!
      module sh_coef_module
!
      integer :: lat
!
      real,dimension(36,0:34,0:35) :: lpmn,pmn,zmn
!
!     Laplacian(Pmn) Basis Set lpmn(lat,m,n)
      data (lpmn(lat, 0, 0), lat = 1,36)/
     |   0.0000000000000d+00, 0.0000000000000d+00, 0.0000000000000d+00,
     |   0.0000000000000d+00, 0.0000000000000d+00, 0.0000000000000d+00,
     |   0.0000000000000d+00, 0.0000000000000d+00, 0.0000000000000d+00,
     |   0.0000000000000d+00, 0.0000000000000d+00, 0.0000000000000d+00,
     |   0.0000000000000d+00, 0.0000000000000d+00, 0.0000000000000d+00,
     |   0.0000000000000d+00, 0.0000000000000d+00, 0.0000000000000d+00,
     |   0.0000000000000d+00, 0.0000000000000d+00, 0.0000000000000d+00,
     |   0.0000000000000d+00, 0.0000000000000d+00, 0.0000000000000d+00,
     |   0.0000000000000d+00, 0.0000000000000d+00, 0.0000000000000d+00,
     |   0.0000000000000d+00, 0.0000000000000d+00, 0.0000000000000d+00,
     |   0.0000000000000d+00, 0.0000000000000d+00, 0.0000000000000d+00,
     |   0.0000000000000d+00, 0.0000000000000d+00, 0.0000000000000d+00/
      data (lpmn(lat, 0, 1), lat = 1,36)/
     |  -2.4471583713105d+00,-2.4285340184702d+00,-2.3914270553604d+00,
     |  -2.3361198883762d+00,-2.2630334384537d+00,-2.1727239376076d+00,
     |  -2.0658786956697d+00,-1.9433108694462d+00,-1.8059532741029d+00,
     |  -1.6548512838793d+00,-1.4911548761589d+00,-1.3161098794470d+00,
     |  -1.1310484918636d+00,-9.3737914231135d-01,-7.3657577148113d-01,
     |  -5.3016661427333d-01,-3.1972256900756d-01,-1.0684524193788d-01,
     |   1.0684524193788d-01, 3.1972256900756d-01, 5.3016661427333d-01,
     |   7.3657577148113d-01, 9.3737914231135d-01, 1.1310484918636d+00,
     |   1.3161098794470d+00, 1.4911548761589d+00, 1.6548512838793d+00,
     |   1.8059532741029d+00, 1.9433108694462d+00, 2.0658786956697d+00,
     |   2.1727239376076d+00, 2.2630334384537d+00, 2.3361198883762d+00,
     |   2.3914270553604d+00, 2.4285340184702d+00, 2.4471583713105d+00/
      data (lpmn(lat, 1, 1), lat = 1,36)/
     |   1.9778588553685d+01, 6.4088003297265d+00, 3.6263489522110d+00,
     |   2.3591380049394d+00, 1.6002062903825d+00, 1.0757623318282d+00,
     |   6.8118075108370d-01, 3.6819656660410d-01, 1.1172318138174d-01,
     |  -1.0237543396049d-01,-2.8252716243651d-01,-4.3395999874994d-01,
     |  -5.6000642417447d-01,-6.6282714807118d-01,-7.4383335575578d-01,
     |  -8.0394220758600d-01,-8.4373456994742d-01,-8.6355182565343d-01,
     |  -8.6355182565343d-01,-8.4373456994742d-01,-8.0394220758600d-01,
     |  -7.4383335575578d-01,-6.6282714807118d-01,-5.6000642417447d-01,
     |  -4.3395999874994d-01,-2.8252716243651d-01,-1.0237543396049d-01,
     |   1.1172318138174d-01, 3.6819656660409d-01, 6.8118075108370d-01,
     |   1.0757623318282d+00, 1.6002062903825d+00, 2.3591380049394d+00,
     |   3.6263489522110d+00, 6.4088003297265d+00, 1.9778588553685d+01/
      data (lpmn(lat, 0, 2), lat = 1,36)/
     |  -9.4597577827721d+00,-9.2443909842969d+00,-8.8202011985372d+00,
     |  -8.2000772174830d+00,-7.4028611945008d+00,-6.4527761350381d+00,
     |  -5.3786898928603d+00,-4.2132380349224d+00,-2.9918322261805d+00,
     |  -1.7515842640721d+00,-5.3017845533020d-01, 6.3527340260778d-01,
     |   1.7093596447855d+00, 2.6594447042482d+00, 3.4566607272305d+00,
     |   4.0767847082847d+00, 4.5009744940443d+00, 4.7163412925196d+00,
     |   4.7163412925196d+00, 4.5009744940443d+00, 4.0767847082847d+00,
     |   3.4566607272305d+00, 2.6594447042482d+00, 1.7093596447855d+00,
     |   6.3527340260779d-01,-5.3017845533020d-01,-1.7515842640721d+00,
     |  -2.9918322261805d+00,-4.2132380349224d+00,-5.3786898928603d+00,
     |  -6.4527761350381d+00,-7.4028611945008d+00,-8.2000772174830d+00,
     |  -8.8202011985372d+00,-9.2443909842969d+00,-9.4597577827721d+00/
      data (lpmn(lat, 1, 2), lat = 1,36)/
     |   4.3846622156973d+01, 1.3205511813190d+01, 6.2797592228524d+00,
     |   2.8095889465885d+00, 5.6718527934079d-01,-1.0388774452538d+00,
     |  -2.2254893991176d+00,-3.0878368756493d+00,-3.6740583878262d+00,
     |  -4.0129005246441d+00,-4.1255996355648d+00,-4.0314911933608d+00,
     |  -3.7507695796289d+00,-3.3057980668666d+00,-2.7216044994431d+00,
     |  -2.0258803661077d+00,-1.2486588117238d+00,-4.2178005789984d-01,
     |   4.2178005789984d-01, 1.2486588117238d+00, 2.0258803661077d+00,
     |   2.7216044994431d+00, 3.3057980668666d+00, 3.7507695796289d+00,
     |   4.0314911933608d+00, 4.1255996355648d+00, 4.0129005246441d+00,
     |   3.6740583878263d+00, 3.0878368756493d+00, 2.2254893991176d+00,
     |   1.0388774452538d+00,-5.6718527934079d-01,-2.8095889465885d+00,
     |  -6.2797592228524d+00,-1.3205511813190d+01,-4.3846622156973d+01/
      data (lpmn(lat, 2, 2), lat = 1,36)/
     |   3.8619299430187d+00, 3.7740068157188d+00, 3.6008320608501d+00,
     |   3.3476675057091d+00, 3.0222054271962d+00, 2.6343348258753d+00,
     |   2.1958409536955d+00, 1.7200472250744d+00, 1.2214103916929d+00,
     |   7.1508128141084d-01, 2.1644444802933d-01,-2.5934928059179d-01,
     |  -6.9784315277160d-01,-1.0857137540925d+00,-1.4111758326054d+00,
     |  -1.6643403877464d+00,-1.8375151426150d+00,-1.9254382699152d+00,
     |  -1.9254382699152d+00,-1.8375151426150d+00,-1.6643403877464d+00,
     |  -1.4111758326054d+00,-1.0857137540925d+00,-6.9784315277159d-01,
     |  -2.5934928059179d-01, 2.1644444802933d-01, 7.1508128141084d-01,
     |   1.2214103916929d+00, 1.7200472250744d+00, 2.1958409536955d+00,
     |   2.6343348258753d+00, 3.0222054271962d+00, 3.3476675057091d+00,
     |   3.6008320608501d+00, 3.7740068157188d+00, 3.8619299430187d+00/
      data (lpmn(lat, 0, 3), lat = 1,36)/
     |  -2.2321892564825d+01,-2.1309858265474d+01,-1.9350883072700d+01,
     |  -1.6570747281858d+01,-1.3147405117091d+01,-9.2989450235757d+00,
     |  -5.2688430322988d+00,-1.3095132754074d+00, 2.3347244310284d+00,
     |   5.4441004933804d+00, 7.8381549702375d+00, 9.3877963501853d+00,
     |   1.0023839712796d+01, 9.7414443840270d+00, 8.6001507766722d+00,
     |   6.7195161354913d+00, 4.2706489377460d+00, 1.4642212857090d+00,
     |  -1.4642212857090d+00,-4.2706489377460d+00,-6.7195161354913d+00,
     |  -8.6001507766722d+00,-9.7414443840270d+00,-1.0023839712796d+01,
     |  -9.3877963501853d+00,-7.8381549702375d+00,-5.4441004933804d+00,
     |  -2.3347244310284d+00, 1.3095132754074d+00, 5.2688430322988d+00,
     |   9.2989450235757d+00, 1.3147405117091d+01, 1.6570747281858d+01,
     |   1.9350883072700d+01, 2.1309858265474d+01, 2.2321892564825d+01/
      data (lpmn(lat, 1, 3), lat = 1,36)/
     |   7.2418627450367d+01, 1.9329399916453d+01, 6.1712585279395d+00,
     |  -8.1325875860535d-01,-5.2389957259254d+00,-8.0222979184505d+00,
     |  -9.4986870047281d+00,-9.8487540094783d+00,-9.2223150343152d+00,
     |  -7.7803506148232d+00,-5.7072550219227d+00,-3.2098041463784d+00,
     |  -5.0927766216197d-01, 2.1700630828930d+00, 4.6141272460283d+00,
     |   6.6322686016525d+00, 8.0694537265771d+00, 8.8163169264303d+00,
     |   8.8163169264303d+00, 8.0694537265771d+00, 6.6322686016526d+00,
     |   4.6141272460283d+00, 2.1700630828930d+00,-5.0927766216198d-01,
     |  -3.2098041463784d+00,-5.7072550219227d+00,-7.7803506148232d+00,
     |  -9.2223150343152d+00,-9.8487540094783d+00,-9.4986870047281d+00,
     |  -8.0222979184505d+00,-5.2389957259254d+00,-8.1325875860537d-01,
     |   6.1712585279395d+00, 1.9329399916453d+01, 7.2418627450367d+01/
      data (lpmn(lat, 2, 3), lat = 1,36)/
     |   1.0178764496087d+01, 9.6400327329060d+00, 8.5981037429706d+00,
     |   7.1216339531952d+00, 5.3077407386254d+00, 3.2754106831228d+00,
     |   1.1574260564087d+00,-9.0864056330166d-01,-2.7897501506629d+00,
     |  -4.3664045646299d+00,-5.5407239646738d+00,-6.2430443529210d+00,
     |  -6.4365861847284d+00,-6.1198764898923d+00,-5.3267600828407d+00,
     |  -4.1239997764939d+00,-2.6066298514584d+00,-8.9138017031681d-01,
     |   8.9138017031680d-01, 2.6066298514584d+00, 4.1239997764939d+00,
     |   5.3267600828407d+00, 6.1198764898923d+00, 6.4365861847284d+00,
     |   6.2430443529210d+00, 5.5407239646738d+00, 4.3664045646299d+00,
     |   2.7897501506629d+00, 9.0864056330167d-01,-1.1574260564087d+00,
     |  -3.2754106831228d+00,-5.3077407386254d+00,-7.1216339531952d+00,
     |  -8.5981037429706d+00,-9.6400327329060d+00,-1.0178764496087d+01/
      data (lpmn(lat, 3, 3), lat = 1,36)/
     |   4.0952267792329d-01, 1.2006597400377d+00, 1.9099738250526d+00,
     |   2.4891263502711d+00, 2.8986490281944d+00, 3.1106335650903d+00,
     |   3.1106335650903d+00, 2.8986490281944d+00, 2.4891263502711d+00,
     |   1.9099738250526d+00, 1.2006597400377d+00, 4.0952267792333d-01,
     |  -4.0952267792333d-01,-1.2006597400377d+00,-1.9099738250526d+00,
     |  -2.4891263502711d+00,-2.8986490281944d+00,-3.1106335650903d+00,
     |  -3.1106335650903d+00,-2.8986490281944d+00,-2.4891263502711d+00,
     |  -1.9099738250526d+00,-1.2006597400377d+00,-4.0952267792332d-01,
     |   4.0952267792332d-01, 1.2006597400377d+00, 1.9099738250526d+00,
     |   2.4891263502711d+00, 2.8986490281944d+00, 3.1106335650903d+00,
     |   3.1106335650903d+00, 2.8986490281944d+00, 2.4891263502711d+00,
     |   1.9099738250526d+00, 1.2006597400377d+00, 4.0952267792329d-01/
      data (lpmn(lat, 0, 4), lat = 1,36)/
     |  -4.2023465596814d+01,-3.8866172173009d+01,-3.2896190990921d+01,
     |  -2.4762269090765d+01,-1.5341213466261d+01,-5.6353032107368d+00,
     |   3.3445274186627d+00, 1.0695768919528d+01, 1.5727705355810d+01,
     |   1.8038770982668d+01, 1.7558745240486d+01, 1.4550886371042d+01,
     |   9.5739388269872d+00, 3.4087865337385d+00,-3.0412203905313d+00,
     |  -8.8640766638294d+00,-1.3253195852051d+01,-1.5607864606710d+01,
     |  -1.5607864606710d+01,-1.3253195852051d+01,-8.8640766638294d+00,
     |  -3.0412203905313d+00, 3.4087865337385d+00, 9.5739388269872d+00,
     |   1.4550886371042d+01, 1.7558745240486d+01, 1.8038770982668d+01,
     |   1.5727705355810d+01, 1.0695768919528d+01, 3.3445274186627d+00,
     |  -5.6353032107368d+00,-1.5341213466261d+01,-2.4762269090765d+01,
     |  -3.2896190990921d+01,-3.8866172173009d+01,-4.2023465596814d+01/
      data (lpmn(lat, 1, 4), lat = 1,36)/
     |   1.0415996558931d+02, 2.3044767872899d+01, 1.2389816149334d+00,
     |  -1.0238239203383d+01,-1.6428293400384d+01,-1.8645759190886d+01,
     |  -1.7586989382758d+01,-1.3930783395535d+01,-8.4684974005735d+00,
     |  -2.0912384814649d+00, 4.2796745134644d+00, 9.7838213796681d+00,
     |   1.3713331732967d+01, 1.5589767908821d+01, 1.5215002075753d+01,
     |   1.2688996267395d+01, 8.3918723315887d+00, 2.9322176922455d+00,
     |  -2.9322176922455d+00,-8.3918723315887d+00,-1.2688996267395d+01,
     |  -1.5215002075753d+01,-1.5589767908821d+01,-1.3713331732967d+01,
     |  -9.7838213796681d+00,-4.2796745134644d+00, 2.0912384814648d+00,
     |   8.4684974005735d+00, 1.3930783395535d+01, 1.7586989382758d+01,
     |   1.8645759190886d+01, 1.6428293400384d+01, 1.0238239203383d+01,
     |  -1.2389816149333d+00,-2.3044767872899d+01,-1.0415996558931d+02/
      data (lpmn(lat, 2, 4), lat = 1,36)/
     |   1.9888914415350d+01, 1.8044354046857d+01, 1.4568553896129d+01,
     |   9.8627038654253d+00, 4.4680219740323d+00,-9.9872307224652d-01,
     |  -5.9185729651126d+00,-9.7438074077558d+00,-1.2062619113782d+01,
     |  -1.2647277610022d+01,-1.1480018343918d+01,-8.7535824504676d+00,
     |  -4.8463907781656d+00,-2.7539451622023d-01, 4.3676649006110d+00,
     |   8.4888564350752d+00, 1.1564726620442d+01, 1.3206237224077d+01,
     |   1.3206237224077d+01, 1.1564726620442d+01, 8.4888564350752d+00,
     |   4.3676649006110d+00,-2.7539451622023d-01,-4.8463907781656d+00,
     |  -8.7535824504676d+00,-1.1480018343918d+01,-1.2647277610022d+01,
     |  -1.2062619113782d+01,-9.7438074077558d+00,-5.9185729651126d+00,
     |  -9.9872307224652d-01, 4.4680219740323d+00, 9.8627038654253d+00,
     |   1.4568553896129d+01, 1.8044354046857d+01, 1.9888914415350d+01/
      data (lpmn(lat, 3, 4), lat = 1,36)/
     |   1.2253175974352d+00, 3.5158247197354d+00, 5.3456362770924d+00,
     |   6.4708646038993d+00, 6.7344227894258d+00, 6.0856209264240d+00,
     |   4.5868543563392d+00, 2.4065597604042d+00,-2.0072594599970d-01,
     |  -2.9248101135198d+00,-5.4371279883528d+00,-7.4303724706521d+00,
     |  -8.6556900680875d+00,-8.9529527080881d+00,-8.2704463906122d+00,
     |  -6.6715905498990d+00,-4.3278630290216d+00,-1.4987665700848d+00,
     |   1.4987665700848d+00, 4.3278630290216d+00, 6.6715905498990d+00,
     |   8.2704463906122d+00, 8.9529527080881d+00, 8.6556900680875d+00,
     |   7.4303724706522d+00, 5.4371279883528d+00, 2.9248101135198d+00,
     |   2.0072594599970d-01,-2.4065597604042d+00,-4.5868543563392d+00,
     |  -6.0856209264240d+00,-6.7344227894258d+00,-6.4708646038993d+00,
     |  -5.3456362770924d+00,-3.5158247197354d+00,-1.2253175974352d+00/
      data (lpmn(lat, 4, 4), lat = 1,36)/
     |   3.3688391959646d-02, 2.9593873872477d-01, 7.8274899142926d-01,
     |   1.4234683969127d+00, 2.1233700294170d+00, 2.7756063652916d+00,
     |   3.2747781668042d+00, 3.5304593605169d+00, 3.4790219327698d+00,
     |   3.0923066870320d+00, 2.3820637703578d+00, 1.3995956511146d+00,
     |   2.3061339592254d-01,-1.0141050700858d+00,-2.2111582394645d+00,
     |  -3.2385928906857d+00,-3.9899319509371d+00,-4.3864870930991d+00,
     |  -4.3864870930991d+00,-3.9899319509372d+00,-3.2385928906857d+00,
     |  -2.2111582394645d+00,-1.0141050700858d+00, 2.3061339592254d-01,
     |   1.3995956511146d+00, 2.3820637703578d+00, 3.0923066870320d+00,
     |   3.4790219327698d+00, 3.5304593605169d+00, 3.2747781668042d+00,
     |   2.7756063652916d+00, 2.1233700294170d+00, 1.4234683969127d+00,
     |   7.8274899142926d-01, 2.9593873872477d-01, 3.3688391959646d-02/
      data (lpmn(lat, 0, 5), lat = 1,36)/
     |  -6.9355125001686d+01,-6.1594900654781d+01,-4.7351071638193d+01,
     |  -2.8948392235379d+01,-9.3448746472029d+00, 8.3931310039037d+00,
     |   2.1629508511340d+01, 2.8612092860116d+01, 2.8759205995156d+01,
     |   2.2728107267731d+01, 1.2255226879016d+01,-1.9946183809951d-01,
     |  -1.1935315121522d+01,-2.0529251649703d+01,-2.4291504754388d+01,
     |  -2.2573480137275d+01,-1.5870737558514d+01,-5.7031757748787d+00,
     |   5.7031757748787d+00, 1.5870737558514d+01, 2.2573480137275d+01,
     |   2.4291504754388d+01, 2.0529251649703d+01, 1.1935315121522d+01,
     |   1.9946183809958d-01,-1.2255226879016d+01,-2.2728107267731d+01,
     |  -2.8759205995156d+01,-2.8612092860116d+01,-2.1629508511340d+01,
     |  -8.3931310039037d+00, 9.3448746472029d+00, 2.8948392235379d+01,
     |   4.7351071638193d+01, 6.1594900654781d+01, 6.9355125001686d+01/
      data (lpmn(lat, 1, 5), lat = 1,36)/
     |   1.3791448234938d+02, 2.2639860660190d+01,-1.0126271051225d+01,
     |  -2.5788898140317d+01,-3.0966620741446d+01,-2.8003969421194d+01,
     |  -1.9079675799000d+01,-6.7722983642087d+00, 6.1098019539777d+00,
     |   1.6921059534849d+01, 2.3600272224814d+01, 2.5004397592408d+01,
     |   2.1078702450345d+01, 1.2826794291971d+01, 2.0851342262234d+00,
     |  -8.8551693778794d+00,-1.7707223326076d+01,-2.2640530077228d+01,
     |  -2.2640530077228d+01,-1.7707223326076d+01,-8.8551693778794d+00,
     |   2.0851342262234d+00, 1.2826794291971d+01, 2.1078702450345d+01,
     |   2.5004397592408d+01, 2.3600272224814d+01, 1.6921059534849d+01,
     |   6.1098019539777d+00,-6.7722983642087d+00,-1.9079675799000d+01,
     |  -2.8003969421194d+01,-3.0966620741446d+01,-2.5788898140317d+01,
     |  -1.0126271051225d+01, 2.2639860660190d+01, 1.3791448234938d+02/
      data (lpmn(lat, 2, 5), lat = 1,36)/
     |   3.3372921814242d+01, 2.8638058386597d+01, 2.0009810599707d+01,
     |   9.0161356179473d+00,-2.4096677070141d+00,-1.2283896371769d+01,
     |  -1.8935161888201d+01,-2.1307522218005d+01,-1.9147894143853d+01,
     |  -1.3043321204603d+01,-4.3017838647828d+00, 5.3005123476586d+00,
     |   1.3857524534717d+01, 1.9693678236411d+01, 2.1678392893539d+01,
     |   1.9435885614350d+01, 1.3411113726572d+01, 4.7798404122343d+00,
     |  -4.7798404122343d+00,-1.3411113726572d+01,-1.9435885614350d+01,
     |  -2.1678392893539d+01,-1.9693678236411d+01,-1.3857524534717d+01,
     |  -5.3005123476586d+00, 4.3017838647828d+00, 1.3043321204603d+01,
     |   1.9147894143852d+01, 2.1307522218005d+01, 1.8935161888201d+01,
     |   1.2283896371769d+01, 2.4096677070142d+00,-9.0161356179473d+00,
     |  -2.0009810599707d+01,-2.8638058386597d+01,-3.3372921814242d+01/
      data (lpmn(lat, 3, 5), lat = 1,36)/
     |   2.7003105022862d+00, 7.5392649289054d+00, 1.0802261039738d+01,
     |   1.1781440143126d+01, 1.0214589427040d+01, 6.3396418687680d+00,
     |   8.5388514935864d-01,-5.2147353575480d+00,-1.0700237539444d+01,
     |  -1.4519053274396d+01,-1.5876866070330d+01,-1.4422818917334d+01,
     |  -1.0321830565927d+01,-4.2310214747527d+00, 2.8158326317258d+00,
     |   9.5946850808062d+00, 1.4914014395736d+01, 1.7832731551182d+01,
     |   1.7832731551182d+01, 1.4914014395736d+01, 9.5946850808062d+00,
     |   2.8158326317258d+00,-4.2310214747527d+00,-1.0321830565927d+01,
     |  -1.4422818917334d+01,-1.5876866070330d+01,-1.4519053274396d+01,
     |  -1.0700237539444d+01,-5.2147353575481d+00, 8.5388514935862d-01,
     |   6.3396418687680d+00, 1.0214589427040d+01, 1.1781440143126d+01,
     |   1.0802261039738d+01, 7.5392649289054d+00, 2.7003105022862d+00/
      data (lpmn(lat, 4, 5), lat = 1,36)/
     |   1.1149235547344d-01, 9.6253329885752d-01, 2.4557228307341d+00,
     |   4.2157112352710d+00, 5.7773860137537d+00, 6.6820224155256d+00,
     |   6.5742614882802d+00, 5.2809947376524d+00, 2.8565385010719d+00,
     |  -4.1523158930546d-01,-4.0630212842099d+00,-7.5073860137935d+00,
     |  -1.0162884854879d+01,-1.1544410863106d+01,-1.1357997486168d+01,
     |  -9.5590860740884d+00,-6.3671131397575d+00,-2.2332526127212d+00,
     |   2.2332526127212d+00, 6.3671131397575d+00, 9.5590860740883d+00,
     |   1.1357997486168d+01, 1.1544410863106d+01, 1.0162884854879d+01,
     |   7.5073860137935d+00, 4.0630212842099d+00, 4.1523158930547d-01,
     |  -2.8565385010719d+00,-5.2809947376524d+00,-6.5742614882802d+00,
     |  -6.6820224155256d+00,-5.7773860137536d+00,-4.2157112352710d+00,
     |  -2.4557228307342d+00,-9.6253329885752d-01,-1.1149235547343d-01/
      data (lpmn(lat, 5, 5), lat = 1,36)/
     |   2.4083390282354d-03, 6.3356867583758d-02, 2.7832666586284d-01,
     |   7.0504060755114d-01, 1.3435597835948d+00, 2.1308187804730d+00,
     |   2.9485871093147d+00, 3.6436277212789d+00, 4.0564112439822d+00,
     |   4.0530053382657d+00, 3.5540275798724d+00, 2.5549737636814d+00,
     |   1.1337407912504d+00,-5.5652068422403d-01,-2.3083922107530d+00,
     |  -3.8916052139685d+00,-5.0895108720874d+00,-5.7342234567741d+00,
     |  -5.7342234567741d+00,-5.0895108720874d+00,-3.8916052139685d+00,
     |  -2.3083922107530d+00,-5.5652068422403d-01, 1.1337407912504d+00,
     |   2.5549737636814d+00, 3.5540275798724d+00, 4.0530053382657d+00,
     |   4.0564112439822d+00, 3.6436277212789d+00, 2.9485871093147d+00,
     |   2.1308187804730d+00, 1.3435597835948d+00, 7.0504060755115d-01,
     |   2.7832666586284d-01, 6.3356867583758d-02, 2.4083390282354d-03/
      data (lpmn(lat, 0, 6), lat = 1,36)/
     |  -1.0494934225757d+02,-8.8650683451432d+01,-5.9801498775439d+01,
     |  -2.4954166978455d+01, 8.1764027062604d+00, 3.2625313899084d+01,
     |   4.3865997757499d+01, 4.0841774144766d+01, 2.6084214475561d+01,
     |   4.9043060781783d+00,-1.6113457203831d+01,-3.0903015095704d+01,
     |  -3.5513723230859d+01,-2.9090349929981d+01,-1.3985318137211d+01,
     |   5.0106216662038d+00, 2.2094472063057d+01, 3.2132927256391d+01,
     |   3.2132927256391d+01, 2.2094472063057d+01, 5.0106216662039d+00,
     |  -1.3985318137211d+01,-2.9090349929981d+01,-3.5513723230860d+01,
     |  -3.0903015095704d+01,-1.6113457203831d+01, 4.9043060781783d+00,
     |   2.6084214475561d+01, 4.0841774144766d+01, 4.3865997757499d+01,
     |   3.2625313899084d+01, 8.1764027062604d+00,-2.4954166978455d+01,
     |  -5.9801498775439d+01,-8.8650683451432d+01,-1.0494934225757d+02/
      data (lpmn(lat, 1, 6), lat = 1,36)/
     |   1.7260764535807d+02, 1.6502042523122d+01,-2.8780589240327d+01,
     |  -4.5950446305834d+01,-4.4118256175568d+01,-2.8791910821615d+01,
     |  -6.4456074762896d+00, 1.5859944785774d+01, 3.1873804839813d+01,
     |   3.7556271504025d+01, 3.1957003412186d+01, 1.7294786469155d+01,
     |  -1.7881605237968d+00,-1.9592356082185d+01,-3.0974246462016d+01,
     |  -3.2768597784345d+01,-2.4637250935482d+01,-9.1197962682248d+00,
     |   9.1197962682248d+00, 2.4637250935482d+01, 3.2768597784345d+01,
     |   3.0974246462016d+01, 1.9592356082185d+01, 1.7881605237967d+00,
     |  -1.7294786469155d+01,-3.1957003412186d+01,-3.7556271504025d+01,
     |  -3.1873804839814d+01,-1.5859944785774d+01, 6.4456074762895d+00,
     |   2.8791910821615d+01, 4.4118256175568d+01, 4.5950446305834d+01,
     |   2.8780589240327d+01,-1.6502042523122d+01,-1.7260764535807d+02/
      data (lpmn(lat, 2, 6), lat = 1,36)/
     |   5.0913675310246d+01, 4.0735418664787d+01, 2.2937801047268d+01,
     |   1.9691943878961d+00,-1.6993855973093d+01,-2.9392098716691d+01,
     |  -3.2457350997336d+01,-2.5905384220153d+01,-1.1967608753329d+01,
     |   5.2421851460676d+00, 2.0852754216884d+01, 3.0548544605607d+01,
     |   3.1718954418602d+01, 2.4137328890538d+01, 9.9908957450815d+00,
     |  -6.7420488206497d+00,-2.1395842826629d+01,-2.9901305868098d+01,
     |  -2.9901305868098d+01,-2.1395842826629d+01,-6.7420488206497d+00,
     |   9.9908957450815d+00, 2.4137328890538d+01, 3.1718954418602d+01,
     |   3.0548544605607d+01, 2.0852754216884d+01, 5.2421851460676d+00,
     |  -1.1967608753329d+01,-2.5905384220153d+01,-3.2457350997336d+01,
     |  -2.9392098716691d+01,-1.6993855973093d+01, 1.9691943878961d+00,
     |   2.2937801047268d+01, 4.0735418664787d+01, 5.0913675310246d+01/
      data (lpmn(lat, 3, 6), lat = 1,36)/
     |   5.0642932961750d+00, 1.3675902861160d+01, 1.8160637055957d+01,
     |   1.7065070661362d+01, 1.0508834997039d+01, 1.7056873356895d-01,
     |  -1.1155080908889d+01,-2.0311444631419d+01,-2.4642085371612d+01,
     |  -2.2728246602079d+01,-1.4800765523676d+01,-2.7122306922918d+00,
     |   1.0527257719699d+01, 2.1530193212525d+01, 2.7421759647492d+01,
     |   2.6603487272553d+01, 1.9186581968903d+01, 6.9781320657091d+00,
     |  -6.9781320657091d+00,-1.9186581968903d+01,-2.6603487272553d+01,
     |  -2.7421759647492d+01,-2.1530193212525d+01,-1.0527257719699d+01,
     |   2.7122306922917d+00, 1.4800765523676d+01, 2.2728246602079d+01,
     |   2.4642085371612d+01, 2.0311444631419d+01, 1.1155080908889d+01,
     |  -1.7056873356895d-01,-1.0508834997039d+01,-1.7065070661362d+01,
     |  -1.8160637055957d+01,-1.3675902861160d+01,-5.0642932961750d+00/
      data (lpmn(lat, 4, 6), lat = 1,36)/
     |   2.7032529364526d-01, 2.2851812491272d+00, 5.5759987313634d+00,
     |   8.8861451198836d+00, 1.0821534133177d+01, 1.0282936353236d+01,
     |   6.8274633895585d+00, 8.5438536988263d-01,-6.4424948697024d+00,
     |  -1.3350182686112d+01,-1.8071004991702d+01,-1.9202677748792d+01,
     |  -1.6135343047493d+01,-9.2564776308521d+00, 9.6374579022747d-02,
     |   9.9293286325191d+00, 1.8061551377341d+01, 2.2652465266819d+01,
     |   2.2652465266819d+01, 1.8061551377341d+01, 9.9293286325191d+00,
     |   9.6374579022755d-02,-9.2564776308521d+00,-1.6135343047494d+01,
     |  -1.9202677748792d+01,-1.8071004991702d+01,-1.3350182686112d+01,
     |  -6.4424948697024d+00, 8.5438536988260d-01, 6.8274633895585d+00,
     |   1.0282936353236d+01, 1.0821534133177d+01, 8.8861451198837d+00,
     |   5.5759987313634d+00, 2.2851812491272d+00, 2.7032529364526d-01/
      data (lpmn(lat, 5, 6), lat = 1,36)/
     |   8.6671843085609d-03, 2.2459134731785d-01, 9.5639097681657d-01,
     |   2.3063701519610d+00, 4.0938463642059d+00, 5.8774860124952d+00,
     |   7.0652699139110d+00, 7.0837374964224d+00, 5.5599763893313d+00,
     |   2.4642506862474d+00,-1.8300494049921d+00,-6.5914439320396d+00,
     |  -1.0874953536539d+01,-1.3733727438623d+01,-1.4446069397073d+01,
     |  -1.2700322869134d+01,-8.6891955540966d+00,-3.0870585187754d+00,
     |   3.0870585187754d+00, 8.6891955540966d+00, 1.2700322869134d+01,
     |   1.4446069397073d+01, 1.3733727438623d+01, 1.0874953536539d+01,
     |   6.5914439320396d+00, 1.8300494049921d+00,-2.4642506862474d+00,
     |  -5.5599763893313d+00,-7.0837374964224d+00,-7.0652699139110d+00,
     |  -5.8774860124952d+00,-4.0938463642059d+00,-2.3063701519610d+00,
     |  -9.5639097681658d-01,-2.2459134731785d-01,-8.6671843085609d-03/
      data (lpmn(lat, 6, 6), lat = 1,36)/
     |   1.5745930723068d-04, 1.2401854245385d-02, 9.0438443685931d-02,
     |   3.1883453321756d-01, 7.7518372333167d-01, 1.4887568188576d+00,
     |   2.4094719011357d+00, 3.3984438021296d+00, 4.2455814073939d+00,
     |   4.7120845972252d+00, 4.5883359019990d+00, 3.7526384186069d+00,
     |   2.2149830896125d+00, 1.3300050026197d-01,-2.2062059945004d+00,
     |  -4.4361803162413d+00,-6.1828131111868d+00,-7.1414550167391d+00,
     |  -7.1414550167391d+00,-6.1828131111868d+00,-4.4361803162413d+00,
     |  -2.2062059945004d+00, 1.3300050026197d-01, 2.2149830896125d+00,
     |   3.7526384186069d+00, 4.5883359019990d+00, 4.7120845972252d+00,
     |   4.2455814073939d+00, 3.3984438021296d+00, 2.4094719011357d+00,
     |   1.4887568188576d+00, 7.7518372333167d-01, 3.1883453321756d-01,
     |   9.0438443685932d-02, 1.2401854245385d-02, 1.5745930723068d-04/
      data (lpmn(lat, 0, 7), lat = 1,36)/
     |  -1.4930142980579d+02,-1.1869694472339d+02,-6.6822271953742d+01,
     |  -9.2153563062973d+00, 3.7552516193038d+01, 6.1291864535223d+01,
     |   5.7992037113975d+01, 3.2725756028052d+01,-2.5811529221552d+00,
     |  -3.3652236548121d+01,-4.8988823203318d+01,-4.3792035727510d+01,
     |  -2.1317490866557d+01, 8.7462426214644d+00, 3.4200254401461d+01,
     |   4.5060838172796d+01, 3.7323621819769d+01, 1.4383901755708d+01,
     |  -1.4383901755708d+01,-3.7323621819769d+01,-4.5060838172796d+01,
     |  -3.4200254401461d+01,-8.7462426214645d+00, 2.1317490866557d+01,
     |   4.3792035727510d+01, 4.8988823203318d+01, 3.3652236548121d+01,
     |   2.5811529221552d+00,-3.2725756028052d+01,-5.7992037113974d+01,
     |  -6.1291864535223d+01,-3.7552516193038d+01, 9.2153563062970d+00,
     |   6.6822271953741d+01, 1.1869694472339d+02, 1.4930142980579d+02/
      data (lpmn(lat, 1, 7), lat = 1,36)/
     |   2.0720110019596d+02, 3.2034249264881d+00,-5.4587640934944d+01,
     |  -6.7281528591840d+01,-4.9329517493556d+01,-1.4180179568077d+01,
     |   2.2728869054799d+01, 4.7579088724973d+01, 5.2234337048762d+01,
     |   3.6516398585443d+01, 7.7263921297428d+00,-2.2415496517527d+01,
     |  -4.2277130340937d+01,-4.4619647204477d+01,-2.9148922835258d+01,
     |  -2.4224457667524d+00, 2.4800737715229d+01, 4.1742521012951d+01,
     |   4.1742521012951d+01, 2.4800737715229d+01,-2.4224457667523d+00,
     |  -2.9148922835258d+01,-4.4619647204477d+01,-4.2277130340937d+01,
     |  -2.2415496517527d+01, 7.7263921297428d+00, 3.6516398585443d+01,
     |   5.2234337048762d+01, 4.7579088724973d+01, 2.2728869054799d+01,
     |  -1.4180179568077d+01,-4.9329517493556d+01,-6.7281528591840d+01,
     |  -5.4587640934944d+01, 3.2034249264881d+00, 2.0720110019596d+02/
      data (lpmn(lat, 2, 7), lat = 1,36)/
     |   7.2713835926682d+01, 5.3346376300508d+01, 2.1119944151542d+01,
     |  -1.3231174380251d+01,-3.8498786909544d+01,-4.6886963007318d+01,
     |  -3.6654954543298d+01,-1.2589955080522d+01, 1.5836508897229d+01,
     |   3.7945514004864d+01, 4.5698490235879d+01, 3.6531063058950d+01,
     |   1.4165319664831d+01,-1.2869114088061d+01,-3.4443917301334d+01,
     |  -4.2586716757931d+01,-3.4407251551477d+01,-1.3130661168696d+01,
     |   1.3130661168696d+01, 3.4407251551477d+01, 4.2586716757931d+01,
     |   3.4443917301334d+01, 1.2869114088061d+01,-1.4165319664831d+01,
     |  -3.6531063058950d+01,-4.5698490235879d+01,-3.7945514004864d+01,
     |  -1.5836508897229d+01, 1.2589955080521d+01, 3.6654954543298d+01,
     |   4.6886963007318d+01, 3.8498786909544d+01, 1.3231174380251d+01,
     |  -2.1119944151542d+01,-5.3346376300508d+01,-7.2713835926681d+01/
      data (lpmn(lat, 3, 7), lat = 1,36)/
     |   8.5612996822003d+00, 2.2219563696673d+01, 2.6794652689596d+01,
     |   2.0113642660826d+01, 4.3115689245302d+00,-1.4905199938281d+01,
     |  -3.0333327859835d+01,-3.5931553573335d+01,-2.9092168801131d+01,
     |  -1.1687161948898d+01, 1.0508221741235d+01, 2.9824042386649d+01,
     |   3.9423744448051d+01, 3.5772227169408d+01, 1.9950498151674d+01,
     |  -2.6669960014637d+00,-2.4270052130763d+01,-3.7351078655642d+01,
     |  -3.7351078655642d+01,-2.4270052130763d+01,-2.6669960014638d+00,
     |   1.9950498151674d+01, 3.5772227169408d+01, 3.9423744448051d+01,
     |   2.9824042386650d+01, 1.0508221741235d+01,-1.1687161948897d+01,
     |  -2.9092168801131d+01,-3.5931553573335d+01,-3.0333327859835d+01,
     |  -1.4905199938281d+01, 4.3115689245301d+00, 2.0113642660826d+01,
     |   2.6794652689596d+01, 2.2219563696673d+01, 8.5612996822003d+00/
      data (lpmn(lat, 4, 7), lat = 1,36)/
     |   5.5435746858547d-01, 4.5714862455877d+00, 1.0568536477123d+01,
     |   1.5309570219019d+01, 1.5715043046221d+01, 1.0209765607406d+01,
     |  -4.6638306446339d-01,-1.3321741677438d+01,-2.4063722590868d+01,
     |  -2.8616009256892d+01,-2.4658130177913d+01,-1.2616681071131d+01,
     |   4.2801569276431d+00, 2.0944633700413d+01, 3.2070069780911d+01,
     |   3.3914163405744d+01, 2.5605032515729d+01, 9.5056419018866d+00,
     |  -9.5056419018866d+00,-2.5605032515729d+01,-3.3914163405744d+01,
     |  -3.2070069780911d+01,-2.0944633700413d+01,-4.2801569276430d+00,
     |   1.2616681071131d+01, 2.4658130177913d+01, 2.8616009256892d+01,
     |   2.4063722590868d+01, 1.3321741677438d+01, 4.6638306446342d-01,
     |  -1.0209765607406d+01,-1.5715043046221d+01,-1.5309570219019d+01,
     |  -1.0568536477123d+01,-4.5714862455877d+00,-5.5435746858546d-01/
      data (lpmn(lat, 5, 7), lat = 1,36)/
     |   2.2755196985791d-02, 5.7929096018957d-01, 2.3770494763416d+00,
     |   5.3969458607594d+00, 8.7424163570366d+00, 1.0913284751790d+01,
     |   1.0393019310756d+01, 6.3292674189598d+00,-9.6287275336665d-01,
     |  -9.8934109303211d+00,-1.7966546604965d+01,-2.2532044182241d+01,
     |  -2.1676428398921d+01,-1.4945431958365d+01,-3.6319809164156d+00,
     |   9.4962963817165d+00, 2.0966767636654d+01, 2.7632508286521d+01,
     |   2.7632508286521d+01, 2.0966767636654d+01, 9.4962963817166d+00,
     |  -3.6319809164156d+00,-1.4945431958365d+01,-2.1676428398921d+01,
     |  -2.2532044182241d+01,-1.7966546604965d+01,-9.8934109303211d+00,
     |  -9.6287275336666d-01, 6.3292674189597d+00, 1.0393019310756d+01,
     |   1.0913284751790d+01, 8.7424163570366d+00, 5.3969458607594d+00,
     |   2.3770494763416d+00, 5.7929096018957d-01, 2.2755196985791d-02/
      data (lpmn(lat, 6, 7), lat = 1,36)/
     |   6.0880504054470d-04, 4.7299338246701d-02, 3.3537382471057d-01,
     |   1.1313912296191d+00, 2.5832195753388d+00, 4.5499622836066d+00,
     |   6.5380590164431d+00, 7.7910498792558d+00, 7.5203507250767d+00,
     |   5.2048930661308d+00, 8.5173703400930d-01,-4.8872629201370d+00,
     |  -1.0804936332401d+01,-1.5427806817808d+01,-1.7426890988526d+01,
     |  -1.6024569735097d+01,-1.1265028121856d+01,-4.0540941077763d+00,
     |   4.0540941077763d+00, 1.1265028121856d+01, 1.6024569735097d+01,
     |   1.7426890988526d+01, 1.5427806817808d+01, 1.0804936332401d+01,
     |   4.8872629201370d+00,-8.5173703400930d-01,-5.2048930661307d+00,
     |  -7.5203507250767d+00,-7.7910498792557d+00,-6.5380590164431d+00,
     |  -4.5499622836066d+00,-2.5832195753388d+00,-1.1313912296191d+00,
     |  -3.3537382471057d-01,-4.7299338246701d-02,-6.0880504054469d-04/
      data (lpmn(lat, 7, 7), lat = 1,36)/
     |   9.6770460184891d-06, 2.2815983149869d-03, 2.7610681721514d-02,
     |   1.3540240569143d-01, 4.1970294367859d-01, 9.7505555033960d-01,
     |   1.8428568715564d+00, 2.9600649783559d+00, 4.1349981913604d+00,
     |   5.0677858265742d+00, 5.4178518491069d+00, 4.9028966917795d+00,
     |   3.3998013584645d+00, 1.0132525387968d+00,-1.9149386473859d+00,
     |  -4.8656460499532d+00,-7.2593837353314d+00,-8.5993036424108d+00,
     |  -8.5993036424108d+00,-7.2593837353315d+00,-4.8656460499532d+00,
     |  -1.9149386473859d+00, 1.0132525387968d+00, 3.3998013584645d+00,
     |   4.9028966917795d+00, 5.4178518491069d+00, 5.0677858265742d+00,
     |   4.1349981913605d+00, 2.9600649783559d+00, 1.8428568715564d+00,
     |   9.7505555033960d-01, 4.1970294367859d-01, 1.3540240569143d-01,
     |   2.7610681721515d-02, 2.2815983149869d-03, 9.6770460184891d-06/
      data (lpmn(lat, 0, 8), lat = 1,36)/
     |  -2.0278145186171d+02,-1.4995399450074d+02,-6.4849259421231d+01,
     |   2.0248577911320d+01, 7.5013619463957d+01, 8.3563670277459d+01,
     |   5.0278627260199d+01,-3.4248299696330d+00,-4.9626587967288d+01,
     |  -6.6759878970147d+01,-4.8896854373396d+01,-7.3775709573901d+00,
     |   3.5655330016520d+01, 5.8488985198786d+01, 5.0382657427721d+01,
     |   1.6435187346770d+01,-2.5396229491827d+01,-5.3507908407932d+01,
     |  -5.3507908407932d+01,-2.5396229491827d+01, 1.6435187346769d+01,
     |   5.0382657427721d+01, 5.8488985198786d+01, 3.5655330016520d+01,
     |  -7.3775709573899d+00,-4.8896854373396d+01,-6.6759878970147d+01,
     |  -4.9626587967288d+01,-3.4248299696332d+00, 5.0278627260199d+01,
     |   8.3563670277459d+01, 7.5013619463957d+01, 2.0248577911320d+01,
     |  -6.4849259421231d+01,-1.4995399450074d+02,-2.0278145186171d+02/
      data (lpmn(lat, 1, 8), lat = 1,36)/
     |   2.4067189511133d+02,-1.8412592194916d+01,-8.6268806333113d+01,
     |  -8.4720508839818d+01,-3.9925568649032d+01, 1.8651421700930d+01,
     |   6.1754074068100d+01, 7.0823277763224d+01, 4.4726488638600d+01,
     |  -1.1951197554762d+00,-4.3333279271916d+01,-6.1352837451871d+01,
     |  -4.7656827135699d+01,-1.0451805778406d+01, 3.0821109798587d+01,
     |   5.5308329890903d+01, 5.1001826449733d+01, 2.0493043558672d+01,
     |  -2.0493043558671d+01,-5.1001826449733d+01,-5.5308329890903d+01,
     |  -3.0821109798587d+01, 1.0451805778406d+01, 4.7656827135699d+01,
     |   6.1352837451871d+01, 4.3333279271916d+01, 1.1951197554763d+00,
     |  -4.4726488638600d+01,-7.0823277763224d+01,-6.1754074068100d+01,
     |  -1.8651421700930d+01, 3.9925568649032d+01, 8.4720508839818d+01,
     |   8.6268806333113d+01, 1.8412592194916d+01,-2.4067189511133d+02/
      data (lpmn(lat, 2, 8), lat = 1,36)/
     |   9.8902212957125d+01, 6.5213443787817d+01, 1.2354589536879d+01,
     |  -3.7181825385859d+01,-6.3015876526243d+01,-5.5891997987994d+01,
     |  -2.1520618498068d+01, 2.2439044947150d+01, 5.4773653642668d+01,
     |   6.0545803601792d+01, 3.7802900149622d+01,-1.8873112720192d+00,
     |  -3.9218427916669d+01,-5.6441302672197d+01,-4.5761443102682d+01,
     |  -1.2895743227224d+01, 2.5836825379427d+01, 5.1451177783194d+01,
     |   5.1451177783194d+01, 2.5836825379427d+01,-1.2895743227224d+01,
     |  -4.5761443102682d+01,-5.6441302672197d+01,-3.9218427916669d+01,
     |  -1.8873112720194d+00, 3.7802900149622d+01, 6.0545803601792d+01,
     |   5.4773653642668d+01, 2.2439044947150d+01,-2.1520618498068d+01,
     |  -5.5891997987994d+01,-6.3015876526243d+01,-3.7181825385859d+01,
     |   1.2354589536879d+01, 6.5213443787817d+01, 9.8902212957125d+01/
      data (lpmn(lat, 3, 8), lat = 1,36)/
     |   1.3446605985596d+01, 3.3313129680879d+01, 3.5535012377010d+01,
     |   1.8159010723272d+01,-1.1022212680786d+01,-3.8079293468408d+01,
     |  -4.9561343294674d+01,-3.8993574869894d+01,-1.0164069567629d+01,
     |   2.4402018649802d+01, 4.9125013519232d+01, 5.2588953202713d+01,
     |   3.2926664357272d+01,-1.1696775384755d+00,-3.4330237963881d+01,
     |  -5.1520324527574d+01,-4.4952923565936d+01,-1.7697732686111d+01,
     |   1.7697732686111d+01, 4.4952923565936d+01, 5.1520324527574d+01,
     |   3.4330237963881d+01, 1.1696775384755d+00,-3.2926664357272d+01,
     |  -5.2588953202713d+01,-4.9125013519232d+01,-2.4402018649802d+01,
     |   1.0164069567629d+01, 3.8993574869894d+01, 4.9561343294675d+01,
     |   3.8079293468408d+01, 1.1022212680786d+01,-1.8159010723272d+01,
     |  -3.5535012377011d+01,-3.3313129680879d+01,-1.3446605985596d+01/
      data (lpmn(lat, 4, 8), lat = 1,36)/
     |   1.0186726004254d+00, 8.1630475625802d+00, 1.7691759656526d+01,
     |   2.2649018433777d+01, 1.7726360984962d+01, 2.4374383855082d+00,
     |  -1.8034256264623d+01,-3.4863973772730d+01,-3.9634048376344d+01,
     |  -2.8517173457278d+01,-4.5623360814977d+00, 2.3124290507996d+01,
     |   4.3083952413198d+01, 4.6507458297261d+01, 3.1283046189887d+01,
     |   3.2051708451486d+00,-2.6292783698859d+01,-4.4952324350789d+01,
     |  -4.4952324350789d+01,-2.6292783698859d+01, 3.2051708451485d+00,
     |   3.1283046189887d+01, 4.6507458297261d+01, 4.3083952413198d+01,
     |   2.3124290507996d+01,-4.5623360814977d+00,-2.8517173457278d+01,
     |  -3.9634048376344d+01,-3.4863973772730d+01,-1.8034256264623d+01,
     |   2.4374383855082d+00, 1.7726360984962d+01, 2.2649018433777d+01,
     |   1.7691759656526d+01, 8.1630475625802d+00, 1.0186726004254d+00/
      data (lpmn(lat, 5, 8), lat = 1,36)/
     |   5.0302257739312d-02, 1.2547163645770d+00, 4.9297644476761d+00,
     |   1.0402103643260d+01, 1.4955868599657d+01, 1.5116492189003d+01,
     |   8.6185887292668d+00,-3.9535867943676d+00,-1.8776457310489d+01,
     |  -3.0009598251119d+01,-3.2212514124318d+01,-2.2912546251258d+01,
     |  -4.1196766947543d+00, 1.8013272283366d+01, 3.5384311887708d+01,
     |   4.1145113632754d+01, 3.2571047378236d+01, 1.2345268354506d+01,
     |  -1.2345268354506d+01,-3.2571047378236d+01,-4.1145113632754d+01,
     |  -3.5384311887708d+01,-1.8013272283366d+01, 4.1196766947544d+00,
     |   2.2912546251257d+01, 3.2212514124318d+01, 3.0009598251119d+01,
     |   1.8776457310489d+01, 3.9535867943677d+00,-8.6185887292668d+00,
     |  -1.5116492189003d+01,-1.4955868599657d+01,-1.0402103643260d+01,
     |  -4.9297644476761d+00,-1.2547163645770d+00,-5.0302257739312d-02/
      data (lpmn(lat, 6, 8), lat = 1,36)/
     |   1.7114527250523d-03, 1.3089475824133d-01, 8.9835314197592d-01,
     |   2.8765008374291d+00, 6.0800584928608d+00, 9.5669037321644d+00,
     |   1.1568716017062d+01, 1.0191699895254d+01, 4.4118304444287d+00,
     |  -5.1140344634999d+00,-1.5877403060001d+01,-2.4188962441468d+01,
     |  -2.6511252037954d+01,-2.0940738856216d+01,-8.2033587939800d+00,
     |   8.3151403400794d+00, 2.3599920276295d+01, 3.2747314783904d+01,
     |   3.2747314783904d+01, 2.3599920276295d+01, 8.3151403400795d+00,
     |  -8.2033587939800d+00,-2.0940738856216d+01,-2.6511252037954d+01,
     |  -2.4188962441468d+01,-1.5877403060001d+01,-5.1140344634999d+00,
     |   4.4118304444287d+00, 1.0191699895254d+01, 1.1568716017062d+01,
     |   9.5669037321644d+00, 6.0800584928608d+00, 2.8765008374292d+00,
     |   8.9835314197593d-01, 1.3089475824133d-01, 1.7114527250523d-03/
      data (lpmn(lat, 7, 8), lat = 1,36)/
     |   3.9836688534460d-05, 9.2738738562411d-03, 1.0934695854735d-01,
     |   5.1490680927493d-01, 1.5069358328099d+00, 3.2377599212238d+00,
     |   5.5067986668998d+00, 7.6500860419442d+00, 8.6537731149955d+00,
     |   7.5013399221293d+00, 3.6411922875273d+00,-2.6236708771873d+00,
     |  -1.0022118769402d+01,-1.6580908289154d+01,-2.0219241794770d+01,
     |  -1.9472368452631d+01,-1.4069676493691d+01,-5.1293693098504d+00,
     |   5.1293693098504d+00, 1.4069676493691d+01, 1.9472368452631d+01,
     |   2.0219241794770d+01, 1.6580908289154d+01, 1.0022118769402d+01,
     |   2.6236708771873d+00,-3.6411922875273d+00,-7.5013399221293d+00,
     |  -8.6537731149955d+00,-7.6500860419442d+00,-5.5067986668998d+00,
     |  -3.2377599212238d+00,-1.5069358328099d+00,-5.1490680927493d-01,
     |  -1.0934695854735d-01,-9.2738738562411d-03,-3.9836688534460d-05/
      data (lpmn(lat, 8, 8), lat = 1,36)/
     |   5.6831028883824d-07, 4.0106978880479d-04, 8.0527817487928d-03,
     |   5.4915877518866d-02, 2.1691616935947d-01, 6.0920585814933d-01,
     |   1.3433369777356d+00, 2.4538833403527d+00, 3.8251113007780d+00,
     |   5.1592551758201d+00, 6.0185798080385d+00, 5.9451097757425d+00,
     |   4.6258698137373d+00, 2.0440643458860d+00,-1.4481334617535d+00,
     |  -5.1767225506350d+00,-8.3113656099482d+00,-1.0101043870198d+01,
     |  -1.0101043870198d+01,-8.3113656099482d+00,-5.1767225506350d+00,
     |  -1.4481334617535d+00, 2.0440643458860d+00, 4.6258698137373d+00,
     |   5.9451097757425d+00, 6.0185798080385d+00, 5.1592551758201d+00,
     |   3.8251113007780d+00, 2.4538833403527d+00, 1.3433369777356d+00,
     |   6.0920585814933d-01, 2.1691616935947d-01, 5.4915877518867d-02,
     |   8.0527817487930d-03, 4.0106978880479d-04, 5.6831028883824d-07/
      data (lpmn(lat, 0, 9), lat = 1,36)/
     |  -2.6564147638452d+02,-1.8026233912426d+02,-5.0598611686741d+01,
     |   6.3020456098212d+01, 1.1261419840162d+02, 8.6473206053186d+01,
     |   1.2607851210442d+01,-5.9398864611800d+01,-8.7180139635726d+01,
     |  -5.8475457109410d+01, 4.4630619996644d+00, 6.0514404381012d+01,
     |   7.5370280291949d+01, 4.1808249314363d+01,-1.7169911552896d+01,
     |  -6.3569670677473d+01,-6.8283456153480d+01,-2.8952440110716d+01,
     |   2.8952440110716d+01, 6.8283456153480d+01, 6.3569670677473d+01,
     |   1.7169911552896d+01,-4.1808249314363d+01,-7.5370280291949d+01,
     |  -6.0514404381013d+01,-4.4630619996644d+00, 5.8475457109410d+01,
     |   8.7180139635726d+01, 5.9398864611800d+01,-1.2607851210442d+01,
     |  -8.6473206053186d+01,-1.1261419840162d+02,-6.3020456098212d+01,
     |   5.0598611686741d+01, 1.8026233912426d+02, 2.6564147638452d+02/
      data (lpmn(lat, 1, 9), lat = 1,36)/
     |   2.7200344555709d+02,-4.9150214389976d+01,-1.2136372828406d+02,
     |  -9.2273382167794d+01,-1.1254373425379d+01, 6.5679607545537d+01,
     |   9.4746813948924d+01, 6.4394293252952d+01,-1.7877268561264d+00,
     |  -6.1404395887684d+01,-7.9095190070547d+01,-4.6797457049374d+01,
     |   1.2986158186741d+01, 6.2119269522200d+01, 7.0492614699078d+01,
     |   3.4072553914334d+01,-2.3318289035910d+01,-6.5211872670082d+01,
     |  -6.5211872670082d+01,-2.3318289035910d+01, 3.4072553914334d+01,
     |   7.0492614699078d+01, 6.2119269522200d+01, 1.2986158186741d+01,
     |  -4.6797457049373d+01,-7.9095190070547d+01,-6.1404395887684d+01,
     |  -1.7877268561266d+00, 6.4394293252952d+01, 9.4746813948924d+01,
     |   6.5679607545537d+01,-1.1254373425379d+01,-9.2273382167794d+01,
     |  -1.2136372828406d+02,-4.9150214389976d+01, 2.7200344555709d+02/
      data (lpmn(lat, 2, 9), lat = 1,36)/
     |   1.2953705897869d+02, 7.4859774950482d+01,-5.2206984772532d+00,
     |  -6.8578533311897d+01,-8.3689727657136d+01,-4.6758365967378d+01,
     |   1.7112754301209d+01, 6.9098743530677d+01, 7.9195288572229d+01,
     |   4.3055938770443d+01,-1.6436744397936d+01,-6.3428000732368d+01,
     |  -7.0536953243863d+01,-3.4810390546118d+01, 2.1078321665031d+01,
     |   6.2843791761375d+01, 6.5300678547401d+01, 2.7389274076060d+01,
     |  -2.7389274076060d+01,-6.5300678547401d+01,-6.2843791761375d+01,
     |  -2.1078321665031d+01, 3.4810390546117d+01, 7.0536953243863d+01,
     |   6.3428000732368d+01, 1.6436744397936d+01,-4.3055938770443d+01,
     |  -7.9195288572229d+01,-6.9098743530677d+01,-1.7112754301210d+01,
     |   4.6758365967378d+01, 8.3689727657136d+01, 6.8578533311897d+01,
     |   5.2206984772535d+00,-7.4859774950482d+01,-1.2953705897869d+02/
      data (lpmn(lat, 3, 9), lat = 1,36)/
     |   1.9983275305461d+01, 4.6912216546078d+01, 4.2696009201399d+01,
     |   8.3669936837719d+00,-3.6199170348502d+01,-6.3954902467811d+01,
     |  -5.6865034843154d+01,-1.7005131336565d+01, 3.4097639653020d+01,
     |   6.7659838628617d+01, 6.4336188190069d+01, 2.5651720937998d+01,
     |  -2.6594840617770d+01,-6.2733295673221d+01,-6.2298965904486d+01,
     |  -2.5874968633948d+01, 2.5214005203408d+01, 6.1226734256974d+01,
     |   6.1226734256974d+01, 2.5214005203408d+01,-2.5874968633948d+01,
     |  -6.2298965904486d+01,-6.2733295673221d+01,-2.6594840617770d+01,
     |   2.5651720937998d+01, 6.4336188190069d+01, 6.7659838628617d+01,
     |   3.4097639653020d+01,-1.7005131336565d+01,-5.6865034843154d+01,
     |  -6.3954902467811d+01,-3.6199170348502d+01, 8.3669936837718d+00,
     |   4.2696009201399d+01, 4.6912216546078d+01, 1.9983275305460d+01/
      data (lpmn(lat, 4, 9), lat = 1,36)/
     |   1.7297763162885d+00, 1.3415592666243d+01, 2.6927682426619d+01,
     |   2.9248688042136d+01, 1.3373168768101d+01,-1.5935528657218d+01,
     |  -4.3708911978209d+01,-5.3120400359321d+01,-3.5822972729684d+01,
     |   1.9889500129657d+00, 4.1780261148092d+01, 6.2351409094316d+01,
     |   5.1711903798891d+01, 1.4340252265463d+01,-3.0565401777226d+01,
     |  -5.9188844004186d+01,-5.6081887231584d+01,-2.2790438883833d+01,
     |   2.2790438883833d+01, 5.6081887231584d+01, 5.9188844004186d+01,
     |   3.0565401777226d+01,-1.4340252265463d+01,-5.1711903798891d+01,
     |  -6.2351409094316d+01,-4.1780261148092d+01,-1.9889500129657d+00,
     |   3.5822972729684d+01, 5.3120400359321d+01, 4.3708911978209d+01,
     |   1.5935528657218d+01,-1.3373168768101d+01,-2.9248688042136d+01,
     |  -2.6927682426619d+01,-1.3415592666243d+01,-1.7297763162885d+00/
      data (lpmn(lat, 5, 9), lat = 1,36)/
     |   9.9209798047604d-02, 2.4180762649964d+00, 9.0345153862010d+00,
     |   1.7441181375624d+01, 2.1355862696291d+01, 1.4833162753213d+01,
     |  -2.9832000488152d+00,-2.5706452230710d+01,-4.2006091950486d+01,
     |  -4.1530838527727d+01,-2.1240711642636d+01, 1.1659550806295d+01,
     |   4.2319976789392d+01, 5.5437456402744d+01, 4.3365828472128d+01,
     |   1.0693307379891d+01,-2.7439954921776d+01,-5.2672623534347d+01,
     |  -5.2672623534347d+01,-2.7439954921776d+01, 1.0693307379891d+01,
     |   4.3365828472128d+01, 5.5437456402744d+01, 4.2319976789392d+01,
     |   1.1659550806295d+01,-2.1240711642636d+01,-4.1530838527727d+01,
     |  -4.2006091950486d+01,-2.5706452230710d+01,-2.9832000488153d+00,
     |   1.4833162753213d+01, 2.1355862696291d+01, 1.7441181375624d+01,
     |   9.0345153862011d+00, 2.4180762649964d+00, 9.9209798047604d-02/
      data (lpmn(lat, 6, 9), lat = 1,36)/
     |   4.0369694871379d-03, 3.0332143758552d-01, 2.0055033518624d+00,
     |   6.0395889227313d+00, 1.1608392968458d+01, 1.5687134694796d+01,
     |   1.4280245837645d+01, 4.9530156659685d+00,-1.0856595163881d+01,
     |  -2.7381936747234d+01,-3.6650687855724d+01,-3.2410326747731d+01,
     |  -1.3862281090783d+01, 1.2956407985155d+01, 3.7226265406342d+01,
     |   4.8115246774527d+01, 4.0001783208879d+01, 1.5482768895083d+01,
     |  -1.5482768895083d+01,-4.0001783208879d+01,-4.8115246774527d+01,
     |  -3.7226265406342d+01,-1.2956407985155d+01, 1.3862281090784d+01,
     |   3.2410326747731d+01, 3.6650687855724d+01, 2.7381936747234d+01,
     |   1.0856595163881d+01,-4.9530156659685d+00,-1.4280245837645d+01,
     |  -1.5687134694796d+01,-1.1608392968458d+01,-6.0395889227313d+00,
     |  -2.0055033518625d+00,-3.0332143758552d-01,-4.0369694871379d-03/
      data (lpmn(lat, 7, 9), lat = 1,36)/
     |   1.1890791608786d-04, 2.7287236209586d-02, 3.1235480704926d-01,
     |   1.4033798136197d+00, 3.8360661520501d+00, 7.4792665664482d+00,
     |   1.1042383088985d+01, 1.2255439604580d+01, 8.8739866725796d+00,
     |   1.1091543834624d-01,-1.2302442655778d+01,-2.4186621552300d+01,
     |  -3.0358358218453d+01,-2.6939799715875d+01,-1.3453264818843d+01,
     |   6.4161302665785d+00, 2.5939025917003d+01, 3.7976513302664d+01,
     |   3.7976513302664d+01, 2.5939025917003d+01, 6.4161302665786d+00,
     |  -1.3453264818843d+01,-2.6939799715875d+01,-3.0358358218453d+01,
     |  -2.4186621552300d+01,-1.2302442655778d+01, 1.1091543834622d-01,
     |   8.8739866725796d+00, 1.2255439604579d+01, 1.1042383088985d+01,
     |   7.4792665664482d+00, 3.8360661520501d+00, 1.4033798136197d+00,
     |   3.1235480704927d-01, 2.7287236209586d-02, 1.1890791608786d-04/
      data (lpmn(lat, 8, 9), lat = 1,36)/
     |   2.4735221817055d-06, 1.7247988369979d-03, 3.3792589359358d-02,
     |   2.2183044469382d-01, 8.3046603774420d-01, 2.1696123530782d+00,
     |   4.3446134038764d+00, 6.9690075559038d+00, 9.0493878010867d+00,
     |   9.2139896433169d+00, 6.2857287694463d+00,-1.9407888299925d-02,
     |  -8.6262441571280d+00,-1.7181011638586d+01,-2.2762535088840d+01,
     |  -2.2993021584684d+01,-1.7081238745364d+01,-6.3086643276705d+00,
     |   6.3086643276705d+00, 1.7081238745364d+01, 2.2993021584684d+01,
     |   2.2762535088840d+01, 1.7181011638586d+01, 8.6262441571279d+00,
     |   1.9407888299969d-02,-6.2857287694463d+00,-9.2139896433169d+00,
     |  -9.0493878010867d+00,-6.9690075559038d+00,-4.3446134038764d+00,
     |  -2.1696123530782d+00,-8.3046603774420d-01,-2.2183044469382d-01,
     |  -3.3792589359359d-02,-1.7247988369979d-03,-2.4735221817055d-06/
      data (lpmn(lat, 9, 9), lat = 1,36)/
     |   3.2234591741079d-08, 6.8087591490324d-05, 2.2679133618509d-03,
     |   2.1502655351800d-02, 1.0820154964691d-01, 3.6720100674464d-01,
     |   9.4410082919357d-01, 1.9595821370968d+00, 3.4040436713495d+00,
     |   5.0422303033671d+00, 6.3947109652505d+00, 6.8422203456124d+00,
     |   5.8430004777842d+00, 3.1878895484576d+00,-8.2103842175030d-01,
     |  -5.3684325670794d+00,-9.3326673225609d+00,-1.1641374403646d+01,
     |  -1.1641374403646d+01,-9.3326673225609d+00,-5.3684325670794d+00,
     |  -8.2103842175030d-01, 3.1878895484576d+00, 5.8430004777842d+00,
     |   6.8422203456124d+00, 6.3947109652505d+00, 5.0422303033671d+00,
     |   3.4040436713495d+00, 1.9595821370968d+00, 9.4410082919358d-01,
     |   3.6720100674464d-01, 1.0820154964690d-01, 2.1502655351801d-02,
     |   2.2679133618509d-03, 6.8087591490324d-05, 3.2234591741078d-08/
      data (lpmn(lat, 0,10), lat = 1,36)/
     |  -3.3802027899342d+02,-2.0716134322586d+02,-2.1498225663332d+01,
     |   1.1579191018027d+02, 1.3936882603514d+02, 5.9556638967828d+01,
     |  -5.0877026988653d+01,-1.0981470432772d+02,-8.1081751166768d+01,
     |   5.5761715528464d+00, 8.1358597844796d+01, 9.0654752717259d+01,
     |   3.0476008303626d+01,-5.0323907680525d+01,-8.9601245863279d+01,
     |  -5.8707729165369d+01, 1.7051661228535d+01, 7.8689035867728d+01,
     |   7.8689035867728d+01, 1.7051661228535d+01,-5.8707729165368d+01,
     |  -8.9601245863279d+01,-5.0323907680525d+01, 3.0476008303626d+01,
     |   9.0654752717259d+01, 8.1358597844796d+01, 5.5761715528465d+00,
     |  -8.1081751166768d+01,-1.0981470432772d+02,-5.0877026988654d+01,
     |   5.9556638967828d+01, 1.3936882603514d+02, 1.1579191018027d+02,
     |  -2.1498225663331d+01,-2.0716134322586d+02,-3.3802027899342d+02/
      data (lpmn(lat, 1,10), lat = 1,36)/
     |   3.0018257774105d+02,-8.9389935339576d+01,-1.5631293181003d+02,
     |  -8.4005349134592d+01, 3.7255370129105d+01, 1.1522192139158d+02,
     |   1.0158957043276d+02, 1.6497097555447d+01,-7.2260162023714d+01,
     |  -1.0033465064285d+02,-5.1871076068021d+01, 3.2420079980891d+01,
     |   8.7947156606528d+01, 7.4513902587065d+01, 4.8312234797958d+00,
     |  -6.6720864358972d+01,-8.5719102065945d+01,-3.8427194040854d+01,
     |   3.8427194040854d+01, 8.5719102065945d+01, 6.6720864358972d+01,
     |  -4.8312234797957d+00,-7.4513902587065d+01,-8.7947156606527d+01,
     |  -3.2420079980891d+01, 5.1871076068021d+01, 1.0033465064285d+02,
     |   7.2260162023714d+01,-1.6497097555447d+01,-1.0158957043276d+02,
     |  -1.1522192139158d+02,-3.7255370129105d+01, 8.4005349134592d+01,
     |   1.5631293181003d+02, 8.9389935339576d+01,-3.0018257774105d+02/
      data (lpmn(lat, 2,10), lat = 1,36)/
     |   1.6460805257877d+02, 8.0648625696513d+01,-3.2819389730556d+01,
     |  -1.0394587096216d+02,-9.1855678454944d+01,-1.2949075828872d+01,
     |   7.2573744430671d+01, 1.0377754112549d+02, 6.1058661963979d+01,
     |  -2.2042071708482d+01,-8.4687851114967d+01,-8.2992655088276d+01,
     |  -2.0833539835288d+01, 5.4372113597459d+01, 8.7096203598517d+01,
     |   5.4224012205245d+01,-1.8683205483004d+01,-7.6834980890465d+01,
     |  -7.6834980890465d+01,-1.8683205483005d+01, 5.4224012205245d+01,
     |   8.7096203598517d+01, 5.4372113597459d+01,-2.0833539835289d+01,
     |  -8.2992655088276d+01,-8.4687851114967d+01,-2.2042071708482d+01,
     |   6.1058661963979d+01, 1.0377754112549d+02, 7.2573744430671d+01,
     |  -1.2949075828872d+01,-9.1855678454944d+01,-1.0394587096216d+02,
     |  -3.2819389730557d+01, 8.0648625696513d+01, 1.6460805257876d+02/
      data (lpmn(lat, 3,10), lat = 1,36)/
     |   2.8438737999585d+01, 6.2755685669306d+01, 4.6172353663184d+01,
     |  -1.1526640560065d+01,-6.8928873202317d+01,-8.2830797216296d+01,
     |  -3.9963582837842d+01, 3.2404015094237d+01, 8.4972563067228d+01,
     |   8.1121138132678d+01, 2.3126934448519d+01,-4.8957561583954d+01,
     |  -8.5237534081104d+01,-6.1051402262189d+01, 5.6848989305300d+00,
     |   6.7235318088329d+01, 7.9910237255152d+01, 3.5025979880892d+01,
     |  -3.5025979880892d+01,-7.9910237255152d+01,-6.7235318088329d+01,
     |  -5.6848989305300d+00, 6.1051402262189d+01, 8.5237534081104d+01,
     |   4.8957561583954d+01,-2.3126934448519d+01,-8.1121138132678d+01,
     |  -8.4972563067228d+01,-3.2404015094237d+01, 3.9963582837842d+01,
     |   8.2830797216297d+01, 6.8928873202317d+01, 1.1526640560065d+01,
     |  -4.6172353663184d+01,-6.2755685669306d+01,-2.8438737999585d+01/
      data (lpmn(lat, 4,10), lat = 1,36)/
     |   2.7659083265783d+00, 2.0674482397027d+01, 3.7882243553252d+01,
     |   3.2685116295688d+01,-6.9544999931201d-01,-4.4620974606776d+01,
     |  -6.8764503819503d+01,-5.2058202891899d+01, 9.1330154415495d-02,
     |   5.6667270488720d+01, 8.0699397139996d+01, 5.4684302413545d+01,
     |  -6.1239113767258d+00,-6.2597715828830d+01,-7.7510822930473d+01,
     |  -4.0838026649015d+01, 2.2954600095605d+01, 7.1036289975468d+01,
     |   7.1036289975468d+01, 2.2954600095605d+01,-4.0838026649014d+01,
     |  -7.7510822930473d+01,-6.2597715828830d+01,-6.1239113767255d+00,
     |   5.4684302413545d+01, 8.0699397139996d+01, 5.6667270488720d+01,
     |   9.1330154415609d-02,-5.2058202891899d+01,-6.8764503819503d+01,
     |  -4.4620974606776d+01,-6.9544999931206d-01, 3.2685116295688d+01,
     |   3.7882243553252d+01, 2.0674482397027d+01, 2.7659083265783d+00/
      data (lpmn(lat, 5,10), lat = 1,36)/
     |   1.8009106746598d-01, 4.2771132717128d+00, 1.5082363904852d+01,
     |   2.6117986403770d+01, 2.5397142830559d+01, 5.7503337502398d+00,
     |  -2.6648332736106d+01,-5.3201049896904d+01,-5.4177715445649d+01,
     |  -2.3196038671043d+01, 2.5667283858979d+01, 6.4412555965551d+01,
     |   6.8248081382825d+01, 3.2361038847289d+01,-2.3291917831132d+01,
     |  -6.5309217104656d+01,-6.7627324467441d+01,-2.8383050001605d+01,
     |   2.8383050001605d+01, 6.7627324467441d+01, 6.5309217104656d+01,
     |   2.3291917831132d+01,-3.2361038847289d+01,-6.8248081382825d+01,
     |  -6.4412555965551d+01,-2.5667283858979d+01, 2.3196038671043d+01,
     |   5.4177715445649d+01, 5.3201049896904d+01, 2.6648332736106d+01,
     |  -5.7503337502397d+00,-2.5397142830559d+01,-2.6117986403771d+01,
     |  -1.5082363904852d+01,-4.2771132717128d+00,-1.8009106746598d-01/
      data (lpmn(lat, 6,10), lat = 1,36)/
     |   8.4677059449259d-03, 6.2373394173153d-01, 3.9531212924449d+00,
     |   1.1080165042469d+01, 1.8913668738331d+01, 2.0512626077576d+01,
     |   9.7322948136443d+00,-1.2805409877894d+01,-3.7296289813497d+01,
     |  -4.8906675597605d+01,-3.6893208277339d+01,-2.9641679998915d+00,
     |   3.7275914281878d+01, 6.1940326597146d+01, 5.5643272603545d+01,
     |   1.9607119616628d+01,-2.7698397977990d+01,-6.0484421735167d+01,
     |  -6.0484421735167d+01,-2.7698397977990d+01, 1.9607119616628d+01,
     |   5.5643272603545d+01, 6.1940326597146d+01, 3.7275914281878d+01,
     |  -2.9641679998912d+00,-3.6893208277339d+01,-4.8906675597605d+01,
     |  -3.7296289813497d+01,-1.2805409877895d+01, 9.7322948136442d+00,
     |   2.0512626077576d+01, 1.8913668738331d+01, 1.1080165042469d+01,
     |   3.9531212924449d+00, 6.2373394173153d-01, 8.4677059449258d-03/
      data (lpmn(lat, 7,10), lat = 1,36)/
     |   2.9699682350218d-04, 6.7073811493012d-02, 7.4260781059049d-01,
     |   3.1613100058351d+00, 7.9676754459536d+00, 1.3737739797142d+01,
     |   1.6551859133684d+01, 1.1827967192626d+01,-2.2173195103287d+00,
     |  -2.1778767259271d+01,-3.7817238777511d+01,-4.0275470225371d+01,
     |  -2.4183959385286d+01, 6.0793240070651d+00, 3.7534069363115d+01,
     |   5.4676814916813d+01, 4.7823928342741d+01, 1.8905927173451d+01,
     |  -1.8905927173451d+01,-4.7823928342741d+01,-5.4676814916813d+01,
     |  -3.7534069363115d+01,-6.0793240070652d+00, 2.4183959385287d+01,
     |   4.0275470225371d+01, 3.7817238777511d+01, 2.1778767259271d+01,
     |   2.2173195103288d+00,-1.1827967192626d+01,-1.6551859133684d+01,
     |  -1.3737739797142d+01,-7.9676754459536d+00,-3.1613100058351d+00,
     |  -7.4260781059050d-01,-6.7073811493012d-02,-2.9699682350218d-04/
      data (lpmn(lat, 8,10), lat = 1,36)/
     |   7.7884560545559d-06, 5.3587965122835d-03, 1.0214322123685d-01,
     |   6.4209158077310d-01, 2.2586638811406d+00, 5.4093944983063d+00,
     |   9.5805788007903d+00, 1.2788091779230d+01, 1.2072059918302d+01,
     |   5.1147724802743d+00,-7.7814817880956d+00,-2.2688151619047d+01,
     |  -3.3061258270723d+01,-3.2694437301693d+01,-1.9223745702459d+01,
     |   3.8367021160523d+00, 2.7967828247086d+01, 4.3303452416398d+01,
     |   4.3303452416398d+01, 2.7967828247086d+01, 3.8367021160524d+00,
     |  -1.9223745702459d+01,-3.2694437301693d+01,-3.3061258270723d+01,
     |  -2.2688151619047d+01,-7.7814817880956d+00, 5.1147724802743d+00,
     |   1.2072059918302d+01, 1.2788091779230d+01, 9.5805788007904d+00,
     |   5.4093944983063d+00, 2.2586638811406d+00, 6.4209158077310d-01,
     |   1.0214322123686d-01, 5.3587965122835d-03, 7.7884560545558d-06/
      data (lpmn(lat, 9,10), lat = 1,36)/
     |   1.4750738529666d-07, 3.0802076036960d-04, 1.0022723067401d-02,
     |   9.1644357627237d-02, 4.3831421243382d-01, 1.3896247585961d+00,
     |   3.2659323719855d+00, 6.0160305624422d+00, 8.8712180754337d+00,
     |   1.0319915726357d+01, 8.6181263144162d+00, 2.7340619673401d+00,
     |  -6.7305727694691d+00,-1.7240044279390d+01,-2.5012604159058d+01,
     |  -2.6542923444542d+01,-2.0280146223038d+01,-7.5883269759124d+00,
     |   7.5883269759123d+00, 2.0280146223038d+01, 2.6542923444542d+01,
     |   2.5012604159058d+01, 1.7240044279390d+01, 6.7305727694691d+00,
     |  -2.7340619673400d+00,-8.6181263144162d+00,-1.0319915726357d+01,
     |  -8.8712180754337d+00,-6.0160305624422d+00,-3.2659323719855d+00,
     |  -1.3896247585961d+00,-4.3831421243382d-01,-9.1644357627238d-02,
     |  -1.0022723067402d-02,-3.0802076036960d-04,-1.4750738529666d-07/
      data (lpmn(lat,10,10), lat = 1,36)/
     |   1.7787731569659d-09, 1.1244989696276d-05, 6.2131414895452d-04,
     |   8.1889521730811d-03, 5.2483883982093d-02, 2.1516184623067d-01,
     |   6.4474897847278d-01, 1.5196715463493d+00, 2.9392326625291d+00,
     |   4.7745956809759d+00, 6.5672485679344d+00, 7.5754156259567d+00,
     |   7.0121961796931d+00, 4.4105819100229d+00,-4.9680462142038d-02,
     |  -5.4414252506825d+00,-1.0318464256276d+01,-1.3215989735130d+01,
     |  -1.3215989735130d+01,-1.0318464256276d+01,-5.4414252506825d+00,
     |  -4.9680462142038d-02, 4.4105819100229d+00, 7.0121961796931d+00,
     |   7.5754156259567d+00, 6.5672485679344d+00, 4.7745956809759d+00,
     |   2.9392326625291d+00, 1.5196715463493d+00, 6.4474897847279d-01,
     |   2.1516184623067d-01, 5.2483883982093d-02, 8.1889521730812d-03,
     |   6.2131414895453d-04, 1.1244989696276d-05, 1.7787731569659d-09/
      data (lpmn(lat, 0,11), lat = 1,36)/
     |  -4.1994661492584d+02,-2.2798196802229d+02, 2.3906783630379d+01,
     |   1.7231445401232d+02, 1.4350120059652d+02,-2.0027226224205d-01,
     |  -1.2137129317882d+02,-1.2173907396347d+02,-1.5431068859727d+01,
     |   9.4814605732151d+01, 1.1219703522206d+02, 2.8006443039053d+01,
     |  -7.6828613661368d+01,-1.0750382979920d+02,-3.9409824172275d+01,
     |   6.2791284880790d+01, 1.0550697876168d+02, 5.0701980739347d+01,
     |  -5.0701980739347d+01,-1.0550697876168d+02,-6.2791284880790d+01,
     |   3.9409824172275d+01, 1.0750382979920d+02, 7.6828613661368d+01,
     |  -2.8006443039052d+01,-1.1219703522206d+02,-9.4814605732151d+01,
     |   1.5431068859727d+01, 1.2173907396347d+02, 1.2137129317882d+02,
     |   2.0027226224205d-01,-1.4350120059652d+02,-1.7231445401232d+02,
     |  -2.3906783630381d+01, 2.2798196802229d+02, 4.1994661492584d+02/
      data (lpmn(lat, 1,11), lat = 1,36)/
     |   3.2419996297537d+02,-1.3903038173820d+02,-1.8666398472625d+02,
     |  -5.5200954608855d+01, 1.0070501058555d+02, 1.4992846377303d+02,
     |   6.6751604378971d+01,-6.3669692103679d+01,-1.2605417222393d+02,
     |  -7.3056390376022d+01, 4.0385596888952d+01, 1.1096465950339d+02,
     |   7.8836735079562d+01,-2.2657120671210d+01,-1.0022425469338d+02,
     |  -8.4950038170282d+01, 7.3236769069829d+00, 9.1881960640486d+01,
     |   9.1881960640486d+01, 7.3236769069830d+00,-8.4950038170282d+01,
     |  -1.0022425469338d+02,-2.2657120671210d+01, 7.8836735079563d+01,
     |   1.1096465950339d+02, 4.0385596888952d+01,-7.3056390376022d+01,
     |  -1.2605417222393d+02,-6.3669692103679d+01, 6.6751604378970d+01,
     |   1.4992846377303d+02, 1.0070501058555d+02,-5.5200954608854d+01,
     |  -1.8666398472625d+02,-1.3903038173820d+02, 3.2419996297537d+02/
      data (lpmn(lat, 2,11), lat = 1,36)/
     |   2.0403765744871d+02, 8.0852990755377d+01,-7.0724922243836d+01,
     |  -1.3773173064101d+02,-7.9012528018882d+01, 4.5109808833875d+01,
     |   1.2635727841199d+02, 9.8997415037839d+01,-8.3915271978541d+00,
     |  -1.0145981643658d+02,-1.0237650609724d+02,-1.5019010498219d+01,
     |   8.1424519117755d+01, 1.0287976382369d+02, 3.2985355861218d+01,
     |  -6.4484989696351d+01,-1.0287276517556d+02,-4.8851814370565d+01,
     |   4.8851814370565d+01, 1.0287276517556d+02, 6.4484989696352d+01,
     |  -3.2985355861217d+01,-1.0287976382369d+02,-8.1424519117755d+01,
     |   1.5019010498219d+01, 1.0237650609724d+02, 1.0145981643658d+02,
     |   8.3915271978543d+00,-9.8997415037839d+01,-1.2635727841199d+02,
     |  -4.5109808833875d+01, 7.9012528018882d+01, 1.3773173064101d+02,
     |   7.0724922243837d+01,-8.0852990755377d+01,-2.0403765744871d+02/
      data (lpmn(lat, 3,11), lat = 1,36)/
     |   3.9081443837127d+01, 8.0344711000643d+01, 4.3604138401129d+01,
     |  -4.2535609283110d+01,-1.0345463326638d+02,-8.2921562686937d+01,
     |   7.1321708500582d+00, 9.4732222840521d+01, 1.0777745424145d+02,
     |   3.5131282428101d+01,-6.3247015252782d+01,-1.0622532824810d+02,
     |  -5.9501759134859d+01, 3.5852014906486d+01, 9.8508940315575d+01,
     |   7.5872114399581d+01,-1.1611084786145d+01,-8.8348893153443d+01,
     |  -8.8348893153443d+01,-1.1611084786145d+01, 7.5872114399581d+01,
     |   9.8508940315575d+01, 3.5852014906487d+01,-5.9501759134860d+01,
     |  -1.0622532824810d+02,-6.3247015252782d+01, 3.5131282428101d+01,
     |   1.0777745424145d+02, 9.4732222840522d+01, 7.1321708500587d+00,
     |  -8.2921562686937d+01,-1.0345463326638d+02,-4.2535609283111d+01,
     |   4.3604138401129d+01, 8.0344711000643d+01, 3.9081443837127d+01/
      data (lpmn(lat, 4,11), lat = 1,36)/
     |   4.2172048648788d+00, 3.0246917298977d+01, 4.9711102777322d+01,
     |   3.0006897075785d+01,-2.6516716820998d+01,-7.8594895527843d+01,
     |  -7.9266062432322d+01,-1.8578979121946d+01, 6.2387028330624d+01,
     |   1.0121681658398d+02, 6.4916434242803d+01,-2.0674204837729d+01,
     |  -8.9122162957474d+01,-8.6194454703833d+01,-1.4365408918193d+01,
     |   6.8229097492163d+01, 9.4565263892367d+01, 4.3363732836450d+01,
     |  -4.3363732836450d+01,-9.4565263892366d+01,-6.8229097492163d+01,
     |   1.4365408918193d+01, 8.6194454703833d+01, 8.9122162957473d+01,
     |   2.0674204837729d+01,-6.4916434242803d+01,-1.0121681658398d+02,
     |  -6.2387028330624d+01, 1.8578979121946d+01, 7.9266062432322d+01,
     |   7.8594895527843d+01, 2.6516716820998d+01,-3.0006897075785d+01,
     |  -4.9711102777322d+01,-3.0246917298977d+01,-4.2172048648788d+00/
      data (lpmn(lat, 5,11), lat = 1,36)/
     |   3.0671710169357d-01, 7.0776848289898d+00, 2.3359210655297d+01,
     |   3.5347687922952d+01, 2.3597690859397d+01,-1.5451166918532d+01,
     |  -5.9088797228040d+01,-7.2052503366378d+01,-3.5732118650229d+01,
     |   3.1700599623401d+01, 8.3930119552694d+01, 8.0424468773825d+01,
     |   1.9723378437711d+01,-5.5859018727119d+01,-9.0404834102686d+01,
     |  -5.7281258145894d+01, 1.9092619747198d+01, 8.0849463951787d+01,
     |   8.0849463951787d+01, 1.9092619747198d+01,-5.7281258145894d+01,
     |  -9.0404834102686d+01,-5.5859018727119d+01, 1.9723378437711d+01,
     |   8.0424468773825d+01, 8.3930119552694d+01, 3.1700599623401d+01,
     |  -3.5732118650229d+01,-7.2052503366378d+01,-5.9088797228040d+01,
     |  -1.5451166918532d+01, 2.3597690859397d+01, 3.5347687922952d+01,
     |   2.3359210655297d+01, 7.0776848289898d+00, 3.0671710169357d-01/
      data (lpmn(lat, 6,11), lat = 1,36)/
     |   1.6296750560905d-02, 1.1743571139529d+00, 7.0964471265786d+00,
     |   1.8286635198920d+01, 2.6811565981053d+01, 2.0158630700349d+01,
     |  -6.8471725425188d+00,-4.2575563866608d+01,-6.2385859100540d+01,
     |  -4.6019847732090d+01, 3.9472888103402d+00, 5.8732514099883d+01,
     |   8.0877324003018d+01, 5.1599186147390d+01,-1.2797807941635d+01,
     |  -6.9676464808651d+01,-7.9442298113808d+01,-3.4453259654007d+01,
     |   3.4453259654007d+01, 7.9442298113807d+01, 6.9676464808651d+01,
     |   1.2797807941635d+01,-5.1599186147390d+01,-8.0877324003018d+01,
     |  -5.8732514099883d+01,-3.9472888103402d+00, 4.6019847732090d+01,
     |   6.2385859100540d+01, 4.2575563866608d+01, 6.8471725425189d+00,
     |  -2.0158630700349d+01,-2.6811565981053d+01,-1.8286635198920d+01,
     |  -7.0964471265787d+00,-1.1743571139529d+00,-1.6296750560905d-02/
      data (lpmn(lat, 7,11), lat = 1,36)/
     |   6.5791644125794d-04, 1.4598128534649d-01, 1.5571286173235d+00,
     |   6.2324594360116d+00, 1.4255978878492d+01, 2.0920788413120d+01,
     |   1.8000537638041d+01, 1.8266276744709d-01,-2.7808618150990d+01,
     |  -5.0368836381361d+01,-4.9656693143366d+01,-1.9090725995058d+01,
     |   2.8445983620589d+01, 6.5638102726632d+01, 6.7630808966488d+01,
     |   2.9752835758550d+01,-2.7063709432430d+01,-6.8364216792288d+01,
     |  -6.8364216792288d+01,-2.7063709432430d+01, 2.9752835758550d+01,
     |   6.7630808966487d+01, 6.5638102726632d+01, 2.8445983620589d+01,
     |  -1.9090725995058d+01,-4.9656693143366d+01,-5.0368836381361d+01,
     |  -2.7808618150990d+01, 1.8266276744697d-01, 1.8000537638041d+01,
     |   2.0920788413120d+01, 1.4255978878492d+01, 6.2324594360116d+00,
     |   1.5571286173236d+00, 1.4598128534649d-01, 6.5791644125794d-04/
      data (lpmn(lat, 8,11), lat = 1,36)/
     |   2.0475343294307d-05, 1.3881620995924d-02, 2.5662763437481d-01,
     |   1.5362122097801d+00, 5.0274867057463d+00, 1.0833560055442d+01,
     |   1.6300770658099d+01, 1.6171358543739d+01, 5.7527407199025d+00,
     |  -1.4395690970614d+01,-3.6000269802408d+01,-4.6006927156901d+01,
     |  -3.4416998042452d+01,-2.2689315825245d+00, 3.6304139250282d+01,
     |   6.0709547849355d+01, 5.5971751749294d+01, 2.2604037700886d+01,
     |  -2.2604037700886d+01,-5.5971751749294d+01,-6.0709547849355d+01,
     |  -3.6304139250282d+01, 2.2689315825244d+00, 3.4416998042452d+01,
     |   4.6006927156901d+01, 3.6000269802408d+01, 1.4395690970614d+01,
     |  -5.7527407199025d+00,-1.6171358543739d+01,-1.6300770658099d+01,
     |  -1.0833560055442d+01,-5.0274867057463d+00,-1.5362122097801d+00,
     |  -2.5662763437482d-01,-1.3881620995924d-02,-2.0475343294307d-05/
      data (lpmn(lat, 9,11), lat = 1,36)/
     |   4.8740280074756d-07, 1.0049956294887d-03, 3.1864804983844d-02,
     |   2.7975811976169d-01, 1.2626909382085d+00, 3.6959853528090d+00,
     |   7.7788963258947d+00, 1.2223940950032d+01, 1.3974857161157d+01,
     |   9.4627551818121d+00,-2.8117443718934d+00,-1.9941175309274d+01,
     |  -3.4561880116473d+01,-3.8007826990347d+01,-2.5366464459495d+01,
     |   6.1902142907976d-01, 2.9674423183725d+01, 4.8714235530562d+01,
     |   4.8714235530562d+01, 2.9674423183725d+01, 6.1902142907988d-01,
     |  -2.5366464459495d+01,-3.8007826990347d+01,-3.4561880116473d+01,
     |  -1.9941175309274d+01,-2.8117443718934d+00, 9.4627551818121d+00,
     |   1.3974857161157d+01, 1.2223940950032d+01, 7.7788963258947d+00,
     |   3.6959853528090d+00, 1.2626909382085d+00, 2.7975811976169d-01,
     |   3.1864804983845d-02, 1.0049956294887d-03, 4.8740280074756d-07/
      data (lpmn(lat,10,11), lat = 1,36)/
     |   8.5190021566939d-09, 5.3263472388185d-05, 2.8774763970920d-03,
     |   3.6627763478173d-02, 2.2361320505212d-01, 8.5920128390715d-01,
     |   2.3651540757444d+00, 4.9862028300559d+00, 8.2969327722001d+00,
     |   1.0868552856668d+01, 1.0543524442055d+01, 5.4796107946903d+00,
     |  -4.4507884133972d+00,-1.6786659482878d+01,-2.6938535277396d+01,
     |  -3.0084373777003d+01,-2.3648694911287d+01,-8.9651395990530d+00,
     |   8.9651395990530d+00, 2.3648694911287d+01, 3.0084373777003d+01,
     |   2.6938535277396d+01, 1.6786659482877d+01, 4.4507884133972d+00,
     |  -5.4796107946903d+00,-1.0543524442055d+01,-1.0868552856668d+01,
     |  -8.2969327722002d+00,-4.9862028300559d+00,-2.3651540757444d+00,
     |  -8.5920128390715d-01,-2.2361320505212d-01,-3.6627763478173d-02,
     |  -2.8774763970921d-03,-5.3263472388185d-05,-8.5190021566939d-09/
      data (lpmn(lat,11,11), lat = 1,36)/
     |   9.5994334943557d-11, 1.8161981225191d-06, 1.6644888940552d-04,
     |   3.0493294201104d-03, 2.4888128842015d-02, 1.2322735457996d-01,
     |   4.3024130226236d-01, 1.1510597502511d+00, 2.4771895244568d+00,
     |   4.4087009666396d+00, 6.5658537847081d+00, 8.1394272913606d+00,
     |   8.1043443338270d+00, 5.6817132896834d+00, 8.4973147380228d-01,
     |  -5.3975285999817d+00,-1.1264878537462d+01,-1.4821310677640d+01,
     |  -1.4821310677640d+01,-1.1264878537462d+01,-5.3975285999817d+00,
     |   8.4973147380228d-01, 5.6817132896834d+00, 8.1043443338269d+00,
     |   8.1394272913606d+00, 6.5658537847081d+00, 4.4087009666396d+00,
     |   2.4771895244568d+00, 1.1510597502511d+00, 4.3024130226237d-01,
     |   1.2322735457996d-01, 2.4888128842015d-02, 3.0493294201104d-03,
     |   1.6644888940553d-04, 1.8161981225191d-06, 9.5994334943557d-11/
      data (lpmn(lat, 0,12), lat = 1,36)/
     |  -5.1134169787836d+02,-2.3995140365721d+02, 8.5613027100858d+01,
     |   2.2385968246845d+02, 1.1541061163928d+02,-8.4895627070510d+01,
     |  -1.6957519450238d+02,-7.2323750700180d+01, 8.8139992070409d+01,
     |   1.4336384619729d+02, 4.5898705621628d+01,-9.3049418286762d+01,
     |  -1.2700604297352d+02,-2.5775148858768d+01, 9.9105298379028d+01,
     |   1.1536715320730d+02, 8.3360169590260d+00,-1.0639095670427d+02,
     |  -1.0639095670427d+02, 8.3360169590258d+00, 1.1536715320730d+02,
     |   9.9105298379028d+01,-2.5775148858767d+01,-1.2700604297352d+02,
     |  -9.3049418286762d+01, 4.5898705621628d+01, 1.4336384619729d+02,
     |   8.8139992070410d+01,-7.2323750700180d+01,-1.6957519450238d+02,
     |  -8.4895627070510d+01, 1.1541061163928d+02, 2.2385968246845d+02,
     |   8.5613027100860d+01,-2.3995140365721d+02,-5.1134169787836d+02/
      data (lpmn(lat, 1,12), lat = 1,36)/
     |   3.4305255706605d+02,-1.9744604373941d+02,-2.0739211844303d+02,
     |  -3.5173029922089d+00, 1.6849837619121d+02, 1.5147628765830d+02,
     |  -1.1412093523136d+01,-1.4364794265786d+02,-1.1777555576305d+02,
     |   2.5715052289985d+01, 1.3221544637087d+02, 9.5396047020249d+01,
     |  -3.8695196125145d+01,-1.2653264905644d+02,-7.8382671484305d+01,
     |   5.1216934699466d+01, 1.2410708412087d+02, 6.4126206203519d+01,
     |  -6.4126206203519d+01,-1.2410708412087d+02,-5.1216934699467d+01,
     |   7.8382671484305d+01, 1.2653264905644d+02, 3.8695196125145d+01,
     |  -9.5396047020248d+01,-1.3221544637087d+02,-2.5715052289985d+01,
     |   1.1777555576305d+02, 1.4364794265786d+02, 1.1412093523137d+01,
     |  -1.5147628765830d+02,-1.6849837619121d+02, 3.5173029922078d+00,
     |   2.0739211844303d+02, 1.9744604373941d+02,-3.4305255706605d+02/
      data (lpmn(lat, 2,12), lat = 1,36)/
     |   2.4768220370141d+02, 7.3733511668120d+01,-1.1806813870856d+02,
     |  -1.6280544349563d+02,-3.9262707740538d+01, 1.1770466958884d+02,
     |   1.5282359352662d+02, 3.9177699844709d+01,-1.0355606957974d+02,
     |  -1.3382376548566d+02,-2.8468015182757d+01, 9.9803164292748d+01,
     |   1.2049583578957d+02, 1.6907540463496d+01,-1.0083310022342d+02,
     |  -1.1119749039705d+02,-5.5897023280795d+00, 1.0477119444074d+02,
     |   1.0477119444074d+02,-5.5897023280793d+00,-1.1119749039705d+02,
     |  -1.0083310022342d+02, 1.6907540463496d+01, 1.2049583578957d+02,
     |   9.9803164292748d+01,-2.8468015182757d+01,-1.3382376548566d+02,
     |  -1.0355606957974d+02, 3.9177699844709d+01, 1.5282359352662d+02,
     |   1.1770466958884d+02,-3.9262707740538d+01,-1.6280544349563d+02,
     |  -1.1806813870856d+02, 7.3733511668120d+01, 2.4768220370141d+02/
      data (lpmn(lat, 3,12), lat = 1,36)/
     |   5.2177579246254d+01, 9.8931721592153d+01, 3.2601017630299d+01,
     |  -8.3817164478246d+01,-1.3095223177900d+02,-5.4194351671306d+01,
     |   7.8262587833633d+01, 1.4018079835271d+02, 7.1573151276644d+01,
     |  -6.1139584217371d+01,-1.2969486185494d+02,-6.9832558213018d+01,
     |   5.6254843906597d+01, 1.2264623448907d+02, 6.4904448038338d+01,
     |  -5.6857383775134d+01,-1.1937965076419d+02,-6.0170828545219d+01,
     |   6.0170828545219d+01, 1.1937965076419d+02, 5.6857383775135d+01,
     |  -6.4904448038338d+01,-1.2264623448907d+02,-5.6254843906597d+01,
     |   6.9832558213018d+01, 1.2969486185494d+02, 6.1139584217371d+01,
     |  -7.1573151276644d+01,-1.4018079835271d+02,-7.8262587833633d+01,
     |   5.4194351671306d+01, 1.3095223177900d+02, 8.3817164478246d+01,
     |  -3.2601017630298d+01,-9.8931721592153d+01,-5.2177579246254d+01/
      data (lpmn(lat, 4,12), lat = 1,36)/
     |   6.1857209291805d+00, 4.2372023076652d+01, 6.1084151065337d+01,
     |   1.8160361815280d+01,-6.3599457053459d+01,-1.0789992876940d+02,
     |  -6.0871365317111d+01, 4.7175409572623d+01, 1.2147767266143d+02,
     |   9.0873068745734d+01,-2.0500494280416d+01,-1.1115070365687d+02,
     |  -9.6810821591923d+01, 8.3158516529987d+00, 1.0364974635557d+02,
     |   9.8091486617023d+01,-2.2306603186338d+00,-9.9724043554716d+01,
     |  -9.9724043554716d+01,-2.2306603186339d+00, 9.8091486617022d+01,
     |   1.0364974635557d+02, 8.3158516529989d+00,-9.6810821591924d+01,
     |  -1.1115070365687d+02,-2.0500494280416d+01, 9.0873068745734d+01,
     |   1.2147767266143d+02, 4.7175409572623d+01,-6.0871365317111d+01,
     |  -1.0789992876940d+02,-6.3599457053459d+01, 1.8160361815280d+01,
     |   6.1084151065337d+01, 4.2372023076652d+01, 6.1857209291804d+00/
      data (lpmn(lat, 5,12), lat = 1,36)/
     |   4.9646582334324d-01, 1.1098113549517d+01, 3.3959148372736d+01,
     |   4.3270907457826d+01, 1.2180761985719d+01,-4.9062202670328d+01,
     |  -9.0004483732709d+01,-6.3866256364245d+01, 2.1411139709125d+01,
     |   9.9282178039973d+01, 9.9904149367521d+01, 1.6609290732216d+01,
     |  -8.1399510392433d+01,-1.0775664619259d+02,-3.7929242351263d+01,
     |   6.5710705526192d+01, 1.0903579022624d+02, 5.2368128929708d+01,
     |  -5.2368128929707d+01,-1.0903579022624d+02,-6.5710705526193d+01,
     |   3.7929242351263d+01, 1.0775664619258d+02, 8.1399510392433d+01,
     |  -1.6609290732215d+01,-9.9904149367521d+01,-9.9282178039973d+01,
     |  -2.1411139709125d+01, 6.3866256364245d+01, 9.0004483732709d+01,
     |   4.9062202670328d+01,-1.2180761985719d+01,-4.3270907457826d+01,
     |  -3.3959148372736d+01,-1.1098113549517d+01,-4.9646582334324d-01/
      data (lpmn(lat, 6,12), lat = 1,36)/
     |   2.9342905744680d-02, 2.0640925003058d+00, 1.1824214314209d+01,
     |   2.7599624566046d+01, 3.2996916362163d+01, 1.0050010765351d+01,
     |  -3.7080914511751d+01,-7.4859111489404d+01,-6.4620659115516d+01,
     |  -8.2624428417155d-01, 7.4144631495594d+01, 9.9377417796579d+01,
     |   4.8232207908489d+01,-4.2883815789493d+01,-1.0022854980775d+02,
     |  -7.4725544102925d+01, 1.3672250424861d+01, 9.0639020573748d+01,
     |   9.0639020573748d+01, 1.3672250424861d+01,-7.4725544102925d+01,
     |  -1.0022854980775d+02,-4.2883815789494d+01, 4.8232207908489d+01,
     |   9.9377417796579d+01, 7.4144631495594d+01,-8.2624428417144d-01,
     |  -6.4620659115516d+01,-7.4859111489404d+01,-3.7080914511751d+01,
     |   1.0050010765351d+01, 3.2996916362163d+01, 2.7599624566046d+01,
     |   1.1824214314209d+01, 2.0640925003058d+00, 2.9342905744680d-02/
      data (lpmn(lat, 7,12), lat = 1,36)/
     |   1.3339543655321d-03, 2.9030582436733d-01, 2.9711317140529d+00,
     |   1.1084245085654d+01, 2.2546186865610d+01, 2.6413340489451d+01,
     |   9.9783235035333d+00,-2.6264845957544d+01,-6.0805543810541d+01,
     |  -6.3109405140837d+01,-2.0013085494405d+01, 4.6228804641984d+01,
     |   8.8552769235607d+01, 7.0854769392736d+01, 5.3131973974244d-01,
     |  -7.2149534966428d+01,-9.1396077441375d+01,-4.0981321102794d+01,
     |   4.0981321102794d+01, 9.1396077441375d+01, 7.2149534966428d+01,
     |  -5.3131973974233d-01,-7.0854769392736d+01,-8.8552769235607d+01,
     |  -4.6228804641984d+01, 2.0013085494405d+01, 6.3109405140837d+01,
     |   6.0805543810541d+01, 2.6264845957544d+01,-9.9783235035332d+00,
     |  -2.6413340489451d+01,-2.2546186865609d+01,-1.1084245085654d+01,
     |  -2.9711317140529d+00,-2.9030582436733d-01,-1.3339543655321d-03/
      data (lpmn(lat, 8,12), lat = 1,36)/
     |   4.7638655845573d-05, 3.1780127165530d-02, 5.6800816755811d-01,
     |   3.2183162672510d+00, 9.6850708152465d+00, 1.8309042277939d+01,
     |   2.1805370667662d+01, 1.0975258211495d+01,-1.6019474372708d+01,
     |  -4.6660904549139d+01,-5.8463932546494d+01,-3.5223919497781d+01,
     |   1.6534650844356d+01, 6.6356216495971d+01, 7.8915073743993d+01,
     |   4.0937398951142d+01,-2.5538481594840d+01,-7.6291787121840d+01,
     |  -7.6291787121840d+01,-2.5538481594840d+01, 4.0937398951142d+01,
     |   7.8915073743993d+01, 6.6356216495971d+01, 1.6534650844356d+01,
     |  -3.5223919497781d+01,-5.8463932546494d+01,-4.6660904549139d+01,
     |  -1.6019474372709d+01, 1.0975258211494d+01, 2.1805370667662d+01,
     |   1.8309042277939d+01, 9.6850708152465d+00, 3.2183162672510d+00,
     |   5.6800816755812d-01, 3.1780127165530d-02, 4.7638655845573d-05/
      data (lpmn(lat, 9,12), lat = 1,36)/
     |   1.3421501666111d-06, 2.7294364835999d-03, 8.4105989310497d-02,
     |   7.0571729260016d-01, 2.9819526259351d+00, 7.9431916497713d+00,
     |   1.4545007202288d+01, 1.8161530360817d+01, 1.2242637052527d+01,
     |  -6.3254050094009d+00,-3.1742800208146d+01,-4.9385620340161d+01,
     |  -4.4012453021524d+01,-1.1724504860581d+01, 3.3577262496351d+01,
     |   6.6116273305216d+01, 6.4385762619384d+01, 2.6567564263531d+01,
     |  -2.6567564263531d+01,-6.4385762619384d+01,-6.6116273305216d+01,
     |  -3.3577262496351d+01, 1.1724504860581d+01, 4.4012453021524d+01,
     |   4.9385620340161d+01, 3.1742800208146d+01, 6.3254050094009d+00,
     |  -1.2242637052527d+01,-1.8161530360817d+01,-1.4545007202288d+01,
     |  -7.9431916497713d+00,-2.9819526259351d+00,-7.0571729260016d-01,
     |  -8.4105989310498d-02,-2.7294364835999d-03,-1.3421501666110d-06/
      data (lpmn(lat,10,12), lat = 1,36)/
     |   2.9413121429938d-08, 1.8169280594790d-04, 9.5760923249258d-03,
     |   1.1728134470624d-01, 6.7790424350142d-01, 2.4174620634762d+00,
     |   6.0123500329492d+00, 1.0994536412550d+01, 1.4738500940482d+01,
     |   1.2924092814704d+01, 2.1937195343353d+00,-1.6230044780066d+01,
     |  -3.4876678595767d+01,-4.2729934508797d+01,-3.1744451745449d+01,
     |  -3.1917394335271d+00, 3.1050298199400d+01, 5.4197062384344d+01,
     |   5.4197062384344d+01, 3.1050298199400d+01,-3.1917394335270d+00,
     |  -3.1744451745449d+01,-4.2729934508797d+01,-3.4876678595767d+01,
     |  -1.6230044780066d+01, 2.1937195343353d+00, 1.2924092814704d+01,
     |   1.4738500940482d+01, 1.0994536412550d+01, 6.0123500329492d+00,
     |   2.4174620634762d+00, 6.7790424350142d-01, 1.1728134470624d-01,
     |   9.5760923249260d-03, 1.8169280594790d-04, 2.9413121429938d-08/
      data (lpmn(lat,11,12), lat = 1,36)/
     |   4.7933350978619d-10, 8.9723008351553d-06, 8.0456058639788d-04,
     |   1.4251646673391d-02, 1.1099369253961d-01, 5.1640253424624d-01,
     |   1.6626604501870d+00, 4.0025906645354d+00, 7.4853263553697d+00,
     |   1.0947340961010d+01, 1.2023450288393d+01, 8.0955571320970d+00,
     |  -1.8978966818648d+00,-1.5860808067758d+01,-2.8520198094489d+01,
     |  -3.3584691083797d+01,-2.7170715007016d+01,-1.0436227195122d+01,
     |   1.0436227195122d+01, 2.7170715007016d+01, 3.3584691083797d+01,
     |   2.8520198094489d+01, 1.5860808067758d+01, 1.8978966818648d+00,
     |  -8.0955571320969d+00,-1.2023450288393d+01,-1.0947340961010d+01,
     |  -7.4853263553698d+00,-4.0025906645354d+00,-1.6626604501870d+00,
     |  -5.1640253424624d-01,-1.1099369253961d-01,-1.4251646673391d-02,
     |  -8.0456058639789d-04,-8.9723008351553d-06,-4.7933350978619d-10/
      data (lpmn(lat,12,12), lat = 1,36)/
     |   5.0859600432251d-12, 2.8797813051660d-07, 4.3774536573535d-05,
     |   1.1145962860918d-03, 1.1583677870825d-02, 6.9257590162268d-02,
     |   2.8167895116432d-01, 8.5512269731916d-01, 2.0467496293617d+00,
     |   3.9879992326547d+00, 6.4232941837073d+00, 8.5386134868096d+00,
     |   9.0988107510560d+00, 6.9746242838464d+00, 1.8612010724237d+00,
     |  -5.2394385137292d+00,-1.2168762742207d+01,-1.6454305793701d+01,
     |  -1.6454305793701d+01,-1.2168762742207d+01,-5.2394385137292d+00,
     |   1.8612010724237d+00, 6.9746242838464d+00, 9.0988107510560d+00,
     |   8.5386134868096d+00, 6.4232941837073d+00, 3.9879992326547d+00,
     |   2.0467496293617d+00, 8.5512269731916d-01, 2.8167895116432d-01,
     |   6.9257590162268d-02, 1.1583677870825d-02, 1.1145962860918d-03,
     |   4.3774536573536d-05, 2.8797813051660d-07, 5.0859600432251d-12/
      data (lpmn(lat, 0,13), lat = 1,36)/
     |  -6.1202127410739d+02,-2.4030676843153d+02, 1.6191760331304d+02,
     |   2.6017956465377d+02, 5.0725585808166d+01,-1.7530161746487d+02,
     |  -1.6609558257689d+02, 3.4090337167315d+01, 1.7279515808618d+02,
     |   9.5082228901398d+01,-8.9567539722375d+01,-1.5518956579880d+02,
     |  -3.0792780873706d+01, 1.2524572012386d+02, 1.2383024739986d+02,
     |  -2.8366723628010d+01,-1.4295350674372d+02,-8.0736575755151d+01,
     |   8.0736575755151d+01, 1.4295350674372d+02, 2.8366723628011d+01,
     |  -1.2383024739986d+02,-1.2524572012386d+02, 3.0792780873707d+01,
     |   1.5518956579880d+02, 8.9567539722375d+01,-9.5082228901398d+01,
     |  -1.7279515808618d+02,-3.4090337167315d+01, 1.6609558257689d+02,
     |   1.7530161746487d+02,-5.0725585808166d+01,-2.6017956465377d+02,
     |  -1.6191760331305d+02, 2.4030676843153d+02, 6.1202127410739d+02/
      data (lpmn(lat, 1,13), lat = 1,36)/
     |   3.5574727752569d+02,-2.6346304617490d+02,-2.1331599375896d+02,
     |   7.0061950542453d+01, 2.2554857424231d+02, 1.0686894514625d+02,
     |  -1.1526280320511d+02,-1.7892203334388d+02,-2.8935817199190d+01,
     |   1.4177739014437d+02, 1.3265211190789d+02,-3.3369308076567d+01,
     |  -1.5077986089971d+02,-8.2054812013960d+01, 8.3277592539737d+01,
     |   1.4328892683001d+02, 2.7802578549977d+01,-1.2035536325668d+02,
     |  -1.2035536325668d+02, 2.7802578549976d+01, 1.4328892683001d+02,
     |   8.3277592539737d+01,-8.2054812013960d+01,-1.5077986089971d+02,
     |  -3.3369308076568d+01, 1.3265211190789d+02, 1.4177739014437d+02,
     |  -2.8935817199189d+01,-1.7892203334388d+02,-1.1526280320511d+02,
     |   1.0686894514625d+02, 2.2554857424231d+02, 7.0061950542454d+01,
     |  -2.1331599375896d+02,-2.6346304617490d+02, 3.5574727752569d+02/
      data (lpmn(lat, 2,13), lat = 1,36)/
     |   2.9533288924797d+02, 5.7622293491866d+01,-1.7269005971786d+02,
     |  -1.7133684882762d+02, 2.8328171312439d+01, 1.8627727698853d+02,
     |   1.2889982229604d+02,-6.5436697969773d+01,-1.6992108386401d+02,
     |  -7.2970007118159d+01, 1.0169158600078d+02, 1.4813270270320d+02,
     |   1.8644560642941d+01,-1.2766499148404d+02,-1.1766476873488d+02,
     |   3.2519257314225d+01, 1.4106794081538d+02, 7.8625875858297d+01,
     |  -7.8625875858297d+01,-1.4106794081538d+02,-3.2519257314225d+01,
     |   1.1766476873488d+02, 1.2766499148404d+02,-1.8644560642942d+01,
     |  -1.4813270270320d+02,-1.0169158600078d+02, 7.2970007118159d+01,
     |   1.6992108386401d+02, 6.5436697969773d+01,-1.2889982229604d+02,
     |  -1.8627727698853d+02,-2.8328171312439d+01, 1.7133684882762d+02,
     |   1.7269005971786d+02,-5.7622293491866d+01,-2.9533288924796d+02/
      data (lpmn(lat, 3,13), lat = 1,36)/
     |   6.7987842732613d+01, 1.1752022303177d+02, 1.1010276023860d+01,
     |  -1.3226406977091d+02,-1.4089577105189d+02, 7.1858438404640d+00,
     |   1.5319432625807d+02, 1.3547269761633d+02,-2.5965280508877d+01,
     |  -1.5076539178817d+02,-1.0223677685294d+02, 5.8964660012264d+01,
     |   1.4672609661767d+02, 6.3263592494646d+01,-9.0963656339474d+01,
     |  -1.3607710672755d+02,-2.1412782103228d+01, 1.1733127898995d+02,
     |   1.1733127898995d+02,-2.1412782103227d+01,-1.3607710672755d+02,
     |  -9.0963656339474d+01, 6.3263592494646d+01, 1.4672609661767d+02,
     |   5.8964660012265d+01,-1.0223677685294d+02,-1.5076539178817d+02,
     |  -2.5965280508878d+01, 1.3547269761633d+02, 1.5319432625807d+02,
     |   7.1858438404640d+00,-1.4089577105189d+02,-1.3226406977091d+02,
     |   1.1010276023859d+01, 1.1752022303177d+02, 6.7987842732613d+01/
      data (lpmn(lat, 4,13), lat = 1,36)/
     |   8.7853165901518d+00, 5.7190090371848d+01, 7.0199413698765d+01,
     |  -5.4364863894109d+00,-1.0801737746981d+02,-1.1932696268017d+02,
     |  -5.8641408408598d+00, 1.2550358823675d+02, 1.3484686367324d+02,
     |   6.2354795415852d+00,-1.2594578869186d+02,-1.2002556317091d+02,
     |   1.5980099863079d+01, 1.3108099838921d+02, 9.8221624680732d+01,
     |  -4.4036911218072d+01,-1.3493148232857d+02,-7.2335672328418d+01,
     |   7.2335672328418d+01, 1.3493148232857d+02, 4.4036911218073d+01,
     |  -9.8221624680732d+01,-1.3108099838921d+02,-1.5980099863078d+01,
     |   1.2002556317091d+02, 1.2594578869186d+02,-6.2354795415850d+00,
     |  -1.3484686367324d+02,-1.2550358823675d+02, 5.8641408408592d+00,
     |   1.1932696268017d+02, 1.0801737746981d+02, 5.4364863894112d+00,
     |  -7.0199413698765d+01,-5.7190090371848d+01,-8.7853165901518d+00/
      data (lpmn(lat, 5,13), lat = 1,36)/
     |   7.7076956113484d-01, 1.6640155333854d+01, 4.6695766165352d+01,
     |   4.7299375331666d+01,-1.1919781898177d+01,-9.0625229426522d+01,
     |  -1.0362544218914d+02,-1.5967525711609d+01, 1.0093648323779d+02,
     |   1.3016714749077d+02, 3.3659412726450d+01,-9.6628606185523d+01,
     |  -1.2752587034264d+02,-2.5798820765245d+01, 1.0195240364868d+02,
     |   1.2005050932711d+02, 9.3208770505430d+00,-1.1093221751303d+02,
     |  -1.1093221751303d+02, 9.3208770505429d+00, 1.2005050932711d+02,
     |   1.0195240364868d+02,-2.5798820765244d+01,-1.2752587034264d+02,
     |  -9.6628606185524d+01, 3.3659412726450d+01, 1.3016714749077d+02,
     |   1.0093648323779d+02,-1.5967525711609d+01,-1.0362544218914d+02,
     |  -9.0625229426522d+01,-1.1919781898177d+01, 4.7299375331666d+01,
     |   4.6695766165352d+01, 1.6640155333854d+01, 7.7076956113484d-01/
      data (lpmn(lat, 6,13), lat = 1,36)/
     |   5.0080864073527d-02, 3.4313531132755d+00, 1.8518089597924d+01,
     |   3.8431844591169d+01, 3.4120095500544d+01,-1.3537289730245d+01,
     |  -7.6499960424028d+01,-9.1702458852160d+01,-2.5277846723836d+01,
     |   7.7466390434569d+01, 1.2201212234837d+02, 5.7395230177291d+01,
     |  -6.2738094877859d+01,-1.2383773825052d+02,-6.3806948125459d+01,
     |   5.9676383109689d+01, 1.2312099229848d+02, 6.2008505558856d+01,
     |  -6.2008505558856d+01,-1.2312099229848d+02,-5.9676383109690d+01,
     |   6.3806948125459d+01, 1.2383773825052d+02, 6.2738094877859d+01,
     |  -5.7395230177291d+01,-1.2201212234837d+02,-7.7466390434570d+01,
     |   2.5277846723835d+01, 9.1702458852159d+01, 7.6499960424028d+01,
     |   1.3537289730245d+01,-3.4120095500543d+01,-3.8431844591169d+01,
     |  -1.8518089597924d+01,-3.4313531132755d+00,-5.0080864073527d-02/
      data (lpmn(lat, 7,13), lat = 1,36)/
     |   2.5245175355104d-03, 5.3793973618885d-01, 5.2596468921990d+00,
     |   1.8107275248979d+01, 3.1859104429605d+01, 2.6135952292297d+01,
     |  -1.2190017494374d+01,-6.3869169708052d+01,-8.1955128895230d+01,
     |  -3.4481559025987d+01, 5.3564396238564d+01, 1.0947688021124d+02,
     |   7.6791636235019d+01,-2.4424065059044d+01,-1.0644718571225d+02,
     |  -9.2720909459872d+01, 6.7460347552012d+00, 1.0038073946532d+02,
     |   1.0038073946532d+02, 6.7460347552014d+00,-9.2720909459872d+01,
     |  -1.0644718571225d+02,-2.4424065059044d+01, 7.6791636235020d+01,
     |   1.0947688021124d+02, 5.3564396238564d+01,-3.4481559025987d+01,
     |  -8.1955128895230d+01,-6.3869169708053d+01,-1.2190017494374d+01,
     |   2.6135952292297d+01, 3.1859104429605d+01, 1.8107275248979d+01,
     |   5.2596468921991d+00, 5.3793973618885d-01, 2.5245175355104d-03/
      data (lpmn(lat, 8,13), lat = 1,36)/
     |   1.0124206884365d-04, 6.6363896446577d-02, 1.1429496130872d+00,
     |   6.0888694757641d+00, 1.6612656535019d+01, 2.6551406891110d+01,
     |   2.1350961421578d+01,-8.8038928353686d+00,-5.1641065272899d+01,
     |  -7.2894325270817d+01,-4.3236006060545d+01, 2.8395352254615d+01,
     |   9.0776106750792d+01, 8.9073092936095d+01, 1.6248591015677d+01,
     |  -7.2640379729824d+01,-1.0337157054114d+02,-4.7949478642851d+01,
     |   4.7949478642851d+01, 1.0337157054114d+02, 7.2640379729824d+01,
     |  -1.6248591015677d+01,-8.9073092936095d+01,-9.0776106750792d+01,
     |  -2.8395352254615d+01, 4.3236006060545d+01, 7.2894325270817d+01,
     |   5.1641065272899d+01, 8.8038928353687d+00,-2.1350961421578d+01,
     |  -2.6551406891110d+01,-1.6612656535019d+01,-6.0888694757642d+00,
     |  -1.1429496130873d+00,-6.6363896446577d-02,-1.0124206884364d-04/
      data (lpmn(lat, 9,13), lat = 1,36)/
     |   3.2650532233822d-06, 6.5409312537006d-03, 1.9535892569981d-01,
     |   1.5588737227724d+00, 6.1103486851509d+00, 1.4542661541489d+01,
     |   2.2152452608930d+01, 1.8589374070364d+01,-4.0011498319294d+00,
     |  -3.9054710984928d+01,-6.2934468191857d+01,-5.0138435432685d+01,
     |   2.3483691346127d+00, 6.4084782952613d+01, 8.9151699084622d+01,
     |   5.2971512700400d+01,-2.3130913824286d+01,-8.4249564056381d+01,
     |  -8.4249564056381d+01,-2.3130913824286d+01, 5.2971512700400d+01,
     |   8.9151699084622d+01, 6.4084782952613d+01, 2.3483691346124d+00,
     |  -5.0138435432685d+01,-6.2934468191857d+01,-3.9054710984928d+01,
     |  -4.0011498319294d+00, 1.8589374070363d+01, 2.2152452608930d+01,
     |   1.4542661541489d+01, 6.1103486851509d+00, 1.5588737227724d+00,
     |   1.9535892569981d-01, 6.5409312537006d-03, 3.2650532233822d-06/
      data (lpmn(lat,10,13), lat = 1,36)/
     |   8.4499069408625d-08, 5.1517558851142d-04, 2.6429641315768d-02,
     |   3.1020579845789d-01, 1.6863116917047d+00, 5.5166270508250d+00,
     |   1.2124968212183d+01, 1.8301569575553d+01, 1.6924301929286d+01,
     |   1.5642831573578d+00,-2.5696639735535d+01,-5.0412886400421d+01,
     |  -5.2545880424540d+01,-2.1928913089144d+01, 2.9427652593819d+01,
     |   7.0819498648176d+01, 7.3011741479238d+01, 3.0787901803115d+01,
     |  -3.0787901803114d+01,-7.3011741479238d+01,-7.0819498648176d+01,
     |  -2.9427652593819d+01, 2.1928913089144d+01, 5.2545880424540d+01,
     |   5.0412886400421d+01, 2.5696639735535d+01,-1.5642831573577d+00,
     |  -1.6924301929286d+01,-1.8301569575553d+01,-1.2124968212183d+01,
     |  -5.5166270508250d+00,-1.6863116917047d+00,-3.1020579845790d-01,
     |  -2.6429641315768d-02,-5.1517558851142d-04,-8.4499069408625d-08/
      data (lpmn(lat,11,13), lat = 1,36)/
     |   1.7231148248650d-09, 3.1881040864907d-05, 2.7917384155863d-03,
     |   4.7656910942597d-02, 3.5230403374127d-01, 1.5273672760252d+00,
     |   4.4724444639003d+00, 9.4508122382633d+00, 1.4603630593403d+01,
     |   1.5425485258436d+01, 6.9203358273225d+00,-1.1842721298124d+01,
     |  -3.4076080007026d+01,-4.6752301703958d+01,-3.8232993294885d+01,
     |  -7.5486506757554d+00, 3.2089639369167d+01, 5.9741766329715d+01,
     |   5.9741766329715d+01, 3.2089639369167d+01,-7.5486506757552d+00,
     |  -3.8232993294885d+01,-4.6752301703958d+01,-3.4076080007025d+01,
     |  -1.1842721298124d+01, 6.9203358273225d+00, 1.5425485258436d+01,
     |   1.4603630593403d+01, 9.4508122382633d+00, 4.4724444639004d+00,
     |   1.5273672760252d+00, 3.5230403374127d-01, 4.7656910942598d-02,
     |   2.7917384155864d-03, 3.1881040864907d-05, 1.7231148248650d-09/
      data (lpmn(lat,12,13), lat = 1,36)/
     |   2.6393181732154d-11, 1.4789270317778d-06, 2.2008873410058d-04,
     |   5.4235846643051d-03, 5.3861160627537d-02, 3.0323177835099d-01,
     |   1.1408017709689d+00, 3.1310522172157d+00, 6.5629136819287d+00,
     |   1.0657645236178d+01, 1.3060338336225d+01, 1.0493432540993d+01,
     |   8.2610948590405d-01,-1.4509623987535d+01,-2.9746269434444d+01,
     |  -3.7015523826155d+01,-3.0831328488621d+01,-1.1998991453276d+01,
     |   1.1998991453276d+01, 3.0831328488621d+01, 3.7015523826155d+01,
     |   2.9746269434444d+01, 1.4509623987535d+01,-8.2610948590407d-01,
     |  -1.0493432540993d+01,-1.3060338336225d+01,-1.0657645236178d+01,
     |  -6.5629136819287d+00,-3.1310522172157d+00,-1.1408017709689d+00,
     |  -3.0323177835099d-01,-5.3861160627537d-02,-5.4235846643052d-03,
     |  -2.2008873410059d-04,-1.4789270317778d-06,-2.6393181732154d-11/
      data (lpmn(lat,13,13), lat = 1,36)/
     |   2.6532442633948d-13, 4.4959856538614d-08, 1.1334832212961d-05,
     |   4.0110474470840d-04, 5.3074982494979d-03, 3.8314535206560d-02,
     |   1.8149230044724d-01, 6.2505078449102d-01, 1.6633118519698d+00,
     |   3.5462611543556d+00, 6.1718735248387d+00, 8.7838114310127d+00,
     |   9.9820673326995d+00, 8.2663165509459d+00, 2.9692080757575d+00,
     |  -4.9704945112663d+00,-1.3027547528818d+01,-1.8112368044757d+01,
     |  -1.8112368044757d+01,-1.3027547528818d+01,-4.9704945112663d+00,
     |   2.9692080757575d+00, 8.2663165509459d+00, 9.9820673326995d+00,
     |   8.7838114310127d+00, 6.1718735248387d+00, 3.5462611543556d+00,
     |   1.6633118519698d+00, 6.2505078449103d-01, 1.8149230044724d-01,
     |   3.8314535206560d-02, 5.3074982494979d-03, 4.0110474470841d-04,
     |   1.1334832212962d-05, 4.4959856538614d-08, 2.6532442633948d-13/
      data (lpmn(lat, 0,14), lat = 1,36)/
     |  -7.2169753915641d+02,-2.2641457447274d+02, 2.4930607658228d+02,
     |   2.7087973943018d+02,-4.7296830272636d+01,-2.4431015209915d+02,
     |  -9.4766006061722d+01, 1.5974212656480d+02, 1.7514562572128d+02,
     |  -4.4865694500931d+01,-1.8754028189066d+02,-6.7028612601578d+01,
     |   1.3819607275967d+02, 1.4523674471852d+02,-4.7549087676115d+01,
     |  -1.6947724298557d+02,-5.4254875022393d+01, 1.3511143983785d+02,
     |   1.3511143983785d+02,-5.4254875022393d+01,-1.6947724298557d+02,
     |  -4.7549087676115d+01, 1.4523674471852d+02, 1.3819607275967d+02,
     |  -6.7028612601576d+01,-1.8754028189066d+02,-4.4865694500931d+01,
     |   1.7514562572128d+02, 1.5974212656480d+02,-9.4766006061721d+01,
     |  -2.4431015209915d+02,-4.7296830272636d+01, 2.7087973943018d+02,
     |   2.4930607658228d+02,-2.2641457447274d+02,-7.2169753915641d+02/
      data (lpmn(lat, 1,14), lat = 1,36)/
     |   3.6130546645695d+02,-3.3535454615955d+02,-1.9958012977162d+02,
     |   1.6065347692288d+02, 2.5488025485779d+02, 1.4476030759364d+01,
     |  -2.0989966417485d+02,-1.3467343481139d+02, 1.0966939021214d+02,
     |   1.8705288723741d+02, 8.5331468931493d+00,-1.7017630364086d+02,
     |  -1.0894302996230d+02, 9.7945496914140d+01, 1.6362248072585d+02,
     |   2.7176606891301d+00,-1.5890081422876d+02,-9.8587834710335d+01,
     |   9.8587834710335d+01, 1.5890081422876d+02,-2.7176606891291d+00,
     |  -1.6362248072585d+02,-9.7945496914140d+01, 1.0894302996230d+02,
     |   1.7017630364086d+02,-8.5331468931493d+00,-1.8705288723741d+02,
     |  -1.0966939021214d+02, 1.3467343481139d+02, 2.0989966417485d+02,
     |  -1.4476030759364d+01,-2.5488025485779d+02,-1.6065347692288d+02,
     |   1.9958012977161d+02, 3.3535454615955d+02,-3.6130546645694d+02/
      data (lpmn(lat, 2,14), lat = 1,36)/
     |   3.4671682324506d+02, 3.1009938479660d+01,-2.3111144064071d+02,
     |  -1.5596987477809d+02, 1.1807037920194d+02, 2.2714340567741d+02,
     |   4.5546646017273d+01,-1.7564686802245d+02,-1.5256923197452d+02,
     |   6.6640228520162d+01, 1.8362430706967d+02, 5.0816203657298d+01,
     |  -1.4321810031126d+02,-1.3714532242452d+02, 5.3817917606517d+01,
     |   1.6696934016991d+02, 5.0600039462948d+01,-1.3375696965460d+02,
     |  -1.3375696965460d+02, 5.0600039462947d+01, 1.6696934016991d+02,
     |   5.3817917606517d+01,-1.3714532242452d+02,-1.4321810031126d+02,
     |   5.0816203657297d+01, 1.8362430706967d+02, 6.6640228520162d+01,
     |  -1.5256923197452d+02,-1.7564686802245d+02, 4.5546646017272d+01,
     |   2.2714340567741d+02, 1.1807037920194d+02,-1.5596987477809d+02,
     |  -2.3111144064071d+02, 3.1009938479660d+01, 3.4671682324506d+02/
      data (lpmn(lat, 3,14), lat = 1,36)/
     |   8.6764276013442d+01, 1.3487616046647d+02,-2.2792000832405d+01,
     |  -1.8240245627803d+02,-1.2325790877528d+02, 9.5268546415599d+01,
     |   2.0176448090154d+02, 6.2061393651753d+01,-1.4549003480012d+02,
     |  -1.5919862711718d+02, 2.9829663900989d+01, 1.7132616840867d+02,
     |   8.4415193661447d+01,-1.0991758961794d+02,-1.5363751752301d+02,
     |   7.4684307876601d+00, 1.5602201047056d+02, 9.4136136300160d+01,
     |  -9.4136136300160d+01,-1.5602201047056d+02,-7.4684307876611d+00,
     |   1.5363751752301d+02, 1.0991758961794d+02,-8.4415193661448d+01,
     |  -1.7132616840867d+02,-2.9829663900989d+01, 1.5919862711718d+02,
     |   1.4549003480012d+02,-6.2061393651753d+01,-2.0176448090154d+02,
     |  -9.5268546415599d+01, 1.2325790877528d+02, 1.8240245627803d+02,
     |   2.2792000832406d+01,-1.3487616046647d+02,-8.6764276013441d+01/
      data (lpmn(lat, 4,14), lat = 1,36)/
     |   1.2141410334993d+01, 7.4712336076711d+01, 7.4853338403999d+01,
     |  -4.2242849456163d+01,-1.5214623732097d+02,-9.9939106937327d+01,
     |   8.0298992163194d+01, 1.8028745385734d+02, 7.2385819678469d+01,
     |  -1.1833534508665d+02,-1.5973076376168d+02,-3.1031340067956d+00,
     |   1.5244996831182d+02, 1.1105996128501d+02,-7.0983189350713d+01,
     |  -1.5843239414015d+02,-3.9868175892154d+01, 1.2953563857384d+02,
     |   1.2953563857384d+02,-3.9868175892153d+01,-1.5843239414015d+02,
     |  -7.0983189350713d+01, 1.1105996128501d+02, 1.5244996831182d+02,
     |  -3.1031340067944d+00,-1.5973076376168d+02,-1.1833534508665d+02,
     |   7.2385819678469d+01, 1.8028745385734d+02, 8.0298992163195d+01,
     |  -9.9939106937327d+01,-1.5214623732097d+02,-4.2242849456164d+01,
     |   7.4853338403999d+01, 7.4712336076711d+01, 1.2141410334993d+01/
      data (lpmn(lat, 5,14), lat = 1,36)/
     |   1.1555560915386d+00, 2.4016573907162d+01, 6.1021359798078d+01,
     |   4.4322587660688d+01,-4.9857681444425d+01,-1.3032916437665d+02,
     |  -8.3733238112897d+01, 6.7886451772090d+01, 1.6183926550277d+02,
     |   8.0624407374555d+01,-9.2119811342513d+01,-1.5603107562889d+02,
     |  -3.4067043072442d+01, 1.2688937252754d+02, 1.3072999131443d+02,
     |  -2.6374781107201d+01,-1.4926691438076d+02,-8.5302887775505d+01,
     |   8.5302887775505d+01, 1.4926691438076d+02, 2.6374781107202d+01,
     |  -1.3072999131443d+02,-1.2688937252754d+02, 3.4067043072443d+01,
     |   1.5603107562889d+02, 9.2119811342513d+01,-8.0624407374555d+01,
     |  -1.6183926550277d+02,-6.7886451772090d+01, 8.3733238112897d+01,
     |   1.3032916437665d+02, 4.9857681444425d+01,-4.4322587660688d+01,
     |  -6.1021359798078d+01,-2.4016573907162d+01,-1.1555560915386d+00/
      data (lpmn(lat, 6,14), lat = 1,36)/
     |   8.1786455449411d-02, 5.4457791256072d+00, 2.7497664275732d+01,
     |   4.9521195907329d+01, 2.6218653260160d+01,-5.1492285549241d+01,
     |  -1.1324168357794d+02,-7.3095927147420d+01, 5.5461594679567d+01,
     |   1.4507598875345d+02, 8.8577384578677d+01,-6.4827623423187d+01,
     |  -1.4781677633542d+02,-6.3742365670775d+01, 9.3281272907650d+01,
     |   1.4101208367541d+02, 2.2899401705025d+01,-1.2194736606625d+02,
     |  -1.2194736606625d+02, 2.2899401705025d+01, 1.4101208367541d+02,
     |   9.3281272907650d+01,-6.3742365670775d+01,-1.4781677633542d+02,
     |  -6.4827623423188d+01, 8.8577384578677d+01, 1.4507598875345d+02,
     |   5.5461594679567d+01,-7.3095927147420d+01,-1.1324168357794d+02,
     |  -5.1492285549241d+01, 2.6218653260160d+01, 4.9521195907329d+01,
     |   2.7497664275732d+01, 5.4457791256072d+00, 8.1786455449411d-02/
      data (lpmn(lat, 7,14), lat = 1,36)/
     |   4.5191420578061d-03, 9.4122104843625d-01, 8.7512663928931d+00,
     |   2.7478453315180d+01, 4.0160364484351d+01, 1.5274364369344d+01,
     |  -4.9407167073547d+01,-9.9124162762752d+01,-6.6908157526246d+01,
     |   4.1615455259580d+01, 1.2842092248662d+02, 9.6490380702926d+01,
     |  -3.4846340470959d+01,-1.3313260314219d+02,-9.0809473631348d+01,
     |   5.0210570774703d+01, 1.3664485640085d+02, 7.2257110639447d+01,
     |  -7.2257110639447d+01,-1.3664485640085d+02,-5.0210570774704d+01,
     |   9.0809473631348d+01, 1.3313260314219d+02, 3.4846340470958d+01,
     |  -9.6490380702926d+01,-1.2842092248662d+02,-4.1615455259580d+01,
     |   6.6908157526246d+01, 9.9124162762752d+01, 4.9407167073547d+01,
     |  -1.5274364369344d+01,-4.0160364484350d+01,-2.7478453315180d+01,
     |  -8.7512663928932d+00,-9.4122104843625d-01,-4.5191420578061d-03/
      data (lpmn(lat, 8,14), lat = 1,36)/
     |   2.0045021348326d-04, 1.2892364973184d-01, 2.1321709734208d+00,
     |   1.0601160867351d+01, 2.5760891383373d+01, 3.2769010236330d+01,
     |   9.1901022929774d+00,-4.4660463471852d+01,-8.6826458381211d+01,
     |  -6.4122285126223d+01, 2.5539188467430d+01, 1.0997331164828d+02,
     |   1.0311377373504d+02,-1.4844142012410d+00,-1.0871978906294d+02,
     |  -1.1084962614067d+02,-1.6267973012665d+00, 1.1005308555977d+02,
     |   1.1005308555977d+02,-1.6267973012663d+00,-1.1084962614067d+02,
     |  -1.0871978906294d+02,-1.4844142012412d+00, 1.0311377373504d+02,
     |   1.0997331164828d+02, 2.5539188467430d+01,-6.4122285126223d+01,
     |  -8.6826458381211d+01,-4.4660463471853d+01, 9.1901022929773d+00,
     |   3.2769010236330d+01, 2.5760891383373d+01, 1.0601160867352d+01,
     |   2.1321709734208d+00, 1.2892364973184d-01, 2.0045021348326d-04/
      data (lpmn(lat, 9,14), lat = 1,36)/
     |   7.2430274131490d-06, 1.4276576906733d-02, 4.1214817068407d-01,
     |   3.1108412983067d+00, 1.1191528553405d+01, 2.3218248225347d+01,
     |   2.7140065997510d+01, 6.6746204916286d+00,-3.7767287807207d+01,
     |  -7.5269933518925d+01,-6.3433320099659d+01, 6.9878799991199d+00,
     |   8.7507323426502d+01, 1.0537156297794d+02, 3.3873688303485d+01,
     |  -7.1105199444239d+01,-1.1526342907091d+02,-5.5341571889247d+01,
     |   5.5341571889247d+01, 1.1526342907091d+02, 7.1105199444240d+01,
     |  -3.3873688303485d+01,-1.0537156297794d+02,-8.7507323426502d+01,
     |  -6.9878799991204d+00, 6.3433320099659d+01, 7.5269933518925d+01,
     |   3.7767287807207d+01,-6.6746204916284d+00,-2.7140065997510d+01,
     |  -2.3218248225347d+01,-1.1191528553405d+01,-3.1108412983067d+00,
     |  -4.1214817068408d-01,-1.4276576906733d-02,-7.2430274131490d-06/
      data (lpmn(lat,10,14), lat = 1,36)/
     |   2.1413416165212d-07, 1.2871936582516d-03, 6.4129621861805d-02,
     |   7.1831023993272d-01, 3.6450754097584d+00, 1.0784973896582d+01,
     |   2.0297730051768d+01, 2.2971674669972d+01, 6.7975713641653d+00,
     |  -2.8975326692896d+01,-6.3211590909029d+01,-6.2922072817592d+01,
     |  -1.3284893500936d+01, 5.8943129561724d+01, 9.8061581053609d+01,
     |   6.5671834678902d+01,-1.9853727261576d+01,-9.2222140780517d+01,
     |  -9.2222140780517d+01,-1.9853727261576d+01, 6.5671834678902d+01,
     |   9.8061581053609d+01, 5.8943129561724d+01,-1.3284893500936d+01,
     |  -6.2922072817592d+01,-6.3211590909029d+01,-2.8975326692896d+01,
     |   6.7975713641653d+00, 2.2971674669972d+01, 2.0297730051768d+01,
     |   1.0784973896582d+01, 3.6450754097584d+00, 7.1831023993273d-01,
     |   6.4129621861806d-02, 1.2871936582516d-03, 2.1413416165212d-07/
      data (lpmn(lat,11,14), lat = 1,36)/
     |   5.1471444770808d-09, 9.4045620925198d-05, 8.0260541704699d-03,
     |   1.3158200389705d-01, 9.1804091268664d-01, 3.6729669723884d+00,
     |   9.6100817849736d+00, 1.7175569759762d+01, 1.9810395744711d+01,
     |   8.6651201742198d+00,-1.8519714967829d+01,-4.9249903620865d+01,
     |  -5.9712545202356d+01,-3.2542787336747d+01, 2.3954204856314d+01,
     |   7.4758655112983d+01, 8.1800011795587d+01, 3.5257203872147d+01,
     |  -3.5257203872147d+01,-8.1800011795587d+01,-7.4758655112983d+01,
     |  -2.3954204856314d+01, 3.2542787336747d+01, 5.9712545202356d+01,
     |   4.9249903620865d+01, 1.8519714967829d+01,-8.6651201742197d+00,
     |  -1.9810395744711d+01,-1.7175569759762d+01,-9.6100817849736d+00,
     |  -3.6729669723884d+00,-9.1804091268664d-01,-1.3158200389705d-01,
     |  -8.0260541704701d-03,-9.4045620925198d-05,-5.1471444770808d-09/
      data (lpmn(lat,12,14), lat = 1,36)/
     |   9.8485900577481d-11, 5.4568450660617d-06, 7.9363525743146d-04,
     |   1.8872220790270d-02, 1.7826135290824d-01, 9.3814201508041d-01,
     |   3.2263231456079d+00, 7.8422139841964d+00, 1.3827015105092d+01,
     |   1.7002723881055d+01, 1.1149834527999d+01,-7.0491911668663d+00,
     |  -3.2267355154165d+01,-5.0002676330690d+01,-4.4719942350474d+01,
     |  -1.2403949308038d+01, 3.2788817094257d+01, 6.5339480147592d+01,
     |   6.5339480147592d+01, 3.2788817094257d+01,-1.2403949308038d+01,
     |  -4.4719942350474d+01,-5.0002676330690d+01,-3.2267355154165d+01,
     |  -7.0491911668664d+00, 1.1149834527999d+01, 1.7002723881055d+01,
     |   1.3827015105092d+01, 7.8422139841964d+00, 3.2263231456079d+00,
     |   9.3814201508041d-01, 1.7826135290824d-01, 1.8872220790270d-02,
     |   7.9363525743147d-04, 5.4568450660617d-06, 9.8485900577481d-11/
      data (lpmn(lat,13,14), lat = 1,36)/
     |   1.4270049433640d-12, 2.3935465712028d-07, 5.9105944402591d-05,
     |   2.0258509399651d-03, 2.5645430233976d-02, 1.7462503334245d-01,
     |   7.6708744065602d-01, 2.3975668838550d+00, 5.6217974013947d+00,
     |   1.0099366414880d+01, 1.3684106013770d+01, 1.2614041692985d+01,
     |   3.6306581494754d+00,-1.2784299629176d+01,-3.0612622379601d+01,
     |  -4.0352298879521d+01,-3.4616765432846d+01,-1.3651061877633d+01,
     |   1.3651061877633d+01, 3.4616765432846d+01, 4.0352298879521d+01,
     |   3.0612622379601d+01, 1.2784299629176d+01,-3.6306581494754d+00,
     |  -1.2614041692985d+01,-1.3684106013770d+01,-1.0099366414880d+01,
     |  -5.6217974013947d+00,-2.3975668838550d+00,-7.6708744065602d-01,
     |  -1.7462503334245d-01,-2.5645430233976d-02,-2.0258509399652d-03,
     |  -5.9105944402592d-05,-2.3935465712028d-07,-1.4270049433640d-12/
      data (lpmn(lat,14,14), lat = 1,36)/
     |   1.3659999863786d-14, 6.9271301570981d-09, 2.8964024445531d-06,
     |   1.4243867961201d-04, 2.3995707575209d-03, 2.0913100368294d-02,
     |   1.1536195673399d-01, 4.5063087059692d-01, 1.3328555787431d+00,
     |   3.1081948568196d+00, 5.8413065296603d+00, 8.8898828152694d+00,
     |   1.0746420981492d+01, 9.5372526355810d+00, 4.1588831741043d+00,
     |  -4.5945131394545d+00,-1.3839130608402d+01,-1.9793226648915d+01,
     |  -1.9793226648915d+01,-1.3839130608402d+01,-4.5945131394546d+00,
     |   4.1588831741043d+00, 9.5372526355810d+00, 1.0746420981492d+01,
     |   8.8898828152694d+00, 5.8413065296603d+00, 3.1081948568196d+00,
     |   1.3328555787431d+00, 4.5063087059692d-01, 1.1536195673399d-01,
     |   2.0913100368294d-02, 2.3995707575209d-03, 1.4243867961201d-04,
     |   2.8964024445532d-06, 6.9271301570981d-09, 1.3659999863786d-14/
      data (lpmn(lat, 0,15), lat = 1,36)/
     |  -8.3998106050999d+02,-1.9589232371187d+02, 3.4249046686372d+02,
     |   2.4704705568745d+02,-1.6671876659825d+02,-2.6386618037476d+02,
     |   3.6461342129704d+01, 2.4455406312834d+02, 6.7111822438220d+01,
     |  -1.9463686064987d+02,-1.4268802902028d+02, 1.2238943249673d+02,
     |   1.8638379896503d+02,-3.8204076084916d+01,-1.9596970904697d+02,
     |  -4.6387292224943d+01, 1.7234792621563d+02, 1.1993789796555d+02,
     |  -1.1993789796555d+02,-1.7234792621563d+02, 4.6387292224942d+01,
     |   1.9596970904697d+02, 3.8204076084917d+01,-1.8638379896503d+02,
     |  -1.2238943249674d+02, 1.4268802902028d+02, 1.9463686064987d+02,
     |  -6.7111822438219d+01,-2.4455406312834d+02,-3.6461342129706d+01,
     |   2.6386618037476d+02, 1.6671876659825d+02,-2.4704705568745d+02,
     |  -3.4249046686372d+02, 1.9589232371187d+02, 8.3998106050999d+02/
      data (lpmn(lat, 1,15), lat = 1,36)/
     |   3.5876785714540d+02,-4.1085674743188d+02,-1.6216812906363d+02,
     |   2.5942524895820d+02, 2.4124809548693d+02,-1.1230925708011d+02,
     |  -2.5349132101655d+02,-8.2799963108771d+00, 2.2362854772131d+02,
     |   1.0227694401373d+02,-1.6334998180369d+02,-1.6544642059066d+02,
     |   8.3857867579124d+01, 1.9422358811753d+02, 2.7738464633521d+00,
     |  -1.8782267929248d+02,-8.4218989276320d+01, 1.4903156889779d+02,
     |   1.4903156889779d+02,-8.4218989276320d+01,-1.8782267929249d+02,
     |   2.7738464633518d+00, 1.9422358811753d+02, 8.3857867579123d+01,
     |  -1.6544642059066d+02,-1.6334998180369d+02, 1.0227694401373d+02,
     |   2.2362854772131d+02,-8.2799963108765d+00,-2.5349132101655d+02,
     |  -1.1230925708011d+02, 2.4124809548693d+02, 2.5942524895820d+02,
     |  -1.6216812906363d+02,-4.1085674743188d+02, 3.5876785714540d+02/
      data (lpmn(lat, 2,15), lat = 1,36)/
     |   4.0149819046672d+02,-7.3671217266690d+00,-2.8862311466525d+02,
     |  -1.1114741434434d+02, 2.1723682704548d+02, 2.1796297768635d+02,
     |  -8.3818430278626d+01,-2.3588613252510d+02,-3.4168225770843d+01,
     |   2.0132847804910d+02, 1.2356742937686d+02,-1.3344559350281d+02,
     |  -1.7763163141769d+02, 4.7891269181911d+01, 1.9329728786673d+02,
     |   4.0440224889607d+01,-1.7155511050120d+02,-1.1759666626209d+02,
     |   1.1759666626209d+02, 1.7155511050120d+02,-4.0440224889606d+01,
     |  -1.9329728786673d+02,-4.7891269181912d+01, 1.7763163141769d+02,
     |   1.3344559350281d+02,-1.2356742937686d+02,-2.0132847804910d+02,
     |   3.4168225770842d+01, 2.3588613252510d+02, 8.3818430278628d+01,
     |  -2.1796297768635d+02,-2.1723682704548d+02, 1.1114741434434d+02,
     |   2.8862311466525d+02, 7.3671217266690d+00,-4.0149819046672d+02/
      data (lpmn(lat, 3,15), lat = 1,36)/
     |   1.0874715251232d+02, 1.4955111486527d+02,-6.9611508452442d+01,
     |  -2.2666934648526d+02,-7.1176308007563d+01, 1.9308501556537d+02,
     |   1.9392951363705d+02,-6.8062219584183d+01,-2.1819752764919d+02,
     |  -5.0440410566141d+01, 1.7990793386884d+02, 1.3742580379645d+02,
     |  -1.0449499096435d+02,-1.8313153629286d+02, 1.2870463658967d+01,
     |   1.8505993666386d+02, 7.6264683136448d+01,-1.4657343480746d+02,
     |  -1.4657343480746d+02, 7.6264683136447d+01, 1.8505993666386d+02,
     |   1.2870463658967d+01,-1.8313153629286d+02,-1.0449499096435d+02,
     |   1.3742580379645d+02, 1.7990793386884d+02,-5.0440410566141d+01,
     |  -2.1819752764919d+02,-6.8062219584183d+01, 1.9392951363705d+02,
     |   1.9308501556537d+02,-7.1176308007563d+01,-2.2666934648526d+02,
     |  -6.9611508452443d+01, 1.4955111486527d+02, 1.0874715251232d+02/
      data (lpmn(lat, 4,15), lat = 1,36)/
     |   1.6390602060925d+01, 9.4792609070650d+01, 7.2569822682686d+01,
     |  -9.1964092130640d+01,-1.8528882770328d+02,-4.1717823398880d+01,
     |   1.7622087888655d+02, 1.7304998919671d+02,-5.7352713938410d+01,
     |  -2.0191352759233d+02,-6.2816010753401d+01, 1.5874206844835d+02,
     |   1.4749659709888d+02,-7.4683284502796d+01,-1.8330007356469d+02,
     |  -2.2998396959411d+01, 1.6867135819073d+02, 1.1059883466124d+02,
     |  -1.1059883466124d+02,-1.6867135819073d+02, 2.2998396959410d+01,
     |   1.8330007356469d+02, 7.4683284502796d+01,-1.4749659709889d+02,
     |  -1.5874206844835d+02, 6.2816010753401d+01, 2.0191352759234d+02,
     |   5.7352713938411d+01,-1.7304998919671d+02,-1.7622087888656d+02,
     |   4.1717823398880d+01, 1.8528882770328d+02, 9.1964092130641d+01,
     |  -7.2569822682686d+01,-9.4792609070650d+01,-1.6390602060925d+01/
      data (lpmn(lat, 5,15), lat = 1,36)/
     |   1.6816783434851d+00, 3.3535465337519d+01, 7.5964833285337d+01,
     |   3.1082116128763d+01,-9.9743008424930d+01,-1.5414914197809d+02,
     |  -2.1032913136341d+01, 1.6205049665758d+02, 1.5626974357016d+02,
     |  -4.7360455587522d+01,-1.8678661439726d+02,-7.4687844244127d+01,
     |   1.3616963013384d+02, 1.5531127360597d+02,-4.1885880744234d+01,
     |  -1.7731169926234d+02,-6.0677579193768d+01, 1.4135855739988d+02,
     |   1.4135855739988d+02,-6.0677579193767d+01,-1.7731169926234d+02,
     |  -4.1885880744235d+01, 1.5531127360597d+02, 1.3616963013384d+02,
     |  -7.4687844244126d+01,-1.8678661439726d+02,-4.7360455587522d+01,
     |   1.5626974357016d+02, 1.6205049665758d+02,-2.1032913136340d+01,
     |  -1.5414914197809d+02,-9.9743008424930d+01, 3.1082116128763d+01,
     |   7.5964833285337d+01, 3.3535465337519d+01, 1.6816783434851d+00/
      data (lpmn(lat, 6,15), lat = 1,36)/
     |   1.2869664969227d-01, 8.3084942557973d+00, 3.8953482750478d+01,
     |   5.8857806638363d+01, 5.5185638269690d+00,-1.0003482733370d+02,
     |  -1.2979323745596d+02,-7.8939153855468d+00, 1.4852184579269d+02,
     |   1.4372967857544d+02,-3.5500806222881d+01,-1.7182971509001d+02,
     |  -8.7866185774761d+01, 1.1002368003186d+02, 1.6047060540033d+02,
     |  -4.3346220810194d+00,-1.6216467737532d+02,-9.9032977101648d+01,
     |   9.9032977101648d+01, 1.6216467737532d+02, 4.3346220810203d+00,
     |  -1.6047060540033d+02,-1.1002368003186d+02, 8.7866185774762d+01,
     |   1.7182971509001d+02, 3.5500806222881d+01,-1.4372967857544d+02,
     |  -1.4852184579269d+02, 7.8939153855465d+00, 1.2979323745596d+02,
     |   1.0003482733370d+02,-5.5185638269689d+00,-5.8857806638363d+01,
     |  -3.8953482750478d+01,-8.3084942557973d+00,-1.2869664969227d-01/
      data (lpmn(lat, 7,15), lat = 1,36)/
     |   7.7253398354669d-03, 1.5698569327459d+00, 1.3811933212474d+01,
     |   3.9001142167676d+01, 4.4325033876305d+01,-1.0281617921113d+01,
     |  -9.5965849235155d+01,-1.1086746100774d+02,-1.4576153240061d+00,
     |   1.3453423004770d+02, 1.3513363178050d+02,-2.0096544118235d+01,
     |  -1.5538100070052d+02,-1.0273171958621d+02, 7.7852209713469d+01,
     |   1.6033284958495d+02, 3.8355623021071d+01,-1.3274576145493d+02,
     |  -1.3274576145493d+02, 3.8355623021071d+01, 1.6033284958495d+02,
     |   7.7852209713469d+01,-1.0273171958621d+02,-1.5538100070052d+02,
     |  -2.0096544118236d+01, 1.3513363178050d+02, 1.3453423004770d+02,
     |  -1.4576153240056d+00,-1.1086746100774d+02,-9.5965849235155d+01,
     |  -1.0281617921113d+01, 4.4325033876305d+01, 3.9001142167677d+01,
     |   1.3811933212474d+01, 1.5698569327459d+00, 7.7253398354669d-03/
      data (lpmn(lat, 8,15), lat = 1,36)/
     |   3.7473439205674d-04, 2.3614429245401d-01, 3.7366877148953d+00,
     |   1.7195524687777d+01, 3.6355540221099d+01, 3.2716062021555d+01,
     |  -1.9129498019777d+01,-8.9262026343179d+01,-9.6643734300992d+01,
     |  -1.0959774342990d+00, 1.1915503661212d+02, 1.2961338718339d+02,
     |  -7.8335602214876d-02,-1.3489822899774d+02,-1.1780583993779d+02,
     |   3.7467767658553d+01, 1.4945292554236d+02, 8.3088529967807d+01,
     |  -8.3088529967807d+01,-1.4945292554236d+02,-3.7467767658554d+01,
     |   1.1780583993779d+02, 1.3489822899774d+02, 7.8335602214192d-02,
     |  -1.2961338718338d+02,-1.1915503661212d+02, 1.0959774342989d+00,
     |   9.6643734300991d+01, 8.9262026343179d+01, 1.9129498019777d+01,
     |  -3.2716062021555d+01,-3.6355540221099d+01,-1.7195524687777d+01,
     |  -3.7366877148954d+00,-2.3614429245401d-01,-3.7473439205674d-04/
      data (lpmn(lat, 9,15), lat = 1,36)/
     |   1.4945265887286d-05, 2.8949063639525d-02, 8.0547721760991d-01,
     |   5.7173214950581d+00, 1.8639207024768d+01, 3.2528112977566d+01,
     |   2.4150195857453d+01,-2.2653599607423d+01,-8.0874239196963d+01,
     |  -8.6408053148172d+01,-6.2543568493398d+00, 1.0119452168388d+02,
     |   1.2535453401077d+02, 2.4787039234662d+01,-1.0687492752334d+02,
     |  -1.2872807948603d+02,-1.1381752455367d+01, 1.1963685612473d+02,
     |   1.1963685612473d+02,-1.1381752455366d+01,-1.2872807948603d+02,
     |  -1.0687492752334d+02, 2.4787039234662d+01, 1.2535453401077d+02,
     |   1.0119452168388d+02,-6.2543568493398d+00,-8.6408053148172d+01,
     |  -8.0874239196963d+01,-2.2653599607423d+01, 2.4150195857453d+01,
     |   3.2528112977566d+01, 1.8639207024768d+01, 5.7173214950582d+00,
     |   8.0547721760993d-01, 2.8949063639525d-02, 1.4945265887286d-05/
      data (lpmn(lat,10,15), lat = 1,36)/
     |   4.9412827570744d-07, 2.9254776563695d-03, 1.4120730505194d-01,
     |   1.5026736090949d+00, 7.0581092827235d+00, 1.8550163429546d+01,
     |   2.8442728058906d+01, 1.8533771783781d+01,-2.1934765871066d+01,
     |  -7.1132602949332d+01,-7.9097099226366d+01,-1.6213565558977d+01,
     |   7.9065515670261d+01, 1.1904936461858d+02, 5.2914207833777d+01,
     |  -6.7537238705485d+01,-1.2697659065835d+02,-6.3142748693668d+01,
     |   6.3142748693668d+01, 1.2697659065835d+02, 6.7537238705485d+01,
     |  -5.2914207833777d+01,-1.1904936461858d+02,-7.9065515670260d+01,
     |   1.6213565558977d+01, 7.9097099226366d+01, 7.1132602949332d+01,
     |   2.1934765871066d+01,-1.8533771783781d+01,-2.8442728058906d+01,
     |  -1.8550163429546d+01,-7.0581092827235d+00,-1.5026736090949d+00,
     |  -1.4120730505194d-01,-2.9254776563695d-03,-4.9412827570744d-07/
      data (lpmn(lat,11,15), lat = 1,36)/
     |   1.3545100232367d-08, 2.4417871277479d-04, 2.0267895969183d-02,
     |   3.1795890368151d-01, 2.0805662064931d+00, 7.5942528364945d+00,
     |   1.7337124575974d+01, 2.4598660384361d+01, 1.5549817455444d+01,
     |  -1.7755051248024d+01,-5.9792983770694d+01,-7.2973081004577d+01,
     |  -2.9572746422375d+01, 5.1148240507118d+01, 1.0542623722889d+02,
     |   7.8862540341825d+01,-1.5723309960572d+01,-1.0019589062167d+02,
     |  -1.0019589062167d+02,-1.5723309960572d+01, 7.8862540341825d+01,
     |   1.0542623722889d+02, 5.1148240507118d+01,-2.9572746422375d+01,
     |  -7.2973081004577d+01,-5.9792983770694d+01,-1.7755051248024d+01,
     |   1.5549817455444d+01, 2.4598660384361d+01, 1.7337124575974d+01,
     |   7.5942528364945d+00, 2.0805662064931d+00, 3.1795890368152d-01,
     |   2.0267895969184d-02, 2.4417871277479d-04, 1.3545100232366d-08/
      data (lpmn(lat,12,15), lat = 1,36)/
     |   3.0501925783034d-10, 1.6697438430372d-05, 2.3691037565440d-03,
     |   5.4196469388938d-02, 4.8448807885545d-01, 2.3638263218757d+00,
     |   7.3233715130207d+00, 1.5311710844931d+01, 2.1118011726804d+01,
     |   1.4611836035573d+01,-1.0810972127664d+01,-4.6163707973789d+01,
     |  -6.5316497460673d+01,-4.3254845534589d+01, 1.7273448878358d+01,
     |   7.7887821366502d+01, 9.0704874882126d+01, 3.9968253686415d+01,
     |  -3.9968253686415d+01,-9.0704874882126d+01,-7.7887821366502d+01,
     |  -1.7273448878359d+01, 4.3254845534589d+01, 6.5316497460673d+01,
     |   4.6163707973789d+01, 1.0810972127664d+01,-1.4611836035573d+01,
     |  -2.1118011726804d+01,-1.5311710844931d+01,-7.3233715130207d+00,
     |  -2.3638263218757d+00,-4.8448807885545d-01,-5.4196469388939d-02,
     |  -2.3691037565441d-03,-1.6697438430372d-05,-3.0501925783033d-10/
      data (lpmn(lat,13,15), lat = 1,36)/
     |   5.5129134099838d-12, 9.1462582470055d-07, 2.2087357211513d-04,
     |   7.3131204796253d-03, 8.8201525137243d-02, 5.6285899058895d-01,
     |   2.2693787153134d+00, 6.3252714303869d+00, 1.2642181859560d+01,
     |   1.7758538794744d+01, 1.4749136661046d+01,-2.0886265570654d+00,
     |  -2.9580724193867d+01,-5.2439778161103d+01,-5.1105645180739d+01,
     |  -1.7709732940174d+01, 3.3145994820019d+01, 7.0982388722791d+01,
     |   7.0982388722791d+01, 3.3145994820019d+01,-1.7709732940174d+01,
     |  -5.1105645180739d+01,-5.2439778161103d+01,-2.9580724193867d+01,
     |  -2.0886265570656d+00, 1.4749136661046d+01, 1.7758538794744d+01,
     |   1.2642181859560d+01, 6.3252714303869d+00, 2.2693787153134d+00,
     |   5.6285899058895d-01, 8.8201525137243d-02, 7.3131204796254d-03,
     |   2.2087357211513d-04, 9.1462582470055d-07, 5.5129134099838d-12/
      data (lpmn(lat,14,15), lat = 1,36)/
     |   7.5961099093403d-14, 3.8137098766975d-08, 1.5625367336817d-05,
     |   7.4476821527921d-04, 1.2015086534577d-02, 9.8914312839181d-02,
     |   5.0706041114900d-01, 1.8032645292785d+00, 4.7233121863820d+00,
     |   9.3621597845251d+00, 1.3941310127386d+01, 1.4422835154772d+01,
     |   6.4376733821406d+00,-1.0737720779096d+01,-3.1120995434554d+01,
     |  -4.3573769079518d+01,-3.8514221091879d+01,-1.5390258617087d+01,
     |   1.5390258617087d+01, 3.8514221091879d+01, 4.3573769079518d+01,
     |   3.1120995434554d+01, 1.0737720779096d+01,-6.4376733821406d+00,
     |  -1.4422835154772d+01,-1.3941310127386d+01,-9.3621597845251d+00,
     |  -4.7233121863820d+00,-1.8032645292785d+00,-5.0706041114900d-01,
     |  -9.8914312839181d-02,-1.2015086534577d-02,-7.4476821527922d-04,
     |  -1.5625367336818d-05,-3.8137098766975d-08,-7.5961099093402d-14/
      data (lpmn(lat,15,15), lat = 1,36)/
     |   6.9531382688992d-16, 1.0551970549366d-09, 7.3171896418169d-07,
     |   5.0006150569324d-05, 1.0724547228504d-03, 1.1283447181766d-02,
     |   7.2475187461297d-02, 3.2105836965589d-01, 1.0552526739993d+00,
     |   2.6907258827823d+00, 5.4576083598161d+00, 8.8738512653261d+00,
     |   1.1388874258683d+01, 1.0771104487372d+01, 5.4161213655169d+00,
     |  -4.1156613095576d+00,-1.4601793531235d+01,-2.1494882296739d+01,
     |  -2.1494882296739d+01,-1.4601793531235d+01,-4.1156613095577d+00,
     |   5.4161213655169d+00, 1.0771104487372d+01, 1.1388874258683d+01,
     |   8.8738512653261d+00, 5.4576083598161d+00, 2.6907258827823d+00,
     |   1.0552526739994d+00, 3.2105836965589d-01, 7.2475187461298d-02,
     |   1.1283447181766d-02, 1.0724547228504d-03, 5.0006150569325d-05,
     |   7.3171896418171d-07, 1.0551970549366d-09, 6.9531382688991d-16/
      data (lpmn(lat, 0,16), lat = 1,36)/
     |  -9.6638281687605d+02,-1.4672838755079d+02, 4.3460739884654d+02,
     |   1.8291783329418d+02,-2.8769496313026d+02,-2.1379799780893d+02,
     |   1.9242144867662d+02, 2.3264083340216d+02,-1.1477061611212d+02,
     |  -2.3979354230918d+02, 4.6132442410549d+01, 2.3580659403253d+02,
     |   1.5970763310055d+01,-2.2125146706405d+02,-7.1916142333608d+01,
     |   1.9678183840231d+02, 1.2124355844280d+02,-1.6316072810153d+02,
     |  -1.6316072810153d+02, 1.2124355844280d+02, 1.9678183840231d+02,
     |  -7.1916142333608d+01,-2.2125146706405d+02, 1.5970763310056d+01,
     |   2.3580659403253d+02, 4.6132442410549d+01,-2.3979354230918d+02,
     |  -1.1477061611212d+02, 2.3264083340216d+02, 1.9242144867663d+02,
     |  -2.1379799780893d+02,-2.8769496313026d+02, 1.8291783329418d+02,
     |   4.3460739884654d+02,-1.4672838755079d+02,-9.6638281687605d+02/
      data (lpmn(lat, 1,16), lat = 1,36)/
     |   3.4719985898660d+02,-4.8720589988808d+02,-9.8405844324931d+01,
     |   3.5415218514784d+02, 1.7509743763707d+02,-2.4551007432087d+02,
     |  -2.1329035803324d+02, 1.5998475076523d+02, 2.3231391578594d+02,
     |  -8.5723596147480d+01,-2.3697760060371d+02, 1.8782948474944d+01,
     |   2.2922655773148d+02, 4.1818345960878d+01,-2.1024680561528d+02,
     |  -9.5851547933946d+01, 1.8103487651673d+02, 1.4257209394216d+02,
     |  -1.4257209394216d+02,-1.8103487651673d+02, 9.5851547933945d+01,
     |   2.1024680561528d+02,-4.1818345960878d+01,-2.2922655773148d+02,
     |  -1.8782948474946d+01, 2.3697760060371d+02, 8.5723596147480d+01,
     |  -2.3231391578594d+02,-1.5998475076523d+02, 2.1329035803324d+02,
     |   2.4551007432087d+02,-1.7509743763707d+02,-3.5415218514784d+02,
     |   9.8405844324927d+01, 4.8720589988808d+02,-3.4719985898659d+02/
      data (lpmn(lat, 2,16), lat = 1,36)/
     |   4.5927958902321d+02,-5.8442044484456d+01,-3.3950211136415d+02,
     |  -3.4403275808273d+01, 3.0723929375726d+02, 1.4540532807574d+02,
     |  -2.2246810450594d+02,-1.9962051845067d+02, 1.4158981622494d+02,
     |   2.2480307139060d+02,-6.6963793666239d+01,-2.3035139886534d+02,
     |  -1.4106340120286d+00, 2.2032434052470d+02, 6.3044585553488d+01,
     |  -1.9701840787347d+02,-1.1700290505051d+02, 1.6210028742140d+02,
     |   1.6210028742140d+02,-1.1700290505051d+02,-1.9701840787347d+02,
     |   6.3044585553488d+01, 2.2032434052470d+02,-1.4106340120299d+00,
     |  -2.3035139886534d+02,-6.6963793666239d+01, 2.2480307139060d+02,
     |   1.4158981622494d+02,-1.9962051845067d+02,-2.2246810450594d+02,
     |   1.4540532807574d+02, 3.0723929375726d+02,-3.4403275808270d+01,
     |  -3.3950211136415d+02,-5.8442044484456d+01, 4.5927958902320d+02/
      data (lpmn(lat, 3,16), lat = 1,36)/
     |   1.3416192797230d+02, 1.5991723058468d+02,-1.2917518824129d+02,
     |  -2.5609407590748d+02, 1.6465328884303d+01, 2.7479083582237d+02,
     |   1.1281449761404d+02,-2.0877053920717d+02,-1.8252985883573d+02,
     |   1.3042608034187d+02, 2.1530532717017d+02,-5.3178639235479d+01,
     |  -2.2244576630867d+02,-1.8781663014476d+01, 2.0971953157861d+02,
     |   8.3075701763494d+01,-1.8061918429885d+02,-1.3768831561291d+02,
     |   1.3768831561291d+02, 1.8061918429885d+02,-8.3075701763493d+01,
     |  -2.0971953157861d+02, 1.8781663014476d+01, 2.2244576630867d+02,
     |   5.3178639235481d+01,-2.1530532717017d+02,-1.3042608034187d+02,
     |   1.8252985883573d+02, 2.0877053920717d+02,-1.1281449761404d+02,
     |  -2.7479083582237d+02,-1.6465328884303d+01, 2.5609407590748d+02,
     |   1.2917518824129d+02,-1.5991723058468d+02,-1.3416192797230d+02/
      data (lpmn(lat, 4,16), lat = 1,36)/
     |   2.1680168328914d+01, 1.1710247433347d+02, 6.0785057219840d+01,
     |  -1.5205221420904d+02,-1.9526130505769d+02, 5.3971419354157d+01,
     |   2.4804610857862d+02, 8.3360121597821d+01,-1.9852610787029d+02,
     |  -1.6618477502906d+02, 1.2169298916988d+02, 2.0611003951320d+02,
     |  -4.0272328827573d+01,-2.1393557778863d+02,-3.6741395455494d+01,
     |   1.9657189664036d+02, 1.0434443346686d+02,-1.5878159680022d+02,
     |  -1.5878159680022d+02, 1.0434443346686d+02, 1.9657189664036d+02,
     |  -3.6741395455494d+01,-2.1393557778863d+02,-4.0272328827571d+01,
     |   2.0611003951320d+02, 1.2169298916988d+02,-1.6618477502906d+02,
     |  -1.9852610787029d+02, 8.3360121597820d+01, 2.4804610857862d+02,
     |   5.3971419354157d+01,-1.9526130505769d+02,-1.5205221420904d+02,
     |   6.0785057219840d+01, 1.1710247433347d+02, 2.1680168328914d+01/
      data (lpmn(lat, 5,16), lat = 1,36)/
     |   2.3853279858109d+00, 4.5481635745036d+01, 9.0098966265318d+01,
     |   4.6921897274568d+00,-1.5590133728598d+02,-1.4691490325304d+02,
     |   7.9752275458327d+01, 2.2403607751282d+02, 5.9545264074183d+01,
     |  -1.8871833521911d+02,-1.5279375776559d+02, 1.1214784263422d+02,
     |   1.9822969329189d+02,-2.5088773518036d+01,-2.0433686883695d+02,
     |  -5.7839858994395d+01, 1.7877730281420d+02, 1.2796099136625d+02,
     |  -1.2796099136625d+02,-1.7877730281420d+02, 5.7839858994394d+01,
     |   2.0433686883695d+02, 2.5088773518036d+01,-1.9822969329189d+02,
     |  -1.1214784263422d+02, 1.5279375776559d+02, 1.8871833521911d+02,
     |  -5.9545264074183d+01,-2.2403607751282d+02,-7.9752275458328d+01,
     |   1.4691490325304d+02, 1.5590133728598d+02,-4.6921897274563d+00,
     |  -9.0098966265318d+01,-4.5481635745036d+01,-2.3853279858109d+00/
      data (lpmn(lat, 6,16), lat = 1,36)/
     |   1.9618382944627d-01, 1.2250587546806d+01, 5.2872474299296d+01,
     |   6.3723207234171d+01,-3.0478044004213d+01,-1.4977886641307d+02,
     |  -1.0821777579326d+02, 9.5446050728187d+01, 2.0225899878186d+02,
     |   4.2651104076408d+01,-1.7787493165297d+02,-1.4369495504251d+02,
     |   9.9418643794948d+01, 1.9178698738770d+02,-5.1145983541905d+00,
     |  -1.9195578823659d+02,-8.3563355845935d+01, 1.5277596014265d+02,
     |   1.5277596014265d+02,-8.3563355845935d+01,-1.9195578823659d+02,
     |  -5.1145983541909d+00, 1.9178698738770d+02, 9.9418643794947d+01,
     |  -1.4369495504251d+02,-1.7787493165297d+02, 4.2651104076408d+01,
     |   2.0225899878186d+02, 9.5446050728187d+01,-1.0821777579326d+02,
     |  -1.4977886641307d+02,-3.0478044004213d+01, 6.3723207234171d+01,
     |   5.2872474299296d+01, 1.2250587546806d+01, 1.9618382944627d-01/
      data (lpmn(lat, 7,16), lat = 1,36)/
     |   1.2701738832687d-02, 2.5137611685975d+00, 2.0817294059667d+01,
     |   5.1945067519127d+01, 4.0394475138819d+01,-5.2017062697060d+01,
     |  -1.3844339040953d+02,-7.8367413697973d+01, 1.0260002401325d+02,
     |   1.8309238432805d+02, 3.3387651571321d+01,-1.6510391332154d+02,
     |  -1.3955562226793d+02, 8.1445995068433d+01, 1.8578389953236d+02,
     |   2.1539477563925d+01,-1.7343836055943d+02,-1.1348962311420d+02,
     |   1.1348962311420d+02, 1.7343836055943d+02,-2.1539477563924d+01,
     |  -1.8578389953236d+02,-8.1445995068433d+01, 1.3955562226794d+02,
     |   1.6510391332154d+02,-3.3387651571321d+01,-1.8309238432805d+02,
     |  -1.0260002401325d+02, 7.8367413697973d+01, 1.3844339040953d+02,
     |   5.2017062697060d+01,-4.0394475138819d+01,-5.1945067519127d+01,
     |  -2.0817294059667d+01,-2.5137611685975d+00,-1.2701738832687d-02/
      data (lpmn(lat, 8,16), lat = 1,36)/
     |   6.6789485724590d-04, 4.1176920378460d-01, 6.2104799840793d+00,
     |   2.6199560397621d+01, 4.6646371837106d+01, 2.1360737496769d+01,
     |  -6.3694231347648d+01,-1.2504900417803d+02,-5.7044807094455d+01,
     |   1.0257235858348d+02, 1.6694436751189d+02, 3.2121606898850d+01,
     |  -1.4936489501754d+02,-1.4015210090326d+02, 5.6159756537392d+01,
     |   1.7746098067591d+02, 5.5536752414191d+01,-1.4330590323797d+02,
     |  -1.4330590323797d+02, 5.5536752414191d+01, 1.7746098067591d+02,
     |   5.6159756537392d+01,-1.4015210090326d+02,-1.4936489501754d+02,
     |   3.2121606898849d+01, 1.6694436751189d+02, 1.0257235858348d+02,
     |  -5.7044807094455d+01,-1.2504900417803d+02,-6.3694231347648d+01,
     |   2.1360737496769d+01, 4.6646371837105d+01, 2.6199560397622d+01,
     |   6.2104799840794d+00, 4.1176920378460d-01, 6.6789485724590d-04/
      data (lpmn(lat, 9,16), lat = 1,36)/
     |   2.9074363016422d-05, 5.5275782123201d-02, 1.4779142181942d+00,
     |   9.8021212479165d+00, 2.8507448925312d+01, 3.9535254336410d+01,
     |   7.2177606776161d+00,-6.8072940497552d+01,-1.1174540956934d+02,
     |  -4.3901353758113d+01, 9.6334927833222d+01, 1.5368977825207d+02,
     |   3.8904725510790d+01,-1.2889379183498d+02,-1.4375594419551d+02,
     |   2.1657584297328d+01, 1.6140974935863d+02, 9.4479274008084d+01,
     |  -9.4479274008084d+01,-1.6140974935863d+02,-2.1657584297329d+01,
     |   1.4375594419551d+02, 1.2889379183498d+02,-3.8904725510791d+01,
     |  -1.5368977825207d+02,-9.6334927833222d+01, 4.3901353758113d+01,
     |   1.1174540956934d+02, 6.8072940497552d+01,-7.2177606776160d+00,
     |  -3.9535254336410d+01,-2.8507448925312d+01,-9.8021212479165d+00,
     |  -1.4779142181942d+00,-5.5275782123201d-02,-2.9074363016422d-05/
      data (lpmn(lat,10,16), lat = 1,36)/
     |   1.0591545724956d-06, 6.1695935942499d-03, 2.8780579236713d-01,
     |   2.8958847874290d+00, 1.2467684106125d+01, 2.8415038952222d+01,
     |   3.2381421144692d+01,-1.9341637728874d+00,-6.7052219162994d+01,
     |  -9.9782071827522d+01,-3.8381785495493d+01, 8.4259759570051d+01,
     |   1.4216189965131d+02, 5.3186299131511d+01,-1.0088682369520d+02,
     |  -1.4600767170988d+02,-2.2450261631940d+01, 1.2911485930019d+02,
     |   1.2911485930019d+02,-2.2450261631940d+01,-1.4600767170988d+02,
     |  -1.0088682369520d+02, 5.3186299131510d+01, 1.4216189965131d+02,
     |   8.4259759570052d+01,-3.8381785495493d+01,-9.9782071827522d+01,
     |  -6.7052219162994d+01,-1.9341637728876d+00, 3.2381421144692d+01,
     |   2.8415038952222d+01, 1.2467684106125d+01, 2.8958847874291d+00,
     |   2.8780579236713d-01, 6.1695935942499d-03, 1.0591545724956d-06/
      data (lpmn(lat,11,16), lat = 1,36)/
     |   3.2417851389841d-08, 5.7604986981518d-04, 4.6408178628723d-02,
     |   6.9400708995025d-01, 4.2294679171974d+00, 1.3888858385696d+01,
     |   2.6730413081837d+01, 2.6325680378467d+01,-6.3462440760022d+00,
     |  -6.1932758026551d+01,-8.9456011284879d+01,-3.9568715979274d+01,
     |   6.6032119614280d+01, 1.2958535938728d+02, 7.2881975820463d+01,
     |  -6.1960749462662d+01,-1.3842512146141d+02,-7.1339250000240d+01,
     |   7.1339250000240d+01, 1.3842512146141d+02, 6.1960749462663d+01,
     |  -7.2881975820463d+01,-1.2958535938728d+02,-6.6032119614280d+01,
     |   3.9568715979274d+01, 8.9456011284879d+01, 6.1932758026551d+01,
     |   6.3462440760022d+00,-2.6325680378467d+01,-2.6730413081837d+01,
     |  -1.3888858385696d+01,-4.2294679171974d+00,-6.9400708995026d-01,
     |  -4.6408178628724d-02,-5.7604986981518d-04,-3.2417851389841d-08/
      data (lpmn(lat,12,16), lat = 1,36)/
     |   8.3130244134628d-10, 4.4923888303971d-05, 6.2069635818099d-03,
     |   1.3616512619426d-01, 1.1457921386733d+00, 5.1334221811987d+00,
     |   1.4060183959536d+01, 2.4161252436606d+01, 2.1939110696865d+01,
     |  -6.4982201132389d+00,-5.3380202747582d+01,-7.9970495906230d+01,
     |  -4.5796443375475d+01, 4.0987323401316d+01, 1.1108267220733d+02,
     |   9.2376416332958d+01,-1.0759035557859d+01,-1.0815866888346d+02,
     |  -1.0815866888346d+02,-1.0759035557859d+01, 9.2376416332958d+01,
     |   1.1108267220733d+02, 4.0987323401316d+01,-4.5796443375475d+01,
     |  -7.9970495906230d+01,-5.3380202747582d+01,-6.4982201132390d+00,
     |   2.1939110696866d+01, 2.4161252436606d+01, 1.4060183959536d+01,
     |   5.1334221811987d+00, 1.1457921386733d+00, 1.3616512619427d-01,
     |   6.2069635818100d-03, 4.4923888303971d-05, 8.3130244134628d-10/
      data (lpmn(lat,13,16), lat = 1,36)/
     |   1.7658998131424d-11, 2.8956765826263d-06, 6.8275228599398d-04,
     |   2.1777821853722d-02, 2.4913797127121d-01, 1.4793318218408d+00,
     |   5.4070512596152d+00, 1.3123953426413d+01, 2.1160544485428d+01,
     |   1.9240433464513d+01,-3.0747586552756d+00,-4.1482166800879d+01,
     |  -6.9256470528189d+01,-5.3787316143479d+01, 9.5138419742265d+00,
     |   8.0173807507391d+01, 9.9684160026251d+01, 4.4914365292300d+01,
     |  -4.4914365292300d+01,-9.9684160026251d+01,-8.0173807507392d+01,
     |  -9.5138419742266d+00, 5.3787316143479d+01, 6.9256470528189d+01,
     |   4.1482166800879d+01, 3.0747586552756d+00,-1.9240433464513d+01,
     |  -2.1160544485428d+01,-1.3123953426412d+01,-5.4070512596152d+00,
     |  -1.4793318218408d+00,-2.4913797127121d-01,-2.1777821853723d-02,
     |  -6.8275228599399d-04,-2.8956765826263d-06,-1.7658998131424d-11/
      data (lpmn(lat,14,16), lat = 1,36)/
     |   3.0313536266233d-13, 1.5057451513150d-07, 6.0364732614388d-05,
     |   2.7819575479101d-03, 4.2818591440261d-02, 3.3106416158105d-01,
     |   1.5628573612213d+00, 4.9837168133957d+00, 1.1241077129216d+01,
     |   1.7829585294923d+01, 1.7655295118892d+01, 2.8370566631228d+00,
     |  -2.6158361503963d+01,-5.4048369691469d+01,-5.7302606043120d+01,
     |  -2.3418485757893d+01, 3.3160824837234d+01, 7.6663542012766d+01,
     |   7.6663542012766d+01, 3.3160824837234d+01,-2.3418485757893d+01,
     |  -5.7302606043120d+01,-5.4048369691469d+01,-2.6158361503963d+01,
     |   2.8370566631227d+00, 1.7655295118892d+01, 1.7829585294923d+01,
     |   1.1241077129216d+01, 4.9837168133957d+00, 1.5628573612213d+00,
     |   3.3106416158105d-01, 4.2818591440261d-02, 2.7819575479101d-03,
     |   6.0364732614390d-05, 1.5057451513150d-07, 3.0313536266233d-13/
      data (lpmn(lat,15,16), lat = 1,36)/
     |   3.9893901592311d-15, 5.9949558064272d-09, 4.0749882503831d-06,
     |   2.7006861703622d-04, 5.5513257676898d-03, 5.5238023965296d-02,
     |   3.3030415261571d-01, 1.3356789760256d+00, 3.9039773925254d+00,
     |   8.5213062917047d+00, 1.3886862866848d+01, 1.5905213211497d+01,
     |   9.1817409757909d+00,-8.4226920242872d+00,-3.1277882370710d+01,
     |  -4.6661634730097d+01,-4.2511742168041d+01,-1.7214563573635d+01,
     |   1.7214563573635d+01, 4.2511742168041d+01, 4.6661634730097d+01,
     |   3.1277882370710d+01, 8.4226920242872d+00,-9.1817409757909d+00,
     |  -1.5905213211497d+01,-1.3886862866848d+01,-8.5213062917047d+00,
     |  -3.9039773925254d+00,-1.3356789760256d+00,-3.3030415261572d-01,
     |  -5.5238023965296d-02,-5.5513257676898d-03,-2.7006861703623d-04,
     |  -4.0749882503832d-06,-5.9949558064272d-09,-3.9893901592310d-15/
      data (lpmn(lat,16,16), lat = 1,36)/
     |   3.5043163531344d-17, 1.5914832284940d-10, 1.8302470264224d-07,
     |   1.7381438383135d-05, 4.7453910294358d-04, 6.0267882945303d-03,
     |   4.5071238667929d-02, 2.2640088553963d-01, 8.2677203320071d-01,
     |   2.3044880020399d+00, 5.0426689918236d+00, 8.7535291136568d+00,
     |   1.1910127534700d+01, 1.1954477059500d+01, 6.7276516026247d+00,
     |  -3.5383581850860d+00,-1.5314137823270d+01,-2.3215558386851d+01,
     |  -2.3215558386851d+01,-1.5314137823270d+01,-3.5383581850860d+00,
     |   6.7276516026247d+00, 1.1954477059500d+01, 1.1910127534700d+01,
     |   8.7535291136568d+00, 5.0426689918236d+00, 2.3044880020399d+00,
     |   8.2677203320071d-01, 2.2640088553963d-01, 4.5071238667929d-02,
     |   6.0267882945303d-03, 4.7453910294358d-04, 1.7381438383135d-05,
     |   1.8302470264224d-07, 1.5914832284940d-10, 3.5043163531343d-17/
      data (lpmn(lat, 0,17), lat = 1,36)/
     |  -1.1003164304731d+03,-7.7396233982248d+01, 5.1757457164820d+02,
     |   7.7344250841508d+01,-3.8520283400550d+02,-9.0059814330689d+01,
     |   3.1849608412242d+02, 1.0327087244571d+02,-2.7587997448577d+02,
     |  -1.1617134158136d+02, 2.4509826960628d+02, 1.2889371594187d+02,
     |  -2.2106720911256d+02,-1.4171052737735d+02, 2.0123877116378d+02,
     |   1.5493625665291d+02,-1.8416398880325d+02,-1.6893561128606d+02,
     |   1.6893561128606d+02, 1.8416398880325d+02,-1.5493625665291d+02,
     |  -2.0123877116378d+02, 1.4171052737735d+02, 2.2106720911256d+02,
     |  -1.2889371594187d+02,-2.4509826960628d+02, 1.1617134158136d+02,
     |   2.7587997448577d+02,-1.0327087244571d+02,-3.1849608412242d+02,
     |   9.0059814330689d+01, 3.8520283400550d+02,-7.7344250841505d+01,
     |  -5.1757457164820d+02, 7.7396233982248d+01, 1.1003164304731d+03/
      data (lpmn(lat, 1,17), lat = 1,36)/
     |   3.2569703254254d+02,-5.6119601323312d+02,-7.4115074899464d+00,
     |   4.3037713772130d+02, 5.6014345851806d+01,-3.4779104388952d+02,
     |  -8.1686055993634d+01, 2.9685105710435d+02, 1.0058417402599d+02,
     |  -2.6117324530798d+02,-1.1669035946561d+02, 2.3392661405969d+02,
     |   1.3156206054841d+02,-2.1178407528196d+02,-1.4603937575058d+02,
     |   1.9290091179830d+02, 1.6071816797195d+02,-1.7613859758710d+02,
     |  -1.7613859758710d+02, 1.6071816797195d+02, 1.9290091179830d+02,
     |  -1.4603937575058d+02,-2.1178407528196d+02, 1.3156206054841d+02,
     |   2.3392661405969d+02,-1.1669035946561d+02,-2.6117324530798d+02,
     |   1.0058417402599d+02, 2.9685105710435d+02,-8.1686055993632d+01,
     |  -3.4779104388952d+02, 5.6014345851806d+01, 4.3037713772130d+02,
     |  -7.4115074899423d+00,-5.6119601323312d+02, 3.2569703254253d+02/
      data (lpmn(lat, 2,17), lat = 1,36)/
     |   5.1960357672090d+02,-1.2273882979992d+02,-3.7734857109801d+02,
     |   7.2581120502892d+01, 3.6642141495043d+02, 1.1758311198135d+01,
     |  -3.1927602136087d+02,-5.6763459529245d+01, 2.8117774101099d+02,
     |   8.6796102612788d+01,-2.5090623544203d+02,-1.1008257758791d+02,
     |   2.2586596806184d+02, 1.3005194719792d+02,-2.0422277854257d+02,
     |  -1.4845838680681d+02, 1.8471446691000d+02, 1.6639717182637d+02,
     |  -1.6639717182636d+02,-1.8471446691000d+02, 1.4845838680681d+02,
     |   2.0422277854257d+02,-1.3005194719792d+02,-2.2586596806184d+02,
     |   1.1008257758791d+02, 2.5090623544203d+02,-8.6796102612788d+01,
     |  -2.8117774101099d+02, 5.6763459529244d+01, 3.1927602136087d+02,
     |  -1.1758311198135d+01,-3.6642141495043d+02,-7.2581120502895d+01,
     |   3.7734857109801d+02, 1.2273882979992d+02,-5.1960357672090d+02/
      data (lpmn(lat, 3,17), lat = 1,36)/
     |   1.6321626019843d+02, 1.6421336730440d+02,-1.9992691136990d+02,
     |  -2.6134874403229d+02, 1.3317525211177d+02, 3.1129511317495d+02,
     |  -3.4180210711078d+01,-2.9385819594789d+02,-2.7158342553053d+01,
     |   2.6798921747554d+02, 6.9277592131764d+01,-2.4260293277030d+02,
     |  -1.0143710836112d+02, 2.1883500399676d+02, 1.2816955850372d+02,
     |  -1.9630684231170d+02,-1.5194729331179d+02, 1.7429930635369d+02,
     |   1.7429930635369d+02,-1.5194729331179d+02,-1.9630684231170d+02,
     |   1.2816955850372d+02, 2.1883500399676d+02,-1.0143710836112d+02,
     |  -2.4260293277030d+02, 6.9277592131764d+01, 2.6798921747554d+02,
     |  -2.7158342553052d+01,-2.9385819594789d+02,-3.4180210711080d+01,
     |   3.1129511317495d+02, 1.3317525211177d+02,-2.6134874403229d+02,
     |  -1.9992691136990d+02, 1.6421336730440d+02, 1.6321626019843d+02/
      data (lpmn(lat, 4,17), lat = 1,36)/
     |   2.8167432661461d+01, 1.4111107257811d+02, 3.7079736677701d+01,
     |  -2.1744782073860d+02,-1.7079451635427d+02, 1.7365957906038d+02,
     |   2.5951105399583d+02,-7.3973815703735d+01,-2.6872445328027d+02,
     |   9.1127825611573d-01, 2.5521950156138d+02, 5.2686081431954d+01,
     |  -2.3451460783019d+02,-9.4404143432366d+01, 2.1104578548409d+02,
     |   1.2885801731787d+02,-1.8587748241923d+02,-1.5879460722889d+02,
     |   1.5879460722889d+02, 1.8587748241923d+02,-1.2885801731787d+02,
     |  -2.1104578548409d+02, 9.4404143432366d+01, 2.3451460783019d+02,
     |  -5.2686081431952d+01,-2.5521950156138d+02,-9.1127825611624d-01,
     |   2.6872445328027d+02, 7.3973815703736d+01,-2.5951105399583d+02,
     |  -1.7365957906038d+02, 1.7079451635427d+02, 2.1744782073860d+02,
     |  -3.7079736677700d+01,-1.4111107257811d+02,-2.8167432661461d+01/
      data (lpmn(lat, 5,17), lat = 1,36)/
     |   3.3084282122971d+00, 6.0095493541244d+01, 1.0154658524789d+02,
     |  -3.6744332410610d+01,-2.0882691010040d+02,-9.6865563619386d+01,
     |   1.9638935876476d+02, 2.1088853176241d+02,-1.0446723077690d+02,
     |  -2.4370869189897d+02, 2.3800674960776d+01, 2.4228069141164d+02,
     |   4.0308060998086d+01,-2.2561661892343d+02,-9.1831926021876d+01,
     |   2.0083983112899d+02, 1.3439979917840d+02,-1.7035898802574d+02,
     |  -1.7035898802574d+02, 1.3439979917840d+02, 2.0083983112899d+02,
     |  -9.1831926021876d+01,-2.2561661892343d+02, 4.0308060998087d+01,
     |   2.4228069141164d+02, 2.3800674960776d+01,-2.4370869189897d+02,
     |  -1.0446723077690d+02, 2.1088853176241d+02, 1.9638935876476d+02,
     |  -9.6865563619386d+01,-2.0882691010040d+02,-3.6744332410610d+01,
     |   1.0154658524789d+02, 6.0095493541244d+01, 3.3084282122971d+00/
      data (lpmn(lat, 6,17), lat = 1,36)/
     |   2.9094368457114d-01, 1.7529547103024d+01, 6.8961904077864d+01,
     |   6.0870043545076d+01,-8.1803487533218d+01,-1.8636886194634d+02,
     |  -3.7802782685551d+01, 2.0468588976730d+02, 1.6726863894386d+02,
     |  -1.2476384779479d+02,-2.2010767639673d+02, 3.9290084808929d+01,
     |   2.2946868992727d+02, 3.4627790799846d+01,-2.1512786684101d+02,
     |  -9.5959467537445d+01, 1.8615245359819d+02, 1.4617377491312d+02,
     |  -1.4617377491312d+02,-1.8615245359819d+02, 9.5959467537444d+01,
     |   2.1512786684101d+02,-3.4627790799846d+01,-2.2946868992727d+02,
     |  -3.9290084808931d+01, 2.2010767639673d+02, 1.2476384779479d+02,
     |  -1.6726863894386d+02,-2.0468588976731d+02, 3.7802782685550d+01,
     |   1.8636886194634d+02, 8.1803487533218d+01,-6.0870043545076d+01,
     |  -6.8961904077864d+01,-1.7529547103024d+01,-2.9094368457114d-01/
      data (lpmn(lat, 7,17), lat = 1,36)/
     |   2.0196954304103d-02, 3.8856178950788d+00, 3.0113049002120d+01,
     |   6.4916142356582d+01, 2.4177129591060d+01,-1.0688930312579d+02,
     |  -1.5765595011514d+02, 6.8331154224077d+00, 2.0236770558608d+02,
     |   1.3085898301694d+02,-1.3523270344155d+02,-1.9970295476681d+02,
     |   4.5991785301697d+01, 2.1722785725162d+02, 3.7592284151590d+01,
     |  -2.0178447836401d+02,-1.0825024905511d+02, 1.6376566933966d+02,
     |   1.6376566933966d+02,-1.0825024905511d+02,-2.0178447836401d+02,
     |   3.7592284151589d+01, 2.1722785725162d+02, 4.5991785301696d+01,
     |  -1.9970295476681d+02,-1.3523270344155d+02, 1.3085898301694d+02,
     |   2.0236770558609d+02, 6.8331154224082d+00,-1.5765595011514d+02,
     |  -1.0688930312579d+02, 2.4177129591060d+01, 6.4916142356582d+01,
     |   3.0113049002120d+01, 3.8856178950788d+00, 2.0196954304103d-02/
      data (lpmn(lat, 8,17), lat = 1,36)/
     |   1.1431655010920d-03, 6.8849590883215d-01, 9.8577896064768d+00,
     |   3.7698745242637d+01, 5.3792871960123d+01,-5.7716341218328d+00,
     |  -1.1750493325947d+02,-1.2819968867462d+02, 3.7732038397176d+01,
     |   1.9326611438065d+02, 1.0346217358771d+02,-1.3678308569187d+02,
     |  -1.8401970059106d+02, 4.2878873256839d+01, 2.0533444876129d+02,
     |   5.0648929057111d+01,-1.8293226138971d+02,-1.2863913173983d+02,
     |   1.2863913173983d+02, 1.8293226138971d+02,-5.0648929057110d+01,
     |  -2.0533444876129d+02,-4.2878873256839d+01, 1.8401970059106d+02,
     |   1.3678308569187d+02,-1.0346217358771d+02,-1.9326611438065d+02,
     |  -3.7732038397177d+01, 1.2819968867462d+02, 1.1750493325947d+02,
     |   5.7716341218329d+00,-5.3792871960123d+01,-3.7698745242637d+01,
     |  -9.8577896064769d+00,-6.8849590883215d-01,-1.1431655010920d-03/
      data (lpmn(lat, 9,17), lat = 1,36)/
     |   5.3848810543059d-05, 1.0035884788386d-01, 2.5704996424388d+00,
     |   1.5817007307552d+01, 4.0219360886076d+01, 3.9851260826279d+01,
     |  -2.7772141231620d+01,-1.1816795990600d+02,-1.0195238431425d+02,
     |   5.6091982959927d+01, 1.8069125161450d+02, 8.6192780587016d+01,
     |  -1.3016509082126d+02,-1.7369442014405d+02, 2.8911312872587d+01,
     |   1.9193284871554d+02, 7.4287969132658d+01,-1.5360833753955d+02,
     |  -1.5360833753955d+02, 7.4287969132658d+01, 1.9193284871554d+02,
     |   2.8911312872587d+01,-1.7369442014405d+02,-1.3016509082125d+02,
     |   8.6192780587015d+01, 1.8069125161450d+02, 5.6091982959927d+01,
     |  -1.0195238431425d+02,-1.1816795990600d+02,-2.7772141231620d+01,
     |   3.9851260826279d+01, 4.0219360886076d+01, 1.5817007307552d+01,
     |   2.5704996424389d+00, 1.0035884788386d-01, 5.3848810543059d-05/
      data (lpmn(lat,10,17), lat = 1,36)/
     |   2.1377024337453d-06, 1.2238317420157d-02, 5.5036515114729d-01,
     |   5.2090767106432d+00, 2.0320279775688d+01, 3.8807801985121d+01,
     |   2.6232409339433d+01,-4.1811619797493d+01,-1.1272146779574d+02,
     |  -8.1458801293498d+01, 6.3358440650400d+01, 1.6691566166328d+02,
     |   7.9405786680660d+01,-1.1530653002141d+02,-1.6773212194281d+02,
     |   3.0322646457693d+00, 1.7239681921768d+02, 1.0640746898185d+02,
     |  -1.0640746898185d+02,-1.7239681921768d+02,-3.0322646457702d+00,
     |   1.6773212194281d+02, 1.1530653002141d+02,-7.9405786680661d+01,
     |  -1.6691566166328d+02,-6.3358440650400d+01, 8.1458801293498d+01,
     |   1.1272146779574d+02, 4.1811619797493d+01,-2.6232409339433d+01,
     |  -3.8807801985121d+01,-2.0320279775687d+01,-5.2090767106432d+00,
     |  -5.5036515114730d-01,-1.2238317420157d-02,-2.1377024337453d-06/
      data (lpmn(lat,11,17), lat = 1,36)/
     |   7.1985545930626d-08, 1.2596957696223d-03, 9.8289671926119d-02,
     |   1.3954808281642d+00, 7.8584483583845d+00, 2.2809821091417d+01,
     |   3.5022432603352d+01, 1.5048378607836d+01,-4.8642499385141d+01,
     |  -1.0415848721682d+02,-6.7996264668834d+01, 6.0797791434099d+01,
     |   1.5267314870495d+02, 8.2521593470257d+01,-9.0852551646089d+01,
     |  -1.6237499117660d+02,-3.4760664679828d+01, 1.3847163710642d+02,
     |   1.3847163710642d+02,-3.4760664679827d+01,-1.6237499117660d+02,
     |  -9.0852551646089d+01, 8.2521593470256d+01, 1.5267314870495d+02,
     |   6.0797791434100d+01,-6.7996264668834d+01,-1.0415848721682d+02,
     |  -4.8642499385141d+01, 1.5048378607836d+01, 3.5022432603353d+01,
     |   2.2809821091417d+01, 7.8584483583845d+00, 1.3954808281642d+00,
     |   9.8289671926121d-02, 1.2596957696223d-03, 7.1985545930626d-08/
      data (lpmn(lat,12,17), lat = 1,36)/
     |   2.0583218826345d-09, 1.0971499580553d-04, 1.4734414997272d-02,
     |   3.0893681508876d-01, 2.4325631837622d+00, 9.8951577308108d+00,
     |   2.3355778527824d+01, 3.0373371688447d+01, 7.4869142737140d+00,
     |  -4.9314083715024d+01,-9.4357957325434d+01,-6.1678275144172d+01,
     |   4.9163002975296d+01, 1.3662813687019d+02, 9.3305371946604d+01,
     |  -5.4425864242065d+01,-1.4953127320207d+02,-7.9918244345917d+01,
     |   7.9918244345917d+01, 1.4953127320207d+02, 5.4425864242066d+01,
     |  -9.3305371946603d+01,-1.3662813687019d+02,-4.9163002975296d+01,
     |   6.1678275144172d+01, 9.4357957325434d+01, 4.9314083715024d+01,
     |  -7.4869142737140d+00,-3.0373371688447d+01,-2.3355778527824d+01,
     |  -9.8951577308107d+00,-2.4325631837622d+00,-3.0893681508877d-01,
     |  -1.4734414997272d-02,-1.0971499580553d-04,-2.0583218826345d-09/
      data (lpmn(lat,13,17), lat = 1,36)/
     |   4.9728423260548d-11, 8.0535018975412d-06, 1.8509786478166d-03,
     |   5.6716599257068d-02, 6.1253022416426d-01, 3.3566693016115d+00,
     |   1.0952116745410d+01, 2.2359896090581d+01, 2.6012412197654d+01,
     |   3.9714790332800d+00,-4.4757793181017d+01,-8.3830339995491d+01,
     |  -6.1333910935888d+01, 2.8794427121528d+01, 1.1491803741261d+02,
     |   1.0605559924043d+02,-4.9827134645603d+00,-1.1609957778813d+02,
     |  -1.1609957778813d+02,-4.9827134645604d+00, 1.0605559924043d+02,
     |   1.1491803741261d+02, 2.8794427121528d+01,-6.1333910935888d+01,
     |  -8.3830339995491d+01,-4.4757793181017d+01, 3.9714790332798d+00,
     |   2.6012412197654d+01, 2.2359896090581d+01, 1.0952116745410d+01,
     |   3.3566693016115d+00, 6.1253022416426d-01, 5.6716599257069d-02,
     |   1.8509786478166d-03, 8.0535018975412d-06, 4.9728423260548d-11/
      data (lpmn(lat,14,17), lat = 1,36)/
     |   1.0021238150152d-12, 4.9215093237620d-07, 1.9277169443559d-04,
     |   8.5685883251256d-03, 1.2532779468723d-01, 9.0430348344480d-01,
     |   3.8893295751182d+00, 1.0902180337105d+01, 2.0272496537766d+01,
     |   2.2538362996337d+01, 4.2933448239621d+00,-3.5558394470312d+01,
     |  -7.1510569329743d+01,-6.3898726557510d+01, 8.1114213737398d-01,
     |   8.1594518753981d+01, 1.0869885851780d+02, 5.0089306197954d+01,
     |  -5.0089306197954d+01,-1.0869885851780d+02,-8.1594518753982d+01,
     |  -8.1114213737408d-01, 6.3898726557510d+01, 7.1510569329743d+01,
     |   3.5558394470313d+01,-4.2933448239621d+00,-2.2538362996337d+01,
     |  -2.0272496537766d+01,-1.0902180337105d+01,-3.8893295751182d+00,
     |  -9.0430348344480d-01,-1.2532779468723d-01,-8.5685883251258d-03,
     |  -1.9277169443559d-04,-4.9215093237620d-07,-1.0021238150152d-12/
      data (lpmn(lat,15,17), lat = 1,36)/
     |   1.6412659657630d-14, 2.4406932410387d-08, 1.6240753413109d-05,
     |   1.0415142027675d-03, 2.0449189555427d-02, 1.9144232844576d-01,
     |   1.0570935772924d+00, 3.8501932457883d+00, 9.7693149723921d+00,
     |   1.7362695730641d+01, 1.9859621212571d+01, 7.5651368488900d+00,
     |  -2.2145919421368d+01,-5.4834722353437d+01,-6.3234978663095d+01,
     |  -2.9483479444958d+01, 3.2834207311095d+01, 8.2376710899755d+01,
     |   8.2376710899755d+01, 3.2834207311095d+01,-2.9483479444958d+01,
     |  -6.3234978663095d+01,-5.4834722353437d+01,-2.2145919421368d+01,
     |   7.5651368488899d+00, 1.9859621212571d+01, 1.7362695730641d+01,
     |   9.7693149723921d+00, 3.8501932457883d+00, 1.0570935772924d+00,
     |   1.9144232844576d-01, 2.0449189555427d-02, 1.0415142027675d-03,
     |   1.6240753413110d-05, 2.4406932410387d-08, 1.6412659657630d-14/
      data (lpmn(lat,16,17), lat = 1,36)/
     |   2.0706838577119d-16, 9.3132806086106d-10, 1.0502006581493d-06,
     |   9.6767735732316d-05, 2.5339661700342d-03, 3.0468466173594d-02,
     |   2.1244859917602d-01, 9.7635155800823d-01, 3.1817776488781d+00,
     |   7.6366318191757d+00, 1.3578024671144d+01, 1.7062117655618d+01,
     |   1.1809670462300d+01,-5.8906246958831d+00,-3.1093599711667d+01,
     |  -4.9600221889606d+01,-4.6598134574782d+01,-1.9122097524007d+01,
     |   1.9122097524007d+01, 4.6598134574782d+01, 4.9600221889606d+01,
     |   3.1093599711667d+01, 5.8906246958831d+00,-1.1809670462300d+01,
     |  -1.7062117655618d+01,-1.3578024671144d+01,-7.6366318191757d+00,
     |  -3.1817776488781d+00,-9.7635155800823d-01,-2.1244859917602d-01,
     |  -3.0468466173594d-02,-2.5339661700342d-03,-9.6767735732317d-05,
     |  -1.0502006581493d-06,-9.3132806086106d-10,-2.0706838577119d-16/
      data (lpmn(lat,17,17), lat = 1,36)/
     |   1.7508073134979d-18, 2.3794680586556d-11, 4.5381370819052d-08,
     |   5.9887978219435d-06, 2.0813299478056d-04, 3.1906847057452d-03,
     |   2.7780038194188d-02, 1.5821680749744d-01, 6.4185094267717d-01,
     |   1.9552730734078d+00, 4.6142681468799d+00, 8.5465384512369d+00,
     |   1.2313720670253d+01, 1.3076624083002d+01, 8.0810749015271d+00,
     |  -2.8671980482820d+00,-1.5975034969556d+01,-2.4953663562943d+01,
     |  -2.4953663562943d+01,-1.5975034969556d+01,-2.8671980482820d+00,
     |   8.0810749015271d+00, 1.3076624083002d+01, 1.2313720670253d+01,
     |   8.5465384512369d+00, 4.6142681468799d+00, 1.9552730734078d+00,
     |   6.4185094267717d-01, 1.5821680749744d-01, 2.7780038194188d-02,
     |   3.1906847057452d-03, 2.0813299478056d-04, 5.9887978219436d-06,
     |   4.5381370819054d-08, 2.3794680586556d-11, 1.7508073134979d-18/
      data (lpmn(lat, 0,18), lat = 1,36)/
     |  -1.2411006454385d+03, 1.3040904826845d+01, 5.8259120603230d+02,
     |  -6.5181251740103d+01,-4.3344074925931d+02, 9.0336711506218d+01,
     |   3.5825303245987d+02,-1.0945768474207d+02,-3.1016957937057d+02,
     |   1.2615159434043d+02, 2.7538395521840d+02,-1.4176144196732d+02,
     |  -2.4816696291212d+02, 1.5703036228972d+02, 2.2564184629224d+02,
     |  -1.7250559760758d+02,-2.0616484063903d+02, 1.8869498379421d+02,
     |   1.8869498379421d+02,-2.0616484063903d+02,-1.7250559760758d+02,
     |   2.2564184629224d+02, 1.5703036228972d+02,-2.4816696291213d+02,
     |  -1.4176144196732d+02, 2.7538395521840d+02, 1.2615159434043d+02,
     |  -3.1016957937057d+02,-1.0945768474207d+02, 3.5825303245986d+02,
     |   9.0336711506218d+01,-4.3344074925931d+02,-6.5181251740107d+01,
     |   5.8259120603230d+02, 1.3040904826845d+01,-1.2411006454385d+03/
      data (lpmn(lat, 1,18), lat = 1,36)/
     |   2.9339066162654d+02,-6.2925637004047d+02, 1.0954913668457d+02,
     |   4.7309054832405d+02,-1.0519844239557d+02,-3.8174928509066d+02,
     |   1.1449013230745d+02, 3.2599207090627d+02,-1.2646066924449d+02,
     |  -2.8719808653385d+02, 1.3922157066868d+02, 2.5777522985640d+02,
     |  -1.5244680122727d+02,-2.3406537343963d+02, 1.6622290203597d+02,
     |   2.1406654850937d+02,-1.8080484591826d+02,-1.9657361146626d+02,
     |   1.9657361146626d+02, 1.8080484591826d+02,-2.1406654850937d+02,
     |  -1.6622290203597d+02, 2.3406537343963d+02, 1.5244680122727d+02,
     |  -2.5777522985640d+02,-1.3922157066868d+02, 2.8719808653385d+02,
     |   1.2646066924449d+02,-3.2599207090627d+02,-1.1449013230745d+02,
     |   3.8174928509066d+02, 1.0519844239557d+02,-4.7309054832405d+02,
     |  -1.0954913668457d+02, 6.2925637004047d+02,-2.9339066162654d+02/
      data (lpmn(lat, 2,18), lat = 1,36)/
     |   5.8195444971796d+02,-2.0030243477669d+02,-3.9552825352381d+02,
     |   2.0334838636425d+02, 3.7413201657943d+02,-1.6185518684937d+02,
     |  -3.2585410872229d+02, 1.5129558124531d+02, 2.8842952311662d+02,
     |  -1.5188127972085d+02,-2.5963547841126d+02, 1.5743166869931d+02,
     |   2.3668452149391d+02,-1.6574108515126d+02,-2.1776490813127d+02,
     |   1.7598919520875d+02, 2.0175130312437d+02,-1.8795420243345d+02,
     |  -1.8795420243345d+02, 2.0175130312437d+02, 1.7598919520875d+02,
     |  -2.1776490813127d+02,-1.6574108515126d+02, 2.3668452149391d+02,
     |   1.5743166869931d+02,-2.5963547841126d+02,-1.5188127972085d+02,
     |   2.8842952311662d+02, 1.5129558124531d+02,-3.2585410872228d+02,
     |  -1.6185518684937d+02, 3.7413201657943d+02, 2.0334838636425d+02,
     |  -3.9552825352381d+02,-2.0030243477669d+02, 5.8195444971796d+02/
      data (lpmn(lat, 3,18), lat = 1,36)/
     |   1.9609710654094d+02, 1.6060156503975d+02,-2.7890471469204d+02,
     |  -2.3407185255229d+02, 2.6429262768605d+02, 2.7837203482747d+02,
     |  -2.1146706531626d+02,-2.6578949459118d+02, 1.8707898328054d+02,
     |   2.4686757546117d+02,-1.7726427499130d+02,-2.2931365761332d+02,
     |   1.7515479546034d+02, 2.1425866262972d+02,-1.7763445620642d+02,
     |  -2.0165428637665d+02, 1.8324562868384d+02, 1.9132808362103d+02,
     |  -1.9132808362103d+02,-1.8324562868384d+02, 2.0165428637665d+02,
     |   1.7763445620642d+02,-2.1425866262972d+02,-1.7515479546034d+02,
     |   2.2931365761332d+02, 1.7726427499130d+02,-2.4686757546117d+02,
     |  -1.8707898328054d+02, 2.6578949459118d+02, 2.1146706531627d+02,
     |  -2.7837203482747d+02,-2.6429262768605d+02, 2.3407185255228d+02,
     |   2.7890471469204d+02,-1.6060156503975d+02,-1.9609710654094d+02/
      data (lpmn(lat, 4,18), lat = 1,36)/
     |   3.6019013946612d+01, 1.6607106686901d+02,-5.5514911442055d-01,
     |  -2.8065489753943d+02,-1.0437860859149d+02, 2.9216161876063d+02,
     |   1.8607017811759d+02,-2.4534438584448d+02,-2.0385435891828d+02,
     |   2.1490472215615d+02, 2.0370261802257d+02,-1.9769909454238d+02,
     |  -1.9870990048211d+02, 1.8885811780266d+02, 1.9307861657006d+02,
     |  -1.8540321137651d+02,-1.8842511376071d+02, 1.8560985141718d+02,
     |   1.8560985141718d+02,-1.8842511376071d+02,-1.8540321137651d+02,
     |   1.9307861657006d+02, 1.8885811780266d+02,-1.9870990048211d+02,
     |  -1.9769909454239d+02, 2.0370261802257d+02, 2.1490472215615d+02,
     |  -2.0385435891827d+02,-2.4534438584448d+02, 1.8607017811759d+02,
     |   2.9216161876063d+02,-1.0437860859149d+02,-2.8065489753943d+02,
     |  -5.5514911442173d-01, 1.6607106686901d+02, 3.6019013946612d+01/
      data (lpmn(lat, 5,18), lat = 1,36)/
     |   4.4990011469628d+00, 7.7550068429020d+01, 1.0803301399594d+02,
     |  -9.3501978000116d+01,-2.4603872421276d+02,-6.1831441170469d-01,
     |   2.9195309630338d+02, 1.0154472025957d+02,-2.6159815921341d+02,
     |  -1.4416929568359d+02, 2.3206963485909d+02, 1.6236284368792d+02,
     |  -2.1088558659151d+02,-1.7089910964444d+02, 1.9661537176396d+02,
     |   1.7604688973220d+02,-1.8718445259820d+02,-1.8085262891539d+02,
     |   1.8085262891539d+02, 1.8718445259820d+02,-1.7604688973220d+02,
     |  -1.9661537176396d+02, 1.7089910964444d+02, 2.1088558659150d+02,
     |  -1.6236284368792d+02,-2.3206963485909d+02, 1.4416929568359d+02,
     |   2.6159815921341d+02,-1.0154472025957d+02,-2.9195309630338d+02,
     |   6.1831441170469d-01, 2.4603872421276d+02, 9.3501978000117d+01,
     |  -1.0803301399594d+02,-7.7550068429020d+01,-4.4990011469627d+00/
      data (lpmn(lat, 6,18), lat = 1,36)/
     |   4.2119591980402d-01, 2.4423430424150d+01, 8.6579394167300d+01,
     |   4.6853935720199d+01,-1.4499915565230d+02,-1.9303287352505d+02,
     |   7.7408311203720d+01, 2.7105166417668d+02, 2.9468590875205d+01,
     |  -2.6229986072608d+02,-9.1184689271197d+01, 2.3877604514975d+02,
     |   1.2656654428707d+02,-2.1637821335544d+02,-1.4910671850764d+02,
     |   1.9748655569154d+02, 1.6600526503638d+02,-1.8128451753928d+02,
     |  -1.8128451753928d+02, 1.6600526503638d+02, 1.9748655569154d+02,
     |  -1.4910671850764d+02,-2.1637821335544d+02, 1.2656654428707d+02,
     |   2.3877604514975d+02,-9.1184689271197d+01,-2.6229986072608d+02,
     |   2.9468590875204d+01, 2.7105166417668d+02, 7.7408311203721d+01,
     |  -1.9303287352505d+02,-1.4499915565230d+02, 4.6853935720199d+01,
     |   8.6579394167301d+01, 2.4423430424150d+01, 4.2119591980402d-01/
      data (lpmn(lat, 7,18), lat = 1,36)/
     |   3.1194603741526d-02, 5.8229612260523d+00, 4.1963896415273d+01,
     |   7.5790488157652d+01,-7.8281953448753d+00,-1.6612792163948d+02,
     |  -1.3408438501296d+02, 1.3054371381666d+02, 2.3780807670170d+02,
     |  -2.6986046380693d+01,-2.5177155032232d+02,-4.8592126694099d+01,
     |   2.3701683744537d+02, 9.9671722830444d+01,-2.1471994007886d+02,
     |  -1.3624432800406d+02, 1.9065430500991d+02, 1.6519177610451d+02,
     |  -1.6519177610451d+02,-1.9065430500991d+02, 1.3624432800406d+02,
     |   2.1471994007886d+02,-9.9671722830444d+01,-2.3701683744537d+02,
     |   4.8592126694097d+01, 2.5177155032232d+02, 2.6986046380693d+01,
     |  -2.3780807670170d+02,-1.3054371381666d+02, 1.3408438501296d+02,
     |   1.6612792163948d+02, 7.8281953448755d+00,-7.5790488157652d+01,
     |  -4.1963896415274d+01,-5.8229612260523d+00,-3.1194603741526d-02/
      data (lpmn(lat, 8,18), lat = 1,36)/
     |   1.8895793704314d-03, 1.1100645847294d+00, 1.5023288573833d+01,
     |   5.1389157760938d+01, 5.3981493649159d+01,-5.0748039143710d+01,
     |  -1.6557747844736d+02,-7.8282188001949d+01, 1.6160645506722d+02,
     |   2.0023616576906d+02,-6.6699279269875d+01,-2.3516212896043d+02,
     |  -1.8875642347346d+01, 2.2943130869648d+02, 8.4330326214885d+01,
     |  -2.0638256249899d+02,-1.3446696985423d+02, 1.7430742804117d+02,
     |   1.7430742804117d+02,-1.3446696985423d+02,-2.0638256249899d+02,
     |   8.4330326214885d+01, 2.2943130869648d+02,-1.8875642347347d+01,
     |  -2.3516212896043d+02,-6.6699279269875d+01, 2.0023616576906d+02,
     |   1.6160645506722d+02,-7.8282188001949d+01,-1.6557747844736d+02,
     |  -5.0748039143710d+01, 5.3981493649159d+01, 5.1389157760938d+01,
     |   1.5023288573833d+01, 1.1100645847294d+00, 1.8895793704314d-03/
      data (lpmn(lat, 9,18), lat = 1,36)/
     |   9.5650755510469d-05, 1.7453299200345d-01, 4.2685196501755d+00,
     |   2.4173043626642d+01, 5.2309255612896d+01, 2.8247151039311d+01,
     |  -8.0001602662010d+01,-1.5147574856344d+02,-3.1591693636939d+01,
     |   1.7502928261754d+02, 1.6501544571024d+02,-9.0271996257669d+01,
     |  -2.1724445760605d+02,-3.4342608181289d+00, 2.1811628830094d+02,
     |   8.2361889756233d+01,-1.9051797434023d+02,-1.4445001771271d+02,
     |   1.4445001771271d+02, 1.9051797434023d+02,-8.2361889756232d+01,
     |  -2.1811628830094d+02, 3.4342608181285d+00, 2.1724445760605d+02,
     |   9.0271996257671d+01,-1.6501544571024d+02,-1.7502928261754d+02,
     |   3.1591693636938d+01, 1.5147574856344d+02, 8.0001602662011d+01,
     |  -2.8247151039311d+01,-5.2309255612896d+01,-2.4173043626642d+01,
     |  -4.2685196501756d+00,-1.7453299200345d-01,-9.5650755510469d-05/
      data (lpmn(lat,10,18), lat = 1,36)/
     |   4.1027172154093d-06, 2.3059837057607d-02, 9.9709831769301d-01,
     |   8.8273317144743d+00, 3.0766824514187d+01, 4.6671407142108d+01,
     |   3.9242254724681d+00,-9.6325301126688d+01,-1.3109195711478d+02,
     |   2.8652910064998d+00, 1.7586450139087d+02, 1.3695955932365d+02,
     |  -9.9169900403886d+01,-2.0144023618254d+02,-3.0314112116230d+00,
     |   2.0336885090344d+02, 9.4453673115589d+01,-1.6363545615580d+02,
     |  -1.6363545615580d+02, 9.4453673115589d+01, 2.0336885090344d+02,
     |  -3.0314112116227d+00,-2.0144023618254d+02,-9.9169900403885d+01,
     |   1.3695955932364d+02, 1.7586450139087d+02, 2.8652910064999d+00,
     |  -1.3109195711478d+02,-9.6325301126689d+01, 3.9242254724678d+00,
     |   4.6671407142108d+01, 3.0766824514187d+01, 8.8273317144744d+00,
     |   9.9709831769303d-01, 2.3059837057607d-02, 4.1027172154093d-06/
      data (lpmn(lat,11,18), lat = 1,36)/
     |   1.5034685687158d-07, 2.5885143342761d-03, 1.9518676880810d-01,
     |   2.6196061248218d+00, 1.3508939899007d+01, 3.3857538878747d+01,
     |   3.7365856821492d+01,-1.5575285892183d+01,-1.0213917490336d+02,
     |  -1.1025666689410d+02, 2.4165652770876d+01, 1.6866595648285d+02,
     |   1.1889510180509d+02,-9.4672168485442d+01,-1.8893204778674d+02,
     |  -1.8123819211314d+01, 1.8231085334825d+02, 1.1885261935605d+02,
     |  -1.1885261935605d+02,-1.8231085334825d+02, 1.8123819211313d+01,
     |   1.8893204778674d+02, 9.4672168485442d+01,-1.1889510180509d+02,
     |  -1.6866595648285d+02,-2.4165652770876d+01, 1.1025666689410d+02,
     |   1.0213917490337d+02, 1.5575285892184d+01,-3.7365856821492d+01,
     |  -3.3857538878747d+01,-1.3508939899007d+01,-2.6196061248218d+00,
     |  -1.9518676880810d-01,-2.5885143342761d-03,-1.5034685687158d-07/
      data (lpmn(lat,12,18), lat = 1,36)/
     |   4.7237274164908d-09, 2.4814674748733d-04, 3.2331149280473d-02,
     |   6.4563065042712d-01, 4.7258989254587d+00, 1.7215910312770d+01,
     |   3.3731539058270d+01, 2.7280143027195d+01,-2.8611874600895d+01,
     |  -1.0049593539281d+02,-9.2999550966175d+01, 3.2697571140565d+01,
     |   1.5647820192525d+02, 1.1166453583540d+02,-7.6970683767328d+01,
     |  -1.7755142779052d+02,-4.8239027735883d+01, 1.4769323177575d+02,
     |   1.4769323177575d+02,-4.8239027735882d+01,-1.7755142779052d+02,
     |  -7.6970683767328d+01, 1.1166453583540d+02, 1.5647820192525d+02,
     |   3.2697571140566d+01,-9.2999550966175d+01,-1.0049593539281d+02,
     |  -2.8611874600896d+01, 2.7280143027195d+01, 3.3731539058270d+01,
     |   1.7215910312770d+01, 4.7258989254587d+00, 6.4563065042713d-01,
     |   3.2331149280474d-02, 2.4814674748733d-04, 4.7237274164908d-09/
      data (lpmn(lat,13,18), lat = 1,36)/
     |   1.2710389235262d-10, 2.0314579631127d-05, 4.5436685044113d-03,
     |   1.3334840261945d-01, 1.3525940925019d+00, 6.7764893859395d+00,
     |   1.9346512812038d+01, 3.1394968874705d+01, 1.8712512469322d+01,
     |  -3.4858957017734d+01,-9.4122453642207d+01,-8.1434951153006d+01,
     |   2.9312651045565d+01, 1.3998109943939d+02, 1.1373845916886d+02,
     |  -4.5004199478485d+01,-1.6022469862219d+02,-8.8867697775489d+01,
     |   8.8867697775489d+01, 1.6022469862219d+02, 4.5004199478485d+01,
     |  -1.1373845916886d+02,-1.3998109943939d+02,-2.9312651045565d+01,
     |   8.1434951153005d+01, 9.4122453642207d+01, 3.4858957017734d+01,
     |  -1.8712512469322d+01,-3.1394968874705d+01,-1.9346512812038d+01,
     |  -6.7764893859395d+00,-1.3525940925019d+00,-1.3334840261945d-01,
     |  -4.5436685044114d-03,-2.0314579631127d-05,-1.2710389235262d-10/
      data (lpmn(lat,14,18), lat = 1,36)/
     |   2.9099438562314d-12, 1.4119717809751d-06, 5.3955911699626d-04,
     |   2.3072281468980d-02, 3.1933968603838d-01, 2.1351054769671d+00,
     |   8.2584629807603d+00, 1.9795246224200d+01, 2.8040187640973d+01,
     |   1.3109094635478d+01,-3.4704209223574d+01,-8.4656553033439d+01,
     |  -7.5671222423100d+01, 1.4930878413460d+01, 1.1686428123626d+02,
     |   1.1975204410971d+02, 1.5818601242085d+00,-1.2400877919159d+02,
     |  -1.2400877919159d+02, 1.5818601242083d+00, 1.1975204410971d+02,
     |   1.1686428123626d+02, 1.4930878413460d+01,-7.5671222423100d+01,
     |  -8.4656553033440d+01,-3.4704209223574d+01, 1.3109094635478d+01,
     |   2.8040187640973d+01, 1.9795246224200d+01, 8.2584629807604d+00,
     |   2.1351054769671d+00, 3.1933968603838d-01, 2.3072281468980d-02,
     |   5.3955911699628d-04, 1.4119717809751d-06, 2.9099438562314d-12/
      data (lpmn(lat,15,18), lat = 1,36)/
     |   5.5891308252427d-14, 8.2197828337862d-08, 5.3471455150987d-05,
     |   3.3106135199659d-03, 6.1865775485177d-02, 5.4183085443882d-01,
     |   2.7368507583479d+00, 8.8272335610790d+00, 1.8763515272047d+01,
     |   2.4596574750938d+01, 1.1006189655375d+01,-2.8744050685889d+01,
     |  -7.2121031494499d+01,-7.3384751023503d+01,-8.6953381484102d+00,
     |   8.2137541844452d+01, 1.1771282041655d+02, 5.5487235709117d+01,
     |  -5.5487235709117d+01,-1.1771282041655d+02,-8.2137541844452d+01,
     |   8.6953381484101d+00, 7.3384751023503d+01, 7.2121031494499d+01,
     |   2.8744050685889d+01,-1.1006189655375d+01,-2.4596574750938d+01,
     |  -1.8763515272047d+01,-8.8272335610790d+00,-2.7368507583479d+00,
     |  -5.4183085443882d-01,-6.1865775485177d-02,-3.3106135199660d-03,
     |  -5.3471455150989d-05,-8.2197828337862d-08,-5.5891308252427d-14/
      data (lpmn(lat,16,18), lat = 1,36)/
     |   8.7669941909993d-16, 3.9028123876538d-09, 4.3099824826333d-06,
     |   3.8453286149219d-04, 9.6278874353427d-03, 1.0908353289109d-01,
     |   7.0399178565224d-01, 2.9249445885739d+00, 8.3292050792371d+00,
     |   1.6499201042028d+01, 2.1392816729280d+01, 1.1970997905288d+01,
     |  -1.7686187260643d+01,-5.4822520154010d+01,-6.8837945438873d+01,
     |  -3.5859079084453d+01, 3.2168096254057d+01, 8.8116274214505d+01,
     |   8.8116274214505d+01, 3.2168096254057d+01,-3.5859079084452d+01,
     |  -6.8837945438873d+01,-5.4822520154010d+01,-1.7686187260643d+01,
     |   1.1970997905288d+01, 2.1392816729280d+01, 1.6499201042028d+01,
     |   8.3292050792372d+00, 2.9249445885740d+00, 7.0399178565225d-01,
     |   1.0908353289109d-01, 9.6278874353427d-03, 3.8453286149219d-04,
     |   4.3099824826334d-06, 3.9028123876538d-09, 8.7669941909992d-16/
      data (lpmn(lat,17,18), lat = 1,36)/
     |   1.0637082159458d-17, 1.4318900490066d-10, 2.6784600406251d-07,
     |   3.4309646667543d-05, 1.1444001096411d-03, 1.6624722157251d-02,
     |   1.3513440041811d-01, 7.0551067489311d-01, 2.5617790597371d+00,
     |   6.7532639350116d+00, 1.3070291455803d+01, 1.7906098778131d+01,
     |   1.4279674119345d+01,-3.1905887382788d+00,-3.0581499652691d+01,
     |  -5.2376205299475d+01,-5.0762887378574d+01,-2.1111101710234d+01,
     |   2.1111101710234d+01, 5.0762887378574d+01, 5.2376205299475d+01,
     |   3.0581499652691d+01, 3.1905887382788d+00,-1.4279674119345d+01,
     |  -1.7906098778131d+01,-1.3070291455803d+01,-6.7532639350116d+00,
     |  -2.5617790597371d+00,-7.0551067489311d-01,-1.3513440041811d-01,
     |  -1.6624722157251d-02,-1.1444001096411d-03,-3.4309646667543d-05,
     |  -2.6784600406252d-07,-1.4318900490066d-10,-1.0637082159458d-17/
      data (lpmn(lat,18,18), lat = 1,36)/
     |   8.6799535002787d-20, 3.5301970749288d-12, 1.1165574954880d-08,
     |   2.0474822028051d-06, 9.0578118031707d-05, 1.6760112523377d-03,
     |   1.6987749539275d-02, 1.0968854917157d-01, 4.9427213087204d-01,
     |   1.6453144130679d+00, 4.1863550645362d+00, 8.2696431366722d+00,
     |   1.2605305865364d+01, 1.4129167095480d+01, 9.4648794693071d+00,
     |  -2.1068889415081d+00,-1.6583586550443d+01,-2.6707762419482d+01,
     |  -2.6707762419482d+01,-1.6583586550443d+01,-2.1068889415082d+00,
     |   9.4648794693071d+00, 1.4129167095480d+01, 1.2605305865364d+01,
     |   8.2696431366722d+00, 4.1863550645362d+00, 1.6453144130679d+00,
     |   4.9427213087204d-01, 1.0968854917157d-01, 1.6987749539275d-02,
     |   1.6760112523377d-03, 9.0578118031706d-05, 2.0474822028051d-06,
     |   1.1165574954880d-08, 3.5301970749288d-12, 8.6799535002786d-20/
      data (lpmn(lat, 0,19), lat = 1,36)/
     |  -1.3879620891568d+03, 1.2483868563840d+02, 6.2075598510087d+02,
     |  -2.3414762985833d+02,-4.1119872966490d+02, 2.8984761348705d+02,
     |   2.7567278714997d+02,-3.2115782878343d+02,-1.6539440621474d+02,
     |   3.3359803141305d+02, 6.8028826176773d+01,-3.2927484481445d+02,
     |   1.9980846167573d+01, 3.0948092762131d+02,-9.9184660348878d+01,
     |  -2.7535459190154d+02, 1.6893033463870d+02, 2.2808186542489d+02,
     |  -2.2808186542489d+02,-1.6893033463870d+02, 2.7535459190154d+02,
     |   9.9184660348879d+01,-3.0948092762131d+02,-1.9980846167571d+01,
     |   3.2927484481445d+02,-6.8028826176773d+01,-3.3359803141305d+02,
     |   1.6539440621474d+02, 3.2115782878343d+02,-2.7567278714996d+02,
     |  -2.8984761348705d+02, 4.1119872966490d+02, 2.3414762985833d+02,
     |  -6.2075598510087d+02,-1.2483868563840d+02, 1.3879620891568d+03/
      data (lpmn(lat, 1,19), lat = 1,36)/
     |   2.4945335158881d+02,-6.8754729143388d+02, 2.4884041489787d+02,
     |   4.6875866790482d+02,-2.8650579824466d+02,-3.2115526356946d+02,
     |   3.1667523449232d+02, 2.0654906829043d+02,-3.3261083069362d+02,
     |  -1.0718000840690d+02, 3.3366307184445d+02, 1.7507427765176d+01,
     |  -3.2013911299593d+02, 6.3838629745676d+01, 2.9268930916239d+02,
     |  -1.3658212474407d+02,-2.5220471607952d+02, 1.9976836306276d+02,
     |   1.9976836306276d+02,-2.5220471607952d+02,-1.3658212474408d+02,
     |   2.9268930916239d+02, 6.3838629745677d+01,-3.2013911299594d+02,
     |   1.7507427765172d+01, 3.3366307184445d+02,-1.0718000840690d+02,
     |  -3.3261083069362d+02, 2.0654906829043d+02, 3.1667523449232d+02,
     |  -3.2115526356946d+02,-2.8650579824466d+02, 4.6875866790482d+02,
     |   2.4884041489787d+02,-6.8754729143388d+02, 2.4945335158881d+02/
      data (lpmn(lat, 2,19), lat = 1,36)/
     |   6.4576026888290d+02,-2.9064062185630d+02,-3.8769571165308d+02,
     |   3.4662061672875d+02, 3.1540376977457d+02,-3.3734975188333d+02,
     |  -2.1659999764401d+02, 3.3995614981741d+02, 1.2531701220850d+02,
     |  -3.3795780436734d+02,-4.1062181994569d+01, 3.2639370462053d+02,
     |  -3.6736512190677d+01,-3.0377696332192d+02, 1.0770641093969d+02,
     |   2.6994417212015d+02,-1.7095092549560d+02,-2.2538255231213d+02,
     |   2.2538255231213d+02, 1.7095092549560d+02,-2.6994417212015d+02,
     |  -1.0770641093969d+02, 3.0377696332192d+02, 3.6736512190675d+01,
     |  -3.2639370462053d+02, 4.1062181994569d+01, 3.3795780436734d+02,
     |  -1.2531701220850d+02,-3.3995614981741d+02, 2.1659999764401d+02,
     |   3.3734975188333d+02,-3.1540376977457d+02,-3.4662061672875d+02,
     |   3.8769571165308d+02, 2.9064062185630d+02,-6.4576026888290d+02/
      data (lpmn(lat, 3,19), lat = 1,36)/
     |   2.3296790884576d+02, 1.4723251943104d+02,-3.6172072740833d+02,
     |  -1.6831498270022d+02, 3.8811800890957d+02, 1.6525301628625d+02,
     |  -3.6193028072694d+02,-1.0748258665206d+02, 3.4632366674496d+02,
     |   4.1086283863953d+01,-3.3055398131154d+02, 2.5122939772022d+01,
     |   3.0931733487287d+02,-8.8210798981942d+01,-2.8049872662210d+02,
     |   1.4647464685913d+02, 2.4351276349425d+02,-1.9859468849728d+02,
     |  -1.9859468849728d+02, 2.4351276349425d+02, 1.4647464685913d+02,
     |  -2.8049872662210d+02,-8.8210798981942d+01, 3.0931733487287d+02,
     |   2.5122939772026d+01,-3.3055398131154d+02, 4.1086283863952d+01,
     |   3.4632366674496d+02,-1.0748258665206d+02,-3.6193028072694d+02,
     |   1.6525301628625d+02, 3.8811800890957d+02,-1.6831498270022d+02,
     |  -3.6172072740833d+02, 1.4723251943104d+02, 2.3296790884576d+02/
      data (lpmn(lat, 4,19), lat = 1,36)/
     |   4.5409956356381d+01, 1.9101185386745d+02,-5.3437433803555d+01,
     |  -3.3220452451268d+02, 5.0004017120756d+00, 3.7674043603223d+02,
     |   2.8229996291364d+01,-3.5414361490326d+02,-4.2086050167732d+00,
     |   3.3187615775385d+02,-3.7636372872860d+01,-3.0934443855144d+02,
     |   8.4675059828221d+01, 2.8359741499448d+02,-1.3185363149587d+02,
     |  -2.5306385527431d+02, 1.7657698468682d+02, 2.1728632803038d+02,
     |  -2.1728632803038d+02,-1.7657698468682d+02, 2.5306385527431d+02,
     |   1.3185363149587d+02,-2.8359741499448d+02,-8.4675059828219d+01,
     |   3.0934443855144d+02, 3.7636372872860d+01,-3.3187615775385d+02,
     |   4.2086050167721d+00, 3.5414361490326d+02,-2.8229996291361d+01,
     |  -3.7674043603223d+02,-5.0004017120756d+00, 3.3220452451268d+02,
     |   5.3437433803556d+01,-1.9101185386745d+02,-4.5409956356381d+01/
      data (lpmn(lat, 5,19), lat = 1,36)/
     |   6.0115054132985d+00, 9.7926907483292d+01, 1.0698907381166d+02,
     |  -1.6367700035378d+02,-2.5388373837935d+02, 1.3294532692578d+02,
     |   3.2467847428405d+02,-8.5086370517907d+01,-3.1790685433712d+02,
     |   8.3991470078282d+01, 2.9928962507589d+02,-1.0399813211426d+02,
     |  -2.7748546821874d+02, 1.3274451246576d+02, 2.5306894980609d+02,
     |  -1.6442464261112d+02,-2.2584209776210d+02, 1.9601383218724d+02,
     |   1.9601383218724d+02,-2.2584209776210d+02,-1.6442464261112d+02,
     |   2.5306894980609d+02, 1.3274451246576d+02,-2.7748546821874d+02,
     |  -1.0399813211426d+02, 2.9928962507589d+02, 8.3991470078283d+01,
     |  -3.1790685433712d+02,-8.5086370517908d+01, 3.2467847428405d+02,
     |   1.3294532692578d+02,-2.5388373837935d+02,-1.6367700035378d+02,
     |   1.0698907381166d+02, 9.7926907483292d+01, 6.0115054132984d+00/
      data (lpmn(lat, 6,19), lat = 1,36)/
     |   5.9689681236889d-01, 3.3222629069007d+01, 1.0467750996907d+02,
     |   1.8506775587828d+01,-2.1255535721916d+02,-1.5485228069841d+02,
     |   2.1451857928368d+02, 2.4797722608708d+02,-1.6797604613661d+02,
     |  -2.6261148281510d+02, 1.5119965052478d+02, 2.5523185816317d+02,
     |  -1.5391844860196d+02,-2.4065434738852d+02, 1.6679822315177d+02,
     |   2.2297779822380d+02,-1.8445509838398d+02,-2.0380380907275d+02,
     |   2.0380380907275d+02, 1.8445509838398d+02,-2.2297779822379d+02,
     |  -1.6679822315177d+02, 2.4065434738852d+02, 1.5391844860196d+02,
     |  -2.5523185816317d+02,-1.5119965052478d+02, 2.6261148281510d+02,
     |   1.6797604613661d+02,-2.4797722608708d+02,-2.1451857928368d+02,
     |   1.5485228069841d+02, 2.1255535721916d+02,-1.8506775587827d+01,
     |  -1.0467750996907d+02,-3.3222629069007d+01,-5.9689681236889d-01/
      data (lpmn(lat, 7,19), lat = 1,36)/
     |   4.6964848664829d-02, 8.4895444190781d+00, 5.6493022899139d+01,
     |   8.1746146371432d+01,-5.7297422672532d+01,-2.1542288504193d+02,
     |  -5.5757739222130d+01, 2.5342045076733d+02, 1.6286298122758d+02,
     |  -2.1926818258333d+02,-1.9954606731816d+02, 1.9571686211294d+02,
     |   2.0792013004225d+02,-1.8638116254836d+02,-2.0536058315359d+02,
     |   1.8638887965996d+02, 1.9875069080294d+02,-1.9153874802184d+02,
     |  -1.9153874802184d+02, 1.9875069080294d+02, 1.8638887965996d+02,
     |  -2.0536058315359d+02,-1.8638116254836d+02, 2.0792013004225d+02,
     |   1.9571686211295d+02,-1.9954606731816d+02,-2.1926818258333d+02,
     |   1.6286298122758d+02, 2.5342045076733d+02,-5.5757739222129d+01,
     |  -2.1542288504193d+02,-5.7297422672532d+01, 8.1746146371432d+01,
     |   5.6493022899139d+01, 8.4895444190781d+00, 4.6964848664829d-02/
      data (lpmn(lat, 8,19), lat = 1,36)/
     |   3.0297851319195d-03, 1.7334805266578d+00, 2.2073606878322d+01,
     |   6.6431528304058d+01, 4.2845171419669d+01,-1.1129102954874d+02,
     |  -1.8711684286252d+02, 2.9286451105989d+01, 2.5818868225209d+02,
     |   8.2796490664485d+01,-2.4284706345749d+02,-1.3912981257320d+02,
     |   2.1960272949281d+02, 1.6515598162697d+02,-2.0277261952158d+02,
     |  -1.7759566259645d+02, 1.9217991845005d+02, 1.8497247265496d+02,
     |  -1.8497247265496d+02,-1.9217991845005d+02, 1.7759566259645d+02,
     |   2.0277261952158d+02,-1.6515598162697d+02,-2.1960272949281d+02,
     |   1.3912981257319d+02, 2.4284706345749d+02,-8.2796490664484d+01,
     |  -2.5818868225209d+02,-2.9286451105990d+01, 1.8711684286252d+02,
     |   1.1129102954874d+02,-4.2845171419668d+01,-6.6431528304058d+01,
     |  -2.2073606878322d+01,-1.7334805266578d+00,-3.0297851319195d-03/
      data (lpmn(lat, 9,19), lat = 1,36)/
     |   1.6387822885583d-04, 2.9239356995798d-01, 6.8049581705655d+00,
     |   3.5142664479826d+01, 6.2255141979407d+01,-9.3194316325316d-02,
     |  -1.4113005418509d+02,-1.4224348462194d+02, 9.2891715639699d+01,
     |   2.4013678657307d+02, 1.6826197172605d+01,-2.4585789244161d+02,
     |  -8.9271955942935d+01, 2.2724082896488d+02, 1.3313632804217d+02,
     |  -2.0548534916748d+02,-1.6194758406341d+02, 1.8438281864809d+02,
     |   1.8438281864809d+02,-1.6194758406341d+02,-2.0548534916748d+02,
     |   1.3313632804217d+02, 2.2724082896488d+02,-8.9271955942936d+01,
     |  -2.4585789244161d+02, 1.6826197172605d+01, 2.4013678657307d+02,
     |   9.2891715639699d+01,-1.4224348462194d+02,-1.4113005418509d+02,
     |  -9.3194316325371d-02, 6.2255141979407d+01, 3.5142664479827d+01,
     |   6.8049581705656d+00, 2.9239356995798d-01, 1.6387822885583d-04/
      data (lpmn(lat,10,19), lat = 1,36)/
     |   7.5430965772266d-06, 4.1578895238715d-02, 1.7239777997602d+00,
     |   1.4187792153557d+01, 4.3415224217939d+01, 4.7495384617044d+01,
     |  -3.8214873887196d+01,-1.4974939630372d+02,-9.3426787358995d+01,
     |   1.3361100334953d+02, 2.1084549669491d+02,-3.0577374200794d+01,
     |  -2.3648198593289d+02,-5.4946157433220d+01, 2.2344419324104d+02,
     |   1.1603070292332d+02,-1.9609151780759d+02,-1.6089268714322d+02,
     |   1.6089268714322d+02, 1.9609151780759d+02,-1.1603070292332d+02,
     |  -2.2344419324104d+02, 5.4946157433219d+01, 2.3648198593289d+02,
     |   3.0577374200796d+01,-2.1084549669491d+02,-1.3361100334953d+02,
     |   9.3426787358995d+01, 1.4974939630372d+02, 3.8214873887197d+01,
     |  -4.7495384617044d+01,-4.3415224217939d+01,-1.4187792153557d+01,
     |  -1.7239777997602d+00,-4.1578895238715d-02,-7.5430965772266d-06/
      data (lpmn(lat,11,19), lat = 1,36)/
     |   2.9828074852127d-07, 5.0478394392187d-03, 3.6701661809365d-01,
     |   4.6347562739826d+00, 2.1657501146641d+01, 4.5352798169260d+01,
     |   2.7443607423630d+01,-6.6497997463776d+01,-1.4322641103899d+02,
     |  -4.9936082423417d+01, 1.5417981598549d+02, 1.8017324141584d+02,
     |  -5.8482938711171d+01,-2.2190497765615d+02,-3.8703665417887d+01,
     |   2.1146865072607d+02, 1.1587854220544d+02,-1.7337130260611d+02,
     |  -1.7337130260611d+02, 1.1587854220544d+02, 2.1146865072607d+02,
     |  -3.8703665417886d+01,-2.2190497765615d+02,-5.8482938711170d+01,
     |   1.8017324141584d+02, 1.5417981598549d+02,-4.9936082423416d+01,
     |  -1.4322641103899d+02,-6.6497997463776d+01, 2.7443607423630d+01,
     |   4.5352798169260d+01, 2.1657501146641d+01, 4.6347562739827d+00,
     |   3.6701661809366d-01, 5.0478394392187d-03, 2.9828074852127d-07/
      data (lpmn(lat,12,19), lat = 1,36)/
     |   1.0186483263389d-08, 5.2693070380158d-04, 6.6477372356411d-02,
     |   1.2596616615559d+00, 8.5087746703419d+00, 2.7282884242884d+01,
     |   4.1746926346994d+01, 7.2390881983815d+00,-8.3508887853988d+01,
     |  -1.2858643614293d+02,-1.7339246667097d+01, 1.5931054439484d+02,
     |   1.5515070162793d+02,-6.7795808401359d+01,-2.0668496422821d+02,
     |  -4.1503057957806d+01, 1.9106234369585d+02, 1.3179542100392d+02,
     |  -1.3179542100392d+02,-1.9106234369585d+02, 4.1503057957805d+01,
     |   2.0668496422821d+02, 6.7795808401359d+01,-1.5515070162793d+02,
     |  -1.5931054439484d+02, 1.7339246667097d+01, 1.2858643614293d+02,
     |   8.3508887853988d+01,-7.2390881983811d+00,-4.1746926346994d+01,
     |  -2.7282884242884d+01,-8.5087746703419d+00,-1.2596616615560d+00,
     |  -6.6477372356412d-02,-5.2693070380158d-04,-1.0186483263389d-08/
      data (lpmn(lat,13,19), lat = 1,36)/
     |   3.0084420106299d-10, 4.7416634433592d-05, 1.0303317894702d-02,
     |   2.8872782100239d-01, 2.7352486096151d+00, 1.2389392579896d+01,
     |   3.0111708540831d+01, 3.4780434961140d+01,-9.2808610379416d+00,
     |  -9.0373051767046d+01,-1.1206688004457d+02, 1.9049996094939d+00,
     |   1.5356241411599d+02, 1.3958679536600d+02,-5.9521613047074d+01,
     |  -1.9129237407628d+02,-6.2809824185004d+01, 1.5676699001204d+02,
     |   1.5676699001204d+02,-6.2809824185003d+01,-1.9129237407628d+02,
     |  -5.9521613047075d+01, 1.3958679536600d+02, 1.5356241411599d+02,
     |   1.9049996094949d+00,-1.1206688004457d+02,-9.0373051767046d+01,
     |  -9.2808610379417d+00, 3.4780434961140d+01, 3.0111708540831d+01,
     |   1.2389392579896d+01, 2.7352486096151d+00, 2.8872782100239d-01,
     |   1.0303317894702d-02, 4.7416634433592d-05, 3.0084420106299d-10/
      data (lpmn(lat,14,19), lat = 1,36)/
     |   7.6630786416837d-12, 3.6712193118258d-06, 1.3665847265742d-03,
     |   5.6068662654401d-02, 7.3104272916222d-01, 4.4926737235374d+00,
     |   1.5376117140127d+01, 3.0228598988695d+01, 2.7015982878815d+01,
     |  -1.9933285614032d+01,-8.9391345957683d+01,-9.8036926637868d+01,
     |   7.3716029024262d+00, 1.3958468793466d+02, 1.3376754452632d+02,
     |  -3.3785057722929d+01,-1.7044178722707d+02,-9.8176269720863d+01,
     |   9.8176269720862d+01, 1.7044178722707d+02, 3.3785057722930d+01,
     |  -1.3376754452632d+02,-1.3958468793466d+02,-7.3716029024256d+00,
     |   9.8036926637868d+01, 8.9391345957683d+01, 1.9933285614032d+01,
     |  -2.7015982878815d+01,-3.0228598988695d+01,-1.5376117140127d+01,
     |  -4.4926737235374d+00,-7.3104272916222d-01,-5.6068662654402d-02,
     |  -1.3665847265742d-03,-3.6712193118258d-06,-7.6630786416837d-12/
      data (lpmn(lat,15,19), lat = 1,36)/
     |   1.6705289945672d-13, 2.4281639861024d-07, 1.5421158655150d-04,
     |   9.1963990947867d-03, 1.6294569556688d-01, 1.3267196595280d+00,
     |   6.0622651943194d+00, 1.6926691321842d+01, 2.8403007094670d+01,
     |   2.0614951924459d+01,-2.3931974138718d+01,-8.2692453837129d+01,
     |  -8.8405465026563d+01,-2.3078191323039d-01, 1.1689292284111d+02,
     |   1.3332778527480d+02, 8.9092729265310d+00,-1.3187734373629d+02,
     |  -1.3187734373629d+02, 8.9092729265307d+00, 1.3332778527480d+02,
     |   1.1689292284111d+02,-2.3078191323027d-01,-8.8405465026563d+01,
     |  -8.2692453837130d+01,-2.3931974138718d+01, 2.0614951924459d+01,
     |   2.8403007094670d+01, 1.6926691321842d+01, 6.0622651943194d+00,
     |   1.3267196595280d+00, 1.6294569556688d-01, 9.1963990947868d-03,
     |   1.5421158655151d-04, 2.4281639861024d-07, 1.6705289945672d-13/
      data (lpmn(lat,16,19), lat = 1,36)/
     |   3.0702257939164d-15, 1.3520180724873d-08, 1.4603906413811d-05,
     |   1.2589888120050d-03, 3.0041718598720d-02, 3.1908056044015d-01,
     |   1.8900633401445d+00, 6.9953437090668d+00, 1.6894886271314d+01,
     |   2.5568492863791d+01, 1.6875760344642d+01,-2.1370442146754d+01,
     |  -7.1179863536691d+01,-8.2077650871038d+01,-1.8865752225205d+01,
     |   8.1798912633368d+01, 1.2669249930939d+02, 6.1102655015132d+01,
     |  -6.1102655015132d+01,-1.2669249930939d+02,-8.1798912633368d+01,
     |   1.8865752225205d+01, 8.2077650871038d+01, 7.1179863536691d+01,
     |   2.1370442146754d+01,-1.6875760344642d+01,-2.5568492863791d+01,
     |  -1.6894886271314d+01,-6.9953437090668d+00,-1.8900633401445d+00,
     |  -3.1908056044015d-01,-3.0041718598720d-02,-1.2589888120050d-03,
     |  -1.4603906413811d-05,-1.3520180724873d-08,-3.0702257939163d-15/
      data (lpmn(lat,17,19), lat = 1,36)/
     |   4.6274821546759d-17, 6.1665568326074d-10, 1.1300551968894d-06,
     |   1.4024302816636d-04, 4.4766240727541d-03, 6.1358162433369d-02,
     |   4.6253847799886d-01, 2.1900129047892d+00, 6.9865042425262d+00,
     |   1.5365657619696d+01, 2.2312043848644d+01, 1.5965135980303d+01,
     |  -1.2914524489658d+01,-5.4049211517564d+01,-7.4057028046479d+01,
     |  -4.2500975668051d+01, 3.1165341051015d+01, 9.3877128863367d+01,
     |   9.3877128863368d+01, 3.1165341051015d+01,-4.2500975668051d+01,
     |  -7.4057028046479d+01,-5.4049211517564d+01,-1.2914524489658d+01,
     |   1.5965135980303d+01, 2.2312043848644d+01, 1.5365657619696d+01,
     |   6.9865042425262d+00, 2.1900129047892d+00, 4.6253847799886d-01,
     |   6.1358162433369d-02, 4.4766240727541d-03, 1.4024302816636d-04,
     |   1.1300551968894d-06, 6.1665568326074d-10, 4.6274821546759d-17/
      data (lpmn(lat,18,19), lat = 1,36)/
     |   5.4142590893225d-19, 2.1812991548485d-11, 6.7682649749671d-08,
     |   1.2051747930886d-05, 5.1198446289857d-04, 8.9844810256586d-03,
     |   8.5116825737757d-02, 5.0465335721519d-01, 2.0406928724542d+00,
     |   5.9033679044486d+00, 1.2414782144333d+01, 1.8457936254906d+01,
     |   1.6560321726841d+01,-3.6865131090600d-01,-2.9757303656031d+01,
     |  -5.4978367144346d+01,-5.4996109172679d+01,-2.3179922817794d+01,
     |   2.3179922817794d+01, 5.4996109172679d+01, 5.4978367144346d+01,
     |   2.9757303656031d+01, 3.6865131090600d-01,-1.6560321726841d+01,
     |  -1.8457936254906d+01,-1.2414782144333d+01,-5.9033679044486d+00,
     |  -2.0406928724542d+00,-5.0465335721519d-01,-8.5116825737758d-02,
     |  -8.9844810256586d-03,-5.1198446289857d-04,-1.2051747930886d-05,
     |  -6.7682649749674d-08,-2.1812991548485d-11,-5.4142590893225d-19/
      data (lpmn(lat,19,19), lat = 1,36)/
     |   4.2736807644450d-21, 5.2014130968155d-13, 2.7282434254714d-09,
     |   6.9517086248454d-07, 3.9145835451066d-05, 8.7424763781747d-04,
     |   1.0315303858078d-02, 7.5506336641543d-02, 3.7789327361630d-01,
     |   1.3743551617458d+00, 3.7694704664816d+00, 7.9383211612125d+00,
     |   1.2792040089205d+01, 1.5105824807896d+01, 1.0868439005396d+01,
     |  -1.2622034070147d+00,-1.7139091981110d+01,-2.8476552237730d+01,
     |  -2.8476552237730d+01,-1.7139091981110d+01,-1.2622034070147d+00,
     |   1.0868439005396d+01, 1.5105824807896d+01, 1.2792040089205d+01,
     |   7.9383211612126d+00, 3.7694704664816d+00, 1.3743551617458d+00,
     |   3.7789327361630d-01, 7.5506336641543d-02, 1.0315303858078d-02,
     |   8.7424763781747d-04, 3.9145835451066d-05, 6.9517086248456d-07,
     |   2.7282434254715d-09, 5.2014130968155d-13, 4.2736807644450d-21/
      data (lpmn(lat, 0,20), lat = 1,36)/
     |  -1.5400383414804d+03, 2.5749713045904d+02, 6.2376511456273d+02,
     |  -4.1342973716562d+02,-3.0719861529310d+02, 4.5720063796463d+02,
     |   7.3812162933364d+01,-4.2862132272878d+02, 1.1145212784349d+02,
     |   3.4311465782503d+02,-2.4668561402813d+02,-2.1686353380748d+02,
     |   3.2516496612014d+02, 6.8867112828003d+01,-3.4302261423373d+02,
     |   8.0155157272089d+01, 3.0191994807515d+02,-2.0975331920993d+02,
     |  -2.0975331920993d+02, 3.0191994807515d+02, 8.0155157272092d+01,
     |  -3.4302261423373d+02, 6.8867112828002d+01, 3.2516496612014d+02,
     |  -2.1686353380748d+02,-2.4668561402813d+02, 3.4311465782503d+02,
     |   1.1145212784349d+02,-4.2862132272878d+02, 7.3812162933361d+01,
     |   4.5720063796463d+02,-3.0719861529310d+02,-4.1342973716562d+02,
     |   6.2376511456273d+02, 2.5749713045904d+02,-1.5400383414804d+03/
      data (lpmn(lat, 1,20), lat = 1,36)/
     |   1.9310459754661d+02,-7.3207200452272d+02, 4.0439745138195d+02,
     |   4.0746233987112d+02,-4.5702295598095d+02,-1.6107259865624d+02,
     |   4.5060757021299d+02,-3.8073469423798d+01,-3.8741563640909d+02,
     |   1.9272949295841d+02, 2.7850161793974d+02,-2.9595582168900d+02,
     |  -1.3985385990412d+02, 3.4167275766884d+02,-9.4424378904614d+00,
     |  -3.2843798012690d+02, 1.4928548710916d+02, 2.6079834683047d+02,
     |  -2.6079834683047d+02,-1.4928548710916d+02, 3.2843798012690d+02,
     |   9.4424378904620d+00,-3.4167275766884d+02, 1.3985385990412d+02,
     |   2.9595582168901d+02,-2.7850161793974d+02,-1.9272949295841d+02,
     |   3.8741563640909d+02, 3.8073469423799d+01,-4.5060757021299d+02,
     |   1.6107259865624d+02, 4.5702295598095d+02,-4.0746233987112d+02,
     |  -4.0439745138196d+02, 7.3207200452272d+02,-1.9310459754660d+02/
      data (lpmn(lat, 2,20), lat = 1,36)/
     |   7.1039514318960d+02,-3.9268017098193d+02,-3.4836471522995d+02,
     |   4.8693083496428d+02, 1.8532506024595d+02,-4.6706467951399d+02,
     |  -4.0823291663525d+00, 4.1384438029147d+02,-1.5009532251612d+02,
     |  -3.2086062867631d+02, 2.6420031650742d+02, 1.9621296852002d+02,
     |  -3.2905352640664d+02,-5.4533129862502d+01, 3.3995308226778d+02,
     |  -8.6613155884379d+01,-2.9780053321072d+02, 2.0935417443141d+02,
     |   2.0935417443141d+02,-2.9780053321072d+02,-8.6613155884382d+01,
     |   3.3995308226778d+02,-5.4533129862501d+01,-3.2905352640664d+02,
     |   1.9621296852002d+02, 2.6420031650742d+02,-3.2086062867631d+02,
     |  -1.5009532251612d+02, 4.1384438029147d+02,-4.0823291663491d+00,
     |  -4.6706467951399d+02, 1.8532506024595d+02, 4.8693083496428d+02,
     |  -3.4836471522995d+02,-3.9268017098193d+02, 7.1039514318959d+02/
      data (lpmn(lat, 3,20), lat = 1,36)/
     |   2.7396587635290d+02, 1.2231839788748d+02,-4.4265872303839d+02,
     |  -6.1923049464828d+01, 4.7881849418280d+02,-1.8848885313568d+01,
     |  -4.2386272178080d+02, 1.3880906924415d+02, 3.4160821195619d+02,
     |  -2.4335411786234d+02,-2.3225405376310d+02, 3.1354908562325d+02,
     |   1.0395656802173d+02,-3.4001454466063d+02, 3.0081796749193d+01,
     |   3.1968202328675d+02,-1.5470437736354d+02,-2.5526690742324d+02,
     |   2.5526690742324d+02, 1.5470437736354d+02,-3.1968202328675d+02,
     |  -3.0081796749194d+01, 3.4001454466063d+02,-1.0395656802174d+02,
     |  -3.1354908562325d+02, 2.3225405376310d+02, 2.4335411786234d+02,
     |  -3.4160821195619d+02,-1.3880906924415d+02, 4.2386272178080d+02,
     |   1.8848885313568d+01,-4.7881849418280d+02, 6.1923049464825d+01,
     |   4.4265872303839d+02,-1.2231839788748d+02,-2.7396587635290d+02/
      data (lpmn(lat, 4,20), lat = 1,36)/
     |   5.6522744578506d+01, 2.1474103764719d+02,-1.2191993461735d+02,
     |  -3.6151514485087d+02, 1.4986963353406d+02, 3.9467024386619d+02,
     |  -1.8161692468819d+02,-3.3271837275746d+02, 2.4802381566435d+02,
     |   2.4179528229890d+02,-3.0535578541777d+02,-1.3170165174043d+02,
     |   3.3500483194253d+02, 1.2075720995264d+01,-3.2880849754033d+02,
     |   1.0528147175948d+02, 2.8523236818683d+02,-2.0804703229657d+02,
     |  -2.0804703229657d+02, 2.8523236818683d+02, 1.0528147175948d+02,
     |  -3.2880849754033d+02, 1.2075720995263d+01, 3.3500483194253d+02,
     |  -1.3170165174043d+02,-3.0535578541777d+02, 2.4179528229890d+02,
     |   2.4802381566435d+02,-3.3271837275746d+02,-1.8161692468819d+02,
     |   3.9467024386619d+02, 1.4986963353406d+02,-3.6151514485087d+02,
     |  -1.2191993461735d+02, 2.1474103764719d+02, 5.6522744578506d+01/
      data (lpmn(lat, 5,20), lat = 1,36)/
     |   7.9071395465627d+00, 1.2119171859160d+02, 9.5705026996878d+01,
     |  -2.4281379821620d+02,-2.2012218676317d+02, 2.8140750996275d+02,
     |   2.6278072107556d+02,-2.8715966600280d+02,-2.1207060490479d+02,
     |   3.1271295713715d+02, 1.2954090120552d+02,-3.3167559128789d+02,
     |  -3.2004679988318d+01, 3.2962506548579d+02,-6.9527486143125d+01,
     |  -3.0054468636864d+02, 1.6473347683893d+02, 2.4419879856230d+02,
     |  -2.4419879856230d+02,-1.6473347683893d+02, 3.0054468636864d+02,
     |   6.9527486143125d+01,-3.2962506548579d+02, 3.2004679988320d+01,
     |   3.3167559128789d+02,-1.2954090120552d+02,-3.1271295713715d+02,
     |   2.1207060490479d+02, 2.8715966600280d+02,-2.6278072107556d+02,
     |  -2.8140750996275d+02, 2.2012218676317d+02, 2.4281379821620d+02,
     |  -9.5705026996878d+01,-1.2119171859160d+02,-7.9071395465627d+00/
      data (lpmn(lat, 6,20), lat = 1,36)/
     |   8.2996250573118d-01, 4.4219171754733d+01, 1.2177171152768d+02,
     |  -2.6484522944553d+01,-2.7308938057966d+02,-6.3924073866131d+01,
     |   3.3397772510115d+02, 1.1515345297723d+02,-3.3204890780540d+02,
     |  -8.4558358048445d+01, 3.3236206871381d+02, 2.1248147344283d+01,
     |  -3.2582645886580d+02, 5.5341423098112d+01, 3.0404323807817d+02,
     |  -1.3382427892965d+02,-2.6363743568066d+02, 2.0549441647012d+02,
     |   2.0549441647012d+02,-2.6363743568066d+02,-1.3382427892966d+02,
     |   3.0404323807817d+02, 5.5341423098112d+01,-3.2582645886580d+02,
     |   2.1248147344280d+01, 3.3236206871381d+02,-8.4558358048445d+01,
     |  -3.3204890780541d+02, 1.1515345297723d+02, 3.3397772510115d+02,
     |  -6.3924073866131d+01,-2.7308938057966d+02,-2.6484522944554d+01,
     |   1.2177171152768d+02, 4.4219171754733d+01, 8.2996250573118d-01/
      data (lpmn(lat, 7,20), lat = 1,36)/
     |   6.9122811828562d-02, 1.2075764566768d+01, 7.3615522875657d+01,
     |   7.9419383392824d+01,-1.2293328354481d+02,-2.3695325843779d+02,
     |   7.3863437794669d+01, 3.2066200996866d+02,-2.0586743341665d+01,
     |  -3.2473139685726d+02, 3.0059664837740d+01, 3.1530434113947d+02,
     |  -7.0111932091556d+01,-2.9714290847452d+02, 1.2282090346615d+02,
     |   2.6809890951511d+02,-1.7765708913096d+02,-2.2759324113621d+02,
     |   2.2759324113621d+02, 1.7765708913096d+02,-2.6809890951511d+02,
     |  -1.2282090346615d+02, 2.9714290847452d+02, 7.0111932091554d+01,
     |  -3.1530434113947d+02,-3.0059664837740d+01, 3.2473139685726d+02,
     |   2.0586743341667d+01,-3.2066200996866d+02,-7.3863437794671d+01,
     |   2.3695325843779d+02, 1.2293328354481d+02,-7.9419383392824d+01,
     |  -7.3615522875658d+01,-1.2075764566768d+01,-6.9122811828562d-02/
      data (lpmn(lat, 8,20), lat = 1,36)/
     |   4.7295152901930d-03, 2.6312904732600d+00, 3.1369176084986d+01,
     |   8.1332234798866d+01, 1.6205430711229d+01,-1.7937375523208d+02,
     |  -1.6114170295561d+02, 1.7363513566298d+02, 2.6276936791290d+02,
     |  -1.2646122820524d+02,-2.8141694298398d+02, 1.1920076709445d+02,
     |   2.7510464295098d+02,-1.3743832509927d+02,-2.5762664397773d+02,
     |   1.6764465735063d+02, 2.3224254875106d+02,-2.0110397030690d+02,
     |  -2.0110397030690d+02, 2.3224254875106d+02, 1.6764465735064d+02,
     |  -2.5762664397773d+02,-1.3743832509927d+02, 2.7510464295098d+02,
     |   1.1920076709445d+02,-2.8141694298398d+02,-1.2646122820524d+02,
     |   2.6276936791290d+02, 1.7363513566298d+02,-1.6114170295561d+02,
     |  -1.7937375523208d+02, 1.6205430711229d+01, 8.1332234798866d+01,
     |   3.1369176084987d+01, 2.6312904732600d+00, 4.7295152901930d-03/
      data (lpmn(lat, 9,20), lat = 1,36)/
     |   2.7204668778406d-04, 4.7401039010240d-01, 1.0460271892538d+01,
     |   4.8736787487156d+01, 6.6488156763243d+01,-4.7797506502329d+01,
     |  -1.9460953650182d+02,-7.1466184491606d+01, 2.2954333572578d+02,
     |   1.8373489620809d+02,-1.9566821265574d+02,-2.2073797104043d+02,
     |   1.7854629870673d+02, 2.2646690180107d+02,-1.7948795419019d+02,
     |  -2.1895272093499d+02, 1.9066140225633d+02, 2.0547582112649d+02,
     |  -2.0547582112649d+02,-1.9066140225633d+02, 2.1895272093499d+02,
     |   1.7948795419019d+02,-2.2646690180107d+02,-1.7854629870673d+02,
     |   2.2073797104043d+02, 1.9566821265574d+02,-1.8373489620809d+02,
     |  -2.2954333572578d+02, 7.1466184491605d+01, 1.9460953650182d+02,
     |   4.7797506502329d+01,-6.6488156763242d+01,-4.8736787487156d+01,
     |  -1.0460271892538d+01,-4.7401039010240d-01,-2.7204668778406d-04/
      data (lpmn(lat,10,20), lat = 1,36)/
     |   1.3362391615786d-05, 7.2155543068911d-02, 2.8607694597713d+00,
     |   2.1735425292220d+01, 5.7075406597573d+01, 3.5873001394934d+01,
     |  -9.8381436011938d+01,-1.7706379263279d+02, 1.1843371004522d+01,
     |   2.4671648283304d+02, 1.0370936232726d+02,-2.3081954513683d+02,
     |  -1.5925670670832d+02, 2.1046843273613d+02, 1.8207536215351d+02,
     |  -1.9896411829520d+02,-1.9043268507762d+02, 1.9397513963915d+02,
     |   1.9397513963915d+02,-1.9043268507762d+02,-1.9896411829520d+02,
     |   1.8207536215351d+02, 2.1046843273613d+02,-1.5925670670832d+02,
     |  -2.3081954513683d+02, 1.0370936232726d+02, 2.4671648283304d+02,
     |   1.1843371004523d+01,-1.7706379263279d+02,-9.8381436011938d+01,
     |   3.5873001394934d+01, 5.7075406597573d+01, 2.1735425292220d+01,
     |   2.8607694597713d+00, 7.2155543068911d-02, 1.3362391615786d-05/
      data (lpmn(lat,11,20), lat = 1,36)/
     |   5.6634329583790d-07, 9.4117214777733d-03, 6.5829804079610d-01,
     |   7.7829225785473d+00, 3.2542724771275d+01, 5.4139692975545d+01,
     |  -8.1713564168721d-01,-1.2897812269064d+02,-1.3993463906209d+02,
     |   7.6678756835908d+01, 2.3668446495508d+02, 3.6524218490543d+01,
     |  -2.4026730774212d+02,-1.0899329936309d+02, 2.2093505592484d+02,
     |   1.5100620151765d+02,-1.9957086800152d+02,-1.7793918825500d+02,
     |   1.7793918825500d+02, 1.9957086800152d+02,-1.5100620151764d+02,
     |  -2.2093505592484d+02, 1.0899329936309d+02, 2.4026730774212d+02,
     |  -3.6524218490542d+01,-2.3668446495508d+02,-7.6678756835908d+01,
     |   1.3993463906209d+02, 1.2897812269064d+02, 8.1713564168753d-01,
     |  -5.4139692975545d+01,-3.2542724771274d+01,-7.7829225785474d+00,
     |  -6.5829804079612d-01,-9.4117214777733d-03,-5.6634329583790d-07/
      data (lpmn(lat,12,20), lat = 1,36)/
     |   2.0847142348993d-08, 1.0609948141189d-03, 1.2935501111261d-01,
     |   2.3167150480359d+00, 1.4320821095727d+01, 3.9509958644902d+01,
     |   4.1938316950949d+01,-3.4802897234013d+01,-1.3995564472159d+02,
     |  -9.6623083241995d+01, 1.1887160543289d+02, 2.1271908762069d+02,
     |  -1.0657173916809d+01,-2.3404886485543d+02,-7.7081882952486d+01,
     |   2.1600603502977d+02, 1.3840841871611d+02,-1.8280139519322d+02,
     |  -1.8280139519322d+02, 1.3840841871611d+02, 2.1600603502977d+02,
     |  -7.7081882952486d+01,-2.3404886485543d+02,-1.0657173916808d+01,
     |   2.1271908762069d+02, 1.1887160543289d+02,-9.6623083241995d+01,
     |  -1.3995564472159d+02,-3.4802897234013d+01, 4.1938316950949d+01,
     |   3.9509958644902d+01, 1.4320821095727d+01, 2.3167150480359d+00,
     |   1.2935501111261d-01, 1.0609948141189d-03, 2.0847142348993d-08/
      data (lpmn(lat,13,20), lat = 1,36)/
     |   6.6853123071587d-10, 1.0382938609057d-04, 2.1880904535238d-02,
     |   5.8358002600159d-01, 5.1316148237147d+00, 2.0732759799001d+01,
     |   4.1187543165950d+01, 2.4882814569054d+01,-6.0432766704846d+01,
     |  -1.3625963435474d+02,-5.7689196148052d+01, 1.3998726068480d+02,
     |   1.8634460689026d+02,-3.5677159079288d+01,-2.2045280114036d+02,
     |  -6.6782150778079d+01, 1.9857430431118d+02, 1.4521761140692d+02,
     |  -1.4521761140692d+02,-1.9857430431118d+02, 6.6782150778078d+01,
     |   2.2045280114036d+02, 3.5677159079288d+01,-1.8634460689026d+02,
     |  -1.3998726068480d+02, 5.7689196148052d+01, 1.3625963435474d+02,
     |   6.0432766704846d+01,-2.4882814569054d+01,-4.1187543165950d+01,
     |  -2.0732759799001d+01,-5.1316148237147d+00,-5.8358002600159d-01,
     |  -2.1880904535239d-02,-1.0382938609057d-04,-6.6853123071587d-10/
      data (lpmn(lat,14,20), lat = 1,36)/
     |   1.8672645757024d-11, 8.8262935195489d-06, 3.1955996961023d-03,
     |   1.2544976601228d-01, 1.5333174743002d+00, 8.5811235412464d+00,
     |   2.5439903826895d+01, 3.8184644452014d+01, 7.7734412234750d+00,
     |  -7.5628794557049d+01,-1.2458201238744d+02,-2.9730629093691d+01,
     |   1.4423884614732d+02, 1.6538462374179d+02,-3.8849660730061d+01,
     |  -2.0338611970691d+02,-7.8396504554952d+01, 1.6568139908706d+02,
     |   1.6568139908706d+02,-7.8396504554952d+01,-2.0338611970691d+02,
     |  -3.8849660730061d+01, 1.6538462374179d+02, 1.4423884614732d+02,
     |  -2.9730629093691d+01,-1.2458201238744d+02,-7.5628794557049d+01,
     |   7.7734412234750d+00, 3.8184644452014d+01, 2.5439903826895d+01,
     |   8.5811235412464d+00, 1.5333174743002d+00, 1.2544976601228d-01,
     |   3.1955996961024d-03, 8.8262935195489d-06, 1.8672645757024d-11/
      data (lpmn(lat,15,20), lat = 1,36)/
     |   4.5247876023010d-13, 6.4961369639943d-07, 4.0222782600832d-04,
     |   2.3048440485986d-02, 3.8565270916669d-01, 2.8987039609871d+00,
     |   1.1820279589691d+01, 2.7662157837959d+01, 3.2469853644552d+01,
     |  -5.6117917849954d+00,-8.0994713001761d+01,-1.1097500561773d+02,
     |  -1.5783011905085d+01, 1.3549728210607d+02, 1.5301566860999d+02,
     |  -2.0872129873631d+01,-1.8012509451478d+02,-1.0783322835916d+02,
     |   1.0783322835916d+02, 1.8012509451478d+02, 2.0872129873632d+01,
     |  -1.5301566860999d+02,-1.3549728210607d+02, 1.5783011905085d+01,
     |   1.1097500561773d+02, 8.0994713001761d+01, 5.6117917849956d+00,
     |  -3.2469853644552d+01,-2.7662157837959d+01,-1.1820279589691d+01,
     |  -2.8987039609871d+00,-3.8565270916669d-01,-2.3048440485987d-02,
     |  -4.0222782600833d-04,-6.4961369639943d-07,-4.5247876023009d-13/
      data (lpmn(lat,16,20), lat = 1,36)/
     |   9.4305079877311d-15, 4.1056207302782d-08, 4.3321983047401d-05,
     |   3.6010307319019d-03, 8.1609071209129d-02, 8.0801668470654d-01,
     |   4.3504013540814d+00, 1.4072064890052d+01, 2.7509905153886d+01,
     |   2.6386652816893d+01,-1.3052318857357d+01,-7.8276258835499d+01,
     |  -9.9241431532649d+01,-1.6319722123062d+01, 1.1501003886430d+02,
     |   1.4665503658106d+02, 1.6972805663320d+01,-1.3969712806906d+02,
     |  -1.3969712806906d+02, 1.6972805663319d+01, 1.4665503658106d+02,
     |   1.1501003886430d+02,-1.6319722123062d+01,-9.9241431532650d+01,
     |  -7.8276258835499d+01,-1.3052318857357d+01, 2.6386652816893d+01,
     |   2.7509905153886d+01, 1.4072064890052d+01, 4.3504013540815d+00,
     |   8.0801668470654d-01, 8.1609071209129d-02, 3.6010307319020d-03,
     |   4.3321983047403d-05, 4.1056207302782d-08, 9.4305079877311d-15/
      data (lpmn(lat,17,20), lat = 1,36)/
     |   1.6640654143969d-16, 2.1940359691600d-09, 3.9344205745178d-06,
     |   4.7214528364316d-04, 1.4379538165490d-02, 1.8508810476421d-01,
     |   1.2842399838113d+00, 5.4431228761169d+00, 1.4871512205665d+01,
     |   2.5637757924894d+01, 2.1799061031265d+01,-1.3736148632559d+01,
     |  -6.8815819145129d+01,-8.9844717547131d+01,-2.9562137154782d+01,
     |   8.0582033786115d+01, 1.3560673450373d+02, 6.6930366237466d+01,
     |  -6.6930366237466d+01,-1.3560673450373d+02,-8.0582033786116d+01,
     |   2.9562137154782d+01, 8.9844717547131d+01, 6.8815819145129d+01,
     |   1.3736148632560d+01,-2.1799061031265d+01,-2.5637757924894d+01,
     |  -1.4871512205666d+01,-5.4431228761169d+00,-1.2842399838114d+00,
     |  -1.8508810476421d-01,-1.4379538165490d-02,-4.7214528364317d-04,
     |  -3.9344205745180d-06,-2.1940359691600d-09,-1.6640654143969d-16/
      data (lpmn(lat,18,20), lat = 1,36)/
     |   2.4167841818943d-18, 9.6402654310123d-11, 2.9313474588052d-07,
     |   5.0595368360505d-05, 2.0585335403219d-03, 3.4121857707560d-02,
     |   3.0030397256991d-01, 1.6190676997799d+00, 5.7783162436045d+00,
     |   1.4069306356999d+01, 2.2690290640687d+01, 1.9489090562442d+01,
     |  -7.9557415528547d+00,-5.2562800441076d+01,-7.8847360925697d+01,
     |  -4.9366361137253d+01, 2.9829555389714d+01, 9.9654617379460d+01,
     |   9.9654617379460d+01, 2.9829555389714d+01,-4.9366361137253d+01,
     |  -7.8847360925697d+01,-5.2562800441076d+01,-7.9557415528546d+00,
     |   1.9489090562442d+01, 2.2690290640687d+01, 1.4069306356999d+01,
     |   5.7783162436045d+00, 1.6190676997799d+00, 3.0030397256992d-01,
     |   3.4121857707560d-02, 2.0585335403219d-03, 5.0595368360506d-05,
     |   2.9313474588053d-07, 9.6402654310123d-11, 2.4167841818943d-18/
      data (lpmn(lat,19,20), lat = 1,36)/
     |   2.7333088409177d-20, 3.2956889835102d-12, 1.6962069505802d-08,
     |   4.1982385132504d-06, 2.2713305740117d-04, 4.8141606554245d-03,
     |   5.3146338194118d-02, 3.5774345228552d-01, 1.6103363508546d+00,
     |   5.1082880231027d+00, 1.1656765504016d+01, 1.8743825060433d+01,
     |   1.8629384297120d+01, 2.5325589746816d+00,-2.8638537254767d+01,
     |  -5.7397385088922d+01,-5.9288474171364d+01,-2.5327000566405d+01,
     |   2.5327000566405d+01, 5.9288474171364d+01, 5.7397385088922d+01,
     |   2.8638537254767d+01,-2.5325589746816d+00,-1.8629384297120d+01,
     |  -1.8743825060433d+01,-1.1656765504016d+01,-5.1082880231027d+00,
     |  -1.6103363508546d+00,-3.5774345228552d-01,-5.3146338194118d-02,
     |  -4.8141606554245d-03,-2.2713305740117d-04,-4.1982385132505d-06,
     |  -1.6962069505802d-08,-3.2956889835102d-12,-2.7333088409177d-20/
      data (lpmn(lat,20,20), lat = 1,36)/
     |   2.0912143032745d-22, 7.6164669899098d-14, 6.6250765837980d-10,
     |   2.3456450125115d-07, 1.6812712167013d-05, 4.5317804986920d-04,
     |   6.2242493892249d-03, 5.1646290353831d-02, 2.8705827769828d-01,
     |   1.1404974086002d+00, 3.3712279117262d+00, 7.5665190015706d+00,
     |   1.2882084192583d+01, 1.6002157193138d+01, 1.2281998689888d+01,
     |  -3.3793866414175d-01,-1.7641022051873d+01,-3.0258844256749d+01,
     |  -3.0258844256749d+01,-1.7641022051873d+01,-3.3793866414180d-01,
     |   1.2281998689888d+01, 1.6002157193138d+01, 1.2882084192583d+01,
     |   7.5665190015706d+00, 3.3712279117262d+00, 1.1404974086002d+00,
     |   2.8705827769828d-01, 5.1646290353831d-02, 6.2242493892250d-03,
     |   4.5317804986920d-04, 1.6812712167013d-05, 2.3456450125116d-07,
     |   6.6250765837983d-10, 7.6164669899098d-14, 2.0912143032744d-22/
      data (lpmn(lat, 0,21), lat = 1,36)/
     |  -1.6963813279832d+03, 4.0970606311207d+02, 5.8464432414245d+02,
     |  -5.8252047637709d+02,-1.2426930122537d+02, 5.3953537468229d+02,
     |  -1.9825303837403d+02,-3.5742221089191d+02, 3.8181585765760d+02,
     |   1.0422945057189d+02,-4.1299738803186d+02, 1.4406767693070d+02,
     |   3.0593098936058d+02,-3.1831156204989d+02,-1.0627205421492d+02,
     |   3.7293937950164d+02,-1.1871565668753d+02,-2.9743037116451d+02,
     |   2.9743037116451d+02, 1.1871565668753d+02,-3.7293937950164d+02,
     |   1.0627205421492d+02, 3.1831156204989d+02,-3.0593098936058d+02,
     |  -1.4406767693071d+02, 4.1299738803186d+02,-1.0422945057189d+02,
     |  -3.8181585765760d+02, 3.5742221089191d+02, 1.9825303837404d+02,
     |  -5.3953537468229d+02, 1.2426930122537d+02, 5.8252047637709d+02,
     |  -5.8464432414244d+02,-4.0970606311207d+02, 1.6963813279832d+03/
      data (lpmn(lat, 1,21), lat = 1,36)/
     |   1.2361627612352d+02,-7.5880190103158d+02, 5.6785047030127d+02,
     |   2.8486630925735d+02,-5.8167184260773d+02, 7.6377378662678d+01,
     |   4.5182439222655d+02,-3.1796524792988d+02,-2.2446166131587d+02,
     |   4.1722168348201d+02,-3.2493950001383d+01,-3.7153973011942d+02,
     |   2.4718917174415d+02, 2.1032362810733d+02,-3.6225420440681d+02,
     |   9.5619417761902d+00, 3.4966157050404d+02,-2.1791532350311d+02,
     |  -2.1791532350311d+02, 3.4966157050404d+02, 9.5619417761931d+00,
     |  -3.6225420440681d+02, 2.1032362810733d+02, 2.4718917174415d+02,
     |  -3.7153973011942d+02,-3.2493950001383d+01, 4.1722168348201d+02,
     |  -2.2446166131587d+02,-3.1796524792989d+02, 4.5182439222654d+02,
     |   7.6377378662678d+01,-5.8167184260773d+02, 2.8486630925734d+02,
     |   5.6785047030128d+02,-7.5880190103158d+02, 1.2361627612351d+02/
      data (lpmn(lat, 2,21), lat = 1,36)/
     |   7.7518177484749d+02,-5.0473975776572d+02,-2.7348594709410d+02,
     |   6.0594003236536d+02,-7.8799813532375d+00,-5.0548950393096d+02,
     |   2.5736141817764d+02, 3.1186975871499d+02,-3.9790230835443d+02,
     |  -6.7568728188897d+01, 4.0589981393589d+02,-1.6449312818545d+02,
     |  -2.9132145620880d+02, 3.2382891091326d+02, 9.4914364399196d+01,
     |  -3.7015794738124d+02, 1.2218978300431d+02, 2.9460915460108d+02,
     |  -2.9460915460108d+02,-1.2218978300431d+02, 3.7015794738124d+02,
     |  -9.4914364399195d+01,-3.2382891091326d+02, 2.9132145620880d+02,
     |   1.6449312818546d+02,-4.0589981393589d+02, 6.7568728188896d+01,
     |   3.9790230835443d+02,-3.1186975871499d+02,-2.5736141817765d+02,
     |   5.0548950393096d+02, 7.8799813532375d+00,-6.0594003236536d+02,
     |   2.7348594709409d+02, 5.0473975776572d+02,-7.7518177484749d+02/
      data (lpmn(lat, 3,21), lat = 1,36)/
     |   3.1919937750117d+02, 8.4210996949200d+01,-5.1489635473417d+02,
     |   8.2358676105730d+01, 5.1081898463832d+02,-2.4268584893993d+02,
     |  -3.5362933956777d+02, 3.7820305202667d+02, 1.3747668105681d+02,
     |  -4.1700837030144d+02, 8.9059438843669d+01, 3.4472639528286d+02,
     |  -2.7080381832333d+02,-1.8214386760392d+02, 3.6243485097363d+02,
     |  -2.4624411522063d+01,-3.4201170311197d+02, 2.1744667881223d+02,
     |   2.1744667881223d+02,-3.4201170311197d+02,-2.4624411522065d+01,
     |   3.6243485097363d+02,-1.8214386760392d+02,-2.7080381832333d+02,
     |   3.4472639528286d+02, 8.9059438843669d+01,-4.1700837030144d+02,
     |   1.3747668105681d+02, 3.7820305202667d+02,-3.5362933956776d+02,
     |  -2.4268584893993d+02, 5.1081898463832d+02, 8.2358676105734d+01,
     |  -5.1489635473417d+02, 8.4210996949200d+01, 3.1919937750117d+02/
      data (lpmn(lat, 4,21), lat = 1,36)/
     |   6.9546208580280d+01, 2.3585494218749d+02,-2.0514799208710d+02,
     |  -3.5810051065096d+02, 3.1362089439160d+02, 3.2268796276681d+02,
     |  -3.8320767587948d+02,-1.5801933878260d+02, 4.1827447341667d+02,
     |  -4.0239715244084d+01,-3.7265131894484d+02, 2.2022119343425d+02,
     |   2.4438279605591d+02,-3.3691106305586d+02,-6.1018676826666d+01,
     |   3.6085135109890d+02,-1.3225777554925d+02,-2.8613775032167d+02,
     |   2.8613775032167d+02, 1.3225777554925d+02,-3.6085135109890d+02,
     |   6.1018676826666d+01, 3.3691106305586d+02,-2.4438279605591d+02,
     |  -2.2022119343425d+02, 3.7265131894484d+02, 4.0239715244085d+01,
     |  -4.1827447341667d+02, 1.5801933878260d+02, 3.8320767587948d+02,
     |  -3.2268796276681d+02,-3.1362089439160d+02, 3.5810051065095d+02,
     |   2.0514799208710d+02,-2.3585494218749d+02,-6.9546208580280d+01/
      data (lpmn(lat, 5,21), lat = 1,36)/
     |   1.0254107079122d+01, 1.4717072840408d+02, 7.1531450866801d+01,
     |  -3.2381030916176d+02,-1.3691604824628d+02, 4.1124393262317d+02,
     |   9.9574637776016d+01,-4.1778860262196d+02, 3.7952351298232d+01,
     |   3.7946749285849d+02,-1.9000393507136d+02,-2.7857123351436d+02,
     |   3.0806606912123d+02, 1.2431408633094d+02,-3.5862924702762d+02,
     |   5.3720285538838d+01, 3.2619915080787d+02,-2.1629895074819d+02,
     |  -2.1629895074819d+02, 3.2619915080787d+02, 5.3720285538840d+01,
     |  -3.5862924702762d+02, 1.2431408633094d+02, 3.0806606912123d+02,
     |  -2.7857123351436d+02,-1.9000393507136d+02, 3.7946749285849d+02,
     |   3.7952351298234d+01,-4.1778860262197d+02, 9.9574637776013d+01,
     |   4.1124393262317d+02,-1.3691604824628d+02,-3.2381030916176d+02,
     |   7.1531450866800d+01, 1.4717072840408d+02, 1.0254107079122d+01/
      data (lpmn(lat, 6,21), lat = 1,36)/
     |   1.1345017803283d+00, 5.7693607365750d+01, 1.3594002285776d+02,
     |  -8.8954655358796d+01,-3.1243602532549d+02, 7.5927189739242d+01,
     |   3.8913747352400d+02,-1.0300975321706d+02,-3.6091688943697d+02,
     |   1.9639859952251d+02, 2.8226207132015d+02,-2.9079643045270d+02,
     |  -1.5831767676119d+02, 3.4680988106792d+02, 5.7778377237062d+00,
     |  -3.4222308381538d+02, 1.4780516785644d+02, 2.7199694599170d+02,
     |  -2.7199694599170d+02,-1.4780516785644d+02, 3.4222308381538d+02,
     |  -5.7778377237056d+00,-3.4680988106792d+02, 1.5831767676119d+02,
     |   2.9079643045270d+02,-2.8226207132015d+02,-1.9639859952251d+02,
     |   3.6091688943697d+02, 1.0300975321706d+02,-3.8913747352400d+02,
     |  -7.5927189739242d+01, 3.1243602532549d+02, 8.8954655358797d+01,
     |  -1.3594002285776d+02,-5.7693607365750d+01,-1.1345017803283d+00/
      data (lpmn(lat, 7,21), lat = 1,36)/
     |   9.9694179087818d-02, 1.6797910386679d+01, 9.2970529992826d+01,
     |   6.5199922227717d+01,-1.9956720022013d+02,-2.1325511935683d+02,
     |   2.3128904105185d+02, 2.8311632696533d+02,-2.4700288091260d+02,
     |  -2.4499558113501d+02, 2.9564862947885d+02, 1.5653405981458d+02,
     |  -3.3662541544260d+02,-3.6821661159755d+01, 3.4266035940852d+02,
     |  -9.4330359555724d+01,-3.0128438421529d+02, 2.1403629126822d+02,
     |   2.1403629126822d+02,-3.0128438421529d+02,-9.4330359555727d+01,
     |   3.4266035940852d+02,-3.6821661159755d+01,-3.3662541544260d+02,
     |   1.5653405981458d+02, 2.9564862947885d+02,-2.4499558113501d+02,
     |  -2.4700288091260d+02, 2.8311632696533d+02, 2.3128904105185d+02,
     |  -2.1325511935683d+02,-1.9956720022013d+02, 6.5199922227717d+01,
     |   9.2970529992827d+01, 1.6797910386679d+01, 9.9694179087818d-02/
      data (lpmn(lat, 8,21), lat = 1,36)/
     |   7.2089164658395d-03, 3.8938114187377d+00, 4.3226036284722d+01,
     |   9.3880802411711d+01,-2.8914434953013d+01,-2.4101886967217d+02,
     |  -7.4575046949296d+01, 3.0796950056593d+02, 1.3837421362685d+02,
     |  -3.1816463093949d+02,-1.0769277690363d+02, 3.3303858575137d+02,
     |   3.1308712652192d+01,-3.3531343368434d+02, 6.6585772981261d+01,
     |   3.0999758609629d+02,-1.6680402314176d+02,-2.5216917164900d+02,
     |   2.5216917164900d+02, 1.6680402314176d+02,-3.0999758609629d+02,
     |  -6.6585772981262d+01, 3.3531343368434d+02,-3.1308712652194d+01,
     |  -3.3303858575137d+02, 1.0769277690363d+02, 3.1816463093949d+02,
     |  -1.3837421362685d+02,-3.0796950056593d+02, 7.4575046949294d+01,
     |   2.4101886967217d+02, 2.8914434953013d+01,-9.3880802411711d+01,
     |  -4.3226036284722d+01,-3.8938114187377d+00,-7.2089164658395d-03/
      data (lpmn(lat, 9,21), lat = 1,36)/
     |   4.3919062937412d-04, 7.4632463871612d-01, 1.5557059648782d+01,
     |   6.4567311673881d+01, 6.0656606673484d+01,-1.1336014177547d+02,
     |  -2.1808653246080d+02, 6.0383411947828d+01, 3.1038079942050d+02,
     |  -4.3511739197630d+00,-3.2366126188243d+02, 1.9419114772018d+01,
     |   3.2096916189455d+02,-7.2649539008235d+01,-3.0328330557782d+02,
     |   1.4154136489337d+02, 2.6610494456681d+02,-2.0996417663502d+02,
     |  -2.0996417663502d+02, 2.6610494456681d+02, 1.4154136489338d+02,
     |  -3.0328330557782d+02,-7.2649539008236d+01, 3.2096916189455d+02,
     |   1.9419114772021d+01,-3.2366126188243d+02,-4.3511739197636d+00,
     |   3.1038079942050d+02, 6.0383411947829d+01,-2.1808653246080d+02,
     |  -1.1336014177547d+02, 6.0656606673484d+01, 6.4567311673882d+01,
     |   1.5557059648782d+01, 7.4632463871612d-01, 4.3919062937412d-04/
      data (lpmn(lat,10,21), lat = 1,36)/
     |   2.2912400708210d-05, 1.2107005286147d-01, 4.5764526396335d+00,
     |   3.1853197393297d+01, 6.9558416819975d+01, 6.6702147392442d+00,
     |  -1.6684811688958d+02,-1.5147649643041d+02, 1.6291194670040d+02,
     |   2.5979503099467d+02,-1.1802263893601d+02,-2.8395072784074d+02,
     |   1.1724243362465d+02, 2.7953354594620d+02,-1.4553168895530d+02,
     |  -2.5931126995650d+02, 1.8606200226495d+02, 2.2666393759407d+02,
     |  -2.2666393759407d+02,-1.8606200226495d+02, 2.5931126995650d+02,
     |   1.4553168895530d+02,-2.7953354594619d+02,-1.1724243362465d+02,
     |   2.8395072784074d+02, 1.1802263893601d+02,-2.5979503099467d+02,
     |  -1.6291194670040d+02, 1.5147649643041d+02, 1.6684811688958d+02,
     |  -6.6702147392441d+00,-6.9558416819975d+01,-3.1853197393297d+01,
     |  -4.5764526396336d+00,-1.2107005286147d-01,-2.2912400708210d-05/
      data (lpmn(lat,11,21), lat = 1,36)/
     |   1.0351037044611d-06, 1.6875766594461d-02, 1.1327917008222d+00,
     |   1.2470343498820d+01, 4.5941697140236d+01, 5.5603919019751d+01,
     |  -5.0546067394712d+01,-1.8293279596697d+02,-6.7175366315999d+01,
     |   2.2193079701662d+02, 1.8337463401251d+02,-1.9186210761120d+02,
     |  -2.2336504889315d+02, 1.7977373862072d+02, 2.2930952312414d+02,
     |  -1.8681174093918d+02,-2.1967036523432d+02, 2.0306926975235d+02,
     |   2.0306926975235d+02,-2.1967036523432d+02,-1.8681174093919d+02,
     |   2.2930952312414d+02, 1.7977373862072d+02,-2.2336504889315d+02,
     |  -1.9186210761120d+02, 1.8337463401251d+02, 2.2193079701662d+02,
     |  -6.7175366315999d+01,-1.8293279596697d+02,-5.0546067394712d+01,
     |   5.5603919019751d+01, 4.5941697140236d+01, 1.2470343498820d+01,
     |   1.1327917008222d+00, 1.6875766594461d-02, 1.0351037044611d-06/
      data (lpmn(lat,12,21), lat = 1,36)/
     |   4.0795626762529d-08, 2.0410203183615d-03, 2.3998639507719d-01,
     |   4.0454135153238d+00, 2.2664307480481d+01, 5.2129457720547d+01,
     |   2.7639342321560d+01,-9.6689030863048d+01,-1.6753861400833d+02,
     |   1.2555593030428d+01, 2.4110418080018d+02, 1.0519364584762d+02,
     |  -2.2832931893767d+02,-1.6295114174087d+02, 2.1048255052678d+02,
     |   1.8664939270617d+02,-2.0089381039245d+02,-1.9556301163848d+02,
     |   1.9556301163848d+02, 2.0089381039245d+02,-1.8664939270617d+02,
     |  -2.1048255052678d+02, 1.6295114174087d+02, 2.2832931893767d+02,
     |  -1.0519364584762d+02,-2.4110418080018d+02,-1.2555593030429d+01,
     |   1.6753861400833d+02, 9.6689030863048d+01,-2.7639342321560d+01,
     |  -5.2129457720547d+01,-2.2664307480481d+01,-4.0454135153238d+00,
     |  -2.3998639507720d-01,-2.0410203183615d-03,-4.0795626762529d-08/
      data (lpmn(lat,13,21), lat = 1,36)/
     |   1.4087418489704d-09, 2.1543042909777d-04, 4.3952745666508d-02,
     |   1.1118963948085d+00, 9.0130638594046d+00, 3.1936260885803d+01,
     |   4.8475264859328d+01,-5.6860270488039d+00,-1.2456310647274d+02,
     |  -1.3335877704287d+02, 7.4001369420675d+01, 2.3267621957352d+02,
     |   4.1543133056365d+01,-2.3726364771256d+02,-1.1712123491028d+02,
     |   2.1682354717507d+02, 1.6189105031079d+02,-1.9191256973720d+02,
     |  -1.9191256973720d+02, 1.6189105031079d+02, 2.1682354717507d+02,
     |  -1.1712123491028d+02,-2.3726364771256d+02, 4.1543133056366d+01,
     |   2.3267621957352d+02, 7.4001369420675d+01,-1.3335877704287d+02,
     |  -1.2456310647274d+02,-5.6860270488044d+00, 4.8475264859328d+01,
     |   3.1936260885803d+01, 9.0130638594046d+00, 1.1118963948086d+00,
     |   4.3952745666509d-02, 2.1543042909777d-04, 1.4087418489704d-09/
      data (lpmn(lat,14,21), lat = 1,36)/
     |   4.2685081497630d-11, 1.9893558808758d-05, 6.9945107731799d-03,
     |   2.6197505691622d-01, 2.9857545406569d+00, 1.5050413093135d+01,
     |   3.7528381233861d+01, 3.6906784523497d+01,-3.6062656533226d+01,
     |  -1.3421130201799d+02,-9.4090800844295d+01, 1.1236688463068d+02,
     |   2.1108440342554d+02, 5.5748677264894d-01,-2.2982742694988d+02,
     |  -9.3628514826953d+01, 2.0478117876595d+02, 1.5910184760594d+02,
     |  -1.5910184760594d+02,-2.0478117876595d+02, 9.3628514826952d+01,
     |   2.2982742694988d+02,-5.5748677264858d-01,-2.1108440342554d+02,
     |  -1.1236688463068d+02, 9.4090800844295d+01, 1.3421130201799d+02,
     |   3.6062656533226d+01,-3.6906784523496d+01,-3.7528381233861d+01,
     |  -1.5050413093135d+01,-2.9857545406569d+00,-2.6197505691623d-01,
     |  -6.9945107731801d-03,-1.9893558808758d-05,-4.2685081497630d-11/
      data (lpmn(lat,15,21), lat = 1,36)/
     |   1.1332307263378d-12, 1.6059508287207d-06, 9.6809746305209d-04,
     |   5.3171053082954d-02, 8.3653361443323d-01, 5.7583801216682d+00,
     |   2.0599285978036d+01, 3.8403840866575d+01, 2.1666104915325d+01,
     |  -5.8092603802536d+01,-1.3052118325363d+02,-6.0562961023617d+01,
     |   1.2907732792181d+02, 1.8829339837759d+02,-1.5346998951195d+01,
     |  -2.1365252290957d+02,-9.4921975625001d+01, 1.7442594920005d+02,
     |   1.7442594920005d+02,-9.4921975625001d+01,-2.1365252290957d+02,
     |  -1.5346998951195d+01, 1.8829339837759d+02, 1.2907732792181d+02,
     |  -6.0562961023616d+01,-1.3052118325363d+02,-5.8092603802537d+01,
     |   2.1666104915325d+01, 3.8403840866575d+01, 2.0599285978037d+01,
     |   5.7583801216682d+00, 8.3653361443323d-01, 5.3171053082955d-02,
     |   9.6809746305212d-04, 1.6059508287207d-06, 1.1332307263378d-12/
      data (lpmn(lat,16,21), lat = 1,36)/
     |   2.6232897275370d-14, 1.1284102408211d-07, 1.1616813378483d-04,
     |   9.2899860550997d-03, 1.9922917797275d-01, 1.8274394944779d+00,
     |   8.8397701735722d+00, 2.4347868453068d+01, 3.5390408804983d+01,
     |   7.3384085362571d+00,-6.9840277164282d+01,-1.2000280984320d+02,
     |  -3.9324766510608d+01, 1.2787587754911d+02, 1.7114542569336d+02,
     |  -6.3806208969302d+00,-1.8922284533093d+02,-1.1782838087425d+02,
     |   1.1782838087425d+02, 1.8922284533093d+02, 6.3806208969312d+00,
     |  -1.7114542569336d+02,-1.2787587754911d+02, 3.9324766510608d+01,
     |   1.2000280984320d+02, 6.9840277164282d+01,-7.3384085362570d+00,
     |  -3.5390408804983d+01,-2.4347868453068d+01,-8.8397701735722d+00,
     |  -1.8274394944779d+00,-1.9922917797275d-01,-9.2899860550999d-03,
     |  -1.1616813378484d-04,-1.1284102408211d-07,-2.6232897275370d-14/
      data (lpmn(lat,17,21), lat = 1,36)/
     |   5.2453141959665d-16, 6.8388653124577d-09, 1.1986561403036d-05,
     |   1.3881769503619d-03, 4.0210905319585d-02, 4.8359620240120d-01,
     |   3.0618880861919d+00, 1.1428153373571d+01, 2.5746035349794d+01,
     |   3.0467934459972d+01,-2.5588864701265d+00,-7.1802550408246d+01,
     |  -1.0798409831394d+02,-3.2976970988125d+01, 1.1125152089185d+02,
     |   1.5961616693029d+02, 2.5744692051250d+01,-1.4746067390311d+02,
     |  -1.4746067390311d+02, 2.5744692051250d+01, 1.5961616693029d+02,
     |   1.1125152089185d+02,-3.2976970988125d+01,-1.0798409831394d+02,
     |  -7.1802550408247d+01,-2.5588864701265d+00, 3.0467934459972d+01,
     |   2.5746035349794d+01, 1.1428153373571d+01, 3.0618880861920d+00,
     |   4.8359620240120d-01, 4.0210905319585d-02, 1.3881769503620d-03,
     |   1.1986561403036d-05, 6.8388653124577d-09, 5.2453141959664d-16/
      data (lpmn(lat,18,21), lat = 1,36)/
     |   8.9122493041143d-18, 3.5179776856374d-10, 1.0471756034008d-06,
     |   1.7488587355502d-04, 6.7956685704066d-03, 1.0594454734523d-01,
     |   8.6028699658868d-01, 4.1689280863459d+00, 1.2843488476299d+01,
     |   2.4994688685990d+01, 2.5742122846820d+01,-6.0998843284160d+00,
     |  -6.5182954462299d+01,-9.6586035094290d+01,-4.0650329178808d+01,
     |   7.8496718710837d+01, 1.4442656293173d+02, 7.2965438430366d+01,
     |  -7.2965438430366d+01,-1.4442656293173d+02,-7.8496718710837d+01,
     |   4.0650329178808d+01, 9.6586035094290d+01, 6.5182954462299d+01,
     |   6.0998843284163d+00,-2.5742122846820d+01,-2.4994688685990d+01,
     |  -1.2843488476299d+01,-4.1689280863459d+00,-8.6028699658868d-01,
     |  -1.0594454734523d-01,-6.7956685704065d-03,-1.7488587355502d-04,
     |  -1.0471756034008d-06,-3.5179776856374d-10,-8.9122493041142d-18/
      data (lpmn(lat,19,21), lat = 1,36)/
     |   1.2503033560474d-19, 1.4928106439322d-11, 7.5313529517938d-08,
     |   1.8077022225803d-05, 9.3729018349033d-04, 1.8783908860638d-02,
     |   1.9292658225994d-01, 1.1836502565112d+00, 4.7206674232604d+00,
     |   1.2696800168751d+01, 2.2608037960829d+01, 2.2510894706125d+01,
     |  -2.9221411687576d+00,-5.0419055958399d+01,-8.3172950462448d+01,
     |  -5.6414057911263d+01, 2.8165007652701d+01, 1.0544446882162d+02,
     |   1.0544446882162d+02, 2.8165007652702d+01,-5.6414057911262d+01,
     |  -8.3172950462448d+01,-5.0419055958399d+01,-2.9221411687575d+00,
     |   2.2510894706125d+01, 2.2608037960829d+01, 1.2696800168751d+01,
     |   4.7206674232604d+00, 1.1836502565112d+00, 1.9292658225994d-01,
     |   1.8783908860638d-02, 9.3729018349033d-04, 1.8077022225803d-05,
     |   7.5313529517941d-08, 1.4928106439322d-11, 1.2503033560473d-19/
      data (lpmn(lat,20,21), lat = 1,36)/
     |   1.3697215054932d-21, 4.9427037247129d-13, 4.2194327856749d-09,
     |   1.4515632523798d-06, 1.0000534026674d-04, 2.5598862236456d-03,
     |   3.2925801740917d-02, 2.5156825653117d-01, 1.2601073151900d+00,
     |   4.3807344776260d+00, 1.0835017498120d+01, 1.8793097413207d+01,
     |   2.0472646314186d+01, 5.4741109304129d+00,-2.7244050464493d+01,
     |  -5.9625644609882d+01,-6.3631176023265d+01,-2.7550857346799d+01,
     |   2.7550857346799d+01, 6.3631176023265d+01, 5.9625644609883d+01,
     |   2.7244050464493d+01,-5.4741109304129d+00,-2.0472646314187d+01,
     |  -1.8793097413207d+01,-1.0835017498120d+01,-4.3807344776260d+00,
     |  -1.2601073151900d+00,-2.5156825653117d-01,-3.2925801740917d-02,
     |  -2.5598862236456d-03,-1.0000534026674d-04,-1.4515632523799d-06,
     |  -4.2194327856751d-09,-4.9427037247129d-13,-1.3697215054932d-21/
      data (lpmn(lat,21,21), lat = 1,36)/
     |   1.0175792779108d-23, 1.1090658965854d-14, 1.5998039979484d-10,
     |   7.8703776145196d-08, 7.1803320731579d-06, 2.3358589571540d-04,
     |   3.7343914792919d-03, 3.5123783027619d-02, 2.1679384424338d-01,
     |   9.4085102203496d-01, 2.9968009507524d+00, 7.1665406400328d+00,
     |   1.2884195640894d+01, 1.6815326833651d+01, 1.3696652219653d+01,
     |   6.6111574313971d-01,-1.8088996967372d+01,-3.2053548411242d+01,
     |  -3.2053548411242d+01,-1.8088996967372d+01, 6.6111574313960d-01,
     |   1.3696652219653d+01, 1.6815326833651d+01, 1.2884195640894d+01,
     |   7.1665406400329d+00, 2.9968009507524d+00, 9.4085102203496d-01,
     |   2.1679384424338d-01, 3.5123783027619d-02, 3.7343914792919d-03,
     |   2.3358589571540d-04, 7.1803320731579d-06, 7.8703776145198d-08,
     |   1.5998039979485d-10, 1.1090658965854d-14, 1.0175792779108d-23/
      data (lpmn(lat, 0,22), lat = 1,36)/
     |  -1.8559610465879d+03, 5.7931317903329d+02, 4.9846263580745d+02,
     |  -7.1852891066875d+02, 1.1868719957118d+02, 4.9720177921580d+02,
     |  -4.5509210776544d+02,-1.0457594904920d+02, 4.8219226620048d+02,
     |  -2.5917628618152d+02,-2.5337552082051d+02, 4.3079100996575d+02,
     |  -8.2402462244023d+01,-3.4972915840088d+02, 3.4328884973795d+02,
     |   8.0196747264652d+01,-3.9768457891829d+02, 2.2429786808667d+02,
     |   2.2429786808668d+02,-3.9768457891829d+02, 8.0196747264649d+01,
     |   3.4328884973795d+02,-3.4972915840088d+02,-8.2402462244020d+01,
     |   4.3079100996575d+02,-2.5337552082051d+02,-2.5917628618152d+02,
     |   4.8219226620048d+02,-1.0457594904920d+02,-4.5509210776544d+02,
     |   4.9720177921580d+02, 1.1868719957118d+02,-7.1852891066875d+02,
     |   4.9846263580744d+02, 5.7931317903329d+02,-1.8559610465879d+03/
      data (lpmn(lat, 1,22), lat = 1,36)/
     |   4.0318021085018d+01,-7.6381197700419d+02, 7.2884100141739d+02,
     |   1.0373050527221d+02,-6.2749207638359d+02, 3.4305891348206d+02,
     |   2.9230904514888d+02,-5.0736183208269d+02, 1.0418955748773d+02,
     |   3.8577629047128d+02,-3.7909583727367d+02,-8.1003432196991d+01,
     |   4.1883814202068d+02,-2.3531732788310d+02,-2.2746743818018d+02,
     |   4.0036578253802d+02,-7.9843952886355d+01,-3.3514509932474d+02,
     |   3.3514509932474d+02, 7.9843952886356d+01,-4.0036578253802d+02,
     |   2.2746743818018d+02, 2.3531732788310d+02,-4.1883814202069d+02,
     |   8.1003432196987d+01, 3.7909583727367d+02,-3.8577629047128d+02,
     |  -1.0418955748773d+02, 5.0736183208269d+02,-2.9230904514887d+02,
     |  -3.4305891348206d+02, 6.2749207638359d+02,-1.0373050527221d+02,
     |  -7.2884100141740d+02, 7.6381197700419d+02,-4.0318021085014d+01/
      data (lpmn(lat, 2,22), lat = 1,36)/
     |   8.3939426720979d+02,-6.2452139375322d+02,-1.6098794744251d+02,
     |   6.8435688277822d+02,-2.4192258884866d+02,-4.2265483380499d+02,
     |   4.8353867600380d+02, 4.4590536977870d+01,-4.6478271232166d+02,
     |   2.8706083686390d+02, 2.2501944083143d+02,-4.3140672126396d+02,
     |   1.0101344501886d+02, 3.3855395380881d+02,-3.4732746767133d+02,
     |  -7.1831278017705d+01, 3.9433748160759d+02,-2.2425828610483d+02,
     |  -2.2425828610483d+02, 3.9433748160759d+02,-7.1831278017702d+01,
     |  -3.4732746767133d+02, 3.3855395380881d+02, 1.0101344501886d+02,
     |  -4.3140672126396d+02, 2.2501944083143d+02, 2.8706083686390d+02,
     |  -4.6478271232166d+02, 4.4590536977868d+01, 4.8353867600380d+02,
     |  -4.2265483380499d+02,-2.4192258884866d+02, 6.8435688277822d+02,
     |  -1.6098794744251d+02,-6.2452139375322d+02, 8.3939426720979d+02/
      data (lpmn(lat, 3,22), lat = 1,36)/
     |   3.6874545186110d+02, 3.1482958162951d+01,-5.7085005997078d+02,
     |   2.5624836231195d+02, 4.6402594716579d+02,-4.5689801505663d+02,
     |  -1.4629631612306d+02, 4.9765112881174d+02,-1.8970174401429d+02,
     |  -3.2982337363336d+02, 4.0141438519377d+02, 3.1040543209819d+01,
     |  -4.0275162878476d+02, 2.5666303692823d+02, 2.0502182065031d+02,
     |  -3.9810159395922d+02, 8.8063547651648d+01, 3.2940835685426d+02,
     |  -3.2940835685426d+02,-8.8063547651649d+01, 3.9810159395922d+02,
     |  -2.0502182065031d+02,-2.5666303692823d+02, 4.0275162878477d+02,
     |  -3.1040543209814d+01,-4.0141438519377d+02, 3.2982337363336d+02,
     |   1.8970174401429d+02,-4.9765112881174d+02, 1.4629631612306d+02,
     |   4.5689801505663d+02,-4.6402594716579d+02,-2.5624836231196d+02,
     |   5.7085005997078d+02,-3.1482958162951d+01,-3.6874545186110d+02/
      data (lpmn(lat, 4,22), lat = 1,36)/
     |   8.4674322560811d+01, 2.5275867977273d+02,-3.0087321015349d+02,
     |  -3.1301895169142d+02, 4.7162421881626d+02, 1.5593329950333d+02,
     |  -5.0420497634084d+02, 1.2628604188373d+02, 3.8874862055336d+02,
     |  -3.5545360548043d+02,-1.3647446364599d+02, 4.2461749260339d+02,
     |  -1.5411067229817d+02,-3.0282730687778d+02, 3.5741967635683d+02,
     |   4.6980244350900d+01,-3.8399093063702d+02, 2.2404023865959d+02,
     |   2.2404023865959d+02,-3.8399093063702d+02, 4.6980244350897d+01,
     |   3.5741967635683d+02,-3.0282730687778d+02,-1.5411067229817d+02,
     |   4.2461749260339d+02,-1.3647446364599d+02,-3.5545360548043d+02,
     |   3.8874862055336d+02, 1.2628604188374d+02,-5.0420497634084d+02,
     |   1.5593329950333d+02, 4.7162421881626d+02,-3.1301895169142d+02,
     |  -3.0087321015349d+02, 2.5275867977273d+02, 8.4674322560810d+01/
      data (lpmn(lat, 5,22), lat = 1,36)/
     |   1.3127839295815d+01, 1.7552879129182d+02, 3.2118402185421d+01,
     |  -3.9717705758010d+02,-3.6699766318544d+00, 4.8416333918039d+02,
     |  -1.3705373604476d+02,-4.0017215349496d+02, 3.2497628228874d+02,
     |   1.9843828754891d+02,-4.2065278186285d+02, 6.5728126215912d+01,
     |   3.6092952663533d+02,-2.9351045253656d+02,-1.5930649656630d+02,
     |   3.9150306247455d+02,-1.0387884717398d+02,-3.1791173097441d+02,
     |   3.1791173097441d+02, 1.0387884717398d+02,-3.9150306247455d+02,
     |   1.5930649656630d+02, 2.9351045253656d+02,-3.6092952663533d+02,
     |  -6.5728126215916d+01, 4.2065278186285d+02,-1.9843828754891d+02,
     |  -3.2497628228874d+02, 4.0017215349496d+02, 1.3705373604477d+02,
     |  -4.8416333918039d+02, 3.6699766318544d+00, 3.9717705758010d+02,
     |  -3.2118402185419d+01,-1.7552879129182d+02,-1.3127839295814d+01/
      data (lpmn(lat, 6,22), lat = 1,36)/
     |   1.5270569023961d+00, 7.3899614937306d+01, 1.4486151615695d+02,
     |  -1.6767336537888d+02,-3.1566375389396d+02, 2.4645391920934d+02,
     |   3.4149300728183d+02,-3.3558294889128d+02,-2.0239065077438d+02,
     |   4.1111599865096d+02,-1.3617403423191d+01,-3.8554161237121d+02,
     |   2.3115001394686d+02, 2.3705915013271d+02,-3.6733597717814d+02,
     |  -6.6099790422931d+00, 3.6576061693292d+02,-2.2333937581444d+02,
     |  -2.2333937581444d+02, 3.6576061693292d+02,-6.6099790422900d+00,
     |  -3.6733597717814d+02, 2.3705915013270d+02, 2.3115001394686d+02,
     |  -3.8554161237121d+02,-1.3617403423191d+01, 4.1111599865096d+02,
     |  -2.0239065077438d+02,-3.3558294889129d+02, 3.4149300728183d+02,
     |   2.4645391920934d+02,-3.1566375389396d+02,-1.6767336537888d+02,
     |   1.4486151615695d+02, 7.3899614937306d+01, 1.5270569023961d+00/
      data (lpmn(lat, 7,22), lat = 1,36)/
     |   1.4118825124525d-01, 2.2896012522227d+01, 1.1385806769591d+02,
     |   3.5661616424863d+01,-2.7779370304455d+02,-1.3234298717707d+02,
     |   3.7465093635641d+02, 1.2272631684651d+02,-4.0563347030695d+02,
     |   1.6754765899456d+01, 3.8566274271539d+02,-1.9314059354831d+02,
     |  -2.7742530812443d+02, 3.3265288106563d+02, 8.9911207041023d+01,
     |  -3.7651482787943d+02, 1.2593767079335d+02, 3.0061614722352d+02,
     |  -3.0061614722352d+02,-1.2593767079335d+02, 3.7651482787943d+02,
     |  -8.9911207041022d+01,-3.3265288106563d+02, 2.7742530812443d+02,
     |   1.9314059354831d+02,-3.8566274271539d+02,-1.6754765899456d+01,
     |   4.0563347030695d+02,-1.2272631684651d+02,-3.7465093635641d+02,
     |   1.3234298717707d+02, 2.7779370304455d+02,-3.5661616424862d+01,
     |  -1.1385806769591d+02,-2.2896012522227d+01,-1.4118825124525d-01/
      data (lpmn(lat, 8,22), lat = 1,36)/
     |   1.0755960220830d-02, 5.6311901713520d+00, 5.7868145991466d+01,
     |   1.0117368418745d+02,-9.3138505155242d+01,-2.7782270547855d+02,
     |   6.9586482836956d+01, 3.7191626864968d+02,-9.2065926390611d+01,
     |  -3.5910471565683d+02, 1.9688937228687d+02, 2.8036479621998d+02,
     |  -3.0778510685742d+02,-1.3631971107355d+02, 3.6641498818723d+02,
     |  -4.6890288617578d+01,-3.3829068224516d+02, 2.2162575488559d+02,
     |   2.2162575488559d+02,-3.3829068224515d+02,-4.6890288617581d+01,
     |   3.6641498818723d+02,-1.3631971107355d+02,-3.0778510685742d+02,
     |   2.8036479621998d+02, 1.9688937228687d+02,-3.5910471565683d+02,
     |  -9.2065926390613d+01, 3.7191626864968d+02, 6.9586482836958d+01,
     |  -2.7782270547855d+02,-9.3138505155242d+01, 1.0117368418745d+02,
     |   5.7868145991466d+01, 5.6311901713520d+00, 1.0755960220830d-02/
      data (lpmn(lat, 9,22), lat = 1,36)/
     |   6.9162218879847d-04, 1.1447159440402d+00, 2.2448252554082d+01,
     |   8.1711632054377d+01, 4.0190724658278d+01,-1.8958085775766d+02,
     |  -1.8922619255946d+02, 2.2492217854194d+02, 2.7109216179100d+02,
     |  -2.4701405355209d+02,-2.3779390845554d+02, 3.0572542825594d+02,
     |   1.3980554301446d+02,-3.5178351480158d+02, 4.9372265150898d-01,
     |   3.4741848558454d+02,-1.5194958233784d+02,-2.7748260133084d+02,
     |   2.7748260133084d+02, 1.5194958233784d+02,-3.4741848558454d+02,
     |  -4.9372265150975d-01, 3.5178351480158d+02,-1.3980554301447d+02,
     |  -3.0572542825594d+02, 2.3779390845554d+02, 2.4701405355209d+02,
     |  -2.7109216179100d+02,-2.2492217854195d+02, 1.8922619255945d+02,
     |   1.8958085775766d+02,-4.0190724658278d+01,-8.1711632054377d+01,
     |  -2.2448252554082d+01,-1.1447159440402d+00,-6.9162218879847d-04/
      data (lpmn(lat,10,22), lat = 1,36)/
     |   3.8170851762968d-05, 1.9714758325667d-01, 7.0831732358429d+00,
     |   4.4766499603200d+01, 7.7605415571484d+01,-4.3276146911563d+01,
     |  -2.2550142912590d+02,-5.6614799420081d+01, 3.0176668899906d+02,
     |   1.2402853258135d+02,-3.2080154065624d+02,-9.1349897814819d+01,
     |   3.4088060892234d+02, 3.9804196921251d+00,-3.4012538691092d+02,
     |   1.0852642025653d+02, 2.9998041532413d+02,-2.1810498481660d+02,
     |  -2.1810498481660d+02, 2.9998041532413d+02, 1.0852642025654d+02,
     |  -3.4012538691092d+02, 3.9804196921247d+00, 3.4088060892234d+02,
     |  -9.1349897814816d+01,-3.2080154065624d+02, 1.2402853258135d+02,
     |   3.0176668899906d+02,-5.6614799420080d+01,-2.2550142912590d+02,
     |  -4.3276146911563d+01, 7.7605415571484d+01, 4.4766499603200d+01,
     |   7.0831732358430d+00, 1.9714758325667d-01, 3.8170851762968d-05/
      data (lpmn(lat,11,22), lat = 1,36)/
     |   1.8295942070756d-06, 2.9234947693340d-02, 1.8786457107662d+00,
     |   1.9141514330201d+01, 6.0924559570800d+01, 4.4179468405084d+01,
     |  -1.1887878378831d+02,-2.0032303444024d+02, 7.4166983535587d+01,
     |   3.0150834868185d+02,-2.0946987843337d+01,-3.2217727615600d+02,
     |   4.0564095911747d+01, 3.2100860484336d+02,-1.0195108402662d+02,
     |  -2.9773759723273d+02, 1.7837267474253d+02, 2.4850084226353d+02,
     |  -2.4850084226353d+02,-1.7837267474253d+02, 2.9773759723273d+02,
     |   1.0195108402662d+02,-3.2100860484336d+02,-4.0564095911745d+01,
     |   3.2217727615600d+02, 2.0946987843337d+01,-3.0150834868185d+02,
     |  -7.4166983535589d+01, 2.0032303444024d+02, 1.1887878378831d+02,
     |  -4.4179468405084d+01,-6.0924559570800d+01,-1.9141514330201d+01,
     |  -1.8786457107662d+00,-2.9234947693340d-02,-1.8295942070756d-06/
      data (lpmn(lat,12,22), lat = 1,36)/
     |   7.6783969224807d-08, 3.7730977053712d-03, 4.2697444333900d-01,
     |   6.7438637751758d+00, 3.3854891896134d+01, 6.1904741964487d+01,
     |  -7.1240137544333d+00,-1.6533071564405d+02,-1.3336529840194d+02,
     |   1.7182579238917d+02, 2.4746752513816d+02,-1.3292723728933d+02,
     |  -2.7696462888797d+02, 1.3651828431483d+02, 2.7315043318571d+02,
     |  -1.6912865765063d+02,-2.4941700704203d+02, 2.1165153367111d+02,
     |   2.1165153367111d+02,-2.4941700704203d+02,-1.6912865765063d+02,
     |   2.7315043318571d+02, 1.3651828431483d+02,-2.7696462888797d+02,
     |  -1.3292723728933d+02, 2.4746752513816d+02, 1.7182579238917d+02,
     |  -1.3336529840194d+02,-1.6533071564405d+02,-7.1240137544337d+00,
     |   6.1904741964487d+01, 3.3854891896134d+01, 6.7438637751759d+00,
     |   4.2697444333901d-01, 3.7730977053712d-03, 7.6783969224807d-08/
      data (lpmn(lat,13,22), lat = 1,36)/
     |   2.8362833282303d-09, 4.2674440360818d-04, 8.4139336882708d-02,
     |   2.0116656173783d+00, 1.4915616859520d+01, 4.5341080621412d+01,
     |   4.5950671506295d+01,-5.9971103009933d+01,-1.7622396938880d+02,
     |  -5.1108249055658d+01, 2.2508606620047d+02, 1.7007283747404d+02,
     |  -2.0143230818245d+02,-2.1435694070566d+02, 1.9222755242653d+02,
     |   2.2234093314693d+02,-2.0001604536310d+02,-2.1373892743474d+02,
     |   2.1373892743473d+02, 2.0001604536310d+02,-2.2234093314693d+02,
     |  -1.9222755242653d+02, 2.1435694070566d+02, 2.0143230818245d+02,
     |  -1.7007283747404d+02,-2.2508606620047d+02, 5.1108249055657d+01,
     |   1.7622396938880d+02, 5.9971103009934d+01,-4.5950671506295d+01,
     |  -4.5341080621412d+01,-1.4915616859520d+01,-2.0116656173784d+00,
     |  -8.4139336882710d-02,-4.2674440360818d-04,-2.8362833282302d-09/
      data (lpmn(lat,14,22), lat = 1,36)/
     |   9.2461551445657d-11, 4.2457878820028d-05, 1.4473870347828d-02,
     |   5.1566403333217d-01, 5.4482754882655d+00, 2.4410498781887d+01,
     |   4.8983393420002d+01, 1.8213538826237d+01,-1.0100146330681d+02,
     |  -1.5814863412814d+02, 2.3863747566631d+01, 2.3925635324576d+02,
     |   9.5343142001964d+01,-2.3134200027475d+02,-1.5778698410553d+02,
     |   2.1382702084038d+02, 1.8617670751178d+02,-2.0069284150119d+02,
     |  -2.0069284150119d+02, 1.8617670751178d+02, 2.1382702084038d+02,
     |  -1.5778698410553d+02,-2.3134200027475d+02, 9.5343142001966d+01,
     |   2.3925635324576d+02, 2.3863747566631d+01,-1.5814863412814d+02,
     |  -1.0100146330681d+02, 1.8213538826237d+01, 4.8983393420002d+01,
     |   2.4410498781887d+01, 5.4482754882655d+00, 5.1566403333218d-01,
     |   1.4473870347828d-02, 4.2457878820028d-05, 9.2461551445656d-11/
      data (lpmn(lat,15,22), lat = 1,36)/
     |   2.6607930761849d-12, 3.7196725525692d-06, 2.1799376353764d-03,
     |   1.1446292354718d-01, 1.6854076012787d+00, 1.0527846230220d+01,
     |   3.2300737033579d+01, 4.3728723130671d+01,-1.2830624396084d+01,
     |  -1.2408980320168d+02,-1.2452455068167d+02, 7.8433466922566d+01,
     |   2.2841977793073d+02, 3.9715198624147d+01,-2.3452502418288d+02,
     |  -1.2170572479722d+02, 2.0962787568683d+02, 1.7343160537750d+02,
     |  -1.7343160537750d+02,-2.0962787568683d+02, 1.2170572479722d+02,
     |   2.3452502418288d+02,-3.9715198624146d+01,-2.2841977793073d+02,
     |  -7.8433466922567d+01, 1.2452455068167d+02, 1.2408980320168d+02,
     |   1.2830624396084d+01,-4.3728723130670d+01,-3.2300737033579d+01,
     |  -1.0527846230220d+01,-1.6854076012787d+00,-1.1446292354718d-01,
     |  -2.1799376353765d-03,-3.7196725525692d-06,-2.6607930761849d-12/
      data (lpmn(lat,16,22), lat = 1,36)/
     |   6.7430531420988d-14, 2.8641707095566d-07, 2.8730932784874d-04,
     |   2.2054718304408d-02, 4.4584537232009d-01, 3.7624027917683d+00,
     |   1.6120297145953d+01, 3.6388583199380d+01, 3.2076435492384d+01,
     |  -3.9405505616466d+01,-1.3031553450361d+02,-8.9213506856609d+01,
     |   1.0883542005511d+02, 2.0769411867161d+02, 1.0560637556236d+01,
     |  -2.2194152365217d+02,-1.1230900486960d+02, 1.8299101736920d+02,
     |   1.8299101736920d+02,-1.1230900486960d+02,-2.2194152365217d+02,
     |   1.0560637556236d+01, 2.0769411867161d+02, 1.0883542005511d+02,
     |  -8.9213506856608d+01,-1.3031553450361d+02,-3.9405505616466d+01,
     |   3.2076435492384d+01, 3.6388583199380d+01, 1.6120297145953d+01,
     |   3.7624027917683d+00, 4.4584537232009d-01, 2.2054718304409d-02,
     |   2.8730932784875d-04, 2.8641707095566d-07, 6.7430531420988d-14/
      data (lpmn(lat,17,22), lat = 1,36)/
     |   1.4964391766024d-15, 1.9282968645442d-08, 3.2994816367972d-05,
     |   3.6801946517117d-03, 1.0105513085723d-01, 1.1292444813801d+00,
     |   6.4586795096131d+00, 2.0775344268055d+01, 3.6219373709675d+01,
     |   1.8436429912091d+01,-5.6828855277345d+01,-1.2509744141704d+02,
     |  -6.2504414180534d+01, 1.1695731369814d+02, 1.8786044258890d+02,
     |   9.5652616050572d+00,-1.9768849703123d+02,-1.2815201531685d+02,
     |   1.2815201531685d+02, 1.9768849703123d+02,-9.5652616050561d+00,
     |  -1.8786044258890d+02,-1.1695731369814d+02, 6.2504414180535d+01,
     |   1.2509744141704d+02, 5.6828855277345d+01,-1.8436429912090d+01,
     |  -3.6219373709676d+01,-2.0775344268054d+01,-6.4586795096131d+00,
     |  -1.1292444813801d+00,-1.0105513085723d-01,-3.6801946517117d-03,
     |  -3.2994816367973d-05,-1.9282968645442d-08,-1.4964391766024d-15/
      data (lpmn(lat,18,22), lat = 1,36)/
     |   2.8791739268635d-17, 1.1241063143290d-09, 3.2719702104181d-06,
     |   5.2776390638406d-04, 1.9529197141489d-02, 2.8503030817892d-01,
     |   2.1189819819271d+00, 9.0985331997996d+00, 2.3443851369823d+01,
     |   3.3001250146644d+01, 7.1746772639723d+00,-6.3690457659184d+01,
     |  -1.1452843927498d+02,-4.9863158037166d+01, 1.0567863906875d+02,
     |   1.7210357893393d+02, 3.5196339199737d+01,-1.5516112426175d+02,
     |  -1.5516112426175d+02, 3.5196339199737d+01, 1.7210357893393d+02,
     |   1.0567863906875d+02,-4.9863158037166d+01,-1.1452843927498d+02,
     |  -6.3690457659185d+01, 7.1746772639723d+00, 3.3001250146644d+01,
     |   2.3443851369823d+01, 9.0985331997996d+00, 2.1189819819271d+00,
     |   2.8503030817892d-01, 1.9529197141489d-02, 5.2776390638407d-04,
     |   3.2719702104182d-06, 1.1241063143290d-09, 2.8791739268635d-17/
      data (lpmn(lat,19,22), lat = 1,36)/
     |   4.7224004158463d-19, 5.5805501144937d-11, 2.7570335640716d-07,
     |   6.4066847069615d-05, 3.1753281637098d-03, 5.9930442985262d-02,
     |   5.6910280633855d-01, 3.1492321447042d+00, 1.0912848018084d+01,
     |   2.3820426055183d+01, 2.8724083348000d+01, 1.3225998788339d+00,
     |  -6.0450837108318d+01,-1.0223180582920d+02,-5.2001458817643d+01,
     |   7.5558343032582d+01, 1.5312505499634d+02, 7.9203179054669d+01,
     |  -7.9203179054669d+01,-1.5312505499634d+02,-7.5558343032583d+01,
     |   5.2001458817643d+01, 1.0223180582920d+02, 6.0450837108318d+01,
     |  -1.3225998788336d+00,-2.8724083348000d+01,-2.3820426055183d+01,
     |  -1.0912848018084d+01,-3.1492321447042d+00,-5.6910280633856d-01,
     |  -5.9930442985262d-02,-3.1753281637098d-03,-6.4066847069617d-05,
     |  -2.7570335640717d-07,-5.5805501144937d-11,-4.7224004158463d-19/
      data (lpmn(lat,20,22), lat = 1,36)/
     |   6.4134185866441d-21, 2.2919467716543d-12, 1.9183874191652d-08,
     |   6.4026156414793d-06, 4.2299903912605d-04, 1.0246885695570d-02,
     |   1.2278083356857d-01, 8.5676480828209d-01, 3.8150363435761d+00,
     |   1.1315023436477d+01, 2.2147035111651d+01, 2.5020456101208d+01,
     |   2.0875272965630d+00,-4.7679111817152d+01,-8.7005936413896d+01,
     |  -6.3604612032091d+01, 2.6176528356339d+01, 1.1124275004342d+02,
     |   1.1124275004342d+02, 2.6176528356339d+01,-6.3604612032091d+01,
     |  -8.7005936413896d+01,-4.7679111817152d+01, 2.0875272965631d+00,
     |   2.5020456101208d+01, 2.2147035111651d+01, 1.1315023436477d+01,
     |   3.8150363435761d+00, 8.5676480828210d-01, 1.2278083356857d-01,
     |   1.0246885695570d-02, 4.2299903912605d-04, 6.4026156414794d-06,
     |   1.9183874191653d-08, 2.2919467716543d-12, 6.4134185866440d-21/
      data (lpmn(lat,21,22), lat = 1,36)/
     |   6.8183351698031d-23, 7.3634251029115d-14, 1.0425925933004d-09,
     |   4.9850721892778d-07, 4.3732573409158d-05, 1.3518237512299d-03,
     |   2.0255441367326d-02, 1.7562997653421d-01, 9.7865304533874d-01,
     |   3.7268089029285d+00, 9.9817573569287d+00, 1.8636429845296d+01,
     |   2.2082741055878d+01, 8.4208918926144d+00,-2.5593611099168d+01,
     |  -6.1657071763981d+01,-6.8015887839872d+01,-2.9850089481561d+01,
     |   2.9850089481561d+01, 6.8015887839872d+01, 6.1657071763981d+01,
     |   2.5593611099167d+01,-8.4208918926144d+00,-2.2082741055878d+01,
     |  -1.8636429845296d+01,-9.9817573569287d+00,-3.7268089029285d+00,
     |  -9.7865304533875d-01,-1.7562997653421d-01,-2.0255441367326d-02,
     |  -1.3518237512299d-03,-4.3732573409158d-05,-4.9850721892779d-07,
     |  -1.0425925933004d-09,-7.3634251029115d-14,-6.8183351698031d-23/
      data (lpmn(lat,22,22), lat = 1,36)/
     |   4.9264751779018d-25, 1.6067859175555d-15, 3.8435853224385d-11,
     |   2.6273501217377d-08, 3.0509385692845d-06, 1.1978347253477d-04,
     |   2.2290095164064d-03, 2.3763159281399d-02, 1.6286898488428d-01,
     |   7.7201130511193d-01, 2.6493833861876d+00, 6.7490335307336d+00,
     |   1.2807402312961d+01, 1.7543878795318d+01, 1.5104312426389d+01,
     |   1.7302043099635d+00,-1.8482767926400d+01,-3.3859660758694d+01,
     |  -3.3859660758694d+01,-1.8482767926400d+01, 1.7302043099633d+00,
     |   1.5104312426389d+01, 1.7543878795318d+01, 1.2807402312961d+01,
     |   6.7490335307337d+00, 2.6493833861876d+00, 7.7201130511193d-01,
     |   1.6286898488428d-01, 2.3763159281399d-02, 2.2290095164064d-03,
     |   1.1978347253477d-04, 3.0509385692845d-06, 2.6273501217378d-08,
     |   3.8435853224387d-11, 1.6067859175555d-15, 4.9264751779018d-25/
      data (lpmn(lat, 0,23), lat = 1,36)/
     |  -2.0176696315406d+03, 7.6331686922655d+02, 3.6297309787117d+02,
     |  -7.9877440515960d+02, 3.8766653071703d+02, 3.1735155950453d+02,
     |  -6.0035030987598d+02, 2.4608605357582d+02, 3.1926803475307d+02,
     |  -5.0647607706050d+02, 1.5700672387462d+02, 3.3275607832276d+02,
     |  -4.4853283702387d+02, 8.8392828316716d+01, 3.5215076287358d+02,
     |  -4.0773719110710d+02, 2.8617593785563d+01, 3.7672045144193d+02,
     |  -3.7672045144193d+02,-2.8617593785564d+01, 4.0773719110710d+02,
     |  -3.5215076287357d+02,-8.8392828316717d+01, 4.4853283702387d+02,
     |  -3.3275607832276d+02,-1.5700672387462d+02, 5.0647607706050d+02,
     |  -3.1926803475306d+02,-2.4608605357582d+02, 6.0035030987598d+02,
     |  -3.1735155950453d+02,-3.8766653071703d+02, 7.9877440515960d+02,
     |  -3.6297309787116d+02,-7.6331686922655d+02, 2.0176696315406d+03/
      data (lpmn(lat, 1,23), lat = 1,36)/
     |  -5.7397551846084d+01,-7.4342281860991d+02, 8.7552483297260d+02,
     |  -1.2529639639149d+02,-5.7056161584458d+02, 5.7350738454017d+02,
     |  -1.8945564550068d+00,-4.9899020975144d+02, 4.3615820462099d+02,
     |   7.0426180960459d+01,-4.6516417782953d+02, 3.4906017252118d+02,
     |   1.2689108918605d+02,-4.4803802040906d+02, 2.8359181434309d+02,
     |   1.7780433646779d+02,-4.4065844935991d+02, 2.2851787468685d+02,
     |   2.2851787468685d+02,-4.4065844935991d+02, 1.7780433646779d+02,
     |   2.8359181434309d+02,-4.4803802040906d+02, 1.2689108918605d+02,
     |   3.4906017252119d+02,-4.6516417782953d+02, 7.0426180960458d+01,
     |   4.3615820462100d+02,-4.9899020975144d+02,-1.8945564550121d+00,
     |   5.7350738454017d+02,-5.7056161584458d+02,-1.2529639639149d+02,
     |   8.7552483297260d+02,-7.4342281860991d+02,-5.7397551846088d+01/
      data (lpmn(lat, 2,23), lat = 1,36)/
     |   9.0226119353136d+02,-7.4912185027333d+02,-1.1236178883465d+01,
     |   7.0428614810723d+02,-4.8220957317274d+02,-2.1558501605287d+02,
     |   5.8609540108113d+02,-2.9635266715777d+02,-2.7466322445461d+02,
     |   5.0608030975535d+02,-1.8565678987816d+02,-3.1114546022738d+02,
     |   4.5080330207129d+02,-1.0352723002734d+02,-3.4240007602775d+02,
     |   4.0871479294941d+02,-3.3378254660640d+01,-3.7381851964336d+02,
     |   3.7381851964336d+02, 3.3378254660641d+01,-4.0871479294942d+02,
     |   3.4240007602775d+02, 1.0352723002734d+02,-4.5080330207129d+02,
     |   3.1114546022738d+02, 1.8565678987816d+02,-5.0608030975535d+02,
     |   2.7466322445461d+02, 2.9635266715777d+02,-5.8609540108113d+02,
     |   2.1558501605287d+02, 4.8220957317274d+02,-7.0428614810723d+02,
     |   1.1236178883456d+01, 7.4912185027333d+02,-9.0226119353136d+02/
      data (lpmn(lat, 3,23), lat = 1,36)/
     |   4.2264745351028d+02,-3.6990466489946d+01,-6.0263094227980d+02,
     |   4.4592257355837d+02, 3.2894971019351d+02,-6.0391877952097d+02,
     |   1.5422386252385d+02, 4.1666740219032d+02,-4.7407401490525d+02,
     |   9.2509420955441d+00, 4.3205216006237d+02,-3.7667604229290d+02,
     |  -8.5298150140526d+01, 4.3476253808550d+02,-2.9837976889886d+02,
     |  -1.6037342149241d+02, 4.3499154044625d+02,-2.2878545672199d+02,
     |  -2.2878545672199d+02, 4.3499154044625d+02,-1.6037342149240d+02,
     |  -2.9837976889886d+02, 4.3476253808550d+02,-8.5298150140530d+01,
     |  -3.7667604229290d+02, 4.3205216006237d+02, 9.2509420955458d+00,
     |  -4.7407401490525d+02, 4.1666740219032d+02, 1.5422386252386d+02,
     |  -6.0391877952097d+02, 3.2894971019351d+02, 4.4592257355838d+02,
     |  -6.0263094227980d+02,-3.6990466489946d+01, 4.2264745351027d+02/
      data (lpmn(lat, 4,23), lat = 1,36)/
     |   1.0210490319488d+02, 2.6369600295077d+02,-4.0534679658395d+02,
     |  -2.2040701691675d+02, 5.9422611464428d+02,-8.6351160701620d+01,
     |  -4.8422536682088d+02, 4.1535184315688d+02, 1.3308504281057d+02,
     |  -4.8612140228900d+02, 2.6399131908412d+02, 2.4237967260632d+02,
     |  -4.5193583108350d+02, 1.4722011506719d+02, 3.1205596795907d+02,
     |  -4.1058963753018d+02, 4.7407869326493d+01, 3.6509675579791d+02,
     |  -3.6509675579791d+02,-4.7407869326494d+01, 4.1058963753018d+02,
     |  -3.1205596795906d+02,-1.4722011506719d+02, 4.5193583108350d+02,
     |  -2.4237967260631d+02,-2.6399131908412d+02, 4.8612140228900d+02,
     |  -1.3308504281057d+02,-4.1535184315688d+02, 4.8422536682087d+02,
     |   8.6351160701620d+01,-5.9422611464428d+02, 2.2040701691674d+02,
     |   4.0534679658396d+02,-2.6369600295077d+02,-1.0210490319488d+02/
      data (lpmn(lat, 5,23), lat = 1,36)/
     |   1.6611171839859d+01, 2.0575032387854d+02,-2.4320267487935d+01,
     |  -4.5168797670988d+02, 1.7091068286105d+02, 4.6643529268004d+02,
     |  -3.8592373729276d+02,-2.0665925491325d+02, 4.9462250573747d+02,
     |  -1.5841369916283d+02,-3.4635810076932d+02, 4.1594790800049d+02,
     |   2.8602680282862d+00,-4.0212250903377d+02, 3.2435471732998d+02,
     |   1.2556105622494d+02,-4.2298112977759d+02, 2.2913003121264d+02,
     |   2.2913003121264d+02,-4.2298112977759d+02, 1.2556105622494d+02,
     |   3.2435471732998d+02,-4.0212250903377d+02, 2.8602680282894d+00,
     |   4.1594790800049d+02,-3.4635810076932d+02,-1.5841369916283d+02,
     |   4.9462250573747d+02,-2.0665925491325d+02,-3.8592373729276d+02,
     |   4.6643529268004d+02, 1.7091068286105d+02,-4.5168797670988d+02,
     |  -2.4320267487938d+01, 2.0575032387854d+02, 1.6611171839859d+01/
      data (lpmn(lat, 6,23), lat = 1,36)/
     |   2.0268510185283d+00, 9.3046598287792d+01, 1.4589864375440d+02,
     |  -2.5888968090826d+02,-2.6982972290547d+02, 4.1566441447500d+02,
     |   1.7720780640737d+02,-4.8549627282833d+02, 1.0184122122054d+02,
     |   3.9520840689534d+02,-3.6278173404601d+02,-1.1918518030021d+02,
     |   4.3506452979168d+02,-2.1319892250828d+02,-2.5833917524091d+02,
     |   4.1016942246049d+02,-6.9897450497978d+01,-3.5051030834377d+02,
     |   3.5051030834377d+02, 6.9897450497979d+01,-4.1016942246049d+02,
     |   2.5833917524091d+02, 2.1319892250828d+02,-4.3506452979169d+02,
     |   1.1918518030021d+02, 3.6278173404601d+02,-3.9520840689534d+02,
     |  -1.0184122122054d+02, 4.8549627282833d+02,-1.7720780640737d+02,
     |  -4.1566441447500d+02, 2.6982972290547d+02, 2.5888968090826d+02,
     |  -1.4589864375440d+02,-9.3046598287792d+01,-2.0268510185283d+00/
      data (lpmn(lat, 7,23), lat = 1,36)/
     |   1.9667866288613d-01, 3.0630098419371d+01, 1.3518754196793d+02,
     |  -1.1896320162339d+01,-3.4438072105356d+02, 7.0621489741909d+00,
     |   4.5292385316411d+02,-1.2914247216679d+02,-3.9198717900659d+02,
     |   3.2923955276215d+02, 1.8258303063426d+02,-4.3221777793458d+02,
     |   1.1369270383881d+02, 3.3941851536433d+02,-3.5371575034332d+02,
     |  -7.3909032227515d+01, 4.0332188056147d+02,-2.2915868537069d+02,
     |  -2.2915868537069d+02, 4.0332188056147d+02,-7.3909032227512d+01,
     |  -3.5371575034332d+02, 3.3941851536433d+02, 1.1369270383881d+02,
     |  -4.3221777793458d+02, 1.8258303063426d+02, 3.2923955276216d+02,
     |  -3.9198717900659d+02,-1.2914247216679d+02, 4.5292385316411d+02,
     |   7.0621489741909d+00,-3.4438072105356d+02,-1.1896320162340d+01,
     |   1.3518754196793d+02, 3.0630098419371d+01, 1.9667866288613d-01/
      data (lpmn(lat, 8,23), lat = 1,36)/
     |   1.5742159639588d-02, 7.9751534691136d+00, 7.5371782739510d+01,
     |   9.9749660317650d+01,-1.7365825327003d+02,-2.7035963790995d+02,
     |   2.4726502479333d+02, 3.1492940107588d+02,-3.3891264589725d+02,
     |  -1.7993416949371d+02, 4.1843581149242d+02,-5.4169433816841d+01,
     |  -3.7439303498688d+02, 2.8751489675951d+02, 1.7843614542284d+02,
     |  -4.0213418354534d+02, 9.9323849647505d+01, 3.2999521558340d+02,
     |  -3.2999521558340d+02,-9.9323849647505d+01, 4.0213418354534d+02,
     |  -1.7843614542284d+02,-2.8751489675951d+02, 3.7439303498688d+02,
     |   5.4169433816845d+01,-4.1843581149242d+02, 1.7993416949371d+02,
     |   3.3891264589725d+02,-3.1492940107588d+02,-2.4726502479333d+02,
     |   2.7035963790995d+02, 1.7365825327003d+02,-9.9749660317650d+01,
     |  -7.5371782739511d+01,-7.9751534691136d+00,-1.5742159639588d-02/
      data (lpmn(lat, 9,23), lat = 1,36)/
     |   1.0651099904038d-03, 1.7147147336912d+00, 3.1497659181653d+01,
     |   9.8601360542443d+01, 1.1606190829522d+00,-2.6303152246015d+02,
     |  -9.3990239896584d+01, 3.6775530374325d+02, 8.9962607673835d+01,
     |  -4.0376180233311d+02, 5.4717859580923d+01, 3.7455025579439d+02,
     |  -2.4177195235080d+02,-2.3553419942763d+02, 3.7366055323540d+02,
     |   7.3803060098243d+00,-3.7419874209852d+02, 2.2825071750639d+02,
     |   2.2825071750639d+02,-3.7419874209852d+02, 7.3803060098212d+00,
     |   3.7366055323540d+02,-2.3553419942763d+02,-2.4177195235080d+02,
     |   3.7455025579439d+02, 5.4717859580923d+01,-4.0376180233311d+02,
     |   8.9962607673834d+01, 3.6775530374325d+02,-9.3990239896582d+01,
     |  -2.6303152246015d+02, 1.1606190829519d+00, 9.8601360542444d+01,
     |   3.1497659181653d+01, 1.7147147336912d+00, 1.0651099904038d-03/
      data (lpmn(lat,10,23), lat = 1,36)/
     |   6.1974050174347d-05, 3.1251425619157d-01, 1.0637709686688d+01,
     |   6.0425932558495d+01, 7.7023550500738d+01,-1.1322473472123d+02,
     |  -2.5047809964156d+02, 1.0084828788177d+02, 3.5236081649451d+02,
     |  -1.2752502459990d+02,-3.3968318184326d+02, 2.3680814908211d+02,
     |   2.4478688398332d+02,-3.4487340312941d+02,-7.2722457684545d+01,
     |   3.7927483962945d+02,-1.3318239930088d+02,-3.0348696695321d+02,
     |   3.0348696695321d+02, 1.3318239930088d+02,-3.7927483962945d+02,
     |   7.2722457684544d+01, 3.4487340312941d+02,-2.4478688398333d+02,
     |  -2.3680814908211d+02, 3.3968318184326d+02, 1.2752502459990d+02,
     |  -3.5236081649451d+02,-1.0084828788177d+02, 2.5047809964156d+02,
     |   1.1322473472123d+02,-7.7023550500738d+01,-6.0425932558495d+01,
     |  -1.0637709686689d+01,-3.1251425619157d-01,-6.1974050174347d-05/
      data (lpmn(lat,11,23), lat = 1,36)/
     |   3.1393225891592d-06, 4.9116215000284d-02, 3.0137383016817d+00,
     |   2.8232452120902d+01, 7.5635329223735d+01, 1.4437883056506d+01,
     |  -1.9465994195809d+02,-1.5435394609919d+02, 2.4479723519191d+02,
     |   2.3792250967182d+02,-2.7445453242648d+02,-2.0056246377058d+02,
     |   3.3280435708783d+02, 8.7910441239689d+01,-3.6640526090960d+02,
     |   6.9179403091605d+01, 3.3353051851401d+02,-2.2551354079642d+02,
     |  -2.2551354079642d+02, 3.3353051851401d+02, 6.9179403091608d+01,
     |  -3.6640526090960d+02, 8.7910441239688d+01, 3.3280435708783d+02,
     |  -2.0056246377058d+02,-2.7445453242648d+02, 2.3792250967182d+02,
     |   2.4479723519191d+02,-1.5435394609919d+02,-1.9465994195809d+02,
     |   1.4437883056506d+01, 7.5635329223735d+01, 2.8232452120902d+01,
     |   3.0137383016818d+00, 4.9116215000284d-02, 3.1393225891592d-06/
      data (lpmn(lat,12,23), lat = 1,36)/
     |   1.3965379364464d-07, 6.7343846442877d-03, 7.3187130135358d-01,
     |   1.0778494983107d+01, 4.7821521152263d+01, 6.4134069631601d+01,
     |  -6.4846233787949d+01,-2.1643021010739d+02,-2.0387244953465d+01,
     |   3.0602448297251d+02, 8.3390284197252d+01,-3.3195427373093d+02,
     |  -4.5739233547583d+01, 3.4837196342224d+02,-5.0093266312497d+01,
     |  -3.3337877925777d+02, 1.6760905055056d+02, 2.7095225149573d+02,
     |  -2.7095225149573d+02,-1.6760905055056d+02, 3.3337877925777d+02,
     |   5.0093266312497d+01,-3.4837196342224d+02, 4.5739233547585d+01,
     |   3.3195427373093d+02,-8.3390284197252d+01,-3.0602448297251d+02,
     |   2.0387244953464d+01, 2.1643021010739d+02, 6.4846233787950d+01,
     |  -6.4134069631601d+01,-4.7821521152263d+01,-1.0778494983107d+01,
     |  -7.3187130135359d-01,-6.7343846442877d-03,-1.3965379364464d-07/
      data (lpmn(lat,13,23), lat = 1,36)/
     |   5.4882938794103d-09, 8.1182348179318d-04, 1.5439914092351d-01,
     |   3.4755080934086d+00, 2.3362032783767d+01, 5.9107288397248d+01,
     |   2.6683221641280d+01,-1.3210426730289d+02,-1.8031114987453d+02,
     |   1.0467846340615d+02, 2.9042074230779d+02,-5.9355196475093d+01,
     |  -3.1647501578353d+02, 8.2609448199218d+01, 3.1209751138475d+02,
     |  -1.4610936235291d+02,-2.7943791704506d+02, 2.1970957557724d+02,
     |   2.1970957557724d+02,-2.7943791704506d+02,-1.4610936235291d+02,
     |   3.1209751138475d+02, 8.2609448199219d+01,-3.1647501578353d+02,
     |  -5.9355196475096d+01, 2.9042074230779d+02, 1.0467846340615d+02,
     |  -1.8031114987453d+02,-1.3210426730289d+02, 2.6683221641280d+01,
     |   5.9107288397248d+01, 2.3362032783767d+01, 3.4755080934086d+00,
     |   1.5439914092352d-01, 8.1182348179318d-04, 5.4882938794103d-09/
      data (lpmn(lat,14,23), lat = 1,36)/
     |   1.9122912294126d-10, 8.6458399936378d-05, 2.8530694081216d-02,
     |   9.6383863422937d-01, 9.3795997955854d+00, 3.6741244811397d+01,
     |   5.5069598951870d+01,-2.4379337870743d+01,-1.6846528984542d+02,
     |  -1.0815818849209d+02, 1.9141979601503d+02, 2.2665743431207d+02,
     |  -1.6117831527082d+02,-2.6100185236020d+02, 1.6652621819895d+02,
     |   2.5748872807155d+02,-1.9690950174131d+02,-2.3244285068183d+02,
     |   2.3244285068183d+02, 1.9690950174131d+02,-2.5748872807155d+02,
     |  -1.6652621819895d+02, 2.6100185236020d+02, 1.6117831527082d+02,
     |  -2.2665743431207d+02,-1.9141979601503d+02, 1.0815818849209d+02,
     |   1.6846528984542d+02, 2.4379337870743d+01,-5.5069598951870d+01,
     |  -3.6741244811397d+01,-9.3795997955854d+00,-9.6383863422939d-01,
     |  -2.8530694081217d-02,-8.6458399936378d-05,-1.9122912294126d-10/
      data (lpmn(lat,15,23), lat = 1,36)/
     |   5.9161084120366d-12, 8.1532541713631d-06, 4.6386909475475d-03,
     |   2.3222753379242d-01, 3.1841438159257d+00, 1.7854647419579d+01,
     |   4.5523420476007d+01, 3.5808409777391d+01,-7.3140991584926d+01,
     |  -1.7059141938777d+02,-2.7471125613998d+01, 2.3266238924903d+02,
     |   1.4811710025631d+02,-2.1643522858102d+02,-1.9808015758022d+02,
     |   2.0698011076180d+02, 2.1111869694507d+02,-2.0913128459904d+02,
     |  -2.0913128459904d+02, 2.1111869694507d+02, 2.0698011076180d+02,
     |  -1.9808015758022d+02,-2.1643522858102d+02, 1.4811710025631d+02,
     |   2.3266238924903d+02,-2.7471125613998d+01,-1.7059141938777d+02,
     |  -7.3140991584927d+01, 3.5808409777391d+01, 4.5523420476007d+01,
     |   1.7854647419579d+01, 3.1841438159257d+00, 2.3222753379242d-01,
     |   4.6386909475476d-03, 8.1532541713631d-06, 5.9161084120366d-12/
      data (lpmn(lat,16,23), lat = 1,36)/
     |   1.6239541281688d-13, 6.8073987709814d-07, 6.6450075049341d-04,
     |   4.8848632027652d-02, 9.2700857415215d-01, 7.1406223333855d+00,
     |   2.6614155144845d+01, 4.6239274068734d+01, 7.6173354646041d+00,
     |  -1.0789324131621d+02,-1.4774266476503d+02, 4.0293857500263d+01,
     |   2.3782290913855d+02, 8.0587700978117d+01,-2.3437838626588d+02,
     |  -1.5067811788918d+02, 2.1306890936277d+02, 1.8819109493652d+02,
     |  -1.8819109493652d+02,-2.1306890936277d+02, 1.5067811788918d+02,
     |   2.3437838626588d+02,-8.0587700978116d+01,-2.3782290913855d+02,
     |  -4.0293857500264d+01, 1.4774266476503d+02, 1.0789324131621d+02,
     |  -7.6173354646041d+00,-4.6239274068734d+01,-2.6614155144845d+01,
     |  -7.1406223333855d+00,-9.2700857415215d-01,-4.8848632027653d-02,
     |  -6.6450075049343d-04,-6.8073987709814d-07,-1.6239541281688d-13/
      data (lpmn(lat,17,23), lat = 1,36)/
     |   3.9427165347527d-15, 5.0185120097880d-08, 8.3731662685179d-05,
     |   8.9760327571453d-03, 2.3282967936599d-01, 2.4026443198830d+00,
     |   1.2264244848500d+01, 3.2989478436971d+01, 3.9094776791912d+01,
     |  -2.0920243518334d+01,-1.2471275569531d+02,-1.1460245992212d+02,
     |   8.4394644513648d+01, 2.2311355952589d+02, 3.8426514188968d+01,
     |  -2.2813154935049d+02,-1.3048056306369d+02, 1.9136776896715d+02,
     |   1.9136776896715d+02,-1.3048056306369d+02,-2.2813154935049d+02,
     |   3.8426514188968d+01, 2.2311355952589d+02, 8.4394644513647d+01,
     |  -1.1460245992212d+02,-1.2471275569531d+02,-2.0920243518335d+01,
     |   3.9094776791912d+01, 3.2989478436971d+01, 1.2264244848500d+01,
     |   2.4026443198830d+00, 2.3282967936599d-01, 8.9760327571454d-03,
     |   8.3731662685182d-05, 5.0185120097880d-08, 3.9427165347527d-15/
      data (lpmn(lat,18,23), lat = 1,36)/
     |   8.4139339875747d-17, 3.2475121333412d-09, 9.2331691712484d-06,
     |   1.4356893357560d-03, 5.0437064992130d-02, 6.8569860144925d-01,
     |   4.6255725630162d+00, 1.7279532879913d+01, 3.5436258931846d+01,
     |   2.7445147249895d+01,-4.2794773006434d+01,-1.2641620387634d+02,
     |  -8.4667089897803d+01, 1.0304057925801d+02, 2.0290578594396d+02,
     |   2.6834504990705d+01,-2.0548035164479d+02,-1.3879485162673d+02,
     |   1.3879485162673d+02, 2.0548035164479d+02,-2.6834504990704d+01,
     |  -2.0290578594396d+02,-1.0304057925801d+02, 8.4667089897804d+01,
     |   1.2641620387634d+02, 4.2794773006434d+01,-2.7445147249895d+01,
     |  -3.5436258931846d+01,-1.7279532879913d+01,-4.6255725630162d+00,
     |  -6.8569860144925d-01,-5.0437064992130d-02,-1.4356893357561d-03,
     |  -9.2331691712487d-06,-3.2475121333412d-09,-8.4139339875747d-17/
      data (lpmn(lat,19,23), lat = 1,36)/
     |   1.5617765337277d-18, 1.8257886985763d-10, 8.8240807634298d-07,
     |   1.9817769908223d-04, 9.3636898502067d-03, 1.6573172971344d-01,
     |   1.4449093118425d+00, 7.1209816956022d+00, 2.0871347832156d+01,
     |   3.4187594397662d+01, 1.5887751769734d+01,-5.4358564154080d+01,
     |  -1.1884777354580d+02,-6.6664183579018d+01, 9.8373930968387d+01,
     |   1.8401951241321d+02, 4.5298515718436d+01,-1.6279215337458d+02,
     |  -1.6279215337458d+02, 4.5298515718436d+01, 1.8401951241321d+02,
     |   9.8373930968387d+01,-6.6664183579018d+01,-1.1884777354580d+02,
     |  -5.4358564154081d+01, 1.5887751769734d+01, 3.4187594397662d+01,
     |   2.0871347832157d+01, 7.1209816956022d+00, 1.4449093118425d+00,
     |   1.6573172971344d-01, 9.3636898502067d-03, 1.9817769908223d-04,
     |   8.8240807634302d-07, 1.8257886985763d-10, 1.5617765337277d-18/
      data (lpmn(lat,20,23), lat = 1,36)/
     |   2.4783213457021d-20, 8.7671838131446d-12, 7.1882154376424d-08,
     |   2.3237953782713d-05, 1.4686633184076d-03, 3.3544989383068d-02,
     |   3.7229607055452d-01, 2.3501496995689d+00, 9.1424376710098d+00,
     |   2.2277320133636d+01, 3.0802533299453d+01, 8.3586207891944d+00,
     |  -5.4796380846032d+01,-1.0673942591265d+02,-6.3493093694811d+01,
     |   7.1787088688174d+01, 1.6167716997376d+02, 8.5639109817512d+01,
     |  -8.5639109817512d+01,-1.6167716997376d+02,-7.1787088688174d+01,
     |   6.3493093694811d+01, 1.0673942591265d+02, 5.4796380846032d+01,
     |  -8.3586207891941d+00,-3.0802533299453d+01,-2.2277320133636d+01,
     |  -9.1424376710098d+00,-2.3501496995689d+00,-3.7229607055453d-01,
     |  -3.3544989383068d-02,-1.4686633184076d-03,-2.3237953782714d-05,
     |  -7.1882154376427d-08,-8.7671838131446d-12,-2.4783213457021d-20/
      data (lpmn(lat,21,23), lat = 1,36)/
     |   3.2644769413952d-22, 3.4917524834004d-13, 4.8485989721174d-09,
     |   2.2499245012091d-06, 1.8937798459999d-04, 5.5442299693089d-03,
     |   7.7480245090306d-02, 6.1465690574985d-01, 3.0535878253674d+00,
     |   9.9731160219403d+00, 2.1385895295084d+01, 2.7025140843697d+01,
     |   6.9884099575471d+00,-4.4407424546850d+01,-9.0325867518194d+01,
     |  -7.0900357007475d+01, 2.3869431304551d+01, 1.1704582512196d+02,
     |   1.1704582512196d+02, 2.3869431304551d+01,-7.0900357007475d+01,
     |  -9.0325867518194d+01,-4.4407424546850d+01, 6.9884099575472d+00,
     |   2.7025140843697d+01, 2.1385895295084d+01, 9.9731160219403d+00,
     |   3.0535878253674d+00, 6.1465690574985d-01, 7.7480245090307d-02,
     |   5.5442299693089d-03, 1.8937798459999d-04, 2.2499245012091d-06,
     |   4.8485989721177d-09, 3.4917524834004d-13, 3.2644769413952d-22/
      data (lpmn(lat,22,23), lat = 1,36)/
     |   3.3735952896261d-24, 1.0903324738249d-14, 2.5605248871889d-10,
     |   1.7015499090160d-07, 1.9006447222472d-05, 7.0941377473432d-04,
     |   1.2381652132557d-02, 1.2181532021475d-01, 7.5492198304691d-01,
     |   3.1477658525576d+00, 9.1229646973328d+00, 1.8304474488166d+01,
     |   2.3458045106645d+01, 1.1341622542000d+01,-2.3707560506126d+01,
     |  -6.3486983351872d+01,-7.2434727290552d+01,-3.2223359790846d+01,
     |   3.2223359790846d+01, 7.2434727290552d+01, 6.3486983351872d+01,
     |   2.3707560506126d+01,-1.1341622542000d+01,-2.3458045106645d+01,
     |  -1.8304474488166d+01,-9.1229646973328d+00,-3.1477658525576d+00,
     |  -7.5492198304692d-01,-1.2181532021475d-01,-1.2381652132557d-02,
     |  -7.0941377473432d-04,-1.9006447222472d-05,-1.7015499090161d-07,
     |  -2.5605248871891d-10,-1.0903324738249d-14,-3.3735952896261d-24/
      data (lpmn(lat,23,23), lat = 1,36)/
     |   2.3740935075044d-26, 2.3171326495571d-16, 9.1917007429819d-12,
     |   8.7302319571703d-09, 1.2903331016210d-06, 6.1138988205126d-05,
     |   1.3242302864531d-03, 1.6001126914965d-02, 1.2177290995671d-01,
     |   6.3039710667320d-01, 2.3306045312559d+00, 6.3230419137751d+00,
     |   1.2660745691378d+01, 1.8187539421296d+01, 1.6497677406071d+01,
     |   2.8646270802191d+00,-1.8822201525072d+01,-3.5676253020170d+01,
     |  -3.5676253020170d+01,-1.8822201525072d+01, 2.8646270802190d+00,
     |   1.6497677406071d+01, 1.8187539421296d+01, 1.2660745691378d+01,
     |   6.3230419137751d+00, 2.3306045312559d+00, 6.3039710667320d-01,
     |   1.2177290995671d-01, 1.6001126914965d-02, 1.3242302864531d-03,
     |   6.1138988205126d-05, 1.2903331016210d-06, 8.7302319571706d-09,
     |   9.1917007429823d-12, 2.3171326495571d-16, 2.3740935075044d-26/
      data (lpmn(lat, 0,24), lat = 1,36)/
     |  -2.1803257543470d+03, 9.5788529220929d+02, 1.7912678175095d+02,
     |  -8.0371071589759d+02, 6.3769503990900d+02, 2.2232553215224d+01,
     |  -5.6083386096126d+02, 5.4833336254457d+02,-6.0176171214567d+01,
     |  -4.3635739983329d+02, 5.0818780158883d+02,-1.2224030591359d+02,
     |  -3.5242782691290d+02, 4.8822645267048d+02,-1.7691582983260d+02,
     |  -2.8690402328699d+02, 4.7969039221066d+02,-2.3025631048946d+02,
     |  -2.3025631048946d+02, 4.7969039221066d+02,-2.8690402328699d+02,
     |  -1.7691582983260d+02, 4.8822645267048d+02,-3.5242782691291d+02,
     |  -1.2224030591360d+02, 5.0818780158883d+02,-4.3635739983329d+02,
     |  -6.0176171214570d+01, 5.4833336254457d+02,-5.6083386096125d+02,
     |   2.2232553215224d+01, 6.3769503990900d+02,-8.0371071589758d+02,
     |   1.7912678175093d+02, 9.5788529220929d+02,-2.1803257543470d+03/
      data (lpmn(lat, 1,24), lat = 1,36)/
     |  -1.7006980207075d+02,-6.9434516192613d+02, 9.9524256639589d+02,
     |  -3.8379526140561d+02,-4.0221818196130d+02, 7.0000313549674d+02,
     |  -3.5044331326792d+02,-2.5941328711180d+02, 5.7612109124080d+02,
     |  -3.5414896547881d+02,-1.6642275953940d+02, 5.0415417000718d+02,
     |  -3.6933312896887d+02,-9.3920812889998d+01, 4.5533739953634d+02,
     |  -3.9114108383293d+02,-3.0436963327957d+01, 4.1919216640982d+02,
     |  -4.1919216640982d+02, 3.0436963327955d+01, 3.9114108383294d+02,
     |  -4.5533739953634d+02, 9.3920812889997d+01, 3.6933312896886d+02,
     |  -5.0415417000718d+02, 1.6642275953940d+02, 3.5414896547881d+02,
     |  -5.7612109124080d+02, 2.5941328711179d+02, 3.5044331326793d+02,
     |  -7.0000313549674d+02, 4.0221818196130d+02, 3.8379526140562d+02,
     |  -9.9524256639589d+02, 6.9434516192613d+02, 1.7006980207075d+02/
      data (lpmn(lat, 2,24), lat = 1,36)/
     |   9.6296892216703d+02,-8.7506495536977d+02, 1.7263281850648d+02,
     |   6.5175424886334d+02,-6.8635723605790d+02, 8.5804458721247d+01,
     |   5.0459244783096d+02,-5.6664393364419d+02, 1.1025194618408d+02,
     |   4.0542972300807d+02,-5.1400616708730d+02, 1.4738005899674d+02,
     |   3.3440120506181d+02,-4.8838561786125d+02, 1.8758971685480d+02,
     |   2.7831862153640d+02,-4.7755913615383d+02, 2.3058985937407d+02,
     |   2.3058985937407d+02,-4.7755913615383d+02, 2.7831862153640d+02,
     |   1.8758971685480d+02,-4.8838561786125d+02, 3.3440120506181d+02,
     |   1.4738005899675d+02,-5.1400616708730d+02, 4.0542972300807d+02,
     |   1.1025194618408d+02,-5.6664393364419d+02, 5.0459244783095d+02,
     |   8.5804458721247d+01,-6.8635723605790d+02, 6.5175424886333d+02,
     |   1.7263281850649d+02,-8.7506495536977d+02, 9.6296892216703d+02/
      data (lpmn(lat, 3,24), lat = 1,36)/
     |   4.8091283711724d+02,-1.2195176968476d+02,-6.0259031834338d+02,
     |   6.3273959665462d+02, 1.1066473290042d+02,-6.3212718311251d+02,
     |   4.6143916325173d+02, 1.3245522055518d+02,-5.4172802005754d+02,
     |   4.0662278250623d+02, 9.9570173703388d+01,-4.8111710412666d+02,
     |   3.9254618238911d+02, 5.9887053832112d+01,-4.4054080006010d+02,
     |   3.9699375950223d+02, 1.9893744302240d+01,-4.1333466092330d+02,
     |   4.1333466092330d+02,-1.9893744302238d+01,-3.9699375950223d+02,
     |   4.4054080006010d+02,-5.9887053832111d+01,-3.9254618238911d+02,
     |   4.8111710412666d+02,-9.9570173703388d+01,-4.0662278250623d+02,
     |   5.4172802005754d+02,-1.3245522055517d+02,-4.6143916325173d+02,
     |   6.3212718311251d+02,-1.1066473290042d+02,-6.3273959665463d+02,
     |   6.0259031834338d+02, 1.2195176968476d+02,-4.8091283711724d+02/
      data (lpmn(lat, 4,24), lat = 1,36)/
     |   1.2203821272076d+02, 2.6678885485657d+02,-5.1331252839824d+02,
     |  -7.8904539094889d+01, 6.5138461816489d+02,-3.6066776136619d+02,
     |  -2.9961299506040d+02, 5.7953913035172d+02,-2.4830130931516d+02,
     |  -3.0215387110628d+02, 5.1857600536946d+02,-2.1849539602247d+02,
     |  -2.7768797389086d+02, 4.8533119548797d+02,-2.1828910082669d+02,
     |  -2.5231763817409d+02, 4.7079685160804d+02,-2.3150039985527d+02,
     |  -2.3150039985528d+02, 4.7079685160804d+02,-2.5231763817408d+02,
     |  -2.1828910082669d+02, 4.8533119548797d+02,-2.7768797389087d+02,
     |  -2.1849539602247d+02, 5.1857600536946d+02,-3.0215387110628d+02,
     |  -2.4830130931516d+02, 5.7953913035172d+02,-2.9961299506040d+02,
     |  -3.6066776136619d+02, 6.5138461816489d+02,-7.8904539094884d+01,
     |  -5.1331252839825d+02, 2.6678885485657d+02, 1.2203821272076d+02/
      data (lpmn(lat, 5,24), lat = 1,36)/
     |   2.0794471550125d+01, 2.3712414353133d+02,-9.8734586933913d+01,
     |  -4.7541332751844d+02, 3.6814491777811d+02, 3.3920160094698d+02,
     |  -5.6662318386069d+02, 1.1658066400497d+02, 4.2562944370216d+02,
     |  -4.7806574016642d+02, 3.2988211674540d+01, 4.2064608663703d+02,
     |  -4.2865877532573d+02, 7.1862872304779d+00, 4.0787172158631d+02,
     |  -4.0664089871512d+02, 7.8756118121168d-01, 4.0158096540132d+02,
     |  -4.0158096540132d+02,-7.8756118121297d-01, 4.0664089871512d+02,
     |  -4.0787172158630d+02,-7.1862872304790d+00, 4.2865877532573d+02,
     |  -4.2064608663703d+02,-3.2988211674540d+01, 4.7806574016642d+02,
     |  -4.2562944370216d+02,-1.1658066400497d+02, 5.6662318386069d+02,
     |  -3.3920160094698d+02,-3.6814491777811d+02, 4.7541332751844d+02,
     |   9.8734586933916d+01,-2.3712414353133d+02,-2.0794471550125d+01/
      data (lpmn(lat, 6,24), lat = 1,36)/
     |   2.6560404369358d+00, 1.1528063505376d+02, 1.3622564650427d+02,
     |  -3.5610231484363d+02,-1.6708460919288d+02, 5.4256525003296d+02,
     |  -8.1106966167341d+01,-4.6785090431004d+02, 4.1699746651291d+02,
     |   1.0835438374353d+02,-4.8390436459368d+02, 3.1884476512304d+02,
     |   1.7666378614098d+02,-4.6861587420470d+02, 2.6460973316933d+02,
     |   2.0836386798808d+02,-4.5831235900735d+02, 2.3271243641907d+02,
     |   2.3271243641907d+02,-4.5831235900735d+02, 2.0836386798807d+02,
     |   2.6460973316933d+02,-4.6861587420470d+02, 1.7666378614099d+02,
     |   3.1884476512305d+02,-4.8390436459368d+02, 1.0835438374353d+02,
     |   4.1699746651292d+02,-4.6785090431004d+02,-8.1106966167345d+01,
     |   5.4256525003296d+02,-1.6708460919288d+02,-3.5610231484363d+02,
     |   1.3622564650427d+02, 1.1528063505376d+02, 2.6560404369358d+00/
      data (lpmn(lat, 7,24), lat = 1,36)/
     |   2.6989193272028d-01, 4.0274687547909d+01, 1.5544527620060d+02,
     |  -7.8844912042403d+01,-3.8359577389681d+02, 1.9170191145917d+02,
     |   4.2140296380343d+02,-3.9162727890526d+02,-1.7015187508900d+02,
     |   4.9285047769133d+02,-2.1252160521459d+02,-2.9999407885896d+02,
     |   4.5531158509452d+02,-1.0281950063655d+02,-3.5193299837257d+02,
     |   4.1585099104572d+02,-3.0694324448690d+01,-3.8385915729134d+02,
     |   3.8385915729134d+02, 3.0694324448691d+01,-4.1585099104572d+02,
     |   3.5193299837257d+02, 1.0281950063655d+02,-4.5531158509452d+02,
     |   2.9999407885896d+02, 2.1252160521459d+02,-4.9285047769133d+02,
     |   1.7015187508900d+02, 3.9162727890526d+02,-4.2140296380343d+02,
     |  -1.9170191145917d+02, 3.8359577389681d+02, 7.8844912042404d+01,
     |  -1.5544527620060d+02,-4.0274687547909d+01,-2.6989193272028d-01/
      data (lpmn(lat, 8,24), lat = 1,36)/
     |   2.2640822002534d-02, 1.1080292977676d+01, 9.5604760711410d+01,
     |   8.5852688740478d+01,-2.6348137252658d+02,-2.0309520282087d+02,
     |   4.1447928071934d+02, 1.2279455663235d+02,-4.7663573046177d+02,
     |   1.5725802772862d+02, 3.5650897297993d+02,-4.0994633927983d+02,
     |  -3.0208039327515d+01, 4.2196119888110d+02,-3.1786668537169d+02,
     |  -1.4625161740889d+02, 4.3834461065099d+02,-2.3374879495805d+02,
     |  -2.3374879495805d+02, 4.3834461065099d+02,-1.4625161740889d+02,
     |  -3.1786668537169d+02, 4.2196119888110d+02,-3.0208039327519d+01,
     |  -4.0994633927984d+02, 3.5650897297993d+02, 1.5725802772862d+02,
     |  -4.7663573046177d+02, 1.2279455663235d+02, 4.1447928071934d+02,
     |  -2.0309520282087d+02,-2.6348137252658d+02, 8.5852688740477d+01,
     |   9.5604760711411d+01, 1.1080292977676d+01, 2.2640822002534d-02/
      data (lpmn(lat, 9,24), lat = 1,36)/
     |   1.6075480270767d-03, 2.5138217499024d+00, 4.3052076950457d+01,
     |   1.1296117750406d+02,-5.8649778136544d+01,-3.1511094838294d+02,
     |   6.4959015307542d+01, 4.2360531853090d+02,-1.8471852722559d+02,
     |  -3.4866897113466d+02, 3.7487096710112d+02, 1.0538244447704d+02,
     |  -4.3769596657803d+02, 2.1424039935424d+02, 2.6688962307663d+02,
     |  -4.1809369002969d+02, 6.8196545562828d+01, 3.6007601153759d+02,
     |  -3.6007601153759d+02,-6.8196545562829d+01, 4.1809369002969d+02,
     |  -2.6688962307663d+02,-2.1424039935424d+02, 4.3769596657803d+02,
     |  -1.0538244447704d+02,-3.7487096710112d+02, 3.4866897113466d+02,
     |   1.8471852722559d+02,-4.2360531853090d+02,-6.4959015307545d+01,
     |   3.1511094838294d+02, 5.8649778136545d+01,-1.1296117750406d+02,
     |  -4.3052076950458d+01,-2.5138217499024d+00,-1.6075480270767d-03/
      data (lpmn(lat,10,24), lat = 1,36)/
     |   9.8317229565317d-05, 4.8349327081142d-01, 1.5539315497060d+01,
     |   7.8377663796826d+01, 6.3088683133523d+01,-1.9685245028538d+02,
     |  -2.1819035107769d+02, 2.8433311105716d+02, 2.5693323004952d+02,
     |  -3.7295401728953d+02,-1.0652349477128d+02, 4.2629713099166d+02,
     |  -1.4476042521416d+02,-3.2723799494623d+02, 3.6358823981633d+02,
     |   6.7243575965979d+01,-4.0858561868051d+02, 2.3390065287431d+02,
     |   2.3390065287431d+02,-4.0858561868051d+02, 6.7243575965976d+01,
     |   3.6358823981633d+02,-3.2723799494623d+02,-1.4476042521416d+02,
     |   4.2629713099166d+02,-1.0652349477128d+02,-3.7295401728953d+02,
     |   2.5693323004952d+02, 2.8433311105716d+02,-2.1819035107769d+02,
     |  -1.9685245028538d+02, 6.3088683133523d+01, 7.8377663796827d+01,
     |   1.5539315497060d+01, 4.8349327081142d-01, 9.8317229565317d-05/
      data (lpmn(lat,11,24), lat = 1,36)/
     |   5.2455184831752d-06, 8.0276414100646d-02, 4.6907598546236d+00,
     |   4.0100720560584d+01, 8.7163307952604d+01,-3.7291790432754d+01,
     |  -2.5821053026790d+02,-3.2538275739414d+01, 3.7210038898335d+02,
     |   1.7572016188882d+01,-3.9914107598511d+02, 1.3453255971176d+02,
     |   3.3662267530435d+02,-3.1451731308454d+02,-1.5014951487504d+02,
     |   4.0465419662614d+02,-1.1062150868940d+02,-3.3013788272176d+02,
     |   3.3013788272176d+02, 1.1062150868940d+02,-4.0465419662614d+02,
     |   1.5014951487504d+02, 3.1451731308454d+02,-3.3662267530436d+02,
     |  -1.3453255971177d+02, 3.9914107598511d+02,-1.7572016188881d+01,
     |  -3.7210038898335d+02, 3.2538275739414d+01, 2.5821053026790d+02,
     |   3.7291790432754d+01,-8.7163307952604d+01,-4.0100720560585d+01,
     |  -4.6907598546237d+00,-8.0276414100646d-02,-5.2455184831752d-06/
      data (lpmn(lat,12,24), lat = 1,36)/
     |   2.4638861531382d-07, 1.1649421760811d-02, 1.2131460856776d+00,
     |   1.6571105513126d+01, 6.3874928445451d+01, 5.3109754227847d+01,
     |  -1.4153177965947d+02,-2.1965188064324d+02, 1.5445538921828d+02,
     |   3.2190886015127d+02,-1.9182559903457d+02,-2.9686585488918d+02,
     |   2.9713739188057d+02, 1.7439793435437d+02,-3.8084933100620d+02,
     |   2.4186272650937d+01, 3.6643623355022d+02,-2.3217841421923d+02,
     |  -2.3217841421923d+02, 3.6643623355022d+02, 2.4186272650940d+01,
     |  -3.8084933100620d+02, 1.7439793435437d+02, 2.9713739188057d+02,
     |  -2.9686585488918d+02,-1.9182559903457d+02, 3.2190886015127d+02,
     |   1.5445538921828d+02,-2.1965188064324d+02,-1.4153177965947d+02,
     |   5.3109754227847d+01, 6.3874928445451d+01, 1.6571105513126d+01,
     |   1.2131460856776d+00, 1.1649421760811d-02, 2.4638861531382d-07/
      data (lpmn(lat,13,24), lat = 1,36)/
     |   1.0255225441660d-08, 1.4901730091378d-03, 2.7286729311004d-01,
     |   5.7592766780112d+00, 3.4733882861960d+01, 6.9933284026194d+01,
     |  -1.5106149179268d+01,-2.0442876928667d+02,-1.0703465891377d+02,
     |   2.7604100613172d+02, 1.8343238257274d+02,-3.1280660883668d+02,
     |  -1.3559546056005d+02, 3.5996943485884d+02, 8.4731006607117d+00,
     |  -3.6546983128935d+02, 1.5380872352191d+02, 2.9398540581253d+02,
     |  -2.9398540581253d+02,-1.5380872352191d+02, 3.6546983128935d+02,
     |  -8.4731006607109d+00,-3.5996943485884d+02, 1.3559546056005d+02,
     |   3.1280660883668d+02,-1.8343238257274d+02,-2.7604100613172d+02,
     |   1.0703465891377d+02, 2.0442876928667d+02, 1.5106149179268d+01,
     |  -6.9933284026194d+01,-3.4733882861960d+01,-5.7592766780113d+00,
     |  -2.7286729311005d-01,-1.4901730091378d-03,-1.0255225441660d-08/
      data (lpmn(lat,14,24), lat = 1,36)/
     |   3.7986501971428d-10, 1.6897875874047d-04, 5.3888825921172d-02,
     |   1.7205133666324d+00, 1.5309917323238d+01, 5.1323248121928d+01,
     |   4.9260646715243d+01,-9.1208710320878d+01,-2.0573403699961d+02,
     |   2.9348571193155d+01, 3.0953345656277d+02, 2.2816755896479d+01,
     |  -3.3946786141074d+02, 2.0344724152222d+01, 3.4486393234935d+02,
     |  -1.1802949877167d+02,-3.0950782378193d+02, 2.2723224307527d+02,
     |   2.2723224307527d+02,-3.0950782378192d+02,-1.1802949877167d+02,
     |   3.4486393234935d+02, 2.0344724152223d+01,-3.3946786141074d+02,
     |   2.2816755896476d+01, 3.0953345656277d+02, 2.9348571193156d+01,
     |  -2.0573403699961d+02,-9.1208710320879d+01, 4.9260646715243d+01,
     |   5.1323248121928d+01, 1.5309917323238d+01, 1.7205133666324d+00,
     |   5.3888825921174d-02, 1.6897875874047d-04, 3.7986501971428d-10/
      data (lpmn(lat,15,24), lat = 1,36)/
     |   1.2551582058405d-11, 1.7041774594785d-05, 9.3986643902698d-03,
     |   4.4736770608175d-01, 5.6804609365163d+00, 2.8223837189509d+01,
     |   5.7002945414289d+01, 6.4242070133106d+00,-1.4812554567766d+02,
     |  -1.5430633833941d+02, 1.4405790867079d+02, 2.7151112705828d+02,
     |  -1.0979418309058d+02,-3.0099506812871d+02, 1.3391718905353d+02,
     |   2.9153392955428d+02,-1.9156082342441d+02,-2.5165172854825d+02,
     |   2.5165172854825d+02, 1.9156082342441d+02,-2.9153392955428d+02,
     |  -1.3391718905353d+02, 3.0099506812871d+02, 1.0979418309058d+02,
     |  -2.7151112705828d+02,-1.4405790867079d+02, 1.5430633833941d+02,
     |   1.4812554567766d+02,-6.4242070133101d+00,-5.7002945414289d+01,
     |  -2.8223837189509d+01,-5.6804609365163d+00,-4.4736770608176d-01,
     |  -9.3986643902700d-03,-1.7041774594785d-05,-1.2551582058405d-11/
      data (lpmn(lat,16,24), lat = 1,36)/
     |   3.7014183739974d-13, 1.5303235517117d-06, 1.4517283507541d-03,
     |   1.0195125327794d-01, 1.8081815823290d+00, 1.2598776837969d+01,
     |   3.9880692650520d+01, 4.7145246444816d+01,-4.4300063159952d+01,
     |  -1.7151069908471d+02,-7.6471185910835d+01, 2.1390174227493d+02,
     |   1.9750723611709d+02,-1.9300388177235d+02,-2.3705807806123d+02,
     |   1.9629889428143d+02, 2.3657378635760d+02,-2.1721792681565d+02,
     |  -2.1721792681565d+02, 2.3657378635760d+02, 1.9629889428143d+02,
     |  -2.3705807806123d+02,-1.9300388177235d+02, 1.9750723611709d+02,
     |   2.1390174227493d+02,-7.6471185910835d+01,-1.7151069908471d+02,
     |  -4.4300063159952d+01, 4.7145246444815d+01, 3.9880692650520d+01,
     |   1.2598776837969d+01, 1.8081815823290d+00, 1.0195125327794d-01,
     |   1.4517283507542d-03, 1.5303235517117d-06, 3.7014183739974d-13/
      data (lpmn(lat,17,24), lat = 1,36)/
     |   9.7274323005792d-15, 1.2223728620532d-07, 1.9862621658259d-04,
     |   2.0420603252631d-02, 4.9850970775389d-01, 4.7180569644005d+00,
     |   2.1175794141703d+01, 4.5500373088042d+01, 2.4357479733701d+01,
     |  -8.7681670255341d+01,-1.6319757783461d+02, 2.3131113186191d-02,
     |   2.3915054501219d+02, 1.2199397619285d+02,-2.2932777587127d+02,
     |  -1.8021467615106d+02, 2.1506762786975d+02, 2.0336518970787d+02,
     |  -2.0336518970787d+02,-2.1506762786975d+02, 1.8021467615106d+02,
     |   2.2932777587127d+02,-1.2199397619285d+02,-2.3915054501219d+02,
     |  -2.3131113187582d-02, 1.6319757783461d+02, 8.7681670255342d+01,
     |  -2.4357479733701d+01,-4.5500373088042d+01,-2.1175794141703d+01,
     |  -4.7180569644005d+00,-4.9850970775389d-01,-2.0420603252632d-02,
     |  -1.9862621658259d-04,-1.2223728620532d-07,-9.7274323005792d-15/
      data (lpmn(lat,18,24), lat = 1,36)/
     |   2.2696133694142d-16, 8.6555276879529d-09, 2.4010930348771d-05,
     |   3.5922067456839d-03, 1.1942775342130d-01, 1.5040962993892d+00,
     |   9.1107189117923d+00, 2.8892481813811d+01, 4.3076154458161d+01,
     |  -3.6630837291221d+00,-1.1465109251168d+02,-1.3595299292649d+02,
     |   5.6704015595840d+01, 2.3421955752028d+02, 6.7793821880724d+01,
     |  -2.3212785292838d+02,-1.4936011530174d+02, 1.9954807375027d+02,
     |   1.9954807375027d+02,-1.4936011530173d+02,-2.3212785292839d+02,
     |   6.7793821880723d+01, 2.3421955752028d+02, 5.6704015595839d+01,
     |  -1.3595299292649d+02,-1.1465109251168d+02,-3.6630837291223d+00,
     |   4.3076154458161d+01, 2.8892481813811d+01, 9.1107189117924d+00,
     |   1.5040962993892d+00, 1.1942775342130d-01, 3.5922067456839d-03,
     |   2.4010930348772d-05, 8.6555276879529d-09, 2.2696133694141d-16/
      data (lpmn(lat,19,24), lat = 1,36)/
     |   4.6699331940219d-18, 5.3982338260843d-10, 2.5496321931581d-06,
     |   5.5245510775939d-04, 2.4814438583377d-02, 4.0998858219361d-01,
     |   3.2556337248925d+00, 1.4065783665318d+01, 3.3499899896601d+01,
     |   3.4320007322335d+01,-2.8468163755130d+01,-1.2425338728525d+02,
     |  -1.0526180508194d+02, 8.6470533523836d+01, 2.1606752086143d+02,
     |   4.5291215624608d+01,-2.1256120873357d+02,-1.4974799998819d+02,
     |   1.4974799998819d+02, 2.1256120873357d+02,-4.5291215624607d+01,
     |  -2.1606752086143d+02,-8.6470533523836d+01, 1.0526180508194d+02,
     |   1.2425338728525d+02, 2.8468163755130d+01,-3.4320007322335d+01,
     |  -3.3499899896602d+01,-1.4065783665318d+01,-3.2556337248925d+00,
     |  -4.0998858219361d-01,-2.4814438583377d-02,-5.5245510775940d-04,
     |  -2.5496321931582d-06,-5.3982338260843d-10,-4.6699331940219d-18/
      data (lpmn(lat,20,24), lat = 1,36)/
     |   8.3816775313835d-20, 2.9337658617652d-11, 2.3539597941592d-07,
     |   7.3592705129499d-05, 4.4382329737348d-03, 9.5205355252509d-02,
     |   9.7244599079089d-01, 5.4907403840753d+00, 1.8231533327862d+01,
     |   3.4254822912834d+01, 2.3420048674761d+01,-4.4206092220771d+01,
     |  -1.2098155033260d+02,-8.3095133630338d+01, 8.9437423109212d+01,
     |   1.9527578992737d+02, 5.6021513222994d+01,-1.7034790752749d+02,
     |  -1.7034790752749d+02, 5.6021513222994d+01, 1.9527578992737d+02,
     |   8.9437423109212d+01,-8.3095133630338d+01,-1.2098155033260d+02,
     |  -4.4206092220772d+01, 2.3420048674761d+01, 3.4254822912834d+01,
     |   1.8231533327863d+01, 5.4907403840753d+00, 9.7244599079090d-01,
     |   9.5205355252509d-02, 4.4382329737348d-03, 7.3592705129501d-05,
     |   2.3539597941593d-07, 2.9337658617652d-11, 8.3816775313835d-20/
      data (lpmn(lat,21,24), lat = 1,36)/
     |   1.2893386449788d-21, 1.3653395175939d-12, 1.8576392111906d-08,
     |   8.3534130740712d-06, 6.7307868915052d-04, 1.8598540910832d-02,
     |   2.4112419814853d-01, 1.7349285735781d+00, 7.5650235181700d+00,
     |   2.0504069791088d+01, 3.2060772625389d+01, 1.4876556534626d+01,
     |  -4.8397211178825d+01,-1.1009045257208d+02,-7.5010086053485d+01,
     |   6.7207268536054d+01, 1.7005962758688d+02, 9.2268946035950d+01,
     |  -9.2268946035950d+01,-1.7005962758688d+02,-6.7207268536055d+01,
     |   7.5010086053485d+01, 1.1009045257208d+02, 4.8397211178824d+01,
     |  -1.4876556534626d+01,-3.2060772625389d+01,-2.0504069791088d+01,
     |  -7.5650235181701d+00,-1.7349285735781d+00,-2.4112419814854d-01,
     |  -1.8598540910832d-02,-6.7307868915052d-04,-8.3534130740714d-06,
     |  -1.8576392111907d-08,-1.3653395175939d-12,-1.2893386449788d-21/
      data (lpmn(lat,22,24), lat = 1,36)/
     |   1.6500318589135d-23, 5.2823587240388d-14, 1.2168091178467d-09,
     |   7.8500665079746d-07, 8.4171948719432d-05, 2.9776192545447d-03,
     |   4.8520714370663d-02, 4.3744264545497d-01, 2.4231318658623d+00,
     |   8.7050694130420d+00, 2.0397190648973d+01, 2.8545727172847d+01,
     |   1.1709361994031d+01,-4.0670056630565d+01,-9.3118999807881d+01,
     |  -7.8265453916799d+01, 2.1249445904714d+01, 1.2285032128201d+02,
     |   1.2285032128201d+02, 2.1249445904715d+01,-7.8265453916799d+01,
     |  -9.3118999807881d+01,-4.0670056630565d+01, 1.1709361994031d+01,
     |   2.8545727172847d+01, 2.0397190648973d+01, 8.7050694130420d+00,
     |   2.4231318658623d+00, 4.3744264545497d-01, 4.8520714370663d-02,
     |   2.9776192545447d-03, 8.4171948719432d-05, 7.8500665079748d-07,
     |   1.2168091178468d-09, 5.2823587240388d-14, 1.6500318589135d-23/
      data (lpmn(lat,23,24), lat = 1,36)/
     |   1.6599965238367d-25, 1.6055855012021d-15, 6.2536007589441d-11,
     |   5.7755166122165d-08, 8.2138979668160d-06, 3.7017097284938d-04,
     |   7.5248336393331d-03, 8.3989641228641d-02, 5.7876683175701d-01,
     |   2.6414745689021d+00, 8.2789276720833d+00, 1.7826851259994d+01,
     |   2.4601654574248d+01, 1.4208790848245d+01,-2.1606522967390d+01,
     |  -6.5111952044995d+01,-7.6880225874238d+01,-3.4669391218042d+01,
     |   3.4669391218042d+01, 7.6880225874238d+01, 6.5111952044996d+01,
     |   2.1606522967390d+01,-1.4208790848245d+01,-2.4601654574248d+01,
     |  -1.7826851259994d+01,-8.2789276720833d+00,-2.6414745689021d+00,
     |  -5.7876683175702d-01,-8.3989641228641d-02,-7.5248336393332d-03,
     |  -3.7017097284938d-04,-8.2138979668160d-06,-5.7755166122167d-08,
     |  -6.2536007589444d-11,-1.6055855012021d-15,-1.6599965238367d-25/
      data (lpmn(lat,24,24), lat = 1,36)/
     |   1.1392606957987d-27, 3.3274109747792d-17, 2.1888480265929d-12,
     |   2.8886196886011d-09, 5.4340260088393d-07, 3.1073042123296d-05,
     |   7.8333801440995d-04, 1.0727958402208d-02, 9.0649073793570d-02,
     |   5.1247935569951d-01, 2.0408912400769d+00, 5.8961046165738d+00,
     |   1.2453082834353d+01, 1.8747033843206d+01, 1.7870193639557d+01,
     |   4.0597571840148d+00,-1.9107266438168d+01,-3.7502463802149d+01,
     |  -3.7502463802149d+01,-1.9107266438168d+01, 4.0597571840147d+00,
     |   1.7870193639557d+01, 1.8747033843206d+01, 1.2453082834353d+01,
     |   5.8961046165739d+00, 2.0408912400769d+00, 5.1247935569951d-01,
     |   9.0649073793570d-02, 1.0727958402208d-02, 7.8333801440996d-04,
     |   3.1073042123296d-05, 5.4340260088393d-07, 2.8886196886012d-09,
     |   2.1888480265930d-12, 3.3274109747792d-17, 1.1392606957987d-27/
      data (lpmn(lat, 0,25), lat = 1,36)/
     |  -2.3426793576727d+03, 1.1584025005118d+03,-4.8588721039853d+01,
     |  -7.1984315370877d+02, 8.1974454212325d+02,-3.3098008295597d+02,
     |  -3.1768744575814d+02, 6.5257918868074d+02,-4.7206432598885d+02,
     |  -4.2198862215162d+01, 4.8527279545342d+02,-5.3411649239658d+02,
     |   1.7565488403268d+02, 3.0064321172605d+02,-5.2992011983936d+02,
     |   3.4561604137323d+02, 1.0193371895210d+02,-4.6536639706125d+02,
     |   4.6536639706124d+02,-1.0193371895210d+02,-3.4561604137324d+02,
     |   5.2992011983936d+02,-3.0064321172605d+02,-1.7565488403267d+02,
     |   5.3411649239658d+02,-4.8527279545342d+02, 4.2198862215161d+01,
     |   4.7206432598885d+02,-6.5257918868074d+02, 3.1768744575814d+02,
     |   3.3098008295597d+02,-8.1974454212325d+02, 7.1984315370876d+02,
     |   4.8588721039867d+01,-1.1584025005118d+03, 2.3426793576727d+03/
      data (lpmn(lat, 1,25), lat = 1,36)/
     |  -2.9816523135454d+02,-6.1382281614206d+02, 1.0753250739007d+03,
     |  -6.4670388184723d+02,-1.3324161677890d+02, 6.7076615343846d+02,
     |  -6.3881995606604d+02, 1.4164734944202d+02, 4.0725369853849d+02,
     |  -6.0179684468634d+02, 3.2827248588818d+02, 1.7620114764787d+02,
     |  -5.1924686001036d+02, 4.4979047835954d+02,-3.7137254222832d+01,
     |  -3.9298196473369d+02, 5.1039511639735d+02,-2.2950188406988d+02,
     |  -2.2950188406988d+02, 5.1039511639735d+02,-3.9298196473369d+02,
     |  -3.7137254222833d+01, 4.4979047835954d+02,-5.1924686001036d+02,
     |   1.7620114764786d+02, 3.2827248588818d+02,-6.0179684468635d+02,
     |   4.0725369853849d+02, 1.4164734944202d+02,-6.3881995606605d+02,
     |   6.7076615343846d+02,-1.3324161677890d+02,-6.4670388184724d+02,
     |   1.0753250739007d+03,-6.1382281614206d+02,-2.9816523135454d+02/
      data (lpmn(lat, 2,25), lat = 1,36)/
     |   1.0206651916811d+03,-9.9835507685431d+02, 3.8453987484989d+02,
     |   5.1910771939547d+02,-8.1097704517005d+02, 4.2095185818713d+02,
     |   2.3387801030638d+02,-6.2841031421980d+02, 5.0098186365502d+02,
     |  -1.1712525173674d+00,-4.6162412970336d+02, 5.3907415139925d+02,
     |  -1.9566191989358d+02,-2.8437737754490d+02, 5.2623120494460d+02,
     |  -3.5072590004945d+02,-9.6197267914870d+01, 4.6242670438232d+02,
     |  -4.6242670438232d+02, 9.6197267914869d+01, 3.5072590004945d+02,
     |  -5.2623120494460d+02, 2.8437737754490d+02, 1.9566191989358d+02,
     |  -5.3907415139925d+02, 4.6162412970336d+02, 1.1712525173692d+00,
     |  -5.0098186365503d+02, 6.2841031421980d+02,-2.3387801030638d+02,
     |  -4.2095185818713d+02, 8.1097704517005d+02,-5.1910771939546d+02,
     |  -3.8453987484990d+02, 9.9835507685431d+02,-1.0206651916811d+03/
      data (lpmn(lat, 3,25), lat = 1,36)/
     |   5.4351109783552d+02,-2.2368642362675d+02,-5.6392475772915d+02,
     |   7.9470501137341d+02,-1.6938007810467d+02,-5.1099910296149d+02,
     |   6.6962530286077d+02,-2.6370960196411d+02,-3.1275952207371d+02,
     |   5.8978920704352d+02,-3.7797882673048d+02,-1.2014129347720d+02,
     |   4.9679680773816d+02,-4.6306586448567d+02, 6.2677468521029d+01,
     |   3.7694592921607d+02,-5.0753771351468d+02, 2.3052804753361d+02,
     |   2.3052804753362d+02,-5.0753771351468d+02, 3.7694592921607d+02,
     |   6.2677468521031d+01,-4.6306586448567d+02, 4.9679680773817d+02,
     |  -1.2014129347719d+02,-3.7797882673048d+02, 5.8978920704352d+02,
     |  -3.1275952207371d+02,-2.6370960196412d+02, 6.6962530286077d+02,
     |  -5.1099910296149d+02,-1.6938007810467d+02, 7.9470501137341d+02,
     |  -5.6392475772915d+02,-2.2368642362675d+02, 5.4351109783552d+02/
      data (lpmn(lat, 4,25), lat = 1,36)/
     |   1.4467547287035d+02, 2.6008620493998d+02,-6.1811412590425d+02,
     |   1.0723667004150d+02, 6.1831522106733d+02,-6.0579865372084d+02,
     |   2.0276299746823d+01, 5.2020265696239d+02,-5.6179923635035d+02,
     |   1.2690433166159d+02, 3.8236185364016d+02,-5.4532383244201d+02,
     |   2.5250713446454d+02, 2.3450869739873d+02,-5.1325791022326d+02,
     |   3.6512491208546d+02, 7.9126040193296d+01,-4.5358449541665d+02,
     |   4.5358449541665d+02,-7.9126040193295d+01,-3.6512491208546d+02,
     |   5.1325791022325d+02,-2.3450869739873d+02,-2.5250713446454d+02,
     |   5.4532383244201d+02,-3.8236185364016d+02,-1.2690433166159d+02,
     |   5.6179923635035d+02,-5.2020265696239d+02,-2.0276299746830d+01,
     |   6.0579865372084d+02,-6.1831522106733d+02,-1.0723667004151d+02,
     |   6.1811412590425d+02,-2.6008620493998d+02,-1.4467547287035d+02/
      data (lpmn(lat, 5,25), lat = 1,36)/
     |   2.5775710127518d+01, 2.6873325672421d+02,-1.9097841381858d+02,
     |  -4.5707103831366d+02, 5.6051675255848d+02, 1.0706049762021d+02,
     |  -6.0389916480148d+02, 4.5449853237428d+02, 1.0808898174147d+02,
     |  -5.2986770348960d+02, 4.5653338831579d+02, 8.1383849718586d+00,
     |  -4.4288517209730d+02, 4.8277935101748d+02,-1.1211338259865d+02,
     |  -3.4397588289897d+02, 5.0104931485847d+02,-2.3240755702757d+02,
     |  -2.3240755702757d+02, 5.0104931485847d+02,-3.4397588289897d+02,
     |  -1.1211338259865d+02, 4.8277935101748d+02,-4.4288517209730d+02,
     |   8.1383849718524d+00, 4.5653338831579d+02,-5.2986770348960d+02,
     |   1.0808898174147d+02, 4.5449853237428d+02,-6.0389916480148d+02,
     |   1.0706049762021d+02, 5.6051675255848d+02,-4.5707103831365d+02,
     |  -1.9097841381858d+02, 2.6873325672421d+02, 2.5775710127518d+01/
      data (lpmn(lat, 6,25), lat = 1,36)/
     |   3.4399700170983d+00, 1.4066425963199d+02, 1.1300185715734d+02,
     |  -4.5013975872667d+02,-7.5764580543110d+00, 5.8563242396707d+02,
     |  -3.7300948686436d+02,-2.5198702187015d+02, 5.7141322274380d+02,
     |  -3.0880135508993d+02,-2.2916483372713d+02, 5.2710285431995d+02,
     |  -3.3475740218100d+02,-1.4897376499362d+02, 4.8547091636665d+02,
     |  -3.8592043899466d+02,-5.1183461802825d+01, 4.3877270106926d+02,
     |  -4.3877270106926d+02, 5.1183461802824d+01, 3.8592043899466d+02,
     |  -4.8547091636665d+02, 1.4897376499362d+02, 3.3475740218100d+02,
     |  -5.2710285431995d+02, 2.2916483372713d+02, 3.0880135508993d+02,
     |  -5.7141322274380d+02, 2.5198702187014d+02, 3.7300948686437d+02,
     |  -5.8563242396707d+02, 7.5764580543110d+00, 4.5013975872667d+02,
     |  -1.1300185715734d+02,-1.4066425963199d+02,-3.4399700170983d+00/
      data (lpmn(lat, 7,25), lat = 1,36)/
     |   3.6530395352867d-01, 5.2111407348192d+01, 1.7268841719773d+02,
     |  -1.6462575142461d+02,-3.7942947538829d+02, 3.9284461221059d+02,
     |   2.5932609997783d+02,-5.5761655607041d+02, 1.8883542734671d+02,
     |   3.6389134051322d+02,-5.1480732784576d+02, 1.5067232604459d+02,
     |   3.4267861063214d+02,-4.9471410253605d+02, 1.8116439491846d+02,
     |   2.9262256307286d+02,-4.8939866090036d+02, 2.3478523349183d+02,
     |   2.3478523349183d+02,-4.8939866090036d+02, 2.9262256307285d+02,
     |   1.8116439491846d+02,-4.9471410253605d+02, 3.4267861063214d+02,
     |   1.5067232604460d+02,-5.1480732784576d+02, 3.6389134051322d+02,
     |   1.8883542734672d+02,-5.5761655607040d+02, 2.5932609997782d+02,
     |   3.9284461221059d+02,-3.7942947538829d+02,-1.6462575142461d+02,
     |   1.7268841719773d+02, 5.2111407348192d+01, 3.6530395352867d-01/
      data (lpmn(lat, 8,25), lat = 1,36)/
     |   3.2048071301917d-02, 1.5124718011151d+01, 1.1816433609406d+02,
     |   5.5823745983298d+01,-3.5127317480046d+02,-6.9870993122850d+01,
     |   5.1623099873584d+02,-1.6470560224565d+02,-4.0480382788808d+02,
     |   4.6695108251196d+02,-3.0108028558725d+00,-4.4511834608622d+02,
     |   4.1787885574768d+02, 2.8365583346763d+01,-4.3448538336213d+02,
     |   4.0799260284171d+02, 1.3308721156255d+01,-4.1788769856220d+02,
     |   4.1788769856220d+02,-1.3308721156254d+01,-4.0799260284172d+02,
     |   4.3448538336213d+02,-2.8365583346762d+01,-4.1787885574768d+02,
     |   4.4511834608622d+02, 3.0108028558725d+00,-4.6695108251196d+02,
     |   4.0480382788808d+02, 1.6470560224565d+02,-5.1623099873584d+02,
     |   6.9870993122850d+01, 3.5127317480046d+02,-5.5823745983297d+01,
     |  -1.1816433609406d+02,-1.5124718011151d+01,-3.2048071301917d-02/
      data (lpmn(lat, 9,25), lat = 1,36)/
     |   2.3821909524158d-03, 3.6133822423236d+00, 5.7404730076141d+01,
     |   1.2182457709245d+02,-1.3860428441002d+02,-3.2496150435199d+02,
     |   2.6291894924727d+02, 3.4188903878802d+02,-4.3921783833851d+02,
     |  -6.2075333114063d+01, 4.7404754617865d+02,-3.2158531645938d+02,
     |  -1.8407831486454d+02, 4.7733488285747d+02,-2.6104675266465d+02,
     |  -2.2165391162361d+02, 4.7034577336549d+02,-2.3710316963934d+02,
     |  -2.3710316963934d+02, 4.7034577336549d+02,-2.2165391162361d+02,
     |  -2.6104675266465d+02, 4.7733488285747d+02,-1.8407831486454d+02,
     |  -3.2158531645939d+02, 4.7404754617865d+02,-6.2075333114062d+01,
     |  -4.3921783833851d+02, 3.4188903878802d+02, 2.6291894924727d+02,
     |  -3.2496150435199d+02,-1.3860428441002d+02, 1.2182457709245d+02,
     |   5.7404730076142d+01, 3.6133822423236d+00, 2.3821909524158d-03/
      data (lpmn(lat,10,25), lat = 1,36)/
     |   1.5273738332153d-04, 7.3164545001154d-01, 2.2122761057892d+01,
     |   9.7635956710092d+01, 3.1237783958984d+01,-2.8144138887551d+02,
     |  -1.1377641331315d+02, 4.3191016848691d+02, 1.5155073588900d+01,
     |  -4.5561611606011d+02, 2.6340007683310d+02, 2.6327773978966d+02,
     |  -4.6005262231874d+02, 1.1765750512697d+02, 3.5099726439807d+02,
     |  -4.2369677606978d+02, 3.2822152147757d+01, 3.9080312690999d+02,
     |  -3.9080312690999d+02,-3.2822152147758d+01, 4.2369677606978d+02,
     |  -3.5099726439807d+02,-1.1765750512697d+02, 4.6005262231874d+02,
     |  -2.6327773978966d+02,-2.6340007683310d+02, 4.5561611606011d+02,
     |  -1.5155073588898d+01,-4.3191016848691d+02, 1.1377641331315d+02,
     |   2.8144138887551d+02,-3.1237783958984d+01,-9.7635956710093d+01,
     |  -2.2122761057893d+01,-7.3164545001154d-01,-1.5273738332153d-04/
      data (lpmn(lat,11,25), lat = 1,36)/
     |   8.5576601074579d-06, 1.2797636791068d-01, 7.1014205421138d+00,
     |   5.4932404255456d+01, 9.1576842526081d+01,-1.1101549382318d+02,
     |  -2.8420438548924d+02, 1.5117681188126d+02, 3.7703782651384d+02,
     |  -2.7560653099852d+02,-2.6176124233541d+02, 4.2912610481680d+02,
     |  -2.5562499493960d+01,-4.0504900322037d+02, 3.3617301787787d+02,
     |   1.3138062881919d+02,-4.4106277426915d+02, 2.3856652506451d+02,
     |   2.3856652506451d+02,-4.4106277426915d+02, 1.3138062881919d+02,
     |   3.3617301787787d+02,-4.0504900322037d+02,-2.5562499493957d+01,
     |   4.2912610481681d+02,-2.6176124233541d+02,-2.7560653099852d+02,
     |   3.7703782651384d+02, 1.5117681188126d+02,-2.8420438548924d+02,
     |  -1.1101549382318d+02, 9.1576842526081d+01, 5.4932404255457d+01,
     |   7.1014205421139d+00, 1.2797636791068d-01, 8.5576601074579d-06/
      data (lpmn(lat,12,25), lat = 1,36)/
     |   4.2301067806993d-07, 1.9592562752058d-02, 1.9506458306274d+00,
     |   2.4570016683035d+01, 8.0481525679308d+01, 2.3132096413801d+01,
     |  -2.2456020088275d+02,-1.4935513245251d+02, 3.3364729433306d+02,
     |   1.6444145899273d+02,-4.0930852377396d+02, 1.0284566113561d+01,
     |   4.0737942738484d+02,-2.6208695690039d+02,-2.2882728111382d+02,
     |   4.2281968313937d+02,-8.4412288278664d+01,-3.5739292658163d+02,
     |   3.5739292658163d+02, 8.4412288278665d+01,-4.2281968313937d+02,
     |   2.2882728111382d+02, 2.6208695690039d+02,-4.0737942738484d+02,
     |  -1.0284566113565d+01, 4.0930852377396d+02,-1.6444145899273d+02,
     |  -3.3364729433306d+02, 1.4935513245250d+02, 2.2456020088275d+02,
     |  -2.3132096413801d+01,-8.0481525679307d+01,-2.4570016683035d+01,
     |  -1.9506458306275d+00,-1.9592562752058d-02,-4.2301067806993d-07/
      data (lpmn(lat,13,25), lat = 1,36)/
     |   1.8575821619703d-08, 2.6495101191529d-03, 4.6619685111310d-01,
     |   9.1859670430739d+00, 4.9093971262256d+01, 7.3044798424582d+01,
     |  -8.1188502972454d+01,-2.4876684577685d+02, 4.8195324788531d+01,
     |   3.6718957009033d+02,-8.3771337255762d+01,-3.7111609657709d+02,
     |   2.3636999895884d+02, 2.5878756229885d+02,-3.8265464175634d+02,
     |  -2.5684368117081d+01, 3.9839819880003d+02,-2.3808949467745d+02,
     |  -2.3808949467745d+02, 3.9839819880003d+02,-2.5684368117077d+01,
     |  -3.8265464175634d+02, 2.5878756229885d+02, 2.3636999895884d+02,
     |  -3.7111609657709d+02,-8.3771337255762d+01, 3.6718957009033d+02,
     |   4.8195324788533d+01,-2.4876684577685d+02,-8.1188502972455d+01,
     |   7.3044798424582d+01, 4.9093971262255d+01, 9.1859670430741d+00,
     |   4.6619685111311d-01, 2.6495101191529d-03, 1.8575821619703d-08/
      data (lpmn(lat,14,25), lat = 1,36)/
     |   7.2819959871473d-10, 3.1848921408665d-04, 9.7991810857375d-02,
     |   2.9463959828923d+00, 2.3776946246979d+01, 6.6258367121768d+01,
     |   2.4445911670437d+01,-1.7219974112212d+02,-1.7619314544442d+02,
     |   2.1817114453790d+02, 2.6947469741955d+02,-2.6683724002237d+02,
     |  -2.2308363285972d+02, 3.5499934608021d+02, 7.2030896479038d+01,
     |  -3.9333825204417d+02, 1.3702881233770d+02, 3.1756892576913d+02,
     |  -3.1756892576913d+02,-1.3702881233770d+02, 3.9333825204417d+02,
     |  -7.2030896479037d+01,-3.5499934608021d+02, 2.2308363285972d+02,
     |   2.6683724002237d+02,-2.6947469741955d+02,-2.1817114453790d+02,
     |   1.7619314544442d+02, 1.7219974112213d+02,-2.4445911670436d+01,
     |  -6.6258367121768d+01,-2.3776946246979d+01,-2.9463959828924d+00,
     |  -9.7991810857378d-02,-3.1848921408665d-04,-7.2819959871473d-10/
      data (lpmn(lat,15,25), lat = 1,36)/
     |   2.5561381655351d-11, 3.4169689243359d-05, 1.8240190385862d-02,
     |   8.2306568536165d-01, 9.6193440587933d+00, 4.1672614590894d+01,
     |   6.1394761137197d+01,-4.9319638756038d+01,-2.1063511310636d+02,
     |  -4.5973596435590d+01, 3.0470103876751d+02, 1.0746784711164d+02,
     |  -3.4466978631436d+02,-4.7735923099948d+01, 3.7039208505900d+02,
     |  -8.5233644136207d+01,-3.3941125900238d+02, 2.3420948206526d+02,
     |   2.3420948206527d+02,-3.3941125900238d+02,-8.5233644136210d+01,
     |   3.7039208505900d+02,-4.7735923099947d+01,-3.4466978631436d+02,
     |   1.0746784711164d+02, 3.0470103876751d+02,-4.5973596435590d+01,
     |  -2.1063511310636d+02,-4.9319638756038d+01, 6.1394761137197d+01,
     |   4.1672614590894d+01, 9.6193440587933d+00, 8.2306568536166d-01,
     |   1.8240190385863d-02, 3.4169689243359d-05, 2.5561381655351d-11/
      data (lpmn(lat,16,25), lat = 1,36)/
     |   8.0455414661002d-13, 3.2788342814943d-06, 3.0187342124533d-03,
     |   2.0201672419224d-01, 3.3324715298606d+00, 2.0781091308207d+01,
     |   5.4009620979787d+01, 3.0548184071518d+01,-1.1952630561540d+02,
     |  -1.8715419068982d+02, 8.7513952064207d+01, 3.0234563528339d+02,
     |  -4.9921158651800d+01,-3.3280334439127d+02, 9.5089028199298d+01,
     |   3.2395556494854d+02,-1.8397000236088d+02,-2.7134344485707d+02,
     |   2.7134344485707d+02, 1.8397000236088d+02,-3.2395556494854d+02,
     |  -9.5089028199299d+01, 3.3280334439127d+02, 4.9921158651798d+01,
     |  -3.0234563528339d+02,-8.7513952064207d+01, 1.8715419068982d+02,
     |   1.1952630561540d+02,-3.0548184071517d+01,-5.4009620979787d+01,
     |  -2.0781091308207d+01,-3.3324715298606d+00,-2.0201672419224d-01,
     |  -3.0187342124534d-03,-3.2788342814943d-06,-8.0455414661001d-13/
      data (lpmn(lat,17,25), lat = 1,36)/
     |   2.2701092123920d-14, 2.8147441002220d-07, 4.4489569158436d-04,
     |   4.3768869121659d-02, 1.0016110009107d+00, 8.6267966521736d+00,
     |   3.3403434579945d+01, 5.2975468542982d+01,-1.7019147886480d+01,
     |  -1.6255680970244d+02,-1.2032358359620d+02, 1.8458205379051d+02,
     |   2.4150473878259d+02,-1.6176491517364d+02,-2.7385029498781d+02,
     |   1.8184659986256d+02, 2.6240255477119d+02,-2.2494365779437d+02,
     |  -2.2494365779437d+02, 2.6240255477119d+02, 1.8184659986256d+02,
     |  -2.7385029498781d+02,-1.6176491517364d+02, 2.4150473878259d+02,
     |   1.8458205379051d+02,-1.2032358359620d+02,-1.6255680970244d+02,
     |  -1.7019147886480d+01, 5.2975468542982d+01, 3.3403434579945d+01,
     |   8.6267966521736d+00, 1.0016110009107d+00, 4.3768869121660d-02,
     |   4.4489569158438d-04, 2.8147441002220d-07, 2.2701092123919d-14/
      data (lpmn(lat,18,25), lat = 1,36)/
     |   5.7299631168355d-16, 2.1580453613419d-08, 5.8344954657687d-05,
     |   8.3818297589564d-03, 2.6282749922960d-01, 3.0478071659064d+00,
     |   1.6369558663031d+01, 4.2545206457719d+01, 3.7056160155750d+01,
     |  -6.5372563133350d+01,-1.7092966239650d+02,-4.0452510939060d+01,
     |   2.3259438584372d+02, 1.6281450711036d+02,-2.1941085844341d+02,
     |  -2.0999228018283d+02, 2.1559551508552d+02, 2.1893936557384d+02,
     |  -2.1893936557384d+02,-2.1559551508552d+02, 2.0999228018283d+02,
     |   2.1941085844341d+02,-1.6281450711036d+02,-2.3259438584372d+02,
     |   4.0452510939058d+01, 1.7092966239650d+02, 6.5372563133350d+01,
     |  -3.7056160155751d+01,-4.2545206457719d+01,-1.6369558663031d+01,
     |  -3.0478071659064d+00,-2.6282749922960d-01,-8.3818297589566d-03,
     |  -5.8344954657689d-05,-2.1580453613419d-08,-5.7299631168354d-16/
      data (lpmn(lat,19,25), lat = 1,36)/
     |   1.2882986003800d-17, 1.4718324280454d-09, 6.7864023208968d-06,
     |   1.4161703908160d-03, 6.0291989604285d-02, 9.2528170125332d-01,
     |   6.6307644726590d+00, 2.4604507387555d+01, 4.4517485223048d+01,
     |   1.1660725080002d+01,-1.0115292347372d+02,-1.5277616545550d+02,
     |   2.6731896738955d+01, 2.4081268852783d+02, 9.8205068846282d+01,
     |  -2.3386081459429d+02,-1.6887186867706d+02, 2.0752443384285d+02,
     |   2.0752443384285d+02,-1.6887186867706d+02,-2.3386081459429d+02,
     |   9.8205068846281d+01, 2.4081268852783d+02, 2.6731896738954d+01,
     |  -1.5277616545550d+02,-1.0115292347372d+02, 1.1660725080002d+01,
     |   4.4517485223048d+01, 2.4604507387555d+01, 6.6307644726590d+00,
     |   9.2528170125332d-01, 6.0291989604285d-02, 1.4161703908161d-03,
     |   6.7864023208971d-06, 1.4718324280454d-09, 1.2882986003800d-17/
      data (lpmn(lat,20,25), lat = 1,36)/
     |   2.5617883156051d-19, 8.8681641020815d-11, 6.9566428349491d-07,
     |   2.0998261225107d-04, 1.2052431553995d-02, 2.4179251073335d-01,
     |   2.2566539518685d+00, 1.1240333086604d+01, 3.0814305157979d+01,
     |   3.9157502543425d+01,-1.4455188909390d+01,-1.1899981089549d+02,
     |  -1.2384473528602d+02, 6.7623240502358d+01, 2.2717160564382d+02,
     |   6.4796302971774d+01,-2.1889805246363d+02,-1.6100292512472d+02,
     |   1.6100292512472d+02, 2.1889805246363d+02,-6.4796302971772d+01,
     |  -2.2717160564382d+02,-6.7623240502358d+01, 1.2384473528602d+02,
     |   1.1899981089549d+02, 1.4455188909390d+01,-3.9157502543425d+01,
     |  -3.0814305157979d+01,-1.1240333086604d+01,-2.2566539518686d+00,
     |  -2.4179251073335d-01,-1.2052431553995d-02,-2.0998261225107d-04,
     |  -6.9566428349494d-07,-8.8681641020815d-11,-2.5617883156050d-19/
      data (lpmn(lat,21,25), lat = 1,36)/
     |   4.4549109197863d-21, 4.6684379348908d-12, 6.2179466810186d-08,
     |   2.7054837441796d-05, 2.0819264059914d-03, 5.4099540798135d-02,
     |   6.4686624768761d-01, 4.1784327750146d+00, 1.5668487480482d+01,
     |   3.3434303936881d+01, 2.9696009386861d+01,-3.3599652655509d+01,
     |  -1.2102323245405d+02,-9.8902725990388d+01, 7.8983184049230d+01,
     |   2.0579351802899d+02, 6.7335285717912d+01,-1.7782295478183d+02,
     |  -1.7782295478183d+02, 6.7335285717912d+01, 2.0579351802899d+02,
     |   7.8983184049230d+01,-9.8902725990388d+01,-1.2102323245405d+02,
     |  -3.3599652655510d+01, 2.9696009386861d+01, 3.3434303936881d+01,
     |   1.5668487480482d+01, 4.1784327750146d+00, 6.4686624768762d-01,
     |   5.4099540798135d-02, 2.0819264059914d-03, 2.7054837441797d-05,
     |   6.2179466810189d-08, 4.6684379348908d-12, 4.4549109197863d-21/
      data (lpmn(lat,22,25), lat = 1,36)/
     |   6.6547624806984d-23, 2.1094183381934d-13, 4.7622500950160d-09,
     |   2.9784452136680d-06, 3.0590821662789d-04, 1.0223375832105d-02,
     |   1.5476611143480d-01, 1.2683901847447d+00, 6.1915629756390d+00,
     |   1.8614262129872d+01, 3.2597231073530d+01, 2.0782448361119d+01,
     |  -4.1426427868751d+01,-1.1228756925358d+02,-8.6445172948587d+01,
     |   6.1846721516274d+01, 1.7825079309791d+02, 9.9088578875159d+01,
     |  -9.9088578875158d+01,-1.7825079309791d+02,-6.1846721516275d+01,
     |   8.6445172948587d+01, 1.1228756925358d+02, 4.1426427868751d+01,
     |  -2.0782448361119d+01,-3.2597231073530d+01,-1.8614262129873d+01,
     |  -6.1915629756390d+00,-1.2683901847447d+00,-1.5476611143480d-01,
     |  -1.0223375832105d-02,-3.0590821662789d-04,-2.9784452136681d-06,
     |  -4.7622500950162d-09,-2.1094183381934d-13,-6.6547624806984d-23/
      data (lpmn(lat,23,25), lat = 1,36)/
     |   8.2868747221858d-25, 7.9400659382985d-15, 3.0340573132662d-10,
     |   2.7211145014588d-07, 3.7164889504740d-05, 1.5884199321235d-03,
     |   3.0174765389418d-02, 3.0906911557292d-01, 1.9079630301121d+00,
     |   7.5324699747410d+00, 1.9245734642902d+01, 2.9612820038477d+01,
     |   1.6192376770193d+01,-3.6533251530296d+01,-9.5377623576950d+01,
     |  -8.5665912206564d+01, 1.8322658664031d+01, 1.2865310004530d+02,
     |   1.2865310004530d+02, 1.8322658664032d+01,-8.5665912206564d+01,
     |  -9.5377623576950d+01,-3.6533251530296d+01, 1.6192376770194d+01,
     |   2.9612820038477d+01, 1.9245734642902d+01, 7.5324699747410d+00,
     |   1.9079630301121d+00, 3.0906911557292d-01, 3.0174765389419d-02,
     |   1.5884199321235d-03, 3.7164889504740d-05, 2.7211145014589d-07,
     |   3.0340573132663d-10, 7.9400659382985d-15, 8.2868747221858d-25/
      data (lpmn(lat,24,25), lat = 1,36)/
     |   8.1268599743268d-27, 2.3523704624672d-16, 1.5195730037672d-11,
     |   1.9503617312982d-08, 3.5314906529955d-06, 1.9214987687082d-04,
     |   4.5489800602176d-03, 5.7596465681695d-02, 4.4123730273865d-01,
     |   2.2035860684572d+00, 7.4649120363793d+00, 1.7231439880438d+01,
     |   2.5520455600276d+01, 1.6998525639093d+01,-1.9311161390009d+01,
     |  -6.6529684502075d+01,-8.1345301669321d+01,-3.7186961324960d+01,
     |   3.7186961324959d+01, 8.1345301669321d+01, 6.6529684502075d+01,
     |   1.9311161390009d+01,-1.6998525639093d+01,-2.5520455600276d+01,
     |  -1.7231439880438d+01,-7.4649120363793d+00,-2.2035860684572d+00,
     |  -4.4123730273865d-01,-5.7596465681695d-02,-4.5489800602176d-03,
     |  -1.9214987687082d-04,-3.5314906529955d-06,-1.9503617312982d-08,
     |  -1.5195730037673d-11,-2.3523704624672d-16,-8.1268599743268d-27/
      data (lpmn(lat,25,25), lat = 1,36)/
     |   5.4457998536897d-29, 4.7596419950629d-18, 5.1921308166362d-13,
     |   9.5205500836368d-10, 2.2795234167237d-07, 1.5730601789088d-05,
     |   4.6155351996035d-04, 7.1640483501125d-03, 6.7209967148719d-02,
     |   4.1492632134930d-01, 1.7797749372305d+00, 5.4743799808972d+00,
     |   1.2192937648731d+01, 1.9223921606782d+01, 1.9216017244738d+01,
     |   5.3110550975753d+00,-1.9338021958591d+01,-3.9337491169684d+01,
     |  -3.9337491169684d+01,-1.9338021958592d+01, 5.3110550975751d+00,
     |   1.9216017244738d+01, 1.9223921606782d+01, 1.2192937648731d+01,
     |   5.4743799808972d+00, 1.7797749372305d+00, 4.1492632134930d-01,
     |   6.7209967148719d-02, 7.1640483501126d-03, 4.6155351996036d-04,
     |   1.5730601789088d-05, 2.2795234167237d-07, 9.5205500836371d-10,
     |   5.1921308166365d-13, 4.7596419950629d-18, 5.4457998536897d-29/
      data (lpmn(lat, 0,26), lat = 1,36)/
     |  -2.5034167151485d+03, 1.3595416975116d+03,-3.1202641427353d+02,
     |  -5.4226753242499d+02, 8.8944866460377d+02,-6.6003431497277d+02,
     |   7.7553219130633d+01, 4.7652137765456d+02,-6.8122522386400d+02,
     |   4.4897751379088d+02, 4.3390473402008d+01,-4.7674010770169d+02,
     |   5.8750852535295d+02,-3.2276898817520d+02,-1.3713781815690d+02,
     |   4.9723169923501d+02,-5.3251270160004d+02, 2.2556622429253d+02,
     |   2.2556622429253d+02,-5.3251270160004d+02, 4.9723169923501d+02,
     |  -1.3713781815689d+02,-3.2276898817520d+02, 5.8750852535295d+02,
     |  -4.7674010770169d+02, 4.3390473402008d+01, 4.4897751379088d+02,
     |  -6.8122522386400d+02, 4.7652137765456d+02, 7.7553219130641d+01,
     |  -6.6003431497277d+02, 8.8944866460377d+02,-5.4226753242499d+02,
     |  -3.1202641427354d+02, 1.3595416975116d+03,-2.5034167151485d+03/
      data (lpmn(lat, 1,26), lat = 1,36)/
     |  -4.4207288722559d+02,-4.9976960867978d+02, 1.1039889980536d+03,
     |  -8.8443222521609d+02, 2.0510985361874d+02, 4.6665200566245d+02,
     |  -7.5451707444811d+02, 5.4664183013565d+02,-2.5307985860785d+01,
     |  -4.6433882819203d+02, 6.2675263610005d+02,-3.8539521600866d+02,
     |  -8.6014270650448d+01, 4.8196496213095d+02,-5.5700067148037d+02,
     |   2.7388390012542d+02, 1.7961411106448d+02,-5.1218944632666d+02,
     |   5.1218944632666d+02,-1.7961411106448d+02,-2.7388390012543d+02,
     |   5.5700067148037d+02,-4.8196496213094d+02, 8.6014270650454d+01,
     |   3.8539521600867d+02,-6.2675263610005d+02, 4.6433882819203d+02,
     |   2.5307985860788d+01,-5.4664183013565d+02, 7.5451707444811d+02,
     |  -4.6665200566245d+02,-2.0510985361874d+02, 8.8443222521609d+02,
     |  -1.1039889980536d+03, 4.9976960867978d+02, 4.4207288722559d+02/
      data (lpmn(lat, 2,26), lat = 1,36)/
     |   1.0744629274920d+03,-1.1145514979404d+03, 6.1548353015423d+02,
     |   3.0696128354914d+02,-8.1973298811473d+02, 7.0970859022345d+02,
     |  -1.6432796616196d+02,-4.1663564297490d+02, 6.7161292752555d+02,
     |  -4.7681571790285d+02,-6.9519861167886d+00, 4.5514813122558d+02,
     |  -5.8745269437002d+02, 3.3608740785354d+02, 1.2325999235453d+02,
     |  -4.9039551726802d+02, 5.3196136921589d+02,-2.2628187685858d+02,
     |  -2.2628187685858d+02, 5.3196136921589d+02,-4.9039551726802d+02,
     |   1.2325999235453d+02, 3.3608740785354d+02,-5.8745269437002d+02,
     |   4.5514813122558d+02,-6.9519861167886d+00,-4.7681571790285d+02,
     |   6.7161292752555d+02,-4.1663564297490d+02,-1.6432796616197d+02,
     |   7.0970859022345d+02,-8.1973298811473d+02, 3.0696128354913d+02,
     |   6.1548353015424d+02,-1.1145514979404d+03, 1.0744629274920d+03/
      data (lpmn(lat, 3,26), lat = 1,36)/
     |   6.1037187584458d+02,-3.4195576624224d+02,-4.8130302658430d+02,
     |   9.0859865421903d+02,-4.7440696262814d+02,-2.4319519365902d+02,
     |   6.8853920231497d+02,-6.1200532776328d+02, 1.3411644184424d+02,
     |   3.9051426715803d+02,-6.1794435621806d+02, 4.2381650746290d+02,
     |   3.9065627510571d+01,-4.5595389459068d+02, 5.5743540211969d+02,
     |  -2.8774077211799d+02,-1.6749699214474d+02, 5.0629873759211d+02,
     |  -5.0629873759211d+02, 1.6749699214473d+02, 2.8774077211799d+02,
     |  -5.5743540211969d+02, 4.5595389459068d+02,-3.9065627510576d+01,
     |  -4.2381650746291d+02, 6.1794435621806d+02,-3.9051426715803d+02,
     |  -1.3411644184425d+02, 6.1200532776329d+02,-6.8853920231496d+02,
     |   2.4319519365902d+02, 4.7440696262814d+02,-9.0859865421904d+02,
     |   4.8130302658429d+02, 3.4195576624224d+02,-6.1037187584458d+02/
      data (lpmn(lat, 4,26), lat = 1,36)/
     |   1.7021729607836d+02, 2.4162142349920d+02,-7.1192494180146d+02,
     |   3.2755754089519d+02, 4.8121274594942d+02,-7.5547154720766d+02,
     |   3.9301826878567d+02, 2.2173777979141d+02,-6.1626474394366d+02,
     |   5.4386612085902d+02,-9.9764671335576d+01,-3.8525645076972d+02,
     |   5.8167452402505d+02,-3.7336761285729d+02,-8.1753844763766d+01,
     |   4.6922066003838d+02,-5.2990908823902d+02, 2.2834712701842d+02,
     |   2.2834712701842d+02,-5.2990908823902d+02, 4.6922066003838d+02,
     |  -8.1753844763765d+01,-3.7336761285729d+02, 5.8167452402505d+02,
     |  -3.8525645076971d+02,-9.9764671335576d+01, 5.4386612085902d+02,
     |  -6.1626474394366d+02, 2.2173777979140d+02, 3.9301826878568d+02,
     |  -7.5547154720766d+02, 4.8121274594942d+02, 3.2755754089520d+02,
     |  -7.1192494180147d+02, 2.4162142349920d+02, 1.7021729607836d+02/
      data (lpmn(lat, 5,26), lat = 1,36)/
     |   3.1660481461621d+01, 2.9945057337912d+02,-2.9958389162606d+02,
     |  -3.8757906265116d+02, 7.1477806162966d+02,-1.9784207352823d+02,
     |  -4.5547573004478d+02, 6.6162809247399d+02,-3.2790003807163d+02,
     |  -2.2702258171243d+02, 5.7562735050595d+02,-4.8617044874313d+02,
     |   5.3065160990914d+01, 3.9954233014917d+02,-5.5422682569422d+02,
     |   3.1383543744645d+02, 1.4343260131855d+02,-4.9446509634376d+02,
     |   4.9446509634376d+02,-1.4343260131855d+02,-3.1383543744645d+02,
     |   5.5422682569422d+02,-3.9954233014917d+02,-5.3065160990908d+01,
     |   4.8617044874313d+02,-5.7562735050595d+02, 2.2702258171243d+02,
     |   3.2790003807164d+02,-6.6162809247399d+02, 4.5547573004477d+02,
     |   1.9784207352823d+02,-7.1477806162966d+02, 3.8757906265116d+02,
     |   2.9958389162606d+02,-2.9945057337912d+02,-3.1660481461621d+01/
      data (lpmn(lat, 6,26), lat = 1,36)/
     |   4.4074297782116d+00, 1.6915566300901d+02, 7.3584896951700d+01,
     |  -5.2960805675926d+02, 1.9847650175840d+02, 5.1352985794931d+02,
     |  -6.1223223541587d+02, 1.1197797645332d+02, 4.4714393660723d+02,
     |  -5.9569760826802d+02, 2.6167502535946d+02, 2.5534454914453d+02,
     |  -5.5370068165479d+02, 4.2585462968141d+02, 1.3512357139453d+01,
     |  -4.3184272580310d+02, 5.2516126350586d+02,-2.3151256104983d+02,
     |  -2.3151256104983d+02, 5.2516126350586d+02,-4.3184272580310d+02,
     |   1.3512357139451d+01, 4.2585462968141d+02,-5.5370068165479d+02,
     |   2.5534454914453d+02, 2.6167502535946d+02,-5.9569760826802d+02,
     |   4.4714393660723d+02, 1.1197797645333d+02,-6.1223223541588d+02,
     |   5.1352985794931d+02, 1.9847650175840d+02,-5.2960805675926d+02,
     |   7.3584896951698d+01, 1.6915566300901d+02, 4.4074297782115d+00/
      data (lpmn(lat, 7,26), lat = 1,36)/
     |   4.8824446971891d-01, 6.6419665262323d+01, 1.8457184407444d+02,
     |  -2.6623918838291d+02,-3.1850617053009d+02, 5.6929200229153d+02,
     |  -1.6362398185085d+01,-5.3526684130561d+02, 5.2149959458952d+02,
     |  -3.1718693938650d+01,-4.5661012306839d+02, 5.3960130177497d+02,
     |  -1.8235449092666d+02,-3.0581507720403d+02, 5.3931300049686d+02,
     |  -3.4867671606976d+02,-1.0785483022249d+02, 4.7658821826996d+02,
     |  -4.7658821826995d+02, 1.0785483022249d+02, 3.4867671606976d+02,
     |  -5.3931300049686d+02, 3.0581507720403d+02, 1.8235449092666d+02,
     |  -5.3960130177497d+02, 4.5661012306839d+02, 3.1718693938652d+01,
     |  -5.2149959458952d+02, 5.3526684130560d+02, 1.6362398185091d+01,
     |  -5.6929200229153d+02, 3.1850617053009d+02, 2.6623918838292d+02,
     |  -1.8457184407444d+02,-6.6419665262323d+01,-4.8824446971891d-01/
      data (lpmn(lat, 8,26), lat = 1,36)/
     |   4.4706875931310d-02, 2.0309902327388d+01, 1.4231872239517d+02,
     |   6.6051554223629d+00,-4.2200461128644d+02, 1.2141792106610d+02,
     |   5.0209744860457d+02,-4.5599008664986d+02,-1.1131023733939d+02,
     |   5.3804652945299d+02,-4.3186965958238d+02,-5.9453650092045d+01,
     |   4.7858784795467d+02,-4.7691623262477d+02, 7.8257972790548d+01,
     |   3.7564407891937d+02,-5.1573476805704d+02, 2.3534768321374d+02,
     |   2.3534768321374d+02,-5.1573476805704d+02, 3.7564407891936d+02,
     |   7.8257972790549d+01,-4.7691623262477d+02, 4.7858784795468d+02,
     |  -5.9453650092039d+01,-4.3186965958238d+02, 5.3804652945299d+02,
     |  -1.1131023733939d+02,-4.5599008664986d+02, 5.0209744860457d+02,
     |   1.2141792106610d+02,-4.2200461128644d+02, 6.6051554223617d+00,
     |   1.4231872239518d+02, 2.0309902327388d+01, 4.4706875931309d-02/
      data (lpmn(lat, 9,26), lat = 1,36)/
     |   3.4715388273535d-03, 5.1004473976308d+00, 7.4750504237907d+01,
     |   1.2165033415364d+02,-2.3422662470775d+02,-2.7406070853702d+02,
     |   4.5392433547036d+02, 1.1389667806996d+02,-5.3811795960721d+02,
     |   3.2648951974360d+02, 2.2296955136257d+02,-5.3078533335118d+02,
     |   3.2620067746587d+02, 1.6973679305915d+02,-5.0121093324358d+02,
     |   3.8645142464883d+02, 6.1657414316246d+01,-4.5252871835136d+02,
     |   4.5252871835136d+02,-6.1657414316244d+01,-3.8645142464883d+02,
     |   5.0121093324357d+02,-1.6973679305914d+02,-3.2620067746587d+02,
     |   5.3078533335118d+02,-2.2296955136257d+02,-3.2648951974361d+02,
     |   5.3811795960721d+02,-1.1389667806995d+02,-4.5392433547037d+02,
     |   2.7406070853702d+02, 2.3422662470775d+02,-1.2165033415364d+02,
     |  -7.4750504237908d+01,-5.1004473976308d+00,-3.4715388273535d-03/
      data (lpmn(lat,10,26), lat = 1,36)/
     |   2.3279557836789d-04, 1.0849531345233d+00, 3.0745455916763d+01,
     |   1.1657736860311d+02,-2.1981494064953d+01,-3.4850666979898d+02,
     |   6.0301708243435d+01, 4.7428514960232d+02,-2.9629939495876d+02,
     |  -2.8010127233968d+02, 5.1435860267930d+02,-1.7953059326635d+02,
     |  -3.3120394346462d+02, 5.0061102428713d+02,-1.8549117948828d+02,
     |  -2.9813054862215d+02, 4.9889618117576d+02,-2.3921679034175d+02,
     |  -2.3921679034175d+02, 4.9889618117576d+02,-2.9813054862214d+02,
     |  -1.8549117948828d+02, 5.0061102428713d+02,-3.3120394346462d+02,
     |  -1.7953059326636d+02, 5.1435860267930d+02,-2.8010127233967d+02,
     |  -2.9629939495876d+02, 4.7428514960232d+02, 6.0301708243439d+01,
     |  -3.4850666979898d+02,-2.1981494064954d+01, 1.1657736860311d+02,
     |   3.0745455916763d+01, 1.0849531345233d+00, 2.3279557836789d-04/
      data (lpmn(lat,11,26), lat = 1,36)/
     |   1.3661761697169d-05, 1.9944189383924d-01, 1.0479020558317d+01,
     |   7.2629888834773d+01, 8.4184898639225d+01,-2.0131404787662d+02,
     |  -2.4789586081175d+02, 3.5150605115902d+02, 2.1524719637470d+02,
     |  -4.8302856392353d+02, 1.0292182085780d+02, 3.9900437393392d+02,
     |  -4.3866117902987d+02, 4.0198658368396d+00, 4.2684494657949d+02,
     |  -4.1852486905707d+02,-6.5050917434406d+00, 4.2212362428505d+02,
     |  -4.2212362428505d+02, 6.5050917434392d+00, 4.1852486905707d+02,
     |  -4.2684494657949d+02,-4.0198658368404d+00, 4.3866117902987d+02,
     |  -3.9900437393392d+02,-1.0292182085780d+02, 4.8302856392353d+02,
     |  -2.1524719637470d+02,-3.5150605115902d+02, 2.4789586081174d+02,
     |   2.0131404787662d+02,-8.4184898639225d+01,-7.2629888834773d+01,
     |  -1.0479020558317d+01,-1.9944189383924d-01,-1.3661761697169d-05/
      data (lpmn(lat,12,26), lat = 1,36)/
     |   7.0860249992787d-07, 3.2122770114600d-02, 3.0503476017879d+00,
     |   3.5201885608750d+01, 9.5095822890713d+01,-2.9948756835608d+01,
     |  -2.9268930174471d+02, 1.7937236286514d+00, 4.3317253537490d+02,
     |  -1.3100968400045d+02,-3.8916392940752d+02, 3.8279783244737d+02,
     |   1.0549987430476d+02,-4.6375160816182d+02, 2.9209608076225d+02,
     |   1.9842804000398d+02,-4.7127566250822d+02, 2.4224070401153d+02,
     |   2.4224070401153d+02,-4.7127566250822d+02, 1.9842804000398d+02,
     |   2.9209608076225d+02,-4.6375160816182d+02, 1.0549987430476d+02,
     |   3.8279783244737d+02,-3.8916392940752d+02,-1.3100968400045d+02,
     |   4.3317253537490d+02, 1.7937236286523d+00,-2.9268930174471d+02,
     |  -2.9948756835609d+01, 9.5095822890712d+01, 3.5201885608751d+01,
     |   3.0503476017880d+00, 3.2122770114600d-02, 7.0860249992787d-07/
      data (lpmn(lat,13,26), lat = 1,36)/
     |   3.2721744504341d-08, 4.5775849626938d-03, 7.7243601395411d-01,
     |   1.4141665883497d+01, 6.5971524166862d+01, 6.2609218180785d+01,
     |  -1.6637178139145d+02,-2.3337940886074d+02, 2.4974138509132d+02,
     |   2.9229595829390d+02,-3.7039312445065d+02,-1.2310029324544d+02,
     |   4.5127541473270d+02,-1.9015791980207d+02,-3.0586303972861d+02,
     |   4.3320766025288d+02,-5.4722817341900d+01,-3.8521146116283d+02,
     |   3.8521146116283d+02, 5.4722817341901d+01,-4.3320766025288d+02,
     |   3.0586303972861d+02, 1.9015791980207d+02,-4.5127541473270d+02,
     |   1.2310029324544d+02, 3.7039312445065d+02,-2.9229595829390d+02,
     |  -2.4974138509132d+02, 2.3337940886074d+02, 1.6637178139145d+02,
     |  -6.2609218180785d+01,-6.5971524166862d+01,-1.4141665883497d+01,
     |  -7.7243601395413d-01,-4.5775849626938d-03,-3.2721744504340d-08/
      data (lpmn(lat,14,26), lat = 1,36)/
     |   1.3523980013772d-09, 5.8113930553237d-04, 1.7220815978009d-01,
     |   4.8582173751842d+00, 3.5217044269297d+01, 7.8193941451336d+01,
     |  -2.4866002323845d+01,-2.4507864510738d+02,-5.7695527929605d+01,
     |   3.7146314288567d+02, 3.7168482353719d+01,-4.1695757159727d+02,
     |   1.5464465268580d+02, 3.3674761794107d+02,-3.7146988315080d+02,
     |  -7.9602955083059d+01, 4.2913680626101d+02,-2.4323789254074d+02,
     |  -2.4323789254074d+02, 4.2913680626101d+02,-7.9602955083055d+01,
     |  -3.7146988315080d+02, 3.3674761794107d+02, 1.5464465268580d+02,
     |  -4.1695757159727d+02, 3.7168482353719d+01, 3.7146314288567d+02,
     |  -5.7695527929604d+01,-2.4507864510739d+02,-2.4866002323845d+01,
     |   7.8193941451336d+01, 3.5217044269297d+01, 4.8582173751843d+00,
     |   1.7220815978009d-01, 5.8113930553237d-04, 1.3523980013772d-09/
      data (lpmn(lat,15,26), lat = 1,36)/
     |   5.0207451536337d-11, 6.6036289572244d-05, 3.4067922810500d-02,
     |   1.4528491863625d+00, 1.5522800269289d+01, 5.7431666688747d+01,
     |   5.1731101705364d+01,-1.2839940173930d+02,-2.2274192023744d+02,
     |   1.4119599908753d+02, 3.3438805638143d+02,-1.9815842225863d+02,
     |  -3.0281085189001d+02, 3.3345906402221d+02, 1.3878110480113d+02,
     |  -4.1640639526966d+02, 1.1734375658645d+02, 3.4167268978554d+02,
     |  -3.4167268978554d+02,-1.1734375658646d+02, 4.1640639526966d+02,
     |  -1.3878110480113d+02,-3.3345906402221d+02, 3.0281085189001d+02,
     |   1.9815842225864d+02,-3.3438805638143d+02,-1.4119599908753d+02,
     |   2.2274192023744d+02, 1.2839940173930d+02,-5.1731101705364d+01,
     |  -5.7431666688747d+01,-1.5522800269289d+01,-1.4528491863626d+00,
     |  -3.4067922810501d-02,-6.6036289572244d-05,-5.0207451536337d-11/
      data (lpmn(lat,16,26), lat = 1,36)/
     |   1.6777653055533d-12, 6.7357323281638d-06, 6.0103472773843d-03,
     |   3.8227648290647d-01, 5.8345877246123d+00, 3.2150459179344d+01,
     |   6.5129196256240d+01,-1.1222849682783d+01,-1.9821241359799d+02,
     |  -1.1457285368155d+02, 2.7793040596483d+02, 1.8888554414052d+02,
     |  -3.3189079867746d+02,-1.1898436650702d+02, 3.8786020583159d+02,
     |  -4.8123829048952d+01,-3.6894283883387d+02, 2.4063224220608d+02,
     |   2.4063224220609d+02,-3.6894283883387d+02,-4.8123829048955d+01,
     |   3.8786020583159d+02,-1.1898436650702d+02,-3.3189079867745d+02,
     |   1.8888554414052d+02, 2.7793040596483d+02,-1.1457285368155d+02,
     |  -1.9821241359799d+02,-1.1222849682784d+01, 6.5129196256240d+01,
     |   3.2150459179344d+01, 5.8345877246123d+00, 3.8227648290648d-01,
     |   6.0103472773845d-03, 6.7357323281638d-06, 1.6777653055533d-12/
      data (lpmn(lat,17,26), lat = 1,36)/
     |   5.0497000952628d-14, 6.1745333673983d-07, 9.4813626340048d-04,
     |   8.9054953531341d-02, 1.9022763630713d+00, 1.4777563787779d+01,
     |   4.8124027998155d+01, 4.7503716184653d+01,-8.6772574310419d+01,
     |  -2.0598219289168d+02, 2.6356331022165d+01, 3.1799511147845d+02,
     |   1.5580385626495d+01,-3.5526952829192d+02, 5.0848720885473d+01,
     |   3.5427399141737d+02,-1.7414913693165d+02,-2.9149673846608d+02,
     |   2.9149673846608d+02, 1.7414913693165d+02,-3.5427399141737d+02,
     |  -5.0848720885474d+01, 3.5526952829192d+02,-1.5580385626497d+01,
     |  -3.1799511147845d+02,-2.6356331022165d+01, 2.0598219289168d+02,
     |   8.6772574310420d+01,-4.7503716184653d+01,-4.8124027998156d+01,
     |  -1.4777563787779d+01,-1.9022763630713d+00,-8.9054953531342d-02,
     |  -9.4813626340051d-04,-6.1745333673983d-07,-5.0497000952628d-14/
      data (lpmn(lat,18,26), lat = 1,36)/
     |   1.3676870628643d-15, 5.0843905560158d-08, 1.3381813287653d-04,
     |   1.8422533891281d-02, 5.4289447321314d-01, 5.7574364230493d+00,
     |   2.6994622798624d+01, 5.4394502595322d+01, 6.9838828437510d+00,
     |  -1.4583840692776d+02,-1.5700550935155d+02, 1.4670975340658d+02,
     |   2.7849722194244d+02,-1.2363823906884d+02,-3.0767044180046d+02,
     |   1.6372850472122d+02, 2.8846967889190d+02,-2.3230014872398d+02,
     |  -2.3230014872398d+02, 2.8846967889190d+02, 1.6372850472122d+02,
     |  -3.0767044180046d+02,-1.2363823906884d+02, 2.7849722194244d+02,
     |   1.4670975340658d+02,-1.5700550935155d+02,-1.4583840692776d+02,
     |   6.9838828437509d+00, 5.4394502595321d+01, 2.6994622798625d+01,
     |   5.7574364230493d+00, 5.4289447321314d-01, 1.8422533891281d-02,
     |   1.3381813287654d-04, 5.0843905560158d-08, 1.3676870628643d-15/
      data (lpmn(lat,19,26), lat = 1,36)/
     |   3.3248295487308d-17, 3.7523455215460d-09, 1.6872647771824d-05,
     |   3.3846871587027d-03, 1.3616225065695d-01, 1.9304229607632d+00,
     |   1.2349470362010d+01, 3.8266003431112d+01, 4.5814662723707d+01,
     |  -4.2613564641146d+01,-1.7143691113179d+02,-7.9437204189005d+01,
     |   2.1862517120751d+02, 2.0201773001656d+02,-2.0475212128028d+02,
     |  -2.3969841404672d+02, 2.1463155583873d+02, 2.3489964862071d+02,
     |  -2.3489964862071d+02,-2.1463155583873d+02, 2.3969841404672d+02,
     |   2.0475212128028d+02,-2.0201773001655d+02,-2.1862517120751d+02,
     |   7.9437204189004d+01, 1.7143691113179d+02, 4.2613564641146d+01,
     |  -4.5814662723707d+01,-3.8266003431112d+01,-1.2349470362010d+01,
     |  -1.9304229607632d+00,-1.3616225065695d-01,-3.3846871587028d-03,
     |  -1.6872647771824d-05,-3.7523455215460d-09,-3.3248295487308d-17/
      data (lpmn(lat,20,26), lat = 1,36)/
     |   7.2207028631373d-19, 2.4709809392833d-10, 1.8932313362574d-06,
     |   5.5081883876189d-04, 3.0007700100024d-02, 5.6046169373854d-01,
     |   4.7404642272778d+00, 2.0468390403018d+01, 4.3964356316310d+01,
     |   2.4633892619239d+01,-8.5240739010501d+01,-1.6484271817611d+02,
     |  -4.5735251592925d+00, 2.4281539594509d+02, 1.2921005099203d+02,
     |  -2.3328423206241d+02,-1.8894098330312d+02, 2.1528992163054d+02,
     |   2.1528992163054d+02,-1.8894098330312d+02,-2.3328423206241d+02,
     |   1.2921005099203d+02, 2.4281539594509d+02,-4.5735251592938d+00,
     |  -1.6484271817611d+02,-8.5240739010501d+01, 2.4633892619239d+01,
     |   4.3964356316311d+01, 2.0468390403018d+01, 4.7404642272778d+00,
     |   5.6046169373854d-01, 3.0007700100024d-02, 5.5081883876190d-04,
     |   1.8932313362575d-06, 2.4709809392833d-10, 7.2207028631373d-19/
      data (lpmn(lat,21,26), lat = 1,36)/
     |   1.3904944230731d-20, 1.4413696839413d-11, 1.8776259062731d-07,
     |   7.8928584547371d-05, 5.7864714892959d-03, 1.4085315565699d-01,
     |   1.5431272192604d+00, 8.8394458002421d+00, 2.7712861662825d+01,
     |   4.2148402660080d+01,-1.2320621790419d+00,-1.1110677621188d+02,
     |  -1.4007767361871d+02, 4.6893007144427d+01, 2.3608227614813d+02,
     |   8.5208952116366d+01,-2.2446176775245d+02,-1.7255141545422d+02,
     |   1.7255141545422d+02, 2.2446176775245d+02,-8.5208952116364d+01,
     |  -2.3608227614813d+02,-4.6893007144427d+01, 1.4007767361871d+02,
     |   1.1110677621188d+02, 1.2320621790419d+00,-4.2148402660080d+01,
     |  -2.7712861662825d+01,-8.8394458002421d+00,-1.5431272192605d+00,
     |  -1.4085315565699d-01,-5.7864714892959d-03,-7.8928584547373d-05,
     |  -1.8776259062732d-07,-1.4413696839413d-11,-1.3904944230731d-20/
      data (lpmn(lat,22,26), lat = 1,36)/
     |   2.3470344594135d-22, 7.3632383487237d-13, 1.6277997062743d-08,
     |   9.8556665928462d-06, 9.6746367956143d-04, 3.0440966360149d-02,
     |   4.2579780083485d-01, 3.1428280250530d+00, 1.3276614641053d+01,
     |   3.1944956251953d+01, 3.4708336384262d+01,-2.2864730669622d+01,
     |  -1.1910874462474d+02,-1.1386654387101d+02, 6.7136201946579d+01,
     |   2.1550275524966d+02, 7.9209570421892d+01,-1.8521224193669d+02,
     |  -1.8521224193669d+02, 7.9209570421892d+01, 2.1550275524966d+02,
     |   6.7136201946580d+01,-1.1386654387101d+02,-1.1910874462474d+02,
     |  -2.2864730669623d+01, 3.4708336384262d+01, 3.1944956251953d+01,
     |   1.3276614641053d+01, 3.1428280250530d+00, 4.2579780083486d-01,
     |   3.0440966360149d-02, 9.6746367956143d-04, 9.8556665928465d-06,
     |   1.6277997062744d-08, 7.3632383487237d-13, 2.3470344594135d-22/
      data (lpmn(lat,23,26), lat = 1,36)/
     |   3.4099778865318d-24, 3.2353819452821d-14, 1.2119288381090d-09,
     |   1.0541090138712d-06, 1.3798120273377d-04, 5.5758750437100d-03,
     |   9.8528183400915d-02, 9.1923075921113d-01, 5.0181561004979d+00,
     |   1.6697181073575d+01, 3.2517054081969d+01, 2.6015778252780d+01,
     |  -3.4048610325572d+01,-1.1335162692550d+02,-9.7699369745291d+01,
     |   5.5736270051538d+01, 1.8623057381751d+02, 1.0609405995417d+02,
     |  -1.0609405995417d+02,-1.8623057381751d+02,-5.5736270051539d+01,
     |   9.7699369745290d+01, 1.1335162692550d+02, 3.4048610325572d+01,
     |  -2.6015778252779d+01,-3.2517054081969d+01,-1.6697181073575d+01,
     |  -5.0181561004979d+00,-9.1923075921114d-01,-9.8528183400916d-02,
     |  -5.5758750437100d-03,-1.3798120273377d-04,-1.0541090138712d-06,
     |  -1.2119288381091d-09,-3.2353819452821d-14,-3.4099778865318d-24/
      data (lpmn(lat,24,26), lat = 1,36)/
     |   4.1375261972567d-26, 1.1864923908178d-15, 7.5206480456742d-11,
     |   9.3762024047813d-08, 1.6310597778059d-05, 8.4213515520685d-04,
     |   1.8646849454991d-02, 2.1693023275025d-01, 1.4917866887962d+00,
     |   6.4671234058161d+00, 1.7987769167993d+01, 3.0263763067483d+01,
     |   2.0391747555045d+01,-3.2062268338512d+01,-9.7099423009845d+01,
     |  -9.3069594733467d+01, 1.5095462309046d+01, 1.3445123262369d+02,
     |   1.3445123262369d+02, 1.5095462309046d+01,-9.3069594733467d+01,
     |  -9.7099423009845d+01,-3.2062268338512d+01, 2.0391747555045d+01,
     |   3.0263763067484d+01, 1.7987769167993d+01, 6.4671234058161d+00,
     |   1.4917866887962d+00, 2.1693023275025d-01, 1.8646849454992d-02,
     |   8.4213515520685d-04, 1.6310597778059d-05, 9.3762024047816d-08,
     |   7.5206480456746d-11, 1.1864923908178d-15, 4.1375261972567d-26/
      data (lpmn(lat,25,26), lat = 1,36)/
     |   3.9602004696940d-28, 3.4304699981480d-17, 3.6752088372362d-12,
     |   6.5553811447018d-09, 1.5111574167273d-06, 9.9265553341552d-05,
     |   2.7366567712752d-03, 3.9301530345639d-02, 3.3466920332659d-01,
     |   1.8284328719935d+00, 6.6918732138408d+00, 1.6543915534481d+01,
     |   2.6224294603180d+01, 1.9690426316111d+01,-1.6841973017011d+01,
     |  -6.7738910854036d+01,-8.5823235007026d+01,-3.9774897506761d+01,
     |   3.9774897506761d+01, 8.5823235007027d+01, 6.7738910854037d+01,
     |   1.6841973017011d+01,-1.9690426316111d+01,-2.6224294603180d+01,
     |  -1.6543915534481d+01,-6.6918732138408d+00,-1.8284328719935d+00,
     |  -3.3466920332659d-01,-3.9301530345639d-02,-2.7366567712752d-03,
     |  -9.9265553341552d-05,-1.5111574167273d-06,-6.5553811447020d-09,
     |  -3.6752088372364d-12,-3.4304699981480d-17,-3.9602004696940d-28/
      data (lpmn(lat,26,26), lat = 1,36)/
     |   2.5938535552911d-30, 6.7840101098133d-19, 1.2272081196008d-13,
     |   3.1266082560120d-10, 9.5280071094591d-08, 7.9348164496356d-06,
     |   2.7096743043416d-04, 4.7666281922239d-03, 4.9647810131617d-02,
     |   3.3468753870603d-01, 1.5461458754279d+00, 5.0627849795770d+00,
     |   1.1888393105594d+01, 1.9620449548514d+01, 2.0529974241388d+01,
     |   6.6140801792580d+00,-1.9514608067202d+01,-4.1180586316553d+01,
     |  -4.1180586316553d+01,-1.9514608067202d+01, 6.6140801792578d+00,
     |   2.0529974241388d+01, 1.9620449548514d+01, 1.1888393105594d+01,
     |   5.0627849795770d+00, 1.5461458754279d+00, 3.3468753870603d-01,
     |   4.9647810131618d-02, 4.7666281922239d-03, 2.7096743043416d-04,
     |   7.9348164496356d-06, 9.5280071094591d-08, 3.1266082560121d-10,
     |   1.2272081196009d-13, 6.7840101098133d-19, 2.5938535552911d-30/
      data (lpmn(lat, 0,27), lat = 1,36)/
     |  -2.6611658073815d+03, 1.5553649441123d+03,-5.9950076614484d+02,
     |  -2.7646881529051d+02, 8.1616660683935d+02,-8.7580886298104d+02,
     |   5.1035391749959d+02, 5.5111531510048d+01,-5.3253335089362d+02,
     |   7.0228412997907d+02,-5.0753428206436d+02, 6.9608941623055d+01,
     |   3.7989498370774d+02,-6.1566977373615d+02, 5.2754077905983d+02,
     |  -1.7022490213557d+02,-2.6823975129580d+02, 5.6245238483556d+02,
     |  -5.6245238483556d+02, 2.6823975129580d+02, 1.7022490213558d+02,
     |  -5.2754077905983d+02, 6.1566977373615d+02,-3.7989498370775d+02,
     |  -6.9608941623064d+01, 5.0753428206436d+02,-7.0228412997907d+02,
     |   5.3253335089362d+02,-5.5111531510044d+01,-5.1035391749960d+02,
     |   8.7580886298104d+02,-8.1616660683935d+02, 2.7646881529050d+02,
     |   5.9950076614485d+02,-1.5553649441123d+03, 2.6611658073815d+03/
      data (lpmn(lat, 1,27), lat = 1,36)/
     |  -6.0210002662294d+02,-3.5089599347178d+02, 1.0712675688204d+03,
     |  -1.0658173622528d+03, 5.6383830955640d+02, 1.1150314596292d+02,
     |  -6.2827369352585d+02, 7.6998248026947d+02,-5.1409116329396d+02,
     |   2.4043958437538d+01, 4.4041908288360d+02,-6.5128586618873d+02,
     |   5.1846614814322d+02,-1.2574479704758d+02,-3.1777909135415d+02,
     |   5.8491134743388d+02,-5.4320851242646d+02, 2.1882572411652d+02,
     |   2.1882572411652d+02,-5.4320851242646d+02, 5.8491134743388d+02,
     |  -3.1777909135415d+02,-1.2574479704758d+02, 5.1846614814322d+02,
     |  -6.5128586618873d+02, 4.4041908288360d+02, 2.4043958437541d+01,
     |  -5.1409116329397d+02, 7.6998248026947d+02,-6.2827369352584d+02,
     |   1.1150314596292d+02, 5.6383830955640d+02,-1.0658173622528d+03,
     |   1.0712675688204d+03,-3.5089599347178d+02,-6.0210002662294d+02/
      data (lpmn(lat, 2,27), lat = 1,36)/
     |   1.1234442900398d+03,-1.2188627706378d+03, 8.5377048025824d+02,
     |   2.5392497692722d+01,-6.9128694909691d+02, 8.7051591192831d+02,
     |  -5.7250248401027d+02, 1.7905652950723d+01, 4.8655080840280d+02,
     |  -6.9477707610133d+02, 5.2839379872425d+02,-9.9234441019778d+01,
     |  -3.5828160093525d+02, 6.0888830245141d+02,-5.3243311401661d+02,
     |   1.7890969122142d+02, 2.6196172945233d+02,-5.5951917365582d+02,
     |   5.5951917365582d+02,-2.6196172945232d+02,-1.7890969122143d+02,
     |   5.3243311401661d+02,-6.0888830245141d+02, 3.5828160093526d+02,
     |   9.9234441019786d+01,-5.2839379872425d+02, 6.9477707610133d+02,
     |  -4.8655080840280d+02,-1.7905652950727d+01, 5.7250248401028d+02,
     |  -8.7051591192831d+02, 6.9128694909691d+02,-2.5392497692711d+01,
     |  -8.5377048025825d+02, 1.2188627706378d+03,-1.1234442900398d+03/
      data (lpmn(lat, 3,27), lat = 1,36)/
     |   6.8138323602349d+02,-4.7594024250493d+02,-3.5147200251478d+02,
     |   9.5258704233903d+02,-7.5645622930490d+02, 1.3026117665294d+02,
     |   4.7855684728632d+02,-7.4656248144431d+02, 5.7989190886489d+02,
     |  -1.1548309739182d+02,-3.7555969470187d+02, 6.3414008818700d+02,
     |  -5.3985429075695d+02, 1.6106454126380d+02, 2.9057263229207d+02,
     |  -5.7419617328274d+02, 5.4378700511576d+02,-2.2062352153680d+02,
     |  -2.2062352153680d+02, 5.4378700511576d+02,-5.7419617328274d+02,
     |   2.9057263229207d+02, 1.6106454126380d+02,-5.3985429075695d+02,
     |   6.3414008818700d+02,-3.7555969470187d+02,-1.1548309739182d+02,
     |   5.7989190886489d+02,-7.4656248144431d+02, 4.7855684728631d+02,
     |   1.3026117665294d+02,-7.5645622930490d+02, 9.5258704233903d+02,
     |  -3.5147200251477d+02,-4.7594024250493d+02, 6.8138323602348d+02/
      data (lpmn(lat, 4,27), lat = 1,36)/
     |   1.9886204083375d+02, 2.0947711844827d+02,-7.8609972184704d+02,
     |   5.6546904835618d+02, 2.4194636033295d+02,-7.5478357200145d+02,
     |   7.0232257175833d+02,-2.2568987280190d+02,-3.3501382663637d+02,
     |   6.5413084303203d+02,-5.7946757414214d+02, 1.8508362939910d+02,
     |   2.9133727644043d+02,-5.8538504132857d+02, 5.4513746614661d+02,
     |  -2.0434753560116d+02,-2.4314796214141d+02, 5.5069015982117d+02,
     |  -5.5069015982117d+02, 2.4314796214141d+02, 2.0434753560116d+02,
     |  -5.4513746614661d+02, 5.8538504132857d+02,-2.9133727644044d+02,
     |  -1.8508362939910d+02, 5.7946757414214d+02,-6.5413084303203d+02,
     |   3.3501382663637d+02, 2.2568987280191d+02,-7.0232257175833d+02,
     |   7.5478357200145d+02,-2.4194636033295d+02,-5.6546904835619d+02,
     |   7.8609972184704d+02,-2.0947711844827d+02,-1.9886204083375d+02/
      data (lpmn(lat, 5,27), lat = 1,36)/
     |   3.8561959698240d+01, 3.2794141616670d+02,-4.2159314349536d+02,
     |  -2.6164510754873d+02, 7.9679490231797d+02,-5.1825419086995d+02,
     |  -1.3373882696448d+02, 6.2254199140539d+02,-6.6013780226051d+02,
     |   2.8421283911823d+02, 2.3610253083876d+02,-5.8411369469251d+02,
     |   5.7198252806420d+02,-2.2834465348154d+02,-2.3525390754403d+02,
     |   5.5113915784693d+02,-5.4414111440407d+02, 2.2406269260628d+02,
     |   2.2406269260628d+02,-5.4414111440407d+02, 5.5113915784693d+02,
     |  -2.3525390754402d+02,-2.2834465348154d+02, 5.7198252806420d+02,
     |  -5.8411369469251d+02, 2.3610253083876d+02, 2.8421283911823d+02,
     |  -6.6013780226052d+02, 6.2254199140539d+02,-1.3373882696447d+02,
     |  -5.1825419086995d+02, 7.9679490231797d+02,-2.6164510754872d+02,
     |  -4.2159314349536d+02, 3.2794141616670d+02, 3.8561959698240d+01/
      data (lpmn(lat, 6,27), lat = 1,36)/
     |   5.5909107340855d+00, 2.0058798568397d+02, 1.5774781608737d+01,
     |  -5.8172633027075d+02, 4.3013961660096d+02, 3.1563494972979d+02,
     |  -7.1069220442107d+02, 4.9816055865495d+02, 5.8629841748719d+01,
     |  -5.3136699197291d+02, 6.2366555050103d+02,-3.1435494669969d+02,
     |  -1.7482700311670d+02, 5.3618971026792d+02,-5.5960659854845d+02,
     |   2.4453959277993d+02, 2.1190300408475d+02,-5.3587897360808d+02,
     |   5.3587897360808d+02,-2.1190300408474d+02,-2.4453959277994d+02,
     |   5.5960659854845d+02,-5.3618971026792d+02, 1.7482700311671d+02,
     |   3.1435494669970d+02,-6.2366555050103d+02, 5.3136699197291d+02,
     |  -5.8629841748716d+01,-4.9816055865496d+02, 7.1069220442107d+02,
     |  -3.1563494972979d+02,-4.3013961660096d+02, 5.8172633027075d+02,
     |  -1.5774781608734d+01,-2.0058798568397d+02,-5.5909107340854d+00/
      data (lpmn(lat, 7,27), lat = 1,36)/
     |   6.4500952700640d-01, 8.3465376607856d+01, 1.8841335042370d+02,
     |  -3.7791033564537d+02,-1.9328061368876d+02, 6.7451590664412d+02,
     |  -3.4714144275379d+02,-2.9267541649426d+02, 6.4327149738880d+02,
     |  -4.7985299182799d+02,-1.6842582896921d+01, 4.7382560193439d+02,
     |  -5.9239642695030d+02, 3.1895967353218d+02, 1.5097277824157d+02,
     |  -5.1269182200189d+02, 5.4265512085073d+02,-2.2882239854720d+02,
     |  -2.2882239854720d+02, 5.4265512085073d+02,-5.1269182200189d+02,
     |   1.5097277824157d+02, 3.1895967353218d+02,-5.9239642695030d+02,
     |   4.7382560193439d+02,-1.6842582896921d+01,-4.7985299182799d+02,
     |   6.4327149738880d+02,-2.9267541649425d+02,-3.4714144275380d+02,
     |   6.7451590664412d+02,-1.9328061368876d+02,-3.7791033564537d+02,
     |   1.8841335042370d+02, 8.3465376607856d+01, 6.4500952700640d-01/
      data (lpmn(lat, 8,27), lat = 1,36)/
     |   6.1534316523441d-02, 2.6859550764610d+01, 1.6695799034288d+02,
     |  -6.3679102882623d+01,-4.5851311813371d+02, 3.4648776204788d+02,
     |   3.4470891802988d+02,-6.3415523803455d+02, 2.9879807711478d+02,
     |   2.7355112528084d+02,-5.9637173468638d+02, 4.5459310821018d+02,
     |   9.0235930930526d+00,-4.4848772578650d+02, 5.6548696916184d+02,
     |  -2.9567195473379d+02,-1.6855071299191d+02, 5.1494785908418d+02,
     |  -5.1494785908418d+02, 1.6855071299191d+02, 2.9567195473380d+02,
     |  -5.6548696916184d+02, 4.4848772578650d+02,-9.0235930930583d+00,
     |  -4.5459310821018d+02, 5.9637173468638d+02,-2.7355112528084d+02,
     |  -2.9879807711478d+02, 6.3415523803455d+02,-3.4470891802988d+02,
     |  -3.4648776204788d+02, 4.5851311813371d+02, 6.3679102882624d+01,
     |  -1.6695799034288d+02,-2.6859550764610d+01,-6.1534316523441d-02/
      data (lpmn(lat, 9,27), lat = 1,36)/
     |   4.9819610108728d-03, 7.0795405126603d+00, 9.5134290433396d+01,
     |   1.0855629723085d+02,-3.3661406448507d+02,-1.5175683832077d+02,
     |   5.7932126267339d+02,-2.1074499301584d+02,-3.9299130993004d+02,
     |   5.8835082293591d+02,-2.5263849972035d+02,-2.7713463705887d+02,
     |   5.6693166308608d+02,-4.1567804366958d+02,-3.8971124584177d+01,
     |   4.5487756998046d+02,-5.3689267545176d+02, 2.3440054166211d+02,
     |   2.3440054166211d+02,-5.3689267545176d+02, 4.5487756998046d+02,
     |  -3.8971124584175d+01,-4.1567804366958d+02, 5.6693166308609d+02,
     |  -2.7713463705887d+02,-2.5263849972035d+02, 5.8835082293591d+02,
     |  -3.9299130993004d+02,-2.1074499301584d+02, 5.7932126267339d+02,
     |  -1.5175683832077d+02,-3.3661406448507d+02, 1.0855629723085d+02,
     |   9.5134290433397d+01, 7.0795405126603d+00, 4.9819610108728d-03/
      data (lpmn(lat,10,27), lat = 1,36)/
     |   3.4867815838371d-04, 1.5791395959731d+00, 4.1767710304172d+01,
     |   1.3287963859103d+02,-9.7803194342406d+01,-3.7622586637061d+02,
     |   2.7865198467085d+02, 3.6235036023575d+02,-5.4163252061869d+02,
     |   1.0591992922310d+02, 4.2284065870733d+02,-5.4370879611349d+02,
     |   1.8970975956272d+02, 3.1031042933956d+02,-5.4829841296309d+02,
     |   3.5145952989029d+02, 1.1387260876875d+02,-4.8771805480212d+02,
     |   4.8771805480212d+02,-1.1387260876875d+02,-3.5145952989030d+02,
     |   5.4829841296309d+02,-3.1031042933956d+02,-1.8970975956271d+02,
     |   5.4370879611349d+02,-4.2284065870733d+02,-1.0591992922311d+02,
     |   5.4163252061869d+02,-3.6235036023575d+02,-2.7865198467085d+02,
     |   3.7622586637061d+02, 9.7803194342406d+01,-1.3287963859103d+02,
     |  -4.1767710304173d+01,-1.5791395959731d+00,-3.4867815838371d-04/
      data (lpmn(lat,11,27), lat = 1,36)/
     |   2.1383398356996d-05, 3.0442190504925d-01, 1.5098493865566d+01,
     |   9.2688701070470d+01, 6.0068453205466d+01,-2.9629726377584d+02,
     |  -1.3373147185097d+02, 4.9928314236859d+02,-8.6680341572938d+01,
     |  -4.5375038529334d+02, 4.7157798240271d+02,-2.7387960227638d+00,
     |  -4.5641494777740d+02, 4.8939271830937d+02,-9.4213661355682d+01,
     |  -3.7374290465954d+02, 5.2361887104256d+02,-2.4008609503264d+02,
     |  -2.4008609503264d+02, 5.2361887104256d+02,-3.7374290465954d+02,
     |  -9.4213661355683d+01, 4.8939271830937d+02,-4.5641494777741d+02,
     |  -2.7387960227700d+00, 4.7157798240271d+02,-4.5375038529334d+02,
     |  -8.6680341572941d+01, 4.9928314236859d+02,-1.3373147185096d+02,
     |  -2.9629726377584d+02, 6.0068453205466d+01, 9.2688701070470d+01,
     |   1.5098493865566d+01, 3.0442190504925d-01, 2.1383398356996d-05/
      data (lpmn(lat,12,27), lat = 1,36)/
     |   1.1608061812564d-06, 5.1457774892812d-02, 4.6490869715864d+00,
     |   4.8802203002358d+01, 1.0411553943430d+02,-1.0686262591886d+02,
     |  -3.1917642956549d+02, 2.1160405305432d+02, 3.7738922473515d+02,
     |  -4.2965757505084d+02,-8.1831645847797d+01, 4.9615310993985d+02,
     |  -3.7495388532057d+02,-1.1955782438790d+02, 4.9100862959673d+02,
     |  -4.0242036899060d+02,-4.9468193087821d+01, 4.5398681877063d+02,
     |  -4.5398681877063d+02, 4.9468193087820d+01, 4.0242036899060d+02,
     |  -4.9100862959673d+02, 1.1955782438790d+02, 3.7495388532056d+02,
     |  -4.9615310993985d+02, 8.1831645847797d+01, 4.2965757505085d+02,
     |  -3.7738922473515d+02,-2.1160405305432d+02, 3.1917642956549d+02,
     |   1.0686262591886d+02,-1.0411553943430d+02,-4.8802203002359d+01,
     |  -4.6490869715865d+00,-5.1457774892812d-02,-1.1608061812564d-06/
      data (lpmn(lat,13,27), lat = 1,36)/
     |   5.6205795465801d-08, 7.7057903529147d-03, 1.2444364954838d+00,
     |   2.1059904476883d+01, 8.4137495175562d+01, 3.2678242767102d+01,
     |  -2.5653739650084d+02,-1.3503120578606d+02, 4.2281028675865d+02,
     |   3.6503652961344d+01,-4.7274907066297d+02, 2.9250613900318d+02,
     |   2.3766103795016d+02,-4.9949394638785d+02, 2.3265160153046d+02,
     |   2.6700990336987d+02,-4.9890315622366d+02, 2.4491687758748d+02,
     |   2.4491687758748d+02,-4.9890315622366d+02, 2.6700990336986d+02,
     |   2.3265160153046d+02,-4.9949394638785d+02, 2.3766103795017d+02,
     |   2.9250613900318d+02,-4.7274907066297d+02, 3.6503652961342d+01,
     |   4.2281028675865d+02,-1.3503120578606d+02,-2.5653739650084d+02,
     |   3.2678242767102d+01, 8.4137495175561d+01, 2.1059904476883d+01,
     |   1.2444364954838d+00, 7.7057903529147d-03, 5.6205795465801d-08/
      data (lpmn(lat,14,27), lat = 1,36)/
     |   2.4411460795455d-09, 1.0298854341443d-03, 2.9340828019066d-01,
     |   7.7354984964388d+00, 4.9808929037878d+01, 8.2296835087843d+01,
     |  -9.9638956685237d+01,-2.7831429792559d+02, 1.3789489368432d+02,
     |   3.8595930491111d+02,-2.8847186199974d+02,-2.5285415889493d+02,
     |   4.6488154788718d+02,-1.0224481366970d+02,-3.7852644118569d+02,
     |   4.3542250826993d+02,-2.1740595804762d+01,-4.1355448192932d+02,
     |   4.1355448192932d+02, 2.1740595804763d+01,-4.3542250826993d+02,
     |   3.7852644118569d+02, 1.0224481366970d+02,-4.6488154788718d+02,
     |   2.5285415889493d+02, 2.8847186199974d+02,-3.8595930491111d+02,
     |  -1.3789489368432d+02, 2.7831429792559d+02, 9.9638956685238d+01,
     |  -8.2296835087842d+01,-4.9808929037878d+01,-7.7354984964389d+00,
     |  -2.9340828019066d-01,-1.0298854341443d-03,-2.4411460795455d-09/
      data (lpmn(lat,15,27), lat = 1,36)/
     |   9.5487741682742d-11, 1.2349113888440d-04, 6.1474871477159d-02,
     |   2.4696413390370d+00, 2.3938023895942d+01, 7.3556937652060d+01,
     |   2.0804460323335d+01,-2.1616785896784d+02,-1.5038064281290d+02,
     |   3.3785221563477d+02, 1.5849748962864d+02,-4.3101412064382d+02,
     |   5.7269959583334d+01, 4.0445237019518d+02,-3.4736452370352d+02,
     |  -1.3669861714577d+02, 4.5839217405980d+02,-2.4761584617994d+02,
     |  -2.4761584617994d+02, 4.5839217405980d+02,-1.3669861714577d+02,
     |  -3.4736452370352d+02, 4.0445237019518d+02, 5.7269959583330d+01,
     |  -4.3101412064382d+02, 1.5849748962864d+02, 3.3785221563477d+02,
     |  -1.5038064281290d+02,-2.1616785896784d+02, 2.0804460323334d+01,
     |   7.3556937652060d+01, 2.3938023895942d+01, 2.4696413390370d+00,
     |   6.1474871477160d-02, 1.2349113888440d-04, 9.5487741682742d-11/
      data (lpmn(lat,16,27), lat = 1,36)/
     |   3.3727176980275d-12, 1.3330982235784d-05, 1.1512830456234d-02,
     |   6.9404292276286d-01, 9.7447549837467d+00, 4.6707980418099d+01,
     |   6.7317992973190d+01,-8.0782188395483d+01,-2.4552179475943d+02,
     |   5.4501557934331d+01, 3.7388361525028d+02,-1.1225887660524d+02,
     |  -3.7018762009776d+02, 2.9606248810205d+02, 2.0690210064743d+02,
     |  -4.3419203480331d+02, 9.4843315873847d+01, 3.6626772954500d+02,
     |  -3.6626772954500d+02,-9.4843315873848d+01, 4.3419203480332d+02,
     |  -2.0690210064743d+02,-2.9606248810205d+02, 3.7018762009776d+02,
     |   1.1225887660525d+02,-3.7388361525028d+02,-5.4501557934332d+01,
     |   2.4552179475943d+02, 8.0782188395484d+01,-6.7317992973190d+01,
     |  -4.6707980418099d+01,-9.7447549837467d+00,-6.9404292276287d-01,
     |  -1.1512830456234d-02,-1.3330982235784d-05,-3.3727176980275d-12/
      data (lpmn(lat,17,27), lat = 1,36)/
     |   1.0771086622128d-13, 1.2980852569063d-06, 1.9340612910608d-03,
     |   1.7302414554098d-01, 3.4340883755577d+00, 2.3810956583868d+01,
     |   6.2895694544850d+01, 2.0234086125135d+01,-1.7281496526607d+02,
     |  -1.7160395090690d+02, 2.3275697775171d+02, 2.6212365560143d+02,
     |  -3.0189991084380d+02,-1.9076201901560d+02, 3.9668171297879d+02,
     |  -7.1488219697042d+00,-3.9790745925873d+02, 2.4649239219071d+02,
     |   2.4649239219071d+02,-3.9790745925873d+02,-7.1488219697077d+00,
     |   3.9668171297879d+02,-1.9076201901560d+02,-3.0189991084380d+02,
     |   2.6212365560143d+02, 2.3275697775171d+02,-1.7160395090690d+02,
     |  -1.7281496526607d+02, 2.0234086125134d+01, 6.2895694544850d+01,
     |   2.3810956583868d+01, 3.4340883755577d+00, 1.7302414554098d-01,
     |   1.9340612910609d-03, 1.2980852569063d-06, 1.0771086622128d-13/
      data (lpmn(lat,18,27), lat = 1,36)/
     |   3.1102041337361d-15, 1.1406700928328d-07, 2.9192363327420d-04,
     |   3.8431826940222d-02, 1.0603201434659d+00, 1.0204991071602d+01,
     |   4.0941201064217d+01, 5.7763330208760d+01,-5.3337506335533d+01,
     |  -2.1141069251192d+02,-3.5178306283961d+01, 3.1831419755902d+02,
     |   8.3802984526520d+01,-3.6761368501680d+02, 2.0918400843506d+00,
     |   3.8205334424299d+02,-1.6212129901353d+02,-3.1209113289149d+02,
     |   3.1209113289149d+02, 1.6212129901353d+02,-3.8205334424299d+02,
     |  -2.0918400843514d+00, 3.6761368501680d+02,-8.3802984526523d+01,
     |  -3.1831419755902d+02, 3.5178306283961d+01, 2.1141069251192d+02,
     |   5.3337506335533d+01,-5.7763330208759d+01,-4.0941201064217d+01,
     |  -1.0204991071602d+01,-1.0603201434659d+00,-3.8431826940223d-02,
     |  -2.9192363327421d-04,-1.1406700928328d-07,-3.1102041337361d-15/
      data (lpmn(lat,19,27), lat = 1,36)/
     |   8.1089409581732d-17, 9.0360648372954d-09, 3.9581999207743d-05,
     |   7.6185851536552d-03, 2.8866338251549d-01, 3.7579953157460d+00,
     |   2.1181605029093d+01, 5.2578759846197d+01, 2.6741304910626d+01,
     |  -1.2361644460320d+02,-1.8527076149638d+02, 1.0250546775769d+02,
     |   3.0728783225795d+02,-7.9694792202888d+01,-3.3782452266577d+02,
     |   1.4208703261941d+02, 3.1464416504083d+02,-2.3927978188537d+02,
     |  -2.3927978188537d+02, 3.1464416504083d+02, 1.4208703261941d+02,
     |  -3.3782452266577d+02,-7.9694792202888d+01, 3.0728783225795d+02,
     |   1.0250546775769d+02,-1.8527076149638d+02,-1.2361644460320d+02,
     |   2.6741304910626d+01, 5.2578759846197d+01, 2.1181605029093d+01,
     |   3.7579953157460d+00, 2.8866338251549d-01, 7.6185851536553d-03,
     |   3.9581999207745d-05, 9.0360648372954d-09, 8.1089409581732d-17/
      data (lpmn(lat,20,27), lat = 1,36)/
     |   1.9031761597586d-18, 6.4353368455067d-10, 4.8111144788856d-06,
     |   1.3468809382294d-03, 6.9446141902309d-02, 1.2016162646355d+00,
     |   9.1234260388206d+00, 3.3367351018933d+01, 5.1020237986067d+01,
     |  -2.0719561160079d+01,-1.6554327291129d+02,-1.1551517110877d+02,
     |   1.9793471753577d+02, 2.3867941497417d+02,-1.8555210387538d+02,
     |  -2.6903338988217d+02, 2.1216165557802d+02, 2.5123256985493d+02,
     |  -2.5123256985493d+02,-2.1216165557802d+02, 2.6903338988217d+02,
     |   1.8555210387538d+02,-2.3867941497417d+02,-1.9793471753577d+02,
     |   1.1551517110877d+02, 1.6554327291129d+02, 2.0719561160079d+01,
     |  -5.1020237986067d+01,-3.3367351018933d+01,-9.1234260388206d+00,
     |  -1.2016162646355d+00,-6.9446141902308d-02,-1.3468809382294d-03,
     |  -4.8111144788859d-06,-6.4353368455067d-10,-1.9031761597586d-18/
      data (lpmn(lat,21,27), lat = 1,36)/
     |   4.0008152796816d-20, 4.1005528660924d-11, 5.2195681839811d-07,
     |   2.1164386431431d-04, 1.4744938467394d-02, 3.3481776852977d-01,
     |   3.3361774955609d+00, 1.6691699053473d+01, 4.1946758814515d+01,
     |   3.5079360438698d+01,-6.7875382415561d+01,-1.7214699720454d+02,
     |  -3.6315371893349d+01, 2.4025944836101d+02, 1.6037251711367d+02,
     |  -2.3037361870735d+02,-2.0949375213119d+02, 2.2283812591122d+02,
     |   2.2283812591122d+02,-2.0949375213119d+02,-2.3037361870735d+02,
     |   1.6037251711367d+02, 2.4025944836101d+02,-3.6315371893350d+01,
     |  -1.7214699720454d+02,-6.7875382415561d+01, 3.5079360438698d+01,
     |   4.1946758814515d+01, 1.6691699053473d+01, 3.3361774955609d+00,
     |   3.3481776852977d-01, 1.4744938467394d-02, 2.1164386431431d-04,
     |   5.2195681839813d-07, 4.1005528660924d-11, 4.0008152796816d-20/
      data (lpmn(lat,22,27), lat = 1,36)/
     |   7.4747711862353d-22, 2.3200149849537d-12, 5.0179968524527d-08,
     |   2.9369268938608d-05, 2.7491320681817d-03, 8.1146299423576d-02,
     |   1.0424826176413d+00, 6.8539688636340d+00, 2.4455223787906d+01,
     |   4.3538359001980d+01, 1.0850954759311d+01,-1.0105528919954d+02,
     |  -1.5372286549580d+02, 2.4681139312233d+01, 2.4270004727787d+02,
     |   1.0638790893141d+02,-2.2922688137216d+02,-1.8438555626056d+02,
     |   1.8438555626055d+02, 2.2922688137216d+02,-1.0638790893141d+02,
     |  -2.4270004727787d+02,-2.4681139312234d+01, 1.5372286549580d+02,
     |   1.0105528919954d+02,-1.0850954759311d+01,-4.3538359001980d+01,
     |  -2.4455223787906d+01,-6.8539688636340d+00,-1.0424826176413d+00,
     |  -8.1146299423575d-02,-2.7491320681817d-03,-2.9369268938609d-05,
     |  -5.0179968524529d-08,-2.3200149849537d-12,-7.4747711862353d-22/
      data (lpmn(lat,23,27), lat = 1,36)/
     |   1.2265919466145d-23, 1.1519881759794d-13, 4.2266666552221d-09,
     |   3.5604563374885d-06, 4.4574107102929d-04, 1.6976495152986d-02,
     |   2.7763308229832d-01, 2.3392753859888d+00, 1.1110822732558d+01,
     |   2.9983383519652d+01, 3.8502053228339d+01,-1.2281056950913d+01,
     |  -1.1540579717039d+02,-1.2779928407782d+02, 5.4029575225454d+01,
     |   2.2434215570807d+02, 9.1613992902785d+01,-1.9251105745407d+02,
     |  -1.9251105745407d+02, 9.1613992902785d+01, 2.2434215570807d+02,
     |   5.4029575225455d+01,-1.2779928407782d+02,-1.1540579717039d+02,
     |  -1.2281056950913d+01, 3.8502053228339d+01, 2.9983383519652d+01,
     |   1.1110822732558d+01, 2.3392753859888d+00, 2.7763308229832d-01,
     |   1.6976495152986d-02, 4.4574107102929d-04, 3.5604563374886d-06,
     |   4.2266666552223d-09, 1.1519881759794d-13, 1.2265919466145d-23/
      data (lpmn(lat,24,27), lat = 1,36)/
     |   1.7357385404343d-25, 4.9293668161360d-15, 3.0635262658248d-10,
     |   3.7052969873831d-07, 6.1806281347314d-05, 3.0194611141337d-03,
     |   6.2260333324318d-02, 6.6092453973128d-01, 4.0315516214307d+00,
     |   1.4819996435912d+01, 3.1925698040501d+01, 3.0544856926600d+01,
     |  -2.6416905143334d+01,-1.1331881759287d+02,-1.0868219146845d+02,
     |   4.8909232680733d+01, 1.9398032534277d+02, 1.1328158791865d+02,
     |  -1.1328158791865d+02,-1.9398032534277d+02,-4.8909232680734d+01,
     |   1.0868219146845d+02, 1.1331881759287d+02, 2.6416905143334d+01,
     |  -3.0544856926599d+01,-3.1925698040501d+01,-1.4819996435912d+01,
     |  -4.0315516214308d+00,-6.6092453973128d-01,-6.2260333324318d-02,
     |  -3.0194611141337d-03,-6.1806281347314d-05,-3.7052969873832d-07,
     |  -3.0635262658250d-10,-4.9293668161360d-15,-1.7357385404343d-25/
      data (lpmn(lat,25,27), lat = 1,36)/
     |   2.0546896472709d-27, 1.7634179194105d-16, 1.8540589299645d-11,
     |   3.2130937403751d-08, 7.1185666294070d-06, 4.4395537808429d-04,
     |   1.1456255780496d-02, 1.5134262932017d-01, 1.1589408507505d+00,
     |   5.5134106390765d+00, 1.6670813184421d+01, 3.0540047233634d+01,
     |   2.4273055647663d+01,-2.7320445473928d+01,-9.8286871006094d+01,
     |  -1.0044620994182d+02, 1.1574511290684d+01, 1.4024197879022d+02,
     |   1.4024197879022d+02, 1.1574511290684d+01,-1.0044620994182d+02,
     |  -9.8286871006094d+01,-2.7320445473928d+01, 2.4273055647663d+01,
     |   3.0540047233634d+01, 1.6670813184421d+01, 5.5134106390765d+00,
     |   1.1589408507505d+00, 1.5134262932017d-01, 1.1456255780497d-02,
     |   4.4395537808429d-04, 7.1185666294070d-06, 3.2130937403752d-08,
     |   1.8540589299646d-11, 1.7634179194105d-16, 2.0546896472709d-27/
      data (lpmn(lat,26,27), lat = 1,36)/
     |   1.9215297194588d-29, 4.9812034625623d-18, 8.8505327094785d-13,
     |   2.1938066184857d-09, 6.4382119899337d-07, 5.1055373089744d-05,
     |   1.6390167907531d-03, 2.6695615678479d-02, 2.5264831572964d-01,
     |   1.5096989268578d+00, 5.9671586226597d+00, 1.5787478228868d+01,
     |   2.6725248634612d+01, 2.2267361998006d+01,-1.4219119796264d+01,
     |  -6.8739284210284d+01,-9.0307646622927d+01,-4.2432072807575d+01,
     |   4.2432072807574d+01, 9.0307646622928d+01, 6.8739284210284d+01,
     |   1.4219119796264d+01,-2.2267361998006d+01,-2.6725248634612d+01,
     |  -1.5787478228868d+01,-5.9671586226597d+00,-1.5096989268578d+00,
     |  -2.5264831572964d-01,-2.6695615678479d-02,-1.6390167907531d-03,
     |  -5.1055373089744d-05,-6.4382119899337d-07,-2.1938066184858d-09,
     |  -8.8505327094790d-13,-4.9812034625623d-18,-1.9215297194588d-29/
      data (lpmn(lat,27,27), lat = 1,36)/
     |   1.2313782863030d-31, 9.6374065996855d-20, 2.8910175646434d-14,
     |   1.0233926786437d-10, 3.9692994718262d-08, 3.9891205757900d-06,
     |   1.5854549509867d-04, 3.1607943454648d-03, 3.6549816830156d-02,
     |   2.6903401659427d-01, 1.3384591367880d+00, 4.6651391024619d+00,
     |   1.1547017109441d+01, 1.9939420899346d+01, 2.1807520509650d+01,
     |   7.9644999278183d+00,-1.9637236774418d+01,-4.3031048133898d+01,
     |  -4.3031048133898d+01,-1.9637236774419d+01, 7.9644999278182d+00,
     |   2.1807520509650d+01, 1.9939420899346d+01, 1.1547017109441d+01,
     |   4.6651391024619d+00, 1.3384591367880d+00, 2.6903401659427d-01,
     |   3.6549816830156d-02, 3.1607943454648d-03, 1.5854549509867d-04,
     |   3.9891205757900d-06, 3.9692994718262d-08, 1.0233926786437d-10,
     |   2.8910175646436d-14, 9.6374065996855d-20, 1.2313782863030d-31/
      data (lpmn(lat, 0,28), lat = 1,36)/
     |  -2.8145020021610d+03, 1.7394478720093d+03,-8.9616580651202d+02,
     |   6.0927433685475d+01, 5.9069720010004d+02,-9.0505930253387d+02,
     |   8.3476944188074d+02,-4.5728827379786d+02,-5.5302291414901d+01,
     |   4.9970350366457d+02,-7.1379184741869d+02, 6.3177938023083d+02,
     |  -3.0281701082109d+02,-1.3268741011566d+02, 4.9934478396191d+02,
     |  -6.5428490668160d+02, 5.4076263117699d+02,-2.0822060402151d+02,
     |  -2.0822060402152d+02, 5.4076263117699d+02,-6.5428490668160d+02,
     |   4.9934478396190d+02,-1.3268741011566d+02,-3.0281701082109d+02,
     |   6.3177938023084d+02,-7.1379184741869d+02, 4.9970350366457d+02,
     |  -5.5302291414896d+01,-4.5728827379786d+02, 8.3476944188074d+02,
     |  -9.0505930253387d+02, 5.9069720010004d+02, 6.0927433685489d+01,
     |  -8.9616580651203d+02, 1.7394478720093d+03,-2.8145020021610d+03/
      data (lpmn(lat, 1,28), lat = 1,36)/
     |  -7.7846806222117d+02,-1.6682106354817d+02, 9.6991524510223d+02,
     |  -1.1616495944442d+03, 8.8269333834845d+02,-3.2759165374720d+02,
     |  -2.6586772636094d+02, 6.8058236794116d+02,-7.8547594536027d+02,
     |   5.7218703264701d+02,-1.4885851975868d+02,-3.0628031692552d+02,
     |   6.1408800240310d+02,-6.6102305274499d+02, 4.3900190070892d+02,
     |  -4.4745442487143d+01,-3.6018921283811d+02, 6.1305620553476d+02,
     |  -6.1305620553476d+02, 3.6018921283810d+02, 4.4745442487150d+01,
     |  -4.3900190070892d+02, 6.6102305274498d+02,-6.1408800240310d+02,
     |   3.0628031692551d+02, 1.4885851975868d+02,-5.7218703264701d+02,
     |   7.8547594536028d+02,-6.8058236794116d+02, 2.6586772636093d+02,
     |   3.2759165374720d+02,-8.8269333834845d+02, 1.1616495944442d+03,
     |  -9.6991524510222d+02, 1.6682106354817d+02, 7.7846806222118d+02/
      data (lpmn(lat, 2,28), lat = 1,36)/
     |   1.1666649430004d+03,-1.3062595122770d+03, 1.0854611910885d+03,
     |  -3.0585973766188d+02,-4.2558975072971d+02, 8.4178762627568d+02,
     |  -8.5048758085917d+02, 5.1347162667641d+02,-4.9757964559767d+00,
     |  -4.5919199853004d+02, 7.0109952809459d+02,-6.4181858233525d+02,
     |   3.2365108575022d+02, 1.1292676836538d+02,-4.8756580042235d+02,
     |   6.5101211906967d+02,-5.4203624173257d+02, 2.0932256202650d+02,
     |   2.0932256202650d+02,-5.4203624173258d+02, 6.5101211906967d+02,
     |  -4.8756580042235d+02, 1.1292676836538d+02, 3.2365108575022d+02,
     |  -6.4181858233525d+02, 7.0109952809459d+02,-4.5919199853004d+02,
     |  -4.9757964559812d+00, 5.1347162667641d+02,-8.5048758085918d+02,
     |   8.4178762627568d+02,-4.2558975072971d+02,-3.0585973766190d+02,
     |   1.0854611910885d+03,-1.3062595122770d+03, 1.1666649430004d+03/
      data (lpmn(lat, 3,28), lat = 1,36)/
     |   7.5639013281591d+02,-6.2419555598974d+02,-1.7379587700355d+02,
     |   9.0906193474721d+02,-9.6331041731420d+02, 5.3423864919389d+02,
     |   7.3380224808672d+01,-5.7137608266210d+02, 7.6962486838528d+02,
     |  -6.2179156020497d+02, 2.2193670333871d+02, 2.4567220820518d+02,
     |  -5.8433795076910d+02, 6.6154400807023d+02,-4.5682857162255d+02,
     |   6.4594685163301d+01, 3.4746726602366d+02,-6.0722190786011d+02,
     |   6.0722190786011d+02,-3.4746726602365d+02,-6.4594685163308d+01,
     |   4.5682857162255d+02,-6.6154400807023d+02, 5.8433795076910d+02,
     |  -2.4567220820518d+02,-2.2193670333871d+02, 6.2179156020497d+02,
     |  -7.6962486838528d+02, 5.7137608266210d+02,-7.3380224808662d+01,
     |  -5.3423864919389d+02, 9.6331041731420d+02,-9.0906193474720d+02,
     |   1.7379587700353d+02, 6.2419555598974d+02,-7.5639013281590d+02/
      data (lpmn(lat, 4,28), lat = 1,36)/
     |   2.3080409844827d+02, 1.6185604120810d+02,-8.3163925008349d+02,
     |   7.9909803673517d+02,-7.9349212783806d+01,-5.7656992941084d+02,
     |   8.3288762278699d+02,-6.4873641577853d+02, 1.7955131649044d+02,
     |   3.2935620959352d+02,-6.5144819985467d+02, 6.6353521770614d+02,
     |  -3.8253284203548d+02,-5.3841823478080d+01, 4.5113428507743d+02,
     |  -6.4025472383970d+02, 5.4546204255909d+02,-2.1255458897465d+02,
     |  -2.1255458897466d+02, 5.4546204255909d+02,-6.4025472383970d+02,
     |   4.5113428507743d+02,-5.3841823478077d+01,-3.8253284203547d+02,
     |   6.6353521770615d+02,-6.5144819985467d+02, 3.2935620959352d+02,
     |   1.7955131649045d+02,-6.4873641577853d+02, 8.3288762278699d+02,
     |  -5.7656992941084d+02,-7.9349212783806d+01, 7.9909803673518d+02,
     |  -8.3163925008348d+02, 1.6185604120810d+02, 2.3080409844827d+02/
      data (lpmn(lat, 5,28), lat = 1,36)/
     |   4.6600795393454d+01, 3.5267355044576d+02,-5.5246878136247d+02,
     |  -7.9198392270015d+01, 7.7753651645282d+02,-7.8140276504833d+02,
     |   2.8781449004605d+02, 3.1003753317841d+02,-6.8499034267957d+02,
     |   6.8577598293094d+02,-3.5546135765159d+02,-1.2172236831347d+02,
     |   5.1657419940977d+02,-6.5558148349765d+02, 4.8899220263442d+02,
     |  -1.0343236663122d+02,-3.2195872465837d+02, 5.9548930679010d+02,
     |  -5.9548930679010d+02, 3.2195872465837d+02, 1.0343236663122d+02,
     |  -4.8899220263442d+02, 6.5558148349765d+02,-5.1657419940978d+02,
     |   1.2172236831346d+02, 3.5546135765159d+02,-6.8577598293094d+02,
     |   6.8499034267957d+02,-3.1003753317841d+02,-2.8781449004606d+02,
     |   7.8140276504833d+02,-7.7753651645282d+02, 7.9198392270007d+01,
     |   5.5246878136247d+02,-3.5267355044576d+02,-4.6600795393454d+01/
      data (lpmn(lat, 6,28), lat = 1,36)/
     |   7.0268578685060d+00, 2.3464945897644d+02,-6.1923904105139d+01,
     |  -5.9352300160723d+02, 6.5697636689296d+02, 9.4713865139160d+00,
     |  -6.0837458173450d+02, 7.4577000603447d+02,-4.2931481857906d+02,
     |  -9.7093445254712d+01, 5.3378588859855d+02,-6.7116106697409d+02,
     |   4.6704919561630d+02,-4.2923043967801d+01,-3.8715892803750d+02,
     |   6.1925414605535d+02,-5.4984399453730d+02, 2.1769149824455d+02,
     |   2.1769149824455d+02,-5.4984399453730d+02, 6.1925414605534d+02,
     |  -3.8715892803750d+02,-4.2923043967803d+01, 4.6704919561630d+02,
     |  -6.7116106697409d+02, 5.3378588859855d+02,-9.7093445254710d+01,
     |  -4.2931481857907d+02, 7.4577000603447d+02,-6.0837458173449d+02,
     |   9.4713865139160d+00, 6.5697636689296d+02,-5.9352300160723d+02,
     |  -6.1923904105143d+01, 2.3464945897644d+02, 7.0268578685059d+00/
      data (lpmn(lat, 7,28), lat = 1,36)/
     |   8.4298181215479d-01, 1.0348782052802d+02, 1.8130035458289d+02,
     |  -4.9101880184956d+02,-4.9691332039702d+00, 6.6700310517626d+02,
     |  -6.4272161684399d+02, 1.1440900930963d+02, 4.4763357227419d+02,
     |  -6.8850596457277d+02, 5.1281311982561d+02,-6.3127683056093d+01,
     |  -3.9735656519415d+02, 6.2939999542627d+02,-5.2802636392797d+02,
     |   1.5921825380779d+02, 2.8361584729468d+02,-5.7773353815012d+02,
     |   5.7773353815012d+02,-2.8361584729468d+02,-1.5921825380779d+02,
     |   5.2802636392797d+02,-6.2939999542627d+02, 3.9735656519415d+02,
     |   6.3127683056102d+01,-5.1281311982561d+02, 6.8850596457277d+02,
     |  -4.4763357227418d+02,-1.1440900930964d+02, 6.4272161684400d+02,
     |  -6.6700310517626d+02, 4.9691332039702d+00, 4.9101880184956d+02,
     |  -1.8130035458289d+02,-1.0348782052802d+02,-8.4298181215478d-01/
      data (lpmn(lat, 8,28), lat = 1,36)/
     |   8.3652326518444d-02, 3.5017317592333d+01, 1.9056067392800d+02,
     |  -1.5512316569223d+02,-4.4392583704003d+02, 5.6596086457937d+02,
     |   5.5203725838704d+01,-6.0169684828131d+02, 6.3415059334659d+02,
     |  -2.1773780729592d+02,-3.1310175245776d+02, 6.2243170087872d+02,
     |  -5.5210711102545d+02, 1.7112627136077d+02, 2.9222890814678d+02,
     |  -5.8364823238175d+02, 5.5315705751029d+02,-2.2434547853809d+02,
     |  -2.2434547853809d+02, 5.5315705751029d+02,-5.8364823238175d+02,
     |   2.9222890814678d+02, 1.7112627136078d+02,-5.5210711102545d+02,
     |   6.2243170087872d+02,-3.1310175245776d+02,-2.1773780729592d+02,
     |   6.3415059334659d+02,-6.0169684828131d+02, 5.5203725838697d+01,
     |   5.6596086457937d+02,-4.4392583704003d+02,-1.5512316569223d+02,
     |   1.9056067392800d+02, 3.5017317592333d+01, 8.3652326518444d-02/
      data (lpmn(lat, 9,28), lat = 1,36)/
     |   7.0491554632379d-03, 9.6742308706070d+00, 1.1839468056144d+02,
     |   7.8675600420808d+01,-4.3249647333703d+02, 3.9471229619194d+01,
     |   5.8339895105838d+02,-5.2906901977462d+02,-2.2951261346873d+01,
     |   5.2709065451349d+02,-6.1836807532701d+02, 2.8545295311368d+02,
     |   2.1579460854695d+02,-5.6399666017125d+02, 5.6176556107436d+02,
     |  -2.2810902629881d+02,-2.3257939904702d+02, 5.5377567904555d+02,
     |  -5.5377567904555d+02, 2.3257939904701d+02, 2.2810902629881d+02,
     |  -5.6176556107436d+02, 5.6399666017125d+02,-2.1579460854695d+02,
     |  -2.8545295311368d+02, 6.1836807532701d+02,-5.2709065451349d+02,
     |   2.2951261346870d+01, 5.2906901977462d+02,-5.8339895105837d+02,
     |  -3.9471229619194d+01, 4.3249647333703d+02,-7.8675600420807d+01,
     |  -1.1839468056144d+02,-9.6742308706070d+00,-7.0491554632378d-03/
      data (lpmn(lat,10,28), lat = 1,36)/
     |   5.1393882973350d-04, 2.2591081746329d+00, 5.5525505241383d+01,
     |   1.4352952298019d+02,-1.9414326258441d+02,-3.4363759552268d+02,
     |   4.9339920568581d+02, 9.4608148539734d+01,-5.8230600752466d+02,
     |   5.0589944688911d+02,-1.2357936703608d+01,-4.6881150798192d+02,
     |   5.9663382538411d+02,-3.1497077986915d+02,-1.6483534818065d+02,
     |   5.2796924764198d+02,-5.5251809723367d+02, 2.3194603301429d+02,
     |   2.3194603301430d+02,-5.5251809723367d+02, 5.2796924764198d+02,
     |  -1.6483534818065d+02,-3.1497077986915d+02, 5.9663382538411d+02,
     |  -4.6881150798192d+02,-1.2357936703608d+01, 5.0589944688912d+02,
     |  -5.8230600752466d+02, 9.4608148539731d+01, 4.9339920568581d+02,
     |  -3.4363759552268d+02,-1.9414326258442d+02, 1.4352952298019d+02,
     |   5.5525505241384d+01, 2.2591081746329d+00, 5.1393882973350d-04/
      data (lpmn(lat,11,28), lat = 1,36)/
     |   3.2869009282156d-05, 4.5585248493898d-01, 2.1272952054354d+01,
     |   1.1407635200152d+02, 1.4882517825020d+01,-3.7784938017936d+02,
     |   5.5891898525521d+01, 5.2230426166307d+02,-4.2240394460914d+02,
     |  -1.4681373520577d+02, 5.6199725689486d+02,-4.8170711957674d+02,
     |   2.2155749399366d+01, 4.3960088504295d+02,-5.7299771726663d+02,
     |   3.0358295626773d+02, 1.6945699114835d+02,-5.2339433565764d+02,
     |   5.2339433565764d+02,-1.6945699114834d+02,-3.0358295626774d+02,
     |   5.7299771726663d+02,-4.3960088504295d+02,-2.2155749399361d+01,
     |   4.8170711957675d+02,-5.6199725689486d+02, 1.4681373520577d+02,
     |   4.2240394460915d+02,-5.2230426166307d+02,-5.5891898525525d+01,
     |   3.7784938017936d+02,-1.4882517825020d+01,-1.1407635200152d+02,
     |  -2.1272952054355d+01,-4.5585248493898d-01,-3.2869009282156d-05/
      data (lpmn(lat,12,28), lat = 1,36)/
     |   1.8632405780695d-06, 8.0695248457556d-02, 6.9188240849098d+00,
     |   6.5524862260979d+01, 1.0302471166683d+02,-2.0310352267357d+02,
     |  -2.7820944302705d+02, 4.2577730075461d+02, 1.4238188498215d+02,
     |  -5.5311785392499d+02, 3.5357777521662d+02, 1.8658800863977d+02,
     |  -5.4741201326358d+02, 4.4372822576001d+02, 9.1965985968377d+00,
     |  -4.4663930472984d+02, 5.4418733778142d+02,-2.3970890691837d+02,
     |  -2.3970890691838d+02, 5.4418733778142d+02,-4.4663930472984d+02,
     |   9.1965985968359d+00, 4.4372822576001d+02,-5.4741201326358d+02,
     |   1.8658800863976d+02, 3.5357777521662d+02,-5.5311785392499d+02,
     |   1.4238188498215d+02, 4.2577730075461d+02,-2.7820944302705d+02,
     |  -2.0310352267357d+02, 1.0302471166683d+02, 6.5524862260979d+01,
     |   6.9188240849100d+00, 8.0695248457556d-02, 1.8632405780695d-06/
      data (lpmn(lat,13,28), lat = 1,36)/
     |   9.4358066088585d-08, 1.2667828790661d-02, 1.9537344779629d+00,
     |   3.0390843254999d+01, 1.0141282645764d+02,-2.1347514207846d+01,
     |  -3.2888506184698d+02, 4.7209457125574d+01, 4.7689977322539d+02,
     |  -3.0792346748433d+02,-2.6486250984125d+02, 5.4384390355822d+02,
     |  -2.7400108610211d+02,-2.4563214759105d+02, 5.4064549986983d+02,
     |  -3.7546661874333d+02,-9.5731959692201d+01, 4.8634409290161d+02,
     |  -4.8634409290161d+02, 9.5731959692200d+01, 3.7546661874333d+02,
     |  -5.4064549986983d+02, 2.4563214759105d+02, 2.7400108610211d+02,
     |  -5.4384390355822d+02, 2.6486250984125d+02, 3.0792346748434d+02,
     |  -4.7689977322539d+02,-4.7209457125575d+01, 3.2888506184698d+02,
     |   2.1347514207847d+01,-1.0141282645764d+02,-3.0390843254999d+01,
     |  -1.9537344779630d+00,-1.2667828790661d-02,-9.4358066088584d-08/
      data (lpmn(lat,14,28), lat = 1,36)/
     |   4.2943729970290d-09, 1.7774616307177d-03, 4.8596528685893d-01,
     |   1.1922256953497d+01, 6.7277069804721d+01, 7.2625444974793d+01,
     |  -1.9342348292654d+02,-2.3981091291010d+02, 3.5496212069042d+02,
     |   2.0241623281670d+02,-5.0359842188331d+02, 1.6761182070008d+02,
     |   3.6063652225157d+02,-5.0987474111301d+02, 1.5964436882311d+02,
     |   3.3576565351954d+02,-5.2365684264180d+02, 2.4658996462627d+02,
     |   2.4658996462627d+02,-5.2365684264180d+02, 3.3576565351954d+02,
     |   1.5964436882311d+02,-5.0987474111301d+02, 3.6063652225158d+02,
     |   1.6761182070009d+02,-5.0359842188331d+02, 2.0241623281670d+02,
     |   3.5496212069042d+02,-2.3981091291010d+02,-1.9342348292654d+02,
     |   7.2625444974793d+01, 6.7277069804721d+01, 1.1922256953497d+01,
     |   4.8596528685894d-01, 1.7774616307177d-03, 4.2943729970290d-09/
      data (lpmn(lat,15,28), lat = 1,36)/
     |   1.7641472975826d-10, 2.2418730687438d-04, 1.0751805724308d-01,
     |   4.0549882308149d+00, 3.5345447926972d+01, 8.6657078755069d+01,
     |  -3.6499215217987d+01,-2.8586827207762d+02, 1.6293164608127d+01,
     |   4.3689501274894d+02,-1.7380137932936d+02,-3.6749891029444d+02,
     |   4.4710794128336d+02,-2.5263413717631d+00,-4.4432544844246d+02,
     |   4.2922915681979d+02, 1.4330421078153d+01,-4.4238448703388d+02,
     |   4.4238448703387d+02,-1.4330421078152d+01,-4.2922915681980d+02,
     |   4.4432544844246d+02, 2.5263413717645d+00,-4.4710794128336d+02,
     |   3.6749891029444d+02, 1.7380137932936d+02,-4.3689501274894d+02,
     |  -1.6293164608129d+01, 2.8586827207762d+02, 3.6499215217988d+01,
     |  -8.6657078755069d+01,-3.5345447926972d+01,-4.0549882308150d+00,
     |  -1.0751805724308d-01,-2.2418730687438d-04,-1.7641472975826d-10/
      data (lpmn(lat,16,28), lat = 1,36)/
     |   6.5615782118172d-12, 2.5518602810397d-05, 2.1299385951777d-02,
     |   1.2135359404208d+00, 1.5574501791917d+01, 6.3643905513861d+01,
     |   5.3229539315334d+01,-1.7116790306371d+02,-2.2146876113282d+02,
     |   2.7334792136039d+02, 2.6909643357894d+02,-4.1276765996132d+02,
     |  -4.9764616077461d+01, 4.5871201667279d+02,-3.1078930774194d+02,
     |  -1.9607685210619d+02, 4.8592401470620d+02,-2.5121663624579d+02,
     |  -2.5121663624579d+02, 4.8592401470620d+02,-1.9607685210619d+02,
     |  -3.1078930774194d+02, 4.5871201667279d+02,-4.9764616077465d+01,
     |  -4.1276765996132d+02, 2.6909643357894d+02, 2.7334792136039d+02,
     |  -2.2146876113282d+02,-1.7116790306371d+02, 5.3229539315334d+01,
     |   6.3643905513861d+01, 1.5574501791917d+01, 1.2135359404208d+00,
     |   2.1299385951777d-02, 2.5518602810397d-05, 6.5615782118172d-12/
      data (lpmn(lat,17,28), lat = 1,36)/
     |   2.2137106710379d-13, 2.6280126791734d-06, 3.7943690370642d-03,
     |   3.2251824505918d-01, 5.9181231676251d+00, 3.6170527867307d+01,
     |   7.3244491764656d+01,-3.5318757800378d+01,-2.4639489233382d+02,
     |  -3.3136688952476d+01, 3.8641650300958d+02,-1.5379909313041d+01,
     |  -4.2160545872920d+02, 2.4413821609871d+02, 2.7460130415659d+02,
     |  -4.4630743612305d+02, 6.9630746878392d+01, 3.9132613963272d+02,
     |  -3.9132613963272d+02,-6.9630746878393d+01, 4.4630743612306d+02,
     |  -2.7460130415659d+02,-2.4413821609871d+02, 4.2160545872920d+02,
     |   1.5379909313045d+01,-3.8641650300958d+02, 3.3136688952476d+01,
     |   2.4639489233382d+02, 3.5318757800379d+01,-7.3244491764657d+01,
     |  -3.6170527867307d+01,-5.9181231676251d+00,-3.2251824505918d-01,
     |  -3.7943690370644d-03,-2.6280126791734d-06,-2.2137106710379d-13/
      data (lpmn(lat,18,28), lat = 1,36)/
     |   6.7790782881360d-15, 2.4515207398655d-07, 6.0935604556717d-04,
     |   7.6548916756674d-02, 1.9692239400583d+00, 1.7049276653091d+01,
     |   5.6968548391757d+01, 4.3859173525399d+01,-1.3908327978173d+02,
     |  -2.1415715668707d+02, 1.7365267519531d+02, 3.2323034352633d+02,
     |  -2.5626730488014d+02,-2.6053922216865d+02, 3.9649862040226d+02,
     |   3.7205809328871d+01,-4.2612041819424d+02, 2.5178264390223d+02,
     |   2.5178264390223d+02,-4.2612041819424d+02, 3.7205809328868d+01,
     |   3.9649862040226d+02,-2.6053922216865d+02,-2.5626730488014d+02,
     |   3.2323034352633d+02, 1.7365267519531d+02,-2.1415715668707d+02,
     |  -1.3908327978173d+02, 4.3859173525398d+01, 5.6968548391757d+01,
     |   1.7049276653091d+01, 1.9692239400583d+00, 7.6548916756675d-02,
     |   6.0935604556719d-04, 2.4515207398655d-07, 6.7790782881359d-15/
      data (lpmn(lat,19,28), lat = 1,36)/
     |   1.8833887055932d-16, 2.0712209009506d-08, 8.8290964568998d-05,
     |   1.6273960298139d-02, 5.7875233628038d-01, 6.8724343568594d+00,
     |   3.3576085104792d+01, 6.2353077540539d+01,-2.1868452873351d+01,
     |  -2.0501519214060d+02,-9.3448902554751d+01, 3.0402663944747d+02,
     |   1.5193633357688d+02,-3.6942027393907d+02,-5.0225200154322d+01,
     |   4.0690312345671d+02,-1.4791949618156d+02,-3.3310687515799d+02,
     |   3.3310687515799d+02, 1.4791949618156d+02,-4.0690312345671d+02,
     |   5.0225200154321d+01, 3.6942027393906d+02,-1.5193633357688d+02,
     |  -3.0402663944747d+02, 9.3448902554751d+01, 2.0501519214060d+02,
     |   2.1868452873352d+01,-6.2353077540539d+01,-3.3576085104793d+01,
     |  -6.8724343568594d+00,-5.7875233628038d-01,-1.6273960298139d-02,
     |  -8.8290964569001d-05,-2.0712209009506d-08,-1.8833887055932d-16/
      data (lpmn(lat,20,28), lat = 1,36)/
     |   4.7385229332569d-18, 1.5824865776286d-09, 1.1532462440786d-05,
     |   3.1011512677512d-03, 1.5088237835956d-01, 2.4055739112482d+00,
     |   1.6211893619560d+01, 4.8618530810723d+01, 4.1900597078457d+01,
     |  -9.8073504234764d+01,-2.0457778321145d+02, 5.4244832434840d+01,
     |   3.2709137686577d+02,-3.1107695619271d+01,-3.6371610214155d+02,
     |   1.1709707404212d+02, 3.4079953435487d+02,-2.4587558864669d+02,
     |  -2.4587558864669d+02, 3.4079953435487d+02, 1.1709707404212d+02,
     |  -3.6371610214155d+02,-3.1107695619272d+01, 3.2709137686577d+02,
     |   5.4244832434843d+01,-2.0457778321145d+02,-9.8073504234765d+01,
     |   4.1900597078457d+01, 4.8618530810723d+01, 1.6211893619560d+01,
     |   2.4055739112482d+00, 1.5088237835956d-01, 3.1011512677513d-03,
     |   1.1532462440786d-05, 1.5824865776286d-09, 4.7385229332569d-18/
      data (lpmn(lat,21,28), lat = 1,36)/
     |   1.0760236950849d-19, 1.0899768748719d-10, 1.3544548511268d-06,
     |   5.2891468946489d-04, 3.4924728158381d-02, 7.3647495147927d-01,
     |   6.6180885450816d+00, 2.8362588038107d+01, 5.3219274396826d+01,
     |  -6.5863436836275d-01,-1.5427687147544d+02,-1.4757375155510d+02,
     |   1.7137911816644d+02, 2.7199576755554d+02,-1.6207669553402d+02,
     |  -2.9771215147592d+02, 2.0817810756915d+02, 2.6792512569010d+02,
     |  -2.6792512569010d+02,-2.0817810756915d+02, 2.9771215147592d+02,
     |   1.6207669553402d+02,-2.7199576755554d+02,-1.7137911816644d+02,
     |   1.4757375155510d+02, 1.5427687147544d+02, 6.5863436836307d-01,
     |  -5.3219274396826d+01,-2.8362588038107d+01,-6.6180885450816d+00,
     |  -7.3647495147927d-01,-3.4924728158381d-02,-5.2891468946490d-04,
     |  -1.3544548511269d-06,-1.0899768748719d-10,-1.0760236950849d-19/
      data (lpmn(lat,22,28), lat = 1,36)/
     |   2.1936326390314d-21, 6.7332407770247d-12, 1.4236167647795d-07,
     |   8.0425149766222d-05, 7.1617387382795d-03, 1.9754488795163d-01,
     |   2.3153003991544d+00, 1.3379227980001d+01, 3.8939674651205d+01,
     |   4.3007484055501d+01,-4.9914564751535d+01,-1.7486719120491d+02,
     |  -6.7671380662985d+01, 2.3327244509607d+02, 1.9127564528138d+02,
     |  -2.2512452497024d+02,-2.3045775405071d+02, 2.3016310496458d+02,
     |   2.3016310496458d+02,-2.3045775405071d+02,-2.2512452497024d+02,
     |   1.9127564528138d+02, 2.3327244509607d+02,-6.7671380662987d+01,
     |  -1.7486719120491d+02,-4.9914564751535d+01, 4.3007484055501d+01,
     |   3.8939674651205d+01, 1.3379227980001d+01, 2.3153003991544d+00,
     |   1.9754488795163d-01, 7.1617387382795d-03, 8.0425149766224d-05,
     |   1.4236167647796d-07, 6.7332407770247d-12, 2.1936326390314d-21/
      data (lpmn(lat,23,28), lat = 1,36)/
     |   3.9827771213926d-23, 3.7011846611179d-13, 1.3290249450715d-08,
     |   1.0827899011249d-05, 1.2936861000857d-03, 4.6280636090930d-02,
     |   6.9661303649237d-01, 5.2482921449221d+00, 2.1232130220008d+01,
     |   4.3596760031270d+01, 2.1558902980814d+01,-8.9330828621642d+01,
     |  -1.6463527202671d+02, 1.3863731279153d+00, 2.4695943746681d+02,
     |   1.2819259877812d+02,-2.3317132466447d+02,-1.9649770621225d+02,
     |   1.9649770621225d+02, 2.3317132466447d+02,-1.2819259877812d+02,
     |  -2.4695943746681d+02,-1.3863731279157d+00, 1.6463527202671d+02,
     |   8.9330828621643d+01,-2.1558902980814d+01,-4.3596760031270d+01,
     |  -2.1232130220008d+01,-5.2482921449221d+00,-6.9661303649238d-01,
     |  -4.6280636090930d-02,-1.2936861000857d-03,-1.0827899011249d-05,
     |  -1.3290249450715d-08,-3.7011846611179d-13,-3.9827771213926d-23/
      data (lpmn(lat,24,28), lat = 1,36)/
     |   6.3630933225265d-25, 1.7889525868727d-14, 1.0892636448325d-09,
     |   1.2764609990842d-06, 2.0376369723991d-04, 9.3907875839150d-03,
     |   1.7947124627036d-01, 1.7248154569546d+00, 9.1962411083467d+00,
     |   2.7718748212395d+01, 4.1159969879919d+01,-2.0810520872035d+00,
     |  -1.1010427447881d+02,-1.4054621861428d+02, 3.9802002079547d+01,
     |   2.3225859556191d+02, 1.0451815884966d+02,-1.9971499932992d+02,
     |  -1.9971499932992d+02, 1.0451815884966d+02, 2.3225859556191d+02,
     |   3.9802002079548d+01,-1.4054621861428d+02,-1.1010427447881d+02,
     |  -2.0810520872040d+00, 4.1159969879919d+01, 2.7718748212395d+01,
     |   9.1962411083468d+00, 1.7248154569546d+00, 1.7947124627036d-01,
     |   9.3907875839150d-03, 2.0376369723991d-04, 1.2764609990842d-06,
     |   1.0892636448326d-09, 1.7889525868727d-14, 6.3630933225265d-25/
      data (lpmn(lat,25,28), lat = 1,36)/
     |   8.7813242874563d-27, 7.4643167602579d-16, 7.6962505685451d-11,
     |   1.2943165280161d-07, 2.7509019537817d-05, 1.6244299281128d-03,
     |   3.9075490013970d-02, 4.7178205004139d-01, 3.2132912934986d+00,
     |   1.3030671761264d+01, 3.0924294274352d+01, 3.4362143481089d+01,
     |  -1.8671037416765d+01,-1.1223801862078d+02,-1.1931173146159d+02,
     |   4.1400985952310d+01, 2.0148276615566d+02, 1.2064749666099d+02,
     |  -1.2064749666099d+02,-2.0148276615566d+02,-4.1400985952311d+01,
     |   1.1931173146159d+02, 1.1223801862078d+02, 1.8671037416765d+01,
     |  -3.4362143481089d+01,-3.0924294274352d+01,-1.3030671761264d+01,
     |  -3.2132912934987d+00,-4.7178205004139d-01,-3.9075490013971d-02,
     |  -1.6244299281128d-03,-2.7509019537817d-05,-1.2943165280161d-07,
     |  -7.6962505685455d-11,-7.4643167602579d-16,-8.7813242874563d-27/
      data (lpmn(lat,26,28), lat = 1,36)/
     |   1.0152841059593d-28, 2.6078108933849d-17, 4.5479032518241d-12,
     |   1.0955222408466d-08, 3.0909340938198d-06, 2.3282645924196d-04,
     |   7.0009730651641d-03, 1.0500139790398d-01, 8.9510008876816d-01,
     |   4.6703061569685d+00, 1.5333971959525d+01, 3.0485191157829d+01,
     |   2.7812058931423d+01,-2.2368464856445d+01,-9.8946660612031d+01,
     |  -1.0776729353661d+02, 7.7666826810731d+00, 1.4602276862324d+02,
     |   1.4602276862324d+02, 7.7666826810732d+00,-1.0776729353661d+02,
     |  -9.8946660612031d+01,-2.2368464856445d+01, 2.7812058931423d+01,
     |   3.0485191157829d+01, 1.5333971959525d+01, 4.6703061569685d+00,
     |   8.9510008876817d-01, 1.0500139790398d-01, 7.0009730651642d-03,
     |   2.3282645924196d-04, 3.0909340938198d-06, 1.0955222408466d-08,
     |   4.5479032518243d-12, 2.6078108933849d-17, 1.0152841059593d-28/
      data (lpmn(lat,27,28), lat = 1,36)/
     |   9.2864936196453d-31, 7.2042236341269d-19, 2.1228724506868d-13,
     |   7.3123603214691d-10, 2.7319174413483d-07, 2.6152538806461d-05,
     |   9.7757840777641d-04, 1.8056785543403d-02, 1.8990427951267d-01,
     |   1.2408998957639d+00, 5.2951666655199d+00, 1.4982732566314d+01,
     |   2.7036992748700d+01, 2.4715250722481d+01,-1.1462288792954d+01,
     |  -6.9531289055326d+01,-9.4792477925535d+01,-4.5157402241204d+01,
     |   4.5157402241204d+01, 9.4792477925535d+01, 6.9531289055326d+01,
     |   1.1462288792954d+01,-2.4715250722481d+01,-2.7036992748700d+01,
     |  -1.4982732566314d+01,-5.2951666655199d+00,-1.2408998957639d+00,
     |  -1.8990427951267d-01,-1.8056785543403d-02,-9.7757840777642d-04,
     |  -2.6152538806461d-05,-2.7319174413483d-07,-7.3123603214694d-10,
     |  -2.1228724506869d-13,-7.2042236341269d-19,-9.2864936196453d-31/
      data (lpmn(lat,28,28), lat = 1,36)/
     |   5.8277927199819d-33, 1.3648966337684d-20, 6.7896551091524d-15,
     |   3.3394379258898d-11, 1.6484836991310d-08, 1.9992722399205d-06,
     |   9.2478126709607d-05, 2.0893969574121d-03, 2.6822425780292d-02,
     |   2.1556843547197d-01, 1.1548980113568d+00, 4.2843063485876d+00,
     |   1.1175815724772d+01, 2.0184079502758d+01, 2.3044701967063d+01,
     |   9.3580973258950d+00,-1.9706184527360d+01,-4.4888218520848d+01,
     |  -4.4888218520848d+01,-1.9706184527361d+01, 9.3580973258949d+00,
     |   2.3044701967063d+01, 2.0184079502758d+01, 1.1175815724772d+01,
     |   4.2843063485876d+00, 1.1548980113568d+00, 2.1556843547197d-01,
     |   2.6822425780292d-02, 2.0893969574121d-03, 9.2478126709608d-05,
     |   1.9992722399205d-06, 1.6484836991310d-08, 3.3394379258900d-11,
     |   6.7896551091528d-15, 1.3648966337684d-20, 5.8277927199819d-33/
      data (lpmn(lat, 0,29), lat = 1,36)/
     |  -2.9619540248033d+03, 1.9050272105747d+03,-1.1846473961355d+03,
     |   4.4265961563590d+02, 2.3000464095171d+02,-7.1213827352643d+02,
     |   9.2110893741514d+02,-8.4071679946239d+02, 5.2548462611383d+02,
     |  -8.4882970098057d+01,-3.4692150373936d+02, 6.4718865410149d+02,
     |  -7.3676664095873d+02, 5.9972425568018d+02,-2.8538238552482d+02,
     |  -1.0751583741134d+02, 4.5992021517795d+02,-6.6673314102935d+02,
     |   6.6673314102935d+02,-4.5992021517794d+02, 1.0751583741133d+02,
     |   2.8538238552482d+02,-5.9972425568018d+02, 7.3676664095873d+02,
     |  -6.4718865410149d+02, 3.4692150373936d+02, 8.4882970098060d+01,
     |  -5.2548462611384d+02, 8.4071679946239d+02,-9.2110893741514d+02,
     |   7.1213827352643d+02,-2.3000464095171d+02,-4.4265961563591d+02,
     |   1.1846473961355d+03,-1.9050272105747d+03, 2.9619540248033d+03/
      data (lpmn(lat, 1,29), lat = 1,36)/
     |  -9.7130881234223d+02, 5.1834073222031d+01, 7.9622164440646d+02,
     |  -1.1484030783689d+03, 1.0996579457947d+03,-7.5160283282622d+02,
     |   2.4258014910228d+02, 2.7131483616543d+02,-6.4991659829643d+02,
     |   8.0116892548083d+02,-7.0125121772586d+02, 3.9681831281974d+02,
     |   1.1191216050833d+01,-3.9762578341996d+02, 6.4878737598724d+02,
     |  -6.9397693084305d+02, 5.2441303249051d+02,-1.9452613329165d+02,
     |  -1.9452613329165d+02, 5.2441303249052d+02,-6.9397693084305d+02,
     |   6.4878737598724d+02,-3.9762578341995d+02, 1.1191216050840d+01,
     |   3.9681831281975d+02,-7.0125121772586d+02, 8.0116892548083d+02,
     |  -6.4991659829643d+02, 2.7131483616543d+02, 2.4258014910229d+02,
     |  -7.5160283282622d+02, 1.0996579457947d+03,-1.1484030783689d+03,
     |   7.9622164440644d+02, 5.1834073222031d+01,-9.7130881234223d+02/
      data (lpmn(lat, 2,29), lat = 1,36)/
     |   1.2031585287433d+03,-1.3716035086929d+03, 1.2950212788260d+03,
     |  -6.5833895298851d+02,-4.7097047183823d+01, 6.0116515853869d+02,
     |  -8.8194433020185d+02, 8.5502134904634d+02,-5.6857318588784d+02,
     |   1.3378150763660d+02, 3.0845647491117d+02,-6.2666784178694d+02,
     |   7.3369835514319d+02,-6.0831609514763d+02, 2.9810062665310d+02,
     |   9.6714158684347d+01,-4.5362576966574d+02, 6.6385144379539d+02,
     |  -6.6385144379538d+02, 4.5362576966574d+02,-9.6714158684339d+01,
     |  -2.9810062665310d+02, 6.0831609514763d+02,-7.3369835514319d+02,
     |   6.2666784178693d+02,-3.0845647491117d+02,-1.3378150763661d+02,
     |   5.6857318588785d+02,-8.5502134904634d+02, 8.8194433020184d+02,
     |  -6.0116515853869d+02, 4.7097047183823d+01, 6.5833895298853d+02,
     |  -1.2950212788260d+03, 1.3716035086929d+03,-1.2031585287432d+03/
      data (lpmn(lat, 3,29), lat = 1,36)/
     |   8.3519306984979d+02,-7.8462405711871d+02, 4.9316820462553d+01,
     |   7.6738564601588d+02,-1.0472917321682d+03, 8.7349717437812d+02,
     |  -4.1994407092532d+02,-1.1591955239334d+02, 5.5489842090649d+02,
     |  -7.7290403862454d+02, 7.2449791062819d+02,-4.4647249461823d+02,
     |   4.0507649889662d+01, 3.6018877411616d+02,-6.3099573784517d+02,
     |   6.9176296280078d+02,-5.2878193592941d+02, 1.9709899261296d+02,
     |   1.9709899261296d+02,-5.2878193592941d+02, 6.9176296280078d+02,
     |  -6.3099573784517d+02, 3.6018877411616d+02, 4.0507649889654d+01,
     |  -4.4647249461824d+02, 7.2449791062819d+02,-7.7290403862454d+02,
     |   5.5489842090649d+02,-1.1591955239333d+02,-4.1994407092533d+02,
     |   8.7349717437812d+02,-1.0472917321682d+03, 7.6738564601587d+02,
     |   4.9316820462569d+01,-7.8462405711871d+02, 8.3519306984979d+02/
      data (lpmn(lat, 4,29), lat = 1,36)/
     |   2.6623211891002d+02, 9.7156375258011d+01,-8.3974952379685d+02,
     |   1.0029141451580d+03,-4.4462296776053d+02,-2.3329881981564d+02,
     |   7.1093247022389d+02,-8.5592360850924d+02, 6.7494459373066d+02,
     |  -2.7369656788556d+02,-1.9030583536419d+02, 5.5898780389244d+02,
     |  -7.1900149120763d+02, 6.3079047697766d+02,-3.3496985765150d+02,
     |  -6.4494796714430d+01, 4.3464968880519d+02,-6.5517153896820d+02,
     |   6.5517153896820d+02,-4.3464968880519d+02, 6.4494796714423d+01,
     |   3.3496985765150d+02,-6.3079047697766d+02, 7.1900149120763d+02,
     |  -5.5898780389243d+02, 1.9030583536419d+02, 2.7369656788556d+02,
     |  -6.7494459373066d+02, 8.5592360850923d+02,-7.1093247022389d+02,
     |   2.3329881981564d+02, 4.4462296776053d+02,-1.0029141451580d+03,
     |   8.3974952379685d+02,-9.7156375258011d+01,-2.6623211891002d+02/
      data (lpmn(lat, 5,29), lat = 1,36)/
     |   5.5904947379709d+01, 3.7193528327942d+02,-6.8610193309250d+02,
     |   1.5354303225212d+02, 6.3928019788097d+02,-9.1448490789572d+02,
     |   6.8853126648706d+02,-1.8657165550990d+02,-3.3717827155474d+02,
     |   6.8228818124957d+02,-7.4566635956269d+02, 5.3305794127060d+02,
     |  -1.4105508534864d+02,-2.8317990761590d+02, 5.9234838160339d+02,
     |  -6.8533350340108d+02, 5.3675243465654d+02,-2.0210373959048d+02,
     |  -2.0210373959048d+02, 5.3675243465654d+02,-6.8533350340108d+02,
     |   5.9234838160339d+02,-2.8317990761590d+02,-1.4105508534863d+02,
     |   5.3305794127061d+02,-7.4566635956269d+02, 6.8228818124956d+02,
     |  -3.3717827155474d+02,-1.8657165550991d+02, 6.8853126648707d+02,
     |  -9.1448490789572d+02, 6.3928019788097d+02, 1.5354303225213d+02,
     |  -6.8610193309251d+02, 3.7193528327942d+02, 5.5904947379709d+01/
      data (lpmn(lat, 6,29), lat = 1,36)/
     |   8.7559180810597d+00, 2.7086521127630d+02,-1.6003802868772d+02,
     |  -5.5331416847722d+02, 8.4228056981136d+02,-3.5758846970173d+02,
     |  -2.9956295739048d+02, 7.2401443178596d+02,-7.6652480867629d+02,
     |   4.7368708926340d+02,-9.0290678561881d+00,-4.2864892781735d+02,
     |   6.7671752092699d+02,-6.5691893384414d+02, 3.9178150992414d+02,
     |   1.1576559309450d+01,-4.0275020405331d+02, 6.4059032838386d+02,
     |  -6.4059032838386d+02, 4.0275020405331d+02,-1.1576559309443d+01,
     |  -3.9178150992414d+02, 6.5691893384414d+02,-6.7671752092699d+02,
     |   4.2864892781734d+02, 9.0290678561881d+00,-4.7368708926340d+02,
     |   7.6652480867629d+02,-7.2401443178596d+02, 2.9956295739047d+02,
     |   3.5758846970173d+02,-8.4228056981136d+02, 5.5331416847721d+02,
     |   1.6003802868773d+02,-2.7086521127630d+02,-8.7559180810596d+00/
      data (lpmn(lat, 7,29), lat = 1,36)/
     |   1.0907587313469d+00, 1.2668477508252d+02, 1.6023878546264d+02,
     |  -5.9436178718586d+02, 2.3440762657437d+02, 5.2179523801945d+02,
     |  -8.0415593017915d+02, 5.4838370187981d+02,-1.8583987328546d+01,
     |  -4.7476505061314d+02, 7.1374213480763d+02,-6.2654962056365d+02,
     |   2.8086800167747d+02, 1.6429738413134d+02,-5.2731196297074d+02,
     |   6.7073539310473d+02,-5.4675992363231d+02, 2.0925158778558d+02,
     |   2.0925158778558d+02,-5.4675992363231d+02, 6.7073539310473d+02,
     |  -5.2731196297074d+02, 1.6429738413134d+02, 2.8086800167746d+02,
     |  -6.2654962056365d+02, 7.1374213480763d+02,-4.7476505061314d+02,
     |  -1.8583987328550d+01, 5.4838370187981d+02,-8.0415593017915d+02,
     |   5.2179523801945d+02, 2.3440762657437d+02,-5.9436178718586d+02,
     |   1.6023878546264d+02, 1.2668477508252d+02, 1.0907587313469d+00/
      data (lpmn(lat, 8,29), lat = 1,36)/
     |   1.1242213352867d-01, 4.5043221871428d+01, 2.1118254788613d+02,
     |  -2.6549153242278d+02,-3.6471082134336d+02, 7.3090619444338d+02,
     |  -3.1062777301996d+02,-3.2738001628664d+02, 7.0361742973709d+02,
     |  -6.5304780892902d+02, 2.6926611287946d+02, 2.2084045915284d+02,
     |  -5.8299179302481d+02, 6.6896147093576d+02,-4.6042424339139d+02,
     |   6.0299977509268d+01, 3.5765026984843d+02,-6.1994066166970d+02,
     |   6.1994066166969d+02,-3.5765026984843d+02,-6.0299977509275d+01,
     |   4.6042424339139d+02,-6.6896147093576d+02, 5.8299179302481d+02,
     |  -2.2084045915284d+02,-2.6926611287946d+02, 6.5304780892902d+02,
     |  -7.0361742973709d+02, 3.2738001628664d+02, 3.1062777301996d+02,
     |  -7.3090619444338d+02, 3.6471082134336d+02, 2.6549153242278d+02,
     |  -2.1118254788613d+02,-4.5043221871428d+01,-1.1242213352867d-01/
      data (lpmn(lat, 9,29), lat = 1,36)/
     |   9.8445461769435d-03, 1.3028404894620d+01, 1.4410621475495d+02,
     |   2.8625199511497d+01,-5.0512562228249d+02, 2.8052566954447d+02,
     |   4.3253598887024d+02,-7.1478621871447d+02, 4.2976019359028d+02,
     |   1.1846087735102d+02,-5.6168431855777d+02, 6.7450891260421d+02,
     |  -4.3656939444827d+02,-5.2685650432051d+00, 4.2931199464026d+02,
     |  -6.4223957822421d+02, 5.5639065880822d+02,-2.1809164262627d+02,
     |  -2.1809164262627d+02, 5.5639065880822d+02,-6.4223957822421d+02,
     |   4.2931199464026d+02,-5.2685650432034d+00,-4.3656939444826d+02,
     |   6.7450891260421d+02,-5.6168431855777d+02, 1.1846087735102d+02,
     |   4.2976019359028d+02,-7.1478621871447d+02, 4.3253598887024d+02,
     |   2.8052566954447d+02,-5.0512562228249d+02, 2.8625199511495d+01,
     |   1.4410621475495d+02, 1.3028404894620d+01, 9.8445461769435d-03/
      data (lpmn(lat,10,29), lat = 1,36)/
     |   7.4640638604789d-04, 3.1804762573919d+00, 7.2295588816687d+01,
     |   1.4492198555281d+02,-3.0472599637460d+02,-2.3607011855488d+02,
     |   6.4248014949380d+02,-2.6811659013285d+02,-3.5066740982560d+02,
     |   6.6895590997793d+02,-5.1854674335903d+02, 5.8284858227481d+01,
     |   4.1360781813830d+02,-6.4210607253070d+02, 5.2756335727918d+02,
     |  -1.4755741230432d+02,-2.9924165896375d+02, 5.9299913510557d+02,
     |  -5.9299913510556d+02, 2.9924165896375d+02, 1.4755741230432d+02,
     |  -5.2756335727918d+02, 6.4210607253070d+02,-4.1360781813831d+02,
     |  -5.8284858227490d+01, 5.1854674335903d+02,-6.6895590997792d+02,
     |   3.5066740982560d+02, 2.6811659013285d+02,-6.4248014949380d+02,
     |   2.3607011855488d+02, 3.0472599637460d+02,-1.4492198555281d+02,
     |  -7.2295588816689d+01,-3.1804762573919d+00,-7.4640638604789d-04/
      data (lpmn(lat,11,29), lat = 1,36)/
     |   4.9689656964935d-05, 6.7063383441128d-01, 2.9345731634869d+01,
     |   1.3513049655078d+02,-5.4126104699029d+01,-4.2358767077533d+02,
     |   2.9481017362023d+02, 3.7458983419288d+02,-6.3828747180456d+02,
     |   3.1190237387426d+02, 2.4512506316400d+02,-6.0665850670457d+02,
     |   5.6355331851616d+02,-1.8163371184310d+02,-2.9342269413668d+02,
     |   5.9280437356520d+02,-5.6232683350357d+02, 2.2798779847182d+02,
     |   2.2798779847182d+02,-5.6232683350357d+02, 5.9280437356520d+02,
     |  -2.9342269413668d+02,-1.8163371184310d+02, 5.6355331851616d+02,
     |  -6.0665850670457d+02, 2.4512506316400d+02, 3.1190237387426d+02,
     |  -6.3828747180456d+02, 3.7458983419288d+02, 2.9481017362024d+02,
     |  -4.2358767077533d+02,-5.4126104699030d+01, 1.3513049655078d+02,
     |   2.9345731634870d+01, 6.7063383441128d-01, 4.9689656964935d-05/
      data (lpmn(lat,12,29), lat = 1,36)/
     |   2.9353795186087d-06, 1.2408912907473d-01, 1.0069881476764d+01,
     |   8.5234383427590d+01, 8.6777435134029d+01,-3.0769230269687d+02,
     |  -1.5367001168655d+02, 5.6845180960871d+02,-2.1395732622308d+02,
     |  -3.8242828808005d+02, 6.1859837141196d+02,-3.5265823843360d+02,
     |  -1.6025047556046d+02, 5.4831586136964d+02,-5.7364679467018d+02,
     |   2.4367883118683d+02, 2.2790101908902d+02,-5.5949875578286d+02,
     |   5.5949875578286d+02,-2.2790101908902d+02,-2.4367883118683d+02,
     |   5.7364679467018d+02,-5.4831586136964d+02, 1.6025047556047d+02,
     |   3.5265823843361d+02,-6.1859837141196d+02, 3.8242828808004d+02,
     |   2.1395732622309d+02,-5.6845180960871d+02, 1.5367001168655d+02,
     |   3.0769230269687d+02,-8.6777435134029d+01,-8.5234383427590d+01,
     |  -1.0069881476764d+01,-1.2408912907473d-01,-2.9353795186087d-06/
      data (lpmn(lat,13,29), lat = 1,36)/
     |   1.5512724242263d-07, 2.0377284251787d-02, 2.9947758567149d+00,
     |   4.2552347722215d+01, 1.1456523291021d+02,-1.0089405555557d+02,
     |  -3.5530254228732d+02, 2.8207685851754d+02, 3.4710272935938d+02,
     |  -5.6467504827253d+02, 1.7875693341149d+02, 3.6613564711476d+02,
     |  -5.9560371556052d+02, 3.6587559329413d+02, 1.2077275447828d+02,
     |  -5.1508781300657d+02, 5.6032364897922d+02,-2.3808435700835d+02,
     |  -2.3808435700835d+02, 5.6032364897922d+02,-5.1508781300657d+02,
     |   1.2077275447828d+02, 3.6587559329413d+02,-5.9560371556052d+02,
     |   3.6613564711476d+02, 1.7875693341149d+02,-5.6467504827253d+02,
     |   3.4710272935938d+02, 2.8207685851754d+02,-3.5530254228732d+02,
     |  -1.0089405555557d+02, 1.1456523291021d+02, 4.2552347722215d+01,
     |   2.9947758567150d+00, 2.0377284251787d-02, 1.5512724242263d-07/
      data (lpmn(lat,14,29), lat = 1,36)/
     |   7.3795503206526d-09, 2.9944662310633d-03, 7.8421641957225d-01,
     |   1.7820658127884d+01, 8.6674372371309d+01, 4.3004848442080d+01,
     |  -2.9057386979187d+02,-1.1005320376362d+02, 5.0421009636488d+02,
     |  -1.3933566485253d+02,-4.2271645709704d+02, 5.3725054960517d+02,
     |  -1.4369420441451d+02,-3.6690431030824d+02, 5.7355028084374d+02,
     |  -3.3796580586778d+02,-1.4494708381242d+02, 5.1914873790561d+02,
     |  -5.1914873790561d+02, 1.4494708381242d+02, 3.3796580586779d+02,
     |  -5.7355028084374d+02, 3.6690431030824d+02, 1.4369420441451d+02,
     |  -5.3725054960517d+02, 4.2271645709704d+02, 1.3933566485253d+02,
     |  -5.0421009636488d+02, 1.1005320376362d+02, 2.9057386979188d+02,
     |  -4.3004848442080d+01,-8.6674372371309d+01,-1.7820658127884d+01,
     |  -7.8421641957227d-01,-2.9944662310633d-03,-7.3795503206525d-09/
      data (lpmn(lat,15,29), lat = 1,36)/
     |   3.1748329937013d-10, 3.9618470752550d-04, 1.8275563541361d-01,
     |   6.4471690904138d+00, 5.0022346495202d+01, 9.1852670002571d+01,
     |  -1.2025686537147d+02,-3.0332892872149d+02, 2.4584735485740d+02,
     |   3.4571305452862d+02,-4.7987458377233d+02, 2.0166473929576d+01,
     |   4.6535990877266d+02,-4.9393659204060d+02, 7.5283655453308d+01,
     |   4.0337391373356d+02,-5.4528020762705d+02, 2.4725603129439d+02,
     |   2.4725603129439d+02,-5.4528020762705d+02, 4.0337391373356d+02,
     |   7.5283655453310d+01,-4.9393659204060d+02, 4.6535990877266d+02,
     |   2.0166473929582d+01,-4.7987458377233d+02, 3.4571305452862d+02,
     |   2.4584735485740d+02,-3.0332892872149d+02,-1.2025686537147d+02,
     |   9.1852670002571d+01, 5.0022346495202d+01, 6.4471690904139d+00,
     |   1.8275563541361d-01, 3.9618470752550d-04, 3.1748329937013d-10/
      data (lpmn(lat,16,29), lat = 1,36)/
     |   1.2394728176836d-11, 4.7401117806359d-05, 3.8182327493024d-02,
     |   2.0498506451576d+00, 2.3875293009352d+01, 8.0979121512687d+01,
     |   1.5641834236044d+01,-2.6294415508462d+02,-9.9182350533465d+01,
     |   4.4300141353466d+02,-3.8986559049546d+01,-4.5771771317382d+02,
     |   3.9902288941416d+02, 1.0442320924906d+02,-5.0106431683388d+02,
     |   4.1454388111558d+02, 5.3272509412949d+01,-4.7166536473491d+02,
     |   4.7166536473491d+02,-5.3272509412947d+01,-4.1454388111559d+02,
     |   5.0106431683388d+02,-1.0442320924905d+02,-3.9902288941415d+02,
     |   4.5771771317382d+02, 3.8986559049546d+01,-4.4300141353466d+02,
     |   9.9182350533463d+01, 2.6294415508462d+02,-1.5641834236044d+01,
     |  -8.0979121512686d+01,-2.3875293009352d+01,-2.0498506451576d+00,
     |  -3.8182327493025d-02,-4.7401117806359d-05,-1.2394728176836d-11/
      data (lpmn(lat,17,29), lat = 1,36)/
     |   4.4011302166923d-13, 5.1438752530937d-06, 7.1875918898585d-03,
     |   5.7897700698814d-01, 9.7689357958137d+00, 5.1827299749024d+01,
     |   7.2708777024678d+01,-1.1881350088916d+02,-2.6700289788919d+02,
     |   1.8714688050014d+02, 3.6011088078317d+02,-3.6420994271956d+02,
     |  -1.6023949603091d+02, 4.9705414462411d+02,-2.6253088511455d+02,
     |  -2.5683529289949d+02, 5.1151141482793d+02,-2.5403450703605d+02,
     |  -2.5403450703606d+02, 5.1151141482793d+02,-2.5683529289949d+02,
     |  -2.6253088511455d+02, 4.9705414462411d+02,-1.6023949603091d+02,
     |  -3.6420994271957d+02, 3.6011088078317d+02, 1.8714688050014d+02,
     |  -2.6700289788919d+02,-1.1881350088917d+02, 7.2708777024678d+01,
     |   5.1827299749024d+01, 9.7689357958137d+00, 5.7897700698815d-01,
     |   7.1875918898587d-03, 5.1438752530937d-06, 4.4011302166923d-13/
      data (lpmn(lat,18,29), lat = 1,36)/
     |   1.4230873992701d-14, 5.0718240350166d-07, 1.2229601002877d-03,
     |   1.4626908442616d-01, 3.4931269054152d+00, 2.6927374042892d+01,
     |   7.2086849753938d+01, 4.0570784933712d+00,-2.2917321883776d+02,
     |  -1.1436763046774d+02, 3.7283736077524d+02, 8.6048176845781d+01,
     |  -4.5452630387917d+02, 1.7951666846834d+02, 3.4015914166576d+02,
     |  -4.5245720280600d+02, 4.1821137781782d+01, 4.1682099885416d+02,
     |  -4.1682099885416d+02,-4.1821137781784d+01, 4.5245720280600d+02,
     |  -3.4015914166576d+02,-1.7951666846834d+02, 4.5452630387917d+02,
     |  -8.6048176845777d+01,-3.7283736077524d+02, 1.1436763046774d+02,
     |   2.2917321883776d+02,-4.0570784933703d+00,-7.2086849753938d+01,
     |  -2.6927374042892d+01,-3.4931269054152d+00,-1.4626908442617d-01,
     |  -1.2229601002877d-03,-5.0718240350166d-07,-1.4230873992701d-14/
      data (lpmn(lat,19,29), lat = 1,36)/
     |   4.1909826410326d-16, 4.5463448861995d-08, 1.8838726771181d-04,
     |   3.3186630921934d-02, 1.1037074776779d+00, 1.1864036340723d+01,
     |   4.9193834566888d+01, 5.9691164611333d+01,-1.0133442012916d+02,
     |  -2.4109154923317d+02, 1.0548678663647d+02, 3.6935966726957d+02,
     |  -1.9718948366180d+02,-3.2597581442930d+02, 3.8717025885915d+02,
     |   8.4426859558863d+01,-4.5340747468114d+02, 2.5649648450202d+02,
     |   2.5649648450202d+02,-4.5340747468114d+02, 8.4426859558859d+01,
     |   3.8717025885915d+02,-3.2597581442930d+02,-1.9718948366179d+02,
     |   3.6935966726957d+02, 1.0548678663647d+02,-2.4109154923317d+02,
     |  -1.0133442012916d+02, 5.9691164611333d+01, 4.9193834566888d+01,
     |   1.1864036340723d+01, 1.1037074776779d+00, 3.3186630921935d-02,
     |   1.8838726771182d-04, 4.5463448861995d-08, 4.1909826410326d-16/
      data (lpmn(lat,20,29), lat = 1,36)/
     |   1.1230956022988d-17, 3.7027153757730d-09, 2.6276823906611d-05,
     |   6.7750218445291d-03, 3.1006747126381d-01, 4.5280795544654d+00,
     |   2.6718782147563d+01, 6.2528845633158d+01, 5.8420573044402d+00,
     |  -1.8895449116767d+02,-1.4556130487238d+02, 2.7654751232184d+02,
     |   2.1738202295206d+02,-3.6061456041722d+02,-1.0511052630823d+02,
     |   4.2847904408607d+02,-1.3158571792769d+02,-3.5452488229544d+02,
     |   3.5452488229544d+02, 1.3158571792769d+02,-4.2847904408607d+02,
     |   1.0511052630823d+02, 3.6061456041722d+02,-2.1738202295206d+02,
     |  -2.7654751232185d+02, 1.4556130487238d+02, 1.8895449116767d+02,
     |  -5.8420573044401d+00,-6.2528845633158d+01,-2.6718782147563d+01,
     |  -4.5280795544654d+00,-3.1006747126381d-01,-6.7750218445292d-03,
     |  -2.6276823906612d-05,-3.7027153757730d-09,-1.1230956022988d-17/
      data (lpmn(lat,21,29), lat = 1,36)/
     |   2.7327256554726d-19, 2.7346785360194d-10, 3.3143736136832d-06,
     |   1.2444033021657d-03, 7.7663935660922d-02, 1.5135041010759d+00,
     |   1.2145604143599d+01, 4.3429759545020d+01, 5.2567849623715d+01,
     |  -7.1157831008058d+01,-2.1498203525516d+02, 4.1289329687843d+00,
     |   3.3751268019699d+02, 2.0892440456260d+01,-3.8484883796445d+02,
     |   8.8961543953281d+01, 3.6681396776505d+02,-2.5208119470527d+02,
     |  -2.5208119470527d+02, 3.6681396776505d+02, 8.8961543953284d+01,
     |  -3.8484883796445d+02, 2.0892440456259d+01, 3.3751268019699d+02,
     |   4.1289329687867d+00,-2.1498203525516d+02,-7.1157831008059d+01,
     |   5.2567849623715d+01, 4.3429759545020d+01, 1.2145604143599d+01,
     |   1.5135041010759d+00, 7.7663935660921d-02, 1.2444033021657d-03,
     |   3.3143736136834d-06, 2.7346785360194d-10, 2.7327256554726d-19/
      data (lpmn(lat,22,29), lat = 1,36)/
     |   6.0154431178240d-21, 1.8252345476513d-11, 3.7690829669101d-07,
     |   2.0521836260654d-04, 1.7341919705466d-02, 4.4516739025098d-01,
     |   4.7240113119883d+00, 2.3594689523314d+01, 5.3018953481682d+01,
     |   1.6928142108470d+01,-1.3876478508779d+02,-1.7480505546100d+02,
     |   1.3992542015917d+02, 3.0129107233824d+02,-1.3464669879330d+02,
     |  -3.2546570839346d+02, 2.0267910187706d+02, 2.8496474325433d+02,
     |  -2.8496474325433d+02,-2.0267910187706d+02, 3.2546570839346d+02,
     |   1.3464669879330d+02,-3.0129107233824d+02,-1.3992542015916d+02,
     |   1.7480505546100d+02, 1.3876478508779d+02,-1.6928142108470d+01,
     |  -5.3018953481682d+01,-2.3594689523314d+01,-4.7240113119883d+00,
     |  -4.4516739025098d-01,-1.7341919705466d-02,-2.0521836260654d-04,
     |  -3.7690829669103d-07,-1.8252345476513d-11,-6.0154431178240d-21/
      data (lpmn(lat,23,29), lat = 1,36)/
     |   1.1912692892432d-22, 1.0949747398834d-12, 3.8448571378225d-08,
     |   3.0254389672624d-05, 3.4420257750519d-03, 1.1524771802995d-01,
     |   1.5868204307300d+00, 1.0563316385267d+01, 3.5343079642151d+01,
     |   4.8564630176361d+01,-3.2088674995811d+01,-1.7332506496111d+02,
     |  -9.7910165160589d+01, 2.2206394727950d+02, 2.2152644459084d+02,
     |  -2.1755089499191d+02,-2.5176198398942d+02, 2.3725934545017d+02,
     |   2.3725934545017d+02,-2.5176198398942d+02,-2.1755089499191d+02,
     |   2.2152644459084d+02, 2.2206394727950d+02,-9.7910165160590d+01,
     |  -1.7332506496111d+02,-3.2088674995811d+01, 4.8564630176361d+01,
     |   3.5343079642151d+01, 1.0563316385267d+01, 1.5868204307300d+00,
     |   1.1524771802995d-01, 3.4420257750519d-03, 3.0254389672625d-05,
     |   3.8448571378226d-08, 1.0949747398834d-12, 1.1912692892431d-22/
      data (lpmn(lat,24,29), lat = 1,36)/
     |   2.1049732147227d-24, 5.8565464556549d-14, 3.4909268698494d-09,
     |   3.9584315092635d-06, 6.0348885067045d-04, 2.6154529839616d-02,
     |   4.6091180616081d-01, 3.9739636284435d+00, 1.8174507097746d+01,
     |   4.2593599976858d+01, 3.0757535865933d+01,-7.6403531268026d+01,
     |  -1.7275314234130d+02,-2.2603099771452d+01, 2.4882650382405d+02,
     |   1.5048409687554d+02,-2.3627621512396d+02,-2.0888047669308d+02,
     |   2.0888047669308d+02, 2.3627621512396d+02,-1.5048409687554d+02,
     |  -2.4882650382405d+02, 2.2603099771451d+01, 1.7275314234130d+02,
     |   7.6403531268027d+01,-3.0757535865933d+01,-4.2593599976858d+01,
     |  -1.8174507097746d+01,-3.9739636284435d+00,-4.6091180616082d-01,
     |  -2.6154529839616d-02,-6.0348885067045d-04,-3.9584315092636d-06,
     |  -3.4909268698496d-09,-5.8565464556549d-14,-2.1049732147227d-24/
      data (lpmn(lat,25,29), lat = 1,36)/
     |   3.2785158044557d-26, 2.7591579189669d-15, 2.7878253431447d-10,
     |   4.5442104733870d-07, 9.2479470163318d-05, 5.1560445400085d-03,
     |   1.1510675406961d-01, 1.2609162895207d+00, 7.5367388373165d+00,
     |   2.5291124588086d+01, 4.2790034215392d+01, 7.5493919177047d+00,
     |  -1.0340778449531d+02,-1.5198404226271d+02, 2.4595552646373d+01,
     |   2.3920678818888d+02, 1.1789173438832d+02,-2.0681994709649d+02,
     |  -2.0681994709649d+02, 1.1789173438832d+02, 2.3920678818888d+02,
     |   2.4595552646373d+01,-1.5198404226271d+02,-1.0340778449531d+02,
     |   7.5493919177042d+00, 4.2790034215392d+01, 2.5291124588086d+01,
     |   7.5367388373166d+00, 1.2609162895207d+00, 1.1510675406961d-01,
     |   5.1560445400085d-03, 9.2479470163318d-05, 4.5442104733872d-07,
     |   2.7878253431448d-10, 2.7591579189669d-15, 3.2785158044557d-26/
      data (lpmn(lat,26,29), lat = 1,36)/
     |   4.4175513304813d-28, 1.1238967213780d-16, 1.9224560572167d-11,
     |   4.4951950712351d-08, 1.2172065357793d-05, 8.6866849872031d-04,
     |   2.4371422081516d-02, 3.3454897040690d-01, 2.5426785462109d+00,
     |   1.1361124085868d+01, 2.9606505767440d+01, 3.7479724447246d+01,
     |  -1.0936095686784d+01,-1.1016833277188d+02,-1.2951462253042d+02,
     |   3.3248570440931d+01, 2.0872189946161d+02, 1.2818824493017d+02,
     |  -1.2818824493017d+02,-2.0872189946161d+02,-3.3248570440932d+01,
     |   1.2951462253042d+02, 1.1016833277188d+02, 1.0936095686784d+01,
     |  -3.7479724447246d+01,-2.9606505767440d+01,-1.1361124085868d+01,
     |  -2.5426785462110d+00,-3.3454897040691d-01,-2.4371422081516d-02,
     |  -8.6866849872031d-04,-1.2172065357793d-05,-4.4951950712352d-08,
     |  -1.9224560572168d-11,-1.1238967213780d-16,-4.4175513304813d-28/
      data (lpmn(lat,27,29), lat = 1,36)/
     |   4.9937309358436d-30, 3.8387375791888d-18, 1.1104027608834d-12,
     |   3.7177886710541d-09, 1.3357615324218d-06, 1.2151586755402d-04,
     |   4.2572752676780d-03, 7.2478890418586d-02, 6.8761595178476d-01,
     |   3.9330428584783d+00, 1.4008546379549d+01, 3.0143053158626d+01,
     |   3.0993538259452d+01,-1.7263790208207d+01,-9.9089173617254d+01,
     |  -1.1500618159763d+02, 3.6790416566369d+00, 1.5179118664211d+02,
     |   1.5179118664211d+02, 3.6790416566371d+00,-1.1500618159763d+02,
     |  -9.9089173617254d+01,-1.7263790208207d+01, 3.0993538259452d+01,
     |   3.0143053158626d+01, 1.4008546379549d+01, 3.9330428584783d+00,
     |   6.8761595178476d-01, 7.2478890418586d-02, 4.2572752676780d-03,
     |   1.2151586755402d-04, 1.3357615324218d-06, 3.7177886710543d-09,
     |   1.1104027608835d-12, 3.8387375791888d-18, 4.9937309358436d-30/
      data (lpmn(lat,28,29), lat = 1,36)/
     |   4.4715212430799d-32, 1.0380941918706d-19, 5.0730656112293d-14,
     |   2.4282956972284d-10, 1.1548985819268d-07, 1.3345810373678d-05,
     |   5.8084048395322d-04, 1.2165976635982d-02, 1.4217165678003d-01,
     |   1.0157121714971d+00, 4.6779429372583d+00, 1.4147681257991d+01,
     |   2.7174258985070d+01, 2.7022827165993d+01,-8.5905786561983d+00,
     |  -7.0116157577082d+01,-9.9271973086574d+01,-4.7949839539509d+01,
     |   4.7949839539509d+01, 9.9271973086574d+01, 7.0116157577082d+01,
     |   8.5905786561983d+00,-2.7022827165993d+01,-2.7174258985070d+01,
     |  -1.4147681257991d+01,-4.6779429372583d+00,-1.0157121714972d+00,
     |  -1.4217165678004d-01,-1.2165976635982d-02,-5.8084048395323d-04,
     |  -1.3345810373677d-05,-1.1548985819268d-07,-2.4282956972285d-10,
     |  -5.0730656112296d-14,-1.0380941918706d-19,-4.4715212430799d-32/
      data (lpmn(lat,29,29), lat = 1,36)/
     |   2.7502781593921d-34, 1.9275189185652d-21, 1.5900205569940d-15,
     |   1.0865769259993d-11, 6.8266648290169d-09, 9.9911575490537d-07,
     |   5.3785808152066d-05, 1.3771510740599d-03, 1.9626193089457d-02,
     |   1.7221570759155d-01, 9.9350073409494d-01, 3.9223307961017d+00,
     |   1.0781208367715d+01, 2.0358007997209d+01, 2.4238115366532d+01,
     |   1.0790776566648d+01,-1.9721785516504d+01,-4.6751478312529d+01,
     |  -4.6751478312529d+01,-1.9721785516504d+01, 1.0790776566648d+01,
     |   2.4238115366532d+01, 2.0358007997209d+01, 1.0781208367715d+01,
     |   3.9223307961017d+00, 9.9350073409494d-01, 1.7221570759155d-01,
     |   1.9626193089457d-02, 1.3771510740599d-03, 5.3785808152067d-05,
     |   9.9911575490537d-07, 6.8266648290169d-09, 1.0865769259994d-11,
     |   1.5900205569941d-15, 1.9275189185652d-21, 2.7502781593920d-34/
      data (lpmn(lat, 0,30), lat = 1,36)/
     |  -3.1020102027445d+03, 2.0451682173480d+03,-1.4459092116123d+03,
     |   8.3266710869077d+02,-2.2230409609699d+02,-3.1369584408864d+02,
     |   7.0454495411808d+02,-9.0202429405679d+02, 8.9151854296068d+02,
     |  -6.9491107833365d+02, 3.6607605094385d+02, 1.9731761778825d+01,
     |  -3.8039937849099d+02, 6.4256777067400d+02,-7.5535874248076d+02,
     |   6.9962880980230d+02,-4.9102673224148d+02, 1.7631386339487d+02,
     |   1.7631386339487d+02,-4.9102673224148d+02, 6.9962880980231d+02,
     |  -7.5535874248076d+02, 6.4256777067400d+02,-3.8039937849100d+02,
     |   1.9731761778814d+01, 3.6607605094385d+02,-6.9491107833366d+02,
     |   8.9151854296068d+02,-9.0202429405679d+02, 7.0454495411807d+02,
     |  -3.1369584408864d+02,-2.2230409609699d+02, 8.3266710869079d+02,
     |  -1.4459092116123d+03, 2.0451682173480d+03,-3.1020102027445d+03/
      data (lpmn(lat, 1,30), lat = 1,36)/
     |  -1.1806610739439d+03, 3.0337526325754d+02, 5.5067132177017d+02,
     |  -1.0117419314296d+03, 1.1620242971715d+03,-1.0509456814292d+03,
     |   7.4235490642382d+02,-3.1932082419407d+02,-1.2512002267668d+02,
     |   5.0231444457047d+02,-7.4263172215371d+02, 8.0692264365013d+02,
     |  -6.9239323103520d+02, 4.3171785255032d+02,-8.5563718257833d+01,
     |  -2.7003018178200d+02, 5.5899825322443d+02,-7.2038465516329d+02,
     |   7.2038465516329d+02,-5.5899825322442d+02, 2.7003018178199d+02,
     |   8.5563718257835d+01,-4.3171785255032d+02, 6.9239323103520d+02,
     |  -8.0692264365014d+02, 7.4263172215371d+02,-5.0231444457047d+02,
     |   1.2512002267668d+02, 3.1932082419408d+02,-7.4235490642383d+02,
     |   1.0509456814292d+03,-1.1620242971715d+03, 1.0117419314296d+03,
     |  -5.5067132177014d+02,-3.0337526325754d+02, 1.1806610739439d+03/
      data (lpmn(lat, 2,30), lat = 1,36)/
     |   1.2319413370242d+03,-1.4097904201971d+03, 1.4661543696896d+03,
     |  -9.9697930606960d+02, 3.9610237291859d+02, 1.7717040480599d+02,
     |  -6.1915047181966d+02, 8.6543272761919d+02,-8.9296955815259d+02,
     |   7.2019466942795d+02,-4.0118588832245d+02, 1.3963252050728d+01,
     |   3.5516062977793d+02,-6.2832251417524d+02, 7.5083167494040d+02,
     |  -7.0113882657220d+02, 4.9422048673105d+02,-1.7780143951048d+02,
     |  -1.7780143951048d+02, 4.9422048673105d+02,-7.0113882657220d+02,
     |   7.5083167494040d+02,-6.2832251417524d+02, 3.5516062977794d+02,
     |   1.3963252050740d+01,-4.0118588832245d+02, 7.2019466942795d+02,
     |  -8.9296955815259d+02, 8.6543272761919d+02,-6.1915047181965d+02,
     |   1.7717040480599d+02, 3.9610237291859d+02,-9.9697930606961d+02,
     |   1.4661543696896d+03,-1.4097904201971d+03, 1.2319413370242d+03/
      data (lpmn(lat, 3,30), lat = 1,36)/
     |   9.1754696331923d+02,-9.5446338928436d+02, 3.1214045890424d+02,
     |   5.2619674397502d+02,-9.7454976107462d+02, 1.0541429829364d+03,
     |  -8.4718046317972d+02, 4.5879779411983d+02,-3.6888350955652d+00,
     |  -4.0944285710695d+02, 6.9388803553968d+02,-7.9771132445785d+02,
     |   7.1045535071588d+02,-4.6231637013266d+02, 1.1590401049071d+02,
     |   2.4783066046817d+02,-5.4678408500775d+02, 7.1469743409455d+02,
     |  -7.1469743409455d+02, 5.4678408500775d+02,-2.4783066046817d+02,
     |  -1.1590401049072d+02, 4.6231637013266d+02,-7.1045535071588d+02,
     |   7.9771132445786d+02,-6.9388803553968d+02, 4.0944285710695d+02,
     |   3.6888350955711d+00,-4.5879779411984d+02, 8.4718046317972d+02,
     |  -1.0541429829364d+03, 9.7454976107462d+02,-5.2619674397501d+02,
     |  -3.1214045890426d+02, 9.5446338928436d+02,-9.1754696331923d+02/
      data (lpmn(lat, 4,30), lat = 1,36)/
     |   3.0532718386280d+02, 1.4049460190421d+01,-8.0246833677925d+02,
     |   1.1500551658717d+03,-8.0159835709338d+02, 2.1940817842140d+02,
     |   3.3675010222081d+02,-7.2173454622899d+02, 8.6953135046817d+02,
     |  -7.7850646880593d+02, 4.9834473365497d+02,-1.1331175925702d+02,
     |  -2.7791389341228d+02, 5.8321091091360d+02,-7.3536823472629d+02,
     |   7.0465415023256d+02,-5.0344062512570d+02, 1.8219780648094d+02,
     |   1.8219780648094d+02,-5.0344062512571d+02, 7.0465415023256d+02,
     |  -7.3536823472629d+02, 5.8321091091360d+02,-2.7791389341229d+02,
     |  -1.1331175925703d+02, 4.9834473365497d+02,-7.7850646880593d+02,
     |   8.6953135046817d+02,-7.2173454622898d+02, 3.3675010222080d+02,
     |   2.1940817842140d+02,-8.0159835709338d+02, 1.1500551658717d+03,
     |  -8.0246833677925d+02, 1.4049460190421d+01, 3.0532718386280d+02/
      data (lpmn(lat, 5,30), lat = 1,36)/
     |   6.6609448263573d+01, 3.8386197212871d+02,-8.1493192358208d+02,
     |   4.2356237829885d+02, 3.8090797267379d+02,-8.6301474858711d+02,
     |   9.3361318606678d+02,-6.8145304828933d+02, 2.4967056451596d+02,
     |   2.1228134003572d+02,-5.7777729704196d+02, 7.6268702959134d+02,
     |  -7.3565818179711d+02, 5.1820086044374d+02,-1.7500882724960d+02,
     |  -2.0337835861868d+02, 5.2207369547559d+02,-7.0324878767826d+02,
     |   7.0324878767826d+02,-5.2207369547559d+02, 2.0337835861867d+02,
     |   1.7500882724960d+02,-5.1820086044374d+02, 7.3565818179711d+02,
     |  -7.6268702959134d+02, 5.7777729704196d+02,-2.1228134003572d+02,
     |  -2.4967056451597d+02, 6.8145304828933d+02,-9.3361318606678d+02,
     |   8.6301474858711d+02,-3.8090797267379d+02,-4.2356237829886d+02,
     |   8.1493192358208d+02,-3.8386197212871d+02,-6.6609448263572d+01/
      data (lpmn(lat, 6,30), lat = 1,36)/
     |   1.0823180859541d+01, 3.0858159588591d+02,-2.7787908335815d+02,
     |  -4.5233575249402d+02, 9.4812529585937d+02,-7.1395052129042d+02,
     |   1.5463115875373d+02, 3.9572669116171d+02,-7.4321647109235d+02,
     |   8.1419261012304d+02,-6.2838330585382d+02, 2.6957214759916d+02,
     |   1.4597828482664d+02,-5.0083770843090d+02, 7.0347552696981d+02,
     |  -7.0711487828494d+02, 5.1758447062801d+02,-1.8930072350889d+02,
     |  -1.8930072350889d+02, 5.1758447062801d+02,-7.0711487828494d+02,
     |   7.0347552696981d+02,-5.0083770843090d+02, 1.4597828482665d+02,
     |   2.6957214759917d+02,-6.2838330585382d+02, 8.1419261012304d+02,
     |  -7.4321647109235d+02, 3.9572669116170d+02, 1.5463115875374d+02,
     |  -7.1395052129042d+02, 9.4812529585937d+02,-4.5233575249402d+02,
     |  -2.7787908335815d+02, 3.0858159588591d+02, 1.0823180859541d+01/
      data (lpmn(lat, 7,30), lat = 1,36)/
     |   1.3982880039473d+00, 1.5319616565562d+02, 1.2234170773970d+02,
     |  -6.7479169915718d+02, 5.0145612022458d+02, 2.4044747658148d+02,
     |  -7.5497739500643d+02, 8.3346279470825d+02,-5.5193696102649d+02,
     |   8.9082279695610d+01, 3.6718095366985d+02,-6.7115225428168d+02,
     |   7.4549042526554d+02,-5.8751189798361d+02, 2.5892210248824d+02,
     |   1.3688082505543d+02,-4.8436887795725d+02, 6.8589267312774d+02,
     |  -6.8589267312773d+02, 4.8436887795725d+02,-1.3688082505543d+02,
     |  -2.5892210248824d+02, 5.8751189798361d+02,-7.4549042526554d+02,
     |   6.7115225428167d+02,-3.6718095366985d+02,-8.9082279695614d+01,
     |   5.5193696102650d+02,-8.3346279470825d+02, 7.5497739500642d+02,
     |  -2.4044747658148d+02,-5.0145612022458d+02, 6.7479169915718d+02,
     |  -1.2234170773970d+02,-1.5319616565562d+02,-1.3982880039473d+00/
      data (lpmn(lat, 8,30), lat = 1,36)/
     |   1.4948262284974d-01, 5.7208626285693d+01, 2.2647370212502d+02,
     |  -3.8980640478611d+02,-2.1394213288549d+02, 7.9223856105330d+02,
     |  -6.5994016725752d+02, 1.2557809340569d+02, 4.2130501636248d+02,
     |  -7.3436063351969d+02, 7.3080466302037d+02,-4.5708031105542d+02,
     |   3.8518344336201d+01, 3.7325832810911d+02,-6.4664039369549d+02,
     |   7.0340175610314d+02,-5.3475296920198d+02, 1.9876234822699d+02,
     |   1.9876234822699d+02,-5.3475296920198d+02, 7.0340175610315d+02,
     |  -6.4664039369549d+02, 3.7325832810911d+02, 3.8518344336193d+01,
     |  -4.5708031105543d+02, 7.3080466302037d+02,-7.3436063351969d+02,
     |   4.2130501636248d+02, 1.2557809340569d+02,-6.5994016725753d+02,
     |   7.9223856105330d+02,-2.1394213288549d+02,-3.8980640478612d+02,
     |   2.2647370212502d+02, 5.7208626285693d+01, 1.4948262284974d-01/
      data (lpmn(lat, 9,30), lat = 1,36)/
     |   1.3582727700284d-02, 1.7307112627746d+01, 1.7152429202343d+02,
     |  -4.3940967628817d+01,-5.3606747286698d+02, 5.3539810704442d+02,
     |   1.3209105256644d+02,-6.6617052785035d+02, 7.4888224803197d+02,
     |  -4.3702296843578d+02,-5.2158628047766d+01, 4.8745960853153d+02,
     |  -7.0646865919311d+02, 6.4997308767833d+02,-3.5977847790750d+02,
     |  -4.9453377100558d+01, 4.3309582882181d+02,-6.6241630871053d+02,
     |   6.6241630871053d+02,-4.3309582882180d+02, 4.9453377100551d+01,
     |   3.5977847790750d+02,-6.4997308767833d+02, 7.0646865919311d+02,
     |  -4.8745960853152d+02, 5.2158628047766d+01, 4.3702296843578d+02,
     |  -7.4888224803198d+02, 6.6617052785035d+02,-1.3209105256643d+02,
     |  -5.3539810704442d+02, 5.3606747286699d+02, 4.3940967628819d+01,
     |  -1.7152429202344d+02,-1.7307112627746d+01,-1.3582727700284d-02/
      data (lpmn(lat,10,30), lat = 1,36)/
     |   1.0692857609907d-03, 4.4111691556423d+00, 9.2253296278658d+01,
     |   1.3306766236419d+02,-4.1867847604533d+02,-5.0755203502936d+01,
     |   6.6527122639519d+02,-6.1096473743244d+02, 9.6218957426375d+01,
     |   4.4409593088328d+02,-7.1151239856447d+02, 6.2067435088133d+02,
     |  -2.5856423389954d+02,-1.9587857270916d+02, 5.5474093713557d+02,
     |  -6.8642881077590d+02, 5.5217062353899d+02,-2.1007213911165d+02,
     |  -2.1007213911165d+02, 5.5217062353899d+02,-6.8642881077590d+02,
     |   5.5474093713557d+02,-1.9587857270916d+02,-2.5856423389954d+02,
     |   6.2067435088134d+02,-7.1151239856447d+02, 4.4409593088328d+02,
     |   9.6218957426380d+01,-6.1096473743244d+02, 6.6527122639519d+02,
     |  -5.0755203502936d+01,-4.1867847604533d+02, 1.3306766236419d+02,
     |   9.2253296278660d+01, 4.4111691556423d+00, 1.0692857609907d-03/
      data (lpmn(lat,11,30), lat = 1,36)/
     |   7.3972133690856d-05, 9.7052419306279d-01, 3.9677004460466d+01,
     |   1.5349704424131d+02,-1.4700311490782d+02,-4.1062768492632d+02,
     |   5.3327157601133d+02, 6.3578470043762d+01,-6.0109784704237d+02,
     |   6.7014431169221d+02,-3.1621413485758d+02,-1.9353314294339d+02,
     |   5.8019485646646d+02,-6.7588791652349d+02, 4.6381980181951d+02,
     |  -5.5880251125444d+01,-3.6783804019401d+02, 6.3254882107643d+02,
     |  -6.3254882107643d+02, 3.6783804019401d+02, 5.5880251125451d+01,
     |  -4.6381980181952d+02, 6.7588791652349d+02,-5.8019485646646d+02,
     |   1.9353314294338d+02, 3.1621413485758d+02,-6.7014431169221d+02,
     |   6.0109784704237d+02,-6.3578470043760d+01,-5.3327157601133d+02,
     |   4.1062768492632d+02, 1.4700311490782d+02,-1.5349704424131d+02,
     |  -3.9677004460467d+01,-9.7052419306279d-01,-7.3972133690856d-05/
      data (lpmn(lat,12,30), lat = 1,36)/
     |   4.5455553247467d-06, 1.8738952222066d-01, 1.4352468313888d+01,
     |   1.0738821607820d+02, 5.0446268303090d+01,-4.0308378143331d+02,
     |   5.1975500960773d+01, 5.6583561387375d+02,-5.5646522428518d+02,
     |   4.8299163893349d+01, 4.7626157697363d+02,-6.7180515406730d+02,
     |   4.7020824444423d+02,-2.4610602675865d+01,-4.1888599943808d+02,
     |   6.4753782209756d+02,-5.6610107467847d+02, 2.2253083192163d+02,
     |   2.2253083192163d+02,-5.6610107467847d+02, 6.4753782209756d+02,
     |  -4.1888599943808d+02,-2.4610602675866d+01, 4.7020824444422d+02,
     |  -6.7180515406730d+02, 4.7626157697363d+02, 4.8299163893352d+01,
     |  -5.5646522428518d+02, 5.6583561387375d+02, 5.1975500960778d+01,
     |  -4.0308378143331d+02, 5.0446268303089d+01, 1.0738821607820d+02,
     |   1.4352468313889d+01, 1.8738952222066d-01, 4.5455553247467d-06/
      data (lpmn(lat,13,30), lat = 1,36)/
     |   2.5018011492737d-07, 3.2128543111552d-02, 4.4892727806110d+00,
     |   5.7861350591885d+01, 1.1935609228807d+02,-2.0236489821853d+02,
     |  -3.0900026817622d+02, 5.0617562891768d+02, 3.6630352959535d+01,
     |  -5.5997508022192d+02, 5.8529014845226d+02,-1.7231287628293d+02,
     |  -3.4064260774371d+02, 6.2886925949828d+02,-5.4964870875894d+02,
     |   1.7285183693973d+02, 2.8868818141398d+02,-5.9597488630153d+02,
     |   5.9597488630153d+02,-2.8868818141398d+02,-1.7285183693974d+02,
     |   5.4964870875894d+02,-6.2886925949828d+02, 3.4064260774371d+02,
     |   1.7231287628294d+02,-5.8529014845226d+02, 5.5997508022192d+02,
     |  -3.6630352959532d+01,-5.0617562891768d+02, 3.0900026817622d+02,
     |   2.0236489821853d+02,-1.1935609228807d+02,-5.7861350591886d+01,
     |  -4.4892727806111d+00,-3.2128543111552d-02,-2.5018011492737d-07/
      data (lpmn(lat,14,30), lat = 1,36)/
     |   1.2412285788674d-08, 4.9341434836461d-03, 1.2353960182090d+00,
     |   2.5873350390170d+01, 1.0617787280789d+02,-1.1584518718047d+01,
     |  -3.6673986548909d+02, 1.0429540525396d+02, 4.9509272368169d+02,
     |  -4.9072983800931d+02,-2.8127965157286d+01, 5.1607776723626d+02,
     |  -5.9647860558629d+02, 2.5996250378183d+02, 2.3635618035256d+02,
     |  -5.7750226673588d+02, 5.7179646638146d+02,-2.3521280545271d+02,
     |  -2.3521280545272d+02, 5.7179646638146d+02,-5.7750226673588d+02,
     |   2.3635618035256d+02, 2.5996250378183d+02,-5.9647860558629d+02,
     |   5.1607776723626d+02,-2.8127965157286d+01,-4.9072983800931d+02,
     |   4.9509272368169d+02, 1.0429540525396d+02,-3.6673986548909d+02,
     |  -1.1584518718047d+01, 1.0617787280788d+02, 2.5873350390170d+01,
     |   1.2353960182090d+00, 4.9341434836461d-03, 1.2412285788673d-08/
      data (lpmn(lat,15,30), lat = 1,36)/
     |   5.5785599406659d-10, 6.8314118438507d-04, 3.0259625655169d-01,
     |   9.9463603893355d+00, 6.7865019572278d+01, 8.3108269008807d+01,
     |  -2.2270500370349d+02,-2.3727595067077d+02, 4.6308608030278d+02,
     |   5.0513924266123d+01,-5.3716813182789d+02, 4.7736843770094d+02,
     |   6.1764484383593d+00,-4.7661778920275d+02, 5.8818098121332d+02,
     |  -2.9041556831488d+02,-1.9675380768806d+02, 5.5235581624643d+02,
     |  -5.5235581624643d+02, 1.9675380768805d+02, 2.9041556831488d+02,
     |  -5.8818098121332d+02, 4.7661778920274d+02,-6.1764484383649d+00,
     |  -4.7736843770094d+02, 5.3716813182789d+02,-5.0513924266121d+01,
     |  -4.6308608030279d+02, 2.3727595067077d+02, 2.2270500370349d+02,
     |  -8.3108269008807d+01,-6.7865019572278d+01,-9.9463603893356d+00,
     |  -3.0259625655170d-01,-6.8314118438507d-04,-5.5785599406659d-10/
      data (lpmn(lat,16,30), lat = 1,36)/
     |   2.2796352198728d-11, 8.5675200639629d-05, 6.6504879737470d-02,
     |   3.3535942141098d+00, 3.5161595087122d+01, 9.5294687207689d+01,
     |  -5.0094931204320d+01,-3.2519441157601d+02, 1.1454798348056d+02,
     |   4.5113569262975d+02,-4.0594466874878d+02,-1.3656978834307d+02,
     |   5.4451239179413d+02,-4.5208389844561d+02,-1.7922399790083d+01,
     |   4.6857263591774d+02,-5.6354772829872d+02, 2.4691221202996d+02,
     |   2.4691221202996d+02,-5.6354772829872d+02, 4.6857263591773d+02,
     |  -1.7922399790081d+01,-4.5208389844561d+02, 5.4451239179413d+02,
     |  -1.3656978834307d+02,-4.0594466874878d+02, 4.5113569262975d+02,
     |   1.1454798348056d+02,-3.2519441157601d+02,-5.0094931204321d+01,
     |   9.5294687207689d+01, 3.5161595087122d+01, 3.3535942141098d+00,
     |   6.6504879737472d-02, 8.5675200639629d-05, 2.2796352198728d-11/
      data (lpmn(lat,17,30), lat = 1,36)/
     |   8.4921568249730d-13, 9.7660614011282d-06, 1.3189233895370d-02,
     |   1.0041454338144d+00, 1.5485453222994d+01, 6.9939531278622d+01,
     |   5.3627779354097d+01,-2.1887259742394d+02,-1.9666447560744d+02,
     |   4.0757180193268d+02, 1.0273047731962d+02,-5.1687216052226d+02,
     |   3.2355191503399d+02, 2.1388374552246d+02,-5.4688496861885d+02,
     |   3.9142380443858d+02, 9.4856615289827d+01,-5.0136229519787d+02,
     |   5.0136229519787d+02,-9.4856615289825d+01,-3.9142380443858d+02,
     |   5.4688496861885d+02,-2.1388374552246d+02,-3.2355191503399d+02,
     |   5.1687216052226d+02,-1.0273047731962d+02,-4.0757180193268d+02,
     |   1.9666447560744d+02, 2.1887259742394d+02,-5.3627779354097d+01,
     |  -6.9939531278622d+01,-1.5485453222994d+01,-1.0041454338144d+00,
     |  -1.3189233895370d-02,-9.7660614011282d-06,-8.4921568249730d-13/
      data (lpmn(lat,18,30), lat = 1,36)/
     |   2.8886387522141d-14, 1.0140667840345d-06, 2.3692232889495d-03,
     |   2.6915902789853d-01, 5.9390188563111d+00, 4.0266299725082d+01,
     |   8.1230712221316d+01,-6.6275063586156d+01,-2.8679857014374d+02,
     |   8.9142872958490d+01, 4.2541045340731d+02,-2.8935093862777d+02,
     |  -2.6809839401669d+02, 5.1776204425538d+02,-2.0366291122269d+02,
     |  -3.1807764656690d+02, 5.3495254007789d+02,-2.5606459465543d+02,
     |  -2.5606459465543d+02, 5.3495254007789d+02,-3.1807764656689d+02,
     |  -2.0366291122269d+02, 5.1776204425538d+02,-2.6809839401670d+02,
     |  -2.8935093862777d+02, 4.2541045340731d+02, 8.9142872958492d+01,
     |  -2.8679857014374d+02,-6.6275063586157d+01, 8.1230712221316d+01,
     |   4.0266299725082d+01, 5.9390188563111d+00, 2.6915902789853d-01,
     |   2.3692232889496d-03, 1.0140667840345d-06, 2.8886387522141d-14/
      data (lpmn(lat,19,30), lat = 1,36)/
     |   8.9783763094602d-16, 9.6026799420369d-08, 3.8636954303682d-04,
     |   6.4916679364417d-02, 2.0111290793502d+00, 1.9400287019633d+01,
     |   6.6346372996339d+01, 3.5287796492982d+01,-1.9862509626874d+02,
     |  -1.8369774447098d+02, 3.3589543292748d+02, 1.8587759510187d+02,
     |  -4.6749653218470d+02, 1.0441303283586d+02, 4.0196548030899d+02,
     |  -4.5243512878185d+02, 1.1539882977375d+01, 4.4272630123272d+02,
     |  -4.4272630123272d+02,-1.1539882977376d+01, 4.5243512878186d+02,
     |  -4.0196548030899d+02,-1.0441303283586d+02, 4.6749653218470d+02,
     |  -1.8587759510187d+02,-3.3589543292748d+02, 1.8369774447097d+02,
     |   1.9862509626875d+02,-3.5287796492981d+01,-6.6346372996340d+01,
     |  -1.9400287019633d+01,-2.0111290793502d+00,-6.4916679364419d-02,
     |  -3.8636954303683d-04,-9.6026799420369d-08,-8.9783763094602d-16/
      data (lpmn(lat,20,30), lat = 1,36)/
     |   2.5493243661771d-17, 8.2934733662022d-09, 5.7255553821869d-05,
     |   1.4128331821854d-02, 6.0620889193739d-01, 8.0551951159262d+00,
     |   4.0911652269354d+01, 6.8561848751621d+01,-6.3188534019316d+01,
     |  -2.5272869342514d+02, 3.3076652789354d+01, 3.9878592915963d+02,
     |  -1.2731072761400d+02,-3.8498326930178d+02, 3.6875839018806d+02,
     |   1.3398188095693d+02,-4.7960485416520d+02, 2.6062811555060d+02,
     |   2.6062811555060d+02,-4.7960485416520d+02, 1.3398188095692d+02,
     |   3.6875839018806d+02,-3.8498326930178d+02,-1.2731072761399d+02,
     |   3.9878592915963d+02, 3.3076652789354d+01,-2.5272869342514d+02,
     |  -6.3188534019316d+01, 6.8561848751620d+01, 4.0911652269354d+01,
     |   8.0551951159262d+00, 6.0620889193739d-01, 1.4128331821854d-02,
     |   5.7255553821871d-05, 8.2934733662022d-09, 2.5493243661771d-17/
      data (lpmn(lat,21,30), lat = 1,36)/
     |   6.6042235602867d-19, 6.5261878854364d-10, 7.7071099412909d-06,
     |   2.7775490850675d-03, 1.6337057858626d-01, 2.9265687955033d+00,
     |   2.0729072208823d+01, 5.9550104239586d+01, 2.8777825315909d+01,
     |  -1.6564780153523d+02,-1.8942495234992d+02, 2.3779761302922d+02,
     |   2.7783909014672d+02,-3.4143112970723d+02,-1.6155965969947d+02,
     |   4.4648325911918d+02,-1.1317005664717d+02,-3.7632669423017d+02,
     |   3.7632669423017d+02, 1.1317005664717d+02,-4.4648325911918d+02,
     |   1.6155965969947d+02, 3.4143112970723d+02,-2.7783909014672d+02,
     |  -2.3779761302922d+02, 1.8942495234992d+02, 1.6564780153524d+02,
     |  -2.8777825315909d+01,-5.9550104239586d+01,-2.0729072208823d+01,
     |  -2.9265687955033d+00,-1.6337057858626d-01,-2.7775490850676d-03,
     |  -7.7071099412913d-06,-6.5261878854364d-10,-6.6042235602867d-19/
      data (lpmn(lat,22,30), lat = 1,36)/
     |   1.5571155115270d-20, 4.6685898435952d-11, 9.4073262299139d-07,
     |   4.9290207021528d-04, 3.9425918478282d-02, 9.3767295016404d-01,
     |   8.9310662725273d+00, 3.7722961489242d+01, 5.9156555884917d+01,
     |  -4.4493319408824d+01,-2.1701147276439d+02,-4.5814658547261d+01,
     |   3.3851197422268d+02, 7.5057377670254d+01,-4.0082676198785d+02,
     |   5.7907186721552d+01, 3.9257041624432d+02,-2.5789077155857d+02,
     |  -2.5789077155857d+02, 3.9257041624432d+02, 5.7907186721556d+01,
     |  -4.0082676198785d+02, 7.5057377670253d+01, 3.3851197422268d+02,
     |  -4.5814658547259d+01,-2.1701147276439d+02,-4.4493319408825d+01,
     |   5.9156555884917d+01, 3.7722961489242d+01, 8.9310662725274d+00,
     |   9.3767295016404d-01, 3.9425918478282d-02, 4.9290207021529d-04,
     |   9.4073262299143d-07, 4.6685898435952d-11, 1.5571155115270d-20/
      data (lpmn(lat,23,30), lat = 1,36)/
     |   3.3283322819652d-22, 3.0247705591189d-12, 1.0377453631153d-07,
     |   7.8755106712128d-05, 8.5122380224740d-03, 2.6573538601680d-01,
     |   3.3240131391801d+00, 1.9268096001199d+01, 5.1017500781685d+01,
     |   3.1686131684566d+01,-1.2014752748815d+02,-1.9669143688879d+02,
     |   1.0460333709213d+02, 3.2602068869172d+02,-1.0362780972525d+02,
     |  -3.5204224588007d+02, 1.9566827136394d+02, 3.0233924975559d+02,
     |  -3.0233924975559d+02,-1.9566827136394d+02, 3.5204224588007d+02,
     |   1.0362780972525d+02,-3.2602068869172d+02,-1.0460333709213d+02,
     |   1.9669143688879d+02, 1.2014752748815d+02,-3.1686131684566d+01,
     |  -5.1017500781685d+01,-1.9268096001199d+01,-3.3240131391801d+00,
     |  -2.6573538601680d-01,-8.5122380224740d-03,-7.8755106712130d-05,
     |  -1.0377453631153d-07,-3.0247705591189d-12,-3.3283322819652d-22/
      data (lpmn(lat,24,30), lat = 1,36)/
     |   6.4124508715580d-24, 1.7649158688547d-13, 1.0290750235528d-08,
     |   1.1276198608278d-05, 1.6384180720726d-03, 6.6550355558298d-02,
     |   1.0753356405295d+00, 8.2292103490985d+00, 3.1475904328580d+01,
     |   5.1987153563344d+01,-1.4990529474423d+01,-1.6794748649017d+02,
     |  -1.2640132263573d+02, 2.0691169003710d+02, 2.5075919248617d+02,
     |  -2.0768346775362d+02,-2.7333696311466d+02, 2.4412172624200d+02,
     |   2.4412172624200d+02,-2.7333696311466d+02,-2.0768346775362d+02,
     |   2.5075919248617d+02, 2.0691169003710d+02,-1.2640132263573d+02,
     |  -1.6794748649018d+02,-1.4990529474423d+01, 5.1987153563344d+01,
     |   3.1475904328580d+01, 8.2292103490985d+00, 1.0753356405295d+00,
     |   6.6550355558298d-02, 1.6384180720726d-03, 1.1276198608278d-05,
     |   1.0290750235528d-08, 1.7649158688547d-13, 6.4124508715580d-24/
      data (lpmn(lat,25,30), lat = 1,36)/
     |   1.1042203526003d-25, 9.1975505300373d-15, 9.0999293397313d-10,
     |   1.4359020165418d-06, 2.7927224135559d-04, 1.4657147617035d-02,
     |   3.0222663553425d-01, 2.9787954922449d+00, 1.5364279788846d+01,
     |   4.0783480846022d+01, 3.8396894145626d+01,-6.2713398756449d+01,
     |  -1.7808761731638d+02,-4.6916120629594d+01, 2.4829626028788d+02,
     |   1.7312596621368d+02,-2.3852565457693d+02,-2.2152671351170d+02,
     |   2.2152671351170d+02, 2.3852565457693d+02,-1.7312596621368d+02,
     |  -2.4829626028788d+02, 4.6916120629593d+01, 1.7808761731638d+02,
     |   6.2713398756450d+01,-3.8396894145626d+01,-4.0783480846022d+01,
     |  -1.5364279788846d+01,-2.9787954922449d+00,-3.0222663553425d-01,
     |  -1.4657147617035d-02,-2.7927224135559d-04,-1.4359020165419d-06,
     |  -9.0999293397318d-10,-9.1975505300373d-15,-1.1042203526003d-25/
      data (lpmn(lat,26,30), lat = 1,36)/
     |   1.6786163862731d-27, 4.2287038409446d-16, 7.0896584803718d-11,
     |   1.6072891441951d-07, 4.1694941775833d-05, 2.8115903449245d-03,
     |   7.3294883038478d-02, 9.1462118635279d-01, 6.1219448927175d+00,
     |   2.2812247955509d+01, 4.3514762415034d+01, 1.6468435562075d+01,
     |  -9.5526395948089d+01,-1.6201925446852d+02, 8.5537065465428d+00,
     |   2.4514889290552d+02, 1.3170451651433d+02,-2.1382203729825d+02,
     |  -2.1382203729825d+02, 1.3170451651433d+02, 2.4514889290552d+02,
     |   8.5537065465432d+00,-1.6201925446852d+02,-9.5526395948089d+01,
     |   1.6468435562075d+01, 4.3514762415034d+01, 2.2812247955509d+01,
     |   6.1219448927175d+00, 9.1462118635279d-01, 7.3294883038479d-02,
     |   2.8115903449245d-03, 4.1694941775833d-05, 1.6072891441952d-07,
     |   7.0896584803722d-11, 4.2287038409446d-16, 1.6786163862731d-27/
      data (lpmn(lat,27,30), lat = 1,36)/
     |   2.2106987378184d-29, 1.6833779613197d-17, 4.7767974012189d-12,
     |   1.5528665389318d-08, 5.3566385143657d-06, 4.6194358395449d-04,
     |   1.5113096135061d-02, 2.3579796874380d-01, 1.9987924986273d+00,
     |   9.8303260554106d+00, 2.8056598027886d+01, 3.9925104723713d+01,
     |  -3.3219521441778d+00,-1.0717683819849d+02,-1.3922590211336d+02,
     |   2.4490336433359d+01, 2.1568294134219d+02, 1.3590040712210d+02,
     |  -1.3590040712210d+02,-2.1568294134219d+02,-2.4490336433360d+01,
     |   1.3922590211336d+02, 1.0717683819849d+02, 3.3219521441777d+00,
     |  -3.9925104723713d+01,-2.8056598027886d+01,-9.8303260554106d+00,
     |  -1.9987924986273d+00,-2.3579796874380d-01,-1.5113096135061d-02,
     |  -4.6194358395449d-04,-5.3566385143657d-06,-1.5528665389319d-08,
     |  -4.7767974012192d-12,-1.6833779613197d-17,-2.2106987378184d-29/
      data (lpmn(lat,28,30), lat = 1,36)/
     |   2.4456933877003d-31, 5.6264683745644d-19, 2.6994558073441d-13,
     |   1.2562047355723d-09, 5.7472399752846d-07, 6.3138530297888d-05,
     |   2.5770434634424d-03, 4.9794207592739d-02, 5.2561480230683d-01,
     |   3.2944402673970d+00, 1.2718818196031d+01, 2.9556527318671d+01,
     |   3.3810145255258d+01,-1.2060255412719d+01,-9.8727986226087d+01,
     |  -1.2213797674761d+02,-6.8118909123949d-01, 1.5754495794760d+02,
     |   1.5754495794760d+02,-6.8118909123931d-01,-1.2213797674761d+02,
     |  -9.8727986226087d+01,-1.2060255412719d+01, 3.3810145255258d+01,
     |   2.9556527318671d+01, 1.2718818196031d+01, 3.2944402673971d+00,
     |   5.2561480230684d-01, 4.9794207592739d-02, 2.5770434634425d-03,
     |   6.3138530297888d-05, 5.7472399752846d-07, 1.2562047355723d-09,
     |   2.6994558073443d-13, 5.6264683745644d-19, 2.4456933877003d-31/
      data (lpmn(lat,29,30), lat = 1,36)/
     |   2.1456995803342d-33, 1.4907144117979d-20, 1.2081506010486d-14,
     |   8.0360570931357d-11, 4.8652814545052d-08, 6.7865688078286d-06,
     |   3.4388808161013d-04, 8.1673450891859d-03, 1.0604198499919d-01,
     |   8.2818483827575d-01, 4.1157043506893d+00, 1.3297801877845d+01,
     |   2.7152380147803d+01, 2.9181405559024d+01,-5.6224086765480d+00,
     |  -7.0495793107206d+01,-1.0374066270923d+02,-5.0808374265226d+01,
     |   5.0808374265226d+01, 1.0374066270923d+02, 7.0495793107207d+01,
     |   5.6224086765480d+00,-2.9181405559024d+01,-2.7152380147803d+01,
     |  -1.3297801877845d+01,-4.1157043506893d+00,-8.2818483827575d-01,
     |  -1.0604198499919d-01,-8.1673450891859d-03,-3.4388808161013d-04,
     |  -6.7865688078286d-06,-4.8652814545052d-08,-8.0360570931360d-11,
     |  -1.2081506010487d-14,-1.4907144117979d-20,-2.1456995803342d-33/
      data (lpmn(lat,30,30), lat = 1,36)/
     |   1.2944728296258d-35, 2.7148183826791d-22, 3.7136406003373d-16,
     |   3.5260452578985d-12, 2.8194876440593d-09, 4.9795917978076d-07,
     |   3.1197906747178d-05, 9.0524143493267d-04, 1.4321438860470d-02,
     |   1.3720153825255d-01, 8.5225642343330d-01, 3.5805628505334d+00,
     |   1.0369020381078d+01, 2.0465038811959d+01, 2.5384870020846d+01,
     |   1.2258567410057d+01,-1.9684425747005d+01,-4.8620243725388d+01,
     |  -4.8620243725388d+01,-1.9684425747006d+01, 1.2258567410056d+01,
     |   2.5384870020846d+01, 2.0465038811959d+01, 1.0369020381078d+01,
     |   3.5805628505335d+00, 8.5225642343330d-01, 1.3720153825255d-01,
     |   1.4321438860470d-02, 9.0524143493267d-04, 3.1197906747179d-05,
     |   4.9795917978076d-07, 2.8194876440593d-09, 3.5260452578987d-12,
     |   3.7136406003375d-16, 2.7148183826791d-22, 1.2944728296258d-35/
      data (lpmn(lat, 0,31), lat = 1,36)/
     |  -3.2331249668430d+03, 2.1529484369865d+03,-1.6603148174757d+03,
     |   1.1891827534946d+03,-7.0035218574631d+02, 2.1848228007978d+02,
     |   2.1719190381644d+02,-5.6784704140052d+02, 8.0287139359008d+02,
     |  -9.0462968672703d+02, 8.7093160189078d+02,-7.1533597615926d+02,
     |   4.6542187194433d+02,-1.5931103629871d+02,-1.5909951580025d+02,
     |   4.4559692747231d+02,-6.6113089192263d+02, 7.7664045502434d+02,
     |  -7.7664045502434d+02, 6.6113089192263d+02,-4.4559692747230d+02,
     |   1.5909951580025d+02, 1.5931103629871d+02,-4.6542187194433d+02,
     |   7.1533597615927d+02,-8.7093160189078d+02, 9.0462968672703d+02,
     |  -8.0287139359008d+02, 5.6784704140051d+02,-2.1719190381643d+02,
     |  -2.1848228007978d+02, 7.0035218574631d+02,-1.1891827534946d+03,
     |   1.6603148174757d+03,-2.1529484369865d+03, 3.2331249668430d+03/
      data (lpmn(lat, 1,31), lat = 1,36)/
     |  -1.4064675368071d+03, 5.8498988597741d+02, 2.3839136290373d+02,
     |  -7.4935689996566d+02, 1.0371878155040d+03,-1.1325521340714d+03,
     |   1.0597790652519d+03,-8.5022724543547d+02, 5.4436280825974d+02,
     |  -1.8939289009568d+02,-1.6518270363651d+02, 4.7283293970476d+02,
     |  -6.9513869567332d+02, 8.0606413416970d+02,-7.9477738852506d+02,
     |   6.6664912101554d+02,-4.4229386830169d+02, 1.5476421234306d+02,
     |   1.5476421234306d+02,-4.4229386830169d+02, 6.6664912101554d+02,
     |  -7.9477738852506d+02, 8.0606413416969d+02,-6.9513869567333d+02,
     |   4.7283293970475d+02,-1.6518270363651d+02,-1.8939289009568d+02,
     |   5.4436280825974d+02,-8.5022724543547d+02, 1.0597790652519d+03,
     |  -1.1325521340714d+03, 1.0371878155040d+03,-7.4935689996565d+02,
     |   2.3839136290371d+02, 5.8498988597741d+02,-1.4064675368071d+03/
      data (lpmn(lat, 2,31), lat = 1,36)/
     |   1.2520171518024d+03,-1.4159028694972d+03, 1.5827778180702d+03,
     |  -1.2832615773497d+03, 8.3761093953270d+02,-3.5088691914879d+02,
     |  -1.0974581325649d+02, 4.9238038443180d+02,-7.5907117343489d+02,
     |   8.8785581969112d+02,-8.7424363691467d+02, 7.3106476802014d+02,
     |  -4.8641728762916d+02, 1.7986621087918d+02, 1.4267844609547d+02,
     |  -4.3479535194861d+02, 6.5539368501190d+02,-7.7385558236418d+02,
     |   7.7385558236418d+02,-6.5539368501190d+02, 4.3479535194861d+02,
     |  -1.4267844609547d+02,-1.7986621087919d+02, 4.8641728762915d+02,
     |  -7.3106476802014d+02, 8.7424363691467d+02,-8.8785581969112d+02,
     |   7.5907117343489d+02,-4.9238038443179d+02, 1.0974581325647d+02,
     |   3.5088691914879d+02,-8.3761093953270d+02, 1.2832615773497d+03,
     |  -1.5827778180702d+03, 1.4159028694972d+03,-1.2520171518023d+03/
      data (lpmn(lat, 3,31), lat = 1,36)/
     |   1.0031602175247d+03,-1.1302940374687d+03, 6.0554934008561d+02,
     |   1.9494238110668d+02,-7.3318184939862d+02, 1.0079235159534d+03,
     |  -1.0537136736018d+03, 9.1397739552128d+02,-6.4015509036587d+02,
     |   2.8962513445293d+02, 7.8627593725142d+01,-4.0950591386996d+02,
     |   6.5735051943610d+02,-7.9062288321170d+02, 7.9501781460444d+02,
     |  -6.7455588821042d+02, 4.5048511794995d+02,-1.5810573917388d+02,
     |  -1.5810573917388d+02, 4.5048511794995d+02,-6.7455588821043d+02,
     |   7.9501781460444d+02,-7.9062288321170d+02, 6.5735051943610d+02,
     |  -4.0950591386995d+02, 7.8627593725142d+01, 2.8962513445293d+02,
     |  -6.4015509036587d+02, 9.1397739552129d+02,-1.0537136736018d+03,
     |   1.0079235159534d+03,-7.3318184939862d+02, 1.9494238110666d+02,
     |   6.0554934008563d+02,-1.1302940374687d+03, 1.0031602175247d+03/
      data (lpmn(lat, 4,31), lat = 1,36)/
     |   3.4826093510113d+02,-8.8442214990201d+01,-7.1332442697213d+02,
     |   1.2151715946442d+03,-1.0906345227330d+03, 6.8987646066165d+02,
     |  -2.0360703619266d+02,-2.5374941057398d+02, 6.0924697816601d+02,
     |  -8.2040836263415d+02, 8.7138556183093d+02,-7.7025682703356d+02,
     |   5.4535497020715d+02,-2.4008954227221d+02,-9.3535418079085d+01,
     |   4.0211773278958d+02,-6.3798870245459d+02, 7.6546146536802d+02,
     |  -7.6546146536802d+02, 6.3798870245459d+02,-4.0211773278957d+02,
     |   9.3535418079083d+01, 2.4008954227222d+02,-5.4535497020714d+02,
     |   7.7025682703357d+02,-8.7138556183093d+02, 8.2040836263415d+02,
     |  -6.0924697816601d+02, 2.5374941057398d+02, 2.0360703619267d+02,
     |  -6.8987646066165d+02, 1.0906345227330d+03,-1.2151715946442d+03,
     |   7.1332442697212d+02, 8.8442214990201d+01,-3.4826093510113d+02/
      data (lpmn(lat, 5,31), lat = 1,36)/
     |   7.8856101782116d+01, 3.8647104977097d+02,-9.3018564542626d+02,
     |   7.1124507892633d+02, 2.1159310205628d+01,-6.0769726402799d+02,
     |   9.1773142659091d+02,-9.5947043404405d+02, 7.8670058739887d+02,
     |  -4.7162413348948d+02, 9.2136587554167d+01, 2.7747110197278d+02,
     |  -5.7437175603904d+02, 7.5346542050395d+02,-7.9147534731808d+02,
     |   6.8840819756426d+02,-4.6619416182761d+02, 1.6466260717316d+02,
     |   1.6466260717316d+02,-4.6619416182761d+02, 6.8840819756426d+02,
     |  -7.9147534731808d+02, 7.5346542050394d+02,-5.7437175603904d+02,
     |   2.7747110197277d+02, 9.2136587554167d+01,-4.7162413348949d+02,
     |   7.8670058739888d+02,-9.5947043404405d+02, 9.1773142659090d+02,
     |  -6.0769726402799d+02, 2.1159310205629d+01, 7.1124507892634d+02,
     |  -9.3018564542626d+02, 3.8647104977097d+02, 7.8856101782115d+01/
      data (lpmn(lat, 6,31), lat = 1,36)/
     |   1.3278409371791d+01, 3.4695391311519d+02,-4.1333410900186d+02,
     |  -2.8635952058896d+02, 9.4164642204165d+02,-9.7669210952579d+02,
     |   6.3442959061782d+02,-1.4964698631047d+02,-3.1467866541028d+02,
     |   6.5678474382278d+02,-8.2473210678457d+02, 8.0786683581378d+02,
     |  -6.2883862953696d+02, 3.3480063885591d+02, 1.2448960019712d+01,
     |  -3.4688788646939d+02, 6.0836400390775d+02,-7.5134060582101d+02,
     |   7.5134060582101d+02,-6.0836400390775d+02, 3.4688788646939d+02,
     |  -1.2448960019710d+01,-3.3480063885591d+02, 6.2883862953696d+02,
     |  -8.0786683581379d+02, 8.2473210678457d+02,-6.5678474382278d+02,
     |   3.1467866541028d+02, 1.4964698631047d+02,-6.3442959061782d+02,
     |   9.7669210952579d+02,-9.4164642204165d+02, 2.8635952058895d+02,
     |   4.1333410900187d+02,-3.4695391311519d+02,-1.3278409371791d+01/
      data (lpmn(lat, 7,31), lat = 1,36)/
     |   1.7770104745105d+00, 1.8308654587618d+02, 6.5051856094798d+01,
     |  -7.1823042883189d+02, 7.6274275490952d+02,-1.4352878233018d+02,
     |  -4.7112590900034d+02, 8.2492740351254d+02,-8.7676850699500d+02,
     |   6.8070254537647d+02,-3.2994451313709d+02,-7.2885975327078d+01,
     |   4.3440363834425d+02,-6.8293799859741d+02, 7.7617524127326d+02,
     |  -7.0419411345564d+02, 4.8802977466287d+02,-1.7417648252303d+02,
     |  -1.7417648252304d+02, 4.8802977466288d+02,-7.0419411345565d+02,
     |   7.7617524127326d+02,-6.8293799859741d+02, 4.3440363834426d+02,
     |  -7.2885975327066d+01,-3.2994451313709d+02, 6.8070254537647d+02,
     |  -8.7676850699500d+02, 8.2492740351254d+02,-4.7112590900033d+02,
     |  -1.4352878233018d+02, 7.6274275490952d+02,-7.1823042883188d+02,
     |   6.5051856094795d+01, 1.8308654587618d+02, 1.7770104745105d+00/
      data (lpmn(lat, 8,31), lat = 1,36)/
     |   1.9679283548467d-01, 7.1789675023768d+01, 2.3372916087504d+02,
     |  -5.2015433626510d+02, 5.7738607150637d+00, 7.1246519937852d+02,
     |  -8.8470368604796d+02, 6.0682791001143d+02,-1.2585662952805d+02,
     |  -3.4816551034194d+02, 6.7850286581877d+02,-8.0061639215927d+02,
     |   7.1105647566831d+02,-4.5266006849156d+02, 9.7883212698260d+01,
     |   2.6846980850572d+02,-5.6569781284814d+02, 7.3130065760354d+02,
     |  -7.3130065760354d+02, 5.6569781284814d+02,-2.6846980850571d+02,
     |  -9.7883212698262d+01, 4.5266006849156d+02,-7.1105647566830d+02,
     |   8.0061639215927d+02,-6.7850286581877d+02, 3.4816551034194d+02,
     |   1.2585662952806d+02,-6.0682791001143d+02, 8.8470368604796d+02,
     |  -7.1246519937852d+02,-5.7738607150637d+00, 5.2015433626510d+02,
     |  -2.3372916087504d+02,-7.1789675023768d+01,-1.9679283548467d-01/
      data (lpmn(lat, 9,31), lat = 1,36)/
     |   1.8530071703949d-02, 2.2696858640940d+01, 1.9953763889140d+02,
     |  -1.3974007183086d+02,-5.0781537877193d+02, 7.5501805845351d+02,
     |  -2.6540356238970d+02,-3.5469300063118d+02, 7.4498790964674d+02,
     |  -8.0405034234325d+02, 5.8059703574374d+02,-1.9199011682415d+02,
     |  -2.2837247641816d+02, 5.6446052536246d+02,-7.3758581468486d+02,
     |   7.1572927473384d+02,-5.1379919851342d+02, 1.8624451342954d+02,
     |   1.8624451342954d+02,-5.1379919851342d+02, 7.1572927473385d+02,
     |  -7.3758581468485d+02, 5.6446052536246d+02,-2.2837247641817d+02,
     |  -1.9199011682416d+02, 5.8059703574374d+02,-8.0405034234325d+02,
     |   7.4498790964674d+02,-3.5469300063117d+02,-2.6540356238971d+02,
     |   7.5501805845351d+02,-5.0781537877193d+02,-1.3974007183086d+02,
     |   1.9953763889141d+02, 2.2696858640940d+01, 1.8530071703949d-02/
      data (lpmn(lat,10,31), lat = 1,36)/
     |   1.5124831957332d-03, 6.0330281432163d+00, 1.1542418524126d+02,
     |   1.0391622774513d+02,-5.2081611672218d+02, 1.9877742286508d+02,
     |   5.2226164635864d+02,-7.9886346523545d+02, 5.7769951899310d+02,
     |  -9.8280128243467d+01,-3.8354596102066d+02, 6.9212281384451d+02,
     |  -7.5135015408509d+02, 5.7278003158281d+02,-2.3076652292632d+02,
     |  -1.6705425233534d+02, 5.0906094644004d+02,-7.0508022478073d+02,
     |   7.0508022478072d+02,-5.0906094644004d+02, 1.6705425233533d+02,
     |   2.3076652292632d+02,-5.7278003158281d+02, 7.5135015408509d+02,
     |  -6.9212281384451d+02, 3.8354596102066d+02, 9.8280128243469d+01,
     |  -5.7769951899311d+02, 7.9886346523545d+02,-5.2226164635864d+02,
     |  -1.9877742286508d+02, 5.2081611672218d+02,-1.0391622774513d+02,
     |  -1.1542418524126d+02,-6.0330281432163d+00,-1.5124831957332d-03/
      data (lpmn(lat,11,31), lat = 1,36)/
     |   1.0856310168315d-04, 1.3831511675826d+00, 5.2624163135326d+01,
     |   1.6613035156036d+02,-2.6004991858708d+02,-3.2078839707737d+02,
     |   7.0599283444513d+02,-3.3746313264651d+02,-2.7303566240290d+02,
     |   6.8438852464520d+02,-7.3417901344679d+02, 4.6836305605988d+02,
     |  -3.7530210302818d+01,-3.8572431632898d+02, 6.6185685438490d+02,
     |  -7.1463117638691d+02, 5.4039651992833d+02,-2.0029957522129d+02,
     |  -2.0029957522129d+02, 5.4039651992833d+02,-7.1463117638691d+02,
     |   6.6185685438489d+02,-3.8572431632898d+02,-3.7530210302811d+01,
     |   4.6836305605988d+02,-7.3417901344679d+02, 6.8438852464520d+02,
     |  -2.7303566240290d+02,-3.3746313264651d+02, 7.0599283444513d+02,
     |  -3.2078839707737d+02,-2.6004991858708d+02, 1.6613035156036d+02,
     |   5.2624163135327d+01, 1.3831511675826d+00, 1.0856310168315d-04/
      data (lpmn(lat,12,31), lat = 1,36)/
     |   6.9278930851542d-06, 2.7825458269436d-01, 2.0055706736423d+01,
     |   1.3092068092582d+02,-9.8845746995437d+00,-4.6668048380514d+02,
     |   3.1169668400453d+02, 3.7684810392428d+02,-7.2010752932797d+02,
     |   5.3415257682606d+02,-4.7486633760368d+01,-4.3495919806974d+02,
     |   6.9755542517168d+02,-6.6194206455106d+02, 3.7282673515218d+02,
     |   4.4836002833033d+01,-4.3767522242457d+02, 6.7235824060789d+02,
     |  -6.7235824060788d+02, 4.3767522242457d+02,-4.4836002833026d+01,
     |  -3.7282673515218d+02, 6.6194206455106d+02,-6.9755542517168d+02,
     |   4.3495919806973d+02, 4.7486633760368d+01,-5.3415257682606d+02,
     |   7.2010752932797d+02,-3.7684810392428d+02,-3.1169668400453d+02,
     |   4.6668048380514d+02, 9.8845746995444d+00,-1.3092068092582d+02,
     |  -2.0055706736423d+01,-2.7825458269436d-01,-6.9278930851541d-06/
      data (lpmn(lat,13,31), lat = 1,36)/
     |   3.9639161714145d-07, 4.9726102165699d-02, 6.5903814653713d+00,
     |   7.6445988281060d+01, 1.1079444907834d+02,-3.1574839933920d+02,
     |  -1.7341800927109d+02, 6.3773997674325d+02,-3.6263170189700d+02,
     |  -2.3389490545901d+02, 6.4496498111136d+02,-6.5580535861050d+02,
     |   3.2486982572837d+02, 1.4585323053797d+02,-5.3569066464643d+02,
     |   6.9061455796395d+02,-5.6368567039456d+02, 2.1558140899426d+02,
     |   2.1558140899427d+02,-5.6368567039456d+02, 6.9061455796395d+02,
     |  -5.3569066464643d+02, 1.4585323053796d+02, 3.2486982572837d+02,
     |  -6.5580535861051d+02, 6.4496498111136d+02,-2.3389490545901d+02,
     |  -3.6263170189700d+02, 6.3773997674325d+02,-1.7341800927109d+02,
     |  -3.1574839933920d+02, 1.1079444907834d+02, 7.6445988281061d+01,
     |   6.5903814653715d+00, 4.9726102165699d-02, 3.9639161714145d-07/
      data (lpmn(lat,14,31), lat = 1,36)/
     |   2.0470061839664d-08, 7.9657868863683d-03, 1.9030134126251d+00,
     |   3.6531328157807d+01, 1.2294429556711d+02,-9.3234351662117d+01,
     |  -3.9248774848387d+02, 3.6223176352696d+02, 2.8123814827126d+02,
     |  -6.5277777567218d+02, 4.6832732745536d+02, 3.8500465870396d+01,
     |  -5.0309210973177d+02, 6.7571242523352d+02,-5.0140875755319d+02,
     |   9.2411029354675d+01, 3.5129965620740d+02,-6.3276850918426d+02,
     |   6.3276850918426d+02,-3.5129965620740d+02,-9.2411029354682d+01,
     |   5.0140875755319d+02,-6.7571242523352d+02, 5.0309210973178d+02,
     |  -3.8500465870387d+01,-4.6832732745536d+02, 6.5277777567218d+02,
     |  -2.8123814827126d+02,-3.6223176352696d+02, 3.9248774848386d+02,
     |   9.3234351662117d+01,-1.2294429556711d+02,-3.6531328157807d+01,
     |  -1.9030134126252d+00,-7.9657868863683d-03,-2.0470061839664d-08/
      data (lpmn(lat,15,31), lat = 1,36)/
     |   9.5899111351376d-10, 1.1516580582729d-03, 4.8900789174010d-01,
     |   1.4914509931789d+01, 8.8182961388263d+01, 5.4043569145666d+01,
     |  -3.2664582310832d+02,-7.3259306054408d+01, 5.6883608682450d+02,
     |  -3.4628162902592d+02,-2.4022712347297d+02, 6.2095173930720d+02,
     |  -5.4957283716019d+02, 1.3158171886708d+02, 3.5176542366660d+02,
     |  -6.3246219945077d+02, 5.7841899647142d+02,-2.3109576426232d+02,
     |  -2.3109576426232d+02, 5.7841899647142d+02,-6.3246219945077d+02,
     |   3.5176542366660d+02, 1.3158171886708d+02,-5.4957283716019d+02,
     |   6.2095173930719d+02,-2.4022712347297d+02,-3.4628162902592d+02,
     |   5.6883608682450d+02,-7.3259306054407d+01,-3.2664582310832d+02,
     |   5.4043569145666d+01, 8.8182961388262d+01, 1.4914509931789d+01,
     |   4.8900789174011d-01, 1.1516580582729d-03, 9.5899111351375d-10/
      data (lpmn(lat,16,31), lat = 1,36)/
     |   4.0918296388984d-11, 1.5103558547884d-04, 1.1281058146002d-01,
     |   5.3253457721559d+00, 4.9792829665822d+01, 1.0167653381950d+02,
     |  -1.4309485759794d+02,-3.2199472784481d+02, 3.6691351090249d+02,
     |   2.3641937542485d+02,-5.9669072467197d+02, 3.7021806075321d+02,
     |   1.6485292937023d+02,-5.6887182740544d+02, 5.8365850617778d+02,
     |  -2.3348494006224d+02,-2.5078521561847d+02, 5.8592204156356d+02,
     |  -5.8592204156356d+02, 2.5078521561847d+02, 2.3348494006225d+02,
     |  -5.8365850617778d+02, 5.6887182740544d+02,-1.6485292937024d+02,
     |  -3.7021806075322d+02, 5.9669072467197d+02,-2.3641937542485d+02,
     |  -3.6691351090250d+02, 3.2199472784481d+02, 1.4309485759795d+02,
     |  -1.0167653381950d+02,-4.9792829665822d+01,-5.3253457721560d+00,
     |  -1.1281058146002d-01,-1.5103558547884d-04,-4.0918296388984d-11/
      data (lpmn(lat,17,31), lat = 1,36)/
     |   1.5947356687754d-12, 1.8035154791182d-05, 2.3509492943359d-02,
     |   1.6869447176460d+00, 2.3618624592712d+01, 8.8502702666711d+01,
     |   8.8466035778400d+00,-3.1122097385339d+02,-2.0552956771522d+01,
     |   5.1006910215458d+02,-2.9094691965750d+02,-2.8946696459094d+02,
     |   5.9284678927921d+02,-3.8594350542037d+02,-1.1726855764479d+02,
     |   5.3017580513523d+02,-5.7826389113225d+02, 2.4555663557404d+02,
     |   2.4555663557404d+02,-5.7826389113225d+02, 5.3017580513522d+02,
     |  -1.1726855764479d+02,-3.8594350542037d+02, 5.9284678927922d+02,
     |  -2.8946696459093d+02,-2.9094691965750d+02, 5.1006910215458d+02,
     |  -2.0552956771520d+01,-3.1122097385339d+02, 8.8466035778392d+00,
     |   8.8502702666711d+01, 2.3618624592712d+01, 1.6869447176460d+00,
     |   2.3509492943360d-02, 1.8035154791182d-05, 1.5947356687754d-12/
      data (lpmn(lat,18,31), lat = 1,36)/
     |   5.6884073595827d-14, 1.9659698471400d-06, 4.4450687321785d-03,
     |   4.7851449204665d-01, 9.7050273392380d+00, 5.7012510418136d+01,
     |   7.7438746628666d+01,-1.6321152445237d+02,-2.6888792761293d+02,
     |   3.3781286920945d+02, 2.3889232118702d+02,-5.4119684452690d+02,
     |   2.2510158563814d+02, 3.2121185331546d+02,-5.8029334452208d+02,
     |   3.6005547871613d+02, 1.3884457103458d+02,-5.3144166420822d+02,
     |   5.3144166420822d+02,-1.3884457103458d+02,-3.6005547871613d+02,
     |   5.8029334452208d+02,-3.2121185331546d+02,-2.2510158563814d+02,
     |   5.4119684452690d+02,-2.3889232118702d+02,-3.3781286920945d+02,
     |   2.6888792761293d+02, 1.6321152445237d+02,-7.7438746628666d+01,
     |  -5.7012510418136d+01,-9.7050273392379d+00,-4.7851449204666d-01,
     |  -4.4450687321787d-03,-1.9659698471400d-06,-5.6884073595827d-14/
      data (lpmn(lat,19,31), lat = 1,36)/
     |   1.8591459880387d-15, 1.9594924710462d-07, 7.6469973309908d-04,
     |   1.2228234830547d-01, 3.5141260579223d+00, 3.0115144651936d+01,
     |   8.1485263405995d+01,-1.8672165077465d+01,-2.8346031491552d+02,
     |  -1.1275946804647d+01, 4.6168148949098d+02,-1.9365776325361d+02,
     |  -3.6777100079145d+02, 5.1987601586032d+02,-1.3549556398732d+02,
     |  -3.7892589797250d+02, 5.5606427709388d+02,-2.5730286151334d+02,
     |  -2.5730286151334d+02, 5.5606427709388d+02,-3.7892589797249d+02,
     |  -1.3549556398732d+02, 5.1987601586032d+02,-3.6777100079146d+02,
     |  -1.9365776325361d+02, 4.6168148949098d+02,-1.1275946804647d+01,
     |  -2.8346031491552d+02,-1.8672165077466d+01, 8.1485263405996d+01,
     |   3.0115144651936d+01, 3.5141260579223d+00, 1.2228234830547d-01,
     |   7.6469973309911d-04, 1.9594924710462d-07, 1.8591459880387d-15/
      data (lpmn(lat,20,31), lat = 1,36)/
     |   5.5690321952645d-17, 1.7868965653457d-08, 1.1988427214386d-04,
     |   2.8258339235364d-02, 1.1327448256023d+00, 1.3593512799379d+01,
     |   5.8120776034452d+01, 5.7814790993681d+01,-1.5967445286266d+02,
     |  -2.3760769159074d+02, 2.7968125275345d+02, 2.7860704447139d+02,
     |  -4.6010000634090d+02, 2.1311533781509d+01, 4.5854886733013d+02,
     |  -4.4612025536235d+02,-2.1078716331431d+01, 4.6901689510441d+02,
     |  -4.6901689510441d+02, 2.1078716331430d+01, 4.4612025536235d+02,
     |  -4.5854886733013d+02,-2.1311533781510d+01, 4.6010000634090d+02,
     |  -2.7860704447139d+02,-2.7968125275345d+02, 2.3760769159074d+02,
     |   1.5967445286266d+02,-5.7814790993680d+01,-5.8120776034452d+01,
     |  -1.3593512799379d+01,-1.1327448256023d+00,-2.8258339235364d-02,
     |  -1.1988427214387d-04,-1.7868965653457d-08,-5.5690321952645d-17/
      data (lpmn(lat,21,31), lat = 1,36)/
     |   1.5280203947907d-18, 1.4904134120220d-09, 1.7134057361661d-05,
     |   5.9169077585551d-03, 3.2699350082689d-01, 5.3528791641024d+00,
     |   3.2992413212614d+01, 7.1718902483675d+01,-2.7399260726503d+01,
     |  -2.5048427709008d+02,-3.9155157375981d+01, 4.1084236490684d+02,
     |  -4.9551129056821d+01,-4.3576943759913d+02, 3.4150966375651d+02,
     |   1.8532682906098d+02,-5.0455920757104d+02, 2.6417239833932d+02,
     |   2.6417239833932d+02,-5.0455920757104d+02, 1.8532682906098d+02,
     |   3.4150966375651d+02,-4.3576943759913d+02,-4.9551129056818d+01,
     |   4.1084236490684d+02,-3.9155157375981d+01,-2.5048427709008d+02,
     |  -2.7399260726503d+01, 7.1718902483675d+01, 3.2992413212614d+01,
     |   5.3528791641024d+00, 3.2699350082689d-01, 5.9169077585553d-03,
     |   1.7134057361662d-05, 1.4904134120220d-09, 1.5280203947906d-18/
      data (lpmn(lat,22,31), lat = 1,36)/
     |   3.8342375598965d-20, 1.1354821692248d-10, 2.2306744037961d-06,
     |   1.1229546472943d-03, 8.4793050871263d-02, 1.8594012557384d+00,
     |   1.5735271900445d+01, 5.4542450331760d+01, 4.6562234027287d+01,
     |  -1.3751859836508d+02,-2.2373601486172d+02, 1.9002403990651d+02,
     |   3.3136219787320d+02,-3.1237702060403d+02,-2.1857577223942d+02,
     |   4.6066405051022d+02,-9.2729895616973d+01,-3.9849443206754d+02,
     |   3.9849443206754d+02, 9.2729895616974d+01,-4.6066405051022d+02,
     |   2.1857577223942d+02, 3.1237702060403d+02,-3.3136219787320d+02,
     |  -1.9002403990652d+02, 2.2373601486172d+02, 1.3751859836508d+02,
     |  -4.6562234027288d+01,-5.4542450331760d+01,-1.5735271900445d+01,
     |  -1.8594012557384d+00,-8.4793050871263d-02,-1.1229546472944d-03,
     |  -2.2306744037962d-06,-1.1354821692248d-10,-3.8342375598965d-20/
      data (lpmn(lat,23,31), lat = 1,36)/
     |   8.7751067571663d-22, 7.8817307321731d-12, 2.6398412451913d-07,
     |   1.9293730138581d-04, 1.9764251750644d-02, 5.7291992639360d-01,
     |   6.4601119911531d+00, 3.2008828487389d+01, 6.2257161464806d+01,
     |  -1.9342772169902d+01,-2.1153945748587d+02,-9.3801591388056d+01,
     |   3.3036157898802d+02, 1.3015591523039d+02,-4.1135267862563d+02,
     |   2.4180633334994d+01, 4.1795668098250d+02,-2.6329899334363d+02,
     |  -2.6329899334364d+02, 4.1795668098250d+02, 2.4180633334998d+01,
     |  -4.1135267862563d+02, 1.3015591523039d+02, 3.3036157898802d+02,
     |  -9.3801591388055d+01,-2.1153945748587d+02,-1.9342772169903d+01,
     |   6.2257161464806d+01, 3.2008828487389d+01, 6.4601119911531d+00,
     |   5.7291992639360d-01, 1.9764251750644d-02, 1.9293730138582d-04,
     |   2.6398412451914d-07, 7.8817307321731d-12, 8.7751067571663d-22/
      data (lpmn(lat,24,31), lat = 1,36)/
     |   1.8241459332972d-23, 4.9648325359604d-13, 2.8294882888584d-08,
     |   2.9920749083210d-05, 4.1343636476533d-03, 1.5683335360544d-01,
     |   2.3090272043145d+00, 1.5482670686901d+01, 4.7759642425181d+01,
     |   4.3496216234119d+01,-9.9513797245834d+01,-2.1297953713694d+02,
     |   6.6462939475815d+01, 3.4577017446890d+02,-6.9421127059118d+01,
     |  -3.7720795032519d+02, 1.8715427070378d+02, 3.2003684528882d+02,
     |  -3.2003684528882d+02,-1.8715427070378d+02, 3.7720795032519d+02,
     |   6.9421127059118d+01,-3.4577017446890d+02,-6.6462939475813d+01,
     |   2.1297953713694d+02, 9.9513797245834d+01,-4.3496216234118d+01,
     |  -4.7759642425182d+01,-1.5482670686901d+01,-2.3090272043145d+00,
     |  -1.5683335360544d-01,-4.1343636476533d-03,-2.9920749083211d-05,
     |  -2.8294882888586d-08,-4.9648325359604d-13,-1.8241459332972d-23/
      data (lpmn(lat,25,31), lat = 1,36)/
     |   3.4237662744917d-25, 2.8215343773075d-14, 2.7315103049144d-09,
     |   4.1671350412717d-06, 7.7302828347244d-04, 3.8071783401538d-02,
     |   7.2129234541270d-01, 6.3346614696841d+00, 2.7579173690857d+01,
     |   5.3562769635668d+01, 9.2426136123233d-01,-1.5923129263403d+02,
     |  -1.5262031678074d+02, 1.8814822660795d+02, 2.7863801269853d+02,
     |  -1.9556822982131d+02,-2.9511483174161d+02, 2.5074548646573d+02,
     |   2.5074548646573d+02,-2.9511483174160d+02,-1.9556822982131d+02,
     |   2.7863801269853d+02, 1.8814822660795d+02,-1.5262031678074d+02,
     |  -1.5923129263403d+02, 9.2426136123233d-01, 5.3562769635668d+01,
     |   2.7579173690857d+01, 6.3346614696841d+00, 7.2129234541270d-01,
     |   3.8071783401538d-02, 7.7302828347244d-04, 4.1671350412719d-06,
     |   2.7315103049146d-09, 2.8215343773075d-14, 3.4237662744917d-25/
      data (lpmn(lat,26,31), lat = 1,36)/
     |   5.7525230141759d-27, 1.4344309934228d-15, 2.3554669417761d-10,
     |   5.1714183621475d-07, 1.2828575257807d-04, 8.1508496822540d-03,
     |   1.9654880886727d-01, 2.2124724693975d+00, 1.2845212694433d+01,
     |   3.8395568030071d+01, 4.4494598784157d+01,-4.8659972867725d+01,
     |  -1.8071194306601d+02,-7.1203689230603d+01, 2.4539003819000d+02,
     |   1.9598497698537d+02,-2.3990654205639d+02,-2.3442948063778d+02,
     |   2.3442948063778d+02, 2.3990654205639d+02,-1.9598497698537d+02,
     |  -2.4539003819000d+02, 7.1203689230603d+01, 1.8071194306601d+02,
     |   4.8659972867726d+01,-4.4494598784157d+01,-3.8395568030071d+01,
     |  -1.2845212694433d+01,-2.2124724693975d+00,-1.9654880886728d-01,
     |  -8.1508496822539d-03,-1.2828575257807d-04,-5.1714183621477d-07,
     |  -2.3554669417762d-10,-1.4344309934228d-15,-5.7525230141759d-27/
      data (lpmn(lat,27,31), lat = 1,36)/
     |   8.5445769154099d-29, 6.4430593369419d-17, 1.7923237599069d-11,
     |   5.6509768714602d-08, 1.8683495251010d-05, 1.5234835942434d-03,
     |   4.6362120434636d-02, 6.5870887148109d-01, 4.9327478842792d+00,
     |   2.0367783708443d+01, 4.3462741730325d+01, 2.4574663952100d+01,
     |  -8.6670539355731d+01,-1.7058620183640d+02,-8.1803620853152d+00,
     |   2.5005412115744d+02, 1.4592649495386d+02,-2.2071764190659d+02,
     |  -2.2071764190659d+02, 1.4592649495386d+02, 2.5005412115744d+02,
     |  -8.1803620853149d+00,-1.7058620183640d+02,-8.6670539355731d+01,
     |   2.4574663952099d+01, 4.3462741730325d+01, 2.0367783708443d+01,
     |   4.9327478842792d+00, 6.5870887148109d-01, 4.6362120434636d-02,
     |   1.5234835942434d-03, 1.8683495251010d-05, 5.6509768714603d-08,
     |   1.7923237599071d-11, 6.4430593369419d-17, 8.5445769154099d-29/
      data (lpmn(lat,28,31), lat = 1,36)/
     |   1.1009437939508d-30, 2.5090993067154d-18, 1.1810934322396d-12,
     |   5.3378212641645d-09, 2.3454734501326d-06, 2.4439005963140d-04,
     |   9.3220310131452d-03, 1.6526770888058d-01, 1.5617641748610d+00,
     |   8.4471615609053d+00, 2.6348463039649d+01, 4.1737403821315d+01,
     |   4.0768065867702d+00,-1.0333655440227d+02,-1.4838879992454d+02,
     |   1.5165625393156d+01, 2.2235225445089d+02, 1.4378066507869d+02,
     |  -1.4378066507869d+02,-2.2235225445089d+02,-1.5165625393157d+01,
     |   1.4838879992454d+02, 1.0333655440227d+02,-4.0768065867702d+00,
     |  -4.1737403821315d+01,-2.6348463039649d+01,-8.4471615609053d+00,
     |  -1.5617641748611d+00,-1.6526770888058d-01,-9.3220310131454d-03,
     |  -2.4439005963140d-04,-2.3454734501326d-06,-5.3378212641646d-09,
     |  -1.1810934322397d-12,-2.5090993067154d-18,-1.1009437939508d-30/
      data (lpmn(lat,29,31), lat = 1,36)/
     |   1.1930166470759d-32, 8.2138585740883d-20, 6.5362397878886d-14,
     |   4.2274608979150d-10, 2.4627167184064d-07, 3.2670339843080d-05,
     |   1.5533536195185d-03, 3.4060148619130d-02, 3.9994360989277d-01,
     |   2.7459309024427d+00, 1.1482918332855d+01, 2.8766572899555d+01,
     |   3.6261283746415d+01,-6.8077811377055d+00,-9.7879411226686d+01,
     |  -1.2913950871902d+02,-5.3066565610041d+00, 1.6328193605352d+02,
     |   1.6328193605352d+02,-5.3066565610039d+00,-1.2913950871902d+02,
     |  -9.7879411226686d+01,-6.8077811377055d+00, 3.6261283746415d+01,
     |   2.8766572899555d+01, 1.1482918332855d+01, 2.7459309024427d+00,
     |   3.9994360989277d-01, 3.4060148619130d-02, 1.5533536195186d-03,
     |   3.2670339843080d-05, 2.4627167184064d-07, 4.2274608979152d-10,
     |   6.5362397878890d-14, 8.2138585740883d-20, 1.1930166470759d-32/
      data (lpmn(lat,30,31), lat = 1,36)/
     |   1.0263432383635d-34, 2.1338331654437d-21, 2.8679812934178d-15,
     |   2.6508381728656d-11, 2.0429711396985d-08, 3.4398024168678d-06,
     |   2.0292618673140d-04, 5.4645064939814d-03, 7.8821091729856d-02,
     |   6.7286370458661d-01, 3.6072888997401d+00, 1.2446181956515d+01,
     |   2.6986910792290d+01, 3.1184643012261d+01,-2.5754474179446d+00,
     |  -7.0672699967028d+01,-1.0819334887173d+02,-5.3732029237187d+01,
     |   5.3732029237187d+01, 1.0819334887173d+02, 7.0672699967028d+01,
     |   2.5754474179446d+00,-3.1184643012261d+01,-2.6986910792290d+01,
     |  -1.2446181956515d+01,-3.6072888997401d+00,-6.7286370458662d-01,
     |  -7.8821091729857d-02,-5.4645064939814d-03,-2.0292618673141d-04,
     |  -3.4398024168678d-06,-2.0429711396985d-08,-2.6508381728657d-11,
     |  -2.8679812934180d-15,-2.1338331654437d-21,-1.0263432383635d-34/
      data (lpmn(lat,31,31), lat = 1,36)/
     |   6.0775522227923d-37, 3.8141859031585d-23, 8.6519682807478d-17,
     |   1.1413834495713d-12, 1.1615709431236d-09, 2.4756105996484d-07,
     |   1.8050505707170d-05, 5.9353622438765d-04, 1.0423858790658d-02,
     |   1.0902445748629d-01, 7.2917564058778d-01, 3.2597744953273d+00,
     |   9.9444891300202d+00, 2.0509176849834d+01, 2.6482550682421d+01,
     |   1.3757628374301d+01,-1.9594537764253d+01,-5.0493963238795d+01,
     |  -5.0493963238795d+01,-1.9594537764253d+01, 1.3757628374301d+01,
     |   2.6482550682421d+01, 2.0509176849834d+01, 9.9444891300201d+00,
     |   3.2597744953273d+00, 7.2917564058778d-01, 1.0902445748629d-01,
     |   1.0423858790658d-02, 5.9353622438765d-04, 1.8050505707170d-05,
     |   2.4756105996484d-07, 1.1615709431236d-09, 1.1413834495714d-12,
     |   8.6519682807484d-17, 3.8141859031585d-23, 6.0775522227923d-37/
      data (lpmn(lat, 0,32), lat = 1,36)/
     |  -3.3537255903606d+03, 2.2216536186870d+03,-1.8088323885181d+03,
     |   1.4688462156270d+03,-1.1249783607322d+03, 7.6874730680689d+02,
     |  -4.1006201279739d+02, 6.5223166604791d+01, 2.4779009779817d+02,
     |  -5.1195165401751d+02, 7.1297611111556d+02,-8.4059837567983d+02,
     |   8.8943082010404d+02,-8.5941326406036d+02, 7.5585949445271d+02,
     |  -5.8911450719491d+02, 3.7385520504492d+02,-1.2808762199392d+02,
     |  -1.2808762199393d+02, 3.7385520504492d+02,-5.8911450719492d+02,
     |   7.5585949445271d+02,-8.5941326406036d+02, 8.8943082010404d+02,
     |  -8.4059837567983d+02, 7.1297611111556d+02,-5.1195165401751d+02,
     |   2.4779009779816d+02, 6.5223166604797d+01,-4.1006201279740d+02,
     |   7.6874730680689d+02,-1.1249783607322d+03, 1.4688462156270d+03,
     |  -1.8088323885181d+03, 2.2216536186870d+03,-3.3537255903606d+03/
      data (lpmn(lat, 1,32), lat = 1,36)/
     |  -1.6485720557015d+03, 8.9272976148359d+02,-1.3066163914600d+02,
     |  -3.7272385551111d+02, 7.2112903154749d+02,-9.4617100742682d+02,
     |   1.0607612804438d+03,-1.0741604579705d+03, 9.9701557285807d+02,
     |  -8.4303554899200d+02, 6.2921016890156d+02,-3.7525942378103d+02,
     |   1.0263186803131d+02, 1.6675414810414d+02,-4.1187940402087d+02,
     |   6.1397769812406d+02,-7.5776489783458d+02, 8.3244940157405d+02,
     |  -8.3244940157405d+02, 7.5776489783458d+02,-6.1397769812406d+02,
     |   4.1187940402087d+02,-1.6675414810413d+02,-1.0263186803130d+02,
     |   3.7525942378105d+02,-6.2921016890156d+02, 8.4303554899201d+02,
     |  -9.9701557285808d+02, 1.0741604579705d+03,-1.0607612804438d+03,
     |   9.4617100742682d+02,-7.2112903154749d+02, 3.7272385551109d+02,
     |   1.3066163914603d+02,-8.9272976148359d+02, 1.6485720557015d+03/
      data (lpmn(lat, 2,32), lat = 1,36)/
     |   1.2623822600649d+03,-1.3853702393237d+03, 1.6300898603474d+03,
     |  -1.4791623653620d+03, 1.2020759294701d+03,-8.6627762079492d+02,
     |   5.0662732339541d+02,-1.5019288361887d+02,-1.7935632773769d+02,
     |   4.6152625916086d+02,-6.7974874852236d+02, 8.2224632405360d+02,
     |  -8.8270877476397d+02, 8.6065169033937d+02,-7.6140077806929d+02,
     |   5.9569004695202d+02,-3.7889565713975d+02, 1.2995517811320d+02,
     |   1.2995517811320d+02,-3.7889565713975d+02, 5.9569004695203d+02,
     |  -7.6140077806929d+02, 8.6065169033937d+02,-8.8270877476397d+02,
     |   8.2224632405359d+02,-6.7974874852236d+02, 4.6152625916086d+02,
     |  -1.7935632773768d+02,-1.5019288361887d+02, 5.0662732339542d+02,
     |  -8.6627762079492d+02, 1.2020759294701d+03,-1.4791623653620d+03,
     |   1.6300898603474d+03,-1.3853702393237d+03, 1.2623822600649d+03/
      data (lpmn(lat, 3,32), lat = 1,36)/
     |   1.0916940203074d+03,-1.3080669835152d+03, 9.1715057559300d+02,
     |  -2.0564201786408d+02,-3.3853360571998d+02, 7.1336122393935d+02,
     |  -9.3826306456908d+02, 1.0302977916755d+03,-1.0062073483959d+03,
     |   8.8459498054386d+02,-6.8670744401983d+02, 4.3619398337472d+02,
     |  -1.5821591280728d+02,-1.2182565093053d+02, 3.7974276387857d+02,
     |  -5.9403126910123d+02, 7.4722212812306d+02,-8.2699994573242d+02,
     |   8.2699994573242d+02,-7.4722212812306d+02, 5.9403126910123d+02,
     |  -3.7974276387856d+02, 1.2182565093053d+02, 1.5821591280727d+02,
     |  -4.3619398337474d+02, 6.8670744401983d+02,-8.8459498054386d+02,
     |   1.0062073483959d+03,-1.0302977916755d+03, 9.3826306456907d+02,
     |  -7.1336122393935d+02, 3.3853360571998d+02, 2.0564201786410d+02,
     |  -9.1715057559302d+02, 1.3080669835152d+03,-1.0916940203074d+03/
      data (lpmn(lat, 4,32), lat = 1,36)/
     |   3.9519366729484d+02,-2.1086908494968d+02,-5.6798828402904d+02,
     |   1.1775249807478d+03,-1.2539710680848d+03, 1.0678505372111d+03,
     |  -7.5483302278495d+02, 3.9072765720279d+02,-2.5535812027445d+01,
     |  -3.0445018759089d+02, 5.7251340732000d+02,-7.6024610798736d+02,
     |   8.5723023094517d+02,-8.6087606682246d+02, 7.7607614132177d+02,
     |  -6.1453192288563d+02, 3.9371631837957d+02,-1.3549869889078d+02,
     |  -1.3549869889079d+02, 3.9371631837957d+02,-6.1453192288564d+02,
     |   7.7607614132177d+02,-8.6087606682246d+02, 8.5723023094517d+02,
     |  -7.6024610798736d+02, 5.7251340732000d+02,-3.0445018759088d+02,
     |  -2.5535812027451d+01, 3.9072765720279d+02,-7.5483302278496d+02,
     |   1.0678505372111d+03,-1.2539710680848d+03, 1.1775249807478d+03,
     |  -5.6798828402902d+02,-2.1086908494968d+02, 3.9519366729484d+02/
      data (lpmn(lat, 5,32), lat = 1,36)/
     |   9.2793110564711d+01, 3.7770541706401d+02,-1.0222372988206d+03,
     |   9.9138019429720d+02,-4.0109384043770d+02,-1.7518991216301d+02,
     |   6.0562530286086d+02,-8.6745949556489d+02, 9.6912313646539d+02,
     |  -9.3107849799242d+02, 7.8020477524820d+02,-5.4734016508853d+02,
     |   2.6542196718891d+02, 3.2374460486998d+01,-3.1455690155803d+02,
     |   5.5320155738973d+02,-7.2566860500406d+02, 8.1601808807860d+02,
     |  -8.1601808807860d+02, 7.2566860500405d+02,-5.5320155738972d+02,
     |   3.1455690155803d+02,-3.2374460486996d+01,-2.6542196718890d+02,
     |   5.4734016508855d+02,-7.8020477524820d+02, 9.3107849799243d+02,
     |  -9.6912313646539d+02, 8.6745949556488d+02,-6.0562530286085d+02,
     |   1.7518991216301d+02, 4.0109384043770d+02,-9.9138019429721d+02,
     |   1.0222372988206d+03,-3.7770541706401d+02,-9.2793110564711d+01/
      data (lpmn(lat, 6,32), lat = 1,36)/
     |   1.6176259617614d+01, 3.8493838885902d+02,-5.6271538587866d+02,
     |  -5.7096292643388d+01, 8.0164426835415d+02,-1.0697238418931d+03,
     |   9.9110555582738d+02,-7.1404408683602d+02, 3.4679239414603d+02,
     |   3.3944467873022d+01,-3.7387005872934d+02, 6.3594693540933d+02,
     |  -7.9770792677312d+02, 8.4965354237570d+02,-7.9393502181331d+02,
     |   6.4291010161746d+02,-4.1739019297865d+02, 1.4453796763034d+02,
     |   1.4453796763034d+02,-4.1739019297865d+02, 6.4291010161747d+02,
     |  -7.9393502181331d+02, 8.4965354237570d+02,-7.9770792677313d+02,
     |   6.3594693540932d+02,-3.7387005872934d+02, 3.3944467873017d+01,
     |   3.4679239414604d+02,-7.1404408683602d+02, 9.9110555582739d+02,
     |  -1.0697238418931d+03, 8.0164426835415d+02,-5.7096292643376d+01,
     |  -5.6271538587867d+02, 3.8493838885902d+02, 1.6176259617614d+01/
      data (lpmn(lat, 7,32), lat = 1,36)/
     |   2.2400097702486d+00, 2.1632681454114d+02,-1.3611247185827d+01,
     |  -7.1101614072479d+02, 9.7818482221648d+02,-5.6607099059662d+02,
     |   9.6384369283331d-01, 4.7756540472943d+02,-7.8518114105977d+02,
     |   9.0706826217679d+02,-8.6123549102647d+02, 6.8227279388990d+02,
     |  -4.1296561516128d+02, 9.8959907374689d+01, 2.1528753467210d+02,
     |  -4.8986673310862d+02, 6.9221692661756d+02,-7.9933967574605d+02,
     |   7.9933967574604d+02,-6.9221692661756d+02, 4.8986673310861d+02,
     |  -2.1528753467210d+02,-9.8959907374691d+01, 4.1296561516127d+02,
     |  -6.8227279388991d+02, 8.6123549102647d+02,-9.0706826217679d+02,
     |   7.8518114105977d+02,-4.7756540472942d+02,-9.6384369284608d-01,
     |   5.6607099059662d+02,-9.7818482221648d+02, 7.1101614072479d+02,
     |   1.3611247185832d+01,-2.1632681454114d+02,-2.2400097702486d+00/
      data (lpmn(lat, 8,32), lat = 1,36)/
     |   2.5667880174407d-01, 8.9059123307405d+01, 2.2997685767282d+02,
     |  -6.4578751652075d+02, 2.8032544661412d+02, 4.7730741384976d+02,
     |  -8.9345057068545d+02, 9.2583249043704d+02,-6.9349951418206d+02,
     |   3.2506120377485d+02, 7.4267762196624d+01,-4.2699078684937d+02,
     |   6.8162760080902d+02,-8.1006871186108d+02, 8.0481738873731d+02,
     |  -6.7604381919528d+02, 4.4829089402891d+02,-1.5676318788588d+02,
     |  -1.5676318788588d+02, 4.4829089402891d+02,-6.7604381919529d+02,
     |   8.0481738873731d+02,-8.1006871186108d+02, 6.8162760080903d+02,
     |  -4.2699078684936d+02, 7.4267762196624d+01, 3.2506120377485d+02,
     |  -6.9349951418207d+02, 9.2583249043704d+02,-8.9345057068544d+02,
     |   4.7730741384976d+02, 2.8032544661412d+02,-6.4578751652075d+02,
     |   2.2997685767282d+02, 8.9059123307405d+01, 2.5667880174407d-01/
      data (lpmn(lat, 9,32), lat = 1,36)/
     |   2.5014616193646d-02, 2.9405200817062d+01, 2.2663379903178d+02,
     |  -2.5729205990110d+02,-4.0696547687214d+02, 8.8532799267838d+02,
     |  -6.6569008478961d+02, 1.4703169706852d+02, 3.6271408427708d+02,
     |  -7.1181468346264d+02, 8.5132676148645d+02,-7.9176696877348d+02,
     |   5.7624484392338d+02,-2.6368795882141d+02,-8.2433805817128d+01,
     |   4.0226297648455d+02,-6.4566583829248d+02, 7.7672310147365d+02,
     |  -7.7672310147365d+02, 6.4566583829247d+02,-4.0226297648454d+02,
     |   8.2433805817126d+01, 2.6368795882141d+02,-5.7624484392337d+02,
     |   7.9176696877348d+02,-8.5132676148645d+02, 7.1181468346264d+02,
     |  -3.6271408427708d+02,-1.4703169706852d+02, 6.6569008478961d+02,
     |  -8.8532799267838d+02, 4.0696547687214d+02, 2.5729205990110d+02,
     |  -2.2663379903178d+02,-2.9405200817062d+01,-2.5014616193646d-02/
      data (lpmn(lat,10,32), lat = 1,36)/
     |   2.1141895584853d-03, 8.1433756560729d+00, 1.4163135333752d+02,
     |   5.3790509776102d+01,-5.9277478208108d+02, 4.8100434398242d+02,
     |   2.1316250808957d+02,-7.2747638883887d+02, 8.5802763760786d+02,
     |  -6.6810956564525d+02, 2.9554154954558d+02, 1.2453014548610d+02,
     |  -4.8632766343952d+02, 7.2064063087814d+02,-7.9439085756412d+02,
     |   7.0683953620582d+02,-4.8397707184962d+02, 1.7172013638893d+02,
     |   1.7172013638894d+02,-4.8397707184962d+02, 7.0683953620582d+02,
     |  -7.9439085756412d+02, 7.2064063087814d+02,-4.8632766343953d+02,
     |   1.2453014548609d+02, 2.9554154954558d+02,-6.6810956564526d+02,
     |   8.5802763760786d+02,-7.2747638883887d+02, 2.1316250808956d+02,
     |   4.8100434398242d+02,-5.9277478208108d+02, 5.3790509776100d+01,
     |   1.4163135333752d+02, 8.1433756560729d+00, 2.1141895584853d-03/
      data (lpmn(lat,11,32), lat = 1,36)/
     |   1.5723283376163d-04, 1.9431363268888d+00, 6.8515452887323d+01,
     |   1.6937657719204d+02,-3.8508461082004d+02,-1.4636986086696d+02,
     |   7.4776134081727d+02,-7.0147700828340d+02, 2.4544283696590d+02,
     |   2.8048423663427d+02,-6.5934215822793d+02, 8.0226019538556d+02,
     |  -7.1113446111159d+02, 4.4248259858240d+02,-7.9383113261555d+01,
     |  -2.8938866299879d+02, 5.8468009883717d+02,-7.4785566865261d+02,
     |   7.4785566865261d+02,-5.8468009883717d+02, 2.8938866299878d+02,
     |   7.9383113261556d+01,-4.4248259858240d+02, 7.1113446111159d+02,
     |  -8.0226019538556d+02, 6.5934215822793d+02,-2.8048423663426d+02,
     |  -2.4544283696590d+02, 7.0147700828341d+02,-7.4776134081727d+02,
     |   1.4636986086696d+02, 3.8508461082004d+02,-1.6937657719204d+02,
     |  -6.8515452887324d+01,-1.9431363268888d+00,-1.5723283376163d-04/
      data (lpmn(lat,12,32), lat = 1,36)/
     |   1.0404144615390d-05, 4.0674241713583d-01, 2.7503312032227d+01,
     |   1.5414404736132d+02,-9.6056175970892d+01,-4.7414689051870d+02,
     |   5.7386887539603d+02, 1.9572124122338d+01,-5.8667067625360d+02,
     |   7.8983706076865d+02,-6.2641195927778d+02, 2.3891342678489d+02,
     |   2.0321284536401d+02,-5.6039231555425d+02, 7.4507383027384d+02,
     |  -7.2571775761745d+02, 5.2104662510422d+02,-1.8878785659972d+02,
     |  -1.8878785659972d+02, 5.2104662510422d+02,-7.2571775761745d+02,
     |   7.4507383027384d+02,-5.6039231555425d+02, 2.0321284536402d+02,
     |   2.3891342678491d+02,-6.2641195927778d+02, 7.8983706076865d+02,
     |  -5.8667067625360d+02, 1.9572124122335d+01, 5.7386887539604d+02,
     |  -4.7414689051870d+02,-9.6056175970893d+01, 1.5414404736132d+02,
     |   2.7503312032227d+01, 4.0674241713583d-01, 1.0404144615390d-05/
      data (lpmn(lat,13,32), lat = 1,36)/
     |   6.1784098320287d-07, 7.5647864360009d-02, 9.4862865111307d+00,
     |   9.8141817437338d+01, 8.3637051375851d+01,-4.2422852912557d+02,
     |   4.8775236213946d+01, 6.0291327239949d+02,-6.8992984397076d+02,
     |   2.9125359805713d+02, 2.4302393547887d+02,-6.3421649457792d+02,
     |   7.5337836466782d+02,-6.0033348422708d+02, 2.5801810737743d+02,
     |   1.5234816101932d+02,-5.0807153912271d+02, 7.1236361030235d+02,
     |  -7.1236361030235d+02, 5.0807153912271d+02,-1.5234816101932d+02,
     |  -2.5801810737743d+02, 6.0033348422708d+02,-7.5337836466782d+02,
     |   6.3421649457792d+02,-2.4302393547887d+02,-2.9125359805713d+02,
     |   6.8992984397077d+02,-6.0291327239949d+02,-4.8775236213952d+01,
     |   4.2422852912557d+02,-8.3637051375850d+01,-9.8141817437339d+01,
     |  -9.4862865111309d+00,-7.5647864360009d-02,-6.1784098320287d-07/
      data (lpmn(lat,14,32), lat = 1,36)/
     |   3.3150650563314d-08, 1.2619077828044d-02, 2.8705987396426d+00,
     |   5.0204771780446d+01, 1.3308127637183d+02,-1.9924437655093d+02,
     |  -3.4013830182990d+02, 5.9142318867924d+02,-1.0130908922083d+02,
     |  -4.8550943479566d+02, 7.2724263515940d+02,-5.6053458098276d+02,
     |   1.4023943118452d+02, 3.1899164049757d+02,-6.3881774334309d+02,
     |   7.2078129916810d+02,-5.5498438791035d+02, 2.0714701369730d+02,
     |   2.0714701369731d+02,-5.5498438791036d+02, 7.2078129916810d+02,
     |  -6.3881774334309d+02, 3.1899164049756d+02, 1.4023943118451d+02,
     |  -5.6053458098277d+02, 7.2724263515940d+02,-4.8550943479566d+02,
     |  -1.0130908922083d+02, 5.9142318867924d+02,-3.4013830182990d+02,
     |  -1.9924437655093d+02, 1.3308127637183d+02, 5.0204771780446d+01,
     |   2.8705987396427d+00, 1.2619077828044d-02, 3.3150650563314d-08/
      data (lpmn(lat,15,32), lat = 1,36)/
     |   1.6156978567128d-09, 1.9015023425448d-03, 7.7262380942202d-01,
     |   2.1767167694567d+01, 1.0949085346663d+02,-7.5216233175204d-01,
     |  -4.0619045352141d+02, 1.7336051973373d+02, 4.8014436697357d+02,
     |  -6.5052263392590d+02, 2.8484971499048d+02, 2.5680782722733d+02,
     |  -6.3388562517324d+02, 6.8549596878178d+02,-4.3024098643160d+02,
     |   3.8278088521985d+00, 4.1521843081779d+02,-6.6982747260104d+02,
     |   6.6982747260104d+02,-4.1521843081779d+02,-3.8278088522057d+00,
     |   4.3024098643160d+02,-6.8549596878178d+02, 6.3388562517325d+02,
     |  -2.5680782722732d+02,-2.8484971499048d+02, 6.5052263392590d+02,
     |  -4.8014436697357d+02,-1.7336051973373d+02, 4.0619045352141d+02,
     |   7.5216233175204d-01,-1.0949085346663d+02,-2.1767167694567d+01,
     |  -7.7262380942205d-01,-1.9015023425448d-03,-1.6156978567128d-09/
      data (lpmn(lat,16,32), lat = 1,36)/
     |   7.1825238215690d-11, 2.6022143082832d-04, 1.8673214765169d-01,
     |   8.2226530246931d+00, 6.7814270915035d+01, 9.4009769046391d+01,
     |  -2.5422796132830d+02,-2.2417793075259d+02, 5.6542465673161d+02,
     |  -1.5453164379359d+02,-4.3232657773927d+02, 6.7075487680919d+02,
     |  -4.5811464601145d+02,-1.2642769403554d+01, 4.6294501243269d+02,
     |  -6.7872727895586d+02, 5.8004689052655d+02,-2.2573582290486d+02,
     |  -2.2573582290486d+02, 5.8004689052655d+02,-6.7872727895586d+02,
     |   4.6294501243269d+02,-1.2642769403552d+01,-4.5811464601145d+02,
     |   6.7075487680919d+02,-4.3232657773927d+02,-1.5453164379360d+02,
     |   5.6542465673162d+02,-2.2417793075259d+02,-2.5422796132830d+02,
     |   9.4009769046391d+01, 6.7814270915035d+01, 8.2226530246933d+00,
     |   1.8673214765169d-01, 2.6022143082832d-04, 7.1825238215690d-11/
      data (lpmn(lat,17,32), lat = 1,36)/
     |   2.9215099819859d-12, 3.2472936372622d-05, 4.0801256953746d-02,
     |   2.7512630027100d+00, 3.4707732140758d+01, 1.0408029118224d+02,
     |  -6.5736015935916d+01,-3.6129589652390d+02, 2.3437090621142d+02,
     |   3.9693020931180d+02,-5.9681329947018d+02, 2.2568808503985d+02,
     |   3.2147614664373d+02,-6.3884890006160d+02, 5.5974451938422d+02,
     |  -1.6799015766873d+02,-3.0667019047810d+02, 6.1980567299758d+02,
     |  -6.1980567299758d+02, 3.0667019047810d+02, 1.6799015766874d+02,
     |  -5.5974451938422d+02, 6.3884890006160d+02,-3.2147614664373d+02,
     |  -2.2568808503986d+02, 5.9681329947018d+02,-3.9693020931180d+02,
     |  -2.3437090621142d+02, 3.6129589652390d+02, 6.5736015935918d+01,
     |  -1.0408029118224d+02,-3.4707732140758d+01,-2.7512630027100d+00,
     |  -4.0801256953747d-02,-3.2472936372622d-05,-2.9215099819859d-12/
      data (lpmn(lat,18,32), lat = 1,36)/
     |   1.0897748598649d-13, 3.7060130707815d-06, 8.0990344996170d-03,
     |   8.2408300787098d-01, 1.5275597438160d+01, 7.6299832080563d+01,
     |   5.2801747123183d+01,-2.7060491153399d+02,-1.4419337080746d+02,
     |   5.2032056206613d+02,-1.4711023794213d+02,-4.2662395917677d+02,
     |   6.0732271719063d+02,-2.9818512873985d+02,-2.1994786788056d+02,
     |   5.8708698220948d+02,-5.8926215053698d+02, 2.4318835621007d+02,
     |   2.4318835621007d+02,-5.8926215053698d+02, 5.8708698220948d+02,
     |  -2.1994786788056d+02,-2.9818512873985d+02, 6.0732271719063d+02,
     |  -4.2662395917677d+02,-1.4711023794213d+02, 5.2032056206613d+02,
     |  -1.4419337080746d+02,-2.7060491153400d+02, 5.2801747123182d+01,
     |   7.6299832080563d+01, 1.5275597438160d+01, 8.2408300787099d-01,
     |   8.0990344996173d-03, 3.7060130707815d-06, 1.0897748598649d-13/
      data (lpmn(lat,19,32), lat = 1,36)/
     |   3.7333944221348d-15, 3.8757519241064d-07, 1.4653764833496d-03,
     |   2.2252909143944d-01, 5.9053072350385d+00, 4.4421820463681d+01,
     |   8.8969449009159d+01,-1.0429452754346d+02,-3.1294005808117d+02,
     |   2.4324921760581d+02, 3.5887435188187d+02,-5.2972492328800d+02,
     |   1.0914739127128d+02, 4.2203059632267d+02,-6.0017243449089d+02,
     |   3.2074285696486d+02, 1.8499111095824d+02,-5.6187098684457d+02,
     |   5.6187098684457d+02,-1.8499111095824d+02,-3.2074285696486d+02,
     |   6.0017243449089d+02,-4.2203059632267d+02,-1.0914739127127d+02,
     |   5.2972492328801d+02,-3.5887435188187d+02,-2.4324921760581d+02,
     |   3.1294005808118d+02, 1.0429452754346d+02,-8.8969449009159d+01,
     |  -4.4421820463681d+01,-5.9053072350385d+00,-2.2252909143944d-01,
     |  -1.4653764833496d-03,-3.8757519241064d-07,-3.7333944221348d-15/
      data (lpmn(lat,20,32), lat = 1,36)/
     |   1.1754760232804d-16, 3.7182767477116d-08, 2.4217749067123d-04,
     |   5.4422732772339d-02, 2.0304280317721d+00, 2.1818151017246d+01,
     |   7.6184558661777d+01, 2.0923236755552d+01,-2.6133236061314d+02,
     |  -1.0606542557679d+02, 4.6823714112057d+02,-8.3484625650890d+01,
     |  -4.5441927679789d+02, 5.0316411765234d+02,-5.9525072495214d+01,
     |  -4.3853087663255d+02, 5.7468182280627d+02,-2.5774603664164d+02,
     |  -2.5774603664164d+02, 5.7468182280627d+02,-4.3853087663255d+02,
     |  -5.9525072495215d+01, 5.0316411765234d+02,-4.5441927679789d+02,
     |  -8.3484625650896d+01, 4.6823714112057d+02,-1.0606542557679d+02,
     |  -2.6133236061314d+02, 2.0923236755551d+01, 7.6184558661778d+01,
     |   2.1818151017246d+01, 2.0304280317721d+00, 5.4422732772340d-02,
     |   2.4217749067124d-04, 3.7182767477116d-08, 1.1754760232804d-16/
      data (lpmn(lat,21,32), lat = 1,36)/
     |   3.4012210996534d-18, 3.2731351942548d-09, 3.6594782902912d-05,
     |   1.2087949407643d-02, 6.2565467947880d-01, 9.2981902839676d+00,
     |   4.8985566876645d+01, 7.2132808720301d+01,-1.1683436908769d+02,
     |  -2.7443455470874d+02, 2.0907685684568d+02, 3.5963535661628d+02,
     |  -4.3286473155784d+02,-6.7144714703944d+01, 5.0859902205255d+02,
     |  -4.3347230468834d+02,-5.5892737888143d+01, 4.9566842904326d+02,
     |  -4.9566842904326d+02, 5.5892737888141d+01, 4.3347230468835d+02,
     |  -5.0859902205255d+02, 6.7144714703943d+01, 4.3286473155783d+02,
     |  -3.5963535661628d+02,-2.0907685684568d+02, 2.7443455470874d+02,
     |   1.1683436908769d+02,-7.2132808720301d+01,-4.8985566876645d+01,
     |  -9.2981902839676d+00,-6.2565467947880d-01,-1.2087949407644d-02,
     |  -3.6594782902913d-05,-3.2731351942548d-09,-3.4012210996534d-18/
      data (lpmn(lat,22,32), lat = 1,36)/
     |   9.0360156907609d-20, 2.6420242809489d-10, 5.0556419019512d-06,
     |   2.4413837507794d-03, 1.7353728913929d-01, 3.4902255821661d+00,
     |   2.5926339140049d+01, 7.0539953198026d+01, 4.1636241580285d+00,
     |  -2.3649591961961d+02,-1.0741565170361d+02, 4.0580557829203d+02,
     |   3.3051333560656d+01,-4.7686736636766d+02, 3.0583623720214d+02,
     |   2.3791298241019d+02,-5.2812753078239d+02, 2.6712480469781d+02,
     |   2.6712480469781d+02,-5.2812753078239d+02, 2.3791298241019d+02,
     |   3.0583623720214d+02,-4.7686736636766d+02, 3.3051333560660d+01,
     |   4.0580557829203d+02,-1.0741565170361d+02,-2.3649591961961d+02,
     |   4.1636241580283d+00, 7.0539953198026d+01, 2.5926339140049d+01,
     |   3.4902255821661d+00, 1.7353728913929d-01, 2.4413837507794d-03,
     |   5.0556419019514d-06, 2.6420242809489d-10, 9.0360156907609d-20/
      data (lpmn(lat,23,32), lat = 1,36)/
     |   2.2001230367549d-21, 1.9523199963696d-11, 6.3781919955579d-07,
     |   4.4827496543665d-04, 4.3413539733778d-02, 1.1633989915984d+00,
     |   1.1719581771631d+01, 4.8430409747484d+01, 5.9300647861010d+01,
     |  -1.0680948451957d+02,-2.4790812354250d+02, 1.3563678320042d+02,
     |   3.7639520571367d+02,-2.7419164131892d+02,-2.7518734346556d+02,
     |   4.7081507173101d+02,-7.0329157362384d+01,-4.2101076095358d+02,
     |   4.2101076095358d+02, 7.0329157362386d+01,-4.7081507173101d+02,
     |   2.7518734346556d+02, 2.7419164131892d+02,-3.7639520571367d+02,
     |  -1.3563678320042d+02, 2.4790812354250d+02, 1.0680948451957d+02,
     |  -5.9300647861010d+01,-4.8430409747483d+01,-1.1719581771631d+01,
     |  -1.1633989915984d+00,-4.3413539733778d-02,-4.4827496543666d-04,
     |  -6.3781919955582d-07,-1.9523199963696d-11,-2.2001230367549d-21/
      data (lpmn(lat,24,32), lat = 1,36)/
     |   4.8952331530729d-23, 1.3170530332559d-12, 7.3306183222792d-08,
     |   7.4706628046560d-05, 9.7947688748391d-03, 3.4568604822213d-01,
     |   4.6047926392265d+00, 2.6624047963274d+01, 6.2534008259185d+01,
     |   3.3892275055302d+00,-1.9966522388099d+02,-1.3833403396016d+02,
     |   3.1359751639418d+02, 1.8500324534529d+02,-4.1622501490482d+02,
     |  -1.1955287540637d+01, 4.4286546745827d+02,-2.6830099831787d+02,
     |  -2.6830099831787d+02, 4.4286546745827d+02,-1.1955287540634d+01,
     |  -4.1622501490482d+02, 1.8500324534529d+02, 3.1359751639418d+02,
     |  -1.3833403396016d+02,-1.9966522388099d+02, 3.3892275055298d+00,
     |   6.2534008259186d+01, 2.6624047963274d+01, 4.6047926392265d+00,
     |   3.4568604822213d-01, 9.7947688748391d-03, 7.4706628046563d-05,
     |   7.3306183222796d-08, 1.3170530332559d-12, 4.8952331530728d-23/
      data (lpmn(lat,25,32), lat = 1,36)/
     |   9.9102574926336d-25, 8.0775252474781d-14, 7.6457495408393d-09,
     |   1.1262841584959d-05, 1.9887133549375d-03, 9.1605982230947d-02,
     |   1.5854439330085d+00, 1.2264743758594d+01, 4.3712332656714d+01,
     |   5.2421231540687d+01,-7.7854328837634d+01,-2.2364702225532d+02,
     |   2.6538773428273d+01, 3.6025126168779d+02,-3.2454269830921d+01,
     |  -4.0074758545882d+02, 1.7715038502859d+02, 3.3804607858103d+02,
     |  -3.3804607858103d+02,-1.7715038502859d+02, 4.0074758545882d+02,
     |   3.2454269830922d+01,-3.6025126168779d+02,-2.6538773428271d+01,
     |   2.2364702225532d+02, 7.7854328837634d+01,-5.2421231540687d+01,
     |  -4.3712332656714d+01,-1.2264743758594d+01,-1.5854439330086d+00,
     |  -9.1605982230947d-02,-1.9887133549375d-03,-1.1262841584960d-05,
     |  -7.6457495408397d-09,-8.0775252474781d-14,-9.9102574926335d-25/
      data (lpmn(lat,26,32), lat = 1,36)/
     |   1.8143223897899d-26, 4.4766738270013d-15, 7.1948452928548d-10,
     |   1.5279108244682d-06, 3.6176749804603d-04, 2.1593620308763d-02,
     |   4.7931572121438d-01, 4.8240754778018d+00, 2.3824509495757d+01,
     |   5.3599949088372d+01, 1.5329344092426d+01,-1.4771242470348d+02,
     |  -1.7614905211315d+02, 1.6614826627735d+02, 3.0485869291177d+02,
     |  -1.8126492501129d+02,-3.1702942715089d+02, 2.5712619713159d+02,
     |   2.5712619713159d+02,-3.1702942715089d+02,-1.8126492501129d+02,
     |   3.0485869291177d+02, 1.6614826627735d+02,-1.7614905211315d+02,
     |  -1.4771242470348d+02, 1.5329344092426d+01, 5.3599949088372d+01,
     |   2.3824509495758d+01, 4.8240754778018d+00, 4.7931572121439d-01,
     |   2.1593620308763d-02, 3.6176749804603d-04, 1.5279108244683d-06,
     |   7.1948452928552d-10, 4.4766738270013d-15, 1.8143223897899d-26/
      data (lpmn(lat,27,32), lat = 1,36)/
     |   2.9776423959434d-28, 2.2227165298180d-16, 6.0573398912480d-11,
     |   1.8501587598797d-07, 5.8528007680361d-05, 4.5005739233050d-03,
     |   1.2685943364927d-01, 1.6296244811807d+00, 1.0632790661838d+01,
     |   3.5628248451004d+01, 4.9119937382681d+01,-3.4595849706154d+01,
     |  -1.8075074453980d+02,-9.5142858850449d+01, 2.4015283767100d+02,
     |   2.1893171990569d+02,-2.4040839977203d+02,-2.4758204567481d+02,
     |   2.4758204567481d+02, 2.4040839977203d+02,-2.1893171990569d+02,
     |  -2.4015283767100d+02, 9.5142858850449d+01, 1.8075074453980d+02,
     |   3.4595849706155d+01,-4.9119937382681d+01,-3.5628248451004d+01,
     |  -1.0632790661838d+01,-1.6296244811807d+00,-1.2685943364928d-01,
     |  -4.5005739233050d-03,-5.8528007680360d-05,-1.8501587598797d-07,
     |  -6.0573398912483d-11,-2.2227165298180d-16,-2.9776423959434d-28/
      data (lpmn(lat,28,32), lat = 1,36)/
     |   4.3258672030977d-30, 9.7636215237195d-18, 4.5063131954744d-12,
     |   1.9757575788008d-08, 8.3245920012521d-06, 8.2068719392284d-04,
     |   2.9146762968298d-02, 4.7129535255087d-01, 3.9454089278727d+00,
     |   1.8020441987146d+01, 4.2762070581660d+01, 3.1802752077339d+01,
     |  -7.7046012460364d+01,-1.7764488775198d+02,-2.5465270089377d+01,
     |   2.5389834339805d+02, 1.6052790654992d+02,-2.2750334923491d+02,
     |  -2.2750334923491d+02, 1.6052790654992d+02, 2.5389834339805d+02,
     |  -2.5465270089377d+01,-1.7764488775198d+02,-7.7046012460364d+01,
     |   3.1802752077339d+01, 4.2762070581660d+01, 1.8020441987146d+01,
     |   3.9454089278727d+00, 4.7129535255087d-01, 2.9146762968299d-02,
     |   8.2068719392284d-04, 8.3245920012521d-06, 1.9757575788009d-08,
     |   4.5063131954747d-12, 9.7636215237195d-18, 4.3258672030977d-30/
      data (lpmn(lat,29,32), lat = 1,36)/
     |   5.4579936042747d-32, 3.7228918848443d-19, 2.9070038661293d-13,
     |   1.8263651188399d-09, 1.0221908536050d-06, 1.2867576348002d-04,
     |   5.7216311700566d-03, 1.1523530294879d-01, 1.2135071927021d+00,
     |   7.2129345164016d+00, 2.4545363925439d+01, 4.2964005710013d+01,
     |   1.1180548321647d+01,-9.8724623908557d+01,-1.5695446386151d+02,
     |   5.3144837835681d+00, 2.2871728660452d+02, 1.5182580075420d+02,
     |  -1.5182580075420d+02,-2.2871728660452d+02,-5.3144837835691d+00,
     |   1.5695446386151d+02, 9.8724623908557d+01,-1.1180548321647d+01,
     |  -4.2964005710013d+01,-2.4545363925439d+01,-7.2129345164016d+00,
     |  -1.2135071927021d+00,-1.1523530294879d-01,-5.7216311700566d-03,
     |  -1.2867576348002d-04,-1.0221908536050d-06,-1.8263651188399d-09,
     |  -2.9070038661295d-13,-3.7228918848443d-19,-5.4579936042747d-32/
      data (lpmn(lat,30,32), lat = 1,36)/
     |   5.7979449361932d-34, 1.1946434095037d-20, 1.5767123031846d-14,
     |   1.4172948075601d-10, 1.0512699844184d-07, 1.6839662568878d-05,
     |   9.3261977519157d-04, 2.3203224077504d-02, 3.0302871779482d-01,
     |   2.2783276832880d+00, 1.0313711313867d+01, 2.7811526870596d+01,
     |   3.8352047801142d+01,-1.5522001330920d+00,-9.6562075717464d+01,
     |  -1.3598929044548d+02,-1.0189901712281d+01, 1.6900009215379d+02,
     |   1.6900009215379d+02,-1.0189901712281d+01,-1.3598929044548d+02,
     |  -9.6562075717464d+01,-1.5522001330920d+00, 3.8352047801142d+01,
     |   2.7811526870597d+01, 1.0313711313867d+01, 2.2783276832880d+00,
     |   3.0302871779482d-01, 2.3203224077504d-02, 9.3261977519158d-04,
     |   1.6839662568878d-05, 1.0512699844184d-07, 1.4172948075601d-10,
     |   1.5767123031848d-14, 1.1946434095037d-20, 5.7979449361932d-34/
      data (lpmn(lat,31,32), lat = 1,36)/
     |   4.8945941502676d-36, 3.0452659691878d-22, 6.7877681400158d-16,
     |   8.7179337141756d-12, 8.5526142229240d-09, 1.7381535965204d-06,
     |   1.1937545127942d-04, 3.6446421466127d-03, 5.8399411520572d-02,
     |   5.4485131488213d-01, 3.1505334131191d+00, 1.1603692441009d+01,
     |   2.6693317532872d+01, 3.3028307269779d+01, 5.3344171041747d-01,
     |  -7.0649919105844d+01,-1.1262509137661d+02,-5.6719858224815d+01,
     |   5.6719858224815d+01, 1.1262509137661d+02, 7.0649919105844d+01,
     |  -5.3344171041747d-01,-3.3028307269779d+01,-2.6693317532872d+01,
     |  -1.1603692441009d+01,-3.1505334131191d+00,-5.4485131488213d-01,
     |  -5.8399411520573d-02,-3.6446421466127d-03,-1.1937545127942d-04,
     |  -1.7381535965204d-06,-8.5526142229240d-09,-8.7179337141759d-12,
     |  -6.7877681400163d-16,-3.0452659691878d-22,-4.8945941502676d-36/
      data (lpmn(lat,32,32), lat = 1,36)/
     |   2.8467698385321d-38, 5.3462637223290d-24, 2.0110204187916d-17,
     |   3.6860421402736d-13, 4.7742393279139d-10, 1.2278656838569d-07,
     |   1.0419074932192d-05, 3.8824001922895d-04, 7.5689005213154d-03,
     |   8.6425115362532d-02, 6.2234041622144d-01, 2.9602627697183d+00,
     |   9.5122803866794d+00, 2.0494532772520d+01, 2.7529181745708d+01,
     |   1.5284248934579d+01,-1.9452595942523d+01,-5.2372114846823d+01,
     |  -5.2372114846823d+01,-1.9452595942524d+01, 1.5284248934578d+01,
     |   2.7529181745708d+01, 2.0494532772520d+01, 9.5122803866794d+00,
     |   2.9602627697183d+00, 6.2234041622144d-01, 8.6425115362532d-02,
     |   7.5689005213155d-03, 3.8824001922895d-04, 1.0419074932193d-05,
     |   1.2278656838569d-07, 4.7742393279139d-10, 3.6860421402738d-13,
     |   2.0110204187918d-17, 5.3462637223290d-24, 2.8467698385321d-38/
      data (lpmn(lat, 0,33), lat = 1,36)/
     |  -3.4622191452370d+03, 2.2449811145957d+03,-1.8743153041220d+03,
     |   1.6314602586089d+03,-1.4162155134563d+03, 1.2017281124017d+03,
     |  -9.8048791813692d+02, 7.5221270014465d+02,-5.1992127672044d+02,
     |   2.8829903400648d+02,-6.2860079278756d+01,-1.5056733283015d+02,
     |   3.4620490182132d+02,-5.1860680916725d+02, 6.6288920278779d+02,
     |  -7.7491815368839d+02, 8.5146010508378d+02,-8.9029556808223d+02,
     |   8.9029556808223d+02,-8.5146010508378d+02, 7.7491815368838d+02,
     |  -6.6288920278779d+02, 5.1860680916725d+02,-3.4620490182134d+02,
     |   1.5056733283014d+02, 6.2860079278756d+01,-2.8829903400648d+02,
     |   5.1992127672045d+02,-7.5221270014465d+02, 9.8048791813693d+02,
     |  -1.2017281124017d+03, 1.4162155134563d+03,-1.6314602586089d+03,
     |   1.8743153041220d+03,-2.2449811145957d+03, 3.4622191452370d+03/
      data (lpmn(lat, 1,33), lat = 1,36)/
     |  -1.9067172959766d+03, 1.2215244700998d+03,-5.4181023199204d+02,
     |   9.2536471557469d+01, 2.4275631962075d+02,-5.0287035705642d+02,
     |   7.0300508682934d+02,-8.4986720598267d+02, 9.4692288496727d+02,
     |  -9.9657385779572d+02, 1.0011705580647d+03,-9.6351125373976d+02,
     |   8.8708101385254d+02,-7.7614203818426d+02, 6.3572986335648d+02,
     |  -4.7158523584809d+02, 2.9004010985638d+02,-9.7870851736427d+01,
     |  -9.7870851736431d+01, 2.9004010985639d+02,-4.7158523584810d+02,
     |   6.3572986335648d+02,-7.7614203818426d+02, 8.8708101385254d+02,
     |  -9.6351125373977d+02, 1.0011705580647d+03,-9.9657385779572d+02,
     |   9.4692288496727d+02,-8.4986720598267d+02, 7.0300508682933d+02,
     |  -5.0287035705642d+02, 2.4275631962075d+02, 9.2536471557491d+01,
     |  -5.4181023199207d+02, 1.2215244700998d+03,-1.9067172959766d+03/
      data (lpmn(lat, 2,33), lat = 1,36)/
     |   1.2620306056201d+03,-1.3141311355864d+03, 1.5956664520788d+03,
     |  -1.5515213102187d+03, 1.4173533749536d+03,-1.2396917035023d+03,
     |   1.0345779287498d+03,-8.1135248081106d+02, 5.7771469101579d+02,
     |  -3.4096858824843d+02, 1.0827474159853d+02, 1.1340143663544d+02,
     |  -3.1744071605725d+02, 4.9774926168070d+02,-6.4893668273948d+02,
     |   7.6647834808881d+02,-8.4685337348484d+02, 8.8765258870195d+02,
     |  -8.8765258870195d+02, 8.4685337348484d+02,-7.6647834808880d+02,
     |   6.4893668273948d+02,-4.9774926168070d+02, 3.1744071605726d+02,
     |  -1.1340143663543d+02,-1.0827474159853d+02, 3.4096858824843d+02,
     |  -5.7771469101580d+02, 8.1135248081106d+02,-1.0345779287498d+03,
     |   1.2396917035023d+03,-1.4173533749536d+03, 1.5515213102187d+03,
     |  -1.5956664520787d+03, 1.3141311355864d+03,-1.2620306056201d+03/
      data (lpmn(lat, 3,33), lat = 1,36)/
     |   1.1827618654051d+03,-1.4831521771411d+03, 1.2316468365784d+03,
     |  -6.4429128046878d+02, 1.6565817490732d+02, 2.0776986906258d+02,
     |  -4.9540692533933d+02, 7.0989921267807d+02,-8.5902322007698d+02,
     |   9.4813935514310d+02,-9.8170805111115d+02, 9.6414469982197d+02,
     |  -9.0028064531632d+02, 7.9558712029700d+02,-6.5624960054767d+02,
     |   4.8914297295708d+02,-3.0173864995114d+02, 1.0196474989513d+02,
     |   1.0196474989513d+02,-3.0173864995115d+02, 4.8914297295709d+02,
     |  -6.5624960054768d+02, 7.9558712029700d+02,-9.0028064531632d+02,
     |   9.6414469982197d+02,-9.8170805111115d+02, 9.4813935514310d+02,
     |  -8.5902322007697d+02, 7.0989921267806d+02,-4.9540692533932d+02,
     |   2.0776986906258d+02, 1.6565817490732d+02,-6.4429128046880d+02,
     |   1.2316468365785d+03,-1.4831521771411d+03, 1.1827618654051d+03/
      data (lpmn(lat, 4,33), lat = 1,36)/
     |   4.4627239395375d+02,-3.5328309563078d+02,-3.6486986372902d+02,
     |   1.0240105656764d+03,-1.2460206182183d+03, 1.2493162631703d+03,
     |  -1.1353891580795d+03, 9.5358053268653d+02,-7.3207131204492d+02,
     |   4.8975891788774d+02,-2.4100984404143d+02,-2.3541345813611d+00,
     |   2.3022682198163d+02,-4.3390324542149d+02, 6.0600160624655d+02,
     |  -7.4049087436555d+02, 8.3275810770175d+02,-8.7968016073480d+02,
     |   8.7968016073480d+02,-8.3275810770174d+02, 7.4049087436554d+02,
     |  -6.0600160624655d+02, 4.3390324542149d+02,-2.3022682198164d+02,
     |   2.3541345813459d+00, 2.4100984404143d+02,-4.8975891788774d+02,
     |   7.3207131204493d+02,-9.5358053268653d+02, 1.1353891580795d+03,
     |  -1.2493162631703d+03, 1.2460206182183d+03,-1.0240105656764d+03,
     |   3.6486986372900d+02, 3.5328309563078d+02,-4.4627239395375d+02/
      data (lpmn(lat, 5,33), lat = 1,36)/
     |   1.0857463317818d+02, 3.5548478557305d+02,-1.0810809576938d+03,
     |   1.2349685536098d+03,-8.3007663067514d+02, 3.6100640265944d+02,
     |   5.5000311318369d+01,-3.9170507719029d+02, 6.4567959518229d+02,
     |  -8.1972419168942d+02, 9.1866814560180d+02,-9.4837489391586d+02,
     |   9.1557989166322d+02,-8.2790202762238d+02, 6.9384336652468d+02,
     |  -5.2273189360324d+02, 3.2460454909522d+02,-1.1004065229861d+02,
     |  -1.1004065229862d+02, 3.2460454909522d+02,-5.2273189360325d+02,
     |   6.9384336652468d+02,-8.2790202762238d+02, 9.1557989166322d+02,
     |  -9.4837489391586d+02, 9.1866814560180d+02,-8.1972419168942d+02,
     |   6.4567959518229d+02,-3.9170507719028d+02, 5.5000311318356d+01,
     |   3.6100640265944d+02,-8.3007663067514d+02, 1.2349685536098d+03,
     |  -1.0810809576938d+03, 3.5548478557305d+02, 1.0857463317818d+02/
      data (lpmn(lat, 6,33), lat = 1,36)/
     |   1.9576485240640d+01, 4.2128923329880d+02,-7.2068884643951d+02,
     |   2.2681698863068d+02, 5.2437013448764d+02,-9.4349533281443d+02,
     |   1.0916554181005d+03,-1.0601464367544d+03, 9.1418525303241d+02,
     |  -6.9845788380560d+02, 4.4496863892878d+02,-1.7792773551446d+02,
     |  -8.3559667332145d+01, 3.2407700817771d+02,-5.3117897659215d+02,
     |   6.9505128504847d+02,-8.0836841927052d+02, 8.6624853565340d+02,
     |  -8.6624853565340d+02, 8.0836841927052d+02,-6.9505128504846d+02,
     |   5.3117897659215d+02,-3.2407700817771d+02, 8.3559667332156d+01,
     |   1.7792773551448d+02,-4.4496863892878d+02, 6.9845788380560d+02,
     |  -9.1418525303242d+02, 1.0601464367544d+03,-1.0916554181005d+03,
     |   9.4349533281443d+02,-5.2437013448764d+02,-2.2681698863069d+02,
     |   7.2068884643951d+02,-4.2128923329880d+02,-1.9576485240640d+01/
      data (lpmn(lat, 7,33), lat = 1,36)/
     |   2.8021683541749d+00, 2.5277565279454d+02,-1.1479227158963d+02,
     |  -6.4148955668301d+02, 1.1063058069242d+03,-9.4181140988946d+02,
     |   5.4658537863087d+02,-1.1753811082513d+02,-2.6292123838753d+02,
     |   5.6203557567992d+02,-7.6895524881162d+02, 8.8333992850422d+02,
     |  -9.1053269356706d+02, 8.5939218596928d+02,-7.4121554832928d+02,
     |   5.6910723452182d+02,-3.5752222458635d+02, 1.2186950664334d+02,
     |   1.2186950664335d+02,-3.5752222458636d+02, 5.6910723452183d+02,
     |  -7.4121554832928d+02, 8.5939218596928d+02,-9.1053269356707d+02,
     |   8.8333992850422d+02,-7.6895524881162d+02, 5.6203557567992d+02,
     |  -2.6292123838752d+02,-1.1753811082513d+02, 5.4658537863088d+02,
     |  -9.4181140988946d+02, 1.1063058069242d+03,-6.4148955668300d+02,
     |  -1.1479227158964d+02, 2.5277565279454d+02, 2.8021683541749d+00/
      data (lpmn(lat, 8,33), lat = 1,36)/
     |   3.3188489781809d-01, 1.0927653576081d+02, 2.1210479988683d+02,
     |  -7.5357484199363d+02, 5.8364796316570d+02, 1.0422263410961d+02,
     |  -6.4412121993396d+02, 9.2542087746725d+02,-9.8510143875461d+02,
     |   8.8365710748535d+02,-6.7640056895540d+02, 4.0898436052827d+02,
     |  -1.1826388970972d+02,-1.6616934120792d+02, 4.2078626922027d+02,
     |  -6.2734059930916d+02, 7.7240959620718d+02,-8.4714398595752d+02,
     |   8.4714398595752d+02,-7.7240959620718d+02, 6.2734059930915d+02,
     |  -4.2078626922027d+02, 1.6616934120792d+02, 1.1826388970971d+02,
     |  -4.0898436052828d+02, 6.7640056895540d+02,-8.8365710748535d+02,
     |   9.8510143875462d+02,-9.2542087746724d+02, 6.4412121993395d+02,
     |  -1.0422263410961d+02,-5.8364796316570d+02, 7.5357484199363d+02,
     |  -2.1210479988683d+02,-1.0927653576081d+02,-3.3188489781809d-01/
      data (lpmn(lat, 9,33), lat = 1,36)/
     |   3.3437363221369d-02, 3.7659518785685d+01, 2.5088337620171d+02,
     |  -3.9244943304536d+02,-2.2752687714188d+02, 8.7858970748895d+02,
     |  -9.5321014068102d+02, 6.7482537756352d+02,-2.6407826285192d+02,
     |  -1.4662671559916d+02, 4.8757293321339d+02,-7.2634976126137d+02,
     |   8.5246524955284d+02,-8.6876095965911d+02, 7.8658861712005d+02,
     |  -6.2295632065104d+02, 3.9868748015847d+02,-1.3709423616373d+02,
     |  -1.3709423616373d+02, 3.9868748015847d+02,-6.2295632065104d+02,
     |   7.8658861712005d+02,-8.6876095965911d+02, 8.5246524955284d+02,
     |  -7.2634976126137d+02, 4.8757293321339d+02,-1.4662671559916d+02,
     |  -2.6407826285192d+02, 6.7482537756352d+02,-9.5321014068102d+02,
     |   8.7858970748895d+02,-2.2752687714188d+02,-3.9244943304536d+02,
     |   2.5088337620172d+02, 3.7659518785685d+01, 3.3437363221369d-02/
      data (lpmn(lat,10,33), lat = 1,36)/
     |   2.9227592465553d-03, 1.0856469283494d+01, 1.7044112017580d+02,
     |  -2.0089197254139d+01,-6.1502915245477d+02, 7.4858669440326d+02,
     |  -2.1306826040691d+02,-3.7313113810208d+02, 7.5946578052913d+02,
     |  -9.0512846892152d+02, 8.4728625193252d+02,-6.4471299214004d+02,
     |   3.5680209701651d+02,-3.6400757188647d+01,-2.7231216214804d+02,
     |   5.3423528813942d+02,-7.2325509235391d+02, 8.2207301410971d+02,
     |  -8.2207301410971d+02, 7.2325509235390d+02,-5.3423528813941d+02,
     |   2.7231216214804d+02, 3.6400757188649d+01,-3.5680209701650d+02,
     |   6.4471299214005d+02,-8.4728625193252d+02, 9.0512846892152d+02,
     |  -7.5946578052913d+02, 3.7313113810207d+02, 2.1306826040692d+02,
     |  -7.4858669440326d+02, 6.1502915245477d+02, 2.0089197254141d+01,
     |  -1.7044112017580d+02,-1.0856469283494d+01,-2.9227592465553d-03/
      data (lpmn(lat,11,33), lat = 1,36)/
     |   2.2492609110454d-04, 2.6933234365459d+00, 8.7616693921663d+01,
     |   1.5915713665115d+02,-5.0923129411700d+02, 1.0477728769383d+02,
     |   6.1352861085646d+02,-8.8543294440852d+02, 7.3644836437248d+02,
     |  -3.6309212126387d+02,-6.6282430959751d+01, 4.4212275048131d+02,
     |  -7.0425996712620d+02, 8.2802825243575d+02,-8.1325393759268d+02,
     |   6.7647210270777d+02,-4.4545812278060d+02, 1.5521254189588d+02,
     |   1.5521254189589d+02,-4.4545812278061d+02, 6.7647210270778d+02,
     |  -8.1325393759268d+02, 8.2802825243574d+02,-7.0425996712621d+02,
     |   4.4212275048130d+02,-6.6282430959751d+01,-3.6309212126387d+02,
     |   7.3644836437248d+02,-8.8543294440852d+02, 6.1352861085645d+02,
     |   1.0477728769383d+02,-5.0923129411700d+02, 1.5915713665115d+02,
     |   8.7616693921664d+01, 2.6933234365459d+00, 2.2492609110454d-04/
      data (lpmn(lat,12,33), lat = 1,36)/
     |   1.5411579129411d-05, 5.8589024569134d-01, 3.7045064808183d+01,
     |   1.7468537646408d+02,-2.0673546011297d+02,-4.0430851109756d+02,
     |   7.7013252160480d+02,-4.1918713500154d+02,-1.5697500303496d+02,
     |   6.1447107380602d+02,-8.2863428942947d+02, 8.0100306348331d+02,
     |  -5.8906675846648d+02, 2.6813664004848d+02, 8.7456661318373d+01,
     |  -4.1330611011373d+02, 6.5911989251580d+02,-7.9066918005260d+02,
     |   7.9066918005260d+02,-6.5911989251580d+02, 4.1330611011373d+02,
     |  -8.7456661318371d+01,-2.6813664004848d+02, 5.8906675846648d+02,
     |  -8.0100306348332d+02, 8.2863428942947d+02,-6.1447107380602d+02,
     |   1.5697500303496d+02, 4.1918713500154d+02,-7.7013252160480d+02,
     |   4.0430851109756d+02, 2.0673546011297d+02,-1.7468537646409d+02,
     |  -3.7045064808184d+01,-5.8589024569134d-01,-1.5411579129411d-05/
      data (lpmn(lat,13,33), lat = 1,36)/
     |   9.4845749106832d-07, 1.1324852146978d-01, 1.3402671138251d+01,
     |   1.2237880820481d+02, 3.3140713500259d+01,-5.0528513076939d+02,
     |   3.2958103649468d+02, 3.6737588628698d+02,-7.7733922845224d+02,
     |   7.4294240181220d+02,-4.0755243836838d+02,-3.6868714099364d+01,
     |   4.3925377960469d+02,-7.0703286905021d+02, 8.0004895545484d+02,
     |  -7.1900777199145d+02, 4.9417187282736d+02,-1.7555211997669d+02,
     |  -1.7555211997669d+02, 4.9417187282737d+02,-7.1900777199146d+02,
     |   8.0004895545484d+02,-7.0703286905021d+02, 4.3925377960470d+02,
     |  -3.6868714099353d+01,-4.0755243836838d+02, 7.4294240181220d+02,
     |  -7.7733922845224d+02, 3.6737588628697d+02, 3.2958103649469d+02,
     |  -5.0528513076939d+02, 3.3140713500258d+01, 1.2237880820481d+02,
     |   1.3402671138251d+01, 1.1324852146978d-01, 9.4845749106832d-07/
      data (lpmn(lat,14,33), lat = 1,36)/
     |   5.2790079213618d-08, 1.9642093938657d-02, 4.2456765222726d+00,
     |   6.7195523873651d+01, 1.3179125535967d+02,-3.2060572253010d+02,
     |  -1.9280926899393d+02, 7.0524158827191d+02,-5.2613221160341d+02,
     |  -1.1420019838397d+01, 5.1044861624360d+02,-7.6651440107647d+02,
     |   7.4170148542780d+02,-4.9430156358840d+02, 1.2373734932589d+02,
     |   2.6431829170571d+02,-5.7836175557648d+02, 7.5250368736628d+02,
     |  -7.5250368736628d+02, 5.7836175557648d+02,-2.6431829170570d+02,
     |  -1.2373734932589d+02, 4.9430156358840d+02,-7.4170148542780d+02,
     |   7.6651440107647d+02,-5.1044861624360d+02, 1.1420019838395d+01,
     |   5.2613221160342d+02,-7.0524158827191d+02, 1.9280926899393d+02,
     |   3.2060572253010d+02,-1.3179125535967d+02,-6.7195523873652d+01,
     |  -4.2456765222727d+00,-1.9642093938657d-02,-5.2790079213618d-08/
      data (lpmn(lat,15,33), lat = 1,36)/
     |   2.6719381948482d-09, 3.0796120548446d-03, 1.1952663121245d+00,
     |   3.0954323015748d+01, 1.2933694706593d+02,-8.4004092721364d+01,
     |  -4.3063345818631d+02, 4.5137913105885d+02, 1.7685764704664d+02,
     |  -6.6748148525139d+02, 7.1314284716643d+02,-3.9685429414767d+02,
     |  -6.8088741099553d+01, 4.8422974003216d+02,-7.2392179003140d+02,
     |   7.3709055396601d+02,-5.3995618242220d+02, 1.9723626522539d+02,
     |   1.9723626522539d+02,-5.3995618242220d+02, 7.3709055396601d+02,
     |  -7.2392179003140d+02, 4.8422974003216d+02,-6.8088741099561d+01,
     |  -3.9685429414768d+02, 7.1314284716643d+02,-6.6748148525139d+02,
     |   1.7685764704664d+02, 4.5137913105885d+02,-4.3063345818631d+02,
     |  -8.4004092721364d+01, 1.2933694706593d+02, 3.0954323015749d+01,
     |   1.1952663121246d+00, 3.0796120548446d-03, 2.6719381948482d-09/
      data (lpmn(lat,16,33), lat = 1,36)/
     |   1.2351304600843d-10, 4.3894871547491d-04, 3.0214349996895d-01,
     |   1.2363809313949d+01, 8.8765354633256d+01, 6.5729151295450d+01,
     |  -3.6472335447608d+02,-2.3700254077197d+01, 6.0737038060588d+02,
     |  -5.5815242925277d+02, 5.9143298900691d+01, 4.6019157472092d+02,
     |  -7.2243585870485d+02, 6.5708211137997d+02,-3.3825263573533d+02,
     |  -9.1304336453688d+01, 4.7993293866062d+02,-7.0710156341733d+02,
     |   7.0710156341733d+02,-4.7993293866062d+02, 9.1304336453681d+01,
     |   3.3825263573533d+02,-6.5708211137997d+02, 7.2243585870485d+02,
     |  -4.6019157472091d+02,-5.9143298900691d+01, 5.5815242925277d+02,
     |  -6.0737038060589d+02, 2.3700254077195d+01, 3.6472335447608d+02,
     |  -6.5729151295450d+01,-8.8765354633256d+01,-1.2363809313949d+01,
     |  -3.0214349996896d-01,-4.3894871547491d-04,-1.2351304600843d-10/
      data (lpmn(lat,17,33), lat = 1,36)/
     |   5.2319556675447d-12, 5.7123304965703d-05, 6.9085625765626d-02,
     |   4.3641460781431d+00, 4.9179116737508d+01, 1.1173436731040d+02,
     |  -1.6819904172611d+02,-3.3246986426189d+02, 4.9377542515244d+02,
     |   5.7852170853725d+01,-5.8366477569383d+02, 6.6130666664460d+02,
     |  -3.2843488517533d+02,-1.6548971414570d+02, 5.6609225396279d+02,
     |  -7.1524685976332d+02, 5.7657611202025d+02,-2.1913657757738d+02,
     |  -2.1913657757738d+02, 5.7657611202025d+02,-7.1524685976332d+02,
     |   5.6609225396279d+02,-1.6548971414569d+02,-3.2843488517532d+02,
     |   6.6130666664461d+02,-5.8366477569383d+02, 5.7852170853723d+01,
     |   4.9377542515245d+02,-3.3246986426189d+02,-1.6819904172611d+02,
     |   1.1173436731040d+02, 4.9179116737508d+01, 4.3641460781432d+00,
     |   6.9085625765628d-02, 5.7123304965703d-05, 5.2319556675447d-12/
      data (lpmn(lat,18,33), lat = 1,36)/
     |   2.0359571559840d-13, 6.8091508847001d-06, 1.4364731417209d-02,
     |   1.3778932940088d+00, 2.3196875765172d+01, 9.6106961685368d+01,
     |   3.1273120556176d-01,-3.5946797979121d+02, 8.5453796742673d+01,
     |   5.1641733382682d+02,-5.3958722008749d+02, 5.6207397585375d+01,
     |   4.6583583387486d+02,-6.8295924997846d+02, 5.1680176800298d+02,
     |  -9.4870751364474d+01,-3.6403606724975d+02, 6.5396642153400d+02,
     |  -6.5396642153400d+02, 3.6403606724974d+02, 9.4870751364481d+01,
     |  -5.1680176800298d+02, 6.8295924997846d+02,-4.6583583387487d+02,
     |  -5.6207397585383d+01, 5.3958722008749d+02,-5.1641733382682d+02,
     |  -8.5453796742675d+01, 3.5946797979121d+02,-3.1273120556083d-01,
     |  -9.6106961685368d+01,-2.3196875765172d+01,-1.3778932940088d+00,
     |  -1.4364731417210d-02,-6.8091508847001d-06,-2.0359571559840d-13/
      data (lpmn(lat,19,33), lat = 1,36)/
     |   7.2910053799707d-15, 7.4515604184363d-07, 2.7263922662790d-03,
     |   3.9228400520982d-01, 9.5657842055493d+00, 6.2247247226209d+01,
     |   8.1381653929526d+01,-2.1351176262104d+02,-2.4549262972122d+02,
     |   4.8513310499649d+02, 1.1921398994525d+01,-5.3817887240519d+02,
     |   5.8707927454436d+02,-1.9231696532840d+02,-3.2313885945287d+02,
     |   6.3830995472773d+02,-5.9640384098732d+02, 2.3980729009284d+02,
     |   2.3980729009284d+02,-5.9640384098732d+02, 6.3830995472773d+02,
     |  -3.2313885945287d+02,-1.9231696532840d+02, 5.8707927454436d+02,
     |  -5.3817887240519d+02, 1.1921398994525d+01, 4.8513310499649d+02,
     |  -2.4549262972122d+02,-2.1351176262104d+02, 8.1381653929526d+01,
     |   6.2247247226209d+01, 9.5657842055493d+00, 3.9228400520983d-01,
     |   2.7263922662791d-03, 7.4515604184363d-07, 7.2910053799707d-15/
      data (lpmn(lat,20,33), lat = 1,36)/
     |   2.4053230222727d-16, 7.4973681903819d-08, 4.7355686984556d-04,
     |   1.0125231752451d-01, 3.5017603267512d+00, 3.3360531475958d+01,
     |   9.0990479209075d+01,-4.8488519136183d+01,-3.2949321223887d+02,
     |   1.3425077294749d+02, 4.5454087639402d+02,-4.8400847662275d+02,
     |  -1.8181708143149d+01, 5.1238388418962d+02,-6.0578373166298d+02,
     |   2.7389492160721d+02, 2.3304570542605d+02,-5.9261883955396d+02,
     |   5.9261883955396d+02,-2.3304570542605d+02,-2.7389492160721d+02,
     |   6.0578373166298d+02,-5.1238388418962d+02, 1.8181708143155d+01,
     |   4.8400847662275d+02,-4.5454087639402d+02,-1.3425077294749d+02,
     |   3.2949321223887d+02, 4.8488519136184d+01,-9.0990479209075d+01,
     |  -3.3360531475958d+01,-3.5017603267512d+00,-1.0125231752451d-01,
     |  -4.7355686984558d-04,-7.4973681903819d-08,-2.4053230222727d-16/
      data (lpmn(lat,21,33), lat = 1,36)/
     |   7.3126858719583d-18, 6.9401458503138d-09, 7.5387829236835d-05,
     |   2.3776454357761d-02, 1.1486561074265d+00, 1.5383732454254d+01,
     |   6.7675155617239d+01, 5.1190028283687d+01,-2.2555297029302d+02,
     |  -1.8900708748685d+02, 4.4663427174941d+02, 3.4460545893192d+01,
     |  -5.2410767806037d+02, 4.6806874197432d+02, 2.2615461140989d+01,
     |  -4.9608128878640d+02, 5.9065823001528d+02,-2.5739156130444d+02,
     |  -2.5739156130444d+02, 5.9065823001528d+02,-4.9608128878640d+02,
     |   2.2615461140987d+01, 4.6806874197432d+02,-5.2410767806037d+02,
     |   3.4460545893187d+01, 4.4663427174941d+02,-1.8900708748685d+02,
     |  -2.2555297029302d+02, 5.1190028283686d+01, 6.7675155617239d+01,
     |   1.5383732454254d+01, 1.1486561074265d+00, 2.3776454357762d-02,
     |   7.5387829236838d-05, 6.9401458503138d-09, 7.3126858719583d-18/
      data (lpmn(lat,22,33), lat = 1,36)/
     |   2.0480280407101d-19, 5.9098422405178d-10, 1.1005339196850d-05,
     |   5.0895840716956d-03, 3.3956146089000d-01, 6.2272619879882d+00,
     |   4.0007116414676d+01, 7.9371376363512d+01,-7.3866655535549d+01,
     |  -2.9410267151358d+02, 1.2926079515937d+02, 4.2541118978870d+02,
     |  -3.8713697508739d+02,-1.5825513190553d+02, 5.5098310670284d+02,
     |  -4.1452663765308d+02,-9.2753821022040d+01, 5.2265730359309d+02,
     |  -5.2265730359309d+02, 9.2753821022039d+01, 4.1452663765308d+02,
     |  -5.5098310670284d+02, 1.5825513190553d+02, 3.8713697508738d+02,
     |  -4.2541118978870d+02,-1.2926079515937d+02, 2.9410267151358d+02,
     |   7.3866655535550d+01,-7.9371376363511d+01,-4.0007116414677d+01,
     |  -6.2272619879882d+00,-3.3956146089000d-01,-5.0895840716957d-03,
     |  -1.1005339196850d-05,-5.9098422405178d-10,-2.0480280407101d-19/
      data (lpmn(lat,23,33), lat = 1,36)/
     |   5.2777564400505d-21, 4.6250799170118d-11, 1.4726023445610d-06,
     |   9.9376881194990d-04, 9.0751343019282d-02, 2.2375158699459d+00,
     |   1.9926220838578d+01, 6.6340491227452d+01, 3.0431459473399d+01,
     |  -2.1328605621410d+02,-1.6867694026048d+02, 3.8474537691408d+02,
     |   1.1747969351581d+02,-5.0714993944635d+02, 2.6229526599786d+02,
     |   2.9119316358795d+02,-5.5017705022835d+02, 2.6948137262791d+02,
     |   2.6948137262791d+02,-5.5017705022835d+02, 2.9119316358795d+02,
     |   2.6229526599786d+02,-5.0714993944635d+02, 1.1747969351581d+02,
     |   3.8474537691408d+02,-1.6867694026048d+02,-2.1328605621410d+02,
     |   3.0431459473399d+01, 6.6340491227452d+01, 1.9926220838578d+01,
     |   2.2375158699459d+00, 9.0751343019282d-02, 9.9376881194992d-04,
     |   1.4726023445611d-06, 4.6250799170118d-11, 5.2777564400505d-21/
      data (lpmn(lat,24,33), lat = 1,36)/
     |   1.2489043663684d-22, 3.3203461150924d-12, 1.8034570221200d-07,
     |   1.7687733270064d-04, 2.1952996811430d-02, 7.1791876481970d-01,
     |   8.5834806966236d+00, 4.1919813774496d+01, 6.7427299678204d+01,
     |  -7.5463434670942d+01,-2.6196991840648d+02, 7.7067503212808d+01,
     |   4.1178346013431d+02,-2.2780528420271d+02,-3.3046327360783d+02,
     |   4.7677421515570d+02,-4.6037606751497d+01,-4.4385885685225d+02,
     |   4.4385885685225d+02, 4.6037606751498d+01,-4.7677421515571d+02,
     |   3.3046327360783d+02, 2.2780528420271d+02,-4.1178346013431d+02,
     |  -7.7067503212811d+01, 2.6196991840648d+02, 7.5463434670943d+01,
     |  -6.7427299678205d+01,-4.1919813774496d+01,-8.5834806966237d+00,
     |  -7.1791876481970d-01,-2.1952996811430d-02,-1.7687733270065d-04,
     |  -1.8034570221201d-07,-3.3203461150924d-12,-1.2489043663684d-22/
      data (lpmn(lat,25,33), lat = 1,36)/
     |   2.7053414091359d-24, 2.1800911698127d-13, 2.0160945235327d-08,
     |   2.8639659810509d-05, 4.8033073903163d-03, 2.0620764531671d-01,
     |   3.2393887000130d+00, 2.1765503650446d+01, 6.0650425131979d+01,
     |   2.3126622182853d+01,-1.8260834470894d+02,-1.7822126843381d+02,
     |   2.8896907264470d+02, 2.3848507457813d+02,-4.1533342205737d+02,
     |  -5.0224985939705d+01, 4.6719441680847d+02,-2.7289235436559d+02,
     |  -2.7289235436559d+02, 4.6719441680847d+02,-5.0224985939701d+01,
     |  -4.1533342205737d+02, 2.3848507457813d+02, 2.8896907264470d+02,
     |  -1.7822126843380d+02,-1.8260834470894d+02, 2.3126622182853d+01,
     |   6.0650425131979d+01, 2.1765503650446d+01, 3.2393887000131d+00,
     |   2.0620764531671d-01, 4.8033073903163d-03, 2.8639659810510d-05,
     |   2.0160945235328d-08, 2.1800911698127d-13, 2.7053414091359d-24/
      data (lpmn(lat,26,33), lat = 1,36)/
     |   5.3405462700398d-26, 1.3034678321385d-14, 2.0489072787940d-09,
     |   4.2035359007838d-06, 9.4813075830573d-04, 5.3000809236159d-02,
     |   1.0771841948195d+00, 9.5928967796760d+00, 3.9255548208277d+01,
     |   5.8654988808788d+01,-5.6032628206937d+01,-2.2886544691469d+02,
     |  -1.4179520195127d+01, 3.6929534656047d+02, 6.8268431793114d+00,
     |  -4.2246485046329d+02, 1.6567416531729d+02, 3.5635582526019d+02,
     |  -3.5635582526019d+02,-1.6567416531729d+02, 4.2246485046329d+02,
     |  -6.8268431793105d+00,-3.6929534656047d+02, 1.4179520195129d+01,
     |   2.2886544691469d+02, 5.6032628206937d+01,-5.8654988808788d+01,
     |  -3.9255548208277d+01,-9.5928967796760d+00,-1.0771841948195d+00,
     |  -5.3000809236159d-02,-9.4813075830573d-04,-4.2035359007839d-06,
     |  -2.0489072787941d-09,-1.3034678321385d-14,-5.3405462700398d-26/
      data (lpmn(lat,27,33), lat = 1,36)/
     |   9.5475239152503d-28, 7.0529777115603d-16, 1.8816833411296d-10,
     |   5.5615654893600d-07, 1.6803339124309d-04, 1.2150974457383d-02,
     |   3.1580248771222d-01, 3.6380565409973d+00, 2.0325170804871d+01,
     |   5.2405045789614d+01, 2.8014705426448d+01,-1.3393978411895d+02,
     |  -1.9667300562797d+02, 1.4131689332066d+02, 3.2914983487846d+02,
     |  -1.6484562484261d+02,-3.3901634818945d+02, 2.6325973585864d+02,
     |   2.6325973585864d+02,-3.3901634818945d+02,-1.6484562484261d+02,
     |   3.2914983487846d+02, 1.4131689332066d+02,-1.9667300562797d+02,
     |  -1.3393978411896d+02, 2.8014705426448d+01, 5.2405045789614d+01,
     |   2.0325170804871d+01, 3.6380565409973d+00, 3.1580248771222d-01,
     |   1.2150974457383d-02, 1.6803339124309d-04, 5.5615654893602d-07,
     |   1.8816833411297d-10, 7.0529777115603d-16, 9.5475239152503d-28/
      data (lpmn(lat,28,33), lat = 1,36)/
     |   1.5321222558211d-29, 3.4235938485072d-17, 1.5482929560936d-11,
     |   6.5785330571274d-08, 2.6533801760400d-05, 2.4687406398320d-03,
     |   8.1310470400778d-02, 1.1911735491175d+00, 8.7226557019589d+00,
     |   3.2647309877536d+01, 5.2379429660170d+01,-2.0823384706620d+01,
     |  -1.7836969839293d+02,-1.1843953519201d+02, 2.3265070909776d+02,
     |   2.4184112441809d+02,-2.4002321081536d+02,-2.6097786682980d+02,
     |   2.6097786682980d+02, 2.4002321081536d+02,-2.4184112441809d+02,
     |  -2.3265070909776d+02, 1.1843953519201d+02, 1.7836969839293d+02,
     |   2.0823384706621d+01,-5.2379429660170d+01,-3.2647309877536d+01,
     |  -8.7226557019590d+00,-1.1911735491175d+00,-8.1310470400779d-02,
     |  -2.4687406398320d-03,-2.6533801760400d-05,-6.5785330571277d-08,
     |  -1.5482929560937d-11,-3.4235938485072d-17,-1.5321222558211d-29/
      data (lpmn(lat,29,33), lat = 1,36)/
     |   2.1790120868637d-31, 1.4720584118109d-18, 1.1272068113329d-12,
     |   6.8721338719794d-09, 3.6895277237856d-06, 4.3969688262397d-04,
     |   1.8220093685918d-02, 3.3516638755137d-01, 3.1344946759397d+00,
     |   1.5813444785524d+01, 4.1535526168762d+01, 3.8118777415766d+01,
     |  -6.6850007356734d+01,-1.8317863800874d+02,-4.3162699118486d+01,
     |   2.5666369928348d+02, 1.7547928310101d+02,-2.3417594699302d+02,
     |  -2.3417594699302d+02, 1.7547928310101d+02, 2.5666369928349d+02,
     |  -4.3162699118486d+01,-1.8317863800874d+02,-6.6850007356734d+01,
     |   3.8118777415765d+01, 4.1535526168762d+01, 1.5813444785524d+01,
     |   3.1344946759397d+00, 3.3516638755138d-01, 1.8220093685918d-02,
     |   4.3969688262397d-04, 3.6895277237856d-06, 6.8721338719796d-09,
     |   1.1272068113329d-12, 1.4720584118109d-18, 2.1790120868637d-31/
      data (lpmn(lat,30,33), lat = 1,36)/
     |   2.6944086517436d-33, 5.5004757144564d-20, 7.1244784843910d-14,
     |   6.2221315710268d-10, 4.4354157053926d-07, 6.7448307290633d-05,
     |   3.4956773280731d-03, 7.9964034711579d-02, 9.3806249200790d-01,
     |   6.1234921736683d+00, 2.2700201524998d+01, 4.3657677079365d+01,
     |   1.7923959696742d+01,-9.3420704714595d+01,-1.6488163768832d+02,
     |  -5.0225937765278d+00, 2.3476651372286d+02, 1.6003268963105d+02,
     |  -1.6003268963105d+02,-2.3476651372286d+02, 5.0225937765266d+00,
     |   1.6488163768832d+02, 9.3420704714595d+01,-1.7923959696742d+01,
     |  -4.3657677079365d+01,-2.2700201524998d+01,-6.1234921736683d+00,
     |  -9.3806249200790d-01,-7.9964034711580d-02,-3.4956773280732d-03,
     |  -6.7448307290633d-05,-4.4354157053926d-07,-6.2221315710270d-10,
     |  -7.1244784843915d-14,-5.5004757144564d-20,-2.6944086517436d-33/
      data (lpmn(lat,31,33), lat = 1,36)/
     |   2.8079478763938d-35, 1.7314649844337d-21, 3.7901376543144d-15,
     |   4.7348767328683d-11, 4.4716408583872d-08, 8.6485704214483d-06,
     |   5.5787761455843d-04, 1.5747228925256d-02, 2.2869235655750d-01,
     |   1.8823768364229d+00, 9.2196497405457d+00, 2.6726651944720d+01,
     |   4.0092231899332d+01, 3.6648262837853d+00,-9.4796533184920d+01,
     |  -1.4266747062491d+02,-1.5323381181112d+01, 1.7469750561481d+02,
     |   1.7469750561481d+02,-1.5323381181112d+01,-1.4266747062491d+02,
     |  -9.4796533184920d+01, 3.6648262837853d+00, 4.0092231899332d+01,
     |   2.6726651944720d+01, 9.2196497405457d+00, 1.8823768364229d+00,
     |   2.2869235655750d-01, 1.5747228925256d-02, 5.5787761455844d-04,
     |   8.6485704214483d-06, 4.4716408583872d-08, 4.7348767328684d-11,
     |   3.7901376543147d-15, 1.7314649844337d-21, 2.8079478763938d-35/
      data (lpmn(lat,32,33), lat = 1,36)/
     |   2.3276776787423d-37, 4.3338178041060d-23, 1.6019735471753d-16,
     |   2.8590172499050d-12, 3.5702727624631d-09, 8.7578754365822d-07,
     |   7.0021916247524d-05, 2.4237121007645d-03, 4.3138748544104d-02,
     |   4.3982198168476d-01, 2.7425845110991d+00, 1.0779183796279d+01,
     |   2.6286730820307d+01, 3.4710051923365d+01, 3.6882402484041d+00,
     |  -7.0430968995652d+01,-1.1703119506259d+02,-5.9770943875901d+01,
     |   5.9770943875901d+01, 1.1703119506259d+02, 7.0430968995652d+01,
     |  -3.6882402484041d+00,-3.4710051923365d+01,-2.6286730820307d+01,
     |  -1.0779183796279d+01,-2.7425845110991d+00,-4.3982198168476d-01,
     |  -4.3138748544104d-02,-2.4237121007645d-03,-7.0021916247526d-05,
     |  -8.7578754365822d-07,-3.5702727624631d-09,-2.8590172499051d-12,
     |  -1.6019735471754d-16,-4.3338178041060d-23,-2.3276776787423d-37/
      data (lpmn(lat,33,33), lat = 1,36)/
     |   1.3305342491988d-39, 7.4773642178448d-25, 4.6640890227210d-18,
     |   1.1877812554178d-13, 1.9579794958645d-10, 6.0766217553123d-08,
     |   6.0007850196156d-06, 2.5338879226774d-04, 5.4835774703207d-03,
     |   6.8355370409352d-02, 5.2993796107248d-01, 2.6819413470877d+00,
     |   9.0765123216035d+00, 2.0425265857427d+01, 2.8523192890689d+01,
     |   1.6834850874765d+01,-1.9259112261011d+01,-5.4254203625864d+01,
     |  -5.4254203625864d+01,-1.9259112261012d+01, 1.6834850874764d+01,
     |   2.8523192890689d+01, 2.0425265857427d+01, 9.0765123216035d+00,
     |   2.6819413470877d+00, 5.2993796107248d-01, 6.8355370409352d-02,
     |   5.4835774703207d-03, 2.5338879226774d-04, 6.0007850196158d-06,
     |   6.0766217553123d-08, 1.9579794958645d-10, 1.1877812554179d-13,
     |   4.6640890227213d-18, 7.4773642178448d-25, 1.3305342491988d-39/
      data (lpmn(lat, 0,34), lat = 1,36)/
     |  -3.5569996540464d+03, 2.2172456769154d+03,-1.8427819618298d+03,
     |   1.6449009440073d+03,-1.5073806517707d+03, 1.3945503120297d+03,
     |  -1.2918156499999d+03, 1.1922397608887d+03,-1.0922632165194d+03,
     |   9.9002711412827d+02,-8.8461700952371d+02, 7.7568450478117d+02,
     |  -6.6324134726105d+02, 5.4753907091578d+02,-4.2899384657402d+02,
     |   3.0813642702791d+02,-1.8557651654553d+02, 6.1975569406044d+01,
     |   6.1975569406047d+01,-1.8557651654554d+02, 3.0813642702793d+02,
     |  -4.2899384657402d+02, 5.4753907091578d+02,-6.6324134726104d+02,
     |   7.7568450478118d+02,-8.8461700952371d+02, 9.9002711412827d+02,
     |  -1.0922632165194d+03, 1.1922397608887d+03,-1.2918156499999d+03,
     |   1.3945503120297d+03,-1.5073806517707d+03, 1.6449009440073d+03,
     |  -1.8427819618297d+03, 2.2172456769154d+03,-3.5569996540464d+03/
      data (lpmn(lat, 1,34), lat = 1,36)/
     |  -2.1805427666817d+03, 1.5652264523785d+03,-9.7607879049765d+02,
     |   6.0788431120126d+02,-3.3715394632619d+02, 1.2004476226186d+02,
     |   6.2531004268547d+01,-2.2008809983388d+02, 3.5778814872382d+02,
     |  -4.7857856585502d+02, 5.8418888642709d+02,-6.7564188569865d+02,
     |   7.5353612795967d+02,-8.1821157628977d+02, 8.6985112240778d+02,
     |  -9.0854481157838d+02, 9.3433105645176d+02,-9.4722275539904d+02,
     |   9.4722275539904d+02,-9.3433105645176d+02, 9.0854481157838d+02,
     |  -8.6985112240777d+02, 8.1821157628977d+02,-7.5353612795968d+02,
     |   6.7564188569864d+02,-5.8418888642709d+02, 4.7857856585502d+02,
     |  -3.5778814872381d+02, 2.2008809983388d+02,-6.2531004268530d+01,
     |  -1.2004476226186d+02, 3.3715394632619d+02,-6.0788431120128d+02,
     |   9.7607879049768d+02,-1.5652264523785d+03, 2.1805427666817d+03/
      data (lpmn(lat, 2,34), lat = 1,36)/
     |   1.2499590699845d+03,-1.1987941916585d+03, 1.4705190078108d+03,
     |  -1.4763638355252d+03, 1.4276083005299d+03,-1.3604975507351d+03,
     |   1.2834943844721d+03,-1.1989496718102d+03, 1.1076627005486d+03,
     |  -1.0100611657131d+03, 9.0653966266631d+02,-7.9755605947258d+02,
     |   6.8365206555037d+02,-5.6544937562940d+02, 4.4363832119628d+02,
     |  -3.1896472638408d+02, 1.9221679738244d+02,-6.4212510608180d+01,
     |  -6.4212510608184d+01, 1.9221679738245d+02,-3.1896472638410d+02,
     |   4.4363832119628d+02,-5.6544937562940d+02, 6.8365206555036d+02,
     |  -7.9755605947260d+02, 9.0653966266631d+02,-1.0100611657131d+03,
     |   1.1076627005486d+03,-1.1989496718102d+03, 1.2834943844721d+03,
     |  -1.3604975507351d+03, 1.4276083005299d+03,-1.4763638355252d+03,
     |   1.4705190078108d+03,-1.1987941916585d+03, 1.2499590699845d+03/
      data (lpmn(lat, 3,34), lat = 1,36)/
     |   1.2759293080131d+03,-1.6504079931016d+03, 1.5314290826232d+03,
     |  -1.0812673944402d+03, 7.1101851776295d+02,-4.1417010414213d+02,
     |   1.6957962640135d+02, 3.6892315448433d+01,-2.1388631913089d+02,
     |   3.6669208344927d+02,-4.9859569853127d+02, 6.1166349078742d+02,
     |  -7.0720247780982d+02, 7.8603836195595d+02,-8.4868817130935d+02,
     |   8.9546985642711d+02,-9.2657251589071d+02, 9.4210073574433d+02,
     |  -9.4210073574433d+02, 9.2657251589071d+02,-8.9546985642711d+02,
     |   8.4868817130934d+02,-7.8603836195595d+02, 7.0720247780983d+02,
     |  -6.1166349078741d+02, 4.9859569853127d+02,-3.6669208344927d+02,
     |   2.1388631913089d+02,-3.6892315448428d+01,-1.6957962640137d+02,
     |   4.1417010414213d+02,-7.1101851776295d+02, 1.0812673944402d+03,
     |  -1.5314290826232d+03, 1.6504079931016d+03,-1.2759293080131d+03/
      data (lpmn(lat, 4,34), lat = 1,36)/
     |   5.0162889591038d+02,-5.1517330432931d+02,-1.0561726082445d+02,
     |   7.5174266868938d+02,-1.0430027473864d+03, 1.1633083087452d+03,
     |  -1.1957228868373d+03, 1.1772612447943d+03,-1.1260332537837d+03,
     |   1.0518229893770d+03,-9.6045531131431d+02, 8.5574650550887d+02,
     |  -7.4044040978529d+02, 6.1668563030745d+02,-4.8629122647655d+02,
     |   3.5086943974844d+02,-2.1191827825542d+02, 7.0871191669803d+01,
     |   7.0871191669807d+01,-2.1191827825543d+02, 3.5086943974845d+02,
     |  -4.8629122647655d+02, 6.1668563030745d+02,-7.4044040978528d+02,
     |   8.5574650550888d+02,-9.6045531131431d+02, 1.0518229893770d+03,
     |  -1.1260332537838d+03, 1.1772612447943d+03,-1.1957228868373d+03,
     |   1.1633083087452d+03,-1.0430027473864d+03, 7.5174266868936d+02,
     |  -1.0561726082443d+02,-5.1517330432931d+02, 5.0162889591038d+02/
      data (lpmn(lat, 5,34), lat = 1,36)/
     |   1.2636026967474d+02, 3.1776427470839d+02,-1.0968998107834d+03,
     |   1.4117490006566d+03,-1.1998101582629d+03, 8.9128041307218d+02,
     |  -5.8893389400502d+02, 3.1558465774631d+02,-7.4311479521046d+01,
     |  -1.3651015644932d+02, 3.1922927513340d+02,-4.7590125383063d+02,
     |   6.0810388107366d+02,-7.1698098263005d+02, 8.0333322525867d+02,
     |  -8.6770360512098d+02, 9.1044466935556d+02,-9.3176637022881d+02,
     |   9.3176637022881d+02,-9.1044466935556d+02, 8.6770360512097d+02,
     |  -8.0333322525866d+02, 7.1698098263005d+02,-6.0810388107367d+02,
     |   4.7590125383062d+02,-3.1922927513340d+02, 1.3651015644931d+02,
     |   7.4311479521053d+01,-3.1558465774631d+02, 5.8893389400504d+02,
     |  -8.9128041307218d+02, 1.1998101582629d+03,-1.4117490006566d+03,
     |   1.0968998107834d+03,-3.1776427470839d+02,-1.2636026967474d+02/
      data (lpmn(lat, 6,34), lat = 1,36)/
     |   2.3544125571116d+01, 4.5456153564096d+02,-8.8029859567615d+02,
     |   5.4943255303085d+02, 1.2732448626852d+02,-5.9149626390604d+02,
     |   8.6548763106142d+02,-1.0091239653329d+03, 1.0646651773694d+03,
     |  -1.0589353325162d+03, 1.0090953869616d+03,-9.2655492267079d+02,
     |   8.1928717708458d+02,-6.9317706677971d+02, 5.5281815786771d+02,
     |  -4.0199655066825d+02, 2.4399493489641d+02,-8.1792719951543d+01,
     |  -8.1792719951547d+01, 2.4399493489641d+02,-4.0199655066826d+02,
     |   5.5281815786772d+02,-6.9317706677971d+02, 8.1928717708458d+02,
     |  -9.2655492267080d+02, 1.0090953869616d+03,-1.0589353325162d+03,
     |   1.0646651773694d+03,-1.0091239653329d+03, 8.6548763106141d+02,
     |  -5.9149626390604d+02, 1.2732448626852d+02, 5.4943255303087d+02,
     |  -8.8029859567616d+02, 4.5456153564096d+02, 2.3544125571116d+01/
      data (lpmn(lat, 7,34), lat = 1,36)/
     |   3.4803294461807d+00, 2.9216124011413d+02,-2.3854478837545d+02,
     |  -5.0168094577205d+02, 1.1107844124395d+03,-1.1803133428819d+03,
     |   1.0082154776384d+03,-7.4975056811694d+02, 4.7219150609056d+02,
     |  -2.0442304617754d+02,-4.1021019640751d+01, 2.5869990256721d+02,
     |  -4.4630529733072d+02, 6.0291860645773d+02,-7.2822668249834d+02,
     |   8.2216511678127d+02,-8.8475674086467d+02, 9.1604023393283d+02,
     |  -9.1604023393283d+02, 8.8475674086467d+02,-8.2216511678126d+02,
     |   7.2822668249833d+02,-6.0291860645773d+02, 4.4630529733073d+02,
     |  -2.5869990256719d+02, 4.1021019640751d+01, 2.0442304617755d+02,
     |  -4.7219150609057d+02, 7.4975056811694d+02,-1.0082154776384d+03,
     |   1.1803133428819d+03,-1.1107844124395d+03, 5.0168094577204d+02,
     |   2.3854478837546d+02,-2.9216124011413d+02,-3.4803294461807d+00/
      data (lpmn(lat, 8,34), lat = 1,36)/
     |   4.2562989665531d-01, 1.3267688239412d+02, 1.7702679931685d+02,
     |  -8.2882698391849d+02, 8.7921558036025d+02,-3.5496605431271d+02,
     |  -1.6709580189834d+02, 5.5446569010404d+02,-8.0434348532872d+02,
     |   9.4069243858824d+02,-9.8823900805787d+02, 9.6727815455072d+02,
     |  -8.9364777997701d+02, 7.7972498356117d+02,-6.3540850083146d+02,
     |   4.6888777083144d+02,-2.8721075555045d+02, 9.6703911963387d+01,
     |   9.6703911963390d+01,-2.8721075555045d+02, 4.6888777083145d+02,
     |  -6.3540850083147d+02, 7.7972498356117d+02,-8.9364777997700d+02,
     |   9.6727815455073d+02,-9.8823900805787d+02, 9.4069243858824d+02,
     |  -8.0434348532871d+02, 5.5446569010403d+02,-1.6709580189833d+02,
     |  -3.5496605431271d+02, 8.7921558036025d+02,-8.2882698391848d+02,
     |   1.7702679931685d+02, 1.3267688239412d+02, 4.2562989665531d-01/
      data (lpmn(lat, 9,34), lat = 1,36)/
     |   4.4285115723742d-02, 4.7704816723538d+01, 2.6994865790363d+02,
     |  -5.3810519841738d+02, 2.6187100893162d+01, 7.0586294601365d+02,
     |  -1.0229644874316d+03, 1.0236392463504d+03,-8.4989644733260d+02,
     |   5.9530691268672d+02,-3.1443179315138d+02, 3.8378831441685d+01,
     |   2.1500638307347d+02,-4.3532990154435d+02, 6.1644028512456d+02,
     |  -7.5466005316086d+02, 8.4780714928996d+02,-8.9465646660851d+02,
     |   8.9465646660851d+02,-8.4780714928996d+02, 7.5466005316086d+02,
     |  -6.1644028512456d+02, 4.3532990154435d+02,-2.1500638307348d+02,
     |  -3.8378831441700d+01, 3.1443179315138d+02,-5.9530691268672d+02,
     |   8.4989644733260d+02,-1.0236392463504d+03, 1.0229644874316d+03,
     |  -7.0586294601365d+02,-2.6187100893162d+01, 5.3810519841739d+02,
     |  -2.6994865790363d+02,-4.7704816723538d+01,-4.4285115723742d-02/
      data (lpmn(lat,10,34), lat = 1,36)/
     |   3.9989256232251d-03, 1.4304765096149d+01, 2.0111055308304d+02,
     |  -1.1902779921779d+02,-5.6968411876752d+02, 9.4490456375737d+02,
     |  -6.6163349268076d+02, 1.8018913794824d+02, 2.6729391323513d+02,
     |  -6.0367041495836d+02, 8.1671293269971d+02,-9.1735397360667d+02,
     |   9.2314196136551d+02,-8.5221838426930d+02, 7.2142494076846d+02,
     |  -5.4596950018218d+02, 3.3964307090725d+02,-1.1520421789137d+02,
     |  -1.1520421789137d+02, 3.3964307090726d+02,-5.4596950018219d+02,
     |   7.2142494076847d+02,-8.5221838426930d+02, 9.2314196136551d+02,
     |  -9.1735397360667d+02, 8.1671293269971d+02,-6.0367041495836d+02,
     |   2.6729391323513d+02, 1.8018913794824d+02,-6.6163349268077d+02,
     |   9.4490456375737d+02,-5.6968411876752d+02,-1.1902779921779d+02,
     |   2.0111055308304d+02, 1.4304765096149d+01, 3.9989256232250d-03/
      data (lpmn(lat,11,34), lat = 1,36)/
     |   3.1806873702086d-04, 3.6860943314957d+00, 1.1009142116218d+02,
     |   1.3126168746334d+02,-6.1543900669044d+02, 4.0635970204391d+02,
     |   2.9755538847467d+02,-7.8417848810628d+02, 9.5260074386297d+02,
     |  -8.8204028528339d+02, 6.6737602712472d+02,-3.8236867255187d+02,
     |   7.8274002446254d+01, 2.1063876875726d+02,-4.6180038645430d+02,
     |   6.6052524350810d+02,-7.9750713535889d+02, 8.6726732247333d+02,
     |  -8.6726732247333d+02, 7.9750713535888d+02,-6.6052524350810d+02,
     |   4.6180038645430d+02,-2.1063876875726d+02,-7.8274002446244d+01,
     |   3.8236867255189d+02,-6.6737602712472d+02, 8.8204028528340d+02,
     |  -9.5260074386297d+02, 7.8417848810628d+02,-2.9755538847466d+02,
     |  -4.0635970204391d+02, 6.1543900669044d+02,-1.3126168746334d+02,
     |  -1.1009142116218d+02,-3.6860943314957d+00,-3.1806873702086d-04/
      data (lpmn(lat,12,34), lat = 1,36)/
     |   2.2538302722988d-05, 8.3238676173397d-01, 4.9043265094968d+01,
     |   1.8947942247400d+02,-3.3646409610215d+02,-2.4493945887081d+02,
     |   8.3096374549705d+02,-8.0009843129014d+02, 4.2158046655695d+02,
     |   3.8086659904231d+01,-4.3554002826085d+02, 7.1267423429676d+02,
     |  -8.5683562795405d+02, 8.7715666393048d+02,-7.9236711355288d+02,
     |   6.2494438510813d+02,-3.9849794560851d+02, 1.3674626740615d+02,
     |   1.3674626740615d+02,-3.9849794560851d+02, 6.2494438510813d+02,
     |  -7.9236711355288d+02, 8.7715666393048d+02,-8.5683562795405d+02,
     |   7.1267423429676d+02,-4.3554002826085d+02, 3.8086659904228d+01,
     |   4.2158046655696d+02,-8.0009843129014d+02, 8.3096374549704d+02,
     |  -2.4493945887081d+02,-3.3646409610215d+02, 1.8947942247400d+02,
     |   4.9043265094969d+01, 8.3238676173397d-01, 2.2538302722988d-05/
      data (lpmn(lat,13,34), lat = 1,36)/
     |   1.4354924182658d-06, 1.6700951911793d-01, 1.8603454507654d+01,
     |   1.4806949629392d+02,-4.3972190407118d+01,-5.3355574163596d+02,
     |   6.1548371115291d+02,-3.8488833905451d+01,-5.3215105827579d+02,
     |   8.3552995028175d+02,-8.6260722548891d+02, 6.8799638904083d+02,
     |  -3.9691950725478d+02, 6.1761118427227d+01, 2.6230813484762d+02,
     |  -5.3569953793620d+02, 7.3158415346352d+02,-8.3345037610464d+02,
     |   8.3345037610464d+02,-7.3158415346352d+02, 5.3569953793620d+02,
     |  -2.6230813484761d+02,-6.1761118427230d+01, 3.9691950725478d+02,
     |  -6.8799638904084d+02, 8.6260722548891d+02,-8.3552995028175d+02,
     |   5.3215105827578d+02, 3.8488833905454d+01,-6.1548371115292d+02,
     |   5.3355574163596d+02, 4.3972190407119d+01,-1.4806949629393d+02,
     |  -1.8603454507654d+01,-1.6700951911793d-01,-1.4354924182658d-06/
      data (lpmn(lat,14,34), lat = 1,36)/
     |   8.2759151587221d-08, 3.0076168565203d-02, 6.1637518773030d+00,
     |   8.7611730502012d+01, 1.1373533247783d+02,-4.4135443849598d+02,
     |   4.6496404740456d+01, 6.3147359463319d+02,-8.1261759518295d+02,
     |   5.5697378961571d+02,-1.1360668558128d+02,-3.2374432527338d+02,
     |   6.4760374905360d+02,-8.1512097784288d+02, 8.2377768564721d+02,
     |  -6.9425161475678d+02, 4.5988993169117d+02,-1.6060866285140d+02,
     |  -1.6060866285141d+02, 4.5988993169117d+02,-6.9425161475678d+02,
     |   8.2377768564721d+02,-8.1512097784288d+02, 6.4760374905361d+02,
     |  -3.2374432527337d+02,-1.1360668558128d+02, 5.5697378961571d+02,
     |  -8.1261759518295d+02, 6.3147359463319d+02, 4.6496404740462d+01,
     |  -4.4135443849598d+02, 1.1373533247783d+02, 8.7611730502013d+01,
     |   6.1637518773031d+00, 3.0076168565203d-02, 8.2759151587220d-08/
      data (lpmn(lat,15,34), lat = 1,36)/
     |   4.3431258702597d-09, 4.8990057372384d-03, 1.8128828182941d+00,
     |   4.2927428590515d+01, 1.4421684739623d+02,-1.9388774915120d+02,
     |  -3.7149323459146d+02, 6.7994349299791d+02,-2.6801030214569d+02,
     |  -3.2094893124850d+02, 7.1649392534319d+02,-8.1632697368546d+02,
     |   6.6288768962334d+02,-3.4980011077267d+02,-2.5004407935082d+01,
     |   3.7837054597272d+02,-6.4790118131993d+02, 7.9271961748420d+02,
     |  -7.9271961748420d+02, 6.4790118131993d+02,-3.7837054597271d+02,
     |   2.5004407935079d+01, 3.4980011077267d+02,-6.6288768962334d+02,
     |   8.1632697368547d+02,-7.1649392534319d+02, 3.2094893124850d+02,
     |   2.6801030214569d+02,-6.7994349299791d+02, 3.7149323459145d+02,
     |   1.9388774915120d+02,-1.4421684739623d+02,-4.2927428590515d+01,
     |  -1.8128828182941d+00,-4.8990057372384d-03,-4.3431258702597d-09/
      data (lpmn(lat,16,34), lat = 1,36)/
     |   2.0840067329146d-10, 7.2604597965899d-04, 4.7861745200812d-01,
     |   1.8126211095580d+01, 1.1147458680928d+02, 1.1061213116617d+01,
     |  -4.4716824718858d+02, 2.5440534491980d+02, 4.2575410763439d+02,
     |  -7.5563310664713d+02, 6.0633056932304d+02,-1.8245152669616d+02,
     |  -2.8320337054879d+02, 6.3179522541383d+02,-7.8744473376893d+02,
     |   7.3889813690560d+02,-5.1861149900452d+02, 1.8585884653696d+02,
     |   1.8585884653696d+02,-5.1861149900452d+02, 7.3889813690561d+02,
     |  -7.8744473376892d+02, 6.3179522541383d+02,-2.8320337054880d+02,
     |  -1.8245152669617d+02, 6.0633056932304d+02,-7.5563310664714d+02,
     |   4.2575410763439d+02, 2.5440534491980d+02,-4.4716824718858d+02,
     |   1.1061213116617d+01, 1.1147458680928d+02, 1.8126211095580d+01,
     |   4.7861745200814d-01, 7.2604597965899d-04, 2.0840067329146d-10/
      data (lpmn(lat,17,34), lat = 1,36)/
     |   9.1755869346372d-12, 9.8348781545511d-05, 1.1432658547568d-01,
     |   6.7435223311977d+00, 6.7205230058481d+01, 1.0528424263965d+02,
     |  -2.8799753227622d+02,-1.9904421298006d+02, 6.5211977950170d+02,
     |  -3.9258878590330d+02,-1.8136210757062d+02, 6.2901114874144d+02,
     |  -7.6181796536935d+02, 5.9143207012054d+02,-2.2821414795725d+02,
     |  -1.9130784596200d+02, 5.4494026036890d+02,-7.4454239399513d+02,
     |   7.4454239399513d+02,-5.4494026036889d+02, 1.9130784596199d+02,
     |   2.2821414795725d+02,-5.9143207012054d+02, 7.6181796536935d+02,
     |  -6.2901114874144d+02, 1.8136210757062d+02, 3.9258878590330d+02,
     |  -6.5211977950170d+02, 1.9904421298006d+02, 2.8799753227622d+02,
     |  -1.0528424263965d+02,-6.7205230058481d+01,-6.7435223311978d+00,
     |  -1.1432658547569d-01,-9.8348781545511d-05,-9.1755869346371d-12/
      data (lpmn(lat,18,34), lat = 1,36)/
     |   3.7169102673881d-13, 1.2218831784392d-05, 2.4851728745227d-02,
     |   2.2410978617714d+00, 3.4024649358871d+01, 1.1298886873965d+02,
     |  -8.3499208268619d+01,-3.9229230297513d+02, 3.7062293788146d+02,
     |   2.6491557757323d+02,-6.7968697365879d+02, 5.9398963412375d+02,
     |  -1.6923123832493d+02,-3.1955166113017d+02, 6.5776127565795d+02,
     |  -7.4116522001068d+02, 5.6794078696474d+02,-2.1130256452364d+02,
     |  -2.1130256452364d+02, 5.6794078696474d+02,-7.4116522001068d+02,
     |   6.5776127565795d+02,-3.1955166113017d+02,-1.6923123832493d+02,
     |   5.9398963412376d+02,-6.7968697365879d+02, 2.6491557757323d+02,
     |   3.7062293788146d+02,-3.9229230297513d+02,-8.3499208268621d+01,
     |   1.1298886873965d+02, 3.4024649358870d+01, 2.2410978617714d+00,
     |   2.4851728745228d-02, 1.2218831784392d-05, 3.7169102673881d-13/
      data (lpmn(lat,19,34), lat = 1,36)/
     |   1.3880548509635d-14, 1.3959151448169d-06, 4.9367656986558d-03,
     |   6.7142967016366d-01, 1.4963918731881d+01, 8.2707604191312d+01,
     |   5.0631345289586d+01,-3.2519566593296d+02,-6.1594180039765d+01,
     |   5.8589558537419d+02,-4.3243386617091d+02,-1.2459443491461d+02,
     |   5.8897249241276d+02,-6.9890917620168d+02, 4.5574081345408d+02,
     |  -1.5166261498366d+01,-4.2251101187924d+02, 6.8836536648013d+02,
     |  -6.8836536648013d+02, 4.2251101187924d+02, 1.5166261498374d+01,
     |  -4.5574081345409d+02, 6.9890917620167d+02,-5.8897249241277d+02,
     |   1.2459443491461d+02, 4.3243386617091d+02,-5.8589558537419d+02,
     |   6.1594180039763d+01, 3.2519566593296d+02,-5.0631345289586d+01,
     |  -8.2707604191312d+01,-1.4963918731881d+01,-6.7142967016367d-01,
     |  -4.9367656986560d-03,-1.3959151448169d-06,-1.3880548509635d-14/
      data (lpmn(lat,20,34), lat = 1,36)/
     |   4.7850019035432d-16, 1.4690060477898d-07, 8.9886427039378d-04,
     |   1.8247697034581d-01, 5.8248201444819d+00, 4.8622682069063d+01,
     |   9.6342178233310d+01,-1.4934648000134d+02,-3.1823389122880d+02,
     |   4.1177650901263d+02, 1.7257857846236d+02,-6.1682065176052d+02,
     |   5.3327677883048d+02,-7.2469892836744d+01,-4.2408330118822d+02,
     |   6.8295676047127d+02,-5.9957705407898d+02, 2.3541415642074d+02,
     |   2.3541415642074d+02,-5.9957705407898d+02, 6.8295676047127d+02,
     |  -4.2408330118822d+02,-7.2469892836745d+01, 5.3327677883048d+02,
     |  -6.1682065176053d+02, 1.7257857846236d+02, 4.1177650901263d+02,
     |  -3.1823389122880d+02,-1.4934648000134d+02, 9.6342178233310d+01,
     |   4.8622682069063d+01, 5.8248201444819d+00, 1.8247697034582d-01,
     |   8.9886427039381d-04, 1.4690060477898d-07, 4.7850019035432d-16/
      data (lpmn(lat,21,34), lat = 1,36)/
     |   1.5237234558026d-17, 1.4255122829937d-08, 1.5029750879776d-04,
     |   4.5175283180890d-02, 2.0297105648149d+00, 2.4291499246001d+01,
     |   8.6405622823118d+01,-7.1332882420229d-03,-3.2180186475880d+02,
     |   2.0827467310643d+01, 5.2053879140029d+02,-4.0769894658768d+02,
     |  -1.5049656581431d+02, 5.8885478508946d+02,-5.9675883655976d+02,
     |   2.2001318985801d+02, 2.8275422960158d+02,-6.2365479937118d+02,
     |   6.2365479937118d+02,-2.8275422960158d+02,-2.2001318985802d+02,
     |   5.9675883655976d+02,-5.8885478508945d+02, 1.5049656581432d+02,
     |   4.0769894658768d+02,-5.2053879140029d+02,-2.0827467310644d+01,
     |   3.2180186475880d+02, 7.1332882433746d-03,-8.6405622823118d+01,
     |  -2.4291499246001d+01,-2.0297105648149d+00,-4.5175283180891d-02,
     |  -1.5029750879777d-04,-1.4255122829937d-08,-1.5237234558025d-17/
      data (lpmn(lat,22,34), lat = 1,36)/
     |   4.4822713589682d-19, 1.2759669695081d-09, 2.3102309376102d-05,
     |   1.0214586864884d-02, 6.3765856969821d-01, 1.0594260941504d+01,
     |   5.7775355668795d+01, 7.2130358195999d+01,-1.8130333964718d+02,
     |  -2.5588235538995d+02, 4.0018044450325d+02, 1.5358152265053d+02,
     |  -5.7390204052819d+02, 4.1563508811123d+02, 1.0920294131535d+02,
     |  -5.5081131853571d+02, 6.0386391697497d+02,-2.5623753939209d+02,
     |  -2.5623753939209d+02, 6.0386391697497d+02,-5.5081131853571d+02,
     |   1.0920294131534d+02, 4.1563508811123d+02,-5.7390204052819d+02,
     |   1.5358152265053d+02, 4.0018044450325d+02,-2.5588235538995d+02,
     |  -1.8130333964718d+02, 7.2130358195998d+01, 5.7775355668796d+01,
     |   1.0594260941504d+01, 6.3765856969820d-01, 1.0214586864884d-02,
     |   2.3102309376103d-05, 1.2759669695081d-09, 4.4822713589682d-19/
      data (lpmn(lat,23,34), lat = 1,36)/
     |   1.2172640092675d-20, 1.0530551825693d-10, 3.2648478519279d-06,
     |   2.1122520943190d-03, 1.8139228069164d-01, 4.0932560930323d+00,
     |   3.1823406171736d+01, 8.0952730802413d+01,-3.3631205650260d+01,
     |  -2.9777602033155d+02, 4.5296435332107d+01, 4.7349113265856d+02,
     |  -3.2493534876796d+02,-2.4935219821063d+02, 5.8475634999350d+02,
     |  -3.8938886390915d+02,-1.3150825530009d+02, 5.4996062796971d+02,
     |  -5.4996062796971d+02, 1.3150825530009d+02, 3.8938886390916d+02,
     |  -5.8475634999350d+02, 2.4935219821062d+02, 3.2493534876795d+02,
     |  -4.7349113265856d+02,-4.5296435332107d+01, 2.9777602033155d+02,
     |   3.3631205650260d+01,-8.0952730802412d+01,-3.1823406171736d+01,
     |  -4.0932560930323d+00,-1.8139228069164d-01,-2.1122520943190d-03,
     |  -3.2648478519281d-06,-1.0530551825693d-10,-1.2172640092675d-20/
      data (lpmn(lat,24,34), lat = 1,36)/
     |   3.0476827339648d-22, 8.0036352660751d-12, 4.2388008007810d-07,
     |   3.9952063212040d-04, 4.6826807151787d-02, 1.4127620759109d+00,
     |   1.5021186961524d+01, 6.0262882014832d+01, 5.0998855633147d+01,
     |  -1.8348199494106d+02,-2.2072730997389d+02, 3.4935698302821d+02,
     |   2.0085497267247d+02,-5.2583222626154d+02, 2.1156785881570d+02,
     |   3.4462729208695d+02,-5.7058507950235d+02, 2.7123866619466d+02,
     |   2.7123866619466d+02,-5.7058507950235d+02, 3.4462729208695d+02,
     |   2.1156785881570d+02,-5.2583222626154d+02, 2.0085497267248d+02,
     |   3.4935698302821d+02,-2.2072730997389d+02,-1.8348199494106d+02,
     |   5.0998855633147d+01, 6.0262882014832d+01, 1.5021186961524d+01,
     |   1.4127620759109d+00, 4.6826807151787d-02, 3.9952063212041d-04,
     |   4.2388008007812d-07, 8.0036352660751d-12, 3.0476827339648d-22/
      data (lpmn(lat,25,34), lat = 1,36)/
     |   7.0191218874396d-24, 5.5903792871128d-13, 5.0470754559346d-08,
     |   6.9048105210688d-05, 1.0975444800461d-02, 4.3748866727014d-01,
     |   6.1932780945400d+00, 3.5511211416749d+01, 7.1571590021785d+01,
     |  -4.5061685354452d+01,-2.6644564274533d+02, 1.6653669898136d+01,
     |   4.3676836805628d+02,-1.7429772959525d+02,-3.8352554893156d+02,
     |   4.7842216867688d+02,-1.9930203925484d+01,-4.6702237669193d+02,
     |   4.6702237669193d+02, 1.9930203925486d+01,-4.7842216867688d+02,
     |   3.8352554893155d+02, 1.7429772959525d+02,-4.3676836805628d+02,
     |  -1.6653669898139d+01, 2.6644564274533d+02, 4.5061685354453d+01,
     |  -7.1571590021785d+01,-3.5511211416749d+01,-6.1932780945401d+00,
     |  -4.3748866727014d-01,-1.0975444800461d-02,-6.9048105210690d-05,
     |  -5.0470754559349d-08,-5.5903792871128d-13,-7.0191218874396d-24/
      data (lpmn(lat,26,34), lat = 1,36)/
     |   1.4821738984392d-25, 3.5771825973919d-14, 5.4954630767269d-09,
     |   1.0878682569795d-05, 2.3328378759965d-03, 1.2172687529531d-01,
     |   2.2518892006909d+00, 1.7525230125476d+01, 5.7219219469019d+01,
     |   3.9576281191547d+01,-1.6162064751548d+02,-2.1258165778553d+02,
     |   2.5738871984698d+02, 2.8957672996463d+02,-4.0865339593764d+02,
     |  -9.0343297933616d+01, 4.9084611742053d+02,-2.7706902800805d+02,
     |  -2.7706902800805d+02, 4.9084611742053d+02,-9.0343297933612d+01,
     |  -4.0865339593764d+02, 2.8957672996463d+02, 2.5738871984698d+02,
     |  -2.1258165778553d+02,-1.6162064751548d+02, 3.9576281191547d+01,
     |   5.7219219469020d+01, 1.7525230125476d+01, 2.2518892006910d+00,
     |   1.2172687529531d-01, 2.3328378759965d-03, 1.0878682569795d-05,
     |   5.4954630767272d-09, 3.5771825973919d-14, 1.4821738984392d-25/
      data (lpmn(lat,27,34), lat = 1,36)/
     |   2.8563683348842d-27, 2.0874985592998d-15, 5.4485027893792d-10,
     |   1.5564941835914d-06, 4.4832376037498d-04, 3.0397965580131d-02,
     |   7.2484343370902d-01, 7.4178753786311d+00, 3.4683410681546d+01,
     |   6.2477062635496d+01,-3.4769849777081d+01,-2.2896198116506d+02,
     |  -5.4770295200858d+01, 3.7284508911827d+02, 4.7965520563633d+01,
     |  -4.4218254772577d+02, 1.5274708804271d+02, 3.7495526830432d+02,
     |  -3.7495526830432d+02,-1.5274708804271d+02, 4.4218254772577d+02,
     |  -4.7965520563632d+01,-3.7284508911827d+02, 5.4770295200860d+01,
     |   2.2896198116506d+02, 3.4769849777081d+01,-6.2477062635496d+01,
     |  -3.4683410681546d+01,-7.4178753786312d+00,-7.2484343370903d-01,
     |  -3.0397965580131d-02,-4.4832376037498d-04,-1.5564941835915d-06,
     |  -5.4485027893795d-10,-2.0874985592998d-15,-2.8563683348842d-27/
      data (lpmn(lat,28,34), lat = 1,36)/
     |   4.9916483098046d-29, 1.1039506444442d-16, 4.8887277634542d-11,
     |   2.0107608194371d-07, 7.7505422169101d-05, 6.7876591006712d-03,
     |   2.0643854055033d-01, 2.7193547549986d+00, 1.7147692488871d+01,
     |   5.0266328781760d+01, 3.8870928724305d+01,-1.1845389468946d+02,
     |  -2.1397570879202d+02, 1.1407879212006d+02, 3.5127342310124d+02,
     |  -1.4639336245258d+02,-3.6101300825697d+02, 2.6914226426873d+02,
     |   2.6914226426873d+02,-3.6101300825697d+02,-1.4639336245258d+02,
     |   3.5127342310124d+02, 1.1407879212006d+02,-2.1397570879202d+02,
     |  -1.1845389468946d+02, 3.8870928724305d+01, 5.0266328781760d+01,
     |   1.7147692488871d+01, 2.7193547549986d+00, 2.0643854055034d-01,
     |   6.7876591006712d-03, 7.7505422169101d-05, 2.0107608194372d-07,
     |   4.8887277634545d-11, 1.1039506444442d-16, 4.9916483098046d-29/
      data (lpmn(lat,29,34), lat = 1,36)/
     |   7.8396435730252d-31, 5.2438571451367d-18, 3.9352318783304d-12,
     |   2.3257052522645d-08, 1.1958548915797d-05, 1.3459570777631d-03,
     |   5.1780778066974d-02, 8.6458405178845d-01, 7.0974483832686d+00,
     |   2.9586606212835d+01, 5.4404252104551d+01,-7.5939624037775d+00,
     |  -1.7376584967998d+02,-1.4083031240292d+02, 2.2296819575707d+02,
     |   2.6459289160649d+02,-2.3874526743676d+02,-2.7461058117999d+02,
     |   2.7461058117999d+02, 2.3874526743676d+02,-2.6459289160649d+02,
     |  -2.2296819575707d+02, 1.4083031240292d+02, 1.7376584967998d+02,
     |   7.5939624037784d+00,-5.4404252104551d+01,-2.9586606212835d+01,
     |  -7.0974483832687d+00,-8.6458405178845d-01,-5.1780778066974d-02,
     |  -1.3459570777631d-03,-1.1958548915797d-05,-2.3257052522646d-08,
     |  -3.9352318783307d-12,-5.2438571451367d-18,-7.8396435730252d-31/
      data (lpmn(lat,30,34), lat = 1,36)/
     |   1.0924319719958d-32, 2.2089191210213d-19, 2.8061469596248d-13,
     |   2.3787444588984d-09, 1.6271847022372d-06, 2.3438387534903d-04,
     |   1.1329710262584d-02, 2.3702300544852d-01, 2.4748580951431d+00,
     |   1.3774004121033d+01, 3.9897214359969d+01, 4.3515452898860d+01,
     |  -5.6268062581690d+01,-1.8719169574191d+02,-6.1138475236335d+01,
     |   2.5833821332281d+02, 1.9075149343862d+02,-2.4073240718111d+02,
     |  -2.4073240718111d+02, 1.9075149343862d+02, 2.5833821332281d+02,
     |  -6.1138475236335d+01,-1.8719169574191d+02,-5.6268062581690d+01,
     |   4.3515452898860d+01, 3.9897214359969d+01, 1.3774004121033d+01,
     |   2.4748580951431d+00, 2.3702300544852d-01, 1.1329710262584d-02,
     |   2.3438387534903d-04, 1.6271847022372d-06, 2.3787444588985d-09,
     |   2.8061469596250d-13, 2.2089191210213d-19, 1.0924319719958d-32/
      data (lpmn(lat,31,34), lat = 1,36)/
     |   1.3248728831442d-34, 8.0946039400786d-21, 1.7391060295189d-14,
     |   2.1112517771583d-10, 1.9167328533999d-07, 3.5207459272367d-05,
     |   2.1265697046576d-03, 5.5240849153766d-02, 7.2168305520743d-01,
     |   5.1709651304703d+00, 2.0856138438432d+01, 4.3874144867353d+01,
     |   2.4255188111331d+01,-8.7505565148084d+01,-1.7213630203699d+02,
     |  -1.5804894713162d+01, 2.4048938665065d+02, 1.6839829478660d+02,
     |  -1.6839829478660d+02,-2.4048938665065d+02, 1.5804894713161d+01,
     |   1.7213630203699d+02, 8.7505565148084d+01,-2.4255188111331d+01,
     |  -4.3874144867353d+01,-2.0856138438432d+01,-5.1709651304703d+00,
     |  -7.2168305520743d-01,-5.5240849153766d-02,-2.1265697046577d-03,
     |  -3.5207459272367d-05,-1.9167328533999d-07,-2.1112517771584d-10,
     |  -1.7391060295190d-14,-8.0946039400786d-21,-1.3248728831442d-34/
      data (lpmn(lat,32,34), lat = 1,36)/
     |   1.3554573994380d-36, 2.5013143852273d-22, 9.0809432846437d-16,
     |   1.5765997018858d-11, 1.8957029717055d-08, 4.4267654926058d-06,
     |   3.3256496485844d-04, 1.0649322767205d-02, 1.7195631046459d-01,
     |   1.5491384469707d+00, 8.2055690799369d+00, 2.5543876469970d+01,
     |   4.1495422862859d+01, 8.8058160709017d+00,-9.2604908537997d+01,
     |  -1.4915578355302d+02,-2.0699486756859d+01, 1.8037235551905d+02,
     |   1.8037235551905d+02,-2.0699486756859d+01,-1.4915578355302d+02,
     |  -9.2604908537997d+01, 8.8058160709017d+00, 4.1495422862859d+01,
     |   2.5543876469970d+01, 8.2055690799369d+00, 1.5491384469707d+00,
     |   1.7195631046459d-01, 1.0649322767205d-02, 3.3256496485845d-04,
     |   4.4267654926058d-06, 1.8957029717055d-08, 1.5765997018859d-11,
     |   9.0809432846444d-16, 2.5013143852273d-22, 1.3554573994380d-36/
      data (lpmn(lat,33,34), lat = 1,36)/
     |   1.1040413848552d-38, 6.1513596184209d-24, 3.7708218318361d-17,
     |   9.3512135815973d-13, 1.4864337268840d-09, 4.4009055685187d-07,
     |   4.0961234510850d-05, 1.6073458556318d-03, 3.1776241381767d-02,
     |   3.5400659939104d-01, 2.3801495502592d+00, 9.9796926238716d+00,
     |   2.5781750606410d+01, 3.6229201320048d+01, 6.8738018675622d+00,
     |  -7.0019791311072d+01,-1.2140719805762d+02,-6.2884395847471d+01,
     |   6.2884395847471d+01, 1.2140719805762d+02, 7.0019791311073d+01,
     |  -6.8738018675622d+00,-3.6229201320048d+01,-2.5781750606410d+01,
     |  -9.9796926238717d+00,-2.3801495502592d+00,-3.5400659939104d-01,
     |  -3.1776241381767d-02,-1.6073458556318d-03,-4.0961234510851d-05,
     |  -4.4009055685187d-07,-1.4864337268840d-09,-9.3512135815977d-13,
     |  -3.7708218318363d-17,-6.1513596184209d-24,-1.1040413848552d-38/
      data (lpmn(lat,34,34), lat = 1,36)/
     |   6.2059232611392d-41, 1.0436453917265d-25, 1.0795000755341d-18,
     |   3.8195914227990d-14, 8.0133589402645d-11, 3.0010525173903d-08,
     |   3.4489242746945d-06, 1.6503138907152d-04, 3.9644298742504d-03,
     |   5.3948770300878d-02, 4.5028164830121d-01, 2.4244205383765d+00,
     |   8.6407848948287d+00, 2.0305535455743d+01, 2.9463386246707d+01,
     |   1.8405988915323d+01,-1.9014632503880d+01,-5.6139759573151d+01,
     |  -5.6139759573151d+01,-1.9014632503880d+01, 1.8405988915322d+01,
     |   2.9463386246707d+01, 2.0305535455743d+01, 8.6407848948287d+00,
     |   2.4244205383765d+00, 4.5028164830121d-01, 5.3948770300878d-02,
     |   3.9644298742505d-03, 1.6503138907153d-04, 3.4489242746946d-06,
     |   3.0010525173903d-08, 8.0133589402645d-11, 3.8195914227991d-14,
     |   1.0795000755342d-18, 1.0436453917265d-25, 6.2059232611392d-41/
      data (lpmn(lat, 0,35), lat = 1,36)/
     |  -3.6364554149163d+03, 2.1335822824556d+03,-1.7046125779642d+03,
     |   1.4896296769379d+03,-1.3584029614545d+03, 1.2696798986865d+03,
     |  -1.2058649095278d+03, 1.1580729253680d+03,-1.1212967210798d+03,
     |   1.0924890079461d+03,-1.0696884720226d+03, 1.0515795875496d+03,
     |  -1.0372534891463d+03, 1.0260702777825d+03,-1.0175761442135d+03,
     |   1.0114519174707d+03,-1.0074806446817d+03, 1.0055273808792d+03,
     |  -1.0055273808792d+03, 1.0074806446817d+03,-1.0114519174707d+03,
     |   1.0175761442135d+03,-1.0260702777825d+03, 1.0372534891463d+03,
     |  -1.0515795875496d+03, 1.0696884720226d+03,-1.0924890079461d+03,
     |   1.1212967210798d+03,-1.1580729253680d+03, 1.2058649095278d+03,
     |  -1.2696798986865d+03, 1.3584029614545d+03,-1.4896296769379d+03,
     |   1.7046125779642d+03,-2.1335822824556d+03, 3.6364554149163d+03/
      data (lpmn(lat, 2,35), lat = 1,36)/
     |   1.2251728617285d+03,-1.0367927112020d+03, 1.2500411981157d+03,
     |  -1.2426759102393d+03, 1.2050983725038d+03,-1.1670925712811d+03,
     |   1.1340381056105d+03,-1.1063727404057d+03, 1.0834834331002d+03,
     |  -1.0646257640298d+03, 1.0491439323670d+03,-1.0365079900670d+03,
     |   1.0263036634901d+03,-1.0182128414975d+03, 1.0119953330496d+03,
     |  -1.0074743419612d+03, 1.0045257338692d+03,-1.0030705988565d+03,
     |   1.0030705988565d+03,-1.0045257338692d+03, 1.0074743419612d+03,
     |  -1.0119953330496d+03, 1.0182128414975d+03,-1.0263036634901d+03,
     |   1.0365079900670d+03,-1.0491439323670d+03, 1.0646257640298d+03,
     |  -1.0834834331002d+03, 1.1063727404057d+03,-1.1340381056105d+03,
     |   1.1670925712811d+03,-1.2050983725038d+03, 1.2426759102393d+03,
     |  -1.2500411981157d+03, 1.0367927112020d+03,-1.2251728617285d+03/
      data (lpmn(lat, 4,35), lat = 1,36)/
     |   5.6137776183542d+02,-6.9541097284501d+02, 2.0452785334550d+02,
     |   3.6984848632900d+02,-6.5011013645557d+02, 7.9410171564744d+02,
     |  -8.7347236085207d+02, 9.1971237173718d+02,-9.4777099489202d+02,
     |   9.6530192782106d+02,-9.7647883504730d+02, 9.8369692923781d+02,
     |  -9.8838791027055d+02, 9.9143474328212d+02,-9.9339367031466d+02,
     |   9.9461785550956d+02,-9.9532809419549d+02, 9.9565342709669d+02,
     |  -9.9565342709669d+02, 9.9532809419549d+02,-9.9461785550955d+02,
     |   9.9339367031466d+02,-9.9143474328212d+02, 9.8838791027056d+02,
     |  -9.8369692923780d+02, 9.7647883504730d+02,-9.6530192782106d+02,
     |   9.4777099489202d+02,-9.1971237173717d+02, 8.7347236085206d+02,
     |  -7.9410171564744d+02, 6.5011013645557d+02,-3.6984848632898d+02,
     |  -2.0452785334552d+02, 6.9541097284501d+02,-5.6137776183542d+02/
      data (lpmn(lat, 6,35), lat = 1,36)/
     |   2.8149674453833d+01, 4.8312065374028d+02,-1.0331008226308d+03,
     |   8.8785374640345d+02,-3.4993654668386d+02,-5.8863130617795d+01,
     |   3.3743839197938d+02,-5.2734889906710d+02, 6.5951470358666d+02,
     |  -7.5357509999542d+02, 8.2179663895182d+02,-8.7195117518301d+02,
     |   9.0906597557513d+02,-9.3645445587561d+02, 9.5632659731869d+02,
     |  -9.7015550386559d+02, 9.7889956466077d+02,-9.8313588042914d+02,
     |   9.8313588042914d+02,-9.7889956466077d+02, 9.7015550386559d+02,
     |  -9.5632659731869d+02, 9.3645445587561d+02,-9.0906597557514d+02,
     |   8.7195117518300d+02,-8.2179663895182d+02, 7.5357509999542d+02,
     |  -6.5951470358666d+02, 5.2734889906710d+02,-3.3743839197936d+02,
     |   5.8863130617795d+01, 3.4993654668386d+02,-8.8785374640347d+02,
     |   1.0331008226308d+03,-4.8312065374028d+02,-2.8149674453833d+01/
      data (lpmn(lat, 8,35), lat = 1,36)/
     |   5.4166786601192d-01, 1.5945761864351d+02, 1.2188331296904d+02,
     |  -8.5647992095245d+02, 1.1236205231594d+03,-8.1917876001889d+02,
     |   4.3121728442226d+02,-9.2428173745748d+01,-1.7767953561456d+02,
     |   3.8726439276843d+02,-5.4865612679985d+02, 6.7261647933557d+02,
     |  -7.6742873732963d+02, 8.3918339973892d+02,-8.9225489088431d+02,
     |   9.2971399078614d+02,-9.5363198075149d+02, 9.6528637960509d+02,
     |  -9.6528637960509d+02, 9.5363198075149d+02,-9.2971399078614d+02,
     |   8.9225489088431d+02,-8.3918339973891d+02, 7.6742873732964d+02,
     |  -6.7261647933556d+02, 5.4865612679985d+02,-3.8726439276843d+02,
     |   1.7767953561455d+02, 9.2428173745754d+01,-4.3121728442228d+02,
     |   8.1917876001889d+02,-1.1236205231594d+03, 8.5647992095244d+02,
     |  -1.2188331296903d+02,-1.5945761864351d+02,-5.4166786601192d-01/
      data (lpmn(lat,10,35), lat = 1,36)/
     |   5.4183975765933d-03, 1.8639900508996d+01, 2.3254103243576d+02,
     |  -2.4227821289525d+02,-4.4375649482311d+02, 1.0144416753303d+03,
     |  -1.0107687265417d+03, 7.5341462568565d+02,-4.3233059684977d+02,
     |   1.2525783432338d+02, 1.4182646527619d+02,-3.6375286624428d+02,
     |   5.4287611369794d+02,-6.8367718130064d+02, 7.9066335965858d+02,
     |  -8.6761543684207d+02, 9.1736813052783d+02,-9.4178467276069d+02,
     |   9.4178467276069d+02,-9.1736813052783d+02, 8.6761543684206d+02,
     |  -7.9066335965858d+02, 6.8367718130064d+02,-5.4287611369795d+02,
     |   3.6375286624426d+02,-1.4182646527619d+02,-1.2525783432339d+02,
     |   4.3233059684978d+02,-7.5341462568566d+02, 1.0107687265417d+03,
     |  -1.0144416753303d+03, 4.4375649482311d+02, 2.4227821289525d+02,
     |  -2.3254103243576d+02,-1.8639900508996d+01,-5.4183975765933d-03/
      data (lpmn(lat,12,35), lat = 1,36)/
     |   3.2567623292835d-05, 1.1673417647360d+00, 6.3853488721005d+01,
     |   1.9483743716241d+02,-4.7507241150157d+02, 1.6997127369399d+00,
     |   7.0610874858341d+02,-9.7324578959345d+02, 8.9775514686211d+02,
     |  -6.5164792628760d+02, 3.4730907186827d+02,-4.4595999978373d+01,
     |  -2.2785149753383d+02, 4.5783815899506d+02,-6.4123370515325d+02,
     |   7.7752564251394d+02,-8.6752780155184d+02, 9.1222663245190d+02,
     |  -9.1222663245190d+02, 8.6752780155184d+02,-7.7752564251394d+02,
     |   6.4123370515324d+02,-4.5783815899506d+02, 2.2785149753384d+02,
     |   4.4595999978389d+01,-3.4730907186827d+02, 6.5164792628761d+02,
     |  -8.9775514686211d+02, 9.7324578959345d+02,-7.0610874858341d+02,
     |  -1.6997127369399d+00, 4.7507241150158d+02,-1.9483743716242d+02,
     |  -6.3853488721007d+01,-1.1673417647360d+00,-3.2567623292835d-05/
      data (lpmn(lat,14,35), lat = 1,36)/
     |   1.2786259631947d-07, 4.5351244840362d-02, 8.7920098484048d+00,
     |   1.1126767964911d+02, 7.3641730089959d+01,-5.3929221466939d+02,
     |   3.4870604738608d+02, 3.4448209285158d+02,-8.0020417055924d+02,
     |   9.0374483248327d+02,-7.5687359102757d+02, 4.7780510921295d+02,
     |  -1.5305693299334d+02,-1.6274237433685d+02, 4.3756520566006d+02,
     |  -6.5357507508362d+02, 8.0131813722700d+02,-8.7613177143260d+02,
     |   8.7613177143260d+02,-8.0131813722700d+02, 6.5357507508361d+02,
     |  -4.3756520566006d+02, 1.6274237433685d+02, 1.5305693299333d+02,
     |  -4.7780510921296d+02, 7.5687359102757d+02,-9.0374483248328d+02,
     |   8.0020417055924d+02,-3.4448209285157d+02,-3.4870604738609d+02,
     |   5.3929221466939d+02,-7.3641730089958d+01,-1.1126767964911d+02,
     |  -8.7920098484050d+00,-4.5351244840362d-02,-1.2786259631947d-07/
      data (lpmn(lat,16,35), lat = 1,36)/
     |   3.4548670973715d-10, 1.1792009085567d-03, 7.4322605436885d-01,
     |   2.5936754299861d+01, 1.3387204536065d+02,-7.3319503904370d+01,
     |  -4.6963728220446d+02, 5.4849413986554d+02, 3.3571845554481d+01,
     |  -5.8848615997089d+02, 8.3411848820870d+02,-7.7823328556306d+02,
     |   5.2304182258239d+02,-1.7492522879416d+02,-1.8276834174379d+02,
     |   4.9214245588365d+02,-7.1606918485278d+02, 8.3295479954464d+02,
     |  -8.3295479954464d+02, 7.1606918485278d+02,-4.9214245588364d+02,
     |   1.8276834174379d+02, 1.7492522879416d+02,-5.2304182258238d+02,
     |   7.7823328556306d+02,-8.3411848820870d+02, 5.8848615997089d+02,
     |  -3.3571845554477d+01,-5.4849413986554d+02, 4.6963728220446d+02,
     |   7.3319503904370d+01,-1.3387204536065d+02,-2.5936754299861d+01,
     |  -7.4322605436887d-01,-1.1792009085567d-03,-3.4548670973715d-10/
      data (lpmn(lat,18,35), lat = 1,36)/
     |   6.6429003043277d-13, 2.1453426932696d-05, 4.2012645019611d-02,
     |   3.5515385508520d+00, 4.8238265316596d+01, 1.2199378421282d+02,
     |  -1.9560909340506d+02,-3.3293603704305d+02, 6.1722647735952d+02,
     |  -1.7836866606919d+02,-4.0977095971978d+02, 7.4800517189071d+02,
     |  -7.4895576501259d+02, 4.9139501243058d+02,-1.0342138665454d+02,
     |  -2.9445651596654d+02, 6.0974893090777d+02,-7.8210330104507d+02,
     |   7.8210330104507d+02,-6.0974893090777d+02, 2.9445651596653d+02,
     |   1.0342138665454d+02,-4.9139501243058d+02, 7.4895576501259d+02,
     |  -7.4800517189071d+02, 4.0977095971978d+02, 1.7836866606920d+02,
     |  -6.1722647735953d+02, 3.3293603704305d+02, 1.9560909340507d+02,
     |  -1.2199378421282d+02,-4.8238265316596d+01,-3.5515385508520d+00,
     |  -4.2012645019612d-02,-2.1453426932696d-05,-6.6429003043277d-13/
      data (lpmn(lat,20,35), lat = 1,36)/
     |   9.2765651894468d-16, 2.8037063174883d-07, 1.6601218894423d-03,
     |   3.1929929956219d-01, 9.3632888615020d+00, 6.7516618989841d+01,
     |   8.4413381913113d+01,-2.6897979173992d+02,-1.9224188737089d+02,
     |   6.0282657154359d+02,-2.8664613825487d+02,-3.0311630110057d+02,
     |   6.8361710237419d+02,-6.8570214080020d+02, 3.7795677892345d+02,
     |   7.0006149331941d+01,-4.8172615026785d+02, 7.2296488055615d+02,
     |  -7.2296488055615d+02, 4.8172615026785d+02,-7.0006149331933d+01,
     |  -3.7795677892346d+02, 6.8570214080020d+02,-6.8361710237419d+02,
     |   3.0311630110057d+02, 2.8664613825487d+02,-6.0282657154359d+02,
     |   1.9224188737089d+02, 2.6897979173992d+02,-8.4413381913113d+01,
     |  -6.7516618989841d+01,-9.3632888615020d+00,-3.1929929956220d-01,
     |  -1.6601218894424d-03,-2.8037063174883d-07,-9.2765651894467d-16/
      data (lpmn(lat,22,35), lat = 1,36)/
     |   9.5042696189470d-19, 2.6679762062823d-09, 4.6922643612882d-05,
     |   1.9800790664163d-02, 1.1528048356537d+00, 1.7225707698652d+01,
     |   7.7804325049658d+01, 3.8906807861671d+01,-2.9467983073045d+02,
     |  -8.8244137093991d+01, 5.5428755661600d+02,-3.0604837057799d+02,
     |  -2.8150038623070d+02, 6.4864880649148d+02,-5.7308287825072d+02,
     |   1.5967928043034d+02, 3.3386048120242d+02,-6.5494938925658d+02,
     |   6.5494938925658d+02,-3.3386048120242d+02,-1.5967928043034d+02,
     |   5.7308287825072d+02,-6.4864880649148d+02, 2.8150038623070d+02,
     |   3.0604837057800d+02,-5.5428755661600d+02, 8.8244137093990d+01,
     |   2.9467983073045d+02,-3.8906807861670d+01,-7.7804325049659d+01,
     |  -1.7225707698652d+01,-1.1528048356537d+00,-1.9800790664164d-02,
     |  -4.6922643612884d-05,-2.6679762062823d-09,-9.5042696189469d-19/
      data (lpmn(lat,24,35), lat = 1,36)/
     |   7.1486493649119d-22, 1.8537176381944d-11, 9.5648413172758d-07,
     |   8.6511340258839d-04, 9.5513425386839d-02, 2.6458855588577d+00,
     |   2.4747989162240d+01, 7.8342577926429d+01, 1.9225379454794d+00,
     |  -2.8748992716059d+02,-3.8183507769783d+01, 5.0252193507159d+02,
     |  -2.4879564842830d+02,-3.3787974611457d+02, 6.0916762100916d+02,
     |  -3.5822921375464d+02,-1.7199798317736d+02, 5.7755618104491d+02,
     |  -5.7755618104491d+02, 1.7199798317736d+02, 3.5822921375464d+02,
     |  -6.0916762100916d+02, 3.3787974611457d+02, 2.4879564842830d+02,
     |  -5.0252193507160d+02, 3.8183507769783d+01, 2.8748992716059d+02,
     |  -1.9225379454792d+00,-7.8342577926428d+01,-2.4747989162240d+01,
     |  -2.6458855588577d+00,-9.5513425386838d-02,-8.6511340258841d-04,
     |  -9.5648413172763d-07,-1.8537176381944d-11,-7.1486493649119d-22/
      data (lpmn(lat,26,35), lat = 1,36)/
     |   3.9086370313290d-25, 9.3249816659063d-14, 1.3990569299303d-08,
     |   2.6689579277872d-05, 5.4301146783847d-03, 2.6356023286262d-01,
     |   4.4090187207478d+00, 2.9529737983491d+01, 7.2450700329502d+01,
     |  -1.6806338639744d+01,-2.6223159919602d+02,-4.3451113138620d+01,
     |   4.5096782330346d+02,-1.1485812883046d+02,-4.3355958615154d+02,
     |   4.7568071817569d+02, 7.9134971962842d+00,-4.9048543142768d+02,
     |   4.9048543142767d+02,-7.9134971962827d+00,-4.7568071817569d+02,
     |   4.3355958615154d+02, 1.1485812883046d+02,-4.5096782330346d+02,
     |   4.3451113138617d+01, 2.6223159919602d+02, 1.6806338639745d+01,
     |  -7.2450700329502d+01,-2.9529737983491d+01,-4.4090187207478d+00,
     |  -2.6356023286262d-01,-5.4301146783847d-03,-2.6689579277873d-05,
     |  -1.3990569299303d-08,-9.3249816659063d-14,-3.9086370313290d-25/
      data (lpmn(lat,28,35), lat = 1,36)/
     |   1.5170386633937d-28, 3.3195924396705d-16, 1.4385316579871d-10,
     |   5.7212530327932d-07, 2.1038009951728d-04, 1.7294214254440d-02,
     |   4.8345875325046d-01, 5.6770113300209d+00, 3.0211711151005d+01,
     |   6.4214937984350d+01,-1.4640926546361d+01,-2.2438208411743d+02,
     |  -9.4397106100560d+01, 3.7094464876114d+02, 9.0501117826494d+01,
     |  -4.5974258493541d+02, 1.3839423692413d+02, 3.9383388038387d+02,
     |  -3.9383388038387d+02,-1.3839423692413d+02, 4.5974258493541d+02,
     |  -9.0501117826493d+01,-3.7094464876114d+02, 9.4397106100562d+01,
     |   2.2438208411743d+02, 1.4640926546361d+01,-6.4214937984350d+01,
     |  -3.0211711151006d+01,-5.6770113300209d+00,-4.8345875325047d-01,
     |  -1.7294214254440d-02,-2.1038009951728d-04,-5.7212530327933d-07,
     |  -1.4385316579871d-10,-3.3195924396705d-16,-1.5170386633937d-28/
      data (lpmn(lat,30,35), lat = 1,36)/
     |   3.9906101460680d-32, 7.9900446922387d-19, 9.9493655407040d-13,
     |   8.1780931931932d-09, 5.3601115843779d-06, 7.2965749588670d-04,
     |   3.2778641646571d-02, 6.2347470752937d-01, 5.7321106000210d+00,
     |   2.6550351659792d+01, 5.5339673087777d+01, 4.8907473471995d+00,
     |  -1.6715873795109d+02,-1.6208347460892d+02, 2.1120586242424d+02,
     |   2.8707185061074d+02,-2.3657102889266d+02,-2.8847399406884d+02,
     |   2.8847399406884d+02, 2.3657102889266d+02,-2.8707185061074d+02,
     |  -2.1120586242424d+02, 1.6208347460892d+02, 1.6715873795110d+02,
     |  -4.8907473471989d+00,-5.5339673087777d+01,-2.6550351659792d+01,
     |  -5.7321106000210d+00,-6.2347470752937d-01,-3.2778641646571d-02,
     |  -7.2965749588670d-04,-5.3601115843779d-06,-8.1780931931935d-09,
     |  -9.9493655407047d-13,-7.9900446922387d-19,-3.9906101460680d-32/
      data (lpmn(lat,32,35), lat = 1,36)/
     |   6.4904083679894d-36, 1.1867895299291d-21, 4.2293415298449d-15,
     |   7.1367407971757d-11, 8.2513688144665d-08, 1.8306423724527d-05,
     |   1.2885049178155d-03, 3.8002538603666d-02, 5.5275392506608d-01,
     |   4.3451511049327d+00, 1.9047448626827d+01, 4.3670107579017d+01,
     |   3.0134830416817d+01,-8.1059870361594d+01,-1.7869128856832d+02,
     |  -2.6991694456679d+01, 2.4587628146293d+02, 1.7691966152799d+02,
     |  -1.7691966152799d+02,-2.4587628146293d+02, 2.6991694456677d+01,
     |   1.7869128856832d+02, 8.1059870361594d+01,-3.0134830416817d+01,
     |  -4.3670107579018d+01,-1.9047448626827d+01,-4.3451511049327d+00,
     |  -5.5275392506608d-01,-3.8002538603666d-02,-1.2885049178155d-03,
     |  -1.8306423724527d-05,-8.2513688144665d-08,-7.1367407971760d-11,
     |  -4.2293415298452d-15,-1.1867895299291d-21,-6.4904083679894d-36/
      data (lpmn(lat,34,35), lat = 1,36)/
     |   5.2236237674624d-40, 8.7095239838535d-25, 8.8539496408416d-18,
     |   3.0509535026078d-13, 6.1730578516586d-10, 2.2059102218130d-07,
     |   2.3900289088480d-05, 1.0631939109781d-03, 2.3344717395303d-02,
     |   2.8415838933932d-01, 2.0596950071859d+00, 9.2106496714889d+00,
     |   2.5192298735380d+01, 3.7586546742168d+01, 1.0075868717559d+01,
     |  -6.9420700977782d+01,-1.2574886086973d+02,-6.6059349114227d+01,
     |   6.6059349114227d+01, 1.2574886086974d+02, 6.9420700977783d+01,
     |  -1.0075868717559d+01,-3.7586546742168d+01,-2.5192298735380d+01,
     |  -9.2106496714890d+00,-2.0596950071859d+00,-2.8415838933932d-01,
     |  -2.3344717395303d-02,-1.0631939109781d-03,-2.3900289088481d-05,
     |  -2.2059102218130d-07,-6.1730578516586d-10,-3.0509535026079d-13,
     |  -8.8539496408423d-18,-8.7095239838535d-25,-5.2236237674624d-40/
!
!     Pmn Basis Set pmn(lat,m,n)
      data (pmn(lat, 0, 0), lat = 1,36)/
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01,
     |   7.0710678118655d-01, 7.0710678118655d-01, 7.0710678118655d-01/
      data (pmn(lat, 0, 1), lat = 1,36)/
     |   1.2235791856553d+00, 1.2142670092351d+00, 1.1957135276802d+00,
     |   1.1680599441881d+00, 1.1315167192269d+00, 1.0863619688038d+00,
     |   1.0329393478349d+00, 9.7165543472308d-01, 9.0297663705145d-01,
     |   8.2742564193966d-01, 7.4557743807945d-01, 6.5805493972348d-01,
     |   5.6552424593179d-01, 4.6868957115567d-01, 3.6828788574057d-01,
     |   2.6508330713667d-01, 1.5986128450378d-01, 5.3422620968938d-02,
     |  -5.3422620968938d-02,-1.5986128450378d-01,-2.6508330713667d-01,
     |  -3.6828788574057d-01,-4.6868957115567d-01,-5.6552424593179d-01,
     |  -6.5805493972348d-01,-7.4557743807945d-01,-8.2742564193966d-01,
     |  -9.0297663705145d-01,-9.7165543472308d-01,-1.0329393478349d+00,
     |  -1.0863619688038d+00,-1.1315167192269d+00,-1.1680599441881d+00,
     |  -1.1957135276802d+00,-1.2142670092351d+00,-1.2235791856553d+00/
      data (pmn(lat, 1, 1), lat = 1,36)/
     |   3.7775497555894d-02, 1.1303899832182d-01, 1.8744220405569d-01,
     |   2.6041886143601d-01, 3.3141357403559d-01, 3.9988602922377d-01,
     |   4.6531511027178d-01, 5.2720286236567d-01, 5.8507828234316d-01,
     |   6.3850090331210d-01, 6.8706414686945d-01, 7.3039841740845d-01,
     |   7.6817391496434d-01, 8.0010314519127d-01, 8.2594310736780d-01,
     |   8.4549714377918d-01, 8.5861643640126d-01, 8.6520113949555d-01,
     |   8.6520113949555d-01, 8.5861643640126d-01, 8.4549714377918d-01,
     |   8.2594310736780d-01, 8.0010314519127d-01, 7.6817391496434d-01,
     |   7.3039841740845d-01, 6.8706414686945d-01, 6.3850090331210d-01,
     |   5.8507828234317d-01, 5.2720286236567d-01, 4.6531511027178d-01,
     |   3.9988602922377d-01, 3.3141357403559d-01, 2.6041886143601d-01,
     |   1.8744220405569d-01, 1.1303899832182d-01, 3.7775497555894d-02/
      data (pmn(lat, 0, 2), lat = 1,36)/
     |   1.5766262971287d+00, 1.5407318307161d+00, 1.4700335330895d+00,
     |   1.3666795362472d+00, 1.2338101990835d+00, 1.0754626891730d+00,
     |   8.9644831547672d-01, 7.0220633915373d-01, 4.9863870436341d-01,
     |   2.9193071067868d-01, 8.8363075888367d-02,-1.0587890043463d-01,
     |  -2.8489327413092d-01,-4.4324078404137d-01,-5.7611012120508d-01,
     |  -6.7946411804744d-01,-7.5016241567405d-01,-7.8605688208659d-01,
     |  -7.8605688208659d-01,-7.5016241567405d-01,-6.7946411804744d-01,
     |  -5.7611012120508d-01,-4.4324078404137d-01,-2.8489327413092d-01,
     |  -1.0587890043463d-01, 8.8363075888367d-02, 2.9193071067868d-01,
     |   4.9863870436341d-01, 7.0220633915373d-01, 8.9644831547672d-01,
     |   1.0754626891730d+00, 1.2338101990835d+00, 1.3666795362472d+00,
     |   1.4700335330895d+00, 1.5407318307161d+00, 1.5766262971287d+00/
      data (pmn(lat, 1, 2), lat = 1,36)/
     |   8.4388185047002d-02, 2.5060046284084d-01, 4.0919837238121d-01,
     |   5.5536299644115d-01, 6.8465319688146d-01, 7.9314055638576d-01,
     |   8.7752874143276d-01, 9.3525365972230d-01, 9.6456136882236d-01,
     |   9.6456136882236d-01, 9.3525365972230d-01, 8.7752874143276d-01,
     |   7.9314055638576d-01, 6.8465319688146d-01, 5.5536299644115d-01,
     |   4.0919837238121d-01, 2.5060046284084d-01, 8.4388185047004d-02,
     |  -8.4388185047004d-02,-2.5060046284084d-01,-4.0919837238121d-01,
     |  -5.5536299644115d-01,-6.8465319688146d-01,-7.9314055638576d-01,
     |  -8.7752874143276d-01,-9.3525365972230d-01,-9.6456136882236d-01,
     |  -9.6456136882236d-01,-9.3525365972230d-01,-8.7752874143276d-01,
     |  -7.9314055638576d-01,-6.8465319688146d-01,-5.5536299644115d-01,
     |  -4.0919837238121d-01,-2.5060046284084d-01,-8.4388185047002d-02/
      data (pmn(lat, 2, 2), lat = 1,36)/
     |   1.8422338647450d-03, 1.6496088414777d-02, 4.5358547559547d-02,
     |   8.7552640083049d-02, 1.4179631983520d-01, 2.0644142005535d-01,
     |   2.7952373208532d-01, 3.5882268685551d-01, 4.4192882575242d-01,
     |   5.2631701079943d-01, 6.0942314969635d-01, 6.8872210446653d-01,
     |   7.6180441649650d-01, 8.2644951671666d-01, 8.8069319646881d-01,
     |   9.2288728899231d-01, 9.5174974813708d-01, 9.6640360268711d-01,
     |   9.6640360268711d-01, 9.5174974813708d-01, 9.2288728899231d-01,
     |   8.8069319646881d-01, 8.2644951671666d-01, 7.6180441649650d-01,
     |   6.8872210446653d-01, 6.0942314969635d-01, 5.2631701079943d-01,
     |   4.4192882575242d-01, 3.5882268685551d-01, 2.7952373208532d-01,
     |   2.0644142005535d-01, 1.4179631983520d-01, 8.7552640083049d-02,
     |   4.5358547559547d-02, 1.6496088414777d-02, 1.8422338647450d-03/
      data (pmn(lat, 0, 3), lat = 1,36)/
     |   1.8601577137355d+00, 1.7758215221229d+00, 1.6125735893917d+00,
     |   1.3808956068215d+00, 1.0956170930909d+00, 7.7491208529797d-01,
     |   4.3907025269157d-01, 1.0912610628395d-01,-1.9456036925236d-01,
     |  -4.5367504111504d-01,-6.5317958085312d-01,-7.8231636251544d-01,
     |  -8.3531997606634d-01,-8.1178703200225d-01,-7.1667923138935d-01,
     |  -5.5995967795761d-01,-3.5588741147883d-01,-1.2201844047575d-01,
     |   1.2201844047575d-01, 3.5588741147883d-01, 5.5995967795761d-01,
     |   7.1667923138935d-01, 8.1178703200225d-01, 8.3531997606634d-01,
     |   7.8231636251544d-01, 6.5317958085312d-01, 4.5367504111504d-01,
     |   1.9456036925237d-01,-1.0912610628395d-01,-4.3907025269156d-01,
     |  -7.7491208529797d-01,-1.0956170930909d+00,-1.3808956068215d+00,
     |  -1.6125735893917d+00,-1.7758215221229d+00,-1.8601577137355d+00/
      data (pmn(lat, 1, 3), lat = 1,36)/
     |   1.4100681154942d-01, 4.1394583999384d-01, 6.6027543305578d-01,
     |   8.6426195988471d-01, 1.0130372040186d+00, 1.0974674483403d+00,
     |   1.1127682736161d+00, 1.0588232313268d+00, 9.4018472991115d-01,
     |   7.6575712767712d-01, 5.4818367982242d-01, 3.0297916556913d-01,
     |   4.7467349245728d-02,-2.0040427459070d-01,-4.2329164329729d-01,
     |  -6.0563953550565d-01,-7.3474441782897d-01,-8.0162227648079d-01,
     |  -8.0162227648079d-01,-7.3474441782897d-01,-6.0563953550565d-01,
     |  -4.2329164329729d-01,-2.0040427459070d-01, 4.7467349245729d-02,
     |   3.0297916556913d-01, 5.4818367982242d-01, 7.6575712767712d-01,
     |   9.4018472991115d-01, 1.0588232313268d+00, 1.1127682736161d+00,
     |   1.0974674483403d+00, 1.0130372040186d+00, 8.6426195988471d-01,
     |   6.6027543305578d-01, 4.1394583999384d-01, 1.4100681154942d-01/
      data (pmn(lat, 2, 3), lat = 1,36)/
     |   4.8694536067320d-03, 4.3271162396259d-02, 1.1716278124919d-01,
     |   2.2092139048191d-01, 3.4660061205796d-01, 4.8447880444394d-01,
     |   6.2373038043895d-01, 7.5317443177296d-01, 8.6204956015117d-01,
     |   9.4076201333600d-01, 9.8155602966178d-01, 9.7906058218502d-01,
     |   9.3067512423316d-01, 8.3676789835715d-01, 7.0067313378329d-01,
     |   5.2848715369341d-01, 3.2867710973378d-01, 1.1152882375756d-01,
     |  -1.1152882375756d-01,-3.2867710973378d-01,-5.2848715369341d-01,
     |  -7.0067313378329d-01,-8.3676789835715d-01,-9.3067512423316d-01,
     |  -9.7906058218502d-01,-9.8155602966178d-01,-9.4076201333600d-01,
     |  -8.6204956015117d-01,-7.5317443177296d-01,-6.2373038043895d-01,
     |  -4.8447880444394d-01,-3.4660061205796d-01,-2.2092139048191d-01,
     |  -1.1716278124919d-01,-4.3271162396259d-02,-4.8694536067320d-03/
      data (pmn(lat, 3, 3), lat = 1,36)/
     |   8.6795601633180d-05, 2.3256911443542d-03, 1.0603989398149d-02,
     |   2.8437043699258d-02, 5.8610849326562d-02, 1.0296173030619d-01,
     |   1.6222157178266d-01, 2.3593937058028d-01, 3.2248466760959d-01,
     |   4.1913283599632d-01, 5.2222660923130d-01, 6.2740302526595d-01,
     |   7.2987049034842d-01, 8.2471723538509d-01, 9.0723028165762d-01,
     |   9.7320329887662d-01, 1.0192124769554d+00, 1.0428416933614d+00,
     |   1.0428416933614d+00, 1.0192124769554d+00, 9.7320329887662d-01,
     |   9.0723028165762d-01, 8.2471723538509d-01, 7.2987049034842d-01,
     |   6.2740302526595d-01, 5.2222660923130d-01, 4.1913283599632d-01,
     |   3.2248466760959d-01, 2.3593937058028d-01, 1.6222157178266d-01,
     |   1.0296173030619d-01, 5.8610849326562d-02, 2.8437043699258d-02,
     |   1.0603989398149d-02, 2.3256911443542d-03, 8.6795601633180d-05/
      data (pmn(lat, 0, 4), lat = 1,36)/
     |   2.1011732798407d+00, 1.9433086086504d+00, 1.6448095495461d+00,
     |   1.2381134545383d+00, 7.6706067331307d-01, 2.8176516053684d-01,
     |  -1.6722637093313d-01,-5.3478844597638d-01,-7.8638526779050d-01,
     |  -9.0193854913341d-01,-8.7793726202429d-01,-7.2754431855211d-01,
     |  -4.7869694134936d-01,-1.7043932668693d-01, 1.5206101952656d-01,
     |   4.4320383319147d-01, 6.6265979260253d-01, 7.8039323033552d-01,
     |   7.8039323033552d-01, 6.6265979260253d-01, 4.4320383319147d-01,
     |   1.5206101952656d-01,-1.7043932668693d-01,-4.7869694134936d-01,
     |  -7.2754431855211d-01,-8.7793726202429d-01,-9.0193854913341d-01,
     |  -7.8638526779050d-01,-5.3478844597638d-01,-1.6722637093314d-01,
     |   2.8176516053684d-01, 7.6706067331307d-01, 1.2381134545383d+00,
     |   1.6448095495461d+00, 1.9433086086504d+00, 2.1011732798407d+00/
      data (pmn(lat, 1, 4), lat = 1,36)/
     |   2.0601973065225d-01, 5.9554158652955d-01, 9.2015574281074d-01,
     |   1.1450905676765d+00, 1.2472537301334d+00, 1.2178947794450d+00,
     |   1.0635520472139d+00, 8.0517295942015d-01, 4.7551662884358d-01,
     |   1.1515416596024d-01,-2.3244939782260d-01,-5.2617763442970d-01,
     |  -7.3219736508196d-01,-8.2799098435214d-01,-8.0500157685050d-01,
     |  -6.6957393883290d-01,-4.4208077071320d-01,-1.5434273223108d-01,
     |   1.5434273223108d-01, 4.4208077071320d-01, 6.6957393883290d-01,
     |   8.0500157685050d-01, 8.2799098435214d-01, 7.3219736508196d-01,
     |   5.2617763442970d-01, 2.3244939782260d-01,-1.1515416596024d-01,
     |  -4.7551662884358d-01,-8.0517295942015d-01,-1.0635520472139d+00,
     |  -1.2178947794450d+00,-1.2472537301334d+00,-1.1450905676765d+00,
     |  -9.2015574281074d-01,-5.9554158652955d-01,-2.0601973065225d-01/
      data (pmn(lat, 2, 4), lat = 1,36)/
     |   9.5512792501221d-03, 8.4012443249693d-02, 2.2280857881698d-01,
     |   4.0694346193120d-01, 6.1091058997669d-01, 8.0586982366145d-01,
     |   9.6325472400540d-01, 1.0583715730832d+00, 1.0735513198913d+00,
     |   1.0004690078613d+00, 8.4134520606291d-01, 6.0887853833603d-01,
     |   3.2491136042157d-01, 1.7983528695123d-02,-2.7993640867059d-01,
     |  -5.3715360381478d-01,-7.2594098505219d-01,-8.2578336965914d-01,
     |  -8.2578336965914d-01,-7.2594098505219d-01,-5.3715360381478d-01,
     |  -2.7993640867059d-01, 1.7983528695122d-02, 3.2491136042157d-01,
     |   6.0887853833603d-01, 8.4134520606291d-01, 1.0004690078613d+00,
     |   1.0735513198913d+00, 1.0583715730832d+00, 9.6325472400541d-01,
     |   8.0586982366145d-01, 6.1091058997669d-01, 4.0694346193120d-01,
     |   2.2280857881698d-01, 8.4012443249693d-02, 9.5512792501221d-03/
      data (pmn(lat, 3, 4), lat = 1,36)/
     |   2.6013897435827d-04, 6.9173836026377d-03, 3.1057897526865d-02,
     |   8.1362671815450d-02, 1.6244809222774d-01, 2.7398451055309d-01,
     |   4.1044885790346d-01, 5.6154986326823d-01, 7.1328191069188d-01,
     |   8.4948611906789d-01, 9.5373425070607d-01, 1.0113101992530d+00,
     |   1.0110500602787d+00, 9.4681686710344d-01, 8.1842822154102d-01,
     |   6.3191923887643d-01, 3.9910177104049d-01, 1.3646434735037d-01,
     |  -1.3646434735037d-01,-3.9910177104049d-01,-6.3191923887643d-01,
     |  -8.1842822154102d-01,-9.4681686710344d-01,-1.0110500602787d+00,
     |  -1.0113101992530d+00,-9.5373425070607d-01,-8.4948611906789d-01,
     |  -7.1328191069188d-01,-5.6154986326823d-01,-4.1044885790346d-01,
     |  -2.7398451055309d-01,-1.6244809222774d-01,-8.1362671815450d-02,
     |  -3.1057897526865d-02,-6.9173836026377d-03,-2.6013897435827d-04/
      data (pmn(lat, 4, 4), lat = 1,36)/
     |   4.0156286185928d-06, 3.2197783004188d-04, 2.4343459495125d-03,
     |   9.0699002491258d-03, 2.3789972311344d-02, 5.0426368530985d-02,
     |   9.2448823823296d-02, 1.5234345669071d-01, 2.3108336252020d-01,
     |   3.2776217395466d-01, 4.3944235423049d-01, 5.6124445274571d-01,
     |   6.8667461087325d-01, 8.0815874718704d-01, 9.1772655934341d-01,
     |   1.0077698164783d+00, 1.0717896502455d+00, 1.1050478868933d+00,
     |   1.1050478868933d+00, 1.0717896502455d+00, 1.0077698164783d+00,
     |   9.1772655934341d-01, 8.0815874718704d-01, 6.8667461087325d-01,
     |   5.6124445274571d-01, 4.3944235423049d-01, 3.2776217395466d-01,
     |   2.3108336252020d-01, 1.5234345669071d-01, 9.2448823823296d-02,
     |   5.0426368530985d-02, 2.3789972311344d-02, 9.0699002491258d-03,
     |   2.4343459495126d-03, 3.2197783004188d-04, 4.0156286185928d-06/
      data (pmn(lat, 0, 5), lat = 1,36)/
     |   2.3118375000562d+00, 2.0531633551594d+00, 1.5783690546064d+00,
     |   9.6494640784596d-01, 3.1149582157343d-01,-2.7977103346346d-01,
     |  -7.2098361704468d-01,-9.5373642867052d-01,-9.5864019983855d-01,
     |  -7.5760357559105d-01,-4.0850756263385d-01, 6.6487279366505d-03,
     |   3.9784383738406d-01, 6.8430838832342d-01, 8.0971682514627d-01,
     |   7.5244933790916d-01, 5.2902458528381d-01, 1.9010585916262d-01,
     |  -1.9010585916262d-01,-5.2902458528381d-01,-7.5244933790916d-01,
     |  -8.0971682514627d-01,-6.8430838832342d-01,-3.9784383738406d-01,
     |  -6.6487279366527d-03, 4.0850756263385d-01, 7.5760357559105d-01,
     |   9.5864019983855d-01, 9.5373642867052d-01, 7.2098361704468d-01,
     |   2.7977103346346d-01,-3.1149582157343d-01,-9.6494640784596d-01,
     |  -1.5783690546064d+00,-2.0531633551594d+00,-2.3118375000562d+00/
      data (pmn(lat, 1, 5), lat = 1,36)/
     |   2.7828764927230d-01, 7.8896956013186d-01, 1.1701924954518d+00,
     |   1.3615393402751d+00, 1.3364056427312d+00, 1.1064464676999d+00,
     |   7.1900863390729d-01, 2.4805496616934d-01,-2.1970555939593d-01,
     |  -6.0088270346255d-01,-8.3066764180986d-01,-8.7445876308100d-01,
     |  -7.3370793111399d-01,-4.4493562678488d-01,-7.2148508601684d-02,
     |   3.0586904792939d-01, 6.1095905864549d-01, 7.8075925590933d-01,
     |   7.8075925590933d-01, 6.1095905864549d-01, 3.0586904792940d-01,
     |  -7.2148508601683d-02,-4.4493562678488d-01,-7.3370793111399d-01,
     |  -8.7445876308100d-01,-8.3066764180986d-01,-6.0088270346255d-01,
     |  -2.1970555939593d-01, 2.4805496616933d-01, 7.1900863390729d-01,
     |   1.1064464676999d+00, 1.3364056427312d+00, 1.3615393402751d+00,
     |   1.1701924954518d+00, 7.8896956013186d-01, 2.7828764927230d-01/
      data (pmn(lat, 2, 5), lat = 1,36)/
     |   1.6104058398550d-02, 1.3984661382206d-01, 3.6127944443550d-01,
     |   6.3333107538031d-01, 8.9702391051137d-01, 1.0929403707111d+00,
     |   1.1728662564486d+00, 1.1093961450505d+00, 9.0166364285134d-01,
     |   5.7608410907866d-01, 1.8193332578746d-01,-2.1744294756789d-01,
     |  -5.5616882358179d-01,-7.7798471279704d-01,-8.4673460413046d-01,
     |  -7.5322946455155d-01,-5.1719116700687d-01,-1.8389394708191d-01,
     |   1.8389394708191d-01, 5.1719116700687d-01, 7.5322946455155d-01,
     |   8.4673460413046d-01, 7.7798471279704d-01, 5.5616882358179d-01,
     |   2.1744294756790d-01,-1.8193332578746d-01,-5.7608410907866d-01,
     |  -9.0166364285134d-01,-1.1093961450505d+00,-1.1728662564486d+00,
     |  -1.0929403707111d+00,-8.9702391051137d-01,-6.3333107538031d-01,
     |  -3.6127944443550d-01,-1.3984661382206d-01,-1.6104058398550d-02/
      data (pmn(lat, 3, 5), lat = 1,36)/
     |   5.7450453350884d-04, 1.5131206888883d-02, 6.6631916246338d-02,
     |   1.6944124805038d-01, 3.2472787527782d-01, 5.1915124248600d-01,
     |   7.2657763221382d-01, 9.1255522263414d-01, 1.0407362090118d+00,
     |   1.0800428392428d+00, 1.0112084410454d+00, 8.3141705502463d-01,
     |   5.5610046806483d-01, 2.1746789540798d-01,-1.4005438485914d-01,
     |  -4.6672060661388d-01,-7.1550605725741d-01,-8.4987201817474d-01,
     |  -8.4987201817474d-01,-7.1550605725741d-01,-4.6672060661388d-01,
     |  -1.4005438485914d-01, 2.1746789540798d-01, 5.5610046806483d-01,
     |   8.3141705502463d-01, 1.0112084410454d+00, 1.0800428392428d+00,
     |   1.0407362090118d+00, 9.1255522263414d-01, 7.2657763221382d-01,
     |   5.1915124248600d-01, 3.2472787527782d-01, 1.6944124805038d-01,
     |   6.6631916246339d-02, 1.5131206888883d-02, 5.7450453350884d-04/
      data (pmn(lat, 4, 5), lat = 1,36)/
     |   1.3305657322966d-05, 1.0587437945937d-03, 7.8824305393415d-03,
     |   2.8689194502119d-02, 7.2896323447598d-02, 1.4834843188889d-01,
     |   2.5859904972140d-01, 4.0085453635698d-01, 5.6506174365880d-01,
     |   7.3440989578910d-01, 8.8724872327090d-01, 1.0001495136755d+00,
     |   1.0516057024602d+00, 1.0257291104668d+00, 9.1527467777415d-01,
     |   7.2342654410726d-01, 4.6398460430509d-01, 1.5986632908671d-01,
     |  -1.5986632908671d-01,-4.6398460430509d-01,-7.2342654410726d-01,
     |  -9.1527467777415d-01,-1.0257291104668d+00,-1.0516057024602d+00,
     |  -1.0001495136755d+00,-8.8724872327090d-01,-7.3440989578910d-01,
     |  -5.6506174365880d-01,-4.0085453635698d-01,-2.5859904972140d-01,
     |  -1.4834843188889d-01,-7.2896323447598d-02,-2.8689194502119d-02,
     |  -7.8824305393415d-03,-1.0587437945937d-03,-1.3305657322966d-05/
      data (pmn(lat, 5, 5), lat = 1,36)/
     |   1.8370858196787d-07, 4.4077807151189d-05, 5.5260573770510d-04,
     |   2.8604914724503d-03, 9.5483853930534d-03, 2.4420785883256d-02,
     |   5.2097184926452d-02, 9.7267393017009d-02, 1.6373757987198d-01,
     |   2.5344636008382d-01, 3.6564943766704d-01, 4.9645237872436d-01,
     |   6.3881669357887d-01, 7.8308402864221d-01, 9.1797138730968d-01,
     |   1.0319037778946d+00, 1.1144856161062d+00, 1.1578809054659d+00,
     |   1.1578809054659d+00, 1.1144856161062d+00, 1.0319037778946d+00,
     |   9.1797138730968d-01, 7.8308402864221d-01, 6.3881669357886d-01,
     |   4.9645237872436d-01, 3.6564943766704d-01, 2.5344636008382d-01,
     |   1.6373757987198d-01, 9.7267393017009d-02, 5.2097184926452d-02,
     |   2.4420785883256d-02, 9.5483853930534d-03, 2.8604914724503d-03,
     |   5.5260573770511d-04, 4.4077807151189d-05, 1.8370858196787d-07/
      data (pmn(lat, 0, 6), lat = 1,36)/
     |   2.4987938632755d+00, 2.1107305583674d+00, 1.4238452089390d+00,
     |   5.9414683282035d-01,-1.9467625491096d-01,-7.7679318807343d-01,
     |  -1.0444285180357d+00,-9.7242319392299d-01,-6.2105272560861d-01,
     |  -1.1676919233758d-01, 3.8365374294835d-01, 7.3578607370724d-01,
     |   8.4556483882999d-01, 6.9262737928526d-01, 3.3298376517168d-01,
     |  -1.1930051586200d-01,-5.2605885864420d-01,-7.6506969658073d-01,
     |  -7.6506969658073d-01,-5.2605885864420d-01,-1.1930051586200d-01,
     |   3.3298376517168d-01, 6.9262737928526d-01, 8.4556483882999d-01,
     |   7.3578607370724d-01, 3.8365374294835d-01,-1.1676919233758d-01,
     |  -6.2105272560861d-01,-9.7242319392299d-01,-1.0444285180357d+00,
     |  -7.7679318807343d-01,-1.9467625491096d-01, 5.9414683282035d-01,
     |   1.4238452089390d+00, 2.1107305583674d+00, 2.4987938632755d+00/
      data (pmn(lat, 1, 6), lat = 1,36)/
     |   3.5693527747247d-01, 9.8841374961422d-01, 1.3934963558012d+00,
     |   1.4850995924145d+00, 1.2543725676428d+00, 7.7169777030139d-01,
     |   1.6726159676459d-01,-4.0354446948426d-01,-8.0066739191845d-01,
     |  -9.3515827160868d-01,-7.9079552359032d-01,-4.2604143941523d-01,
     |   4.3903854431346d-02, 4.7987045943071d-01, 7.5730567654447d-01,
     |   8.0019331962134d-01, 6.0116269550817d-01, 2.2244439778225d-01,
     |  -2.2244439778225d-01,-6.0116269550817d-01,-8.0019331962134d-01,
     |  -7.5730567654447d-01,-4.7987045943071d-01,-4.3903854431344d-02,
     |   4.2604143941523d-01, 7.9079552359032d-01, 9.3515827160868d-01,
     |   8.0066739191845d-01, 4.0354446948426d-01,-1.6726159676458d-01,
     |  -7.7169777030139d-01,-1.2543725676428d+00,-1.4850995924145d+00,
     |  -1.3934963558012d+00,-9.8841374961422d-01,-3.5693527747247d-01/
      data (pmn(lat, 2, 6), lat = 1,36)/
     |   2.4711418876168d-02, 2.1130310460412d-01, 5.2869173573557d-01,
     |   8.8065586498841d-01, 1.1571237008279d+00, 1.2647577689482d+00,
     |   1.1532457644971d+00, 8.3013010711552d-01, 3.6007771245622d-01,
     |  -1.5132739746156d-01,-5.8501471377318d-01,-8.3978637959950d-01,
     |  -8.5921877331930d-01,-6.4687563529619d-01,-2.6569872955375d-01,
     |   1.7834501043039d-01, 5.6407763311707d-01, 7.8703439719269d-01,
     |   7.8703439719269d-01, 5.6407763311707d-01, 1.7834501043040d-01,
     |  -2.6569872955375d-01,-6.4687563529619d-01,-8.5921877331931d-01,
     |  -8.3978637959950d-01,-5.8501471377318d-01,-1.5132739746156d-01,
     |   3.6007771245622d-01, 8.3013010711552d-01, 1.1532457644971d+00,
     |   1.2647577689482d+00, 1.1571237008279d+00, 8.8065586498841d-01,
     |   5.2869173573558d-01, 2.1130310460412d-01, 2.4711418876168d-02/
      data (pmn(lat, 3, 6), lat = 1,36)/
     |   1.0802115135061d-03, 2.8124710749453d-02, 1.2097540697352d-01,
     |   2.9662328797275d-01, 5.4013770519315d-01, 8.0627717292297d-01,
     |   1.0305129586510d+00, 1.1466042991464d+00, 1.1059481146624d+00,
     |   8.9329936249196d-01, 5.3430662050830d-01, 9.2418490140237d-02,
     |  -3.4446604775819d-01,-6.8445765208308d-01,-8.5411993270841d-01,
     |  -8.1711906153723d-01,-5.8417296788866d-01,-2.1156854065689d-01,
     |   2.1156854065689d-01, 5.8417296788866d-01, 8.1711906153723d-01,
     |   8.5411993270841d-01, 6.8445765208308d-01, 3.4446604775819d-01,
     |  -9.2418490140234d-02,-5.3430662050830d-01,-8.9329936249196d-01,
     |  -1.1059481146624d+00,-1.1466042991464d+00,-1.0305129586510d+00,
     |  -8.0627717292297d-01,-5.4013770519315d-01,-2.9662328797275d-01,
     |  -1.2097540697352d-01,-2.8124710749453d-02,-1.0802115135061d-03/
      data (pmn(lat, 4, 6), lat = 1,36)/
     |   3.2307274718485d-05, 2.5472196188164d-03, 1.8614965917724d-02,
     |   6.5850506883980d-02, 1.6090343980078d-01, 3.1120091629858d-01,
     |   5.0865412501369d-01, 7.2754393519894d-01, 9.2768083608646d-01,
     |   1.0624562794645d+00, 1.0899707414760d+00, 9.8443648767352d-01,
     |   7.4479433739538d-01, 3.9804531102947d-01,-3.9482589174622d-03,
     |  -3.9380807694445d-01,-7.0216439463325d-01,-8.7227192116516d-01,
     |  -8.7227192116516d-01,-7.0216439463325d-01,-3.9380807694445d-01,
     |  -3.9482589174626d-03, 3.9804531102946d-01, 7.4479433739538d-01,
     |   9.8443648767352d-01, 1.0899707414760d+00, 1.0624562794645d+00,
     |   9.2768083608647d-01, 7.2754393519894d-01, 5.0865412501369d-01,
     |   3.1120091629858d-01, 1.6090343980078d-01, 6.5850506883981d-02,
     |   1.8614965917724d-02, 2.5472196188164d-03, 3.2307274718485d-05/
      data (pmn(lat, 5, 6), lat = 1,36)/
     |   6.6174028187942d-07, 1.5756517015158d-04, 1.9452193415630d-03,
     |   9.8363015672663d-03, 3.1806579096972d-02, 7.8101654841954d-02,
     |   1.5842186614285d-01, 2.7823105770142d-01, 4.3526217457739d-01,
     |   6.1736368652350d-01, 8.0257146366697d-01, 9.6175797472817d-01,
     |   1.0635392753734d+00, 1.0804873910281d+00, 9.9527392209871d-01,
     |   8.0528132792689d-01, 5.2449797113571d-01, 1.8210217368640d-01,
     |  -1.8210217368640d-01,-5.2449797113571d-01,-8.0528132792689d-01,
     |  -9.9527392209871d-01,-1.0804873910281d+00,-1.0635392753734d+00,
     |  -9.6175797472817d-01,-8.0257146366697d-01,-6.1736368652350d-01,
     |  -4.3526217457739d-01,-2.7823105770142d-01,-1.5842186614285d-01,
     |  -7.8101654841954d-02,-3.1806579096972d-02,-9.8363015672664d-03,
     |  -1.9452193415630d-03,-1.5756517015158d-04,-6.6174028187942d-07/
      data (pmn(lat, 6, 6), lat = 1,36)/
     |   8.3404610711023d-09, 5.9882331663109d-06, 1.2448963500662d-04,
     |   8.9528954856718d-04, 3.8032130400235d-03, 1.1736707701246d-02,
     |   2.9134786098709d-02, 6.1630466766703d-02, 1.1513643182202d-01,
     |   1.9449032222681d-01, 3.0193441508716d-01, 4.3580061710993d-01,
     |   5.8977482946698d-01, 7.5301697328801d-01, 9.1123354593927d-01,
     |   1.0485804798124d+00, 1.1500695025690d+00, 1.2040136102668d+00,
     |   1.2040136102668d+00, 1.1500695025690d+00, 1.0485804798124d+00,
     |   9.1123354593927d-01, 7.5301697328801d-01, 5.8977482946698d-01,
     |   4.3580061710993d-01, 3.0193441508716d-01, 1.9449032222681d-01,
     |   1.1513643182202d-01, 6.1630466766703d-02, 2.9134786098710d-02,
     |   1.1736707701246d-02, 3.8032130400235d-03, 8.9528954856719d-04,
     |   1.2448963500662d-04, 5.9882331663109d-06, 8.3404610711023d-09/
      data (pmn(lat, 0, 7), lat = 1,36)/
     |   2.6660969608177d+00, 2.1195882986320d+00, 1.1932548563168d+00,
     |   1.6455993404102d-01,-6.7058064630424d-01,-1.0944975809861d+00,
     |  -1.0355720913210d+00,-5.8438850050093d-01, 4.6092016467057d-02,
     |   6.0093279550215d-01, 8.7480041434496d-01, 7.8200063799125d-01,
     |   3.8066947975994d-01,-1.5618290395472d-01,-6.1071882859751d-01,
     |  -8.0465782451421d-01,-6.6649324678159d-01,-2.5685538849478d-01,
     |   2.5685538849478d-01, 6.6649324678159d-01, 8.0465782451421d-01,
     |   6.1071882859751d-01, 1.5618290395472d-01,-3.8066947975995d-01,
     |  -7.8200063799125d-01,-8.7480041434496d-01,-6.0093279550215d-01,
     |  -4.6092016467058d-02, 5.8438850050093d-01, 1.0355720913210d+00,
     |   1.0944975809861d+00, 6.7058064630424d-01,-1.6455993404102d-01,
     |  -1.1932548563168d+00,-2.1195882986320d+00,-2.6660969608177d+00/
      data (pmn(lat, 1, 7), lat = 1,36)/
     |   4.4124538426064d-01, 1.1884429799379d+00, 1.5752413776591d+00,
     |   1.4971084074255d+00, 1.0032121123866d+00, 2.7636381201412d-01,
     |  -4.3263345770376d-01,-8.9263897306743d-01,-9.7073524191663d-01,
     |  -6.7422768186253d-01,-1.4200000753637d-01, 4.1058428448025d-01,
     |   7.7248118288170d-01, 8.1380498300559d-01, 5.3094009738888d-01,
     |   4.4083862245263d-02,-4.5106464980361d-01,-7.5898123349327d-01,
     |  -7.5898123349327d-01,-4.5106464980361d-01, 4.4083862245261d-02,
     |   5.3094009738888d-01, 8.1380498300559d-01, 7.7248118288170d-01,
     |   4.1058428448025d-01,-1.4200000753637d-01,-6.7422768186253d-01,
     |  -9.7073524191663d-01,-8.9263897306743d-01,-4.3263345770377d-01,
     |   2.7636381201412d-01, 1.0032121123866d+00, 1.4971084074255d+00,
     |   1.5752413776591d+00, 1.1884429799379d+00, 4.4124538426064d-01/
      data (pmn(lat, 2, 7), lat = 1,36)/
     |   3.5533779642403d-02, 2.9838797824086d-01, 7.1870854950258d-01,
     |   1.1247225027086d+00, 1.3420621800549d+00, 1.2590717218429d+00,
     |   8.6974779834786d-01, 2.7849930627974d-01,-3.3526224779554d-01,
     |  -7.8010817966377d-01,-9.2050841209611d-01,-7.2515985128594d-01,
     |  -2.7820937616237d-01, 2.5079290631109d-01, 6.6748742077502d-01,
     |   8.2208333627762d-01, 6.6256128091103d-01, 2.5254974786046d-01,
     |  -2.5254974786045d-01,-6.6256128091103d-01,-8.2208333627762d-01,
     |  -6.6748742077502d-01,-2.5079290631109d-01, 2.7820937616237d-01,
     |   7.2515985128594d-01, 9.2050841209611d-01, 7.8010817966377d-01,
     |   3.3526224779554d-01,-2.7849930627973d-01,-8.6974779834785d-01,
     |  -1.2590717218429d+00,-1.3420621800549d+00,-1.1247225027086d+00,
     |  -7.1870854950258d-01,-2.9838797824086d-01,-3.5533779642403d-02/
      data (pmn(lat, 3, 7), lat = 1,36)/
     |   1.8315909097399d-03, 4.7049497017015d-02, 1.9684810125803d-01,
     |   4.6205201225966d-01, 7.9026614902334d-01, 1.0809917726568d+00,
     |   1.2218969157356d+00, 1.1329716653570d+00, 8.0184776055421d-01,
     |   2.9630483715980d-01,-2.5199038542038d-01,-6.8802579920485d-01,
     |  -8.8471231020107d-01,-7.8696651354302d-01,-4.3271612544508d-01,
     |   5.7283716858998d-02, 5.1810365651947d-01, 7.9499399938983d-01,
     |   7.9499399938983d-01, 5.1810365651947d-01, 5.7283716859000d-02,
     |  -4.3271612544508d-01,-7.8696651354302d-01,-8.8471231020107d-01,
     |  -6.8802579920486d-01,-2.5199038542038d-01, 2.9630483715979d-01,
     |   8.0184776055421d-01, 1.1329716653570d+00, 1.2218969157356d+00,
     |   1.0809917726568d+00, 7.9026614902334d-01, 4.6205201225966d-01,
     |   1.9684810125803d-01, 4.7049497017015d-02, 1.8315909097399d-03/
      data (pmn(lat, 4, 7), lat = 1,36)/
     |   6.6363732474423d-05, 5.1764725580583d-03, 3.7011955024235d-02,
     |   1.2658373043631d-01, 2.9509139109173d-01, 5.3614954173411d-01,
     |   8.0773654987587d-01, 1.0386790006807d+00, 1.1489152732952d+00,
     |   1.0771911877976d+00, 8.0636544691650d-01, 3.7654693984350d-01,
     |  -1.2001283730122d-01,-5.6219908811555d-01,-8.3495396489533d-01,
     |  -8.6485665620092d-01,-6.4459475743719d-01,-2.3782238977686d-01,
     |   2.3782238977686d-01, 6.4459475743719d-01, 8.6485665620092d-01,
     |   8.3495396489533d-01, 5.6219908811555d-01, 1.2001283730122d-01,
     |  -3.7654693984350d-01,-8.0636544691650d-01,-1.0771911877976d+00,
     |  -1.1489152732952d+00,-1.0386790006807d+00,-8.0773654987587d-01,
     |  -5.3614954173411d-01,-2.9509139109173d-01,-1.2658373043631d-01,
     |  -3.7011955024235d-02,-5.1764725580583d-03,-6.6363732474423d-05/
      data (pmn(lat, 5, 7), lat = 1,36)/
     |   1.7392203397498d-06, 4.1044090291220d-04, 4.9764228310396d-03,
     |   2.4478682589392d-02, 7.6212751074434d-02, 1.7816354561879d-01,
     |   3.3966534927187d-01, 5.5229646653492d-01, 7.8528528609218d-01,
     |   9.8850783153221d-01, 1.1035804791958d+00, 1.0804902835788d+00,
     |   8.9478662179216d-01, 5.5953023326378d-01, 1.2737237774429d-01,
     |  -3.1897500464737d-01,-6.8593515672655d-01,-8.9274366856325d-01,
     |  -8.9274366856325d-01,-6.8593515672655d-01,-3.1897500464737d-01,
     |   1.2737237774429d-01, 5.5953023326378d-01, 8.9478662179216d-01,
     |   1.0804902835788d+00, 1.1035804791958d+00, 9.8850783153221d-01,
     |   7.8528528609218d-01, 5.5229646653492d-01, 3.3966534927187d-01,
     |   1.7816354561879d-01, 7.6212751074434d-02, 2.4478682589392d-02,
     |   4.9764228310396d-03, 4.1044090291220d-04, 1.7392203397498d-06/
      data (pmn(lat, 6, 7), lat = 1,36)/
     |   3.2271722037291d-08, 2.2993913750988d-05, 4.7071749109299d-04,
     |   3.3069577453736d-03, 1.3608542968169d-02, 4.0320029598292d-02,
     |   9.5167060537331d-02, 1.8936850085200d-01, 3.2876780340414d-01,
     |   5.0889357929121d-01, 7.1187767761264d-01, 9.0688035537165d-01,
     |   1.0547206840974d+00, 1.1160664565568d+00, 1.0612486065881d+00,
     |   8.7899043429611d-01, 5.8138976935858d-01, 2.0340264092844d-01,
     |  -2.0340264092844d-01,-5.8138976935858d-01,-8.7899043429610d-01,
     |  -1.0612486065881d+00,-1.1160664565568d+00,-1.0547206840974d+00,
     |  -9.0688035537165d-01,-7.1187767761264d-01,-5.0889357929121d-01,
     |  -3.2876780340414d-01,-1.8936850085200d-01,-9.5167060537331d-02,
     |  -4.0320029598292d-02,-1.3608542968169d-02,-3.3069577453737d-03,
     |  -4.7071749109299d-04,-2.2993913750988d-05,-3.2271722037291d-08/
      data (pmn(lat, 7, 7), lat = 1,36)/
     |   3.7657478164892d-10, 8.0905488175571d-07, 2.7890195333455d-05,
     |   2.7866789077909d-04, 1.5065096770960d-03, 5.6096207419565d-03,
     |   1.6203542390361d-02, 3.8835079312845d-02, 8.0515171789204d-02,
     |   1.4842617370130d-01, 2.4794815663867d-01, 3.8045092504459d-01,
     |   5.4149789081698d-01, 7.2011477733196d-01, 8.9956140200538d-01,
     |   1.0596559804305d+00, 1.1802506951363d+00, 1.2450863128795d+00,
     |   1.2450863128795d+00, 1.1802506951363d+00, 1.0596559804305d+00,
     |   8.9956140200538d-01, 7.2011477733196d-01, 5.4149789081698d-01,
     |   3.8045092504459d-01, 2.4794815663867d-01, 1.4842617370130d-01,
     |   8.0515171789204d-02, 3.8835079312845d-02, 1.6203542390361d-02,
     |   5.6096207419565d-03, 1.5065096770960d-03, 2.7866789077909d-04,
     |   2.7890195333456d-05, 8.0905488175571d-07, 3.7657478164892d-10/
      data (pmn(lat, 0, 8), lat = 1,36)/
     |   2.8164090536349d+00, 2.0826943680659d+00, 9.0068415862821d-01,
     |  -2.8123024876833d-01,-1.0418558258883d+00,-1.1606065316314d+00,
     |  -6.9831426750276d-01, 4.7567082911570d-02, 6.8925816621234d-01,
     |   9.2722054125204d-01, 6.7912297740828d-01, 1.0246626329708d-01,
     |  -4.9521291689611d-01,-8.1234701664980d-01,-6.9975913094057d-01,
     |  -2.2826649092736d-01, 3.5272540960871d-01, 7.4316539455461d-01,
     |   7.4316539455461d-01, 3.5272540960871d-01,-2.2826649092735d-01,
     |  -6.9975913094057d-01,-8.1234701664980d-01,-4.9521291689611d-01,
     |   1.0246626329708d-01, 6.7912297740828d-01, 9.2722054125204d-01,
     |   6.8925816621234d-01, 4.7567082911572d-02,-6.9831426750276d-01,
     |  -1.1606065316314d+00,-1.0418558258883d+00,-2.8123024876834d-01,
     |   9.0068415862820d-01, 2.0826943680659d+00, 2.8164090536349d+00/
      data (pmn(lat, 1, 8), lat = 1,36)/
     |   5.3060227783904d-01, 1.3839351546391d+00, 1.7031160996619d+00,
     |   1.3902057356006d+00, 6.1262245005893d-01,-2.7709804566676d-01,
     |  -9.0104464087382d-01,-1.0219572716357d+00,-6.4069760809014d-01,
     |   1.7034122176725d-02, 6.1543154430533d-01, 8.6909247939256d-01,
     |   6.7379463069206d-01, 1.4756512607569d-01,-4.3470881193718d-01,
     |  -7.7953017814281d-01,-7.1851098528523d-01,-2.8864216606851d-01,
     |   2.8864216606851d-01, 7.1851098528523d-01, 7.7953017814281d-01,
     |   4.3470881193718d-01,-1.4756512607569d-01,-6.7379463069206d-01,
     |  -8.6909247939256d-01,-6.1543154430533d-01,-1.7034122176726d-02,
     |   6.4069760809014d-01, 1.0219572716357d+00, 9.0104464087383d-01,
     |   2.7709804566676d-01,-6.1262245005893d-01,-1.3902057356006d+00,
     |  -1.7031160996619d+00,-1.3839351546391d+00,-5.3060227783904d-01/
      data (pmn(lat, 2, 8), lat = 1,36)/
     |   4.8712385462238d-02, 4.0061846500464d-01, 9.2295099404309d-01,
     |   1.3392125841909d+00, 1.4101836247658d+00, 1.0498257261995d+00,
     |   3.7012399241746d-01,-3.6661263572892d-01,-8.6617583518020d-01,
     |  -9.3664202252085d-01,-5.7587011830612d-01, 2.8433397322423d-02,
     |   5.8608411441480d-01, 8.3848155050094d-01, 6.7692092567722d-01,
     |   1.9019314818875d-01,-3.8034109183742d-01,-7.5671982141750d-01,
     |  -7.5671982141750d-01,-3.8034109183742d-01, 1.9019314818874d-01,
     |   6.7692092567722d-01, 8.3848155050094d-01, 5.8608411441480d-01,
     |   2.8433397322426d-02,-5.7587011830612d-01,-9.3664202252085d-01,
     |  -8.6617583518020d-01,-3.6661263572892d-01, 3.7012399241746d-01,
     |   1.0498257261995d+00, 1.4101836247658d+00, 1.3392125841909d+00,
     |   9.2295099404309d-01, 4.0061846500464d-01, 4.8712385462238d-02/
      data (pmn(lat, 3, 8), lat = 1,36)/
     |   2.8866265767354d-03, 7.3013586495917d-02, 2.9583316303201d-01,
     |   6.5958120110621d-01, 1.0453385561695d+00, 1.2783241401628d+00,
     |   1.2140013390830d+00, 8.1722809442914d-01, 1.9441077082269d-01,
     |  -4.4012776030275d-01,-8.5137367781580d-01,-8.8612248277803d-01,
     |  -5.4369339491899d-01, 1.9032812178771d-02, 5.5277486759151d-01,
     |   8.2356536064275d-01, 7.1530961475016d-01, 2.8099291335600d-01,
     |  -2.8099291335600d-01,-7.1530961475015d-01,-8.2356536064275d-01,
     |  -5.5277486759151d-01,-1.9032812178771d-02, 5.4369339491899d-01,
     |   8.8612248277803d-01, 8.5137367781580d-01, 4.4012776030275d-01,
     |  -1.9441077082269d-01,-8.1722809442914d-01,-1.2140013390830d+00,
     |  -1.2783241401628d+00,-1.0453385561695d+00,-6.5958120110622d-01,
     |  -2.9583316303201d-01,-7.3013586495917d-02,-2.8866265767354d-03/
      data (pmn(lat, 4, 8), lat = 1,36)/
     |   1.2218226561554d-04, 9.4138933277928d-03, 6.5635921752303d-02,
     |   2.1581959430421d-01, 4.7581371552735d-01, 8.0106236999805d-01,
     |   1.0878823988147d+00, 1.2094771166281d+00, 1.0727929568427d+00,
     |   6.6996144503716d-01, 9.7947614322472d-02,-4.6709827743377d-01,
     |  -8.3392342264562d-01,-8.7330022098665d-01,-5.7495678671308d-01,
     |  -5.8050362115769d-02, 4.7185065028853d-01, 8.0315751810856d-01,
     |   8.0315751810856d-01, 4.7185065028853d-01,-5.8050362115766d-02,
     |  -5.7495678671308d-01,-8.7330022098665d-01,-8.3392342264562d-01,
     |  -4.6709827743378d-01, 9.7947614322472d-02, 6.6996144503716d-01,
     |   1.0727929568427d+00, 1.2094771166281d+00, 1.0878823988147d+00,
     |   8.0106236999805d-01, 4.7581371552735d-01, 2.1581959430421d-01,
     |   6.5635921752304d-02, 9.4138933277928d-03, 1.2218226561554d-04/
      data (pmn(lat, 5, 8), lat = 1,36)/
     |   3.8493988469786d-06, 8.9918879308453d-04, 1.0678291599519d-02,
     |   5.0872167056908d-02, 1.5151216549925d-01, 3.3403432193907d-01,
     |   5.9040244137472d-01, 8.7081670052276d-01, 1.0899977054226d+00,
     |   1.1538412292389d+00, 9.9790217700568d-01, 6.2171905529230d-01,
     |   1.0241519526473d-01,-4.2175102519615d-01,-7.9489108639806d-01,
     |  -8.9892848567181d-01,-6.9944947838524d-01,-2.6293189119308d-01,
     |   2.6293189119308d-01, 6.9944947838524d-01, 8.9892848567181d-01,
     |   7.9489108639806d-01, 4.2175102519615d-01,-1.0241519526473d-01,
     |  -6.2171905529230d-01,-9.9790217700568d-01,-1.1538412292389d+00,
     |  -1.0899977054226d+00,-8.7081670052276d-01,-5.9040244137472d-01,
     |  -3.3403432193907d-01,-1.5151216549925d-01,-5.0872167056909d-02,
     |  -1.0678291599519d-02,-8.9918879308453d-04,-3.8493988469786d-06/
      data (pmn(lat, 6, 8), lat = 1,36)/
     |   9.0798213511372d-08, 6.4131487589660d-05, 1.2898594209845d-03,
     |   8.8202540202139d-03, 3.4978370663398d-02, 9.8784498940183d-02,
     |   2.1951664079932d-01, 4.0536117604443d-01, 6.4178120782586d-01,
     |   8.8598610314126d-01, 1.0725413575031d+00, 1.1309017175734d+00,
     |   1.0101695757143d+00, 7.0215855212209d-01, 2.5302514933561d-01,
     |  -2.4291503589441d-01,-6.6711604997110d-01,-9.1138498597587d-01,
     |  -9.1138498597587d-01,-6.6711604997110d-01,-2.4291503589441d-01,
     |   2.5302514933560d-01, 7.0215855212209d-01, 1.0101695757143d+00,
     |   1.1309017175734d+00, 1.0725413575031d+00, 8.8598610314126d-01,
     |   6.4178120782587d-01, 4.0536117604443d-01, 2.1951664079932d-01,
     |   9.8784498940183d-02, 3.4978370663398d-02, 8.8202540202140d-03,
     |   1.2898594209845d-03, 6.4131487589660d-05, 9.0798213511372d-08/
      data (pmn(lat, 7, 8), lat = 1,36)/
     |   1.5511798146873d-09, 3.3072803426958d-06, 1.1226839907650d-04,
     |   1.0957989822133d-03, 5.7386763531776d-03, 2.0515725751181d-02,
     |   5.6346068920184d-02, 1.2703263649909d-01, 2.4475584327317d-01,
     |   4.1344552781241d-01, 6.2234681660817d-01, 8.4282930802855d-01,
     |   1.0309244265331d+00, 1.1362289339759d+00, 1.1153138041172d+00,
     |   9.4564058899482d-01, 6.3517938479401d-01, 2.2392546322476d-01,
     |  -2.2392546322476d-01,-6.3517938479401d-01,-9.4564058899482d-01,
     |  -1.1153138041172d+00,-1.1362289339759d+00,-1.0309244265331d+00,
     |  -8.4282930802855d-01,-6.2234681660817d-01,-4.1344552781241d-01,
     |  -2.4475584327317d-01,-1.2703263649909d-01,-5.6346068920185d-02,
     |  -2.0515725751181d-02,-5.7386763531776d-03,-1.0957989822133d-03,
     |  -1.1226839907650d-04,-3.3072803426958d-06,-1.5511798146873d-09/
      data (pmn(lat, 8, 8), lat = 1,36)/
     |   1.6931493332474d-11, 1.0885292933440d-07, 6.2223262146819d-06,
     |   8.6376022986666d-05, 5.9425939388898d-04, 2.6699527110552d-03,
     |   8.9741012056147d-03, 2.4368892584969d-02, 5.6069352303533d-02,
     |   1.1279915480769d-01, 2.0276454052768d-01, 3.3074425219608d-01,
     |   4.9509684940703d-01, 6.8577482559135d-01, 8.8433086603551d-01,
     |   1.0663772615467d+00, 1.2061666060918d+00, 1.2821840775059d+00,
     |   1.2821840775059d+00, 1.2061666060918d+00, 1.0663772615467d+00,
     |   8.8433086603551d-01, 6.8577482559135d-01, 4.9509684940703d-01,
     |   3.3074425219608d-01, 2.0276454052768d-01, 1.1279915480769d-01,
     |   5.6069352303533d-02, 2.4368892584969d-02, 8.9741012056147d-03,
     |   2.6699527110552d-03, 5.9425939388898d-04, 8.6376022986667d-05,
     |   6.2223262146820d-06, 1.0885292933440d-07, 1.6931493332474d-11/
      data (pmn(lat, 0, 9), lat = 1,36)/
     |   2.9515719598280d+00, 2.0029148791584d+00, 5.6220679651935d-01,
     |  -7.0022728998013d-01,-1.2512688711291d+00,-9.6081340059095d-01,
     |  -1.4008723567158d-01, 6.5998738457556d-01, 9.6866821817473d-01,
     |   6.4972730121566d-01,-4.9589577774048d-02,-6.7238227090014d-01,
     |  -8.3744755879944d-01,-4.6453610349292d-01, 1.9077679503217d-01,
     |   7.0632967419414d-01, 7.5870506837200d-01, 3.2169377900795d-01,
     |  -3.2169377900795d-01,-7.5870506837200d-01,-7.0632967419414d-01,
     |  -1.9077679503217d-01, 4.6453610349292d-01, 8.3744755879944d-01,
     |   6.7238227090014d-01, 4.9589577774048d-02,-6.4972730121566d-01,
     |  -9.6866821817473d-01,-6.5998738457556d-01, 1.4008723567157d-01,
     |   9.6081340059095d-01, 1.2512688711291d+00, 7.0022728998014d-01,
     |  -5.6220679651934d-01,-2.0029148791584d+00,-2.9515719598280d+00/
      data (pmn(lat, 1, 9), lat = 1,36)/
     |   6.2445911017621d-01, 1.5700676847737d+00, 1.7677716756833d+00,
     |   1.1688906658575d+00, 1.3531514478221d-01,-7.6989497389740d-01,
     |  -1.0948821124995d+00,-7.3760722114166d-01, 2.0359256164842d-02,
     |   6.9650817875894d-01, 8.9462852847037d-01, 5.2822293061513d-01,
     |  -1.4635752382069d-01,-6.9931745425327d-01,-7.9293756471809d-01,
     |  -3.8304921592925d-01, 2.6205428157675d-01, 7.3273336475874d-01,
     |   7.3273336475874d-01, 2.6205428157675d-01,-3.8304921592925d-01,
     |  -7.9293756471809d-01,-6.9931745425327d-01,-1.4635752382069d-01,
     |   5.2822293061513d-01, 8.9462852847037d-01, 6.9650817875894d-01,
     |   2.0359256164843d-02,-7.3760722114166d-01,-1.0948821124995d+00,
     |  -7.6989497389740d-01, 1.3531514478221d-01, 1.1688906658575d+00,
     |   1.7677716756833d+00, 1.5700676847737d+00, 6.2445911017621d-01/
      data (pmn(lat, 2, 9), lat = 1,36)/
     |   6.4371681126739d-02, 5.1705194841746d-01, 1.1314821568601d+00,
     |   1.4985275494737d+00, 1.3350562882760d+00, 6.5635623824376d-01,
     |  -2.2474096345687d-01,-8.7238822711339d-01,-9.7487702678996d-01,
     |  -5.2099753257070d-01, 1.9650638285933d-01, 7.5172531653045d-01,
     |   8.3066701442609d-01, 4.0802810191438d-01,-2.4623532506826d-01,
     |  -7.3241605152666d-01,-7.5992283294202d-01,-3.1850817135416d-01,
     |   3.1850817135416d-01, 7.5992283294202d-01, 7.3241605152666d-01,
     |   2.4623532506826d-01,-4.0802810191438d-01,-8.3066701442609d-01,
     |  -7.5172531653045d-01,-1.9650638285933d-01, 5.2099753257070d-01,
     |   9.7487702678997d-01, 8.7238822711339d-01, 2.2474096345687d-01,
     |  -6.5635623824376d-01,-1.3350562882760d+00,-1.4985275494737d+00,
     |  -1.1314821568601d+00,-5.1705194841746d-01,-6.4371681126739d-02/
      data (pmn(lat, 3, 9), lat = 1,36)/
     |   4.3065154944245d-03, 1.0704214122567d-01, 4.1810291275626d-01,
     |   8.7786027800860d-01, 1.2681814976112d+00, 1.3382920724937d+00,
     |   9.6668496335832d-01, 2.5877315912609d-01,-4.8515871807358d-01,
     |  -9.2125603173455d-01,-8.4987367511589d-01,-3.3164350633966d-01,
     |   3.3852433542685d-01, 7.8953658306534d-01, 7.7771360208761d-01,
     |   3.2119810304231d-01,-3.1188464855496d-01,-7.5604574514661d-01,
     |  -7.5604574514661d-01,-3.1188464855496d-01, 3.2119810304231d-01,
     |   7.7771360208761d-01, 7.8953658306534d-01, 3.3852433542685d-01,
     |  -3.3164350633965d-01,-8.4987367511589d-01,-9.2125603173455d-01,
     |  -4.8515871807358d-01, 2.5877315912608d-01, 9.6668496335832d-01,
     |   1.3382920724937d+00, 1.2681814976112d+00, 8.7786027800860d-01,
     |   4.1810291275626d-01, 1.0704214122567d-01, 4.3065154944245d-03/
      data (pmn(lat, 4, 9), lat = 1,36)/
     |   2.0792281041494d-04, 1.5799264168951d-02, 1.0704965131599d-01,
     |   3.3640751393604d-01, 6.9453565639265d-01, 1.0654055023414d+00,
     |   1.2640892105402d+00, 1.1344293402655d+00, 6.5198193472621d-01,
     |  -3.2839710153903d-02,-6.4696008850398d-01,-9.2363886925486d-01,
     |  -7.4230284900683d-01,-2.0125304433774d-01, 4.2211932922754d-01,
     |   8.0844030214158d-01, 7.6071414892250d-01, 3.0810589528856d-01,
     |  -3.0810589528856d-01,-7.6071414892250d-01,-8.0844030214158d-01,
     |  -4.2211932922754d-01, 2.0125304433773d-01, 7.4230284900683d-01,
     |   9.2363886925486d-01, 6.4696008850398d-01, 3.2839710153904d-02,
     |  -6.5198193472621d-01,-1.1344293402655d+00,-1.2640892105402d+00,
     |  -1.0654055023414d+00,-6.9453565639265d-01,-3.3640751393604d-01,
     |  -1.0704965131599d-01,-1.5799264168951d-02,-2.0792281041494d-04/
      data (pmn(lat, 5, 9), lat = 1,36)/
     |   7.6025385948826d-06, 1.7555532622665d-03, 2.0363496720187d-02,
     |   9.3530766041902d-02, 2.6459773593891d-01, 5.4425020029849d-01,
     |   8.7684963469973d-01, 1.1404768767236d+00, 1.1924692093696d+00,
     |   9.4370190008622d-01, 4.2244656905835d-01,-2.1255786644066d-01,
     |  -7.2683204920200d-01,-9.1314177539568d-01,-6.9369046756401d-01,
     |  -1.6768216382916d-01, 4.2498623842369d-01, 8.1094262438686d-01,
     |   8.1094262438686d-01, 4.2498623842369d-01,-1.6768216382916d-01,
     |  -6.9369046756401d-01,-9.1314177539568d-01,-7.2683204920200d-01,
     |  -2.1255786644066d-01, 4.2244656905835d-01, 9.4370190008622d-01,
     |   1.1924692093696d+00, 1.1404768767236d+00, 8.7684963469973d-01,
     |   5.4425020029849d-01, 2.6459773593891d-01, 9.3530766041902d-02,
     |   2.0363496720188d-02, 1.7555532622665d-03, 7.6025385948826d-06/
      data (pmn(lat, 6, 9), lat = 1,36)/
     |   2.1437927361498d-07, 1.4993368518919d-04, 2.9559044086581d-03,
     |   1.9601132442805d-02, 7.4497121227116d-02, 1.9895865504602d-01,
     |   4.1152424883140d-01, 6.9347925480147d-01, 9.7581695436518d-01,
     |   1.1518499604070d+00, 1.1172786207295d+00, 8.2282489811473d-01,
     |   3.1331183683563d-01,-2.7092206648418d-01,-7.3830698759898d-01,
     |  -9.2120706648672d-01,-7.4943340624231d-01,-2.8708278221717d-01,
     |   2.8708278221717d-01, 7.4943340624231d-01, 9.2120706648672d-01,
     |   7.3830698759898d-01, 2.7092206648418d-01,-3.1331183683563d-01,
     |  -8.2282489811473d-01,-1.1172786207295d+00,-1.1518499604070d+00,
     |  -9.7581695436518d-01,-6.9347925480147d-01,-4.1152424883140d-01,
     |  -1.9895865504602d-01,-7.4497121227116d-02,-1.9601132442805d-02,
     |  -2.9559044086582d-03,-1.4993368518919d-04,-2.1437927361498d-07/
      data (pmn(lat, 7, 9), lat = 1,36)/
     |   4.6333401349062d-09, 9.7941374423152d-06, 3.2673846520470d-04,
     |   3.1055669299326d-03, 1.5683471169703d-02, 5.3492703378520d-02,
     |   1.3849421556572d-01, 2.9026591128234d-01, 5.1126982829383d-01,
     |   7.7304730454492d-01, 1.0126087787702d+00, 1.1455832283134d+00,
     |   1.0951201079952d+00, 8.2655350253532d-01, 3.7237009116485d-01,
     |  -1.6625664457743d-01,-6.4604147067917d-01,-9.2837147002645d-01,
     |  -9.2837147002645d-01,-6.4604147067917d-01,-1.6625664457743d-01,
     |   3.7237009116485d-01, 8.2655350253532d-01, 1.0951201079952d+00,
     |   1.1455832283134d+00, 1.0126087787702d+00, 7.7304730454492d-01,
     |   5.1126982829383d-01, 2.9026591128235d-01, 1.3849421556572d-01,
     |   5.3492703378520d-02, 1.5683471169703d-02, 3.1055669299327d-03,
     |   3.2673846520471d-04, 9.7941374423152d-06, 4.6333401349062d-09/
      data (pmn(lat, 8, 9), lat = 1,36)/
     |   7.3732424612505d-11, 4.7041968575253d-07, 2.6479579826112d-05,
     |   3.5907858572194d-04, 2.3931405303106d-03, 1.0323080020814d-02,
     |   3.2991112087128d-02, 8.4271213684024d-02, 1.8019105335792d-01,
     |   3.3217427213773d-01, 5.3804169993664d-01, 7.7461451387716d-01,
     |   9.9648912380053d-01, 1.1439261800367d+00, 1.1591333149258d+00,
     |   1.0060612622662d+00, 6.8624907115123d-01, 2.4378486604564d-01,
     |  -2.4378486604564d-01,-6.8624907115123d-01,-1.0060612622662d+00,
     |  -1.1591333149258d+00,-1.1439261800367d+00,-9.9648912380053d-01,
     |  -7.7461451387716d-01,-5.3804169993664d-01,-3.3217427213773d-01,
     |  -1.8019105335792d-01,-8.4271213684024d-02,-3.2991112087129d-02,
     |  -1.0323080020814d-02,-2.3931405303106d-03,-3.5907858572194d-04,
     |  -2.6479579826113d-05,-4.7041968575253d-07,-7.3732424612505d-11/
      data (pmn(lat, 9, 9), lat = 1,36)/
     |   7.5877912340921d-13, 1.4597495076975d-08, 1.3836621928176d-06,
     |   2.6685512995299d-05, 2.3364487766520d-04, 1.2666298457373d-03,
     |   4.9539091173773d-03, 1.5241351162688d-02, 3.8917903175773d-02,
     |   8.5443155278498d-02, 1.6527197250827d-01, 2.8659066838970d-01,
     |   4.5119017557948d-01, 6.5093471303916d-01, 8.6651250199573d-01,
     |   1.0696284285131d+00, 1.2286167010033d+00, 1.3160651179151d+00,
     |   1.3160651179151d+00, 1.2286167010033d+00, 1.0696284285131d+00,
     |   8.6651250199573d-01, 6.5093471303916d-01, 4.5119017557947d-01,
     |   2.8659066838970d-01, 1.6527197250827d-01, 8.5443155278498d-02,
     |   3.8917903175773d-02, 1.5241351162688d-02, 4.9539091173773d-03,
     |   1.2666298457373d-03, 2.3364487766520d-04, 2.6685512995299d-05,
     |   1.3836621928176d-06, 1.4597495076975d-08, 7.5877912340921d-13/
      data (pmn(lat, 0,10), lat = 1,36)/
     |   3.0729116272129d+00, 1.8832849384169d+00, 1.9543841512120d-01,
     |  -1.0526537289115d+00,-1.2669893275922d+00,-5.4142399061662d-01,
     |   4.6251842716958d-01, 9.9831549388840d-01, 7.3710682878880d-01,
     |  -5.0692468662240d-02,-7.3962361677088d-01,-8.2413411561144d-01,
     |  -2.7705462094205d-01, 4.5749006982295d-01, 8.1455678057527d-01,
     |   5.3370662877608d-01,-1.5501510207759d-01,-7.1535487152480d-01,
     |  -7.1535487152480d-01,-1.5501510207759d-01, 5.3370662877608d-01,
     |   8.1455678057527d-01, 4.5749006982295d-01,-2.7705462094205d-01,
     |  -8.2413411561144d-01,-7.3962361677088d-01,-5.0692468662241d-02,
     |   7.3710682878880d-01, 9.9831549388840d-01, 4.6251842716958d-01,
     |  -5.4142399061662d-01,-1.2669893275922d+00,-1.0526537289115d+00,
     |   1.9543841512119d-01, 1.8832849384169d+00, 3.0729116272129d+00/
      data (pmn(lat, 1,10), lat = 1,36)/
     |   7.2231769831931d-01, 1.7423403684929d+00, 1.7631894544806d+00,
     |   8.4904499321246d-01,-3.6110111623626d-01,-1.0941231596635d+00,
     |  -9.5356956608087d-01,-1.5374511654742d-01, 6.7026065871686d-01,
     |   9.2764735446703d-01, 4.7846598526156d-01,-2.9854354515089d-01,
     |  -8.0886560679899d-01,-6.8469153286257d-01,-4.4363612973641d-02,
     |   6.1239415254436d-01, 7.8653885005757d-01, 3.5254923025388d-01,
     |  -3.5254923025388d-01,-7.8653885005757d-01,-6.1239415254437d-01,
     |   4.4363612973640d-02, 6.8469153286257d-01, 8.0886560679899d-01,
     |   2.9854354515089d-01,-4.7846598526156d-01,-9.2764735446703d-01,
     |  -6.7026065871686d-01, 1.5374511654742d-01, 9.5356956608087d-01,
     |   1.0941231596635d+00, 3.6110111623626d-01,-8.4904499321246d-01,
     |  -1.7631894544806d+00,-1.7423403684929d+00,-7.2231769831931d-01/
      data (pmn(lat, 2,10), lat = 1,36)/
     |   8.2620881285756d-02, 6.4631658414883d-01, 1.3333608037285d+00,
     |   1.5805905493195d+00, 1.1108936776275d+00, 1.4192430580174d-01,
     |  -7.5484149999168d-01,-1.0460769259500d+00,-6.0313081885678d-01,
     |   2.1474846135372d-01, 8.1709666804464d-01, 7.9512728118492d-01,
     |   1.9857344861926d-01,-5.1628714221931d-01,-8.2475632714989d-01,
     |  -5.1249779476197d-01, 1.7637201198134d-01, 7.2491045673303d-01,
     |   7.2491045673303d-01, 1.7637201198134d-01,-5.1249779476197d-01,
     |  -8.2475632714989d-01,-5.1628714221931d-01, 1.9857344861926d-01,
     |   7.9512728118492d-01, 8.1709666804464d-01, 2.1474846135372d-01,
     |  -6.0313081885677d-01,-1.0460769259500d+00,-7.5484149999169d-01,
     |   1.4192430580174d-01, 1.1108936776275d+00, 1.5805905493195d+00,
     |   1.3333608037285d+00, 6.4631658414883d-01, 8.2620881285756d-02/
      data (pmn(lat, 3,10), lat = 1,36)/
     |   6.1552481958767d-03, 1.5004013524142d-01, 5.6226548426070d-01,
     |   1.1010388033107d+00, 1.4199211410033d+00, 1.2219013478713d+00,
     |   5.0699260377915d-01,-3.7804619470815d-01,-9.4119665802290d-01,
     |  -8.6813467120679d-01,-2.4165852569462d-01, 5.0291661904459d-01,
     |   8.6481931665266d-01, 6.1385434712976d-01,-5.6789201597749d-02,
     |  -6.6862450746390d-01,-7.9241432764567d-01,-3.4685079828818d-01,
     |   3.4685079828818d-01, 7.9241432764567d-01, 6.6862450746390d-01,
     |   5.6789201597750d-02,-6.1385434712976d-01,-8.6481931665266d-01,
     |  -5.0291661904460d-01, 2.4165852569462d-01, 8.6813467120679d-01,
     |   9.4119665802291d-01, 3.7804619470815d-01,-5.0699260377914d-01,
     |  -1.2219013478713d+00,-1.4199211410033d+00,-1.1010388033107d+00,
     |  -5.6226548426070d-01,-1.5004013524142d-01,-6.1552481958767d-03/
      data (pmn(lat, 4,10), lat = 1,36)/
     |   3.3326928627493d-04, 2.4935221293294d-02, 1.6360720457465d-01,
     |   4.8824405665859d-01, 9.3328197411313d-01, 1.2764443411038d+00,
     |   1.2599447773108d+00, 7.7901519293241d-01,-1.2186334098623d-03,
     |  -7.0336985970816d-01,-9.5412649049544d-01,-6.2491872108237d-01,
     |   6.8298319371606d-02, 6.8596602599283d-01, 8.3877650995838d-01,
     |   4.3811221000650d-01,-2.4492043575612d-01,-7.5595049791002d-01,
     |  -7.5595049791002d-01,-2.4492043575612d-01, 4.3811221000650d-01,
     |   8.3877650995838d-01, 6.8596602599283d-01, 6.8298319371603d-02,
     |  -6.2491872108237d-01,-9.5412649049544d-01,-7.0336985970816d-01,
     |  -1.2186334098638d-03, 7.7901519293241d-01, 1.2599447773108d+00,
     |   1.2764443411038d+00, 9.3328197411313d-01, 4.8824405665859d-01,
     |   1.6360720457466d-01, 2.4935221293294d-02, 3.3326928627493d-04/
      data (pmn(lat, 5,10), lat = 1,36)/
     |   1.3821728523595d-05, 3.1509902696115d-03, 3.5599968683532d-02,
     |   1.5688801982031d-01, 4.1833073880219d-01, 7.9267843460865d-01,
     |   1.1387115665957d+00, 1.2506096962775d+00, 9.8101572248393d-01,
     |   3.6239037352661d-01,-3.6521341784337d-01,-8.6051452592587d-01,
     |  -8.7245592137144d-01,-4.0095114551899d-01, 2.8227609372002d-01,
     |   7.7961339154056d-01, 7.9969222006932d-01, 3.3410555827003d-01,
     |  -3.3410555827003d-01,-7.9969222006932d-01,-7.7961339154056d-01,
     |  -2.8227609372002d-01, 4.0095114551899d-01, 8.7245592137144d-01,
     |   8.6051452592587d-01, 3.6521341784337d-01,-3.6239037352661d-01,
     |  -9.8101572248393d-01,-1.2506096962775d+00,-1.1387115665957d+00,
     |  -7.9267843460865d-01,-4.1833073880219d-01,-1.5688801982031d-01,
     |  -3.5599968683532d-02,-3.1509902696115d-03,-1.3821728523595d-05/
      data (pmn(lat, 6,10), lat = 1,36)/
     |   4.5014724541222d-07, 3.1139407233950d-04, 6.0034613261250d-03,
     |   3.8456172438425d-02, 1.3925194047582d-01, 3.4858027703058d-01,
     |   6.6202208725283d-01, 9.9593079706317d-01, 1.1982494557143d+00,
     |   1.1173014916578d+00, 6.9868823327999d-01, 4.9910982491262d-02,
     |  -5.8022082268913d-01,-9.1325925959305d-01,-7.9015034697807d-01,
     |  -2.7145150652702d-01, 3.7748562233329d-01, 8.1811575339878d-01,
     |   8.1811575339878d-01, 3.7748562233330d-01,-2.7145150652702d-01,
     |  -7.9015034697807d-01,-9.1325925959305d-01,-5.8022082268913d-01,
     |   4.9910982491258d-02, 6.9868823327999d-01, 1.1173014916578d+00,
     |   1.1982494557143d+00, 9.9593079706317d-01, 6.6202208725283d-01,
     |   3.4858027703058d-01, 1.3925194047582d-01, 3.8456172438425d-02,
     |   6.0034613261251d-03, 3.1139407233950d-04, 4.5014724541222d-07/
      data (pmn(lat, 7,10), lat = 1,36)/
     |   1.1581739806560d-08, 2.4248700955252d-05, 7.9340300285864d-04,
     |   7.3196828168445d-03, 3.5476074324496d-02, 1.1465463335188d-01,
     |   2.7710330439231d-01, 5.3227768503689d-01, 8.3886359789227d-01,
     |   1.0968067561019d+00, 1.1763021671155d+00, 9.7963019474782d-01,
     |   5.0677295971251d-01,-1.1559204078658d-01,-6.6871382955562d-01,
     |  -9.3318326757925d-01,-7.9506834848872d-01,-3.1040855241314d-01,
     |   3.1040855241314d-01, 7.9506834848872d-01, 9.3318326757925d-01,
     |   6.6871382955562d-01, 1.1559204078658d-01,-5.0677295971252d-01,
     |  -9.7963019474782d-01,-1.1763021671155d+00,-1.0968067561019d+00,
     |  -8.3886359789227d-01,-5.3227768503689d-01,-2.7710330439232d-01,
     |  -1.1465463335188d-01,-3.5476074324496d-02,-7.3196828168446d-03,
     |  -7.9340300285865d-04,-2.4248700955252d-05,-1.1581739806560d-08/
      data (pmn(lat, 8,10), lat = 1,36)/
     |   2.3230206586841d-10, 1.4695682730374d-06, 8.1312863011385d-05,
     |   1.0741325287560d-03, 6.9068205840062d-03, 2.8444892576104d-02,
     |   8.5777981754984d-02, 2.0396536921528d-01, 3.9945836662434d-01,
     |   6.6095819855637d-01, 9.3556720451924d-01, 1.1329882356697d+00,
     |   1.1537033743940d+00, 9.3361100041584d-01, 4.8498827752475d-01,
     |  -8.9528581794183d-02,-6.2302015799960d-01,-9.4388277832401d-01,
     |  -9.4388277832401d-01,-6.2302015799960d-01,-8.9528581794185d-02,
     |   4.8498827752474d-01, 9.3361100041584d-01, 1.1537033743940d+00,
     |   1.1329882356697d+00, 9.3556720451924d-01, 6.6095819855637d-01,
     |   3.9945836662434d-01, 2.0396536921528d-01, 8.5777981754984d-02,
     |   2.8444892576104d-02, 6.9068205840062d-03, 1.0741325287560d-03,
     |   8.1312863011387d-05, 1.4695682730374d-06, 2.3230206586841d-10/
      data (pmn(lat, 9,10), lat = 1,36)/
     |   3.4738532802953d-12, 6.6321837624520d-08, 6.1904359564184d-06,
     |   1.1662850399436d-04, 9.8919350800039d-04, 5.1485897585245d-03,
     |   1.9146388815381d-02, 5.5411482726708d-02, 1.3148916423231d-01,
     |   2.6452716113931d-01, 4.6105844965515d-01, 7.0564816530447d-01,
     |   9.5471749659841d-01, 1.1415284510451d+00, 1.1940603697125d+00,
     |   1.0609119347375d+00, 7.3489235693045d-01, 2.6306713035427d-01,
     |  -2.6306713035427d-01,-7.3489235693045d-01,-1.0609119347375d+00,
     |  -1.1940603697125d+00,-1.1415284510451d+00,-9.5471749659841d-01,
     |  -7.0564816530447d-01,-4.6105844965515d-01,-2.6452716113931d-01,
     |  -1.3148916423231d-01,-5.5411482726708d-02,-1.9146388815381d-02,
     |  -5.1485897585245d-03,-9.8919350800039d-04,-1.1662850399436d-04,
     |  -6.1904359564185d-06,-6.6321837624520d-08,-3.4738532802953d-12/
      data (pmn(lat,10,10), lat = 1,36)/
     |   3.3914825325012d-14, 1.9524083470880d-09, 3.0687497535415d-07,
     |   8.2226538790885d-06, 9.1620060514287d-05, 5.9930785022305d-04,
     |   2.7274651394487d-03, 9.5074761966034d-03, 2.6941850928495d-02,
     |   6.4550975779778d-02, 1.3435706695850d-01, 2.4767711866174d-01,
     |   4.1009380433122d-01, 6.1623651339732d-01, 8.4681586168113d-01,
     |   1.0700623893840d+00, 1.2481869287369d+00, 1.3472819113196d+00,
     |   1.3472819113196d+00, 1.2481869287369d+00, 1.0700623893840d+00,
     |   8.4681586168113d-01, 6.1623651339732d-01, 4.1009380433122d-01,
     |   2.4767711866174d-01, 1.3435706695850d-01, 6.4550975779779d-02,
     |   2.6941850928495d-02, 9.5074761966034d-03, 2.7274651394487d-03,
     |   5.9930785022305d-04, 9.1620060514287d-05, 8.2226538790886d-06,
     |   3.0687497535416d-07, 1.9524083470880d-09, 3.3914825325012d-14/
      data (pmn(lat, 0,11), lat = 1,36)/
     |   3.1814137494382d+00, 1.7271361213810d+00,-1.8111199719984d-01,
     |  -1.3054125303963d+00,-1.0871303075494d+00, 1.5172141078943d-03,
     |   9.1947949377894d-01, 9.2226571184447d-01, 1.1690203681612d-01,
     |  -7.1829246766781d-01,-8.4997753956106d-01,-2.1217002302313d-01,
     |   5.8203495198006d-01, 8.1442295302425d-01, 2.9855927403239d-01,
     |  -4.7569155212719d-01,-7.9929529364908d-01,-3.8410591469203d-01,
     |   3.8410591469203d-01, 7.9929529364908d-01, 4.7569155212720d-01,
     |  -2.9855927403239d-01,-8.1442295302425d-01,-5.8203495198006d-01,
     |   2.1217002302312d-01, 8.4997753956106d-01, 7.1829246766781d-01,
     |  -1.1690203681612d-01,-9.2226571184447d-01,-9.1947949377894d-01,
     |  -1.5172141078943d-03, 1.0871303075494d+00, 1.3054125303963d+00,
     |   1.8111199719985d-01,-1.7271361213810d+00,-3.1814137494382d+00/
      data (pmn(lat, 1,11), lat = 1,36)/
     |   8.2371544085289d-01, 1.8966140527791d+00, 1.6869233227126d+00,
     |   4.5642884391476d-01,-8.0453579253107d-01,-1.1776660649025d+00,
     |  -5.1932189503190d-01, 4.9241223865298d-01, 9.7107386846804d-01,
     |   5.6127997175713d-01,-3.0967887735828d-01,-8.4969094511800d-01,
     |  -6.0305463272612d-01, 1.7318193888861d-01, 7.6565168453516d-01,
     |   6.4871695916762d-01,-5.5913328382017d-02,-7.0139921910185d-01,
     |  -7.0139921910185d-01,-5.5913328382018d-02, 6.4871695916762d-01,
     |   7.6565168453516d-01, 1.7318193888861d-01,-6.0305463272613d-01,
     |  -8.4969094511800d-01,-3.0967887735828d-01, 5.6127997175713d-01,
     |   9.7107386846804d-01, 4.9241223865298d-01,-5.1932189503189d-01,
     |  -1.1776660649025d+00,-8.0453579253107d-01, 4.5642884391475d-01,
     |   1.6869233227125d+00, 1.8966140527791d+00, 8.2371544085289d-01/
      data (pmn(lat, 2,11), lat = 1,36)/
     |   1.0355507314347d-01, 7.8664602736683d-01, 1.5172452239071d+00,
     |   1.5693429646878d+00, 7.5475524909693d-01,-3.9835820764367d-01,
     |  -1.0695160601629d+00,-8.1676712769521d-01, 6.8093046961359d-02,
     |   8.1401410912243d-01, 8.1480869727584d-01, 1.1884331867665d-01,
     |  -6.4156208511265d-01,-8.0808080321150d-01,-2.5850116957551d-01,
     |   5.0456393739356d-01, 8.0412902386869d-01, 3.8167753675338d-01,
     |  -3.8167753675337d-01,-8.0412902386869d-01,-5.0456393739356d-01,
     |   2.5850116957551d-01, 8.0808080321149d-01, 6.4156208511265d-01,
     |  -1.1884331867664d-01,-8.1480869727584d-01,-8.1401410912243d-01,
     |  -6.8093046961361d-02, 8.1676712769521d-01, 1.0695160601629d+00,
     |   3.9835820764367d-01,-7.5475524909693d-01,-1.5693429646878d+00,
     |  -1.5172452239071d+00,-7.8664602736683d-01,-1.0355507314347d-01/
      data (pmn(lat, 3,11), lat = 1,36)/
     |   8.4992136996255d-03, 2.0275790614451d-01, 7.2530412123584d-01,
     |   1.3100424872603d+00, 1.4665230872753d+00, 9.2352149525425d-01,
     |  -7.0738270071349d-02,-8.7947567017208d-01,-9.5988688166801d-01,
     |  -3.0431703865933d-01, 5.3735378440600d-01, 8.9005240983510d-01,
     |   4.9354032362559d-01,-2.9518558917809d-01,-8.0675414088792d-01,
     |  -6.1907278878733d-01, 9.4518934382429d-02, 7.1838388705384d-01,
     |   7.1838388705384d-01, 9.4518934382430d-02,-6.1907278878733d-01,
     |  -8.0675414088792d-01,-2.9518558917809d-01, 4.9354032362559d-01,
     |   8.9005240983510d-01, 5.3735378440600d-01,-3.0431703865933d-01,
     |  -9.5988688166801d-01,-8.7947567017208d-01,-7.0738270071354d-02,
     |   9.2352149525425d-01, 1.4665230872753d+00, 1.3100424872603d+00,
     |   7.2530412123584d-01, 2.0275790614451d-01, 8.4992136996255d-03/
      data (pmn(lat, 4,11), lat = 1,36)/
     |   5.0948918950789d-04, 3.7474761086878d-02, 2.3723483450241d-01,
     |   6.6764755915069d-01, 1.1658176869874d+00, 1.3798929130316d+00,
     |   1.0351104579577d+00, 2.0916230210534d-01,-6.4353190717011d-01,
     |  -9.8685152735888d-01,-6.0909017588182d-01, 1.8879472401415d-01,
     |   7.9812684435713d-01, 7.6106645220039d-01, 1.2556145367560d-01,
     |  -5.9219643776071d-01,-8.1717138183267d-01,-3.7392360063278d-01,
     |   3.7392360063278d-01, 8.1717138183267d-01, 5.9219643776071d-01,
     |  -1.2556145367560d-01,-7.6106645220039d-01,-7.9812684435713d-01,
     |  -1.8879472401416d-01, 6.0909017588182d-01, 9.8685152735888d-01,
     |   6.4353190717011d-01,-2.0916230210534d-01,-1.0351104579577d+00,
     |  -1.3798929130316d+00,-1.1658176869874d+00,-6.6764755915069d-01,
     |  -2.3723483450241d-01,-3.7474761086878d-02,-5.0948918950789d-04/
      data (pmn(lat, 5,11), lat = 1,36)/
     |   2.3579907124501d-05, 5.3001000888196d-03, 5.8156346291750d-02,
     |   2.4466243153890d-01, 6.0959125508126d-01, 1.0478428029436d+00,
     |   1.3014528726657d+00, 1.1163991651784d+00, 4.6269458568788d-01,
     |  -3.6857549675161d-01,-9.0951352663805d-01,-8.3037203603426d-01,
     |  -1.9679051640150d-01, 5.4384821276896d-01, 8.6499662519370d-01,
     |   5.4155773099865d-01,-1.7916123376038d-01,-7.5593915612278d-01,
     |  -7.5593915612278d-01,-1.7916123376038d-01, 5.4155773099865d-01,
     |   8.6499662519370d-01, 5.4384821276896d-01,-1.9679051640150d-01,
     |  -8.3037203603426d-01,-9.0951352663805d-01,-3.6857549675161d-01,
     |   4.6269458568788d-01, 1.1163991651784d+00, 1.3014528726657d+00,
     |   1.0478428029436d+00, 6.0959125508126d-01, 2.4466243153890d-01,
     |   5.8156346291751d-02, 5.3001000888196d-03, 2.3579907124501d-05/
      data (pmn(lat, 6,11), lat = 1,36)/
     |   8.6735735386305d-07, 5.9279909281060d-04, 1.1149631653094d-02,
     |   6.8714590116113d-02, 2.3555412611754d-01, 5.4710196805618d-01,
     |   9.3807950865748d-01, 1.2214095164066d+00, 1.1743077475985d+00,
     |   6.9968604955847d-01,-5.2768747268501d-02,-7.2162634648387d-01,
     |  -9.3776944753370d-01,-5.7445164235882d-01, 1.3847276365420d-01,
     |   7.3942461900692d-01, 8.3293773623357d-01, 3.5914485761508d-01,
     |  -3.5914485761508d-01,-8.3293773623357d-01,-7.3942461900693d-01,
     |  -1.3847276365420d-01, 5.7445164235881d-01, 9.3776944753370d-01,
     |   7.2162634648388d-01, 5.2768747268501d-02,-6.9968604955847d-01,
     |  -1.1743077475985d+00,-1.2214095164066d+00,-9.3807950865748d-01,
     |  -5.4710196805618d-01,-2.3555412611754d-01,-6.8714590116113d-02,
     |  -1.1149631653094d-02,-5.9279909281060d-04,-8.6735735386305d-07/
      data (pmn(lat, 7,11), lat = 1,36)/
     |   2.5678253800732d-08, 5.3198654073607d-05, 1.7036826922442d-03,
     |   1.5205138220836d-02, 7.0367603355846d-02, 2.1387365714289d-01,
     |   4.7706635016307d-01, 8.2495218405432d-01, 1.1284480398042d+00,
     |   1.2033688949608d+00, 9.1703372082696d-01, 3.0248516732425d-01,
     |  -4.0799450359630d-01,-8.7995073403783d-01,-8.6563283749286d-01,
     |  -3.6917979775745d-01, 3.2943973729353d-01, 8.2459325403211d-01,
     |   8.2459325403211d-01, 3.2943973729353d-01,-3.6917979775744d-01,
     |  -8.6563283749286d-01,-8.7995073403783d-01,-4.0799450359629d-01,
     |   3.0248516732425d-01, 9.1703372082696d-01, 1.2033688949608d+00,
     |   1.1284480398042d+00, 8.2495218405432d-01, 4.7706635016307d-01,
     |   2.1387365714289d-01, 7.0367603355846d-02, 1.5205138220837d-02,
     |   1.7036826922443d-03, 5.3198654073607d-05, 2.5678253800732d-08/
      data (pmn(lat, 8,11), lat = 1,36)/
     |   6.1110798719883d-10, 3.8299295920752d-06, 2.0793448537069d-04,
     |   2.6680686397770d-03, 1.6482518032935d-02, 6.4419895051471d-02,
     |   1.8174483601953d-01, 3.9735637472733d-01, 6.9975557517865d-01,
     |   1.0094036906071d+00, 1.1874460209211d+00, 1.0947499596996d+00,
     |   6.7941735566635d-01, 3.9792318577172d-02,-5.8899389977837d-01,
     |  -9.3608852120136d-01,-8.3676398354549d-01,-3.3300978662112d-01,
     |   3.3300978662112d-01, 8.3676398354549d-01, 9.3608852120136d-01,
     |   5.8899389977837d-01,-3.9792318577172d-02,-6.7941735566636d-01,
     |  -1.0947499596996d+00,-1.1874460209211d+00,-1.0094036906071d+00,
     |  -6.9975557517865d-01,-3.9735637472733d-01,-1.8174483601953d-01,
     |  -6.4419895051471d-02,-1.6482518032935d-02,-2.6680686397771d-03,
     |  -2.0793448537069d-04,-3.8299295920752d-06,-6.1110798719883d-10/
      data (pmn(lat, 9,11), lat = 1,36)/
     |   1.1484465760641d-11, 2.1742168481378d-07, 1.9952092913852d-05,
     |   3.6628097466946d-04, 2.9985351477074d-03, 1.4908940418523d-02,
     |   5.2356014646280d-02, 1.4120279495353d-01, 3.0736065403618d-01,
     |   5.5621750817675d-01, 8.4999531828289d-01, 1.1001748475487d+00,
     |   1.1897456586462d+00, 1.0243980194529d+00, 5.9063862410459d-01,
     |  -1.3165355054197d-02,-5.9832198135265d-01,-9.5808179442291d-01,
     |  -9.5808179442291d-01,-5.9832198135265d-01,-1.3165355054200d-02,
     |   5.9063862410459d-01, 1.0243980194529d+00, 1.1897456586463d+00,
     |   1.1001748475487d+00, 8.4999531828289d-01, 5.5621750817675d-01,
     |   3.0736065403618d-01, 1.4120279495353d-01, 5.2356014646281d-02,
     |   1.4908940418523d-02, 2.9985351477074d-03, 3.6628097466946d-04,
     |   1.9952092913852d-05, 2.1742168481378d-07, 1.1484465760641d-11/
      data (pmn(lat,10,11), lat = 1,36)/
     |   1.6249498184302d-13, 9.2833161284185d-09, 1.4368350239868d-06,
     |   3.7609315500250d-05, 4.0594746919235d-04, 2.5494283354967d-03,
     |   1.1031950849855d-02, 3.6173940455983d-02, 9.5262556265577d-02,
     |   2.0914624692045d-01, 3.9225777483513d-01, 6.3821400287941d-01,
     |   9.0813983437322d-01, 1.1309697948797d+00, 1.2212222443769d+00,
     |   1.1107332387322d+00, 7.8134208478399d-01, 2.8183956416592d-01,
     |  -2.8183956416592d-01,-7.8134208478399d-01,-1.1107332387322d+00,
     |  -1.2212222443769d+00,-1.1309697948797d+00,-9.0813983437321d-01,
     |  -6.3821400287941d-01,-3.9225777483513d-01,-2.0914624692045d-01,
     |  -9.5262556265577d-02,-3.6173940455983d-02,-1.1031950849855d-02,
     |  -2.5494283354967d-03,-4.0594746919235d-04,-3.7609315500251d-05,
     |  -1.4368350239868d-06,-9.2833161284185d-09,-1.6249498184302d-13/
      data (pmn(lat,11,11), lat = 1,36)/
     |   1.5125917378025d-15, 2.6056789350496d-10, 6.7912669628310d-08,
     |   2.5281706857140d-06, 3.5849476029570d-05, 2.8294898728818d-04,
     |   1.4984018826930d-03, 5.9178636169482d-03, 1.8610727596997d-02,
     |   4.8661587568862d-02, 1.0898826693321d-01, 2.1358347889227d-01,
     |   3.7193299697747d-01, 5.8212379397590d-01, 8.2577373118456d-01,
     |   1.0681769211516d+00, 1.2653211693470d+00, 1.3762505565544d+00,
     |   1.3762505565544d+00, 1.2653211693470d+00, 1.0681769211516d+00,
     |   8.2577373118456d-01, 5.8212379397590d-01, 3.7193299697747d-01,
     |   2.1358347889227d-01, 1.0898826693321d-01, 4.8661587568863d-02,
     |   1.8610727596997d-02, 5.9178636169482d-03, 1.4984018826930d-03,
     |   2.8294898728818d-04, 3.5849476029570d-05, 2.5281706857140d-06,
     |   6.7912669628312d-08, 2.6056789350496d-10, 1.5125917378025d-15/
      data (pmn(lat, 0,12), lat = 1,36)/
     |   3.2778313966561d+00, 1.5381500234437d+00,-5.4880145577473d-01,
     |  -1.4349979645414d+00,-7.3981161307230d-01, 5.4420273763147d-01,
     |   1.0870204775794d+00, 4.6361378653962d-01,-5.6499994916929d-01,
     |  -9.1899901408518d-01,-2.9422247193351d-01, 5.9647063004334d-01,
     |   8.1414130111229d-01, 1.6522531319723d-01,-6.3529037422454d-01,
     |  -7.3953303338013d-01,-5.3436006147602d-02, 6.8199331220689d-01,
     |   6.8199331220689d-01,-5.3436006147601d-02,-7.3953303338013d-01,
     |  -6.3529037422454d-01, 1.6522531319723d-01, 8.1414130111229d-01,
     |   5.9647063004335d-01,-2.9422247193351d-01,-9.1899901408518d-01,
     |  -5.6499994916929d-01, 4.6361378653961d-01, 1.0870204775794d+00,
     |   5.4420273763147d-01,-7.3981161307230d-01,-1.4349979645414d+00,
     |  -5.4880145577474d-01, 1.5381500234437d+00, 3.2778313966561d+00/
      data (pmn(lat, 1,12), lat = 1,36)/
     |   9.2821651205645d-01, 2.0291559409280d+00, 1.5401909708776d+00,
     |   2.4267138504691d-02,-1.1295609005351d+00,-1.0011001267598d+00,
     |   7.4815695967059d-02, 9.3702831058979d-01, 7.6572580750727d-01,
     |  -1.6680718763633d-01,-8.5625549450587d-01,-6.1707414074851d-01,
     |   2.5008365359980d-01, 8.1724429684019d-01, 5.0601920346114d-01,
     |  -3.3053664572612d-01,-8.0078041000858d-01,-4.1372254757215d-01,
     |   4.1372254757215d-01, 8.0078041000858d-01, 3.3053664572612d-01,
     |  -5.0601920346114d-01,-8.1724429684019d-01,-2.5008365359980d-01,
     |   6.1707414074850d-01, 8.5625549450587d-01, 1.6680718763633d-01,
     |  -7.6572580750727d-01,-9.3702831058979d-01,-7.4815695967064d-02,
     |   1.0011001267598d+00, 1.1295609005351d+00,-2.4267138504684d-02,
     |  -1.5401909708776d+00,-2.0291559409280d+00,-9.2821651205645d-01/
      data (pmn(lat, 2,12), lat = 1,36)/
     |   1.2725602326766d-01, 9.3591917590815d-01, 1.6720208441234d+00,
     |   1.4566901925800d+00, 3.0510404241642d-01,-8.5766001747594d-01,
     |  -1.0751295768289d+00,-2.6980695017383d-01, 7.0333302218437d-01,
     |   9.0031318095387d-01, 1.9023720243446d-01,-6.6368827931889d-01,
     |  -7.9842961664259d-01,-1.1173832583456d-01, 6.6511569524926d-01,
     |   7.3250985202361d-01, 3.6791138421476d-02,-6.8931875377148d-01,
     |  -6.8931875377149d-01, 3.6791138421474d-02, 7.3250985202361d-01,
     |   6.6511569524926d-01,-1.1173832583456d-01,-7.9842961664259d-01,
     |  -6.6368827931889d-01, 1.9023720243446d-01, 9.0031318095387d-01,
     |   7.0333302218437d-01,-2.6980695017383d-01,-1.0751295768289d+00,
     |  -8.5766001747594d-01, 3.0510404241642d-01, 1.4566901925799d+00,
     |   1.6720208441234d+00, 9.3591917590815d-01, 1.2725602326766d-01/
      data (pmn(lat, 3,12), lat = 1,36)/
     |   1.1406824557200d-02, 2.6576022407770d-01, 9.0261470096185d-01,
     |   1.4843072487366d+00, 1.3850907077638d+00, 4.7627287428974d-01,
     |  -6.2697955394964d-01,-1.0642781928619d+00,-5.2518645302833d-01,
     |   4.3845563448804d-01, 9.1527207538741d-01, 4.8715651566581d-01,
     |  -3.8914236255511d-01,-8.4318533386391d-01,-4.4423068084940d-01,
     |   3.8795230832124d-01, 8.1296916312416d-01, 4.0937314255865d-01,
     |  -4.0937314255864d-01,-8.1296916312416d-01,-3.8795230832124d-01,
     |   4.4423068084940d-01, 8.4318533386391d-01, 3.8914236255510d-01,
     |  -4.8715651566580d-01,-9.1527207538741d-01,-4.3845563448804d-01,
     |   5.2518645302833d-01, 1.0642781928619d+00, 6.2697955394965d-01,
     |  -4.7627287428974d-01,-1.3850907077638d+00,-1.4843072487366d+00,
     |  -9.0261470096185d-01,-2.6576022407770d-01,-1.1406824557200d-02/
      data (pmn(lat, 4,12), lat = 1,36)/
     |   7.4948277946502d-04, 5.4106148576341d-02, 3.2921677549623d-01,
     |   8.6708237546089d-01, 1.3605568765749d+00, 1.3328014293703d+00,
     |   6.0521914792772d-01,-4.1812660694027d-01,-1.0044064802520d+00,
     |  -7.1799300936376d-01, 1.5699645070289d-01, 8.3255047782674d-01,
     |   7.1360646916511d-01,-6.0586949187121d-02,-7.4886356169284d-01,
     |  -7.0461125903402d-01, 1.5964911981448d-02, 7.1246981573249d-01,
     |   7.1246981573249d-01, 1.5964911981449d-02,-7.0461125903402d-01,
     |  -7.4886356169284d-01,-6.0586949187122d-02, 7.1360646916512d-01,
     |   8.3255047782674d-01, 1.5699645070289d-01,-7.1799300936376d-01,
     |  -1.0044064802520d+00,-4.1812660694027d-01, 6.0521914792771d-01,
     |   1.3328014293703d+00, 1.3605568765749d+00, 8.6708237546089d-01,
     |   3.2921677549624d-01, 5.4106148576341d-02, 7.4948277946502d-04/
      data (pmn(lat, 5,12), lat = 1,36)/
     |   3.8238029508593d-05, 8.4628819982664d-03, 8.9919354301084d-02,
     |   3.5916817121437d-01, 8.2802178713110d-01, 1.2662621448269d+00,
     |   1.2968538465173d+00, 7.2132585212911d-01,-2.1151788349216d-01,
     |  -9.0249609508984d-01,-8.5916709451647d-01,-1.3743321987021d-01,
     |   6.5525737544500d-01, 8.5041488051764d-01, 2.9513551474646d-01,
     |  -5.0635781680885d-01,-8.3509653044902d-01,-3.9990219120455d-01,
     |   3.9990219120454d-01, 8.3509653044902d-01, 5.0635781680885d-01,
     |  -2.9513551474646d-01,-8.5041488051764d-01,-6.5525737544499d-01,
     |   1.3743321987021d-01, 8.5916709451647d-01, 9.0249609508985d-01,
     |   2.1151788349216d-01,-7.2132585212911d-01,-1.2968538465173d+00,
     |  -1.2662621448269d+00,-8.2802178713110d-01,-3.5916817121437d-01,
     |  -8.9919354301085d-02,-8.4628819982664d-03,-3.8238029508593d-05/
      data (pmn(lat, 6,12), lat = 1,36)/
     |   1.5637065808778d-06, 1.0547026880168d-03, 1.9305669182306d-02,
     |   1.1398939715322d-01, 3.6735332884663d-01, 7.8233311559469d-01,
     |   1.1847263512396d+00, 1.2718654072321d+00, 8.3786213099518d-01,
     |   9.2037941650838d-03,-7.5042488936009d-01,-9.4295732707067d-01,
     |  -4.3750273266484d-01, 3.7675754411429d-01, 8.6091380660825d-01,
     |   6.3203189788968d-01,-1.1453094838709d-01,-7.5575737653138d-01,
     |  -7.5575737653138d-01,-1.1453094838709d-01, 6.3203189788968d-01,
     |   8.6091380660825d-01, 3.7675754411429d-01,-4.3750273266485d-01,
     |  -9.4295732707067d-01,-7.5042488936009d-01, 9.2037941650826d-03,
     |   8.3786213099518d-01, 1.2718654072321d+00, 1.1847263512396d+00,
     |   7.8233311559469d-01, 3.6735332884663d-01, 1.1398939715322d-01,
     |   1.9305669182306d-02, 1.0547026880168d-03, 1.5637065808778d-06/
      data (pmn(lat, 7,12), lat = 1,36)/
     |   5.2112597373629d-08, 1.0672700049049d-04, 3.3384325045667d-03,
     |   2.8723722392357d-02, 1.2624344635391d-01, 3.5781491670368d-01,
     |   7.2666190976199d-01, 1.1045591637968d+00, 1.2500306576304d+00,
     |   9.5828633852979d-01, 2.5608798697399d-01,-5.3067671162028d-01,
     |  -9.4485023382837d-01,-7.1865974599295d-01,-5.2024503901496d-03,
     |   6.8982069846928d-01, 8.6100295076962d-01, 3.8333764260939d-01,
     |  -3.8333764260939d-01,-8.6100295076962d-01,-6.8982069846928d-01,
     |   5.2024503901485d-03, 7.1865974599295d-01, 9.4485023382837d-01,
     |   5.3067671162029d-01,-2.5608798697399d-01,-9.5828633852979d-01,
     |  -1.2500306576304d+00,-1.1045591637968d+00,-7.2666190976199d-01,
     |  -3.5781491670368d-01,-1.2624344635391d-01,-2.8723722392357d-02,
     |  -3.3384325045668d-03,-1.0672700049049d-04,-5.2112597373629d-08/
      data (pmn(lat, 8,12), lat = 1,36)/
     |   1.4228445867055d-09, 8.8265608218851d-06, 4.6936018542038d-04,
     |   5.8326407710964d-03, 3.4464072663691d-02, 1.2699529421604d-01,
     |   3.3194141092875d-01, 6.5730469138314d-01, 1.0152447628721d+00,
     |   1.2195237408302d+00, 1.0763390397802d+00, 5.3349322543902d-01,
     |  -2.2147596799802d-01,-8.1901703698578d-01,-9.2150086497114d-01,
     |  -4.6072400931103d-01, 2.8098005427935d-01, 8.3035970097765d-01,
     |   8.3035970097766d-01, 2.8098005427935d-01,-4.6072400931102d-01,
     |  -9.2150086497114d-01,-8.1901703698578d-01,-2.2147596799802d-01,
     |   5.3349322543902d-01, 1.0763390397802d+00, 1.2195237408302d+00,
     |   1.0152447628721d+00, 6.5730469138314d-01, 3.3194141092875d-01,
     |   1.2699529421604d-01, 3.4464072663691d-02, 5.8326407710965d-03,
     |   4.6936018542039d-04, 8.8265608218851d-06, 1.4228445867055d-09/
      data (pmn(lat, 9,12), lat = 1,36)/
     |   3.1642409765692d-11, 5.9357074297309d-07, 5.3466288551421d-05,
     |   9.5395549544706d-04, 7.5092750530432d-03, 3.5475887468308d-02,
     |   1.1675521546584d-01, 2.9025890275297d-01, 5.7029251864439d-01,
     |   9.0527021328502d-01, 1.1624013147242d+00, 1.1723461349849d+00,
     |   8.2964400171199d-01, 1.9188226714063d-01,-5.0154602006680d-01,
     |  -9.3096638372347d-01,-8.7485318593123d-01,-3.5496498505286d-01,
     |   3.5496498505286d-01, 8.7485318593123d-01, 9.3096638372347d-01,
     |   5.0154602006680d-01,-1.9188226714063d-01,-8.2964400171199d-01,
     |  -1.1723461349849d+00,-1.1624013147242d+00,-9.0527021328502d-01,
     |  -5.7029251864439d-01,-2.9025890275297d-01,-1.1675521546584d-01,
     |  -3.5475887468308d-02,-7.5092750530432d-03,-9.5395549544707d-04,
     |  -5.3466288551422d-05,-5.9357074297309d-07,-3.1642409765692d-11/
      data (pmn(lat,10,12), lat = 1,36)/
     |   5.6129503523889d-13, 3.1800346164513d-08, 4.8397122186583d-06,
     |   1.2346686694400d-04, 1.2867298483019d-03, 7.7230957498796d-03,
     |   3.1578914739050d-02, 9.6579158884758d-02, 2.3359064573723d-01,
     |   4.6213124764672d-01, 7.6195404784299d-01, 1.0529316628986d+00,
     |   1.2067639571915d+00, 1.1000759675761d+00, 6.8921776412399d-01,
     |   6.2478813901980d-02,-5.7217893719775d-01,-9.7111041105916d-01,
     |  -9.7111041105916d-01,-5.7217893719775d-01, 6.2478813901978d-02,
     |   6.8921776412399d-01, 1.1000759675761d+00, 1.2067639571915d+00,
     |   1.0529316628986d+00, 7.6195404784299d-01, 4.6213124764672d-01,
     |   2.3359064573723d-01, 9.6579158884758d-02, 3.1578914739051d-02,
     |   7.7230957498796d-03, 1.2867298483019d-03, 1.2346686694400d-04,
     |   4.8397122186584d-06, 3.1800346164513d-08, 5.6129503523889d-13/
      data (pmn(lat,11,12), lat = 1,36)/
     |   7.5557604281550d-15, 1.2916934952724d-09, 3.3151434095487d-07,
     |   1.2055796186751d-05, 1.6560298577487d-04, 1.2548940848071d-03,
     |   6.3186966512660d-03, 2.3474784339469d-02, 6.8606338394064d-02,
     |   1.6437646024278d-01, 3.3173926561723d-01, 5.7379159779085d-01,
     |   8.5869772785349d-01, 1.1138456577004d+00, 1.2415747502274d+00,
     |   1.1559790021582d+00, 8.2578777085142d-01, 3.0015603069052d-01,
     |  -3.0015603069052d-01,-8.2578777085142d-01,-1.1559790021582d+00,
     |  -1.2415747502274d+00,-1.1138456577004d+00,-8.5869772785349d-01,
     |  -5.7379159779085d-01,-3.3173926561723d-01,-1.6437646024278d-01,
     |  -6.8606338394064d-02,-2.3474784339469d-02,-6.3186966512661d-03,
     |  -1.2548940848071d-03,-1.6560298577487d-04,-1.2055796186751d-05,
     |  -3.3151434095488d-07,-1.2916934952724d-09,-7.5557604281550d-15/
      data (pmn(lat,12,12), lat = 1,36)/
     |   6.7338845907807d-17, 3.4712265130123d-11, 1.5002095884627d-08,
     |   7.7591219719407d-07, 1.4001896288712d-05, 1.3334542722776d-04,
     |   8.2169230049758d-04, 3.6768546620231d-03, 1.2832494357425d-02,
     |   3.6616897247097d-02, 8.8249201572254d-02, 1.8384898282941d-01,
     |   3.3671155238296d-01, 5.4890233795292d-01, 8.0379434863287d-01,
     |   1.0643613288140d+00, 1.2803647933540d+00, 1.4032929460387d+00,
     |   1.4032929460387d+00, 1.2803647933540d+00, 1.0643613288140d+00,
     |   8.0379434863287d-01, 5.4890233795292d-01, 3.3671155238296d-01,
     |   1.8384898282941d-01, 8.8249201572254d-02, 3.6616897247097d-02,
     |   1.2832494357425d-02, 3.6768546620232d-03, 8.2169230049759d-04,
     |   1.3334542722776d-04, 1.4001896288712d-05, 7.7591219719408d-07,
     |   1.5002095884627d-08, 3.4712265130123d-11, 6.7338845907807d-17/
      data (pmn(lat, 0,13), lat = 1,36)/
     |   3.3627542533373d+00, 1.3203668595139d+00,-8.8965716106068d-01,
     |  -1.4295580475482d+00,-2.7871200993498d-01, 9.6319570035643d-01,
     |   9.1261309108182d-01,-1.8730954487536d-01,-9.4942394552849d-01,
     |  -5.2242982912856d-01, 4.9212933913393d-01, 8.5268992197142d-01,
     |   1.6919110370168d-01,-6.8816329738384d-01,-6.8038597472450d-01,
     |   1.5586111883522d-01, 7.8545882826217d-01, 4.4360755909424d-01,
     |  -4.4360755909424d-01,-7.8545882826217d-01,-1.5586111883522d-01,
     |   6.8038597472450d-01, 6.8816329738384d-01,-1.6919110370169d-01,
     |  -8.5268992197142d-01,-4.9212933913393d-01, 5.2242982912856d-01,
     |   9.4942394552849d-01, 1.8730954487536d-01,-9.1261309108181d-01,
     |  -9.6319570035643d-01, 2.7871200993498d-01, 1.4295580475482d+00,
     |   8.8965716106069d-01,-1.3203668595139d+00,-3.3627542533373d+00/
      data (pmn(lat, 1,13), lat = 1,36)/
     |   1.0354057673700d+00, 2.1366860463088d+00, 1.3278016481493d+00,
     |  -4.0986045543557d-01,-1.2875866245885d+00,-6.0272431907405d-01,
     |   6.4559946966406d-01, 9.9788306252690d-01, 1.6092525866878d-01,
     |  -7.8695118117532d-01,-7.3527644112219d-01, 1.8477514166619d-01,
     |   8.3428698549758d-01, 4.5377164043656d-01,-4.6035004126291d-01,
     |  -7.9186655194368d-01,-1.5362011686318d-01, 6.6495376156555d-01,
     |   6.6495376156555d-01,-1.5362011686318d-01,-7.9186655194368d-01,
     |  -4.6035004126291d-01, 4.5377164043656d-01, 8.3428698549758d-01,
     |   1.8477514166620d-01,-7.3527644112219d-01,-7.8695118117532d-01,
     |   1.6092525866878d-01, 9.9788306252689d-01, 6.4559946966406d-01,
     |  -6.0272431907405d-01,-1.2875866245885d+00,-4.0986045543558d-01,
     |   1.3278016481493d+00, 2.1366860463088d+00, 1.0354057673700d+00/
      data (pmn(lat, 2,13), lat = 1,36)/
     |   1.5379278760893d-01, 1.0917050976831d+00, 1.7874220799927d+00,
     |   1.2436987633704d+00,-1.8313304325518d-01,-1.1411300147148d+00,
     |  -7.6660216801653d-01, 3.8220938249848d-01, 9.8086370237362d-01,
     |   4.1782778049857d-01,-5.7896142942131d-01,-8.3986612349059d-01,
     |  -1.0538649104827d-01, 7.1999504474166d-01, 6.6251809688642d-01,
     |  -1.8289445665274d-01,-7.9282532030708d-01,-4.4173732671221d-01,
     |   4.4173732671221d-01, 7.9282532030708d-01, 1.8289445665274d-01,
     |  -6.6251809688642d-01,-7.1999504474166d-01, 1.0538649104827d-01,
     |   8.3986612349059d-01, 5.7896142942131d-01,-4.1782778049857d-01,
     |  -9.8086370237362d-01,-3.8220938249848d-01, 7.6660216801652d-01,
     |   1.1411300147148d+00, 1.8313304325518d-01,-1.2436987633704d+00,
     |  -1.7874220799927d+00,-1.0917050976831d+00,-1.5379278760893d-01/
      data (pmn(lat, 3,13), lat = 1,36)/
     |   1.4948157650211d-02, 3.3939944599698d-01, 1.0881417359914d+00,
     |   1.6038058656932d+00, 1.1688312056814d+00,-5.1405133194611d-02,
     |  -1.0157105581942d+00,-8.5897463752403d-01, 1.6000156900882d-01,
     |   9.1128279977673d-01, 6.0963767532308d-01,-3.4818783230177d-01,
     |  -8.6025539023400d-01,-3.6897892176464d-01, 5.2853495433648d-01,
     |   7.8858918308167d-01, 1.2388501215217d-01,-6.7828275114992d-01,
     |  -6.7828275114992d-01, 1.2388501215217d-01, 7.8858918308167d-01,
     |   5.2853495433649d-01,-3.6897892176464d-01,-8.6025539023400d-01,
     |  -3.4818783230178d-01, 6.0963767532308d-01, 9.1128279977673d-01,
     |   1.6000156900882d-01,-8.5897463752402d-01,-1.0157105581942d+00,
     |  -5.1405133194611d-02, 1.1688312056814d+00, 1.6038058656932d+00,
     |   1.0881417359914d+00, 3.3939944599698d-01, 1.4948157650211d-02/
      data (pmn(lat, 4,13), lat = 1,36)/
     |   1.0678224494869d-03, 7.5535594892046d-02, 4.4000072466280d-01,
     |   1.0753006743041d+00, 1.4848736129598d+00, 1.1156510740540d+00,
     |   4.6328499964436d-02,-9.0403740927626d-01,-9.1767062185378d-01,
     |  -4.0870864240224d-02, 8.0435759722145d-01, 7.5248181712825d-01,
     |  -9.8847511709913d-02,-8.0292261601561d-01,-5.9742102689272d-01,
     |   2.6654527787645d-01, 8.1420045081869d-01, 4.3583714190393d-01,
     |  -4.3583714190393d-01,-8.1420045081869d-01,-2.6654527787646d-01,
     |   5.9742102689272d-01, 8.0292261601561d-01, 9.8847511709909d-02,
     |  -7.5248181712825d-01,-8.0435759722145d-01, 4.0870864240222d-02,
     |   9.1767062185378d-01, 9.0403740927626d-01,-4.6328499964430d-02,
     |  -1.1156510740540d+00,-1.4848736129598d+00,-1.0753006743041d+00,
     |  -4.4000072466281d-01,-7.5535594892046d-02,-1.0678224494869d-03/
      data (pmn(lat, 5,13), lat = 1,36)/
     |   5.9484150385762d-05, 1.2945638285411d-02, 1.3278582550487d-01,
     |   5.0065313818512d-01, 1.0558456941398d+00, 1.3997105761327d+00,
     |   1.0861957503292d+00, 1.3940556197816d-01,-7.9336274883224d-01,
     |  -9.5705205905761d-01,-2.3657125219260d-01, 6.5799304608885d-01,
     |   8.4889771520566d-01, 1.6893920636774d-01,-6.5982347004041d-01,
     |  -7.7068445478963d-01,-5.9532950597325d-02, 7.0678917788792d-01,
     |   7.0678917788792d-01,-5.9532950597323d-02,-7.7068445478963d-01,
     |  -6.5982347004041d-01, 1.6893920636774d-01, 8.4889771520567d-01,
     |   6.5799304608885d-01,-2.3657125219260d-01,-9.5705205905761d-01,
     |  -7.9336274883225d-01, 1.3940556197816d-01, 1.0861957503292d+00,
     |   1.3997105761327d+00, 1.0558456941398d+00, 5.0065313818512d-01,
     |   1.3278582550487d-01, 1.2945638285411d-02, 5.9484150385762d-05/
      data (pmn(lat, 6,13), lat = 1,36)/
     |   2.6725517119665d-06, 1.7769481274172d-03, 3.1575312111515d-02,
     |   1.7782272024748d-01, 5.3460185556664d-01, 1.0291546019211d+00,
     |   1.3350979093459d+00, 1.0806612221579d+00, 2.4511697536652d-01,
     |  -6.6912809474813d-01,-9.7763354837655d-01,-4.3683405296837d-01,
     |   4.6048214968332d-01, 8.8567263470866d-01, 4.4801605275618d-01,
     |  -4.1375658921230d-01,-8.4691395578417d-01,-4.2491551927189d-01,
     |   4.2491551927189d-01, 8.4691395578417d-01, 4.1375658921230d-01,
     |  -4.4801605275618d-01,-8.8567263470865d-01,-4.6048214968332d-01,
     |   4.3683405296837d-01, 9.7763354837655d-01, 6.6912809474813d-01,
     |  -2.4511697536652d-01,-1.0806612221579d+00,-1.3350979093459d+00,
     |  -1.0291546019211d+00,-5.3460185556664d-01,-1.7782272024748d-01,
     |  -3.1575312111516d-02,-1.7769481274172d-03,-2.6725517119665d-06/
      data (pmn(lat, 7,13), lat = 1,36)/
     |   9.8723714072794d-08, 1.9967485242259d-04, 6.0877087979907d-03,
     |   5.0313127430344d-02, 2.0878493266292d-01, 5.4656634460955d-01,
     |   9.9362137027597d-01, 1.2830653785814d+00, 1.0979577879823d+00,
     |   3.7538498466461d-01,-5.1430416897245d-01,-9.6785467090021d-01,
     |  -6.4141899617178d-01, 1.9603090827873d-01, 8.3078300688903d-01,
     |   7.1000602327994d-01,-5.1048038886522d-02,-7.5527283987124d-01,
     |  -7.5527283987124d-01,-5.1048038886523d-02, 7.1000602327994d-01,
     |   8.3078300688903d-01, 1.9603090827873d-01,-6.4141899617178d-01,
     |  -9.6785467090021d-01,-5.1430416897245d-01, 3.7538498466461d-01,
     |   1.0979577879823d+00, 1.2830653785814d+00, 9.9362137027597d-01,
     |   5.4656634460955d-01, 2.0878493266292d-01, 5.0313127430344d-02,
     |   6.0877087979908d-03, 1.9967485242259d-04, 9.8723714072794d-08/
      data (pmn(lat, 8,13), lat = 1,36)/
     |   3.0261911851957d-09, 1.8565868450879d-05, 9.6518605035957d-04,
     |   1.1580710042007d-02, 6.5142733083098d-02, 2.2468626242847d-01,
     |   5.3793740335458d-01, 9.4638728898719d-01, 1.2360552869688d+00,
     |   1.1343375909815d+00, 5.3831434866833d-01,-3.0856110095042d-01,
     |  -9.0183926141865d-01,-8.3230840592783d-01,-1.4554772507125d-01,
     |   6.3245570011282d-01, 8.8434363101047d-01, 4.0677208105085d-01,
     |  -4.0677208105084d-01,-8.8434363101047d-01,-6.3245570011282d-01,
     |   1.4554772507125d-01, 8.3230840592783d-01, 9.0183926141865d-01,
     |   3.0856110095042d-01,-5.3831434866833d-01,-1.1343375909815d+00,
     |  -1.2360552869688d+00,-9.4638728898719d-01,-5.3793740335458d-01,
     |  -2.2468626242847d-01,-6.5142733083098d-02,-1.1580710042007d-02,
     |  -9.6518605035958d-04,-1.8565868450879d-05,-3.0261911851957d-09/
      data (pmn(lat, 9,13), lat = 1,36)/
     |   7.7023810200873d-11, 1.4305453981884d-06, 1.2627706414615d-04,
     |   2.1839691537776d-03, 1.6465389174927d-02, 7.3483429144415d-02,
     |   2.2472246681242d-01, 5.0832157790550d-01, 8.8272869667461d-01,
     |   1.1839313105548d+00, 1.1805831009386d+00, 7.3597206322572d-01,
     |  -2.9707462482734d-02,-7.3573906040680d-01,-9.5916167032476d-01,
     |  -5.4599129343723d-01, 2.3224723776488d-01, 8.3543130457085d-01,
     |   8.3543130457085d-01, 2.3224723776488d-01,-5.4599129343723d-01,
     |  -9.5916167032476d-01,-7.3573906040680d-01,-2.9707462482730d-02,
     |   7.3597206322572d-01, 1.1805831009386d+00, 1.1839313105548d+00,
     |   8.8272869667462d-01, 5.0832157790550d-01, 2.2472246681242d-01,
     |   7.3483429144415d-02, 1.6465389174927d-02, 2.1839691537776d-03,
     |   1.2627706414616d-04, 1.4305453981884d-06, 7.7023810200873d-11/
      data (pmn(lat,10,13), lat = 1,36)/
     |   1.6133089564940d-12, 9.0579557941530d-08, 1.3535274227347d-05,
     |   3.3575640453758d-04, 3.3669486441617d-03, 1.9220542923660d-02,
     |   7.3756759671023d-02, 2.0835206235190d-01, 4.5623691277133d-01,
     |   7.9555380127442d-01, 1.1114016804609d+00, 1.2172865673883d+00,
     |   9.5710252280273d-01, 3.3818623947490d-01,-4.0838463527826d-01,
     |  -9.1871781792021d-01,-9.0961363920777d-01,-3.7633709895030d-01,
     |   3.7633709895030d-01, 9.0961363920777d-01, 9.1871781792021d-01,
     |   4.0838463527826d-01,-3.3818623947490d-01,-9.5710252280273d-01,
     |  -1.2172865673883d+00,-1.1114016804609d+00,-7.9555380127442d-01,
     |  -4.5623691277133d-01,-2.0835206235190d-01,-7.3756759671023d-02,
     |  -1.9220542923660d-02,-3.3669486441617d-03,-3.3575640453758d-04,
     |  -1.3535274227347d-05,-9.0579557941530d-08,-1.6133089564940d-12/
      data (pmn(lat,11,13), lat = 1,36)/
     |   2.7172690015824d-14, 4.6069848737132d-09, 1.1627759754434d-06,
     |   4.1220686403478d-05, 5.4685242702841d-04, 3.9619306884658d-03,
     |   1.8860453729346d-02, 6.5400846918542d-02, 1.7572407352526d-01,
     |   3.7994553520790d-01, 6.7557156003302d-01, 9.9592989370226d-01,
     |   1.2079345711085d+00, 1.1618457023196d+00, 7.8072743127951d-01,
     |   1.3711599269010d-01,-5.4478987709353d-01,-9.8309058426803d-01,
     |  -9.8309058426803d-01,-5.4478987709353d-01, 1.3711599269009d-01,
     |   7.8072743127951d-01, 1.1618457023196d+00, 1.2079345711085d+00,
     |   9.9592989370226d-01, 6.7557156003302d-01, 3.7994553520790d-01,
     |   1.7572407352526d-01, 6.5400846918542d-02, 1.8860453729346d-02,
     |   3.9619306884658d-03, 5.4685242702841d-04, 4.1220686403478d-05,
     |   1.1627759754434d-06, 4.6069848737132d-09, 2.7172690015824d-14/
      data (pmn(lat,12,13), lat = 1,36)/
     |   3.4956987727050d-16, 1.7882712831265d-10, 7.6105375326920d-08,
     |   3.8451559871702d-06, 6.7217767555443d-05, 6.1459487325684d-04,
     |   3.6009765352808d-03, 1.5157410069155d-02, 4.9161355433779d-02,
     |   1.2854250807640d-01, 2.7915139002226d-01, 5.1328625831172d-01,
     |   8.0787747405716d-01, 1.0914821137048d+00, 1.2559392545980d+00,
     |   1.1970374003073d+00, 8.6838692236355d-01, 3.1806053551973d-01,
     |  -3.1806053551973d-01,-8.6838692236355d-01,-1.1970374003073d+00,
     |  -1.2559392545980d+00,-1.0914821137048d+00,-8.0787747405716d-01,
     |  -5.1328625831172d-01,-2.7915139002226d-01,-1.2854250807641d-01,
     |  -4.9161355433779d-02,-1.5157410069155d-02,-3.6009765352809d-03,
     |  -6.1459487325684d-04,-6.7217767555443d-05,-3.8451559871703d-06,
     |  -7.6105375326922d-08,-1.7882712831265d-10,-3.4956987727050d-16/
      data (pmn(lat,13,13), lat = 1,36)/
     |   2.9932324073983d-18, 4.6171696374140d-12, 3.3089019297609d-09,
     |   2.3776591216677d-07, 5.4603656408227d-06, 6.2744972754597d-05,
     |   4.4990513458079d-04, 2.2809659352984d-03, 8.8346558433116d-03,
     |   2.7511079618070d-02, 7.1346495805930d-02, 1.5801038502730d-01,
     |   3.0435619716876d-01, 5.1677992503644d-01, 7.8119536537337d-01,
     |   1.0589264791738d+00, 1.2935925268370d+00, 1.4286636707965d+00,
     |   1.4286636707965d+00, 1.2935925268370d+00, 1.0589264791738d+00,
     |   7.8119536537337d-01, 5.1677992503644d-01, 3.0435619716876d-01,
     |   1.5801038502730d-01, 7.1346495805930d-02, 2.7511079618071d-02,
     |   8.8346558433116d-03, 2.2809659352984d-03, 4.4990513458079d-04,
     |   6.2744972754597d-05, 5.4603656408227d-06, 2.3776591216677d-07,
     |   3.3089019297610d-09, 4.6171696374140d-12, 2.9932324073983d-18/
      data (pmn(lat, 0,14), lat = 1,36)/
     |   3.4366549483639d+00, 1.0781646403464d+00,-1.1871717932489d+00,
     |  -1.2899035210961d+00, 2.2522300129827d-01, 1.1633816766626d+00,
     |   4.5126669553201d-01,-7.6067679316570d-01,-8.3402678914896d-01,
     |   2.1364616429015d-01, 8.9304896138407d-01, 3.1918386953132d-01,
     |  -6.5807653695079d-01,-6.9160354627869d-01, 2.2642422702912d-01,
     |   8.0703449040749d-01, 2.5835654772568d-01,-6.4338780875167d-01,
     |  -6.4338780875167d-01, 2.5835654772568d-01, 8.0703449040749d-01,
     |   2.2642422702912d-01,-6.9160354627869d-01,-6.5807653695079d-01,
     |   3.1918386953132d-01, 8.9304896138407d-01, 2.1364616429015d-01,
     |  -8.3402678914896d-01,-7.6067679316570d-01, 4.5126669553201d-01,
     |   1.1633816766626d+00, 2.2522300129827d-01,-1.2899035210961d+00,
     |  -1.1871717932490d+00, 1.0781646403464d+00, 3.4366549483639d+00/
      data (pmn(lat, 1,14), lat = 1,36)/
     |   1.1448844393893d+00, 2.2164212104079d+00, 1.0579189915227d+00,
     |  -8.0754338169455d-01,-1.2545074650492d+00,-7.0508221276103d-02,
     |   1.0162856623830d+00, 6.4964974922883d-01,-5.2774117610443d-01,
     |  -8.9860003962275d-01,-4.0943800105931d-02, 8.1582494326617d-01,
     |   5.2193525945699d-01,-4.6902377354799d-01,-7.8325524753743d-01,
     |  -1.3006219739837d-02, 7.6035403336792d-01, 4.7171643030123d-01,
     |  -4.7171643030123d-01,-7.6035403336792d-01, 1.3006219739832d-02,
     |   7.8325524753743d-01, 4.6902377354799d-01,-5.2193525945699d-01,
     |  -8.1582494326618d-01, 4.0943800105931d-02, 8.9860003962275d-01,
     |   5.2774117610443d-01,-6.4964974922883d-01,-1.0162856623830d+00,
     |   7.0508221276103d-02, 1.2545074650492d+00, 8.0754338169456d-01,
     |  -1.0579189915227d+00,-2.2164212104079d+00,-1.1448844393893d+00/
      data (pmn(lat, 2,14), lat = 1,36)/
     |   1.8322218673083d-01, 1.2513128834212d+00, 1.8546180637434d+00,
     |   9.4091555420768d-01,-6.4630125354140d-01,-1.1877443234862d+00,
     |  -2.3220983069944d-01, 8.8173299265594d-01, 7.5816003704393d-01,
     |  -3.2885799932603d-01,-9.0168898764029d-01,-2.4864006998928d-01,
     |   6.9891112702823d-01, 6.6797937374552d-01,-2.6175731197452d-01,
     |  -8.1130503858617d-01,-2.4571395482336d-01, 6.4932971294281d-01,
     |   6.4932971294281d-01,-2.4571395482336d-01,-8.1130503858617d-01,
     |  -2.6175731197452d-01, 6.6797937374552d-01, 6.9891112702823d-01,
     |  -2.4864006998928d-01,-9.0168898764029d-01,-3.2885799932603d-01,
     |   7.5816003704393d-01, 8.8173299265594d-01,-2.3220983069944d-01,
     |  -1.1877443234862d+00,-6.4630125354140d-01, 9.4091555420767d-01,
     |   1.8546180637434d+00, 1.2513128834212d+00, 1.8322218673083d-01/
      data (pmn(lat, 3,14), lat = 1,36)/
     |   1.9194607392874d-02, 4.2379327148407d-01, 1.2746078316096d+00,
     |   1.6511660125262d+00, 8.2977285809284d-01,-5.6778965999927d-01,
     |  -1.1282802953685d+00,-3.3417647065321d-01, 7.6460455818705d-01,
     |   8.2297420237143d-01,-1.5242477880482d-01,-8.6814560700330d-01,
     |  -4.2513462163469d-01, 5.5108733515132d-01, 7.6778342617544d-01,
     |  -3.7238321713483d-02,-7.7683178888189d-01,-4.6837896539575d-01,
     |   4.6837896539575d-01, 7.7683178888189d-01, 3.7238321713487d-02,
     |  -7.6778342617544d-01,-5.5108733515132d-01, 4.2513462163470d-01,
     |   8.6814560700330d-01, 1.5242477880482d-01,-8.2297420237143d-01,
     |  -7.6460455818706d-01, 3.3417647065320d-01, 1.1282802953685d+00,
     |   5.6778965999927d-01,-8.2977285809284d-01,-1.6511660125262d+00,
     |  -1.2746078316097d+00,-4.2379327148407d-01,-1.9194607392874d-02/
      data (pmn(lat, 4,14), lat = 1,36)/
     |   1.4807826620458d-03, 1.0246810982375d-01, 5.6903711669721d-01,
     |   1.2779261657837d+00, 1.5102088105631d+00, 7.4052422047523d-01,
     |  -5.1947435231921d-01,-1.0806937971896d+00,-4.1376392883953d-01,
     |   6.5536004376855d-01, 8.6537722063636d-01, 1.6549495175006d-02,
     |  -8.0378901848318d-01,-5.8069100249443d-01, 3.6891749689938d-01,
     |   8.1998562610543d-01, 2.0580024753640d-01,-6.6781447017358d-01,
     |  -6.6781447017358d-01, 2.0580024753640d-01, 8.1998562610543d-01,
     |   3.6891749689938d-01,-5.8069100249443d-01,-8.0378901848318d-01,
     |   1.6549495175000d-02, 8.6537722063636d-01, 6.5536004376855d-01,
     |  -4.1376392883952d-01,-1.0806937971896d+00,-5.1947435231922d-01,
     |   7.4052422047523d-01, 1.5102088105631d+00, 1.2779261657837d+00,
     |   5.6903711669722d-01, 1.0246810982375d-01, 1.4807826620458d-03/
      data (pmn(lat, 5,14), lat = 1,36)/
     |   8.9373182155065d-05, 1.9100383293956d-02, 1.8853404781820d-01,
     |   6.6675232982767d-01, 1.2689880877811d+00, 1.4052314667428d+00,
     |   6.7853937669234d-01,-4.7626216206032d-01,-1.0426031430648d+00,
     |  -4.9158697285378d-01, 5.4098946235680d-01, 8.9235298435251d-01,
     |   1.9114599828623d-01,-7.0216864796568d-01,-7.1627115549394d-01,
     |   1.4351959737627d-01, 8.0874243331140d-01, 4.6121550215615d-01,
     |  -4.6121550215615d-01,-8.0874243331140d-01,-1.4351959737628d-01,
     |   7.1627115549394d-01, 7.0216864796568d-01,-1.9114599828624d-01,
     |  -8.9235298435251d-01,-5.4098946235680d-01, 4.9158697285378d-01,
     |   1.0426031430648d+00, 4.7626216206032d-01,-6.7853937669234d-01,
     |  -1.4052314667428d+00,-1.2689880877811d+00,-6.6675232982767d-01,
     |  -1.8853404781820d-01,-1.9100383293956d-02,-8.9373182155065d-05/
      data (pmn(lat, 6,14), lat = 1,36)/
     |   4.3710432531920d-06, 2.8616250070919d-03, 4.9237171050378d-02,
     |   2.6323630753132d-01, 7.3188671276832d-01, 1.2512159387583d+00,
     |   1.3275829646845d+00, 6.4768205743067d-01,-4.2296526930321d-01,
     |  -1.0090688662249d+00,-5.7968151607134d-01, 4.0672559237403d-01,
     |   8.9998084615433d-01, 3.7981815765842d-01,-5.4735746818493d-01,
     |  -8.1873976026605d-01,-1.3207939491415d-01, 7.0112345614102d-01,
     |   7.0112345614102d-01,-1.3207939491415d-01,-8.1873976026605d-01,
     |  -5.4735746818493d-01, 3.7981815765842d-01, 8.9998084615434d-01,
     |   4.0672559237404d-01,-5.7968151607134d-01,-1.0090688662249d+00,
     |  -4.2296526930321d-01, 6.4768205743067d-01, 1.3275829646845d+00,
     |   1.2512159387583d+00, 7.3188671276832d-01, 2.6323630753132d-01,
     |   4.9237171050378d-02, 2.8616250070919d-03, 4.3710432531920d-06/
      data (pmn(lat, 7,14), lat = 1,36)/
     |   1.7691916707653d-07, 3.5303575345484d-04, 1.0468296617979d-02,
     |   8.2793441764520d-02, 3.2233261365954d-01, 7.7071460087403d-01,
     |   1.2269502588528d+00, 1.2744404131350d+00, 6.5185156090187d-01,
     |  -3.4721060344283d-01,-9.7178695494705d-01,-6.8378127281576d-01,
     |   2.3589215825347d-01, 8.7246901882316d-01, 5.8163198878346d-01,
     |  -3.1660272068617d-01,-8.5322664833648d-01,-4.4906246270063d-01,
     |   4.4906246270063d-01, 8.5322664833648d-01, 3.1660272068617d-01,
     |  -5.8163198878346d-01,-8.7246901882316d-01,-2.3589215825347d-01,
     |   6.8378127281575d-01, 9.7178695494705d-01, 3.4721060344283d-01,
     |  -6.5185156090187d-01,-1.2744404131350d+00,-1.2269502588528d+00,
     |  -7.7071460087403d-01,-3.2233261365954d-01,-8.2793441764521d-02,
     |  -1.0468296617979d-02,-3.5303575345484d-04,-1.7691916707653d-07/
      data (pmn(lat, 8,14), lat = 1,36)/
     |   5.9966058434868d-09, 3.6352251170758d-05, 1.8441586847156d-03,
     |   2.1297013804495d-02, 1.1347443719603d-01, 3.6340951751683d-01,
     |   7.8612251466658d-01, 1.1972469737240d+00, 1.2443077076750d+00,
     |   6.9500528259981d-01,-2.3578104438414d-01,-9.1625295852566d-01,
     |  -8.0146486423911d-01, 1.0994086072380d-02, 7.7858564051137d-01,
     |   7.7596176815429d-01, 1.1227752992906d-02,-7.5441867114017d-01,
     |  -7.5441867114017d-01, 1.1227752992905d-02, 7.7596176815429d-01,
     |   7.7858564051137d-01, 1.0994086072381d-02,-8.0146486423912d-01,
     |  -9.1625295852566d-01,-2.3578104438414d-01, 6.9500528259981d-01,
     |   1.2443077076750d+00, 1.1972469737240d+00, 7.8612251466658d-01,
     |   3.6340951751683d-01, 1.1347443719603d-01, 2.1297013804495d-02,
     |   1.8441586847156d-03, 3.6352251170758d-05, 5.9966058434868d-09/
      data (pmn(lat, 9,14), lat = 1,36)/
     |   1.7097862560342d-10, 3.1416214446524d-06, 2.7131686727911d-04,
     |   4.5362081731220d-03, 3.2618606352309d-02, 1.3665513373074d-01,
     |   3.8454581461160d-01, 7.7882588179315d-01, 1.1609021266421d+00,
     |   1.2341900571858d+00, 7.8016132413463d-01,-7.2695412759403d-02,
     |  -8.1744495398882d-01,-9.1545773621708d-01,-2.8006930727655d-01,
     |   5.6875528306760d-01, 9.0334618109794d-01, 4.2951855201612d-01,
     |  -4.2951855201612d-01,-9.0334618109794d-01,-5.6875528306760d-01,
     |   2.8006930727655d-01, 9.1545773621708d-01, 8.1744495398882d-01,
     |   7.2695412759407d-02,-7.8016132413463d-01,-1.2341900571858d+00,
     |  -1.1609021266421d+00,-7.7882588179315d-01,-3.8454581461161d-01,
     |  -1.3665513373074d-01,-3.2618606352309d-02,-4.5362081731220d-03,
     |  -2.7131686727912d-04,-3.1416214446524d-06,-1.7097862560342d-10/
      data (pmn(lat,10,14), lat = 1,36)/
     |   4.0905698155677d-12, 2.2743753493170d-07, 3.3320162713666d-05,
     |   8.0177380320556d-04, 7.7088539457061d-03, 4.1638055363137d-02,
     |   1.4881985041791d-01, 3.8388726484391d-01, 7.4736164332742d-01,
     |   1.1129922643355d+00, 1.2365109889510d+00, 9.0647331094898d-01,
     |   1.6025010998917d-01,-6.3487082605258d-01,-9.8004084631581d-01,
     |  -6.2493926253169d-01, 1.8337786128484d-01, 8.3983852131624d-01,
     |   8.3983852131625d-01, 1.8337786128484d-01,-6.2493926253169d-01,
     |  -9.8004084631581d-01,-6.3487082605258d-01, 1.6025010998917d-01,
     |   9.0647331094897d-01, 1.2365109889510d+00, 1.1129922643355d+00,
     |   7.4736164332742d-01, 3.8388726484391d-01, 1.4881985041791d-01,
     |   4.1638055363137d-02, 7.7088539457061d-03, 8.0177380320557d-04,
     |   3.3320162713667d-05, 2.2743753493170d-07, 4.0905698155677d-12/
      data (pmn(lat,11,14), lat = 1,36)/
     |   8.1203842062315d-14, 1.3645317934812d-08, 3.3823457110625d-06,
     |   1.1663616991910d-04, 1.4897465050720d-03, 1.0273721622425d-02,
     |   4.5951911465596d-02, 1.4742224005647d-01, 3.5949966583749d-01,
     |   6.8775154736322d-01, 1.0429925940660d+00, 1.2346082120335d+00,
     |   1.0623079358522d+00, 4.7688949212544d-01,-3.1121082927020d-01,
     |  -9.0013159443130d-01,-9.4128185436621d-01,-3.9717771614925d-01,
     |   3.9717771614925d-01, 9.4128185436621d-01, 9.0013159443130d-01,
     |   3.1121082927020d-01,-4.7688949212544d-01,-1.0623079358522d+00,
     |  -1.2346082120335d+00,-1.0429925940660d+00,-6.8775154736322d-01,
     |  -3.5949966583749d-01,-1.4742224005647d-01,-4.5951911465596d-02,
     |  -1.0273721622425d-02,-1.4897465050720d-03,-1.1663616991911d-04,
     |  -3.3823457110626d-06,-1.3645317934812d-08,-8.1203842062315d-14/
      data (pmn(lat,12,14), lat = 1,36)/
     |   1.3049005169910d-15, 6.6206579558778d-10, 2.7711746809061d-07,
     |   1.3650812787476d-05, 2.3052224224506d-04, 2.0158414782188d-03,
     |   1.1171345785033d-02, 4.3916976490917d-02, 1.3106497066279d-01,
     |   3.0963897463296d-01, 5.9352265476689d-01, 9.3288018994021d-01,
     |   1.1960869702844d+00, 1.2109089592670d+00, 8.6524893875747d-01,
     |   2.1051254782588d-01,-5.1632568376895d-01,-9.9412684797683d-01,
     |  -9.9412684797683d-01,-5.1632568376895d-01, 2.1051254782588d-01,
     |   8.6524893875747d-01, 1.2109089592670d+00, 1.1960869702844d+00,
     |   9.3288018994021d-01, 5.9352265476689d-01, 3.0963897463296d-01,
     |   1.3106497066279d-01, 4.3916976490917d-02, 1.1171345785033d-02,
     |   2.0158414782188d-03, 2.3052224224506d-04, 1.3650812787476d-05,
     |   2.7711746809062d-07, 6.6206579558778d-10, 1.3049005169910d-15/
      data (pmn(lat,13,14), lat = 1,36)/
     |   1.6103708056156d-17, 2.4651502595831d-11, 1.7396601194678d-08,
     |   1.2211474071975d-06, 2.7166648905177d-05, 2.9971388138853d-04,
     |   2.0433800097391d-03, 9.7450585546425d-03, 3.5076763885049d-02,
     |   1.0008983625201d-01, 2.3389383475083d-01, 4.5719466532300d-01,
     |   7.5680980121413d-01, 1.0649869696877d+00, 1.2650289405201d+00,
     |   1.2342455152143d+00, 9.0927272849122d-01, 3.3558965283144d-01,
     |  -3.3558965283144d-01,-9.0927272849122d-01,-1.2342455152143d+00,
     |  -1.2650289405201d+00,-1.0649869696877d+00,-7.5680980121413d-01,
     |  -4.5719466532300d-01,-2.3389383475083d-01,-1.0008983625201d-01,
     |  -3.5076763885049d-02,-9.7450585546425d-03,-2.0433800097391d-03,
     |  -2.9971388138853d-04,-2.7166648905177d-05,-1.2211474071975d-06,
     |  -1.7396601194679d-08,-2.4651502595831d-11,-1.6103708056156d-17/
      data (pmn(lat,14,14), lat = 1,36)/
     |   1.3287399218414d-19, 6.1332897624407d-13, 7.2885414756462d-10,
     |   7.2763131009684d-08, 2.1265782565604d-06, 2.9485229883731d-05,
     |   2.4601266005033d-04, 1.4131423458321d-03, 6.0742542386921d-03,
     |   2.0642319766725d-02, 5.7604881215339d-02, 1.3562345581978d-01,
     |   2.7474579632051d-01, 4.8589335951915d-01, 7.5822682120832d-01,
     |   1.0521249139708d+00, 1.3052269950963d+00, 1.4525678768043d+00,
     |   1.4525678768043d+00, 1.3052269950963d+00, 1.0521249139708d+00,
     |   7.5822682120832d-01, 4.8589335951915d-01, 2.7474579632051d-01,
     |   1.3562345581978d-01, 5.7604881215339d-02, 2.0642319766725d-02,
     |   6.0742542386922d-03, 1.4131423458321d-03, 2.4601266005034d-04,
     |   2.9485229883731d-05, 2.1265782565604d-06, 7.2763131009685d-08,
     |   7.2885414756465d-10, 6.1332897624407d-13, 1.3287399218414d-19/
      data (pmn(lat, 0,15), lat = 1,36)/
     |   3.4999210854583d+00, 8.1621801546612d-01,-1.4270436119321d+00,
     |  -1.0293627320311d+00, 6.9466152749273d-01, 1.0994424182282d+00,
     |  -1.5192225887377d-01,-1.0189752630347d+00,-2.7963259349258d-01,
     |   8.1098691937448d-01, 5.9453345425117d-01,-5.0995596873639d-01,
     |  -7.7659916235429d-01, 1.5918365035382d-01, 8.1654045436238d-01,
     |   1.9328038427060d-01,-7.1811635923180d-01,-4.9974124152311d-01,
     |   4.9974124152311d-01, 7.1811635923180d-01,-1.9328038427059d-01,
     |  -8.1654045436238d-01,-1.5918365035382d-01, 7.7659916235429d-01,
     |   5.0995596873640d-01,-5.9453345425117d-01,-8.1098691937448d-01,
     |   2.7963259349258d-01, 1.0189752630347d+00, 1.5192225887377d-01,
     |  -1.0994424182282d+00,-6.9466152749273d-01, 1.0293627320311d+00,
     |   1.4270436119322d+00,-8.1621801546612d-01,-3.4999210854583d+00/
      data (pmn(lat, 1,15), lat = 1,36)/
     |   1.2562670574075d+00, 2.2661142075101d+00, 7.4166716993177d-01,
     |  -1.1331533642213d+00,-1.0346376812237d+00, 4.7728247559058d-01,
     |   1.0716813828666d+00, 3.4892289745634d-02,-9.4037023280956d-01,
     |  -4.2944574745305d-01, 6.8516066122789d-01, 6.9342197407891d-01,
     |  -3.5126802393280d-01,-8.1323479979242d-01,-1.1610881756186d-02,
     |   7.8603059219863d-01, 3.5240626491908d-01,-6.2356802339646d-01,
     |  -6.2356802339646d-01, 3.5240626491908d-01, 7.8603059219863d-01,
     |  -1.1610881756184d-02,-8.1323479979242d-01,-3.5126802393280d-01,
     |   6.9342197407890d-01, 6.8516066122789d-01,-4.2944574745305d-01,
     |  -9.4037023280956d-01, 3.4892289745631d-02, 1.0716813828666d+00,
     |   4.7728247559058d-01,-1.0346376812237d+00,-1.1331533642213d+00,
     |   7.4166716993176d-01, 2.2661142075101d+00, 1.2562670574075d+00/
      data (pmn(lat, 2,15), lat = 1,36)/
     |   2.1558918715089d-01, 1.4118458861874d+00, 1.8667329542839d+00,
     |   5.6776243440451d-01,-1.0213955281854d+00,-9.8519099984927d-01,
     |   3.7064127730682d-01, 1.0291428057502d+00, 1.4776331854429d-01,
     |  -8.6540281492721d-01,-5.2886864897767d-01, 5.6936406151626d-01,
     |   7.5614943782205d-01,-2.0352094864086d-01,-8.2043872048958d-01,
     |  -1.7149974884455d-01, 7.2714204623130d-01, 4.9830705893687d-01,
     |  -4.9830705893687d-01,-7.2714204623130d-01, 1.7149974884455d-01,
     |   8.2043872048958d-01, 2.0352094864086d-01,-7.5614943782206d-01,
     |  -5.6936406151627d-01, 5.2886864897767d-01, 8.6540281492721d-01,
     |  -1.4776331854429d-01,-1.0291428057502d+00,-3.7064127730682d-01,
     |   9.8519099984927d-01, 1.0213955281854d+00,-5.6776243440450d-01,
     |  -1.8667329542839d+00,-1.4118458861874d+00,-2.1558918715089d-01/
      data (pmn(lat, 3,15), lat = 1,36)/
     |   2.4218548926630d-02, 5.1880755265532d-01, 1.4538264961400d+00,
     |   1.6136624013682d+00, 3.9864820922217d-01,-9.7621987801171d-01,
     |  -9.2867096170990d-01, 3.1552000832122d-01, 9.9053990015214d-01,
     |   2.2574170035280d-01,-7.9710779579608d-01,-6.0447526717337d-01,
     |   4.5718626554955d-01, 7.9811232088260d-01,-5.5932934939218d-02,
     |  -8.0266226688761d-01,-3.3037324037967d-01, 6.3456416323994d-01,
     |   6.3456416323994d-01,-3.3037324037967d-01,-8.0266226688761d-01,
     |  -5.5932934939219d-02, 7.9811232088260d-01, 4.5718626554954d-01,
     |  -6.0447526717337d-01,-7.9710779579608d-01, 2.2574170035280d-01,
     |   9.9053990015214d-01, 3.1552000832123d-01,-9.2867096170989d-01,
     |  -9.7621987801171d-01, 3.9864820922217d-01, 1.6136624013682d+00,
     |   1.4538264961400d+00, 5.1880755265532d-01, 2.4218548926630d-02/
      data (pmn(lat, 4,15), lat = 1,36)/
     |   2.0063607279206d-03, 1.3558697589695d-01, 7.1466480786864d-01,
     |   1.4584561225917d+00, 1.4171753600246d+00, 2.5290082884304d-01,
     |  -9.5472622128947d-01,-8.7920442344148d-01, 2.7984478231824d-01,
     |   9.5891125754405d-01, 2.9274024334142d-01,-7.2982757245678d-01,
     |  -6.7146410083611d-01, 3.3754419351654d-01, 8.2415619330965d-01,
     |   1.0303312399094d-01,-7.5393052123569d-01,-4.9381203637977d-01,
     |   4.9381203637977d-01, 7.5393052123569d-01,-1.0303312399094d-01,
     |  -8.2415619330965d-01,-3.3754419351654d-01, 6.7146410083612d-01,
     |   7.2982757245678d-01,-2.9274024334142d-01,-9.5891125754405d-01,
     |  -2.7984478231825d-01, 8.7920442344148d-01, 9.5472622128948d-01,
     |  -2.5290082884304d-01,-1.4171753600246d+00,-1.4584561225917d+00,
     |  -7.1466480786864d-01,-1.3558697589695d-01,-2.0063607279206d-03/
      data (pmn(lat, 5,15), lat = 1,36)/
     |   1.3036708963857d-04, 2.7322649635358d-02, 2.5868093530072d-01,
     |   8.5214055122610d-01, 1.4395148590967d+00, 1.2558415684301d+00,
     |   1.3710961065926d-01,-9.3920488861415d-01,-8.4367001488298d-01,
     |   2.4411545267639d-01, 9.3262631172730d-01, 3.6459143108988d-01,
     |  -6.5395349996527d-01,-7.3708307045794d-01, 1.9709642335003d-01,
     |   8.2944581483369d-01, 2.8279123405980d-01,-6.5762743216967d-01,
     |  -6.5762743216967d-01, 2.8279123405980d-01, 8.2944581483369d-01,
     |   1.9709642335003d-01,-7.3708307045794d-01,-6.5395349996527d-01,
     |   3.6459143108988d-01, 9.3262631172730d-01, 2.4411545267639d-01,
     |  -8.4367001488298d-01,-9.3920488861415d-01, 1.3710961065926d-01,
     |   1.2558415684301d+00, 1.4395148590967d+00, 8.5214055122610d-01,
     |   2.5868093530072d-01, 2.7322649635358d-02, 1.3036708963857d-04/
      data (pmn(lat, 6,15), lat = 1,36)/
     |   6.8891848533959d-06, 4.4358402569584d-03, 7.3709408766234d-02,
     |   3.7222448537982d-01, 9.4765705697165d-01, 1.4058958607554d+00,
     |   1.1257086462461d+00, 5.5257180362450d-02,-9.2177656615016d-01,
     |  -8.2711578419205d-01, 1.9420196828814d-01, 9.0728411030875d-01,
     |   4.5234871507252d-01,-5.5617127754841d-01,-8.0066714125085d-01,
     |   2.1434050740447d-02, 7.9736374996690d-01, 4.8561913334830d-01,
     |  -4.8561913334830d-01,-7.9736374996690d-01,-2.1434050740451d-02,
     |   8.0066714125085d-01, 5.5617127754841d-01,-4.5234871507252d-01,
     |  -9.0728411030875d-01,-1.9420196828814d-01, 8.2711578419205d-01,
     |   9.2177656615016d-01,-5.5257180362448d-02,-1.1257086462461d+00,
     |  -1.4058958607554d+00,-9.4765705697165d-01,-3.7222448537983d-01,
     |  -7.3709408766234d-02,-4.4358402569584d-03,-6.8891848533959d-06/
      data (pmn(lat, 7,15), lat = 1,36)/
     |   3.0279370993418d-07, 5.9552737334987d-04, 1.7136859851325d-02,
     |   1.2918919787907d-01, 4.6858717974109d-01, 1.0098277904484d+00,
     |   1.3657066859339d+00, 1.0286595288286d+00, 1.0988990481664d-02,
     |  -8.9775358746308d-01,-8.3339039369489d-01, 1.1744608549563d-01,
     |   8.7429496015957d-01, 5.6262704194244d-01,-4.1827074518531d-01,
     |  -8.5015846711633d-01,-2.0171169668776d-01, 6.9534404128850d-01,
     |   6.9534404128850d-01,-2.0171169668776d-01,-8.5015846711633d-01,
     |  -4.1827074518531d-01, 5.6262704194244d-01, 8.7429496015957d-01,
     |   1.1744608549564d-01,-8.3339039369489d-01,-8.9775358746309d-01,
     |   1.0988990481660d-02, 1.0286595288286d+00, 1.3657066859339d+00,
     |   1.0098277904484d+00, 4.6858717974109d-01, 1.2918919787907d-01,
     |   1.7136859851326d-02, 5.9552737334987d-04, 3.0279370993418d-07/
      data (pmn(lat, 8,15), lat = 1,36)/
     |   1.1220506851989d-08, 6.7153013009722d-05, 3.3180334002394d-03,
     |   3.6760100378011d-02, 1.8452777763953d-01, 5.4371783938993d-01,
     |   1.0447808152995d+00, 1.3262783857240d+00, 9.6857859567731d-01,
     |   8.9642015003811d-03,-8.6146096662056d-01,-8.6394494086848d-01,
     |   4.9374299068132d-04, 8.1746922682452d-01, 6.9445616220375d-01,
     |  -2.1675900165065d-01,-8.5455030996516d-01,-4.7242139899499d-01,
     |   4.7242139899499d-01, 8.5455030996516d-01, 2.1675900165066d-01,
     |  -6.9445616220375d-01,-8.1746922682452d-01,-4.9374299067700d-04,
     |   8.6394494086848d-01, 8.6146096662056d-01,-8.9642015003805d-03,
     |  -9.6857859567731d-01,-1.3262783857240d+00,-1.0447808152995d+00,
     |  -5.4371783938993d-01,-1.8452777763953d-01,-3.6760100378011d-02,
     |  -3.3180334002395d-03,-6.7153013009722d-05,-1.1220506851989d-08/
      data (pmn(lat, 9,15), lat = 1,36)/
     |   3.5304739048364d-10, 6.4126987786123d-06, 5.4092789204769d-04,
     |   8.7183516058266d-03, 5.9530668851496d-02, 2.3250316311628d-01,
     |   5.9517048922831d-01, 1.0571027454767d+00, 1.2933110386228d+00,
     |   9.4967146170513d-01, 5.6189667435351d-02,-8.0233223013448d-01,
     |  -9.1466407739207d-01,-1.7082422871330d-01, 7.0802704885892d-01,
     |   8.3040211025368d-01, 7.2221039107375d-02,-7.5316447252085d-01,
     |  -7.5316447252085d-01, 7.2221039107374d-02, 8.3040211025368d-01,
     |   7.0802704885892d-01,-1.7082422871330d-01,-9.1466407739207d-01,
     |  -8.0233223013449d-01, 5.6189667435351d-02, 9.4967146170513d-01,
     |   1.2933110386228d+00, 1.0571027454767d+00, 5.9517048922831d-01,
     |   2.3250316311628d-01, 5.9530668851496d-02, 8.7183516058267d-03,
     |   5.4092789204770d-04, 6.4126987786123d-06, 3.5304739048364d-10/
      data (pmn(lat,10,15), lat = 1,36)/
     |   9.4446641103946d-12, 5.1966474542123d-07, 7.4529528198131d-05,
     |   1.7353865927232d-03, 1.5938185463824d-02, 8.0998984963681d-02,
     |   2.6734077985100d-01, 6.2111250326710d-01, 1.0492806141525d+00,
     |   1.2694607023895d+00, 9.7505168959828d-01, 1.6309112776784d-01,
     |  -7.0030840701446d-01,-9.6912028577337d-01,-4.0684876219717d-01,
     |   4.9996050548569d-01, 9.1834500810444d-01, 4.5163459142378d-01,
     |  -4.5163459142378d-01,-9.1834500810444d-01,-4.9996050548569d-01,
     |   4.0684876219717d-01, 9.6912028577337d-01, 7.0030840701446d-01,
     |  -1.6309112776783d-01,-9.7505168959828d-01,-1.2694607023895d+00,
     |  -1.0492806141525d+00,-6.2111250326710d-01,-2.6734077985100d-01,
     |  -8.0998984963681d-02,-1.5938185463824d-02,-1.7353865927232d-03,
     |  -7.4529528198133d-05,-5.1966474542123d-07,-9.4446641103946d-12/
      data (pmn(lat,11,15), lat = 1,36)/
     |   2.1379524409007d-13, 3.5583395998147d-08, 8.6506790440004d-06,
     |   2.8954297001266d-04, 3.5490026861718d-03, 2.3187789918198d-02,
     |   9.6783289570823d-02, 2.8435798044712d-01, 6.1937981757048d-01,
     |   1.0203584060301d+00, 1.2520432503320d+00, 1.0440966121602d+00,
     |   3.4303069982922d-01,-5.2064745545519d-01,-9.8555916582234d-01,
     |  -6.9757123072523d-01, 1.3449902295611d-01, 8.4361747156053d-01,
     |   8.4361747156053d-01, 1.3449902295611d-01,-6.9757123072522d-01,
     |  -9.8555916582234d-01,-5.2064745545519d-01, 3.4303069982923d-01,
     |   1.0440966121602d+00, 1.2520432503320d+00, 1.0203584060301d+00,
     |   6.1937981757048d-01, 2.8435798044712d-01, 9.6783289570824d-02,
     |   2.3187789918198d-02, 3.5490026861718d-03, 2.8954297001266d-04,
     |   8.6506790440006d-06, 3.5583395998147d-08, 2.1379524409007d-13/
      data (pmn(lat,12,15), lat = 1,36)/
     |   4.0429955568261d-15, 2.0332604812684d-09, 8.3598862319075d-07,
     |   4.0071387248952d-05, 6.5181260830129d-04, 5.4292805718943d-03,
     |   2.8297040323746d-02, 1.0306122303097d-01, 2.7971835575102d-01,
     |   5.8655109576664d-01, 9.6404840661840d-01, 1.2291843872043d+00,
     |   1.1463573371247d+00, 6.0671508505647d-01,-2.1146549091368d-01,
     |  -8.7590567874824d-01,-9.7006268960496d-01,-4.1752986786204d-01,
     |   4.1752986786204d-01, 9.7006268960496d-01, 8.7590567874825d-01,
     |   2.1146549091368d-01,-6.0671508505647d-01,-1.1463573371247d+00,
     |  -1.2291843872043d+00,-9.6404840661840d-01,-5.8655109576664d-01,
     |  -2.7971835575102d-01,-1.0306122303097d-01,-2.8297040323746d-02,
     |  -5.4292805718943d-03,-6.5181260830129d-04,-4.0071387248953d-05,
     |  -8.3598862319078d-07,-2.0332604812684d-09,-4.0429955568261d-15/
      data (pmn(lat,13,15), lat = 1,36)/
     |   6.2234132064538d-17, 9.4490666156186d-11, 6.5588665973603d-08,
     |   4.4894047644054d-06, 9.6500132792959d-05, 1.0184928391975d-03,
     |   6.5702675261305d-03, 2.9279734724618d-02, 9.7045051602651d-02,
     |   2.5046238695011d-01, 5.1741136659467d-01, 8.6668217640074d-01,
     |   1.1737133984113d+00, 1.2484417756716d+00, 9.4292340743381d-01,
     |   2.8247936514888d-01,-4.8693391737649d-01,-1.0043089842319d+00,
     |  -1.0043089842319d+00,-4.8693391737649d-01, 2.8247936514888d-01,
     |   9.4292340743380d-01, 1.2484417756716d+00, 1.1737133984113d+00,
     |   8.6668217640075d-01, 5.1741136659467d-01, 2.5046238695011d-01,
     |   9.7045051602651d-02, 2.9279734724618d-02, 6.5702675261306d-03,
     |   1.0184928391975d-03, 9.6500132792959d-05, 4.4894047644054d-06,
     |   6.5588665973605d-08, 9.4490666156186d-11, 6.2234132064538d-17/
      data (pmn(lat,14,15), lat = 1,36)/
     |   7.3910694221188d-19, 3.3856565199740d-12, 3.9618952559322d-09,
     |   3.8637741007837d-07, 1.0938998478045d-05, 1.4561774084888d-04,
     |   1.1552274387601d-03, 6.2421386658494d-03, 2.4934731534501d-02,
     |   7.7646644834524d-02, 1.9524829952570d-01, 4.0572538155775d-01,
     |   7.0634602103360d-01, 1.0352886940747d+00, 1.2694681053627d+00,
     |   1.2678997091107d+00, 9.4855946751141d-01, 3.5277422313138d-01,
     |  -3.5277422313138d-01,-9.4855946751141d-01,-1.2678997091107d+00,
     |  -1.2694681053627d+00,-1.0352886940747d+00,-7.0634602103360d-01,
     |  -4.0572538155775d-01,-1.9524829952570d-01,-7.7646644834524d-02,
     |  -2.4934731534501d-02,-6.2421386658495d-03,-1.1552274387601d-03,
     |  -1.4561774084888d-04,-1.0938998478045d-05,-3.8637741007838d-07,
     |  -3.9618952559323d-09,-3.3856565199740d-12,-7.3910694221188d-19/
      data (pmn(lat,15,15), lat = 1,36)/
     |   5.8916883310749d-21, 8.1378816833451d-14, 1.6036057309585d-10,
     |   2.2241977763854d-08, 8.2725852099713d-07, 1.3839816677807d-05,
     |   1.3436748872552d-04, 8.7448679908862d-04, 4.1715411402611d-03,
     |   1.5470687198532d-02, 4.6456464949153d-02, 1.1627442963141d-01,
     |   2.4773091107352d-01, 4.5632738180281d-01, 7.3508720602516d-01,
     |   1.0441647730790d+00, 1.3154514777212d+00, 1.4751735139291d+00,
     |   1.4751735139291d+00, 1.3154514777212d+00, 1.0441647730790d+00,
     |   7.3508720602516d-01, 4.5632738180281d-01, 2.4773091107352d-01,
     |   1.1627442963141d-01, 4.6456464949153d-02, 1.5470687198532d-02,
     |   4.1715411402611d-03, 8.7448679908862d-04, 1.3436748872552d-04,
     |   1.3839816677807d-05, 8.2725852099713d-07, 2.2241977763854d-08,
     |   1.6036057309586d-10, 8.1378816833451d-14, 5.8916883310749d-21/
      data (pmn(lat, 0,16), lat = 1,36)/
     |   3.5528780032208d+00, 5.3944260128967d-01,-1.5978213192888d+00,
     |  -6.7249203416978d-01, 1.0577020703318d+00, 7.8602205076812d-01,
     |  -7.0743179660523d-01,-8.5529718162561d-01, 4.2195079452984d-01,
     |   8.8159390554846d-01,-1.6960456768584d-01,-8.6693600747253d-01,
     |  -5.8716041581084d-02, 8.1342451126490d-01, 2.6439758210885d-01,
     |  -7.2346264118495d-01,-4.4574837662795d-01, 5.9985561802033d-01,
     |   5.9985561802033d-01,-4.4574837662795d-01,-7.2346264118496d-01,
     |   2.6439758210885d-01, 8.1342451126490d-01,-5.8716041581089d-02,
     |  -8.6693600747253d-01,-1.6960456768584d-01, 8.8159390554846d-01,
     |   4.2195079452984d-01,-8.5529718162560d-01,-7.0743179660524d-01,
     |   7.8602205076812d-01, 1.0577020703318d+00,-6.7249203416978d-01,
     |  -1.5978213192888d+00, 5.3944260128967d-01, 3.5528780032208d+00/
      data (pmn(lat, 1,16), lat = 1,36)/
     |   1.3691792274292d+00, 2.2840861559039d+00, 3.9259711463053d-01,
     |  -1.3572117972755d+00,-6.6031752852877d-01, 9.1844761736903d-01,
     |   7.9427074500842d-01,-5.9407277420623d-01,-8.6103086401509d-01,
     |   3.1730637088492d-01, 8.7636012287672d-01,-6.9413729255253d-02,
     |  -8.4670112662587d-01,-1.5440899762570d-01, 7.7610317569558d-01,
     |   3.5375990668270d-01,-6.6806810231376d-01,-5.2609998832088d-01,
     |   5.2609998832088d-01, 6.6806810231376d-01,-3.5375990668270d-01,
     |  -7.7610317569558d-01, 1.5440899762570d-01, 8.4670112662587d-01,
     |   6.9413729255260d-02,-8.7636012287672d-01,-3.1730637088492d-01,
     |   8.6103086401509d-01, 5.9407277420624d-01,-7.9427074500842d-01,
     |  -9.1844761736903d-01, 6.6031752852877d-01, 1.3572117972755d+00,
     |  -3.9259711463051d-01,-2.2840861559039d+00,-1.3691792274292d+00/
      data (pmn(lat, 2,16), lat = 1,36)/
     |   2.5092721684812d-01, 1.5702596125963d+00, 1.8192742632501d+00,
     |   1.5104794444893d-01,-1.2556457162864d+00,-5.7418150322008d-01,
     |   8.6179730673189d-01, 7.6422517733679d-01,-5.3788128440199d-01,
     |  -8.4946314126469d-01, 2.5208016228961d-01, 8.6475849728034d-01,
     |   5.2849353421123d-03,-8.2421639264917d-01,-2.3559055565892d-01,
     |   7.3568298060579d-01, 4.3669097248594d-01,-6.0486902841540d-01,
     |  -6.0486902841540d-01, 4.3669097248593d-01, 7.3568298060579d-01,
     |  -2.3559055565892d-01,-8.2421639264917d-01, 5.2849353421172d-03,
     |   8.6475849728034d-01, 2.5208016228961d-01,-8.4946314126469d-01,
     |  -5.3788128440200d-01, 7.6422517733679d-01, 8.6179730673189d-01,
     |  -5.7418150322008d-01,-1.2556457162864d+00, 1.5104794444892d-01,
     |   1.8192742632500d+00, 1.5702596125963d+00, 2.5092721684812d-01/
      data (pmn(lat, 3,16), lat = 1,36)/
     |   3.0093009609014d-02, 6.2404453249276d-01, 1.6170835580350d+00,
     |   1.4848712378870d+00,-7.8203685187539d-02,-1.1958426848930d+00,
     |  -4.6845052827162d-01, 8.4278714395144d-01, 7.2351687559462d-01,
     |  -5.1058773451419d-01,-8.3548540512399d-01, 2.0504799819008d-01,
     |   8.5371828435511d-01, 7.1834932883202d-02,-8.0013470742647d-01,
     |  -3.1640935832085d-01, 6.8717253733643d-01, 5.2356387124416d-01,
     |  -5.2356387124416d-01,-6.8717253733643d-01, 3.1640935832084d-01,
     |   8.0013470742647d-01,-7.1834932883201d-02,-8.5371828435511d-01,
     |  -2.0504799819009d-01, 8.3548540512399d-01, 5.1058773451419d-01,
     |  -7.2351687559462d-01,-8.4278714395145d-01, 4.6845052827161d-01,
     |   1.1958426848930d+00, 7.8203685187539d-02,-1.4848712378870d+00,
     |  -1.6170835580350d+00,-6.2404453249276d-01,-3.0093009609014d-02/
      data (pmn(lat, 4,16), lat = 1,36)/
     |   2.6642886526914d-03, 1.7553232510771d-01, 8.7405355194593d-01,
     |   1.5996103564002d+00, 1.1997978794210d+00,-2.7402607092890d-01,
     |  -1.1453000833782d+00,-3.6429534306317d-01, 8.3785828923445d-01,
     |   6.8511328714671d-01,-4.9352465976283d-01,-8.2607160412053d-01,
     |   1.6002409308557d-01, 8.4474430127586d-01, 1.4441839556537d-01,
     |  -7.7022493489330d-01,-4.0803745950190d-01, 6.2031451824331d-01,
     |   6.2031451824331d-01,-4.0803745950190d-01,-7.7022493489330d-01,
     |   1.4441839556537d-01, 8.4474430127585d-01, 1.6002409308556d-01,
     |  -8.2607160412053d-01,-4.9352465976283d-01, 6.8511328714671d-01,
     |   8.3785828923446d-01,-3.6429534306317d-01,-1.1453000833782d+00,
     |  -2.7402607092890d-01, 1.1997978794210d+00, 1.5996103564002d+00,
     |   8.7405355194593d-01, 1.7553232510771d-01, 2.6642886526914d-03/
      data (pmn(lat, 5,16), lat = 1,36)/
     |   1.8537528732869d-04, 3.8047624100363d-02, 3.4433303196088d-01,
     |   1.0484544145651d+00, 1.5391685361327d+00, 9.4939575792031d-01,
     |  -4.3015824073231d-01,-1.0953162128633d+00,-2.7411647147345d-01,
     |   8.3500573693888d-01, 6.5779922909355d-01,-4.7349025909264d-01,
     |  -8.2518259178985d-01, 1.0336905533992d-01, 8.3568348465539d-01,
     |   2.3534018037941d-01,-7.2506672516819d-01,-5.1816066932196d-01,
     |   5.1816066932196d-01, 7.2506672516819d-01,-2.3534018037941d-01,
     |  -8.3568348465539d-01,-1.0336905533992d-01, 8.2518259178986d-01,
     |   4.7349025909265d-01,-6.5779922909355d-01,-8.3500573693888d-01,
     |   2.7411647147344d-01, 1.0953162128633d+00, 4.3015824073232d-01,
     |  -9.4939575792031d-01,-1.5391685361327d+00,-1.0484544145651d+00,
     |  -3.4433303196088d-01,-3.8047624100363d-02,-1.8537528732869d-04/
      data (pmn(lat, 6,16), lat = 1,36)/
     |   1.0519821653567d-05, 6.6541767243378d-03, 1.0649602601150d-01,
     |   5.0524055725649d-01, 1.1643229690634d+00, 1.4519956817763d+00,
     |   7.3468030208608d-01,-5.4584976257273d-01,-1.0472922769016d+00,
     |  -2.0727346469263d-01, 8.2808195876193d-01, 6.4906067795974d-01,
     |  -4.3943037807043d-01,-8.3449730099726d-01, 2.2005738327884d-02,
     |   8.1951608660179d-01, 3.5502066337763d-01,-6.4754406146225d-01,
     |  -6.4754406146225d-01, 3.5502066337763d-01, 8.1951608660179d-01,
     |   2.2005738327886d-02,-8.3449730099726d-01,-4.3943037807042d-01,
     |   6.4906067795974d-01, 8.2808195876193d-01,-2.0727346469263d-01,
     |  -1.0472922769016d+00,-5.4584976257273d-01, 7.3468030208608d-01,
     |   1.4519956817763d+00, 1.1643229690634d+00, 5.0524055725649d-01,
     |   1.0649602601150d-01, 6.6541767243378d-03, 1.0519821653567d-05/
      data (pmn(lat, 7,16), lat = 1,36)/
     |   4.9846823094084d-07, 9.6531695327252d-04, 2.6896490859671d-02,
     |   1.9246636364418d-01, 6.4535205032785d-01, 1.2331707971174d+00,
     |   1.3537276747661d+00, 5.6065396399483d-01,-6.2316571731064d-01,
     |  -1.0067958108907d+00,-1.7196899110199d-01, 8.1286755679121d-01,
     |   6.6543311337617d-01,-3.7953717955782d-01,-8.5171671353076d-01,
     |  -9.7644088066141d-02, 7.8072385150247d-01, 5.0913533737100d-01,
     |  -5.0913533737100d-01,-7.8072385150247d-01, 9.7644088066136d-02,
     |   8.5171671353076d-01, 3.7953717955782d-01,-6.6543311337617d-01,
     |  -8.1286755679121d-01, 1.7196899110199d-01, 1.0067958108907d+00,
     |   6.2316571731064d-01,-5.6065396399483d-01,-1.3537276747661d+00,
     |  -1.2331707971174d+00,-6.4535205032785d-01,-1.9246636364418d-01,
     |  -2.6896490859672d-02,-9.6531695327252d-04,-4.9846823094084d-07/
      data (pmn(lat, 8,16), lat = 1,36)/
     |   2.0017661701382d-08, 1.1817131091885d-04, 5.6759453496988d-03,
     |   6.0121503031124d-02, 2.8267215813847d-01, 7.5825193683194d-01,
     |   1.2660457755158d+00, 1.2592717982527d+00, 4.3288261490675d-01,
     |  -6.6492485635701d-01,-9.8019563839859d-01,-1.7646805225082d-01,
     |   7.8342352897372d-01, 7.1136216251799d-01,-2.7851834809467d-01,
     |  -8.6627818984118d-01,-2.6843519300763d-01, 6.8937503954479d-01,
     |   6.8937503954479d-01,-2.6843519300763d-01,-8.6627818984118d-01,
     |  -2.7851834809467d-01, 7.1136216251799d-01, 7.8342352897372d-01,
     |  -1.7646805225081d-01,-9.8019563839859d-01,-6.6492485635701d-01,
     |   4.3288261490675d-01, 1.2592717982527d+00, 1.2660457755158d+00,
     |   7.5825193683194d-01, 2.8267215813847d-01, 6.0121503031124d-02,
     |   5.6759453496989d-03, 1.1817131091885d-04, 2.0017661701382d-08/
      data (pmn(lat, 9,16), lat = 1,36)/
     |   6.8733425289681d-10, 1.2331919723665d-05, 1.0143085032713d-03,
     |   1.5714065317284d-02, 1.0141296885535d-01, 3.6639299186183d-01,
     |   8.4153120110255d-01, 1.2740609350408d+00, 1.1820819911664d+00,
     |   3.5695839845498d-01,-6.7222318069422d-01,-9.7194833867159d-01,
     |  -2.3013765303641d-01, 7.2779165264851d-01, 7.8577694710403d-01,
     |  -1.1580421143124d-01,-8.5133485741735d-01,-4.9505609886941d-01,
     |   4.9505609886941d-01, 8.5133485741735d-01, 1.1580421143125d-01,
     |  -7.8577694710403d-01,-7.2779165264851d-01, 2.3013765303642d-01,
     |   9.7194833867159d-01, 6.7222318069422d-01,-3.5695839845498d-01,
     |  -1.1820819911664d+00,-1.2740609350408d+00,-8.4153120110255d-01,
     |  -3.6639299186183d-01,-1.0141296885535d-01,-1.5714065317284d-02,
     |  -1.0143085032713d-03,-1.2331919723665d-05,-6.8733425289681d-10/
      data (pmn(lat,10,16), lat = 1,36)/
     |   2.0256848033840d-11, 1.1021957354583d-06, 1.5451422879352d-04,
     |   3.4726946491258d-03, 3.0346611312707d-02, 1.4422615975588d-01,
     |   4.3528516602233d-01, 8.9529583189925d-01, 1.2674181479897d+00,
     |   1.1334528876935d+00, 3.3929871081671d-01,-6.4117722994987d-01,
     |  -9.8109678305198d-01,-3.4348596896498d-01, 6.2253272429361d-01,
     |   8.7385188784622d-01, 1.3185345965254d-01,-7.5150067567358d-01,
     |  -7.5150067567358d-01, 1.3185345965254d-01, 8.7385188784622d-01,
     |   6.2253272429361d-01,-3.4348596896498d-01,-9.8109678305198d-01,
     |  -6.4117722994988d-01, 3.3929871081671d-01, 1.1334528876935d+00,
     |   1.2674181479897d+00, 8.9529583189925d-01, 4.3528516602234d-01,
     |   1.4422615975588d-01, 3.0346611312707d-02, 3.4726946491258d-03,
     |   1.5451422879352d-04, 1.1021957354583d-06, 2.0256848033840d-11/
      data (pmn(lat,11,16), lat = 1,36)/
     |   5.1194046155133d-13, 8.4339231866008d-08, 2.0082075306136d-05,
     |   6.5095266142640d-04, 7.6311171030115d-03, 4.6999486762674d-02,
     |   1.8167461619233d-01, 4.8298717911413d-01, 9.2047437191132d-01,
     |   1.2536792851183d+00, 1.1216165216733d+00, 3.8834312749953d-01,
     |  -5.5859915376419d-01,-9.9497601117807d-01,-5.2444022396534d-01,
     |   4.2715929500869d-01, 9.2963421903313d-01, 4.7316815093353d-01,
     |  -4.7316815093353d-01,-9.2963421903313d-01,-4.2715929500870d-01,
     |   5.2444022396534d-01, 9.9497601117807d-01, 5.5859915376419d-01,
     |  -3.8834312749952d-01,-1.1216165216733d+00,-1.2536792851183d+00,
     |  -9.2047437191132d-01,-4.8298717911413d-01,-1.8167461619233d-01,
     |  -4.6999486762674d-02,-7.6311171030115d-03,-6.5095266142641d-04,
     |  -2.0082075306136d-05,-8.4339231866008d-08,-5.1194046155133d-13/
      data (pmn(lat,12,16), lat = 1,36)/
     |   1.1023494958238d-14, 5.4918177183732d-09, 2.2152736530573d-06,
     |   1.0311649894721d-04, 1.6108570218441d-03, 1.2725868648910d-02,
     |   6.1992814848255d-02, 2.0726982599706d-01, 5.0437738907069d-01,
     |   9.1672014481825d-01, 1.2352485757803d+00, 1.1497220435226d+00,
     |   5.1469729165804d-01,-3.9680445560458d-01,-9.7711377325457d-01,
     |  -7.6393004028276d-01, 8.5726540913541d-02, 8.4680562839792d-01,
     |   8.4680562839793d-01, 8.5726540913542d-02,-7.6393004028276d-01,
     |  -9.7711377325457d-01,-3.9680445560458d-01, 5.1469729165804d-01,
     |   1.1497220435226d+00, 1.2352485757803d+00, 9.1672014481825d-01,
     |   5.0437738907069d-01, 2.0726982599706d-01, 6.1992814848256d-02,
     |   1.2725868648910d-02, 1.6108570218441d-03, 1.0311649894721d-04,
     |   2.2152736530574d-06, 5.4918177183732d-09, 1.1023494958238d-14/
      data (pmn(lat,13,16), lat = 1,36)/
     |   1.9942079351500d-16, 3.0014674411866d-10, 2.0468913683702d-07,
     |   1.3636935506510d-05, 2.8246801519483d-04, 2.8413765951739d-03,
     |   1.7252806106466d-02, 7.1314599100625d-02, 2.1532788842739d-01,
     |   4.9457433166267d-01, 8.7991773142494d-01, 1.2055296304711d+00,
     |   1.2107207126415d+00, 7.2681452826779d-01,-1.1037048753209d-01,
     |  -8.4666285683273d-01,-9.9613605940955d-01,-4.3742998213733d-01,
     |   4.3742998213733d-01, 9.9613605940955d-01, 8.4666285683273d-01,
     |   1.1037048753209d-01,-7.2681452826779d-01,-1.2107207126415d+00,
     |  -1.2055296304711d+00,-8.7991773142494d-01,-4.9457433166267d-01,
     |  -2.1532788842739d-01,-7.1314599100625d-02,-1.7252806106466d-02,
     |  -2.8413765951739d-03,-2.8246801519483d-04,-1.3636935506510d-05,
     |  -2.0468913683702d-07,-3.0014674411866d-10,-1.9942079351500d-16/
      data (pmn(lat,14,16), lat = 1,36)/
     |   2.9504474780822d-18, 1.3405475722780d-11, 1.5431003650549d-08,
     |   1.4676126148259d-06, 4.0153532562544d-05, 5.1147470095937d-04,
     |   3.8406340773621d-03, 1.9400523372545d-02, 7.1404999458422d-02,
     |   2.0129612352680d-01, 4.4807006486128d-01, 7.9956067747145d-01,
     |   1.1429878243369d+00, 1.2755765925821d+00, 1.0139364444533d+00,
     |   3.5286399540314d-01,-4.5674272071044d-01,-1.0137144291690d+00,
     |  -1.0137144291690d+00,-4.5674272071044d-01, 3.5286399540314d-01,
     |   1.0139364444533d+00, 1.2755765925821d+00, 1.1429878243369d+00,
     |   7.9956067747146d-01, 4.4807006486128d-01, 2.0129612352680d-01,
     |   7.1404999458422d-02, 1.9400523372545d-02, 3.8406340773621d-03,
     |   5.1147470095937d-04, 4.0153532562544d-05, 1.4676126148259d-06,
     |   1.5431003650549d-08, 1.3405475722780d-11, 2.9504474780822d-18/
      data (pmn(lat,15,16), lat = 1,36)/
     |   3.3812959606791d-20, 4.6348630633411d-13, 8.9936520774837d-10,
     |   1.2185682932766d-07, 4.3904957902197d-06, 7.0520637786732d-05,
     |   6.5099906110466d-04, 3.9854455719125d-03, 1.7667877737671d-02,
     |   6.0041277089996d-02, 1.6246142466634d-01, 3.5888698729724d-01,
     |   6.5711710107564d-01, 1.0031668211049d+00, 1.2698067697408d+00,
     |   1.2982632327638d+00, 9.8634641818068d-01, 3.6964057553447d-01,
     |  -3.6964057553447d-01,-9.8634641818068d-01,-1.2982632327638d+00,
     |  -1.2698067697408d+00,-1.0031668211049d+00,-6.5711710107564d-01,
     |  -3.5888698729724d-01,-1.6246142466634d-01,-6.0041277089996d-02,
     |  -1.7667877737671d-02,-3.9854455719125d-03,-6.5099906110467d-04,
     |  -7.0520637786732d-05,-4.3904957902197d-06,-1.2185682932766d-07,
     |  -8.9936520774840d-10,-4.6348630633411d-13,-3.3812959606791d-20/
      data (pmn(lat,16,16), lat = 1,36)/
     |   2.6097644270972d-22, 1.0786760120595d-14, 3.5246527050341d-11,
     |   6.7919923351555d-09, 3.2148661104609d-07, 6.4895998370404d-06,
     |   7.3314977433014d-05, 5.4060787348802d-04, 2.8619487856186d-03,
     |   1.1583037712037d-02, 3.7427842648077d-02, 9.9585335405482d-02,
     |   2.2314702674312d-01, 4.2812822074239d-01, 7.1193500367753d-01,
     |   1.0352197079401d+00, 1.3244189318012d+00, 1.4966199774351d+00,
     |   1.4966199774351d+00, 1.3244189318012d+00, 1.0352197079401d+00,
     |   7.1193500367753d-01, 4.2812822074239d-01, 2.2314702674312d-01,
     |   9.9585335405483d-02, 3.7427842648077d-02, 1.1583037712037d-02,
     |   2.8619487856186d-03, 5.4060787348802d-04, 7.3314977433014d-05,
     |   6.4895998370404d-06, 3.2148661104609d-07, 6.7919923351556d-09,
     |   3.5246527050343d-11, 1.0786760120595d-14, 2.6097644270972d-22/
      data (pmn(lat, 0,17), lat = 1,36)/
     |   3.5958053283433d+00, 2.5292886922303d-01,-1.6914201687850d+00,
     |  -2.5275898967813d-01, 1.2588327908676d+00, 2.9431311872774d-01,
     |  -1.0408368762170d+00,-3.3748651126049d-01, 9.0156854407115d-01,
     |   3.7964490712863d-01,-8.0097473727543d-01,-4.2122129392769d-01,
     |   7.2244185984497d-01, 4.6310629861881d-01,-6.5764304301890d-01,
     |  -5.0632763612061d-01, 6.0184310066422d-01, 5.5207716106556d-01,
     |  -5.5207716106556d-01,-6.0184310066422d-01, 5.0632763612061d-01,
     |   6.5764304301890d-01,-4.6310629861880d-01,-7.2244185984496d-01,
     |   4.2122129392768d-01, 8.0097473727543d-01,-3.7964490712863d-01,
     |  -9.0156854407115d-01, 3.3748651126049d-01, 1.0408368762170d+00,
     |  -2.9431311872774d-01,-1.2588327908676d+00, 2.5275898967812d-01,
     |   1.6914201687850d+00,-2.5292886922303d-01,-3.5958053283433d+00/
      data (pmn(lat, 1,17), lat = 1,36)/
     |   1.4832560322403d+00, 2.2692509399373d+00, 2.6036944077455d-02,
     |  -1.4591974583132d+00,-1.8723151171573d-01, 1.1542638571779d+00,
     |   2.7000433816878d-01,-9.7873223733049d-01,-3.3107695584200d-01,
     |   8.5866963368675d-01, 3.8333134885678d-01,-7.6799446279864d-01,
     |  -4.3173461093111d-01, 6.9476484617783d-01, 4.7897374466798d-01,
     |  -6.3256393895700d-01,-5.2697475966818d-01, 5.7750720811917d-01,
     |   5.7750720811917d-01,-5.2697475966818d-01,-6.3256393895701d-01,
     |   4.7897374466797d-01, 6.9476484617784d-01,-4.3173461093112d-01,
     |  -7.6799446279864d-01, 3.8333134885678d-01, 8.5866963368676d-01,
     |  -3.3107695584199d-01,-9.7873223733049d-01, 2.7000433816877d-01,
     |   1.1542638571779d+00,-1.8723151171573d-01,-1.4591974583132d+00,
     |   2.6036944077440d-02, 2.2692509399373d+00, 1.4832560322403d+00/
      data (pmn(lat, 2,17), lat = 1,36)/
     |   2.8925843477840d-01, 1.7234223883778d+00, 1.7104468026714d+00,
     |  -2.7727699598145d-01,-1.3148167890745d+00,-4.0935591896005d-02,
     |   1.0928707767939d+00, 1.9228396382714d-01,-9.4597413461673d-01,
     |  -2.9063658795192d-01, 8.3734543137237d-01, 3.6648190995411d-01,
     |  -7.5059464501902d-01,-4.3161643008473d-01, 6.7712595999507d-01,
     |   4.9190427908206d-01,-6.1177775221259d-01,-5.5099792465931d-01,
     |   5.5099792465931d-01, 6.1177775221259d-01,-4.9190427908206d-01,
     |  -6.7712595999507d-01, 4.3161643008473d-01, 7.5059464501902d-01,
     |  -3.6648190995410d-01,-8.3734543137237d-01, 2.9063658795192d-01,
     |   9.4597413461673d-01,-1.9228396382714d-01,-1.0928707767939d+00,
     |   4.0935591896005d-02, 1.3148167890745d+00, 2.7727699598146d-01,
     |  -1.7104468026714d+00,-1.7234223883778d+00,-2.8925843477840d-01/
      data (pmn(lat, 3,17), lat = 1,36)/
     |   3.6891347630286d-02, 7.3883679526750d-01, 1.7555684848551d+00,
     |   1.2658021245652d+00,-5.4458570737057d-01,-1.1800937999461d+00,
     |   1.2437091781324d-01, 1.0431066423736d+00, 9.4865895701529d-02,
     |  -9.2587896554960d-01,-2.3749531117933d-01, 8.2701615052972d-01,
     |   3.4436696485898d-01,-7.4066906561467d-01,-4.3285131043997d-01,
     |   6.6195167622561d-01, 5.1187589750999d-01,-5.8690025423818d-01,
     |  -5.8690025423818d-01, 5.1187589750998d-01, 6.6195167622561d-01,
     |  -4.3285131043997d-01,-7.4066906561467d-01, 3.4436696485898d-01,
     |   8.2701615052972d-01,-2.3749531117933d-01,-9.2587896554960d-01,
     |   9.4865895701526d-02, 1.0431066423736d+00, 1.2437091781325d-01,
     |  -1.1800937999461d+00,-5.4458570737057d-01, 1.2658021245652d+00,
     |   1.7555684848551d+00, 7.3883679526750d-01, 3.6891347630286d-02/
      data (pmn(lat, 4,17), lat = 1,36)/
     |   3.4760362394319d-03, 2.2287932609254d-01, 1.0432107663225d+00,
     |   1.6849134260813d+00, 8.6810019185297d-01,-7.5191224592463d-01,
     |  -1.0356522940593d+00, 2.8145583751227d-01, 9.9180541806247d-01,
     |  -3.2949829335526d-03,-9.0961613086365d-01,-1.8583745113692d-01,
     |   8.2094515651197d-01, 3.2864248834086d-01,-7.3175768597744d-01,
     |  -4.4554615271167d-01, 6.4157034992448d-01, 5.4762520704301d-01,
     |  -5.4762520704301d-01,-6.4157034992448d-01, 4.4554615271166d-01,
     |   7.3175768597744d-01,-3.2864248834086d-01,-8.2094515651197d-01,
     |   1.8583745113692d-01, 9.0961613086365d-01, 3.2949829335544d-03,
     |  -9.9180541806247d-01,-2.8145583751227d-01, 1.0356522940593d+00,
     |   7.5191224592463d-01,-8.6810019185297d-01,-1.6849134260813d+00,
     |  -1.0432107663225d+00,-2.2287932609254d-01,-3.4760362394319d-03/
      data (pmn(lat, 5,17), lat = 1,36)/
     |   2.5779500937925d-04, 5.1744588876423d-02, 4.4604044724506d-01,
     |   1.2445302371380d+00, 1.5435579630117d+00, 5.1320675321786d-01,
     |  -8.9511124735022d-01,-8.8408003515372d-01, 4.1582945612439d-01,
     |   9.3731073403574d-01,-8.9382057210192d-02,-8.9450813171086d-01,
     |  -1.4698887573979d-01, 8.1535205094864d-01, 3.2972025158570d-01,
     |  -7.1787149190478d-01,-4.7902977698578d-01, 6.0636258155160d-01,
     |   6.0636258155160d-01,-4.7902977698578d-01,-7.1787149190478d-01,
     |   3.2972025158570d-01, 8.1535205094864d-01,-1.4698887573979d-01,
     |  -8.9450813171086d-01,-8.9382057210192d-02, 9.3731073403574d-01,
     |   4.1582945612439d-01,-8.8408003515371d-01,-8.9511124735022d-01,
     |   5.1320675321786d-01, 1.5435579630117d+00, 1.2445302371380d+00,
     |   4.4604044724506d-01, 5.1744588876423d-02, 2.5779500937925d-04/
      data (pmn(lat, 6,17), lat = 1,36)/
     |   1.5629555025213d-05, 9.7007112737039d-03, 1.4911530440782d-01,
     |   6.6073683597337d-01, 1.3593897889734d+00, 1.3588312341577d+00,
     |   2.0851054745770d-01,-9.8002544213310d-01,-7.3645861225967d-01,
     |   5.2034339183291d-01, 8.8466458798531d-01,-1.5384402007479d-01,
     |  -8.8174318799911d-01,-1.3125368669158d-01, 8.0747302104144d-01,
     |   3.5774981870411d-01,-6.9105053859419d-01,-5.4152199038633d-01,
     |   5.4152199038633d-01, 6.9105053859419d-01,-3.5774981870411d-01,
     |  -8.0747302104144d-01, 1.3125368669158d-01, 8.8174318799911d-01,
     |   1.5384402007480d-01,-8.8466458798531d-01,-5.2034339183291d-01,
     |   7.3645861225966d-01, 9.8002544213310d-01,-2.0851054745769d-01,
     |  -1.3588312341577d+00,-1.3593897889734d+00,-6.6073683597337d-01,
     |  -1.4911530440782d-01,-9.7007112737039d-03,-1.5629555025213d-05/
      data (pmn(lat, 7,17), lat = 1,36)/
     |   7.9367016386314d-07, 1.5118673708857d-03, 4.0694515502283d-02,
     |   2.7519472593941d-01, 8.4556323333929d-01, 1.4030863784356d+00,
     |   1.1569527337499d+00,-3.9320815665648d-02,-1.0187495105750d+00,
     |  -6.0623131479995d-01, 5.9273786896594d-01, 8.4222717221312d-01,
     |  -1.8870632131014d-01,-8.7382958971154d-01,-1.4909955567135d-01,
     |   7.9258067191060d-01, 4.2260373835862d-01,-6.3745218766786d-01,
     |  -6.3745218766786d-01, 4.2260373835862d-01, 7.9258067191060d-01,
     |  -1.4909955567135d-01,-8.7382958971154d-01,-1.8870632131013d-01,
     |   8.4222717221312d-01, 5.9273786896594d-01,-6.0623131479995d-01,
     |  -1.0187495105750d+00,-3.9320815665651d-02, 1.1569527337499d+00,
     |   1.4030863784356d+00, 8.4556323333929d-01, 2.7519472593941d-01,
     |   4.0694515502284d-02, 1.5118673708857d-03, 7.9367016386314d-07/
      data (pmn(lat, 8,17), lat = 1,36)/
     |   3.4297079293663d-08, 1.9953449149803d-04, 9.2982625906240d-03,
     |   9.3830053638702d-02, 4.1057200875138d-01, 9.9016350852221d-01,
     |   1.3937316865607d+00, 9.6171910930943d-01,-2.2760455006168d-01,
     |  -1.0265828795482d+00,-5.0637966334911d-01, 6.3318158051579d-01,
     |   8.1911535500673d-01,-1.8560729158989d-01,-8.7139953403842d-01,
     |  -2.1204930291652d-01, 7.5939934740287d-01, 5.3183477906502d-01,
     |  -5.3183477906501d-01,-7.5939934740287d-01, 2.1204930291652d-01,
     |   8.7139953403842d-01, 1.8560729158989d-01,-8.1911535500674d-01,
     |  -6.3318158051580d-01, 5.0637966334911d-01, 1.0265828795482d+00,
     |   2.2760455006168d-01,-9.6171910930943d-01,-1.3937316865607d+00,
     |  -9.9016350852221d-01,-4.1057200875138d-01,-9.3830053638703d-02,
     |  -9.2982625906242d-03,-1.9953449149803d-04,-3.4297079293663d-08/
      data (pmn(lat, 9,17), lat = 1,36)/
     |   1.2740401380960d-09, 2.2560996904138d-05, 1.8063111802889d-03,
     |   2.6818482491263d-02, 1.6276381291564d-01, 5.3923039330389d-01,
     |   1.0923995266586d+00, 1.3515738693457d+00, 7.9320188092489d-01,
     |  -3.5730265337478d-01,-1.0190814838618d+00,-4.4862758188996d-01,
     |   6.4105006368362d-01, 8.2279622575232d-01,-1.3326408523281d-01,
     |  -8.6839988921326d-01,-3.3224182668832d-01, 6.8317255643543d-01,
     |   6.8317255643543d-01,-3.3224182668831d-01,-8.6839988921326d-01,
     |  -1.3326408523281d-01, 8.2279622575232d-01, 6.4105006368362d-01,
     |  -4.4862758188996d-01,-1.0190814838618d+00,-3.5730265337478d-01,
     |   7.9320188092489d-01, 1.3515738693457d+00, 1.0923995266586d+00,
     |   5.3923039330389d-01, 1.6276381291564d-01, 2.6818482491263d-02,
     |   1.8063111802889d-03, 2.2560996904138d-05, 1.2740401380960d-09/
      data (pmn(lat,10,17), lat = 1,36)/
     |   4.0911205368479d-11, 2.1997324910571d-06, 3.0096815456676d-04,
     |   6.5121488440894d-03, 5.3922443244955d-02, 2.3805950585674d-01,
     |   6.4945722503315d-01, 1.1562831954142d+00, 1.2970717258917d+00,
     |   6.6751060821798d-01,-4.3065552215787d-01,-1.0090772971927d+00,
     |  -4.4385324331781d-01, 6.1059560366625d-01, 8.5552005524742d-01,
     |  -1.5079505777141d-02,-8.4397881250935d-01,-5.1701954989262d-01,
     |   5.1701954989262d-01, 8.4397881250935d-01, 1.5079505777146d-02,
     |  -8.5552005524742d-01,-6.1059560366625d-01, 4.4385324331782d-01,
     |   1.0090772971927d+00, 4.3065552215787d-01,-6.6751060821798d-01,
     |  -1.2970717258917d+00,-1.1562831954142d+00,-6.4945722503315d-01,
     |  -2.3805950585674d-01,-5.3922443244955d-02,-6.5121488440895d-03,
     |  -3.0096815456677d-04,-2.1997324910571d-06,-4.0911205368479d-11/
      data (pmn(lat,11,17), lat = 1,36)/
     |   1.1374014504337d-12, 1.8535423535358d-07, 4.3167716597325d-05,
     |   1.3520258461745d-03, 1.5105438183318d-02, 8.7223229554193d-02,
     |   3.0956744059692d-01, 7.3385385654409d-01, 1.1894620565396d+00,
     |   1.2488907637867d+00, 5.9773612551433d-01,-4.4740076978111d-01,
     |  -1.0030414863326d+00,-5.0244613492908d-01, 5.2524734319849d-01,
     |   9.0685420061785d-01, 1.9004995057325d-01,-7.4942973130330d-01,
     |  -7.4942973130330d-01, 1.9004995057324d-01, 9.0685420061785d-01,
     |   5.2524734319849d-01,-5.0244613492908d-01,-1.0030414863326d+00,
     |  -4.4740076978111d-01, 5.9773612551433d-01, 1.2488907637867d+00,
     |   1.1894620565396d+00, 7.3385385654409d-01, 3.0956744059692d-01,
     |   8.7223229554193d-02, 1.5105438183318d-02, 1.3520258461745d-03,
     |   4.3167716597326d-05, 1.8535423535358d-07, 1.1374014504337d-12/
      data (pmn(lat,12,17), lat = 1,36)/
     |   2.7306710879062d-14, 1.3468326339247d-08, 5.3233292505046d-06,
     |   2.4013782019968d-04, 3.5915938398108d-03, 2.6788209224615d-02,
     |   1.2113776573756d-01, 3.6785407516923d-01, 7.8831105751424d-01,
     |   1.2001902985764d+00, 1.2220295329782d+00, 5.9560095671766d-01,
     |  -3.9977256064888d-01,-9.9515367395862d-01,-6.3178860299923d-01,
     |   3.5131000775306d-01, 9.3747582832857d-01, 4.9415983461972d-01,
     |  -4.9415983461972d-01,-9.3747582832857d-01,-3.5131000775306d-01,
     |   6.3178860299922d-01, 9.9515367395862d-01, 3.9977256064888d-01,
     |  -5.9560095671766d-01,-1.2220295329782d+00,-1.2001902985764d+00,
     |  -7.8831105751424d-01,-3.6785407516923d-01,-1.2113776573756d-01,
     |  -2.6788209224615d-02,-3.5915938398108d-03,-2.4013782019968d-04,
     |  -5.3233292505047d-06,-1.3468326339247d-08,-2.7306710879062d-14/
      data (pmn(lat,13,17), lat = 1,36)/
     |   5.6179238923370d-16, 8.3772523662724d-10, 5.6063809898355d-07,
     |   3.6287631640374d-05, 7.2231981358355d-04, 6.8976560559078d-03,
     |   3.9198522394042d-02, 1.4903717306142d-01, 4.0472847792971d-01,
     |   8.1000724825189d-01, 1.1937203494587d+00, 1.2254122139567d+00,
     |   6.7250118485308d-01,-2.6660473727239d-01,-9.5606366149844d-01,
     |  -8.2409189263239d-01, 3.7164784821770d-02, 8.4943966493064d-01,
     |   8.4943966493064d-01, 3.7164784821771d-02,-8.2409189263239d-01,
     |  -9.5606366149844d-01,-2.6660473727239d-01, 6.7250118485309d-01,
     |   1.2254122139567d+00, 1.1937203494587d+00, 8.1000724825189d-01,
     |   4.0472847792971d-01, 1.4903717306142d-01, 3.9198522394042d-02,
     |   6.8976560559078d-03, 7.2231981358355d-04, 3.6287631640375d-05,
     |   5.6063809898356d-07, 8.3772523662724d-10, 5.6179238923370d-16/
      data (pmn(lat,14,17), lat = 1,36)/
     |   9.7570023917591d-18, 4.3948662646925d-11, 4.9710174110847d-08,
     |   4.6028909370512d-06, 1.2139793515282d-04, 1.4745510361148d-03,
     |   1.0429200631100d-02, 4.8913774528657d-02, 1.6424681224112d-01,
     |   4.1298785141963d-01, 7.9462556580650d-01, 1.1676969990632d+00,
     |   1.2570866812189d+00, 8.3668050853790d-01,-8.9614124117620d-03,
     |  -8.1296251420934d-01,-1.0196618097243d+00,-4.5690928574177d-01,
     |   4.5690928574177d-01, 1.0196618097243d+00, 8.1296251420934d-01,
     |   8.9614124117631d-03,-8.3668050853790d-01,-1.2570866812189d+00,
     |  -1.1676969990632d+00,-7.9462556580650d-01,-4.1298785141963d-01,
     |  -1.6424681224112d-01,-4.8913774528657d-02,-1.0429200631100d-02,
     |  -1.4745510361148d-03,-1.2139793515282d-04,-4.6028909370513d-06,
     |  -4.9710174110849d-08,-4.3948662646925d-11,-9.7570023917591d-18/
      data (pmn(lat,15,17), lat = 1,36)/
     |   1.3914923020682d-19, 1.8919394087879d-12, 3.6114956617495d-09,
     |   4.7726008105529d-07, 1.6620005138539d-05, 2.5549872746220d-04,
     |   2.2330743233594d-03, 1.2785427646055d-02, 5.2252188302962d-02,
     |   1.6087871164170d-01, 3.8578919801695d-01, 7.3318616668236d-01,
     |   1.1057900054480d+00, 1.2933906275684d+00, 1.0785062243950d+00,
     |   4.2154435897808d-01,-4.2586402042616d-01,-1.0224103148176d+00,
     |  -1.0224103148176d+00,-4.2586402042616d-01, 4.2154435897808d-01,
     |   1.0785062243950d+00, 1.2933906275684d+00, 1.1057900054480d+00,
     |   7.3318616668236d-01, 3.8578919801695d-01, 1.6087871164170d-01,
     |   5.2252188302962d-02, 1.2785427646055d-02, 2.2330743233595d-03,
     |   2.5549872746220d-04, 1.6620005138539d-05, 4.7726008105530d-07,
     |   3.6114956617496d-09, 1.8919394087879d-12, 1.3914923020682d-19/
      data (pmn(lat,16,17), lat = 1,36)/
     |   1.5424879511945d-21, 6.3269384450245d-14, 2.0357847949986d-10,
     |   3.8322224511965d-08, 1.7571638447073d-06, 3.4054998399645d-05,
     |   3.6581029126352d-04, 2.5373655745082d-03, 1.2483224020600d-02,
     |   4.6295612954164d-02, 1.3479567101319d-01, 3.1655263764625d-01,
     |   6.0958002382213d-01, 9.6927617703756d-01, 1.2665320163637d+00,
     |   1.3255719454412d+00, 1.0227207583998d+00, 3.8621142926986d-01,
     |  -3.8621142926986d-01,-1.0227207583998d+00,-1.3255719454412d+00,
     |  -1.2665320163637d+00,-9.6927617703756d-01,-6.0958002382213d-01,
     |  -3.1655263764625d-01,-1.3479567101319d-01,-4.6295612954164d-02,
     |  -1.2483224020600d-02,-2.5373655745082d-03,-3.6581029126352d-04,
     |  -3.4054998399645d-05,-1.7571638447073d-06,-3.8322224511966d-08,
     |  -2.0357847949986d-10,-6.3269384450245d-14,-1.5424879511945d-21/
      data (pmn(lat,17,17), lat = 1,36)/
     |   1.1549825755501d-23, 1.4285098957951d-15, 7.7401191345758d-12,
     |   2.0722089966910d-09, 1.2482371813646d-07, 3.0403114951299d-06,
     |   3.9967206360823d-05, 3.3390587314056d-04, 1.9617324115520d-03,
     |   8.6645880278578d-03, 3.0127008725427d-02, 8.5215607789713d-02,
     |   2.0082352793137d-01, 4.0131349640491d-01, 6.8889718738320d-01,
     |   1.0254361130647d+00, 1.3322585311760d+00, 1.5170243534235d+00,
     |   1.5170243534235d+00, 1.3322585311760d+00, 1.0254361130647d+00,
     |   6.8889718738320d-01, 4.0131349640491d-01, 2.0082352793137d-01,
     |   8.5215607789713d-02, 3.0127008725427d-02, 8.6645880278578d-03,
     |   1.9617324115521d-03, 3.3390587314056d-04, 3.9967206360824d-05,
     |   3.0403114951299d-06, 1.2482371813646d-07, 2.0722089966911d-09,
     |   7.7401191345761d-12, 1.4285098957951d-15, 1.1549825755501d-23/
      data (pmn(lat, 0,18), lat = 1,36)/
     |   3.6289492556681d+00,-3.8131300663288d-02,-1.7034830585740d+00,
     |   1.9058845538042d-01, 1.2673706118693d+00,-2.6414243130473d-01,
     |  -1.0475234867248d+00, 3.2005170977213d-01, 9.0692859465079d-01,
     |  -3.6886431093692d-01,-8.0521624332865d-01, 4.1450714025531d-01,
     |   7.2563439447989d-01,-4.5915310611028d-01,-6.5977148038667d-01,
     |   5.0440233218590d-01, 6.0282117145915d-01,-5.5173971869651d-01,
     |  -5.5173971869651d-01, 6.0282117145915d-01, 5.0440233218591d-01,
     |  -6.5977148038667d-01,-4.5915310611028d-01, 7.2563439447990d-01,
     |   4.1450714025532d-01,-8.0521624332865d-01,-3.6886431093692d-01,
     |   9.0692859465079d-01, 3.2005170977214d-01,-1.0475234867248d+00,
     |  -2.6414243130473d-01, 1.2673706118693d+00, 1.9058845538043d-01,
     |  -1.7034830585740d+00,-3.8131300663288d-02, 3.6289492556681d+00/
      data (pmn(lat, 1,18), lat = 1,36)/
     |   1.5981408876471d+00, 2.2211307156062d+00,-3.4164334298493d-01,
     |  -1.4295314504758d+00, 3.1386445304156d-01, 1.1317467022234d+00,
     |  -3.3819181068143d-01,-9.6077374059241d-01, 3.7215215670122d-01,
     |   8.4430209857853d-01,-4.0898057075622d-01,-7.5683988201959d-01,
     |   4.4741362425080d-01, 6.8675425760175d-01,-4.8759934284026d-01,
     |  -6.2785163193555d-01, 5.3024644091241d-01, 5.7646542630375d-01,
     |  -5.7646542630375d-01,-5.3024644091242d-01, 6.2785163193555d-01,
     |   4.8759934284026d-01,-6.8675425760175d-01,-4.4741362425079d-01,
     |   7.5683988201958d-01, 4.0898057075622d-01,-8.4430209857853d-01,
     |  -3.7215215670122d-01, 9.6077374059240d-01, 3.3819181068143d-01,
     |  -1.1317467022234d+00,-3.1386445304156d-01, 1.4295314504758d+00,
     |   3.4164334298494d-01,-2.2211307156062d+00,-1.5981408876471d+00/
      data (pmn(lat, 2,18), lat = 1,36)/
     |   3.3059396877948d-01, 1.8681778186971d+00, 1.5413352322932d+00,
     |  -6.8291809449331d-01,-1.1889047177583d+00, 5.0072865986863d-01,
     |   9.9302063240658d-01,-4.5680148275205d-01,-8.6554083203383d-01,
     |   4.5386286035081d-01, 7.7354229726048d-01,-4.6802210571209d-01,
     |  -7.0250297862336d-01, 4.9135591283494d-01, 6.4503375128507d-01,
     |  -5.2098111544088d-01,-5.9701980538816d-01, 5.5609006710755d-01,
     |   5.5609006710755d-01,-5.9701980538816d-01,-5.2098111544089d-01,
     |   6.4503375128506d-01, 4.9135591283495d-01,-7.0250297862337d-01,
     |  -4.6802210571210d-01, 7.7354229726048d-01, 4.5386286035081d-01,
     |  -8.6554083203383d-01,-4.5680148275205d-01, 9.9302063240657d-01,
     |   5.0072865986863d-01,-1.1889047177583d+00,-6.8291809449332d-01,
     |   1.5413352322932d+00, 1.8681778186971d+00, 3.3059396877948d-01/
      data (pmn(lat, 3,18), lat = 1,36)/
     |   4.4686936985290d-02, 8.6224711247529d-01, 1.8608338413873d+00,
     |   9.6536864766137d-01,-9.4207140711801d-01,-9.2856157649197d-01,
     |   6.8034170930015d-01, 8.3656726695021d-01,-5.8048331809146d-01,
     |  -7.5855848552013d-01, 5.4093316142879d-01, 6.9626705964254d-01,
     |  -5.2987118271672d-01,-6.4641691021262d-01, 5.3487392965391d-01,
     |   6.0637389733344d-01,-5.5054507204806d-01,-5.7458841305692d-01,
     |   5.7458841305692d-01, 5.5054507204806d-01,-6.0637389733343d-01,
     |  -5.3487392965391d-01, 6.4641691021262d-01, 5.2987118271672d-01,
     |  -6.9626705964254d-01,-5.4093316142879d-01, 7.5855848552013d-01,
     |   5.8048331809147d-01,-8.3656726695021d-01,-6.8034170930016d-01,
     |   9.2856157649197d-01, 9.4207140711801d-01,-9.6536864766136d-01,
     |  -1.8608338413873d+00,-8.6224711247529d-01,-4.4686936985290d-02/
      data (pmn(lat, 4,18), lat = 1,36)/
     |   4.4648056157243d-03, 2.7811650677745d-01, 1.2170566894348d+00,
     |   1.7003639205896d+00, 4.4846735330122d-01,-1.0944135316253d+00,
     |  -6.4928421204374d-01, 8.2102851359086d-01, 6.6414027545485d-01,
     |  -6.8755123145957d-01,-6.4344885053757d-01, 6.1876437800519d-01,
     |   6.1775580163185d-01,-5.8423911397727d-01,-5.9516963577005d-01,
     |   5.7009669309044d-01, 5.7848324424675d-01,-5.6940864612085d-01,
     |  -5.6940864612085d-01, 5.7848324424675d-01, 5.7009669309044d-01,
     |  -5.9516963577005d-01,-5.8423911397727d-01, 6.1775580163186d-01,
     |   6.1876437800520d-01,-6.4344885053757d-01,-6.8755123145957d-01,
     |   6.6414027545485d-01, 8.2102851359086d-01,-6.4928421204373d-01,
     |  -1.0944135316253d+00, 4.4846735330122d-01, 1.7003639205896d+00,
     |   1.2170566894348d+00, 2.7811650677745d-01, 4.4648056157243d-03/
      data (pmn(lat, 5,18), lat = 1,36)/
     |   3.5155142670949d-04, 6.8909688397901d-02, 5.6366340797655d-01,
     |   1.4269738699420d+00, 1.4363926572329d+00, 2.7511735910820d-03,
     |  -1.1431112162709d+00,-3.6987210139151d-01, 9.1077419232425d-01,
     |   4.8704456130831d-01,-7.6773010614738d-01,-5.2912162994215d-01,
     |   6.7978215026421d-01, 5.4650871109555d-01,-6.2513896009158d-01,
     |  -5.5751392551471d-01, 5.9129547806921d-01, 5.7059880729748d-01,
     |  -5.7059880729748d-01,-5.9129547806921d-01, 5.5751392551471d-01,
     |   6.2513896009158d-01,-5.4650871109555d-01,-6.7978215026421d-01,
     |   5.2912162994215d-01, 7.6773010614738d-01,-4.8704456130831d-01,
     |  -9.1077419232426d-01, 3.6987210139151d-01, 1.1431112162709d+00,
     |  -2.7511735910820d-03,-1.4363926572329d+00,-1.4269738699420d+00,
     |  -5.6366340797655d-01,-6.8909688397901d-02,-3.5155142670949d-04/
      data (pmn(lat, 6,18), lat = 1,36)/
     |   2.2670575341291d-05, 1.3790466429694d-02, 2.0301227846242d-01,
     |   8.3482159647816d-01, 1.5076340836454d+00, 1.1148059005144d+00,
     |  -3.5622925902931d-01,-1.1069761347549d+00,-1.1199436918840d-01,
     |   9.5114706724226d-01, 3.2016698602399d-01,-8.1944057129779d-01,
     |  -4.2723697801189d-01, 7.2168559999535d-01, 4.9304333765525d-01,
     |  -6.4913431188761d-01,-5.4360934186732d-01, 5.9256595743152d-01,
     |   5.9256595743152d-01,-5.4360934186732d-01,-6.4913431188761d-01,
     |   4.9304333765525d-01, 7.2168559999535d-01,-4.2723697801189d-01,
     |  -8.1944057129780d-01, 3.2016698602399d-01, 9.5114706724226d-01,
     |  -1.1199436918840d-01,-1.1069761347549d+00,-3.5622925902932d-01,
     |   1.1148059005144d+00, 1.5076340836454d+00, 8.3482159647817d-01,
     |   2.0301227846242d-01, 1.3790466429694d-02, 2.2670575341291d-05/
      data (pmn(lat, 7,18), lat = 1,36)/
     |   1.2275762153069d-06, 2.2978613800572d-03, 5.9609664363797d-02,
     |   3.7915781933983d-01, 1.0568543846601d+00, 1.4808844516892d+00,
     |   7.7834637367360d-01,-6.2229287287502d-01,-1.0134878578017d+00,
     |   1.0714849148310d-01, 9.5314124568629d-01, 1.7791953761170d-01,
     |  -8.4733153570861d-01,-3.5022557707687d-01, 7.4522220467397d-01,
     |   4.6885137299056d-01,-6.5258887376323d-01,-5.6397425118228d-01,
     |   5.6397425118228d-01, 6.5258887376323d-01,-4.6885137299056d-01,
     |  -7.4522220467397d-01, 3.5022557707687d-01, 8.4733153570861d-01,
     |  -1.7791953761170d-01,-9.5314124568629d-01,-1.0714849148310d-01,
     |   1.0134878578017d+00, 6.2229287287502d-01,-7.7834637367359d-01,
     |  -1.4808844516892d+00,-1.0568543846601d+00,-3.7915781933983d-01,
     |  -5.9609664363798d-02,-2.2978613800572d-03,-1.2275762153069d-06/
      data (pmn(lat, 8,18), lat = 1,36)/
     |   5.6752171975192d-08, 3.2510209060741d-04, 1.4668667133895d-02,
     |   1.4049318589025d-01, 5.6811061759458d-01, 1.2132270587213d+00,
     |   1.3762617932519d+00, 4.6238021819717d-01,-8.0090848131380d-01,
     |  -8.9286879288394d-01, 2.7754661425772d-01, 9.3309027967398d-01,
     |   7.2415736649453d-02,-8.5923106598708d-01,-3.1045165555850d-01,
     |   7.5087934390433d-01, 4.8563189885287d-01,-6.2728042220928d-01,
     |  -6.2728042220928d-01, 4.8563189885287d-01, 7.5087934390433d-01,
     |  -3.1045165555850d-01,-8.5923106598708d-01, 7.2415736649458d-02,
     |   9.3309027967398d-01, 2.7754661425772d-01,-8.9286879288394d-01,
     |  -8.0090848131380d-01, 4.6238021819717d-01, 1.3762617932519d+00,
     |   1.2132270587213d+00, 5.6811061759458d-01, 1.4049318589025d-01,
     |   1.4668667133895d-02, 3.2510209060741d-04, 5.6752171975192d-08/
      data (pmn(lat, 9,18), lat = 1,36)/
     |   2.2649857091908d-09, 3.9555707935262d-05, 3.0773736100460d-03,
     |   4.3650979135623d-02, 2.4779067775759d-01, 7.4522957116917d-01,
     |   1.3024684809864d+00, 1.2272209256446d+00, 1.9200859432468d-01,
     |  -9.0694710040542d-01,-7.7360193824683d-01, 3.9571206219410d-01,
     |   9.0878324308189d-01, 1.3898117050860d-02,-8.6229858196473d-01,
     |  -3.2045062620900d-01, 7.3390159199503d-01, 5.5377595952121d-01,
     |  -5.5377595952121d-01,-7.3390159199503d-01, 3.2045062620899d-01,
     |   8.6229858196473d-01,-1.3898117050858d-02,-9.0878324308189d-01,
     |  -3.9571206219411d-01, 7.7360193824683d-01, 9.0694710040542d-01,
     |  -1.9200859432467d-01,-1.2272209256446d+00,-1.3024684809864d+00,
     |  -7.4522957116917d-01,-2.4779067775759d-01,-4.3650979135624d-02,
     |  -3.0773736100460d-03,-3.9555707935262d-05,-2.2649857091908d-09/
      data (pmn(lat,10,18), lat = 1,36)/
     |   7.8571659237187d-11, 4.1718021864161d-06, 5.5621499282268d-04,
     |   1.1555591059026d-02, 9.0266927788513d-02, 3.6744153498744d-01,
     |   8.9364023439874d-01, 1.3348782828232d+00, 1.0666157588421d+00,
     |  -1.8130883988714d-02,-9.6037357397252d-01,-6.7998976483822d-01,
     |   4.6146785218010d-01, 8.9591623391075d-01, 1.3063124277744d-02,
     |  -8.5778823732514d-01,-3.9312001516192d-01, 6.7671262971605d-01,
     |   6.7671262971605d-01,-3.9312001516192d-01,-8.5778823732514d-01,
     |   1.3063124277742d-02, 8.9591623391075d-01, 4.6146785218010d-01,
     |  -6.7998976483822d-01,-9.6037357397252d-01,-1.8130883988714d-02,
     |   1.0666157588421d+00, 1.3348782828232d+00, 8.9364023439874d-01,
     |   3.6744153498744d-01, 9.0266927788513d-02, 1.1555591059026d-02,
     |   5.5621499282270d-04, 4.1718021864161d-06, 7.8571659237187d-11/
      data (pmn(lat,11,18), lat = 1,36)/
     |   2.3768946427340d-12, 3.8290764699835d-07, 8.7100965382137d-05,
     |   2.6297552855158d-03, 2.7897217841756d-02, 1.5013707123208d-01,
     |   4.8443129093028d-01, 1.0052437556779d+00, 1.3283021091697d+00,
     |   9.2341649364045d-01,-1.6136649219328d-01,-9.8123717533386d-01,
     |  -6.3171443218674d-01, 4.7279424085813d-01, 9.0410659406631d-01,
     |   8.4276047279926d-02,-8.3283936219589d-01,-5.3835654514786d-01,
     |   5.3835654514786d-01, 8.3283936219589d-01,-8.4276047279921d-02,
     |  -9.0410659406631d-01,-4.7279424085813d-01, 6.3171443218674d-01,
     |   9.8123717533386d-01, 1.6136649219328d-01,-9.2341649364045d-01,
     |  -1.3283021091698d+00,-1.0052437556779d+00,-4.8443129093028d-01,
     |  -1.5013707123208d-01,-2.7897217841756d-02,-2.6297552855158d-03,
     |  -8.7100965382139d-05,-3.8290764699835d-07,-2.3768946427340d-12/
      data (pmn(lat,12,18), lat = 1,36)/
     |   6.2697235992605d-14, 3.0597063189854d-08, 1.1834698051780d-05,
     |   5.1629884463675d-04, 7.3693229098877d-03, 5.1639755307945d-02,
     |   2.1511988530868d-01, 5.8579951368322d-01, 1.0795879159727d+00,
     |   1.3036427637038d+00, 8.2144820770573d-01,-2.3429650911149d-01,
     |  -9.8427933923228d-01,-6.4436653419054d-01, 4.1903748940046d-01,
     |   9.2996542080733d-01, 2.4674172327665d-01,-7.4696098773590d-01,
     |  -7.4696098773590d-01, 2.4674172327665d-01, 9.2996542080733d-01,
     |   4.1903748940046d-01,-6.4436653419054d-01,-9.8427933923228d-01,
     |  -2.3429650911149d-01, 8.2144820770573d-01, 1.3036427637038d+00,
     |   1.0795879159727d+00, 5.8579951368322d-01, 2.1511988530868d-01,
     |   5.1639755307945d-02, 7.3693229098877d-03, 5.1629884463676d-04,
     |   1.1834698051780d-05, 3.0597063189854d-08, 6.2697235992605d-14/
      data (pmn(lat,13,18), lat = 1,36)/
     |   1.4365034578505d-15, 2.1210652909767d-09, 1.3913915713073d-06,
     |   8.7328575359628d-05, 1.6657476882720d-03, 1.5037507892797d-02,
     |   7.9484027361999d-02, 2.7532445668083d-01, 6.6189153307167d-01,
     |   1.1209755183366d+00, 1.2806756880526d+00, 7.7995422743913d-01,
     |  -2.3044051311528d-01,-9.7206272395237d-01,-7.2816312205720d-01,
     |   2.7325966295508d-01, 9.4210571403062d-01, 5.1464448637575d-01,
     |  -5.1464448637575d-01,-9.4210571403062d-01,-2.7325966295508d-01,
     |   7.2816312205720d-01, 9.7206272395237d-01, 2.3044051311528d-01,
     |  -7.7995422743913d-01,-1.2806756880526d+00,-1.1209755183366d+00,
     |  -6.6189153307167d-01,-2.7532445668083d-01,-7.9484027361999d-02,
     |  -1.5037507892797d-02,-1.6657476882720d-03,-8.7328575359629d-05,
     |  -1.3913915713074d-06,-2.1210652909767d-09,-1.4365034578505d-15/
      data (pmn(lat,14,18), lat = 1,36)/
     |   2.8342091025250d-17, 1.2649453844813d-10, 1.4044024907630d-07,
     |   1.2638421772033d-05, 3.2050256020522d-04, 3.6986011865864d-03,
     |   2.4511140880010d-02, 1.0592168041750d-01, 3.2072674805669d-01,
     |   7.0577991655444d-01, 1.1342348858966d+00, 1.2739555799933d+00,
     |   8.1466812707465d-01,-1.3287043114688d-01,-9.2371886553721d-01,
     |  -8.7816070772240d-01,-1.1092766276586d-02, 8.5155442380669d-01,
     |   8.5155442380669d-01,-1.1092766276584d-02,-8.7816070772240d-01,
     |  -9.2371886553721d-01,-1.3287043114688d-01, 8.1466812707466d-01,
     |   1.2739555799933d+00, 1.1342348858966d+00, 7.0577991655444d-01,
     |   3.2072674805669d-01, 1.0592168041750d-01, 2.4511140880010d-02,
     |   3.6986011865864d-03, 3.2050256020522d-04, 1.2638421772033d-05,
     |   1.4044024907630d-07, 1.2649453844813d-10, 2.8342091025250d-17/
      data (pmn(lat,15,18), lat = 1,36)/
     |   4.7400038295094d-19, 6.3895165907658d-12, 1.1986534043004d-08,
     |   1.5424905025146d-06, 5.1796699040017d-05, 7.5962341429293d-04,
     |   6.2573697129393d-03, 3.3292829203029d-02, 1.2429074246410d-01,
     |   3.4197943270768d-01, 7.1109021800700d-01, 1.1192366986465d+00,
     |   1.2872494575296d+00, 9.3607651594558d-01, 9.1885810321570d-02,
     |  -7.7530975202913d-01,-1.0407833527574d+00,-4.7599483642139d-01,
     |   4.7599483642139d-01, 1.0407833527574d+00, 7.7530975202913d-01,
     |  -9.1885810321569d-02,-9.3607651594557d-01,-1.2872494575296d+00,
     |  -1.1192366986465d+00,-7.1109021800700d-01,-3.4197943270768d-01,
     |  -1.2429074246410d-01,-3.3292829203029d-02,-6.2573697129394d-03,
     |  -7.5962341429293d-04,-5.1796699040017d-05,-1.5424905025147d-06,
     |  -1.1986534043005d-08,-6.3895165907658d-12,-4.7400038295094d-19/
      data (pmn(lat,16,18), lat = 1,36)/
     |   6.5324362726635d-21, 2.6578595436823d-13, 8.4134948592510d-10,
     |   1.5448624244445d-07, 6.8473384318947d-06, 1.2703569418353d-04,
     |   1.2922931476108d-03, 8.3859887666533d-03, 3.8053006037403d-02,
     |   1.2794672304640d-01, 3.3049092598743d-01, 6.6877903721300d-01,
     |   1.0637318843098d+00, 1.3028987817926d+00, 1.1368741728527d+00,
     |   4.8842368125844d-01,-3.9439612910216d-01,-1.0304551593207d+00,
     |  -1.0304551593207d+00,-3.9439612910216d-01, 4.8842368125844d-01,
     |   1.1368741728527d+00, 1.3028987817926d+00, 1.0637318843098d+00,
     |   6.6877903721300d-01, 3.3049092598743d-01, 1.2794672304640d-01,
     |   3.8053006037403d-02, 8.3859887666534d-03, 1.2922931476108d-03,
     |   1.2703569418353d-04, 6.8473384318947d-06, 1.5448624244445d-07,
     |   8.4134948592513d-10, 2.6578595436823d-13, 6.5324362726635d-21/
      data (pmn(lat,17,18), lat = 1,36)/
     |   7.0187980289568d-23, 8.6149484180039d-15, 4.5965291694182d-11,
     |   1.2021368732439d-08, 7.0147681715357d-07, 1.6403928495055d-05,
     |   2.0503775911434d-04, 1.6113562750048d-03, 8.7977479157869d-03,
     |   3.5606732867349d-02, 1.1155884342148d-01, 2.7850726723398d-01,
     |   5.6405448140043d-01, 9.3416649807832d-01, 1.2600769804228d+00,
     |   1.3500387080711d+00, 1.0577597586054d+00, 4.0250657257225d-01,
     |  -4.0250657257225d-01,-1.0577597586054d+00,-1.3500387080711d+00,
     |  -1.2600769804228d+00,-9.3416649807832d-01,-5.6405448140043d-01,
     |  -2.7850726723398d-01,-1.1155884342148d-01,-3.5606732867349d-02,
     |  -8.7977479157870d-03,-1.6113562750048d-03,-2.0503775911434d-04,
     |  -1.6403928495055d-05,-7.0147681715357d-07,-1.2021368732439d-08,
     |  -4.5965291694184d-11,-8.6149484180039d-15,-7.0187980289568d-23/
      data (pmn(lat,18,18), lat = 1,36)/
     |   5.1074556671442d-25, 1.8902991263613d-16, 1.6983766392377d-12,
     |   6.3172050033427d-10, 4.8426868559220d-08, 1.4232241123554d-06,
     |   2.1770576445726d-05, 2.0607285951007d-04, 1.3436084460637d-03,
     |   6.4763217122402d-03, 2.4231052551950d-02, 7.2861473416598d-02,
     |   1.8058976290137d-01, 3.7587957152921d-01, 6.6607560028111d-01,
     |   1.0149385134615d+00, 1.3390805061170d+00, 1.5364860283163d+00,
     |   1.5364860283163d+00, 1.3390805061170d+00, 1.0149385134615d+00,
     |   6.6607560028111d-01, 3.7587957152921d-01, 1.8058976290137d-01,
     |   7.2861473416599d-02, 2.4231052551950d-02, 6.4763217122402d-03,
     |   1.3436084460637d-03, 2.0607285951007d-04, 2.1770576445726d-05,
     |   1.4232241123554d-06, 4.8426868559220d-08, 6.3172050033429d-10,
     |   1.6983766392378d-12, 1.8902991263613d-16, 5.1074556671442d-25/
      data (pmn(lat, 0,19), lat = 1,36)/
     |   3.6525318135704d+00,-3.2852285694315d-01,-1.6335683818444d+00,
     |   6.1617797331139d-01, 1.0821019201708d+00,-7.6275687759750d-01,
     |  -7.2545470302622d-01, 8.4515218100903d-01, 4.3524843740720d-01,
     |  -8.7788955635013d-01,-1.7902322678098d-01, 8.6651274951171d-01,
     |  -5.2581174125193d-02,-8.1442349374028d-01, 2.6101226407600d-01,
     |   7.2461734710931d-01,-4.4455351220709d-01,-6.0021543532866d-01,
     |   6.0021543532866d-01, 4.4455351220710d-01,-7.2461734710931d-01,
     |  -2.6101226407600d-01, 8.1442349374028d-01, 5.2581174125187d-02,
     |  -8.6651274951171d-01, 1.7902322678098d-01, 8.7788955635013d-01,
     |  -4.3524843740720d-01,-8.4515218100904d-01, 7.2545470302622d-01,
     |   7.6275687759750d-01,-1.0821019201708d+00,-6.1617797331140d-01,
     |   1.6335683818444d+00, 3.2852285694315d-01,-3.6525318135704d+00/
      data (pmn(lat, 1,19), lat = 1,36)/
     |   1.7134847402859d+00, 2.1398618749325d+00,-6.9381843142683d-01,
     |  -1.2705518908771d+00, 7.6775890520589d-01, 8.5570704493696d-01,
     |  -8.4102226922375d-01,-5.4743755739322d-01, 8.8036756777092d-01,
     |   2.8342477480926d-01,-8.8174732579245d-01,-4.6243261178333d-02,
     |   8.4529862933310d-01,-1.6851594329972d-01,-7.7246992867399d-01,
     |   3.6042173862888d-01, 6.6547823324861d-01,-5.2709595739883d-01,
     |  -5.2709595739883d-01, 6.6547823324861d-01, 3.6042173862888d-01,
     |  -7.7246992867399d-01,-1.6851594329972d-01, 8.4529862933310d-01,
     |  -4.6243261178324d-02,-8.8174732579245d-01, 2.8342477480925d-01,
     |   8.8036756777093d-01,-5.4743755739322d-01,-8.4102226922376d-01,
     |   8.5570704493696d-01, 7.6775890520589d-01,-1.2705518908771d+00,
     |  -6.9381843142684d-01, 2.1398618749325d+00, 1.7134847402859d+00/
      data (pmn(lat, 2,19), lat = 1,36)/
     |   3.7493413250097d-01, 2.0014079940128d+00, 1.3159444743230d+00,
     |  -1.0323342372857d+00,-8.9428984730942d-01, 9.3386777661685d-01,
     |   5.9156995971656d-01,-9.2077530740706d-01,-3.3756680501449d-01,
     |   9.0692513197993d-01, 1.0989629163654d-01,-8.7183262608518d-01,
     |   9.7985970970697d-02, 8.0939479811925d-01,-2.8675649097362d-01,
     |  -7.1831220227821d-01, 4.5474056500242d-01, 5.9943383793118d-01,
     |  -5.9943383793118d-01,-4.5474056500243d-01, 7.1831220227820d-01,
     |   2.8675649097362d-01,-8.0939479811925d-01,-9.7985970970692d-02,
     |   8.7183262608518d-01,-1.0989629163654d-01,-9.0692513197993d-01,
     |   3.3756680501449d-01, 9.2077530740706d-01,-5.9156995971655d-01,
     |  -9.3386777661685d-01, 8.9428984730942d-01, 1.0323342372857d+00,
     |  -1.3159444743230d+00,-2.0014079940128d+00,-3.7493413250097d-01/
      data (pmn(lat, 3,19), lat = 1,36)/
     |   5.3552858322217d-02, 9.9307426066656d-01, 1.9252591394821d+00,
     |   6.0011999936868d-01,-1.2184119587461d+00,-4.8922044779870d-01,
     |   1.0375704267610d+00, 3.0215975734206d-01,-9.6125876995770d-01,
     |  -1.1304738281034d-01, 9.0389166692697d-01,-6.8390162647042d-02,
     |  -8.3925662169509d-01, 2.3875870522877d-01, 7.5788901626561d-01,
     |  -3.9528165619095d-01,-6.5664472894519d-01, 5.3532041165143d-01,
     |   5.3532041165143d-01,-6.5664472894519d-01,-3.9528165619096d-01,
     |   7.5788901626561d-01, 2.3875870522877d-01,-8.3925662169509d-01,
     |  -6.8390162647051d-02, 9.0389166692697d-01,-1.1304738281033d-01,
     |  -9.6125876995770d-01, 3.0215975734206d-01, 1.0375704267610d+00,
     |  -4.8922044779870d-01,-1.2184119587461d+00, 6.0011999936867d-01,
     |   1.9252591394821d+00, 9.9307426066656d-01, 5.3552858322217d-02/
      data (pmn(lat, 4,19), lat = 1,36)/
     |   5.6555173415905d-03, 3.4162474465661d-01, 1.3895682926906d+00,
     |   1.6360259251637d+00,-1.8469034132268d-02,-1.2353877307990d+00,
     |  -8.6974622152264d-02, 1.0514151949190d+00, 1.2200809652315d-02,
     |  -9.4668830012348d-01, 1.0614372498353d-01, 8.6528396825416d-01,
     |  -2.3542812837421d-01,-7.8503424260799d-01, 3.6382510030299d-01,
     |   6.9673558152560d-01,-4.8547146896546d-01,-5.9699048490936d-01,
     |   5.9699048490936d-01, 4.8547146896546d-01,-6.9673558152560d-01,
     |  -3.6382510030299d-01, 7.8503424260799d-01, 2.3542812837421d-01,
     |  -8.6528396825416d-01,-1.0614372498353d-01, 9.4668830012348d-01,
     |  -1.2200809652312d-02,-1.0514151949190d+00, 8.6974622152256d-02,
     |   1.2353877307990d+00, 1.8469034132268d-02,-1.6360259251637d+00,
     |  -1.3895682926906d+00,-3.4162474465661d-01,-5.6555173415905d-03/
      data (pmn(lat, 5,19), lat = 1,36)/
     |   4.7113728958001d-04, 9.0057087555132d-02, 6.9626113659424d-01,
     |   1.5810435887781d+00, 1.2130754502768d+00,-5.0598480251914d-01,
     |  -1.1065987123499d+00, 2.7224145974418d-01, 9.7749476883149d-01,
     |  -2.5146512082647d-01,-8.7953867616566d-01, 3.0157188758423d-01,
     |   7.9685625696840d-01,-3.7850148497858d-01,-7.1789622846699d-01,
     |   4.6477667547716d-01, 6.3695238107547d-01,-5.5222577347162d-01,
     |  -5.5222577347162d-01, 6.3695238107547d-01, 4.6477667547717d-01,
     |  -7.1789622846699d-01,-3.7850148497859d-01, 7.9685625696841d-01,
     |   3.0157188758423d-01,-8.7953867616566d-01,-2.5146512082647d-01,
     |   9.7749476883150d-01, 2.7224145974418d-01,-1.1065987123499d+00,
     |  -5.0598480251914d-01, 1.2130754502768d+00, 1.5810435887781d+00,
     |   6.9626113659425d-01, 9.0057087555132d-02, 4.7113728958001d-04/
      data (pmn(lat, 6,19), lat = 1,36)/
     |   3.2193398718578d-05, 1.9170175436539d-02, 2.6945843295795d-01,
     |   1.0210922541813d+00, 1.5841459686507d+00, 7.3336252343279d-01,
     |  -8.4026362285810d-01,-8.7668534131000d-01, 5.5782709875350d-01,
     |   8.3694965429886d-01,-4.6839527555900d-01,-7.7486432699899d-01,
     |   4.6049677397447d-01, 7.1236736157313d-01,-4.8997613023291d-01,
     |  -6.5154245000419d-01, 5.3718104920049d-01, 5.9257114785962d-01,
     |  -5.9257114785962d-01,-5.3718104920049d-01, 6.5154245000419d-01,
     |   4.8997613023291d-01,-7.1236736157313d-01,-4.6049677397446d-01,
     |   7.7486432699899d-01, 4.6839527555900d-01,-8.3694965429886d-01,
     |  -5.5782709875351d-01, 8.7668534131000d-01, 8.4026362285811d-01,
     |  -7.3336252343279d-01,-1.5841459686507d+00,-1.0210922541813d+00,
     |  -2.6945843295795d-01,-1.9170175436539d-02,-3.2193398718578d-05/
      data (pmn(lat, 7,19), lat = 1,36)/
     |   1.8509378741478d-06, 3.4011527525665d-03, 8.4827152011343d-02,
     |   5.0494351208629d-01, 1.2618612377480d+00, 1.4344163902283d+00,
     |   2.6517428722227d-01,-1.0227698175805d+00,-5.9734831504133d-01,
     |   7.5647144740508d-01, 6.6042217137220d-01,-6.2908623065425d-01,
     |  -6.5441003621654d-01, 5.7775960267042d-01, 6.2969175527942d-01,
     |  -5.6723546876428d-01,-6.0199988293756d-01, 5.7883025733503d-01,
     |   5.7883025733503d-01,-6.0199988293756d-01,-5.6723546876429d-01,
     |   6.2969175527942d-01, 5.7775960267043d-01,-6.5441003621655d-01,
     |  -6.2908623065426d-01, 6.6042217137220d-01, 7.5647144740508d-01,
     |  -5.9734831504133d-01,-1.0227698175805d+00, 2.6517428722226d-01,
     |   1.4344163902283d+00, 1.2618612377480d+00, 5.0494351208629d-01,
     |   8.4827152011344d-02, 3.4011527525665d-03, 1.8509378741478d-06/
      data (pmn(lat, 8,19), lat = 1,36)/
     |   9.1101415092176d-08, 5.1339404865939d-04, 2.2383042658994d-02,
     |   2.0267302066740d-01, 7.5141477325998d-01, 1.3941183070894d+00,
     |   1.1819679058580d+00,-1.4127389893745d-01,-1.0767780306094d+00,
     |  -3.1570194469827d-01, 8.7255438577562d-01, 4.7971652870376d-01,
     |  -7.3530168972526d-01,-5.4146069492385d-01, 6.5487090118231d-01,
     |   5.6766217432972d-01,-6.1030669232686d-01,-5.8558200856632d-01,
     |   5.8558200856632d-01, 6.1030669232686d-01,-5.6766217432972d-01,
     |  -6.5487090118231d-01, 5.4146069492384d-01, 7.3530168972525d-01,
     |  -4.7971652870375d-01,-8.7255438577562d-01, 3.1570194469827d-01,
     |   1.0767780306094d+00, 1.4127389893745d-01,-1.1819679058580d+00,
     |  -1.3941183070894d+00,-7.5141477325998d-01,-2.0267302066740d-01,
     |  -2.2383042658994d-02,-5.1339404865939d-04,-9.1101415092176d-08/
      data (pmn(lat, 9,19), lat = 1,36)/
     |   3.8840900518218d-09, 6.6842992567581d-05, 5.0442003889541d-03,
     |   6.8134975397301d-02, 3.5964302685676d-01, 9.7035872950051d-01,
     |   1.4194901153587d+00, 8.8114711125328d-01,-4.5865044409300d-01,
     |  -1.0396102927498d+00,-6.6954495418083d-02, 9.2384205683794d-01,
     |   3.2222349243075d-01,-7.9704931232750d-01,-4.5759567835570d-01,
     |   6.9651571709232d-01, 5.4418588303173d-01,-6.1698356576218d-01,
     |  -6.1698356576219d-01, 5.4418588303173d-01, 6.9651571709233d-01,
     |  -4.5759567835570d-01,-7.9704931232750d-01, 3.2222349243076d-01,
     |   9.2384205683794d-01,-6.6954495418083d-02,-1.0396102927498d+00,
     |  -4.5865044409301d-01, 8.8114711125328d-01, 1.4194901153587d+00,
     |   9.7035872950051d-01, 3.5964302685676d-01, 6.8134975397301d-02,
     |   5.0442003889542d-03, 6.6842992567581d-05, 3.8840900518218d-09/
      data (pmn(lat,10,19), lat = 1,36)/
     |   1.4456400741457d-10, 7.5741927803465d-06, 9.8251996915941d-04,
     |   1.9545069005469d-02, 1.4335898613237d-01, 5.3355269426002d-01,
     |   1.1370523822141d+00, 1.3593763905108d+00, 5.8063474602880d-01,
     |  -6.8157154159563d-01,-9.5353025746086d-01, 1.2771749046803d-01,
     |   9.3507732667544d-01, 2.0904577081826d-01,-8.2739130506153d-01,
     |  -4.2179922802884d-01, 7.0468896970208d-01, 5.7500821317921d-01,
     |  -5.7500821317921d-01,-7.0468896970208d-01, 4.2179922802884d-01,
     |   8.2739130506153d-01,-2.0904577081826d-01,-9.3507732667544d-01,
     |  -1.2771749046804d-01, 9.5353025746086d-01, 6.8157154159563d-01,
     |  -5.8063474602880d-01,-1.3593763905108d+00,-1.1370523822141d+00,
     |  -5.3355269426002d-01,-1.4335898613237d-01,-1.9545069005470d-02,
     |  -9.8251996915943d-04,-7.5741927803465d-06,-1.4456400741457d-10/
      data (pmn(lat,11,19), lat = 1,36)/
     |   4.7184763962510d-12, 7.5092598011232d-07, 1.6660419464418d-04,
     |   4.8372400241015d-03, 4.8533337611299d-02, 2.4186759134070d-01,
     |   7.0128259406867d-01, 1.2430917310512d+00, 1.2465902688527d+00,
     |   3.1725431401076d-01,-8.2116976023622d-01,-8.5841288528694d-01,
     |   2.5853360201641d-01, 9.3143583682388d-01, 1.5671340915911d-01,
     |  -8.3566931343667d-01,-4.5105989628024d-01, 6.6998394152245d-01,
     |   6.6998394152245d-01,-4.5105989628024d-01,-8.3566931343667d-01,
     |   1.5671340915911d-01, 9.3143583682387d-01, 2.5853360201640d-01,
     |  -8.5841288528694d-01,-8.2116976023622d-01, 3.1725431401076d-01,
     |   1.2465902688527d+00, 1.2430917310512d+00, 7.0128259406867d-01,
     |   2.4186759134070d-01, 4.8533337611299d-02, 4.8372400241016d-03,
     |   1.6660419464418d-04, 7.5092598011232d-07, 4.7184763962510d-12/
      data (pmn(lat,12,19), lat = 1,36)/
     |   1.3527169815278d-13, 6.5277621966970d-08, 2.4677049006111d-05,
     |   1.0388979661935d-03, 1.4103872470421d-02, 9.2363868353749d-02,
     |   3.5139491470433d-01, 8.4479199659419d-01, 1.2946594767600d+00,
     |   1.1172825779784d+00, 1.1466683516398d-01,-8.9723923300736d-01,
     |  -7.8765724524788d-01, 3.2086082386785d-01, 9.3233844462056d-01,
     |   1.8129732787023d-01,-8.1823965063624d-01,-5.5910549878167d-01,
     |   5.5910549878167d-01, 8.1823965063624d-01,-1.8129732787023d-01,
     |  -9.3233844462056d-01,-3.2086082386785d-01, 7.8765724524789d-01,
     |   8.9723923300736d-01,-1.1466683516398d-01,-1.1172825779784d+00,
     |  -1.2946594767600d+00,-8.4479199659419d-01,-3.5139491470433d-01,
     |  -9.2363868353749d-02,-1.4103872470421d-02,-1.0388979661935d-03,
     |  -2.4677049006112d-05,-6.5277621966970d-08,-1.3527169815278d-13/
      data (pmn(lat,13,19), lat = 1,36)/
     |   3.4015434743918d-15, 4.9705387539490d-09, 3.1922961704898d-06,
     |   1.9391067766493d-04, 3.5338938288284d-03, 3.0024764631697d-02,
     |   1.4659943078694d-01, 4.5746282255844d-01, 9.5396403053348d-01,
     |   1.3079160246833d+00, 1.0051348730589d+00,-1.3376875257985d-02,
     |  -9.2953948036704d-01,-7.6694278249687d-01, 3.0649780754855d-01,
     |   9.4375003151246d-01, 3.0186751723595d-01,-7.4410764195543d-01,
     |  -7.4410764195543d-01, 3.0186751723594d-01, 9.4375003151246d-01,
     |   3.0649780754855d-01,-7.6694278249687d-01,-9.2953948036703d-01,
     |  -1.3376875257992d-02, 1.0051348730589d+00, 1.3079160246833d+00,
     |   9.5396403053348d-01, 4.5746282255844d-01, 1.4659943078694d-01,
     |   3.0024764631697d-02, 3.5338938288284d-03, 1.9391067766494d-04,
     |   3.1922961704899d-06, 4.9705387539490d-09, 3.4015434743918d-15/
      data (pmn(lat,14,19), lat = 1,36)/
     |   7.4664012857994d-17, 3.3001758584232d-10, 3.5925768717934d-07,
     |   3.1365914229967d-05, 7.6279664415594d-04, 8.3309701200335d-03,
     |   5.1437714626781d-02, 2.0303226719100d-01, 5.4658315151918d-01,
     |   1.0261091398635d+00, 1.3031374243984d+00, 9.3858594825251d-01,
     |  -5.6320811642837d-02,-9.2826424562920d-01,-8.1310247844745d-01,
     |   1.9375844713543d-01, 9.4373806353275d-01, 5.3465234854357d-01,
     |  -5.3465234854357d-01,-9.4373806353275d-01,-1.9375844713543d-01,
     |   8.1310247844745d-01, 9.2826424562920d-01, 5.6320811642833d-02,
     |  -9.3858594825251d-01,-1.3031374243984d+00,-1.0261091398635d+00,
     |  -5.4658315151918d-01,-2.0303226719100d-01,-5.1437714626781d-02,
     |  -8.3309701200335d-03,-7.6279664415594d-04,-3.1365914229968d-05,
     |  -3.5925768717935d-07,-3.3001758584232d-10,-7.4664012857994d-17/
      data (pmn(lat,15,19), lat = 1,36)/
     |   1.4171911028559d-18, 1.8930863301028d-11, 3.4866145834873d-08,
     |   4.3620427868186d-06, 1.4090820189949d-04, 1.9646700925160d-03,
     |   1.5179176194671d-02, 7.4521229842954d-02, 2.5143257879693d-01,
     |   6.0767804877545d-01, 1.0626000087779d+00, 1.2985250129439d+00,
     |   9.4021123105850d-01, 1.9827288641766d-03,-8.8133272091322d-01,
     |  -9.2626316324895d-01,-5.8962675583337d-02, 8.5318247998094d-01,
     |   8.5318247998094d-01,-5.8962675583336d-02,-9.2626316324895d-01,
     |  -8.8133272091322d-01, 1.9827288641756d-03, 9.4021123105851d-01,
     |   1.2985250129439d+00, 1.0626000087779d+00, 6.0767804877546d-01,
     |   2.5143257879693d-01, 7.4521229842954d-02, 1.5179176194671d-02,
     |   1.9646700925160d-03, 1.4090820189949d-04, 4.3620427868187d-06,
     |   3.4866145834874d-08, 1.8930863301028d-11, 1.4171911028559d-18/
      data (pmn(lat,16,19), lat = 1,36)/
     |   2.2883253111955d-20, 9.2312856843336d-13, 2.8721264562213d-09,
     |   5.1364080225829d-07, 2.1959079091472d-05, 3.8879826454477d-04,
     |   3.7296887593523d-03, 2.2508303382779d-02, 9.3401624814855d-02,
     |   2.8111553364067d-01, 6.3133163647501d-01, 1.0631944613981d+00,
     |   1.3030269815601d+00, 1.0249796863597d+00, 1.9143293906478d-01,
     |  -7.3416260196948d-01,-1.0596304370585d+00,-4.9471029983376d-01,
     |   4.9471029983376d-01, 1.0596304370585d+00, 7.3416260196949d-01,
     |  -1.9143293906478d-01,-1.0249796863597d+00,-1.3030269815601d+00,
     |  -1.0631944613981d+00,-6.3133163647501d-01,-2.8111553364067d-01,
     |  -9.3401624814856d-02,-2.2508303382779d-02,-3.7296887593524d-03,
     |  -3.8879826454477d-04,-2.1959079091472d-05,-5.1364080225830d-07,
     |  -2.8721264562214d-09,-9.2312856843336d-13,-2.2883253111955d-20/
      data (pmn(lat,17,19), lat = 1,36)/
     |   3.0541748254861d-22, 3.7186028521691d-14, 1.9520273924115d-10,
     |   4.9801240306393d-08, 2.8094519251166d-06, 6.2901784555796d-05,
     |   7.4474355616915d-04, 5.4772703892859d-03, 2.7594378857412d-02,
     |   1.0131477481558d-01, 2.8185824816513d-01, 6.0719842902952d-01,
     |   1.0181845171157d+00, 1.3050498257464d+00, 1.1892976516225d+00,
     |   5.5342639208610d-01,-3.6242585874280d-01,-1.0379002525137d+00,
     |  -1.0379002525137d+00,-3.6242585874280d-01, 5.5342639208610d-01,
     |   1.1892976516225d+00, 1.3050498257464d+00, 1.0181845171157d+00,
     |   6.0719842902952d-01, 2.8185824816513d-01, 1.0131477481558d-01,
     |   2.7594378857412d-02, 5.4772703892860d-03, 7.4474355616916d-04,
     |   6.2901784555796d-05, 2.8094519251166d-06, 4.9801240306394d-08,
     |   1.9520273924115d-10, 3.7186028521691d-14, 3.0541748254861d-22/
      data (pmn(lat,18,19), lat = 1,36)/
     |   3.1865692445812d-24, 1.1703921582532d-15, 1.0354945661160d-11,
     |   3.7625023144731d-09, 2.7940491176797d-07, 7.8837804327422d-06,
     |   1.1466514481326d-04, 1.0209859262768d-03, 6.1863703120893d-03,
     |   2.7323986608151d-02, 9.2119529435564d-02, 2.4448193649921d-01,
     |   5.2075210138032d-01, 8.9829852634039d-01, 1.2508281095692d+00,
     |   1.3718568209555d+00, 1.0915324718744d+00, 4.1854338327121d-01,
     |  -4.1854338327120d-01,-1.0915324718744d+00,-1.3718568209555d+00,
     |  -1.2508281095692d+00,-8.9829852634039d-01,-5.2075210138032d-01,
     |  -2.4448193649921d-01,-9.2119529435564d-02,-2.7323986608151d-02,
     |  -6.1863703120893d-03,-1.0209859262768d-03,-1.1466514481326d-04,
     |  -7.8837804327422d-06,-2.7940491176797d-07,-3.7625023144732d-09,
     |  -1.0354945661160d-11,-1.1703921582532d-15,-3.1865692445812d-24/
      data (pmn(lat,19,19), lat = 1,36)/
     |   2.2569642109480d-26, 2.4995895914279d-17, 3.7240136433587d-13,
     |   1.9244528714917d-10, 1.8774421022373d-08, 6.6576260534960d-07,
     |   1.1850234860366d-05, 1.2708913697256d-04, 9.1959494742778d-04,
     |   4.8372641510152d-03, 1.9475088473422d-02, 6.2254055195470d-02,
     |   1.6227908749355d-01, 3.5180707919783d-01, 6.4355183299640d-01,
     |   1.0038336531438d+00, 1.3449797918213d+00, 1.5550901541775d+00,
     |   1.5550901541775d+00, 1.3449797918213d+00, 1.0038336531438d+00,
     |   6.4355183299640d-01, 3.5180707919783d-01, 1.6227908749355d-01,
     |   6.2254055195471d-02, 1.9475088473422d-02, 4.8372641510152d-03,
     |   9.1959494742778d-04, 1.2708913697256d-04, 1.1850234860367d-05,
     |   6.6576260534960d-07, 1.8774421022373d-08, 1.9244528714918d-10,
     |   3.7240136433589d-13, 2.4995895914279d-17, 2.2569642109480d-26/
      data (pmn(lat, 0,20), lat = 1,36)/
     |   3.6667579559057d+00,-6.1308840585485d-01,-1.4851550346732d+00,
     |   9.8435651706100d-01, 7.3142527450739d-01,-1.0885729475348d+00,
     |  -1.7574324507944d-01, 1.0205269588781d+00,-2.6536220915116d-01,
     |  -8.1693966148818d-01, 5.8734670006697d-01, 5.1634174716067d-01,
     |  -7.7420230028604d-01,-1.6396931625715d-01, 8.1672051008030d-01,
     |  -1.9084561255259d-01,-7.1885701922655d-01, 4.9941266478554d-01,
     |   4.9941266478554d-01,-7.1885701922655d-01,-1.9084561255260d-01,
     |   8.1672051008030d-01,-1.6396931625715d-01,-7.7420230028604d-01,
     |   5.1634174716066d-01, 5.8734670006697d-01,-8.1693966148818d-01,
     |  -2.6536220915117d-01, 1.0205269588781d+00,-1.7574324507943d-01,
     |  -1.0885729475348d+00, 7.3142527450739d-01, 9.8435651706101d-01,
     |  -1.4851550346732d+00,-6.1308840585485d-01, 3.6667579559057d+00/
      data (pmn(lat, 1,20), lat = 1,36)/
     |   1.8289455250367d+00, 2.0261911077638d+00,-1.0144083582867d+00,
     |  -9.9638420557576d-01, 1.1061335919132d+00, 3.8783719509056d-01,
     |  -1.0817971937412d+00, 9.1237294783502d-02, 9.2725526252920d-01,
     |  -4.6089854972463d-01,-6.6561700966373d-01, 7.0702332488609d-01,
     |   3.3399610865794d-01,-8.1578215694294d-01, 2.2540999441989d-02,
     |   7.8395348516263d-01,-3.5630468428970d-01,-6.2243325384546d-01,
     |   6.2243325384546d-01, 3.5630468428970d-01,-7.8395348516263d-01,
     |  -2.2540999441990d-02, 8.1578215694294d-01,-3.3399610865795d-01,
     |  -7.0702332488610d-01, 6.6561700966373d-01, 4.6089854972463d-01,
     |  -9.2725526252920d-01,-9.1237294783505d-02, 1.0817971937412d+00,
     |  -3.8783719509056d-01,-1.1061335919132d+00, 9.9638420557575d-01,
     |   1.0144083582867d+00,-2.0261911077638d+00,-1.8289455250367d+00/
      data (pmn(lat, 2,20), lat = 1,36)/
     |   4.2226862935624d-01, 2.1200963511211d+00, 1.0410941520806d+00,
     |  -1.2958423516043d+00,-4.7194176180065d-01, 1.1640551339110d+00,
     |   1.0051424275278d-02,-1.0113340495571d+00, 3.6498569122284d-01,
     |   7.7757750083237d-01,-6.3871295556926d-01,-4.7351367005780d-01,
     |   7.9306051069590d-01, 1.3130587492427d-01,-8.1797681117842d-01,
     |   2.0830314195145d-01, 7.1598599080802d-01,-5.0326445163243d-01,
     |  -5.0326445163243d-01, 7.1598599080802d-01, 2.0830314195145d-01,
     |  -8.1797681117842d-01, 1.3130587492427d-01, 7.9306051069589d-01,
     |  -4.7351367005779d-01,-6.3871295556926d-01, 7.7757750083237d-01,
     |   3.6498569122285d-01,-1.0113340495571d+00, 1.0051424275269d-02,
     |   1.1640551339110d+00,-4.7194176180065d-01,-1.2958423516043d+00,
     |   1.0410941520806d+00, 2.1200963511211d+00, 4.2226862935624d-01/
      data (pmn(lat, 3,20), lat = 1,36)/
     |   6.3561595411864d-02, 1.1298647764125d+00, 1.9424945389617d+00,
     |   1.9322640598313d-01,-1.3354519557326d+00, 4.9892698844885d-02,
     |   1.0901124065608d+00,-3.5078091116160d-01,-8.5342012365877d-01,
     |   6.0319325650062d-01, 5.7247608552965d-01,-7.6973409702334d-01,
     |  -2.5444559134515d-01, 8.3040589001516d-01,-7.3351400753800d-02,
     |  -7.7865316342108d-01, 3.7655259449603d-01, 6.2111329331955d-01,
     |  -6.2111329331955d-01,-3.7655259449603d-01, 7.7865316342108d-01,
     |   7.3351400753802d-02,-8.3040589001516d-01, 2.5444559134516d-01,
     |   7.6973409702334d-01,-5.7247608552965d-01,-6.0319325650062d-01,
     |   8.5342012365877d-01, 3.5078091116161d-01,-1.0901124065608d+00,
     |  -4.9892698844885d-02, 1.3354519557326d+00,-1.9322640598311d-01,
     |  -1.9424945389617d+00,-1.1298647764125d+00,-6.3561595411864d-02/
      data (pmn(lat, 4,20), lat = 1,36)/
     |   7.0747882500073d-03, 4.1365745333921d-01, 1.5539884258734d+00,
     |   1.4873752068442d+00,-4.8229111802855d-01,-1.1441135161953d+00,
     |   4.9815739309981d-01, 8.8295041926517d-01,-6.4431019569768d-01,
     |  -6.1909038914700d-01, 7.7387675362806d-01, 3.3131968917008d-01,
     |  -8.3821584769663d-01,-3.0094892253401d-02, 8.1709947218586d-01,
     |  -2.6110593886436d-01,-7.0650568066105d-01, 5.1500678275653d-01,
     |   5.1500678275653d-01,-7.0650568066105d-01,-2.6110593886436d-01,
     |   8.1709947218586d-01,-3.0094892253399d-02,-8.3821584769663d-01,
     |   3.3131968917007d-01, 7.7387675362806d-01,-6.1909038914700d-01,
     |  -6.4431019569769d-01, 8.8295041926517d-01, 4.9815739309982d-01,
     |  -1.1441135161953d+00,-4.8229111802855d-01, 1.4873752068442d+00,
     |   1.5539884258734d+00, 4.1365745333921d-01, 7.0747882500073d-03/
      data (pmn(lat, 5,20), lat = 1,36)/
     |   6.2165187795809d-04, 1.1570863207840d-01, 8.4201220397333d-01,
     |   1.6917914859315d+00, 8.8299885892400d-01,-9.2951780217212d-01,
     |  -7.8817937330980d-01, 8.1454471019484d-01, 5.8065559778274d-01,
     |  -8.3611205652546d-01,-3.4064589791875d-01, 8.6182289972738d-01,
     |   8.2438430009015d-02,-8.4365512371711d-01, 1.7713347300442d-01,
     |   7.6324682971200d-01,-4.1750477373405d-01,-6.1829940462054d-01,
     |   6.1829940462054d-01, 4.1750477373405d-01,-7.6324682971200d-01,
     |  -1.7713347300442d-01, 8.4365512371711d-01,-8.2438430009021d-02,
     |  -8.6182289972739d-01, 3.4064589791875d-01, 8.3611205652546d-01,
     |  -5.8065559778274d-01,-8.1454471019484d-01, 7.8817937330979d-01,
     |   9.2951780217212d-01,-8.8299885892400d-01,-1.6917914859315d+00,
     |  -8.4201220397333d-01,-1.1570863207840d-01,-6.2165187795809d-04/
      data (pmn(lat, 6,20), lat = 1,36)/
     |   4.4860488072257d-05, 2.6118250181751d-02, 3.4944306366681d-01,
     |   1.2106927811454d+00, 1.5678876710188d+00, 2.5452163126064d-01,
     |  -1.1309810331796d+00,-3.5666933780936d-01, 9.7339180015651d-01,
     |   2.3901926934058d-01,-9.1609380021826d-01,-5.7522400430999d-02,
     |   8.7062490550842d-01,-1.4647432250516d-01,-7.9922807092021d-01,
     |   3.5011393729072d-01, 6.8767322963021d-01,-5.3523736373043d-01,
     |  -5.3523736373043d-01, 6.8767322963021d-01, 3.5011393729073d-01,
     |  -7.9922807092020d-01,-1.4647432250516d-01, 8.7062490550843d-01,
     |  -5.7522400430991d-02,-9.1609380021826d-01, 2.3901926934057d-01,
     |   9.7339180015652d-01,-3.5666933780935d-01,-1.1309810331796d+00,
     |   2.5452163126064d-01, 1.5678876710188d+00, 1.2106927811454d+00,
     |   3.4944306366682d-01, 2.6118250181751d-02, 4.4860488072257d-05/
      data (pmn(lat, 7,20), lat = 1,36)/
     |   2.7285096427992d-06, 4.9166850074630d-03, 1.1760080187460d-01,
     |   6.5155712482769d-01, 1.4393806305198d+00, 1.2459318546137d+00,
     |  -2.9513704285213d-01,-1.1142664352365d+00, 6.5847395928682d-02,
     |   9.8446256296073d-01,-8.7855415041429d-02,-8.9801403426956d-01,
     |   1.9599586430023d-01, 8.1949449263054d-01,-3.3545823557482d-01,
     |  -7.2736009318094d-01, 4.7995879168122d-01, 6.1361336199258d-01,
     |  -6.1361336199257d-01,-4.7995879168122d-01, 7.2736009318093d-01,
     |   3.3545823557482d-01,-8.1949449263054d-01,-1.9599586430022d-01,
     |   8.9801403426956d-01, 8.7855415041429d-02,-9.8446256296074d-01,
     |  -6.5847395928686d-02, 1.1142664352365d+00, 2.9513704285214d-01,
     |  -1.2459318546137d+00,-1.4393806305198d+00,-6.5155712482769d-01,
     |  -1.1760080187460d-01,-4.9166850074630d-03,-2.7285096427992d-06/
      data (pmn(lat, 8,20), lat = 1,36)/
     |   1.4238117949993d-07, 7.8863539391092d-04, 3.3153657191154d-02,
     |   2.8262255705217d-01, 9.5217761296307d-01, 1.4969147620986d+00,
     |   8.1257649216018d-01,-7.0211600314434d-01,-9.3920356854991d-01,
     |   4.1838340294130d-01, 8.8407654622159d-01,-3.6118702300037d-01,
     |  -8.1234091782366d-01, 3.9834963077473d-01, 7.3683918131991d-01,
     |  -4.7510988229978d-01,-6.5440579491706d-01, 5.6509245111307d-01,
     |   5.6509245111307d-01,-6.5440579491706d-01,-4.7510988229979d-01,
     |   7.3683918131991d-01, 3.9834963077473d-01,-8.1234091782367d-01,
     |  -3.6118702300038d-01, 8.8407654622159d-01, 4.1838340294131d-01,
     |  -9.3920356854991d-01,-7.0211600314434d-01, 8.1257649216017d-01,
     |   1.4969147620986d+00, 9.5217761296307d-01, 2.8262255705217d-01,
     |   3.3153657191154d-02, 7.8863539391092d-04, 1.4238117949993d-07/
      data (pmn(lat, 9,20), lat = 1,36)/
     |   6.4539173072462d-09, 1.0936176086883d-04, 7.9906388140123d-03,
     |   1.0243553146317d-01, 4.9952561565024d-01, 1.1920754567106d+00,
     |   1.3958202701911d+00, 3.5479433132415d-01,-9.4644280900083d-01,
     |  -6.7802029240028d-01, 6.7168853713664d-01, 7.2107027936759d-01,
     |  -5.6314905590205d-01,-6.9660133083562d-01, 5.4234566821904d-01,
     |   6.5355320385514d-01,-5.6476190076587d-01,-6.0639957044932d-01,
     |   6.0639957044932d-01, 5.6476190076587d-01,-6.5355320385514d-01,
     |  -5.4234566821905d-01, 6.9660133083562d-01, 5.6314905590205d-01,
     |  -7.2107027936758d-01,-6.7168853713664d-01, 6.7802029240028d-01,
     |   9.4644280900083d-01,-3.5479433132415d-01,-1.3958202701911d+00,
     |  -1.1920754567106d+00,-4.9952561565024d-01,-1.0243553146317d-01,
     |  -7.9906388140125d-03,-1.0936176086883d-04,-6.4539173072462d-09/
      data (pmn(lat,10,20), lat = 1,36)/
     |   2.5628770093458d-10, 1.3240647178925d-05, 1.6684284997828d-03,
     |   3.1688850015858d-02, 2.1714661996986d-01, 7.3184468079061d-01,
     |   1.3365459619942d+00, 1.1791646569062d+00,-5.8950230337638d-02,
     |  -1.0452594865400d+00,-3.9716985760070d-01, 8.2608395658608d-01,
     |   5.4372197312726d-01,-6.9497605214378d-01,-5.8722874511483d-01,
     |   6.3146143122142d-01, 5.9834298714755d-01,-6.0653363064651d-01,
     |  -6.0653363064652d-01, 5.9834298714755d-01, 6.3146143122143d-01,
     |  -5.8722874511483d-01,-6.9497605214379d-01, 5.4372197312727d-01,
     |   8.2608395658609d-01,-3.9716985760070d-01,-1.0452594865400d+00,
     |  -5.8950230337642d-02, 1.1791646569062d+00, 1.3365459619942d+00,
     |   7.3184468079061d-01, 2.1714661996986d-01, 3.1688850015859d-02,
     |   1.6684284997829d-03, 1.3240647178925d-05, 2.5628770093458d-10/
      data (pmn(lat,11,20), lat = 1,36)/
     |   8.9646061911503d-12, 1.4084863475734d-06, 3.0435540213191d-04,
     |   8.4768304569842d-03, 8.0107203224232d-02, 3.6702176261636d-01,
     |   9.4297590033381d-01, 1.3795331141573d+00, 9.0341881838478d-01,
     |  -3.8844197861502d-01,-1.0392004062159d+00,-1.4616053013643d-01,
     |   9.0254732773954d-01, 3.9172449645826d-01,-7.6988638410107d-01,
     |  -5.1528626817632d-01, 6.7217581005325d-01, 5.9557378958218d-01,
     |  -5.9557378958218d-01,-6.7217581005326d-01, 5.1528626817632d-01,
     |   7.6988638410107d-01,-3.9172449645826d-01,-9.0254732773953d-01,
     |   1.4616053013642d-01, 1.0392004062159d+00, 3.8844197861502d-01,
     |  -9.0341881838478d-01,-1.3795331141573d+00,-9.4297590033381d-01,
     |  -3.6702176261636d-01,-8.0107203224232d-02,-8.4768304569843d-03,
     |  -3.0435540213192d-04,-1.4084863475734d-06,-8.9646061911503d-12/
      data (pmn(lat,12,20), lat = 1,36)/
     |   2.7698735827059d-13, 1.3209351419868d-07, 4.8741575722174d-05,
     |   1.9758798164009d-03, 2.5423373328675d-02, 1.5470754796725d-01,
     |   5.3218887911669d-01, 1.1072820842536d+00, 1.3392552887022d+00,
     |   6.2301879050696d-01,-6.2166744839265d-01,-9.7776536801279d-01,
     |   4.4971260839361d-02, 9.3137649521858d-01, 2.9456039063846d-01,
     |  -8.0322748958183d-01,-5.0605603301434d-01, 6.6298328540605d-01,
     |   6.6298328540605d-01,-5.0605603301434d-01,-8.0322748958184d-01,
     |   2.9456039063846d-01, 9.3137649521858d-01, 4.4971260839356d-02,
     |  -9.7776536801279d-01,-6.2166744839265d-01, 6.2301879050696d-01,
     |   1.3392552887022d+00, 1.1072820842536d+00, 5.3218887911670d-01,
     |   1.5470754796725d-01, 2.5423373328675d-02, 1.9758798164009d-03,
     |   4.8741575722176d-05, 1.3209351419868d-07, 2.7698735827059d-13/
      data (pmn(lat,13,20), lat = 1,36)/
     |   7.5622763333933d-15, 1.0929942660326d-08, 6.8644747189028d-06,
     |   4.0275416206839d-04, 6.9912609968728d-03, 5.5637635600632d-02,
     |   2.4901588963548d-01, 6.9063320074846d-01, 1.2152484780897d+00,
     |   1.2489771044418d+00, 3.8080092295027d-01,-7.6743231894719d-01,
     |  -9.0810025539149d-01, 1.6070489494060d-01, 9.4130488156840d-01,
     |   2.7517029025136d-01,-8.0047422788323d-01,-5.7929975768699d-01,
     |   5.7929975768699d-01, 8.0047422788323d-01,-2.7517029025136d-01,
     |  -9.4130488156840d-01,-1.6070489494060d-01, 9.0810025539150d-01,
     |   7.6743231894720d-01,-3.8080092295027d-01,-1.2489771044418d+00,
     |  -1.2152484780897d+00,-6.9063320074846d-01,-2.4901588963548d-01,
     |  -5.5637635600632d-02,-6.9912609968728d-03,-4.0275416206839d-04,
     |  -6.8644747189030d-06,-1.0929942660326d-08,-7.5622763333933d-15/
      data (pmn(lat,14,20), lat = 1,36)/
     |   1.8200494825936d-16, 7.9628684025136d-10, 8.4901014200682d-07,
     |   7.1785396584341d-05, 1.6696044170729d-03, 1.7187210574306d-02,
     |   9.8251293126549d-02, 3.5068561171712d-01, 8.2459052720026d-01,
     |   1.2726531080446d+00, 1.1471954813541d+00, 2.0581705019724d-01,
     |  -8.4406498404419d-01,-8.6874577182797d-01, 1.8995996870559d-01,
     |   9.4877581268040d-01, 3.5537393697527d-01,-7.4088489402780d-01,
     |  -7.4088489402780d-01, 3.5537393697526d-01, 9.4877581268040d-01,
     |   1.8995996870559d-01,-8.6874577182797d-01,-8.4406498404419d-01,
     |   2.0581705019724d-01, 1.1471954813541d+00, 1.2726531080446d+00,
     |   8.2459052720026d-01, 3.5068561171712d-01, 9.8251293126550d-02,
     |   1.7187210574306d-02, 1.6696044170729d-03, 7.1785396584342d-05,
     |   8.4901014200684d-07, 7.9628684025136d-10, 1.8200494825936d-16/
      data (pmn(lat,15,20), lat = 1,36)/
     |   3.8399007155261d-18, 5.0804720126359d-11, 9.1770807441562d-08,
     |   1.1143782335589d-05, 3.4544433477231d-04, 4.5628131273207d-03,
     |   3.2890720156197d-02, 1.4781595856714d-01, 4.4500767375654d-01,
     |   9.2362016307739d-01, 1.2954575199285d+00, 1.0703418500008d+00,
     |   1.1775973422605d-01,-8.6637249552980d-01,-8.8636908105702d-01,
     |   1.1347151427727d-01, 9.4256877215822d-01, 5.5420992792079d-01,
     |  -5.5420992792079d-01,-9.4256877215822d-01,-1.1347151427728d-01,
     |   8.8636908105702d-01, 8.6637249552980d-01,-1.1775973422606d-01,
     |  -1.0703418500008d+00,-1.2954575199285d+00,-9.2362016307739d-01,
     |  -4.4500767375655d-01,-1.4781595856714d-01,-3.2890720156197d-02,
     |  -4.5628131273207d-03,-3.4544433477231d-04,-1.1143782335589d-05,
     |  -9.1770807441565d-08,-5.0804720126359d-11,-3.8399007155261d-18/
      data (pmn(lat,16,20), lat = 1,36)/
     |   7.0309179798957d-20, 2.8109055444246d-12, 8.5876202811067d-09,
     |   1.4935172998557d-06, 6.1449035014275d-05, 1.0350110461861d-03,
     |   9.3203909918977d-03, 5.1966809567889d-02, 1.9526595775192d-01,
     |   5.1785566340815d-01, 9.8362719109362d-01, 1.3024288324138d+00,
     |   1.0487694582060d+00, 1.3591008585177d-01,-8.3009658904103d-01,
     |  -9.6854441275637d-01,-1.0637061952573d-01, 8.5435401792527d-01,
     |   8.5435401792527d-01,-1.0637061952572d-01,-9.6854441275637d-01,
     |  -8.3009658904103d-01, 1.3591008585177d-01, 1.0487694582060d+00,
     |   1.3024288324138d+00, 9.8362719109362d-01, 5.1785566340815d-01,
     |   1.9526595775192d-01, 5.1966809567889d-02, 9.3203909918978d-03,
     |   1.0350110461861d-03, 6.1449035014275d-05, 1.4935172998557d-06,
     |   8.5876202811070d-09, 2.8109055444246d-12, 7.0309179798957d-20/
      data (pmn(lat,17,20), lat = 1,36)/
     |   1.0985863665419d-21, 1.3262629398041d-13, 6.8434989241706d-10,
     |   1.7007778878788d-07, 9.2567241215711d-06, 1.9785789188901d-04,
     |   2.2101265087604d-03, 1.5126653619491d-02, 6.9758463432700d-02,
     |   2.2960031586140d-01, 5.5665921379326d-01, 1.0021347007266d+00,
     |   1.3062027039970d+00, 1.1035341526579d+00, 2.8906099154769d-01,
     |  -6.8993784762256d-01,-1.0763212989361d+00,-5.1307654546079d-01,
     |   5.1307654546079d-01, 1.0763212989361d+00, 6.8993784762257d-01,
     |  -2.8906099154769d-01,-1.1035341526579d+00,-1.3062027039970d+00,
     |  -1.0021347007266d+00,-5.5665921379326d-01,-2.2960031586140d-01,
     |  -6.9758463432701d-02,-1.5126653619491d-02,-2.2101265087605d-03,
     |  -1.9785789188901d-04,-9.2567241215711d-06,-1.7007778878789d-07,
     |  -6.8434989241708d-10,-1.3262629398041d-13,-1.0985863665419d-21/
      data (pmn(lat,18,20), lat = 1,36)/
     |   1.4227364219152d-23, 5.1836809255748d-15, 4.5123594764080d-11,
     |   1.5995397553632d-08, 1.1484722213304d-06, 3.1030707818518d-05,
     |   4.2759598230513d-04, 3.5640270015608d-03, 1.9934221150696d-02,
     |   7.9916194907313d-02, 2.3942940035161d-01, 5.4901692921646d-01,
     |   9.7030439004971d-01, 1.3007249496758d+00, 1.2360441952167d+00,
     |   6.1649478121456d-01,-3.3003024277428d-01,-1.0447907890323d+00,
     |  -1.0447907890323d+00,-3.3003024277428d-01, 6.1649478121456d-01,
     |   1.2360441952167d+00, 1.3007249496758d+00, 9.7030439004971d-01,
     |   5.4901692921646d-01, 2.3942940035161d-01, 7.9916194907313d-02,
     |   1.9934221150696d-02, 3.5640270015608d-03, 4.2759598230513d-04,
     |   3.1030707818518d-05, 1.1484722213304d-06, 1.5995397553633d-08,
     |   4.5123594764082d-11, 5.1836809255748d-15, 1.4227364219152d-23/
      data (pmn(lat,19,20), lat = 1,36)/
     |   1.4437867499982d-25, 1.5868256139801d-16, 2.3280092676928d-12,
     |   1.1752187449816d-09, 1.1106413207675d-07, 3.7812922998632d-06,
     |   6.3995299794567d-05, 6.4560519073509d-04, 4.3412959103027d-03,
     |   2.0925463103124d-02, 7.5913409178218d-02, 2.1417861150317d-01,
     |   4.7979982489403d-01, 8.6205735822507d-01, 1.2391311198718d+00,
     |   1.3912027584985d+00, 1.1241010571581d+00, 4.3433723439069d-01,
     |  -4.3433723439069d-01,-1.1241010571581d+00,-1.3912027584985d+00,
     |  -1.2391311198718d+00,-8.6205735822507d-01,-4.7979982489402d-01,
     |  -2.1417861150317d-01,-7.5913409178218d-02,-2.0925463103124d-02,
     |  -4.3412959103028d-03,-6.4560519073510d-04,-6.3995299794568d-05,
     |  -3.7812922998632d-06,-1.1106413207675d-07,-1.1752187449816d-09,
     |  -2.3280092676929d-12,-1.5868256139801d-16,-1.4437867499982d-25/
      data (pmn(lat,20,20), lat = 1,36)/
     |   9.9670392100200d-28, 3.3031500988595d-18, 8.1603718062398d-14,
     |   5.8588316204472d-11, 7.2739137329482d-09, 3.1123392556696d-07,
     |   6.4462243218086d-06, 7.8328081792154d-05, 6.2898726894730d-04,
     |   3.6107101000162d-03, 1.5642567100617d-02, 5.3156792908828d-02,
     |   1.4573149280260d-01, 3.2906512163446d-01, 6.2139101014658d-01,
     |   9.9221364906062d-01, 1.3500388241640d+00, 1.5729102967051d+00,
     |   1.5729102967051d+00, 1.3500388241640d+00, 9.9221364906062d-01,
     |   6.2139101014658d-01, 3.2906512163446d-01, 1.4573149280260d-01,
     |   5.3156792908829d-02, 1.5642567100617d-02, 3.6107101000162d-03,
     |   6.2898726894730d-04, 7.8328081792155d-05, 6.4462243218087d-06,
     |   3.1123392556696d-07, 7.2739137329482d-09, 5.8588316204473d-11,
     |   8.1603718062402d-14, 3.3031500988595d-18, 9.9670392100200d-28/
      data (pmn(lat, 0,21), lat = 1,36)/
     |   3.6718210562406d+00,-8.8680966041573d-01,-1.2654639050702d+00,
     |   1.2608668319850d+00, 2.6898117148348d-01,-1.1678254863253d+00,
     |   4.2911913067973d-01, 7.7364114911669d-01,-8.2644125034113d-01,
     |  -2.2560487136774d-01, 8.9393374032871d-01,-3.1183479855131d-01,
     |  -6.6218828865925d-01, 6.8898606504305d-01, 2.3002609137428d-01,
     |  -8.0722809415940d-01, 2.5696029586045d-01, 6.4378868217426d-01,
     |  -6.4378868217426d-01,-2.5696029586046d-01, 8.0722809415940d-01,
     |  -2.3002609137428d-01,-6.8898606504305d-01, 6.6218828865926d-01,
     |   3.1183479855132d-01,-8.9393374032871d-01, 2.2560487136773d-01,
     |   8.2644125034113d-01,-7.7364114911669d-01,-4.2911913067974d-01,
     |   1.1678254863253d+00,-2.6898117148348d-01,-1.2608668319850d+00,
     |   1.2654639050702d+00, 8.8680966041573d-01,-3.6718210562406d+00/
      data (pmn(lat, 1,21), lat = 1,36)/
     |   1.9441878222093d+00, 1.8814614377479d+00,-1.2886552789608d+00,
     |  -6.3171527504174d-01, 1.2779177727058d+00,-1.6701451410345d-01,
     |  -9.8536277699845d-01, 6.9227985580408d-01, 4.8816277841396d-01,
     |  -9.0668762553353d-01, 7.0575931570483d-02, 8.0665318261174d-01,
     |  -5.3651748947431d-01,-4.5640332871737d-01, 7.8597036949151d-01,
     |  -2.0743950782520d-02,-7.5851348665536d-01, 4.7270330717352d-01,
     |   4.7270330717352d-01,-7.5851348665536d-01,-2.0743950782526d-02,
     |   7.8597036949151d-01,-4.5640332871737d-01,-5.3651748947431d-01,
     |   8.0665318261173d-01, 7.0575931570483d-02,-9.0668762553353d-01,
     |   4.8816277841396d-01, 6.9227985580408d-01,-9.8536277699845d-01,
     |  -1.6701451410345d-01, 1.2779177727058d+00,-6.3171527504173d-01,
     |  -1.2886552789608d+00, 1.8814614377479d+00, 1.9441878222093d+00/
      data (pmn(lat, 2,21), lat = 1,36)/
     |   4.7257674958849d-01, 2.2213890838821d+00, 7.2617035359135d-01,
     |  -1.4504363976151d+00, 1.8127972994104d-02, 1.1404437552374d+00,
     |  -5.7428241345020d-01,-6.9119088001761d-01, 8.7791381901903d-01,
     |   1.4861984810535d-01,-8.9082500408278d-01, 3.6043289788516d-01,
     |   6.3758203005266d-01,-7.0811109506458d-01,-2.0741669068073d-01,
     |   8.0855219206706d-01,-2.6683031052792d-01,-6.4326213874841d-01,
     |   6.4326213874840d-01, 2.6683031052792d-01,-8.0855219206706d-01,
     |   2.0741669068073d-01, 7.0811109506458d-01,-6.3758203005267d-01,
     |  -3.6043289788517d-01, 8.9082500408278d-01,-1.4861984810535d-01,
     |  -8.7791381901904d-01, 6.9119088001761d-01, 5.7428241345021d-01,
     |  -1.1404437552374d+00,-1.8127972994104d-02, 1.4504363976151d+00,
     |  -7.2617035359133d-01,-2.2213890838821d+00,-4.7257674958849d-01/
      data (pmn(lat, 3,21), lat = 1,36)/
     |   7.4784737149878d-02, 1.2709305009659d+00, 1.9078603154260d+00,
     |  -2.2721585541735d-01,-1.2753125395613d+00, 5.7811464205803d-01,
     |   8.2081939601797d-01,-8.6404062515938d-01,-3.1083531296845d-01,
     |   9.3616543058349d-01,-1.9892620742502d-01,-7.6717144118080d-01,
     |   6.0103685077663d-01, 4.0345887637775d-01,-8.0166029231656d-01,
     |   5.4411655175835d-02, 7.5525279485370d-01,-4.8003292383614d-01,
     |  -4.8003292383614d-01, 7.5525279485370d-01, 5.4411655175841d-02,
     |  -8.0166029231656d-01, 4.0345887637775d-01, 6.0103685077662d-01,
     |  -7.6717144118080d-01,-1.9892620742502d-01, 9.3616543058349d-01,
     |  -3.1083531296845d-01,-8.6404062515938d-01, 8.2081939601796d-01,
     |   5.7811464205803d-01,-1.2753125395613d+00,-2.2721585541737d-01,
     |   1.9078603154260d+00, 1.2709305009659d+00, 7.4784737149878d-02/
      data (pmn(lat, 4,21), lat = 1,36)/
     |   8.7509011715863d-03, 4.9432247969512d-01, 1.7030928507349d+00,
     |   1.2562471367623d+00,-8.8908629973397d-01,-8.3391115909127d-01,
     |   9.4252085966810d-01, 3.7729144752400d-01,-9.7969231607840d-01,
     |   9.3025738353286d-02, 8.5357065114883d-01,-5.0106497133380d-01,
     |  -5.5332267969184d-01, 7.6008435151990d-01, 1.3730285327414d-01,
     |  -8.1051282339674d-01, 2.9672659910443d-01, 6.4160834005116d-01,
     |  -6.4160834005116d-01,-2.9672659910443d-01, 8.1051282339674d-01,
     |  -1.3730285327414d-01,-7.6008435151990d-01, 5.5332267969184d-01,
     |   5.0106497133381d-01,-8.5357065114883d-01,-9.3025738353288d-02,
     |   9.7969231607840d-01,-3.7729144752399d-01,-9.4252085966811d-01,
     |   8.3391115909127d-01, 8.8908629973397d-01,-1.2562471367623d+00,
     |  -1.7030928507349d+00,-4.9432247969512d-01,-8.7509011715863d-03/
      data (pmn(lat, 5,21), lat = 1,36)/
     |   8.0883904602403d-04, 1.4638216569772d-01, 9.9817436372105d-01,
     |   1.7453761065612d+00, 4.7003456001058d-01,-1.1928907090891d+00,
     |  -2.6524789453548d-01, 1.0589256009237d+00,-9.3197236640904d-02,
     |  -9.1216298988324d-01, 4.4994750054815d-01, 6.5261549764027d-01,
     |  -7.1605762351246d-01,-2.8729146891275d-01, 8.2535590716197d-01,
     |  -1.2327633130508d-01,-7.4719202795004d-01, 4.9501725803228d-01,
     |   4.9501725803228d-01,-7.4719202795004d-01,-1.2327633130509d-01,
     |   8.2535590716197d-01,-2.8729146891275d-01,-7.1605762351246d-01,
     |   6.5261549764027d-01, 4.4994750054815d-01,-9.1216298988324d-01,
     |  -9.3197236640908d-02, 1.0589256009237d+00,-2.6524789453547d-01,
     |  -1.1928907090891d+00, 4.7003456001058d-01, 1.7453761065612d+00,
     |   9.9817436372106d-01, 1.4638216569772d-01, 8.0883904602403d-04/
      data (pmn(lat, 6,21), lat = 1,36)/
     |   6.1460733333015d-05, 3.4943854620416d-02, 4.4356181372042d-01,
     |   1.3926253476382d+00, 1.4452812716463d+00,-2.5900121630402d-01,
     |  -1.1536865314992d+00, 2.8232854775926d-01, 9.4203270409263d-01,
     |  -4.9624160074861d-01,-6.9728163718306d-01, 7.0686470577784d-01,
     |   3.8034792231715d-01,-8.2608520746692d-01,-1.3677909192200d-02,
     |   8.0669108012225d-01,-3.4746942924097d-01,-6.3859335704942d-01,
     |   6.3859335704942d-01, 3.4746942924097d-01,-8.0669108012224d-01,
     |   1.3677909192199d-02, 8.2608520746692d-01,-3.8034792231716d-01,
     |  -7.0686470577784d-01, 6.9728163718306d-01, 4.9624160074862d-01,
     |  -9.4203270409263d-01,-2.8232854775927d-01, 1.1536865314992d+00,
     |   2.5900121630402d-01,-1.4452812716463d+00,-1.3926253476382d+00,
     |  -4.4356181372043d-01,-3.4943854620416d-02,-6.1460733333015d-05/
      data (pmn(lat, 7,21), lat = 1,36)/
     |   3.9417992661346d-06, 6.9583114480581d-03, 1.5920209151825d-01,
     |   8.1610417644910d-01, 1.5663746040943d+00, 9.1848432443707d-01,
     |  -7.9135870364238d-01,-8.5850429975053d-01, 6.9648269485205d-01,
     |   6.5884438425683d-01,-7.6961916582273d-01,-3.9819107134587d-01,
     |   8.4214991211977d-01, 9.1009156389658d-02,-8.3958888443047d-01,
     |   2.2974247755300d-01, 7.3100536876141d-01,-5.1836491646674d-01,
     |  -5.1836491646674d-01, 7.3100536876141d-01, 2.2974247755301d-01,
     |  -8.3958888443047d-01, 9.1009156389657d-02, 8.4214991211977d-01,
     |  -3.9819107134586d-01,-7.6961916582273d-01, 6.5884438425683d-01,
     |   6.9648269485205d-01,-8.5850429975053d-01,-7.9135870364238d-01,
     |   9.1848432443707d-01, 1.5663746040943d+00, 8.1610417644911d-01,
     |   1.5920209151825d-01, 6.9583114480581d-03, 3.9417992661346d-06/
      data (pmn(lat, 8,21), lat = 1,36)/
     |   2.1729784331802d-07, 1.1819088504337d-03, 4.7807134003085d-02,
     |   3.8197574285229d-01, 1.1574726330017d+00, 1.4893431538604d+00,
     |   3.1032906353428d-01,-1.0645236728781d+00,-4.3002882238345d-01,
     |   9.2419442044989d-01, 2.9888309158047d-01,-8.9520472174089d-01,
     |  -8.2249223176765d-02, 8.6639969249085d-01,-1.7001886941412d-01,
     |  -7.8509321893166d-01, 4.2027694655417d-01, 6.3378516224103d-01,
     |  -6.3378516224103d-01,-4.2027694655417d-01, 7.8509321893166d-01,
     |   1.7001886941413d-01,-8.6639969249085d-01, 8.2249223176771d-02,
     |   8.9520472174089d-01,-2.9888309158047d-01,-9.2419442044989d-01,
     |   4.3002882238344d-01, 1.0645236728781d+00,-3.1032906353427d-01,
     |  -1.4893431538604d+00,-1.1574726330017d+00,-3.8197574285229d-01,
     |  -4.7807134003086d-02,-1.1819088504337d-03,-2.1729784331802d-07/
      data (pmn(lat, 9,21), lat = 1,36)/
     |   1.0429559392146d-08, 1.7387385323740d-04, 1.2278020447682d-02,
     |   1.4884802588164d-01, 6.6580546111047d-01, 1.3808234874846d+00,
     |   1.2020882554082d+00,-2.4805257479573d-01,-1.0908440142828d+00,
     |   1.3902077685942d-02, 9.7105772360873d-01,-5.5781943573114d-02,
     |  -8.9394049759655d-01, 1.9789982305019d-01, 8.1320638655130d-01,
     |  -3.7542239596900d-01,-7.0102132383064d-01, 5.5131050832203d-01,
     |   5.5131050832203d-01,-7.0102132383063d-01,-3.7542239596901d-01,
     |   8.1320638655130d-01, 1.9789982305019d-01,-8.9394049759655d-01,
     |  -5.5781943573122d-02, 9.7105772360873d-01, 1.3902077685943d-02,
     |  -1.0908440142828d+00,-2.4805257479573d-01, 1.2020882554082d+00,
     |   1.3808234874846d+00, 6.6580546111047d-01, 1.4884802588164d-01,
     |   1.2278020447682d-02, 1.7387385323740d-04, 1.0429559392146d-08/
      data (pmn(lat,10,21), lat = 1,36)/
     |   4.3980904097065d-10, 2.2389084969799d-05, 2.7360506059172d-03,
     |   4.9469063772283d-02, 3.1496813293293d-01, 9.5054767820501d-01,
     |   1.4432139589354d+00, 7.8828169481002d-01,-6.7068290637149d-01,
     |  -9.3440116870705d-01, 3.8935826433480d-01, 8.8344190621579d-01,
     |  -3.5008087619713d-01,-8.1061172480706d-01, 4.1337340177184d-01,
     |   7.2618889824739d-01,-5.1645619828565d-01,-6.2647337246074d-01,
     |   6.2647337246074d-01, 5.1645619828565d-01,-7.2618889824739d-01,
     |  -4.1337340177184d-01, 8.1061172480706d-01, 3.5008087619713d-01,
     |  -8.8344190621579d-01,-3.8935826433480d-01, 9.3440116870705d-01,
     |   6.7068290637149d-01,-7.8828169481001d-01,-1.4432139589354d+00,
     |  -9.5054767820501d-01,-3.1496813293293d-01,-4.9469063772283d-02,
     |  -2.7360506059173d-03,-2.2389084969799d-05,-4.3980904097065d-10/
      data (pmn(lat,11,21), lat = 1,36)/
     |   1.6395480028895d-11, 2.5414724969111d-06, 5.3410255810886d-04,
     |   1.4233266745492d-02, 1.2613040093842d-01, 5.2699715589455d-01,
     |   1.1791494195521d+00, 1.3501169306150d+00, 3.4117435424664d-01,
     |  -9.2702613441976d-01,-6.7977881275498d-01, 6.5730710819037d-01,
     |   7.2471659403816d-01,-5.6137246154208d-01,-6.9705090060305d-01,
     |   5.5755872938833d-01, 6.4818106223408d-01,-5.9591414395434d-01,
     |  -5.9591414395434d-01, 6.4818106223408d-01, 5.5755872938834d-01,
     |  -6.9705090060304d-01,-5.6137246154208d-01, 7.2471659403816d-01,
     |   6.5730710819038d-01,-6.7977881275498d-01,-9.2702613441976d-01,
     |   3.4117435424664d-01, 1.3501169306150d+00, 1.1791494195521d+00,
     |   5.2699715589455d-01, 1.2613040093842d-01, 1.4233266745493d-02,
     |   5.3410255810887d-04, 2.5414724969111d-06, 1.6395480028895d-11/
      data (pmn(lat,12,21), lat = 1,36)/
     |   5.4233726428550d-13, 2.5544207846552d-07, 9.1882108416232d-05,
     |   3.5784350517605d-03, 4.3477057015305d-02, 2.4429787807598d-01,
     |   7.5099878510347d-01, 1.3167345273604d+00, 1.1435880784823d+00,
     |  -6.3705338463708d-02,-1.0338317504765d+00,-4.0528246107019d-01,
     |   8.1845085866479d-01, 5.5559069133014d-01,-6.9309616949038d-01,
     |  -6.0030819608440d-01, 6.3673906825905d-01, 6.1550934411783d-01,
     |  -6.1550934411782d-01,-6.3673906825905d-01, 6.0030819608439d-01,
     |   6.9309616949038d-01,-5.5559069133014d-01,-8.1845085866479d-01,
     |   4.0528246107018d-01, 1.0338317504765d+00, 6.3705338463710d-02,
     |  -1.1435880784823d+00,-1.3167345273604d+00,-7.5099878510347d-01,
     |  -2.4429787807598d-01,-4.3477057015305d-02,-3.5784350517606d-03,
     |  -9.1882108416234d-05,-2.5544207846552d-07,-5.4233726428550d-13/
      data (pmn(lat,13,21), lat = 1,36)/
     |   1.5942948337828d-14, 2.2778705180901d-08, 1.3972961060895d-05,
     |   7.9027540704443d-04, 1.3024580005047d-02, 9.6589479450238d-02,
     |   3.9282632017948d-01, 9.5227174856757d-01, 1.3579508059852d+00,
     |   8.8260383559874d-01,-3.8244714401456d-01,-1.0368357572061d+00,
     |  -1.6805292286030d-01, 8.9871169480698d-01, 4.2404632967725d-01,
     |  -7.6160236495058d-01,-5.5810869214669d-01, 6.5571267839743d-01,
     |   6.5571267839744d-01,-5.5810869214669d-01,-7.6160236495058d-01,
     |   4.2404632967725d-01, 8.9871169480698d-01,-1.6805292286030d-01,
     |  -1.0368357572061d+00,-3.8244714401456d-01, 8.8260383559874d-01,
     |   1.3579508059852d+00, 9.5227174856757d-01, 3.9282632017948d-01,
     |   9.6589479450238d-02, 1.3024580005047d-02, 7.9027540704445d-04,
     |   1.3972961060895d-05, 2.2778705180901d-08, 1.5942948337828d-14/
      data (pmn(lat,14,21), lat = 1,36)/
     |   4.1622798845989d-16, 1.8015751475285d-09, 1.8792787830978d-06,
     |   1.5360001018416d-04, 3.4069499101942d-03, 3.2913352671534d-02,
     |   1.7300011818778d-01, 5.5178895633331d-01, 1.1071344941052d+00,
     |   1.3232424294449d+00, 6.2478527057527d-01,-6.0265938134420d-01,
     |  -9.9153750648152d-01,-2.3991163002331d-03, 9.3230609938406d-01,
     |   3.6521297677828d-01,-7.7981322761540d-01,-5.9896857337877d-01,
     |   5.9896857337876d-01, 7.7981322761540d-01,-3.6521297677828d-01,
     |  -9.3230609938406d-01, 2.3991163002315d-03, 9.9153750648153d-01,
     |   6.0265938134421d-01,-6.2478527057527d-01,-1.3232424294449d+00,
     |  -1.1071344941052d+00,-5.5178895633331d-01,-1.7300011818778d-01,
     |  -3.2913352671534d-02,-3.4069499101942d-03,-1.5360001018416d-04,
     |  -1.8792787830979d-06,-1.8015751475285d-09,-4.1622798845989d-16/
      data (pmn(lat,15,21), lat = 1,36)/
     |   9.6204405688466d-18, 1.2601145243652d-10, 2.2301457438750d-07,
     |   2.6240748586977d-05, 7.7860819863786d-04, 9.7058639349251d-03,
     |   6.4904093369738d-02, 2.6460008843045d-01, 6.9970325587229d-01,
     |   1.2083527426457d+00, 1.2487425572210d+00, 4.1572074921799d-01,
     |  -7.3328042590558d-01,-9.4907810922657d-01, 7.1503777803564d-02,
     |   9.4560957219812d-01, 4.0721530797256d-01,-7.3730881938918d-01,
     |  -7.3730881938918d-01, 4.0721530797256d-01, 9.4560957219813d-01,
     |   7.1503777803565d-02,-9.4907810922656d-01,-7.3328042590557d-01,
     |   4.1572074921799d-01, 1.2487425572210d+00, 1.2083527426457d+00,
     |   6.9970325587229d-01, 2.6460008843045d-01, 6.4904093369739d-02,
     |   9.7058639349251d-03, 7.7860819863786d-04, 2.6240748586978d-05,
     |   2.2301457438751d-07, 1.2601145243652d-10, 9.6204405688466d-18/
      data (pmn(lat,16,21), lat = 1,36)/
     |   1.9564070331652d-19, 7.7479188944196d-12, 2.3221079253840d-08,
     |   3.9213020670913d-06, 1.5491228339593d-04, 2.4739119907290d-03,
     |   2.0811129152486d-02, 1.0642040610783d-01, 3.5789719503615d-01,
     |   8.1959673148104d-01, 1.2636296177729d+00, 1.1753433079644d+00,
     |   2.8782668976205d-01,-7.8898058448175d-01,-9.4791053467562d-01,
     |   3.2988768484531d-02, 9.3877809505771d-01, 5.7334065638264d-01,
     |  -5.7334065638264d-01,-9.3877809505771d-01,-3.2988768484537d-02,
     |   9.4791053467562d-01, 7.8898058448175d-01,-2.8782668976206d-01,
     |  -1.1753433079644d+00,-1.2636296177729d+00,-8.1959673148104d-01,
     |  -3.5789719503616d-01,-1.0642040610783d-01,-2.0811129152486d-02,
     |  -2.4739119907290d-03,-1.5491228339593d-04,-3.9213020670913d-06,
     |  -2.3221079253841d-08,-7.7479188944196d-12,-1.9564070331652d-19/
      data (pmn(lat,17,21), lat = 1,36)/
     |   3.4638235035386d-21, 4.1445172113312d-13, 2.1002761263666d-09,
     |   5.0773557485578d-07, 2.6604799898575d-05, 5.4126240513785d-04,
     |   5.6799367961720d-03, 3.5956070234890d-02, 1.5039821562156d-01,
     |   4.3736458429546d-01, 9.0117951840688d-01, 1.2889348571783d+00,
     |   1.1404697900742d+00, 2.6720296294797d-01,-7.7113654189580d-01,
     |  -1.0051644235968d+00,-1.5325047721337d-01, 8.5509687293821d-01,
     |   8.5509687293821d-01,-1.5325047721337d-01,-1.0051644235968d+00,
     |  -7.7113654189580d-01, 2.6720296294797d-01, 1.1404697900742d+00,
     |   1.2889348571783d+00, 9.0117951840688d-01, 4.3736458429546d-01,
     |   1.5039821562156d-01, 3.5956070234890d-02, 5.6799367961720d-03,
     |   5.4126240513785d-04, 2.6604799898575d-05, 5.0773557485579d-07,
     |   2.1002761263666d-09, 4.1445172113312d-13, 3.4638235035386d-21/
      data (pmn(lat,18,21), lat = 1,36)/
     |   5.2478486202546d-23, 1.8959385825246d-14, 1.6224556994274d-10,
     |   5.6033042932629d-08, 3.8823287472313d-06, 1.0017299644885d-04,
     |   1.3028576381071d-03, 1.0111874920455d-02, 5.1815593709471d-02,
     |   1.8645690509798d-01, 4.8783411717429d-01, 9.3817810485121d-01,
     |   1.2984853402391d+00, 1.1720128608624d+00, 3.8425463237435d-01,
     |  -6.4301580080417d-01,-1.0909643612327d+00,-5.3111211127005d-01,
     |   5.3111211127005d-01, 1.0909643612327d+00, 6.4301580080417d-01,
     |  -3.8425463237435d-01,-1.1720128608624d+00,-1.2984853402391d+00,
     |  -9.3817810485121d-01,-4.8783411717429d-01,-1.8645690509798d-01,
     |  -5.1815593709471d-02,-1.0111874920455d-02,-1.3028576381071d-03,
     |  -1.0017299644885d-04,-3.8823287472313d-06,-5.6033042932630d-08,
     |  -1.6224556994275d-10,-1.8959385825246d-14,-5.2478486202546d-23/
      data (pmn(lat,19,21), lat = 1,36)/
     |   6.6058103714170d-25, 7.2022275881007d-16, 1.0396557595899d-11,
     |   5.1205286305333d-09, 4.6792864805603d-07, 1.5257178339952d-05,
     |   2.4468396323009d-04, 2.3112702808007d-03, 1.4351391166807d-02,
     |   6.2818663815732d-02, 2.0266552909061d-01, 4.9458270773814d-01,
     |   9.2105842313388d-01, 1.2907380086433d+00, 1.2773869596056d+00,
     |   6.7758624945579d-01,-2.9727794611886d-01,-1.0511667962678d+00,
     |  -1.0511667962678d+00,-2.9727794611886d-01, 6.7758624945578d-01,
     |   1.2773869596055d+00, 1.2907380086433d+00, 9.2105842313388d-01,
     |   4.9458270773814d-01, 2.0266552909061d-01, 6.2818663815732d-02,
     |   1.4351391166807d-02, 2.3112702808007d-03, 2.4468396323009d-04,
     |   1.5257178339952d-05, 4.6792864805603d-07, 5.1205286305334d-09,
     |   1.0396557595899d-11, 7.2022275881007d-16, 6.6058103714170d-25/
      data (pmn(lat,20,21), lat = 1,36)/
     |   6.5296040320177d-27, 2.1474897664404d-17, 5.2242708857334d-13,
     |   3.6640783030380d-10, 4.4067429645187d-08, 1.8102980442922d-06,
     |   3.5650763406809d-05, 4.0749133052774d-04, 3.0409338102351d-03,
     |   1.5995955770533d-02, 6.2443808363365d-02, 1.8728781488636d-01,
     |   4.4125865940584d-01, 8.2576361171163d-01, 1.2252959493545d+00,
     |   1.4082383767822d+00, 1.1555218300279d+00, 4.4990181464170d-01,
     |  -4.4990181464170d-01,-1.1555218300279d+00,-1.4082383767822d+00,
     |  -1.2252959493545d+00,-8.2576361171163d-01,-4.4125865940584d-01,
     |  -1.8728781488636d-01,-6.2443808363365d-02,-1.5995955770533d-02,
     |  -3.0409338102352d-03,-4.0749133052774d-04,-3.5650763406810d-05,
     |  -1.8102980442922d-06,-4.4067429645187d-08,-3.6640783030381d-10,
     |  -5.2242708857337d-13,-2.1474897664404d-17,-6.5296040320177d-27/
      data (pmn(lat,21,21), lat = 1,36)/
     |   4.3990136640885d-29, 4.3625012086151d-19, 1.7871305541549d-14,
     |   1.7826348947883d-11, 2.8165495068246d-09, 1.4541262448108d-07,
     |   3.5045440326199d-06, 4.8247431865034d-05, 4.2996666247218d-04,
     |   2.6935999027703d-03, 1.2556952858176d-02, 4.5362558923116d-02,
     |   1.3079523430063d-01, 3.0761448474526d-01, 5.9964476981531d-01,
     |   9.8015845980312d-01, 1.3543297134129d+00, 1.5900104882917d+00,
     |   1.5900104882917d+00, 1.3543297134129d+00, 9.8015845980312d-01,
     |   5.9964476981531d-01, 3.0761448474526d-01, 1.3079523430063d-01,
     |   4.5362558923116d-02, 1.2556952858176d-02, 2.6935999027703d-03,
     |   4.2996666247218d-04, 4.8247431865034d-05, 3.5045440326199d-06,
     |   1.4541262448108d-07, 2.8165495068246d-09, 1.7826348947883d-11,
     |   1.7871305541550d-14, 4.3625012086151d-19, 4.3990136640885d-29/
      data (pmn(lat, 0,22), lat = 1,36)/
     |   3.6679072066954d+00,-1.1448877055994d+00,-9.8510402333488d-01,
     |   1.4200176100173d+00,-2.3455968294700d-01,-9.8261221188894d-01,
     |   8.9939151732300d-01, 2.0667183606562d-01,-9.5294914268870d-01,
     |   5.1220609917296d-01, 5.0074213600892d-01,-8.5136563234338d-01,
     |   1.6285071589728d-01, 6.9116434466577d-01,-6.7843646193270d-01,
     |  -1.5849159538469d-01, 7.8593790300057d-01,-4.4327641914363d-01,
     |  -4.4327641914363d-01, 7.8593790300057d-01,-1.5849159538468d-01,
     |  -6.7843646193270d-01, 6.9116434466577d-01, 1.6285071589727d-01,
     |  -8.5136563234338d-01, 5.0074213600892d-01, 5.1220609917296d-01,
     |  -9.5294914268871d-01, 2.0667183606562d-01, 8.9939151732301d-01,
     |  -9.8261221188894d-01,-2.3455968294700d-01, 1.4200176100173d+00,
     |  -9.8510402333486d-01,-1.1448877055994d+00, 3.6679072066954d+00/
      data (pmn(lat, 1,22), lat = 1,36)/
     |   2.0588826700205d+00, 1.7075883291498d+00,-1.5038393165244d+00,
     |  -2.0958156249029d-01, 1.2570669294511d+00,-6.8432513098337d-01,
     |  -5.8166776993858d-01, 1.0080671875985d+00,-2.0680366572515d-01,
     |  -7.6518571974438d-01, 7.5156108803496d-01, 1.6053185230997d-01,
     |  -8.2982775661259d-01, 4.6613327467185d-01, 4.5051925900646d-01,
     |  -7.9288069594751d-01, 1.5811226405588d-01, 6.6365616720366d-01,
     |  -6.6365616720366d-01,-1.5811226405588d-01, 7.9288069594751d-01,
     |  -4.5051925900646d-01,-4.6613327467185d-01, 8.2982775661259d-01,
     |  -1.6053185230996d-01,-7.5156108803496d-01, 7.6518571974438d-01,
     |   2.0680366572516d-01,-1.0080671875985d+00, 5.8166776993857d-01,
     |   6.8432513098337d-01,-1.2570669294511d+00, 2.0958156249028d-01,
     |   1.5038393165244d+00,-1.7075883291498d+00,-2.0588826700205d+00/
      data (pmn(lat, 2,22), lat = 1,36)/
     |   5.2582756514223d-01, 2.3026540071959d+00, 3.8274506787115d-01,
     |  -1.4820491925413d+00, 5.0538858777439d-01, 8.6744814005783d-01,
     |  -9.8251392548972d-01,-9.0044344482012d-02, 9.3473228254815d-01,
     |  -5.7568598673551d-01,-4.5035878305901d-01, 8.6216411925913d-01,
     |  -2.0165743756682d-01,-6.7533352483516d-01, 6.9243589062108d-01,
     |   1.4314625443401d-01,-7.8564133415251d-01, 4.4673643928306d-01,
     |   4.4673643928306d-01,-7.8564133415251d-01, 1.4314625443400d-01,
     |   6.9243589062108d-01,-6.7533352483516d-01,-2.0165743756681d-01,
     |   8.6216411925913d-01,-4.5035878305901d-01,-5.7568598673552d-01,
     |   9.3473228254815d-01,-9.0044344482008d-02,-9.8251392548973d-01,
     |   8.6744814005783d-01, 5.0538858777439d-01,-1.4820491925413d+00,
     |   3.8274506787113d-01, 2.3026540071959d+00, 5.2582756514223d-01/
      data (pmn(lat, 3,22), lat = 1,36)/
     |   8.7292685134103d-02, 1.4143716554062d+00, 1.8186797119720d+00,
     |  -6.3042554148395d-01,-1.0438241984085d+00, 9.8514315315791d-01,
     |   3.0810589682090d-01,-1.0330832856219d+00, 3.9010692041942d-01,
     |   6.7387489514958d-01,-8.1637922271113d-01,-6.2918242152932d-02,
     |   8.1436173877210d-01,-5.1803412952508d-01,-4.1326272646006d-01,
     |   8.0172278748524d-01,-1.7724586818211d-01,-6.6281635505835d-01,
     |   6.6281635505835d-01, 1.7724586818211d-01,-8.0172278748524d-01,
     |   4.1326272646006d-01, 5.1803412952508d-01,-8.1436173877210d-01,
     |   6.2918242152923d-02, 8.1637922271113d-01,-6.7387489514958d-01,
     |  -3.9010692041943d-01, 1.0330832856219d+00,-3.0810589682089d-01,
     |  -9.8514315315791d-01, 1.0438241984085d+00, 6.3042554148396d-01,
     |  -1.8186797119720d+00,-1.4143716554062d+00,-8.7292685134103d-02/
      data (pmn(lat, 4,22), lat = 1,36)/
     |   1.0713766698539d-02, 5.8356620089845d-01, 1.8295042607501d+00,
     |   9.5126409650646d-01,-1.1887333715149d+00,-3.6183009370386d-01,
     |   1.1190196887577d+00,-2.7285877455061d-01,-8.2546548260530d-01,
     |   7.4586532993151d-01, 2.8397904324480d-01,-8.7820473996000d-01,
     |   3.1731942619143d-01, 6.2149677283716d-01,-7.3180345429774d-01,
     |  -9.6032166894278d-02, 7.8409872528890d-01,-4.5725343896706d-01,
     |  -4.5725343896706d-01, 7.8409872528890d-01,-9.6032166894271d-02,
     |  -7.3180345429774d-01, 6.2149677283715d-01, 3.1731942619143d-01,
     |  -8.7820473996000d-01, 2.8397904324480d-01, 7.4586532993151d-01,
     |  -8.2546548260530d-01,-2.7285877455061d-01, 1.1190196887577d+00,
     |  -3.6183009370386d-01,-1.1887333715149d+00, 9.5126409650645d-01,
     |   1.8295042607501d+00, 5.8356620089845d-01, 1.0713766698539d-02/
      data (pmn(lat, 5,22), lat = 1,36)/
     |   1.0391241513675d-03, 1.8257870017229d-01, 1.1610901935783d+00,
     |   1.7304330487357d+00, 1.0945700898739d-02,-1.2454500449061d+00,
     |   3.2678355685875d-01, 9.1250985255583d-01,-7.2020712161987d-01,
     |  -4.3137967660666d-01, 9.0214586141398d-01,-1.3959357006202d-01,
     |  -7.6109301996275d-01, 6.1569934555464d-01, 3.3291873291415d-01,
     |  -8.1602020202768d-01, 2.1615906642750d-01, 6.6100464124425d-01,
     |  -6.6100464124425d-01,-2.1615906642750d-01, 8.1602020202768d-01,
     |  -3.3291873291415d-01,-6.1569934555464d-01, 7.6109301996275d-01,
     |   1.3959357006203d-01,-9.0214586141398d-01, 4.3137967660666d-01,
     |   7.2020712161987d-01,-9.1250985255582d-01,-3.2678355685876d-01,
     |   1.2454500449061d+00,-1.0945700898739d-02,-1.7304330487357d+00,
     |  -1.1610901935783d+00,-1.8257870017229d-01,-1.0391241513675d-03/
      data (pmn(lat, 6,22), lat = 1,36)/
     |   8.2924760298547d-05, 4.5985002937663d-02, 5.5190872582470d-01,
     |   1.5543227950321d+00, 1.2132671630388d+00,-7.3098367006969d-01,
     |  -8.9560393016704d-01, 8.2078171398294d-01, 4.7384335757451d-01,
     |  -9.3483866460467d-01, 3.0341569026052d-02, 8.4662021549335d-01,
     |  -5.0223323741627d-01,-5.1109789231888d-01, 7.8756291519954d-01,
     |   1.4116929333311d-02,-7.7924859854894d-01, 4.7525955527527d-01,
     |   4.7525955527528d-01,-7.7924859854894d-01, 1.4116929333304d-02,
     |   7.8756291519954d-01,-5.1109789231888d-01,-5.0223323741626d-01,
     |   8.4662021549335d-01, 3.0341569026052d-02,-9.3483866460467d-01,
     |   4.7384335757450d-01, 8.2078171398294d-01,-8.9560393016704d-01,
     |  -7.3098367006969d-01, 1.2132671630388d+00, 1.5543227950321d+00,
     |   5.5190872582470d-01, 4.5985002937663d-02, 8.2924760298547d-05/
      data (pmn(lat, 7,22), lat = 1,36)/
     |   5.5921584344340d-06, 9.6604446109857d-03, 2.1085683701410d-01,
     |   9.9359044787485d-01, 1.6206665314699d+00, 4.7918836154592d-01,
     |  -1.1141429842248d+00,-3.2833962177491d-01, 1.0175350477593d+00,
     |  -4.0289775490518d-02,-9.0076705230025d-01, 4.4185513426548d-01,
     |   6.2522396601177d-01,-7.4154731266875d-01,-1.9886195610223d-01,
     |   8.2824831462402d-01,-2.7608785232804d-01,-6.5793786352888d-01,
     |   6.5793786352888d-01, 2.7608785232804d-01,-8.2824831462402d-01,
     |   1.9886195610223d-01, 7.4154731266875d-01,-6.2522396601177d-01,
     |  -4.4185513426548d-01, 9.0076705230025d-01, 4.0289775490520d-02,
     |  -1.0175350477594d+00, 3.2833962177491d-01, 1.1141429842248d+00,
     |  -4.7918836154592d-01,-1.6206665314699d+00,-9.9359044787486d-01,
     |  -2.1085683701410d-01,-9.6604446109857d-03,-5.5921584344340d-06/
      data (pmn(lat, 8,22), lat = 1,36)/
     |   3.2464669983490d-07, 1.7324016428321d-03, 6.7274818012913d-02,
     |   5.0141368679017d-01, 1.3502117801201d+00, 1.3497745457106d+00,
     |  -2.4475602550440d-01,-1.1158515797896d+00, 2.5169827798858d-01,
     |   9.2490407144834d-01,-4.8696735492040d-01,-6.7391324853774d-01,
     |   7.2478581606037d-01, 3.1627284368210d-01,-8.4110056768659d-01,
     |   1.0684700556855d-01, 7.6728917396655d-01,-5.0155417509427d-01,
     |  -5.0155417509427d-01, 7.6728917396655d-01, 1.0684700556856d-01,
     |  -8.4110056768659d-01, 3.1627284368209d-01, 7.2478581606037d-01,
     |  -6.7391324853774d-01,-4.8696735492040d-01, 9.2490407144834d-01,
     |   2.5169827798859d-01,-1.1158515797896d+00,-2.4475602550441d-01,
     |   1.3497745457106d+00, 1.3502117801201d+00, 5.0141368679017d-01,
     |   6.7274818012914d-02, 1.7324016428321d-03, 3.2464669983490d-07/
      data (pmn(lat, 9,22), lat = 1,36)/
     |   1.6441287971974d-08, 2.6945055745783d-04, 1.8354084286853d-02,
     |   2.0963520683164d-01, 8.5325920711256d-01, 1.5034639954529d+00,
     |   8.3942694514902d-01,-7.8252883004465d-01,-8.2516034683648d-01,
     |   6.9194070928042d-01, 6.3023826215854d-01,-7.7966227485715d-01,
     |  -3.4686914884055d-01, 8.5570735208030d-01,-1.1841361973597d-03,
     |  -8.2518487448151d-01, 3.5871338407707d-01, 6.5313753253149d-01,
     |  -6.5313753253149d-01,-3.5871338407707d-01, 8.2518487448151d-01,
     |   1.1841361973616d-03,-8.5570735208030d-01, 3.4686914884055d-01,
     |   7.7966227485715d-01,-6.3023826215854d-01,-6.9194070928042d-01,
     |   8.2516034683647d-01, 7.8252883004465d-01,-8.3942694514901d-01,
     |  -1.5034639954529d+00,-8.5325920711256d-01,-2.0963520683164d-01,
     |  -1.8354084286853d-02,-2.6945055745783d-04,-1.6441287971974d-08/
      data (pmn(lat,10,22), lat = 1,36)/
     |   7.3331803142257d-10, 3.6756934265935d-05, 4.3491094224546d-03,
     |   7.4623100829455d-02, 4.3883864076459d-01, 1.1701706138508d+00,
     |   1.4128390396310d+00, 2.3973032035874d-01,-1.0518015908990d+00,
     |  -3.8514144844822d-01, 9.2417804151189d-01, 2.4999004073853d-01,
     |  -8.9965614709724d-01,-1.0236580407521d-02, 8.5877526470207d-01,
     |  -2.7058199709188d-01,-7.4203581281093d-01, 5.3745674633076d-01,
     |   5.3745674633077d-01,-7.4203581281093d-01,-2.7058199709189d-01,
     |   8.5877526470207d-01,-1.0236580407520d-02,-8.9965614709724d-01,
     |   2.4999004073852d-01, 9.2417804151189d-01,-3.8514144844822d-01,
     |  -1.0518015908990d+00, 2.3973032035873d-01, 1.4128390396310d+00,
     |   1.1701706138508d+00, 4.3883864076459d-01, 7.4623100829456d-02,
     |   4.3491094224546d-03, 3.6756934265935d-05, 7.3331803142257d-10/
      data (pmn(lat,11,22), lat = 1,36)/
     |   2.8999988868947d-11, 4.4321208208253d-06, 9.0453209266853d-04,
     |   2.3002739330420d-02, 1.9024675259596d-01, 7.1823860071306d-01,
     |   1.3685219911388d+00, 1.1160428258565d+00,-3.0788155115269d-01,
     |  -1.0638937859071d+00, 6.6761962091639d-02, 9.5917175992650d-01,
     |  -1.1517013281910d-01,-8.8131145677933d-01, 2.7334856446641d-01,
     |   7.8547742589667d-01,-4.6584324566236d-01,-6.4584366837728d-01,
     |   6.4584366837728d-01, 4.6584324566237d-01,-7.8547742589667d-01,
     |  -2.7334856446641d-01, 8.8131145677933d-01, 1.1517013281909d-01,
     |  -9.5917175992650d-01,-6.6761962091639d-02, 1.0638937859071d+00,
     |   3.0788155115270d-01,-1.1160428258565d+00,-1.3685219911388d+00,
     |  -7.1823860071306d-01,-1.9024675259596d-01,-2.3002739330420d-02,
     |  -9.0453209266855d-04,-4.4321208208253d-06,-2.8999988868947d-11/
      data (pmn(lat,12,22), lat = 1,36)/
     |   1.0213639000047d-12, 4.7483348366624d-07, 1.6627412244173d-04,
     |   6.2069732682312d-03, 7.0930971138598d-02, 3.6546807139519d-01,
     |   9.8991997450604d-01, 1.4078976159312d+00, 7.0007079299152d-01,
     |  -7.1270821299570d-01,-8.9269445882311d-01, 4.3789967493305d-01,
     |   8.5753554666542d-01,-4.0474625778778d-01,-7.8562733771283d-01,
     |   4.7652263235703d-01, 6.9378063056855d-01,-5.8511643780954d-01,
     |  -5.8511643780954d-01, 6.9378063056855d-01, 4.7652263235704d-01,
     |  -7.8562733771283d-01,-4.0474625778778d-01, 8.5753554666543d-01,
     |   4.3789967493305d-01,-8.9269445882311d-01,-7.1270821299571d-01,
     |   7.0007079299151d-01, 1.4078976159312d+00, 9.8991997450604d-01,
     |   3.6546807139519d-01, 7.0930971138598d-02, 6.2069732682313d-03,
     |   1.6627412244173d-04, 4.7483348366624d-07, 1.0213639000047d-12/
      data (pmn(lat,13,22), lat = 1,36)/
     |   3.2114646626827d-14, 4.5333060183081d-08, 2.7128096150579d-05,
     |   1.4759391267166d-03, 2.3017778628464d-02, 1.5818175819053d-01,
     |   5.7871460197905d-01, 1.2001178150244d+00, 1.2983541945113d+00,
     |   2.6196329733460d-01,-9.4775326938205d-01,-6.3363099037120d-01,
     |   6.9172545936708d-01, 6.9595463887762d-01,-6.0033748906231d-01,
     |  -6.7643766269929d-01, 5.9872347042246d-01, 6.3484703374375d-01,
     |  -6.3484703374375d-01,-5.9872347042246d-01, 6.7643766269929d-01,
     |   6.0033748906231d-01,-6.9595463887762d-01,-6.9172545936708d-01,
     |   6.3363099037119d-01, 9.4775326938205d-01,-2.6196329733460d-01,
     |  -1.2983541945113d+00,-1.2001178150244d+00,-5.7871460197905d-01,
     |  -1.5818175819053d-01,-2.3017778628464d-02,-1.4759391267166d-03,
     |  -2.7128096150580d-05,-4.5333060183081d-08,-3.2114646626827d-14/
      data (pmn(lat,14,22), lat = 1,36)/
     |   9.0199206205741d-16, 3.8603987940215d-09, 3.9353495301018d-06,
     |   3.1034808569134d-04, 6.5454836830597d-03, 5.9066169049440d-02,
     |   2.8326067440060d-01, 7.9584839378049d-01, 1.3190224415161d+00,
     |   1.0874846266415d+00,-1.2263161778652d-01,-1.0382059296930d+00,
     |  -3.7114969591547d-01, 8.3706829065627d-01, 5.4312854962799d-01,
     |  -7.1188612454594d-01,-6.0722431441441d-01, 6.4817748504214d-01,
     |   6.4817748504214d-01,-6.0722431441441d-01,-7.1188612454594d-01,
     |   5.4312854962799d-01, 8.3706829065627d-01,-3.7114969591547d-01,
     |  -1.0382059296930d+00,-1.2263161778652d-01, 1.0874846266415d+00,
     |   1.3190224415161d+00, 7.9584839378049d-01, 2.8326067440060d-01,
     |   5.9066169049440d-02, 6.5454836830597d-03, 3.1034808569134d-04,
     |   3.9353495301019d-06, 3.8603987940215d-09, 9.0199206205741d-16/
      data (pmn(lat,15,22), lat = 1,36)/
     |   2.2596957829180d-17, 2.9287646122751d-10, 5.0732084333990d-07,
     |   5.7743121907024d-05, 1.6356890289672d-03, 1.9166323279326d-02,
     |   1.1815309036027d-01, 4.3236183534764d-01, 9.8429873736878d-01,
     |   1.3476908706991d+00, 8.3842443779371d-01,-4.1350015139592d-01,
     |  -1.0381431871381d+00,-1.6384421251617d-01, 9.0679043096551d-01,
     |   4.5085949261337d-01,-7.5650564213991d-01,-6.1813783788202d-01,
     |   6.1813783788202d-01, 7.5650564213991d-01,-4.5085949261337d-01,
     |  -9.0679043096551d-01, 1.6384421251617d-01, 1.0381431871381d+00,
     |   4.1350015139593d-01,-8.3842443779371d-01,-1.3476908706991d+00,
     |  -9.8429873736878d-01,-4.3236183534764d-01,-1.1815309036027d-01,
     |  -1.9166323279326d-02,-1.6356890289672d-03,-5.7743121907025d-05,
     |  -5.0732084333991d-07,-2.9287646122751d-10,-2.2596957829180d-17/
      data (pmn(lat,16,22), lat = 1,36)/
     |   5.0305106650324d-19, 1.9725635150730d-11, 5.7940433287134d-08,
     |   9.4854618559819d-06, 3.5895137649609d-04, 5.4159908072490d-03,
     |   4.2336973516070d-02, 1.9691913687370d-01, 5.8443750448882d-01,
     |   1.1243836132392d+00, 1.3127439003106d+00, 6.1063225711534d-01,
     |  -6.0254388060765d-01,-1.0078454754206d+00,-4.7030187896724d-02,
     |   9.3481346915446d-01, 4.5735328903892d-01,-7.3339567882147d-01,
     |  -7.3339567882147d-01, 4.5735328903892d-01, 9.3481346915446d-01,
     |  -4.7030187896723d-02,-1.0078454754206d+00,-6.0254388060765d-01,
     |   6.1063225711534d-01, 1.3127439003106d+00, 1.1243836132392d+00,
     |   5.8443750448882d-01, 1.9691913687370d-01, 4.2336973516071d-02,
     |   5.4159908072490d-03, 3.5895137649609d-04, 9.4854618559821d-06,
     |   5.7940433287136d-08, 1.9725635150730d-11, 5.0305106650324d-19/
      data (pmn(lat,17,22), lat = 1,36)/
     |   9.8848372631534d-21, 1.1717187713827d-12, 5.8262447893236d-09,
     |   1.3680741660428d-06, 6.8866067623318d-05, 1.3293677653457d-03,
     |   1.3045971361140d-02, 7.5867681449028d-02, 2.8477534721400d-01,
     |   7.1841754757464d-01, 1.2132681278185d+00, 1.2546519429532d+00,
     |   4.5069705810647d-01,-6.9860530403088d-01,-9.9782701917389d-01,
     |  -4.7166896714910d-02, 9.3253275366824d-01, 5.9206540381664d-01,
     |  -5.9206540381664d-01,-9.3253275366824d-01, 4.7166896714905d-02,
     |   9.9782701917389d-01, 6.9860530403088d-01,-4.5069705810648d-01,
     |  -1.2546519429532d+00,-1.2132681278185d+00,-7.1841754757464d-01,
     |  -2.8477534721401d-01,-7.5867681449028d-02,-1.3045971361140d-02,
     |  -1.3293677653457d-03,-6.8866067623318d-05,-1.3680741660428d-06,
     |  -5.8262447893238d-09,-1.1717187713827d-12,-9.8848372631534d-21/
      data (pmn(lat,18,22), lat = 1,36)/
     |   1.6957991293309d-22, 6.0725294642882d-14, 5.1042681612879d-10,
     |   1.7151227030997d-07, 1.1444607507106d-05, 2.8120151458191d-04,
     |   3.4381881118459d-03, 2.4705448865825d-02, 1.1499458583932d-01,
     |   3.6647389101683d-01, 8.1826216861456d-01, 1.2611512198882d+00,
     |   1.2158108769682d+00, 3.9445459080765d-01,-7.0551158964493d-01,
     |  -1.0362948586383d+00,-1.9954348224651d-01, 8.5543665421978d-01,
     |   8.5543665421978d-01,-1.9954348224651d-01,-1.0362948586383d+00,
     |  -7.0551158964493d-01, 3.9445459080765d-01, 1.2158108769682d+00,
     |   1.2611512198882d+00, 8.1826216861456d-01, 3.6647389101683d-01,
     |   1.1499458583932d-01, 2.4705448865825d-02, 3.4381881118459d-03,
     |   2.8120151458191d-04, 1.1444607507106d-05, 1.7151227030997d-07,
     |   5.1042681612881d-10, 6.0725294642882d-14, 1.6957991293309d-22/
      data (pmn(lat,19,22), lat = 1,36)/
     |   2.4955971755506d-24, 2.6981248556807d-15, 3.8291689687750d-11,
     |   1.8376724690305d-08, 1.6208409189981d-06, 5.0482526490153d-05,
     |   7.6443762180567d-04, 6.7273878682263d-03, 3.8299499349013d-02,
     |   1.5064941465069d-01, 4.2520530716332d-01, 8.7304660695197d-01,
     |   1.2814822445719d+00, 1.2307862738335d+00, 4.7658881951059d-01,
     |  -5.9374427816782d-01,-1.1036595943792d+00,-5.4883357132308d-01,
     |   5.4883357132308d-01, 1.1036595943792d+00, 5.9374427816782d-01,
     |  -4.7658881951059d-01,-1.2307862738335d+00,-1.2814822445719d+00,
     |  -8.7304660695197d-01,-4.2520530716332d-01,-1.5064941465069d-01,
     |  -3.8299499349013d-02,-6.7273878682263d-03,-7.6443762180568d-04,
     |  -5.0482526490153d-05,-1.6208409189981d-06,-1.8376724690305d-08,
     |  -3.8291689687752d-11,-2.6981248556807d-15,-2.4955971755506d-24/
      data (pmn(lat,20,22), lat = 1,36)/
     |   3.0579843685227d-26, 9.9770485553346d-17, 2.3882531924306d-12,
     |   1.6343186535319d-09, 1.9008024624091d-07, 7.4791022917377d-06,
     |   1.3959265796462d-04, 1.4942915036776d-03, 1.0300283103112d-02,
     |   4.9224619347661d-02, 1.7099807582772d-01, 4.4407069940854d-01,
     |   8.7124726033054d-01, 1.2758369677618d+00, 1.3136011258219d+00,
     |   7.3667103240429d-01,-2.6423042674218d-01,-1.0570638969505d+00,
     |  -1.0570638969505d+00,-2.6423042674218d-01, 7.3667103240428d-01,
     |   1.3136011258219d+00, 1.2758369677618d+00, 8.7124726033054d-01,
     |   4.4407069940854d-01, 1.7099807582772d-01, 4.9224619347661d-02,
     |   1.0300283103112d-02, 1.4942915036777d-03, 1.3959265796462d-04,
     |   7.4791022917377d-06, 1.9008024624091d-07, 1.6343186535319d-09,
     |   2.3882531924308d-12, 9.9770485553346d-17, 3.0579843685227d-26/
      data (pmn(lat,21,22), lat = 1,36)/
     |   2.9481394273639d-28, 2.9014185500219d-18, 1.1704262404677d-13,
     |   1.1404812822747d-10, 1.7455769242106d-08, 8.6524140473455d-07,
     |   1.9827454855986d-05, 2.5677167431241d-04, 2.1265320129874d-03,
     |   1.2207386375486d-02, 5.1278775798795d-02, 1.6350096724420d-01,
     |   4.0513874352511d-01, 7.8968283647057d-01, 1.2096009272099d+00,
     |   1.4231127191077d+00, 1.1858461076388d+00, 4.6524938486859d-01,
     |  -4.6524938486859d-01,-1.1858461076388d+00,-1.4231127191077d+00,
     |  -1.2096009272099d+00,-7.8968283647057d-01,-4.0513874352511d-01,
     |  -1.6350096724420d-01,-5.1278775798795d-02,-1.2207386375486d-02,
     |  -2.1265320129875d-03,-2.5677167431241d-04,-1.9827454855986d-05,
     |  -8.6524140473455d-07,-1.7455769242106d-08,-1.1404812822747d-10,
     |  -1.1704262404677d-13,-2.9014185500219d-18,-2.9481394273639d-28/
      data (pmn(lat,22,22), lat = 1,36)/
     |   1.9405051122872d-30, 5.7585500742737d-20, 3.9117667347159d-15,
     |   5.4210589043120d-12, 1.0900262795420d-09, 6.7902791926857d-08,
     |   1.9042675362289d-06, 2.9703063792655d-05, 2.9376364515409d-04,
     |   2.0083707638779d-03, 1.0074670174262d-02, 3.8690706116998d-02,
     |   1.1732775554209d-01, 2.8741011333637d-01, 5.7835363602607d-01,
     |   9.6773784336646d-01, 1.3579159565094d+00, 1.6064468407112d+00,
     |   1.6064468407112d+00, 1.3579159565094d+00, 9.6773784336646d-01,
     |   5.7835363602607d-01, 2.8741011333637d-01, 1.1732775554209d-01,
     |   3.8690706116998d-02, 1.0074670174262d-02, 2.0083707638780d-03,
     |   2.9376364515409d-04, 2.9703063792655d-05, 1.9042675362290d-06,
     |   6.7902791926857d-08, 1.0900262795420d-09, 5.4210589043121d-12,
     |   3.9117667347161d-15, 5.7585500742737d-20, 1.9405051122872d-30/
      data (pmn(lat, 0,23), lat = 1,36)/
     |   3.6551986078635d+00,-1.3828204152655d+00,-6.5755995991155d-01,
     |   1.4470550818109d+00,-7.0229443970476d-01,-5.7491224547921d-01,
     |   1.0875911410797d+00,-4.4580806807213d-01,-5.7838412092947d-01,
     |   9.1752912510961d-01,-2.8443247078736d-01,-6.0281898246876d-01,
     |   8.1255948736208d-01,-1.6013193535637d-01,-6.3795428056807d-01,
     |   7.3865433171577d-01,-5.1843467002831d-02,-6.8246458594552d-01,
     |   6.8246458594552d-01, 5.1843467002833d-02,-7.3865433171577d-01,
     |   6.3795428056807d-01, 1.6013193535637d-01,-8.1255948736208d-01,
     |   6.0281898246876d-01, 2.8443247078736d-01,-9.1752912510961d-01,
     |   5.7838412092947d-01, 4.4580806807213d-01,-1.0875911410797d+00,
     |   5.7491224547921d-01, 7.0229443970476d-01,-1.4470550818109d+00,
     |   6.5755995991153d-01, 1.3828204152655d+00,-3.6551986078635d+00/
      data (pmn(lat, 1,23), lat = 1,36)/
     |   2.1727074987222d+00, 1.5070261659577d+00,-1.6498992628179d+00,
     |   2.3162673847865d-01, 1.0465725731725d+00,-1.0478660450589d+00,
     |   3.4538410493931d-03, 9.0840843437579d-01,-7.9329033959721d-01,
     |  -1.2801028391379d-01, 8.4512119298333d-01,-6.3397000843695d-01,
     |  -2.3040567483184d-01, 8.1338943007673d-01,-5.1477856659290d-01,
     |  -3.2272268205281d-01, 7.9976825997713d-01,-4.1473441975667d-01,
     |  -4.1473441975667d-01, 7.9976825997713d-01,-3.2272268205280d-01,
     |  -5.1477856659290d-01, 8.1338943007673d-01,-2.3040567483184d-01,
     |  -6.3397000843696d-01, 8.4512119298333d-01,-1.2801028391379d-01,
     |  -7.9329033959721d-01, 9.0840843437579d-01, 3.4538410494027d-03,
     |  -1.0478660450589d+00, 1.0465725731725d+00, 2.3162673847866d-01,
     |  -1.6498992628179d+00, 1.5070261659577d+00, 2.1727074987222d+00/
      data (pmn(lat, 2,23), lat = 1,36)/
     |   5.8198012597891d-01, 2.3615358096345d+00, 2.4080241990860d-02,
     |  -1.3870345741497d+00, 9.1904359039617d-01, 4.0429317895077d-01,
     |  -1.0891044427690d+00, 5.4757789119314d-01, 5.0560554145470d-01,
     |  -9.2919920778416d-01, 3.4025207832936d-01, 5.6947072701975d-01,
     |  -8.2426418184723d-01, 1.8915519275274d-01, 6.2527138186007d-01,
     |  -7.4609757541263d-01, 6.0916930661007d-02, 6.8216007516452d-01,
     |  -6.8216007516452d-01,-6.0916930661009d-02, 7.4609757541263d-01,
     |  -6.2527138186006d-01,-1.8915519275274d-01, 8.2426418184723d-01,
     |  -5.6947072701975d-01,-3.4025207832936d-01, 9.2919920778416d-01,
     |  -5.0560554145469d-01,-5.4757789119315d-01, 1.0891044427690d+00,
     |  -4.0429317895077d-01,-9.1904359039617d-01, 1.3870345741497d+00,
     |  -2.4080241990841d-02,-2.3615358096345d+00,-5.8198012597891d-01/
      data (pmn(lat, 3,23), lat = 1,36)/
     |   1.0115436695902d-01, 1.5581050785442d+00, 1.6745256695131d+00,
     |  -9.8553203446455d-01,-6.7058124381326d-01, 1.1846458676985d+00,
     |  -2.9611467628680d-01,-7.8956984386298d-01, 8.9064544505242d-01,
     |  -1.7277173289187d-02,-8.0351766792017d-01, 6.9839241043469d-01,
     |   1.5779557906653d-01,-8.0295104911079d-01, 5.5040926527015d-01,
     |   2.9558779157264d-01,-8.0131959379086d-01, 4.2134932891777d-01,
     |   4.2134932891777d-01,-8.0131959379085d-01, 2.9558779157263d-01,
     |   5.5040926527015d-01,-8.0295104911079d-01, 1.5779557906654d-01,
     |   6.9839241043470d-01,-8.0351766792017d-01,-1.7277173289191d-02,
     |   8.9064544505243d-01,-7.8956984386298d-01,-2.9611467628681d-01,
     |   1.1846458676985d+00,-6.7058124381326d-01,-9.8553203446456d-01,
     |   1.6745256695130d+00, 1.5581050785442d+00, 1.0115436695902d-01/
      data (pmn(lat, 4,23), lat = 1,36)/
     |   1.2994877149341d-02, 6.8116027522200d-01, 1.9260392934960d+00,
     |   5.8766462795447d-01,-1.3421402654881d+00, 1.8104591559483d-01,
     |   9.7512567360752d-01,-8.1629500516098d-01,-2.5744539899469d-01,
     |   9.3025946045991d-01,-5.0133245775343d-01,-4.5774656356535d-01,
     |   8.5004005502189d-01,-2.7607835069023d-01,-5.8392680906951d-01,
     |   7.6715094572770d-01,-8.8493302461560d-02,-6.8118942608186d-01,
     |   6.8118942608186d-01, 8.8493302461561d-02,-7.6715094572770d-01,
     |   5.8392680906951d-01, 2.7607835069023d-01,-8.5004005502189d-01,
     |   4.5774656356534d-01, 5.0133245775343d-01,-9.3025946045991d-01,
     |   2.5744539899469d-01, 8.1629500516098d-01,-9.7512567360751d-01,
     |  -1.8104591559483d-01, 1.3421402654881d+00,-5.8766462795445d-01,
     |  -1.9260392934960d+00,-6.8116027522200d-01,-1.2994877149341d-02/
      data (pmn(lat, 5,23), lat = 1,36)/
     |   1.3196496638514d-03, 2.2476867252720d-01, 1.3262427201430d+00,
     |   1.6393740448332d+00,-4.4824408409275d-01,-1.0728922714793d+00,
     |   8.2922632103059d-01, 4.2650599792299d-01,-9.9476367407086d-01,
     |   3.1306533632866d-01, 6.7611061076588d-01,-8.0476939435991d-01,
     |  -5.4981338097781d-03, 7.6930226579853d-01,-6.1839017635495d-01,
     |  -2.3881307205257d-01, 8.0328121282867d-01,-4.3482116406531d-01,
     |  -4.3482116406531d-01, 8.0328121282867d-01,-2.3881307205257d-01,
     |  -6.1839017635495d-01, 7.6930226579853d-01,-5.4981338097841d-03,
     |  -8.0476939435991d-01, 6.7611061076588d-01, 3.1306533632866d-01,
     |  -9.9476367407086d-01, 4.2650599792299d-01, 8.2922632103060d-01,
     |  -1.0728922714793d+00,-4.4824408409275d-01, 1.6393740448332d+00,
     |   1.3262427201430d+00, 2.2476867252720d-01, 1.3196496638514d-03/
      data (pmn(lat, 6,23), lat = 1,36)/
     |   1.1034103233231d-04, 5.9605621415366d-02, 6.7397866325424d-01,
     |   1.6824618787775d+00, 8.8128779987481d-01,-1.0848500491654d+00,
     |  -4.1471603922144d-01, 1.0673585171245d+00,-2.1525195648074d-01,
     |  -8.1356746425579d-01, 7.3318339240180d-01, 2.3770995794226d-01,
     |  -8.5939630313327d-01, 4.1818192797619d-01, 5.0415403469843d-01,
     |  -7.9763705244551d-01, 1.3562417699689d-01, 6.7937389740449d-01,
     |  -6.7937389740449d-01,-1.3562417699689d-01, 7.9763705244552d-01,
     |  -5.0415403469843d-01,-4.1818192797619d-01, 8.5939630313327d-01,
     |  -2.3770995794225d-01,-7.3318339240180d-01, 8.1356746425578d-01,
     |   2.1525195648074d-01,-1.0673585171245d+00, 4.1471603922143d-01,
     |   1.0848500491654d+00,-8.8128779987481d-01,-1.6824618787775d+00,
     |  -6.7397866325425d-01,-5.9605621415366d-02,-1.1034103233231d-04/
      data (pmn(lat, 7,23), lat = 1,36)/
     |   7.8042315048827d-06, 1.3179459216382d-02, 2.7367114137104d-01,
     |   1.1768823703471d+00, 1.5840364328898d+00,-2.1919780473773d-02,
     |  -1.1848324489130d+00, 3.0764426536129d-01, 8.8157682826013d-01,
     |  -7.1286110994250d-01,-3.8507501290283d-01, 8.9465164088560d-01,
     |  -2.3215788315614d-01,-6.8625832555540d-01, 7.1008901306032d-01,
     |   1.4764333673032d-01,-8.0318890289224d-01, 4.5566848564397d-01,
     |   4.5566848564398d-01,-8.0318890289223d-01, 1.4764333673032d-01,
     |   7.1008901306032d-01,-6.8625832555540d-01,-2.3215788315613d-01,
     |   8.9465164088560d-01,-3.8507501290283d-01,-7.1286110994250d-01,
     |   8.8157682826013d-01, 3.0764426536130d-01,-1.1848324489130d+00,
     |  -2.1919780473773d-02, 1.5840364328898d+00, 1.1768823703471d+00,
     |   2.7367114137105d-01, 1.3179459216382d-02, 7.8042315048827d-06/
      data (pmn(lat, 8,23), lat = 1,36)/
     |   4.7580556553748d-07, 2.4887273221376d-03, 9.2574375623600d-02,
     |   6.4033678719997d-01, 1.5103257122041d+00, 1.0735843342901d+00,
     |  -7.4858568958846d-01,-8.3028530352678d-01, 8.2304514039596d-01,
     |   4.1434512743499d-01,-9.2920197251539d-01, 1.1724349846936d-01,
     |   7.9546957574451d-01,-6.0273216423517d-01,-3.7047806278861d-01,
     |   8.2939147333346d-01,-2.0399618231047d-01,-6.7638880374335d-01,
     |   6.7638880374335d-01, 2.0399618231047d-01,-8.2939147333346d-01,
     |   3.7047806278861d-01, 6.0273216423517d-01,-7.9546957574452d-01,
     |  -1.1724349846937d-01, 9.2920197251539d-01,-4.1434512743499d-01,
     |  -8.2304514039596d-01, 8.3028530352678d-01, 7.4858568958847d-01,
     |  -1.0735843342901d+00,-1.5103257122041d+00,-6.4033678719997d-01,
     |  -9.2574375623602d-02,-2.4887273221376d-03,-4.7580556553748d-07/
      data (pmn(lat, 9,23), lat = 1,36)/
     |   2.5347582416347d-08, 4.0803866726818d-04, 2.6759472166566d-02,
     |   2.8681520631093d-01, 1.0526230100524d+00, 1.5283996121256d+00,
     |   3.4628685969905d-01,-1.1029464080569d+00,-2.4019960389519d-01,
     |   1.0019218738891d+00,-1.2926253622738d-01,-8.5489269604066d-01,
     |   5.3840787664745d-01, 5.1527644104331d-01,-8.0713371738878d-01,
     |  -1.5803011205582d-02, 7.9685235941828d-01,-4.8476766403490d-01,
     |  -4.8476766403491d-01, 7.9685235941828d-01,-1.5803011205576d-02,
     |  -8.0713371738878d-01, 5.1527644104330d-01, 5.3840787664745d-01,
     |  -8.5489269604066d-01,-1.2926253622738d-01, 1.0019218738891d+00,
     |  -2.4019960389519d-01,-1.1029464080569d+00, 3.4628685969904d-01,
     |   1.5283996121256d+00, 1.0526230100524d+00, 2.8681520631093d-01,
     |   2.6759472166566d-02, 4.0803866726818d-04, 2.5347582416347d-08/
      data (pmn(lat,10,23), lat = 1,36)/
     |   1.1916654824928d-09, 5.8770368036585d-05, 6.7214580597129d-03,
     |   1.0909150442142d-01, 5.8867283507042d-01, 1.3644367271290d+00,
     |   1.2182270332839d+00,-3.5741479382830d-01,-1.0584438976635d+00,
     |   3.4650364458292d-01, 8.6406791519151d-01,-5.7559554058225d-01,
     |  -5.7610334431127d-01, 7.9309919020326d-01, 1.6450861175664d-01,
     |  -8.4832797872688d-01, 2.9578554435794d-01, 6.7171463369854d-01,
     |  -6.7171463369854d-01,-2.9578554435794d-01, 8.4832797872689d-01,
     |  -1.6450861175664d-01,-7.9309919020326d-01, 5.7610334431128d-01,
     |   5.7559554058226d-01,-8.6406791519151d-01,-3.4650364458292d-01,
     |   1.0584438976635d+00, 3.5741479382831d-01,-1.2182270332839d+00,
     |  -1.3644367271290d+00,-5.8867283507042d-01,-1.0909150442142d-01,
     |  -6.7214580597130d-03,-5.8770368036585d-05,-1.1916654824928d-09/
      data (pmn(lat,11,23), lat = 1,36)/
     |   4.9796150331236d-11, 7.4984834567321d-06, 1.4839236579286d-03,
     |   3.5912724168038d-02, 2.7580009080425d-01, 9.3082461752170d-01,
     |   1.4650786232645d+00, 6.8451453008011d-01,-8.5326558759560d-01,
     |  -7.2228880620396d-01, 7.6289008343595d-01, 5.2518231918080d-01,
     |  -8.3575045090073d-01,-2.1429043819189d-01, 8.7453611782796d-01,
     |  -1.6275475864546d-01,-7.7763664053325d-01, 5.2351344365138d-01,
     |   5.2351344365139d-01,-7.7763664053325d-01,-1.6275475864546d-01,
     |   8.7453611782796d-01,-2.1429043819189d-01,-8.3575045090072d-01,
     |   5.2518231918079d-01, 7.6289008343595d-01,-7.2228880620396d-01,
     |  -8.5326558759560d-01, 6.8451453008011d-01, 1.4650786232645d+00,
     |   9.3082461752170d-01, 2.7580009080425d-01, 3.5912724168039d-02,
     |   1.4839236579287d-03, 7.4984834567321d-06, 4.9796150331236d-11/
      data (pmn(lat,12,23), lat = 1,36)/
     |   1.8587821839273d-12, 8.5243765346567d-07, 2.9020691927599d-04,
     |   1.0358977555358d-02, 1.1087929795149d-01, 5.1978899673297d-01,
     |   1.2189931007096d+00, 1.3242916760565d+00, 8.6203051973655d-02,
     |  -1.0659584956176d+00,-2.5800320692787d-01, 9.4964446045103d-01,
     |   1.2396214390142d-01,-9.0889085779465d-01, 1.2724216657728d-01,
     |   8.3152900026224d-01,-4.1333499500653d-01,-6.6454576466035d-01,
     |   6.6454576466035d-01, 4.1333499500653d-01,-8.3152900026223d-01,
     |  -1.2724216657728d-01, 9.0889085779465d-01,-1.2396214390143d-01,
     |  -9.4964446045104d-01, 2.5800320692787d-01, 1.0659584956176d+00,
     |  -8.6203051973650d-02,-1.3242916760565d+00,-1.2189931007096d+00,
     |  -5.1978899673297d-01,-1.1087929795149d-01,-1.0358977555358d-02,
     |  -2.9020691927600d-04,-8.5243765346567d-07,-1.8587821839273d-12/
      data (pmn(lat,13,23), lat = 1,36)/
     |   6.2175194751880d-14, 8.6663500782946d-08, 5.0530603825732d-05,
     |   2.6390118174170d-03, 3.8807093707143d-02, 2.4562626135889d-01,
     |   7.9886859353102d-01, 1.3765017486918d+00, 9.9219945694303d-01,
     |  -4.3417574934453d-01,-1.0244321313622d+00, 1.8878284200163d-01,
     |   9.3853054484120d-01,-2.3335726500921d-01,-8.5226170843944d-01,
     |   3.8994326444359d-01, 7.3522590168864d-01,-5.7413718059766d-01,
     |  -5.7413718059766d-01, 7.3522590168864d-01, 3.8994326444359d-01,
     |  -8.5226170843944d-01,-2.3335726500921d-01, 9.3853054484120d-01,
     |   1.8878284200164d-01,-1.0244321313622d+00,-4.3417574934454d-01,
     |   9.9219945694303d-01, 1.3765017486918d+00, 7.9886859353102d-01,
     |   2.4562626135889d-01, 3.8807093707143d-02, 2.6390118174170d-03,
     |   5.0530603825734d-05, 8.6663500782946d-08, 6.2175194751880d-14/
      data (pmn(lat,14,23), lat = 1,36)/
     |   1.8663388801125d-15, 7.8940759430221d-09, 7.8555570486439d-06,
     |   5.9659477747185d-04, 1.1927692208878d-02, 1.0003775685133d-01,
     |   4.3386858260541d-01, 1.0547291616935d+00, 1.3744081789702d+00,
     |   5.6501279465959d-01,-7.9560334869466d-01,-8.1988068512858d-01,
     |   5.3214193525360d-01, 8.0963012274831d-01,-4.9485527870019d-01,
     |  -7.4339879459595d-01, 5.5844557067200d-01, 6.5361534070872d-01,
     |  -6.5361534070872d-01,-5.5844557067200d-01, 7.4339879459595d-01,
     |   4.9485527870019d-01,-8.0963012274831d-01,-5.3214193525360d-01,
     |   8.1988068512858d-01, 7.9560334869466d-01,-5.6501279465959d-01,
     |  -1.3744081789702d+00,-1.0547291616935d+00,-4.3386858260541d-01,
     |  -1.0003775685133d-01,-1.1927692208878d-02,-5.9659477747186d-04,
     |  -7.8555570486442d-06,-7.8940759430221d-09,-1.8663388801125d-15/
      data (pmn(lat,15,23), lat = 1,36)/
     |   5.0262569994897d-17, 6.4429768430198d-10, 1.0912100746392d-06,
     |   1.1993501287315d-04, 3.2346164374303d-03, 3.5475950023091d-02,
     |   2.0020821488649d-01, 6.4941856795107d-01, 1.2389366666517d+00,
     |   1.2354904957676d+00, 1.4122368038957d-01,-9.8718847213092d-01,
     |  -5.5677419150167d-01, 7.5047903310285d-01, 6.5022767321436d-01,
     |  -6.5512146044260d-01,-6.5341552709759d-01, 6.4038517990907d-01,
     |   6.4038517990907d-01,-6.5341552709758d-01,-6.5512146044260d-01,
     |   6.5022767321436d-01, 7.5047903310285d-01,-5.5677419150168d-01,
     |  -9.8718847213093d-01, 1.4122368038957d-01, 1.2354904957676d+00,
     |   1.2389366666517d+00, 6.4941856795107d-01, 2.0020821488649d-01,
     |   3.5475950023091d-02, 3.2346164374303d-03, 1.1993501287315d-04,
     |   1.0912100746393d-06, 6.4429768430198d-10, 5.0262569994897d-17/
      data (pmn(lat,16,23), lat = 1,36)/
     |   1.2119321681741d-18, 4.7031771028210d-11, 1.3526177336100d-07,
     |   2.1433228785752d-05, 7.7504066008169d-04, 1.1007857516375d-02,
     |   7.9501797144634d-02, 3.3316125223841d-01, 8.5739416264815d-01,
     |   1.3312540783405d+00, 1.0170241122660d+00,-2.0975435418617d-01,
     |  -1.0494044637919d+00,-3.1969434349042d-01, 8.6630280166047d-01,
     |   5.3164629482365d-01,-7.3078193951089d-01,-6.3683065151613d-01,
     |   6.3683065151613d-01, 7.3078193951089d-01,-5.3164629482365d-01,
     |  -8.6630280166047d-01, 3.1969434349042d-01, 1.0494044637919d+00,
     |   2.0975435418618d-01,-1.0170241122660d+00,-1.3312540783405d+00,
     |  -8.5739416264815d-01,-3.3316125223841d-01,-7.9501797144635d-02,
     |  -1.1007857516375d-02,-7.7504066008169d-04,-2.1433228785752d-05,
     |  -1.3526177336100d-07,-4.7031771028210d-11,-1.2119321681741d-18/
      data (pmn(lat,17,23), lat = 1,36)/
     |   2.6051815373636d-20, 3.0580183306401d-12, 1.4906468938541d-08,
     |   3.3947981425742d-06, 1.6380128776520d-04, 2.9903727703038d-03,
     |   2.7310269969556d-02, 1.4479449500603d-01, 4.8154711821695d-01,
     |   1.0286564334562d+00, 1.3433158809999d+00, 7.8652739812203d-01,
     |  -4.5696812895244d-01,-1.0454424502620d+00,-1.6402692710524d-01,
     |   9.1694190822404d-01, 5.0575637260294d-01,-7.2916149992981d-01,
     |  -7.2916149992981d-01, 5.0575637260294d-01, 9.1694190822404d-01,
     |  -1.6402692710524d-01,-1.0454424502620d+00,-4.5696812895244d-01,
     |   7.8652739812203d-01, 1.3433158809999d+00, 1.0286564334562d+00,
     |   4.8154711821695d-01, 1.4479449500603d-01, 2.7310269969556d-02,
     |   2.9903727703038d-03, 1.6380128776520d-04, 3.3947981425742d-06,
     |   1.4906468938541d-08, 3.0580183306401d-12, 2.6051815373636d-20/
      data (pmn(lat,18,23), lat = 1,36)/
     |   4.9570498785129d-22, 1.7587073351565d-13, 1.4507836890174d-09,
     |   4.7364972179970d-07, 3.0376264412675d-05, 7.0864756054141d-04,
     |   8.1106605280949d-03, 5.3616451877195d-02, 2.2446597876040d-01,
     |   6.2303467843363d-01, 1.1494142170861d+00, 1.3099874916268d+00,
     |   6.0390555959678d-01,-5.9764716154074d-01,-1.0363435347275d+00,
     |  -1.2653256557345d-01, 9.2398763526022d-01, 6.1040288259623d-01,
     |  -6.1040288259623d-01,-9.2398763526022d-01, 1.2653256557345d-01,
     |   1.0363435347275d+00, 5.9764716154074d-01,-6.0390555959678d-01,
     |  -1.3099874916268d+00,-1.1494142170861d+00,-6.2303467843363d-01,
     |  -2.2446597876040d-01,-5.3616451877195d-02,-8.1106605280950d-03,
     |  -7.0864756054141d-04,-3.0376264412675d-05,-4.7364972179971d-07,
     |  -1.4507836890175d-09,-1.7587073351565d-13,-4.9570498785129d-22/
      data (pmn(lat,19,23), lat = 1,36)/
     |   8.2553626500563d-24, 8.8471320466960d-15, 1.2334327631583d-10,
     |   5.7604707168262d-08, 4.8946081780301d-06, 1.4523192259952d-04,
     |   2.0686702205047d-03, 1.6869523596028d-02, 8.7351761178032d-02,
     |   3.0492436156707d-01, 7.3713282217991d-01, 1.2219505935662d+00,
     |   1.2755658392204d+00, 5.1652759440022d-01,-6.3421311471515d-01,
     |  -1.0621164257939d+00,-2.4519745308948d-01, 8.5539690432989d-01,
     |   8.5539690432989d-01,-2.4519745308948d-01,-1.0621164257939d+00,
     |  -6.3421311471515d-01, 5.1652759440022d-01, 1.2755658392204d+00,
     |   1.2219505935662d+00, 7.3713282217991d-01, 3.0492436156707d-01,
     |   8.7351761178033d-02, 1.6869523596028d-02, 2.0686702205048d-03,
     |   1.4523192259952d-04, 4.8946081780301d-06, 5.7604707168263d-08,
     |   1.2334327631584d-10, 8.8471320466960d-15, 8.2553626500563d-24/
      data (pmn(lat,20,23), lat = 1,36)/
     |   1.1819485111968d-25, 3.8240906864926d-16, 9.0003488392580d-12,
     |   6.0021492804328d-09, 6.7389325615509d-07, 2.5334775668126d-05,
     |   4.4663105455689d-04, 4.4564551085274d-03, 2.8184196990603d-02,
     |   1.2116120306706d-01, 3.6882069392150d-01, 8.0811099132477d-01,
     |   1.2566830577649d+00, 1.2802967229269d+00, 5.6571729557246d-01,
     |  -5.4244195488805d-01,-1.1144996210835d+00,-5.6625583036617d-01,
     |   5.6625583036617d-01, 1.1144996210835d+00, 5.4244195488805d-01,
     |  -5.6571729557246d-01,-1.2802967229269d+00,-1.2566830577649d+00,
     |  -8.0811099132477d-01,-3.6882069392150d-01,-1.2116120306706d-01,
     |  -2.8184196990603d-02,-4.4564551085274d-03,-4.4663105455689d-04,
     |  -2.5334775668126d-05,-6.7389325615509d-07,-6.0021492804329d-09,
     |  -9.0003488392585d-12,-3.8240906864926d-16,-1.1819485111968d-25/
      data (pmn(lat,21,23), lat = 1,36)/
     |   1.4117885861775d-27, 1.3783574312149d-17, 5.4713461575005d-13,
     |   5.2021075130551d-10, 7.7003693974164d-08, 3.6562610708002d-06,
     |   7.9419221735757d-05, 9.6342295010623d-04, 7.3720619174008d-03,
     |   3.8462979184523d-02, 1.4386095662651d-01, 3.9752437975847d-01,
     |   8.2152664583388d-01, 1.2567061807445d+00, 1.3449610613168d+00,
     |   7.9373030193984d-01,-2.3094289856284d-01,-1.0625139386937d+00,
     |  -1.0625139386937d+00,-2.3094289856284d-01, 7.9373030193983d-01,
     |   1.3449610613168d+00, 1.2567061807445d+00, 8.2152664583388d-01,
     |   3.9752437975847d-01, 1.4386095662651d-01, 3.8462979184523d-02,
     |   7.3720619174009d-03, 9.6342295010624d-04, 7.9419221735758d-05,
     |   3.6562610708002d-06, 7.7003693974164d-08, 5.2021075130553d-10,
     |   5.4713461575008d-13, 1.3783574312149d-17, 1.4117885861775d-27/
      data (pmn(lat,22,23), lat = 1,36)/
     |   1.3290770879927d-29, 3.9140885153274d-19, 2.6182034528435d-14,
     |   3.5444802176001d-11, 6.9040073236682d-09, 4.1291958696641d-07,
     |   1.1010475742686d-05, 1.6155367120511d-04, 1.4848338571628d-03,
     |   9.3019963694106d-03, 4.2046213756259d-02, 1.4251878418424d-01,
     |   3.7141145287298d-01, 7.5403349041150d-01, 1.1922963195726d+00,
     |   1.4359635102337d+00, 1.2151208959593d+00, 4.8039098557665d-01,
     |  -4.8039098557665d-01,-1.2151208959593d+00,-1.4359635102337d+00,
     |  -1.1922963195726d+00,-7.5403349041150d-01,-3.7141145287298d-01,
     |  -1.4251878418425d-01,-4.2046213756259d-02,-9.3019963694106d-03,
     |  -1.4848338571628d-03,-1.6155367120511d-04,-1.1010475742686d-05,
     |  -4.1291958696641d-07,-6.9040073236682d-09,-3.5444802176002d-11,
     |  -2.6182034528436d-14,-3.9140885153274d-19,-1.3290770879927d-29/
      data (pmn(lat,23,23), lat = 1,36)/
     |   8.5558737195385d-32, 7.5976770535065d-21, 8.5581464283347d-16,
     |   1.6477675409415d-12, 4.2164469663105d-10, 3.1692992236732d-08,
     |   1.0342237358636d-06, 1.8277567182839d-05, 2.0060945942472d-04,
     |   1.4967345646865d-03, 8.0791841056682d-03, 3.2984192830329d-02,
     |   1.0519611468279d-01, 2.6840302426514d-01, 5.5754892779349d-01,
     |   9.5501292810513d-01, 1.3608538018506d+00, 1.6222688268785d+00,
     |   1.6222688268785d+00, 1.3608538018506d+00, 9.5501292810513d-01,
     |   5.5754892779349d-01, 2.6840302426514d-01, 1.0519611468279d-01,
     |   3.2984192830330d-02, 8.0791841056682d-03, 1.4967345646865d-03,
     |   2.0060945942472d-04, 1.8277567182839d-05, 1.0342237358636d-06,
     |   3.1692992236732d-08, 4.2164469663105d-10, 1.6477675409416d-12,
     |   8.5581464283352d-16, 7.5976770535065d-21, 8.5558737195385d-32/
      data (pmn(lat, 0,24), lat = 1,36)/
     |   3.6338762572450d+00,-1.5964754870155d+00,-2.9854463625158d-01,
     |   1.3395178598293d+00,-1.0628250665150d+00,-3.7054255358707d-02,
     |   9.3472310160209d-01,-9.1388893757428d-01, 1.0029361869095d-01,
     |   7.2726233305548d-01,-8.4697966931471d-01, 2.0373384318932d-01,
     |   5.8737971152150d-01,-8.1371075445080d-01, 2.9485971638766d-01,
     |   4.7817337214498d-01,-7.9948398701776d-01, 3.8376051748243d-01,
     |   3.8376051748243d-01,-7.9948398701776d-01, 4.7817337214498d-01,
     |   2.9485971638766d-01,-8.1371075445080d-01, 5.8737971152151d-01,
     |   2.0373384318933d-01,-8.4697966931471d-01, 7.2726233305548d-01,
     |   1.0029361869095d-01,-9.1388893757428d-01, 9.3472310160209d-01,
     |  -3.7054255358707d-02,-1.0628250665150d+00, 1.3395178598293d+00,
     |  -2.9854463625156d-01,-1.5964754870155d+00, 3.6338762572450d+00/
      data (pmn(lat, 1,24), lat = 1,36)/
     |   2.2853461605448d+00, 1.2827255952344d+00,-1.7199283358161d+00,
     |   6.5167015076562d-01, 6.7808067741959d-01,-1.1758635637497d+00,
     |   5.8746372733172d-01, 4.3430870691842d-01,-9.6372093284858d-01,
     |   5.9206360479987d-01, 2.7810769075646d-01,-8.4223037792907d-01,
     |   6.1686192389818d-01, 1.5684093913336d-01,-7.6028878526445d-01,
     |   6.5304370612159d-01, 5.0814430823017d-02,-6.9982220444983d-01,
     |   6.9982220444983d-01,-5.0814430823015d-02,-6.5304370612160d-01,
     |   7.6028878526445d-01,-1.5684093913336d-01,-6.1686192389817d-01,
     |   8.4223037792907d-01,-2.7810769075646d-01,-5.9206360479987d-01,
     |   9.6372093284858d-01,-4.3430870691842d-01,-5.8746372733173d-01,
     |   1.1758635637497d+00,-6.7808067741959d-01,-6.5167015076564d-01,
     |   1.7199283358161d+00,-1.2827255952344d+00,-2.2853461605448d+00/
      data (pmn(lat, 2,24), lat = 1,36)/
     |   6.4098366067288d-01, 2.3960066833344d+00,-3.3546076613730d-01,
     |  -1.1727177590021d+00, 1.1984872804602d+00,-1.4762328897219d-01,
     |  -8.6086720600806d-01, 9.6170700061897d-01,-1.8647699405093d-01,
     |  -6.8410637206638d-01, 8.6584795301871d-01,-2.4795738500533d-01,
     |  -5.6209814948591d-01, 8.2038362444678d-01,-3.1495798815394d-01,
     |  -4.6713163902290d-01, 8.0136693714650d-01,-3.8690068713933d-01,
     |  -3.8690068713933d-01, 8.0136693714650d-01,-4.6713163902290d-01,
     |  -3.1495798815394d-01, 8.2038362444678d-01,-5.6209814948592d-01,
     |  -2.4795738500534d-01, 8.6584795301871d-01,-6.8410637206638d-01,
     |  -1.8647699405093d-01, 9.6170700061897d-01,-8.6086720600806d-01,
     |  -1.4762328897219d-01, 1.1984872804602d+00,-1.1727177590021d+00,
     |  -3.3546076613732d-01, 2.3960066833344d+00, 6.4098366067288d-01/
      data (pmn(lat, 3,24), lat = 1,36)/
     |   1.1643695544653d-01, 1.6998971568330d+00, 1.4773658560210d+00,
     |  -1.2642935951970d+00,-2.0548868963241d-01, 1.1332740651651d+00,
     |  -8.1121493940241d-01,-2.3007104398250d-01, 9.3356087071211d-01,
     |  -6.9693656172286d-01,-1.7000174745221d-01, 8.1913567315385d-01,
     |  -6.6695911330797d-01,-1.0159718396081d-01, 7.4654610786168d-01,
     |  -6.7223538729689d-01,-3.3670044907602d-02, 6.9940213234683d-01,
     |  -6.9940213234683d-01, 3.3670044907600d-02, 6.7223538729689d-01,
     |  -7.4654610786168d-01, 1.0159718396081d-01, 6.6695911330797d-01,
     |  -8.1913567315385d-01, 1.7000174745221d-01, 6.9693656172287d-01,
     |  -9.3356087071211d-01, 2.3007104398250d-01, 8.1121493940241d-01,
     |  -1.1332740651651d+00, 2.0548868963241d-01, 1.2642935951970d+00,
     |  -1.4773658560209d+00,-1.6998971568330d+00,-1.1643695544653d-01/
      data (pmn(lat, 4,24), lat = 1,36)/
     |   1.5627252903869d-02, 7.8669145510980d-01, 1.9860720931937d+00,
     |   1.8651095753507d-01,-1.3273378186663d+00, 6.8704216656005d-01,
     |   5.5017523275511d-01,-1.0407909944206d+00, 4.3951433691132d-01,
     |   5.2956921997322d-01,-9.0253157644124d-01, 3.7834290248776d-01,
     |   4.7904975582013d-01,-8.3497145675586d-01, 3.7480354160098d-01,
     |   4.3263330613891d-01,-8.0654198678906d-01, 3.9642549830507d-01,
     |   3.9642549830508d-01,-8.0654198678906d-01, 4.3263330613890d-01,
     |   3.7480354160098d-01,-8.3497145675585d-01, 4.7904975582014d-01,
     |   3.7834290248777d-01,-9.0253157644124d-01, 5.2956921997322d-01,
     |   4.3951433691133d-01,-1.0407909944206d+00, 5.5017523275510d-01,
     |   6.8704216656005d-01,-1.3273378186663d+00, 1.8651095753506d-01,
     |   1.9860720931937d+00, 7.8669145510980d-01, 1.5627252903869d-02/
      data (pmn(lat, 5,24), lat = 1,36)/
     |   1.6583092538338d-03, 2.7337755792285d-01, 1.4883626859696d+00,
     |   1.4694809575410d+00,-8.5756830886156d-01,-7.0265070570591d-01,
     |   1.1036633778308d+00,-2.1891434286950d-01,-7.8064753217356d-01,
     |   8.6292141909854d-01,-5.8878057390825d-02,-7.4469939379170d-01,
     |   7.5438178142631d-01,-1.2591821926598d-02,-7.1242143687814d-01,
     |   7.0871601279021d-01,-1.3707045574300d-03,-6.9845956843987d-01,
     |   6.9845956843987d-01, 1.3707045574323d-03,-7.0871601279021d-01,
     |   7.1242143687814d-01, 1.2591821926600d-02,-7.5438178142631d-01,
     |   7.4469939379170d-01, 5.8878057390825d-02,-8.6292141909854d-01,
     |   7.8064753217356d-01, 2.1891434286950d-01,-1.1036633778308d+00,
     |   7.0265070570591d-01, 8.5756830886156d-01,-1.4694809575410d+00,
     |  -1.4883626859696d+00,-2.7337755792285d-01,-1.6583092538338d-03/
      data (pmn(lat, 6,24), lat = 1,36)/
     |   1.4497270399108d-04, 7.6191535458999d-02, 8.0858709663717d-01,
     |   1.7639698521479d+00, 4.7175504565329d-01,-1.2584030455318d+00,
     |   1.7064404192168d-01, 9.3038423364465d-01,-8.0018603719700d-01,
     |  -2.0299745141357d-01, 8.9149081348553d-01,-5.8036238608427d-01,
     |  -3.1874710779557d-01, 8.4007930458679d-01,-4.7216231438467d-01,
     |  -3.7060211288455d-01, 8.1351057036724d-01,-4.1266091434276d-01,
     |  -4.1266091434277d-01, 8.1351057036724d-01,-3.7060211288455d-01,
     |  -4.7216231438467d-01, 8.4007930458679d-01,-3.1874710779557d-01,
     |  -5.8036238608428d-01, 8.9149081348553d-01,-2.0299745141357d-01,
     |  -8.0018603719700d-01, 9.3038423364465d-01, 1.7064404192169d-01,
     |  -1.2584030455318d+00, 4.7175504565329d-01, 1.7639698521479d+00,
     |   8.0858709663718d-01, 7.6191535458999d-02, 1.4497270399108d-04/
      data (pmn(lat, 7,24), lat = 1,36)/
     |   1.0729778725286d-05, 1.7694770512071d-02, 3.4854914846667d-01,
     |   1.3568606517849d+00, 1.4453110560099d+00,-5.1785916530530d-01,
     |  -9.7939585828518d-01, 8.3720652789972d-01, 3.4538558651814d-01,
     |  -9.6664543184539d-01, 4.0701313470021d-01, 5.6484047066641d-01,
     |  -8.4674240439970d-01, 1.8949657306577d-01, 6.4441397801807d-01,
     |  -7.5803365982886d-01, 5.5792574111995d-02, 6.9677720796951d-01,
     |  -6.9677720796951d-01,-5.5792574111998d-02, 7.5803365982887d-01,
     |  -6.4441397801807d-01,-1.8949657306577d-01, 8.4674240439970d-01,
     |  -5.6484047066640d-01,-4.0701313470021d-01, 9.6664543184539d-01,
     |  -3.4538558651814d-01,-8.3720652789972d-01, 9.7939585828518d-01,
     |   5.1785916530530d-01,-1.4453110560099d+00,-1.3568606517849d+00,
     |  -3.4854914846668d-01,-1.7694770512071d-02,-1.0729778725286d-05/
      data (pmn(lat, 8,24), lat = 1,36)/
     |   6.8531135257272d-07, 3.5102978697122d-03, 1.2478181377193d-01,
     |   7.9657804974684d-01, 1.6166419134255d+00, 6.7737017646319d-01,
     |  -1.0956087356152d+00,-2.8737140234803d-01, 1.0366628417935d+00,
     |  -3.2608450354905d-01,-7.1542550332522d-01, 8.0377686417999d-01,
     |   5.8242847385990d-02,-8.0370601606595d-01, 6.0015889564640d-01,
     |   2.7446820645896d-01,-8.1950310217300d-01, 4.3619778333487d-01,
     |   4.3619778333487d-01,-8.1950310217300d-01, 2.7446820645895d-01,
     |   6.0015889564640d-01,-8.0370601606595d-01, 5.8242847385997d-02,
     |   8.0377686418000d-01,-7.1542550332522d-01,-3.2608450354905d-01,
     |   1.0366628417935d+00,-2.8737140234803d-01,-1.0956087356152d+00,
     |   6.7737017646319d-01, 1.6166419134255d+00, 7.9657804974685d-01,
     |   1.2478181377193d-01, 3.5102978697122d-03, 6.8531135257272d-07/
      data (pmn(lat, 9,24), lat = 1,36)/
     |   3.8300321900335d-08, 6.0510825465644d-04, 3.8130707194442d-02,
     |   3.8190932111619d-01, 1.2505975707687d+00, 1.4316974844852d+00,
     |  -2.0336357318145d-01,-1.1105718911350d+00, 4.3716977293667d-01,
     |   7.7312368266625d-01,-7.9538434455410d-01,-2.1678034401651d-01,
     |   8.8058774318472d-01,-4.2415224269761d-01,-5.2234253486096d-01,
     |   8.1180250574769d-01,-1.3175630296582d-01,-6.9399454759840d-01,
     |   6.9399454759840d-01, 1.3175630296582d-01,-8.1180250574769d-01,
     |   5.2234253486096d-01, 4.2415224269761d-01,-8.8058774318472d-01,
     |   2.1678034401650d-01, 7.9538434455410d-01,-7.7312368266625d-01,
     |  -4.3716977293667d-01, 1.1105718911350d+00, 2.0336357318146d-01,
     |  -1.4316974844852d+00,-1.2505975707687d+00,-3.8190932111620d-01,
     |  -3.8130707194443d-02,-6.0510825465644d-04,-3.8300321900335d-08/
      data (pmn(lat,10,24), lat = 1,36)/
     |   1.8922352860304d-09, 9.1752322181674d-05, 1.0125647152482d-02,
     |   1.5492677059794d-01, 7.6154777226605d-01, 1.5028881670166d+00,
     |   8.6034246781808d-01,-8.6119699130970d-01,-6.7453437564759d-01,
     |   8.9645142015200d-01, 2.4148365603007d-01,-9.2791467696013d-01,
     |   3.0611148394873d-01, 6.7773207815254d-01,-7.4192798540890d-01,
     |  -1.3582224448543d-01, 8.2001379552271d-01,-4.6797972563367d-01,
     |  -4.6797972563368d-01, 8.2001379552271d-01,-1.3582224448542d-01,
     |  -7.4192798540890d-01, 6.7773207815254d-01, 3.0611148394873d-01,
     |  -9.2791467696013d-01, 2.4148365603007d-01, 8.9645142015201d-01,
     |  -6.7453437564759d-01,-8.6119699130970d-01, 8.6034246781807d-01,
     |   1.5028881670166d+00, 7.6154777226605d-01, 1.5492677059794d-01,
     |   1.0125647152483d-02, 9.1752322181674d-05, 1.8922352860304d-09/
      data (pmn(lat,11,24), lat = 1,36)/
     |   8.3268172793001d-11, 1.2346127860232d-05, 2.3655755127861d-03,
     |   5.4326666419031d-02, 3.8526975968910d-01, 1.1478229792297d+00,
     |   1.4276300977531d+00, 1.1897252264005d-01,-1.1110972217310d+00,
     |  -4.6560622681161d-02, 9.7887157595670d-01,-3.1294565910980d-01,
     |  -7.5440380497926d-01, 6.8635983607336d-01, 3.2153927949994d-01,
     |  -8.5540979997449d-01, 2.3195819538783d-01, 6.8955518844790d-01,
     |  -6.8955518844790d-01,-2.3195819538783d-01, 8.5540979997450d-01,
     |  -3.2153927949994d-01,-6.8635983607336d-01, 7.5440380497927d-01,
     |   3.1294565910981d-01,-9.7887157595670d-01, 4.6560622681159d-02,
     |   1.1110972217310d+00,-1.1897252264005d-01,-1.4276300977531d+00,
     |  -1.1478229792297d+00,-3.8526975968910d-01,-5.4326666419031d-02,
     |  -2.3655755127861d-03,-1.2346127860232d-05,-8.3268172793001d-11/
      data (pmn(lat,12,24), lat = 1,36)/
     |   3.2815116442323d-12, 1.4835965882977d-06, 4.9037902431314d-04,
     |   1.6696362341114d-02, 1.6664756238145d-01, 7.0451527464948d-01,
     |   1.3985829790305d+00, 1.0388824783957d+00,-5.4289625227865d-01,
     |  -9.6066802775362d-01, 5.1675186707657d-01, 7.4672643846428d-01,
     |  -7.1259825815532d-01,-4.0436021396795d-01, 8.6226559314240d-01,
     |  -5.3876262791853d-02,-8.0801078411785d-01, 5.0946988103298d-01,
     |   5.0946988103298d-01,-8.0801078411785d-01,-5.3876262791860d-02,
     |   8.6226559314240d-01,-4.0436021396795d-01,-7.1259825815532d-01,
     |   7.4672643846427d-01, 5.1675186707657d-01,-9.6066802775362d-01,
     |  -5.4289625227865d-01, 1.0388824783957d+00, 1.3985829790305d+00,
     |   7.0451527464948d-01, 1.6664756238145d-01, 1.6696362341114d-02,
     |   4.9037902431315d-04, 1.4835965882977d-06, 3.2815116442323d-12/
      data (pmn(lat,13,24), lat = 1,36)/
     |   1.1624150698145d-13, 1.5989776479551d-07, 9.0727222084876d-05,
     |   4.5385326016344d-03, 6.2696065950311d-02, 3.6302741896934d-01,
     |   1.0347574116651d+00, 1.4199300604999d+00, 4.6591759622674d-01,
     |  -9.5483876359761d-01,-5.5334991733981d-01, 8.6312929005017d-01,
     |   3.5201068761914d-01,-8.9543703551434d-01,-2.0456586413749d-02,
     |   8.6462054855509d-01,-3.5930671643036d-01,-6.8261094296245d-01,
     |   6.8261094296245d-01, 3.5930671643037d-01,-8.6462054855509d-01,
     |   2.0456586413747d-02, 8.9543703551434d-01,-3.5201068761915d-01,
     |  -8.6312929005018d-01, 5.5334991733981d-01, 9.5483876359761d-01,
     |  -4.6591759622674d-01,-1.4199300604999d+00,-1.0347574116651d+00,
     |  -3.6302741896934d-01,-6.2696065950311d-02,-4.5385326016345d-03,
     |  -9.0727222084879d-05,-1.5989776479551d-07,-1.1624150698145d-13/
      data (pmn(lat,14,24), lat = 1,36)/
     |   3.7091062393576d-15, 1.5496504948190d-08, 1.5036312768957d-05,
     |   1.0975695046717d-03, 2.0734701752718d-02, 1.6074996383389d-01,
     |   6.2412992117986d-01, 1.2825647753638d+00, 1.2061350594952d+00,
     |  -1.2257883649192d-01,-1.0725455686342d+00,-7.0324038193084d-02,
     |   9.6745926133125d-01,-5.4930555570527d-02,-8.9688033773934d-01,
     |   2.9928856083677d-01, 7.7260514017980d-01,-5.6297670378401d-01,
     |  -5.6297670378401d-01, 7.7260514017980d-01, 2.9928856083678d-01,
     |  -8.9688033773934d-01,-5.4930555570529d-02, 9.6745926133126d-01,
     |  -7.0324038193076d-02,-1.0725455686342d+00,-1.2257883649192d-01,
     |   1.2061350594953d+00, 1.2825647753638d+00, 6.2412992117986d-01,
     |   1.6074996383389d-01, 2.0734701752718d-02, 1.0975695046717d-03,
     |   1.5036312768957d-05, 1.5496504948190d-08, 3.7091062393576d-15/
      data (pmn(lat,15,24), lat = 1,36)/
     |   1.0668028795658d-16, 1.3518262333944d-09, 2.2362009690611d-06,
     |   2.3691834167406d-04, 6.0663013418205d-03, 6.1991067550735d-02,
     |   3.1777691978927d-01, 8.9985174759710d-01, 1.3838944032139d+00,
     |   8.2926572994095d-01,-5.9399912004698d-01,-9.5709733536746d-01,
     |   3.4963267470600d-01, 8.9476383758216d-01,-3.7976470782533d-01,
     |  -8.0104594746205d-01, 5.1619701620643d-01, 6.7183970405114d-01,
     |  -6.7183970405114d-01,-5.1619701620643d-01, 8.0104594746205d-01,
     |   3.7976470782533d-01,-8.9476383758216d-01,-3.4963267470600d-01,
     |   9.5709733536746d-01, 5.9399912004698d-01,-8.2926572994095d-01,
     |  -1.3838944032139d+00,-8.9985174759710d-01,-3.1777691978927d-01,
     |  -6.1991067550735d-02,-6.0663013418205d-03,-2.3691834167406d-04,
     |  -2.2362009690611d-06,-1.3518262333944d-09,-1.0668028795658d-16/
      data (pmn(lat,16,24), lat = 1,36)/
     |   2.7633018728828d-18, 1.0608061751585d-10, 2.9842083354998d-07,
     |   4.5695357230121d-05, 1.5749649550016d-03, 2.0974046892222d-02,
     |   1.3907260099587d-01, 5.1928098874918d-01, 1.1325388009579d+00,
     |   1.3290630976421d+00, 3.9567109449276d-01,-8.9088524215157d-01,
     |  -7.1918479436663d-01, 6.4318045221747d-01, 7.4417811270466d-01,
     |  -5.9230007818848d-01,-6.9670090257370d-01, 6.3234452169903d-01,
     |   6.3234452169904d-01,-6.9670090257370d-01,-5.9230007818848d-01,
     |   7.4417811270466d-01, 6.4318045221747d-01,-7.1918479436664d-01,
     |  -8.9088524215158d-01, 3.9567109449276d-01, 1.3290630976421d+00,
     |   1.1325388009579d+00, 5.1928098874918d-01, 1.3907260099587d-01,
     |   2.0974046892222d-02, 1.5749649550016d-03, 4.5695357230122d-05,
     |   2.9842083354999d-07, 1.0608061751585d-10, 2.7633018728828d-18/
      data (pmn(lat,17,24), lat = 1,36)/
     |   6.4295180344784d-20, 7.4703496883932d-12, 3.5665535564530d-08,
     |   7.8660135559458d-06, 3.6297080517612d-04, 6.2452786230142d-03,
     |   5.2798144407256d-02, 2.5300959496835d-01, 7.3397347247887d-01,
     |   1.2830691929767d+00, 1.1587487477413d+00,-1.1941296131494d-04,
     |  -1.0277916579768d+00,-4.6666706693153d-01, 8.1244249307313d-01,
     |   6.0720033141912d-01,-7.0285619032413d-01,-6.5506776824500d-01,
     |   6.5506776824499d-01, 7.0285619032413d-01,-6.0720033141912d-01,
     |  -8.1244249307313d-01, 4.6666706693153d-01, 1.0277916579768d+00,
     |   1.1941296132212d-04,-1.1587487477413d+00,-1.2830691929767d+00,
     |  -7.3397347247887d-01,-2.5300959496835d-01,-5.2798144407256d-02,
     |  -6.2452786230142d-03,-3.6297080517612d-04,-7.8660135559460d-06,
     |  -3.5665535564532d-08,-7.4703496883932d-12,-6.4295180344784d-20/
      data (pmn(lat,18,24), lat = 1,36)/
     |   1.3375157396311d-21, 4.6996633124150d-13, 3.8014455346376d-09,
     |   1.2041775926079d-06, 7.4067839229499d-05, 1.6355702469875d-03,
     |   1.7443200677006d-02, 1.0533920475475d-01, 3.9206769662119d-01,
     |   9.2753998494985d-01, 1.3451678549561d+00, 9.4083917911486d-01,
     |  -3.0129782075143d-01,-1.0626520791585d+00,-2.7808277204797d-01,
     |   8.9253895575728d-01, 5.5239934573895d-01,-7.2462182922540d-01,
     |  -7.2462182922540d-01, 5.5239934573895d-01, 8.9253895575728d-01,
     |  -2.7808277204797d-01,-1.0626520791585d+00,-3.0129782075142d-01,
     |   9.4083917911485d-01, 1.3451678549561d+00, 9.2753998494986d-01,
     |   3.9206769662119d-01, 1.0533920475475d-01, 1.7443200677006d-02,
     |   1.6355702469875d-03, 7.4067839229499d-05, 1.2041775926079d-06,
     |   3.8014455346377d-09, 4.6996633124150d-13, 1.3375157396311d-21/
      data (pmn(lat,19,24), lat = 1,36)/
     |   2.4690969043772d-23, 2.6218931820844d-14, 3.5879570736037d-10,
     |   1.6285542894954d-07, 1.3304885321987d-05, 3.7505168788864d-04,
     |   5.0050288073572d-03, 3.7596874446930d-02, 1.7545233055290d-01,
     |   5.3526090048182d-01, 1.0764412906614d+00, 1.3434966333448d+00,
     |   7.4562494558608d-01,-4.8836249303599d-01,-1.0637862119886d+00,
     |  -2.0469922857724d-01, 9.1328718325230d-01, 6.2836997091194d-01,
     |  -6.2836997091193d-01,-9.1328718325230d-01, 2.0469922857724d-01,
     |   1.0637862119886d+00, 4.8836249303599d-01,-7.4562494558609d-01,
     |  -1.3434966333448d+00,-1.0764412906614d+00,-5.3526090048182d-01,
     |  -1.7545233055290d-01,-3.7596874446930d-02,-5.0050288073572d-03,
     |  -3.7505168788864d-04,-1.3304885321987d-05,-1.6285542894955d-07,
     |  -3.5879570736039d-10,-2.6218931820844d-14,-2.4690969043772d-23/
      data (pmn(lat,20,24), lat = 1,36)/
     |   3.9982626353955d-25, 1.2823416439622d-15, 2.9652090259223d-11,
     |   1.9246940187318d-08, 2.0823372778821d-06, 7.4608316840179d-05,
     |   1.2378935375070d-03, 1.1454349559238d-02, 6.5965052942455d-02,
     |   2.5212373012165d-01, 6.5941722965703d-01, 1.1739270220862d+00,
     |   1.3207019226587d+00, 6.3252337710043d-01,-5.5816524221903d-01,
     |  -1.0828166263268d+00,-2.9016610455990d-01, 8.5499927012475d-01,
     |   8.5499927012475d-01,-2.9016610455989d-01,-1.0828166263268d+00,
     |  -5.5816524221903d-01, 6.3252337710043d-01, 1.3207019226587d+00,
     |   1.1739270220862d+00, 6.5941722965703d-01, 2.5212373012165d-01,
     |   6.5965052942455d-02, 1.1454349559238d-02, 1.2378935375070d-03,
     |   7.4608316840179d-05, 2.0823372778821d-06, 1.9246940187318d-08,
     |   2.9652090259224d-11, 1.2823416439622d-15, 3.9982626353955d-25/
      data (pmn(lat,21,24), lat = 1,36)/
     |   5.5771615376296d-27, 5.3998629368766d-17, 2.1076478462069d-12,
     |   1.9530896094941d-09, 2.7913098303242d-07, 1.2666147901919d-05,
     |   2.5994820449503d-04, 2.9405927883938d-03, 2.0657564078596d-02,
     |   9.7041711700480d-02, 3.1851602654490d-01, 7.4443803933338d-01,
     |   1.2254510417471d+00, 1.3210374188739d+00, 6.5136260653228d-01,
     |  -4.8940122532117d-01,-1.1235706233996d+00,-5.8339236263508d-01,
     |   5.8339236263508d-01, 1.1235706233996d+00, 4.8940122532118d-01,
     |  -6.5136260653228d-01,-1.3210374188738d+00,-1.2254510417471d+00,
     |  -7.4443803933339d-01,-3.1851602654490d-01,-9.7041711700480d-02,
     |  -2.0657564078596d-02,-2.9405927883938d-03,-2.5994820449503d-04,
     |  -1.2666147901919d-05,-2.7913098303242d-07,-1.9530896094942d-09,
     |  -2.1076478462070d-12,-5.3998629368766d-17,-5.5771615376296d-27/
      data (pmn(lat,22,24), lat = 1,36)/
     |   6.5017707663498d-29, 1.8995405500702d-18, 1.2503559500206d-13,
     |   1.6517544755199d-10, 3.1117646208943d-08, 1.7829591967078d-06,
     |   4.5071241002198d-05, 6.1958622080213d-04, 5.2628515415082d-03,
     |   2.9976464134070d-02, 1.2071150542174d-01, 3.5488956056833d-01,
     |   7.7242682054723d-01, 1.2339692285808d+00, 1.3717380866889d+00,
     |   8.4875457212298d-01,-1.9746513483700d-01,-1.0675455163636d+00,
     |  -1.0675455163636d+00,-1.9746513483700d-01, 8.4875457212297d-01,
     |   1.3717380866889d+00, 1.2339692285808d+00, 7.7242682054723d-01,
     |   3.5488956056833d-01, 1.2071150542174d-01, 2.9976464134070d-02,
     |   5.2628515415083d-03, 6.1958622080213d-04, 4.5071241002199d-05,
     |   1.7829591967078d-06, 3.1117646208943d-08, 1.6517544755199d-10,
     |   1.2503559500207d-13, 1.8995405500702d-18, 6.5017707663498d-29/
      data (pmn(lat,23,24), lat = 1,36)/
     |   5.9834112965087d-31, 5.2728745111537d-20, 5.8486989304316d-15,
     |   1.1000526842821d-11, 2.7268423364655d-09, 1.9678419214870d-07,
     |   6.1057881631881d-06, 1.0150398283832d-04, 1.0353336558850d-03,
     |   7.0782545071147d-03, 3.4428069629738d-02, 1.2405675722560d-01,
     |   3.4001912050746d-01, 7.1899373408068d-01, 1.1736073726642d+00,
     |   1.4469184062548d+00, 1.2433894544661d+00, 4.9533660659225d-01,
     |  -4.9533660659225d-01,-1.2433894544661d+00,-1.4469184062548d+00,
     |  -1.1736073726642d+00,-7.1899373408068d-01,-3.4001912050745d-01,
     |  -1.2405675722561d-01,-3.4428069629738d-02,-7.0782545071147d-03,
     |  -1.0353336558850d-03,-1.0150398283832d-04,-6.1057881631882d-06,
     |  -1.9678419214870d-07,-2.7268423364655d-09,-1.1000526842821d-11,
     |  -5.8486989304320d-15,-5.2728745111537d-20,-5.9834112965087d-31/
      data (pmn(lat,24,24), lat = 1,36)/
     |   3.7706945124446d-33, 1.0019727709845d-21, 1.8715174673515d-16,
     |   5.0062803807707d-13, 1.6302857186426d-10, 1.4785848956395d-08,
     |   5.6144658698224d-07, 1.1241983358519d-05, 1.3693427759900d-04,
     |   1.1149441001659d-03, 6.4760706907891d-03, 2.8106869283229d-02,
     |   9.4277063130739d-02, 2.5054178787562d-01, 5.3725430958656d-01,
     |   9.4203748681592d-01, 1.3631933487760d+00, 1.6375203105139d+00,
     |   1.6375203105139d+00, 1.3631933487760d+00, 9.4203748681592d-01,
     |   5.3725430958656d-01, 2.5054178787562d-01, 9.4277063130739d-02,
     |   2.8106869283229d-02, 6.4760706907891d-03, 1.1149441001659d-03,
     |   1.3693427759901d-04, 1.1241983358519d-05, 5.6144658698225d-07,
     |   1.4785848956395d-08, 1.6302857186426d-10, 5.0062803807709d-13,
     |   1.8715174673516d-16, 1.0019727709845d-21, 3.7706945124446d-33/
      data (pmn(lat, 0,25), lat = 1,36)/
     |   3.6041220887272d+00,-1.7821576930950d+00, 7.4751878522850d-02,
     |   1.1074510057058d+00,-1.2611454494204d+00, 5.0920012762456d-01,
     |   4.8874991655099d-01,-1.0039679825858d+00, 7.2625280921361d-01,
     |   6.4921326484865d-02,-7.4657353146681d-01, 8.2171768061012d-01,
     |  -2.7023828312720d-01,-4.6252801804008d-01, 8.1526172282978d-01,
     |  -5.3171698672805d-01,-1.5682110608015d-01, 7.1594830317115d-01,
     |  -7.1594830317115d-01, 1.5682110608015d-01, 5.3171698672806d-01,
     |  -8.1526172282978d-01, 4.6252801804008d-01, 2.7023828312719d-01,
     |  -8.2171768061013d-01, 7.4657353146681d-01,-6.4921326484862d-02,
     |  -7.2625280921362d-01, 1.0039679825858d+00,-4.8874991655098d-01,
     |  -5.0920012762456d-01, 1.2611454494204d+00,-1.1074510057058d+00,
     |  -7.4751878522872d-02, 1.7821576930950d+00,-3.6041220887272d+00/
      data (pmn(lat, 1,25), lat = 1,36)/
     |   2.3964890353187d+00, 1.0380824024542d+00,-1.7105210721911d+00,
     |   1.0121496282172d+00, 2.0716341081937d-01,-1.0394482226663d+00,
     |   9.8806542855714d-01,-2.1882743476642d-01,-6.2866318586759d-01,
     |   9.2846909964449d-01,-5.0627207115351d-01,-2.7166626458427d-01,
     |   8.0040641323204d-01,-6.9323485155046d-01, 5.7231038136670d-02,
     |   6.0556506527349d-01,-7.8645415642487d-01, 3.5362489703731d-01,
     |   3.5362489703732d-01,-7.8645415642487d-01, 6.0556506527349d-01,
     |   5.7231038136672d-02,-6.9323485155046d-01, 8.0040641323205d-01,
     |  -2.7166626458426d-01,-5.0627207115351d-01, 9.2846909964450d-01,
     |  -6.2866318586759d-01,-2.1882743476643d-01, 9.8806542855714d-01,
     |  -1.0394482226663d+00, 2.0716341081937d-01, 1.0121496282172d+00,
     |  -1.7105210721911d+00, 1.0380824024542d+00, 2.3964890353187d+00/
      data (pmn(lat, 2,25), lat = 1,36)/
     |   7.0277778350065d-01, 2.4044113928210d+00,-6.8106680119513d-01,
     |  -8.5694720382923d-01, 1.3023846136313d+00,-6.6686572124189d-01,
     |  -3.6764927765806d-01, 9.8311015026530d-01,-7.8127510099949d-01,
     |   1.8225601569270d-03, 7.1720318884266d-01,-8.3658248902990d-01,
     |   3.0339130650132d-01, 4.4068082515459d-01,-8.1510113406274d-01,
     |   5.4308462427090d-01, 1.4892816258974d-01,-7.1583926120229d-01,
     |   7.1583926120229d-01,-1.4892816258973d-01,-5.4308462427091d-01,
     |   8.1510113406274d-01,-4.4068082515459d-01,-3.0339130650132d-01,
     |   8.3658248902991d-01,-7.1720318884266d-01,-1.8225601569298d-03,
     |   7.8127510099950d-01,-9.8311015026530d-01, 3.6764927765805d-01,
     |   6.6686572124189d-01,-1.3023846136313d+00, 8.5694720382922d-01,
     |   6.8106680119515d-01,-2.4044113928210d+00,-7.0277778350065d-01/
      data (pmn(lat, 3,25), lat = 1,36)/
     |   1.3320559409184d-01, 1.8374008800735d+00, 1.2315952058389d+00,
     |  -1.4436874518923d+00, 2.8779502168736d-01, 8.4075158682800d-01,
     |  -1.0820919255592d+00, 4.2145360280089d-01, 4.9622203069703d-01,
     |  -9.3108484080392d-01, 5.9458597031546d-01, 1.8850209062107d-01,
     |  -7.7799417455440d-01, 7.2415612233704d-01,-9.7917437135972d-02,
     |  -5.8846525585318d-01, 7.9198323885427d-01,-3.5964776572702d-01,
     |  -3.5964776572702d-01, 7.9198323885427d-01,-5.8846525585317d-01,
     |  -9.7917437135974d-02, 7.2415612233704d-01,-7.7799417455441d-01,
     |   1.8850209062106d-01, 5.9458597031546d-01,-9.3108484080392d-01,
     |   4.9622203069703d-01, 4.2145360280089d-01,-1.0820919255592d+00,
     |   8.4075158682800d-01, 2.8779502168736d-01,-1.4436874518923d+00,
     |   1.2315952058389d+00, 1.8374008800735d+00, 1.3320559409184d-01/
      data (pmn(lat, 4,25), lat = 1,36)/
     |   1.8645381288750d-02, 8.9955481659074d-01, 2.0038963220565d+00,
     |  -2.2668927005298d-01,-1.1434502977373d+00, 1.0536412253737d+00,
     |  -3.4102036028482d-02,-8.5725224381821d-01, 9.1357679322317d-01,
     |  -2.0449791868863d-01,-6.1219099612927d-01, 8.6903328933342d-01,
     |  -4.0101875071275d-01,-3.7149608172384d-01, 8.1159122706388d-01,
     |  -5.7662200948120d-01,-1.2485909444460d-01, 7.1546737774679d-01,
     |  -7.1546737774679d-01, 1.2485909444460d-01, 5.7662200948121d-01,
     |  -8.1159122706388d-01, 3.7149608172384d-01, 4.0101875071274d-01,
     |  -8.6903328933342d-01, 6.1219099612927d-01, 2.0449791868863d-01,
     |  -9.1357679322317d-01, 8.5725224381821d-01, 3.4102036028492d-02,
     |  -1.0536412253737d+00, 1.1434502977373d+00, 2.2668927005299d-01,
     |  -2.0038963220565d+00,-8.9955481659074d-01,-1.8645381288750d-02/
      data (pmn(lat, 5,25), lat = 1,36)/
     |   2.0637801644722d-03, 3.2877113567715d-01, 1.6415863575817d+00,
     |   1.2236703140812d+00,-1.1694747347141d+00,-2.0095985624828d-01,
     |   1.0718793546318d+00,-7.8020129367624d-01,-1.8159313540153d-01,
     |   8.7725216672665d-01,-7.4807172856774d-01,-1.3236298534839d-02,
     |   7.1638156653512d-01,-7.7778483283187d-01, 1.8009757612165d-01,
     |   5.5144552196494d-01,-8.0223508951427d-01, 3.7188044754378d-01,
     |   3.7188044754378d-01,-8.0223508951427d-01, 5.5144552196493d-01,
     |   1.8009757612165d-01,-7.7778483283187d-01, 7.1638156653512d-01,
     |  -1.3236298534829d-02,-7.4807172856774d-01, 8.7725216672665d-01,
     |  -1.8159313540153d-01,-7.8020129367625d-01, 1.0718793546318d+00,
     |  -2.0095985624828d-01,-1.1694747347141d+00, 1.2236703140812d+00,
     |   1.6415863575817d+00, 3.2877113567715d-01, 2.0637801644722d-03/
      data (pmn(lat, 6,25), lat = 1,36)/
     |   1.8827518066920d-04, 9.6145368052090d-02, 9.5381399424017d-01,
     |   1.7871517456886d+00, 1.8745413795906d-02,-1.2171418552310d+00,
     |   7.1008965998669d-01, 4.5578999428998d-01,-1.0005035241324d+00,
     |   5.2897583619362d-01, 3.8657804882126d-01,-8.7940014281382d-01,
     |   5.5400997579918d-01, 2.4509383935460d-01,-7.9530491370348d-01,
     |   6.3035138310255d-01, 8.3445486845490d-02,-7.1469340003680d-01,
     |   7.1469340003680d-01,-8.3445486845488d-02,-6.3035138310255d-01,
     |   7.9530491370347d-01,-2.4509383935460d-01,-5.5400997579918d-01,
     |   8.7940014281382d-01,-3.8657804882126d-01,-5.2897583619362d-01,
     |   1.0005035241324d+00,-4.5578999428997d-01,-7.1008965998670d-01,
     |   1.2171418552310d+00,-1.8745413795906d-02,-1.7871517456886d+00,
     |  -9.5381399424018d-01,-9.6145368052090d-02,-1.8827518066920d-04/
      data (pmn(lat, 7,25), lat = 1,36)/
     |   1.4551889257445d-05, 2.3409509709321d-02, 4.3610601368407d-01,
     |   1.5227850178111d+00, 1.2029834154343d+00,-9.3494016302726d-01,
     |  -5.3996092383379d-01, 1.0769401826005d+00,-3.4799185307099d-01,
     |  -6.4997249535548d-01, 8.9977802645508d-01,-2.5928234870921d-01,
     |  -5.8306292692880d-01, 8.3482957394869d-01,-3.0390145723765d-01,
     |  -4.8885166992196d-01, 8.1545960038762d-01,-3.9071835201786d-01,
     |  -3.9071835201786d-01, 8.1545960038762d-01,-4.8885166992195d-01,
     |  -3.0390145723765d-01, 8.3482957394869d-01,-5.8306292692881d-01,
     |  -2.5928234870922d-01, 8.9977802645508d-01,-6.4997249535548d-01,
     |  -3.4799185307100d-01, 1.0769401826005d+00,-5.3996092383379d-01,
     |  -9.3494016302726d-01, 1.2029834154343d+00, 1.5227850178111d+00,
     |   4.3610601368408d-01, 2.3409509709321d-02, 1.4551889257445d-05/
      data (pmn(lat, 8,25), lat = 1,36)/
     |   9.7152820043622d-07, 4.8687158055526d-03, 1.6499356159036d-01,
     |   9.6619540296750d-01, 1.6493195587637d+00, 1.9972900750466d-01,
     |  -1.2052753959436d+00, 3.4507583060763d-01, 7.9407720753979d-01,
     |  -8.7729624024299d-01, 5.4909854848792d-03, 7.9481862854620d-01,
     |  -7.3485268420146d-01,-4.9329790446498d-02, 7.4958115726253d-01,
     |  -6.9999048937937d-01,-2.2754200958564d-02, 7.1326743765329d-01,
     |  -7.1326743765329d-01, 2.2754200958562d-02, 6.9999048937938d-01,
     |  -7.4958115726252d-01, 4.9329790446496d-02, 7.3485268420146d-01,
     |  -7.9481862854620d-01,-5.4909854848792d-03, 8.7729624024299d-01,
     |  -7.9407720753979d-01,-3.4507583060764d-01, 1.2052753959436d+00,
     |  -1.9972900750466d-01,-1.6493195587637d+00,-9.6619540296751d-01,
     |  -1.6499356159036d-01,-4.8687158055526d-03,-9.7152820043622d-07/
      data (pmn(lat, 9,25), lat = 1,36)/
     |   5.6824118389174d-08, 8.8038213005852d-04, 5.3198545200393d-02,
     |   4.9566493253816d-01, 1.4304231100952d+00, 1.2031331634215d+00,
     |  -7.1170150451508d-01,-7.9245560790788d-01, 9.2949722332500d-01,
     |   1.2390599858322d-01,-9.0934263261319d-01, 5.9983220419262d-01,
     |   3.3649278909289d-01,-8.5990389046524d-01, 4.6536751316476d-01,
     |   3.9229463708119d-01,-8.2866283304368d-01, 4.1681463860772d-01,
     |   4.1681463860773d-01,-8.2866283304368d-01, 3.9229463708118d-01,
     |   4.6536751316476d-01,-8.5990389046524d-01, 3.3649278909290d-01,
     |   5.9983220419262d-01,-9.0934263261319d-01, 1.2390599858322d-01,
     |   9.2949722332500d-01,-7.9245560790787d-01,-7.1170150451509d-01,
     |   1.2031331634215d+00, 1.4304231100952d+00, 4.9566493253816d-01,
     |   5.3198545200394d-02, 8.8038213005852d-04, 5.6824118389174d-08/
      data (pmn(lat,10,25), lat = 1,36)/
     |   2.9424492310156d-09, 1.4017409983171d-04, 1.4901003039983d-02,
     |   2.1416026685284d-01, 9.5113288779436d-01, 1.5550728606592d+00,
     |   3.7474685748740d-01,-1.1361262530190d+00,-3.5170370538715d-02,
     |   9.7764624856320d-01,-5.3632427593889d-01,-5.1682455361492d-01,
     |   8.7980827552496d-01,-2.2081094922092d-01,-6.4992432415783d-01,
     |   7.7730383572571d-01,-5.9865296281597d-02,-7.1079749939814d-01,
     |   7.1079749939813d-01, 5.9865296281598d-02,-7.7730383572571d-01,
     |   6.4992432415783d-01, 2.2081094922093d-01,-8.7980827552496d-01,
     |   5.1682455361492d-01, 5.3632427593889d-01,-9.7764624856320d-01,
     |   3.5170370538710d-02, 1.1361262530190d+00,-3.7474685748739d-01,
     |  -1.5550728606592d+00,-9.5113288779436d-01,-2.1416026685284d-01,
     |  -1.4901003039983d-02,-1.4017409983171d-04,-2.9424492310156d-09/
      data (pmn(lat,11,25), lat = 1,36)/
     |   1.3595352926833d-10, 1.9834676119050d-05, 3.6739236861210d-03,
     |   7.9827292138086d-02, 5.1961534109604d-01, 1.3458193807250d+00,
     |   1.2310331906121d+00,-4.6732487676674d-01,-9.7958736963609d-01,
     |   6.4484327549781d-01, 5.7183533752873d-01,-8.9421555734788d-01,
     |   5.1515465252743d-02, 7.9696453758057d-01,-6.5027443704253d-01,
     |  -2.5118032325511d-01, 8.3708568132909d-01,-4.5117314271223d-01,
     |  -4.5117314271224d-01, 8.3708568132909d-01,-2.5118032325510d-01,
     |  -6.5027443704253d-01, 7.9696453758057d-01, 5.1515465252736d-02,
     |  -8.9421555734789d-01, 5.7183533752873d-01, 6.4484327549781d-01,
     |  -9.7958736963609d-01,-4.6732487676675d-01, 1.2310331906121d+00,
     |   1.3458193807250d+00, 5.1961534109604d-01, 7.9827292138087d-02,
     |   3.6739236861211d-03, 1.9834676119050d-05, 1.3595352926833d-10/
      data (pmn(lat,12,25), lat = 1,36)/
     |   5.6375959408196d-12, 2.5111750948480d-06, 8.0475682530719d-04,
     |   2.6069039725951d-02, 2.4147342879262d-01, 9.1125720864163d-01,
     |   1.4852203515101d+00, 5.7129864783179d-01,-9.9744308568385d-01,
     |  -4.2702245327232d-01, 9.7173500741978d-01,-2.2979375832853d-02,
     |  -8.7237497850757d-01, 5.4454704593561d-01, 4.6539455677015d-01,
     |  -8.4746546346258d-01, 1.6764964184325d-01, 7.0669351144933d-01,
     |  -7.0669351144933d-01,-1.6764964184325d-01, 8.4746546346258d-01,
     |  -4.6539455677015d-01,-5.4454704593561d-01, 8.7237497850758d-01,
     |   2.2979375832862d-02,-9.7173500741978d-01, 4.2702245327232d-01,
     |   9.9744308568385d-01,-5.7129864783178d-01,-1.4852203515101d+00,
     |  -9.1125720864163d-01,-2.4147342879262d-01,-2.6069039725951d-02,
     |  -8.0475682530721d-04,-2.5111750948480d-06,-5.6375959408196d-12/
      data (pmn(lat,13,25), lat = 1,36)/
     |   2.1067366700130d-13, 2.8582984722440d-07, 1.5762903266514d-04,
     |   7.5358230302388d-03, 9.7407864483636d-02, 5.1209511323786d-01,
     |   1.2568125838512d+00, 1.2824949555631d+00,-1.7229307953834d-01,
     |  -1.0828452865435d+00, 2.1958734836105d-01, 8.9987191637586d-01,
     |  -5.4312624751110d-01,-5.7253355480409d-01, 8.2433292590025d-01,
     |   5.4336153147290d-02,-8.3334555397805d-01, 4.9532030675363d-01,
     |   4.9532030675363d-01,-8.3334555397804d-01, 5.4336153147282d-02,
     |   8.2433292590025d-01,-5.7253355480409d-01,-5.4312624751110d-01,
     |   8.9987191637586d-01, 2.1958734836105d-01,-1.0828452865435d+00,
     |  -1.7229307953834d-01, 1.2824949555631d+00, 1.2568125838512d+00,
     |   5.1209511323786d-01, 9.7407864483636d-02, 7.5358230302389d-03,
     |   1.5762903266514d-04, 2.8582984722440d-07, 2.1067366700130d-13/
      data (pmn(lat,14,25), lat = 1,36)/
     |   7.1138136690143d-15, 2.9342177555215d-08, 2.7728987931543d-05,
     |   1.9415265591573d-03, 3.4540852970529d-02, 2.4606319945210d-01,
     |   8.4509236765217d-01, 1.4217951593948d+00, 7.9879754523258d-01,
     |  -7.5380608105718d-01,-7.9585666820720d-01, 7.1260784287209d-01,
     |   5.5647655698037d-01,-8.4448913232777d-01,-1.6577309980047d-01,
     |   8.8516552745622d-01,-3.0410107542480d-01,-7.0006716342776d-01,
     |   7.0006716342776d-01, 3.0410107542480d-01,-8.8516552745622d-01,
     |   1.6577309980047d-01, 8.4448913232777d-01,-5.5647655698037d-01,
     |  -7.1260784287210d-01, 7.9585666820720d-01, 7.5380608105718d-01,
     |  -7.9879754523258d-01,-1.4217951593948d+00,-8.4509236765218d-01,
     |  -2.4606319945210d-01,-3.4540852970529d-02,-1.9415265591573d-03,
     |  -2.7728987931543d-05,-2.9342177555215d-08,-7.1138136690143d-15/
      data (pmn(lat,15,25), lat = 1,36)/
     |   2.1734749273218d-16, 2.7212786344809d-09, 4.3920933736476d-06,
     |   4.4773731691660d-04, 1.0852195790911d-02, 1.0282203009062d-01,
     |   4.7452913619204d-01, 1.1506929433826d+00, 1.3413233829054d+00,
     |   1.9474077267103d-01,-1.0416342836957d+00,-3.2206682018894d-01,
     |   9.4682416726735d-01, 1.2354141959750d-01,-9.1992708874780d-01,
     |   2.0590742219726d-01, 8.0601065337220d-01,-5.5163785048095d-01,
     |  -5.5163785048095d-01, 8.0601065337220d-01, 2.0590742219726d-01,
     |  -9.1992708874780d-01, 1.2354141959749d-01, 9.4682416726735d-01,
     |  -3.2206682018893d-01,-1.0416342836957d+00, 1.9474077267103d-01,
     |   1.3413233829054d+00, 1.1506929433826d+00, 4.7452913619205d-01,
     |   1.0282203009062d-01, 1.0852195790911d-02, 4.4773731691660d-04,
     |   4.3920933736478d-06, 2.7212786344809d-09, 2.1734749273218d-16/
      data (pmn(lat,16,25), lat = 1,36)/
     |   6.0086592284519d-18, 2.2807627086792d-10, 6.2698259833121d-07,
     |   9.2621168889948d-05, 3.0348240479295d-03, 3.7736863413351d-02,
     |   2.2811808510043d-01, 7.4892326546229d-01, 1.3412483730030d+00,
     |   1.0452836608101d+00,-3.5974063166164d-01,-1.0422109838629d+00,
     |   1.5378027226850d-01, 9.5065661962129d-01,-2.5800835591130d-01,
     |  -8.4934529475701d-01, 4.7224722198396d-01, 6.8954301212761d-01,
     |  -6.8954301212761d-01,-4.7224722198396d-01, 8.4934529475701d-01,
     |   2.5800835591130d-01,-9.5065661962129d-01,-1.5378027226850d-01,
     |   1.0422109838629d+00, 3.5974063166164d-01,-1.0452836608101d+00,
     |  -1.3412483730030d+00,-7.4892326546229d-01,-2.2811808510043d-01,
     |  -3.7736863413351d-02,-3.0348240479295d-03,-9.2621168889949d-05,
     |  -6.2698259833123d-07,-2.2807627086792d-10,-6.0086592284519d-18/
      data (pmn(lat,17,25), lat = 1,36)/
     |   1.5009647880589d-19, 1.7254613846842d-11, 8.0609663351293d-08,
     |   1.7190858157404d-05, 7.5683792961372d-04, 1.2228615441150d-02,
     |   9.5147287536576d-02, 4.0801660147709d-01, 1.0121875714753d+00,
     |   1.3736717897196d+00, 6.3049626797494d-01,-7.5739366624248d-01,
     |  -8.5432796380754d-01, 5.1945053098928d-01, 8.2418113863378d-01,
     |  -5.2436175628070d-01,-7.3710458246515d-01, 6.2406499761855d-01,
     |   6.2406499761855d-01,-7.3710458246515d-01,-5.2436175628071d-01,
     |   8.2418113863378d-01, 5.1945053098928d-01,-8.5432796380754d-01,
     |  -7.5739366624248d-01, 6.3049626797494d-01, 1.3736717897196d+00,
     |   1.0121875714753d+00, 4.0801660147709d-01, 9.5147287536577d-02,
     |   1.2228615441150d-02, 7.5683792961372d-04, 1.7190858157405d-05,
     |   8.0609663351296d-08, 1.7254613846842d-11, 1.5009647880589d-19/
      data (pmn(lat,18,25), lat = 1,36)/
     |   3.3777447969771d-21, 1.1749365270744d-12, 9.3109646462500d-09,
     |   2.8576493994508d-06, 1.6821924711840d-04, 3.5047742245330d-03,
     |   3.4658670403846d-02, 1.8969647717414d-01, 6.1895224077505d-01,
     |   1.2117419200359d+00, 1.2639752511327d+00, 2.0798009340462d-01,
     |  -9.7646996256599d-01,-6.0210152451252d-01, 7.4682867690402d-01,
     |   6.7722868758342d-01,-6.7292782179496d-01,-6.7286795009739d-01,
     |   6.7286795009738d-01, 6.7292782179496d-01,-6.7722868758341d-01,
     |  -7.4682867690402d-01, 6.0210152451252d-01, 9.7646996256599d-01,
     |  -2.0798009340461d-01,-1.2639752511327d+00,-1.2117419200359d+00,
     |  -6.1895224077505d-01,-1.8969647717414d-01,-3.4658670403846d-02,
     |  -3.5047742245330d-03,-1.6821924711840d-04,-2.8576493994508d-06,
     |  -9.3109646462503d-09,-1.1749365270744d-12,-3.3777447969771d-21/
      data (pmn(lat,19,25), lat = 1,36)/
     |   6.8133206437096d-23, 7.1660135405647d-14, 9.6178035438503d-10,
     |   4.2371083856866d-07, 3.3217588834651d-05, 8.8700545394512d-04,
     |   1.1042577635247d-02, 7.5911466772984d-02, 3.1587362089860d-01,
     |   8.2593110303636d-01, 1.3231848515098d+00, 1.0722257411575d+00,
     |  -1.3983122096251d-01,-1.0605582830471d+00,-3.8799089189033d-01,
     |   8.6213621902690d-01, 5.9726275183035d-01,-7.1979159233477d-01,
     |  -7.1979159233478d-01, 5.9726275183035d-01, 8.6213621902691d-01,
     |  -3.8799089189033d-01,-1.0605582830471d+00,-1.3983122096250d-01,
     |   1.0722257411575d+00, 1.3231848515098d+00, 8.2593110303636d-01,
     |   3.1587362089860d-01, 7.5911466772984d-02, 1.1042577635247d-02,
     |   8.8700545394512d-04, 3.3217588834651d-05, 4.2371083856867d-07,
     |   9.6178035438507d-10, 7.1660135405647d-14, 6.8133206437096d-23/
      data (pmn(lat,20,25), lat = 1,36)/
     |   1.2223264441743d-24, 3.8847421723186d-15, 8.8186065174196d-11,
     |   5.5645089504972d-08, 5.7906218656724d-06, 1.9720955670079d-04,
     |   3.0679186342558d-03, 2.6179362478404d-02, 1.3611659183187d-01,
     |   4.5603498613044d-01, 9.9803030551748d-01, 1.3575682862266d+00,
     |   8.7458514038510d-01,-3.7284514319810d-01,-1.0805620509316d+00,
     |  -2.8130648964965d-01, 9.0056654864717d-01, 6.4598197439426d-01,
     |  -6.4598197439426d-01,-9.0056654864717d-01, 2.8130648964965d-01,
     |   1.0805620509316d+00, 3.7284514319810d-01,-8.7458514038511d-01,
     |  -1.3575682862266d+00,-9.9803030551748d-01,-4.5603498613044d-01,
     |  -1.3611659183187d-01,-2.6179362478404d-02,-3.0679186342558d-03,
     |  -1.9720955670079d-04,-5.7906218656724d-06,-5.5645089504974d-08,
     |  -8.8186065174200d-11,-3.8847421723186d-15,-1.2223264441743d-24/
      data (pmn(lat,21,25), lat = 1,36)/
     |   1.9274325433043d-26, 1.8500067981590d-16, 7.0950327724506d-12,
     |   6.4004441621040d-09, 8.8167295413030d-07, 3.8142158551675d-05,
     |   7.3709765155248d-04, 7.7379416414235d-03, 4.9550762968656d-02,
     |   2.0729142330032d-01, 5.8622074618941d-01, 1.1193767230504d+00,
     |   1.3523148210547d+00, 7.4175359592227d-01,-4.7822593054296d-01,
     |  -1.0985878417701d+00,-3.3440843651921d-01, 8.5426367177446d-01,
     |   8.5426367177446d-01,-3.3440843651920d-01,-1.0985878417701d+00,
     |  -4.7822593054296d-01, 7.4175359592227d-01, 1.3523148210547d+00,
     |   1.1193767230504d+00, 5.8622074618941d-01, 2.0729142330032d-01,
     |   4.9550762968656d-02, 7.7379416414235d-03, 7.3709765155249d-04,
     |   3.8142158551675d-05, 8.8167295413030d-07, 6.4004441621042d-09,
     |   7.0950327724510d-12, 1.8500067981590d-16, 1.9274325433043d-26/
      data (pmn(lat,22,25), lat = 1,36)/
     |   2.6227533844798d-28, 7.5991490279806d-18, 4.9188151229186d-13,
     |   6.3336641765599d-10, 1.1522145838210d-07, 6.3105567275807d-06,
     |   1.5076572379304d-04, 1.9334513461092d-03, 1.5085851082617d-02,
     |   7.7431403971112d-02, 2.7398455758151d-01, 6.8283527838207d-01,
     |   1.1890200986578d+00, 1.3535353235296d+00, 7.3330740007871d-01,
     |  -4.3489066783946d-01,-1.1309530953529d+00,-6.0025540744834d-01,
     |   6.0025540744834d-01, 1.1309530953529d+00, 4.3489066783947d-01,
     |  -7.3330740007870d-01,-1.3535353235296d+00,-1.1890200986578d+00,
     |  -6.8283527838208d-01,-2.7398455758151d-01,-7.7431403971112d-02,
     |  -1.5085851082618d-02,-1.9334513461092d-03,-1.5076572379304d-04,
     |  -6.3105567275807d-06,-1.1522145838210d-07,-6.3336641765601d-10,
     |  -4.9188151229189d-13,-7.5991490279806d-18,-2.6227533844798d-28/
      data (pmn(lat,23,25), lat = 1,36)/
     |   2.9875193647644d-30, 2.6118715962101d-19, 2.8509429985277d-14,
     |   5.2326929417168d-11, 1.2546220170261d-08, 8.6746705403807d-07,
     |   2.5519716957498d-05, 3.9754125320295d-04, 3.7483449352858d-03,
     |   2.3307234162361d-02, 1.0104324026916d-01, 3.1604148242682d-01,
     |   7.2436996059280d-01, 1.2081921145343d+00, 1.3941987289026d+00,
     |   9.0174235228740d-01,-1.6384214270452d-01,-1.0721844078348d+00,
     |  -1.0721844078348d+00,-1.6384214270452d-01, 9.0174235228740d-01,
     |   1.3941987289026d+00, 1.2081921145343d+00, 7.2436996059280d-01,
     |   3.1604148242683d-01, 1.0104324026916d-01, 2.3307234162361d-02,
     |   3.7483449352858d-03, 3.9754125320295d-04, 2.5519716957498d-05,
     |   8.6746705403807d-07, 1.2546220170261d-08, 5.2326929417170d-11,
     |   2.8509429985279d-14, 2.6118715962101d-19, 2.9875193647644d-30/
      data (pmn(lat,24,25), lat = 1,36)/
     |   2.6902515359283d-32, 7.0943003929006d-21, 1.3048496879100d-15,
     |   3.4097281778120d-12, 1.0756330999629d-09, 9.3661320700442d-08,
     |   3.3816038244260d-06, 6.3693436411121d-05, 7.2098818413383d-04,
     |   5.3792475141415d-03, 2.8154239234380d-02, 1.0784849424047d-01,
     |   3.1088282735027d-01, 6.8470724127795d-01, 1.1537369455161d+00,
     |   1.4560960502640d+00, 1.2706917644904d+00, 5.1009532705376d-01,
     |  -5.1009532705376d-01,-1.2706917644904d+00,-1.4560960502640d+00,
     |  -1.1537369455161d+00,-6.8470724127795d-01,-3.1088282735027d-01,
     |  -1.0784849424047d-01,-2.8154239234380d-02,-5.3792475141415d-03,
     |  -7.2098818413384d-04,-6.3693436411121d-05,-3.3816038244260d-06,
     |  -9.3661320700442d-08,-1.0756330999629d-09,-3.4097281778121d-12,
     |  -1.3048496879100d-15,-7.0943003929006d-21,-2.6902515359283d-32/
      data (pmn(lat,25,25), lat = 1,36)/
     |   1.6611199587508d-34, 1.3208505281103d-22, 4.0910116980568d-17,
     |   1.5203971924391d-13, 6.3009128182084d-11, 6.8952807079568d-09,
     |   3.0466674732770d-07, 6.9117839081338d-06, 9.3431991715796d-05,
     |   8.3020255182500d-04, 5.1889360842667d-03, 2.3940970505054d-02,
     |   8.4456884138491d-02, 2.3377367494262d-01, 5.1748706094331d-01,
     |   9.2885898011802d-01, 1.3649794419929d+00, 1.6522403813728d+00,
     |   1.6522403813728d+00, 1.3649794419929d+00, 9.2885898011802d-01,
     |   5.1748706094331d-01, 2.3377367494262d-01, 8.4456884138491d-02,
     |   2.3940970505054d-02, 5.1889360842667d-03, 8.3020255182500d-04,
     |   9.3431991715797d-05, 6.9117839081339d-06, 3.0466674732771d-07,
     |   6.8952807079568d-09, 6.3009128182084d-11, 1.5203971924392d-13,
     |   4.0910116980570d-17, 1.3208505281103d-22, 1.6611199587508d-34/
      data (pmn(lat, 0,26), lat = 1,36)/
     |   3.5661206768497d+00,-1.9366690847744d+00, 4.4448207161471d-01,
     |   7.7246087240028d-01,-1.2670208897490d+00, 9.4021982189853d-01,
     |  -1.1047467112626d-01,-6.7880538127430d-01, 9.7040630180057d-01,
     |  -6.3956910796421d-01,-6.1809791170952d-02, 6.7911696253802d-01,
     |  -8.3690673127200d-01, 4.5978488344046d-01, 1.9535301731752d-01,
     |  -7.0830726386753d-01, 7.5856510199437d-01,-3.2131940782412d-01,
     |  -3.2131940782412d-01, 7.5856510199437d-01,-7.0830726386753d-01,
     |   1.9535301731751d-01, 4.5978488344046d-01,-8.3690673127200d-01,
     |   6.7911696253802d-01,-6.1809791170952d-02,-6.3956910796421d-01,
     |   9.7040630180058d-01,-6.7880538127430d-01,-1.1047467112627d-01,
     |   9.4021982189853d-01,-1.2670208897490d+00, 7.7246087240027d-01,
     |   4.4448207161473d-01,-1.9366690847744d+00, 3.5661206768497d+00/
      data (pmn(lat, 1,26), lat = 1,36)/
     |   2.5058331958626d+00, 7.7687874647617d-01,-1.6219544655078d+00,
     |   1.2800401808726d+00,-2.9504925348198d-01,-6.6921759474287d-01,
     |   1.0801404369592d+00,-7.8169680621348d-01, 3.6164130792941d-02,
     |   6.6318927756254d-01,-8.9483524504446d-01, 5.5009768593408d-01,
     |   1.2274969271943d-01,-6.8770749512585d-01, 7.9469283101007d-01,
     |  -3.9073196009176d-01,-2.5623188612401d-01, 7.3065740251462d-01,
     |  -7.3065740251462d-01, 2.5623188612401d-01, 3.9073196009177d-01,
     |  -7.9469283101007d-01, 6.8770749512584d-01,-1.2274969271944d-01,
     |  -5.5009768593409d-01, 8.9483524504446d-01,-6.6318927756254d-01,
     |  -3.6164130792946d-02, 7.8169680621349d-01,-1.0801404369592d+00,
     |   6.6921759474287d-01, 2.9504925348198d-01,-1.2800401808726d+00,
     |   1.6219544655077d+00,-7.7687874647617d-01,-2.5058331958626d+00/
      data (pmn(lat, 2,26), lat = 1,36)/
     |   7.6729270974630d-01, 2.3855059356916d+00,-9.9816659212857d-01,
     |  -4.6667392699850d-01, 1.2149839094715d+00,-1.0387408615672d+00,
     |   2.3879868585571d-01, 6.0276588039197d-01,-9.6880824165559d-01,
     |   6.8642000477336d-01, 9.9935854408547d-03,-6.5359484148776d-01,
     |   8.4293180359645d-01,-4.8197447398101d-01,-1.7669090842155d-01,
     |   7.0277031197799d-01,-7.6219801151654d-01, 3.2418961151948d-01,
     |   3.2418961151948d-01,-7.6219801151654d-01, 7.0277031197799d-01,
     |  -1.7669090842155d-01,-4.8197447398101d-01, 8.4293180359645d-01,
     |  -6.5359484148775d-01, 9.9935854408547d-03, 6.8642000477337d-01,
     |  -9.6880824165559d-01, 6.0276588039197d-01, 2.3879868585572d-01,
     |  -1.0387408615672d+00, 1.2149839094715d+00,-4.6667392699848d-01,
     |  -9.9816659212859d-01, 2.3855059356916d+00, 7.6729270974630d-01/
      data (pmn(lat, 3,26), lat = 1,36)/
     |   1.5152312904893d-01, 1.9681963707351d+00, 9.4395060786863d-01,
     |  -1.5081254615308d+00, 7.4063116223174d-01, 3.6859571279804d-01,
     |  -1.0264069217746d+00, 9.0304307873717d-01,-1.9657056388291d-01,
     |  -5.6972534176669d-01, 8.9856559867391d-01,-6.1480841928376d-01,
     |  -5.6570849565424d-02, 6.5941144104316d-01,-8.0541995297085d-01,
     |   4.1547554430556d-01, 2.4175281891849d-01,-7.3060789648994d-01,
     |   7.3060789648993d-01,-2.4175281891848d-01,-4.1547554430557d-01,
     |   8.0541995297085d-01,-6.5941144104316d-01, 5.6570849565432d-02,
     |   6.1480841928377d-01,-8.9856559867391d-01, 5.6972534176668d-01,
     |   1.9657056388291d-01,-9.0304307873717d-01, 1.0264069217746d+00,
     |  -3.6859571279804d-01,-7.4063116223174d-01, 1.5081254615308d+00,
     |  -9.4395060786861d-01,-1.9681963707351d+00,-1.5152312904893d-01/
      data (pmn(lat, 4,26), lat = 1,36)/
     |   2.2085148203776d-02, 1.0189506964327d+00, 1.9750667595223d+00,
     |  -6.2385283960096d-01,-8.1183748691444d-01, 1.2049809712245d+00,
     |  -6.0784412169433d-01,-3.3656518547051d-01, 9.2401171235645d-01,
     |  -8.0864422256250d-01, 1.4745450260610d-01, 5.6696526777830d-01,
     |  -8.5331539913137d-01, 5.4645440365741d-01, 1.1945167080252d-01,
     |  -6.8478010923970d-01, 7.7277462480429d-01,-3.3288233247573d-01,
     |  -3.3288233247573d-01, 7.7277462480429d-01,-6.8478010923970d-01,
     |   1.1945167080252d-01, 5.4645440365741d-01,-8.5331539913137d-01,
     |   5.6696526777829d-01, 1.4745450260610d-01,-8.0864422256250d-01,
     |   9.2401171235645d-01,-3.3656518547050d-01,-6.0784412169434d-01,
     |   1.2049809712245d+00,-8.1183748691444d-01,-6.2385283960097d-01,
     |   1.9750667595223d+00, 1.0189506964327d+00, 2.2085148203776d-02/
      data (pmn(lat, 5,26), lat = 1,36)/
     |   2.5455536782244d-03, 3.9124072931442d-01, 1.7796599113313d+00,
     |   9.1082632539334d-01,-1.3453650058288d+00, 3.3833865958767d-01,
     |   7.4012693658074d-01,-1.0426891888816d+00, 5.0662359851876d-01,
     |   3.4606656181169d-01,-8.6915979429716d-01, 7.2905131594464d-01,
     |  -7.9175114781244d-02,-5.9392892538373d-01, 8.2166756771648d-01,
     |  -4.6441073115087d-01,-2.1200068423881d-01, 7.3042822204408d-01,
     |  -7.3042822204408d-01, 2.1200068423881d-01, 4.6441073115088d-01,
     |  -8.2166756771648d-01, 5.9392892538373d-01, 7.9175114781236d-02,
     |  -7.2905131594465d-01, 8.6915979429716d-01,-3.4606656181169d-01,
     |  -5.0662359851877d-01, 1.0426891888816d+00,-7.4012693658073d-01,
     |  -3.3833865958767d-01, 1.3453650058288d+00,-9.1082632539333d-01,
     |  -1.7796599113314d+00,-3.9124072931442d-01,-2.5455536782244d-03/
      data (pmn(lat, 6,26), lat = 1,36)/
     |   2.4191433350154d-04, 1.1988036253323d-01, 1.1069778777066d+00,
     |   1.7428454680615d+00,-4.3508696309692d-01,-9.6319272555272d-01,
     |   1.0605112571009d+00,-1.8513109908266d-01,-7.1758230241052d-01,
     |   9.3696714943860d-01,-4.0582132592575d-01,-3.9200003767231d-01,
     |   8.4374162590696d-01,-6.4540700565390d-01,-2.0398439491580d-02,
     |   6.5013971238945d-01,-7.8926988112219d-01, 3.4765228083668d-01,
     |   3.4765228083669d-01,-7.8926988112219d-01, 6.5013971238945d-01,
     |  -2.0398439491578d-02,-6.4540700565390d-01, 8.4374162590696d-01,
     |  -3.9200003767231d-01,-4.0582132592575d-01, 9.3696714943860d-01,
     |  -7.1758230241052d-01,-1.8513109908266d-01, 1.0605112571009d+00,
     |  -9.6319272555272d-01,-4.3508696309692d-01, 1.7428454680615d+00,
     |   1.1069778777066d+00, 1.1988036253323d-01, 2.4191433350154d-04/
      data (pmn(lat, 7,26), lat = 1,36)/
     |   1.9489597990007d-05, 3.0550720151764d-02, 5.3658026683688d-01,
     |   1.6628690188232d+00, 8.6690266945807d-01,-1.2056633627237d+00,
     |   3.0740885823602d-02, 9.3942956475804d-01,-8.7699574759932d-01,
     |   5.1840084739981d-02, 7.3157200642434d-01,-8.5229865627680d-01,
     |   2.8505294027654d-01, 4.7443132462694d-01,-8.3210782268569d-01,
     |   5.3593783027187d-01, 1.6538328949221d-01,-7.2994854674669d-01,
     |   7.2994854674669d-01,-1.6538328949220d-01,-5.3593783027188d-01,
     |   8.3210782268569d-01,-4.7443132462694d-01,-2.8505294027654d-01,
     |   8.5229865627680d-01,-7.3157200642434d-01,-5.1840084739985d-02,
     |   8.7699574759933d-01,-9.3942956475804d-01,-3.0740885823613d-02,
     |   1.2056633627237d+00,-8.6690266945807d-01,-1.6628690188232d+00,
     |  -5.3658026683689d-01,-3.0550720151764d-02,-1.9489597990007d-05/
      data (pmn(lat, 8,26), lat = 1,36)/
     |   1.3574160593277d-06, 6.6491507016797d-03, 2.1427881014717d-01,
     |   1.1433796621979d+00, 1.5925864358940d+00,-3.0216318360925d-01,
     |  -1.0453621360310d+00, 8.6149219546569d-01, 1.9813886160878d-01,
     |  -9.2090007000474d-01, 7.1940220845489d-01, 9.7142510124639d-02,
     |  -7.7109921940982d-01, 7.6060849363843d-01,-1.2389696139426d-01,
     |  -5.9170106248594d-01, 8.0976962868022d-01,-3.6895406938848d-01,
     |  -3.6895406938849d-01, 8.0976962868022d-01,-5.9170106248594d-01,
     |  -1.2389696139427d-01, 7.6060849363843d-01,-7.7109921940983d-01,
     |   9.7142510124629d-02, 7.1940220845489d-01,-9.2090007000474d-01,
     |   1.9813886160878d-01, 8.6149219546569d-01,-1.0453621360310d+00,
     |  -3.0216318360925d-01, 1.5925864358940d+00, 1.1433796621979d+00,
     |   2.1427881014717d-01, 6.6491507016797d-03, 1.3574160593277d-06/
      data (pmn(lat, 9,26), lat = 1,36)/
     |   8.2911962147201d-08, 1.2586443993795d-03, 7.2780638923006d-02,
     |   6.2777516183812d-01, 1.5730739432175d+00, 8.5086642978936d-01,
     |  -1.0771226733160d+00,-2.3560123095949d-01, 1.0258997260833d+00,
     |  -5.9041050839580d-01,-3.8891759704937d-01, 9.0250358019730d-01,
     |  -5.4453014491891d-01,-2.7958502215062d-01, 8.1770611091737d-01,
     |  -6.2632016791756d-01,-9.9512273534502d-02, 7.2889092643364d-01,
     |  -7.2889092643364d-01, 9.9512273534500d-02, 6.2632016791757d-01,
     |  -8.1770611091737d-01, 2.7958502215062d-01, 5.4453014491891d-01,
     |  -9.0250358019730d-01, 3.8891759704937d-01, 5.9041050839580d-01,
     |  -1.0258997260833d+00, 2.3560123095949d-01, 1.0771226733160d+00,
     |  -8.5086642978936d-01,-1.5730739432175d+00,-6.2777516183812d-01,
     |  -7.2780638923007d-02,-1.2586443993795d-03,-8.2911962147201d-08/
      data (pmn(lat,10,26), lat = 1,36)/
     |   4.4892484321279d-09, 2.0995511278563d-04, 2.1460562448126d-02,
     |   2.8862831479659d-01, 1.1474220468754d+00, 1.4958474165580d+00,
     |  -1.6957319952713d-01,-1.0974748969923d+00, 6.1357752641226d-01,
     |   5.4070085137860d-01,-9.4704249989605d-01, 3.1978280885252d-01,
     |   5.7610605405541d-01,-8.5597548470582d-01, 3.1329864709399d-01,
     |   4.9930993894714d-01,-8.3112411475786d-01, 3.9749595368497d-01,
     |   3.9749595368498d-01,-8.3112411475786d-01, 4.9930993894714d-01,
     |   3.1329864709400d-01,-8.5597548470582d-01, 5.7610605405542d-01,
     |   3.1978280885253d-01,-9.4704249989605d-01, 5.4070085137860d-01,
     |   6.1357752641227d-01,-1.0974748969923d+00,-1.6957319952714d-01,
     |   1.4958474165580d+00, 1.1474220468754d+00, 2.8862831479659d-01,
     |   2.1460562448126d-02, 2.0995511278563d-04, 4.4892484321279d-09/
      data (pmn(lat,11,26), lat = 1,36)/
     |   2.1722063681493d-10, 3.1162050236368d-05, 5.5712046627866d-03,
     |   1.1417269037919d-01, 6.7760072482586d-01, 1.4968794966262d+00,
     |   8.7637036237647d-01,-9.3611619548905d-01,-4.9267541347862d-01,
     |   1.0075672906904d+00,-2.0190396059443d-01,-7.5016175184576d-01,
     |   8.0016967263308d-01,-7.1752608130373d-03,-7.5020511755593d-01,
     |   7.2780221683203d-01, 1.1236932945643d-02,-7.2683524239809d-01,
     |   7.2683524239809d-01,-1.1236932945641d-02,-7.2780221683203d-01,
     |   7.5020511755593d-01, 7.1752608130387d-03,-8.0016967263308d-01,
     |   7.5016175184575d-01, 2.0190396059443d-01,-1.0075672906904d+00,
     |   4.9267541347862d-01, 9.3611619548905d-01,-8.7637036237646d-01,
     |  -1.4968794966262d+00,-6.7760072482586d-01,-1.1417269037919d-01,
     |  -5.5712046627868d-03,-3.1162050236368d-05,-2.1722063681493d-10/
      data (pmn(lat,12,26), lat = 1,36)/
     |   9.4503169590214d-12, 4.1447937703314d-06, 1.2860383551927d-03,
     |   3.9530563019791d-02, 3.3806618665085d-01, 1.1252507832626d+00,
     |   1.4404245260742d+00,-5.7228674665446d-03,-1.1207493764265d+00,
     |   2.9973258930266d-01, 8.2238440895472d-01,-7.6627554513660d-01,
     |  -2.0328412712702d-01, 8.6959920377055d-01,-5.3725293062566d-01,
     |  -3.6017407065373d-01, 8.4837471207789d-01,-4.3433679428096d-01,
     |  -4.3433679428097d-01, 8.4837471207789d-01,-3.6017407065373d-01,
     |  -5.3725293062566d-01, 8.6959920377054d-01,-2.0328412712703d-01,
     |  -7.6627554513661d-01, 8.2238440895472d-01, 2.9973258930266d-01,
     |  -1.1207493764265d+00,-5.7228674665474d-03, 1.4404245260742d+00,
     |   1.1252507832626d+00, 3.3806618665085d-01, 3.9530563019791d-02,
     |   1.2860383551927d-03, 4.1447937703314d-06, 9.4503169590214d-12/
      data (pmn(lat,13,26), lat = 1,36)/
     |   3.7132558278046d-13, 4.9661697634771d-07, 2.6584782550341d-04,
     |   1.2118242913178d-02, 1.4595334842051d-01, 6.9075268301942d-01,
     |   1.4268746695940d+00, 9.4880858502777d-01,-7.5284821750239d-01,
     |  -7.4737461741080d-01, 8.5443583485051d-01, 2.6506818747352d-01,
     |  -9.2625806972563d-01, 3.7729432772149d-01, 5.9252914499425d-01,
     |  -8.2563883558472d-01, 1.0323680247260d-01, 7.2316029115292d-01,
     |  -7.2316029115292d-01,-1.0323680247260d-01, 8.2563883558473d-01,
     |  -5.9252914499424d-01,-3.7729432772149d-01, 9.2625806972563d-01,
     |  -2.6506818747351d-01,-8.5443583485051d-01, 7.4737461741079d-01,
     |   7.5284821750239d-01,-9.4880858502776d-01,-1.4268746695940d+00,
     |  -6.9075268301942d-01,-1.4595334842051d-01,-1.2118242913178d-02,
     |  -2.6584782550341d-04,-4.9661697634771d-07,-3.7132558278046d-13/
      data (pmn(lat,14,26), lat = 1,36)/
     |   1.3218349906815d-14, 5.3797667381662d-08, 4.9457926024755d-05,
     |   3.3149071246427d-03, 5.5340366893961d-02, 3.5988669454281d-01,
     |   1.0777058190466d+00, 1.4157041303104d+00, 2.1167002853103d-01,
     |  -1.0879752802327d+00,-9.5158130515565d-02, 9.7773684956909d-01,
     |  -3.4146489396117d-01,-7.1288691980046d-01, 7.6353224931187d-01,
     |   1.6037120279819d-01,-8.5382882981220d-01, 4.8106251414346d-01,
     |   4.8106251414347d-01,-8.5382882981220d-01, 1.6037120279818d-01,
     |   7.6353224931187d-01,-7.1288691980045d-01,-3.4146489396117d-01,
     |   9.7773684956909d-01,-9.5158130515565d-02,-1.0879752802327d+00,
     |   2.1167002853102d-01, 1.4157041303104d+00, 1.0777058190466d+00,
     |   3.5988669454281d-01, 5.5340366893961d-02, 3.3149071246427d-03,
     |   4.9457926024757d-05, 5.3797667381662d-08, 1.3218349906815d-14/
      data (pmn(lat,15,26), lat = 1,36)/
     |   4.2710096738761d-16, 5.2810091332393d-09, 8.3073032854110d-06,
     |   8.1333876324019d-04, 1.8603634667294d-02, 1.6256295358463d-01,
     |   6.6852993031500d-01, 1.3535557343326d+00, 1.0655708656866d+00,
     |  -4.9013477368183d-01,-9.7058523989063d-01, 5.1378728521953d-01,
     |   7.2786304443572d-01,-7.6063418832573d-01,-3.0526030793233d-01,
     |   8.9368798826923d-01,-2.4803150156510d-01,-7.1693961042278d-01,
     |   7.1693961042277d-01, 2.4803150156510d-01,-8.9368798826923d-01,
     |   3.0526030793233d-01, 7.6063418832573d-01,-7.2786304443572d-01,
     |  -5.1378728521954d-01, 9.7058523989063d-01, 4.9013477368184d-01,
     |  -1.0655708656866d+00,-1.3535557343326d+00,-6.6852993031500d-01,
     |  -1.6256295358463d-01,-1.8603634667294d-02,-8.1333876324020d-04,
     |  -8.3073032854112d-06,-5.2810091332393d-09,-4.2710096738761d-16/
      data (pmn(lat,16,26), lat = 1,36)/
     |   1.2534938231120d-17, 4.7023960480072d-10, 1.2619617172752d-06,
     |   1.7954776198593d-04, 5.5775873155462d-03, 6.4470589861407d-02,
     |   3.5250381134572d-01, 1.0010990580314d+00, 1.4046090886214d+00,
     |   4.9588694896373d-01,-9.4127680465250d-01,-5.5213511515397d-01,
     |   8.8121987702233d-01, 2.9592407605599d-01,-9.2226853407871d-01,
     |   1.1103330155157d-01, 8.3553856065076d-01,-5.4012517298929d-01,
     |  -5.4012517298929d-01, 8.3553856065076d-01, 1.1103330155158d-01,
     |  -9.2226853407871d-01, 2.9592407605599d-01, 8.8121987702233d-01,
     |  -5.5213511515396d-01,-9.4127680465250d-01, 4.9588694896372d-01,
     |   1.4046090886214d+00, 1.0010990580314d+00, 3.5250381134572d-01,
     |   6.4470589861407d-02, 5.5775873155462d-03, 1.7954776198593d-04,
     |   1.2619617172752d-06, 4.7023960480072d-10, 1.2534938231120d-17/
      data (pmn(lat,17,26), lat = 1,36)/
     |   3.3399401318560d-19, 3.7971438980621d-11, 1.7342467256007d-07,
     |   3.5706893438934d-05, 1.4961878742720d-03, 2.2614342454677d-02,
     |   1.6091182293574d-01, 6.1030088294962d-01, 1.2609685919803d+00,
     |   1.2092596142551d+00,-1.0853395992173d-01,-1.0753726876697d+00,
     |  -4.6552543519827d-02, 9.7758512742059d-01,-1.3232565800852d-01,
     |  -8.8835876803784d-01, 4.2684559616950d-01, 7.0674599263058d-01,
     |  -7.0674599263058d-01,-4.2684559616950d-01, 8.8835876803783d-01,
     |   1.3232565800852d-01,-9.7758512742059d-01, 4.6552543519835d-02,
     |   1.0753726876697d+00, 1.0853395992173d-01,-1.2092596142551d+00,
     |  -1.2609685919803d+00,-6.1030088294962d-01,-1.6091182293574d-01,
     |  -2.2614342454677d-02,-1.4961878742720d-03,-3.5706893438934d-05,
     |  -1.7342467256008d-07,-3.7971438980621d-11,-3.3399401318560d-19/
      data (pmn(lat,18,26), lat = 1,36)/
     |   8.0648239682373d-21, 2.7760291378807d-12, 2.1534030606255d-08,
     |   6.3942256180247d-06, 3.5943507630522d-04, 7.0417379070504d-03,
     |   6.4225850580519d-02, 3.1573234568976d-01, 8.8749870838224d-01,
     |   1.3764931059504d+00, 8.3856214619172d-01,-5.9516696976116d-01,
     |  -9.5967597561691d-01, 3.8348094078358d-01, 8.8976074664667d-01,
     |  -4.5219390323075d-01,-7.7465583818472d-01, 6.1555644800709d-01,
     |   6.1555644800709d-01,-7.7465583818472d-01,-4.5219390323076d-01,
     |   8.8976074664667d-01, 3.8348094078358d-01,-9.5967597561692d-01,
     |  -5.9516696976117d-01, 8.3856214619172d-01, 1.3764931059504d+00,
     |   8.8749870838224d-01, 3.1573234568976d-01, 6.4225850580519d-02,
     |   7.0417379070504d-03, 3.5943507630522d-04, 6.3942256180248d-06,
     |   2.1534030606256d-08, 2.7760291378807d-12, 8.0648239682373d-21/
      data (pmn(lat,19,26), lat = 1,36)/
     |   1.7588594216097d-22, 1.8315678136533d-13, 2.4089730217199d-09,
     |   1.0286852689810d-06, 7.7230543126733d-05, 1.9476554030544d-03,
     |   2.2516114853846d-02, 1.4062123361654d-01, 5.1515072170008d-01,
     |   1.1249109757208d+00, 1.3346945053111d+00, 4.0844884406176d-01,
     |  -8.9905351088944d-01,-7.2391651676123d-01, 6.7107246758865d-01,
     |   7.4150948013951d-01,-6.4118308352717d-01,-6.9024825287678d-01,
     |   6.9024825287678d-01, 6.4118308352717d-01,-7.4150948013951d-01,
     |  -6.7107246758865d-01, 7.2391651676123d-01, 8.9905351088944d-01,
     |  -4.0844884406175d-01,-1.3346945053111d+00,-1.1249109757208d+00,
     |  -5.1515072170008d-01,-1.4062123361654d-01,-2.2516114853846d-02,
     |  -1.9476554030544d-03,-7.7230543126733d-05,-1.0286852689810d-06,
     |  -2.4089730217200d-09,-1.8315678136533d-13,-1.7588594216097d-22/
      data (pmn(lat,20,26), lat = 1,36)/
     |   3.4461264394598d-24, 1.0848964198260d-14, 2.4158846772386d-10,
     |   1.4800570565900d-07, 1.4786701061329d-05, 4.7736693992462d-04,
     |   6.9349123558770d-03, 5.4241226173510d-02, 2.5211565703485d-01,
     |   7.2741176353140d-01, 1.2821295549380d+00, 1.1803432583880d+00,
     |   2.3623094929271d-02,-1.0404701189147d+00,-4.9272680550611d-01,
     |   8.2625113005634d-01, 6.4033237399695d-01,-7.1468502300218d-01,
     |  -7.1468502300218d-01, 6.4033237399695d-01, 8.2625113005634d-01,
     |  -4.9272680550611d-01,-1.0404701189147d+00, 2.3623094929278d-02,
     |   1.1803432583880d+00, 1.2821295549380d+00, 7.2741176353140d-01,
     |   2.5211565703485d-01, 5.4241226173510d-02, 6.9349123558771d-03,
     |   4.7736693992462d-04, 1.4786701061329d-05, 1.4800570565900d-07,
     |   2.4158846772387d-10, 1.0848964198260d-14, 3.4461264394598d-24/
      data (pmn(lat,21,26), lat = 1,36)/
     |   6.0173757703531d-26, 5.7236487268900d-16, 2.1552668120130d-11,
     |   1.8904937017854d-08, 2.5056858691004d-06, 1.0308596365410d-04,
     |   1.8691306066391d-03, 1.8113885688412d-02, 1.0488919973517d-01,
     |   3.8565193371330d-01, 9.1719169811835d-01, 1.3546898481111d+00,
     |   9.8999449689486d-01,-2.5301568799068d-01,-1.0871415744257d+00,
     |  -3.5603791364896d-01, 8.8595255422234d-01, 6.6325284011734d-01,
     |  -6.6325284011734d-01,-8.8595255422234d-01, 3.5603791364895d-01,
     |   1.0871415744257d+00, 2.5301568799068d-01,-9.8999449689486d-01,
     |  -1.3546898481111d+00,-9.1719169811835d-01,-3.8565193371330d-01,
     |  -1.0488919973517d-01,-1.8113885688413d-02,-1.8691306066391d-03,
     |  -1.0308596365410d-04,-2.5056858691004d-06,-1.8904937017855d-08,
     |  -2.1552668120131d-11,-5.7236487268900d-16,-6.0173757703531d-26/
      data (pmn(lat,22,26), lat = 1,36)/
     |   9.2519521175835d-28, 2.6575743703694d-17, 1.6903947283930d-12,
     |   2.1192417966839d-09, 3.7167845537244d-07, 1.9413344165184d-05,
     |   4.3692461010962d-04, 5.2031522513090d-03, 3.7041866951630d-02,
     |   1.6956209121075d-01, 5.1823054646882d-01, 1.0602960580238d+00,
     |   1.3715756382826d+00, 8.4371381710708d-01,-3.9518860912161d-01,
     |  -1.1096257081325d+00,-3.7788819310104d-01, 8.5320846298607d-01,
     |   8.5320846298607d-01,-3.7788819310104d-01,-1.1096257081325d+00,
     |  -3.9518860912161d-01, 8.4371381710708d-01, 1.3715756382826d+00,
     |   1.0602960580238d+00, 5.1823054646882d-01, 1.6956209121075d-01,
     |   3.7041866951630d-02, 5.2031522513090d-03, 4.3692461010963d-04,
     |   1.9413344165184d-05, 3.7167845537244d-07, 2.1192417966840d-09,
     |   1.6903947283931d-12, 2.6575743703694d-17, 9.2519521175835d-28/
      data (pmn(lat,23,26), lat = 1,36)/
     |   1.2295691028290d-29, 1.0660971480116d-18, 1.1443769696729d-13,
     |   2.0475220262810d-10, 4.7412343991194d-08, 3.1340966761570d-06,
     |   8.7161467184143d-05, 1.2671150722720d-03, 1.0980292436099d-02,
     |   6.1571946995332d-02, 2.3483055863274d-01, 6.2389220782614d-01,
     |   1.1484959233179d+00, 1.3783372313708d+00, 8.1138680701072d-01,
     |  -3.7915718773918d-01,-1.1367224733626d+00,-6.1685613091222d-01,
     |   6.1685613091222d-01, 1.1367224733626d+00, 3.7915718773919d-01,
     |  -8.1138680701072d-01,-1.3783372313708d+00,-1.1484959233179d+00,
     |  -6.2389220782615d-01,-2.3483055863274d-01,-6.1571946995332d-02,
     |  -1.0980292436099d-02,-1.2671150722720d-03,-8.7161467184145d-05,
     |  -3.1340966761570d-06,-4.7412343991194d-08,-2.0475220262811d-10,
     |  -1.1443769696730d-13,-1.0660971480116d-18,-1.2295691028290d-29/
      data (pmn(lat,24,26), lat = 1,36)/
     |   1.3698898004045d-31, 3.5838548984252d-20, 6.4869080449035d-15,
     |   1.6542371071122d-11, 5.0478858946153d-09, 4.2116460059456d-07,
     |   1.4418999979540d-05, 2.5453040296270d-04, 2.6639540615691d-03,
     |   1.8082481842063d-02, 8.4392785360412d-02, 2.8080632624454d-01,
     |   6.7768573562093d-01, 1.1798866634917d+00, 1.4126033674211d+00,
     |   9.5269900241923d-01,-1.3011473304986d-01,-1.0764539394473d+00,
     |  -1.0764539394473d+00,-1.3011473304986d-01, 9.5269900241923d-01,
     |   1.4126033674211d+00, 1.1798866634917d+00, 6.7768573562093d-01,
     |   2.8080632624455d-01, 8.4392785360412d-02, 1.8082481842063d-02,
     |   2.6639540615692d-03, 2.5453040296270d-04, 1.4418999979540d-05,
     |   4.2116460059456d-07, 5.0478858946153d-09, 1.6542371071123d-11,
     |   6.4869080449039d-15, 3.5838548984252d-20, 1.3698898004045d-31/
      data (pmn(lat,25,26), lat = 1,36)/
     |   1.2081625853284d-33, 9.5336713179701d-22, 2.9077038351311d-16,
     |   1.0556367363495d-12, 4.2379590047805d-10, 4.4526525735925d-08,
     |   1.8706484680407d-06, 3.9920386850898d-05, 5.0149248113760d-04,
     |   4.0832441148103d-03, 2.2996586901559d-02, 9.3647504829796d-02,
     |   2.8390862710543d-01, 6.5128818455538d-01, 1.1328678036893d+00,
     |   1.4636069719019d+00, 1.2970649209663d+00, 5.2467543189960d-01,
     |  -5.2467543189960d-01,-1.2970649209663d+00,-1.4636069719019d+00,
     |  -1.1328678036893d+00,-6.5128818455538d-01,-2.8390862710543d-01,
     |  -9.3647504829797d-02,-2.2996586901559d-02,-4.0832441148103d-03,
     |  -5.0149248113760d-04,-3.9920386850898d-05,-1.8706484680407d-06,
     |  -4.4526525735925d-08,-4.2379590047805d-10,-1.0556367363495d-12,
     |  -2.9077038351313d-16,-9.5336713179701d-22,-1.2081625853284d-33/
      data (pmn(lat,26,26), lat = 1,36)/
     |   7.3150419495050d-36, 1.7405544177521d-23, 8.9393045826539d-18,
     |   4.6156739848932d-14, 2.4343296800506d-11, 3.2143548105115d-09,
     |   1.6526384127771d-07, 4.2478927438513d-06, 6.3725788221191d-05,
     |   6.1794697592535d-04, 4.1560545460558d-03, 2.0384835276743d-02,
     |   7.5631069522410d-02, 2.1804554255917d-01, 4.9825912370130d-01,
     |   9.1551941850107d-01, 1.3662524056925d+00, 1.6664640388041d+00,
     |   1.6664640388041d+00, 1.3662524056925d+00, 9.1551941850107d-01,
     |   4.9825912370130d-01, 2.1804554255917d-01, 7.5631069522409d-02,
     |   2.0384835276744d-02, 4.1560545460558d-03, 6.1794697592535d-04,
     |   6.3725788221191d-05, 4.2478927438513d-06, 1.6526384127771d-07,
     |   3.2143548105115d-09, 2.4343296800506d-11, 4.6156739848934d-14,
     |   8.9393045826544d-18, 1.7405544177521d-23, 7.3150419495050d-36/
      data (pmn(lat, 0,27), lat = 1,36)/
     |   3.5200605917745d+00,-2.0573610371856d+00, 7.9299043140852d-01,
     |   3.6569949112502d-01,-1.0795854587822d+00, 1.1584773319855d+00,
     |  -6.7507131944390d-01,-7.2898851203767d-02, 7.0440919430373d-01,
     |  -9.2894726187708d-01, 6.7134164294227d-01,-9.2075319607216d-02,
     |  -5.0250659220601d-01, 8.1437800758750d-01,-6.9780526330665d-01,
     |   2.2516521446504d-01, 3.5481448584101d-01,-7.4398463602587d-01,
     |   7.4398463602587d-01,-3.5481448584101d-01,-2.2516521446505d-01,
     |   6.9780526330665d-01,-8.1437800758750d-01, 5.0250659220601d-01,
     |   9.2075319607227d-02,-6.7134164294227d-01, 9.2894726187708d-01,
     |  -7.0440919430373d-01, 7.2898851203762d-02, 6.7507131944391d-01,
     |  -1.1584773319855d+00, 1.0795854587822d+00,-3.6569949112500d-01,
     |  -7.9299043140854d-01, 2.0573610371856d+00,-3.5200605917745d+00/
      data (pmn(lat, 1,27), lat = 1,36)/
     |   2.6130826204015d+00, 5.0321772436526d-01,-1.4581943133676d+00,
     |   1.4307406649615d+00,-7.5261572912123d-01,-1.4841166966900d-01,
     |   8.3487516973796d-01,-1.0221436892761d+00, 6.8199123662508d-01,
     |  -3.1881759424607d-02,-5.8379180672041d-01, 8.6309425210875d-01,
     |  -6.8695669745145d-01, 1.6658725682413d-01, 4.2095488725788d-01,
     |  -7.7476745180152d-01, 7.1949799078030d-01,-2.8983612797979d-01,
     |  -2.8983612797979d-01, 7.1949799078031d-01,-7.7476745180152d-01,
     |   4.2095488725788d-01, 1.6658725682413d-01,-6.8695669745144d-01,
     |   8.6309425210875d-01,-5.8379180672041d-01,-3.1881759424611d-02,
     |   6.8199123662509d-01,-1.0221436892761d+00, 8.3487516973795d-01,
     |  -1.4841166966900d-01,-7.5261572912123d-01, 1.4307406649615d+00,
     |  -1.4581943133675d+00, 5.0321772436526d-01, 2.6130826204015d+00/
      data (pmn(lat, 2,27), lat = 1,36)/
     |   8.3444948055375d-01, 2.3384890556715d+00,-1.2731175243434d+00,
     |  -3.5675448086857d-02, 9.4867566078803d-01,-1.1807779364553d+00,
     |   7.7141661857285d-01,-2.4027776200087d-02,-6.5113389776588d-01,
     |   9.2805063104116d-01,-7.0485885118094d-01, 1.3224618881406d-01,
     |   4.7712604599383d-01,-8.1043150892039d-01, 7.0839735447597d-01,
     |  -2.3797403658443d-01,-3.4838548251432d-01, 7.4404899881992d-01,
     |  -7.4404899881991d-01, 3.4838548251432d-01, 2.3797403658444d-01,
     |  -7.0839735447597d-01, 8.1043150892039d-01,-4.7712604599384d-01,
     |  -1.3224618881407d-01, 7.0485885118094d-01,-9.2805063104116d-01,
     |   6.5113389776588d-01, 2.4027776200091d-02,-7.7141661857286d-01,
     |   1.1807779364553d+00,-9.4867566078803d-01, 3.5675448086841d-02,
     |   1.2731175243434d+00,-2.3384890556715d+00,-8.3444948055375d-01/
      data (pmn(lat, 3,27), lat = 1,36)/
     |   1.7144984801446d-01, 2.0898341599752d+00, 6.2330818297262d-01,
     |  -1.4510772326267d+00, 1.0891405865325d+00,-1.8249269350530d-01,
     |  -6.6023797390399d-01, 1.0202921360213d+00,-7.8759547582174d-01,
     |   1.5617578634957d-01, 5.0634926152159d-01,-8.5308725938187d-01,
     |   7.2506379712928d-01,-2.1606181309551d-01,-3.8945258806814d-01,
     |   7.6912501407204d-01,-7.2811323230733d-01, 2.9535286313068d-01,
     |   2.9535286313068d-01,-7.2811323230733d-01, 7.6912501407204d-01,
     |  -3.8945258806814d-01,-2.1606181309551d-01, 7.2506379712928d-01,
     |  -8.5308725938187d-01, 5.0634926152159d-01, 1.5617578634957d-01,
     |  -7.8759547582175d-01, 1.0202921360213d+00,-6.6023797390398d-01,
     |  -1.8249269350530d-01, 1.0891405865325d+00,-1.4510772326267d+00,
     |   6.2330818297260d-01, 2.0898341599752d+00, 1.7144984801446d-01/
      data (pmn(lat, 4,27), lat = 1,36)/
     |   2.5983762692247d-02, 1.1438855586831d+00, 1.8967018331100d+00,
     |  -9.7653639837969d-01,-3.7409844410253d-01, 1.1084155137620d+00,
     |  -1.0024910548740d+00, 3.1661300383329d-01, 4.6468725233091d-01,
     |  -9.0030553016762d-01, 7.9316172182553d-01,-2.5232726501782d-01,
     |  -3.9601939665425d-01, 7.9400637925393d-01,-7.3825912279369d-01,
     |   2.7643908211417d-01, 3.2870150947777d-01,-7.4420656547846d-01,
     |   7.4420656547846d-01,-3.2870150947777d-01,-2.7643908211418d-01,
     |   7.3825912279369d-01,-7.9400637925393d-01, 3.9601939665426d-01,
     |   2.5232726501783d-01,-7.9316172182553d-01, 9.0030553016762d-01,
     |  -4.6468725233090d-01,-3.1661300383329d-01, 1.0024910548740d+00,
     |  -1.1084155137620d+00, 3.7409844410253d-01, 9.7653639837970d-01,
     |  -1.8967018331100d+00,-1.1438855586831d+00,-2.5983762692247d-02/
      data (pmn(lat, 5,27), lat = 1,36)/
     |   3.1139634934178d-03, 4.6098875848455d-01, 1.8961836243208d+00,
     |   5.4563431089752d-01,-1.3613692793109d+00, 8.1136232714703d-01,
     |   1.9978845455728d-01,-9.0414777559564d-01, 9.4140500609539d-01,
     |  -4.0029502089594d-01,-3.2962312818282d-01, 8.1030842557396d-01,
     |  -7.8978540051286d-01, 3.1421673075273d-01, 3.2292267850063d-01,
     |  -7.5522176294113d-01, 7.4482059130552d-01,-3.0653529568132d-01,
     |  -3.0653529568132d-01, 7.4482059130552d-01,-7.5522176294113d-01,
     |   3.2292267850062d-01, 3.1421673075273d-01,-7.8978540051286d-01,
     |   8.1030842557396d-01,-3.2962312818282d-01,-4.0029502089594d-01,
     |   9.4140500609539d-01,-9.0414777559563d-01, 1.9978845455727d-01,
     |   8.1136232714703d-01,-1.3613692793109d+00, 5.4563431089750d-01,
     |   1.8961836243208d+00, 4.6098875848455d-01, 3.1139634934178d-03/
      data (pmn(lat, 6,27), lat = 1,36)/
     |   3.0778531408065d-04, 1.4781317047183d-01, 1.2646450232665d+00,
     |   1.6254991269379d+00,-8.4311902345180d-01,-5.3756775798270d-01,
     |   1.1257614033308d+00,-7.5609731133700d-01,-8.6586355119397d-02,
     |   7.7035148615461d-01,-8.9247623924477d-01, 4.4564758606223d-01,
     |   2.4615049895825d-01,-7.5115179458511d-01, 7.8111404413899d-01,
     |  -3.4047501551958d-01,-2.9456500352605d-01, 7.4434729887506d-01,
     |  -7.4434729887506d-01, 2.9456500352605d-01, 3.4047501551959d-01,
     |  -7.8111404413899d-01, 7.5115179458511d-01,-2.4615049895825d-01,
     |  -4.4564758606224d-01, 8.9247623924477d-01,-7.7035148615461d-01,
     |   8.6586355119392d-02, 7.5609731133700d-01,-1.1257614033308d+00,
     |   5.3756775798270d-01, 8.4311902345180d-01,-1.6254991269379d+00,
     |  -1.2646450232665d+00,-1.4781317047183d-01,-3.0778531408065d-04/
      data (pmn(lat, 7,27), lat = 1,36)/
     |   2.5802918705888d-05, 3.9369002033122d-02, 6.4975034506547d-01,
     |   1.7650426233252d+00, 4.5865536447153d-01,-1.2819071655120d+00,
     |   5.9212046631028d-01, 4.6919760782619d-01,-9.9171849133326d-01,
     |   7.2065524046112d-01, 2.4836100258523d-02,-6.8958911907275d-01,
     |   8.5393985591372d-01,-4.5657443732984d-01,-2.1502150265727d-01,
     |   7.2764383363892d-01,-7.6846926664969d-01, 3.2369538070996d-01,
     |   3.2369538070996d-01,-7.6846926664969d-01, 7.2764383363892d-01,
     |  -2.1502150265727d-01,-4.5657443732984d-01, 8.5393985591372d-01,
     |  -6.8958911907274d-01, 2.4836100258523d-02, 7.2065524046113d-01,
     |  -9.9171849133326d-01, 4.6919760782619d-01, 5.9212046631029d-01,
     |  -1.2819071655120d+00, 4.5865536447153d-01, 1.7650426233252d+00,
     |   6.4975034506548d-01, 3.9369002033122d-02, 2.5802918705888d-05/
      data (pmn(lat, 8,27), lat = 1,36)/
     |   1.8714088795294d-06, 8.9516595543703d-03, 2.7362292905587d-01,
     |   1.3205095272246d+00, 1.4374323269650d+00,-7.6012667971323d-01,
     |  -6.4514830141805d-01, 1.0871804841347d+00,-4.8523595621344d-01,
     |  -4.2858779859447d-01, 9.1144105206332d-01,-6.8254655717000d-01,
     |  -1.3375089792905d-02, 6.5855358591052d-01,-8.2476079604761d-01,
     |   4.2922265455870d-01, 2.4396146342822d-01,-7.4427552316283d-01,
     |   7.4427552316283d-01,-2.4396146342822d-01,-4.2922265455871d-01,
     |   8.2476079604761d-01,-6.5855358591052d-01, 1.3375089792914d-02,
     |   6.8254655717001d-01,-9.1144105206332d-01, 4.2858779859447d-01,
     |   4.8523595621344d-01,-1.0871804841347d+00, 6.4514830141804d-01,
     |   7.6012667971323d-01,-1.4374323269650d+00,-1.3205095272246d+00,
     |  -2.7362292905587d-01,-8.9516595543703d-03,-1.8714088795294d-06/
      data (pmn(lat, 9,27), lat = 1,36)/
     |   1.1913955176585d-07, 1.7706226262106d-03, 9.7767583286919d-02,
     |   7.7662196974804d-01, 1.6590358461037d+00, 4.0350554575993d-01,
     |  -1.2185384105282d+00, 3.9213485411522d-01, 6.7928970259042d-01,
     |  -9.6929674105016d-01, 4.0273441234524d-01, 4.3158954795682d-01,
     |  -8.6812928847147d-01, 6.2876480215054d-01, 5.8432070563422d-02,
     |  -6.7789077595070d-01, 7.9705433807658d-01,-3.4733951680049d-01,
     |  -3.4733951680049d-01, 7.9705433807658d-01,-6.7789077595069d-01,
     |   5.8432070563420d-02, 6.2876480215054d-01,-8.6812928847148d-01,
     |   4.3158954795681d-01, 4.0273441234524d-01,-9.6929674105016d-01,
     |   6.7928970259042d-01, 3.9213485411523d-01,-1.2185384105282d+00,
     |   4.0350554575993d-01, 1.6590358461037d+00, 7.7662196974805d-01,
     |   9.7767583286921d-02, 1.7706226262106d-03, 1.1913955176585d-07/
      data (pmn(lat,10,27), lat = 1,36)/
     |   6.7309465194608d-09, 3.0881485404396d-04, 3.0296113552806d-02,
     |   3.7976313940725d-01, 1.3368892922455d+00, 1.3109702390301d+00,
     |  -6.8028821608067d-01,-7.4533094014476d-01, 1.0088059317886d+00,
     |  -1.8516378650239d-01,-7.0813236971322d-01, 8.8348439442536d-01,
     |  -3.0165282166075d-01,-4.8573838799466d-01, 8.4868207897041d-01,
     |  -5.3980578601099d-01,-1.7404614659434d-01, 7.4368875388472d-01,
     |  -7.4368875388472d-01, 1.7404614659434d-01, 5.3980578601100d-01,
     |  -8.4868207897041d-01, 4.8573838799466d-01, 3.0165282166074d-01,
     |  -8.8348439442537d-01, 7.0813236971322d-01, 1.8516378650239d-01,
     |  -1.0088059317886d+00, 7.4533094014476d-01, 6.8028821608068d-01,
     |  -1.3109702390301d+00,-1.3368892922455d+00,-3.7976313940725d-01,
     |  -3.0296113552807d-02,-3.0881485404396d-04,-6.7309465194608d-09/
      data (pmn(lat,11,27), lat = 1,36)/
     |   3.4028605077926d-10, 4.7969517607228d-05, 8.2644280766193d-03,
     |   1.5922045979168d-01, 8.5519255518313d-01, 1.5719592730790d+00,
     |   3.9698649777926d-01,-1.1624914366768d+00, 1.7657630130905d-01,
     |   8.5067436415577d-01,-8.3649258003044d-01, 4.6745819009574d-03,
     |   7.5789972531442d-01,-7.9674552552638d-01, 1.5123282342652d-01,
     |   5.9413576857544d-01,-8.2732907158896d-01, 3.7822572667543d-01,
     |   3.7822572667543d-01,-8.2732907158896d-01, 5.9413576857544d-01,
     |   1.5123282342652d-01,-7.9674552552638d-01, 7.5789972531442d-01,
     |   4.6745819009680d-03,-8.3649258003044d-01, 8.5067436415576d-01,
     |   1.7657630130905d-01,-1.1624914366768d+00, 3.9698649777925d-01,
     |   1.5719592730790d+00, 8.5519255518313d-01, 1.5922045979168d-01,
     |   8.2644280766195d-03, 4.7969517607228d-05, 3.4028605077926d-10/
      data (pmn(lat,12,27), lat = 1,36)/
     |   1.5492313864134d-11, 6.6861716904923d-06, 2.0057368888895d-03,
     |   5.8341090486993d-02, 4.5806649421405d-01, 1.3255893045109d+00,
     |   1.2409825213224d+00,-5.7590159175584d-01,-8.5672419263374d-01,
     |   8.7490855097556d-01, 1.5521519608109d-01,-8.9630096169374d-01,
     |   6.5439555599339d-01, 2.0357423191963d-01,-8.2151811731999d-01,
     |   6.6524272790035d-01, 8.1161373752103d-02,-7.4214140452878d-01,
     |   7.4214140452878d-01,-8.1161373752101d-02,-6.6524272790035d-01,
     |   8.2151811731998d-01,-2.0357423191963d-01,-6.5439555599338d-01,
     |   8.9630096169373d-01,-1.5521519608109d-01,-8.7490855097557d-01,
     |   8.5672419263374d-01, 5.7590159175584d-01,-1.2409825213224d+00,
     |  -1.3255893045109d+00,-4.5806649421405d-01,-5.8341090486994d-02,
     |  -2.0057368888895d-03,-6.6861716904923d-06,-1.5492313864134d-11/
      data (pmn(lat,13,27), lat = 1,36)/
     |   6.3821312878827d-13, 8.4091885219011d-07, 4.3640596682036d-04,
     |   1.8922201042856d-02, 2.1139851926332d-01, 8.9189475843564d-01,
     |   1.5037473554084d+00, 4.5014751394785d-01,-1.0961337617312d+00,
     |  -8.2012806933579d-02, 9.6975288161077d-01,-5.6423716643260d-01,
     |  -4.3913499758588d-01, 8.9514372944980d-01,-4.0801815015572d-01,
     |  -4.6140092989243d-01, 8.5418263079053d-01,-4.1746400033260d-01,
     |  -4.1746400033261d-01, 8.5418263079053d-01,-4.6140092989243d-01,
     |  -4.0801815015573d-01, 8.9514372944980d-01,-4.3913499758589d-01,
     |  -5.6423716643261d-01, 9.6975288161077d-01,-8.2012806933576d-02,
     |  -1.0961337617312d+00, 4.5014751394785d-01, 1.5037473554084d+00,
     |   8.9189475843564d-01, 2.1139851926332d-01, 1.8922201042856d-02,
     |   4.3640596682038d-04, 8.4091885219011d-07, 6.3821312878827d-13/
      data (pmn(lat,14,27), lat = 1,36)/
     |   2.3872382915215d-14, 9.5818322419594d-08, 8.5593870715230d-05,
     |   5.4800801799088d-03, 8.5527726760976d-02, 5.0404196282822d-01,
     |   1.2927853018978d+00, 1.2254370792069d+00,-4.2224834007659d-01,
     |  -9.7605928748172d-01, 6.4883894410084d-01, 5.2628420874778d-01,
     |  -9.1713244062966d-01, 1.9424450530742d-01, 7.0030702118054d-01,
     |  -7.9114953434198d-01, 3.9059440080479d-02, 7.3898319387741d-01,
     |  -7.3898319387741d-01,-3.9059440080481d-02, 7.9114953434198d-01,
     |  -7.0030702118054d-01,-1.9424450530742d-01, 9.1713244062966d-01,
     |  -5.2628420874778d-01,-6.4883894410084d-01, 9.7605928748171d-01,
     |   4.2224834007659d-01,-1.2254370792069d+00,-1.2927853018978d+00,
     |  -5.0404196282822d-01,-8.5527726760976d-02,-5.4800801799088d-03,
     |  -8.5593870715233d-05,-9.5818322419594d-08,-2.3872382915215d-14/
      data (pmn(lat,15,27), lat = 1,36)/
     |   8.1266123596074d-16, 9.9185820885100d-09, 1.5190380819440d-05,
     |   1.4256610408860d-03, 3.0674197118408d-02, 2.4577245744650d-01,
     |   8.8982549124012d-01, 1.4521474789475d+00, 5.7171279170282d-01,
     |  -9.8765288584961d-01,-3.9771318376429d-01, 9.8028639729450d-01,
     |  -1.2184391663894d-01,-8.2139636702083d-01, 6.8293878996590d-01,
     |   2.6291149201952d-01,-8.6964899932417d-01, 4.6669683296023d-01,
     |   4.6669683296023d-01,-8.6964899932417d-01, 2.6291149201952d-01,
     |   6.8293878996590d-01,-8.2139636702083d-01,-1.2184391663893d-01,
     |   9.8028639729450d-01,-3.9771318376429d-01,-9.8765288584962d-01,
     |   5.7171279170282d-01, 1.4521474789475d+00, 8.8982549124012d-01,
     |   2.4577245744650d-01, 3.0674197118408d-02, 1.4256610408861d-03,
     |   1.5190380819440d-05, 9.9185820885100d-09, 8.1266123596074d-16/
      data (pmn(lat,16,27), lat = 1,36)/
     |   2.5208455046032d-17, 9.3419355628502d-10, 2.4450116127963d-06,
     |   3.3446119284946d-04, 9.8225758740690d-03, 1.0503631371008d-01,
     |   5.1481437963685d-01, 1.2387905765211d+00, 1.2583394257334d+00,
     |  -1.9120246254976d-01,-1.0704728885061d+00, 2.8341028621469d-01,
     |   8.5964886143573d-01,-6.4914973751520d-01,-4.3599624586014d-01,
     |   8.9080020516781d-01,-1.9138501657030d-01,-7.3325112267347d-01,
     |   7.3325112267346d-01, 1.9138501657031d-01,-8.9080020516782d-01,
     |   4.3599624586014d-01, 6.4914973751520d-01,-8.5964886143573d-01,
     |  -2.8341028621470d-01, 1.0704728885061d+00, 1.9120246254976d-01,
     |  -1.2583394257334d+00,-1.2387905765211d+00,-5.1481437963686d-01,
     |  -1.0503631371008d-01,-9.8225758740690d-03,-3.3446119284946d-04,
     |  -2.4450116127964d-06,-9.3419355628502d-10,-2.5208455046032d-17/
      data (pmn(lat,17,27), lat = 1,36)/
     |   7.1266881712624d-19, 8.0094141258427d-11, 3.5729035922588d-07,
     |   7.0909938781506d-05, 2.8208023862691d-03, 3.9720689236231d-02,
     |   2.5664295351998d-01, 8.4886800911699d-01, 1.4071250101938d+00,
     |   7.6493672733439d-01,-7.8411730536191d-01,-7.4955245149739d-01,
     |   7.7672352973600d-01, 4.5700757846668d-01,-9.0510900003854d-01,
     |   1.5788171181644d-02, 8.6128844304011d-01,-5.2844436779883d-01,
     |  -5.2844436779884d-01, 8.6128844304011d-01, 1.5788171181651d-02,
     |  -9.0510900003854d-01, 4.5700757846668d-01, 7.7672352973600d-01,
     |  -7.4955245149739d-01,-7.8411730536191d-01, 7.6493672733439d-01,
     |   1.4071250101938d+00, 8.4886800911699d-01, 2.5664295351998d-01,
     |   3.9720689236231d-02, 2.8208023862691d-03, 7.0909938781507d-05,
     |   3.5729035922590d-07, 8.0094141258427d-11, 7.1266881712624d-19/
      data (pmn(lat,18,27), lat = 1,36)/
     |   1.8345745241195d-20, 6.2463672530138d-12, 4.7388175820728d-08,
     |   1.3593983084556d-05, 7.2803665223632d-04, 1.3364038035426d-02,
     |   1.1176722572329d-01, 4.8835917163189d-01, 1.1562226903564d+00,
     |   1.3217360980424d+00, 1.4582780821286d-01,-1.0592753678591d+00,
     |  -2.4347232375002d-01, 9.7663001959658d-01,-5.2323461161763d-03,
     |  -9.1822997696589d-01, 3.8022341735390d-01, 7.2346752562550d-01,
     |  -7.2346752562550d-01,-3.8022341735390d-01, 9.1822997696589d-01,
     |   5.2323461161784d-03,-9.7663001959658d-01, 2.4347232375002d-01,
     |   1.0592753678591d+00,-1.4582780821286d-01,-1.3217360980424d+00,
     |  -1.1562226903564d+00,-4.8835917163189d-01,-1.1176722572329d-01,
     |  -1.3364038035426d-02,-7.2803665223632d-04,-1.3593983084556d-05,
     |  -4.7388175820730d-08,-6.2463672530138d-12,-1.8345745241195d-20/
      data (pmn(lat,19,27), lat = 1,36)/
     |   4.2909155003961d-22, 4.4222750235585d-13, 5.6951834038185d-09,
     |   2.3541006576154d-06, 1.6890162561729d-04, 4.0100159483303d-03,
     |   4.2836768410414d-02, 2.4105307625005d-01, 7.6547019378976d-01,
     |   1.3453866794243d+00, 1.0154796375113d+00,-4.1252162786244d-01,
     |  -1.0340382731112d+00, 2.3927901187566d-01, 9.4072245136341d-01,
     |  -3.7663154919789d-01,-8.0938860974630d-01, 6.0682881277289d-01,
     |   6.0682881277290d-01,-8.0938860974630d-01,-3.7663154919790d-01,
     |   9.4072245136341d-01, 2.3927901187566d-01,-1.0340382731112d+00,
     |  -4.1252162786245d-01, 1.0154796375113d+00, 1.3453866794243d+00,
     |   7.6547019378976d-01, 2.4105307625005d-01, 4.2836768410414d-02,
     |   4.0100159483303d-03, 1.6890162561729d-04, 2.3541006576155d-06,
     |   5.6951834038188d-09, 4.4222750235585d-13, 4.2909155003961d-22/
      data (pmn(lat,20,27), lat = 1,36)/
     |   9.0853709280589d-24, 2.8321813248565d-14, 6.1818886409064d-10,
     |   3.6723714196555d-07, 3.5156002178466d-05, 1.0728056366767d-03,
     |   1.4491631898215d-02, 1.0318994541986d-01, 4.2382055509637d-01,
     |   1.0290386428118d+00, 1.3739887552703d+00, 5.9649490497059d-01,
     |  -7.9940039272885d-01,-8.3056237283111d-01, 5.8675446361753d-01,
     |   7.9988380047867d-01,-6.0779628676791d-01,-7.0722425914392d-01,
     |   7.0722425914392d-01, 6.0779628676791d-01,-7.9988380047866d-01,
     |  -5.8675446361753d-01, 8.3056237283111d-01, 7.9940039272885d-01,
     |  -5.9649490497059d-01,-1.3739887552703d+00,-1.0290386428118d+00,
     |  -4.2382055509637d-01,-1.0318994541986d-01,-1.4491631898215d-02,
     |  -1.0728056366767d-03,-3.5156002178466d-05,-3.6723714196556d-07,
     |  -6.1818886409067d-10,-2.8321813248565d-14,-9.0853709280589d-24/
      data (pmn(lat,21,27), lat = 1,36)/
     |   1.7317607089756d-25, 1.6318200850445d-15, 6.0287447199063d-11,
     |   5.1357093115306d-08, 6.5378001772796d-06, 2.5512529958781d-04,
     |   4.3237946810299d-03, 3.8460774105927d-02, 1.9954614348543d-01,
     |   6.3444625119649d-01, 1.2264426647206d+00, 1.2656341802103d+00,
     |   1.8576266241887d-01,-1.0038568579391d+00,-5.9143410645624d-01,
     |   7.8538557948589d-01, 6.8159875066636d-01,-7.0931563578467d-01,
     |  -7.0931563578468d-01, 6.8159875066636d-01, 7.8538557948590d-01,
     |  -5.9143410645624d-01,-1.0038568579391d+00, 1.8576266241887d-01,
     |   1.2656341802103d+00, 1.2264426647206d+00, 6.3444625119649d-01,
     |   1.9954614348543d-01, 3.8460774105927d-02, 4.3237946810300d-03,
     |   2.5512529958781d-04, 6.5378001772796d-06, 5.1357093115307d-08,
     |   6.0287447199066d-11, 1.6318200850445d-15, 1.7317607089756d-25/
      data (pmn(lat,22,27), lat = 1,36)/
     |   2.9471637715963d-27, 8.3898582026846d-17, 5.2403437231149d-12,
     |   6.3893982605218d-09, 1.0785314166040d-06, 5.3595754886706d-05,
     |   1.1324761970088d-03, 1.2461221336652d-02, 8.0333338225179d-02,
     |   3.2395382439484d-01, 8.3631630323520d-01, 1.3373385526114d+00,
     |   1.0914653312619d+00,-1.3061656121526d-01,-1.0840439753927d+00,
     |  -4.2861690727775d-01, 8.6956451001385d-01, 6.8019533337071d-01,
     |  -6.8019533337070d-01,-8.6956451001385d-01, 4.2861690727775d-01,
     |   1.0840439753927d+00, 1.3061656121527d-01,-1.0914653312619d+00,
     |  -1.3373385526114d+00,-8.3631630323520d-01,-3.2395382439484d-01,
     |  -8.0333338225179d-02,-1.2461221336652d-02,-1.1324761970088d-03,
     |  -5.3595754886706d-05,-1.0785314166040d-06,-6.3893982605220d-09,
     |  -5.2403437231152d-12,-8.3898582026846d-17,-2.9471637715963d-27/
      data (pmn(lat,23,27), lat = 1,36)/
     |   4.4237039916901d-29, 3.8027055806465d-18, 4.0115307302720d-13,
     |   6.9892105229420d-10, 1.5605880146883d-07, 9.8408693415641d-06,
     |   2.5792506016922d-04, 3.4839072596777d-03, 2.7569267582552d-02,
     |   1.3805671888150d-01, 4.5580589443912d-01, 9.9839137486598d-01,
     |   1.3796886469234d+00, 9.3805936616465d-01,-3.0978422496326d-01,
     |  -1.1161277340682d+00,-4.2057338496389d-01, 8.5185057925495d-01,
     |   8.5185057925495d-01,-4.2057338496388d-01,-1.1161277340682d+00,
     |  -3.0978422496327d-01, 9.3805936616465d-01, 1.3796886469234d+00,
     |   9.9839137486598d-01, 4.5580589443912d-01, 1.3805671888150d-01,
     |   2.7569267582552d-02, 3.4839072596777d-03, 2.5792506016922d-04,
     |   9.8408693415641d-06, 1.5605880146883d-07, 6.9892105229422d-10,
     |   4.0115307302722d-13, 3.8027055806465d-18, 4.4237039916901d-29/
      data (pmn(lat,24,27), lat = 1,36)/
     |   5.7478686597947d-31, 1.4913705108302d-19, 2.6547990037798d-14,
     |   6.6001111167725d-11, 1.9453225062046d-08, 1.5519918672780d-06,
     |   5.0241801997568d-05, 8.2793956306578d-04, 7.9676563790974d-03,
     |   4.8806857159948d-02, 2.0060956737946d-01, 5.6801743520560d-01,
     |   1.1048600899951d+00, 1.3959985253036d+00, 8.8548174732915d-01,
     |  -3.2242789523529d-01,-1.1409496688782d+00,-6.3320476074898d-01,
     |   6.3320476074898d-01, 1.1409496688782d+00, 3.2242789523530d-01,
     |  -8.8548174732915d-01,-1.3959985253036d+00,-1.1048600899951d+00,
     |  -5.6801743520561d-01,-2.0060956737946d-01,-4.8806857159948d-02,
     |  -7.9676563790975d-03,-8.2793956306579d-04,-5.0241801997569d-05,
     |  -1.5519918672780d-06,-1.9453225062046d-08,-6.6001111167727d-11,
     |  -2.6547990037800d-14,-1.4913705108302d-19,-5.7478686597947d-31/
      data (pmn(lat,25,27), lat = 1,36)/
     |   6.2694002383301d-33, 4.9081072508673d-21, 1.4731639843221d-15,
     |   5.2195493035471d-12, 2.0270612272247d-09, 2.0408385091586d-07,
     |   8.1310850735824d-06, 1.6264696193418d-04, 1.8895372100154d-03,
     |   1.4000916632179d-02, 7.0342707875461d-02, 2.4897811452785d-01,
     |   6.3262509852581d-01, 1.1495140126960d+00, 1.4272051989974d+00,
     |   1.0016357552882d+00,-9.6320004776409d-02,-1.0803752941307d+00,
     |  -1.0803752941307d+00,-9.6320004776410d-02, 1.0016357552882d+00,
     |   1.4272051989974d+00, 1.1495140126960d+00, 6.3262509852581d-01,
     |   2.4897811452786d-01, 7.0342707875461d-02, 1.4000916632179d-02,
     |   1.8895372100155d-03, 1.6264696193418d-04, 8.1310850735825d-06,
     |   2.0408385091586d-07, 2.0270612272247d-09, 5.2195493035472d-12,
     |   1.4731639843222d-15, 4.9081072508673d-21, 6.2694002383301d-33/
      data (pmn(lat,26,27), lat = 1,36)/
     |   5.4198169247239d-35, 1.2797864769038d-22, 6.4724185337176d-17,
     |   3.2646450730775d-13, 1.6679233354977d-10, 2.1144824386238d-08,
     |   1.0336853935757d-06, 2.4993181437478d-05, 3.4843955065629d-04,
     |   3.0961065776221d-03, 1.8763321125960d-02, 8.1227871883509d-02,
     |   2.5899249921131d-01, 6.1882552403370d-01, 1.1111646300660d+00,
     |   1.4695543601065d+00, 1.3225434626684d+00, 5.3908450955049d-01,
     |  -5.3908450955048d-01,-1.3225434626684d+00,-1.4695543601065d+00,
     |  -1.1111646300660d+00,-6.1882552403370d-01,-2.5899249921131d-01,
     |  -8.1227871883510d-02,-1.8763321125960d-02,-3.0961065776221d-03,
     |  -3.4843955065630d-04,-2.4993181437478d-05,-1.0336853935757d-06,
     |  -2.1144824386238d-08,-1.6679233354977d-10,-3.2646450730776d-13,
     |  -6.4724185337180d-17,-1.2797864769038d-22,-5.4198169247239d-35/
      data (pmn(lat,27,27), lat = 1,36)/
     |   3.2201851837665d-37, 2.2928188283481d-24, 1.9526524487314d-18,
     |   1.4007524637785d-14, 9.4016378798510d-12, 1.4979036481113d-09,
     |   8.9614612624030d-08, 2.6097874314348d-06, 4.3449324288549d-05,
     |   4.5979745214697d-04, 3.3276095211479d-03, 1.7350854306310d-02,
     |   6.7703891319997d-02, 2.0330451505481d-01, 4.7957797138093d-01,
     |   9.0205608035386d-01, 1.3670486510396d+00, 1.6802227557682d+00,
     |   1.6802227557682d+00, 1.3670486510396d+00, 9.0205608035386d-01,
     |   4.7957797138093d-01, 2.0330451505481d-01, 6.7703891319996d-02,
     |   1.7350854306310d-02, 3.3276095211479d-03, 4.5979745214697d-04,
     |   4.3449324288550d-05, 2.6097874314348d-06, 8.9614612624031d-08,
     |   1.4979036481113d-09, 9.4016378798510d-12, 1.4007524637785d-14,
     |   1.9526524487316d-18, 2.2928188283481d-24, 3.2201851837665d-37/
      data (pmn(lat, 0,28), lat = 1,36)/
     |   3.4661354706416d+00,-2.1421771822774d+00, 1.1036524710739d+00,
     |  -7.5033785326940d-02,-7.2745960603454d-01, 1.1146050523816d+00,
     |  -1.0280411845822d+00, 5.6316289876584d-01, 6.8106270215395d-02,
     |  -6.1539840352779d-01, 8.7905399928410d-01,-7.7805342392959d-01,
     |   3.7292735322795d-01, 1.6340814053653d-01,-6.1495663049496d-01,
     |   8.0576958950936d-01,-6.6596383149876d-01, 2.5642931529743d-01,
     |   2.5642931529743d-01,-6.6596383149876d-01, 8.0576958950936d-01,
     |  -6.1495663049496d-01, 1.6340814053653d-01, 3.7292735322794d-01,
     |  -7.7805342392960d-01, 8.7905399928410d-01,-6.1539840352779d-01,
     |   6.8106270215390d-02, 5.6316289876584d-01,-1.0280411845822d+00,
     |   1.1146050523816d+00,-7.2745960603454d-01,-7.5033785326957d-02,
     |   1.1036524710739d+00,-2.1421771822774d+00, 3.4661354706416d+00/
      data (pmn(lat, 1,28), lat = 1,36)/
     |   2.7179484416944d+00, 2.2145235988757d-01,-1.2267260365169d+00,
     |   1.4503560364060d+00,-1.0962798092789d+00, 4.0578182318621d-01,
     |   3.2882604817958d-01,-8.4095022781438d-01, 9.6995205163148d-01,
     |  -7.0626394108481d-01, 1.8368270089508d-01, 3.7784669448172d-01,
     |  -7.5745162054099d-01, 8.1524405241812d-01,-5.4137573449007d-01,
     |   5.5176515821732d-02, 4.4413922420218d-01,-7.5592804752617d-01,
     |   7.5592804752617d-01,-4.4413922420218d-01,-5.5176515821741d-02,
     |   5.4137573449007d-01,-8.1524405241812d-01, 7.5745162054100d-01,
     |  -3.7784669448171d-01,-1.8368270089508d-01, 7.0626394108481d-01,
     |  -9.6995205163148d-01, 8.4095022781438d-01,-3.2882604817957d-01,
     |  -4.0578182318621d-01, 1.0962798092789d+00,-1.4503560364060d+00,
     |   1.2267260365169d+00,-2.2145235988757d-01,-2.7179484416944d+00/
      data (pmn(lat, 2,28), lat = 1,36)/
     |   9.0416019833979d-01, 2.2630259904091d+00,-1.4938621311101d+00,
     |   3.9837731297414d-01, 5.4236929501548d-01,-1.0612026092897d+00,
     |   1.0655811598301d+00,-6.4087308510907d-01, 6.1946866452860d-03,
     |   5.7067909729173d-01,-8.7023399858653d-01, 7.9592910986209d-01,
     |  -4.0109635921607d-01,-1.3987966161920d-01, 6.0372013828054d-01,
     |  -8.0590415230961d-01, 6.7089449817627d-01,-2.5906502156712d-01,
     |  -2.5906502156713d-01, 6.7089449817627d-01,-8.0590415230961d-01,
     |   6.0372013828054d-01,-1.3987966161920d-01,-4.0109635921607d-01,
     |   7.9592910986209d-01,-8.7023399858653d-01, 5.7067909729173d-01,
     |   6.1946866452915d-03,-6.4087308510907d-01, 1.0655811598301d+00,
     |  -1.0612026092897d+00, 5.4236929501548d-01, 3.9837731297415d-01,
     |  -1.4938621311101d+00, 2.2630259904091d+00, 9.0416019833979d-01/
      data (pmn(lat, 3,28), lat = 1,36)/
     |   1.9304322639458d-01, 2.1998804214488d+00, 2.8036948160402d-01,
     |  -1.2759321329220d+00, 1.2834826702344d+00,-6.9400710010712d-01,
     |  -9.3977837597433d-02, 7.2535941831251d-01,-9.7140341414460d-01,
     |   7.8169213022949d-01,-2.7822045567446d-01,-3.0734102235325d-01,
     |   7.2991050704778d-01,-8.2542789215588d-01, 5.6953692112130d-01,
     |  -8.0486036228951d-02,-4.3279548992176d-01, 7.5620782284022d-01,
     |  -7.5620782284022d-01, 4.3279548992175d-01, 8.0486036228960d-02,
     |  -5.6953692112130d-01, 8.2542789215588d-01,-7.2991050704778d-01,
     |   3.0734102235324d-01, 2.7822045567446d-01,-7.8169213022949d-01,
     |   9.7140341414460d-01,-7.2535941831250d-01, 9.3977837597420d-02,
     |   6.9400710010712d-01,-1.2834826702344d+00, 1.2759321329220d+00,
     |  -2.8036948160400d-01,-2.1998804214488d+00,-1.9304322639458d-01/
      data (pmn(lat, 4,28), lat = 1,36)/
     |   3.0379674670733d-02, 1.2731769366661d+00, 1.7677296098441d+00,
     |  -1.2583115667753d+00, 1.1291321039602d-01, 7.8236551052762d-01,
     |  -1.1008624210359d+00, 8.4380172408821d-01,-2.3109921346391d-01,
     |  -4.2086733166528d-01, 8.2820404697173d-01,-8.4044325953252d-01,
     |   4.8320090990843d-01, 6.7874560822853d-02,-5.6788639785111d-01,
     |   8.0513550676002d-01,-6.8549264078318d-01, 2.6703861026586d-01,
     |   2.6703861026586d-01,-6.8549264078318d-01, 8.0513550676002d-01,
     |  -5.6788639785111d-01, 6.7874560822850d-02, 4.8320090990842d-01,
     |  -8.4044325953253d-01, 8.2820404697173d-01,-4.2086733166528d-01,
     |  -2.3109921346391d-01, 8.4380172408822d-01,-1.1008624210359d+00,
     |   7.8236551052762d-01, 1.1291321039602d-01,-1.2583115667753d+00,
     |   1.7677296098441d+00, 1.2731769366661d+00, 3.0379674670733d-02/
      data (pmn(lat, 5,28), lat = 1,36)/
     |   3.7802118329122d-03, 5.3811495065971d-01, 1.9848864954812d+00,
     |   1.4788934693397d-01,-1.2124582305094d+00, 1.1247320773452d+00,
     |  -3.9676540557855d-01,-4.1641482716030d-01, 9.0460471843069d-01,
     |  -8.9525905529425d-01, 4.6027509544751d-01, 1.5668637974229d-01,
     |  -6.6208341796882d-01, 8.3757830552846d-01,-6.2330536738340d-01,
     |   1.3163164441583d-01, 4.0932158524911d-01,-7.5670313716957d-01,
     |   7.5670313716957d-01,-4.0932158524911d-01,-1.3163164441584d-01,
     |   6.2330536738340d-01,-8.3757830552846d-01, 6.6208341796882d-01,
     |  -1.5668637974228d-01,-4.6027509544751d-01, 8.9525905529425d-01,
     |  -9.0460471843069d-01, 4.1641482716029d-01, 3.9676540557856d-01,
     |  -1.1247320773452d+00, 1.2124582305094d+00,-1.4788934693396d-01,
     |  -1.9848864954812d+00,-5.3811495065971d-01,-3.7802118329122d-03/
      data (pmn(lat, 6,28), lat = 1,36)/
     |   3.8803190902683d-04, 1.8035567394653d-01, 1.4226773344096d+00,
     |   1.4340616591130d+00,-1.1603735294139d+00,-1.4726472225136d-02,
     |   8.8516709448159d-01,-1.0432425559920d+00, 5.8559514350647d-01,
     |   1.3019183775735d-01,-7.0718520006002d-01, 8.8149550973221d-01,
     |  -6.0953035504740d-01, 5.5757002552273d-02, 5.0122778609423d-01,
     |  -7.9983160513095d-01, 7.0913204716548d-01,-2.8055509229370d-01,
     |  -2.8055509229370d-01, 7.0913204716548d-01,-7.9983160513094d-01,
     |   5.0122778609423d-01, 5.5757002552276d-02,-6.0953035504739d-01,
     |   8.8149550973222d-01,-7.0718520006002d-01, 1.3019183775735d-01,
     |   5.8559514350648d-01,-1.0432425559920d+00, 8.8516709448158d-01,
     |  -1.4726472225136d-02,-1.1603735294139d+00, 1.4340616591130d+00,
     |   1.4226773344096d+00, 1.8035567394653d-01, 3.8803190902683d-04/
      data (pmn(lat, 7,28), lat = 1,36)/
     |   3.3798304632077d-05, 5.0137539922157d-02, 7.7486046159169d-01,
     |   1.8178587622534d+00, 1.0408587360747d-02,-1.1456960438151d+00,
     |   1.0007058492582d+00,-1.6830334619848d-01,-6.3526270541027d-01,
     |   9.5379891125608d-01,-6.9851343724168d-01, 8.4950322194481d-02,
     |   5.3000557126842d-01,-8.3409209276116d-01, 6.9648640288142d-01,
     |  -2.0933471812656d-01,-3.7212567320065d-01, 7.5727952008767d-01,
     |  -7.5727952008767d-01, 3.7212567320065d-01, 2.0933471812657d-01,
     |  -6.9648640288142d-01, 8.3409209276116d-01,-5.3000557126843d-01,
     |  -8.4950322194493d-02, 6.9851343724168d-01,-9.5379891125608d-01,
     |   6.3526270541027d-01, 1.6830334619849d-01,-1.0007058492582d+00,
     |   1.1456960438151d+00,-1.0408587360747d-02,-1.8178587622534d+00,
     |  -7.7486046159170d-01,-5.0137539922157d-02,-3.3798304632077d-05/
      data (pmn(lat, 8,28), lat = 1,36)/
     |   2.5484117845844d-06, 1.1892406077090d-02, 3.4386344316905d-01,
     |   1.4883756165351d+00, 1.1838632752029d+00,-1.1057616839428d+00,
     |  -9.3516567747028d-02, 9.4117686680465d-01,-9.4398702695639d-01,
     |   3.1362502798443d-01, 4.4079133462926d-01,-8.6206385312476d-01,
     |   7.5563141894217d-01,-2.3218694952197d-01,-3.9403197597271d-01,
     |   7.8357348541460d-01,-7.4061310043873d-01, 2.9997603763503d-01,
     |   2.9997603763503d-01,-7.4061310043873d-01, 7.8357348541460d-01,
     |  -3.9403197597271d-01,-2.3218694952197d-01, 7.5563141894217d-01,
     |  -8.6206385312475d-01, 4.4079133462926d-01, 3.1362502798444d-01,
     |  -9.4398702695640d-01, 9.4117686680465d-01,-9.3516567747017d-02,
     |  -1.1057616839428d+00, 1.1838632752029d+00, 1.4883756165351d+00,
     |   3.4386344316905d-01, 1.1892406077090d-02, 2.5484117845844d-06/
      data (pmn(lat, 9,28), lat = 1,36)/
     |   1.6880088556411d-07, 2.4539349171199d-03, 1.2910162189186d-01,
     |   9.3907263956761d-01, 1.6705322977361d+00,-9.1348278773939d-02,
     |  -1.0978051056431d+00, 8.9154426710162d-01, 3.6170336253432d-02,
     |  -7.9502374379989d-01, 9.0496250309350d-01,-4.0888489164997d-01,
     |  -3.0434337170347d-01, 7.8649367949383d-01,-7.7704887988231d-01,
     |   3.1375938708174d-01, 3.1877830255933d-01,-7.5771912083189d-01,
     |   7.5771912083189d-01,-3.1877830255933d-01,-3.1375938708174d-01,
     |   7.7704887988231d-01,-7.8649367949383d-01, 3.0434337170348d-01,
     |   4.0888489164998d-01,-9.0496250309350d-01, 7.9502374379989d-01,
     |  -3.6170336253427d-02,-8.9154426710162d-01, 1.0978051056431d+00,
     |   9.1348278773939d-02,-1.6705322977361d+00,-9.3907263956761d-01,
     |  -1.2910162189186d-01,-2.4539349171199d-03,-1.6880088556411d-07/
      data (pmn(lat,10,28), lat = 1,36)/
     |   9.9319052738043d-09, 4.4668051602641d-04, 4.1980525583652d-02,
     |   4.8835950759166d-01, 1.5031537616200d+00, 1.0019092176061d+00,
     |  -1.0596863539252d+00,-1.7450214925047d-01, 9.8212432748573d-01,
     |  -8.0552911798833d-01, 1.8921360728512d-02, 6.9824490470341d-01,
     |  -8.7112419181552d-01, 4.5329795393178d-01, 2.3478856659858d-01,
     |  -7.4668411490828d-01, 7.7790222885734d-01,-3.2585414307670d-01,
     |  -3.2585414307671d-01, 7.7790222885734d-01,-7.4668411490828d-01,
     |   2.3478856659858d-01, 4.5329795393178d-01,-8.7112419181552d-01,
     |   6.9824490470341d-01, 1.8921360728512d-02,-8.0552911798833d-01,
     |   9.8212432748573d-01,-1.7450214925046d-01,-1.0596863539252d+00,
     |   1.0019092176061d+00, 1.5031537616200d+00, 4.8835950759166d-01,
     |   4.1980525583653d-02, 4.4668051602641d-04, 9.9319052738043d-09/
      data (pmn(lat,11,28), lat = 1,36)/
     |   5.2352958891122d-10, 7.2470808642885d-05, 1.2012336388782d-02,
     |   2.1681722027744d-01, 1.0451439664506d+00, 1.5454648337678d+00,
     |  -1.4226688055866d-01,-1.0758201332525d+00, 7.7236819255548d-01,
     |   2.4908981379735d-01,-9.0680358499596d-01, 7.5044988940397d-01,
     |  -3.3660598518814d-02,-6.5588609088220d-01, 8.4392076804089d-01,
     |  -4.4315249121681d-01,-2.4598099408899d-01, 7.5769769309312d-01,
     |  -7.5769769309312d-01, 2.4598099408898d-01, 4.4315249121682d-01,
     |  -8.4392076804089d-01, 6.5588609088220d-01, 3.3660598518806d-02,
     |  -7.5044988940397d-01, 9.0680358499596d-01,-2.4908981379735d-01,
     |  -7.7236819255549d-01, 1.0758201332525d+00, 1.4226688055867d-01,
     |  -1.5454648337678d+00,-1.0451439664506d+00,-2.1681722027745d-01,
     |  -1.2012336388783d-02,-7.2470808642885d-05,-5.2352958891122d-10/
      data (pmn(lat,12,28), lat = 1,36)/
     |   2.4885720286554d-11, 1.0561999035270d-05, 3.0588621045766d-03,
     |   8.3952637764272d-02, 6.0145135734924d-01, 1.4866833720230d+00,
     |   8.8829023945216d-01,-1.0055413486798d+00,-2.8676967290103d-01,
     |   1.0110207022814d+00,-6.0625720814555d-01,-3.0610459794151d-01,
     |   8.7032059535593d-01,-6.8977569592505d-01,-1.4068864817664d-02,
     |   6.7578154567383d-01,-8.1770691917833d-01, 3.5899319160719d-01,
     |   3.5899319160720d-01,-8.1770691917833d-01, 6.7578154567382d-01,
     |  -1.4068864817661d-02,-6.8977569592505d-01, 8.7032059535593d-01,
     |  -3.0610459794150d-01,-6.0625720814555d-01, 1.0110207022814d+00,
     |  -2.8676967290103d-01,-1.0055413486798d+00, 8.8829023945216d-01,
     |   1.4866833720230d+00, 6.0145135734924d-01, 8.3952637764273d-02,
     |   3.0588621045767d-03, 1.0561999035270d-05, 2.4885720286554d-11/
      data (pmn(lat,13,28), lat = 1,36)/
     |   1.0721113948696d-12, 1.3909172026974d-06, 6.9887126909798d-04,
     |   2.8752706759728d-02, 2.9652510459725d-01, 1.1026109744989d+00,
     |   1.4513984905310d+00,-1.3262163320421d-01,-1.0796213556987d+00,
     |   6.1449874519738d-01, 4.8733257263832d-01,-9.4678711757852d-01,
     |   4.5880752864409d-01, 4.0004963151554d-01,-8.6337629445349d-01,
     |   5.9157117945626d-01, 1.4956463494406d-01,-7.5674632508958d-01,
     |   7.5674632508958d-01,-1.4956463494406d-01,-5.9157117945626d-01,
     |   8.6337629445349d-01,-4.0004963151554d-01,-4.5880752864409d-01,
     |   9.4678711757852d-01,-4.8733257263832d-01,-6.1449874519739d-01,
     |   1.0796213556987d+00, 1.3262163320421d-01,-1.4513984905310d+00,
     |  -1.1026109744989d+00,-2.9652510459725d-01,-2.8752706759728d-02,
     |  -6.9887126909800d-04,-1.3909172026974d-06,-1.0721113948696d-12/
      data (pmn(lat,14,28), lat = 1,36)/
     |   4.2018414992886d-14, 1.6623731773984d-07, 1.4412156872871d-04,
     |   8.7950355173475d-03, 1.2781285107495d-01, 6.7701023435688d-01,
     |   1.4535131356695d+00, 8.4704624099632d-01,-9.2782854594984d-01,
     |  -4.4839285668707d-01, 1.0059956416528d+00,-3.1244529774177d-01,
     |  -6.4069199567128d-01, 8.7551425783667d-01,-2.6762842849033d-01,
     |  -5.5373348938803d-01, 8.5480640459501d-01,-4.0055133573418d-01,
     |  -4.0055133573418d-01, 8.5480640459501d-01,-5.5373348938802d-01,
     |  -2.6762842849033d-01, 8.7551425783667d-01,-6.4069199567129d-01,
     |  -3.1244529774179d-01, 1.0059956416528d+00,-4.4839285668707d-01,
     |  -9.2782854594984d-01, 8.4704624099631d-01, 1.4535131356695d+00,
     |   6.7701023435688d-01, 1.2781285107495d-01, 8.7950355173477d-03,
     |   1.4412156872872d-04, 1.6623731773984d-07, 4.2018414992886d-14/
      data (pmn(lat,15,28), lat = 1,36)/
     |   1.5021171271995d-15, 1.8087668898553d-08, 2.6940396096104d-05,
     |   2.4190427189940d-03, 4.8792984635450d-02, 3.5619020585924d-01,
     |   1.1189344937199d+00, 1.3954267945020d+00,-5.1070100594466d-02,
     |  -1.0975169577733d+00, 3.8238268888316d-01, 7.4140080463318d-01,
     |  -8.4997108350087d-01, 4.6067821372727d-03, 7.8692926931449d-01,
     |  -7.4526509296579d-01,-2.4576257601123d-02, 7.5418733805332d-01,
     |  -7.5418733805332d-01, 2.4576257601121d-02, 7.4526509296580d-01,
     |  -7.8692926931449d-01,-4.6067821372751d-03, 8.4997108350087d-01,
     |  -7.4140080463317d-01,-3.8238268888316d-01, 1.0975169577733d+00,
     |   5.1070100594471d-02,-1.3954267945020d+00,-1.1189344937199d+00,
     |  -3.5619020585924d-01,-4.8792984635450d-02,-2.4190427189940d-03,
     |  -2.6940396096105d-05,-1.8087668898553d-08,-1.5021171271995d-15/
      data (pmn(lat,16,28), lat = 1,36)/
     |   4.9063255658004d-17, 1.7953092429226d-09, 4.5778532781999d-06,
     |   6.0102592504869d-04, 1.6638050149196d-02, 1.6374197639054d-01,
     |   7.1198961268385d-01, 1.4121537539211d+00, 8.8193907951254d-01,
     |  -8.0149794021223d-01,-6.6399366601702d-01, 9.1300035273304d-01,
     |   1.0226449105924d-01,-8.9578658791629d-01, 5.8578681997101d-01,
     |   3.6082143036281d-01,-8.8099472478883d-01, 4.5222540553560d-01,
     |   4.5222540553560d-01,-8.8099472478883d-01, 3.6082143036280d-01,
     |   5.8578681997101d-01,-8.9578658791629d-01, 1.0226449105925d-01,
     |   9.1300035273304d-01,-6.6399366601702d-01,-8.0149794021223d-01,
     |   8.8193907951254d-01, 1.4121537539211d+00, 7.1198961268385d-01,
     |   1.6374197639054d-01, 1.6638050149196d-02, 6.0102592504870d-04,
     |   4.5778532782001d-06, 1.7953092429226d-09, 4.9063255658004d-17/
      data (pmn(lat,17,28), lat = 1,36)/
     |   1.4652443079843d-18, 1.6271522974339d-10, 7.0828313237460d-07,
     |   1.3528138186870d-04, 5.0956126194237d-03, 6.6556031562592d-02,
     |   3.8739187035680d-01, 1.0981023363067d+00, 1.3779378828743d+00,
     |   1.1820286428871d-01,-1.0951623005114d+00, 3.7908918354469d-02,
     |   9.4810152343992d-01,-5.1569550960942d-01,-5.5556994128845d-01,
     |   8.7718332852761d-01,-1.3442464184807d-01,-7.4902253704959d-01,
     |   7.4902253704959d-01, 1.3442464184807d-01,-8.7718332852761d-01,
     |   5.5556994128845d-01, 5.1569550960942d-01,-9.4810152343992d-01,
     |  -3.7908918354479d-02, 1.0951623005114d+00,-1.1820286428870d-01,
     |  -1.3779378828743d+00,-1.0981023363067d+00,-3.8739187035680d-01,
     |  -6.6556031562592d-02,-5.0956126194237d-03,-1.3528138186870d-04,
     |  -7.0828313237462d-07,-1.6271522974339d-10,-1.4652443079843d-18/
      data (pmn(lat,18,28), lat = 1,36)/
     |   4.0000055437232d-20, 1.3465946362644d-11, 9.9824668522842d-08,
     |   2.7623814781200d-05, 1.4061763296994d-03, 2.4093972739166d-02,
     |   1.8358725571908d-01, 7.0422084888827d-01, 1.3618149082932d+00,
     |   9.9170133950234d-01,-5.8423314298876d-01,-9.0667229975746d-01,
     |   6.4034933226915d-01, 6.0252766618764d-01,-8.6991498018351d-01,
     |  -7.8813197265353d-02, 8.8336293362908d-01,-5.1660187461246d-01,
     |  -5.1660187461247d-01, 8.8336293362908d-01,-7.8813197265345d-02,
     |  -8.6991498018351d-01, 6.0252766618764d-01, 6.4034933226915d-01,
     |  -9.0667229975745d-01,-5.8423314298876d-01, 9.9170133950234d-01,
     |   1.3618149082932d+00, 7.0422084888827d-01, 1.8358725571908d-01,
     |   2.4093972739166d-02, 1.4061763296994d-03, 2.7623814781201d-05,
     |   9.9824668522846d-08, 1.3465946362644d-11, 4.0000055437232d-20/
      data (pmn(lat,19,28), lat = 1,36)/
     |   9.9690666283786d-22, 1.0164469454779d-12, 1.2806773635694d-08,
     |   5.1171085463847d-06, 3.5010923307639d-04, 7.7993725306701d-03,
     |   7.6575117499171d-02, 3.8460805667123d-01, 1.0381160885863d+00,
     |   1.3863457203090d+00, 3.9190711969090d-01,-9.9849438977930d-01,
     |  -4.3020420519568d-01, 9.4951470871108d-01, 1.2099198687913d-01,
     |  -9.3917181654201d-01, 3.3259543735912d-01, 7.3972489784853d-01,
     |  -7.3972489784852d-01,-3.3259543735912d-01, 9.3917181654201d-01,
     |  -1.2099198687913d-01,-9.4951470871108d-01, 4.3020420519569d-01,
     |   9.9849438977931d-01,-3.9190711969090d-01,-1.3863457203090d+00,
     |  -1.0381160885863d+00,-3.8460805667123d-01,-7.6575117499171d-02,
     |  -7.7993725306701d-03,-3.5010923307639d-04,-5.1171085463848d-06,
     |  -1.2806773635695d-08,-1.0164469454779d-12,-9.9690666283786d-22/
      data (pmn(lat,20,28), lat = 1,36)/
     |   2.2626781210010d-23, 6.9817045691693d-14, 1.4925669365090d-09,
     |   8.5866280870821d-07, 7.8610331279932d-05, 2.2607312712243d-03,
     |   2.8265131420600d-02, 1.8184767608367d-01, 6.5081534828489d-01,
     |   1.2881548481503d+00, 1.1591878628604d+00,-2.1727778849097d-01,
     |  -1.0773619589616d+00, 9.0595039236641d-02, 9.7711506195099d-01,
     |  -2.9845770955384d-01,-8.4134104731124d-01, 5.9789196103879d-01,
     |   5.9789196103879d-01,-8.4134104731124d-01,-2.9845770955384d-01,
     |   9.7711506195099d-01, 9.0595039236643d-02,-1.0773619589616d+00,
     |  -2.1727778849098d-01, 1.1591878628604d+00, 1.2881548481503d+00,
     |   6.5081534828490d-01, 1.8184767608367d-01, 2.8265131420601d-02,
     |   2.2607312712243d-03, 7.8610331279932d-05, 8.5866280870823d-07,
     |   1.4925669365091d-09, 6.9817045691693d-14, 2.2626781210010d-23/
      data (pmn(lat,21,28), lat = 1,36)/
     |   4.6587188430576d-25, 4.3472644513884d-15, 1.5746174502490d-10,
     |   1.3011351475804d-07, 1.5879666594706d-05, 5.8619459009020d-04,
     |   9.2484938359442d-03, 7.5034730874247d-02, 3.4510726138578d-01,
     |   9.2936069958741d-01, 1.3855963819492d+00, 7.6854766693716d-01,
     |  -6.8144582567988d-01,-9.2096945225966d-01, 4.9540692050191d-01,
     |   8.5224854895056d-01,-5.7293086319788d-01,-7.2381027017416d-01,
     |   7.2381027017416d-01, 5.7293086319788d-01,-8.5224854895055d-01,
     |  -4.9540692050191d-01, 9.2096945225966d-01, 6.8144582567988d-01,
     |  -7.6854766693715d-01,-1.3855963819492d+00,-9.2936069958741d-01,
     |  -3.4510726138578d-01,-7.5034730874247d-02,-9.2484938359443d-03,
     |  -5.8619459009020d-04,-1.5879666594706d-05,-1.3011351475805d-07,
     |  -1.5746174502490d-10,-4.3472644513884d-15,-4.6587188430576d-25/
      data (pmn(lat,22,28), lat = 1,36)/
     |   8.6509971362759d-27, 2.4398794442825d-16, 1.4954426127822d-11,
     |   1.7712595826882d-08, 2.8727867239670d-06, 1.3548628714699d-04,
     |   2.6780912414729d-03, 2.7082150255958d-02, 1.5674818447239d-01,
     |   5.4858720320179d-01, 1.1601213006856d+00, 1.3291368179186d+00,
     |   3.4378734447690d-01,-9.5229284802994d-01,-6.8341055363337d-01,
     |   7.4002485149902d-01, 7.2105672752188d-01,-7.0369622624970d-01,
     |  -7.0369622624970d-01, 7.2105672752188d-01, 7.4002485149903d-01,
     |  -6.8341055363337d-01,-9.5229284802994d-01, 3.4378734447691d-01,
     |   1.3291368179186d+00, 1.1601213006856d+00, 5.4858720320179d-01,
     |   1.5674818447239d-01, 2.7082150255958d-02, 2.6780912414729d-03,
     |   1.3548628714699d-04, 2.8727867239670d-06, 1.7712595826883d-08,
     |   1.4954426127823d-11, 2.4398794442825d-16, 8.6509971362759d-27/
      data (pmn(lat,23,28), lat = 1,36)/
     |   1.4366787704629d-28, 1.2240213554056d-17, 1.2681180169341d-12,
     |   2.1491524591421d-09, 4.6199148917038d-07, 2.7727879590138d-05,
     |   6.8267962921290d-04, 8.5275453896248d-03, 6.1185086356270d-02,
     |   2.7048218510808d-01, 7.5724229468519d-01, 1.3079022581419d+00,
     |   1.1789450745837d+00,-7.2117557183367d-03,-1.0718244082085d+00,
     |  -4.9880304959207d-01, 8.5151490929427d-01, 6.9682118497495d-01,
     |  -6.9682118497495d-01,-8.5151490929427d-01, 4.9880304959207d-01,
     |   1.0718244082085d+00, 7.2117557183391d-03,-1.1789450745837d+00,
     |  -1.3079022581419d+00,-7.5724229468519d-01,-2.7048218510808d-01,
     |  -6.1185086356271d-02,-8.5275453896249d-03,-6.8267962921291d-04,
     |  -2.7727879590138d-05,-4.6199148917038d-07,-2.1491524591421d-09,
     |  -1.2681180169342d-12,-1.2240213554056d-17,-1.4366787704629d-28/
      data (pmn(lat,24,28), lat = 1,36)/
     |   2.1075183577147d-30, 5.4216275641125d-19, 9.4854021649942d-14,
     |   2.2966226625963d-10, 6.5284311506704d-08, 4.9698822174481d-06,
     |   1.5168116652637d-04, 2.3236838257229d-03, 2.0436561627343d-02,
     |   1.1192901287542d-01, 3.9905559784777d-01, 9.3509665867270d-01,
     |   1.3778581919287d+00, 1.0245833333873d+00,-2.2268358708313d-01,
     |  -1.1182921266105d+00,-4.6243586714706d-01, 8.5020567304889d-01,
     |   8.5020567304889d-01,-4.6243586714706d-01,-1.1182921266105d+00,
     |  -2.2268358708313d-01, 1.0245833333873d+00, 1.3778581919288d+00,
     |   9.3509665867271d-01, 3.9905559784777d-01, 1.1192901287542d-01,
     |   2.0436561627343d-02, 2.3236838257229d-03, 1.5168116652637d-04,
     |   4.9698822174481d-06, 6.5284311506704d-08, 2.2966226625964d-10,
     |   9.4854021649947d-14, 5.4216275641125d-19, 2.1075183577147d-30/
      data (pmn(lat,25,28), lat = 1,36)/
     |   2.6798716448009d-32, 2.0807806192050d-20, 6.1424761997747d-15,
     |   2.1218709001446d-11, 7.9603225310676d-09, 7.6647274893515d-07,
     |   2.8881791480304d-05, 5.3948916317031d-04, 5.7653396115267d-03,
     |   3.8576335000536d-02, 1.7085793753617d-01, 5.1547153486019d-01,
     |   1.0589761495486d+00, 1.4070741635086d+00, 9.5551303184091d-01,
     |  -2.6491176311434d-01,-1.1437015219678d+00,-6.4931069959089d-01,
     |   6.4931069959089d-01, 1.1437015219678d+00, 2.6491176311434d-01,
     |  -9.5551303184091d-01,-1.4070741635086d+00,-1.0589761495486d+00,
     |  -5.1547153486020d-01,-1.7085793753617d-01,-3.8576335000536d-02,
     |  -5.7653396115267d-03,-5.3948916317031d-04,-2.8881791480304d-05,
     |  -7.6647274893515d-07,-7.9603225310676d-09,-2.1218709001447d-11,
     |  -6.1424761997751d-15,-2.0807806192050d-20,-2.6798716448009d-32/
      data (pmn(lat,26,28), lat = 1,36)/
     |   2.8641364317581d-34, 6.7097236006755d-22, 3.3395704886088d-16,
     |   1.6439672877232d-12, 8.1254481987456d-10, 9.8715659168926d-08,
     |   4.5769808476254d-06, 1.0374443574078d-04, 1.3377971350089d-03,
     |   1.0820610724129d-02, 5.8521580897262d-02, 2.2033183261332d-01,
     |   5.8937243679076d-01, 1.1174881104209d+00, 1.4382494617454d+00,
     |   1.0485688769979d+00,-6.2491758677765d-02,-1.0839677725317d+00,
     |  -1.0839677725317d+00,-6.2491758677766d-02, 1.0485688769979d+00,
     |   1.4382494617454d+00, 1.1174881104209d+00, 5.8937243679076d-01,
     |   2.2033183261332d-01, 5.8521580897262d-02, 1.0820610724129d-02,
     |   1.3377971350089d-03, 1.0374443574078d-04, 4.5769808476255d-06,
     |   9.8715659168926d-08, 8.1254481987456d-10, 1.6439672877233d-12,
     |   3.3395704886090d-16, 6.7097236006755d-22, 2.8641364317581d-34/
      data (pmn(lat,27,28), lat = 1,36)/
     |   2.4288725479948d-36, 1.7162309650660d-23, 1.4392753629769d-17,
     |   1.0085985150775d-13, 6.5577717017981d-11, 1.0031138581439d-08,
     |   5.7061797927244d-07, 1.5631808201098d-05, 2.4185292210334d-04,
     |   2.3452402238435d-03, 1.5293853083104d-02, 7.0384141040694d-02,
     |   2.3602426743954d-01, 5.8738670460940d-01, 1.0887757972806d+00,
     |   1.4740347318878d+00, 1.3471596525972d+00, 5.5332953440492d-01,
     |  -5.5332953440492d-01,-1.3471596525972d+00,-1.4740347318878d+00,
     |  -1.0887757972806d+00,-5.8738670460939d-01,-2.3602426743954d-01,
     |  -7.0384141040695d-02,-1.5293853083104d-02,-2.3452402238435d-03,
     |  -2.4185292210335d-04,-1.5631808201098d-05,-5.7061797927245d-07,
     |  -1.0031138581439d-08,-6.5577717017981d-11,-1.0085985150775d-13,
     |  -1.4392753629770d-17,-1.7162309650660d-23,-2.4288725479948d-36/
      data (pmn(lat,28,28), lat = 1,36)/
     |   1.4171108507276d-38, 3.0193316708585d-25, 4.2638813908156d-19,
     |   4.2495859106872d-15, 3.6298325809212d-12, 6.9780309702778d-10,
     |   4.8577903760180d-08, 1.6028603188005d-06, 2.9614867041792d-05,
     |   3.4201161794997d-04, 2.6634369914333d-03, 1.4763640765174d-02,
     |   6.0587909636715d-02, 1.8949850320853d-01, 4.6144733504999d-01,
     |   8.8850211450709d-01, 1.3674011826795d+00, 1.6935449477324d+00,
     |   1.6935449477324d+00, 1.3674011826795d+00, 8.8850211450710d-01,
     |   4.6144733504999d-01, 1.8949850320853d-01, 6.0587909636715d-02,
     |   1.4763640765174d-02, 2.6634369914333d-03, 3.4201161794997d-04,
     |   2.9614867041793d-05, 1.6028603188005d-06, 4.8577903760180d-08,
     |   6.9780309702778d-10, 3.6298325809212d-12, 4.2495859106873d-15,
     |   4.2638813908159d-19, 3.0193316708585d-25, 1.4171108507276d-38/
      data (pmn(lat, 0,29), lat = 1,36)/
     |   3.4045448560958d+00,-2.1896864489365d+00, 1.3616636737190d+00,
     |  -5.0880415590333d-01,-2.6437315051921d-01, 8.1854973968556d-01,
     |  -1.0587459050749d+00, 9.6634114880734d-01,-6.0400531737222d-01,
     |   9.7566632296617d-02, 3.9876034912570d-01,-7.4389500471436d-01,
     |   8.4685820799854d-01,-6.8933822491974d-01, 3.2802573048829d-01,
     |   1.2358142231188d-01,-5.2864392549189d-01, 7.6635993221764d-01,
     |  -7.6635993221764d-01, 5.2864392549189d-01,-1.2358142231187d-01,
     |  -3.2802573048830d-01, 6.8933822491974d-01,-8.4685820799854d-01,
     |   7.4389500471435d-01,-3.9876034912570d-01,-9.7566632296620d-02,
     |   6.0400531737223d-01,-9.6634114880734d-01, 1.0587459050749d+00,
     |  -8.1854973968556d-01, 2.6437315051921d-01, 5.0880415590335d-01,
     |  -1.3616636737190d+00, 2.1896864489365d+00,-3.4045448560958d+00/
      data (pmn(lat, 1,29), lat = 1,36)/
     |   2.8201492244083d+00,-6.3889787347166d-02,-9.3821758368385d-01,
     |   1.3369988119548d+00,-1.2739737734084d+00, 8.6859389411063d-01,
     |  -2.7994235057099d-01,-3.1282639745001d-01, 7.4891659804102d-01,
     |  -9.2283520816404d-01, 8.0751055516240d-01,-4.5685124256345d-01,
     |  -1.2882286561986d-02, 4.5765742810216d-01,-7.4667618590394d-01,
     |   7.9863772463519d-01,-6.0347927758659d-01, 2.2385104719673d-01,
     |   2.2385104719673d-01,-6.0347927758659d-01, 7.9863772463520d-01,
     |  -7.4667618590394d-01, 4.5765742810216d-01,-1.2882286561994d-02,
     |  -4.5685124256346d-01, 8.0751055516240d-01,-9.2283520816404d-01,
     |   7.4891659804102d-01,-3.1282639745001d-01,-2.7994235057100d-01,
     |   8.6859389411063d-01,-1.2739737734084d+00, 1.3369988119548d+00,
     |  -9.3821758368383d-01,-6.3889787347166d-02, 2.8201492244083d+00/
      data (pmn(lat, 2,29), lat = 1,36)/
     |   9.7632827352164d-01, 2.1592639702028d+00,-1.6505201548287d+00,
     |   7.9724836191471d-01, 5.5889181607467d-02,-7.0622344504334d-01,
     |   1.0301350835094d+00,-9.9512915011653d-01, 6.6018265035357d-01,
     |  -1.5508357886555d-01,-3.5715662461489d-01, 7.2499402053067d-01,
     |  -8.4828852905402d-01, 7.0300064493701d-01,-3.4438518771502d-01,
     |  -1.1170452555926d-01, 5.2385922468197d-01,-7.6657885570995d-01,
     |   7.6657885570995d-01,-5.2385922468197d-01, 1.1170452555925d-01,
     |   3.4438518771502d-01,-7.0300064493701d-01, 8.4828852905402d-01,
     |  -7.2499402053066d-01, 3.5715662461489d-01, 1.5508357886555d-01,
     |  -6.6018265035358d-01, 9.9512915011653d-01,-1.0301350835094d+00,
     |   7.0622344504334d-01,-5.5889181607467d-02,-7.9724836191472d-01,
     |   1.6505201548287d+00,-2.1592639702028d+00,-9.7632827352164d-01/
      data (pmn(lat, 3,29), lat = 1,36)/
     |   2.1635768115701d-01, 2.2959633260441d+00,-7.2751380151138d-02,
     |  -9.9599823982510d-01, 1.2952808137385d+00,-1.0552178825665d+00,
     |   5.0063383746470d-01, 1.3706701448898d-01,-6.5260561174936d-01,
     |   9.0563049585677d-01,-8.4667192061891d-01, 5.2076038321812d-01,
     |  -4.7180859212526d-02,-4.1908933027714d-01, 7.3362616469292d-01,
     |  -8.0385428229981d-01, 6.1425987828193d-01,-2.2892325218938d-01,
     |  -2.2892325218939d-01, 6.1425987828193d-01,-8.0385428229981d-01,
     |   7.3362616469292d-01,-4.1908933027714d-01,-4.7180859212517d-02,
     |   5.2076038321813d-01,-8.4667192061891d-01, 9.0563049585677d-01,
     |  -6.5260561174936d-01, 1.3706701448898d-01, 5.0063383746472d-01,
     |  -1.0552178825665d+00, 1.2952808137385d+00,-9.9599823982509d-01,
     |  -7.2751380151161d-02, 2.2959633260441d+00, 2.1635768115701d-01/
      data (pmn(lat, 4,29), lat = 1,36)/
     |   3.5312486046742d-02, 1.4054625165021d+00, 1.5890619090034d+00,
     |  -1.4470900761583d+00, 5.8445717124432d-01, 2.9347341880609d-01,
     |  -8.7276233611061d-01, 1.0351923651436d+00,-8.0837038404070d-01,
     |   3.2561008287418d-01, 2.2532617646636d-01,-6.5956775521131d-01,
     |   8.4621845405411d-01,-7.4101250505283d-01, 3.9296828829745d-01,
     |   7.5590444091157d-02,-5.0912280768816d-01, 7.6720718867726d-01,
     |  -7.6720718867726d-01, 5.0912280768816d-01,-7.5590444091148d-02,
     |  -3.9296828829746d-01, 7.4101250505283d-01,-8.4621845405412d-01,
     |   6.5956775521130d-01,-2.2532617646636d-01,-3.2561008287418d-01,
     |   8.0837038404071d-01,-1.0351923651436d+00, 8.7276233611060d-01,
     |  -2.9347341880609d-01,-5.8445717124432d-01, 1.4470900761583d+00,
     |  -1.5890619090034d+00,-1.4054625165021d+00,-3.5312486046742d-02/
      data (pmn(lat, 5,29), lat = 1,36)/
     |   4.5563931134184d-03, 6.2260356328310d-01, 2.0399196776025d+00,
     |  -2.5869697173137d-01,-9.1418555650339d-01, 1.2148656817082d+00,
     |  -8.7889883932796d-01, 2.3247643036698d-01, 4.1360090581361d-01,
     |  -8.2801116691661d-01, 8.9808998277964d-01,-6.3850474077346d-01,
     |   1.6827825882878d-01, 3.3683396082182d-01,-7.0307189288798d-01,
     |   8.1222662352935d-01,-6.3553587975473d-01, 2.3918951317487d-01,
     |   2.3918951317487d-01,-6.3553587975473d-01, 8.1222662352935d-01,
     |  -7.0307189288798d-01, 3.3683396082182d-01, 1.6827825882878d-01,
     |  -6.3850474077347d-01, 8.9808998277964d-01,-8.2801116691661d-01,
     |   4.1360090581360d-01, 2.3247643036698d-01,-8.7889883932797d-01,
     |   1.2148656817082d+00,-9.1418555650339d-01,-2.5869697173138d-01,
     |   2.0399196776025d+00, 6.2260356328310d-01, 4.5563931134184d-03/
      data (pmn(lat, 6,29), lat = 1,36)/
     |   4.8506637011539d-04, 2.1790594006361d-01, 1.5763206429250d+00,
     |   1.1725850481242d+00,-1.3494266495852d+00, 5.1000004809197d-01,
     |   4.0193654036867d-01,-9.3680169470577d-01, 9.6890400581926d-01,
     |  -5.8933006830677d-01, 1.1108548957039d-02, 5.2313233271002d-01,
     |  -8.2101565429771d-01, 7.9354962966716d-01,-4.7178654343973d-01,
     |  -1.3910277476021d-02, 4.8327548125864d-01,-7.6815712702545d-01,
     |   7.6815712702545d-01,-4.8327548125864d-01, 1.3910277476012d-02,
     |   4.7178654343973d-01,-7.9354962966716d-01, 8.2101565429771d-01,
     |  -5.2313233271001d-01,-1.1108548957039d-02, 5.8933006830678d-01,
     |  -9.6890400581927d-01, 9.3680169470577d-01,-4.0193654036866d-01,
     |  -5.1000004809197d-01, 1.3494266495852d+00,-1.1725850481242d+00,
     |  -1.5763206429250d+00,-2.1790594006361d-01,-4.8506637011539d-04/
      data (pmn(lat, 7,29), lat = 1,36)/
     |   4.3834545754782d-05, 6.3150456049212d-02, 9.1056110759606d-01,
     |   1.8114803114276d+00,-4.3781197395440d-01,-8.1507383859022d-01,
     |   1.1483540837618d+00,-7.4329035623541d-01, 2.4367864690365d-02,
     |   6.0878512565280d-01,-9.0101976358363d-01, 7.8209899631212d-01,
     |  -3.4772877294574d-01,-2.0218903985637d-01, 6.4611369823791d-01,
     |  -8.1937719963523d-01, 6.6665786509282d-01,-2.5490304223117d-01,
     |  -2.5490304223117d-01, 6.6665786509282d-01,-8.1937719963523d-01,
     |   6.4611369823791d-01,-2.0218903985637d-01,-3.4772877294573d-01,
     |   7.8209899631212d-01,-9.0101976358363d-01, 6.0878512565279d-01,
     |   2.4367864690372d-02,-7.4329035623541d-01, 1.1483540837618d+00,
     |  -8.1507383859022d-01,-4.3781197395440d-01, 1.8114803114276d+00,
     |   9.1056110759607d-01, 6.3150456049212d-02, 4.3834545754782d-05/
      data (pmn(lat, 8,29), lat = 1,36)/
     |   3.4309267883464d-06, 1.5604730312988d-02, 4.2562072220193d-01,
     |   1.6365824779088d+00, 8.4232588578061d-01,-1.2826764379679d+00,
     |   4.7913494194284d-01, 4.6949488096731d-01,-9.6415147437373d-01,
     |   8.6811267082411d-01,-3.5046208078463d-01,-2.8311969950950d-01,
     |   7.3922131129871d-01,-8.4144050422118d-01, 5.7579117570248d-01,
     |  -7.5106981305317d-02,-4.4434636597536d-01, 7.6927359109576d-01,
     |  -7.6927359109576d-01, 4.4434636597536d-01, 7.5106981305326d-02,
     |  -5.7579117570248d-01, 8.4144050422118d-01,-7.3922131129872d-01,
     |   2.8311969950949d-01, 3.5046208078463d-01,-8.6811267082411d-01,
     |   9.6415147437373d-01,-4.6949488096731d-01,-4.7913494194285d-01,
     |   1.2826764379679d+00,-8.4232588578061d-01,-1.6365824779088d+00,
     |  -4.2562072220194d-01,-1.5604730312988d-02,-3.4309267883464d-06/
      data (pmn(lat, 9,29), lat = 1,36)/
     |   2.3606789956787d-07, 3.3540898259872d-03, 1.6774758910674d-01,
     |   1.1103602623874d+00, 1.5939721110588d+00,-5.7238917685783d-01,
     |  -7.3382942835060d-01, 1.0972573188303d+00,-6.2056302864238d-01,
     |  -1.6430369224912d-01, 7.5769363657187d-01,-8.9205951682849d-01,
     |   5.6915390793629d-01, 6.7972486002329d-03,-5.4973219496962d-01,
     |   8.1811982014987d-01,-7.0644163284695d-01, 2.7646936863158d-01,
     |   2.7646936863158d-01,-7.0644163284695d-01, 8.1811982014987d-01,
     |  -5.4973219496962d-01, 6.7972486002308d-03, 5.6915390793628d-01,
     |  -8.9205951682850d-01, 7.5769363657187d-01,-1.6430369224912d-01,
     |  -6.2056302864239d-01, 1.0972573188303d+00,-7.3382942835060d-01,
     |  -5.7238917685783d-01, 1.5939721110588d+00, 1.1103602623874d+00,
     |   1.6774758910674d-01, 3.3540898259872d-03, 2.3606789956787d-07/
      data (pmn(lat,10,29), lat = 1,36)/
     |   1.4440543455729d-08, 6.3615275280431d-04, 5.7166519665195d-02,
     |   6.1433298283641d-01, 1.6281813035641d+00, 5.8872883851645d-01,
     |  -1.2270233980153d+00, 4.4674158236744d-01, 5.3873858472975d-01,
     |  -9.7510645974453d-01, 7.2919628990755d-01,-7.9906399354829d-02,
     |  -5.5674688976246d-01, 8.5290866457361d-01,-6.9410873124111d-01,
     |   1.9286403971698d-01, 3.8950228458336d-01,-7.7031945377062d-01,
     |   7.7031945377062d-01,-3.8950228458336d-01,-1.9286403971699d-01,
     |   6.9410873124111d-01,-8.5290866457361d-01, 5.5674688976247d-01,
     |   7.9906399354841d-02,-7.2919628990755d-01, 9.7510645974453d-01,
     |  -5.3873858472974d-01,-4.4674158236744d-01, 1.2270233980153d+00,
     |  -5.8872883851645d-01,-1.6281813035641d+00,-6.1433298283641d-01,
     |  -5.7166519665196d-02,-6.3615275280431d-04,-1.4440543455729d-08/
      data (pmn(lat,11,29), lat = 1,36)/
     |   7.9217659643988d-10, 1.0760868976719d-04, 1.7131937573838d-02,
     |   2.8865363039280d-01, 1.2368764051407d+00, 1.4003400579526d+00,
     |  -6.5387457487528d-01,-6.8922528557105d-01, 1.0552045577857d+00,
     |  -4.8177631922881d-01,-3.6167137700872d-01, 8.6678983326565d-01,
     |  -7.8685463541340d-01, 2.4941474120273d-01, 3.9814687295016d-01,
     |  -7.9779551485264d-01, 7.5287821527961d-01,-3.0448335178792d-01,
     |  -3.0448335178792d-01, 7.5287821527961d-01,-7.9779551485264d-01,
     |   3.9814687295016d-01, 2.4941474120273d-01,-7.8685463541340d-01,
     |   8.6678983326565d-01,-3.6167137700872d-01,-4.8177631922881d-01,
     |   1.0552045577857d+00,-6.8922528557104d-01,-6.5387457487529d-01,
     |   1.4003400579526d+00, 1.2368764051407d+00, 2.8865363039280d-01,
     |   1.7131937573838d-02, 1.0760868976719d-04, 7.9217659643988d-10/
      data (pmn(lat,12,29), lat = 1,36)/
     |   3.9235762836076d-11, 1.6365957175979d-05, 4.5691299695945d-03,
     |   1.1797179853603d-01, 7.6595242062704d-01, 1.5810292706955d+00,
     |   4.1398555435883d-01,-1.1807546694509d+00, 3.8585451276167d-01,
     |   6.3202036403740d-01,-9.6472977511705d-01, 5.2828233303018d-01,
     |   2.3326890818773d-01,-7.8186359449650d-01, 8.0604089307971d-01,
     |  -3.3895001618800d-01,-3.1499615185519d-01, 7.7095094341345d-01,
     |  -7.7095094341345d-01, 3.1499615185518d-01, 3.3895001618801d-01,
     |  -8.0604089307971d-01, 7.8186359449650d-01,-2.3326890818773d-01,
     |  -5.2828233303019d-01, 9.6472977511705d-01,-6.3202036403739d-01,
     |  -3.8585451276168d-01, 1.1807546694509d+00,-4.1398555435882d-01,
     |  -1.5810292706955d+00,-7.6595242062704d-01,-1.1797179853603d-01,
     |  -4.5691299695946d-03,-1.6365957175979d-05,-3.9235762836076d-11/
      data (pmn(lat,13,29), lat = 1,36)/
     |   1.7637427834356d-12, 2.2517490151659d-06, 1.0939592643317d-03,
     |   4.2596081256265d-02, 4.0339276437239d-01, 1.3042000161408d+00,
     |   1.2484333156408d+00,-6.8139277779729d-01,-6.9458229367552d-01,
     |   1.0099769183151d+00,-2.9718804056599d-01,-5.7895305083352d-01,
     |   9.0903736044620d-01,-5.4445433817333d-01,-1.7651696126181d-01,
     |   7.4360090849679d-01,-8.0267449476090d-01, 3.3979147583479d-01,
     |   3.3979147583479d-01,-8.0267449476090d-01, 7.4360090849679d-01,
     |  -1.7651696126181d-01,-5.4445433817333d-01, 9.0903736044620d-01,
     |  -5.7895305083351d-01,-2.9718804056599d-01, 1.0099769183151d+00,
     |  -6.9458229367552d-01,-6.8139277779729d-01, 1.2484333156408d+00,
     |   1.3042000161408d+00, 4.0339276437239d-01, 4.2596081256266d-02,
     |   1.0939592643318d-03, 2.2517490151659d-06, 1.7637427834356d-12/
      data (pmn(lat,14,29), lat = 1,36)/
     |   7.2246420488678d-14, 2.8158526997410d-07, 2.3664368704286d-04,
     |   1.3733905645261d-02, 1.8505466775024d-01, 8.7277353134175d-01,
     |   1.5207472242632d+00, 3.2262851546444d-01,-1.1444417449528d+00,
     |   2.7351497765263d-01, 7.5674670792087d-01,-9.0377489361133d-01,
     |   2.3143413787205d-01, 5.7295520848748d-01,-8.7629816171411d-01,
     |   5.0870356614327d-01, 2.1614444832246d-01,-7.7067757646124d-01,
     |   7.7067757646124d-01,-2.1614444832246d-01,-5.0870356614327d-01,
     |   8.7629816171411d-01,-5.7295520848748d-01,-2.3143413787204d-01,
     |   9.0377489361133d-01,-7.5674670792087d-01,-2.7351497765263d-01,
     |   1.1444417449528d+00,-3.2262851546444d-01,-1.5207472242632d+00,
     |  -8.7277353134175d-01,-1.8505466775024d-01,-1.3733905645261d-02,
     |  -2.3664368704286d-04,-2.8158526997410d-07,-7.2246420488678d-14/
      data (pmn(lat,15,29), lat = 1,36)/
     |   2.7046082561460d-15, 3.2114882630361d-08, 4.6467701476250d-05,
     |   3.9839686753458d-03, 7.5063984115323d-02, 4.9572711641801d-01,
     |   1.3270511249010d+00, 1.1539526244322d+00,-6.5205395390488d-01,
     |  -7.5801655110783d-01, 9.3630029253352d-01,-3.6422495203439d-02,
     |  -7.9681199545992d-01, 8.1454446943452d-01,-1.2091195965050d-01,
     |  -6.3629508624090d-01, 8.5053817689871d-01,-3.8359776928098d-01,
     |  -3.8359776928099d-01, 8.5053817689871d-01,-6.3629508624090d-01,
     |  -1.2091195965050d-01, 8.1454446943452d-01,-7.9681199545992d-01,
     |  -3.6422495203450d-02, 9.3630029253352d-01,-7.5801655110782d-01,
     |  -6.5205395390488d-01, 1.1539526244322d+00, 1.3270511249010d+00,
     |   4.9572711641801d-01, 7.5063984115323d-02, 3.9839686753459d-03,
     |   4.6467701476252d-05, 3.2114882630361d-08, 2.7046082561460d-15/
      data (pmn(lat,16,29), lat = 1,36)/
     |   9.2720005483622d-17, 3.3484722916172d-09, 8.3100774725227d-06,
     |   1.0452515565644d-03, 2.7190421406794d-02, 2.4488361352324d-01,
     |   9.3319014513108d-01, 1.4672360884649d+00, 3.2085832661328d-01,
     |  -1.1101503599920d+00, 8.4155232298749d-02, 8.9730938272648d-01,
     |  -7.3265413197054d-01,-1.8317375766639d-01, 8.5135359166562d-01,
     |  -6.8927750130675d-01,-8.7394604361233d-02, 7.6879567185805d-01,
     |  -7.6879567185804d-01, 8.7394604361230d-02, 6.8927750130675d-01,
     |  -8.5135359166562d-01, 1.8317375766639d-01, 7.3265413197054d-01,
     |  -8.9730938272647d-01,-8.4155232298749d-02, 1.1101503599920d+00,
     |  -3.2085832661328d-01,-1.4672360884649d+00,-9.3319014513109d-01,
     |  -2.4488361352324d-01,-2.7190421406794d-02,-1.0452515565644d-03,
     |  -8.3100774725229d-06,-3.3484722916172d-09,-9.2720005483622d-17/
      data (pmn(lat,17,29), lat = 1,36)/
     |   2.9142054092175d-18, 3.1963445040858d-10, 1.3563705378556d-06,
     |   2.4890943034642d-04, 8.8533615264707d-03, 1.0675919885259d-01,
     |   5.5472901442021d-01, 1.3177568408838d+00, 1.1274782997657d+00,
     |  -5.5313676724488d-01,-8.7652451433254d-01, 7.8543138290653d-01,
     |   3.1876792593586d-01,-9.3534005242893d-01, 4.7536730158043d-01,
     |   4.5313526936125d-01,-8.8805461579487d-01, 4.3765166197125d-01,
     |   4.3765166197125d-01,-8.8805461579487d-01, 4.5313526936124d-01,
     |   4.7536730158043d-01,-9.3534005242893d-01, 3.1876792593586d-01,
     |   7.8543138290654d-01,-8.7652451433254d-01,-5.5313676724488d-01,
     |   1.1274782997657d+00, 1.3177568408838d+00, 5.5472901442021d-01,
     |   1.0675919885259d-01, 8.8533615264707d-03, 2.4890943034642d-04,
     |   1.3563705378557d-06, 3.1963445040858d-10, 2.9142054092175d-18/
      data (pmn(lat,18,29), lat = 1,36)/
     |   8.3998237017679d-20, 2.7948036671501d-11, 2.0226709785235d-07,
     |   5.3911755722014d-05, 2.6021304182042d-03, 4.1451227889837d-02,
     |   2.8571000904517d-01, 9.4782149264472d-01, 1.4311624208054d+00,
     |   4.1747744178332d-01,-1.0495607350606d+00,-2.0759419730792d-01,
     |   9.9198401392708d-01,-3.6605396767291d-01,-6.6205859823202d-01,
     |   8.5357063250695d-01,-7.7391473248909d-02,-7.6427296678173d-01,
     |   7.6427296678173d-01, 7.7391473248911d-02,-8.5357063250696d-01,
     |   6.6205859823202d-01, 3.6605396767291d-01,-9.9198401392709d-01,
     |   2.0759419730791d-01, 1.0495607350606d+00,-4.1747744178332d-01,
     |  -1.4311624208054d+00,-9.4782149264472d-01,-2.8571000904518d-01,
     |  -4.1451227889837d-02,-2.6021304182042d-03,-5.3911755722015d-05,
     |  -2.0226709785236d-07,-2.7948036671501d-11,-8.3998237017679d-20/
      data (pmn(lat,19,29), lat = 1,36)/
     |   2.2190329400039d-21, 2.2374770239725d-12, 2.7557778153849d-08,
     |   1.0628891971989d-05, 6.9195262930210d-04, 1.4412931374245d-02,
     |   1.2929668074192d-01, 5.7328601110123d-01, 1.2816512562526d+00,
     |   1.1710196860403d+00,-3.5583745154520d-01,-1.0189651724977d+00,
     |   4.7957837714798d-01, 7.2915093299808d-01,-8.1834836434719d-01,
     |  -1.7185870884423d-01, 9.0186728599369d-01,-5.0460459016374d-01,
     |  -5.0460459016374d-01, 9.0186728599369d-01,-1.7185870884422d-01,
     |  -8.1834836434719d-01, 7.2915093299808d-01, 4.7957837714797d-01,
     |  -1.0189651724977d+00,-3.5583745154520d-01, 1.1710196860403d+00,
     |   1.2816512562526d+00, 5.7328601110123d-01, 1.2929668074193d-01,
     |   1.4412931374245d-02, 6.9195262930210d-04, 1.0628891971989d-05,
     |   2.7557778153851d-08, 2.2374770239725d-12, 2.2190329400039d-21/
      data (pmn(lat,20,29), lat = 1,36)/
     |   5.3643463895634d-23, 1.6377759620640d-13, 3.4265492998981d-09,
     |   1.9065205651721d-06, 1.6658016927724d-04, 4.5007647156009d-03,
     |   5.1824262120982d-02, 2.9866869990134d-01, 9.1543935255306d-01,
     |   1.4086902877573d+00, 6.2077361482341d-01,-8.9888375061052d-01,
     |  -6.0116048485640d-01, 8.9845727587948d-01, 2.4430975409816d-01,
     |  -9.5145552723556d-01, 2.8416126457231d-01, 7.5553401153569d-01,
     |  -7.5553401153569d-01,-2.8416126457231d-01, 9.5145552723556d-01,
     |  -2.4430975409816d-01,-8.9845727587948d-01, 6.0116048485640d-01,
     |   8.9888375061052d-01,-6.2077361482341d-01,-1.4086902877573d+00,
     |  -9.1543935255307d-01,-2.9866869990134d-01,-5.1824262120982d-02,
     |  -4.5007647156009d-03,-1.6658016927724d-04,-1.9065205651721d-06,
     |  -3.4265492998983d-09,-1.6377759620640d-13,-5.3643463895634d-23/
      data (pmn(lat,21,29), lat = 1,36)/
   