




      module mo_nln_matrix

      use shr_kind_mod, only : r8 => shr_kind_r8

      private
      public :: nlnmat

      contains

      subroutine nlnmat01( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(936) = -(rxt(45)*y(2) + rxt(48)*y(3) + rxt(58)*y(15) + rxt(63)*y(12) &
                      + rxt(71)*y(13) + rxt(78)*y(5) + rxt(81)*y(6) + rxt(117)*y(23) &
                      + rxt(138)*y(35) + rxt(160)*y(55) + rxt(166)*y(56) + rxt(184) &
                      *y(52) + rxt(216)*y(65))
         mat(492) = -rxt(45)*y(1)
         mat(410) = -rxt(48)*y(1)
         mat(371) = -rxt(58)*y(1)
         mat(800) = -rxt(63)*y(1)
         mat(858) = -rxt(71)*y(1)
         mat(680) = -rxt(78)*y(1)
         mat(702) = -rxt(81)*y(1)
         mat(135) = -rxt(117)*y(1)
         mat(399) = -rxt(138)*y(1)
         mat(524) = -rxt(160)*y(1)
         mat(469) = -rxt(166)*y(1)
         mat(364) = -rxt(184)*y(1)
         mat(261) = -rxt(216)*y(1)

         mat(936) = mat(936) + .100_r8*rxt(184)*y(52) + .200_r8*rxt(160)*y(55) &
                      + .200_r8*rxt(166)*y(56)
         mat(858) = mat(858) + .250_r8*rxt(128)*y(33) + .250_r8*rxt(176)*y(59)
         mat(603) = .250_r8*rxt(128)*y(13)
         mat(364) = mat(364) + .100_r8*rxt(184)*y(1)
         mat(524) = mat(524) + .200_r8*rxt(160)*y(1)
         mat(469) = mat(469) + .200_r8*rxt(166)*y(1)
         mat(579) = .250_r8*rxt(176)*y(13)

         mat(483) = -(rxt(45)*y(1) + rxt(62)*y(12) + rxt(69)*y(11) + rxt(70)*y(13) &
                      + rxt(73)*y(14) + rxt(76)*y(5) + (rxt(79) + rxt(80)) * y(6) &
                      + rxt(87)*y(7) + rxt(98)*y(20) + rxt(231)*y(80))
         mat(921) = -rxt(45)*y(2)
         mat(785) = -rxt(62)*y(2)
         mat(265) = -rxt(69)*y(2)
         mat(843) = -rxt(70)*y(2)
         mat(89) = -rxt(73)*y(2)
         mat(665) = -rxt(76)*y(2)
         mat(691) = -(rxt(79) + rxt(80)) * y(2)
         mat(623) = -rxt(87)*y(2)
         mat(708) = -rxt(98)*y(2)
         mat(71) = -rxt(231)*y(2)

         mat(368) = rxt(61)*y(13)
         mat(785) = mat(785) + 2.000_r8*rxt(65)*y(12)
         mat(843) = mat(843) + rxt(61)*y(15)

         mat(403) = -(rxt(48)*y(1) + rxt(50)*y(11) + rxt(56)*y(87))
         mat(914) = -rxt(48)*y(3)
         mat(264) = -rxt(50)*y(3)
         mat(62) = -rxt(56)*y(3)

         mat(868) = -((rxt(94) + rxt(95)) * y(12))
         mat(798) = -(rxt(94) + rxt(95)) * y(17)

         mat(934) = .500_r8*rxt(117)*y(23) + .560_r8*rxt(138)*y(35) + .300_r8*rxt(184) &
                      *y(52) + .050_r8*rxt(160)*y(55) + .200_r8*rxt(166)*y(56)
         mat(490) = rxt(98)*y(20) + rxt(231)*y(80)
         mat(678) = .220_r8*rxt(167)*y(57) + .500_r8*rxt(202)*y(63)
         mat(636) = rxt(96)*y(20) + .220_r8*rxt(169)*y(57) + rxt(155)*y(62) &
                      + .500_r8*rxt(203)*y(63)
         mat(798) = mat(798) + rxt(97)*y(20) + rxt(154)*y(62) + rxt(133)*y(74) &
                      + rxt(232)*y(80) + .350_r8*rxt(110)*y(89)
         mat(901) = .110_r8*rxt(171)*y(57) + .200_r8*rxt(205)*y(63)
         mat(715) = rxt(98)*y(2) + rxt(96)*y(7) + rxt(97)*y(12)
         mat(134) = .500_r8*rxt(117)*y(1)
         mat(601) = .220_r8*rxt(172)*y(57) + .500_r8*rxt(206)*y(63)
         mat(397) = .560_r8*rxt(138)*y(1)
         mat(362) = .300_r8*rxt(184)*y(1)
         mat(522) = .050_r8*rxt(160)*y(1)
         mat(468) = .200_r8*rxt(166)*y(1)
         mat(541) = .220_r8*rxt(167)*y(5) + .220_r8*rxt(169)*y(7) + .110_r8*rxt(171) &
                      *y(18) + .220_r8*rxt(172)*y(33)
         mat(477) = rxt(155)*y(7) + rxt(154)*y(12)
         mat(507) = .500_r8*rxt(202)*y(5) + .500_r8*rxt(203)*y(7) + .200_r8*rxt(205) &
                      *y(18) + .500_r8*rxt(206)*y(33)
         mat(270) = rxt(133)*y(12)
         mat(73) = rxt(231)*y(2) + rxt(232)*y(12)
         mat(56) = .350_r8*rxt(110)*y(12)

         mat(262) = -(rxt(50)*y(3) + rxt(67)*y(12) + rxt(69)*y(2))
         mat(401) = -rxt(50)*y(11)
         mat(763) = -rxt(67)*y(11)
         mat(480) = -rxt(69)*y(11)

         mat(365) = rxt(60)*y(13)
         mat(823) = rxt(60)*y(15)

         mat(61) = -(rxt(56)*y(3) + rxt(74)*y(12))
         mat(400) = -rxt(56)*y(87)
         mat(730) = -rxt(74)*y(87)

         mat(34) = -(rxt(75)*y(12))
         mat(724) = -rxt(75)*y(88)

         mat(366) = -(rxt(58)*y(1) + (rxt(59) + rxt(60) + rxt(61)) * y(13))
         mat(911) = -rxt(58)*y(15)
         mat(833) = -(rxt(59) + rxt(60) + rxt(61)) * y(15)

         mat(481) = rxt(69)*y(11) + rxt(62)*y(12)
         mat(402) = rxt(50)*y(11)
         mat(859) = rxt(94)*y(12)
         mat(263) = rxt(69)*y(2) + rxt(50)*y(3) + rxt(67)*y(12)
         mat(774) = rxt(62)*y(2) + rxt(94)*y(17) + rxt(67)*y(11) + rxt(97)*y(20) &
                      + rxt(232)*y(80)
         mat(706) = rxt(97)*y(12)
         mat(70) = rxt(232)*y(12)

         mat(673) = -(rxt(76)*y(2) + rxt(77)*y(13) + rxt(78)*y(1) + rxt(86)*y(7) &
                      + rxt(100)*y(18) + rxt(108)*y(91) + rxt(113)*y(25) + rxt(119) &
                      *y(30) + rxt(126)*y(33) + rxt(140)*y(37) + rxt(145)*y(39) &
                      + rxt(149)*y(42) + rxt(158)*y(45) + rxt(162)*y(47) + (rxt(167) &
                      + rxt(168)) * y(57) + rxt(174)*y(59) + rxt(186)*y(53) + rxt(192) &
                      *y(78) + rxt(199)*y(50) + rxt(202)*y(63) + rxt(210)*y(70) &
                      + rxt(218)*y(66))
         mat(485) = -rxt(76)*y(5)
         mat(851) = -rxt(77)*y(5)
         mat(929) = -rxt(78)*y(5)
         mat(631) = -rxt(86)*y(5)
         mat(896) = -rxt(100)*y(5)
         mat(166) = -rxt(108)*y(5)
         mat(248) = -rxt(113)*y(5)
         mat(326) = -rxt(119)*y(5)
         mat(596) = -rxt(126)*y(5)
         mat(338) = -rxt(140)*y(5)
         mat(299) = -rxt(145)*y(5)
         mat(448) = -rxt(149)*y(5)
         mat(106) = -rxt(158)*y(5)
         mat(286) = -rxt(162)*y(5)
         mat(536) = -(rxt(167) + rxt(168)) * y(5)
         mat(572) = -rxt(174)*y(5)
         mat(556) = -rxt(186)*y(5)
         mat(436) = -rxt(192)*y(5)
         mat(315) = -rxt(199)*y(5)
         mat(502) = -rxt(202)*y(5)
         mat(222) = -rxt(210)*y(5)
         mat(379) = -rxt(218)*y(5)

         mat(485) = mat(485) + rxt(79)*y(6)
         mat(695) = rxt(79)*y(2)

         mat(696) = -((rxt(79) + rxt(80)) * y(2) + rxt(81)*y(1) + rxt(82)*y(7) + rxt(84) &
                      *y(12) + rxt(90)*y(13) + rxt(127)*y(33) + rxt(180)*y(59) + rxt(214) &
                      *y(72))
         mat(486) = -(rxt(79) + rxt(80)) * y(6)
         mat(930) = -rxt(81)*y(6)
         mat(632) = -rxt(82)*y(6)
         mat(794) = -rxt(84)*y(6)
         mat(852) = -rxt(90)*y(6)
         mat(597) = -rxt(127)*y(6)
         mat(573) = -rxt(180)*y(6)
         mat(59) = -rxt(214)*y(6)

         mat(930) = mat(930) + rxt(78)*y(5)
         mat(486) = mat(486) + rxt(76)*y(5) + rxt(87)*y(7)
         mat(674) = rxt(78)*y(1) + rxt(76)*y(2) + 2.000_r8*rxt(86)*y(7) + rxt(77) &
                      *y(13) + rxt(100)*y(18) + rxt(113)*y(25) + rxt(119)*y(30) &
                      + rxt(126)*y(33) + rxt(140)*y(37) + rxt(145)*y(39) + rxt(149) &
                      *y(42) + rxt(158)*y(45) + .900_r8*rxt(199)*y(50) + rxt(162) &
                      *y(47) + .920_r8*rxt(186)*y(53) + rxt(167)*y(57) + rxt(174) &
                      *y(59) + rxt(202)*y(63) + rxt(218)*y(66) + .900_r8*rxt(210) &
                      *y(70) + 1.206_r8*rxt(192)*y(78) + rxt(108)*y(91)
         mat(696) = mat(696) + .700_r8*rxt(214)*y(72)
         mat(632) = mat(632) + rxt(87)*y(2) + 2.000_r8*rxt(86)*y(5) + rxt(88)*y(12) &
                      + rxt(89)*y(13) + rxt(187)*y(53) + rxt(169)*y(57) + rxt(175) &
                      *y(59) + rxt(203)*y(63) + rxt(217)*y(65) + 1.206_r8*rxt(193) &
                      *y(78) + rxt(197)*y(79)
         mat(138) = rxt(91)*y(12)
         mat(794) = mat(794) + rxt(88)*y(7) + rxt(91)*y(9) + rxt(156)*y(76) &
                      + .400_r8*rxt(196)*y(79)
         mat(852) = mat(852) + rxt(77)*y(5) + rxt(89)*y(7) + .206_r8*rxt(194)*y(78)
         mat(897) = rxt(100)*y(5)
         mat(249) = rxt(113)*y(5)
         mat(327) = rxt(119)*y(5)
         mat(597) = mat(597) + rxt(126)*y(5)
         mat(339) = rxt(140)*y(5)
         mat(300) = rxt(145)*y(5)
         mat(449) = rxt(149)*y(5)
         mat(107) = rxt(158)*y(5)
         mat(316) = .900_r8*rxt(199)*y(5)
         mat(287) = rxt(162)*y(5)
         mat(557) = .920_r8*rxt(186)*y(5) + rxt(187)*y(7)
         mat(537) = rxt(167)*y(5) + rxt(169)*y(7)
         mat(573) = mat(573) + rxt(174)*y(5) + rxt(175)*y(7)
         mat(503) = rxt(202)*y(5) + rxt(203)*y(7)
         mat(258) = rxt(217)*y(7)
         mat(380) = rxt(218)*y(5)
         mat(223) = .900_r8*rxt(210)*y(5)
         mat(59) = mat(59) + .700_r8*rxt(214)*y(6)
         mat(162) = rxt(156)*y(12)
         mat(437) = 1.206_r8*rxt(192)*y(5) + 1.206_r8*rxt(193)*y(7) + .206_r8*rxt(194) &
                      *y(13)
         mat(424) = rxt(197)*y(7) + .400_r8*rxt(196)*y(12)
         mat(167) = rxt(108)*y(5)

         mat(630) = -(rxt(82)*y(6) + rxt(86)*y(5) + rxt(87)*y(2) + rxt(88)*y(12) &
                      + rxt(89)*y(13) + rxt(96)*y(20) + rxt(125)*y(32) + rxt(139) &
                      *y(35) + rxt(155)*y(62) + rxt(169)*y(57) + rxt(175)*y(59) &
                      + rxt(185)*y(52) + rxt(187)*y(53) + rxt(193)*y(78) + rxt(197) &
                      *y(79) + rxt(203)*y(63) + rxt(217)*y(65) + rxt(228)*y(82))
         mat(694) = -rxt(82)*y(7)
         mat(672) = -rxt(86)*y(7)
         mat(484) = -rxt(87)*y(7)
         mat(792) = -rxt(88)*y(7)
         mat(850) = -rxt(89)*y(7)
         mat(709) = -rxt(96)*y(7)
         mat(414) = -rxt(125)*y(7)
         mat(391) = -rxt(139)*y(7)
         mat(473) = -rxt(155)*y(7)
         mat(535) = -rxt(169)*y(7)
         mat(571) = -rxt(175)*y(7)
         mat(358) = -rxt(185)*y(7)
         mat(555) = -rxt(187)*y(7)
         mat(435) = -rxt(193)*y(7)
         mat(423) = -rxt(197)*y(7)
         mat(501) = -rxt(203)*y(7)
         mat(257) = -rxt(217)*y(7)
         mat(77) = -rxt(228)*y(7)

         mat(928) = rxt(81)*y(6)
         mat(484) = mat(484) + rxt(80)*y(6)
         mat(694) = mat(694) + rxt(81)*y(1) + rxt(80)*y(2)
         mat(206) = rxt(85)*y(12)
         mat(792) = mat(792) + rxt(85)*y(8) + rxt(136)*y(75) + .500_r8*rxt(182)*y(77)
         mat(200) = rxt(136)*y(12)
         mat(235) = .500_r8*rxt(182)*y(12)


      end subroutine nlnmat01

      subroutine nlnmat02( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(205) = -(rxt(85)*y(12))
         mat(755) = -rxt(85)*y(8)

         mat(685) = rxt(84)*y(12)
         mat(609) = rxt(96)*y(20) + rxt(125)*y(32) + rxt(155)*y(62) + rxt(228)*y(82)
         mat(755) = mat(755) + rxt(84)*y(6)
         mat(704) = rxt(96)*y(7)
         mat(411) = rxt(125)*y(7)
         mat(470) = rxt(155)*y(7)
         mat(76) = rxt(228)*y(7)

         mat(136) = -(rxt(91)*y(12))
         mat(743) = -rxt(91)*y(9)

         mat(683) = rxt(90)*y(13)
         mat(810) = rxt(90)*y(6)


         mat(682) = rxt(82)*y(7)
         mat(606) = rxt(82)*y(6)

         mat(796) = -(rxt(62)*y(2) + rxt(63)*y(1) + rxt(64)*y(13) + (4._r8*rxt(65) &
                      + 4._r8*rxt(66)) * y(12) + rxt(67)*y(11) + rxt(68)*y(14) + rxt(74) &
                      *y(87) + rxt(75)*y(88) + rxt(84)*y(6) + rxt(85)*y(8) + rxt(88) &
                      *y(7) + rxt(91)*y(9) + (rxt(94) + rxt(95)) * y(17) + rxt(97) &
                      *y(20) + rxt(104)*y(21) + rxt(105)*y(19) + rxt(106)*y(90) &
                      + rxt(110)*y(89) + rxt(111)*y(29) + rxt(112)*y(23) + rxt(118) &
                      *y(26) + rxt(123)*y(31) + rxt(124)*y(32) + rxt(131)*y(34) &
                      + rxt(132)*y(27) + rxt(133)*y(74) + rxt(134)*y(22) + rxt(136) &
                      *y(75) + rxt(137)*y(35) + rxt(143)*y(38) + rxt(144)*y(36) &
                      + rxt(147)*y(40) + rxt(148)*y(41) + rxt(152)*y(43) + rxt(153) &
                      *y(61) + rxt(154)*y(62) + rxt(156)*y(76) + rxt(157)*y(44) &
                      + rxt(159)*y(55) + rxt(161)*y(46) + rxt(164)*y(48) + rxt(165) &
                      *y(56) + rxt(173)*y(58) + rxt(182)*y(77) + rxt(183)*y(52) &
                      + rxt(189)*y(54) + rxt(195)*y(49) + rxt(196)*y(79) + rxt(198) &
                      *y(60) + rxt(201)*y(51) + rxt(207)*y(64) + rxt(209)*y(68) &
                      + rxt(212)*y(71) + rxt(213)*y(69) + rxt(215)*y(65) + rxt(220) &
                      *y(67) + rxt(225)*y(81) + (rxt(226) + rxt(227)) * y(82) + rxt(229) &
                      *y(83) + rxt(232)*y(80))
         mat(488) = -rxt(62)*y(12)
         mat(932) = -rxt(63)*y(12)
         mat(854) = -rxt(64)*y(12)
         mat(266) = -rxt(67)*y(12)
         mat(90) = -rxt(68)*y(12)
         mat(63) = -rxt(74)*y(12)
         mat(35) = -rxt(75)*y(12)
         mat(698) = -rxt(84)*y(12)
         mat(208) = -rxt(85)*y(12)
         mat(634) = -rxt(88)*y(12)
         mat(139) = -rxt(91)*y(12)
         mat(866) = -(rxt(94) + rxt(95)) * y(12)
         mat(713) = -rxt(97)*y(12)
         mat(242) = -rxt(104)*y(12)
         mat(149) = -rxt(105)*y(12)
         mat(126) = -rxt(106)*y(12)
         mat(54) = -rxt(110)*y(12)
         mat(24) = -rxt(111)*y(12)
         mat(132) = -rxt(112)*y(12)
         mat(172) = -rxt(118)*y(12)
         mat(123) = -rxt(123)*y(12)
         mat(416) = -rxt(124)*y(12)
         mat(177) = -rxt(131)*y(12)
         mat(347) = -rxt(132)*y(12)
         mat(268) = -rxt(133)*y(12)
         mat(82) = -rxt(134)*y(12)
         mat(203) = -rxt(136)*y(12)
         mat(395) = -rxt(137)*y(12)
         mat(144) = -rxt(143)*y(12)
         mat(27) = -rxt(144)*y(12)
         mat(189) = -rxt(147)*y(12)
         mat(293) = -rxt(148)*y(12)
         mat(102) = -rxt(152)*y(12)
         mat(458) = -rxt(153)*y(12)
         mat(475) = -rxt(154)*y(12)
         mat(163) = -rxt(156)*y(12)
         mat(30) = -rxt(157)*y(12)
         mat(520) = -rxt(159)*y(12)
         mat(183) = -rxt(161)*y(12)
         mat(114) = -rxt(164)*y(12)
         mat(466) = -rxt(165)*y(12)
         mat(118) = -rxt(173)*y(12)
         mat(238) = -rxt(182)*y(12)
         mat(360) = -rxt(183)*y(12)
         mat(215) = -rxt(189)*y(12)
         mat(33) = -rxt(195)*y(12)
         mat(426) = -rxt(196)*y(12)
         mat(153) = -rxt(198)*y(12)
         mat(280) = -rxt(201)*y(12)
         mat(67) = -rxt(207)*y(12)
         mat(43) = -rxt(209)*y(12)
         mat(159) = -rxt(212)*y(12)
         mat(47) = -rxt(213)*y(12)
         mat(259) = -rxt(215)*y(12)
         mat(196) = -rxt(220)*y(12)
         mat(50) = -rxt(225)*y(12)
         mat(78) = -(rxt(226) + rxt(227)) * y(12)
         mat(21) = -rxt(229)*y(12)
         mat(72) = -rxt(232)*y(12)

         mat(932) = mat(932) + rxt(58)*y(15) + rxt(71)*y(13) + .120_r8*rxt(117)*y(23) &
                      + .330_r8*rxt(138)*y(35) + .270_r8*rxt(184)*y(52) &
                      + .080_r8*rxt(160)*y(55) + .215_r8*rxt(166)*y(56) &
                      + .700_r8*rxt(216)*y(65)
         mat(488) = mat(488) + rxt(69)*y(11) + rxt(70)*y(13) + rxt(73)*y(14) + rxt(98) &
                      *y(20)
         mat(407) = rxt(50)*y(11) + rxt(56)*y(87)
         mat(266) = mat(266) + rxt(69)*y(2) + rxt(50)*y(3)
         mat(63) = mat(63) + rxt(56)*y(3)
         mat(369) = rxt(58)*y(1) + 2.000_r8*rxt(59)*y(13)
         mat(676) = rxt(77)*y(13)
         mat(634) = mat(634) + rxt(89)*y(13)
         mat(796) = mat(796) + .300_r8*rxt(105)*y(19) + .500_r8*rxt(123)*y(31) &
                      + .500_r8*rxt(147)*y(40) + .100_r8*rxt(173)*y(58) &
                      + .650_r8*rxt(110)*y(89)
         mat(854) = mat(854) + rxt(71)*y(1) + rxt(70)*y(2) + 2.000_r8*rxt(59)*y(15) &
                      + rxt(77)*y(5) + rxt(89)*y(7)
         mat(90) = mat(90) + rxt(73)*y(2)
         mat(149) = mat(149) + .300_r8*rxt(105)*y(12)
         mat(713) = mat(713) + rxt(98)*y(2)
         mat(132) = mat(132) + .120_r8*rxt(117)*y(1)
         mat(123) = mat(123) + .500_r8*rxt(123)*y(12)
         mat(395) = mat(395) + .330_r8*rxt(138)*y(1)
         mat(189) = mat(189) + .500_r8*rxt(147)*y(12)
         mat(360) = mat(360) + .270_r8*rxt(184)*y(1)
         mat(520) = mat(520) + .080_r8*rxt(160)*y(1)
         mat(466) = mat(466) + .215_r8*rxt(166)*y(1)
         mat(118) = mat(118) + .100_r8*rxt(173)*y(12)
         mat(259) = mat(259) + .700_r8*rxt(216)*y(1)
         mat(54) = mat(54) + .650_r8*rxt(110)*y(12)

         mat(855) = -((rxt(59) + rxt(60) + rxt(61)) * y(15) + rxt(64)*y(12) + rxt(70) &
                      *y(2) + rxt(71)*y(1) + 4._r8*rxt(72)*y(13) + rxt(77)*y(5) + rxt(89) &
                      *y(7) + rxt(90)*y(6) + rxt(99)*y(20) + rxt(101)*y(18) + rxt(109) &
                      *y(91) + rxt(114)*y(25) + rxt(120)*y(30) + rxt(128)*y(33) &
                      + rxt(141)*y(37) + rxt(146)*y(39) + rxt(150)*y(42) + rxt(163) &
                      *y(47) + rxt(170)*y(57) + rxt(176)*y(59) + rxt(188)*y(53) &
                      + rxt(194)*y(78) + rxt(200)*y(50) + rxt(204)*y(63) + rxt(211) &
                      *y(70) + rxt(219)*y(66))
         mat(370) = -(rxt(59) + rxt(60) + rxt(61)) * y(13)
         mat(797) = -rxt(64)*y(13)
         mat(489) = -rxt(70)*y(13)
         mat(933) = -rxt(71)*y(13)
         mat(677) = -rxt(77)*y(13)
         mat(635) = -rxt(89)*y(13)
         mat(699) = -rxt(90)*y(13)
         mat(714) = -rxt(99)*y(13)
         mat(900) = -rxt(101)*y(13)
         mat(170) = -rxt(109)*y(13)
         mat(252) = -rxt(114)*y(13)
         mat(330) = -rxt(120)*y(13)
         mat(600) = -rxt(128)*y(13)
         mat(342) = -rxt(141)*y(13)
         mat(303) = -rxt(146)*y(13)
         mat(452) = -rxt(150)*y(13)
         mat(289) = -rxt(163)*y(13)
         mat(540) = -rxt(170)*y(13)
         mat(576) = -rxt(176)*y(13)
         mat(560) = -rxt(188)*y(13)
         mat(440) = -rxt(194)*y(13)
         mat(319) = -rxt(200)*y(13)
         mat(506) = -rxt(204)*y(13)
         mat(225) = -rxt(211)*y(13)
         mat(382) = -rxt(219)*y(13)

         mat(933) = mat(933) + rxt(63)*y(12) + .120_r8*rxt(117)*y(23) &
                      + .190_r8*rxt(138)*y(35) + .060_r8*rxt(184)*y(52) &
                      + .060_r8*rxt(160)*y(55) + .275_r8*rxt(166)*y(56) + rxt(216) &
                      *y(65)
         mat(489) = mat(489) + rxt(73)*y(14) + rxt(98)*y(20)
         mat(867) = rxt(95)*y(12)
         mat(64) = rxt(74)*y(12)
         mat(36) = rxt(75)*y(12)
         mat(677) = mat(677) + rxt(100)*y(18) + .250_r8*rxt(113)*y(25) + rxt(119) &
                      *y(30) + rxt(140)*y(37) + rxt(145)*y(39) + rxt(158)*y(45) &
                      + .900_r8*rxt(199)*y(50) + rxt(186)*y(53) + .470_r8*rxt(167) &
                      *y(57) + rxt(202)*y(63) + rxt(218)*y(66) + .900_r8*rxt(210) &
                      *y(70) + .794_r8*rxt(192)*y(78) + rxt(108)*y(91)
         mat(699) = mat(699) + .700_r8*rxt(214)*y(72)
         mat(635) = mat(635) + rxt(88)*y(12) + rxt(96)*y(20) + rxt(187)*y(53) &
                      + .470_r8*rxt(169)*y(57) + rxt(203)*y(63) + .794_r8*rxt(193) &
                      *y(78) + rxt(197)*y(79)
         mat(797) = mat(797) + rxt(63)*y(1) + rxt(95)*y(17) + rxt(74)*y(87) + rxt(75) &
                      *y(88) + rxt(88)*y(7) + rxt(68)*y(14) + rxt(104)*y(21) &
                      + rxt(134)*y(22) + rxt(132)*y(27) + .200_r8*rxt(173)*y(58) &
                      + rxt(153)*y(61) + .250_r8*rxt(209)*y(68) + rxt(133)*y(74) &
                      + .500_r8*rxt(182)*y(77) + rxt(196)*y(79) + .500_r8*rxt(227) &
                      *y(82) + .350_r8*rxt(110)*y(89) + rxt(106)*y(90)
         mat(855) = mat(855) + .794_r8*rxt(194)*y(78)
         mat(91) = rxt(73)*y(2) + rxt(68)*y(12)
         mat(900) = mat(900) + rxt(100)*y(5) + 4.000_r8*rxt(102)*y(18) + rxt(121) &
                      *y(30) + .900_r8*rxt(129)*y(33) + rxt(142)*y(37) &
                      + .300_r8*rxt(151)*y(42) + rxt(190)*y(53) + .730_r8*rxt(171) &
                      *y(57) + rxt(177)*y(59) + .800_r8*rxt(205)*y(63)
         mat(714) = mat(714) + rxt(98)*y(2) + rxt(96)*y(7)
         mat(243) = rxt(104)*y(12)
         mat(83) = rxt(134)*y(12)
         mat(133) = .120_r8*rxt(117)*y(1)
         mat(252) = mat(252) + .250_r8*rxt(113)*y(5)
         mat(348) = rxt(132)*y(12)
         mat(330) = mat(330) + rxt(119)*y(5) + rxt(121)*y(18) + 2.400_r8*rxt(122) &
                      *y(30)
         mat(600) = mat(600) + .900_r8*rxt(129)*y(18) + rxt(191)*y(53) &
                      + .470_r8*rxt(172)*y(57) + rxt(206)*y(63)
         mat(396) = .190_r8*rxt(138)*y(1)
         mat(342) = mat(342) + rxt(140)*y(5) + rxt(142)*y(18)
         mat(303) = mat(303) + rxt(145)*y(5)
         mat(452) = mat(452) + .300_r8*rxt(151)*y(18)
         mat(109) = rxt(158)*y(5)
         mat(319) = mat(319) + .900_r8*rxt(199)*y(5)
         mat(361) = .060_r8*rxt(184)*y(1)
         mat(560) = mat(560) + rxt(186)*y(5) + rxt(187)*y(7) + rxt(190)*y(18) &
                      + rxt(191)*y(33)
         mat(521) = .060_r8*rxt(160)*y(1)
         mat(467) = .275_r8*rxt(166)*y(1)
         mat(540) = mat(540) + .470_r8*rxt(167)*y(5) + .470_r8*rxt(169)*y(7) &
                      + .730_r8*rxt(171)*y(18) + .470_r8*rxt(172)*y(33)
         mat(119) = .200_r8*rxt(173)*y(12)
         mat(576) = mat(576) + rxt(177)*y(18)
         mat(459) = rxt(153)*y(12)
         mat(506) = mat(506) + rxt(202)*y(5) + rxt(203)*y(7) + .800_r8*rxt(205)*y(18) &
                      + rxt(206)*y(33)
         mat(260) = rxt(216)*y(1)
         mat(382) = mat(382) + rxt(218)*y(5)
         mat(44) = .250_r8*rxt(209)*y(12)
         mat(225) = mat(225) + .900_r8*rxt(210)*y(5)
         mat(60) = .700_r8*rxt(214)*y(6)
         mat(269) = rxt(133)*y(12)
         mat(239) = .500_r8*rxt(182)*y(12)
         mat(440) = mat(440) + .794_r8*rxt(192)*y(5) + .794_r8*rxt(193)*y(7) &
                      + .794_r8*rxt(194)*y(13)
         mat(427) = rxt(197)*y(7) + rxt(196)*y(12)
         mat(79) = .500_r8*rxt(227)*y(12)
         mat(55) = .350_r8*rxt(110)*y(12)
         mat(127) = rxt(106)*y(12)
         mat(170) = mat(170) + rxt(108)*y(5)


      end subroutine nlnmat02

      subroutine nlnmat03( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(88) = -(rxt(68)*y(12) + rxt(73)*y(2))
         mat(735) = -rxt(68)*y(14)
         mat(479) = -rxt(73)*y(14)

         mat(735) = mat(735) + 2.000_r8*rxt(66)*y(12)
         mat(804) = 2.000_r8*rxt(72)*y(13)

         mat(902) = -(rxt(100)*y(5) + rxt(101)*y(13) + (4._r8*rxt(102) + 4._r8*rxt(103) &
                      ) * y(18) + rxt(121)*y(30) + rxt(129)*y(33) + rxt(142)*y(37) &
                      + rxt(151)*y(42) + rxt(171)*y(57) + rxt(177)*y(59) + rxt(190) &
                      *y(53) + rxt(205)*y(63))
         mat(679) = -rxt(100)*y(18)
         mat(857) = -rxt(101)*y(18)
         mat(331) = -rxt(121)*y(18)
         mat(602) = -rxt(129)*y(18)
         mat(343) = -rxt(142)*y(18)
         mat(453) = -rxt(151)*y(18)
         mat(542) = -rxt(171)*y(18)
         mat(578) = -rxt(177)*y(18)
         mat(562) = -rxt(190)*y(18)
         mat(508) = -rxt(205)*y(18)

         mat(935) = .310_r8*rxt(138)*y(35)
         mat(679) = mat(679) + rxt(126)*y(33)
         mat(799) = .700_r8*rxt(105)*y(19) + rxt(118)*y(26)
         mat(902) = mat(902) + .900_r8*rxt(129)*y(33)
         mat(150) = .700_r8*rxt(105)*y(12)
         mat(173) = rxt(118)*y(12)
         mat(602) = mat(602) + rxt(126)*y(5) + .900_r8*rxt(129)*y(18) &
                      + 4.000_r8*rxt(130)*y(33) + rxt(191)*y(53) + rxt(172)*y(57) &
                      + rxt(178)*y(59) + rxt(206)*y(63)
         mat(398) = .310_r8*rxt(138)*y(1)
         mat(562) = mat(562) + rxt(191)*y(33)
         mat(542) = mat(542) + rxt(172)*y(33)
         mat(578) = mat(578) + rxt(178)*y(33)
         mat(508) = mat(508) + rxt(206)*y(33)

         mat(146) = -(rxt(105)*y(12))
         mat(745) = -rxt(105)*y(19)

         mat(812) = rxt(101)*y(18)
         mat(872) = rxt(101)*y(13)

         mat(712) = -(rxt(96)*y(7) + rxt(97)*y(12) + rxt(98)*y(2) + rxt(99)*y(13))
         mat(633) = -rxt(96)*y(20)
         mat(795) = -rxt(97)*y(20)
         mat(487) = -rxt(98)*y(20)
         mat(853) = -rxt(99)*y(20)

         mat(931) = rxt(117)*y(23) + .540_r8*rxt(138)*y(35) + .600_r8*rxt(184)*y(52) &
                      + .800_r8*rxt(160)*y(55) + .700_r8*rxt(166)*y(56)
         mat(675) = rxt(100)*y(18) + .500_r8*rxt(113)*y(25) + rxt(145)*y(39) &
                      + rxt(149)*y(42) + .500_r8*rxt(158)*y(45) + .100_r8*rxt(199) &
                      *y(50) + .510_r8*rxt(186)*y(53) + .250_r8*rxt(167)*y(57) &
                      + rxt(174)*y(59) + .072_r8*rxt(192)*y(78)
         mat(633) = mat(633) + .600_r8*rxt(187)*y(53) + .250_r8*rxt(169)*y(57) &
                      + rxt(175)*y(59) + .072_r8*rxt(193)*y(78)
         mat(795) = mat(795) + .300_r8*rxt(105)*y(19) + rxt(104)*y(21) &
                      + .800_r8*rxt(132)*y(27) + .500_r8*rxt(131)*y(34) + rxt(136) &
                      *y(75) + .500_r8*rxt(182)*y(77)
         mat(853) = mat(853) + .008_r8*rxt(194)*y(78)
         mat(898) = rxt(100)*y(5) + (4.000_r8*rxt(102)+2.000_r8*rxt(103))*y(18) &
                      + .700_r8*rxt(121)*y(30) + rxt(129)*y(33) + rxt(142)*y(37) &
                      + .800_r8*rxt(151)*y(42) + 1.200_r8*rxt(190)*y(53) &
                      + .880_r8*rxt(171)*y(57) + 2.000_r8*rxt(177)*y(59) &
                      + .700_r8*rxt(205)*y(63)
         mat(148) = .300_r8*rxt(105)*y(12)
         mat(241) = rxt(104)*y(12)
         mat(131) = rxt(117)*y(1)
         mat(250) = .500_r8*rxt(113)*y(5)
         mat(346) = .800_r8*rxt(132)*y(12)
         mat(328) = .700_r8*rxt(121)*y(18)
         mat(598) = rxt(129)*y(18) + .600_r8*rxt(191)*y(53) + .250_r8*rxt(172)*y(57) &
                      + rxt(178)*y(59)
         mat(176) = .500_r8*rxt(131)*y(12)
         mat(394) = .540_r8*rxt(138)*y(1)
         mat(340) = rxt(142)*y(18)
         mat(301) = rxt(145)*y(5)
         mat(450) = rxt(149)*y(5) + .800_r8*rxt(151)*y(18)
         mat(108) = .500_r8*rxt(158)*y(5)
         mat(317) = .100_r8*rxt(199)*y(5)
         mat(359) = .600_r8*rxt(184)*y(1)
         mat(558) = .510_r8*rxt(186)*y(5) + .600_r8*rxt(187)*y(7) + 1.200_r8*rxt(190) &
                      *y(18) + .600_r8*rxt(191)*y(33)
         mat(519) = .800_r8*rxt(160)*y(1)
         mat(465) = .700_r8*rxt(166)*y(1)
         mat(538) = .250_r8*rxt(167)*y(5) + .250_r8*rxt(169)*y(7) + .880_r8*rxt(171) &
                      *y(18) + .250_r8*rxt(172)*y(33)
         mat(574) = rxt(174)*y(5) + rxt(175)*y(7) + 2.000_r8*rxt(177)*y(18) + rxt(178) &
                      *y(33) + 4.000_r8*rxt(179)*y(59)
         mat(504) = .700_r8*rxt(205)*y(18)
         mat(202) = rxt(136)*y(12)
         mat(237) = .500_r8*rxt(182)*y(12)
         mat(438) = .072_r8*rxt(192)*y(5) + .072_r8*rxt(193)*y(7) + .008_r8*rxt(194) &
                      *y(13)

         mat(240) = -(rxt(104)*y(12))
         mat(760) = -rxt(104)*y(21)

         mat(875) = 2.000_r8*rxt(103)*y(18) + .300_r8*rxt(121)*y(30) &
                      + .500_r8*rxt(151)*y(42) + .250_r8*rxt(190)*y(53) &
                      + .250_r8*rxt(171)*y(57) + .300_r8*rxt(205)*y(63)
         mat(323) = .300_r8*rxt(121)*y(18)
         mat(443) = .500_r8*rxt(151)*y(18)
         mat(545) = .250_r8*rxt(190)*y(18)
         mat(526) = .250_r8*rxt(171)*y(18)
         mat(494) = .300_r8*rxt(205)*y(18)

         mat(80) = -(rxt(134)*y(12))
         mat(734) = -rxt(134)*y(22)

         mat(871) = .200_r8*rxt(121)*y(30)
         mat(321) = .200_r8*rxt(121)*y(18) + .800_r8*rxt(122)*y(30)


         mat(801) = rxt(114)*y(25)
         mat(244) = rxt(114)*y(13)

         mat(129) = -(rxt(112)*y(12) + rxt(117)*y(1))
         mat(742) = -rxt(112)*y(23)
         mat(905) = -rxt(117)*y(23)


         mat(639) = .750_r8*rxt(113)*y(25)
         mat(245) = .750_r8*rxt(113)*y(5)

         mat(246) = -(rxt(113)*y(5) + rxt(114)*y(13))
         mat(648) = -rxt(113)*y(25)
         mat(822) = -rxt(114)*y(25)

         mat(761) = rxt(112)*y(23)
         mat(130) = rxt(112)*y(12)

         mat(171) = -(rxt(118)*y(12))
         mat(749) = -rxt(118)*y(26)

         mat(906) = .250_r8*rxt(138)*y(35) + .200_r8*rxt(184)*y(52)
         mat(815) = .250_r8*rxt(128)*y(33) + .250_r8*rxt(176)*y(59)
         mat(874) = .100_r8*rxt(129)*y(33)
         mat(581) = .250_r8*rxt(128)*y(13) + .100_r8*rxt(129)*y(18)
         mat(385) = .250_r8*rxt(138)*y(1)
         mat(350) = .200_r8*rxt(184)*y(1)
         mat(564) = .250_r8*rxt(176)*y(13)

         mat(345) = -(rxt(132)*y(12))
         mat(772) = -rxt(132)*y(27)

         mat(656) = .530_r8*rxt(167)*y(57) + .250_r8*rxt(202)*y(63)
         mat(612) = .530_r8*rxt(169)*y(57) + .250_r8*rxt(203)*y(63)
         mat(880) = .260_r8*rxt(171)*y(57) + .100_r8*rxt(205)*y(63)
         mat(585) = .530_r8*rxt(172)*y(57) + .250_r8*rxt(206)*y(63)
         mat(527) = .530_r8*rxt(167)*y(5) + .530_r8*rxt(169)*y(7) + .260_r8*rxt(171) &
                      *y(18) + .530_r8*rxt(172)*y(33)
         mat(496) = .250_r8*rxt(202)*y(5) + .250_r8*rxt(203)*y(7) + .100_r8*rxt(205) &
                      *y(18) + .250_r8*rxt(206)*y(33)

         mat(22) = -(rxt(111)*y(12))
         mat(720) = -rxt(111)*y(29)

         mat(324) = -(rxt(119)*y(5) + rxt(120)*y(13) + rxt(121)*y(18) + 4._r8*rxt(122) &
                      *y(30))
         mat(654) = -rxt(119)*y(30)
         mat(830) = -rxt(120)*y(30)
         mat(878) = -rxt(121)*y(30)

         mat(770) = rxt(111)*y(29) + .500_r8*rxt(123)*y(31)
         mat(23) = rxt(111)*y(12)
         mat(121) = .500_r8*rxt(123)*y(12)

         mat(120) = -(rxt(123)*y(12))
         mat(740) = -rxt(123)*y(31)

         mat(808) = rxt(120)*y(30)
         mat(322) = rxt(120)*y(13)

         mat(412) = -(rxt(124)*y(12) + rxt(125)*y(7))
         mat(778) = -rxt(124)*y(32)
         mat(616) = -rxt(125)*y(32)

         mat(915) = .500_r8*rxt(138)*y(35) + .040_r8*rxt(160)*y(55)
         mat(658) = rxt(119)*y(30) + .270_r8*rxt(140)*y(37) + rxt(145)*y(39) &
                      + rxt(158)*y(45) + .400_r8*rxt(199)*y(50) + rxt(162)*y(47)
         mat(778) = mat(778) + rxt(134)*y(22) + .500_r8*rxt(123)*y(31)
         mat(883) = .800_r8*rxt(121)*y(30)
         mat(81) = rxt(134)*y(12)
         mat(325) = rxt(119)*y(5) + .800_r8*rxt(121)*y(18) + 3.200_r8*rxt(122)*y(30)
         mat(122) = .500_r8*rxt(123)*y(12)
         mat(388) = .500_r8*rxt(138)*y(1)
         mat(335) = .270_r8*rxt(140)*y(5)
         mat(297) = rxt(145)*y(5)
         mat(105) = rxt(158)*y(5)
         mat(311) = .400_r8*rxt(199)*y(5)
         mat(284) = rxt(162)*y(5)
         mat(510) = .040_r8*rxt(160)*y(1)

         mat(594) = -(rxt(126)*y(5) + rxt(127)*y(6) + rxt(128)*y(13) + rxt(129)*y(18) &
                      + 4._r8*rxt(130)*y(33) + rxt(172)*y(57) + rxt(191)*y(53) + rxt(206) &
                      *y(63))
         mat(671) = -rxt(126)*y(33)
         mat(693) = -rxt(127)*y(33)
         mat(849) = -rxt(128)*y(33)
         mat(894) = -rxt(129)*y(33)
         mat(534) = -rxt(172)*y(33)
         mat(554) = -rxt(191)*y(33)
         mat(500) = -rxt(206)*y(33)

         mat(671) = mat(671) + rxt(149)*y(42) + rxt(162)*y(47) + .530_r8*rxt(167) &
                      *y(57) + rxt(174)*y(59)
         mat(629) = rxt(125)*y(32) + .530_r8*rxt(169)*y(57) + rxt(175)*y(59) &
                      + rxt(155)*y(62)
         mat(791) = rxt(124)*y(32) + .500_r8*rxt(131)*y(34) + rxt(154)*y(62)
         mat(894) = mat(894) + .300_r8*rxt(151)*y(42) + .260_r8*rxt(171)*y(57) &
                      + rxt(177)*y(59)
         mat(413) = rxt(125)*y(7) + rxt(124)*y(12)
         mat(594) = mat(594) + .530_r8*rxt(172)*y(57)
         mat(175) = .500_r8*rxt(131)*y(12)
         mat(447) = rxt(149)*y(5) + .300_r8*rxt(151)*y(18)
         mat(285) = rxt(162)*y(5)
         mat(534) = mat(534) + .530_r8*rxt(167)*y(5) + .530_r8*rxt(169)*y(7) &
                      + .260_r8*rxt(171)*y(18) + .530_r8*rxt(172)*y(33)
         mat(570) = rxt(174)*y(5) + rxt(175)*y(7) + rxt(177)*y(18) + 4.000_r8*rxt(179) &
                      *y(59)
         mat(472) = rxt(155)*y(7) + rxt(154)*y(12)

         mat(174) = -(rxt(131)*y(12))
         mat(750) = -rxt(131)*y(34)

         mat(816) = .750_r8*rxt(128)*y(33) + .750_r8*rxt(176)*y(59)
         mat(582) = .750_r8*rxt(128)*y(13)
         mat(565) = .750_r8*rxt(176)*y(13)

         mat(387) = -(rxt(137)*y(12) + rxt(138)*y(1) + rxt(139)*y(7))
         mat(776) = -rxt(137)*y(35)
         mat(913) = -rxt(138)*y(35)
         mat(615) = -rxt(139)*y(35)

         mat(913) = mat(913) + .070_r8*rxt(184)*y(52)
         mat(352) = .070_r8*rxt(184)*y(1)


      end subroutine nlnmat03

      subroutine nlnmat04( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(25) = -(rxt(144)*y(12))
         mat(721) = -rxt(144)*y(36)

         mat(334) = -(rxt(140)*y(5) + rxt(141)*y(13) + rxt(142)*y(18))
         mat(655) = -rxt(140)*y(37)
         mat(831) = -rxt(141)*y(37)
         mat(879) = -rxt(142)*y(37)

         mat(771) = rxt(144)*y(36) + rxt(143)*y(38)
         mat(26) = rxt(144)*y(12)
         mat(143) = rxt(143)*y(12)

         mat(141) = -(rxt(143)*y(12))
         mat(744) = -rxt(143)*y(38)

         mat(811) = rxt(141)*y(37)
         mat(332) = rxt(141)*y(13)

         mat(296) = -(rxt(145)*y(5) + rxt(146)*y(13))
         mat(652) = -rxt(145)*y(39)
         mat(828) = -rxt(146)*y(39)

         mat(768) = rxt(137)*y(35) + .500_r8*rxt(147)*y(40)
         mat(386) = rxt(137)*y(12)
         mat(185) = .500_r8*rxt(147)*y(12)

         mat(184) = -(rxt(147)*y(12))
         mat(752) = -rxt(147)*y(40)

         mat(817) = rxt(146)*y(39)
         mat(295) = rxt(146)*y(13)

         mat(290) = -(rxt(148)*y(12))
         mat(767) = -rxt(148)*y(41)

         mat(651) = .820_r8*rxt(140)*y(37) + .500_r8*rxt(158)*y(45) + .250_r8*rxt(199) &
                      *y(50) + .100_r8*rxt(218)*y(66)
         mat(877) = .820_r8*rxt(142)*y(37)
         mat(333) = .820_r8*rxt(140)*y(5) + .820_r8*rxt(142)*y(18)
         mat(104) = .500_r8*rxt(158)*y(5)
         mat(308) = .250_r8*rxt(199)*y(5)
         mat(373) = .100_r8*rxt(218)*y(5)

         mat(444) = -(rxt(149)*y(5) + rxt(150)*y(13) + rxt(151)*y(18))
         mat(661) = -rxt(149)*y(42)
         mat(839) = -rxt(150)*y(42)
         mat(884) = -rxt(151)*y(42)

         mat(781) = rxt(148)*y(41) + rxt(152)*y(43)
         mat(291) = rxt(148)*y(12)
         mat(99) = rxt(152)*y(12)

         mat(98) = -(rxt(152)*y(12))
         mat(736) = -rxt(152)*y(43)

         mat(805) = rxt(150)*y(42)
         mat(442) = rxt(150)*y(13)

         mat(28) = -(rxt(157)*y(12))
         mat(722) = -rxt(157)*y(44)

         mat(103) = -(rxt(158)*y(5))
         mat(640) = -rxt(158)*y(45)

         mat(737) = rxt(157)*y(44)
         mat(29) = rxt(157)*y(12)

         mat(31) = -(rxt(195)*y(12))
         mat(723) = -rxt(195)*y(49)

         mat(309) = -(rxt(199)*y(5) + rxt(200)*y(13))
         mat(653) = -rxt(199)*y(50)
         mat(829) = -rxt(200)*y(50)

         mat(769) = rxt(195)*y(49) + rxt(201)*y(51)
         mat(32) = rxt(195)*y(12)
         mat(275) = rxt(201)*y(12)

         mat(272) = -(rxt(201)*y(12))
         mat(765) = -rxt(201)*y(51)

         mat(825) = rxt(200)*y(50)
         mat(306) = rxt(200)*y(13)

         mat(179) = -(rxt(161)*y(12))
         mat(751) = -rxt(161)*y(46)

         mat(645) = .800_r8*rxt(199)*y(50)
         mat(305) = .800_r8*rxt(199)*y(5)

         mat(283) = -(rxt(162)*y(5) + rxt(163)*y(13))
         mat(650) = -rxt(162)*y(47)
         mat(826) = -rxt(163)*y(47)

         mat(766) = rxt(161)*y(46) + rxt(164)*y(48)
         mat(180) = rxt(161)*y(12)
         mat(111) = rxt(164)*y(12)

         mat(110) = -(rxt(164)*y(12))
         mat(738) = -rxt(164)*y(48)

         mat(806) = rxt(163)*y(47)
         mat(282) = rxt(163)*y(13)

         mat(351) = -(rxt(183)*y(12) + rxt(184)*y(1) + rxt(185)*y(7))
         mat(773) = -rxt(183)*y(52)
         mat(910) = -rxt(184)*y(52)
         mat(613) = -rxt(185)*y(52)

         mat(552) = -(rxt(186)*y(5) + rxt(187)*y(7) + rxt(188)*y(13) + rxt(190)*y(18) &
                      + rxt(191)*y(33))
         mat(669) = -rxt(186)*y(53)
         mat(627) = -rxt(187)*y(53)
         mat(847) = -rxt(188)*y(53)
         mat(892) = -rxt(190)*y(53)
         mat(592) = -rxt(191)*y(53)

         mat(789) = rxt(183)*y(52) + .200_r8*rxt(189)*y(54)
         mat(356) = rxt(183)*y(12)
         mat(213) = .200_r8*rxt(189)*y(12)

         mat(209) = -(rxt(189)*y(12))
         mat(756) = -rxt(189)*y(54)

         mat(819) = rxt(188)*y(53)
         mat(544) = rxt(188)*y(13)

         mat(513) = -(rxt(159)*y(12) + rxt(160)*y(1))
         mat(787) = -rxt(159)*y(55)
         mat(923) = -rxt(160)*y(55)

         mat(923) = mat(923) + .200_r8*rxt(184)*y(52) + rxt(216)*y(65)
         mat(667) = .320_r8*rxt(186)*y(53) + rxt(218)*y(66) + .039_r8*rxt(192)*y(78)
         mat(625) = .350_r8*rxt(187)*y(53) + .039_r8*rxt(193)*y(78)
         mat(845) = .039_r8*rxt(194)*y(78)
         mat(890) = .260_r8*rxt(190)*y(53)
         mat(590) = .350_r8*rxt(191)*y(53)
         mat(355) = .200_r8*rxt(184)*y(1)
         mat(550) = .320_r8*rxt(186)*y(5) + .350_r8*rxt(187)*y(7) + .260_r8*rxt(190) &
                      *y(18) + .350_r8*rxt(191)*y(33)
         mat(256) = rxt(216)*y(1)
         mat(377) = rxt(218)*y(5)
         mat(434) = .039_r8*rxt(192)*y(5) + .039_r8*rxt(193)*y(7) + .039_r8*rxt(194) &
                      *y(13)

         mat(460) = -(rxt(165)*y(12) + rxt(166)*y(1))
         mat(783) = -rxt(165)*y(56)
         mat(919) = -rxt(166)*y(56)

         mat(919) = mat(919) + .400_r8*rxt(184)*y(52) + rxt(216)*y(65)
         mat(663) = .230_r8*rxt(186)*y(53) + rxt(218)*y(66) + .167_r8*rxt(192)*y(78)
         mat(621) = .250_r8*rxt(187)*y(53) + .167_r8*rxt(193)*y(78)
         mat(841) = .167_r8*rxt(194)*y(78)
         mat(886) = .190_r8*rxt(190)*y(53)
         mat(587) = .250_r8*rxt(191)*y(53)
         mat(354) = .400_r8*rxt(184)*y(1)
         mat(547) = .230_r8*rxt(186)*y(5) + .250_r8*rxt(187)*y(7) + .190_r8*rxt(190) &
                      *y(18) + .250_r8*rxt(191)*y(33)
         mat(255) = rxt(216)*y(1)
         mat(376) = rxt(218)*y(5)
         mat(432) = .167_r8*rxt(192)*y(5) + .167_r8*rxt(193)*y(7) + .167_r8*rxt(194) &
                      *y(13)

         mat(532) = -((rxt(167) + rxt(168)) * y(5) + rxt(169)*y(7) + rxt(170)*y(13) &
                      + rxt(171)*y(18) + rxt(172)*y(33))
         mat(668) = -(rxt(167) + rxt(168)) * y(57)
         mat(626) = -rxt(169)*y(57)
         mat(846) = -rxt(170)*y(57)
         mat(891) = -rxt(171)*y(57)
         mat(591) = -rxt(172)*y(57)

         mat(788) = rxt(159)*y(55) + .500_r8*rxt(165)*y(56) + .200_r8*rxt(173)*y(58)
         mat(514) = rxt(159)*y(12)
         mat(462) = .500_r8*rxt(165)*y(12)
         mat(116) = .200_r8*rxt(173)*y(12)

         mat(115) = -(rxt(173)*y(12))
         mat(739) = -rxt(173)*y(58)

         mat(807) = rxt(170)*y(57)
         mat(525) = rxt(170)*y(13)

         mat(569) = -(rxt(174)*y(5) + rxt(175)*y(7) + rxt(176)*y(13) + rxt(177)*y(18) &
                      + rxt(178)*y(33) + 4._r8*rxt(179)*y(59) + rxt(180)*y(6))
         mat(670) = -rxt(174)*y(59)
         mat(628) = -rxt(175)*y(59)
         mat(848) = -rxt(176)*y(59)
         mat(893) = -rxt(177)*y(59)
         mat(593) = -rxt(178)*y(59)
         mat(692) = -rxt(180)*y(59)

         mat(926) = .200_r8*rxt(184)*y(52)
         mat(790) = .500_r8*rxt(165)*y(56) + .500_r8*rxt(173)*y(58)
         mat(357) = .200_r8*rxt(184)*y(1)
         mat(463) = .500_r8*rxt(165)*y(12)
         mat(117) = .500_r8*rxt(173)*y(12)

         mat(151) = -(rxt(198)*y(12))
         mat(746) = -rxt(198)*y(60)

         mat(642) = .370_r8*rxt(186)*y(53)
         mat(607) = .400_r8*rxt(187)*y(53) + rxt(197)*y(79)
         mat(746) = mat(746) + rxt(196)*y(79)
         mat(873) = .300_r8*rxt(190)*y(53)
         mat(580) = .400_r8*rxt(191)*y(53)
         mat(543) = .370_r8*rxt(186)*y(5) + .400_r8*rxt(187)*y(7) + .300_r8*rxt(190) &
                      *y(18) + .400_r8*rxt(191)*y(33)
         mat(420) = rxt(197)*y(7) + rxt(196)*y(12)

         mat(454) = -(rxt(153)*y(12))
         mat(782) = -rxt(153)*y(61)

         mat(662) = .220_r8*rxt(167)*y(57) + .250_r8*rxt(202)*y(63)
         mat(620) = .220_r8*rxt(169)*y(57) + .250_r8*rxt(203)*y(63)
         mat(782) = mat(782) + .500_r8*rxt(147)*y(40) + .500_r8*rxt(182)*y(77)
         mat(885) = .200_r8*rxt(151)*y(42) + .230_r8*rxt(171)*y(57) + .100_r8*rxt(205) &
                      *y(63)
         mat(586) = .220_r8*rxt(172)*y(57) + .250_r8*rxt(206)*y(63)
         mat(187) = .500_r8*rxt(147)*y(12)
         mat(445) = .200_r8*rxt(151)*y(18)
         mat(529) = .220_r8*rxt(167)*y(5) + .220_r8*rxt(169)*y(7) + .230_r8*rxt(171) &
                      *y(18) + .220_r8*rxt(172)*y(33)
         mat(497) = .250_r8*rxt(202)*y(5) + .250_r8*rxt(203)*y(7) + .100_r8*rxt(205) &
                      *y(18) + .250_r8*rxt(206)*y(33)
         mat(233) = .500_r8*rxt(182)*y(12)

         mat(471) = -(rxt(154)*y(12) + rxt(155)*y(7))
         mat(784) = -rxt(154)*y(62)
         mat(622) = -rxt(155)*y(62)

         mat(920) = .950_r8*rxt(160)*y(55) + .800_r8*rxt(166)*y(56)
         mat(664) = .250_r8*rxt(167)*y(57) + .250_r8*rxt(202)*y(63) + .450_r8*rxt(210) &
                      *y(70)
         mat(622) = mat(622) + .250_r8*rxt(169)*y(57) + .250_r8*rxt(203)*y(63)
         mat(784) = mat(784) + rxt(153)*y(61) + rxt(156)*y(76)
         mat(887) = .500_r8*rxt(151)*y(42) + .240_r8*rxt(171)*y(57) + .100_r8*rxt(205) &
                      *y(63)
         mat(588) = .250_r8*rxt(172)*y(57) + .250_r8*rxt(206)*y(63)
         mat(446) = .500_r8*rxt(151)*y(18)
         mat(512) = .950_r8*rxt(160)*y(1)
         mat(461) = .800_r8*rxt(166)*y(1)
         mat(530) = .250_r8*rxt(167)*y(5) + .250_r8*rxt(169)*y(7) + .240_r8*rxt(171) &
                      *y(18) + .250_r8*rxt(172)*y(33)
         mat(455) = rxt(153)*y(12)
         mat(498) = .250_r8*rxt(202)*y(5) + .250_r8*rxt(203)*y(7) + .100_r8*rxt(205) &
                      *y(18) + .250_r8*rxt(206)*y(33)
         mat(221) = .450_r8*rxt(210)*y(5)
         mat(161) = rxt(156)*y(12)

         mat(499) = -(rxt(202)*y(5) + rxt(203)*y(7) + rxt(204)*y(13) + rxt(205)*y(18) &
                      + rxt(206)*y(33))
         mat(666) = -rxt(202)*y(63)
         mat(624) = -rxt(203)*y(63)
         mat(844) = -rxt(204)*y(63)
         mat(889) = -rxt(205)*y(63)
         mat(589) = -rxt(206)*y(63)

         mat(786) = .800_r8*rxt(189)*y(54) + rxt(198)*y(60) + rxt(207)*y(64)
         mat(211) = .800_r8*rxt(189)*y(12)
         mat(152) = rxt(198)*y(12)
         mat(66) = rxt(207)*y(12)


      end subroutine nlnmat04

      subroutine nlnmat05( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(65) = -((rxt(207) + rxt(208)) * y(12))
         mat(731) = -(rxt(207) + rxt(208)) * y(64)

         mat(802) = rxt(204)*y(63) + rxt(194)*y(78)
         mat(493) = rxt(204)*y(13)
         mat(429) = rxt(194)*y(13)

         mat(253) = -(rxt(215)*y(12) + rxt(216)*y(1) + rxt(217)*y(7))
         mat(762) = -rxt(215)*y(65)
         mat(908) = -rxt(216)*y(65)
         mat(610) = -rxt(217)*y(65)

         mat(374) = -(rxt(218)*y(5) + rxt(219)*y(13))
         mat(657) = -rxt(218)*y(66)
         mat(834) = -rxt(219)*y(66)

         mat(614) = rxt(217)*y(65)
         mat(775) = rxt(215)*y(65) + rxt(220)*y(67)
         mat(254) = rxt(217)*y(7) + rxt(215)*y(12)
         mat(193) = rxt(220)*y(12)

         mat(191) = -(rxt(220)*y(12))
         mat(753) = -rxt(220)*y(67)

         mat(818) = rxt(219)*y(66)
         mat(372) = rxt(219)*y(13)

         mat(40) = -(rxt(209)*y(12))
         mat(725) = -rxt(209)*y(68)

         mat(45) = -(rxt(213)*y(12))
         mat(726) = -rxt(213)*y(69)

         mat(726) = mat(726) + .250_r8*rxt(209)*y(68)
         mat(41) = .250_r8*rxt(209)*y(12)

         mat(218) = -(rxt(210)*y(5) + rxt(211)*y(13))
         mat(646) = -rxt(210)*y(70)
         mat(820) = -rxt(211)*y(70)

         mat(757) = .700_r8*rxt(209)*y(68) + rxt(212)*y(71)
         mat(42) = .700_r8*rxt(209)*y(12)
         mat(155) = rxt(212)*y(12)

         mat(154) = -(rxt(212)*y(12))
         mat(747) = -rxt(212)*y(71)

         mat(813) = rxt(211)*y(70)
         mat(217) = rxt(211)*y(13)

         mat(57) = -(rxt(214)*y(6))
         mat(681) = -rxt(214)*y(72)

         mat(729) = rxt(213)*y(69)
         mat(46) = rxt(213)*y(12)


         mat(647) = .900_r8*rxt(210)*y(70)
         mat(686) = .700_r8*rxt(214)*y(72)
         mat(219) = .900_r8*rxt(210)*y(5)
         mat(58) = .700_r8*rxt(214)*y(6)

         mat(267) = -(rxt(133)*y(12))
         mat(764) = -rxt(133)*y(74)

         mat(649) = .250_r8*rxt(202)*y(63) + .450_r8*rxt(210)*y(70)
         mat(611) = .250_r8*rxt(203)*y(63)
         mat(764) = mat(764) + .200_r8*rxt(132)*y(27) + .650_r8*rxt(110)*y(89)
         mat(876) = .100_r8*rxt(205)*y(63)
         mat(344) = .200_r8*rxt(132)*y(12)
         mat(584) = .250_r8*rxt(206)*y(63)
         mat(495) = .250_r8*rxt(202)*y(5) + .250_r8*rxt(203)*y(7) + .100_r8*rxt(205) &
                      *y(18) + .250_r8*rxt(206)*y(33)
         mat(220) = .450_r8*rxt(210)*y(5)
         mat(53) = .650_r8*rxt(110)*y(12)

         mat(198) = -(rxt(136)*y(12))
         mat(754) = -rxt(136)*y(75)

         mat(684) = rxt(127)*y(33)
         mat(583) = rxt(127)*y(6)

         mat(160) = -(rxt(156)*y(12))
         mat(748) = -rxt(156)*y(76)

         mat(643) = .100_r8*rxt(199)*y(50)
         mat(608) = rxt(139)*y(35)
         mat(384) = rxt(139)*y(7)
         mat(304) = .100_r8*rxt(199)*y(5)

         mat(232) = -(rxt(182)*y(12))
         mat(759) = -rxt(182)*y(77)

         mat(687) = rxt(180)*y(59)
         mat(566) = rxt(180)*y(6)

         mat(431) = -(rxt(192)*y(5) + rxt(193)*y(7) + rxt(194)*y(13))
         mat(660) = -rxt(192)*y(78)
         mat(618) = -rxt(193)*y(78)
         mat(838) = -rxt(194)*y(78)

         mat(618) = mat(618) + rxt(185)*y(52)
         mat(353) = rxt(185)*y(7)

         mat(421) = -(rxt(196)*y(12) + rxt(197)*y(7))
         mat(779) = -rxt(196)*y(79)
         mat(617) = -rxt(197)*y(79)

         mat(659) = .080_r8*rxt(186)*y(53) + .800_r8*rxt(168)*y(57) + .794_r8*rxt(192) &
                      *y(78)
         mat(617) = mat(617) + .794_r8*rxt(193)*y(78)
         mat(837) = .794_r8*rxt(194)*y(78)
         mat(546) = .080_r8*rxt(186)*y(5)
         mat(528) = .800_r8*rxt(168)*y(5)
         mat(430) = .794_r8*rxt(192)*y(5) + .794_r8*rxt(193)*y(7) + .794_r8*rxt(194) &
                      *y(13)

         mat(69) = -(rxt(231)*y(2) + rxt(232)*y(12))
         mat(478) = -rxt(231)*y(80)
         mat(732) = -rxt(232)*y(80)

         mat(49) = -(rxt(225)*y(12))
         mat(727) = -rxt(225)*y(81)

         mat(604) = rxt(228)*y(82)
         mat(727) = mat(727) + rxt(232)*y(80) + (rxt(226)+.500_r8*rxt(227))*y(82)
         mat(68) = rxt(232)*y(12)
         mat(74) = rxt(228)*y(7) + (rxt(226)+.500_r8*rxt(227))*y(12)

         mat(75) = -((rxt(226) + rxt(227)) * y(12) + rxt(228)*y(7))
         mat(733) = -(rxt(226) + rxt(227)) * y(82)
         mat(605) = -rxt(228)*y(82)

         mat(20) = -(rxt(229)*y(12))
         mat(719) = -rxt(229)*y(83)



         mat(51) = -(rxt(110)*y(12))
         mat(728) = -rxt(110)*y(89)

         mat(125) = -(rxt(106)*y(12))
         mat(741) = -rxt(106)*y(90)

         mat(904) = .500_r8*rxt(117)*y(23)
         mat(641) = rxt(108)*y(91)
         mat(741) = mat(741) + .350_r8*rxt(110)*y(89)
         mat(809) = rxt(109)*y(91)
         mat(128) = .500_r8*rxt(117)*y(1)
         mat(52) = .350_r8*rxt(110)*y(12)
         mat(164) = rxt(108)*y(5) + rxt(109)*y(13)

         mat(165) = -(rxt(108)*y(5) + rxt(109)*y(13))
         mat(644) = -rxt(108)*y(91)
         mat(814) = -rxt(109)*y(91)

         mat(814) = mat(814) + rxt(99)*y(20)
         mat(703) = rxt(99)*y(13)


         mat(718) = rxt(225)*y(81)
         mat(48) = rxt(225)*y(12)
      end subroutine nlnmat05
      subroutine nlnmat_finit( mat, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(inout) :: mat(nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
         mat( 1) = lmat( 1)
         mat( 2) = lmat( 2)
         mat( 3) = lmat( 3)
         mat( 4) = lmat( 4)
         mat( 5) = lmat( 5)
         mat( 6) = lmat( 6)
         mat( 7) = lmat( 7)
         mat( 8) = lmat( 8)
         mat( 9) = lmat( 9)
         mat( 10) = lmat( 10)
         mat( 11) = lmat( 11)
         mat( 12) = lmat( 12)
         mat( 13) = lmat( 13)
         mat( 14) = lmat( 14)
         mat( 15) = lmat( 15)
         mat( 16) = lmat( 16)
         mat( 17) = lmat( 17)
         mat( 18) = lmat( 18)
         mat( 19) = lmat( 19)
         mat( 20) = mat( 20) + lmat( 20)
         mat( 22) = mat( 22) + lmat( 22)
         mat( 25) = mat( 25) + lmat( 25)
         mat( 28) = mat( 28) + lmat( 28)
         mat( 31) = mat( 31) + lmat( 31)
         mat( 34) = mat( 34) + lmat( 34)
         mat( 37) = lmat( 37)
         mat( 38) = lmat( 38)
         mat( 39) = lmat( 39)
         mat( 40) = mat( 40) + lmat( 40)
         mat( 45) = mat( 45) + lmat( 45)
         mat( 49) = mat( 49) + lmat( 49)
         mat( 51) = mat( 51) + lmat( 51)
         mat( 57) = mat( 57) + lmat( 57)
         mat( 61) = mat( 61) + lmat( 61)
         mat( 65) = mat( 65) + lmat( 65)
         mat( 67) = mat( 67) + lmat( 67)
         mat( 69) = mat( 69) + lmat( 69)
         mat( 73) = mat( 73) + lmat( 73)
         mat( 75) = mat( 75) + lmat( 75)
         mat( 80) = mat( 80) + lmat( 80)
         mat( 84) = lmat( 84)
         mat( 85) = lmat( 85)
         mat( 86) = lmat( 86)
         mat( 87) = lmat( 87)
         mat( 88) = mat( 88) + lmat( 88)
         mat( 90) = mat( 90) + lmat( 90)
         mat( 92) = lmat( 92)
         mat( 93) = lmat( 93)
         mat( 94) = lmat( 94)
         mat( 95) = lmat( 95)
         mat( 96) = lmat( 96)
         mat( 97) = lmat( 97)
         mat( 98) = mat( 98) + lmat( 98)
         mat( 100) = lmat( 100)
         mat( 101) = lmat( 101)
         mat( 102) = mat( 102) + lmat( 102)
         mat( 103) = mat( 103) + lmat( 103)
         mat( 110) = mat( 110) + lmat( 110)
         mat( 112) = lmat( 112)
         mat( 113) = lmat( 113)
         mat( 114) = mat( 114) + lmat( 114)
         mat( 115) = mat( 115) + lmat( 115)
         mat( 120) = mat( 120) + lmat( 120)
         mat( 122) = mat( 122) + lmat( 122)
         mat( 123) = mat( 123) + lmat( 123)
         mat( 124) = lmat( 124)
         mat( 125) = mat( 125) + lmat( 125)
         mat( 129) = mat( 129) + lmat( 129)
         mat( 136) = mat( 136) + lmat( 136)
         mat( 137) = lmat( 137)
         mat( 138) = mat( 138) + lmat( 138)
         mat( 139) = mat( 139) + lmat( 139)
         mat( 140) = lmat( 140)
         mat( 141) = mat( 141) + lmat( 141)
         mat( 142) = lmat( 142)
         mat( 144) = mat( 144) + lmat( 144)
         mat( 145) = lmat( 145)
         mat( 146) = mat( 146) + lmat( 146)
         mat( 147) = lmat( 147)
         mat( 148) = mat( 148) + lmat( 148)
         mat( 149) = mat( 149) + lmat( 149)
         mat( 151) = mat( 151) + lmat( 151)
         mat( 154) = mat( 154) + lmat( 154)
         mat( 156) = lmat( 156)
         mat( 157) = lmat( 157)
         mat( 158) = lmat( 158)
         mat( 159) = mat( 159) + lmat( 159)
         mat( 160) = mat( 160) + lmat( 160)
         mat( 165) = mat( 165) + lmat( 165)
         mat( 168) = lmat( 168)
         mat( 170) = mat( 170) + lmat( 170)
         mat( 171) = mat( 171) + lmat( 171)
         mat( 174) = mat( 174) + lmat( 174)
         mat( 177) = mat( 177) + lmat( 177)
         mat( 178) = lmat( 178)
         mat( 179) = mat( 179) + lmat( 179)
         mat( 181) = lmat( 181)
         mat( 182) = lmat( 182)
         mat( 184) = mat( 184) + lmat( 184)
         mat( 186) = lmat( 186)
         mat( 188) = lmat( 188)
         mat( 189) = mat( 189) + lmat( 189)
         mat( 190) = lmat( 190)
         mat( 191) = mat( 191) + lmat( 191)
         mat( 192) = lmat( 192)
         mat( 194) = lmat( 194)
         mat( 195) = lmat( 195)
         mat( 196) = mat( 196) + lmat( 196)
         mat( 197) = lmat( 197)
         mat( 198) = mat( 198) + lmat( 198)
         mat( 199) = lmat( 199)
         mat( 200) = mat( 200) + lmat( 200)
         mat( 201) = lmat( 201)
         mat( 204) = lmat( 204)
         mat( 205) = mat( 205) + lmat( 205)
         mat( 207) = lmat( 207)
         mat( 208) = mat( 208) + lmat( 208)
         mat( 209) = mat( 209) + lmat( 209)
         mat( 210) = lmat( 210)
         mat( 212) = lmat( 212)
         mat( 214) = lmat( 214)
         mat( 216) = lmat( 216)
         mat( 218) = mat( 218) + lmat( 218)
         mat( 226) = lmat( 226)
         mat( 227) = lmat( 227)
         mat( 228) = lmat( 228)
         mat( 229) = lmat( 229)
         mat( 230) = lmat( 230)
         mat( 231) = lmat( 231)
         mat( 232) = mat( 232) + lmat( 232)
         mat( 234) = lmat( 234)
         mat( 236) = lmat( 236)
         mat( 240) = mat( 240) + lmat( 240)
         mat( 246) = mat( 246) + lmat( 246)
         mat( 253) = mat( 253) + lmat( 253)
         mat( 262) = mat( 262) + lmat( 262)
         mat( 267) = mat( 267) + lmat( 267)
         mat( 269) = mat( 269) + lmat( 269)
         mat( 270) = mat( 270) + lmat( 270)
         mat( 271) = lmat( 271)
         mat( 272) = mat( 272) + lmat( 272)
         mat( 274) = lmat( 274)
         mat( 277) = lmat( 277)
         mat( 279) = lmat( 279)
         mat( 280) = mat( 280) + lmat( 280)
         mat( 281) = lmat( 281)
         mat( 283) = mat( 283) + lmat( 283)
         mat( 290) = mat( 290) + lmat( 290)
         mat( 292) = lmat( 292)
         mat( 294) = lmat( 294)
         mat( 296) = mat( 296) + lmat( 296)
         mat( 309) = mat( 309) + lmat( 309)
         mat( 324) = mat( 324) + lmat( 324)
         mat( 334) = mat( 334) + lmat( 334)
         mat( 345) = mat( 345) + lmat( 345)
         mat( 346) = mat( 346) + lmat( 346)
         mat( 348) = mat( 348) + lmat( 348)
         mat( 349) = lmat( 349)
         mat( 351) = mat( 351) + lmat( 351)
         mat( 366) = mat( 366) + lmat( 366)
         mat( 370) = mat( 370) + lmat( 370)
         mat( 374) = mat( 374) + lmat( 374)
         mat( 387) = mat( 387) + lmat( 387)
         mat( 401) = mat( 401) + lmat( 401)
         mat( 402) = mat( 402) + lmat( 402)
         mat( 403) = mat( 403) + lmat( 403)
         mat( 404) = lmat( 404)
         mat( 405) = lmat( 405)
         mat( 406) = lmat( 406)
         mat( 407) = mat( 407) + lmat( 407)
         mat( 408) = lmat( 408)
         mat( 409) = lmat( 409)
         mat( 412) = mat( 412) + lmat( 412)
         mat( 417) = lmat( 417)
         mat( 418) = lmat( 418)
         mat( 419) = lmat( 419)
         mat( 421) = mat( 421) + lmat( 421)
         mat( 424) = mat( 424) + lmat( 424)
         mat( 425) = lmat( 425)
         mat( 427) = mat( 427) + lmat( 427)
         mat( 428) = lmat( 428)
         mat( 431) = mat( 431) + lmat( 431)
         mat( 444) = mat( 444) + lmat( 444)
         mat( 454) = mat( 454) + lmat( 454)
         mat( 456) = lmat( 456)
         mat( 457) = lmat( 457)
         mat( 459) = mat( 459) + lmat( 459)
         mat( 460) = mat( 460) + lmat( 460)
         mat( 463) = mat( 463) + lmat( 463)
         mat( 464) = lmat( 464)
         mat( 465) = mat( 465) + lmat( 465)
         mat( 467) = mat( 467) + lmat( 467)
         mat( 468) = mat( 468) + lmat( 468)
         mat( 471) = mat( 471) + lmat( 471)
         mat( 472) = mat( 472) + lmat( 472)
         mat( 476) = lmat( 476)
         mat( 477) = mat( 477) + lmat( 477)
         mat( 483) = mat( 483) + lmat( 483)
         mat( 492) = mat( 492) + lmat( 492)
         mat( 499) = mat( 499) + lmat( 499)
         mat( 509) = lmat( 509)
         mat( 513) = mat( 513) + lmat( 513)
         mat( 515) = lmat( 515)
         mat( 522) = mat( 522) + lmat( 522)
         mat( 523) = lmat( 523)
         mat( 532) = mat( 532) + lmat( 532)
         mat( 552) = mat( 552) + lmat( 552)
         mat( 569) = mat( 569) + lmat( 569)
         mat( 594) = mat( 594) + lmat( 594)
         mat( 609) = mat( 609) + lmat( 609)
         mat( 623) = mat( 623) + lmat( 623)
         mat( 630) = mat( 630) + lmat( 630)
         mat( 631) = mat( 631) + lmat( 631)
         mat( 632) = mat( 632) + lmat( 632)
         mat( 673) = mat( 673) + lmat( 673)
         mat( 685) = mat( 685) + lmat( 685)
         mat( 691) = mat( 691) + lmat( 691)
         mat( 695) = mat( 695) + lmat( 695)
         mat( 696) = mat( 696) + lmat( 696)
         mat( 698) = mat( 698) + lmat( 698)
         mat( 705) = lmat( 705)
         mat( 712) = mat( 712) + lmat( 712)
         mat( 715) = mat( 715) + lmat( 715)
         mat( 796) = mat( 796) + lmat( 796)
         mat( 799) = mat( 799) + lmat( 799)
         mat( 804) = mat( 804) + lmat( 804)
         mat( 855) = mat( 855) + lmat( 855)
         mat( 868) = mat( 868) + lmat( 868)
         mat( 902) = mat( 902) + lmat( 902)
         mat( 914) = mat( 914) + lmat( 914)
         mat( 921) = mat( 921) + lmat( 921)
         mat( 936) = mat( 936) + lmat( 936)
         mat( 169) = 0._r8
         mat( 224) = 0._r8
         mat( 247) = 0._r8
         mat( 251) = 0._r8
         mat( 273) = 0._r8
         mat( 276) = 0._r8
         mat( 278) = 0._r8
         mat( 288) = 0._r8
         mat( 298) = 0._r8
         mat( 302) = 0._r8
         mat( 307) = 0._r8
         mat( 310) = 0._r8
         mat( 312) = 0._r8
         mat( 313) = 0._r8
         mat( 314) = 0._r8
         mat( 318) = 0._r8
         mat( 320) = 0._r8
         mat( 329) = 0._r8
         mat( 336) = 0._r8
         mat( 337) = 0._r8
         mat( 341) = 0._r8
         mat( 363) = 0._r8
         mat( 367) = 0._r8
         mat( 375) = 0._r8
         mat( 378) = 0._r8
         mat( 381) = 0._r8
         mat( 383) = 0._r8
         mat( 389) = 0._r8
         mat( 390) = 0._r8
         mat( 392) = 0._r8
         mat( 393) = 0._r8
         mat( 415) = 0._r8
         mat( 422) = 0._r8
         mat( 433) = 0._r8
         mat( 439) = 0._r8
         mat( 441) = 0._r8
         mat( 451) = 0._r8
         mat( 474) = 0._r8
         mat( 482) = 0._r8
         mat( 491) = 0._r8
         mat( 505) = 0._r8
         mat( 511) = 0._r8
         mat( 516) = 0._r8
         mat( 517) = 0._r8
         mat( 518) = 0._r8
         mat( 531) = 0._r8
         mat( 533) = 0._r8
         mat( 539) = 0._r8
         mat( 548) = 0._r8
         mat( 549) = 0._r8
         mat( 551) = 0._r8
         mat( 553) = 0._r8
         mat( 559) = 0._r8
         mat( 561) = 0._r8
         mat( 563) = 0._r8
         mat( 567) = 0._r8
         mat( 568) = 0._r8
         mat( 575) = 0._r8
         mat( 577) = 0._r8
         mat( 595) = 0._r8
         mat( 599) = 0._r8
         mat( 619) = 0._r8
         mat( 637) = 0._r8
         mat( 638) = 0._r8
         mat( 688) = 0._r8
         mat( 689) = 0._r8
         mat( 690) = 0._r8
         mat( 697) = 0._r8
         mat( 700) = 0._r8
         mat( 701) = 0._r8
         mat( 707) = 0._r8
         mat( 710) = 0._r8
         mat( 711) = 0._r8
         mat( 716) = 0._r8
         mat( 717) = 0._r8
         mat( 758) = 0._r8
         mat( 777) = 0._r8
         mat( 780) = 0._r8
         mat( 793) = 0._r8
         mat( 803) = 0._r8
         mat( 821) = 0._r8
         mat( 824) = 0._r8
         mat( 827) = 0._r8
         mat( 832) = 0._r8
         mat( 835) = 0._r8
         mat( 836) = 0._r8
         mat( 840) = 0._r8
         mat( 842) = 0._r8
         mat( 856) = 0._r8
         mat( 860) = 0._r8
         mat( 861) = 0._r8
         mat( 862) = 0._r8
         mat( 863) = 0._r8
         mat( 864) = 0._r8
         mat( 865) = 0._r8
         mat( 869) = 0._r8
         mat( 870) = 0._r8
         mat( 881) = 0._r8
         mat( 882) = 0._r8
         mat( 888) = 0._r8
         mat( 895) = 0._r8
         mat( 899) = 0._r8
         mat( 903) = 0._r8
         mat( 907) = 0._r8
         mat( 909) = 0._r8
         mat( 912) = 0._r8
         mat( 916) = 0._r8
         mat( 917) = 0._r8
         mat( 918) = 0._r8
         mat( 922) = 0._r8
         mat( 924) = 0._r8
         mat( 925) = 0._r8
         mat( 927) = 0._r8
         mat( 1) = mat( 1) - dti
         mat( 2) = mat( 2) - dti
         mat( 3) = mat( 3) - dti
         mat( 4) = mat( 4) - dti
         mat( 5) = mat( 5) - dti
         mat( 6) = mat( 6) - dti
         mat( 7) = mat( 7) - dti
         mat( 8) = mat( 8) - dti
         mat( 9) = mat( 9) - dti
         mat( 10) = mat( 10) - dti
         mat( 11) = mat( 11) - dti
         mat( 12) = mat( 12) - dti
         mat( 13) = mat( 13) - dti
         mat( 14) = mat( 14) - dti
         mat( 15) = mat( 15) - dti
         mat( 16) = mat( 16) - dti
         mat( 17) = mat( 17) - dti
         mat( 18) = mat( 18) - dti
         mat( 19) = mat( 19) - dti
         mat( 20) = mat( 20) - dti
         mat( 22) = mat( 22) - dti
         mat( 25) = mat( 25) - dti
         mat( 28) = mat( 28) - dti
         mat( 31) = mat( 31) - dti
         mat( 34) = mat( 34) - dti
         mat( 37) = mat( 37) - dti
         mat( 40) = mat( 40) - dti
         mat( 45) = mat( 45) - dti
         mat( 49) = mat( 49) - dti
         mat( 51) = mat( 51) - dti
         mat( 57) = mat( 57) - dti
         mat( 61) = mat( 61) - dti
         mat( 65) = mat( 65) - dti
         mat( 69) = mat( 69) - dti
         mat( 75) = mat( 75) - dti
         mat( 80) = mat( 80) - dti
         mat( 84) = mat( 84) - dti
         mat( 88) = mat( 88) - dti
         mat( 92) = mat( 92) - dti
         mat( 98) = mat( 98) - dti
         mat( 103) = mat( 103) - dti
         mat( 110) = mat( 110) - dti
         mat( 115) = mat( 115) - dti
         mat( 120) = mat( 120) - dti
         mat( 125) = mat( 125) - dti
         mat( 129) = mat( 129) - dti
         mat( 136) = mat( 136) - dti
         mat( 141) = mat( 141) - dti
         mat( 146) = mat( 146) - dti
         mat( 151) = mat( 151) - dti
         mat( 154) = mat( 154) - dti
         mat( 160) = mat( 160) - dti
         mat( 165) = mat( 165) - dti
         mat( 171) = mat( 171) - dti
         mat( 174) = mat( 174) - dti
         mat( 179) = mat( 179) - dti
         mat( 184) = mat( 184) - dti
         mat( 191) = mat( 191) - dti
         mat( 198) = mat( 198) - dti
         mat( 205) = mat( 205) - dti
         mat( 209) = mat( 209) - dti
         mat( 218) = mat( 218) - dti
         mat( 226) = mat( 226) - dti
         mat( 232) = mat( 232) - dti
         mat( 240) = mat( 240) - dti
         mat( 246) = mat( 246) - dti
         mat( 253) = mat( 253) - dti
         mat( 262) = mat( 262) - dti
         mat( 267) = mat( 267) - dti
         mat( 272) = mat( 272) - dti
         mat( 283) = mat( 283) - dti
         mat( 290) = mat( 290) - dti
         mat( 296) = mat( 296) - dti
         mat( 309) = mat( 309) - dti
         mat( 324) = mat( 324) - dti
         mat( 334) = mat( 334) - dti
         mat( 345) = mat( 345) - dti
         mat( 351) = mat( 351) - dti
         mat( 366) = mat( 366) - dti
         mat( 374) = mat( 374) - dti
         mat( 387) = mat( 387) - dti
         mat( 403) = mat( 403) - dti
         mat( 412) = mat( 412) - dti
         mat( 421) = mat( 421) - dti
         mat( 431) = mat( 431) - dti
         mat( 444) = mat( 444) - dti
         mat( 454) = mat( 454) - dti
         mat( 460) = mat( 460) - dti
         mat( 471) = mat( 471) - dti
         mat( 483) = mat( 483) - dti
         mat( 499) = mat( 499) - dti
         mat( 513) = mat( 513) - dti
         mat( 532) = mat( 532) - dti
         mat( 552) = mat( 552) - dti
         mat( 569) = mat( 569) - dti
         mat( 594) = mat( 594) - dti
         mat( 630) = mat( 630) - dti
         mat( 673) = mat( 673) - dti
         mat( 696) = mat( 696) - dti
         mat( 712) = mat( 712) - dti
         mat( 796) = mat( 796) - dti
         mat( 855) = mat( 855) - dti
         mat( 868) = mat( 868) - dti
         mat( 902) = mat( 902) - dti
         mat( 936) = mat( 936) - dti
      end subroutine nlnmat_finit
      subroutine nlnmat( mat, y, rxt, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)
      call nlnmat01( mat, y, rxt )
      call nlnmat02( mat, y, rxt )
      call nlnmat03( mat, y, rxt )
      call nlnmat04( mat, y, rxt )
      call nlnmat05( mat, y, rxt )
      call nlnmat_finit( mat, lmat, dti )
      end subroutine nlnmat
      end module mo_nln_matrix
