



      module mo_prod_loss

      use shr_kind_mod, only : r8 => shr_kind_r8

      private
      public :: exp_prod_loss
      public :: imp_prod_loss

      contains

      subroutine exp_prod_loss( prod, loss, y, rxt, het_rates )

      use ppgrid, only : pver

      implicit none

!--------------------------------------------------------------------
! ... dummy args
!--------------------------------------------------------------------
      real(r8), dimension(:,:,:), intent(out) :: &
            prod, &
            loss
      real(r8), intent(in) :: y(:,:,:)
      real(r8), intent(in) :: rxt(:,:,:)
      real(r8), intent(in) :: het_rates(:,:,:)



!--------------------------------------------------------------------
! ... loss and production for Explicit method
!--------------------------------------------------------------------


         loss(:,:,1) = ((rxt(:,:,127) +rxt(:,:,128) +rxt(:,:,129))* y(:,:,3) &
                  +rxt(:,:,234)* y(:,:,22) +rxt(:,:,181)* y(:,:,27) +rxt(:,:,220) &
                 * y(:,:,62) + rxt(:,:,59) + rxt(:,:,60) + het_rates(:,:,15)) &
                 * y(:,:,15)
         prod(:,:,1) = 0._r8
         loss(:,:,2) = ((rxt(:,:,106) +rxt(:,:,107))* y(:,:,3) + rxt(:,:,5) &
                  + het_rates(:,:,7))* y(:,:,7)
         prod(:,:,2) = 0._r8
         loss(:,:,3) = (rxt(:,:,223)* y(:,:,22) +rxt(:,:,222)* y(:,:,27) + rxt(:,:,37) &
                  + het_rates(:,:,41))* y(:,:,41)
         prod(:,:,3) = 0._r8
         loss(:,:,4) = (rxt(:,:,118)* y(:,:,3) +rxt(:,:,226)* y(:,:,22) +rxt(:,:,227) &
                 * y(:,:,27) + rxt(:,:,48) + het_rates(:,:,42))* y(:,:,42)
         prod(:,:,4) = 0._r8
         loss(:,:,5) = (rxt(:,:,109)* y(:,:,3) + rxt(:,:,40) + het_rates(:,:,43)) &
                 * y(:,:,43)
         prod(:,:,5) = 0._r8
         loss(:,:,6) = (rxt(:,:,110)* y(:,:,3) + rxt(:,:,41) + het_rates(:,:,44)) &
                 * y(:,:,44)
         prod(:,:,6) = 0._r8
         loss(:,:,7) = (rxt(:,:,111)* y(:,:,3) + rxt(:,:,42) + het_rates(:,:,45)) &
                 * y(:,:,45)
         prod(:,:,7) = 0._r8
         loss(:,:,8) = (rxt(:,:,112)* y(:,:,3) + rxt(:,:,43) + het_rates(:,:,53)) &
                 * y(:,:,53)
         prod(:,:,8) = 0._r8
         loss(:,:,9) = (rxt(:,:,113)* y(:,:,3) + rxt(:,:,44) + het_rates(:,:,54)) &
                 * y(:,:,54)
         prod(:,:,9) = 0._r8
         loss(:,:,10) = (rxt(:,:,114)* y(:,:,3) +rxt(:,:,225)* y(:,:,22) + rxt(:,:,45) &
                  + het_rates(:,:,46))* y(:,:,46)
         prod(:,:,10) = 0._r8
         loss(:,:,11) = (rxt(:,:,115)* y(:,:,3) +rxt(:,:,228)* y(:,:,22) + rxt(:,:,46) &
                  + het_rates(:,:,51))* y(:,:,51)
         prod(:,:,11) = 0._r8
         loss(:,:,12) = (rxt(:,:,116)* y(:,:,3) +rxt(:,:,229)* y(:,:,22) + rxt(:,:,47) &
                  + het_rates(:,:,52))* y(:,:,52)
         prod(:,:,12) = 0._r8
         loss(:,:,13) = (rxt(:,:,117)* y(:,:,3) + rxt(:,:,38) + het_rates(:,:,47)) &
                 * y(:,:,47)
         prod(:,:,13) = 0._r8
         loss(:,:,14) = (rxt(:,:,224)* y(:,:,22) + rxt(:,:,39) + het_rates(:,:,48)) &
                 * y(:,:,48)
         prod(:,:,14) = 0._r8
         loss(:,:,15) = (rxt(:,:,120)* y(:,:,3) + rxt(:,:,49) + het_rates(:,:,49)) &
                 * y(:,:,49)
         prod(:,:,15) = 0._r8
         loss(:,:,16) = (rxt(:,:,119)* y(:,:,3) + rxt(:,:,50) + het_rates(:,:,50)) &
                 * y(:,:,50)
         prod(:,:,16) = 0._r8
         loss(:,:,17) = (rxt(:,:,121)* y(:,:,3) + rxt(:,:,53) + het_rates(:,:,55)) &
                 * y(:,:,55)
         prod(:,:,17) = 0._r8
         loss(:,:,18) = (rxt(:,:,122)* y(:,:,3) + rxt(:,:,54) + het_rates(:,:,56)) &
                 * y(:,:,56)
         prod(:,:,18) = 0._r8
         loss(:,:,19) = (rxt(:,:,123)* y(:,:,3) +rxt(:,:,231)* y(:,:,22) +rxt(:,:,233) &
                 * y(:,:,27) + rxt(:,:,51) + het_rates(:,:,57))* y(:,:,57)
         prod(:,:,19) = 0._r8
         loss(:,:,20) = (rxt(:,:,124)* y(:,:,3) +rxt(:,:,230)* y(:,:,22) +rxt(:,:,232) &
                 * y(:,:,27) + rxt(:,:,52) + het_rates(:,:,58))* y(:,:,58)
         prod(:,:,20) = 0._r8
         loss(:,:,21) = (rxt(:,:,268)* y(:,:,67) + rxt(:,:,58) + rxt(:,:,88) &
                  + het_rates(:,:,63))* y(:,:,63)
         prod(:,:,21) =.440_r8*rxt(:,:,60)*y(:,:,15)
         loss(:,:,22) = ( + het_rates(:,:,25))* y(:,:,25)
         prod(:,:,22) = 0._r8
         loss(:,:,23) = ( + het_rates(:,:,26))* y(:,:,26)
         prod(:,:,23) = 0._r8
         loss(:,:,24) = ( + rxt(:,:,297) + het_rates(:,:,84))* y(:,:,84)
         prod(:,:,24) = 0._r8
         loss(:,:,25) = ( + rxt(:,:,298) + het_rates(:,:,85))* y(:,:,85)
         prod(:,:,25) = 0._r8
         loss(:,:,26) = ( + rxt(:,:,299) + het_rates(:,:,86))* y(:,:,86)
         prod(:,:,26) = 0._r8
         loss(:,:,27) = ( + rxt(:,:,291) + het_rates(:,:,73))* y(:,:,73)
         prod(:,:,27) = 0._r8
         loss(:,:,28) = ( + rxt(:,:,292) + het_rates(:,:,74))* y(:,:,74)
         prod(:,:,28) = 0._r8
         loss(:,:,29) = ( + rxt(:,:,293) + het_rates(:,:,75))* y(:,:,75)
         prod(:,:,29) = 0._r8
         loss(:,:,30) = ( + het_rates(:,:,76))* y(:,:,76)
         prod(:,:,30) = 0._r8
         loss(:,:,31) = ( + rxt(:,:,294) + het_rates(:,:,77))* y(:,:,77)
         prod(:,:,31) = 0._r8
         loss(:,:,32) = ( + rxt(:,:,295) + het_rates(:,:,78))* y(:,:,78)
         prod(:,:,32) = 0._r8
         loss(:,:,33) = ( + rxt(:,:,296) + het_rates(:,:,79))* y(:,:,79)
         prod(:,:,33) = 0._r8
         loss(:,:,34) = ( + het_rates(:,:,80))* y(:,:,80)
         prod(:,:,34) = 0._r8
         loss(:,:,35) = ( + rxt(:,:,61) + het_rates(:,:,81))* y(:,:,81)
         prod(:,:,35) = 0._r8
         loss(:,:,36) = ( + rxt(:,:,62) + het_rates(:,:,82))* y(:,:,82)
         prod(:,:,36) = 0._r8
         loss(:,:,37) = ( + het_rates(:,:,83))* y(:,:,83)
         prod(:,:,37) = 0._r8

      end subroutine exp_prod_loss

      subroutine imp_prod_loss( prod, loss, y, rxt, het_rates )

      use ppgrid, only : pver

      implicit none

!--------------------------------------------------------------------
! ... dummy args
!--------------------------------------------------------------------
      real(r8), dimension(:), intent(out) :: &
            prod, &
            loss
      real(r8), intent(in) :: y(:)
      real(r8), intent(in) :: rxt(:)
      real(r8), intent(in) :: het_rates(:)



!--------------------------------------------------------------------
! ... loss and production for Implicit method
!--------------------------------------------------------------------


         loss(49) = (rxt(90)* y(2) +rxt(108)* y(3) +rxt(160)* y(9) +rxt(163)* y(10) &
                  +rxt(134)* y(21) +rxt(139)* y(22) +rxt(147)* y(23) +rxt(175)* y(27) &
                  +rxt(202)* y(36) + rxt(3) + rxt(4) + het_rates(1))* y(1)
         prod(49) =rxt(89)*y(4)*y(2)
         loss(44) = (rxt(90)* y(1) + 2._r8*rxt(91)* y(2) +rxt(89)* y(4) +rxt(158) &
                 * y(9) + (rxt(161) +rxt(162))* y(10) +rxt(169)* y(11) +rxt(239) &
                 * y(18) +rxt(145)* y(20) +rxt(138)* y(22) +rxt(146)* y(23) +rxt(149) &
                 * y(24) +rxt(182)* y(29) +rxt(195)* y(32) +rxt(196)* y(33) +rxt(199) &
                 * y(34) +rxt(205)* y(37) +rxt(215)* y(38) +rxt(216)* y(39) +rxt(217) &
                 * y(40) + (rxt(266) +rxt(267))* y(64) +rxt(273)* y(66) + rxt(63) &
                  + rxt(64) + rxt(65) + rxt(76) + rxt(77) + rxt(78) + het_rates(2)) &
                 * y(2)
         prod(44) = (rxt(1) +2.000_r8*rxt(2) +rxt(69) +rxt(70) +rxt(71) + &
                 2.000_r8*rxt(74) +rxt(81) +rxt(82) +rxt(83) +2.000_r8*rxt(86) + &
                 rxt(103)*y(3) +rxt(104)*y(3) +rxt(153)*y(8) +rxt(264)*y(67) + &
                 rxt(272)*y(66) +rxt(285)*y(72))*y(4) + (rxt(154)*y(9) + &
                 rxt(155)*y(10) +rxt(269)*y(65))*y(8) + (rxt(276)*y(68) + &
                 1.150_r8*rxt(277)*y(65))*y(69) +rxt(4)*y(1) +rxt(102)*y(3) +rxt(6) &
                 *y(9) +rxt(8)*y(10) +rxt(12)*y(11) +rxt(10)*y(14) +rxt(137)*y(23) &
                 *y(21) +rxt(141)*y(22)*y(22) +rxt(24)*y(29) +rxt(25)*y(30) +rxt(32) &
                 *y(37) +rxt(279)*y(71) +rxt(286)*y(72) +rxt(21)*y(87)
         loss(47) = (rxt(108)* y(1) + (rxt(103) +rxt(104))* y(4) + (rxt(106) + &
                 rxt(107))* y(7) + (rxt(127) +rxt(128) +rxt(129))* y(15) +rxt(130) &
                 * y(20) +rxt(131)* y(32) +rxt(132)* y(38) +rxt(118)* y(42) +rxt(109) &
                 * y(43) +rxt(110)* y(44) +rxt(111)* y(45) +rxt(114)* y(46) +rxt(117) &
                 * y(47) +rxt(120)* y(49) +rxt(119)* y(50) +rxt(115)* y(51) +rxt(116) &
                 * y(52) +rxt(112)* y(53) +rxt(113)* y(54) +rxt(121)* y(55) +rxt(122) &
                 * y(56) +rxt(123)* y(57) +rxt(124)* y(58) +rxt(125)* y(59) +rxt(126) &
                 * y(60) +rxt(105)* y(87) + rxt(102) + het_rates(3))* y(3)
         prod(47) = (rxt(1) +rxt(150)*y(70))*y(4) +rxt(3)*y(1) +.850_r8*rxt(277)*y(69) &
                 *y(65) +rxt(20)*y(87)
         loss(32) = (rxt(89)* y(2) +rxt(103)* y(3) +rxt(99)* y(6) +rxt(153)* y(8) &
                  +rxt(133)* y(21) +rxt(274)* y(64) + (rxt(271) +rxt(272))* y(66) &
                  +rxt(264)* y(67) +rxt(150)* y(70) +rxt(285)* y(72) + rxt(1) + rxt(2) &
                  + rxt(67) + rxt(69) + rxt(70) + rxt(71) + rxt(74) + rxt(79) &
                  + rxt(81) + rxt(82) + rxt(83) + rxt(86) + het_rates(4))* y(4)
         prod(32) = (rxt(136)*y(21) +rxt(140)*y(22) +rxt(146)*y(2) + &
                 2.000_r8*rxt(147)*y(1) +rxt(148)*y(23) +rxt(171)*y(11) + &
                 rxt(178)*y(27) +rxt(185)*y(29) +rxt(203)*y(36) +rxt(207)*y(37) + &
                 rxt(241)*y(16))*y(23) + (rxt(4) +2.000_r8*rxt(90)*y(2) + &
                 2.000_r8*rxt(108)*y(3) +rxt(134)*y(21) +rxt(139)*y(22) + &
                 rxt(160)*y(9) +rxt(163)*y(10) +rxt(175)*y(27) +rxt(202)*y(36))*y(1) &
                  + (rxt(91)*y(2) +rxt(98)*y(6) +rxt(138)*y(22) +rxt(161)*y(10) + &
                 rxt(169)*y(11) +rxt(182)*y(29) +rxt(205)*y(37))*y(2) &
                  + (rxt(184)*y(22) +rxt(189)*y(29) +rxt(190)*y(29) +rxt(211)*y(37) + &
                 rxt(212)*y(37))*y(29) + (rxt(100) +rxt(101) +2.000_r8*rxt(99)*y(4)) &
                 *y(6) +rxt(107)*y(7)*y(3) +rxt(97)*y(5) +rxt(157)*y(10)*y(8) &
                  +rxt(270)*y(65)*y(9) +rxt(13)*y(11) +rxt(173)*y(22)*y(13) &
                  +rxt(213)*y(37)*y(37)
         loss(3) = (rxt(95)* y(1) +rxt(92)* y(2) +rxt(93)* y(4) +rxt(96)* y(63) &
                  + rxt(94) + rxt(97) + het_rates(5))* y(5)
         prod(3) =rxt(103)*y(4)*y(3)
         loss(2) = (rxt(98)* y(2) +rxt(99)* y(4) + rxt(100) + rxt(101) + het_rates(6)) &
                 * y(6)
         prod(2) = (rxt(94) +rxt(96)*y(63) +rxt(92)*y(2) +rxt(93)*y(4) +rxt(95)*y(1)) &
                 *y(5) +rxt(3)*y(1)
         loss(35) = (rxt(145)* y(2) +rxt(130)* y(3) +rxt(143)* y(22) +rxt(176)* y(27) &
                  +rxt(219)* y(62) + het_rates(20))* y(20)
         prod(35) =rxt(129)*y(15)*y(3) +rxt(18)*y(18) +rxt(136)*y(23)*y(21) +rxt(20) &
                 *y(87)
         loss(16) = ((rxt(235) +rxt(236))* y(22) + het_rates(19))* y(19)
         prod(16) = (rxt(17) +rxt(18) +rxt(180)*y(27) +rxt(204)*y(36) + &
                 rxt(237)*y(11) +rxt(238)*y(22) +rxt(239)*y(2))*y(18) +rxt(222)*y(41) &
                 *y(27) +rxt(268)*y(67)*y(63)
         loss(28) = (rxt(153)* y(4) +rxt(154)* y(9) + (rxt(155) +rxt(156) +rxt(157)) &
                 * y(10) +rxt(152)* y(22) +rxt(269)* y(65) + rxt(66) + het_rates(8)) &
                 * y(8)
         prod(28) = (rxt(151)*y(70) +rxt(273)*y(66))*y(2) + (.200_r8*rxt(276)*y(68) + &
                 1.100_r8*rxt(278)*y(64))*y(69) +rxt(271)*y(66)*y(4) +rxt(6)*y(9) &
                  +rxt(265)*y(67)
         loss(48) = (rxt(160)* y(1) +rxt(158)* y(2) +rxt(154)* y(8) +rxt(168)* y(11) &
                  +rxt(240)* y(16) +rxt(159)* y(23) +rxt(187)* y(29) +rxt(208)* y(37) &
                  +rxt(270)* y(65) + rxt(6) + rxt(7) + het_rates(9))* y(9)
         prod(48) = (rxt(8) +.500_r8*rxt(245) +2.000_r8*rxt(156)*y(8) +rxt(161)*y(2)) &
                 *y(10) + (rxt(150)*y(70) +rxt(153)*y(8))*y(4) +2.000_r8*rxt(106)*y(7) &
                 *y(3) +rxt(152)*y(22)*y(8) +rxt(13)*y(11) +rxt(10)*y(14) +rxt(275) &
                 *y(65) +rxt(280)*y(71)
         loss(40) = (rxt(163)* y(1) + (rxt(161) +rxt(162))* y(2) + (rxt(155) + &
                 rxt(156) +rxt(157))* y(8) +rxt(164)* y(11) +rxt(166)* y(22) +rxt(172) &
                 * y(23) +rxt(188)* y(29) +rxt(209)* y(37) + rxt(8) + rxt(245) &
                  + het_rates(10))* y(10)
         prod(40) = (rxt(158)*y(2) +rxt(159)*y(23) +rxt(160)*y(1) + &
                 2.000_r8*rxt(168)*y(11) +rxt(187)*y(29) +rxt(208)*y(37) + &
                 rxt(240)*y(16))*y(9) + (rxt(12) +rxt(169)*y(2) +rxt(170)*y(22) + &
                 rxt(171)*y(23))*y(11) + (rxt(15) +rxt(174) +rxt(173)*y(22))*y(13) &
                  + (rxt(9) +rxt(165))*y(14) +rxt(11)*y(12) +rxt(30)*y(34) +rxt(36) &
                 *y(40)
         loss(43) = (rxt(139)* y(1) +rxt(138)* y(2) +rxt(152)* y(8) +rxt(166)* y(10) &
                  +rxt(170)* y(11) +rxt(167)* y(12) +rxt(173)* y(13) +rxt(234)* y(15) &
                  +rxt(242)* y(17) +rxt(238)* y(18) + (rxt(235) +rxt(236))* y(19) &
                  +rxt(143)* y(20) + 2._r8*(rxt(141) +rxt(142))* y(22) +rxt(140) &
                 * y(23) +rxt(144)* y(24) + (rxt(183) +rxt(184))* y(29) +rxt(194) &
                 * y(32) +rxt(198)* y(33) +rxt(200)* y(34) +rxt(206)* y(37) +rxt(214) &
                 * y(38) +rxt(223)* y(41) +rxt(226)* y(42) +rxt(225)* y(46) +rxt(224) &
                 * y(48) +rxt(228)* y(51) +rxt(229)* y(52) +rxt(231)* y(57) +rxt(230) &
                 * y(58) + het_rates(22))* y(22)
         prod(43) = (rxt(145)*y(20) +rxt(146)*y(23) +rxt(149)*y(24) +rxt(195)*y(32) + &
                 rxt(196)*y(33) +rxt(215)*y(38) +rxt(216)*y(39) +rxt(239)*y(18))*y(2) &
                  + (rxt(127)*y(15) +2.000_r8*rxt(105)*y(87) +rxt(130)*y(20) + &
                 rxt(131)*y(32) +rxt(132)*y(38))*y(3) + (2.000_r8*rxt(135)*y(21) + &
                 rxt(147)*y(1) +rxt(159)*y(9) +rxt(171)*y(11) +rxt(179)*y(27))*y(23) &
                  + (rxt(19) +rxt(218)*y(62))*y(87) +rxt(134)*y(21)*y(1) &
                  +.500_r8*rxt(245)*y(10) +rxt(11)*y(12) +rxt(14)*y(13) +rxt(16)*y(17) &
                  +2.000_r8*rxt(22)*y(24) +rxt(27)*y(33) +rxt(33)*y(39)
         loss(45) = (rxt(169)* y(2) +rxt(168)* y(9) +rxt(164)* y(10) +rxt(237)* y(18) &
                  +rxt(170)* y(22) +rxt(171)* y(23) + rxt(12) + rxt(13) + rxt(244) &
                  + het_rates(11))* y(11)
         prod(45) = (rxt(29) +rxt(199)*y(2) +rxt(200)*y(22) +rxt(201)*y(27))*y(34) &
                  + (rxt(9) +rxt(10) +rxt(165))*y(14) + (rxt(162)*y(10) + &
                 rxt(217)*y(40))*y(2) + (rxt(167)*y(22) +rxt(221)*y(62))*y(12) &
                  +rxt(163)*y(10)*y(1) +rxt(14)*y(13) +rxt(35)*y(40)
         loss(31) = (rxt(167)* y(22) +rxt(221)* y(62) + rxt(11) + het_rates(12)) &
                 * y(12)
         prod(31) = (rxt(248) +rxt(254) +rxt(259) +rxt(250)*y(32) +rxt(255)*y(32) + &
                 rxt(261)*y(32))*y(34) + (2.000_r8*rxt(243) +2.000_r8*rxt(247) + &
                 2.000_r8*rxt(253) +2.000_r8*rxt(258))*y(14) + (rxt(249) +rxt(257) + &
                 rxt(260))*y(40) + (.500_r8*rxt(245) +rxt(166)*y(22))*y(10) &
                  + (rxt(244) +rxt(237)*y(18))*y(11)
         loss(12) = (rxt(173)* y(22) + rxt(14) + rxt(15) + rxt(174) + het_rates(13)) &
                 * y(13)
         prod(12) =rxt(172)*y(23)*y(10)
         loss(10) = ( + rxt(9) + rxt(10) + rxt(165) + rxt(243) + rxt(247) + rxt(253) &
                  + rxt(258) + het_rates(14))* y(14)
         prod(10) =rxt(164)*y(11)*y(10)
         loss(50) = (rxt(240)* y(9) +rxt(241)* y(23) +rxt(186)* y(29) + het_rates(16)) &
                 * y(16)
         prod(50) = (rxt(127)*y(3) +rxt(181)*y(27) +rxt(220)*y(62) +rxt(234)*y(22)) &
                 *y(15) +rxt(242)*y(22)*y(17)
         loss(11) = (rxt(242)* y(22) + rxt(16) + het_rates(17))* y(17)
         prod(11) =rxt(241)*y(23)*y(16)
         loss(34) = (rxt(239)* y(2) +rxt(237)* y(11) +rxt(238)* y(22) +rxt(180)* y(27) &
                  +rxt(204)* y(36) + rxt(17) + rxt(18) + het_rates(18))* y(18)
         prod(34) = (rxt(128)*y(15) +rxt(129)*y(15))*y(3) + (rxt(186)*y(29) + &
                 rxt(240)*y(9))*y(16) +rxt(16)*y(17)
         loss(38) = (rxt(134)* y(1) +rxt(133)* y(4) + (rxt(135) +rxt(136) +rxt(137)) &
                 * y(23) + het_rates(21))* y(21)
         prod(38) = (rxt(130)*y(3) +rxt(143)*y(22) +rxt(145)*y(2) +rxt(176)*y(27) + &
                 rxt(219)*y(62))*y(20) + (rxt(138)*y(2) +rxt(152)*y(8) + &
                 rxt(235)*y(19) +rxt(238)*y(18))*y(22) + (rxt(19) +2.000_r8*rxt(21)) &
                 *y(87) +rxt(128)*y(15)*y(3) +rxt(16)*y(17) +2.000_r8*rxt(17)*y(18) &
                  +rxt(28)*y(32) +rxt(34)*y(38) +rxt(57)*y(61)
         loss(41) = (rxt(147)* y(1) +rxt(146)* y(2) +rxt(159)* y(9) +rxt(172)* y(10) &
                  +rxt(171)* y(11) +rxt(241)* y(16) + (rxt(135) +rxt(136) +rxt(137)) &
                 * y(21) +rxt(140)* y(22) + 2._r8*rxt(148)* y(23) + (rxt(178) + &
                 rxt(179))* y(27) +rxt(185)* y(29) +rxt(203)* y(36) +rxt(207)* y(37) &
                  + rxt(246) + het_rates(23))* y(23)
         prod(41) = (rxt(223)*y(41) +rxt(226)*y(42) +rxt(139)*y(1) +rxt(144)*y(24) + &
                 rxt(170)*y(11) +rxt(183)*y(29) +rxt(206)*y(37) +rxt(236)*y(19))*y(22) &
                  + (rxt(180)*y(27) +rxt(204)*y(36) +rxt(237)*y(11) +rxt(239)*y(2)) &
                 *y(18) + (rxt(222)*y(41) +rxt(227)*y(42) +rxt(177)*y(24))*y(27) &
                  + (rxt(15) +rxt(174))*y(13) + (rxt(186)*y(29) +rxt(240)*y(9))*y(16) &
                  +rxt(149)*y(24)*y(2) +rxt(128)*y(15)*y(3) +rxt(133)*y(21)*y(4)
         loss(18) = (rxt(149)* y(2) +rxt(144)* y(22) +rxt(177)* y(27) + rxt(22) &
                  + het_rates(24))* y(24)
         prod(18) = (.500_r8*rxt(246) +rxt(148)*y(23))*y(23) +rxt(142)*y(22)*y(22)
         loss(33) = (rxt(105)* y(3) +rxt(218)* y(62) + rxt(19) + rxt(20) + rxt(21) &
                  + het_rates(87))* y(87)
         prod(33) = (rxt(223)*y(41) +rxt(224)*y(48) +rxt(225)*y(46) +rxt(226)*y(42) + &
                 rxt(230)*y(58) +rxt(234)*y(15) +rxt(140)*y(23) +rxt(141)*y(22) + &
                 rxt(143)*y(20) +rxt(144)*y(24) +rxt(167)*y(12) +rxt(173)*y(13) + &
                 rxt(194)*y(32) +rxt(198)*y(33) +rxt(214)*y(38) +rxt(238)*y(18) + &
                 rxt(242)*y(17))*y(22) + (rxt(251)*y(33) +rxt(252)*y(39) + &
                 rxt(256)*y(33) +rxt(262)*y(33) +rxt(263)*y(39))*y(32) +rxt(137)*y(23) &
                 *y(21)
         loss(42) = (rxt(175)* y(1) +rxt(181)* y(15) +rxt(180)* y(18) +rxt(176)* y(20) &
                  + (rxt(178) +rxt(179))* y(23) +rxt(177)* y(24) +rxt(197)* y(33) &
                  +rxt(201)* y(34) +rxt(222)* y(41) +rxt(227)* y(42) +rxt(233)* y(57) &
                  +rxt(232)* y(58) + het_rates(27))* y(27)
         prod(42) = (2.000_r8*rxt(109)*y(43) +2.000_r8*rxt(110)*y(44) + &
                 2.000_r8*rxt(111)*y(45) +2.000_r8*rxt(112)*y(53) +rxt(113)*y(54) + &
                 rxt(114)*y(46) +rxt(115)*y(51) +rxt(116)*y(52) + &
                 4.000_r8*rxt(117)*y(47) +rxt(119)*y(50) +rxt(126)*y(60) + &
                 rxt(131)*y(32))*y(3) + (rxt(24) +rxt(182)*y(2) +rxt(183)*y(22) + &
                 rxt(186)*y(16) +rxt(187)*y(9) +2.000_r8*rxt(189)*y(29) + &
                 rxt(191)*y(29) +rxt(211)*y(37))*y(29) + (rxt(223)*y(41) + &
                 3.000_r8*rxt(224)*y(48) +rxt(225)*y(46) +rxt(228)*y(51) + &
                 rxt(229)*y(52) +rxt(194)*y(32))*y(22) + (rxt(28) +rxt(195)*y(2)) &
                 *y(32) +2.000_r8*rxt(23)*y(28) +2.000_r8*rxt(26)*y(31) +rxt(27)*y(33) &
                  +rxt(29)*y(34) +rxt(31)*y(35) +rxt(56)*y(60)
         loss(6) = ( + rxt(23) + het_rates(28))* y(28)
         prod(6) = (rxt(250)*y(34) +rxt(251)*y(33) +rxt(255)*y(34) +rxt(256)*y(33) + &
                 rxt(261)*y(34) +rxt(262)*y(33))*y(32) +rxt(201)*y(34)*y(27) &
                  +rxt(190)*y(29)*y(29)
         loss(37) = (rxt(182)* y(2) +rxt(187)* y(9) +rxt(188)* y(10) +rxt(186)* y(16) &
                  + (rxt(183) +rxt(184))* y(22) +rxt(185)* y(23) + 2._r8*(rxt(189) + &
                 rxt(190) +rxt(191) +rxt(192))* y(29) + (rxt(210) +rxt(211) +rxt(212)) &
                 * y(37) + rxt(24) + het_rates(29))* y(29)
         prod(37) = (rxt(175)*y(1) +rxt(179)*y(23) +rxt(197)*y(33))*y(27) &
                  + (rxt(196)*y(33) +rxt(199)*y(34))*y(2) +rxt(198)*y(33)*y(22) &
                  +rxt(25)*y(30) +2.000_r8*rxt(193)*y(31) +rxt(30)*y(34)
         loss(4) = ( + rxt(25) + het_rates(30))* y(30)
         prod(4) = (rxt(191)*y(29) +rxt(210)*y(37))*y(29)
         loss(1) = ( + rxt(26) + rxt(193) + het_rates(31))* y(31)
         prod(1) =rxt(192)*y(29)*y(29)
         loss(46) = (rxt(195)* y(2) +rxt(131)* y(3) +rxt(194)* y(22) + (rxt(251) + &
                 rxt(256) +rxt(262))* y(33) + (rxt(250) +rxt(255) +rxt(261))* y(34) &
                  + (rxt(252) +rxt(263))* y(39) + rxt(28) + het_rates(32))* y(32)
         prod(46) = (rxt(181)*y(15) +2.000_r8*rxt(222)*y(41) +rxt(227)*y(42) + &
                 rxt(232)*y(58) +rxt(233)*y(57) +rxt(176)*y(20) +rxt(177)*y(24) + &
                 rxt(178)*y(23) +rxt(180)*y(18) +rxt(197)*y(33))*y(27) +rxt(184)*y(29) &
                 *y(22)
         loss(29) = (rxt(196)* y(2) +rxt(198)* y(22) +rxt(197)* y(27) + (rxt(251) + &
                 rxt(256) +rxt(262))* y(32) + rxt(27) + het_rates(33))* y(33)
         prod(29) = (rxt(248) +rxt(254) +rxt(259) +rxt(200)*y(22))*y(34) &
                  +rxt(185)*y(29)*y(23)
         loss(30) = (rxt(199)* y(2) +rxt(200)* y(22) +rxt(201)* y(27) + (rxt(250) + &
                 rxt(255) +rxt(261))* y(32) + rxt(29) + rxt(30) + rxt(248) + rxt(254) &
                  + rxt(259) + het_rates(34))* y(34)
         prod(30) =rxt(188)*y(29)*y(10)
         loss(8) = ( + rxt(31) + het_rates(35))* y(35)
         prod(8) = (rxt(252)*y(39) +rxt(263)*y(39))*y(32) +rxt(212)*y(37)*y(29)
         loss(39) = (rxt(202)* y(1) +rxt(204)* y(18) +rxt(203)* y(23) + het_rates(36)) &
                 * y(36)
         prod(39) = (rxt(118)*y(42) +rxt(119)*y(50) +rxt(120)*y(49) + &
                 2.000_r8*rxt(121)*y(55) +2.000_r8*rxt(122)*y(56) + &
                 3.000_r8*rxt(123)*y(57) +2.000_r8*rxt(124)*y(58) +rxt(132)*y(38)) &
                 *y(3) + (rxt(32) +rxt(205)*y(2) +rxt(206)*y(22) +rxt(208)*y(9) + &
                 rxt(210)*y(29) +rxt(211)*y(29) +2.000_r8*rxt(213)*y(37))*y(37) &
                  + (rxt(226)*y(42) +2.000_r8*rxt(230)*y(58) + &
                 3.000_r8*rxt(231)*y(57) +rxt(214)*y(38))*y(22) + (rxt(227)*y(42) + &
                 2.000_r8*rxt(232)*y(58) +3.000_r8*rxt(233)*y(57))*y(27) + (rxt(34) + &
                 rxt(215)*y(2))*y(38) +rxt(31)*y(35) +rxt(33)*y(39) +rxt(35)*y(40)
         loss(36) = (rxt(205)* y(2) +rxt(208)* y(9) +rxt(209)* y(10) +rxt(206)* y(22) &
                  +rxt(207)* y(23) + (rxt(210) +rxt(211) +rxt(212))* y(29) &
                  + 2._r8*rxt(213)* y(37) + rxt(32) + het_rates(37))* y(37)
         prod(36) = (rxt(216)*y(39) +rxt(217)*y(40))*y(2) +rxt(202)*y(36)*y(1) &
                  +rxt(36)*y(40)
         loss(27) = (rxt(215)* y(2) +rxt(132)* y(3) +rxt(214)* y(22) + rxt(34) &
                  + het_rates(38))* y(38)
         prod(27) = (rxt(203)*y(23) +rxt(204)*y(18))*y(36)
         loss(22) = (rxt(216)* y(2) + (rxt(252) +rxt(263))* y(32) + rxt(33) &
                  + het_rates(39))* y(39)
         prod(22) = (rxt(249) +rxt(257) +rxt(260))*y(40) +rxt(207)*y(37)*y(23)
         loss(17) = (rxt(217)* y(2) + rxt(35) + rxt(36) + rxt(249) + rxt(257) &
                  + rxt(260) + het_rates(40))* y(40)
         prod(17) =rxt(209)*y(37)*y(10)
         loss(20) = ((rxt(266) +rxt(267))* y(2) +rxt(274)* y(4) +rxt(278)* y(69) &
                  + het_rates(64))* y(64)
         prod(20) =rxt(279)*y(71) +rxt(286)*y(72)
         loss(23) = (rxt(269)* y(8) +rxt(270)* y(9) +rxt(277)* y(69) + rxt(275) &
                  + het_rates(65))* y(65)
         prod(23) = (rxt(67) +rxt(79) +rxt(264)*y(67) +rxt(271)*y(66) + &
                 rxt(274)*y(64) +rxt(285)*y(72))*y(4) +rxt(268)*y(67)*y(63)
         loss(19) = (rxt(273)* y(2) + (rxt(271) +rxt(272))* y(4) + het_rates(66)) &
                 * y(66)
         prod(19) =rxt(66)*y(8) +rxt(280)*y(71)
         loss(21) = (rxt(264)* y(4) +rxt(268)* y(63) + rxt(265) + het_rates(67)) &
                 * y(67)
         prod(21) = (rxt(63) +rxt(76) +rxt(267)*y(64) +rxt(273)*y(66) + &
                 rxt(281)*y(71) +rxt(284)*y(72))*y(2) + (rxt(69) +rxt(81))*y(4) &
                  + (rxt(283)*y(71) +rxt(287)*y(72))*y(69) +rxt(288)*y(71) +rxt(290) &
                 *y(72)
         loss(24) = (rxt(276)* y(69) + het_rates(68))* y(68)
         prod(24) = (rxt(275) +rxt(269)*y(8) +rxt(270)*y(9))*y(65) +rxt(266)*y(64) &
                 *y(2) +rxt(272)*y(66)*y(4) +rxt(7)*y(9) +rxt(265)*y(67)
         loss(15) = (rxt(151)* y(2) +rxt(150)* y(4) + het_rates(70))* y(70)
         prod(15) = (rxt(266)*y(2) +.900_r8*rxt(278)*y(69))*y(64) &
                  +.800_r8*rxt(276)*y(69)*y(68)
         loss(25) = (rxt(278)* y(64) +rxt(277)* y(65) +rxt(276)* y(68) &
                  + het_rates(69))* y(69)
         prod(25) = (rxt(67) +rxt(69) +rxt(70) +rxt(71) +rxt(79) +rxt(81) +rxt(82) + &
                 rxt(83))*y(4) + (rxt(63) +rxt(64) +rxt(65) +rxt(76) +rxt(77) + &
                 rxt(78))*y(2) +rxt(66)*y(8) +rxt(7)*y(9)
         loss(13) = (rxt(281)* y(2) + (rxt(282) +rxt(283))* y(69) + rxt(279) &
                  + rxt(280) + rxt(288) + rxt(289) + het_rates(71))* y(71)
         prod(13) = (rxt(65) +rxt(78))*y(2) + (rxt(71) +rxt(83))*y(4)
         loss(14) = (rxt(284)* y(2) +rxt(285)* y(4) +rxt(287)* y(69) + rxt(286) &
                  + rxt(290) + het_rates(72))* y(72)
         prod(14) = (rxt(64) +rxt(77))*y(2) + (rxt(70) +rxt(82))*y(4) + (rxt(289) + &
                 rxt(282)*y(69))*y(71)
         loss(5) = (rxt(125)* y(3) + rxt(55) + het_rates(59))* y(59)
         prod(5) = (rxt(110)*y(44) +rxt(111)*y(45) +2.000_r8*rxt(112)*y(53) + &
                 2.000_r8*rxt(113)*y(54) +rxt(114)*y(46) +rxt(116)*y(52) + &
                 rxt(119)*y(50) +rxt(120)*y(49) +rxt(121)*y(55) + &
                 2.000_r8*rxt(122)*y(56))*y(3) + (rxt(225)*y(46) +rxt(229)*y(52)) &
                 *y(22)
         loss(7) = (rxt(126)* y(3) + rxt(56) + het_rates(60))* y(60)
         prod(7) = (rxt(109)*y(43) +rxt(111)*y(45) +rxt(115)*y(51))*y(3) &
                  +rxt(228)*y(51)*y(22)
         loss(9) = ( + rxt(57) + het_rates(61))* y(61)
         prod(9) = (rxt(220)*y(15) +rxt(218)*y(87) +rxt(219)*y(20) +rxt(221)*y(12)) &
                 *y(62)
         loss(26) = (rxt(221)* y(12) +rxt(220)* y(15) +rxt(219)* y(20) +rxt(218) &
                 * y(87) + het_rates(62))* y(62)
         prod(26) = (rxt(113)*y(54) +rxt(120)*y(49) +2.000_r8*rxt(125)*y(59) + &
                 rxt(126)*y(60))*y(3) +2.000_r8*rxt(55)*y(59) +rxt(56)*y(60) +rxt(57) &
                 *y(61)

      end subroutine imp_prod_loss

      end module mo_prod_loss
