




      module mo_nln_matrix

      use shr_kind_mod, only : r8 => shr_kind_r8

      private
      public :: nlnmat

      contains

      subroutine nlnmat01( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(1018) = -(rxt(119)*y(2) + rxt(137)*y(3) + rxt(164)*y(22) + rxt(169)*y(23) &
                      + rxt(177)*y(24) + rxt(192)*y(9) + rxt(195)*y(10) + rxt(207) &
                      *y(28) + rxt(234)*y(37) + rxt(293)*y(44) + rxt(314)*y(59) &
                      + rxt(336)*y(77) + rxt(342)*y(78) + rxt(360)*y(83) + rxt(392) &
                      *y(99) + rxt(405)*y(138) + rxt(408)*y(139))
         mat(947) = -rxt(119)*y(1)
         mat(973) = -rxt(137)*y(1)
         mat(1474) = -rxt(164)*y(1)
         mat(1388) = -rxt(169)*y(1)
         mat(1175) = -rxt(177)*y(1)
         mat(1254) = -rxt(192)*y(1)
         mat(1291) = -rxt(195)*y(1)
         mat(1106) = -rxt(207)*y(1)
         mat(845) = -rxt(234)*y(1)
         mat(237) = -rxt(293)*y(1)
         mat(593) = -rxt(314)*y(1)
         mat(747) = -rxt(336)*y(1)
         mat(641) = -rxt(342)*y(1)
         mat(528) = -rxt(360)*y(1)
         mat(300) = -rxt(392)*y(1)
         mat(379) = -rxt(405)*y(1)
         mat(811) = -rxt(408)*y(1)

         mat(1018) = mat(1018) + .100_r8*rxt(360)*y(83) + .200_r8*rxt(336)*y(77) &
                      + .200_r8*rxt(342)*y(78)
         mat(947) = mat(947) + rxt(118)*y(4)
         mat(908) = rxt(118)*y(2)
         mat(1175) = mat(1175) + .250_r8*rxt(304)*y(48) + .250_r8*rxt(352)*y(76)
         mat(528) = mat(528) + .100_r8*rxt(360)*y(1)
         mat(794) = .250_r8*rxt(304)*y(24)
         mat(747) = mat(747) + .200_r8*rxt(336)*y(1)
         mat(641) = mat(641) + .200_r8*rxt(342)*y(1)
         mat(766) = .250_r8*rxt(352)*y(24)

         mat(945) = -(rxt(118)*y(4) + rxt(119)*y(1) + 4._r8*rxt(120)*y(2) + rxt(168) &
                      *y(23) + rxt(175)*y(21) + rxt(176)*y(24) + rxt(179)*y(25) &
                      + rxt(190)*y(9) + (rxt(193) + rxt(194)) * y(10) + rxt(201)*y(11) &
                      + rxt(214)*y(30) + rxt(227)*y(33) + rxt(228)*y(34) + rxt(231) &
                      *y(35) + rxt(237)*y(38) + rxt(247)*y(39) + rxt(248)*y(40) &
                      + rxt(249)*y(41) + rxt(271)*y(19) + rxt(401)*y(137) + (rxt(437) &
                      + rxt(438)) * y(121) + rxt(444)*y(123))
         mat(906) = -rxt(118)*y(2)
         mat(1016) = -rxt(119)*y(2)
         mat(1386) = -rxt(168)*y(2)
         mat(652) = -rxt(175)*y(2)
         mat(1173) = -rxt(176)*y(2)
         mat(314) = -rxt(179)*y(2)
         mat(1252) = -rxt(190)*y(2)
         mat(1289) = -(rxt(193) + rxt(194)) * y(2)
         mat(1430) = -rxt(201)*y(2)
         mat(1043) = -rxt(214)*y(2)
         mat(828) = -rxt(227)*y(2)
         mat(498) = -rxt(228)*y(2)
         mat(575) = -rxt(231)*y(2)
         mat(1197) = -rxt(237)*y(2)
         mat(464) = -rxt(247)*y(2)
         mat(400) = -rxt(248)*y(2)
         mat(283) = -rxt(249)*y(2)
         mat(1496) = -rxt(271)*y(2)
         mat(147) = -rxt(401)*y(2)
         mat(351) = -(rxt(437) + rxt(438)) * y(2)
         mat(200) = -rxt(444)*y(2)

         mat(971) = (rxt(132)+rxt(133))*y(4)
         mat(906) = mat(906) + (rxt(132)+rxt(133))*y(3) + rxt(185)*y(8) + rxt(443) &
                      *y(123) + rxt(435)*y(124) + rxt(404)*y(138) + rxt(407)*y(139)
         mat(489) = rxt(185)*y(4) + rxt(186)*y(9) + rxt(187)*y(10) + rxt(440)*y(122)
         mat(1252) = mat(1252) + rxt(186)*y(8)
         mat(1289) = mat(1289) + rxt(187)*y(8)
         mat(1386) = mat(1386) + 2.000_r8*rxt(171)*y(23)
         mat(1472) = rxt(167)*y(24)
         mat(1173) = mat(1173) + rxt(167)*y(22)
         mat(419) = rxt(440)*y(8) + 1.150_r8*rxt(448)*y(126)
         mat(200) = mat(200) + rxt(443)*y(4)
         mat(311) = rxt(435)*y(4)
         mat(427) = rxt(447)*y(126)
         mat(438) = 1.150_r8*rxt(448)*y(122) + rxt(447)*y(125)
         mat(378) = rxt(404)*y(4)
         mat(810) = rxt(407)*y(4)

         mat(972) = -((rxt(132) + rxt(133)) * y(4) + rxt(134)*y(158) + rxt(137)*y(1) &
                      + rxt(154)*y(131) + rxt(155)*y(132) + rxt(159)*y(21) + rxt(160) &
                      *y(33) + rxt(161)*y(39) + rxt(162)*y(42))
         mat(907) = -(rxt(132) + rxt(133)) * y(3)
         mat(1070) = -rxt(134)*y(3)
         mat(1017) = -rxt(137)*y(3)
         mat(46) = -rxt(154)*y(3)
         mat(67) = -rxt(155)*y(3)
         mat(653) = -rxt(159)*y(3)
         mat(829) = -rxt(160)*y(3)
         mat(465) = -rxt(161)*y(3)
         mat(58) = -rxt(162)*y(3)

         mat(907) = mat(907) + rxt(182)*y(127)
         mat(420) = .850_r8*rxt(448)*y(126)
         mat(225) = rxt(182)*y(4)
         mat(439) = .850_r8*rxt(448)*y(122)

         mat(905) = -(rxt(118)*y(2) + rxt(128)*y(6) + rxt(132)*y(3) + rxt(163)*y(22) &
                      + rxt(182)*y(127) + rxt(185)*y(8) + rxt(291)*y(56) + rxt(404) &
                      *y(138) + rxt(407)*y(139) + rxt(435)*y(124) + (rxt(442) + rxt(443) &
                      ) * y(123) + rxt(445)*y(121))
         mat(944) = -rxt(118)*y(4)
         mat(51) = -rxt(128)*y(4)
         mat(970) = -rxt(132)*y(4)
         mat(1471) = -rxt(163)*y(4)
         mat(224) = -rxt(182)*y(4)
         mat(488) = -rxt(185)*y(4)
         mat(191) = -rxt(291)*y(4)
         mat(377) = -rxt(404)*y(4)
         mat(809) = -rxt(407)*y(4)
         mat(310) = -rxt(435)*y(4)
         mat(199) = -(rxt(442) + rxt(443)) * y(4)
         mat(350) = -rxt(445)*y(4)

         mat(1015) = 2.000_r8*rxt(119)*y(2) + 2.000_r8*rxt(137)*y(3) + rxt(192)*y(9) &
                      + rxt(195)*y(10) + rxt(169)*y(23) + rxt(164)*y(22) &
                      + 2.000_r8*rxt(177)*y(24) + rxt(207)*y(28) + rxt(234)*y(37) &
                      + rxt(405)*y(138) + rxt(408)*y(139)
         mat(944) = mat(944) + 2.000_r8*rxt(119)*y(1) + 2.000_r8*rxt(120)*y(2) &
                      + rxt(127)*y(6) + rxt(193)*y(10) + rxt(168)*y(23) + rxt(201) &
                      *y(11) + rxt(176)*y(24) + rxt(214)*y(30) + rxt(237)*y(38)
         mat(970) = mat(970) + 2.000_r8*rxt(137)*y(1)
         mat(905) = mat(905) + 2.000_r8*rxt(128)*y(6)
         mat(51) = mat(51) + rxt(127)*y(2) + 2.000_r8*rxt(128)*y(4)
         mat(488) = mat(488) + rxt(189)*y(10)
         mat(1251) = rxt(192)*y(1) + rxt(441)*y(122)
         mat(1288) = rxt(195)*y(1) + rxt(193)*y(2) + rxt(189)*y(8)
         mat(1385) = rxt(169)*y(1) + rxt(168)*y(2) + rxt(205)*y(13) + rxt(170)*y(24) &
                      + rxt(216)*y(30)
         mat(1429) = rxt(201)*y(2) + rxt(203)*y(24)
         mat(216) = rxt(205)*y(23)
         mat(875) = rxt(274)*y(24)
         mat(1471) = mat(1471) + rxt(164)*y(1) + rxt(166)*y(24)
         mat(1172) = 2.000_r8*rxt(177)*y(1) + rxt(176)*y(2) + rxt(170)*y(23) &
                      + rxt(203)*y(11) + rxt(274)*y(16) + rxt(166)*y(22) &
                      + 2.000_r8*rxt(178)*y(24) + rxt(210)*y(28) + rxt(217)*y(30) &
                      + rxt(235)*y(37) + rxt(239)*y(38) + rxt(322)*y(64) &
                      + .750_r8*rxt(352)*y(76) + rxt(296)*y(46) + rxt(317)*y(61) &
                      + rxt(326)*y(67)
         mat(1103) = rxt(207)*y(1) + rxt(210)*y(24)
         mat(1042) = rxt(214)*y(2) + rxt(216)*y(23) + rxt(217)*y(24) + ( &
                      + 2.000_r8*rxt(221)+2.000_r8*rxt(222))*y(30) + (rxt(243) &
                       +rxt(244))*y(38)
         mat(842) = rxt(234)*y(1) + rxt(235)*y(24)
         mat(1196) = rxt(237)*y(2) + rxt(239)*y(24) + (rxt(243)+rxt(244))*y(30) &
                      + 2.000_r8*rxt(245)*y(38)
         mat(418) = rxt(441)*y(9)
         mat(445) = rxt(322)*y(24)
         mat(765) = .750_r8*rxt(352)*y(24)
         mat(475) = rxt(296)*y(24)
         mat(510) = rxt(317)*y(24)
         mat(622) = rxt(326)*y(24)
         mat(377) = mat(377) + rxt(405)*y(1)
         mat(809) = mat(809) + rxt(408)*y(1)

         mat(53) = -(rxt(121)*y(2) + rxt(122)*y(4) + rxt(124)*y(1))
         mat(920) = -rxt(121)*y(5)
         mat(889) = -rxt(122)*y(5)
         mat(987) = -rxt(124)*y(5)

         mat(961) = rxt(132)*y(4)
         mat(889) = mat(889) + rxt(132)*y(3)

         mat(50) = -(rxt(127)*y(2) + rxt(128)*y(4))
         mat(919) = -rxt(127)*y(6)
         mat(888) = -rxt(128)*y(6)

         mat(986) = rxt(124)*y(5)
         mat(919) = mat(919) + rxt(121)*y(5)
         mat(888) = mat(888) + rxt(122)*y(5)
         mat(52) = rxt(124)*y(1) + rxt(121)*y(2) + rxt(122)*y(4)

         mat(649) = -(rxt(159)*y(3) + rxt(173)*y(23) + rxt(175)*y(2) + rxt(208)*y(28) &
                      + rxt(251)*y(134))
         mat(966) = -rxt(159)*y(21)
         mat(1373) = -rxt(173)*y(21)
         mat(939) = -rxt(175)*y(21)
         mat(1098) = -rxt(208)*y(21)
         mat(407) = -rxt(251)*y(21)

         mat(1467) = rxt(166)*y(24)
         mat(1161) = rxt(166)*y(22)

         mat(601) = -((rxt(267) + rxt(268)) * y(23))
         mat(1368) = -(rxt(267) + rxt(268)) * y(20)

         mat(1000) = .560_r8*rxt(314)*y(59) + .300_r8*rxt(360)*y(83) &
                      + .500_r8*rxt(293)*y(44) + .050_r8*rxt(336)*y(77) &
                      + .200_r8*rxt(342)*y(78)
         mat(938) = rxt(271)*y(19) + rxt(401)*y(137)
         mat(1237) = .220_r8*rxt(343)*y(79) + .250_r8*rxt(378)*y(91)
         mat(1368) = mat(1368) + rxt(270)*y(19) + rxt(309)*y(53) + rxt(330)*y(68) &
                      + .350_r8*rxt(286)*y(128) + rxt(402)*y(137)
         mat(1414) = rxt(269)*y(19) + .220_r8*rxt(345)*y(79) + rxt(331)*y(68) &
                      + .500_r8*rxt(379)*y(91)
         mat(862) = .110_r8*rxt(347)*y(79) + .200_r8*rxt(381)*y(91)
         mat(1490) = rxt(271)*y(2) + rxt(270)*y(23) + rxt(269)*y(11) + rxt(212)*y(28) &
                      + rxt(236)*y(37)
         mat(1096) = rxt(212)*y(19)
         mat(840) = rxt(236)*y(19)
         mat(587) = .560_r8*rxt(314)*y(1)
         mat(522) = .300_r8*rxt(360)*y(1)
         mat(782) = .220_r8*rxt(348)*y(79) + .250_r8*rxt(382)*y(91)
         mat(236) = .500_r8*rxt(293)*y(1)
         mat(383) = rxt(309)*y(23)
         mat(737) = .050_r8*rxt(336)*y(1)
         mat(635) = .200_r8*rxt(342)*y(1)
         mat(719) = .220_r8*rxt(343)*y(9) + .220_r8*rxt(345)*y(11) + .110_r8*rxt(347) &
                      *y(16) + .220_r8*rxt(348)*y(48)
         mat(660) = rxt(330)*y(23) + rxt(331)*y(11)
         mat(673) = .250_r8*rxt(378)*y(9) + .500_r8*rxt(379)*y(11) + .200_r8*rxt(381) &
                      *y(16) + .250_r8*rxt(382)*y(48)
         mat(97) = .350_r8*rxt(286)*y(23)
         mat(145) = rxt(401)*y(2) + rxt(402)*y(23)

         mat(486) = -(rxt(184)*y(23) + rxt(185)*y(4) + rxt(186)*y(9) + (rxt(187) &
                      + rxt(188) + rxt(189)) * y(10) + rxt(440)*y(122))
         mat(1358) = -rxt(184)*y(8)
         mat(899) = -rxt(185)*y(8)
         mat(1232) = -rxt(186)*y(8)
         mat(1276) = -(rxt(187) + rxt(188) + rxt(189)) * y(8)
         mat(417) = -rxt(440)*y(8)

         mat(934) = rxt(444)*y(123) + rxt(183)*y(127)
         mat(899) = mat(899) + rxt(442)*y(123)
         mat(348) = 1.100_r8*rxt(449)*y(126)
         mat(198) = rxt(444)*y(2) + rxt(442)*y(4)
         mat(425) = .200_r8*rxt(447)*y(126)
         mat(223) = rxt(183)*y(2)
         mat(435) = 1.100_r8*rxt(449)*y(121) + .200_r8*rxt(447)*y(125)


      end subroutine nlnmat01

      subroutine nlnmat02( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(1260) = -(rxt(186)*y(8) + rxt(190)*y(2) + rxt(191)*y(24) + rxt(192)*y(1) &
                      + rxt(200)*y(11) + rxt(219)*y(30) + rxt(240)*y(38) + rxt(273) &
                      *y(16) + rxt(281)*y(130) + rxt(289)*y(55) + rxt(295)*y(46) &
                      + rxt(302)*y(48) + rxt(316)*y(61) + rxt(321)*y(64) + rxt(325) &
                      *y(67) + rxt(334)*y(73) + rxt(338)*y(74) + (rxt(343) + rxt(344) &
                      ) * y(79) + rxt(350)*y(76) + rxt(362)*y(88) + rxt(368)*y(89) &
                      + rxt(375)*y(84) + rxt(378)*y(91) + rxt(386)*y(96) + rxt(394) &
                      *y(100) + rxt(441)*y(122))
         mat(491) = -rxt(186)*y(9)
         mat(953) = -rxt(190)*y(9)
         mat(1181) = -rxt(191)*y(9)
         mat(1024) = -rxt(192)*y(9)
         mat(1438) = -rxt(200)*y(9)
         mat(1051) = -rxt(219)*y(9)
         mat(1205) = -rxt(240)*y(9)
         mat(881) = -rxt(273)*y(9)
         mat(181) = -rxt(281)*y(9)
         mat(392) = -rxt(289)*y(9)
         mat(477) = -rxt(295)*y(9)
         mat(797) = -rxt(302)*y(9)
         mat(513) = -rxt(316)*y(9)
         mat(448) = -rxt(321)*y(9)
         mat(625) = -rxt(325)*y(9)
         mat(116) = -rxt(334)*y(9)
         mat(339) = -rxt(338)*y(9)
         mat(729) = -(rxt(343) + rxt(344)) * y(9)
         mat(769) = -rxt(350)*y(9)
         mat(708) = -rxt(362)*y(9)
         mat(457) = -rxt(368)*y(9)
         mat(365) = -rxt(375)*y(9)
         mat(681) = -rxt(378)*y(9)
         mat(251) = -rxt(386)*y(9)
         mat(568) = -rxt(394)*y(9)
         mat(421) = -rxt(441)*y(9)

         mat(953) = mat(953) + rxt(193)*y(10)
         mat(914) = rxt(185)*y(8) + rxt(182)*y(127)
         mat(491) = mat(491) + rxt(185)*y(4) + 2.000_r8*rxt(188)*y(10) + rxt(184) &
                      *y(23)
         mat(1297) = rxt(193)*y(2) + 2.000_r8*rxt(188)*y(8) + rxt(409)*y(139)
         mat(1394) = rxt(184)*y(8)
         mat(226) = rxt(182)*y(4)
         mat(817) = rxt(409)*y(10)

         mat(1298) = -((rxt(187) + rxt(188) + rxt(189)) * y(8) + (rxt(193) + rxt(194) &
                      ) * y(2) + rxt(195)*y(1) + rxt(196)*y(11) + rxt(198)*y(23) &
                      + rxt(204)*y(24) + rxt(220)*y(30) + rxt(241)*y(38) + rxt(303) &
                      *y(48) + rxt(356)*y(76) + rxt(390)*y(98) + rxt(409)*y(139))
         mat(492) = -(rxt(187) + rxt(188) + rxt(189)) * y(10)
         mat(954) = -(rxt(193) + rxt(194)) * y(10)
         mat(1025) = -rxt(195)*y(10)
         mat(1439) = -rxt(196)*y(10)
         mat(1395) = -rxt(198)*y(10)
         mat(1182) = -rxt(204)*y(10)
         mat(1052) = -rxt(220)*y(10)
         mat(1206) = -rxt(241)*y(10)
         mat(798) = -rxt(303)*y(10)
         mat(770) = -rxt(356)*y(10)
         mat(64) = -rxt(390)*y(10)
         mat(818) = -rxt(409)*y(10)

         mat(1025) = mat(1025) + rxt(192)*y(9)
         mat(954) = mat(954) + rxt(190)*y(9) + rxt(201)*y(11)
         mat(1261) = rxt(192)*y(1) + rxt(190)*y(2) + 2.000_r8*rxt(200)*y(11) &
                      + rxt(273)*y(16) + rxt(191)*y(24) + rxt(219)*y(30) + rxt(240) &
                      *y(38) + rxt(321)*y(64) + rxt(302)*y(48) + rxt(334)*y(73) &
                      + .900_r8*rxt(375)*y(84) + rxt(338)*y(74) + .900_r8*rxt(386) &
                      *y(96) + rxt(394)*y(100) + .920_r8*rxt(362)*y(88) + rxt(343) &
                      *y(79) + rxt(350)*y(76) + rxt(295)*y(46) + rxt(316)*y(61) &
                      + rxt(289)*y(55) + rxt(325)*y(67) + 1.206_r8*rxt(368)*y(89) &
                      + rxt(378)*y(91) + rxt(281)*y(130)
         mat(1298) = mat(1298) + .700_r8*rxt(390)*y(98)
         mat(1395) = mat(1395) + rxt(202)*y(11) + rxt(205)*y(13) + rxt(332)*y(82) &
                      + .400_r8*rxt(372)*y(90)
         mat(1439) = mat(1439) + rxt(201)*y(2) + 2.000_r8*rxt(200)*y(9) + rxt(202) &
                      *y(23) + rxt(203)*y(24) + rxt(363)*y(88) + rxt(345)*y(79) &
                      + rxt(351)*y(76) + rxt(393)*y(99) + 1.206_r8*rxt(369)*y(89) &
                      + rxt(373)*y(90) + rxt(379)*y(91)
         mat(219) = rxt(205)*y(23)
         mat(882) = rxt(273)*y(9)
         mat(1182) = mat(1182) + rxt(191)*y(9) + rxt(203)*y(11) + .206_r8*rxt(370) &
                      *y(89)
         mat(1052) = mat(1052) + rxt(219)*y(9)
         mat(1206) = mat(1206) + rxt(240)*y(9)
         mat(449) = rxt(321)*y(9)
         mat(798) = mat(798) + rxt(302)*y(9)
         mat(152) = rxt(332)*y(23)
         mat(117) = rxt(334)*y(9)
         mat(366) = .900_r8*rxt(375)*y(9)
         mat(340) = rxt(338)*y(9)
         mat(252) = .900_r8*rxt(386)*y(9)
         mat(64) = mat(64) + .700_r8*rxt(390)*y(10)
         mat(569) = rxt(394)*y(9)
         mat(709) = .920_r8*rxt(362)*y(9) + rxt(363)*y(11)
         mat(730) = rxt(343)*y(9) + rxt(345)*y(11)
         mat(770) = mat(770) + rxt(350)*y(9) + rxt(351)*y(11)
         mat(478) = rxt(295)*y(9)
         mat(302) = rxt(393)*y(11)
         mat(514) = rxt(316)*y(9)
         mat(393) = rxt(289)*y(9)
         mat(626) = rxt(325)*y(9)
         mat(458) = 1.206_r8*rxt(368)*y(9) + 1.206_r8*rxt(369)*y(11) &
                      + .206_r8*rxt(370)*y(24)
         mat(547) = .400_r8*rxt(372)*y(23) + rxt(373)*y(11)
         mat(682) = rxt(378)*y(9) + rxt(379)*y(11)
         mat(182) = rxt(281)*y(9)

         mat(1396) = -(rxt(168)*y(2) + rxt(169)*y(1) + rxt(170)*y(24) + (4._r8*rxt(171) &
                      + 4._r8*rxt(172)) * y(23) + rxt(173)*y(21) + rxt(174)*y(25) &
                      + rxt(180)*y(42) + rxt(181)*y(43) + rxt(184)*y(8) + rxt(198) &
                      *y(10) + rxt(199)*y(12) + rxt(202)*y(11) + rxt(205)*y(13) &
                      + (rxt(215) + rxt(216)) * y(30) + rxt(226)*y(33) + rxt(230) &
                      *y(34) + rxt(232)*y(35) + rxt(238)*y(38) + rxt(246)*y(39) &
                      + (rxt(267) + rxt(268)) * y(20) + rxt(270)*y(19) + rxt(277) &
                      *y(18) + rxt(278)*y(17) + rxt(279)*y(129) + rxt(286)*y(128) &
                      + rxt(287)*y(45) + rxt(288)*y(44) + rxt(294)*y(49) + rxt(299) &
                      *y(47) + rxt(300)*y(50) + rxt(307)*y(54) + rxt(308)*y(52) &
                      + rxt(309)*y(53) + rxt(310)*y(51) + rxt(312)*y(58) + rxt(313) &
                      *y(59) + rxt(319)*y(62) + rxt(320)*y(60) + rxt(323)*y(65) &
                      + rxt(324)*y(63) + rxt(328)*y(69) + rxt(329)*y(66) + rxt(330) &
                      *y(68) + rxt(332)*y(82) + rxt(333)*y(70) + rxt(335)*y(77) &
                      + rxt(337)*y(72) + rxt(340)*y(75) + rxt(341)*y(78) + rxt(349) &
                      *y(80) + rxt(358)*y(81) + rxt(359)*y(83) + rxt(365)*y(93) &
                      + rxt(371)*y(71) + rxt(372)*y(90) + rxt(374)*y(87) + rxt(377) &
                      *y(85) + rxt(383)*y(92) + rxt(385)*y(94) + rxt(388)*y(97) &
                      + rxt(389)*y(95) + rxt(391)*y(99) + rxt(396)*y(101) + rxt(402) &
                      *y(137) + rxt(403)*y(138) + rxt(406)*y(139) + rxt(413)*y(135) &
                      + (rxt(415) + rxt(416)) * y(136))
         mat(955) = -rxt(168)*y(23)
         mat(1026) = -rxt(169)*y(23)
         mat(1183) = -rxt(170)*y(23)
         mat(656) = -rxt(173)*y(23)
         mat(318) = -rxt(174)*y(23)
         mat(60) = -rxt(180)*y(23)
         mat(19) = -rxt(181)*y(23)
         mat(493) = -rxt(184)*y(23)
         mat(1299) = -rxt(198)*y(23)
         mat(1462) = -rxt(199)*y(23)
         mat(1440) = -rxt(202)*y(23)
         mat(220) = -rxt(205)*y(23)
         mat(1053) = -(rxt(215) + rxt(216)) * y(23)
         mat(835) = -rxt(226)*y(23)
         mat(502) = -rxt(230)*y(23)
         mat(580) = -rxt(232)*y(23)
         mat(1207) = -rxt(238)*y(23)
         mat(467) = -rxt(246)*y(23)
         mat(603) = -(rxt(267) + rxt(268)) * y(23)
         mat(1506) = -rxt(270)*y(23)
         mat(270) = -rxt(277)*y(23)
         mat(157) = -rxt(278)*y(23)
         mat(244) = -rxt(279)*y(23)
         mat(99) = -rxt(286)*y(23)
         mat(93) = -rxt(287)*y(23)
         mat(239) = -rxt(288)*y(23)
         mat(322) = -rxt(294)*y(23)
         mat(133) = -rxt(299)*y(23)
         mat(611) = -rxt(300)*y(23)
         mat(231) = -rxt(307)*y(23)
         mat(540) = -rxt(308)*y(23)
         mat(385) = -rxt(309)*y(23)
         mat(78) = -rxt(310)*y(23)
         mat(205) = -rxt(312)*y(23)
         mat(598) = -rxt(313)*y(23)
         mat(171) = -rxt(319)*y(23)
         mat(32) = -rxt(320)*y(23)
         mat(266) = -rxt(323)*y(23)
         mat(374) = -rxt(324)*y(23)
         mat(176) = -rxt(328)*y(23)
         mat(633) = -rxt(329)*y(23)
         mat(665) = -rxt(330)*y(23)
         mat(153) = -rxt(332)*y(23)
         mat(28) = -rxt(333)*y(23)
         mat(752) = -rxt(335)*y(23)
         mat(188) = -rxt(337)*y(23)
         mat(123) = -rxt(340)*y(23)
         mat(644) = -rxt(341)*y(23)
         mat(128) = -rxt(349)*y(23)
         mat(293) = -rxt(358)*y(23)
         mat(533) = -rxt(359)*y(23)
         mat(278) = -rxt(365)*y(23)
         mat(25) = -rxt(371)*y(23)
         mat(548) = -rxt(372)*y(23)
         mat(141) = -rxt(374)*y(23)
         mat(332) = -rxt(377)*y(23)
         mat(82) = -rxt(383)*y(23)
         mat(37) = -rxt(385)*y(23)
         mat(165) = -rxt(388)*y(23)
         mat(40) = -rxt(389)*y(23)
         mat(303) = -rxt(391)*y(23)
         mat(214) = -rxt(396)*y(23)
         mat(148) = -rxt(402)*y(23)
         mat(380) = -rxt(403)*y(23)
         mat(819) = -rxt(406)*y(23)
         mat(557) = -rxt(413)*y(23)
         mat(103) = -(rxt(415) + rxt(416)) * y(23)

         mat(1026) = mat(1026) + rxt(164)*y(22) + rxt(177)*y(24) + .330_r8*rxt(314) &
                      *y(59) + .270_r8*rxt(360)*y(83) + .120_r8*rxt(293)*y(44) &
                      + .080_r8*rxt(336)*y(77) + .215_r8*rxt(342)*y(78) &
                      + .700_r8*rxt(392)*y(99)
         mat(955) = mat(955) + rxt(175)*y(21) + rxt(271)*y(19) + rxt(176)*y(24) &
                      + rxt(179)*y(25) + rxt(227)*y(33) + rxt(228)*y(34) + rxt(247) &
                      *y(39) + rxt(248)*y(40)
         mat(981) = rxt(159)*y(21) + rxt(162)*y(42) + 2.000_r8*rxt(134)*y(158) &
                      + rxt(160)*y(33) + rxt(161)*y(39)
         mat(656) = mat(656) + rxt(175)*y(2) + rxt(159)*y(3)
         mat(1262) = rxt(191)*y(24)
         mat(1396) = mat(1396) + .300_r8*rxt(278)*y(17) + .500_r8*rxt(323)*y(65) &
                      + .100_r8*rxt(349)*y(80) + .500_r8*rxt(299)*y(47) &
                      + .650_r8*rxt(286)*y(128)
         mat(1440) = mat(1440) + rxt(203)*y(24)
         mat(157) = mat(157) + .300_r8*rxt(278)*y(23)
         mat(60) = mat(60) + rxt(162)*y(3)
         mat(1506) = mat(1506) + rxt(271)*y(2)
         mat(1482) = rxt(164)*y(1) + 2.000_r8*rxt(165)*y(24)
         mat(1183) = mat(1183) + rxt(177)*y(1) + rxt(176)*y(2) + rxt(191)*y(9) &
                      + rxt(203)*y(11) + 2.000_r8*rxt(165)*y(22) + rxt(211)*y(28) &
                      + .206_r8*rxt(370)*y(89)
         mat(318) = mat(318) + rxt(179)*y(2)
         mat(1079) = 2.000_r8*rxt(134)*y(3) + rxt(250)*y(134)
         mat(1114) = rxt(211)*y(24)
         mat(835) = mat(835) + rxt(227)*y(2) + rxt(160)*y(3)
         mat(502) = mat(502) + rxt(228)*y(2)
         mat(467) = mat(467) + rxt(247)*y(2) + rxt(161)*y(3)
         mat(404) = rxt(248)*y(2)
         mat(598) = mat(598) + .330_r8*rxt(314)*y(1)
         mat(533) = mat(533) + .270_r8*rxt(360)*y(1)
         mat(266) = mat(266) + .500_r8*rxt(323)*y(23)
         mat(239) = mat(239) + .120_r8*rxt(293)*y(1)
         mat(752) = mat(752) + .080_r8*rxt(336)*y(1)
         mat(644) = mat(644) + .215_r8*rxt(342)*y(1)
         mat(128) = mat(128) + .100_r8*rxt(349)*y(23)
         mat(133) = mat(133) + .500_r8*rxt(299)*y(23)
         mat(303) = mat(303) + .700_r8*rxt(392)*y(1)
         mat(459) = .206_r8*rxt(370)*y(24)
         mat(99) = mat(99) + .650_r8*rxt(286)*y(23)
         mat(410) = rxt(250)*y(158)


      end subroutine nlnmat02

      subroutine nlnmat03( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(1441) = -(rxt(196)*y(10) + rxt(200)*y(9) + rxt(201)*y(2) + rxt(202)*y(23) &
                      + rxt(203)*y(24) + rxt(269)*y(19) + rxt(301)*y(50) + rxt(315) &
                      *y(59) + rxt(331)*y(68) + rxt(345)*y(79) + rxt(351)*y(76) &
                      + rxt(361)*y(83) + rxt(363)*y(88) + rxt(369)*y(89) + rxt(373) &
                      *y(90) + rxt(379)*y(91) + rxt(393)*y(99) + rxt(417)*y(136))
         mat(1300) = -rxt(196)*y(11)
         mat(1263) = -rxt(200)*y(11)
         mat(956) = -rxt(201)*y(11)
         mat(1397) = -rxt(202)*y(11)
         mat(1184) = -rxt(203)*y(11)
         mat(1507) = -rxt(269)*y(11)
         mat(612) = -rxt(301)*y(11)
         mat(599) = -rxt(315)*y(11)
         mat(666) = -rxt(331)*y(11)
         mat(732) = -rxt(345)*y(11)
         mat(772) = -rxt(351)*y(11)
         mat(534) = -rxt(361)*y(11)
         mat(711) = -rxt(363)*y(11)
         mat(460) = -rxt(369)*y(11)
         mat(549) = -rxt(373)*y(11)
         mat(684) = -rxt(379)*y(11)
         mat(304) = -rxt(393)*y(11)
         mat(104) = -rxt(417)*y(11)

         mat(1027) = rxt(195)*y(10)
         mat(956) = mat(956) + rxt(194)*y(10) + rxt(231)*y(35) + rxt(249)*y(41)
         mat(1300) = mat(1300) + rxt(195)*y(1) + rxt(194)*y(2)
         mat(1397) = mat(1397) + rxt(199)*y(12) + rxt(232)*y(35) + rxt(312)*y(58) &
                      + .500_r8*rxt(358)*y(81)
         mat(1463) = rxt(199)*y(23) + rxt(253)*y(134)
         mat(1115) = rxt(233)*y(35)
         mat(581) = rxt(231)*y(2) + rxt(232)*y(23) + rxt(233)*y(28)
         mat(286) = rxt(249)*y(2)
         mat(206) = rxt(312)*y(23)
         mat(294) = .500_r8*rxt(358)*y(23)
         mat(411) = rxt(253)*y(12)

         mat(1464) = -(rxt(199)*y(23) + rxt(253)*y(134))
         mat(1398) = -rxt(199)*y(12)
         mat(412) = -rxt(253)*y(12)

         mat(1301) = rxt(198)*y(23)
         mat(1398) = mat(1398) + rxt(198)*y(10)
         mat(1442) = rxt(269)*y(19) + rxt(301)*y(50) + rxt(331)*y(68) + rxt(417) &
                      *y(136)
         mat(1508) = rxt(269)*y(11)
         mat(837) = (rxt(421)+rxt(426)+rxt(432))*y(35)
         mat(582) = (rxt(421)+rxt(426)+rxt(432))*y(33)
         mat(613) = rxt(301)*y(11)
         mat(667) = rxt(331)*y(11)
         mat(105) = rxt(417)*y(11)

         mat(215) = -(rxt(205)*y(23))
         mat(1334) = -rxt(205)*y(13)

         mat(1270) = rxt(204)*y(24)
         mat(1131) = rxt(204)*y(10)


         mat(1268) = rxt(196)*y(11)
         mat(1402) = rxt(196)*y(10)

         mat(874) = -(rxt(218)*y(30) + rxt(273)*y(9) + rxt(274)*y(24) + (4._r8*rxt(275) &
                      + 4._r8*rxt(276)) * y(16) + rxt(297)*y(46) + rxt(305)*y(48) &
                      + rxt(318)*y(61) + rxt(327)*y(67) + rxt(347)*y(79) + rxt(353) &
                      *y(76) + rxt(366)*y(88) + rxt(381)*y(91))
         mat(1041) = -rxt(218)*y(16)
         mat(1250) = -rxt(273)*y(16)
         mat(1171) = -rxt(274)*y(16)
         mat(474) = -rxt(297)*y(16)
         mat(792) = -rxt(305)*y(16)
         mat(509) = -rxt(318)*y(16)
         mat(621) = -rxt(327)*y(16)
         mat(726) = -rxt(347)*y(16)
         mat(764) = -rxt(353)*y(16)
         mat(704) = -rxt(366)*y(16)
         mat(678) = -rxt(381)*y(16)

         mat(1014) = .310_r8*rxt(314)*y(59)
         mat(1250) = mat(1250) + rxt(302)*y(48)
         mat(1384) = .700_r8*rxt(278)*y(17) + rxt(294)*y(49)
         mat(874) = mat(874) + .900_r8*rxt(305)*y(48)
         mat(155) = .700_r8*rxt(278)*y(23)
         mat(591) = .310_r8*rxt(314)*y(1)
         mat(320) = rxt(294)*y(23)
         mat(792) = mat(792) + rxt(302)*y(9) + .900_r8*rxt(305)*y(16) &
                      + 4.000_r8*rxt(306)*y(48) + rxt(367)*y(88) + rxt(348)*y(79) &
                      + rxt(354)*y(76) + rxt(382)*y(91)
         mat(704) = mat(704) + rxt(367)*y(48)
         mat(726) = mat(726) + rxt(348)*y(48)
         mat(764) = mat(764) + rxt(354)*y(48)
         mat(678) = mat(678) + rxt(382)*y(48)

         mat(154) = -(rxt(278)*y(23))
         mat(1327) = -rxt(278)*y(17)

         mat(854) = rxt(274)*y(24)
         mat(1124) = rxt(274)*y(16)

         mat(57) = -(rxt(162)*y(3) + rxt(180)*y(23))
         mat(962) = -rxt(162)*y(42)
         mat(1311) = -rxt(180)*y(42)

         mat(17) = -(rxt(181)*y(23))
         mat(1304) = -rxt(181)*y(43)

         mat(1510) = -(rxt(212)*y(28) + rxt(236)*y(37) + rxt(269)*y(11) + rxt(270) &
                      *y(23) + rxt(271)*y(2) + rxt(272)*y(24))
         mat(1118) = -rxt(212)*y(19)
         mat(851) = -rxt(236)*y(19)
         mat(1444) = -rxt(269)*y(19)
         mat(1400) = -rxt(270)*y(19)
         mat(959) = -rxt(271)*y(19)
         mat(1187) = -rxt(272)*y(19)

         mat(1030) = .540_r8*rxt(314)*y(59) + .600_r8*rxt(360)*y(83) + rxt(293)*y(44) &
                      + .800_r8*rxt(336)*y(77) + .700_r8*rxt(342)*y(78)
         mat(1266) = rxt(273)*y(16) + rxt(321)*y(64) + .500_r8*rxt(334)*y(73) &
                      + .100_r8*rxt(375)*y(84) + .550_r8*rxt(362)*y(88) &
                      + .250_r8*rxt(343)*y(79) + rxt(350)*y(76) + .500_r8*rxt(289) &
                      *y(55) + rxt(325)*y(67) + .072_r8*rxt(368)*y(89) &
                      + .250_r8*rxt(378)*y(91)
         mat(1400) = mat(1400) + .300_r8*rxt(278)*y(17) + .500_r8*rxt(307)*y(54) &
                      + rxt(312)*y(58) + .500_r8*rxt(358)*y(81) + rxt(277)*y(18) &
                      + .800_r8*rxt(308)*y(52)
         mat(1444) = mat(1444) + .600_r8*rxt(363)*y(88) + .250_r8*rxt(345)*y(79) &
                      + rxt(351)*y(76) + .072_r8*rxt(369)*y(89)
         mat(887) = rxt(273)*y(9) + (4.000_r8*rxt(275)+2.000_r8*rxt(276))*y(16) &
                      + rxt(218)*y(30) + rxt(305)*y(48) + 1.200_r8*rxt(366)*y(88) &
                      + .880_r8*rxt(347)*y(79) + 2.000_r8*rxt(353)*y(76) &
                      + .700_r8*rxt(297)*y(46) + rxt(318)*y(61) + .800_r8*rxt(327) &
                      *y(67) + .800_r8*rxt(381)*y(91)
         mat(159) = .300_r8*rxt(278)*y(23)
         mat(1187) = mat(1187) + .206_r8*rxt(370)*y(89)
         mat(1057) = rxt(218)*y(16)
         mat(600) = .540_r8*rxt(314)*y(1)
         mat(535) = .600_r8*rxt(360)*y(1)
         mat(451) = rxt(321)*y(9)
         mat(803) = rxt(305)*y(16) + .600_r8*rxt(367)*y(88) + .250_r8*rxt(348)*y(79) &
                      + rxt(354)*y(76) + .250_r8*rxt(382)*y(91)
         mat(232) = .500_r8*rxt(307)*y(23)
         mat(207) = rxt(312)*y(23)
         mat(240) = rxt(293)*y(1)
         mat(295) = .500_r8*rxt(358)*y(23)
         mat(118) = .500_r8*rxt(334)*y(9)
         mat(368) = .100_r8*rxt(375)*y(9)
         mat(714) = .550_r8*rxt(362)*y(9) + .600_r8*rxt(363)*y(11) + 1.200_r8*rxt(366) &
                      *y(16) + .600_r8*rxt(367)*y(48)
         mat(756) = .800_r8*rxt(336)*y(1)
         mat(646) = .700_r8*rxt(342)*y(1)
         mat(735) = .250_r8*rxt(343)*y(9) + .250_r8*rxt(345)*y(11) + .880_r8*rxt(347) &
                      *y(16) + .250_r8*rxt(348)*y(48)
         mat(775) = rxt(350)*y(9) + rxt(351)*y(11) + 2.000_r8*rxt(353)*y(16) &
                      + rxt(354)*y(48) + 4.000_r8*rxt(355)*y(76)
         mat(480) = .700_r8*rxt(297)*y(16)
         mat(516) = rxt(318)*y(16)
         mat(271) = rxt(277)*y(23)
         mat(541) = .800_r8*rxt(308)*y(23)
         mat(395) = .500_r8*rxt(289)*y(9)
         mat(628) = rxt(325)*y(9) + .800_r8*rxt(327)*y(16)
         mat(461) = .072_r8*rxt(368)*y(9) + .072_r8*rxt(369)*y(11) + .206_r8*rxt(370) &
                      *y(24)
         mat(687) = .250_r8*rxt(378)*y(9) + .800_r8*rxt(381)*y(16) + .250_r8*rxt(382) &
                      *y(48)

         mat(1485) = -(rxt(163)*y(4) + rxt(164)*y(1) + (rxt(165) + rxt(166) + rxt(167) &
                      ) * y(24))
         mat(917) = -rxt(163)*y(22)
         mat(1029) = -rxt(164)*y(22)
         mat(1186) = -(rxt(165) + rxt(166) + rxt(167)) * y(22)

         mat(958) = rxt(175)*y(21) + rxt(168)*y(23)
         mat(984) = rxt(159)*y(21)
         mat(659) = rxt(175)*y(2) + rxt(159)*y(3) + rxt(173)*y(23) + rxt(208)*y(28) &
                      + rxt(251)*y(134)
         mat(604) = rxt(267)*y(23)
         mat(494) = rxt(184)*y(23)
         mat(1399) = rxt(168)*y(2) + rxt(173)*y(21) + rxt(267)*y(20) + rxt(184)*y(8) &
                      + rxt(270)*y(19) + rxt(402)*y(137) + rxt(403)*y(138) + rxt(406) &
                      *y(139)
         mat(1509) = rxt(270)*y(23)
         mat(1117) = rxt(208)*y(21)
         mat(413) = rxt(251)*y(21)
         mat(149) = rxt(402)*y(23)
         mat(381) = rxt(403)*y(23)
         mat(820) = rxt(406)*y(23)

         mat(1179) = -((rxt(165) + rxt(166) + rxt(167)) * y(22) + rxt(170)*y(23) &
                      + rxt(176)*y(2) + rxt(177)*y(1) + 4._r8*rxt(178)*y(24) + rxt(191) &
                      *y(9) + rxt(203)*y(11) + rxt(204)*y(10) + (rxt(210) + rxt(211) &
                      ) * y(28) + rxt(217)*y(30) + rxt(235)*y(37) + rxt(239)*y(38) &
                      + rxt(272)*y(19) + rxt(274)*y(16) + rxt(282)*y(130) + rxt(290) &
                      *y(55) + rxt(296)*y(46) + rxt(304)*y(48) + rxt(317)*y(61) &
                      + rxt(322)*y(64) + rxt(326)*y(67) + rxt(339)*y(74) + rxt(346) &
                      *y(79) + rxt(352)*y(76) + rxt(364)*y(88) + rxt(370)*y(89) &
                      + rxt(376)*y(84) + rxt(380)*y(91) + rxt(387)*y(96) + rxt(395) &
                      *y(100))
         mat(1478) = -(rxt(165) + rxt(166) + rxt(167)) * y(24)
         mat(1392) = -rxt(170)*y(24)
         mat(951) = -rxt(176)*y(24)
         mat(1022) = -rxt(177)*y(24)
         mat(1258) = -rxt(191)*y(24)
         mat(1436) = -rxt(203)*y(24)
         mat(1295) = -rxt(204)*y(24)
         mat(1110) = -(rxt(210) + rxt(211)) * y(24)
         mat(1049) = -rxt(217)*y(24)
         mat(847) = -rxt(235)*y(24)
         mat(1203) = -rxt(239)*y(24)
         mat(1502) = -rxt(272)*y(24)
         mat(880) = -rxt(274)*y(24)
         mat(180) = -rxt(282)*y(24)
         mat(391) = -rxt(290)*y(24)
         mat(476) = -rxt(296)*y(24)
         mat(796) = -rxt(304)*y(24)
         mat(512) = -rxt(317)*y(24)
         mat(447) = -rxt(322)*y(24)
         mat(624) = -rxt(326)*y(24)
         mat(338) = -rxt(339)*y(24)
         mat(728) = -rxt(346)*y(24)
         mat(768) = -rxt(352)*y(24)
         mat(707) = -rxt(364)*y(24)
         mat(456) = -rxt(370)*y(24)
         mat(364) = -rxt(376)*y(24)
         mat(680) = -rxt(380)*y(24)
         mat(250) = -rxt(387)*y(24)
         mat(567) = -rxt(395)*y(24)

         mat(1022) = mat(1022) + rxt(169)*y(23) + .190_r8*rxt(314)*y(59) &
                      + .060_r8*rxt(360)*y(83) + .120_r8*rxt(293)*y(44) &
                      + .060_r8*rxt(336)*y(77) + .275_r8*rxt(342)*y(78) + rxt(392) &
                      *y(99)
         mat(951) = mat(951) + rxt(271)*y(19) + rxt(179)*y(25)
         mat(912) = rxt(163)*y(22) + rxt(291)*y(56)
         mat(602) = rxt(268)*y(23)
         mat(1258) = mat(1258) + rxt(273)*y(16) + rxt(321)*y(64) + rxt(334)*y(73) &
                      + .900_r8*rxt(375)*y(84) + .900_r8*rxt(386)*y(96) + rxt(394) &
                      *y(100) + .920_r8*rxt(362)*y(88) + .470_r8*rxt(343)*y(79) &
                      + rxt(295)*y(46) + rxt(316)*y(61) + .250_r8*rxt(289)*y(55) &
                      + .794_r8*rxt(368)*y(89) + rxt(378)*y(91) + rxt(281)*y(130)
         mat(1295) = mat(1295) + .700_r8*rxt(390)*y(98)
         mat(1392) = mat(1392) + rxt(169)*y(1) + rxt(268)*y(20) + rxt(202)*y(11) &
                      + rxt(180)*y(42) + rxt(181)*y(43) + rxt(174)*y(25) + rxt(215) &
                      *y(30) + rxt(238)*y(38) + .500_r8*rxt(358)*y(81) &
                      + .250_r8*rxt(385)*y(94) + rxt(309)*y(53) + .200_r8*rxt(349) &
                      *y(80) + rxt(277)*y(18) + rxt(310)*y(51) + rxt(308)*y(52) &
                      + rxt(329)*y(66) + rxt(372)*y(90) + .350_r8*rxt(286)*y(128) &
                      + rxt(279)*y(129) + rxt(413)*y(135) + .500_r8*rxt(416)*y(136)
         mat(1436) = mat(1436) + rxt(202)*y(23) + rxt(269)*y(19) + rxt(363)*y(88) &
                      + .470_r8*rxt(345)*y(79) + .794_r8*rxt(369)*y(89) + rxt(373) &
                      *y(90) + rxt(379)*y(91)
         mat(880) = mat(880) + rxt(273)*y(9) + 4.000_r8*rxt(275)*y(16) + rxt(218) &
                      *y(30) + .900_r8*rxt(305)*y(48) + rxt(366)*y(88) &
                      + .730_r8*rxt(347)*y(79) + rxt(353)*y(76) + rxt(297)*y(46) &
                      + rxt(318)*y(61) + .300_r8*rxt(327)*y(67) + .800_r8*rxt(381) &
                      *y(91)
         mat(59) = rxt(180)*y(23)
         mat(18) = rxt(181)*y(23)
         mat(1502) = mat(1502) + rxt(271)*y(2) + rxt(269)*y(11) + rxt(212)*y(28) &
                      + rxt(236)*y(37)
         mat(1478) = mat(1478) + rxt(163)*y(4)
         mat(317) = rxt(179)*y(2) + rxt(174)*y(23) + rxt(209)*y(28)
         mat(1110) = mat(1110) + rxt(212)*y(19) + rxt(209)*y(25)
         mat(1049) = mat(1049) + rxt(215)*y(23) + rxt(218)*y(16)
         mat(847) = mat(847) + rxt(236)*y(19)
         mat(1203) = mat(1203) + rxt(238)*y(23)
         mat(595) = .190_r8*rxt(314)*y(1)
         mat(530) = .060_r8*rxt(360)*y(1)
         mat(447) = mat(447) + rxt(321)*y(9)
         mat(796) = mat(796) + .900_r8*rxt(305)*y(16) + rxt(367)*y(88) &
                      + .470_r8*rxt(348)*y(79) + rxt(382)*y(91)
         mat(238) = .120_r8*rxt(293)*y(1)
         mat(291) = .500_r8*rxt(358)*y(23)
         mat(115) = rxt(334)*y(9)
         mat(364) = mat(364) + .900_r8*rxt(375)*y(9)
         mat(36) = .250_r8*rxt(385)*y(23)
         mat(250) = mat(250) + .900_r8*rxt(386)*y(9)
         mat(63) = .700_r8*rxt(390)*y(10)
         mat(567) = mat(567) + rxt(394)*y(9)
         mat(384) = rxt(309)*y(23)
         mat(707) = mat(707) + .920_r8*rxt(362)*y(9) + rxt(363)*y(11) + rxt(366)*y(16) &
                      + rxt(367)*y(48)
         mat(749) = .060_r8*rxt(336)*y(1)
         mat(643) = .275_r8*rxt(342)*y(1)
         mat(728) = mat(728) + .470_r8*rxt(343)*y(9) + .470_r8*rxt(345)*y(11) &
                      + .730_r8*rxt(347)*y(16) + .470_r8*rxt(348)*y(48)
         mat(127) = .200_r8*rxt(349)*y(23)
         mat(768) = mat(768) + rxt(353)*y(16)
         mat(476) = mat(476) + rxt(295)*y(9) + rxt(297)*y(16) + 2.400_r8*rxt(298) &
                      *y(46)
         mat(301) = rxt(392)*y(1)
         mat(512) = mat(512) + rxt(316)*y(9) + rxt(318)*y(16)
         mat(269) = rxt(277)*y(23)
         mat(77) = rxt(310)*y(23)
         mat(539) = rxt(308)*y(23)
         mat(632) = rxt(329)*y(23)
         mat(391) = mat(391) + .250_r8*rxt(289)*y(9)
         mat(192) = rxt(291)*y(4)
         mat(624) = mat(624) + .300_r8*rxt(327)*y(16)
         mat(456) = mat(456) + .794_r8*rxt(368)*y(9) + .794_r8*rxt(369)*y(11)
         mat(546) = rxt(372)*y(23) + rxt(373)*y(11)
         mat(680) = mat(680) + rxt(378)*y(9) + rxt(379)*y(11) + .800_r8*rxt(381)*y(16) &
                      + rxt(382)*y(48)
         mat(98) = .350_r8*rxt(286)*y(23)
         mat(243) = rxt(279)*y(23)
         mat(180) = mat(180) + rxt(281)*y(9)
         mat(556) = rxt(413)*y(23)
         mat(102) = .500_r8*rxt(416)*y(23)


      end subroutine nlnmat03

      subroutine nlnmat04( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(312) = -(rxt(174)*y(23) + rxt(179)*y(2) + rxt(209)*y(28))
         mat(1345) = -rxt(174)*y(25)
         mat(926) = -rxt(179)*y(25)
         mat(1089) = -rxt(209)*y(25)

         mat(1345) = mat(1345) + 2.000_r8*rxt(172)*y(23)
         mat(1138) = 2.000_r8*rxt(178)*y(24)

         mat(1073) = -(rxt(134)*y(3) + rxt(250)*y(134) + rxt(414)*y(140))
         mat(975) = -rxt(134)*y(158)
         mat(409) = -rxt(250)*y(158)
         mat(87) = -rxt(414)*y(158)

         mat(654) = rxt(173)*y(23)
         mat(1390) = rxt(173)*y(21) + 2.000_r8*rxt(171)*y(23) + rxt(199)*y(12) &
                      + rxt(205)*y(13) + rxt(278)*y(17) + rxt(270)*y(19) + rxt(170) &
                      *y(24) + rxt(174)*y(25) + rxt(226)*y(33) + rxt(230)*y(34) &
                      + rxt(246)*y(39) + rxt(300)*y(50) + rxt(294)*y(49) + rxt(323) &
                      *y(65) + rxt(307)*y(54) + rxt(287)*y(45) + .500_r8*rxt(341) &
                      *y(78) + rxt(320)*y(60) + rxt(319)*y(62) + rxt(324)*y(63) &
                      + rxt(328)*y(69) + rxt(330)*y(68) + (rxt(383)+rxt(384))*y(92) &
                      + rxt(279)*y(129)
         mat(1456) = rxt(199)*y(23)
         mat(217) = rxt(205)*y(23)
         mat(156) = rxt(278)*y(23)
         mat(1500) = rxt(270)*y(23)
         mat(1476) = rxt(167)*y(24)
         mat(1177) = rxt(170)*y(23) + rxt(167)*y(22)
         mat(315) = rxt(174)*y(23)
         mat(831) = rxt(226)*y(23) + (rxt(422)+rxt(427)+rxt(433))*y(34) + (rxt(423) &
                       +rxt(434))*y(40)
         mat(500) = rxt(230)*y(23) + (rxt(422)+rxt(427)+rxt(433))*y(33)
         mat(466) = rxt(246)*y(23)
         mat(401) = (rxt(423)+rxt(434))*y(33)
         mat(609) = rxt(300)*y(23)
         mat(321) = rxt(294)*y(23)
         mat(264) = rxt(323)*y(23)
         mat(230) = rxt(307)*y(23)
         mat(91) = rxt(287)*y(23)
         mat(642) = .500_r8*rxt(341)*y(23)
         mat(31) = rxt(320)*y(23)
         mat(169) = rxt(319)*y(23)
         mat(373) = rxt(324)*y(23)
         mat(175) = rxt(328)*y(23)
         mat(663) = rxt(330)*y(23)
         mat(81) = (rxt(383)+rxt(384))*y(23)
         mat(242) = rxt(279)*y(23)

         mat(1109) = -(rxt(207)*y(1) + rxt(208)*y(21) + rxt(209)*y(25) + (rxt(210) &
                      + rxt(211)) * y(24) + rxt(212)*y(19) + rxt(229)*y(34) + rxt(233) &
                      *y(35) + rxt(285)*y(45))
         mat(1021) = -rxt(207)*y(28)
         mat(655) = -rxt(208)*y(28)
         mat(316) = -rxt(209)*y(28)
         mat(1178) = -(rxt(210) + rxt(211)) * y(28)
         mat(1501) = -rxt(212)*y(28)
         mat(501) = -rxt(229)*y(28)
         mat(578) = -rxt(233)*y(28)
         mat(92) = -rxt(285)*y(28)

         mat(950) = rxt(214)*y(30) + rxt(227)*y(33)
         mat(976) = rxt(160)*y(33) + rxt(155)*y(132)
         mat(1257) = rxt(219)*y(30)
         mat(1391) = rxt(215)*y(30) + rxt(226)*y(33)
         mat(879) = rxt(218)*y(30)
         mat(1048) = rxt(214)*y(2) + rxt(219)*y(9) + rxt(215)*y(23) + rxt(218)*y(16) + ( &
                      + 4.000_r8*rxt(221)+2.000_r8*rxt(223))*y(30) + rxt(243)*y(38) &
                      + rxt(410)*y(139)
         mat(832) = rxt(227)*y(2) + rxt(160)*y(3) + rxt(226)*y(23)
         mat(1202) = rxt(243)*y(30)
         mat(68) = rxt(155)*y(3)
         mat(814) = rxt(410)*y(30)


         mat(1084) = rxt(233)*y(35)
         mat(1032) = 2.000_r8*rxt(222)*y(30)
         mat(821) = (rxt(422)+rxt(427)+rxt(433))*y(34) + (rxt(421)+rxt(426)+rxt(432)) &
                      *y(35)
         mat(495) = (rxt(422)+rxt(427)+rxt(433))*y(33)
         mat(571) = rxt(233)*y(28) + (rxt(421)+rxt(426)+rxt(432))*y(33)

         mat(1046) = -(rxt(214)*y(2) + (rxt(215) + rxt(216)) * y(23) + rxt(217)*y(24) &
                      + rxt(218)*y(16) + rxt(219)*y(9) + rxt(220)*y(10) + (4._r8*rxt(221) &
                      + 4._r8*rxt(222) + 4._r8*rxt(223) + 4._r8*rxt(224)) * y(30) &
                      + (rxt(242) + rxt(243) + rxt(244)) * y(38) + rxt(410)*y(139))
         mat(948) = -rxt(214)*y(30)
         mat(1389) = -(rxt(215) + rxt(216)) * y(30)
         mat(1176) = -rxt(217)*y(30)
         mat(877) = -rxt(218)*y(30)
         mat(1255) = -rxt(219)*y(30)
         mat(1292) = -rxt(220)*y(30)
         mat(1200) = -(rxt(242) + rxt(243) + rxt(244)) * y(30)
         mat(812) = -rxt(410)*y(30)

         mat(1019) = rxt(207)*y(28)
         mat(948) = mat(948) + rxt(228)*y(34) + rxt(231)*y(35)
         mat(1389) = mat(1389) + rxt(230)*y(34)
         mat(1176) = mat(1176) + rxt(211)*y(28)
         mat(1107) = rxt(207)*y(1) + rxt(211)*y(24) + rxt(229)*y(34)
         mat(138) = rxt(412)*y(139)
         mat(499) = rxt(228)*y(2) + rxt(230)*y(23) + rxt(229)*y(28)
         mat(576) = rxt(231)*y(2)
         mat(812) = mat(812) + rxt(412)*y(31)

         mat(134) = -(rxt(412)*y(139))
         mat(804) = -rxt(412)*y(31)

         mat(1034) = 2.000_r8*rxt(223)*y(30) + rxt(242)*y(38)
         mat(1189) = rxt(242)*y(30)


         mat(1031) = 2.000_r8*rxt(224)*y(30)

         mat(826) = -(rxt(160)*y(3) + rxt(226)*y(23) + rxt(227)*y(2) + (rxt(421) &
                      + rxt(426) + rxt(432)) * y(35) + (rxt(422) + rxt(427) + rxt(433) &
                      ) * y(34) + (rxt(423) + rxt(434)) * y(40))
         mat(967) = -rxt(160)*y(33)
         mat(1382) = -rxt(226)*y(33)
         mat(941) = -rxt(227)*y(33)
         mat(574) = -(rxt(421) + rxt(426) + rxt(432)) * y(33)
         mat(497) = -(rxt(422) + rxt(427) + rxt(433)) * y(33)
         mat(398) = -(rxt(423) + rxt(434)) * y(33)

         mat(650) = rxt(208)*y(28)
         mat(1382) = mat(1382) + rxt(216)*y(30)
         mat(1492) = rxt(212)*y(28)
         mat(1169) = rxt(210)*y(28)
         mat(313) = rxt(209)*y(28)
         mat(1100) = rxt(208)*y(21) + rxt(212)*y(19) + rxt(210)*y(24) + rxt(209)*y(25) &
                      + rxt(229)*y(34) + rxt(285)*y(45)
         mat(1039) = rxt(216)*y(23)
         mat(497) = mat(497) + rxt(229)*y(28)
         mat(90) = rxt(285)*y(28)

         mat(496) = -(rxt(228)*y(2) + rxt(229)*y(28) + rxt(230)*y(23) + (rxt(422) &
                      + rxt(427) + rxt(433)) * y(33))
         mat(935) = -rxt(228)*y(34)
         mat(1093) = -rxt(229)*y(34)
         mat(1359) = -rxt(230)*y(34)
         mat(824) = -(rxt(422) + rxt(427) + rxt(433)) * y(34)

         mat(1359) = mat(1359) + rxt(232)*y(35)
         mat(1151) = rxt(217)*y(30)
         mat(1035) = rxt(217)*y(24)
         mat(572) = rxt(232)*y(23)

         mat(573) = -(rxt(231)*y(2) + rxt(232)*y(23) + rxt(233)*y(28) + (rxt(421) &
                      + rxt(426) + rxt(432)) * y(33))
         mat(937) = -rxt(231)*y(35)
         mat(1366) = -rxt(232)*y(35)
         mat(1095) = -rxt(233)*y(35)
         mat(825) = -(rxt(421) + rxt(426) + rxt(432)) * y(35)

         mat(1278) = rxt(220)*y(30)
         mat(1037) = rxt(220)*y(10)


         mat(1033) = rxt(244)*y(38)
         mat(822) = (rxt(423)+rxt(434))*y(40)
         mat(1188) = rxt(244)*y(30)
         mat(396) = (rxt(423)+rxt(434))*y(33)

         mat(841) = -(rxt(234)*y(1) + rxt(235)*y(24) + rxt(236)*y(19))
         mat(1013) = -rxt(234)*y(37)
         mat(1170) = -rxt(235)*y(37)
         mat(1493) = -rxt(236)*y(37)

         mat(942) = rxt(237)*y(38) + rxt(247)*y(39)
         mat(968) = rxt(161)*y(39)
         mat(1249) = rxt(240)*y(38)
         mat(1383) = rxt(238)*y(38) + rxt(246)*y(39)
         mat(1040) = (rxt(242)+rxt(243))*y(38)
         mat(1195) = rxt(237)*y(2) + rxt(240)*y(9) + rxt(238)*y(23) + (rxt(242) &
                       +rxt(243))*y(30) + 4.000_r8*rxt(245)*y(38) + rxt(411)*y(139)
         mat(463) = rxt(247)*y(2) + rxt(161)*y(3) + rxt(246)*y(23)
         mat(808) = rxt(411)*y(38)

         mat(1204) = -(rxt(237)*y(2) + rxt(238)*y(23) + rxt(239)*y(24) + rxt(240)*y(9) &
                      + rxt(241)*y(10) + (rxt(242) + rxt(243) + rxt(244)) * y(30) &
                      + 4._r8*rxt(245)*y(38) + rxt(411)*y(139))
         mat(952) = -rxt(237)*y(38)
         mat(1393) = -rxt(238)*y(38)
         mat(1180) = -rxt(239)*y(38)
         mat(1259) = -rxt(240)*y(38)
         mat(1296) = -rxt(241)*y(38)
         mat(1050) = -(rxt(242) + rxt(243) + rxt(244)) * y(38)
         mat(816) = -rxt(411)*y(38)

         mat(1023) = rxt(234)*y(37)
         mat(952) = mat(952) + rxt(248)*y(40) + rxt(249)*y(41)
         mat(848) = rxt(234)*y(1)
         mat(403) = rxt(248)*y(2)
         mat(284) = rxt(249)*y(2)

         mat(462) = -(rxt(161)*y(3) + rxt(246)*y(23) + rxt(247)*y(2))
         mat(965) = -rxt(161)*y(39)
         mat(1356) = -rxt(246)*y(39)
         mat(933) = -rxt(247)*y(39)

         mat(1489) = rxt(236)*y(37)
         mat(1149) = rxt(235)*y(37)
         mat(839) = rxt(236)*y(19) + rxt(235)*y(24)

         mat(397) = -(rxt(248)*y(2) + (rxt(423) + rxt(434)) * y(33))
         mat(929) = -rxt(248)*y(40)
         mat(823) = -(rxt(423) + rxt(434)) * y(40)

         mat(1146) = rxt(239)*y(38)
         mat(1191) = rxt(239)*y(24)

         mat(280) = -(rxt(249)*y(2))
         mat(924) = -rxt(249)*y(41)

         mat(1272) = rxt(241)*y(38)
         mat(1190) = rxt(241)*y(10)

         mat(344) = -((rxt(437) + rxt(438)) * y(2) + rxt(445)*y(4) + rxt(449)*y(126))
         mat(927) = -(rxt(437) + rxt(438)) * y(121)
         mat(894) = -rxt(445)*y(121)
         mat(431) = -rxt(449)*y(121)

         mat(414) = -(rxt(440)*y(8) + rxt(441)*y(9) + rxt(448)*y(126))
         mat(483) = -rxt(440)*y(122)
         mat(1226) = -rxt(441)*y(122)
         mat(432) = -rxt(448)*y(122)

         mat(896) = rxt(445)*y(121) + rxt(442)*y(123) + rxt(435)*y(124)
         mat(345) = rxt(445)*y(4)
         mat(196) = rxt(442)*y(4)
         mat(306) = rxt(435)*y(4)

         mat(194) = -((rxt(442) + rxt(443)) * y(4) + rxt(444)*y(2))
         mat(891) = -(rxt(442) + rxt(443)) * y(123)
         mat(922) = -rxt(444)*y(123)

         mat(305) = -(rxt(435)*y(4))
         mat(893) = -rxt(435)*y(124)

         mat(925) = rxt(438)*y(121) + rxt(444)*y(123)
         mat(343) = rxt(438)*y(2)
         mat(195) = rxt(444)*y(2)


      end subroutine nlnmat04

      subroutine nlnmat05( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(423) = -(rxt(447)*y(126))
         mat(433) = -rxt(447)*y(125)

         mat(931) = rxt(437)*y(121)
         mat(897) = rxt(443)*y(123)
         mat(484) = rxt(440)*y(122)
         mat(1227) = rxt(441)*y(122)
         mat(346) = rxt(437)*y(2)
         mat(415) = rxt(440)*y(8) + rxt(441)*y(9)
         mat(197) = rxt(443)*y(4)

         mat(222) = -(rxt(182)*y(4) + rxt(183)*y(2))
         mat(892) = -rxt(182)*y(127)
         mat(923) = -rxt(183)*y(127)

         mat(923) = mat(923) + rxt(437)*y(121)
         mat(342) = rxt(437)*y(2) + .900_r8*rxt(449)*y(126)
         mat(422) = .800_r8*rxt(447)*y(126)
         mat(430) = .900_r8*rxt(449)*y(121) + .800_r8*rxt(447)*y(125)

         mat(434) = -(rxt(447)*y(125) + rxt(448)*y(122) + rxt(449)*y(121))
         mat(424) = -rxt(447)*y(126)
         mat(416) = -rxt(448)*y(126)
         mat(347) = -rxt(449)*y(126)

         mat(586) = -(rxt(313)*y(23) + rxt(314)*y(1) + rxt(315)*y(11))
         mat(1367) = -rxt(313)*y(59)
         mat(999) = -rxt(314)*y(59)
         mat(1413) = -rxt(315)*y(59)

         mat(999) = mat(999) + .070_r8*rxt(360)*y(83)
         mat(521) = .070_r8*rxt(360)*y(1)

         mat(519) = -(rxt(359)*y(23) + rxt(360)*y(1) + rxt(361)*y(11))
         mat(1361) = -rxt(359)*y(83)
         mat(994) = -rxt(360)*y(83)
         mat(1408) = -rxt(361)*y(83)

         mat(442) = -(rxt(321)*y(9) + rxt(322)*y(24))
         mat(1229) = -rxt(321)*y(64)
         mat(1147) = -rxt(322)*y(64)

         mat(1355) = rxt(313)*y(59) + .500_r8*rxt(323)*y(65)
         mat(585) = rxt(313)*y(23)
         mat(261) = .500_r8*rxt(323)*y(23)

         mat(606) = -(rxt(300)*y(23) + rxt(301)*y(11))
         mat(1369) = -rxt(300)*y(50)
         mat(1415) = -rxt(301)*y(50)

         mat(1001) = .500_r8*rxt(314)*y(59) + .040_r8*rxt(336)*y(77)
         mat(1238) = rxt(321)*y(64) + rxt(334)*y(73) + .400_r8*rxt(375)*y(84) &
                      + rxt(338)*y(74) + rxt(295)*y(46) + .270_r8*rxt(316)*y(61)
         mat(1369) = mat(1369) + .500_r8*rxt(299)*y(47) + rxt(310)*y(51)
         mat(863) = .800_r8*rxt(297)*y(46)
         mat(588) = .500_r8*rxt(314)*y(1)
         mat(443) = rxt(321)*y(9)
         mat(114) = rxt(334)*y(9)
         mat(361) = .400_r8*rxt(375)*y(9)
         mat(336) = rxt(338)*y(9)
         mat(738) = .040_r8*rxt(336)*y(1)
         mat(473) = rxt(295)*y(9) + .800_r8*rxt(297)*y(16) + 3.200_r8*rxt(298)*y(46)
         mat(131) = .500_r8*rxt(299)*y(23)
         mat(506) = .270_r8*rxt(316)*y(9)
         mat(76) = rxt(310)*y(23)

         mat(319) = -(rxt(294)*y(23))
         mat(1346) = -rxt(294)*y(49)

         mat(991) = .250_r8*rxt(314)*y(59) + .200_r8*rxt(360)*y(83)
         mat(856) = .100_r8*rxt(305)*y(48)
         mat(1139) = .250_r8*rxt(304)*y(48) + .250_r8*rxt(352)*y(76)
         mat(584) = .250_r8*rxt(314)*y(1)
         mat(517) = .200_r8*rxt(360)*y(1)
         mat(779) = .100_r8*rxt(305)*y(16) + .250_r8*rxt(304)*y(24)
         mat(759) = .250_r8*rxt(352)*y(24)

         mat(260) = -(rxt(323)*y(23))
         mat(1340) = -rxt(323)*y(65)

         mat(1136) = rxt(322)*y(64)
         mat(441) = rxt(322)*y(24)

         mat(791) = -(rxt(302)*y(9) + rxt(303)*y(10) + rxt(304)*y(24) + rxt(305)*y(16) &
                      + 4._r8*rxt(306)*y(48) + rxt(348)*y(79) + rxt(367)*y(88) + rxt(382) &
                      *y(91))
         mat(1248) = -rxt(302)*y(48)
         mat(1283) = -rxt(303)*y(48)
         mat(1168) = -rxt(304)*y(48)
         mat(873) = -rxt(305)*y(48)
         mat(725) = -rxt(348)*y(48)
         mat(703) = -rxt(367)*y(48)
         mat(677) = -rxt(382)*y(48)

         mat(1248) = mat(1248) + rxt(338)*y(74) + .530_r8*rxt(343)*y(79) + rxt(350) &
                      *y(76) + rxt(325)*y(67)
         mat(1380) = rxt(300)*y(50) + .500_r8*rxt(307)*y(54) + rxt(330)*y(68)
         mat(1425) = rxt(301)*y(50) + .530_r8*rxt(345)*y(79) + rxt(351)*y(76) &
                      + rxt(331)*y(68)
         mat(873) = mat(873) + .260_r8*rxt(347)*y(79) + rxt(353)*y(76) &
                      + .300_r8*rxt(327)*y(67)
         mat(607) = rxt(300)*y(23) + rxt(301)*y(11)
         mat(791) = mat(791) + .530_r8*rxt(348)*y(79)
         mat(228) = .500_r8*rxt(307)*y(23)
         mat(337) = rxt(338)*y(9)
         mat(725) = mat(725) + .530_r8*rxt(343)*y(9) + .530_r8*rxt(345)*y(11) &
                      + .260_r8*rxt(347)*y(16) + .530_r8*rxt(348)*y(48)
         mat(763) = rxt(350)*y(9) + rxt(351)*y(11) + rxt(353)*y(16) &
                      + 4.000_r8*rxt(355)*y(76)
         mat(620) = rxt(325)*y(9) + .300_r8*rxt(327)*y(16)
         mat(662) = rxt(330)*y(23) + rxt(331)*y(11)

         mat(227) = -(rxt(307)*y(23))
         mat(1335) = -rxt(307)*y(54)

         mat(1132) = .750_r8*rxt(304)*y(48) + .750_r8*rxt(352)*y(76)
         mat(778) = .750_r8*rxt(304)*y(24)
         mat(757) = .750_r8*rxt(352)*y(24)

         mat(201) = -(rxt(312)*y(23))
         mat(1332) = -rxt(312)*y(58)

         mat(1269) = rxt(303)*y(48)
         mat(777) = rxt(303)*y(10)

         mat(150) = -(rxt(332)*y(23))
         mat(1326) = -rxt(332)*y(82)

         mat(1214) = .100_r8*rxt(375)*y(84)
         mat(1404) = rxt(315)*y(59)
         mat(583) = rxt(315)*y(11)
         mat(354) = .100_r8*rxt(375)*y(9)

         mat(88) = -(rxt(285)*y(28) + rxt(287)*y(23))
         mat(1085) = -rxt(285)*y(45)
         mat(1317) = -rxt(287)*y(45)

         mat(233) = -(rxt(284)*y(28) + rxt(288)*y(23) + rxt(293)*y(1))
         mat(1087) = -rxt(284)*y(44)
         mat(1336) = -rxt(288)*y(44)
         mat(988) = -rxt(293)*y(44)

         mat(23) = -(rxt(371)*y(23))
         mat(1305) = -rxt(371)*y(71)

         mat(288) = -(rxt(358)*y(23))
         mat(1343) = -rxt(358)*y(81)

         mat(1273) = rxt(356)*y(76)
         mat(758) = rxt(356)*y(10)

         mat(26) = -(rxt(333)*y(23))
         mat(1306) = -rxt(333)*y(70)

         mat(112) = -(rxt(334)*y(9))
         mat(1212) = -rxt(334)*y(73)

         mat(1320) = rxt(333)*y(70)
         mat(27) = rxt(333)*y(23)

         mat(358) = -(rxt(375)*y(9) + rxt(376)*y(24))
         mat(1222) = -rxt(375)*y(84)
         mat(1142) = -rxt(376)*y(84)

         mat(1349) = rxt(371)*y(71) + rxt(377)*y(85)
         mat(24) = rxt(371)*y(23)
         mat(326) = rxt(377)*y(23)

         mat(324) = -(rxt(377)*y(23))
         mat(1347) = -rxt(377)*y(85)

         mat(1140) = rxt(376)*y(84)
         mat(356) = rxt(376)*y(24)

         mat(184) = -(rxt(337)*y(23))
         mat(1331) = -rxt(337)*y(72)

         mat(1216) = .800_r8*rxt(375)*y(84)
         mat(355) = .800_r8*rxt(375)*y(9)

         mat(335) = -(rxt(338)*y(9) + rxt(339)*y(24))
         mat(1221) = -rxt(338)*y(74)
         mat(1141) = -rxt(339)*y(74)

         mat(1348) = rxt(337)*y(72) + rxt(340)*y(75)
         mat(185) = rxt(337)*y(23)
         mat(120) = rxt(340)*y(23)

         mat(119) = -(rxt(340)*y(23))
         mat(1321) = -rxt(340)*y(75)

         mat(1121) = rxt(339)*y(74)
         mat(334) = rxt(339)*y(24)

         mat(33) = -(rxt(385)*y(23))
         mat(1308) = -rxt(385)*y(94)

         mat(38) = -(rxt(389)*y(23))
         mat(1309) = -rxt(389)*y(95)

         mat(1309) = mat(1309) + .250_r8*rxt(385)*y(94)
         mat(34) = .250_r8*rxt(385)*y(23)

         mat(246) = -(rxt(386)*y(9) + rxt(387)*y(24))
         mat(1219) = -rxt(386)*y(96)
         mat(1134) = -rxt(387)*y(96)

         mat(1338) = .700_r8*rxt(385)*y(94) + rxt(388)*y(97)
         mat(35) = .700_r8*rxt(385)*y(23)
         mat(161) = rxt(388)*y(23)

         mat(160) = -(rxt(388)*y(23))
         mat(1328) = -rxt(388)*y(97)

         mat(1125) = rxt(387)*y(96)
         mat(245) = rxt(387)*y(24)

         mat(61) = -(rxt(390)*y(10))
         mat(1267) = -rxt(390)*y(98)

         mat(1312) = rxt(389)*y(95)
         mat(39) = rxt(389)*y(23)

         mat(560) = -(rxt(394)*y(9) + rxt(395)*y(24))
         mat(1236) = -rxt(394)*y(100)
         mat(1155) = -rxt(395)*y(100)

         mat(1365) = rxt(396)*y(101) + rxt(391)*y(99)
         mat(1412) = rxt(393)*y(99)
         mat(210) = rxt(396)*y(23)
         mat(297) = rxt(391)*y(23) + rxt(393)*y(11)

         mat(208) = -(rxt(396)*y(23))
         mat(1333) = -rxt(396)*y(101)

         mat(1130) = rxt(395)*y(100)
         mat(558) = rxt(395)*y(24)


         mat(1220) = .900_r8*rxt(386)*y(96)
         mat(1271) = .700_r8*rxt(390)*y(98)
         mat(247) = .900_r8*rxt(386)*y(9)
         mat(62) = .700_r8*rxt(390)*y(10)

         mat(382) = -(rxt(309)*y(23))
         mat(1352) = -rxt(309)*y(53)

         mat(1224) = .450_r8*rxt(386)*y(96) + .020_r8*rxt(362)*y(88) &
                      + .250_r8*rxt(378)*y(91)
         mat(1352) = mat(1352) + .200_r8*rxt(308)*y(52) + .650_r8*rxt(286)*y(128)
         mat(1406) = .250_r8*rxt(379)*y(91)
         mat(858) = .100_r8*rxt(381)*y(91)
         mat(780) = .250_r8*rxt(382)*y(91)
         mat(248) = .450_r8*rxt(386)*y(9)
         mat(691) = .020_r8*rxt(362)*y(9)
         mat(536) = .200_r8*rxt(308)*y(23)
         mat(671) = .250_r8*rxt(378)*y(9) + .250_r8*rxt(379)*y(11) + .100_r8*rxt(381) &
                      *y(16) + .250_r8*rxt(382)*y(48)
         mat(96) = .650_r8*rxt(286)*y(23)


      end subroutine nlnmat05

      subroutine nlnmat06( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(699) = -(rxt(362)*y(9) + rxt(363)*y(11) + rxt(364)*y(24) + rxt(366)*y(16) &
                      + rxt(367)*y(48))
         mat(1244) = -rxt(362)*y(88)
         mat(1421) = -rxt(363)*y(88)
         mat(1164) = -rxt(364)*y(88)
         mat(869) = -rxt(366)*y(88)
         mat(787) = -rxt(367)*y(88)

         mat(1376) = rxt(359)*y(83) + .200_r8*rxt(365)*y(93)
         mat(524) = rxt(359)*y(23)
         mat(275) = .200_r8*rxt(365)*y(23)

         mat(742) = -(rxt(335)*y(23) + rxt(336)*y(1))
         mat(1378) = -rxt(335)*y(77)
         mat(1009) = -rxt(336)*y(77)

         mat(1009) = mat(1009) + .200_r8*rxt(360)*y(83) + rxt(392)*y(99)
         mat(1246) = rxt(394)*y(100) + .320_r8*rxt(362)*y(88) + .039_r8*rxt(368)*y(89)
         mat(1423) = .350_r8*rxt(363)*y(88) + .039_r8*rxt(369)*y(89)
         mat(871) = .260_r8*rxt(366)*y(88)
         mat(1166) = .039_r8*rxt(370)*y(89)
         mat(525) = .200_r8*rxt(360)*y(1)
         mat(789) = .350_r8*rxt(367)*y(88)
         mat(563) = rxt(394)*y(9)
         mat(701) = .320_r8*rxt(362)*y(9) + .350_r8*rxt(363)*y(11) + .260_r8*rxt(366) &
                      *y(16) + .350_r8*rxt(367)*y(48)
         mat(299) = rxt(392)*y(1)
         mat(455) = .039_r8*rxt(368)*y(9) + .039_r8*rxt(369)*y(11) + .039_r8*rxt(370) &
                      *y(24)

         mat(636) = -(rxt(341)*y(23) + rxt(342)*y(1))
         mat(1372) = -rxt(341)*y(78)
         mat(1004) = -rxt(342)*y(78)

         mat(1004) = mat(1004) + .400_r8*rxt(360)*y(83) + rxt(392)*y(99)
         mat(1241) = rxt(394)*y(100) + .230_r8*rxt(362)*y(88) + .167_r8*rxt(368)*y(89)
         mat(1418) = .250_r8*rxt(363)*y(88) + .167_r8*rxt(369)*y(89)
         mat(866) = .190_r8*rxt(366)*y(88)
         mat(1160) = .167_r8*rxt(370)*y(89)
         mat(523) = .400_r8*rxt(360)*y(1)
         mat(784) = .250_r8*rxt(367)*y(88)
         mat(562) = rxt(394)*y(9)
         mat(696) = .230_r8*rxt(362)*y(9) + .250_r8*rxt(363)*y(11) + .190_r8*rxt(366) &
                      *y(16) + .250_r8*rxt(367)*y(48)
         mat(298) = rxt(392)*y(1)
         mat(454) = .167_r8*rxt(368)*y(9) + .167_r8*rxt(369)*y(11) + .167_r8*rxt(370) &
                      *y(24)

         mat(723) = -((rxt(343) + rxt(344)) * y(9) + rxt(345)*y(11) + rxt(346)*y(24) &
                      + rxt(347)*y(16) + rxt(348)*y(48))
         mat(1245) = -(rxt(343) + rxt(344)) * y(79)
         mat(1422) = -rxt(345)*y(79)
         mat(1165) = -rxt(346)*y(79)
         mat(870) = -rxt(347)*y(79)
         mat(788) = -rxt(348)*y(79)

         mat(1377) = rxt(335)*y(77) + .500_r8*rxt(341)*y(78) + .200_r8*rxt(349)*y(80)
         mat(741) = rxt(335)*y(23)
         mat(638) = .500_r8*rxt(341)*y(23)
         mat(125) = .200_r8*rxt(349)*y(23)

         mat(124) = -(rxt(349)*y(23))
         mat(1322) = -rxt(349)*y(80)

         mat(1122) = rxt(346)*y(79)
         mat(715) = rxt(346)*y(24)

         mat(762) = -(rxt(350)*y(9) + rxt(351)*y(11) + rxt(352)*y(24) + rxt(353)*y(16) &
                      + rxt(354)*y(48) + 4._r8*rxt(355)*y(76) + rxt(356)*y(10))
         mat(1247) = -rxt(350)*y(76)
         mat(1424) = -rxt(351)*y(76)
         mat(1167) = -rxt(352)*y(76)
         mat(872) = -rxt(353)*y(76)
         mat(790) = -rxt(354)*y(76)
         mat(1282) = -rxt(356)*y(76)

         mat(1010) = .200_r8*rxt(360)*y(83)
         mat(1379) = .500_r8*rxt(341)*y(78) + .500_r8*rxt(349)*y(80)
         mat(526) = .200_r8*rxt(360)*y(1)
         mat(639) = .500_r8*rxt(341)*y(23)
         mat(126) = .500_r8*rxt(349)*y(23)

         mat(472) = -(rxt(295)*y(9) + rxt(296)*y(24) + rxt(297)*y(16) + 4._r8*rxt(298) &
                      *y(46))
         mat(1231) = -rxt(295)*y(46)
         mat(1150) = -rxt(296)*y(46)
         mat(859) = -rxt(297)*y(46)

         mat(1357) = rxt(287)*y(45) + .500_r8*rxt(299)*y(47)
         mat(1092) = rxt(285)*y(45)
         mat(89) = rxt(287)*y(23) + rxt(285)*y(28)
         mat(130) = .500_r8*rxt(299)*y(23)

         mat(129) = -(rxt(299)*y(23))
         mat(1323) = -rxt(299)*y(47)

         mat(1123) = rxt(296)*y(46)
         mat(470) = rxt(296)*y(24)

         mat(296) = -(rxt(391)*y(23) + rxt(392)*y(1) + rxt(393)*y(11))
         mat(1344) = -rxt(391)*y(99)
         mat(990) = -rxt(392)*y(99)
         mat(1405) = -rxt(393)*y(99)

         mat(29) = -(rxt(320)*y(23))
         mat(1307) = -rxt(320)*y(60)

         mat(505) = -(rxt(316)*y(9) + rxt(317)*y(24) + rxt(318)*y(16))
         mat(1233) = -rxt(316)*y(61)
         mat(1152) = -rxt(317)*y(61)
         mat(860) = -rxt(318)*y(61)

         mat(1360) = rxt(320)*y(60) + rxt(319)*y(62)
         mat(30) = rxt(320)*y(23)
         mat(168) = rxt(319)*y(23)

         mat(166) = -(rxt(319)*y(23))
         mat(1329) = -rxt(319)*y(62)

         mat(1126) = rxt(317)*y(61)
         mat(503) = rxt(317)*y(24)

         mat(369) = -(rxt(324)*y(23))
         mat(1350) = -rxt(324)*y(63)

         mat(1223) = .500_r8*rxt(334)*y(73) + .250_r8*rxt(375)*y(84) &
                      + .100_r8*rxt(394)*y(100) + .820_r8*rxt(316)*y(61)
         mat(857) = .820_r8*rxt(318)*y(61)
         mat(113) = .500_r8*rxt(334)*y(9)
         mat(359) = .250_r8*rxt(375)*y(9)
         mat(559) = .100_r8*rxt(394)*y(9)
         mat(504) = .820_r8*rxt(316)*y(9) + .820_r8*rxt(318)*y(16)

         mat(172) = -(rxt(328)*y(23))
         mat(1330) = -rxt(328)*y(69)

         mat(1127) = rxt(326)*y(67)
         mat(615) = rxt(326)*y(24)

         mat(268) = -(rxt(277)*y(23))
         mat(1341) = -rxt(277)*y(18)

         mat(855) = 2.000_r8*rxt(276)*y(16) + .250_r8*rxt(366)*y(88) &
                      + .250_r8*rxt(347)*y(79) + .300_r8*rxt(297)*y(46) &
                      + .500_r8*rxt(327)*y(67) + .300_r8*rxt(381)*y(91)
         mat(689) = .250_r8*rxt(366)*y(16)
         mat(716) = .250_r8*rxt(347)*y(16)
         mat(471) = .300_r8*rxt(297)*y(16)
         mat(616) = .500_r8*rxt(327)*y(16)
         mat(670) = .300_r8*rxt(381)*y(16)

         mat(75) = -(rxt(310)*y(23))
         mat(1314) = -rxt(310)*y(51)

         mat(852) = .200_r8*rxt(297)*y(46)
         mat(469) = .200_r8*rxt(297)*y(16) + .800_r8*rxt(298)*y(46)

         mat(537) = -(rxt(308)*y(23))
         mat(1362) = -rxt(308)*y(52)

         mat(900) = rxt(291)*y(56)
         mat(1234) = .020_r8*rxt(362)*y(88) + .530_r8*rxt(343)*y(79) &
                      + .250_r8*rxt(378)*y(91)
         mat(1409) = .530_r8*rxt(345)*y(79) + .250_r8*rxt(379)*y(91)
         mat(861) = .260_r8*rxt(347)*y(79) + .100_r8*rxt(381)*y(91)
         mat(781) = .530_r8*rxt(348)*y(79) + .250_r8*rxt(382)*y(91)
         mat(692) = .020_r8*rxt(362)*y(9)
         mat(717) = .530_r8*rxt(343)*y(9) + .530_r8*rxt(345)*y(11) + .260_r8*rxt(347) &
                      *y(16) + .530_r8*rxt(348)*y(48)
         mat(190) = rxt(291)*y(4)
         mat(672) = .250_r8*rxt(378)*y(9) + .250_r8*rxt(379)*y(11) + .100_r8*rxt(381) &
                      *y(16) + .250_r8*rxt(382)*y(48)

         mat(629) = -(rxt(329)*y(23))
         mat(1371) = -rxt(329)*y(66)

         mat(1240) = .020_r8*rxt(362)*y(88) + .220_r8*rxt(343)*y(79) &
                      + .250_r8*rxt(378)*y(91)
         mat(1371) = mat(1371) + .500_r8*rxt(323)*y(65) + .500_r8*rxt(358)*y(81)
         mat(1417) = .220_r8*rxt(345)*y(79) + .250_r8*rxt(379)*y(91)
         mat(865) = .230_r8*rxt(347)*y(79) + .200_r8*rxt(327)*y(67) + .100_r8*rxt(381) &
                      *y(91)
         mat(263) = .500_r8*rxt(323)*y(23)
         mat(783) = .220_r8*rxt(348)*y(79) + .250_r8*rxt(382)*y(91)
         mat(289) = .500_r8*rxt(358)*y(23)
         mat(695) = .020_r8*rxt(362)*y(9)
         mat(720) = .220_r8*rxt(343)*y(9) + .220_r8*rxt(345)*y(11) + .230_r8*rxt(347) &
                      *y(16) + .220_r8*rxt(348)*y(48)
         mat(618) = .200_r8*rxt(327)*y(16)
         mat(674) = .250_r8*rxt(378)*y(9) + .250_r8*rxt(379)*y(11) + .100_r8*rxt(381) &
                      *y(16) + .250_r8*rxt(382)*y(48)

         mat(388) = -(rxt(289)*y(9) + rxt(290)*y(24))
         mat(1225) = -rxt(289)*y(55)
         mat(1145) = -rxt(290)*y(55)

         mat(1353) = rxt(288)*y(44)
         mat(235) = rxt(288)*y(23)

         mat(189) = -(rxt(291)*y(4))
         mat(890) = -rxt(291)*y(56)

         mat(1217) = .750_r8*rxt(289)*y(55)
         mat(387) = .750_r8*rxt(289)*y(9)


         mat(1119) = rxt(290)*y(55)
         mat(386) = rxt(290)*y(24)

         mat(139) = -(rxt(374)*y(23))
         mat(1324) = -rxt(374)*y(87)

         mat(1213) = .330_r8*rxt(362)*y(88)
         mat(1324) = mat(1324) + rxt(372)*y(90)
         mat(1403) = .400_r8*rxt(363)*y(88) + rxt(373)*y(90)
         mat(853) = .300_r8*rxt(366)*y(88)
         mat(776) = .400_r8*rxt(367)*y(88)
         mat(688) = .330_r8*rxt(362)*y(9) + .400_r8*rxt(363)*y(11) + .300_r8*rxt(366) &
                      *y(16) + .400_r8*rxt(367)*y(48)
         mat(542) = rxt(372)*y(23) + rxt(373)*y(11)

         mat(617) = -(rxt(325)*y(9) + rxt(326)*y(24) + rxt(327)*y(16))
         mat(1239) = -rxt(325)*y(67)
         mat(1158) = -rxt(326)*y(67)
         mat(864) = -rxt(327)*y(67)

         mat(1370) = rxt(324)*y(63) + rxt(328)*y(69)
         mat(370) = rxt(324)*y(23)
         mat(173) = rxt(328)*y(23)

         mat(661) = -(rxt(330)*y(23) + rxt(331)*y(11))
         mat(1374) = -rxt(330)*y(68)
         mat(1419) = -rxt(331)*y(68)

         mat(1005) = .950_r8*rxt(336)*y(77) + .800_r8*rxt(342)*y(78)
         mat(1242) = .450_r8*rxt(386)*y(96) + .020_r8*rxt(362)*y(88) &
                      + .250_r8*rxt(343)*y(79) + .250_r8*rxt(378)*y(91)
         mat(1374) = mat(1374) + rxt(332)*y(82) + rxt(329)*y(66)
         mat(1419) = mat(1419) + .250_r8*rxt(345)*y(79) + .250_r8*rxt(379)*y(91)
         mat(867) = .240_r8*rxt(347)*y(79) + .500_r8*rxt(327)*y(67) + .100_r8*rxt(381) &
                      *y(91)
         mat(785) = .250_r8*rxt(348)*y(79) + .250_r8*rxt(382)*y(91)
         mat(151) = rxt(332)*y(23)
         mat(249) = .450_r8*rxt(386)*y(9)
         mat(697) = .020_r8*rxt(362)*y(9)
         mat(740) = .950_r8*rxt(336)*y(1)
         mat(637) = .800_r8*rxt(342)*y(1)
         mat(721) = .250_r8*rxt(343)*y(9) + .250_r8*rxt(345)*y(11) + .240_r8*rxt(347) &
                      *y(16) + .250_r8*rxt(348)*y(48)
         mat(630) = rxt(329)*y(23)
         mat(619) = .500_r8*rxt(327)*y(16)
         mat(675) = .250_r8*rxt(378)*y(9) + .250_r8*rxt(379)*y(11) + .100_r8*rxt(381) &
                      *y(16) + .250_r8*rxt(382)*y(48)


      end subroutine nlnmat06

      subroutine nlnmat07( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(452) = -(rxt(368)*y(9) + rxt(369)*y(11) + rxt(370)*y(24))
         mat(1230) = -rxt(368)*y(89)
         mat(1407) = -rxt(369)*y(89)
         mat(1148) = -rxt(370)*y(89)

         mat(1407) = mat(1407) + rxt(361)*y(83)
         mat(518) = rxt(361)*y(11)

         mat(543) = -(rxt(372)*y(23) + rxt(373)*y(11))
         mat(1363) = -rxt(372)*y(90)
         mat(1410) = -rxt(373)*y(90)

         mat(1235) = .080_r8*rxt(362)*y(88) + .800_r8*rxt(344)*y(79) &
                      + .794_r8*rxt(368)*y(89)
         mat(1410) = mat(1410) + .794_r8*rxt(369)*y(89)
         mat(1154) = .794_r8*rxt(370)*y(89)
         mat(693) = .080_r8*rxt(362)*y(9)
         mat(718) = .800_r8*rxt(344)*y(9)
         mat(453) = .794_r8*rxt(368)*y(9) + .794_r8*rxt(369)*y(11) + .794_r8*rxt(370) &
                      *y(24)

         mat(676) = -(rxt(378)*y(9) + rxt(379)*y(11) + rxt(380)*y(24) + rxt(381)*y(16) &
                      + rxt(382)*y(48))
         mat(1243) = -rxt(378)*y(91)
         mat(1420) = -rxt(379)*y(91)
         mat(1163) = -rxt(380)*y(91)
         mat(868) = -rxt(381)*y(91)
         mat(786) = -rxt(382)*y(91)

         mat(1375) = rxt(374)*y(87) + rxt(383)*y(92) + .800_r8*rxt(365)*y(93)
         mat(140) = rxt(374)*y(23)
         mat(80) = rxt(383)*y(23)
         mat(274) = .800_r8*rxt(365)*y(23)

         mat(79) = -((rxt(383) + rxt(384)) * y(23))
         mat(1315) = -(rxt(383) + rxt(384)) * y(92)

         mat(1120) = rxt(380)*y(91)
         mat(669) = rxt(380)*y(24)

         mat(272) = -(rxt(365)*y(23))
         mat(1342) = -rxt(365)*y(93)

         mat(1137) = rxt(364)*y(88)
         mat(690) = rxt(364)*y(24)

         mat(94) = -(rxt(283)*y(28) + rxt(286)*y(23))
         mat(1086) = -rxt(283)*y(128)
         mat(1318) = -rxt(286)*y(128)

         mat(241) = -(rxt(279)*y(23))
         mat(1337) = -rxt(279)*y(129)

         mat(989) = .500_r8*rxt(293)*y(44)
         mat(1218) = rxt(281)*y(130)
         mat(1337) = mat(1337) + .350_r8*rxt(286)*y(128)
         mat(1133) = rxt(282)*y(130)
         mat(234) = .500_r8*rxt(293)*y(1)
         mat(95) = .350_r8*rxt(286)*y(23)
         mat(179) = rxt(281)*y(9) + rxt(282)*y(24)

         mat(178) = -(rxt(281)*y(9) + rxt(282)*y(24))
         mat(1215) = -rxt(281)*y(130)
         mat(1128) = -rxt(282)*y(130)

         mat(1487) = rxt(272)*y(24)
         mat(1128) = mat(1128) + rxt(272)*y(19)

         mat(44) = -(rxt(154)*y(3))
         mat(960) = -rxt(154)*y(131)

         mat(65) = -(rxt(155)*y(3))
         mat(963) = -rxt(155)*y(132)


         mat(647) = rxt(251)*y(134)
         mat(1445) = rxt(253)*y(134)
         mat(1059) = rxt(250)*y(134)
         mat(405) = rxt(251)*y(21) + rxt(253)*y(12) + rxt(250)*y(158)

         mat(406) = -(rxt(250)*y(158) + rxt(251)*y(21) + rxt(253)*y(12))
         mat(1061) = -rxt(250)*y(134)
         mat(648) = -rxt(251)*y(134)
         mat(1446) = -rxt(253)*y(134)

         mat(964) = 2.000_r8*rxt(154)*y(131) + rxt(155)*y(132)
         mat(45) = 2.000_r8*rxt(154)*y(3)
         mat(66) = rxt(155)*y(3)

         mat(552) = -(rxt(413)*y(23))
         mat(1364) = -rxt(413)*y(135)

         mat(997) = rxt(408)*y(139)
         mat(901) = rxt(407)*y(139)
         mat(1277) = rxt(409)*y(139)
         mat(1364) = mat(1364) + (rxt(415)+.500_r8*rxt(416))*y(136) + rxt(402)*y(137) &
                      + rxt(406)*y(139)
         mat(1411) = rxt(417)*y(136)
         mat(1036) = rxt(410)*y(139)
         mat(135) = rxt(412)*y(139)
         mat(1192) = rxt(411)*y(139)
         mat(101) = (rxt(415)+.500_r8*rxt(416))*y(23) + rxt(417)*y(11)
         mat(144) = rxt(402)*y(23)
         mat(806) = rxt(408)*y(1) + rxt(407)*y(4) + rxt(409)*y(10) + rxt(406)*y(23) &
                      + rxt(410)*y(30) + rxt(412)*y(31) + rxt(411)*y(38)

         mat(100) = -((rxt(415) + rxt(416)) * y(23) + rxt(417)*y(11))
         mat(1319) = -(rxt(415) + rxt(416)) * y(136)
         mat(1401) = -rxt(417)*y(136)

         mat(142) = -(rxt(401)*y(2) + rxt(402)*y(23))
         mat(921) = -rxt(401)*y(137)
         mat(1325) = -rxt(402)*y(137)

         mat(375) = -(rxt(403)*y(23) + rxt(404)*y(4) + rxt(405)*y(1))
         mat(1351) = -rxt(403)*y(138)
         mat(895) = -rxt(404)*y(138)
         mat(992) = -rxt(405)*y(138)

         mat(807) = -(rxt(406)*y(23) + rxt(407)*y(4) + rxt(408)*y(1) + rxt(409)*y(10) &
                      + rxt(410)*y(30) + rxt(411)*y(38) + rxt(412)*y(31))
         mat(1381) = -rxt(406)*y(139)
         mat(903) = -rxt(407)*y(139)
         mat(1012) = -rxt(408)*y(139)
         mat(1284) = -rxt(409)*y(139)
         mat(1038) = -rxt(410)*y(139)
         mat(1193) = -rxt(411)*y(139)
         mat(136) = -rxt(412)*y(139)

         mat(1012) = mat(1012) + rxt(405)*y(138)
         mat(940) = rxt(401)*y(137)
         mat(903) = mat(903) + rxt(404)*y(138)
         mat(1381) = mat(1381) + rxt(403)*y(138)
         mat(146) = rxt(401)*y(2)
         mat(376) = rxt(405)*y(1) + rxt(404)*y(4) + rxt(403)*y(23)

         mat(84) = -(rxt(414)*y(158))
         mat(1060) = -rxt(414)*y(140)

         mat(1316) = rxt(413)*y(135)
         mat(551) = rxt(413)*y(23)


         mat(1058) = rxt(414)*y(140)
         mat(83) = rxt(414)*y(158)
      end subroutine nlnmat07
      subroutine nlnmat_finit( mat, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(inout) :: mat(nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
         mat( 1) = lmat( 1)
         mat( 2) = lmat( 2)
         mat( 3) = lmat( 3)
         mat( 4) = lmat( 4)
         mat( 5) = lmat( 5)
         mat( 6) = lmat( 6)
         mat( 7) = lmat( 7)
         mat( 8) = lmat( 8)
         mat( 9) = lmat( 9)
         mat( 10) = lmat( 10)
         mat( 11) = lmat( 11)
         mat( 12) = lmat( 12)
         mat( 13) = lmat( 13)
         mat( 14) = lmat( 14)
         mat( 15) = lmat( 15)
         mat( 16) = lmat( 16)
         mat( 17) = mat( 17) + lmat( 17)
         mat( 20) = lmat( 20)
         mat( 21) = lmat( 21)
         mat( 22) = lmat( 22)
         mat( 23) = mat( 23) + lmat( 23)
         mat( 26) = mat( 26) + lmat( 26)
         mat( 29) = mat( 29) + lmat( 29)
         mat( 33) = mat( 33) + lmat( 33)
         mat( 38) = mat( 38) + lmat( 38)
         mat( 41) = lmat( 41)
         mat( 42) = lmat( 42)
         mat( 43) = lmat( 43)
         mat( 44) = mat( 44) + lmat( 44)
         mat( 45) = mat( 45) + lmat( 45)
         mat( 47) = lmat( 47)
         mat( 48) = lmat( 48)
         mat( 49) = lmat( 49)
         mat( 50) = mat( 50) + lmat( 50)
         mat( 51) = mat( 51) + lmat( 51)
         mat( 52) = mat( 52) + lmat( 52)
         mat( 53) = mat( 53) + lmat( 53)
         mat( 54) = lmat( 54)
         mat( 55) = lmat( 55)
         mat( 56) = lmat( 56)
         mat( 57) = mat( 57) + lmat( 57)
         mat( 61) = mat( 61) + lmat( 61)
         mat( 65) = mat( 65) + lmat( 65)
         mat( 66) = mat( 66) + lmat( 66)
         mat( 68) = mat( 68) + lmat( 68)
         mat( 69) = lmat( 69)
         mat( 70) = lmat( 70)
         mat( 71) = lmat( 71)
         mat( 72) = lmat( 72)
         mat( 73) = lmat( 73)
         mat( 74) = lmat( 74)
         mat( 75) = mat( 75) + lmat( 75)
         mat( 79) = mat( 79) + lmat( 79)
         mat( 82) = mat( 82) + lmat( 82)
         mat( 84) = mat( 84) + lmat( 84)
         mat( 85) = lmat( 85)
         mat( 86) = lmat( 86)
         mat( 88) = mat( 88) + lmat( 88)
         mat( 94) = mat( 94) + lmat( 94)
         mat( 100) = mat( 100) + lmat( 100)
         mat( 106) = lmat( 106)
         mat( 107) = lmat( 107)
         mat( 108) = lmat( 108)
         mat( 109) = lmat( 109)
         mat( 110) = lmat( 110)
         mat( 111) = lmat( 111)
         mat( 112) = mat( 112) + lmat( 112)
         mat( 119) = mat( 119) + lmat( 119)
         mat( 121) = lmat( 121)
         mat( 122) = lmat( 122)
         mat( 123) = mat( 123) + lmat( 123)
         mat( 124) = mat( 124) + lmat( 124)
         mat( 129) = mat( 129) + lmat( 129)
         mat( 131) = mat( 131) + lmat( 131)
         mat( 132) = lmat( 132)
         mat( 133) = mat( 133) + lmat( 133)
         mat( 134) = mat( 134) + lmat( 134)
         mat( 137) = lmat( 137)
         mat( 138) = mat( 138) + lmat( 138)
         mat( 139) = mat( 139) + lmat( 139)
         mat( 142) = mat( 142) + lmat( 142)
         mat( 143) = lmat( 143)
         mat( 145) = mat( 145) + lmat( 145)
         mat( 150) = mat( 150) + lmat( 150)
         mat( 154) = mat( 154) + lmat( 154)
         mat( 157) = mat( 157) + lmat( 157)
         mat( 158) = lmat( 158)
         mat( 159) = mat( 159) + lmat( 159)
         mat( 160) = mat( 160) + lmat( 160)
         mat( 162) = lmat( 162)
         mat( 163) = lmat( 163)
         mat( 164) = lmat( 164)
         mat( 165) = mat( 165) + lmat( 165)
         mat( 166) = mat( 166) + lmat( 166)
         mat( 167) = lmat( 167)
         mat( 170) = lmat( 170)
         mat( 171) = mat( 171) + lmat( 171)
         mat( 172) = mat( 172) + lmat( 172)
         mat( 174) = lmat( 174)
         mat( 176) = mat( 176) + lmat( 176)
         mat( 177) = lmat( 177)
         mat( 178) = mat( 178) + lmat( 178)
         mat( 180) = mat( 180) + lmat( 180)
         mat( 183) = lmat( 183)
         mat( 184) = mat( 184) + lmat( 184)
         mat( 186) = lmat( 186)
         mat( 187) = lmat( 187)
         mat( 189) = mat( 189) + lmat( 189)
         mat( 192) = mat( 192) + lmat( 192)
         mat( 193) = lmat( 193)
         mat( 194) = mat( 194) + lmat( 194)
         mat( 201) = mat( 201) + lmat( 201)
         mat( 202) = lmat( 202)
         mat( 203) = lmat( 203)
         mat( 204) = lmat( 204)
         mat( 206) = mat( 206) + lmat( 206)
         mat( 208) = mat( 208) + lmat( 208)
         mat( 209) = lmat( 209)
         mat( 211) = lmat( 211)
         mat( 212) = lmat( 212)
         mat( 213) = lmat( 213)
         mat( 214) = mat( 214) + lmat( 214)
         mat( 215) = mat( 215) + lmat( 215)
         mat( 218) = lmat( 218)
         mat( 219) = mat( 219) + lmat( 219)
         mat( 220) = mat( 220) + lmat( 220)
         mat( 221) = lmat( 221)
         mat( 222) = mat( 222) + lmat( 222)
         mat( 227) = mat( 227) + lmat( 227)
         mat( 229) = lmat( 229)
         mat( 231) = mat( 231) + lmat( 231)
         mat( 233) = mat( 233) + lmat( 233)
         mat( 241) = mat( 241) + lmat( 241)
         mat( 246) = mat( 246) + lmat( 246)
         mat( 254) = lmat( 254)
         mat( 255) = lmat( 255)
         mat( 256) = lmat( 256)
         mat( 257) = lmat( 257)
         mat( 258) = lmat( 258)
         mat( 259) = lmat( 259)
         mat( 260) = mat( 260) + lmat( 260)
         mat( 262) = lmat( 262)
         mat( 265) = lmat( 265)
         mat( 266) = mat( 266) + lmat( 266)
         mat( 267) = lmat( 267)
         mat( 268) = mat( 268) + lmat( 268)
         mat( 272) = mat( 272) + lmat( 272)
         mat( 273) = lmat( 273)
         mat( 276) = lmat( 276)
         mat( 277) = lmat( 277)
         mat( 279) = lmat( 279)
         mat( 280) = mat( 280) + lmat( 280)
         mat( 281) = lmat( 281)
         mat( 282) = lmat( 282)
         mat( 284) = mat( 284) + lmat( 284)
         mat( 285) = lmat( 285)
         mat( 286) = mat( 286) + lmat( 286)
         mat( 287) = lmat( 287)
         mat( 288) = mat( 288) + lmat( 288)
         mat( 290) = lmat( 290)
         mat( 292) = lmat( 292)
         mat( 296) = mat( 296) + lmat( 296)
         mat( 305) = mat( 305) + lmat( 305)
         mat( 306) = mat( 306) + lmat( 306)
         mat( 307) = lmat( 307)
         mat( 308) = lmat( 308)
         mat( 309) = lmat( 309)
         mat( 312) = mat( 312) + lmat( 312)
         mat( 318) = mat( 318) + lmat( 318)
         mat( 319) = mat( 319) + lmat( 319)
         mat( 323) = lmat( 323)
         mat( 324) = mat( 324) + lmat( 324)
         mat( 327) = lmat( 327)
         mat( 329) = lmat( 329)
         mat( 331) = lmat( 331)
         mat( 332) = mat( 332) + lmat( 332)
         mat( 333) = lmat( 333)
         mat( 335) = mat( 335) + lmat( 335)
         mat( 344) = mat( 344) + lmat( 344)
         mat( 358) = mat( 358) + lmat( 358)
         mat( 369) = mat( 369) + lmat( 369)
         mat( 371) = lmat( 371)
         mat( 372) = lmat( 372)
         mat( 375) = mat( 375) + lmat( 375)
         mat( 382) = mat( 382) + lmat( 382)
         mat( 383) = mat( 383) + lmat( 383)
         mat( 384) = mat( 384) + lmat( 384)
         mat( 388) = mat( 388) + lmat( 388)
         mat( 397) = mat( 397) + lmat( 397)
         mat( 399) = lmat( 399)
         mat( 404) = mat( 404) + lmat( 404)
         mat( 405) = mat( 405) + lmat( 405)
         mat( 406) = mat( 406) + lmat( 406)
         mat( 408) = lmat( 408)
         mat( 414) = mat( 414) + lmat( 414)
         mat( 415) = mat( 415) + lmat( 415)
         mat( 421) = mat( 421) + lmat( 421)
         mat( 423) = mat( 423) + lmat( 423)
         mat( 434) = mat( 434) + lmat( 434)
         mat( 442) = mat( 442) + lmat( 442)
         mat( 452) = mat( 452) + lmat( 452)
         mat( 462) = mat( 462) + lmat( 462)
         mat( 463) = mat( 463) + lmat( 463)
         mat( 468) = lmat( 468)
         mat( 472) = mat( 472) + lmat( 472)
         mat( 481) = lmat( 481)
         mat( 485) = lmat( 485)
         mat( 486) = mat( 486) + lmat( 486)
         mat( 496) = mat( 496) + lmat( 496)
         mat( 501) = mat( 501) + lmat( 501)
         mat( 502) = mat( 502) + lmat( 502)
         mat( 505) = mat( 505) + lmat( 505)
         mat( 519) = mat( 519) + lmat( 519)
         mat( 537) = mat( 537) + lmat( 537)
         mat( 538) = lmat( 538)
         mat( 539) = mat( 539) + lmat( 539)
         mat( 541) = mat( 541) + lmat( 541)
         mat( 543) = mat( 543) + lmat( 543)
         mat( 544) = lmat( 544)
         mat( 546) = mat( 546) + lmat( 546)
         mat( 547) = mat( 547) + lmat( 547)
         mat( 550) = lmat( 550)
         mat( 552) = mat( 552) + lmat( 552)
         mat( 553) = lmat( 553)
         mat( 554) = lmat( 554)
         mat( 560) = mat( 560) + lmat( 560)
         mat( 572) = mat( 572) + lmat( 572)
         mat( 573) = mat( 573) + lmat( 573)
         mat( 576) = mat( 576) + lmat( 576)
         mat( 578) = mat( 578) + lmat( 578)
         mat( 579) = lmat( 579)
         mat( 581) = mat( 581) + lmat( 581)
         mat( 582) = mat( 582) + lmat( 582)
         mat( 586) = mat( 586) + lmat( 586)
         mat( 601) = mat( 601) + lmat( 601)
         mat( 605) = lmat( 605)
         mat( 606) = mat( 606) + lmat( 606)
         mat( 608) = lmat( 608)
         mat( 610) = lmat( 610)
         mat( 617) = mat( 617) + lmat( 617)
         mat( 629) = mat( 629) + lmat( 629)
         mat( 631) = lmat( 631)
         mat( 632) = mat( 632) + lmat( 632)
         mat( 634) = lmat( 634)
         mat( 635) = mat( 635) + lmat( 635)
         mat( 636) = mat( 636) + lmat( 636)
         mat( 639) = mat( 639) + lmat( 639)
         mat( 640) = lmat( 640)
         mat( 643) = mat( 643) + lmat( 643)
         mat( 646) = mat( 646) + lmat( 646)
         mat( 649) = mat( 649) + lmat( 649)
         mat( 660) = mat( 660) + lmat( 660)
         mat( 661) = mat( 661) + lmat( 661)
         mat( 662) = mat( 662) + lmat( 662)
         mat( 664) = lmat( 664)
         mat( 676) = mat( 676) + lmat( 676)
         mat( 699) = mat( 699) + lmat( 699)
         mat( 723) = mat( 723) + lmat( 723)
         mat( 736) = lmat( 736)
         mat( 737) = mat( 737) + lmat( 737)
         mat( 742) = mat( 742) + lmat( 742)
         mat( 744) = lmat( 744)
         mat( 745) = lmat( 745)
         mat( 762) = mat( 762) + lmat( 762)
         mat( 791) = mat( 791) + lmat( 791)
         mat( 805) = lmat( 805)
         mat( 807) = mat( 807) + lmat( 807)
         mat( 810) = mat( 810) + lmat( 810)
         mat( 826) = mat( 826) + lmat( 826)
         mat( 832) = mat( 832) + lmat( 832)
         mat( 838) = lmat( 838)
         mat( 841) = mat( 841) + lmat( 841)
         mat( 874) = mat( 874) + lmat( 874)
         mat( 893) = mat( 893) + lmat( 893)
         mat( 896) = mat( 896) + lmat( 896)
         mat( 898) = lmat( 898)
         mat( 905) = mat( 905) + lmat( 905)
         mat( 906) = mat( 906) + lmat( 906)
         mat( 907) = mat( 907) + lmat( 907)
         mat( 925) = mat( 925) + lmat( 925)
         mat( 932) = lmat( 932)
         mat( 945) = mat( 945) + lmat( 945)
         mat( 960) = mat( 960) + lmat( 960)
         mat( 963) = mat( 963) + lmat( 963)
         mat( 964) = mat( 964) + lmat( 964)
         mat( 966) = mat( 966) + lmat( 966)
         mat( 968) = mat( 968) + lmat( 968)
         mat( 969) = lmat( 969)
         mat( 970) = mat( 970) + lmat( 970)
         mat( 971) = mat( 971) + lmat( 971)
         mat( 972) = mat( 972) + lmat( 972)
         mat( 976) = mat( 976) + lmat( 976)
         mat( 977) = lmat( 977)
         mat( 979) = lmat( 979)
         mat( 981) = mat( 981) + lmat( 981)
         mat( 984) = mat( 984) + lmat( 984)
         mat( 985) = lmat( 985)
         mat( 986) = mat( 986) + lmat( 986)
         mat(1015) = mat(1015) + lmat(1015)
         mat(1016) = mat(1016) + lmat(1016)
         mat(1017) = mat(1017) + lmat(1017)
         mat(1018) = mat(1018) + lmat(1018)
         mat(1043) = mat(1043) + lmat(1043)
         mat(1046) = mat(1046) + lmat(1046)
         mat(1048) = mat(1048) + lmat(1048)
         mat(1063) = lmat(1063)
         mat(1069) = lmat(1069)
         mat(1070) = mat(1070) + lmat(1070)
         mat(1073) = mat(1073) + lmat(1073)
         mat(1079) = mat(1079) + lmat(1079)
         mat(1082) = lmat(1082)
         mat(1096) = mat(1096) + lmat(1096)
         mat(1100) = mat(1100) + lmat(1100)
         mat(1101) = lmat(1101)
         mat(1102) = lmat(1102)
         mat(1109) = mat(1109) + lmat(1109)
         mat(1110) = mat(1110) + lmat(1110)
         mat(1138) = mat(1138) + lmat(1138)
         mat(1179) = mat(1179) + lmat(1179)
         mat(1195) = mat(1195) + lmat(1195)
         mat(1197) = mat(1197) + lmat(1197)
         mat(1204) = mat(1204) + lmat(1204)
         mat(1227) = mat(1227) + lmat(1227)
         mat(1228) = lmat(1228)
         mat(1232) = mat(1232) + lmat(1232)
         mat(1252) = mat(1252) + lmat(1252)
         mat(1260) = mat(1260) + lmat(1260)
         mat(1289) = mat(1289) + lmat(1289)
         mat(1297) = mat(1297) + lmat(1297)
         mat(1298) = mat(1298) + lmat(1298)
         mat(1299) = mat(1299) + lmat(1299)
         mat(1301) = mat(1301) + lmat(1301)
         mat(1310) = lmat(1310)
         mat(1313) = lmat(1313)
         mat(1383) = mat(1383) + lmat(1383)
         mat(1384) = mat(1384) + lmat(1384)
         mat(1390) = mat(1390) + lmat(1390)
         mat(1391) = mat(1391) + lmat(1391)
         mat(1392) = mat(1392) + lmat(1392)
         mat(1396) = mat(1396) + lmat(1396)
         mat(1429) = mat(1429) + lmat(1429)
         mat(1430) = mat(1430) + lmat(1430)
         mat(1438) = mat(1438) + lmat(1438)
         mat(1439) = mat(1439) + lmat(1439)
         mat(1441) = mat(1441) + lmat(1441)
         mat(1442) = mat(1442) + lmat(1442)
         mat(1461) = lmat(1461)
         mat(1462) = mat(1462) + lmat(1462)
         mat(1464) = mat(1464) + lmat(1464)
         mat(1485) = mat(1485) + lmat(1485)
         mat(1490) = mat(1490) + lmat(1490)
         mat(1491) = lmat(1491)
         mat(1509) = mat(1509) + lmat(1509)
         mat(1510) = mat(1510) + lmat(1510)
         mat( 253) = 0._r8
         mat( 325) = 0._r8
         mat( 328) = 0._r8
         mat( 330) = 0._r8
         mat( 341) = 0._r8
         mat( 349) = 0._r8
         mat( 352) = 0._r8
         mat( 353) = 0._r8
         mat( 357) = 0._r8
         mat( 360) = 0._r8
         mat( 362) = 0._r8
         mat( 363) = 0._r8
         mat( 367) = 0._r8
         mat( 389) = 0._r8
         mat( 390) = 0._r8
         mat( 394) = 0._r8
         mat( 402) = 0._r8
         mat( 426) = 0._r8
         mat( 428) = 0._r8
         mat( 429) = 0._r8
         mat( 436) = 0._r8
         mat( 437) = 0._r8
         mat( 440) = 0._r8
         mat( 444) = 0._r8
         mat( 446) = 0._r8
         mat( 450) = 0._r8
         mat( 479) = 0._r8
         mat( 482) = 0._r8
         mat( 487) = 0._r8
         mat( 490) = 0._r8
         mat( 507) = 0._r8
         mat( 508) = 0._r8
         mat( 511) = 0._r8
         mat( 515) = 0._r8
         mat( 520) = 0._r8
         mat( 527) = 0._r8
         mat( 529) = 0._r8
         mat( 531) = 0._r8
         mat( 532) = 0._r8
         mat( 545) = 0._r8
         mat( 555) = 0._r8
         mat( 561) = 0._r8
         mat( 564) = 0._r8
         mat( 565) = 0._r8
         mat( 566) = 0._r8
         mat( 570) = 0._r8
         mat( 577) = 0._r8
         mat( 589) = 0._r8
         mat( 590) = 0._r8
         mat( 592) = 0._r8
         mat( 594) = 0._r8
         mat( 596) = 0._r8
         mat( 597) = 0._r8
         mat( 614) = 0._r8
         mat( 623) = 0._r8
         mat( 627) = 0._r8
         mat( 645) = 0._r8
         mat( 651) = 0._r8
         mat( 657) = 0._r8
         mat( 658) = 0._r8
         mat( 668) = 0._r8
         mat( 679) = 0._r8
         mat( 683) = 0._r8
         mat( 685) = 0._r8
         mat( 686) = 0._r8
         mat( 694) = 0._r8
         mat( 698) = 0._r8
         mat( 700) = 0._r8
         mat( 702) = 0._r8
         mat( 705) = 0._r8
         mat( 706) = 0._r8
         mat( 710) = 0._r8
         mat( 712) = 0._r8
         mat( 713) = 0._r8
         mat( 722) = 0._r8
         mat( 724) = 0._r8
         mat( 727) = 0._r8
         mat( 731) = 0._r8
         mat( 733) = 0._r8
         mat( 734) = 0._r8
         mat( 739) = 0._r8
         mat( 743) = 0._r8
         mat( 746) = 0._r8
         mat( 748) = 0._r8
         mat( 750) = 0._r8
         mat( 751) = 0._r8
         mat( 753) = 0._r8
         mat( 754) = 0._r8
         mat( 755) = 0._r8
         mat( 760) = 0._r8
         mat( 761) = 0._r8
         mat( 767) = 0._r8
         mat( 771) = 0._r8
         mat( 773) = 0._r8
         mat( 774) = 0._r8
         mat( 793) = 0._r8
         mat( 795) = 0._r8
         mat( 799) = 0._r8
         mat( 800) = 0._r8
         mat( 801) = 0._r8
         mat( 802) = 0._r8
         mat( 813) = 0._r8
         mat( 815) = 0._r8
         mat( 827) = 0._r8
         mat( 830) = 0._r8
         mat( 833) = 0._r8
         mat( 834) = 0._r8
         mat( 836) = 0._r8
         mat( 843) = 0._r8
         mat( 844) = 0._r8
         mat( 846) = 0._r8
         mat( 849) = 0._r8
         mat( 850) = 0._r8
         mat( 876) = 0._r8
         mat( 878) = 0._r8
         mat( 883) = 0._r8
         mat( 884) = 0._r8
         mat( 885) = 0._r8
         mat( 886) = 0._r8
         mat( 902) = 0._r8
         mat( 904) = 0._r8
         mat( 909) = 0._r8
         mat( 910) = 0._r8
         mat( 911) = 0._r8
         mat( 913) = 0._r8
         mat( 915) = 0._r8
         mat( 916) = 0._r8
         mat( 918) = 0._r8
         mat( 928) = 0._r8
         mat( 930) = 0._r8
         mat( 936) = 0._r8
         mat( 943) = 0._r8
         mat( 946) = 0._r8
         mat( 949) = 0._r8
         mat( 957) = 0._r8
         mat( 974) = 0._r8
         mat( 978) = 0._r8
         mat( 980) = 0._r8
         mat( 982) = 0._r8
         mat( 983) = 0._r8
         mat( 993) = 0._r8
         mat( 995) = 0._r8
         mat( 996) = 0._r8
         mat( 998) = 0._r8
         mat(1002) = 0._r8
         mat(1003) = 0._r8
         mat(1006) = 0._r8
         mat(1007) = 0._r8
         mat(1008) = 0._r8
         mat(1011) = 0._r8
         mat(1020) = 0._r8
         mat(1028) = 0._r8
         mat(1044) = 0._r8
         mat(1045) = 0._r8
         mat(1047) = 0._r8
         mat(1054) = 0._r8
         mat(1055) = 0._r8
         mat(1056) = 0._r8
         mat(1062) = 0._r8
         mat(1064) = 0._r8
         mat(1065) = 0._r8
         mat(1066) = 0._r8
         mat(1067) = 0._r8
         mat(1068) = 0._r8
         mat(1071) = 0._r8
         mat(1072) = 0._r8
         mat(1074) = 0._r8
         mat(1075) = 0._r8
         mat(1076) = 0._r8
         mat(1077) = 0._r8
         mat(1078) = 0._r8
         mat(1080) = 0._r8
         mat(1081) = 0._r8
         mat(1083) = 0._r8
         mat(1088) = 0._r8
         mat(1090) = 0._r8
         mat(1091) = 0._r8
         mat(1094) = 0._r8
         mat(1097) = 0._r8
         mat(1099) = 0._r8
         mat(1104) = 0._r8
         mat(1105) = 0._r8
         mat(1108) = 0._r8
         mat(1111) = 0._r8
         mat(1112) = 0._r8
         mat(1113) = 0._r8
         mat(1116) = 0._r8
         mat(1129) = 0._r8
         mat(1135) = 0._r8
         mat(1143) = 0._r8
         mat(1144) = 0._r8
         mat(1153) = 0._r8
         mat(1156) = 0._r8
         mat(1157) = 0._r8
         mat(1159) = 0._r8
         mat(1162) = 0._r8
         mat(1174) = 0._r8
         mat(1185) = 0._r8
         mat(1194) = 0._r8
         mat(1198) = 0._r8
         mat(1199) = 0._r8
         mat(1201) = 0._r8
         mat(1208) = 0._r8
         mat(1209) = 0._r8
         mat(1210) = 0._r8
         mat(1211) = 0._r8
         mat(1253) = 0._r8
         mat(1256) = 0._r8
         mat(1264) = 0._r8
         mat(1265) = 0._r8
         mat(1274) = 0._r8
         mat(1275) = 0._r8
         mat(1279) = 0._r8
         mat(1280) = 0._r8
         mat(1281) = 0._r8
         mat(1285) = 0._r8
         mat(1286) = 0._r8
         mat(1287) = 0._r8
         mat(1290) = 0._r8
         mat(1293) = 0._r8
         mat(1294) = 0._r8
         mat(1302) = 0._r8
         mat(1303) = 0._r8
         mat(1339) = 0._r8
         mat(1354) = 0._r8
         mat(1387) = 0._r8
         mat(1416) = 0._r8
         mat(1426) = 0._r8
         mat(1427) = 0._r8
         mat(1428) = 0._r8
         mat(1431) = 0._r8
         mat(1432) = 0._r8
         mat(1433) = 0._r8
         mat(1434) = 0._r8
         mat(1435) = 0._r8
         mat(1437) = 0._r8
         mat(1443) = 0._r8
         mat(1447) = 0._r8
         mat(1448) = 0._r8
         mat(1449) = 0._r8
         mat(1450) = 0._r8
         mat(1451) = 0._r8
         mat(1452) = 0._r8
         mat(1453) = 0._r8
         mat(1454) = 0._r8
         mat(1455) = 0._r8
         mat(1457) = 0._r8
         mat(1458) = 0._r8
         mat(1459) = 0._r8
         mat(1460) = 0._r8
         mat(1465) = 0._r8
         mat(1466) = 0._r8
         mat(1468) = 0._r8
         mat(1469) = 0._r8
         mat(1470) = 0._r8
         mat(1473) = 0._r8
         mat(1475) = 0._r8
         mat(1477) = 0._r8
         mat(1479) = 0._r8
         mat(1480) = 0._r8
         mat(1481) = 0._r8
         mat(1483) = 0._r8
         mat(1484) = 0._r8
         mat(1486) = 0._r8
         mat(1488) = 0._r8
         mat(1494) = 0._r8
         mat(1495) = 0._r8
         mat(1497) = 0._r8
         mat(1498) = 0._r8
         mat(1499) = 0._r8
         mat(1503) = 0._r8
         mat(1504) = 0._r8
         mat(1505) = 0._r8
         mat( 1) = mat( 1) - dti
         mat( 2) = mat( 2) - dti
         mat( 3) = mat( 3) - dti
         mat( 4) = mat( 4) - dti
         mat( 5) = mat( 5) - dti
         mat( 6) = mat( 6) - dti
         mat( 7) = mat( 7) - dti
         mat( 8) = mat( 8) - dti
         mat( 9) = mat( 9) - dti
         mat( 10) = mat( 10) - dti
         mat( 11) = mat( 11) - dti
         mat( 12) = mat( 12) - dti
         mat( 13) = mat( 13) - dti
         mat( 14) = mat( 14) - dti
         mat( 15) = mat( 15) - dti
         mat( 16) = mat( 16) - dti
         mat( 17) = mat( 17) - dti
         mat( 20) = mat( 20) - dti
         mat( 23) = mat( 23) - dti
         mat( 26) = mat( 26) - dti
         mat( 29) = mat( 29) - dti
         mat( 33) = mat( 33) - dti
         mat( 38) = mat( 38) - dti
         mat( 41) = mat( 41) - dti
         mat( 44) = mat( 44) - dti
         mat( 47) = mat( 47) - dti
         mat( 50) = mat( 50) - dti
         mat( 53) = mat( 53) - dti
         mat( 55) = mat( 55) - dti
         mat( 57) = mat( 57) - dti
         mat( 61) = mat( 61) - dti
         mat( 65) = mat( 65) - dti
         mat( 69) = mat( 69) - dti
         mat( 72) = mat( 72) - dti
         mat( 75) = mat( 75) - dti
         mat( 79) = mat( 79) - dti
         mat( 84) = mat( 84) - dti
         mat( 88) = mat( 88) - dti
         mat( 94) = mat( 94) - dti
         mat( 100) = mat( 100) - dti
         mat( 106) = mat( 106) - dti
         mat( 112) = mat( 112) - dti
         mat( 119) = mat( 119) - dti
         mat( 124) = mat( 124) - dti
         mat( 129) = mat( 129) - dti
         mat( 134) = mat( 134) - dti
         mat( 139) = mat( 139) - dti
         mat( 142) = mat( 142) - dti
         mat( 150) = mat( 150) - dti
         mat( 154) = mat( 154) - dti
         mat( 160) = mat( 160) - dti
         mat( 166) = mat( 166) - dti
         mat( 172) = mat( 172) - dti
         mat( 178) = mat( 178) - dti
         mat( 184) = mat( 184) - dti
         mat( 189) = mat( 189) - dti
         mat( 194) = mat( 194) - dti
         mat( 201) = mat( 201) - dti
         mat( 208) = mat( 208) - dti
         mat( 215) = mat( 215) - dti
         mat( 222) = mat( 222) - dti
         mat( 227) = mat( 227) - dti
         mat( 233) = mat( 233) - dti
         mat( 241) = mat( 241) - dti
         mat( 246) = mat( 246) - dti
         mat( 254) = mat( 254) - dti
         mat( 260) = mat( 260) - dti
         mat( 268) = mat( 268) - dti
         mat( 272) = mat( 272) - dti
         mat( 280) = mat( 280) - dti
         mat( 288) = mat( 288) - dti
         mat( 296) = mat( 296) - dti
         mat( 305) = mat( 305) - dti
         mat( 312) = mat( 312) - dti
         mat( 319) = mat( 319) - dti
         mat( 324) = mat( 324) - dti
         mat( 335) = mat( 335) - dti
         mat( 344) = mat( 344) - dti
         mat( 358) = mat( 358) - dti
         mat( 369) = mat( 369) - dti
         mat( 375) = mat( 375) - dti
         mat( 382) = mat( 382) - dti
         mat( 388) = mat( 388) - dti
         mat( 397) = mat( 397) - dti
         mat( 406) = mat( 406) - dti
         mat( 414) = mat( 414) - dti
         mat( 423) = mat( 423) - dti
         mat( 434) = mat( 434) - dti
         mat( 442) = mat( 442) - dti
         mat( 452) = mat( 452) - dti
         mat( 462) = mat( 462) - dti
         mat( 472) = mat( 472) - dti
         mat( 486) = mat( 486) - dti
         mat( 496) = mat( 496) - dti
         mat( 505) = mat( 505) - dti
         mat( 519) = mat( 519) - dti
         mat( 537) = mat( 537) - dti
         mat( 543) = mat( 543) - dti
         mat( 552) = mat( 552) - dti
         mat( 560) = mat( 560) - dti
         mat( 573) = mat( 573) - dti
         mat( 586) = mat( 586) - dti
         mat( 601) = mat( 601) - dti
         mat( 606) = mat( 606) - dti
         mat( 617) = mat( 617) - dti
         mat( 629) = mat( 629) - dti
         mat( 636) = mat( 636) - dti
         mat( 649) = mat( 649) - dti
         mat( 661) = mat( 661) - dti
         mat( 676) = mat( 676) - dti
         mat( 699) = mat( 699) - dti
         mat( 723) = mat( 723) - dti
         mat( 742) = mat( 742) - dti
         mat( 762) = mat( 762) - dti
         mat( 791) = mat( 791) - dti
         mat( 807) = mat( 807) - dti
         mat( 826) = mat( 826) - dti
         mat( 841) = mat( 841) - dti
         mat( 874) = mat( 874) - dti
         mat( 905) = mat( 905) - dti
         mat( 945) = mat( 945) - dti
         mat( 972) = mat( 972) - dti
         mat(1018) = mat(1018) - dti
         mat(1046) = mat(1046) - dti
         mat(1073) = mat(1073) - dti
         mat(1109) = mat(1109) - dti
         mat(1179) = mat(1179) - dti
         mat(1204) = mat(1204) - dti
         mat(1260) = mat(1260) - dti
         mat(1298) = mat(1298) - dti
         mat(1396) = mat(1396) - dti
         mat(1441) = mat(1441) - dti
         mat(1464) = mat(1464) - dti
         mat(1485) = mat(1485) - dti
         mat(1510) = mat(1510) - dti
      end subroutine nlnmat_finit
      subroutine nlnmat( mat, y, rxt, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)
      call nlnmat01( mat, y, rxt )
      call nlnmat02( mat, y, rxt )
      call nlnmat03( mat, y, rxt )
      call nlnmat04( mat, y, rxt )
      call nlnmat05( mat, y, rxt )
      call nlnmat06( mat, y, rxt )
      call nlnmat07( mat, y, rxt )
      call nlnmat_finit( mat, lmat, dti )
      end subroutine nlnmat
      end module mo_nln_matrix
