module dpie_coupling

!---------------------------------------------------------------------------------
! Dummy interface for waccmx/dpie_coupling module.
!---------------------------------------------------------------------------------

use shr_kind_mod,   only : r8 => shr_kind_r8            ! Real kind to declare variables
use physics_types,  only : physics_state, physics_ptend !Structures containing physics state and tendency variables
use physics_buffer, only : physics_buffer_desc
use cam_abortutils, only : endrun

implicit none
save
private

!------------------------
! PUBLIC: interfaces 
!------------------------
public d_pie_coupling     

!==============================================================================
contains
!==============================================================================

subroutine d_pie_coupling(omega,pe,z,u,v,pt,ionrates,ion_OpO2,ion_OpN2, &
  sigma_ped,sigma_hall,te,ti,h2ommr,o2mmr,o1mmr,h1mmr,n1mmr,o2pmmr,     &
  nopmmr,n2pmmr,opmmr,rmassO2,rmassO1,rmassH,rmassN,rmassN2,rmassO2p,   &
  rmassNOp,rmassN2p,rmassOp,i0,i1,j0,j1)

  use pmgrid,	  only: &
    plev,	        & ! number of midpoint levels
    plevp	          ! number of interface levels
  use mo_jeuv,    only: nIonRates        ! Number of ionization rates (11 rates)
  
  integer,intent(in) :: &
    i0, 		& ! grid%ifirstxy
    i1, 		& ! grid%ilastxy
    j0, 		& ! grid%jfirstxy
    j1  		  ! grid%jlastxy

  real(r8),intent(in) :: omega  (i0:i1,plev,j0:j1)    ! pressure velocity (Pa/s) (note i,k,j dims)
  real(r8),intent(in) :: pe	(i0:i1,plevp,j0:j1)   ! interface pressure (Pa)  (note i,k,j dims)
  real(r8),intent(in) :: z	(i0:i1,j0:j1,plev)    ! geopotential (on interfaces)
  real(r8),intent(in) :: u	(i0:i1,j0:j1,plev)    ! U-wind (m/s)
  real(r8),intent(in) :: v	(i0:i1,j0:j1,plev)    ! V-wind (m/s)
  real(r8),intent(in) :: pt	(i0:i1,j0:j1,plev)    ! potential temperature
  real(r8),intent(in) :: ionrates(i0:i1,j0:j1,plev,nIonRates) ! EUV ion rates from mo_photo
  real(r8),intent(in) :: ion_OpO2(i0:i1,j0:j1,plev)   ! Op+O2 rate (s-1/cm^3)
  real(r8),intent(in) :: ion_OpN2(i0:i1,j0:j1,plev)   ! Op+N2 rate (s-1/cm^3)
  real(r8),intent(in) :: sigma_ped (i0:i1,j0:j1,plev) ! Pedersen conductivity
  real(r8),intent(in) :: sigma_hall(i0:i1,j0:j1,plev) ! Hall conductivity
  real(r8),intent(in) :: te(i0:i1,j0:j1,plev)	      ! electron temperature
  real(r8),intent(in) :: ti(i0:i1,j0:j1,plev)	      ! ion temperature
  real(r8),intent(in) :: h2ommr(i0:i1,j0:j1,plev)     ! H2O mass mixing ratio (for oplus)
  real(r8),intent(in) :: o2mmr(i0:i1,j0:j1,plev)      ! O2 mass mixing ratio (for oplus)
  real(r8),intent(in) :: o1mmr(i0:i1,j0:j1,plev)      ! O mass mixing ratio (for oplus)
  real(r8),intent(in) :: h1mmr(i0:i1,j0:j1,plev)      ! H mass mixing ratio (for oplus)
  real(r8),intent(in) :: n1mmr(i0:i1,j0:j1,plev)      ! N mass mixing ratio (for oplus)
  real(r8),intent(in) :: o2pmmr(i0:i1,j0:j1,plev)     ! O2+ mass mixing ratio (for oplus)
  real(r8),intent(in) :: nopmmr(i0:i1,j0:j1,plev)     ! NO+ mass mixing ratio (for oplus)
  real(r8),intent(in) :: n2pmmr(i0:i1,j0:j1,plev)     ! N2+ mass mixing ratio (for oplus)
  real(r8),intent(inout) :: opmmr(i0:i1,j0:j1,plev)   ! O+ mass mixing ratio (oplus_xport output)
  real(r8),intent(in) :: rmassO2		      ! O2 molecular weight kg/kmol
  real(r8),intent(in) :: rmassO1		      ! O atomic weight kg/kmol
  real(r8),intent(in) :: rmassH 		      ! H atomic weight kg/kmol
  real(r8),intent(in) :: rmassN2		      ! N2 molecular weight kg/kmol
  real(r8),intent(in) :: rmassN 		      ! N molecular weight kg/kmol
  real(r8),intent(in) :: rmassO2p		      ! O2+ molecular weight kg/kmol
  real(r8),intent(in) :: rmassNOp		      ! NO+ molecular weight kg/kmol
  real(r8),intent(in) :: rmassN2p		      ! N2+ molecular weight kg/kmol
  real(r8),intent(in) :: rmassOp		      ! O+ molecular weight kg/kmol
  
  
  call endrun('d_pie_coupling: dummy interface should not be called')

end subroutine d_pie_coupling

end module dpie_coupling
