module edyn_init

!---------------------------------------------------------------------------------
! Dummy interface for waccmx/edyn_init module.
!---------------------------------------------------------------------------------

use cam_abortutils, only : endrun

implicit none
save
private

!------------------------
! PUBLIC: interfaces 
!------------------------
public edynamo_init,use_dynamo,use_dynamo_drifts 
    
logical :: use_dynamo=.false.            ! if true, call d_pie_coupling from dp_coupling
logical :: use_dynamo_drifts=.false.     ! if true, use ion drifts from edynamo in ionosphere.F90 and iondrag.F90

!==============================================================================
contains
!==============================================================================

  subroutine edynamo_init(dyn_state)

!------------------------------------------------------------------------------------------------------
! Dummy interface for one-time initialization, called from inital.F90 after dyn_init and initcom.
!-----------------------------------------------------------------------------
    use dynamics_vars ,only : t_fvdycore_state

!---------------------
! Args:
!---------------------
    type (t_fvdycore_state),target :: dyn_state
    
    call endrun('edynamo_init: dummy interface should not be called')

  end subroutine edynamo_init

end module edyn_init
