module edynamo

!---------------------------------------------------------------------------------
! Dummy interface for waccmx/edynamo module.
!---------------------------------------------------------------------------------

use shr_kind_mod,   only : r8 => shr_kind_r8            ! Real kind to declare variables
use cam_abortutils, only : endrun

implicit none
save
private

!------------------------
! PUBLIC: variables 
!------------------------
public ui,vi,wi 

!---------------------------------------------------------------
! 3d ion drift velocities on geographic grid (output):
!---------------------------------------------------------------
real(r8),allocatable,dimension(:,:,:),save,target :: & ! (nlev,lon0:lon1,lat0:lat1)
  ui,   & ! zonal ion drift
  vi,   & ! meridional ion drift
  wi      ! vertical ion drift

!==============================================================================
contains
!==============================================================================

  subroutine dynamo(tn,un,vn,wn,zpot,ped,hall, &
    lev0,lev1,lon0,lon1,lat0,lat1,do_integrals)

!---------------------
! Dummy interface for main driver for edynamo.
! Note alloc_edyn and esmf_init are called from edyn_init.
!---------------------
! Args:
!---------------------
    integer,intent(in) :: & ! geographic subdomain
      lev0,lev1,  & ! first,last level indices (not distributed)
      lon0,lon1,  & ! first,last longitude indices of geographic subdomain
      lat0,lat1     ! first,last latitude indices of geographic subdomain
    logical,intent(in) :: do_integrals

!---------------------------------------------------------------
! Inputs from neutral atmosphere (on geographic subdomain):
! (intent(inout) because they are passed to sub dynamo_input)
!---------------------------------------------------------------
    real(r8),intent(inout),dimension(lev0:lev1,lon0:lon1,lat0:lat1) :: &
      tn,         & ! neutral temperature (deg K)
      un,         & ! neutral zonal wind velocity (cm/s)
      vn,         & ! neutral meridional wind velocity (cm/s)
      wn,         & ! neutral vertical wind velocity (cm/s)
      zpot,       & ! geopotential height (cm)
      ped,        & ! pedersen conductivity (S/m)
      hall          ! hall conductivity (S/m)
   
    call endrun('dynamo: dummy interface should not be called')

  end subroutine dynamo

end module edynamo
