
module time3d_flds
  use shr_kind_mod, only: r8 => shr_kind_r8
  use cam_logfile,  only: iulog
  implicit none
  save
!
! Args to main time3dmodule:
!
  real(r8),allocatable,dimension(:,:,:),save ::                 &
    Z,Tn,cO,cO2,cN2,cH,cHe,cN,Wu,Ws,We,Wu_msis,Ws_msis,We_msis, &
    Qop,QHep,OpL,Qep,QHp,HepL,HpL,cO2p,cNOp,cN2p,Op,Te,Ti,Vi,   &
    Ped,Hall,Ped_t3d,Hall_t3d,Tn_t3d,Ped_waccm,Hall_waccm,Oppc, &
    Op_t3d,Op_waccm
  real(r8),allocatable,dimension(:,:,:),save ::                 &
    Tn_sim,cO2_sim,cO_sim,cN2_sim,cN_sim,cO2p_sim,cNOp_sim,cN2p_sim,&
    Qep_sim,Qop_sim,OpL_sim
!
! Formerly COMMON/input/ (time3d_gcmsim.f)
!
  integer :: iyd,iyr,imo,ida
  real(r8) :: f107,f107a,ap,uth,timestep,hindex(6)
!
  contains
!-----------------------------------------------------------------------
  subroutine time3d_alloc
    use time3d_geogrid,only: nlat,nlon,nlev
    use edyn_params,only: finit
!
! Inputs to time3d (waccm or gcmsim):
    allocate(Z(nlat,nlon,Nlev))
    allocate(Tn(nlat,nlon,Nlev))
    allocate(cO(nlat,nlon,Nlev))
    allocate(cO2(nlat,nlon,Nlev))
    allocate(cN2(nlat,nlon,Nlev))
    allocate(cH(nlat,nlon,Nlev))
    allocate(cHe(nlat,nlon,Nlev))
    allocate(cN(nlat,nlon,Nlev))
    allocate(Wu(nlat,nlon,Nlev))
    allocate(Ws(nlat,nlon,Nlev))
    allocate(We(nlat,nlon,Nlev))
    allocate(Qop(nlat,nlon,Nlev))
    allocate(QHep(nlat,nlon,Nlev))
    allocate(OpL(nlat,nlon,Nlev))
    allocate(Qep(nlat,nlon,Nlev))
    allocate(QHp(nlat,nlon,Nlev))
    allocate(HepL(nlat,nlon,Nlev))
    allocate(HpL(nlat,nlon,Nlev))
    allocate(cO2p(nlat,nlon,Nlev))
    allocate(cNOp(nlat,nlon,Nlev))
    allocate(cN2p(nlat,nlon,Nlev))
!
! time3d gcm simulator output (time3d_gcmsim)
    allocate(Tn_sim(nlat,nlon,Nlev))
    allocate(Wu_msis(nlat,nlon,Nlev))
    allocate(Ws_msis(nlat,nlon,Nlev))
    allocate(We_msis(nlat,nlon,Nlev))
    allocate(cO2_sim(nlat,nlon,Nlev))
    allocate(cO_sim(nlat,nlon,Nlev))
    allocate(cN2_sim(nlat,nlon,Nlev))
    allocate(cN_sim(nlat,nlon,Nlev))
!
! These ions are intent(inout) in sub time3d_gcmsim.F90:
    allocate(cO2p_sim(nlat,nlon,Nlev)) ; cO2p_sim=finit
    allocate(cNOp_sim(nlat,nlon,Nlev)) ; cNOp_sim=finit
    allocate(cN2p_sim(nlat,nlon,Nlev)) ; cN2p_sim=finit
!
! Production rates:
    allocate(Qop_sim(nlat,nlon,Nlev)) ; Qop_sim=finit ! O+ production rate
    allocate(Qep_sim(nlat,nlon,Nlev)) ; Qep_sim=finit ! Photo-Electron production rate
    allocate(OpL_sim(nlat,nlon,Nlev)) ; OpL_sim=finit ! O+ loss rate
!
! time3d output:
    allocate(Te(nlat,nlon,Nlev))
    allocate(Ti(nlat,nlon,Nlev))
    allocate(Vi(nlat,nlon,Nlev))
    allocate(Oppc(nlat,nlon,Nlev))

    allocate(Op(nlat,nlon,Nlev))
    allocate(Op_t3d(nlat,nlon,Nlev))
    allocate(Op_waccm(nlat,nlon,Nlev))

    allocate(Ped(nlat,nlon,Nlev))         ; Ped=finit
    allocate(Hall(nlat,nlon,Nlev))        ; Hall=finit
    allocate(Ped_t3d(nlat,nlon,Nlev))     ; Ped_t3d=finit
    allocate(Hall_t3d(nlat,nlon,Nlev))    ; Hall_t3d=finit
    allocate(Ped_waccm(nlat,nlon,Nlev))   ; Ped_waccm=finit
    allocate(Hall_waccm(nlat,nlon,Nlev))  ; Hall_waccm=finit
    allocate(Tn_t3d(nlat,nlon,Nlev))      ; Tn_t3d=finit

    write(iulog,"('Allocated time3d fields: nlat=',i4,' nlon=',i4,' nlev=',i4)") &
      nlat,nlon,nlev

  end subroutine time3d_alloc
!-----------------------------------------------------------------------
end module time3d_flds
