      module time3d_grid
!
! Module data arrays below are use-associated only by routines in time3d_main.f.
!
      use shr_kind_mod,only: r8 => shr_kind_r8
      use cam_logfile ,only: iulog
      use eig         ,only: Nhr,NLi,NFi,lmi,NHN,nk,ihe,re,Bki,kVC,CLNPd
      use edyn_maggrid,only: nmlat,nmlath,nmlon,nmlonp1
      implicit none
      save
!
! time3d mag grid (set by sub pregrid in time3d_gcmsim.f):
      real(r8) :: gmlat_t3d(nmlat),gmlon_t3d(nmlonp1)
!
! Formerly COMMON/TIME3Din/:
!
      real(r8),allocatable,dimension(:,:,:),save :: 
     |  Tn,cO,cO2,cN2,cH,cHe,cN,Ws,We,Wu,Qop,QHep,OpL,Qep,
     |  cO2p,cNOp,cN2p,QHp,HepL,HpL
!
! Formerly COMMON/InterpTI/:
!
      real(r8),allocatable,dimension(:,:,:),save   :: XMLAI,XMLOI,Cpole
      real(r8),allocatable,dimension(:,:,:,:),save :: xij,xijh,xix
      integer,allocatable,dimension(:,:,:,:),save  :: ij,ijh,ix
!
! Formerly COMMON/GRIDI/:
!
      real(r8) :: alti(NLi),Cli(NLi),SIi(NLi),MLATi(lmi+1,NLi),
     |  Mloni(NFi),altH(NHN),ClH(NHN),SIH(NHN),MlatH(NHN,2,NLi),
     |  MlonH(NHN)
!
! Formerly COMMON/IGrid/:
!
      real(r8),save :: d1i(lmi,NFi,NLi,3),d2i(lmi,NFi,NLi,3),
     |  glati(lmi,NFi,NLi),gloni(lmi,NFi,NLi),Vsi(lmi,NFi,NLi),
     |  Wsi(lmi,NFi,NLi),Bsi(lmi,NFi,NLi,4),gxi(lmi,NFi,NLi,3),
     |  dvv(lmi,NFi,NLi,2),mlov(NLi,NFi,2),
     |  d1ih(NHN,2,NLi,3),d2ih(NHN,2,NLi,3),glatih(NHN,2,NLi),
     |  glonih(NHN,2,NLi),Vsih(NHN,2,NLi),Wsih(NHN,2,NLi),
     |  Bsih(NHN,2,NLi,4),gxih(NHN,2,NLi,3),dvvh(NHN,2,NLi,2),
     |  mlovh(NHN,2,2),MH300(NHN+NLi)
      integer :: i300
!
! Formerly COMMON/GridD/:
!
      real(r8),save ::Be3i(lmi,NFi),d11i(lmi,NFi,NLi),d12i(lmi,NFi,NLi),
     |  d22i(lmi,NFi,NLi),Dhi(lmi,NFi,NLi),Be3h(NHN,2),d11h(NHN,2,NLi),
     |  d12h(NHN,2,NLi),d22h(NHN,2,NLi),Dhh(NHN,2,NLi),xije(NLi,NFi,4),
     |  xijeh(NHN,2,4),xie(nmlat,nmlon,4),siy(nmlat+1)
      integer :: ije(NLi,NFi,4),ijeh(NHN,2,4),ie(nmlat,nmlon,7),idmax
!
! Formerly COMMON/Iinterp/:
!
      real(r8) :: Sl(NLi+nk+1,2),dmlon(NLi+nk),Xli(NLi+nk+1),
     |  MLATT(NLi+nk+1,NLi)
      integer :: NHni(NHN,2),Nmlo(NLi+nk),NHX(NLi+1:NLi+nk,NFi)
!
! Formerly COMMON/EEmC/:
!
      real(r8),save :: EEm(NLi,NFi,2),EEH(NHN,2,2),dE(NLi,NFi,2)
!
! Formerly COMMON/EConductance/:
! lmi is lat, NFi is lon, NLi is levels
      real(r8),save :: EconT(lmi,NFi,NLi,2),EconTH(NHN,2,NLi,2)
      integer :: imax
!
! Formerly COMMON/constant/:
! Defined by TIME3DParaGrid
!
      real(r8) :: pi,DtR,dF
!
! Formerly COMMON/consti/:
!
      real(r8) :: Bolt,Simx(3),Sif(3)
!
! Formerly COMMON/PreThdf/:
      real(r8):: A(3),Ast(3,3),cpre(3,3),Cst(3,3),cospp(3,3),costpp(3,3)

      contains

!------------------------------------------------------------------------
      SUBROUTINE TIME3DParaGrid(iyr,iday,HB)

      use time3d_geogrid,only: nlat,nlon,ylatg,ylong
      use edyn_params ,only: h0,r0
      use time3d_apex ,only: apex_mka,apex_q2g,apex_mall,feldg
      use time_manager, only: get_nstep ! for debug
 
      implicit none
      save

      integer,intent(in)  :: iyr
      integer,intent(in)  :: iday
      real(r8),intent(out) :: HB       
      !
      !  Local variables
      !
      real(r8) :: Atomx
      real(r8) :: MaxG
      real(r8) :: dlat
      real(r8) :: dnlon
      real(r8) :: ClHt
      real(r8) :: SIHT
      real(r8) :: dm
      real(r8) :: dm1
      real(r8) :: dmlonx
      real(r8) :: dl
      real(r8) :: mlovx
      real(r8) :: RX2
      real(r8) :: RX1
      real(r8) :: Mlatg
      real(r8) :: Mlong
      real(r8) :: dlatg
      real(r8) :: dlong
      real(r8) :: xi
      real(r8) :: xj
      real(r8) :: yj
      real(r8) :: dlatp
      real(r8) :: yi
      real(r8) :: MIMX
      real(r8) :: xx
      real(r8) :: xmlat

      logical,save :: debug=.false.
      logical,save :: first=.true.
      
      integer :: nstep
      integer,parameter :: lm=61, ln=121

      real*8 Glatg(nlat),Glong(nlon),ymlat(nmlat)
      
      integer ier,lwk,i,j,k,ik
      
      real*8  epoch,glatx,glonx,galtx,HBr,Bsr,sir,alon,alat,Vr,Wr,Dr,be3
     &       ,sim,alatqd,fr,mlatx,mlaty,mlonx,GLAT0,GLON0,ALT0,BN,BE,BDx
     &       ,HBrs,Alt1,Alt2,BABS,BABSx,DATE

!      REAL*8 xa,ART,GLAT1,GLON1,HB,Vxtt,HAxx,RA,PAI,XPAI,Omg,MLAT1,MLON1
      REAL*8 xa,ART,GLAT1,GLON1,Vxtt,HAxx,RA,PAI,XPAI,Omg,MLAT1,MLON1
     &      ,xre,glg,dbx,yre,dfc,a,o

      real*8 :: gla(lm),glo(ln),altb(NLi),R(NLi),MlatiH(nk),MlatjH(NLi),
     |  BsjH(NHN,2,NLi,3),Bsj(lmi,NFi,NLi,3)

      real*8 :: Br(3),Bvr(3),D1r(3),D2r(3),D3r(3),E1r(3),E2r(3),E3r(3),
     |  F1r(2),F2r(2),Bxt(4),D1d(3),D2d(3),Dy(4),BB(3),Bd(3)

!      integer :: nkn,k1,iyr,iday,NINX,ix0,ix1
      integer :: nkn,k1,NINX,ix0,ix1

      nstep = get_nstep()
      if (debug) write(iulog,"('Enter time3dparagrid: nstep=',i4)") nstep

C     Based moudle
	 CALL PreThdff()
	 Bolt=1.3807D-23
	 Atomx=1.6726D-27
	 Simx(1)=16.0D0*Atomx
	 Simx(2)=4.0D0*Atomx
	 Simx(3)=1.0D0*Atomx
	 Sif(1:3)=-2.0D-2*Simx(1)/Simx(1:3)

! For 97 km lb (see also module eig.f)
!      R=[97.000D3,99.721D3,103.14D3,106.83D3,110.99D3

       R=[90.000D3,93.221D3,96.445D3,99.721D3,103.14D3,106.83D3,110.99D3
     &  ,116.05D3,122.92D3,132.54D3,145.00D3,160.14D3,177.57D3,196.96D3,
     &   218.06D3,240.78D3,265.04D3,290.78D3,317.91D3,346.26D3,375.66D3,
     &   405.93D3,436.92D3,468.51D3,500.60D3,533.21D3,566.34D3,600.00D3,
     &   635.88D3,676.50D3,725.16D3,786.67D3,868.47D3,982.67D3,1149.63D3
     &   ,1404.74D3,1811.38D3,2486.42D3,3593.89D3,5109.99D3,7225.02D3,
     &   10262.51D3,14807.11D3,22000.00D3]

      HB=R(1)*1.0D-3  !-1.D00
      MaxG=Dacosd(Dsqrt(dble((HB+RE)/(R(NLi)/1.0D3+RE))))
      PI=4.0D0*DATAN(1.0D0)
      DtR=PI/180.0D0
      Glatg=ylatg/dtr
      Glong=ylong(1:nlon)/dtr

      do k=1,NLi
        alti(k)=R(k)/1.0D3
        Xli(k)=Dacos(Dsqrt(dble((HB+RE)/(alti(k)+RE))))
	Cli(k)=Dcos(Xli(k))
        SIi(k)=2.0D0*Dsin(dble(Xli(k)))/Dsqrt(4.0D0-3.0D0*Cli(k)*
     |      Cli(k))
      enddo
!
! Temporary to avoid SIi(1)==0
      if (SIi(1)==0.) then
        SIi(1) = SIi(2)-(SIi(3)-SIi(2))
!       write(iulog,"('time3dparagrid: reset SIi(1)=',e12.4)") SIi(1)
      endif

	dF=2.0*PI/dble(NFi)
	DO j=1,NFi
        Mloni(j)=dble(j-1)*dF/DtR
	ENDDO
      dmlon(1:NLi)=360.0D0/dble(NFi)
	Nmlo(1:NLi)=NFi

! High-latitude
      dlat=2.5D0
	nkn=int((90.0D0-MaxG-0.6D0*dlat)/dlat)+1
	dnlon=dble(NFi)/dble(nkn)
	IF(nkn.ne.nk)write(*,*)'error in nk'
	k1=0
	DO k=1,nkn
	  j=NFi-int(NFi-k*dnlon)
	  IF(j.lt.3)j=3
	  DO i=1,j
	    k1=k1+1
	  enddo
	enddo
	IF(k1.ne.NHN)write(*,*)'error in NHN: ',k1,NHN

      k1=0
	DO k=1,nkn
	  j=NFi-int(NFi-k*dnlon)
	  IF(j.lt.3)j=3
	  dmlon(NLi+nk+1-k)=360.0D0/dble(j)
        MlatiH(k)=(90.0D0-0.6D0*dlat-DBLE(k-1)*dlat)*Dtr
	  Xli(NLi+nk+1-k)=MlatiH(k)
	  Nmlo(NLi+nk+1-k)=j
	  ClHt=Dcos(MlatiH(k))
 	  SIHT=2.D0*Dsin(MlatiH(k))/Dsqrt(4.D0-3.D0*ClHt*ClHt)
        MLATjH(1:NLi)=Dacos(Dsqrt((alti(1:NLi)+RE)/(HB+RE))*ClHt)/Dtr
        MLATT(NLi+nk+1-k,1:NLi)=MLATjH(1:NLi)
	  DO i=1,j
	    k1=k1+1
		ClH(k1)=ClHt
		SIH(k1)=SIHT
          MlatH(k1,1,1:NLi)=MLATjH(1:NLi)
		NHni(k1,1)=NLi+nk+1-k
	    MlatH(k1,2,1:NLi)=0.0D0-MLATjH(1:NLi)
		NHni(K1,2)=i
		MlonH(k1)=dmlon(NLi+nk+1-k)*DBLE(i-1)
		NHX(NHni(k1,1),i)=k1
	    altH(k1)=(HB+RE)/(ClH(k1)*ClH(k1))-RE
	  ENDDO
	ENDDO
      dmlon(1:NLi+nk)=dmlon(1:NLi+nk)*Dtr
	Xli(NLi+nk+1)=PI*0.5D0
	Sl(1:NLi-1,1)=2.5D0*Dtr
	Sl(NLi:NLi+nk+1,1)=1.25D0*Dtr
      Sl(1:NLi+nk,2)=dmlon(1:NLi+nk)*0.5D0
	Sl(NLi+nk+1,2)=Sl(NLi+nk,2)

      DO i=1,NLi
	  DO j=i,NLi
          MLATi(j,i)=Dacos(Dsqrt((alti(i)+RE)/(alti(j)+RE)))/DtR
          MLATi(lmi-j+1,i)=-MLATi(j,i)
	  ENDDO
	  MLATi(lmi+1,i)=0.0D0
	  if(alti(i).gt.3.0D2)MLATi(lmi+1,i)=Dacos(Dsqrt(dble((3.0D2+RE)
     &                                     /(alti(i)+RE))))/DtR
	ENDDO
      MLATT(1:NLi,1:NLi)=MLATi(1:NLi,1:NLi)
	MLATT(NLi+nk+1,1:NLi)=90.0D0

	 PAI=4.D0*DATAN(1.0D0)
	 XPAI=180.0D0/PAI
	 RA=(Re+HB)*1.0D3
	 Omg=7.292D-5
	 ART=CLNPd
	 i300=19
! For 97 km lb (see also EIG.h):
!        i300=17
	 IF(abs(alti(i300)-3.0D2).ge.20.0D0)write(*,*)'wrong in i300'
	 dm=180.0D0/DBLE(lm-1)
	 dm1=360.0D0/DBLE(ln-1)
	 IF(dabs(dm-dm1).ge.1.0D-3)write(*,*)'wrong in dm'
       altb(1:NLi)=real(alti(1:NLi))
	 DO i=1,lm
         gla(i)=real(i-1)*dm-90.0
	 ENDDO
	 DO i=1,ln
         glo(i)=real(i-1)*dm-180.0
	 ENDDO
	 IF(Bki.GT.0.0)THEN ! parameter Bki==1.0 in eig module
!          iulog=1
	   epoch=real(iyr)+real(iday)/366.0
	   HBr=real(HB)
	   lwk=lm*ln*NLi*5+lm+ln+NLi
c         call apxmka(iulog,epoch,gla,glo,altb,lm,ln,NLi,wk,lwk,ier)
         call apex_mka(epoch,gla,glo,altb,lm,ln,NLi,ier)
       ENDIF

      idmax=28
	imax=idmax
	Dhi(:,:,:)=0.0D0
C     Ionospheric moudle parameters
       dmlonx=360.0D0/dble(NFi)
       DO k=1,NLi
	   k1=k-1
	   Alt0=real(alti(k))
	   dl=(Re+alti(k))*1.0D3/XPAI*2.0D0
         DO j=1,NFi
           mlonx=real((j-1)*dmlonx)
		 MLON1=DBLE(mlonx)
           DO i=k,lmi-k+1
             mlatx=real(MLATi(i,k))
		   MLAT1=real(mlatx)
		   IF(Bki.GT.0.0)THEN
	         galtx=Alt0
			 HBrs=HBr
c	         call apxq2g(mlatx,mlonx,galtx,wk,glatx,glonx,ier)
	         call apex_q2g(mlatx,mlonx,galtx,glatx,glonx,ier)

               glati(i,j,k)=DBLE(glatx)
			 gloni(i,j,k)=DBLE(glonx)
                IF(gloni(i,j,k).LE.0.0D0)gloni(i,j,k)=gloni(i,j,k)+3.6D2
!
! Inputs: glatx,glonx,galtx,HBrs
! Output args: Br(3),Bvr(3),  Bsr,  sir, alon, alat,  Vr,  Wr, Dr, be3, sim, D1r(3),D2r(3),D3r(3),E1r(3),E2r(3),E3r(3),alatqd,fr,F1r(2),F2r(2)
! Actual args: b(3) ,bhat(3), bmag, si,  alon, xlatm, vmp, w,  d,  be3, sim, d1(3), d2(3), d3(3), e1(3), e2(3), e3(3), xlatqd,f, f1(2), f2(2)

	         call apex_mall(glatx,glonx,galtx,HBrs, Br,Bvr,Bsr,sir,
     &                      alon, alat,Vr,Wr,Dr,be3,sim,D1r,D2r,D3r,E1r,
     &                      E2r,E3r, alatqd,fr,F1r,F2r, ier)

               d1i(i,j,k,1)=DBLE(D1r(3))
			 d1i(i,j,k,2)=DBLE(-D1r(2))
               d1i(i,j,k,3)=DBLE(D1r(1))
			 d2i(i,j,k,1)=DBLE(D2r(3))
               d2i(i,j,k,2)=DBLE(-D2r(2))
			 d2i(i,j,k,3)=DBLE(D2r(1))
               Bsi(i,j,k,1)=-Br(2)*1.0D-9
			 Bsi(i,j,k,2)=Br(1)*1.0D-9
			 Bsi(i,j,k,3)=Br(3)*1.0D-9
			 Bsi(i,j,k,4)=Bsr*1.0D-9
               Vsi(i,j,k)=DBLE(Vr)
			 Wsi(i,j,k)=DBLE(Wr)*1.0D15
c			 Di(i,j,k)=DBLE(Dr)
               IF(k.eq.1)Be3i(i,j)=Bsi(i,j,1,4)/DBLE(Dr)
               IF(k.ge.2.and.k.le.idmax)THEN
                 Dhi(i,j,k)=Dabs(Vsi(i,j,k)-Vsi(i,j,k1))/(Bsi(i,j,k,4)
     &                      +Bsi(i,j,k1,4))
                 Dhi(i,j,k-1)=Dhi(i,j,k-1)+Dhi(i,j,k)
               ENDIF                                     
               d11i(i,j,k)=sum(d1i(i,j,k,1:3)*d1i(i,j,k,1:3))/DBLE(Dr)
               d12i(i,j,k)=sum(d1i(i,j,k,1:3)*d2i(i,j,k,1:3))/DBLE(Dr)
               d22i(i,j,k)=sum(d2i(i,j,k,1:3)*d2i(i,j,k,1:3))/DBLE(Dr)
               galtx=Alt0
               glatx=real(glati(i,j,k))+1.0
			 glonx=real(gloni(i,j,k))
	         IF(glatx.GT.90.0)Then
			   glonx=glonx+180.0
			   IF(glonx.GT.180.0)glonx=glonx-360.0
                 glatx=180.0-glatx
	         ENDIF
               call FELDG(1,glatx,glonx,galtx,BN,BE,BDx,BABS)
               glatx=real(glati(i,j,k))-1.0
			 glonx=real(gloni(i,j,k))
	         IF(glatx.LT.-90.0)Then
			   glonx=glonx+180.0
			   IF(glonx.GT.180.0)glonx=glonx-360.0
                 glatx=-180.0-glatx
	         ENDIF
               call FELDG(1,glatx,glonx,galtx,BN,BE,BDx,BABSx)
               Bsj(i,j,k,1)=DBLE(BABSx-BABS)*1.0D-4/dl
               glatx=real(glati(i,j,k))
			 glonx=real(gloni(i,j,k))+1.0
			 IF(glonx.GT.180.0)glonx=glonx-360.0
			 galtx=Alt0
		     IF(abs(glatx).GT.89.9)glatx=glatx/abs(glatx)*89.9
               call FELDG(1,glatx,glonx,galtx,BN,BE,BDx,BABS)
               glatx=real(glati(i,j,k))
			 glonx=real(gloni(i,j,k))-1.0
               IF(glonx.LT.-180.0)glonx=glonx+360.0
			 galtx=Alt0
		     IF(abs(glatx).GT.89.9)glatx=glatx/abs(glatx)*89.9
               call FELDG(1,glatx,glonx,galtx,BN,BE,BDx,BABSx)
		     Bsj(i,j,k,2)=DBLE(BABS-BABSx)*1.0D-4/dcos(glatx/XPAI)/dl
	         GLAT0=real(glati(i,j,k))
			 GLON0=real(gloni(i,j,k))
               galtx=Alt0+1.0
			 call FELDG(1,GLAT0,GLON0,galtx,BN,BE,BDx,BABS)
               galtx=Alt0-1.0
			 call FELDG(1,GLAT0,GLON0,galtx,BN,BE,BDx,BABSx)
		     Bsj(i,j,k,3)=DBLE(BABS-BABSx)*1.0D-4*0.5D-3
             ELSE
	         CALL M2G(ART,MLON1,MLAT1,GLON1,GLAT1)
               glati(i,j,k)=GLAT1
			 gloni(i,j,k)=GLON1
               call Dipx(ART,GLAT1,GLON1,alti(k),HB,a,o,Vxtt,HAxx,Bxt,
     &                   D1d,D2d,Bd)
               d1i(i,j,k,1:3)=D1d(1:3)
			 d2i(i,j,k,1:3)=D2d(1:3)
			 Vsi(i,j,k)=Vxtt
			 Bsj(i,j,k,1:3)=Bd(1:3)
			 Bsi(i,j,k,1:4)=Bxt(1:4)
	         Dy(1)=D1d(2)*D2d(3)-D1d(3)*D2d(2)
			 Dy(2)=D1d(1)*D2d(3)-D1d(3)*D2d(1)
	         Dy(3)=D1d(1)*D2d(2)-D1d(2)*D2d(1)
	         Dy(4)=dsqrt(Dy(1)*Dy(1)+Dy(2)*Dy(2)+Dy(3)*Dy(3))
c	         Di(i,j,k)=Dy(4)
               IF(k.eq.1)Be3i(i,j)=Bsi(i,j,1,4)/Dy(4)
               IF(k.ge.2.and.k.le.idmax)THEN
                 Dhi(i,j,k)=Dabs(Vsi(i,j,k)-Vsi(i,j,k1))/(Bsi(i,j,k,4)
     &                      +Bsi(i,j,k1,4))
                 Dhi(i,j,k-1)=Dhi(i,j,k-1)+Dhi(i,j,k)
               ENDIF  
               d11i(i,j,k)=sum(D1d(1:3)*D1d(1:3))/Dy(4)
               d12i(i,j,k)=sum(D1d(1:3)*D2d(1:3))/Dy(4)
               d22i(i,j,k)=sum(D2d(1:3)*D2d(1:3))/Dy(4)
               Wsi(i,j,k)=RA*RA*Cli(k)*SIi(k)/(Dy(4)*Bxt(4))
	       ENDIF
           ENDDO
	   ENDDO
       ENDDO

	 do k=1,NLi
         xre=Re/(Re+alti(k))
	   glg=9.8D0*xre*xre
	   xre=(Re+alti(k))*1.0D3
	   ik=NLi-k+1
         do j=1,NFi

           BB(1)=d1i(k,j,1,3)*d2i(k,j,1,1)-d1i(k,j,1,1)*d2i(k,j,1,3)
           BB(2)=d1i(k,j,1,1)*d2i(k,j,1,2)-d1i(k,j,1,2)*d2i(k,j,1,1)
           BB(3)=d1i(k,j,1,2)*d2i(k,j,1,3)-d1i(k,j,1,3)*d2i(k,j,1,2)

          mlovx=sum(BB(1:3)*Bsi(k,j,1,1:3))/(Bsi(k,j,1,4)*Bsi(k,j,1,4)*RA)
          mlov(k,j,1)=mlovx/SIi(k)
          mlov(k,j,2)=mlovx/Cli(k)

         enddo ! j=1,NFi

!         write(iulog,"('time3dparagrid loc 3a: k=',i4)") k

          IF(k.eq.2)mlov(1,1:NFi,1)=mlov(k,1:NFi,1)
	   do i=k,lmi-k+1
           do j=1,NFi
             BB(2)=Bsi(i,j,k,2)*Bsj(i,j,k,3)-Bsi(i,j,k,3)*Bsj(i,j,k,2)
             BB(3)=Bsi(i,j,k,3)*Bsj(i,j,k,1)-Bsi(i,j,k,1)*Bsj(i,j,k,3)
             BB(1)=Bsi(i,j,k,1)*Bsj(i,j,k,2)-Bsi(i,j,k,2)*Bsj(i,j,k,1)
	       dbx=-2.0D0/(Bsi(i,j,k,4)*Bsi(i,j,k,4)*Bsi(i,j,k,4))
	       dvv(i,j,k,1)=sum(BB(1:3)*d1i(i,j,k,1:3))*dbx
	       dvv(i,j,k,2)=sum(BB(1:3)*d2i(i,j,k,1:3))*dbx
             BB(1)=dcos(glati(i,j,k)/XPAI)
             BB(2)=dsin(glati(i,j,k)/XPAI)
		   yre=xre*Omg*Omg
	       gxi(i,j,k,3)=(yre*BB(1)*BB(1)*Bsi(i,j,k,3)+yre*BB(1)*BB(2)
     &                    *Bsi(i,j,k,1)-glg*Bsi(i,j,k,3))/Bsi(i,j,k,4)
	       gxi(i,j,k,1)=(BB(2)*d1i(i,j,k,1)-BB(1)*d1i(i,j,k,2))*2.0D0
     &                    *Omg/Bsi(i,j,k,4)
	       gxi(i,j,k,2)=(BB(2)*d2i(i,j,k,1)-BB(1)*d2i(i,j,k,2))*2.0D0
     &                    *Omg/Bsi(i,j,k,4)
	       gxi(i,j,k,1:3)=-gxi(i,j,k,1:3)
           enddo ! j=1,NFi
	   enddo ! i=k,lmi-k+1
	 enddo ! k=1,NLi
        k=i300
	  MH300(NHN+1:NHN+k)=0.0D0      
        MH300(NHN+k:NHN+NLi)=Dacos(Dsqrt((alti(k)+RE)/(alti(k:NLi)+RE)
     &                        ))/PAI*180.0D0

! high-latitude ionosphere
       DO k=1,NLi
!         write(iulog,"('time3dparagrid after loc4: k=',i4,' NLi=',i4)") 
!    |      k,NLi
	   k1=k-1
	   Alt0=real(alti(k))
	   dl=(Re+alti(k))*1.0D3/XPAI*2.0D0
         DO j=1,2
           DO i=1,NHN
            IF(k.eq.i300.and.j.eq.1)MH300(i)=Dacos(Dsqrt((alti(k)+RE)
     &                                      /(altH(i)+RE)))/PAI*180.0D0
             mlonx=real(MlonH(i))
		   MLON1=DBLE(mlonx)
             mlatx=real(Dacos(Dsqrt((alti(k)+RE)/(altH(i)+RE)))*XPAI)
		   IF(j.eq.2)mlatx=0.0-mlatx
		   MLAT1=real(mlatx)
		   IF(Bki.GT.0.0)THEN
	         galtx=Alt0
			 HBrs=HBr
c	         call apxq2g(mlatx,mlonx,galtx,wk,glatx,glonx,ier)
	         call apex_q2g(mlatx,mlonx,galtx,glatx,glonx,ier)	
               glatiH(i,j,k)=DBLE(glatx)
			 gloniH(i,j,k)=DBLE(glonx)
	        IF(gloniH(i,j,k).LE.0.D0)gloniH(i,j,k)=gloniH(i,j,k)+3.6D2
	         call apex_mall(glatx,glonx,galtx,HBrs, Br,Bvr,Bsr,sir,
     &                      alon, alat,Vr,Wr,Dr,be3,sim,D1r,D2r,D3r,E1r,
     &                      E2r,E3r,alatqd,fr,F1r,F2r, ier)
               d1iH(i,j,k,1)=DBLE(D1r(3))
			 d1iH(i,j,k,2)=DBLE(-D1r(2))
               d1iH(i,j,k,3)=DBLE(D1r(1))
			 d2iH(i,j,k,1)=DBLE(D2r(3))
               d2iH(i,j,k,2)=DBLE(-D2r(2))
			 d2iH(i,j,k,3)=DBLE(D2r(1))
               BsiH(i,j,k,1)=-Br(2)*1.0D-9
			 BsiH(i,j,k,2)=Br(1)*1.0D-9
			 BsiH(i,j,k,3)=Br(3)*1.0D-9
			 BsiH(i,j,k,4)=Bsr*1.0D-9
               VsiH(i,j,k)=DBLE(Vr)
			 WsiH(i,j,k)=DBLE(Wr)*1.0D15
c			 Dh(i,j,k)=DBLE(Dr)
               IF(k.eq.1)Be3h(i,j)=BsiH(i,j,1,4)/DBLE(Dr)
               IF(k.ge.2.and.k.le.idmax)THEN
                 Dhh(i,j,k)=Dabs(VsiH(i,j,k)-VsiH(i,j,k1))/(BsiH(i,j,k,4
     &                      )+BsiH(i,j,k1,4))    
                 Dhh(i,j,k-1)=Dhh(i,j,k-1)+Dhh(i,j,k)
               ENDIF
               d11h(i,j,k)=sum(d1ih(i,j,k,1:3)*d1ih(i,j,k,1:3))/DBLE(Dr)
               d12h(i,j,k)=sum(d1ih(i,j,k,1:3)*d2ih(i,j,k,1:3))/DBLE(Dr)
               d22h(i,j,k)=sum(d2ih(i,j,k,1:3)*d2ih(i,j,k,1:3))/DBLE(Dr)
               galtx=Alt0
               glatx=real(glatiH(i,j,k))+1.0
			 glonx=real(gloniH(i,j,k))
	         IF(glatx.GT.90.0)Then
			   glonx=glonx+180.0
			   glatx=180.0-glatx
			   IF(glonx.GT.180.0)glonx=glonx-360.0
	         ENDIF
               call FELDG(1,glatx,glonx,galtx,BN,BE,BDx,BABS)
               glatx=real(glatiH(i,j,k))-1.0
			 glonx=real(gloniH(i,j,k))
	         IF(glatx.LT.-90.0)Then
			   glonx=glonx+180.0
			   glatx=-180.0-glatx
			   IF(glonx.GT.180.0)glonx=glonx-360.0
	         ENDIF
               call FELDG(1,glatx,glonx,galtx,BN,BE,BDx,BABSx)
               BsjH(i,j,k,1)=DBLE(BABSx-BABS)*1.0D-4/dl
               glatx=real(glatiH(i,j,k))
			 glonx=real(gloniH(i,j,k))+1.0
			 IF(glonx.GT.180.0)glonx=glonx-360.0
			 galtx=Alt0
		     IF(abs(glatx).GT.89.9)glatx=glatx/abs(glatx)*89.9
               call FELDG(1,glatx,glonx,galtx,BN,BE,BDx,BABS)
               glatx=real(glatiH(i,j,k))
			 glonx=real(gloniH(i,j,k))-1.0
               IF(glonx.LT.-180.0)glonx=glonx+360.0
			 galtx=Alt0
		     IF(abs(glatx).GT.89.9)glatx=glatx/abs(glatx)*89.9
               call FELDG(1,glatx,glonx,galtx,BN,BE,BDx,BABSx)
		     BsjH(i,j,k,2)=DBLE(BABS-BABSx)*1.0D-4/dcos(glatx/XPAI)/dl
	         GLAT0=real(glatiH(i,j,k))
			 GLON0=real(gloniH(i,j,k))
               galtx=Alt0+1.0
			 call FELDG(1,GLAT0,GLON0,galtx,BN,BE,BDx,BABS)
               galtx=Alt0-1.0
			 call FELDG(1,GLAT0,GLON0,galtx,BN,BE,BDx,BABSx)
		     BsjH(i,j,k,3)=DBLE(BABS-BABSx)*1.0D-4*0.5D-3
             ELSE
	         CALL M2G(ART,MLON1,MLAT1,GLON1,GLAT1)
               glatiH(i,j,k)=GLAT1
			 gloniH(i,j,k)=GLON1
               call Dipx(ART,GLAT1,GLON1,alti(k),HB,a,o,Vxtt,HAxx,Bxt,
     &                   D1d,D2d,Bd)
               d1iH(i,j,k,1:3)=D1d(1:3)
			 d2iH(i,j,k,1:3)=D2d(1:3)
			 BsjH(i,j,k,1:3)=Bd(1:3)
			 BsiH(i,j,k,1:4)=Bxt(1:4)
			 VsiH(i,j,k)=Vxtt
	         Dy(1)=D1d(2)*D2d(3)-D1d(3)*D2d(2)
			 Dy(2)=D1d(1)*D2d(3)-D1d(3)*D2d(1)
	         Dy(3)=D1d(1)*D2d(2)-D1d(2)*D2d(1)
	         Dy(4)=dsqrt(Dy(1)*Dy(1)+Dy(2)*Dy(2)+Dy(3)*Dy(3))
c	         Dh(i,j,k)=Dy(4)
               IF(k.eq.1)Be3h(i,j)=Bsih(i,j,1,4)/Dy(4)
               IF(k.ge.2.and.k.le.idmax)THEN
                 Dhh(i,j,k)=Dabs(VsiH(i,j,k)-VsiH(i,j,k1))/(BsiH(i,j,k,4
     &                      )+BsiH(i,j,k1,4))    
                 Dhh(i,j,k-1)=Dhh(i,j,k-1)+Dhh(i,j,k)
               ENDIF
               d11h(i,j,k)=sum(D1d(1:3)*D1d(1:3))/Dy(4)
               d12h(i,j,k)=sum(D1d(1:3)*D2d(1:3))/Dy(4)
               d22h(i,j,k)=sum(D2d(1:3)*D2d(1:3))/Dy(4)
               WsiH(i,j,k)=RA*RA*ClH(k)*SIH(k)/(Dy(4)*Bxt(4))
	       ENDIF
           ENDDO
	   ENDDO
       ENDDO

	 DO i=1,NHN
         DO j=1,2
           BB(1)=d1iH(i,j,1,3)*d2iH(i,j,1,1)-d1iH(i,j,1,1)*d2iH(i,j,1,3)
           BB(2)=d1iH(i,j,1,1)*d2iH(i,j,1,2)-d1iH(i,j,1,2)*d2iH(i,j,1,1)
           BB(3)=d1iH(i,j,1,2)*d2iH(i,j,1,3)-d1iH(i,j,1,3)*d2iH(i,j,1,2)
	     mlovx=sum(BB(1:3)*BsiH(i,j,1,1:3))/(BsiH(i,j,1,4)*BsiH(i,j,1,
     &           4)*RA)
	     mlovH(i,j,1)=mlovx/SIH(i)
		 mlovH(i,j,2)=mlovx/ClH(i)
         ENDDO
       ENDDO
	 DO k=1,NLi
         xre=Re/(Re+alti(k))
	   glg=9.8D0*xre*xre
	   xre=(Re+alti(k))*1.0D3
	   ik=NLi-k+1
	   DO i=1,NHN
           DO j=1,2
           BB(2)=BsiH(i,j,k,2)*BsjH(i,j,k,3)-BsiH(i,j,k,3)*BsjH(i,j,k,2)
           BB(3)=BsiH(i,j,k,3)*BsjH(i,j,k,1)-BsiH(i,j,k,1)*BsjH(i,j,k,3)
           BB(1)=BsiH(i,j,k,1)*BsjH(i,j,k,2)-BsiH(i,j,k,2)*BsjH(i,j,k,1)
	     dbx=-2.0D0/(BsiH(i,j,k,4)*BsiH(i,j,k,4)*BsiH(i,j,k,4))
	       dvvH(i,j,k,1)=sum(BB(1:3)*d1iH(i,j,k,1:3))*dbx
	       dvvH(i,j,k,2)=sum(BB(1:3)*d2iH(i,j,k,1:3))*dbx
             BB(1)=dcos(glatiH(i,j,k)/XPAI)
             BB(2)=dsin(glatiH(i,j,k)/XPAI)
		   yre=xre*Omg*Omg
	       gxiH(i,j,k,3)=(yre*BB(1)*BB(1)*BsiH(i,j,k,3)+yre*BB(1)*BB(2
     &                  )*BsiH(i,j,k,1)-glg*BsiH(i,j,k,3))/BsiH(i,j,k,4)
	       gxiH(i,j,k,1)=(BB(2)*d1iH(i,j,k,1)-BB(1)*d1iH(i,j,k,2))*
     &                     2.0D0*Omg/BsiH(i,j,k,4)
	       gxiH(i,j,k,2)=(BB(2)*d2iH(i,j,k,1)-BB(1)*d2iH(i,j,k,2))*
     &                     2.0D0*Omg/BsiH(i,j,k,4)
	       gxiH(i,j,k,1:3)=-gxiH(i,j,k,1:3)
           enddo
	   enddo
	 enddo

      RX2=(RE+300.0D0)/(RE+HB)
	RX1=RX2*Dsqrt(dble(RX2))
	DO k=1,NLi
	  IF(k.GT.9)THEN
	    dfc=dsin(MLATi(lmi+1,k)*PAI/180.0D0)
	    BE=2.6D-5*dsqrt(1.0D0+3.0D0*dfc*dfc)
	    dfc=(300.0D0+6371.2D0)/(alti(9)+6371.2D0)
          BE=BE*dfc*dfc*dfc
          DO j=1,NFi
            dE(k,j,1)=BE/dsqrt(dble(sum(d1i(k,j,9,1:3)*d1i(k,j,9,1:3))))
            dE(k,j,2)=BE/dsqrt(dble(sum(d2i(k,j,9,1:3)*d2i(k,j,9,1:3))))
          ENDDO
	  ELSE
 	    dfc=(300.0D0+6371.2D0)/(alti(k)+6371.2D0)
          BE=2.6D-5*dfc*dfc*dfc
          DO j=1,NFi
            dE(k,j,1)=BE/dsqrt(dble(sum(d1i(k,j,k,1:3)*d1i(k,j,k,1:3))))
            dE(k,j,2)=BE/dsqrt(dble(sum(d2i(k,j,k,1:3)*d2i(k,j,k,1:3))))
          ENDDO
	  ENDIF
	ENDDO

       DO k=1,NLi
         DO i=1,nlat
	     GLAT1=Glatg(i)
           DO j=1,nlon
             GLON1=Glong(j)
		   IF(Bki.GT.0.0)THEN
	         glonx=real(GLON1)
			 glatx=real(GLAT1)
			 galtx=real(alti(k))
	         if(glonx.ge.180.0)glonx=glonx-360.0
			 HBrs=HBr
	         call apex_mall(glatx,glonx,galtx,HBrs, Br,Bvr,Bsr,sir, 
     &               alon,alat,Vr,Wr,Dr,be3,sim,D1r,D2r,D3r,E1r,E2r,E3r,
     &               alatqd,fr,F1r,F2r, ier)
               XMLAI(i,j,k)=DBLE(alatqd)
			 XMLOI(i,j,k)=DBLE(alon)
	         IF(alon.LT.0.0)XMLOI(i,j,k)=XMLOI(i,j,K)+360.0D0
             ELSE
               call Dipx(ART,GLAT1,GLON1,alti(k),HB,XMLAI(i,j,k),XMLOI(i
     &                   ,j,k),Vxtt,HAxx,Bxt,D1d,D2d,Bd)
	       ENDIF
	     ENDDO
         ENDDO
	 ENDDO

      Mlatg=Glatg(1)
      Mlong=Glong(1)
      dlatg=Glatg(2)-Glatg(1)
      dlong=Glong(2)-Glong(1)
	DO j=1,Nlon
	  i=1
	  IF(Mlatg.LT.0.0D0)i=2
	  k=2-i
	  Cpole(j,i,1)=Dcos(ylong(j)-ylong(1))
	  Cpole(j,i,2)=0.0D0-Dsin(ylong(j)-ylong(1))
	  Cpole(j,i,3)=0.0D0-Cpole(j,i,2)
	  Cpole(j,i,4)=Cpole(j,i,1)
	  Cpole(j,k,1)=Cpole(j,i,1)
	  Cpole(j,k,2)=0.0D0-Cpole(j,i,2)
	  Cpole(j,k,3)=0.0D0-Cpole(j,i,2)
	  Cpole(j,k,4)=Cpole(j,i,4)
	ENDDO
	DO j=1,NFi
	  DO k=1,NLi
	    DO i=k,lmi-k+1
            xi=(glati(i,j,k)-Mlatg)/dlatg+1.0D0
	      xj=(gloni(i,j,k)-Mlong)/dlong+1.0D0
            IF(xj.GE.nlon+1)xj=xj-dble(nlon)
	      ij(i,j,k,3)=INT(xj)
		  ij(i,j,k,4)=ij(i,j,k,3)+1
		  if(ij(i,j,k,3).EQ.nlon)ij(i,j,k,4)=1
		  yj=xj-DBLE(ij(i,j,k,3))
            IF(xi.LT.1.0D0)THEN
              ij(i,j,k,1)=1
              ij(i,j,k,2)=0
              dlatp=90.0D0-Dabs(Glatg(1))
              yi=dabs(glati(i,j,k)-Glatg(1))/dlatp
	        xij(i,j,k,1)=(1.0D0-yi)*(1.0D0-yj)
		    xij(i,j,k,2)=(1.0D0-yi)*yj
		    xij(i,j,k,3)=yi
            ELSE IF(xi.GT.dble(nlat))THEN
              ij(i,j,k,1)=nlat
              ij(i,j,k,2)=0
              dlatp=90.0D0-Dabs(Glatg(nlat))
              yi=dabs(glati(i,j,k)-Glatg(nlat))/dlatp
	        xij(i,j,k,1)=(1.0D0-yi)*(1.0D0-yj)
		    xij(i,j,k,2)=(1.0D0-yi)*yj
		    xij(i,j,k,3)=yi
            ELSE
		    ij(i,j,k,1)=INT(xi)
		    ij(i,j,k,2)=ij(i,j,k,1)+1
		    yi=xi-DBLE(ij(i,j,k,1))
	        xij(i,j,k,1)=(1.0D0-yi)*(1.0D0-yj)
		    xij(i,j,k,2)=(1.0D0-yi)*yj
		    xij(i,j,k,3)=yi*(1.0D0-yj)
		    xij(i,j,k,4)=yi*yj
	      ENDIF
		ENDDO
	  ENDDO
	ENDDO

	DO j=1,2
	  DO k=1,NLi
	    DO i=1,NHN
            xi=(glatih(i,j,k)-Mlatg)/dlatg+1.0D0
	      xj=(glonih(i,j,k)-Mlong)/dlong+1.0D0
            IF(xj.GE.nlon+1)xj=xj-dble(nlon)
	      ijh(i,j,k,3)=INT(xj)
		  ijh(i,j,k,4)=ijh(i,j,k,3)+1
		  if(ijh(i,j,k,3).EQ.nlon)ijh(i,j,k,4)=1
		  yj=xj-DBLE(ijh(i,j,k,3))
            IF(xi.LT.1.0D0)THEN
              ijh(i,j,k,1)=1
              ijh(i,j,k,2)=0
              dlatp=90.0D0-Dabs(Glatg(1))
              yi=dabs(glatih(i,j,k)-Glatg(1))/dlatp
	        xijh(i,j,k,1)=(1.0D0-yi)*(1.0D0-yj)
		    xijh(i,j,k,2)=(1.0D0-yi)*yj
		    xijh(i,j,k,3)=yi
            ELSE IF(xi.GT.dble(nlat))THEN
              ijh(i,j,k,1)=nlat
              ijh(i,j,k,2)=0
              dlatp=90.0D0-Dabs(Glatg(nlat))
              yi=dabs(glatih(i,j,k)-Glatg(nlat))/dlatp
	        xijh(i,j,k,1)=(1.0D0-yi)*(1.0D0-yj)
		    xijh(i,j,k,2)=(1.0D0-yi)*yj
		    xijh(i,j,k,3)=yi
            ELSE
		    ijh(i,j,k,1)=INT(xi)
		    ijh(i,j,k,2)=ijh(i,j,k,1)+1
		    yi=xi-DBLE(ijh(i,j,k,1))
	        xijh(i,j,k,1)=(1.0D0-yi)*(1.0D0-yj)
		    xijh(i,j,k,2)=(1.0D0-yi)*yj
		    xijh(i,j,k,3)=yi*(1.0D0-yj)
		    xijh(i,j,k,4)=yi*yj
	      ENDIF
		ENDDO
	  ENDDO
	ENDDO

	DO i=1,nlat
	  DO j=1,nlon
       	DO k=1,NLi
            MLATX=dabs(XMLAI(i,j,k))
		  MLONX=XMLOI(i,j,k)
	      if(MLONX.ge.360.0D0)MLONX=MLONX-360.0D0
	      if(MLONX.lt.0.0D0)MLONX=MLONX+360.0D0
            IF(MLATX.LE.MLATT(k,k))then
              NINX=k
			MIMX=0.0D0
			goto 1002
	      ENDIF
	      DO ik=k+1,NLi+nk+1
              IF(MLATX.LE.MLATT(ik,k))THEN
		     MIMX=(MLATX-MLATT(ik-1,k))/(MLATT(ik,k)-MLATT(ik-1,k))
	         NINX=ik-1
			 goto 1002
	        ENDIF
	      ENDDO
            IF(MLATX.GT.MLATT(NLi+nk+1,k))THEN
              NINX=NLi+nk
			MIMX=1.0D0
	      ENDIF
1002        IF(NINX.LE.NLi-1)THEN
			xj=MLONX*dble(Nmlo(NINX))/360.0D0+1.0D0
		    ix(i,j,k,1)=NINX
			ix(i,j,k,2)=NINX+1
			ix(i,j,k,7)=1
	        IF(XMLAI(i,j,k).LT.0.0D0)ix(i,j,k,1:2)=lmi+1-ix(i,j,k,1:2)
	        ix(i,j,k,3)=INT(xj)
			ix(i,j,k,4)=ix(i,j,k,3)+1
		    if(ix(i,j,k,3).EQ.Nmlo(NINX))ix(i,j,k,4)=1
		    yi=MIMX
			yj=xj-DBLE(ix(i,j,k,3))
	        xix(i,j,k,1)=(1.0D0-yi)*(1.0D0-yj)
			xix(i,j,k,2)=(1.0D0-yi)*yj
		    xix(i,j,k,3)=yi*(1.0D0-yj)
			xix(i,j,k,4)=yi*yj
            ELSE IF(NINX.EQ.NLi)THEN
			xj=MLONX*dble(Nmlo(NINX))/360.0D0+1.0D0
	        ix(i,j,k,1)=NLi
			IF(XMLAI(i,j,k).LT.0.0D0)ix(i,j,k,1)=NLi+1
			ix(i,j,k,2)=INT(xj)
			ix(i,j,k,3)=ix(i,j,k,2)+1
		    if(ix(i,j,k,2).EQ.Nmlo(NLi))ix(i,j,k,3)=1
              ix(i,j,k,4)=NHX(NLi+1,ix(i,j,k,2))
			ix(i,j,k,5)=NHX(NLi+1,ix(i,j,k,3))
              ix(i,j,k,6)=1
			IF(XMLAI(i,j,k).LT.0.0D0)ix(i,j,k,6)=2
			ix(i,j,k,7)=2
		    yi=MIMX
			yj=xj-DBLE(ix(i,j,k,2))
	        xix(i,j,k,1)=(1.0D0-yi)*(1.0D0-yj)
			xix(i,j,k,2)=(1.0D0-yi)*yj
		    xix(i,j,k,3)=yi*(1.0D0-yj)
			xix(i,j,k,4)=yi*yj
            ELSE IF((NINX.GT.NLi).and.(NINX.LT.NLi+nk))THEN
			xj=MLONX*dble(Nmlo(NINX))/360.0D0+1.0D0
              ix0=INT(xj)
			ix1=ix0+1
			if(ix0.EQ.Nmlo(NINX))ix1=1
              ix(i,j,k,1)=NHX(NINX,ix0)
			ix(i,j,k,2)=NHX(NINX,ix1)
              ix(i,j,k,6)=1
			IF(XMLAI(i,j,k).LT.0.0D0)ix(i,j,k,6)=2
			ix(i,j,k,7)=3
		    yi=1.0D0-MIMX
			yj=xj-DBLE(ix0)
		    xix(i,j,k,1)=yi*(1.0D0-yj)
			xix(i,j,k,2)=yi*yj
			xj=MLONX*dble(Nmlo(NINX+1))/360.0D0+1.0D0
              ix0=INT(xj)
			ix1=ix0+1
			if(ix0.EQ.Nmlo(NINX+1))ix1=1
              ix(i,j,k,3)=NHX(NINX+1,ix0)
			ix(i,j,k,4)=NHX(NINX+1,ix1)
		    yi=MIMX
			yj=xj-DBLE(ix0)
		    xix(i,j,k,3)=yi*(1.0D0-yj)
			xix(i,j,k,4)=yi*yj
            ELSE IF(NINX.EQ.NLi+nk)THEN
			xj=MLONX*dble(Nmlo(NINX))/360.0D0+1.0D0
              ix0=INT(xj)
			ix1=ix0+1
			if(ix0.EQ.Nmlo(NINX))ix1=1
              ix(i,j,k,1)=NHX(NINX,ix0)
			ix(i,j,k,2)=NHX(NINX,ix1)
              ix(i,j,k,6)=1
			IF(XMLAI(i,j,k).LT.0.0D0)ix(i,j,k,6)=2
		    yi=1.0D0-MIMX
			yj=xj-DBLE(ix0)
			xix(i,j,k,3)=MIMX
		    xix(i,j,k,1)=yi*(1.0D0-yj)
			xix(i,j,k,2)=yi*yj
			ix(i,j,k,7)=4
	      ENDIF	 
   	    ENDDO
	  ENDDO
	ENDDO

      dlong=gmlon_t3d(2)-gmlon_t3d(1)
      Mlong=gmlon_t3d(1)
      xx=dsqrt((r0-h0+HB*1.0D5)/r0)
      ymlat=dsign(dacosd(xx*dcosd(gmlat_t3d)),gmlat_t3d)
      dlatg=ymlat(2)-ymlat(1)
	xx=1.0D0/xx
      siy(nmlat+1)=xx*dsqrt(dble(xx))
	siy(1:nmlat)=siy(nmlat+1)*dsqrt((4.0D0-3.0D0*dcosd(ymlat(1:nmlat))
     &             *dcosd(ymlat(1:nmlat)))/(4.0D0-3.0D0*dcosd(gmlat_t3d(1:
     &             nmlat))*dcosd(gmlat_t3d(1:nmlat))))
c      Mlatg=ymlat(1)
	DO i=1,NLi
	  DO j=1,NFi
	    xmlat=Xli(i)/DtR
	    IF(xmlat*dlatg.LT.ymlat(1)*dlatg)xmlat=ymlat(1)
	    IF(xmlat*dlatg.GT.ymlat(nmlat)*dlatg)xmlat=ymlat(nmlat)
	    k=1
	    DO WHILE(k.LT.nmlat.and.(xmlat-ymlat(k))*(xmlat-ymlat(k+1))
     &             .GT.0.0D0)
             k=k+1
	    ENDDO
	    xi=(xmlat-ymlat(k))/(ymlat(k+1)-ymlat(k))+k
	    if(xi.LT.nmlath)xi=dble(nmlath)
c	    xi=(Xli(i)/DtR-Mlatg)/dlatg+1.0D0
	    xj=(Mloni(j)-Mlong)/dlong+1.0D0
          IF(xj.GE.nmlon+1)xj=xj-dble(nmlon)
		ije(i,j,1)=INT(xi)
		ije(i,j,2)=ije(i,j,1)+1
	    ije(i,j,3)=INT(xj)
		ije(i,j,4)=ije(i,j,3)+1
		if(ije(i,j,3).EQ.nmlon)ije(i,j,4)=1
		yi=xi-DBLE(ije(i,j,1))
		yj=xj-DBLE(ije(i,j,3))
	    xije(i,j,1)=(1.0D0-yi)*(1.0D0-yj)
		xije(i,j,2)=(1.0D0-yi)*yj
		xije(i,j,3)=yi*(1.0D0-yj)
		xije(i,j,4)=yi*yj
	  ENDDO
	ENDDO

	DO i=1,NHN
	  DO j=1,2
	    xmlat=Xli(NHni(i,1))/DtR
	    IF(j.eq.2)xmlat=0.0D0-xmlat
	    IF(xmlat*dlatg.LT.ymlat(1)*dlatg)xmlat=ymlat(1)
	    IF(xmlat*dlatg.GT.ymlat(nmlat)*dlatg)xmlat=ymlat(nmlat)
	    k=1
	    DO WHILE(k.LT.nmlat.and.(xmlat-ymlat(k))*(xmlat-ymlat(k+1))
     &             .GT.0.0D0)
             k=k+1
	    ENDDO
	    xi=(xmlat-ymlat(k))/(ymlat(k+1)-ymlat(k))+k
c          xi=(xmlat-Mlatg)/dlatg+1.0D0
          xj=(MlonH(i)-Mlong)/dlong+1.0D0
          IF(xj.GE.nmlon+1)xj=xj-dble(nmlon)
          ijeh(i,j,1)=INT(xi)
	    ijeh(i,j,2)=ijeh(i,j,1)+1
	    ijeh(i,j,3)=INT(xj)
	    ijeh(i,j,4)=ijeh(i,j,3)+1
	    if(ijeh(i,j,3).EQ.nmlon)ijeh(i,j,4)=1
	    yi=xi-DBLE(ijeh(i,j,1))
		yj=xj-DBLE(ijeh(i,j,3))
	    xijeh(i,j,1)=(1.0D0-yi)*(1.0D0-yj)
		xijeh(i,j,2)=(1.0D0-yi)*yj
		xijeh(i,j,3)=yi*(1.0D0-yj)
		xijeh(i,j,4)=yi*yj
	  ENDDO
	ENDDO

	DO i=1,nmlat
	  DO j=1,nmlon
          MLATX=dabs(ymlat(i))
	    MLONX=gmlon_t3d(j)
	    if(MLONX.ge.360.0D0)MLONX=MLONX-360.0D0
	    if(MLONX.lt.0.0D0)MLONX=MLONX+360.0D0
          IF(MLATX.LE.MLATT(1,1))then
            NINX=1
	      MIMX=0.0D0
		  goto 1003
	    ENDIF
	    DO ik=2,NLi+nk+1
            IF(MLATX.LE.MLATT(ik,1))THEN
	        MIMX=(MLATX-MLATT(ik-1,1))/(MLATT(ik,1)-MLATT(ik-1,1))
	        NINX=ik-1
		    goto 1003
	      ENDIF
	    ENDDO
          IF(MLATX.GT.MLATT(NLi+nk+1,1))THEN
            NINX=NLi+nk
	      MIMX=1.0D0
	    ENDIF
1003      IF(NINX.LE.NLi-1)THEN
		  xj=MLONX*dble(Nmlo(NINX))/360.0D0+1.0D0
		  ie(i,j,1)=NINX
		  ie(i,j,2)=NINX+1
		  ie(i,j,7)=1
	      IF(ymlat(i).LT.0.0D0)ie(i,j,1:2)=lmi+1-ie(i,j,1:2)
	      ie(i,j,3)=INT(xj)
		  ie(i,j,4)=ie(i,j,3)+1
		  if(ie(i,j,3).EQ.Nmlo(NINX))ie(i,j,4)=1
		  yi=MIMX
		  yj=xj-DBLE(ie(i,j,3))
	      xie(i,j,1)=(1.0D0-yi)*(1.0D0-yj)
		  xie(i,j,2)=(1.0D0-yi)*yj
		  xie(i,j,3)=yi*(1.0D0-yj)
		  xie(i,j,4)=yi*yj
          ELSE IF(NINX.EQ.NLi)THEN
		  xj=MLONX*dble(Nmlo(NINX))/360.0D0+1.0D0
	      ie(i,j,1)=NLi
		  IF(ymlat(i).LT.0.0D0)ie(i,j,1)=NLi+1
		  ie(i,j,2)=INT(xj)
		  ie(i,j,3)=ie(i,j,2)+1
		  if(ie(i,j,2).EQ.Nmlo(NLi))ie(i,j,3)=1
            ie(i,j,4)=NHX(NLi+1,ie(i,j,2))
		  ie(i,j,5)=NHX(NLi+1,ie(i,j,3))
            ie(i,j,6)=1
		  IF(ymlat(i).LT.0.0D0)ie(i,j,6)=2
		  ie(i,j,7)=2
		  yi=MIMX
		  yj=xj-DBLE(ie(i,j,2))
	      xie(i,j,1)=(1.0D0-yi)*(1.0D0-yj)
		  xie(i,j,2)=(1.0D0-yi)*yj
		  xie(i,j,3)=yi*(1.0D0-yj)
		  xie(i,j,4)=yi*yj
          ELSE IF((NINX.GT.NLi).and.(NINX.LT.NLi+nk))THEN
		  xj=MLONX*dble(Nmlo(NINX))/360.0D0+1.0D0
            ix0=INT(xj)
		  ix1=ix0+1
		  if(ix0.EQ.Nmlo(NINX))ix1=1
            ie(i,j,1)=NHX(NINX,ix0)
		  ie(i,j,2)=NHX(NINX,ix1)
            ie(i,j,6)=1
		  IF(ymlat(i).LT.0.0D0)ie(i,j,6)=2
		  ie(i,j,7)=3
		  yi=1.0D0-MIMX
		  yj=xj-DBLE(ix0)
		  xie(i,j,1)=yi*(1.0D0-yj)
		  xie(i,j,2)=yi*yj
		  xj=MLONX*dble(Nmlo(NINX+1))/360.0D0+1.0D0
            ix0=INT(xj)
		  ix1=ix0+1
		  if(ix0.EQ.Nmlo(NINX+1))ix1=1
            ie(i,j,3)=NHX(NINX+1,ix0)
		  ie(i,j,4)=NHX(NINX+1,ix1)
		  yi=MIMX
		  yj=xj-DBLE(ix0)
		  xie(i,j,3)=yi*(1.0D0-yj)
		  xie(i,j,4)=yi*yj
          ELSE IF(NINX.EQ.NLi+nk)THEN
		  xj=MLONX*dble(Nmlo(NINX))/360.0D0+1.0D0
            ix0=INT(xj)
		  ix1=ix0+1
		  if(ix0.EQ.Nmlo(NINX))ix1=1
            ie(i,j,1)=NHX(NINX,ix0)
		  ie(i,j,2)=NHX(NINX,ix1)
            ie(i,j,6)=1
		  IF(ymlat(i).LT.0.0D0)ie(i,j,6)=2
		  yi=1.0D0-MIMX
		  yj=xj-DBLE(ix0)
		  xie(i,j,3)=MIMX
		  xie(i,j,1)=yi*(1.0D0-yj)
		  xie(i,j,2)=yi*yj
		  ie(i,j,7)=4
	    ENDIF	 
	  ENDDO
	ENDDO

      first = .false.

      END SUBROUTINE TIME3DParaGrid

cc%%%%%%%%%%%%%%%%%%%%%%%%%%%%%    DIP   %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
      SUBROUTINE Dipx(ART,glat,glon,alt,HB,mlatx,mlon,V,HA,B,D1,D2,Bd)

        IMPLICIT NONE

	real(r8),intent(in)  :: ART
	real(r8),intent(in)  :: glat
	real(r8),intent(in)  :: glon
	real(r8),intent(in)  :: alt
	real(r8),intent(in)  :: HB
	real(r8),intent(out) :: mlatx
	real(r8),intent(out) :: mlon
	real(r8),intent(out) :: V
 	real(r8),intent(out) :: HA
 	real(r8),intent(out) :: B(4)
 	real(r8),intent(out) :: D1(3)
 	real(r8),intent(out) :: D2(3)
 	real(r8),intent(out) :: Bd(3)
       
	!
        !  Local variables
        !
	real(r8) :: FAK
	real(r8) :: VM
	real(r8) :: MLATy
	real(r8) :: Mcos
	real(r8) :: Msin
	real(r8) :: XX
	real(r8) :: CSI
	real(r8) :: SSI
	real(r8) :: CL
	real(r8) :: CI
	real(r8) :: D2x
	real(r8) :: D2h
	real(r8) :: D1h

!      IMPLICIT REAL*8 (A-H,M,O-Z)
!	REAL*8 B(4),HB,D1(3),D2(3),Bd(3)

!         RE=6371.2D0 ! this is now module data
	  FAK=0.0174532925
	  VM=7.71943D15
	  CALL G2M(ART,glon,glat,MLON,MLATx)
        MLATy=MLATx
	  if(dabs(MLATx).eq.9.0D1)MLATy=MLATx/9.0D1*89.99999D0
	  Mcos=Dcos(MLATy*FAK)
	  Msin=Dsin(MLATy*FAK)
	  HA=(alt+RE)/Mcos**2-RE
        V=0.0D0-VM*Msin/((alt+RE)*(alt+RE))*1.0D-6
	  XX=Dsqrt(1.0D0+3.0D0*Msin**2)
        B(4)=DABS(VM*XX/((alt+RE)*(alt+RE)*(alt+RE)))*1.0D-9
        CSI=(dcos(ART*FAK)-Msin*dsin(glat*FAK))/(Mcos*dcos(glat*FAK))
        SSI=0.0D0-dsin(ART*FAK)*dsin((glon+69.0D0)*FAK)/Mcos
        B(1)=(0.0D0-B(4)*Mcos)*CSI
	  B(2)=(0.0D0-B(4)*Mcos)*SSI
        B(3)=0.0D0-B(4)*Msin
	  CL=Dsqrt(dble((HB+RE)/(HA+RE)))
	  CI=Cl/Dsqrt(4.0D0-3.0D0*CL*CL)
	  D2x=-1.0D0*CL*CL*CI
	  D2h=D2x*2.0D0*(HA+RE)/(alt+RE)*Msin/Mcos
	  D2(1)=D2x/Mcos/Mcos
	  D2(2)=-1.0D0*D2h*CSI
        D2(3)=D2h*SSI
	  D1h=((HB+RE)/(alt+RE))**1.5D0
	  D1(1)=0.0D0
	  D1(2)=D1h*SSI
	  D1(3)=D1h*CSI
	  Bd(3)=-3.0D-3*B(4)/(alt+RE)
	  Bd(1)=Bd(3)*Mcos*Msin/XX/XX*CSI
	  Bd(2)=0.0D0-Bd(3)*Mcos*Msin/XX/XX*SSI
      END SUBROUTINE Dipx

CC----------------------------------------------------------------------------------
      SUBROUTINE G2M(ART,LONG,LATI,MLONG,MLAT)

        IMPLICIT NONE

	real(r8),intent(in)  :: ART
	real(r8),intent(in)  :: LONG
	real(r8),intent(in)  :: LATI
	real(r8),intent(out) :: MLONG
	real(r8),intent(out) :: MLAT
        
	!
        !  Local variables
        !
	real(r8) :: FAKTOR
	real(r8) :: ZPI
	real(r8) :: CBG
	real(r8) :: CI
	real(r8) :: SI
	real(r8) :: YLG
	real(r8) :: SBG
	real(r8) :: CLG
	real(r8) :: SLG
	real(r8) :: SBM
	real(r8) :: CBM
	real(r8) :: SLM
	real(r8) :: CLM
	
C INPUT: GLONG,GLAT (0/360,-90/90);  OUTPUT: MLONG,MLAT(0/360,-90/90)
!      IMPLICIT REAL*8 (A-Z)
!      REAL*8 ARTMLONG,MLAT,LONG,LATI
 
        FAKTOR=0.0174532925D0
	  ZPI=FAKTOR*360.0D0
        CBG=ART*FAKTOR
	  CI=COS(CBG)
	  SI=SIN(CBG)
        YLG=LONG+69.8
	  CBG=COS(LATI*FAKTOR)
        SBG=SIN(LATI*FAKTOR)
	  CLG=COS(YLG*FAKTOR)
        SLG=SIN(YLG*FAKTOR)
	  SBM=SBG*CI+CBG*CLG*SI
        IF(ABS(SBM).GT.1.0)SBM=SIGN(1.,SBM)
        MLAT=ASIN(SBM)
	  CBM=COS(MLAT)
        SLM=(CBG*SLG)/CBM
	  CLM=(-SBG*SI+CBG*CLG*CI)/CBM
        IF(ABS(CLM).GT.1.0)CLM=SIGN(1.,CLM)
        MLONG=ACOS(CLM)
	  IF(SLM.LT.0)MLONG=ZPI-MLONG
        MLAT=MLAT/FAKTOR
	  MLONG=MLONG/FAKTOR

      END SUBROUTINE G2M

CC----------------------------------------------------------------------------------
      SUBROUTINE M2G(ART,LONG,LATI,GLONG,GLAT)

C INPUT: MLONG,MLAT (0/360,-90/90);  OUTPUT: GLONG,GLAT(0/360,-90/90)

        IMPLICIT NONE

	real(r8),intent(in)  :: ART
	real(r8),intent(in)  :: LONG
	real(r8),intent(in)  :: LATI
	real(r8),intent(out) :: GLONG
	real(r8),intent(out) :: GLAT
        
	!
        !  Local variables
        !
	real(r8) :: FAKTOR
	real(r8) :: ZPI
	real(r8) :: CBG
	real(r8) :: CI
	real(r8) :: SI
	real(r8) :: YLG
	real(r8) :: SBG
	real(r8) :: CLG
	real(r8) :: SLG
	real(r8) :: SBM
	real(r8) :: CBM
	real(r8) :: SLM
	real(r8) :: CLM
	

!      IMPLICIT REAL*8 (A-Z)

!      REAL*8 ARTMLONG,MLAT,LONG,LATI

        FAKTOR=0.0174532925D0
	  ZPI=FAKTOR*360.0D0
        CBG=ART*FAKTOR
	  CI=COS(CBG)
	  SI=SIN(CBG)
        YLG=LONG+180.0
	  CBG=COS(LATI*FAKTOR)
        SBG=SIN(LATI*FAKTOR)
	  CLG=COS(YLG*FAKTOR)
        SLG=SIN(YLG*FAKTOR)
	  SBM=SBG*CI+CBG*CLG*SI
        IF(ABS(SBM).GT.1.0)SBM=SIGN(1.,SBM)
        GLAT=ASIN(SBM)
	  CBM=COS(GLAT)
        SLM=(CBG*SLG)/CBM
	  CLM=(-SBG*SI+CBG*CLG*CI)/CBM
        IF(ABS(CLM).GT.1.0)CLM=SIGN(1.,CLM)
        GLONG=ACOS(CLM)
	  IF(SLM.LT.0)GLONG=ZPI-GLONG
        GLAT=GLAT/FAKTOR
	  GLONG=GLONG/FAKTOR+110.2D0
	  IF(GLONG.GE.360.0D0)GLONG=GLONG-360.0D0

      END SUBROUTINE M2G

c--------------------------------------------------------------------------------------
      SUBROUTINE MagPOL (iyr,iiday,dCLATP,dPOLON)
    
        use time3d_apex,only: cofrm,dypol

        IMPLICIT NONE

	real(r8),intent(out) :: dCLATP,dPOLON
        integer,intent(in) :: iyr,iiday
        !
        !  Local variables
        !
	real*8 :: DATE,VPOL


	DATE=iyr+iiday/366.0D0
	
	CALL COFRM(DATE)
        
	CALL DYPOL(dCLATP,dPOLON,VPOL)

!       dPOLON=dble(POLON)
!       dCLATP=dble(CLATP)

	END SUBROUTINE MagPOL

CC-------------------------------------------------------------------------------------
      SUBROUTINE Dsubsol (iyr,iiday,Ut,dCLATP,dPOLON,DSBSLLAT,dSMLON)
      
       use time3d_apex,only: solgmlon,subsol

       IMPLICIT NONE

C Computes geomagnetic longitude of the point with geocentric spherical
C  latitude and longitude of XLAT and XLON, respectively.

        integer,intent(in) :: iyr,iiday
	real(r8), intent(in) :: Ut,dCLATP,dPOLON
        real(r8), intent(out) :: DSBSLLAT,dSMLON
        !
        ! Local variables
        !
	real(r8) :: DSBSLLON,sec
        integer :: ihr,mnt

        ihr=int(ut)
	  mnt=int((ut-ihr)*60.0D0)
	  sec=((ut-ihr)*60-mnt)*60
!         CLATP=real(dCLATP)
!         POLON=real(dPOLON)
        call subsol (iyr,iiday,ihr,mnt,sec,DSBSLLAT,DSBSLLON)
!         DSBSLLAT=dble(SBSLLAT)
	  CALL SOLGMLON (DSBSLLAT,DSBSLLON,dCLATP,dPOLON,dSMLON)
!       dSMLON=dble(SMLON)

      RETURN

	END SUBROUTINE Dsubsol

!-------------------------------------------------------------------------------------
      subroutine time3d_alloc_neutrals
!
! Allocate neutrals internal to time3d.
! These fields are module data in this file (time3d_grid.f)
!
      use time3d_geogrid,only: Nlat,Nlon ! 37,48
      use eig,only: NLi ! 44
      implicit none
      real(r8),parameter :: finit=0.
      integer,parameter :: init=0
!
! Formerly COMMON/InterpTI/:
!
      allocate(XMLAI(Nlat,Nlon,NLi)) ; xmlai=finit
      allocate(XMLOI(Nlat,Nlon,NLi)) ; xmloi=finit
      allocate(xij(lmi,NFi,NLi,4))   ; xij=finit
      allocate(xijh(NHN,2,NLi,4))    ; xijh=finit
      allocate(xix(Nlat,Nlon,NLi,4)) ; xix=finit
      allocate(ij(lmi,NFi,NLi,4))    ; ij=init
      allocate(ijh(NHN,2,NLi,4))     ; ijh=init
      allocate(ix(Nlat,Nlon,NLi,7))  ; ix=init
      allocate(Cpole(Nlon,2,4))      ; cpole=finit
!
! Formerly COMMON/TIME3Din/:
!
      allocate(Tn(Nlat,Nlon,NLi))   ; Tn=finit
      allocate(cO(Nlat,Nlon,NLi))   ; cO=finit
      allocate(cO2(Nlat,Nlon,NLi))  ; cO2=finit
      allocate(cN2(Nlat,Nlon,NLi))  ; cN2=finit
      allocate(cH(Nlat,Nlon,NLi))   ; cH=finit
      allocate(cHe(Nlat,Nlon,NLi))  ; cHe=finit
      allocate(cN(Nlat,Nlon,NLi))   ; cN=finit
      allocate(Ws(Nlat,Nlon,NLi))   ; Ws=finit
      allocate(We(Nlat,Nlon,NLi))   ; We=finit
      allocate(Wu(Nlat,Nlon,NLi))   ; Wu=finit
      allocate(Qop(Nlat,Nlon,NLi))  ; Qop=finit
      allocate(QHep(Nlat,Nlon,NLi)) ; QHep=finit
      allocate(OpL(Nlat,Nlon,NLi))  ; OpL=finit
      allocate(Qep(Nlat,Nlon,NLi))  ; Qep=finit
      allocate(cO2p(Nlat,Nlon,NLi)) ; cO2p=finit
      allocate(cNOp(Nlat,Nlon,NLi)) ; cNOp=finit
      allocate(cN2p(Nlat,Nlon,NLi)) ; cN2p=finit
      allocate(QHp(Nlat,Nlon,NLi))  ; QHp=finit
      allocate(HepL(Nlat,Nlon,NLi)) ; HepL=finit
      allocate(HpL(Nlat,Nlon,NLi))  ; HpL=finit

      write(iulog,"('Allocated time3d neutrals (Nlat=',i3,',Nlon=',i3,
     |  ' ,NLi=',i3,')')") Nlat,Nlon,NLi

      end subroutine time3d_alloc_neutrals

C---------------------------------------------------------
      SUBROUTINE PreThdff() ! PreCollisions between ions coefficients

       IMPLICIT NONE

       real(r8) :: Bst3                 ! mass of electron (g/mole)
       real(r8) :: Dst1                 ! mass of electron (g/mole)
       real(r8) :: Dst4                 ! mass of electron (g/mole)

!       IMPLICIT REAL*8 (A-H,O-Z)
!
! A,Ast,cpre,Cst,cospp,costpp are in module data above, are defined
! here, and use-associated to sub Thdff (timegcm_main.f).
!
       INTEGER s,t

       A = (/16.0D0,4.0D0,1.0D0/)
       DO s=1,3
         DO t=1,3
             Ast(s,t)=A(s)*A(t)/(A(s)+A(t))
             cpre(s,t)=1.27D-6*dsqrt(Ast(s,t))/A(s)
         ENDDO
       ENDDO
       DO s=1,3  ! Correction
         DO t=1,3
           Bst3=Ast(s,t)/A(s)*Ast(s,t)/A(s)
           Dst1=3.0D0*(Ast(s,t)/A(t))*(Ast(s,t)/A(t))-0.2D0*Bst3+
     &          Ast(s,t)/(A(s)+A(t))*0.1D0
           Dst4=3.0D0*(Ast(s,t)/A(s))*(Ast(s,t)/A(s))-0.2D0*Bst3-
     &          Ast(s,t)/(A(s)+A(t))*(1.6D0*A(t)/A(s)+1.5D0)
           Cst(s,t)=2.5D0-Ast(s,t)/A(t)*(2.5D0+A(t)/A(s))
           cospp(s,t)=1.25D0*(Dst1+1.5D0*Ast(s,t)/A(s))
           costpp(s,t)=1.25D0*(Dst4+1.5D0*Ast(s,t)/A(s))
          ENDDO
       ENDDO
      RETURN
      END SUBROUTINE PreThdff

!-------------------------------------------------------------------------------------

      end module time3d_grid
