;-----------------------------------------------------------------------
pro plot_map,file,name,long_name,units,klev,itime,data

  title = long_name + ' ' + units + ' klev=' + string(klev) + ' itime=' + $
    string(itime) + ' min,max=' + string(format="(e10.3)",min(data)) + ',' + string(format="(e10.3)",max(data))
  contour,data,title=title,/follow,xstyle=1,ystyle=1,c_charsize=1.0,$
    charsize=.7,nlevels=20
  xyouts,0.5,0.01,'file='+file,alignment=0.5,/normal
end
;-----------------------------------------------------------------------
function make_ijk,fin,dimnames,idims
  if (dimnames[0] eq 'nlon' and dimnames[1] eq 'nlat' and dimnames[2] eq 'nlev') then begin ; i,j,k
    return,fin
  endif else if(dimnames[0] eq 'nlon' and dimnames[1] eq 'nlev' and dimnames[2] eq 'nlat') then begin ; i,k,j
    fout = fltarr(idims[0],idims[2],idims[1]) ; i,j,k
    for k=0,idims[1]-1 do begin
      for j=0,idims[2]-1 do begin
        fout[*,j,k] = fin[*,k,j]
      endfor
    endfor
    return,fout
  endif else if(dimnames[0] eq 'nlat' and dimnames[1] eq 'nlon' and dimnames[2] eq 'nlev') then begin ; j,i,k
    fout = fltarr(idims[1],idims[0],idims[2]) ; i,j,k
    for k=0,idims[2]-1 do begin
      for j=0,idims[0]-1 do begin
        fout[*,j,k] = fin[j,*,k]
      endfor
    endfor
  endif else if(dimnames[0] eq 'nlat' and dimnames[1] eq 'nlev' and dimnames[2] eq 'nlon') then begin ; j,k,i
    fout = fltarr(idims[2],idims[0],idims[1]) ; i,j,k
    for k=0,idims[1]-1 do begin
      for j=0,idims[0]-1 do begin
        fout[*,j,k] = fin[j,k,*]
      endfor
    endfor
  endif else if(dimnames[0] eq 'nlev' and dimnames[1] eq 'nlon' and dimnames[2] eq 'nlat') then begin ; k,i,j
    fout = fltarr(idims[1],idims[2],idims[0]) ; i,j,k
    for k=0,idims[0]-1 do begin
      for j=0,idims[2]-1 do begin
        fout[*,j,k] = fin[k,*,j]
      endfor
    endfor
  endif else if(dimnames[0] eq 'nlev' and dimnames[1] eq 'nlat' and dimnames[2] eq 'nlon') then begin ; k,j,i
    fout = fltarr(idims[2],idims[1],idims[0]) ; i,j,k
    for k=0,idims[0]-1 do begin
      for j=0,idims[1]-1 do begin
        fout[*,j,k] = fin[k,j,*]
      endfor
    endfor
  endif
  return,fout
end
;-----------------------------------------------------------------------
pro plotdata,file,psfile

;
; Calls to save_data (savedata.F90) are made from time3d.F90 in this order:
; (total of 4 output files (3 and 4 write to the same file))
; All calls are made from the masterproc only.
;
;   1. From sub time3d_prep_input:        'waccm.nc'            z,u,v_glb (waccm grid)
;   2. From sub time3d_prep_input:        'time3d_prepinput.nc' We,Ws,Wu (time3d grid)
;   3. From sub time3d_drv before time3d: 'time3d.nc'           Z,Ws,We,Wu (inputs)
;   4. From sub time3d_drv after  time3d: 'time3d.nc'           Op,Ped,Hall,et.al (output)
;   5. From sub time3d_drv after  time3d: 'time3d_mag.nc'       zigm11,et.al. (mag grid)
;
; (winds in 2 and 3 should be the same) 

; file = '/glade/scratch/foster/fwx.edyn.cam5342/run/time3d_waccm_input.nc'
; psfile = 'time3d_waccm_input.ps'

; -----------------------------------------------------------------------------------------------

; dir_nc = '/glade/scratch/foster/fwx.edyn.cam5342/run/time3d_gcmsim_input'
; dir_ps = '/glade/scratch/foster/fwx.edyn.cam5342/run/time3d_gcmsim_input'

; file   = dir_nc + '/time3d_edyn_maginput.nc'
; psfile = dir_ps + '/time3d_edyn_maginput.ps'

; file   = dir_nc + '/time3d_gcmsim_input.nc'
; psfile = dir_ps + '/time3d_gcmsim_input.ps'

; file   = dir_nc + '/time3d_gcmsim_output.nc'
; psfile = dir_ps + '/time3d_gcmsim_output.ps'

; file   = dir_nc + '/time3d_gcmsim_magoutput.nc'
; psfile = dir_ps + '/time3d_gcmsim_magoutput.ps'

; -----------------------------------------------------------------------------------------------

; dir_nc = '/glade/scratch/foster/fwx.edyn.cam5342/run/time3d_waccm_input'
; dir_ps = '/glade/scratch/foster/fwx.edyn.cam5342/run/time3d_waccm_input'

; file   = dir_nc + '/time3d_waccm_interp.nc'
; psfile = dir_ps + '/time3d_waccm_interp.ps'

; file   = dir_nc + '/time3d_waccm_input.nc'
; psfile = dir_ps + '/time3d_waccm_input.ps'

; file   = dir_nc + '/time3d_waccm_output.nc'
; psfile = dir_ps + '/time3d_waccm_output.ps'

; file   = dir_nc + '/time3d_waccm_magoutput.nc'
; psfile = dir_ps + '/time3d_waccm_magoutput.ps'

; -----------------------------------------------------------------------------------------------

; dir_nc = '/glade/scratch/foster/fwx.edyn.cam5342/run/edynamo_integ'
; dir_ps = '/glade/scratch/foster/fwx.edyn.cam5342/run/edynamo_integ'

; file   = dir_nc + '/time3d_edyn_maginput.nc'
; psfile = dir_ps + '/time3d_edyn_maginput.ps'

; file   = dir_nc + '/time3d_waccm_interp.nc'
; psfile = dir_ps + '/time3d_waccm_interp.ps'

; file   = dir_nc + '/time3d_waccm_output.nc'
; psfile = dir_ps + '/time3d_waccm_output.ps'

; file   = dir_nc + '/time3d_waccm_magoutput.nc'
; psfile = dir_ps + '/time3d_waccm_magoutput.ps'

; -----------------------------------------------------------------------------------------------

  set_plot,'PS'
  device,filename=psfile,xsize=20,ysize=12

  ncid = ncdf_open(file,/NOWRITE)
  print,'Opened file ',file
  info = ncdf_inquire(ncid)
; help,info

;** Structure <1af9528>, 4 tags, length=16, data length=16, refs=1:
;   NDIMS           LONG                 4
;   NVARS           LONG                 3
;   NGATTS          LONG                 0
;   RECDIM          LONG                 0

  if (info.nvars le 0) then begin
    print,'No variables on file ',file
    return
  endif

; ncdf_diminq,ncid,info.recdim,recname,recsize
; print,'Record dimension name=',recname,' size=',ntimes

  for i=0,info.ndims-1 do begin
    ncdf_diminq,ncid,i,dimname,dimsize
    if (dimname eq 'nlat') then nlat = dimsize
    if (dimname eq 'nlon') then nlon = dimsize
    if (dimname eq 'nlev') then nlev = dimsize
    if (dimname eq 'time') then ntimes = dimsize
  endfor

  print,'nlat=',nlat,' nlon=',nlon,' nlev=',nlev,' ntimes=',ntimes
  iframe = -1 ; gv frame numbers are 0-based
;
; Loop through variables (3d fields):
;
  for n=0,info.nvars-1 do begin
    varinfo = ncdf_varinq(ncid,n)
    idvar = ncdf_varid(ncid,varinfo.name)
    ncdf_varget,ncid,idvar,vdata

    ndims = n_elements(varinfo.dim)
    idims = intarr(ndims) & dimnames = strarr(ndims)
    dimname = ' '
    for i=0,ndims-1 do begin
      ncdf_diminq,ncid,varinfo.dim[i],dimname,dimlen
      dimnames[i]=dimname
      idims[i]=dimlen
    endfor

    print,format="('Field ',a,': ndims=',i3,' dimnames=',4a8,' idims=',4i4,' min,max=',2e12.4)",$
      varinfo.name,ndims,dimnames,idims,min(vdata),max(vdata)

    ncdf_attget,ncid,idvar,'long_name',long_name
    long_name = string(long_name)
    ncdf_attget,ncid,idvar,'units',units
    units = string(units)
;
; Contour [lon,lat] global array at selected time and levels:
;   itime = 0
    itime = ntimes-1
;   itime = ntimes-2

    vdata_new = make_ijk(vdata[*,*,*,itime],dimnames[0:2],idims[0:2])

;   for klev=0,nlev-1,5 do begin
    for klev=0,nlev-1 do begin
      glb = vdata_new[*,*,klev]
;     help,glb
      iframe = iframe+1
      print,'Frame ',iframe,' ',long_name,' klev=',klev,' itime=',itime,' min,max=',$
        min(glb),max(glb)
      plot_map,file,varinfo.name,long_name,units,klev,itime,glb
    endfor
;
; Plot at top level:
;   glb = vdata_new[*,*,nlev-1]
;   iframe = iframe+1
;   print,'Frame ',iframe,' ',long_name,' klev=nlev-1=',nlev-1,' itime=',itime,' min,max=',$
;     min(glb),max(glb)
;   plot_map,file,varinfo.name,long_name,units,nlev-1,itime,glb

  endfor ; n=0,info.nvars-1
  device,/close_file
  print,'Closed plot file ',psfile
end
