module time3d_geogrid
!
! Global geographic grid for TIME3D.
! See sub pregrid in time3d_gcmsim.f
!
  use shr_kind_mod,   only : r8 => shr_kind_r8            ! 8-byte reals
  implicit none
  save
  public
!
! Original time3d dimensions: nlat=37, nlon=48, nlev=28
! Waccm/edynamo   dimensions: nlat=
!
  integer ::        & ! geographic grid dimensions 
    nlat,           & ! number of latitudes
    nlon,           & ! number of longitudes
    nlev              ! number of midpoint levels

  real(r8),allocatable :: & ! coordinate vars
    ylatg(:),          & ! latitudes (nlat radians) (includes poles)
    ylong(:),          & ! longitudes (nlon+1 radians) (single periodic point)
    latdeg(:),         & ! latitudes (deg)
    londeg(:),         & ! longitudes (deg) (nlon+1 to include periodic point (degrees))
    alt(:)               ! altitudes(nlev)

end module time3d_geogrid
