



      module mo_prod_loss

      use shr_kind_mod, only : r8 => shr_kind_r8

      private
      public :: exp_prod_loss
      public :: imp_prod_loss

      contains

      subroutine exp_prod_loss( prod, loss, y, rxt, het_rates )

      use ppgrid, only : pver

      implicit none

!--------------------------------------------------------------------
! ... dummy args
!--------------------------------------------------------------------
      real(r8), dimension(:,:,:), intent(out) :: &
            prod, &
            loss
      real(r8), intent(in) :: y(:,:,:)
      real(r8), intent(in) :: rxt(:,:,:)
      real(r8), intent(in) :: het_rates(:,:,:)



!--------------------------------------------------------------------
! ... loss and production for Explicit method
!--------------------------------------------------------------------


         loss(:,:,1) = ((rxt(:,:,53) +rxt(:,:,54) +rxt(:,:,55))* y(:,:,3) +rxt(:,:,93) &
                 * y(:,:,12) + het_rates(:,:,16))* y(:,:,16)
         prod(:,:,1) = 0._r8
         loss(:,:,2) = ((rxt(:,:,51) +rxt(:,:,52))* y(:,:,3) + rxt(:,:,4) &
                  + het_rates(:,:,4))* y(:,:,4)
         prod(:,:,2) = 0._r8
         loss(:,:,3) = ( + rxt(:,:,221) + het_rates(:,:,85))* y(:,:,85)
         prod(:,:,3) = 0._r8
         loss(:,:,4) = ( + het_rates(:,:,86))* y(:,:,86)
         prod(:,:,4) =rxt(:,:,221)*y(:,:,85)

      end subroutine exp_prod_loss

      subroutine imp_prod_loss( prod, loss, y, rxt, het_rates )

      use ppgrid, only : pver

      implicit none

!--------------------------------------------------------------------
! ... dummy args
!--------------------------------------------------------------------
      real(r8), dimension(:), intent(out) :: &
            prod, &
            loss
      real(r8), intent(in) :: y(:)
      real(r8), intent(in) :: rxt(:)
      real(r8), intent(in) :: het_rates(:)



!--------------------------------------------------------------------
! ... loss and production for Implicit method
!--------------------------------------------------------------------


         loss(105) = (rxt(45)* y(2) +rxt(48)* y(3) +rxt(78)* y(5) +rxt(81)* y(6) &
                  +rxt(63)* y(12) +rxt(71)* y(13) +rxt(58)* y(15) +rxt(117)* y(23) &
                  +rxt(138)* y(35) +rxt(184)* y(52) +rxt(160)* y(55) +rxt(166)* y(56) &
                  +rxt(216)* y(65) + rxt(2) + rxt(3) + het_rates(1))* y(1)
         prod(105) = (.200_r8*rxt(160)*y(55) +.200_r8*rxt(166)*y(56) + &
                 .100_r8*rxt(184)*y(52))*y(1) + (.250_r8*rxt(128)*y(33) + &
                 .250_r8*rxt(176)*y(59))*y(13) +rxt(44)*y(2)
         loss(90) = (rxt(45)* y(1) +rxt(76)* y(5) + (rxt(79) +rxt(80))* y(6) +rxt(87) &
                 * y(7) +rxt(69)* y(11) +rxt(62)* y(12) +rxt(70)* y(13) +rxt(73) &
                 * y(14) +rxt(98)* y(20) +rxt(231)* y(80) + rxt(44) + het_rates(2)) &
                 * y(2)
         prod(90) = (rxt(46) +rxt(47))*y(3) +rxt(3)*y(1) +rxt(5)*y(6) +rxt(9)*y(7) &
                  +rxt(7)*y(10) +rxt(65)*y(12)*y(12) +rxt(61)*y(15)*y(13)
         loss(82) = (rxt(48)* y(1) + (rxt(51) +rxt(52))* y(4) +rxt(50)* y(11) &
                  + (rxt(53) +rxt(54) +rxt(55))* y(16) +rxt(56)* y(87) + rxt(46) &
                  + rxt(47) + rxt(49) + het_rates(3))* y(3)
         prod(82) =rxt(2)*y(1)
         loss(103) = ((rxt(94) +rxt(95))* y(12) + het_rates(17))* y(17)
         prod(103) = (.500_r8*rxt(117)*y(23) +.560_r8*rxt(138)*y(35) + &
                 .050_r8*rxt(160)*y(55) +.200_r8*rxt(166)*y(56) + &
                 .300_r8*rxt(184)*y(52))*y(1) + (rxt(97)*y(20) + &
                 .350_r8*rxt(110)*y(89) +rxt(133)*y(74) +rxt(154)*y(62) + &
                 rxt(232)*y(80))*y(12) + (rxt(96)*y(20) +rxt(155)*y(62) + &
                 .220_r8*rxt(169)*y(57) +.500_r8*rxt(203)*y(63))*y(7) + (rxt(14) + &
                 rxt(15) +rxt(98)*y(2))*y(20) + (.220_r8*rxt(167)*y(5) + &
                 .110_r8*rxt(171)*y(18) +.220_r8*rxt(172)*y(33))*y(57) &
                  + (.500_r8*rxt(202)*y(5) +.200_r8*rxt(205)*y(18) + &
                 .500_r8*rxt(206)*y(33))*y(63) + (rxt(43) +rxt(231)*y(2))*y(80) &
                  +rxt(35)*y(27) +rxt(17)*y(32) +.700_r8*rxt(24)*y(55) &
                  +1.340_r8*rxt(23)*y(56) +rxt(30)*y(62) +.450_r8*rxt(37)*y(73) &
                  +2.000_r8*rxt(38)*y(74) +rxt(32)*y(79)
         loss(68) = (rxt(69)* y(2) +rxt(50)* y(3) +rxt(67)* y(12) + het_rates(11)) &
                 * y(11)
         prod(68) =rxt(55)*y(16)*y(3) +rxt(60)*y(15)*y(13) +rxt(15)*y(20)
         loss(32) = (rxt(56)* y(3) +rxt(74)* y(12) + het_rates(87))* y(87)
         prod(32) = 0._r8
         loss(25) = (rxt(75)* y(12) + het_rates(88))* y(88)
         prod(25) = 0._r8
         loss(79) = (rxt(58)* y(1) + (rxt(59) +rxt(60) +rxt(61))* y(13) + rxt(57) &
                  + het_rates(15))* y(15)
         prod(79) = (rxt(62)*y(2) +rxt(67)*y(11) +rxt(94)*y(17) +rxt(97)*y(20) + &
                 rxt(232)*y(80))*y(12) + (rxt(54)*y(16) +rxt(50)*y(11))*y(3) &
                  +rxt(69)*y(11)*y(2) +rxt(13)*y(19)
         loss(98) = (rxt(78)* y(1) +rxt(76)* y(2) +rxt(86)* y(7) +rxt(77)* y(13) &
                  +rxt(100)* y(18) +rxt(113)* y(25) +rxt(119)* y(30) +rxt(126)* y(33) &
                  +rxt(140)* y(37) +rxt(145)* y(39) +rxt(149)* y(42) +rxt(158)* y(45) &
                  +rxt(162)* y(47) +rxt(199)* y(50) +rxt(186)* y(53) + (rxt(167) + &
                 rxt(168))* y(57) +rxt(174)* y(59) +rxt(202)* y(63) +rxt(218)* y(66) &
                  +rxt(210)* y(70) +rxt(192)* y(78) +rxt(108)* y(91) + het_rates(5)) &
                 * y(5)
         prod(98) = (rxt(5) +.500_r8*rxt(224) +rxt(79)*y(2))*y(6) &
                  +2.000_r8*rxt(51)*y(4)*y(3) +rxt(10)*y(7) +rxt(7)*y(10)
         loss(99) = (rxt(81)* y(1) + (rxt(79) +rxt(80))* y(2) +rxt(82)* y(7) +rxt(84) &
                 * y(12) +rxt(90)* y(13) +rxt(127)* y(33) +rxt(180)* y(59) +rxt(214) &
                 * y(72) + rxt(5) + rxt(224) + het_rates(6))* y(6)
         prod(99) = (rxt(76)*y(2) +rxt(77)*y(13) +rxt(78)*y(1) + &
                 2.000_r8*rxt(86)*y(7) +rxt(100)*y(18) +rxt(108)*y(91) + &
                 rxt(113)*y(25) +rxt(119)*y(30) +rxt(126)*y(33) +rxt(140)*y(37) + &
                 rxt(145)*y(39) +rxt(149)*y(42) +rxt(158)*y(45) +rxt(162)*y(47) + &
                 rxt(167)*y(57) +rxt(174)*y(59) +.920_r8*rxt(186)*y(53) + &
                 1.206_r8*rxt(192)*y(78) +.900_r8*rxt(199)*y(50) +rxt(202)*y(63) + &
                 .900_r8*rxt(210)*y(70) +rxt(218)*y(66))*y(5) + (rxt(9) + &
                 rxt(87)*y(2) +rxt(88)*y(12) +rxt(89)*y(13) +rxt(169)*y(57) + &
                 rxt(175)*y(59) +rxt(187)*y(53) +1.206_r8*rxt(193)*y(78) + &
                 rxt(197)*y(79) +rxt(203)*y(63) +rxt(217)*y(65))*y(7) + (rxt(12) + &
                 rxt(92) +rxt(91)*y(12))*y(9) + (rxt(6) +rxt(83))*y(10) &
                  + (rxt(156)*y(76) +.400_r8*rxt(196)*y(79))*y(12) &
                  + (.600_r8*rxt(20) +rxt(135))*y(75) + (rxt(21) +rxt(181))*y(77) &
                  +.700_r8*rxt(214)*y(72)*y(6) +rxt(8)*y(8) +.206_r8*rxt(194)*y(78) &
                 *y(13) +rxt(32)*y(79)
         loss(97) = (rxt(87)* y(2) +rxt(86)* y(5) +rxt(82)* y(6) +rxt(88)* y(12) &
                  +rxt(89)* y(13) +rxt(96)* y(20) +rxt(125)* y(32) +rxt(139)* y(35) &
                  +rxt(185)* y(52) +rxt(187)* y(53) +rxt(169)* y(57) +rxt(175)* y(59) &
                  +rxt(155)* y(62) +rxt(203)* y(63) +rxt(217)* y(65) +rxt(193)* y(78) &
                  +rxt(197)* y(79) +rxt(228)* y(82) + rxt(9) + rxt(10) + rxt(223) &
                  + het_rates(7))* y(7)
         prod(97) = (rxt(6) +rxt(7) +rxt(83))*y(10) + (rxt(85)*y(8) +rxt(136)*y(75) + &
                 .500_r8*rxt(182)*y(77))*y(12) + (rxt(80)*y(2) +rxt(81)*y(1))*y(6) &
                  +rxt(11)*y(9) +.400_r8*rxt(20)*y(75)
         loss(60) = (rxt(85)* y(12) + rxt(8) + het_rates(8))* y(8)
         prod(60) = (rxt(223) +rxt(96)*y(20) +rxt(125)*y(32) +rxt(155)*y(62) + &
                 rxt(228)*y(82))*y(7) + (.500_r8*rxt(224) +rxt(84)*y(12))*y(6) &
                  +2.000_r8*rxt(222)*y(10)
         loss(47) = (rxt(91)* y(12) + rxt(11) + rxt(12) + rxt(92) + het_rates(9)) &
                 * y(9)
         prod(47) =rxt(90)*y(13)*y(6)
         loss(39) = ( + rxt(6) + rxt(7) + rxt(83) + rxt(222) + het_rates(10))* y(10)
         prod(39) =rxt(82)*y(7)*y(6)
         loss(101) = (rxt(63)* y(1) +rxt(62)* y(2) +rxt(84)* y(6) +rxt(88)* y(7) &
                  +rxt(85)* y(8) +rxt(91)* y(9) +rxt(67)* y(11) + 2._r8*(rxt(65) + &
                 rxt(66))* y(12) +rxt(64)* y(13) +rxt(68)* y(14) +rxt(93)* y(16) &
                  + (rxt(94) +rxt(95))* y(17) +rxt(105)* y(19) +rxt(97)* y(20) &
                  +rxt(104)* y(21) +rxt(134)* y(22) +rxt(112)* y(23) +rxt(118)* y(26) &
                  +rxt(132)* y(27) +rxt(111)* y(29) +rxt(123)* y(31) +rxt(124)* y(32) &
                  +rxt(131)* y(34) +rxt(137)* y(35) +rxt(144)* y(36) +rxt(143)* y(38) &
                  +rxt(147)* y(40) +rxt(148)* y(41) +rxt(152)* y(43) +rxt(157)* y(44) &
                  +rxt(161)* y(46) +rxt(164)* y(48) +rxt(195)* y(49) +rxt(201)* y(51) &
                  +rxt(183)* y(52) +rxt(189)* y(54) +rxt(159)* y(55) +rxt(165)* y(56) &
                  +rxt(173)* y(58) +rxt(198)* y(60) +rxt(153)* y(61) +rxt(154)* y(62) &
                  +rxt(207)* y(64) +rxt(215)* y(65) +rxt(220)* y(67) +rxt(209)* y(68) &
                  +rxt(213)* y(69) +rxt(212)* y(71) +rxt(133)* y(74) +rxt(136)* y(75) &
                  +rxt(156)* y(76) +rxt(182)* y(77) +rxt(196)* y(79) +rxt(232)* y(80) &
                  +rxt(225)* y(81) + (rxt(226) +rxt(227))* y(82) +rxt(229)* y(83) &
                  +rxt(74)* y(87) +rxt(75)* y(88) +rxt(110)* y(89) +rxt(106)* y(90) &
                  + het_rates(12))* y(12)
         prod(101) = (rxt(58)*y(15) +rxt(71)*y(13) +.120_r8*rxt(117)*y(23) + &
                 .330_r8*rxt(138)*y(35) +.080_r8*rxt(160)*y(55) + &
                 .215_r8*rxt(166)*y(56) +.270_r8*rxt(184)*y(52) + &
                 .700_r8*rxt(216)*y(65))*y(1) + (.300_r8*rxt(105)*y(19) + &
                 .650_r8*rxt(110)*y(89) +.500_r8*rxt(123)*y(31) + &
                 .500_r8*rxt(147)*y(40) +.100_r8*rxt(173)*y(58))*y(12) &
                  + (rxt(69)*y(11) +rxt(70)*y(13) +rxt(73)*y(14) +rxt(98)*y(20))*y(2) &
                  + (2.000_r8*rxt(49) +rxt(53)*y(16) +rxt(50)*y(11) +rxt(56)*y(87)) &
                 *y(3) + (2.000_r8*rxt(59)*y(15) +rxt(77)*y(5) +rxt(89)*y(7))*y(13) &
                  +.500_r8*rxt(224)*y(6) +rxt(8)*y(8) +rxt(11)*y(9) +2.000_r8*rxt(16) &
                 *y(14) +rxt(13)*y(19) +rxt(26)*y(28) +rxt(25)*y(31) +rxt(19)*y(34) &
                  +rxt(27)*y(38) +rxt(18)*y(40) +rxt(28)*y(43) +rxt(40)*y(48) +rxt(39) &
                 *y(51) +rxt(31)*y(64) +rxt(42)*y(67) +rxt(41)*y(71)
         loss(102) = (rxt(71)* y(1) +rxt(70)* y(2) +rxt(77)* y(5) +rxt(90)* y(6) &
                  +rxt(89)* y(7) +rxt(64)* y(12) + 2._r8*rxt(72)* y(13) + (rxt(59) + &
                 rxt(60) +rxt(61))* y(15) +rxt(101)* y(18) +rxt(99)* y(20) +rxt(114) &
                 * y(25) +rxt(120)* y(30) +rxt(128)* y(33) +rxt(141)* y(37) +rxt(146) &
                 * y(39) +rxt(150)* y(42) +rxt(163)* y(47) +rxt(200)* y(50) +rxt(188) &
                 * y(53) +rxt(170)* y(57) +rxt(176)* y(59) +rxt(204)* y(63) +rxt(219) &
                 * y(66) +rxt(211)* y(70) +rxt(194)* y(78) +rxt(109)* y(91) + rxt(230) &
                  + het_rates(13))* y(13)
         prod(102) = (rxt(63)*y(1) +rxt(68)*y(14) +rxt(74)*y(87) +rxt(75)*y(88) + &
                 rxt(88)*y(7) +rxt(95)*y(17) +rxt(104)*y(21) +rxt(106)*y(90) + &
                 .350_r8*rxt(110)*y(89) +rxt(132)*y(27) +rxt(133)*y(74) + &
                 rxt(134)*y(22) +rxt(153)*y(61) +.200_r8*rxt(173)*y(58) + &
                 .500_r8*rxt(182)*y(77) +rxt(196)*y(79) +.250_r8*rxt(209)*y(68) + &
                 .500_r8*rxt(227)*y(82))*y(12) + (rxt(100)*y(18) +rxt(108)*y(91) + &
                 .250_r8*rxt(113)*y(25) +rxt(119)*y(30) +rxt(140)*y(37) + &
                 rxt(145)*y(39) +rxt(158)*y(45) +.470_r8*rxt(167)*y(57) + &
                 rxt(186)*y(53) +.794_r8*rxt(192)*y(78) +.900_r8*rxt(199)*y(50) + &
                 rxt(202)*y(63) +.900_r8*rxt(210)*y(70) +rxt(218)*y(66))*y(5) &
                  + (2.000_r8*rxt(102)*y(18) +rxt(121)*y(30) +.900_r8*rxt(129)*y(33) + &
                 rxt(142)*y(37) +.300_r8*rxt(151)*y(42) +.730_r8*rxt(171)*y(57) + &
                 rxt(177)*y(59) +rxt(190)*y(53) +.800_r8*rxt(205)*y(63))*y(18) &
                  + (.120_r8*rxt(117)*y(23) +.190_r8*rxt(138)*y(35) + &
                 .060_r8*rxt(160)*y(55) +.275_r8*rxt(166)*y(56) + &
                 .060_r8*rxt(184)*y(52) +rxt(216)*y(65))*y(1) + (rxt(96)*y(20) + &
                 .470_r8*rxt(169)*y(57) +rxt(187)*y(53) +.794_r8*rxt(193)*y(78) + &
                 rxt(197)*y(79) +rxt(203)*y(63))*y(7) + (.470_r8*rxt(172)*y(57) + &
                 rxt(191)*y(53) +rxt(206)*y(63))*y(33) + (rxt(73)*y(14) + &
                 rxt(98)*y(20))*y(2) + (rxt(12) +rxt(92))*y(9) + (rxt(115) +rxt(116)) &
                 *y(24) + (1.340_r8*rxt(22) +.660_r8*rxt(23))*y(56) +rxt(54)*y(16) &
                 *y(3) +.700_r8*rxt(214)*y(72)*y(6) +.794_r8*rxt(194)*y(78)*y(13) &
                  +rxt(57)*y(15) +2.000_r8*rxt(35)*y(27) +1.200_r8*rxt(122)*y(30) &
                 *y(30) +rxt(25)*y(31) +rxt(17)*y(32) +rxt(27)*y(38) +rxt(18)*y(40) &
                  +.900_r8*rxt(39)*y(51) +rxt(33)*y(54) +rxt(34)*y(61) +rxt(30)*y(62) &
                  +rxt(42)*y(67) +.560_r8*rxt(37)*y(73) +2.000_r8*rxt(38)*y(74) &
                  +rxt(32)*y(79) +rxt(107)*y(91)
         loss(38) = (rxt(73)* y(2) +rxt(68)* y(12) + rxt(16) + het_rates(14))* y(14)
         prod(38) = (.500_r8*rxt(230) +rxt(72)*y(13))*y(13) +rxt(66)*y(12)*y(12)
         loss(104) = (rxt(100)* y(5) +rxt(101)* y(13) + 2._r8*(rxt(102) +rxt(103)) &
                 * y(18) +rxt(121)* y(30) +rxt(129)* y(33) +rxt(142)* y(37) +rxt(151) &
                 * y(42) +rxt(190)* y(53) +rxt(171)* y(57) +rxt(177)* y(59) +rxt(205) &
                 * y(63) + het_rates(18))* y(18)
         prod(104) = (rxt(126)*y(5) +.900_r8*rxt(129)*y(18) +2.000_r8*rxt(130)*y(33) + &
                 rxt(172)*y(57) +rxt(178)*y(59) +rxt(191)*y(53) +rxt(206)*y(63))*y(33) &
                  + (rxt(93)*y(16) +.700_r8*rxt(105)*y(19) +rxt(118)*y(26))*y(12) &
                  +.310_r8*rxt(138)*y(35)*y(1) +rxt(53)*y(16)*y(3) +rxt(17)*y(32) &
                  +rxt(19)*y(34) +rxt(29)*y(41) +.300_r8*rxt(24)*y(55) &
                  +.400_r8*rxt(20)*y(75)
         loss(49) = (rxt(105)* y(12) + rxt(13) + het_rates(19))* y(19)
         prod(49) =rxt(101)*y(18)*y(13)
         loss(100) = (rxt(98)* y(2) +rxt(96)* y(7) +rxt(97)* y(12) +rxt(99)* y(13) &
                  + rxt(14) + rxt(15) + het_rates(20))* y(20)
         prod(100) = (rxt(100)*y(5) +2.000_r8*rxt(102)*y(18) +rxt(103)*y(18) + &
                 .700_r8*rxt(121)*y(30) +rxt(129)*y(33) +rxt(142)*y(37) + &
                 .800_r8*rxt(151)*y(42) +.880_r8*rxt(171)*y(57) + &
                 2.000_r8*rxt(177)*y(59) +1.200_r8*rxt(190)*y(53) + &
                 .700_r8*rxt(205)*y(63))*y(18) + (.500_r8*rxt(113)*y(25) + &
                 rxt(145)*y(39) +rxt(149)*y(42) +.500_r8*rxt(158)*y(45) + &
                 .250_r8*rxt(167)*y(57) +rxt(174)*y(59) +.510_r8*rxt(186)*y(53) + &
                 .072_r8*rxt(192)*y(78) +.100_r8*rxt(199)*y(50))*y(5) &
                  + (rxt(104)*y(21) +.300_r8*rxt(105)*y(19) +.500_r8*rxt(131)*y(34) + &
                 .800_r8*rxt(132)*y(27) +rxt(136)*y(75) +.500_r8*rxt(182)*y(77))*y(12) &
                  + (rxt(117)*y(23) +.540_r8*rxt(138)*y(35) +.800_r8*rxt(160)*y(55) + &
                 .700_r8*rxt(166)*y(56) +.600_r8*rxt(184)*y(52))*y(1) &
                  + (.250_r8*rxt(169)*y(57) +rxt(175)*y(59) +.600_r8*rxt(187)*y(53) + &
                 .072_r8*rxt(193)*y(78))*y(7) + (.250_r8*rxt(172)*y(57) + &
                 rxt(178)*y(59) +.600_r8*rxt(191)*y(53))*y(33) + (rxt(54)*y(16) + &
                 rxt(55)*y(16))*y(3) +.008_r8*rxt(194)*y(78)*y(13) +rxt(13)*y(19) &
                  +2.000_r8*rxt(116)*y(24) +rxt(35)*y(27) +rxt(18)*y(40) +rxt(28) &
                 *y(43) +.100_r8*rxt(39)*y(51) +.690_r8*rxt(33)*y(54) &
                  +1.340_r8*rxt(22)*y(56) +2.000_r8*rxt(179)*y(59)*y(59) +rxt(34) &
                 *y(61) +rxt(32)*y(79) +rxt(107)*y(91)
         loss(65) = (rxt(104)* y(12) + het_rates(21))* y(21)
         prod(65) = (rxt(103)*y(18) +.300_r8*rxt(121)*y(30) +.500_r8*rxt(151)*y(42) + &
                 .250_r8*rxt(171)*y(57) +.250_r8*rxt(190)*y(53) + &
                 .300_r8*rxt(205)*y(63))*y(18)
         loss(36) = (rxt(134)* y(12) + het_rates(22))* y(22)
         prod(36) = (.200_r8*rxt(121)*y(18) +.400_r8*rxt(122)*y(30))*y(30)
         loss(26) = ( + rxt(26) + het_rates(28))* y(28)
         prod(26) =rxt(114)*y(25)*y(13)
         loss(46) = (rxt(117)* y(1) +rxt(112)* y(12) + het_rates(23))* y(23)
         prod(46) = 0._r8
         loss(37) = ( + rxt(115) + rxt(116) + het_rates(24))* y(24)
         prod(37) =.750_r8*rxt(113)*y(25)*y(5) +rxt(26)*y(28)
         loss(66) = (rxt(113)* y(5) +rxt(114)* y(13) + het_rates(25))* y(25)
         prod(66) =rxt(112)*y(23)*y(12)
         loss(54) = (rxt(118)* y(12) + het_rates(26))* y(26)
         prod(54) = (.250_r8*rxt(138)*y(35) +.200_r8*rxt(184)*y(52))*y(1) &
                  + (.250_r8*rxt(128)*y(33) +.250_r8*rxt(176)*y(59))*y(13) &
                  +.100_r8*rxt(129)*y(33)*y(18)
         loss(77) = (rxt(132)* y(12) + rxt(35) + het_rates(27))* y(27)
         prod(77) = (.530_r8*rxt(167)*y(5) +.530_r8*rxt(169)*y(7) + &
                 .260_r8*rxt(171)*y(18) +.530_r8*rxt(172)*y(33))*y(57) &
                  + (.250_r8*rxt(202)*y(5) +.250_r8*rxt(203)*y(7) + &
                 .100_r8*rxt(205)*y(18) +.250_r8*rxt(206)*y(33))*y(63) +rxt(115)*y(24)
         loss(21) = (rxt(111)* y(12) + het_rates(29))* y(29)
         prod(21) = 0._r8
         loss(75) = (rxt(119)* y(5) +rxt(120)* y(13) +rxt(121)* y(18) + 2._r8*rxt(122) &
                 * y(30) + het_rates(30))* y(30)
         prod(75) = (rxt(111)*y(29) +.500_r8*rxt(123)*y(31))*y(12) +rxt(36)*y(46)
         loss(44) = (rxt(123)* y(12) + rxt(25) + het_rates(31))* y(31)
         prod(44) =rxt(120)*y(30)*y(13)
         loss(83) = (rxt(125)* y(7) +rxt(124)* y(12) + rxt(17) + het_rates(32))* y(32)
         prod(83) = (rxt(119)*y(30) +.270_r8*rxt(140)*y(37) +rxt(145)*y(39) + &
                 rxt(158)*y(45) +rxt(162)*y(47) +.400_r8*rxt(199)*y(50))*y(5) &
                  + (.500_r8*rxt(138)*y(35) +.040_r8*rxt(160)*y(55))*y(1) &
                  + (.500_r8*rxt(123)*y(31) +rxt(134)*y(22))*y(12) &
                  + (.800_r8*rxt(121)*y(18) +1.600_r8*rxt(122)*y(30))*y(30) +rxt(25) &
                 *y(31) +rxt(18)*y(40) +rxt(40)*y(48) +.400_r8*rxt(39)*y(51)
         loss(96) = (rxt(126)* y(5) +rxt(127)* y(6) +rxt(128)* y(13) +rxt(129)* y(18) &
                  + 2._r8*rxt(130)* y(33) +rxt(191)* y(53) +rxt(172)* y(57) +rxt(206) &
                 * y(63) + het_rates(33))* y(33)
         prod(96) = (rxt(149)*y(42) +rxt(162)*y(47) +.530_r8*rxt(167)*y(57) + &
                 rxt(174)*y(59))*y(5) + (rxt(125)*y(32) +rxt(155)*y(62) + &
                 .530_r8*rxt(169)*y(57) +rxt(175)*y(59))*y(7) + (rxt(124)*y(32) + &
                 .500_r8*rxt(131)*y(34) +rxt(154)*y(62))*y(12) &
                  + (.300_r8*rxt(151)*y(42) +.260_r8*rxt(171)*y(57) +rxt(177)*y(59)) &
                 *y(18) + (.600_r8*rxt(20) +rxt(135))*y(75) +.530_r8*rxt(172)*y(57) &
                 *y(33) +rxt(29)*y(41) +rxt(28)*y(43) +rxt(36)*y(46) +rxt(40)*y(48) &
                  +.300_r8*rxt(24)*y(55) +1.340_r8*rxt(22)*y(56) &
                  +2.000_r8*rxt(179)*y(59)*y(59) +rxt(34)*y(61) +rxt(30)*y(62) &
                  +.130_r8*rxt(37)*y(73)
         loss(55) = (rxt(131)* y(12) + rxt(19) + het_rates(34))* y(34)
         prod(55) = (.750_r8*rxt(128)*y(33) +.750_r8*rxt(176)*y(59))*y(13)
         loss(81) = (rxt(138)* y(1) +rxt(139)* y(7) +rxt(137)* y(12) + het_rates(35)) &
                 * y(35)
         prod(81) =.070_r8*rxt(184)*y(52)*y(1) +.700_r8*rxt(24)*y(55)
         loss(22) = (rxt(144)* y(12) + het_rates(36))* y(36)
         prod(22) = 0._r8
         loss(76) = (rxt(140)* y(5) +rxt(141)* y(13) +rxt(142)* y(18) + het_rates(37)) &
                 * y(37)
         prod(76) = (rxt(143)*y(38) +rxt(144)*y(36))*y(12)
         loss(48) = (rxt(143)* y(12) + rxt(27) + het_rates(38))* y(38)
         prod(48) =rxt(141)*y(37)*y(13)
         loss(73) = (rxt(145)* y(5) +rxt(146)* y(13) + het_rates(39))* y(39)
         prod(73) = (rxt(137)*y(35) +.500_r8*rxt(147)*y(40))*y(12)
         loss(57) = (rxt(147)* y(12) + rxt(18) + het_rates(40))* y(40)
         prod(57) =rxt(146)*y(39)*y(13)
         loss(72) = (rxt(148)* y(12) + rxt(29) + het_rates(41))* y(41)
         prod(72) = (.820_r8*rxt(140)*y(37) +.500_r8*rxt(158)*y(45) + &
                 .250_r8*rxt(199)*y(50) +.100_r8*rxt(218)*y(66))*y(5) &
                  +.820_r8*rxt(142)*y(37)*y(18) +.820_r8*rxt(27)*y(38) &
                  +.250_r8*rxt(39)*y(51) +.100_r8*rxt(42)*y(67)
         loss(86) = (rxt(149)* y(5) +rxt(150)* y(13) +rxt(151)* y(18) + het_rates(42)) &
                 * y(42)
         prod(86) = (rxt(148)*y(41) +rxt(152)*y(43))*y(12)
         loss(40) = (rxt(152)* y(12) + rxt(28) + het_rates(43))* y(43)
         prod(40) =rxt(150)*y(42)*y(13)
         loss(23) = (rxt(157)* y(12) + het_rates(44))* y(44)
         prod(23) = 0._r8
         loss(41) = (rxt(158)* y(5) + het_rates(45))* y(45)
         prod(41) =rxt(157)*y(44)*y(12)
         loss(24) = (rxt(195)* y(12) + het_rates(49))* y(49)
         prod(24) = 0._r8
         loss(74) = (rxt(199)* y(5) +rxt(200)* y(13) + het_rates(50))* y(50)
         prod(74) = (rxt(195)*y(49) +rxt(201)*y(51))*y(12)
         loss(70) = (rxt(201)* y(12) + rxt(39) + het_rates(51))* y(51)
         prod(70) =rxt(200)*y(50)*y(13)
         loss(56) = (rxt(161)* y(12) + rxt(36) + het_rates(46))* y(46)
         prod(56) =.800_r8*rxt(199)*y(50)*y(5) +.800_r8*rxt(39)*y(51)
         loss(71) = (rxt(162)* y(5) +rxt(163)* y(13) + het_rates(47))* y(47)
         prod(71) = (rxt(161)*y(46) +rxt(164)*y(48))*y(12)
         loss(42) = (rxt(164)* y(12) + rxt(40) + het_rates(48))* y(48)
         prod(42) =rxt(163)*y(47)*y(13)
         loss(78) = (rxt(184)* y(1) +rxt(185)* y(7) +rxt(183)* y(12) + het_rates(52)) &
                 * y(52)
         prod(78) = 0._r8
         loss(94) = (rxt(186)* y(5) +rxt(187)* y(7) +rxt(188)* y(13) +rxt(190)* y(18) &
                  +rxt(191)* y(33) + het_rates(53))* y(53)
         prod(94) = (rxt(183)*y(52) +.200_r8*rxt(189)*y(54))*y(12)
         loss(61) = (rxt(189)* y(12) + rxt(33) + het_rates(54))* y(54)
         prod(61) =rxt(188)*y(53)*y(13)
         loss(92) = (rxt(160)* y(1) +rxt(159)* y(12) + rxt(24) + het_rates(55))* y(55)
         prod(92) = (.320_r8*rxt(186)*y(5) +.350_r8*rxt(187)*y(7) + &
                 .260_r8*rxt(190)*y(18) +.350_r8*rxt(191)*y(33))*y(53) &
                  + (.039_r8*rxt(192)*y(5) +.039_r8*rxt(193)*y(7) + &
                 .039_r8*rxt(194)*y(13))*y(78) + (.200_r8*rxt(184)*y(52) + &
                 rxt(216)*y(65))*y(1) +rxt(218)*y(66)*y(5) +.402_r8*rxt(33)*y(54) &
                  +rxt(42)*y(67)
         loss(88) = (rxt(166)* y(1) +rxt(165)* y(12) + rxt(22) + rxt(23) &
                  + het_rates(56))* y(56)
         prod(88) = (.230_r8*rxt(186)*y(5) +.250_r8*rxt(187)*y(7) + &
                 .190_r8*rxt(190)*y(18) +.250_r8*rxt(191)*y(33))*y(53) &
                  + (.167_r8*rxt(192)*y(5) +.167_r8*rxt(193)*y(7) + &
                 .167_r8*rxt(194)*y(13))*y(78) + (.400_r8*rxt(184)*y(52) + &
                 rxt(216)*y(65))*y(1) +rxt(218)*y(66)*y(5) +.288_r8*rxt(33)*y(54) &
                  +rxt(42)*y(67)
         loss(93) = ((rxt(167) +rxt(168))* y(5) +rxt(169)* y(7) +rxt(170)* y(13) &
                  +rxt(171)* y(18) +rxt(172)* y(33) + het_rates(57))* y(57)
         prod(93) = (rxt(159)*y(55) +.500_r8*rxt(165)*y(56) +.200_r8*rxt(173)*y(58)) &
                 *y(12)
         loss(43) = (rxt(173)* y(12) + het_rates(58))* y(58)
         prod(43) =rxt(170)*y(57)*y(13)
         loss(95) = (rxt(174)* y(5) +rxt(180)* y(6) +rxt(175)* y(7) +rxt(176)* y(13) &
                  +rxt(177)* y(18) +rxt(178)* y(33) + 2._r8*rxt(179)* y(59) &
                  + het_rates(59))* y(59)
         prod(95) = (.500_r8*rxt(165)*y(56) +.500_r8*rxt(173)*y(58))*y(12) &
                  + (rxt(21) +rxt(181))*y(77) +.200_r8*rxt(184)*y(52)*y(1) &
                  +.660_r8*rxt(22)*y(56)
         loss(50) = (rxt(198)* y(12) + het_rates(60))* y(60)
         prod(50) = (.370_r8*rxt(186)*y(5) +.400_r8*rxt(187)*y(7) + &
                 .300_r8*rxt(190)*y(18) +.400_r8*rxt(191)*y(33))*y(53) &
                  + (rxt(196)*y(12) +rxt(197)*y(7))*y(79)
         loss(87) = (rxt(153)* y(12) + rxt(34) + het_rates(61))* y(61)
         prod(87) = (.220_r8*rxt(167)*y(5) +.220_r8*rxt(169)*y(7) + &
                 .230_r8*rxt(171)*y(18) +.220_r8*rxt(172)*y(33))*y(57) &
                  + (.250_r8*rxt(202)*y(5) +.250_r8*rxt(203)*y(7) + &
                 .100_r8*rxt(205)*y(18) +.250_r8*rxt(206)*y(33))*y(63) &
                  + (.500_r8*rxt(147)*y(40) +.500_r8*rxt(182)*y(77))*y(12) &
                  +.200_r8*rxt(151)*y(42)*y(18)
         loss(89) = (rxt(155)* y(7) +rxt(154)* y(12) + rxt(30) + het_rates(62))* y(62)
         prod(89) = (.250_r8*rxt(167)*y(5) +.250_r8*rxt(169)*y(7) + &
                 .240_r8*rxt(171)*y(18) +.250_r8*rxt(172)*y(33))*y(57) &
                  + (.250_r8*rxt(202)*y(5) +.250_r8*rxt(203)*y(7) + &
                 .100_r8*rxt(205)*y(18) +.250_r8*rxt(206)*y(33))*y(63) &
                  + (.950_r8*rxt(160)*y(55) +.800_r8*rxt(166)*y(56))*y(1) &
                  + (rxt(153)*y(61) +rxt(156)*y(76))*y(12) +.450_r8*rxt(210)*y(70) &
                 *y(5) +.500_r8*rxt(151)*y(42)*y(18) +.450_r8*rxt(41)*y(71) &
                  +.180_r8*rxt(37)*y(73)
         loss(91) = (rxt(202)* y(5) +rxt(203)* y(7) +rxt(204)* y(13) +rxt(205)* y(18) &
                  +rxt(206)* y(33) + het_rates(63))* y(63)
         prod(91) = (.800_r8*rxt(189)*y(54) +rxt(198)*y(60) +rxt(207)*y(64))*y(12)
         loss(33) = ((rxt(207) +rxt(208))* y(12) + rxt(31) + het_rates(64))* y(64)
         prod(33) = (rxt(194)*y(78) +rxt(204)*y(63))*y(13)
         loss(67) = (rxt(216)* y(1) +rxt(217)* y(7) +rxt(215)* y(12) + het_rates(65)) &
                 * y(65)
         prod(67) = 0._r8
         loss(80) = (rxt(218)* y(5) +rxt(219)* y(13) + het_rates(66))* y(66)
         prod(80) = (rxt(215)*y(65) +rxt(220)*y(67))*y(12) +rxt(217)*y(65)*y(7)
         loss(58) = (rxt(220)* y(12) + rxt(42) + het_rates(67))* y(67)
         prod(58) =rxt(219)*y(66)*y(13)
         loss(27) = (rxt(209)* y(12) + het_rates(68))* y(68)
         prod(27) = 0._r8
         loss(28) = (rxt(213)* y(12) + het_rates(69))* y(69)
         prod(28) =.250_r8*rxt(209)*y(68)*y(12)
         loss(62) = (rxt(210)* y(5) +rxt(211)* y(13) + het_rates(70))* y(70)
         prod(62) = (.700_r8*rxt(209)*y(68) +rxt(212)*y(71))*y(12)
         loss(51) = (rxt(212)* y(12) + rxt(41) + het_rates(71))* y(71)
         prod(51) =rxt(211)*y(70)*y(13)
         loss(31) = (rxt(214)* y(6) + het_rates(72))* y(72)
         prod(31) =rxt(213)*y(69)*y(12)
         loss(63) = ( + rxt(37) + het_rates(73))* y(73)
         prod(63) =.900_r8*rxt(210)*y(70)*y(5) +.700_r8*rxt(214)*y(72)*y(6) &
                  +.900_r8*rxt(41)*y(71)
         loss(69) = (rxt(133)* y(12) + rxt(38) + het_rates(74))* y(74)
         prod(69) = (.250_r8*rxt(202)*y(5) +.250_r8*rxt(203)*y(7) + &
                 .100_r8*rxt(205)*y(18) +.250_r8*rxt(206)*y(33))*y(63) &
                  + (.650_r8*rxt(110)*y(89) +.200_r8*rxt(132)*y(27))*y(12) &
                  +.450_r8*rxt(210)*y(70)*y(5) +.450_r8*rxt(41)*y(71) +.130_r8*rxt(37) &
                 *y(73)
         loss(59) = (rxt(136)* y(12) + rxt(20) + rxt(135) + het_rates(75))* y(75)
         prod(59) =rxt(127)*y(33)*y(6)
         loss(52) = (rxt(156)* y(12) + het_rates(76))* y(76)
         prod(52) =.100_r8*rxt(199)*y(50)*y(5) +rxt(139)*y(35)*y(7)
         loss(64) = (rxt(182)* y(12) + rxt(21) + rxt(181) + het_rates(77))* y(77)
         prod(64) =rxt(180)*y(59)*y(6)
         loss(85) = (rxt(192)* y(5) +rxt(193)* y(7) +rxt(194)* y(13) + het_rates(78)) &
                 * y(78)
         prod(85) =rxt(185)*y(52)*y(7)
         loss(84) = (rxt(197)* y(7) +rxt(196)* y(12) + rxt(32) + het_rates(79))* y(79)
         prod(84) = (.800_r8*rxt(168)*y(57) +.080_r8*rxt(186)*y(53) + &
                 .794_r8*rxt(192)*y(78))*y(5) + (.794_r8*rxt(193)*y(7) + &
                 .794_r8*rxt(194)*y(13))*y(78)
         loss(34) = (rxt(231)* y(2) +rxt(232)* y(12) + rxt(43) + het_rates(80))* y(80)
         prod(34) = 0._r8
         loss(29) = (rxt(225)* y(12) + het_rates(81))* y(81)
         prod(29) = (rxt(226)*y(82) +.500_r8*rxt(227)*y(82) +rxt(232)*y(80))*y(12) &
                  +rxt(228)*y(82)*y(7)
         loss(35) = (rxt(228)* y(7) + (rxt(226) +rxt(227))* y(12) + het_rates(82)) &
                 * y(82)
         prod(35) = 0._r8
         loss(20) = (rxt(229)* y(12) + het_rates(83))* y(83)
         prod(20) = 0._r8
         loss(1) = ( + het_rates(84))* y(84)
         prod(1) = 0._r8
         loss(2) = ( + het_rates(94))* y(94)
         prod(2) = 0._r8
         loss(30) = (rxt(110)* y(12) + het_rates(89))* y(89)
         prod(30) = 0._r8
         loss(45) = (rxt(106)* y(12) + het_rates(90))* y(90)
         prod(45) = (rxt(108)*y(5) +rxt(109)*y(13))*y(91) +.500_r8*rxt(117)*y(23)*y(1) &
                  +.350_r8*rxt(110)*y(89)*y(12)
         loss(53) = (rxt(108)* y(5) +rxt(109)* y(13) + rxt(107) + het_rates(91)) &
                 * y(91)
         prod(53) =rxt(99)*y(20)*y(13)
         loss(3) = ( + het_rates(92))* y(92)
         prod(3) =rxt(225)*y(81)*y(12)
         loss(4) = ( + het_rates(93))* y(93)
         prod(4) = 0._r8
         loss(5) = ( + het_rates(95))* y(95)
         prod(5) = 0._r8
         loss(6) = ( + het_rates(96))* y(96)
         prod(6) = 0._r8
         loss(7) = ( + het_rates(97))* y(97)
         prod(7) = 0._r8
         loss(8) = ( + het_rates(98))* y(98)
         prod(8) = 0._r8
         loss(9) = ( + het_rates(99))* y(99)
         prod(9) = 0._r8
         loss(10) = ( + het_rates(100))* y(100)
         prod(10) = 0._r8
         loss(11) = ( + het_rates(101))* y(101)
         prod(11) = 0._r8
         loss(12) = ( + het_rates(102))* y(102)
         prod(12) = 0._r8
         loss(13) = ( + het_rates(103))* y(103)
         prod(13) = 0._r8
         loss(14) = ( + het_rates(104))* y(104)
         prod(14) = 0._r8
         loss(15) = ( + het_rates(105))* y(105)
         prod(15) = 0._r8
         loss(16) = ( + het_rates(106))* y(106)
         prod(16) = 0._r8
         loss(17) = ( + het_rates(107))* y(107)
         prod(17) = 0._r8
         loss(18) = ( + het_rates(108))* y(108)
         prod(18) = 0._r8
         loss(19) = ( + het_rates(109))* y(109)
         prod(19) = 0._r8

      end subroutine imp_prod_loss

      end module mo_prod_loss
