




      module mo_nln_matrix

      use shr_kind_mod, only : r8 => shr_kind_r8

      private
      public :: nlnmat

      contains

      subroutine nlnmat01( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(845) = -(rxt(47)*y(2) + rxt(50)*y(3) + rxt(60)*y(15) + rxt(65)*y(12) &
                      + rxt(73)*y(13) + rxt(80)*y(5) + rxt(83)*y(6) + rxt(119)*y(23) &
                      + rxt(140)*y(35) + rxt(162)*y(55) + rxt(168)*y(56) + rxt(186) &
                      *y(52) + rxt(224)*y(65))
         mat(546) = -rxt(47)*y(1)
         mat(448) = -rxt(50)*y(1)
         mat(411) = -rxt(60)*y(1)
         mat(753) = -rxt(65)*y(1)
         mat(907) = -rxt(73)*y(1)
         mat(951) = -rxt(80)*y(1)
         mat(666) = -rxt(83)*y(1)
         mat(158) = -rxt(119)*y(1)
         mat(437) = -rxt(140)*y(1)
         mat(562) = -rxt(162)*y(1)
         mat(509) = -rxt(168)*y(1)
         mat(403) = -rxt(186)*y(1)
         mat(297) = -rxt(224)*y(1)

         mat(845) = mat(845) + .100_r8*rxt(186)*y(52) + .200_r8*rxt(162)*y(55) &
                      + .200_r8*rxt(168)*y(56)
         mat(907) = mat(907) + .250_r8*rxt(130)*y(33) + .250_r8*rxt(178)*y(59)
         mat(812) = .250_r8*rxt(130)*y(13)
         mat(403) = mat(403) + .100_r8*rxt(186)*y(1)
         mat(562) = mat(562) + .200_r8*rxt(162)*y(1)
         mat(509) = mat(509) + .200_r8*rxt(168)*y(1)
         mat(644) = .250_r8*rxt(178)*y(13)

         mat(540) = -(rxt(47)*y(1) + rxt(64)*y(12) + rxt(71)*y(11) + rxt(72)*y(13) &
                      + rxt(75)*y(14) + rxt(78)*y(5) + (rxt(81) + rxt(82)) * y(6) &
                      + rxt(89)*y(7) + rxt(100)*y(20) + rxt(241)*y(100))
         mat(834) = -rxt(47)*y(2)
         mat(742) = -rxt(64)*y(2)
         mat(288) = -rxt(71)*y(2)
         mat(896) = -rxt(72)*y(2)
         mat(107) = -rxt(75)*y(2)
         mat(940) = -rxt(78)*y(2)
         mat(658) = -(rxt(81) + rxt(82)) * y(2)
         mat(777) = -rxt(89)*y(2)
         mat(610) = -rxt(100)*y(2)
         mat(97) = -rxt(241)*y(2)

         mat(409) = rxt(63)*y(13)
         mat(742) = mat(742) + 2.000_r8*rxt(67)*y(12)
         mat(896) = mat(896) + rxt(63)*y(15)

         mat(444) = -(rxt(50)*y(1) + rxt(52)*y(11) + rxt(58)*y(117))
         mat(826) = -rxt(50)*y(3)
         mat(287) = -rxt(52)*y(3)
         mat(88) = -rxt(58)*y(3)

         mat(624) = -((rxt(96) + rxt(97)) * y(12))
         mat(747) = -(rxt(96) + rxt(97)) * y(17)

         mat(839) = .500_r8*rxt(119)*y(23) + .560_r8*rxt(140)*y(35) + .300_r8*rxt(186) &
                      *y(52) + .050_r8*rxt(162)*y(55) + .200_r8*rxt(168)*y(56)
         mat(542) = rxt(100)*y(20) + rxt(241)*y(100)
         mat(945) = .220_r8*rxt(169)*y(57) + .500_r8*rxt(204)*y(63)
         mat(782) = rxt(98)*y(20) + .220_r8*rxt(171)*y(57) + rxt(157)*y(62) &
                      + .500_r8*rxt(205)*y(63)
         mat(747) = mat(747) + rxt(99)*y(20) + rxt(156)*y(62) + rxt(135)*y(80) &
                      + rxt(242)*y(100) + .350_r8*rxt(112)*y(119)
         mat(978) = .110_r8*rxt(173)*y(57) + .200_r8*rxt(207)*y(63)
         mat(612) = rxt(100)*y(2) + rxt(98)*y(7) + rxt(99)*y(12)
         mat(156) = .500_r8*rxt(119)*y(1)
         mat(806) = .220_r8*rxt(174)*y(57) + .500_r8*rxt(208)*y(63)
         mat(433) = .560_r8*rxt(140)*y(1)
         mat(399) = .300_r8*rxt(186)*y(1)
         mat(557) = .050_r8*rxt(162)*y(1)
         mat(505) = .200_r8*rxt(168)*y(1)
         mat(575) = .220_r8*rxt(169)*y(5) + .220_r8*rxt(171)*y(7) + .110_r8*rxt(173) &
                      *y(18) + .220_r8*rxt(174)*y(33)
         mat(513) = rxt(157)*y(7) + rxt(156)*y(12)
         mat(527) = .500_r8*rxt(204)*y(5) + .500_r8*rxt(205)*y(7) + .200_r8*rxt(207) &
                      *y(18) + .500_r8*rxt(208)*y(33)
         mat(309) = rxt(135)*y(12)
         mat(98) = rxt(241)*y(2) + rxt(242)*y(12)
         mat(80) = .350_r8*rxt(112)*y(12)

         mat(285) = -(rxt(52)*y(3) + rxt(69)*y(12) + rxt(71)*y(2))
         mat(442) = -rxt(52)*y(11)
         mat(717) = -rxt(69)*y(11)
         mat(537) = -rxt(71)*y(11)

         mat(406) = rxt(62)*y(13)
         mat(874) = rxt(62)*y(15)

         mat(87) = -(rxt(58)*y(3) + rxt(76)*y(12))
         mat(441) = -rxt(58)*y(117)
         mat(684) = -rxt(76)*y(117)

         mat(54) = -(rxt(77)*y(12))
         mat(676) = -rxt(77)*y(118)

         mat(407) = -(rxt(60)*y(1) + (rxt(61) + rxt(62) + rxt(63)) * y(13))
         mat(823) = -rxt(60)*y(15)
         mat(885) = -(rxt(61) + rxt(62) + rxt(63)) * y(15)

         mat(538) = rxt(71)*y(11) + rxt(64)*y(12)
         mat(443) = rxt(52)*y(11)
         mat(620) = rxt(96)*y(12)
         mat(286) = rxt(71)*y(2) + rxt(52)*y(3) + rxt(69)*y(12)
         mat(730) = rxt(64)*y(2) + rxt(96)*y(17) + rxt(69)*y(11) + rxt(99)*y(20) &
                      + rxt(242)*y(100)
         mat(608) = rxt(99)*y(12)
         mat(96) = rxt(242)*y(12)

         mat(953) = -(rxt(78)*y(2) + rxt(79)*y(13) + rxt(80)*y(1) + rxt(88)*y(7) &
                      + rxt(102)*y(18) + rxt(110)*y(121) + rxt(115)*y(25) + rxt(121) &
                      *y(30) + rxt(128)*y(33) + rxt(142)*y(37) + rxt(147)*y(39) &
                      + rxt(151)*y(42) + rxt(160)*y(45) + rxt(164)*y(47) + (rxt(169) &
                      + rxt(170)) * y(57) + rxt(176)*y(59) + rxt(188)*y(53) + rxt(194) &
                      *y(84) + rxt(201)*y(50) + rxt(204)*y(63) + rxt(212)*y(70) &
                      + rxt(219)*y(73) + rxt(222)*y(76) + rxt(226)*y(66))
         mat(548) = -rxt(78)*y(5)
         mat(909) = -rxt(79)*y(5)
         mat(847) = -rxt(80)*y(5)
         mat(790) = -rxt(88)*y(5)
         mat(986) = -rxt(102)*y(5)
         mat(203) = -rxt(110)*y(5)
         mat(307) = -rxt(115)*y(5)
         mat(371) = -rxt(121)*y(5)
         mat(814) = -rxt(128)*y(5)
         mat(389) = -rxt(142)*y(5)
         mat(344) = -rxt(147)*y(5)
         mat(493) = -rxt(151)*y(5)
         mat(176) = -rxt(160)*y(5)
         mat(330) = -rxt(164)*y(5)
         mat(582) = -(rxt(169) + rxt(170)) * y(5)
         mat(646) = -rxt(176)*y(5)
         mat(603) = -rxt(188)*y(5)
         mat(482) = -rxt(194)*y(5)
         mat(360) = -rxt(201)*y(5)
         mat(533) = -rxt(204)*y(5)
         mat(278) = -rxt(212)*y(5)
         mat(192) = -rxt(219)*y(5)
         mat(224) = -rxt(222)*y(5)
         mat(423) = -rxt(226)*y(5)

         mat(548) = mat(548) + rxt(81)*y(6)
         mat(668) = rxt(81)*y(2)

         mat(662) = -((rxt(81) + rxt(82)) * y(2) + rxt(83)*y(1) + rxt(84)*y(7) + rxt(86) &
                      *y(12) + rxt(92)*y(13) + rxt(129)*y(33) + rxt(182)*y(59) + rxt(216) &
                      *y(78))
         mat(543) = -(rxt(81) + rxt(82)) * y(6)
         mat(841) = -rxt(83)*y(6)
         mat(784) = -rxt(84)*y(6)
         mat(749) = -rxt(86)*y(6)
         mat(903) = -rxt(92)*y(6)
         mat(808) = -rxt(129)*y(6)
         mat(640) = -rxt(182)*y(6)
         mat(85) = -rxt(216)*y(6)

         mat(841) = mat(841) + rxt(80)*y(5)
         mat(543) = mat(543) + rxt(78)*y(5) + rxt(89)*y(7)
         mat(947) = rxt(80)*y(1) + rxt(78)*y(2) + 2.000_r8*rxt(88)*y(7) + rxt(79) &
                      *y(13) + rxt(102)*y(18) + rxt(115)*y(25) + rxt(121)*y(30) &
                      + rxt(128)*y(33) + rxt(142)*y(37) + rxt(147)*y(39) + rxt(151) &
                      *y(42) + rxt(160)*y(45) + .900_r8*rxt(201)*y(50) + rxt(164) &
                      *y(47) + .920_r8*rxt(188)*y(53) + rxt(169)*y(57) + rxt(176) &
                      *y(59) + rxt(204)*y(63) + rxt(226)*y(66) + .900_r8*rxt(212) &
                      *y(70) + .900_r8*rxt(219)*y(73) + .900_r8*rxt(222)*y(76) &
                      + 1.206_r8*rxt(194)*y(84) + rxt(110)*y(121)
         mat(662) = mat(662) + .700_r8*rxt(216)*y(78)
         mat(784) = mat(784) + rxt(89)*y(2) + 2.000_r8*rxt(88)*y(5) + rxt(90)*y(12) &
                      + rxt(91)*y(13) + rxt(189)*y(53) + rxt(171)*y(57) + rxt(177) &
                      *y(59) + rxt(205)*y(63) + rxt(225)*y(65) + 1.206_r8*rxt(195) &
                      *y(84) + rxt(199)*y(85)
         mat(140) = rxt(93)*y(12)
         mat(749) = mat(749) + rxt(90)*y(7) + rxt(93)*y(9) + rxt(158)*y(82) &
                      + .400_r8*rxt(198)*y(85)
         mat(903) = mat(903) + rxt(79)*y(5) + rxt(91)*y(7) + .206_r8*rxt(196)*y(84)
         mat(980) = rxt(102)*y(5)
         mat(304) = rxt(115)*y(5)
         mat(368) = rxt(121)*y(5)
         mat(808) = mat(808) + rxt(128)*y(5)
         mat(385) = rxt(142)*y(5)
         mat(341) = rxt(147)*y(5)
         mat(489) = rxt(151)*y(5)
         mat(174) = rxt(160)*y(5)
         mat(356) = .900_r8*rxt(201)*y(5)
         mat(326) = rxt(164)*y(5)
         mat(597) = .920_r8*rxt(188)*y(5) + rxt(189)*y(7)
         mat(577) = rxt(169)*y(5) + rxt(171)*y(7)
         mat(640) = mat(640) + rxt(176)*y(5) + rxt(177)*y(7)
         mat(528) = rxt(204)*y(5) + rxt(205)*y(7)
         mat(294) = rxt(225)*y(7)
         mat(419) = rxt(226)*y(5)
         mat(275) = .900_r8*rxt(212)*y(5)
         mat(85) = mat(85) + .700_r8*rxt(216)*y(6)
         mat(190) = .900_r8*rxt(219)*y(5)
         mat(222) = .900_r8*rxt(222)*y(5)
         mat(195) = rxt(158)*y(12)
         mat(478) = 1.206_r8*rxt(194)*y(5) + 1.206_r8*rxt(195)*y(7) + .206_r8*rxt(196) &
                      *y(13)
         mat(457) = rxt(199)*y(7) + .400_r8*rxt(198)*y(12)
         mat(200) = rxt(110)*y(5)

         mat(786) = -(rxt(84)*y(6) + rxt(88)*y(5) + rxt(89)*y(2) + rxt(90)*y(12) &
                      + rxt(91)*y(13) + rxt(98)*y(20) + rxt(127)*y(32) + rxt(141) &
                      *y(35) + rxt(157)*y(62) + rxt(171)*y(57) + rxt(177)*y(59) &
                      + rxt(187)*y(52) + rxt(189)*y(53) + rxt(195)*y(84) + rxt(199) &
                      *y(85) + rxt(205)*y(63) + rxt(225)*y(65) + rxt(237)*y(102))
         mat(664) = -rxt(84)*y(7)
         mat(949) = -rxt(88)*y(7)
         mat(545) = -rxt(89)*y(7)
         mat(751) = -rxt(90)*y(7)
         mat(905) = -rxt(91)*y(7)
         mat(615) = -rxt(98)*y(7)
         mat(466) = -rxt(127)*y(7)
         mat(436) = -rxt(141)*y(7)
         mat(516) = -rxt(157)*y(7)
         mat(579) = -rxt(171)*y(7)
         mat(642) = -rxt(177)*y(7)
         mat(402) = -rxt(187)*y(7)
         mat(599) = -rxt(189)*y(7)
         mat(480) = -rxt(195)*y(7)
         mat(459) = -rxt(199)*y(7)
         mat(530) = -rxt(205)*y(7)
         mat(296) = -rxt(225)*y(7)
         mat(104) = -rxt(237)*y(7)

         mat(843) = rxt(83)*y(6)
         mat(545) = mat(545) + rxt(82)*y(6)
         mat(664) = mat(664) + rxt(83)*y(1) + rxt(82)*y(2)
         mat(235) = rxt(87)*y(12)
         mat(751) = mat(751) + rxt(87)*y(8) + rxt(138)*y(81) + .500_r8*rxt(184)*y(83)
         mat(229) = rxt(138)*y(12)
         mat(256) = .500_r8*rxt(184)*y(12)


      end subroutine nlnmat01

      subroutine nlnmat02( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(232) = -(rxt(87)*y(12))
         mat(709) = -rxt(87)*y(8)

         mat(652) = rxt(86)*y(12)
         mat(762) = rxt(98)*y(20) + rxt(127)*y(32) + rxt(157)*y(62) + rxt(237)*y(102)
         mat(709) = mat(709) + rxt(86)*y(6)
         mat(606) = rxt(98)*y(7)
         mat(461) = rxt(127)*y(7)
         mat(511) = rxt(157)*y(7)
         mat(102) = rxt(237)*y(7)

         mat(139) = -(rxt(93)*y(12))
         mat(693) = -rxt(93)*y(9)

         mat(650) = rxt(92)*y(13)
         mat(858) = rxt(92)*y(6)


         mat(649) = rxt(84)*y(7)
         mat(759) = rxt(84)*y(6)

         mat(750) = -(rxt(64)*y(2) + rxt(65)*y(1) + rxt(66)*y(13) + (4._r8*rxt(67) &
                      + 4._r8*rxt(68)) * y(12) + rxt(69)*y(11) + rxt(70)*y(14) + rxt(76) &
                      *y(117) + rxt(77)*y(118) + rxt(86)*y(6) + rxt(87)*y(8) + rxt(90) &
                      *y(7) + rxt(93)*y(9) + (rxt(96) + rxt(97)) * y(17) + rxt(99) &
                      *y(20) + rxt(106)*y(21) + rxt(107)*y(19) + rxt(108)*y(120) &
                      + rxt(112)*y(119) + rxt(113)*y(29) + rxt(114)*y(23) + rxt(120) &
                      *y(26) + rxt(125)*y(31) + rxt(126)*y(32) + rxt(133)*y(34) &
                      + rxt(134)*y(27) + rxt(135)*y(80) + rxt(136)*y(22) + rxt(138) &
                      *y(81) + rxt(139)*y(35) + rxt(145)*y(38) + rxt(146)*y(36) &
                      + rxt(149)*y(40) + rxt(150)*y(41) + rxt(154)*y(43) + rxt(155) &
                      *y(61) + rxt(156)*y(62) + rxt(158)*y(82) + rxt(159)*y(44) &
                      + rxt(161)*y(55) + rxt(163)*y(46) + rxt(166)*y(48) + rxt(167) &
                      *y(56) + rxt(175)*y(58) + rxt(184)*y(83) + rxt(185)*y(52) &
                      + rxt(191)*y(54) + rxt(197)*y(49) + rxt(198)*y(85) + rxt(200) &
                      *y(60) + rxt(203)*y(51) + rxt(209)*y(64) + rxt(211)*y(68) &
                      + rxt(214)*y(71) + rxt(215)*y(69) + rxt(217)*y(72) + rxt(220) &
                      *y(75) + rxt(223)*y(65) + rxt(228)*y(67) + rxt(234)*y(101) &
                      + (rxt(235) + rxt(236)) * y(102) + rxt(238)*y(104) + rxt(242) &
                      *y(100))
         mat(544) = -rxt(64)*y(12)
         mat(842) = -rxt(65)*y(12)
         mat(904) = -rxt(66)*y(12)
         mat(289) = -rxt(69)*y(12)
         mat(108) = -rxt(70)*y(12)
         mat(89) = -rxt(76)*y(12)
         mat(55) = -rxt(77)*y(12)
         mat(663) = -rxt(86)*y(12)
         mat(234) = -rxt(87)*y(12)
         mat(785) = -rxt(90)*y(12)
         mat(141) = -rxt(93)*y(12)
         mat(626) = -(rxt(96) + rxt(97)) * y(12)
         mat(614) = -rxt(99)*y(12)
         mat(268) = -rxt(106)*y(12)
         mat(147) = -rxt(107)*y(12)
         mat(150) = -rxt(108)*y(12)
         mat(81) = -rxt(112)*y(12)
         mat(59) = -rxt(113)*y(12)
         mat(157) = -rxt(114)*y(12)
         mat(210) = -rxt(120)*y(12)
         mat(168) = -rxt(125)*y(12)
         mat(465) = -rxt(126)*y(12)
         mat(214) = -rxt(133)*y(12)
         mat(377) = -rxt(134)*y(12)
         mat(310) = -rxt(135)*y(12)
         mat(112) = -rxt(136)*y(12)
         mat(228) = -rxt(138)*y(12)
         mat(435) = -rxt(139)*y(12)
         mat(132) = -rxt(145)*y(12)
         mat(62) = -rxt(146)*y(12)
         mat(248) = -rxt(149)*y(12)
         mat(333) = -rxt(150)*y(12)
         mat(137) = -rxt(154)*y(12)
         mat(498) = -rxt(155)*y(12)
         mat(515) = -rxt(156)*y(12)
         mat(196) = -rxt(158)*y(12)
         mat(44) = -rxt(159)*y(12)
         mat(559) = -rxt(161)*y(12)
         mat(207) = -rxt(163)*y(12)
         mat(127) = -rxt(166)*y(12)
         mat(507) = -rxt(167)*y(12)
         mat(163) = -rxt(175)*y(12)
         mat(255) = -rxt(184)*y(12)
         mat(401) = -rxt(185)*y(12)
         mat(264) = -rxt(191)*y(12)
         mat(47) = -rxt(197)*y(12)
         mat(458) = -rxt(198)*y(12)
         mat(179) = -rxt(200)*y(12)
         mat(320) = -rxt(203)*y(12)
         mat(93) = -rxt(209)*y(12)
         mat(66) = -rxt(211)*y(12)
         mat(185) = -rxt(214)*y(12)
         mat(70) = -rxt(215)*y(12)
         mat(50) = -rxt(217)*y(12)
         mat(53) = -rxt(220)*y(12)
         mat(295) = -rxt(223)*y(12)
         mat(241) = -rxt(228)*y(12)
         mat(73) = -rxt(234)*y(12)
         mat(103) = -(rxt(235) + rxt(236)) * y(12)
         mat(41) = -rxt(238)*y(12)
         mat(99) = -rxt(242)*y(12)

         mat(842) = mat(842) + rxt(60)*y(15) + rxt(73)*y(13) + .120_r8*rxt(119)*y(23) &
                      + .330_r8*rxt(140)*y(35) + .270_r8*rxt(186)*y(52) &
                      + .080_r8*rxt(162)*y(55) + .215_r8*rxt(168)*y(56) &
                      + .700_r8*rxt(224)*y(65)
         mat(544) = mat(544) + rxt(71)*y(11) + rxt(72)*y(13) + rxt(75)*y(14) &
                      + rxt(100)*y(20)
         mat(447) = rxt(52)*y(11) + rxt(58)*y(117)
         mat(289) = mat(289) + rxt(71)*y(2) + rxt(52)*y(3)
         mat(89) = mat(89) + rxt(58)*y(3)
         mat(410) = rxt(60)*y(1) + 2.000_r8*rxt(61)*y(13)
         mat(948) = rxt(79)*y(13)
         mat(785) = mat(785) + rxt(91)*y(13)
         mat(750) = mat(750) + .300_r8*rxt(107)*y(19) + .500_r8*rxt(125)*y(31) &
                      + .500_r8*rxt(149)*y(40) + .100_r8*rxt(175)*y(58) &
                      + .650_r8*rxt(112)*y(119)
         mat(904) = mat(904) + rxt(73)*y(1) + rxt(72)*y(2) + 2.000_r8*rxt(61)*y(15) &
                      + rxt(79)*y(5) + rxt(91)*y(7)
         mat(108) = mat(108) + rxt(75)*y(2)
         mat(147) = mat(147) + .300_r8*rxt(107)*y(12)
         mat(614) = mat(614) + rxt(100)*y(2)
         mat(157) = mat(157) + .120_r8*rxt(119)*y(1)
         mat(168) = mat(168) + .500_r8*rxt(125)*y(12)
         mat(435) = mat(435) + .330_r8*rxt(140)*y(1)
         mat(248) = mat(248) + .500_r8*rxt(149)*y(12)
         mat(401) = mat(401) + .270_r8*rxt(186)*y(1)
         mat(559) = mat(559) + .080_r8*rxt(162)*y(1)
         mat(507) = mat(507) + .215_r8*rxt(168)*y(1)
         mat(163) = mat(163) + .100_r8*rxt(175)*y(12)
         mat(295) = mat(295) + .700_r8*rxt(224)*y(1)
         mat(81) = mat(81) + .650_r8*rxt(112)*y(12)

         mat(908) = -((rxt(61) + rxt(62) + rxt(63)) * y(15) + rxt(66)*y(12) + rxt(72) &
                      *y(2) + rxt(73)*y(1) + 4._r8*rxt(74)*y(13) + rxt(79)*y(5) + rxt(91) &
                      *y(7) + rxt(92)*y(6) + rxt(101)*y(20) + rxt(103)*y(18) + rxt(111) &
                      *y(121) + rxt(116)*y(25) + rxt(122)*y(30) + rxt(130)*y(33) &
                      + rxt(143)*y(37) + rxt(148)*y(39) + rxt(152)*y(42) + rxt(165) &
                      *y(47) + rxt(172)*y(57) + rxt(178)*y(59) + rxt(190)*y(53) &
                      + rxt(196)*y(84) + rxt(202)*y(50) + rxt(206)*y(63) + rxt(213) &
                      *y(70) + rxt(218)*y(73) + rxt(221)*y(76) + rxt(227)*y(66))
         mat(412) = -(rxt(61) + rxt(62) + rxt(63)) * y(13)
         mat(754) = -rxt(66)*y(13)
         mat(547) = -rxt(72)*y(13)
         mat(846) = -rxt(73)*y(13)
         mat(952) = -rxt(79)*y(13)
         mat(789) = -rxt(91)*y(13)
         mat(667) = -rxt(92)*y(13)
         mat(617) = -rxt(101)*y(13)
         mat(985) = -rxt(103)*y(13)
         mat(202) = -rxt(111)*y(13)
         mat(306) = -rxt(116)*y(13)
         mat(370) = -rxt(122)*y(13)
         mat(813) = -rxt(130)*y(13)
         mat(388) = -rxt(143)*y(13)
         mat(343) = -rxt(148)*y(13)
         mat(492) = -rxt(152)*y(13)
         mat(329) = -rxt(165)*y(13)
         mat(581) = -rxt(172)*y(13)
         mat(645) = -rxt(178)*y(13)
         mat(602) = -rxt(190)*y(13)
         mat(481) = -rxt(196)*y(13)
         mat(359) = -rxt(202)*y(13)
         mat(532) = -rxt(206)*y(13)
         mat(277) = -rxt(213)*y(13)
         mat(191) = -rxt(218)*y(13)
         mat(223) = -rxt(221)*y(13)
         mat(422) = -rxt(227)*y(13)

         mat(846) = mat(846) + rxt(65)*y(12) + .120_r8*rxt(119)*y(23) &
                      + .190_r8*rxt(140)*y(35) + .060_r8*rxt(186)*y(52) &
                      + .060_r8*rxt(162)*y(55) + .275_r8*rxt(168)*y(56) + rxt(224) &
                      *y(65)
         mat(547) = mat(547) + rxt(75)*y(14) + rxt(100)*y(20)
         mat(629) = rxt(97)*y(12)
         mat(90) = rxt(76)*y(12)
         mat(56) = rxt(77)*y(12)
         mat(952) = mat(952) + rxt(102)*y(18) + .250_r8*rxt(115)*y(25) + rxt(121) &
                      *y(30) + rxt(142)*y(37) + rxt(147)*y(39) + rxt(160)*y(45) &
                      + .900_r8*rxt(201)*y(50) + rxt(188)*y(53) + .470_r8*rxt(169) &
                      *y(57) + rxt(204)*y(63) + rxt(226)*y(66) + .900_r8*rxt(212) &
                      *y(70) + .900_r8*rxt(219)*y(73) + .900_r8*rxt(222)*y(76) &
                      + .794_r8*rxt(194)*y(84) + rxt(110)*y(121)
         mat(667) = mat(667) + .700_r8*rxt(216)*y(78)
         mat(789) = mat(789) + rxt(90)*y(12) + rxt(98)*y(20) + rxt(189)*y(53) &
                      + .470_r8*rxt(171)*y(57) + rxt(205)*y(63) + .794_r8*rxt(195) &
                      *y(84) + rxt(199)*y(85)
         mat(754) = mat(754) + rxt(65)*y(1) + rxt(97)*y(17) + rxt(76)*y(117) + rxt(77) &
                      *y(118) + rxt(90)*y(7) + rxt(70)*y(14) + rxt(106)*y(21) &
                      + rxt(136)*y(22) + rxt(134)*y(27) + .200_r8*rxt(175)*y(58) &
                      + rxt(155)*y(61) + .250_r8*rxt(211)*y(68) + rxt(135)*y(80) &
                      + .500_r8*rxt(184)*y(83) + rxt(198)*y(85) + .500_r8*rxt(236) &
                      *y(102) + .350_r8*rxt(112)*y(119) + rxt(108)*y(120)
         mat(908) = mat(908) + .794_r8*rxt(196)*y(84)
         mat(109) = rxt(75)*y(2) + rxt(70)*y(12)
         mat(985) = mat(985) + rxt(102)*y(5) + 4.000_r8*rxt(104)*y(18) + rxt(123) &
                      *y(30) + .900_r8*rxt(131)*y(33) + rxt(144)*y(37) &
                      + .300_r8*rxt(153)*y(42) + rxt(192)*y(53) + .730_r8*rxt(173) &
                      *y(57) + rxt(179)*y(59) + .800_r8*rxt(207)*y(63)
         mat(617) = mat(617) + rxt(100)*y(2) + rxt(98)*y(7)
         mat(269) = rxt(106)*y(12)
         mat(113) = rxt(136)*y(12)
         mat(159) = .120_r8*rxt(119)*y(1)
         mat(306) = mat(306) + .250_r8*rxt(115)*y(5)
         mat(378) = rxt(134)*y(12)
         mat(370) = mat(370) + rxt(121)*y(5) + rxt(123)*y(18) + 2.400_r8*rxt(124) &
                      *y(30)
         mat(813) = mat(813) + .900_r8*rxt(131)*y(18) + rxt(193)*y(53) &
                      + .470_r8*rxt(174)*y(57) + rxt(208)*y(63)
         mat(438) = .190_r8*rxt(140)*y(1)
         mat(388) = mat(388) + rxt(142)*y(5) + rxt(144)*y(18)
         mat(343) = mat(343) + rxt(147)*y(5)
         mat(492) = mat(492) + .300_r8*rxt(153)*y(18)
         mat(175) = rxt(160)*y(5)
         mat(359) = mat(359) + .900_r8*rxt(201)*y(5)
         mat(404) = .060_r8*rxt(186)*y(1)
         mat(602) = mat(602) + rxt(188)*y(5) + rxt(189)*y(7) + rxt(192)*y(18) &
                      + rxt(193)*y(33)
         mat(563) = .060_r8*rxt(162)*y(1)
         mat(510) = .275_r8*rxt(168)*y(1)
         mat(581) = mat(581) + .470_r8*rxt(169)*y(5) + .470_r8*rxt(171)*y(7) &
                      + .730_r8*rxt(173)*y(18) + .470_r8*rxt(174)*y(33)
         mat(164) = .200_r8*rxt(175)*y(12)
         mat(645) = mat(645) + rxt(179)*y(18)
         mat(500) = rxt(155)*y(12)
         mat(532) = mat(532) + rxt(204)*y(5) + rxt(205)*y(7) + .800_r8*rxt(207)*y(18) &
                      + rxt(208)*y(33)
         mat(298) = rxt(224)*y(1)
         mat(422) = mat(422) + rxt(226)*y(5)
         mat(67) = .250_r8*rxt(211)*y(12)
         mat(277) = mat(277) + .900_r8*rxt(212)*y(5)
         mat(86) = .700_r8*rxt(216)*y(6)
         mat(311) = rxt(135)*y(12)
         mat(191) = mat(191) + .900_r8*rxt(219)*y(5)
         mat(223) = mat(223) + .900_r8*rxt(222)*y(5)
         mat(257) = .500_r8*rxt(184)*y(12)
         mat(481) = mat(481) + .794_r8*rxt(194)*y(5) + .794_r8*rxt(195)*y(7) &
                      + .794_r8*rxt(196)*y(13)
         mat(460) = rxt(199)*y(7) + rxt(198)*y(12)
         mat(105) = .500_r8*rxt(236)*y(12)
         mat(82) = .350_r8*rxt(112)*y(12)
         mat(151) = rxt(108)*y(12)
         mat(202) = mat(202) + rxt(110)*y(5)


      end subroutine nlnmat02

      subroutine nlnmat03( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(106) = -(rxt(70)*y(12) + rxt(75)*y(2))
         mat(688) = -rxt(70)*y(14)
         mat(536) = -rxt(75)*y(14)

         mat(688) = mat(688) + 2.000_r8*rxt(68)*y(12)
         mat(853) = 2.000_r8*rxt(74)*y(13)

         mat(987) = -(rxt(102)*y(5) + rxt(103)*y(13) + (4._r8*rxt(104) + 4._r8*rxt(105) &
                      ) * y(18) + rxt(123)*y(30) + rxt(131)*y(33) + rxt(144)*y(37) &
                      + rxt(153)*y(42) + rxt(173)*y(57) + rxt(179)*y(59) + rxt(192) &
                      *y(53) + rxt(207)*y(63))
         mat(954) = -rxt(102)*y(18)
         mat(910) = -rxt(103)*y(18)
         mat(372) = -rxt(123)*y(18)
         mat(815) = -rxt(131)*y(18)
         mat(390) = -rxt(144)*y(18)
         mat(494) = -rxt(153)*y(18)
         mat(583) = -rxt(173)*y(18)
         mat(647) = -rxt(179)*y(18)
         mat(604) = -rxt(192)*y(18)
         mat(534) = -rxt(207)*y(18)

         mat(848) = .310_r8*rxt(140)*y(35)
         mat(954) = mat(954) + rxt(128)*y(33)
         mat(756) = .700_r8*rxt(107)*y(19) + rxt(120)*y(26)
         mat(987) = mat(987) + .900_r8*rxt(131)*y(33)
         mat(148) = .700_r8*rxt(107)*y(12)
         mat(211) = rxt(120)*y(12)
         mat(815) = mat(815) + rxt(128)*y(5) + .900_r8*rxt(131)*y(18) &
                      + 4.000_r8*rxt(132)*y(33) + rxt(193)*y(53) + rxt(174)*y(57) &
                      + rxt(180)*y(59) + rxt(208)*y(63)
         mat(440) = .310_r8*rxt(140)*y(1)
         mat(604) = mat(604) + rxt(193)*y(33)
         mat(583) = mat(583) + rxt(174)*y(33)
         mat(647) = mat(647) + rxt(180)*y(33)
         mat(534) = mat(534) + rxt(208)*y(33)

         mat(144) = -(rxt(107)*y(12))
         mat(694) = -rxt(107)*y(19)

         mat(859) = rxt(103)*y(18)
         mat(956) = rxt(103)*y(13)

         mat(611) = -(rxt(98)*y(7) + rxt(99)*y(12) + rxt(100)*y(2) + rxt(101)*y(13))
         mat(781) = -rxt(98)*y(20)
         mat(746) = -rxt(99)*y(20)
         mat(541) = -rxt(100)*y(20)
         mat(900) = -rxt(101)*y(20)

         mat(838) = rxt(119)*y(23) + .540_r8*rxt(140)*y(35) + .600_r8*rxt(186)*y(52) &
                      + .800_r8*rxt(162)*y(55) + .700_r8*rxt(168)*y(56)
         mat(944) = rxt(102)*y(18) + .500_r8*rxt(115)*y(25) + rxt(147)*y(39) &
                      + rxt(151)*y(42) + .500_r8*rxt(160)*y(45) + .100_r8*rxt(201) &
                      *y(50) + .510_r8*rxt(188)*y(53) + .250_r8*rxt(169)*y(57) &
                      + rxt(176)*y(59) + .072_r8*rxt(194)*y(84)
         mat(781) = mat(781) + .600_r8*rxt(189)*y(53) + .250_r8*rxt(171)*y(57) &
                      + rxt(177)*y(59) + .072_r8*rxt(195)*y(84)
         mat(746) = mat(746) + .300_r8*rxt(107)*y(19) + rxt(106)*y(21) &
                      + .800_r8*rxt(134)*y(27) + .500_r8*rxt(133)*y(34) + rxt(138) &
                      *y(81) + .500_r8*rxt(184)*y(83)
         mat(900) = mat(900) + .008_r8*rxt(196)*y(84)
         mat(977) = rxt(102)*y(5) + (4.000_r8*rxt(104)+2.000_r8*rxt(105))*y(18) &
                      + .700_r8*rxt(123)*y(30) + rxt(131)*y(33) + rxt(144)*y(37) &
                      + .800_r8*rxt(153)*y(42) + 1.200_r8*rxt(192)*y(53) &
                      + .880_r8*rxt(173)*y(57) + 2.000_r8*rxt(179)*y(59) &
                      + .700_r8*rxt(207)*y(63)
         mat(146) = .300_r8*rxt(107)*y(12)
         mat(267) = rxt(106)*y(12)
         mat(155) = rxt(119)*y(1)
         mat(303) = .500_r8*rxt(115)*y(5)
         mat(375) = .800_r8*rxt(134)*y(12)
         mat(367) = .700_r8*rxt(123)*y(18)
         mat(805) = rxt(131)*y(18) + .600_r8*rxt(193)*y(53) + .250_r8*rxt(174)*y(57) &
                      + rxt(180)*y(59)
         mat(213) = .500_r8*rxt(133)*y(12)
         mat(432) = .540_r8*rxt(140)*y(1)
         mat(384) = rxt(144)*y(18)
         mat(340) = rxt(147)*y(5)
         mat(488) = rxt(151)*y(5) + .800_r8*rxt(153)*y(18)
         mat(173) = .500_r8*rxt(160)*y(5)
         mat(355) = .100_r8*rxt(201)*y(5)
         mat(398) = .600_r8*rxt(186)*y(1)
         mat(594) = .510_r8*rxt(188)*y(5) + .600_r8*rxt(189)*y(7) + 1.200_r8*rxt(192) &
                      *y(18) + .600_r8*rxt(193)*y(33)
         mat(556) = .800_r8*rxt(162)*y(1)
         mat(504) = .700_r8*rxt(168)*y(1)
         mat(574) = .250_r8*rxt(169)*y(5) + .250_r8*rxt(171)*y(7) + .880_r8*rxt(173) &
                      *y(18) + .250_r8*rxt(174)*y(33)
         mat(637) = rxt(176)*y(5) + rxt(177)*y(7) + 2.000_r8*rxt(179)*y(18) + rxt(180) &
                      *y(33) + 4.000_r8*rxt(181)*y(59)
         mat(526) = .700_r8*rxt(207)*y(18)
         mat(226) = rxt(138)*y(12)
         mat(252) = .500_r8*rxt(184)*y(12)
         mat(476) = .072_r8*rxt(194)*y(5) + .072_r8*rxt(195)*y(7) + .008_r8*rxt(196) &
                      *y(13)

         mat(266) = -(rxt(106)*y(12))
         mat(714) = -rxt(106)*y(21)

         mat(959) = 2.000_r8*rxt(105)*y(18) + .300_r8*rxt(123)*y(30) &
                      + .500_r8*rxt(153)*y(42) + .250_r8*rxt(192)*y(53) &
                      + .250_r8*rxt(173)*y(57) + .300_r8*rxt(207)*y(63)
         mat(364) = .300_r8*rxt(123)*y(18)
         mat(484) = .500_r8*rxt(153)*y(18)
         mat(586) = .250_r8*rxt(192)*y(18)
         mat(567) = .250_r8*rxt(173)*y(18)
         mat(520) = .300_r8*rxt(207)*y(18)

         mat(110) = -(rxt(136)*y(12))
         mat(689) = -rxt(136)*y(22)

         mat(955) = .200_r8*rxt(123)*y(30)
         mat(362) = .200_r8*rxt(123)*y(18) + .800_r8*rxt(124)*y(30)


         mat(851) = rxt(116)*y(25)
         mat(299) = rxt(116)*y(13)

         mat(153) = -(rxt(114)*y(12) + rxt(119)*y(1))
         mat(696) = -rxt(114)*y(23)
         mat(817) = -rxt(119)*y(23)


         mat(911) = .750_r8*rxt(115)*y(25)
         mat(300) = .750_r8*rxt(115)*y(5)

         mat(301) = -(rxt(115)*y(5) + rxt(116)*y(13))
         mat(922) = -rxt(115)*y(25)
         mat(875) = -rxt(116)*y(25)

         mat(719) = rxt(114)*y(23)
         mat(154) = rxt(114)*y(12)

         mat(209) = -(rxt(120)*y(12))
         mat(705) = -rxt(120)*y(26)

         mat(818) = .250_r8*rxt(140)*y(35) + .200_r8*rxt(186)*y(52)
         mat(866) = .250_r8*rxt(130)*y(33) + .250_r8*rxt(178)*y(59)
         mat(958) = .100_r8*rxt(131)*y(33)
         mat(793) = .250_r8*rxt(130)*y(13) + .100_r8*rxt(131)*y(18)
         mat(426) = .250_r8*rxt(140)*y(1)
         mat(391) = .200_r8*rxt(186)*y(1)
         mat(632) = .250_r8*rxt(178)*y(13)

         mat(374) = -(rxt(134)*y(12))
         mat(727) = -rxt(134)*y(27)

         mat(929) = .530_r8*rxt(169)*y(57) + .250_r8*rxt(204)*y(63)
         mat(765) = .530_r8*rxt(171)*y(57) + .250_r8*rxt(205)*y(63)
         mat(963) = .260_r8*rxt(173)*y(57) + .100_r8*rxt(207)*y(63)
         mat(797) = .530_r8*rxt(174)*y(57) + .250_r8*rxt(208)*y(63)
         mat(568) = .530_r8*rxt(169)*y(5) + .530_r8*rxt(171)*y(7) + .260_r8*rxt(173) &
                      *y(18) + .530_r8*rxt(174)*y(33)
         mat(522) = .250_r8*rxt(204)*y(5) + .250_r8*rxt(205)*y(7) + .100_r8*rxt(207) &
                      *y(18) + .250_r8*rxt(208)*y(33)

         mat(57) = -(rxt(113)*y(12))
         mat(677) = -rxt(113)*y(29)

         mat(365) = -(rxt(121)*y(5) + rxt(122)*y(13) + rxt(123)*y(18) + 4._r8*rxt(124) &
                      *y(30))
         mat(928) = -rxt(121)*y(30)
         mat(882) = -rxt(122)*y(30)
         mat(962) = -rxt(123)*y(30)

         mat(726) = rxt(113)*y(29) + .500_r8*rxt(125)*y(31)
         mat(58) = rxt(113)*y(12)
         mat(166) = .500_r8*rxt(125)*y(12)

         mat(165) = -(rxt(125)*y(12))
         mat(698) = -rxt(125)*y(31)

         mat(862) = rxt(122)*y(30)
         mat(363) = rxt(122)*y(13)

         mat(462) = -(rxt(126)*y(12) + rxt(127)*y(7))
         mat(735) = -rxt(126)*y(32)
         mat(770) = -rxt(127)*y(32)

         mat(827) = .500_r8*rxt(140)*y(35) + .040_r8*rxt(162)*y(55)
         mat(933) = rxt(121)*y(30) + .270_r8*rxt(142)*y(37) + rxt(147)*y(39) &
                      + rxt(160)*y(45) + .400_r8*rxt(201)*y(50) + rxt(164)*y(47)
         mat(735) = mat(735) + rxt(136)*y(22) + .500_r8*rxt(125)*y(31)
         mat(967) = .800_r8*rxt(123)*y(30)
         mat(111) = rxt(136)*y(12)
         mat(366) = rxt(121)*y(5) + .800_r8*rxt(123)*y(18) + 3.200_r8*rxt(124)*y(30)
         mat(167) = .500_r8*rxt(125)*y(12)
         mat(429) = .500_r8*rxt(140)*y(1)
         mat(382) = .270_r8*rxt(142)*y(5)
         mat(338) = rxt(147)*y(5)
         mat(172) = rxt(160)*y(5)
         mat(352) = .400_r8*rxt(201)*y(5)
         mat(325) = rxt(164)*y(5)
         mat(551) = .040_r8*rxt(162)*y(1)

         mat(811) = -(rxt(128)*y(5) + rxt(129)*y(6) + rxt(130)*y(13) + rxt(131)*y(18) &
                      + 4._r8*rxt(132)*y(33) + rxt(174)*y(57) + rxt(193)*y(53) + rxt(208) &
                      *y(63))
         mat(950) = -rxt(128)*y(33)
         mat(665) = -rxt(129)*y(33)
         mat(906) = -rxt(130)*y(33)
         mat(983) = -rxt(131)*y(33)
         mat(580) = -rxt(174)*y(33)
         mat(600) = -rxt(193)*y(33)
         mat(531) = -rxt(208)*y(33)

         mat(950) = mat(950) + rxt(151)*y(42) + rxt(164)*y(47) + .530_r8*rxt(169) &
                      *y(57) + rxt(176)*y(59)
         mat(787) = rxt(127)*y(32) + .530_r8*rxt(171)*y(57) + rxt(177)*y(59) &
                      + rxt(157)*y(62)
         mat(752) = rxt(126)*y(32) + .500_r8*rxt(133)*y(34) + rxt(156)*y(62)
         mat(983) = mat(983) + .300_r8*rxt(153)*y(42) + .260_r8*rxt(173)*y(57) &
                      + rxt(179)*y(59)
         mat(467) = rxt(127)*y(7) + rxt(126)*y(12)
         mat(811) = mat(811) + .530_r8*rxt(174)*y(57)
         mat(215) = .500_r8*rxt(133)*y(12)
         mat(491) = rxt(151)*y(5) + .300_r8*rxt(153)*y(18)
         mat(328) = rxt(164)*y(5)
         mat(580) = mat(580) + .530_r8*rxt(169)*y(5) + .530_r8*rxt(171)*y(7) &
                      + .260_r8*rxt(173)*y(18) + .530_r8*rxt(174)*y(33)
         mat(643) = rxt(176)*y(5) + rxt(177)*y(7) + rxt(179)*y(18) + 4.000_r8*rxt(181) &
                      *y(59)
         mat(517) = rxt(157)*y(7) + rxt(156)*y(12)

         mat(212) = -(rxt(133)*y(12))
         mat(706) = -rxt(133)*y(34)

         mat(867) = .750_r8*rxt(130)*y(33) + .750_r8*rxt(178)*y(59)
         mat(794) = .750_r8*rxt(130)*y(13)
         mat(633) = .750_r8*rxt(178)*y(13)

         mat(428) = -(rxt(139)*y(12) + rxt(140)*y(1) + rxt(141)*y(7))
         mat(732) = -rxt(139)*y(35)
         mat(825) = -rxt(140)*y(35)
         mat(768) = -rxt(141)*y(35)

         mat(825) = mat(825) + .070_r8*rxt(186)*y(52)
         mat(393) = .070_r8*rxt(186)*y(1)


      end subroutine nlnmat03

      subroutine nlnmat04( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(60) = -(rxt(146)*y(12))
         mat(678) = -rxt(146)*y(36)

         mat(381) = -(rxt(142)*y(5) + rxt(143)*y(13) + rxt(144)*y(18))
         mat(930) = -rxt(142)*y(37)
         mat(884) = -rxt(143)*y(37)
         mat(964) = -rxt(144)*y(37)

         mat(728) = rxt(146)*y(36) + rxt(145)*y(38)
         mat(61) = rxt(146)*y(12)
         mat(131) = rxt(145)*y(12)

         mat(129) = -(rxt(145)*y(12))
         mat(691) = -rxt(145)*y(38)

         mat(856) = rxt(143)*y(37)
         mat(379) = rxt(143)*y(13)

         mat(337) = -(rxt(147)*y(5) + rxt(148)*y(13))
         mat(926) = -rxt(147)*y(39)
         mat(880) = -rxt(148)*y(39)

         mat(724) = rxt(139)*y(35) + .500_r8*rxt(149)*y(40)
         mat(427) = rxt(139)*y(12)
         mat(244) = .500_r8*rxt(149)*y(12)

         mat(243) = -(rxt(149)*y(12))
         mat(711) = -rxt(149)*y(40)

         mat(870) = rxt(148)*y(39)
         mat(336) = rxt(148)*y(13)

         mat(331) = -(rxt(150)*y(12))
         mat(723) = -rxt(150)*y(41)

         mat(925) = .820_r8*rxt(142)*y(37) + .500_r8*rxt(160)*y(45) + .250_r8*rxt(201) &
                      *y(50) + .100_r8*rxt(226)*y(66)
         mat(961) = .820_r8*rxt(144)*y(37)
         mat(380) = .820_r8*rxt(142)*y(5) + .820_r8*rxt(144)*y(18)
         mat(171) = .500_r8*rxt(160)*y(5)
         mat(349) = .250_r8*rxt(201)*y(5)
         mat(414) = .100_r8*rxt(226)*y(5)

         mat(485) = -(rxt(151)*y(5) + rxt(152)*y(13) + rxt(153)*y(18))
         mat(935) = -rxt(151)*y(42)
         mat(891) = -rxt(152)*y(42)
         mat(968) = -rxt(153)*y(42)

         mat(737) = rxt(150)*y(41) + rxt(154)*y(43)
         mat(332) = rxt(150)*y(12)
         mat(135) = rxt(154)*y(12)

         mat(134) = -(rxt(154)*y(12))
         mat(692) = -rxt(154)*y(43)

         mat(857) = rxt(152)*y(42)
         mat(483) = rxt(152)*y(13)

         mat(42) = -(rxt(159)*y(12))
         mat(672) = -rxt(159)*y(44)

         mat(170) = -(rxt(160)*y(5))
         mat(913) = -rxt(160)*y(45)

         mat(699) = rxt(159)*y(44)
         mat(43) = rxt(159)*y(12)

         mat(45) = -(rxt(197)*y(12))
         mat(673) = -rxt(197)*y(49)

         mat(350) = -(rxt(201)*y(5) + rxt(202)*y(13))
         mat(927) = -rxt(201)*y(50)
         mat(881) = -rxt(202)*y(50)

         mat(725) = rxt(197)*y(49) + rxt(203)*y(51)
         mat(46) = rxt(197)*y(12)
         mat(316) = rxt(203)*y(12)

         mat(313) = -(rxt(203)*y(12))
         mat(721) = -rxt(203)*y(51)

         mat(877) = rxt(202)*y(50)
         mat(347) = rxt(202)*y(13)

         mat(204) = -(rxt(163)*y(12))
         mat(704) = -rxt(163)*y(46)

         mat(918) = .800_r8*rxt(201)*y(50)
         mat(346) = .800_r8*rxt(201)*y(5)

         mat(324) = -(rxt(164)*y(5) + rxt(165)*y(13))
         mat(924) = -rxt(164)*y(47)
         mat(878) = -rxt(165)*y(47)

         mat(722) = rxt(163)*y(46) + rxt(166)*y(48)
         mat(205) = rxt(163)*y(12)
         mat(125) = rxt(166)*y(12)

         mat(124) = -(rxt(166)*y(12))
         mat(690) = -rxt(166)*y(48)

         mat(855) = rxt(165)*y(47)
         mat(323) = rxt(165)*y(13)

         mat(392) = -(rxt(185)*y(12) + rxt(186)*y(1) + rxt(187)*y(7))
         mat(729) = -rxt(185)*y(52)
         mat(822) = -rxt(186)*y(52)
         mat(766) = -rxt(187)*y(52)

         mat(593) = -(rxt(188)*y(5) + rxt(189)*y(7) + rxt(190)*y(13) + rxt(192)*y(18) &
                      + rxt(193)*y(33))
         mat(943) = -rxt(188)*y(53)
         mat(780) = -rxt(189)*y(53)
         mat(899) = -rxt(190)*y(53)
         mat(976) = -rxt(192)*y(53)
         mat(804) = -rxt(193)*y(53)

         mat(745) = rxt(185)*y(52) + .200_r8*rxt(191)*y(54)
         mat(397) = rxt(185)*y(12)
         mat(262) = .200_r8*rxt(191)*y(12)

         mat(258) = -(rxt(191)*y(12))
         mat(713) = -rxt(191)*y(54)

         mat(871) = rxt(190)*y(53)
         mat(585) = rxt(190)*y(13)

         mat(554) = -(rxt(161)*y(12) + rxt(162)*y(1))
         mat(743) = -rxt(161)*y(55)
         mat(835) = -rxt(162)*y(55)

         mat(835) = mat(835) + .200_r8*rxt(186)*y(52) + rxt(224)*y(65)
         mat(941) = .320_r8*rxt(188)*y(53) + rxt(226)*y(66) + .039_r8*rxt(194)*y(84)
         mat(778) = .350_r8*rxt(189)*y(53) + .039_r8*rxt(195)*y(84)
         mat(897) = .039_r8*rxt(196)*y(84)
         mat(974) = .260_r8*rxt(192)*y(53)
         mat(802) = .350_r8*rxt(193)*y(53)
         mat(396) = .200_r8*rxt(186)*y(1)
         mat(591) = .320_r8*rxt(188)*y(5) + .350_r8*rxt(189)*y(7) + .260_r8*rxt(192) &
                      *y(18) + .350_r8*rxt(193)*y(33)
         mat(293) = rxt(224)*y(1)
         mat(418) = rxt(226)*y(5)
         mat(475) = .039_r8*rxt(194)*y(5) + .039_r8*rxt(195)*y(7) + .039_r8*rxt(196) &
                      *y(13)

         mat(501) = -(rxt(167)*y(12) + rxt(168)*y(1))
         mat(739) = -rxt(167)*y(56)
         mat(831) = -rxt(168)*y(56)

         mat(831) = mat(831) + .400_r8*rxt(186)*y(52) + rxt(224)*y(65)
         mat(937) = .230_r8*rxt(188)*y(53) + rxt(226)*y(66) + .167_r8*rxt(194)*y(84)
         mat(774) = .250_r8*rxt(189)*y(53) + .167_r8*rxt(195)*y(84)
         mat(893) = .167_r8*rxt(196)*y(84)
         mat(970) = .190_r8*rxt(192)*y(53)
         mat(799) = .250_r8*rxt(193)*y(53)
         mat(395) = .400_r8*rxt(186)*y(1)
         mat(588) = .230_r8*rxt(188)*y(5) + .250_r8*rxt(189)*y(7) + .190_r8*rxt(192) &
                      *y(18) + .250_r8*rxt(193)*y(33)
         mat(292) = rxt(224)*y(1)
         mat(417) = rxt(226)*y(5)
         mat(473) = .167_r8*rxt(194)*y(5) + .167_r8*rxt(195)*y(7) + .167_r8*rxt(196) &
                      *y(13)

         mat(573) = -((rxt(169) + rxt(170)) * y(5) + rxt(171)*y(7) + rxt(172)*y(13) &
                      + rxt(173)*y(18) + rxt(174)*y(33))
         mat(942) = -(rxt(169) + rxt(170)) * y(57)
         mat(779) = -rxt(171)*y(57)
         mat(898) = -rxt(172)*y(57)
         mat(975) = -rxt(173)*y(57)
         mat(803) = -rxt(174)*y(57)

         mat(744) = rxt(161)*y(55) + .500_r8*rxt(167)*y(56) + .200_r8*rxt(175)*y(58)
         mat(555) = rxt(161)*y(12)
         mat(503) = .500_r8*rxt(167)*y(12)
         mat(161) = .200_r8*rxt(175)*y(12)

         mat(160) = -(rxt(175)*y(12))
         mat(697) = -rxt(175)*y(58)

         mat(861) = rxt(172)*y(57)
         mat(566) = rxt(172)*y(13)

         mat(639) = -(rxt(176)*y(5) + rxt(177)*y(7) + rxt(178)*y(13) + rxt(179)*y(18) &
                      + rxt(180)*y(33) + 4._r8*rxt(181)*y(59) + rxt(182)*y(6))
         mat(946) = -rxt(176)*y(59)
         mat(783) = -rxt(177)*y(59)
         mat(902) = -rxt(178)*y(59)
         mat(979) = -rxt(179)*y(59)
         mat(807) = -rxt(180)*y(59)
         mat(661) = -rxt(182)*y(59)

         mat(840) = .200_r8*rxt(186)*y(52)
         mat(748) = .500_r8*rxt(167)*y(56) + .500_r8*rxt(175)*y(58)
         mat(400) = .200_r8*rxt(186)*y(1)
         mat(506) = .500_r8*rxt(167)*y(12)
         mat(162) = .500_r8*rxt(175)*y(12)

         mat(177) = -(rxt(200)*y(12))
         mat(700) = -rxt(200)*y(60)

         mat(914) = .370_r8*rxt(188)*y(53)
         mat(760) = .400_r8*rxt(189)*y(53) + rxt(199)*y(85)
         mat(700) = mat(700) + rxt(198)*y(85)
         mat(957) = .300_r8*rxt(192)*y(53)
         mat(792) = .400_r8*rxt(193)*y(53)
         mat(584) = .370_r8*rxt(188)*y(5) + .400_r8*rxt(189)*y(7) + .300_r8*rxt(192) &
                      *y(18) + .400_r8*rxt(193)*y(33)
         mat(452) = rxt(199)*y(7) + rxt(198)*y(12)

         mat(495) = -(rxt(155)*y(12))
         mat(738) = -rxt(155)*y(61)

         mat(936) = .220_r8*rxt(169)*y(57) + .250_r8*rxt(204)*y(63)
         mat(773) = .220_r8*rxt(171)*y(57) + .250_r8*rxt(205)*y(63)
         mat(738) = mat(738) + .500_r8*rxt(149)*y(40) + .500_r8*rxt(184)*y(83)
         mat(969) = .200_r8*rxt(153)*y(42) + .230_r8*rxt(173)*y(57) + .100_r8*rxt(207) &
                      *y(63)
         mat(798) = .220_r8*rxt(174)*y(57) + .250_r8*rxt(208)*y(63)
         mat(246) = .500_r8*rxt(149)*y(12)
         mat(486) = .200_r8*rxt(153)*y(18)
         mat(570) = .220_r8*rxt(169)*y(5) + .220_r8*rxt(171)*y(7) + .230_r8*rxt(173) &
                      *y(18) + .220_r8*rxt(174)*y(33)
         mat(523) = .250_r8*rxt(204)*y(5) + .250_r8*rxt(205)*y(7) + .100_r8*rxt(207) &
                      *y(18) + .250_r8*rxt(208)*y(33)
         mat(251) = .500_r8*rxt(184)*y(12)

         mat(512) = -(rxt(156)*y(12) + rxt(157)*y(7))
         mat(740) = -rxt(156)*y(62)
         mat(775) = -rxt(157)*y(62)

         mat(832) = .950_r8*rxt(162)*y(55) + .800_r8*rxt(168)*y(56)
         mat(938) = .250_r8*rxt(169)*y(57) + .250_r8*rxt(204)*y(63) + .450_r8*rxt(212) &
                      *y(70) + .540_r8*rxt(222)*y(76)
         mat(775) = mat(775) + .250_r8*rxt(171)*y(57) + .250_r8*rxt(205)*y(63)
         mat(740) = mat(740) + rxt(155)*y(61) + rxt(158)*y(82)
         mat(971) = .500_r8*rxt(153)*y(42) + .240_r8*rxt(173)*y(57) + .100_r8*rxt(207) &
                      *y(63)
         mat(800) = .250_r8*rxt(174)*y(57) + .250_r8*rxt(208)*y(63)
         mat(487) = .500_r8*rxt(153)*y(18)
         mat(553) = .950_r8*rxt(162)*y(1)
         mat(502) = .800_r8*rxt(168)*y(1)
         mat(571) = .250_r8*rxt(169)*y(5) + .250_r8*rxt(171)*y(7) + .240_r8*rxt(173) &
                      *y(18) + .250_r8*rxt(174)*y(33)
         mat(496) = rxt(155)*y(12)
         mat(524) = .250_r8*rxt(204)*y(5) + .250_r8*rxt(205)*y(7) + .100_r8*rxt(207) &
                      *y(18) + .250_r8*rxt(208)*y(33)
         mat(274) = .450_r8*rxt(212)*y(5)
         mat(221) = .540_r8*rxt(222)*y(5)
         mat(194) = rxt(158)*y(12)

         mat(525) = -(rxt(204)*y(5) + rxt(205)*y(7) + rxt(206)*y(13) + rxt(207)*y(18) &
                      + rxt(208)*y(33))
         mat(939) = -rxt(204)*y(63)
         mat(776) = -rxt(205)*y(63)
         mat(895) = -rxt(206)*y(63)
         mat(972) = -rxt(207)*y(63)
         mat(801) = -rxt(208)*y(63)

         mat(741) = .800_r8*rxt(191)*y(54) + rxt(200)*y(60) + rxt(209)*y(64)
         mat(260) = .800_r8*rxt(191)*y(12)
         mat(178) = rxt(200)*y(12)
         mat(92) = rxt(209)*y(12)


      end subroutine nlnmat04

      subroutine nlnmat05( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(91) = -((rxt(209) + rxt(210)) * y(12))
         mat(685) = -(rxt(209) + rxt(210)) * y(64)

         mat(852) = rxt(206)*y(63) + rxt(196)*y(84)
         mat(519) = rxt(206)*y(13)
         mat(470) = rxt(196)*y(13)

         mat(290) = -(rxt(223)*y(12) + rxt(224)*y(1) + rxt(225)*y(7))
         mat(718) = -rxt(223)*y(65)
         mat(819) = -rxt(224)*y(65)
         mat(763) = -rxt(225)*y(65)

         mat(415) = -(rxt(226)*y(5) + rxt(227)*y(13))
         mat(931) = -rxt(226)*y(66)
         mat(886) = -rxt(227)*y(66)

         mat(767) = rxt(225)*y(65)
         mat(731) = rxt(223)*y(65) + rxt(228)*y(67)
         mat(291) = rxt(225)*y(7) + rxt(223)*y(12)
         mat(238) = rxt(228)*y(12)

         mat(236) = -(rxt(228)*y(12))
         mat(710) = -rxt(228)*y(67)

         mat(869) = rxt(227)*y(66)
         mat(413) = rxt(227)*y(13)

         mat(63) = -(rxt(211)*y(12))
         mat(679) = -rxt(211)*y(68)

         mat(68) = -(rxt(215)*y(12))
         mat(680) = -rxt(215)*y(69)

         mat(680) = mat(680) + .250_r8*rxt(211)*y(68)
         mat(64) = .250_r8*rxt(211)*y(12)

         mat(271) = -(rxt(212)*y(5) + rxt(213)*y(13))
         mat(920) = -rxt(212)*y(70)
         mat(872) = -rxt(213)*y(70)

         mat(715) = .700_r8*rxt(211)*y(68) + rxt(214)*y(71)
         mat(65) = .700_r8*rxt(211)*y(12)
         mat(181) = rxt(214)*y(12)

         mat(180) = -(rxt(214)*y(12))
         mat(701) = -rxt(214)*y(71)

         mat(863) = rxt(213)*y(70)
         mat(270) = rxt(213)*y(13)

         mat(83) = -(rxt(216)*y(6))
         mat(648) = -rxt(216)*y(78)

         mat(683) = rxt(215)*y(69)
         mat(69) = rxt(215)*y(12)


         mat(921) = .900_r8*rxt(212)*y(70) + .900_r8*rxt(219)*y(73) + .620_r8*rxt(222) &
                      *y(76)
         mat(654) = .700_r8*rxt(216)*y(78)
         mat(272) = .900_r8*rxt(212)*y(5)
         mat(84) = .700_r8*rxt(216)*y(6)
         mat(188) = .900_r8*rxt(219)*y(5)
         mat(219) = .620_r8*rxt(222)*y(5)

         mat(308) = -(rxt(135)*y(12))
         mat(720) = -rxt(135)*y(80)

         mat(923) = .250_r8*rxt(204)*y(63) + .450_r8*rxt(212)*y(70) + .900_r8*rxt(219) &
                      *y(73) + .340_r8*rxt(222)*y(76)
         mat(764) = .250_r8*rxt(205)*y(63)
         mat(720) = mat(720) + .200_r8*rxt(134)*y(27) + .650_r8*rxt(112)*y(119)
         mat(960) = .100_r8*rxt(207)*y(63)
         mat(373) = .200_r8*rxt(134)*y(12)
         mat(796) = .250_r8*rxt(208)*y(63)
         mat(521) = .250_r8*rxt(204)*y(5) + .250_r8*rxt(205)*y(7) + .100_r8*rxt(207) &
                      *y(18) + .250_r8*rxt(208)*y(33)
         mat(273) = .450_r8*rxt(212)*y(5)
         mat(189) = .900_r8*rxt(219)*y(5)
         mat(220) = .340_r8*rxt(222)*y(5)
         mat(79) = .650_r8*rxt(112)*y(12)

         mat(48) = -(rxt(217)*y(12))
         mat(674) = -rxt(217)*y(72)

         mat(187) = -(rxt(218)*y(13) + rxt(219)*y(5))
         mat(864) = -rxt(218)*y(73)
         mat(915) = -rxt(219)*y(73)

         mat(702) = rxt(217)*y(72)
         mat(49) = rxt(217)*y(12)


         mat(849) = rxt(218)*y(73)
         mat(186) = rxt(218)*y(13)

         mat(51) = -(rxt(220)*y(12))
         mat(675) = -rxt(220)*y(75)

         mat(218) = -(rxt(221)*y(13) + rxt(222)*y(5))
         mat(868) = -rxt(221)*y(76)
         mat(919) = -rxt(222)*y(76)

         mat(707) = rxt(220)*y(75)
         mat(52) = rxt(220)*y(12)


         mat(850) = rxt(221)*y(76)
         mat(217) = rxt(221)*y(13)

         mat(225) = -(rxt(138)*y(12))
         mat(708) = -rxt(138)*y(81)

         mat(651) = rxt(129)*y(33)
         mat(795) = rxt(129)*y(6)

         mat(193) = -(rxt(158)*y(12))
         mat(703) = -rxt(158)*y(82)

         mat(916) = .100_r8*rxt(201)*y(50)
         mat(761) = rxt(141)*y(35)
         mat(425) = rxt(141)*y(7)
         mat(345) = .100_r8*rxt(201)*y(5)

         mat(250) = -(rxt(184)*y(12))
         mat(712) = -rxt(184)*y(83)

         mat(653) = rxt(182)*y(59)
         mat(634) = rxt(182)*y(6)

         mat(472) = -(rxt(194)*y(5) + rxt(195)*y(7) + rxt(196)*y(13))
         mat(934) = -rxt(194)*y(84)
         mat(771) = -rxt(195)*y(84)
         mat(890) = -rxt(196)*y(84)

         mat(771) = mat(771) + rxt(187)*y(52)
         mat(394) = rxt(187)*y(7)

         mat(453) = -(rxt(198)*y(12) + rxt(199)*y(7))
         mat(734) = -rxt(198)*y(85)
         mat(769) = -rxt(199)*y(85)

         mat(932) = .080_r8*rxt(188)*y(53) + .800_r8*rxt(170)*y(57) + .794_r8*rxt(194) &
                      *y(84)
         mat(769) = mat(769) + .794_r8*rxt(195)*y(84)
         mat(888) = .794_r8*rxt(196)*y(84)
         mat(587) = .080_r8*rxt(188)*y(5)
         mat(569) = .800_r8*rxt(170)*y(5)
         mat(471) = .794_r8*rxt(194)*y(5) + .794_r8*rxt(195)*y(7) + .794_r8*rxt(196) &
                      *y(13)

         mat(95) = -(rxt(241)*y(2) + rxt(242)*y(12))
         mat(535) = -rxt(241)*y(100)
         mat(686) = -rxt(242)*y(100)

         mat(72) = -(rxt(234)*y(12))
         mat(681) = -rxt(234)*y(101)

         mat(757) = rxt(237)*y(102)
         mat(681) = mat(681) + rxt(242)*y(100) + (rxt(235)+.500_r8*rxt(236))*y(102)
         mat(94) = rxt(242)*y(12)
         mat(100) = rxt(237)*y(7) + (rxt(235)+.500_r8*rxt(236))*y(12)

         mat(101) = -((rxt(235) + rxt(236)) * y(12) + rxt(237)*y(7))
         mat(687) = -(rxt(235) + rxt(236)) * y(102)
         mat(758) = -rxt(237)*y(102)


         mat(670) = rxt(234)*y(101)
         mat(71) = rxt(234)*y(12)

         mat(40) = -(rxt(238)*y(12))
         mat(671) = -rxt(238)*y(104)
         mat(77) = -(rxt(112)*y(12))
         mat(682) = -rxt(112)*y(119)
         mat(149) = -(rxt(108)*y(12))
         mat(695) = -rxt(108)*y(120)
         mat(816) = .500_r8*rxt(119)*y(23)
         mat(912) = rxt(110)*y(121)
         mat(695) = mat(695) + .350_r8*rxt(112)*y(119)
         mat(860) = rxt(111)*y(121)
         mat(152) = .500_r8*rxt(119)*y(1)
         mat(78) = .350_r8*rxt(112)*y(12)
         mat(197) = rxt(110)*y(5) + rxt(111)*y(13)
         mat(198) = -(rxt(110)*y(5) + rxt(111)*y(13))
         mat(917) = -rxt(110)*y(121)
         mat(865) = -rxt(111)*y(121)
         mat(865) = mat(865) + rxt(101)*y(20)
         mat(605) = rxt(101)*y(13)
      end subroutine nlnmat05
      subroutine nlnmat_finit( mat, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(inout) :: mat(nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
         mat( 1) = lmat( 1)
         mat( 2) = lmat( 2)
         mat( 3) = lmat( 3)
         mat( 4) = lmat( 4)
         mat( 5) = lmat( 5)
         mat( 6) = lmat( 6)
         mat( 7) = lmat( 7)
         mat( 8) = lmat( 8)
         mat( 9) = lmat( 9)
         mat( 10) = lmat( 10)
         mat( 11) = lmat( 11)
         mat( 12) = lmat( 12)
         mat( 13) = lmat( 13)
         mat( 14) = lmat( 14)
         mat( 15) = lmat( 15)
         mat( 16) = lmat( 16)
         mat( 17) = lmat( 17)
         mat( 18) = lmat( 18)
         mat( 19) = lmat( 19)
         mat( 20) = lmat( 20)
         mat( 21) = lmat( 21)
         mat( 22) = lmat( 22)
         mat( 23) = lmat( 23)
         mat( 24) = lmat( 24)
         mat( 25) = lmat( 25)
         mat( 26) = lmat( 26)
         mat( 27) = lmat( 27)
         mat( 28) = lmat( 28)
         mat( 29) = lmat( 29)
         mat( 30) = lmat( 30)
         mat( 31) = lmat( 31)
         mat( 32) = lmat( 32)
         mat( 33) = lmat( 33)
         mat( 34) = lmat( 34)
         mat( 35) = lmat( 35)
         mat( 36) = lmat( 36)
         mat( 37) = lmat( 37)
         mat( 38) = lmat( 38)
         mat( 39) = lmat( 39)
         mat( 40) = mat( 40) + lmat( 40)
         mat( 42) = mat( 42) + lmat( 42)
         mat( 45) = mat( 45) + lmat( 45)
         mat( 48) = mat( 48) + lmat( 48)
         mat( 51) = mat( 51) + lmat( 51)
         mat( 54) = mat( 54) + lmat( 54)
         mat( 57) = mat( 57) + lmat( 57)
         mat( 60) = mat( 60) + lmat( 60)
         mat( 63) = mat( 63) + lmat( 63)
         mat( 68) = mat( 68) + lmat( 68)
         mat( 72) = mat( 72) + lmat( 72)
         mat( 74) = lmat( 74)
         mat( 75) = lmat( 75)
         mat( 76) = lmat( 76)
         mat( 77) = mat( 77) + lmat( 77)
         mat( 83) = mat( 83) + lmat( 83)
         mat( 87) = mat( 87) + lmat( 87)
         mat( 91) = mat( 91) + lmat( 91)
         mat( 93) = mat( 93) + lmat( 93)
         mat( 95) = mat( 95) + lmat( 95)
         mat( 98) = mat( 98) + lmat( 98)
         mat( 101) = mat( 101) + lmat( 101)
         mat( 106) = mat( 106) + lmat( 106)
         mat( 108) = mat( 108) + lmat( 108)
         mat( 110) = mat( 110) + lmat( 110)
         mat( 114) = lmat( 114)
         mat( 115) = lmat( 115)
         mat( 116) = lmat( 116)
         mat( 117) = lmat( 117)
         mat( 118) = lmat( 118)
         mat( 119) = lmat( 119)
         mat( 120) = lmat( 120)
         mat( 121) = lmat( 121)
         mat( 122) = lmat( 122)
         mat( 123) = lmat( 123)
         mat( 124) = mat( 124) + lmat( 124)
         mat( 126) = lmat( 126)
         mat( 127) = mat( 127) + lmat( 127)
         mat( 128) = lmat( 128)
         mat( 129) = mat( 129) + lmat( 129)
         mat( 130) = lmat( 130)
         mat( 132) = mat( 132) + lmat( 132)
         mat( 133) = lmat( 133)
         mat( 134) = mat( 134) + lmat( 134)
         mat( 136) = lmat( 136)
         mat( 137) = mat( 137) + lmat( 137)
         mat( 138) = lmat( 138)
         mat( 139) = mat( 139) + lmat( 139)
         mat( 140) = mat( 140) + lmat( 140)
         mat( 141) = mat( 141) + lmat( 141)
         mat( 142) = lmat( 142)
         mat( 143) = lmat( 143)
         mat( 144) = mat( 144) + lmat( 144)
         mat( 145) = lmat( 145)
         mat( 146) = mat( 146) + lmat( 146)
         mat( 147) = mat( 147) + lmat( 147)
         mat( 149) = mat( 149) + lmat( 149)
         mat( 153) = mat( 153) + lmat( 153)
         mat( 160) = mat( 160) + lmat( 160)
         mat( 165) = mat( 165) + lmat( 165)
         mat( 167) = mat( 167) + lmat( 167)
         mat( 168) = mat( 168) + lmat( 168)
         mat( 169) = lmat( 169)
         mat( 170) = mat( 170) + lmat( 170)
         mat( 177) = mat( 177) + lmat( 177)
         mat( 180) = mat( 180) + lmat( 180)
         mat( 182) = lmat( 182)
         mat( 183) = lmat( 183)
         mat( 184) = lmat( 184)
         mat( 185) = mat( 185) + lmat( 185)
         mat( 187) = mat( 187) + lmat( 187)
         mat( 193) = mat( 193) + lmat( 193)
         mat( 198) = mat( 198) + lmat( 198)
         mat( 199) = lmat( 199)
         mat( 202) = mat( 202) + lmat( 202)
         mat( 204) = mat( 204) + lmat( 204)
         mat( 206) = lmat( 206)
         mat( 208) = lmat( 208)
         mat( 209) = mat( 209) + lmat( 209)
         mat( 212) = mat( 212) + lmat( 212)
         mat( 214) = mat( 214) + lmat( 214)
         mat( 216) = lmat( 216)
         mat( 218) = mat( 218) + lmat( 218)
         mat( 225) = mat( 225) + lmat( 225)
         mat( 227) = lmat( 227)
         mat( 229) = mat( 229) + lmat( 229)
         mat( 230) = lmat( 230)
         mat( 231) = lmat( 231)
         mat( 232) = mat( 232) + lmat( 232)
         mat( 233) = lmat( 233)
         mat( 234) = mat( 234) + lmat( 234)
         mat( 236) = mat( 236) + lmat( 236)
         mat( 237) = lmat( 237)
         mat( 239) = lmat( 239)
         mat( 240) = lmat( 240)
         mat( 241) = mat( 241) + lmat( 241)
         mat( 242) = lmat( 242)
         mat( 243) = mat( 243) + lmat( 243)
         mat( 245) = lmat( 245)
         mat( 247) = lmat( 247)
         mat( 248) = mat( 248) + lmat( 248)
         mat( 249) = lmat( 249)
         mat( 250) = mat( 250) + lmat( 250)
         mat( 253) = lmat( 253)
         mat( 254) = lmat( 254)
         mat( 258) = mat( 258) + lmat( 258)
         mat( 259) = lmat( 259)
         mat( 261) = lmat( 261)
         mat( 263) = lmat( 263)
         mat( 265) = lmat( 265)
         mat( 266) = mat( 266) + lmat( 266)
         mat( 271) = mat( 271) + lmat( 271)
         mat( 279) = lmat( 279)
         mat( 280) = lmat( 280)
         mat( 281) = lmat( 281)
         mat( 282) = lmat( 282)
         mat( 283) = lmat( 283)
         mat( 284) = lmat( 284)
         mat( 285) = mat( 285) + lmat( 285)
         mat( 290) = mat( 290) + lmat( 290)
         mat( 301) = mat( 301) + lmat( 301)
         mat( 308) = mat( 308) + lmat( 308)
         mat( 309) = mat( 309) + lmat( 309)
         mat( 311) = mat( 311) + lmat( 311)
         mat( 312) = lmat( 312)
         mat( 313) = mat( 313) + lmat( 313)
         mat( 315) = lmat( 315)
         mat( 318) = lmat( 318)
         mat( 319) = lmat( 319)
         mat( 320) = mat( 320) + lmat( 320)
         mat( 322) = lmat( 322)
         mat( 324) = mat( 324) + lmat( 324)
         mat( 331) = mat( 331) + lmat( 331)
         mat( 334) = lmat( 334)
         mat( 335) = lmat( 335)
         mat( 337) = mat( 337) + lmat( 337)
         mat( 350) = mat( 350) + lmat( 350)
         mat( 365) = mat( 365) + lmat( 365)
         mat( 374) = mat( 374) + lmat( 374)
         mat( 375) = mat( 375) + lmat( 375)
         mat( 376) = lmat( 376)
         mat( 378) = mat( 378) + lmat( 378)
         mat( 381) = mat( 381) + lmat( 381)
         mat( 392) = mat( 392) + lmat( 392)
         mat( 407) = mat( 407) + lmat( 407)
         mat( 412) = mat( 412) + lmat( 412)
         mat( 415) = mat( 415) + lmat( 415)
         mat( 428) = mat( 428) + lmat( 428)
         mat( 442) = mat( 442) + lmat( 442)
         mat( 443) = mat( 443) + lmat( 443)
         mat( 444) = mat( 444) + lmat( 444)
         mat( 445) = lmat( 445)
         mat( 446) = lmat( 446)
         mat( 447) = mat( 447) + lmat( 447)
         mat( 449) = lmat( 449)
         mat( 450) = lmat( 450)
         mat( 451) = lmat( 451)
         mat( 453) = mat( 453) + lmat( 453)
         mat( 455) = lmat( 455)
         mat( 456) = lmat( 456)
         mat( 457) = mat( 457) + lmat( 457)
         mat( 460) = mat( 460) + lmat( 460)
         mat( 462) = mat( 462) + lmat( 462)
         mat( 463) = lmat( 463)
         mat( 468) = lmat( 468)
         mat( 469) = lmat( 469)
         mat( 472) = mat( 472) + lmat( 472)
         mat( 485) = mat( 485) + lmat( 485)
         mat( 495) = mat( 495) + lmat( 495)
         mat( 497) = lmat( 497)
         mat( 499) = lmat( 499)
         mat( 500) = mat( 500) + lmat( 500)
         mat( 501) = mat( 501) + lmat( 501)
         mat( 504) = mat( 504) + lmat( 504)
         mat( 505) = mat( 505) + lmat( 505)
         mat( 506) = mat( 506) + lmat( 506)
         mat( 508) = lmat( 508)
         mat( 510) = mat( 510) + lmat( 510)
         mat( 512) = mat( 512) + lmat( 512)
         mat( 513) = mat( 513) + lmat( 513)
         mat( 517) = mat( 517) + lmat( 517)
         mat( 518) = lmat( 518)
         mat( 525) = mat( 525) + lmat( 525)
         mat( 540) = mat( 540) + lmat( 540)
         mat( 546) = mat( 546) + lmat( 546)
         mat( 550) = lmat( 550)
         mat( 554) = mat( 554) + lmat( 554)
         mat( 557) = mat( 557) + lmat( 557)
         mat( 561) = lmat( 561)
         mat( 565) = lmat( 565)
         mat( 573) = mat( 573) + lmat( 573)
         mat( 593) = mat( 593) + lmat( 593)
         mat( 607) = lmat( 607)
         mat( 611) = mat( 611) + lmat( 611)
         mat( 612) = mat( 612) + lmat( 612)
         mat( 624) = mat( 624) + lmat( 624)
         mat( 639) = mat( 639) + lmat( 639)
         mat( 652) = mat( 652) + lmat( 652)
         mat( 658) = mat( 658) + lmat( 658)
         mat( 662) = mat( 662) + lmat( 662)
         mat( 663) = mat( 663) + lmat( 663)
         mat( 668) = mat( 668) + lmat( 668)
         mat( 750) = mat( 750) + lmat( 750)
         mat( 756) = mat( 756) + lmat( 756)
         mat( 762) = mat( 762) + lmat( 762)
         mat( 777) = mat( 777) + lmat( 777)
         mat( 784) = mat( 784) + lmat( 784)
         mat( 786) = mat( 786) + lmat( 786)
         mat( 790) = mat( 790) + lmat( 790)
         mat( 811) = mat( 811) + lmat( 811)
         mat( 826) = mat( 826) + lmat( 826)
         mat( 834) = mat( 834) + lmat( 834)
         mat( 845) = mat( 845) + lmat( 845)
         mat( 853) = mat( 853) + lmat( 853)
         mat( 908) = mat( 908) + lmat( 908)
         mat( 953) = mat( 953) + lmat( 953)
         mat( 987) = mat( 987) + lmat( 987)
         mat( 201) = 0._r8
         mat( 276) = 0._r8
         mat( 302) = 0._r8
         mat( 305) = 0._r8
         mat( 314) = 0._r8
         mat( 317) = 0._r8
         mat( 321) = 0._r8
         mat( 327) = 0._r8
         mat( 339) = 0._r8
         mat( 342) = 0._r8
         mat( 348) = 0._r8
         mat( 351) = 0._r8
         mat( 353) = 0._r8
         mat( 354) = 0._r8
         mat( 357) = 0._r8
         mat( 358) = 0._r8
         mat( 361) = 0._r8
         mat( 369) = 0._r8
         mat( 383) = 0._r8
         mat( 386) = 0._r8
         mat( 387) = 0._r8
         mat( 405) = 0._r8
         mat( 408) = 0._r8
         mat( 416) = 0._r8
         mat( 420) = 0._r8
         mat( 421) = 0._r8
         mat( 424) = 0._r8
         mat( 430) = 0._r8
         mat( 431) = 0._r8
         mat( 434) = 0._r8
         mat( 439) = 0._r8
         mat( 454) = 0._r8
         mat( 464) = 0._r8
         mat( 474) = 0._r8
         mat( 477) = 0._r8
         mat( 479) = 0._r8
         mat( 490) = 0._r8
         mat( 514) = 0._r8
         mat( 529) = 0._r8
         mat( 539) = 0._r8
         mat( 549) = 0._r8
         mat( 552) = 0._r8
         mat( 558) = 0._r8
         mat( 560) = 0._r8
         mat( 564) = 0._r8
         mat( 572) = 0._r8
         mat( 576) = 0._r8
         mat( 578) = 0._r8
         mat( 589) = 0._r8
         mat( 590) = 0._r8
         mat( 592) = 0._r8
         mat( 595) = 0._r8
         mat( 596) = 0._r8
         mat( 598) = 0._r8
         mat( 601) = 0._r8
         mat( 609) = 0._r8
         mat( 613) = 0._r8
         mat( 616) = 0._r8
         mat( 618) = 0._r8
         mat( 619) = 0._r8
         mat( 621) = 0._r8
         mat( 622) = 0._r8
         mat( 623) = 0._r8
         mat( 625) = 0._r8
         mat( 627) = 0._r8
         mat( 628) = 0._r8
         mat( 630) = 0._r8
         mat( 631) = 0._r8
         mat( 635) = 0._r8
         mat( 636) = 0._r8
         mat( 638) = 0._r8
         mat( 641) = 0._r8
         mat( 655) = 0._r8
         mat( 656) = 0._r8
         mat( 657) = 0._r8
         mat( 659) = 0._r8
         mat( 660) = 0._r8
         mat( 669) = 0._r8
         mat( 716) = 0._r8
         mat( 733) = 0._r8
         mat( 736) = 0._r8
         mat( 755) = 0._r8
         mat( 772) = 0._r8
         mat( 788) = 0._r8
         mat( 791) = 0._r8
         mat( 809) = 0._r8
         mat( 810) = 0._r8
         mat( 820) = 0._r8
         mat( 821) = 0._r8
         mat( 824) = 0._r8
         mat( 828) = 0._r8
         mat( 829) = 0._r8
         mat( 830) = 0._r8
         mat( 833) = 0._r8
         mat( 836) = 0._r8
         mat( 837) = 0._r8
         mat( 844) = 0._r8
         mat( 854) = 0._r8
         mat( 873) = 0._r8
         mat( 876) = 0._r8
         mat( 879) = 0._r8
         mat( 883) = 0._r8
         mat( 887) = 0._r8
         mat( 889) = 0._r8
         mat( 892) = 0._r8
         mat( 894) = 0._r8
         mat( 901) = 0._r8
         mat( 965) = 0._r8
         mat( 966) = 0._r8
         mat( 973) = 0._r8
         mat( 981) = 0._r8
         mat( 982) = 0._r8
         mat( 984) = 0._r8
         mat( 1) = mat( 1) - dti
         mat( 2) = mat( 2) - dti
         mat( 3) = mat( 3) - dti
         mat( 4) = mat( 4) - dti
         mat( 5) = mat( 5) - dti
         mat( 6) = mat( 6) - dti
         mat( 7) = mat( 7) - dti
         mat( 8) = mat( 8) - dti
         mat( 9) = mat( 9) - dti
         mat( 10) = mat( 10) - dti
         mat( 11) = mat( 11) - dti
         mat( 12) = mat( 12) - dti
         mat( 13) = mat( 13) - dti
         mat( 14) = mat( 14) - dti
         mat( 15) = mat( 15) - dti
         mat( 16) = mat( 16) - dti
         mat( 18) = mat( 18) - dti
         mat( 19) = mat( 19) - dti
         mat( 21) = mat( 21) - dti
         mat( 22) = mat( 22) - dti
         mat( 23) = mat( 23) - dti
         mat( 24) = mat( 24) - dti
         mat( 25) = mat( 25) - dti
         mat( 26) = mat( 26) - dti
         mat( 27) = mat( 27) - dti
         mat( 28) = mat( 28) - dti
         mat( 29) = mat( 29) - dti
         mat( 30) = mat( 30) - dti
         mat( 31) = mat( 31) - dti
         mat( 32) = mat( 32) - dti
         mat( 33) = mat( 33) - dti
         mat( 34) = mat( 34) - dti
         mat( 35) = mat( 35) - dti
         mat( 36) = mat( 36) - dti
         mat( 37) = mat( 37) - dti
         mat( 38) = mat( 38) - dti
         mat( 39) = mat( 39) - dti
         mat( 40) = mat( 40) - dti
         mat( 42) = mat( 42) - dti
         mat( 45) = mat( 45) - dti
         mat( 48) = mat( 48) - dti
         mat( 51) = mat( 51) - dti
         mat( 54) = mat( 54) - dti
         mat( 57) = mat( 57) - dti
         mat( 60) = mat( 60) - dti
         mat( 63) = mat( 63) - dti
         mat( 68) = mat( 68) - dti
         mat( 72) = mat( 72) - dti
         mat( 74) = mat( 74) - dti
         mat( 77) = mat( 77) - dti
         mat( 83) = mat( 83) - dti
         mat( 87) = mat( 87) - dti
         mat( 91) = mat( 91) - dti
         mat( 95) = mat( 95) - dti
         mat( 101) = mat( 101) - dti
         mat( 106) = mat( 106) - dti
         mat( 110) = mat( 110) - dti
         mat( 114) = mat( 114) - dti
         mat( 118) = mat( 118) - dti
         mat( 124) = mat( 124) - dti
         mat( 129) = mat( 129) - dti
         mat( 134) = mat( 134) - dti
         mat( 139) = mat( 139) - dti
         mat( 144) = mat( 144) - dti
         mat( 149) = mat( 149) - dti
         mat( 153) = mat( 153) - dti
         mat( 160) = mat( 160) - dti
         mat( 165) = mat( 165) - dti
         mat( 170) = mat( 170) - dti
         mat( 177) = mat( 177) - dti
         mat( 180) = mat( 180) - dti
         mat( 187) = mat( 187) - dti
         mat( 193) = mat( 193) - dti
         mat( 198) = mat( 198) - dti
         mat( 204) = mat( 204) - dti
         mat( 209) = mat( 209) - dti
         mat( 212) = mat( 212) - dti
         mat( 218) = mat( 218) - dti
         mat( 225) = mat( 225) - dti
         mat( 232) = mat( 232) - dti
         mat( 236) = mat( 236) - dti
         mat( 243) = mat( 243) - dti
         mat( 250) = mat( 250) - dti
         mat( 258) = mat( 258) - dti
         mat( 266) = mat( 266) - dti
         mat( 271) = mat( 271) - dti
         mat( 279) = mat( 279) - dti
         mat( 285) = mat( 285) - dti
         mat( 290) = mat( 290) - dti
         mat( 301) = mat( 301) - dti
         mat( 308) = mat( 308) - dti
         mat( 313) = mat( 313) - dti
         mat( 324) = mat( 324) - dti
         mat( 331) = mat( 331) - dti
         mat( 337) = mat( 337) - dti
         mat( 350) = mat( 350) - dti
         mat( 365) = mat( 365) - dti
         mat( 374) = mat( 374) - dti
         mat( 381) = mat( 381) - dti
         mat( 392) = mat( 392) - dti
         mat( 407) = mat( 407) - dti
         mat( 415) = mat( 415) - dti
         mat( 428) = mat( 428) - dti
         mat( 444) = mat( 444) - dti
         mat( 453) = mat( 453) - dti
         mat( 462) = mat( 462) - dti
         mat( 472) = mat( 472) - dti
         mat( 485) = mat( 485) - dti
         mat( 495) = mat( 495) - dti
         mat( 501) = mat( 501) - dti
         mat( 512) = mat( 512) - dti
         mat( 525) = mat( 525) - dti
         mat( 540) = mat( 540) - dti
         mat( 554) = mat( 554) - dti
         mat( 573) = mat( 573) - dti
         mat( 593) = mat( 593) - dti
         mat( 611) = mat( 611) - dti
         mat( 624) = mat( 624) - dti
         mat( 639) = mat( 639) - dti
         mat( 662) = mat( 662) - dti
         mat( 750) = mat( 750) - dti
         mat( 786) = mat( 786) - dti
         mat( 811) = mat( 811) - dti
         mat( 845) = mat( 845) - dti
         mat( 908) = mat( 908) - dti
         mat( 953) = mat( 953) - dti
         mat( 987) = mat( 987) - dti
      end subroutine nlnmat_finit
      subroutine nlnmat( mat, y, rxt, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)
      call nlnmat01( mat, y, rxt )
      call nlnmat02( mat, y, rxt )
      call nlnmat03( mat, y, rxt )
      call nlnmat04( mat, y, rxt )
      call nlnmat05( mat, y, rxt )
      call nlnmat_finit( mat, lmat, dti )
      end subroutine nlnmat
      end module mo_nln_matrix
