




      module mo_nln_matrix

      use shr_kind_mod, only : r8 => shr_kind_r8

      private
      public :: nlnmat

      contains

      subroutine nlnmat01( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(972) = -(rxt(84)*y(2) + rxt(91)*y(3) + rxt(116)*y(19) + rxt(121)*y(20) &
                      + rxt(129)*y(21) + rxt(141)*y(6) + rxt(144)*y(7) + rxt(156) &
                      *y(25) + rxt(183)*y(34) + rxt(236)*y(41) + rxt(257)*y(56) &
                      + rxt(279)*y(74) + rxt(285)*y(75) + rxt(303)*y(80) + rxt(335) &
                      *y(96))
         mat(1091) = -rxt(84)*y(1)
         mat(1110) = -rxt(91)*y(1)
         mat(694) = -rxt(116)*y(1)
         mat(893) = -rxt(121)*y(1)
         mat(1065) = -rxt(129)*y(1)
         mat(1202) = -rxt(141)*y(1)
         mat(801) = -rxt(144)*y(1)
         mat(998) = -rxt(156)*y(1)
         mat(1151) = -rxt(183)*y(1)
         mat(143) = -rxt(236)*y(1)
         mat(476) = -rxt(257)*y(1)
         mat(593) = -rxt(279)*y(1)
         mat(548) = -rxt(285)*y(1)
         mat(426) = -rxt(303)*y(1)
         mat(277) = -rxt(335)*y(1)

         mat(972) = mat(972) + .100_r8*rxt(303)*y(80) + .200_r8*rxt(279)*y(74) &
                      + .200_r8*rxt(285)*y(75)
         mat(1065) = mat(1065) + .250_r8*rxt(247)*y(45) + .250_r8*rxt(295)*y(73)
         mat(426) = mat(426) + .100_r8*rxt(303)*y(1)
         mat(679) = .250_r8*rxt(247)*y(21)
         mat(593) = mat(593) + .200_r8*rxt(279)*y(1)
         mat(548) = mat(548) + .200_r8*rxt(285)*y(1)
         mat(653) = .250_r8*rxt(295)*y(21)

         mat(1094) = -(rxt(84)*y(1) + 4._r8*rxt(85)*y(2) + rxt(120)*y(20) + rxt(127) &
                      *y(18) + rxt(128)*y(21) + rxt(131)*y(22) + rxt(139)*y(6) &
                      + (rxt(142) + rxt(143)) * y(7) + rxt(150)*y(8) + rxt(163)*y(27) &
                      + rxt(176)*y(30) + rxt(177)*y(31) + rxt(180)*y(32) + rxt(186) &
                      *y(35) + rxt(196)*y(36) + rxt(197)*y(37) + rxt(198)*y(38) &
                      + rxt(216)*y(16) + rxt(350)*y(121))
         mat(975) = -rxt(84)*y(2)
         mat(896) = -rxt(120)*y(2)
         mat(498) = -rxt(127)*y(2)
         mat(1068) = -rxt(128)*y(2)
         mat(293) = -rxt(131)*y(2)
         mat(1205) = -rxt(139)*y(2)
         mat(804) = -(rxt(142) + rxt(143)) * y(2)
         mat(937) = -rxt(150)*y(2)
         mat(1136) = -rxt(163)*y(2)
         mat(1226) = -rxt(176)*y(2)
         mat(409) = -rxt(177)*y(2)
         mat(437) = -rxt(180)*y(2)
         mat(714) = -rxt(186)*y(2)
         mat(383) = -rxt(196)*y(2)
         mat(370) = -rxt(197)*y(2)
         mat(237) = -rxt(198)*y(2)
         mat(771) = -rxt(216)*y(2)
         mat(84) = -rxt(350)*y(2)

         mat(70) = rxt(135)*y(6) + rxt(136)*y(7)
         mat(1205) = mat(1205) + rxt(135)*y(5)
         mat(804) = mat(804) + rxt(136)*y(5)
         mat(896) = mat(896) + 2.000_r8*rxt(123)*y(20)
         mat(697) = rxt(119)*y(21)
         mat(1068) = mat(1068) + rxt(119)*y(19)

         mat(1114) = -(rxt(88)*y(146) + rxt(91)*y(1) + rxt(111)*y(18) + rxt(112)*y(30) &
                      + rxt(113)*y(36) + rxt(114)*y(39))
         mat(688) = -rxt(88)*y(3)
         mat(976) = -rxt(91)*y(3)
         mat(499) = -rxt(111)*y(3)
         mat(1227) = -rxt(112)*y(3)
         mat(384) = -rxt(113)*y(3)
         mat(75) = -rxt(114)*y(3)

         mat(493) = -(rxt(111)*y(3) + rxt(125)*y(20) + rxt(127)*y(2) + rxt(157)*y(25))
         mat(1102) = -rxt(111)*y(18)
         mat(872) = -rxt(125)*y(18)
         mat(1082) = -rxt(127)*y(18)
         mat(987) = -rxt(157)*y(18)

         mat(690) = rxt(118)*y(21)
         mat(1044) = rxt(118)*y(19)

         mat(501) = -((rxt(212) + rxt(213)) * y(20))
         mat(873) = -(rxt(212) + rxt(213)) * y(17)

         mat(952) = .560_r8*rxt(257)*y(56) + .300_r8*rxt(303)*y(80) + .500_r8*rxt(236) &
                      *y(41) + .050_r8*rxt(279)*y(74) + .200_r8*rxt(285)*y(75)
         mat(1083) = rxt(216)*y(16) + rxt(350)*y(121)
         mat(1182) = .220_r8*rxt(286)*y(76) + .500_r8*rxt(321)*y(88)
         mat(873) = mat(873) + rxt(215)*y(16) + rxt(252)*y(50) + rxt(273)*y(65) &
                      + .350_r8*rxt(229)*y(118) + rxt(351)*y(121)
         mat(915) = rxt(214)*y(16) + .220_r8*rxt(288)*y(76) + rxt(274)*y(65) &
                      + .500_r8*rxt(322)*y(88)
         mat(731) = .110_r8*rxt(290)*y(76) + .200_r8*rxt(324)*y(88)
         mat(761) = rxt(216)*y(2) + rxt(215)*y(20) + rxt(214)*y(8) + rxt(161)*y(25) &
                      + rxt(185)*y(34)
         mat(988) = rxt(161)*y(16)
         mat(1143) = rxt(185)*y(16)
         mat(466) = .560_r8*rxt(257)*y(1)
         mat(416) = .300_r8*rxt(303)*y(1)
         mat(662) = .220_r8*rxt(291)*y(76) + .500_r8*rxt(325)*y(88)
         mat(140) = .500_r8*rxt(236)*y(1)
         mat(319) = rxt(252)*y(20)
         mat(579) = .050_r8*rxt(279)*y(1)
         mat(538) = .200_r8*rxt(285)*y(1)
         mat(600) = .220_r8*rxt(286)*y(6) + .220_r8*rxt(288)*y(8) + .110_r8*rxt(290) &
                      *y(13) + .220_r8*rxt(291)*y(45)
         mat(551) = rxt(273)*y(20) + rxt(274)*y(8)
         mat(564) = .500_r8*rxt(321)*y(6) + .500_r8*rxt(322)*y(8) + .200_r8*rxt(324) &
                      *y(13) + .500_r8*rxt(325)*y(45)
         mat(59) = .350_r8*rxt(229)*y(20)
         mat(81) = rxt(350)*y(2) + rxt(351)*y(20)

         mat(68) = -(rxt(135)*y(6) + (rxt(136) + rxt(137) + rxt(138)) * y(7))
         mat(1160) = -rxt(135)*y(5)
         mat(777) = -(rxt(136) + rxt(137) + rxt(138)) * y(5)

         mat(1209) = -(rxt(135)*y(5) + rxt(139)*y(2) + rxt(140)*y(21) + rxt(141)*y(1) &
                      + rxt(149)*y(8) + rxt(168)*y(27) + rxt(189)*y(35) + rxt(218) &
                      *y(13) + rxt(226)*y(120) + rxt(232)*y(52) + rxt(238)*y(43) &
                      + rxt(245)*y(45) + rxt(259)*y(58) + rxt(264)*y(61) + rxt(268) &
                      *y(64) + rxt(277)*y(70) + rxt(281)*y(71) + (rxt(286) + rxt(287) &
                      ) * y(76) + rxt(293)*y(73) + rxt(305)*y(85) + rxt(311)*y(86) &
                      + rxt(318)*y(81) + rxt(321)*y(88) + rxt(329)*y(93) + rxt(337) &
                      *y(97))
         mat(71) = -rxt(135)*y(6)
         mat(1098) = -rxt(139)*y(6)
         mat(1072) = -rxt(140)*y(6)
         mat(979) = -rxt(141)*y(6)
         mat(941) = -rxt(149)*y(6)
         mat(1140) = -rxt(168)*y(6)
         mat(718) = -rxt(189)*y(6)
         mat(755) = -rxt(218)*y(6)
         mat(212) = -rxt(226)*y(6)
         mat(287) = -rxt(232)*y(6)
         mat(363) = -rxt(238)*y(6)
         mat(681) = -rxt(245)*y(6)
         mat(398) = -rxt(259)*y(6)
         mat(352) = -rxt(264)*y(6)
         mat(461) = -rxt(268)*y(6)
         mat(117) = -rxt(277)*y(6)
         mat(317) = -rxt(281)*y(6)
         mat(615) = -(rxt(286) + rxt(287)) * y(6)
         mat(655) = -rxt(293)*y(6)
         mat(638) = -rxt(305)*y(6)
         mat(492) = -rxt(311)*y(6)
         mat(336) = -rxt(318)*y(6)
         mat(577) = -rxt(321)*y(6)
         mat(247) = -rxt(329)*y(6)
         mat(520) = -rxt(337)*y(6)

         mat(1098) = mat(1098) + rxt(142)*y(7)
         mat(71) = mat(71) + 2.000_r8*rxt(137)*y(7)
         mat(808) = rxt(142)*y(2) + 2.000_r8*rxt(137)*y(5)

         mat(798) = -((rxt(136) + rxt(137) + rxt(138)) * y(5) + (rxt(142) + rxt(143) &
                      ) * y(2) + rxt(144)*y(1) + rxt(145)*y(8) + rxt(147)*y(20) &
                      + rxt(153)*y(21) + rxt(169)*y(27) + rxt(190)*y(35) + rxt(246) &
                      *y(45) + rxt(299)*y(73) + rxt(333)*y(95))
         mat(69) = -(rxt(136) + rxt(137) + rxt(138)) * y(7)
         mat(1088) = -(rxt(142) + rxt(143)) * y(7)
         mat(969) = -rxt(144)*y(7)
         mat(931) = -rxt(145)*y(7)
         mat(890) = -rxt(147)*y(7)
         mat(1062) = -rxt(153)*y(7)
         mat(1130) = -rxt(169)*y(7)
         mat(708) = -rxt(190)*y(7)
         mat(676) = -rxt(246)*y(7)
         mat(650) = -rxt(299)*y(7)
         mat(66) = -rxt(333)*y(7)

         mat(969) = mat(969) + rxt(141)*y(6)
         mat(1088) = mat(1088) + rxt(139)*y(6) + rxt(150)*y(8)
         mat(1199) = rxt(141)*y(1) + rxt(139)*y(2) + 2.000_r8*rxt(149)*y(8) + rxt(218) &
                      *y(13) + rxt(140)*y(21) + rxt(168)*y(27) + rxt(189)*y(35) &
                      + rxt(264)*y(61) + rxt(245)*y(45) + rxt(277)*y(70) &
                      + .900_r8*rxt(318)*y(81) + rxt(281)*y(71) + .900_r8*rxt(329) &
                      *y(93) + rxt(337)*y(97) + .920_r8*rxt(305)*y(85) + rxt(286) &
                      *y(76) + rxt(293)*y(73) + rxt(238)*y(43) + rxt(259)*y(58) &
                      + rxt(232)*y(52) + rxt(268)*y(64) + 1.206_r8*rxt(311)*y(86) &
                      + rxt(321)*y(88) + rxt(226)*y(120)
         mat(798) = mat(798) + .700_r8*rxt(333)*y(95)
         mat(890) = mat(890) + rxt(151)*y(8) + rxt(154)*y(10) + rxt(275)*y(79) &
                      + .400_r8*rxt(315)*y(87)
         mat(931) = mat(931) + rxt(150)*y(2) + 2.000_r8*rxt(149)*y(6) + rxt(151)*y(20) &
                      + rxt(152)*y(21) + rxt(306)*y(85) + rxt(288)*y(76) + rxt(294) &
                      *y(73) + rxt(336)*y(96) + 1.206_r8*rxt(312)*y(86) + rxt(316) &
                      *y(87) + rxt(322)*y(88)
         mat(176) = rxt(154)*y(20)
         mat(746) = rxt(218)*y(6)
         mat(1062) = mat(1062) + rxt(140)*y(6) + rxt(152)*y(8) + .206_r8*rxt(313) &
                      *y(86)
         mat(1130) = mat(1130) + rxt(168)*y(6)
         mat(708) = mat(708) + rxt(189)*y(6)
         mat(349) = rxt(264)*y(6)
         mat(676) = mat(676) + rxt(245)*y(6)
         mat(156) = rxt(275)*y(20)
         mat(115) = rxt(277)*y(6)
         mat(333) = .900_r8*rxt(318)*y(6)
         mat(314) = rxt(281)*y(6)
         mat(244) = .900_r8*rxt(329)*y(6)
         mat(66) = mat(66) + .700_r8*rxt(333)*y(7)
         mat(517) = rxt(337)*y(6)
         mat(633) = .920_r8*rxt(305)*y(6) + rxt(306)*y(8)
         mat(611) = rxt(286)*y(6) + rxt(288)*y(8)
         mat(650) = mat(650) + rxt(293)*y(6) + rxt(294)*y(8)
         mat(360) = rxt(238)*y(6)
         mat(274) = rxt(336)*y(8)
         mat(395) = rxt(259)*y(6)
         mat(284) = rxt(232)*y(6)
         mat(458) = rxt(268)*y(6)
         mat(488) = 1.206_r8*rxt(311)*y(6) + 1.206_r8*rxt(312)*y(8) + .206_r8*rxt(313) &
                      *y(21)
         mat(445) = .400_r8*rxt(315)*y(20) + rxt(316)*y(8)
         mat(573) = rxt(321)*y(6) + rxt(322)*y(8)
         mat(209) = rxt(226)*y(6)


      end subroutine nlnmat01

      subroutine nlnmat02( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(891) = -(rxt(120)*y(2) + rxt(121)*y(1) + rxt(122)*y(21) + (4._r8*rxt(123) &
                      + 4._r8*rxt(124)) * y(20) + rxt(125)*y(18) + rxt(126)*y(22) &
                      + rxt(132)*y(39) + rxt(133)*y(40) + rxt(147)*y(7) + rxt(148) &
                      *y(9) + rxt(151)*y(8) + rxt(154)*y(10) + (rxt(164) + rxt(165) &
                      ) * y(27) + rxt(175)*y(30) + rxt(179)*y(31) + rxt(181)*y(32) &
                      + rxt(187)*y(35) + rxt(195)*y(36) + (rxt(212) + rxt(213) &
                      ) * y(17) + rxt(215)*y(16) + rxt(222)*y(15) + rxt(223)*y(14) &
                      + rxt(224)*y(119) + rxt(229)*y(118) + rxt(230)*y(42) + rxt(231) &
                      *y(41) + rxt(237)*y(46) + rxt(242)*y(44) + rxt(243)*y(47) &
                      + rxt(250)*y(51) + rxt(251)*y(49) + rxt(252)*y(50) + rxt(253) &
                      *y(48) + rxt(255)*y(55) + rxt(256)*y(56) + rxt(262)*y(59) &
                      + rxt(263)*y(57) + rxt(266)*y(62) + rxt(267)*y(60) + rxt(271) &
                      *y(66) + rxt(272)*y(63) + rxt(273)*y(65) + rxt(275)*y(79) &
                      + rxt(276)*y(67) + rxt(278)*y(74) + rxt(280)*y(69) + rxt(283) &
                      *y(72) + rxt(284)*y(75) + rxt(292)*y(77) + rxt(301)*y(78) &
                      + rxt(302)*y(80) + rxt(308)*y(90) + rxt(314)*y(68) + rxt(315) &
                      *y(87) + rxt(317)*y(84) + rxt(320)*y(82) + rxt(326)*y(89) &
                      + rxt(328)*y(91) + rxt(331)*y(94) + rxt(332)*y(92) + rxt(334) &
                      *y(96) + rxt(339)*y(98) + rxt(344)*y(122) + (rxt(345) + rxt(346) &
                      ) * y(123) + rxt(348)*y(124) + rxt(351)*y(121))
         mat(1089) = -rxt(120)*y(20)
         mat(970) = -rxt(121)*y(20)
         mat(1063) = -rxt(122)*y(20)
         mat(496) = -rxt(125)*y(20)
         mat(290) = -rxt(126)*y(20)
         mat(73) = -rxt(132)*y(20)
         mat(33) = -rxt(133)*y(20)
         mat(799) = -rxt(147)*y(20)
         mat(402) = -rxt(148)*y(20)
         mat(932) = -rxt(151)*y(20)
         mat(177) = -rxt(154)*y(20)
         mat(1131) = -(rxt(164) + rxt(165)) * y(20)
         mat(1221) = -rxt(175)*y(20)
         mat(407) = -rxt(179)*y(20)
         mat(434) = -rxt(181)*y(20)
         mat(709) = -rxt(187)*y(20)
         mat(382) = -rxt(195)*y(20)
         mat(503) = -(rxt(212) + rxt(213)) * y(20)
         mat(766) = -rxt(215)*y(20)
         mat(221) = -rxt(222)*y(20)
         mat(185) = -rxt(223)*y(20)
         mat(172) = -rxt(224)*y(20)
         mat(60) = -rxt(229)*y(20)
         mat(102) = -rxt(230)*y(20)
         mat(142) = -rxt(231)*y(20)
         mat(298) = -rxt(237)*y(20)
         mat(131) = -rxt(242)*y(20)
         mat(535) = -rxt(243)*y(20)
         mat(218) = -rxt(250)*y(20)
         mat(377) = -rxt(251)*y(20)
         mat(320) = -rxt(252)*y(20)
         mat(93) = -rxt(253)*y(20)
         mat(203) = -rxt(255)*y(20)
         mat(474) = -rxt(256)*y(20)
         mat(162) = -rxt(262)*y(20)
         mat(38) = -rxt(263)*y(20)
         mat(268) = -rxt(266)*y(20)
         mat(342) = -rxt(267)*y(20)
         mat(169) = -rxt(271)*y(20)
         mat(525) = -rxt(272)*y(20)
         mat(557) = -rxt(273)*y(20)
         mat(157) = -rxt(275)*y(20)
         mat(28) = -rxt(276)*y(20)
         mat(591) = -rxt(278)*y(20)
         mat(190) = -rxt(280)*y(20)
         mat(122) = -rxt(283)*y(20)
         mat(547) = -rxt(284)*y(20)
         mat(126) = -rxt(292)*y(20)
         mat(259) = -rxt(301)*y(20)
         mat(424) = -rxt(302)*y(20)
         mat(229) = -rxt(308)*y(20)
         mat(25) = -rxt(314)*y(20)
         mat(446) = -rxt(315)*y(20)
         mat(147) = -rxt(317)*y(20)
         mat(308) = -rxt(320)*y(20)
         mat(136) = -rxt(326)*y(20)
         mat(45) = -rxt(328)*y(20)
         mat(153) = -rxt(331)*y(20)
         mat(49) = -rxt(332)*y(20)
         mat(275) = -rxt(334)*y(20)
         mat(196) = -rxt(339)*y(20)
         mat(55) = -rxt(344)*y(20)
         mat(88) = -(rxt(345) + rxt(346)) * y(20)
         mat(31) = -rxt(348)*y(20)
         mat(83) = -rxt(351)*y(20)

         mat(970) = mat(970) + rxt(116)*y(19) + rxt(129)*y(21) + .330_r8*rxt(257) &
                      *y(56) + .270_r8*rxt(303)*y(80) + .120_r8*rxt(236)*y(41) &
                      + .080_r8*rxt(279)*y(74) + .215_r8*rxt(285)*y(75) &
                      + .700_r8*rxt(335)*y(96)
         mat(1089) = mat(1089) + rxt(127)*y(18) + rxt(216)*y(16) + rxt(128)*y(21) &
                      + rxt(131)*y(22) + rxt(176)*y(30) + rxt(177)*y(31) + rxt(196) &
                      *y(36) + rxt(197)*y(37)
         mat(1108) = rxt(111)*y(18) + rxt(114)*y(39) + 2.000_r8*rxt(88)*y(146) &
                      + rxt(112)*y(30) + rxt(113)*y(36)
         mat(496) = mat(496) + rxt(127)*y(2) + rxt(111)*y(3)
         mat(1200) = rxt(140)*y(21)
         mat(891) = mat(891) + .300_r8*rxt(223)*y(14) + .500_r8*rxt(266)*y(62) &
                      + .100_r8*rxt(292)*y(77) + .500_r8*rxt(242)*y(44) &
                      + .650_r8*rxt(229)*y(118)
         mat(932) = mat(932) + rxt(152)*y(21)
         mat(185) = mat(185) + .300_r8*rxt(223)*y(20)
         mat(73) = mat(73) + rxt(114)*y(3)
         mat(766) = mat(766) + rxt(216)*y(2)
         mat(693) = rxt(116)*y(1) + 2.000_r8*rxt(117)*y(21)
         mat(1063) = mat(1063) + rxt(129)*y(1) + rxt(128)*y(2) + rxt(140)*y(6) &
                      + rxt(152)*y(8) + 2.000_r8*rxt(117)*y(19) + rxt(160)*y(25)
         mat(290) = mat(290) + rxt(131)*y(2)
         mat(685) = 2.000_r8*rxt(88)*y(3)
         mat(996) = rxt(160)*y(21)
         mat(1221) = mat(1221) + rxt(176)*y(2) + rxt(112)*y(3)
         mat(407) = mat(407) + rxt(177)*y(2)
         mat(382) = mat(382) + rxt(196)*y(2) + rxt(113)*y(3)
         mat(368) = rxt(197)*y(2)
         mat(474) = mat(474) + .330_r8*rxt(257)*y(1)
         mat(424) = mat(424) + .270_r8*rxt(303)*y(1)
         mat(268) = mat(268) + .500_r8*rxt(266)*y(20)
         mat(142) = mat(142) + .120_r8*rxt(236)*y(1)
         mat(591) = mat(591) + .080_r8*rxt(279)*y(1)
         mat(547) = mat(547) + .215_r8*rxt(285)*y(1)
         mat(126) = mat(126) + .100_r8*rxt(292)*y(20)
         mat(131) = mat(131) + .500_r8*rxt(242)*y(20)
         mat(275) = mat(275) + .700_r8*rxt(335)*y(1)
         mat(60) = mat(60) + .650_r8*rxt(229)*y(20)

         mat(933) = -(rxt(145)*y(7) + rxt(149)*y(6) + rxt(150)*y(2) + rxt(151)*y(20) &
                      + rxt(152)*y(21) + rxt(214)*y(16) + rxt(244)*y(47) + rxt(258) &
                      *y(56) + rxt(274)*y(65) + rxt(288)*y(76) + rxt(294)*y(73) &
                      + rxt(304)*y(80) + rxt(306)*y(85) + rxt(312)*y(86) + rxt(316) &
                      *y(87) + rxt(322)*y(88) + rxt(336)*y(96) + rxt(347)*y(123))
         mat(800) = -rxt(145)*y(8)
         mat(1201) = -rxt(149)*y(8)
         mat(1090) = -rxt(150)*y(8)
         mat(892) = -rxt(151)*y(8)
         mat(1064) = -rxt(152)*y(8)
         mat(767) = -rxt(214)*y(8)
         mat(536) = -rxt(244)*y(8)
         mat(475) = -rxt(258)*y(8)
         mat(558) = -rxt(274)*y(8)
         mat(613) = -rxt(288)*y(8)
         mat(652) = -rxt(294)*y(8)
         mat(425) = -rxt(304)*y(8)
         mat(635) = -rxt(306)*y(8)
         mat(490) = -rxt(312)*y(8)
         mat(447) = -rxt(316)*y(8)
         mat(575) = -rxt(322)*y(8)
         mat(276) = -rxt(336)*y(8)
         mat(89) = -rxt(347)*y(8)

         mat(971) = rxt(144)*y(7)
         mat(1090) = mat(1090) + rxt(143)*y(7) + rxt(180)*y(32) + rxt(198)*y(38)
         mat(800) = mat(800) + rxt(144)*y(1) + rxt(143)*y(2)
         mat(892) = mat(892) + rxt(148)*y(9) + rxt(181)*y(32) + rxt(255)*y(55) &
                      + .500_r8*rxt(301)*y(78)
         mat(403) = rxt(148)*y(20)
         mat(997) = rxt(182)*y(32)
         mat(435) = rxt(180)*y(2) + rxt(181)*y(20) + rxt(182)*y(25)
         mat(236) = rxt(198)*y(2)
         mat(204) = rxt(255)*y(20)
         mat(260) = .500_r8*rxt(301)*y(20)

         mat(399) = -(rxt(148)*y(20))
         mat(864) = -rxt(148)*y(9)

         mat(786) = rxt(147)*y(20)
         mat(864) = mat(864) + rxt(147)*y(7)
         mat(910) = rxt(214)*y(16) + rxt(244)*y(47) + rxt(274)*y(65) + rxt(347)*y(123)
         mat(759) = rxt(214)*y(8)
         mat(1214) = (rxt(355)+rxt(360)+rxt(366))*y(32)
         mat(429) = (rxt(355)+rxt(360)+rxt(366))*y(30)
         mat(527) = rxt(244)*y(8)
         mat(550) = rxt(274)*y(8)
         mat(87) = rxt(347)*y(8)

         mat(174) = -(rxt(154)*y(20))
         mat(838) = -rxt(154)*y(10)

         mat(779) = rxt(153)*y(21)
         mat(1017) = rxt(153)*y(7)


         mat(778) = rxt(145)*y(8)
         mat(904) = rxt(145)*y(7)

         mat(744) = -(rxt(167)*y(27) + rxt(218)*y(6) + rxt(219)*y(21) + (4._r8*rxt(220) &
                      + 4._r8*rxt(221)) * y(13) + rxt(240)*y(43) + rxt(248)*y(45) &
                      + rxt(261)*y(58) + rxt(270)*y(64) + rxt(290)*y(76) + rxt(296) &
                      *y(73) + rxt(309)*y(85) + rxt(324)*y(88))
         mat(1128) = -rxt(167)*y(13)
         mat(1197) = -rxt(218)*y(13)
         mat(1060) = -rxt(219)*y(13)
         mat(358) = -rxt(240)*y(13)
         mat(674) = -rxt(248)*y(13)
         mat(393) = -rxt(261)*y(13)
         mat(456) = -rxt(270)*y(13)
         mat(609) = -rxt(290)*y(13)
         mat(648) = -rxt(296)*y(13)
         mat(631) = -rxt(309)*y(13)
         mat(571) = -rxt(324)*y(13)

         mat(967) = .310_r8*rxt(257)*y(56)
         mat(1197) = mat(1197) + rxt(245)*y(45)
         mat(888) = .700_r8*rxt(223)*y(14) + rxt(237)*y(46)
         mat(744) = mat(744) + .900_r8*rxt(248)*y(45)
         mat(183) = .700_r8*rxt(223)*y(20)
         mat(471) = .310_r8*rxt(257)*y(1)
         mat(297) = rxt(237)*y(20)
         mat(674) = mat(674) + rxt(245)*y(6) + .900_r8*rxt(248)*y(13) &
                      + 4.000_r8*rxt(249)*y(45) + rxt(310)*y(85) + rxt(291)*y(76) &
                      + rxt(297)*y(73) + rxt(325)*y(88)
         mat(631) = mat(631) + rxt(310)*y(45)
         mat(609) = mat(609) + rxt(291)*y(45)
         mat(648) = mat(648) + rxt(297)*y(45)
         mat(571) = mat(571) + rxt(325)*y(45)


      end subroutine nlnmat02

      subroutine nlnmat03( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(180) = -(rxt(223)*y(20))
         mat(839) = -rxt(223)*y(14)

         mat(722) = rxt(219)*y(21)
         mat(1018) = rxt(219)*y(13)

         mat(72) = -(rxt(114)*y(3) + rxt(132)*y(20))
         mat(1100) = -rxt(114)*y(39)
         mat(821) = -rxt(132)*y(39)

         mat(32) = -(rxt(133)*y(20))
         mat(814) = -rxt(133)*y(40)

         mat(764) = -(rxt(161)*y(25) + rxt(185)*y(34) + rxt(214)*y(8) + rxt(215)*y(20) &
                      + rxt(216)*y(2) + rxt(217)*y(21))
         mat(994) = -rxt(161)*y(16)
         mat(1147) = -rxt(185)*y(16)
         mat(930) = -rxt(214)*y(16)
         mat(889) = -rxt(215)*y(16)
         mat(1087) = -rxt(216)*y(16)
         mat(1061) = -rxt(217)*y(16)

         mat(968) = .540_r8*rxt(257)*y(56) + .600_r8*rxt(303)*y(80) + rxt(236)*y(41) &
                      + .800_r8*rxt(279)*y(74) + .700_r8*rxt(285)*y(75)
         mat(1198) = rxt(218)*y(13) + rxt(264)*y(61) + .500_r8*rxt(277)*y(70) &
                      + .100_r8*rxt(318)*y(81) + .510_r8*rxt(305)*y(85) &
                      + .250_r8*rxt(286)*y(76) + rxt(293)*y(73) + .500_r8*rxt(232) &
                      *y(52) + rxt(268)*y(64) + .072_r8*rxt(311)*y(86)
         mat(889) = mat(889) + .300_r8*rxt(223)*y(14) + .500_r8*rxt(250)*y(51) &
                      + rxt(255)*y(55) + .500_r8*rxt(301)*y(78) + rxt(222)*y(15) &
                      + .800_r8*rxt(251)*y(49)
         mat(930) = mat(930) + .600_r8*rxt(306)*y(85) + .250_r8*rxt(288)*y(76) &
                      + rxt(294)*y(73) + .072_r8*rxt(312)*y(86)
         mat(745) = rxt(218)*y(6) + (4.000_r8*rxt(220)+2.000_r8*rxt(221))*y(13) &
                      + rxt(167)*y(27) + rxt(248)*y(45) + 1.200_r8*rxt(309)*y(85) &
                      + .880_r8*rxt(290)*y(76) + 2.000_r8*rxt(296)*y(73) &
                      + .700_r8*rxt(240)*y(43) + rxt(261)*y(58) + .800_r8*rxt(270) &
                      *y(64) + .700_r8*rxt(324)*y(88)
         mat(184) = .300_r8*rxt(223)*y(20)
         mat(1061) = mat(1061) + .008_r8*rxt(313)*y(86)
         mat(1129) = rxt(167)*y(13)
         mat(472) = .540_r8*rxt(257)*y(1)
         mat(423) = .600_r8*rxt(303)*y(1)
         mat(348) = rxt(264)*y(6)
         mat(675) = rxt(248)*y(13) + .600_r8*rxt(310)*y(85) + .250_r8*rxt(291)*y(76) &
                      + rxt(297)*y(73)
         mat(217) = .500_r8*rxt(250)*y(20)
         mat(201) = rxt(255)*y(20)
         mat(141) = rxt(236)*y(1)
         mat(257) = .500_r8*rxt(301)*y(20)
         mat(114) = .500_r8*rxt(277)*y(6)
         mat(332) = .100_r8*rxt(318)*y(6)
         mat(632) = .510_r8*rxt(305)*y(6) + .600_r8*rxt(306)*y(8) + 1.200_r8*rxt(309) &
                      *y(13) + .600_r8*rxt(310)*y(45)
         mat(589) = .800_r8*rxt(279)*y(1)
         mat(546) = .700_r8*rxt(285)*y(1)
         mat(610) = .250_r8*rxt(286)*y(6) + .250_r8*rxt(288)*y(8) + .880_r8*rxt(290) &
                      *y(13) + .250_r8*rxt(291)*y(45)
         mat(649) = rxt(293)*y(6) + rxt(294)*y(8) + 2.000_r8*rxt(296)*y(13) + rxt(297) &
                      *y(45) + 4.000_r8*rxt(298)*y(73)
         mat(359) = .700_r8*rxt(240)*y(13)
         mat(394) = rxt(261)*y(13)
         mat(220) = rxt(222)*y(20)
         mat(376) = .800_r8*rxt(251)*y(20)
         mat(283) = .500_r8*rxt(232)*y(6)
         mat(457) = rxt(268)*y(6) + .800_r8*rxt(270)*y(13)
         mat(487) = .072_r8*rxt(311)*y(6) + .072_r8*rxt(312)*y(8) + .008_r8*rxt(313) &
                      *y(21)
         mat(572) = .700_r8*rxt(324)*y(13)

         mat(692) = -(rxt(116)*y(1) + (rxt(117) + rxt(118) + rxt(119)) * y(21))
         mat(965) = -rxt(116)*y(19)
         mat(1058) = -(rxt(117) + rxt(118) + rxt(119)) * y(19)

         mat(1085) = rxt(127)*y(18) + rxt(120)*y(20)
         mat(1104) = rxt(111)*y(18)
         mat(495) = rxt(127)*y(2) + rxt(111)*y(3) + rxt(125)*y(20) + rxt(157)*y(25)
         mat(502) = rxt(212)*y(20)
         mat(886) = rxt(120)*y(2) + rxt(125)*y(18) + rxt(212)*y(17) + rxt(215)*y(16) &
                      + rxt(351)*y(121)
         mat(763) = rxt(215)*y(20)
         mat(992) = rxt(157)*y(18)
         mat(82) = rxt(351)*y(20)

         mat(1067) = -((rxt(117) + rxt(118) + rxt(119)) * y(19) + rxt(122)*y(20) &
                      + rxt(128)*y(2) + rxt(129)*y(1) + 4._r8*rxt(130)*y(21) + rxt(140) &
                      *y(6) + rxt(152)*y(8) + rxt(153)*y(7) + (rxt(159) + rxt(160) &
                      ) * y(25) + rxt(166)*y(27) + rxt(184)*y(34) + rxt(188)*y(35) &
                      + rxt(217)*y(16) + rxt(219)*y(13) + rxt(227)*y(120) + rxt(233) &
                      *y(52) + rxt(239)*y(43) + rxt(247)*y(45) + rxt(260)*y(58) &
                      + rxt(265)*y(61) + rxt(269)*y(64) + rxt(282)*y(71) + rxt(289) &
                      *y(76) + rxt(295)*y(73) + rxt(307)*y(85) + rxt(313)*y(86) &
                      + rxt(319)*y(81) + rxt(323)*y(88) + rxt(330)*y(93) + rxt(338) &
                      *y(97))
         mat(696) = -(rxt(117) + rxt(118) + rxt(119)) * y(21)
         mat(895) = -rxt(122)*y(21)
         mat(1093) = -rxt(128)*y(21)
         mat(974) = -rxt(129)*y(21)
         mat(1204) = -rxt(140)*y(21)
         mat(936) = -rxt(152)*y(21)
         mat(803) = -rxt(153)*y(21)
         mat(1000) = -(rxt(159) + rxt(160)) * y(21)
         mat(1135) = -rxt(166)*y(21)
         mat(1153) = -rxt(184)*y(21)
         mat(713) = -rxt(188)*y(21)
         mat(770) = -rxt(217)*y(21)
         mat(751) = -rxt(219)*y(21)
         mat(211) = -rxt(227)*y(21)
         mat(286) = -rxt(233)*y(21)
         mat(362) = -rxt(239)*y(21)
         mat(680) = -rxt(247)*y(21)
         mat(397) = -rxt(260)*y(21)
         mat(351) = -rxt(265)*y(21)
         mat(460) = -rxt(269)*y(21)
         mat(316) = -rxt(282)*y(21)
         mat(614) = -rxt(289)*y(21)
         mat(654) = -rxt(295)*y(21)
         mat(637) = -rxt(307)*y(21)
         mat(491) = -rxt(313)*y(21)
         mat(335) = -rxt(319)*y(21)
         mat(576) = -rxt(323)*y(21)
         mat(246) = -rxt(330)*y(21)
         mat(519) = -rxt(338)*y(21)

         mat(974) = mat(974) + rxt(121)*y(20) + .190_r8*rxt(257)*y(56) &
                      + .060_r8*rxt(303)*y(80) + .120_r8*rxt(236)*y(41) &
                      + .060_r8*rxt(279)*y(74) + .275_r8*rxt(285)*y(75) + rxt(335) &
                      *y(96)
         mat(1093) = mat(1093) + rxt(216)*y(16) + rxt(131)*y(22)
         mat(504) = rxt(213)*y(20)
         mat(1204) = mat(1204) + rxt(218)*y(13) + rxt(264)*y(61) + rxt(277)*y(70) &
                      + .900_r8*rxt(318)*y(81) + .900_r8*rxt(329)*y(93) + rxt(337) &
                      *y(97) + rxt(305)*y(85) + .470_r8*rxt(286)*y(76) + rxt(238) &
                      *y(43) + rxt(259)*y(58) + .250_r8*rxt(232)*y(52) &
                      + .794_r8*rxt(311)*y(86) + rxt(321)*y(88) + rxt(226)*y(120)
         mat(803) = mat(803) + .700_r8*rxt(333)*y(95)
         mat(895) = mat(895) + rxt(121)*y(1) + rxt(213)*y(17) + rxt(151)*y(8) &
                      + rxt(132)*y(39) + rxt(133)*y(40) + rxt(126)*y(22) + rxt(164) &
                      *y(27) + rxt(187)*y(35) + .500_r8*rxt(301)*y(78) &
                      + .250_r8*rxt(328)*y(91) + rxt(252)*y(50) + .200_r8*rxt(292) &
                      *y(77) + rxt(222)*y(15) + rxt(253)*y(48) + rxt(251)*y(49) &
                      + rxt(272)*y(63) + rxt(315)*y(87) + .350_r8*rxt(229)*y(118) &
                      + rxt(224)*y(119) + .500_r8*rxt(346)*y(123)
         mat(936) = mat(936) + rxt(151)*y(20) + rxt(214)*y(16) + rxt(306)*y(85) &
                      + .470_r8*rxt(288)*y(76) + .794_r8*rxt(312)*y(86) + rxt(316) &
                      *y(87) + rxt(322)*y(88)
         mat(751) = mat(751) + rxt(218)*y(6) + 4.000_r8*rxt(220)*y(13) + rxt(167) &
                      *y(27) + .900_r8*rxt(248)*y(45) + rxt(309)*y(85) &
                      + .730_r8*rxt(290)*y(76) + rxt(296)*y(73) + rxt(240)*y(43) &
                      + rxt(261)*y(58) + .300_r8*rxt(270)*y(64) + .800_r8*rxt(324) &
                      *y(88)
         mat(74) = rxt(132)*y(20)
         mat(34) = rxt(133)*y(20)
         mat(770) = mat(770) + rxt(216)*y(2) + rxt(214)*y(8) + rxt(161)*y(25) &
                      + rxt(185)*y(34)
         mat(1067) = mat(1067) + .794_r8*rxt(313)*y(86)
         mat(292) = rxt(131)*y(2) + rxt(126)*y(20) + rxt(158)*y(25)
         mat(1000) = mat(1000) + rxt(161)*y(16) + rxt(158)*y(22)
         mat(1135) = mat(1135) + rxt(164)*y(20) + rxt(167)*y(13)
         mat(1153) = mat(1153) + rxt(185)*y(16)
         mat(713) = mat(713) + rxt(187)*y(20)
         mat(477) = .190_r8*rxt(257)*y(1)
         mat(427) = .060_r8*rxt(303)*y(1)
         mat(351) = mat(351) + rxt(264)*y(6)
         mat(680) = mat(680) + .900_r8*rxt(248)*y(13) + rxt(310)*y(85) &
                      + .470_r8*rxt(291)*y(76) + rxt(325)*y(88)
         mat(144) = .120_r8*rxt(236)*y(1)
         mat(261) = .500_r8*rxt(301)*y(20)
         mat(116) = rxt(277)*y(6)
         mat(335) = mat(335) + .900_r8*rxt(318)*y(6)
         mat(46) = .250_r8*rxt(328)*y(20)
         mat(246) = mat(246) + .900_r8*rxt(329)*y(6)
         mat(67) = .700_r8*rxt(333)*y(7)
         mat(519) = mat(519) + rxt(337)*y(6)
         mat(321) = rxt(252)*y(20)
         mat(637) = mat(637) + rxt(305)*y(6) + rxt(306)*y(8) + rxt(309)*y(13) &
                      + rxt(310)*y(45)
         mat(594) = .060_r8*rxt(279)*y(1)
         mat(549) = .275_r8*rxt(285)*y(1)
         mat(614) = mat(614) + .470_r8*rxt(286)*y(6) + .470_r8*rxt(288)*y(8) &
                      + .730_r8*rxt(290)*y(13) + .470_r8*rxt(291)*y(45)
         mat(127) = .200_r8*rxt(292)*y(20)
         mat(654) = mat(654) + rxt(296)*y(13)
         mat(362) = mat(362) + rxt(238)*y(6) + rxt(240)*y(13) + 2.400_r8*rxt(241) &
                      *y(43)
         mat(278) = rxt(335)*y(1)
         mat(397) = mat(397) + rxt(259)*y(6) + rxt(261)*y(13)
         mat(222) = rxt(222)*y(20)
         mat(94) = rxt(253)*y(20)
         mat(378) = rxt(251)*y(20)
         mat(526) = rxt(272)*y(20)
         mat(286) = mat(286) + .250_r8*rxt(232)*y(6)
         mat(460) = mat(460) + .300_r8*rxt(270)*y(13)
         mat(491) = mat(491) + .794_r8*rxt(311)*y(6) + .794_r8*rxt(312)*y(8) &
                      + .794_r8*rxt(313)*y(21)
         mat(448) = rxt(315)*y(20) + rxt(316)*y(8)
         mat(576) = mat(576) + rxt(321)*y(6) + rxt(322)*y(8) + .800_r8*rxt(324)*y(13) &
                      + rxt(325)*y(45)
         mat(61) = .350_r8*rxt(229)*y(20)
         mat(173) = rxt(224)*y(20)
         mat(211) = mat(211) + rxt(226)*y(6)
         mat(90) = .500_r8*rxt(346)*y(20)

         mat(288) = -(rxt(126)*y(20) + rxt(131)*y(2) + rxt(158)*y(25))
         mat(852) = -rxt(126)*y(22)
         mat(1076) = -rxt(131)*y(22)
         mat(983) = -rxt(158)*y(22)

         mat(852) = mat(852) + 2.000_r8*rxt(124)*y(20)
         mat(1027) = 2.000_r8*rxt(130)*y(21)

         mat(683) = -(rxt(88)*y(3))
         mat(1103) = -rxt(88)*y(146)

         mat(494) = rxt(125)*y(20)
         mat(885) = rxt(125)*y(18) + 2.000_r8*rxt(123)*y(20) + rxt(148)*y(9) &
                      + rxt(154)*y(10) + rxt(223)*y(14) + rxt(215)*y(16) + rxt(122) &
                      *y(21) + rxt(126)*y(22) + rxt(175)*y(30) + rxt(179)*y(31) &
                      + rxt(195)*y(36) + rxt(243)*y(47) + rxt(237)*y(46) + rxt(266) &
                      *y(62) + rxt(250)*y(51) + rxt(230)*y(42) + .500_r8*rxt(284) &
                      *y(75) + rxt(263)*y(57) + rxt(262)*y(59) + rxt(267)*y(60) &
                      + rxt(271)*y(66) + rxt(273)*y(65) + (rxt(326)+rxt(327))*y(89) &
                      + rxt(224)*y(119) + rxt(348)*y(124)
         mat(400) = rxt(148)*y(20)
         mat(175) = rxt(154)*y(20)
         mat(181) = rxt(223)*y(20)
         mat(762) = rxt(215)*y(20)
         mat(691) = rxt(119)*y(21)
         mat(1057) = rxt(122)*y(20) + rxt(119)*y(19)
         mat(289) = rxt(126)*y(20)
         mat(1217) = rxt(175)*y(20) + (rxt(356)+rxt(361)+rxt(367))*y(31) + (rxt(357) &
                       +rxt(368))*y(37)
         mat(406) = rxt(179)*y(20) + (rxt(356)+rxt(361)+rxt(367))*y(30)
         mat(380) = rxt(195)*y(20)
         mat(366) = (rxt(357)+rxt(368))*y(30)
         mat(531) = rxt(243)*y(20)
         mat(296) = rxt(237)*y(20)
         mat(266) = rxt(266)*y(20)
         mat(215) = rxt(250)*y(20)
         mat(101) = rxt(230)*y(20)
         mat(544) = .500_r8*rxt(284)*y(20)
         mat(37) = rxt(263)*y(20)
         mat(161) = rxt(262)*y(20)
         mat(340) = rxt(267)*y(20)
         mat(167) = rxt(271)*y(20)
         mat(554) = rxt(273)*y(20)
         mat(135) = (rxt(326)+rxt(327))*y(20)
         mat(171) = rxt(224)*y(20)
         mat(30) = rxt(348)*y(20)


      end subroutine nlnmat03

      subroutine nlnmat04( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(999) = -(rxt(156)*y(1) + rxt(157)*y(18) + rxt(158)*y(22) + (rxt(159) &
                      + rxt(160)) * y(21) + rxt(161)*y(16) + rxt(178)*y(31) + rxt(182) &
                      *y(32) + rxt(228)*y(42))
         mat(973) = -rxt(156)*y(25)
         mat(497) = -rxt(157)*y(25)
         mat(291) = -rxt(158)*y(25)
         mat(1066) = -(rxt(159) + rxt(160)) * y(25)
         mat(769) = -rxt(161)*y(25)
         mat(408) = -rxt(178)*y(25)
         mat(436) = -rxt(182)*y(25)
         mat(103) = -rxt(228)*y(25)

         mat(1092) = rxt(163)*y(27) + rxt(176)*y(30)
         mat(1111) = rxt(112)*y(30)
         mat(1203) = rxt(168)*y(27)
         mat(894) = rxt(164)*y(27) + rxt(175)*y(30)
         mat(750) = rxt(167)*y(27)
         mat(1134) = rxt(163)*y(2) + rxt(168)*y(6) + rxt(164)*y(20) + rxt(167)*y(13) + ( &
                      + 4.000_r8*rxt(170)+2.000_r8*rxt(172))*y(27) + rxt(192)*y(35)
         mat(1224) = rxt(176)*y(2) + rxt(112)*y(3) + rxt(175)*y(20)
         mat(712) = rxt(192)*y(27)


         mat(981) = rxt(182)*y(32)
         mat(1121) = 2.000_r8*rxt(171)*y(27)
         mat(1211) = (rxt(356)+rxt(361)+rxt(367))*y(31) + (rxt(355)+rxt(360)+rxt(366)) &
                      *y(32)
         mat(404) = (rxt(356)+rxt(361)+rxt(367))*y(30)
         mat(428) = rxt(182)*y(25) + (rxt(355)+rxt(360)+rxt(366))*y(30)

         mat(1138) = -(rxt(163)*y(2) + (rxt(164) + rxt(165)) * y(20) + rxt(166)*y(21) &
                      + rxt(167)*y(13) + rxt(168)*y(6) + rxt(169)*y(7) + (4._r8*rxt(170) &
                      + 4._r8*rxt(171) + 4._r8*rxt(172) + 4._r8*rxt(173)) * y(27) &
                      + (rxt(191) + rxt(192) + rxt(193)) * y(35))
         mat(1096) = -rxt(163)*y(27)
         mat(898) = -(rxt(164) + rxt(165)) * y(27)
         mat(1070) = -rxt(166)*y(27)
         mat(754) = -rxt(167)*y(27)
         mat(1207) = -rxt(168)*y(27)
         mat(806) = -rxt(169)*y(27)
         mat(716) = -(rxt(191) + rxt(192) + rxt(193)) * y(27)

         mat(977) = rxt(156)*y(25)
         mat(1096) = mat(1096) + rxt(177)*y(31) + rxt(180)*y(32)
         mat(898) = mat(898) + rxt(179)*y(31)
         mat(1070) = mat(1070) + rxt(160)*y(25)
         mat(1003) = rxt(156)*y(1) + rxt(160)*y(21) + rxt(178)*y(31)
         mat(410) = rxt(177)*y(2) + rxt(179)*y(20) + rxt(178)*y(25)
         mat(438) = rxt(180)*y(2)


         mat(1120) = 2.000_r8*rxt(172)*y(27) + rxt(191)*y(35)
         mat(700) = rxt(191)*y(27)


         mat(1119) = 2.000_r8*rxt(173)*y(27)

         mat(1231) = -(rxt(112)*y(3) + rxt(175)*y(20) + rxt(176)*y(2) + (rxt(355) &
                      + rxt(360) + rxt(366)) * y(32) + (rxt(356) + rxt(361) + rxt(367) &
                      ) * y(31) + (rxt(357) + rxt(368)) * y(37))
         mat(1118) = -rxt(112)*y(30)
         mat(901) = -rxt(175)*y(30)
         mat(1099) = -rxt(176)*y(30)
         mat(439) = -(rxt(355) + rxt(360) + rxt(366)) * y(30)
         mat(411) = -(rxt(356) + rxt(361) + rxt(367)) * y(30)
         mat(372) = -(rxt(357) + rxt(368)) * y(30)

         mat(500) = rxt(157)*y(25)
         mat(901) = mat(901) + rxt(165)*y(27)
         mat(775) = rxt(161)*y(25)
         mat(1073) = rxt(159)*y(25)
         mat(294) = rxt(158)*y(25)
         mat(1006) = rxt(157)*y(18) + rxt(161)*y(16) + rxt(159)*y(21) + rxt(158)*y(22) &
                      + rxt(178)*y(31) + rxt(228)*y(42)
         mat(1141) = rxt(165)*y(20)
         mat(411) = mat(411) + rxt(178)*y(25)
         mat(104) = rxt(228)*y(25)

         mat(405) = -(rxt(177)*y(2) + rxt(178)*y(25) + rxt(179)*y(20) + (rxt(356) &
                      + rxt(361) + rxt(367)) * y(30))
         mat(1080) = -rxt(177)*y(31)
         mat(985) = -rxt(178)*y(31)
         mat(865) = -rxt(179)*y(31)
         mat(1215) = -(rxt(356) + rxt(361) + rxt(367)) * y(31)

         mat(865) = mat(865) + rxt(181)*y(32)
         mat(1040) = rxt(166)*y(27)
         mat(1123) = rxt(166)*y(21)
         mat(430) = rxt(181)*y(20)

         mat(431) = -(rxt(180)*y(2) + rxt(181)*y(20) + rxt(182)*y(25) + (rxt(355) &
                      + rxt(360) + rxt(366)) * y(30))
         mat(1081) = -rxt(180)*y(32)
         mat(867) = -rxt(181)*y(32)
         mat(986) = -rxt(182)*y(32)
         mat(1216) = -(rxt(355) + rxt(360) + rxt(366)) * y(32)

         mat(787) = rxt(169)*y(27)
         mat(1124) = rxt(169)*y(7)


         mat(1122) = rxt(193)*y(35)
         mat(1212) = (rxt(357)+rxt(368))*y(37)
         mat(701) = rxt(193)*y(27)
         mat(364) = (rxt(357)+rxt(368))*y(30)

         mat(1157) = -(rxt(183)*y(1) + rxt(184)*y(21) + rxt(185)*y(16))
         mat(978) = -rxt(183)*y(34)
         mat(1071) = -rxt(184)*y(34)
         mat(773) = -rxt(185)*y(34)

         mat(1097) = rxt(186)*y(35) + rxt(196)*y(36)
         mat(1116) = rxt(113)*y(36)
         mat(1208) = rxt(189)*y(35)
         mat(899) = rxt(187)*y(35) + rxt(195)*y(36)
         mat(1139) = (rxt(191)+rxt(192))*y(35)
         mat(717) = rxt(186)*y(2) + rxt(189)*y(6) + rxt(187)*y(20) + (rxt(191) &
                       +rxt(192))*y(27) + 4.000_r8*rxt(194)*y(35)
         mat(385) = rxt(196)*y(2) + rxt(113)*y(3) + rxt(195)*y(20)

         mat(707) = -(rxt(186)*y(2) + rxt(187)*y(20) + rxt(188)*y(21) + rxt(189)*y(6) &
                      + rxt(190)*y(7) + (rxt(191) + rxt(192) + rxt(193)) * y(27) &
                      + 4._r8*rxt(194)*y(35))
         mat(1086) = -rxt(186)*y(35)
         mat(887) = -rxt(187)*y(35)
         mat(1059) = -rxt(188)*y(35)
         mat(1196) = -rxt(189)*y(35)
         mat(795) = -rxt(190)*y(35)
         mat(1127) = -(rxt(191) + rxt(192) + rxt(193)) * y(35)

         mat(966) = rxt(183)*y(34)
         mat(1086) = mat(1086) + rxt(197)*y(37) + rxt(198)*y(38)
         mat(1146) = rxt(183)*y(1)
         mat(367) = rxt(197)*y(2)
         mat(234) = rxt(198)*y(2)

         mat(379) = -(rxt(113)*y(3) + rxt(195)*y(20) + rxt(196)*y(2))
         mat(1101) = -rxt(113)*y(36)
         mat(862) = -rxt(195)*y(36)
         mat(1078) = -rxt(196)*y(36)

         mat(758) = rxt(185)*y(34)
         mat(1038) = rxt(184)*y(34)
         mat(1142) = rxt(185)*y(16) + rxt(184)*y(21)

         mat(365) = -(rxt(197)*y(2) + (rxt(357) + rxt(368)) * y(30))
         mat(1077) = -rxt(197)*y(37)
         mat(1213) = -(rxt(357) + rxt(368)) * y(37)

         mat(1036) = rxt(188)*y(35)
         mat(703) = rxt(188)*y(21)

         mat(231) = -(rxt(198)*y(2))
         mat(1075) = -rxt(198)*y(38)

         mat(781) = rxt(190)*y(35)
         mat(702) = rxt(190)*y(7)

         mat(465) = -(rxt(256)*y(20) + rxt(257)*y(1) + rxt(258)*y(8))
         mat(870) = -rxt(256)*y(56)
         mat(950) = -rxt(257)*y(56)
         mat(913) = -rxt(258)*y(56)

         mat(950) = mat(950) + .070_r8*rxt(303)*y(80)
         mat(414) = .070_r8*rxt(303)*y(1)

         mat(413) = -(rxt(302)*y(20) + rxt(303)*y(1) + rxt(304)*y(8))
         mat(866) = -rxt(302)*y(80)
         mat(949) = -rxt(303)*y(80)
         mat(911) = -rxt(304)*y(80)

         mat(344) = -(rxt(264)*y(6) + rxt(265)*y(21))
         mat(1175) = -rxt(264)*y(61)
         mat(1034) = -rxt(265)*y(61)

         mat(859) = rxt(256)*y(56) + .500_r8*rxt(266)*y(62)
         mat(464) = rxt(256)*y(20)
         mat(263) = .500_r8*rxt(266)*y(20)

         mat(529) = -(rxt(243)*y(20) + rxt(244)*y(8))
         mat(876) = -rxt(243)*y(47)
         mat(918) = -rxt(244)*y(47)

         mat(955) = .500_r8*rxt(257)*y(56) + .040_r8*rxt(279)*y(74)
         mat(1185) = rxt(264)*y(61) + rxt(277)*y(70) + .400_r8*rxt(318)*y(81) &
                      + rxt(281)*y(71) + rxt(238)*y(43) + .270_r8*rxt(259)*y(58)
         mat(876) = mat(876) + .500_r8*rxt(242)*y(44) + rxt(253)*y(48)
         mat(733) = .800_r8*rxt(240)*y(43)
         mat(468) = .500_r8*rxt(257)*y(1)
         mat(346) = rxt(264)*y(6)
         mat(113) = rxt(277)*y(6)
         mat(329) = .400_r8*rxt(318)*y(6)
         mat(312) = rxt(281)*y(6)
         mat(581) = .040_r8*rxt(279)*y(1)
         mat(357) = rxt(238)*y(6) + .800_r8*rxt(240)*y(13) + 3.200_r8*rxt(241)*y(43)
         mat(130) = .500_r8*rxt(242)*y(20)
         mat(390) = .270_r8*rxt(259)*y(6)
         mat(92) = rxt(253)*y(20)

         mat(295) = -(rxt(237)*y(20))
         mat(853) = -rxt(237)*y(46)

         mat(947) = .250_r8*rxt(257)*y(56) + .200_r8*rxt(303)*y(80)
         mat(724) = .100_r8*rxt(248)*y(45)
         mat(1028) = .250_r8*rxt(247)*y(45) + .250_r8*rxt(295)*y(73)
         mat(463) = .250_r8*rxt(257)*y(1)
         mat(412) = .200_r8*rxt(303)*y(1)
         mat(659) = .100_r8*rxt(248)*y(13) + .250_r8*rxt(247)*y(21)
         mat(641) = .250_r8*rxt(295)*y(21)

         mat(262) = -(rxt(266)*y(20))
         mat(849) = -rxt(266)*y(62)

         mat(1025) = rxt(265)*y(61)
         mat(343) = rxt(265)*y(21)

         mat(671) = -(rxt(245)*y(6) + rxt(246)*y(7) + rxt(247)*y(21) + rxt(248)*y(13) &
                      + 4._r8*rxt(249)*y(45) + rxt(291)*y(76) + rxt(310)*y(85) + rxt(325) &
                      *y(88))
         mat(1193) = -rxt(245)*y(45)
         mat(792) = -rxt(246)*y(45)
         mat(1056) = -rxt(247)*y(45)
         mat(741) = -rxt(248)*y(45)
         mat(606) = -rxt(291)*y(45)
         mat(628) = -rxt(310)*y(45)
         mat(568) = -rxt(325)*y(45)

         mat(1193) = mat(1193) + rxt(281)*y(71) + .530_r8*rxt(286)*y(76) + rxt(293) &
                      *y(73) + rxt(268)*y(64)
         mat(884) = rxt(243)*y(47) + .500_r8*rxt(250)*y(51) + rxt(273)*y(65)
         mat(926) = rxt(244)*y(47) + .530_r8*rxt(288)*y(76) + rxt(294)*y(73) &
                      + rxt(274)*y(65)
         mat(741) = mat(741) + .260_r8*rxt(290)*y(76) + rxt(296)*y(73) &
                      + .300_r8*rxt(270)*y(64)
         mat(530) = rxt(243)*y(20) + rxt(244)*y(8)
         mat(671) = mat(671) + .530_r8*rxt(291)*y(76)
         mat(214) = .500_r8*rxt(250)*y(20)
         mat(313) = rxt(281)*y(6)
         mat(606) = mat(606) + .530_r8*rxt(286)*y(6) + .530_r8*rxt(288)*y(8) &
                      + .260_r8*rxt(290)*y(13) + .530_r8*rxt(291)*y(45)
         mat(645) = rxt(293)*y(6) + rxt(294)*y(8) + rxt(296)*y(13) + 4.000_r8*rxt(298) &
                      *y(73)
         mat(454) = rxt(268)*y(6) + .300_r8*rxt(270)*y(13)
         mat(553) = rxt(273)*y(20) + rxt(274)*y(8)


      end subroutine nlnmat04

      subroutine nlnmat05( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(213) = -(rxt(250)*y(20))
         mat(843) = -rxt(250)*y(51)

         mat(1021) = .750_r8*rxt(247)*y(45) + .750_r8*rxt(295)*y(73)
         mat(658) = .750_r8*rxt(247)*y(21)
         mat(639) = .750_r8*rxt(295)*y(21)

         mat(198) = -(rxt(255)*y(20))
         mat(842) = -rxt(255)*y(55)

         mat(780) = rxt(246)*y(45)
         mat(657) = rxt(246)*y(7)

         mat(154) = -(rxt(275)*y(20))
         mat(834) = -rxt(275)*y(79)

         mat(1164) = .100_r8*rxt(318)*y(81)
         mat(906) = rxt(258)*y(56)
         mat(462) = rxt(258)*y(8)
         mat(322) = .100_r8*rxt(318)*y(6)

         mat(99) = -(rxt(228)*y(25) + rxt(230)*y(20))
         mat(982) = -rxt(228)*y(42)
         mat(825) = -rxt(230)*y(42)

         mat(137) = -(rxt(231)*y(20) + rxt(236)*y(1))
         mat(831) = -rxt(231)*y(41)
         mat(943) = -rxt(236)*y(41)

         mat(23) = -(rxt(314)*y(20))
         mat(811) = -rxt(314)*y(68)

         mat(254) = -(rxt(301)*y(20))
         mat(848) = -rxt(301)*y(78)

         mat(783) = rxt(299)*y(73)
         mat(640) = rxt(299)*y(7)

         mat(26) = -(rxt(276)*y(20))
         mat(812) = -rxt(276)*y(67)

         mat(111) = -(rxt(277)*y(6))
         mat(1162) = -rxt(277)*y(70)

         mat(826) = rxt(276)*y(67)
         mat(27) = rxt(276)*y(20)

         mat(326) = -(rxt(318)*y(6) + rxt(319)*y(21))
         mat(1173) = -rxt(318)*y(81)
         mat(1032) = -rxt(319)*y(81)

         mat(857) = rxt(314)*y(68) + rxt(320)*y(82)
         mat(24) = rxt(314)*y(20)
         mat(302) = rxt(320)*y(20)

         mat(300) = -(rxt(320)*y(20))
         mat(854) = -rxt(320)*y(82)

         mat(1029) = rxt(319)*y(81)
         mat(324) = rxt(319)*y(21)

         mat(186) = -(rxt(280)*y(20))
         mat(840) = -rxt(280)*y(69)

         mat(1166) = .800_r8*rxt(318)*y(81)
         mat(323) = .800_r8*rxt(318)*y(6)

         mat(311) = -(rxt(281)*y(6) + rxt(282)*y(21))
         mat(1171) = -rxt(281)*y(71)
         mat(1030) = -rxt(282)*y(71)

         mat(855) = rxt(280)*y(69) + rxt(283)*y(72)
         mat(187) = rxt(280)*y(20)
         mat(119) = rxt(283)*y(20)

         mat(118) = -(rxt(283)*y(20))
         mat(827) = -rxt(283)*y(72)

         mat(1009) = rxt(282)*y(71)
         mat(310) = rxt(282)*y(21)

         mat(42) = -(rxt(328)*y(20))
         mat(816) = -rxt(328)*y(91)

         mat(47) = -(rxt(332)*y(20))
         mat(817) = -rxt(332)*y(92)

         mat(817) = mat(817) + .250_r8*rxt(328)*y(91)
         mat(43) = .250_r8*rxt(328)*y(20)

         mat(240) = -(rxt(329)*y(6) + rxt(330)*y(21))
         mat(1168) = -rxt(329)*y(93)
         mat(1023) = -rxt(330)*y(93)

         mat(846) = .700_r8*rxt(328)*y(91) + rxt(331)*y(94)
         mat(44) = .700_r8*rxt(328)*y(20)
         mat(149) = rxt(331)*y(20)

         mat(148) = -(rxt(331)*y(20))
         mat(833) = -rxt(331)*y(94)

         mat(1013) = rxt(330)*y(93)
         mat(239) = rxt(330)*y(21)

         mat(64) = -(rxt(333)*y(7))
         mat(776) = -rxt(333)*y(95)

         mat(820) = rxt(332)*y(92)
         mat(48) = rxt(332)*y(20)

         mat(508) = -(rxt(337)*y(6) + rxt(338)*y(21))
         mat(1183) = -rxt(337)*y(97)
         mat(1046) = -rxt(338)*y(97)

         mat(874) = rxt(339)*y(98) + rxt(334)*y(96)
         mat(916) = rxt(336)*y(96)
         mat(193) = rxt(339)*y(20)
         mat(271) = rxt(334)*y(20) + rxt(336)*y(8)

         mat(191) = -(rxt(339)*y(20))
         mat(841) = -rxt(339)*y(98)

         mat(1019) = rxt(338)*y(97)
         mat(505) = rxt(338)*y(21)


         mat(1169) = .900_r8*rxt(329)*y(93)
         mat(782) = .700_r8*rxt(333)*y(95)
         mat(241) = .900_r8*rxt(329)*y(6)
         mat(65) = .700_r8*rxt(333)*y(7)

         mat(318) = -(rxt(252)*y(20))
         mat(856) = -rxt(252)*y(50)

         mat(1172) = .450_r8*rxt(329)*y(93) + .250_r8*rxt(321)*y(88)
         mat(856) = mat(856) + .200_r8*rxt(251)*y(49) + .650_r8*rxt(229)*y(118)
         mat(908) = .250_r8*rxt(322)*y(88)
         mat(725) = .100_r8*rxt(324)*y(88)
         mat(660) = .250_r8*rxt(325)*y(88)
         mat(242) = .450_r8*rxt(329)*y(6)
         mat(373) = .200_r8*rxt(251)*y(20)
         mat(562) = .250_r8*rxt(321)*y(6) + .250_r8*rxt(322)*y(8) + .100_r8*rxt(324) &
                      *y(13) + .250_r8*rxt(325)*y(45)
         mat(58) = .650_r8*rxt(229)*y(20)

         mat(626) = -(rxt(305)*y(6) + rxt(306)*y(8) + rxt(307)*y(21) + rxt(309)*y(13) &
                      + rxt(310)*y(45))
         mat(1191) = -rxt(305)*y(85)
         mat(924) = -rxt(306)*y(85)
         mat(1054) = -rxt(307)*y(85)
         mat(739) = -rxt(309)*y(85)
         mat(669) = -rxt(310)*y(85)

         mat(882) = rxt(302)*y(80) + .200_r8*rxt(308)*y(90)
         mat(419) = rxt(302)*y(20)
         mat(227) = .200_r8*rxt(308)*y(20)

         mat(583) = -(rxt(278)*y(20) + rxt(279)*y(1))
         mat(880) = -rxt(278)*y(74)
         mat(959) = -rxt(279)*y(74)

         mat(959) = mat(959) + .200_r8*rxt(303)*y(80) + rxt(335)*y(96)
         mat(1189) = rxt(337)*y(97) + .320_r8*rxt(305)*y(85) + .039_r8*rxt(311)*y(86)
         mat(922) = .350_r8*rxt(306)*y(85) + .039_r8*rxt(312)*y(86)
         mat(737) = .260_r8*rxt(309)*y(85)
         mat(1052) = .039_r8*rxt(313)*y(86)
         mat(418) = .200_r8*rxt(303)*y(1)
         mat(667) = .350_r8*rxt(310)*y(85)
         mat(512) = rxt(337)*y(6)
         mat(624) = .320_r8*rxt(305)*y(6) + .350_r8*rxt(306)*y(8) + .260_r8*rxt(309) &
                      *y(13) + .350_r8*rxt(310)*y(45)
         mat(273) = rxt(335)*y(1)
         mat(485) = .039_r8*rxt(311)*y(6) + .039_r8*rxt(312)*y(8) + .039_r8*rxt(313) &
                      *y(21)

         mat(539) = -(rxt(284)*y(20) + rxt(285)*y(1))
         mat(877) = -rxt(284)*y(75)
         mat(956) = -rxt(285)*y(75)

         mat(956) = mat(956) + .400_r8*rxt(303)*y(80) + rxt(335)*y(96)
         mat(1186) = rxt(337)*y(97) + .230_r8*rxt(305)*y(85) + .167_r8*rxt(311)*y(86)
         mat(919) = .250_r8*rxt(306)*y(85) + .167_r8*rxt(312)*y(86)
         mat(734) = .190_r8*rxt(309)*y(85)
         mat(1049) = .167_r8*rxt(313)*y(86)
         mat(417) = .400_r8*rxt(303)*y(1)
         mat(664) = .250_r8*rxt(310)*y(85)
         mat(510) = rxt(337)*y(6)
         mat(621) = .230_r8*rxt(305)*y(6) + .250_r8*rxt(306)*y(8) + .190_r8*rxt(309) &
                      *y(13) + .250_r8*rxt(310)*y(45)
         mat(272) = rxt(335)*y(1)
         mat(483) = .167_r8*rxt(311)*y(6) + .167_r8*rxt(312)*y(8) + .167_r8*rxt(313) &
                      *y(21)

         mat(604) = -((rxt(286) + rxt(287)) * y(6) + rxt(288)*y(8) + rxt(289)*y(21) &
                      + rxt(290)*y(13) + rxt(291)*y(45))
         mat(1190) = -(rxt(286) + rxt(287)) * y(76)
         mat(923) = -rxt(288)*y(76)
         mat(1053) = -rxt(289)*y(76)
         mat(738) = -rxt(290)*y(76)
         mat(668) = -rxt(291)*y(76)

         mat(881) = rxt(278)*y(74) + .500_r8*rxt(284)*y(75) + .200_r8*rxt(292)*y(77)
         mat(584) = rxt(278)*y(20)
         mat(541) = .500_r8*rxt(284)*y(20)
         mat(124) = .200_r8*rxt(292)*y(20)

         mat(123) = -(rxt(292)*y(20))
         mat(828) = -rxt(292)*y(77)

         mat(1010) = rxt(289)*y(76)
         mat(596) = rxt(289)*y(21)

         mat(644) = -(rxt(293)*y(6) + rxt(294)*y(8) + rxt(295)*y(21) + rxt(296)*y(13) &
                      + rxt(297)*y(45) + 4._r8*rxt(298)*y(73) + rxt(299)*y(7))
         mat(1192) = -rxt(293)*y(73)
         mat(925) = -rxt(294)*y(73)
         mat(1055) = -rxt(295)*y(73)
         mat(740) = -rxt(296)*y(73)
         mat(670) = -rxt(297)*y(73)
         mat(791) = -rxt(299)*y(73)

         mat(962) = .200_r8*rxt(303)*y(80)
         mat(883) = .500_r8*rxt(284)*y(75) + .500_r8*rxt(292)*y(77)
         mat(420) = .200_r8*rxt(303)*y(1)
         mat(542) = .500_r8*rxt(284)*y(20)
         mat(125) = .500_r8*rxt(292)*y(20)

         mat(356) = -(rxt(238)*y(6) + rxt(239)*y(21) + rxt(240)*y(13) + 4._r8*rxt(241) &
                      *y(43))
         mat(1176) = -rxt(238)*y(43)
         mat(1035) = -rxt(239)*y(43)
         mat(727) = -rxt(240)*y(43)

         mat(860) = rxt(230)*y(42) + .500_r8*rxt(242)*y(44)
         mat(984) = rxt(228)*y(42)
         mat(100) = rxt(230)*y(20) + rxt(228)*y(25)
         mat(129) = .500_r8*rxt(242)*y(20)

         mat(128) = -(rxt(242)*y(20))
         mat(829) = -rxt(242)*y(44)

         mat(1011) = rxt(239)*y(43)
         mat(354) = rxt(239)*y(21)

         mat(270) = -(rxt(334)*y(20) + rxt(335)*y(1) + rxt(336)*y(8))
         mat(850) = -rxt(334)*y(96)
         mat(945) = -rxt(335)*y(96)
         mat(907) = -rxt(336)*y(96)

         mat(35) = -(rxt(263)*y(20))
         mat(815) = -rxt(263)*y(57)

         mat(388) = -(rxt(259)*y(6) + rxt(260)*y(21) + rxt(261)*y(13))
         mat(1178) = -rxt(259)*y(58)
         mat(1039) = -rxt(260)*y(58)
         mat(729) = -rxt(261)*y(58)

         mat(863) = rxt(263)*y(57) + rxt(262)*y(59)
         mat(36) = rxt(263)*y(20)
         mat(160) = rxt(262)*y(20)

         mat(158) = -(rxt(262)*y(20))
         mat(835) = -rxt(262)*y(59)

         mat(1014) = rxt(260)*y(58)
         mat(386) = rxt(260)*y(21)


      end subroutine nlnmat05

      subroutine nlnmat06( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(337) = -(rxt(267)*y(20))
         mat(858) = -rxt(267)*y(60)

         mat(1174) = .500_r8*rxt(277)*y(70) + .250_r8*rxt(318)*y(81) &
                      + .100_r8*rxt(337)*y(97) + .820_r8*rxt(259)*y(58)
         mat(726) = .820_r8*rxt(261)*y(58)
         mat(112) = .500_r8*rxt(277)*y(6)
         mat(327) = .250_r8*rxt(318)*y(6)
         mat(506) = .100_r8*rxt(337)*y(6)
         mat(387) = .820_r8*rxt(259)*y(6) + .820_r8*rxt(261)*y(13)

         mat(164) = -(rxt(271)*y(20))
         mat(836) = -rxt(271)*y(66)

         mat(1015) = rxt(269)*y(64)
         mat(449) = rxt(269)*y(21)

         mat(219) = -(rxt(222)*y(20))
         mat(844) = -rxt(222)*y(15)

         mat(723) = 2.000_r8*rxt(221)*y(13) + .250_r8*rxt(309)*y(85) &
                      + .250_r8*rxt(290)*y(76) + .300_r8*rxt(240)*y(43) &
                      + .500_r8*rxt(270)*y(64) + .300_r8*rxt(324)*y(88)
         mat(617) = .250_r8*rxt(309)*y(13)
         mat(597) = .250_r8*rxt(290)*y(13)
         mat(355) = .300_r8*rxt(240)*y(13)
         mat(450) = .500_r8*rxt(270)*y(13)
         mat(561) = .300_r8*rxt(324)*y(13)

         mat(91) = -(rxt(253)*y(20))
         mat(824) = -rxt(253)*y(48)

         mat(720) = .200_r8*rxt(240)*y(43)
         mat(353) = .200_r8*rxt(240)*y(13) + .800_r8*rxt(241)*y(43)

         mat(374) = -(rxt(251)*y(20))
         mat(861) = -rxt(251)*y(49)

         mat(1177) = .530_r8*rxt(286)*y(76) + .250_r8*rxt(321)*y(88)
         mat(909) = .530_r8*rxt(288)*y(76) + .250_r8*rxt(322)*y(88)
         mat(728) = .260_r8*rxt(290)*y(76) + .100_r8*rxt(324)*y(88)
         mat(661) = .530_r8*rxt(291)*y(76) + .250_r8*rxt(325)*y(88)
         mat(598) = .530_r8*rxt(286)*y(6) + .530_r8*rxt(288)*y(8) + .260_r8*rxt(290) &
                      *y(13) + .530_r8*rxt(291)*y(45)
         mat(563) = .250_r8*rxt(321)*y(6) + .250_r8*rxt(322)*y(8) + .100_r8*rxt(324) &
                      *y(13) + .250_r8*rxt(325)*y(45)

         mat(521) = -(rxt(272)*y(20))
         mat(875) = -rxt(272)*y(63)

         mat(1184) = .220_r8*rxt(286)*y(76) + .250_r8*rxt(321)*y(88)
         mat(875) = mat(875) + .500_r8*rxt(266)*y(62) + .500_r8*rxt(301)*y(78)
         mat(917) = .220_r8*rxt(288)*y(76) + .250_r8*rxt(322)*y(88)
         mat(732) = .230_r8*rxt(290)*y(76) + .200_r8*rxt(270)*y(64) + .100_r8*rxt(324) &
                      *y(88)
         mat(264) = .500_r8*rxt(266)*y(20)
         mat(663) = .220_r8*rxt(291)*y(76) + .250_r8*rxt(325)*y(88)
         mat(255) = .500_r8*rxt(301)*y(20)
         mat(601) = .220_r8*rxt(286)*y(6) + .220_r8*rxt(288)*y(8) + .230_r8*rxt(290) &
                      *y(13) + .220_r8*rxt(291)*y(45)
         mat(452) = .200_r8*rxt(270)*y(13)
         mat(565) = .250_r8*rxt(321)*y(6) + .250_r8*rxt(322)*y(8) + .100_r8*rxt(324) &
                      *y(13) + .250_r8*rxt(325)*y(45)

         mat(281) = -(rxt(232)*y(6) + rxt(233)*y(21))
         mat(1170) = -rxt(232)*y(52)
         mat(1026) = -rxt(233)*y(52)

         mat(851) = rxt(231)*y(41)
         mat(139) = rxt(231)*y(20)


         mat(1161) = .750_r8*rxt(232)*y(52)
         mat(280) = .750_r8*rxt(232)*y(6)


         mat(1007) = rxt(233)*y(52)
         mat(279) = rxt(233)*y(21)

         mat(145) = -(rxt(317)*y(20))
         mat(832) = -rxt(317)*y(84)

         mat(1163) = .370_r8*rxt(305)*y(85)
         mat(832) = mat(832) + rxt(315)*y(87)
         mat(905) = .400_r8*rxt(306)*y(85) + rxt(316)*y(87)
         mat(721) = .300_r8*rxt(309)*y(85)
         mat(656) = .400_r8*rxt(310)*y(85)
         mat(616) = .370_r8*rxt(305)*y(6) + .400_r8*rxt(306)*y(8) + .300_r8*rxt(309) &
                      *y(13) + .400_r8*rxt(310)*y(45)
         mat(440) = rxt(315)*y(20) + rxt(316)*y(8)

         mat(451) = -(rxt(268)*y(6) + rxt(269)*y(21) + rxt(270)*y(13))
         mat(1180) = -rxt(268)*y(64)
         mat(1042) = -rxt(269)*y(64)
         mat(730) = -rxt(270)*y(64)

         mat(869) = rxt(267)*y(60) + rxt(271)*y(66)
         mat(338) = rxt(267)*y(20)
         mat(165) = rxt(271)*y(20)

         mat(552) = -(rxt(273)*y(20) + rxt(274)*y(8))
         mat(878) = -rxt(273)*y(65)
         mat(920) = -rxt(274)*y(65)

         mat(957) = .950_r8*rxt(279)*y(74) + .800_r8*rxt(285)*y(75)
         mat(1187) = .450_r8*rxt(329)*y(93) + .250_r8*rxt(286)*y(76) &
                      + .250_r8*rxt(321)*y(88)
         mat(878) = mat(878) + rxt(275)*y(79) + rxt(272)*y(63)
         mat(920) = mat(920) + .250_r8*rxt(288)*y(76) + .250_r8*rxt(322)*y(88)
         mat(735) = .240_r8*rxt(290)*y(76) + .500_r8*rxt(270)*y(64) + .100_r8*rxt(324) &
                      *y(88)
         mat(665) = .250_r8*rxt(291)*y(76) + .250_r8*rxt(325)*y(88)
         mat(155) = rxt(275)*y(20)
         mat(243) = .450_r8*rxt(329)*y(6)
         mat(582) = .950_r8*rxt(279)*y(1)
         mat(540) = .800_r8*rxt(285)*y(1)
         mat(602) = .250_r8*rxt(286)*y(6) + .250_r8*rxt(288)*y(8) + .240_r8*rxt(290) &
                      *y(13) + .250_r8*rxt(291)*y(45)
         mat(522) = rxt(272)*y(20)
         mat(453) = .500_r8*rxt(270)*y(13)
         mat(566) = .250_r8*rxt(321)*y(6) + .250_r8*rxt(322)*y(8) + .100_r8*rxt(324) &
                      *y(13) + .250_r8*rxt(325)*y(45)

         mat(481) = -(rxt(311)*y(6) + rxt(312)*y(8) + rxt(313)*y(21))
         mat(1181) = -rxt(311)*y(86)
         mat(914) = -rxt(312)*y(86)
         mat(1043) = -rxt(313)*y(86)

         mat(914) = mat(914) + rxt(304)*y(80)
         mat(415) = rxt(304)*y(8)

         mat(441) = -(rxt(315)*y(20) + rxt(316)*y(8))
         mat(868) = -rxt(315)*y(87)
         mat(912) = -rxt(316)*y(87)

         mat(1179) = .080_r8*rxt(305)*y(85) + .800_r8*rxt(287)*y(76) &
                      + .794_r8*rxt(311)*y(86)
         mat(912) = mat(912) + .794_r8*rxt(312)*y(86)
         mat(1041) = .794_r8*rxt(313)*y(86)
         mat(619) = .080_r8*rxt(305)*y(6)
         mat(599) = .800_r8*rxt(287)*y(6)
         mat(480) = .794_r8*rxt(311)*y(6) + .794_r8*rxt(312)*y(8) + .794_r8*rxt(313) &
                      *y(21)

         mat(567) = -(rxt(321)*y(6) + rxt(322)*y(8) + rxt(323)*y(21) + rxt(324)*y(13) &
                      + rxt(325)*y(45))
         mat(1188) = -rxt(321)*y(88)
         mat(921) = -rxt(322)*y(88)
         mat(1051) = -rxt(323)*y(88)
         mat(736) = -rxt(324)*y(88)
         mat(666) = -rxt(325)*y(88)

         mat(879) = rxt(317)*y(84) + rxt(326)*y(89) + .800_r8*rxt(308)*y(90)
         mat(146) = rxt(317)*y(20)
         mat(134) = rxt(326)*y(20)
         mat(225) = .800_r8*rxt(308)*y(20)

         mat(133) = -((rxt(326) + rxt(327)) * y(20))
         mat(830) = -(rxt(326) + rxt(327)) * y(89)

         mat(1012) = rxt(313)*y(86) + rxt(323)*y(88)
         mat(479) = rxt(313)*y(21)
         mat(560) = rxt(323)*y(21)

         mat(223) = -(rxt(308)*y(20))
         mat(845) = -rxt(308)*y(90)

         mat(1022) = rxt(307)*y(85)
         mat(618) = rxt(307)*y(21)

         mat(56) = -(rxt(229)*y(20))
         mat(819) = -rxt(229)*y(118)

         mat(170) = -(rxt(224)*y(20))
         mat(837) = -rxt(224)*y(119)

         mat(944) = .500_r8*rxt(236)*y(41)
         mat(1165) = rxt(226)*y(120)
         mat(837) = mat(837) + .350_r8*rxt(229)*y(118)
         mat(1016) = rxt(227)*y(120)
         mat(138) = .500_r8*rxt(236)*y(1)
         mat(57) = .350_r8*rxt(229)*y(20)
         mat(205) = rxt(226)*y(6) + rxt(227)*y(21)

         mat(206) = -(rxt(226)*y(6) + rxt(227)*y(21))
         mat(1167) = -rxt(226)*y(120)
         mat(1020) = -rxt(227)*y(120)

         mat(757) = rxt(217)*y(21)
         mat(1020) = mat(1020) + rxt(217)*y(16)

         mat(80) = -(rxt(350)*y(2) + rxt(351)*y(20))
         mat(1074) = -rxt(350)*y(121)
         mat(822) = -rxt(351)*y(121)

         mat(54) = -(rxt(344)*y(20))
         mat(818) = -rxt(344)*y(122)

         mat(818) = mat(818) + rxt(351)*y(121) + (rxt(345)+.500_r8*rxt(346))*y(123)
         mat(902) = rxt(347)*y(123)
         mat(79) = rxt(351)*y(20)
         mat(85) = (rxt(345)+.500_r8*rxt(346))*y(20) + rxt(347)*y(8)

         mat(86) = -((rxt(345) + rxt(346)) * y(20) + rxt(347)*y(8))
         mat(823) = -(rxt(345) + rxt(346)) * y(123)
         mat(903) = -rxt(347)*y(123)

         mat(29) = -(rxt(348)*y(20))
         mat(813) = -rxt(348)*y(124)




         mat(810) = rxt(344)*y(122)
         mat(53) = rxt(344)*y(20)
      end subroutine nlnmat06
      subroutine nlnmat_finit( mat, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(inout) :: mat(nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
         mat( 1) = lmat( 1)
         mat( 2) = lmat( 2)
         mat( 3) = lmat( 3)
         mat( 4) = lmat( 4)
         mat( 5) = lmat( 5)
         mat( 6) = lmat( 6)
         mat( 7) = lmat( 7)
         mat( 8) = lmat( 8)
         mat( 9) = lmat( 9)
         mat( 10) = lmat( 10)
         mat( 11) = lmat( 11)
         mat( 12) = lmat( 12)
         mat( 13) = lmat( 13)
         mat( 14) = lmat( 14)
         mat( 15) = lmat( 15)
         mat( 16) = lmat( 16)
         mat( 17) = lmat( 17)
         mat( 18) = lmat( 18)
         mat( 19) = lmat( 19)
         mat( 20) = lmat( 20)
         mat( 21) = lmat( 21)
         mat( 22) = lmat( 22)
         mat( 23) = mat( 23) + lmat( 23)
         mat( 26) = mat( 26) + lmat( 26)
         mat( 29) = mat( 29) + lmat( 29)
         mat( 32) = mat( 32) + lmat( 32)
         mat( 35) = mat( 35) + lmat( 35)
         mat( 39) = lmat( 39)
         mat( 40) = lmat( 40)
         mat( 41) = lmat( 41)
         mat( 42) = mat( 42) + lmat( 42)
         mat( 47) = mat( 47) + lmat( 47)
         mat( 50) = lmat( 50)
         mat( 51) = lmat( 51)
         mat( 52) = lmat( 52)
         mat( 54) = mat( 54) + lmat( 54)
         mat( 56) = mat( 56) + lmat( 56)
         mat( 62) = lmat( 62)
         mat( 63) = lmat( 63)
         mat( 64) = mat( 64) + lmat( 64)
         mat( 68) = mat( 68) + lmat( 68)
         mat( 70) = mat( 70) + lmat( 70)
         mat( 71) = mat( 71) + lmat( 71)
         mat( 72) = mat( 72) + lmat( 72)
         mat( 76) = lmat( 76)
         mat( 77) = lmat( 77)
         mat( 78) = lmat( 78)
         mat( 80) = mat( 80) + lmat( 80)
         mat( 81) = mat( 81) + lmat( 81)
         mat( 86) = mat( 86) + lmat( 86)
         mat( 91) = mat( 91) + lmat( 91)
         mat( 95) = lmat( 95)
         mat( 96) = lmat( 96)
         mat( 97) = lmat( 97)
         mat( 98) = lmat( 98)
         mat( 99) = mat( 99) + lmat( 99)
         mat( 105) = lmat( 105)
         mat( 106) = lmat( 106)
         mat( 107) = lmat( 107)
         mat( 108) = lmat( 108)
         mat( 109) = lmat( 109)
         mat( 110) = lmat( 110)
         mat( 111) = mat( 111) + lmat( 111)
         mat( 118) = mat( 118) + lmat( 118)
         mat( 120) = lmat( 120)
         mat( 121) = lmat( 121)
         mat( 122) = mat( 122) + lmat( 122)
         mat( 123) = mat( 123) + lmat( 123)
         mat( 128) = mat( 128) + lmat( 128)
         mat( 130) = mat( 130) + lmat( 130)
         mat( 131) = mat( 131) + lmat( 131)
         mat( 132) = lmat( 132)
         mat( 133) = mat( 133) + lmat( 133)
         mat( 136) = mat( 136) + lmat( 136)
         mat( 137) = mat( 137) + lmat( 137)
         mat( 145) = mat( 145) + lmat( 145)
         mat( 148) = mat( 148) + lmat( 148)
         mat( 150) = lmat( 150)
         mat( 151) = lmat( 151)
         mat( 152) = lmat( 152)
         mat( 153) = mat( 153) + lmat( 153)
         mat( 154) = mat( 154) + lmat( 154)
         mat( 158) = mat( 158) + lmat( 158)
         mat( 159) = lmat( 159)
         mat( 162) = mat( 162) + lmat( 162)
         mat( 163) = lmat( 163)
         mat( 164) = mat( 164) + lmat( 164)
         mat( 166) = lmat( 166)
         mat( 168) = lmat( 168)
         mat( 169) = mat( 169) + lmat( 169)
         mat( 170) = mat( 170) + lmat( 170)
         mat( 174) = mat( 174) + lmat( 174)
         mat( 176) = mat( 176) + lmat( 176)
         mat( 177) = mat( 177) + lmat( 177)
         mat( 178) = lmat( 178)
         mat( 179) = lmat( 179)
         mat( 180) = mat( 180) + lmat( 180)
         mat( 182) = lmat( 182)
         mat( 184) = mat( 184) + lmat( 184)
         mat( 185) = mat( 185) + lmat( 185)
         mat( 186) = mat( 186) + lmat( 186)
         mat( 188) = lmat( 188)
         mat( 189) = lmat( 189)
         mat( 191) = mat( 191) + lmat( 191)
         mat( 192) = lmat( 192)
         mat( 194) = lmat( 194)
         mat( 195) = lmat( 195)
         mat( 196) = mat( 196) + lmat( 196)
         mat( 197) = lmat( 197)
         mat( 198) = mat( 198) + lmat( 198)
         mat( 199) = lmat( 199)
         mat( 200) = lmat( 200)
         mat( 202) = lmat( 202)
         mat( 204) = mat( 204) + lmat( 204)
         mat( 206) = mat( 206) + lmat( 206)
         mat( 208) = lmat( 208)
         mat( 211) = mat( 211) + lmat( 211)
         mat( 213) = mat( 213) + lmat( 213)
         mat( 216) = lmat( 216)
         mat( 218) = mat( 218) + lmat( 218)
         mat( 219) = mat( 219) + lmat( 219)
         mat( 223) = mat( 223) + lmat( 223)
         mat( 224) = lmat( 224)
         mat( 226) = lmat( 226)
         mat( 228) = lmat( 228)
         mat( 230) = lmat( 230)
         mat( 231) = mat( 231) + lmat( 231)
         mat( 232) = lmat( 232)
         mat( 233) = lmat( 233)
         mat( 234) = mat( 234) + lmat( 234)
         mat( 235) = lmat( 235)
         mat( 236) = mat( 236) + lmat( 236)
         mat( 238) = lmat( 238)
         mat( 240) = mat( 240) + lmat( 240)
         mat( 248) = lmat( 248)
         mat( 249) = lmat( 249)
         mat( 250) = lmat( 250)
         mat( 251) = lmat( 251)
         mat( 252) = lmat( 252)
         mat( 253) = lmat( 253)
         mat( 254) = mat( 254) + lmat( 254)
         mat( 256) = lmat( 256)
         mat( 258) = lmat( 258)
         mat( 262) = mat( 262) + lmat( 262)
         mat( 265) = lmat( 265)
         mat( 267) = lmat( 267)
         mat( 268) = mat( 268) + lmat( 268)
         mat( 269) = lmat( 269)
         mat( 270) = mat( 270) + lmat( 270)
         mat( 281) = mat( 281) + lmat( 281)
         mat( 288) = mat( 288) + lmat( 288)
         mat( 290) = mat( 290) + lmat( 290)
         mat( 295) = mat( 295) + lmat( 295)
         mat( 299) = lmat( 299)
         mat( 300) = mat( 300) + lmat( 300)
         mat( 303) = lmat( 303)
         mat( 305) = lmat( 305)
         mat( 307) = lmat( 307)
         mat( 308) = mat( 308) + lmat( 308)
         mat( 309) = lmat( 309)
         mat( 311) = mat( 311) + lmat( 311)
         mat( 318) = mat( 318) + lmat( 318)
         mat( 319) = mat( 319) + lmat( 319)
         mat( 321) = mat( 321) + lmat( 321)
         mat( 326) = mat( 326) + lmat( 326)
         mat( 337) = mat( 337) + lmat( 337)
         mat( 339) = lmat( 339)
         mat( 341) = lmat( 341)
         mat( 344) = mat( 344) + lmat( 344)
         mat( 356) = mat( 356) + lmat( 356)
         mat( 365) = mat( 365) + lmat( 365)
         mat( 368) = mat( 368) + lmat( 368)
         mat( 371) = lmat( 371)
         mat( 374) = mat( 374) + lmat( 374)
         mat( 375) = lmat( 375)
         mat( 376) = mat( 376) + lmat( 376)
         mat( 378) = mat( 378) + lmat( 378)
         mat( 379) = mat( 379) + lmat( 379)
         mat( 381) = lmat( 381)
         mat( 385) = mat( 385) + lmat( 385)
         mat( 388) = mat( 388) + lmat( 388)
         mat( 399) = mat( 399) + lmat( 399)
         mat( 401) = lmat( 401)
         mat( 402) = mat( 402) + lmat( 402)
         mat( 405) = mat( 405) + lmat( 405)
         mat( 407) = mat( 407) + lmat( 407)
         mat( 408) = mat( 408) + lmat( 408)
         mat( 413) = mat( 413) + lmat( 413)
         mat( 429) = mat( 429) + lmat( 429)
         mat( 430) = mat( 430) + lmat( 430)
         mat( 431) = mat( 431) + lmat( 431)
         mat( 433) = lmat( 433)
         mat( 435) = mat( 435) + lmat( 435)
         mat( 436) = mat( 436) + lmat( 436)
         mat( 438) = mat( 438) + lmat( 438)
         mat( 441) = mat( 441) + lmat( 441)
         mat( 442) = lmat( 442)
         mat( 444) = lmat( 444)
         mat( 445) = mat( 445) + lmat( 445)
         mat( 448) = mat( 448) + lmat( 448)
         mat( 451) = mat( 451) + lmat( 451)
         mat( 465) = mat( 465) + lmat( 465)
         mat( 481) = mat( 481) + lmat( 481)
         mat( 493) = mat( 493) + lmat( 493)
         mat( 501) = mat( 501) + lmat( 501)
         mat( 508) = mat( 508) + lmat( 508)
         mat( 521) = mat( 521) + lmat( 521)
         mat( 523) = lmat( 523)
         mat( 524) = lmat( 524)
         mat( 526) = mat( 526) + lmat( 526)
         mat( 528) = lmat( 528)
         mat( 529) = mat( 529) + lmat( 529)
         mat( 533) = lmat( 533)
         mat( 537) = lmat( 537)
         mat( 538) = mat( 538) + lmat( 538)
         mat( 539) = mat( 539) + lmat( 539)
         mat( 542) = mat( 542) + lmat( 542)
         mat( 543) = lmat( 543)
         mat( 546) = mat( 546) + lmat( 546)
         mat( 549) = mat( 549) + lmat( 549)
         mat( 551) = mat( 551) + lmat( 551)
         mat( 552) = mat( 552) + lmat( 552)
         mat( 553) = mat( 553) + lmat( 553)
         mat( 559) = lmat( 559)
         mat( 567) = mat( 567) + lmat( 567)
         mat( 578) = lmat( 578)
         mat( 579) = mat( 579) + lmat( 579)
         mat( 583) = mat( 583) + lmat( 583)
         mat( 585) = lmat( 585)
         mat( 588) = lmat( 588)
         mat( 604) = mat( 604) + lmat( 604)
         mat( 626) = mat( 626) + lmat( 626)
         mat( 644) = mat( 644) + lmat( 644)
         mat( 671) = mat( 671) + lmat( 671)
         mat( 682) = lmat( 682)
         mat( 683) = mat( 683) + lmat( 683)
         mat( 684) = lmat( 684)
         mat( 685) = mat( 685) + lmat( 685)
         mat( 687) = lmat( 687)
         mat( 688) = mat( 688) + lmat( 688)
         mat( 692) = mat( 692) + lmat( 692)
         mat( 696) = mat( 696) + lmat( 696)
         mat( 707) = mat( 707) + lmat( 707)
         mat( 714) = mat( 714) + lmat( 714)
         mat( 717) = mat( 717) + lmat( 717)
         mat( 744) = mat( 744) + lmat( 744)
         mat( 760) = lmat( 760)
         mat( 761) = mat( 761) + lmat( 761)
         mat( 763) = mat( 763) + lmat( 763)
         mat( 764) = mat( 764) + lmat( 764)
         mat( 786) = mat( 786) + lmat( 786)
         mat( 798) = mat( 798) + lmat( 798)
         mat( 799) = mat( 799) + lmat( 799)
         mat( 804) = mat( 804) + lmat( 804)
         mat( 808) = mat( 808) + lmat( 808)
         mat( 885) = mat( 885) + lmat( 885)
         mat( 888) = mat( 888) + lmat( 888)
         mat( 891) = mat( 891) + lmat( 891)
         mat( 894) = mat( 894) + lmat( 894)
         mat( 895) = mat( 895) + lmat( 895)
         mat( 899) = mat( 899) + lmat( 899)
         mat( 910) = mat( 910) + lmat( 910)
         mat( 931) = mat( 931) + lmat( 931)
         mat( 933) = mat( 933) + lmat( 933)
         mat( 937) = mat( 937) + lmat( 937)
         mat( 941) = mat( 941) + lmat( 941)
         mat( 972) = mat( 972) + lmat( 972)
         mat( 975) = mat( 975) + lmat( 975)
         mat( 976) = mat( 976) + lmat( 976)
         mat( 988) = mat( 988) + lmat( 988)
         mat( 993) = lmat( 993)
         mat( 999) = mat( 999) + lmat( 999)
         mat(1000) = mat(1000) + lmat(1000)
         mat(1004) = lmat(1004)
         mat(1006) = mat(1006) + lmat(1006)
         mat(1027) = mat(1027) + lmat(1027)
         mat(1067) = mat(1067) + lmat(1067)
         mat(1091) = mat(1091) + lmat(1091)
         mat(1094) = mat(1094) + lmat(1094)
         mat(1102) = mat(1102) + lmat(1102)
         mat(1104) = mat(1104) + lmat(1104)
         mat(1105) = lmat(1105)
         mat(1106) = lmat(1106)
         mat(1108) = mat(1108) + lmat(1108)
         mat(1111) = mat(1111) + lmat(1111)
         mat(1112) = lmat(1112)
         mat(1113) = lmat(1113)
         mat(1114) = mat(1114) + lmat(1114)
         mat(1116) = mat(1116) + lmat(1116)
         mat(1117) = lmat(1117)
         mat(1134) = mat(1134) + lmat(1134)
         mat(1136) = mat(1136) + lmat(1136)
         mat(1138) = mat(1138) + lmat(1138)
         mat(1157) = mat(1157) + lmat(1157)
         mat(1160) = mat(1160) + lmat(1160)
         mat(1205) = mat(1205) + lmat(1205)
         mat(1209) = mat(1209) + lmat(1209)
         mat(1218) = lmat(1218)
         mat(1224) = mat(1224) + lmat(1224)
         mat(1231) = mat(1231) + lmat(1231)
         mat( 207) = 0._r8
         mat( 210) = 0._r8
         mat( 245) = 0._r8
         mat( 282) = 0._r8
         mat( 285) = 0._r8
         mat( 301) = 0._r8
         mat( 304) = 0._r8
         mat( 306) = 0._r8
         mat( 315) = 0._r8
         mat( 325) = 0._r8
         mat( 328) = 0._r8
         mat( 330) = 0._r8
         mat( 331) = 0._r8
         mat( 334) = 0._r8
         mat( 345) = 0._r8
         mat( 347) = 0._r8
         mat( 350) = 0._r8
         mat( 361) = 0._r8
         mat( 369) = 0._r8
         mat( 389) = 0._r8
         mat( 391) = 0._r8
         mat( 392) = 0._r8
         mat( 396) = 0._r8
         mat( 421) = 0._r8
         mat( 422) = 0._r8
         mat( 432) = 0._r8
         mat( 443) = 0._r8
         mat( 455) = 0._r8
         mat( 459) = 0._r8
         mat( 467) = 0._r8
         mat( 469) = 0._r8
         mat( 470) = 0._r8
         mat( 473) = 0._r8
         mat( 478) = 0._r8
         mat( 482) = 0._r8
         mat( 484) = 0._r8
         mat( 486) = 0._r8
         mat( 489) = 0._r8
         mat( 507) = 0._r8
         mat( 509) = 0._r8
         mat( 511) = 0._r8
         mat( 513) = 0._r8
         mat( 514) = 0._r8
         mat( 515) = 0._r8
         mat( 516) = 0._r8
         mat( 518) = 0._r8
         mat( 532) = 0._r8
         mat( 534) = 0._r8
         mat( 545) = 0._r8
         mat( 555) = 0._r8
         mat( 556) = 0._r8
         mat( 569) = 0._r8
         mat( 570) = 0._r8
         mat( 574) = 0._r8
         mat( 580) = 0._r8
         mat( 586) = 0._r8
         mat( 587) = 0._r8
         mat( 590) = 0._r8
         mat( 592) = 0._r8
         mat( 595) = 0._r8
         mat( 603) = 0._r8
         mat( 605) = 0._r8
         mat( 607) = 0._r8
         mat( 608) = 0._r8
         mat( 612) = 0._r8
         mat( 620) = 0._r8
         mat( 622) = 0._r8
         mat( 623) = 0._r8
         mat( 625) = 0._r8
         mat( 627) = 0._r8
         mat( 629) = 0._r8
         mat( 630) = 0._r8
         mat( 634) = 0._r8
         mat( 636) = 0._r8
         mat( 642) = 0._r8
         mat( 643) = 0._r8
         mat( 646) = 0._r8
         mat( 647) = 0._r8
         mat( 651) = 0._r8
         mat( 672) = 0._r8
         mat( 673) = 0._r8
         mat( 677) = 0._r8
         mat( 678) = 0._r8
         mat( 686) = 0._r8
         mat( 689) = 0._r8
         mat( 695) = 0._r8
         mat( 698) = 0._r8
         mat( 699) = 0._r8
         mat( 704) = 0._r8
         mat( 705) = 0._r8
         mat( 706) = 0._r8
         mat( 710) = 0._r8
         mat( 711) = 0._r8
         mat( 715) = 0._r8
         mat( 719) = 0._r8
         mat( 742) = 0._r8
         mat( 743) = 0._r8
         mat( 747) = 0._r8
         mat( 748) = 0._r8
         mat( 749) = 0._r8
         mat( 752) = 0._r8
         mat( 753) = 0._r8
         mat( 756) = 0._r8
         mat( 765) = 0._r8
         mat( 768) = 0._r8
         mat( 772) = 0._r8
         mat( 774) = 0._r8
         mat( 784) = 0._r8
         mat( 785) = 0._r8
         mat( 788) = 0._r8
         mat( 789) = 0._r8
         mat( 790) = 0._r8
         mat( 793) = 0._r8
         mat( 794) = 0._r8
         mat( 796) = 0._r8
         mat( 797) = 0._r8
         mat( 802) = 0._r8
         mat( 805) = 0._r8
         mat( 807) = 0._r8
         mat( 809) = 0._r8
         mat( 847) = 0._r8
         mat( 871) = 0._r8
         mat( 897) = 0._r8
         mat( 900) = 0._r8
         mat( 927) = 0._r8
         mat( 928) = 0._r8
         mat( 929) = 0._r8
         mat( 934) = 0._r8
         mat( 935) = 0._r8
         mat( 938) = 0._r8
         mat( 939) = 0._r8
         mat( 940) = 0._r8
         mat( 942) = 0._r8
         mat( 946) = 0._r8
         mat( 948) = 0._r8
         mat( 951) = 0._r8
         mat( 953) = 0._r8
         mat( 954) = 0._r8
         mat( 958) = 0._r8
         mat( 960) = 0._r8
         mat( 961) = 0._r8
         mat( 963) = 0._r8
         mat( 964) = 0._r8
         mat( 980) = 0._r8
         mat( 989) = 0._r8
         mat( 990) = 0._r8
         mat( 991) = 0._r8
         mat( 995) = 0._r8
         mat(1001) = 0._r8
         mat(1002) = 0._r8
         mat(1005) = 0._r8
         mat(1008) = 0._r8
         mat(1024) = 0._r8
         mat(1031) = 0._r8
         mat(1033) = 0._r8
         mat(1037) = 0._r8
         mat(1045) = 0._r8
         mat(1047) = 0._r8
         mat(1048) = 0._r8
         mat(1050) = 0._r8
         mat(1069) = 0._r8
         mat(1079) = 0._r8
         mat(1084) = 0._r8
         mat(1095) = 0._r8
         mat(1107) = 0._r8
         mat(1109) = 0._r8
         mat(1115) = 0._r8
         mat(1125) = 0._r8
         mat(1126) = 0._r8
         mat(1132) = 0._r8
         mat(1133) = 0._r8
         mat(1137) = 0._r8
         mat(1144) = 0._r8
         mat(1145) = 0._r8
         mat(1148) = 0._r8
         mat(1149) = 0._r8
         mat(1150) = 0._r8
         mat(1152) = 0._r8
         mat(1154) = 0._r8
         mat(1155) = 0._r8
         mat(1156) = 0._r8
         mat(1158) = 0._r8
         mat(1159) = 0._r8
         mat(1194) = 0._r8
         mat(1195) = 0._r8
         mat(1206) = 0._r8
         mat(1210) = 0._r8
         mat(1219) = 0._r8
         mat(1220) = 0._r8
         mat(1222) = 0._r8
         mat(1223) = 0._r8
         mat(1225) = 0._r8
         mat(1228) = 0._r8
         mat(1229) = 0._r8
         mat(1230) = 0._r8
         mat( 1) = mat( 1) - dti
         mat( 2) = mat( 2) - dti
         mat( 3) = mat( 3) - dti
         mat( 4) = mat( 4) - dti
         mat( 5) = mat( 5) - dti
         mat( 6) = mat( 6) - dti
         mat( 7) = mat( 7) - dti
         mat( 8) = mat( 8) - dti
         mat( 9) = mat( 9) - dti
         mat( 10) = mat( 10) - dti
         mat( 11) = mat( 11) - dti
         mat( 12) = mat( 12) - dti
         mat( 13) = mat( 13) - dti
         mat( 14) = mat( 14) - dti
         mat( 15) = mat( 15) - dti
         mat( 16) = mat( 16) - dti
         mat( 17) = mat( 17) - dti
         mat( 18) = mat( 18) - dti
         mat( 19) = mat( 19) - dti
         mat( 20) = mat( 20) - dti
         mat( 23) = mat( 23) - dti
         mat( 26) = mat( 26) - dti
         mat( 29) = mat( 29) - dti
         mat( 32) = mat( 32) - dti
         mat( 35) = mat( 35) - dti
         mat( 39) = mat( 39) - dti
         mat( 42) = mat( 42) - dti
         mat( 47) = mat( 47) - dti
         mat( 50) = mat( 50) - dti
         mat( 54) = mat( 54) - dti
         mat( 56) = mat( 56) - dti
         mat( 62) = mat( 62) - dti
         mat( 64) = mat( 64) - dti
         mat( 68) = mat( 68) - dti
         mat( 72) = mat( 72) - dti
         mat( 76) = mat( 76) - dti
         mat( 80) = mat( 80) - dti
         mat( 86) = mat( 86) - dti
         mat( 91) = mat( 91) - dti
         mat( 95) = mat( 95) - dti
         mat( 99) = mat( 99) - dti
         mat( 105) = mat( 105) - dti
         mat( 111) = mat( 111) - dti
         mat( 118) = mat( 118) - dti
         mat( 123) = mat( 123) - dti
         mat( 128) = mat( 128) - dti
         mat( 133) = mat( 133) - dti
         mat( 137) = mat( 137) - dti
         mat( 145) = mat( 145) - dti
         mat( 148) = mat( 148) - dti
         mat( 154) = mat( 154) - dti
         mat( 158) = mat( 158) - dti
         mat( 164) = mat( 164) - dti
         mat( 170) = mat( 170) - dti
         mat( 174) = mat( 174) - dti
         mat( 180) = mat( 180) - dti
         mat( 186) = mat( 186) - dti
         mat( 191) = mat( 191) - dti
         mat( 198) = mat( 198) - dti
         mat( 206) = mat( 206) - dti
         mat( 213) = mat( 213) - dti
         mat( 219) = mat( 219) - dti
         mat( 223) = mat( 223) - dti
         mat( 231) = mat( 231) - dti
         mat( 240) = mat( 240) - dti
         mat( 248) = mat( 248) - dti
         mat( 254) = mat( 254) - dti
         mat( 262) = mat( 262) - dti
         mat( 270) = mat( 270) - dti
         mat( 281) = mat( 281) - dti
         mat( 288) = mat( 288) - dti
         mat( 295) = mat( 295) - dti
         mat( 300) = mat( 300) - dti
         mat( 311) = mat( 311) - dti
         mat( 318) = mat( 318) - dti
         mat( 326) = mat( 326) - dti
         mat( 337) = mat( 337) - dti
         mat( 344) = mat( 344) - dti
         mat( 356) = mat( 356) - dti
         mat( 365) = mat( 365) - dti
         mat( 374) = mat( 374) - dti
         mat( 379) = mat( 379) - dti
         mat( 388) = mat( 388) - dti
         mat( 399) = mat( 399) - dti
         mat( 405) = mat( 405) - dti
         mat( 413) = mat( 413) - dti
         mat( 431) = mat( 431) - dti
         mat( 441) = mat( 441) - dti
         mat( 451) = mat( 451) - dti
         mat( 465) = mat( 465) - dti
         mat( 481) = mat( 481) - dti
         mat( 493) = mat( 493) - dti
         mat( 501) = mat( 501) - dti
         mat( 508) = mat( 508) - dti
         mat( 521) = mat( 521) - dti
         mat( 529) = mat( 529) - dti
         mat( 539) = mat( 539) - dti
         mat( 552) = mat( 552) - dti
         mat( 567) = mat( 567) - dti
         mat( 583) = mat( 583) - dti
         mat( 604) = mat( 604) - dti
         mat( 626) = mat( 626) - dti
         mat( 644) = mat( 644) - dti
         mat( 671) = mat( 671) - dti
         mat( 683) = mat( 683) - dti
         mat( 692) = mat( 692) - dti
         mat( 707) = mat( 707) - dti
         mat( 744) = mat( 744) - dti
         mat( 764) = mat( 764) - dti
         mat( 798) = mat( 798) - dti
         mat( 891) = mat( 891) - dti
         mat( 933) = mat( 933) - dti
         mat( 972) = mat( 972) - dti
         mat( 999) = mat( 999) - dti
         mat(1067) = mat(1067) - dti
         mat(1094) = mat(1094) - dti
         mat(1114) = mat(1114) - dti
         mat(1138) = mat(1138) - dti
         mat(1157) = mat(1157) - dti
         mat(1209) = mat(1209) - dti
         mat(1231) = mat(1231) - dti
      end subroutine nlnmat_finit
      subroutine nlnmat( mat, y, rxt, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)
      call nlnmat01( mat, y, rxt )
      call nlnmat02( mat, y, rxt )
      call nlnmat03( mat, y, rxt )
      call nlnmat04( mat, y, rxt )
      call nlnmat05( mat, y, rxt )
      call nlnmat06( mat, y, rxt )
      call nlnmat_finit( mat, lmat, dti )
      end subroutine nlnmat
      end module mo_nln_matrix
