




      module mo_nln_matrix

      use shr_kind_mod, only : r8 => shr_kind_r8

      private
      public :: nlnmat

      contains

      subroutine nlnmat01( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(1348) = -(rxt(136)*y(2) + rxt(143)*y(3) + rxt(168)*y(21) + rxt(173)*y(22) &
                      + rxt(181)*y(23) + rxt(193)*y(6) + rxt(196)*y(7) + rxt(208) &
                      *y(27) + rxt(235)*y(36) + rxt(290)*y(44) + rxt(311)*y(59) &
                      + rxt(335)*y(77) + rxt(341)*y(78) + rxt(360)*y(92) + rxt(406) &
                      *y(115) + rxt(445)*y(141) + rxt(446)*y(142))
         mat(1882) = -rxt(136)*y(1)
         mat(1901) = -rxt(143)*y(1)
         mat(1210) = -rxt(168)*y(1)
         mat(1522) = -rxt(173)*y(1)
         mat(1707) = -rxt(181)*y(1)
         mat(1784) = -rxt(193)*y(1)
         mat(1561) = -rxt(196)*y(1)
         mat(1614) = -rxt(208)*y(1)
         mat(1802) = -rxt(235)*y(1)
         mat(456) = -rxt(290)*y(1)
         mat(865) = -rxt(311)*y(1)
         mat(1091) = -rxt(335)*y(1)
         mat(1020) = -rxt(341)*y(1)
         mat(726) = -rxt(360)*y(1)
         mat(377) = -rxt(406)*y(1)
         mat(817) = -rxt(445)*y(1)
         mat(788) = -rxt(446)*y(1)

         mat(1707) = mat(1707) + .150_r8*rxt(301)*y(48) + .150_r8*rxt(351)*y(76)
         mat(1193) = .150_r8*rxt(301)*y(23)
         mat(1162) = .150_r8*rxt(351)*y(23)

         mat(1892) = -(rxt(136)*y(1) + 4._r8*rxt(137)*y(2) + rxt(172)*y(22) + rxt(179) &
                      *y(20) + rxt(180)*y(23) + rxt(183)*y(24) + rxt(191)*y(6) &
                      + (rxt(194) + rxt(195)) * y(7) + rxt(202)*y(8) + rxt(215)*y(29) &
                      + rxt(228)*y(32) + rxt(229)*y(33) + rxt(232)*y(34) + rxt(238) &
                      *y(37) + rxt(248)*y(38) + rxt(249)*y(39) + rxt(250)*y(40) &
                      + rxt(268)*y(16))
         mat(1358) = -rxt(136)*y(2)
         mat(1532) = -rxt(172)*y(2)
         mat(877) = -rxt(179)*y(2)
         mat(1717) = -rxt(180)*y(2)
         mat(489) = -rxt(183)*y(2)
         mat(1794) = -rxt(191)*y(2)
         mat(1571) = -(rxt(194) + rxt(195)) * y(2)
         mat(1867) = -rxt(202)*y(2)
         mat(1381) = -rxt(215)*y(2)
         mat(1592) = -rxt(228)*y(2)
         mat(687) = -rxt(229)*y(2)
         mat(759) = -rxt(232)*y(2)
         mat(1284) = -rxt(238)*y(2)
         mat(654) = -rxt(248)*y(2)
         mat(648) = -rxt(249)*y(2)
         mat(438) = -rxt(250)*y(2)
         mat(1304) = -rxt(268)*y(2)

         mat(140) = rxt(187)*y(6) + rxt(188)*y(7)
         mat(1794) = mat(1794) + rxt(187)*y(5)
         mat(1571) = mat(1571) + rxt(188)*y(5)
         mat(1532) = mat(1532) + 2.000_r8*rxt(175)*y(22)
         mat(1215) = rxt(171)*y(23)
         mat(1717) = mat(1717) + rxt(171)*y(21)

         mat(1912) = -(rxt(140)*y(237) + rxt(143)*y(1) + rxt(163)*y(20) + rxt(164) &
                      *y(32) + rxt(165)*y(38) + rxt(166)*y(18))
         mat(1206) = -rxt(140)*y(3)
         mat(1359) = -rxt(143)*y(3)
         mat(878) = -rxt(163)*y(3)
         mat(1593) = -rxt(164)*y(3)
         mat(655) = -rxt(165)*y(3)
         mat(144) = -rxt(166)*y(3)

         mat(871) = -(rxt(163)*y(3) + rxt(177)*y(22) + rxt(179)*y(2) + rxt(209)*y(27))
         mat(1896) = -rxt(163)*y(20)
         mat(1496) = -rxt(177)*y(20)
         mat(1876) = -rxt(179)*y(20)
         mat(1605) = -rxt(209)*y(20)

         mat(1207) = rxt(170)*y(23)
         mat(1682) = rxt(170)*y(21)

         mat(936) = -((rxt(264) + rxt(265)) * y(22))
         mat(1502) = -(rxt(264) + rxt(265)) * y(17)

         mat(1329) = .560_r8*rxt(311)*y(59) + .620_r8*rxt(360)*y(92) &
                      + .630_r8*rxt(290)*y(44) + .230_r8*rxt(445)*y(141) &
                      + .230_r8*rxt(446)*y(142) + .560_r8*rxt(335)*y(77) &
                      + .650_r8*rxt(341)*y(78)
         mat(1877) = rxt(268)*y(16)
         mat(1764) = .400_r8*rxt(414)*y(124) + .170_r8*rxt(430)*y(130) &
                      + .350_r8*rxt(432)*y(131) + .225_r8*rxt(456)*y(146) &
                      + .220_r8*rxt(342)*y(79) + .250_r8*rxt(387)*y(103)
         mat(1502) = mat(1502) + rxt(267)*y(16) + rxt(306)*y(53) + .700_r8*rxt(459) &
                      *y(149) + rxt(327)*y(68) + .350_r8*rxt(283)*y(41)
         mat(1838) = rxt(266)*y(16) + .220_r8*rxt(344)*y(79) + rxt(328)*y(68) &
                      + .500_r8*rxt(388)*y(103)
         mat(1237) = .125_r8*rxt(458)*y(146) + .110_r8*rxt(346)*y(79) &
                      + .200_r8*rxt(390)*y(103)
         mat(1291) = rxt(268)*y(2) + rxt(267)*y(22) + rxt(266)*y(8) + rxt(213)*y(27) &
                      + rxt(237)*y(36)
         mat(1688) = .160_r8*rxt(415)*y(124) + .070_r8*rxt(429)*y(130) &
                      + .140_r8*rxt(431)*y(131)
         mat(1607) = rxt(213)*y(16)
         mat(1797) = rxt(237)*y(16)
         mat(857) = .560_r8*rxt(311)*y(1)
         mat(716) = .620_r8*rxt(360)*y(1)
         mat(1177) = .220_r8*rxt(347)*y(79) + .250_r8*rxt(391)*y(103)
         mat(454) = .630_r8*rxt(290)*y(1)
         mat(762) = rxt(306)*y(22)
         mat(569) = .400_r8*rxt(414)*y(6) + .160_r8*rxt(415)*y(23)
         mat(623) = .170_r8*rxt(430)*y(6) + .070_r8*rxt(429)*y(23)
         mat(929) = .350_r8*rxt(432)*y(6) + .140_r8*rxt(431)*y(23)
         mat(810) = .230_r8*rxt(445)*y(1)
         mat(781) = .230_r8*rxt(446)*y(1)
         mat(917) = .225_r8*rxt(456)*y(6) + .125_r8*rxt(458)*y(13)
         mat(902) = .700_r8*rxt(459)*y(22)
         mat(1080) = .560_r8*rxt(335)*y(1)
         mat(1011) = .650_r8*rxt(341)*y(1)
         mat(1100) = .220_r8*rxt(342)*y(6) + .220_r8*rxt(344)*y(8) + .110_r8*rxt(346) &
                      *y(13) + .220_r8*rxt(347)*y(48)
         mat(1024) = rxt(327)*y(22) + rxt(328)*y(8)
         mat(1037) = .250_r8*rxt(387)*y(6) + .500_r8*rxt(388)*y(8) + .200_r8*rxt(390) &
                      *y(13) + .250_r8*rxt(391)*y(48)
         mat(224) = .350_r8*rxt(283)*y(22)

         mat(137) = -(rxt(187)*y(6) + (rxt(188) + rxt(189) + rxt(190)) * y(7))
         mat(1720) = -rxt(187)*y(5)
         mat(1535) = -(rxt(188) + rxt(189) + rxt(190)) * y(5)

         mat(1791) = -(rxt(187)*y(5) + rxt(191)*y(2) + rxt(192)*y(23) + rxt(193)*y(1) &
                      + rxt(201)*y(8) + rxt(220)*y(29) + rxt(241)*y(37) + rxt(270) &
                      *y(13) + rxt(278)*y(43) + rxt(286)*y(55) + rxt(292)*y(46) &
                      + rxt(299)*y(48) + rxt(313)*y(61) + rxt(318)*y(64) + rxt(322) &
                      *y(67) + (rxt(331) + rxt(332)) * y(73) + rxt(337)*y(74) + (rxt(342) &
                      + rxt(343)) * y(79) + rxt(349)*y(76) + rxt(362)*y(97) + rxt(363) &
                      *y(98) + rxt(378)*y(101) + rxt(387)*y(103) + (rxt(395) + rxt(396) &
                      ) * y(93) + rxt(402)*y(114) + rxt(407)*y(117) + rxt(410)*y(113) &
                      + rxt(414)*y(124) + rxt(420)*y(126) + rxt(424)*y(129) + rxt(428) &
                      *y(108) + rxt(430)*y(130) + rxt(432)*y(131) + rxt(437)*y(135) &
                      + rxt(442)*y(137) + rxt(449)*y(143) + rxt(456)*y(146) + rxt(460) &
                      *y(151))
         mat(139) = -rxt(187)*y(6)
         mat(1889) = -rxt(191)*y(6)
         mat(1714) = -rxt(192)*y(6)
         mat(1355) = -rxt(193)*y(6)
         mat(1864) = -rxt(201)*y(6)
         mat(1378) = -rxt(220)*y(6)
         mat(1281) = -rxt(241)*y(6)
         mat(1262) = -rxt(270)*y(6)
         mat(323) = -rxt(278)*y(6)
         mat(596) = -rxt(286)*y(6)
         mat(698) = -rxt(292)*y(6)
         mat(1197) = -rxt(299)*y(6)
         mat(666) = -rxt(313)*y(6)
         mat(639) = -rxt(318)*y(6)
         mat(974) = -rxt(322)*y(6)
         mat(482) = -(rxt(331) + rxt(332)) * y(6)
         mat(551) = -rxt(337)*y(6)
         mat(1116) = -(rxt(342) + rxt(343)) * y(6)
         mat(1166) = -rxt(349)*y(6)
         mat(1076) = -rxt(362)*y(6)
         mat(1149) = -rxt(363)*y(6)
         mat(1008) = -rxt(378)*y(6)
         mat(1049) = -rxt(387)*y(6)
         mat(837) = -(rxt(395) + rxt(396)) * y(6)
         mat(336) = -rxt(402)*y(6)
         mat(521) = -rxt(407)*y(6)
         mat(374) = -rxt(410)*y(6)
         mat(572) = -rxt(414)*y(6)
         mat(350) = -rxt(420)*y(6)
         mat(414) = -rxt(424)*y(6)
         mat(587) = -rxt(428)*y(6)
         mat(629) = -rxt(430)*y(6)
         mat(935) = -rxt(432)*y(6)
         mat(400) = -rxt(437)*y(6)
         mat(621) = -rxt(442)*y(6)
         mat(747) = -rxt(449)*y(6)
         mat(926) = -rxt(456)*y(6)
         mat(898) = -rxt(460)*y(6)

         mat(1889) = mat(1889) + rxt(194)*y(7)
         mat(139) = mat(139) + 2.000_r8*rxt(189)*y(7)
         mat(1568) = rxt(194)*y(2) + 2.000_r8*rxt(189)*y(5)

         mat(1564) = -((rxt(188) + rxt(189) + rxt(190)) * y(5) + (rxt(194) + rxt(195) &
                      ) * y(2) + rxt(196)*y(1) + rxt(197)*y(8) + rxt(199)*y(22) &
                      + rxt(205)*y(23) + rxt(221)*y(29) + rxt(242)*y(37) + rxt(300) &
                      *y(48) + rxt(355)*y(76) + rxt(405)*y(115) + rxt(413)*y(124) &
                      + rxt(422)*y(129) + rxt(433)*y(130) + rxt(434)*y(131))
         mat(138) = -(rxt(188) + rxt(189) + rxt(190)) * y(7)
         mat(1885) = -(rxt(194) + rxt(195)) * y(7)
         mat(1351) = -rxt(196)*y(7)
         mat(1860) = -rxt(197)*y(7)
         mat(1525) = -rxt(199)*y(7)
         mat(1710) = -rxt(205)*y(7)
         mat(1374) = -rxt(221)*y(7)
         mat(1277) = -rxt(242)*y(7)
         mat(1195) = -rxt(300)*y(7)
         mat(1164) = -rxt(355)*y(7)
         mat(378) = -rxt(405)*y(7)
         mat(570) = -rxt(413)*y(7)
         mat(412) = -rxt(422)*y(7)
         mat(627) = -rxt(433)*y(7)
         mat(933) = -rxt(434)*y(7)

         mat(1351) = mat(1351) + rxt(193)*y(6)
         mat(1885) = mat(1885) + rxt(191)*y(6) + rxt(202)*y(8)
         mat(1787) = rxt(193)*y(1) + rxt(191)*y(2) + 2.000_r8*rxt(201)*y(8) + rxt(270) &
                      *y(13) + rxt(192)*y(23) + rxt(220)*y(29) + rxt(241)*y(37) &
                      + rxt(318)*y(64) + rxt(299)*y(48) + rxt(331)*y(73) + rxt(395) &
                      *y(93) + rxt(337)*y(74) + rxt(428)*y(108) + .800_r8*rxt(449) &
                      *y(143) + rxt(410)*y(113) + rxt(402)*y(114) + rxt(407)*y(117) &
                      + rxt(414)*y(124) + rxt(420)*y(126) + rxt(424)*y(129) + rxt(430) &
                      *y(130) + rxt(432)*y(131) + rxt(437)*y(135) + rxt(442)*y(137) &
                      + .900_r8*rxt(456)*y(146) + 1.600_r8*rxt(460)*y(151) &
                      + .920_r8*rxt(362)*y(97) + .920_r8*rxt(363)*y(98) + rxt(342) &
                      *y(79) + rxt(349)*y(76) + rxt(292)*y(46) + rxt(313)*y(61) &
                      + rxt(286)*y(55) + rxt(322)*y(67) + rxt(378)*y(101) + rxt(387) &
                      *y(103) + rxt(278)*y(43)
         mat(1525) = mat(1525) + rxt(203)*y(8) + rxt(206)*y(10) + rxt(397)*y(82) &
                      + rxt(329)*y(83) + .700_r8*rxt(364)*y(85) + rxt(464)*y(90)
         mat(1860) = mat(1860) + rxt(202)*y(2) + 2.000_r8*rxt(201)*y(6) + rxt(203) &
                      *y(22) + rxt(204)*y(23) + rxt(333)*y(70) + 2.000_r8*rxt(463) &
                      *y(151) + rxt(366)*y(97) + rxt(367)*y(98) + rxt(344)*y(79) &
                      + rxt(350)*y(76) + rxt(379)*y(101) + rxt(388)*y(103)
         mat(327) = rxt(206)*y(22)
         mat(1258) = rxt(270)*y(6) + .500_r8*rxt(462)*y(151)
         mat(1710) = mat(1710) + rxt(192)*y(6) + rxt(204)*y(8)
         mat(1374) = mat(1374) + rxt(220)*y(6)
         mat(1277) = mat(1277) + rxt(241)*y(6)
         mat(637) = rxt(318)*y(6)
         mat(1195) = mat(1195) + rxt(299)*y(6)
         mat(531) = rxt(397)*y(22)
         mat(735) = rxt(329)*y(22)
         mat(473) = .700_r8*rxt(364)*y(22)
         mat(424) = rxt(464)*y(22)
         mat(292) = rxt(333)*y(8)
         mat(480) = rxt(331)*y(6)
         mat(835) = rxt(395)*y(6)
         mat(549) = rxt(337)*y(6)
         mat(585) = rxt(428)*y(6)
         mat(745) = .800_r8*rxt(449)*y(6)
         mat(372) = rxt(410)*y(6)
         mat(334) = rxt(402)*y(6)
         mat(519) = rxt(407)*y(6)
         mat(570) = mat(570) + rxt(414)*y(6)
         mat(348) = rxt(420)*y(6)
         mat(412) = mat(412) + rxt(424)*y(6)
         mat(627) = mat(627) + rxt(430)*y(6)
         mat(933) = mat(933) + rxt(432)*y(6)
         mat(398) = rxt(437)*y(6)
         mat(619) = rxt(442)*y(6)
         mat(924) = .900_r8*rxt(456)*y(6)
         mat(896) = 1.600_r8*rxt(460)*y(6) + 2.000_r8*rxt(463)*y(8) + .500_r8*rxt(462) &
                      *y(13)
         mat(1074) = .920_r8*rxt(362)*y(6) + rxt(366)*y(8)
         mat(1147) = .920_r8*rxt(363)*y(6) + rxt(367)*y(8)
         mat(1114) = rxt(342)*y(6) + rxt(344)*y(8)
         mat(1164) = mat(1164) + rxt(349)*y(6) + rxt(350)*y(8)
         mat(696) = rxt(292)*y(6)
         mat(664) = rxt(313)*y(6)
         mat(594) = rxt(286)*y(6)
         mat(972) = rxt(322)*y(6)
         mat(1006) = rxt(378)*y(6) + rxt(379)*y(8)
         mat(1047) = rxt(387)*y(6) + rxt(388)*y(8)
         mat(321) = rxt(278)*y(6)


      end subroutine nlnmat01

      subroutine nlnmat02( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(1524) = -(rxt(172)*y(2) + rxt(173)*y(1) + rxt(174)*y(23) + (4._r8*rxt(175) &
                      + 4._r8*rxt(176)) * y(22) + rxt(177)*y(20) + rxt(178)*y(24) &
                      + rxt(184)*y(18) + rxt(185)*y(19) + rxt(199)*y(7) + rxt(200) &
                      *y(9) + rxt(203)*y(8) + rxt(206)*y(10) + (rxt(216) + rxt(217) &
                      ) * y(29) + rxt(227)*y(32) + rxt(231)*y(33) + rxt(233)*y(34) &
                      + rxt(239)*y(37) + rxt(247)*y(38) + (rxt(264) + rxt(265) &
                      ) * y(17) + rxt(267)*y(16) + rxt(274)*y(15) + rxt(275)*y(14) &
                      + rxt(276)*y(42) + rxt(283)*y(41) + rxt(284)*y(45) + rxt(285) &
                      *y(44) + rxt(291)*y(49) + rxt(296)*y(47) + rxt(297)*y(50) &
                      + rxt(304)*y(54) + rxt(305)*y(52) + rxt(306)*y(53) + rxt(307) &
                      *y(51) + rxt(309)*y(58) + rxt(310)*y(59) + rxt(316)*y(62) &
                      + rxt(317)*y(60) + rxt(320)*y(65) + rxt(321)*y(63) + rxt(325) &
                      *y(69) + rxt(326)*y(66) + rxt(327)*y(68) + rxt(329)*y(83) &
                      + rxt(330)*y(70) + rxt(334)*y(77) + rxt(336)*y(72) + rxt(339) &
                      *y(75) + rxt(340)*y(78) + rxt(348)*y(80) + rxt(357)*y(81) &
                      + rxt(358)*y(84) + rxt(359)*y(92) + rxt(364)*y(85) + rxt(365) &
                      *y(86) + rxt(370)*y(105) + rxt(371)*y(100) + rxt(377)*y(99) &
                      + rxt(383)*y(87) + rxt(384)*y(89) + rxt(385)*y(88) + rxt(386) &
                      *y(96) + rxt(392)*y(104) + rxt(394)*y(71) + rxt(397)*y(82) &
                      + rxt(399)*y(94) + rxt(400)*y(110) + rxt(401)*y(111) + rxt(404) &
                      *y(116) + rxt(409)*y(118) + rxt(412)*y(119) + rxt(416)*y(106) &
                      + rxt(417)*y(107) + rxt(419)*y(127) + rxt(421)*y(128) + rxt(427) &
                      *y(109) + rxt(435)*y(133) + rxt(436)*y(134) + rxt(439)*y(136) &
                      + rxt(441)*y(138) + rxt(443)*y(141) + rxt(444)*y(142) + rxt(452) &
                      *y(144) + rxt(453)*y(150) + rxt(454)*y(145) + rxt(459)*y(149) &
                      + rxt(464)*y(90) + rxt(465)*y(91) + rxt(487)*y(170) + (rxt(488) &
                      + rxt(489)) * y(171))
         mat(1884) = -rxt(172)*y(22)
         mat(1350) = -rxt(173)*y(22)
         mat(1709) = -rxt(174)*y(22)
         mat(874) = -rxt(177)*y(22)
         mat(485) = -rxt(178)*y(22)
         mat(142) = -rxt(184)*y(22)
         mat(89) = -rxt(185)*y(22)
         mat(1563) = -rxt(199)*y(22)
         mat(677) = -rxt(200)*y(22)
         mat(1859) = -rxt(203)*y(22)
         mat(326) = -rxt(206)*y(22)
         mat(1373) = -(rxt(216) + rxt(217)) * y(22)
         mat(1584) = -rxt(227)*y(22)
         mat(684) = -rxt(231)*y(22)
         mat(754) = -rxt(233)*y(22)
         mat(1276) = -rxt(239)*y(22)
         mat(652) = -rxt(247)*y(22)
         mat(938) = -(rxt(264) + rxt(265)) * y(22)
         mat(1296) = -rxt(267)*y(22)
         mat(669) = -rxt(274)*y(22)
         mat(362) = -rxt(275)*y(22)
         mat(673) = -rxt(276)*y(22)
         mat(225) = -rxt(283)*y(22)
         mat(239) = -rxt(284)*y(22)
         mat(457) = -rxt(285)*y(22)
         mat(442) = -rxt(291)*y(22)
         mat(255) = -rxt(296)*y(22)
         mat(982) = -rxt(297)*y(22)
         mat(420) = -rxt(304)*y(22)
         mat(883) = -rxt(305)*y(22)
         mat(763) = -rxt(306)*y(22)
         mat(211) = -rxt(307)*y(22)
         mat(390) = -rxt(309)*y(22)
         mat(866) = -rxt(310)*y(22)
         mat(310) = -rxt(316)*y(22)
         mat(97) = -rxt(317)*y(22)
         mat(449) = -rxt(320)*y(22)
         mat(843) = -rxt(321)*y(22)
         mat(317) = -rxt(325)*y(22)
         mat(960) = -rxt(326)*y(22)
         mat(1029) = -rxt(327)*y(22)
         mat(734) = -rxt(329)*y(22)
         mat(291) = -rxt(330)*y(22)
         mat(1092) = -rxt(334)*y(22)
         mat(430) = -rxt(336)*y(22)
         mat(285) = -rxt(339)*y(22)
         mat(1021) = -rxt(340)*y(22)
         mat(250) = -rxt(348)*y(22)
         mat(463) = -rxt(357)*y(22)
         mat(953) = -rxt(358)*y(22)
         mat(727) = -rxt(359)*y(22)
         mat(472) = -rxt(364)*y(22)
         mat(406) = -rxt(365)*y(22)
         mat(603) = -rxt(370)*y(22)
         mat(106) = -rxt(371)*y(22)
         mat(191) = -rxt(377)*y(22)
         mat(354) = -rxt(383)*y(22)
         mat(274) = -rxt(384)*y(22)
         mat(705) = -rxt(385)*y(22)
         mat(259) = -rxt(386)*y(22)
         mat(220) = -rxt(392)*y(22)
         mat(204) = -rxt(394)*y(22)
         mat(530) = -rxt(397)*y(22)
         mat(542) = -rxt(399)*y(22)
         mat(124) = -rxt(400)*y(22)
         mat(133) = -rxt(401)*y(22)
         mat(263) = -rxt(404)*y(22)
         mat(208) = -rxt(409)*y(22)
         mat(341) = -rxt(412)*y(22)
         mat(178) = -rxt(416)*y(22)
         mat(183) = -rxt(417)*y(22)
         mat(269) = -rxt(419)*y(22)
         mat(187) = -rxt(421)*y(22)
         mat(499) = -rxt(427)*y(22)
         mat(155) = -rxt(435)*y(22)
         mat(160) = -rxt(436)*y(22)
         mat(298) = -rxt(439)*y(22)
         mat(565) = -rxt(441)*y(22)
         mat(818) = -rxt(443)*y(22)
         mat(789) = -rxt(444)*y(22)
         mat(384) = -rxt(452)*y(22)
         mat(508) = -rxt(453)*y(22)
         mat(849) = -rxt(454)*y(22)
         mat(908) = -rxt(459)*y(22)
         mat(423) = -rxt(464)*y(22)
         mat(279) = -rxt(465)*y(22)
         mat(100) = -rxt(487)*y(22)
         mat(196) = -(rxt(488) + rxt(489)) * y(22)

         mat(1350) = mat(1350) + rxt(168)*y(21) + rxt(181)*y(23) + .360_r8*rxt(311) &
                      *y(59) + .320_r8*rxt(360)*y(92) + .130_r8*rxt(290)*y(44) &
                      + .630_r8*rxt(445)*y(141) + .630_r8*rxt(446)*y(142) &
                      + .360_r8*rxt(335)*y(77) + .240_r8*rxt(341)*y(78)
         mat(1884) = mat(1884) + rxt(179)*y(20) + rxt(268)*y(16) + rxt(180)*y(23) &
                      + rxt(183)*y(24) + rxt(228)*y(32) + rxt(229)*y(33) + rxt(248) &
                      *y(38) + rxt(249)*y(39)
         mat(1903) = rxt(163)*y(20) + rxt(166)*y(18) + 2.000_r8*rxt(140)*y(237) &
                      + rxt(164)*y(32) + rxt(165)*y(38)
         mat(874) = mat(874) + rxt(179)*y(2) + rxt(163)*y(3)
         mat(1786) = rxt(192)*y(23)
         mat(1524) = mat(1524) + .300_r8*rxt(275)*y(14) + .500_r8*rxt(320)*y(65) &
                      + .100_r8*rxt(348)*y(80) + .500_r8*rxt(296)*y(47) &
                      + .600_r8*rxt(370)*y(105) + .650_r8*rxt(283)*y(41)
         mat(1859) = mat(1859) + rxt(204)*y(23)
         mat(362) = mat(362) + .300_r8*rxt(275)*y(22)
         mat(142) = mat(142) + rxt(166)*y(3)
         mat(1296) = mat(1296) + rxt(268)*y(2)
         mat(1211) = rxt(168)*y(1) + 2.000_r8*rxt(169)*y(23)
         mat(1709) = mat(1709) + rxt(181)*y(1) + rxt(180)*y(2) + rxt(192)*y(6) &
                      + rxt(204)*y(8) + 2.000_r8*rxt(169)*y(21) + rxt(212)*y(27) &
                      + .450_r8*rxt(301)*y(48) + .200_r8*rxt(338)*y(74) &
                      + .400_r8*rxt(425)*y(129) + .400_r8*rxt(429)*y(130) &
                      + .400_r8*rxt(431)*y(131) + .450_r8*rxt(351)*y(76) &
                      + .150_r8*rxt(323)*y(67)
         mat(485) = mat(485) + rxt(183)*y(2)
         mat(1202) = 2.000_r8*rxt(140)*y(3)
         mat(1616) = rxt(212)*y(23)
         mat(1584) = mat(1584) + rxt(228)*y(2) + rxt(164)*y(3)
         mat(684) = mat(684) + rxt(229)*y(2)
         mat(652) = mat(652) + rxt(248)*y(2) + rxt(165)*y(3)
         mat(644) = rxt(249)*y(2)
         mat(866) = mat(866) + .360_r8*rxt(311)*y(1)
         mat(727) = mat(727) + .320_r8*rxt(360)*y(1)
         mat(449) = mat(449) + .500_r8*rxt(320)*y(22)
         mat(1194) = .450_r8*rxt(301)*y(23)
         mat(457) = mat(457) + .130_r8*rxt(290)*y(1)
         mat(548) = .200_r8*rxt(338)*y(23)
         mat(411) = .400_r8*rxt(425)*y(23)
         mat(626) = .400_r8*rxt(429)*y(23)
         mat(932) = .400_r8*rxt(431)*y(23)
         mat(818) = mat(818) + .630_r8*rxt(445)*y(1)
         mat(789) = mat(789) + .630_r8*rxt(446)*y(1)
         mat(1092) = mat(1092) + .360_r8*rxt(335)*y(1)
         mat(1021) = mat(1021) + .240_r8*rxt(341)*y(1)
         mat(250) = mat(250) + .100_r8*rxt(348)*y(22)
         mat(1163) = .450_r8*rxt(351)*y(23)
         mat(255) = mat(255) + .500_r8*rxt(296)*y(22)
         mat(971) = .150_r8*rxt(323)*y(23)
         mat(603) = mat(603) + .600_r8*rxt(370)*y(22)
         mat(225) = mat(225) + .650_r8*rxt(283)*y(22)

         mat(1866) = -(rxt(197)*y(7) + rxt(201)*y(6) + rxt(202)*y(2) + rxt(203)*y(22) &
                      + rxt(204)*y(23) + rxt(266)*y(16) + rxt(298)*y(50) + rxt(312) &
                      *y(59) + rxt(328)*y(68) + rxt(333)*y(70) + rxt(344)*y(79) &
                      + rxt(350)*y(76) + rxt(361)*y(92) + rxt(366)*y(97) + rxt(367) &
                      *y(98) + rxt(379)*y(101) + rxt(388)*y(103) + rxt(447)*y(141) &
                      + rxt(448)*y(142) + rxt(455)*y(145) + rxt(463)*y(151) + rxt(490) &
                      *y(171))
         mat(1570) = -rxt(197)*y(8)
         mat(1793) = -rxt(201)*y(8)
         mat(1891) = -rxt(202)*y(8)
         mat(1531) = -rxt(203)*y(8)
         mat(1716) = -rxt(204)*y(8)
         mat(1303) = -rxt(266)*y(8)
         mat(985) = -rxt(298)*y(8)
         mat(870) = -rxt(312)*y(8)
         mat(1032) = -rxt(328)*y(8)
         mat(293) = -rxt(333)*y(8)
         mat(1117) = -rxt(344)*y(8)
         mat(1167) = -rxt(350)*y(8)
         mat(729) = -rxt(361)*y(8)
         mat(1077) = -rxt(366)*y(8)
         mat(1150) = -rxt(367)*y(8)
         mat(1009) = -rxt(379)*y(8)
         mat(1050) = -rxt(388)*y(8)
         mat(822) = -rxt(447)*y(8)
         mat(793) = -rxt(448)*y(8)
         mat(851) = -rxt(455)*y(8)
         mat(899) = -rxt(463)*y(8)
         mat(198) = -rxt(490)*y(8)

         mat(1357) = rxt(196)*y(7)
         mat(1891) = mat(1891) + rxt(195)*y(7) + rxt(232)*y(34) + rxt(250)*y(40)
         mat(1570) = mat(1570) + rxt(196)*y(1) + rxt(195)*y(2)
         mat(1531) = mat(1531) + rxt(200)*y(9) + rxt(233)*y(34) + rxt(309)*y(58) &
                      + .500_r8*rxt(357)*y(81)
         mat(679) = rxt(200)*y(22)
         mat(1623) = rxt(234)*y(34)
         mat(758) = rxt(232)*y(2) + rxt(233)*y(22) + rxt(234)*y(27)
         mat(437) = rxt(250)*y(2)
         mat(392) = rxt(309)*y(22)
         mat(466) = .500_r8*rxt(357)*y(22)


      end subroutine nlnmat02

      subroutine nlnmat03( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(675) = -(rxt(200)*y(22))
         mat(1481) = -rxt(200)*y(9)

         mat(1547) = rxt(199)*y(22)
         mat(1481) = mat(1481) + rxt(199)*y(7)
         mat(1822) = rxt(266)*y(16) + rxt(298)*y(50) + rxt(328)*y(68) + rxt(490) &
                      *y(171)
         mat(1289) = rxt(266)*y(8)
         mat(1576) = (rxt(494)+rxt(499)+rxt(505))*y(34)
         mat(749) = (rxt(494)+rxt(499)+rxt(505))*y(32)
         mat(975) = rxt(298)*y(8)
         mat(1023) = rxt(328)*y(8)
         mat(195) = rxt(490)*y(8)

         mat(324) = -(rxt(206)*y(22))
         mat(1438) = -rxt(206)*y(10)

         mat(1537) = rxt(205)*y(23)
         mat(1640) = rxt(205)*y(7)


         mat(1536) = rxt(197)*y(8)
         mat(1818) = rxt(197)*y(7)

         mat(1253) = -(rxt(219)*y(29) + rxt(270)*y(6) + rxt(271)*y(23) + (4._r8*rxt(272) &
                      + 4._r8*rxt(273)) * y(13) + rxt(294)*y(46) + rxt(302)*y(48) &
                      + rxt(315)*y(61) + rxt(324)*y(67) + rxt(346)*y(79) + rxt(352) &
                      *y(76) + rxt(372)*y(97) + rxt(373)*y(98) + rxt(382)*y(101) &
                      + rxt(390)*y(103) + rxt(451)*y(143) + rxt(458)*y(146) + rxt(462) &
                      *y(151))
         mat(1368) = -rxt(219)*y(13)
         mat(1781) = -rxt(270)*y(13)
         mat(1704) = -rxt(271)*y(13)
         mat(693) = -rxt(294)*y(13)
         mat(1191) = -rxt(302)*y(13)
         mat(661) = -rxt(315)*y(13)
         mat(969) = -rxt(324)*y(13)
         mat(1111) = -rxt(346)*y(13)
         mat(1160) = -rxt(352)*y(13)
         mat(1070) = -rxt(372)*y(13)
         mat(1143) = -rxt(373)*y(13)
         mat(1003) = -rxt(382)*y(13)
         mat(1044) = -rxt(390)*y(13)
         mat(742) = -rxt(451)*y(13)
         mat(921) = -rxt(458)*y(13)
         mat(893) = -rxt(462)*y(13)

         mat(1345) = .280_r8*rxt(311)*y(59) + .050_r8*rxt(360)*y(92)
         mat(1781) = mat(1781) + rxt(299)*y(48) + .830_r8*rxt(430)*y(130) &
                      + .170_r8*rxt(432)*y(131)
         mat(1519) = .700_r8*rxt(275)*y(14) + rxt(291)*y(49)
         mat(1253) = mat(1253) + .900_r8*rxt(302)*y(48)
         mat(360) = .700_r8*rxt(275)*y(22)
         mat(1704) = mat(1704) + .450_r8*rxt(301)*y(48) + .330_r8*rxt(429)*y(130) &
                      + .070_r8*rxt(431)*y(131)
         mat(863) = .280_r8*rxt(311)*y(1)
         mat(724) = .050_r8*rxt(360)*y(1)
         mat(441) = rxt(291)*y(22)
         mat(1191) = mat(1191) + rxt(299)*y(6) + .900_r8*rxt(302)*y(13) &
                      + .450_r8*rxt(301)*y(23) + 4.000_r8*rxt(303)*y(48) + rxt(374) &
                      *y(97) + rxt(375)*y(98) + rxt(347)*y(79) + rxt(353)*y(76) &
                      + rxt(381)*y(101) + rxt(391)*y(103)
         mat(625) = .830_r8*rxt(430)*y(6) + .330_r8*rxt(429)*y(23)
         mat(931) = .170_r8*rxt(432)*y(6) + .070_r8*rxt(431)*y(23)
         mat(1070) = mat(1070) + rxt(374)*y(48)
         mat(1143) = mat(1143) + rxt(375)*y(48)
         mat(1111) = mat(1111) + rxt(347)*y(48)
         mat(1160) = mat(1160) + rxt(353)*y(48)
         mat(1003) = mat(1003) + rxt(381)*y(48)
         mat(1044) = mat(1044) + rxt(391)*y(48)

         mat(357) = -(rxt(275)*y(22))
         mat(1443) = -rxt(275)*y(14)

         mat(1220) = rxt(271)*y(23)
         mat(1645) = rxt(271)*y(13)

         mat(141) = -(rxt(166)*y(3) + rxt(184)*y(22))
         mat(1894) = -rxt(166)*y(18)
         mat(1411) = -rxt(184)*y(18)

         mat(88) = -(rxt(185)*y(22))
         mat(1403) = -rxt(185)*y(19)

         mat(1294) = -(rxt(213)*y(27) + rxt(237)*y(36) + rxt(266)*y(8) + rxt(267) &
                      *y(22) + rxt(268)*y(2) + rxt(269)*y(23))
         mat(1613) = -rxt(213)*y(16)
         mat(1801) = -rxt(237)*y(16)
         mat(1856) = -rxt(266)*y(16)
         mat(1521) = -rxt(267)*y(16)
         mat(1881) = -rxt(268)*y(16)
         mat(1706) = -rxt(269)*y(16)

         mat(1347) = .500_r8*rxt(311)*y(59) + .910_r8*rxt(360)*y(92) + rxt(290)*y(44) &
                      + .340_r8*rxt(445)*y(141) + .340_r8*rxt(446)*y(142) &
                      + .600_r8*rxt(335)*y(77) + .120_r8*rxt(341)*y(78)
         mat(1783) = rxt(270)*y(13) + rxt(318)*y(64) + .500_r8*rxt(331)*y(73) &
                      + .100_r8*rxt(395)*y(93) + .320_r8*rxt(449)*y(143) &
                      + .340_r8*rxt(456)*y(146) + .920_r8*rxt(362)*y(97) &
                      + .250_r8*rxt(342)*y(79) + rxt(349)*y(76) + .500_r8*rxt(286) &
                      *y(55) + rxt(322)*y(67) + .250_r8*rxt(387)*y(103)
         mat(1521) = mat(1521) + .300_r8*rxt(275)*y(14) + .500_r8*rxt(304)*y(54) &
                      + rxt(309)*y(58) + .500_r8*rxt(357)*y(81) + .400_r8*rxt(397) &
                      *y(82) + .300_r8*rxt(364)*y(85) + .680_r8*rxt(459)*y(149) &
                      + rxt(274)*y(15) + .800_r8*rxt(305)*y(52)
         mat(1856) = mat(1856) + .500_r8*rxt(333)*y(70) + rxt(366)*y(97) &
                      + .250_r8*rxt(344)*y(79) + rxt(350)*y(76)
         mat(1254) = rxt(270)*y(6) + (4.000_r8*rxt(272)+2.000_r8*rxt(273))*y(13) &
                      + rxt(219)*y(29) + rxt(302)*y(48) + .950_r8*rxt(451)*y(143) &
                      + .930_r8*rxt(458)*y(146) + .750_r8*rxt(462)*y(151) &
                      + 1.500_r8*rxt(372)*y(97) + .750_r8*rxt(373)*y(98) &
                      + .880_r8*rxt(346)*y(79) + 2.000_r8*rxt(352)*y(76) &
                      + .700_r8*rxt(294)*y(46) + rxt(315)*y(61) + .800_r8*rxt(324) &
                      *y(67) + .800_r8*rxt(382)*y(101) + .800_r8*rxt(390)*y(103)
         mat(361) = .300_r8*rxt(275)*y(22)
         mat(1706) = mat(1706) + .450_r8*rxt(351)*y(76) + .150_r8*rxt(323)*y(67)
         mat(1370) = rxt(219)*y(13)
         mat(864) = .500_r8*rxt(311)*y(1)
         mat(725) = .910_r8*rxt(360)*y(1)
         mat(635) = rxt(318)*y(6)
         mat(1192) = rxt(302)*y(13) + rxt(374)*y(97) + .250_r8*rxt(347)*y(79) &
                      + rxt(353)*y(76) + .250_r8*rxt(391)*y(103)
         mat(419) = .500_r8*rxt(304)*y(22)
         mat(389) = rxt(309)*y(22)
         mat(455) = rxt(290)*y(1)
         mat(462) = .500_r8*rxt(357)*y(22)
         mat(529) = .400_r8*rxt(397)*y(22)
         mat(471) = .300_r8*rxt(364)*y(22)
         mat(290) = .500_r8*rxt(333)*y(8)
         mat(479) = .500_r8*rxt(331)*y(6)
         mat(833) = .100_r8*rxt(395)*y(6)
         mat(743) = .320_r8*rxt(449)*y(6) + .950_r8*rxt(451)*y(13)
         mat(816) = .340_r8*rxt(445)*y(1)
         mat(787) = .340_r8*rxt(446)*y(1)
         mat(922) = .340_r8*rxt(456)*y(6) + .930_r8*rxt(458)*y(13)
         mat(907) = .680_r8*rxt(459)*y(22)
         mat(894) = .750_r8*rxt(462)*y(13)
         mat(1071) = .920_r8*rxt(362)*y(6) + rxt(366)*y(8) + 1.500_r8*rxt(372)*y(13) &
                      + rxt(374)*y(48)
         mat(1144) = .750_r8*rxt(373)*y(13)
         mat(1090) = .600_r8*rxt(335)*y(1)
         mat(1019) = .120_r8*rxt(341)*y(1)
         mat(1112) = .250_r8*rxt(342)*y(6) + .250_r8*rxt(344)*y(8) + .880_r8*rxt(346) &
                      *y(13) + .250_r8*rxt(347)*y(48)
         mat(1161) = rxt(349)*y(6) + rxt(350)*y(8) + 2.000_r8*rxt(352)*y(13) &
                      + .450_r8*rxt(351)*y(23) + rxt(353)*y(48) + 4.000_r8*rxt(354) &
                      *y(76)
         mat(694) = .700_r8*rxt(294)*y(13)
         mat(662) = rxt(315)*y(13)
         mat(668) = rxt(274)*y(22)
         mat(882) = .800_r8*rxt(305)*y(22)
         mat(592) = .500_r8*rxt(286)*y(6)
         mat(970) = rxt(322)*y(6) + .800_r8*rxt(324)*y(13) + .150_r8*rxt(323)*y(23)
         mat(1004) = .800_r8*rxt(382)*y(13)
         mat(1045) = .250_r8*rxt(387)*y(6) + .800_r8*rxt(390)*y(13) + .250_r8*rxt(391) &
                      *y(48)

         mat(1209) = -(rxt(168)*y(1) + (rxt(169) + rxt(170) + rxt(171)) * y(23))
         mat(1344) = -rxt(168)*y(21)
         mat(1703) = -(rxt(169) + rxt(170) + rxt(171)) * y(21)

         mat(1879) = rxt(179)*y(20) + rxt(172)*y(22)
         mat(1898) = rxt(163)*y(20)
         mat(873) = rxt(179)*y(2) + rxt(163)*y(3) + rxt(177)*y(22) + rxt(209)*y(27)
         mat(937) = rxt(264)*y(22)
         mat(1518) = rxt(172)*y(2) + rxt(177)*y(20) + rxt(264)*y(17) + rxt(267)*y(16)
         mat(1293) = rxt(267)*y(22)
         mat(1611) = rxt(209)*y(20)

         mat(1713) = -((rxt(169) + rxt(170) + rxt(171)) * y(21) + rxt(174)*y(22) &
                      + rxt(180)*y(2) + rxt(181)*y(1) + 4._r8*rxt(182)*y(23) + rxt(192) &
                      *y(6) + rxt(204)*y(8) + rxt(205)*y(7) + (rxt(211) + rxt(212) &
                      ) * y(27) + rxt(218)*y(29) + rxt(236)*y(36) + rxt(240)*y(37) &
                      + rxt(269)*y(16) + rxt(271)*y(13) + rxt(279)*y(43) + rxt(287) &
                      *y(55) + rxt(293)*y(46) + rxt(301)*y(48) + rxt(314)*y(61) &
                      + rxt(319)*y(64) + rxt(323)*y(67) + rxt(338)*y(74) + rxt(345) &
                      *y(79) + rxt(351)*y(76) + rxt(368)*y(97) + rxt(369)*y(98) &
                      + rxt(380)*y(101) + rxt(389)*y(103) + rxt(398)*y(93) + rxt(403) &
                      *y(114) + rxt(408)*y(117) + rxt(411)*y(113) + rxt(415)*y(124) &
                      + rxt(418)*y(126) + rxt(425)*y(129) + rxt(426)*y(108) + rxt(429) &
                      *y(130) + rxt(431)*y(131) + rxt(438)*y(135) + rxt(440)*y(137) &
                      + rxt(450)*y(143) + rxt(457)*y(146) + rxt(461)*y(151))
         mat(1214) = -(rxt(169) + rxt(170) + rxt(171)) * y(23)
         mat(1528) = -rxt(174)*y(23)
         mat(1888) = -rxt(180)*y(23)
         mat(1354) = -rxt(181)*y(23)
         mat(1790) = -rxt(192)*y(23)
         mat(1863) = -rxt(204)*y(23)
         mat(1567) = -rxt(205)*y(23)
         mat(1620) = -(rxt(211) + rxt(212)) * y(23)
         mat(1377) = -rxt(218)*y(23)
         mat(1808) = -rxt(236)*y(23)
         mat(1280) = -rxt(240)*y(23)
         mat(1300) = -rxt(269)*y(23)
         mat(1261) = -rxt(271)*y(23)
         mat(322) = -rxt(279)*y(23)
         mat(595) = -rxt(287)*y(23)
         mat(697) = -rxt(293)*y(23)
         mat(1196) = -rxt(301)*y(23)
         mat(665) = -rxt(314)*y(23)
         mat(638) = -rxt(319)*y(23)
         mat(973) = -rxt(323)*y(23)
         mat(550) = -rxt(338)*y(23)
         mat(1115) = -rxt(345)*y(23)
         mat(1165) = -rxt(351)*y(23)
         mat(1075) = -rxt(368)*y(23)
         mat(1148) = -rxt(369)*y(23)
         mat(1007) = -rxt(380)*y(23)
         mat(1048) = -rxt(389)*y(23)
         mat(836) = -rxt(398)*y(23)
         mat(335) = -rxt(403)*y(23)
         mat(520) = -rxt(408)*y(23)
         mat(373) = -rxt(411)*y(23)
         mat(571) = -rxt(415)*y(23)
         mat(349) = -rxt(418)*y(23)
         mat(413) = -rxt(425)*y(23)
         mat(586) = -rxt(426)*y(23)
         mat(628) = -rxt(429)*y(23)
         mat(934) = -rxt(431)*y(23)
         mat(399) = -rxt(438)*y(23)
         mat(620) = -rxt(440)*y(23)
         mat(746) = -rxt(450)*y(23)
         mat(925) = -rxt(457)*y(23)
         mat(897) = -rxt(461)*y(23)

         mat(1354) = mat(1354) + rxt(173)*y(22) + .280_r8*rxt(311)*y(59) &
                      + .370_r8*rxt(360)*y(92) + .130_r8*rxt(290)*y(44) &
                      + .570_r8*rxt(445)*y(141) + .570_r8*rxt(446)*y(142) &
                      + .280_r8*rxt(335)*y(77) + .140_r8*rxt(341)*y(78)
         mat(1888) = mat(1888) + rxt(268)*y(16) + rxt(183)*y(24)
         mat(939) = rxt(265)*y(22)
         mat(1790) = mat(1790) + rxt(270)*y(13) + rxt(318)*y(64) + rxt(331)*y(73) &
                      + rxt(395)*y(93) + rxt(428)*y(108) + .800_r8*rxt(449)*y(143) &
                      + rxt(410)*y(113) + rxt(402)*y(114) + .400_r8*rxt(414)*y(124) &
                      + rxt(420)*y(126) + .170_r8*rxt(430)*y(130) + .830_r8*rxt(432) &
                      *y(131) + rxt(437)*y(135) + rxt(442)*y(137) + .900_r8*rxt(456) &
                      *y(146) + .920_r8*rxt(362)*y(97) + .920_r8*rxt(363)*y(98) &
                      + .470_r8*rxt(342)*y(79) + rxt(292)*y(46) + rxt(313)*y(61) &
                      + .250_r8*rxt(286)*y(55) + rxt(378)*y(101) + rxt(387)*y(103) &
                      + rxt(278)*y(43)
         mat(1528) = mat(1528) + rxt(173)*y(1) + rxt(265)*y(17) + rxt(203)*y(8) &
                      + rxt(184)*y(18) + rxt(185)*y(19) + rxt(178)*y(24) + rxt(216) &
                      *y(29) + rxt(239)*y(37) + .500_r8*rxt(357)*y(81) + rxt(358) &
                      *y(84) + .300_r8*rxt(364)*y(85) + rxt(365)*y(86) + rxt(383) &
                      *y(87) + rxt(385)*y(88) + rxt(384)*y(89) + .750_r8*rxt(399) &
                      *y(94) + .280_r8*rxt(416)*y(106) + .730_r8*rxt(417)*y(107) &
                      + rxt(306)*y(53) + .650_r8*rxt(400)*y(110) + .380_r8*rxt(435) &
                      *y(133) + .800_r8*rxt(401)*y(111) + .630_r8*rxt(436)*y(134) &
                      + .200_r8*rxt(459)*y(149) + .200_r8*rxt(348)*y(80) + rxt(274) &
                      *y(15) + rxt(307)*y(51) + rxt(305)*y(52) + rxt(326)*y(66) &
                      + .350_r8*rxt(283)*y(41) + rxt(276)*y(42) + .500_r8*rxt(489) &
                      *y(171)
         mat(1863) = mat(1863) + rxt(203)*y(22) + rxt(266)*y(16) + rxt(366)*y(97) &
                      + rxt(367)*y(98) + .470_r8*rxt(344)*y(79) + rxt(379)*y(101) &
                      + rxt(388)*y(103)
         mat(1261) = mat(1261) + rxt(270)*y(6) + 4.000_r8*rxt(272)*y(13) + rxt(219) &
                      *y(29) + .900_r8*rxt(302)*y(48) + rxt(451)*y(143) + rxt(458) &
                      *y(146) + .500_r8*rxt(462)*y(151) + rxt(372)*y(97) + rxt(373) &
                      *y(98) + .730_r8*rxt(346)*y(79) + rxt(352)*y(76) + rxt(294) &
                      *y(46) + rxt(315)*y(61) + .300_r8*rxt(324)*y(67) &
                      + 1.200_r8*rxt(382)*y(101) + .800_r8*rxt(390)*y(103)
         mat(143) = rxt(184)*y(22)
         mat(90) = rxt(185)*y(22)
         mat(1300) = mat(1300) + rxt(268)*y(2) + rxt(266)*y(8) + rxt(213)*y(27) &
                      + rxt(237)*y(36)
         mat(1713) = mat(1713) + .160_r8*rxt(415)*y(124) + .070_r8*rxt(429)*y(130) &
                      + .330_r8*rxt(431)*y(131)
         mat(488) = rxt(183)*y(2) + rxt(178)*y(22) + rxt(210)*y(27)
         mat(1620) = mat(1620) + rxt(213)*y(16) + rxt(210)*y(24)
         mat(1377) = mat(1377) + rxt(216)*y(22) + rxt(219)*y(13)
         mat(1808) = mat(1808) + rxt(237)*y(16)
         mat(1280) = mat(1280) + rxt(239)*y(22)
         mat(868) = .280_r8*rxt(311)*y(1)
         mat(728) = .370_r8*rxt(360)*y(1)
         mat(638) = mat(638) + rxt(318)*y(6)
         mat(1196) = mat(1196) + .900_r8*rxt(302)*y(13) + rxt(374)*y(97) + rxt(375) &
                      *y(98) + .470_r8*rxt(347)*y(79) + rxt(381)*y(101) + rxt(391) &
                      *y(103)
         mat(458) = .130_r8*rxt(290)*y(1)
         mat(465) = .500_r8*rxt(357)*y(22)
         mat(955) = rxt(358)*y(22)
         mat(474) = .300_r8*rxt(364)*y(22)
         mat(407) = rxt(365)*y(22)
         mat(356) = rxt(383)*y(22)
         mat(707) = rxt(385)*y(22)
         mat(275) = rxt(384)*y(22)
         mat(481) = rxt(331)*y(6)
         mat(836) = mat(836) + rxt(395)*y(6)
         mat(543) = .750_r8*rxt(399)*y(22)
         mat(179) = .280_r8*rxt(416)*y(22)
         mat(184) = .730_r8*rxt(417)*y(22)
         mat(586) = mat(586) + rxt(428)*y(6)
         mat(746) = mat(746) + .800_r8*rxt(449)*y(6) + rxt(451)*y(13)
         mat(764) = rxt(306)*y(22)
         mat(125) = .650_r8*rxt(400)*y(22)
         mat(156) = .380_r8*rxt(435)*y(22)
         mat(134) = .800_r8*rxt(401)*y(22)
         mat(373) = mat(373) + rxt(410)*y(6)
         mat(335) = mat(335) + rxt(402)*y(6)
         mat(571) = mat(571) + .400_r8*rxt(414)*y(6) + .160_r8*rxt(415)*y(23)
         mat(349) = mat(349) + rxt(420)*y(6)
         mat(628) = mat(628) + .170_r8*rxt(430)*y(6) + .070_r8*rxt(429)*y(23)
         mat(934) = mat(934) + .830_r8*rxt(432)*y(6) + .330_r8*rxt(431)*y(23)
         mat(161) = .630_r8*rxt(436)*y(22)
         mat(399) = mat(399) + rxt(437)*y(6)
         mat(620) = mat(620) + rxt(442)*y(6)
         mat(820) = .570_r8*rxt(445)*y(1)
         mat(791) = .570_r8*rxt(446)*y(1)
         mat(925) = mat(925) + .900_r8*rxt(456)*y(6) + rxt(458)*y(13)
         mat(909) = .200_r8*rxt(459)*y(22)
         mat(897) = mat(897) + .500_r8*rxt(462)*y(13)
         mat(1075) = mat(1075) + .920_r8*rxt(362)*y(6) + rxt(366)*y(8) + rxt(372) &
                      *y(13) + rxt(374)*y(48)
         mat(1148) = mat(1148) + .920_r8*rxt(363)*y(6) + rxt(367)*y(8) + rxt(373) &
                      *y(13) + rxt(375)*y(48)
         mat(1094) = .280_r8*rxt(335)*y(1)
         mat(1022) = .140_r8*rxt(341)*y(1)
         mat(1115) = mat(1115) + .470_r8*rxt(342)*y(6) + .470_r8*rxt(344)*y(8) &
                      + .730_r8*rxt(346)*y(13) + .470_r8*rxt(347)*y(48)
         mat(251) = .200_r8*rxt(348)*y(22)
         mat(1165) = mat(1165) + rxt(352)*y(13)
         mat(697) = mat(697) + rxt(292)*y(6) + rxt(294)*y(13) + 2.400_r8*rxt(295) &
                      *y(46)
         mat(665) = mat(665) + rxt(313)*y(6) + rxt(315)*y(13)
         mat(670) = rxt(274)*y(22)
         mat(212) = rxt(307)*y(22)
         mat(884) = rxt(305)*y(22)
         mat(961) = rxt(326)*y(22)
         mat(595) = mat(595) + .250_r8*rxt(286)*y(6)
         mat(973) = mat(973) + .300_r8*rxt(324)*y(13)
         mat(1007) = mat(1007) + rxt(378)*y(6) + rxt(379)*y(8) + 1.200_r8*rxt(382) &
                      *y(13) + rxt(381)*y(48)
         mat(1048) = mat(1048) + rxt(387)*y(6) + rxt(388)*y(8) + .800_r8*rxt(390) &
                      *y(13) + rxt(391)*y(48)
         mat(226) = .350_r8*rxt(283)*y(22)
         mat(674) = rxt(276)*y(22)
         mat(322) = mat(322) + rxt(278)*y(6)
         mat(197) = .500_r8*rxt(489)*y(22)


      end subroutine nlnmat03

      subroutine nlnmat04( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(483) = -(rxt(178)*y(22) + rxt(183)*y(2) + rxt(210)*y(27))
         mat(1461) = -rxt(178)*y(24)
         mat(1870) = -rxt(183)*y(24)
         mat(1598) = -rxt(210)*y(24)

         mat(1461) = mat(1461) + 2.000_r8*rxt(176)*y(22)
         mat(1655) = 2.000_r8*rxt(182)*y(23)

         mat(1200) = -(rxt(140)*y(3))
         mat(1897) = -rxt(140)*y(237)

         mat(872) = rxt(177)*y(22)
         mat(1517) = rxt(177)*y(20) + 2.000_r8*rxt(175)*y(22) + rxt(200)*y(9) &
                      + rxt(206)*y(10) + rxt(275)*y(14) + rxt(267)*y(16) + rxt(174) &
                      *y(23) + rxt(178)*y(24) + rxt(227)*y(32) + rxt(231)*y(33) &
                      + rxt(247)*y(38) + rxt(297)*y(50) + rxt(291)*y(49) + rxt(320) &
                      *y(65) + rxt(304)*y(54) + rxt(284)*y(45) + .500_r8*rxt(340) &
                      *y(78) + rxt(317)*y(60) + rxt(316)*y(62) + rxt(321)*y(63) &
                      + rxt(325)*y(69) + rxt(327)*y(68) + (rxt(392)+rxt(393))*y(104) &
                      + rxt(276)*y(42)
         mat(676) = rxt(200)*y(22)
         mat(325) = rxt(206)*y(22)
         mat(358) = rxt(275)*y(22)
         mat(1292) = rxt(267)*y(22)
         mat(1208) = rxt(171)*y(23)
         mat(1702) = rxt(174)*y(22) + rxt(171)*y(21)
         mat(484) = rxt(178)*y(22)
         mat(1579) = rxt(227)*y(22) + (rxt(495)+rxt(500)+rxt(506))*y(33) + (rxt(496) &
                       +rxt(507))*y(39)
         mat(682) = rxt(231)*y(22) + (rxt(495)+rxt(500)+rxt(506))*y(32)
         mat(650) = rxt(247)*y(22)
         mat(642) = (rxt(496)+rxt(507))*y(32)
         mat(979) = rxt(297)*y(22)
         mat(440) = rxt(291)*y(22)
         mat(447) = rxt(320)*y(22)
         mat(417) = rxt(304)*y(22)
         mat(238) = rxt(284)*y(22)
         mat(1017) = .500_r8*rxt(340)*y(22)
         mat(96) = rxt(317)*y(22)
         mat(309) = rxt(316)*y(22)
         mat(841) = rxt(321)*y(22)
         mat(315) = rxt(325)*y(22)
         mat(1027) = rxt(327)*y(22)
         mat(219) = (rxt(392)+rxt(393))*y(22)
         mat(672) = rxt(276)*y(22)

         mat(1619) = -(rxt(208)*y(1) + rxt(209)*y(20) + rxt(210)*y(24) + (rxt(211) &
                      + rxt(212)) * y(23) + rxt(213)*y(16) + rxt(230)*y(33) + rxt(234) &
                      *y(34) + rxt(282)*y(45))
         mat(1353) = -rxt(208)*y(27)
         mat(876) = -rxt(209)*y(27)
         mat(487) = -rxt(210)*y(27)
         mat(1712) = -(rxt(211) + rxt(212)) * y(27)
         mat(1299) = -rxt(213)*y(27)
         mat(686) = -rxt(230)*y(27)
         mat(757) = -rxt(234)*y(27)
         mat(241) = -rxt(282)*y(27)

         mat(1887) = rxt(215)*y(29) + rxt(228)*y(32)
         mat(1906) = rxt(164)*y(32)
         mat(1789) = rxt(220)*y(29)
         mat(1527) = rxt(216)*y(29) + rxt(227)*y(32)
         mat(1260) = rxt(219)*y(29)
         mat(1376) = rxt(215)*y(2) + rxt(220)*y(6) + rxt(216)*y(22) + rxt(219)*y(13) + ( &
                      + 4.000_r8*rxt(222)+2.000_r8*rxt(224))*y(29) + rxt(244)*y(37)
         mat(1587) = rxt(228)*y(2) + rxt(164)*y(3) + rxt(227)*y(22)
         mat(1279) = rxt(244)*y(29)


         mat(1594) = rxt(234)*y(34)
         mat(1362) = 2.000_r8*rxt(223)*y(29)
         mat(1573) = (rxt(495)+rxt(500)+rxt(506))*y(33) + (rxt(494)+rxt(499)+rxt(505)) &
                      *y(34)
         mat(680) = (rxt(495)+rxt(500)+rxt(506))*y(32)
         mat(748) = rxt(234)*y(27) + (rxt(494)+rxt(499)+rxt(505))*y(32)

         mat(1372) = -(rxt(215)*y(2) + (rxt(216) + rxt(217)) * y(22) + rxt(218)*y(23) &
                      + rxt(219)*y(13) + rxt(220)*y(6) + rxt(221)*y(7) + (4._r8*rxt(222) &
                      + 4._r8*rxt(223) + 4._r8*rxt(224) + 4._r8*rxt(225)) * y(29) &
                      + (rxt(243) + rxt(244) + rxt(245)) * y(37))
         mat(1883) = -rxt(215)*y(29)
         mat(1523) = -(rxt(216) + rxt(217)) * y(29)
         mat(1708) = -rxt(218)*y(29)
         mat(1256) = -rxt(219)*y(29)
         mat(1785) = -rxt(220)*y(29)
         mat(1562) = -rxt(221)*y(29)
         mat(1275) = -(rxt(243) + rxt(244) + rxt(245)) * y(29)

         mat(1349) = rxt(208)*y(27)
         mat(1883) = mat(1883) + rxt(229)*y(33) + rxt(232)*y(34)
         mat(1523) = mat(1523) + rxt(231)*y(33)
         mat(1708) = mat(1708) + rxt(212)*y(27)
         mat(1615) = rxt(208)*y(1) + rxt(212)*y(23) + rxt(230)*y(33)
         mat(683) = rxt(229)*y(2) + rxt(231)*y(22) + rxt(230)*y(27)
         mat(753) = rxt(232)*y(2)


         mat(1361) = 2.000_r8*rxt(224)*y(29) + rxt(243)*y(37)
         mat(1266) = rxt(243)*y(29)


         mat(1360) = 2.000_r8*rxt(225)*y(29)

         mat(1586) = -(rxt(164)*y(3) + rxt(227)*y(22) + rxt(228)*y(2) + (rxt(494) &
                      + rxt(499) + rxt(505)) * y(34) + (rxt(495) + rxt(500) + rxt(506) &
                      ) * y(33) + (rxt(496) + rxt(507)) * y(39))
         mat(1905) = -rxt(164)*y(32)
         mat(1526) = -rxt(227)*y(32)
         mat(1886) = -rxt(228)*y(32)
         mat(756) = -(rxt(494) + rxt(499) + rxt(505)) * y(32)
         mat(685) = -(rxt(495) + rxt(500) + rxt(506)) * y(32)
         mat(645) = -(rxt(496) + rxt(507)) * y(32)

         mat(875) = rxt(209)*y(27)
         mat(1526) = mat(1526) + rxt(217)*y(29)
         mat(1298) = rxt(213)*y(27)
         mat(1711) = rxt(211)*y(27)
         mat(486) = rxt(210)*y(27)
         mat(1618) = rxt(209)*y(20) + rxt(213)*y(16) + rxt(211)*y(23) + rxt(210)*y(24) &
                      + rxt(230)*y(33) + rxt(282)*y(45)
         mat(1375) = rxt(217)*y(22)
         mat(685) = mat(685) + rxt(230)*y(27)
         mat(240) = rxt(282)*y(27)

         mat(681) = -(rxt(229)*y(2) + rxt(230)*y(27) + rxt(231)*y(22) + (rxt(495) &
                      + rxt(500) + rxt(506)) * y(32))
         mat(1874) = -rxt(229)*y(33)
         mat(1601) = -rxt(230)*y(33)
         mat(1482) = -rxt(231)*y(33)
         mat(1577) = -(rxt(495) + rxt(500) + rxt(506)) * y(33)

         mat(1482) = mat(1482) + rxt(233)*y(34)
         mat(1674) = rxt(218)*y(29)
         mat(1364) = rxt(218)*y(23)
         mat(750) = rxt(233)*y(22)

         mat(751) = -(rxt(232)*y(2) + rxt(233)*y(22) + rxt(234)*y(27) + (rxt(494) &
                      + rxt(499) + rxt(505)) * y(32))
         mat(1875) = -rxt(232)*y(34)
         mat(1488) = -rxt(233)*y(34)
         mat(1603) = -rxt(234)*y(34)
         mat(1578) = -(rxt(494) + rxt(499) + rxt(505)) * y(34)

         mat(1548) = rxt(221)*y(29)
         mat(1365) = rxt(221)*y(7)


         mat(1363) = rxt(245)*y(37)
         mat(1574) = (rxt(496)+rxt(507))*y(39)
         mat(1267) = rxt(245)*y(29)
         mat(640) = (rxt(496)+rxt(507))*y(32)

         mat(1810) = -(rxt(235)*y(1) + rxt(236)*y(23) + rxt(237)*y(16))
         mat(1356) = -rxt(235)*y(36)
         mat(1715) = -rxt(236)*y(36)
         mat(1302) = -rxt(237)*y(36)

         mat(1890) = rxt(238)*y(37) + rxt(248)*y(38)
         mat(1909) = rxt(165)*y(38)
         mat(1792) = rxt(241)*y(37)
         mat(1530) = rxt(239)*y(37) + rxt(247)*y(38)
         mat(1379) = (rxt(243)+rxt(244))*y(37)
         mat(1282) = rxt(238)*y(2) + rxt(241)*y(6) + rxt(239)*y(22) + (rxt(243) &
                       +rxt(244))*y(29) + 4.000_r8*rxt(246)*y(37)
         mat(653) = rxt(248)*y(2) + rxt(165)*y(3) + rxt(247)*y(22)

         mat(1273) = -(rxt(238)*y(2) + rxt(239)*y(22) + rxt(240)*y(23) + rxt(241)*y(6) &
                      + rxt(242)*y(7) + (rxt(243) + rxt(244) + rxt(245)) * y(29) &
                      + 4._r8*rxt(246)*y(37))
         mat(1880) = -rxt(238)*y(37)
         mat(1520) = -rxt(239)*y(37)
         mat(1705) = -rxt(240)*y(37)
         mat(1782) = -rxt(241)*y(37)
         mat(1559) = -rxt(242)*y(37)
         mat(1369) = -(rxt(243) + rxt(244) + rxt(245)) * y(37)

         mat(1346) = rxt(235)*y(36)
         mat(1880) = mat(1880) + rxt(249)*y(39) + rxt(250)*y(40)
         mat(1800) = rxt(235)*y(1)
         mat(643) = rxt(249)*y(2)
         mat(434) = rxt(250)*y(2)

         mat(649) = -(rxt(165)*y(3) + rxt(247)*y(22) + rxt(248)*y(2))
         mat(1895) = -rxt(165)*y(38)
         mat(1477) = -rxt(247)*y(38)
         mat(1872) = -rxt(248)*y(38)

         mat(1287) = rxt(237)*y(36)
         mat(1671) = rxt(236)*y(36)
         mat(1796) = rxt(237)*y(16) + rxt(236)*y(23)

         mat(641) = -(rxt(249)*y(2) + (rxt(496) + rxt(507)) * y(32))
         mat(1871) = -rxt(249)*y(39)
         mat(1575) = -(rxt(496) + rxt(507)) * y(39)

         mat(1670) = rxt(240)*y(37)
         mat(1269) = rxt(240)*y(23)

         mat(431) = -(rxt(250)*y(2))
         mat(1869) = -rxt(250)*y(40)

         mat(1541) = rxt(242)*y(37)
         mat(1268) = rxt(242)*y(7)

         mat(856) = -(rxt(310)*y(22) + rxt(311)*y(1) + rxt(312)*y(8))
         mat(1495) = -rxt(310)*y(59)
         mat(1324) = -rxt(311)*y(59)
         mat(1832) = -rxt(312)*y(59)

         mat(1324) = mat(1324) + .130_r8*rxt(360)*y(92)
         mat(715) = .130_r8*rxt(360)*y(1)

         mat(714) = -(rxt(359)*y(22) + rxt(360)*y(1) + rxt(361)*y(8))
         mat(1485) = -rxt(359)*y(92)
         mat(1317) = -rxt(360)*y(92)
         mat(1824) = -rxt(361)*y(92)

         mat(631) = -(rxt(318)*y(6) + rxt(319)*y(23))
         mat(1748) = -rxt(318)*y(64)
         mat(1669) = -rxt(319)*y(64)

         mat(1476) = rxt(310)*y(59) + .500_r8*rxt(320)*y(65)
         mat(853) = rxt(310)*y(22)
         mat(444) = .500_r8*rxt(320)*y(22)

         mat(977) = -(rxt(297)*y(22) + rxt(298)*y(8))
         mat(1506) = -rxt(297)*y(50)
         mat(1842) = -rxt(298)*y(50)

         mat(1332) = .500_r8*rxt(311)*y(59) + .100_r8*rxt(335)*y(77)
         mat(1768) = rxt(318)*y(64) + rxt(331)*y(73) + .400_r8*rxt(395)*y(93) &
                      + rxt(337)*y(74) + rxt(292)*y(46) + .270_r8*rxt(313)*y(61)
         mat(1506) = mat(1506) + .800_r8*rxt(397)*y(82) + .500_r8*rxt(296)*y(47) &
                      + rxt(307)*y(51)
         mat(1842) = mat(1842) + rxt(333)*y(70)
         mat(1240) = .800_r8*rxt(294)*y(46)
         mat(1691) = .200_r8*rxt(338)*y(74)
         mat(859) = .500_r8*rxt(311)*y(1)
         mat(633) = rxt(318)*y(6)
         mat(527) = .800_r8*rxt(397)*y(22)
         mat(289) = rxt(333)*y(8)
         mat(478) = rxt(331)*y(6)
         mat(830) = .400_r8*rxt(395)*y(6)
         mat(546) = rxt(337)*y(6) + .200_r8*rxt(338)*y(23)
         mat(1082) = .100_r8*rxt(335)*y(1)
         mat(692) = rxt(292)*y(6) + .800_r8*rxt(294)*y(13) + 3.200_r8*rxt(295)*y(46)
         mat(254) = .500_r8*rxt(296)*y(22)
         mat(659) = .270_r8*rxt(313)*y(6)
         mat(210) = rxt(307)*y(22)


      end subroutine nlnmat04

      subroutine nlnmat05( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(439) = -(rxt(291)*y(22))
         mat(1455) = -rxt(291)*y(49)

         mat(1312) = .120_r8*rxt(311)*y(59)
         mat(1222) = .100_r8*rxt(302)*y(48)
         mat(1653) = .150_r8*rxt(301)*y(48) + .150_r8*rxt(351)*y(76)
         mat(852) = .120_r8*rxt(311)*y(1)
         mat(1171) = .100_r8*rxt(302)*y(13) + .150_r8*rxt(301)*y(23)
         mat(1152) = .150_r8*rxt(351)*y(23)

         mat(443) = -(rxt(320)*y(22))
         mat(1456) = -rxt(320)*y(65)

         mat(1654) = rxt(319)*y(64)
         mat(630) = rxt(319)*y(23)

         mat(1188) = -(rxt(299)*y(6) + rxt(300)*y(7) + rxt(301)*y(23) + rxt(302)*y(13) &
                      + 4._r8*rxt(303)*y(48) + rxt(347)*y(79) + rxt(374)*y(97) + rxt(375) &
                      *y(98) + rxt(381)*y(101) + rxt(391)*y(103))
         mat(1778) = -rxt(299)*y(48)
         mat(1555) = -rxt(300)*y(48)
         mat(1701) = -rxt(301)*y(48)
         mat(1250) = -rxt(302)*y(48)
         mat(1108) = -rxt(347)*y(48)
         mat(1067) = -rxt(374)*y(48)
         mat(1140) = -rxt(375)*y(48)
         mat(1001) = -rxt(381)*y(48)
         mat(1041) = -rxt(391)*y(48)

         mat(1342) = .080_r8*rxt(360)*y(92) + .060_r8*rxt(445)*y(141) &
                      + .060_r8*rxt(446)*y(142) + .280_r8*rxt(335)*y(77) &
                      + .100_r8*rxt(341)*y(78)
         mat(1778) = mat(1778) + rxt(337)*y(74) + .530_r8*rxt(342)*y(79) + rxt(349) &
                      *y(76) + rxt(322)*y(67)
         mat(1516) = rxt(297)*y(50) + .500_r8*rxt(304)*y(54) + .650_r8*rxt(459)*y(149) &
                      + rxt(327)*y(68)
         mat(1852) = rxt(298)*y(50) + .530_r8*rxt(344)*y(79) + rxt(350)*y(76) &
                      + rxt(328)*y(68)
         mat(1250) = mat(1250) + .260_r8*rxt(346)*y(79) + rxt(352)*y(76) &
                      + .300_r8*rxt(324)*y(67)
         mat(1701) = mat(1701) + .200_r8*rxt(338)*y(74) + .450_r8*rxt(351)*y(76) &
                      + .150_r8*rxt(323)*y(67)
         mat(722) = .080_r8*rxt(360)*y(1)
         mat(978) = rxt(297)*y(22) + rxt(298)*y(8)
         mat(1188) = mat(1188) + .530_r8*rxt(347)*y(79)
         mat(416) = .500_r8*rxt(304)*y(22)
         mat(547) = rxt(337)*y(6) + .200_r8*rxt(338)*y(23)
         mat(813) = .060_r8*rxt(445)*y(1)
         mat(784) = .060_r8*rxt(446)*y(1)
         mat(904) = .650_r8*rxt(459)*y(22)
         mat(1086) = .280_r8*rxt(335)*y(1)
         mat(1016) = .100_r8*rxt(341)*y(1)
         mat(1108) = mat(1108) + .530_r8*rxt(342)*y(6) + .530_r8*rxt(344)*y(8) &
                      + .260_r8*rxt(346)*y(13) + .530_r8*rxt(347)*y(48)
         mat(1157) = rxt(349)*y(6) + rxt(350)*y(8) + rxt(352)*y(13) + .450_r8*rxt(351) &
                      *y(23) + 4.000_r8*rxt(354)*y(76)
         mat(967) = rxt(322)*y(6) + .300_r8*rxt(324)*y(13) + .150_r8*rxt(323)*y(23)
         mat(1026) = rxt(327)*y(22) + rxt(328)*y(8)

         mat(415) = -(rxt(304)*y(22))
         mat(1452) = -rxt(304)*y(54)

         mat(1652) = .400_r8*rxt(301)*y(48) + .400_r8*rxt(351)*y(76)
         mat(1170) = .400_r8*rxt(301)*y(23)
         mat(1151) = .400_r8*rxt(351)*y(23)

         mat(386) = -(rxt(309)*y(22))
         mat(1448) = -rxt(309)*y(58)

         mat(1539) = rxt(300)*y(48)
         mat(1169) = rxt(300)*y(7)

         mat(236) = -(rxt(282)*y(27) + rxt(284)*y(22))
         mat(1596) = -rxt(282)*y(45)
         mat(1425) = -rxt(284)*y(45)

         mat(451) = -(rxt(281)*y(27) + rxt(285)*y(22) + rxt(290)*y(1))
         mat(1597) = -rxt(281)*y(44)
         mat(1457) = -rxt(285)*y(44)
         mat(1313) = -rxt(290)*y(44)

         mat(202) = -(rxt(394)*y(22))
         mat(1420) = -rxt(394)*y(71)

         mat(1309) = .050_r8*rxt(445)*y(141) + .050_r8*rxt(446)*y(142)
         mat(799) = .050_r8*rxt(445)*y(1)
         mat(770) = .050_r8*rxt(446)*y(1)

         mat(459) = -(rxt(357)*y(22))
         mat(1458) = -rxt(357)*y(81)

         mat(1542) = rxt(355)*y(76)
         mat(1153) = rxt(355)*y(7)

         mat(523) = -(rxt(397)*y(22))
         mat(1466) = -rxt(397)*y(82)

         mat(1741) = rxt(396)*y(93)
         mat(824) = rxt(396)*y(6)

         mat(730) = -(rxt(329)*y(22))
         mat(1486) = -rxt(329)*y(83)

         mat(1486) = mat(1486) + .500_r8*rxt(365)*y(86) + rxt(383)*y(87) + rxt(385) &
                      *y(88) + rxt(384)*y(89)
         mat(1825) = rxt(312)*y(59)
         mat(855) = rxt(312)*y(8)
         mat(402) = .500_r8*rxt(365)*y(22)
         mat(353) = rxt(383)*y(22)
         mat(701) = rxt(385)*y(22)
         mat(272) = rxt(384)*y(22)

         mat(944) = -(rxt(358)*y(22))
         mat(1503) = -rxt(358)*y(84)

         mat(1765) = rxt(332)*y(73) + rxt(343)*y(79)
         mat(1503) = mat(1503) + .300_r8*rxt(364)*y(85) + .500_r8*rxt(365)*y(86)
         mat(469) = .300_r8*rxt(364)*y(22)
         mat(404) = .500_r8*rxt(365)*y(22)
         mat(477) = rxt(332)*y(6)
         mat(1101) = rxt(343)*y(6)

         mat(467) = -(rxt(364)*y(22))
         mat(1459) = -rxt(364)*y(85)

         mat(1737) = .080_r8*rxt(362)*y(97)
         mat(1051) = .080_r8*rxt(362)*y(6)

         mat(401) = -(rxt(365)*y(22))
         mat(1450) = -rxt(365)*y(86)

         mat(1733) = .080_r8*rxt(363)*y(98)
         mat(1120) = .080_r8*rxt(363)*y(6)

         mat(351) = -(rxt(383)*y(22))
         mat(1442) = -rxt(383)*y(87)

         mat(1644) = rxt(380)*y(101)
         mat(987) = rxt(380)*y(23)

         mat(700) = -(rxt(385)*y(22))
         mat(1484) = -rxt(385)*y(88)

         mat(1752) = rxt(378)*y(101)
         mat(1823) = rxt(379)*y(101)
         mat(1226) = .800_r8*rxt(382)*y(101)
         mat(1172) = rxt(381)*y(101)
         mat(990) = rxt(378)*y(6) + rxt(379)*y(8) + .800_r8*rxt(382)*y(13) + rxt(381) &
                      *y(48)

         mat(271) = -(rxt(384)*y(22))
         mat(1431) = -rxt(384)*y(89)

         mat(1219) = .200_r8*rxt(382)*y(101)
         mat(986) = .200_r8*rxt(382)*y(13)

         mat(421) = -(rxt(464)*y(22))
         mat(1453) = -rxt(464)*y(90)

         mat(1735) = .200_r8*rxt(449)*y(143) + .200_r8*rxt(460)*y(151)
         mat(1221) = .500_r8*rxt(462)*y(151)
         mat(737) = .200_r8*rxt(449)*y(6)
         mat(886) = .200_r8*rxt(460)*y(6) + .500_r8*rxt(462)*y(13)

         mat(276) = -(rxt(465)*y(22))
         mat(1432) = -rxt(465)*y(91)

         mat(1634) = rxt(461)*y(151)
         mat(885) = rxt(461)*y(23)

         mat(286) = -(rxt(330)*y(22) + rxt(333)*y(8))
         mat(1434) = -rxt(330)*y(70)
         mat(1820) = -rxt(333)*y(70)

         mat(475) = -((rxt(331) + rxt(332)) * y(6))
         mat(1738) = -(rxt(331) + rxt(332)) * y(73)

         mat(1460) = rxt(330)*y(70)
         mat(287) = rxt(330)*y(22)

         mat(828) = -((rxt(395) + rxt(396)) * y(6) + rxt(398)*y(23))
         mat(1756) = -(rxt(395) + rxt(396)) * y(93)
         mat(1679) = -rxt(398)*y(93)

         mat(1492) = rxt(394)*y(71) + rxt(399)*y(94)
         mat(203) = rxt(394)*y(22)
         mat(537) = rxt(399)*y(22)

         mat(534) = -(rxt(399)*y(22))
         mat(1467) = -rxt(399)*y(94)

         mat(1660) = rxt(398)*y(93)
         mat(825) = rxt(398)*y(23)

         mat(426) = -(rxt(336)*y(22))
         mat(1454) = -rxt(336)*y(72)

         mat(1736) = .800_r8*rxt(395)*y(93)
         mat(823) = .800_r8*rxt(395)*y(6)

         mat(545) = -(rxt(337)*y(6) + rxt(338)*y(23))
         mat(1742) = -rxt(337)*y(74)
         mat(1661) = -rxt(338)*y(74)

         mat(1468) = rxt(336)*y(72) + rxt(339)*y(75)
         mat(427) = rxt(336)*y(22)
         mat(282) = rxt(339)*y(22)

         mat(281) = -(rxt(339)*y(22))
         mat(1433) = -rxt(339)*y(75)

         mat(1635) = .800_r8*rxt(338)*y(74)
         mat(544) = .800_r8*rxt(338)*y(23)

         mat(172) = -(rxt(416)*y(22))
         mat(1415) = -rxt(416)*y(106)

         mat(180) = -(rxt(417)*y(22))
         mat(1416) = -rxt(417)*y(107)

         mat(1416) = mat(1416) + .180_r8*rxt(416)*y(106)
         mat(173) = .180_r8*rxt(416)*y(22)

         mat(578) = -(rxt(426)*y(23) + rxt(428)*y(6))
         mat(1664) = -rxt(426)*y(108)
         mat(1744) = -rxt(428)*y(108)

         mat(1471) = .650_r8*rxt(416)*y(106) + rxt(427)*y(109)
         mat(175) = .650_r8*rxt(416)*y(22)
         mat(495) = rxt(427)*y(22)

         mat(492) = -(rxt(427)*y(22))
         mat(1462) = -rxt(427)*y(109)

         mat(1656) = rxt(426)*y(108)
         mat(575) = rxt(426)*y(23)

         mat(739) = -(rxt(449)*y(6) + rxt(450)*y(23) + rxt(451)*y(13))
         mat(1754) = -rxt(449)*y(143)
         mat(1677) = -rxt(450)*y(143)
         mat(1228) = -rxt(451)*y(143)

         mat(1487) = rxt(452)*y(144) + rxt(443)*y(141) + rxt(444)*y(142)
         mat(380) = rxt(452)*y(22)
         mat(802) = rxt(443)*y(22)
         mat(773) = rxt(444)*y(22)

         mat(379) = -(rxt(452)*y(22))
         mat(1447) = -rxt(452)*y(144)

         mat(1649) = rxt(450)*y(143)
         mat(736) = rxt(450)*y(23)


         mat(1310) = .100_r8*rxt(445)*y(141) + .100_r8*rxt(446)*y(142)
         mat(800) = .100_r8*rxt(445)*y(1)
         mat(771) = .100_r8*rxt(446)*y(1)

         mat(761) = -(rxt(306)*y(22))
         mat(1489) = -rxt(306)*y(53)

         mat(1755) = .600_r8*rxt(428)*y(108) + rxt(410)*y(113) + .700_r8*rxt(402) &
                      *y(114) + .400_r8*rxt(414)*y(124) + .170_r8*rxt(432)*y(131) &
                      + .170_r8*rxt(437)*y(135) + .340_r8*rxt(442)*y(137) &
                      + .050_r8*rxt(363)*y(98) + .250_r8*rxt(387)*y(103)
         mat(1489) = mat(1489) + rxt(385)*y(88) + .200_r8*rxt(305)*y(52) &
                      + .650_r8*rxt(283)*y(41)
         mat(1826) = .050_r8*rxt(367)*y(98) + .250_r8*rxt(388)*y(103)
         mat(1229) = .100_r8*rxt(390)*y(103)
         mat(1678) = .160_r8*rxt(415)*y(124) + .070_r8*rxt(431)*y(131)
         mat(1174) = .250_r8*rxt(391)*y(103)
         mat(702) = rxt(385)*y(22)
         mat(580) = .600_r8*rxt(428)*y(6)
         mat(370) = rxt(410)*y(6)
         mat(332) = .700_r8*rxt(402)*y(6)
         mat(568) = .400_r8*rxt(414)*y(6) + .160_r8*rxt(415)*y(23)
         mat(927) = .170_r8*rxt(432)*y(6) + .070_r8*rxt(431)*y(23)
         mat(395) = .170_r8*rxt(437)*y(6)
         mat(613) = .340_r8*rxt(442)*y(6)
         mat(1125) = .050_r8*rxt(363)*y(6) + .050_r8*rxt(367)*y(8)
         mat(879) = .200_r8*rxt(305)*y(22)
         mat(1035) = .250_r8*rxt(387)*y(6) + .250_r8*rxt(388)*y(8) + .100_r8*rxt(390) &
                      *y(13) + .250_r8*rxt(391)*y(48)
         mat(223) = .650_r8*rxt(283)*y(22)


      end subroutine nlnmat05

      subroutine nlnmat06( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(120) = -(rxt(400)*y(22))
         mat(1408) = -rxt(400)*y(110)

         mat(150) = -(rxt(435)*y(22))
         mat(1412) = -rxt(435)*y(133)

         mat(130) = -(rxt(401)*y(22))
         mat(1410) = -rxt(401)*y(111)

         mat(1410) = mat(1410) + .530_r8*rxt(400)*y(110)
         mat(122) = .530_r8*rxt(400)*y(22)


         mat(1409) = .120_r8*rxt(400)*y(110)
         mat(121) = .120_r8*rxt(400)*y(22)

         mat(368) = -(rxt(410)*y(6) + rxt(411)*y(23))
         mat(1730) = -rxt(410)*y(113)
         mat(1647) = -rxt(411)*y(113)

         mat(1445) = .350_r8*rxt(400)*y(110) + rxt(412)*y(119)
         mat(123) = .350_r8*rxt(400)*y(22)
         mat(339) = rxt(412)*y(22)

         mat(331) = -(rxt(402)*y(6) + rxt(403)*y(23))
         mat(1727) = -rxt(402)*y(114)
         mat(1641) = -rxt(403)*y(114)

         mat(1439) = .200_r8*rxt(417)*y(107) + .140_r8*rxt(401)*y(111) + rxt(404) &
                      *y(116)
         mat(181) = .200_r8*rxt(417)*y(22)
         mat(131) = .140_r8*rxt(401)*y(22)
         mat(261) = rxt(404)*y(22)

         mat(375) = -(rxt(405)*y(7) + rxt(406)*y(1))
         mat(1538) = -rxt(405)*y(115)
         mat(1311) = -rxt(406)*y(115)

         mat(1731) = rxt(407)*y(117)
         mat(1446) = .070_r8*rxt(417)*y(107) + .060_r8*rxt(401)*y(111) &
                      + .070_r8*rxt(436)*y(134)
         mat(182) = .070_r8*rxt(417)*y(22)
         mat(132) = .060_r8*rxt(401)*y(22)
         mat(515) = rxt(407)*y(6)
         mat(158) = .070_r8*rxt(436)*y(22)

         mat(260) = -(rxt(404)*y(22))
         mat(1429) = -rxt(404)*y(116)

         mat(1632) = rxt(403)*y(114)
         mat(330) = rxt(403)*y(23)

         mat(516) = -(rxt(407)*y(6) + rxt(408)*y(23))
         mat(1740) = -rxt(407)*y(117)
         mat(1659) = -rxt(408)*y(117)

         mat(1314) = rxt(406)*y(115)
         mat(1740) = mat(1740) + rxt(424)*y(129)
         mat(1465) = rxt(409)*y(118)
         mat(1659) = mat(1659) + .400_r8*rxt(425)*y(129)
         mat(376) = rxt(406)*y(1)
         mat(207) = rxt(409)*y(22)
         mat(410) = rxt(424)*y(6) + .400_r8*rxt(425)*y(23)

         mat(205) = -(rxt(409)*y(22))
         mat(1421) = -rxt(409)*y(118)

         mat(1627) = rxt(408)*y(117)
         mat(514) = rxt(408)*y(23)

         mat(337) = -(rxt(412)*y(22))
         mat(1440) = -rxt(412)*y(119)

         mat(1642) = rxt(411)*y(113)
         mat(366) = rxt(411)*y(23)


         mat(1729) = .200_r8*rxt(428)*y(108) + .500_r8*rxt(410)*y(113) &
                      + .060_r8*rxt(442)*y(137)
         mat(574) = .200_r8*rxt(428)*y(6)
         mat(367) = .500_r8*rxt(410)*y(6)
         mat(607) = .060_r8*rxt(442)*y(6)


         mat(1723) = .200_r8*rxt(428)*y(108) + .200_r8*rxt(442)*y(137)
         mat(573) = .200_r8*rxt(428)*y(6)
         mat(605) = .200_r8*rxt(442)*y(6)


         mat(1739) = .200_r8*rxt(428)*y(108) + .150_r8*rxt(442)*y(137)
         mat(576) = .200_r8*rxt(428)*y(6)
         mat(608) = .150_r8*rxt(442)*y(6)


         mat(1724) = .210_r8*rxt(442)*y(137)
         mat(606) = .210_r8*rxt(442)*y(6)

         mat(567) = -(rxt(413)*y(7) + rxt(414)*y(6) + rxt(415)*y(23))
         mat(1544) = -rxt(413)*y(124)
         mat(1743) = -rxt(414)*y(124)
         mat(1663) = -rxt(415)*y(124)


         mat(1414) = .100_r8*rxt(416)*y(106) + .230_r8*rxt(435)*y(133)
         mat(171) = .100_r8*rxt(416)*y(22)
         mat(152) = .230_r8*rxt(435)*y(22)

         mat(345) = -(rxt(418)*y(23) + rxt(420)*y(6))
         mat(1643) = -rxt(418)*y(126)
         mat(1728) = -rxt(420)*y(126)

         mat(1441) = .070_r8*rxt(416)*y(106) + .060_r8*rxt(435)*y(133) + rxt(419) &
                      *y(127)
         mat(174) = .070_r8*rxt(416)*y(22)
         mat(153) = .060_r8*rxt(435)*y(22)
         mat(267) = rxt(419)*y(22)

         mat(266) = -(rxt(419)*y(22))
         mat(1430) = -rxt(419)*y(127)

         mat(1633) = rxt(418)*y(126)
         mat(344) = rxt(418)*y(23)

         mat(185) = -(rxt(421)*y(22))
         mat(1417) = -rxt(421)*y(128)

         mat(1721) = rxt(420)*y(126)
         mat(343) = rxt(420)*y(6)

         mat(409) = -(rxt(422)*y(7) + rxt(424)*y(6) + rxt(425)*y(23))
         mat(1540) = -rxt(422)*y(129)
         mat(1734) = -rxt(424)*y(129)
         mat(1651) = -rxt(425)*y(129)

         mat(1451) = rxt(421)*y(128)
         mat(186) = rxt(421)*y(22)

         mat(622) = -(rxt(429)*y(23) + rxt(430)*y(6) + rxt(433)*y(7))
         mat(1668) = -rxt(429)*y(130)
         mat(1747) = -rxt(430)*y(130)
         mat(1545) = -rxt(433)*y(130)

         mat(928) = -(rxt(431)*y(23) + rxt(432)*y(6) + rxt(434)*y(7))
         mat(1687) = -rxt(431)*y(131)
         mat(1763) = -rxt(432)*y(131)
         mat(1550) = -rxt(434)*y(131)


         mat(1534) = rxt(422)*y(129)
         mat(408) = rxt(422)*y(7)

         mat(157) = -(rxt(436)*y(22))
         mat(1413) = -rxt(436)*y(134)

         mat(1413) = mat(1413) + .150_r8*rxt(435)*y(133)
         mat(151) = .150_r8*rxt(435)*y(22)

         mat(394) = -(rxt(437)*y(6) + rxt(438)*y(23))
         mat(1732) = -rxt(437)*y(135)
         mat(1650) = -rxt(438)*y(135)

         mat(1449) = .300_r8*rxt(436)*y(134) + rxt(439)*y(136)
         mat(159) = .300_r8*rxt(436)*y(22)
         mat(295) = rxt(439)*y(22)

         mat(294) = -(rxt(439)*y(22))
         mat(1435) = -rxt(439)*y(136)

         mat(1636) = rxt(438)*y(135)
         mat(393) = rxt(438)*y(23)

         mat(611) = -(rxt(440)*y(23) + rxt(442)*y(6))
         mat(1667) = -rxt(440)*y(137)
         mat(1746) = -rxt(442)*y(137)

         mat(1474) = .560_r8*rxt(435)*y(133) + rxt(441)*y(138)
         mat(154) = .560_r8*rxt(435)*y(22)
         mat(558) = rxt(441)*y(22)

         mat(556) = -(rxt(441)*y(22))
         mat(1469) = -rxt(441)*y(138)

         mat(1662) = rxt(440)*y(137)
         mat(609) = rxt(440)*y(23)

         mat(804) = -(rxt(443)*y(22) + rxt(445)*y(1) + rxt(447)*y(8))
         mat(1491) = -rxt(443)*y(141)
         mat(1320) = -rxt(445)*y(141)
         mat(1828) = -rxt(447)*y(141)

         mat(775) = -(rxt(444)*y(22) + rxt(446)*y(1) + rxt(448)*y(8))
         mat(1490) = -rxt(444)*y(142)
         mat(1319) = -rxt(446)*y(142)
         mat(1827) = -rxt(448)*y(142)

         mat(12) = -(rxt(470)*y(22))
         mat(1389) = -rxt(470)*y(140)

         mat(29) = -(rxt(469)*y(22))
         mat(1396) = -rxt(469)*y(139)

         mat(18) = -(rxt(472)*y(22))
         mat(1390) = -rxt(472)*y(148)

         mat(35) = -(rxt(471)*y(22))
         mat(1397) = -rxt(471)*y(147)

         mat(844) = -(rxt(454)*y(22) + rxt(455)*y(8))
         mat(1494) = -rxt(454)*y(145)
         mat(1831) = -rxt(455)*y(145)

         mat(1323) = .330_r8*rxt(445)*y(141) + .330_r8*rxt(446)*y(142)
         mat(1758) = .800_r8*rxt(449)*y(143) + .800_r8*rxt(460)*y(151)
         mat(1494) = mat(1494) + rxt(464)*y(90)
         mat(1831) = mat(1831) + rxt(463)*y(151)
         mat(1231) = rxt(451)*y(143) + .500_r8*rxt(462)*y(151)
         mat(422) = rxt(464)*y(22)
         mat(741) = .800_r8*rxt(449)*y(6) + rxt(451)*y(13)
         mat(807) = .330_r8*rxt(445)*y(1)
         mat(778) = .330_r8*rxt(446)*y(1)
         mat(888) = .800_r8*rxt(460)*y(6) + rxt(463)*y(8) + .500_r8*rxt(462)*y(13)

         mat(916) = -(rxt(456)*y(6) + rxt(457)*y(23) + rxt(458)*y(13))
         mat(1762) = -rxt(456)*y(146)
         mat(1686) = -rxt(457)*y(146)
         mat(1235) = -rxt(458)*y(146)

         mat(1500) = rxt(454)*y(145) + rxt(453)*y(150)
         mat(1836) = .500_r8*rxt(455)*y(145)
         mat(847) = rxt(454)*y(22) + .500_r8*rxt(455)*y(8)
         mat(505) = rxt(453)*y(22)

         mat(901) = -(rxt(459)*y(22))
         mat(1499) = -rxt(459)*y(149)

         mat(1327) = .300_r8*rxt(445)*y(141) + .300_r8*rxt(446)*y(142)
         mat(1761) = .900_r8*rxt(456)*y(146)
         mat(1234) = rxt(458)*y(146)
         mat(809) = .300_r8*rxt(445)*y(1)
         mat(780) = .300_r8*rxt(446)*y(1)
         mat(915) = .900_r8*rxt(456)*y(6) + rxt(458)*y(13)

         mat(501) = -(rxt(453)*y(22))
         mat(1463) = -rxt(453)*y(150)

         mat(1657) = rxt(457)*y(146)
         mat(911) = rxt(457)*y(23)

         mat(889) = -(rxt(460)*y(6) + rxt(461)*y(23) + rxt(462)*y(13) + rxt(463)*y(8))
         mat(1760) = -rxt(460)*y(151)
         mat(1684) = -rxt(461)*y(151)
         mat(1233) = -rxt(462)*y(151)
         mat(1834) = -rxt(463)*y(151)

         mat(1498) = rxt(465)*y(91)
         mat(1834) = mat(1834) + rxt(447)*y(141) + rxt(448)*y(142) + .500_r8*rxt(455) &
                      *y(145)
         mat(278) = rxt(465)*y(22)
         mat(808) = rxt(447)*y(8)
         mat(779) = rxt(448)*y(8)
         mat(845) = .500_r8*rxt(455)*y(8)

         mat(1063) = -(rxt(362)*y(6) + rxt(366)*y(8) + rxt(368)*y(23) + rxt(372)*y(13) &
                      + rxt(374)*y(48))
         mat(1773) = -rxt(362)*y(97)
         mat(1847) = -rxt(366)*y(97)
         mat(1696) = -rxt(368)*y(97)
         mat(1245) = -rxt(372)*y(97)
         mat(1183) = -rxt(374)*y(97)

         mat(1511) = .600_r8*rxt(359)*y(92)
         mat(719) = .600_r8*rxt(359)*y(22)


      end subroutine nlnmat06

      subroutine nlnmat07( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(1138) = -(rxt(363)*y(6) + rxt(367)*y(8) + rxt(369)*y(23) + rxt(373)*y(13) &
                      + rxt(375)*y(48))
         mat(1776) = -rxt(363)*y(98)
         mat(1850) = -rxt(367)*y(98)
         mat(1699) = -rxt(369)*y(98)
         mat(1248) = -rxt(373)*y(98)
         mat(1186) = -rxt(375)*y(98)

         mat(1514) = .400_r8*rxt(359)*y(92)
         mat(721) = .400_r8*rxt(359)*y(22)

         mat(188) = -(rxt(377)*y(22))
         mat(1418) = -rxt(377)*y(99)

         mat(104) = -(rxt(371)*y(22))
         mat(1406) = -rxt(371)*y(100)

         mat(1406) = mat(1406) + .600_r8*rxt(370)*y(105)
         mat(597) = .600_r8*rxt(370)*y(22)

         mat(1084) = -(rxt(334)*y(22) + rxt(335)*y(1))
         mat(1512) = -rxt(334)*y(77)
         mat(1338) = -rxt(335)*y(77)

         mat(1338) = mat(1338) + .200_r8*rxt(360)*y(92)
         mat(1774) = .560_r8*rxt(362)*y(97)
         mat(1848) = .600_r8*rxt(366)*y(97)
         mat(1246) = .440_r8*rxt(372)*y(97)
         mat(720) = .200_r8*rxt(360)*y(1)
         mat(1184) = .610_r8*rxt(374)*y(97)
         mat(1064) = .560_r8*rxt(362)*y(6) + .600_r8*rxt(366)*y(8) + .440_r8*rxt(372) &
                      *y(13) + .610_r8*rxt(374)*y(48)

         mat(1012) = -(rxt(340)*y(22) + rxt(341)*y(1))
         mat(1508) = -rxt(340)*y(78)
         mat(1334) = -rxt(341)*y(78)

         mat(1334) = mat(1334) + .300_r8*rxt(360)*y(92)
         mat(1770) = .360_r8*rxt(362)*y(97)
         mat(1844) = .400_r8*rxt(366)*y(97)
         mat(1242) = .310_r8*rxt(372)*y(97)
         mat(718) = .300_r8*rxt(360)*y(1)
         mat(1180) = .390_r8*rxt(374)*y(97)
         mat(1060) = .360_r8*rxt(362)*y(6) + .400_r8*rxt(366)*y(8) + .310_r8*rxt(372) &
                      *y(13) + .390_r8*rxt(374)*y(48)

         mat(1106) = -((rxt(342) + rxt(343)) * y(6) + rxt(344)*y(8) + rxt(345)*y(23) &
                      + rxt(346)*y(13) + rxt(347)*y(48))
         mat(1775) = -(rxt(342) + rxt(343)) * y(79)
         mat(1849) = -rxt(344)*y(79)
         mat(1698) = -rxt(345)*y(79)
         mat(1247) = -rxt(346)*y(79)
         mat(1185) = -rxt(347)*y(79)

         mat(1513) = rxt(334)*y(77) + .500_r8*rxt(340)*y(78) + .200_r8*rxt(348)*y(80)
         mat(1085) = rxt(334)*y(22)
         mat(1014) = .500_r8*rxt(340)*y(22)
         mat(248) = .200_r8*rxt(348)*y(22)

         mat(247) = -(rxt(348)*y(22))
         mat(1426) = -rxt(348)*y(80)

         mat(1630) = rxt(345)*y(79)
         mat(1097) = rxt(345)*y(23)

         mat(1156) = -(rxt(349)*y(6) + rxt(350)*y(8) + rxt(351)*y(23) + rxt(352)*y(13) &
                      + rxt(353)*y(48) + 4._r8*rxt(354)*y(76) + rxt(355)*y(7))
         mat(1777) = -rxt(349)*y(76)
         mat(1851) = -rxt(350)*y(76)
         mat(1700) = -rxt(351)*y(76)
         mat(1249) = -rxt(352)*y(76)
         mat(1187) = -rxt(353)*y(76)
         mat(1554) = -rxt(355)*y(76)

         mat(1515) = .500_r8*rxt(340)*y(78) + .500_r8*rxt(348)*y(80)
         mat(1015) = .500_r8*rxt(340)*y(22)
         mat(249) = .500_r8*rxt(348)*y(22)

         mat(691) = -(rxt(292)*y(6) + rxt(293)*y(23) + rxt(294)*y(13) + 4._r8*rxt(295) &
                      *y(46))
         mat(1751) = -rxt(292)*y(46)
         mat(1675) = -rxt(293)*y(46)
         mat(1225) = -rxt(294)*y(46)

         mat(1483) = rxt(284)*y(45) + .500_r8*rxt(296)*y(47)
         mat(1602) = rxt(282)*y(45)
         mat(237) = rxt(284)*y(22) + rxt(282)*y(27)
         mat(253) = .500_r8*rxt(296)*y(22)

         mat(252) = -(rxt(296)*y(22))
         mat(1427) = -rxt(296)*y(47)

         mat(1631) = rxt(293)*y(46)
         mat(689) = rxt(293)*y(23)

         mat(94) = -(rxt(317)*y(22))
         mat(1404) = -rxt(317)*y(60)

         mat(657) = -(rxt(313)*y(6) + rxt(314)*y(23) + rxt(315)*y(13))
         mat(1749) = -rxt(313)*y(61)
         mat(1672) = -rxt(314)*y(61)
         mat(1223) = -rxt(315)*y(61)

         mat(1478) = rxt(317)*y(60) + rxt(316)*y(62)
         mat(95) = rxt(317)*y(22)
         mat(307) = rxt(316)*y(22)

         mat(306) = -(rxt(316)*y(22))
         mat(1436) = -rxt(316)*y(62)

         mat(1637) = rxt(314)*y(61)
         mat(656) = rxt(314)*y(23)

         mat(838) = -(rxt(321)*y(22))
         mat(1493) = -rxt(321)*y(63)

         mat(1322) = .520_r8*rxt(445)*y(141) + .520_r8*rxt(446)*y(142)
         mat(1757) = .500_r8*rxt(331)*y(73) + .250_r8*rxt(395)*y(93) &
                      + .040_r8*rxt(449)*y(143) + .270_r8*rxt(456)*y(146) &
                      + .820_r8*rxt(313)*y(61)
         mat(1493) = mat(1493) + .800_r8*rxt(397)*y(82) + .750_r8*rxt(399)*y(94) &
                      + .500_r8*rxt(459)*y(149)
         mat(1830) = .500_r8*rxt(333)*y(70)
         mat(1230) = .025_r8*rxt(451)*y(143) + .150_r8*rxt(458)*y(146) &
                      + .820_r8*rxt(315)*y(61)
         mat(526) = .800_r8*rxt(397)*y(22)
         mat(288) = .500_r8*rxt(333)*y(8)
         mat(476) = .500_r8*rxt(331)*y(6)
         mat(829) = .250_r8*rxt(395)*y(6)
         mat(538) = .750_r8*rxt(399)*y(22)
         mat(740) = .040_r8*rxt(449)*y(6) + .025_r8*rxt(451)*y(13)
         mat(806) = .520_r8*rxt(445)*y(1)
         mat(777) = .520_r8*rxt(446)*y(1)
         mat(913) = .270_r8*rxt(456)*y(6) + .150_r8*rxt(458)*y(13)
         mat(900) = .500_r8*rxt(459)*y(22)
         mat(658) = .820_r8*rxt(313)*y(6) + .820_r8*rxt(315)*y(13)

         mat(312) = -(rxt(325)*y(22))
         mat(1437) = -rxt(325)*y(69)

         mat(1638) = .850_r8*rxt(323)*y(67)
         mat(962) = .850_r8*rxt(323)*y(23)

         mat(667) = -(rxt(274)*y(22))
         mat(1479) = -rxt(274)*y(15)

         mat(1224) = 2.000_r8*rxt(273)*y(13) + .250_r8*rxt(451)*y(143) &
                      + .250_r8*rxt(458)*y(146) + .250_r8*rxt(462)*y(151) &
                      + .250_r8*rxt(372)*y(97) + .250_r8*rxt(373)*y(98) &
                      + .250_r8*rxt(346)*y(79) + .300_r8*rxt(294)*y(46) &
                      + .500_r8*rxt(324)*y(67) + .200_r8*rxt(382)*y(101) &
                      + .300_r8*rxt(390)*y(103)
         mat(738) = .250_r8*rxt(451)*y(13)
         mat(912) = .250_r8*rxt(458)*y(13)
         mat(887) = .250_r8*rxt(462)*y(13)
         mat(1053) = .250_r8*rxt(372)*y(13)
         mat(1123) = .250_r8*rxt(373)*y(13)
         mat(1098) = .250_r8*rxt(346)*y(13)
         mat(690) = .300_r8*rxt(294)*y(13)
         mat(963) = .500_r8*rxt(324)*y(13)
         mat(989) = .200_r8*rxt(382)*y(13)
         mat(1034) = .300_r8*rxt(390)*y(13)

         mat(209) = -(rxt(307)*y(22))
         mat(1422) = -rxt(307)*y(51)

         mat(1217) = .200_r8*rxt(294)*y(46)
         mat(688) = .200_r8*rxt(294)*y(13) + .800_r8*rxt(295)*y(46)

         mat(880) = -(rxt(305)*y(22))
         mat(1497) = -rxt(305)*y(52)

         mat(1759) = .225_r8*rxt(456)*y(146) + .050_r8*rxt(363)*y(98) &
                      + .530_r8*rxt(342)*y(79) + .250_r8*rxt(387)*y(103)
         mat(1497) = mat(1497) + .700_r8*rxt(364)*y(85) + .500_r8*rxt(365)*y(86) &
                      + rxt(384)*y(89)
         mat(1833) = .050_r8*rxt(367)*y(98) + .530_r8*rxt(344)*y(79) &
                      + .250_r8*rxt(388)*y(103)
         mat(1232) = .125_r8*rxt(458)*y(146) + .260_r8*rxt(346)*y(79) &
                      + .100_r8*rxt(390)*y(103)
         mat(1175) = .530_r8*rxt(347)*y(79) + .250_r8*rxt(391)*y(103)
         mat(468) = .700_r8*rxt(364)*y(22)
         mat(403) = .500_r8*rxt(365)*y(22)
         mat(273) = rxt(384)*y(22)
         mat(914) = .225_r8*rxt(456)*y(6) + .125_r8*rxt(458)*y(13)
         mat(1126) = .050_r8*rxt(363)*y(6) + .050_r8*rxt(367)*y(8)
         mat(1099) = .530_r8*rxt(342)*y(6) + .530_r8*rxt(344)*y(8) + .260_r8*rxt(346) &
                      *y(13) + .530_r8*rxt(347)*y(48)
         mat(1036) = .250_r8*rxt(387)*y(6) + .250_r8*rxt(388)*y(8) + .100_r8*rxt(390) &
                      *y(13) + .250_r8*rxt(391)*y(48)

         mat(956) = -(rxt(326)*y(22))
         mat(1504) = -rxt(326)*y(66)

         mat(1766) = .050_r8*rxt(363)*y(98) + .220_r8*rxt(342)*y(79) &
                      + .250_r8*rxt(387)*y(103)
         mat(1504) = mat(1504) + .500_r8*rxt(320)*y(65) + .500_r8*rxt(357)*y(81) &
                      + .700_r8*rxt(364)*y(85) + .500_r8*rxt(365)*y(86)
         mat(1840) = .050_r8*rxt(367)*y(98) + .220_r8*rxt(344)*y(79) &
                      + .250_r8*rxt(388)*y(103)
         mat(1238) = .230_r8*rxt(346)*y(79) + .200_r8*rxt(324)*y(67) &
                      + .100_r8*rxt(390)*y(103)
         mat(445) = .500_r8*rxt(320)*y(22)
         mat(1178) = .220_r8*rxt(347)*y(79) + .250_r8*rxt(391)*y(103)
         mat(460) = .500_r8*rxt(357)*y(22)
         mat(470) = .700_r8*rxt(364)*y(22)
         mat(405) = .500_r8*rxt(365)*y(22)
         mat(1130) = .050_r8*rxt(363)*y(6) + .050_r8*rxt(367)*y(8)
         mat(1102) = .220_r8*rxt(342)*y(6) + .220_r8*rxt(344)*y(8) + .230_r8*rxt(346) &
                      *y(13) + .220_r8*rxt(347)*y(48)
         mat(964) = .200_r8*rxt(324)*y(13)
         mat(1038) = .250_r8*rxt(387)*y(6) + .250_r8*rxt(388)*y(8) + .100_r8*rxt(390) &
                      *y(13) + .250_r8*rxt(391)*y(48)

         mat(590) = -(rxt(286)*y(6) + rxt(287)*y(23))
         mat(1745) = -rxt(286)*y(55)
         mat(1665) = -rxt(287)*y(55)

         mat(1472) = rxt(285)*y(44)
         mat(452) = rxt(285)*y(22)


         mat(1722) = .750_r8*rxt(286)*y(55)
         mat(589) = .750_r8*rxt(286)*y(6)


         mat(1626) = rxt(287)*y(55)
         mat(588) = rxt(287)*y(23)

         mat(257) = -(rxt(386)*y(22))
         mat(1428) = -rxt(386)*y(96)

         mat(1725) = .870_r8*rxt(363)*y(98)
         mat(1819) = .950_r8*rxt(367)*y(98)
         mat(1218) = .750_r8*rxt(373)*y(98)
         mat(1168) = rxt(375)*y(98)
         mat(1119) = .870_r8*rxt(363)*y(6) + .950_r8*rxt(367)*y(8) + .750_r8*rxt(373) &
                      *y(13) + rxt(375)*y(48)

         mat(965) = -(rxt(322)*y(6) + rxt(323)*y(23) + rxt(324)*y(13))
         mat(1767) = -rxt(322)*y(67)
         mat(1690) = -rxt(323)*y(67)
         mat(1239) = -rxt(324)*y(67)

         mat(1331) = .060_r8*rxt(445)*y(141) + .060_r8*rxt(446)*y(142)
         mat(1505) = .150_r8*rxt(459)*y(149) + rxt(321)*y(63) + rxt(325)*y(69)
         mat(811) = .060_r8*rxt(445)*y(1)
         mat(782) = .060_r8*rxt(446)*y(1)
         mat(903) = .150_r8*rxt(459)*y(22)
         mat(839) = rxt(321)*y(22)
         mat(313) = rxt(325)*y(22)


      end subroutine nlnmat07

      subroutine nlnmat08( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(1025) = -(rxt(327)*y(22) + rxt(328)*y(8))
         mat(1509) = -rxt(327)*y(68)
         mat(1845) = -rxt(328)*y(68)

         mat(1335) = .500_r8*rxt(335)*y(77) + .880_r8*rxt(341)*y(78)
         mat(1771) = .400_r8*rxt(428)*y(108) + .170_r8*rxt(430)*y(130) &
                      + .170_r8*rxt(432)*y(131) + .510_r8*rxt(437)*y(135) &
                      + .540_r8*rxt(442)*y(137) + .050_r8*rxt(363)*y(98) &
                      + .250_r8*rxt(342)*y(79) + .250_r8*rxt(387)*y(103)
         mat(1509) = mat(1509) + rxt(329)*y(83) + rxt(326)*y(66)
         mat(1845) = mat(1845) + .050_r8*rxt(367)*y(98) + .250_r8*rxt(344)*y(79) &
                      + .250_r8*rxt(388)*y(103)
         mat(1243) = .240_r8*rxt(346)*y(79) + .500_r8*rxt(324)*y(67) &
                      + .100_r8*rxt(390)*y(103)
         mat(1694) = .070_r8*rxt(429)*y(130) + .070_r8*rxt(431)*y(131)
         mat(1181) = .250_r8*rxt(347)*y(79) + .250_r8*rxt(391)*y(103)
         mat(731) = rxt(329)*y(22)
         mat(583) = .400_r8*rxt(428)*y(6)
         mat(624) = .170_r8*rxt(430)*y(6) + .070_r8*rxt(429)*y(23)
         mat(930) = .170_r8*rxt(432)*y(6) + .070_r8*rxt(431)*y(23)
         mat(396) = .510_r8*rxt(437)*y(6)
         mat(616) = .540_r8*rxt(442)*y(6)
         mat(1134) = .050_r8*rxt(363)*y(6) + .050_r8*rxt(367)*y(8)
         mat(1083) = .500_r8*rxt(335)*y(1)
         mat(1013) = .880_r8*rxt(341)*y(1)
         mat(1105) = .250_r8*rxt(342)*y(6) + .250_r8*rxt(344)*y(8) + .240_r8*rxt(346) &
                      *y(13) + .250_r8*rxt(347)*y(48)
         mat(957) = rxt(326)*y(22)
         mat(966) = .500_r8*rxt(324)*y(13)
         mat(1039) = .250_r8*rxt(387)*y(6) + .250_r8*rxt(388)*y(8) + .100_r8*rxt(390) &
                      *y(13) + .250_r8*rxt(391)*y(48)

         mat(996) = -(rxt(378)*y(6) + rxt(379)*y(8) + rxt(380)*y(23) + rxt(381)*y(48) &
                      + rxt(382)*y(13))
         mat(1769) = -rxt(378)*y(101)
         mat(1843) = -rxt(379)*y(101)
         mat(1692) = -rxt(380)*y(101)
         mat(1179) = -rxt(381)*y(101)
         mat(1241) = -rxt(382)*y(101)

         mat(1843) = mat(1843) + rxt(361)*y(92)
         mat(717) = rxt(361)*y(8)


         mat(1719) = .100_r8*rxt(456)*y(146)
         mat(1407) = rxt(358)*y(84)
         mat(940) = rxt(358)*y(22)
         mat(910) = .100_r8*rxt(456)*y(6)

         mat(1040) = -(rxt(387)*y(6) + rxt(388)*y(8) + rxt(389)*y(23) + rxt(390)*y(13) &
                      + rxt(391)*y(48))
         mat(1772) = -rxt(387)*y(103)
         mat(1846) = -rxt(388)*y(103)
         mat(1695) = -rxt(389)*y(103)
         mat(1244) = -rxt(390)*y(103)
         mat(1182) = -rxt(391)*y(103)

         mat(1510) = rxt(377)*y(99) + rxt(371)*y(100) + rxt(386)*y(96) + rxt(392) &
                      *y(104) + .400_r8*rxt(370)*y(105)
         mat(190) = rxt(377)*y(22)
         mat(105) = rxt(371)*y(22)
         mat(258) = rxt(386)*y(22)
         mat(218) = rxt(392)*y(22)
         mat(600) = .400_r8*rxt(370)*y(22)

         mat(217) = -((rxt(392) + rxt(393)) * y(22))
         mat(1423) = -(rxt(392) + rxt(393)) * y(104)

         mat(1629) = rxt(389)*y(103)
         mat(1033) = rxt(389)*y(23)

         mat(598) = -(rxt(370)*y(22))
         mat(1473) = -rxt(370)*y(105)

         mat(1666) = rxt(368)*y(97) + rxt(369)*y(98)
         mat(1052) = rxt(368)*y(23)
         mat(1122) = rxt(369)*y(23)

         mat(221) = -(rxt(280)*y(27) + rxt(283)*y(22))
         mat(1595) = -rxt(280)*y(41)
         mat(1424) = -rxt(283)*y(41)

         mat(671) = -(rxt(276)*y(22))
         mat(1480) = -rxt(276)*y(42)

         mat(1316) = .120_r8*rxt(311)*y(59) + .110_r8*rxt(360)*y(92) &
                      + .370_r8*rxt(290)*y(44) + .050_r8*rxt(445)*y(141) &
                      + .050_r8*rxt(446)*y(142) + .120_r8*rxt(335)*y(77) &
                      + .330_r8*rxt(341)*y(78)
         mat(1750) = rxt(278)*y(43)
         mat(1480) = mat(1480) + .350_r8*rxt(283)*y(41)
         mat(1673) = rxt(279)*y(43)
         mat(854) = .120_r8*rxt(311)*y(1)
         mat(713) = .110_r8*rxt(360)*y(1)
         mat(453) = .370_r8*rxt(290)*y(1)
         mat(801) = .050_r8*rxt(445)*y(1)
         mat(772) = .050_r8*rxt(446)*y(1)
         mat(1078) = .120_r8*rxt(335)*y(1)
         mat(1010) = .330_r8*rxt(341)*y(1)
         mat(222) = .350_r8*rxt(283)*y(22)
         mat(319) = rxt(278)*y(6) + rxt(279)*y(23)

         mat(318) = -(rxt(278)*y(6) + rxt(279)*y(23))
         mat(1726) = -rxt(278)*y(43)
         mat(1639) = -rxt(279)*y(43)

         mat(1286) = rxt(269)*y(23)
         mat(1639) = mat(1639) + rxt(269)*y(16)

         mat(99) = -(rxt(487)*y(22))
         mat(1405) = -rxt(487)*y(170)

         mat(1405) = mat(1405) + (rxt(488)+.500_r8*rxt(489))*y(171)
         mat(1816) = rxt(490)*y(171)
         mat(193) = (rxt(488)+.500_r8*rxt(489))*y(22) + rxt(490)*y(8)

         mat(194) = -((rxt(488) + rxt(489)) * y(22) + rxt(490)*y(8))
         mat(1419) = -(rxt(488) + rxt(489)) * y(171)
         mat(1817) = -rxt(490)*y(171)


         mat(1383) = rxt(487)*y(170)
         mat(98) = rxt(487)*y(22)


         mat(1384) = .1364005_r8*rxt(474)*y(106) + .0023005_r8*rxt(473)*y(110) &
                      + .1677005_r8*rxt(475)*y(133) + .2381005_r8*rxt(470)*y(140) &
                      + .5931005_r8*rxt(472)*y(148)
         mat(166) = .1364005_r8*rxt(474)*y(22)
         mat(115) = .0023005_r8*rxt(473)*y(22)
         mat(145) = .1677005_r8*rxt(475)*y(22)
         mat(7) = .2381005_r8*rxt(470)*y(22)
         mat(13) = .5931005_r8*rxt(472)*y(22)


         mat(1385) = .0101005_r8*rxt(474)*y(106) + .0008005_r8*rxt(473)*y(110) &
                      + .0174005_r8*rxt(475)*y(133) + .1308005_r8*rxt(470)*y(140) &
                      + .1534005_r8*rxt(472)*y(148)
         mat(167) = .0101005_r8*rxt(474)*y(22)
         mat(116) = .0008005_r8*rxt(473)*y(22)
         mat(146) = .0174005_r8*rxt(475)*y(22)
         mat(8) = .1308005_r8*rxt(470)*y(22)
         mat(14) = .1534005_r8*rxt(472)*y(22)


         mat(1386) = .0763005_r8*rxt(474)*y(106) + .0843005_r8*rxt(473)*y(110) &
                      + .086_r8*rxt(475)*y(133) + .0348005_r8*rxt(470)*y(140) &
                      + .0459005_r8*rxt(472)*y(148)
         mat(168) = .0763005_r8*rxt(474)*y(22)
         mat(117) = .0843005_r8*rxt(473)*y(22)
         mat(147) = .086_r8*rxt(475)*y(22)
         mat(9) = .0348005_r8*rxt(470)*y(22)
         mat(15) = .0459005_r8*rxt(472)*y(22)


         mat(1387) = .2157005_r8*rxt(474)*y(106) + .0443005_r8*rxt(473)*y(110) &
                      + .0512005_r8*rxt(475)*y(133) + .0076005_r8*rxt(470)*y(140) &
                      + .0085005_r8*rxt(472)*y(148)
         mat(169) = .2157005_r8*rxt(474)*y(22)
         mat(118) = .0443005_r8*rxt(473)*y(22)
         mat(148) = .0512005_r8*rxt(475)*y(22)
         mat(10) = .0076005_r8*rxt(470)*y(22)
         mat(16) = .0085005_r8*rxt(472)*y(22)


         mat(1388) = .0232005_r8*rxt(474)*y(106) + .1621005_r8*rxt(473)*y(110) &
                      + .1598005_r8*rxt(475)*y(133) + .0113005_r8*rxt(470)*y(140) &
                      + .0128005_r8*rxt(472)*y(148)
         mat(170) = .0232005_r8*rxt(474)*y(22)
         mat(119) = .1621005_r8*rxt(473)*y(22)
         mat(149) = .1598005_r8*rxt(475)*y(22)
         mat(11) = .0113005_r8*rxt(470)*y(22)
         mat(17) = .0128005_r8*rxt(472)*y(22)


         mat(1391) = .2381005_r8*rxt(469)*y(139) + .5931005_r8*rxt(471)*y(147)
         mat(24) = .2381005_r8*rxt(469)*y(22)
         mat(30) = .5931005_r8*rxt(471)*y(22)


         mat(1392) = .1308005_r8*rxt(469)*y(139) + .1534005_r8*rxt(471)*y(147)
         mat(25) = .1308005_r8*rxt(469)*y(22)
         mat(31) = .1534005_r8*rxt(471)*y(22)


         mat(1393) = .0348005_r8*rxt(469)*y(139) + .0459005_r8*rxt(471)*y(147)
         mat(26) = .0348005_r8*rxt(469)*y(22)
         mat(32) = .0459005_r8*rxt(471)*y(22)


         mat(1394) = .0076005_r8*rxt(469)*y(139) + .0085005_r8*rxt(471)*y(147)
         mat(27) = .0076005_r8*rxt(469)*y(22)
         mat(33) = .0085005_r8*rxt(471)*y(22)


         mat(1395) = .0113005_r8*rxt(469)*y(139) + .0128005_r8*rxt(471)*y(147)
         mat(28) = .0113005_r8*rxt(469)*y(22)
         mat(34) = .0128005_r8*rxt(471)*y(22)


         mat(1398) = .0031005_r8*rxt(466)*y(92) + .0508005_r8*rxt(467)*y(141) &
                      + .2202005_r8*rxt(468)*y(142)
         mat(708) = .0031005_r8*rxt(466)*y(22)
         mat(794) = .0508005_r8*rxt(467)*y(22)
         mat(765) = .2202005_r8*rxt(468)*y(22)


         mat(1399) = .0035005_r8*rxt(466)*y(92) + .1149005_r8*rxt(467)*y(141) &
                      + .2067005_r8*rxt(468)*y(142)
         mat(709) = .0035005_r8*rxt(466)*y(22)
         mat(795) = .1149005_r8*rxt(467)*y(22)
         mat(766) = .2067005_r8*rxt(468)*y(22)


         mat(1306) = .0348005_r8*rxt(477)*y(141) + .0653005_r8*rxt(478)*y(142)
         mat(1400) = .0003005_r8*rxt(466)*y(92) + .0348005_r8*rxt(467)*y(141) &
                      + .0653005_r8*rxt(468)*y(142)
         mat(710) = .0003005_r8*rxt(466)*y(22)
         mat(796) = .0348005_r8*rxt(477)*y(1) + .0348005_r8*rxt(467)*y(22)
         mat(767) = .0653005_r8*rxt(478)*y(1) + .0653005_r8*rxt(468)*y(22)


         mat(1307) = .0271005_r8*rxt(476)*y(92) + .0554005_r8*rxt(477)*y(141) &
                      + .1284005_r8*rxt(478)*y(142)
         mat(1401) = .0271005_r8*rxt(466)*y(92) + .0554005_r8*rxt(467)*y(141) &
                      + .1284005_r8*rxt(468)*y(142)
         mat(1814) = .0590245_r8*rxt(479)*y(92) + .1749305_r8*rxt(480)*y(141) &
                      + .1749305_r8*rxt(481)*y(142)
         mat(711) = .0271005_r8*rxt(476)*y(1) + .0271005_r8*rxt(466)*y(22) &
                      + .0590245_r8*rxt(479)*y(8)
         mat(797) = .0554005_r8*rxt(477)*y(1) + .0554005_r8*rxt(467)*y(22) &
                      + .1749305_r8*rxt(480)*y(8)
         mat(768) = .1284005_r8*rxt(478)*y(1) + .1284005_r8*rxt(468)*y(22) &
                      + .1749305_r8*rxt(481)*y(8)


         mat(1308) = .1278005_r8*rxt(477)*y(141) + .114_r8*rxt(478)*y(142)
         mat(1402) = .0474005_r8*rxt(466)*y(92) + .1278005_r8*rxt(467)*y(141) &
                      + .114_r8*rxt(468)*y(142)
         mat(1815) = .0250245_r8*rxt(479)*y(92) + .5901905_r8*rxt(480)*y(141) &
                      + .5901905_r8*rxt(481)*y(142)
         mat(712) = .0474005_r8*rxt(466)*y(22) + .0250245_r8*rxt(479)*y(8)
         mat(798) = .1278005_r8*rxt(477)*y(1) + .1278005_r8*rxt(467)*y(22) &
                      + .5901905_r8*rxt(480)*y(8)
         mat(769) = .114_r8*rxt(478)*y(1) + .114_r8*rxt(468)*y(22) &
                      + .5901905_r8*rxt(481)*y(8)
      end subroutine nlnmat08
      subroutine nlnmat_finit( mat, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(inout) :: mat(nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
         mat( 1) = lmat( 1)
         mat( 2) = lmat( 2)
         mat( 3) = lmat( 3)
         mat( 4) = lmat( 4)
         mat( 5) = lmat( 5)
         mat( 6) = lmat( 6)
         mat( 12) = mat( 12) + lmat( 12)
         mat( 18) = mat( 18) + lmat( 18)
         mat( 19) = lmat( 19)
         mat( 20) = lmat( 20)
         mat( 21) = lmat( 21)
         mat( 22) = lmat( 22)
         mat( 23) = lmat( 23)
         mat( 29) = mat( 29) + lmat( 29)
         mat( 35) = mat( 35) + lmat( 35)
         mat( 36) = lmat( 36)
         mat( 37) = lmat( 37)
         mat( 38) = lmat( 38)
         mat( 39) = lmat( 39)
         mat( 40) = lmat( 40)
         mat( 41) = lmat( 41)
         mat( 42) = lmat( 42)
         mat( 43) = lmat( 43)
         mat( 44) = lmat( 44)
         mat( 45) = lmat( 45)
         mat( 46) = lmat( 46)
         mat( 47) = lmat( 47)
         mat( 48) = lmat( 48)
         mat( 49) = lmat( 49)
         mat( 50) = lmat( 50)
         mat( 51) = lmat( 51)
         mat( 52) = lmat( 52)
         mat( 53) = lmat( 53)
         mat( 54) = lmat( 54)
         mat( 55) = lmat( 55)
         mat( 56) = lmat( 56)
         mat( 57) = lmat( 57)
         mat( 58) = lmat( 58)
         mat( 59) = lmat( 59)
         mat( 60) = lmat( 60)
         mat( 61) = lmat( 61)
         mat( 62) = lmat( 62)
         mat( 63) = lmat( 63)
         mat( 64) = lmat( 64)
         mat( 65) = lmat( 65)
         mat( 66) = lmat( 66)
         mat( 67) = lmat( 67)
         mat( 68) = lmat( 68)
         mat( 69) = lmat( 69)
         mat( 70) = lmat( 70)
         mat( 71) = lmat( 71)
         mat( 72) = lmat( 72)
         mat( 73) = lmat( 73)
         mat( 74) = lmat( 74)
         mat( 75) = lmat( 75)
         mat( 76) = lmat( 76)
         mat( 77) = lmat( 77)
         mat( 78) = lmat( 78)
         mat( 79) = lmat( 79)
         mat( 80) = lmat( 80)
         mat( 81) = lmat( 81)
         mat( 82) = lmat( 82)
         mat( 83) = lmat( 83)
         mat( 84) = lmat( 84)
         mat( 85) = lmat( 85)
         mat( 86) = lmat( 86)
         mat( 87) = lmat( 87)
         mat( 88) = mat( 88) + lmat( 88)
         mat( 91) = lmat( 91)
         mat( 92) = lmat( 92)
         mat( 93) = lmat( 93)
         mat( 94) = mat( 94) + lmat( 94)
         mat( 99) = mat( 99) + lmat( 99)
         mat( 101) = lmat( 101)
         mat( 102) = lmat( 102)
         mat( 103) = lmat( 103)
         mat( 104) = mat( 104) + lmat( 104)
         mat( 107) = lmat( 107)
         mat( 108) = lmat( 108)
         mat( 109) = lmat( 109)
         mat( 110) = lmat( 110)
         mat( 111) = lmat( 111)
         mat( 112) = lmat( 112)
         mat( 113) = lmat( 113)
         mat( 114) = lmat( 114)
         mat( 120) = mat( 120) + lmat( 120)
         mat( 126) = lmat( 126)
         mat( 127) = lmat( 127)
         mat( 128) = lmat( 128)
         mat( 129) = lmat( 129)
         mat( 130) = mat( 130) + lmat( 130)
         mat( 135) = lmat( 135)
         mat( 136) = lmat( 136)
         mat( 137) = mat( 137) + lmat( 137)
         mat( 139) = mat( 139) + lmat( 139)
         mat( 140) = mat( 140) + lmat( 140)
         mat( 141) = mat( 141) + lmat( 141)
         mat( 150) = mat( 150) + lmat( 150)
         mat( 157) = mat( 157) + lmat( 157)
         mat( 162) = lmat( 162)
         mat( 163) = lmat( 163)
         mat( 164) = lmat( 164)
         mat( 165) = lmat( 165)
         mat( 172) = mat( 172) + lmat( 172)
         mat( 180) = mat( 180) + lmat( 180)
         mat( 185) = mat( 185) + lmat( 185)
         mat( 188) = mat( 188) + lmat( 188)
         mat( 189) = lmat( 189)
         mat( 191) = mat( 191) + lmat( 191)
         mat( 192) = lmat( 192)
         mat( 194) = mat( 194) + lmat( 194)
         mat( 199) = lmat( 199)
         mat( 200) = lmat( 200)
         mat( 201) = lmat( 201)
         mat( 202) = mat( 202) + lmat( 202)
         mat( 205) = mat( 205) + lmat( 205)
         mat( 206) = lmat( 206)
         mat( 208) = mat( 208) + lmat( 208)
         mat( 209) = mat( 209) + lmat( 209)
         mat( 213) = lmat( 213)
         mat( 214) = lmat( 214)
         mat( 215) = lmat( 215)
         mat( 216) = lmat( 216)
         mat( 217) = mat( 217) + lmat( 217)
         mat( 220) = mat( 220) + lmat( 220)
         mat( 221) = mat( 221) + lmat( 221)
         mat( 227) = lmat( 227)
         mat( 228) = lmat( 228)
         mat( 229) = lmat( 229)
         mat( 230) = lmat( 230)
         mat( 231) = lmat( 231)
         mat( 232) = lmat( 232)
         mat( 233) = lmat( 233)
         mat( 234) = lmat( 234)
         mat( 235) = lmat( 235)
         mat( 236) = mat( 236) + lmat( 236)
         mat( 242) = lmat( 242)
         mat( 243) = lmat( 243)
         mat( 244) = lmat( 244)
         mat( 245) = lmat( 245)
         mat( 246) = lmat( 246)
         mat( 247) = mat( 247) + lmat( 247)
         mat( 252) = mat( 252) + lmat( 252)
         mat( 254) = mat( 254) + lmat( 254)
         mat( 255) = mat( 255) + lmat( 255)
         mat( 256) = lmat( 256)
         mat( 257) = mat( 257) + lmat( 257)
         mat( 260) = mat( 260) + lmat( 260)
         mat( 262) = lmat( 262)
         mat( 263) = mat( 263) + lmat( 263)
         mat( 264) = lmat( 264)
         mat( 265) = lmat( 265)
         mat( 266) = mat( 266) + lmat( 266)
         mat( 269) = mat( 269) + lmat( 269)
         mat( 270) = lmat( 270)
         mat( 271) = mat( 271) + lmat( 271)
         mat( 276) = mat( 276) + lmat( 276)
         mat( 277) = lmat( 277)
         mat( 279) = mat( 279) + lmat( 279)
         mat( 280) = lmat( 280)
         mat( 281) = mat( 281) + lmat( 281)
         mat( 283) = lmat( 283)
         mat( 284) = lmat( 284)
         mat( 285) = mat( 285) + lmat( 285)
         mat( 286) = mat( 286) + lmat( 286)
         mat( 294) = mat( 294) + lmat( 294)
         mat( 296) = lmat( 296)
         mat( 297) = lmat( 297)
         mat( 298) = mat( 298) + lmat( 298)
         mat( 299) = lmat( 299)
         mat( 300) = lmat( 300)
         mat( 301) = lmat( 301)
         mat( 302) = lmat( 302)
         mat( 303) = lmat( 303)
         mat( 304) = lmat( 304)
         mat( 305) = lmat( 305)
         mat( 306) = mat( 306) + lmat( 306)
         mat( 308) = lmat( 308)
         mat( 310) = mat( 310) + lmat( 310)
         mat( 311) = lmat( 311)
         mat( 312) = mat( 312) + lmat( 312)
         mat( 314) = lmat( 314)
         mat( 316) = lmat( 316)
         mat( 317) = mat( 317) + lmat( 317)
         mat( 318) = mat( 318) + lmat( 318)
         mat( 320) = lmat( 320)
         mat( 322) = mat( 322) + lmat( 322)
         mat( 324) = mat( 324) + lmat( 324)
         mat( 326) = mat( 326) + lmat( 326)
         mat( 327) = mat( 327) + lmat( 327)
         mat( 328) = lmat( 328)
         mat( 329) = lmat( 329)
         mat( 331) = mat( 331) + lmat( 331)
         mat( 337) = mat( 337) + lmat( 337)
         mat( 338) = lmat( 338)
         mat( 340) = lmat( 340)
         mat( 341) = mat( 341) + lmat( 341)
         mat( 342) = lmat( 342)
         mat( 345) = mat( 345) + lmat( 345)
         mat( 351) = mat( 351) + lmat( 351)
         mat( 352) = lmat( 352)
         mat( 355) = lmat( 355)
         mat( 356) = mat( 356) + lmat( 356)
         mat( 357) = mat( 357) + lmat( 357)
         mat( 359) = lmat( 359)
         mat( 361) = mat( 361) + lmat( 361)
         mat( 362) = mat( 362) + lmat( 362)
         mat( 363) = lmat( 363)
         mat( 364) = lmat( 364)
         mat( 365) = lmat( 365)
         mat( 368) = mat( 368) + lmat( 368)
         mat( 375) = mat( 375) + lmat( 375)
         mat( 379) = mat( 379) + lmat( 379)
         mat( 381) = lmat( 381)
         mat( 382) = lmat( 382)
         mat( 383) = lmat( 383)
         mat( 384) = mat( 384) + lmat( 384)
         mat( 385) = lmat( 385)
         mat( 386) = mat( 386) + lmat( 386)
         mat( 387) = lmat( 387)
         mat( 388) = lmat( 388)
         mat( 391) = lmat( 391)
         mat( 392) = mat( 392) + lmat( 392)
         mat( 394) = mat( 394) + lmat( 394)
         mat( 401) = mat( 401) + lmat( 401)
         mat( 409) = mat( 409) + lmat( 409)
         mat( 415) = mat( 415) + lmat( 415)
         mat( 418) = lmat( 418)
         mat( 420) = mat( 420) + lmat( 420)
         mat( 421) = mat( 421) + lmat( 421)
         mat( 422) = mat( 422) + lmat( 422)
         mat( 424) = mat( 424) + lmat( 424)
         mat( 425) = lmat( 425)
         mat( 426) = mat( 426) + lmat( 426)
         mat( 428) = lmat( 428)
         mat( 429) = lmat( 429)
         mat( 431) = mat( 431) + lmat( 431)
         mat( 432) = lmat( 432)
         mat( 433) = lmat( 433)
         mat( 434) = mat( 434) + lmat( 434)
         mat( 435) = lmat( 435)
         mat( 436) = lmat( 436)
         mat( 437) = mat( 437) + lmat( 437)
         mat( 439) = mat( 439) + lmat( 439)
         mat( 443) = mat( 443) + lmat( 443)
         mat( 446) = lmat( 446)
         mat( 448) = lmat( 448)
         mat( 449) = mat( 449) + lmat( 449)
         mat( 450) = lmat( 450)
         mat( 451) = mat( 451) + lmat( 451)
         mat( 459) = mat( 459) + lmat( 459)
         mat( 461) = lmat( 461)
         mat( 464) = lmat( 464)
         mat( 467) = mat( 467) + lmat( 467)
         mat( 475) = mat( 475) + lmat( 475)
         mat( 483) = mat( 483) + lmat( 483)
         mat( 485) = mat( 485) + lmat( 485)
         mat( 490) = lmat( 490)
         mat( 491) = lmat( 491)
         mat( 492) = mat( 492) + lmat( 492)
         mat( 493) = lmat( 493)
         mat( 497) = lmat( 497)
         mat( 498) = lmat( 498)
         mat( 499) = mat( 499) + lmat( 499)
         mat( 500) = lmat( 500)
         mat( 501) = mat( 501) + lmat( 501)
         mat( 502) = lmat( 502)
         mat( 503) = lmat( 503)
         mat( 504) = lmat( 504)
         mat( 506) = lmat( 506)
         mat( 507) = lmat( 507)
         mat( 508) = mat( 508) + lmat( 508)
         mat( 509) = lmat( 509)
         mat( 510) = lmat( 510)
         mat( 511) = lmat( 511)
         mat( 512) = lmat( 512)
         mat( 513) = lmat( 513)
         mat( 516) = mat( 516) + lmat( 516)
         mat( 522) = lmat( 522)
         mat( 523) = mat( 523) + lmat( 523)
         mat( 526) = mat( 526) + lmat( 526)
         mat( 527) = mat( 527) + lmat( 527)
         mat( 529) = mat( 529) + lmat( 529)
         mat( 531) = mat( 531) + lmat( 531)
         mat( 532) = lmat( 532)
         mat( 533) = lmat( 533)
         mat( 534) = mat( 534) + lmat( 534)
         mat( 538) = mat( 538) + lmat( 538)
         mat( 539) = lmat( 539)
         mat( 541) = lmat( 541)
         mat( 542) = mat( 542) + lmat( 542)
         mat( 543) = mat( 543) + lmat( 543)
         mat( 545) = mat( 545) + lmat( 545)
         mat( 552) = lmat( 552)
         mat( 553) = lmat( 553)
         mat( 554) = lmat( 554)
         mat( 555) = lmat( 555)
         mat( 556) = mat( 556) + lmat( 556)
         mat( 560) = lmat( 560)
         mat( 563) = lmat( 563)
         mat( 565) = mat( 565) + lmat( 565)
         mat( 566) = lmat( 566)
         mat( 567) = mat( 567) + lmat( 567)
         mat( 578) = mat( 578) + lmat( 578)
         mat( 590) = mat( 590) + lmat( 590)
         mat( 598) = mat( 598) + lmat( 598)
         mat( 599) = lmat( 599)
         mat( 601) = lmat( 601)
         mat( 602) = lmat( 602)
         mat( 604) = lmat( 604)
         mat( 611) = mat( 611) + lmat( 611)
         mat( 622) = mat( 622) + lmat( 622)
         mat( 631) = mat( 631) + lmat( 631)
         mat( 641) = mat( 641) + lmat( 641)
         mat( 644) = mat( 644) + lmat( 644)
         mat( 647) = lmat( 647)
         mat( 649) = mat( 649) + lmat( 649)
         mat( 651) = lmat( 651)
         mat( 653) = mat( 653) + lmat( 653)
         mat( 657) = mat( 657) + lmat( 657)
         mat( 667) = mat( 667) + lmat( 667)
         mat( 671) = mat( 671) + lmat( 671)
         mat( 675) = mat( 675) + lmat( 675)
         mat( 677) = mat( 677) + lmat( 677)
         mat( 678) = lmat( 678)
         mat( 681) = mat( 681) + lmat( 681)
         mat( 684) = mat( 684) + lmat( 684)
         mat( 686) = mat( 686) + lmat( 686)
         mat( 691) = mat( 691) + lmat( 691)
         mat( 699) = lmat( 699)
         mat( 700) = mat( 700) + lmat( 700)
         mat( 706) = lmat( 706)
         mat( 707) = mat( 707) + lmat( 707)
         mat( 714) = mat( 714) + lmat( 714)
         mat( 730) = mat( 730) + lmat( 730)
         mat( 732) = lmat( 732)
         mat( 733) = lmat( 733)
         mat( 735) = mat( 735) + lmat( 735)
         mat( 739) = mat( 739) + lmat( 739)
         mat( 749) = mat( 749) + lmat( 749)
         mat( 750) = mat( 750) + lmat( 750)
         mat( 751) = mat( 751) + lmat( 751)
         mat( 753) = mat( 753) + lmat( 753)
         mat( 755) = lmat( 755)
         mat( 757) = mat( 757) + lmat( 757)
         mat( 758) = mat( 758) + lmat( 758)
         mat( 760) = lmat( 760)
         mat( 761) = mat( 761) + lmat( 761)
         mat( 762) = mat( 762) + lmat( 762)
         mat( 764) = mat( 764) + lmat( 764)
         mat( 775) = mat( 775) + lmat( 775)
         mat( 804) = mat( 804) + lmat( 804)
         mat( 828) = mat( 828) + lmat( 828)
         mat( 838) = mat( 838) + lmat( 838)
         mat( 840) = lmat( 840)
         mat( 842) = lmat( 842)
         mat( 844) = mat( 844) + lmat( 844)
         mat( 846) = lmat( 846)
         mat( 848) = lmat( 848)
         mat( 850) = lmat( 850)
         mat( 856) = mat( 856) + lmat( 856)
         mat( 871) = mat( 871) + lmat( 871)
         mat( 880) = mat( 880) + lmat( 880)
         mat( 881) = lmat( 881)
         mat( 882) = mat( 882) + lmat( 882)
         mat( 884) = mat( 884) + lmat( 884)
         mat( 889) = mat( 889) + lmat( 889)
         mat( 900) = mat( 900) + lmat( 900)
         mat( 901) = mat( 901) + lmat( 901)
         mat( 902) = mat( 902) + lmat( 902)
         mat( 903) = mat( 903) + lmat( 903)
         mat( 904) = mat( 904) + lmat( 904)
         mat( 907) = mat( 907) + lmat( 907)
         mat( 909) = mat( 909) + lmat( 909)
         mat( 916) = mat( 916) + lmat( 916)
         mat( 928) = mat( 928) + lmat( 928)
         mat( 936) = mat( 936) + lmat( 936)
         mat( 941) = lmat( 941)
         mat( 942) = lmat( 942)
         mat( 943) = lmat( 943)
         mat( 944) = mat( 944) + lmat( 944)
         mat( 945) = lmat( 945)
         mat( 947) = lmat( 947)
         mat( 948) = lmat( 948)
         mat( 952) = lmat( 952)
         mat( 954) = lmat( 954)
         mat( 955) = mat( 955) + lmat( 955)
         mat( 956) = mat( 956) + lmat( 956)
         mat( 958) = lmat( 958)
         mat( 959) = lmat( 959)
         mat( 961) = mat( 961) + lmat( 961)
         mat( 965) = mat( 965) + lmat( 965)
         mat( 976) = lmat( 976)
         mat( 977) = mat( 977) + lmat( 977)
         mat( 981) = lmat( 981)
         mat( 984) = lmat( 984)
         mat( 996) = mat( 996) + lmat( 996)
         mat(1011) = mat(1011) + lmat(1011)
         mat(1012) = mat(1012) + lmat(1012)
         mat(1015) = mat(1015) + lmat(1015)
         mat(1016) = mat(1016) + lmat(1016)
         mat(1019) = mat(1019) + lmat(1019)
         mat(1022) = mat(1022) + lmat(1022)
         mat(1024) = mat(1024) + lmat(1024)
         mat(1025) = mat(1025) + lmat(1025)
         mat(1026) = mat(1026) + lmat(1026)
         mat(1031) = lmat(1031)
         mat(1040) = mat(1040) + lmat(1040)
         mat(1063) = mat(1063) + lmat(1063)
         mat(1079) = lmat(1079)
         mat(1080) = mat(1080) + lmat(1080)
         mat(1084) = mat(1084) + lmat(1084)
         mat(1086) = mat(1086) + lmat(1086)
         mat(1089) = lmat(1089)
         mat(1106) = mat(1106) + lmat(1106)
         mat(1118) = lmat(1118)
         mat(1138) = mat(1138) + lmat(1138)
         mat(1148) = mat(1148) + lmat(1148)
         mat(1156) = mat(1156) + lmat(1156)
         mat(1188) = mat(1188) + lmat(1188)
         mat(1199) = lmat(1199)
         mat(1200) = mat(1200) + lmat(1200)
         mat(1201) = lmat(1201)
         mat(1202) = mat(1202) + lmat(1202)
         mat(1205) = lmat(1205)
         mat(1206) = mat(1206) + lmat(1206)
         mat(1209) = mat(1209) + lmat(1209)
         mat(1214) = mat(1214) + lmat(1214)
         mat(1253) = mat(1253) + lmat(1253)
         mat(1273) = mat(1273) + lmat(1273)
         mat(1282) = mat(1282) + lmat(1282)
         mat(1284) = mat(1284) + lmat(1284)
         mat(1290) = lmat(1290)
         mat(1291) = mat(1291) + lmat(1291)
         mat(1293) = mat(1293) + lmat(1293)
         mat(1294) = mat(1294) + lmat(1294)
         mat(1348) = mat(1348) + lmat(1348)
         mat(1358) = mat(1358) + lmat(1358)
         mat(1359) = mat(1359) + lmat(1359)
         mat(1372) = mat(1372) + lmat(1372)
         mat(1376) = mat(1376) + lmat(1376)
         mat(1381) = mat(1381) + lmat(1381)
         mat(1517) = mat(1517) + lmat(1517)
         mat(1519) = mat(1519) + lmat(1519)
         mat(1524) = mat(1524) + lmat(1524)
         mat(1527) = mat(1527) + lmat(1527)
         mat(1528) = mat(1528) + lmat(1528)
         mat(1530) = mat(1530) + lmat(1530)
         mat(1547) = mat(1547) + lmat(1547)
         mat(1563) = mat(1563) + lmat(1563)
         mat(1564) = mat(1564) + lmat(1564)
         mat(1568) = mat(1568) + lmat(1568)
         mat(1571) = mat(1571) + lmat(1571)
         mat(1580) = lmat(1580)
         mat(1586) = mat(1586) + lmat(1586)
         mat(1587) = mat(1587) + lmat(1587)
         mat(1607) = mat(1607) + lmat(1607)
         mat(1612) = lmat(1612)
         mat(1618) = mat(1618) + lmat(1618)
         mat(1619) = mat(1619) + lmat(1619)
         mat(1620) = mat(1620) + lmat(1620)
         mat(1622) = lmat(1622)
         mat(1655) = mat(1655) + lmat(1655)
         mat(1713) = mat(1713) + lmat(1713)
         mat(1720) = mat(1720) + lmat(1720)
         mat(1791) = mat(1791) + lmat(1791)
         mat(1794) = mat(1794) + lmat(1794)
         mat(1810) = mat(1810) + lmat(1810)
         mat(1822) = mat(1822) + lmat(1822)
         mat(1860) = mat(1860) + lmat(1860)
         mat(1864) = mat(1864) + lmat(1864)
         mat(1866) = mat(1866) + lmat(1866)
         mat(1867) = mat(1867) + lmat(1867)
         mat(1882) = mat(1882) + lmat(1882)
         mat(1892) = mat(1892) + lmat(1892)
         mat(1896) = mat(1896) + lmat(1896)
         mat(1898) = mat(1898) + lmat(1898)
         mat(1899) = lmat(1899)
         mat(1900) = lmat(1900)
         mat(1903) = mat(1903) + lmat(1903)
         mat(1906) = mat(1906) + lmat(1906)
         mat(1907) = lmat(1907)
         mat(1908) = lmat(1908)
         mat(1909) = mat(1909) + lmat(1909)
         mat(1911) = lmat(1911)
         mat(1912) = mat(1912) + lmat(1912)
         mat( 176) = 0._r8
         mat( 177) = 0._r8
         mat( 268) = 0._r8
         mat( 333) = 0._r8
         mat( 346) = 0._r8
         mat( 347) = 0._r8
         mat( 369) = 0._r8
         mat( 371) = 0._r8
         mat( 397) = 0._r8
         mat( 494) = 0._r8
         mat( 496) = 0._r8
         mat( 517) = 0._r8
         mat( 518) = 0._r8
         mat( 524) = 0._r8
         mat( 525) = 0._r8
         mat( 528) = 0._r8
         mat( 535) = 0._r8
         mat( 536) = 0._r8
         mat( 540) = 0._r8
         mat( 557) = 0._r8
         mat( 559) = 0._r8
         mat( 561) = 0._r8
         mat( 562) = 0._r8
         mat( 564) = 0._r8
         mat( 577) = 0._r8
         mat( 579) = 0._r8
         mat( 581) = 0._r8
         mat( 582) = 0._r8
         mat( 584) = 0._r8
         mat( 591) = 0._r8
         mat( 593) = 0._r8
         mat( 610) = 0._r8
         mat( 612) = 0._r8
         mat( 614) = 0._r8
         mat( 615) = 0._r8
         mat( 617) = 0._r8
         mat( 618) = 0._r8
         mat( 632) = 0._r8
         mat( 634) = 0._r8
         mat( 636) = 0._r8
         mat( 646) = 0._r8
         mat( 660) = 0._r8
         mat( 663) = 0._r8
         mat( 695) = 0._r8
         mat( 703) = 0._r8
         mat( 704) = 0._r8
         mat( 723) = 0._r8
         mat( 744) = 0._r8
         mat( 752) = 0._r8
         mat( 774) = 0._r8
         mat( 776) = 0._r8
         mat( 783) = 0._r8
         mat( 785) = 0._r8
         mat( 786) = 0._r8
         mat( 790) = 0._r8
         mat( 792) = 0._r8
         mat( 803) = 0._r8
         mat( 805) = 0._r8
         mat( 812) = 0._r8
         mat( 814) = 0._r8
         mat( 815) = 0._r8
         mat( 819) = 0._r8
         mat( 821) = 0._r8
         mat( 826) = 0._r8
         mat( 827) = 0._r8
         mat( 831) = 0._r8
         mat( 832) = 0._r8
         mat( 834) = 0._r8
         mat( 858) = 0._r8
         mat( 860) = 0._r8
         mat( 861) = 0._r8
         mat( 862) = 0._r8
         mat( 867) = 0._r8
         mat( 869) = 0._r8
         mat( 890) = 0._r8
         mat( 891) = 0._r8
         mat( 892) = 0._r8
         mat( 895) = 0._r8
         mat( 905) = 0._r8
         mat( 906) = 0._r8
         mat( 918) = 0._r8
         mat( 919) = 0._r8
         mat( 920) = 0._r8
         mat( 923) = 0._r8
         mat( 946) = 0._r8
         mat( 949) = 0._r8
         mat( 950) = 0._r8
         mat( 951) = 0._r8
         mat( 968) = 0._r8
         mat( 980) = 0._r8
         mat( 983) = 0._r8
         mat( 988) = 0._r8
         mat( 991) = 0._r8
         mat( 992) = 0._r8
         mat( 993) = 0._r8
         mat( 994) = 0._r8
         mat( 995) = 0._r8
         mat( 997) = 0._r8
         mat( 998) = 0._r8
         mat( 999) = 0._r8
         mat(1000) = 0._r8
         mat(1002) = 0._r8
         mat(1005) = 0._r8
         mat(1018) = 0._r8
         mat(1028) = 0._r8
         mat(1030) = 0._r8
         mat(1042) = 0._r8
         mat(1043) = 0._r8
         mat(1046) = 0._r8
         mat(1054) = 0._r8
         mat(1055) = 0._r8
         mat(1056) = 0._r8
         mat(1057) = 0._r8
         mat(1058) = 0._r8
         mat(1059) = 0._r8
         mat(1061) = 0._r8
         mat(1062) = 0._r8
         mat(1065) = 0._r8
         mat(1066) = 0._r8
         mat(1068) = 0._r8
         mat(1069) = 0._r8
         mat(1072) = 0._r8
         mat(1073) = 0._r8
         mat(1081) = 0._r8
         mat(1087) = 0._r8
         mat(1088) = 0._r8
         mat(1093) = 0._r8
         mat(1095) = 0._r8
         mat(1096) = 0._r8
         mat(1103) = 0._r8
         mat(1104) = 0._r8
         mat(1107) = 0._r8
         mat(1109) = 0._r8
         mat(1110) = 0._r8
         mat(1113) = 0._r8
         mat(1121) = 0._r8
         mat(1124) = 0._r8
         mat(1127) = 0._r8
         mat(1128) = 0._r8
         mat(1129) = 0._r8
         mat(1131) = 0._r8
         mat(1132) = 0._r8
         mat(1133) = 0._r8
         mat(1135) = 0._r8
         mat(1136) = 0._r8
         mat(1137) = 0._r8
         mat(1139) = 0._r8
         mat(1141) = 0._r8
         mat(1142) = 0._r8
         mat(1145) = 0._r8
         mat(1146) = 0._r8
         mat(1154) = 0._r8
         mat(1155) = 0._r8
         mat(1158) = 0._r8
         mat(1159) = 0._r8
         mat(1173) = 0._r8
         mat(1176) = 0._r8
         mat(1189) = 0._r8
         mat(1190) = 0._r8
         mat(1198) = 0._r8
         mat(1203) = 0._r8
         mat(1204) = 0._r8
         mat(1212) = 0._r8
         mat(1213) = 0._r8
         mat(1216) = 0._r8
         mat(1227) = 0._r8
         mat(1236) = 0._r8
         mat(1251) = 0._r8
         mat(1252) = 0._r8
         mat(1255) = 0._r8
         mat(1257) = 0._r8
         mat(1259) = 0._r8
         mat(1263) = 0._r8
         mat(1264) = 0._r8
         mat(1265) = 0._r8
         mat(1270) = 0._r8
         mat(1271) = 0._r8
         mat(1272) = 0._r8
         mat(1274) = 0._r8
         mat(1278) = 0._r8
         mat(1283) = 0._r8
         mat(1285) = 0._r8
         mat(1288) = 0._r8
         mat(1295) = 0._r8
         mat(1297) = 0._r8
         mat(1301) = 0._r8
         mat(1305) = 0._r8
         mat(1315) = 0._r8
         mat(1318) = 0._r8
         mat(1321) = 0._r8
         mat(1325) = 0._r8
         mat(1326) = 0._r8
         mat(1328) = 0._r8
         mat(1330) = 0._r8
         mat(1333) = 0._r8
         mat(1336) = 0._r8
         mat(1337) = 0._r8
         mat(1339) = 0._r8
         mat(1340) = 0._r8
         mat(1341) = 0._r8
         mat(1343) = 0._r8
         mat(1352) = 0._r8
         mat(1366) = 0._r8
         mat(1367) = 0._r8
         mat(1371) = 0._r8
         mat(1380) = 0._r8
         mat(1382) = 0._r8
         mat(1444) = 0._r8
         mat(1464) = 0._r8
         mat(1470) = 0._r8
         mat(1475) = 0._r8
         mat(1501) = 0._r8
         mat(1507) = 0._r8
         mat(1529) = 0._r8
         mat(1533) = 0._r8
         mat(1543) = 0._r8
         mat(1546) = 0._r8
         mat(1549) = 0._r8
         mat(1551) = 0._r8
         mat(1552) = 0._r8
         mat(1553) = 0._r8
         mat(1556) = 0._r8
         mat(1557) = 0._r8
         mat(1558) = 0._r8
         mat(1560) = 0._r8
         mat(1565) = 0._r8
         mat(1566) = 0._r8
         mat(1569) = 0._r8
         mat(1572) = 0._r8
         mat(1581) = 0._r8
         mat(1582) = 0._r8
         mat(1583) = 0._r8
         mat(1585) = 0._r8
         mat(1588) = 0._r8
         mat(1589) = 0._r8
         mat(1590) = 0._r8
         mat(1591) = 0._r8
         mat(1599) = 0._r8
         mat(1600) = 0._r8
         mat(1604) = 0._r8
         mat(1606) = 0._r8
         mat(1608) = 0._r8
         mat(1609) = 0._r8
         mat(1610) = 0._r8
         mat(1617) = 0._r8
         mat(1621) = 0._r8
         mat(1624) = 0._r8
         mat(1625) = 0._r8
         mat(1628) = 0._r8
         mat(1646) = 0._r8
         mat(1648) = 0._r8
         mat(1658) = 0._r8
         mat(1676) = 0._r8
         mat(1680) = 0._r8
         mat(1681) = 0._r8
         mat(1683) = 0._r8
         mat(1685) = 0._r8
         mat(1689) = 0._r8
         mat(1693) = 0._r8
         mat(1697) = 0._r8
         mat(1718) = 0._r8
         mat(1753) = 0._r8
         mat(1779) = 0._r8
         mat(1780) = 0._r8
         mat(1788) = 0._r8
         mat(1795) = 0._r8
         mat(1798) = 0._r8
         mat(1799) = 0._r8
         mat(1803) = 0._r8
         mat(1804) = 0._r8
         mat(1805) = 0._r8
         mat(1806) = 0._r8
         mat(1807) = 0._r8
         mat(1809) = 0._r8
         mat(1811) = 0._r8
         mat(1812) = 0._r8
         mat(1813) = 0._r8
         mat(1821) = 0._r8
         mat(1829) = 0._r8
         mat(1835) = 0._r8
         mat(1837) = 0._r8
         mat(1839) = 0._r8
         mat(1841) = 0._r8
         mat(1853) = 0._r8
         mat(1854) = 0._r8
         mat(1855) = 0._r8
         mat(1857) = 0._r8
         mat(1858) = 0._r8
         mat(1861) = 0._r8
         mat(1862) = 0._r8
         mat(1865) = 0._r8
         mat(1868) = 0._r8
         mat(1873) = 0._r8
         mat(1878) = 0._r8
         mat(1893) = 0._r8
         mat(1902) = 0._r8
         mat(1904) = 0._r8
         mat(1910) = 0._r8
         mat( 1) = mat( 1) - dti
         mat( 2) = mat( 2) - dti
         mat( 3) = mat( 3) - dti
         mat( 4) = mat( 4) - dti
         mat( 5) = mat( 5) - dti
         mat( 6) = mat( 6) - dti
         mat( 12) = mat( 12) - dti
         mat( 18) = mat( 18) - dti
         mat( 19) = mat( 19) - dti
         mat( 20) = mat( 20) - dti
         mat( 21) = mat( 21) - dti
         mat( 22) = mat( 22) - dti
         mat( 23) = mat( 23) - dti
         mat( 29) = mat( 29) - dti
         mat( 35) = mat( 35) - dti
         mat( 36) = mat( 36) - dti
         mat( 37) = mat( 37) - dti
         mat( 38) = mat( 38) - dti
         mat( 39) = mat( 39) - dti
         mat( 40) = mat( 40) - dti
         mat( 41) = mat( 41) - dti
         mat( 42) = mat( 42) - dti
         mat( 43) = mat( 43) - dti
         mat( 44) = mat( 44) - dti
         mat( 45) = mat( 45) - dti
         mat( 46) = mat( 46) - dti
         mat( 47) = mat( 47) - dti
         mat( 48) = mat( 48) - dti
         mat( 49) = mat( 49) - dti
         mat( 50) = mat( 50) - dti
         mat( 51) = mat( 51) - dti
         mat( 52) = mat( 52) - dti
         mat( 53) = mat( 53) - dti
         mat( 54) = mat( 54) - dti
         mat( 55) = mat( 55) - dti
         mat( 56) = mat( 56) - dti
         mat( 57) = mat( 57) - dti
         mat( 58) = mat( 58) - dti
         mat( 59) = mat( 59) - dti
         mat( 60) = mat( 60) - dti
         mat( 61) = mat( 61) - dti
         mat( 62) = mat( 62) - dti
         mat( 63) = mat( 63) - dti
         mat( 64) = mat( 64) - dti
         mat( 65) = mat( 65) - dti
         mat( 66) = mat( 66) - dti
         mat( 67) = mat( 67) - dti
         mat( 68) = mat( 68) - dti
         mat( 69) = mat( 69) - dti
         mat( 70) = mat( 70) - dti
         mat( 71) = mat( 71) - dti
         mat( 72) = mat( 72) - dti
         mat( 73) = mat( 73) - dti
         mat( 74) = mat( 74) - dti
         mat( 75) = mat( 75) - dti
         mat( 76) = mat( 76) - dti
         mat( 77) = mat( 77) - dti
         mat( 78) = mat( 78) - dti
         mat( 79) = mat( 79) - dti
         mat( 80) = mat( 80) - dti
         mat( 81) = mat( 81) - dti
         mat( 82) = mat( 82) - dti
         mat( 83) = mat( 83) - dti
         mat( 84) = mat( 84) - dti
         mat( 85) = mat( 85) - dti
         mat( 86) = mat( 86) - dti
         mat( 87) = mat( 87) - dti
         mat( 88) = mat( 88) - dti
         mat( 91) = mat( 91) - dti
         mat( 94) = mat( 94) - dti
         mat( 99) = mat( 99) - dti
         mat( 101) = mat( 101) - dti
         mat( 104) = mat( 104) - dti
         mat( 107) = mat( 107) - dti
         mat( 110) = mat( 110) - dti
         mat( 112) = mat( 112) - dti
         mat( 120) = mat( 120) - dti
         mat( 126) = mat( 126) - dti
         mat( 130) = mat( 130) - dti
         mat( 135) = mat( 135) - dti
         mat( 137) = mat( 137) - dti
         mat( 141) = mat( 141) - dti
         mat( 150) = mat( 150) - dti
         mat( 157) = mat( 157) - dti
         mat( 162) = mat( 162) - dti
         mat( 172) = mat( 172) - dti
         mat( 180) = mat( 180) - dti
         mat( 185) = mat( 185) - dti
         mat( 188) = mat( 188) - dti
         mat( 194) = mat( 194) - dti
         mat( 199) = mat( 199) - dti
         mat( 202) = mat( 202) - dti
         mat( 205) = mat( 205) - dti
         mat( 209) = mat( 209) - dti
         mat( 213) = mat( 213) - dti
         mat( 217) = mat( 217) - dti
         mat( 221) = mat( 221) - dti
         mat( 227) = mat( 227) - dti
         mat( 233) = mat( 233) - dti
         mat( 236) = mat( 236) - dti
         mat( 242) = mat( 242) - dti
         mat( 247) = mat( 247) - dti
         mat( 252) = mat( 252) - dti
         mat( 257) = mat( 257) - dti
         mat( 260) = mat( 260) - dti
         mat( 266) = mat( 266) - dti
         mat( 271) = mat( 271) - dti
         mat( 276) = mat( 276) - dti
         mat( 281) = mat( 281) - dti
         mat( 286) = mat( 286) - dti
         mat( 294) = mat( 294) - dti
         mat( 300) = mat( 300) - dti
         mat( 306) = mat( 306) - dti
         mat( 312) = mat( 312) - dti
         mat( 318) = mat( 318) - dti
         mat( 324) = mat( 324) - dti
         mat( 331) = mat( 331) - dti
         mat( 337) = mat( 337) - dti
         mat( 345) = mat( 345) - dti
         mat( 351) = mat( 351) - dti
         mat( 357) = mat( 357) - dti
         mat( 363) = mat( 363) - dti
         mat( 368) = mat( 368) - dti
         mat( 375) = mat( 375) - dti
         mat( 379) = mat( 379) - dti
         mat( 386) = mat( 386) - dti
         mat( 394) = mat( 394) - dti
         mat( 401) = mat( 401) - dti
         mat( 409) = mat( 409) - dti
         mat( 415) = mat( 415) - dti
         mat( 421) = mat( 421) - dti
         mat( 426) = mat( 426) - dti
         mat( 431) = mat( 431) - dti
         mat( 439) = mat( 439) - dti
         mat( 443) = mat( 443) - dti
         mat( 451) = mat( 451) - dti
         mat( 459) = mat( 459) - dti
         mat( 467) = mat( 467) - dti
         mat( 475) = mat( 475) - dti
         mat( 483) = mat( 483) - dti
         mat( 492) = mat( 492) - dti
         mat( 501) = mat( 501) - dti
         mat( 510) = mat( 510) - dti
         mat( 516) = mat( 516) - dti
         mat( 523) = mat( 523) - dti
         mat( 534) = mat( 534) - dti
         mat( 545) = mat( 545) - dti
         mat( 556) = mat( 556) - dti
         mat( 567) = mat( 567) - dti
         mat( 578) = mat( 578) - dti
         mat( 590) = mat( 590) - dti
         mat( 598) = mat( 598) - dti
         mat( 611) = mat( 611) - dti
         mat( 622) = mat( 622) - dti
         mat( 631) = mat( 631) - dti
         mat( 641) = mat( 641) - dti
         mat( 649) = mat( 649) - dti
         mat( 657) = mat( 657) - dti
         mat( 667) = mat( 667) - dti
         mat( 671) = mat( 671) - dti
         mat( 675) = mat( 675) - dti
         mat( 681) = mat( 681) - dti
         mat( 691) = mat( 691) - dti
         mat( 700) = mat( 700) - dti
         mat( 714) = mat( 714) - dti
         mat( 730) = mat( 730) - dti
         mat( 739) = mat( 739) - dti
         mat( 751) = mat( 751) - dti
         mat( 761) = mat( 761) - dti
         mat( 775) = mat( 775) - dti
         mat( 804) = mat( 804) - dti
         mat( 828) = mat( 828) - dti
         mat( 838) = mat( 838) - dti
         mat( 844) = mat( 844) - dti
         mat( 856) = mat( 856) - dti
         mat( 871) = mat( 871) - dti
         mat( 880) = mat( 880) - dti
         mat( 889) = mat( 889) - dti
         mat( 901) = mat( 901) - dti
         mat( 916) = mat( 916) - dti
         mat( 928) = mat( 928) - dti
         mat( 936) = mat( 936) - dti
         mat( 944) = mat( 944) - dti
         mat( 956) = mat( 956) - dti
         mat( 965) = mat( 965) - dti
         mat( 977) = mat( 977) - dti
         mat( 996) = mat( 996) - dti
         mat(1012) = mat(1012) - dti
         mat(1025) = mat(1025) - dti
         mat(1040) = mat(1040) - dti
         mat(1063) = mat(1063) - dti
         mat(1084) = mat(1084) - dti
         mat(1106) = mat(1106) - dti
         mat(1138) = mat(1138) - dti
         mat(1156) = mat(1156) - dti
         mat(1188) = mat(1188) - dti
         mat(1200) = mat(1200) - dti
         mat(1209) = mat(1209) - dti
         mat(1253) = mat(1253) - dti
         mat(1273) = mat(1273) - dti
         mat(1294) = mat(1294) - dti
         mat(1348) = mat(1348) - dti
         mat(1372) = mat(1372) - dti
         mat(1524) = mat(1524) - dti
         mat(1564) = mat(1564) - dti
         mat(1586) = mat(1586) - dti
         mat(1619) = mat(1619) - dti
         mat(1713) = mat(1713) - dti
         mat(1791) = mat(1791) - dti
         mat(1810) = mat(1810) - dti
         mat(1866) = mat(1866) - dti
         mat(1892) = mat(1892) - dti
         mat(1912) = mat(1912) - dti
      end subroutine nlnmat_finit
      subroutine nlnmat( mat, y, rxt, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)
      call nlnmat01( mat, y, rxt )
      call nlnmat02( mat, y, rxt )
      call nlnmat03( mat, y, rxt )
      call nlnmat04( mat, y, rxt )
      call nlnmat05( mat, y, rxt )
      call nlnmat06( mat, y, rxt )
      call nlnmat07( mat, y, rxt )
      call nlnmat08( mat, y, rxt )
      call nlnmat_finit( mat, lmat, dti )
      end subroutine nlnmat
      end module mo_nln_matrix
