



      module mo_prod_loss

      use shr_kind_mod, only : r8 => shr_kind_r8

      private
      public :: exp_prod_loss
      public :: imp_prod_loss

      contains

      subroutine exp_prod_loss( prod, loss, y, rxt, het_rates )

      use ppgrid, only : pver

      implicit none

!--------------------------------------------------------------------
! ... dummy args
!--------------------------------------------------------------------
      real(r8), dimension(:,:,:), intent(out) :: &
            prod, &
            loss
      real(r8), intent(in) :: y(:,:,:)
      real(r8), intent(in) :: rxt(:,:,:)
      real(r8), intent(in) :: het_rates(:,:,:)



!--------------------------------------------------------------------
! ... loss and production for Explicit method
!--------------------------------------------------------------------


         loss(:,:,1) = ( + het_rates(:,:,235))* y(:,:,235)
         prod(:,:,1) = 0._r8
         loss(:,:,2) = ((rxt(:,:,160) +rxt(:,:,161) +rxt(:,:,162))* y(:,:,3) &
                  +rxt(:,:,263)* y(:,:,22) +rxt(:,:,214)* y(:,:,27) + rxt(:,:,54) &
                  + rxt(:,:,55) + het_rates(:,:,12))* y(:,:,12)
         prod(:,:,2) = 0._r8
         loss(:,:,3) = ((rxt(:,:,141) +rxt(:,:,142))* y(:,:,3) + rxt(:,:,4) &
                  + het_rates(:,:,4))* y(:,:,4)
         prod(:,:,3) = 0._r8
         loss(:,:,4) = (rxt(:,:,252)* y(:,:,22) +rxt(:,:,251)* y(:,:,27) + rxt(:,:,35) &
                  + het_rates(:,:,152))* y(:,:,152)
         prod(:,:,4) = 0._r8
         loss(:,:,5) = (rxt(:,:,153)* y(:,:,3) +rxt(:,:,255)* y(:,:,22) +rxt(:,:,256) &
                 * y(:,:,27) + rxt(:,:,46) + het_rates(:,:,153))* y(:,:,153)
         prod(:,:,5) = 0._r8
         loss(:,:,6) = (rxt(:,:,144)* y(:,:,3) + rxt(:,:,38) + het_rates(:,:,154)) &
                 * y(:,:,154)
         prod(:,:,6) = 0._r8
         loss(:,:,7) = (rxt(:,:,145)* y(:,:,3) + rxt(:,:,39) + het_rates(:,:,155)) &
                 * y(:,:,155)
         prod(:,:,7) = 0._r8
         loss(:,:,8) = (rxt(:,:,146)* y(:,:,3) + rxt(:,:,40) + het_rates(:,:,156)) &
                 * y(:,:,156)
         prod(:,:,8) = 0._r8
         loss(:,:,9) = (rxt(:,:,147)* y(:,:,3) + rxt(:,:,42) + het_rates(:,:,164)) &
                 * y(:,:,164)
         prod(:,:,9) = 0._r8
         loss(:,:,10) = (rxt(:,:,148)* y(:,:,3) + rxt(:,:,43) + het_rates(:,:,165)) &
                 * y(:,:,165)
         prod(:,:,10) = 0._r8
         loss(:,:,11) = (rxt(:,:,149)* y(:,:,3) +rxt(:,:,254)* y(:,:,22) + rxt(:,:,41) &
                  + het_rates(:,:,157))* y(:,:,157)
         prod(:,:,11) = 0._r8
         loss(:,:,12) = (rxt(:,:,150)* y(:,:,3) +rxt(:,:,257)* y(:,:,22) + rxt(:,:,44) &
                  + het_rates(:,:,162))* y(:,:,162)
         prod(:,:,12) = 0._r8
         loss(:,:,13) = (rxt(:,:,151)* y(:,:,3) +rxt(:,:,258)* y(:,:,22) + rxt(:,:,45) &
                  + het_rates(:,:,163))* y(:,:,163)
         prod(:,:,13) = 0._r8
         loss(:,:,14) = (rxt(:,:,152)* y(:,:,3) + rxt(:,:,36) + het_rates(:,:,158)) &
                 * y(:,:,158)
         prod(:,:,14) = 0._r8
         loss(:,:,15) = (rxt(:,:,253)* y(:,:,22) + rxt(:,:,37) + het_rates(:,:,159)) &
                 * y(:,:,159)
         prod(:,:,15) = 0._r8
         loss(:,:,16) = (rxt(:,:,155)* y(:,:,3) + rxt(:,:,47) + het_rates(:,:,160)) &
                 * y(:,:,160)
         prod(:,:,16) = 0._r8
         loss(:,:,17) = (rxt(:,:,154)* y(:,:,3) + rxt(:,:,50) + het_rates(:,:,161)) &
                 * y(:,:,161)
         prod(:,:,17) = 0._r8
         loss(:,:,18) = (rxt(:,:,156)* y(:,:,3) + rxt(:,:,48) + het_rates(:,:,166)) &
                 * y(:,:,166)
         prod(:,:,18) = 0._r8
         loss(:,:,19) = (rxt(:,:,157)* y(:,:,3) + rxt(:,:,49) + het_rates(:,:,167)) &
                 * y(:,:,167)
         prod(:,:,19) = 0._r8
         loss(:,:,20) = (rxt(:,:,158)* y(:,:,3) +rxt(:,:,260)* y(:,:,22) +rxt(:,:,262) &
                 * y(:,:,27) + rxt(:,:,51) + het_rates(:,:,168))* y(:,:,168)
         prod(:,:,20) = 0._r8
         loss(:,:,21) = (rxt(:,:,159)* y(:,:,3) +rxt(:,:,259)* y(:,:,22) +rxt(:,:,261) &
                 * y(:,:,27) + rxt(:,:,52) + het_rates(:,:,169))* y(:,:,169)
         prod(:,:,21) = 0._r8
         loss(:,:,22) = ( + rxt(:,:,53) + het_rates(:,:,236))* y(:,:,236)
         prod(:,:,22) =.440_r8*rxt(:,:,55)*y(:,:,12)
         loss(:,:,23) = ( + het_rates(:,:,25))* y(:,:,25)
         prod(:,:,23) = 0._r8
         loss(:,:,24) = ( + het_rates(:,:,26))* y(:,:,26)
         prod(:,:,24) = 0._r8

      end subroutine exp_prod_loss

      subroutine imp_prod_loss( prod, loss, y, rxt, het_rates )

      use ppgrid, only : pver

      implicit none

!--------------------------------------------------------------------
! ... dummy args
!--------------------------------------------------------------------
      real(r8), dimension(:), intent(out) :: &
            prod, &
            loss
      real(r8), intent(in) :: y(:)
      real(r8), intent(in) :: rxt(:)
      real(r8), intent(in) :: het_rates(:)



!--------------------------------------------------------------------
! ... loss and production for Implicit method
!--------------------------------------------------------------------


         loss(202) = (rxt(136)* y(2) +rxt(143)* y(3) +rxt(193)* y(6) +rxt(196)* y(7) &
                  +rxt(168)* y(21) +rxt(173)* y(22) +rxt(181)* y(23) +rxt(208)* y(27) &
                  +rxt(235)* y(36) +rxt(290)* y(44) +rxt(311)* y(59) +rxt(335)* y(77) &
                  +rxt(341)* y(78) +rxt(360)* y(92) +rxt(406)* y(115) +rxt(445) &
                 * y(141) +rxt(446)* y(142) + rxt(2) + rxt(3) + het_rates(1))* y(1)
         prod(202) = (.150_r8*rxt(301)*y(48) +.150_r8*rxt(351)*y(76))*y(23) +rxt(135) &
                 *y(2)
         loss(212) = (rxt(136)* y(1) + 2._r8*rxt(137)* y(2) +rxt(191)* y(6) &
                  + (rxt(194) +rxt(195))* y(7) +rxt(202)* y(8) +rxt(268)* y(16) &
                  +rxt(179)* y(20) +rxt(172)* y(22) +rxt(180)* y(23) +rxt(183)* y(24) &
                  +rxt(215)* y(29) +rxt(228)* y(32) +rxt(229)* y(33) +rxt(232)* y(34) &
                  +rxt(238)* y(37) +rxt(248)* y(38) +rxt(249)* y(39) +rxt(250)* y(40) &
                  + rxt(135) + het_rates(2))* y(2)
         prod(212) = (rxt(186) +rxt(187)*y(6) +rxt(188)*y(7))*y(5) + (rxt(138) + &
                 rxt(139))*y(3) +rxt(3)*y(1) +rxt(5)*y(6) +rxt(6)*y(7) +rxt(10)*y(8) &
                  +rxt(8)*y(11) +rxt(171)*y(23)*y(21) +rxt(175)*y(22)*y(22) +rxt(22) &
                 *y(29) +rxt(23)*y(30) +rxt(30)*y(37) +rxt(19)*y(237)
         loss(213) = (rxt(143)* y(1) + (rxt(141) +rxt(142))* y(4) + (rxt(160) + &
                 rxt(161) +rxt(162))* y(12) +rxt(166)* y(18) +rxt(163)* y(20) &
                  +rxt(164)* y(32) +rxt(165)* y(38) +rxt(153)* y(153) +rxt(144) &
                 * y(154) +rxt(145)* y(155) +rxt(146)* y(156) +rxt(149)* y(157) &
                  +rxt(152)* y(158) +rxt(155)* y(160) +rxt(154)* y(161) +rxt(150) &
                 * y(162) +rxt(151)* y(163) +rxt(147)* y(164) +rxt(148)* y(165) &
                  +rxt(156)* y(166) +rxt(157)* y(167) +rxt(158)* y(168) +rxt(159) &
                 * y(169) +rxt(140)* y(237) + rxt(138) + rxt(139) + het_rates(3)) &
                 * y(3)
         prod(213) =rxt(2)*y(1) +rxt(18)*y(237)
         loss(176) = (rxt(179)* y(2) +rxt(163)* y(3) +rxt(177)* y(22) +rxt(209)* y(27) &
                  + het_rates(20))* y(20)
         prod(176) =rxt(162)*y(12)*y(3) +rxt(16)*y(16) +rxt(170)*y(23)*y(21) +rxt(18) &
                 *y(237)
         loss(182) = ((rxt(264) +rxt(265))* y(22) + het_rates(17))* y(17)
         prod(182) = (.630_r8*rxt(290)*y(44) +.560_r8*rxt(311)*y(59) + &
                 .560_r8*rxt(335)*y(77) +.650_r8*rxt(341)*y(78) + &
                 .620_r8*rxt(360)*y(92) +.230_r8*rxt(445)*y(141) + &
                 .230_r8*rxt(446)*y(142))*y(1) + (rxt(15) +rxt(16) +rxt(213)*y(27) + &
                 rxt(237)*y(36) +rxt(266)*y(8) +rxt(267)*y(22) +rxt(268)*y(2))*y(16) &
                  + (.220_r8*rxt(342)*y(79) +.250_r8*rxt(387)*y(103) + &
                 .400_r8*rxt(414)*y(124) +.170_r8*rxt(430)*y(130) + &
                 .350_r8*rxt(432)*y(131) +.225_r8*rxt(456)*y(146))*y(6) &
                  + (.350_r8*rxt(283)*y(41) +rxt(306)*y(53) +rxt(327)*y(68) + &
                 .700_r8*rxt(459)*y(149))*y(22) + (rxt(328)*y(68) + &
                 .220_r8*rxt(344)*y(79) +.500_r8*rxt(388)*y(103))*y(8) &
                  + (.110_r8*rxt(346)*y(79) +.200_r8*rxt(390)*y(103) + &
                 .125_r8*rxt(458)*y(146))*y(13) + (.160_r8*rxt(415)*y(124) + &
                 .070_r8*rxt(429)*y(130) +.140_r8*rxt(431)*y(131))*y(23) &
                  + (.220_r8*rxt(347)*y(79) +.250_r8*rxt(391)*y(103))*y(48) &
                  +rxt(251)*y(152)*y(27) +rxt(56)*y(50) +rxt(81)*y(52) &
                  +2.000_r8*rxt(84)*y(53) +rxt(69)*y(68) +.700_r8*rxt(63)*y(77) &
                  +1.340_r8*rxt(62)*y(78) +.330_r8*rxt(78)*y(84) +.450_r8*rxt(83) &
                 *y(95) +1.500_r8*rxt(93)*y(112) +.600_r8*rxt(96)*y(122) +rxt(97) &
                 *y(123) +1.500_r8*rxt(94)*y(125) +rxt(90)*y(145) +1.700_r8*rxt(91) &
                 *y(149) +.250_r8*rxt(89)*y(150)
         loss(81) = (rxt(187)* y(6) + (rxt(188) +rxt(189) +rxt(190))* y(7) + rxt(186) &
                  + het_rates(5))* y(5)
         prod(81) =rxt(5)*y(6)
         loss(209) = (rxt(193)* y(1) +rxt(191)* y(2) +rxt(187)* y(5) +rxt(201)* y(8) &
                  +rxt(270)* y(13) +rxt(192)* y(23) +rxt(220)* y(29) +rxt(241)* y(37) &
                  +rxt(278)* y(43) +rxt(292)* y(46) +rxt(299)* y(48) +rxt(286)* y(55) &
                  +rxt(313)* y(61) +rxt(318)* y(64) +rxt(322)* y(67) + (rxt(331) + &
                 rxt(332))* y(73) +rxt(337)* y(74) +rxt(349)* y(76) + (rxt(342) + &
                 rxt(343))* y(79) + (rxt(395) +rxt(396))* y(93) +rxt(362)* y(97) &
                  +rxt(363)* y(98) +rxt(378)* y(101) +rxt(387)* y(103) +rxt(428) &
                 * y(108) +rxt(410)* y(113) +rxt(402)* y(114) +rxt(407)* y(117) &
                  +rxt(414)* y(124) +rxt(420)* y(126) +rxt(424)* y(129) +rxt(430) &
                 * y(130) +rxt(432)* y(131) +rxt(437)* y(135) +rxt(442)* y(137) &
                  +rxt(449)* y(143) +rxt(456)* y(146) +rxt(460)* y(151) + rxt(5) &
                  + het_rates(6))* y(6)
         prod(209) = (rxt(6) +.500_r8*rxt(484) +2.000_r8*rxt(189)*y(5) +rxt(194)*y(2)) &
                 *y(7) +2.000_r8*rxt(141)*y(4)*y(3) +rxt(186)*y(5) +rxt(11)*y(8) &
                  +rxt(8)*y(11)
         loss(205) = (rxt(196)* y(1) + (rxt(194) +rxt(195))* y(2) + (rxt(188) + &
                 rxt(189) +rxt(190))* y(5) +rxt(197)* y(8) +rxt(199)* y(22) +rxt(205) &
                 * y(23) +rxt(221)* y(29) +rxt(242)* y(37) +rxt(300)* y(48) +rxt(355) &
                 * y(76) +rxt(405)* y(115) +rxt(413)* y(124) +rxt(422)* y(129) &
                  +rxt(433)* y(130) +rxt(434)* y(131) + rxt(6) + rxt(484) &
                  + het_rates(7))* y(7)
         prod(205) = (rxt(191)*y(2) +rxt(192)*y(23) +rxt(193)*y(1) + &
                 2.000_r8*rxt(201)*y(8) +rxt(220)*y(29) +rxt(241)*y(37) + &
                 rxt(270)*y(13) +rxt(278)*y(43) +rxt(286)*y(55) +rxt(292)*y(46) + &
                 rxt(299)*y(48) +rxt(313)*y(61) +rxt(318)*y(64) +rxt(322)*y(67) + &
                 rxt(331)*y(73) +rxt(337)*y(74) +rxt(342)*y(79) +rxt(349)*y(76) + &
                 .920_r8*rxt(362)*y(97) +.920_r8*rxt(363)*y(98) +rxt(378)*y(101) + &
                 rxt(387)*y(103) +rxt(395)*y(93) +rxt(402)*y(114) +rxt(407)*y(117) + &
                 rxt(410)*y(113) +rxt(414)*y(124) +rxt(420)*y(126) +rxt(424)*y(129) + &
                 rxt(428)*y(108) +rxt(430)*y(130) +rxt(432)*y(131) +rxt(437)*y(135) + &
                 rxt(442)*y(137) +.800_r8*rxt(449)*y(143) +.900_r8*rxt(456)*y(146) + &
                 1.600_r8*rxt(460)*y(151))*y(6) + (rxt(10) +rxt(202)*y(2) + &
                 rxt(203)*y(22) +rxt(204)*y(23) +rxt(333)*y(70) +rxt(344)*y(79) + &
                 rxt(350)*y(76) +rxt(366)*y(97) +rxt(367)*y(98) +rxt(379)*y(101) + &
                 rxt(388)*y(103) +2.000_r8*rxt(463)*y(151))*y(8) + (rxt(206)*y(10) + &
                 rxt(329)*y(83) +.700_r8*rxt(364)*y(85) +rxt(397)*y(82) + &
                 rxt(464)*y(90))*y(22) + (rxt(13) +rxt(207))*y(10) + (rxt(7) + &
                 rxt(198))*y(11) + (.600_r8*rxt(59) +rxt(308))*y(58) + (rxt(60) + &
                 rxt(356))*y(81) +rxt(9)*y(9) +.500_r8*rxt(462)*y(151)*y(13) +rxt(28) &
                 *y(34) +rxt(34)*y(40) +rxt(72)*y(82) +rxt(77)*y(83) +rxt(78)*y(84) &
                  +rxt(73)*y(87) +rxt(74)*y(88) +rxt(75)*y(90) +rxt(76)*y(91) +rxt(71) &
                 *y(102) +rxt(423)*y(132)
         loss(204) = (rxt(173)* y(1) +rxt(172)* y(2) +rxt(199)* y(7) +rxt(203)* y(8) &
                  +rxt(200)* y(9) +rxt(206)* y(10) +rxt(263)* y(12) +rxt(275)* y(14) &
                  +rxt(274)* y(15) +rxt(267)* y(16) + (rxt(264) +rxt(265))* y(17) &
                  +rxt(184)* y(18) +rxt(185)* y(19) +rxt(177)* y(20) &
                  + 2._r8*(rxt(175) +rxt(176))* y(22) +rxt(174)* y(23) +rxt(178) &
                 * y(24) + (rxt(216) +rxt(217))* y(29) +rxt(227)* y(32) +rxt(231) &
                 * y(33) +rxt(233)* y(34) +rxt(239)* y(37) +rxt(247)* y(38) +rxt(283) &
                 * y(41) +rxt(276)* y(42) +rxt(285)* y(44) +rxt(284)* y(45) +rxt(296) &
                 * y(47) +rxt(291)* y(49) +rxt(297)* y(50) +rxt(307)* y(51) +rxt(305) &
                 * y(52) +rxt(306)* y(53) +rxt(304)* y(54) +rxt(309)* y(58) +rxt(310) &
                 * y(59) +rxt(317)* y(60) +rxt(316)* y(62) +rxt(321)* y(63) +rxt(320) &
                 * y(65) +rxt(326)* y(66) +rxt(327)* y(68) +rxt(325)* y(69) +rxt(330) &
                 * y(70) +rxt(394)* y(71) +rxt(336)* y(72) +rxt(339)* y(75) +rxt(334) &
                 * y(77) +rxt(340)* y(78) +rxt(348)* y(80) +rxt(357)* y(81) +rxt(397) &
                 * y(82) +rxt(329)* y(83) +rxt(358)* y(84) +rxt(364)* y(85) +rxt(365) &
                 * y(86) +rxt(383)* y(87) +rxt(385)* y(88) +rxt(384)* y(89) +rxt(464) &
                 * y(90) +rxt(465)* y(91) +rxt(359)* y(92) +rxt(399)* y(94) +rxt(386) &
                 * y(96) +rxt(377)* y(99) +rxt(371)* y(100) +rxt(392)* y(104) &
                  +rxt(370)* y(105) +rxt(416)* y(106) +rxt(417)* y(107) +rxt(427) &
                 * y(109) +rxt(400)* y(110) +rxt(401)* y(111) +rxt(404)* y(116) &
                  +rxt(409)* y(118) +rxt(412)* y(119) +rxt(419)* y(127) +rxt(421) &
                 * y(128) +rxt(435)* y(133) +rxt(436)* y(134) +rxt(439)* y(136) &
                  +rxt(441)* y(138) +rxt(443)* y(141) +rxt(444)* y(142) +rxt(452) &
                 * y(144) +rxt(454)* y(145) +rxt(459)* y(149) +rxt(453)* y(150) &
                  +rxt(252)* y(152) +rxt(255)* y(153) +rxt(254)* y(157) +rxt(253) &
                 * y(159) +rxt(257)* y(162) +rxt(258)* y(163) +rxt(260)* y(168) &
                  +rxt(259)* y(169) +rxt(487)* y(170) + (rxt(488) +rxt(489))* y(171) &
                  + het_rates(22))* y(22)
         prod(204) = (2.000_r8*rxt(169)*y(21) +rxt(180)*y(2) +rxt(181)*y(1) + &
                 rxt(192)*y(6) +rxt(204)*y(8) +rxt(212)*y(27) + &
                 .450_r8*rxt(301)*y(48) +.150_r8*rxt(323)*y(67) + &
                 .200_r8*rxt(338)*y(74) +.450_r8*rxt(351)*y(76) + &
                 .400_r8*rxt(425)*y(129) +.400_r8*rxt(429)*y(130) + &
                 .400_r8*rxt(431)*y(131))*y(23) + (rxt(168)*y(21) + &
                 .130_r8*rxt(290)*y(44) +.360_r8*rxt(311)*y(59) + &
                 .360_r8*rxt(335)*y(77) +.240_r8*rxt(341)*y(78) + &
                 .320_r8*rxt(360)*y(92) +.630_r8*rxt(445)*y(141) + &
                 .630_r8*rxt(446)*y(142))*y(1) + (rxt(179)*y(20) +rxt(183)*y(24) + &
                 rxt(228)*y(32) +rxt(229)*y(33) +rxt(248)*y(38) +rxt(249)*y(39) + &
                 rxt(268)*y(16))*y(2) + (rxt(160)*y(12) +2.000_r8*rxt(140)*y(237) + &
                 rxt(163)*y(20) +rxt(164)*y(32) +rxt(165)*y(38) +rxt(166)*y(18))*y(3) &
                  + (.300_r8*rxt(275)*y(14) +.650_r8*rxt(283)*y(41) + &
                 .500_r8*rxt(296)*y(47) +.500_r8*rxt(320)*y(65) + &
                 .100_r8*rxt(348)*y(80) +.600_r8*rxt(370)*y(105))*y(22) &
                  +.500_r8*rxt(484)*y(7) +rxt(9)*y(9) +rxt(12)*y(10) +rxt(14)*y(14) &
                  +2.000_r8*rxt(20)*y(24) +rxt(25)*y(33) +rxt(31)*y(39) +rxt(64)*y(47) &
                  +rxt(58)*y(54) +rxt(65)*y(57) +rxt(66)*y(62) +rxt(57)*y(65) +rxt(67) &
                 *y(69) +rxt(86)*y(75) +rxt(76)*y(91) +rxt(85)*y(94) +rxt(98)*y(99) &
                  +rxt(70)*y(104) +rxt(87)*y(109) +rxt(99)*y(116) +rxt(100)*y(118) &
                  +rxt(101)*y(119) +rxt(102)*y(127) +rxt(103)*y(136) +rxt(104)*y(138) &
                  +rxt(88)*y(144) +rxt(89)*y(150) +rxt(17)*y(237)
         loss(211) = (rxt(202)* y(2) +rxt(201)* y(6) +rxt(197)* y(7) +rxt(266)* y(16) &
                  +rxt(203)* y(22) +rxt(204)* y(23) +rxt(298)* y(50) +rxt(312)* y(59) &
                  +rxt(328)* y(68) +rxt(333)* y(70) +rxt(350)* y(76) +rxt(344)* y(79) &
                  +rxt(361)* y(92) +rxt(366)* y(97) +rxt(367)* y(98) +rxt(379)* y(101) &
                  +rxt(388)* y(103) +rxt(447)* y(141) +rxt(448)* y(142) +rxt(455) &
                 * y(145) +rxt(463)* y(151) +rxt(490)* y(171) + rxt(10) + rxt(11) &
                  + rxt(483) + het_rates(8))* y(8)
         prod(211) = (rxt(200)*y(9) +rxt(233)*y(34) +rxt(309)*y(58) + &
                 .500_r8*rxt(357)*y(81))*y(22) + (rxt(195)*y(7) +rxt(232)*y(34) + &
                 rxt(250)*y(40))*y(2) + (rxt(7) +rxt(8) +rxt(198))*y(11) + (rxt(27) + &
                 rxt(234)*y(27))*y(34) +rxt(196)*y(7)*y(1) +rxt(12)*y(10) +rxt(33) &
                 *y(40) +.400_r8*rxt(59)*y(58)
         loss(161) = (rxt(200)* y(22) + rxt(9) + het_rates(9))* y(9)
         prod(161) = (rxt(492) +rxt(498) +rxt(503) +rxt(494)*y(32) +rxt(499)*y(32) + &
                 rxt(505)*y(32))*y(34) + (rxt(483) +rxt(266)*y(16) +rxt(298)*y(50) + &
                 rxt(328)*y(68) +rxt(490)*y(171))*y(8) + (2.000_r8*rxt(482) + &
                 2.000_r8*rxt(491) +2.000_r8*rxt(497) +2.000_r8*rxt(502))*y(11) &
                  + (rxt(493) +rxt(501) +rxt(504))*y(40) + (.500_r8*rxt(484) + &
                 rxt(199)*y(22))*y(7)
         loss(116) = (rxt(206)* y(22) + rxt(12) + rxt(13) + rxt(207) + het_rates(10)) &
                 * y(10)
         prod(116) =rxt(205)*y(23)*y(7)
         loss(98) = ( + rxt(7) + rxt(8) + rxt(198) + rxt(482) + rxt(491) + rxt(497) &
                  + rxt(502) + het_rates(11))* y(11)
         prod(98) =rxt(197)*y(8)*y(7)
         loss(199) = (rxt(270)* y(6) + 2._r8*(rxt(272) +rxt(273))* y(13) +rxt(271) &
                 * y(23) +rxt(219)* y(29) +rxt(294)* y(46) +rxt(302)* y(48) +rxt(315) &
                 * y(61) +rxt(324)* y(67) +rxt(352)* y(76) +rxt(346)* y(79) +rxt(372) &
                 * y(97) +rxt(373)* y(98) +rxt(382)* y(101) +rxt(390)* y(103) &
                  +rxt(451)* y(143) +rxt(458)* y(146) +rxt(462)* y(151) &
                  + het_rates(13))* y(13)
         prod(199) = (rxt(299)*y(6) +.450_r8*rxt(301)*y(23) +.900_r8*rxt(302)*y(13) + &
                 2.000_r8*rxt(303)*y(48) +rxt(347)*y(79) +rxt(353)*y(76) + &
                 rxt(374)*y(97) +rxt(375)*y(98) +rxt(381)*y(101) +rxt(391)*y(103)) &
                 *y(48) + (rxt(160)*y(3) +rxt(214)*y(27) +rxt(263)*y(22))*y(12) &
                  + (.280_r8*rxt(311)*y(59) +.050_r8*rxt(360)*y(92))*y(1) &
                  + (.830_r8*rxt(430)*y(130) +.170_r8*rxt(432)*y(131))*y(6) &
                  + (.700_r8*rxt(275)*y(14) +rxt(291)*y(49))*y(22) &
                  + (.330_r8*rxt(429)*y(130) +.070_r8*rxt(431)*y(131))*y(23) +rxt(56) &
                 *y(50) +rxt(58)*y(54) +.400_r8*rxt(59)*y(58) +rxt(68)*y(63) &
                  +.300_r8*rxt(63)*y(77)
         loss(121) = (rxt(275)* y(22) + rxt(14) + het_rates(14))* y(14)
         prod(121) =rxt(271)*y(23)*y(13)
         loss(82) = (rxt(166)* y(3) +rxt(184)* y(22) + het_rates(18))* y(18)
         prod(82) = 0._r8
         loss(68) = (rxt(185)* y(22) + het_rates(19))* y(19)
         prod(68) = 0._r8
         loss(201) = (rxt(268)* y(2) +rxt(266)* y(8) +rxt(267)* y(22) +rxt(269)* y(23) &
                  +rxt(213)* y(27) +rxt(237)* y(36) + rxt(15) + rxt(16) &
                  + het_rates(16))* y(16)
         prod(201) = (rxt(219)*y(29) +rxt(270)*y(6) +2.000_r8*rxt(272)*y(13) + &
                 rxt(273)*y(13) +.700_r8*rxt(294)*y(46) +rxt(302)*y(48) + &
                 rxt(315)*y(61) +.800_r8*rxt(324)*y(67) +.880_r8*rxt(346)*y(79) + &
                 2.000_r8*rxt(352)*y(76) +1.500_r8*rxt(372)*y(97) + &
                 .750_r8*rxt(373)*y(98) +.800_r8*rxt(382)*y(101) + &
                 .800_r8*rxt(390)*y(103) +.950_r8*rxt(451)*y(143) + &
                 .930_r8*rxt(458)*y(146) +.750_r8*rxt(462)*y(151))*y(13) &
                  + (.500_r8*rxt(286)*y(55) +rxt(318)*y(64) +rxt(322)*y(67) + &
                 .500_r8*rxt(331)*y(73) +.250_r8*rxt(342)*y(79) +rxt(349)*y(76) + &
                 .920_r8*rxt(362)*y(97) +.250_r8*rxt(387)*y(103) + &
                 .100_r8*rxt(395)*y(93) +.320_r8*rxt(449)*y(143) + &
                 .340_r8*rxt(456)*y(146))*y(6) + (rxt(274)*y(15) + &
                 .300_r8*rxt(275)*y(14) +.500_r8*rxt(304)*y(54) + &
                 .800_r8*rxt(305)*y(52) +rxt(309)*y(58) +.500_r8*rxt(357)*y(81) + &
                 .300_r8*rxt(364)*y(85) +.400_r8*rxt(397)*y(82) + &
                 .680_r8*rxt(459)*y(149))*y(22) + (rxt(290)*y(44) + &
                 .500_r8*rxt(311)*y(59) +.600_r8*rxt(335)*y(77) + &
                 .120_r8*rxt(341)*y(78) +.910_r8*rxt(360)*y(92) + &
                 .340_r8*rxt(445)*y(141) +.340_r8*rxt(446)*y(142))*y(1) &
                  + (.500_r8*rxt(333)*y(70) +.250_r8*rxt(344)*y(79) +rxt(350)*y(76) + &
                 rxt(366)*y(97))*y(8) + (.250_r8*rxt(347)*y(79) +rxt(353)*y(76) + &
                 rxt(374)*y(97) +.250_r8*rxt(391)*y(103))*y(48) + (rxt(161)*y(12) + &
                 rxt(162)*y(12))*y(3) + (.150_r8*rxt(323)*y(67) + &
                 .450_r8*rxt(351)*y(76))*y(23) +rxt(14)*y(14) +rxt(277)*y(43) +rxt(81) &
                 *y(52) +2.000_r8*rxt(289)*y(56) +rxt(57)*y(65) +rxt(80)*y(66) &
                  +rxt(67)*y(69) +2.000_r8*rxt(354)*y(76)*y(76) +1.340_r8*rxt(61) &
                 *y(78) +.100_r8*rxt(72)*y(82) +rxt(77)*y(83) +.330_r8*rxt(78)*y(84) &
                  +.100_r8*rxt(85)*y(94) +.690_r8*rxt(79)*y(105) +.400_r8*rxt(88) &
                 *y(144) +.680_r8*rxt(91)*y(149) +.375_r8*rxt(89)*y(150)
         loss(198) = (rxt(168)* y(1) + (rxt(169) +rxt(170) +rxt(171))* y(23) &
                  + rxt(167) + het_rates(21))* y(21)
         prod(198) = (rxt(163)*y(3) +rxt(177)*y(22) +rxt(179)*y(2) +rxt(209)*y(27)) &
                 *y(20) + (rxt(172)*y(2) +rxt(264)*y(17) +rxt(267)*y(16))*y(22) &
                  + (rxt(17) +2.000_r8*rxt(19))*y(237) +rxt(161)*y(12)*y(3) +rxt(14) &
                 *y(14) +2.000_r8*rxt(15)*y(16) +rxt(26)*y(32) +rxt(32)*y(38)
         loss(208) = (rxt(181)* y(1) +rxt(180)* y(2) +rxt(192)* y(6) +rxt(205)* y(7) &
                  +rxt(204)* y(8) +rxt(271)* y(13) +rxt(269)* y(16) + (rxt(169) + &
                 rxt(170) +rxt(171))* y(21) +rxt(174)* y(22) + 2._r8*rxt(182)* y(23) &
                  + (rxt(211) +rxt(212))* y(27) +rxt(218)* y(29) +rxt(236)* y(36) &
                  +rxt(240)* y(37) +rxt(279)* y(43) +rxt(293)* y(46) +rxt(301)* y(48) &
                  +rxt(287)* y(55) +rxt(314)* y(61) +rxt(319)* y(64) +rxt(323)* y(67) &
                  +rxt(338)* y(74) +rxt(351)* y(76) +rxt(345)* y(79) +rxt(398)* y(93) &
                  +rxt(368)* y(97) +rxt(369)* y(98) +rxt(380)* y(101) +rxt(389) &
                 * y(103) +rxt(426)* y(108) +rxt(411)* y(113) +rxt(403)* y(114) &
                  +rxt(408)* y(117) +rxt(415)* y(124) +rxt(418)* y(126) +rxt(425) &
                 * y(129) +rxt(429)* y(130) +rxt(431)* y(131) +rxt(438)* y(135) &
                  +rxt(440)* y(137) +rxt(450)* y(143) +rxt(457)* y(146) +rxt(461) &
                 * y(151) + rxt(485) + het_rates(23))* y(23)
         prod(208) = (rxt(252)*y(152) +rxt(255)*y(153) +rxt(173)*y(1) + &
                 rxt(178)*y(24) +rxt(184)*y(18) +rxt(185)*y(19) +rxt(203)*y(8) + &
                 rxt(216)*y(29) +rxt(239)*y(37) +rxt(265)*y(17) +rxt(274)*y(15) + &
                 rxt(276)*y(42) +.350_r8*rxt(283)*y(41) +rxt(305)*y(52) + &
                 rxt(306)*y(53) +rxt(307)*y(51) +rxt(326)*y(66) + &
                 .200_r8*rxt(348)*y(80) +.500_r8*rxt(357)*y(81) +rxt(358)*y(84) + &
                 .300_r8*rxt(364)*y(85) +rxt(365)*y(86) +rxt(383)*y(87) + &
                 rxt(384)*y(89) +rxt(385)*y(88) +.750_r8*rxt(399)*y(94) + &
                 .650_r8*rxt(400)*y(110) +.800_r8*rxt(401)*y(111) + &
                 .280_r8*rxt(416)*y(106) +.730_r8*rxt(417)*y(107) + &
                 .380_r8*rxt(435)*y(133) +.630_r8*rxt(436)*y(134) + &
                 .200_r8*rxt(459)*y(149) +.500_r8*rxt(489)*y(171))*y(22) &
                  + (rxt(270)*y(13) +rxt(278)*y(43) +.250_r8*rxt(286)*y(55) + &
                 rxt(292)*y(46) +rxt(313)*y(61) +rxt(318)*y(64) +rxt(331)*y(73) + &
                 .470_r8*rxt(342)*y(79) +.920_r8*rxt(362)*y(97) + &
                 .920_r8*rxt(363)*y(98) +rxt(378)*y(101) +rxt(387)*y(103) + &
                 rxt(395)*y(93) +rxt(402)*y(114) +rxt(410)*y(113) + &
                 .400_r8*rxt(414)*y(124) +rxt(420)*y(126) +rxt(428)*y(108) + &
                 .170_r8*rxt(430)*y(130) +.830_r8*rxt(432)*y(131) +rxt(437)*y(135) + &
                 rxt(442)*y(137) +.800_r8*rxt(449)*y(143) +.900_r8*rxt(456)*y(146)) &
                 *y(6) + (rxt(219)*y(29) +2.000_r8*rxt(272)*y(13) +rxt(294)*y(46) + &
                 .900_r8*rxt(302)*y(48) +rxt(315)*y(61) +.300_r8*rxt(324)*y(67) + &
                 .730_r8*rxt(346)*y(79) +rxt(352)*y(76) +rxt(372)*y(97) + &
                 rxt(373)*y(98) +1.200_r8*rxt(382)*y(101) +.800_r8*rxt(390)*y(103) + &
                 rxt(451)*y(143) +rxt(458)*y(146) +.500_r8*rxt(462)*y(151))*y(13) &
                  + (.130_r8*rxt(290)*y(44) +.280_r8*rxt(311)*y(59) + &
                 .280_r8*rxt(335)*y(77) +.140_r8*rxt(341)*y(78) + &
                 .370_r8*rxt(360)*y(92) +.570_r8*rxt(445)*y(141) + &
                 .570_r8*rxt(446)*y(142))*y(1) + (rxt(266)*y(16) + &
                 .470_r8*rxt(344)*y(79) +rxt(366)*y(97) +rxt(367)*y(98) + &
                 rxt(379)*y(101) +rxt(388)*y(103))*y(8) + (.470_r8*rxt(347)*y(79) + &
                 rxt(374)*y(97) +rxt(375)*y(98) +rxt(381)*y(101) +rxt(391)*y(103)) &
                 *y(48) + (rxt(251)*y(152) +rxt(256)*y(153) +rxt(210)*y(24) + &
                 rxt(213)*y(16))*y(27) + (.160_r8*rxt(415)*y(124) + &
                 .070_r8*rxt(429)*y(130) +.330_r8*rxt(431)*y(131))*y(23) &
                  + (rxt(183)*y(24) +rxt(268)*y(16))*y(2) + (rxt(13) +rxt(207))*y(10) &
                  + (rxt(288) +rxt(289))*y(56) + (1.340_r8*rxt(61) +.660_r8*rxt(62)) &
                 *y(78) +rxt(161)*y(12)*y(3) +rxt(237)*y(36)*y(16) +rxt(167)*y(21) &
                  +rxt(277)*y(43) +1.200_r8*rxt(295)*y(46)*y(46) +rxt(64)*y(47) &
                  +rxt(56)*y(50) +2.000_r8*rxt(81)*y(52) +2.000_r8*rxt(84)*y(53) &
                  +rxt(66)*y(62) +rxt(57)*y(65) +rxt(80)*y(66) +rxt(69)*y(68) +rxt(72) &
                 *y(82) +.670_r8*rxt(78)*y(84) +rxt(73)*y(87) +rxt(74)*y(88) +rxt(75) &
                 *y(90) +.900_r8*rxt(85)*y(94) +.560_r8*rxt(83)*y(95) +rxt(376)*y(98) &
                  +rxt(98)*y(99) +rxt(79)*y(105) +rxt(87)*y(109) +1.500_r8*rxt(93) &
                 *y(112) +rxt(99)*y(116) +rxt(101)*y(119) +rxt(92)*y(120) &
                  +.600_r8*rxt(95)*y(121) +.600_r8*rxt(96)*y(122) +rxt(97)*y(123) &
                  +rxt(94)*y(125) +rxt(102)*y(127) +rxt(103)*y(136) +rxt(104)*y(138) &
                  +rxt(88)*y(144) +rxt(90)*y(145) +1.200_r8*rxt(91)*y(149) +rxt(89) &
                 *y(150)
         loss(140) = (rxt(183)* y(2) +rxt(178)* y(22) +rxt(210)* y(27) + rxt(20) &
                  + het_rates(24))* y(24)
         prod(140) = (.500_r8*rxt(485) +rxt(182)*y(23))*y(23) +rxt(176)*y(22)*y(22)
         loss(197) = (rxt(140)* y(3) + rxt(17) + rxt(18) + rxt(19) + het_rates(237)) &
                 * y(237)
         prod(197) = (rxt(252)*y(152) +rxt(253)*y(159) +rxt(254)*y(157) + &
                 rxt(255)*y(153) +rxt(259)*y(169) +rxt(263)*y(12) +rxt(174)*y(23) + &
                 rxt(175)*y(22) +rxt(177)*y(20) +rxt(178)*y(24) +rxt(200)*y(9) + &
                 rxt(206)*y(10) +rxt(227)*y(32) +rxt(231)*y(33) +rxt(247)*y(38) + &
                 rxt(267)*y(16) +rxt(275)*y(14) +rxt(276)*y(42) +rxt(284)*y(45) + &
                 rxt(291)*y(49) +rxt(297)*y(50) +rxt(304)*y(54) +rxt(316)*y(62) + &
                 rxt(317)*y(60) +rxt(320)*y(65) +rxt(321)*y(63) +rxt(325)*y(69) + &
                 rxt(327)*y(68) +.500_r8*rxt(340)*y(78) +rxt(392)*y(104) + &
                 rxt(393)*y(104))*y(22) + (rxt(495)*y(33) +rxt(496)*y(39) + &
                 rxt(500)*y(33) +rxt(506)*y(33) +rxt(507)*y(39))*y(32) +rxt(171)*y(23) &
                 *y(21)
         loss(207) = (rxt(208)* y(1) +rxt(214)* y(12) +rxt(213)* y(16) +rxt(209) &
                 * y(20) + (rxt(211) +rxt(212))* y(23) +rxt(210)* y(24) +rxt(230) &
                 * y(33) +rxt(234)* y(34) +rxt(282)* y(45) +rxt(251)* y(152) +rxt(256) &
                 * y(153) +rxt(262)* y(168) +rxt(261)* y(169) + het_rates(27))* y(27)
         prod(207) = (3.000_r8*rxt(144)*y(154) +2.000_r8*rxt(145)*y(155) + &
                 3.000_r8*rxt(146)*y(156) +2.000_r8*rxt(147)*y(164) +rxt(148)*y(165) + &
                 rxt(149)*y(157) +2.000_r8*rxt(150)*y(162) +rxt(151)*y(163) + &
                 4.000_r8*rxt(152)*y(158) +rxt(154)*y(161) +rxt(164)*y(32))*y(3) &
                  + (rxt(22) +rxt(215)*y(2) +rxt(216)*y(22) +rxt(219)*y(13) + &
                 rxt(220)*y(6) +2.000_r8*rxt(222)*y(29) +rxt(224)*y(29) + &
                 rxt(244)*y(37))*y(29) + (rxt(252)*y(152) +3.000_r8*rxt(253)*y(159) + &
                 rxt(254)*y(157) +2.000_r8*rxt(257)*y(162) +rxt(258)*y(163) + &
                 rxt(227)*y(32))*y(22) + (rxt(26) +rxt(228)*y(2))*y(32) &
                  +2.000_r8*rxt(21)*y(28) +2.000_r8*rxt(24)*y(31) +rxt(25)*y(33) &
                  +rxt(27)*y(34) +rxt(29)*y(35)
         loss(80) = ( + rxt(21) + het_rates(28))* y(28)
         prod(80) = (rxt(494)*y(34) +rxt(495)*y(33) +rxt(499)*y(34) +rxt(500)*y(33) + &
                 rxt(505)*y(34) +rxt(506)*y(33))*y(32) +rxt(234)*y(34)*y(27) &
                  +rxt(223)*y(29)*y(29)
         loss(203) = (rxt(215)* y(2) +rxt(220)* y(6) +rxt(221)* y(7) +rxt(219)* y(13) &
                  + (rxt(216) +rxt(217))* y(22) +rxt(218)* y(23) + 2._r8*(rxt(222) + &
                 rxt(223) +rxt(224) +rxt(225))* y(29) + (rxt(243) +rxt(244) +rxt(245)) &
                 * y(37) + rxt(22) + het_rates(29))* y(29)
         prod(203) = (rxt(208)*y(1) +rxt(212)*y(23) +rxt(230)*y(33))*y(27) &
                  + (rxt(229)*y(33) +rxt(232)*y(34))*y(2) +rxt(231)*y(33)*y(22) &
                  +rxt(23)*y(30) +2.000_r8*rxt(226)*y(31) +rxt(28)*y(34)
         loss(76) = ( + rxt(23) + het_rates(30))* y(30)
         prod(76) = (rxt(224)*y(29) +rxt(243)*y(37))*y(29)
         loss(69) = ( + rxt(24) + rxt(226) + het_rates(31))* y(31)
         prod(69) =rxt(225)*y(29)*y(29)
         loss(206) = (rxt(228)* y(2) +rxt(164)* y(3) +rxt(227)* y(22) + (rxt(495) + &
                 rxt(500) +rxt(506))* y(33) + (rxt(494) +rxt(499) +rxt(505))* y(34) &
                  + (rxt(496) +rxt(507))* y(39) + rxt(26) + het_rates(32))* y(32)
         prod(206) = (rxt(214)*y(12) +2.000_r8*rxt(251)*y(152) +rxt(256)*y(153) + &
                 rxt(261)*y(169) +rxt(262)*y(168) +rxt(209)*y(20) +rxt(210)*y(24) + &
                 rxt(211)*y(23) +rxt(213)*y(16) +rxt(230)*y(33) +rxt(282)*y(45))*y(27) &
                  +rxt(217)*y(29)*y(22)
         loss(162) = (rxt(229)* y(2) +rxt(231)* y(22) +rxt(230)* y(27) + (rxt(495) + &
                 rxt(500) +rxt(506))* y(32) + rxt(25) + het_rates(33))* y(33)
         prod(162) = (rxt(492) +rxt(498) +rxt(503) +rxt(233)*y(22))*y(34) &
                  +rxt(218)*y(29)*y(23)
         loss(168) = (rxt(232)* y(2) +rxt(233)* y(22) +rxt(234)* y(27) + (rxt(494) + &
                 rxt(499) +rxt(505))* y(32) + rxt(27) + rxt(28) + rxt(492) + rxt(498) &
                  + rxt(503) + het_rates(34))* y(34)
         prod(168) =rxt(221)*y(29)*y(7)
         loss(91) = ( + rxt(29) + het_rates(35))* y(35)
         prod(91) = (rxt(496)*y(39) +rxt(507)*y(39))*y(32) +rxt(245)*y(37)*y(29)
         loss(210) = (rxt(235)* y(1) +rxt(237)* y(16) +rxt(236)* y(23) &
                  + het_rates(36))* y(36)
         prod(210) = (rxt(153)*y(153) +rxt(154)*y(161) +rxt(155)*y(160) + &
                 2.000_r8*rxt(156)*y(166) +2.000_r8*rxt(157)*y(167) + &
                 3.000_r8*rxt(158)*y(168) +2.000_r8*rxt(159)*y(169) +rxt(165)*y(38)) &
                 *y(3) + (rxt(30) +rxt(238)*y(2) +rxt(239)*y(22) +rxt(241)*y(6) + &
                 rxt(243)*y(29) +rxt(244)*y(29) +2.000_r8*rxt(246)*y(37))*y(37) &
                  + (rxt(255)*y(153) +2.000_r8*rxt(259)*y(169) + &
                 3.000_r8*rxt(260)*y(168) +rxt(247)*y(38))*y(22) + (rxt(256)*y(153) + &
                 2.000_r8*rxt(261)*y(169) +3.000_r8*rxt(262)*y(168))*y(27) &
                  + (rxt(32) +rxt(248)*y(2))*y(38) +rxt(29)*y(35) +rxt(31)*y(39) &
                  +rxt(33)*y(40)
         loss(200) = (rxt(238)* y(2) +rxt(241)* y(6) +rxt(242)* y(7) +rxt(239)* y(22) &
                  +rxt(240)* y(23) + (rxt(243) +rxt(244) +rxt(245))* y(29) &
                  + 2._r8*rxt(246)* y(37) + rxt(30) + het_rates(37))* y(37)
         prod(200) = (rxt(249)*y(39) +rxt(250)*y(40))*y(2) +rxt(235)*y(36)*y(1) &
                  +rxt(34)*y(40)
         loss(157) = (rxt(248)* y(2) +rxt(165)* y(3) +rxt(247)* y(22) + rxt(32) &
                  + het_rates(38))* y(38)
         prod(157) = (rxt(236)*y(23) +rxt(237)*y(16))*y(36)
         loss(156) = (rxt(249)* y(2) + (rxt(496) +rxt(507))* y(32) + rxt(31) &
                  + het_rates(39))* y(39)
         prod(156) = (rxt(493) +rxt(501) +rxt(504))*y(40) +rxt(240)*y(37)*y(23)
         loss(133) = (rxt(250)* y(2) + rxt(33) + rxt(34) + rxt(493) + rxt(501) &
                  + rxt(504) + het_rates(40))* y(40)
         prod(133) =rxt(242)*y(37)*y(7)
         loss(175) = (rxt(311)* y(1) +rxt(312)* y(8) +rxt(310)* y(22) + het_rates(59)) &
                 * y(59)
         prod(175) =.130_r8*rxt(360)*y(92)*y(1) +.700_r8*rxt(63)*y(77)
         loss(165) = (rxt(360)* y(1) +rxt(361)* y(8) +rxt(359)* y(22) + het_rates(92)) &
                 * y(92)
         prod(165) = 0._r8
         loss(155) = (rxt(318)* y(6) +rxt(319)* y(23) + het_rates(64))* y(64)
         prod(155) = (rxt(310)*y(59) +.500_r8*rxt(320)*y(65))*y(22)
         loss(186) = (rxt(298)* y(8) +rxt(297)* y(22) + rxt(56) + het_rates(50)) &
                 * y(50)
         prod(186) = (rxt(292)*y(46) +.270_r8*rxt(313)*y(61) +rxt(318)*y(64) + &
                 rxt(331)*y(73) +rxt(337)*y(74) +.400_r8*rxt(395)*y(93))*y(6) &
                  + (.500_r8*rxt(296)*y(47) +rxt(307)*y(51) +.800_r8*rxt(397)*y(82)) &
                 *y(22) + (.500_r8*rxt(311)*y(59) +.100_r8*rxt(335)*y(77))*y(1) &
                  + (.800_r8*rxt(294)*y(13) +1.600_r8*rxt(295)*y(46))*y(46) &
                  +rxt(333)*y(70)*y(8) +.200_r8*rxt(338)*y(74)*y(23) +rxt(64)*y(47) &
                  +rxt(57)*y(65) +rxt(86)*y(75) +.400_r8*rxt(72)*y(82) &
                  +.330_r8*rxt(78)*y(84) +.400_r8*rxt(85)*y(94)
         loss(134) = (rxt(291)* y(22) + het_rates(49))* y(49)
         prod(134) = (.150_r8*rxt(301)*y(48) +.150_r8*rxt(351)*y(76))*y(23) &
                  +.120_r8*rxt(311)*y(59)*y(1) +.100_r8*rxt(302)*y(48)*y(13)
         loss(135) = (rxt(320)* y(22) + rxt(57) + het_rates(65))* y(65)
         prod(135) =rxt(319)*y(64)*y(23)
         loss(196) = (rxt(299)* y(6) +rxt(300)* y(7) +rxt(302)* y(13) +rxt(301)* y(23) &
                  + 2._r8*rxt(303)* y(48) +rxt(347)* y(79) +rxt(374)* y(97) +rxt(375) &
                 * y(98) +rxt(381)* y(101) +rxt(391)* y(103) + het_rates(48))* y(48)
         prod(196) = (.280_r8*rxt(335)*y(77) +.100_r8*rxt(341)*y(78) + &
                 .080_r8*rxt(360)*y(92) +.060_r8*rxt(445)*y(141) + &
                 .060_r8*rxt(446)*y(142))*y(1) + (rxt(349)*y(6) +rxt(350)*y(8) + &
                 .450_r8*rxt(351)*y(23) +rxt(352)*y(13) +2.000_r8*rxt(354)*y(76)) &
                 *y(76) + (rxt(297)*y(50) +.500_r8*rxt(304)*y(54) +rxt(327)*y(68) + &
                 .650_r8*rxt(459)*y(149))*y(22) + (.530_r8*rxt(342)*y(6) + &
                 .530_r8*rxt(344)*y(8) +.260_r8*rxt(346)*y(13) + &
                 .530_r8*rxt(347)*y(48))*y(79) + (rxt(322)*y(6) + &
                 .150_r8*rxt(323)*y(23) +.300_r8*rxt(324)*y(13))*y(67) &
                  + (rxt(298)*y(50) +rxt(328)*y(68))*y(8) + (.600_r8*rxt(59) + &
                 rxt(308))*y(58) + (rxt(337)*y(6) +.200_r8*rxt(338)*y(23))*y(74) &
                  +rxt(68)*y(63) +rxt(80)*y(66) +rxt(69)*y(68) +rxt(67)*y(69) +rxt(82) &
                 *y(72) +rxt(86)*y(75) +.300_r8*rxt(63)*y(77) +1.340_r8*rxt(61)*y(78) &
                  +rxt(77)*y(83) +.330_r8*rxt(78)*y(84) +.130_r8*rxt(83)*y(95) &
                  +rxt(97)*y(123) +.500_r8*rxt(94)*y(125) +.650_r8*rxt(91)*y(149)
         loss(130) = (rxt(304)* y(22) + rxt(58) + het_rates(54))* y(54)
         prod(130) = (.400_r8*rxt(301)*y(48) +.400_r8*rxt(351)*y(76))*y(23)
         loss(126) = (rxt(309)* y(22) + rxt(59) + rxt(308) + het_rates(58))* y(58)
         prod(126) =rxt(300)*y(48)*y(7)
         loss(100) = (rxt(284)* y(22) +rxt(282)* y(27) + het_rates(45))* y(45)
         prod(100) = 0._r8
         loss(136) = (rxt(290)* y(1) +rxt(285)* y(22) +rxt(281)* y(27) &
                  + het_rates(44))* y(44)
         prod(136) = 0._r8
         loss(92) = (rxt(394)* y(22) + het_rates(71))* y(71)
         prod(92) = (.050_r8*rxt(445)*y(141) +.050_r8*rxt(446)*y(142))*y(1)
         loss(137) = (rxt(357)* y(22) + rxt(60) + rxt(356) + het_rates(81))* y(81)
         prod(137) =rxt(355)*y(76)*y(7)
         loss(145) = (rxt(397)* y(22) + rxt(72) + het_rates(82))* y(82)
         prod(145) =rxt(396)*y(93)*y(6)
         loss(166) = (rxt(329)* y(22) + rxt(77) + het_rates(83))* y(83)
         prod(166) = (.500_r8*rxt(365)*y(86) +rxt(383)*y(87) +rxt(384)*y(89) + &
                 rxt(385)*y(88))*y(22) +rxt(312)*y(59)*y(8)
         loss(183) = (rxt(358)* y(22) + rxt(78) + het_rates(84))* y(84)
         prod(183) = (rxt(332)*y(73) +rxt(343)*y(79))*y(6) + (.300_r8*rxt(364)*y(85) + &
                 .500_r8*rxt(365)*y(86))*y(22)
         loss(138) = (rxt(364)* y(22) + het_rates(85))* y(85)
         prod(138) =.080_r8*rxt(362)*y(97)*y(6)
         loss(128) = (rxt(365)* y(22) + het_rates(86))* y(86)
         prod(128) =.080_r8*rxt(363)*y(98)*y(6)
         loss(120) = (rxt(383)* y(22) + rxt(73) + het_rates(87))* y(87)
         prod(120) =rxt(380)*y(101)*y(23)
         loss(164) = (rxt(385)* y(22) + rxt(74) + het_rates(88))* y(88)
         prod(164) = (rxt(378)*y(6) +rxt(379)*y(8) +rxt(381)*y(48) + &
                 .800_r8*rxt(382)*y(13))*y(101)
         loss(107) = (rxt(384)* y(22) + het_rates(89))* y(89)
         prod(107) =.200_r8*rxt(382)*y(101)*y(13)
         loss(131) = (rxt(464)* y(22) + rxt(75) + het_rates(90))* y(90)
         prod(131) = (.200_r8*rxt(449)*y(143) +.200_r8*rxt(460)*y(151))*y(6) &
                  +.500_r8*rxt(462)*y(151)*y(13)
         loss(108) = (rxt(465)* y(22) + rxt(76) + het_rates(91))* y(91)
         prod(108) =rxt(461)*y(151)*y(23)
         loss(110) = (rxt(333)* y(8) +rxt(330)* y(22) + het_rates(70))* y(70)
         prod(110) = 0._r8
         loss(139) = ((rxt(331) +rxt(332))* y(6) + het_rates(73))* y(73)
         prod(139) =rxt(330)*y(70)*y(22)
         loss(172) = ((rxt(395) +rxt(396))* y(6) +rxt(398)* y(23) + het_rates(93)) &
                 * y(93)
         prod(172) = (rxt(394)*y(71) +rxt(399)*y(94))*y(22)
         loss(146) = (rxt(399)* y(22) + rxt(85) + het_rates(94))* y(94)
         prod(146) =rxt(398)*y(93)*y(23)
         loss(132) = (rxt(336)* y(22) + rxt(82) + het_rates(72))* y(72)
         prod(132) =.800_r8*rxt(395)*y(93)*y(6) +.800_r8*rxt(72)*y(82) &
                  +.800_r8*rxt(85)*y(94)
         loss(147) = (rxt(337)* y(6) +rxt(338)* y(23) + het_rates(74))* y(74)
         prod(147) = (rxt(336)*y(72) +rxt(339)*y(75))*y(22)
         loss(109) = (rxt(339)* y(22) + rxt(86) + het_rates(75))* y(75)
         prod(109) =.800_r8*rxt(338)*y(74)*y(23)
         loss(86) = (rxt(416)* y(22) + het_rates(106))* y(106)
         prod(86) = 0._r8
         loss(87) = (rxt(417)* y(22) + het_rates(107))* y(107)
         prod(87) =.180_r8*rxt(416)*y(106)*y(22)
         loss(150) = (rxt(428)* y(6) +rxt(426)* y(23) + het_rates(108))* y(108)
         prod(150) = (.650_r8*rxt(416)*y(106) +rxt(427)*y(109))*y(22)
         loss(141) = (rxt(427)* y(22) + rxt(87) + het_rates(109))* y(109)
         prod(141) =rxt(426)*y(108)*y(23)
         loss(167) = (rxt(449)* y(6) +rxt(451)* y(13) +rxt(450)* y(23) &
                  + het_rates(143))* y(143)
         prod(167) = (rxt(443)*y(141) +rxt(444)*y(142) +rxt(452)*y(144))*y(22)
         loss(125) = (rxt(452)* y(22) + rxt(88) + het_rates(144))* y(144)
         prod(125) =rxt(450)*y(143)*y(23)
         loss(112) = ( + rxt(83) + het_rates(95))* y(95)
         prod(112) = (.100_r8*rxt(445)*y(141) +.100_r8*rxt(446)*y(142))*y(1)
         loss(169) = (rxt(306)* y(22) + rxt(84) + rxt(486) + het_rates(53))* y(53)
         prod(169) = (.050_r8*rxt(363)*y(98) +.250_r8*rxt(387)*y(103) + &
                 .700_r8*rxt(402)*y(114) +rxt(410)*y(113) +.400_r8*rxt(414)*y(124) + &
                 .600_r8*rxt(428)*y(108) +.170_r8*rxt(432)*y(131) + &
                 .170_r8*rxt(437)*y(135) +.340_r8*rxt(442)*y(137))*y(6) &
                  + (.650_r8*rxt(283)*y(41) +.200_r8*rxt(305)*y(52) +rxt(385)*y(88)) &
                 *y(22) + (.250_r8*rxt(388)*y(8) +.100_r8*rxt(390)*y(13) + &
                 .250_r8*rxt(391)*y(48))*y(103) + (.160_r8*rxt(415)*y(124) + &
                 .070_r8*rxt(431)*y(131))*y(23) +.050_r8*rxt(367)*y(98)*y(8) &
                  +.130_r8*rxt(83)*y(95) +.600_r8*rxt(87)*y(109) +.700_r8*rxt(99) &
                 *y(116) +rxt(101)*y(119) +.170_r8*rxt(103)*y(136) +.340_r8*rxt(104) &
                 *y(138)
         loss(77) = (rxt(400)* y(22) + het_rates(110))* y(110)
         prod(77) = 0._r8
         loss(83) = (rxt(435)* y(22) + het_rates(133))* y(133)
         prod(83) = 0._r8
         loss(79) = (rxt(401)* y(22) + het_rates(111))* y(111)
         prod(79) =.530_r8*rxt(400)*y(110)*y(22)
         loss(78) = ( + rxt(93) + het_rates(112))* y(112)
         prod(78) =.120_r8*rxt(400)*y(110)*y(22)
         loss(123) = (rxt(410)* y(6) +rxt(411)* y(23) + het_rates(113))* y(113)
         prod(123) = (.350_r8*rxt(400)*y(110) +rxt(412)*y(119))*y(22)
         loss(117) = (rxt(402)* y(6) +rxt(403)* y(23) + het_rates(114))* y(114)
         prod(117) = (.140_r8*rxt(401)*y(111) +rxt(404)*y(116) + &
                 .200_r8*rxt(417)*y(107))*y(22)
         loss(124) = (rxt(406)* y(1) +rxt(405)* y(7) + het_rates(115))* y(115)
         prod(124) = (.060_r8*rxt(401)*y(111) +.070_r8*rxt(417)*y(107) + &
                 .070_r8*rxt(436)*y(134))*y(22) +rxt(407)*y(117)*y(6) +rxt(100)*y(118)
         loss(105) = (rxt(404)* y(22) + rxt(99) + het_rates(116))* y(116)
         prod(105) =rxt(403)*y(114)*y(23)
         loss(144) = (rxt(407)* y(6) +rxt(408)* y(23) + het_rates(117))* y(117)
         prod(144) = (rxt(424)*y(6) +.400_r8*rxt(425)*y(23))*y(129) +rxt(406)*y(115) &
                 *y(1) +rxt(409)*y(118)*y(22)
         loss(93) = (rxt(409)* y(22) + rxt(100) + het_rates(118))* y(118)
         prod(93) =rxt(408)*y(117)*y(23)
         loss(118) = (rxt(412)* y(22) + rxt(101) + het_rates(119))* y(119)
         prod(118) =rxt(411)*y(113)*y(23)
         loss(122) = ( + rxt(92) + het_rates(120))* y(120)
         prod(122) = (.500_r8*rxt(410)*y(113) +.200_r8*rxt(428)*y(108) + &
                 .060_r8*rxt(442)*y(137))*y(6) +.200_r8*rxt(87)*y(109) +rxt(93)*y(112) &
                  +.500_r8*rxt(101)*y(119) +.060_r8*rxt(104)*y(138)
         loss(99) = ( + rxt(95) + het_rates(121))* y(121)
         prod(99) = (.200_r8*rxt(428)*y(108) +.200_r8*rxt(442)*y(137))*y(6) &
                  +.200_r8*rxt(87)*y(109) +.200_r8*rxt(104)*y(138)
         loss(143) = ( + rxt(96) + het_rates(122))* y(122)
         prod(143) = (.200_r8*rxt(428)*y(108) +.150_r8*rxt(442)*y(137))*y(6) +rxt(74) &
                 *y(88) +rxt(98)*y(99) +.200_r8*rxt(87)*y(109) +.150_r8*rxt(104) &
                 *y(138)
         loss(101) = ( + rxt(97) + het_rates(123))* y(123)
         prod(101) =.210_r8*rxt(442)*y(137)*y(6) +.210_r8*rxt(104)*y(138)
         loss(149) = (rxt(414)* y(6) +rxt(413)* y(7) +rxt(415)* y(23) &
                  + het_rates(124))* y(124)
         prod(149) =.600_r8*rxt(92)*y(120)
         loss(85) = ( + rxt(94) + het_rates(125))* y(125)
         prod(85) = (.100_r8*rxt(416)*y(106) +.230_r8*rxt(435)*y(133))*y(22)
         loss(119) = (rxt(420)* y(6) +rxt(418)* y(23) + het_rates(126))* y(126)
         prod(119) = (.070_r8*rxt(416)*y(106) +rxt(419)*y(127) + &
                 .060_r8*rxt(435)*y(133))*y(22)
         loss(106) = (rxt(419)* y(22) + rxt(102) + het_rates(127))* y(127)
         prod(106) =rxt(418)*y(126)*y(23)
         loss(88) = (rxt(421)* y(22) + het_rates(128))* y(128)
         prod(88) =rxt(420)*y(126)*y(6) +rxt(102)*y(127)
         loss(129) = (rxt(424)* y(6) +rxt(422)* y(7) +rxt(425)* y(23) &
                  + het_rates(129))* y(129)
         prod(129) =rxt(421)*y(128)*y(22) +rxt(423)*y(132)
         loss(154) = (rxt(430)* y(6) +rxt(433)* y(7) +rxt(429)* y(23) &
                  + het_rates(130))* y(130)
         prod(154) =.600_r8*rxt(95)*y(121)
         loss(181) = (rxt(432)* y(6) +rxt(434)* y(7) +rxt(431)* y(23) &
                  + het_rates(131))* y(131)
         prod(181) =.600_r8*rxt(96)*y(122)
         loss(72) = ( + rxt(423) + het_rates(132))* y(132)
         prod(72) =rxt(422)*y(129)*y(7)
         loss(84) = (rxt(436)* y(22) + het_rates(134))* y(134)
         prod(84) =.150_r8*rxt(435)*y(133)*y(22)
         loss(127) = (rxt(437)* y(6) +rxt(438)* y(23) + het_rates(135))* y(135)
         prod(127) = (.300_r8*rxt(436)*y(134) +rxt(439)*y(136))*y(22)
         loss(111) = (rxt(439)* y(22) + rxt(103) + het_rates(136))* y(136)
         prod(111) =rxt(438)*y(135)*y(23)
         loss(153) = (rxt(442)* y(6) +rxt(440)* y(23) + het_rates(137))* y(137)
         prod(153) = (.560_r8*rxt(435)*y(133) +rxt(441)*y(138))*y(22)
         loss(148) = (rxt(441)* y(22) + rxt(104) + het_rates(138))* y(138)
         prod(148) =rxt(440)*y(137)*y(23)
         loss(171) = (rxt(445)* y(1) +rxt(447)* y(8) +rxt(443)* y(22) &
                  + het_rates(141))* y(141)
         prod(171) = 0._r8
         loss(170) = (rxt(446)* y(1) +rxt(448)* y(8) +rxt(444)* y(22) &
                  + het_rates(142))* y(142)
         prod(170) = 0._r8
         loss(7) = (rxt(470)* y(22) + het_rates(140))* y(140)
         prod(7) = 0._r8
         loss(14) = (rxt(469)* y(22) + het_rates(139))* y(139)
         prod(14) = 0._r8
         loss(8) = (rxt(472)* y(22) + het_rates(148))* y(148)
         prod(8) = 0._r8
         loss(15) = (rxt(471)* y(22) + het_rates(147))* y(147)
         prod(15) = 0._r8
         loss(174) = (rxt(455)* y(8) +rxt(454)* y(22) + rxt(90) + het_rates(145)) &
                 * y(145)
         prod(174) = (.800_r8*rxt(460)*y(6) +.500_r8*rxt(462)*y(13) +rxt(463)*y(8)) &
                 *y(151) + (.330_r8*rxt(445)*y(141) +.330_r8*rxt(446)*y(142))*y(1) &
                  + (rxt(75) +rxt(464)*y(22))*y(90) + (.800_r8*rxt(449)*y(6) + &
                 rxt(451)*y(13))*y(143) +rxt(76)*y(91) +rxt(88)*y(144)
         loss(180) = (rxt(456)* y(6) +rxt(458)* y(13) +rxt(457)* y(23) &
                  + het_rates(146))* y(146)
         prod(180) = (rxt(453)*y(150) +rxt(454)*y(145))*y(22) +.500_r8*rxt(455)*y(145) &
                 *y(8)
         loss(179) = (rxt(459)* y(22) + rxt(91) + het_rates(149))* y(149)
         prod(179) = (.300_r8*rxt(445)*y(141) +.300_r8*rxt(446)*y(142))*y(1) &
                  + (.900_r8*rxt(456)*y(6) +rxt(458)*y(13))*y(146) +rxt(90)*y(145) &
                  +rxt(89)*y(150)
         loss(142) = (rxt(453)* y(22) + rxt(89) + het_rates(150))* y(150)
         prod(142) =rxt(457)*y(146)*y(23)
         loss(178) = (rxt(460)* y(6) +rxt(463)* y(8) +rxt(462)* y(13) +rxt(461)* y(23) &
                  + het_rates(151))* y(151)
         prod(178) = (rxt(447)*y(141) +rxt(448)*y(142) +.500_r8*rxt(455)*y(145))*y(8) &
                  +rxt(465)*y(91)*y(22)
         loss(191) = (rxt(362)* y(6) +rxt(366)* y(8) +rxt(372)* y(13) +rxt(368)* y(23) &
                  +rxt(374)* y(48) + het_rates(97))* y(97)
         prod(191) =.600_r8*rxt(359)*y(92)*y(22)
         loss(194) = (rxt(363)* y(6) +rxt(367)* y(8) +rxt(373)* y(13) +rxt(369)* y(23) &
                  +rxt(375)* y(48) + rxt(376) + het_rates(98))* y(98)
         prod(194) =.400_r8*rxt(359)*y(92)*y(22)
         loss(89) = (rxt(377)* y(22) + rxt(98) + het_rates(99))* y(99)
         prod(89) =rxt(376)*y(98)
         loss(73) = (rxt(371)* y(22) + het_rates(100))* y(100)
         prod(73) =.600_r8*rxt(370)*y(105)*y(22)
         loss(192) = (rxt(335)* y(1) +rxt(334)* y(22) + rxt(63) + het_rates(77)) &
                 * y(77)
         prod(192) = (.560_r8*rxt(362)*y(6) +.600_r8*rxt(366)*y(8) + &
                 .440_r8*rxt(372)*y(13) +.610_r8*rxt(374)*y(48))*y(97) &
                  +.200_r8*rxt(360)*y(92)*y(1) +.402_r8*rxt(79)*y(105)
         loss(188) = (rxt(341)* y(1) +rxt(340)* y(22) + rxt(61) + rxt(62) &
                  + het_rates(78))* y(78)
         prod(188) = (.360_r8*rxt(362)*y(6) +.400_r8*rxt(366)*y(8) + &
                 .310_r8*rxt(372)*y(13) +.390_r8*rxt(374)*y(48))*y(97) &
                  +.300_r8*rxt(360)*y(92)*y(1) +.288_r8*rxt(79)*y(105)
         loss(193) = ((rxt(342) +rxt(343))* y(6) +rxt(344)* y(8) +rxt(346)* y(13) &
                  +rxt(345)* y(23) +rxt(347)* y(48) + het_rates(79))* y(79)
         prod(193) = (rxt(334)*y(77) +.500_r8*rxt(340)*y(78) +.200_r8*rxt(348)*y(80)) &
                 *y(22)
         loss(102) = (rxt(348)* y(22) + het_rates(80))* y(80)
         prod(102) =rxt(345)*y(79)*y(23)
         loss(195) = (rxt(349)* y(6) +rxt(355)* y(7) +rxt(350)* y(8) +rxt(352)* y(13) &
                  +rxt(351)* y(23) +rxt(353)* y(48) + 2._r8*rxt(354)* y(76) &
                  + het_rates(76))* y(76)
         prod(195) = (.500_r8*rxt(340)*y(78) +.500_r8*rxt(348)*y(80))*y(22) &
                  + (rxt(60) +rxt(356))*y(81) +.660_r8*rxt(61)*y(78)
         loss(163) = (rxt(292)* y(6) +rxt(294)* y(13) +rxt(293)* y(23) &
                  + 2._r8*rxt(295)* y(46) + het_rates(46))* y(46)
         prod(163) = (rxt(284)*y(45) +.500_r8*rxt(296)*y(47))*y(22) +rxt(282)*y(45) &
                 *y(27) +rxt(82)*y(72)
         loss(103) = (rxt(296)* y(22) + rxt(64) + het_rates(47))* y(47)
         prod(103) =rxt(293)*y(46)*y(23)
         loss(70) = (rxt(317)* y(22) + het_rates(60))* y(60)
         prod(70) = 0._r8
         loss(158) = (rxt(313)* y(6) +rxt(315)* y(13) +rxt(314)* y(23) &
                  + het_rates(61))* y(61)
         prod(158) = (rxt(316)*y(62) +rxt(317)*y(60))*y(22)
         loss(113) = (rxt(316)* y(22) + rxt(66) + het_rates(62))* y(62)
         prod(113) =rxt(314)*y(61)*y(23)
         loss(173) = (rxt(321)* y(22) + rxt(68) + het_rates(63))* y(63)
         prod(173) = (.820_r8*rxt(313)*y(61) +.500_r8*rxt(331)*y(73) + &
                 .250_r8*rxt(395)*y(93) +.040_r8*rxt(449)*y(143) + &
                 .270_r8*rxt(456)*y(146))*y(6) + (.820_r8*rxt(315)*y(61) + &
                 .025_r8*rxt(451)*y(143) +.150_r8*rxt(458)*y(146))*y(13) &
                  + (.800_r8*rxt(397)*y(82) +.750_r8*rxt(399)*y(94) + &
                 .500_r8*rxt(459)*y(149))*y(22) + (.520_r8*rxt(445)*y(141) + &
                 .520_r8*rxt(446)*y(142))*y(1) +.500_r8*rxt(333)*y(70)*y(8) &
                  +.820_r8*rxt(66)*y(62) +.250_r8*rxt(72)*y(82) +.170_r8*rxt(78)*y(84) &
                  +.250_r8*rxt(85)*y(94) +.050_r8*rxt(88)*y(144) +.500_r8*rxt(91) &
                 *y(149) +.300_r8*rxt(89)*y(150)
         loss(114) = (rxt(325)* y(22) + rxt(67) + het_rates(69))* y(69)
         prod(114) =.850_r8*rxt(323)*y(67)*y(23)
         loss(159) = (rxt(274)* y(22) + het_rates(15))* y(15)
         prod(159) = (rxt(273)*y(13) +.300_r8*rxt(294)*y(46) +.500_r8*rxt(324)*y(67) + &
                 .250_r8*rxt(346)*y(79) +.250_r8*rxt(372)*y(97) + &
                 .250_r8*rxt(373)*y(98) +.200_r8*rxt(382)*y(101) + &
                 .300_r8*rxt(390)*y(103) +.250_r8*rxt(451)*y(143) + &
                 .250_r8*rxt(458)*y(146) +.250_r8*rxt(462)*y(151))*y(13)
         loss(94) = (rxt(307)* y(22) + het_rates(51))* y(51)
         prod(94) = (.200_r8*rxt(294)*y(13) +.400_r8*rxt(295)*y(46))*y(46)
         loss(177) = (rxt(305)* y(22) + rxt(81) + het_rates(52))* y(52)
         prod(177) = (.530_r8*rxt(342)*y(79) +.050_r8*rxt(363)*y(98) + &
                 .250_r8*rxt(387)*y(103) +.225_r8*rxt(456)*y(146))*y(6) &
                  + (.530_r8*rxt(344)*y(79) +.050_r8*rxt(367)*y(98) + &
                 .250_r8*rxt(388)*y(103))*y(8) + (.260_r8*rxt(346)*y(79) + &
                 .100_r8*rxt(390)*y(103) +.125_r8*rxt(458)*y(146))*y(13) &
                  + (.700_r8*rxt(364)*y(85) +.500_r8*rxt(365)*y(86) +rxt(384)*y(89)) &
                 *y(22) + (.530_r8*rxt(347)*y(79) +.250_r8*rxt(391)*y(103))*y(48) &
                  +rxt(288)*y(56) +.330_r8*rxt(78)*y(84) +.250_r8*rxt(89)*y(150)
         loss(184) = (rxt(326)* y(22) + rxt(80) + het_rates(66))* y(66)
         prod(184) = (.500_r8*rxt(320)*y(65) +.500_r8*rxt(357)*y(81) + &
                 .700_r8*rxt(364)*y(85) +.500_r8*rxt(365)*y(86))*y(22) &
                  + (.220_r8*rxt(342)*y(6) +.220_r8*rxt(344)*y(8) + &
                 .230_r8*rxt(346)*y(13) +.220_r8*rxt(347)*y(48))*y(79) &
                  + (.250_r8*rxt(387)*y(6) +.250_r8*rxt(388)*y(8) + &
                 .100_r8*rxt(390)*y(13) +.250_r8*rxt(391)*y(48))*y(103) &
                  + (.050_r8*rxt(363)*y(6) +.050_r8*rxt(367)*y(8))*y(98) &
                  +.200_r8*rxt(324)*y(67)*y(13) +.170_r8*rxt(78)*y(84)
         loss(151) = (rxt(286)* y(6) +rxt(287)* y(23) + het_rates(55))* y(55)
         prod(151) =rxt(285)*y(44)*y(22)
         loss(95) = ( + rxt(288) + rxt(289) + het_rates(56))* y(56)
         prod(95) =.750_r8*rxt(286)*y(55)*y(6) +rxt(65)*y(57)
         loss(74) = ( + rxt(65) + het_rates(57))* y(57)
         prod(74) =rxt(287)*y(55)*y(23)
         loss(104) = (rxt(386)* y(22) + het_rates(96))* y(96)
         prod(104) = (.870_r8*rxt(363)*y(6) +.950_r8*rxt(367)*y(8) + &
                 .750_r8*rxt(373)*y(13) +rxt(375)*y(48))*y(98)
         loss(185) = (rxt(322)* y(6) +rxt(324)* y(13) +rxt(323)* y(23) &
                  + het_rates(67))* y(67)
         prod(185) = (rxt(321)*y(63) +rxt(325)*y(69) +.150_r8*rxt(459)*y(149))*y(22) &
                  + (.060_r8*rxt(445)*y(141) +.060_r8*rxt(446)*y(142))*y(1) &
                  +.150_r8*rxt(91)*y(149)
         loss(189) = (rxt(328)* y(8) +rxt(327)* y(22) + rxt(69) + het_rates(68)) &
                 * y(68)
         prod(189) = (.250_r8*rxt(342)*y(79) +.050_r8*rxt(363)*y(98) + &
                 .250_r8*rxt(387)*y(103) +.400_r8*rxt(428)*y(108) + &
                 .170_r8*rxt(430)*y(130) +.170_r8*rxt(432)*y(131) + &
                 .510_r8*rxt(437)*y(135) +.540_r8*rxt(442)*y(137))*y(6) &
                  + (.250_r8*rxt(344)*y(79) +.050_r8*rxt(367)*y(98) + &
                 .250_r8*rxt(388)*y(103))*y(8) + (.500_r8*rxt(324)*y(67) + &
                 .240_r8*rxt(346)*y(79) +.100_r8*rxt(390)*y(103))*y(13) &
                  + (.500_r8*rxt(335)*y(77) +.880_r8*rxt(341)*y(78))*y(1) &
                  + (rxt(326)*y(66) +rxt(329)*y(83))*y(22) &
                  + (.070_r8*rxt(429)*y(130) +.070_r8*rxt(431)*y(131))*y(23) &
                  + (.250_r8*rxt(347)*y(79) +.250_r8*rxt(391)*y(103))*y(48) &
                  +.180_r8*rxt(83)*y(95) +.400_r8*rxt(87)*y(109) +rxt(97)*y(123) &
                  +.510_r8*rxt(103)*y(136) +.540_r8*rxt(104)*y(138)
         loss(187) = (rxt(378)* y(6) +rxt(379)* y(8) +rxt(382)* y(13) +rxt(380)* y(23) &
                  +rxt(381)* y(48) + het_rates(101))* y(101)
         prod(187) =rxt(361)*y(92)*y(8)
         loss(75) = ( + rxt(71) + het_rates(102))* y(102)
         prod(75) =.100_r8*rxt(456)*y(146)*y(6) +rxt(358)*y(84)*y(22)
         loss(190) = (rxt(387)* y(6) +rxt(388)* y(8) +rxt(390)* y(13) +rxt(389)* y(23) &
                  +rxt(391)* y(48) + het_rates(103))* y(103)
         prod(190) = (.400_r8*rxt(370)*y(105) +rxt(371)*y(100) +rxt(377)*y(99) + &
                 rxt(386)*y(96) +rxt(392)*y(104))*y(22)
         loss(96) = ((rxt(392) +rxt(393))* y(22) + rxt(70) + het_rates(104))* y(104)
         prod(96) =rxt(389)*y(103)*y(23)
         loss(152) = (rxt(370)* y(22) + rxt(79) + het_rates(105))* y(105)
         prod(152) = (rxt(368)*y(97) +rxt(369)*y(98))*y(23) +rxt(73)*y(87)
         loss(97) = (rxt(283)* y(22) +rxt(280)* y(27) + het_rates(41))* y(41)
         prod(97) = 0._r8
         loss(160) = (rxt(276)* y(22) + het_rates(42))* y(42)
         prod(160) = (.370_r8*rxt(290)*y(44) +.120_r8*rxt(311)*y(59) + &
                 .120_r8*rxt(335)*y(77) +.330_r8*rxt(341)*y(78) + &
                 .110_r8*rxt(360)*y(92) +.050_r8*rxt(445)*y(141) + &
                 .050_r8*rxt(446)*y(142))*y(1) + (rxt(278)*y(6) +rxt(279)*y(23))*y(43) &
                  +.350_r8*rxt(283)*y(41)*y(22)
         loss(115) = (rxt(278)* y(6) +rxt(279)* y(23) + rxt(277) + het_rates(43)) &
                 * y(43)
         prod(115) =rxt(269)*y(23)*y(16)
         loss(71) = (rxt(487)* y(22) + het_rates(170))* y(170)
         prod(71) = (rxt(488)*y(22) +.500_r8*rxt(489)*y(22) +rxt(490)*y(8))*y(171)
         loss(90) = (rxt(490)* y(8) + (rxt(488) +rxt(489))* y(22) + het_rates(171)) &
                 * y(171)
         prod(90) = 0._r8
         loss(1) = ( + het_rates(172))* y(172)
         prod(1) =rxt(487)*y(170)*y(22)
         loss(2) = ( + het_rates(173))* y(173)
         prod(2) = (.2381005_r8*rxt(470)*y(140) +.5931005_r8*rxt(472)*y(148) + &
                 .0023005_r8*rxt(473)*y(110) +.1364005_r8*rxt(474)*y(106) + &
                 .1677005_r8*rxt(475)*y(133))*y(22)
         loss(3) = ( + het_rates(174))* y(174)
         prod(3) = (.1308005_r8*rxt(470)*y(140) +.1534005_r8*rxt(472)*y(148) + &
                 .0008005_r8*rxt(473)*y(110) +.0101005_r8*rxt(474)*y(106) + &
                 .0174005_r8*rxt(475)*y(133))*y(22)
         loss(4) = ( + het_rates(175))* y(175)
         prod(4) = (.0348005_r8*rxt(470)*y(140) +.0459005_r8*rxt(472)*y(148) + &
                 .0843005_r8*rxt(473)*y(110) +.0763005_r8*rxt(474)*y(106) + &
                 .086_r8*rxt(475)*y(133))*y(22)
         loss(5) = ( + het_rates(176))* y(176)
         prod(5) = (.0076005_r8*rxt(470)*y(140) +.0085005_r8*rxt(472)*y(148) + &
                 .0443005_r8*rxt(473)*y(110) +.2157005_r8*rxt(474)*y(106) + &
                 .0512005_r8*rxt(475)*y(133))*y(22)
         loss(6) = ( + het_rates(177))* y(177)
         prod(6) = (.0113005_r8*rxt(470)*y(140) +.0128005_r8*rxt(472)*y(148) + &
                 .1621005_r8*rxt(473)*y(110) +.0232005_r8*rxt(474)*y(106) + &
                 .1598005_r8*rxt(475)*y(133))*y(22)
         loss(9) = ( + het_rates(178))* y(178)
         prod(9) = (.2381005_r8*rxt(469)*y(139) +.5931005_r8*rxt(471)*y(147))*y(22)
         loss(10) = ( + het_rates(179))* y(179)
         prod(10) = (.1308005_r8*rxt(469)*y(139) +.1534005_r8*rxt(471)*y(147))*y(22)
         loss(11) = ( + het_rates(180))* y(180)
         prod(11) = (.0348005_r8*rxt(469)*y(139) +.0459005_r8*rxt(471)*y(147))*y(22)
         loss(12) = ( + het_rates(181))* y(181)
         prod(12) = (.0076005_r8*rxt(469)*y(139) +.0085005_r8*rxt(471)*y(147))*y(22)
         loss(13) = ( + het_rates(182))* y(182)
         prod(13) = (.0113005_r8*rxt(469)*y(139) +.0128005_r8*rxt(471)*y(147))*y(22)
         loss(16) = ( + het_rates(183))* y(183)
         prod(16) = (.0031005_r8*rxt(466)*y(92) +.0508005_r8*rxt(467)*y(141) + &
                 .2202005_r8*rxt(468)*y(142))*y(22) +rxt(486)*y(53)
         loss(17) = ( + het_rates(184))* y(184)
         prod(17) = (.0035005_r8*rxt(466)*y(92) +.1149005_r8*rxt(467)*y(141) + &
                 .2067005_r8*rxt(468)*y(142))*y(22)
         loss(18) = ( + het_rates(185))* y(185)
         prod(18) = (.0003005_r8*rxt(466)*y(92) +.0348005_r8*rxt(467)*y(141) + &
                 .0653005_r8*rxt(468)*y(142))*y(22) + (.0348005_r8*rxt(477)*y(141) + &
                 .0653005_r8*rxt(478)*y(142))*y(1)
         loss(19) = ( + het_rates(186))* y(186)
         prod(19) = (.0271005_r8*rxt(476)*y(92) +.0554005_r8*rxt(477)*y(141) + &
                 .1284005_r8*rxt(478)*y(142))*y(1) + (.0590245_r8*rxt(479)*y(92) + &
                 .1749305_r8*rxt(480)*y(141) +.1749305_r8*rxt(481)*y(142))*y(8) &
                  + (.0271005_r8*rxt(466)*y(92) +.0554005_r8*rxt(467)*y(141) + &
                 .1284005_r8*rxt(468)*y(142))*y(22)
         loss(20) = ( + het_rates(187))* y(187)
         prod(20) = (.0250245_r8*rxt(479)*y(92) +.5901905_r8*rxt(480)*y(141) + &
                 .5901905_r8*rxt(481)*y(142))*y(8) + (.0474005_r8*rxt(466)*y(92) + &
                 .1278005_r8*rxt(467)*y(141) +.114_r8*rxt(468)*y(142))*y(22) &
                  + (.1278005_r8*rxt(477)*y(141) +.114_r8*rxt(478)*y(142))*y(1)
         loss(21) = ( + het_rates(218))* y(218)
         prod(21) = 0._r8
         loss(22) = ( + het_rates(219))* y(219)
         prod(22) = 0._r8
         loss(23) = ( + het_rates(220))* y(220)
         prod(23) = 0._r8
         loss(24) = ( + het_rates(221))* y(221)
         prod(24) = 0._r8
         loss(25) = ( + het_rates(222))* y(222)
         prod(25) = 0._r8
         loss(26) = ( + het_rates(223))* y(223)
         prod(26) = 0._r8
         loss(27) = ( + het_rates(224))* y(224)
         prod(27) = 0._r8
         loss(28) = ( + het_rates(225))* y(225)
         prod(28) = 0._r8
         loss(29) = ( + rxt(115) + het_rates(188))* y(188)
         prod(29) = 0._r8
         loss(30) = ( + rxt(116) + het_rates(189))* y(189)
         prod(30) = 0._r8
         loss(31) = ( + rxt(117) + het_rates(190))* y(190)
         prod(31) = 0._r8
         loss(32) = ( + rxt(118) + het_rates(191))* y(191)
         prod(32) = 0._r8
         loss(33) = ( + rxt(119) + het_rates(192))* y(192)
         prod(33) = 0._r8
         loss(34) = ( + rxt(105) + het_rates(193))* y(193)
         prod(34) = 0._r8
         loss(35) = ( + rxt(106) + het_rates(194))* y(194)
         prod(35) = 0._r8
         loss(36) = ( + rxt(107) + het_rates(195))* y(195)
         prod(36) = 0._r8
         loss(37) = ( + rxt(108) + het_rates(196))* y(196)
         prod(37) = 0._r8
         loss(38) = ( + rxt(109) + het_rates(197))* y(197)
         prod(38) = 0._r8
         loss(39) = ( + rxt(125) + het_rates(198))* y(198)
         prod(39) = 0._r8
         loss(40) = ( + rxt(126) + het_rates(199))* y(199)
         prod(40) = 0._r8
         loss(41) = ( + rxt(127) + het_rates(200))* y(200)
         prod(41) = 0._r8
         loss(42) = ( + rxt(128) + het_rates(201))* y(201)
         prod(42) = 0._r8
         loss(43) = ( + rxt(129) + het_rates(202))* y(202)
         prod(43) = 0._r8
         loss(44) = ( + rxt(120) + het_rates(203))* y(203)
         prod(44) = 0._r8
         loss(45) = ( + rxt(121) + het_rates(204))* y(204)
         prod(45) = 0._r8
         loss(46) = ( + rxt(122) + het_rates(205))* y(205)
         prod(46) = 0._r8
         loss(47) = ( + rxt(123) + het_rates(206))* y(206)
         prod(47) = 0._r8
         loss(48) = ( + rxt(124) + het_rates(207))* y(207)
         prod(48) = 0._r8
         loss(49) = ( + rxt(110) + het_rates(208))* y(208)
         prod(49) = 0._r8
         loss(50) = ( + rxt(111) + het_rates(209))* y(209)
         prod(50) = 0._r8
         loss(51) = ( + rxt(112) + het_rates(210))* y(210)
         prod(51) = 0._r8
         loss(52) = ( + rxt(113) + het_rates(211))* y(211)
         prod(52) = 0._r8
         loss(53) = ( + rxt(114) + het_rates(212))* y(212)
         prod(53) = 0._r8
         loss(54) = ( + rxt(130) + het_rates(213))* y(213)
         prod(54) = 0._r8
         loss(55) = ( + rxt(131) + het_rates(214))* y(214)
         prod(55) = 0._r8
         loss(56) = ( + rxt(132) + het_rates(215))* y(215)
         prod(56) = 0._r8
         loss(57) = ( + rxt(133) + het_rates(216))* y(216)
         prod(57) = 0._r8
         loss(58) = ( + rxt(134) + het_rates(217))* y(217)
         prod(58) = 0._r8
         loss(59) = ( + het_rates(226))* y(226)
         prod(59) = 0._r8
         loss(60) = ( + het_rates(227))* y(227)
         prod(60) = 0._r8
         loss(61) = ( + het_rates(228))* y(228)
         prod(61) = 0._r8
         loss(62) = ( + het_rates(229))* y(229)
         prod(62) = 0._r8
         loss(63) = ( + het_rates(230))* y(230)
         prod(63) = 0._r8
         loss(64) = ( + het_rates(231))* y(231)
         prod(64) = 0._r8
         loss(65) = ( + het_rates(232))* y(232)
         prod(65) = 0._r8
         loss(66) = ( + het_rates(233))* y(233)
         prod(66) = 0._r8
         loss(67) = ( + het_rates(234))* y(234)
         prod(67) = 0._r8

      end subroutine imp_prod_loss

      end module mo_prod_loss
