




      module mo_nln_matrix

      use shr_kind_mod, only : r8 => shr_kind_r8

      private
      public :: nlnmat

      contains

      subroutine nlnmat01( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(832) = -(rxt(86)*y(2) + rxt(93)*y(3) + rxt(118)*y(19) + rxt(123)*y(20) &
                      + rxt(131)*y(21) + rxt(143)*y(6) + rxt(146)*y(7) + rxt(158) &
                      *y(25) + rxt(185)*y(34) + rxt(240)*y(41) + rxt(261)*y(56) &
                      + rxt(283)*y(74) + rxt(289)*y(75) + rxt(307)*y(80) + rxt(345) &
                      *y(102))
         mat(1172) = -rxt(86)*y(1)
         mat(885) = -rxt(93)*y(1)
         mat(721) = -rxt(118)*y(1)
         mat(1114) = -rxt(123)*y(1)
         mat(998) = -rxt(131)*y(1)
         mat(1266) = -rxt(143)*y(1)
         mat(866) = -rxt(146)*y(1)
         mat(1146) = -rxt(158)*y(1)
         mat(1213) = -rxt(185)*y(1)
         mat(253) = -rxt(240)*y(1)
         mat(515) = -rxt(261)*y(1)
         mat(615) = -rxt(283)*y(1)
         mat(572) = -rxt(289)*y(1)
         mat(476) = -rxt(307)*y(1)
         mat(303) = -rxt(345)*y(1)

         mat(832) = mat(832) + .100_r8*rxt(307)*y(80) + .200_r8*rxt(283)*y(74) &
                      + .200_r8*rxt(289)*y(75)
         mat(998) = mat(998) + .250_r8*rxt(251)*y(45) + .250_r8*rxt(299)*y(73)
         mat(476) = mat(476) + .100_r8*rxt(307)*y(1)
         mat(704) = .250_r8*rxt(251)*y(21)
         mat(615) = mat(615) + .200_r8*rxt(283)*y(1)
         mat(572) = mat(572) + .200_r8*rxt(289)*y(1)
         mat(678) = .250_r8*rxt(299)*y(21)

         mat(1180) = -(rxt(86)*y(1) + 4._r8*rxt(87)*y(2) + rxt(122)*y(20) + rxt(129) &
                      *y(18) + rxt(130)*y(21) + rxt(133)*y(22) + rxt(141)*y(6) &
                      + (rxt(144) + rxt(145)) * y(7) + rxt(152)*y(8) + rxt(165)*y(27) &
                      + rxt(178)*y(30) + rxt(179)*y(31) + rxt(182)*y(32) + rxt(188) &
                      *y(35) + rxt(198)*y(36) + rxt(199)*y(37) + rxt(200)*y(38) &
                      + rxt(218)*y(16) + rxt(361)*y(142))
         mat(840) = -rxt(86)*y(2)
         mat(1122) = -rxt(122)*y(2)
         mat(528) = -rxt(129)*y(2)
         mat(1006) = -rxt(130)*y(2)
         mat(314) = -rxt(133)*y(2)
         mat(1274) = -rxt(141)*y(2)
         mat(874) = -(rxt(144) + rxt(145)) * y(2)
         mat(935) = -rxt(152)*y(2)
         mat(1203) = -rxt(165)*y(2)
         mat(1027) = -rxt(178)*y(2)
         mat(443) = -rxt(179)*y(2)
         mat(461) = -rxt(182)*y(2)
         mat(781) = -rxt(188)*y(2)
         mat(417) = -rxt(198)*y(2)
         mat(400) = -rxt(199)*y(2)
         mat(266) = -rxt(200)*y(2)
         mat(802) = -rxt(218)*y(2)
         mat(94) = -rxt(361)*y(2)

         mat(80) = rxt(137)*y(6) + rxt(138)*y(7)
         mat(1274) = mat(1274) + rxt(137)*y(5)
         mat(874) = mat(874) + rxt(138)*y(5)
         mat(1122) = mat(1122) + 2.000_r8*rxt(125)*y(20)
         mat(727) = rxt(121)*y(21)
         mat(1006) = mat(1006) + rxt(121)*y(19)

         mat(887) = -(rxt(90)*y(124) + rxt(93)*y(1) + rxt(113)*y(18) + rxt(114)*y(30) &
                      + rxt(115)*y(36) + rxt(116)*y(39))
         mat(713) = -rxt(90)*y(3)
         mat(834) = -rxt(93)*y(3)
         mat(524) = -rxt(113)*y(3)
         mat(1021) = -rxt(114)*y(3)
         mat(415) = -rxt(115)*y(3)
         mat(83) = -rxt(116)*y(3)

         mat(521) = -(rxt(113)*y(3) + rxt(127)*y(20) + rxt(129)*y(2) + rxt(159)*y(25))
         mat(880) = -rxt(113)*y(18)
         mat(1096) = -rxt(127)*y(18)
         mat(1166) = -rxt(129)*y(18)
         mat(1138) = -rxt(159)*y(18)

         mat(718) = rxt(120)*y(21)
         mat(980) = rxt(120)*y(19)

         mat(529) = -((rxt(214) + rxt(215)) * y(20))
         mat(1097) = -(rxt(214) + rxt(215)) * y(17)

         mat(815) = .560_r8*rxt(261)*y(56) + .300_r8*rxt(307)*y(80) + .500_r8*rxt(240) &
                      *y(41) + .050_r8*rxt(283)*y(74) + .200_r8*rxt(289)*y(75)
         mat(1167) = rxt(218)*y(16) + rxt(361)*y(142)
         mat(1249) = .220_r8*rxt(290)*y(76) + .250_r8*rxt(325)*y(88)
         mat(1097) = mat(1097) + rxt(217)*y(16) + rxt(256)*y(50) + rxt(277)*y(65) &
                      + .350_r8*rxt(233)*y(125) + rxt(362)*y(142)
         mat(911) = rxt(216)*y(16) + .220_r8*rxt(292)*y(76) + rxt(278)*y(65) &
                      + .500_r8*rxt(326)*y(88)
         mat(738) = .110_r8*rxt(294)*y(76) + .200_r8*rxt(328)*y(88)
         mat(790) = rxt(218)*y(2) + rxt(217)*y(20) + rxt(216)*y(8) + rxt(163)*y(25) &
                      + rxt(187)*y(34)
         mat(1139) = rxt(163)*y(16)
         mat(1208) = rxt(187)*y(16)
         mat(508) = .560_r8*rxt(261)*y(1)
         mat(468) = .300_r8*rxt(307)*y(1)
         mat(690) = .220_r8*rxt(295)*y(76) + .250_r8*rxt(329)*y(88)
         mat(251) = .500_r8*rxt(240)*y(1)
         mat(379) = rxt(256)*y(20)
         mat(604) = .050_r8*rxt(283)*y(1)
         mat(563) = .200_r8*rxt(289)*y(1)
         mat(625) = .220_r8*rxt(290)*y(6) + .220_r8*rxt(292)*y(8) + .110_r8*rxt(294) &
                      *y(13) + .220_r8*rxt(295)*y(45)
         mat(576) = rxt(277)*y(20) + rxt(278)*y(8)
         mat(589) = .250_r8*rxt(325)*y(6) + .500_r8*rxt(326)*y(8) + .200_r8*rxt(328) &
                      *y(13) + .250_r8*rxt(329)*y(45)
         mat(116) = .350_r8*rxt(233)*y(20)
         mat(91) = rxt(361)*y(2) + rxt(362)*y(20)

         mat(78) = -(rxt(137)*y(6) + (rxt(138) + rxt(139) + rxt(140)) * y(7))
         mat(1225) = -rxt(137)*y(5)
         mat(845) = -(rxt(138) + rxt(139) + rxt(140)) * y(5)

         mat(1277) = -(rxt(137)*y(5) + rxt(141)*y(2) + rxt(142)*y(21) + rxt(143)*y(1) &
                      + rxt(151)*y(8) + rxt(170)*y(27) + rxt(191)*y(35) + rxt(220) &
                      *y(13) + rxt(228)*y(127) + rxt(236)*y(52) + rxt(242)*y(43) &
                      + rxt(249)*y(45) + rxt(263)*y(58) + rxt(268)*y(61) + rxt(272) &
                      *y(64) + rxt(281)*y(70) + rxt(285)*y(71) + (rxt(290) + rxt(291) &
                      ) * y(76) + rxt(297)*y(73) + rxt(309)*y(85) + rxt(315)*y(86) &
                      + rxt(322)*y(81) + rxt(325)*y(88) + rxt(333)*y(93) + rxt(340) &
                      *y(97) + rxt(343)*y(100) + rxt(347)*y(103))
         mat(81) = -rxt(137)*y(6)
         mat(1183) = -rxt(141)*y(6)
         mat(1009) = -rxt(142)*y(6)
         mat(843) = -rxt(143)*y(6)
         mat(938) = -rxt(151)*y(6)
         mat(1206) = -rxt(170)*y(6)
         mat(784) = -rxt(191)*y(6)
         mat(764) = -rxt(220)*y(6)
         mat(186) = -rxt(228)*y(6)
         mat(346) = -rxt(236)*y(6)
         mat(392) = -rxt(242)*y(6)
         mat(709) = -rxt(249)*y(6)
         mat(436) = -rxt(263)*y(6)
         mat(377) = -rxt(268)*y(6)
         mat(545) = -rxt(272)*y(6)
         mat(152) = -rxt(281)*y(6)
         mat(337) = -rxt(285)*y(6)
         mat(640) = -(rxt(290) + rxt(291)) * y(6)
         mat(683) = -rxt(297)*y(6)
         mat(666) = -rxt(309)*y(6)
         mat(411) = -rxt(315)*y(6)
         mat(361) = -rxt(322)*y(6)
         mat(602) = -rxt(325)*y(6)
         mat(292) = -rxt(333)*y(6)
         mat(168) = -rxt(340)*y(6)
         mat(222) = -rxt(343)*y(6)
         mat(503) = -rxt(347)*y(6)

         mat(1183) = mat(1183) + rxt(144)*y(7)
         mat(81) = mat(81) + 2.000_r8*rxt(139)*y(7)
         mat(877) = rxt(144)*y(2) + 2.000_r8*rxt(139)*y(5)

         mat(867) = -((rxt(138) + rxt(139) + rxt(140)) * y(5) + (rxt(144) + rxt(145) &
                      ) * y(2) + rxt(146)*y(1) + rxt(147)*y(8) + rxt(149)*y(20) &
                      + rxt(155)*y(21) + rxt(171)*y(27) + rxt(192)*y(35) + rxt(250) &
                      *y(45) + rxt(303)*y(73) + rxt(337)*y(95))
         mat(79) = -(rxt(138) + rxt(139) + rxt(140)) * y(7)
         mat(1173) = -(rxt(144) + rxt(145)) * y(7)
         mat(833) = -rxt(146)*y(7)
         mat(928) = -rxt(147)*y(7)
         mat(1115) = -rxt(149)*y(7)
         mat(999) = -rxt(155)*y(7)
         mat(1196) = -rxt(171)*y(7)
         mat(774) = -rxt(192)*y(7)
         mat(705) = -rxt(250)*y(7)
         mat(679) = -rxt(303)*y(7)
         mat(76) = -rxt(337)*y(7)

         mat(833) = mat(833) + rxt(143)*y(6)
         mat(1173) = mat(1173) + rxt(141)*y(6) + rxt(152)*y(8)
         mat(1267) = rxt(143)*y(1) + rxt(141)*y(2) + 2.000_r8*rxt(151)*y(8) + rxt(220) &
                      *y(13) + rxt(142)*y(21) + rxt(170)*y(27) + rxt(191)*y(35) &
                      + rxt(268)*y(61) + rxt(249)*y(45) + rxt(281)*y(70) &
                      + .900_r8*rxt(322)*y(81) + rxt(285)*y(71) + .900_r8*rxt(333) &
                      *y(93) + rxt(347)*y(103) + .900_r8*rxt(340)*y(97) &
                      + .900_r8*rxt(343)*y(100) + .920_r8*rxt(309)*y(85) + rxt(290) &
                      *y(76) + rxt(297)*y(73) + rxt(242)*y(43) + rxt(263)*y(58) &
                      + rxt(236)*y(52) + rxt(272)*y(64) + 1.206_r8*rxt(315)*y(86) &
                      + rxt(325)*y(88) + rxt(228)*y(127)
         mat(867) = mat(867) + .700_r8*rxt(337)*y(95)
         mat(1115) = mat(1115) + rxt(153)*y(8) + rxt(156)*y(10) + rxt(279)*y(79) &
                      + .400_r8*rxt(319)*y(87)
         mat(928) = mat(928) + rxt(152)*y(2) + 2.000_r8*rxt(151)*y(6) + rxt(153)*y(20) &
                      + rxt(154)*y(21) + rxt(310)*y(85) + rxt(292)*y(76) + rxt(298) &
                      *y(73) + rxt(346)*y(102) + 1.206_r8*rxt(316)*y(86) + rxt(320) &
                      *y(87) + rxt(326)*y(88)
         mat(193) = rxt(156)*y(20)
         mat(755) = rxt(220)*y(6)
         mat(999) = mat(999) + rxt(142)*y(6) + rxt(154)*y(8) + .206_r8*rxt(317)*y(86)
         mat(1196) = mat(1196) + rxt(170)*y(6)
         mat(774) = mat(774) + rxt(191)*y(6)
         mat(374) = rxt(268)*y(6)
         mat(705) = mat(705) + rxt(249)*y(6)
         mat(189) = rxt(279)*y(20)
         mat(150) = rxt(281)*y(6)
         mat(358) = .900_r8*rxt(322)*y(6)
         mat(334) = rxt(285)*y(6)
         mat(289) = .900_r8*rxt(333)*y(6)
         mat(76) = mat(76) + .700_r8*rxt(337)*y(7)
         mat(500) = rxt(347)*y(6)
         mat(166) = .900_r8*rxt(340)*y(6)
         mat(220) = .900_r8*rxt(343)*y(6)
         mat(662) = .920_r8*rxt(309)*y(6) + rxt(310)*y(8)
         mat(636) = rxt(290)*y(6) + rxt(292)*y(8)
         mat(679) = mat(679) + rxt(297)*y(6) + rxt(298)*y(8)
         mat(389) = rxt(242)*y(6)
         mat(304) = rxt(346)*y(8)
         mat(433) = rxt(263)*y(6)
         mat(343) = rxt(236)*y(6)
         mat(542) = rxt(272)*y(6)
         mat(407) = 1.206_r8*rxt(315)*y(6) + 1.206_r8*rxt(316)*y(8) + .206_r8*rxt(317) &
                      *y(21)
         mat(487) = .400_r8*rxt(319)*y(20) + rxt(320)*y(8)
         mat(598) = rxt(325)*y(6) + rxt(326)*y(8)
         mat(184) = rxt(228)*y(6)


      end subroutine nlnmat01

      subroutine nlnmat02( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(1120) = -(rxt(122)*y(2) + rxt(123)*y(1) + rxt(124)*y(21) + (4._r8*rxt(125) &
                      + 4._r8*rxt(126)) * y(20) + rxt(127)*y(18) + rxt(128)*y(22) &
                      + rxt(134)*y(39) + rxt(135)*y(40) + rxt(149)*y(7) + rxt(150) &
                      *y(9) + rxt(153)*y(8) + rxt(156)*y(10) + (rxt(166) + rxt(167) &
                      ) * y(27) + rxt(177)*y(30) + rxt(181)*y(31) + rxt(183)*y(32) &
                      + rxt(189)*y(35) + rxt(197)*y(36) + (rxt(214) + rxt(215) &
                      ) * y(17) + rxt(217)*y(16) + rxt(224)*y(15) + rxt(225)*y(14) &
                      + rxt(226)*y(126) + rxt(233)*y(125) + rxt(234)*y(42) + rxt(235) &
                      *y(41) + rxt(241)*y(46) + rxt(246)*y(44) + rxt(247)*y(47) &
                      + rxt(254)*y(51) + rxt(255)*y(49) + rxt(256)*y(50) + rxt(257) &
                      *y(48) + rxt(259)*y(55) + rxt(260)*y(56) + rxt(266)*y(59) &
                      + rxt(267)*y(57) + rxt(270)*y(62) + rxt(271)*y(60) + rxt(275) &
                      *y(66) + rxt(276)*y(63) + rxt(277)*y(65) + rxt(279)*y(79) &
                      + rxt(280)*y(67) + rxt(282)*y(74) + rxt(284)*y(69) + rxt(287) &
                      *y(72) + rxt(288)*y(75) + rxt(296)*y(77) + rxt(305)*y(78) &
                      + rxt(306)*y(80) + rxt(312)*y(90) + rxt(318)*y(68) + rxt(319) &
                      *y(87) + rxt(321)*y(84) + rxt(324)*y(82) + rxt(330)*y(89) &
                      + rxt(332)*y(91) + rxt(335)*y(94) + rxt(336)*y(92) + rxt(338) &
                      *y(96) + rxt(341)*y(99) + rxt(344)*y(102) + rxt(349)*y(104) &
                      + rxt(354)*y(143) + (rxt(355) + rxt(356)) * y(144) + rxt(358) &
                      *y(146) + rxt(362)*y(142))
         mat(1178) = -rxt(122)*y(20)
         mat(838) = -rxt(123)*y(20)
         mat(1004) = -rxt(124)*y(20)
         mat(526) = -rxt(127)*y(20)
         mat(312) = -rxt(128)*y(20)
         mat(85) = -rxt(134)*y(20)
         mat(47) = -rxt(135)*y(20)
         mat(872) = -rxt(149)*y(20)
         mat(423) = -rxt(150)*y(20)
         mat(933) = -rxt(153)*y(20)
         mat(196) = -rxt(156)*y(20)
         mat(1201) = -(rxt(166) + rxt(167)) * y(20)
         mat(1025) = -rxt(177)*y(20)
         mat(441) = -rxt(181)*y(20)
         mat(459) = -rxt(183)*y(20)
         mat(779) = -rxt(189)*y(20)
         mat(416) = -rxt(197)*y(20)
         mat(532) = -(rxt(214) + rxt(215)) * y(20)
         mat(800) = -rxt(217)*y(20)
         mat(247) = -rxt(224)*y(20)
         mat(202) = -rxt(225)*y(20)
         mat(259) = -rxt(226)*y(20)
         mat(118) = -rxt(233)*y(20)
         mat(123) = -rxt(234)*y(20)
         mat(255) = -rxt(235)*y(20)
         mat(318) = -rxt(241)*y(20)
         mat(145) = -rxt(246)*y(20)
         mat(556) = -rxt(247)*y(20)
         mat(235) = -rxt(254)*y(20)
         mat(450) = -rxt(255)*y(20)
         mat(381) = -rxt(256)*y(20)
         mat(104) = -rxt(257)*y(20)
         mat(214) = -rxt(259)*y(20)
         mat(519) = -rxt(260)*y(20)
         mat(174) = -rxt(266)*y(20)
         mat(54) = -rxt(267)*y(20)
         mat(243) = -rxt(270)*y(20)
         mat(367) = -rxt(271)*y(20)
         mat(180) = -rxt(275)*y(20)
         mat(562) = -rxt(276)*y(20)
         mat(584) = -rxt(277)*y(20)
         mat(190) = -rxt(279)*y(20)
         mat(35) = -rxt(280)*y(20)
         mat(619) = -rxt(282)*y(20)
         mat(207) = -rxt(284)*y(20)
         mat(135) = -rxt(287)*y(20)
         mat(574) = -rxt(288)*y(20)
         mat(140) = -rxt(296)*y(20)
         mat(275) = -rxt(305)*y(20)
         mat(480) = -rxt(306)*y(20)
         mat(283) = -rxt(312)*y(20)
         mat(32) = -rxt(318)*y(20)
         mat(490) = -rxt(319)*y(20)
         mat(155) = -rxt(321)*y(20)
         mat(329) = -rxt(324)*y(20)
         mat(112) = -rxt(330)*y(20)
         mat(59) = -rxt(332)*y(20)
         mat(161) = -rxt(335)*y(20)
         mat(62) = -rxt(336)*y(20)
         mat(38) = -rxt(338)*y(20)
         mat(41) = -rxt(341)*y(20)
         mat(307) = -rxt(344)*y(20)
         mat(229) = -rxt(349)*y(20)
         mat(68) = -rxt(354)*y(20)
         mat(100) = -(rxt(355) + rxt(356)) * y(20)
         mat(44) = -rxt(358)*y(20)
         mat(93) = -rxt(362)*y(20)

         mat(838) = mat(838) + rxt(118)*y(19) + rxt(131)*y(21) + .330_r8*rxt(261) &
                      *y(56) + .270_r8*rxt(307)*y(80) + .120_r8*rxt(240)*y(41) &
                      + .080_r8*rxt(283)*y(74) + .215_r8*rxt(289)*y(75) &
                      + .700_r8*rxt(345)*y(102)
         mat(1178) = mat(1178) + rxt(129)*y(18) + rxt(218)*y(16) + rxt(130)*y(21) &
                      + rxt(133)*y(22) + rxt(178)*y(30) + rxt(179)*y(31) + rxt(198) &
                      *y(36) + rxt(199)*y(37)
         mat(891) = rxt(113)*y(18) + rxt(116)*y(39) + 2.000_r8*rxt(90)*y(124) &
                      + rxt(114)*y(30) + rxt(115)*y(36)
         mat(526) = mat(526) + rxt(129)*y(2) + rxt(113)*y(3)
         mat(1272) = rxt(142)*y(21)
         mat(1120) = mat(1120) + .300_r8*rxt(225)*y(14) + .500_r8*rxt(270)*y(62) &
                      + .100_r8*rxt(296)*y(77) + .500_r8*rxt(246)*y(44) &
                      + .650_r8*rxt(233)*y(125)
         mat(933) = mat(933) + rxt(154)*y(21)
         mat(202) = mat(202) + .300_r8*rxt(225)*y(20)
         mat(85) = mat(85) + rxt(116)*y(3)
         mat(800) = mat(800) + rxt(218)*y(2)
         mat(725) = rxt(118)*y(1) + 2.000_r8*rxt(119)*y(21)
         mat(1004) = mat(1004) + rxt(131)*y(1) + rxt(130)*y(2) + rxt(142)*y(6) &
                      + rxt(154)*y(8) + 2.000_r8*rxt(119)*y(19) + rxt(162)*y(25) &
                      + .206_r8*rxt(317)*y(86)
         mat(312) = mat(312) + rxt(133)*y(2)
         mat(715) = 2.000_r8*rxt(90)*y(3)
         mat(1152) = rxt(162)*y(21)
         mat(1025) = mat(1025) + rxt(178)*y(2) + rxt(114)*y(3)
         mat(441) = mat(441) + rxt(179)*y(2)
         mat(416) = mat(416) + rxt(198)*y(2) + rxt(115)*y(3)
         mat(398) = rxt(199)*y(2)
         mat(519) = mat(519) + .330_r8*rxt(261)*y(1)
         mat(480) = mat(480) + .270_r8*rxt(307)*y(1)
         mat(243) = mat(243) + .500_r8*rxt(270)*y(20)
         mat(255) = mat(255) + .120_r8*rxt(240)*y(1)
         mat(619) = mat(619) + .080_r8*rxt(283)*y(1)
         mat(574) = mat(574) + .215_r8*rxt(289)*y(1)
         mat(140) = mat(140) + .100_r8*rxt(296)*y(20)
         mat(145) = mat(145) + .500_r8*rxt(246)*y(20)
         mat(307) = mat(307) + .700_r8*rxt(345)*y(1)
         mat(410) = .206_r8*rxt(317)*y(21)
         mat(118) = mat(118) + .650_r8*rxt(233)*y(20)

         mat(930) = -(rxt(147)*y(7) + rxt(151)*y(6) + rxt(152)*y(2) + rxt(153)*y(20) &
                      + rxt(154)*y(21) + rxt(216)*y(16) + rxt(248)*y(47) + rxt(262) &
                      *y(56) + rxt(278)*y(65) + rxt(292)*y(76) + rxt(298)*y(73) &
                      + rxt(308)*y(80) + rxt(310)*y(85) + rxt(316)*y(86) + rxt(320) &
                      *y(87) + rxt(326)*y(88) + rxt(346)*y(102) + rxt(357)*y(144))
         mat(869) = -rxt(147)*y(8)
         mat(1269) = -rxt(151)*y(8)
         mat(1175) = -rxt(152)*y(8)
         mat(1117) = -rxt(153)*y(8)
         mat(1001) = -rxt(154)*y(8)
         mat(797) = -rxt(216)*y(8)
         mat(554) = -rxt(248)*y(8)
         mat(517) = -rxt(262)*y(8)
         mat(582) = -rxt(278)*y(8)
         mat(637) = -rxt(292)*y(8)
         mat(680) = -rxt(298)*y(8)
         mat(478) = -rxt(308)*y(8)
         mat(663) = -rxt(310)*y(8)
         mat(408) = -rxt(316)*y(8)
         mat(488) = -rxt(320)*y(8)
         mat(599) = -rxt(326)*y(8)
         mat(305) = -rxt(346)*y(8)
         mat(98) = -rxt(357)*y(8)

         mat(835) = rxt(146)*y(7)
         mat(1175) = mat(1175) + rxt(145)*y(7) + rxt(182)*y(32) + rxt(200)*y(38)
         mat(869) = mat(869) + rxt(146)*y(1) + rxt(145)*y(2)
         mat(1117) = mat(1117) + rxt(150)*y(9) + rxt(183)*y(32) + rxt(259)*y(55) &
                      + .500_r8*rxt(305)*y(78)
         mat(422) = rxt(150)*y(20)
         mat(1149) = rxt(184)*y(32)
         mat(457) = rxt(182)*y(2) + rxt(183)*y(20) + rxt(184)*y(25)
         mat(265) = rxt(200)*y(2)
         mat(213) = rxt(259)*y(20)
         mat(273) = .500_r8*rxt(305)*y(20)

         mat(419) = -(rxt(150)*y(20))
         mat(1087) = -rxt(150)*y(9)

         mat(854) = rxt(149)*y(20)
         mat(1087) = mat(1087) + rxt(149)*y(7)
         mat(905) = rxt(216)*y(16) + rxt(248)*y(47) + rxt(278)*y(65) + rxt(357)*y(144)
         mat(788) = rxt(216)*y(8)
         mat(1013) = (rxt(387)+rxt(392)+rxt(398))*y(32)
         mat(452) = (rxt(387)+rxt(392)+rxt(398))*y(30)
         mat(546) = rxt(248)*y(8)
         mat(575) = rxt(278)*y(8)
         mat(97) = rxt(357)*y(8)

         mat(191) = -(rxt(156)*y(20))
         mat(1060) = -rxt(156)*y(10)

         mat(847) = rxt(155)*y(21)
         mat(952) = rxt(155)*y(7)


         mat(846) = rxt(147)*y(8)
         mat(899) = rxt(147)*y(7)

         mat(752) = -(rxt(169)*y(27) + rxt(220)*y(6) + rxt(221)*y(21) + (4._r8*rxt(222) &
                      + 4._r8*rxt(223)) * y(13) + rxt(244)*y(43) + rxt(252)*y(45) &
                      + rxt(265)*y(58) + rxt(274)*y(64) + rxt(294)*y(76) + rxt(300) &
                      *y(73) + rxt(313)*y(85) + rxt(328)*y(88))
         mat(1192) = -rxt(169)*y(13)
         mat(1263) = -rxt(220)*y(13)
         mat(995) = -rxt(221)*y(13)
         mat(387) = -rxt(244)*y(13)
         mat(702) = -rxt(252)*y(13)
         mat(431) = -rxt(265)*y(13)
         mat(540) = -rxt(274)*y(13)
         mat(634) = -rxt(294)*y(13)
         mat(676) = -rxt(300)*y(13)
         mat(659) = -rxt(313)*y(13)
         mat(596) = -rxt(328)*y(13)

         mat(829) = .310_r8*rxt(261)*y(56)
         mat(1263) = mat(1263) + rxt(249)*y(45)
         mat(1111) = .700_r8*rxt(225)*y(14) + rxt(241)*y(46)
         mat(752) = mat(752) + .900_r8*rxt(252)*y(45)
         mat(200) = .700_r8*rxt(225)*y(20)
         mat(513) = .310_r8*rxt(261)*y(1)
         mat(317) = rxt(241)*y(20)
         mat(702) = mat(702) + rxt(249)*y(6) + .900_r8*rxt(252)*y(13) &
                      + 4.000_r8*rxt(253)*y(45) + rxt(314)*y(85) + rxt(295)*y(76) &
                      + rxt(301)*y(73) + rxt(329)*y(88)
         mat(659) = mat(659) + rxt(314)*y(45)
         mat(634) = mat(634) + rxt(295)*y(45)
         mat(676) = mat(676) + rxt(301)*y(45)
         mat(596) = mat(596) + rxt(329)*y(45)


      end subroutine nlnmat02

      subroutine nlnmat03( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(197) = -(rxt(225)*y(20))
         mat(1061) = -rxt(225)*y(14)

         mat(730) = rxt(221)*y(21)
         mat(953) = rxt(221)*y(13)

         mat(82) = -(rxt(116)*y(3) + rxt(134)*y(20))
         mat(878) = -rxt(116)*y(39)
         mat(1043) = -rxt(134)*y(39)

         mat(45) = -(rxt(135)*y(20))
         mat(1037) = -rxt(135)*y(40)

         mat(793) = -(rxt(163)*y(25) + rxt(187)*y(34) + rxt(216)*y(8) + rxt(217)*y(20) &
                      + rxt(218)*y(2) + rxt(219)*y(21))
         mat(1145) = -rxt(163)*y(16)
         mat(1212) = -rxt(187)*y(16)
         mat(926) = -rxt(216)*y(16)
         mat(1113) = -rxt(217)*y(16)
         mat(1171) = -rxt(218)*y(16)
         mat(997) = -rxt(219)*y(16)

         mat(831) = .540_r8*rxt(261)*y(56) + .600_r8*rxt(307)*y(80) + rxt(240)*y(41) &
                      + .800_r8*rxt(283)*y(74) + .700_r8*rxt(289)*y(75)
         mat(1265) = rxt(220)*y(13) + rxt(268)*y(61) + .500_r8*rxt(281)*y(70) &
                      + .100_r8*rxt(322)*y(81) + .550_r8*rxt(309)*y(85) &
                      + .250_r8*rxt(290)*y(76) + rxt(297)*y(73) + .500_r8*rxt(236) &
                      *y(52) + rxt(272)*y(64) + .072_r8*rxt(315)*y(86) &
                      + .250_r8*rxt(325)*y(88)
         mat(1113) = mat(1113) + .300_r8*rxt(225)*y(14) + .500_r8*rxt(254)*y(51) &
                      + rxt(259)*y(55) + .500_r8*rxt(305)*y(78) + rxt(224)*y(15) &
                      + .800_r8*rxt(255)*y(49)
         mat(926) = mat(926) + .600_r8*rxt(310)*y(85) + .250_r8*rxt(292)*y(76) &
                      + rxt(298)*y(73) + .072_r8*rxt(316)*y(86)
         mat(753) = rxt(220)*y(6) + (4.000_r8*rxt(222)+2.000_r8*rxt(223))*y(13) &
                      + rxt(169)*y(27) + rxt(252)*y(45) + 1.200_r8*rxt(313)*y(85) &
                      + .880_r8*rxt(294)*y(76) + 2.000_r8*rxt(300)*y(73) &
                      + .700_r8*rxt(244)*y(43) + rxt(265)*y(58) + .800_r8*rxt(274) &
                      *y(64) + .800_r8*rxt(328)*y(88)
         mat(201) = .300_r8*rxt(225)*y(20)
         mat(997) = mat(997) + .206_r8*rxt(317)*y(86)
         mat(1194) = rxt(169)*y(13)
         mat(514) = .540_r8*rxt(261)*y(1)
         mat(475) = .600_r8*rxt(307)*y(1)
         mat(373) = rxt(268)*y(6)
         mat(703) = rxt(252)*y(13) + .600_r8*rxt(314)*y(85) + .250_r8*rxt(295)*y(76) &
                      + rxt(301)*y(73) + .250_r8*rxt(329)*y(88)
         mat(234) = .500_r8*rxt(254)*y(20)
         mat(211) = rxt(259)*y(20)
         mat(252) = rxt(240)*y(1)
         mat(271) = .500_r8*rxt(305)*y(20)
         mat(149) = .500_r8*rxt(281)*y(6)
         mat(357) = .100_r8*rxt(322)*y(6)
         mat(660) = .550_r8*rxt(309)*y(6) + .600_r8*rxt(310)*y(8) + 1.200_r8*rxt(313) &
                      *y(13) + .600_r8*rxt(314)*y(45)
         mat(614) = .800_r8*rxt(283)*y(1)
         mat(571) = .700_r8*rxt(289)*y(1)
         mat(635) = .250_r8*rxt(290)*y(6) + .250_r8*rxt(292)*y(8) + .880_r8*rxt(294) &
                      *y(13) + .250_r8*rxt(295)*y(45)
         mat(677) = rxt(297)*y(6) + rxt(298)*y(8) + 2.000_r8*rxt(300)*y(13) + rxt(301) &
                      *y(45) + 4.000_r8*rxt(302)*y(73)
         mat(388) = .700_r8*rxt(244)*y(13)
         mat(432) = rxt(265)*y(13)
         mat(245) = rxt(224)*y(20)
         mat(448) = .800_r8*rxt(255)*y(20)
         mat(342) = .500_r8*rxt(236)*y(6)
         mat(541) = rxt(272)*y(6) + .800_r8*rxt(274)*y(13)
         mat(406) = .072_r8*rxt(315)*y(6) + .072_r8*rxt(316)*y(8) + .206_r8*rxt(317) &
                      *y(21)
         mat(597) = .250_r8*rxt(325)*y(6) + .800_r8*rxt(328)*y(13) + .250_r8*rxt(329) &
                      *y(45)

         mat(720) = -(rxt(118)*y(1) + (rxt(119) + rxt(120) + rxt(121)) * y(21))
         mat(828) = -rxt(118)*y(19)
         mat(994) = -(rxt(119) + rxt(120) + rxt(121)) * y(19)

         mat(1169) = rxt(129)*y(18) + rxt(122)*y(20)
         mat(882) = rxt(113)*y(18)
         mat(523) = rxt(129)*y(2) + rxt(113)*y(3) + rxt(127)*y(20) + rxt(159)*y(25)
         mat(530) = rxt(214)*y(20)
         mat(1110) = rxt(122)*y(2) + rxt(127)*y(18) + rxt(214)*y(17) + rxt(217)*y(16) &
                      + rxt(362)*y(142)
         mat(792) = rxt(217)*y(20)
         mat(1143) = rxt(159)*y(18)
         mat(92) = rxt(362)*y(20)

         mat(1002) = -((rxt(119) + rxt(120) + rxt(121)) * y(19) + rxt(124)*y(20) &
                      + rxt(130)*y(2) + rxt(131)*y(1) + 4._r8*rxt(132)*y(21) + rxt(142) &
                      *y(6) + rxt(154)*y(8) + rxt(155)*y(7) + (rxt(161) + rxt(162) &
                      ) * y(25) + rxt(168)*y(27) + rxt(186)*y(34) + rxt(190)*y(35) &
                      + rxt(219)*y(16) + rxt(221)*y(13) + rxt(229)*y(127) + rxt(237) &
                      *y(52) + rxt(243)*y(43) + rxt(251)*y(45) + rxt(264)*y(58) &
                      + rxt(269)*y(61) + rxt(273)*y(64) + rxt(286)*y(71) + rxt(293) &
                      *y(76) + rxt(299)*y(73) + rxt(311)*y(85) + rxt(317)*y(86) &
                      + rxt(323)*y(81) + rxt(327)*y(88) + rxt(334)*y(93) + rxt(339) &
                      *y(97) + rxt(342)*y(100) + rxt(348)*y(103))
         mat(723) = -(rxt(119) + rxt(120) + rxt(121)) * y(21)
         mat(1118) = -rxt(124)*y(21)
         mat(1176) = -rxt(130)*y(21)
         mat(836) = -rxt(131)*y(21)
         mat(1270) = -rxt(142)*y(21)
         mat(931) = -rxt(154)*y(21)
         mat(870) = -rxt(155)*y(21)
         mat(1150) = -(rxt(161) + rxt(162)) * y(21)
         mat(1199) = -rxt(168)*y(21)
         mat(1217) = -rxt(186)*y(21)
         mat(777) = -rxt(190)*y(21)
         mat(798) = -rxt(219)*y(21)
         mat(758) = -rxt(221)*y(21)
         mat(185) = -rxt(229)*y(21)
         mat(344) = -rxt(237)*y(21)
         mat(390) = -rxt(243)*y(21)
         mat(707) = -rxt(251)*y(21)
         mat(434) = -rxt(264)*y(21)
         mat(375) = -rxt(269)*y(21)
         mat(543) = -rxt(273)*y(21)
         mat(335) = -rxt(286)*y(21)
         mat(638) = -rxt(293)*y(21)
         mat(681) = -rxt(299)*y(21)
         mat(664) = -rxt(311)*y(21)
         mat(409) = -rxt(317)*y(21)
         mat(359) = -rxt(323)*y(21)
         mat(600) = -rxt(327)*y(21)
         mat(290) = -rxt(334)*y(21)
         mat(167) = -rxt(339)*y(21)
         mat(221) = -rxt(342)*y(21)
         mat(501) = -rxt(348)*y(21)

         mat(836) = mat(836) + rxt(123)*y(20) + .190_r8*rxt(261)*y(56) &
                      + .060_r8*rxt(307)*y(80) + .120_r8*rxt(240)*y(41) &
                      + .060_r8*rxt(283)*y(74) + .275_r8*rxt(289)*y(75) + rxt(345) &
                      *y(102)
         mat(1176) = mat(1176) + rxt(218)*y(16) + rxt(133)*y(22)
         mat(531) = rxt(215)*y(20)
         mat(1270) = mat(1270) + rxt(220)*y(13) + rxt(268)*y(61) + rxt(281)*y(70) &
                      + .900_r8*rxt(322)*y(81) + .900_r8*rxt(333)*y(93) + rxt(347) &
                      *y(103) + .900_r8*rxt(340)*y(97) + .900_r8*rxt(343)*y(100) &
                      + .920_r8*rxt(309)*y(85) + .470_r8*rxt(290)*y(76) + rxt(242) &
                      *y(43) + rxt(263)*y(58) + .250_r8*rxt(236)*y(52) &
                      + .794_r8*rxt(315)*y(86) + rxt(325)*y(88) + rxt(228)*y(127)
         mat(870) = mat(870) + .700_r8*rxt(337)*y(95)
         mat(1118) = mat(1118) + rxt(123)*y(1) + rxt(215)*y(17) + rxt(153)*y(8) &
                      + rxt(134)*y(39) + rxt(135)*y(40) + rxt(128)*y(22) + rxt(166) &
                      *y(27) + rxt(189)*y(35) + .500_r8*rxt(305)*y(78) &
                      + .250_r8*rxt(332)*y(91) + rxt(256)*y(50) + .200_r8*rxt(296) &
                      *y(77) + rxt(224)*y(15) + rxt(257)*y(48) + rxt(255)*y(49) &
                      + rxt(276)*y(63) + rxt(319)*y(87) + .350_r8*rxt(233)*y(125) &
                      + rxt(226)*y(126) + .500_r8*rxt(356)*y(144)
         mat(931) = mat(931) + rxt(153)*y(20) + rxt(216)*y(16) + rxt(310)*y(85) &
                      + .470_r8*rxt(292)*y(76) + .794_r8*rxt(316)*y(86) + rxt(320) &
                      *y(87) + rxt(326)*y(88)
         mat(758) = mat(758) + rxt(220)*y(6) + 4.000_r8*rxt(222)*y(13) + rxt(169) &
                      *y(27) + .900_r8*rxt(252)*y(45) + rxt(313)*y(85) &
                      + .730_r8*rxt(294)*y(76) + rxt(300)*y(73) + rxt(244)*y(43) &
                      + rxt(265)*y(58) + .300_r8*rxt(274)*y(64) + .800_r8*rxt(328) &
                      *y(88)
         mat(84) = rxt(134)*y(20)
         mat(46) = rxt(135)*y(20)
         mat(798) = mat(798) + rxt(218)*y(2) + rxt(216)*y(8) + rxt(163)*y(25) &
                      + rxt(187)*y(34)
         mat(310) = rxt(133)*y(2) + rxt(128)*y(20) + rxt(160)*y(25)
         mat(1150) = mat(1150) + rxt(163)*y(16) + rxt(160)*y(22)
         mat(1199) = mat(1199) + rxt(166)*y(20) + rxt(169)*y(13)
         mat(1217) = mat(1217) + rxt(187)*y(16)
         mat(777) = mat(777) + rxt(189)*y(20)
         mat(518) = .190_r8*rxt(261)*y(1)
         mat(479) = .060_r8*rxt(307)*y(1)
         mat(375) = mat(375) + rxt(268)*y(6)
         mat(707) = mat(707) + .900_r8*rxt(252)*y(13) + rxt(314)*y(85) &
                      + .470_r8*rxt(295)*y(76) + rxt(329)*y(88)
         mat(254) = .120_r8*rxt(240)*y(1)
         mat(274) = .500_r8*rxt(305)*y(20)
         mat(151) = rxt(281)*y(6)
         mat(359) = mat(359) + .900_r8*rxt(322)*y(6)
         mat(58) = .250_r8*rxt(332)*y(20)
         mat(290) = mat(290) + .900_r8*rxt(333)*y(6)
         mat(77) = .700_r8*rxt(337)*y(7)
         mat(501) = mat(501) + rxt(347)*y(6)
         mat(380) = rxt(256)*y(20)
         mat(167) = mat(167) + .900_r8*rxt(340)*y(6)
         mat(221) = mat(221) + .900_r8*rxt(343)*y(6)
         mat(664) = mat(664) + .920_r8*rxt(309)*y(6) + rxt(310)*y(8) + rxt(313)*y(13) &
                      + rxt(314)*y(45)
         mat(618) = .060_r8*rxt(283)*y(1)
         mat(573) = .275_r8*rxt(289)*y(1)
         mat(638) = mat(638) + .470_r8*rxt(290)*y(6) + .470_r8*rxt(292)*y(8) &
                      + .730_r8*rxt(294)*y(13) + .470_r8*rxt(295)*y(45)
         mat(139) = .200_r8*rxt(296)*y(20)
         mat(681) = mat(681) + rxt(300)*y(13)
         mat(390) = mat(390) + rxt(242)*y(6) + rxt(244)*y(13) + 2.400_r8*rxt(245) &
                      *y(43)
         mat(306) = rxt(345)*y(1)
         mat(434) = mat(434) + rxt(263)*y(6) + rxt(265)*y(13)
         mat(246) = rxt(224)*y(20)
         mat(103) = rxt(257)*y(20)
         mat(449) = rxt(255)*y(20)
         mat(561) = rxt(276)*y(20)
         mat(344) = mat(344) + .250_r8*rxt(236)*y(6)
         mat(543) = mat(543) + .300_r8*rxt(274)*y(13)
         mat(409) = mat(409) + .794_r8*rxt(315)*y(6) + .794_r8*rxt(316)*y(8)
         mat(489) = rxt(319)*y(20) + rxt(320)*y(8)
         mat(600) = mat(600) + rxt(325)*y(6) + rxt(326)*y(8) + .800_r8*rxt(328)*y(13) &
                      + rxt(329)*y(45)
         mat(117) = .350_r8*rxt(233)*y(20)
         mat(258) = rxt(226)*y(20)
         mat(185) = mat(185) + rxt(228)*y(6)
         mat(99) = .500_r8*rxt(356)*y(20)

         mat(308) = -(rxt(128)*y(20) + rxt(133)*y(2) + rxt(160)*y(25))
         mat(1076) = -rxt(128)*y(22)
         mat(1160) = -rxt(133)*y(22)
         mat(1131) = -rxt(160)*y(22)

         mat(1076) = mat(1076) + 2.000_r8*rxt(126)*y(20)
         mat(962) = 2.000_r8*rxt(132)*y(21)


      end subroutine nlnmat03

      subroutine nlnmat04( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(711) = -(rxt(90)*y(3))
         mat(881) = -rxt(90)*y(124)

         mat(522) = rxt(127)*y(20)
         mat(1109) = rxt(127)*y(18) + 2.000_r8*rxt(125)*y(20) + rxt(150)*y(9) &
                      + rxt(156)*y(10) + rxt(225)*y(14) + rxt(217)*y(16) + rxt(124) &
                      *y(21) + rxt(128)*y(22) + rxt(177)*y(30) + rxt(181)*y(31) &
                      + rxt(197)*y(36) + rxt(247)*y(47) + rxt(241)*y(46) + rxt(270) &
                      *y(62) + rxt(254)*y(51) + rxt(234)*y(42) + .500_r8*rxt(288) &
                      *y(75) + rxt(267)*y(57) + rxt(266)*y(59) + rxt(271)*y(60) &
                      + rxt(275)*y(66) + rxt(277)*y(65) + (rxt(330)+rxt(331))*y(89) &
                      + rxt(226)*y(126) + rxt(358)*y(146)
         mat(420) = rxt(150)*y(20)
         mat(192) = rxt(156)*y(20)
         mat(198) = rxt(225)*y(20)
         mat(791) = rxt(217)*y(20)
         mat(719) = rxt(121)*y(21)
         mat(993) = rxt(124)*y(20) + rxt(121)*y(19)
         mat(309) = rxt(128)*y(20)
         mat(1016) = rxt(177)*y(20) + (rxt(388)+rxt(393)+rxt(399))*y(31) + (rxt(389) &
                       +rxt(400))*y(37)
         mat(439) = rxt(181)*y(20) + (rxt(388)+rxt(393)+rxt(399))*y(30)
         mat(413) = rxt(197)*y(20)
         mat(395) = (rxt(389)+rxt(400))*y(30)
         mat(550) = rxt(247)*y(20)
         mat(316) = rxt(241)*y(20)
         mat(240) = rxt(270)*y(20)
         mat(232) = rxt(254)*y(20)
         mat(121) = rxt(234)*y(20)
         mat(569) = .500_r8*rxt(288)*y(20)
         mat(53) = rxt(267)*y(20)
         mat(172) = rxt(266)*y(20)
         mat(365) = rxt(271)*y(20)
         mat(178) = rxt(275)*y(20)
         mat(579) = rxt(277)*y(20)
         mat(111) = (rxt(330)+rxt(331))*y(20)
         mat(257) = rxt(226)*y(20)
         mat(43) = rxt(358)*y(20)

         mat(1153) = -(rxt(158)*y(1) + rxt(159)*y(18) + rxt(160)*y(22) + (rxt(161) &
                      + rxt(162)) * y(21) + rxt(163)*y(16) + rxt(180)*y(31) + rxt(184) &
                      *y(32) + rxt(232)*y(42))
         mat(839) = -rxt(158)*y(25)
         mat(527) = -rxt(159)*y(25)
         mat(313) = -rxt(160)*y(25)
         mat(1005) = -(rxt(161) + rxt(162)) * y(25)
         mat(801) = -rxt(163)*y(25)
         mat(442) = -rxt(180)*y(25)
         mat(460) = -rxt(184)*y(25)
         mat(124) = -rxt(232)*y(25)

         mat(1179) = rxt(165)*y(27) + rxt(178)*y(30)
         mat(892) = rxt(114)*y(30)
         mat(1273) = rxt(170)*y(27)
         mat(1121) = rxt(166)*y(27) + rxt(177)*y(30)
         mat(761) = rxt(169)*y(27)
         mat(1202) = rxt(165)*y(2) + rxt(170)*y(6) + rxt(166)*y(20) + rxt(169)*y(13) + ( &
                      + 4.000_r8*rxt(172)+2.000_r8*rxt(174))*y(27) + rxt(194)*y(35)
         mat(1026) = rxt(178)*y(2) + rxt(114)*y(3) + rxt(177)*y(20)
         mat(780) = rxt(194)*y(27)


         mat(1126) = rxt(184)*y(32)
         mat(1186) = 2.000_r8*rxt(173)*y(27)
         mat(1010) = (rxt(388)+rxt(393)+rxt(399))*y(31) + (rxt(387)+rxt(392)+rxt(398)) &
                      *y(32)
         mat(437) = (rxt(388)+rxt(393)+rxt(399))*y(30)
         mat(451) = rxt(184)*y(25) + (rxt(387)+rxt(392)+rxt(398))*y(30)

         mat(1204) = -(rxt(165)*y(2) + (rxt(166) + rxt(167)) * y(20) + rxt(168)*y(21) &
                      + rxt(169)*y(13) + rxt(170)*y(6) + rxt(171)*y(7) + (4._r8*rxt(172) &
                      + 4._r8*rxt(173) + 4._r8*rxt(174) + 4._r8*rxt(175)) * y(27) &
                      + (rxt(193) + rxt(194) + rxt(195)) * y(35))
         mat(1181) = -rxt(165)*y(27)
         mat(1123) = -(rxt(166) + rxt(167)) * y(27)
         mat(1007) = -rxt(168)*y(27)
         mat(763) = -rxt(169)*y(27)
         mat(1275) = -rxt(170)*y(27)
         mat(875) = -rxt(171)*y(27)
         mat(782) = -(rxt(193) + rxt(194) + rxt(195)) * y(27)

         mat(841) = rxt(158)*y(25)
         mat(1181) = mat(1181) + rxt(179)*y(31) + rxt(182)*y(32)
         mat(1123) = mat(1123) + rxt(181)*y(31)
         mat(1007) = mat(1007) + rxt(162)*y(25)
         mat(1155) = rxt(158)*y(1) + rxt(162)*y(21) + rxt(180)*y(31)
         mat(444) = rxt(179)*y(2) + rxt(181)*y(20) + rxt(180)*y(25)
         mat(462) = rxt(182)*y(2)


         mat(1185) = 2.000_r8*rxt(174)*y(27) + rxt(193)*y(35)
         mat(765) = rxt(193)*y(27)


         mat(1184) = 2.000_r8*rxt(175)*y(27)

         mat(1024) = -(rxt(114)*y(3) + rxt(177)*y(20) + rxt(178)*y(2) + (rxt(387) &
                      + rxt(392) + rxt(398)) * y(32) + (rxt(388) + rxt(393) + rxt(399) &
                      ) * y(31) + (rxt(389) + rxt(400)) * y(37))
         mat(890) = -rxt(114)*y(30)
         mat(1119) = -rxt(177)*y(30)
         mat(1177) = -rxt(178)*y(30)
         mat(458) = -(rxt(387) + rxt(392) + rxt(398)) * y(30)
         mat(440) = -(rxt(388) + rxt(393) + rxt(399)) * y(30)
         mat(397) = -(rxt(389) + rxt(400)) * y(30)

         mat(525) = rxt(159)*y(25)
         mat(1119) = mat(1119) + rxt(167)*y(27)
         mat(799) = rxt(163)*y(25)
         mat(1003) = rxt(161)*y(25)
         mat(311) = rxt(160)*y(25)
         mat(1151) = rxt(159)*y(18) + rxt(163)*y(16) + rxt(161)*y(21) + rxt(160)*y(22) &
                      + rxt(180)*y(31) + rxt(232)*y(42)
         mat(1200) = rxt(167)*y(20)
         mat(440) = mat(440) + rxt(180)*y(25)
         mat(122) = rxt(232)*y(25)

         mat(438) = -(rxt(179)*y(2) + rxt(180)*y(25) + rxt(181)*y(20) + (rxt(388) &
                      + rxt(393) + rxt(399)) * y(30))
         mat(1164) = -rxt(179)*y(31)
         mat(1135) = -rxt(180)*y(31)
         mat(1089) = -rxt(181)*y(31)
         mat(1014) = -(rxt(388) + rxt(393) + rxt(399)) * y(31)

         mat(1089) = mat(1089) + rxt(183)*y(32)
         mat(976) = rxt(168)*y(27)
         mat(1188) = rxt(168)*y(21)
         mat(453) = rxt(183)*y(20)

         mat(454) = -(rxt(182)*y(2) + rxt(183)*y(20) + rxt(184)*y(25) + (rxt(387) &
                      + rxt(392) + rxt(398)) * y(30))
         mat(1165) = -rxt(182)*y(32)
         mat(1091) = -rxt(183)*y(32)
         mat(1137) = -rxt(184)*y(32)
         mat(1015) = -(rxt(387) + rxt(392) + rxt(398)) * y(32)

         mat(855) = rxt(171)*y(27)
         mat(1189) = rxt(171)*y(7)


         mat(1187) = rxt(195)*y(35)
         mat(1011) = (rxt(389)+rxt(400))*y(37)
         mat(766) = rxt(195)*y(27)
         mat(393) = (rxt(389)+rxt(400))*y(30)

         mat(1223) = -(rxt(185)*y(1) + rxt(186)*y(21) + rxt(187)*y(16))
         mat(842) = -rxt(185)*y(34)
         mat(1008) = -rxt(186)*y(34)
         mat(803) = -rxt(187)*y(34)

         mat(1182) = rxt(188)*y(35) + rxt(198)*y(36)
         mat(895) = rxt(115)*y(36)
         mat(1276) = rxt(191)*y(35)
         mat(1124) = rxt(189)*y(35) + rxt(197)*y(36)
         mat(1205) = (rxt(193)+rxt(194))*y(35)
         mat(783) = rxt(188)*y(2) + rxt(191)*y(6) + rxt(189)*y(20) + (rxt(193) &
                       +rxt(194))*y(27) + 4.000_r8*rxt(196)*y(35)
         mat(418) = rxt(198)*y(2) + rxt(115)*y(3) + rxt(197)*y(20)

         mat(772) = -(rxt(188)*y(2) + rxt(189)*y(20) + rxt(190)*y(21) + rxt(191)*y(6) &
                      + rxt(192)*y(7) + (rxt(193) + rxt(194) + rxt(195)) * y(27) &
                      + 4._r8*rxt(196)*y(35))
         mat(1170) = -rxt(188)*y(35)
         mat(1112) = -rxt(189)*y(35)
         mat(996) = -rxt(190)*y(35)
         mat(1264) = -rxt(191)*y(35)
         mat(864) = -rxt(192)*y(35)
         mat(1193) = -(rxt(193) + rxt(194) + rxt(195)) * y(35)

         mat(830) = rxt(185)*y(34)
         mat(1170) = mat(1170) + rxt(199)*y(37) + rxt(200)*y(38)
         mat(1211) = rxt(185)*y(1)
         mat(396) = rxt(199)*y(2)
         mat(263) = rxt(200)*y(2)

         mat(412) = -(rxt(115)*y(3) + rxt(197)*y(20) + rxt(198)*y(2))
         mat(879) = -rxt(115)*y(36)
         mat(1086) = -rxt(197)*y(36)
         mat(1162) = -rxt(198)*y(36)

         mat(787) = rxt(187)*y(34)
         mat(974) = rxt(186)*y(34)
         mat(1207) = rxt(187)*y(16) + rxt(186)*y(21)

         mat(394) = -(rxt(199)*y(2) + (rxt(389) + rxt(400)) * y(30))
         mat(1161) = -rxt(199)*y(37)
         mat(1012) = -(rxt(389) + rxt(400)) * y(37)

         mat(972) = rxt(190)*y(35)
         mat(768) = rxt(190)*y(21)

         mat(260) = -(rxt(200)*y(2))
         mat(1159) = -rxt(200)*y(38)

         mat(849) = rxt(192)*y(35)
         mat(767) = rxt(192)*y(7)

         mat(507) = -(rxt(260)*y(20) + rxt(261)*y(1) + rxt(262)*y(8))
         mat(1095) = -rxt(260)*y(56)
         mat(814) = -rxt(261)*y(56)
         mat(910) = -rxt(262)*y(56)

         mat(814) = mat(814) + .070_r8*rxt(307)*y(80)
         mat(467) = .070_r8*rxt(307)*y(1)

         mat(465) = -(rxt(306)*y(20) + rxt(307)*y(1) + rxt(308)*y(8))
         mat(1092) = -rxt(306)*y(80)
         mat(811) = -rxt(307)*y(80)
         mat(907) = -rxt(308)*y(80)

         mat(369) = -(rxt(268)*y(6) + rxt(269)*y(21))
         mat(1241) = -rxt(268)*y(61)
         mat(969) = -rxt(269)*y(61)

         mat(1083) = rxt(260)*y(56) + .500_r8*rxt(270)*y(62)
         mat(506) = rxt(260)*y(20)
         mat(237) = .500_r8*rxt(270)*y(20)

         mat(548) = -(rxt(247)*y(20) + rxt(248)*y(8))
         mat(1099) = -rxt(247)*y(47)
         mat(913) = -rxt(248)*y(47)

         mat(817) = .500_r8*rxt(261)*y(56) + .040_r8*rxt(283)*y(74)
         mat(1251) = rxt(268)*y(61) + rxt(281)*y(70) + .400_r8*rxt(322)*y(81) &
                      + rxt(285)*y(71) + rxt(242)*y(43) + .270_r8*rxt(263)*y(58)
         mat(1099) = mat(1099) + .500_r8*rxt(246)*y(44) + rxt(257)*y(48)
         mat(740) = .800_r8*rxt(244)*y(43)
         mat(509) = .500_r8*rxt(261)*y(1)
         mat(370) = rxt(268)*y(6)
         mat(148) = rxt(281)*y(6)
         mat(354) = .400_r8*rxt(322)*y(6)
         mat(332) = rxt(285)*y(6)
         mat(605) = .040_r8*rxt(283)*y(1)
         mat(386) = rxt(242)*y(6) + .800_r8*rxt(244)*y(13) + 3.200_r8*rxt(245)*y(43)
         mat(143) = .500_r8*rxt(246)*y(20)
         mat(428) = .270_r8*rxt(263)*y(6)
         mat(102) = rxt(257)*y(20)


      end subroutine nlnmat04

      subroutine nlnmat05( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(315) = -(rxt(241)*y(20))
         mat(1077) = -rxt(241)*y(46)

         mat(808) = .250_r8*rxt(261)*y(56) + .200_r8*rxt(307)*y(80)
         mat(732) = .100_r8*rxt(252)*y(45)
         mat(963) = .250_r8*rxt(251)*y(45) + .250_r8*rxt(299)*y(73)
         mat(505) = .250_r8*rxt(261)*y(1)
         mat(463) = .200_r8*rxt(307)*y(1)
         mat(687) = .100_r8*rxt(252)*y(13) + .250_r8*rxt(251)*y(21)
         mat(669) = .250_r8*rxt(299)*y(21)

         mat(236) = -(rxt(270)*y(20))
         mat(1067) = -rxt(270)*y(62)

         mat(957) = rxt(269)*y(61)
         mat(368) = rxt(269)*y(21)

         mat(699) = -(rxt(249)*y(6) + rxt(250)*y(7) + rxt(251)*y(21) + rxt(252)*y(13) &
                      + 4._r8*rxt(253)*y(45) + rxt(295)*y(76) + rxt(314)*y(85) + rxt(329) &
                      *y(88))
         mat(1260) = -rxt(249)*y(45)
         mat(860) = -rxt(250)*y(45)
         mat(992) = -rxt(251)*y(45)
         mat(749) = -rxt(252)*y(45)
         mat(631) = -rxt(295)*y(45)
         mat(656) = -rxt(314)*y(45)
         mat(593) = -rxt(329)*y(45)

         mat(1260) = mat(1260) + rxt(285)*y(71) + .530_r8*rxt(290)*y(76) + rxt(297) &
                      *y(73) + rxt(272)*y(64)
         mat(1108) = rxt(247)*y(47) + .500_r8*rxt(254)*y(51) + rxt(277)*y(65)
         mat(922) = rxt(248)*y(47) + .530_r8*rxt(292)*y(76) + rxt(298)*y(73) &
                      + rxt(278)*y(65)
         mat(749) = mat(749) + .260_r8*rxt(294)*y(76) + rxt(300)*y(73) &
                      + .300_r8*rxt(274)*y(64)
         mat(549) = rxt(247)*y(20) + rxt(248)*y(8)
         mat(699) = mat(699) + .530_r8*rxt(295)*y(76)
         mat(231) = .500_r8*rxt(254)*y(20)
         mat(333) = rxt(285)*y(6)
         mat(631) = mat(631) + .530_r8*rxt(290)*y(6) + .530_r8*rxt(292)*y(8) &
                      + .260_r8*rxt(294)*y(13) + .530_r8*rxt(295)*y(45)
         mat(673) = rxt(297)*y(6) + rxt(298)*y(8) + rxt(300)*y(13) + 4.000_r8*rxt(302) &
                      *y(73)
         mat(538) = rxt(272)*y(6) + .300_r8*rxt(274)*y(13)
         mat(578) = rxt(277)*y(20) + rxt(278)*y(8)

         mat(230) = -(rxt(254)*y(20))
         mat(1066) = -rxt(254)*y(51)

         mat(956) = .750_r8*rxt(251)*y(45) + .750_r8*rxt(299)*y(73)
         mat(686) = .750_r8*rxt(251)*y(21)
         mat(667) = .750_r8*rxt(299)*y(21)

         mat(208) = -(rxt(259)*y(20))
         mat(1063) = -rxt(259)*y(55)

         mat(848) = rxt(250)*y(45)
         mat(685) = rxt(250)*y(7)

         mat(187) = -(rxt(279)*y(20))
         mat(1059) = -rxt(279)*y(79)

         mat(1231) = .100_r8*rxt(322)*y(81)
         mat(901) = rxt(262)*y(56)
         mat(504) = rxt(262)*y(8)
         mat(347) = .100_r8*rxt(322)*y(6)

         mat(119) = -(rxt(232)*y(25) + rxt(234)*y(20))
         mat(1128) = -rxt(232)*y(42)
         mat(1049) = -rxt(234)*y(42)

         mat(248) = -(rxt(231)*y(25) + rxt(235)*y(20) + rxt(240)*y(1))
         mat(1129) = -rxt(231)*y(41)
         mat(1069) = -rxt(235)*y(41)
         mat(805) = -rxt(240)*y(41)

         mat(30) = -(rxt(318)*y(20))
         mat(1032) = -rxt(318)*y(68)

         mat(268) = -(rxt(305)*y(20))
         mat(1071) = -rxt(305)*y(78)

         mat(850) = rxt(303)*y(73)
         mat(668) = rxt(303)*y(7)

         mat(33) = -(rxt(280)*y(20))
         mat(1033) = -rxt(280)*y(67)

         mat(146) = -(rxt(281)*y(6))
         mat(1227) = -rxt(281)*y(70)

         mat(1053) = rxt(280)*y(67)
         mat(34) = rxt(280)*y(20)

         mat(351) = -(rxt(322)*y(6) + rxt(323)*y(21))
         mat(1239) = -rxt(322)*y(81)
         mat(967) = -rxt(323)*y(81)

         mat(1081) = rxt(318)*y(68) + rxt(324)*y(82)
         mat(31) = rxt(318)*y(20)
         mat(322) = rxt(324)*y(20)

         mat(320) = -(rxt(324)*y(20))
         mat(1078) = -rxt(324)*y(82)

         mat(964) = rxt(323)*y(81)
         mat(349) = rxt(323)*y(21)

         mat(203) = -(rxt(284)*y(20))
         mat(1062) = -rxt(284)*y(69)

         mat(1232) = .800_r8*rxt(322)*y(81)
         mat(348) = .800_r8*rxt(322)*y(6)

         mat(331) = -(rxt(285)*y(6) + rxt(286)*y(21))
         mat(1237) = -rxt(285)*y(71)
         mat(965) = -rxt(286)*y(71)

         mat(1079) = rxt(284)*y(69) + rxt(287)*y(72)
         mat(204) = rxt(284)*y(20)
         mat(132) = rxt(287)*y(20)

         mat(131) = -(rxt(287)*y(20))
         mat(1050) = -rxt(287)*y(72)

         mat(944) = rxt(286)*y(71)
         mat(330) = rxt(286)*y(21)

         mat(55) = -(rxt(332)*y(20))
         mat(1039) = -rxt(332)*y(91)

         mat(60) = -(rxt(336)*y(20))
         mat(1040) = -rxt(336)*y(92)

         mat(1040) = mat(1040) + .250_r8*rxt(332)*y(91)
         mat(56) = .250_r8*rxt(332)*y(20)

         mat(285) = -(rxt(333)*y(6) + rxt(334)*y(21))
         mat(1235) = -rxt(333)*y(93)
         mat(960) = -rxt(334)*y(93)

         mat(1073) = .700_r8*rxt(332)*y(91) + rxt(335)*y(94)
         mat(57) = .700_r8*rxt(332)*y(20)
         mat(157) = rxt(335)*y(20)

         mat(156) = -(rxt(335)*y(20))
         mat(1055) = -rxt(335)*y(94)

         mat(947) = rxt(334)*y(93)
         mat(284) = rxt(334)*y(21)

         mat(74) = -(rxt(337)*y(7))
         mat(844) = -rxt(337)*y(95)

         mat(1042) = rxt(336)*y(92)
         mat(61) = rxt(336)*y(20)

         mat(493) = -(rxt(347)*y(6) + rxt(348)*y(21))
         mat(1248) = -rxt(347)*y(103)
         mat(979) = -rxt(348)*y(103)

         mat(1094) = rxt(349)*y(104) + rxt(344)*y(102)
         mat(909) = rxt(346)*y(102)
         mat(225) = rxt(349)*y(20)
         mat(300) = rxt(344)*y(20) + rxt(346)*y(8)

         mat(223) = -(rxt(349)*y(20))
         mat(1065) = -rxt(349)*y(104)

         mat(955) = rxt(348)*y(103)
         mat(491) = rxt(348)*y(21)


         mat(1236) = .900_r8*rxt(333)*y(93) + .900_r8*rxt(340)*y(97) &
                      + .620_r8*rxt(343)*y(100)
         mat(851) = .700_r8*rxt(337)*y(95)
         mat(286) = .900_r8*rxt(333)*y(6)
         mat(75) = .700_r8*rxt(337)*y(7)
         mat(164) = .900_r8*rxt(340)*y(6)
         mat(217) = .620_r8*rxt(343)*y(6)

         mat(378) = -(rxt(256)*y(20))
         mat(1084) = -rxt(256)*y(50)

         mat(1242) = .450_r8*rxt(333)*y(93) + .900_r8*rxt(340)*y(97) &
                      + .340_r8*rxt(343)*y(100) + .020_r8*rxt(309)*y(85) &
                      + .250_r8*rxt(325)*y(88)
         mat(1084) = mat(1084) + .200_r8*rxt(255)*y(49) + .650_r8*rxt(233)*y(125)
         mat(903) = .250_r8*rxt(326)*y(88)
         mat(734) = .100_r8*rxt(328)*y(88)
         mat(688) = .250_r8*rxt(329)*y(88)
         mat(287) = .450_r8*rxt(333)*y(6)
         mat(165) = .900_r8*rxt(340)*y(6)
         mat(218) = .340_r8*rxt(343)*y(6)
         mat(644) = .020_r8*rxt(309)*y(6)
         mat(445) = .200_r8*rxt(255)*y(20)
         mat(587) = .250_r8*rxt(325)*y(6) + .250_r8*rxt(326)*y(8) + .100_r8*rxt(328) &
                      *y(13) + .250_r8*rxt(329)*y(45)
         mat(115) = .650_r8*rxt(233)*y(20)

         mat(36) = -(rxt(338)*y(20))
         mat(1034) = -rxt(338)*y(96)

         mat(163) = -(rxt(339)*y(21) + rxt(340)*y(6))
         mat(948) = -rxt(339)*y(97)
         mat(1229) = -rxt(340)*y(97)

         mat(1056) = rxt(338)*y(96)
         mat(37) = rxt(338)*y(20)


         mat(939) = rxt(339)*y(97)
         mat(162) = rxt(339)*y(21)

         mat(39) = -(rxt(341)*y(20))
         mat(1035) = -rxt(341)*y(99)

         mat(216) = -(rxt(342)*y(21) + rxt(343)*y(6))
         mat(954) = -rxt(342)*y(100)
         mat(1233) = -rxt(343)*y(100)

         mat(1064) = rxt(341)*y(99)
         mat(40) = rxt(341)*y(20)


         mat(940) = rxt(342)*y(100)
         mat(215) = rxt(342)*y(21)

         mat(654) = -(rxt(309)*y(6) + rxt(310)*y(8) + rxt(311)*y(21) + rxt(313)*y(13) &
                      + rxt(314)*y(45))
         mat(1258) = -rxt(309)*y(85)
         mat(920) = -rxt(310)*y(85)
         mat(990) = -rxt(311)*y(85)
         mat(747) = -rxt(313)*y(85)
         mat(697) = -rxt(314)*y(85)

         mat(1106) = rxt(306)*y(80) + .200_r8*rxt(312)*y(90)
         mat(471) = rxt(306)*y(20)
         mat(280) = .200_r8*rxt(312)*y(20)

         mat(608) = -(rxt(282)*y(20) + rxt(283)*y(1))
         mat(1104) = -rxt(282)*y(74)
         mat(822) = -rxt(283)*y(74)

         mat(822) = mat(822) + .200_r8*rxt(307)*y(80) + rxt(345)*y(102)
         mat(1256) = rxt(347)*y(103) + .320_r8*rxt(309)*y(85) + .039_r8*rxt(315)*y(86)
         mat(918) = .350_r8*rxt(310)*y(85) + .039_r8*rxt(316)*y(86)
         mat(745) = .260_r8*rxt(313)*y(85)
         mat(988) = .039_r8*rxt(317)*y(86)
         mat(470) = .200_r8*rxt(307)*y(1)
         mat(695) = .350_r8*rxt(314)*y(85)
         mat(496) = rxt(347)*y(6)
         mat(652) = .320_r8*rxt(309)*y(6) + .350_r8*rxt(310)*y(8) + .260_r8*rxt(313) &
                      *y(13) + .350_r8*rxt(314)*y(45)
         mat(302) = rxt(345)*y(1)
         mat(405) = .039_r8*rxt(315)*y(6) + .039_r8*rxt(316)*y(8) + .039_r8*rxt(317) &
                      *y(21)

         mat(564) = -(rxt(288)*y(20) + rxt(289)*y(1))
         mat(1101) = -rxt(288)*y(75)
         mat(819) = -rxt(289)*y(75)

         mat(819) = mat(819) + .400_r8*rxt(307)*y(80) + rxt(345)*y(102)
         mat(1253) = rxt(347)*y(103) + .230_r8*rxt(309)*y(85) + .167_r8*rxt(315)*y(86)
         mat(915) = .250_r8*rxt(310)*y(85) + .167_r8*rxt(316)*y(86)
         mat(742) = .190_r8*rxt(313)*y(85)
         mat(985) = .167_r8*rxt(317)*y(86)
         mat(469) = .400_r8*rxt(307)*y(1)
         mat(692) = .250_r8*rxt(314)*y(85)
         mat(495) = rxt(347)*y(6)
         mat(649) = .230_r8*rxt(309)*y(6) + .250_r8*rxt(310)*y(8) + .190_r8*rxt(313) &
                      *y(13) + .250_r8*rxt(314)*y(45)
         mat(301) = rxt(345)*y(1)
         mat(404) = .167_r8*rxt(315)*y(6) + .167_r8*rxt(316)*y(8) + .167_r8*rxt(317) &
                      *y(21)


      end subroutine nlnmat05

      subroutine nlnmat06( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(629) = -((rxt(290) + rxt(291)) * y(6) + rxt(292)*y(8) + rxt(293)*y(21) &
                      + rxt(294)*y(13) + rxt(295)*y(45))
         mat(1257) = -(rxt(290) + rxt(291)) * y(76)
         mat(919) = -rxt(292)*y(76)
         mat(989) = -rxt(293)*y(76)
         mat(746) = -rxt(294)*y(76)
         mat(696) = -rxt(295)*y(76)

         mat(1105) = rxt(282)*y(74) + .500_r8*rxt(288)*y(75) + .200_r8*rxt(296)*y(77)
         mat(609) = rxt(282)*y(20)
         mat(566) = .500_r8*rxt(288)*y(20)
         mat(137) = .200_r8*rxt(296)*y(20)

         mat(136) = -(rxt(296)*y(20))
         mat(1051) = -rxt(296)*y(77)

         mat(945) = rxt(293)*y(76)
         mat(621) = rxt(293)*y(21)

         mat(672) = -(rxt(297)*y(6) + rxt(298)*y(8) + rxt(299)*y(21) + rxt(300)*y(13) &
                      + rxt(301)*y(45) + 4._r8*rxt(302)*y(73) + rxt(303)*y(7))
         mat(1259) = -rxt(297)*y(73)
         mat(921) = -rxt(298)*y(73)
         mat(991) = -rxt(299)*y(73)
         mat(748) = -rxt(300)*y(73)
         mat(698) = -rxt(301)*y(73)
         mat(859) = -rxt(303)*y(73)

         mat(825) = .200_r8*rxt(307)*y(80)
         mat(1107) = .500_r8*rxt(288)*y(75) + .500_r8*rxt(296)*y(77)
         mat(472) = .200_r8*rxt(307)*y(1)
         mat(567) = .500_r8*rxt(288)*y(20)
         mat(138) = .500_r8*rxt(296)*y(20)

         mat(385) = -(rxt(242)*y(6) + rxt(243)*y(21) + rxt(244)*y(13) + 4._r8*rxt(245) &
                      *y(43))
         mat(1243) = -rxt(242)*y(43)
         mat(971) = -rxt(243)*y(43)
         mat(735) = -rxt(244)*y(43)

         mat(1085) = rxt(234)*y(42) + .500_r8*rxt(246)*y(44)
         mat(1134) = rxt(232)*y(42)
         mat(120) = rxt(234)*y(20) + rxt(232)*y(25)
         mat(142) = .500_r8*rxt(246)*y(20)

         mat(141) = -(rxt(246)*y(20))
         mat(1052) = -rxt(246)*y(44)

         mat(946) = rxt(243)*y(43)
         mat(383) = rxt(243)*y(21)

         mat(299) = -(rxt(344)*y(20) + rxt(345)*y(1) + rxt(346)*y(8))
         mat(1075) = -rxt(344)*y(102)
         mat(807) = -rxt(345)*y(102)
         mat(902) = -rxt(346)*y(102)

         mat(51) = -(rxt(267)*y(20))
         mat(1038) = -rxt(267)*y(57)

         mat(426) = -(rxt(263)*y(6) + rxt(264)*y(21) + rxt(265)*y(13))
         mat(1245) = -rxt(263)*y(58)
         mat(975) = -rxt(264)*y(58)
         mat(736) = -rxt(265)*y(58)

         mat(1088) = rxt(267)*y(57) + rxt(266)*y(59)
         mat(52) = rxt(267)*y(20)
         mat(171) = rxt(266)*y(20)

         mat(169) = -(rxt(266)*y(20))
         mat(1057) = -rxt(266)*y(59)

         mat(949) = rxt(264)*y(58)
         mat(424) = rxt(264)*y(21)

         mat(362) = -(rxt(271)*y(20))
         mat(1082) = -rxt(271)*y(60)

         mat(1240) = .500_r8*rxt(281)*y(70) + .250_r8*rxt(322)*y(81) &
                      + .100_r8*rxt(347)*y(103) + .820_r8*rxt(263)*y(58)
         mat(733) = .820_r8*rxt(265)*y(58)
         mat(147) = .500_r8*rxt(281)*y(6)
         mat(352) = .250_r8*rxt(322)*y(6)
         mat(492) = .100_r8*rxt(347)*y(6)
         mat(425) = .820_r8*rxt(263)*y(6) + .820_r8*rxt(265)*y(13)

         mat(175) = -(rxt(275)*y(20))
         mat(1058) = -rxt(275)*y(66)

         mat(950) = rxt(273)*y(64)
         mat(533) = rxt(273)*y(21)

         mat(244) = -(rxt(224)*y(20))
         mat(1068) = -rxt(224)*y(15)

         mat(731) = 2.000_r8*rxt(223)*y(13) + .250_r8*rxt(313)*y(85) &
                      + .250_r8*rxt(294)*y(76) + .300_r8*rxt(244)*y(43) &
                      + .500_r8*rxt(274)*y(64) + .300_r8*rxt(328)*y(88)
         mat(642) = .250_r8*rxt(313)*y(13)
         mat(622) = .250_r8*rxt(294)*y(13)
         mat(384) = .300_r8*rxt(244)*y(13)
         mat(534) = .500_r8*rxt(274)*y(13)
         mat(586) = .300_r8*rxt(328)*y(13)

         mat(101) = -(rxt(257)*y(20))
         mat(1046) = -rxt(257)*y(48)

         mat(728) = .200_r8*rxt(244)*y(43)
         mat(382) = .200_r8*rxt(244)*y(13) + .800_r8*rxt(245)*y(43)

         mat(446) = -(rxt(255)*y(20))
         mat(1090) = -rxt(255)*y(49)

         mat(1246) = .020_r8*rxt(309)*y(85) + .530_r8*rxt(290)*y(76) &
                      + .250_r8*rxt(325)*y(88)
         mat(906) = .530_r8*rxt(292)*y(76) + .250_r8*rxt(326)*y(88)
         mat(737) = .260_r8*rxt(294)*y(76) + .100_r8*rxt(328)*y(88)
         mat(689) = .530_r8*rxt(295)*y(76) + .250_r8*rxt(329)*y(88)
         mat(645) = .020_r8*rxt(309)*y(6)
         mat(623) = .530_r8*rxt(290)*y(6) + .530_r8*rxt(292)*y(8) + .260_r8*rxt(294) &
                      *y(13) + .530_r8*rxt(295)*y(45)
         mat(588) = .250_r8*rxt(325)*y(6) + .250_r8*rxt(326)*y(8) + .100_r8*rxt(328) &
                      *y(13) + .250_r8*rxt(329)*y(45)

         mat(557) = -(rxt(276)*y(20))
         mat(1100) = -rxt(276)*y(63)

         mat(1252) = .020_r8*rxt(309)*y(85) + .220_r8*rxt(290)*y(76) &
                      + .250_r8*rxt(325)*y(88)
         mat(1100) = mat(1100) + .500_r8*rxt(270)*y(62) + .500_r8*rxt(305)*y(78)
         mat(914) = .220_r8*rxt(292)*y(76) + .250_r8*rxt(326)*y(88)
         mat(741) = .230_r8*rxt(294)*y(76) + .200_r8*rxt(274)*y(64) + .100_r8*rxt(328) &
                      *y(88)
         mat(239) = .500_r8*rxt(270)*y(20)
         mat(691) = .220_r8*rxt(295)*y(76) + .250_r8*rxt(329)*y(88)
         mat(269) = .500_r8*rxt(305)*y(20)
         mat(648) = .020_r8*rxt(309)*y(6)
         mat(626) = .220_r8*rxt(290)*y(6) + .220_r8*rxt(292)*y(8) + .230_r8*rxt(294) &
                      *y(13) + .220_r8*rxt(295)*y(45)
         mat(536) = .200_r8*rxt(274)*y(13)
         mat(590) = .250_r8*rxt(325)*y(6) + .250_r8*rxt(326)*y(8) + .100_r8*rxt(328) &
                      *y(13) + .250_r8*rxt(329)*y(45)

         mat(340) = -(rxt(236)*y(6) + rxt(237)*y(21))
         mat(1238) = -rxt(236)*y(52)
         mat(966) = -rxt(237)*y(52)

         mat(1080) = rxt(235)*y(41)
         mat(250) = rxt(235)*y(20)


         mat(1226) = .750_r8*rxt(236)*y(52)
         mat(339) = .750_r8*rxt(236)*y(6)


         mat(941) = rxt(237)*y(52)
         mat(338) = rxt(237)*y(21)

         mat(153) = -(rxt(321)*y(20))
         mat(1054) = -rxt(321)*y(84)

         mat(1228) = .330_r8*rxt(309)*y(85)
         mat(1054) = mat(1054) + rxt(319)*y(87)
         mat(900) = .400_r8*rxt(310)*y(85) + rxt(320)*y(87)
         mat(729) = .300_r8*rxt(313)*y(85)
         mat(684) = .400_r8*rxt(314)*y(85)
         mat(641) = .330_r8*rxt(309)*y(6) + .400_r8*rxt(310)*y(8) + .300_r8*rxt(313) &
                      *y(13) + .400_r8*rxt(314)*y(45)
         mat(482) = rxt(319)*y(20) + rxt(320)*y(8)

         mat(535) = -(rxt(272)*y(6) + rxt(273)*y(21) + rxt(274)*y(13))
         mat(1250) = -rxt(272)*y(64)
         mat(982) = -rxt(273)*y(64)
         mat(739) = -rxt(274)*y(64)

         mat(1098) = rxt(271)*y(60) + rxt(275)*y(66)
         mat(363) = rxt(271)*y(20)
         mat(176) = rxt(275)*y(20)

         mat(577) = -(rxt(277)*y(20) + rxt(278)*y(8))
         mat(1102) = -rxt(277)*y(65)
         mat(916) = -rxt(278)*y(65)

         mat(820) = .950_r8*rxt(283)*y(74) + .800_r8*rxt(289)*y(75)
         mat(1254) = .450_r8*rxt(333)*y(93) + .540_r8*rxt(343)*y(100) &
                      + .020_r8*rxt(309)*y(85) + .250_r8*rxt(290)*y(76) &
                      + .250_r8*rxt(325)*y(88)
         mat(1102) = mat(1102) + rxt(279)*y(79) + rxt(276)*y(63)
         mat(916) = mat(916) + .250_r8*rxt(292)*y(76) + .250_r8*rxt(326)*y(88)
         mat(743) = .240_r8*rxt(294)*y(76) + .500_r8*rxt(274)*y(64) + .100_r8*rxt(328) &
                      *y(88)
         mat(693) = .250_r8*rxt(295)*y(76) + .250_r8*rxt(329)*y(88)
         mat(188) = rxt(279)*y(20)
         mat(288) = .450_r8*rxt(333)*y(6)
         mat(219) = .540_r8*rxt(343)*y(6)
         mat(650) = .020_r8*rxt(309)*y(6)
         mat(607) = .950_r8*rxt(283)*y(1)
         mat(565) = .800_r8*rxt(289)*y(1)
         mat(627) = .250_r8*rxt(290)*y(6) + .250_r8*rxt(292)*y(8) + .240_r8*rxt(294) &
                      *y(13) + .250_r8*rxt(295)*y(45)
         mat(558) = rxt(276)*y(20)
         mat(537) = .500_r8*rxt(274)*y(13)
         mat(591) = .250_r8*rxt(325)*y(6) + .250_r8*rxt(326)*y(8) + .100_r8*rxt(328) &
                      *y(13) + .250_r8*rxt(329)*y(45)

         mat(402) = -(rxt(315)*y(6) + rxt(316)*y(8) + rxt(317)*y(21))
         mat(1244) = -rxt(315)*y(86)
         mat(904) = -rxt(316)*y(86)
         mat(973) = -rxt(317)*y(86)

         mat(904) = mat(904) + rxt(308)*y(80)
         mat(464) = rxt(308)*y(8)

         mat(483) = -(rxt(319)*y(20) + rxt(320)*y(8))
         mat(1093) = -rxt(319)*y(87)
         mat(908) = -rxt(320)*y(87)

         mat(1247) = .080_r8*rxt(309)*y(85) + .800_r8*rxt(291)*y(76) &
                      + .794_r8*rxt(315)*y(86)
         mat(908) = mat(908) + .794_r8*rxt(316)*y(86)
         mat(978) = .794_r8*rxt(317)*y(86)
         mat(646) = .080_r8*rxt(309)*y(6)
         mat(624) = .800_r8*rxt(291)*y(6)
         mat(403) = .794_r8*rxt(315)*y(6) + .794_r8*rxt(316)*y(8) + .794_r8*rxt(317) &
                      *y(21)

         mat(592) = -(rxt(325)*y(6) + rxt(326)*y(8) + rxt(327)*y(21) + rxt(328)*y(13) &
                      + rxt(329)*y(45))
         mat(1255) = -rxt(325)*y(88)
         mat(917) = -rxt(326)*y(88)
         mat(987) = -rxt(327)*y(88)
         mat(744) = -rxt(328)*y(88)
         mat(694) = -rxt(329)*y(88)

         mat(1103) = rxt(321)*y(84) + rxt(330)*y(89) + .800_r8*rxt(312)*y(90)
         mat(154) = rxt(321)*y(20)
         mat(110) = rxt(330)*y(20)
         mat(278) = .800_r8*rxt(312)*y(20)

         mat(109) = -((rxt(330) + rxt(331)) * y(20))
         mat(1047) = -(rxt(330) + rxt(331)) * y(89)

         mat(943) = rxt(327)*y(88)
         mat(585) = rxt(327)*y(21)

         mat(276) = -(rxt(312)*y(20))
         mat(1072) = -rxt(312)*y(90)

         mat(959) = rxt(311)*y(85)
         mat(643) = rxt(311)*y(21)

         mat(113) = -(rxt(230)*y(25) + rxt(233)*y(20))
         mat(1127) = -rxt(230)*y(125)
         mat(1048) = -rxt(233)*y(125)

         mat(256) = -(rxt(226)*y(20))
         mat(1070) = -rxt(226)*y(126)

         mat(806) = .500_r8*rxt(240)*y(41)
         mat(1234) = rxt(228)*y(127)
         mat(1070) = mat(1070) + .350_r8*rxt(233)*y(125)
         mat(958) = rxt(229)*y(127)
         mat(249) = .500_r8*rxt(240)*y(1)
         mat(114) = .350_r8*rxt(233)*y(20)
         mat(182) = rxt(228)*y(6) + rxt(229)*y(21)


      end subroutine nlnmat06

      subroutine nlnmat07( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(181) = -(rxt(228)*y(6) + rxt(229)*y(21))
         mat(1230) = -rxt(228)*y(127)
         mat(951) = -rxt(229)*y(127)

         mat(785) = rxt(219)*y(21)
         mat(951) = mat(951) + rxt(219)*y(16)

         mat(90) = -(rxt(361)*y(2) + rxt(362)*y(20))
         mat(1158) = -rxt(361)*y(142)
         mat(1044) = -rxt(362)*y(142)

         mat(67) = -(rxt(354)*y(20))
         mat(1041) = -rxt(354)*y(143)

         mat(1041) = mat(1041) + rxt(362)*y(142) + (rxt(355)+.500_r8*rxt(356))*y(144)
         mat(897) = rxt(357)*y(144)
         mat(89) = rxt(362)*y(20)
         mat(95) = (rxt(355)+.500_r8*rxt(356))*y(20) + rxt(357)*y(8)

         mat(96) = -((rxt(355) + rxt(356)) * y(20) + rxt(357)*y(8))
         mat(1045) = -(rxt(355) + rxt(356)) * y(144)
         mat(898) = -rxt(357)*y(144)


         mat(1031) = rxt(354)*y(143)
         mat(66) = rxt(354)*y(20)

         mat(42) = -(rxt(358)*y(20))
         mat(1036) = -rxt(358)*y(146)
      end subroutine nlnmat07
      subroutine nlnmat_finit( mat, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(inout) :: mat(nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
         mat( 1) = lmat( 1)
         mat( 2) = lmat( 2)
         mat( 3) = lmat( 3)
         mat( 4) = lmat( 4)
         mat( 5) = lmat( 5)
         mat( 6) = lmat( 6)
         mat( 7) = lmat( 7)
         mat( 8) = lmat( 8)
         mat( 9) = lmat( 9)
         mat( 10) = lmat( 10)
         mat( 11) = lmat( 11)
         mat( 12) = lmat( 12)
         mat( 13) = lmat( 13)
         mat( 14) = lmat( 14)
         mat( 15) = lmat( 15)
         mat( 16) = lmat( 16)
         mat( 17) = lmat( 17)
         mat( 18) = lmat( 18)
         mat( 19) = lmat( 19)
         mat( 20) = lmat( 20)
         mat( 21) = lmat( 21)
         mat( 22) = lmat( 22)
         mat( 23) = lmat( 23)
         mat( 24) = lmat( 24)
         mat( 25) = lmat( 25)
         mat( 26) = lmat( 26)
         mat( 27) = lmat( 27)
         mat( 28) = lmat( 28)
         mat( 29) = lmat( 29)
         mat( 30) = mat( 30) + lmat( 30)
         mat( 33) = mat( 33) + lmat( 33)
         mat( 36) = mat( 36) + lmat( 36)
         mat( 39) = mat( 39) + lmat( 39)
         mat( 42) = mat( 42) + lmat( 42)
         mat( 45) = mat( 45) + lmat( 45)
         mat( 48) = lmat( 48)
         mat( 49) = lmat( 49)
         mat( 50) = lmat( 50)
         mat( 51) = mat( 51) + lmat( 51)
         mat( 55) = mat( 55) + lmat( 55)
         mat( 60) = mat( 60) + lmat( 60)
         mat( 63) = lmat( 63)
         mat( 64) = lmat( 64)
         mat( 65) = lmat( 65)
         mat( 67) = mat( 67) + lmat( 67)
         mat( 69) = lmat( 69)
         mat( 70) = lmat( 70)
         mat( 71) = lmat( 71)
         mat( 72) = lmat( 72)
         mat( 73) = lmat( 73)
         mat( 74) = mat( 74) + lmat( 74)
         mat( 78) = mat( 78) + lmat( 78)
         mat( 80) = mat( 80) + lmat( 80)
         mat( 81) = mat( 81) + lmat( 81)
         mat( 82) = mat( 82) + lmat( 82)
         mat( 86) = lmat( 86)
         mat( 87) = lmat( 87)
         mat( 88) = lmat( 88)
         mat( 90) = mat( 90) + lmat( 90)
         mat( 91) = mat( 91) + lmat( 91)
         mat( 96) = mat( 96) + lmat( 96)
         mat( 101) = mat( 101) + lmat( 101)
         mat( 105) = lmat( 105)
         mat( 106) = lmat( 106)
         mat( 107) = lmat( 107)
         mat( 108) = lmat( 108)
         mat( 109) = mat( 109) + lmat( 109)
         mat( 112) = mat( 112) + lmat( 112)
         mat( 113) = mat( 113) + lmat( 113)
         mat( 119) = mat( 119) + lmat( 119)
         mat( 125) = lmat( 125)
         mat( 126) = lmat( 126)
         mat( 127) = lmat( 127)
         mat( 128) = lmat( 128)
         mat( 129) = lmat( 129)
         mat( 130) = lmat( 130)
         mat( 131) = mat( 131) + lmat( 131)
         mat( 133) = lmat( 133)
         mat( 134) = lmat( 134)
         mat( 135) = mat( 135) + lmat( 135)
         mat( 136) = mat( 136) + lmat( 136)
         mat( 141) = mat( 141) + lmat( 141)
         mat( 143) = mat( 143) + lmat( 143)
         mat( 144) = lmat( 144)
         mat( 145) = mat( 145) + lmat( 145)
         mat( 146) = mat( 146) + lmat( 146)
         mat( 153) = mat( 153) + lmat( 153)
         mat( 156) = mat( 156) + lmat( 156)
         mat( 158) = lmat( 158)
         mat( 159) = lmat( 159)
         mat( 160) = lmat( 160)
         mat( 161) = mat( 161) + lmat( 161)
         mat( 163) = mat( 163) + lmat( 163)
         mat( 169) = mat( 169) + lmat( 169)
         mat( 170) = lmat( 170)
         mat( 173) = lmat( 173)
         mat( 174) = mat( 174) + lmat( 174)
         mat( 175) = mat( 175) + lmat( 175)
         mat( 177) = lmat( 177)
         mat( 179) = lmat( 179)
         mat( 180) = mat( 180) + lmat( 180)
         mat( 181) = mat( 181) + lmat( 181)
         mat( 183) = lmat( 183)
         mat( 185) = mat( 185) + lmat( 185)
         mat( 187) = mat( 187) + lmat( 187)
         mat( 191) = mat( 191) + lmat( 191)
         mat( 193) = mat( 193) + lmat( 193)
         mat( 194) = lmat( 194)
         mat( 195) = lmat( 195)
         mat( 196) = mat( 196) + lmat( 196)
         mat( 197) = mat( 197) + lmat( 197)
         mat( 199) = lmat( 199)
         mat( 201) = mat( 201) + lmat( 201)
         mat( 202) = mat( 202) + lmat( 202)
         mat( 203) = mat( 203) + lmat( 203)
         mat( 205) = lmat( 205)
         mat( 206) = lmat( 206)
         mat( 208) = mat( 208) + lmat( 208)
         mat( 209) = lmat( 209)
         mat( 210) = lmat( 210)
         mat( 212) = lmat( 212)
         mat( 213) = mat( 213) + lmat( 213)
         mat( 216) = mat( 216) + lmat( 216)
         mat( 223) = mat( 223) + lmat( 223)
         mat( 224) = lmat( 224)
         mat( 226) = lmat( 226)
         mat( 227) = lmat( 227)
         mat( 228) = lmat( 228)
         mat( 229) = mat( 229) + lmat( 229)
         mat( 230) = mat( 230) + lmat( 230)
         mat( 233) = lmat( 233)
         mat( 235) = mat( 235) + lmat( 235)
         mat( 236) = mat( 236) + lmat( 236)
         mat( 238) = lmat( 238)
         mat( 241) = lmat( 241)
         mat( 242) = lmat( 242)
         mat( 243) = mat( 243) + lmat( 243)
         mat( 244) = mat( 244) + lmat( 244)
         mat( 248) = mat( 248) + lmat( 248)
         mat( 256) = mat( 256) + lmat( 256)
         mat( 260) = mat( 260) + lmat( 260)
         mat( 261) = lmat( 261)
         mat( 262) = lmat( 262)
         mat( 263) = mat( 263) + lmat( 263)
         mat( 264) = lmat( 264)
         mat( 265) = mat( 265) + lmat( 265)
         mat( 267) = lmat( 267)
         mat( 268) = mat( 268) + lmat( 268)
         mat( 270) = lmat( 270)
         mat( 272) = lmat( 272)
         mat( 276) = mat( 276) + lmat( 276)
         mat( 277) = lmat( 277)
         mat( 279) = lmat( 279)
         mat( 281) = lmat( 281)
         mat( 282) = lmat( 282)
         mat( 285) = mat( 285) + lmat( 285)
         mat( 293) = lmat( 293)
         mat( 294) = lmat( 294)
         mat( 295) = lmat( 295)
         mat( 296) = lmat( 296)
         mat( 297) = lmat( 297)
         mat( 298) = lmat( 298)
         mat( 299) = mat( 299) + lmat( 299)
         mat( 308) = mat( 308) + lmat( 308)
         mat( 312) = mat( 312) + lmat( 312)
         mat( 315) = mat( 315) + lmat( 315)
         mat( 319) = lmat( 319)
         mat( 320) = mat( 320) + lmat( 320)
         mat( 323) = lmat( 323)
         mat( 325) = lmat( 325)
         mat( 327) = lmat( 327)
         mat( 328) = lmat( 328)
         mat( 329) = mat( 329) + lmat( 329)
         mat( 331) = mat( 331) + lmat( 331)
         mat( 340) = mat( 340) + lmat( 340)
         mat( 351) = mat( 351) + lmat( 351)
         mat( 362) = mat( 362) + lmat( 362)
         mat( 364) = lmat( 364)
         mat( 366) = lmat( 366)
         mat( 369) = mat( 369) + lmat( 369)
         mat( 378) = mat( 378) + lmat( 378)
         mat( 379) = mat( 379) + lmat( 379)
         mat( 380) = mat( 380) + lmat( 380)
         mat( 385) = mat( 385) + lmat( 385)
         mat( 394) = mat( 394) + lmat( 394)
         mat( 398) = mat( 398) + lmat( 398)
         mat( 401) = lmat( 401)
         mat( 402) = mat( 402) + lmat( 402)
         mat( 412) = mat( 412) + lmat( 412)
         mat( 414) = lmat( 414)
         mat( 418) = mat( 418) + lmat( 418)
         mat( 419) = mat( 419) + lmat( 419)
         mat( 421) = lmat( 421)
         mat( 423) = mat( 423) + lmat( 423)
         mat( 426) = mat( 426) + lmat( 426)
         mat( 438) = mat( 438) + lmat( 438)
         mat( 441) = mat( 441) + lmat( 441)
         mat( 442) = mat( 442) + lmat( 442)
         mat( 446) = mat( 446) + lmat( 446)
         mat( 447) = lmat( 447)
         mat( 448) = mat( 448) + lmat( 448)
         mat( 449) = mat( 449) + lmat( 449)
         mat( 452) = mat( 452) + lmat( 452)
         mat( 453) = mat( 453) + lmat( 453)
         mat( 454) = mat( 454) + lmat( 454)
         mat( 456) = lmat( 456)
         mat( 457) = mat( 457) + lmat( 457)
         mat( 460) = mat( 460) + lmat( 460)
         mat( 462) = mat( 462) + lmat( 462)
         mat( 465) = mat( 465) + lmat( 465)
         mat( 483) = mat( 483) + lmat( 483)
         mat( 484) = lmat( 484)
         mat( 486) = lmat( 486)
         mat( 487) = mat( 487) + lmat( 487)
         mat( 489) = mat( 489) + lmat( 489)
         mat( 493) = mat( 493) + lmat( 493)
         mat( 507) = mat( 507) + lmat( 507)
         mat( 521) = mat( 521) + lmat( 521)
         mat( 529) = mat( 529) + lmat( 529)
         mat( 535) = mat( 535) + lmat( 535)
         mat( 547) = lmat( 547)
         mat( 548) = mat( 548) + lmat( 548)
         mat( 552) = lmat( 552)
         mat( 555) = lmat( 555)
         mat( 557) = mat( 557) + lmat( 557)
         mat( 559) = lmat( 559)
         mat( 560) = lmat( 560)
         mat( 561) = mat( 561) + lmat( 561)
         mat( 563) = mat( 563) + lmat( 563)
         mat( 564) = mat( 564) + lmat( 564)
         mat( 567) = mat( 567) + lmat( 567)
         mat( 568) = lmat( 568)
         mat( 571) = mat( 571) + lmat( 571)
         mat( 573) = mat( 573) + lmat( 573)
         mat( 576) = mat( 576) + lmat( 576)
         mat( 577) = mat( 577) + lmat( 577)
         mat( 578) = mat( 578) + lmat( 578)
         mat( 583) = lmat( 583)
         mat( 592) = mat( 592) + lmat( 592)
         mat( 603) = lmat( 603)
         mat( 604) = mat( 604) + lmat( 604)
         mat( 608) = mat( 608) + lmat( 608)
         mat( 610) = lmat( 610)
         mat( 613) = lmat( 613)
         mat( 629) = mat( 629) + lmat( 629)
         mat( 654) = mat( 654) + lmat( 654)
         mat( 672) = mat( 672) + lmat( 672)
         mat( 699) = mat( 699) + lmat( 699)
         mat( 710) = lmat( 710)
         mat( 711) = mat( 711) + lmat( 711)
         mat( 712) = lmat( 712)
         mat( 713) = mat( 713) + lmat( 713)
         mat( 715) = mat( 715) + lmat( 715)
         mat( 717) = lmat( 717)
         mat( 720) = mat( 720) + lmat( 720)
         mat( 723) = mat( 723) + lmat( 723)
         mat( 752) = mat( 752) + lmat( 752)
         mat( 772) = mat( 772) + lmat( 772)
         mat( 781) = mat( 781) + lmat( 781)
         mat( 783) = mat( 783) + lmat( 783)
         mat( 789) = lmat( 789)
         mat( 790) = mat( 790) + lmat( 790)
         mat( 792) = mat( 792) + lmat( 792)
         mat( 793) = mat( 793) + lmat( 793)
         mat( 832) = mat( 832) + lmat( 832)
         mat( 834) = mat( 834) + lmat( 834)
         mat( 840) = mat( 840) + lmat( 840)
         mat( 854) = mat( 854) + lmat( 854)
         mat( 867) = mat( 867) + lmat( 867)
         mat( 872) = mat( 872) + lmat( 872)
         mat( 874) = mat( 874) + lmat( 874)
         mat( 877) = mat( 877) + lmat( 877)
         mat( 880) = mat( 880) + lmat( 880)
         mat( 882) = mat( 882) + lmat( 882)
         mat( 883) = lmat( 883)
         mat( 884) = lmat( 884)
         mat( 887) = mat( 887) + lmat( 887)
         mat( 889) = lmat( 889)
         mat( 891) = mat( 891) + lmat( 891)
         mat( 892) = mat( 892) + lmat( 892)
         mat( 893) = lmat( 893)
         mat( 895) = mat( 895) + lmat( 895)
         mat( 896) = lmat( 896)
         mat( 905) = mat( 905) + lmat( 905)
         mat( 928) = mat( 928) + lmat( 928)
         mat( 930) = mat( 930) + lmat( 930)
         mat( 935) = mat( 935) + lmat( 935)
         mat( 938) = mat( 938) + lmat( 938)
         mat( 962) = mat( 962) + lmat( 962)
         mat(1002) = mat(1002) + lmat(1002)
         mat(1017) = lmat(1017)
         mat(1024) = mat(1024) + lmat(1024)
         mat(1026) = mat(1026) + lmat(1026)
         mat(1109) = mat(1109) + lmat(1109)
         mat(1111) = mat(1111) + lmat(1111)
         mat(1118) = mat(1118) + lmat(1118)
         mat(1120) = mat(1120) + lmat(1120)
         mat(1121) = mat(1121) + lmat(1121)
         mat(1124) = mat(1124) + lmat(1124)
         mat(1139) = mat(1139) + lmat(1139)
         mat(1144) = lmat(1144)
         mat(1150) = mat(1150) + lmat(1150)
         mat(1151) = mat(1151) + lmat(1151)
         mat(1153) = mat(1153) + lmat(1153)
         mat(1156) = lmat(1156)
         mat(1172) = mat(1172) + lmat(1172)
         mat(1180) = mat(1180) + lmat(1180)
         mat(1202) = mat(1202) + lmat(1202)
         mat(1203) = mat(1203) + lmat(1203)
         mat(1204) = mat(1204) + lmat(1204)
         mat(1223) = mat(1223) + lmat(1223)
         mat(1225) = mat(1225) + lmat(1225)
         mat(1274) = mat(1274) + lmat(1274)
         mat(1277) = mat(1277) + lmat(1277)
         mat( 291) = 0._r8
         mat( 321) = 0._r8
         mat( 324) = 0._r8
         mat( 326) = 0._r8
         mat( 336) = 0._r8
         mat( 341) = 0._r8
         mat( 345) = 0._r8
         mat( 350) = 0._r8
         mat( 353) = 0._r8
         mat( 355) = 0._r8
         mat( 356) = 0._r8
         mat( 360) = 0._r8
         mat( 371) = 0._r8
         mat( 372) = 0._r8
         mat( 376) = 0._r8
         mat( 391) = 0._r8
         mat( 399) = 0._r8
         mat( 427) = 0._r8
         mat( 429) = 0._r8
         mat( 430) = 0._r8
         mat( 435) = 0._r8
         mat( 455) = 0._r8
         mat( 466) = 0._r8
         mat( 473) = 0._r8
         mat( 474) = 0._r8
         mat( 477) = 0._r8
         mat( 481) = 0._r8
         mat( 485) = 0._r8
         mat( 494) = 0._r8
         mat( 497) = 0._r8
         mat( 498) = 0._r8
         mat( 499) = 0._r8
         mat( 502) = 0._r8
         mat( 510) = 0._r8
         mat( 511) = 0._r8
         mat( 512) = 0._r8
         mat( 516) = 0._r8
         mat( 520) = 0._r8
         mat( 539) = 0._r8
         mat( 544) = 0._r8
         mat( 551) = 0._r8
         mat( 553) = 0._r8
         mat( 570) = 0._r8
         mat( 580) = 0._r8
         mat( 581) = 0._r8
         mat( 594) = 0._r8
         mat( 595) = 0._r8
         mat( 601) = 0._r8
         mat( 606) = 0._r8
         mat( 611) = 0._r8
         mat( 612) = 0._r8
         mat( 616) = 0._r8
         mat( 617) = 0._r8
         mat( 620) = 0._r8
         mat( 628) = 0._r8
         mat( 630) = 0._r8
         mat( 632) = 0._r8
         mat( 633) = 0._r8
         mat( 639) = 0._r8
         mat( 647) = 0._r8
         mat( 651) = 0._r8
         mat( 653) = 0._r8
         mat( 655) = 0._r8
         mat( 657) = 0._r8
         mat( 658) = 0._r8
         mat( 661) = 0._r8
         mat( 665) = 0._r8
         mat( 670) = 0._r8
         mat( 671) = 0._r8
         mat( 674) = 0._r8
         mat( 675) = 0._r8
         mat( 682) = 0._r8
         mat( 700) = 0._r8
         mat( 701) = 0._r8
         mat( 706) = 0._r8
         mat( 708) = 0._r8
         mat( 714) = 0._r8
         mat( 716) = 0._r8
         mat( 722) = 0._r8
         mat( 724) = 0._r8
         mat( 726) = 0._r8
         mat( 750) = 0._r8
         mat( 751) = 0._r8
         mat( 754) = 0._r8
         mat( 756) = 0._r8
         mat( 757) = 0._r8
         mat( 759) = 0._r8
         mat( 760) = 0._r8
         mat( 762) = 0._r8
         mat( 769) = 0._r8
         mat( 770) = 0._r8
         mat( 771) = 0._r8
         mat( 773) = 0._r8
         mat( 775) = 0._r8
         mat( 776) = 0._r8
         mat( 778) = 0._r8
         mat( 786) = 0._r8
         mat( 794) = 0._r8
         mat( 795) = 0._r8
         mat( 796) = 0._r8
         mat( 804) = 0._r8
         mat( 809) = 0._r8
         mat( 810) = 0._r8
         mat( 812) = 0._r8
         mat( 813) = 0._r8
         mat( 816) = 0._r8
         mat( 818) = 0._r8
         mat( 821) = 0._r8
         mat( 823) = 0._r8
         mat( 824) = 0._r8
         mat( 826) = 0._r8
         mat( 827) = 0._r8
         mat( 837) = 0._r8
         mat( 852) = 0._r8
         mat( 853) = 0._r8
         mat( 856) = 0._r8
         mat( 857) = 0._r8
         mat( 858) = 0._r8
         mat( 861) = 0._r8
         mat( 862) = 0._r8
         mat( 863) = 0._r8
         mat( 865) = 0._r8
         mat( 868) = 0._r8
         mat( 871) = 0._r8
         mat( 873) = 0._r8
         mat( 876) = 0._r8
         mat( 886) = 0._r8
         mat( 888) = 0._r8
         mat( 894) = 0._r8
         mat( 912) = 0._r8
         mat( 923) = 0._r8
         mat( 924) = 0._r8
         mat( 925) = 0._r8
         mat( 927) = 0._r8
         mat( 929) = 0._r8
         mat( 932) = 0._r8
         mat( 934) = 0._r8
         mat( 936) = 0._r8
         mat( 937) = 0._r8
         mat( 942) = 0._r8
         mat( 961) = 0._r8
         mat( 968) = 0._r8
         mat( 970) = 0._r8
         mat( 977) = 0._r8
         mat( 981) = 0._r8
         mat( 983) = 0._r8
         mat( 984) = 0._r8
         mat( 986) = 0._r8
         mat(1000) = 0._r8
         mat(1018) = 0._r8
         mat(1019) = 0._r8
         mat(1020) = 0._r8
         mat(1022) = 0._r8
         mat(1023) = 0._r8
         mat(1028) = 0._r8
         mat(1029) = 0._r8
         mat(1030) = 0._r8
         mat(1074) = 0._r8
         mat(1116) = 0._r8
         mat(1125) = 0._r8
         mat(1130) = 0._r8
         mat(1132) = 0._r8
         mat(1133) = 0._r8
         mat(1136) = 0._r8
         mat(1140) = 0._r8
         mat(1141) = 0._r8
         mat(1142) = 0._r8
         mat(1147) = 0._r8
         mat(1148) = 0._r8
         mat(1154) = 0._r8
         mat(1157) = 0._r8
         mat(1163) = 0._r8
         mat(1168) = 0._r8
         mat(1174) = 0._r8
         mat(1190) = 0._r8
         mat(1191) = 0._r8
         mat(1195) = 0._r8
         mat(1197) = 0._r8
         mat(1198) = 0._r8
         mat(1209) = 0._r8
         mat(1210) = 0._r8
         mat(1214) = 0._r8
         mat(1215) = 0._r8
         mat(1216) = 0._r8
         mat(1218) = 0._r8
         mat(1219) = 0._r8
         mat(1220) = 0._r8
         mat(1221) = 0._r8
         mat(1222) = 0._r8
         mat(1224) = 0._r8
         mat(1261) = 0._r8
         mat(1262) = 0._r8
         mat(1268) = 0._r8
         mat(1271) = 0._r8
         mat( 1) = mat( 1) - dti
         mat( 2) = mat( 2) - dti
         mat( 3) = mat( 3) - dti
         mat( 4) = mat( 4) - dti
         mat( 5) = mat( 5) - dti
         mat( 6) = mat( 6) - dti
         mat( 7) = mat( 7) - dti
         mat( 8) = mat( 8) - dti
         mat( 9) = mat( 9) - dti
         mat( 10) = mat( 10) - dti
         mat( 11) = mat( 11) - dti
         mat( 12) = mat( 12) - dti
         mat( 13) = mat( 13) - dti
         mat( 14) = mat( 14) - dti
         mat( 15) = mat( 15) - dti
         mat( 16) = mat( 16) - dti
         mat( 18) = mat( 18) - dti
         mat( 19) = mat( 19) - dti
         mat( 21) = mat( 21) - dti
         mat( 22) = mat( 22) - dti
         mat( 23) = mat( 23) - dti
         mat( 24) = mat( 24) - dti
         mat( 25) = mat( 25) - dti
         mat( 26) = mat( 26) - dti
         mat( 27) = mat( 27) - dti
         mat( 28) = mat( 28) - dti
         mat( 29) = mat( 29) - dti
         mat( 30) = mat( 30) - dti
         mat( 33) = mat( 33) - dti
         mat( 36) = mat( 36) - dti
         mat( 39) = mat( 39) - dti
         mat( 42) = mat( 42) - dti
         mat( 45) = mat( 45) - dti
         mat( 48) = mat( 48) - dti
         mat( 51) = mat( 51) - dti
         mat( 55) = mat( 55) - dti
         mat( 60) = mat( 60) - dti
         mat( 63) = mat( 63) - dti
         mat( 67) = mat( 67) - dti
         mat( 69) = mat( 69) - dti
         mat( 72) = mat( 72) - dti
         mat( 74) = mat( 74) - dti
         mat( 78) = mat( 78) - dti
         mat( 82) = mat( 82) - dti
         mat( 86) = mat( 86) - dti
         mat( 90) = mat( 90) - dti
         mat( 96) = mat( 96) - dti
         mat( 101) = mat( 101) - dti
         mat( 105) = mat( 105) - dti
         mat( 109) = mat( 109) - dti
         mat( 113) = mat( 113) - dti
         mat( 119) = mat( 119) - dti
         mat( 125) = mat( 125) - dti
         mat( 131) = mat( 131) - dti
         mat( 136) = mat( 136) - dti
         mat( 141) = mat( 141) - dti
         mat( 146) = mat( 146) - dti
         mat( 153) = mat( 153) - dti
         mat( 156) = mat( 156) - dti
         mat( 163) = mat( 163) - dti
         mat( 169) = mat( 169) - dti
         mat( 175) = mat( 175) - dti
         mat( 181) = mat( 181) - dti
         mat( 187) = mat( 187) - dti
         mat( 191) = mat( 191) - dti
         mat( 197) = mat( 197) - dti
         mat( 203) = mat( 203) - dti
         mat( 208) = mat( 208) - dti
         mat( 216) = mat( 216) - dti
         mat( 223) = mat( 223) - dti
         mat( 230) = mat( 230) - dti
         mat( 236) = mat( 236) - dti
         mat( 244) = mat( 244) - dti
         mat( 248) = mat( 248) - dti
         mat( 256) = mat( 256) - dti
         mat( 260) = mat( 260) - dti
         mat( 268) = mat( 268) - dti
         mat( 276) = mat( 276) - dti
         mat( 285) = mat( 285) - dti
         mat( 293) = mat( 293) - dti
         mat( 299) = mat( 299) - dti
         mat( 308) = mat( 308) - dti
         mat( 315) = mat( 315) - dti
         mat( 320) = mat( 320) - dti
         mat( 331) = mat( 331) - dti
         mat( 340) = mat( 340) - dti
         mat( 351) = mat( 351) - dti
         mat( 362) = mat( 362) - dti
         mat( 369) = mat( 369) - dti
         mat( 378) = mat( 378) - dti
         mat( 385) = mat( 385) - dti
         mat( 394) = mat( 394) - dti
         mat( 402) = mat( 402) - dti
         mat( 412) = mat( 412) - dti
         mat( 419) = mat( 419) - dti
         mat( 426) = mat( 426) - dti
         mat( 438) = mat( 438) - dti
         mat( 446) = mat( 446) - dti
         mat( 454) = mat( 454) - dti
         mat( 465) = mat( 465) - dti
         mat( 483) = mat( 483) - dti
         mat( 493) = mat( 493) - dti
         mat( 507) = mat( 507) - dti
         mat( 521) = mat( 521) - dti
         mat( 529) = mat( 529) - dti
         mat( 535) = mat( 535) - dti
         mat( 548) = mat( 548) - dti
         mat( 557) = mat( 557) - dti
         mat( 564) = mat( 564) - dti
         mat( 577) = mat( 577) - dti
         mat( 592) = mat( 592) - dti
         mat( 608) = mat( 608) - dti
         mat( 629) = mat( 629) - dti
         mat( 654) = mat( 654) - dti
         mat( 672) = mat( 672) - dti
         mat( 699) = mat( 699) - dti
         mat( 711) = mat( 711) - dti
         mat( 720) = mat( 720) - dti
         mat( 752) = mat( 752) - dti
         mat( 772) = mat( 772) - dti
         mat( 793) = mat( 793) - dti
         mat( 832) = mat( 832) - dti
         mat( 867) = mat( 867) - dti
         mat( 887) = mat( 887) - dti
         mat( 930) = mat( 930) - dti
         mat(1002) = mat(1002) - dti
         mat(1024) = mat(1024) - dti
         mat(1120) = mat(1120) - dti
         mat(1153) = mat(1153) - dti
         mat(1180) = mat(1180) - dti
         mat(1204) = mat(1204) - dti
         mat(1223) = mat(1223) - dti
         mat(1277) = mat(1277) - dti
      end subroutine nlnmat_finit
      subroutine nlnmat( mat, y, rxt, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)
      call nlnmat01( mat, y, rxt )
      call nlnmat02( mat, y, rxt )
      call nlnmat03( mat, y, rxt )
      call nlnmat04( mat, y, rxt )
      call nlnmat05( mat, y, rxt )
      call nlnmat06( mat, y, rxt )
      call nlnmat07( mat, y, rxt )
      call nlnmat_finit( mat, lmat, dti )
      end subroutine nlnmat
      end module mo_nln_matrix
