
      module mo_sim_dat

      private
      public :: set_sim_dat

      contains

      subroutine set_sim_dat

      use chem_mods,     only : clscnt, cls_rxt_cnt, clsmap, permute, adv_mass, fix_mass, crb_mass
      use chem_mods,     only : diag_map
      use chem_mods,     only : phtcnt, rxt_tag_cnt, rxt_tag_lst, rxt_tag_map
      use chem_mods,     only : pht_alias_lst, pht_alias_mult
      use chem_mods,     only : extfrc_lst, inv_lst, slvd_lst
      use chem_mods,     only : enthalpy_cnt, cph_enthalpy, cph_rid
      use cam_abortutils,only : endrun
      use mo_tracname,   only : solsym
      use chem_mods,     only : frc_from_dataset
      use shr_kind_mod,  only : r8 => shr_kind_r8
      use cam_logfile,   only : iulog

      implicit none

!--------------------------------------------------------------
!      ... local variables
!--------------------------------------------------------------
      integer :: ios

      clscnt(:) = (/     37,     0,     0,   133,     0 /)

      cls_rxt_cnt(:,1) = (/     19,    69,     0,    37 /)
      cls_rxt_cnt(:,4) = (/     23,   142,   232,   133 /)

      solsym(:170) = (/ 'O3              ','O               ','O1D             ','N2O             ','N               ', &
                        'NO              ','NO2             ','NO3             ','HNO3            ','HO2NO2          ', &
                        'N2O5            ','CH4             ','CH3O2           ','CH3OOH          ','CH3OH           ', &
                        'CH2O            ','CO              ','H2              ','H               ','OH              ', &
                        'HO2             ','H2O2            ','CLY             ','BRY             ','CL              ', &
                        'CL2             ','CLO             ','OCLO            ','CL2O2           ','HCL             ', &
                        'HOCL            ','CLONO2          ','BRCL            ','BR              ','BRO             ', &
                        'HBR             ','HOBR            ','BRONO2          ','HCN             ','CH3CN           ', &
                        'C2H4            ','C2H6            ','C2H5O2          ','C2H5OOH         ','CH3CO3          ', &
                        'CH3COOH         ','CH3CHO          ','C2H5OH          ','GLYALD          ','GLYOXAL         ', &
                        'CH3COOOH        ','EO2             ','EO              ','EOOH            ','PAN             ', &
                        'C3H6            ','C3H8            ','C3H7O2          ','C3H7OOH         ','CH3COCH3        ', &
                        'PO2             ','POOH            ','HYAC            ','RO2             ','CH3COCHO        ', &
                        'ROOH            ','BIGENE          ','BIGALK          ','MEK             ','ENEO2           ', &
                        'MEKO2           ','MEKOOH          ','MCO3            ','MVK             ','MACR            ', &
                        'MACRO2          ','MACROOH         ','MPAN            ','ONIT            ','ISOP            ', &
                        'ALKO2           ','ALKOOH          ','BIGALD          ','HYDRALD         ','ISOPO2          ', &
                        'ISOPNO3         ','ONITR           ','XO2             ','XOOH            ','ISOPOOH         ', &
                        'TOLUENE         ','CRESOL          ','TOLO2           ','TOLOOH          ','XOH             ', &
                        'BENZENE         ','BENO2           ','BENOOH          ','XYLENE          ','XYLO2           ', &
                        'XYLOOH          ','C10H16          ','TERPO2          ','TERPOOH         ','CH3CL           ', &
                        'CH3BR           ','CFC11           ','CFC12           ','CFC113          ','HCFC22          ', &
                        'CCL4            ','CH3CCL3         ','CF3BR           ','CF2CLBR         ','HCFC141B        ', &
                        'HCFC142B        ','CFC114          ','CFC115          ','H1202           ','H2402           ', &
                        'CHBR3           ','CH2BR2          ','CO2             ','H2O             ','C2H2            ', &
                        'HCOOH           ','HOCH2OO         ','CB1             ','CB2             ','OC1             ', &
                        'OC2             ','SOAM            ','SOAI            ','SOAT            ','SOAB            ', &
                        'SOAX            ','SOGM            ','SOGI            ','SOGT            ','SOGB            ', &
                        'SOGX            ','OCS             ','SO2             ','DMS             ','SO4             ', &
                        'NH3             ','NH4             ','NH4NO3          ','SSLT01          ','SSLT02          ', &
                        'SSLT03          ','SSLT04          ','DST01           ','DST02           ','DST03           ', &
                        'DST04           ','NH_5            ','NH_50           ','NH_50W          ','AOA_NH          ', &
                        'ST80_25         ','CO_25           ','CO_50           ','SO2t            ','SF6             ', &
                        'SF6em           ','O3S             ','E90             ','E90_NH          ','E90_SH          ' /)

      adv_mass(:170) = (/    47.998200_r8,    15.999400_r8,    15.999400_r8,    44.012880_r8,    14.006740_r8, &
                             30.006140_r8,    46.005540_r8,    62.004940_r8,    63.012340_r8,    79.011740_r8, &
                            108.010480_r8,    16.040600_r8,    47.032000_r8,    48.039400_r8,    32.040000_r8, &
                             30.025200_r8,    28.010400_r8,     2.014800_r8,     1.007400_r8,    17.006800_r8, &
                             33.006200_r8,    34.013600_r8,   100.916850_r8,    99.716850_r8,    35.452700_r8, &
                             70.905400_r8,    51.452100_r8,    67.451500_r8,   102.904200_r8,    36.460100_r8, &
                             52.459500_r8,    97.457640_r8,   115.356700_r8,    79.904000_r8,    95.903400_r8, &
                             80.911400_r8,    96.910800_r8,   141.908940_r8,    27.025140_r8,    41.050940_r8, &
                             28.051600_r8,    30.066400_r8,    61.057800_r8,    62.065200_r8,    75.042400_r8, &
                             60.050400_r8,    44.051000_r8,    46.065800_r8,    60.050400_r8,    58.035600_r8, &
                             76.049800_r8,    77.057200_r8,    61.057800_r8,    78.064600_r8,   121.047940_r8, &
                             42.077400_r8,    44.092200_r8,    75.083600_r8,    76.091000_r8,    58.076800_r8, &
                             91.083000_r8,    92.090400_r8,    74.076200_r8,    89.068200_r8,    72.061400_r8, &
                             90.075600_r8,    56.103200_r8,    72.143800_r8,    72.102600_r8,   105.108800_r8, &
                            103.094000_r8,   104.101400_r8,   101.079200_r8,    70.087800_r8,    70.087800_r8, &
                            119.093400_r8,   120.100800_r8,   147.084740_r8,   119.074340_r8,    68.114200_r8, &
                            103.135200_r8,   104.142600_r8,    98.098200_r8,   100.113000_r8,   117.119800_r8, &
                            162.117940_r8,   147.125940_r8,   149.118600_r8,   150.126000_r8,   118.127200_r8, &
                             92.136200_r8,   108.135600_r8,   173.140600_r8,   174.148000_r8,   190.147400_r8, &
                             78.110400_r8,   127.116000_r8,   128.123400_r8,   106.162000_r8,   155.167600_r8, &
                            156.175000_r8,   136.228400_r8,   185.234000_r8,   186.241400_r8,    50.485900_r8, &
                             94.937200_r8,   137.367503_r8,   120.913206_r8,   187.375310_r8,    86.467906_r8, &
                            153.821800_r8,   133.402300_r8,   148.910210_r8,   165.364506_r8,   116.948003_r8, &
                            100.493706_r8,   170.921013_r8,   154.466716_r8,   209.815806_r8,   259.823613_r8, &
                            252.730400_r8,   173.833800_r8,    44.009800_r8,    18.014200_r8,    26.036800_r8, &
                             46.024600_r8,    63.031400_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8, &
                             12.011000_r8,   200.226000_r8,   136.141400_r8,   141.141800_r8,   127.116000_r8, &
                            155.167600_r8,   200.226000_r8,   136.141400_r8,   141.141800_r8,   127.116000_r8, &
                            155.167600_r8,    60.076400_r8,    64.064800_r8,    62.132400_r8,    96.063600_r8, &
                             17.028940_r8,    18.036340_r8,    80.041280_r8,    58.442468_r8,    58.442468_r8, &
                             58.442468_r8,    58.442468_r8,   135.064039_r8,   135.064039_r8,   135.064039_r8, &
                            135.064039_r8,     1.007400_r8,     1.007400_r8,     1.007400_r8,     1.007400_r8, &
                              1.007400_r8,    28.010400_r8,    28.010400_r8,    64.064800_r8,   146.056419_r8, &
                            146.056419_r8,    47.998200_r8,    28.010400_r8,    28.010400_r8,    28.010400_r8 /)

      crb_mass(:170) = (/     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8, &
                             12.011000_r8,    12.011000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,    12.011000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,    12.011000_r8,    24.022000_r8, &
                             24.022000_r8,    24.022000_r8,    24.022000_r8,    24.022000_r8,    24.022000_r8, &
                             24.022000_r8,    24.022000_r8,    24.022000_r8,    24.022000_r8,    24.022000_r8, &
                             24.022000_r8,    24.022000_r8,    24.022000_r8,    24.022000_r8,    24.022000_r8, &
                             36.033000_r8,    36.033000_r8,    36.033000_r8,    36.033000_r8,    36.033000_r8, &
                             36.033000_r8,    36.033000_r8,    36.033000_r8,    36.033000_r8,    36.033000_r8, &
                             36.033000_r8,    48.044000_r8,    60.055000_r8,    48.044000_r8,    48.044000_r8, &
                             48.044000_r8,    48.044000_r8,    48.044000_r8,    48.044000_r8,    48.044000_r8, &
                             48.044000_r8,    48.044000_r8,    48.044000_r8,    36.033000_r8,    60.055000_r8, &
                             60.055000_r8,    60.055000_r8,    60.055000_r8,    60.055000_r8,    60.055000_r8, &
                             60.055000_r8,    60.055000_r8,    60.055000_r8,    60.055000_r8,    60.055000_r8, &
                             84.077000_r8,    84.077000_r8,    84.077000_r8,    84.077000_r8,    84.077000_r8, &
                             72.066000_r8,    72.066000_r8,    72.066000_r8,    96.088000_r8,    96.088000_r8, &
                             96.088000_r8,   120.110000_r8,   120.110000_r8,   120.110000_r8,    12.011000_r8, &
                             12.011000_r8,    12.011000_r8,    12.011000_r8,    24.022000_r8,    12.011000_r8, &
                             12.011000_r8,    24.022000_r8,    12.011000_r8,    12.011000_r8,    24.022000_r8, &
                             24.022000_r8,    24.022000_r8,    24.022000_r8,    12.011000_r8,    24.022000_r8, &
                             12.011000_r8,    12.011000_r8,    12.011000_r8,     0.000000_r8,    24.022000_r8, &
                             12.011000_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8, &
                             12.011000_r8,   120.110000_r8,    60.055000_r8,    84.077000_r8,    72.066000_r8, &
                             96.088000_r8,   120.110000_r8,    60.055000_r8,    84.077000_r8,    72.066000_r8, &
                             96.088000_r8,    12.011000_r8,     0.000000_r8,    24.022000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,    12.011000_r8,    12.011000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8 /)

      fix_mass(:  3) = (/ 0.00000000_r8, 28.0134800_r8, 31.9988000_r8 /)

      clsmap(: 37,1) = (/  167,  12,   4, 105, 106, 107, 108, 109, 117, 118, &
                           110, 115, 116, 111, 112, 113, 114, 119, 120, 121, &
                           122, 123,  23,  24, 168, 169, 170, 157, 158, 159, &
                           160, 161, 162, 163, 164, 165, 166 /)
      clsmap(:133,4) = (/    1,   2,   3,  18,  17,   5,   6,   7,  20,   8, &
                             9,  10,  11,  13,  14,  39,  40,  16,  19,  21, &
                            22, 124,  25,  26,  27,  28,  29,  30,  31,  32, &
                            33,  34,  35,  36,  37,  38,  56,  80,  61,  47, &
                            46,  62,  45,  51,  55,  79,  42,  41,  68,  78, &
                            67,  70,  81,  82,  69,  71,  72,  91,  92,  93, &
                            94,  95, 103, 104,  83,  50,  96,  97,  98,  99, &
                           100, 101,  85,  74,  75,  76,  77,  73,  43,  44, &
                           102,  57,  58,  59,  60,  66,  15,  48,  49,  63, &
                            52,  53,  54,  84,  64,  65,  86,  87,  88,  89, &
                            90, 125, 126, 127, 142, 143, 144, 145, 146, 147, &
                           148, 132, 133, 134, 135, 136, 137, 138, 139, 140, &
                           141, 128, 129, 130, 131, 149, 150, 151, 152, 153, &
                           154, 155, 156 /)

      permute(:133,4) = (/  122, 130, 124, 104, 105,  43, 133, 123, 128, 125, &
                             95,  65,  53, 119,  66,  44,  33, 121, 118, 126, &
                             82, 117, 129,  41, 131,  40,  34, 127,  97,  99, &
                             45, 132, 120,  94,  92,  76, 103, 100,  89, 107, &
                             83,  72, 116,  71,  68,  64,  52,  74,  28,  77, &
                             29,  57,  87,  84,  67,  85,  54,  36,  37,  79, &
                             59,  42, 102,  70,  80,  90,  30,  60,   1,  31, &
                             69,   2, 114, 112, 109, 113,  55, 115,  91,  56, &
                             81,  35,  96,  61,  88,  62,  73,  48,  98, 108, &
                             86,  49,  38,  58, 106, 110,  93, 101, 111,  50, &
                             78,  51,  75,  63,  46,  39,  47,   3,  32,   4, &
                              5,   6,   7,   8,   9,  10,  11,  12,  13,  14, &
                             15,  16,  17,  18,  19,  20,  21,  22,  23,  24, &
                             25,  26,  27 /)

      diag_map(:133) = (/    1,   2,   3,   4,   5,   6,   7,   8,   9,  10, &
                            11,  12,  13,  14,  15,  16,  18,  19,  21,  22, &
                            23,  24,  25,  26,  27,  28,  29,  30,  33,  36, &
                            39,  42,  45,  48,  51,  55,  60,  63,  67,  69, &
                            72,  74,  78,  82,  86,  90,  96, 101, 105, 109, &
                           113, 119, 125, 131, 136, 141, 146, 153, 156, 163, &
                           169, 175, 181, 187, 191, 197, 203, 208, 216, 223, &
                           230, 236, 244, 248, 256, 260, 268, 276, 285, 293, &
                           299, 308, 315, 320, 331, 340, 351, 362, 369, 378, &
                           385, 394, 402, 412, 419, 426, 438, 446, 454, 465, &
                           483, 493, 507, 521, 529, 535, 548, 557, 564, 577, &
                           592, 608, 629, 654, 672, 699, 711, 720, 752, 772, &
                           793, 832, 867, 887, 930,1002,1024,1120,1153,1180, &
                          1204,1223,1277 /)

      extfrc_lst(:  9) = (/ 'NO              ','NO2             ','CO              ','SO2             ','SO4             ', &
                            'CB1             ','N               ','OH              ','AOA_NH          ' /)

      frc_from_dataset(:  9) = (/ .true., .true., .true., .true., .true., &
                                  .true., .false., .false., .false. /)

      inv_lst(:  3) = (/ 'M               ', 'N2              ', 'O2              ' /)

      if( allocated( rxt_tag_lst ) ) then
         deallocate( rxt_tag_lst )
      end if
      allocate( rxt_tag_lst(rxt_tag_cnt),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate rxt_tag_lst; error = ',ios
         call endrun
      end if
      if( allocated( rxt_tag_map ) ) then
         deallocate( rxt_tag_map )
      end if
      allocate( rxt_tag_map(rxt_tag_cnt),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate rxt_tag_map; error = ',ios
         call endrun
      end if
      rxt_tag_lst(:rxt_tag_cnt) = (/ 'jo2_b           ', 'jo3_a           ', 'jo3_b           ', 'jn2o            ', &
                                     'jno             ', 'jno2            ', 'jn2o5_a         ', 'jn2o5_b         ', &
                                     'jhno3           ', 'jno3_a          ', 'jno3_b          ', 'jho2no2_a       ', &
                                     'jho2no2_b       ', 'jch3ooh         ', 'jch2o_a         ', 'jch2o_b         ', &
                                     'jh2o_a          ', 'jh2o_b          ', 'jh2o_c          ', 'jh2o2           ', &
                                     'jcl2            ', 'jclo            ', 'joclo           ', 'jcl2o2          ', &
                                     'jhocl           ', 'jhcl            ', 'jclono2_a       ', 'jclono2_b       ', &
                                     'jbrcl           ', 'jbro            ', 'jhobr           ', 'jhbr            ', &
                                     'jbrono2_a       ', 'jbrono2_b       ', 'jch3cl          ', 'jccl4           ', &
                                     'jch3ccl3        ', 'jcfcl3          ', 'jcf2cl2         ', 'jcfc113         ', &
                                     'jhcfc22         ', 'jcfc114         ', 'jcfc115         ', 'jhcfc141b       ', &
                                     'jhcfc142b       ', 'jch3br          ', 'jcf3br          ', 'jh1202          ', &
                                     'jh2402          ', 'jcf2clbr        ', 'jchbr3          ', 'jch2br2         ', &
                                     'jco2            ', 'jch4_a          ', 'jch4_b          ', 'jch3cho         ', &
                                     'jpooh           ', 'jch3co3h        ', 'jpan            ', 'jmpan           ', &
                                     'jmacr_a         ', 'jmacr_b         ', 'jmvk            ', 'jc2h5ooh        ', &
                                     'jeooh           ', 'jc3h7ooh        ', 'jrooh           ', 'jacet           ', &
                                     'jmgly           ', 'jxooh           ', 'jonitr          ', 'jisopooh        ', &
                                     'jhyac           ', 'jglyald         ', 'jmek            ', 'jbigald         ', &
                                     'jglyoxal        ', 'jalkooh         ', 'jmekooh         ', 'jtolooh         ', &
                                     'jterpooh        ', 'jsf6            ', 'jsf6em          ', 'jocs            ', &
                                     'usr_O_O2        ', 'O_O3            ', 'usr_O_O         ', 'O1D_N2          ', &
                                     'O1D_O2b         ', 'O1D_H2O         ', 'O1D_N2Oa        ', 'O1D_N2Ob        ', &
                                     'O1D_O3          ', 'O1D_CFC11       ', 'O1D_CFC12       ', 'O1D_CFC113      ', &
                                     'O1D_CFC114      ', 'O1D_CFC115      ', 'O1D_HCFC22      ', 'O1D_HCFC141B    ', &
                                     'O1D_HCFC142B    ', 'O1D_CCL4        ', 'O1D_CH3BR       ', 'O1D_CF2CLBR     ', &
                                     'O1D_CF3BR       ', 'O1D_H1202       ', 'O1D_H2402       ', 'O1D_CHBR3       ', &
                                     'O1D_CH2BR2      ', 'O1D_CH4a        ', 'O1D_CH4b        ', 'O1D_CH4c        ', &
                                     'O1D_H2          ', 'O1D_HCL         ', 'O1D_HBR         ', 'O1D_HCN         ', &
                                     'H_O2            ', 'H_O3            ', 'H_HO2a          ', 'H_HO2b          ', &
                                     'H_HO2c          ', 'OH_O            ', 'OH_O3           ', 'OH_HO2          ', &
                                     'OH_OH           ', 'OH_OH_M         ', 'OH_H2           ', 'OH_H2O2         ', &
                                     'H2_O            ', 'HO2_O           ', 'HO2_O3          ', 'usr_HO2_HO2     ', &
                                     'H2O2_O          ', 'HCN_OH          ', 'CH3CN_OH        ', 'N_O2            ', &
                                     'N_NO            ', 'N_NO2a          ', 'N_NO2b          ', 'N_NO2c          ', &
                                     'NO_O_M          ', 'NO_HO2          ', 'NO_O3           ', 'NO2_O           ', &
                                     'NO2_O_M         ', 'NO2_O3          ', 'tag_NO2_NO3     ', 'usr_N2O5_M      ', &
                                     'tag_NO2_OH      ', 'usr_HNO3_OH     ', 'NO3_NO          ', 'NO3_O           ', &
                                     'NO3_OH          ', 'NO3_HO2         ', 'tag_NO2_HO2     ', 'HO2NO2_OH       ', &
                                     'usr_HO2NO2_M    ', 'CL_O3           ', 'CL_H2           ', 'CL_H2O2         ', &
                                     'CL_HO2a         ', 'CL_HO2b         ', 'CL_CH2O         ', 'CL_CH4          ', &
                                     'CLO_O           ', 'CLO_OHa         ', 'CLO_OHb         ', 'CLO_HO2         ', &
                                     'CLO_CH3O2       ', 'CLO_NO          ', 'CLO_NO2_M       ', 'CLO_CLOa        ', &
                                     'CLO_CLOb        ', 'CLO_CLOc        ', 'tag_CLO_CLO_M   ', 'usr_CL2O2_M     ', &
                                     'HCL_OH          ', 'HCL_O           ', 'HOCL_O          ', 'HOCL_CL         ', &
                                     'HOCL_OH         ', 'CLONO2_O        ', 'CLONO2_OH       ', 'CLONO2_CL       ', &
                                     'BR_O3           ', 'BR_HO2          ', 'BR_CH2O         ', 'BRO_O           ', &
                                     'BRO_OH          ', 'BRO_HO2         ', 'BRO_NO          ', 'BRO_NO2_M       ', &
                                     'BRO_CLOa        ', 'BRO_CLOb        ', 'BRO_CLOc        ', 'BRO_BRO         ', &
                                     'HBR_OH          ', 'HBR_O           ', 'HOBR_O          ', 'BRONO2_O        ', &
                                     'CH3CL_CL        ', 'CH3CL_OH        ', 'CH3CCL3_OH      ', 'HCFC22_OH       ', &
                                     'CH3BR_OH        ', 'CH3BR_CL        ', 'HCFC141B_OH     ', 'HCFC142B_OH     ', &
                                     'CH2BR2_OH       ', 'CHBR3_OH        ', 'CH2BR2_CL       ', 'CHBR3_CL        ', &
                                     'CH4_OH          ', 'usr_CO_OH_b     ', 'CO_OH_M         ', 'CH2O_NO3        ', &
                                     'CH2O_OH         ', 'CH2O_O          ', 'CH2O_HO2        ', 'CH3O2_NO        ', &
                                     'CH3O2_HO2       ', 'CH3O2_CH3O2a    ', 'CH3O2_CH3O2b    ', 'CH3OH_OH        ', &
                                     'CH3OOH_OH       ', 'HCOOH_OH        ', 'HOCH2OO_M       ', 'HOCH2OO_NO      ', &
                                     'HOCH2OO_HO2     ', 'C2H2_CL_M       ', 'C2H4_CL_M       ', 'C2H6_CL         ', &
                                     'C2H2_OH_M       ', 'C2H6_OH         ', 'tag_C2H4_OH     ', 'EO2_NO          ', &
                                     'EO2_HO2         ', 'EO_O2           ', 'EO_M            ', 'C2H4_O3         ', &
                                     'CH3COOH_OH      ', 'C2H5O2_NO       ', 'C2H5O2_HO2      ', 'C2H5O2_CH3O2    ', &
                                     'C2H5O2_C2H5O2   ', 'C2H5OOH_OH      ', 'CH3CHO_OH       ', 'CH3CHO_NO3      ', &
                                     'CH3CO3_NO       ', 'tag_CH3CO3_NO2  ', 'CH3CO3_HO2      ', 'CH3CO3_CH3O2    ', &
                                     'CH3CO3_CH3CO3   ', 'CH3COOOH_OH     ', 'GLYALD_OH       ', 'GLYOXAL_OH      ', &
                                     'C2H5OH_OH       ', 'usr_PAN_M       ', 'PAN_OH          ', 'tag_C3H6_OH     ', &
                                     'C3H6_O3         ', 'C3H6_NO3        ', 'C3H7O2_NO       ', 'C3H7O2_HO2      ', &
                                     'CH3H7O2_CH3O2   ', 'CH3H7OOH_OH     ', 'C3H8_OH         ', 'PO2_NO          ', &
                                     'PO2_HO2         ', 'POOH_OH         ', 'usr_CH3COCH3_OH ', 'RO2_NO          ', &
                                     'RO2_HO2         ', 'RO2_CH3O2       ', 'ROOH_OH         ', 'HYAC_OH         ', &
                                     'CH3COCHO_OH     ', 'CH3COCHO_NO3    ', 'ONIT_OH         ', 'BIGENE_OH       ', &
                                     'ENEO2_NO        ', 'MVK_OH          ', 'MVK_O3          ', 'MEK_OH          ', &
                                     'MEKO2_NO        ', 'MEKO2_HO2       ', 'MEKOOH_OH       ', 'MACR_OH         ', &
                                     'MACR_O3         ', 'MACRO2_NOa      ', 'MACRO2_NOb      ', 'MACRO2_NO3      ', &
                                     'MACRO2_HO2      ', 'MACRO2_CH3O2    ', 'MACRO2_CH3CO3   ', 'MACROOH_OH      ', &
                                     'MCO3_NO         ', 'MCO3_NO3        ', 'MCO3_HO2        ', 'MCO3_CH3O2      ', &
                                     'MCO3_CH3CO3     ', 'MCO3_MCO3       ', 'usr_MCO3_NO2    ', 'usr_MPAN_M      ', &
                                     'MPAN_OH_M       ', 'ISOP_OH         ', 'ISOP_O3         ', 'ISOP_NO3        ', &
                                     'ISOPO2_NO       ', 'ISOPO2_NO3      ', 'ISOPO2_HO2      ', 'ISOPOOH_OH      ', &
                                     'ISOPO2_CH3O2    ', 'ISOPO2_CH3CO3   ', 'ISOPNO3_NO      ', 'ISOPNO3_NO3     ', &
                                     'ISOPNO3_HO2     ', 'BIGALK_OH       ', 'ONITR_OH        ', 'ONITR_NO3       ', &
                                     'HYDRALD_OH      ', 'ALKO2_NO        ', 'ALKO2_HO2       ', 'ALKOOH_OH       ', &
                                     'XO2_NO          ', 'XO2_NO3         ', 'XO2_HO2         ', 'XO2_CH3O2       ', &
                                     'XO2_CH3CO3      ', 'XOOH_OHa        ', 'usr_XOOH_OH     ', 'TOLUENE_OH      ', &
                                     'TOLO2_NO        ', 'TOLO2_HO2       ', 'TOLO2_OH        ', 'CRESOL_OH       ', &
                                     'XOH_NO2         ', 'BENZENE_OH      ', 'BENO2_HO2       ', 'BENO2_NO        ', &
                                     'XYLENE_OH       ', 'XYLO2_HO2       ', 'XYLO2_NO        ', 'C10H16_OH       ', &
                                     'C10H16_O3       ', 'C10H16_NO3      ', 'TERPO2_NO       ', 'TERPO2_HO2      ', &
                                     'TERPOOH_OH      ', 'usr_N2O5_aer    ', 'usr_NO3_aer     ', 'usr_NO2_aer     ', &
                                     'CB1_CB2         ', 'usr_SO2_OH      ', 'DMS_OHa         ', 'usr_DMS_OH      ', &
                                     'DMS_NO3         ', 'NH3_OH          ', 'OC1_OC2         ', 'usr_HO2_aer     ', &
                                     'OCS_O           ', 'OCS_OH          ', 'usr_CB1_strat_ta', 'usr_CB2_strat_ta', &
                                     'usr_OC1_strat_ta', 'usr_OC2_strat_ta', 'usr_SO4_strat_ta', 'usr_SOAM_strat_t', &
                                     'usr_SOAI_strat_t', 'usr_SOAB_strat_t', 'usr_SOAT_strat_t', 'usr_SOAX_strat_t', &
                                     'usr_NH4_strat_ta', 'usr_NH4NO3_strat', 'usr_SSLT01_strat', 'usr_SSLT02_strat', &
                                     'usr_SSLT03_strat', 'usr_SSLT04_strat', 'usr_DST01_strat_', 'usr_DST02_strat_', &
                                     'usr_DST03_strat_', 'usr_DST04_strat_', 'usr_SO2t_strat_t', 'het1            ', &
                                     'het2            ', 'het3            ', 'het4            ', 'het5            ', &
                                     'het6            ', 'het7            ', 'het8            ', 'het9            ', &
                                     'het10           ', 'het11           ', 'het12           ', 'het13           ', &
                                     'het14           ', 'het15           ', 'het16           ', 'het17           ', &
                                     'NH_5_tau        ', 'NH_50_tau       ', 'NH_50W_tau      ', 'ST80_25_tau     ', &
                                     'CO_25_tau       ', 'CO_50_tau       ', 'E90_tau         ', 'E90_NH_tau      ', &
                                     'E90_SH_tau      ' /)
      rxt_tag_map(:rxt_tag_cnt) = (/    1,   2,   3,   4,   5,   6,   7,   8,   9,  10, &
                                       11,  12,  13,  14,  15,  16,  17,  18,  19,  20, &
                                       21,  22,  23,  24,  25,  26,  27,  28,  29,  30, &
                                       31,  32,  33,  34,  35,  36,  37,  38,  39,  40, &
                                       41,  42,  43,  44,  45,  46,  47,  48,  49,  50, &
                                       51,  52,  53,  54,  55,  56,  57,  58,  59,  60, &
                                       61,  62,  63,  64,  65,  66,  67,  68,  69,  70, &
                                       71,  72,  73,  74,  75,  76,  77,  78,  79,  80, &
                                       81,  82,  83,  84,  85,  86,  87,  88,  89,  90, &
                                       91,  92,  93,  94,  95,  96,  97,  98,  99, 100, &
                                      101, 102, 103, 104, 105, 106, 107, 108, 109, 110, &
                                      111, 112, 113, 114, 115, 116, 117, 118, 119, 120, &
                                      121, 122, 123, 124, 125, 126, 127, 128, 129, 130, &
                                      131, 132, 133, 134, 135, 136, 137, 138, 139, 140, &
                                      141, 142, 143, 144, 145, 146, 147, 148, 149, 150, &
                                      151, 152, 153, 154, 155, 156, 157, 158, 159, 160, &
                                      161, 162, 163, 164, 165, 166, 167, 168, 169, 170, &
                                      171, 172, 173, 174, 175, 176, 177, 178, 179, 180, &
                                      181, 182, 183, 184, 185, 186, 187, 188, 189, 190, &
                                      191, 192, 193, 194, 195, 196, 197, 198, 199, 200, &
                                      201, 202, 203, 204, 205, 206, 207, 208, 209, 210, &
                                      211, 212, 213, 214, 215, 216, 217, 218, 219, 220, &
                                      221, 222, 223, 224, 225, 226, 227, 228, 229, 230, &
                                      231, 232, 233, 234, 235, 236, 237, 238, 239, 240, &
                                      241, 242, 243, 244, 245, 246, 247, 248, 249, 250, &
                                      251, 252, 253, 254, 255, 256, 257, 258, 259, 260, &
                                      261, 262, 263, 264, 265, 266, 267, 268, 269, 270, &
                                      271, 272, 273, 274, 275, 276, 277, 278, 279, 280, &
                                      281, 282, 283, 284, 285, 286, 287, 288, 289, 290, &
                                      291, 292, 293, 294, 295, 296, 297, 298, 299, 300, &
                                      301, 302, 303, 304, 305, 306, 307, 308, 309, 310, &
                                      311, 312, 313, 314, 315, 316, 317, 318, 319, 320, &
                                      321, 322, 323, 324, 325, 326, 327, 328, 329, 330, &
                                      331, 332, 333, 334, 335, 336, 337, 338, 339, 340, &
                                      341, 342, 343, 344, 345, 346, 347, 348, 349, 350, &
                                      351, 352, 353, 354, 355, 356, 357, 358, 359, 360, &
                                      361, 362, 363, 364, 365, 366, 367, 368, 369, 370, &
                                      371, 372, 373, 374, 375, 376, 377, 378, 379, 380, &
                                      381, 382, 383, 384, 385, 386, 387, 388, 389, 390, &
                                      391, 392, 393, 394, 395, 396, 397, 398, 399, 400, &
                                      401, 402, 403, 404, 405, 406, 407, 408, 409 /)
      if( allocated( pht_alias_lst ) ) then
         deallocate( pht_alias_lst )
      end if
      allocate( pht_alias_lst(phtcnt,2),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate pht_alias_lst; error = ',ios
         call endrun
      end if
      if( allocated( pht_alias_mult ) ) then
         deallocate( pht_alias_mult )
      end if
      allocate( pht_alias_mult(phtcnt,2),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate pht_alias_mult; error = ',ios
         call endrun
      end if
      pht_alias_lst(:,1) = (/ 'userdefined     ', '                ', '                ', '                ', &
                              'userdefined     ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', 'jsf6            ', '                ' /)
      pht_alias_lst(:,2) = (/ '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              'jch3ooh         ', 'jh2o2           ', '                ', 'jpan            ', &
                              '                ', '                ', '                ', 'jch3ooh         ', &
                              'jch3ooh         ', 'jch3ooh         ', 'jch3ooh         ', '                ', &
                              '                ', 'jch3ooh         ', 'jch3cho         ', 'jch3ooh         ', &
                              '                ', '                ', 'jacet           ', 'jno2            ', &
                              'jmgly           ', 'jch3ooh         ', 'jch3ooh         ', 'jch3ooh         ', &
                              'jch3ooh         ', '                ', 'jsf6            ', '                ' /)
      pht_alias_mult(:,1) = (/ 1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8 /)
      pht_alias_mult(:,2) = (/ 1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 0.28_r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          0.2_r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8 /)

      end subroutine set_sim_dat

      end module mo_sim_dat
