




      module mo_nln_matrix

      use shr_kind_mod, only : r8 => shr_kind_r8

      private
      public :: nlnmat

      contains

      subroutine nlnmat01( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(1223) = -(rxt(116)*y(2) + rxt(134)*y(3) + rxt(161)*y(22) + rxt(166)*y(23) &
                      + rxt(174)*y(24) + rxt(189)*y(9) + rxt(192)*y(10) + rxt(204) &
                      *y(28) + rxt(231)*y(37) + rxt(290)*y(44) + rxt(311)*y(59) &
                      + rxt(333)*y(77) + rxt(339)*y(78) + rxt(357)*y(83) + rxt(395) &
                      *y(105))
         mat(1464) = -rxt(116)*y(1)
         mat(1358) = -rxt(134)*y(1)
         mat(1261) = -rxt(161)*y(1)
         mat(1180) = -rxt(166)*y(1)
         mat(1334) = -rxt(174)*y(1)
         mat(976) = -rxt(189)*y(1)
         mat(1393) = -rxt(192)*y(1)
         mat(1427) = -rxt(204)*y(1)
         mat(918) = -rxt(231)*y(1)
         mat(260) = -rxt(290)*y(1)
         mat(605) = -rxt(311)*y(1)
         mat(760) = -rxt(333)*y(1)
         mat(651) = -rxt(339)*y(1)
         mat(547) = -rxt(357)*y(1)
         mat(324) = -rxt(395)*y(1)

         mat(1223) = mat(1223) + .100_r8*rxt(357)*y(83) + .200_r8*rxt(333)*y(77) &
                      + .200_r8*rxt(339)*y(78)
         mat(1464) = mat(1464) + rxt(115)*y(4)
         mat(846) = rxt(115)*y(2)
         mat(1334) = mat(1334) + .250_r8*rxt(301)*y(48) + .250_r8*rxt(349)*y(76)
         mat(547) = mat(547) + .100_r8*rxt(357)*y(1)
         mat(807) = .250_r8*rxt(301)*y(24)
         mat(760) = mat(760) + .200_r8*rxt(333)*y(1)
         mat(651) = mat(651) + .200_r8*rxt(339)*y(1)
         mat(779) = .250_r8*rxt(349)*y(24)

         mat(1471) = -(rxt(115)*y(4) + rxt(116)*y(1) + 4._r8*rxt(117)*y(2) + rxt(165) &
                      *y(23) + rxt(172)*y(21) + rxt(173)*y(24) + rxt(176)*y(25) &
                      + rxt(187)*y(9) + (rxt(190) + rxt(191)) * y(10) + rxt(198)*y(11) &
                      + rxt(211)*y(30) + rxt(224)*y(33) + rxt(225)*y(34) + rxt(228) &
                      *y(35) + rxt(234)*y(38) + rxt(244)*y(39) + rxt(245)*y(40) &
                      + rxt(246)*y(41) + rxt(268)*y(19) + (rxt(451) + rxt(452) &
                      ) * y(127) + rxt(458)*y(129))
         mat(852) = -rxt(115)*y(2)
         mat(1230) = -rxt(116)*y(2)
         mat(1187) = -rxt(165)*y(2)
         mat(667) = -rxt(172)*y(2)
         mat(1341) = -rxt(173)*y(2)
         mat(344) = -rxt(176)*y(2)
         mat(983) = -rxt(187)*y(2)
         mat(1400) = -(rxt(190) + rxt(191)) * y(2)
         mat(1024) = -rxt(198)*y(2)
         mat(904) = -rxt(211)*y(2)
         mat(1088) = -rxt(224)*y(2)
         mat(517) = -rxt(225)*y(2)
         mat(590) = -rxt(228)*y(2)
         mat(829) = -rxt(234)*y(2)
         mat(483) = -rxt(244)*y(2)
         mat(409) = -rxt(245)*y(2)
         mat(278) = -rxt(246)*y(2)
         mat(1251) = -rxt(268)*y(2)
         mat(375) = -(rxt(451) + rxt(452)) * y(2)
         mat(229) = -rxt(458)*y(2)

         mat(1365) = (rxt(129)+rxt(130))*y(4)
         mat(852) = mat(852) + (rxt(129)+rxt(130))*y(3) + rxt(182)*y(8) + rxt(457) &
                      *y(129) + rxt(449)*y(130)
         mat(497) = rxt(182)*y(4) + rxt(183)*y(9) + rxt(184)*y(10) + rxt(454)*y(128)
         mat(983) = mat(983) + rxt(183)*y(8)
         mat(1400) = mat(1400) + rxt(184)*y(8)
         mat(1187) = mat(1187) + 2.000_r8*rxt(168)*y(23)
         mat(1268) = rxt(164)*y(24)
         mat(1341) = mat(1341) + rxt(164)*y(22)
         mat(427) = rxt(454)*y(8) + 1.150_r8*rxt(462)*y(132)
         mat(229) = mat(229) + rxt(457)*y(4)
         mat(337) = rxt(449)*y(4)
         mat(435) = rxt(461)*y(132)
         mat(446) = 1.150_r8*rxt(462)*y(128) + rxt(461)*y(131)

         mat(1362) = -((rxt(129) + rxt(130)) * y(4) + rxt(131)*y(134) + rxt(134)*y(1) &
                      + rxt(151)*y(138) + rxt(152)*y(139) + rxt(156)*y(21) + rxt(157) &
                      *y(33) + rxt(158)*y(39) + rxt(159)*y(42))
         mat(850) = -(rxt(129) + rxt(130)) * y(3)
         mat(863) = -rxt(131)*y(3)
         mat(1227) = -rxt(134)*y(3)
         mat(74) = -rxt(151)*y(3)
         mat(88) = -rxt(152)*y(3)
         mat(665) = -rxt(156)*y(3)
         mat(1085) = -rxt(157)*y(3)
         mat(482) = -rxt(158)*y(3)
         mat(93) = -rxt(159)*y(3)

         mat(850) = mat(850) + rxt(179)*y(133)
         mat(426) = .850_r8*rxt(462)*y(132)
         mat(254) = rxt(179)*y(4)
         mat(445) = .850_r8*rxt(462)*y(128)

         mat(843) = -(rxt(115)*y(2) + rxt(125)*y(6) + rxt(129)*y(3) + rxt(160)*y(22) &
                      + rxt(179)*y(133) + rxt(182)*y(8) + rxt(288)*y(56) + rxt(449) &
                      *y(130) + (rxt(456) + rxt(457)) * y(129) + rxt(459)*y(127))
         mat(1454) = -rxt(115)*y(4)
         mat(76) = -rxt(125)*y(4)
         mat(1349) = -rxt(129)*y(4)
         mat(1253) = -rxt(160)*y(4)
         mat(252) = -rxt(179)*y(4)
         mat(491) = -rxt(182)*y(4)
         mat(205) = -rxt(288)*y(4)
         mat(336) = -rxt(449)*y(4)
         mat(228) = -(rxt(456) + rxt(457)) * y(4)
         mat(372) = -rxt(459)*y(4)

         mat(1213) = 2.000_r8*rxt(116)*y(2) + 2.000_r8*rxt(134)*y(3) + rxt(189)*y(9) &
                      + rxt(192)*y(10) + rxt(166)*y(23) + rxt(161)*y(22) &
                      + 2.000_r8*rxt(174)*y(24) + rxt(204)*y(28) + rxt(231)*y(37)
         mat(1454) = mat(1454) + 2.000_r8*rxt(116)*y(1) + 2.000_r8*rxt(117)*y(2) &
                      + rxt(124)*y(6) + rxt(190)*y(10) + rxt(165)*y(23) + rxt(198) &
                      *y(11) + rxt(173)*y(24) + rxt(211)*y(30) + rxt(234)*y(38)
         mat(1349) = mat(1349) + 2.000_r8*rxt(134)*y(1)
         mat(843) = mat(843) + 2.000_r8*rxt(125)*y(6)
         mat(76) = mat(76) + rxt(124)*y(2) + 2.000_r8*rxt(125)*y(4)
         mat(491) = mat(491) + rxt(186)*y(10)
         mat(966) = rxt(189)*y(1) + rxt(455)*y(128)
         mat(1383) = rxt(192)*y(1) + rxt(190)*y(2) + rxt(186)*y(8)
         mat(1170) = rxt(166)*y(1) + rxt(165)*y(2) + rxt(202)*y(13) + rxt(167)*y(24) &
                      + rxt(213)*y(30)
         mat(1009) = rxt(198)*y(2) + rxt(200)*y(24)
         mat(231) = rxt(202)*y(23)
         mat(1047) = rxt(271)*y(24)
         mat(1253) = mat(1253) + rxt(161)*y(1) + rxt(163)*y(24)
         mat(1324) = 2.000_r8*rxt(174)*y(1) + rxt(173)*y(2) + rxt(167)*y(23) &
                      + rxt(200)*y(11) + rxt(271)*y(16) + rxt(163)*y(22) &
                      + 2.000_r8*rxt(175)*y(24) + rxt(207)*y(28) + rxt(214)*y(30) &
                      + rxt(232)*y(37) + rxt(236)*y(38) + rxt(319)*y(64) &
                      + .750_r8*rxt(349)*y(76) + rxt(293)*y(46) + rxt(314)*y(61) &
                      + rxt(323)*y(67)
         mat(1417) = rxt(204)*y(1) + rxt(207)*y(24)
         mat(887) = rxt(211)*y(2) + rxt(213)*y(23) + rxt(214)*y(24) + ( &
                      + 2.000_r8*rxt(218)+2.000_r8*rxt(219))*y(30) + (rxt(240) &
                       +rxt(241))*y(38)
         mat(908) = rxt(231)*y(1) + rxt(232)*y(24)
         mat(817) = rxt(234)*y(2) + rxt(236)*y(24) + (rxt(240)+rxt(241))*y(30) &
                      + 2.000_r8*rxt(242)*y(38)
         mat(424) = rxt(455)*y(9)
         mat(470) = rxt(319)*y(24)
         mat(772) = .750_r8*rxt(349)*y(24)
         mat(503) = rxt(293)*y(24)
         mat(524) = rxt(314)*y(24)
         mat(629) = rxt(323)*y(24)

         mat(78) = -(rxt(118)*y(2) + rxt(119)*y(4) + rxt(121)*y(1))
         mat(1436) = -rxt(118)*y(5)
         mat(831) = -rxt(119)*y(5)
         mat(1189) = -rxt(121)*y(5)

         mat(1343) = rxt(129)*y(4)
         mat(831) = mat(831) + rxt(129)*y(3)

         mat(75) = -(rxt(124)*y(2) + rxt(125)*y(4))
         mat(1435) = -rxt(124)*y(6)
         mat(830) = -rxt(125)*y(6)

         mat(1188) = rxt(121)*y(5)
         mat(1435) = mat(1435) + rxt(118)*y(5)
         mat(830) = mat(830) + rxt(119)*y(5)
         mat(77) = rxt(121)*y(1) + rxt(118)*y(2) + rxt(119)*y(4)

         mat(657) = -(rxt(156)*y(3) + rxt(170)*y(23) + rxt(172)*y(2) + rxt(205)*y(28) &
                      + rxt(248)*y(141))
         mat(1348) = -rxt(156)*y(21)
         mat(1161) = -rxt(170)*y(21)
         mat(1452) = -rxt(172)*y(21)
         mat(1415) = -rxt(205)*y(21)
         mat(449) = -rxt(248)*y(21)

         mat(1252) = rxt(163)*y(24)
         mat(1315) = rxt(163)*y(22)

         mat(609) = -((rxt(264) + rxt(265)) * y(23))
         mat(1156) = -(rxt(264) + rxt(265)) * y(20)

         mat(1200) = .560_r8*rxt(311)*y(59) + .300_r8*rxt(357)*y(83) &
                      + .500_r8*rxt(290)*y(44) + .050_r8*rxt(333)*y(77) &
                      + .200_r8*rxt(339)*y(78)
         mat(1451) = rxt(268)*y(19)
         mat(953) = .220_r8*rxt(340)*y(79) + .250_r8*rxt(375)*y(91)
         mat(1156) = mat(1156) + rxt(267)*y(19) + rxt(306)*y(53) + rxt(327)*y(68) &
                      + .350_r8*rxt(283)*y(135)
         mat(997) = rxt(266)*y(19) + .220_r8*rxt(342)*y(79) + rxt(328)*y(68) &
                      + .500_r8*rxt(376)*y(91)
         mat(1035) = .110_r8*rxt(344)*y(79) + .200_r8*rxt(378)*y(91)
         mat(1234) = rxt(268)*y(2) + rxt(267)*y(23) + rxt(266)*y(11) + rxt(209)*y(28) &
                      + rxt(233)*y(37)
         mat(1413) = rxt(209)*y(19)
         mat(906) = rxt(233)*y(19)
         mat(595) = .560_r8*rxt(311)*y(1)
         mat(537) = .300_r8*rxt(357)*y(1)
         mat(790) = .220_r8*rxt(345)*y(79) + .250_r8*rxt(379)*y(91)
         mat(258) = .500_r8*rxt(290)*y(1)
         mat(398) = rxt(306)*y(23)
         mat(745) = .050_r8*rxt(333)*y(1)
         mat(643) = .200_r8*rxt(339)*y(1)
         mat(727) = .220_r8*rxt(340)*y(9) + .220_r8*rxt(342)*y(11) + .110_r8*rxt(344) &
                      *y(16) + .220_r8*rxt(345)*y(48)
         mat(668) = rxt(327)*y(23) + rxt(328)*y(11)
         mat(681) = .250_r8*rxt(375)*y(9) + .500_r8*rxt(376)*y(11) + .200_r8*rxt(378) &
                      *y(16) + .250_r8*rxt(379)*y(48)
         mat(123) = .350_r8*rxt(283)*y(23)

         mat(489) = -(rxt(181)*y(23) + rxt(182)*y(4) + rxt(183)*y(9) + (rxt(184) &
                      + rxt(185) + rxt(186)) * y(10) + rxt(454)*y(128))
         mat(1146) = -rxt(181)*y(8)
         mat(840) = -rxt(182)*y(8)
         mat(947) = -rxt(183)*y(8)
         mat(1375) = -(rxt(184) + rxt(185) + rxt(186)) * y(8)
         mat(423) = -rxt(454)*y(8)

         mat(1448) = rxt(458)*y(129) + rxt(180)*y(133)
         mat(840) = mat(840) + rxt(456)*y(129)
         mat(370) = 1.100_r8*rxt(463)*y(132)
         mat(227) = rxt(458)*y(2) + rxt(456)*y(4)
         mat(431) = .200_r8*rxt(461)*y(132)
         mat(251) = rxt(180)*y(2)
         mat(441) = 1.100_r8*rxt(463)*y(127) + .200_r8*rxt(461)*y(131)


      end subroutine nlnmat01

      subroutine nlnmat02( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(971) = -(rxt(183)*y(8) + rxt(187)*y(2) + rxt(188)*y(24) + rxt(189)*y(1) &
                      + rxt(197)*y(11) + rxt(216)*y(30) + rxt(237)*y(38) + rxt(270) &
                      *y(16) + rxt(278)*y(137) + rxt(286)*y(55) + rxt(292)*y(46) &
                      + rxt(299)*y(48) + rxt(313)*y(61) + rxt(318)*y(64) + rxt(322) &
                      *y(67) + rxt(331)*y(73) + rxt(335)*y(74) + (rxt(340) + rxt(341) &
                      ) * y(79) + rxt(347)*y(76) + rxt(359)*y(88) + rxt(365)*y(89) &
                      + rxt(372)*y(84) + rxt(375)*y(91) + rxt(383)*y(96) + rxt(390) &
                      *y(100) + rxt(393)*y(103) + rxt(397)*y(106) + rxt(455)*y(128))
         mat(492) = -rxt(183)*y(9)
         mat(1459) = -rxt(187)*y(9)
         mat(1329) = -rxt(188)*y(9)
         mat(1218) = -rxt(189)*y(9)
         mat(1012) = -rxt(197)*y(9)
         mat(892) = -rxt(216)*y(9)
         mat(822) = -rxt(237)*y(9)
         mat(1052) = -rxt(270)*y(9)
         mat(188) = -rxt(278)*y(9)
         mat(415) = -rxt(286)*y(9)
         mat(504) = -rxt(292)*y(9)
         mat(803) = -rxt(299)*y(9)
         mat(526) = -rxt(313)*y(9)
         mat(472) = -rxt(318)*y(9)
         mat(631) = -rxt(322)*y(9)
         mat(135) = -rxt(331)*y(9)
         mat(360) = -rxt(335)*y(9)
         mat(736) = -(rxt(340) + rxt(341)) * y(9)
         mat(775) = -rxt(347)*y(9)
         mat(714) = -rxt(359)*y(9)
         mat(460) = -rxt(365)*y(9)
         mat(386) = -rxt(372)*y(9)
         mat(688) = -rxt(375)*y(9)
         mat(308) = -rxt(383)*y(9)
         mat(171) = -rxt(390)*y(9)
         mat(220) = -rxt(393)*y(9)
         mat(574) = -rxt(397)*y(9)
         mat(425) = -rxt(455)*y(9)

         mat(1459) = mat(1459) + rxt(190)*y(10)
         mat(844) = rxt(182)*y(8) + rxt(179)*y(133)
         mat(492) = mat(492) + rxt(182)*y(4) + 2.000_r8*rxt(185)*y(10) + rxt(181) &
                      *y(23)
         mat(1388) = rxt(190)*y(2) + 2.000_r8*rxt(185)*y(8)
         mat(1175) = rxt(181)*y(8)
         mat(253) = rxt(179)*y(4)

         mat(1398) = -((rxt(184) + rxt(185) + rxt(186)) * y(8) + (rxt(190) + rxt(191) &
                      ) * y(2) + rxt(192)*y(1) + rxt(193)*y(11) + rxt(195)*y(23) &
                      + rxt(201)*y(24) + rxt(217)*y(30) + rxt(238)*y(38) + rxt(300) &
                      *y(48) + rxt(353)*y(76) + rxt(387)*y(98))
         mat(496) = -(rxt(184) + rxt(185) + rxt(186)) * y(10)
         mat(1469) = -(rxt(190) + rxt(191)) * y(10)
         mat(1228) = -rxt(192)*y(10)
         mat(1022) = -rxt(193)*y(10)
         mat(1185) = -rxt(195)*y(10)
         mat(1339) = -rxt(201)*y(10)
         mat(902) = -rxt(217)*y(10)
         mat(827) = -rxt(238)*y(10)
         mat(811) = -rxt(300)*y(10)
         mat(783) = -rxt(353)*y(10)
         mat(85) = -rxt(387)*y(10)

         mat(1228) = mat(1228) + rxt(189)*y(9)
         mat(1469) = mat(1469) + rxt(187)*y(9) + rxt(198)*y(11)
         mat(981) = rxt(189)*y(1) + rxt(187)*y(2) + 2.000_r8*rxt(197)*y(11) + rxt(270) &
                      *y(16) + rxt(188)*y(24) + rxt(216)*y(30) + rxt(237)*y(38) &
                      + rxt(318)*y(64) + rxt(299)*y(48) + rxt(331)*y(73) &
                      + .900_r8*rxt(372)*y(84) + rxt(335)*y(74) + .900_r8*rxt(383) &
                      *y(96) + rxt(397)*y(106) + .900_r8*rxt(390)*y(100) &
                      + .900_r8*rxt(393)*y(103) + .920_r8*rxt(359)*y(88) + rxt(340) &
                      *y(79) + rxt(347)*y(76) + rxt(292)*y(46) + rxt(313)*y(61) &
                      + rxt(286)*y(55) + rxt(322)*y(67) + 1.206_r8*rxt(365)*y(89) &
                      + rxt(375)*y(91) + rxt(278)*y(137)
         mat(1398) = mat(1398) + .700_r8*rxt(387)*y(98)
         mat(1185) = mat(1185) + rxt(199)*y(11) + rxt(202)*y(13) + rxt(329)*y(82) &
                      + .400_r8*rxt(369)*y(90)
         mat(1022) = mat(1022) + rxt(198)*y(2) + 2.000_r8*rxt(197)*y(9) + rxt(199) &
                      *y(23) + rxt(200)*y(24) + rxt(360)*y(88) + rxt(342)*y(79) &
                      + rxt(348)*y(76) + rxt(396)*y(105) + 1.206_r8*rxt(366)*y(89) &
                      + rxt(370)*y(90) + rxt(376)*y(91)
         mat(236) = rxt(202)*y(23)
         mat(1062) = rxt(270)*y(9)
         mat(1339) = mat(1339) + rxt(188)*y(9) + rxt(200)*y(11) + .206_r8*rxt(367) &
                      *y(89)
         mat(902) = mat(902) + rxt(216)*y(9)
         mat(827) = mat(827) + rxt(237)*y(9)
         mat(476) = rxt(318)*y(9)
         mat(811) = mat(811) + rxt(299)*y(9)
         mat(160) = rxt(329)*y(23)
         mat(138) = rxt(331)*y(9)
         mat(390) = .900_r8*rxt(372)*y(9)
         mat(363) = rxt(335)*y(9)
         mat(311) = .900_r8*rxt(383)*y(9)
         mat(85) = mat(85) + .700_r8*rxt(387)*y(10)
         mat(578) = rxt(397)*y(9)
         mat(173) = .900_r8*rxt(390)*y(9)
         mat(222) = .900_r8*rxt(393)*y(9)
         mat(722) = .920_r8*rxt(359)*y(9) + rxt(360)*y(11)
         mat(743) = rxt(340)*y(9) + rxt(342)*y(11)
         mat(783) = mat(783) + rxt(347)*y(9) + rxt(348)*y(11)
         mat(509) = rxt(292)*y(9)
         mat(326) = rxt(396)*y(11)
         mat(531) = rxt(313)*y(9)
         mat(419) = rxt(286)*y(9)
         mat(636) = rxt(322)*y(9)
         mat(465) = 1.206_r8*rxt(365)*y(9) + 1.206_r8*rxt(366)*y(11) &
                      + .206_r8*rxt(367)*y(24)
         mat(565) = .400_r8*rxt(369)*y(23) + rxt(370)*y(11)
         mat(695) = rxt(375)*y(9) + rxt(376)*y(11)
         mat(191) = rxt(278)*y(9)

         mat(1179) = -(rxt(165)*y(2) + rxt(166)*y(1) + rxt(167)*y(24) + (4._r8*rxt(168) &
                      + 4._r8*rxt(169)) * y(23) + rxt(170)*y(21) + rxt(171)*y(25) &
                      + rxt(177)*y(42) + rxt(178)*y(43) + rxt(181)*y(8) + rxt(195) &
                      *y(10) + rxt(196)*y(12) + rxt(199)*y(11) + rxt(202)*y(13) &
                      + (rxt(212) + rxt(213)) * y(30) + rxt(223)*y(33) + rxt(227) &
                      *y(34) + rxt(229)*y(35) + rxt(235)*y(38) + rxt(243)*y(39) &
                      + (rxt(264) + rxt(265)) * y(20) + rxt(267)*y(19) + rxt(274) &
                      *y(18) + rxt(275)*y(17) + rxt(276)*y(136) + rxt(283)*y(135) &
                      + rxt(284)*y(45) + rxt(285)*y(44) + rxt(291)*y(49) + rxt(296) &
                      *y(47) + rxt(297)*y(50) + rxt(304)*y(54) + rxt(305)*y(52) &
                      + rxt(306)*y(53) + rxt(307)*y(51) + rxt(309)*y(58) + rxt(310) &
                      *y(59) + rxt(316)*y(62) + rxt(317)*y(60) + rxt(320)*y(65) &
                      + rxt(321)*y(63) + rxt(325)*y(69) + rxt(326)*y(66) + rxt(327) &
                      *y(68) + rxt(329)*y(82) + rxt(330)*y(70) + rxt(332)*y(77) &
                      + rxt(334)*y(72) + rxt(337)*y(75) + rxt(338)*y(78) + rxt(346) &
                      *y(80) + rxt(355)*y(81) + rxt(356)*y(83) + rxt(362)*y(93) &
                      + rxt(368)*y(71) + rxt(369)*y(90) + rxt(371)*y(87) + rxt(374) &
                      *y(85) + rxt(380)*y(92) + rxt(382)*y(94) + rxt(385)*y(97) &
                      + rxt(386)*y(95) + rxt(388)*y(99) + rxt(391)*y(102) + rxt(394) &
                      *y(105) + rxt(399)*y(107) + rxt(404)*y(156) + (rxt(405) + rxt(406) &
                      ) * y(157) + rxt(408)*y(159))
         mat(1463) = -rxt(165)*y(23)
         mat(1222) = -rxt(166)*y(23)
         mat(1333) = -rxt(167)*y(23)
         mat(663) = -rxt(170)*y(23)
         mat(341) = -rxt(171)*y(23)
         mat(91) = -rxt(177)*y(23)
         mat(49) = -rxt(178)*y(23)
         mat(493) = -rxt(181)*y(23)
         mat(1392) = -rxt(195)*y(23)
         mat(874) = -rxt(196)*y(23)
         mat(1016) = -rxt(199)*y(23)
         mat(234) = -rxt(202)*y(23)
         mat(896) = -(rxt(212) + rxt(213)) * y(23)
         mat(1080) = -rxt(223)*y(23)
         mat(515) = -rxt(227)*y(23)
         mat(587) = -rxt(229)*y(23)
         mat(825) = -rxt(235)*y(23)
         mat(480) = -rxt(243)*y(23)
         mat(610) = -(rxt(264) + rxt(265)) * y(23)
         mat(1243) = -rxt(267)*y(23)
         mat(268) = -rxt(274)*y(23)
         mat(195) = -rxt(275)*y(23)
         mat(265) = -rxt(276)*y(23)
         mat(124) = -rxt(283)*y(23)
         mat(118) = -rxt(284)*y(23)
         mat(259) = -rxt(285)*y(23)
         mat(330) = -rxt(291)*y(23)
         mat(152) = -rxt(296)*y(23)
         mat(620) = -rxt(297)*y(23)
         mat(248) = -rxt(304)*y(23)
         mat(554) = -rxt(305)*y(23)
         mat(399) = -rxt(306)*y(23)
         mat(108) = -rxt(307)*y(23)
         mat(241) = -rxt(309)*y(23)
         mat(604) = -rxt(310)*y(23)
         mat(178) = -rxt(316)*y(23)
         mat(54) = -rxt(317)*y(23)
         mat(292) = -rxt(320)*y(23)
         mat(396) = -rxt(321)*y(23)
         mat(184) = -rxt(325)*y(23)
         mat(640) = -rxt(326)*y(23)
         mat(674) = -rxt(327)*y(23)
         mat(159) = -rxt(329)*y(23)
         mat(38) = -rxt(330)*y(23)
         mat(759) = -rxt(332)*y(23)
         mat(202) = -rxt(334)*y(23)
         mat(143) = -rxt(337)*y(23)
         mat(650) = -rxt(338)*y(23)
         mat(147) = -rxt(346)*y(23)
         mat(283) = -rxt(355)*y(23)
         mat(546) = -rxt(356)*y(23)
         mat(300) = -rxt(362)*y(23)
         mat(35) = -rxt(368)*y(23)
         mat(562) = -rxt(369)*y(23)
         mat(156) = -rxt(371)*y(23)
         mat(353) = -rxt(374)*y(23)
         mat(113) = -rxt(380)*y(23)
         mat(64) = -rxt(382)*y(23)
         mat(166) = -rxt(385)*y(23)
         mat(68) = -rxt(386)*y(23)
         mat(41) = -rxt(388)*y(23)
         mat(44) = -rxt(391)*y(23)
         mat(323) = -rxt(394)*y(23)
         mat(213) = -rxt(399)*y(23)
         mat(57) = -rxt(404)*y(23)
         mat(101) = -(rxt(405) + rxt(406)) * y(23)
         mat(47) = -rxt(408)*y(23)

         mat(1222) = mat(1222) + rxt(161)*y(22) + rxt(174)*y(24) + .330_r8*rxt(311) &
                      *y(59) + .270_r8*rxt(357)*y(83) + .120_r8*rxt(290)*y(44) &
                      + .080_r8*rxt(333)*y(77) + .215_r8*rxt(339)*y(78) &
                      + .700_r8*rxt(395)*y(105)
         mat(1463) = mat(1463) + rxt(172)*y(21) + rxt(268)*y(19) + rxt(173)*y(24) &
                      + rxt(176)*y(25) + rxt(224)*y(33) + rxt(225)*y(34) + rxt(244) &
                      *y(39) + rxt(245)*y(40)
         mat(1357) = rxt(156)*y(21) + rxt(159)*y(42) + 2.000_r8*rxt(131)*y(134) &
                      + rxt(157)*y(33) + rxt(158)*y(39)
         mat(663) = mat(663) + rxt(172)*y(2) + rxt(156)*y(3)
         mat(975) = rxt(188)*y(24)
         mat(1179) = mat(1179) + .300_r8*rxt(275)*y(17) + .500_r8*rxt(320)*y(65) &
                      + .100_r8*rxt(346)*y(80) + .500_r8*rxt(296)*y(47) &
                      + .650_r8*rxt(283)*y(135)
         mat(1016) = mat(1016) + rxt(200)*y(24)
         mat(195) = mat(195) + .300_r8*rxt(275)*y(23)
         mat(91) = mat(91) + rxt(159)*y(3)
         mat(1243) = mat(1243) + rxt(268)*y(2)
         mat(1260) = rxt(161)*y(1) + 2.000_r8*rxt(162)*y(24)
         mat(1333) = mat(1333) + rxt(174)*y(1) + rxt(173)*y(2) + rxt(188)*y(9) &
                      + rxt(200)*y(11) + 2.000_r8*rxt(162)*y(22) + rxt(208)*y(28) &
                      + .206_r8*rxt(367)*y(89)
         mat(341) = mat(341) + rxt(176)*y(2)
         mat(861) = 2.000_r8*rxt(131)*y(3) + rxt(247)*y(141)
         mat(1426) = rxt(208)*y(24)
         mat(1080) = mat(1080) + rxt(224)*y(2) + rxt(157)*y(3)
         mat(515) = mat(515) + rxt(225)*y(2)
         mat(480) = mat(480) + rxt(244)*y(2) + rxt(158)*y(3)
         mat(407) = rxt(245)*y(2)
         mat(604) = mat(604) + .330_r8*rxt(311)*y(1)
         mat(546) = mat(546) + .270_r8*rxt(357)*y(1)
         mat(292) = mat(292) + .500_r8*rxt(320)*y(23)
         mat(259) = mat(259) + .120_r8*rxt(290)*y(1)
         mat(759) = mat(759) + .080_r8*rxt(333)*y(1)
         mat(650) = mat(650) + .215_r8*rxt(339)*y(1)
         mat(147) = mat(147) + .100_r8*rxt(346)*y(23)
         mat(152) = mat(152) + .500_r8*rxt(296)*y(23)
         mat(323) = mat(323) + .700_r8*rxt(395)*y(1)
         mat(462) = .206_r8*rxt(367)*y(24)
         mat(124) = mat(124) + .650_r8*rxt(283)*y(23)
         mat(454) = rxt(247)*y(134)


      end subroutine nlnmat02

      subroutine nlnmat03( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(1013) = -(rxt(193)*y(10) + rxt(197)*y(9) + rxt(198)*y(2) + rxt(199)*y(23) &
                      + rxt(200)*y(24) + rxt(266)*y(19) + rxt(298)*y(50) + rxt(312) &
                      *y(59) + rxt(328)*y(68) + rxt(342)*y(79) + rxt(348)*y(76) &
                      + rxt(358)*y(83) + rxt(360)*y(88) + rxt(366)*y(89) + rxt(370) &
                      *y(90) + rxt(376)*y(91) + rxt(396)*y(105) + rxt(407)*y(157))
         mat(1389) = -rxt(193)*y(11)
         mat(972) = -rxt(197)*y(11)
         mat(1460) = -rxt(198)*y(11)
         mat(1176) = -rxt(199)*y(11)
         mat(1330) = -rxt(200)*y(11)
         mat(1240) = -rxt(266)*y(11)
         mat(618) = -rxt(298)*y(11)
         mat(602) = -rxt(312)*y(11)
         mat(673) = -rxt(328)*y(11)
         mat(737) = -rxt(342)*y(11)
         mat(776) = -rxt(348)*y(11)
         mat(544) = -rxt(358)*y(11)
         mat(715) = -rxt(360)*y(11)
         mat(461) = -rxt(366)*y(11)
         mat(561) = -rxt(370)*y(11)
         mat(689) = -rxt(376)*y(11)
         mat(322) = -rxt(396)*y(11)
         mat(100) = -rxt(407)*y(11)

         mat(1219) = rxt(192)*y(10)
         mat(1460) = mat(1460) + rxt(191)*y(10) + rxt(228)*y(35) + rxt(246)*y(41)
         mat(1389) = mat(1389) + rxt(192)*y(1) + rxt(191)*y(2)
         mat(1176) = mat(1176) + rxt(196)*y(12) + rxt(229)*y(35) + rxt(309)*y(58) &
                      + .500_r8*rxt(355)*y(81)
         mat(871) = rxt(196)*y(23) + rxt(250)*y(141)
         mat(1423) = rxt(230)*y(35)
         mat(585) = rxt(228)*y(2) + rxt(229)*y(23) + rxt(230)*y(28)
         mat(276) = rxt(246)*y(2)
         mat(239) = rxt(309)*y(23)
         mat(282) = .500_r8*rxt(355)*y(23)
         mat(452) = rxt(250)*y(12)

         mat(870) = -(rxt(196)*y(23) + rxt(250)*y(141))
         mat(1172) = -rxt(196)*y(12)
         mat(451) = -rxt(250)*y(12)

         mat(1385) = rxt(195)*y(23)
         mat(1172) = mat(1172) + rxt(195)*y(10)
         mat(1011) = rxt(266)*y(19) + rxt(298)*y(50) + rxt(328)*y(68) + rxt(407) &
                      *y(157)
         mat(1237) = rxt(266)*y(11)
         mat(1073) = (rxt(435)+rxt(440)+rxt(446))*y(35)
         mat(583) = (rxt(435)+rxt(440)+rxt(446))*y(33)
         mat(617) = rxt(298)*y(11)
         mat(672) = rxt(328)*y(11)
         mat(99) = rxt(407)*y(11)

         mat(230) = -(rxt(202)*y(23))
         mat(1123) = -rxt(202)*y(13)

         mat(1368) = rxt(201)*y(24)
         mat(1285) = rxt(201)*y(10)


         mat(1367) = rxt(193)*y(11)
         mat(986) = rxt(193)*y(10)

         mat(1054) = -(rxt(215)*y(30) + rxt(270)*y(9) + rxt(271)*y(24) + (4._r8*rxt(272) &
                      + 4._r8*rxt(273)) * y(16) + rxt(294)*y(46) + rxt(302)*y(48) &
                      + rxt(315)*y(61) + rxt(324)*y(67) + rxt(344)*y(79) + rxt(350) &
                      *y(76) + rxt(363)*y(88) + rxt(378)*y(91))
         mat(894) = -rxt(215)*y(16)
         mat(973) = -rxt(270)*y(16)
         mat(1331) = -rxt(271)*y(16)
         mat(505) = -rxt(294)*y(16)
         mat(805) = -rxt(302)*y(16)
         mat(527) = -rxt(315)*y(16)
         mat(632) = -rxt(324)*y(16)
         mat(738) = -rxt(344)*y(16)
         mat(777) = -rxt(350)*y(16)
         mat(716) = -rxt(363)*y(16)
         mat(690) = -rxt(378)*y(16)

         mat(1220) = .310_r8*rxt(311)*y(59)
         mat(973) = mat(973) + rxt(299)*y(48)
         mat(1177) = .700_r8*rxt(275)*y(17) + rxt(291)*y(49)
         mat(1054) = mat(1054) + .900_r8*rxt(302)*y(48)
         mat(194) = .700_r8*rxt(275)*y(23)
         mat(603) = .310_r8*rxt(311)*y(1)
         mat(329) = rxt(291)*y(23)
         mat(805) = mat(805) + rxt(299)*y(9) + .900_r8*rxt(302)*y(16) &
                      + 4.000_r8*rxt(303)*y(48) + rxt(364)*y(88) + rxt(345)*y(79) &
                      + rxt(351)*y(76) + rxt(379)*y(91)
         mat(716) = mat(716) + rxt(364)*y(48)
         mat(738) = mat(738) + rxt(345)*y(48)
         mat(777) = mat(777) + rxt(351)*y(48)
         mat(690) = mat(690) + rxt(379)*y(48)

         mat(192) = -(rxt(275)*y(23))
         mat(1119) = -rxt(275)*y(17)

         mat(1027) = rxt(271)*y(24)
         mat(1281) = rxt(271)*y(16)

         mat(90) = -(rxt(159)*y(3) + rxt(177)*y(23))
         mat(1345) = -rxt(159)*y(42)
         mat(1103) = -rxt(177)*y(42)

         mat(48) = -(rxt(178)*y(23))
         mat(1095) = -rxt(178)*y(43)

         mat(1245) = -(rxt(209)*y(28) + rxt(233)*y(37) + rxt(266)*y(11) + rxt(267) &
                      *y(23) + rxt(268)*y(2) + rxt(269)*y(24))
         mat(1428) = -rxt(209)*y(19)
         mat(919) = -rxt(233)*y(19)
         mat(1018) = -rxt(266)*y(19)
         mat(1181) = -rxt(267)*y(19)
         mat(1465) = -rxt(268)*y(19)
         mat(1335) = -rxt(269)*y(19)

         mat(1224) = .540_r8*rxt(311)*y(59) + .600_r8*rxt(357)*y(83) + rxt(290)*y(44) &
                      + .800_r8*rxt(333)*y(77) + .700_r8*rxt(339)*y(78)
         mat(977) = rxt(270)*y(16) + rxt(318)*y(64) + .500_r8*rxt(331)*y(73) &
                      + .100_r8*rxt(372)*y(84) + .550_r8*rxt(359)*y(88) &
                      + .250_r8*rxt(340)*y(79) + rxt(347)*y(76) + .500_r8*rxt(286) &
                      *y(55) + rxt(322)*y(67) + .072_r8*rxt(365)*y(89) &
                      + .250_r8*rxt(375)*y(91)
         mat(1181) = mat(1181) + .300_r8*rxt(275)*y(17) + .500_r8*rxt(304)*y(54) &
                      + rxt(309)*y(58) + .500_r8*rxt(355)*y(81) + rxt(274)*y(18) &
                      + .800_r8*rxt(305)*y(52)
         mat(1018) = mat(1018) + .600_r8*rxt(360)*y(88) + .250_r8*rxt(342)*y(79) &
                      + rxt(348)*y(76) + .072_r8*rxt(366)*y(89)
         mat(1058) = rxt(270)*y(9) + (4.000_r8*rxt(272)+2.000_r8*rxt(273))*y(16) &
                      + rxt(215)*y(30) + rxt(302)*y(48) + 1.200_r8*rxt(363)*y(88) &
                      + .880_r8*rxt(344)*y(79) + 2.000_r8*rxt(350)*y(76) &
                      + .700_r8*rxt(294)*y(46) + rxt(315)*y(61) + .800_r8*rxt(324) &
                      *y(67) + .800_r8*rxt(378)*y(91)
         mat(196) = .300_r8*rxt(275)*y(23)
         mat(1335) = mat(1335) + .206_r8*rxt(367)*y(89)
         mat(898) = rxt(215)*y(16)
         mat(606) = .540_r8*rxt(311)*y(1)
         mat(548) = .600_r8*rxt(357)*y(1)
         mat(474) = rxt(318)*y(9)
         mat(808) = rxt(302)*y(16) + .600_r8*rxt(364)*y(88) + .250_r8*rxt(345)*y(79) &
                      + rxt(351)*y(76) + .250_r8*rxt(379)*y(91)
         mat(249) = .500_r8*rxt(304)*y(23)
         mat(242) = rxt(309)*y(23)
         mat(261) = rxt(290)*y(1)
         mat(284) = .500_r8*rxt(355)*y(23)
         mat(136) = .500_r8*rxt(331)*y(9)
         mat(388) = .100_r8*rxt(372)*y(9)
         mat(719) = .550_r8*rxt(359)*y(9) + .600_r8*rxt(360)*y(11) + 1.200_r8*rxt(363) &
                      *y(16) + .600_r8*rxt(364)*y(48)
         mat(761) = .800_r8*rxt(333)*y(1)
         mat(652) = .700_r8*rxt(339)*y(1)
         mat(740) = .250_r8*rxt(340)*y(9) + .250_r8*rxt(342)*y(11) + .880_r8*rxt(344) &
                      *y(16) + .250_r8*rxt(345)*y(48)
         mat(780) = rxt(347)*y(9) + rxt(348)*y(11) + 2.000_r8*rxt(350)*y(16) &
                      + rxt(351)*y(48) + 4.000_r8*rxt(352)*y(76)
         mat(507) = .700_r8*rxt(294)*y(16)
         mat(529) = rxt(315)*y(16)
         mat(269) = rxt(274)*y(23)
         mat(555) = .800_r8*rxt(305)*y(23)
         mat(417) = .500_r8*rxt(286)*y(9)
         mat(634) = rxt(322)*y(9) + .800_r8*rxt(324)*y(16)
         mat(463) = .072_r8*rxt(365)*y(9) + .072_r8*rxt(366)*y(11) + .206_r8*rxt(367) &
                      *y(24)
         mat(692) = .250_r8*rxt(375)*y(9) + .800_r8*rxt(378)*y(16) + .250_r8*rxt(379) &
                      *y(48)

         mat(1263) = -(rxt(160)*y(4) + rxt(161)*y(1) + (rxt(162) + rxt(163) + rxt(164) &
                      ) * y(24))
         mat(848) = -rxt(160)*y(22)
         mat(1225) = -rxt(161)*y(22)
         mat(1336) = -(rxt(162) + rxt(163) + rxt(164)) * y(22)

         mat(1466) = rxt(172)*y(21) + rxt(165)*y(23)
         mat(1360) = rxt(156)*y(21)
         mat(664) = rxt(172)*y(2) + rxt(156)*y(3) + rxt(170)*y(23) + rxt(205)*y(28) &
                      + rxt(248)*y(141)
         mat(611) = rxt(264)*y(23)
         mat(494) = rxt(181)*y(23)
         mat(1182) = rxt(165)*y(2) + rxt(170)*y(21) + rxt(264)*y(20) + rxt(181)*y(8) &
                      + rxt(267)*y(19)
         mat(1246) = rxt(267)*y(23)
         mat(1429) = rxt(205)*y(21)
         mat(455) = rxt(248)*y(21)

         mat(1337) = -((rxt(162) + rxt(163) + rxt(164)) * y(22) + rxt(167)*y(23) &
                      + rxt(173)*y(2) + rxt(174)*y(1) + 4._r8*rxt(175)*y(24) + rxt(188) &
                      *y(9) + rxt(200)*y(11) + rxt(201)*y(10) + (rxt(207) + rxt(208) &
                      ) * y(28) + rxt(214)*y(30) + rxt(232)*y(37) + rxt(236)*y(38) &
                      + rxt(269)*y(19) + rxt(271)*y(16) + rxt(279)*y(137) + rxt(287) &
                      *y(55) + rxt(293)*y(46) + rxt(301)*y(48) + rxt(314)*y(61) &
                      + rxt(319)*y(64) + rxt(323)*y(67) + rxt(336)*y(74) + rxt(343) &
                      *y(79) + rxt(349)*y(76) + rxt(361)*y(88) + rxt(367)*y(89) &
                      + rxt(373)*y(84) + rxt(377)*y(91) + rxt(384)*y(96) + rxt(389) &
                      *y(100) + rxt(392)*y(103) + rxt(398)*y(106))
         mat(1264) = -(rxt(162) + rxt(163) + rxt(164)) * y(24)
         mat(1183) = -rxt(167)*y(24)
         mat(1467) = -rxt(173)*y(24)
         mat(1226) = -rxt(174)*y(24)
         mat(979) = -rxt(188)*y(24)
         mat(1020) = -rxt(200)*y(24)
         mat(1396) = -rxt(201)*y(24)
         mat(1430) = -(rxt(207) + rxt(208)) * y(24)
         mat(900) = -rxt(214)*y(24)
         mat(921) = -rxt(232)*y(24)
         mat(826) = -rxt(236)*y(24)
         mat(1247) = -rxt(269)*y(24)
         mat(1060) = -rxt(271)*y(24)
         mat(190) = -rxt(279)*y(24)
         mat(418) = -rxt(287)*y(24)
         mat(508) = -rxt(293)*y(24)
         mat(810) = -rxt(301)*y(24)
         mat(530) = -rxt(314)*y(24)
         mat(475) = -rxt(319)*y(24)
         mat(635) = -rxt(323)*y(24)
         mat(362) = -rxt(336)*y(24)
         mat(742) = -rxt(343)*y(24)
         mat(782) = -rxt(349)*y(24)
         mat(721) = -rxt(361)*y(24)
         mat(464) = -rxt(367)*y(24)
         mat(389) = -rxt(373)*y(24)
         mat(694) = -rxt(377)*y(24)
         mat(310) = -rxt(384)*y(24)
         mat(172) = -rxt(389)*y(24)
         mat(221) = -rxt(392)*y(24)
         mat(577) = -rxt(398)*y(24)

         mat(1226) = mat(1226) + rxt(166)*y(23) + .190_r8*rxt(311)*y(59) &
                      + .060_r8*rxt(357)*y(83) + .120_r8*rxt(290)*y(44) &
                      + .060_r8*rxt(333)*y(77) + .275_r8*rxt(339)*y(78) + rxt(395) &
                      *y(105)
         mat(1467) = mat(1467) + rxt(268)*y(19) + rxt(176)*y(25)
         mat(849) = rxt(160)*y(22) + rxt(288)*y(56)
         mat(612) = rxt(265)*y(23)
         mat(979) = mat(979) + rxt(270)*y(16) + rxt(318)*y(64) + rxt(331)*y(73) &
                      + .900_r8*rxt(372)*y(84) + .900_r8*rxt(383)*y(96) + rxt(397) &
                      *y(106) + .900_r8*rxt(390)*y(100) + .900_r8*rxt(393)*y(103) &
                      + .920_r8*rxt(359)*y(88) + .470_r8*rxt(340)*y(79) + rxt(292) &
                      *y(46) + rxt(313)*y(61) + .250_r8*rxt(286)*y(55) &
                      + .794_r8*rxt(365)*y(89) + rxt(375)*y(91) + rxt(278)*y(137)
         mat(1396) = mat(1396) + .700_r8*rxt(387)*y(98)
         mat(1183) = mat(1183) + rxt(166)*y(1) + rxt(265)*y(20) + rxt(199)*y(11) &
                      + rxt(177)*y(42) + rxt(178)*y(43) + rxt(171)*y(25) + rxt(212) &
                      *y(30) + rxt(235)*y(38) + .500_r8*rxt(355)*y(81) &
                      + .250_r8*rxt(382)*y(94) + rxt(306)*y(53) + .200_r8*rxt(346) &
                      *y(80) + rxt(274)*y(18) + rxt(307)*y(51) + rxt(305)*y(52) &
                      + rxt(326)*y(66) + rxt(369)*y(90) + .350_r8*rxt(283)*y(135) &
                      + rxt(276)*y(136) + .500_r8*rxt(406)*y(157)
         mat(1020) = mat(1020) + rxt(199)*y(23) + rxt(266)*y(19) + rxt(360)*y(88) &
                      + .470_r8*rxt(342)*y(79) + .794_r8*rxt(366)*y(89) + rxt(370) &
                      *y(90) + rxt(376)*y(91)
         mat(1060) = mat(1060) + rxt(270)*y(9) + 4.000_r8*rxt(272)*y(16) + rxt(215) &
                      *y(30) + .900_r8*rxt(302)*y(48) + rxt(363)*y(88) &
                      + .730_r8*rxt(344)*y(79) + rxt(350)*y(76) + rxt(294)*y(46) &
                      + rxt(315)*y(61) + .300_r8*rxt(324)*y(67) + .800_r8*rxt(378) &
                      *y(91)
         mat(92) = rxt(177)*y(23)
         mat(50) = rxt(178)*y(23)
         mat(1247) = mat(1247) + rxt(268)*y(2) + rxt(266)*y(11) + rxt(209)*y(28) &
                      + rxt(233)*y(37)
         mat(1264) = mat(1264) + rxt(160)*y(4)
         mat(342) = rxt(176)*y(2) + rxt(171)*y(23) + rxt(206)*y(28)
         mat(1430) = mat(1430) + rxt(209)*y(19) + rxt(206)*y(25)
         mat(900) = mat(900) + rxt(212)*y(23) + rxt(215)*y(16)
         mat(921) = mat(921) + rxt(233)*y(19)
         mat(826) = mat(826) + rxt(235)*y(23)
         mat(607) = .190_r8*rxt(311)*y(1)
         mat(549) = .060_r8*rxt(357)*y(1)
         mat(475) = mat(475) + rxt(318)*y(9)
         mat(810) = mat(810) + .900_r8*rxt(302)*y(16) + rxt(364)*y(88) &
                      + .470_r8*rxt(345)*y(79) + rxt(379)*y(91)
         mat(262) = .120_r8*rxt(290)*y(1)
         mat(285) = .500_r8*rxt(355)*y(23)
         mat(137) = rxt(331)*y(9)
         mat(389) = mat(389) + .900_r8*rxt(372)*y(9)
         mat(65) = .250_r8*rxt(382)*y(23)
         mat(310) = mat(310) + .900_r8*rxt(383)*y(9)
         mat(84) = .700_r8*rxt(387)*y(10)
         mat(577) = mat(577) + rxt(397)*y(9)
         mat(400) = rxt(306)*y(23)
         mat(172) = mat(172) + .900_r8*rxt(390)*y(9)
         mat(221) = mat(221) + .900_r8*rxt(393)*y(9)
         mat(721) = mat(721) + .920_r8*rxt(359)*y(9) + rxt(360)*y(11) + rxt(363)*y(16) &
                      + rxt(364)*y(48)
         mat(763) = .060_r8*rxt(333)*y(1)
         mat(654) = .275_r8*rxt(339)*y(1)
         mat(742) = mat(742) + .470_r8*rxt(340)*y(9) + .470_r8*rxt(342)*y(11) &
                      + .730_r8*rxt(344)*y(16) + .470_r8*rxt(345)*y(48)
         mat(148) = .200_r8*rxt(346)*y(23)
         mat(782) = mat(782) + rxt(350)*y(16)
         mat(508) = mat(508) + rxt(292)*y(9) + rxt(294)*y(16) + 2.400_r8*rxt(295) &
                      *y(46)
         mat(325) = rxt(395)*y(1)
         mat(530) = mat(530) + rxt(313)*y(9) + rxt(315)*y(16)
         mat(270) = rxt(274)*y(23)
         mat(109) = rxt(307)*y(23)
         mat(556) = rxt(305)*y(23)
         mat(642) = rxt(326)*y(23)
         mat(418) = mat(418) + .250_r8*rxt(286)*y(9)
         mat(207) = rxt(288)*y(4)
         mat(635) = mat(635) + .300_r8*rxt(324)*y(16)
         mat(464) = mat(464) + .794_r8*rxt(365)*y(9) + .794_r8*rxt(366)*y(11)
         mat(564) = rxt(369)*y(23) + rxt(370)*y(11)
         mat(694) = mat(694) + rxt(375)*y(9) + rxt(376)*y(11) + .800_r8*rxt(378)*y(16) &
                      + rxt(379)*y(48)
         mat(125) = .350_r8*rxt(283)*y(23)
         mat(266) = rxt(276)*y(23)
         mat(190) = mat(190) + rxt(278)*y(9)
         mat(102) = .500_r8*rxt(406)*y(23)


      end subroutine nlnmat03

      subroutine nlnmat04( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(338) = -(rxt(171)*y(23) + rxt(176)*y(2) + rxt(206)*y(28))
         mat(1136) = -rxt(171)*y(25)
         mat(1441) = -rxt(176)*y(25)
         mat(1406) = -rxt(206)*y(25)

         mat(1136) = mat(1136) + 2.000_r8*rxt(169)*y(23)
         mat(1293) = 2.000_r8*rxt(175)*y(24)

         mat(856) = -(rxt(131)*y(3) + rxt(247)*y(141))
         mat(1350) = -rxt(131)*y(134)
         mat(450) = -rxt(247)*y(134)

         mat(658) = rxt(170)*y(23)
         mat(1171) = rxt(170)*y(21) + 2.000_r8*rxt(168)*y(23) + rxt(196)*y(12) &
                      + rxt(202)*y(13) + rxt(275)*y(17) + rxt(267)*y(19) + rxt(167) &
                      *y(24) + rxt(171)*y(25) + rxt(223)*y(33) + rxt(227)*y(34) &
                      + rxt(243)*y(39) + rxt(297)*y(50) + rxt(291)*y(49) + rxt(320) &
                      *y(65) + rxt(304)*y(54) + rxt(284)*y(45) + .500_r8*rxt(338) &
                      *y(78) + rxt(317)*y(60) + rxt(316)*y(62) + rxt(321)*y(63) &
                      + rxt(325)*y(69) + rxt(327)*y(68) + (rxt(380)+rxt(381))*y(92) &
                      + rxt(276)*y(136) + rxt(408)*y(159)
         mat(869) = rxt(196)*y(23)
         mat(232) = rxt(202)*y(23)
         mat(193) = rxt(275)*y(23)
         mat(1236) = rxt(267)*y(23)
         mat(1254) = rxt(164)*y(24)
         mat(1325) = rxt(167)*y(23) + rxt(164)*y(22)
         mat(339) = rxt(171)*y(23)
         mat(1072) = rxt(223)*y(23) + (rxt(436)+rxt(441)+rxt(447))*y(34) + (rxt(437) &
                       +rxt(448))*y(40)
         mat(512) = rxt(227)*y(23) + (rxt(436)+rxt(441)+rxt(447))*y(33)
         mat(478) = rxt(243)*y(23)
         mat(404) = (rxt(437)+rxt(448))*y(33)
         mat(616) = rxt(297)*y(23)
         mat(328) = rxt(291)*y(23)
         mat(291) = rxt(320)*y(23)
         mat(246) = rxt(304)*y(23)
         mat(116) = rxt(284)*y(23)
         mat(649) = .500_r8*rxt(338)*y(23)
         mat(53) = rxt(317)*y(23)
         mat(177) = rxt(316)*y(23)
         mat(394) = rxt(321)*y(23)
         mat(183) = rxt(325)*y(23)
         mat(671) = rxt(327)*y(23)
         mat(112) = (rxt(380)+rxt(381))*y(23)
         mat(264) = rxt(276)*y(23)
         mat(46) = rxt(408)*y(23)

         mat(1433) = -(rxt(204)*y(1) + rxt(205)*y(21) + rxt(206)*y(25) + (rxt(207) &
                      + rxt(208)) * y(24) + rxt(209)*y(19) + rxt(226)*y(34) + rxt(230) &
                      *y(35) + rxt(282)*y(45))
         mat(1229) = -rxt(204)*y(28)
         mat(666) = -rxt(205)*y(28)
         mat(343) = -rxt(206)*y(28)
         mat(1340) = -(rxt(207) + rxt(208)) * y(28)
         mat(1250) = -rxt(209)*y(28)
         mat(516) = -rxt(226)*y(28)
         mat(589) = -rxt(230)*y(28)
         mat(119) = -rxt(282)*y(28)

         mat(1470) = rxt(211)*y(30) + rxt(224)*y(33)
         mat(1364) = rxt(157)*y(33) + rxt(152)*y(139)
         mat(982) = rxt(216)*y(30)
         mat(1186) = rxt(212)*y(30) + rxt(223)*y(33)
         mat(1063) = rxt(215)*y(30)
         mat(903) = rxt(211)*y(2) + rxt(216)*y(9) + rxt(212)*y(23) + rxt(215)*y(16) + ( &
                      + 4.000_r8*rxt(218)+2.000_r8*rxt(220))*y(30) + rxt(240)*y(38)
         mat(1087) = rxt(224)*y(2) + rxt(157)*y(3) + rxt(223)*y(23)
         mat(828) = rxt(240)*y(30)
         mat(89) = rxt(152)*y(3)


         mat(1401) = rxt(230)*y(35)
         mat(882) = 2.000_r8*rxt(219)*y(30)
         mat(1065) = (rxt(436)+rxt(441)+rxt(447))*y(34) + (rxt(435)+rxt(440)+rxt(446)) &
                      *y(35)
         mat(510) = (rxt(436)+rxt(441)+rxt(447))*y(33)
         mat(579) = rxt(230)*y(28) + (rxt(435)+rxt(440)+rxt(446))*y(33)

         mat(890) = -(rxt(211)*y(2) + (rxt(212) + rxt(213)) * y(23) + rxt(214)*y(24) &
                      + rxt(215)*y(16) + rxt(216)*y(9) + rxt(217)*y(10) + (4._r8*rxt(218) &
                      + 4._r8*rxt(219) + 4._r8*rxt(220) + 4._r8*rxt(221)) * y(30) &
                      + (rxt(239) + rxt(240) + rxt(241)) * y(38))
         mat(1457) = -rxt(211)*y(30)
         mat(1173) = -(rxt(212) + rxt(213)) * y(30)
         mat(1327) = -rxt(214)*y(30)
         mat(1050) = -rxt(215)*y(30)
         mat(969) = -rxt(216)*y(30)
         mat(1386) = -rxt(217)*y(30)
         mat(820) = -(rxt(239) + rxt(240) + rxt(241)) * y(30)

         mat(1216) = rxt(204)*y(28)
         mat(1457) = mat(1457) + rxt(225)*y(34) + rxt(228)*y(35)
         mat(1173) = mat(1173) + rxt(227)*y(34)
         mat(1327) = mat(1327) + rxt(208)*y(28)
         mat(1420) = rxt(204)*y(1) + rxt(208)*y(24) + rxt(226)*y(34)
         mat(513) = rxt(225)*y(2) + rxt(227)*y(23) + rxt(226)*y(28)
         mat(584) = rxt(228)*y(2)


         mat(881) = 2.000_r8*rxt(220)*y(30) + rxt(239)*y(38)
         mat(812) = rxt(239)*y(30)


         mat(880) = 2.000_r8*rxt(221)*y(30)

         mat(1079) = -(rxt(157)*y(3) + rxt(223)*y(23) + rxt(224)*y(2) + (rxt(435) &
                      + rxt(440) + rxt(446)) * y(35) + (rxt(436) + rxt(441) + rxt(447) &
                      ) * y(34) + (rxt(437) + rxt(448)) * y(40))
         mat(1356) = -rxt(157)*y(33)
         mat(1178) = -rxt(223)*y(33)
         mat(1462) = -rxt(224)*y(33)
         mat(586) = -(rxt(435) + rxt(440) + rxt(446)) * y(33)
         mat(514) = -(rxt(436) + rxt(441) + rxt(447)) * y(33)
         mat(406) = -(rxt(437) + rxt(448)) * y(33)

         mat(662) = rxt(205)*y(28)
         mat(1178) = mat(1178) + rxt(213)*y(30)
         mat(1242) = rxt(209)*y(28)
         mat(1332) = rxt(207)*y(28)
         mat(340) = rxt(206)*y(28)
         mat(1425) = rxt(205)*y(21) + rxt(209)*y(19) + rxt(207)*y(24) + rxt(206)*y(25) &
                      + rxt(226)*y(34) + rxt(282)*y(45)
         mat(895) = rxt(213)*y(23)
         mat(514) = mat(514) + rxt(226)*y(28)
         mat(117) = rxt(282)*y(28)

         mat(511) = -(rxt(225)*y(2) + rxt(226)*y(28) + rxt(227)*y(23) + (rxt(436) &
                      + rxt(441) + rxt(447)) * y(33))
         mat(1449) = -rxt(225)*y(34)
         mat(1410) = -rxt(226)*y(34)
         mat(1148) = -rxt(227)*y(34)
         mat(1068) = -(rxt(436) + rxt(441) + rxt(447)) * y(34)

         mat(1148) = mat(1148) + rxt(229)*y(35)
         mat(1305) = rxt(214)*y(30)
         mat(884) = rxt(214)*y(24)
         mat(580) = rxt(229)*y(23)

         mat(581) = -(rxt(228)*y(2) + rxt(229)*y(23) + rxt(230)*y(28) + (rxt(435) &
                      + rxt(440) + rxt(446)) * y(33))
         mat(1450) = -rxt(228)*y(35)
         mat(1154) = -rxt(229)*y(35)
         mat(1412) = -rxt(230)*y(35)
         mat(1069) = -(rxt(435) + rxt(440) + rxt(446)) * y(35)

         mat(1376) = rxt(217)*y(30)
         mat(885) = rxt(217)*y(10)


         mat(883) = rxt(241)*y(38)
         mat(1066) = (rxt(437)+rxt(448))*y(40)
         mat(813) = rxt(241)*y(30)
         mat(401) = (rxt(437)+rxt(448))*y(33)

         mat(912) = -(rxt(231)*y(1) + rxt(232)*y(24) + rxt(233)*y(19))
         mat(1217) = -rxt(231)*y(37)
         mat(1328) = -rxt(232)*y(37)
         mat(1238) = -rxt(233)*y(37)

         mat(1458) = rxt(234)*y(38) + rxt(244)*y(39)
         mat(1352) = rxt(158)*y(39)
         mat(970) = rxt(237)*y(38)
         mat(1174) = rxt(235)*y(38) + rxt(243)*y(39)
         mat(891) = (rxt(239)+rxt(240))*y(38)
         mat(821) = rxt(234)*y(2) + rxt(237)*y(9) + rxt(235)*y(23) + (rxt(239) &
                       +rxt(240))*y(30) + 4.000_r8*rxt(242)*y(38)
         mat(479) = rxt(244)*y(2) + rxt(158)*y(3) + rxt(243)*y(23)

         mat(816) = -(rxt(234)*y(2) + rxt(235)*y(23) + rxt(236)*y(24) + rxt(237)*y(9) &
                      + rxt(238)*y(10) + (rxt(239) + rxt(240) + rxt(241)) * y(30) &
                      + 4._r8*rxt(242)*y(38))
         mat(1453) = -rxt(234)*y(38)
         mat(1169) = -rxt(235)*y(38)
         mat(1323) = -rxt(236)*y(38)
         mat(965) = -rxt(237)*y(38)
         mat(1382) = -rxt(238)*y(38)
         mat(886) = -(rxt(239) + rxt(240) + rxt(241)) * y(38)

         mat(1212) = rxt(231)*y(37)
         mat(1453) = mat(1453) + rxt(245)*y(40) + rxt(246)*y(41)
         mat(907) = rxt(231)*y(1)
         mat(403) = rxt(245)*y(2)
         mat(273) = rxt(246)*y(2)

         mat(477) = -(rxt(158)*y(3) + rxt(243)*y(23) + rxt(244)*y(2))
         mat(1347) = -rxt(158)*y(39)
         mat(1145) = -rxt(243)*y(39)
         mat(1447) = -rxt(244)*y(39)

         mat(1233) = rxt(233)*y(37)
         mat(1303) = rxt(232)*y(37)
         mat(905) = rxt(233)*y(19) + rxt(232)*y(24)

         mat(402) = -(rxt(245)*y(2) + (rxt(437) + rxt(448)) * y(33))
         mat(1443) = -rxt(245)*y(40)
         mat(1067) = -(rxt(437) + rxt(448)) * y(40)

         mat(1299) = rxt(236)*y(38)
         mat(815) = rxt(236)*y(24)

         mat(271) = -(rxt(246)*y(2))
         mat(1439) = -rxt(246)*y(41)

         mat(1370) = rxt(238)*y(38)
         mat(814) = rxt(238)*y(10)

         mat(366) = -((rxt(451) + rxt(452)) * y(2) + rxt(459)*y(4) + rxt(463)*y(132))
         mat(1442) = -(rxt(451) + rxt(452)) * y(127)
         mat(836) = -rxt(459)*y(127)
         mat(437) = -rxt(463)*y(127)

         mat(420) = -(rxt(454)*y(8) + rxt(455)*y(9) + rxt(462)*y(132))
         mat(486) = -rxt(454)*y(128)
         mat(942) = -rxt(455)*y(128)
         mat(438) = -rxt(462)*y(128)

         mat(837) = rxt(459)*y(127) + rxt(456)*y(129) + rxt(449)*y(130)
         mat(367) = rxt(459)*y(4)
         mat(225) = rxt(456)*y(4)
         mat(332) = rxt(449)*y(4)

         mat(223) = -((rxt(456) + rxt(457)) * y(4) + rxt(458)*y(2))
         mat(833) = -(rxt(456) + rxt(457)) * y(129)
         mat(1437) = -rxt(458)*y(129)

         mat(331) = -(rxt(449)*y(4))
         mat(835) = -rxt(449)*y(130)

         mat(1440) = rxt(452)*y(127) + rxt(458)*y(129)
         mat(365) = rxt(452)*y(2)
         mat(224) = rxt(458)*y(2)

         mat(429) = -(rxt(461)*y(132))
         mat(439) = -rxt(461)*y(131)

         mat(1445) = rxt(451)*y(127)
         mat(838) = rxt(457)*y(129)
         mat(487) = rxt(454)*y(128)
         mat(943) = rxt(455)*y(128)
         mat(368) = rxt(451)*y(2)
         mat(421) = rxt(454)*y(8) + rxt(455)*y(9)
         mat(226) = rxt(457)*y(4)


      end subroutine nlnmat04

      subroutine nlnmat05( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(250) = -(rxt(179)*y(4) + rxt(180)*y(2))
         mat(834) = -rxt(179)*y(133)
         mat(1438) = -rxt(180)*y(133)

         mat(1438) = mat(1438) + rxt(451)*y(127)
         mat(364) = rxt(451)*y(2) + .900_r8*rxt(463)*y(132)
         mat(428) = .800_r8*rxt(461)*y(132)
         mat(436) = .900_r8*rxt(463)*y(127) + .800_r8*rxt(461)*y(131)

         mat(440) = -(rxt(461)*y(131) + rxt(462)*y(128) + rxt(463)*y(127))
         mat(430) = -rxt(461)*y(132)
         mat(422) = -rxt(462)*y(132)
         mat(369) = -rxt(463)*y(132)

         mat(594) = -(rxt(310)*y(23) + rxt(311)*y(1) + rxt(312)*y(11))
         mat(1155) = -rxt(310)*y(59)
         mat(1199) = -rxt(311)*y(59)
         mat(996) = -rxt(312)*y(59)

         mat(1199) = mat(1199) + .070_r8*rxt(357)*y(83)
         mat(536) = .070_r8*rxt(357)*y(1)

         mat(534) = -(rxt(356)*y(23) + rxt(357)*y(1) + rxt(358)*y(11))
         mat(1150) = -rxt(356)*y(83)
         mat(1195) = -rxt(357)*y(83)
         mat(992) = -rxt(358)*y(83)

         mat(467) = -(rxt(318)*y(9) + rxt(319)*y(24))
         mat(946) = -rxt(318)*y(64)
         mat(1302) = -rxt(319)*y(64)

         mat(1144) = rxt(310)*y(59) + .500_r8*rxt(320)*y(65)
         mat(593) = rxt(310)*y(23)
         mat(288) = .500_r8*rxt(320)*y(23)

         mat(614) = -(rxt(297)*y(23) + rxt(298)*y(11))
         mat(1157) = -rxt(297)*y(50)
         mat(998) = -rxt(298)*y(50)

         mat(1201) = .500_r8*rxt(311)*y(59) + .040_r8*rxt(333)*y(77)
         mat(954) = rxt(318)*y(64) + rxt(331)*y(73) + .400_r8*rxt(372)*y(84) &
                      + rxt(335)*y(74) + rxt(292)*y(46) + .270_r8*rxt(313)*y(61)
         mat(1157) = mat(1157) + .500_r8*rxt(296)*y(47) + rxt(307)*y(51)
         mat(1036) = .800_r8*rxt(294)*y(46)
         mat(596) = .500_r8*rxt(311)*y(1)
         mat(468) = rxt(318)*y(9)
         mat(134) = rxt(331)*y(9)
         mat(383) = .400_r8*rxt(372)*y(9)
         mat(358) = rxt(335)*y(9)
         mat(746) = .040_r8*rxt(333)*y(1)
         mat(502) = rxt(292)*y(9) + .800_r8*rxt(294)*y(16) + 3.200_r8*rxt(295)*y(46)
         mat(151) = .500_r8*rxt(296)*y(23)
         mat(521) = .270_r8*rxt(313)*y(9)
         mat(107) = rxt(307)*y(23)

         mat(327) = -(rxt(291)*y(23))
         mat(1135) = -rxt(291)*y(49)

         mat(1193) = .250_r8*rxt(311)*y(59) + .200_r8*rxt(357)*y(83)
         mat(1029) = .100_r8*rxt(302)*y(48)
         mat(1292) = .250_r8*rxt(301)*y(48) + .250_r8*rxt(349)*y(76)
         mat(592) = .250_r8*rxt(311)*y(1)
         mat(532) = .200_r8*rxt(357)*y(1)
         mat(787) = .100_r8*rxt(302)*y(16) + .250_r8*rxt(301)*y(24)
         mat(767) = .250_r8*rxt(349)*y(24)

         mat(287) = -(rxt(320)*y(23))
         mat(1130) = -rxt(320)*y(65)

         mat(1288) = rxt(319)*y(64)
         mat(466) = rxt(319)*y(24)

         mat(799) = -(rxt(299)*y(9) + rxt(300)*y(10) + rxt(301)*y(24) + rxt(302)*y(16) &
                      + 4._r8*rxt(303)*y(48) + rxt(345)*y(79) + rxt(364)*y(88) + rxt(379) &
                      *y(91))
         mat(964) = -rxt(299)*y(48)
         mat(1381) = -rxt(300)*y(48)
         mat(1322) = -rxt(301)*y(48)
         mat(1046) = -rxt(302)*y(48)
         mat(733) = -rxt(345)*y(48)
         mat(711) = -rxt(364)*y(48)
         mat(685) = -rxt(379)*y(48)

         mat(964) = mat(964) + rxt(335)*y(74) + .530_r8*rxt(340)*y(79) + rxt(347) &
                      *y(76) + rxt(322)*y(67)
         mat(1168) = rxt(297)*y(50) + .500_r8*rxt(304)*y(54) + rxt(327)*y(68)
         mat(1008) = rxt(298)*y(50) + .530_r8*rxt(342)*y(79) + rxt(348)*y(76) &
                      + rxt(328)*y(68)
         mat(1046) = mat(1046) + .260_r8*rxt(344)*y(79) + rxt(350)*y(76) &
                      + .300_r8*rxt(324)*y(67)
         mat(615) = rxt(297)*y(23) + rxt(298)*y(11)
         mat(799) = mat(799) + .530_r8*rxt(345)*y(79)
         mat(245) = .500_r8*rxt(304)*y(23)
         mat(359) = rxt(335)*y(9)
         mat(733) = mat(733) + .530_r8*rxt(340)*y(9) + .530_r8*rxt(342)*y(11) &
                      + .260_r8*rxt(344)*y(16) + .530_r8*rxt(345)*y(48)
         mat(771) = rxt(347)*y(9) + rxt(348)*y(11) + rxt(350)*y(16) &
                      + 4.000_r8*rxt(352)*y(76)
         mat(628) = rxt(322)*y(9) + .300_r8*rxt(324)*y(16)
         mat(670) = rxt(327)*y(23) + rxt(328)*y(11)

         mat(244) = -(rxt(304)*y(23))
         mat(1125) = -rxt(304)*y(54)

         mat(1286) = .750_r8*rxt(301)*y(48) + .750_r8*rxt(349)*y(76)
         mat(786) = .750_r8*rxt(301)*y(24)
         mat(765) = .750_r8*rxt(349)*y(24)

         mat(237) = -(rxt(309)*y(23))
         mat(1124) = -rxt(309)*y(58)

         mat(1369) = rxt(300)*y(48)
         mat(785) = rxt(300)*y(10)

         mat(157) = -(rxt(329)*y(23))
         mat(1114) = -rxt(329)*y(82)

         mat(928) = .100_r8*rxt(372)*y(84)
         mat(988) = rxt(312)*y(59)
         mat(591) = rxt(312)*y(11)
         mat(376) = .100_r8*rxt(372)*y(9)

         mat(114) = -(rxt(282)*y(28) + rxt(284)*y(23))
         mat(1402) = -rxt(282)*y(45)
         mat(1107) = -rxt(284)*y(45)

         mat(255) = -(rxt(281)*y(28) + rxt(285)*y(23) + rxt(290)*y(1))
         mat(1404) = -rxt(281)*y(44)
         mat(1126) = -rxt(285)*y(44)
         mat(1190) = -rxt(290)*y(44)

         mat(33) = -(rxt(368)*y(23))
         mat(1090) = -rxt(368)*y(71)

         mat(279) = -(rxt(355)*y(23))
         mat(1129) = -rxt(355)*y(81)

         mat(1371) = rxt(353)*y(76)
         mat(766) = rxt(353)*y(10)

         mat(36) = -(rxt(330)*y(23))
         mat(1091) = -rxt(330)*y(70)

         mat(132) = -(rxt(331)*y(9))
         mat(926) = -rxt(331)*y(73)

         mat(1109) = rxt(330)*y(70)
         mat(37) = rxt(330)*y(23)

         mat(380) = -(rxt(372)*y(9) + rxt(373)*y(24))
         mat(938) = -rxt(372)*y(84)
         mat(1296) = -rxt(373)*y(84)

         mat(1139) = rxt(368)*y(71) + rxt(374)*y(85)
         mat(34) = rxt(368)*y(23)
         mat(348) = rxt(374)*y(23)

         mat(346) = -(rxt(374)*y(23))
         mat(1137) = -rxt(374)*y(85)

         mat(1294) = rxt(373)*y(84)
         mat(378) = rxt(373)*y(24)

         mat(198) = -(rxt(334)*y(23))
         mat(1120) = -rxt(334)*y(72)

         mat(931) = .800_r8*rxt(372)*y(84)
         mat(377) = .800_r8*rxt(372)*y(9)

         mat(357) = -(rxt(335)*y(9) + rxt(336)*y(24))
         mat(937) = -rxt(335)*y(74)
         mat(1295) = -rxt(336)*y(74)

         mat(1138) = rxt(334)*y(72) + rxt(337)*y(75)
         mat(199) = rxt(334)*y(23)
         mat(140) = rxt(337)*y(23)

         mat(139) = -(rxt(337)*y(23))
         mat(1110) = -rxt(337)*y(75)

         mat(1273) = rxt(336)*y(74)
         mat(356) = rxt(336)*y(24)

         mat(61) = -(rxt(382)*y(23))
         mat(1098) = -rxt(382)*y(94)

         mat(66) = -(rxt(386)*y(23))
         mat(1099) = -rxt(386)*y(95)

         mat(1099) = mat(1099) + .250_r8*rxt(382)*y(94)
         mat(62) = .250_r8*rxt(382)*y(23)

         mat(304) = -(rxt(383)*y(9) + rxt(384)*y(24))
         mat(935) = -rxt(383)*y(96)
         mat(1290) = -rxt(384)*y(96)

         mat(1132) = .700_r8*rxt(382)*y(94) + rxt(385)*y(97)
         mat(63) = .700_r8*rxt(382)*y(23)
         mat(162) = rxt(385)*y(23)

         mat(161) = -(rxt(385)*y(23))
         mat(1115) = -rxt(385)*y(97)

         mat(1276) = rxt(384)*y(96)
         mat(303) = rxt(384)*y(24)

         mat(82) = -(rxt(387)*y(10))
         mat(1366) = -rxt(387)*y(98)

         mat(1101) = rxt(386)*y(95)
         mat(67) = rxt(386)*y(23)

         mat(568) = -(rxt(397)*y(9) + rxt(398)*y(24))
         mat(952) = -rxt(397)*y(106)
         mat(1309) = -rxt(398)*y(106)

         mat(1153) = rxt(399)*y(107) + rxt(394)*y(105)
         mat(995) = rxt(396)*y(105)
         mat(210) = rxt(399)*y(23)
         mat(319) = rxt(394)*y(23) + rxt(396)*y(11)

         mat(208) = -(rxt(399)*y(23))
         mat(1121) = -rxt(399)*y(107)

         mat(1283) = rxt(398)*y(106)
         mat(566) = rxt(398)*y(24)


         mat(936) = .900_r8*rxt(383)*y(96) + .900_r8*rxt(390)*y(100) &
                      + .620_r8*rxt(393)*y(103)
         mat(1372) = .700_r8*rxt(387)*y(98)
         mat(305) = .900_r8*rxt(383)*y(9)
         mat(83) = .700_r8*rxt(387)*y(10)
         mat(169) = .900_r8*rxt(390)*y(9)
         mat(217) = .620_r8*rxt(393)*y(9)

         mat(397) = -(rxt(306)*y(23))
         mat(1141) = -rxt(306)*y(53)

         mat(940) = .450_r8*rxt(383)*y(96) + .900_r8*rxt(390)*y(100) &
                      + .340_r8*rxt(393)*y(103) + .020_r8*rxt(359)*y(88) &
                      + .250_r8*rxt(375)*y(91)
         mat(1141) = mat(1141) + .200_r8*rxt(305)*y(52) + .650_r8*rxt(283)*y(135)
         mat(990) = .250_r8*rxt(376)*y(91)
         mat(1031) = .100_r8*rxt(378)*y(91)
         mat(788) = .250_r8*rxt(379)*y(91)
         mat(306) = .450_r8*rxt(383)*y(9)
         mat(170) = .900_r8*rxt(390)*y(9)
         mat(218) = .340_r8*rxt(393)*y(9)
         mat(699) = .020_r8*rxt(359)*y(9)
         mat(551) = .200_r8*rxt(305)*y(23)
         mat(679) = .250_r8*rxt(375)*y(9) + .250_r8*rxt(376)*y(11) + .100_r8*rxt(378) &
                      *y(16) + .250_r8*rxt(379)*y(48)
         mat(122) = .650_r8*rxt(283)*y(23)

         mat(39) = -(rxt(388)*y(23))
         mat(1092) = -rxt(388)*y(99)

         mat(168) = -(rxt(389)*y(24) + rxt(390)*y(9))
         mat(1277) = -rxt(389)*y(100)
         mat(929) = -rxt(390)*y(100)

         mat(1116) = rxt(388)*y(99)
         mat(40) = rxt(388)*y(23)


      end subroutine nlnmat05

      subroutine nlnmat06( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------



         mat(1269) = rxt(389)*y(100)
         mat(167) = rxt(389)*y(24)

         mat(42) = -(rxt(391)*y(23))
         mat(1093) = -rxt(391)*y(102)

         mat(216) = -(rxt(392)*y(24) + rxt(393)*y(9))
         mat(1284) = -rxt(392)*y(103)
         mat(933) = -rxt(393)*y(103)

         mat(1122) = rxt(391)*y(102)
         mat(43) = rxt(391)*y(23)


         mat(1270) = rxt(392)*y(103)
         mat(215) = rxt(392)*y(24)

         mat(707) = -(rxt(359)*y(9) + rxt(360)*y(11) + rxt(361)*y(24) + rxt(363)*y(16) &
                      + rxt(364)*y(48))
         mat(960) = -rxt(359)*y(88)
         mat(1004) = -rxt(360)*y(88)
         mat(1318) = -rxt(361)*y(88)
         mat(1042) = -rxt(363)*y(88)
         mat(795) = -rxt(364)*y(88)

         mat(1164) = rxt(356)*y(83) + .200_r8*rxt(362)*y(93)
         mat(539) = rxt(356)*y(23)
         mat(298) = .200_r8*rxt(362)*y(23)

         mat(750) = -(rxt(332)*y(23) + rxt(333)*y(1))
         mat(1166) = -rxt(332)*y(77)
         mat(1209) = -rxt(333)*y(77)

         mat(1209) = mat(1209) + .200_r8*rxt(357)*y(83) + rxt(395)*y(105)
         mat(962) = rxt(397)*y(106) + .320_r8*rxt(359)*y(88) + .039_r8*rxt(365)*y(89)
         mat(1006) = .350_r8*rxt(360)*y(88) + .039_r8*rxt(366)*y(89)
         mat(1044) = .260_r8*rxt(363)*y(88)
         mat(1320) = .039_r8*rxt(367)*y(89)
         mat(540) = .200_r8*rxt(357)*y(1)
         mat(797) = .350_r8*rxt(364)*y(88)
         mat(571) = rxt(397)*y(9)
         mat(709) = .320_r8*rxt(359)*y(9) + .350_r8*rxt(360)*y(11) + .260_r8*rxt(363) &
                      *y(16) + .350_r8*rxt(364)*y(48)
         mat(321) = rxt(395)*y(1)
         mat(459) = .039_r8*rxt(365)*y(9) + .039_r8*rxt(366)*y(11) + .039_r8*rxt(367) &
                      *y(24)

         mat(644) = -(rxt(338)*y(23) + rxt(339)*y(1))
         mat(1160) = -rxt(338)*y(78)
         mat(1204) = -rxt(339)*y(78)

         mat(1204) = mat(1204) + .400_r8*rxt(357)*y(83) + rxt(395)*y(105)
         mat(957) = rxt(397)*y(106) + .230_r8*rxt(359)*y(88) + .167_r8*rxt(365)*y(89)
         mat(1001) = .250_r8*rxt(360)*y(88) + .167_r8*rxt(366)*y(89)
         mat(1039) = .190_r8*rxt(363)*y(88)
         mat(1314) = .167_r8*rxt(367)*y(89)
         mat(538) = .400_r8*rxt(357)*y(1)
         mat(792) = .250_r8*rxt(364)*y(88)
         mat(570) = rxt(397)*y(9)
         mat(704) = .230_r8*rxt(359)*y(9) + .250_r8*rxt(360)*y(11) + .190_r8*rxt(363) &
                      *y(16) + .250_r8*rxt(364)*y(48)
         mat(320) = rxt(395)*y(1)
         mat(458) = .167_r8*rxt(365)*y(9) + .167_r8*rxt(366)*y(11) + .167_r8*rxt(367) &
                      *y(24)

         mat(731) = -((rxt(340) + rxt(341)) * y(9) + rxt(342)*y(11) + rxt(343)*y(24) &
                      + rxt(344)*y(16) + rxt(345)*y(48))
         mat(961) = -(rxt(340) + rxt(341)) * y(79)
         mat(1005) = -rxt(342)*y(79)
         mat(1319) = -rxt(343)*y(79)
         mat(1043) = -rxt(344)*y(79)
         mat(796) = -rxt(345)*y(79)

         mat(1165) = rxt(332)*y(77) + .500_r8*rxt(338)*y(78) + .200_r8*rxt(346)*y(80)
         mat(749) = rxt(332)*y(23)
         mat(646) = .500_r8*rxt(338)*y(23)
         mat(145) = .200_r8*rxt(346)*y(23)

         mat(144) = -(rxt(346)*y(23))
         mat(1111) = -rxt(346)*y(80)

         mat(1274) = rxt(343)*y(79)
         mat(723) = rxt(343)*y(24)

         mat(770) = -(rxt(347)*y(9) + rxt(348)*y(11) + rxt(349)*y(24) + rxt(350)*y(16) &
                      + rxt(351)*y(48) + 4._r8*rxt(352)*y(76) + rxt(353)*y(10))
         mat(963) = -rxt(347)*y(76)
         mat(1007) = -rxt(348)*y(76)
         mat(1321) = -rxt(349)*y(76)
         mat(1045) = -rxt(350)*y(76)
         mat(798) = -rxt(351)*y(76)
         mat(1380) = -rxt(353)*y(76)

         mat(1210) = .200_r8*rxt(357)*y(83)
         mat(1167) = .500_r8*rxt(338)*y(78) + .500_r8*rxt(346)*y(80)
         mat(541) = .200_r8*rxt(357)*y(1)
         mat(647) = .500_r8*rxt(338)*y(23)
         mat(146) = .500_r8*rxt(346)*y(23)

         mat(501) = -(rxt(292)*y(9) + rxt(293)*y(24) + rxt(294)*y(16) + 4._r8*rxt(295) &
                      *y(46))
         mat(948) = -rxt(292)*y(46)
         mat(1304) = -rxt(293)*y(46)
         mat(1032) = -rxt(294)*y(46)

         mat(1147) = rxt(284)*y(45) + .500_r8*rxt(296)*y(47)
         mat(1409) = rxt(282)*y(45)
         mat(115) = rxt(284)*y(23) + rxt(282)*y(28)
         mat(150) = .500_r8*rxt(296)*y(23)

         mat(149) = -(rxt(296)*y(23))
         mat(1112) = -rxt(296)*y(47)

         mat(1275) = rxt(293)*y(46)
         mat(499) = rxt(293)*y(24)

         mat(318) = -(rxt(394)*y(23) + rxt(395)*y(1) + rxt(396)*y(11))
         mat(1134) = -rxt(394)*y(105)
         mat(1192) = -rxt(395)*y(105)
         mat(989) = -rxt(396)*y(105)

         mat(51) = -(rxt(317)*y(23))
         mat(1096) = -rxt(317)*y(60)

         mat(520) = -(rxt(313)*y(9) + rxt(314)*y(24) + rxt(315)*y(16))
         mat(949) = -rxt(313)*y(61)
         mat(1306) = -rxt(314)*y(61)
         mat(1033) = -rxt(315)*y(61)

         mat(1149) = rxt(317)*y(60) + rxt(316)*y(62)
         mat(52) = rxt(317)*y(23)
         mat(176) = rxt(316)*y(23)

         mat(174) = -(rxt(316)*y(23))
         mat(1117) = -rxt(316)*y(62)

         mat(1278) = rxt(314)*y(61)
         mat(518) = rxt(314)*y(24)

         mat(391) = -(rxt(321)*y(23))
         mat(1140) = -rxt(321)*y(63)

         mat(939) = .500_r8*rxt(331)*y(73) + .250_r8*rxt(372)*y(84) + .100_r8*rxt(397) &
                      *y(106) + .820_r8*rxt(313)*y(61)
         mat(1030) = .820_r8*rxt(315)*y(61)
         mat(133) = .500_r8*rxt(331)*y(9)
         mat(381) = .250_r8*rxt(372)*y(9)
         mat(567) = .100_r8*rxt(397)*y(9)
         mat(519) = .820_r8*rxt(313)*y(9) + .820_r8*rxt(315)*y(16)

         mat(180) = -(rxt(325)*y(23))
         mat(1118) = -rxt(325)*y(69)

         mat(1279) = rxt(323)*y(67)
         mat(623) = rxt(323)*y(24)

         mat(267) = -(rxt(274)*y(23))
         mat(1128) = -rxt(274)*y(18)

         mat(1028) = 2.000_r8*rxt(273)*y(16) + .250_r8*rxt(363)*y(88) &
                      + .250_r8*rxt(344)*y(79) + .300_r8*rxt(294)*y(46) &
                      + .500_r8*rxt(324)*y(67) + .300_r8*rxt(378)*y(91)
         mat(697) = .250_r8*rxt(363)*y(16)
         mat(724) = .250_r8*rxt(344)*y(16)
         mat(500) = .300_r8*rxt(294)*y(16)
         mat(624) = .500_r8*rxt(324)*y(16)
         mat(678) = .300_r8*rxt(378)*y(16)

         mat(106) = -(rxt(307)*y(23))
         mat(1105) = -rxt(307)*y(51)

         mat(1025) = .200_r8*rxt(294)*y(46)
         mat(498) = .200_r8*rxt(294)*y(16) + .800_r8*rxt(295)*y(46)

         mat(552) = -(rxt(305)*y(23))
         mat(1151) = -rxt(305)*y(52)

         mat(841) = rxt(288)*y(56)
         mat(950) = .020_r8*rxt(359)*y(88) + .530_r8*rxt(340)*y(79) + .250_r8*rxt(375) &
                      *y(91)
         mat(993) = .530_r8*rxt(342)*y(79) + .250_r8*rxt(376)*y(91)
         mat(1034) = .260_r8*rxt(344)*y(79) + .100_r8*rxt(378)*y(91)
         mat(789) = .530_r8*rxt(345)*y(79) + .250_r8*rxt(379)*y(91)
         mat(700) = .020_r8*rxt(359)*y(9)
         mat(725) = .530_r8*rxt(340)*y(9) + .530_r8*rxt(342)*y(11) + .260_r8*rxt(344) &
                      *y(16) + .530_r8*rxt(345)*y(48)
         mat(204) = rxt(288)*y(4)
         mat(680) = .250_r8*rxt(375)*y(9) + .250_r8*rxt(376)*y(11) + .100_r8*rxt(378) &
                      *y(16) + .250_r8*rxt(379)*y(48)

         mat(637) = -(rxt(326)*y(23))
         mat(1159) = -rxt(326)*y(66)

         mat(956) = .020_r8*rxt(359)*y(88) + .220_r8*rxt(340)*y(79) + .250_r8*rxt(375) &
                      *y(91)
         mat(1159) = mat(1159) + .500_r8*rxt(320)*y(65) + .500_r8*rxt(355)*y(81)
         mat(1000) = .220_r8*rxt(342)*y(79) + .250_r8*rxt(376)*y(91)
         mat(1038) = .230_r8*rxt(344)*y(79) + .200_r8*rxt(324)*y(67) &
                      + .100_r8*rxt(378)*y(91)
         mat(290) = .500_r8*rxt(320)*y(23)
         mat(791) = .220_r8*rxt(345)*y(79) + .250_r8*rxt(379)*y(91)
         mat(280) = .500_r8*rxt(355)*y(23)
         mat(703) = .020_r8*rxt(359)*y(9)
         mat(728) = .220_r8*rxt(340)*y(9) + .220_r8*rxt(342)*y(11) + .230_r8*rxt(344) &
                      *y(16) + .220_r8*rxt(345)*y(48)
         mat(626) = .200_r8*rxt(324)*y(16)
         mat(682) = .250_r8*rxt(375)*y(9) + .250_r8*rxt(376)*y(11) + .100_r8*rxt(378) &
                      *y(16) + .250_r8*rxt(379)*y(48)

         mat(412) = -(rxt(286)*y(9) + rxt(287)*y(24))
         mat(941) = -rxt(286)*y(55)
         mat(1300) = -rxt(287)*y(55)

         mat(1142) = rxt(285)*y(44)
         mat(257) = rxt(285)*y(23)

         mat(203) = -(rxt(288)*y(4))
         mat(832) = -rxt(288)*y(56)

         mat(932) = .750_r8*rxt(286)*y(55)
         mat(411) = .750_r8*rxt(286)*y(9)


         mat(1271) = rxt(287)*y(55)
         mat(410) = rxt(287)*y(24)

         mat(154) = -(rxt(371)*y(23))
         mat(1113) = -rxt(371)*y(87)

         mat(927) = .330_r8*rxt(359)*y(88)
         mat(1113) = mat(1113) + rxt(369)*y(90)
         mat(987) = .400_r8*rxt(360)*y(88) + rxt(370)*y(90)
         mat(1026) = .300_r8*rxt(363)*y(88)
         mat(784) = .400_r8*rxt(364)*y(88)
         mat(696) = .330_r8*rxt(359)*y(9) + .400_r8*rxt(360)*y(11) + .300_r8*rxt(363) &
                      *y(16) + .400_r8*rxt(364)*y(48)
         mat(557) = rxt(369)*y(23) + rxt(370)*y(11)

         mat(625) = -(rxt(322)*y(9) + rxt(323)*y(24) + rxt(324)*y(16))
         mat(955) = -rxt(322)*y(67)
         mat(1312) = -rxt(323)*y(67)
         mat(1037) = -rxt(324)*y(67)

         mat(1158) = rxt(321)*y(63) + rxt(325)*y(69)
         mat(392) = rxt(321)*y(23)
         mat(181) = rxt(325)*y(23)

         mat(669) = -(rxt(327)*y(23) + rxt(328)*y(11))
         mat(1162) = -rxt(327)*y(68)
         mat(1002) = -rxt(328)*y(68)

         mat(1205) = .950_r8*rxt(333)*y(77) + .800_r8*rxt(339)*y(78)
         mat(958) = .450_r8*rxt(383)*y(96) + .540_r8*rxt(393)*y(103) &
                      + .020_r8*rxt(359)*y(88) + .250_r8*rxt(340)*y(79) &
                      + .250_r8*rxt(375)*y(91)
         mat(1162) = mat(1162) + rxt(329)*y(82) + rxt(326)*y(66)
         mat(1002) = mat(1002) + .250_r8*rxt(342)*y(79) + .250_r8*rxt(376)*y(91)
         mat(1040) = .240_r8*rxt(344)*y(79) + .500_r8*rxt(324)*y(67) &
                      + .100_r8*rxt(378)*y(91)
         mat(793) = .250_r8*rxt(345)*y(79) + .250_r8*rxt(379)*y(91)
         mat(158) = rxt(329)*y(23)
         mat(307) = .450_r8*rxt(383)*y(9)
         mat(219) = .540_r8*rxt(393)*y(9)
         mat(705) = .020_r8*rxt(359)*y(9)
         mat(748) = .950_r8*rxt(333)*y(1)
         mat(645) = .800_r8*rxt(339)*y(1)
         mat(729) = .250_r8*rxt(340)*y(9) + .250_r8*rxt(342)*y(11) + .240_r8*rxt(344) &
                      *y(16) + .250_r8*rxt(345)*y(48)
         mat(638) = rxt(326)*y(23)
         mat(627) = .500_r8*rxt(324)*y(16)
         mat(683) = .250_r8*rxt(375)*y(9) + .250_r8*rxt(376)*y(11) + .100_r8*rxt(378) &
                      *y(16) + .250_r8*rxt(379)*y(48)


      end subroutine nlnmat06

      subroutine nlnmat07( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(456) = -(rxt(365)*y(9) + rxt(366)*y(11) + rxt(367)*y(24))
         mat(945) = -rxt(365)*y(89)
         mat(991) = -rxt(366)*y(89)
         mat(1301) = -rxt(367)*y(89)

         mat(991) = mat(991) + rxt(358)*y(83)
         mat(533) = rxt(358)*y(11)

         mat(558) = -(rxt(369)*y(23) + rxt(370)*y(11))
         mat(1152) = -rxt(369)*y(90)
         mat(994) = -rxt(370)*y(90)

         mat(951) = .080_r8*rxt(359)*y(88) + .800_r8*rxt(341)*y(79) + .794_r8*rxt(365) &
                      *y(89)
         mat(994) = mat(994) + .794_r8*rxt(366)*y(89)
         mat(1308) = .794_r8*rxt(367)*y(89)
         mat(701) = .080_r8*rxt(359)*y(9)
         mat(726) = .800_r8*rxt(341)*y(9)
         mat(457) = .794_r8*rxt(365)*y(9) + .794_r8*rxt(366)*y(11) + .794_r8*rxt(367) &
                      *y(24)

         mat(684) = -(rxt(375)*y(9) + rxt(376)*y(11) + rxt(377)*y(24) + rxt(378)*y(16) &
                      + rxt(379)*y(48))
         mat(959) = -rxt(375)*y(91)
         mat(1003) = -rxt(376)*y(91)
         mat(1317) = -rxt(377)*y(91)
         mat(1041) = -rxt(378)*y(91)
         mat(794) = -rxt(379)*y(91)

         mat(1163) = rxt(371)*y(87) + rxt(380)*y(92) + .800_r8*rxt(362)*y(93)
         mat(155) = rxt(371)*y(23)
         mat(111) = rxt(380)*y(23)
         mat(297) = .800_r8*rxt(362)*y(23)

         mat(110) = -((rxt(380) + rxt(381)) * y(23))
         mat(1106) = -(rxt(380) + rxt(381)) * y(92)

         mat(1272) = rxt(377)*y(91)
         mat(677) = rxt(377)*y(24)

         mat(295) = -(rxt(362)*y(23))
         mat(1131) = -rxt(362)*y(93)

         mat(1289) = rxt(361)*y(88)
         mat(698) = rxt(361)*y(24)

         mat(120) = -(rxt(280)*y(28) + rxt(283)*y(23))
         mat(1403) = -rxt(280)*y(135)
         mat(1108) = -rxt(283)*y(135)

         mat(263) = -(rxt(276)*y(23))
         mat(1127) = -rxt(276)*y(136)

         mat(1191) = .500_r8*rxt(290)*y(44)
         mat(934) = rxt(278)*y(137)
         mat(1127) = mat(1127) + .350_r8*rxt(283)*y(135)
         mat(1287) = rxt(279)*y(137)
         mat(256) = .500_r8*rxt(290)*y(1)
         mat(121) = .350_r8*rxt(283)*y(23)
         mat(187) = rxt(278)*y(9) + rxt(279)*y(24)

         mat(186) = -(rxt(278)*y(9) + rxt(279)*y(24))
         mat(930) = -rxt(278)*y(137)
         mat(1280) = -rxt(279)*y(137)

         mat(1231) = rxt(269)*y(24)
         mat(1280) = mat(1280) + rxt(269)*y(19)

         mat(72) = -(rxt(151)*y(3))
         mat(1342) = -rxt(151)*y(138)

         mat(86) = -(rxt(152)*y(3))
         mat(1344) = -rxt(152)*y(139)


         mat(655) = rxt(248)*y(141)
         mat(866) = rxt(250)*y(141)
         mat(853) = rxt(247)*y(141)
         mat(447) = rxt(248)*y(21) + rxt(250)*y(12) + rxt(247)*y(134)

         mat(448) = -(rxt(247)*y(134) + rxt(248)*y(21) + rxt(250)*y(12))
         mat(854) = -rxt(247)*y(141)
         mat(656) = -rxt(248)*y(141)
         mat(867) = -rxt(250)*y(141)

         mat(1346) = 2.000_r8*rxt(151)*y(138) + rxt(152)*y(139)
         mat(73) = 2.000_r8*rxt(151)*y(3)
         mat(87) = rxt(152)*y(3)

         mat(56) = -(rxt(404)*y(23))
         mat(1097) = -rxt(404)*y(156)

         mat(1097) = mat(1097) + (rxt(405)+.500_r8*rxt(406))*y(157)
         mat(984) = rxt(407)*y(157)
         mat(97) = (rxt(405)+.500_r8*rxt(406))*y(23) + rxt(407)*y(11)

         mat(98) = -((rxt(405) + rxt(406)) * y(23) + rxt(407)*y(11))
         mat(1104) = -(rxt(405) + rxt(406)) * y(157)
         mat(985) = -rxt(407)*y(157)


         mat(1089) = rxt(404)*y(156)
         mat(55) = rxt(404)*y(23)

         mat(45) = -(rxt(408)*y(23))
         mat(1094) = -rxt(408)*y(159)
      end subroutine nlnmat07
      subroutine nlnmat_finit( mat, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(inout) :: mat(nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
         mat( 1) = lmat( 1)
         mat( 2) = lmat( 2)
         mat( 3) = lmat( 3)
         mat( 4) = lmat( 4)
         mat( 5) = lmat( 5)
         mat( 6) = lmat( 6)
         mat( 7) = lmat( 7)
         mat( 8) = lmat( 8)
         mat( 9) = lmat( 9)
         mat( 10) = lmat( 10)
         mat( 11) = lmat( 11)
         mat( 12) = lmat( 12)
         mat( 13) = lmat( 13)
         mat( 14) = lmat( 14)
         mat( 15) = lmat( 15)
         mat( 16) = lmat( 16)
         mat( 17) = lmat( 17)
         mat( 18) = lmat( 18)
         mat( 19) = lmat( 19)
         mat( 20) = lmat( 20)
         mat( 21) = lmat( 21)
         mat( 22) = lmat( 22)
         mat( 23) = lmat( 23)
         mat( 24) = lmat( 24)
         mat( 25) = lmat( 25)
         mat( 26) = lmat( 26)
         mat( 27) = lmat( 27)
         mat( 28) = lmat( 28)
         mat( 29) = lmat( 29)
         mat( 30) = lmat( 30)
         mat( 31) = lmat( 31)
         mat( 32) = lmat( 32)
         mat( 33) = mat( 33) + lmat( 33)
         mat( 36) = mat( 36) + lmat( 36)
         mat( 39) = mat( 39) + lmat( 39)
         mat( 42) = mat( 42) + lmat( 42)
         mat( 45) = mat( 45) + lmat( 45)
         mat( 48) = mat( 48) + lmat( 48)
         mat( 51) = mat( 51) + lmat( 51)
         mat( 56) = mat( 56) + lmat( 56)
         mat( 58) = lmat( 58)
         mat( 59) = lmat( 59)
         mat( 60) = lmat( 60)
         mat( 61) = mat( 61) + lmat( 61)
         mat( 66) = mat( 66) + lmat( 66)
         mat( 69) = lmat( 69)
         mat( 70) = lmat( 70)
         mat( 71) = lmat( 71)
         mat( 72) = mat( 72) + lmat( 72)
         mat( 73) = mat( 73) + lmat( 73)
         mat( 75) = mat( 75) + lmat( 75)
         mat( 76) = mat( 76) + lmat( 76)
         mat( 77) = mat( 77) + lmat( 77)
         mat( 78) = mat( 78) + lmat( 78)
         mat( 79) = lmat( 79)
         mat( 80) = lmat( 80)
         mat( 81) = lmat( 81)
         mat( 82) = mat( 82) + lmat( 82)
         mat( 86) = mat( 86) + lmat( 86)
         mat( 87) = mat( 87) + lmat( 87)
         mat( 89) = mat( 89) + lmat( 89)
         mat( 90) = mat( 90) + lmat( 90)
         mat( 94) = lmat( 94)
         mat( 95) = lmat( 95)
         mat( 96) = lmat( 96)
         mat( 98) = mat( 98) + lmat( 98)
         mat( 103) = lmat( 103)
         mat( 104) = lmat( 104)
         mat( 105) = lmat( 105)
         mat( 106) = mat( 106) + lmat( 106)
         mat( 110) = mat( 110) + lmat( 110)
         mat( 113) = mat( 113) + lmat( 113)
         mat( 114) = mat( 114) + lmat( 114)
         mat( 120) = mat( 120) + lmat( 120)
         mat( 126) = lmat( 126)
         mat( 127) = lmat( 127)
         mat( 128) = lmat( 128)
         mat( 129) = lmat( 129)
         mat( 130) = lmat( 130)
         mat( 131) = lmat( 131)
         mat( 132) = mat( 132) + lmat( 132)
         mat( 139) = mat( 139) + lmat( 139)
         mat( 141) = lmat( 141)
         mat( 142) = lmat( 142)
         mat( 143) = mat( 143) + lmat( 143)
         mat( 144) = mat( 144) + lmat( 144)
         mat( 149) = mat( 149) + lmat( 149)
         mat( 151) = mat( 151) + lmat( 151)
         mat( 152) = mat( 152) + lmat( 152)
         mat( 153) = lmat( 153)
         mat( 154) = mat( 154) + lmat( 154)
         mat( 157) = mat( 157) + lmat( 157)
         mat( 161) = mat( 161) + lmat( 161)
         mat( 163) = lmat( 163)
         mat( 164) = lmat( 164)
         mat( 165) = lmat( 165)
         mat( 166) = mat( 166) + lmat( 166)
         mat( 168) = mat( 168) + lmat( 168)
         mat( 174) = mat( 174) + lmat( 174)
         mat( 175) = lmat( 175)
         mat( 178) = mat( 178) + lmat( 178)
         mat( 179) = lmat( 179)
         mat( 180) = mat( 180) + lmat( 180)
         mat( 182) = lmat( 182)
         mat( 184) = mat( 184) + lmat( 184)
         mat( 185) = lmat( 185)
         mat( 186) = mat( 186) + lmat( 186)
         mat( 189) = lmat( 189)
         mat( 190) = mat( 190) + lmat( 190)
         mat( 192) = mat( 192) + lmat( 192)
         mat( 195) = mat( 195) + lmat( 195)
         mat( 196) = mat( 196) + lmat( 196)
         mat( 197) = lmat( 197)
         mat( 198) = mat( 198) + lmat( 198)
         mat( 200) = lmat( 200)
         mat( 201) = lmat( 201)
         mat( 203) = mat( 203) + lmat( 203)
         mat( 206) = lmat( 206)
         mat( 207) = mat( 207) + lmat( 207)
         mat( 208) = mat( 208) + lmat( 208)
         mat( 209) = lmat( 209)
         mat( 211) = lmat( 211)
         mat( 212) = lmat( 212)
         mat( 213) = mat( 213) + lmat( 213)
         mat( 214) = lmat( 214)
         mat( 216) = mat( 216) + lmat( 216)
         mat( 223) = mat( 223) + lmat( 223)
         mat( 230) = mat( 230) + lmat( 230)
         mat( 233) = lmat( 233)
         mat( 234) = mat( 234) + lmat( 234)
         mat( 235) = lmat( 235)
         mat( 236) = mat( 236) + lmat( 236)
         mat( 237) = mat( 237) + lmat( 237)
         mat( 238) = lmat( 238)
         mat( 239) = mat( 239) + lmat( 239)
         mat( 240) = lmat( 240)
         mat( 243) = lmat( 243)
         mat( 244) = mat( 244) + lmat( 244)
         mat( 247) = lmat( 247)
         mat( 248) = mat( 248) + lmat( 248)
         mat( 250) = mat( 250) + lmat( 250)
         mat( 255) = mat( 255) + lmat( 255)
         mat( 263) = mat( 263) + lmat( 263)
         mat( 267) = mat( 267) + lmat( 267)
         mat( 271) = mat( 271) + lmat( 271)
         mat( 272) = lmat( 272)
         mat( 273) = mat( 273) + lmat( 273)
         mat( 274) = lmat( 274)
         mat( 275) = lmat( 275)
         mat( 276) = mat( 276) + lmat( 276)
         mat( 277) = lmat( 277)
         mat( 279) = mat( 279) + lmat( 279)
         mat( 281) = lmat( 281)
         mat( 286) = lmat( 286)
         mat( 287) = mat( 287) + lmat( 287)
         mat( 289) = lmat( 289)
         mat( 292) = mat( 292) + lmat( 292)
         mat( 293) = lmat( 293)
         mat( 294) = lmat( 294)
         mat( 295) = mat( 295) + lmat( 295)
         mat( 296) = lmat( 296)
         mat( 299) = lmat( 299)
         mat( 301) = lmat( 301)
         mat( 302) = lmat( 302)
         mat( 304) = mat( 304) + lmat( 304)
         mat( 312) = lmat( 312)
         mat( 313) = lmat( 313)
         mat( 314) = lmat( 314)
         mat( 315) = lmat( 315)
         mat( 316) = lmat( 316)
         mat( 317) = lmat( 317)
         mat( 318) = mat( 318) + lmat( 318)
         mat( 327) = mat( 327) + lmat( 327)
         mat( 331) = mat( 331) + lmat( 331)
         mat( 332) = mat( 332) + lmat( 332)
         mat( 333) = lmat( 333)
         mat( 334) = lmat( 334)
         mat( 335) = lmat( 335)
         mat( 338) = mat( 338) + lmat( 338)
         mat( 341) = mat( 341) + lmat( 341)
         mat( 345) = lmat( 345)
         mat( 346) = mat( 346) + lmat( 346)
         mat( 349) = lmat( 349)
         mat( 351) = lmat( 351)
         mat( 353) = mat( 353) + lmat( 353)
         mat( 354) = lmat( 354)
         mat( 355) = lmat( 355)
         mat( 357) = mat( 357) + lmat( 357)
         mat( 366) = mat( 366) + lmat( 366)
         mat( 380) = mat( 380) + lmat( 380)
         mat( 391) = mat( 391) + lmat( 391)
         mat( 393) = lmat( 393)
         mat( 395) = lmat( 395)
         mat( 397) = mat( 397) + lmat( 397)
         mat( 398) = mat( 398) + lmat( 398)
         mat( 400) = mat( 400) + lmat( 400)
         mat( 402) = mat( 402) + lmat( 402)
         mat( 405) = lmat( 405)
         mat( 407) = mat( 407) + lmat( 407)
         mat( 412) = mat( 412) + lmat( 412)
         mat( 420) = mat( 420) + lmat( 420)
         mat( 421) = mat( 421) + lmat( 421)
         mat( 425) = mat( 425) + lmat( 425)
         mat( 429) = mat( 429) + lmat( 429)
         mat( 440) = mat( 440) + lmat( 440)
         mat( 447) = mat( 447) + lmat( 447)
         mat( 448) = mat( 448) + lmat( 448)
         mat( 453) = lmat( 453)
         mat( 456) = mat( 456) + lmat( 456)
         mat( 467) = mat( 467) + lmat( 467)
         mat( 477) = mat( 477) + lmat( 477)
         mat( 479) = mat( 479) + lmat( 479)
         mat( 481) = lmat( 481)
         mat( 484) = lmat( 484)
         mat( 488) = lmat( 488)
         mat( 489) = mat( 489) + lmat( 489)
         mat( 501) = mat( 501) + lmat( 501)
         mat( 511) = mat( 511) + lmat( 511)
         mat( 515) = mat( 515) + lmat( 515)
         mat( 516) = mat( 516) + lmat( 516)
         mat( 520) = mat( 520) + lmat( 520)
         mat( 534) = mat( 534) + lmat( 534)
         mat( 552) = mat( 552) + lmat( 552)
         mat( 553) = lmat( 553)
         mat( 555) = mat( 555) + lmat( 555)
         mat( 556) = mat( 556) + lmat( 556)
         mat( 558) = mat( 558) + lmat( 558)
         mat( 559) = lmat( 559)
         mat( 563) = lmat( 563)
         mat( 564) = mat( 564) + lmat( 564)
         mat( 565) = mat( 565) + lmat( 565)
         mat( 568) = mat( 568) + lmat( 568)
         mat( 580) = mat( 580) + lmat( 580)
         mat( 581) = mat( 581) + lmat( 581)
         mat( 583) = mat( 583) + lmat( 583)
         mat( 584) = mat( 584) + lmat( 584)
         mat( 585) = mat( 585) + lmat( 585)
         mat( 588) = lmat( 588)
         mat( 589) = mat( 589) + lmat( 589)
         mat( 594) = mat( 594) + lmat( 594)
         mat( 609) = mat( 609) + lmat( 609)
         mat( 613) = lmat( 613)
         mat( 614) = mat( 614) + lmat( 614)
         mat( 619) = lmat( 619)
         mat( 622) = lmat( 622)
         mat( 625) = mat( 625) + lmat( 625)
         mat( 637) = mat( 637) + lmat( 637)
         mat( 639) = lmat( 639)
         mat( 641) = lmat( 641)
         mat( 642) = mat( 642) + lmat( 642)
         mat( 643) = mat( 643) + lmat( 643)
         mat( 644) = mat( 644) + lmat( 644)
         mat( 647) = mat( 647) + lmat( 647)
         mat( 648) = lmat( 648)
         mat( 652) = mat( 652) + lmat( 652)
         mat( 654) = mat( 654) + lmat( 654)
         mat( 657) = mat( 657) + lmat( 657)
         mat( 668) = mat( 668) + lmat( 668)
         mat( 669) = mat( 669) + lmat( 669)
         mat( 670) = mat( 670) + lmat( 670)
         mat( 676) = lmat( 676)
         mat( 684) = mat( 684) + lmat( 684)
         mat( 707) = mat( 707) + lmat( 707)
         mat( 731) = mat( 731) + lmat( 731)
         mat( 744) = lmat( 744)
         mat( 745) = mat( 745) + lmat( 745)
         mat( 750) = mat( 750) + lmat( 750)
         mat( 752) = lmat( 752)
         mat( 758) = lmat( 758)
         mat( 770) = mat( 770) + lmat( 770)
         mat( 799) = mat( 799) + lmat( 799)
         mat( 816) = mat( 816) + lmat( 816)
         mat( 821) = mat( 821) + lmat( 821)
         mat( 829) = mat( 829) + lmat( 829)
         mat( 835) = mat( 835) + lmat( 835)
         mat( 837) = mat( 837) + lmat( 837)
         mat( 839) = lmat( 839)
         mat( 843) = mat( 843) + lmat( 843)
         mat( 850) = mat( 850) + lmat( 850)
         mat( 852) = mat( 852) + lmat( 852)
         mat( 855) = lmat( 855)
         mat( 856) = mat( 856) + lmat( 856)
         mat( 861) = mat( 861) + lmat( 861)
         mat( 862) = lmat( 862)
         mat( 863) = mat( 863) + lmat( 863)
         mat( 865) = lmat( 865)
         mat( 870) = mat( 870) + lmat( 870)
         mat( 874) = mat( 874) + lmat( 874)
         mat( 877) = lmat( 877)
         mat( 890) = mat( 890) + lmat( 890)
         mat( 903) = mat( 903) + lmat( 903)
         mat( 904) = mat( 904) + lmat( 904)
         mat( 912) = mat( 912) + lmat( 912)
         mat( 943) = mat( 943) + lmat( 943)
         mat( 944) = lmat( 944)
         mat( 947) = mat( 947) + lmat( 947)
         mat( 971) = mat( 971) + lmat( 971)
         mat( 983) = mat( 983) + lmat( 983)
         mat(1009) = mat(1009) + lmat(1009)
         mat(1011) = mat(1011) + lmat(1011)
         mat(1012) = mat(1012) + lmat(1012)
         mat(1013) = mat(1013) + lmat(1013)
         mat(1022) = mat(1022) + lmat(1022)
         mat(1024) = mat(1024) + lmat(1024)
         mat(1054) = mat(1054) + lmat(1054)
         mat(1079) = mat(1079) + lmat(1079)
         mat(1083) = lmat(1083)
         mat(1087) = mat(1087) + lmat(1087)
         mat(1100) = lmat(1100)
         mat(1102) = lmat(1102)
         mat(1171) = mat(1171) + lmat(1171)
         mat(1174) = mat(1174) + lmat(1174)
         mat(1177) = mat(1177) + lmat(1177)
         mat(1179) = mat(1179) + lmat(1179)
         mat(1183) = mat(1183) + lmat(1183)
         mat(1186) = mat(1186) + lmat(1186)
         mat(1188) = mat(1188) + lmat(1188)
         mat(1213) = mat(1213) + lmat(1213)
         mat(1223) = mat(1223) + lmat(1223)
         mat(1227) = mat(1227) + lmat(1227)
         mat(1230) = mat(1230) + lmat(1230)
         mat(1234) = mat(1234) + lmat(1234)
         mat(1235) = lmat(1235)
         mat(1245) = mat(1245) + lmat(1245)
         mat(1246) = mat(1246) + lmat(1246)
         mat(1263) = mat(1263) + lmat(1263)
         mat(1293) = mat(1293) + lmat(1293)
         mat(1337) = mat(1337) + lmat(1337)
         mat(1342) = mat(1342) + lmat(1342)
         mat(1344) = mat(1344) + lmat(1344)
         mat(1346) = mat(1346) + lmat(1346)
         mat(1348) = mat(1348) + lmat(1348)
         mat(1349) = mat(1349) + lmat(1349)
         mat(1352) = mat(1352) + lmat(1352)
         mat(1353) = lmat(1353)
         mat(1355) = lmat(1355)
         mat(1357) = mat(1357) + lmat(1357)
         mat(1359) = lmat(1359)
         mat(1360) = mat(1360) + lmat(1360)
         mat(1361) = lmat(1361)
         mat(1362) = mat(1362) + lmat(1362)
         mat(1364) = mat(1364) + lmat(1364)
         mat(1365) = mat(1365) + lmat(1365)
         mat(1385) = mat(1385) + lmat(1385)
         mat(1388) = mat(1388) + lmat(1388)
         mat(1392) = mat(1392) + lmat(1392)
         mat(1398) = mat(1398) + lmat(1398)
         mat(1400) = mat(1400) + lmat(1400)
         mat(1413) = mat(1413) + lmat(1413)
         mat(1421) = lmat(1421)
         mat(1424) = lmat(1424)
         mat(1425) = mat(1425) + lmat(1425)
         mat(1430) = mat(1430) + lmat(1430)
         mat(1433) = mat(1433) + lmat(1433)
         mat(1440) = mat(1440) + lmat(1440)
         mat(1446) = lmat(1446)
         mat(1471) = mat(1471) + lmat(1471)
         mat( 309) = 0._r8
         mat( 347) = 0._r8
         mat( 350) = 0._r8
         mat( 352) = 0._r8
         mat( 361) = 0._r8
         mat( 371) = 0._r8
         mat( 373) = 0._r8
         mat( 374) = 0._r8
         mat( 379) = 0._r8
         mat( 382) = 0._r8
         mat( 384) = 0._r8
         mat( 385) = 0._r8
         mat( 387) = 0._r8
         mat( 408) = 0._r8
         mat( 413) = 0._r8
         mat( 414) = 0._r8
         mat( 416) = 0._r8
         mat( 432) = 0._r8
         mat( 433) = 0._r8
         mat( 434) = 0._r8
         mat( 442) = 0._r8
         mat( 443) = 0._r8
         mat( 444) = 0._r8
         mat( 469) = 0._r8
         mat( 471) = 0._r8
         mat( 473) = 0._r8
         mat( 485) = 0._r8
         mat( 490) = 0._r8
         mat( 495) = 0._r8
         mat( 506) = 0._r8
         mat( 522) = 0._r8
         mat( 523) = 0._r8
         mat( 525) = 0._r8
         mat( 528) = 0._r8
         mat( 535) = 0._r8
         mat( 542) = 0._r8
         mat( 543) = 0._r8
         mat( 545) = 0._r8
         mat( 550) = 0._r8
         mat( 560) = 0._r8
         mat( 569) = 0._r8
         mat( 572) = 0._r8
         mat( 573) = 0._r8
         mat( 575) = 0._r8
         mat( 576) = 0._r8
         mat( 582) = 0._r8
         mat( 597) = 0._r8
         mat( 598) = 0._r8
         mat( 599) = 0._r8
         mat( 600) = 0._r8
         mat( 601) = 0._r8
         mat( 608) = 0._r8
         mat( 621) = 0._r8
         mat( 630) = 0._r8
         mat( 633) = 0._r8
         mat( 653) = 0._r8
         mat( 659) = 0._r8
         mat( 660) = 0._r8
         mat( 661) = 0._r8
         mat( 675) = 0._r8
         mat( 686) = 0._r8
         mat( 687) = 0._r8
         mat( 691) = 0._r8
         mat( 693) = 0._r8
         mat( 702) = 0._r8
         mat( 706) = 0._r8
         mat( 708) = 0._r8
         mat( 710) = 0._r8
         mat( 712) = 0._r8
         mat( 713) = 0._r8
         mat( 717) = 0._r8
         mat( 718) = 0._r8
         mat( 720) = 0._r8
         mat( 730) = 0._r8
         mat( 732) = 0._r8
         mat( 734) = 0._r8
         mat( 735) = 0._r8
         mat( 739) = 0._r8
         mat( 741) = 0._r8
         mat( 747) = 0._r8
         mat( 751) = 0._r8
         mat( 753) = 0._r8
         mat( 754) = 0._r8
         mat( 755) = 0._r8
         mat( 756) = 0._r8
         mat( 757) = 0._r8
         mat( 762) = 0._r8
         mat( 764) = 0._r8
         mat( 768) = 0._r8
         mat( 769) = 0._r8
         mat( 773) = 0._r8
         mat( 774) = 0._r8
         mat( 778) = 0._r8
         mat( 781) = 0._r8
         mat( 800) = 0._r8
         mat( 801) = 0._r8
         mat( 802) = 0._r8
         mat( 804) = 0._r8
         mat( 806) = 0._r8
         mat( 809) = 0._r8
         mat( 818) = 0._r8
         mat( 819) = 0._r8
         mat( 823) = 0._r8
         mat( 824) = 0._r8
         mat( 842) = 0._r8
         mat( 845) = 0._r8
         mat( 847) = 0._r8
         mat( 851) = 0._r8
         mat( 857) = 0._r8
         mat( 858) = 0._r8
         mat( 859) = 0._r8
         mat( 860) = 0._r8
         mat( 864) = 0._r8
         mat( 868) = 0._r8
         mat( 872) = 0._r8
         mat( 873) = 0._r8
         mat( 875) = 0._r8
         mat( 876) = 0._r8
         mat( 878) = 0._r8
         mat( 879) = 0._r8
         mat( 888) = 0._r8
         mat( 889) = 0._r8
         mat( 893) = 0._r8
         mat( 897) = 0._r8
         mat( 899) = 0._r8
         mat( 901) = 0._r8
         mat( 909) = 0._r8
         mat( 910) = 0._r8
         mat( 911) = 0._r8
         mat( 913) = 0._r8
         mat( 914) = 0._r8
         mat( 915) = 0._r8
         mat( 916) = 0._r8
         mat( 917) = 0._r8
         mat( 920) = 0._r8
         mat( 922) = 0._r8
         mat( 923) = 0._r8
         mat( 924) = 0._r8
         mat( 925) = 0._r8
         mat( 967) = 0._r8
         mat( 968) = 0._r8
         mat( 974) = 0._r8
         mat( 978) = 0._r8
         mat( 980) = 0._r8
         mat( 999) = 0._r8
         mat(1010) = 0._r8
         mat(1014) = 0._r8
         mat(1015) = 0._r8
         mat(1017) = 0._r8
         mat(1019) = 0._r8
         mat(1021) = 0._r8
         mat(1023) = 0._r8
         mat(1048) = 0._r8
         mat(1049) = 0._r8
         mat(1051) = 0._r8
         mat(1053) = 0._r8
         mat(1055) = 0._r8
         mat(1056) = 0._r8
         mat(1057) = 0._r8
         mat(1059) = 0._r8
         mat(1061) = 0._r8
         mat(1064) = 0._r8
         mat(1070) = 0._r8
         mat(1071) = 0._r8
         mat(1074) = 0._r8
         mat(1075) = 0._r8
         mat(1076) = 0._r8
         mat(1077) = 0._r8
         mat(1078) = 0._r8
         mat(1081) = 0._r8
         mat(1082) = 0._r8
         mat(1084) = 0._r8
         mat(1086) = 0._r8
         mat(1133) = 0._r8
         mat(1143) = 0._r8
         mat(1184) = 0._r8
         mat(1194) = 0._r8
         mat(1196) = 0._r8
         mat(1197) = 0._r8
         mat(1198) = 0._r8
         mat(1202) = 0._r8
         mat(1203) = 0._r8
         mat(1206) = 0._r8
         mat(1207) = 0._r8
         mat(1208) = 0._r8
         mat(1211) = 0._r8
         mat(1214) = 0._r8
         mat(1215) = 0._r8
         mat(1221) = 0._r8
         mat(1232) = 0._r8
         mat(1239) = 0._r8
         mat(1241) = 0._r8
         mat(1244) = 0._r8
         mat(1248) = 0._r8
         mat(1249) = 0._r8
         mat(1255) = 0._r8
         mat(1256) = 0._r8
         mat(1257) = 0._r8
         mat(1258) = 0._r8
         mat(1259) = 0._r8
         mat(1262) = 0._r8
         mat(1265) = 0._r8
         mat(1266) = 0._r8
         mat(1267) = 0._r8
         mat(1282) = 0._r8
         mat(1291) = 0._r8
         mat(1297) = 0._r8
         mat(1298) = 0._r8
         mat(1307) = 0._r8
         mat(1310) = 0._r8
         mat(1311) = 0._r8
         mat(1313) = 0._r8
         mat(1316) = 0._r8
         mat(1326) = 0._r8
         mat(1338) = 0._r8
         mat(1351) = 0._r8
         mat(1354) = 0._r8
         mat(1363) = 0._r8
         mat(1373) = 0._r8
         mat(1374) = 0._r8
         mat(1377) = 0._r8
         mat(1378) = 0._r8
         mat(1379) = 0._r8
         mat(1384) = 0._r8
         mat(1387) = 0._r8
         mat(1390) = 0._r8
         mat(1391) = 0._r8
         mat(1394) = 0._r8
         mat(1395) = 0._r8
         mat(1397) = 0._r8
         mat(1399) = 0._r8
         mat(1405) = 0._r8
         mat(1407) = 0._r8
         mat(1408) = 0._r8
         mat(1411) = 0._r8
         mat(1414) = 0._r8
         mat(1416) = 0._r8
         mat(1418) = 0._r8
         mat(1419) = 0._r8
         mat(1422) = 0._r8
         mat(1431) = 0._r8
         mat(1432) = 0._r8
         mat(1434) = 0._r8
         mat(1444) = 0._r8
         mat(1455) = 0._r8
         mat(1456) = 0._r8
         mat(1461) = 0._r8
         mat(1468) = 0._r8
         mat( 1) = mat( 1) - dti
         mat( 2) = mat( 2) - dti
         mat( 3) = mat( 3) - dti
         mat( 4) = mat( 4) - dti
         mat( 5) = mat( 5) - dti
         mat( 6) = mat( 6) - dti
         mat( 7) = mat( 7) - dti
         mat( 8) = mat( 8) - dti
         mat( 9) = mat( 9) - dti
         mat( 10) = mat( 10) - dti
         mat( 11) = mat( 11) - dti
         mat( 12) = mat( 12) - dti
         mat( 13) = mat( 13) - dti
         mat( 14) = mat( 14) - dti
         mat( 15) = mat( 15) - dti
         mat( 16) = mat( 16) - dti
         mat( 18) = mat( 18) - dti
         mat( 19) = mat( 19) - dti
         mat( 21) = mat( 21) - dti
         mat( 22) = mat( 22) - dti
         mat( 23) = mat( 23) - dti
         mat( 24) = mat( 24) - dti
         mat( 25) = mat( 25) - dti
         mat( 26) = mat( 26) - dti
         mat( 27) = mat( 27) - dti
         mat( 28) = mat( 28) - dti
         mat( 29) = mat( 29) - dti
         mat( 30) = mat( 30) - dti
         mat( 33) = mat( 33) - dti
         mat( 36) = mat( 36) - dti
         mat( 39) = mat( 39) - dti
         mat( 42) = mat( 42) - dti
         mat( 45) = mat( 45) - dti
         mat( 48) = mat( 48) - dti
         mat( 51) = mat( 51) - dti
         mat( 56) = mat( 56) - dti
         mat( 58) = mat( 58) - dti
         mat( 61) = mat( 61) - dti
         mat( 66) = mat( 66) - dti
         mat( 69) = mat( 69) - dti
         mat( 72) = mat( 72) - dti
         mat( 75) = mat( 75) - dti
         mat( 78) = mat( 78) - dti
         mat( 80) = mat( 80) - dti
         mat( 82) = mat( 82) - dti
         mat( 86) = mat( 86) - dti
         mat( 90) = mat( 90) - dti
         mat( 94) = mat( 94) - dti
         mat( 98) = mat( 98) - dti
         mat( 103) = mat( 103) - dti
         mat( 106) = mat( 106) - dti
         mat( 110) = mat( 110) - dti
         mat( 114) = mat( 114) - dti
         mat( 120) = mat( 120) - dti
         mat( 126) = mat( 126) - dti
         mat( 132) = mat( 132) - dti
         mat( 139) = mat( 139) - dti
         mat( 144) = mat( 144) - dti
         mat( 149) = mat( 149) - dti
         mat( 154) = mat( 154) - dti
         mat( 157) = mat( 157) - dti
         mat( 161) = mat( 161) - dti
         mat( 168) = mat( 168) - dti
         mat( 174) = mat( 174) - dti
         mat( 180) = mat( 180) - dti
         mat( 186) = mat( 186) - dti
         mat( 192) = mat( 192) - dti
         mat( 198) = mat( 198) - dti
         mat( 203) = mat( 203) - dti
         mat( 208) = mat( 208) - dti
         mat( 216) = mat( 216) - dti
         mat( 223) = mat( 223) - dti
         mat( 230) = mat( 230) - dti
         mat( 237) = mat( 237) - dti
         mat( 244) = mat( 244) - dti
         mat( 250) = mat( 250) - dti
         mat( 255) = mat( 255) - dti
         mat( 263) = mat( 263) - dti
         mat( 267) = mat( 267) - dti
         mat( 271) = mat( 271) - dti
         mat( 279) = mat( 279) - dti
         mat( 287) = mat( 287) - dti
         mat( 295) = mat( 295) - dti
         mat( 304) = mat( 304) - dti
         mat( 312) = mat( 312) - dti
         mat( 318) = mat( 318) - dti
         mat( 327) = mat( 327) - dti
         mat( 331) = mat( 331) - dti
         mat( 338) = mat( 338) - dti
         mat( 346) = mat( 346) - dti
         mat( 357) = mat( 357) - dti
         mat( 366) = mat( 366) - dti
         mat( 380) = mat( 380) - dti
         mat( 391) = mat( 391) - dti
         mat( 397) = mat( 397) - dti
         mat( 402) = mat( 402) - dti
         mat( 412) = mat( 412) - dti
         mat( 420) = mat( 420) - dti
         mat( 429) = mat( 429) - dti
         mat( 440) = mat( 440) - dti
         mat( 448) = mat( 448) - dti
         mat( 456) = mat( 456) - dti
         mat( 467) = mat( 467) - dti
         mat( 477) = mat( 477) - dti
         mat( 489) = mat( 489) - dti
         mat( 501) = mat( 501) - dti
         mat( 511) = mat( 511) - dti
         mat( 520) = mat( 520) - dti
         mat( 534) = mat( 534) - dti
         mat( 552) = mat( 552) - dti
         mat( 558) = mat( 558) - dti
         mat( 568) = mat( 568) - dti
         mat( 581) = mat( 581) - dti
         mat( 594) = mat( 594) - dti
         mat( 609) = mat( 609) - dti
         mat( 614) = mat( 614) - dti
         mat( 625) = mat( 625) - dti
         mat( 637) = mat( 637) - dti
         mat( 644) = mat( 644) - dti
         mat( 657) = mat( 657) - dti
         mat( 669) = mat( 669) - dti
         mat( 684) = mat( 684) - dti
         mat( 707) = mat( 707) - dti
         mat( 731) = mat( 731) - dti
         mat( 750) = mat( 750) - dti
         mat( 770) = mat( 770) - dti
         mat( 799) = mat( 799) - dti
         mat( 816) = mat( 816) - dti
         mat( 843) = mat( 843) - dti
         mat( 856) = mat( 856) - dti
         mat( 870) = mat( 870) - dti
         mat( 890) = mat( 890) - dti
         mat( 912) = mat( 912) - dti
         mat( 971) = mat( 971) - dti
         mat(1013) = mat(1013) - dti
         mat(1054) = mat(1054) - dti
         mat(1079) = mat(1079) - dti
         mat(1179) = mat(1179) - dti
         mat(1223) = mat(1223) - dti
         mat(1245) = mat(1245) - dti
         mat(1263) = mat(1263) - dti
         mat(1337) = mat(1337) - dti
         mat(1362) = mat(1362) - dti
         mat(1398) = mat(1398) - dti
         mat(1433) = mat(1433) - dti
         mat(1471) = mat(1471) - dti
      end subroutine nlnmat_finit
      subroutine nlnmat( mat, y, rxt, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)
      call nlnmat01( mat, y, rxt )
      call nlnmat02( mat, y, rxt )
      call nlnmat03( mat, y, rxt )
      call nlnmat04( mat, y, rxt )
      call nlnmat05( mat, y, rxt )
      call nlnmat06( mat, y, rxt )
      call nlnmat07( mat, y, rxt )
      call nlnmat_finit( mat, lmat, dti )
      end subroutine nlnmat
      end module mo_nln_matrix
