



      module mo_prod_loss

      use shr_kind_mod, only : r8 => shr_kind_r8

      private
      public :: exp_prod_loss
      public :: imp_prod_loss

      contains

      subroutine exp_prod_loss( prod, loss, y, rxt, het_rates )

      use ppgrid, only : pver

      implicit none

!--------------------------------------------------------------------
! ... dummy args
!--------------------------------------------------------------------
      real(r8), dimension(:,:,:), intent(out) :: &
            prod, &
            loss
      real(r8), intent(in) :: y(:,:,:)
      real(r8), intent(in) :: rxt(:,:,:)
      real(r8), intent(in) :: het_rates(:,:,:)



!--------------------------------------------------------------------
! ... loss and production for Explicit method
!--------------------------------------------------------------------


         loss(:,:,1) = ( + het_rates(:,:,180))* y(:,:,180)
         prod(:,:,1) = 0._r8
         loss(:,:,2) = ((rxt(:,:,153) +rxt(:,:,154) +rxt(:,:,155))* y(:,:,3) &
                  +rxt(:,:,263)* y(:,:,23) +rxt(:,:,210)* y(:,:,28) +rxt(:,:,249) &
                 * y(:,:,141) + rxt(:,:,59) + rxt(:,:,60) + het_rates(:,:,15)) &
                 * y(:,:,15)
         prod(:,:,2) = 0._r8
         loss(:,:,3) = ((rxt(:,:,132) +rxt(:,:,133))* y(:,:,3) + rxt(:,:,5) &
                  + het_rates(:,:,7))* y(:,:,7)
         prod(:,:,3) = 0._r8
         loss(:,:,4) = (rxt(:,:,252)* y(:,:,23) +rxt(:,:,251)* y(:,:,28) + rxt(:,:,37) &
                  + het_rates(:,:,108))* y(:,:,108)
         prod(:,:,4) = 0._r8
         loss(:,:,5) = (rxt(:,:,144)* y(:,:,3) +rxt(:,:,255)* y(:,:,23) +rxt(:,:,256) &
                 * y(:,:,28) + rxt(:,:,48) + het_rates(:,:,109))* y(:,:,109)
         prod(:,:,5) = 0._r8
         loss(:,:,6) = (rxt(:,:,135)* y(:,:,3) + rxt(:,:,40) + het_rates(:,:,110)) &
                 * y(:,:,110)
         prod(:,:,6) = 0._r8
         loss(:,:,7) = (rxt(:,:,136)* y(:,:,3) + rxt(:,:,41) + het_rates(:,:,111)) &
                 * y(:,:,111)
         prod(:,:,7) = 0._r8
         loss(:,:,8) = (rxt(:,:,137)* y(:,:,3) + rxt(:,:,42) + het_rates(:,:,112)) &
                 * y(:,:,112)
         prod(:,:,8) = 0._r8
         loss(:,:,9) = (rxt(:,:,138)* y(:,:,3) + rxt(:,:,43) + het_rates(:,:,120)) &
                 * y(:,:,120)
         prod(:,:,9) = 0._r8
         loss(:,:,10) = (rxt(:,:,139)* y(:,:,3) + rxt(:,:,44) + het_rates(:,:,121)) &
                 * y(:,:,121)
         prod(:,:,10) = 0._r8
         loss(:,:,11) = (rxt(:,:,140)* y(:,:,3) +rxt(:,:,254)* y(:,:,23) + rxt(:,:,45) &
                  + het_rates(:,:,113))* y(:,:,113)
         prod(:,:,11) = 0._r8
         loss(:,:,12) = (rxt(:,:,141)* y(:,:,3) +rxt(:,:,257)* y(:,:,23) + rxt(:,:,46) &
                  + het_rates(:,:,118))* y(:,:,118)
         prod(:,:,12) = 0._r8
         loss(:,:,13) = (rxt(:,:,142)* y(:,:,3) +rxt(:,:,258)* y(:,:,23) + rxt(:,:,47) &
                  + het_rates(:,:,119))* y(:,:,119)
         prod(:,:,13) = 0._r8
         loss(:,:,14) = (rxt(:,:,143)* y(:,:,3) + rxt(:,:,38) + het_rates(:,:,114)) &
                 * y(:,:,114)
         prod(:,:,14) = 0._r8
         loss(:,:,15) = (rxt(:,:,253)* y(:,:,23) + rxt(:,:,39) + het_rates(:,:,115)) &
                 * y(:,:,115)
         prod(:,:,15) = 0._r8
         loss(:,:,16) = (rxt(:,:,146)* y(:,:,3) + rxt(:,:,49) + het_rates(:,:,116)) &
                 * y(:,:,116)
         prod(:,:,16) = 0._r8
         loss(:,:,17) = (rxt(:,:,145)* y(:,:,3) + rxt(:,:,50) + het_rates(:,:,117)) &
                 * y(:,:,117)
         prod(:,:,17) = 0._r8
         loss(:,:,18) = (rxt(:,:,147)* y(:,:,3) + rxt(:,:,53) + het_rates(:,:,122)) &
                 * y(:,:,122)
         prod(:,:,18) = 0._r8
         loss(:,:,19) = (rxt(:,:,148)* y(:,:,3) + rxt(:,:,54) + het_rates(:,:,123)) &
                 * y(:,:,123)
         prod(:,:,19) = 0._r8
         loss(:,:,20) = (rxt(:,:,149)* y(:,:,3) +rxt(:,:,260)* y(:,:,23) +rxt(:,:,262) &
                 * y(:,:,28) + rxt(:,:,51) + het_rates(:,:,124))* y(:,:,124)
         prod(:,:,20) = 0._r8
         loss(:,:,21) = (rxt(:,:,150)* y(:,:,3) +rxt(:,:,259)* y(:,:,23) +rxt(:,:,261) &
                 * y(:,:,28) + rxt(:,:,52) + het_rates(:,:,125))* y(:,:,125)
         prod(:,:,21) = 0._r8
         loss(:,:,22) = (rxt(:,:,453)* y(:,:,130) + rxt(:,:,58) + rxt(:,:,114) &
                  + het_rates(:,:,126))* y(:,:,126)
         prod(:,:,22) =.440_r8*rxt(:,:,60)*y(:,:,15)
         loss(:,:,23) = ( + het_rates(:,:,26))* y(:,:,26)
         prod(:,:,23) = 0._r8
         loss(:,:,24) = ( + het_rates(:,:,27))* y(:,:,27)
         prod(:,:,24) = 0._r8
         loss(:,:,25) = ( + rxt(:,:,470) + het_rates(:,:,181))* y(:,:,181)
         prod(:,:,25) = 0._r8
         loss(:,:,26) = ( + rxt(:,:,471) + het_rates(:,:,182))* y(:,:,182)
         prod(:,:,26) = 0._r8
         loss(:,:,27) = ( + rxt(:,:,472) + het_rates(:,:,183))* y(:,:,183)
         prod(:,:,27) = 0._r8
         loss(:,:,28) = ( + rxt(:,:,464) + het_rates(:,:,170))* y(:,:,170)
         prod(:,:,28) = 0._r8
         loss(:,:,29) = ( + rxt(:,:,465) + het_rates(:,:,171))* y(:,:,171)
         prod(:,:,29) = 0._r8
         loss(:,:,30) = ( + rxt(:,:,466) + het_rates(:,:,172))* y(:,:,172)
         prod(:,:,30) = 0._r8
         loss(:,:,31) = ( + het_rates(:,:,173))* y(:,:,173)
         prod(:,:,31) = 0._r8
         loss(:,:,32) = ( + rxt(:,:,467) + het_rates(:,:,174))* y(:,:,174)
         prod(:,:,32) = 0._r8
         loss(:,:,33) = ( + rxt(:,:,468) + het_rates(:,:,175))* y(:,:,175)
         prod(:,:,33) = 0._r8
         loss(:,:,34) = ( + rxt(:,:,469) + het_rates(:,:,176))* y(:,:,176)
         prod(:,:,34) = 0._r8
         loss(:,:,35) = ( + rxt(:,:,431) + het_rates(:,:,177))* y(:,:,177)
         prod(:,:,35) = 0._r8
         loss(:,:,36) = ( + rxt(:,:,87) + het_rates(:,:,178))* y(:,:,178)
         prod(:,:,36) = 0._r8
         loss(:,:,37) = ( + rxt(:,:,88) + het_rates(:,:,179))* y(:,:,179)
         prod(:,:,37) = 0._r8

      end subroutine exp_prod_loss

      subroutine imp_prod_loss( prod, loss, y, rxt, het_rates )

      use ppgrid, only : pver

      implicit none

!--------------------------------------------------------------------
! ... dummy args
!--------------------------------------------------------------------
      real(r8), dimension(:), intent(out) :: &
            prod, &
            loss
      real(r8), intent(in) :: y(:)
      real(r8), intent(in) :: rxt(:)
      real(r8), intent(in) :: het_rates(:)



!--------------------------------------------------------------------
! ... loss and production for Implicit method
!--------------------------------------------------------------------


         loss(139) = (rxt(116)* y(2) +rxt(134)* y(3) +rxt(189)* y(9) +rxt(192)* y(10) &
                  +rxt(161)* y(22) +rxt(166)* y(23) +rxt(174)* y(24) +rxt(204)* y(28) &
                  +rxt(231)* y(37) +rxt(290)* y(44) +rxt(311)* y(59) +rxt(333)* y(77) &
                  +rxt(339)* y(78) +rxt(357)* y(83) +rxt(395)* y(105) + rxt(3) &
                  + rxt(4) + het_rates(1))* y(1)
         prod(139) = (.200_r8*rxt(333)*y(77) +.200_r8*rxt(339)*y(78) + &
                 .100_r8*rxt(357)*y(83))*y(1) + (.250_r8*rxt(301)*y(48) + &
                 .250_r8*rxt(349)*y(76))*y(24) +rxt(115)*y(4)*y(2)
         loss(146) = (rxt(116)* y(1) + 2._r8*rxt(117)* y(2) +rxt(115)* y(4) +rxt(187) &
                 * y(9) + (rxt(190) +rxt(191))* y(10) +rxt(198)* y(11) +rxt(268) &
                 * y(19) +rxt(172)* y(21) +rxt(165)* y(23) +rxt(173)* y(24) +rxt(176) &
                 * y(25) +rxt(211)* y(30) +rxt(224)* y(33) +rxt(225)* y(34) +rxt(228) &
                 * y(35) +rxt(234)* y(38) +rxt(244)* y(39) +rxt(245)* y(40) +rxt(246) &
                 * y(41) + (rxt(451) +rxt(452))* y(127) +rxt(458)* y(129) + rxt(89) &
                  + rxt(90) + rxt(91) + rxt(102) + rxt(103) + rxt(104) + het_rates(2)) &
                 * y(2)
         prod(146) = (rxt(1) +2.000_r8*rxt(2) +rxt(95) +rxt(96) +rxt(97) + &
                 2.000_r8*rxt(100) +rxt(107) +rxt(108) +rxt(109) +2.000_r8*rxt(112) + &
                 rxt(129)*y(3) +rxt(130)*y(3) +rxt(182)*y(8) +rxt(449)*y(130) + &
                 rxt(457)*y(129))*y(4) + (rxt(183)*y(9) +rxt(184)*y(10) + &
                 rxt(454)*y(128))*y(8) + (rxt(461)*y(131) +1.150_r8*rxt(462)*y(128)) &
                 *y(132) +rxt(4)*y(1) +rxt(128)*y(3) +rxt(6)*y(9) +rxt(8)*y(10) &
                  +rxt(12)*y(11) +rxt(10)*y(14) +rxt(164)*y(24)*y(22) +rxt(168)*y(23) &
                 *y(23) +rxt(24)*y(30) +rxt(25)*y(31) +rxt(32)*y(38) +rxt(21)*y(134)
         loss(143) = (rxt(134)* y(1) + (rxt(129) +rxt(130))* y(4) + (rxt(132) + &
                 rxt(133))* y(7) + (rxt(153) +rxt(154) +rxt(155))* y(15) +rxt(156) &
                 * y(21) +rxt(157)* y(33) +rxt(158)* y(39) +rxt(159)* y(42) +rxt(144) &
                 * y(109) +rxt(135)* y(110) +rxt(136)* y(111) +rxt(137)* y(112) &
                  +rxt(140)* y(113) +rxt(143)* y(114) +rxt(146)* y(116) +rxt(145) &
                 * y(117) +rxt(141)* y(118) +rxt(142)* y(119) +rxt(138)* y(120) &
                  +rxt(139)* y(121) +rxt(147)* y(122) +rxt(148)* y(123) +rxt(149) &
                 * y(124) +rxt(150)* y(125) +rxt(131)* y(134) +rxt(151)* y(138) &
                  +rxt(152)* y(139) + rxt(128) + het_rates(3))* y(3)
         prod(143) = (rxt(1) +rxt(179)*y(133))*y(4) +rxt(3)*y(1) &
                  +.850_r8*rxt(462)*y(132)*y(128) +rxt(20)*y(134)
         loss(129) = (rxt(115)* y(2) +rxt(129)* y(3) +rxt(125)* y(6) +rxt(182)* y(8) &
                  +rxt(160)* y(22) +rxt(288)* y(56) +rxt(459)* y(127) + (rxt(456) + &
                 rxt(457))* y(129) +rxt(449)* y(130) +rxt(179)* y(133) + rxt(1) &
                  + rxt(2) + rxt(93) + rxt(95) + rxt(96) + rxt(97) + rxt(100) &
                  + rxt(105) + rxt(107) + rxt(108) + rxt(109) + rxt(112) &
                  + het_rates(4))* y(4)
         prod(129) = (rxt(163)*y(22) +rxt(167)*y(23) +rxt(173)*y(2) + &
                 2.000_r8*rxt(174)*y(1) +rxt(175)*y(24) +rxt(200)*y(11) + &
                 rxt(207)*y(28) +rxt(214)*y(30) +rxt(232)*y(37) +rxt(236)*y(38) + &
                 rxt(271)*y(16) +rxt(293)*y(46) +rxt(314)*y(61) +rxt(319)*y(64) + &
                 rxt(323)*y(67) +.750_r8*rxt(349)*y(76))*y(24) + (rxt(4) + &
                 2.000_r8*rxt(116)*y(2) +2.000_r8*rxt(134)*y(3) +rxt(161)*y(22) + &
                 rxt(166)*y(23) +rxt(189)*y(9) +rxt(192)*y(10) +rxt(204)*y(28) + &
                 rxt(231)*y(37))*y(1) + (rxt(117)*y(2) +rxt(124)*y(6) + &
                 rxt(165)*y(23) +rxt(190)*y(10) +rxt(198)*y(11) +rxt(211)*y(30) + &
                 rxt(234)*y(38))*y(2) + (rxt(213)*y(23) +rxt(218)*y(30) + &
                 rxt(219)*y(30) +rxt(240)*y(38) +rxt(241)*y(38))*y(30) + (rxt(126) + &
                 rxt(127) +2.000_r8*rxt(125)*y(4))*y(6) +rxt(133)*y(7)*y(3) +rxt(123) &
                 *y(5) +rxt(186)*y(10)*y(8) +rxt(455)*y(128)*y(9) +rxt(13)*y(11) &
                  +rxt(202)*y(23)*y(13) +rxt(242)*y(38)*y(38)
         loss(43) = (rxt(121)* y(1) +rxt(118)* y(2) +rxt(119)* y(4) +rxt(122)* y(126) &
                  + rxt(120) + rxt(123) + het_rates(5))* y(5)
         prod(43) =rxt(129)*y(4)*y(3)
         loss(42) = (rxt(124)* y(2) +rxt(125)* y(4) + rxt(126) + rxt(127) &
                  + het_rates(6))* y(6)
         prod(42) = (rxt(120) +rxt(122)*y(126) +rxt(118)*y(2) +rxt(119)*y(4) + &
                 rxt(121)*y(1))*y(5) +rxt(3)*y(1)
         loss(120) = (rxt(172)* y(2) +rxt(156)* y(3) +rxt(170)* y(23) +rxt(205)* y(28) &
                  +rxt(248)* y(141) + het_rates(21))* y(21)
         prod(120) =rxt(155)*y(15)*y(3) +rxt(18)*y(19) +rxt(163)*y(24)*y(22) +rxt(20) &
                 *y(134)
         loss(115) = ((rxt(264) +rxt(265))* y(23) + het_rates(20))* y(20)
         prod(115) = (rxt(17) +rxt(18) +rxt(209)*y(28) +rxt(233)*y(37) + &
                 rxt(266)*y(11) +rxt(267)*y(23) +rxt(268)*y(2))*y(19) &
                  + (.500_r8*rxt(290)*y(44) +.560_r8*rxt(311)*y(59) + &
                 .050_r8*rxt(333)*y(77) +.200_r8*rxt(339)*y(78) + &
                 .300_r8*rxt(357)*y(83))*y(1) + (.220_r8*rxt(340)*y(9) + &
                 .220_r8*rxt(342)*y(11) +.110_r8*rxt(344)*y(16) + &
                 .220_r8*rxt(345)*y(48))*y(79) + (.250_r8*rxt(375)*y(9) + &
                 .500_r8*rxt(376)*y(11) +.200_r8*rxt(378)*y(16) + &
                 .250_r8*rxt(379)*y(48))*y(91) + (.350_r8*rxt(283)*y(135) + &
                 rxt(306)*y(53) +rxt(327)*y(68))*y(23) + (rxt(74) +rxt(328)*y(11)) &
                 *y(68) +rxt(251)*y(108)*y(28) +rxt(61)*y(50) +rxt(79)*y(52) &
                  +2.000_r8*rxt(82)*y(53) +.700_r8*rxt(68)*y(77) +1.340_r8*rxt(67) &
                 *y(78) +.450_r8*rxt(81)*y(86) +rxt(76)*y(90) +rxt(453)*y(130)*y(126)
         loss(105) = (rxt(182)* y(4) +rxt(183)* y(9) + (rxt(184) +rxt(185) +rxt(186)) &
                 * y(10) +rxt(181)* y(23) +rxt(454)* y(128) + rxt(92) + het_rates(8)) &
                 * y(8)
         prod(105) = (rxt(180)*y(133) +rxt(458)*y(129))*y(2) &
                  + (.200_r8*rxt(461)*y(131) +1.100_r8*rxt(463)*y(127))*y(132) &
                  +rxt(456)*y(129)*y(4) +rxt(6)*y(9) +rxt(450)*y(130)
         loss(134) = (rxt(189)* y(1) +rxt(187)* y(2) +rxt(183)* y(8) +rxt(197)* y(11) &
                  +rxt(270)* y(16) +rxt(188)* y(24) +rxt(216)* y(30) +rxt(237)* y(38) &
                  +rxt(292)* y(46) +rxt(299)* y(48) +rxt(286)* y(55) +rxt(313)* y(61) &
                  +rxt(318)* y(64) +rxt(322)* y(67) +rxt(331)* y(73) +rxt(335)* y(74) &
                  +rxt(347)* y(76) + (rxt(340) +rxt(341))* y(79) +rxt(372)* y(84) &
                  +rxt(359)* y(88) +rxt(365)* y(89) +rxt(375)* y(91) +rxt(383)* y(96) &
                  +rxt(390)* y(100) +rxt(393)* y(103) +rxt(397)* y(106) +rxt(455) &
                 * y(128) +rxt(278)* y(137) + rxt(6) + rxt(7) + het_rates(9))* y(9)
         prod(134) = (rxt(8) +.500_r8*rxt(402) +2.000_r8*rxt(185)*y(8) +rxt(190)*y(2)) &
                 *y(10) + (rxt(179)*y(133) +rxt(182)*y(8))*y(4) &
                  +2.000_r8*rxt(132)*y(7)*y(3) +rxt(181)*y(23)*y(8) +rxt(13)*y(11) &
                  +rxt(10)*y(14) +rxt(460)*y(128)
         loss(144) = (rxt(192)* y(1) + (rxt(190) +rxt(191))* y(2) + (rxt(184) + &
                 rxt(185) +rxt(186))* y(8) +rxt(193)* y(11) +rxt(195)* y(23) +rxt(201) &
                 * y(24) +rxt(217)* y(30) +rxt(238)* y(38) +rxt(300)* y(48) +rxt(353) &
                 * y(76) +rxt(387)* y(98) + rxt(8) + rxt(402) + het_rates(10))* y(10)
         prod(144) = (rxt(187)*y(2) +rxt(188)*y(24) +rxt(189)*y(1) + &
                 2.000_r8*rxt(197)*y(11) +rxt(216)*y(30) +rxt(237)*y(38) + &
                 rxt(270)*y(16) +rxt(278)*y(137) +rxt(286)*y(55) +rxt(292)*y(46) + &
                 rxt(299)*y(48) +rxt(313)*y(61) +rxt(318)*y(64) +rxt(322)*y(67) + &
                 rxt(331)*y(73) +rxt(335)*y(74) +rxt(340)*y(79) +rxt(347)*y(76) + &
                 .920_r8*rxt(359)*y(88) +1.206_r8*rxt(365)*y(89) + &
                 .900_r8*rxt(372)*y(84) +rxt(375)*y(91) +.900_r8*rxt(383)*y(96) + &
                 .900_r8*rxt(390)*y(100) +.900_r8*rxt(393)*y(103) +rxt(397)*y(106)) &
                 *y(9) + (rxt(12) +rxt(198)*y(2) +rxt(199)*y(23) +rxt(200)*y(24) + &
                 rxt(342)*y(79) +rxt(348)*y(76) +rxt(360)*y(88) + &
                 1.206_r8*rxt(366)*y(89) +rxt(370)*y(90) +rxt(376)*y(91) + &
                 rxt(396)*y(105))*y(11) + (rxt(15) +rxt(203) +rxt(202)*y(23))*y(13) &
                  + (rxt(9) +rxt(194))*y(14) + (rxt(329)*y(82) + &
                 .400_r8*rxt(369)*y(90))*y(23) + (.600_r8*rxt(64) +rxt(308))*y(58) &
                  + (rxt(65) +rxt(354))*y(81) +.700_r8*rxt(387)*y(98)*y(10) +rxt(11) &
                 *y(12) +.206_r8*rxt(367)*y(89)*y(24) +rxt(30)*y(35) +rxt(36)*y(41) &
                  +rxt(76)*y(90)
         loss(138) = (rxt(166)* y(1) +rxt(165)* y(2) +rxt(181)* y(8) +rxt(195)* y(10) &
                  +rxt(199)* y(11) +rxt(196)* y(12) +rxt(202)* y(13) +rxt(263)* y(15) &
                  +rxt(275)* y(17) +rxt(274)* y(18) +rxt(267)* y(19) + (rxt(264) + &
                 rxt(265))* y(20) +rxt(170)* y(21) + 2._r8*(rxt(168) +rxt(169))* y(23) &
                  +rxt(167)* y(24) +rxt(171)* y(25) + (rxt(212) +rxt(213))* y(30) &
                  +rxt(223)* y(33) +rxt(227)* y(34) +rxt(229)* y(35) +rxt(235)* y(38) &
                  +rxt(243)* y(39) +rxt(177)* y(42) +rxt(178)* y(43) +rxt(285)* y(44) &
                  +rxt(284)* y(45) +rxt(296)* y(47) +rxt(291)* y(49) +rxt(297)* y(50) &
                  +rxt(307)* y(51) +rxt(305)* y(52) +rxt(306)* y(53) +rxt(304)* y(54) &
                  +rxt(309)* y(58) +rxt(310)* y(59) +rxt(317)* y(60) +rxt(316)* y(62) &
                  +rxt(321)* y(63) +rxt(320)* y(65) +rxt(326)* y(66) +rxt(327)* y(68) &
                  +rxt(325)* y(69) +rxt(330)* y(70) +rxt(368)* y(71) +rxt(334)* y(72) &
                  +rxt(337)* y(75) +rxt(332)* y(77) +rxt(338)* y(78) +rxt(346)* y(80) &
                  +rxt(355)* y(81) +rxt(329)* y(82) +rxt(356)* y(83) +rxt(374)* y(85) &
                  +rxt(371)* y(87) +rxt(369)* y(90) +rxt(380)* y(92) +rxt(362)* y(93) &
                  +rxt(382)* y(94) +rxt(386)* y(95) +rxt(385)* y(97) +rxt(388)* y(99) &
                  +rxt(391)* y(102) +rxt(394)* y(105) +rxt(399)* y(107) +rxt(252) &
                 * y(108) +rxt(255)* y(109) +rxt(254)* y(113) +rxt(253)* y(115) &
                  +rxt(257)* y(118) +rxt(258)* y(119) +rxt(260)* y(124) +rxt(259) &
                 * y(125) +rxt(283)* y(135) +rxt(276)* y(136) +rxt(404)* y(156) &
                  + (rxt(405) +rxt(406))* y(157) +rxt(408)* y(159) + het_rates(23)) &
                 * y(23)
         prod(138) = (rxt(161)*y(22) +rxt(174)*y(24) +.120_r8*rxt(290)*y(44) + &
                 .330_r8*rxt(311)*y(59) +.080_r8*rxt(333)*y(77) + &
                 .215_r8*rxt(339)*y(78) +.270_r8*rxt(357)*y(83) + &
                 .700_r8*rxt(395)*y(105))*y(1) + (rxt(172)*y(21) +rxt(173)*y(24) + &
                 rxt(176)*y(25) +rxt(224)*y(33) +rxt(225)*y(34) +rxt(244)*y(39) + &
                 rxt(245)*y(40) +rxt(268)*y(19))*y(2) + (rxt(153)*y(15) + &
                 2.000_r8*rxt(131)*y(134) +rxt(156)*y(21) +rxt(157)*y(33) + &
                 rxt(158)*y(39) +rxt(159)*y(42))*y(3) + (.300_r8*rxt(275)*y(17) + &
                 .650_r8*rxt(283)*y(135) +.500_r8*rxt(296)*y(47) + &
                 .500_r8*rxt(320)*y(65) +.100_r8*rxt(346)*y(80))*y(23) &
                  + (2.000_r8*rxt(162)*y(22) +rxt(188)*y(9) +rxt(200)*y(11) + &
                 rxt(208)*y(28) +.206_r8*rxt(367)*y(89))*y(24) + (rxt(19) + &
                 rxt(247)*y(141))*y(134) +.500_r8*rxt(402)*y(10) +rxt(11)*y(12) &
                  +rxt(14)*y(13) +rxt(16)*y(17) +2.000_r8*rxt(22)*y(25) +rxt(27)*y(34) &
                  +rxt(33)*y(40) +rxt(69)*y(47) +rxt(63)*y(54) +rxt(70)*y(57) +rxt(71) &
                 *y(62) +rxt(62)*y(65) +rxt(72)*y(69) +rxt(84)*y(75) +rxt(83)*y(85) &
                  +rxt(75)*y(92) +rxt(85)*y(97) +rxt(86)*y(107)
         loss(135) = (rxt(198)* y(2) +rxt(197)* y(9) +rxt(193)* y(10) +rxt(266)* y(19) &
                  +rxt(199)* y(23) +rxt(200)* y(24) +rxt(298)* y(50) +rxt(312)* y(59) &
                  +rxt(328)* y(68) +rxt(348)* y(76) +rxt(342)* y(79) +rxt(358)* y(83) &
                  +rxt(360)* y(88) +rxt(366)* y(89) +rxt(370)* y(90) +rxt(376)* y(91) &
                  +rxt(396)* y(105) +rxt(407)* y(157) + rxt(12) + rxt(13) + rxt(401) &
                  + het_rates(11))* y(11)
         prod(135) = (rxt(196)*y(12) +rxt(229)*y(35) +rxt(309)*y(58) + &
                 .500_r8*rxt(355)*y(81))*y(23) + (rxt(191)*y(10) +rxt(228)*y(35) + &
                 rxt(246)*y(41))*y(2) + (rxt(9) +rxt(10) +rxt(194))*y(14) + (rxt(29) + &
                 rxt(230)*y(28))*y(35) +rxt(192)*y(10)*y(1) +rxt(250)*y(141)*y(12) &
                  +rxt(14)*y(13) +rxt(35)*y(41) +.400_r8*rxt(64)*y(58)
         loss(131) = (rxt(196)* y(23) +rxt(250)* y(141) + rxt(11) + het_rates(12)) &
                 * y(12)
         prod(131) = (rxt(433) +rxt(439) +rxt(444) +rxt(435)*y(33) +rxt(440)*y(33) + &
                 rxt(446)*y(33))*y(35) + (rxt(401) +rxt(266)*y(19) +rxt(298)*y(50) + &
                 rxt(328)*y(68) +rxt(407)*y(157))*y(11) + (2.000_r8*rxt(400) + &
                 2.000_r8*rxt(432) +2.000_r8*rxt(438) +2.000_r8*rxt(443))*y(14) &
                  + (rxt(434) +rxt(442) +rxt(445))*y(41) + (.500_r8*rxt(402) + &
                 rxt(195)*y(23))*y(10)
         loss(73) = (rxt(202)* y(23) + rxt(14) + rxt(15) + rxt(203) + het_rates(13)) &
                 * y(13)
         prod(73) =rxt(201)*y(24)*y(10)
         loss(55) = ( + rxt(9) + rxt(10) + rxt(194) + rxt(400) + rxt(432) + rxt(438) &
                  + rxt(443) + het_rates(14))* y(14)
         prod(55) =rxt(193)*y(11)*y(10)
         loss(136) = (rxt(270)* y(9) + 2._r8*(rxt(272) +rxt(273))* y(16) +rxt(271) &
                 * y(24) +rxt(215)* y(30) +rxt(294)* y(46) +rxt(302)* y(48) +rxt(315) &
                 * y(61) +rxt(324)* y(67) +rxt(350)* y(76) +rxt(344)* y(79) +rxt(363) &
                 * y(88) +rxt(378)* y(91) + het_rates(16))* y(16)
         prod(136) = (rxt(299)*y(9) +.900_r8*rxt(302)*y(16) +2.000_r8*rxt(303)*y(48) + &
                 rxt(345)*y(79) +rxt(351)*y(76) +rxt(364)*y(88) +rxt(379)*y(91))*y(48) &
                  + (rxt(153)*y(3) +rxt(210)*y(28) +rxt(249)*y(141) +rxt(263)*y(23)) &
                 *y(15) + (.700_r8*rxt(275)*y(17) +rxt(291)*y(49))*y(23) &
                  +.310_r8*rxt(311)*y(59)*y(1) +rxt(61)*y(50) +rxt(63)*y(54) &
                  +.400_r8*rxt(64)*y(58) +rxt(73)*y(63) +.300_r8*rxt(68)*y(77)
         loss(67) = (rxt(275)* y(23) + rxt(16) + het_rates(17))* y(17)
         prod(67) =rxt(271)*y(24)*y(16)
         loss(47) = (rxt(159)* y(3) +rxt(177)* y(23) + het_rates(42))* y(42)
         prod(47) = 0._r8
         loss(34) = (rxt(178)* y(23) + het_rates(43))* y(43)
         prod(34) = 0._r8
         loss(140) = (rxt(268)* y(2) +rxt(266)* y(11) +rxt(267)* y(23) +rxt(269) &
                 * y(24) +rxt(209)* y(28) +rxt(233)* y(37) + rxt(17) + rxt(18) &
                  + het_rates(19))* y(19)
         prod(140) = (rxt(215)*y(30) +rxt(270)*y(9) +2.000_r8*rxt(272)*y(16) + &
                 rxt(273)*y(16) +.700_r8*rxt(294)*y(46) +rxt(302)*y(48) + &
                 rxt(315)*y(61) +.800_r8*rxt(324)*y(67) +.880_r8*rxt(344)*y(79) + &
                 2.000_r8*rxt(350)*y(76) +1.200_r8*rxt(363)*y(88) + &
                 .800_r8*rxt(378)*y(91))*y(16) + (.500_r8*rxt(286)*y(55) + &
                 rxt(318)*y(64) +rxt(322)*y(67) +.500_r8*rxt(331)*y(73) + &
                 .250_r8*rxt(340)*y(79) +rxt(347)*y(76) +.550_r8*rxt(359)*y(88) + &
                 .072_r8*rxt(365)*y(89) +.100_r8*rxt(372)*y(84) + &
                 .250_r8*rxt(375)*y(91))*y(9) + (rxt(274)*y(18) + &
                 .300_r8*rxt(275)*y(17) +.500_r8*rxt(304)*y(54) + &
                 .800_r8*rxt(305)*y(52) +rxt(309)*y(58) +.500_r8*rxt(355)*y(81))*y(23) &
                  + (rxt(290)*y(44) +.540_r8*rxt(311)*y(59) +.800_r8*rxt(333)*y(77) + &
                 .700_r8*rxt(339)*y(78) +.600_r8*rxt(357)*y(83))*y(1) &
                  + (.250_r8*rxt(342)*y(79) +rxt(348)*y(76) +.600_r8*rxt(360)*y(88) + &
                 .072_r8*rxt(366)*y(89))*y(11) + (.250_r8*rxt(345)*y(79) + &
                 rxt(351)*y(76) +.600_r8*rxt(364)*y(88) +.250_r8*rxt(379)*y(91))*y(48) &
                  + (rxt(154)*y(15) +rxt(155)*y(15))*y(3) +rxt(16)*y(17) &
                  +.206_r8*rxt(367)*y(89)*y(24) +rxt(79)*y(52) +2.000_r8*rxt(289) &
                 *y(56) +rxt(62)*y(65) +rxt(78)*y(66) +rxt(72)*y(69) &
                  +2.000_r8*rxt(352)*y(76)*y(76) +1.340_r8*rxt(66)*y(78) &
                  +.100_r8*rxt(83)*y(85) +rxt(76)*y(90) +.690_r8*rxt(77)*y(93) &
                  +rxt(277)*y(137)
         loss(141) = (rxt(161)* y(1) +rxt(160)* y(4) + (rxt(162) +rxt(163) +rxt(164)) &
                 * y(24) + het_rates(22))* y(22)
         prod(141) = (rxt(156)*y(3) +rxt(170)*y(23) +rxt(172)*y(2) +rxt(205)*y(28) + &
                 rxt(248)*y(141))*y(21) + (rxt(165)*y(2) +rxt(181)*y(8) + &
                 rxt(264)*y(20) +rxt(267)*y(19))*y(23) + (rxt(19) +2.000_r8*rxt(21)) &
                 *y(134) +rxt(154)*y(15)*y(3) +rxt(16)*y(17) +2.000_r8*rxt(17)*y(19) &
                  +rxt(28)*y(33) +rxt(34)*y(39) +rxt(57)*y(140)
         loss(142) = (rxt(174)* y(1) +rxt(173)* y(2) +rxt(188)* y(9) +rxt(201)* y(10) &
                  +rxt(200)* y(11) +rxt(271)* y(16) +rxt(269)* y(19) + (rxt(162) + &
                 rxt(163) +rxt(164))* y(22) +rxt(167)* y(23) + 2._r8*rxt(175)* y(24) &
                  + (rxt(207) +rxt(208))* y(28) +rxt(214)* y(30) +rxt(232)* y(37) &
                  +rxt(236)* y(38) +rxt(293)* y(46) +rxt(301)* y(48) +rxt(287)* y(55) &
                  +rxt(314)* y(61) +rxt(319)* y(64) +rxt(323)* y(67) +rxt(336)* y(74) &
                  +rxt(349)* y(76) +rxt(343)* y(79) +rxt(373)* y(84) +rxt(361)* y(88) &
                  +rxt(367)* y(89) +rxt(377)* y(91) +rxt(384)* y(96) +rxt(389)* y(100) &
                  +rxt(392)* y(103) +rxt(398)* y(106) +rxt(279)* y(137) + rxt(410) &
                  + het_rates(24))* y(24)
         prod(142) = (rxt(252)*y(108) +rxt(255)*y(109) +rxt(166)*y(1) + &
                 rxt(171)*y(25) +rxt(177)*y(42) +rxt(178)*y(43) +rxt(199)*y(11) + &
                 rxt(212)*y(30) +rxt(235)*y(38) +rxt(265)*y(20) +rxt(274)*y(18) + &
                 rxt(276)*y(136) +.350_r8*rxt(283)*y(135) +rxt(305)*y(52) + &
                 rxt(306)*y(53) +rxt(307)*y(51) +rxt(326)*y(66) + &
                 .200_r8*rxt(346)*y(80) +.500_r8*rxt(355)*y(81) +rxt(369)*y(90) + &
                 .250_r8*rxt(382)*y(94) +.500_r8*rxt(406)*y(157))*y(23) &
                  + (rxt(270)*y(16) +rxt(278)*y(137) +.250_r8*rxt(286)*y(55) + &
                 rxt(292)*y(46) +rxt(313)*y(61) +rxt(318)*y(64) +rxt(331)*y(73) + &
                 .470_r8*rxt(340)*y(79) +.920_r8*rxt(359)*y(88) + &
                 .794_r8*rxt(365)*y(89) +.900_r8*rxt(372)*y(84) +rxt(375)*y(91) + &
                 .900_r8*rxt(383)*y(96) +.900_r8*rxt(390)*y(100) + &
                 .900_r8*rxt(393)*y(103) +rxt(397)*y(106))*y(9) + (rxt(215)*y(30) + &
                 2.000_r8*rxt(272)*y(16) +rxt(294)*y(46) +.900_r8*rxt(302)*y(48) + &
                 rxt(315)*y(61) +.300_r8*rxt(324)*y(67) +.730_r8*rxt(344)*y(79) + &
                 rxt(350)*y(76) +rxt(363)*y(88) +.800_r8*rxt(378)*y(91))*y(16) &
                  + (.120_r8*rxt(290)*y(44) +.190_r8*rxt(311)*y(59) + &
                 .060_r8*rxt(333)*y(77) +.275_r8*rxt(339)*y(78) + &
                 .060_r8*rxt(357)*y(83) +rxt(395)*y(105))*y(1) + (rxt(266)*y(19) + &
                 .470_r8*rxt(342)*y(79) +rxt(360)*y(88) +.794_r8*rxt(366)*y(89) + &
                 rxt(370)*y(90) +rxt(376)*y(91))*y(11) + (rxt(251)*y(108) + &
                 rxt(256)*y(109) +rxt(206)*y(25) +rxt(209)*y(19))*y(28) &
                  + (.470_r8*rxt(345)*y(79) +rxt(364)*y(88) +rxt(379)*y(91))*y(48) &
                  + (rxt(176)*y(25) +rxt(268)*y(19))*y(2) + (rxt(160)*y(22) + &
                 rxt(288)*y(56))*y(4) + (rxt(15) +rxt(203))*y(13) &
                  + (1.340_r8*rxt(66) +.660_r8*rxt(67))*y(78) +rxt(154)*y(15)*y(3) &
                  +.700_r8*rxt(387)*y(98)*y(10) +rxt(233)*y(37)*y(19) &
                  +1.200_r8*rxt(295)*y(46)*y(46) +rxt(69)*y(47) +rxt(61)*y(50) &
                  +2.000_r8*rxt(79)*y(52) +2.000_r8*rxt(82)*y(53) +rxt(289)*y(56) &
                  +rxt(71)*y(62) +rxt(62)*y(65) +rxt(78)*y(66) +rxt(74)*y(68) &
                  +.900_r8*rxt(83)*y(85) +.560_r8*rxt(81)*y(86) +rxt(76)*y(90) &
                  +rxt(77)*y(93) +rxt(86)*y(107) +rxt(277)*y(137)
         loss(89) = (rxt(176)* y(2) +rxt(171)* y(23) +rxt(206)* y(28) + rxt(22) &
                  + het_rates(25))* y(25)
         prod(89) = (.500_r8*rxt(410) +rxt(175)*y(24))*y(24) +rxt(169)*y(23)*y(23)
         loss(130) = (rxt(131)* y(3) +rxt(247)* y(141) + rxt(19) + rxt(20) + rxt(21) &
                  + het_rates(134))* y(134)
         prod(130) = (rxt(252)*y(108) +rxt(253)*y(115) +rxt(254)*y(113) + &
                 rxt(255)*y(109) +rxt(259)*y(125) +rxt(263)*y(15) +rxt(167)*y(24) + &
                 rxt(168)*y(23) +rxt(170)*y(21) +rxt(171)*y(25) +rxt(196)*y(12) + &
                 rxt(202)*y(13) +rxt(223)*y(33) +rxt(227)*y(34) +rxt(243)*y(39) + &
                 rxt(267)*y(19) +rxt(275)*y(17) +rxt(276)*y(136) +rxt(284)*y(45) + &
                 rxt(291)*y(49) +rxt(297)*y(50) +rxt(304)*y(54) +rxt(316)*y(62) + &
                 rxt(317)*y(60) +rxt(320)*y(65) +rxt(321)*y(63) +rxt(325)*y(69) + &
                 rxt(327)*y(68) +.500_r8*rxt(338)*y(78) +rxt(380)*y(92) + &
                 rxt(381)*y(92) +rxt(408)*y(159))*y(23) + (rxt(436)*y(34) + &
                 rxt(437)*y(40) +rxt(441)*y(34) +rxt(447)*y(34) +rxt(448)*y(40))*y(33) &
                  +rxt(164)*y(24)*y(22)
         loss(145) = (rxt(204)* y(1) +rxt(210)* y(15) +rxt(209)* y(19) +rxt(205) &
                 * y(21) + (rxt(207) +rxt(208))* y(24) +rxt(206)* y(25) +rxt(226) &
                 * y(34) +rxt(230)* y(35) +rxt(282)* y(45) +rxt(251)* y(108) +rxt(256) &
                 * y(109) +rxt(262)* y(124) +rxt(261)* y(125) + het_rates(28))* y(28)
         prod(145) = (2.000_r8*rxt(135)*y(110) +2.000_r8*rxt(136)*y(111) + &
                 2.000_r8*rxt(137)*y(112) +2.000_r8*rxt(138)*y(120) +rxt(139)*y(121) + &
                 rxt(140)*y(113) +rxt(141)*y(118) +rxt(142)*y(119) + &
                 4.000_r8*rxt(143)*y(114) +rxt(145)*y(117) +rxt(152)*y(139) + &
                 rxt(157)*y(33))*y(3) + (rxt(24) +rxt(211)*y(2) +rxt(212)*y(23) + &
                 rxt(215)*y(16) +rxt(216)*y(9) +2.000_r8*rxt(218)*y(30) + &
                 rxt(220)*y(30) +rxt(240)*y(38))*y(30) + (rxt(252)*y(108) + &
                 3.000_r8*rxt(253)*y(115) +rxt(254)*y(113) +rxt(257)*y(118) + &
                 rxt(258)*y(119) +rxt(223)*y(33))*y(23) + (rxt(28) +rxt(224)*y(2)) &
                 *y(33) +2.000_r8*rxt(23)*y(29) +2.000_r8*rxt(26)*y(32) +rxt(27)*y(34) &
                  +rxt(29)*y(35) +rxt(31)*y(36) +rxt(56)*y(139)
         loss(44) = ( + rxt(23) + het_rates(29))* y(29)
         prod(44) = (rxt(435)*y(35) +rxt(436)*y(34) +rxt(440)*y(35) +rxt(441)*y(34) + &
                 rxt(446)*y(35) +rxt(447)*y(34))*y(33) +rxt(230)*y(35)*y(28) &
                  +rxt(219)*y(30)*y(30)
         loss(132) = (rxt(211)* y(2) +rxt(216)* y(9) +rxt(217)* y(10) +rxt(215)* y(16) &
                  + (rxt(212) +rxt(213))* y(23) +rxt(214)* y(24) + 2._r8*(rxt(218) + &
                 rxt(219) +rxt(220) +rxt(221))* y(30) + (rxt(239) +rxt(240) +rxt(241)) &
                 * y(38) + rxt(24) + het_rates(30))* y(30)
         prod(132) = (rxt(204)*y(1) +rxt(208)*y(24) +rxt(226)*y(34))*y(28) &
                  + (rxt(225)*y(34) +rxt(228)*y(35))*y(2) +rxt(227)*y(34)*y(23) &
                  +rxt(25)*y(31) +2.000_r8*rxt(222)*y(32) +rxt(30)*y(35)
         loss(37) = ( + rxt(25) + het_rates(31))* y(31)
         prod(37) = (rxt(220)*y(30) +rxt(239)*y(38))*y(30)
         loss(28) = ( + rxt(26) + rxt(222) + het_rates(32))* y(32)
         prod(28) =rxt(221)*y(30)*y(30)
         loss(137) = (rxt(224)* y(2) +rxt(157)* y(3) +rxt(223)* y(23) + (rxt(436) + &
                 rxt(441) +rxt(447))* y(34) + (rxt(435) +rxt(440) +rxt(446))* y(35) &
                  + (rxt(437) +rxt(448))* y(40) + rxt(28) + het_rates(33))* y(33)
         prod(137) = (rxt(210)*y(15) +2.000_r8*rxt(251)*y(108) +rxt(256)*y(109) + &
                 rxt(261)*y(125) +rxt(262)*y(124) +rxt(205)*y(21) +rxt(206)*y(25) + &
                 rxt(207)*y(24) +rxt(209)*y(19) +rxt(226)*y(34) +rxt(282)*y(45))*y(28) &
                  +rxt(213)*y(30)*y(23)
         loss(107) = (rxt(225)* y(2) +rxt(227)* y(23) +rxt(226)* y(28) + (rxt(436) + &
                 rxt(441) +rxt(447))* y(33) + rxt(27) + het_rates(34))* y(34)
         prod(107) = (rxt(433) +rxt(439) +rxt(444) +rxt(229)*y(23))*y(35) &
                  +rxt(214)*y(30)*y(24)
         loss(113) = (rxt(228)* y(2) +rxt(229)* y(23) +rxt(230)* y(28) + (rxt(435) + &
                 rxt(440) +rxt(446))* y(33) + rxt(29) + rxt(30) + rxt(433) + rxt(439) &
                  + rxt(444) + het_rates(35))* y(35)
         prod(113) =rxt(217)*y(30)*y(10)
         loss(50) = ( + rxt(31) + het_rates(36))* y(36)
         prod(50) = (rxt(437)*y(40) +rxt(448)*y(40))*y(33) +rxt(241)*y(38)*y(30)
         loss(133) = (rxt(231)* y(1) +rxt(233)* y(19) +rxt(232)* y(24) &
                  + het_rates(37))* y(37)
         prod(133) = (rxt(144)*y(109) +rxt(145)*y(117) +rxt(146)*y(116) + &
                 2.000_r8*rxt(147)*y(122) +2.000_r8*rxt(148)*y(123) + &
                 3.000_r8*rxt(149)*y(124) +2.000_r8*rxt(150)*y(125) +rxt(158)*y(39)) &
                 *y(3) + (rxt(32) +rxt(234)*y(2) +rxt(235)*y(23) +rxt(237)*y(9) + &
                 rxt(239)*y(30) +rxt(240)*y(30) +2.000_r8*rxt(242)*y(38))*y(38) &
                  + (rxt(255)*y(109) +2.000_r8*rxt(259)*y(125) + &
                 3.000_r8*rxt(260)*y(124) +rxt(243)*y(39))*y(23) + (rxt(256)*y(109) + &
                 2.000_r8*rxt(261)*y(125) +3.000_r8*rxt(262)*y(124))*y(28) &
                  + (rxt(34) +rxt(244)*y(2))*y(39) +rxt(31)*y(36) +rxt(33)*y(40) &
                  +rxt(35)*y(41)
         loss(128) = (rxt(234)* y(2) +rxt(237)* y(9) +rxt(238)* y(10) +rxt(235)* y(23) &
                  +rxt(236)* y(24) + (rxt(239) +rxt(240) +rxt(241))* y(30) &
                  + 2._r8*rxt(242)* y(38) + rxt(32) + het_rates(38))* y(38)
         prod(128) = (rxt(245)*y(40) +rxt(246)*y(41))*y(2) +rxt(231)*y(37)*y(1) &
                  +rxt(36)*y(41)
         loss(104) = (rxt(244)* y(2) +rxt(158)* y(3) +rxt(243)* y(23) + rxt(34) &
                  + het_rates(39))* y(39)
         prod(104) = (rxt(232)*y(24) +rxt(233)*y(19))*y(37)
         loss(96) = (rxt(245)* y(2) + (rxt(437) +rxt(448))* y(33) + rxt(33) &
                  + het_rates(40))* y(40)
         prod(96) = (rxt(434) +rxt(442) +rxt(445))*y(41) +rxt(236)*y(38)*y(24)
         loss(80) = (rxt(246)* y(2) + rxt(35) + rxt(36) + rxt(434) + rxt(442) &
                  + rxt(445) + het_rates(41))* y(41)
         prod(80) =rxt(238)*y(38)*y(10)
         loss(92) = ((rxt(451) +rxt(452))* y(2) +rxt(459)* y(4) +rxt(463)* y(132) &
                  + het_rates(127))* y(127)
         prod(92) = 0._r8
         loss(98) = (rxt(454)* y(8) +rxt(455)* y(9) +rxt(462)* y(132) + rxt(460) &
                  + het_rates(128))* y(128)
         prod(98) = (rxt(93) +rxt(105) +rxt(449)*y(130) +rxt(456)*y(129) + &
                 rxt(459)*y(127))*y(4) +rxt(453)*y(130)*y(126)
         loss(72) = (rxt(458)* y(2) + (rxt(456) +rxt(457))* y(4) + het_rates(129)) &
                 * y(129)
         prod(72) =rxt(92)*y(8)
         loss(88) = (rxt(449)* y(4) +rxt(453)* y(126) + rxt(450) + het_rates(130)) &
                 * y(130)
         prod(88) = (rxt(89) +rxt(90) +rxt(91) +rxt(102) +rxt(103) +rxt(104) + &
                 rxt(452)*y(127) +rxt(458)*y(129))*y(2) + (rxt(95) +rxt(96) +rxt(97) + &
                 rxt(107) +rxt(108) +rxt(109))*y(4)
         loss(99) = (rxt(461)* y(132) + het_rates(131))* y(131)
         prod(99) = (rxt(460) +rxt(454)*y(8) +rxt(455)*y(9))*y(128) +rxt(451)*y(127) &
                 *y(2) +rxt(457)*y(129)*y(4) +rxt(7)*y(9) +rxt(450)*y(130)
         loss(76) = (rxt(180)* y(2) +rxt(179)* y(4) + het_rates(133))* y(133)
         prod(76) = (rxt(451)*y(2) +.900_r8*rxt(463)*y(132))*y(127) &
                  +.800_r8*rxt(461)*y(132)*y(131)
         loss(100) = (rxt(463)* y(127) +rxt(462)* y(128) +rxt(461)* y(131) &
                  + het_rates(132))* y(132)
         prod(100) = (rxt(93) +rxt(95) +rxt(96) +rxt(97) +rxt(105) +rxt(107) + &
                 rxt(108) +rxt(109))*y(4) + (rxt(89) +rxt(90) +rxt(91) +rxt(102) + &
                 rxt(103) +rxt(104))*y(2) +rxt(92)*y(8) +rxt(7)*y(9)
         loss(114) = (rxt(311)* y(1) +rxt(312)* y(11) +rxt(310)* y(23) &
                  + het_rates(59))* y(59)
         prod(114) =.070_r8*rxt(357)*y(83)*y(1) +.700_r8*rxt(68)*y(77)
         loss(109) = (rxt(357)* y(1) +rxt(358)* y(11) +rxt(356)* y(23) &
                  + het_rates(83))* y(83)
         prod(109) = 0._r8
         loss(103) = (rxt(318)* y(9) +rxt(319)* y(24) + het_rates(64))* y(64)
         prod(103) = (rxt(310)*y(59) +.500_r8*rxt(320)*y(65))*y(23)
         loss(116) = (rxt(298)* y(11) +rxt(297)* y(23) + rxt(61) + het_rates(50)) &
                 * y(50)
         prod(116) = (rxt(292)*y(46) +.270_r8*rxt(313)*y(61) +rxt(318)*y(64) + &
                 rxt(331)*y(73) +rxt(335)*y(74) +.400_r8*rxt(372)*y(84))*y(9) &
                  + (.500_r8*rxt(311)*y(59) +.040_r8*rxt(333)*y(77))*y(1) &
                  + (.500_r8*rxt(296)*y(47) +rxt(307)*y(51))*y(23) &
                  + (.800_r8*rxt(294)*y(16) +1.600_r8*rxt(295)*y(46))*y(46) +rxt(69) &
                 *y(47) +rxt(62)*y(65) +rxt(84)*y(75) +.400_r8*rxt(83)*y(85)
         loss(87) = (rxt(291)* y(23) + het_rates(49))* y(49)
         prod(87) = (.250_r8*rxt(311)*y(59) +.200_r8*rxt(357)*y(83))*y(1) &
                  + (.250_r8*rxt(301)*y(48) +.250_r8*rxt(349)*y(76))*y(24) &
                  +.100_r8*rxt(302)*y(48)*y(16)
         loss(82) = (rxt(320)* y(23) + rxt(62) + het_rates(65))* y(65)
         prod(82) =rxt(319)*y(64)*y(24)
         loss(127) = (rxt(299)* y(9) +rxt(300)* y(10) +rxt(302)* y(16) +rxt(301) &
                 * y(24) + 2._r8*rxt(303)* y(48) +rxt(345)* y(79) +rxt(364)* y(88) &
                  +rxt(379)* y(91) + het_rates(48))* y(48)
         prod(127) = (rxt(322)*y(67) +rxt(335)*y(74) +.530_r8*rxt(340)*y(79) + &
                 rxt(347)*y(76))*y(9) + (rxt(298)*y(50) +rxt(328)*y(68) + &
                 .530_r8*rxt(342)*y(79) +rxt(348)*y(76))*y(11) &
                  + (.300_r8*rxt(324)*y(67) +.260_r8*rxt(344)*y(79) +rxt(350)*y(76)) &
                 *y(16) + (rxt(297)*y(50) +.500_r8*rxt(304)*y(54) +rxt(327)*y(68)) &
                 *y(23) + (.600_r8*rxt(64) +rxt(308))*y(58) +.530_r8*rxt(345)*y(79) &
                 *y(48) +rxt(73)*y(63) +rxt(78)*y(66) +rxt(74)*y(68) +rxt(72)*y(69) &
                  +rxt(80)*y(72) +rxt(84)*y(75) +2.000_r8*rxt(352)*y(76)*y(76) &
                  +.300_r8*rxt(68)*y(77) +1.340_r8*rxt(66)*y(78) +.130_r8*rxt(81) &
                 *y(86)
         loss(75) = (rxt(304)* y(23) + rxt(63) + het_rates(54))* y(54)
         prod(75) = (.750_r8*rxt(301)*y(48) +.750_r8*rxt(349)*y(76))*y(24)
         loss(74) = (rxt(309)* y(23) + rxt(64) + rxt(308) + het_rates(58))* y(58)
         prod(74) =rxt(300)*y(48)*y(10)
         loss(61) = (rxt(329)* y(23) + het_rates(82))* y(82)
         prod(61) =.100_r8*rxt(372)*y(84)*y(9) +rxt(312)*y(59)*y(11)
         loss(53) = (rxt(284)* y(23) +rxt(282)* y(28) + het_rates(45))* y(45)
         prod(53) = 0._r8
         loss(77) = (rxt(290)* y(1) +rxt(285)* y(23) +rxt(281)* y(28) + het_rates(44)) &
                 * y(44)
         prod(77) = 0._r8
         loss(29) = (rxt(368)* y(23) + het_rates(71))* y(71)
         prod(29) = 0._r8
         loss(81) = (rxt(355)* y(23) + rxt(65) + rxt(354) + het_rates(81))* y(81)
         prod(81) =rxt(353)*y(76)*y(10)
         loss(30) = (rxt(330)* y(23) + het_rates(70))* y(70)
         prod(30) = 0._r8
         loss(56) = (rxt(331)* y(9) + het_rates(73))* y(73)
         prod(56) =rxt(330)*y(70)*y(23)
         loss(93) = (rxt(372)* y(9) +rxt(373)* y(24) + het_rates(84))* y(84)
         prod(93) = (rxt(368)*y(71) +rxt(374)*y(85))*y(23)
         loss(90) = (rxt(374)* y(23) + rxt(83) + het_rates(85))* y(85)
         prod(90) =rxt(373)*y(84)*y(24)
         loss(68) = (rxt(334)* y(23) + rxt(80) + het_rates(72))* y(72)
         prod(68) =.800_r8*rxt(372)*y(84)*y(9) +.800_r8*rxt(83)*y(85)
         loss(91) = (rxt(335)* y(9) +rxt(336)* y(24) + het_rates(74))* y(74)
         prod(91) = (rxt(334)*y(72) +rxt(337)*y(75))*y(23)
         loss(57) = (rxt(337)* y(23) + rxt(84) + het_rates(75))* y(75)
         prod(57) =rxt(336)*y(74)*y(24)
         loss(38) = (rxt(382)* y(23) + het_rates(94))* y(94)
         prod(38) = 0._r8
         loss(39) = (rxt(386)* y(23) + het_rates(95))* y(95)
         prod(39) =.250_r8*rxt(382)*y(94)*y(23)
         loss(84) = (rxt(383)* y(9) +rxt(384)* y(24) + het_rates(96))* y(96)
         prod(84) = (.700_r8*rxt(382)*y(94) +rxt(385)*y(97))*y(23)
         loss(62) = (rxt(385)* y(23) + rxt(85) + het_rates(97))* y(97)
         prod(62) =rxt(384)*y(96)*y(24)
         loss(45) = (rxt(387)* y(10) + het_rates(98))* y(98)
         prod(45) =rxt(386)*y(95)*y(23)
         loss(112) = (rxt(397)* y(9) +rxt(398)* y(24) + het_rates(106))* y(106)
         prod(112) = (rxt(394)*y(105) +rxt(399)*y(107))*y(23) +rxt(396)*y(105)*y(11)
         loss(70) = (rxt(399)* y(23) + rxt(86) + het_rates(107))* y(107)
         prod(70) =rxt(398)*y(106)*y(24)
         loss(85) = ( + rxt(81) + het_rates(86))* y(86)
         prod(85) = (.900_r8*rxt(383)*y(96) +.900_r8*rxt(390)*y(100) + &
                 .620_r8*rxt(393)*y(103))*y(9) +.700_r8*rxt(387)*y(98)*y(10) &
                  +.900_r8*rxt(85)*y(97)
         loss(95) = (rxt(306)* y(23) + rxt(82) + het_rates(53))* y(53)
         prod(95) = (.020_r8*rxt(359)*y(88) +.250_r8*rxt(375)*y(91) + &
                 .450_r8*rxt(383)*y(96) +.900_r8*rxt(390)*y(100) + &
                 .340_r8*rxt(393)*y(103))*y(9) + (.250_r8*rxt(376)*y(11) + &
                 .100_r8*rxt(378)*y(16) +.250_r8*rxt(379)*y(48))*y(91) &
                  + (.650_r8*rxt(283)*y(135) +.200_r8*rxt(305)*y(52))*y(23) &
                  +.130_r8*rxt(81)*y(86) +.450_r8*rxt(85)*y(97)
         loss(31) = (rxt(388)* y(23) + het_rates(99))* y(99)
         prod(31) = 0._r8
         loss(63) = (rxt(390)* y(9) +rxt(389)* y(24) + het_rates(100))* y(100)
         prod(63) =rxt(388)*y(99)*y(23)
         loss(1) = ( + het_rates(101))* y(101)
         prod(1) =rxt(389)*y(100)*y(24)
         loss(32) = (rxt(391)* y(23) + het_rates(102))* y(102)
         prod(32) = 0._r8
         loss(71) = (rxt(393)* y(9) +rxt(392)* y(24) + het_rates(103))* y(103)
         prod(71) =rxt(391)*y(102)*y(23)
         loss(2) = ( + het_rates(104))* y(104)
         prod(2) =rxt(392)*y(103)*y(24)
         loss(123) = (rxt(359)* y(9) +rxt(360)* y(11) +rxt(363)* y(16) +rxt(361) &
                 * y(24) +rxt(364)* y(48) + het_rates(88))* y(88)
         prod(123) = (rxt(356)*y(83) +.200_r8*rxt(362)*y(93))*y(23)
         loss(125) = (rxt(333)* y(1) +rxt(332)* y(23) + rxt(68) + het_rates(77)) &
                 * y(77)
         prod(125) = (.320_r8*rxt(359)*y(9) +.350_r8*rxt(360)*y(11) + &
                 .260_r8*rxt(363)*y(16) +.350_r8*rxt(364)*y(48))*y(88) &
                  + (.039_r8*rxt(365)*y(9) +.039_r8*rxt(366)*y(11) + &
                 .039_r8*rxt(367)*y(24))*y(89) + (.200_r8*rxt(357)*y(83) + &
                 rxt(395)*y(105))*y(1) +rxt(397)*y(106)*y(9) +.402_r8*rxt(77)*y(93) &
                  +rxt(86)*y(107)
         loss(119) = (rxt(339)* y(1) +rxt(338)* y(23) + rxt(66) + rxt(67) &
                  + het_rates(78))* y(78)
         prod(119) = (.230_r8*rxt(359)*y(9) +.250_r8*rxt(360)*y(11) + &
                 .190_r8*rxt(363)*y(16) +.250_r8*rxt(364)*y(48))*y(88) &
                  + (.167_r8*rxt(365)*y(9) +.167_r8*rxt(366)*y(11) + &
                 .167_r8*rxt(367)*y(24))*y(89) + (.400_r8*rxt(357)*y(83) + &
                 rxt(395)*y(105))*y(1) +rxt(397)*y(106)*y(9) +.288_r8*rxt(77)*y(93) &
                  +rxt(86)*y(107)
         loss(124) = ((rxt(340) +rxt(341))* y(9) +rxt(342)* y(11) +rxt(344)* y(16) &
                  +rxt(343)* y(24) +rxt(345)* y(48) + het_rates(79))* y(79)
         prod(124) = (rxt(332)*y(77) +.500_r8*rxt(338)*y(78) +.200_r8*rxt(346)*y(80)) &
                 *y(23)
         loss(58) = (rxt(346)* y(23) + het_rates(80))* y(80)
         prod(58) =rxt(343)*y(79)*y(24)
         loss(126) = (rxt(347)* y(9) +rxt(353)* y(10) +rxt(348)* y(11) +rxt(350) &
                 * y(16) +rxt(349)* y(24) +rxt(351)* y(48) + 2._r8*rxt(352)* y(76) &
                  + het_rates(76))* y(76)
         prod(126) = (.500_r8*rxt(338)*y(78) +.500_r8*rxt(346)*y(80))*y(23) &
                  + (rxt(65) +rxt(354))*y(81) +.200_r8*rxt(357)*y(83)*y(1) &
                  +.660_r8*rxt(66)*y(78)
         loss(106) = (rxt(292)* y(9) +rxt(294)* y(16) +rxt(293)* y(24) &
                  + 2._r8*rxt(295)* y(46) + het_rates(46))* y(46)
         prod(106) = (rxt(284)*y(45) +.500_r8*rxt(296)*y(47))*y(23) +rxt(282)*y(45) &
                 *y(28) +rxt(80)*y(72)
         loss(59) = (rxt(296)* y(23) + rxt(69) + het_rates(47))* y(47)
         prod(59) =rxt(293)*y(46)*y(24)
         loss(86) = (rxt(395)* y(1) +rxt(396)* y(11) +rxt(394)* y(23) &
                  + het_rates(105))* y(105)
         prod(86) = 0._r8
         loss(35) = (rxt(317)* y(23) + het_rates(60))* y(60)
         prod(35) = 0._r8
         loss(108) = (rxt(313)* y(9) +rxt(315)* y(16) +rxt(314)* y(24) &
                  + het_rates(61))* y(61)
         prod(108) = (rxt(316)*y(62) +rxt(317)*y(60))*y(23)
         loss(64) = (rxt(316)* y(23) + rxt(71) + het_rates(62))* y(62)
         prod(64) =rxt(314)*y(61)*y(24)
         loss(94) = (rxt(321)* y(23) + rxt(73) + het_rates(63))* y(63)
         prod(94) = (.820_r8*rxt(313)*y(61) +.500_r8*rxt(331)*y(73) + &
                 .250_r8*rxt(372)*y(84) +.100_r8*rxt(397)*y(106))*y(9) &
                  +.820_r8*rxt(315)*y(61)*y(16) +.820_r8*rxt(71)*y(62) &
                  +.250_r8*rxt(83)*y(85) +.100_r8*rxt(86)*y(107)
         loss(65) = (rxt(325)* y(23) + rxt(72) + het_rates(69))* y(69)
         prod(65) =rxt(323)*y(67)*y(24)
         loss(79) = (rxt(274)* y(23) + het_rates(18))* y(18)
         prod(79) = (rxt(273)*y(16) +.300_r8*rxt(294)*y(46) +.500_r8*rxt(324)*y(67) + &
                 .250_r8*rxt(344)*y(79) +.250_r8*rxt(363)*y(88) + &
                 .300_r8*rxt(378)*y(91))*y(16)
         loss(51) = (rxt(307)* y(23) + het_rates(51))* y(51)
         prod(51) = (.200_r8*rxt(294)*y(16) +.400_r8*rxt(295)*y(46))*y(46)
         loss(110) = (rxt(305)* y(23) + rxt(79) + het_rates(52))* y(52)
         prod(110) = (.530_r8*rxt(340)*y(9) +.530_r8*rxt(342)*y(11) + &
                 .260_r8*rxt(344)*y(16) +.530_r8*rxt(345)*y(48))*y(79) &
                  + (.250_r8*rxt(375)*y(9) +.250_r8*rxt(376)*y(11) + &
                 .100_r8*rxt(378)*y(16) +.250_r8*rxt(379)*y(48))*y(91) +rxt(288)*y(56) &
                 *y(4) +.020_r8*rxt(359)*y(88)*y(9)
         loss(118) = (rxt(326)* y(23) + rxt(78) + het_rates(66))* y(66)
         prod(118) = (.220_r8*rxt(340)*y(9) +.220_r8*rxt(342)*y(11) + &
                 .230_r8*rxt(344)*y(16) +.220_r8*rxt(345)*y(48))*y(79) &
                  + (.250_r8*rxt(375)*y(9) +.250_r8*rxt(376)*y(11) + &
                 .100_r8*rxt(378)*y(16) +.250_r8*rxt(379)*y(48))*y(91) &
                  + (.500_r8*rxt(320)*y(65) +.500_r8*rxt(355)*y(81))*y(23) &
                  +.020_r8*rxt(359)*y(88)*y(9) +.200_r8*rxt(324)*y(67)*y(16)
         loss(97) = (rxt(286)* y(9) +rxt(287)* y(24) + het_rates(55))* y(55)
         prod(97) =rxt(285)*y(44)*y(23)
         loss(69) = (rxt(288)* y(4) + rxt(289) + het_rates(56))* y(56)
         prod(69) =.750_r8*rxt(286)*y(55)*y(9) +rxt(70)*y(57)
         loss(40) = ( + rxt(70) + het_rates(57))* y(57)
         prod(40) =rxt(287)*y(55)*y(24)
         loss(60) = (rxt(371)* y(23) + het_rates(87))* y(87)
         prod(60) = (.330_r8*rxt(359)*y(9) +.400_r8*rxt(360)*y(11) + &
                 .300_r8*rxt(363)*y(16) +.400_r8*rxt(364)*y(48))*y(88) &
                  + (rxt(369)*y(23) +rxt(370)*y(11))*y(90)
         loss(117) = (rxt(322)* y(9) +rxt(324)* y(16) +rxt(323)* y(24) &
                  + het_rates(67))* y(67)
         prod(117) = (rxt(321)*y(63) +rxt(325)*y(69))*y(23)
         loss(121) = (rxt(328)* y(11) +rxt(327)* y(23) + rxt(74) + het_rates(68)) &
                 * y(68)
         prod(121) = (.250_r8*rxt(340)*y(79) +.020_r8*rxt(359)*y(88) + &
                 .250_r8*rxt(375)*y(91) +.450_r8*rxt(383)*y(96) + &
                 .540_r8*rxt(393)*y(103))*y(9) + (.500_r8*rxt(324)*y(67) + &
                 .240_r8*rxt(344)*y(79) +.100_r8*rxt(378)*y(91))*y(16) &
                  + (.950_r8*rxt(333)*y(77) +.800_r8*rxt(339)*y(78))*y(1) &
                  + (.250_r8*rxt(342)*y(79) +.250_r8*rxt(376)*y(91))*y(11) &
                  + (rxt(326)*y(66) +rxt(329)*y(82))*y(23) + (.250_r8*rxt(345)*y(79) + &
                 .250_r8*rxt(379)*y(91))*y(48) +.180_r8*rxt(81)*y(86) +.450_r8*rxt(85) &
                 *y(97)
         loss(102) = (rxt(365)* y(9) +rxt(366)* y(11) +rxt(367)* y(24) &
                  + het_rates(89))* y(89)
         prod(102) =rxt(358)*y(83)*y(11)
         loss(111) = (rxt(370)* y(11) +rxt(369)* y(23) + rxt(76) + het_rates(90)) &
                 * y(90)
         prod(111) = (.800_r8*rxt(341)*y(79) +.080_r8*rxt(359)*y(88) + &
                 .794_r8*rxt(365)*y(89))*y(9) + (.794_r8*rxt(366)*y(11) + &
                 .794_r8*rxt(367)*y(24))*y(89)
         loss(122) = (rxt(375)* y(9) +rxt(376)* y(11) +rxt(378)* y(16) +rxt(377) &
                 * y(24) +rxt(379)* y(48) + het_rates(91))* y(91)
         prod(122) = (.800_r8*rxt(362)*y(93) +rxt(371)*y(87) +rxt(380)*y(92))*y(23)
         loss(52) = ((rxt(380) +rxt(381))* y(23) + rxt(75) + het_rates(92))* y(92)
         prod(52) =rxt(377)*y(91)*y(24)
         loss(83) = (rxt(362)* y(23) + rxt(77) + het_rates(93))* y(93)
         prod(83) =rxt(361)*y(88)*y(24)
         loss(54) = (rxt(283)* y(23) +rxt(280)* y(28) + het_rates(135))* y(135)
         prod(54) = 0._r8
         loss(78) = (rxt(276)* y(23) + het_rates(136))* y(136)
         prod(78) = (rxt(278)*y(9) +rxt(279)*y(24))*y(137) +.500_r8*rxt(290)*y(44) &
                 *y(1) +.350_r8*rxt(283)*y(135)*y(23)
         loss(66) = (rxt(278)* y(9) +rxt(279)* y(24) + rxt(277) + het_rates(137)) &
                 * y(137)
         prod(66) =rxt(269)*y(24)*y(19)
         loss(41) = (rxt(151)* y(3) + rxt(55) + het_rates(138))* y(138)
         prod(41) = (rxt(136)*y(111) +rxt(137)*y(112) +2.000_r8*rxt(138)*y(120) + &
                 2.000_r8*rxt(139)*y(121) +rxt(140)*y(113) +rxt(142)*y(119) + &
                 rxt(145)*y(117) +rxt(146)*y(116) +rxt(147)*y(122) + &
                 2.000_r8*rxt(148)*y(123))*y(3) + (rxt(254)*y(113) +rxt(258)*y(119)) &
                 *y(23)
         loss(46) = (rxt(152)* y(3) + rxt(56) + het_rates(139))* y(139)
         prod(46) = (rxt(135)*y(110) +rxt(137)*y(112) +rxt(141)*y(118))*y(3) &
                  +rxt(257)*y(118)*y(23)
         loss(48) = ( + rxt(57) + het_rates(140))* y(140)
         prod(48) = (rxt(249)*y(15) +rxt(247)*y(134) +rxt(248)*y(21) +rxt(250)*y(12)) &
                 *y(141)
         loss(101) = (rxt(250)* y(12) +rxt(249)* y(15) +rxt(248)* y(21) +rxt(247) &
                 * y(134) + het_rates(141))* y(141)
         prod(101) = (rxt(139)*y(121) +rxt(146)*y(116) +2.000_r8*rxt(151)*y(138) + &
                 rxt(152)*y(139))*y(3) +2.000_r8*rxt(55)*y(138) +rxt(56)*y(139) &
                  +rxt(57)*y(140)
         loss(36) = (rxt(404)* y(23) + het_rates(156))* y(156)
         prod(36) = (rxt(405)*y(23) +.500_r8*rxt(406)*y(23) +rxt(407)*y(11))*y(157)
         loss(49) = (rxt(407)* y(11) + (rxt(405) +rxt(406))* y(23) + het_rates(157)) &
                 * y(157)
         prod(49) = 0._r8
         loss(3) = ( + rxt(415) + het_rates(158))* y(158)
         prod(3) =rxt(404)*y(156)*y(23)
         loss(33) = (rxt(408)* y(23) + het_rates(159))* y(159)
         prod(33) = 0._r8
         loss(4) = ( + rxt(421) + het_rates(160))* y(160)
         prod(4) = 0._r8
         loss(5) = ( + rxt(422) + het_rates(161))* y(161)
         prod(5) = 0._r8
         loss(6) = ( + rxt(416) + het_rates(146))* y(146)
         prod(6) = 0._r8
         loss(7) = ( + rxt(417) + het_rates(147))* y(147)
         prod(7) = 0._r8
         loss(8) = ( + rxt(419) + het_rates(148))* y(148)
         prod(8) = 0._r8
         loss(9) = ( + rxt(418) + het_rates(149))* y(149)
         prod(9) = 0._r8
         loss(10) = ( + rxt(420) + het_rates(150))* y(150)
         prod(10) = 0._r8
         loss(11) = ( + het_rates(151))* y(151)
         prod(11) = 0._r8
         loss(12) = ( + het_rates(152))* y(152)
         prod(12) = 0._r8
         loss(13) = ( + het_rates(153))* y(153)
         prod(13) = 0._r8
         loss(14) = ( + het_rates(154))* y(154)
         prod(14) = 0._r8
         loss(15) = ( + het_rates(155))* y(155)
         prod(15) = 0._r8
         loss(16) = ( + rxt(403) + rxt(411) + het_rates(142))* y(142)
         prod(16) = 0._r8
         loss(17) = ( + rxt(412) + het_rates(143))* y(143)
         prod(17) =rxt(403)*y(142)
         loss(18) = ( + rxt(409) + rxt(413) + het_rates(144))* y(144)
         prod(18) = 0._r8
         loss(19) = ( + rxt(414) + het_rates(145))* y(145)
         prod(19) =rxt(409)*y(144)
         loss(20) = ( + rxt(423) + het_rates(162))* y(162)
         prod(20) = 0._r8
         loss(21) = ( + rxt(424) + het_rates(163))* y(163)
         prod(21) = 0._r8
         loss(22) = ( + rxt(425) + het_rates(164))* y(164)
         prod(22) = 0._r8
         loss(23) = ( + rxt(426) + het_rates(165))* y(165)
         prod(23) = 0._r8
         loss(24) = ( + rxt(427) + het_rates(166))* y(166)
         prod(24) = 0._r8
         loss(25) = ( + rxt(428) + het_rates(167))* y(167)
         prod(25) = 0._r8
         loss(26) = ( + rxt(429) + het_rates(168))* y(168)
         prod(26) = 0._r8
         loss(27) = ( + rxt(430) + het_rates(169))* y(169)
         prod(27) = 0._r8

      end subroutine imp_prod_loss

      end module mo_prod_loss
