




      module mo_nln_matrix

      use shr_kind_mod, only : r8 => shr_kind_r8

      private
      public :: nlnmat

      contains

      subroutine nlnmat01( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(1046) = -(rxt(119)*y(2) + rxt(137)*y(161) + rxt(164)*y(19) + rxt(169) &
                      *y(133) + rxt(177)*y(134) + rxt(192)*y(6) + rxt(195)*y(7) &
                      + rxt(207)*y(131) + rxt(234)*y(132) + rxt(293)*y(37) + rxt(314) &
                      *y(48) + rxt(336)*y(60) + rxt(342)*y(61) + rxt(360)*y(65) &
                      + rxt(392)*y(77) + rxt(405)*y(107) + rxt(408)*y(108))
         mat(951) = -rxt(119)*y(1)
         mat(1503) = -rxt(137)*y(1)
         mat(1349) = -rxt(164)*y(1)
         mat(1236) = -rxt(169)*y(1)
         mat(1418) = -rxt(177)*y(1)
         mat(1101) = -rxt(192)*y(1)
         mat(1138) = -rxt(195)*y(1)
         mat(1453) = -rxt(207)*y(1)
         mat(849) = -rxt(234)*y(1)
         mat(298) = -rxt(293)*y(1)
         mat(601) = -rxt(314)*y(1)
         mat(752) = -rxt(336)*y(1)
         mat(649) = -rxt(342)*y(1)
         mat(502) = -rxt(360)*y(1)
         mat(305) = -rxt(392)*y(1)
         mat(388) = -rxt(405)*y(1)
         mat(815) = -rxt(408)*y(1)

         mat(1046) = mat(1046) + .100_r8*rxt(360)*y(65) + .200_r8*rxt(336)*y(60) &
                      + .200_r8*rxt(342)*y(61)
         mat(951) = mat(951) + rxt(118)*y(3)
         mat(912) = rxt(118)*y(2)
         mat(1418) = mat(1418) + .250_r8*rxt(304)*y(137) + .250_r8*rxt(352)*y(145)
         mat(502) = mat(502) + .100_r8*rxt(360)*y(1)
         mat(799) = .250_r8*rxt(304)*y(134)
         mat(752) = mat(752) + .200_r8*rxt(336)*y(1)
         mat(649) = mat(649) + .200_r8*rxt(342)*y(1)
         mat(771) = .250_r8*rxt(352)*y(134)

         mat(948) = -(rxt(118)*y(3) + rxt(119)*y(1) + 4._r8*rxt(120)*y(2) + rxt(168) &
                      *y(133) + rxt(175)*y(18) + rxt(176)*y(134) + rxt(179)*y(20) &
                      + rxt(190)*y(6) + (rxt(193) + rxt(194)) * y(7) + rxt(201)*y(8) &
                      + rxt(214)*y(24) + rxt(227)*y(27) + rxt(228)*y(28) + rxt(231) &
                      *y(29) + rxt(237)*y(31) + rxt(247)*y(32) + rxt(248)*y(33) &
                      + rxt(249)*y(34) + rxt(271)*y(16) + rxt(401)*y(106) + (rxt(437) &
                      + rxt(438)) * y(152) + rxt(444)*y(154))
         mat(909) = -rxt(118)*y(2)
         mat(1043) = -rxt(119)*y(2)
         mat(1233) = -rxt(168)*y(2)
         mat(658) = -rxt(175)*y(2)
         mat(1415) = -rxt(176)*y(2)
         mat(323) = -rxt(179)*y(2)
         mat(1098) = -rxt(190)*y(2)
         mat(1135) = -(rxt(193) + rxt(194)) * y(2)
         mat(1277) = -rxt(201)*y(2)
         mat(1326) = -rxt(214)*y(2)
         mat(831) = -rxt(227)*y(2)
         mat(509) = -rxt(228)*y(2)
         mat(567) = -rxt(231)*y(2)
         mat(1474) = -rxt(237)*y(2)
         mat(459) = -rxt(247)*y(2)
         mat(432) = -rxt(248)*y(2)
         mat(259) = -rxt(249)*y(2)
         mat(972) = -rxt(271)*y(2)
         mat(151) = -rxt(401)*y(2)
         mat(337) = -(rxt(437) + rxt(438)) * y(2)
         mat(218) = -rxt(444)*y(2)

         mat(1500) = (rxt(132)+rxt(133))*y(3)
         mat(909) = mat(909) + (rxt(132)+rxt(133))*y(161) + rxt(185)*y(5) + rxt(443) &
                      *y(154) + rxt(435)*y(155) + rxt(404)*y(107) + rxt(407)*y(108)
         mat(472) = rxt(185)*y(3) + rxt(186)*y(6) + rxt(187)*y(7) + rxt(440)*y(153)
         mat(1098) = mat(1098) + rxt(186)*y(5)
         mat(1135) = mat(1135) + rxt(187)*y(5)
         mat(1233) = mat(1233) + 2.000_r8*rxt(171)*y(133)
         mat(1346) = rxt(167)*y(134)
         mat(1415) = mat(1415) + rxt(167)*y(19)
         mat(406) = rxt(440)*y(5) + 1.150_r8*rxt(448)*y(157)
         mat(218) = mat(218) + rxt(443)*y(3)
         mat(320) = rxt(435)*y(3)
         mat(414) = rxt(447)*y(157)
         mat(425) = 1.150_r8*rxt(448)*y(153) + rxt(447)*y(156)
         mat(387) = rxt(404)*y(3)
         mat(813) = rxt(407)*y(3)

         mat(1514) = -((rxt(132) + rxt(133)) * y(3) + rxt(134)*y(162) + rxt(137)*y(1) &
                      + rxt(154)*y(100) + rxt(155)*y(101) + rxt(159)*y(18) + rxt(160) &
                      *y(27) + rxt(161)*y(32) + rxt(162)*y(35))
         mat(921) = -(rxt(132) + rxt(133)) * y(161)
         mat(1012) = -rxt(134)*y(161)
         mat(1057) = -rxt(137)*y(161)
         mat(50) = -rxt(154)*y(161)
         mat(68) = -rxt(155)*y(161)
         mat(665) = -rxt(159)*y(161)
         mat(841) = -rxt(160)*y(161)
         mat(463) = -rxt(161)*y(161)
         mat(72) = -rxt(162)*y(161)

         mat(921) = mat(921) + rxt(182)*y(158)
         mat(408) = .850_r8*rxt(448)*y(157)
         mat(236) = rxt(182)*y(3)
         mat(427) = .850_r8*rxt(448)*y(153)

         mat(908) = -(rxt(118)*y(2) + rxt(128)*y(160) + rxt(132)*y(161) + rxt(163) &
                      *y(19) + rxt(182)*y(158) + rxt(185)*y(5) + rxt(291)*y(139) &
                      + rxt(404)*y(107) + rxt(407)*y(108) + rxt(435)*y(155) + (rxt(442) &
                      + rxt(443)) * y(154) + rxt(445)*y(152))
         mat(947) = -rxt(118)*y(3)
         mat(55) = -rxt(128)*y(3)
         mat(1499) = -rxt(132)*y(3)
         mat(1345) = -rxt(163)*y(3)
         mat(234) = -rxt(182)*y(3)
         mat(471) = -rxt(185)*y(3)
         mat(195) = -rxt(291)*y(3)
         mat(386) = -rxt(404)*y(3)
         mat(812) = -rxt(407)*y(3)
         mat(319) = -rxt(435)*y(3)
         mat(217) = -(rxt(442) + rxt(443)) * y(3)
         mat(336) = -rxt(445)*y(3)

         mat(1042) = 2.000_r8*rxt(119)*y(2) + 2.000_r8*rxt(137)*y(161) + rxt(192)*y(6) &
                      + rxt(195)*y(7) + rxt(169)*y(133) + rxt(164)*y(19) &
                      + 2.000_r8*rxt(177)*y(134) + rxt(207)*y(131) + rxt(234)*y(132) &
                      + rxt(405)*y(107) + rxt(408)*y(108)
         mat(947) = mat(947) + 2.000_r8*rxt(119)*y(1) + 2.000_r8*rxt(120)*y(2) &
                      + rxt(127)*y(160) + rxt(193)*y(7) + rxt(168)*y(133) + rxt(201) &
                      *y(8) + rxt(176)*y(134) + rxt(214)*y(24) + rxt(237)*y(31)
         mat(1499) = mat(1499) + 2.000_r8*rxt(137)*y(1)
         mat(908) = mat(908) + 2.000_r8*rxt(128)*y(160)
         mat(55) = mat(55) + rxt(127)*y(2) + 2.000_r8*rxt(128)*y(3)
         mat(471) = mat(471) + rxt(189)*y(7)
         mat(1097) = rxt(192)*y(1) + rxt(441)*y(153)
         mat(1134) = rxt(195)*y(1) + rxt(193)*y(2) + rxt(189)*y(5)
         mat(1232) = rxt(169)*y(1) + rxt(168)*y(2) + rxt(205)*y(10) + rxt(170)*y(134) &
                      + rxt(216)*y(24)
         mat(1276) = rxt(201)*y(2) + rxt(203)*y(134)
         mat(220) = rxt(205)*y(133)
         mat(878) = rxt(274)*y(134)
         mat(1345) = mat(1345) + rxt(164)*y(1) + rxt(166)*y(134)
         mat(1414) = 2.000_r8*rxt(177)*y(1) + rxt(176)*y(2) + rxt(170)*y(133) &
                      + rxt(203)*y(8) + rxt(274)*y(13) + rxt(166)*y(19) &
                      + 2.000_r8*rxt(178)*y(134) + rxt(210)*y(131) + rxt(217)*y(24) &
                      + rxt(235)*y(132) + rxt(239)*y(31) + rxt(322)*y(141) &
                      + .750_r8*rxt(352)*y(145) + rxt(296)*y(136) + rxt(317)*y(140) &
                      + rxt(326)*y(142)
         mat(1449) = rxt(207)*y(1) + rxt(210)*y(134)
         mat(1325) = rxt(214)*y(2) + rxt(216)*y(133) + rxt(217)*y(134) + ( &
                      + 2.000_r8*rxt(221)+2.000_r8*rxt(222))*y(24) + (rxt(243) &
                       +rxt(244))*y(31)
         mat(845) = rxt(234)*y(1) + rxt(235)*y(134)
         mat(1473) = rxt(237)*y(2) + rxt(239)*y(134) + (rxt(243)+rxt(244))*y(24) &
                      + 2.000_r8*rxt(245)*y(31)
         mat(405) = rxt(441)*y(6)
         mat(450) = rxt(322)*y(134)
         mat(768) = .750_r8*rxt(352)*y(134)
         mat(484) = rxt(296)*y(134)
         mat(527) = rxt(317)*y(134)
         mat(634) = rxt(326)*y(134)
         mat(386) = mat(386) + rxt(405)*y(1)
         mat(812) = mat(812) + rxt(408)*y(1)

         mat(57) = -(rxt(121)*y(2) + rxt(122)*y(3) + rxt(124)*y(1))
         mat(923) = -rxt(121)*y(159)
         mat(892) = -rxt(122)*y(159)
         mat(1014) = -rxt(124)*y(159)

         mat(1490) = rxt(132)*y(3)
         mat(892) = mat(892) + rxt(132)*y(161)

         mat(54) = -(rxt(127)*y(2) + rxt(128)*y(3))
         mat(922) = -rxt(127)*y(160)
         mat(891) = -rxt(128)*y(160)

         mat(1013) = rxt(124)*y(159)
         mat(922) = mat(922) + rxt(121)*y(159)
         mat(891) = mat(891) + rxt(122)*y(159)
         mat(56) = rxt(124)*y(1) + rxt(121)*y(2) + rxt(122)*y(3)

         mat(655) = -(rxt(159)*y(161) + rxt(173)*y(133) + rxt(175)*y(2) + rxt(208) &
                      *y(131) + rxt(251)*y(103))
         mat(1495) = -rxt(159)*y(18)
         mat(1220) = -rxt(173)*y(18)
         mat(942) = -rxt(175)*y(18)
         mat(1444) = -rxt(208)*y(18)
         mat(439) = -rxt(251)*y(18)

         mat(1341) = rxt(166)*y(134)
         mat(1403) = rxt(166)*y(19)

         mat(607) = -((rxt(267) + rxt(268)) * y(133))
         mat(1215) = -(rxt(267) + rxt(268)) * y(17)

         mat(1027) = .560_r8*rxt(314)*y(48) + .300_r8*rxt(360)*y(65) &
                      + .500_r8*rxt(293)*y(37) + .050_r8*rxt(336)*y(60) &
                      + .200_r8*rxt(342)*y(61)
         mat(941) = rxt(271)*y(16) + rxt(401)*y(106)
         mat(1083) = .220_r8*rxt(343)*y(146) + .500_r8*rxt(378)*y(149)
         mat(1215) = mat(1215) + rxt(270)*y(16) + rxt(309)*y(44) + rxt(330)*y(54) &
                      + .350_r8*rxt(286)*y(98) + rxt(402)*y(106)
         mat(1261) = rxt(269)*y(16) + .220_r8*rxt(345)*y(146) + rxt(331)*y(54) &
                      + .500_r8*rxt(379)*y(149)
         mat(865) = .110_r8*rxt(347)*y(146) + .200_r8*rxt(381)*y(149)
         mat(966) = rxt(271)*y(2) + rxt(270)*y(133) + rxt(269)*y(8) + rxt(212)*y(131) &
                      + rxt(236)*y(132)
         mat(1442) = rxt(212)*y(16)
         mat(843) = rxt(236)*y(16)
         mat(593) = .560_r8*rxt(314)*y(1)
         mat(494) = .300_r8*rxt(360)*y(1)
         mat(785) = .220_r8*rxt(348)*y(146) + .500_r8*rxt(382)*y(149)
         mat(295) = .500_r8*rxt(293)*y(1)
         mat(360) = rxt(309)*y(133)
         mat(740) = .050_r8*rxt(336)*y(1)
         mat(641) = .200_r8*rxt(342)*y(1)
         mat(722) = .220_r8*rxt(343)*y(6) + .220_r8*rxt(345)*y(8) + .110_r8*rxt(347) &
                      *y(13) + .220_r8*rxt(348)*y(137)
         mat(666) = rxt(330)*y(133) + rxt(331)*y(8)
         mat(679) = .500_r8*rxt(378)*y(6) + .500_r8*rxt(379)*y(8) + .200_r8*rxt(381) &
                      *y(13) + .500_r8*rxt(382)*y(137)
         mat(97) = .350_r8*rxt(286)*y(133)
         mat(149) = rxt(401)*y(2) + rxt(402)*y(133)

         mat(469) = -(rxt(184)*y(133) + rxt(185)*y(3) + rxt(186)*y(6) + (rxt(187) &
                      + rxt(188) + rxt(189)) * y(7) + rxt(440)*y(153))
         mat(1203) = -rxt(184)*y(5)
         mat(902) = -rxt(185)*y(5)
         mat(1076) = -rxt(186)*y(5)
         mat(1122) = -(rxt(187) + rxt(188) + rxt(189)) * y(5)
         mat(404) = -rxt(440)*y(5)

         mat(937) = rxt(444)*y(154) + rxt(183)*y(158)
         mat(902) = mat(902) + rxt(442)*y(154)
         mat(334) = 1.100_r8*rxt(449)*y(157)
         mat(216) = rxt(444)*y(2) + rxt(442)*y(3)
         mat(412) = .200_r8*rxt(447)*y(157)
         mat(233) = rxt(183)*y(2)
         mat(422) = 1.100_r8*rxt(449)*y(152) + .200_r8*rxt(447)*y(156)


      end subroutine nlnmat01

      subroutine nlnmat02( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(1102) = -(rxt(186)*y(5) + rxt(190)*y(2) + rxt(191)*y(134) + rxt(192)*y(1) &
                      + rxt(200)*y(8) + rxt(219)*y(24) + rxt(240)*y(31) + rxt(273) &
                      *y(13) + rxt(281)*y(135) + rxt(289)*y(138) + rxt(295)*y(136) &
                      + rxt(302)*y(137) + rxt(316)*y(140) + rxt(321)*y(141) + rxt(325) &
                      *y(142) + rxt(334)*y(143) + rxt(338)*y(144) + (rxt(343) + rxt(344) &
                      ) * y(146) + rxt(350)*y(145) + rxt(362)*y(148) + rxt(368)*y(69) &
                      + rxt(375)*y(147) + rxt(378)*y(149) + rxt(386)*y(150) + rxt(394) &
                      *y(151) + rxt(441)*y(153))
         mat(473) = -rxt(186)*y(6)
         mat(952) = -rxt(190)*y(6)
         mat(1419) = -rxt(191)*y(6)
         mat(1047) = -rxt(192)*y(6)
         mat(1281) = -rxt(200)*y(6)
         mat(1330) = -rxt(219)*y(6)
         mat(1478) = -rxt(240)*y(6)
         mat(882) = -rxt(273)*y(6)
         mat(179) = -rxt(281)*y(6)
         mat(397) = -rxt(289)*y(6)
         mat(486) = -rxt(295)*y(6)
         mat(800) = -rxt(302)*y(6)
         mat(530) = -rxt(316)*y(6)
         mat(453) = -rxt(321)*y(6)
         mat(637) = -rxt(325)*y(6)
         mat(116) = -rxt(334)*y(6)
         mat(355) = -rxt(338)*y(6)
         mat(732) = -(rxt(343) + rxt(344)) * y(6)
         mat(772) = -rxt(350)*y(6)
         mat(711) = -rxt(362)*y(6)
         mat(584) = -rxt(368)*y(6)
         mat(374) = -rxt(375)*y(6)
         mat(687) = -rxt(378)*y(6)
         mat(242) = -rxt(386)*y(6)
         mat(552) = -rxt(394)*y(6)
         mat(407) = -rxt(441)*y(6)

         mat(952) = mat(952) + rxt(193)*y(7)
         mat(913) = rxt(185)*y(5) + rxt(182)*y(158)
         mat(473) = mat(473) + rxt(185)*y(3) + 2.000_r8*rxt(188)*y(7) + rxt(184) &
                      *y(133)
         mat(1139) = rxt(193)*y(2) + 2.000_r8*rxt(188)*y(5) + rxt(409)*y(108)
         mat(1237) = rxt(184)*y(5)
         mat(235) = rxt(182)*y(3)
         mat(816) = rxt(409)*y(7)

         mat(1140) = -((rxt(187) + rxt(188) + rxt(189)) * y(5) + (rxt(193) + rxt(194) &
                      ) * y(2) + rxt(195)*y(1) + rxt(196)*y(8) + rxt(198)*y(133) &
                      + rxt(204)*y(134) + rxt(220)*y(24) + rxt(241)*y(31) + rxt(303) &
                      *y(137) + rxt(356)*y(145) + rxt(390)*y(76) + rxt(409)*y(108))
         mat(474) = -(rxt(187) + rxt(188) + rxt(189)) * y(7)
         mat(953) = -(rxt(193) + rxt(194)) * y(7)
         mat(1048) = -rxt(195)*y(7)
         mat(1282) = -rxt(196)*y(7)
         mat(1238) = -rxt(198)*y(7)
         mat(1420) = -rxt(204)*y(7)
         mat(1331) = -rxt(220)*y(7)
         mat(1479) = -rxt(241)*y(7)
         mat(801) = -rxt(303)*y(7)
         mat(773) = -rxt(356)*y(7)
         mat(63) = -rxt(390)*y(7)
         mat(817) = -rxt(409)*y(7)

         mat(1048) = mat(1048) + rxt(192)*y(6)
         mat(953) = mat(953) + rxt(190)*y(6) + rxt(201)*y(8)
         mat(1103) = rxt(192)*y(1) + rxt(190)*y(2) + 2.000_r8*rxt(200)*y(8) + rxt(273) &
                      *y(13) + rxt(191)*y(134) + rxt(219)*y(24) + rxt(240)*y(31) &
                      + rxt(321)*y(141) + rxt(302)*y(137) + rxt(334)*y(143) &
                      + .900_r8*rxt(375)*y(147) + rxt(338)*y(144) + .900_r8*rxt(386) &
                      *y(150) + rxt(394)*y(151) + .920_r8*rxt(362)*y(148) + rxt(343) &
                      *y(146) + rxt(350)*y(145) + rxt(295)*y(136) + rxt(316)*y(140) &
                      + rxt(289)*y(138) + rxt(325)*y(142) + 1.206_r8*rxt(368)*y(69) &
                      + rxt(378)*y(149) + rxt(281)*y(135)
         mat(1140) = mat(1140) + .700_r8*rxt(390)*y(76)
         mat(1238) = mat(1238) + rxt(202)*y(8) + rxt(205)*y(10) + rxt(332)*y(64) &
                      + .400_r8*rxt(372)*y(70)
         mat(1282) = mat(1282) + rxt(201)*y(2) + 2.000_r8*rxt(200)*y(6) + rxt(202) &
                      *y(133) + rxt(203)*y(134) + rxt(363)*y(148) + rxt(345)*y(146) &
                      + rxt(351)*y(145) + rxt(393)*y(77) + 1.206_r8*rxt(369)*y(69) &
                      + rxt(373)*y(70) + rxt(379)*y(149)
         mat(222) = rxt(205)*y(133)
         mat(883) = rxt(273)*y(6)
         mat(1420) = mat(1420) + rxt(191)*y(6) + rxt(203)*y(8) + .206_r8*rxt(370) &
                      *y(69)
         mat(1331) = mat(1331) + rxt(219)*y(6)
         mat(1479) = mat(1479) + rxt(240)*y(6)
         mat(454) = rxt(321)*y(6)
         mat(801) = mat(801) + rxt(302)*y(6)
         mat(156) = rxt(332)*y(133)
         mat(117) = rxt(334)*y(6)
         mat(375) = .900_r8*rxt(375)*y(6)
         mat(356) = rxt(338)*y(6)
         mat(243) = .900_r8*rxt(386)*y(6)
         mat(63) = mat(63) + .700_r8*rxt(390)*y(7)
         mat(553) = rxt(394)*y(6)
         mat(712) = .920_r8*rxt(362)*y(6) + rxt(363)*y(8)
         mat(733) = rxt(343)*y(6) + rxt(345)*y(8)
         mat(773) = mat(773) + rxt(350)*y(6) + rxt(351)*y(8)
         mat(487) = rxt(295)*y(6)
         mat(306) = rxt(393)*y(8)
         mat(531) = rxt(316)*y(6)
         mat(398) = rxt(289)*y(6)
         mat(638) = rxt(325)*y(6)
         mat(585) = 1.206_r8*rxt(368)*y(6) + 1.206_r8*rxt(369)*y(8) + .206_r8*rxt(370) &
                      *y(134)
         mat(539) = .400_r8*rxt(372)*y(133) + rxt(373)*y(8)
         mat(688) = rxt(378)*y(6) + rxt(379)*y(8)
         mat(180) = rxt(281)*y(6)

         mat(1239) = -(rxt(168)*y(2) + rxt(169)*y(1) + rxt(170)*y(134) + (4._r8*rxt(171) &
                      + 4._r8*rxt(172)) * y(133) + rxt(173)*y(18) + rxt(174)*y(20) &
                      + rxt(180)*y(35) + rxt(181)*y(36) + rxt(184)*y(5) + rxt(198) &
                      *y(7) + rxt(199)*y(9) + rxt(202)*y(8) + rxt(205)*y(10) + (rxt(215) &
                      + rxt(216)) * y(24) + rxt(226)*y(27) + rxt(230)*y(28) + rxt(232) &
                      *y(29) + rxt(238)*y(31) + rxt(246)*y(32) + (rxt(267) + rxt(268) &
                      ) * y(17) + rxt(270)*y(16) + rxt(277)*y(15) + rxt(278)*y(14) &
                      + rxt(279)*y(99) + rxt(286)*y(98) + rxt(287)*y(38) + rxt(288) &
                      *y(37) + rxt(294)*y(40) + rxt(299)*y(39) + rxt(300)*y(41) &
                      + rxt(307)*y(45) + rxt(308)*y(43) + rxt(309)*y(44) + rxt(310) &
                      *y(42) + rxt(312)*y(47) + rxt(313)*y(48) + rxt(319)*y(50) &
                      + rxt(320)*y(49) + rxt(323)*y(52) + rxt(324)*y(51) + rxt(328) &
                      *y(55) + rxt(329)*y(53) + rxt(330)*y(54) + rxt(332)*y(64) &
                      + rxt(333)*y(56) + rxt(335)*y(60) + rxt(337)*y(58) + rxt(340) &
                      *y(59) + rxt(341)*y(61) + rxt(349)*y(62) + rxt(358)*y(63) &
                      + rxt(359)*y(65) + rxt(365)*y(72) + rxt(371)*y(57) + rxt(372) &
                      *y(70) + rxt(374)*y(68) + rxt(377)*y(66) + rxt(383)*y(71) &
                      + rxt(385)*y(73) + rxt(388)*y(75) + rxt(389)*y(74) + rxt(391) &
                      *y(77) + rxt(396)*y(78) + rxt(402)*y(106) + rxt(403)*y(107) &
                      + rxt(406)*y(108) + rxt(413)*y(104) + (rxt(415) + rxt(416) &
                      ) * y(105))
         mat(954) = -rxt(168)*y(133)
         mat(1049) = -rxt(169)*y(133)
         mat(1421) = -rxt(170)*y(133)
         mat(660) = -rxt(173)*y(133)
         mat(325) = -rxt(174)*y(133)
         mat(70) = -rxt(180)*y(133)
         mat(31) = -rxt(181)*y(133)
         mat(475) = -rxt(184)*y(133)
         mat(1141) = -rxt(198)*y(133)
         mat(1305) = -rxt(199)*y(133)
         mat(1283) = -rxt(202)*y(133)
         mat(223) = -rxt(205)*y(133)
         mat(1332) = -(rxt(215) + rxt(216)) * y(133)
         mat(834) = -rxt(226)*y(133)
         mat(511) = -rxt(230)*y(133)
         mat(570) = -rxt(232)*y(133)
         mat(1480) = -rxt(238)*y(133)
         mat(461) = -rxt(246)*y(133)
         mat(608) = -(rxt(267) + rxt(268)) * y(133)
         mat(978) = -rxt(270)*y(133)
         mat(254) = -rxt(277)*y(133)
         mat(186) = -rxt(278)*y(133)
         mat(282) = -rxt(279)*y(133)
         mat(98) = -rxt(286)*y(133)
         mat(92) = -rxt(287)*y(133)
         mat(299) = -rxt(288)*y(133)
         mat(313) = -rxt(294)*y(133)
         mat(132) = -rxt(299)*y(133)
         mat(616) = -rxt(300)*y(133)
         mat(231) = -rxt(307)*y(133)
         mat(518) = -rxt(308)*y(133)
         mat(361) = -rxt(309)*y(133)
         mat(81) = -rxt(310)*y(133)
         mat(210) = -rxt(312)*y(133)
         mat(604) = -rxt(313)*y(133)
         mat(168) = -rxt(319)*y(133)
         mat(36) = -rxt(320)*y(133)
         mat(290) = -rxt(323)*y(133)
         mat(383) = -rxt(324)*y(133)
         mat(175) = -rxt(328)*y(133)
         mat(625) = -rxt(329)*y(133)
         mat(670) = -rxt(330)*y(133)
         mat(157) = -rxt(332)*y(133)
         mat(29) = -rxt(333)*y(133)
         mat(755) = -rxt(335)*y(133)
         mat(192) = -rxt(337)*y(133)
         mat(123) = -rxt(340)*y(133)
         mat(650) = -rxt(341)*y(133)
         mat(127) = -rxt(349)*y(133)
         mat(269) = -rxt(358)*y(133)
         mat(503) = -rxt(359)*y(133)
         mat(278) = -rxt(365)*y(133)
         mat(26) = -rxt(371)*y(133)
         mat(540) = -rxt(372)*y(133)
         mat(145) = -rxt(374)*y(133)
         mat(349) = -rxt(377)*y(133)
         mat(137) = -rxt(383)*y(133)
         mat(40) = -rxt(385)*y(133)
         mat(163) = -rxt(388)*y(133)
         mat(44) = -rxt(389)*y(133)
         mat(307) = -rxt(391)*y(133)
         mat(203) = -rxt(396)*y(133)
         mat(152) = -rxt(402)*y(133)
         mat(389) = -rxt(403)*y(133)
         mat(818) = -rxt(406)*y(133)
         mat(561) = -rxt(413)*y(133)
         mat(102) = -(rxt(415) + rxt(416)) * y(133)

         mat(1049) = mat(1049) + rxt(164)*y(19) + rxt(177)*y(134) + .330_r8*rxt(314) &
                      *y(48) + .270_r8*rxt(360)*y(65) + .120_r8*rxt(293)*y(37) &
                      + .080_r8*rxt(336)*y(60) + .215_r8*rxt(342)*y(61) &
                      + .700_r8*rxt(392)*y(77)
         mat(954) = mat(954) + rxt(175)*y(18) + rxt(271)*y(16) + rxt(176)*y(134) &
                      + rxt(179)*y(20) + rxt(227)*y(27) + rxt(228)*y(28) + rxt(247) &
                      *y(32) + rxt(248)*y(33)
         mat(1506) = rxt(159)*y(18) + rxt(162)*y(35) + 2.000_r8*rxt(134)*y(162) &
                      + rxt(160)*y(27) + rxt(161)*y(32)
         mat(660) = mat(660) + rxt(175)*y(2) + rxt(159)*y(161)
         mat(1104) = rxt(191)*y(134)
         mat(1239) = mat(1239) + .300_r8*rxt(278)*y(14) + .500_r8*rxt(323)*y(52) &
                      + .100_r8*rxt(349)*y(62) + .500_r8*rxt(299)*y(39) &
                      + .650_r8*rxt(286)*y(98)
         mat(1283) = mat(1283) + rxt(203)*y(134)
         mat(186) = mat(186) + .300_r8*rxt(278)*y(133)
         mat(70) = mat(70) + rxt(162)*y(161)
         mat(978) = mat(978) + rxt(271)*y(2)
         mat(1352) = rxt(164)*y(1) + 2.000_r8*rxt(165)*y(134)
         mat(1421) = mat(1421) + rxt(177)*y(1) + rxt(176)*y(2) + rxt(191)*y(6) &
                      + rxt(203)*y(8) + 2.000_r8*rxt(165)*y(19) + rxt(211)*y(131)
         mat(325) = mat(325) + rxt(179)*y(2)
         mat(1004) = 2.000_r8*rxt(134)*y(161) + rxt(250)*y(103)
         mat(1456) = rxt(211)*y(134)
         mat(834) = mat(834) + rxt(227)*y(2) + rxt(160)*y(161)
         mat(511) = mat(511) + rxt(228)*y(2)
         mat(461) = mat(461) + rxt(247)*y(2) + rxt(161)*y(161)
         mat(434) = rxt(248)*y(2)
         mat(604) = mat(604) + .330_r8*rxt(314)*y(1)
         mat(503) = mat(503) + .270_r8*rxt(360)*y(1)
         mat(290) = mat(290) + .500_r8*rxt(323)*y(133)
         mat(299) = mat(299) + .120_r8*rxt(293)*y(1)
         mat(755) = mat(755) + .080_r8*rxt(336)*y(1)
         mat(650) = mat(650) + .215_r8*rxt(342)*y(1)
         mat(127) = mat(127) + .100_r8*rxt(349)*y(133)
         mat(132) = mat(132) + .500_r8*rxt(299)*y(133)
         mat(307) = mat(307) + .700_r8*rxt(392)*y(1)
         mat(98) = mat(98) + .650_r8*rxt(286)*y(133)
         mat(442) = rxt(250)*y(162)


      end subroutine nlnmat02

      subroutine nlnmat03( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(1284) = -(rxt(196)*y(7) + rxt(200)*y(6) + rxt(201)*y(2) + rxt(202)*y(133) &
                      + rxt(203)*y(134) + rxt(269)*y(16) + rxt(301)*y(41) + rxt(315) &
                      *y(48) + rxt(331)*y(54) + rxt(345)*y(146) + rxt(351)*y(145) &
                      + rxt(361)*y(65) + rxt(363)*y(148) + rxt(369)*y(69) + rxt(373) &
                      *y(70) + rxt(379)*y(149) + rxt(393)*y(77) + rxt(417)*y(105))
         mat(1142) = -rxt(196)*y(8)
         mat(1105) = -rxt(200)*y(8)
         mat(955) = -rxt(201)*y(8)
         mat(1240) = -rxt(202)*y(8)
         mat(1422) = -rxt(203)*y(8)
         mat(979) = -rxt(269)*y(8)
         mat(617) = -rxt(301)*y(8)
         mat(605) = -rxt(315)*y(8)
         mat(671) = -rxt(331)*y(8)
         mat(735) = -rxt(345)*y(8)
         mat(775) = -rxt(351)*y(8)
         mat(504) = -rxt(361)*y(8)
         mat(714) = -rxt(363)*y(8)
         mat(587) = -rxt(369)*y(8)
         mat(541) = -rxt(373)*y(8)
         mat(690) = -rxt(379)*y(8)
         mat(308) = -rxt(393)*y(8)
         mat(103) = -rxt(417)*y(8)

         mat(1050) = rxt(195)*y(7)
         mat(955) = mat(955) + rxt(194)*y(7) + rxt(231)*y(29) + rxt(249)*y(34)
         mat(1142) = mat(1142) + rxt(195)*y(1) + rxt(194)*y(2)
         mat(1240) = mat(1240) + rxt(199)*y(9) + rxt(232)*y(29) + rxt(312)*y(47) &
                      + .500_r8*rxt(358)*y(63)
         mat(1306) = rxt(199)*y(133) + rxt(253)*y(103)
         mat(1457) = rxt(233)*y(29)
         mat(571) = rxt(231)*y(2) + rxt(232)*y(133) + rxt(233)*y(131)
         mat(261) = rxt(249)*y(2)
         mat(211) = rxt(312)*y(133)
         mat(270) = .500_r8*rxt(358)*y(133)
         mat(443) = rxt(253)*y(9)

         mat(1307) = -(rxt(199)*y(133) + rxt(253)*y(103))
         mat(1241) = -rxt(199)*y(9)
         mat(444) = -rxt(253)*y(9)

         mat(1143) = rxt(198)*y(133)
         mat(1241) = mat(1241) + rxt(198)*y(7)
         mat(1285) = rxt(269)*y(16) + rxt(301)*y(41) + rxt(331)*y(54) + rxt(417) &
                      *y(105)
         mat(980) = rxt(269)*y(8)
         mat(836) = (rxt(421)+rxt(426)+rxt(432))*y(29)
         mat(572) = (rxt(421)+rxt(426)+rxt(432))*y(27)
         mat(618) = rxt(301)*y(8)
         mat(672) = rxt(331)*y(8)
         mat(104) = rxt(417)*y(8)

         mat(219) = -(rxt(205)*y(133))
         mat(1180) = -rxt(205)*y(10)

         mat(1116) = rxt(204)*y(134)
         mat(1373) = rxt(204)*y(7)


         mat(1114) = rxt(196)*y(8)
         mat(1249) = rxt(196)*y(7)

         mat(877) = -(rxt(218)*y(24) + rxt(273)*y(6) + rxt(274)*y(134) + (4._r8*rxt(275) &
                      + 4._r8*rxt(276)) * y(13) + rxt(297)*y(136) + rxt(305)*y(137) &
                      + rxt(318)*y(140) + rxt(327)*y(142) + rxt(347)*y(146) + rxt(353) &
                      *y(145) + rxt(366)*y(148) + rxt(381)*y(149))
         mat(1324) = -rxt(218)*y(13)
         mat(1096) = -rxt(273)*y(13)
         mat(1413) = -rxt(274)*y(13)
         mat(483) = -rxt(297)*y(13)
         mat(795) = -rxt(305)*y(13)
         mat(526) = -rxt(318)*y(13)
         mat(633) = -rxt(327)*y(13)
         mat(729) = -rxt(347)*y(13)
         mat(767) = -rxt(353)*y(13)
         mat(707) = -rxt(366)*y(13)
         mat(684) = -rxt(381)*y(13)

         mat(1041) = .310_r8*rxt(314)*y(48)
         mat(1096) = mat(1096) + rxt(302)*y(137)
         mat(1231) = .700_r8*rxt(278)*y(14) + rxt(294)*y(40)
         mat(877) = mat(877) + .900_r8*rxt(305)*y(137)
         mat(183) = .700_r8*rxt(278)*y(133)
         mat(597) = .310_r8*rxt(314)*y(1)
         mat(311) = rxt(294)*y(133)
         mat(795) = mat(795) + rxt(302)*y(6) + .900_r8*rxt(305)*y(13) &
                      + 4.000_r8*rxt(306)*y(137) + rxt(367)*y(148) + rxt(348)*y(146) &
                      + rxt(354)*y(145) + rxt(382)*y(149)
         mat(707) = mat(707) + rxt(367)*y(137)
         mat(729) = mat(729) + rxt(348)*y(137)
         mat(767) = mat(767) + rxt(354)*y(137)
         mat(684) = mat(684) + rxt(382)*y(137)

         mat(182) = -(rxt(278)*y(133))
         mat(1176) = -rxt(278)*y(14)

         mat(857) = rxt(274)*y(134)
         mat(1370) = rxt(274)*y(13)

         mat(69) = -(rxt(162)*y(161) + rxt(180)*y(133))
         mat(1492) = -rxt(162)*y(35)
         mat(1159) = -rxt(180)*y(35)

         mat(30) = -(rxt(181)*y(133))
         mat(1152) = -rxt(181)*y(36)

         mat(973) = -(rxt(212)*y(131) + rxt(236)*y(132) + rxt(269)*y(8) + rxt(270) &
                      *y(133) + rxt(271)*y(2) + rxt(272)*y(134))
         mat(1451) = -rxt(212)*y(16)
         mat(847) = -rxt(236)*y(16)
         mat(1278) = -rxt(269)*y(16)
         mat(1234) = -rxt(270)*y(16)
         mat(949) = -rxt(271)*y(16)
         mat(1416) = -rxt(272)*y(16)

         mat(1044) = .540_r8*rxt(314)*y(48) + .600_r8*rxt(360)*y(65) + rxt(293)*y(37) &
                      + .800_r8*rxt(336)*y(60) + .700_r8*rxt(342)*y(61)
         mat(1099) = rxt(273)*y(13) + rxt(321)*y(141) + .500_r8*rxt(334)*y(143) &
                      + .100_r8*rxt(375)*y(147) + .510_r8*rxt(362)*y(148) &
                      + .250_r8*rxt(343)*y(146) + rxt(350)*y(145) + .500_r8*rxt(289) &
                      *y(138) + rxt(325)*y(142) + .072_r8*rxt(368)*y(69)
         mat(1234) = mat(1234) + .300_r8*rxt(278)*y(14) + .500_r8*rxt(307)*y(45) &
                      + rxt(312)*y(47) + .500_r8*rxt(358)*y(63) + rxt(277)*y(15) &
                      + .800_r8*rxt(308)*y(43)
         mat(1278) = mat(1278) + .600_r8*rxt(363)*y(148) + .250_r8*rxt(345)*y(146) &
                      + rxt(351)*y(145) + .072_r8*rxt(369)*y(69)
         mat(879) = rxt(273)*y(6) + (4.000_r8*rxt(275)+2.000_r8*rxt(276))*y(13) &
                      + rxt(218)*y(24) + rxt(305)*y(137) + 1.200_r8*rxt(366)*y(148) &
                      + .880_r8*rxt(347)*y(146) + 2.000_r8*rxt(353)*y(145) &
                      + .700_r8*rxt(297)*y(136) + rxt(318)*y(140) + .800_r8*rxt(327) &
                      *y(142) + .700_r8*rxt(381)*y(149)
         mat(184) = .300_r8*rxt(278)*y(133)
         mat(1416) = mat(1416) + .008_r8*rxt(370)*y(69)
         mat(1327) = rxt(218)*y(13)
         mat(599) = .540_r8*rxt(314)*y(1)
         mat(500) = .600_r8*rxt(360)*y(1)
         mat(451) = rxt(321)*y(6)
         mat(797) = rxt(305)*y(13) + .600_r8*rxt(367)*y(148) + .250_r8*rxt(348)*y(146) &
                      + rxt(354)*y(145)
         mat(229) = .500_r8*rxt(307)*y(133)
         mat(208) = rxt(312)*y(133)
         mat(296) = rxt(293)*y(1)
         mat(267) = .500_r8*rxt(358)*y(133)
         mat(115) = .500_r8*rxt(334)*y(6)
         mat(373) = .100_r8*rxt(375)*y(6)
         mat(708) = .510_r8*rxt(362)*y(6) + .600_r8*rxt(363)*y(8) + 1.200_r8*rxt(366) &
                      *y(13) + .600_r8*rxt(367)*y(137)
         mat(750) = .800_r8*rxt(336)*y(1)
         mat(647) = .700_r8*rxt(342)*y(1)
         mat(730) = .250_r8*rxt(343)*y(6) + .250_r8*rxt(345)*y(8) + .880_r8*rxt(347) &
                      *y(13) + .250_r8*rxt(348)*y(137)
         mat(769) = rxt(350)*y(6) + rxt(351)*y(8) + 2.000_r8*rxt(353)*y(13) + rxt(354) &
                      *y(137) + 4.000_r8*rxt(355)*y(145)
         mat(485) = .700_r8*rxt(297)*y(13)
         mat(528) = rxt(318)*y(13)
         mat(253) = rxt(277)*y(133)
         mat(517) = .800_r8*rxt(308)*y(133)
         mat(396) = .500_r8*rxt(289)*y(6)
         mat(635) = rxt(325)*y(6) + .800_r8*rxt(327)*y(13)
         mat(582) = .072_r8*rxt(368)*y(6) + .072_r8*rxt(369)*y(8) + .008_r8*rxt(370) &
                      *y(134)
         mat(685) = .700_r8*rxt(381)*y(13)

         mat(1356) = -(rxt(163)*y(3) + rxt(164)*y(1) + (rxt(165) + rxt(166) + rxt(167) &
                      ) * y(134))
         mat(917) = -rxt(163)*y(19)
         mat(1053) = -rxt(164)*y(19)
         mat(1425) = -(rxt(165) + rxt(166) + rxt(167)) * y(19)

         mat(958) = rxt(175)*y(18) + rxt(168)*y(133)
         mat(1510) = rxt(159)*y(18)
         mat(663) = rxt(175)*y(2) + rxt(159)*y(161) + rxt(173)*y(133) + rxt(208) &
                      *y(131) + rxt(251)*y(103)
         mat(609) = rxt(267)*y(133)
         mat(476) = rxt(184)*y(133)
         mat(1243) = rxt(168)*y(2) + rxt(173)*y(18) + rxt(267)*y(17) + rxt(184)*y(5) &
                      + rxt(270)*y(16) + rxt(402)*y(106) + rxt(403)*y(107) + rxt(406) &
                      *y(108)
         mat(982) = rxt(270)*y(133)
         mat(1460) = rxt(208)*y(18)
         mat(445) = rxt(251)*y(18)
         mat(153) = rxt(402)*y(133)
         mat(390) = rxt(403)*y(133)
         mat(820) = rxt(406)*y(133)

         mat(1426) = -((rxt(165) + rxt(166) + rxt(167)) * y(19) + rxt(170)*y(133) &
                      + rxt(176)*y(2) + rxt(177)*y(1) + 4._r8*rxt(178)*y(134) + rxt(191) &
                      *y(6) + rxt(203)*y(8) + rxt(204)*y(7) + (rxt(210) + rxt(211) &
                      ) * y(131) + rxt(217)*y(24) + rxt(235)*y(132) + rxt(239)*y(31) &
                      + rxt(272)*y(16) + rxt(274)*y(13) + rxt(282)*y(135) + rxt(290) &
                      *y(138) + rxt(296)*y(136) + rxt(304)*y(137) + rxt(317)*y(140) &
                      + rxt(322)*y(141) + rxt(326)*y(142) + rxt(339)*y(144) + rxt(346) &
                      *y(146) + rxt(352)*y(145) + rxt(364)*y(148) + rxt(370)*y(69) &
                      + rxt(376)*y(147) + rxt(380)*y(149) + rxt(387)*y(150) + rxt(395) &
                      *y(151))
         mat(1357) = -(rxt(165) + rxt(166) + rxt(167)) * y(134)
         mat(1244) = -rxt(170)*y(134)
         mat(959) = -rxt(176)*y(134)
         mat(1054) = -rxt(177)*y(134)
         mat(1109) = -rxt(191)*y(134)
         mat(1288) = -rxt(203)*y(134)
         mat(1146) = -rxt(204)*y(134)
         mat(1461) = -(rxt(210) + rxt(211)) * y(134)
         mat(1337) = -rxt(217)*y(134)
         mat(852) = -rxt(235)*y(134)
         mat(1485) = -rxt(239)*y(134)
         mat(983) = -rxt(272)*y(134)
         mat(889) = -rxt(274)*y(134)
         mat(181) = -rxt(282)*y(134)
         mat(400) = -rxt(290)*y(134)
         mat(489) = -rxt(296)*y(134)
         mat(806) = -rxt(304)*y(134)
         mat(533) = -rxt(317)*y(134)
         mat(456) = -rxt(322)*y(134)
         mat(640) = -rxt(326)*y(134)
         mat(358) = -rxt(339)*y(134)
         mat(738) = -rxt(346)*y(134)
         mat(778) = -rxt(352)*y(134)
         mat(717) = -rxt(364)*y(134)
         mat(588) = -rxt(370)*y(134)
         mat(377) = -rxt(376)*y(134)
         mat(693) = -rxt(380)*y(134)
         mat(245) = -rxt(387)*y(134)
         mat(555) = -rxt(395)*y(134)

         mat(1054) = mat(1054) + rxt(169)*y(133) + .190_r8*rxt(314)*y(48) &
                      + .060_r8*rxt(360)*y(65) + .120_r8*rxt(293)*y(37) &
                      + .060_r8*rxt(336)*y(60) + .275_r8*rxt(342)*y(61) + rxt(392) &
                      *y(77)
         mat(959) = mat(959) + rxt(271)*y(16) + rxt(179)*y(20)
         mat(918) = rxt(163)*y(19) + rxt(291)*y(139)
         mat(610) = rxt(268)*y(133)
         mat(1109) = mat(1109) + rxt(273)*y(13) + rxt(321)*y(141) + rxt(334)*y(143) &
                      + .900_r8*rxt(375)*y(147) + .900_r8*rxt(386)*y(150) + rxt(394) &
                      *y(151) + rxt(362)*y(148) + .470_r8*rxt(343)*y(146) + rxt(295) &
                      *y(136) + rxt(316)*y(140) + .250_r8*rxt(289)*y(138) &
                      + .794_r8*rxt(368)*y(69) + rxt(378)*y(149) + rxt(281)*y(135)
         mat(1146) = mat(1146) + .700_r8*rxt(390)*y(76)
         mat(1244) = mat(1244) + rxt(169)*y(1) + rxt(268)*y(17) + rxt(202)*y(8) &
                      + rxt(180)*y(35) + rxt(181)*y(36) + rxt(174)*y(20) + rxt(215) &
                      *y(24) + rxt(238)*y(31) + .500_r8*rxt(358)*y(63) &
                      + .250_r8*rxt(385)*y(73) + rxt(309)*y(44) + .200_r8*rxt(349) &
                      *y(62) + rxt(277)*y(15) + rxt(310)*y(42) + rxt(308)*y(43) &
                      + rxt(329)*y(53) + rxt(372)*y(70) + .350_r8*rxt(286)*y(98) &
                      + rxt(279)*y(99) + rxt(413)*y(104) + .500_r8*rxt(416)*y(105)
         mat(1288) = mat(1288) + rxt(202)*y(133) + rxt(269)*y(16) + rxt(363)*y(148) &
                      + .470_r8*rxt(345)*y(146) + .794_r8*rxt(369)*y(69) + rxt(373) &
                      *y(70) + rxt(379)*y(149)
         mat(889) = mat(889) + rxt(273)*y(6) + 4.000_r8*rxt(275)*y(13) + rxt(218) &
                      *y(24) + .900_r8*rxt(305)*y(137) + rxt(366)*y(148) &
                      + .730_r8*rxt(347)*y(146) + rxt(353)*y(145) + rxt(297)*y(136) &
                      + rxt(318)*y(140) + .300_r8*rxt(327)*y(142) + .800_r8*rxt(381) &
                      *y(149)
         mat(71) = rxt(180)*y(133)
         mat(32) = rxt(181)*y(133)
         mat(983) = mat(983) + rxt(271)*y(2) + rxt(269)*y(8) + rxt(212)*y(131) &
                      + rxt(236)*y(132)
         mat(1357) = mat(1357) + rxt(163)*y(3)
         mat(1426) = mat(1426) + .794_r8*rxt(370)*y(69)
         mat(326) = rxt(179)*y(2) + rxt(174)*y(133) + rxt(209)*y(131)
         mat(1461) = mat(1461) + rxt(212)*y(16) + rxt(209)*y(20)
         mat(1337) = mat(1337) + rxt(215)*y(133) + rxt(218)*y(13)
         mat(852) = mat(852) + rxt(236)*y(16)
         mat(1485) = mat(1485) + rxt(238)*y(133)
         mat(606) = .190_r8*rxt(314)*y(1)
         mat(505) = .060_r8*rxt(360)*y(1)
         mat(456) = mat(456) + rxt(321)*y(6)
         mat(806) = mat(806) + .900_r8*rxt(305)*y(13) + rxt(367)*y(148) &
                      + .470_r8*rxt(348)*y(146) + rxt(382)*y(149)
         mat(300) = .120_r8*rxt(293)*y(1)
         mat(271) = .500_r8*rxt(358)*y(133)
         mat(118) = rxt(334)*y(6)
         mat(377) = mat(377) + .900_r8*rxt(375)*y(6)
         mat(41) = .250_r8*rxt(385)*y(133)
         mat(245) = mat(245) + .900_r8*rxt(386)*y(6)
         mat(64) = .700_r8*rxt(390)*y(7)
         mat(555) = mat(555) + rxt(394)*y(6)
         mat(362) = rxt(309)*y(133)
         mat(717) = mat(717) + rxt(362)*y(6) + rxt(363)*y(8) + rxt(366)*y(13) &
                      + rxt(367)*y(137)
         mat(759) = .060_r8*rxt(336)*y(1)
         mat(652) = .275_r8*rxt(342)*y(1)
         mat(738) = mat(738) + .470_r8*rxt(343)*y(6) + .470_r8*rxt(345)*y(8) &
                      + .730_r8*rxt(347)*y(13) + .470_r8*rxt(348)*y(137)
         mat(128) = .200_r8*rxt(349)*y(133)
         mat(778) = mat(778) + rxt(353)*y(13)
         mat(489) = mat(489) + rxt(295)*y(6) + rxt(297)*y(13) + 2.400_r8*rxt(298) &
                      *y(136)
         mat(309) = rxt(392)*y(1)
         mat(533) = mat(533) + rxt(316)*y(6) + rxt(318)*y(13)
         mat(255) = rxt(277)*y(133)
         mat(82) = rxt(310)*y(133)
         mat(519) = rxt(308)*y(133)
         mat(626) = rxt(329)*y(133)
         mat(400) = mat(400) + .250_r8*rxt(289)*y(6)
         mat(197) = rxt(291)*y(3)
         mat(640) = mat(640) + .300_r8*rxt(327)*y(13)
         mat(588) = mat(588) + .794_r8*rxt(368)*y(6) + .794_r8*rxt(369)*y(8) &
                      + .794_r8*rxt(370)*y(134)
         mat(542) = rxt(372)*y(133) + rxt(373)*y(8)
         mat(693) = mat(693) + rxt(378)*y(6) + rxt(379)*y(8) + .800_r8*rxt(381)*y(13) &
                      + rxt(382)*y(137)
         mat(99) = .350_r8*rxt(286)*y(133)
         mat(283) = rxt(279)*y(133)
         mat(181) = mat(181) + rxt(281)*y(6)
         mat(562) = rxt(413)*y(133)
         mat(105) = .500_r8*rxt(416)*y(133)


      end subroutine nlnmat03

      subroutine nlnmat04( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(321) = -(rxt(174)*y(133) + rxt(179)*y(2) + rxt(209)*y(131))
         mat(1192) = -rxt(174)*y(20)
         mat(929) = -rxt(179)*y(20)
         mat(1435) = -rxt(209)*y(20)

         mat(1192) = mat(1192) + 2.000_r8*rxt(172)*y(133)
         mat(1381) = 2.000_r8*rxt(178)*y(134)

         mat(1000) = -(rxt(134)*y(161) + rxt(250)*y(103) + rxt(414)*y(109))
         mat(1502) = -rxt(134)*y(162)
         mat(441) = -rxt(250)*y(162)
         mat(87) = -rxt(414)*y(162)

         mat(659) = rxt(173)*y(133)
         mat(1235) = rxt(173)*y(18) + 2.000_r8*rxt(171)*y(133) + rxt(199)*y(9) &
                      + rxt(205)*y(10) + rxt(278)*y(14) + rxt(270)*y(16) + rxt(170) &
                      *y(134) + rxt(174)*y(20) + rxt(226)*y(27) + rxt(230)*y(28) &
                      + rxt(246)*y(32) + rxt(300)*y(41) + rxt(294)*y(40) + rxt(323) &
                      *y(52) + rxt(307)*y(45) + rxt(287)*y(38) + .500_r8*rxt(341) &
                      *y(61) + rxt(320)*y(49) + rxt(319)*y(50) + rxt(324)*y(51) &
                      + rxt(328)*y(55) + rxt(330)*y(54) + (rxt(383)+rxt(384))*y(71) &
                      + rxt(279)*y(99)
         mat(1301) = rxt(199)*y(133)
         mat(221) = rxt(205)*y(133)
         mat(185) = rxt(278)*y(133)
         mat(974) = rxt(270)*y(133)
         mat(1348) = rxt(167)*y(134)
         mat(1417) = rxt(170)*y(133) + rxt(167)*y(19)
         mat(324) = rxt(174)*y(133)
         mat(832) = rxt(226)*y(133) + (rxt(422)+rxt(427)+rxt(433))*y(28) + (rxt(423) &
                       +rxt(434))*y(33)
         mat(510) = rxt(230)*y(133) + (rxt(422)+rxt(427)+rxt(433))*y(27)
         mat(460) = rxt(246)*y(133)
         mat(433) = (rxt(423)+rxt(434))*y(27)
         mat(615) = rxt(300)*y(133)
         mat(312) = rxt(294)*y(133)
         mat(289) = rxt(323)*y(133)
         mat(230) = rxt(307)*y(133)
         mat(91) = rxt(287)*y(133)
         mat(648) = .500_r8*rxt(341)*y(133)
         mat(35) = rxt(320)*y(133)
         mat(167) = rxt(319)*y(133)
         mat(382) = rxt(324)*y(133)
         mat(174) = rxt(328)*y(133)
         mat(669) = rxt(330)*y(133)
         mat(136) = (rxt(383)+rxt(384))*y(133)
         mat(281) = rxt(279)*y(133)

         mat(1462) = -(rxt(207)*y(1) + rxt(208)*y(18) + rxt(209)*y(20) + (rxt(210) &
                      + rxt(211)) * y(134) + rxt(212)*y(16) + rxt(229)*y(28) + rxt(233) &
                      *y(29) + rxt(285)*y(38))
         mat(1055) = -rxt(207)*y(131)
         mat(664) = -rxt(208)*y(131)
         mat(327) = -rxt(209)*y(131)
         mat(1427) = -(rxt(210) + rxt(211)) * y(131)
         mat(984) = -rxt(212)*y(131)
         mat(513) = -rxt(229)*y(131)
         mat(574) = -rxt(233)*y(131)
         mat(93) = -rxt(285)*y(131)

         mat(960) = rxt(214)*y(24) + rxt(227)*y(27)
         mat(1512) = rxt(160)*y(27) + rxt(155)*y(101)
         mat(1110) = rxt(219)*y(24)
         mat(1245) = rxt(215)*y(24) + rxt(226)*y(27)
         mat(890) = rxt(218)*y(24)
         mat(1338) = rxt(214)*y(2) + rxt(219)*y(6) + rxt(215)*y(133) + rxt(218)*y(13) + ( &
                      + 4.000_r8*rxt(221)+2.000_r8*rxt(223))*y(24) + rxt(243)*y(31) &
                      + rxt(410)*y(108)
         mat(839) = rxt(227)*y(2) + rxt(160)*y(161) + rxt(226)*y(133)
         mat(1486) = rxt(243)*y(24)
         mat(67) = rxt(155)*y(161)
         mat(822) = rxt(410)*y(24)


         mat(1430) = rxt(233)*y(29)
         mat(1315) = 2.000_r8*rxt(222)*y(24)
         mat(824) = (rxt(422)+rxt(427)+rxt(433))*y(28) + (rxt(421)+rxt(426)+rxt(432)) &
                      *y(29)
         mat(506) = (rxt(422)+rxt(427)+rxt(433))*y(27)
         mat(563) = rxt(233)*y(131) + (rxt(421)+rxt(426)+rxt(432))*y(27)

         mat(1335) = -(rxt(214)*y(2) + (rxt(215) + rxt(216)) * y(133) + rxt(217) &
                      *y(134) + rxt(218)*y(13) + rxt(219)*y(6) + rxt(220)*y(7) &
                      + (4._r8*rxt(221) + 4._r8*rxt(222) + 4._r8*rxt(223) &
                      + 4._r8*rxt(224)) * y(24) + (rxt(242) + rxt(243) + rxt(244) &
                      ) * y(31) + rxt(410)*y(108))
         mat(957) = -rxt(214)*y(24)
         mat(1242) = -(rxt(215) + rxt(216)) * y(24)
         mat(1424) = -rxt(217)*y(24)
         mat(887) = -rxt(218)*y(24)
         mat(1107) = -rxt(219)*y(24)
         mat(1144) = -rxt(220)*y(24)
         mat(1483) = -(rxt(242) + rxt(243) + rxt(244)) * y(24)
         mat(819) = -rxt(410)*y(24)

         mat(1052) = rxt(207)*y(131)
         mat(957) = mat(957) + rxt(228)*y(28) + rxt(231)*y(29)
         mat(1242) = mat(1242) + rxt(230)*y(28)
         mat(1424) = mat(1424) + rxt(211)*y(131)
         mat(1459) = rxt(207)*y(1) + rxt(211)*y(134) + rxt(229)*y(28)
         mat(142) = rxt(412)*y(108)
         mat(512) = rxt(228)*y(2) + rxt(230)*y(133) + rxt(229)*y(131)
         mat(573) = rxt(231)*y(2)
         mat(819) = mat(819) + rxt(412)*y(25)

         mat(138) = -(rxt(412)*y(108))
         mat(807) = -rxt(412)*y(25)

         mat(1317) = 2.000_r8*rxt(223)*y(24) + rxt(242)*y(31)
         mat(1466) = rxt(242)*y(24)


         mat(1314) = 2.000_r8*rxt(224)*y(24)

         mat(829) = -(rxt(160)*y(161) + rxt(226)*y(133) + rxt(227)*y(2) + (rxt(421) &
                      + rxt(426) + rxt(432)) * y(29) + (rxt(422) + rxt(427) + rxt(433) &
                      ) * y(28) + (rxt(423) + rxt(434)) * y(33))
         mat(1496) = -rxt(160)*y(27)
         mat(1229) = -rxt(226)*y(27)
         mat(944) = -rxt(227)*y(27)
         mat(566) = -(rxt(421) + rxt(426) + rxt(432)) * y(27)
         mat(508) = -(rxt(422) + rxt(427) + rxt(433)) * y(27)
         mat(430) = -(rxt(423) + rxt(434)) * y(27)

         mat(656) = rxt(208)*y(131)
         mat(1229) = mat(1229) + rxt(216)*y(24)
         mat(968) = rxt(212)*y(131)
         mat(1411) = rxt(210)*y(131)
         mat(322) = rxt(209)*y(131)
         mat(1446) = rxt(208)*y(18) + rxt(212)*y(16) + rxt(210)*y(134) + rxt(209) &
                      *y(20) + rxt(229)*y(28) + rxt(285)*y(38)
         mat(1322) = rxt(216)*y(133)
         mat(508) = mat(508) + rxt(229)*y(131)
         mat(90) = rxt(285)*y(131)

         mat(507) = -(rxt(228)*y(2) + rxt(229)*y(131) + rxt(230)*y(133) + (rxt(422) &
                      + rxt(427) + rxt(433)) * y(27))
         mat(938) = -rxt(228)*y(28)
         mat(1439) = -rxt(229)*y(28)
         mat(1206) = -rxt(230)*y(28)
         mat(827) = -(rxt(422) + rxt(427) + rxt(433)) * y(28)

         mat(1206) = mat(1206) + rxt(232)*y(29)
         mat(1392) = rxt(217)*y(24)
         mat(1318) = rxt(217)*y(134)
         mat(564) = rxt(232)*y(133)

         mat(565) = -(rxt(231)*y(2) + rxt(232)*y(133) + rxt(233)*y(131) + (rxt(421) &
                      + rxt(426) + rxt(432)) * y(27))
         mat(940) = -rxt(231)*y(29)
         mat(1212) = -rxt(232)*y(29)
         mat(1441) = -rxt(233)*y(29)
         mat(828) = -(rxt(421) + rxt(426) + rxt(432)) * y(29)

         mat(1124) = rxt(220)*y(24)
         mat(1320) = rxt(220)*y(7)


         mat(1316) = rxt(244)*y(31)
         mat(825) = (rxt(423)+rxt(434))*y(33)
         mat(1465) = rxt(244)*y(24)
         mat(428) = (rxt(423)+rxt(434))*y(27)

         mat(844) = -(rxt(234)*y(1) + rxt(235)*y(134) + rxt(236)*y(16))
         mat(1040) = -rxt(234)*y(132)
         mat(1412) = -rxt(235)*y(132)
         mat(969) = -rxt(236)*y(132)

         mat(945) = rxt(237)*y(31) + rxt(247)*y(32)
         mat(1497) = rxt(161)*y(32)
         mat(1095) = rxt(240)*y(31)
         mat(1230) = rxt(238)*y(31) + rxt(246)*y(32)
         mat(1323) = (rxt(242)+rxt(243))*y(31)
         mat(1472) = rxt(237)*y(2) + rxt(240)*y(6) + rxt(238)*y(133) + (rxt(242) &
                       +rxt(243))*y(24) + 4.000_r8*rxt(245)*y(31) + rxt(411)*y(108)
         mat(458) = rxt(247)*y(2) + rxt(161)*y(161) + rxt(246)*y(133)
         mat(811) = rxt(411)*y(31)

         mat(1487) = -(rxt(237)*y(2) + rxt(238)*y(133) + rxt(239)*y(134) + rxt(240) &
                      *y(6) + rxt(241)*y(7) + (rxt(242) + rxt(243) + rxt(244)) * y(24) &
                      + 4._r8*rxt(245)*y(31) + rxt(411)*y(108))
         mat(961) = -rxt(237)*y(31)
         mat(1246) = -rxt(238)*y(31)
         mat(1428) = -rxt(239)*y(31)
         mat(1111) = -rxt(240)*y(31)
         mat(1148) = -rxt(241)*y(31)
         mat(1339) = -(rxt(242) + rxt(243) + rxt(244)) * y(31)
         mat(823) = -rxt(411)*y(31)

         mat(1056) = rxt(234)*y(132)
         mat(961) = mat(961) + rxt(248)*y(33) + rxt(249)*y(34)
         mat(853) = rxt(234)*y(1)
         mat(436) = rxt(248)*y(2)
         mat(263) = rxt(249)*y(2)

         mat(457) = -(rxt(161)*y(161) + rxt(246)*y(133) + rxt(247)*y(2))
         mat(1494) = -rxt(161)*y(32)
         mat(1202) = -rxt(246)*y(32)
         mat(936) = -rxt(247)*y(32)

         mat(965) = rxt(236)*y(132)
         mat(1390) = rxt(235)*y(132)
         mat(842) = rxt(236)*y(16) + rxt(235)*y(134)

         mat(429) = -(rxt(248)*y(2) + (rxt(423) + rxt(434)) * y(27))
         mat(935) = -rxt(248)*y(33)
         mat(826) = -(rxt(423) + rxt(434)) * y(33)

         mat(1388) = rxt(239)*y(31)
         mat(1468) = rxt(239)*y(134)

         mat(256) = -(rxt(249)*y(2))
         mat(927) = -rxt(249)*y(34)

         mat(1118) = rxt(241)*y(31)
         mat(1467) = rxt(241)*y(7)

         mat(330) = -((rxt(437) + rxt(438)) * y(2) + rxt(445)*y(3) + rxt(449)*y(157))
         mat(930) = -(rxt(437) + rxt(438)) * y(152)
         mat(897) = -rxt(445)*y(152)
         mat(418) = -rxt(449)*y(152)

         mat(401) = -(rxt(440)*y(5) + rxt(441)*y(6) + rxt(448)*y(157))
         mat(466) = -rxt(440)*y(153)
         mat(1072) = -rxt(441)*y(153)
         mat(419) = -rxt(448)*y(153)

         mat(899) = rxt(445)*y(152) + rxt(442)*y(154) + rxt(435)*y(155)
         mat(331) = rxt(445)*y(3)
         mat(214) = rxt(442)*y(3)
         mat(315) = rxt(435)*y(3)

         mat(212) = -((rxt(442) + rxt(443)) * y(3) + rxt(444)*y(2))
         mat(894) = -(rxt(442) + rxt(443)) * y(154)
         mat(925) = -rxt(444)*y(154)

         mat(314) = -(rxt(435)*y(3))
         mat(896) = -rxt(435)*y(155)

         mat(928) = rxt(438)*y(152) + rxt(444)*y(154)
         mat(329) = rxt(438)*y(2)
         mat(213) = rxt(444)*y(2)


      end subroutine nlnmat04

      subroutine nlnmat05( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(410) = -(rxt(447)*y(157))
         mat(420) = -rxt(447)*y(156)

         mat(933) = rxt(437)*y(152)
         mat(900) = rxt(443)*y(154)
         mat(467) = rxt(440)*y(153)
         mat(1073) = rxt(441)*y(153)
         mat(332) = rxt(437)*y(2)
         mat(402) = rxt(440)*y(5) + rxt(441)*y(6)
         mat(215) = rxt(443)*y(3)

         mat(232) = -(rxt(182)*y(3) + rxt(183)*y(2))
         mat(895) = -rxt(182)*y(158)
         mat(926) = -rxt(183)*y(158)

         mat(926) = mat(926) + rxt(437)*y(152)
         mat(328) = rxt(437)*y(2) + .900_r8*rxt(449)*y(157)
         mat(409) = .800_r8*rxt(447)*y(157)
         mat(417) = .900_r8*rxt(449)*y(152) + .800_r8*rxt(447)*y(156)

         mat(421) = -(rxt(447)*y(156) + rxt(448)*y(153) + rxt(449)*y(152))
         mat(411) = -rxt(447)*y(157)
         mat(403) = -rxt(448)*y(157)
         mat(333) = -rxt(449)*y(157)

         mat(592) = -(rxt(313)*y(133) + rxt(314)*y(1) + rxt(315)*y(8))
         mat(1214) = -rxt(313)*y(48)
         mat(1026) = -rxt(314)*y(48)
         mat(1260) = -rxt(315)*y(48)

         mat(1026) = mat(1026) + .070_r8*rxt(360)*y(65)
         mat(493) = .070_r8*rxt(360)*y(1)

         mat(491) = -(rxt(359)*y(133) + rxt(360)*y(1) + rxt(361)*y(8))
         mat(1205) = -rxt(359)*y(65)
         mat(1021) = -rxt(360)*y(65)
         mat(1254) = -rxt(361)*y(65)

         mat(447) = -(rxt(321)*y(6) + rxt(322)*y(134))
         mat(1075) = -rxt(321)*y(141)
         mat(1389) = -rxt(322)*y(141)

         mat(1201) = rxt(313)*y(48) + .500_r8*rxt(323)*y(52)
         mat(591) = rxt(313)*y(133)
         mat(285) = .500_r8*rxt(323)*y(133)

         mat(612) = -(rxt(300)*y(133) + rxt(301)*y(8))
         mat(1216) = -rxt(300)*y(41)
         mat(1262) = -rxt(301)*y(41)

         mat(1028) = .500_r8*rxt(314)*y(48) + .040_r8*rxt(336)*y(60)
         mat(1084) = rxt(321)*y(141) + rxt(334)*y(143) + .400_r8*rxt(375)*y(147) &
                      + rxt(338)*y(144) + rxt(295)*y(136) + .270_r8*rxt(316)*y(140)
         mat(1216) = mat(1216) + .500_r8*rxt(299)*y(39) + rxt(310)*y(42)
         mat(866) = .800_r8*rxt(297)*y(136)
         mat(594) = .500_r8*rxt(314)*y(1)
         mat(448) = rxt(321)*y(6)
         mat(114) = rxt(334)*y(6)
         mat(370) = .400_r8*rxt(375)*y(6)
         mat(353) = rxt(338)*y(6)
         mat(741) = .040_r8*rxt(336)*y(1)
         mat(482) = rxt(295)*y(6) + .800_r8*rxt(297)*y(13) + 3.200_r8*rxt(298)*y(136)
         mat(131) = .500_r8*rxt(299)*y(133)
         mat(523) = .270_r8*rxt(316)*y(6)
         mat(80) = rxt(310)*y(133)

         mat(310) = -(rxt(294)*y(133))
         mat(1191) = -rxt(294)*y(40)

         mat(1018) = .250_r8*rxt(314)*y(48) + .200_r8*rxt(360)*y(65)
         mat(859) = .100_r8*rxt(305)*y(137)
         mat(1380) = .250_r8*rxt(304)*y(137) + .250_r8*rxt(352)*y(145)
         mat(590) = .250_r8*rxt(314)*y(1)
         mat(490) = .200_r8*rxt(360)*y(1)
         mat(782) = .100_r8*rxt(305)*y(13) + .250_r8*rxt(304)*y(134)
         mat(762) = .250_r8*rxt(352)*y(134)

         mat(284) = -(rxt(323)*y(133))
         mat(1188) = -rxt(323)*y(52)

         mat(1379) = rxt(322)*y(141)
         mat(446) = rxt(322)*y(134)

         mat(794) = -(rxt(302)*y(6) + rxt(303)*y(7) + rxt(304)*y(134) + rxt(305)*y(13) &
                      + 4._r8*rxt(306)*y(137) + rxt(348)*y(146) + rxt(367)*y(148) &
                      + rxt(382)*y(149))
         mat(1094) = -rxt(302)*y(137)
         mat(1129) = -rxt(303)*y(137)
         mat(1410) = -rxt(304)*y(137)
         mat(876) = -rxt(305)*y(137)
         mat(728) = -rxt(348)*y(137)
         mat(706) = -rxt(367)*y(137)
         mat(683) = -rxt(382)*y(137)

         mat(1094) = mat(1094) + rxt(338)*y(144) + .530_r8*rxt(343)*y(146) + rxt(350) &
                      *y(145) + rxt(325)*y(142)
         mat(1227) = rxt(300)*y(41) + .500_r8*rxt(307)*y(45) + rxt(330)*y(54)
         mat(1272) = rxt(301)*y(41) + .530_r8*rxt(345)*y(146) + rxt(351)*y(145) &
                      + rxt(331)*y(54)
         mat(876) = mat(876) + .260_r8*rxt(347)*y(146) + rxt(353)*y(145) &
                      + .300_r8*rxt(327)*y(142)
         mat(613) = rxt(300)*y(133) + rxt(301)*y(8)
         mat(794) = mat(794) + .530_r8*rxt(348)*y(146)
         mat(227) = .500_r8*rxt(307)*y(133)
         mat(354) = rxt(338)*y(6)
         mat(728) = mat(728) + .530_r8*rxt(343)*y(6) + .530_r8*rxt(345)*y(8) &
                      + .260_r8*rxt(347)*y(13) + .530_r8*rxt(348)*y(137)
         mat(766) = rxt(350)*y(6) + rxt(351)*y(8) + rxt(353)*y(13) + 4.000_r8*rxt(355) &
                      *y(145)
         mat(632) = rxt(325)*y(6) + .300_r8*rxt(327)*y(13)
         mat(668) = rxt(330)*y(133) + rxt(331)*y(8)

         mat(226) = -(rxt(307)*y(133))
         mat(1181) = -rxt(307)*y(45)

         mat(1374) = .750_r8*rxt(304)*y(137) + .750_r8*rxt(352)*y(145)
         mat(781) = .750_r8*rxt(304)*y(134)
         mat(760) = .750_r8*rxt(352)*y(134)

         mat(205) = -(rxt(312)*y(133))
         mat(1179) = -rxt(312)*y(47)

         mat(1115) = rxt(303)*y(137)
         mat(780) = rxt(303)*y(7)

         mat(154) = -(rxt(332)*y(133))
         mat(1172) = -rxt(332)*y(64)

         mat(1060) = .100_r8*rxt(375)*y(147)
         mat(1251) = rxt(315)*y(48)
         mat(589) = rxt(315)*y(8)
         mat(363) = .100_r8*rxt(375)*y(6)

         mat(88) = -(rxt(285)*y(131) + rxt(287)*y(133))
         mat(1431) = -rxt(285)*y(38)
         mat(1162) = -rxt(287)*y(38)

         mat(293) = -(rxt(284)*y(131) + rxt(288)*y(133) + rxt(293)*y(1))
         mat(1434) = -rxt(284)*y(37)
         mat(1189) = -rxt(288)*y(37)
         mat(1016) = -rxt(293)*y(37)

         mat(24) = -(rxt(371)*y(133))
         mat(1150) = -rxt(371)*y(57)

         mat(264) = -(rxt(358)*y(133))
         mat(1185) = -rxt(358)*y(63)

         mat(1119) = rxt(356)*y(145)
         mat(761) = rxt(356)*y(7)

         mat(27) = -(rxt(333)*y(133))
         mat(1151) = -rxt(333)*y(56)

         mat(112) = -(rxt(334)*y(6))
         mat(1058) = -rxt(334)*y(143)

         mat(1165) = rxt(333)*y(56)
         mat(28) = rxt(333)*y(133)

         mat(367) = -(rxt(375)*y(6) + rxt(376)*y(134))
         mat(1069) = -rxt(375)*y(147)
         mat(1385) = -rxt(376)*y(147)

         mat(1196) = rxt(371)*y(57) + rxt(377)*y(66)
         mat(25) = rxt(371)*y(133)
         mat(343) = rxt(377)*y(133)

         mat(341) = -(rxt(377)*y(133))
         mat(1193) = -rxt(377)*y(66)

         mat(1382) = rxt(376)*y(147)
         mat(365) = rxt(376)*y(134)

         mat(188) = -(rxt(337)*y(133))
         mat(1177) = -rxt(337)*y(58)

         mat(1062) = .800_r8*rxt(375)*y(147)
         mat(364) = .800_r8*rxt(375)*y(6)

         mat(352) = -(rxt(338)*y(6) + rxt(339)*y(134))
         mat(1067) = -rxt(338)*y(144)
         mat(1383) = -rxt(339)*y(144)

         mat(1194) = rxt(337)*y(58) + rxt(340)*y(59)
         mat(189) = rxt(337)*y(133)
         mat(120) = rxt(340)*y(133)

         mat(119) = -(rxt(340)*y(133))
         mat(1166) = -rxt(340)*y(59)

         mat(1362) = rxt(339)*y(144)
         mat(351) = rxt(339)*y(134)

         mat(37) = -(rxt(385)*y(133))
         mat(1154) = -rxt(385)*y(73)

         mat(42) = -(rxt(389)*y(133))
         mat(1155) = -rxt(389)*y(74)

         mat(1155) = mat(1155) + .250_r8*rxt(385)*y(73)
         mat(38) = .250_r8*rxt(385)*y(133)

         mat(238) = -(rxt(386)*y(6) + rxt(387)*y(134))
         mat(1064) = -rxt(386)*y(150)
         mat(1375) = -rxt(387)*y(150)

         mat(1182) = .700_r8*rxt(385)*y(73) + rxt(388)*y(75)
         mat(39) = .700_r8*rxt(385)*y(133)
         mat(159) = rxt(388)*y(133)

         mat(158) = -(rxt(388)*y(133))
         mat(1173) = -rxt(388)*y(75)

         mat(1366) = rxt(387)*y(150)
         mat(237) = rxt(387)*y(134)

         mat(61) = -(rxt(390)*y(7))
         mat(1113) = -rxt(390)*y(76)

         mat(1157) = rxt(389)*y(74)
         mat(43) = rxt(389)*y(133)

         mat(545) = -(rxt(394)*y(6) + rxt(395)*y(134))
         mat(1081) = -rxt(394)*y(151)
         mat(1396) = -rxt(395)*y(151)

         mat(1210) = rxt(396)*y(78) + rxt(391)*y(77)
         mat(1257) = rxt(393)*y(77)
         mat(200) = rxt(396)*y(133)
         mat(302) = rxt(391)*y(133) + rxt(393)*y(8)

         mat(198) = -(rxt(396)*y(133))
         mat(1178) = -rxt(396)*y(78)

         mat(1372) = rxt(395)*y(151)
         mat(543) = rxt(395)*y(134)


         mat(1065) = .900_r8*rxt(386)*y(150)
         mat(1117) = .700_r8*rxt(390)*y(76)
         mat(239) = .900_r8*rxt(386)*y(6)
         mat(62) = .700_r8*rxt(390)*y(7)

         mat(359) = -(rxt(309)*y(133))
         mat(1195) = -rxt(309)*y(44)

         mat(1068) = .450_r8*rxt(386)*y(150) + .250_r8*rxt(378)*y(149)
         mat(1195) = mat(1195) + .200_r8*rxt(308)*y(43) + .650_r8*rxt(286)*y(98)
         mat(1253) = .250_r8*rxt(379)*y(149)
         mat(860) = .100_r8*rxt(381)*y(149)
         mat(783) = .250_r8*rxt(382)*y(149)
         mat(240) = .450_r8*rxt(386)*y(6)
         mat(514) = .200_r8*rxt(308)*y(133)
         mat(677) = .250_r8*rxt(378)*y(6) + .250_r8*rxt(379)*y(8) + .100_r8*rxt(381) &
                      *y(13) + .250_r8*rxt(382)*y(137)
         mat(96) = .650_r8*rxt(286)*y(133)

         mat(702) = -(rxt(362)*y(6) + rxt(363)*y(8) + rxt(364)*y(134) + rxt(366)*y(13) &
                      + rxt(367)*y(137))
         mat(1090) = -rxt(362)*y(148)
         mat(1268) = -rxt(363)*y(148)
         mat(1406) = -rxt(364)*y(148)
         mat(872) = -rxt(366)*y(148)
         mat(790) = -rxt(367)*y(148)

         mat(1223) = rxt(359)*y(65) + .200_r8*rxt(365)*y(72)
         mat(496) = rxt(359)*y(133)
         mat(275) = .200_r8*rxt(365)*y(133)


      end subroutine nlnmat05

      subroutine nlnmat06( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(745) = -(rxt(335)*y(133) + rxt(336)*y(1))
         mat(1225) = -rxt(335)*y(60)
         mat(1036) = -rxt(336)*y(60)

         mat(1036) = mat(1036) + .200_r8*rxt(360)*y(65) + rxt(392)*y(77)
         mat(1092) = rxt(394)*y(151) + .320_r8*rxt(362)*y(148) + .039_r8*rxt(368) &
                      *y(69)
         mat(1270) = .350_r8*rxt(363)*y(148) + .039_r8*rxt(369)*y(69)
         mat(874) = .260_r8*rxt(366)*y(148)
         mat(1408) = .039_r8*rxt(370)*y(69)
         mat(497) = .200_r8*rxt(360)*y(1)
         mat(792) = .350_r8*rxt(367)*y(148)
         mat(548) = rxt(394)*y(6)
         mat(704) = .320_r8*rxt(362)*y(6) + .350_r8*rxt(363)*y(8) + .260_r8*rxt(366) &
                      *y(13) + .350_r8*rxt(367)*y(137)
         mat(304) = rxt(392)*y(1)
         mat(581) = .039_r8*rxt(368)*y(6) + .039_r8*rxt(369)*y(8) + .039_r8*rxt(370) &
                      *y(134)

         mat(642) = -(rxt(341)*y(133) + rxt(342)*y(1))
         mat(1219) = -rxt(341)*y(61)
         mat(1031) = -rxt(342)*y(61)

         mat(1031) = mat(1031) + .400_r8*rxt(360)*y(65) + rxt(392)*y(77)
         mat(1087) = rxt(394)*y(151) + .230_r8*rxt(362)*y(148) + .167_r8*rxt(368) &
                      *y(69)
         mat(1265) = .250_r8*rxt(363)*y(148) + .167_r8*rxt(369)*y(69)
         mat(869) = .190_r8*rxt(366)*y(148)
         mat(1402) = .167_r8*rxt(370)*y(69)
         mat(495) = .400_r8*rxt(360)*y(1)
         mat(787) = .250_r8*rxt(367)*y(148)
         mat(547) = rxt(394)*y(6)
         mat(699) = .230_r8*rxt(362)*y(6) + .250_r8*rxt(363)*y(8) + .190_r8*rxt(366) &
                      *y(13) + .250_r8*rxt(367)*y(137)
         mat(303) = rxt(392)*y(1)
         mat(579) = .167_r8*rxt(368)*y(6) + .167_r8*rxt(369)*y(8) + .167_r8*rxt(370) &
                      *y(134)

         mat(726) = -((rxt(343) + rxt(344)) * y(6) + rxt(345)*y(8) + rxt(346)*y(134) &
                      + rxt(347)*y(13) + rxt(348)*y(137))
         mat(1091) = -(rxt(343) + rxt(344)) * y(146)
         mat(1269) = -rxt(345)*y(146)
         mat(1407) = -rxt(346)*y(146)
         mat(873) = -rxt(347)*y(146)
         mat(791) = -rxt(348)*y(146)

         mat(1224) = rxt(335)*y(60) + .500_r8*rxt(341)*y(61) + .200_r8*rxt(349)*y(62)
         mat(744) = rxt(335)*y(133)
         mat(644) = .500_r8*rxt(341)*y(133)
         mat(125) = .200_r8*rxt(349)*y(133)

         mat(124) = -(rxt(349)*y(133))
         mat(1167) = -rxt(349)*y(62)

         mat(1363) = rxt(346)*y(146)
         mat(718) = rxt(346)*y(134)

         mat(765) = -(rxt(350)*y(6) + rxt(351)*y(8) + rxt(352)*y(134) + rxt(353)*y(13) &
                      + rxt(354)*y(137) + 4._r8*rxt(355)*y(145) + rxt(356)*y(7))
         mat(1093) = -rxt(350)*y(145)
         mat(1271) = -rxt(351)*y(145)
         mat(1409) = -rxt(352)*y(145)
         mat(875) = -rxt(353)*y(145)
         mat(793) = -rxt(354)*y(145)
         mat(1128) = -rxt(356)*y(145)

         mat(1037) = .200_r8*rxt(360)*y(65)
         mat(1226) = .500_r8*rxt(341)*y(61) + .500_r8*rxt(349)*y(62)
         mat(498) = .200_r8*rxt(360)*y(1)
         mat(645) = .500_r8*rxt(341)*y(133)
         mat(126) = .500_r8*rxt(349)*y(133)

         mat(481) = -(rxt(295)*y(6) + rxt(296)*y(134) + rxt(297)*y(13) + 4._r8*rxt(298) &
                      *y(136))
         mat(1077) = -rxt(295)*y(136)
         mat(1391) = -rxt(296)*y(136)
         mat(862) = -rxt(297)*y(136)

         mat(1204) = rxt(287)*y(38) + .500_r8*rxt(299)*y(39)
         mat(1438) = rxt(285)*y(38)
         mat(89) = rxt(287)*y(133) + rxt(285)*y(131)
         mat(130) = .500_r8*rxt(299)*y(133)

         mat(129) = -(rxt(299)*y(133))
         mat(1168) = -rxt(299)*y(39)

         mat(1364) = rxt(296)*y(136)
         mat(479) = rxt(296)*y(134)

         mat(301) = -(rxt(391)*y(133) + rxt(392)*y(1) + rxt(393)*y(8))
         mat(1190) = -rxt(391)*y(77)
         mat(1017) = -rxt(392)*y(77)
         mat(1252) = -rxt(393)*y(77)

         mat(33) = -(rxt(320)*y(133))
         mat(1153) = -rxt(320)*y(49)

         mat(522) = -(rxt(316)*y(6) + rxt(317)*y(134) + rxt(318)*y(13))
         mat(1079) = -rxt(316)*y(140)
         mat(1394) = -rxt(317)*y(140)
         mat(864) = -rxt(318)*y(140)

         mat(1208) = rxt(320)*y(49) + rxt(319)*y(50)
         mat(34) = rxt(320)*y(133)
         mat(166) = rxt(319)*y(133)

         mat(164) = -(rxt(319)*y(133))
         mat(1174) = -rxt(319)*y(50)

         mat(1367) = rxt(317)*y(140)
         mat(520) = rxt(317)*y(134)

         mat(378) = -(rxt(324)*y(133))
         mat(1197) = -rxt(324)*y(51)

         mat(1070) = .500_r8*rxt(334)*y(143) + .250_r8*rxt(375)*y(147) &
                      + .100_r8*rxt(394)*y(151) + .820_r8*rxt(316)*y(140)
         mat(861) = .820_r8*rxt(318)*y(140)
         mat(113) = .500_r8*rxt(334)*y(6)
         mat(368) = .250_r8*rxt(375)*y(6)
         mat(544) = .100_r8*rxt(394)*y(6)
         mat(521) = .820_r8*rxt(316)*y(6) + .820_r8*rxt(318)*y(13)

         mat(170) = -(rxt(328)*y(133))
         mat(1175) = -rxt(328)*y(55)

         mat(1368) = rxt(326)*y(142)
         mat(627) = rxt(326)*y(134)

         mat(252) = -(rxt(277)*y(133))
         mat(1184) = -rxt(277)*y(15)

         mat(858) = 2.000_r8*rxt(276)*y(13) + .250_r8*rxt(366)*y(148) &
                      + .250_r8*rxt(347)*y(146) + .300_r8*rxt(297)*y(136) &
                      + .500_r8*rxt(327)*y(142) + .300_r8*rxt(381)*y(149)
         mat(695) = .250_r8*rxt(366)*y(13)
         mat(719) = .250_r8*rxt(347)*y(13)
         mat(480) = .300_r8*rxt(297)*y(13)
         mat(628) = .500_r8*rxt(327)*y(13)
         mat(676) = .300_r8*rxt(381)*y(13)

         mat(79) = -(rxt(310)*y(133))
         mat(1160) = -rxt(310)*y(42)

         mat(855) = .200_r8*rxt(297)*y(136)
         mat(478) = .200_r8*rxt(297)*y(13) + .800_r8*rxt(298)*y(136)

         mat(515) = -(rxt(308)*y(133))
         mat(1207) = -rxt(308)*y(43)

         mat(903) = rxt(291)*y(139)
         mat(1078) = .530_r8*rxt(343)*y(146) + .250_r8*rxt(378)*y(149)
         mat(1255) = .530_r8*rxt(345)*y(146) + .250_r8*rxt(379)*y(149)
         mat(863) = .260_r8*rxt(347)*y(146) + .100_r8*rxt(381)*y(149)
         mat(784) = .530_r8*rxt(348)*y(146) + .250_r8*rxt(382)*y(149)
         mat(720) = .530_r8*rxt(343)*y(6) + .530_r8*rxt(345)*y(8) + .260_r8*rxt(347) &
                      *y(13) + .530_r8*rxt(348)*y(137)
         mat(194) = rxt(291)*y(3)
         mat(678) = .250_r8*rxt(378)*y(6) + .250_r8*rxt(379)*y(8) + .100_r8*rxt(381) &
                      *y(13) + .250_r8*rxt(382)*y(137)

         mat(621) = -(rxt(329)*y(133))
         mat(1217) = -rxt(329)*y(53)

         mat(1085) = .220_r8*rxt(343)*y(146) + .250_r8*rxt(378)*y(149)
         mat(1217) = mat(1217) + .500_r8*rxt(323)*y(52) + .500_r8*rxt(358)*y(63)
         mat(1263) = .220_r8*rxt(345)*y(146) + .250_r8*rxt(379)*y(149)
         mat(867) = .230_r8*rxt(347)*y(146) + .200_r8*rxt(327)*y(142) &
                      + .100_r8*rxt(381)*y(149)
         mat(287) = .500_r8*rxt(323)*y(133)
         mat(786) = .220_r8*rxt(348)*y(146) + .250_r8*rxt(382)*y(149)
         mat(265) = .500_r8*rxt(358)*y(133)
         mat(723) = .220_r8*rxt(343)*y(6) + .220_r8*rxt(345)*y(8) + .230_r8*rxt(347) &
                      *y(13) + .220_r8*rxt(348)*y(137)
         mat(629) = .200_r8*rxt(327)*y(13)
         mat(680) = .250_r8*rxt(378)*y(6) + .250_r8*rxt(379)*y(8) + .100_r8*rxt(381) &
                      *y(13) + .250_r8*rxt(382)*y(137)

         mat(393) = -(rxt(289)*y(6) + rxt(290)*y(134))
         mat(1071) = -rxt(289)*y(138)
         mat(1387) = -rxt(290)*y(138)

         mat(1199) = rxt(288)*y(37)
         mat(294) = rxt(288)*y(133)

         mat(193) = -(rxt(291)*y(3))
         mat(893) = -rxt(291)*y(139)

         mat(1063) = .750_r8*rxt(289)*y(138)
         mat(392) = .750_r8*rxt(289)*y(6)


         mat(1361) = rxt(290)*y(138)
         mat(391) = rxt(290)*y(134)

         mat(143) = -(rxt(374)*y(133))
         mat(1170) = -rxt(374)*y(68)

         mat(1059) = .370_r8*rxt(362)*y(148)
         mat(1170) = mat(1170) + rxt(372)*y(70)
         mat(1250) = .400_r8*rxt(363)*y(148) + rxt(373)*y(70)
         mat(856) = .300_r8*rxt(366)*y(148)
         mat(779) = .400_r8*rxt(367)*y(148)
         mat(694) = .370_r8*rxt(362)*y(6) + .400_r8*rxt(363)*y(8) + .300_r8*rxt(366) &
                      *y(13) + .400_r8*rxt(367)*y(137)
         mat(534) = rxt(372)*y(133) + rxt(373)*y(8)

         mat(630) = -(rxt(325)*y(6) + rxt(326)*y(134) + rxt(327)*y(13))
         mat(1086) = -rxt(325)*y(142)
         mat(1401) = -rxt(326)*y(142)
         mat(868) = -rxt(327)*y(142)

         mat(1218) = rxt(324)*y(51) + rxt(328)*y(55)
         mat(379) = rxt(324)*y(133)
         mat(171) = rxt(328)*y(133)

         mat(667) = -(rxt(330)*y(133) + rxt(331)*y(8))
         mat(1221) = -rxt(330)*y(54)
         mat(1266) = -rxt(331)*y(54)

         mat(1032) = .950_r8*rxt(336)*y(60) + .800_r8*rxt(342)*y(61)
         mat(1088) = .450_r8*rxt(386)*y(150) + .250_r8*rxt(343)*y(146) &
                      + .250_r8*rxt(378)*y(149)
         mat(1221) = mat(1221) + rxt(332)*y(64) + rxt(329)*y(53)
         mat(1266) = mat(1266) + .250_r8*rxt(345)*y(146) + .250_r8*rxt(379)*y(149)
         mat(870) = .240_r8*rxt(347)*y(146) + .500_r8*rxt(327)*y(142) &
                      + .100_r8*rxt(381)*y(149)
         mat(788) = .250_r8*rxt(348)*y(146) + .250_r8*rxt(382)*y(149)
         mat(155) = rxt(332)*y(133)
         mat(241) = .450_r8*rxt(386)*y(6)
         mat(743) = .950_r8*rxt(336)*y(1)
         mat(643) = .800_r8*rxt(342)*y(1)
         mat(724) = .250_r8*rxt(343)*y(6) + .250_r8*rxt(345)*y(8) + .240_r8*rxt(347) &
                      *y(13) + .250_r8*rxt(348)*y(137)
         mat(622) = rxt(329)*y(133)
         mat(631) = .500_r8*rxt(327)*y(13)
         mat(681) = .250_r8*rxt(378)*y(6) + .250_r8*rxt(379)*y(8) + .100_r8*rxt(381) &
                      *y(13) + .250_r8*rxt(382)*y(137)

         mat(577) = -(rxt(368)*y(6) + rxt(369)*y(8) + rxt(370)*y(134))
         mat(1082) = -rxt(368)*y(69)
         mat(1259) = -rxt(369)*y(69)
         mat(1397) = -rxt(370)*y(69)

         mat(1259) = mat(1259) + rxt(361)*y(65)
         mat(492) = rxt(361)*y(8)


      end subroutine nlnmat06

      subroutine nlnmat07( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(535) = -(rxt(372)*y(133) + rxt(373)*y(8))
         mat(1209) = -rxt(372)*y(70)
         mat(1256) = -rxt(373)*y(70)

         mat(1080) = .080_r8*rxt(362)*y(148) + .800_r8*rxt(344)*y(146) &
                      + .794_r8*rxt(368)*y(69)
         mat(1256) = mat(1256) + .794_r8*rxt(369)*y(69)
         mat(1395) = .794_r8*rxt(370)*y(69)
         mat(697) = .080_r8*rxt(362)*y(6)
         mat(721) = .800_r8*rxt(344)*y(6)
         mat(576) = .794_r8*rxt(368)*y(6) + .794_r8*rxt(369)*y(8) + .794_r8*rxt(370) &
                      *y(134)

         mat(682) = -(rxt(378)*y(6) + rxt(379)*y(8) + rxt(380)*y(134) + rxt(381)*y(13) &
                      + rxt(382)*y(137))
         mat(1089) = -rxt(378)*y(149)
         mat(1267) = -rxt(379)*y(149)
         mat(1405) = -rxt(380)*y(149)
         mat(871) = -rxt(381)*y(149)
         mat(789) = -rxt(382)*y(149)

         mat(1222) = rxt(374)*y(68) + rxt(383)*y(71) + .800_r8*rxt(365)*y(72)
         mat(144) = rxt(374)*y(133)
         mat(135) = rxt(383)*y(133)
         mat(274) = .800_r8*rxt(365)*y(133)

         mat(134) = -((rxt(383) + rxt(384)) * y(133))
         mat(1169) = -(rxt(383) + rxt(384)) * y(71)

         mat(1365) = rxt(370)*y(69) + rxt(380)*y(149)
         mat(575) = rxt(370)*y(134)
         mat(675) = rxt(380)*y(134)

         mat(272) = -(rxt(365)*y(133))
         mat(1186) = -rxt(365)*y(72)

         mat(1377) = rxt(364)*y(148)
         mat(696) = rxt(364)*y(134)

         mat(94) = -(rxt(283)*y(131) + rxt(286)*y(133))
         mat(1432) = -rxt(283)*y(98)
         mat(1163) = -rxt(286)*y(98)

         mat(280) = -(rxt(279)*y(133))
         mat(1187) = -rxt(279)*y(99)

         mat(1015) = .500_r8*rxt(293)*y(37)
         mat(1066) = rxt(281)*y(135)
         mat(1187) = mat(1187) + .350_r8*rxt(286)*y(98)
         mat(1378) = rxt(282)*y(135)
         mat(292) = .500_r8*rxt(293)*y(1)
         mat(95) = .350_r8*rxt(286)*y(133)
         mat(177) = rxt(281)*y(6) + rxt(282)*y(134)

         mat(176) = -(rxt(281)*y(6) + rxt(282)*y(134))
         mat(1061) = -rxt(281)*y(135)
         mat(1369) = -rxt(282)*y(135)

         mat(963) = rxt(272)*y(134)
         mat(1369) = mat(1369) + rxt(272)*y(16)

         mat(48) = -(rxt(154)*y(161))
         mat(1489) = -rxt(154)*y(100)

         mat(65) = -(rxt(155)*y(161))
         mat(1491) = -rxt(155)*y(101)


         mat(653) = rxt(251)*y(103)
         mat(1292) = rxt(253)*y(103)
         mat(988) = rxt(250)*y(103)
         mat(437) = rxt(251)*y(18) + rxt(253)*y(9) + rxt(250)*y(162)

         mat(438) = -(rxt(250)*y(162) + rxt(251)*y(18) + rxt(253)*y(9))
         mat(990) = -rxt(250)*y(103)
         mat(654) = -rxt(251)*y(103)
         mat(1293) = -rxt(253)*y(103)

         mat(1493) = 2.000_r8*rxt(154)*y(100) + rxt(155)*y(101)
         mat(49) = 2.000_r8*rxt(154)*y(161)
         mat(66) = rxt(155)*y(161)

         mat(557) = -(rxt(413)*y(133))
         mat(1211) = -rxt(413)*y(104)

         mat(1024) = rxt(408)*y(108)
         mat(904) = rxt(407)*y(108)
         mat(1123) = rxt(409)*y(108)
         mat(1211) = mat(1211) + (rxt(415)+.500_r8*rxt(416))*y(105) + rxt(402)*y(106) &
                      + rxt(406)*y(108)
         mat(1258) = rxt(417)*y(105)
         mat(1319) = rxt(410)*y(108)
         mat(139) = rxt(412)*y(108)
         mat(1469) = rxt(411)*y(108)
         mat(101) = (rxt(415)+.500_r8*rxt(416))*y(133) + rxt(417)*y(8)
         mat(148) = rxt(402)*y(133)
         mat(809) = rxt(408)*y(1) + rxt(407)*y(3) + rxt(409)*y(7) + rxt(406)*y(133) &
                      + rxt(410)*y(24) + rxt(412)*y(25) + rxt(411)*y(31)

         mat(100) = -((rxt(415) + rxt(416)) * y(133) + rxt(417)*y(8))
         mat(1164) = -(rxt(415) + rxt(416)) * y(105)
         mat(1248) = -rxt(417)*y(105)

         mat(146) = -(rxt(401)*y(2) + rxt(402)*y(133))
         mat(924) = -rxt(401)*y(106)
         mat(1171) = -rxt(402)*y(106)

         mat(384) = -(rxt(403)*y(133) + rxt(404)*y(3) + rxt(405)*y(1))
         mat(1198) = -rxt(403)*y(107)
         mat(898) = -rxt(404)*y(107)
         mat(1019) = -rxt(405)*y(107)

         mat(810) = -(rxt(406)*y(133) + rxt(407)*y(3) + rxt(408)*y(1) + rxt(409)*y(7) &
                      + rxt(410)*y(24) + rxt(411)*y(31) + rxt(412)*y(25))
         mat(1228) = -rxt(406)*y(108)
         mat(906) = -rxt(407)*y(108)
         mat(1039) = -rxt(408)*y(108)
         mat(1130) = -rxt(409)*y(108)
         mat(1321) = -rxt(410)*y(108)
         mat(1470) = -rxt(411)*y(108)
         mat(140) = -rxt(412)*y(108)

         mat(1039) = mat(1039) + rxt(405)*y(107)
         mat(943) = rxt(401)*y(106)
         mat(906) = mat(906) + rxt(404)*y(107)
         mat(1228) = mat(1228) + rxt(403)*y(107)
         mat(150) = rxt(401)*y(2)
         mat(385) = rxt(405)*y(1) + rxt(404)*y(3) + rxt(403)*y(133)

         mat(84) = -(rxt(414)*y(162))
         mat(989) = -rxt(414)*y(109)

         mat(1161) = rxt(413)*y(104)
         mat(556) = rxt(413)*y(133)


         mat(987) = rxt(414)*y(109)
         mat(83) = rxt(414)*y(162)
      end subroutine nlnmat07
      subroutine nlnmat_finit( mat, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(inout) :: mat(nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
         mat( 1) = lmat( 1)
         mat( 2) = lmat( 2)
         mat( 3) = lmat( 3)
         mat( 4) = lmat( 4)
         mat( 5) = lmat( 5)
         mat( 6) = lmat( 6)
         mat( 7) = lmat( 7)
         mat( 8) = lmat( 8)
         mat( 9) = lmat( 9)
         mat( 10) = lmat( 10)
         mat( 11) = lmat( 11)
         mat( 12) = lmat( 12)
         mat( 13) = lmat( 13)
         mat( 14) = lmat( 14)
         mat( 15) = lmat( 15)
         mat( 16) = lmat( 16)
         mat( 17) = lmat( 17)
         mat( 18) = lmat( 18)
         mat( 19) = lmat( 19)
         mat( 20) = lmat( 20)
         mat( 21) = lmat( 21)
         mat( 22) = lmat( 22)
         mat( 23) = lmat( 23)
         mat( 24) = mat( 24) + lmat( 24)
         mat( 27) = mat( 27) + lmat( 27)
         mat( 30) = mat( 30) + lmat( 30)
         mat( 33) = mat( 33) + lmat( 33)
         mat( 37) = mat( 37) + lmat( 37)
         mat( 42) = mat( 42) + lmat( 42)
         mat( 45) = lmat( 45)
         mat( 46) = lmat( 46)
         mat( 47) = lmat( 47)
         mat( 48) = mat( 48) + lmat( 48)
         mat( 49) = mat( 49) + lmat( 49)
         mat( 51) = lmat( 51)
         mat( 52) = lmat( 52)
         mat( 53) = lmat( 53)
         mat( 54) = mat( 54) + lmat( 54)
         mat( 55) = mat( 55) + lmat( 55)
         mat( 56) = mat( 56) + lmat( 56)
         mat( 57) = mat( 57) + lmat( 57)
         mat( 58) = lmat( 58)
         mat( 59) = lmat( 59)
         mat( 60) = lmat( 60)
         mat( 61) = mat( 61) + lmat( 61)
         mat( 65) = mat( 65) + lmat( 65)
         mat( 66) = mat( 66) + lmat( 66)
         mat( 67) = mat( 67) + lmat( 67)
         mat( 69) = mat( 69) + lmat( 69)
         mat( 73) = lmat( 73)
         mat( 74) = lmat( 74)
         mat( 75) = lmat( 75)
         mat( 76) = lmat( 76)
         mat( 77) = lmat( 77)
         mat( 78) = lmat( 78)
         mat( 79) = mat( 79) + lmat( 79)
         mat( 84) = mat( 84) + lmat( 84)
         mat( 85) = lmat( 85)
         mat( 86) = lmat( 86)
         mat( 88) = mat( 88) + lmat( 88)
         mat( 94) = mat( 94) + lmat( 94)
         mat( 100) = mat( 100) + lmat( 100)
         mat( 106) = lmat( 106)
         mat( 107) = lmat( 107)
         mat( 108) = lmat( 108)
         mat( 109) = lmat( 109)
         mat( 110) = lmat( 110)
         mat( 111) = lmat( 111)
         mat( 112) = mat( 112) + lmat( 112)
         mat( 119) = mat( 119) + lmat( 119)
         mat( 121) = lmat( 121)
         mat( 122) = lmat( 122)
         mat( 123) = mat( 123) + lmat( 123)
         mat( 124) = mat( 124) + lmat( 124)
         mat( 129) = mat( 129) + lmat( 129)
         mat( 131) = mat( 131) + lmat( 131)
         mat( 132) = mat( 132) + lmat( 132)
         mat( 133) = lmat( 133)
         mat( 134) = mat( 134) + lmat( 134)
         mat( 137) = mat( 137) + lmat( 137)
         mat( 138) = mat( 138) + lmat( 138)
         mat( 141) = lmat( 141)
         mat( 142) = mat( 142) + lmat( 142)
         mat( 143) = mat( 143) + lmat( 143)
         mat( 146) = mat( 146) + lmat( 146)
         mat( 147) = lmat( 147)
         mat( 149) = mat( 149) + lmat( 149)
         mat( 154) = mat( 154) + lmat( 154)
         mat( 158) = mat( 158) + lmat( 158)
         mat( 160) = lmat( 160)
         mat( 161) = lmat( 161)
         mat( 162) = lmat( 162)
         mat( 163) = mat( 163) + lmat( 163)
         mat( 164) = mat( 164) + lmat( 164)
         mat( 165) = lmat( 165)
         mat( 168) = mat( 168) + lmat( 168)
         mat( 169) = lmat( 169)
         mat( 170) = mat( 170) + lmat( 170)
         mat( 172) = lmat( 172)
         mat( 173) = lmat( 173)
         mat( 175) = mat( 175) + lmat( 175)
         mat( 176) = mat( 176) + lmat( 176)
         mat( 178) = lmat( 178)
         mat( 181) = mat( 181) + lmat( 181)
         mat( 182) = mat( 182) + lmat( 182)
         mat( 184) = mat( 184) + lmat( 184)
         mat( 186) = mat( 186) + lmat( 186)
         mat( 187) = lmat( 187)
         mat( 188) = mat( 188) + lmat( 188)
         mat( 190) = lmat( 190)
         mat( 191) = lmat( 191)
         mat( 193) = mat( 193) + lmat( 193)
         mat( 196) = lmat( 196)
         mat( 197) = mat( 197) + lmat( 197)
         mat( 198) = mat( 198) + lmat( 198)
         mat( 199) = lmat( 199)
         mat( 201) = lmat( 201)
         mat( 202) = lmat( 202)
         mat( 203) = mat( 203) + lmat( 203)
         mat( 204) = lmat( 204)
         mat( 205) = mat( 205) + lmat( 205)
         mat( 206) = lmat( 206)
         mat( 207) = lmat( 207)
         mat( 209) = lmat( 209)
         mat( 211) = mat( 211) + lmat( 211)
         mat( 212) = mat( 212) + lmat( 212)
         mat( 219) = mat( 219) + lmat( 219)
         mat( 222) = mat( 222) + lmat( 222)
         mat( 223) = mat( 223) + lmat( 223)
         mat( 224) = lmat( 224)
         mat( 225) = lmat( 225)
         mat( 226) = mat( 226) + lmat( 226)
         mat( 228) = lmat( 228)
         mat( 231) = mat( 231) + lmat( 231)
         mat( 232) = mat( 232) + lmat( 232)
         mat( 238) = mat( 238) + lmat( 238)
         mat( 246) = lmat( 246)
         mat( 247) = lmat( 247)
         mat( 248) = lmat( 248)
         mat( 249) = lmat( 249)
         mat( 250) = lmat( 250)
         mat( 251) = lmat( 251)
         mat( 252) = mat( 252) + lmat( 252)
         mat( 256) = mat( 256) + lmat( 256)
         mat( 257) = lmat( 257)
         mat( 258) = lmat( 258)
         mat( 260) = lmat( 260)
         mat( 261) = mat( 261) + lmat( 261)
         mat( 262) = lmat( 262)
         mat( 263) = mat( 263) + lmat( 263)
         mat( 264) = mat( 264) + lmat( 264)
         mat( 266) = lmat( 266)
         mat( 268) = lmat( 268)
         mat( 272) = mat( 272) + lmat( 272)
         mat( 273) = lmat( 273)
         mat( 276) = lmat( 276)
         mat( 277) = lmat( 277)
         mat( 279) = lmat( 279)
         mat( 280) = mat( 280) + lmat( 280)
         mat( 284) = mat( 284) + lmat( 284)
         mat( 286) = lmat( 286)
         mat( 288) = lmat( 288)
         mat( 290) = mat( 290) + lmat( 290)
         mat( 291) = lmat( 291)
         mat( 293) = mat( 293) + lmat( 293)
         mat( 301) = mat( 301) + lmat( 301)
         mat( 310) = mat( 310) + lmat( 310)
         mat( 314) = mat( 314) + lmat( 314)
         mat( 315) = mat( 315) + lmat( 315)
         mat( 316) = lmat( 316)
         mat( 317) = lmat( 317)
         mat( 318) = lmat( 318)
         mat( 321) = mat( 321) + lmat( 321)
         mat( 325) = mat( 325) + lmat( 325)
         mat( 330) = mat( 330) + lmat( 330)
         mat( 340) = lmat( 340)
         mat( 341) = mat( 341) + lmat( 341)
         mat( 344) = lmat( 344)
         mat( 346) = lmat( 346)
         mat( 348) = lmat( 348)
         mat( 349) = mat( 349) + lmat( 349)
         mat( 350) = lmat( 350)
         mat( 352) = mat( 352) + lmat( 352)
         mat( 359) = mat( 359) + lmat( 359)
         mat( 360) = mat( 360) + lmat( 360)
         mat( 362) = mat( 362) + lmat( 362)
         mat( 367) = mat( 367) + lmat( 367)
         mat( 378) = mat( 378) + lmat( 378)
         mat( 380) = lmat( 380)
         mat( 381) = lmat( 381)
         mat( 384) = mat( 384) + lmat( 384)
         mat( 393) = mat( 393) + lmat( 393)
         mat( 401) = mat( 401) + lmat( 401)
         mat( 402) = mat( 402) + lmat( 402)
         mat( 407) = mat( 407) + lmat( 407)
         mat( 410) = mat( 410) + lmat( 410)
         mat( 421) = mat( 421) + lmat( 421)
         mat( 429) = mat( 429) + lmat( 429)
         mat( 431) = lmat( 431)
         mat( 434) = mat( 434) + lmat( 434)
         mat( 437) = mat( 437) + lmat( 437)
         mat( 438) = mat( 438) + lmat( 438)
         mat( 440) = lmat( 440)
         mat( 447) = mat( 447) + lmat( 447)
         mat( 457) = mat( 457) + lmat( 457)
         mat( 458) = mat( 458) + lmat( 458)
         mat( 462) = lmat( 462)
         mat( 464) = lmat( 464)
         mat( 468) = lmat( 468)
         mat( 469) = mat( 469) + lmat( 469)
         mat( 481) = mat( 481) + lmat( 481)
         mat( 491) = mat( 491) + lmat( 491)
         mat( 507) = mat( 507) + lmat( 507)
         mat( 511) = mat( 511) + lmat( 511)
         mat( 513) = mat( 513) + lmat( 513)
         mat( 515) = mat( 515) + lmat( 515)
         mat( 516) = lmat( 516)
         mat( 517) = mat( 517) + lmat( 517)
         mat( 519) = mat( 519) + lmat( 519)
         mat( 522) = mat( 522) + lmat( 522)
         mat( 535) = mat( 535) + lmat( 535)
         mat( 536) = lmat( 536)
         mat( 538) = lmat( 538)
         mat( 539) = mat( 539) + lmat( 539)
         mat( 542) = mat( 542) + lmat( 542)
         mat( 545) = mat( 545) + lmat( 545)
         mat( 557) = mat( 557) + lmat( 557)
         mat( 558) = lmat( 558)
         mat( 559) = lmat( 559)
         mat( 564) = mat( 564) + lmat( 564)
         mat( 565) = mat( 565) + lmat( 565)
         mat( 569) = lmat( 569)
         mat( 571) = mat( 571) + lmat( 571)
         mat( 572) = mat( 572) + lmat( 572)
         mat( 573) = mat( 573) + lmat( 573)
         mat( 574) = mat( 574) + lmat( 574)
         mat( 577) = mat( 577) + lmat( 577)
         mat( 592) = mat( 592) + lmat( 592)
         mat( 607) = mat( 607) + lmat( 607)
         mat( 611) = lmat( 611)
         mat( 612) = mat( 612) + lmat( 612)
         mat( 614) = lmat( 614)
         mat( 620) = lmat( 620)
         mat( 621) = mat( 621) + lmat( 621)
         mat( 623) = lmat( 623)
         mat( 624) = lmat( 624)
         mat( 626) = mat( 626) + lmat( 626)
         mat( 630) = mat( 630) + lmat( 630)
         mat( 641) = mat( 641) + lmat( 641)
         mat( 642) = mat( 642) + lmat( 642)
         mat( 645) = mat( 645) + lmat( 645)
         mat( 646) = lmat( 646)
         mat( 647) = mat( 647) + lmat( 647)
         mat( 652) = mat( 652) + lmat( 652)
         mat( 655) = mat( 655) + lmat( 655)
         mat( 666) = mat( 666) + lmat( 666)
         mat( 667) = mat( 667) + lmat( 667)
         mat( 668) = mat( 668) + lmat( 668)
         mat( 674) = lmat( 674)
         mat( 682) = mat( 682) + lmat( 682)
         mat( 702) = mat( 702) + lmat( 702)
         mat( 726) = mat( 726) + lmat( 726)
         mat( 739) = lmat( 739)
         mat( 740) = mat( 740) + lmat( 740)
         mat( 745) = mat( 745) + lmat( 745)
         mat( 747) = lmat( 747)
         mat( 748) = lmat( 748)
         mat( 765) = mat( 765) + lmat( 765)
         mat( 794) = mat( 794) + lmat( 794)
         mat( 808) = lmat( 808)
         mat( 810) = mat( 810) + lmat( 810)
         mat( 813) = mat( 813) + lmat( 813)
         mat( 829) = mat( 829) + lmat( 829)
         mat( 838) = lmat( 838)
         mat( 839) = mat( 839) + lmat( 839)
         mat( 844) = mat( 844) + lmat( 844)
         mat( 877) = mat( 877) + lmat( 877)
         mat( 896) = mat( 896) + lmat( 896)
         mat( 899) = mat( 899) + lmat( 899)
         mat( 901) = lmat( 901)
         mat( 908) = mat( 908) + lmat( 908)
         mat( 909) = mat( 909) + lmat( 909)
         mat( 921) = mat( 921) + lmat( 921)
         mat( 928) = mat( 928) + lmat( 928)
         mat( 934) = lmat( 934)
         mat( 948) = mat( 948) + lmat( 948)
         mat( 966) = mat( 966) + lmat( 966)
         mat( 967) = lmat( 967)
         mat( 973) = mat( 973) + lmat( 973)
         mat( 982) = mat( 982) + lmat( 982)
         mat( 992) = lmat( 992)
         mat( 998) = lmat( 998)
         mat(1000) = mat(1000) + lmat(1000)
         mat(1004) = mat(1004) + lmat(1004)
         mat(1008) = lmat(1008)
         mat(1012) = mat(1012) + lmat(1012)
         mat(1013) = mat(1013) + lmat(1013)
         mat(1042) = mat(1042) + lmat(1042)
         mat(1043) = mat(1043) + lmat(1043)
         mat(1046) = mat(1046) + lmat(1046)
         mat(1057) = mat(1057) + lmat(1057)
         mat(1073) = mat(1073) + lmat(1073)
         mat(1074) = lmat(1074)
         mat(1076) = mat(1076) + lmat(1076)
         mat(1098) = mat(1098) + lmat(1098)
         mat(1102) = mat(1102) + lmat(1102)
         mat(1135) = mat(1135) + lmat(1135)
         mat(1139) = mat(1139) + lmat(1139)
         mat(1140) = mat(1140) + lmat(1140)
         mat(1141) = mat(1141) + lmat(1141)
         mat(1143) = mat(1143) + lmat(1143)
         mat(1156) = lmat(1156)
         mat(1158) = lmat(1158)
         mat(1230) = mat(1230) + lmat(1230)
         mat(1231) = mat(1231) + lmat(1231)
         mat(1235) = mat(1235) + lmat(1235)
         mat(1239) = mat(1239) + lmat(1239)
         mat(1244) = mat(1244) + lmat(1244)
         mat(1245) = mat(1245) + lmat(1245)
         mat(1276) = mat(1276) + lmat(1276)
         mat(1277) = mat(1277) + lmat(1277)
         mat(1281) = mat(1281) + lmat(1281)
         mat(1282) = mat(1282) + lmat(1282)
         mat(1284) = mat(1284) + lmat(1284)
         mat(1285) = mat(1285) + lmat(1285)
         mat(1304) = lmat(1304)
         mat(1305) = mat(1305) + lmat(1305)
         mat(1307) = mat(1307) + lmat(1307)
         mat(1326) = mat(1326) + lmat(1326)
         mat(1335) = mat(1335) + lmat(1335)
         mat(1338) = mat(1338) + lmat(1338)
         mat(1356) = mat(1356) + lmat(1356)
         mat(1381) = mat(1381) + lmat(1381)
         mat(1426) = mat(1426) + lmat(1426)
         mat(1442) = mat(1442) + lmat(1442)
         mat(1446) = mat(1446) + lmat(1446)
         mat(1447) = lmat(1447)
         mat(1448) = lmat(1448)
         mat(1461) = mat(1461) + lmat(1461)
         mat(1462) = mat(1462) + lmat(1462)
         mat(1472) = mat(1472) + lmat(1472)
         mat(1474) = mat(1474) + lmat(1474)
         mat(1487) = mat(1487) + lmat(1487)
         mat(1489) = mat(1489) + lmat(1489)
         mat(1491) = mat(1491) + lmat(1491)
         mat(1493) = mat(1493) + lmat(1493)
         mat(1495) = mat(1495) + lmat(1495)
         mat(1497) = mat(1497) + lmat(1497)
         mat(1498) = lmat(1498)
         mat(1499) = mat(1499) + lmat(1499)
         mat(1500) = mat(1500) + lmat(1500)
         mat(1501) = lmat(1501)
         mat(1504) = lmat(1504)
         mat(1506) = mat(1506) + lmat(1506)
         mat(1510) = mat(1510) + lmat(1510)
         mat(1511) = lmat(1511)
         mat(1512) = mat(1512) + lmat(1512)
         mat(1514) = mat(1514) + lmat(1514)
         mat( 244) = 0._r8
         mat( 297) = 0._r8
         mat( 335) = 0._r8
         mat( 338) = 0._r8
         mat( 339) = 0._r8
         mat( 342) = 0._r8
         mat( 345) = 0._r8
         mat( 347) = 0._r8
         mat( 357) = 0._r8
         mat( 366) = 0._r8
         mat( 369) = 0._r8
         mat( 371) = 0._r8
         mat( 372) = 0._r8
         mat( 376) = 0._r8
         mat( 394) = 0._r8
         mat( 395) = 0._r8
         mat( 399) = 0._r8
         mat( 413) = 0._r8
         mat( 415) = 0._r8
         mat( 416) = 0._r8
         mat( 423) = 0._r8
         mat( 424) = 0._r8
         mat( 426) = 0._r8
         mat( 435) = 0._r8
         mat( 449) = 0._r8
         mat( 452) = 0._r8
         mat( 455) = 0._r8
         mat( 465) = 0._r8
         mat( 470) = 0._r8
         mat( 477) = 0._r8
         mat( 488) = 0._r8
         mat( 499) = 0._r8
         mat( 501) = 0._r8
         mat( 524) = 0._r8
         mat( 525) = 0._r8
         mat( 529) = 0._r8
         mat( 532) = 0._r8
         mat( 537) = 0._r8
         mat( 546) = 0._r8
         mat( 549) = 0._r8
         mat( 550) = 0._r8
         mat( 551) = 0._r8
         mat( 554) = 0._r8
         mat( 560) = 0._r8
         mat( 568) = 0._r8
         mat( 578) = 0._r8
         mat( 580) = 0._r8
         mat( 583) = 0._r8
         mat( 586) = 0._r8
         mat( 595) = 0._r8
         mat( 596) = 0._r8
         mat( 598) = 0._r8
         mat( 600) = 0._r8
         mat( 602) = 0._r8
         mat( 603) = 0._r8
         mat( 619) = 0._r8
         mat( 636) = 0._r8
         mat( 639) = 0._r8
         mat( 651) = 0._r8
         mat( 657) = 0._r8
         mat( 661) = 0._r8
         mat( 662) = 0._r8
         mat( 673) = 0._r8
         mat( 686) = 0._r8
         mat( 689) = 0._r8
         mat( 691) = 0._r8
         mat( 692) = 0._r8
         mat( 698) = 0._r8
         mat( 700) = 0._r8
         mat( 701) = 0._r8
         mat( 703) = 0._r8
         mat( 705) = 0._r8
         mat( 709) = 0._r8
         mat( 710) = 0._r8
         mat( 713) = 0._r8
         mat( 715) = 0._r8
         mat( 716) = 0._r8
         mat( 725) = 0._r8
         mat( 727) = 0._r8
         mat( 731) = 0._r8
         mat( 734) = 0._r8
         mat( 736) = 0._r8
         mat( 737) = 0._r8
         mat( 742) = 0._r8
         mat( 746) = 0._r8
         mat( 749) = 0._r8
         mat( 751) = 0._r8
         mat( 753) = 0._r8
         mat( 754) = 0._r8
         mat( 756) = 0._r8
         mat( 757) = 0._r8
         mat( 758) = 0._r8
         mat( 763) = 0._r8
         mat( 764) = 0._r8
         mat( 770) = 0._r8
         mat( 774) = 0._r8
         mat( 776) = 0._r8
         mat( 777) = 0._r8
         mat( 796) = 0._r8
         mat( 798) = 0._r8
         mat( 802) = 0._r8
         mat( 803) = 0._r8
         mat( 804) = 0._r8
         mat( 805) = 0._r8
         mat( 814) = 0._r8
         mat( 821) = 0._r8
         mat( 830) = 0._r8
         mat( 833) = 0._r8
         mat( 835) = 0._r8
         mat( 837) = 0._r8
         mat( 840) = 0._r8
         mat( 846) = 0._r8
         mat( 848) = 0._r8
         mat( 850) = 0._r8
         mat( 851) = 0._r8
         mat( 854) = 0._r8
         mat( 880) = 0._r8
         mat( 881) = 0._r8
         mat( 884) = 0._r8
         mat( 885) = 0._r8
         mat( 886) = 0._r8
         mat( 888) = 0._r8
         mat( 905) = 0._r8
         mat( 907) = 0._r8
         mat( 910) = 0._r8
         mat( 911) = 0._r8
         mat( 914) = 0._r8
         mat( 915) = 0._r8
         mat( 916) = 0._r8
         mat( 919) = 0._r8
         mat( 920) = 0._r8
         mat( 931) = 0._r8
         mat( 932) = 0._r8
         mat( 939) = 0._r8
         mat( 946) = 0._r8
         mat( 950) = 0._r8
         mat( 956) = 0._r8
         mat( 962) = 0._r8
         mat( 964) = 0._r8
         mat( 970) = 0._r8
         mat( 971) = 0._r8
         mat( 975) = 0._r8
         mat( 976) = 0._r8
         mat( 977) = 0._r8
         mat( 981) = 0._r8
         mat( 985) = 0._r8
         mat( 986) = 0._r8
         mat( 991) = 0._r8
         mat( 993) = 0._r8
         mat( 994) = 0._r8
         mat( 995) = 0._r8
         mat( 996) = 0._r8
         mat( 997) = 0._r8
         mat( 999) = 0._r8
         mat(1001) = 0._r8
         mat(1002) = 0._r8
         mat(1003) = 0._r8
         mat(1005) = 0._r8
         mat(1006) = 0._r8
         mat(1007) = 0._r8
         mat(1009) = 0._r8
         mat(1010) = 0._r8
         mat(1011) = 0._r8
         mat(1020) = 0._r8
         mat(1022) = 0._r8
         mat(1023) = 0._r8
         mat(1025) = 0._r8
         mat(1029) = 0._r8
         mat(1030) = 0._r8
         mat(1033) = 0._r8
         mat(1034) = 0._r8
         mat(1035) = 0._r8
         mat(1038) = 0._r8
         mat(1045) = 0._r8
         mat(1051) = 0._r8
         mat(1100) = 0._r8
         mat(1106) = 0._r8
         mat(1108) = 0._r8
         mat(1112) = 0._r8
         mat(1120) = 0._r8
         mat(1121) = 0._r8
         mat(1125) = 0._r8
         mat(1126) = 0._r8
         mat(1127) = 0._r8
         mat(1131) = 0._r8
         mat(1132) = 0._r8
         mat(1133) = 0._r8
         mat(1136) = 0._r8
         mat(1137) = 0._r8
         mat(1145) = 0._r8
         mat(1147) = 0._r8
         mat(1149) = 0._r8
         mat(1183) = 0._r8
         mat(1200) = 0._r8
         mat(1213) = 0._r8
         mat(1247) = 0._r8
         mat(1264) = 0._r8
         mat(1273) = 0._r8
         mat(1274) = 0._r8
         mat(1275) = 0._r8
         mat(1279) = 0._r8
         mat(1280) = 0._r8
         mat(1286) = 0._r8
         mat(1287) = 0._r8
         mat(1289) = 0._r8
         mat(1290) = 0._r8
         mat(1291) = 0._r8
         mat(1294) = 0._r8
         mat(1295) = 0._r8
         mat(1296) = 0._r8
         mat(1297) = 0._r8
         mat(1298) = 0._r8
         mat(1299) = 0._r8
         mat(1300) = 0._r8
         mat(1302) = 0._r8
         mat(1303) = 0._r8
         mat(1308) = 0._r8
         mat(1309) = 0._r8
         mat(1310) = 0._r8
         mat(1311) = 0._r8
         mat(1312) = 0._r8
         mat(1313) = 0._r8
         mat(1328) = 0._r8
         mat(1329) = 0._r8
         mat(1333) = 0._r8
         mat(1334) = 0._r8
         mat(1336) = 0._r8
         mat(1340) = 0._r8
         mat(1342) = 0._r8
         mat(1343) = 0._r8
         mat(1344) = 0._r8
         mat(1347) = 0._r8
         mat(1350) = 0._r8
         mat(1351) = 0._r8
         mat(1353) = 0._r8
         mat(1354) = 0._r8
         mat(1355) = 0._r8
         mat(1358) = 0._r8
         mat(1359) = 0._r8
         mat(1360) = 0._r8
         mat(1371) = 0._r8
         mat(1376) = 0._r8
         mat(1384) = 0._r8
         mat(1386) = 0._r8
         mat(1393) = 0._r8
         mat(1398) = 0._r8
         mat(1399) = 0._r8
         mat(1400) = 0._r8
         mat(1404) = 0._r8
         mat(1423) = 0._r8
         mat(1429) = 0._r8
         mat(1433) = 0._r8
         mat(1436) = 0._r8
         mat(1437) = 0._r8
         mat(1440) = 0._r8
         mat(1443) = 0._r8
         mat(1445) = 0._r8
         mat(1450) = 0._r8
         mat(1452) = 0._r8
         mat(1454) = 0._r8
         mat(1455) = 0._r8
         mat(1458) = 0._r8
         mat(1463) = 0._r8
         mat(1464) = 0._r8
         mat(1471) = 0._r8
         mat(1475) = 0._r8
         mat(1476) = 0._r8
         mat(1477) = 0._r8
         mat(1481) = 0._r8
         mat(1482) = 0._r8
         mat(1484) = 0._r8
         mat(1488) = 0._r8
         mat(1505) = 0._r8
         mat(1507) = 0._r8
         mat(1508) = 0._r8
         mat(1509) = 0._r8
         mat(1513) = 0._r8
         mat( 1) = mat( 1) - dti
         mat( 2) = mat( 2) - dti
         mat( 3) = mat( 3) - dti
         mat( 4) = mat( 4) - dti
         mat( 5) = mat( 5) - dti
         mat( 6) = mat( 6) - dti
         mat( 7) = mat( 7) - dti
         mat( 8) = mat( 8) - dti
         mat( 9) = mat( 9) - dti
         mat( 10) = mat( 10) - dti
         mat( 11) = mat( 11) - dti
         mat( 12) = mat( 12) - dti
         mat( 13) = mat( 13) - dti
         mat( 14) = mat( 14) - dti
         mat( 15) = mat( 15) - dti
         mat( 16) = mat( 16) - dti
         mat( 17) = mat( 17) - dti
         mat( 18) = mat( 18) - dti
         mat( 19) = mat( 19) - dti
         mat( 20) = mat( 20) - dti
         mat( 21) = mat( 21) - dti
         mat( 24) = mat( 24) - dti
         mat( 27) = mat( 27) - dti
         mat( 30) = mat( 30) - dti
         mat( 33) = mat( 33) - dti
         mat( 37) = mat( 37) - dti
         mat( 42) = mat( 42) - dti
         mat( 45) = mat( 45) - dti
         mat( 48) = mat( 48) - dti
         mat( 51) = mat( 51) - dti
         mat( 54) = mat( 54) - dti
         mat( 57) = mat( 57) - dti
         mat( 59) = mat( 59) - dti
         mat( 61) = mat( 61) - dti
         mat( 65) = mat( 65) - dti
         mat( 69) = mat( 69) - dti
         mat( 73) = mat( 73) - dti
         mat( 76) = mat( 76) - dti
         mat( 79) = mat( 79) - dti
         mat( 84) = mat( 84) - dti
         mat( 88) = mat( 88) - dti
         mat( 94) = mat( 94) - dti
         mat( 100) = mat( 100) - dti
         mat( 106) = mat( 106) - dti
         mat( 112) = mat( 112) - dti
         mat( 119) = mat( 119) - dti
         mat( 124) = mat( 124) - dti
         mat( 129) = mat( 129) - dti
         mat( 134) = mat( 134) - dti
         mat( 138) = mat( 138) - dti
         mat( 143) = mat( 143) - dti
         mat( 146) = mat( 146) - dti
         mat( 154) = mat( 154) - dti
         mat( 158) = mat( 158) - dti
         mat( 164) = mat( 164) - dti
         mat( 170) = mat( 170) - dti
         mat( 176) = mat( 176) - dti
         mat( 182) = mat( 182) - dti
         mat( 188) = mat( 188) - dti
         mat( 193) = mat( 193) - dti
         mat( 198) = mat( 198) - dti
         mat( 205) = mat( 205) - dti
         mat( 212) = mat( 212) - dti
         mat( 219) = mat( 219) - dti
         mat( 226) = mat( 226) - dti
         mat( 232) = mat( 232) - dti
         mat( 238) = mat( 238) - dti
         mat( 246) = mat( 246) - dti
         mat( 252) = mat( 252) - dti
         mat( 256) = mat( 256) - dti
         mat( 264) = mat( 264) - dti
         mat( 272) = mat( 272) - dti
         mat( 280) = mat( 280) - dti
         mat( 284) = mat( 284) - dti
         mat( 293) = mat( 293) - dti
         mat( 301) = mat( 301) - dti
         mat( 310) = mat( 310) - dti
         mat( 314) = mat( 314) - dti
         mat( 321) = mat( 321) - dti
         mat( 330) = mat( 330) - dti
         mat( 341) = mat( 341) - dti
         mat( 352) = mat( 352) - dti
         mat( 359) = mat( 359) - dti
         mat( 367) = mat( 367) - dti
         mat( 378) = mat( 378) - dti
         mat( 384) = mat( 384) - dti
         mat( 393) = mat( 393) - dti
         mat( 401) = mat( 401) - dti
         mat( 410) = mat( 410) - dti
         mat( 421) = mat( 421) - dti
         mat( 429) = mat( 429) - dti
         mat( 438) = mat( 438) - dti
         mat( 447) = mat( 447) - dti
         mat( 457) = mat( 457) - dti
         mat( 469) = mat( 469) - dti
         mat( 481) = mat( 481) - dti
         mat( 491) = mat( 491) - dti
         mat( 507) = mat( 507) - dti
         mat( 515) = mat( 515) - dti
         mat( 522) = mat( 522) - dti
         mat( 535) = mat( 535) - dti
         mat( 545) = mat( 545) - dti
         mat( 557) = mat( 557) - dti
         mat( 565) = mat( 565) - dti
         mat( 577) = mat( 577) - dti
         mat( 592) = mat( 592) - dti
         mat( 607) = mat( 607) - dti
         mat( 612) = mat( 612) - dti
         mat( 621) = mat( 621) - dti
         mat( 630) = mat( 630) - dti
         mat( 642) = mat( 642) - dti
         mat( 655) = mat( 655) - dti
         mat( 667) = mat( 667) - dti
         mat( 682) = mat( 682) - dti
         mat( 702) = mat( 702) - dti
         mat( 726) = mat( 726) - dti
         mat( 745) = mat( 745) - dti
         mat( 765) = mat( 765) - dti
         mat( 794) = mat( 794) - dti
         mat( 810) = mat( 810) - dti
         mat( 829) = mat( 829) - dti
         mat( 844) = mat( 844) - dti
         mat( 877) = mat( 877) - dti
         mat( 908) = mat( 908) - dti
         mat( 948) = mat( 948) - dti
         mat( 973) = mat( 973) - dti
         mat(1000) = mat(1000) - dti
         mat(1046) = mat(1046) - dti
         mat(1102) = mat(1102) - dti
         mat(1140) = mat(1140) - dti
         mat(1239) = mat(1239) - dti
         mat(1284) = mat(1284) - dti
         mat(1307) = mat(1307) - dti
         mat(1335) = mat(1335) - dti
         mat(1356) = mat(1356) - dti
         mat(1426) = mat(1426) - dti
         mat(1462) = mat(1462) - dti
         mat(1487) = mat(1487) - dti
         mat(1514) = mat(1514) - dti
      end subroutine nlnmat_finit
      subroutine nlnmat( mat, y, rxt, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)
      call nlnmat01( mat, y, rxt )
      call nlnmat02( mat, y, rxt )
      call nlnmat03( mat, y, rxt )
      call nlnmat04( mat, y, rxt )
      call nlnmat05( mat, y, rxt )
      call nlnmat06( mat, y, rxt )
      call nlnmat07( mat, y, rxt )
      call nlnmat_finit( mat, lmat, dti )
      end subroutine nlnmat
      end module mo_nln_matrix
