
      module mo_sim_dat

      private
      public :: set_sim_dat

      contains

      subroutine set_sim_dat

      use chem_mods,     only : clscnt, cls_rxt_cnt, clsmap, permute, adv_mass, fix_mass, crb_mass
      use chem_mods,     only : diag_map
      use chem_mods,     only : phtcnt, rxt_tag_cnt, rxt_tag_lst, rxt_tag_map
      use chem_mods,     only : pht_alias_lst, pht_alias_mult
      use chem_mods,     only : extfrc_lst, inv_lst, slvd_lst
      use chem_mods,     only : enthalpy_cnt, cph_enthalpy, cph_rid
      use cam_abortutils,only : endrun
      use mo_tracname,   only : solsym
      use chem_mods,     only : frc_from_dataset
      use shr_kind_mod,  only : r8 => shr_kind_r8
      use cam_logfile,   only : iulog

      implicit none

!--------------------------------------------------------------
!      ... local variables
!--------------------------------------------------------------
      integer :: ios

      clscnt(:) = (/     23,     0,     0,   151,     0 /)

      cls_rxt_cnt(:,1) = (/     19,    60,     0,    23 /)
      cls_rxt_cnt(:,4) = (/     31,   173,   273,   151 /)

      solsym(:174) = (/ 'O3              ','O               ','O1D             ','O2              ','O2_1S           ', &
                        'O2_1D           ','N2O             ','N               ','NO              ','NO2             ', &
                        'NO3             ','HNO3            ','HO2NO2          ','N2O5            ','CH4             ', &
                        'CH3O2           ','CH3OOH          ','CH3OH           ','CH2O            ','CO              ', &
                        'H2              ','H               ','OH              ','HO2             ','H2O2            ', &
                        'CLY             ','BRY             ','CL              ','CL2             ','CLO             ', &
                        'OCLO            ','CL2O2           ','HCL             ','HOCL            ','CLONO2          ', &
                        'BRCL            ','BR              ','BRO             ','HBR             ','HOBR            ', &
                        'BRONO2          ','HCN             ','CH3CN           ','C2H4            ','C2H6            ', &
                        'C2H5O2          ','C2H5OOH         ','CH3CO3          ','CH3COOH         ','CH3CHO          ', &
                        'C2H5OH          ','GLYALD          ','GLYOXAL         ','CH3COOOH        ','EO2             ', &
                        'EO              ','EOOH            ','PAN             ','C3H6            ','C3H8            ', &
                        'C3H7O2          ','C3H7OOH         ','CH3COCH3        ','PO2             ','POOH            ', &
                        'HYAC            ','RO2             ','CH3COCHO        ','ROOH            ','BIGENE          ', &
                        'BIGALK          ','MEK             ','ENEO2           ','MEKO2           ','MEKOOH          ', &
                        'MCO3            ','MVK             ','MACR            ','MACRO2          ','MACROOH         ', &
                        'MPAN            ','ONIT            ','ISOP            ','ALKO2           ','ALKOOH          ', &
                        'BIGALD          ','HYDRALD         ','ISOPO2          ','ISOPNO3         ','ONITR           ', &
                        'XO2             ','XOOH            ','ISOPOOH         ','TOLUENE         ','CRESOL          ', &
                        'TOLO2           ','TOLOOH          ','XOH             ','BENZENE         ','BENO2           ', &
                        'BENOOH          ','XYLENE          ','XYLO2           ','XYLOOH          ','C10H16          ', &
                        'TERPO2          ','TERPOOH         ','CH3CL           ','CH3BR           ','CFC11           ', &
                        'CFC12           ','CFC113          ','HCFC22          ','CCL4            ','CH3CCL3         ', &
                        'CF3BR           ','CF2CLBR         ','HCFC141B        ','HCFC142B        ','CFC114          ', &
                        'CFC115          ','H1202           ','H2402           ','CHBR3           ','CH2BR2          ', &
                        'CO2             ','N2p             ','O2p             ','Np              ','Op              ', &
                        'NOp             ','e               ','N2D             ','H2O             ','C2H2            ', &
                        'HCOOH           ','HOCH2OO         ','COF2            ','COFCL           ','HF              ', &
                        'F               ','CB1             ','CB2             ','OC1             ','OC2             ', &
                        'SOAM            ','SOAI            ','SOAT            ','SOAB            ','SOAX            ', &
                        'SOGM            ','SOGI            ','SOGT            ','SOGB            ','SOGX            ', &
                        'SO2             ','DMS             ','SO4             ','NH3             ','NH4             ', &
                        'NH4NO3          ','OCS             ','S               ','SO              ','SO3             ', &
                        'H2SO4           ','SSLT01          ','SSLT02          ','SSLT03          ','SSLT04          ', &
                        'DST01           ','DST02           ','DST03           ','DST04           ' /)

      adv_mass(:174) = (/    47.998200_r8,    15.999400_r8,    15.999400_r8,    31.998800_r8,    31.998800_r8, &
                             31.998800_r8,    44.012880_r8,    14.006740_r8,    30.006140_r8,    46.005540_r8, &
                             62.004940_r8,    63.012340_r8,    79.011740_r8,   108.010480_r8,    16.040600_r8, &
                             47.032000_r8,    48.039400_r8,    32.040000_r8,    30.025200_r8,    28.010400_r8, &
                              2.014800_r8,     1.007400_r8,    17.006800_r8,    33.006200_r8,    34.013600_r8, &
                            100.916850_r8,    99.716850_r8,    35.452700_r8,    70.905400_r8,    51.452100_r8, &
                             67.451500_r8,   102.904200_r8,    36.460100_r8,    52.459500_r8,    97.457640_r8, &
                            115.356700_r8,    79.904000_r8,    95.903400_r8,    80.911400_r8,    96.910800_r8, &
                            141.908940_r8,    27.025140_r8,    41.050940_r8,    28.051600_r8,    30.066400_r8, &
                             61.057800_r8,    62.065200_r8,    75.042400_r8,    60.050400_r8,    44.051000_r8, &
                             46.065800_r8,    60.050400_r8,    58.035600_r8,    76.049800_r8,    77.057200_r8, &
                             61.057800_r8,    78.064600_r8,   121.047940_r8,    42.077400_r8,    44.092200_r8, &
                             75.083600_r8,    76.091000_r8,    58.076800_r8,    91.083000_r8,    92.090400_r8, &
                             74.076200_r8,    89.068200_r8,    72.061400_r8,    90.075600_r8,    56.103200_r8, &
                             72.143800_r8,    72.102600_r8,   105.108800_r8,   103.094000_r8,   104.101400_r8, &
                            101.079200_r8,    70.087800_r8,    70.087800_r8,   119.093400_r8,   120.100800_r8, &
                            147.084740_r8,   119.074340_r8,    68.114200_r8,   103.135200_r8,   104.142600_r8, &
                             98.098200_r8,   100.113000_r8,   117.119800_r8,   162.117940_r8,   147.125940_r8, &
                            149.118600_r8,   150.126000_r8,   118.127200_r8,    92.136200_r8,   108.135600_r8, &
                            173.140600_r8,   174.148000_r8,   190.147400_r8,    78.110400_r8,   127.116000_r8, &
                            128.123400_r8,   106.162000_r8,   155.167600_r8,   156.175000_r8,   136.228400_r8, &
                            185.234000_r8,   186.241400_r8,    50.485900_r8,    94.937200_r8,   137.367503_r8, &
                            120.913206_r8,   187.375310_r8,    86.467906_r8,   153.821800_r8,   133.402300_r8, &
                            148.910210_r8,   165.364506_r8,   116.948003_r8,   100.493706_r8,   170.921013_r8, &
                            154.466716_r8,   209.815806_r8,   259.823613_r8,   252.730400_r8,   173.833800_r8, &
                             44.009800_r8,    28.013480_r8,    31.998800_r8,    14.006740_r8,    15.999400_r8, &
                             30.006140_r8, 0.548567E-03_r8,    14.006740_r8,    18.014200_r8,    26.036800_r8, &
                             46.024600_r8,    63.031400_r8,    66.007206_r8,    82.461503_r8,    20.005803_r8, &
                             18.998403_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8, &
                            200.226000_r8,   136.141400_r8,   141.141800_r8,   127.116000_r8,   155.167600_r8, &
                            200.226000_r8,   136.141400_r8,   141.141800_r8,   127.116000_r8,   155.167600_r8, &
                             64.064800_r8,    62.132400_r8,    96.063600_r8,    17.028940_r8,    18.036340_r8, &
                             80.041280_r8,    60.076400_r8,    32.066000_r8,    48.065400_r8,    80.064200_r8, &
                             98.078400_r8,    58.442468_r8,    58.442468_r8,    58.442468_r8,    58.442468_r8, &
                            135.064039_r8,   135.064039_r8,   135.064039_r8,   135.064039_r8 /)

      crb_mass(:174) = (/     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,    12.011000_r8, &
                             12.011000_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                             12.011000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,    12.011000_r8,    24.022000_r8,    24.022000_r8,    24.022000_r8, &
                             24.022000_r8,    24.022000_r8,    24.022000_r8,    24.022000_r8,    24.022000_r8, &
                             24.022000_r8,    24.022000_r8,    24.022000_r8,    24.022000_r8,    24.022000_r8, &
                             24.022000_r8,    24.022000_r8,    24.022000_r8,    36.033000_r8,    36.033000_r8, &
                             36.033000_r8,    36.033000_r8,    36.033000_r8,    36.033000_r8,    36.033000_r8, &
                             36.033000_r8,    36.033000_r8,    36.033000_r8,    36.033000_r8,    48.044000_r8, &
                             60.055000_r8,    48.044000_r8,    48.044000_r8,    48.044000_r8,    48.044000_r8, &
                             48.044000_r8,    48.044000_r8,    48.044000_r8,    48.044000_r8,    48.044000_r8, &
                             48.044000_r8,    36.033000_r8,    60.055000_r8,    60.055000_r8,    60.055000_r8, &
                             60.055000_r8,    60.055000_r8,    60.055000_r8,    60.055000_r8,    60.055000_r8, &
                             60.055000_r8,    60.055000_r8,    60.055000_r8,    84.077000_r8,    84.077000_r8, &
                             84.077000_r8,    84.077000_r8,    84.077000_r8,    72.066000_r8,    72.066000_r8, &
                             72.066000_r8,    96.088000_r8,    96.088000_r8,    96.088000_r8,   120.110000_r8, &
                            120.110000_r8,   120.110000_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8, &
                             12.011000_r8,    24.022000_r8,    12.011000_r8,    12.011000_r8,    24.022000_r8, &
                             12.011000_r8,    12.011000_r8,    24.022000_r8,    24.022000_r8,    24.022000_r8, &
                             24.022000_r8,    12.011000_r8,    24.022000_r8,    12.011000_r8,    12.011000_r8, &
                             12.011000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,    24.022000_r8, &
                             12.011000_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8,     0.000000_r8, &
                              0.000000_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8, &
                            120.110000_r8,    60.055000_r8,    84.077000_r8,    72.066000_r8,    96.088000_r8, &
                            120.110000_r8,    60.055000_r8,    84.077000_r8,    72.066000_r8,    96.088000_r8, &
                              0.000000_r8,    24.022000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,    12.011000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8 /)

      fix_mass(:  2) = (/ 0.00000000_r8, 28.0134800_r8 /)

      clsmap(: 23,1) = (/   15,   7, 108, 109, 110, 111, 112, 120, 121, 113, &
                           118, 119, 114, 115, 116, 117, 122, 123, 124, 125, &
                           126,  26,  27 /)
      clsmap(:151,4) = (/    1,   2,   3,   4,   5,   6,  21,  20,   8,   9, &
                            10,  23,  11,  12,  13,  14,  16,  17,  42,  43, &
                            19,  22,  24,  25, 134,  28,  29,  30,  31,  32, &
                            33,  34,  35,  36,  37,  38,  39,  40,  41, 127, &
                           128, 129, 130, 131, 133, 132,  59,  83,  64,  50, &
                            49,  65,  48,  54,  58,  82,  45,  44,  71,  81, &
                            70,  73,  84,  85,  72,  74,  75,  94,  95,  96, &
                            97,  98, 106, 107,  86,  53,  99, 100, 101, 102, &
                           103, 104,  88,  77,  78,  79,  80,  76,  46,  47, &
                           105,  60,  61,  62,  63,  69,  18,  51,  52,  66, &
                            55,  56,  57,  87,  67,  68,  89,  90,  91,  92, &
                            93, 135, 136, 137, 138, 139, 140, 141, 156, 157, &
                           158, 159, 160, 161, 146, 147, 148, 149, 150, 151, &
                           152, 153, 154, 155, 162, 163, 164, 165, 166, 142, &
                           143, 144, 145, 167, 168, 169, 170, 171, 172, 173, &
                           174 /)

      permute(:151,4) = (/  140, 139, 141, 136,  41,  40, 124, 119, 108, 138, &
                            142, 150, 147, 137,  74,  55, 135,  69,  46,  34, &
                            144, 145, 146,  90, 148, 149,  43, 151,  56,  29, &
                            133, 110, 117,  48, 134, 143, 107, 100,  86,  94, &
                            102,  76,  91, 103,  77, 104, 118, 113, 106, 120, &
                             89,  87, 131,  78,  75,  65,  52,  82,  30,  81, &
                             31,  57,  95,  92,  70,  93,  58,  36,  37,  79, &
                             63,  44, 116,  72,  80,  98,  32,  64,   1,  33, &
                             73,   2, 127, 129, 123, 128,  59, 130, 109,  60, &
                             88,  35, 111,  66,  96,  67,  84,  49, 112, 122, &
                             99,  71,  38,  61, 121, 125, 105, 114, 126,  50, &
                             85,  53,  83,  68,  39,  45,  47, 101, 115,  54, &
                              3,   4,   5,   6,   7,   8,   9,  10,  11,  12, &
                             13,  14,  15,  16,  62,  97, 132,  51,  42,  17, &
                             18,  19,  20,  21,  22,  23,  24,  25,  26,  27, &
                             28 /)

      diag_map(:151) = (/    1,   2,   3,   4,   5,   6,   7,   8,   9,  10, &
                            11,  12,  13,  14,  15,  16,  17,  19,  20,  22, &
                            23,  24,  25,  26,  27,  28,  29,  30,  31,  34, &
                            37,  40,  43,  46,  49,  53,  58,  61,  64,  67, &
                            70,  72,  75,  77,  81,  85,  89,  92,  95,  99, &
                           104, 108, 114, 120, 126, 132, 137, 144, 149, 154, &
                           159, 162, 170, 177, 183, 187, 193, 199, 205, 211, &
                           216, 221, 229, 236, 243, 250, 257, 262, 269, 277, &
                           283, 291, 299, 303, 307, 315, 323, 331, 340, 344, &
                           351, 359, 370, 379, 393, 404, 410, 417, 423, 432, &
                           441, 449, 458, 469, 476, 487, 497, 509, 521, 531, &
                           540, 553, 560, 578, 587, 595, 608, 621, 636, 641, &
                           652, 664, 671, 684, 696, 711, 734, 758, 777, 797, &
                           826, 842, 861, 876, 909, 940, 961,1019,1061,1107, &
                          1134,1172,1197,1222,1243,1317,1362,1389,1425,1527, &
                          1555 /)

      extfrc_lst(: 14) = (/ 'NO              ','NO2             ','CO              ','SO2             ','SO4             ', &
                            'CB1             ','Op              ','O2p             ','Np              ','N2p             ', &
                            'N2D             ','N               ','e               ','OH              ' /)

      frc_from_dataset(: 14) = (/ .true., .true., .true., .true., .true., &
                                  .true., .false., .false., .false., .false., &
                                  .false., .false., .false., .false. /)

      inv_lst(:  2) = (/ 'M               ', 'N2              ' /)

      if( allocated( rxt_tag_lst ) ) then
         deallocate( rxt_tag_lst )
      end if
      allocate( rxt_tag_lst(rxt_tag_cnt),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate rxt_tag_lst; error = ',ios
         call endrun
      end if
      if( allocated( rxt_tag_map ) ) then
         deallocate( rxt_tag_map )
      end if
      allocate( rxt_tag_map(rxt_tag_cnt),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate rxt_tag_map; error = ',ios
         call endrun
      end if
      rxt_tag_lst(:rxt_tag_cnt) = (/ 'jo2_a           ', 'jo2_b           ', 'jo3_a           ', 'jo3_b           ', &
                                     'jn2o            ', 'jno             ', 'jno_i           ', 'jno2            ', &
                                     'jn2o5_a         ', 'jn2o5_b         ', 'jhno3           ', 'jno3_a          ', &
                                     'jno3_b          ', 'jho2no2_a       ', 'jho2no2_b       ', 'jch3ooh         ', &
                                     'jch2o_a         ', 'jch2o_b         ', 'jh2o_a          ', 'jh2o_b          ', &
                                     'jh2o_c          ', 'jh2o2           ', 'jcl2            ', 'jclo            ', &
                                     'joclo           ', 'jcl2o2          ', 'jhocl           ', 'jhcl            ', &
                                     'jclono2_a       ', 'jclono2_b       ', 'jbrcl           ', 'jbro            ', &
                                     'jhobr           ', 'jhbr            ', 'jbrono2_a       ', 'jbrono2_b       ', &
                                     'jch3cl          ', 'jccl4           ', 'jch3ccl3        ', 'jcfcl3          ', &
                                     'jcf2cl2         ', 'jcfc113         ', 'jcfc114         ', 'jcfc115         ', &
                                     'jhcfc22         ', 'jhcfc141b       ', 'jhcfc142b       ', 'jch3br          ', &
                                     'jcf3br          ', 'jcf2clbr        ', 'jchbr3          ', 'jch2br2         ', &
                                     'jh1202          ', 'jh2402          ', 'jcof2           ', 'jcofcl          ', &
                                     'jhf             ', 'jco2            ', 'jch4_a          ', 'jch4_b          ', &
                                     'jch3cho         ', 'jpooh           ', 'jch3co3h        ', 'jpan            ', &
                                     'jmpan           ', 'jmacr_a         ', 'jmacr_b         ', 'jmvk            ', &
                                     'jc2h5ooh        ', 'jeooh           ', 'jc3h7ooh        ', 'jrooh           ', &
                                     'jacet           ', 'jmgly           ', 'jxooh           ', 'jonitr          ', &
                                     'jisopooh        ', 'jhyac           ', 'jglyald         ', 'jmek            ', &
                                     'jbigald         ', 'jglyoxal        ', 'jalkooh         ', 'jmekooh         ', &
                                     'jtolooh         ', 'jterpooh        ', 'jh2so4          ', 'jso2            ', &
                                     'jso3            ', 'jocs            ', 'jso             ', 'jeuv_1          ', &
                                     'jeuv_2          ', 'jeuv_3          ', 'jeuv_4          ', 'jeuv_5          ', &
                                     'jeuv_6          ', 'jeuv_7          ', 'jeuv_8          ', 'jeuv_9          ', &
                                     'jeuv_10         ', 'jeuv_11         ', 'jeuv_12         ', 'jeuv_13         ', &
                                     'jeuv_14         ', 'jeuv_15         ', 'jeuv_16         ', 'jeuv_17         ', &
                                     'jeuv_18         ', 'jeuv_19         ', 'jeuv_20         ', 'jeuv_21         ', &
                                     'jeuv_22         ', 'jeuv_23         ', 'jeuv_24         ', 'jeuv_25         ', &
                                     'jeuv_26         ', 'usr_O_O2        ', 'O_O3            ', 'usr_O_O         ', &
                                     'O2_1S_O         ', 'O2_1S_O2        ', 'O2_1S_N2        ', 'O2_1S_O3        ', &
                                     'O2_1S_CO2       ', 'ag2             ', 'O2_1D_O         ', 'O2_1D_O2        ', &
                                     'O2_1D_N2        ', 'ag1             ', 'O1D_N2          ', 'O1D_O2          ', &
                                     'O1D_O2b         ', 'O1D_H2O         ', 'O1D_N2Oa        ', 'O1D_N2Ob        ', &
                                     'O1D_O3          ', 'O1D_CFC11       ', 'O1D_CFC12       ', 'O1D_CFC113      ', &
                                     'O1D_CFC114      ', 'O1D_CFC115      ', 'O1D_HCFC22      ', 'O1D_HCFC141B    ', &
                                     'O1D_HCFC142B    ', 'O1D_CCL4        ', 'O1D_CH3BR       ', 'O1D_CF2CLBR     ', &
                                     'O1D_CF3BR       ', 'O1D_H1202       ', 'O1D_H2402       ', 'O1D_CHBR3       ', &
                                     'O1D_CH2BR2      ', 'O1D_COF2        ', 'O1D_COFCL       ', 'O1D_CH4a        ', &
                                     'O1D_CH4b        ', 'O1D_CH4c        ', 'O1D_H2          ', 'O1D_HCL         ', &
                                     'O1D_HBR         ', 'O1D_HCN         ', 'H_O2            ', 'H_O3            ', &
                                     'H_HO2a          ', 'H_HO2           ', 'H_HO2b          ', 'OH_O            ', &
                                     'OH_O3           ', 'OH_HO2          ', 'OH_OH           ', 'OH_OH_M         ', &
                                     'OH_H2           ', 'OH_H2O2         ', 'H2_O            ', 'HO2_O           ', &
                                     'HO2_O3          ', 'usr_HO2_HO2     ', 'H2O2_O          ', 'HCN_OH          ', &
                                     'CH3CN_OH        ', 'N2D_O2          ', 'N2D_O           ', 'N_OH            ', &
                                     'N_O2            ', 'N_NO            ', 'N_NO2a          ', 'N_NO2b          ', &
                                     'N_NO2c          ', 'NO_O_M          ', 'NO_HO2          ', 'NO_O3           ', &
                                     'NO2_O           ', 'NO2_O_M         ', 'NO2_O3          ', 'tag_NO2_NO3     ', &
                                     'usr_N2O5_M      ', 'tag_NO2_OH      ', 'usr_HNO3_OH     ', 'NO3_NO          ', &
                                     'NO3_O           ', 'NO3_OH          ', 'NO3_HO2         ', 'tag_NO2_HO2     ', &
                                     'HO2NO2_OH       ', 'usr_HO2NO2_M    ', 'CL_O3           ', 'CL_H2           ', &
                                     'CL_H2O2         ', 'CL_HO2a         ', 'CL_HO2b         ', 'CL_CH2O         ', &
                                     'CL_CH4          ', 'CLO_O           ', 'CLO_OHa         ', 'CLO_OHb         ', &
                                     'CLO_HO2         ', 'CLO_CH3O2       ', 'CLO_NO          ', 'CLO_NO2_M       ', &
                                     'CLO_CLOa        ', 'CLO_CLOb        ', 'CLO_CLOc        ', 'tag_CLO_CLO_M   ', &
                                     'usr_CL2O2_M     ', 'HCL_OH          ', 'HCL_O           ', 'HOCL_O          ', &
                                     'HOCL_CL         ', 'HOCL_OH         ', 'CLONO2_O        ', 'CLONO2_OH       ', &
                                     'CLONO2_CL       ', 'BR_O3           ', 'BR_HO2          ', 'BR_CH2O         ', &
                                     'BRO_O           ', 'BRO_OH          ', 'BRO_HO2         ', 'BRO_NO          ', &
                                     'BRO_NO2_M       ', 'BRO_CLOa        ', 'BRO_CLOb        ', 'BRO_CLOc        ', &
                                     'BRO_BRO         ', 'HBR_OH          ', 'HBR_O           ', 'HOBR_O          ', &
                                     'BRONO2_O        ', 'F_H2O           ', 'F_H2            ', 'F_CH4           ', &
                                     'F_HNO3          ', 'CH3CL_CL        ', 'CH3CL_OH        ', 'CH3CCL3_OH      ', &
                                     'HCFC22_OH       ', 'CH3BR_OH        ', 'CH3BR_CL        ', 'HCFC141B_OH     ', &
                                     'HCFC142B_OH     ', 'CH2BR2_OH       ', 'CHBR3_OH        ', 'CH2BR2_CL       ', &
                                     'CHBR3_CL        ', 'CH4_OH          ', 'usr_CO_OH_b     ', 'CO_OH_M         ', &
                                     'CH2O_NO3        ', 'CH2O_OH         ', 'CH2O_O          ', 'CH2O_HO2        ', &
                                     'CH3O2_NO        ', 'CH3O2_HO2       ', 'CH3O2_CH3O2a    ', 'CH3O2_CH3O2b    ', &
                                     'CH3OH_OH        ', 'CH3OOH_OH       ', 'HCOOH_OH        ', 'HOCH2OO_M       ', &
                                     'HOCH2OO_NO      ', 'HOCH2OO_HO2     ', 'C2H2_CL_M       ', 'C2H4_CL_M       ', &
                                     'C2H6_CL         ', 'C2H2_OH_M       ', 'C2H6_OH         ', 'tag_C2H4_OH     ', &
                                     'EO2_NO          ', 'EO2_HO2         ', 'EO_O2           ', 'EO_M            ', &
                                     'C2H4_O3         ', 'CH3COOH_OH      ', 'C2H5O2_NO       ', 'C2H5O2_HO2      ', &
                                     'C2H5O2_CH3O2    ', 'C2H5O2_C2H5O2   ', 'C2H5OOH_OH      ', 'CH3CHO_OH       ', &
                                     'CH3CHO_NO3      ', 'CH3CO3_NO       ', 'tag_CH3CO3_NO2  ', 'CH3CO3_HO2      ', &
                                     'CH3CO3_CH3O2    ', 'CH3CO3_CH3CO3   ', 'CH3COOOH_OH     ', 'GLYALD_OH       ', &
                                     'GLYOXAL_OH      ', 'C2H5OH_OH       ', 'usr_PAN_M       ', 'PAN_OH          ', &
                                     'tag_C3H6_OH     ', 'C3H6_O3         ', 'C3H6_NO3        ', 'C3H7O2_NO       ', &
                                     'C3H7O2_HO2      ', 'CH3H7O2_CH3O2   ', 'CH3H7OOH_OH     ', 'C3H8_OH         ', &
                                     'PO2_NO          ', 'PO2_HO2         ', 'POOH_OH         ', 'usr_CH3COCH3_OH ', &
                                     'RO2_NO          ', 'RO2_HO2         ', 'RO2_CH3O2       ', 'ROOH_OH         ', &
                                     'HYAC_OH         ', 'CH3COCHO_OH     ', 'CH3COCHO_NO3    ', 'ONIT_OH         ', &
                                     'BIGENE_OH       ', 'ENEO2_NO        ', 'MVK_OH          ', 'MVK_O3          ', &
                                     'MEK_OH          ', 'MEKO2_NO        ', 'MEKO2_HO2       ', 'MEKOOH_OH       ', &
                                     'MACR_OH         ', 'MACR_O3         ', 'MACRO2_NOa      ', 'MACRO2_NOb      ', &
                                     'MACRO2_NO3      ', 'MACRO2_HO2      ', 'MACRO2_CH3O2    ', 'MACRO2_CH3CO3   ', &
                                     'MACROOH_OH      ', 'MCO3_NO         ', 'MCO3_NO3        ', 'MCO3_HO2        ', &
                                     'MCO3_CH3O2      ', 'MCO3_CH3CO3     ', 'MCO3_MCO3       ', 'usr_MCO3_NO2    ', &
                                     'usr_MPAN_M      ', 'MPAN_OH_M       ', 'ISOP_OH         ', 'ISOP_O3         ', &
                                     'ISOP_NO3        ', 'ISOPO2_NO       ', 'ISOPO2_NO3      ', 'ISOPO2_HO2      ', &
                                     'ISOPOOH_OH      ', 'ISOPO2_CH3O2    ', 'ISOPO2_CH3CO3   ', 'ISOPNO3_NO      ', &
                                     'ISOPNO3_NO3     ', 'ISOPNO3_HO2     ', 'BIGALK_OH       ', 'ONITR_OH        ', &
                                     'ONITR_NO3       ', 'HYDRALD_OH      ', 'ALKO2_NO        ', 'ALKO2_HO2       ', &
                                     'ALKOOH_OH       ', 'XO2_NO          ', 'XO2_NO3         ', 'XO2_HO2         ', &
                                     'XO2_CH3O2       ', 'XO2_CH3CO3      ', 'XOOH_OHa        ', 'usr_XOOH_OH     ', &
                                     'TOLUENE_OH      ', 'TOLO2_NO        ', 'TOLO2_HO2       ', 'TOLO2_OH        ', &
                                     'CRESOL_OH       ', 'XOH_NO2         ', 'BENZENE_OH      ', 'BENO2_HO2       ', &
                                     'BENO2_NO        ', 'XYLENE_OH       ', 'XYLO2_HO2       ', 'XYLO2_NO        ', &
                                     'C10H16_OH       ', 'C10H16_O3       ', 'C10H16_NO3      ', 'TERPO2_NO       ', &
                                     'TERPO2_HO2      ', 'TERPOOH_OH      ', 'usr_N2O5_aer    ', 'usr_NO3_aer     ', &
                                     'usr_NO2_aer     ', 'CB1_CB2         ', 'OC1_OC2         ', 'usr_HO2_aer     ', &
                                     'usr_CB1_strat_ta', 'usr_CB2_strat_ta', 'usr_OC1_strat_ta', 'usr_OC2_strat_ta', &
                                     'usr_SO4_strat_ta', 'usr_SOAM_strat_t', 'usr_SOAI_strat_t', 'usr_SOAB_strat_t', &
                                     'usr_SOAT_strat_t', 'usr_SOAX_strat_t', 'usr_NH4_strat_ta', 'usr_NH4NO3_strat', &
                                     'usr_SSLT01_strat', 'usr_SSLT02_strat', 'usr_SSLT03_strat', 'usr_SSLT04_strat', &
                                     'usr_DST01_strat_', 'usr_DST02_strat_', 'usr_DST03_strat_', 'usr_DST04_strat_', &
                                     'OCS_O           ', 'OCS_OH          ', 'S_OH            ', 'S_O2            ', &
                                     'S_O3            ', 'SO_OH           ', 'SO_O2           ', 'SO_O3           ', &
                                     'SO_NO2          ', 'SO_CLO          ', 'SO_BRO          ', 'SO_OCLO         ', &
                                     'usr_SO2_OH      ', 'usr_SO3_H2O     ', 'DMS_OHa         ', 'usr_DMS_OH      ', &
                                     'DMS_NO3         ', 'het1            ', 'het2            ', 'het3            ', &
                                     'het4            ', 'het5            ', 'het6            ', 'het7            ', &
                                     'het8            ', 'het9            ', 'het10           ', 'het11           ', &
                                     'het12           ', 'het13           ', 'het14           ', 'het15           ', &
                                     'het16           ', 'het17           ', 'ion_Op_O2       ', 'ion_Op_N2       ', &
                                     'ion_N2p_Oa      ', 'ion_N2p_Ob      ', 'ion_Op_CO2      ', 'ion_O2p_N       ', &
                                     'ion_O2p_NO      ', 'ion_Np_O2a      ', 'ion_Np_O2b      ', 'ion_Np_O        ', &
                                     'ion_N2p_O2      ', 'ion_O2p_N2      ', 'elec1           ', 'elec2           ', &
                                     'elec3           ' /)
      rxt_tag_map(:rxt_tag_cnt) = (/    1,   2,   3,   4,   5,   6,   7,   8,   9,  10, &
                                       11,  12,  13,  14,  15,  16,  17,  18,  19,  20, &
                                       21,  22,  23,  24,  25,  26,  27,  28,  29,  30, &
                                       31,  32,  33,  34,  35,  36,  37,  38,  39,  40, &
                                       41,  42,  43,  44,  45,  46,  47,  48,  49,  50, &
                                       51,  52,  53,  54,  55,  56,  57,  58,  59,  60, &
                                       61,  62,  63,  64,  65,  66,  67,  68,  69,  70, &
                                       71,  72,  73,  74,  75,  76,  77,  78,  79,  80, &
                                       81,  82,  83,  84,  85,  86,  87,  88,  89,  90, &
                                       91,  92,  93,  94,  95,  96,  97,  98,  99, 100, &
                                      101, 102, 103, 104, 105, 106, 107, 108, 109, 110, &
                                      111, 112, 113, 114, 115, 116, 117, 118, 119, 120, &
                                      121, 122, 123, 124, 125, 126, 127, 128, 129, 130, &
                                      131, 132, 133, 134, 135, 136, 137, 138, 139, 140, &
                                      141, 142, 143, 144, 145, 146, 147, 148, 149, 150, &
                                      151, 152, 153, 154, 155, 156, 157, 158, 159, 160, &
                                      161, 162, 163, 164, 165, 166, 167, 168, 169, 170, &
                                      171, 172, 173, 174, 175, 176, 177, 178, 179, 180, &
                                      181, 182, 183, 184, 185, 186, 187, 188, 189, 190, &
                                      191, 192, 193, 194, 195, 196, 197, 198, 199, 200, &
                                      201, 202, 203, 204, 205, 206, 207, 208, 209, 210, &
                                      211, 212, 213, 214, 215, 216, 217, 218, 219, 220, &
                                      221, 222, 223, 224, 225, 226, 227, 228, 229, 230, &
                                      231, 232, 233, 234, 235, 236, 237, 238, 239, 240, &
                                      241, 242, 243, 244, 245, 246, 247, 248, 249, 250, &
                                      251, 252, 253, 254, 255, 256, 257, 258, 259, 260, &
                                      261, 262, 263, 264, 265, 266, 267, 268, 269, 270, &
                                      271, 272, 273, 274, 275, 276, 277, 278, 279, 280, &
                                      281, 282, 283, 284, 285, 286, 287, 288, 289, 290, &
                                      291, 292, 293, 294, 295, 296, 297, 298, 299, 300, &
                                      301, 302, 303, 304, 305, 306, 307, 308, 309, 310, &
                                      311, 312, 313, 314, 315, 316, 317, 318, 319, 320, &
                                      321, 322, 323, 324, 325, 326, 327, 328, 329, 330, &
                                      331, 332, 333, 334, 335, 336, 337, 338, 339, 340, &
                                      341, 342, 343, 344, 345, 346, 347, 348, 349, 350, &
                                      351, 352, 353, 354, 355, 356, 357, 358, 359, 360, &
                                      361, 362, 363, 364, 365, 366, 367, 368, 369, 370, &
                                      371, 372, 373, 374, 375, 376, 377, 378, 379, 380, &
                                      381, 382, 383, 384, 385, 386, 387, 388, 389, 390, &
                                      391, 392, 393, 394, 395, 396, 397, 398, 399, 400, &
                                      401, 402, 403, 404, 405, 406, 407, 408, 409, 410, &
                                      411, 412, 413, 414, 415, 416, 417, 418, 419, 420, &
                                      421, 422, 423, 424, 425, 426, 427, 428, 429, 430, &
                                      431, 432, 433, 434, 435, 436, 437, 438, 439, 440, &
                                      441, 442, 443, 444, 445, 446, 447, 448, 449, 450, &
                                      451, 452, 453, 454, 455, 456, 457, 458, 459, 460, &
                                      461, 462, 463, 464, 465, 466, 467, 468, 469, 470, &
                                      471, 472, 473, 474, 475, 476, 477 /)
      if( allocated( pht_alias_lst ) ) then
         deallocate( pht_alias_lst )
      end if
      allocate( pht_alias_lst(phtcnt,2),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate pht_alias_lst; error = ',ios
         call endrun
      end if
      if( allocated( pht_alias_mult ) ) then
         deallocate( pht_alias_mult )
      end if
      allocate( pht_alias_mult(phtcnt,2),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate pht_alias_mult; error = ',ios
         call endrun
      end if
      pht_alias_lst(:,1) = (/ 'userdefined     ', 'userdefined     ', '                ', '                ', &
                              '                ', 'userdefined     ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ' /)
      pht_alias_lst(:,2) = (/ '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', 'jch3ooh         ', 'jh2o2           ', '                ', &
                              'jpan            ', '                ', '                ', '                ', &
                              'jch3ooh         ', 'jch3ooh         ', 'jch3ooh         ', 'jch3ooh         ', &
                              '                ', '                ', 'jch3ooh         ', 'jch3cho         ', &
                              'jch3ooh         ', '                ', '                ', 'jacet           ', &
                              'jno2            ', 'jmgly           ', 'jch3ooh         ', 'jch3ooh         ', &
                              'jch3ooh         ', 'jch3ooh         ', '                ', '                ', &
                              '                ', '                ', '                ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ' /)
      pht_alias_mult(:,1) = (/ 1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8 /)
      pht_alias_mult(:,2) = (/ 1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 0.28_r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          0.2_r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8 /)
      allocate( cph_enthalpy(enthalpy_cnt),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate cph_enthalpy; error = ',ios
         call endrun
      end if
      allocate( cph_rid(enthalpy_cnt),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate cph_rid; error = ',ios
         call endrun
      end if
      cph_rid(:)      = (/             118,            119,            120,            121,            122, &
                                       123,            124,            127,            128,            129, &
                                       131,            132,            133,            163,            164, &
                                       166,            168,            169,            170,            176, &
                                       177,            178,            182,            183,            185, &
                                       186,            191,            192,            193,            463, &
                                       464,            465,            468,            469,            470, &
                                       471,            472,            473,            475,            476, &
                                       477 /)
      cph_enthalpy(:) = (/   101.390000_r8,  392.190000_r8,  493.580000_r8,   62.600000_r8,   62.600000_r8, &
                              62.600000_r8,   62.600000_r8,   94.300000_r8,   94.300000_r8,   94.300000_r8, &
                             189.810000_r8,   32.910000_r8,  189.810000_r8,  203.400000_r8,  194.710000_r8, &
                             232.590000_r8,   67.670000_r8,  165.300000_r8,  293.620000_r8,  226.580000_r8, &
                             120.100000_r8,  165.510000_r8,  177.510000_r8,  229.610000_r8,  133.750000_r8, &
                             313.750000_r8,   34.470000_r8,  199.170000_r8,  193.020000_r8,  150.110000_r8, &
                             105.040000_r8,   67.530000_r8,  406.160000_r8,  271.380000_r8,  239.840000_r8, &
                             646.280000_r8,   95.550000_r8,  339.590000_r8,   82.389000_r8,  508.950000_r8, &
                             354.830000_r8 /)

      end subroutine set_sim_dat

      end module mo_sim_dat
