module dynamics_types

  use shr_kind_mod, only: r8=>shr_kind_r8

  implicit none

  type dyn_import_t
     real(r8), dimension(:,: ),    pointer :: phis   ! Surface geopotential
     real(r8), dimension(:,: ),    pointer :: ps     ! Surface pressure
     real(r8), dimension(:,:,:),   pointer :: u3s    ! U-winds (staggered)
     real(r8), dimension(:,:,:),   pointer :: v3s    ! V-winds (staggered)
     real(r8), dimension(:,:,:),   pointer :: pe     ! Pressure
     real(r8), dimension(:,:,:),   pointer :: pt     ! Potential temperature
     real(r8), dimension(:,:,:),   pointer :: t3     ! Temperatures
     real(r8), dimension(:,:,:),   pointer :: pk     ! Pressure to the kappa
     real(r8), dimension(:,:,:),   pointer :: pkz    ! Pressure to the kappa offset
     real(r8), dimension(:,:,:),   pointer :: delp   ! Delta pressure
     real(r8), dimension(:,:,:,:), pointer :: tracer ! Tracers
  end type dyn_import_t

  type dyn_export_t
     real(r8), dimension(:,: ),    pointer :: phis   ! Surface geopotential
     real(r8), dimension(:,: ),    pointer :: ps     ! Surface pressure
     real(r8), dimension(:,:,:),   pointer :: u3s    ! U-winds (staggered)
     real(r8), dimension(:,:,:),   pointer :: v3s    ! V-winds (staggered)
     real(r8), dimension(:,:,:),   pointer :: pe     ! Pressure
     real(r8), dimension(:,:,:),   pointer :: pt     ! Potential temperature
     real(r8), dimension(:,:,:),   pointer :: t3     ! Temperatures
     real(r8), dimension(:,:,:),   pointer :: pk     ! Pressure to the kappa
     real(r8), dimension(:,:,:),   pointer :: pkz    ! Pressure to the kappa offset
     real(r8), dimension(:,:,:),   pointer :: delp   ! Delta pressure
     real(r8), dimension(:,:,:,:), pointer :: tracer ! Tracers
     real(r8), dimension(:,:,:),   pointer :: peln   !
     real(r8), dimension(:,:,:),   pointer :: omga   ! Vertical velocity
     real(r8), dimension(:,:,:),   pointer :: mfx    ! Mass flux in X
     real(r8), dimension(:,:,:),   pointer :: mfy    ! Mass flux in Y
  end type dyn_export_t

end module dynamics_types
