




      module mo_nln_matrix

      use shr_kind_mod, only : r8 => shr_kind_r8

      private
      public :: nlnmat

      contains

      subroutine nlnmat01( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(1246) = -(rxt(84)*y(2) + rxt(91)*y(3) + rxt(116)*y(19) + rxt(121)*y(20) &
                      + rxt(129)*y(21) + rxt(141)*y(6) + rxt(144)*y(7) + rxt(156) &
                      *y(25) + rxt(183)*y(34) + rxt(236)*y(41) + rxt(257)*y(56) &
                      + rxt(279)*y(74) + rxt(285)*y(75) + rxt(303)*y(80) + rxt(335) &
                      *y(96))
         mat(1135) = -rxt(84)*y(1)
         mat(1109) = -rxt(91)*y(1)
         mat(711) = -rxt(116)*y(1)
         mat(958) = -rxt(121)*y(1)
         mat(1025) = -rxt(129)*y(1)
         mat(1186) = -rxt(141)*y(1)
         mat(843) = -rxt(144)*y(1)
         mat(809) = -rxt(156)*y(1)
         mat(762) = -rxt(183)*y(1)
         mat(162) = -rxt(236)*y(1)
         mat(493) = -rxt(257)*y(1)
         mat(607) = -rxt(279)*y(1)
         mat(561) = -rxt(285)*y(1)
         mat(434) = -rxt(303)*y(1)
         mat(313) = -rxt(335)*y(1)

         mat(1246) = mat(1246) + .100_r8*rxt(303)*y(80) + .200_r8*rxt(279)*y(74) &
                      + .200_r8*rxt(285)*y(75)
         mat(1025) = mat(1025) + .250_r8*rxt(247)*y(45) + .250_r8*rxt(295)*y(73)
         mat(434) = mat(434) + .100_r8*rxt(303)*y(1)
         mat(693) = .250_r8*rxt(247)*y(21)
         mat(607) = mat(607) + .200_r8*rxt(279)*y(1)
         mat(561) = mat(561) + .200_r8*rxt(285)*y(1)
         mat(667) = .250_r8*rxt(295)*y(21)

         mat(1132) = -(rxt(84)*y(1) + 4._r8*rxt(85)*y(2) + rxt(120)*y(20) + rxt(127) &
                      *y(18) + rxt(128)*y(21) + rxt(131)*y(22) + rxt(139)*y(6) &
                      + (rxt(142) + rxt(143)) * y(7) + rxt(150)*y(8) + rxt(163)*y(27) &
                      + rxt(176)*y(30) + rxt(177)*y(31) + rxt(180)*y(32) + rxt(186) &
                      *y(35) + rxt(196)*y(36) + rxt(197)*y(37) + rxt(198)*y(38) &
                      + rxt(216)*y(16) + rxt(350)*y(121))
         mat(1243) = -rxt(84)*y(2)
         mat(955) = -rxt(120)*y(2)
         mat(515) = -rxt(127)*y(2)
         mat(1022) = -rxt(128)*y(2)
         mat(304) = -rxt(131)*y(2)
         mat(1183) = -rxt(139)*y(2)
         mat(840) = -(rxt(142) + rxt(143)) * y(2)
         mat(1086) = -rxt(150)*y(2)
         mat(863) = -rxt(163)*y(2)
         mat(1044) = -rxt(176)*y(2)
         mat(442) = -rxt(177)*y(2)
         mat(454) = -rxt(180)*y(2)
         mat(1204) = -rxt(186)*y(2)
         mat(400) = -rxt(196)*y(2)
         mat(386) = -rxt(197)*y(2)
         mat(267) = -rxt(198)*y(2)
         mat(779) = -rxt(216)*y(2)
         mat(96) = -rxt(350)*y(2)

         mat(85) = rxt(135)*y(6) + rxt(136)*y(7)
         mat(1183) = mat(1183) + rxt(135)*y(5)
         mat(840) = mat(840) + rxt(136)*y(5)
         mat(955) = mat(955) + 2.000_r8*rxt(123)*y(20)
         mat(710) = rxt(119)*y(21)
         mat(1022) = mat(1022) + rxt(119)*y(19)

         mat(1105) = -(rxt(88)*y(161) + rxt(91)*y(1) + rxt(111)*y(18) + rxt(112)*y(30) &
                      + rxt(113)*y(36) + rxt(114)*y(39))
         mat(700) = -rxt(88)*y(3)
         mat(1242) = -rxt(91)*y(3)
         mat(514) = -rxt(111)*y(3)
         mat(1043) = -rxt(112)*y(3)
         mat(399) = -rxt(113)*y(3)
         mat(90) = -rxt(114)*y(3)

         mat(508) = -(rxt(111)*y(3) + rxt(125)*y(20) + rxt(127)*y(2) + rxt(157)*y(25))
         mat(1092) = -rxt(111)*y(18)
         mat(929) = -rxt(125)*y(18)
         mat(1118) = -rxt(127)*y(18)
         mat(789) = -rxt(157)*y(18)

         mat(702) = rxt(118)*y(21)
         mat(996) = rxt(118)*y(19)

         mat(516) = -((rxt(212) + rxt(213)) * y(20))
         mat(930) = -(rxt(212) + rxt(213)) * y(17)

         mat(1218) = .560_r8*rxt(257)*y(56) + .300_r8*rxt(303)*y(80) &
                      + .500_r8*rxt(236)*y(41) + .050_r8*rxt(279)*y(74) &
                      + .200_r8*rxt(285)*y(75)
         mat(1119) = rxt(216)*y(16) + rxt(350)*y(121)
         mat(1158) = .220_r8*rxt(286)*y(76) + .500_r8*rxt(321)*y(88)
         mat(930) = mat(930) + rxt(215)*y(16) + rxt(252)*y(50) + rxt(273)*y(65) &
                      + .350_r8*rxt(229)*y(118) + rxt(351)*y(121)
         mat(1062) = rxt(214)*y(16) + .220_r8*rxt(288)*y(76) + rxt(274)*y(65) &
                      + .500_r8*rxt(322)*y(88)
         mat(722) = .110_r8*rxt(290)*y(76) + .200_r8*rxt(324)*y(88)
         mat(767) = rxt(216)*y(2) + rxt(215)*y(20) + rxt(214)*y(8) + rxt(161)*y(25) &
                      + rxt(185)*y(34)
         mat(790) = rxt(161)*y(16)
         mat(750) = rxt(185)*y(16)
         mat(481) = .560_r8*rxt(257)*y(1)
         mat(423) = .300_r8*rxt(303)*y(1)
         mat(674) = .220_r8*rxt(291)*y(76) + .500_r8*rxt(325)*y(88)
         mat(158) = .500_r8*rxt(236)*y(1)
         mat(315) = rxt(252)*y(20)
         mat(591) = .050_r8*rxt(279)*y(1)
         mat(550) = .200_r8*rxt(285)*y(1)
         mat(612) = .220_r8*rxt(286)*y(6) + .220_r8*rxt(288)*y(8) + .110_r8*rxt(290) &
                      *y(13) + .220_r8*rxt(291)*y(45)
         mat(563) = rxt(273)*y(20) + rxt(274)*y(8)
         mat(576) = .500_r8*rxt(321)*y(6) + .500_r8*rxt(322)*y(8) + .200_r8*rxt(324) &
                      *y(13) + .500_r8*rxt(325)*y(45)
         mat(74) = .350_r8*rxt(229)*y(20)
         mat(93) = rxt(350)*y(2) + rxt(351)*y(20)

         mat(83) = -(rxt(135)*y(6) + (rxt(136) + rxt(137) + rxt(138)) * y(7))
         mat(1136) = -rxt(135)*y(5)
         mat(811) = -(rxt(136) + rxt(137) + rxt(138)) * y(5)

         mat(1184) = -(rxt(135)*y(5) + rxt(139)*y(2) + rxt(140)*y(21) + rxt(141)*y(1) &
                      + rxt(149)*y(8) + rxt(168)*y(27) + rxt(189)*y(35) + rxt(218) &
                      *y(13) + rxt(226)*y(120) + rxt(232)*y(52) + rxt(238)*y(43) &
                      + rxt(245)*y(45) + rxt(259)*y(58) + rxt(264)*y(61) + rxt(268) &
                      *y(64) + rxt(277)*y(70) + rxt(281)*y(71) + (rxt(286) + rxt(287) &
                      ) * y(76) + rxt(293)*y(73) + rxt(305)*y(85) + rxt(311)*y(86) &
                      + rxt(318)*y(81) + rxt(321)*y(88) + rxt(329)*y(93) + rxt(337) &
                      *y(97))
         mat(86) = -rxt(135)*y(6)
         mat(1133) = -rxt(139)*y(6)
         mat(1023) = -rxt(140)*y(6)
         mat(1244) = -rxt(141)*y(6)
         mat(1087) = -rxt(149)*y(6)
         mat(864) = -rxt(168)*y(6)
         mat(1205) = -rxt(189)*y(6)
         mat(747) = -rxt(218)*y(6)
         mat(213) = -rxt(226)*y(6)
         mat(293) = -rxt(232)*y(6)
         mat(378) = -rxt(238)*y(6)
         mat(692) = -rxt(245)*y(6)
         mat(413) = -rxt(259)*y(6)
         mat(367) = -rxt(264)*y(6)
         mat(532) = -rxt(268)*y(6)
         mat(146) = -rxt(277)*y(6)
         mat(336) = -rxt(281)*y(6)
         mat(627) = -(rxt(286) + rxt(287)) * y(6)
         mat(666) = -rxt(293)*y(6)
         mat(649) = -rxt(305)*y(6)
         mat(507) = -rxt(311)*y(6)
         mat(351) = -rxt(318)*y(6)
         mat(589) = -rxt(321)*y(6)
         mat(246) = -rxt(329)*y(6)
         mat(476) = -rxt(337)*y(6)

         mat(1133) = mat(1133) + rxt(142)*y(7)
         mat(86) = mat(86) + 2.000_r8*rxt(137)*y(7)
         mat(841) = rxt(142)*y(2) + 2.000_r8*rxt(137)*y(5)

         mat(833) = -((rxt(136) + rxt(137) + rxt(138)) * y(5) + (rxt(142) + rxt(143) &
                      ) * y(2) + rxt(144)*y(1) + rxt(145)*y(8) + rxt(147)*y(20) &
                      + rxt(153)*y(21) + rxt(169)*y(27) + rxt(190)*y(35) + rxt(246) &
                      *y(45) + rxt(299)*y(73) + rxt(333)*y(95))
         mat(84) = -(rxt(136) + rxt(137) + rxt(138)) * y(7)
         mat(1125) = -(rxt(142) + rxt(143)) * y(7)
         mat(1236) = -rxt(144)*y(7)
         mat(1079) = -rxt(145)*y(7)
         mat(948) = -rxt(147)*y(7)
         mat(1015) = -rxt(153)*y(7)
         mat(856) = -rxt(169)*y(7)
         mat(1197) = -rxt(190)*y(7)
         mat(688) = -rxt(246)*y(7)
         mat(662) = -rxt(299)*y(7)
         mat(81) = -rxt(333)*y(7)

         mat(1236) = mat(1236) + rxt(141)*y(6)
         mat(1125) = mat(1125) + rxt(139)*y(6) + rxt(150)*y(8)
         mat(1176) = rxt(141)*y(1) + rxt(139)*y(2) + 2.000_r8*rxt(149)*y(8) + rxt(218) &
                      *y(13) + rxt(140)*y(21) + rxt(168)*y(27) + rxt(189)*y(35) &
                      + rxt(264)*y(61) + rxt(245)*y(45) + rxt(277)*y(70) &
                      + .900_r8*rxt(318)*y(81) + rxt(281)*y(71) + .900_r8*rxt(329) &
                      *y(93) + rxt(337)*y(97) + .920_r8*rxt(305)*y(85) + rxt(286) &
                      *y(76) + rxt(293)*y(73) + rxt(238)*y(43) + rxt(259)*y(58) &
                      + rxt(232)*y(52) + rxt(268)*y(64) + 1.206_r8*rxt(311)*y(86) &
                      + rxt(321)*y(88) + rxt(226)*y(120)
         mat(833) = mat(833) + .700_r8*rxt(333)*y(95)
         mat(948) = mat(948) + rxt(151)*y(8) + rxt(154)*y(10) + rxt(275)*y(79) &
                      + .400_r8*rxt(315)*y(87)
         mat(1079) = mat(1079) + rxt(150)*y(2) + 2.000_r8*rxt(149)*y(6) + rxt(151) &
                      *y(20) + rxt(152)*y(21) + rxt(306)*y(85) + rxt(288)*y(76) &
                      + rxt(294)*y(73) + rxt(336)*y(96) + 1.206_r8*rxt(312)*y(86) &
                      + rxt(316)*y(87) + rxt(322)*y(88)
         mat(191) = rxt(154)*y(20)
         mat(739) = rxt(218)*y(6)
         mat(1015) = mat(1015) + rxt(140)*y(6) + rxt(152)*y(8) + .206_r8*rxt(313) &
                      *y(86)
         mat(856) = mat(856) + rxt(168)*y(6)
         mat(1197) = mat(1197) + rxt(189)*y(6)
         mat(364) = rxt(264)*y(6)
         mat(688) = mat(688) + rxt(245)*y(6)
         mat(177) = rxt(275)*y(20)
         mat(144) = rxt(277)*y(6)
         mat(348) = .900_r8*rxt(318)*y(6)
         mat(333) = rxt(281)*y(6)
         mat(243) = .900_r8*rxt(329)*y(6)
         mat(81) = mat(81) + .700_r8*rxt(333)*y(7)
         mat(473) = rxt(337)*y(6)
         mat(645) = .920_r8*rxt(305)*y(6) + rxt(306)*y(8)
         mat(623) = rxt(286)*y(6) + rxt(288)*y(8)
         mat(662) = mat(662) + rxt(293)*y(6) + rxt(294)*y(8)
         mat(375) = rxt(238)*y(6)
         mat(309) = rxt(336)*y(8)
         mat(410) = rxt(259)*y(6)
         mat(290) = rxt(232)*y(6)
         mat(529) = rxt(268)*y(6)
         mat(503) = 1.206_r8*rxt(311)*y(6) + 1.206_r8*rxt(312)*y(8) + .206_r8*rxt(313) &
                      *y(21)
         mat(460) = .400_r8*rxt(315)*y(20) + rxt(316)*y(8)
         mat(585) = rxt(321)*y(6) + rxt(322)*y(8)
         mat(210) = rxt(226)*y(6)


      end subroutine nlnmat01

      subroutine nlnmat02( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(950) = -(rxt(120)*y(2) + rxt(121)*y(1) + rxt(122)*y(21) + (4._r8*rxt(123) &
                      + 4._r8*rxt(124)) * y(20) + rxt(125)*y(18) + rxt(126)*y(22) &
                      + rxt(132)*y(39) + rxt(133)*y(40) + rxt(147)*y(7) + rxt(148) &
                      *y(9) + rxt(151)*y(8) + rxt(154)*y(10) + (rxt(164) + rxt(165) &
                      ) * y(27) + rxt(175)*y(30) + rxt(179)*y(31) + rxt(181)*y(32) &
                      + rxt(187)*y(35) + rxt(195)*y(36) + (rxt(212) + rxt(213) &
                      ) * y(17) + rxt(215)*y(16) + rxt(222)*y(15) + rxt(223)*y(14) &
                      + rxt(224)*y(119) + rxt(229)*y(118) + rxt(230)*y(42) + rxt(231) &
                      *y(41) + rxt(237)*y(46) + rxt(242)*y(44) + rxt(243)*y(47) &
                      + rxt(250)*y(51) + rxt(251)*y(49) + rxt(252)*y(50) + rxt(253) &
                      *y(48) + rxt(255)*y(55) + rxt(256)*y(56) + rxt(262)*y(59) &
                      + rxt(263)*y(57) + rxt(266)*y(62) + rxt(267)*y(60) + rxt(271) &
                      *y(66) + rxt(272)*y(63) + rxt(273)*y(65) + rxt(275)*y(79) &
                      + rxt(276)*y(67) + rxt(278)*y(74) + rxt(280)*y(69) + rxt(283) &
                      *y(72) + rxt(284)*y(75) + rxt(292)*y(77) + rxt(301)*y(78) &
                      + rxt(302)*y(80) + rxt(308)*y(90) + rxt(314)*y(68) + rxt(315) &
                      *y(87) + rxt(317)*y(84) + rxt(320)*y(82) + rxt(326)*y(89) &
                      + rxt(328)*y(91) + rxt(331)*y(94) + rxt(332)*y(92) + rxt(334) &
                      *y(96) + rxt(339)*y(98) + rxt(344)*y(122) + (rxt(345) + rxt(346) &
                      ) * y(123) + rxt(348)*y(124) + rxt(351)*y(121))
         mat(1127) = -rxt(120)*y(20)
         mat(1238) = -rxt(121)*y(20)
         mat(1017) = -rxt(122)*y(20)
         mat(512) = -rxt(125)*y(20)
         mat(301) = -rxt(126)*y(20)
         mat(88) = -rxt(132)*y(20)
         mat(45) = -rxt(133)*y(20)
         mat(835) = -rxt(147)*y(20)
         mat(417) = -rxt(148)*y(20)
         mat(1081) = -rxt(151)*y(20)
         mat(192) = -rxt(154)*y(20)
         mat(858) = -(rxt(164) + rxt(165)) * y(20)
         mat(1039) = -rxt(175)*y(20)
         mat(440) = -rxt(179)*y(20)
         mat(451) = -rxt(181)*y(20)
         mat(1199) = -rxt(187)*y(20)
         mat(398) = -rxt(195)*y(20)
         mat(518) = -(rxt(212) + rxt(213)) * y(20)
         mat(774) = -rxt(215)*y(20)
         mat(236) = -rxt(222)*y(20)
         mat(200) = -rxt(223)*y(20)
         mat(181) = -rxt(224)*y(20)
         mat(75) = -rxt(229)*y(20)
         mat(124) = -rxt(230)*y(20)
         mat(160) = -rxt(231)*y(20)
         mat(297) = -rxt(237)*y(20)
         mat(134) = -rxt(242)*y(20)
         mat(547) = -rxt(243)*y(20)
         mat(233) = -rxt(250)*y(20)
         mat(392) = -rxt(251)*y(20)
         mat(316) = -rxt(252)*y(20)
         mat(108) = -rxt(253)*y(20)
         mat(226) = -rxt(255)*y(20)
         mat(489) = -rxt(256)*y(20)
         mat(167) = -rxt(262)*y(20)
         mat(53) = -rxt(263)*y(20)
         mat(283) = -rxt(266)*y(20)
         mat(357) = -rxt(267)*y(20)
         mat(174) = -rxt(271)*y(20)
         mat(537) = -rxt(272)*y(20)
         mat(569) = -rxt(273)*y(20)
         mat(178) = -rxt(275)*y(20)
         mat(40) = -rxt(276)*y(20)
         mat(603) = -rxt(278)*y(20)
         mat(205) = -rxt(280)*y(20)
         mat(151) = -rxt(283)*y(20)
         mat(559) = -rxt(284)*y(20)
         mat(129) = -rxt(292)*y(20)
         mat(274) = -rxt(301)*y(20)
         mat(431) = -rxt(302)*y(20)
         mat(259) = -rxt(308)*y(20)
         mat(37) = -rxt(314)*y(20)
         mat(461) = -rxt(315)*y(20)
         mat(154) = -rxt(317)*y(20)
         mat(327) = -rxt(320)*y(20)
         mat(139) = -rxt(326)*y(20)
         mat(57) = -rxt(328)*y(20)
         mat(188) = -rxt(331)*y(20)
         mat(61) = -rxt(332)*y(20)
         mat(310) = -rxt(334)*y(20)
         mat(219) = -rxt(339)*y(20)
         mat(67) = -rxt(344)*y(20)
         mat(100) = -(rxt(345) + rxt(346)) * y(20)
         mat(43) = -rxt(348)*y(20)
         mat(95) = -rxt(351)*y(20)

         mat(1238) = mat(1238) + rxt(116)*y(19) + rxt(129)*y(21) + .330_r8*rxt(257) &
                      *y(56) + .270_r8*rxt(303)*y(80) + .120_r8*rxt(236)*y(41) &
                      + .080_r8*rxt(279)*y(74) + .215_r8*rxt(285)*y(75) &
                      + .700_r8*rxt(335)*y(96)
         mat(1127) = mat(1127) + rxt(127)*y(18) + rxt(216)*y(16) + rxt(128)*y(21) &
                      + rxt(131)*y(22) + rxt(176)*y(30) + rxt(177)*y(31) + rxt(196) &
                      *y(36) + rxt(197)*y(37)
         mat(1101) = rxt(111)*y(18) + rxt(114)*y(39) + 2.000_r8*rxt(88)*y(161) &
                      + rxt(112)*y(30) + rxt(113)*y(36)
         mat(512) = mat(512) + rxt(127)*y(2) + rxt(111)*y(3)
         mat(1178) = rxt(140)*y(21)
         mat(950) = mat(950) + .300_r8*rxt(223)*y(14) + .500_r8*rxt(266)*y(62) &
                      + .100_r8*rxt(292)*y(77) + .500_r8*rxt(242)*y(44) &
                      + .650_r8*rxt(229)*y(118)
         mat(1081) = mat(1081) + rxt(152)*y(21)
         mat(200) = mat(200) + .300_r8*rxt(223)*y(20)
         mat(88) = mat(88) + rxt(114)*y(3)
         mat(774) = mat(774) + rxt(216)*y(2)
         mat(706) = rxt(116)*y(1) + 2.000_r8*rxt(117)*y(21)
         mat(1017) = mat(1017) + rxt(129)*y(1) + rxt(128)*y(2) + rxt(140)*y(6) &
                      + rxt(152)*y(8) + 2.000_r8*rxt(117)*y(19) + rxt(160)*y(25)
         mat(301) = mat(301) + rxt(131)*y(2)
         mat(698) = 2.000_r8*rxt(88)*y(3)
         mat(801) = rxt(160)*y(21)
         mat(1039) = mat(1039) + rxt(176)*y(2) + rxt(112)*y(3)
         mat(440) = mat(440) + rxt(177)*y(2)
         mat(398) = mat(398) + rxt(196)*y(2) + rxt(113)*y(3)
         mat(384) = rxt(197)*y(2)
         mat(489) = mat(489) + .330_r8*rxt(257)*y(1)
         mat(431) = mat(431) + .270_r8*rxt(303)*y(1)
         mat(283) = mat(283) + .500_r8*rxt(266)*y(20)
         mat(160) = mat(160) + .120_r8*rxt(236)*y(1)
         mat(603) = mat(603) + .080_r8*rxt(279)*y(1)
         mat(559) = mat(559) + .215_r8*rxt(285)*y(1)
         mat(129) = mat(129) + .100_r8*rxt(292)*y(20)
         mat(134) = mat(134) + .500_r8*rxt(242)*y(20)
         mat(310) = mat(310) + .700_r8*rxt(335)*y(1)
         mat(75) = mat(75) + .650_r8*rxt(229)*y(20)

         mat(1084) = -(rxt(145)*y(7) + rxt(149)*y(6) + rxt(150)*y(2) + rxt(151)*y(20) &
                      + rxt(152)*y(21) + rxt(214)*y(16) + rxt(244)*y(47) + rxt(258) &
                      *y(56) + rxt(274)*y(65) + rxt(288)*y(76) + rxt(294)*y(73) &
                      + rxt(304)*y(80) + rxt(306)*y(85) + rxt(312)*y(86) + rxt(316) &
                      *y(87) + rxt(322)*y(88) + rxt(336)*y(96) + rxt(347)*y(123))
         mat(838) = -rxt(145)*y(8)
         mat(1181) = -rxt(149)*y(8)
         mat(1130) = -rxt(150)*y(8)
         mat(953) = -rxt(151)*y(8)
         mat(1020) = -rxt(152)*y(8)
         mat(777) = -rxt(214)*y(8)
         mat(549) = -rxt(244)*y(8)
         mat(491) = -rxt(258)*y(8)
         mat(571) = -rxt(274)*y(8)
         mat(626) = -rxt(288)*y(8)
         mat(665) = -rxt(294)*y(8)
         mat(433) = -rxt(304)*y(8)
         mat(648) = -rxt(306)*y(8)
         mat(506) = -rxt(312)*y(8)
         mat(463) = -rxt(316)*y(8)
         mat(588) = -rxt(322)*y(8)
         mat(312) = -rxt(336)*y(8)
         mat(102) = -rxt(347)*y(8)

         mat(1241) = rxt(144)*y(7)
         mat(1130) = mat(1130) + rxt(143)*y(7) + rxt(180)*y(32) + rxt(198)*y(38)
         mat(838) = mat(838) + rxt(144)*y(1) + rxt(143)*y(2)
         mat(953) = mat(953) + rxt(148)*y(9) + rxt(181)*y(32) + rxt(255)*y(55) &
                      + .500_r8*rxt(301)*y(78)
         mat(418) = rxt(148)*y(20)
         mat(804) = rxt(182)*y(32)
         mat(453) = rxt(180)*y(2) + rxt(181)*y(20) + rxt(182)*y(25)
         mat(266) = rxt(198)*y(2)
         mat(227) = rxt(255)*y(20)
         mat(276) = .500_r8*rxt(301)*y(20)

         mat(414) = -(rxt(148)*y(20))
         mat(921) = -rxt(148)*y(9)

         mat(820) = rxt(147)*y(20)
         mat(921) = mat(921) + rxt(147)*y(7)
         mat(1056) = rxt(214)*y(16) + rxt(244)*y(47) + rxt(274)*y(65) + rxt(347) &
                      *y(123)
         mat(765) = rxt(214)*y(8)
         mat(1029) = (rxt(355)+rxt(360)+rxt(366))*y(32)
         mat(444) = (rxt(355)+rxt(360)+rxt(366))*y(30)
         mat(539) = rxt(244)*y(8)
         mat(562) = rxt(274)*y(8)
         mat(99) = rxt(347)*y(8)

         mat(189) = -(rxt(154)*y(20))
         mat(895) = -rxt(154)*y(10)

         mat(813) = rxt(153)*y(21)
         mat(969) = rxt(153)*y(7)


         mat(812) = rxt(145)*y(8)
         mat(1050) = rxt(145)*y(7)

         mat(736) = -(rxt(167)*y(27) + rxt(218)*y(6) + rxt(219)*y(21) + (4._r8*rxt(220) &
                      + 4._r8*rxt(221)) * y(13) + rxt(240)*y(43) + rxt(248)*y(45) &
                      + rxt(261)*y(58) + rxt(270)*y(64) + rxt(290)*y(76) + rxt(296) &
                      *y(73) + rxt(309)*y(85) + rxt(324)*y(88))
         mat(852) = -rxt(167)*y(13)
         mat(1172) = -rxt(218)*y(13)
         mat(1011) = -rxt(219)*y(13)
         mat(373) = -rxt(240)*y(13)
         mat(686) = -rxt(248)*y(13)
         mat(408) = -rxt(261)*y(13)
         mat(527) = -rxt(270)*y(13)
         mat(621) = -rxt(290)*y(13)
         mat(660) = -rxt(296)*y(13)
         mat(643) = -rxt(309)*y(13)
         mat(583) = -rxt(324)*y(13)

         mat(1232) = .310_r8*rxt(257)*y(56)
         mat(1172) = mat(1172) + rxt(245)*y(45)
         mat(944) = .700_r8*rxt(223)*y(14) + rxt(237)*y(46)
         mat(736) = mat(736) + .900_r8*rxt(248)*y(45)
         mat(198) = .700_r8*rxt(223)*y(20)
         mat(486) = .310_r8*rxt(257)*y(1)
         mat(296) = rxt(237)*y(20)
         mat(686) = mat(686) + rxt(245)*y(6) + .900_r8*rxt(248)*y(13) &
                      + 4.000_r8*rxt(249)*y(45) + rxt(310)*y(85) + rxt(291)*y(76) &
                      + rxt(297)*y(73) + rxt(325)*y(88)
         mat(643) = mat(643) + rxt(310)*y(45)
         mat(621) = mat(621) + rxt(291)*y(45)
         mat(660) = mat(660) + rxt(297)*y(45)
         mat(583) = mat(583) + rxt(325)*y(45)


      end subroutine nlnmat02

      subroutine nlnmat03( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(195) = -(rxt(223)*y(20))
         mat(896) = -rxt(223)*y(14)

         mat(714) = rxt(219)*y(21)
         mat(970) = rxt(219)*y(13)

         mat(87) = -(rxt(114)*y(3) + rxt(132)*y(20))
         mat(1090) = -rxt(114)*y(39)
         mat(878) = -rxt(132)*y(39)

         mat(44) = -(rxt(133)*y(20))
         mat(871) = -rxt(133)*y(40)

         mat(771) = -(rxt(161)*y(25) + rxt(185)*y(34) + rxt(214)*y(8) + rxt(215)*y(20) &
                      + rxt(216)*y(2) + rxt(217)*y(21))
         mat(797) = -rxt(161)*y(16)
         mat(754) = -rxt(185)*y(16)
         mat(1077) = -rxt(214)*y(16)
         mat(946) = -rxt(215)*y(16)
         mat(1123) = -rxt(216)*y(16)
         mat(1013) = -rxt(217)*y(16)

         mat(1234) = .540_r8*rxt(257)*y(56) + .600_r8*rxt(303)*y(80) + rxt(236)*y(41) &
                      + .800_r8*rxt(279)*y(74) + .700_r8*rxt(285)*y(75)
         mat(1174) = rxt(218)*y(13) + rxt(264)*y(61) + .500_r8*rxt(277)*y(70) &
                      + .100_r8*rxt(318)*y(81) + .510_r8*rxt(305)*y(85) &
                      + .250_r8*rxt(286)*y(76) + rxt(293)*y(73) + .500_r8*rxt(232) &
                      *y(52) + rxt(268)*y(64) + .072_r8*rxt(311)*y(86)
         mat(946) = mat(946) + .300_r8*rxt(223)*y(14) + .500_r8*rxt(250)*y(51) &
                      + rxt(255)*y(55) + .500_r8*rxt(301)*y(78) + rxt(222)*y(15) &
                      + .800_r8*rxt(251)*y(49)
         mat(1077) = mat(1077) + .600_r8*rxt(306)*y(85) + .250_r8*rxt(288)*y(76) &
                      + rxt(294)*y(73) + .072_r8*rxt(312)*y(86)
         mat(737) = rxt(218)*y(6) + (4.000_r8*rxt(220)+2.000_r8*rxt(221))*y(13) &
                      + rxt(167)*y(27) + rxt(248)*y(45) + 1.200_r8*rxt(309)*y(85) &
                      + .880_r8*rxt(290)*y(76) + 2.000_r8*rxt(296)*y(73) &
                      + .700_r8*rxt(240)*y(43) + rxt(261)*y(58) + .800_r8*rxt(270) &
                      *y(64) + .700_r8*rxt(324)*y(88)
         mat(199) = .300_r8*rxt(223)*y(20)
         mat(1013) = mat(1013) + .008_r8*rxt(313)*y(86)
         mat(854) = rxt(167)*y(13)
         mat(487) = .540_r8*rxt(257)*y(1)
         mat(430) = .600_r8*rxt(303)*y(1)
         mat(363) = rxt(264)*y(6)
         mat(687) = rxt(248)*y(13) + .600_r8*rxt(310)*y(85) + .250_r8*rxt(291)*y(76) &
                      + rxt(297)*y(73)
         mat(232) = .500_r8*rxt(250)*y(20)
         mat(224) = rxt(255)*y(20)
         mat(159) = rxt(236)*y(1)
         mat(272) = .500_r8*rxt(301)*y(20)
         mat(143) = .500_r8*rxt(277)*y(6)
         mat(347) = .100_r8*rxt(318)*y(6)
         mat(644) = .510_r8*rxt(305)*y(6) + .600_r8*rxt(306)*y(8) + 1.200_r8*rxt(309) &
                      *y(13) + .600_r8*rxt(310)*y(45)
         mat(601) = .800_r8*rxt(279)*y(1)
         mat(558) = .700_r8*rxt(285)*y(1)
         mat(622) = .250_r8*rxt(286)*y(6) + .250_r8*rxt(288)*y(8) + .880_r8*rxt(290) &
                      *y(13) + .250_r8*rxt(291)*y(45)
         mat(661) = rxt(293)*y(6) + rxt(294)*y(8) + 2.000_r8*rxt(296)*y(13) + rxt(297) &
                      *y(45) + 4.000_r8*rxt(298)*y(73)
         mat(374) = .700_r8*rxt(240)*y(13)
         mat(409) = rxt(261)*y(13)
         mat(235) = rxt(222)*y(20)
         mat(391) = .800_r8*rxt(251)*y(20)
         mat(289) = .500_r8*rxt(232)*y(6)
         mat(528) = rxt(268)*y(6) + .800_r8*rxt(270)*y(13)
         mat(502) = .072_r8*rxt(311)*y(6) + .072_r8*rxt(312)*y(8) + .008_r8*rxt(313) &
                      *y(21)
         mat(584) = .700_r8*rxt(324)*y(13)

         mat(704) = -(rxt(116)*y(1) + (rxt(117) + rxt(118) + rxt(119)) * y(21))
         mat(1231) = -rxt(116)*y(19)
         mat(1010) = -(rxt(117) + rxt(118) + rxt(119)) * y(19)

         mat(1121) = rxt(127)*y(18) + rxt(120)*y(20)
         mat(1094) = rxt(111)*y(18)
         mat(510) = rxt(127)*y(2) + rxt(111)*y(3) + rxt(125)*y(20) + rxt(157)*y(25)
         mat(517) = rxt(212)*y(20)
         mat(943) = rxt(120)*y(2) + rxt(125)*y(18) + rxt(212)*y(17) + rxt(215)*y(16) &
                      + rxt(351)*y(121)
         mat(769) = rxt(215)*y(20)
         mat(794) = rxt(157)*y(18)
         mat(94) = rxt(351)*y(20)

         mat(1018) = -((rxt(117) + rxt(118) + rxt(119)) * y(19) + rxt(122)*y(20) &
                      + rxt(128)*y(2) + rxt(129)*y(1) + 4._r8*rxt(130)*y(21) + rxt(140) &
                      *y(6) + rxt(152)*y(8) + rxt(153)*y(7) + (rxt(159) + rxt(160) &
                      ) * y(25) + rxt(166)*y(27) + rxt(184)*y(34) + rxt(188)*y(35) &
                      + rxt(217)*y(16) + rxt(219)*y(13) + rxt(227)*y(120) + rxt(233) &
                      *y(52) + rxt(239)*y(43) + rxt(247)*y(45) + rxt(260)*y(58) &
                      + rxt(265)*y(61) + rxt(269)*y(64) + rxt(282)*y(71) + rxt(289) &
                      *y(76) + rxt(295)*y(73) + rxt(307)*y(85) + rxt(313)*y(86) &
                      + rxt(319)*y(81) + rxt(323)*y(88) + rxt(330)*y(93) + rxt(338) &
                      *y(97))
         mat(707) = -(rxt(117) + rxt(118) + rxt(119)) * y(21)
         mat(951) = -rxt(122)*y(21)
         mat(1128) = -rxt(128)*y(21)
         mat(1239) = -rxt(129)*y(21)
         mat(1179) = -rxt(140)*y(21)
         mat(1082) = -rxt(152)*y(21)
         mat(836) = -rxt(153)*y(21)
         mat(802) = -(rxt(159) + rxt(160)) * y(21)
         mat(859) = -rxt(166)*y(21)
         mat(757) = -rxt(184)*y(21)
         mat(1200) = -rxt(188)*y(21)
         mat(775) = -rxt(217)*y(21)
         mat(742) = -rxt(219)*y(21)
         mat(212) = -rxt(227)*y(21)
         mat(292) = -rxt(233)*y(21)
         mat(377) = -rxt(239)*y(21)
         mat(690) = -rxt(247)*y(21)
         mat(412) = -rxt(260)*y(21)
         mat(366) = -rxt(265)*y(21)
         mat(531) = -rxt(269)*y(21)
         mat(335) = -rxt(282)*y(21)
         mat(625) = -rxt(289)*y(21)
         mat(664) = -rxt(295)*y(21)
         mat(647) = -rxt(307)*y(21)
         mat(505) = -rxt(313)*y(21)
         mat(350) = -rxt(319)*y(21)
         mat(587) = -rxt(323)*y(21)
         mat(245) = -rxt(330)*y(21)
         mat(475) = -rxt(338)*y(21)

         mat(1239) = mat(1239) + rxt(121)*y(20) + .190_r8*rxt(257)*y(56) &
                      + .060_r8*rxt(303)*y(80) + .120_r8*rxt(236)*y(41) &
                      + .060_r8*rxt(279)*y(74) + .275_r8*rxt(285)*y(75) + rxt(335) &
                      *y(96)
         mat(1128) = mat(1128) + rxt(216)*y(16) + rxt(131)*y(22)
         mat(519) = rxt(213)*y(20)
         mat(1179) = mat(1179) + rxt(218)*y(13) + rxt(264)*y(61) + rxt(277)*y(70) &
                      + .900_r8*rxt(318)*y(81) + .900_r8*rxt(329)*y(93) + rxt(337) &
                      *y(97) + rxt(305)*y(85) + .470_r8*rxt(286)*y(76) + rxt(238) &
                      *y(43) + rxt(259)*y(58) + .250_r8*rxt(232)*y(52) &
                      + .794_r8*rxt(311)*y(86) + rxt(321)*y(88) + rxt(226)*y(120)
         mat(836) = mat(836) + .700_r8*rxt(333)*y(95)
         mat(951) = mat(951) + rxt(121)*y(1) + rxt(213)*y(17) + rxt(151)*y(8) &
                      + rxt(132)*y(39) + rxt(133)*y(40) + rxt(126)*y(22) + rxt(164) &
                      *y(27) + rxt(187)*y(35) + .500_r8*rxt(301)*y(78) &
                      + .250_r8*rxt(328)*y(91) + rxt(252)*y(50) + .200_r8*rxt(292) &
                      *y(77) + rxt(222)*y(15) + rxt(253)*y(48) + rxt(251)*y(49) &
                      + rxt(272)*y(63) + rxt(315)*y(87) + .350_r8*rxt(229)*y(118) &
                      + rxt(224)*y(119) + .500_r8*rxt(346)*y(123)
         mat(1082) = mat(1082) + rxt(151)*y(20) + rxt(214)*y(16) + rxt(306)*y(85) &
                      + .470_r8*rxt(288)*y(76) + .794_r8*rxt(312)*y(86) + rxt(316) &
                      *y(87) + rxt(322)*y(88)
         mat(742) = mat(742) + rxt(218)*y(6) + 4.000_r8*rxt(220)*y(13) + rxt(167) &
                      *y(27) + .900_r8*rxt(248)*y(45) + rxt(309)*y(85) &
                      + .730_r8*rxt(290)*y(76) + rxt(296)*y(73) + rxt(240)*y(43) &
                      + rxt(261)*y(58) + .300_r8*rxt(270)*y(64) + .800_r8*rxt(324) &
                      *y(88)
         mat(89) = rxt(132)*y(20)
         mat(46) = rxt(133)*y(20)
         mat(775) = mat(775) + rxt(216)*y(2) + rxt(214)*y(8) + rxt(161)*y(25) &
                      + rxt(185)*y(34)
         mat(1018) = mat(1018) + .794_r8*rxt(313)*y(86)
         mat(302) = rxt(131)*y(2) + rxt(126)*y(20) + rxt(158)*y(25)
         mat(802) = mat(802) + rxt(161)*y(16) + rxt(158)*y(22)
         mat(859) = mat(859) + rxt(164)*y(20) + rxt(167)*y(13)
         mat(757) = mat(757) + rxt(185)*y(16)
         mat(1200) = mat(1200) + rxt(187)*y(20)
         mat(490) = .190_r8*rxt(257)*y(1)
         mat(432) = .060_r8*rxt(303)*y(1)
         mat(366) = mat(366) + rxt(264)*y(6)
         mat(690) = mat(690) + .900_r8*rxt(248)*y(13) + rxt(310)*y(85) &
                      + .470_r8*rxt(291)*y(76) + rxt(325)*y(88)
         mat(161) = .120_r8*rxt(236)*y(1)
         mat(275) = .500_r8*rxt(301)*y(20)
         mat(145) = rxt(277)*y(6)
         mat(350) = mat(350) + .900_r8*rxt(318)*y(6)
         mat(58) = .250_r8*rxt(328)*y(20)
         mat(245) = mat(245) + .900_r8*rxt(329)*y(6)
         mat(82) = .700_r8*rxt(333)*y(7)
         mat(475) = mat(475) + rxt(337)*y(6)
         mat(317) = rxt(252)*y(20)
         mat(647) = mat(647) + rxt(305)*y(6) + rxt(306)*y(8) + rxt(309)*y(13) &
                      + rxt(310)*y(45)
         mat(604) = .060_r8*rxt(279)*y(1)
         mat(560) = .275_r8*rxt(285)*y(1)
         mat(625) = mat(625) + .470_r8*rxt(286)*y(6) + .470_r8*rxt(288)*y(8) &
                      + .730_r8*rxt(290)*y(13) + .470_r8*rxt(291)*y(45)
         mat(130) = .200_r8*rxt(292)*y(20)
         mat(664) = mat(664) + rxt(296)*y(13)
         mat(377) = mat(377) + rxt(238)*y(6) + rxt(240)*y(13) + 2.400_r8*rxt(241) &
                      *y(43)
         mat(311) = rxt(335)*y(1)
         mat(412) = mat(412) + rxt(259)*y(6) + rxt(261)*y(13)
         mat(237) = rxt(222)*y(20)
         mat(109) = rxt(253)*y(20)
         mat(393) = rxt(251)*y(20)
         mat(538) = rxt(272)*y(20)
         mat(292) = mat(292) + .250_r8*rxt(232)*y(6)
         mat(531) = mat(531) + .300_r8*rxt(270)*y(13)
         mat(505) = mat(505) + .794_r8*rxt(311)*y(6) + .794_r8*rxt(312)*y(8) &
                      + .794_r8*rxt(313)*y(21)
         mat(462) = rxt(315)*y(20) + rxt(316)*y(8)
         mat(587) = mat(587) + rxt(321)*y(6) + rxt(322)*y(8) + .800_r8*rxt(324)*y(13) &
                      + rxt(325)*y(45)
         mat(76) = .350_r8*rxt(229)*y(20)
         mat(182) = rxt(224)*y(20)
         mat(212) = mat(212) + rxt(226)*y(6)
         mat(101) = .500_r8*rxt(346)*y(20)

         mat(298) = -(rxt(126)*y(20) + rxt(131)*y(2) + rxt(158)*y(25))
         mat(909) = -rxt(126)*y(22)
         mat(1112) = -rxt(131)*y(22)
         mat(785) = -rxt(158)*y(22)

         mat(909) = mat(909) + 2.000_r8*rxt(124)*y(20)
         mat(980) = 2.000_r8*rxt(130)*y(21)

         mat(695) = -(rxt(88)*y(3))
         mat(1093) = -rxt(88)*y(161)

         mat(509) = rxt(125)*y(20)
         mat(942) = rxt(125)*y(18) + 2.000_r8*rxt(123)*y(20) + rxt(148)*y(9) &
                      + rxt(154)*y(10) + rxt(223)*y(14) + rxt(215)*y(16) + rxt(122) &
                      *y(21) + rxt(126)*y(22) + rxt(175)*y(30) + rxt(179)*y(31) &
                      + rxt(195)*y(36) + rxt(243)*y(47) + rxt(237)*y(46) + rxt(266) &
                      *y(62) + rxt(250)*y(51) + rxt(230)*y(42) + .500_r8*rxt(284) &
                      *y(75) + rxt(263)*y(57) + rxt(262)*y(59) + rxt(267)*y(60) &
                      + rxt(271)*y(66) + rxt(273)*y(65) + (rxt(326)+rxt(327))*y(89) &
                      + rxt(224)*y(119) + rxt(348)*y(124)
         mat(415) = rxt(148)*y(20)
         mat(190) = rxt(154)*y(20)
         mat(196) = rxt(223)*y(20)
         mat(768) = rxt(215)*y(20)
         mat(703) = rxt(119)*y(21)
         mat(1009) = rxt(122)*y(20) + rxt(119)*y(19)
         mat(299) = rxt(126)*y(20)
         mat(1032) = rxt(175)*y(20) + (rxt(356)+rxt(361)+rxt(367))*y(31) + (rxt(357) &
                       +rxt(368))*y(37)
         mat(437) = rxt(179)*y(20) + (rxt(356)+rxt(361)+rxt(367))*y(30)
         mat(395) = rxt(195)*y(20)
         mat(381) = (rxt(357)+rxt(368))*y(30)
         mat(543) = rxt(243)*y(20)
         mat(295) = rxt(237)*y(20)
         mat(281) = rxt(266)*y(20)
         mat(230) = rxt(250)*y(20)
         mat(122) = rxt(230)*y(20)
         mat(556) = .500_r8*rxt(284)*y(20)
         mat(52) = rxt(263)*y(20)
         mat(166) = rxt(262)*y(20)
         mat(355) = rxt(267)*y(20)
         mat(172) = rxt(271)*y(20)
         mat(566) = rxt(273)*y(20)
         mat(138) = (rxt(326)+rxt(327))*y(20)
         mat(180) = rxt(224)*y(20)
         mat(42) = rxt(348)*y(20)


      end subroutine nlnmat03

      subroutine nlnmat04( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(798) = -(rxt(156)*y(1) + rxt(157)*y(18) + rxt(158)*y(22) + (rxt(159) &
                      + rxt(160)) * y(21) + rxt(161)*y(16) + rxt(178)*y(31) + rxt(182) &
                      *y(32) + rxt(228)*y(42))
         mat(1235) = -rxt(156)*y(25)
         mat(511) = -rxt(157)*y(25)
         mat(300) = -rxt(158)*y(25)
         mat(1014) = -(rxt(159) + rxt(160)) * y(25)
         mat(772) = -rxt(161)*y(25)
         mat(438) = -rxt(178)*y(25)
         mat(448) = -rxt(182)*y(25)
         mat(123) = -rxt(228)*y(25)

         mat(1124) = rxt(163)*y(27) + rxt(176)*y(30)
         mat(1098) = rxt(112)*y(30)
         mat(1175) = rxt(168)*y(27)
         mat(947) = rxt(164)*y(27) + rxt(175)*y(30)
         mat(738) = rxt(167)*y(27)
         mat(855) = rxt(163)*y(2) + rxt(168)*y(6) + rxt(164)*y(20) + rxt(167)*y(13) + ( &
                      + 4.000_r8*rxt(170)+2.000_r8*rxt(172))*y(27) + rxt(192)*y(35)
         mat(1036) = rxt(176)*y(2) + rxt(112)*y(3) + rxt(175)*y(20)
         mat(1196) = rxt(192)*y(27)


         mat(783) = rxt(182)*y(32)
         mat(846) = 2.000_r8*rxt(171)*y(27)
         mat(1026) = (rxt(356)+rxt(361)+rxt(367))*y(31) + (rxt(355)+rxt(360)+rxt(366)) &
                      *y(32)
         mat(435) = (rxt(356)+rxt(361)+rxt(367))*y(30)
         mat(443) = rxt(182)*y(25) + (rxt(355)+rxt(360)+rxt(366))*y(30)

         mat(857) = -(rxt(163)*y(2) + (rxt(164) + rxt(165)) * y(20) + rxt(166)*y(21) &
                      + rxt(167)*y(13) + rxt(168)*y(6) + rxt(169)*y(7) + (4._r8*rxt(170) &
                      + 4._r8*rxt(171) + 4._r8*rxt(172) + 4._r8*rxt(173)) * y(27) &
                      + (rxt(191) + rxt(192) + rxt(193)) * y(35))
         mat(1126) = -rxt(163)*y(27)
         mat(949) = -(rxt(164) + rxt(165)) * y(27)
         mat(1016) = -rxt(166)*y(27)
         mat(740) = -rxt(167)*y(27)
         mat(1177) = -rxt(168)*y(27)
         mat(834) = -rxt(169)*y(27)
         mat(1198) = -(rxt(191) + rxt(192) + rxt(193)) * y(27)

         mat(1237) = rxt(156)*y(25)
         mat(1126) = mat(1126) + rxt(177)*y(31) + rxt(180)*y(32)
         mat(949) = mat(949) + rxt(179)*y(31)
         mat(1016) = mat(1016) + rxt(160)*y(25)
         mat(800) = rxt(156)*y(1) + rxt(160)*y(21) + rxt(178)*y(31)
         mat(439) = rxt(177)*y(2) + rxt(179)*y(20) + rxt(178)*y(25)
         mat(450) = rxt(180)*y(2)


         mat(845) = 2.000_r8*rxt(172)*y(27) + rxt(191)*y(35)
         mat(1187) = rxt(191)*y(27)


         mat(844) = 2.000_r8*rxt(173)*y(27)

         mat(1041) = -(rxt(112)*y(3) + rxt(175)*y(20) + rxt(176)*y(2) + (rxt(355) &
                      + rxt(360) + rxt(366)) * y(32) + (rxt(356) + rxt(361) + rxt(367) &
                      ) * y(31) + (rxt(357) + rxt(368)) * y(37))
         mat(1103) = -rxt(112)*y(30)
         mat(952) = -rxt(175)*y(30)
         mat(1129) = -rxt(176)*y(30)
         mat(452) = -(rxt(355) + rxt(360) + rxt(366)) * y(30)
         mat(441) = -(rxt(356) + rxt(361) + rxt(367)) * y(30)
         mat(385) = -(rxt(357) + rxt(368)) * y(30)

         mat(513) = rxt(157)*y(25)
         mat(952) = mat(952) + rxt(165)*y(27)
         mat(776) = rxt(161)*y(25)
         mat(1019) = rxt(159)*y(25)
         mat(303) = rxt(158)*y(25)
         mat(803) = rxt(157)*y(18) + rxt(161)*y(16) + rxt(159)*y(21) + rxt(158)*y(22) &
                      + rxt(178)*y(31) + rxt(228)*y(42)
         mat(860) = rxt(165)*y(20)
         mat(441) = mat(441) + rxt(178)*y(25)
         mat(125) = rxt(228)*y(25)

         mat(436) = -(rxt(177)*y(2) + rxt(178)*y(25) + rxt(179)*y(20) + (rxt(356) &
                      + rxt(361) + rxt(367)) * y(30))
         mat(1116) = -rxt(177)*y(31)
         mat(787) = -rxt(178)*y(31)
         mat(923) = -rxt(179)*y(31)
         mat(1030) = -(rxt(356) + rxt(361) + rxt(367)) * y(31)

         mat(923) = mat(923) + rxt(181)*y(32)
         mat(992) = rxt(166)*y(27)
         mat(848) = rxt(166)*y(21)
         mat(445) = rxt(181)*y(20)

         mat(446) = -(rxt(180)*y(2) + rxt(181)*y(20) + rxt(182)*y(25) + (rxt(355) &
                      + rxt(360) + rxt(366)) * y(30))
         mat(1117) = -rxt(180)*y(32)
         mat(924) = -rxt(181)*y(32)
         mat(788) = -rxt(182)*y(32)
         mat(1031) = -(rxt(355) + rxt(360) + rxt(366)) * y(32)

         mat(821) = rxt(169)*y(27)
         mat(849) = rxt(169)*y(7)


         mat(847) = rxt(193)*y(35)
         mat(1027) = (rxt(357)+rxt(368))*y(37)
         mat(1188) = rxt(193)*y(27)
         mat(379) = (rxt(357)+rxt(368))*y(30)

         mat(753) = -(rxt(183)*y(1) + rxt(184)*y(21) + rxt(185)*y(16))
         mat(1233) = -rxt(183)*y(34)
         mat(1012) = -rxt(184)*y(34)
         mat(770) = -rxt(185)*y(34)

         mat(1122) = rxt(186)*y(35) + rxt(196)*y(36)
         mat(1096) = rxt(113)*y(36)
         mat(1173) = rxt(189)*y(35)
         mat(945) = rxt(187)*y(35) + rxt(195)*y(36)
         mat(853) = (rxt(191)+rxt(192))*y(35)
         mat(1194) = rxt(186)*y(2) + rxt(189)*y(6) + rxt(187)*y(20) + (rxt(191) &
                       +rxt(192))*y(27) + 4.000_r8*rxt(194)*y(35)
         mat(397) = rxt(196)*y(2) + rxt(113)*y(3) + rxt(195)*y(20)

         mat(1206) = -(rxt(186)*y(2) + rxt(187)*y(20) + rxt(188)*y(21) + rxt(189)*y(6) &
                      + rxt(190)*y(7) + (rxt(191) + rxt(192) + rxt(193)) * y(27) &
                      + 4._r8*rxt(194)*y(35))
         mat(1134) = -rxt(186)*y(35)
         mat(957) = -rxt(187)*y(35)
         mat(1024) = -rxt(188)*y(35)
         mat(1185) = -rxt(189)*y(35)
         mat(842) = -rxt(190)*y(35)
         mat(865) = -(rxt(191) + rxt(192) + rxt(193)) * y(35)

         mat(1245) = rxt(183)*y(34)
         mat(1134) = mat(1134) + rxt(197)*y(37) + rxt(198)*y(38)
         mat(761) = rxt(183)*y(1)
         mat(387) = rxt(197)*y(2)
         mat(268) = rxt(198)*y(2)

         mat(394) = -(rxt(113)*y(3) + rxt(195)*y(20) + rxt(196)*y(2))
         mat(1091) = -rxt(113)*y(36)
         mat(919) = -rxt(195)*y(36)
         mat(1114) = -rxt(196)*y(36)

         mat(764) = rxt(185)*y(34)
         mat(990) = rxt(184)*y(34)
         mat(749) = rxt(185)*y(16) + rxt(184)*y(21)

         mat(380) = -(rxt(197)*y(2) + (rxt(357) + rxt(368)) * y(30))
         mat(1113) = -rxt(197)*y(37)
         mat(1028) = -(rxt(357) + rxt(368)) * y(37)

         mat(988) = rxt(188)*y(35)
         mat(1190) = rxt(188)*y(21)

         mat(261) = -(rxt(198)*y(2))
         mat(1111) = -rxt(198)*y(38)

         mat(816) = rxt(190)*y(35)
         mat(1189) = rxt(190)*y(7)

         mat(480) = -(rxt(256)*y(20) + rxt(257)*y(1) + rxt(258)*y(8))
         mat(927) = -rxt(256)*y(56)
         mat(1216) = -rxt(257)*y(56)
         mat(1060) = -rxt(258)*y(56)

         mat(1216) = mat(1216) + .070_r8*rxt(303)*y(80)
         mat(421) = .070_r8*rxt(303)*y(1)

         mat(420) = -(rxt(302)*y(20) + rxt(303)*y(1) + rxt(304)*y(8))
         mat(922) = -rxt(302)*y(80)
         mat(1214) = -rxt(303)*y(80)
         mat(1057) = -rxt(304)*y(80)

         mat(359) = -(rxt(264)*y(6) + rxt(265)*y(21))
         mat(1151) = -rxt(264)*y(61)
         mat(986) = -rxt(265)*y(61)

         mat(916) = rxt(256)*y(56) + .500_r8*rxt(266)*y(62)
         mat(479) = rxt(256)*y(20)
         mat(278) = .500_r8*rxt(266)*y(20)

         mat(541) = -(rxt(243)*y(20) + rxt(244)*y(8))
         mat(933) = -rxt(243)*y(47)
         mat(1065) = -rxt(244)*y(47)

         mat(1221) = .500_r8*rxt(257)*y(56) + .040_r8*rxt(279)*y(74)
         mat(1161) = rxt(264)*y(61) + rxt(277)*y(70) + .400_r8*rxt(318)*y(81) &
                      + rxt(281)*y(71) + rxt(238)*y(43) + .270_r8*rxt(259)*y(58)
         mat(933) = mat(933) + .500_r8*rxt(242)*y(44) + rxt(253)*y(48)
         mat(725) = .800_r8*rxt(240)*y(43)
         mat(483) = .500_r8*rxt(257)*y(1)
         mat(361) = rxt(264)*y(6)
         mat(142) = rxt(277)*y(6)
         mat(344) = .400_r8*rxt(318)*y(6)
         mat(331) = rxt(281)*y(6)
         mat(593) = .040_r8*rxt(279)*y(1)
         mat(372) = rxt(238)*y(6) + .800_r8*rxt(240)*y(13) + 3.200_r8*rxt(241)*y(43)
         mat(133) = .500_r8*rxt(242)*y(20)
         mat(405) = .270_r8*rxt(259)*y(6)
         mat(107) = rxt(253)*y(20)

         mat(294) = -(rxt(237)*y(20))
         mat(908) = -rxt(237)*y(46)

         mat(1211) = .250_r8*rxt(257)*y(56) + .200_r8*rxt(303)*y(80)
         mat(716) = .100_r8*rxt(248)*y(45)
         mat(979) = .250_r8*rxt(247)*y(45) + .250_r8*rxt(295)*y(73)
         mat(478) = .250_r8*rxt(257)*y(1)
         mat(419) = .200_r8*rxt(303)*y(1)
         mat(671) = .100_r8*rxt(248)*y(13) + .250_r8*rxt(247)*y(21)
         mat(653) = .250_r8*rxt(295)*y(21)

         mat(277) = -(rxt(266)*y(20))
         mat(906) = -rxt(266)*y(62)

         mat(977) = rxt(265)*y(61)
         mat(358) = rxt(265)*y(21)

         mat(683) = -(rxt(245)*y(6) + rxt(246)*y(7) + rxt(247)*y(21) + rxt(248)*y(13) &
                      + 4._r8*rxt(249)*y(45) + rxt(291)*y(76) + rxt(310)*y(85) + rxt(325) &
                      *y(88))
         mat(1169) = -rxt(245)*y(45)
         mat(826) = -rxt(246)*y(45)
         mat(1008) = -rxt(247)*y(45)
         mat(733) = -rxt(248)*y(45)
         mat(618) = -rxt(291)*y(45)
         mat(640) = -rxt(310)*y(45)
         mat(580) = -rxt(325)*y(45)

         mat(1169) = mat(1169) + rxt(281)*y(71) + .530_r8*rxt(286)*y(76) + rxt(293) &
                      *y(73) + rxt(268)*y(64)
         mat(941) = rxt(243)*y(47) + .500_r8*rxt(250)*y(51) + rxt(273)*y(65)
         mat(1073) = rxt(244)*y(47) + .530_r8*rxt(288)*y(76) + rxt(294)*y(73) &
                      + rxt(274)*y(65)
         mat(733) = mat(733) + .260_r8*rxt(290)*y(76) + rxt(296)*y(73) &
                      + .300_r8*rxt(270)*y(64)
         mat(542) = rxt(243)*y(20) + rxt(244)*y(8)
         mat(683) = mat(683) + .530_r8*rxt(291)*y(76)
         mat(229) = .500_r8*rxt(250)*y(20)
         mat(332) = rxt(281)*y(6)
         mat(618) = mat(618) + .530_r8*rxt(286)*y(6) + .530_r8*rxt(288)*y(8) &
                      + .260_r8*rxt(290)*y(13) + .530_r8*rxt(291)*y(45)
         mat(657) = rxt(293)*y(6) + rxt(294)*y(8) + rxt(296)*y(13) + 4.000_r8*rxt(298) &
                      *y(73)
         mat(525) = rxt(268)*y(6) + .300_r8*rxt(270)*y(13)
         mat(565) = rxt(273)*y(20) + rxt(274)*y(8)


      end subroutine nlnmat04

      subroutine nlnmat05( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(228) = -(rxt(250)*y(20))
         mat(900) = -rxt(250)*y(51)

         mat(973) = .750_r8*rxt(247)*y(45) + .750_r8*rxt(295)*y(73)
         mat(670) = .750_r8*rxt(247)*y(21)
         mat(651) = .750_r8*rxt(295)*y(21)

         mat(221) = -(rxt(255)*y(20))
         mat(899) = -rxt(255)*y(55)

         mat(814) = rxt(246)*y(45)
         mat(669) = rxt(246)*y(7)

         mat(175) = -(rxt(275)*y(20))
         mat(892) = -rxt(275)*y(79)

         mat(1140) = .100_r8*rxt(318)*y(81)
         mat(1052) = rxt(258)*y(56)
         mat(477) = rxt(258)*y(8)
         mat(337) = .100_r8*rxt(318)*y(6)

         mat(120) = -(rxt(228)*y(25) + rxt(230)*y(20))
         mat(784) = -rxt(228)*y(42)
         mat(882) = -rxt(230)*y(42)

         mat(155) = -(rxt(231)*y(20) + rxt(236)*y(1))
         mat(889) = -rxt(231)*y(41)
         mat(1208) = -rxt(236)*y(41)

         mat(35) = -(rxt(314)*y(20))
         mat(868) = -rxt(314)*y(68)

         mat(269) = -(rxt(301)*y(20))
         mat(905) = -rxt(301)*y(78)

         mat(817) = rxt(299)*y(73)
         mat(652) = rxt(299)*y(7)

         mat(38) = -(rxt(276)*y(20))
         mat(869) = -rxt(276)*y(67)

         mat(140) = -(rxt(277)*y(6))
         mat(1138) = -rxt(277)*y(70)

         mat(886) = rxt(276)*y(67)
         mat(39) = rxt(276)*y(20)

         mat(341) = -(rxt(318)*y(6) + rxt(319)*y(21))
         mat(1149) = -rxt(318)*y(81)
         mat(984) = -rxt(319)*y(81)

         mat(914) = rxt(314)*y(68) + rxt(320)*y(82)
         mat(36) = rxt(314)*y(20)
         mat(321) = rxt(320)*y(20)

         mat(319) = -(rxt(320)*y(20))
         mat(912) = -rxt(320)*y(82)

         mat(982) = rxt(319)*y(81)
         mat(339) = rxt(319)*y(21)

         mat(201) = -(rxt(280)*y(20))
         mat(897) = -rxt(280)*y(69)

         mat(1142) = .800_r8*rxt(318)*y(81)
         mat(338) = .800_r8*rxt(318)*y(6)

         mat(330) = -(rxt(281)*y(6) + rxt(282)*y(21))
         mat(1148) = -rxt(281)*y(71)
         mat(983) = -rxt(282)*y(71)

         mat(913) = rxt(280)*y(69) + rxt(283)*y(72)
         mat(202) = rxt(280)*y(20)
         mat(148) = rxt(283)*y(20)

         mat(147) = -(rxt(283)*y(20))
         mat(887) = -rxt(283)*y(72)

         mat(964) = rxt(282)*y(71)
         mat(329) = rxt(282)*y(21)

         mat(54) = -(rxt(328)*y(20))
         mat(873) = -rxt(328)*y(91)

         mat(59) = -(rxt(332)*y(20))
         mat(874) = -rxt(332)*y(92)

         mat(874) = mat(874) + .250_r8*rxt(328)*y(91)
         mat(55) = .250_r8*rxt(328)*y(20)

         mat(239) = -(rxt(329)*y(6) + rxt(330)*y(21))
         mat(1144) = -rxt(329)*y(93)
         mat(974) = -rxt(330)*y(93)

         mat(902) = .700_r8*rxt(328)*y(91) + rxt(331)*y(94)
         mat(56) = .700_r8*rxt(328)*y(20)
         mat(184) = rxt(331)*y(20)

         mat(183) = -(rxt(331)*y(20))
         mat(894) = -rxt(331)*y(94)

         mat(968) = rxt(330)*y(93)
         mat(238) = rxt(330)*y(21)

         mat(79) = -(rxt(333)*y(7))
         mat(810) = -rxt(333)*y(95)

         mat(877) = rxt(332)*y(92)
         mat(60) = rxt(332)*y(20)

         mat(466) = -(rxt(337)*y(6) + rxt(338)*y(21))
         mat(1156) = -rxt(337)*y(97)
         mat(994) = -rxt(338)*y(97)

         mat(926) = rxt(339)*y(98) + rxt(334)*y(96)
         mat(1059) = rxt(336)*y(96)
         mat(216) = rxt(339)*y(20)
         mat(306) = rxt(334)*y(20) + rxt(336)*y(8)

         mat(214) = -(rxt(339)*y(20))
         mat(898) = -rxt(339)*y(98)

         mat(972) = rxt(338)*y(97)
         mat(464) = rxt(338)*y(21)


         mat(1145) = .900_r8*rxt(329)*y(93)
         mat(815) = .700_r8*rxt(333)*y(95)
         mat(240) = .900_r8*rxt(329)*y(6)
         mat(80) = .700_r8*rxt(333)*y(7)

         mat(314) = -(rxt(252)*y(20))
         mat(911) = -rxt(252)*y(50)

         mat(1147) = .450_r8*rxt(329)*y(93) + .250_r8*rxt(321)*y(88)
         mat(911) = mat(911) + .200_r8*rxt(251)*y(49) + .650_r8*rxt(229)*y(118)
         mat(1054) = .250_r8*rxt(322)*y(88)
         mat(717) = .100_r8*rxt(324)*y(88)
         mat(672) = .250_r8*rxt(325)*y(88)
         mat(241) = .450_r8*rxt(329)*y(6)
         mat(388) = .200_r8*rxt(251)*y(20)
         mat(574) = .250_r8*rxt(321)*y(6) + .250_r8*rxt(322)*y(8) + .100_r8*rxt(324) &
                      *y(13) + .250_r8*rxt(325)*y(45)
         mat(73) = .650_r8*rxt(229)*y(20)

         mat(638) = -(rxt(305)*y(6) + rxt(306)*y(8) + rxt(307)*y(21) + rxt(309)*y(13) &
                      + rxt(310)*y(45))
         mat(1167) = -rxt(305)*y(85)
         mat(1071) = -rxt(306)*y(85)
         mat(1006) = -rxt(307)*y(85)
         mat(731) = -rxt(309)*y(85)
         mat(681) = -rxt(310)*y(85)

         mat(939) = rxt(302)*y(80) + .200_r8*rxt(308)*y(90)
         mat(426) = rxt(302)*y(20)
         mat(257) = .200_r8*rxt(308)*y(20)

         mat(595) = -(rxt(278)*y(20) + rxt(279)*y(1))
         mat(937) = -rxt(278)*y(74)
         mat(1225) = -rxt(279)*y(74)

         mat(1225) = mat(1225) + .200_r8*rxt(303)*y(80) + rxt(335)*y(96)
         mat(1165) = rxt(337)*y(97) + .320_r8*rxt(305)*y(85) + .039_r8*rxt(311)*y(86)
         mat(1069) = .350_r8*rxt(306)*y(85) + .039_r8*rxt(312)*y(86)
         mat(729) = .260_r8*rxt(309)*y(85)
         mat(1004) = .039_r8*rxt(313)*y(86)
         mat(425) = .200_r8*rxt(303)*y(1)
         mat(679) = .350_r8*rxt(310)*y(85)
         mat(469) = rxt(337)*y(6)
         mat(636) = .320_r8*rxt(305)*y(6) + .350_r8*rxt(306)*y(8) + .260_r8*rxt(309) &
                      *y(13) + .350_r8*rxt(310)*y(45)
         mat(308) = rxt(335)*y(1)
         mat(500) = .039_r8*rxt(311)*y(6) + .039_r8*rxt(312)*y(8) + .039_r8*rxt(313) &
                      *y(21)

         mat(551) = -(rxt(284)*y(20) + rxt(285)*y(1))
         mat(934) = -rxt(284)*y(75)
         mat(1222) = -rxt(285)*y(75)

         mat(1222) = mat(1222) + .400_r8*rxt(303)*y(80) + rxt(335)*y(96)
         mat(1162) = rxt(337)*y(97) + .230_r8*rxt(305)*y(85) + .167_r8*rxt(311)*y(86)
         mat(1066) = .250_r8*rxt(306)*y(85) + .167_r8*rxt(312)*y(86)
         mat(726) = .190_r8*rxt(309)*y(85)
         mat(1001) = .167_r8*rxt(313)*y(86)
         mat(424) = .400_r8*rxt(303)*y(1)
         mat(676) = .250_r8*rxt(310)*y(85)
         mat(468) = rxt(337)*y(6)
         mat(633) = .230_r8*rxt(305)*y(6) + .250_r8*rxt(306)*y(8) + .190_r8*rxt(309) &
                      *y(13) + .250_r8*rxt(310)*y(45)
         mat(307) = rxt(335)*y(1)
         mat(498) = .167_r8*rxt(311)*y(6) + .167_r8*rxt(312)*y(8) + .167_r8*rxt(313) &
                      *y(21)

         mat(616) = -((rxt(286) + rxt(287)) * y(6) + rxt(288)*y(8) + rxt(289)*y(21) &
                      + rxt(290)*y(13) + rxt(291)*y(45))
         mat(1166) = -(rxt(286) + rxt(287)) * y(76)
         mat(1070) = -rxt(288)*y(76)
         mat(1005) = -rxt(289)*y(76)
         mat(730) = -rxt(290)*y(76)
         mat(680) = -rxt(291)*y(76)

         mat(938) = rxt(278)*y(74) + .500_r8*rxt(284)*y(75) + .200_r8*rxt(292)*y(77)
         mat(596) = rxt(278)*y(20)
         mat(553) = .500_r8*rxt(284)*y(20)
         mat(127) = .200_r8*rxt(292)*y(20)

         mat(126) = -(rxt(292)*y(20))
         mat(883) = -rxt(292)*y(77)

         mat(961) = rxt(289)*y(76)
         mat(608) = rxt(289)*y(21)

         mat(656) = -(rxt(293)*y(6) + rxt(294)*y(8) + rxt(295)*y(21) + rxt(296)*y(13) &
                      + rxt(297)*y(45) + 4._r8*rxt(298)*y(73) + rxt(299)*y(7))
         mat(1168) = -rxt(293)*y(73)
         mat(1072) = -rxt(294)*y(73)
         mat(1007) = -rxt(295)*y(73)
         mat(732) = -rxt(296)*y(73)
         mat(682) = -rxt(297)*y(73)
         mat(825) = -rxt(299)*y(73)

         mat(1228) = .200_r8*rxt(303)*y(80)
         mat(940) = .500_r8*rxt(284)*y(75) + .500_r8*rxt(292)*y(77)
         mat(427) = .200_r8*rxt(303)*y(1)
         mat(554) = .500_r8*rxt(284)*y(20)
         mat(128) = .500_r8*rxt(292)*y(20)

         mat(371) = -(rxt(238)*y(6) + rxt(239)*y(21) + rxt(240)*y(13) + 4._r8*rxt(241) &
                      *y(43))
         mat(1152) = -rxt(238)*y(43)
         mat(987) = -rxt(239)*y(43)
         mat(719) = -rxt(240)*y(43)

         mat(917) = rxt(230)*y(42) + .500_r8*rxt(242)*y(44)
         mat(786) = rxt(228)*y(42)
         mat(121) = rxt(230)*y(20) + rxt(228)*y(25)
         mat(132) = .500_r8*rxt(242)*y(20)

         mat(131) = -(rxt(242)*y(20))
         mat(884) = -rxt(242)*y(44)

         mat(962) = rxt(239)*y(43)
         mat(369) = rxt(239)*y(21)

         mat(305) = -(rxt(334)*y(20) + rxt(335)*y(1) + rxt(336)*y(8))
         mat(910) = -rxt(334)*y(96)
         mat(1212) = -rxt(335)*y(96)
         mat(1053) = -rxt(336)*y(96)

         mat(50) = -(rxt(263)*y(20))
         mat(872) = -rxt(263)*y(57)

         mat(403) = -(rxt(259)*y(6) + rxt(260)*y(21) + rxt(261)*y(13))
         mat(1154) = -rxt(259)*y(58)
         mat(991) = -rxt(260)*y(58)
         mat(721) = -rxt(261)*y(58)

         mat(920) = rxt(263)*y(57) + rxt(262)*y(59)
         mat(51) = rxt(263)*y(20)
         mat(165) = rxt(262)*y(20)

         mat(163) = -(rxt(262)*y(20))
         mat(890) = -rxt(262)*y(59)

         mat(965) = rxt(260)*y(58)
         mat(401) = rxt(260)*y(21)


      end subroutine nlnmat05

      subroutine nlnmat06( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(352) = -(rxt(267)*y(20))
         mat(915) = -rxt(267)*y(60)

         mat(1150) = .500_r8*rxt(277)*y(70) + .250_r8*rxt(318)*y(81) &
                      + .100_r8*rxt(337)*y(97) + .820_r8*rxt(259)*y(58)
         mat(718) = .820_r8*rxt(261)*y(58)
         mat(141) = .500_r8*rxt(277)*y(6)
         mat(342) = .250_r8*rxt(318)*y(6)
         mat(465) = .100_r8*rxt(337)*y(6)
         mat(402) = .820_r8*rxt(259)*y(6) + .820_r8*rxt(261)*y(13)

         mat(169) = -(rxt(271)*y(20))
         mat(891) = -rxt(271)*y(66)

         mat(966) = rxt(269)*y(64)
         mat(520) = rxt(269)*y(21)

         mat(234) = -(rxt(222)*y(20))
         mat(901) = -rxt(222)*y(15)

         mat(715) = 2.000_r8*rxt(221)*y(13) + .250_r8*rxt(309)*y(85) &
                      + .250_r8*rxt(290)*y(76) + .300_r8*rxt(240)*y(43) &
                      + .500_r8*rxt(270)*y(64) + .300_r8*rxt(324)*y(88)
         mat(629) = .250_r8*rxt(309)*y(13)
         mat(609) = .250_r8*rxt(290)*y(13)
         mat(370) = .300_r8*rxt(240)*y(13)
         mat(521) = .500_r8*rxt(270)*y(13)
         mat(573) = .300_r8*rxt(324)*y(13)

         mat(106) = -(rxt(253)*y(20))
         mat(881) = -rxt(253)*y(48)

         mat(712) = .200_r8*rxt(240)*y(43)
         mat(368) = .200_r8*rxt(240)*y(13) + .800_r8*rxt(241)*y(43)

         mat(389) = -(rxt(251)*y(20))
         mat(918) = -rxt(251)*y(49)

         mat(1153) = .530_r8*rxt(286)*y(76) + .250_r8*rxt(321)*y(88)
         mat(1055) = .530_r8*rxt(288)*y(76) + .250_r8*rxt(322)*y(88)
         mat(720) = .260_r8*rxt(290)*y(76) + .100_r8*rxt(324)*y(88)
         mat(673) = .530_r8*rxt(291)*y(76) + .250_r8*rxt(325)*y(88)
         mat(610) = .530_r8*rxt(286)*y(6) + .530_r8*rxt(288)*y(8) + .260_r8*rxt(290) &
                      *y(13) + .530_r8*rxt(291)*y(45)
         mat(575) = .250_r8*rxt(321)*y(6) + .250_r8*rxt(322)*y(8) + .100_r8*rxt(324) &
                      *y(13) + .250_r8*rxt(325)*y(45)

         mat(533) = -(rxt(272)*y(20))
         mat(932) = -rxt(272)*y(63)

         mat(1160) = .220_r8*rxt(286)*y(76) + .250_r8*rxt(321)*y(88)
         mat(932) = mat(932) + .500_r8*rxt(266)*y(62) + .500_r8*rxt(301)*y(78)
         mat(1064) = .220_r8*rxt(288)*y(76) + .250_r8*rxt(322)*y(88)
         mat(724) = .230_r8*rxt(290)*y(76) + .200_r8*rxt(270)*y(64) + .100_r8*rxt(324) &
                      *y(88)
         mat(279) = .500_r8*rxt(266)*y(20)
         mat(675) = .220_r8*rxt(291)*y(76) + .250_r8*rxt(325)*y(88)
         mat(270) = .500_r8*rxt(301)*y(20)
         mat(613) = .220_r8*rxt(286)*y(6) + .220_r8*rxt(288)*y(8) + .230_r8*rxt(290) &
                      *y(13) + .220_r8*rxt(291)*y(45)
         mat(523) = .200_r8*rxt(270)*y(13)
         mat(577) = .250_r8*rxt(321)*y(6) + .250_r8*rxt(322)*y(8) + .100_r8*rxt(324) &
                      *y(13) + .250_r8*rxt(325)*y(45)

         mat(287) = -(rxt(232)*y(6) + rxt(233)*y(21))
         mat(1146) = -rxt(232)*y(52)
         mat(978) = -rxt(233)*y(52)

         mat(907) = rxt(231)*y(41)
         mat(157) = rxt(231)*y(20)


         mat(1137) = .750_r8*rxt(232)*y(52)
         mat(286) = .750_r8*rxt(232)*y(6)


         mat(959) = rxt(233)*y(52)
         mat(285) = rxt(233)*y(21)

         mat(152) = -(rxt(317)*y(20))
         mat(888) = -rxt(317)*y(84)

         mat(1139) = .370_r8*rxt(305)*y(85)
         mat(888) = mat(888) + rxt(315)*y(87)
         mat(1051) = .400_r8*rxt(306)*y(85) + rxt(316)*y(87)
         mat(713) = .300_r8*rxt(309)*y(85)
         mat(668) = .400_r8*rxt(310)*y(85)
         mat(628) = .370_r8*rxt(305)*y(6) + .400_r8*rxt(306)*y(8) + .300_r8*rxt(309) &
                      *y(13) + .400_r8*rxt(310)*y(45)
         mat(455) = rxt(315)*y(20) + rxt(316)*y(8)

         mat(522) = -(rxt(268)*y(6) + rxt(269)*y(21) + rxt(270)*y(13))
         mat(1159) = -rxt(268)*y(64)
         mat(998) = -rxt(269)*y(64)
         mat(723) = -rxt(270)*y(64)

         mat(931) = rxt(267)*y(60) + rxt(271)*y(66)
         mat(353) = rxt(267)*y(20)
         mat(170) = rxt(271)*y(20)

         mat(564) = -(rxt(273)*y(20) + rxt(274)*y(8))
         mat(935) = -rxt(273)*y(65)
         mat(1067) = -rxt(274)*y(65)

         mat(1223) = .950_r8*rxt(279)*y(74) + .800_r8*rxt(285)*y(75)
         mat(1163) = .450_r8*rxt(329)*y(93) + .250_r8*rxt(286)*y(76) &
                      + .250_r8*rxt(321)*y(88)
         mat(935) = mat(935) + rxt(275)*y(79) + rxt(272)*y(63)
         mat(1067) = mat(1067) + .250_r8*rxt(288)*y(76) + .250_r8*rxt(322)*y(88)
         mat(727) = .240_r8*rxt(290)*y(76) + .500_r8*rxt(270)*y(64) + .100_r8*rxt(324) &
                      *y(88)
         mat(677) = .250_r8*rxt(291)*y(76) + .250_r8*rxt(325)*y(88)
         mat(176) = rxt(275)*y(20)
         mat(242) = .450_r8*rxt(329)*y(6)
         mat(594) = .950_r8*rxt(279)*y(1)
         mat(552) = .800_r8*rxt(285)*y(1)
         mat(614) = .250_r8*rxt(286)*y(6) + .250_r8*rxt(288)*y(8) + .240_r8*rxt(290) &
                      *y(13) + .250_r8*rxt(291)*y(45)
         mat(534) = rxt(272)*y(20)
         mat(524) = .500_r8*rxt(270)*y(13)
         mat(578) = .250_r8*rxt(321)*y(6) + .250_r8*rxt(322)*y(8) + .100_r8*rxt(324) &
                      *y(13) + .250_r8*rxt(325)*y(45)

         mat(496) = -(rxt(311)*y(6) + rxt(312)*y(8) + rxt(313)*y(21))
         mat(1157) = -rxt(311)*y(86)
         mat(1061) = -rxt(312)*y(86)
         mat(995) = -rxt(313)*y(86)

         mat(1061) = mat(1061) + rxt(304)*y(80)
         mat(422) = rxt(304)*y(8)

         mat(456) = -(rxt(315)*y(20) + rxt(316)*y(8))
         mat(925) = -rxt(315)*y(87)
         mat(1058) = -rxt(316)*y(87)

         mat(1155) = .080_r8*rxt(305)*y(85) + .800_r8*rxt(287)*y(76) &
                      + .794_r8*rxt(311)*y(86)
         mat(1058) = mat(1058) + .794_r8*rxt(312)*y(86)
         mat(993) = .794_r8*rxt(313)*y(86)
         mat(631) = .080_r8*rxt(305)*y(6)
         mat(611) = .800_r8*rxt(287)*y(6)
         mat(495) = .794_r8*rxt(311)*y(6) + .794_r8*rxt(312)*y(8) + .794_r8*rxt(313) &
                      *y(21)

         mat(579) = -(rxt(321)*y(6) + rxt(322)*y(8) + rxt(323)*y(21) + rxt(324)*y(13) &
                      + rxt(325)*y(45))
         mat(1164) = -rxt(321)*y(88)
         mat(1068) = -rxt(322)*y(88)
         mat(1003) = -rxt(323)*y(88)
         mat(728) = -rxt(324)*y(88)
         mat(678) = -rxt(325)*y(88)

         mat(936) = rxt(317)*y(84) + rxt(326)*y(89) + .800_r8*rxt(308)*y(90)
         mat(153) = rxt(317)*y(20)
         mat(137) = rxt(326)*y(20)
         mat(255) = .800_r8*rxt(308)*y(20)

         mat(136) = -((rxt(326) + rxt(327)) * y(20))
         mat(885) = -(rxt(326) + rxt(327)) * y(89)

         mat(963) = rxt(313)*y(86) + rxt(323)*y(88)
         mat(494) = rxt(313)*y(21)
         mat(572) = rxt(323)*y(21)

         mat(253) = -(rxt(308)*y(20))
         mat(904) = -rxt(308)*y(90)

         mat(976) = rxt(307)*y(85)
         mat(630) = rxt(307)*y(21)

         mat(71) = -(rxt(229)*y(20))
         mat(876) = -rxt(229)*y(118)

         mat(179) = -(rxt(224)*y(20))
         mat(893) = -rxt(224)*y(119)

         mat(1209) = .500_r8*rxt(236)*y(41)
         mat(1141) = rxt(226)*y(120)
         mat(893) = mat(893) + .350_r8*rxt(229)*y(118)
         mat(967) = rxt(227)*y(120)
         mat(156) = .500_r8*rxt(236)*y(1)
         mat(72) = .350_r8*rxt(229)*y(20)
         mat(206) = rxt(226)*y(6) + rxt(227)*y(21)

         mat(207) = -(rxt(226)*y(6) + rxt(227)*y(21))
         mat(1143) = -rxt(226)*y(120)
         mat(971) = -rxt(227)*y(120)

         mat(763) = rxt(217)*y(21)
         mat(971) = mat(971) + rxt(217)*y(16)

         mat(92) = -(rxt(350)*y(2) + rxt(351)*y(20))
         mat(1110) = -rxt(350)*y(121)
         mat(879) = -rxt(351)*y(121)

         mat(66) = -(rxt(344)*y(20))
         mat(875) = -rxt(344)*y(122)

         mat(875) = mat(875) + rxt(351)*y(121) + (rxt(345)+.500_r8*rxt(346))*y(123)
         mat(1048) = rxt(347)*y(123)
         mat(91) = rxt(351)*y(20)
         mat(97) = (rxt(345)+.500_r8*rxt(346))*y(20) + rxt(347)*y(8)

         mat(98) = -((rxt(345) + rxt(346)) * y(20) + rxt(347)*y(8))
         mat(880) = -(rxt(345) + rxt(346)) * y(123)
         mat(1049) = -rxt(347)*y(123)

         mat(41) = -(rxt(348)*y(20))
         mat(870) = -rxt(348)*y(124)



         mat(867) = rxt(344)*y(122)
         mat(65) = rxt(344)*y(20)
      end subroutine nlnmat06
      subroutine nlnmat_finit( mat, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(inout) :: mat(nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
         mat( 1) = lmat( 1)
         mat( 2) = lmat( 2)
         mat( 3) = lmat( 3)
         mat( 4) = lmat( 4)
         mat( 5) = lmat( 5)
         mat( 6) = lmat( 6)
         mat( 7) = lmat( 7)
         mat( 8) = lmat( 8)
         mat( 9) = lmat( 9)
         mat( 10) = lmat( 10)
         mat( 11) = lmat( 11)
         mat( 12) = lmat( 12)
         mat( 13) = lmat( 13)
         mat( 14) = lmat( 14)
         mat( 15) = lmat( 15)
         mat( 16) = lmat( 16)
         mat( 17) = lmat( 17)
         mat( 18) = lmat( 18)
         mat( 19) = lmat( 19)
         mat( 20) = lmat( 20)
         mat( 21) = lmat( 21)
         mat( 22) = lmat( 22)
         mat( 23) = lmat( 23)
         mat( 24) = lmat( 24)
         mat( 25) = lmat( 25)
         mat( 26) = lmat( 26)
         mat( 27) = lmat( 27)
         mat( 28) = lmat( 28)
         mat( 29) = lmat( 29)
         mat( 30) = lmat( 30)
         mat( 31) = lmat( 31)
         mat( 32) = lmat( 32)
         mat( 33) = lmat( 33)
         mat( 34) = lmat( 34)
         mat( 35) = mat( 35) + lmat( 35)
         mat( 38) = mat( 38) + lmat( 38)
         mat( 41) = mat( 41) + lmat( 41)
         mat( 44) = mat( 44) + lmat( 44)
         mat( 47) = lmat( 47)
         mat( 48) = lmat( 48)
         mat( 49) = lmat( 49)
         mat( 50) = mat( 50) + lmat( 50)
         mat( 54) = mat( 54) + lmat( 54)
         mat( 59) = mat( 59) + lmat( 59)
         mat( 62) = lmat( 62)
         mat( 63) = lmat( 63)
         mat( 64) = lmat( 64)
         mat( 66) = mat( 66) + lmat( 66)
         mat( 68) = lmat( 68)
         mat( 69) = lmat( 69)
         mat( 70) = lmat( 70)
         mat( 71) = mat( 71) + lmat( 71)
         mat( 77) = lmat( 77)
         mat( 78) = lmat( 78)
         mat( 79) = mat( 79) + lmat( 79)
         mat( 83) = mat( 83) + lmat( 83)
         mat( 85) = mat( 85) + lmat( 85)
         mat( 86) = mat( 86) + lmat( 86)
         mat( 87) = mat( 87) + lmat( 87)
         mat( 92) = mat( 92) + lmat( 92)
         mat( 93) = mat( 93) + lmat( 93)
         mat( 98) = mat( 98) + lmat( 98)
         mat( 103) = lmat( 103)
         mat( 104) = lmat( 104)
         mat( 105) = lmat( 105)
         mat( 106) = mat( 106) + lmat( 106)
         mat( 110) = lmat( 110)
         mat( 111) = lmat( 111)
         mat( 112) = lmat( 112)
         mat( 113) = lmat( 113)
         mat( 114) = lmat( 114)
         mat( 115) = lmat( 115)
         mat( 116) = lmat( 116)
         mat( 117) = lmat( 117)
         mat( 118) = lmat( 118)
         mat( 119) = lmat( 119)
         mat( 120) = mat( 120) + lmat( 120)
         mat( 126) = mat( 126) + lmat( 126)
         mat( 131) = mat( 131) + lmat( 131)
         mat( 133) = mat( 133) + lmat( 133)
         mat( 134) = mat( 134) + lmat( 134)
         mat( 135) = lmat( 135)
         mat( 136) = mat( 136) + lmat( 136)
         mat( 139) = mat( 139) + lmat( 139)
         mat( 140) = mat( 140) + lmat( 140)
         mat( 147) = mat( 147) + lmat( 147)
         mat( 149) = lmat( 149)
         mat( 150) = lmat( 150)
         mat( 151) = mat( 151) + lmat( 151)
         mat( 152) = mat( 152) + lmat( 152)
         mat( 155) = mat( 155) + lmat( 155)
         mat( 163) = mat( 163) + lmat( 163)
         mat( 164) = lmat( 164)
         mat( 167) = mat( 167) + lmat( 167)
         mat( 168) = lmat( 168)
         mat( 169) = mat( 169) + lmat( 169)
         mat( 171) = lmat( 171)
         mat( 173) = lmat( 173)
         mat( 174) = mat( 174) + lmat( 174)
         mat( 175) = mat( 175) + lmat( 175)
         mat( 179) = mat( 179) + lmat( 179)
         mat( 183) = mat( 183) + lmat( 183)
         mat( 185) = lmat( 185)
         mat( 186) = lmat( 186)
         mat( 187) = lmat( 187)
         mat( 188) = mat( 188) + lmat( 188)
         mat( 189) = mat( 189) + lmat( 189)
         mat( 191) = mat( 191) + lmat( 191)
         mat( 192) = mat( 192) + lmat( 192)
         mat( 193) = lmat( 193)
         mat( 194) = lmat( 194)
         mat( 195) = mat( 195) + lmat( 195)
         mat( 197) = lmat( 197)
         mat( 199) = mat( 199) + lmat( 199)
         mat( 200) = mat( 200) + lmat( 200)
         mat( 201) = mat( 201) + lmat( 201)
         mat( 203) = lmat( 203)
         mat( 204) = lmat( 204)
         mat( 207) = mat( 207) + lmat( 207)
         mat( 209) = lmat( 209)
         mat( 212) = mat( 212) + lmat( 212)
         mat( 214) = mat( 214) + lmat( 214)
         mat( 215) = lmat( 215)
         mat( 217) = lmat( 217)
         mat( 218) = lmat( 218)
         mat( 219) = mat( 219) + lmat( 219)
         mat( 220) = lmat( 220)
         mat( 221) = mat( 221) + lmat( 221)
         mat( 222) = lmat( 222)
         mat( 223) = lmat( 223)
         mat( 225) = lmat( 225)
         mat( 227) = mat( 227) + lmat( 227)
         mat( 228) = mat( 228) + lmat( 228)
         mat( 231) = lmat( 231)
         mat( 233) = mat( 233) + lmat( 233)
         mat( 234) = mat( 234) + lmat( 234)
         mat( 239) = mat( 239) + lmat( 239)
         mat( 247) = lmat( 247)
         mat( 248) = lmat( 248)
         mat( 249) = lmat( 249)
         mat( 250) = lmat( 250)
         mat( 251) = lmat( 251)
         mat( 252) = lmat( 252)
         mat( 253) = mat( 253) + lmat( 253)
         mat( 254) = lmat( 254)
         mat( 256) = lmat( 256)
         mat( 258) = lmat( 258)
         mat( 260) = lmat( 260)
         mat( 261) = mat( 261) + lmat( 261)
         mat( 262) = lmat( 262)
         mat( 263) = lmat( 263)
         mat( 264) = lmat( 264)
         mat( 265) = lmat( 265)
         mat( 266) = mat( 266) + lmat( 266)
         mat( 268) = mat( 268) + lmat( 268)
         mat( 269) = mat( 269) + lmat( 269)
         mat( 271) = lmat( 271)
         mat( 273) = lmat( 273)
         mat( 277) = mat( 277) + lmat( 277)
         mat( 280) = lmat( 280)
         mat( 282) = lmat( 282)
         mat( 283) = mat( 283) + lmat( 283)
         mat( 284) = lmat( 284)
         mat( 287) = mat( 287) + lmat( 287)
         mat( 294) = mat( 294) + lmat( 294)
         mat( 298) = mat( 298) + lmat( 298)
         mat( 301) = mat( 301) + lmat( 301)
         mat( 305) = mat( 305) + lmat( 305)
         mat( 314) = mat( 314) + lmat( 314)
         mat( 315) = mat( 315) + lmat( 315)
         mat( 317) = mat( 317) + lmat( 317)
         mat( 318) = lmat( 318)
         mat( 319) = mat( 319) + lmat( 319)
         mat( 322) = lmat( 322)
         mat( 324) = lmat( 324)
         mat( 326) = lmat( 326)
         mat( 327) = mat( 327) + lmat( 327)
         mat( 328) = lmat( 328)
         mat( 330) = mat( 330) + lmat( 330)
         mat( 341) = mat( 341) + lmat( 341)
         mat( 352) = mat( 352) + lmat( 352)
         mat( 354) = lmat( 354)
         mat( 356) = lmat( 356)
         mat( 359) = mat( 359) + lmat( 359)
         mat( 371) = mat( 371) + lmat( 371)
         mat( 380) = mat( 380) + lmat( 380)
         mat( 382) = lmat( 382)
         mat( 384) = mat( 384) + lmat( 384)
         mat( 389) = mat( 389) + lmat( 389)
         mat( 390) = lmat( 390)
         mat( 391) = mat( 391) + lmat( 391)
         mat( 393) = mat( 393) + lmat( 393)
         mat( 394) = mat( 394) + lmat( 394)
         mat( 396) = lmat( 396)
         mat( 397) = mat( 397) + lmat( 397)
         mat( 403) = mat( 403) + lmat( 403)
         mat( 414) = mat( 414) + lmat( 414)
         mat( 416) = lmat( 416)
         mat( 417) = mat( 417) + lmat( 417)
         mat( 420) = mat( 420) + lmat( 420)
         mat( 436) = mat( 436) + lmat( 436)
         mat( 438) = mat( 438) + lmat( 438)
         mat( 440) = mat( 440) + lmat( 440)
         mat( 444) = mat( 444) + lmat( 444)
         mat( 445) = mat( 445) + lmat( 445)
         mat( 446) = mat( 446) + lmat( 446)
         mat( 448) = mat( 448) + lmat( 448)
         mat( 449) = lmat( 449)
         mat( 450) = mat( 450) + lmat( 450)
         mat( 453) = mat( 453) + lmat( 453)
         mat( 456) = mat( 456) + lmat( 456)
         mat( 457) = lmat( 457)
         mat( 459) = lmat( 459)
         mat( 460) = mat( 460) + lmat( 460)
         mat( 462) = mat( 462) + lmat( 462)
         mat( 466) = mat( 466) + lmat( 466)
         mat( 480) = mat( 480) + lmat( 480)
         mat( 496) = mat( 496) + lmat( 496)
         mat( 508) = mat( 508) + lmat( 508)
         mat( 516) = mat( 516) + lmat( 516)
         mat( 522) = mat( 522) + lmat( 522)
         mat( 533) = mat( 533) + lmat( 533)
         mat( 535) = lmat( 535)
         mat( 536) = lmat( 536)
         mat( 538) = mat( 538) + lmat( 538)
         mat( 540) = lmat( 540)
         mat( 541) = mat( 541) + lmat( 541)
         mat( 545) = lmat( 545)
         mat( 548) = lmat( 548)
         mat( 550) = mat( 550) + lmat( 550)
         mat( 551) = mat( 551) + lmat( 551)
         mat( 554) = mat( 554) + lmat( 554)
         mat( 555) = lmat( 555)
         mat( 558) = mat( 558) + lmat( 558)
         mat( 560) = mat( 560) + lmat( 560)
         mat( 563) = mat( 563) + lmat( 563)
         mat( 564) = mat( 564) + lmat( 564)
         mat( 565) = mat( 565) + lmat( 565)
         mat( 570) = lmat( 570)
         mat( 579) = mat( 579) + lmat( 579)
         mat( 590) = lmat( 590)
         mat( 591) = mat( 591) + lmat( 591)
         mat( 595) = mat( 595) + lmat( 595)
         mat( 597) = lmat( 597)
         mat( 600) = lmat( 600)
         mat( 616) = mat( 616) + lmat( 616)
         mat( 638) = mat( 638) + lmat( 638)
         mat( 656) = mat( 656) + lmat( 656)
         mat( 683) = mat( 683) + lmat( 683)
         mat( 694) = lmat( 694)
         mat( 695) = mat( 695) + lmat( 695)
         mat( 696) = lmat( 696)
         mat( 698) = mat( 698) + lmat( 698)
         mat( 700) = mat( 700) + lmat( 700)
         mat( 701) = lmat( 701)
         mat( 704) = mat( 704) + lmat( 704)
         mat( 707) = mat( 707) + lmat( 707)
         mat( 736) = mat( 736) + lmat( 736)
         mat( 753) = mat( 753) + lmat( 753)
         mat( 766) = lmat( 766)
         mat( 767) = mat( 767) + lmat( 767)
         mat( 769) = mat( 769) + lmat( 769)
         mat( 771) = mat( 771) + lmat( 771)
         mat( 790) = mat( 790) + lmat( 790)
         mat( 795) = lmat( 795)
         mat( 796) = lmat( 796)
         mat( 798) = mat( 798) + lmat( 798)
         mat( 802) = mat( 802) + lmat( 802)
         mat( 803) = mat( 803) + lmat( 803)
         mat( 820) = mat( 820) + lmat( 820)
         mat( 833) = mat( 833) + lmat( 833)
         mat( 835) = mat( 835) + lmat( 835)
         mat( 840) = mat( 840) + lmat( 840)
         mat( 841) = mat( 841) + lmat( 841)
         mat( 855) = mat( 855) + lmat( 855)
         mat( 857) = mat( 857) + lmat( 857)
         mat( 863) = mat( 863) + lmat( 863)
         mat( 942) = mat( 942) + lmat( 942)
         mat( 944) = mat( 944) + lmat( 944)
         mat( 945) = mat( 945) + lmat( 945)
         mat( 947) = mat( 947) + lmat( 947)
         mat( 950) = mat( 950) + lmat( 950)
         mat( 951) = mat( 951) + lmat( 951)
         mat( 980) = mat( 980) + lmat( 980)
         mat(1018) = mat(1018) + lmat(1018)
         mat(1033) = lmat(1033)
         mat(1036) = mat(1036) + lmat(1036)
         mat(1041) = mat(1041) + lmat(1041)
         mat(1056) = mat(1056) + lmat(1056)
         mat(1079) = mat(1079) + lmat(1079)
         mat(1084) = mat(1084) + lmat(1084)
         mat(1086) = mat(1086) + lmat(1086)
         mat(1087) = mat(1087) + lmat(1087)
         mat(1092) = mat(1092) + lmat(1092)
         mat(1094) = mat(1094) + lmat(1094)
         mat(1095) = lmat(1095)
         mat(1096) = mat(1096) + lmat(1096)
         mat(1097) = lmat(1097)
         mat(1098) = mat(1098) + lmat(1098)
         mat(1101) = mat(1101) + lmat(1101)
         mat(1102) = lmat(1102)
         mat(1105) = mat(1105) + lmat(1105)
         mat(1106) = lmat(1106)
         mat(1107) = lmat(1107)
         mat(1132) = mat(1132) + lmat(1132)
         mat(1135) = mat(1135) + lmat(1135)
         mat(1136) = mat(1136) + lmat(1136)
         mat(1183) = mat(1183) + lmat(1183)
         mat(1184) = mat(1184) + lmat(1184)
         mat(1194) = mat(1194) + lmat(1194)
         mat(1204) = mat(1204) + lmat(1204)
         mat(1206) = mat(1206) + lmat(1206)
         mat(1242) = mat(1242) + lmat(1242)
         mat(1243) = mat(1243) + lmat(1243)
         mat(1246) = mat(1246) + lmat(1246)
         mat( 208) = 0._r8
         mat( 211) = 0._r8
         mat( 244) = 0._r8
         mat( 288) = 0._r8
         mat( 291) = 0._r8
         mat( 320) = 0._r8
         mat( 323) = 0._r8
         mat( 325) = 0._r8
         mat( 334) = 0._r8
         mat( 340) = 0._r8
         mat( 343) = 0._r8
         mat( 345) = 0._r8
         mat( 346) = 0._r8
         mat( 349) = 0._r8
         mat( 360) = 0._r8
         mat( 362) = 0._r8
         mat( 365) = 0._r8
         mat( 376) = 0._r8
         mat( 383) = 0._r8
         mat( 404) = 0._r8
         mat( 406) = 0._r8
         mat( 407) = 0._r8
         mat( 411) = 0._r8
         mat( 428) = 0._r8
         mat( 429) = 0._r8
         mat( 447) = 0._r8
         mat( 458) = 0._r8
         mat( 467) = 0._r8
         mat( 470) = 0._r8
         mat( 471) = 0._r8
         mat( 472) = 0._r8
         mat( 474) = 0._r8
         mat( 482) = 0._r8
         mat( 484) = 0._r8
         mat( 485) = 0._r8
         mat( 488) = 0._r8
         mat( 492) = 0._r8
         mat( 497) = 0._r8
         mat( 499) = 0._r8
         mat( 501) = 0._r8
         mat( 504) = 0._r8
         mat( 526) = 0._r8
         mat( 530) = 0._r8
         mat( 544) = 0._r8
         mat( 546) = 0._r8
         mat( 557) = 0._r8
         mat( 567) = 0._r8
         mat( 568) = 0._r8
         mat( 581) = 0._r8
         mat( 582) = 0._r8
         mat( 586) = 0._r8
         mat( 592) = 0._r8
         mat( 598) = 0._r8
         mat( 599) = 0._r8
         mat( 602) = 0._r8
         mat( 605) = 0._r8
         mat( 606) = 0._r8
         mat( 615) = 0._r8
         mat( 617) = 0._r8
         mat( 619) = 0._r8
         mat( 620) = 0._r8
         mat( 624) = 0._r8
         mat( 632) = 0._r8
         mat( 634) = 0._r8
         mat( 635) = 0._r8
         mat( 637) = 0._r8
         mat( 639) = 0._r8
         mat( 641) = 0._r8
         mat( 642) = 0._r8
         mat( 646) = 0._r8
         mat( 650) = 0._r8
         mat( 654) = 0._r8
         mat( 655) = 0._r8
         mat( 658) = 0._r8
         mat( 659) = 0._r8
         mat( 663) = 0._r8
         mat( 684) = 0._r8
         mat( 685) = 0._r8
         mat( 689) = 0._r8
         mat( 691) = 0._r8
         mat( 697) = 0._r8
         mat( 699) = 0._r8
         mat( 705) = 0._r8
         mat( 708) = 0._r8
         mat( 709) = 0._r8
         mat( 734) = 0._r8
         mat( 735) = 0._r8
         mat( 741) = 0._r8
         mat( 743) = 0._r8
         mat( 744) = 0._r8
         mat( 745) = 0._r8
         mat( 746) = 0._r8
         mat( 748) = 0._r8
         mat( 751) = 0._r8
         mat( 752) = 0._r8
         mat( 755) = 0._r8
         mat( 756) = 0._r8
         mat( 758) = 0._r8
         mat( 759) = 0._r8
         mat( 760) = 0._r8
         mat( 773) = 0._r8
         mat( 778) = 0._r8
         mat( 780) = 0._r8
         mat( 781) = 0._r8
         mat( 782) = 0._r8
         mat( 791) = 0._r8
         mat( 792) = 0._r8
         mat( 793) = 0._r8
         mat( 799) = 0._r8
         mat( 805) = 0._r8
         mat( 806) = 0._r8
         mat( 807) = 0._r8
         mat( 808) = 0._r8
         mat( 818) = 0._r8
         mat( 819) = 0._r8
         mat( 822) = 0._r8
         mat( 823) = 0._r8
         mat( 824) = 0._r8
         mat( 827) = 0._r8
         mat( 828) = 0._r8
         mat( 829) = 0._r8
         mat( 830) = 0._r8
         mat( 831) = 0._r8
         mat( 832) = 0._r8
         mat( 837) = 0._r8
         mat( 839) = 0._r8
         mat( 850) = 0._r8
         mat( 851) = 0._r8
         mat( 861) = 0._r8
         mat( 862) = 0._r8
         mat( 866) = 0._r8
         mat( 903) = 0._r8
         mat( 928) = 0._r8
         mat( 954) = 0._r8
         mat( 956) = 0._r8
         mat( 960) = 0._r8
         mat( 975) = 0._r8
         mat( 981) = 0._r8
         mat( 985) = 0._r8
         mat( 989) = 0._r8
         mat( 997) = 0._r8
         mat( 999) = 0._r8
         mat(1000) = 0._r8
         mat(1002) = 0._r8
         mat(1021) = 0._r8
         mat(1034) = 0._r8
         mat(1035) = 0._r8
         mat(1037) = 0._r8
         mat(1038) = 0._r8
         mat(1040) = 0._r8
         mat(1042) = 0._r8
         mat(1045) = 0._r8
         mat(1046) = 0._r8
         mat(1047) = 0._r8
         mat(1063) = 0._r8
         mat(1074) = 0._r8
         mat(1075) = 0._r8
         mat(1076) = 0._r8
         mat(1078) = 0._r8
         mat(1080) = 0._r8
         mat(1083) = 0._r8
         mat(1085) = 0._r8
         mat(1088) = 0._r8
         mat(1089) = 0._r8
         mat(1099) = 0._r8
         mat(1100) = 0._r8
         mat(1104) = 0._r8
         mat(1108) = 0._r8
         mat(1115) = 0._r8
         mat(1120) = 0._r8
         mat(1131) = 0._r8
         mat(1170) = 0._r8
         mat(1171) = 0._r8
         mat(1180) = 0._r8
         mat(1182) = 0._r8
         mat(1191) = 0._r8
         mat(1192) = 0._r8
         mat(1193) = 0._r8
         mat(1195) = 0._r8
         mat(1201) = 0._r8
         mat(1202) = 0._r8
         mat(1203) = 0._r8
         mat(1207) = 0._r8
         mat(1210) = 0._r8
         mat(1213) = 0._r8
         mat(1215) = 0._r8
         mat(1217) = 0._r8
         mat(1219) = 0._r8
         mat(1220) = 0._r8
         mat(1224) = 0._r8
         mat(1226) = 0._r8
         mat(1227) = 0._r8
         mat(1229) = 0._r8
         mat(1230) = 0._r8
         mat(1240) = 0._r8
         mat( 1) = mat( 1) - dti
         mat( 2) = mat( 2) - dti
         mat( 3) = mat( 3) - dti
         mat( 4) = mat( 4) - dti
         mat( 5) = mat( 5) - dti
         mat( 6) = mat( 6) - dti
         mat( 7) = mat( 7) - dti
         mat( 8) = mat( 8) - dti
         mat( 9) = mat( 9) - dti
         mat( 10) = mat( 10) - dti
         mat( 11) = mat( 11) - dti
         mat( 12) = mat( 12) - dti
         mat( 13) = mat( 13) - dti
         mat( 14) = mat( 14) - dti
         mat( 15) = mat( 15) - dti
         mat( 16) = mat( 16) - dti
         mat( 17) = mat( 17) - dti
         mat( 18) = mat( 18) - dti
         mat( 19) = mat( 19) - dti
         mat( 20) = mat( 20) - dti
         mat( 21) = mat( 21) - dti
         mat( 22) = mat( 22) - dti
         mat( 23) = mat( 23) - dti
         mat( 24) = mat( 24) - dti
         mat( 25) = mat( 25) - dti
         mat( 26) = mat( 26) - dti
         mat( 27) = mat( 27) - dti
         mat( 28) = mat( 28) - dti
         mat( 29) = mat( 29) - dti
         mat( 30) = mat( 30) - dti
         mat( 31) = mat( 31) - dti
         mat( 32) = mat( 32) - dti
         mat( 33) = mat( 33) - dti
         mat( 34) = mat( 34) - dti
         mat( 35) = mat( 35) - dti
         mat( 38) = mat( 38) - dti
         mat( 41) = mat( 41) - dti
         mat( 44) = mat( 44) - dti
         mat( 47) = mat( 47) - dti
         mat( 50) = mat( 50) - dti
         mat( 54) = mat( 54) - dti
         mat( 59) = mat( 59) - dti
         mat( 62) = mat( 62) - dti
         mat( 66) = mat( 66) - dti
         mat( 68) = mat( 68) - dti
         mat( 71) = mat( 71) - dti
         mat( 77) = mat( 77) - dti
         mat( 79) = mat( 79) - dti
         mat( 83) = mat( 83) - dti
         mat( 87) = mat( 87) - dti
         mat( 92) = mat( 92) - dti
         mat( 98) = mat( 98) - dti
         mat( 103) = mat( 103) - dti
         mat( 106) = mat( 106) - dti
         mat( 110) = mat( 110) - dti
         mat( 114) = mat( 114) - dti
         mat( 120) = mat( 120) - dti
         mat( 126) = mat( 126) - dti
         mat( 131) = mat( 131) - dti
         mat( 136) = mat( 136) - dti
         mat( 140) = mat( 140) - dti
         mat( 147) = mat( 147) - dti
         mat( 152) = mat( 152) - dti
         mat( 155) = mat( 155) - dti
         mat( 163) = mat( 163) - dti
         mat( 169) = mat( 169) - dti
         mat( 175) = mat( 175) - dti
         mat( 179) = mat( 179) - dti
         mat( 183) = mat( 183) - dti
         mat( 189) = mat( 189) - dti
         mat( 195) = mat( 195) - dti
         mat( 201) = mat( 201) - dti
         mat( 207) = mat( 207) - dti
         mat( 214) = mat( 214) - dti
         mat( 221) = mat( 221) - dti
         mat( 228) = mat( 228) - dti
         mat( 234) = mat( 234) - dti
         mat( 239) = mat( 239) - dti
         mat( 247) = mat( 247) - dti
         mat( 253) = mat( 253) - dti
         mat( 261) = mat( 261) - dti
         mat( 269) = mat( 269) - dti
         mat( 277) = mat( 277) - dti
         mat( 287) = mat( 287) - dti
         mat( 294) = mat( 294) - dti
         mat( 298) = mat( 298) - dti
         mat( 305) = mat( 305) - dti
         mat( 314) = mat( 314) - dti
         mat( 319) = mat( 319) - dti
         mat( 330) = mat( 330) - dti
         mat( 341) = mat( 341) - dti
         mat( 352) = mat( 352) - dti
         mat( 359) = mat( 359) - dti
         mat( 371) = mat( 371) - dti
         mat( 380) = mat( 380) - dti
         mat( 389) = mat( 389) - dti
         mat( 394) = mat( 394) - dti
         mat( 403) = mat( 403) - dti
         mat( 414) = mat( 414) - dti
         mat( 420) = mat( 420) - dti
         mat( 436) = mat( 436) - dti
         mat( 446) = mat( 446) - dti
         mat( 456) = mat( 456) - dti
         mat( 466) = mat( 466) - dti
         mat( 480) = mat( 480) - dti
         mat( 496) = mat( 496) - dti
         mat( 508) = mat( 508) - dti
         mat( 516) = mat( 516) - dti
         mat( 522) = mat( 522) - dti
         mat( 533) = mat( 533) - dti
         mat( 541) = mat( 541) - dti
         mat( 551) = mat( 551) - dti
         mat( 564) = mat( 564) - dti
         mat( 579) = mat( 579) - dti
         mat( 595) = mat( 595) - dti
         mat( 616) = mat( 616) - dti
         mat( 638) = mat( 638) - dti
         mat( 656) = mat( 656) - dti
         mat( 683) = mat( 683) - dti
         mat( 695) = mat( 695) - dti
         mat( 704) = mat( 704) - dti
         mat( 736) = mat( 736) - dti
         mat( 753) = mat( 753) - dti
         mat( 771) = mat( 771) - dti
         mat( 798) = mat( 798) - dti
         mat( 833) = mat( 833) - dti
         mat( 857) = mat( 857) - dti
         mat( 950) = mat( 950) - dti
         mat(1018) = mat(1018) - dti
         mat(1041) = mat(1041) - dti
         mat(1084) = mat(1084) - dti
         mat(1105) = mat(1105) - dti
         mat(1132) = mat(1132) - dti
         mat(1184) = mat(1184) - dti
         mat(1206) = mat(1206) - dti
         mat(1246) = mat(1246) - dti
      end subroutine nlnmat_finit
      subroutine nlnmat( mat, y, rxt, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)
      call nlnmat01( mat, y, rxt )
      call nlnmat02( mat, y, rxt )
      call nlnmat03( mat, y, rxt )
      call nlnmat04( mat, y, rxt )
      call nlnmat05( mat, y, rxt )
      call nlnmat06( mat, y, rxt )
      call nlnmat_finit( mat, lmat, dti )
      end subroutine nlnmat
      end module mo_nln_matrix
