
      module mo_sim_dat

      private
      public :: set_sim_dat

      contains

      subroutine set_sim_dat

      use chem_mods,     only : clscnt, cls_rxt_cnt, clsmap, permute, adv_mass, fix_mass, crb_mass
      use chem_mods,     only : diag_map
      use chem_mods,     only : phtcnt, rxt_tag_cnt, rxt_tag_lst, rxt_tag_map
      use chem_mods,     only : pht_alias_lst, pht_alias_mult
      use chem_mods,     only : extfrc_lst, inv_lst, slvd_lst
      use chem_mods,     only : enthalpy_cnt, cph_enthalpy, cph_rid
      use cam_abortutils,only : endrun
      use mo_tracname,   only : solsym
      use chem_mods,     only : frc_from_dataset
      use shr_kind_mod,  only : r8 => shr_kind_r8
      use cam_logfile,   only : iulog

      implicit none

!--------------------------------------------------------------
!      ... local variables
!--------------------------------------------------------------
      integer :: ios

      clscnt(:) = (/     23,     0,     0,   139,     0 /)

      cls_rxt_cnt(:,1) = (/     19,    60,     0,    23 /)
      cls_rxt_cnt(:,4) = (/     31,   151,   267,   139 /)

      solsym(:162) = (/ 'O3              ','O               ','O2              ','N2O             ','N               ', &
                        'NO              ','NO2             ','NO3             ','HNO3            ','HO2NO2          ', &
                        'N2O5            ','CH4             ','CH3O2           ','CH3OOH          ','CH3OH           ', &
                        'CH2O            ','CO              ','H2              ','H               ','H2O2            ', &
                        'CLY             ','BRY             ','CL2             ','CLO             ','OCLO            ', &
                        'CL2O2           ','HCL             ','HOCL            ','CLONO2          ','BRCL            ', &
                        'BRO             ','HBR             ','HOBR            ','BRONO2          ','HCN             ', &
                        'CH3CN           ','C2H4            ','C2H6            ','C2H5OOH         ','CH3COOH         ', &
                        'CH3CHO          ','C2H5OH          ','GLYALD          ','GLYOXAL         ','CH3COOOH        ', &
                        'EOOH            ','PAN             ','C3H6            ','C3H8            ','C3H7OOH         ', &
                        'CH3COCH3        ','POOH            ','HYAC            ','CH3COCHO        ','ROOH            ', &
                        'BIGENE          ','BIGALK          ','MEK             ','MEKOOH          ','MVK             ', &
                        'MACR            ','MACROOH         ','MPAN            ','ONIT            ','ISOP            ', &
                        'ALKOOH          ','BIGALD          ','HYDRALD         ','ISOPNO3         ','ONITR           ', &
                        'XOOH            ','ISOPOOH         ','TOLUENE         ','CRESOL          ','TOLOOH          ', &
                        'XOH             ','C10H16          ','TERPOOH         ','CH3CL           ','CH3BR           ', &
                        'CFC11           ','CFC12           ','CFC113          ','HCFC22          ','CCL4            ', &
                        'CH3CCL3         ','CF3BR           ','CF2CLBR         ','HCFC141B        ','HCFC142B        ', &
                        'CFC114          ','CFC115          ','H1202           ','H2402           ','CHBR3           ', &
                        'CH2BR2          ','CO2             ','C2H2            ','HCOOH           ','COF2            ', &
                        'COFCL           ','HF              ','F               ','SO2             ','DMS             ', &
                        'OCS             ','S               ','SO              ','SO3             ','H2SO4           ', &
                        'SOAG            ','so4_a1          ','pom_a1          ','soa_a1          ','bc_a1           ', &
                        'dst_a1          ','ncl_a1          ','num_a1          ','so4_a2          ','soa_a2          ', &
                        'ncl_a2          ','dst_a2          ','num_a2          ','dst_a3          ','ncl_a3          ', &
                        'so4_a3          ','num_a3          ','pom_a4          ','bc_a4           ','num_a4          ', &
                        'CL              ','BR              ','OH              ','HO2             ','HOCH2OO         ', &
                        'C2H5O2          ','CH3CO3          ','EO2             ','EO              ','C3H7O2          ', &
                        'PO2             ','RO2             ','ENEO2           ','MEKO2           ','MCO3            ', &
                        'MACRO2          ','ALKO2           ','ISOPO2          ','XO2             ','TOLO2           ', &
                        'TERPO2          ','N2p             ','O2p             ','Np              ','Op              ', &
                        'NOp             ','e               ','N2D             ','O2_1S           ','O2_1D           ', &
                        'O1D             ','H2O             ' /)

      adv_mass(:162) = (/    47.998200_r8,    15.999400_r8,    31.998800_r8,    44.012880_r8,    14.006740_r8, &
                             30.006140_r8,    46.005540_r8,    62.004940_r8,    63.012340_r8,    79.011740_r8, &
                            108.010480_r8,    16.040600_r8,    47.032000_r8,    48.039400_r8,    32.040000_r8, &
                             30.025200_r8,    28.010400_r8,     2.014800_r8,     1.007400_r8,    34.013600_r8, &
                            100.916850_r8,    99.716850_r8,    70.905400_r8,    51.452100_r8,    67.451500_r8, &
                            102.904200_r8,    36.460100_r8,    52.459500_r8,    97.457640_r8,   115.356700_r8, &
                             95.903400_r8,    80.911400_r8,    96.910800_r8,   141.908940_r8,    27.025140_r8, &
                             41.050940_r8,    28.051600_r8,    30.066400_r8,    62.065200_r8,    60.050400_r8, &
                             44.051000_r8,    46.065800_r8,    60.050400_r8,    58.035600_r8,    76.049800_r8, &
                             78.064600_r8,   121.047940_r8,    42.077400_r8,    44.092200_r8,    76.091000_r8, &
                             58.076800_r8,    92.090400_r8,    74.076200_r8,    72.061400_r8,    90.075600_r8, &
                             56.103200_r8,    72.143800_r8,    72.102600_r8,   104.101400_r8,    70.087800_r8, &
                             70.087800_r8,   120.100800_r8,   147.084740_r8,   119.074340_r8,    68.114200_r8, &
                            104.142600_r8,    98.098200_r8,   100.113000_r8,   162.117940_r8,   147.125940_r8, &
                            150.126000_r8,   118.127200_r8,    92.136200_r8,   108.135600_r8,   174.148000_r8, &
                            190.147400_r8,   136.228400_r8,   186.241400_r8,    50.485900_r8,    94.937200_r8, &
                            137.367503_r8,   120.913206_r8,   187.375310_r8,    86.467906_r8,   153.821800_r8, &
                            133.402300_r8,   148.910210_r8,   165.364506_r8,   116.948003_r8,   100.493706_r8, &
                            170.921013_r8,   154.466716_r8,   209.815806_r8,   259.823613_r8,   252.730400_r8, &
                            173.833800_r8,    44.009800_r8,    26.036800_r8,    46.024600_r8,    66.007206_r8, &
                             82.461503_r8,    20.005803_r8,    18.998403_r8,    64.064800_r8,    62.132400_r8, &
                             60.076400_r8,    32.066000_r8,    48.065400_r8,    80.064200_r8,    98.078400_r8, &
                             12.011000_r8,   115.107340_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8, &
                            135.064039_r8,    58.442468_r8,     1.007400_r8,   115.107340_r8,    12.011000_r8, &
                             58.442468_r8,   135.064039_r8,     1.007400_r8,   135.064039_r8,    58.442468_r8, &
                            115.107340_r8,     1.007400_r8,    12.011000_r8,    12.011000_r8,     1.007400_r8, &
                             35.452700_r8,    79.904000_r8,    17.006800_r8,    33.006200_r8,    63.031400_r8, &
                             61.057800_r8,    75.042400_r8,    77.057200_r8,    61.057800_r8,    75.083600_r8, &
                             91.083000_r8,    89.068200_r8,   105.108800_r8,   103.094000_r8,   101.079200_r8, &
                            119.093400_r8,   103.135200_r8,   117.119800_r8,   149.118600_r8,   173.140600_r8, &
                            185.234000_r8,    28.013480_r8,    31.998800_r8,    14.006740_r8,    15.999400_r8, &
                             30.006140_r8, 0.548567E-03_r8,    14.006740_r8,    31.998800_r8,    31.998800_r8, &
                             15.999400_r8,    18.014200_r8 /)

      crb_mass(:162) = (/     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8, &
                             12.011000_r8,    12.011000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                             12.011000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,    12.011000_r8, &
                             24.022000_r8,    24.022000_r8,    24.022000_r8,    24.022000_r8,    24.022000_r8, &
                             24.022000_r8,    24.022000_r8,    24.022000_r8,    24.022000_r8,    24.022000_r8, &
                             24.022000_r8,    24.022000_r8,    36.033000_r8,    36.033000_r8,    36.033000_r8, &
                             36.033000_r8,    36.033000_r8,    36.033000_r8,    36.033000_r8,    36.033000_r8, &
                             48.044000_r8,    60.055000_r8,    48.044000_r8,    48.044000_r8,    48.044000_r8, &
                             48.044000_r8,    48.044000_r8,    48.044000_r8,    36.033000_r8,    60.055000_r8, &
                             60.055000_r8,    60.055000_r8,    60.055000_r8,    60.055000_r8,    60.055000_r8, &
                             60.055000_r8,    60.055000_r8,    84.077000_r8,    84.077000_r8,    84.077000_r8, &
                             84.077000_r8,   120.110000_r8,   120.110000_r8,    12.011000_r8,    12.011000_r8, &
                             12.011000_r8,    12.011000_r8,    24.022000_r8,    12.011000_r8,    12.011000_r8, &
                             24.022000_r8,    12.011000_r8,    12.011000_r8,    24.022000_r8,    24.022000_r8, &
                             24.022000_r8,    24.022000_r8,    12.011000_r8,    24.022000_r8,    12.011000_r8, &
                             12.011000_r8,    12.011000_r8,    24.022000_r8,    12.011000_r8,    12.011000_r8, &
                             12.011000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,    24.022000_r8, &
                             12.011000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                             12.011000_r8,     0.000000_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,    12.011000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,    12.011000_r8,    12.011000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,    12.011000_r8, &
                             24.022000_r8,    24.022000_r8,    24.022000_r8,    24.022000_r8,    36.033000_r8, &
                             36.033000_r8,    36.033000_r8,    48.044000_r8,    48.044000_r8,    48.044000_r8, &
                             48.044000_r8,    60.055000_r8,    60.055000_r8,    60.055000_r8,    84.077000_r8, &
                            120.110000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8 /)

      fix_mass(:  2) = (/ 0.00000000_r8, 28.0134800_r8 /)

      clsmap(: 23,1) = (/   12,   4,  79,  80,  81,  82,  83,  91,  92,  84, &
                            89,  90,  85,  86,  87,  88,  93,  94,  95,  96, &
                            97,  21,  22 /)
      clsmap(:139,4) = (/    1,   2, 161,   3, 159, 160,  18,  17,   5,   6, &
                             7, 133,   8,   9,  10,  11,  13,  14,  35,  36, &
                            16,  19, 134,  20, 162, 131,  23,  24,  25,  26, &
                            27,  28,  29,  30, 132,  31,  32,  33,  34, 152, &
                           153, 154, 155, 156, 158, 157,  48,  65, 141,  41, &
                            40,  52, 137,  45,  47,  64,  38,  37,  57,  63, &
                            56, 143, 147,  66,  58, 144,  59,  73,  74, 150, &
                            75,  76, 151,  78,  67,  44, 148,  60,  61, 146, &
                            62, 145, 136,  39,  77,  49, 140,  50,  51,  55, &
                            15,  42,  43,  53, 138, 139,  46,  68, 142,  54, &
                            69,  70, 149,  71,  72,  98,  99, 135, 100, 101, &
                           102, 103, 104, 105, 106, 107, 108, 109, 110, 111, &
                           112, 113, 114, 115, 116, 117, 118, 119, 120, 121, &
                           123, 122, 124, 125, 126, 127, 128, 129, 130 /)

      permute(:139,4) = (/  128, 125, 139, 124,  32,  31, 112, 107,  95, 129, &
                            130, 131, 132, 133,  64,  44, 123,  58,  36,  24, &
                            126, 135, 136,  79, 127, 137,  33, 134,  50,  21, &
                            121,  98, 104,  37, 122, 138,  94,  91,  70,  80, &
                             88,  63,  78,  89,  66,  90, 106,  97,  93, 108, &
                             77,  74, 119,  65,  62,  53,  41,  75,  22,  71, &
                             23,  45,  84,  81,  59,  82,  46,  26,  27,  67, &
                             54,  34, 102,  61,  68,  83, 115, 117, 111, 116, &
                             47, 118,  96,  48,  76,  25, 100,  55,  85,  56, &
                             69,  39,  99, 109,  87,  60,  28,  51, 110, 113, &
                            105, 101, 114,  49,  72,  42,  73,  57,  29,  35, &
                             38,  92, 103,  43,  52,  86, 120,  40,  30,   1, &
                              2,   3,   4,   5,   6,   7,   8,   9,  10,  11, &
                             12,  13,  14,  15,  16,  17,  18,  19,  20 /)

      diag_map(:139) = (/    1,   2,   3,   4,   5,   6,   7,   8,   9,  10, &
                            11,  12,  13,  14,  15,  16,  17,  18,  19,  20, &
                            21,  24,  27,  30,  33,  37,  42,  45,  48,  51, &
                            54,  57,  59,  61,  65,  69,  73,  76,  79,  84, &
                            88,  94, 100, 106, 112, 119, 124, 129, 134, 138, &
                           143, 146, 154, 158, 164, 170, 176, 182, 188, 193, &
                           198, 205, 212, 219, 226, 232, 238, 246, 252, 256, &
                           264, 272, 280, 284, 293, 301, 310, 314, 321, 330, &
                           341, 352, 359, 367, 378, 384, 393, 401, 410, 421, &
                           429, 438, 447, 457, 469, 481, 491, 507, 515, 522, &
                           535, 545, 557, 565, 577, 592, 607, 612, 621, 630, &
                           642, 655, 667, 682, 702, 726, 745, 765, 794, 810, &
                           829, 844, 877, 908, 948, 973,1000,1046,1102,1140, &
                          1239,1284,1307,1335,1356,1426,1462,1487,1514 /)

      extfrc_lst(: 21) = (/ 'NO              ','NO2             ','CO              ','SO2             ','so4_a1          ', &
                            'so4_a2          ','pom_a1          ','pom_a4          ','bc_a1           ','bc_a4           ', &
                            'num_a1          ','num_a2          ','num_a4          ','Op              ','O2p             ', &
                            'Np              ','N2p             ','N2D             ','N               ','e               ', &
                            'OH              ' /)

      frc_from_dataset(: 21) = (/ .true., .true., .true., .true., .true., &
                                  .true., .true., .true., .true., .true., &
                                  .true., .true., .true., .false., .false., &
                                  .false., .false., .false., .false., .false., &
                                  .false. /)

      inv_lst(:  2) = (/ 'M               ', 'N2              ' /)

      slvd_lst(: 31) = (/ 'CL              ', 'BR              ', 'OH              ', 'HO2             ', 'HOCH2OO         ', &
                          'C2H5O2          ', 'CH3CO3          ', 'EO2             ', 'EO              ', 'C3H7O2          ', &
                          'PO2             ', 'RO2             ', 'ENEO2           ', 'MEKO2           ', 'MCO3            ', &
                          'MACRO2          ', 'ALKO2           ', 'ISOPO2          ', 'XO2             ', 'TOLO2           ', &
                          'TERPO2          ', 'Op              ', 'O2p             ', 'NOp             ', 'Np              ', &
                          'N2p             ', 'e               ', 'O2_1S           ', 'O2_1D           ', 'N2D             ', &
                          'O1D             ' /)

      if( allocated( rxt_tag_lst ) ) then
         deallocate( rxt_tag_lst )
      end if
      allocate( rxt_tag_lst(rxt_tag_cnt),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate rxt_tag_lst; error = ',ios
         call endrun
      end if
      if( allocated( rxt_tag_map ) ) then
         deallocate( rxt_tag_map )
      end if
      allocate( rxt_tag_map(rxt_tag_cnt),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate rxt_tag_map; error = ',ios
         call endrun
      end if
      rxt_tag_lst(:rxt_tag_cnt) = (/ 'jo2_a           ', 'jo2_b           ', 'jo3_a           ', 'jo3_b           ', &
                                     'jn2o            ', 'jno             ', 'jno_i           ', 'jno2            ', &
                                     'jn2o5_a         ', 'jn2o5_b         ', 'jhno3           ', 'jno3_a          ', &
                                     'jno3_b          ', 'jho2no2_a       ', 'jho2no2_b       ', 'jch3ooh         ', &
                                     'jch2o_a         ', 'jch2o_b         ', 'jh2o_a          ', 'jh2o_b          ', &
                                     'jh2o_c          ', 'jh2o2           ', 'jcl2            ', 'jclo            ', &
                                     'joclo           ', 'jcl2o2          ', 'jhocl           ', 'jhcl            ', &
                                     'jclono2_a       ', 'jclono2_b       ', 'jbrcl           ', 'jbro            ', &
                                     'jhobr           ', 'jhbr            ', 'jbrono2_a       ', 'jbrono2_b       ', &
                                     'jch3cl          ', 'jccl4           ', 'jch3ccl3        ', 'jcfcl3          ', &
                                     'jcf2cl2         ', 'jcfc113         ', 'jcfc114         ', 'jcfc115         ', &
                                     'jhcfc22         ', 'jhcfc141b       ', 'jhcfc142b       ', 'jch3br          ', &
                                     'jcf3br          ', 'jcf2clbr        ', 'jchbr3          ', 'jch2br2         ', &
                                     'jh1202          ', 'jh2402          ', 'jcof2           ', 'jcofcl          ', &
                                     'jhf             ', 'jco2            ', 'jch4_a          ', 'jch4_b          ', &
                                     'jch3cho         ', 'jpooh           ', 'jch3co3h        ', 'jpan            ', &
                                     'jmpan           ', 'jmacr_a         ', 'jmacr_b         ', 'jmvk            ', &
                                     'jc2h5ooh        ', 'jeooh           ', 'jc3h7ooh        ', 'jrooh           ', &
                                     'jacet           ', 'jmgly           ', 'jxooh           ', 'jonitr          ', &
                                     'jisopooh        ', 'jhyac           ', 'jglyald         ', 'jmek            ', &
                                     'jbigald         ', 'jglyoxal        ', 'jalkooh         ', 'jmekooh         ', &
                                     'jtolooh         ', 'jterpooh        ', 'jh2so4          ', 'jso2            ', &
                                     'jso3            ', 'jocs            ', 'jso             ', 'jeuv_1          ', &
                                     'jeuv_2          ', 'jeuv_3          ', 'jeuv_4          ', 'jeuv_5          ', &
                                     'jeuv_6          ', 'jeuv_7          ', 'jeuv_8          ', 'jeuv_9          ', &
                                     'jeuv_10         ', 'jeuv_11         ', 'jeuv_12         ', 'jeuv_13         ', &
                                     'jeuv_14         ', 'jeuv_15         ', 'jeuv_16         ', 'jeuv_17         ', &
                                     'jeuv_18         ', 'jeuv_19         ', 'jeuv_20         ', 'jeuv_21         ', &
                                     'jeuv_22         ', 'jeuv_23         ', 'jeuv_24         ', 'jeuv_25         ', &
                                     'jeuv_26         ', 'usr_O_O2        ', 'O_O3            ', 'usr_O_O         ', &
                                     'O2_1S_O         ', 'O2_1S_O2        ', 'O2_1S_N2        ', 'O2_1S_O3        ', &
                                     'O2_1S_CO2       ', 'ag2             ', 'O2_1D_O         ', 'O2_1D_O2        ', &
                                     'O2_1D_N2        ', 'ag1             ', 'O1D_N2          ', 'O1D_O2          ', &
                                     'O1D_O2b         ', 'O1D_H2O         ', 'O1D_N2Oa        ', 'O1D_N2Ob        ', &
                                     'O1D_O3          ', 'O1D_CFC11       ', 'O1D_CFC12       ', 'O1D_CFC113      ', &
                                     'O1D_CFC114      ', 'O1D_CFC115      ', 'O1D_HCFC22      ', 'O1D_HCFC141B    ', &
                                     'O1D_HCFC142B    ', 'O1D_CCL4        ', 'O1D_CH3BR       ', 'O1D_CF2CLBR     ', &
                                     'O1D_CF3BR       ', 'O1D_H1202       ', 'O1D_H2402       ', 'O1D_CHBR3       ', &
                                     'O1D_CH2BR2      ', 'O1D_COF2        ', 'O1D_COFCL       ', 'O1D_CH4a        ', &
                                     'O1D_CH4b        ', 'O1D_CH4c        ', 'O1D_H2          ', 'O1D_HCL         ', &
                                     'O1D_HBR         ', 'O1D_HCN         ', 'H_O2            ', 'H_O3            ', &
                                     'H_HO2a          ', 'H_HO2           ', 'H_HO2b          ', 'OH_O            ', &
                                     'OH_O3           ', 'OH_HO2          ', 'OH_OH           ', 'OH_OH_M         ', &
                                     'OH_H2           ', 'OH_H2O2         ', 'H2_O            ', 'HO2_O           ', &
                                     'HO2_O3          ', 'usr_HO2_HO2     ', 'H2O2_O          ', 'HCN_OH          ', &
                                     'CH3CN_OH        ', 'N2D_O2          ', 'N2D_O           ', 'N_OH            ', &
                                     'N_O2            ', 'N_NO            ', 'N_NO2a          ', 'N_NO2b          ', &
                                     'N_NO2c          ', 'NO_O_M          ', 'NO_HO2          ', 'NO_O3           ', &
                                     'NO2_O           ', 'NO2_O_M         ', 'NO2_O3          ', 'tag_NO2_NO3     ', &
                                     'usr_N2O5_M      ', 'tag_NO2_OH      ', 'usr_HNO3_OH     ', 'NO3_NO          ', &
                                     'NO3_O           ', 'NO3_OH          ', 'NO3_HO2         ', 'tag_NO2_HO2     ', &
                                     'HO2NO2_OH       ', 'usr_HO2NO2_M    ', 'CL_O3           ', 'CL_H2           ', &
                                     'CL_H2O2         ', 'CL_HO2a         ', 'CL_HO2b         ', 'CL_CH2O         ', &
                                     'CL_CH4          ', 'CLO_O           ', 'CLO_OHa         ', 'CLO_OHb         ', &
                                     'CLO_HO2         ', 'CLO_CH3O2       ', 'CLO_NO          ', 'CLO_NO2_M       ', &
                                     'CLO_CLOa        ', 'CLO_CLOb        ', 'CLO_CLOc        ', 'tag_CLO_CLO_M   ', &
                                     'usr_CL2O2_M     ', 'HCL_OH          ', 'HCL_O           ', 'HOCL_O          ', &
                                     'HOCL_CL         ', 'HOCL_OH         ', 'CLONO2_O        ', 'CLONO2_OH       ', &
                                     'CLONO2_CL       ', 'BR_O3           ', 'BR_HO2          ', 'BR_CH2O         ', &
                                     'BRO_O           ', 'BRO_OH          ', 'BRO_HO2         ', 'BRO_NO          ', &
                                     'BRO_NO2_M       ', 'BRO_CLOa        ', 'BRO_CLOb        ', 'BRO_CLOc        ', &
                                     'BRO_BRO         ', 'HBR_OH          ', 'HBR_O           ', 'HOBR_O          ', &
                                     'BRONO2_O        ', 'F_H2O           ', 'F_H2            ', 'F_CH4           ', &
                                     'F_HNO3          ', 'CH3CL_CL        ', 'CH3CL_OH        ', 'CH3CCL3_OH      ', &
                                     'HCFC22_OH       ', 'CH3BR_OH        ', 'CH3BR_CL        ', 'HCFC141B_OH     ', &
                                     'HCFC142B_OH     ', 'CH2BR2_OH       ', 'CHBR3_OH        ', 'CH2BR2_CL       ', &
                                     'CHBR3_CL        ', 'CH4_OH          ', 'usr_CO_OH_b     ', 'CO_OH_M         ', &
                                     'CH2O_NO3        ', 'CH2O_OH         ', 'CH2O_O          ', 'CH2O_HO2        ', &
                                     'CH3O2_NO        ', 'CH3O2_HO2       ', 'CH3O2_CH3O2a    ', 'CH3O2_CH3O2b    ', &
                                     'CH3OH_OH        ', 'CH3OOH_OH       ', 'HCOOH_OH        ', 'HOCH2OO_M       ', &
                                     'HOCH2OO_NO      ', 'HOCH2OO_HO2     ', 'C2H2_CL_M       ', 'C2H4_CL_M       ', &
                                     'C2H6_CL         ', 'C2H2_OH_M       ', 'C2H6_OH         ', 'tag_C2H4_OH     ', &
                                     'EO2_NO          ', 'EO2_HO2         ', 'EO_O2           ', 'EO_M            ', &
                                     'C2H4_O3         ', 'CH3COOH_OH      ', 'C2H5O2_NO       ', 'C2H5O2_HO2      ', &
                                     'C2H5O2_CH3O2    ', 'C2H5O2_C2H5O2   ', 'C2H5OOH_OH      ', 'CH3CHO_OH       ', &
                                     'CH3CHO_NO3      ', 'CH3CO3_NO       ', 'tag_CH3CO3_NO2  ', 'CH3CO3_HO2      ', &
                                     'CH3CO3_CH3O2    ', 'CH3CO3_CH3CO3   ', 'CH3COOOH_OH     ', 'GLYALD_OH       ', &
                                     'GLYOXAL_OH      ', 'C2H5OH_OH       ', 'usr_PAN_M       ', 'PAN_OH          ', &
                                     'tag_C3H6_OH     ', 'C3H6_O3         ', 'C3H6_NO3        ', 'C3H7O2_NO       ', &
                                     'C3H7O2_HO2      ', 'CH3H7O2_CH3O2   ', 'CH3H7OOH_OH     ', 'C3H8_OH         ', &
                                     'PO2_NO          ', 'PO2_HO2         ', 'POOH_OH         ', 'usr_CH3COCH3_OH ', &
                                     'RO2_NO          ', 'RO2_HO2         ', 'RO2_CH3O2       ', 'ROOH_OH         ', &
                                     'HYAC_OH         ', 'CH3COCHO_OH     ', 'CH3COCHO_NO3    ', 'ONIT_OH         ', &
                                     'BIGENE_OH       ', 'ENEO2_NO        ', 'MVK_OH          ', 'MVK_O3          ', &
                                     'MEK_OH          ', 'MEKO2_NO        ', 'MEKO2_HO2       ', 'MEKOOH_OH       ', &
                                     'MACR_OH         ', 'MACR_O3         ', 'MACRO2_NOa      ', 'MACRO2_NOb      ', &
                                     'MACRO2_NO3      ', 'MACRO2_HO2      ', 'MACRO2_CH3O2    ', 'MACRO2_CH3CO3   ', &
                                     'MACROOH_OH      ', 'MCO3_NO         ', 'MCO3_NO3        ', 'MCO3_HO2        ', &
                                     'MCO3_CH3O2      ', 'MCO3_CH3CO3     ', 'MCO3_MCO3       ', 'usr_MCO3_NO2    ', &
                                     'usr_MPAN_M      ', 'MPAN_OH_M       ', 'ISOP_OH         ', 'ISOP_O3         ', &
                                     'ISOP_NO3        ', 'ISOPO2_NO       ', 'ISOPO2_NO3      ', 'ISOPO2_HO2      ', &
                                     'ISOPOOH_OH      ', 'ISOPO2_CH3O2    ', 'ISOPO2_CH3CO3   ', 'ISOPNO3_NO      ', &
                                     'ISOPNO3_NO3     ', 'ISOPNO3_HO2     ', 'BIGALK_OH       ', 'ONITR_OH        ', &
                                     'ONITR_NO3       ', 'HYDRALD_OH      ', 'ALKO2_NO        ', 'ALKO2_HO2       ', &
                                     'ALKOOH_OH       ', 'XO2_NO          ', 'XO2_NO3         ', 'XO2_HO2         ', &
                                     'XO2_CH3O2       ', 'XO2_CH3CO3      ', 'XOOH_OHa        ', 'usr_XOOH_OH     ', &
                                     'TOLUENE_OH      ', 'TOLO2_NO        ', 'TOLO2_HO2       ', 'TOLO2_OH        ', &
                                     'CRESOL_OH       ', 'XOH_NO2         ', 'C10H16_OH       ', 'C10H16_O3       ', &
                                     'C10H16_NO3      ', 'TERPO2_NO       ', 'TERPO2_HO2      ', 'TERPOOH_OH      ', &
                                     'usr_N2O5_aer    ', 'usr_NO3_aer     ', 'usr_NO2_aer     ', 'usr_HO2_aer     ', &
                                     'OCS_O           ', 'OCS_OH          ', 'S_OH            ', 'S_O2            ', &
                                     'S_O3            ', 'SO_OH           ', 'SO_O2           ', 'SO_O3           ', &
                                     'SO_NO2          ', 'SO_CLO          ', 'SO_BRO          ', 'SO_OCLO         ', &
                                     'usr_SO2_OH      ', 'usr_SO3_H2O     ', 'DMS_OHa         ', 'usr_DMS_OH      ', &
                                     'DMS_NO3         ', 'het1            ', 'het2            ', 'het3            ', &
                                     'het4            ', 'het5            ', 'het6            ', 'het7            ', &
                                     'het8            ', 'het9            ', 'het10           ', 'het11           ', &
                                     'het12           ', 'het13           ', 'het14           ', 'het15           ', &
                                     'het16           ', 'het17           ', 'ion_Op_O2       ', 'ion_Op_N2       ', &
                                     'ion_N2p_Oa      ', 'ion_N2p_Ob      ', 'ion_Op_CO2      ', 'ion_O2p_N       ', &
                                     'ion_O2p_NO      ', 'ion_Np_O2a      ', 'ion_Np_O2b      ', 'ion_Np_O        ', &
                                     'ion_N2p_O2      ', 'ion_O2p_N2      ', 'elec1           ', 'elec2           ', &
                                     'elec3           ' /)
      rxt_tag_map(:rxt_tag_cnt) = (/    1,   2,   3,   4,   5,   6,   7,   8,   9,  10, &
                                       11,  12,  13,  14,  15,  16,  17,  18,  19,  20, &
                                       21,  22,  23,  24,  25,  26,  27,  28,  29,  30, &
                                       31,  32,  33,  34,  35,  36,  37,  38,  39,  40, &
                                       41,  42,  43,  44,  45,  46,  47,  48,  49,  50, &
                                       51,  52,  53,  54,  55,  56,  57,  58,  59,  60, &
                                       61,  62,  63,  64,  65,  66,  67,  68,  69,  70, &
                                       71,  72,  73,  74,  75,  76,  77,  78,  79,  80, &
                                       81,  82,  83,  84,  85,  86,  87,  88,  89,  90, &
                                       91,  92,  93,  94,  95,  96,  97,  98,  99, 100, &
                                      101, 102, 103, 104, 105, 106, 107, 108, 109, 110, &
                                      111, 112, 113, 114, 115, 116, 117, 118, 119, 120, &
                                      121, 122, 123, 124, 125, 126, 127, 128, 129, 130, &
                                      131, 132, 133, 134, 135, 136, 137, 138, 139, 140, &
                                      141, 142, 143, 144, 145, 146, 147, 148, 149, 150, &
                                      151, 152, 153, 154, 155, 156, 157, 158, 159, 160, &
                                      161, 162, 163, 164, 165, 166, 167, 168, 169, 170, &
                                      171, 172, 173, 174, 175, 176, 177, 178, 179, 180, &
                                      181, 182, 183, 184, 185, 186, 187, 188, 189, 190, &
                                      191, 192, 193, 194, 195, 196, 197, 198, 199, 200, &
                                      201, 202, 203, 204, 205, 206, 207, 208, 209, 210, &
                                      211, 212, 213, 214, 215, 216, 217, 218, 219, 220, &
                                      221, 222, 223, 224, 225, 226, 227, 228, 229, 230, &
                                      231, 232, 233, 234, 235, 236, 237, 238, 239, 240, &
                                      241, 242, 243, 244, 245, 246, 247, 248, 249, 250, &
                                      251, 252, 253, 254, 255, 256, 257, 258, 259, 260, &
                                      261, 262, 263, 264, 265, 266, 267, 268, 269, 270, &
                                      271, 272, 273, 274, 275, 276, 277, 278, 279, 280, &
                                      281, 282, 283, 284, 285, 286, 287, 288, 289, 290, &
                                      291, 292, 293, 294, 295, 296, 297, 298, 299, 300, &
                                      301, 302, 303, 304, 305, 306, 307, 308, 309, 310, &
                                      311, 312, 313, 314, 315, 316, 317, 318, 319, 320, &
                                      321, 322, 323, 324, 325, 326, 327, 328, 329, 330, &
                                      331, 332, 333, 334, 335, 336, 337, 338, 339, 340, &
                                      341, 342, 343, 344, 345, 346, 347, 348, 349, 350, &
                                      351, 352, 353, 354, 355, 356, 357, 358, 359, 360, &
                                      361, 362, 363, 364, 365, 366, 367, 368, 369, 370, &
                                      371, 372, 373, 374, 375, 376, 377, 378, 379, 380, &
                                      381, 382, 383, 384, 385, 386, 387, 388, 389, 390, &
                                      391, 392, 393, 394, 395, 396, 397, 398, 399, 400, &
                                      401, 402, 403, 404, 405, 406, 407, 408, 409, 410, &
                                      411, 412, 413, 414, 415, 416, 417, 418, 419, 420, &
                                      421, 422, 423, 424, 425, 426, 427, 428, 429, 430, &
                                      431, 432, 433, 434, 435, 436, 437, 438, 439, 440, &
                                      441, 442, 443, 444, 445, 446, 447, 448, 449 /)
      if( allocated( pht_alias_lst ) ) then
         deallocate( pht_alias_lst )
      end if
      allocate( pht_alias_lst(phtcnt,2),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate pht_alias_lst; error = ',ios
         call endrun
      end if
      if( allocated( pht_alias_mult ) ) then
         deallocate( pht_alias_mult )
      end if
      allocate( pht_alias_mult(phtcnt,2),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate pht_alias_mult; error = ',ios
         call endrun
      end if
      pht_alias_lst(:,1) = (/ 'userdefined     ', 'userdefined     ', '                ', '                ', &
                              '                ', 'userdefined     ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ' /)
      pht_alias_lst(:,2) = (/ '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', 'jch3ooh         ', 'jh2o2           ', '                ', &
                              'jpan            ', '                ', '                ', '                ', &
                              'jch3ooh         ', 'jch3ooh         ', 'jch3ooh         ', 'jch3ooh         ', &
                              '                ', '                ', 'jch3ooh         ', 'jch3cho         ', &
                              'jch3ooh         ', '                ', '                ', 'jacet           ', &
                              'jno2            ', 'jmgly           ', 'jch3ooh         ', 'jch3ooh         ', &
                              'jch3ooh         ', 'jch3ooh         ', '                ', '                ', &
                              '                ', '                ', '                ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ', 'userdefined     ', 'userdefined     ', 'userdefined     ', &
                              'userdefined     ' /)
      pht_alias_mult(:,1) = (/ 1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8 /)
      pht_alias_mult(:,2) = (/ 1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 0.28_r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          0.2_r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8 /)
      allocate( cph_enthalpy(enthalpy_cnt),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate cph_enthalpy; error = ',ios
         call endrun
      end if
      allocate( cph_rid(enthalpy_cnt),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate cph_rid; error = ',ios
         call endrun
      end if
      cph_rid(:)      = (/             118,            119,            120,            121,            122, &
                                       123,            124,            127,            128,            129, &
                                       131,            132,            133,            163,            164, &
                                       166,            168,            169,            170,            176, &
                                       177,            178,            182,            183,            185, &
                                       186,            191,            192,            193,            435, &
                                       436,            437,            440,            441,            442, &
                                       443,            444,            445,            447,            448, &
                                       449 /)
      cph_enthalpy(:) = (/   101.390000_r8,  392.190000_r8,  493.580000_r8,   62.600000_r8,   62.600000_r8, &
                              62.600000_r8,   62.600000_r8,   94.300000_r8,   94.300000_r8,   94.300000_r8, &
                             189.810000_r8,   32.910000_r8,  189.810000_r8,  203.400000_r8,  194.710000_r8, &
                             232.590000_r8,   67.670000_r8,  165.300000_r8,  293.620000_r8,  226.580000_r8, &
                             120.100000_r8,  165.510000_r8,  177.510000_r8,  229.610000_r8,  133.750000_r8, &
                             313.750000_r8,   34.470000_r8,  199.170000_r8,  193.020000_r8,  150.110000_r8, &
                             105.040000_r8,   67.530000_r8,  406.160000_r8,  271.380000_r8,  239.840000_r8, &
                             646.280000_r8,   95.550000_r8,  339.590000_r8,   82.389000_r8,  508.950000_r8, &
                             354.830000_r8 /)

      end subroutine set_sim_dat

      end module mo_sim_dat
