module ionosphere_interface

 ! Dummy interface -- actual ionosphere interface exist in src/ionosphere/modelname

  use shr_kind_mod, only: r8 => shr_kind_r8

  implicit none

  private

  public :: ionosphere_readnl
  public :: ionosphere_init
  public :: ionosphere_run
  public :: ionosphere_final
  public :: ionosphere_write_ic
  public :: ionosphere_read_ic
  public :: ionosphere_init_restart
  public :: ionosphere_write_restart
  public :: ionosphere_read_restart

contains

  !--------------------------------------------------------------------------------
  !--------------------------------------------------------------------------------
  subroutine ionosphere_readnl( nlfile )

    character(len=*), intent(in) :: nlfile  ! filepath for file containing namelist input

  end subroutine ionosphere_readnl

  !--------------------------------------------------------------------------------
  !--------------------------------------------------------------------------------
  subroutine ionosphere_init(dyn_state)
    use dynamics_vars, only: t_fvdycore_state

    type (t_fvdycore_state), intent(in) :: dyn_state
    
  end subroutine ionosphere_init

  !--------------------------------------------------------------------------------
  !--------------------------------------------------------------------------------
  subroutine ionosphere_run( grid, phys_state, dyn_in, pbuf2d )

    use dynamics_vars,  only: t_fvdycore_grid
    use dynamics_types, only: dyn_import_t
    use physics_types,  only: physics_state
    use physics_buffer, only: physics_buffer_desc
    use phys_grid,      only: begchunk, endchunk

    ! args
    type(T_FVDYCORE_GRID),  intent(in) :: grid ! FV Dynamics grid
    type(physics_state),    intent(in) :: phys_state(begchunk:endchunk)
    type(dyn_import_t),     intent(in) :: dyn_in  ! dynamics import 

    type(physics_buffer_desc), pointer :: pbuf2d(:,:)

  end subroutine ionosphere_run

  !--------------------------------------------------------------------------------
  !--------------------------------------------------------------------------------
  subroutine ionosphere_write_ic(grid, pbuf2d)
    use dynamics_vars, only: t_fvdycore_grid
    use physics_buffer, only: physics_buffer_desc

    type (t_fvdycore_grid), intent(in) :: grid
    type(physics_buffer_desc), pointer :: pbuf2d(:,:)

  end subroutine ionosphere_write_ic

  !--------------------------------------------------------------------------------
  !--------------------------------------------------------------------------------
  subroutine ionosphere_read_ic()

  end subroutine ionosphere_read_ic

  !--------------------------------------------------------------------------------
  !--------------------------------------------------------------------------------
  subroutine ionosphere_final

  end subroutine ionosphere_final

  !--------------------------------------------------------------------------------
  !--------------------------------------------------------------------------------
  subroutine ionosphere_init_restart(File, dimids)
    use pio, only: file_desc_t

    type(File_desc_t),  intent(inout) :: File
    integer, intent(in) :: dimids(3)

  end subroutine ionosphere_init_restart

  !--------------------------------------------------------------------------------
  !--------------------------------------------------------------------------------
  subroutine ionosphere_write_restart(File,iodesc3d)
    use pio, only: io_desc_t, file_desc_t

    type(File_desc_t), intent(inout) :: File
    type(io_desc_t), intent(inout) :: iodesc3d

  end subroutine ionosphere_write_restart

  !--------------------------------------------------------------------------------
  !--------------------------------------------------------------------------------
  subroutine ionosphere_read_restart(File,iodesc3d)
    use pio, only: io_desc_t, file_desc_t

    type(file_desc_t), intent(inout) :: File
    type(io_desc_t), intent(inout) :: iodesc3d

  end subroutine ionosphere_read_restart

end module ionosphere_interface
