      module mo_lin_matrix
      use chem_mods, only: veclen
      private
      public :: linmat
      contains
      subroutine linmat01( avec_len, mat, y, rxt, het_rates )
!----------------------------------------------
! ... linear matrix entries for implicit species
!----------------------------------------------
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      use shr_kind_mod, only : r8 => shr_kind_r8
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(in) :: het_rates(veclen,gas_pcnst)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
      do k = 1,avec_len
         mat(k,537) = -( rxt(k,20) + het_rates(k,1) )
         mat(k,560) = -( rxt(k,21) + het_rates(k,2) )
         mat(k,1) = -( het_rates(k,3) )
         mat(k,2) = -( het_rates(k,4) )
         mat(k,859) = -( het_rates(k,5) )
         mat(k,85) = -( het_rates(k,6) )
         mat(k,274) = -( rxt(k,22) + het_rates(k,7) )
         mat(k,91) = -( rxt(k,23) + het_rates(k,8) )
         mat(k,280) = -( rxt(k,24) + het_rates(k,9) )
         mat(k,343) = -( rxt(k,25) + het_rates(k,10) )
         mat(k,275) = .500_r8*rxt(k,22)
         mat(k,92) = rxt(k,23)
         mat(k,492) = .200_r8*rxt(k,71)
         mat(k,588) = .060_r8*rxt(k,73)
         mat(k,198) = -( rxt(k,26) + het_rates(k,11) )
         mat(k,491) = .200_r8*rxt(k,71)
         mat(k,586) = .200_r8*rxt(k,73)
         mat(k,502) = -( rxt(k,27) + het_rates(k,12) )
         mat(k,157) = rxt(k,47)
         mat(k,925) = rxt(k,57)
         mat(k,494) = .200_r8*rxt(k,71)
         mat(k,589) = .150_r8*rxt(k,73)
         mat(k,226) = -( rxt(k,28) + het_rates(k,13) )
         mat(k,587) = .210_r8*rxt(k,73)
         mat(k,161) = -( het_rates(k,14) )
         mat(k,260) = -( het_rates(k,15) )
         mat(k,1350) = -( het_rates(k,16) )
         mat(k,168) = rxt(k,75)
         mat(k,1849) = rxt(k,76)
         mat(k,441) = rxt(k,78)
         mat(k,755) = rxt(k,100)
         mat(k,657) = rxt(k,106)
         mat(k,2101) = rxt(k,242)*y(k,33) + rxt(k,268)*y(k,34) &
                      + 3.000_r8*rxt(k,269)*y(k,54) + 2.000_r8*rxt(k,270)*y(k,77) &
                      + 2.000_r8*rxt(k,291)*y(k,40) + rxt(k,292)*y(k,42)
         mat(k,1594) = 2.000_r8*rxt(k,279)*y(k,40) + rxt(k,281)*y(k,42) &
                      + 3.000_r8*rxt(k,286)*y(k,54)
         mat(k,1742) = 2.000_r8*rxt(k,280)*y(k,40) + rxt(k,282)*y(k,42) &
                      + 3.000_r8*rxt(k,287)*y(k,54)
         mat(k,167) = -( rxt(k,75) + het_rates(k,17) )
         mat(k,1857) = -( rxt(k,76) + het_rates(k,18) )
         mat(k,443) = rxt(k,77)
         mat(k,439) = -( rxt(k,77) + rxt(k,78) + rxt(k,552) + rxt(k,555) + rxt(k,560) &
                 + het_rates(k,19) )
         mat(k,170) = -( het_rates(k,21) )
         mat(k,241) = rxt(k,29)
         mat(k,242) = -( rxt(k,29) + het_rates(k,22) )
         mat(k,201) = -( het_rates(k,23) )
         mat(k,447) = -( het_rates(k,24) )
         mat(k,178) = -( het_rates(k,25) )
         mat(k,247) = -( rxt(k,30) + het_rates(k,26) )
         mat(k,207) = -( het_rates(k,27) )
         mat(k,944) = -( het_rates(k,28) )
         mat(k,1243) = .700_r8*rxt(k,56)
         mat(k,304) = -( rxt(k,31) + het_rates(k,29) )
         mat(k,56) = -( het_rates(k,30) )
         mat(k,182) = -( rxt(k,32) + het_rates(k,31) )
         mat(k,2141) = -( rxt(k,33) + rxt(k,34) + het_rates(k,41) )
         mat(k,546) = .100_r8*rxt(k,20)
         mat(k,569) = .100_r8*rxt(k,21)
         mat(k,314) = rxt(k,39)
         mat(k,965) = rxt(k,44)
         mat(k,1000) = .330_r8*rxt(k,46)
         mat(k,1011) = rxt(k,48)
         mat(k,585) = .690_r8*rxt(k,50)
         mat(k,1150) = 1.340_r8*rxt(k,51)
         mat(k,775) = rxt(k,58)
         mat(k,437) = rxt(k,63)
         mat(k,296) = rxt(k,64)
         mat(k,490) = .375_r8*rxt(k,66)
         mat(k,375) = .400_r8*rxt(k,68)
         mat(k,983) = .680_r8*rxt(k,70)
         mat(k,335) = rxt(k,311)
         mat(k,350) = 2.000_r8*rxt(k,341)
         mat(k,2117) = rxt(k,314)*y(k,53) + rxt(k,315)*y(k,53)
         mat(k,966) = -( rxt(k,35) + het_rates(k,44) )
         mat(k,541) = .400_r8*rxt(k,20)
         mat(k,565) = .400_r8*rxt(k,21)
         mat(k,249) = rxt(k,30)
         mat(k,988) = .330_r8*rxt(k,46)
         mat(k,223) = rxt(k,54)
         mat(k,433) = rxt(k,63)
         mat(k,53) = -( het_rates(k,46) )
         mat(k,892) = -( rxt(k,36) + het_rates(k,47) )
         mat(k,540) = .250_r8*rxt(k,20)
         mat(k,564) = .250_r8*rxt(k,21)
         mat(k,306) = .820_r8*rxt(k,31)
         mat(k,986) = .170_r8*rxt(k,46)
         mat(k,483) = .300_r8*rxt(k,66)
         mat(k,370) = .050_r8*rxt(k,68)
         mat(k,975) = .500_r8*rxt(k,70)
         mat(k,1153) = -( rxt(k,37) + het_rates(k,48) )
         mat(k,283) = .180_r8*rxt(k,24)
         mat(k,228) = rxt(k,28)
         mat(k,499) = .400_r8*rxt(k,71)
         mat(k,597) = .540_r8*rxt(k,73)
         mat(k,319) = .510_r8*rxt(k,74)
         mat(k,455) = -( het_rates(k,49) )
         mat(k,400) = -( rxt(k,38) + het_rates(k,50) )
         mat(k,713) = -( het_rates(k,51) )
         mat(k,310) = -( rxt(k,39) + het_rates(k,52) )
         mat(k,1599) = -( rxt(k,217)*y(k,53) + rxt(k,279)*y(k,40) + rxt(k,281)*y(k,42) &
                      + rxt(k,284)*y(k,45) + rxt(k,286)*y(k,54) + het_rates(k,55) )
         mat(k,169) = rxt(k,75)
         mat(k,101) = 2.000_r8*rxt(k,92)
         mat(k,48) = 2.000_r8*rxt(k,93)
         mat(k,1985) = rxt(k,94)
         mat(k,910) = rxt(k,95)
         mat(k,132) = rxt(k,98)
         mat(k,1338) = rxt(k,104)
         mat(k,765) = rxt(k,107)
         mat(k,2106) = 4.000_r8*rxt(k,241)*y(k,32) + rxt(k,242)*y(k,33) &
                      + 2.000_r8*rxt(k,243)*y(k,35) + 2.000_r8*rxt(k,244)*y(k,36) &
                      + 2.000_r8*rxt(k,245)*y(k,37) + rxt(k,246)*y(k,38) &
                      + 2.000_r8*rxt(k,247)*y(k,39) + rxt(k,293)*y(k,81) &
                      + rxt(k,294)*y(k,82) + rxt(k,295)*y(k,83)
         mat(k,1747) = 3.000_r8*rxt(k,283)*y(k,43) + rxt(k,285)*y(k,45) &
                      + rxt(k,288)*y(k,81) + rxt(k,289)*y(k,82) + rxt(k,290)*y(k,83)
         mat(k,100) = -( rxt(k,92) + het_rates(k,56) )
         mat(k,47) = -( rxt(k,93) + rxt(k,251) + het_rates(k,57) )
         mat(k,1993) = -( rxt(k,94) + het_rates(k,58) )
         mat(k,915) = rxt(k,96)
         mat(k,235) = rxt(k,108)
         mat(k,49) = 2.000_r8*rxt(k,251)
         mat(k,907) = -( rxt(k,95) + rxt(k,96) + rxt(k,554) + rxt(k,559) + rxt(k,565) &
                 + het_rates(k,59) )
         mat(k,1002) = -( het_rates(k,61) )
         mat(k,93) = 1.500_r8*rxt(k,23)
         mat(k,282) = .450_r8*rxt(k,24)
         mat(k,504) = .600_r8*rxt(k,27)
         mat(k,227) = rxt(k,28)
         mat(k,2122) = rxt(k,33) + rxt(k,34)
         mat(k,967) = rxt(k,35)
         mat(k,1152) = rxt(k,37)
         mat(k,962) = rxt(k,44)
         mat(k,821) = 2.000_r8*rxt(k,45)
         mat(k,990) = .330_r8*rxt(k,46)
         mat(k,1140) = 1.340_r8*rxt(k,52)
         mat(k,1245) = .700_r8*rxt(k,56)
         mat(k,124) = 1.500_r8*rxt(k,65)
         mat(k,486) = .250_r8*rxt(k,66)
         mat(k,919) = rxt(k,69)
         mat(k,977) = 1.700_r8*rxt(k,70)
         mat(k,255) = rxt(k,137)
         mat(k,1590) = rxt(k,284)*y(k,45)
         mat(k,519) = rxt(k,579)*y(k,62)
         mat(k,60) = -( rxt(k,97) + het_rates(k,63) )
         mat(k,2093) = rxt(k,242)*y(k,33) + rxt(k,244)*y(k,36) &
                      + 2.000_r8*rxt(k,245)*y(k,37) + 2.000_r8*rxt(k,246)*y(k,38) &
                      + rxt(k,247)*y(k,39) + rxt(k,268)*y(k,34) &
                      + 2.000_r8*rxt(k,270)*y(k,77) + rxt(k,294)*y(k,82) &
                      + rxt(k,295)*y(k,83)
         mat(k,1622) = rxt(k,289)*y(k,82) + rxt(k,290)*y(k,83)
         mat(k,130) = -( rxt(k,98) + het_rates(k,64) )
         mat(k,2096) = rxt(k,243)*y(k,35) + rxt(k,244)*y(k,36) + rxt(k,293)*y(k,81)
         mat(k,1632) = rxt(k,288)*y(k,81)
         mat(k,118) = -( het_rates(k,65) )
         mat(k,192) = -( het_rates(k,66) )
         mat(k,3) = -( het_rates(k,67) )
         mat(k,4) = -( het_rates(k,68) )
         mat(k,5) = -( het_rates(k,69) )
         mat(k,6) = -( rxt(k,597) + het_rates(k,70) )
         mat(k,63) = -( rxt(k,43) + het_rates(k,71) )
         mat(k,664) = -( rxt(k,273)*y(k,53) + het_rates(k,72) )
         mat(k,61) = 2.000_r8*rxt(k,97)
         mat(k,131) = rxt(k,98)
         mat(k,154) = rxt(k,105)
         mat(k,2097) = rxt(k,246)*y(k,38) + rxt(k,268)*y(k,34)
         mat(k,961) = -( rxt(k,44) + het_rates(k,73) )
         mat(k,987) = .330_r8*rxt(k,46)
         mat(k,484) = .250_r8*rxt(k,66)
         mat(k,820) = -( rxt(k,45) + rxt(k,522) + het_rates(k,74) )
         mat(k,277) = rxt(k,22)
         mat(k,281) = .130_r8*rxt(k,24)
         mat(k,238) = .700_r8*rxt(k,62)
         mat(k,498) = .600_r8*rxt(k,71)
         mat(k,595) = .340_r8*rxt(k,73)
         mat(k,318) = .170_r8*rxt(k,74)
         mat(k,1832) = -( het_rates(k,75) )
         mat(k,2159) = 2.000_r8*rxt(k,2) + rxt(k,3)
         mat(k,2133) = 2.000_r8*rxt(k,33)
         mat(k,313) = rxt(k,39)
         mat(k,757) = rxt(k,100)
         mat(k,1340) = rxt(k,104)
         mat(k,155) = rxt(k,105)
         mat(k,2109) = rxt(k,314)*y(k,53)
         mat(k,1088) = -( het_rates(k,76) )
         mat(k,2148) = rxt(k,1)
         mat(k,2123) = rxt(k,34)
         mat(k,2099) = rxt(k,315)*y(k,53)
         mat(k,475) = -( rxt(k,4) + het_rates(k,78) )
         mat(k,2027) = .500_r8*rxt(k,523)
         mat(k,66) = -( rxt(k,136) + het_rates(k,79) )
         mat(k,754) = -( rxt(k,100) + het_rates(k,80) )
         mat(k,1335) = -( rxt(k,104) + het_rates(k,84) )
         mat(k,1593) = rxt(k,217)*y(k,53) + rxt(k,279)*y(k,40) + rxt(k,281)*y(k,42) &
                      + 2.000_r8*rxt(k,284)*y(k,45) + rxt(k,286)*y(k,54)
         mat(k,102) = -( het_rates(k,85) )
         mat(k,709) = -( het_rates(k,86) )
         mat(k,153) = -( rxt(k,105) + het_rates(k,87) )
         mat(k,663) = rxt(k,273)*y(k,53)
      end do
      end subroutine linmat01
      subroutine linmat02( avec_len, mat, y, rxt, het_rates )
!----------------------------------------------
! ... linear matrix entries for implicit species
!----------------------------------------------
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      use shr_kind_mod, only : r8 => shr_kind_r8
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(in) :: het_rates(veclen,gas_pcnst)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
      do k = 1,avec_len
         mat(k,1965) = -( rxt(k,9) + het_rates(k,88) )
         mat(k,1943) = .500_r8*rxt(k,524)
         mat(k,1571) = rxt(k,525)
         mat(k,191) = 2.000_r8*rxt(k,526) + 2.000_r8*rxt(k,550) + 2.000_r8*rxt(k,553) &
                      + 2.000_r8*rxt(k,564)
         mat(k,998) = rxt(k,527)
         mat(k,512) = rxt(k,528)
         mat(k,429) = rxt(k,529)
         mat(k,272) = rxt(k,530)
         mat(k,937) = rxt(k,531)
         mat(k,291) = rxt(k,532)
         mat(k,166) = rxt(k,533)
         mat(k,526) = rxt(k,534)
         mat(k,446) = rxt(k,552) + rxt(k,555) + rxt(k,560)
         mat(k,914) = rxt(k,554) + rxt(k,559) + rxt(k,565)
         mat(k,362) = -( rxt(k,10) + rxt(k,11) + rxt(k,214) + het_rates(k,89) )
         mat(k,655) = -( rxt(k,106) + het_rates(k,90) )
         mat(k,440) = rxt(k,552) + rxt(k,555) + rxt(k,560)
         mat(k,763) = -( rxt(k,107) + het_rates(k,91) )
         mat(k,906) = rxt(k,554) + rxt(k,559) + rxt(k,565)
         mat(k,989) = -( rxt(k,46) + rxt(k,527) + het_rates(k,92) )
         mat(k,156) = -( rxt(k,47) + het_rates(k,93) )
         mat(k,1188) = rxt(k,415)
         mat(k,1006) = -( rxt(k,48) + het_rates(k,94) )
         mat(k,991) = .170_r8*rxt(k,46)
         mat(k,213) = -( het_rates(k,95) )
         mat(k,69) = -( het_rates(k,96) )
         mat(k,782) = -( het_rates(k,97) )
         mat(k,506) = -( rxt(k,528) + het_rates(k,98) )
         mat(k,423) = -( rxt(k,529) + het_rates(k,99) )
         mat(k,1125) = -( het_rates(k,100) )
         mat(k,298) = -( rxt(k,49) + het_rates(k,101) )
         mat(k,579) = -( rxt(k,50) + het_rates(k,102) )
         mat(k,299) = rxt(k,49)
         mat(k,40) = -( het_rates(k,103) )
         mat(k,1141) = -( rxt(k,51) + rxt(k,52) + het_rates(k,104) )
         mat(k,581) = .288_r8*rxt(k,50)
         mat(k,216) = -( het_rates(k,105) )
         mat(k,413) = -( rxt(k,53) + het_rates(k,106) )
         mat(k,536) = .800_r8*rxt(k,20)
         mat(k,559) = .800_r8*rxt(k,21)
         mat(k,221) = -( rxt(k,54) + het_rates(k,107) )
         mat(k,467) = -( rxt(k,55) + rxt(k,397) + het_rates(k,108) )
         mat(k,833) = -( het_rates(k,109) )
         mat(k,1249) = -( rxt(k,56) + het_rates(k,110) )
         mat(k,582) = .402_r8*rxt(k,50)
         mat(k,745) = -( rxt(k,111) + het_rates(k,111) )
         mat(k,1473) = rxt(k,15)
         mat(k,518) = rxt(k,580)
         mat(k,186) = -( rxt(k,13) + rxt(k,14) + rxt(k,215) + rxt(k,526) + rxt(k,550) &
                      + rxt(k,553) + rxt(k,564) + het_rates(k,113) )
         mat(k,268) = -( rxt(k,530) + het_rates(k,114) )
         mat(k,929) = -( rxt(k,57) + rxt(k,531) + het_rates(k,115) )
         mat(k,7) = -( het_rates(k,116) )
         mat(k,8) = -( het_rates(k,117) )
         mat(k,9) = -( het_rates(k,118) )
         mat(k,50) = -( het_rates(k,119) )
         mat(k,10) = -( rxt(k,535) + het_rates(k,120) )
         mat(k,1505) = -( rxt(k,15) + rxt(k,16) + het_rates(k,121) )
         mat(k,187) = rxt(k,14)
         mat(k,1934) = rxt(k,17) + .500_r8*rxt(k,524)
         mat(k,1562) = rxt(k,19)
         mat(k,687) = rxt(k,577)
         mat(k,2104) = 2.000_r8*rxt(k,208)*y(k,112)
         mat(k,1942) = -( rxt(k,17) + rxt(k,524) + het_rates(k,122) )
         mat(k,1964) = rxt(k,9)
         mat(k,366) = rxt(k,11) + rxt(k,214)
         mat(k,190) = rxt(k,13) + rxt(k,215)
         mat(k,1570) = rxt(k,18)
         mat(k,544) = rxt(k,20)
         mat(k,997) = rxt(k,46)
         mat(k,302) = rxt(k,49)
         mat(k,472) = rxt(k,55) + rxt(k,397)
         mat(k,936) = rxt(k,57)
         mat(k,774) = rxt(k,58)
         mat(k,290) = rxt(k,59)
         mat(k,165) = rxt(k,60)
         mat(k,356) = .600_r8*rxt(k,61) + rxt(k,348)
         mat(k,525) = rxt(k,67)
         mat(k,445) = rxt(k,77)
         mat(k,913) = rxt(k,96)
         mat(k,74) = rxt(k,472)
         mat(k,1563) = -( rxt(k,18) + rxt(k,19) + rxt(k,525) + het_rates(k,123) )
         mat(k,364) = rxt(k,10)
         mat(k,188) = rxt(k,13) + rxt(k,14) + rxt(k,215)
         mat(k,354) = .400_r8*rxt(k,61)
         mat(k,442) = rxt(k,78)
         mat(k,909) = rxt(k,95)
         mat(k,770) = -( rxt(k,58) + het_rates(k,124) )
         mat(k,286) = -( rxt(k,59) + rxt(k,532) + het_rates(k,125) )
         mat(k,11) = -( het_rates(k,126) )
         mat(k,12) = -( het_rates(k,127) )
         mat(k,13) = -( het_rates(k,128) )
         mat(k,14) = -( het_rates(k,129) )
         mat(k,1899) = -( rxt(k,120) + rxt(k,121) + rxt(k,122) + rxt(k,123) + rxt(k,124) &
                      + rxt(k,125) + het_rates(k,130) )
         mat(k,2161) = rxt(k,2)
         mat(k,1432) = 2.000_r8*rxt(k,5) + rxt(k,6) + rxt(k,127) + rxt(k,128) + rxt(k,129) &
                      + rxt(k,131) + rxt(k,132) + rxt(k,133) + 2.000_r8*rxt(k,134) &
                      + 2.000_r8*rxt(k,135)
         mat(k,1814) = rxt(k,8)
         mat(k,189) = rxt(k,14)
         mat(k,1512) = rxt(k,15)
         mat(k,1941) = rxt(k,17)
         mat(k,1569) = rxt(k,18)
         mat(k,1858) = rxt(k,76)
         mat(k,1990) = rxt(k,94)
         mat(k,234) = rxt(k,108)
         mat(k,1325) = rxt(k,138)
         mat(k,902) = rxt(k,139)
         mat(k,176) = rxt(k,140)
         mat(k,2111) = rxt(k,157)
         mat(k,1425) = -( rxt(k,5) + rxt(k,6) + rxt(k,126) + rxt(k,127) + rxt(k,128) &
                      + rxt(k,129) + rxt(k,130) + rxt(k,131) + rxt(k,132) + rxt(k,133) &
                      + rxt(k,134) + rxt(k,135) + het_rates(k,131) )
         mat(k,1806) = rxt(k,8)
         mat(k,1561) = rxt(k,19)
         mat(k,76) = rxt(k,153) + rxt(k,161)
         mat(k,79) = rxt(k,154)
         mat(k,2103) = rxt(k,209)*y(k,112)
         mat(k,1811) = -( rxt(k,7) + rxt(k,8) + het_rates(k,132) )
         mat(k,231) = -( rxt(k,108) + het_rates(k,134) )
         mat(k,252) = -( rxt(k,137) + het_rates(k,135) )
         mat(k,164) = -( rxt(k,60) + rxt(k,533) + het_rates(k,136) )
         mat(k,351) = -( rxt(k,61) + rxt(k,348) + het_rates(k,137) )
         mat(k,72) = -( rxt(k,472) + het_rates(k,138) )
         mat(k,358) = -( het_rates(k,139) )
         mat(k,183) = rxt(k,32)
         mat(k,95) = -( het_rates(k,140) )
         mat(k,236) = -( rxt(k,62) + het_rates(k,141) )
         mat(k,15) = -( het_rates(k,142) )
         mat(k,16) = -( het_rates(k,143) )
         mat(k,431) = -( rxt(k,63) + het_rates(k,144) )
         mat(k,292) = -( rxt(k,64) + het_rates(k,145) )
         mat(k,601) = -( het_rates(k,146) )
         mat(k,253) = rxt(k,137)
         mat(k,1314) = rxt(k,138)
         mat(k,1316) = -( rxt(k,138) + het_rates(k,148) )
         mat(k,900) = rxt(k,139)
         mat(k,899) = -( rxt(k,139) + het_rates(k,149) )
         mat(k,175) = rxt(k,140)
         mat(k,174) = -( rxt(k,140) + het_rates(k,150) )
         mat(k,67) = rxt(k,136)
         mat(k,17) = -( het_rates(k,151) )
         mat(k,18) = -( het_rates(k,152) )
         mat(k,19) = -( het_rates(k,153) )
         mat(k,20) = -( rxt(k,143) + het_rates(k,154) )
         mat(k,21) = -( rxt(k,144) + het_rates(k,155) )
         mat(k,22) = -( rxt(k,145) + het_rates(k,156) )
         mat(k,23) = -( rxt(k,146) + het_rates(k,157) )
         mat(k,24) = -( rxt(k,147) + het_rates(k,158) )
         mat(k,25) = -( rxt(k,148) + het_rates(k,159) )
         mat(k,26) = -( rxt(k,149) + het_rates(k,160) )
         mat(k,27) = -( rxt(k,150) + het_rates(k,161) )
         mat(k,28) = -( rxt(k,151) + het_rates(k,162) )
         mat(k,29) = -( rxt(k,152) + het_rates(k,163) )
         mat(k,30) = -( het_rates(k,164) )
         mat(k,819) = rxt(k,522)
         mat(k,31) = -( het_rates(k,165) )
         mat(k,32) = -( het_rates(k,166) )
         mat(k,33) = -( het_rates(k,167) )
         mat(k,34) = -( het_rates(k,168) )
         mat(k,46) = -( het_rates(k,169) )
         mat(k,123) = -( rxt(k,65) + het_rates(k,170) )
         mat(k,482) = -( rxt(k,66) + het_rates(k,171) )
         mat(k,522) = -( rxt(k,67) + rxt(k,534) + het_rates(k,172) )
         mat(k,369) = -( rxt(k,68) + het_rates(k,173) )
         mat(k,917) = -( rxt(k,69) + het_rates(k,174) )
         mat(k,287) = rxt(k,59)
         mat(k,523) = rxt(k,67)
         mat(k,371) = rxt(k,68)
         mat(k,976) = -( rxt(k,70) + het_rates(k,175) )
         mat(k,485) = rxt(k,66)
         mat(k,918) = rxt(k,69)
         mat(k,493) = -( rxt(k,71) + het_rates(k,176) )
         mat(k,111) = -( het_rates(k,177) )
         mat(k,127) = -( rxt(k,72) + het_rates(k,178) )
         mat(k,140) = -( het_rates(k,179) )
         mat(k,590) = -( rxt(k,73) + het_rates(k,180) )
         mat(k,148) = -( het_rates(k,181) )
         mat(k,316) = -( rxt(k,74) + het_rates(k,182) )
         mat(k,407) = -( het_rates(k,185) )
         mat(k,73) = rxt(k,472)
         mat(k,881) = -( het_rates(k,186) )
         mat(k,378) = -( het_rates(k,187) )
         mat(k,324) = -( het_rates(k,188) )
         mat(k,801) = -( het_rates(k,189) )
         mat(k,415) = rxt(k,53)
         mat(k,729) = -( het_rates(k,190) )
         mat(k,530) = -( het_rates(k,191) )
         mat(k,1300) = -( het_rates(k,192) )
         mat(k,284) = .130_r8*rxt(k,24)
         mat(k,229) = rxt(k,28)
         mat(k,894) = rxt(k,36)
         mat(k,1154) = rxt(k,37)
         mat(k,993) = .330_r8*rxt(k,46)
         mat(k,1008) = rxt(k,48)
         mat(k,1145) = 1.340_r8*rxt(k,51)
         mat(k,416) = rxt(k,53)
         mat(k,224) = rxt(k,54)
         mat(k,1251) = .300_r8*rxt(k,56)
         mat(k,772) = rxt(k,58)
         mat(k,352) = .600_r8*rxt(k,61) + rxt(k,348)
         mat(k,294) = rxt(k,64)
         mat(k,125) = .500_r8*rxt(k,65)
         mat(k,979) = .650_r8*rxt(k,70)
      end do
      end subroutine linmat02
      subroutine linmat03( avec_len, mat, y, rxt, het_rates )
!----------------------------------------------
! ... linear matrix entries for implicit species
!----------------------------------------------
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      use shr_kind_mod, only : r8 => shr_kind_r8
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(in) :: het_rates(veclen,gas_pcnst)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
      do k = 1,avec_len
         mat(k,1394) = -( het_rates(k,193) )
         mat(k,969) = rxt(k,35)
         mat(k,895) = rxt(k,36)
         mat(k,402) = rxt(k,38)
         mat(k,1252) = .300_r8*rxt(k,56)
         mat(k,353) = .400_r8*rxt(k,61)
         mat(k,1595) = rxt(k,217)*y(k,53)
         mat(k,666) = rxt(k,273)*y(k,53)
         mat(k,1743) = rxt(k,306)*y(k,53)
         mat(k,2102) = rxt(k,313)*y(k,53)
         mat(k,646) = -( het_rates(k,194) )
         mat(k,199) = .600_r8*rxt(k,26)
         mat(k,702) = -( het_rates(k,195) )
         mat(k,1469) = rxt(k,16)
         mat(k,744) = rxt(k,111)
         mat(k,1879) = rxt(k,120) + rxt(k,121) + rxt(k,122) + rxt(k,123) + rxt(k,124) &
                      + rxt(k,125)
         mat(k,1418) = rxt(k,126) + rxt(k,127) + rxt(k,128) + rxt(k,129) + rxt(k,130) &
                      + rxt(k,131) + rxt(k,132) + rxt(k,133)
         mat(k,459) = -( het_rates(k,196) )
         mat(k,346) = -( rxt(k,341) + het_rates(k,197) )
         mat(k,64) = rxt(k,43)
         mat(k,674) = -( het_rates(k,198) )
         mat(k,2089) = -( rxt(k,523) + het_rates(k,199) )
         mat(k,367) = rxt(k,11) + rxt(k,214)
         mat(k,545) = rxt(k,20)
         mat(k,568) = .900_r8*rxt(k,21)
         mat(k,279) = rxt(k,22)
         mat(k,94) = 1.500_r8*rxt(k,23)
         mat(k,285) = .560_r8*rxt(k,24)
         mat(k,345) = rxt(k,25)
         mat(k,200) = .600_r8*rxt(k,26)
         mat(k,505) = .600_r8*rxt(k,27)
         mat(k,230) = rxt(k,28)
         mat(k,246) = rxt(k,29)
         mat(k,251) = rxt(k,30)
         mat(k,308) = rxt(k,31)
         mat(k,973) = rxt(k,35)
         mat(k,1159) = rxt(k,37)
         mat(k,964) = 2.000_r8*rxt(k,44)
         mat(k,823) = 2.000_r8*rxt(k,45)
         mat(k,999) = .670_r8*rxt(k,46)
         mat(k,160) = rxt(k,47)
         mat(k,1010) = rxt(k,48)
         mat(k,303) = rxt(k,49)
         mat(k,584) = rxt(k,50)
         mat(k,1149) = 1.340_r8*rxt(k,51) + .660_r8*rxt(k,52)
         mat(k,938) = rxt(k,57)
         mat(k,240) = rxt(k,62)
         mat(k,436) = rxt(k,63)
         mat(k,126) = rxt(k,65)
         mat(k,489) = rxt(k,66)
         mat(k,527) = rxt(k,67)
         mat(k,374) = rxt(k,68)
         mat(k,924) = rxt(k,69)
         mat(k,982) = 1.200_r8*rxt(k,70)
         mat(k,501) = rxt(k,71)
         mat(k,600) = rxt(k,73)
         mat(k,321) = rxt(k,74)
         mat(k,334) = rxt(k,311)
         mat(k,349) = rxt(k,341)
         mat(k,1218) = rxt(k,415)
         mat(k,1608) = rxt(k,281)*y(k,42) + rxt(k,284)*y(k,45)
         mat(k,1756) = rxt(k,282)*y(k,42) + rxt(k,285)*y(k,45)
         mat(k,2115) = rxt(k,314)*y(k,53)
         mat(k,330) = -( rxt(k,311) + het_rates(k,200) )
         mat(k,1172) = -( het_rates(k,201) )
         mat(k,1205) = -( rxt(k,415) + het_rates(k,202) )
         mat(k,1229) = -( het_rates(k,203) )
         mat(k,608) = -( het_rates(k,204) )
         mat(k,344) = .600_r8*rxt(k,25)
         mat(k,1269) = -( het_rates(k,205) )
         mat(k,1144) = .660_r8*rxt(k,51)
         mat(k,469) = rxt(k,55) + rxt(k,397)
         mat(k,810) = -( het_rates(k,206) )
         mat(k,503) = .600_r8*rxt(k,27)
         mat(k,571) = -( het_rates(k,207) )
         mat(k,418) = -( het_rates(k,208) )
         mat(k,549) = -( het_rates(k,209) )
         mat(k,691) = -( het_rates(k,210) )
         mat(k,1468) = rxt(k,16)
         mat(k,683) = rxt(k,577)
         mat(k,517) = rxt(k,580)
         mat(k,385) = -( het_rates(k,211) )
         mat(k,740) = rxt(k,111)
         mat(k,1060) = -( het_rates(k,212) )
         mat(k,2116) = -( rxt(k,157) + rxt(k,208)*y(k,112) + rxt(k,209)*y(k,112) &
                      + rxt(k,241)*y(k,32) + rxt(k,242)*y(k,33) + rxt(k,243)*y(k,35) &
                      + rxt(k,244)*y(k,36) + rxt(k,245)*y(k,37) + rxt(k,246)*y(k,38) &
                      + rxt(k,247)*y(k,39) + rxt(k,268)*y(k,34) + rxt(k,269)*y(k,54) &
                      + rxt(k,270)*y(k,77) + rxt(k,291)*y(k,40) + rxt(k,292)*y(k,42) &
                      + rxt(k,293)*y(k,81) + rxt(k,294)*y(k,82) + rxt(k,295)*y(k,83) &
                      + rxt(k,313)*y(k,53) + rxt(k,314)*y(k,53) + rxt(k,315)*y(k,53) &
                 + het_rates(k,213) )
         mat(k,2166) = rxt(k,1)
         mat(k,1436) = rxt(k,6)
         mat(k,1819) = rxt(k,7)
         mat(k,75) = -( rxt(k,153) + rxt(k,161) + het_rates(k,214) )
         mat(k,1765) = rxt(k,7)
         mat(k,77) = rxt(k,165) + rxt(k,164)*y(k,62)
         mat(k,78) = -( rxt(k,154) + rxt(k,165) + rxt(k,164)*y(k,62) + het_rates(k,215) )
         mat(k,682) = -( rxt(k,577) + het_rates(k,216) )
         mat(k,1416) = rxt(k,126) + rxt(k,130)
         mat(k,516) = rxt(k,579)*y(k,62)
         mat(k,1748) = -( rxt(k,280)*y(k,40) + rxt(k,282)*y(k,42) + rxt(k,283)*y(k,43) &
                      + rxt(k,285)*y(k,45) + rxt(k,287)*y(k,54) + rxt(k,288)*y(k,81) &
                      + rxt(k,289)*y(k,82) + rxt(k,290)*y(k,83) + rxt(k,306)*y(k,53) &
                 + het_rates(k,217) )
         mat(k,2157) = rxt(k,3)
         mat(k,478) = 2.000_r8*rxt(k,4)
         mat(k,1959) = rxt(k,9)
         mat(k,365) = rxt(k,10)
         mat(k,567) = rxt(k,21)
         mat(k,278) = rxt(k,22)
         mat(k,245) = rxt(k,29)
         mat(k,250) = rxt(k,30)
         mat(k,307) = rxt(k,31)
         mat(k,185) = rxt(k,32)
         mat(k,403) = rxt(k,38)
         mat(k,312) = rxt(k,39)
         mat(k,65) = rxt(k,43)
         mat(k,159) = rxt(k,47)
         mat(k,225) = rxt(k,54)
         mat(k,289) = rxt(k,59)
         mat(k,239) = rxt(k,62)
         mat(k,435) = rxt(k,63)
         mat(k,295) = rxt(k,64)
         mat(k,488) = rxt(k,66)
         mat(k,373) = rxt(k,68)
         mat(k,500) = rxt(k,71)
         mat(k,129) = rxt(k,72)
         mat(k,599) = rxt(k,73)
         mat(k,320) = rxt(k,74)
         mat(k,659) = rxt(k,106)
         mat(k,766) = rxt(k,107)
         mat(k,1937) = .500_r8*rxt(k,524)
         mat(k,2107) = rxt(k,313)*y(k,53)
         mat(k,515) = -( rxt(k,580) + rxt(k,579)*y(k,62) + het_rates(k,218) )
         mat(k,1873) = rxt(k,120) + rxt(k,121) + rxt(k,122) + rxt(k,123) + rxt(k,124) &
                      + rxt(k,125)
         mat(k,1413) = rxt(k,127) + rxt(k,128) + rxt(k,129) + rxt(k,131) + rxt(k,132) &
                      + rxt(k,133)
         mat(k,337) = -( het_rates(k,219) )
         mat(k,718) = -( het_rates(k,220) )
         mat(k,1076) = -( het_rates(k,221) )
         mat(k,978) = .150_r8*rxt(k,70)
         mat(k,1041) = -( het_rates(k,222) )
         mat(k,1019) = -( het_rates(k,223) )
         mat(k,619) = -( het_rates(k,224) )
         mat(k,1105) = -( het_rates(k,225) )
         mat(k,635) = -( het_rates(k,226) )
         mat(k,393) = -( het_rates(k,227) )
         mat(k,2168) = -( rxt(k,1) + rxt(k,2) + rxt(k,3) + het_rates(k,228) )
         mat(k,68) = rxt(k,136)
         mat(k,1759) = rxt(k,280)*y(k,40) + rxt(k,282)*y(k,42) + rxt(k,283)*y(k,43) &
                      + rxt(k,285)*y(k,45) + rxt(k,290)*y(k,83) + rxt(k,306)*y(k,53)
      end do
      end subroutine linmat03
      subroutine linmat( avec_len, mat, y, rxt, het_rates )
!----------------------------------------------
! ... linear matrix entries for implicit species
!----------------------------------------------
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      use shr_kind_mod, only : r8 => shr_kind_r8
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(in) :: het_rates(veclen,gas_pcnst)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
      call linmat01( avec_len, mat, y, rxt, het_rates )
      call linmat02( avec_len, mat, y, rxt, het_rates )
      call linmat03( avec_len, mat, y, rxt, het_rates )
      end subroutine linmat
      end module mo_lin_matrix
