      module mo_lu_solve
      private
      public :: lu_slv
      contains
      subroutine lu_slv01( lu, b )
      use shr_kind_mod, only : r8 => shr_kind_r8
      use chem_mods, only : clscnt4, nzcnt
      implicit none
!-----------------------------------------------------------------------
! ... Dummy args
!-----------------------------------------------------------------------
      real(r8), intent(in) :: lu(:)
      real(r8), intent(inout) :: b(:)
!-----------------------------------------------------------------------
! ... Local variables
!-----------------------------------------------------------------------
!-----------------------------------------------------------------------
! ... solve L * y = b
!-----------------------------------------------------------------------
         b(6) = b(6) - lu(8) * b(5)
         b(8) = b(8) - lu(11) * b(7)
      end subroutine lu_slv01
      subroutine lu_slv02( lu, b )
      use shr_kind_mod, only : r8 => shr_kind_r8
      use chem_mods, only : clscnt4, nzcnt
      implicit none
!-----------------------------------------------------------------------
! ... Dummy args
!-----------------------------------------------------------------------
      real(r8), intent(in) :: lu(:)
      real(r8), intent(inout) :: b(:)
!-----------------------------------------------------------------------
! ... Local variables
!-----------------------------------------------------------------------
!-----------------------------------------------------------------------
! ... solve L * y = b
!-----------------------------------------------------------------------
!-----------------------------------------------------------------------
! ... Solve U * x = y
!-----------------------------------------------------------------------
         b(16) = b(16) * lu(20)
         b(15) = b(15) * lu(19)
         b(14) = b(14) * lu(18)
         b(13) = b(13) * lu(17)
         b(12) = b(12) * lu(16)
         b(11) = b(11) * lu(15)
         b(10) = b(10) * lu(14)
         b(9) = b(9) * lu(13)
         b(8) = b(8) * lu(12)
         b(7) = b(7) * lu(10)
         b(6) = b(6) * lu(9)
         b(5) = b(5) * lu(7)
         b(4) = b(4) * lu(6)
         b(3) = b(3) - lu(5) * b(4)
         b(3) = b(3) * lu(4)
         b(2) = b(2) - lu(3) * b(3)
         b(2) = b(2) * lu(2)
         b(1) = b(1) * lu(1)
      end subroutine lu_slv02
      subroutine lu_slv( lu, b )
      use shr_kind_mod, only : r8 => shr_kind_r8
      use chem_mods, only : clscnt4, nzcnt
      implicit none
!-----------------------------------------------------------------------
! ... Dummy args
!-----------------------------------------------------------------------
      real(r8), intent(in) :: lu(:)
      real(r8), intent(inout) :: b(:)
      call lu_slv01( lu, b )
      call lu_slv02( lu, b )
      end subroutine lu_slv
      end module mo_lu_solve
