
      module mo_sim_dat

      private
      public :: set_sim_dat

      contains

      subroutine set_sim_dat

      use chem_mods,     only : clscnt, cls_rxt_cnt, clsmap, permute, adv_mass, fix_mass, crb_mass
      use chem_mods,     only : diag_map
      use chem_mods,     only : phtcnt, rxt_tag_cnt, rxt_tag_lst, rxt_tag_map
      use chem_mods,     only : pht_alias_lst, pht_alias_mult
      use chem_mods,     only : extfrc_lst, inv_lst, slvd_lst
      use chem_mods,     only : enthalpy_cnt, cph_enthalpy, cph_rid
      use cam_abortutils,only : endrun
      use mo_tracname,   only : solsym
      use chem_mods,     only : frc_from_dataset
      use chem_mods,     only : is_scalar, is_vector
      use shr_kind_mod,  only : r8 => shr_kind_r8
      use cam_logfile,   only : iulog

      implicit none

!--------------------------------------------------------------
!      ... local variables
!--------------------------------------------------------------
      integer :: ios

      is_scalar = .true.
      is_vector = .false.

      clscnt(:) = (/      8,     0,     0,    95,     0 /)

      cls_rxt_cnt(:,1) = (/     30,    12,     0,     8 /)
      cls_rxt_cnt(:,4) = (/      2,    65,   144,    95 /)

      solsym(:103) = (/ 'O3              ','O               ','O1D             ','N2O             ','NO              ', &
                        'NO2             ','NO3             ','HNO3            ','HO2NO2          ','N2O5            ', &
                        'H2              ','OH              ','HO2             ','H2O2            ','CH4             ', &
                        'CO              ','CH3O2           ','CH3OOH          ','CH2O            ','CH3OH           ', &
                        'C2H5OH          ','C2H4            ','EO              ','EO2             ','CH3COOH         ', &
                        'GLYALD          ','C2H6            ','C2H5O2          ','C2H5OOH         ','CH3CHO          ', &
                        'CH3CO3          ','CH3COOOH        ','C3H6            ','C3H8            ','C3H7O2          ', &
                        'C3H7OOH         ','PO2             ','POOH            ','CH3COCH3        ','RO2             ', &
                        'ROOH            ','BIGENE          ','ENEO2           ','MEK             ','MEKO2           ', &
                        'MEKOOH          ','BIGALK          ','ALKO2           ','ALKOOH          ','ISOP            ', &
                        'ISOPO2          ','ISOPOOH         ','MVK             ','MACR            ','MACRO2          ', &
                        'MACROOH         ','MCO3            ','HYDRALD         ','HYAC            ','CH3COCHO        ', &
                        'XO2             ','XOOH            ','C10H16          ','TERPO2          ','TERPOOH         ', &
                        'TOLUENE         ','CRESOL          ','TOLO2           ','TOLOOH          ','XOH             ', &
                        'BIGALD          ','GLYOXAL         ','PAN             ','ONIT            ','MPAN            ', &
                        'ISOPNO3         ','ONITR           ','CB1             ','CB2             ','OC1             ', &
                        'OC2             ','SOA             ','SO2             ','DMS             ','SO4             ', &
                        'NH3             ','NH4             ','NH4NO3          ','SSLT01          ','SSLT02          ', &
                        'SSLT03          ','SSLT04          ','DST01           ','DST02           ','DST03           ', &
                        'DST04           ','Rn              ','Pb              ','HCN             ','CH3CN           ', &
                        'C2H2            ','HCOOH           ','HOCH2OO         ' /)

      adv_mass(:103) = (/    47.998200_r8,    15.999400_r8,    15.999400_r8,    44.012880_r8,    30.006140_r8, &
                             46.005540_r8,    62.004940_r8,    63.012340_r8,    79.011740_r8,   108.010480_r8, &
                              2.014800_r8,    17.006800_r8,    33.006200_r8,    34.013600_r8,    16.040600_r8, &
                             28.010400_r8,    47.032000_r8,    48.039400_r8,    30.025200_r8,    32.040000_r8, &
                             46.065800_r8,    28.051600_r8,    61.057800_r8,    77.057200_r8,    60.050400_r8, &
                             60.050400_r8,    30.066400_r8,    61.057800_r8,    62.065200_r8,    44.051000_r8, &
                             75.042400_r8,    76.049800_r8,    42.077400_r8,    44.092200_r8,    75.083600_r8, &
                             76.091000_r8,    91.083000_r8,    92.090400_r8,    58.076800_r8,    89.068200_r8, &
                             90.075600_r8,    56.103200_r8,   105.108800_r8,    72.102600_r8,   103.094000_r8, &
                            104.101400_r8,    72.143800_r8,   103.135200_r8,   104.142600_r8,    68.114200_r8, &
                            117.119800_r8,   118.127200_r8,    70.087800_r8,    70.087800_r8,   119.093400_r8, &
                            120.100800_r8,   101.079200_r8,   100.113000_r8,    74.076200_r8,    72.061400_r8, &
                            149.118600_r8,   150.126000_r8,   136.228400_r8,   185.234000_r8,   186.241400_r8, &
                             92.136200_r8,   108.135600_r8,   173.140600_r8,   174.148000_r8,   190.147400_r8, &
                             98.098200_r8,    58.035600_r8,   121.047940_r8,   119.074340_r8,   147.084740_r8, &
                            162.117940_r8,   147.125940_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8, &
                             12.011000_r8,   144.132000_r8,    64.064800_r8,    62.132400_r8,    96.063600_r8, &
                             17.028940_r8,    18.036340_r8,    80.041280_r8,    58.442468_r8,    58.442468_r8, &
                             58.442468_r8,    58.442468_r8,   135.064039_r8,   135.064039_r8,   135.064039_r8, &
                            135.064039_r8,   222.000000_r8,   207.200000_r8,    27.025140_r8,    41.050940_r8, &
                             26.036800_r8,    46.024600_r8,    63.031400_r8 /)

      crb_mass(:103) = (/     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,    12.011000_r8, &
                             12.011000_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8, &
                             24.022000_r8,    24.022000_r8,    24.022000_r8,    24.022000_r8,    24.022000_r8, &
                             24.022000_r8,    24.022000_r8,    24.022000_r8,    24.022000_r8,    24.022000_r8, &
                             24.022000_r8,    24.022000_r8,    36.033000_r8,    36.033000_r8,    36.033000_r8, &
                             36.033000_r8,    36.033000_r8,    36.033000_r8,    36.033000_r8,    36.033000_r8, &
                             36.033000_r8,    48.044000_r8,    48.044000_r8,    48.044000_r8,    48.044000_r8, &
                             48.044000_r8,    60.055000_r8,    60.055000_r8,    60.055000_r8,    60.055000_r8, &
                             60.055000_r8,    60.055000_r8,    48.044000_r8,    48.044000_r8,    48.044000_r8, &
                             48.044000_r8,    48.044000_r8,    60.055000_r8,    36.033000_r8,    36.033000_r8, &
                             60.055000_r8,    60.055000_r8,   120.110000_r8,   120.110000_r8,   120.110000_r8, &
                             84.077000_r8,    84.077000_r8,    84.077000_r8,    84.077000_r8,    84.077000_r8, &
                             60.055000_r8,    24.022000_r8,    24.022000_r8,    36.033000_r8,    48.044000_r8, &
                             60.055000_r8,    60.055000_r8,    12.011000_r8,    12.011000_r8,    12.011000_r8, &
                             12.011000_r8,   144.132000_r8,     0.000000_r8,    24.022000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8,     0.000000_r8, &
                              0.000000_r8,     0.000000_r8,     0.000000_r8,    12.011000_r8,    24.022000_r8, &
                             24.022000_r8,    12.011000_r8,    12.011000_r8 /)

      fix_mass(:  4) = (/ 0.00000000_r8, 28.0134800_r8, 31.9988000_r8, 18.0142000_r8 /)

      clsmap(:  8,1) = (/   15,   4,  16,  97,  98,  11,  99, 100 /)
      clsmap(: 95,4) = (/    1,   3,   2,   5,   6,   7,   8,   9,  10,  12, &
                            13,  14,  17,  18,  19,  20,  21,  22,  23,  24, &
                            25,  26,  27,  28,  29,  30,  31,  32,  33,  34, &
                            35,  36,  37,  38,  39,  40,  41,  42,  43,  47, &
                            48,  49,  44,  45,  46,  50,  51,  52,  53,  54, &
                            55,  56,  57,  58,  59,  60,  61,  62,  63,  64, &
                            65,  66,  67,  68,  69,  70,  71,  72,  73,  74, &
                            75,  76,  77,  83,  84,  85,  86,  87,  88,  82, &
                            78,  79,  80,  81, 101, 102, 103,  89,  90,  91, &
                            92,  93,  94,  95,  96 /)

      permute(: 95,4) = (/   91,  30,  59,  88,  93,  94,  58,  41,  31,  89, &
                             90,  26,  92,  43,  82,  62,  33,  38,  27,  45, &
                             50,  63,  18,  71,  42,  76,  95,  49,  75,  19, &
                             72,  40,  67,  52,  68,  78,  34,  20,  35,  21, &
                             70,  65,  51,  66,  36,  74,  86,  61,  84,  80, &
                             85,  37,  87,  44,  79,  81,  83,  28,  64,  77, &
                             53,  23,  24,  55,  46,  29,  56,  54,  57,  47, &
                             60,  69,  73,  22,  32,   1,  17,   2,   3,   4, &
                              5,   6,   7,   8,  25,  39,  48,   9,  10,  11, &
                             12,  13,  14,  15,  16 /)

      diag_map(: 95) = (/    1,   2,   3,   4,   5,   7,   8,  10,  11,  12, &
                            13,  14,  15,  16,  17,  18,  19,  21,  24,  27, &
                            30,  34,  36,  41,  44,  49,  52,  56,  59,  63, &
                            70,  75,  80,  84,  89,  96, 101, 106, 113, 116, &
                           121, 126, 131, 136, 140, 146, 152, 157, 163, 168, &
                           171, 176, 183, 190, 195, 203, 208, 215, 219, 225, &
                           233, 241, 246, 250, 260, 271, 279, 287, 292, 306, &
                           321, 331, 342, 352, 370, 383, 392, 404, 414, 420, &
                           430, 438, 451, 464, 482, 501, 517, 558, 634, 685, &
                           716, 746, 767, 801, 824 /)

      extfrc_lst(:  4) = (/ 'NO              ','CO              ','SO2             ','SO4             ' /)

      frc_from_dataset(:  4) = (/ .true., .true., .true., .true. /)

      inv_lst(:  4) = (/ 'M               ', 'N2              ', 'O2              ', 'H2O             ' /)

      if( allocated( rxt_tag_lst ) ) then
         deallocate( rxt_tag_lst )
      end if
      allocate( rxt_tag_lst(rxt_tag_cnt),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate rxt_tag_lst; error = ',ios
         call endrun
      end if
      if( allocated( rxt_tag_map ) ) then
         deallocate( rxt_tag_map )
      end if
      allocate( rxt_tag_map(rxt_tag_cnt),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate rxt_tag_map; error = ',ios
         call endrun
      end if
      rxt_tag_lst(:rxt_tag_cnt) = (/ 'jo2                             ', 'jo1d                            ', &
                                     'jo3p                            ', 'jn2o                            ', &
                                     'jno2                            ', 'jn2o5                           ', &
                                     'jhno3                           ', 'jno3_a                          ', &
                                     'jno3_b                          ', 'jho2no2_a                       ', &
                                     'jho2no2_b                       ', 'jch3ooh                         ', &
                                     'jch2o_a                         ', 'jch2o_b                         ', &
                                     'jh2o2                           ', 'jch3cho                         ', &
                                     'jpooh                           ', 'jch3co3h                        ', &
                                     'jpan                            ', 'jmpan                           ', &
                                     'jmacr_a                         ', 'jmacr_b                         ', &
                                     'jmvk                            ', 'jc2h5ooh                        ', &
                                     'jc3h7ooh                        ', 'jrooh                           ', &
                                     'jacet                           ', 'jmgly                           ', &
                                     'jxooh                           ', 'jonitr                          ', &
                                     'jisopooh                        ', 'jhyac                           ', &
                                     'jglyald                         ', 'jmek                            ', &
                                     'jbigald                         ', 'jglyoxal                        ', &
                                     'jalkooh                         ', 'jmekooh                         ', &
                                     'jtolooh                         ', 'jterpooh                        ', &
                                     'usr_O_O2                        ', 'o1d_n2                          ', &
                                     'o1d_o2                          ', 'ox_l1                           ', &
                                     'ox_l2                           ', 'ox_l3                           ', &
                                     'usr_HO2_HO2                     ', 'ox_p1                           ', &
                                     'tag_NO2_NO3                     ', 'usr_N2O5_M                      ', &
                                     'tag_NO2_OH                      ', 'usr_HNO3_OH                     ', &
                                     'tag_NO2_HO2                     ', 'usr_HO2NO2_M                    ', &
                                     'ox_p2                           ', 'usr_CO_OH_b                     ', &
                                     'tag_C2H4_OH                     ', 'ox_l6                           ', &
                                     'ox_p16                          ', 'ox_p5                           ', &
                                     'ox_p4                           ', 'tag_CH3CO3_NO2                  ', &
                                     'usr_PAN_M                       ', 'tag_C3H6_OH                     ', &
                                     'ox_l4                           ', 'ox_p3                           ', &
                                     'ox_p9                           ', 'usr_CH3COCH3_OH                 ', &
                                     'ox_p10                          ', 'ox_p15                          ', &
                                     'ox_p17                          ', 'soa5                            ', &
                                     'ox_p14                          ', 'ox_l5                           ', &
                                     'ox_p6                           ', 'ox_l7                           ', &
                                     'ox_l8                           ', 'ox_p7                           ', &
                                     'ox_p8                           ', 'usr_MCO3_NO2                    ', &
                                     'usr_MPAN_M                      ', 'ox_p11                          ', &
                                     'usr_XOOH_OH                     ', 'soa4                            ', &
                                     'ox_p12                          ', 'soa2                            ', &
                                     'soa1                            ', 'soa3                            ', &
                                     'ox_p13                          ', 'usr_N2O5_aer                    ', &
                                     'usr_NO3_aer                     ', 'usr_NO2_aer                     ', &
                                     'usr_SO2_OH                      ', 'usr_DMS_OH                      ', &
                                     'usr_HO2_aer                     ' /)
      rxt_tag_map(:rxt_tag_cnt) = (/    1,   2,   3,   4,   5,   6,   7,   8,   9,  10, &
                                       11,  12,  13,  14,  15,  16,  17,  18,  19,  20, &
                                       21,  22,  23,  24,  25,  26,  27,  28,  29,  30, &
                                       31,  32,  33,  34,  35,  36,  37,  38,  39,  40, &
                                       41,  43,  44,  45,  50,  51,  52,  59,  64,  65, &
                                       66,  67,  69,  71,  74,  82,  90,  91,  92,  96, &
                                      103, 104, 109, 115, 116, 118, 122, 126, 127, 136, &
                                      138, 142, 143, 147, 148, 159, 161, 162, 169, 175, &
                                      176, 180, 186, 187, 190, 193, 194, 195, 196, 200, &
                                      201, 202, 204, 206, 210 /)
      if( allocated( pht_alias_lst ) ) then
         deallocate( pht_alias_lst )
      end if
      allocate( pht_alias_lst(phtcnt,2),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate pht_alias_lst; error = ',ios
         call endrun
      end if
      if( allocated( pht_alias_mult ) ) then
         deallocate( pht_alias_mult )
      end if
      allocate( pht_alias_mult(phtcnt,2),stat=ios )
      if( ios /= 0 ) then
         write(iulog,*) 'set_sim_dat: failed to allocate pht_alias_mult; error = ',ios
         call endrun
      end if
      pht_alias_lst(:,1) = (/ '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ' /)
      pht_alias_lst(:,2) = (/ 'jo2_b           ', 'jo3_a           ', 'jo3_b           ', '                ', &
                              '                ', 'jn2o5_a         ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              '                ', '                ', '                ', '                ', &
                              'jch3ooh         ', 'jh2o2           ', '                ', 'jpan            ', &
                              '                ', '                ', '                ', 'jch3ooh         ', &
                              'jch3ooh         ', 'jch3ooh         ', '                ', '                ', &
                              'jch3ooh         ', 'jch3cho         ', 'jch3ooh         ', '                ', &
                              '                ', 'jacet           ', 'jno2            ', 'jmgly           ', &
                              'jch3ooh         ', 'jch3ooh         ', 'jch3ooh         ', 'jch3ooh         ' /)
      pht_alias_mult(:,1) = (/ 1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8 /)
      pht_alias_mult(:,2) = (/ 1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, .28_r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, .2_r8, &
                          1._r8, 1._r8, 1._r8, 1._r8, 1._r8 /)

      end subroutine set_sim_dat

      end module mo_sim_dat
