pro vfnd, xin, yin, xout, yout,tight=tight, cut=cut,linear=linear
;+
; NAME:     vfnd
; PURPOSE:  Execute spline or interpol
; CATEGORY:
; CALLING SEQUENCE:
;          vfnd,   xin, yin, xout, yout
; INPUTS:
; OUTPUTS:    yout
; OPTIONAL INPUT PARAMETERS:
;            tight controls tightness of spline
;               cut = cut  set extrapolated values to cut
;                   = 0  extrapolate
;                   = 1  set extrapolated value to last value in x
; KEYWORD PARAMETERS:
;          linear = 1 for linear interpolation
;-


if n_elements(tight) eq 0       then tight = 1.0
if n_elements(cut) eq 0         then cut = 1
if n_elements(linear) eq 0      then linear = 0
if n_params() lt 4 then begin
   print,'vfnd called with too few parameters!'
   return
endif

if n_elements(xin) eq 0 or n_elements(xin) eq 0 then begin
   print,'vfnd called with zero element arrays!'
   return
endif

if n_elements(xout) eq 0 then begin
   print,'vfnd called with zero element grid array!'
   return
endif

; OUTPUTS:  yout
; 1. use interpol/spline fit to produce a new array yout = F(xout) using
;    yin = F(xin)
; if keyword cut
; 2. For points lying outside of array bounds of xin, set these
;    points equal to boundary values or missing.
; tight = sigma value for spline fit.  (0.01 ~ cubic spline)
;                                      (10   ~ polynomial interp)
; 3. values must be monotically increasing if spline.
;

  if not linear then begin
   Yout = Spline(xin,yin,xout,tight)
    endif else begin
     Yout = Interpol(yin,xin,xout)
     endelse

if cut ne 0 then begin                   ; set extrapolated values equal 
                                         ; to boundary values
   nin = n_elements(xin)
   Ymin = yin(0)
   Ymax = yin(nin-1)
     if cut ne 1 then ymax = cut     
     if cut ne 1 then ymin = cut     
         outhi = where ( xout gt max(xin),count )
         if count gt 0 then Yout(outhi) = Ymax
           outlo = where ( xout lt min(xin), count )
           if count gt 0 then Yout(outlo) = Ymin

endif

return
end
