;waccmx_50yr_yearly_alts.pro
;
;Calculate and plot global monthly and yearly mean WACCM-X 1955-2005 CO2 and Temperature at all pressure levels from the surface to the thermosphere using data from 
;h0 monthly files.  Global mean is calculated using an area weighted algorithm with the area calculated using the spherical cap method.  Then a regression
;analysis is performed as well as a fit to residuals to get the trend  
;
;
;Open first file to get lat/lon/pressure grid
;
fid = ncdf_open("/glade/scratch/joemci/f_1955-2005_waccmx_cesm1_1_beta08_pleiades/atm/hist/f_1955-2005_waccmx_cesm1_1_beta08.cam.h0.1955-01.nc")

ncdf_varget, fid, 'lat', lat
nLat = n_elements(lat)

dLat = FLTARR(nLat)

areaWeight = FLTARR(nLat)

ncdf_varget, fid, 'lon', lon
nLon = n_elements(lon)

ncdf_varget, fid, 'lev', pres
nPres = n_elements(pres)

ncdf_close,fid
;
;  Get area weights using spherical cap method where need to calculate area above one latitude and subtract from area of next lower 
;  latitude and get area for latitude band.  Then divide by number of longitudes to get grid area weight latitude/longitude point.
;  Area weights used to calculate global means
;
earthRadius = 6371.220 

FOR iLat = 0,nLat-1 DO BEGIN

  latForArea = ABS(lat)

  if iLat eq 0 then begin

    latArea = 2. * !PI * earthRadius*earthRadius * (1. - SIN(latForArea(1) * !PI/ 180.))

  endif else if iLat eq nLat-1 then begin

    latArea = 2. * !PI * earthRadius*earthRadius * (1. - SIN(latForArea(nLat-2) * !PI/ 180.))

  endif else begin 

    lat1 = (latForArea(iLat-1) + latForArea(iLat)) / 2.
    lat2 = (latForArea(iLat) + latForArea(iLat+1)) / 2.  
    latArea = 2. * !PI * earthRadius*earthRadius * ABS( (1. - SIN(lat1 * !PI/ 180.)) - (1. - SIN(lat2 * !PI/ 180.)) )

    if lat(iLat) lt 0. and lat(iLat+1) gt 0. then latArea = 2. * !PI * earthRadius*earthRadius * (1. - SIN(lat1 * !PI/ 180.))
    if lat(iLat) gt 0. and lat(iLat+1) lt 0. then latArea = 2. * !PI * earthRadius*earthRadius * (1. - SIN(lat2 * !PI/ 180.))

  endelse

  areaWeight[iLat] = latArea / nLon
  
ENDFOR

sumAreaWeight = TOTAL(areaWeight) * nLon

nYears = 56
nMonths = 12
iMonthAll = 0

;nNewGeomAlt = 9 ;50km
;newGeomAlt = REVERSE(FINDGEN(nNewGeomAlt)*50.)
;nNewGeomAlt = 17 ;25km
;newGeomAlt = REVERSE(FINDGEN(nNewGeomAlt)*50.) / 2.
;nNewGeomAlt = 81 ;5km 0-400km
nNewGeomAlt = 63 ;5km 0-315km
newGeomAlt = REVERSE(FINDGEN(nNewGeomAlt)*5.)
;newGeomAlt[nNewGeomAlt-1] = newGeomAlt[nNewGeomAlt-1] + .1  ; Don't make bottom point zero km altitude

CO2MonthlyAllGlobalMean = FLTARR(nYears*nMonths,nNewGeomAlt)
TMonthlyAllGlobalMean = FLTARR(nYears*nMonths,nNewGeomAlt)
DensMonthlyAllGlobalMean = FLTARR(nYears*nMonths,nNewGeomAlt)

CO2MonthlyGlobalMean = FLTARR(nMonths,nNewGeomAlt)
TMonthlyGlobalMean = FLTARR(nMonths,nNewGeomAlt)
DensMonthlyGlobalMean = FLTARR(nMonths,nNewGeomAlt)

CO2InterpAlt = FLTARR(nLon,nLat,nNewGeomAlt)
TInterpAlt = FLTARR(nLon,nLat,nNewGeomAlt)
DensInterpAlt = FLTARR(nLon,nLat,nNewGeomAlt)

CO2WeightedMean = FLTARR(nNewGeomAlt)
TWeightedMean = FLTARR(nNewGeomAlt)
DensWeightedMean = FLTARR(nNewGeomAlt)

CO2YearlyGlobalMean = FLTARR(nYears,nNewGeomAlt)
TYearlyGlobalMean = FLTARR(nYears,nNewGeomAlt)
DensYearlyGlobalMean = FLTARR(nYears,nNewGeomAlt)

DensIn = FLTARR(nLon,nLat,nPres)
;
;Loop over years and months and read CO2 and temperature to compile 50 year monthly and yearly global mean values
;
FOR iYear=0,nYears-1 DO BEGIN
    
  CO2MonthlyGlobalMean[*,*] = 0.
  TMonthlyGlobalMean[*,*] = 0.
  DensMonthlyGlobalMean[*,*] = 0.

  cYear = STRTRIM(iYear+1955,2)
  print, 'Doing year ', cYear
 
  FOR iMonth=0,nMonths-1 DO BEGIN

    CO2WeightedMean[*] = 0.
    TWeightedMean[*] = 0.
    DensWeightedMean[*] = 0.
 
    ;
    ;Open file, read monthly file CO2 and T, close file
    ;
    cMonth = STRTRIM(iMonth+1,2)
    cYear = STRTRIM(iYear+1955,2)
  
    if iMonth lt 9 then cMonth = '0'+cMonth

;    print, 'Opening/reading file for month/year ', cMonth, '/', cYear
  
    fid = ncdf_open("/glade/scratch/joemci/f_1955-2005_waccmx_cesm1_1_beta08_pleiades/atm/hist/f_1955-2005_waccmx_cesm1_1_beta08.cam.h0."+cYear+"-"+cMonth+".nc")

    ncdf_varget, fid, 'CO2', CO2In  ; [lon,lat,vert]
    ncdf_varget, fid, 'T', TIn  ; [lon,lat,vert]
    ncdf_varget, fid, 'Z3', geopAlt

    geomAlt = geopAlt * (1. + geopAlt/earthRadius/1000.) /1000.    
;
;  Do interpolation to altitude setting missing points to surface value
;    
    FOR iLat = 0,nLat-1 DO BEGIN

      FOR iLon = 0,nLon-1 DO BEGIN

        vfnd, geomAlt[iLon,iLat,*], CO2In[iLon,iLat,*], newGeomAlt, outDataCO2, cut=CO2In[iLon,iLat,nNewGeomAlt-1], linear=1
	CO2InterpAlt[iLon,iLat,*] = outDataCO2
        vfnd, geomAlt[iLon,iLat,*], TIn[iLon,iLat,*], newGeomAlt, outDataT, cut=TIn[iLon,iLat,nNewGeomAlt-1], linear=1
	TInterpAlt[iLon,iLat,*] = outDataT

        DensIn[iLon,iLat,*] = pres[*] * 100.0 / 287.058 / TIn[iLon,iLat,*]
 
        vfnd, geomAlt[iLon,iLat,*], DensIn[iLon,iLat,*], newGeomAlt, outDataDens, cut=DensIn[iLon,iLat,nNewGeomAlt-1], linear=1
        DensInterpAlt[iLon,iLat,*] = outDataDens

;
;  Check for when input maximum altitude for this point is below interpolated altitude and fill with top valid point
;
        FOR iAlt = nNewGeomAlt-1,0,-1 DO BEGIN

          if MAX(geomAlt[iLon,iLat,*]) lt newGeomAlt[iAlt] then CO2InterpAlt[iLon,iLat,iAlt] = CO2InterpAlt[iLon,iLat,iAlt+1]
  
        ENDFOR
        
      ENDFOR ;Lon

    ENDFOR ;Lat
;
;  Apply area weighting for each latitude and longitude to get global mean at each altitude level
;
    FOR iAlt = 0,nNewGeomAlt-1 DO BEGIN
    
      FOR iLat = 0,nLat-1 DO BEGIN

        FOR iLon = 0,nLon-1 DO BEGIN
	      
	  CO2WeightedMean[iAlt] = CO2WeightedMean[iAlt] + CO2InterpAlt[ILon,iLat,iAlt] * areaWeight[iLat]
	  TWeightedMean[iAlt] = TWeightedMean[iAlt] + TInterpAlt[ILon,iLat,iAlt] * areaWeight[iLat]
	  DensWeightedMean[iAlt] = DensWeightedMean[iAlt] + DensInterpAlt[ILon,iLat,iAlt] * areaWeight[iLat]
	  
        ENDFOR ;Lon

      ENDFOR ;Lat
    
      CO2MonthlyGlobalMean[iMonth,iAlt] = CO2WeightedMean[iAlt] / sumAreaWeight
      TMonthlyGlobalMean[iMonth,iAlt] = TWeightedMean[iAlt] / sumAreaWeight
      DensMonthlyGlobalMean[iMonth,iAlt] = DensWeightedMean[iAlt] / sumAreaWeight
    
      CO2MonthlyAllGlobalMean[iMonthAll,iAlt] = CO2WeightedMean[iAlt] / sumAreaWeight
      TMonthlyAllGlobalMean[iMonthAll,iAlt] = TWeightedMean[iAlt]/ sumAreaWeight
      DensMonthlyAllGlobalMean[iMonthAll,iAlt] = DensWeightedMean[iAlt]/ sumAreaWeight

    ENDFOR ;Altitude
    
    iMonthAll = iMonthAll + 1
    
;    print, 'Geometric altitude at top level ', iMonth, geomAltAllMeanTop
;    if geomAltMonthlyGlobalMeanTop lt 350. then print, 'Monthly geometric altitude at top level below 350', iMonth, geomAltMonthlyGlobalMeanTop
;    if geomAltMonthlyGlobalMeanTop gt 350. then print, 'Monthly geometric altitude at top level above 350', iMonth, geomAltMonthlyGlobalMeanTop
;    if geomAltMonthlyGlobalMeanTop gt 400. then print, 'Monthly geometric altitude at top level above 400', iMonth, geomAltMonthlyGlobalMeanTop
;    if geomAltMonthlyGlobalMeanTop gt 450. then print, 'Monthly geometric altitude at top level above 450', iMonth, geomAltMonthlyGlobalMeanTop

    ncdf_close,fid

  ENDFOR ;Month
;
;  Get yearly mean from monthly means for each altitude level
;
  FOR iAlt = 0,nNewGeomAlt-1 DO BEGIN

    CO2YearlyGlobalMean[iYear,iAlt] = MEAN(CO2MonthlyGlobalMean[*,iAlt])
    TYearlyGlobalMean[iYear,iAlt] = MEAN(TMonthlyGlobalMean[*,iAlt])
    DensYearlyGlobalMean[iYear,iAlt] = MEAN(DensMonthlyGlobalMean[*,iAlt])

  ENDFOR ;Altitude

;print, 'TYearlyGlobalMean Year ', iYear, TYearlyGlobalMean[iYear,*]

ENDFOR ;Year

;tempout = TMonthlyAllGlobalMean[*,7]
;
;fname='temperature_280km_globalmonthly_1955-2005.txt'
;OPENW,1,fname
;PRINTF,1,tempout,FORMAT='(F8.3,6X,F8.3,6X,F8.3,6X,F8.3,6X,F8.3,6X,F8.3,6X,F8.3,6X,F8.3,6X,F8.3)'
;;PRINTF,TMonthlyAllGlobalMean[*,7],FORMAT='(F7.3,6X,F7.3,6X,F7.3,6X,F7.3,6X,F7.3,6X,F7.3,6X,F7.3,6X,F7.3,6X,F7.3)'
;;PRINTF,TMonthlyAllGlobalMean[*,7]
;CLOSE,1
;
;tempout = TYearlyGlobalMean[*,7]
;
;fname='temperature_280km_globalyearly_1955-2005.txt'
;OPENW,1,fname
;PRINTF,1,tempout,FORMAT='(F8.3,6X,F8.3,6X,F8.3,6X,F8.3,6X,F8.3,6X,F8.3,6X,F8.3,6X,F8.3,6X,F8.3)'
;;PRINTF,TYearlyGlobalMean[*,7],FORMAT='(F7.3,6X,F7.3,6X,F7.3,6X,F7.3,6X,F7.3,6X,F7.3,6X,F7.3,6X,F7.3,6X,F7.3)'
;;PRINTF,TYearlyGlobalMean[*,7]
;CLOSE,1

SET_PLOT, 'PS'

psfile = 'monthly_CO2_T_AreaGlobalMean_WACCMX_Alt_2010.ps'

DEVICE, /COLOR, FILENAME = psfile
loadct, 39, ncolors=10

MonthsAll = INDGEN(iMonthAll)

FOR iAlt = 0,nNewGeomAlt-1 DO BEGIN

 yTitle = 'CO2 mol/mol'
 xTitle = 'Months Since January, 1955'
 
 cAlt = STRTRIM(newGeomAlt[iAlt],2)

 Title = 'CO2 1955-2010 Area Weighted Monthly Global Mean  '+cAlt+' km'
 plot, MonthsAll, CO2MonthlyAllGlobalMean[0:iMonthAll-1,iAlt],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
;Title = 'CO2 1955-2005 Area Weighted Monthly Global Mean ~350km'
;plot, MonthsAll, CO2MonthlyAllGlobalMean[0:iMonthAll-1,1],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
;Title = 'CO2 1955-2005 Area Weighted Monthly Global Mean ~300km'
;plot, MonthsAll, CO2MonthlyAllGlobalMean[0:iMonthAll-1,2],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
;Title = 'CO2 1955-2005 Area Weighted Monthly Global Mean ~250km'
;plot, MonthsAll, CO2MonthlyAllGlobalMean[0:iMonthAll-1,3],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1

;yrange=[0.0003,0.00038],
;yrange=[0.0003,0.00038],
;yrange=[0.0003,0.00038],


 yTitle = 'T (K)'

 Title = 'T 1955-2010 Area Weighted Monthly Global Mean  '+cAlt+' km'
 plot, MonthsAll, TMonthlyAllGlobalMean[0:iMonthAll-1,iAlt],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
;Title = 'T 1955-2005 Area Weighted Monthly Global Mean ~350km'
;plot, MonthsAll, TMonthlyAllGlobalMean[0:iMonthAll-1,1],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
;Title = 'T 1955-2005 Area Weighted Monthly Global Mean ~300km'
;plot, MonthsAll, TMonthlyAllGlobalMean[0:iMonthAll-1,2],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
;Title = 'T 1955-2005 Area Weighted Monthly Global Mean ~250km'
;plot, MonthsAll, TMonthlyAllGlobalMean[0:iMonthAll-1,3],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1

;yrange=[190.0,220.0],
;yrange=[222.0,238.0],
;yrange=[285.0,300.0],

ENDFOR ; Altitudes

device,/close

psfile = 'monthly_Dens_AreaGlobalMean_WACCMX_Alt_2010.ps'

DEVICE, /COLOR, FILENAME = psfile
loadct, 39, ncolors=10

MonthsAll = INDGEN(iMonthAll)

FOR iAlt = 0,nNewGeomAlt-1 DO BEGIN

 yTitle = 'Density cm-3'
 xTitle = 'Months Since January, 1955'
 
 cAlt = STRTRIM(newGeomAlt[iAlt],2)

 Title = 'Density 1955-2010 Area Weighted Monthly Global Mean  '+cAlt+' km'
 plot, MonthsAll, DensMonthlyAllGlobalMean[0:iMonthAll-1,iAlt],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1

ENDFOR ; Altitudes

device,/close

psfile = 'yearly_CO2_T_AreaGlobalMean_WACCMX_Alt_2010.ps'

DEVICE, /COLOR, FILENAME = psfile
loadct, 39, ncolors=10

YearsAll = INDGEN(nYears)

FOR iAlt = 0,nNewGeomAlt-1 DO BEGIN

 yTitle = 'CO2 mol/mol'
 xTitle = 'Years Since 1955'
 
 cAlt = STRTRIM(newGeomAlt[iAlt],2)

 Title = 'CO2 1955-2010 Area Weighted Yearly Global Mean  '+cAlt+' km'
 plot, YearsAll, CO2YearlyGlobalMean[0:nYears-1,iAlt],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
;Title = 'CO2 1955-2005 Area Weighted Yearly Global Mean ~350km'
;plot, YearsAll, CO2YearlyGlobalMean[0:nYears-1,1],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
;Title = 'CO2 1955-2005 Area Weighted Yearly Global Mean ~300km'
;plot, YearsAll, CO2YearlyGlobalMean[0:nYears-1,2],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
;Title = 'CO2 1955-2005 Area Weighted Yearly Global Mean 250km'
;plot, YearsAll, CO2YearlyGlobalMean[0:nYears-1,3],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1

;yrange=[0.0003,0.00038],
;yrange=[0.0003,0.00038],
;yrange=[0.0003,0.00038],


 yTitle = 'T (K)'
 
 Title = 'T 1955-2010 Area Weighted Yearly Global Mean '+cAlt+' km'
 plot, YearsAll, TYearlyGlobalMean[0:nYears-1,iAlt],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
;Title = 'T 1955-2005 Area Weighted Yearly Global Mean ~350km'
;plot, YearsAll, TYearlyGlobalMean[0:nYears-1,1],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
;Title = 'T 1955-2005 Area Weighted Yearly Global Mean ~300km'
;plot, YearsAll, TYearlyGlobalMean[0:nYears-1,2],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
;Title = 'T 1955-2005 Area Weighted Yearly Global Mean ~250km'
;plot, YearsAll, TYearlyGlobalMean[0:nYears-1,3],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1

;yrange=[190.0,220.0],
;yrange=[222.0,238.0],
;yrange=[285.0,300.0],

ENDFOR ; Altitudes

device,/close

psfile = 'yearly_Dens_AreaGlobalMean_WACCMX_Alt_2010.ps'

DEVICE, /COLOR, FILENAME = psfile
loadct, 39, ncolors=10

YearsAll = INDGEN(nYears)

FOR iAlt = 0,nNewGeomAlt-1 DO BEGIN

 yTitle = 'Dens kg m-3'
 xTitle = 'Years Since 1955'
 
 cAlt = STRTRIM(newGeomAlt[iAlt],2)

 Title = 'Density 1955-2010 Area Weighted Yearly Global Mean  '+cAlt+' km'
 plot, YearsAll, DensYearlyGlobalMean[0:nYears-1,iAlt],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1

ENDFOR ; Altitudes

device,/close
;
;  Plot year/altitude cross sections
;
CYears = ['1955','1960','1965','1970','1975','1980','1985','1990','1995','2000','2005']

psfile = 'year_alt_CO2_T_50yr_AreaGlobalMean_WACCMX_2010.ps'

DEVICE, /COLOR, FILENAME = psfile
loadct, 39

yTitle = 'Altitude (km)'
xTitle = 'Years'

levels = 21
clevels = findgen(levels) * 2.E-05
  
Title = ' WACCM-X CO2 1955-2005 Area Weighted Global Mean 0-120km'
CONTOUR, CO2YearlyGlobalMean[0:nYears-1,36:62],YearsAll,newGeomAlt[36:62],/fill,levels=clevels,yrange=[0.,120.],ystyle=1,xticks=10,$
                                                                                        xtickname=CYears,Title=Title,xtitle=xTitle,ytitle=yTitle
;,ymargin=[7,3]
CONTOUR, CO2YearlyGlobalMean[0:nYears-1,36:62],YearsAll,newGeomAlt[36:62],levels=clevels,/follow, yrange=[0.,120.],/overplot,ystyle=1
;,c_charsize=1.2
;  axis, xaxis=1,/save,xticks=12,xtickn=Months,xtitle='Month'

clevels = [1.E-12,5.E-12,1.E-11,5.E-11,1.E-10,5.E-10,1.E-09,5.E-09,1.E-08,5.E-08,1.E-07,5.E-07,1.E-06,5.E-06,1.E-05,5.E-05,1.E-04]

Title = ' WACCM-X CO2 1955-2010 Area Weighted Global Mean 120-400km'
CONTOUR, CO2YearlyGlobalMean[0:nYears-1,0:38],YearsAll,newGeomAlt[0:38],/fill,levels=clevels, yrange=[120.,310.],ystyle=1,xticks=10,$
                                                                                     xtickname=CYears,Title=Title,xtitle=xTitle,ytitle=yTitle
;,ymargin=[7,3]
CONTOUR, CO2YearlyGlobalMean[0:nYears-1,0:38],YearsAll,newGeomAlt[0:38],levels=clevels,/follow, yrange=[120.,310.],/overplot,ystyle=1
;,c_charsize=1.2
;  axis, xaxis=1,/save,xticks=12,xtickn=Months,xtitle='Month'

levels = 21
clevels = findgen(levels) * 16.

Title = ' WACCM-X T 1955-2010 Area Weighted Global Mean 0-120km '
CONTOUR, TYearlyGlobalMean[0:nYears-1,36:62],YearsAll,newGeomAlt[36:62],/fill,levels=clevels, yrange=[0.,120.],ystyle=1,xticks=10,$
                                                                                    xtickname=CYears,Title=Title,xtitle=xTitle,ytitle=yTitle
;,ymargin=[7,3]
CONTOUR, TYearlyGlobalMean[0:nYears-1,36:62],YearsAll,newGeomAlt[36:62],levels=clevels,/follow, yrange=[0.,120],/overplot,ystyle=1
;,c_charsize=1.2
;  axis, xaxis=1,/save,xticks=12,xtickn=Months,xtitle='Month'

levels = 16
clevels = findgen(levels) * 75.

Title = ' WACCM-X T 1955-2010 Area Weighted Global Mean 120-400km '
CONTOUR, TYearlyGlobalMean[0:nYears-1,0:38],YearsAll,newGeomAlt[0:38],/fill,levels=clevels, yrange=[120.,310.],ystyle=1,xticks=10,$
                                                                                   xtickname=CYears,Title=Title,xtitle=xTitle,ytitle=yTitle
;,ymargin=[7,3],xticks=11,xtickname=CMonths
CONTOUR, TYearlyGlobalMean[0:nYears-1,0:38],YearsAll,newGeomAlt[0:38],levels=clevels,/follow, yrange=[120.,310.],/overplot,ystyle=1
;,c_charsize=1.2
;  axis, xaxis=1,/save,xticks=12,xtickn=Months,xtitle='Month'

device,/close

;
;  Get monthly and yearly mean f107 and ap for regression
;
waccmx_solar_f107_ap_monthly_yearly_2010, f107AllMonthly, apAllMonthly, f107YearlyMean, apYearlyMean
;
;  Now do regression of yearly mean temperature with f10.7, ap, and f10.7*f10.7
;
f107AllMonthlySquared = f107AllMonthly * f107AllMonthly
f107InverseAllMonthly = 1. / f107AllMonthly
f107InverseAllMonthlySquared = f107InverseAllMonthly * f107InverseAllMonthly
f107YearlyMeanSquared = f107YearlyMean * f107YearlyMean
f107InverseYearlyMean = 1. / f107YearlyMean
f107InverseYearlyMeanSquared = f107InverseYearlyMean * f107InverseYearlyMean

f107apYearlyMean_1955_2005 = FLTARR(3,nYears)
f107apYearlyMean_1955_2005[0,*] = f107YearlyMean[0:nYears-1]
;f107apYearlyMean_1955_2005[0,*] = f107InverseYearlyMean[0:nYears-1]
f107apYearlyMean_1955_2005[1,*] = apYearlyMean[0:nYears-1]
f107apYearlyMean_1955_2005[2,*] = f107YearlyMeanSquared[0:nYears-1]
;f107apYearlyMean_1955_2005[2,*] = f107InverseYearlyMeanSquared[0:nYears-1]

f107apYearlyMean_1970_2000 = FLTARR(3,nYears-20)
f107apYearlyMean_1970_2000[0,*] = f107YearlyMean[15:nYears-6]
f107apYearlyMean_1970_2000[1,*] = apYearlyMean[15:nYears-6]
f107apYearlyMean_1970_2000[2,*] = f107YearlyMeanSquared[15:nYears-6]

residualsCO2YearlyGMean_1955_2005 = FLTARR(nYears,nNewGeomAlt)
residualsTYearlyGMean_1955_2005 = FLTARR(nYears,nNewGeomAlt)
fitCO2YearlyGMean_1955_2005 = FLTARR(nYears,nNewGeomAlt)
fitTYearlyGMean_1955_2005 = FLTARR(nYears,nNewGeomAlt)

residualsCO2YearlyGMean_1970_2000 = FLTARR(nYears-20,nNewGeomAlt)
residualsTYearlyGMean_1970_2000 = FLTARR(nYears-20,nNewGeomAlt)
fitCO2YearlyGMean_1970_2000 = FLTARR(nYears-20,nNewGeomAlt)
fitTYearlyGMean_1970_2000 = FLTARR(nYears-20,nNewGeomAlt)

psfile = 'yearly_CO2_T_AreaGlobalMean_WACCMX_Alt_Trends_2010.ps'

DEVICE, /COLOR, FILENAME = psfile
loadct, 39, ncolors=10

FOR iAlt = 0,nNewGeomAlt-1 DO BEGIN

  CO2YearlyGMean_1955_2005 = CO2YearlyGlobalMean[0:nYears-1,iAlt]
  regressCoeffs_1955_2005 = REGRESS(f107apYearlyMean_1955_2005, CO2YearlyGMean_1955_2005, YFIT=CO2YearlyGMeanFit_1955_2005)
  residualsCO2YearlyGMean_1955_2005[*,iAlt] = CO2YearlyGMean_1955_2005 - CO2YearlyGMeanFit_1955_2005

;  CO2YearlyGMean_1970_2000 = CO2YearlyGlobalMean[15:nYears-6,iAlt]
;  regressCoeffs_1970_2000 = REGRESS(f107apYearlyMean_1970_2000, CO2YearlyGMean_1970_2000, YFIT=CO2YearlyGMeanFit_1970_2000)
;  residualsCO2YearlyGMean_1970_2000 = CO2YearlyGMean_1970_2000 - CO2YearlyGMeanFit_1970_2000
   residualsCO2YearlyGMean_1970_2000[*,iAlt] = residualsCO2YearlyGMean_1955_2005[15:nYears-6,iAlt]
  ;
  ;  Get fit to residuals
  ;
  Years_1955_2005 = INDGEN(nYears)
  fitCoeffs = POLY_FIT(Years_1955_2005,residualsCO2YearlyGMean_1955_2005[*,iAlt],1,YFIT=fitCO2YGMean_1955_2005)
  fitCO2YearlyGMean_1955_2005[*,iAlt] = fitCO2YGMean_1955_2005
 
  Years_1970_2000 = INDGEN(nYears-20)
  fitCoeffs_1970_2000 = POLY_FIT(Years_1970_2000,residualsCO2YearlyGMean_1970_2000[*,iAlt],1,YFIT=fitCO2YGMean_1970_2000) 
  fitCO2YearlyGMean_1970_2000[*,iAlt] = fitCO2YGMean_1970_2000

  yTitle = 'CO2 mol/mol'
  xTitle = 'Years Since 1955'
 
  cAlt = STRTRIM(newGeomAlt[iAlt],2)

  Title = 'CO2 1955-2010 Area Weighted Yearly Global Mean Residuals & Fit '+cAlt+' km'
  plot, Years_1955_2005,residualsCO2YearlyGMean_1955_2005[*,iAlt],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
  oplot, fitCO2YearlyGMean_1955_2005[*,iAlt]

  xTitle = 'Years Since 1970'

  Title = 'CO2 1970-2000 Area Weighted Yearly Global Mean Residuals & Fit '+cAlt+' km'
  plot, Years_1970_2000,residualsCO2YearlyGMean_1970_2000[*,iAlt],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
  oplot, fitCO2YearlyGMean_1970_2000[*,iAlt]

;yrange=[0.0003,0.00038],
;yrange=[0.0003,0.00038],
;yrange=[0.0003,0.00038],

  TYearlyGMean_1955_2005 = TYearlyGlobalMean[0:nYears-1,iAlt]
  regressCoeffs_1955_2005 = REGRESS(f107apYearlyMean_1955_2005, TYearlyGMean_1955_2005, YFIT=TYearlyGMeanFit_1955_2005)
  residualsTYearlyGMean_1955_2005[*,iAlt] = TYearlyGMean_1955_2005 - TYearlyGMeanFit_1955_2005

;  TYearlyGMean_1970_2000 = TYearlyGlobalMean[15:nYears-6,iAlt]
;  regressCoeffs_1970_2000 = REGRESS(f107apYearlyMean_1970_2000, TYearlyGMean_1970_2000, YFIT=TYearlyGMeanFit_1970_2000)
;  residualsTYearlyGMean_1970_2000 = TYearlyGMean_1970_2000 - TYearlyGMeanFit_1970_2000
  residualsTYearlyGMean_1970_2000[*,iAlt] = residualsTYearlyGMean_1955_2005[15:nYears-6,iAlt]
  ;
  ;  Get fit to residuals
  ;
  Years_1955_2005 = INDGEN(nYears)
  fitCoeffs = POLY_FIT(Years_1955_2005,residualsTYearlyGMean_1955_2005[*,iAlt],1,YFIT=fitTYGMean_1955_2005)
  fitTYearlyGMean_1955_2005[*,iAlt] = fitTYGMean_1955_2005
 
  Years_1970_2000 = INDGEN(nYears-20)
  fitCoeffs_1970_2000 = POLY_FIT(Years_1970_2000,residualsTYearlyGMean_1970_2000[*,iAlt],1,YFIT=fitTYGMean_1970_2000) 
  fitTYearlyGMean_1970_2000[*,iAlt] = fitTYGMean_1970_2000

  yTitle = 'T (K)'

  xTitle = 'Years Since 1955'

  Title = 'T 1955-2010 Area Weighted Yearly Global Mean Residuals & Fit '+cAlt+' km'
  plot, Years_1955_2005,residualsTYearlyGMean_1955_2005[*,iAlt],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
  oplot, fitTYearlyGMean_1955_2005[*,iAlt]
;Title = 'T 1955-2005 Area Weighted Yearly Global Mean Residuals and Fit ~350km'
;plot, Years_1955_2005, [0:iMonthAll-1,1],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
;Title = 'T 1955-2005 Area Weighted Yearly Global Mean Residuals and Fit ~300km'
;plot, Years_1955_2005, [0:iMonthAll-1,2],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
;Title = 'T 1955-2005 Area Weighted Yearly Global Mean Residuals and Fit ~250km'
;plot, Years_1955_2005, [0:iMonthAll-1,3],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1

  xTitle = 'Years Since 1970'

  Title = 'T 1970-2000 Area Weighted Yearly Global Mean Residuals & Fit '+cAlt+' km'
  plot, Years_1970_2000,residualsTYearlyGMean_1970_2000[*,iAlt],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
  oplot, fitTYearlyGMean_1970_2000[*,iAlt]

ENDFOR

;yrange=[190.0,220.0],
;yrange=[222.0,238.0],
;yrange=[285.0,300.0],

device,/close

psfile = 'yearly_Dens_AreaGlobalMean_WACCMX_Alt_Trends_2010.ps'

DEVICE, /COLOR, FILENAME = psfile
loadct, 39, ncolors=10

FOR iAlt = 0,nNewGeomAlt-1 DO BEGIN

  DensYearlyGMean_1955_2005 = DensYearlyGlobalMean[0:nYears-1,iAlt]
  regressCoeffs_1955_2005 = REGRESS(f107apYearlyMean_1955_2005, DensYearlyGMean_1955_2005, YFIT=DensYearlyGMeanFit_1955_2005)
  residualsDensYearlyGMean_1955_2005 = DensYearlyGMean_1955_2005 - DensYearlyGMeanFit_1955_2005

  residualsDensYearlyGMean_1970_2000 = residualsDensYearlyGMean_1955_2005[15:nYears-6]
  ;
  ;  Get fit to residuals
  ;
  Years_1955_2005 = INDGEN(nYears)
  fitCoeffs = POLY_FIT(Years_1955_2005,residualsDensYearlyGMean_1955_2005,1,YFIT=fitDensYearlyGMean_1955_2005)
 
  Years_1970_2000 = INDGEN(nYears-20)
  fitCoeffs_1970_2000 = POLY_FIT(Years_1970_2000,residualsDensYearlyGMean_1970_2000,1,YFIT=fitDensYearlyGMean_1970_2000) 

  yTitle = 'Density cm-3'
  xTitle = 'Years Since 1955'
 
  cAlt = STRTRIM(newGeomAlt[iAlt],2)

  Title = 'Density 1955-2010 Area Weighted Yearly Global Mean Residuals & Fit '+cAlt+' km'
  plot, Years_1955_2005,residualsDensYearlyGMean_1955_2005,title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
  oplot, fitDensYearlyGMean_1955_2005

  xTitle = 'Years Since 1970'

  Title = 'Density 1970-2000 Area Weighted Yearly Global Mean Residuals & Fit '+cAlt+' km'
  plot, Years_1970_2000,residualsDensYearlyGMean_1970_2000,title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
  oplot, fitDensYearlyGMean_1970_2000

ENDFOR

device,/close
;
;  Now do regression of monthly mean temperature with f10.7 and ap
;
f107apMonthlyMean_1955_2005 = FLTARR(3,iMonthAll)
f107apMonthlyMean_1955_2005[0,*] = f107AllMonthly[0:iMonthAll-1]
;f107apMonthlyMean_1955_2005[0,*] = f107InverseAllMonthly[0:iMonthAll-1]
f107apMonthlyMean_1955_2005[1,*] = apAllMonthly[0:iMonthAll-1]
f107apMonthlyMean_1955_2005[2,*] = f107AllMonthlySquared[0:iMonthAll-1]
;f107apMonthlyMean_1955_2005[2,*] = f107InverseAllMonthlySquared[0:iMonthAll-1]

f107apMonthlyMean_1970_2000 = FLTARR(3,iMonthAll-240)
f107apMonthlyMean_1970_2000[0,*] = f107AllMonthly[180:iMonthAll-61]
f107apMonthlyMean_1970_2000[1,*] = apAllMonthly[180:iMonthAll-61]
f107apMonthlyMean_1970_2000[2,*] = f107AllMonthlySquared[180:iMonthAll-61]

psfile = 'monthly_CO2_T_AreaGlobalMean_WACCMX_Alt_Trends_2010.ps'

DEVICE, /COLOR, FILENAME = psfile
loadct, 39, ncolors=10

FOR iAlt = 0,nNewGeomAlt-1 DO BEGIN

  CO2MonthlyAllGMean_1955_2005 = CO2MonthlyAllGlobalMean[*,iAlt]
;  CO2MonthlyAllGMean_1970_2000 = CO2MonthlyAllGlobalMean[180:iMonthAll-61,iAlt]
  regressCoeffs = REGRESS(f107apMonthlyMean_1955_2005, CO2MonthlyAllGMean_1955_2005, YFIT=CO2MonthlyGMeanFit_1955_2005)
  residualsCO2MonthlyGMean_1955_2005 = CO2MonthlyAllGMean_1955_2005 - CO2MonthlyGMeanFit_1955_2005
;  regressCoeffs = REGRESS(f107apMonthlyMean_1970_2000, CO2MonthlyAllGMean_1970_2000, YFIT=CO2MonthlyGMeanFit_1970_2000)
;  residualsCO2MonthlyGMean_1970_2000 = CO2MonthlyAllGMean_1970_2000 - CO2MonthlyGMeanFit_1970_2000
  residualsCO2MonthlyGMean_1970_2000 = residualsCO2MonthlyGMean_1955_2005[180:iMonthAll-61]
  ;
  ;  Get fit to residuals
  ;
  Months_1955_2005 = INDGEN(iMonthAll)
  fitCoeffs_1955_2005 = POLY_FIT(Months_1955_2005,residualsCO2MonthlyGMean_1955_2005,1,YFIT=fitCO2MonthlyGMean_1955_2005) 

  Months_1970_2000 = INDGEN(iMonthAll-240)
  fitCoeffs_1970_2000 = POLY_FIT(Months_1970_2000,residualsCO2MonthlyGMean_1970_2000[0:iMonthAll-241],1,YFIT=fitCO2MonthlyGMean_1970_2000) 

  yTitle = 'CO2 mol/mol'
  xTitle = 'Months Since January, 1955'
 
  cAlt = STRTRIM(newGeomAlt[iAlt],2)

  Title = 'CO2 1955-2010 Area Weighted Monthly Global Mean Residuals and Fit '+cAlt+' km'
  plot, Months_1955_2005,residualsCO2MonthlyGMean_1955_2005,title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
  oplot, fitCO2MonthlyGMean_1955_2005

  xTitle = 'Months Since January, 1970'

  Title = 'CO2 1970-2000 Area Weighted Monthly Global Mean Residuals and Fit '+cAlt+' km'
  plot, Months_1970_2000,residualsCO2MonthlyGMean_1970_2000,title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
  oplot, fitCO2MonthlyGMean_1970_2000

;Title = 'CO2 1955-2005 Area Weighted Monthly Global Mean Residuals and Fit ~400km'
;plot, Months_1955_2005, ,title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
;Title = 'CO2 1955-2005 Area Weighted Monthly Global Mean Residuals and Fit ~350km'
;plot, Months_1955_2005, [0:iMonthAll-1,1],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
;Title = 'CO2 1955-2005 Area Weighted Monthly Global Mean Residuals and Fit ~300km'
;plot, Months_1955_2005, [0:iMonthAll-1,2],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
;Title = 'CO2 1955-2005 Area Weighted Monthly Global Mean Residuals and Fit ~250km'
;plot, Months_1955_2005, [0:iMonthAll-1,3],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1

;yrange=[0.0003,0.00038],
;yrange=[0.0003,0.00038],
;yrange=[0.0003,0.00038],

  TMonthlyAllGMean_1955_2005 = TMonthlyAllGlobalMean[*,iAlt]
;  TMonthlyAllGMean_1970_2000 = TMonthlyAllGlobalMean[180:iMonthAll-61,iAlt]
  regressCoeffs = REGRESS(f107apMonthlyMean_1955_2005, TMonthlyAllGMean_1955_2005, YFIT=TMonthlyGMeanFit_1955_2005)
  residualsTMonthlyGMean_1955_2005 = TMonthlyAllGMean_1955_2005 - TMonthlyGMeanFit_1955_2005
;  regressCoeffs = REGRESS(f107apMonthlyMean_1970_2000, TMonthlyAllGMean_1970_2000, YFIT=TMonthlyGMeanFit_1970_2000)
;  residualsTMonthlyGMean_1970_2000 = TMonthlyAllGMean_1970_2000 - TMonthlyGMeanFit_1970_2000
  residualsTMonthlyGMean_1970_2000 = residualsTMonthlyGMean_1955_2005[180:iMonthAll-61]
  ;
  ;  Get fit to residuals
  ;
  Months_1955_2005 = INDGEN(iMonthAll)
  fitCoeffs_1955_2005 = POLY_FIT(Months_1955_2005,residualsTMonthlyGMean_1955_2005,1,YFIT=fitTMonthlyGMean_1955_2005) 

  Months_1970_2000 = INDGEN(iMonthAll-240)
  fitCoeffs_1970_2000 = POLY_FIT(Months_1970_2000,residualsTMonthlyGMean_1970_2000[0:iMonthAll-241],1,YFIT=fitTMonthlyGMean_1970_2000) 

  yTitle = 'T (K)'


  Title = 'T 1955-2010 Area Weighted Monthly Global Mean Residuals and Fit '+cAlt+' km'
  plot, Months_1955_2005,residualsTMonthlyGMean_1955_2005,title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
  oplot, fitTMonthlyGMean_1955_2005
;Title = 'T 1955-2005 Area Weighted Monthly Global Mean Residuals and Fit ~350km'
;plot, Months_1955_2005, [0:iMonthAll-1,1],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
;Title = 'T 1955-2005 Area Weighted Monthly Global Mean Residuals and Fit ~300km'
;plot, Months_1955_2005, [0:iMonthAll-1,2],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
;Title = 'T 1955-2005 Area Weighted Monthly Global Mean Residuals and Fit ~250km'
;plot, Months_1955_2005, [0:iMonthAll-1,3],title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1

  xTitle = 'Months Since January, 1970'

  Title = 'T 1970-2000 Area Weighted Monthly Global Mean Residuals and Fit '+cAlt+' km'
  plot, Months_1970_2000,residualsTMonthlyGMean_1970_2000,title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
  oplot, fitTMonthlyGMean_1970_2000

;yrange=[190.0,220.0],
;yrange=[222.0,238.0],
;yrange=[285.0,300.0],

ENDFOR

device,/close

psfile = 'monthly_Dens_AreaGlobalMean_WACCMX_Alt_Trends_2010.ps'

DEVICE, /COLOR, FILENAME = psfile
loadct, 39, ncolors=10

FOR iAlt = 0,nNewGeomAlt-1 DO BEGIN

  DensMonthlyAllGMean_1955_2005 = DensMonthlyAllGlobalMean[*,iAlt]
  regressCoeffs = REGRESS(f107apMonthlyMean_1955_2005, DensMonthlyAllGMean_1955_2005, YFIT=DensMonthlyGMeanFit_1955_2005)
  residualsDensMonthlyGMean_1955_2005 = DensMonthlyAllGMean_1955_2005 - DensMonthlyGMeanFit_1955_2005

  residualsDensMonthlyGMean_1970_2000 = residualsDensMonthlyGMean_1955_2005[180:iMonthAll-61]
  ;
  ;  Get fit to residuals
  ;
  Months_1955_2005 = INDGEN(iMonthAll)
  fitCoeffs_1955_2005 = POLY_FIT(Months_1955_2005,residualsDensMonthlyGMean_1955_2005,1,YFIT=fitDensMonthlyGMean_1955_2005) 

  Months_1970_2000 = INDGEN(iMonthAll-240)
  fitCoeffs_1970_2000 = POLY_FIT(Months_1970_2000,residualsDensMonthlyGMean_1970_2000[0:iMonthAll-241],1,YFIT=fitDensMonthlyGMean_1970_2000) 

  yTitle = 'Density cm-3'
  xTitle = 'Months Since January, 1955'
 
  cAlt = STRTRIM(newGeomAlt[iAlt],2)

  Title = 'Density 1955-2010 Area Weighted Monthly Global Mean Residuals and Fit '+cAlt+' km'
  plot, Months_1955_2005,residualsDensMonthlyGMean_1955_2005,title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
  oplot, fitDensMonthlyGMean_1955_2005

  xTitle = 'Months Since January, 1970'

  Title = 'Density 1970-2000 Area Weighted Monthly Global Mean Residuals and Fit '+cAlt+' km'
  plot, Months_1970_2000,residualsDensMonthlyGMean_1970_2000,title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1
  oplot, fitDensMonthlyGMean_1970_2000

ENDFOR

device,/close
;
;  Plot year/altitude trend cross sections
;
CYears = ['1955','1960','1965','1970','1975','1980','1985','1990','1995','2000','2005']

psfile = 'year_alt_CO2_T_50yr_AreaGlobalMean_WACCMX_Trends_2010.ps'

DEVICE, /COLOR, FILENAME = psfile
loadct, 39

yTitle = 'Altitude (km)'
xTitle = 'Years'

levels = 21
clevels = findgen(levels)  * 3.5E-06 - 3.E-05
;clevels = findgen(levels) * 2.E-05
  
Title = ' WACCM-X CO2 1955-2010 Area Weighted Global Mean 0-120km'
CONTOUR, residualsCO2YearlyGMean_1955_2005[0:nYears-1,36:62],YearsAll,newGeomAlt[36:62],/fill,levels=clevels,yrange=[0.,120.],ystyle=1,xticks=10,$
                                                                                        xtickname=CYears,Title=Title,xtitle=xTitle,ytitle=yTitle
;,ymargin=[7,3]
CONTOUR, residualsCO2YearlyGMean_1955_2005[0:nYears-1,36:62],YearsAll,newGeomAlt[36:62],levels=clevels,/follow, yrange=[0.,120.],/overplot,ystyle=1
;,c_charsize=1.2
;  axis, xaxis=1,/save,xticks=12,xtickn=Months,xtitle='Month'

;clevels = [1.E-12,5.E-12,1.E-11,5.E-11,1.E-10,5.E-10,1.E-09,5.E-09,1.E-08,5.E-08,1.E-07,5.E-07,1.E-06,5.E-06,1.E-05,5.E-05,1.E-04]
clevels = findgen(levels)  * 5.5E-07 - 6.E-06

Title = ' WACCM-X CO2 1955-2010 Area Weighted Global Mean 120-400km'
CONTOUR, residualsCO2YearlyGMean_1955_2005[0:nYears-1,0:38],YearsAll,newGeomAlt[0:38],/fill,levels=clevels, yrange=[120.,310.],ystyle=1,xticks=10,$
                                                                                     xtickname=CYears,Title=Title,xtitle=xTitle,ytitle=yTitle
;,ymargin=[7,3]
CONTOUR, residualsCO2YearlyGMean_1955_2005[0:nYears-1,0:38],YearsAll,newGeomAlt[0:38],levels=clevels,/follow,yrange=[120.,310.],/overplot,ystyle=1
;,c_charsize=1.2
;  axis, xaxis=1,/save,xticks=12,xtickn=Months,xtitle='Month'

levels = 10
clevels = findgen(levels) / 1.25 - 4.

Title = ' WACCM-X T 1955-2010 Area Weighted Global Mean 0-120km '
CONTOUR, residualsTYearlyGMean_1955_2005[0:nYears-1,36:62],YearsAll,newGeomAlt[36:62],/fill,levels=clevels, yrange=[0.,120.],ystyle=1,xticks=10,$
                                                                                    xtickname=CYears,Title=Title,xtitle=xTitle,ytitle=yTitle
;,ymargin=[7,3]
CONTOUR, residualsTYearlyGMean_1955_2005[0:nYears-1,36:62],YearsAll,newGeomAlt[36:62],levels=clevels,/follow, yrange=[0.,120],/overplot,ystyle=1
;,c_charsize=1.2
;  axis, xaxis=1,/save,xticks=12,xtickn=Months,xtitle='Month'

levels = 10
clevels = findgen(levels) * 14. - 68.

Title = ' WACCM-X T 1955-2010 Area Weighted Global Mean 120-400km '
CONTOUR, residualsTYearlyGMean_1955_2005[0:nYears-1,0:38],YearsAll,newGeomAlt[0:38],/fill,levels=clevels, yrange=[120.,310.],ystyle=1,xticks=10,$
                                                                                   xtickname=CYears,Title=Title,xtitle=xTitle,ytitle=yTitle
;,ymargin=[7,3],xticks=11,xtickname=CMonths
CONTOUR, residualsTYearlyGMean_1955_2005[0:nYears-1,0:38],YearsAll,newGeomAlt[0:38],levels=clevels,/follow, yrange=[120.,310.],/overplot,ystyle=1
;,c_charsize=1.2
;  axis, xaxis=1,/save,xticks=12,xtickn=Months,xtitle='Month'

device,/close
;
;  Plot trend altitude vertical profiles for global mean
;
psfile = 'CO2_T_alt_50yr_AreaGlobalMean_WACCMX_Trends_2010.ps'

DEVICE, /COLOR, FILENAME = psfile
loadct, 39

yTitle = 'Altitude (km)'

xTitle = 'CO2 Residual Trend'

diffsresidualsCO2YearlyGMean_1955_2005 = residualsCO2YearlyGMean_1955_2005[nYears-1,*] - residualsCO2YearlyGMean_1955_2005[0,*]
diffsfitCO2YearlyGMean_1955_2005 = fitCO2YearlyGMean_1955_2005[nYears-1,*] - fitCO2YearlyGMean_1955_2005[0,*]

;perdiffsfitCO2YearlyGMean_1955_2005 = FLTARR(nNewGeomAlt)
;
;FOR iAlt=0,nNewGeomAlt-1 DO BEGIN
;
;  perdiffsfitCO2YearlyGMean_1955_2005[iAlt] = diffsfitCO2YearlyGMean_1955_2005[iAlt] / $
;                                         ((fitCO2YearlyGMean_1955_2005[nYears-1,iAlt] + fitCO2YearlyGMean_1955_2005[0,iAlt]) / 2.) * 100.
;ENDFOR

;Title = 'CO2 1955-2005 Area Weighted Monthly Global Mean Residuals Trend'
;plot, REFORM(diffsresidualsCO2YearlyGMean_1955_2005),newGeomAlt,title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1,xrange=[-1.E-05,7.E-05]
Title = 'CO2 1955-2010 Area Weighted Monthly Global Mean Residual Fit Trend 0-150km'
plot, REFORM(diffsfitCO2YearlyGMean_1955_2005(0,32:62)),newGeomAlt(32:62),title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1,xrange=[-5.E-06,7.E-05],yrange=[0.,150.]
Title = 'CO2 1955-2010 Area Weighted Monthly Global Mean Residual Fit Trend 150-320km'
plot, REFORM(diffsfitCO2YearlyGMean_1955_2005(0,0:34)),newGeomAlt(0:34),title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1,xrange=[-1.E-06,1.E-07],yrange=[150.,320.]
;Title = 'CO2 1955-2005 Area Weighted Monthly Global Mean Residual Fit % Trend'
;plot, REFORM(perdiffsfitCO2YearlyGMean_1955_2005),newGeomAlt,title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1,xrange=[0.,100.]

diffsresidualsCO2YearlyGMean_1970_2000 = residualsCO2YearlyGMean_1955_2005[nYears-6,*] - residualsCO2YearlyGMean_1955_2005[15,*]
diffsfitCO2YearlyGMean_1970_2000 = fitCO2YearlyGMean_1970_2000[nYears-21,*] - fitCO2YearlyGMean_1970_2000[0,*]

;perdiffsfitCO2YearlyGMean_1970_2000 = FLTARR(nNewGeomAlt)
;
;FOR iAlt=0,nNewGeomAlt-1 DO BEGIN
;
;perdiffsfitCO2YearlyGMean_1970_2000[iAlt] = diffsfitCO2YearlyGMean_1970_2000[iAlt] / $
;                                         ((fitCO2YearlyGMean_1970_2000[nYears-21,iAlt] + fitCO2YearlyGMean_1970_2000[0,iAlt]) / 2.) * 100.
;ENDFOR

;Title = 'CO2 1970-2000 Area Weighted Monthly Global Mean Residuals Trend'
;plot, REFORM(diffsresidualsCO2YearlyGMean_1970_2000),newGeomAlt,title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1,xrange=[-1.E-05,7.E-05]
Title = 'CO2 1970-2000 Area Weighted Monthly Global Mean Residual Fit Trend 0-150km'
plot, REFORM(diffsfitCO2YearlyGMean_1970_2000(0,32:62)),newGeomAlt(32:62),title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1,xrange=[0.,5.E-05],yrange=[0.,150.]
Title = 'CO2 1970-2000 Area Weighted Monthly Global Mean Residual Fit Trend 150-320km'
plot, REFORM(diffsfitCO2YearlyGMean_1970_2000(0,0:34)),newGeomAlt(0:34),title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1,xrange=[-1.E-07,1.E-06],yrange=[150.,320.]
;Title = 'CO2 1970-2000 Area Weighted Monthly Global Mean Residual Fit % Trend'
;plot, REFORM(perdiffsfitCO2YearlyGMean_1970_2000),newGeomAlt,title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1,xrange=[0.,100.]

xTitle = 'T Residual Trend'

diffsresidualsTYearlyGMean_1955_2005 = residualsTYearlyGMean_1955_2005[nYears-1,*] - residualsTYearlyGMean_1955_2005[0,*]
diffsfitTYearlyGMean_1955_2005 = fitTYearlyGMean_1955_2005[nYears-1,*] - fitTYearlyGMean_1955_2005[0,*]

;Title = 'T 1955-2005 Area Weighted Monthly Global Mean Residuals Trend'
;plot, REFORM(diffsresidualsTYearlyGMean_1955_2005),newGeomAlt,title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1,xrange=[-10.,30.]
Title = 'T 1955-2010 Area Weighted Monthly Global Mean Residual Fit Trend 0-320km'
plot, REFORM(diffsfitTYearlyGMean_1955_2005),newGeomAlt,title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1,xrange=[-10.,40.],yrange=[0.,320.]
;Title = 'T 1955-2005 Area Weighted Monthly Global Mean Residual Fit Trend 0-150km'
;plot, REFORM(diffsfitTYearlyGMean_1955_2005(0,36:62)),newGeomAlt(36:62),title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1,xrange=[-10.,30.],yrange=[0.,120.]
;Title = 'T 1955-2005 Area Weighted Monthly Global Mean Residual Fit Trend 150-320km'
;plot, REFORM(diffsfitTYearlyGMean_1955_2005(0,0:38)),newGeomAlt(0:38),title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1,xrange=[-10.,30.],yrange=[120.,320.]

diffsresidualsTYearlyGMean_1970_2000 = residualsTYearlyGMean_1955_2005[nYears-6,*] - residualsTYearlyGMean_1955_2005[15,*]
diffsfitTYearlyGMean_1970_2000 = fitTYearlyGMean_1970_2000[nYears-21,*] - fitTYearlyGMean_1970_2000[0,*]

;Title = 'T 1970-2000 Area Weighted Monthly Global Mean Residuals Trend'
;plot, REFORM(diffsresidualsTYearlyGMean_1970_2000),newGeomAlt,title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1,xrange=[-10.,30.]
Title = 'T 1970-2000 Area Weighted Monthly Global Mean Residual Fit Trend 0-320km'
plot, REFORM(diffsfitTYearlyGMean_1970_2000),newGeomAlt,title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1,xrange=[-15.,10.],yrange=[0.,320.]
;Title = 'T 1970-2000 Area Weighted Monthly Global Mean Residual Fit Trend 0-150km'
;plot, REFORM(diffsfitTYearlyGMean_1970_2000(0,36:62)),newGeomAlt(36:62),title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1,xrange=[-10.,30.],yrange=[0.,120.]
;Title = 'T 1970-2000 Area Weighted Monthly Global Mean Residual Fit Trend 150-320km'
;plot, REFORM(diffsfitTYearlyGMean_1970_2000(0,0:38)),newGeomAlt(0:38),title=Title,xtitle=xTitle,ytitle=yTitle,xstyle=1,ystyle=1,xrange=[-10.,30.],yrange=[120.,320.]

device,/close

;plot, residualsTMonthlyGMean
;oplot, fitTMonthlyGMean
;
;plot, residualsTYearlyGMean
;oplot, fitTYearlyGMean

END
