module timing
  use shr_kind_mod ,only: r8 => shr_kind_r8 ! 8-byte reals
  use params       ,only: iulog      ! stdout unit
  implicit none
  save
!
! For MPI timing, using mpi_wtime():
!
  logical :: mpi_timing=.true.

  real(r8),save ::                 &
    time_esmf_init        = 0._r8, & ! time in esmf_init (my_esmf.F90)
    time_dynamo_input     = 0._r8, & ! time in dynamo_input (edynamo.F90)
!
! Routines in my_mpi.F90:
!
    time_geopole_3d       = 0._r8, & ! time spent in mp_geopole_3d
    time_geopole_2d       = 0._r8, & ! time spent in mp_geopole_2d
    time_periodic_f2d     = 0._r8, & ! time spent in mp_periodic_f2d
    time_periodic_f3d     = 0._r8, & ! time spent in mp_periodic_f3d
    time_mageq            = 0._r8, & ! time spent in mp_mageq
    time_mageq_jpm1       = 0._r8, & ! time spent in mp_mageq_jpm1
    time_mageq_jpm3       = 0._r8, & ! time spent in mp_mageq_jpm3
    time_magpole_2d       = 0._r8, & ! time spent in mp_magpole_2d
    time_magpole_3d       = 0._r8, & ! time spent in mp_magpole_3d
    time_mag_foldhem      = 0._r8, & ! time spent in mp_mag_foldhem
    time_conjugate_points = 0._r8, & ! time spent in mp_conjugate_points
    time_mag_periodic_f2d = 0._r8, & ! time spent in mp_mag_periodic_f2d
    time_mag_periodic_f3d = 0._r8, & ! time spent in mp_mag_periodic_f3d
    time_mag_halos        = 0._r8, & ! time spent in mp_mag_halos
    time_gather_edyn      = 0._r8, & ! time spent in mp_gather_edyn
    time_scatter_phim     = 0._r8, & ! time spent in mp_scatter_phim
    time_mag_jslot        = 0._r8, & ! time spent in mp_mag_jslot
    time_magpoles         = 0._r8, & ! time spent in mp_magpoles
    time_total            = 0._r8

  contains
!-----------------------------------------------------------------------
! subroutine begtiming(time)

! end subroutine begtiming
!-----------------------------------------------------------------------
  subroutine report_timing

    write(iulog,"(/,'EDYNAMO timing:')")
    write(iulog,"('time_esmf_init         =',f12.4)") time_esmf_init
    write(iulog,"('time_dynamo_input      =',f12.4)") time_dynamo_input

    write(iulog,"(/,'MPI timing:')")
    write(iulog,"('time_geopole_3d        =',f12.4)") time_geopole_3d 
    write(iulog,"('time_geopole_2d        =',f12.4)") time_geopole_2d
    write(iulog,"('time_periodic_f2d      =',f12.4)") time_periodic_f2d
    write(iulog,"('time_periodic_f3d      =',f12.4)") time_periodic_f3d
    write(iulog,"('time_mageq             =',f12.4)") time_mageq
    write(iulog,"('time_mageq_jpm1        =',f12.4)") time_mageq_jpm1
    write(iulog,"('time_mageq_jpm3        =',f12.4)") time_mageq_jpm3
    write(iulog,"('time_magpole_2d        =',f12.4)") time_magpole_2d
    write(iulog,"('time_magpole_3d        =',f12.4)") time_magpole_3d
    write(iulog,"('time_mag_foldhem       =',f12.4)") time_mag_foldhem
    write(iulog,"('time_conjugate_points  =',f12.4)") time_conjugate_points
    write(iulog,"('time_mag_periodic_f2d  =',f12.4)") time_mag_periodic_f2d
    write(iulog,"('time_mag_periodic_f3d  =',f12.4)") time_mag_periodic_f3d
    write(iulog,"('time_mag_halos         =',f12.4)") time_mag_halos
    write(iulog,"('time_gather_edyn       =',f12.4)") time_gather_edyn
    write(iulog,"('time_scatter_phim      =',f12.4)") time_scatter_phim
    write(iulog,"('time_mag_jslot         =',f12.4)") time_mag_jslot
    write(iulog,"('time_magpoles          =',f12.4)") time_magpoles

    write(iulog,"(/,'time_total             =',f12.4)") time_total
   
  end subroutine report_timing
!-----------------------------------------------------------------------

end module timing
