module fields
!
! Define a field structure. This is used for output only.
!
  use shr_kind_mod, only: r8 => shr_kind_r8            ! 8-byte reals
  use params,only: max_chars,max_fields,fillvalue
  implicit none
  save

  type field
    character(len=max_chars) :: name
    character(len=max_chars) :: long_name
    character(len=max_chars) :: units
    character(len=8)         :: dimnames(3)
    integer                  :: dimsizes(3)
    integer                  :: ndims
    logical                  :: geo,mag
    logical                  :: task0_only
    real(r8)                 :: fillvalue
    real(r8),pointer         :: data(:,:,:)
  end type field
  type(field) :: fields_out(max_fields)
  integer :: nfields
  contains
!-----------------------------------------------------------------------
  subroutine field_init(f)
!
! Args:
    type(field),intent(out) :: f

    f%name       = ' '
    f%long_name  = ' '
    f%units      = ' '
    f%dimnames   = ' '
    f%dimsizes   = 0
    f%ndims      = 0
    f%geo        = .false.
    f%mag        = .true.
    f%task0_only = .false.
    f%data       => NULL()
    f%fillvalue  = fillvalue
 
  end subroutine field_init
!-----------------------------------------------------------------------
end module fields
