module params
!
! Constants for edynamo.
!
  use shr_kind_mod, only: r8 => shr_kind_r8            ! 8-byte reals
  implicit none
  save

  real(r8),parameter :: &
    finit = 0._r8,      & ! initialization value
    re = 6.37122e8_r8,  & ! earth radius (cm)
    gask = 8.314e7_r8,  & ! gas constant
    gravity = 9.8_r8,   & ! gravity
    cm2km = 1.e-5_r8,   & ! cm to km conversion
    rmassO1 = 16._r8,   & ! O atomic mass
!    f107 = 100._r8,    & ! solar flux
    rair = 287.0_r8,    & ! gas constant of dry air       
    kboltz = 1.38e-23_r8, & ! Boltzmann constant
    avogad = 6.02e26_r8,  & ! Avogadro's number
    mbar  = 28.9_r8,      & ! mean mass of dry air
!
! Special pi for mag field calculations. If pi=4.*atan(1.) and code is
! linked with -lmass lib, then the last 2 digits (16th and 17th) of pi
! are different (56 instead of 12), resulting in theta0(j=49)==0., which
! is wrong (should be .1110e-15).
!
    pi_dyn = 3.14159265358979312_r8, & ! pi for dynamo
    re_dyn = 6.378165e8_r8             ! earth radius (cm) for dynamo

  real(r8) :: & ! constants that are set at runtime
    pi,       & ! pi = 4.*atan(1.)
    dtr,      & ! degrees to radians
    rtd         ! radians to degrees

  integer,parameter ::  &
    iulog=6               ! log file unit (stdout)
!
  real(r8),parameter :: zbotdyn = 85._r8 ! km at which to set kbotdyn
  integer :: kbotdyn                     ! set at runtime (read_ncfile.F90)

  integer,parameter :: ztodt = 300        ! model time step for WACCM-X
! 
! Parameters for file output:
!
  integer,parameter :: max_fields = 200        ! max number of fields
  integer,parameter :: max_chars = 1024        ! max char length (e.g., long_name)
  
  real(r8),parameter :: fillvalue = 1.e36_r8 ! default fill value

  contains
!-----------------------------------------------------------------------
  subroutine set_cons
    pi = 4._r8*atan(1._r8)
    rtd = 180._r8/pi
    dtr = pi/180._r8
  end subroutine set_cons
!-----------------------------------------------------------------------
end module params
