module namelist
  use shr_kind_mod, only: r8 => shr_kind_r8            ! 8-byte reals
  use params,only: iulog,fillvalue
  implicit none
#include <mpif.h>

  integer,parameter :: max_path = 1024
  character(len=max_path) :: &
    input_ncfile  = ' ',     & ! input file path for this run
    output_ncfile = ' '        ! output netcdf file to create

  character(len=8) :: model_name = ' ' ! name of model providing input file 

  real(r8) :: & ! If provided, ctpoten will override value read from input file
    ctpoten = fillvalue 

  namelist/edynamo_input/ model_name,input_ncfile,output_ncfile,ctpoten

contains
!-----------------------------------------------------------------------
subroutine get_namelist(mytid)
!
! Args:
  integer,intent(in) :: mytid
!
! Local:
  integer :: ier

  input_ncfile  = ' '
  output_ncfile = ' '
  model_name    = ' '

  if (mytid==0) read(5, nml=edynamo_input)

  call mpi_bcast(model_name   ,8       ,MPI_CHARACTER,0,MPI_COMM_WORLD,ier)
  call mpi_bcast(input_ncfile ,max_path,MPI_CHARACTER,0,MPI_COMM_WORLD,ier)
  call mpi_bcast(output_ncfile,max_path,MPI_CHARACTER,0,MPI_COMM_WORLD,ier)
  call mpi_bcast(ctpoten      ,1,       MPI_REAL8,    0,MPI_COMM_WORLD,ier)

  if (len_trim(model_name)==0)   stop 'Need model name'
  if (len_trim(input_ncfile)==0) stop 'Need input file path'

end subroutine get_namelist
!-----------------------------------------------------------------------
end module namelist
