      module mo_lin_matrix
      use chem_mods, only: veclen
      private
      public :: linmat
      contains
      subroutine linmat01( avec_len, mat, y, rxt, het_rates )
!----------------------------------------------
! ... linear matrix entries for implicit species
!----------------------------------------------
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      use shr_kind_mod, only : r8 => shr_kind_r8
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(in) :: het_rates(veclen,gas_pcnst)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
      do k = 1,avec_len
         mat(k,536) = -( rxt(k,19) + het_rates(k,1) )
         mat(k,512) = -( rxt(k,20) + het_rates(k,2) )
         mat(k,1) = -( het_rates(k,3) )
         mat(k,2) = -( het_rates(k,4) )
         mat(k,764) = -( het_rates(k,5) )
         mat(k,82) = -( het_rates(k,6) )
         mat(k,285) = -( rxt(k,21) + het_rates(k,7) )
         mat(k,88) = -( rxt(k,22) + het_rates(k,8) )
         mat(k,291) = -( rxt(k,23) + het_rates(k,9) )
         mat(k,354) = -( rxt(k,24) + het_rates(k,10) )
         mat(k,286) = .500_r8*rxt(k,21)
         mat(k,89) = rxt(k,22)
         mat(k,523) = .200_r8*rxt(k,70)
         mat(k,564) = .060_r8*rxt(k,72)
         mat(k,191) = -( rxt(k,25) + het_rates(k,11) )
         mat(k,522) = .200_r8*rxt(k,70)
         mat(k,562) = .200_r8*rxt(k,72)
         mat(k,484) = -( rxt(k,26) + het_rates(k,12) )
         mat(k,152) = rxt(k,46)
         mat(k,873) = rxt(k,56)
         mat(k,524) = .200_r8*rxt(k,70)
         mat(k,565) = .150_r8*rxt(k,72)
         mat(k,225) = -( rxt(k,27) + het_rates(k,13) )
         mat(k,563) = .210_r8*rxt(k,72)
         mat(k,156) = -( het_rates(k,14) )
         mat(k,259) = -( het_rates(k,15) )
         mat(k,1251) = -( het_rates(k,16) )
         mat(k,163) = rxt(k,74)
         mat(k,1544) = rxt(k,75)
         mat(k,434) = rxt(k,77)
         mat(k,699) = rxt(k,99)
         mat(k,644) = rxt(k,105)
         mat(k,1373) = rxt(k,202)*y(k,33) + rxt(k,228)*y(k,34) &
                      + 3.000_r8*rxt(k,229)*y(k,54) + 2.000_r8*rxt(k,230)*y(k,77) &
                      + 2.000_r8*rxt(k,251)*y(k,40) + rxt(k,252)*y(k,42)
         mat(k,1628) = 2.000_r8*rxt(k,239)*y(k,40) + rxt(k,241)*y(k,42) &
                      + 3.000_r8*rxt(k,246)*y(k,54)
         mat(k,1520) = 2.000_r8*rxt(k,240)*y(k,40) + rxt(k,242)*y(k,42) &
                      + 3.000_r8*rxt(k,247)*y(k,54)
         mat(k,162) = -( rxt(k,74) + het_rates(k,17) )
         mat(k,1552) = -( rxt(k,75) + het_rates(k,18) )
         mat(k,437) = rxt(k,76)
         mat(k,432) = -( rxt(k,76) + rxt(k,77) + rxt(k,512) + rxt(k,515) + rxt(k,520) &
                 + het_rates(k,19) )
         mat(k,165) = -( het_rates(k,21) )
         mat(k,240) = rxt(k,28)
         mat(k,241) = -( rxt(k,28) + het_rates(k,22) )
         mat(k,200) = -( het_rates(k,23) )
         mat(k,440) = -( het_rates(k,24) )
         mat(k,173) = -( het_rates(k,25) )
         mat(k,246) = -( rxt(k,29) + het_rates(k,26) )
         mat(k,206) = -( het_rates(k,27) )
         mat(k,852) = -( het_rates(k,28) )
         mat(k,1128) = .700_r8*rxt(k,55)
         mat(k,315) = -( rxt(k,30) + het_rates(k,29) )
         mat(k,56) = -( het_rates(k,30) )
         mat(k,177) = -( rxt(k,31) + het_rates(k,31) )
         mat(k,1297) = -( rxt(k,32) + rxt(k,33) + het_rates(k,41) )
         mat(k,542) = .100_r8*rxt(k,19)
         mat(k,519) = .100_r8*rxt(k,20)
         mat(k,323) = rxt(k,38)
         mat(k,870) = rxt(k,43)
         mat(k,922) = .330_r8*rxt(k,45)
         mat(k,932) = rxt(k,47)
         mat(k,559) = .690_r8*rxt(k,49)
         mat(k,1070) = 1.340_r8*rxt(k,50)
         mat(k,738) = rxt(k,57)
         mat(k,428) = rxt(k,62)
         mat(k,306) = rxt(k,63)
         mat(k,494) = .375_r8*rxt(k,65)
         mat(k,372) = .400_r8*rxt(k,67)
         mat(k,902) = .680_r8*rxt(k,69)
         mat(k,343) = rxt(k,271)
         mat(k,183) = 2.000_r8*rxt(k,301)
         mat(k,1376) = rxt(k,274)*y(k,53) + rxt(k,275)*y(k,53)
         mat(k,888) = -( rxt(k,34) + het_rates(k,44) )
         mat(k,540) = .400_r8*rxt(k,19)
         mat(k,517) = .400_r8*rxt(k,20)
         mat(k,248) = rxt(k,29)
         mat(k,914) = .330_r8*rxt(k,45)
         mat(k,222) = rxt(k,53)
         mat(k,426) = rxt(k,62)
         mat(k,53) = -( het_rates(k,46) )
         mat(k,822) = -( rxt(k,35) + het_rates(k,47) )
         mat(k,539) = .250_r8*rxt(k,19)
         mat(k,516) = .250_r8*rxt(k,20)
         mat(k,317) = .820_r8*rxt(k,30)
         mat(k,912) = .170_r8*rxt(k,45)
         mat(k,489) = .300_r8*rxt(k,65)
         mat(k,369) = .050_r8*rxt(k,67)
         mat(k,897) = .500_r8*rxt(k,69)
         mat(k,1076) = -( rxt(k,36) + het_rates(k,48) )
         mat(k,294) = .180_r8*rxt(k,23)
         mat(k,227) = rxt(k,27)
         mat(k,532) = .400_r8*rxt(k,70)
         mat(k,573) = .540_r8*rxt(k,72)
         mat(k,330) = .510_r8*rxt(k,73)
         mat(k,448) = -( het_rates(k,49) )
         mat(k,403) = -( rxt(k,37) + het_rates(k,50) )
         mat(k,675) = -( het_rates(k,51) )
         mat(k,321) = -( rxt(k,38) + het_rates(k,52) )
         mat(k,1638) = -( rxt(k,177)*y(k,53) + rxt(k,239)*y(k,40) + rxt(k,241)*y(k,42) &
                      + rxt(k,244)*y(k,45) + rxt(k,246)*y(k,54) + het_rates(k,55) )
         mat(k,164) = rxt(k,74)
         mat(k,76) = 2.000_r8*rxt(k,91)
         mat(k,49) = 2.000_r8*rxt(k,92)
         mat(k,1329) = rxt(k,93)
         mat(k,835) = rxt(k,94)
         mat(k,100) = rxt(k,97)
         mat(k,1912) = rxt(k,103)
         mat(k,684) = rxt(k,106)
         mat(k,1383) = 4.000_r8*rxt(k,201)*y(k,32) + rxt(k,202)*y(k,33) &
                      + 2.000_r8*rxt(k,203)*y(k,35) + 2.000_r8*rxt(k,204)*y(k,36) &
                      + 2.000_r8*rxt(k,205)*y(k,37) + rxt(k,206)*y(k,38) &
                      + 2.000_r8*rxt(k,207)*y(k,39) + rxt(k,253)*y(k,81) &
                      + rxt(k,254)*y(k,82) + rxt(k,255)*y(k,83)
         mat(k,1530) = 3.000_r8*rxt(k,243)*y(k,43) + rxt(k,245)*y(k,45) &
                      + rxt(k,248)*y(k,81) + rxt(k,249)*y(k,82) + rxt(k,250)*y(k,83)
         mat(k,75) = -( rxt(k,91) + het_rates(k,56) )
         mat(k,47) = -( rxt(k,92) + rxt(k,211) + het_rates(k,57) )
         mat(k,1323) = -( rxt(k,93) + het_rates(k,58) )
         mat(k,832) = rxt(k,95)
         mat(k,233) = rxt(k,107)
         mat(k,48) = 2.000_r8*rxt(k,211)
         mat(k,830) = -( rxt(k,94) + rxt(k,95) + rxt(k,514) + rxt(k,519) + rxt(k,525) &
                 + het_rates(k,59) )
         mat(k,907) = -( het_rates(k,61) )
         mat(k,90) = 1.500_r8*rxt(k,22)
         mat(k,293) = .450_r8*rxt(k,23)
         mat(k,486) = .600_r8*rxt(k,26)
         mat(k,226) = rxt(k,27)
         mat(k,1292) = rxt(k,32) + rxt(k,33)
         mat(k,889) = rxt(k,34)
         mat(k,1075) = rxt(k,36)
         mat(k,869) = rxt(k,43)
         mat(k,743) = 2.000_r8*rxt(k,44)
         mat(k,915) = .330_r8*rxt(k,45)
         mat(k,1063) = 1.340_r8*rxt(k,51)
         mat(k,1130) = .700_r8*rxt(k,55)
         mat(k,123) = 1.500_r8*rxt(k,64)
         mat(k,492) = .250_r8*rxt(k,65)
         mat(k,842) = rxt(k,68)
         mat(k,899) = 1.700_r8*rxt(k,69)
         mat(k,254) = rxt(k,110)
         mat(k,1625) = rxt(k,244)*y(k,45)
         mat(k,60) = -( rxt(k,96) + het_rates(k,63) )
         mat(k,1367) = rxt(k,202)*y(k,33) + rxt(k,204)*y(k,36) &
                      + 2.000_r8*rxt(k,205)*y(k,37) + 2.000_r8*rxt(k,206)*y(k,38) &
                      + rxt(k,207)*y(k,39) + rxt(k,228)*y(k,34) &
                      + 2.000_r8*rxt(k,230)*y(k,77) + rxt(k,254)*y(k,82) &
                      + rxt(k,255)*y(k,83)
         mat(k,1401) = rxt(k,249)*y(k,82) + rxt(k,250)*y(k,83)
         mat(k,97) = -( rxt(k,97) + het_rates(k,64) )
         mat(k,1368) = rxt(k,203)*y(k,35) + rxt(k,204)*y(k,36) + rxt(k,253)*y(k,81)
         mat(k,1406) = rxt(k,248)*y(k,81)
         mat(k,117) = -( het_rates(k,65) )
         mat(k,194) = -( het_rates(k,66) )
         mat(k,3) = -( het_rates(k,67) )
         mat(k,4) = -( het_rates(k,68) )
         mat(k,5) = -( het_rates(k,69) )
         mat(k,6) = -( rxt(k,530) + het_rates(k,70) )
         mat(k,63) = -( rxt(k,42) + het_rates(k,71) )
         mat(k,652) = -( rxt(k,233)*y(k,53) + het_rates(k,72) )
         mat(k,61) = 2.000_r8*rxt(k,96)
         mat(k,98) = rxt(k,97)
         mat(k,149) = rxt(k,104)
         mat(k,1370) = rxt(k,206)*y(k,38) + rxt(k,228)*y(k,34)
         mat(k,868) = -( rxt(k,43) + het_rates(k,73) )
         mat(k,913) = .330_r8*rxt(k,45)
         mat(k,490) = .250_r8*rxt(k,65)
         mat(k,182) = rxt(k,302)
         mat(k,742) = -( rxt(k,44) + rxt(k,482) + het_rates(k,74) )
         mat(k,288) = rxt(k,21)
         mat(k,292) = .130_r8*rxt(k,23)
         mat(k,237) = .700_r8*rxt(k,61)
         mat(k,529) = .600_r8*rxt(k,70)
         mat(k,570) = .340_r8*rxt(k,72)
         mat(k,329) = .170_r8*rxt(k,73)
         mat(k,1277) = -( rxt(k,139) + het_rates(k,75) )
         mat(k,2007) = rxt(k,2) + 2.000_r8*rxt(k,3)
         mat(k,1296) = 2.000_r8*rxt(k,32)
         mat(k,322) = rxt(k,38)
         mat(k,700) = rxt(k,99)
         mat(k,1904) = rxt(k,103)
         mat(k,150) = rxt(k,104)
         mat(k,1375) = rxt(k,274)*y(k,53)
         mat(k,1011) = -( het_rates(k,76) )
         mat(k,2003) = rxt(k,1)
         mat(k,1293) = rxt(k,33)
         mat(k,1372) = rxt(k,275)*y(k,53)
         mat(k,468) = -( rxt(k,4) + het_rates(k,78) )
         mat(k,1833) = .500_r8*rxt(k,483)
         mat(k,66) = -( rxt(k,109) + het_rates(k,79) )
         mat(k,698) = -( rxt(k,99) + het_rates(k,80) )
         mat(k,1917) = -( rxt(k,103) + het_rates(k,84) )
         mat(k,1643) = rxt(k,177)*y(k,53) + rxt(k,239)*y(k,40) + rxt(k,241)*y(k,42) &
                      + 2.000_r8*rxt(k,244)*y(k,45) + rxt(k,246)*y(k,54)
         mat(k,101) = -( het_rates(k,85) )
         mat(k,660) = -( het_rates(k,86) )
         mat(k,148) = -( rxt(k,104) + het_rates(k,87) )
         mat(k,651) = rxt(k,233)*y(k,53)
      end do
      end subroutine linmat01
      subroutine linmat02( avec_len, mat, y, rxt, het_rates )
!----------------------------------------------
! ... linear matrix entries for implicit species
!----------------------------------------------
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      use shr_kind_mod, only : r8 => shr_kind_r8
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(in) :: het_rates(veclen,gas_pcnst)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
      do k = 1,avec_len
         mat(k,1264) = -( rxt(k,9) + het_rates(k,88) )
         mat(k,920) = rxt(k,484)
         mat(k,479) = rxt(k,485)
         mat(k,421) = rxt(k,486)
         mat(k,186) = 2.000_r8*rxt(k,487) + 2.000_r8*rxt(k,510) + 2.000_r8*rxt(k,513) &
                      + 2.000_r8*rxt(k,524)
         mat(k,282) = rxt(k,488)
         mat(k,881) = rxt(k,489)
         mat(k,1727) = .500_r8*rxt(k,491)
         mat(k,1686) = rxt(k,492)
         mat(k,300) = rxt(k,493)
         mat(k,160) = rxt(k,494)
         mat(k,499) = rxt(k,495)
         mat(k,435) = rxt(k,512) + rxt(k,515) + rxt(k,520)
         mat(k,831) = rxt(k,514) + rxt(k,519) + rxt(k,525)
         mat(k,273) = -( rxt(k,10) + rxt(k,11) + rxt(k,174) + het_rates(k,89) )
         mat(k,643) = -( rxt(k,105) + het_rates(k,90) )
         mat(k,433) = rxt(k,512) + rxt(k,515) + rxt(k,520)
         mat(k,680) = -( rxt(k,106) + het_rates(k,91) )
         mat(k,829) = rxt(k,514) + rxt(k,519) + rxt(k,525)
         mat(k,916) = -( rxt(k,45) + rxt(k,484) + het_rates(k,92) )
         mat(k,151) = -( rxt(k,46) + het_rates(k,93) )
         mat(k,1168) = rxt(k,375)
         mat(k,929) = -( rxt(k,47) + het_rates(k,94) )
         mat(k,917) = .170_r8*rxt(k,45)
         mat(k,212) = -( het_rates(k,95) )
         mat(k,69) = -( het_rates(k,96) )
         mat(k,719) = -( het_rates(k,97) )
         mat(k,475) = -( rxt(k,485) + het_rates(k,98) )
         mat(k,416) = -( rxt(k,486) + het_rates(k,99) )
         mat(k,1048) = -( het_rates(k,100) )
         mat(k,309) = -( rxt(k,48) + het_rates(k,101) )
         mat(k,555) = -( rxt(k,49) + het_rates(k,102) )
         mat(k,310) = rxt(k,48)
         mat(k,40) = -( het_rates(k,103) )
         mat(k,1064) = -( rxt(k,50) + rxt(k,51) + het_rates(k,104) )
         mat(k,557) = .288_r8*rxt(k,49)
         mat(k,215) = -( het_rates(k,105) )
         mat(k,398) = -( rxt(k,52) + het_rates(k,106) )
         mat(k,535) = .800_r8*rxt(k,19)
         mat(k,511) = .800_r8*rxt(k,20)
         mat(k,220) = -( rxt(k,53) + het_rates(k,107) )
         mat(k,460) = -( rxt(k,54) + rxt(k,357) + het_rates(k,108) )
         mat(k,790) = -( het_rates(k,109) )
         mat(k,1133) = -( rxt(k,55) + het_rates(k,110) )
         mat(k,558) = .402_r8*rxt(k,49)
         mat(k,267) = -( rxt(k,156) + het_rates(k,111) )
         mat(k,1926) = rxt(k,15)
         mat(k,185) = -( rxt(k,13) + rxt(k,14) + rxt(k,175) + rxt(k,487) + rxt(k,510) &
                      + rxt(k,513) + rxt(k,524) + het_rates(k,113) )
         mat(k,279) = -( rxt(k,488) + het_rates(k,114) )
         mat(k,877) = -( rxt(k,56) + rxt(k,489) + het_rates(k,115) )
         mat(k,7) = -( het_rates(k,116) )
         mat(k,8) = -( het_rates(k,117) )
         mat(k,9) = -( het_rates(k,118) )
         mat(k,50) = -( het_rates(k,119) )
         mat(k,10) = -( rxt(k,490) + het_rates(k,120) )
         mat(k,1996) = -( rxt(k,15) + het_rates(k,121) )
         mat(k,190) = rxt(k,14)
         mat(k,1742) = rxt(k,16) + .500_r8*rxt(k,491)
         mat(k,1701) = rxt(k,17)
         mat(k,272) = rxt(k,156)
         mat(k,1389) = 2.000_r8*rxt(k,168)*y(k,112)
         mat(k,1738) = -( rxt(k,16) + rxt(k,491) + het_rates(k,122) )
         mat(k,1272) = rxt(k,9)
         mat(k,276) = rxt(k,11) + rxt(k,174)
         mat(k,189) = rxt(k,13) + rxt(k,175)
         mat(k,1697) = rxt(k,18)
         mat(k,544) = rxt(k,19)
         mat(k,926) = rxt(k,45)
         mat(k,313) = rxt(k,48)
         mat(k,466) = rxt(k,54) + rxt(k,357)
         mat(k,885) = rxt(k,56)
         mat(k,740) = rxt(k,57)
         mat(k,302) = rxt(k,58)
         mat(k,161) = rxt(k,59)
         mat(k,363) = .600_r8*rxt(k,60) + rxt(k,308)
         mat(k,501) = rxt(k,66)
         mat(k,439) = rxt(k,76)
         mat(k,837) = rxt(k,95)
         mat(k,74) = rxt(k,432)
         mat(k,1696) = -( rxt(k,17) + rxt(k,18) + rxt(k,492) + het_rates(k,123) )
         mat(k,275) = rxt(k,10)
         mat(k,188) = rxt(k,13) + rxt(k,14) + rxt(k,175)
         mat(k,362) = .400_r8*rxt(k,60)
         mat(k,438) = rxt(k,77)
         mat(k,836) = rxt(k,94)
         mat(k,735) = -( rxt(k,57) + het_rates(k,124) )
         mat(k,297) = -( rxt(k,58) + rxt(k,493) + het_rates(k,125) )
         mat(k,11) = -( het_rates(k,126) )
         mat(k,12) = -( het_rates(k,127) )
         mat(k,13) = -( het_rates(k,128) )
         mat(k,14) = -( het_rates(k,129) )
         mat(k,1354) = -( rxt(k,133) + het_rates(k,130) )
         mat(k,2010) = rxt(k,3)
         mat(k,1791) = rxt(k,8)
         mat(k,187) = rxt(k,14)
         mat(k,1985) = rxt(k,15)
         mat(k,1731) = rxt(k,16)
         mat(k,1690) = rxt(k,18)
         mat(k,1549) = rxt(k,75)
         mat(k,1324) = rxt(k,93)
         mat(k,234) = rxt(k,107)
         mat(k,1091) = rxt(k,111) + rxt(k,472)
         mat(k,709) = rxt(k,112)
         mat(k,171) = rxt(k,113)
         mat(k,1378) = rxt(k,128) + rxt(k,129)
         mat(k,269) = rxt(k,156)
         mat(k,395) = rxt(k,466)
         mat(k,1799) = -( rxt(k,7) + rxt(k,8) + het_rates(k,131) )
         mat(k,1362) = rxt(k,133)
         mat(k,230) = -( rxt(k,107) + het_rates(k,133) )
         mat(k,251) = -( rxt(k,110) + het_rates(k,134) )
         mat(k,159) = -( rxt(k,59) + rxt(k,494) + het_rates(k,135) )
         mat(k,357) = -( rxt(k,60) + rxt(k,308) + het_rates(k,136) )
         mat(k,72) = -( rxt(k,432) + het_rates(k,137) )
         mat(k,364) = -( het_rates(k,138) )
         mat(k,178) = rxt(k,31)
         mat(k,92) = -( het_rates(k,139) )
         mat(k,235) = -( rxt(k,61) + het_rates(k,140) )
         mat(k,15) = -( het_rates(k,141) )
         mat(k,16) = -( het_rates(k,142) )
         mat(k,424) = -( rxt(k,62) + het_rates(k,143) )
         mat(k,303) = -( rxt(k,63) + het_rates(k,144) )
         mat(k,392) = -( rxt(k,466) + het_rates(k,145) )
         mat(k,252) = rxt(k,110)
         mat(k,1085) = rxt(k,111)
         mat(k,1087) = -( rxt(k,111) + rxt(k,472) + het_rates(k,147) )
         mat(k,708) = rxt(k,112)
         mat(k,393) = rxt(k,466)
         mat(k,707) = -( rxt(k,112) + het_rates(k,148) )
         mat(k,170) = rxt(k,113)
         mat(k,1086) = rxt(k,472)
         mat(k,169) = -( rxt(k,113) + het_rates(k,149) )
         mat(k,67) = rxt(k,109)
         mat(k,17) = -( het_rates(k,150) )
         mat(k,18) = -( het_rates(k,151) )
         mat(k,19) = -( het_rates(k,152) )
         mat(k,20) = -( rxt(k,116) + het_rates(k,153) )
         mat(k,21) = -( rxt(k,117) + het_rates(k,154) )
         mat(k,22) = -( rxt(k,118) + het_rates(k,155) )
         mat(k,23) = -( rxt(k,119) + het_rates(k,156) )
         mat(k,24) = -( rxt(k,120) + het_rates(k,157) )
         mat(k,25) = -( rxt(k,121) + het_rates(k,158) )
         mat(k,26) = -( rxt(k,122) + het_rates(k,159) )
         mat(k,27) = -( rxt(k,123) + het_rates(k,160) )
         mat(k,28) = -( rxt(k,124) + het_rates(k,161) )
         mat(k,29) = -( rxt(k,125) + het_rates(k,162) )
         mat(k,30) = -( het_rates(k,163) )
         mat(k,741) = rxt(k,482)
         mat(k,31) = -( het_rates(k,164) )
         mat(k,32) = -( het_rates(k,165) )
         mat(k,33) = -( het_rates(k,166) )
         mat(k,34) = -( het_rates(k,167) )
         mat(k,46) = -( het_rates(k,168) )
         mat(k,122) = -( rxt(k,64) + het_rates(k,169) )
         mat(k,488) = -( rxt(k,65) + het_rates(k,170) )
         mat(k,497) = -( rxt(k,66) + rxt(k,495) + het_rates(k,171) )
         mat(k,368) = -( rxt(k,67) + het_rates(k,172) )
         mat(k,840) = -( rxt(k,68) + het_rates(k,173) )
         mat(k,298) = rxt(k,58)
         mat(k,498) = rxt(k,66)
         mat(k,370) = rxt(k,67)
         mat(k,898) = -( rxt(k,69) + het_rates(k,174) )
         mat(k,491) = rxt(k,65)
         mat(k,841) = rxt(k,68)
         mat(k,525) = -( rxt(k,70) + het_rates(k,175) )
         mat(k,110) = -( het_rates(k,176) )
         mat(k,126) = -( rxt(k,71) + het_rates(k,177) )
         mat(k,135) = -( het_rates(k,178) )
         mat(k,566) = -( rxt(k,72) + het_rates(k,179) )
         mat(k,143) = -( het_rates(k,180) )
         mat(k,327) = -( rxt(k,73) + het_rates(k,181) )
         mat(k,410) = -( het_rates(k,184) )
         mat(k,73) = rxt(k,432)
         mat(k,812) = -( het_rates(k,185) )
         mat(k,377) = -( het_rates(k,186) )
         mat(k,335) = -( het_rates(k,187) )
         mat(k,690) = -( het_rates(k,188) )
         mat(k,400) = rxt(k,52)
         mat(k,665) = -( het_rates(k,189) )
         mat(k,505) = -( het_rates(k,190) )
         mat(k,1237) = -( het_rates(k,191) )
         mat(k,295) = .130_r8*rxt(k,23)
         mat(k,228) = rxt(k,27)
         mat(k,824) = rxt(k,35)
         mat(k,1077) = rxt(k,36)
         mat(k,919) = .330_r8*rxt(k,45)
         mat(k,931) = rxt(k,47)
         mat(k,1068) = 1.340_r8*rxt(k,50)
         mat(k,401) = rxt(k,52)
         mat(k,223) = rxt(k,53)
         mat(k,1135) = .300_r8*rxt(k,55)
         mat(k,737) = rxt(k,57)
         mat(k,358) = .600_r8*rxt(k,60) + rxt(k,308)
         mat(k,305) = rxt(k,63)
         mat(k,124) = .500_r8*rxt(k,64)
         mat(k,901) = .650_r8*rxt(k,69)
         mat(k,1603) = -( het_rates(k,192) )
         mat(k,893) = rxt(k,34)
         mat(k,826) = rxt(k,35)
         mat(k,407) = rxt(k,37)
         mat(k,1140) = .300_r8*rxt(k,55)
         mat(k,361) = .400_r8*rxt(k,60)
         mat(k,1637) = rxt(k,177)*y(k,53)
         mat(k,657) = rxt(k,233)*y(k,53)
         mat(k,1529) = rxt(k,266)*y(k,53)
         mat(k,1382) = rxt(k,273)*y(k,53)
      end do
      end subroutine linmat02
      subroutine linmat03( avec_len, mat, y, rxt, het_rates )
!----------------------------------------------
! ... linear matrix entries for implicit species
!----------------------------------------------
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      use shr_kind_mod, only : r8 => shr_kind_r8
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(in) :: het_rates(veclen,gas_pcnst)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
      integer :: k
      do k = 1,avec_len
         mat(k,624) = -( het_rates(k,193) )
         mat(k,192) = .600_r8*rxt(k,25)
         mat(k,452) = -( het_rates(k,194) )
         mat(k,181) = -( rxt(k,301) + rxt(k,302) + het_rates(k,195) )
         mat(k,64) = rxt(k,42)
         mat(k,579) = -( het_rates(k,196) )
         mat(k,1893) = -( rxt(k,483) + het_rates(k,197) )
         mat(k,277) = rxt(k,11) + rxt(k,174)
         mat(k,545) = rxt(k,19)
         mat(k,521) = .900_r8*rxt(k,20)
         mat(k,290) = rxt(k,21)
         mat(k,91) = 1.500_r8*rxt(k,22)
         mat(k,296) = .560_r8*rxt(k,23)
         mat(k,356) = rxt(k,24)
         mat(k,193) = .600_r8*rxt(k,25)
         mat(k,487) = .600_r8*rxt(k,26)
         mat(k,229) = rxt(k,27)
         mat(k,245) = rxt(k,28)
         mat(k,250) = rxt(k,29)
         mat(k,319) = rxt(k,30)
         mat(k,895) = rxt(k,34)
         mat(k,1082) = rxt(k,36)
         mat(k,872) = 2.000_r8*rxt(k,43)
         mat(k,745) = 2.000_r8*rxt(k,44)
         mat(k,927) = .670_r8*rxt(k,45)
         mat(k,155) = rxt(k,46)
         mat(k,934) = rxt(k,47)
         mat(k,314) = rxt(k,48)
         mat(k,561) = rxt(k,49)
         mat(k,1073) = 1.340_r8*rxt(k,50) + .660_r8*rxt(k,51)
         mat(k,886) = rxt(k,56)
         mat(k,239) = rxt(k,61)
         mat(k,430) = rxt(k,62)
         mat(k,125) = rxt(k,64)
         mat(k,496) = rxt(k,65)
         mat(k,502) = rxt(k,66)
         mat(k,374) = rxt(k,67)
         mat(k,847) = rxt(k,68)
         mat(k,905) = 1.200_r8*rxt(k,69)
         mat(k,534) = rxt(k,70)
         mat(k,576) = rxt(k,72)
         mat(k,332) = rxt(k,73)
         mat(k,1286) = rxt(k,139)
         mat(k,345) = rxt(k,271)
         mat(k,184) = rxt(k,301) + rxt(k,302)
         mat(k,1198) = rxt(k,375)
         mat(k,1642) = rxt(k,241)*y(k,42) + rxt(k,244)*y(k,45)
         mat(k,1534) = rxt(k,242)*y(k,42) + rxt(k,245)*y(k,45)
         mat(k,1387) = rxt(k,274)*y(k,53)
         mat(k,341) = -( rxt(k,271) + het_rates(k,198) )
         mat(k,1111) = -( het_rates(k,199) )
         mat(k,1187) = -( rxt(k,375) + het_rates(k,200) )
         mat(k,1155) = -( het_rates(k,201) )
         mat(k,586) = -( het_rates(k,202) )
         mat(k,355) = .600_r8*rxt(k,24)
         mat(k,1206) = -( het_rates(k,203) )
         mat(k,1067) = .660_r8*rxt(k,50)
         mat(k,462) = rxt(k,54) + rxt(k,357)
         mat(k,747) = -( het_rates(k,204) )
         mat(k,485) = .600_r8*rxt(k,26)
         mat(k,547) = -( het_rates(k,205) )
         mat(k,983) = -( het_rates(k,206) )
         mat(k,1379) = -( rxt(k,128) + rxt(k,129) + rxt(k,168)*y(k,112) &
                      + rxt(k,169)*y(k,112) + rxt(k,201)*y(k,32) + rxt(k,202)*y(k,33) &
                      + rxt(k,203)*y(k,35) + rxt(k,204)*y(k,36) + rxt(k,205)*y(k,37) &
                      + rxt(k,206)*y(k,38) + rxt(k,207)*y(k,39) + rxt(k,228)*y(k,34) &
                      + rxt(k,229)*y(k,54) + rxt(k,230)*y(k,77) + rxt(k,251)*y(k,40) &
                      + rxt(k,252)*y(k,42) + rxt(k,253)*y(k,81) + rxt(k,254)*y(k,82) &
                      + rxt(k,255)*y(k,83) + rxt(k,273)*y(k,53) + rxt(k,274)*y(k,53) &
                      + rxt(k,275)*y(k,53) + het_rates(k,207) )
         mat(k,2011) = rxt(k,1)
         mat(k,1792) = rxt(k,7)
         mat(k,1527) = -( rxt(k,240)*y(k,40) + rxt(k,242)*y(k,42) + rxt(k,243)*y(k,43) &
                      + rxt(k,245)*y(k,45) + rxt(k,247)*y(k,54) + rxt(k,248)*y(k,81) &
                      + rxt(k,249)*y(k,82) + rxt(k,250)*y(k,83) + rxt(k,266)*y(k,53) &
                 + het_rates(k,208) )
         mat(k,2012) = rxt(k,2)
         mat(k,470) = 2.000_r8*rxt(k,4)
         mat(k,1268) = rxt(k,9)
         mat(k,274) = rxt(k,10)
         mat(k,520) = rxt(k,20)
         mat(k,289) = rxt(k,21)
         mat(k,244) = rxt(k,28)
         mat(k,249) = rxt(k,29)
         mat(k,318) = rxt(k,30)
         mat(k,180) = rxt(k,31)
         mat(k,406) = rxt(k,37)
         mat(k,324) = rxt(k,38)
         mat(k,65) = rxt(k,42)
         mat(k,154) = rxt(k,46)
         mat(k,224) = rxt(k,53)
         mat(k,301) = rxt(k,58)
         mat(k,238) = rxt(k,61)
         mat(k,429) = rxt(k,62)
         mat(k,307) = rxt(k,63)
         mat(k,495) = rxt(k,65)
         mat(k,373) = rxt(k,67)
         mat(k,533) = rxt(k,70)
         mat(k,128) = rxt(k,71)
         mat(k,575) = rxt(k,72)
         mat(k,331) = rxt(k,73)
         mat(k,646) = rxt(k,105)
         mat(k,683) = rxt(k,106)
         mat(k,1733) = .500_r8*rxt(k,491)
         mat(k,1380) = rxt(k,273)*y(k,53)
         mat(k,348) = -( het_rates(k,209) )
         mat(k,633) = -( het_rates(k,210) )
         mat(k,999) = -( het_rates(k,211) )
         mat(k,900) = .150_r8*rxt(k,69)
         mat(k,964) = -( het_rates(k,212) )
         mat(k,942) = -( het_rates(k,213) )
         mat(k,597) = -( het_rates(k,214) )
         mat(k,1028) = -( het_rates(k,215) )
         mat(k,613) = -( het_rates(k,216) )
         mat(k,385) = -( het_rates(k,217) )
         mat(k,2022) = -( rxt(k,1) + rxt(k,2) + rxt(k,3) + het_rates(k,218) )
         mat(k,68) = rxt(k,109)
         mat(k,1537) = rxt(k,240)*y(k,40) + rxt(k,242)*y(k,42) + rxt(k,243)*y(k,43) &
                      + rxt(k,245)*y(k,45) + rxt(k,250)*y(k,83) + rxt(k,266)*y(k,53)
      end do
      end subroutine linmat03
      subroutine linmat( avec_len, mat, y, rxt, het_rates )
!----------------------------------------------
! ... linear matrix entries for implicit species
!----------------------------------------------
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      use shr_kind_mod, only : r8 => shr_kind_r8
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      integer, intent(in) :: avec_len
      real(r8), intent(in) :: y(veclen,gas_pcnst)
      real(r8), intent(in) :: rxt(veclen,rxntot)
      real(r8), intent(in) :: het_rates(veclen,gas_pcnst)
      real(r8), intent(inout) :: mat(veclen,nzcnt)
      call linmat01( avec_len, mat, y, rxt, het_rates )
      call linmat02( avec_len, mat, y, rxt, het_rates )
      call linmat03( avec_len, mat, y, rxt, het_rates )
      end subroutine linmat
      end module mo_lin_matrix
