
############
# This script compiles directly on the cheyenne login node and may be run in the background
############

chey_comp=true

if [ -z "" ]; then
    export CAM_RBOPTIONS="build_only"
fi

## create_newcase looks for account number in ACCOUNT environment variable
export ACCOUNT=P28100036

##omp threads
export CAM_THREADS=2
export CAM_RESTART_THREADS=1

##mpi tasks
export CAM_TASKS=32
export CAM_RESTART_TASKS=64

# This is a floor preventing the use of 32 MPI tasks per node, which is
# frequently broken, but allowing 32 threads.
export min_cpus_per_task=1

module purge

if [ "$CAM_FC" = "PGI" ]; then
  module load ncarenv/1.0
  module load ncarbinlibs/1.0
  module load pgi/12.5
  module load ncarcompilers
  module load netcdf/4.2
  module load pnetcdf/1.3.0
  module load perlmods
  module load python
  export CFG_STRING=" -cc mpicc -fc_type pgi -fc mpif90 -cppdefs -DNO_MPI2 -cppdefs -DNO_MPIMOD "
else
  module load ncarenv/1.0
  module load intel/16.0.3
  module load mkl/11.3.3
  module load mpt/2.15
  module load ncarcompilers/0.3.5
  module load netcdf-mpi/4.4.1.1
  module load pnetcdf/1.8.0
  module load python
  export CFG_STRING="-cc mpicc -fc mpif90 -fc_type intel "
fi

export MAKE_CMD="gmake -j 8"
export CCSM_MACH="cheyenne"
export MACH_WORKSPACE="/glade/scratch"
export CPRNC_EXE=/glade/p/cesmdata/cseg/tools/cime/tools/cprnc/cprnc.cheyenne
export ADDREALKIND_EXE=/fs/cgd/csm/tools/addrealkind/addrealkind
dataroot=/glade/p/cesmdata/cseg
echo_arg="-e"
input_file="tests_pretag_cheyenne"


## Most machines don't need to set this, so default to 1.
if [[ -z "$min_cpus_per_task" ]]; then
    export min_cpus_per_task=1
fi

##check if interactive job
if  $interactive ; then

    echo "test_driver.sh: interactive run - setting JOBID to $$"
    export JOBID=$$
    if [ $0 = "test_driver.sh" ]; then
	initdir="."
    else
	initdir=${0%/*}
    fi
fi

##establish script dir and cam_root
if [ -f ${initdir}/test_driver.sh ]; then
    export CAM_SCRIPTDIR=`cd ${initdir}; pwd `
    export CAM_ROOT=`cd ${CAM_SCRIPTDIR}/../../../.. ; pwd `
else
    if [ -n "${CAM_ROOT}" ] && [ -f ${CAM_ROOT}/components/cam/test/system/test_driver.sh ]; then
	export CAM_SCRIPTDIR=`cd ${CAM_ROOT}/components/cam/test/system; pwd `
    else
	echo "ERROR: unable to determine script directory "
	echo "       if initiating batch job from directory other than the one containing test_driver.sh, "
	echo "       you must set the environment variable CAM_ROOT to the full path of directory containing "
        echo "       <components>. "
	exit 3
    fi
fi

##output files
cam_log=${initdir}/td.${JOBID}.log
if [ -f $cam_log ]; then
    rm $cam_log
fi
cam_status=${initdir}/td.${JOBID}.status
if [ -f $cam_status ]; then
    rm $cam_status
fi

##setup test work directory
if [ -z "$CAM_TESTDIR" ]; then
    export CAM_TESTDIR=/glade/scratch/$LOGNAME/test-driver.${JOBID}
    if [ -d $CAM_TESTDIR ]; then
        rm -rf $CAM_TESTDIR
    fi
fi
if [ ! -d $CAM_TESTDIR ]; then
    mkdir -p $CAM_TESTDIR
    if [ $? -ne 0 ]; then
	echo "ERROR: unable to create work directory $CAM_TESTDIR"
	exit 4
    fi
fi

##set our own environment vars
export CSMDATA=${dataroot}/inputdata
export MPI_TYPE_MAX=100000

##process other env vars possibly coming in
if [ -z "$CAM_RETAIN_FILES" ]; then
    export CAM_RETAIN_FILES=FALSE
fi
if [ -n "${CAM_INPUT_TESTS}" ]; then
    input_file=$CAM_INPUT_TESTS
else
    input_file=${CAM_SCRIPTDIR}/${input_file}
fi

if [ ! -f ${input_file} ]; then
    echo "ERROR: unable to locate input file ${input_file}"
    exit 5
fi

if  $interactive && ! $chey_comp ; then
    echo "reading tests from ${input_file}"
else
    echo "reading tests from ${input_file}" >> ${cam_log}
fi

num_tests=`wc -w < ${input_file}`
echo "STATUS OF CAM TESTING UNDER JOB ${JOBID};  scheduled to run $num_tests tests from:" >> ${cam_status}
echo "$input_file" >> ${cam_status}
echo "" >> ${cam_status}
if  $interactive && ! $chey_comp ; then
    echo "see ${cam_log} for more detailed output" >> ${cam_status}
fi
echo "" >> ${cam_status}

test_list=""
while read input_line; do
    test_list="${test_list}${input_line} "
done < ${input_file}

##initialize flags, counter
skipped_tests="NO"
pending_tests="NO"
count=0

##loop through the tests of input file
for test_id in ${test_list}; do
    count=`expr $count + 1`
    while [ ${#count} -lt 3 ]; do
        count="0${count}"
    done

    master_line=`grep $test_id ${CAM_SCRIPTDIR}/input_tests_master`
    status_out=""
    for arg in ${master_line}; do
        status_out="${status_out}${arg} "
    done


    test_cmd=${status_out#* }

    status_out="${count} ${status_out}"

    if  $interactive && ! $chey_comp ; then
        echo ""
        echo "************************************************************"
        echo "${status_out}"
        echo "************************************************************"
    else
        echo "" >> ${cam_log}
        echo "************************************************************"            >> ${cam_log}
        echo "$status_out" >> ${cam_log}
        echo "************************************************************"            >> ${cam_log}
    fi

#    if [ ${#status_out} -gt 64 ]; then
#        status_out=`echo "${status_out}" | cut -c1-70`
#    fi
    while [ ${#status_out} -lt 95 ]; do
        status_out="${status_out}."
    done

    echo $echo_arg "$status_out\c" >> ${cam_status}



    if  $interactive && ! $chey_comp ; then
        ${CAM_SCRIPTDIR}/${test_cmd} $CAM_RBOPTIONS
        rc=$?
    else
        ${CAM_SCRIPTDIR}/${test_cmd} $CAM_RBOPTIONS >> ${cam_log} 2>&1
        rc=$?
    fi
    if [ $rc -eq 0 ]; then
        if [ ${CAM_RBOPTIONS} = "build_only" ]; then
          echo "BUILT at $(date)" >> ${cam_status}
        else
          echo "PASS at $(date)" >> ${cam_status}
        fi
    elif [ $rc -eq 255 ]; then
        echo "SKIPPED* at $(date)" >> ${cam_status}
        skipped_tests="YES"
    elif [ $rc -eq 254 ]; then
        echo "PENDING** at $(date)" >> ${cam_status}
        pending_tests="YES"
    else
        echo "FAIL! rc= $rc at $(date)" >> ${cam_status}
        if  $interactive && ! $chey_comp ; then
	    if [ "$CAM_SOFF" != "FALSE" ]; then
		echo "stopping on first failure"
		echo "stopping on first failure" >> ${cam_status}
		exit 6
	    fi
	else
	    if [ "$CAM_SOFF" == "TRUE" ]; then
		echo "stopping on first failure" >> ${cam_status}
		echo "stopping on first failure" >> ${cam_log}
		exit 6
	    fi
	fi
    fi
done


echo "end of input" >> ${cam_status}
if  $interactive && ! $chey_comp ; then
    echo "end of input"
else
    echo "end of input" >> ${cam_log}
fi

if [ "$skipped_tests" = "YES" ]; then
    echo "*  please verify that any skipped tests are not required of your cam commit" >> ${cam_status}
fi
if [ "$pending_tests" = "YES" ]; then
    echo "** tests that are pending must be checked manually for a successful completion" >> ${cam_status}
    if  $interactive && ! $chey_comp ; then
	echo "   see the test's output in ${cam_log} " >> ${cam_status}
	echo "   for the location of test results" >> ${cam_status}
    fi
fi
echo "qsub < /glade/p/work/joemci/CESM/cam5_4_137/components/cam/test/system/test_driver_cheyenne124237.sh" >> ${cam_log}
qsub < /glade/p/work/joemci/CESM/cam5_4_137/components/cam/test/system/test_driver_cheyenne124237.sh >> ${cam_log} 2>&1
exit 0
