




      module mo_nln_matrix

      use shr_kind_mod, only : r8 => shr_kind_r8

      private
      public :: nlnmat

      contains

      subroutine nlnmat01( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(833) = -(rxt(85)*y(2) + rxt(92)*y(3) + rxt(117)*y(19) + rxt(122)*y(20) &
                      + rxt(130)*y(21) + rxt(142)*y(6) + rxt(145)*y(7) + rxt(157) &
                      *y(25) + rxt(184)*y(34) + rxt(237)*y(41) + rxt(258)*y(56) &
                      + rxt(280)*y(74) + rxt(286)*y(75) + rxt(304)*y(80) + rxt(342) &
                      *y(102))
         mat(1168) = -rxt(85)*y(1)
         mat(917) = -rxt(92)*y(1)
         mat(725) = -rxt(117)*y(1)
         mat(1263) = -rxt(122)*y(1)
         mat(1123) = -rxt(130)*y(1)
         mat(970) = -rxt(142)*y(1)
         mat(1031) = -rxt(145)*y(1)
         mat(997) = -rxt(157)*y(1)
         mat(774) = -rxt(184)*y(1)
         mat(161) = -rxt(237)*y(1)
         mat(507) = -rxt(258)*y(1)
         mat(621) = -rxt(280)*y(1)
         mat(578) = -rxt(286)*y(1)
         mat(450) = -rxt(304)*y(1)
         mat(322) = -rxt(342)*y(1)

         mat(833) = mat(833) + .100_r8*rxt(304)*y(80) + .200_r8*rxt(280)*y(74) &
                      + .200_r8*rxt(286)*y(75)
         mat(1123) = mat(1123) + .250_r8*rxt(248)*y(45) + .250_r8*rxt(296)*y(73)
         mat(450) = mat(450) + .100_r8*rxt(304)*y(1)
         mat(707) = .250_r8*rxt(248)*y(21)
         mat(621) = mat(621) + .200_r8*rxt(280)*y(1)
         mat(578) = mat(578) + .200_r8*rxt(286)*y(1)
         mat(681) = .250_r8*rxt(296)*y(21)

         mat(1178) = -(rxt(85)*y(1) + 4._r8*rxt(86)*y(2) + rxt(121)*y(20) + rxt(128) &
                      *y(18) + rxt(129)*y(21) + rxt(132)*y(22) + rxt(140)*y(6) &
                      + (rxt(143) + rxt(144)) * y(7) + rxt(151)*y(8) + rxt(164)*y(27) &
                      + rxt(177)*y(30) + rxt(178)*y(31) + rxt(181)*y(32) + rxt(187) &
                      *y(35) + rxt(197)*y(36) + rxt(198)*y(37) + rxt(199)*y(38) &
                      + rxt(217)*y(16))
         mat(843) = -rxt(85)*y(2)
         mat(1273) = -rxt(121)*y(2)
         mat(534) = -rxt(128)*y(2)
         mat(1133) = -rxt(129)*y(2)
         mat(332) = -rxt(132)*y(2)
         mat(980) = -rxt(140)*y(2)
         mat(1041) = -(rxt(143) + rxt(144)) * y(2)
         mat(885) = -rxt(151)*y(2)
         mat(804) = -rxt(164)*y(2)
         mat(907) = -rxt(177)*y(2)
         mat(461) = -rxt(178)*y(2)
         mat(473) = -rxt(181)*y(2)
         mat(1062) = -rxt(187)*y(2)
         mat(413) = -rxt(197)*y(2)
         mat(406) = -rxt(198)*y(2)
         mat(304) = -rxt(199)*y(2)
         mat(1153) = -rxt(217)*y(2)

         mat(97) = rxt(136)*y(6) + rxt(137)*y(7)
         mat(980) = mat(980) + rxt(136)*y(5)
         mat(1041) = mat(1041) + rxt(137)*y(5)
         mat(1273) = mat(1273) + 2.000_r8*rxt(124)*y(20)
         mat(730) = rxt(120)*y(21)
         mat(1133) = mat(1133) + rxt(120)*y(19)

         mat(920) = -(rxt(89)*y(124) + rxt(92)*y(1) + rxt(112)*y(18) + rxt(113)*y(30) &
                      + rxt(114)*y(36) + rxt(115)*y(39))
         mat(718) = -rxt(89)*y(3)
         mat(836) = -rxt(92)*y(3)
         mat(532) = -rxt(112)*y(3)
         mat(900) = -rxt(113)*y(3)
         mat(412) = -rxt(114)*y(3)
         mat(99) = -rxt(115)*y(3)

         mat(528) = -(rxt(112)*y(3) + rxt(126)*y(20) + rxt(128)*y(2) + rxt(158)*y(25))
         mat(911) = -rxt(112)*y(18)
         mat(1245) = -rxt(126)*y(18)
         mat(1162) = -rxt(128)*y(18)
         mat(988) = -rxt(158)*y(18)

         mat(722) = rxt(119)*y(21)
         mat(1105) = rxt(119)*y(19)

         mat(536) = -((rxt(213) + rxt(214)) * y(20))
         mat(1246) = -(rxt(213) + rxt(214)) * y(17)

         mat(816) = .560_r8*rxt(258)*y(56) + .300_r8*rxt(304)*y(80) + .500_r8*rxt(237) &
                      *y(41) + .050_r8*rxt(280)*y(74) + .200_r8*rxt(286)*y(75)
         mat(1163) = rxt(217)*y(16)
         mat(953) = .220_r8*rxt(287)*y(76) + .500_r8*rxt(322)*y(88)
         mat(1246) = mat(1246) + rxt(216)*y(16) + rxt(253)*y(50) + rxt(274)*y(65) &
                      + .350_r8*rxt(230)*y(125)
         mat(859) = rxt(215)*y(16) + .220_r8*rxt(289)*y(76) + rxt(275)*y(65) &
                      + .500_r8*rxt(323)*y(88)
         mat(742) = .110_r8*rxt(291)*y(76) + .200_r8*rxt(325)*y(88)
         mat(1139) = rxt(217)*y(2) + rxt(216)*y(20) + rxt(215)*y(8) + rxt(162)*y(25) &
                      + rxt(186)*y(34)
         mat(989) = rxt(162)*y(16)
         mat(770) = rxt(186)*y(16)
         mat(501) = .560_r8*rxt(258)*y(1)
         mat(443) = .300_r8*rxt(304)*y(1)
         mat(694) = .220_r8*rxt(292)*y(76) + .500_r8*rxt(326)*y(88)
         mat(160) = .500_r8*rxt(237)*y(1)
         mat(354) = rxt(253)*y(20)
         mat(611) = .050_r8*rxt(280)*y(1)
         mat(570) = .200_r8*rxt(286)*y(1)
         mat(632) = .220_r8*rxt(287)*y(6) + .220_r8*rxt(289)*y(8) + .110_r8*rxt(291) &
                      *y(13) + .220_r8*rxt(292)*y(45)
         mat(583) = rxt(274)*y(20) + rxt(275)*y(8)
         mat(596) = .500_r8*rxt(322)*y(6) + .500_r8*rxt(323)*y(8) + .200_r8*rxt(325) &
                      *y(13) + .500_r8*rxt(326)*y(45)
         mat(85) = .350_r8*rxt(230)*y(20)

         mat(94) = -(rxt(136)*y(6) + (rxt(137) + rxt(138) + rxt(139)) * y(7))
         mat(929) = -rxt(136)*y(5)
         mat(1010) = -(rxt(137) + rxt(138) + rxt(139)) * y(5)

         mat(974) = -(rxt(136)*y(5) + rxt(140)*y(2) + rxt(141)*y(21) + rxt(142)*y(1) &
                      + rxt(150)*y(8) + rxt(169)*y(27) + rxt(190)*y(35) + rxt(219) &
                      *y(13) + rxt(227)*y(127) + rxt(233)*y(52) + rxt(239)*y(43) &
                      + rxt(246)*y(45) + rxt(260)*y(58) + rxt(265)*y(61) + rxt(269) &
                      *y(64) + rxt(278)*y(70) + rxt(282)*y(71) + (rxt(287) + rxt(288) &
                      ) * y(76) + rxt(294)*y(73) + rxt(306)*y(85) + rxt(312)*y(86) &
                      + rxt(319)*y(81) + rxt(322)*y(88) + rxt(330)*y(93) + rxt(337) &
                      *y(97) + rxt(340)*y(100) + rxt(344)*y(103))
         mat(95) = -rxt(136)*y(6)
         mat(1172) = -rxt(140)*y(6)
         mat(1127) = -rxt(141)*y(6)
         mat(837) = -rxt(142)*y(6)
         mat(879) = -rxt(150)*y(6)
         mat(798) = -rxt(169)*y(6)
         mat(1056) = -rxt(190)*y(6)
         mat(762) = -rxt(219)*y(6)
         mat(243) = -rxt(227)*y(6)
         mat(309) = -rxt(233)*y(6)
         mat(394) = -rxt(239)*y(6)
         mat(709) = -rxt(246)*y(6)
         mat(429) = -rxt(260)*y(6)
         mat(383) = -rxt(265)*y(6)
         mat(548) = -rxt(269)*y(6)
         mat(148) = -rxt(278)*y(6)
         mat(349) = -rxt(282)*y(6)
         mat(643) = -(rxt(287) + rxt(288)) * y(6)
         mat(683) = -rxt(294)*y(6)
         mat(666) = -rxt(306)*y(6)
         mat(523) = -rxt(312)*y(6)
         mat(367) = -rxt(319)*y(6)
         mat(605) = -rxt(322)*y(6)
         mat(263) = -rxt(330)*y(6)
         mat(184) = -rxt(337)*y(6)
         mat(230) = -rxt(340)*y(6)
         mat(493) = -rxt(344)*y(6)

         mat(1172) = mat(1172) + rxt(143)*y(7)
         mat(95) = mat(95) + 2.000_r8*rxt(138)*y(7)
         mat(1035) = rxt(143)*y(2) + 2.000_r8*rxt(138)*y(5)

         mat(1037) = -((rxt(137) + rxt(138) + rxt(139)) * y(5) + (rxt(143) + rxt(144) &
                      ) * y(2) + rxt(145)*y(1) + rxt(146)*y(8) + rxt(148)*y(20) &
                      + rxt(154)*y(21) + rxt(170)*y(27) + rxt(191)*y(35) + rxt(247) &
                      *y(45) + rxt(300)*y(73) + rxt(334)*y(95))
         mat(96) = -(rxt(137) + rxt(138) + rxt(139)) * y(7)
         mat(1174) = -(rxt(143) + rxt(144)) * y(7)
         mat(839) = -rxt(145)*y(7)
         mat(881) = -rxt(146)*y(7)
         mat(1269) = -rxt(148)*y(7)
         mat(1129) = -rxt(154)*y(7)
         mat(800) = -rxt(170)*y(7)
         mat(1058) = -rxt(191)*y(7)
         mat(710) = -rxt(247)*y(7)
         mat(684) = -rxt(300)*y(7)
         mat(92) = -rxt(334)*y(7)

         mat(839) = mat(839) + rxt(142)*y(6)
         mat(1174) = mat(1174) + rxt(140)*y(6) + rxt(151)*y(8)
         mat(976) = rxt(142)*y(1) + rxt(140)*y(2) + 2.000_r8*rxt(150)*y(8) + rxt(219) &
                      *y(13) + rxt(141)*y(21) + rxt(169)*y(27) + rxt(190)*y(35) &
                      + rxt(265)*y(61) + rxt(246)*y(45) + rxt(278)*y(70) &
                      + .900_r8*rxt(319)*y(81) + rxt(282)*y(71) + .900_r8*rxt(330) &
                      *y(93) + rxt(344)*y(103) + .900_r8*rxt(337)*y(97) &
                      + .900_r8*rxt(340)*y(100) + .920_r8*rxt(306)*y(85) + rxt(287) &
                      *y(76) + rxt(294)*y(73) + rxt(239)*y(43) + rxt(260)*y(58) &
                      + rxt(233)*y(52) + rxt(269)*y(64) + 1.206_r8*rxt(312)*y(86) &
                      + rxt(322)*y(88) + rxt(227)*y(127)
         mat(1037) = mat(1037) + .700_r8*rxt(334)*y(95)
         mat(1269) = mat(1269) + rxt(152)*y(8) + rxt(155)*y(10) + rxt(276)*y(79) &
                      + .400_r8*rxt(316)*y(87)
         mat(881) = mat(881) + rxt(151)*y(2) + 2.000_r8*rxt(150)*y(6) + rxt(152)*y(20) &
                      + rxt(153)*y(21) + rxt(307)*y(85) + rxt(289)*y(76) + rxt(295) &
                      *y(73) + rxt(343)*y(102) + 1.206_r8*rxt(313)*y(86) + rxt(317) &
                      *y(87) + rxt(323)*y(88)
         mat(198) = rxt(155)*y(20)
         mat(764) = rxt(219)*y(6)
         mat(1129) = mat(1129) + rxt(141)*y(6) + rxt(153)*y(8) + .206_r8*rxt(314) &
                      *y(86)
         mat(800) = mat(800) + rxt(169)*y(6)
         mat(1058) = mat(1058) + rxt(190)*y(6)
         mat(384) = rxt(265)*y(6)
         mat(710) = mat(710) + rxt(246)*y(6)
         mat(193) = rxt(276)*y(20)
         mat(149) = rxt(278)*y(6)
         mat(368) = .900_r8*rxt(319)*y(6)
         mat(350) = rxt(282)*y(6)
         mat(264) = .900_r8*rxt(330)*y(6)
         mat(92) = mat(92) + .700_r8*rxt(334)*y(7)
         mat(494) = rxt(344)*y(6)
         mat(185) = .900_r8*rxt(337)*y(6)
         mat(231) = .900_r8*rxt(340)*y(6)
         mat(667) = .920_r8*rxt(306)*y(6) + rxt(307)*y(8)
         mat(644) = rxt(287)*y(6) + rxt(289)*y(8)
         mat(684) = mat(684) + rxt(294)*y(6) + rxt(295)*y(8)
         mat(395) = rxt(239)*y(6)
         mat(324) = rxt(343)*y(8)
         mat(430) = rxt(260)*y(6)
         mat(310) = rxt(233)*y(6)
         mat(549) = rxt(269)*y(6)
         mat(524) = 1.206_r8*rxt(312)*y(6) + 1.206_r8*rxt(313)*y(8) + .206_r8*rxt(314) &
                      *y(21)
         mat(480) = .400_r8*rxt(316)*y(20) + rxt(317)*y(8)
         mat(606) = rxt(322)*y(6) + rxt(323)*y(8)
         mat(244) = rxt(227)*y(6)


      end subroutine nlnmat01

      subroutine nlnmat02( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(1274) = -(rxt(121)*y(2) + rxt(122)*y(1) + rxt(123)*y(21) + (4._r8*rxt(124) &
                      + 4._r8*rxt(125)) * y(20) + rxt(126)*y(18) + rxt(127)*y(22) &
                      + rxt(133)*y(39) + rxt(134)*y(40) + rxt(148)*y(7) + rxt(149) &
                      *y(9) + rxt(152)*y(8) + rxt(155)*y(10) + (rxt(165) + rxt(166) &
                      ) * y(27) + rxt(176)*y(30) + rxt(180)*y(31) + rxt(182)*y(32) &
                      + rxt(188)*y(35) + rxt(196)*y(36) + (rxt(213) + rxt(214) &
                      ) * y(17) + rxt(216)*y(16) + rxt(223)*y(15) + rxt(224)*y(14) &
                      + rxt(225)*y(126) + rxt(230)*y(125) + rxt(231)*y(42) + rxt(232) &
                      *y(41) + rxt(238)*y(46) + rxt(243)*y(44) + rxt(244)*y(47) &
                      + rxt(251)*y(51) + rxt(252)*y(49) + rxt(253)*y(50) + rxt(254) &
                      *y(48) + rxt(256)*y(55) + rxt(257)*y(56) + rxt(263)*y(59) &
                      + rxt(264)*y(57) + rxt(267)*y(62) + rxt(268)*y(60) + rxt(272) &
                      *y(66) + rxt(273)*y(63) + rxt(274)*y(65) + rxt(276)*y(79) &
                      + rxt(277)*y(67) + rxt(279)*y(74) + rxt(281)*y(69) + rxt(284) &
                      *y(72) + rxt(285)*y(75) + rxt(293)*y(77) + rxt(302)*y(78) &
                      + rxt(303)*y(80) + rxt(309)*y(90) + rxt(315)*y(68) + rxt(316) &
                      *y(87) + rxt(318)*y(84) + rxt(321)*y(82) + rxt(327)*y(89) &
                      + rxt(329)*y(91) + rxt(332)*y(94) + rxt(333)*y(92) + rxt(335) &
                      *y(96) + rxt(338)*y(99) + rxt(341)*y(102) + rxt(346)*y(104) &
                      + rxt(352)*y(142) + (rxt(353) + rxt(354)) * y(143) + rxt(356) &
                      *y(145))
         mat(1179) = -rxt(121)*y(20)
         mat(844) = -rxt(122)*y(20)
         mat(1134) = -rxt(123)*y(20)
         mat(535) = -rxt(126)*y(20)
         mat(333) = -rxt(127)*y(20)
         mat(101) = -rxt(133)*y(20)
         mat(57) = -rxt(134)*y(20)
         mat(1042) = -rxt(148)*y(20)
         mat(438) = -rxt(149)*y(20)
         mat(886) = -rxt(152)*y(20)
         mat(200) = -rxt(155)*y(20)
         mat(805) = -(rxt(165) + rxt(166)) * y(20)
         mat(908) = -rxt(176)*y(20)
         mat(462) = -rxt(180)*y(20)
         mat(474) = -rxt(182)*y(20)
         mat(1063) = -rxt(188)*y(20)
         mat(414) = -rxt(196)*y(20)
         mat(539) = -(rxt(213) + rxt(214)) * y(20)
         mat(1154) = -rxt(216)*y(20)
         mat(257) = -rxt(223)*y(20)
         mat(212) = -rxt(224)*y(20)
         mat(190) = -rxt(225)*y(20)
         mat(87) = -rxt(230)*y(20)
         mat(124) = -rxt(231)*y(20)
         mat(164) = -rxt(232)*y(20)
         mat(317) = -rxt(238)*y(20)
         mat(140) = -rxt(243)*y(20)
         mat(569) = -rxt(244)*y(20)
         mat(253) = -rxt(251)*y(20)
         mat(420) = -rxt(252)*y(20)
         mat(356) = -rxt(253)*y(20)
         mat(114) = -rxt(254)*y(20)
         mat(224) = -rxt(256)*y(20)
         mat(513) = -rxt(257)*y(20)
         mat(173) = -rxt(263)*y(20)
         mat(64) = -rxt(264)*y(20)
         mat(288) = -rxt(267)*y(20)
         mat(377) = -rxt(268)*y(20)
         mat(179) = -rxt(272)*y(20)
         mat(558) = -rxt(273)*y(20)
         mat(591) = -rxt(274)*y(20)
         mat(194) = -rxt(276)*y(20)
         mat(45) = -rxt(277)*y(20)
         mat(627) = -rxt(279)*y(20)
         mat(217) = -rxt(281)*y(20)
         mat(156) = -rxt(284)*y(20)
         mat(581) = -rxt(285)*y(20)
         mat(135) = -rxt(293)*y(20)
         mat(296) = -rxt(302)*y(20)
         mat(454) = -rxt(303)*y(20)
         mat(280) = -rxt(309)*y(20)
         mat(42) = -rxt(315)*y(20)
         mat(483) = -rxt(316)*y(20)
         mat(167) = -rxt(318)*y(20)
         mat(344) = -rxt(321)*y(20)
         mat(144) = -rxt(327)*y(20)
         mat(72) = -rxt(329)*y(20)
         mat(206) = -rxt(332)*y(20)
         mat(75) = -rxt(333)*y(20)
         mat(48) = -rxt(335)*y(20)
         mat(51) = -rxt(338)*y(20)
         mat(326) = -rxt(341)*y(20)
         mat(239) = -rxt(346)*y(20)
         mat(67) = -rxt(352)*y(20)
         mat(107) = -(rxt(353) + rxt(354)) * y(20)
         mat(54) = -rxt(356)*y(20)

         mat(844) = mat(844) + rxt(117)*y(19) + rxt(130)*y(21) + .330_r8*rxt(258) &
                      *y(56) + .270_r8*rxt(304)*y(80) + .120_r8*rxt(237)*y(41) &
                      + .080_r8*rxt(280)*y(74) + .215_r8*rxt(286)*y(75) &
                      + .700_r8*rxt(342)*y(102)
         mat(1179) = mat(1179) + rxt(128)*y(18) + rxt(217)*y(16) + rxt(129)*y(21) &
                      + rxt(132)*y(22) + rxt(177)*y(30) + rxt(178)*y(31) + rxt(197) &
                      *y(36) + rxt(198)*y(37)
         mat(928) = rxt(112)*y(18) + rxt(115)*y(39) + 2.000_r8*rxt(89)*y(124) &
                      + rxt(113)*y(30) + rxt(114)*y(36)
         mat(535) = mat(535) + rxt(128)*y(2) + rxt(112)*y(3)
         mat(981) = rxt(141)*y(21)
         mat(1274) = mat(1274) + .300_r8*rxt(224)*y(14) + .500_r8*rxt(267)*y(62) &
                      + .100_r8*rxt(293)*y(77) + .500_r8*rxt(243)*y(44) &
                      + .650_r8*rxt(230)*y(125)
         mat(886) = mat(886) + rxt(153)*y(21)
         mat(212) = mat(212) + .300_r8*rxt(224)*y(20)
         mat(101) = mat(101) + rxt(115)*y(3)
         mat(1154) = mat(1154) + rxt(217)*y(2)
         mat(731) = rxt(117)*y(1) + 2.000_r8*rxt(118)*y(21)
         mat(1134) = mat(1134) + rxt(130)*y(1) + rxt(129)*y(2) + rxt(141)*y(6) &
                      + rxt(153)*y(8) + 2.000_r8*rxt(118)*y(19) + rxt(161)*y(25)
         mat(333) = mat(333) + rxt(132)*y(2)
         mat(721) = 2.000_r8*rxt(89)*y(3)
         mat(1008) = rxt(161)*y(21)
         mat(908) = mat(908) + rxt(177)*y(2) + rxt(113)*y(3)
         mat(462) = mat(462) + rxt(178)*y(2)
         mat(414) = mat(414) + rxt(197)*y(2) + rxt(114)*y(3)
         mat(407) = rxt(198)*y(2)
         mat(513) = mat(513) + .330_r8*rxt(258)*y(1)
         mat(454) = mat(454) + .270_r8*rxt(304)*y(1)
         mat(288) = mat(288) + .500_r8*rxt(267)*y(20)
         mat(164) = mat(164) + .120_r8*rxt(237)*y(1)
         mat(627) = mat(627) + .080_r8*rxt(280)*y(1)
         mat(581) = mat(581) + .215_r8*rxt(286)*y(1)
         mat(135) = mat(135) + .100_r8*rxt(293)*y(20)
         mat(140) = mat(140) + .500_r8*rxt(243)*y(20)
         mat(326) = mat(326) + .700_r8*rxt(342)*y(1)
         mat(87) = mat(87) + .650_r8*rxt(230)*y(20)

         mat(876) = -(rxt(146)*y(7) + rxt(150)*y(6) + rxt(151)*y(2) + rxt(152)*y(20) &
                      + rxt(153)*y(21) + rxt(215)*y(16) + rxt(245)*y(47) + rxt(259) &
                      *y(56) + rxt(275)*y(65) + rxt(289)*y(76) + rxt(295)*y(73) &
                      + rxt(305)*y(80) + rxt(307)*y(85) + rxt(313)*y(86) + rxt(317) &
                      *y(87) + rxt(323)*y(88) + rxt(343)*y(102) + rxt(355)*y(143))
         mat(1032) = -rxt(146)*y(8)
         mat(971) = -rxt(150)*y(8)
         mat(1169) = -rxt(151)*y(8)
         mat(1264) = -rxt(152)*y(8)
         mat(1124) = -rxt(153)*y(8)
         mat(1144) = -rxt(215)*y(8)
         mat(566) = -rxt(245)*y(8)
         mat(508) = -rxt(259)*y(8)
         mat(588) = -rxt(275)*y(8)
         mat(642) = -rxt(289)*y(8)
         mat(682) = -rxt(295)*y(8)
         mat(451) = -rxt(305)*y(8)
         mat(665) = -rxt(307)*y(8)
         mat(522) = -rxt(313)*y(8)
         mat(479) = -rxt(317)*y(8)
         mat(604) = -rxt(323)*y(8)
         mat(323) = -rxt(343)*y(8)
         mat(105) = -rxt(355)*y(8)

         mat(834) = rxt(145)*y(7)
         mat(1169) = mat(1169) + rxt(144)*y(7) + rxt(181)*y(32) + rxt(199)*y(38)
         mat(1032) = mat(1032) + rxt(145)*y(1) + rxt(144)*y(2)
         mat(1264) = mat(1264) + rxt(149)*y(9) + rxt(182)*y(32) + rxt(256)*y(55) &
                      + .500_r8*rxt(302)*y(78)
         mat(436) = rxt(149)*y(20)
         mat(998) = rxt(183)*y(32)
         mat(469) = rxt(181)*y(2) + rxt(182)*y(20) + rxt(183)*y(25)
         mat(301) = rxt(199)*y(2)
         mat(221) = rxt(256)*y(20)
         mat(292) = .500_r8*rxt(302)*y(20)

         mat(434) = -(rxt(149)*y(20))
         mat(1237) = -rxt(149)*y(9)

         mat(1019) = rxt(148)*y(20)
         mat(1237) = mat(1237) + rxt(148)*y(7)
         mat(853) = rxt(215)*y(16) + rxt(245)*y(47) + rxt(275)*y(65) + rxt(355)*y(143)
         mat(1137) = rxt(215)*y(8)
         mat(890) = (rxt(383)+rxt(388)+rxt(394))*y(32)
         mat(464) = (rxt(383)+rxt(388)+rxt(394))*y(30)
         mat(559) = rxt(245)*y(8)
         mat(582) = rxt(275)*y(8)
         mat(104) = rxt(355)*y(8)

         mat(195) = -(rxt(155)*y(20))
         mat(1209) = -rxt(155)*y(10)

         mat(1012) = rxt(154)*y(21)
         mat(1076) = rxt(154)*y(7)


         mat(1011) = rxt(146)*y(8)
         mat(847) = rxt(146)*y(7)

         mat(756) = -(rxt(168)*y(27) + rxt(219)*y(6) + rxt(220)*y(21) + (4._r8*rxt(221) &
                      + 4._r8*rxt(222)) * y(13) + rxt(241)*y(43) + rxt(249)*y(45) &
                      + rxt(262)*y(58) + rxt(271)*y(64) + rxt(291)*y(76) + rxt(297) &
                      *y(73) + rxt(310)*y(85) + rxt(325)*y(88))
         mat(791) = -rxt(168)*y(13)
         mat(967) = -rxt(219)*y(13)
         mat(1120) = -rxt(220)*y(13)
         mat(393) = -rxt(241)*y(13)
         mat(706) = -rxt(249)*y(13)
         mat(428) = -rxt(262)*y(13)
         mat(547) = -rxt(271)*y(13)
         mat(641) = -rxt(291)*y(13)
         mat(680) = -rxt(297)*y(13)
         mat(663) = -rxt(310)*y(13)
         mat(603) = -rxt(325)*y(13)

         mat(830) = .310_r8*rxt(258)*y(56)
         mat(967) = mat(967) + rxt(246)*y(45)
         mat(1260) = .700_r8*rxt(224)*y(14) + rxt(238)*y(46)
         mat(756) = mat(756) + .900_r8*rxt(249)*y(45)
         mat(210) = .700_r8*rxt(224)*y(20)
         mat(506) = .310_r8*rxt(258)*y(1)
         mat(316) = rxt(238)*y(20)
         mat(706) = mat(706) + rxt(246)*y(6) + .900_r8*rxt(249)*y(13) &
                      + 4.000_r8*rxt(250)*y(45) + rxt(311)*y(85) + rxt(292)*y(76) &
                      + rxt(298)*y(73) + rxt(326)*y(88)
         mat(663) = mat(663) + rxt(311)*y(45)
         mat(641) = mat(641) + rxt(292)*y(45)
         mat(680) = mat(680) + rxt(298)*y(45)
         mat(603) = mat(603) + rxt(326)*y(45)


      end subroutine nlnmat02

      subroutine nlnmat03( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(207) = -(rxt(224)*y(20))
         mat(1211) = -rxt(224)*y(14)

         mat(734) = rxt(220)*y(21)
         mat(1078) = rxt(220)*y(13)

         mat(98) = -(rxt(115)*y(3) + rxt(133)*y(20))
         mat(909) = -rxt(115)*y(39)
         mat(1193) = -rxt(133)*y(39)

         mat(55) = -(rxt(134)*y(20))
         mat(1186) = -rxt(134)*y(40)

         mat(1152) = -(rxt(162)*y(25) + rxt(186)*y(34) + rxt(215)*y(8) + rxt(216) &
                      *y(20) + rxt(217)*y(2) + rxt(218)*y(21))
         mat(1006) = -rxt(162)*y(16)
         mat(780) = -rxt(186)*y(16)
         mat(884) = -rxt(215)*y(16)
         mat(1272) = -rxt(216)*y(16)
         mat(1177) = -rxt(217)*y(16)
         mat(1132) = -rxt(218)*y(16)

         mat(842) = .540_r8*rxt(258)*y(56) + .600_r8*rxt(304)*y(80) + rxt(237)*y(41) &
                      + .800_r8*rxt(280)*y(74) + .700_r8*rxt(286)*y(75)
         mat(979) = rxt(219)*y(13) + rxt(265)*y(61) + .500_r8*rxt(278)*y(70) &
                      + .100_r8*rxt(319)*y(81) + .510_r8*rxt(306)*y(85) &
                      + .250_r8*rxt(287)*y(76) + rxt(294)*y(73) + .500_r8*rxt(233) &
                      *y(52) + rxt(269)*y(64) + .072_r8*rxt(312)*y(86)
         mat(1272) = mat(1272) + .300_r8*rxt(224)*y(14) + .500_r8*rxt(251)*y(51) &
                      + rxt(256)*y(55) + .500_r8*rxt(302)*y(78) + rxt(223)*y(15) &
                      + .800_r8*rxt(252)*y(49)
         mat(884) = mat(884) + .600_r8*rxt(307)*y(85) + .250_r8*rxt(289)*y(76) &
                      + rxt(295)*y(73) + .072_r8*rxt(313)*y(86)
         mat(766) = rxt(219)*y(6) + (4.000_r8*rxt(221)+2.000_r8*rxt(222))*y(13) &
                      + rxt(168)*y(27) + rxt(249)*y(45) + 1.200_r8*rxt(310)*y(85) &
                      + .880_r8*rxt(291)*y(76) + 2.000_r8*rxt(297)*y(73) &
                      + .700_r8*rxt(241)*y(43) + rxt(262)*y(58) + .800_r8*rxt(271) &
                      *y(64) + .700_r8*rxt(325)*y(88)
         mat(211) = .300_r8*rxt(224)*y(20)
         mat(1132) = mat(1132) + .008_r8*rxt(314)*y(86)
         mat(803) = rxt(168)*y(13)
         mat(512) = .540_r8*rxt(258)*y(1)
         mat(453) = .600_r8*rxt(304)*y(1)
         mat(386) = rxt(265)*y(6)
         mat(712) = rxt(249)*y(13) + .600_r8*rxt(311)*y(85) + .250_r8*rxt(292)*y(76) &
                      + rxt(298)*y(73)
         mat(252) = .500_r8*rxt(251)*y(20)
         mat(223) = rxt(256)*y(20)
         mat(163) = rxt(237)*y(1)
         mat(295) = .500_r8*rxt(302)*y(20)
         mat(151) = .500_r8*rxt(278)*y(6)
         mat(370) = .100_r8*rxt(319)*y(6)
         mat(669) = .510_r8*rxt(306)*y(6) + .600_r8*rxt(307)*y(8) + 1.200_r8*rxt(310) &
                      *y(13) + .600_r8*rxt(311)*y(45)
         mat(626) = .800_r8*rxt(280)*y(1)
         mat(580) = .700_r8*rxt(286)*y(1)
         mat(646) = .250_r8*rxt(287)*y(6) + .250_r8*rxt(289)*y(8) + .880_r8*rxt(291) &
                      *y(13) + .250_r8*rxt(292)*y(45)
         mat(686) = rxt(294)*y(6) + rxt(295)*y(8) + 2.000_r8*rxt(297)*y(13) + rxt(298) &
                      *y(45) + 4.000_r8*rxt(299)*y(73)
         mat(397) = .700_r8*rxt(241)*y(13)
         mat(432) = rxt(262)*y(13)
         mat(256) = rxt(223)*y(20)
         mat(419) = .800_r8*rxt(252)*y(20)
         mat(312) = .500_r8*rxt(233)*y(6)
         mat(551) = rxt(269)*y(6) + .800_r8*rxt(271)*y(13)
         mat(526) = .072_r8*rxt(312)*y(6) + .072_r8*rxt(313)*y(8) + .008_r8*rxt(314) &
                      *y(21)
         mat(608) = .700_r8*rxt(325)*y(13)

         mat(724) = -(rxt(117)*y(1) + (rxt(118) + rxt(119) + rxt(120)) * y(21))
         mat(829) = -rxt(117)*y(19)
         mat(1119) = -(rxt(118) + rxt(119) + rxt(120)) * y(19)

         mat(1165) = rxt(128)*y(18) + rxt(121)*y(20)
         mat(913) = rxt(112)*y(18)
         mat(530) = rxt(128)*y(2) + rxt(112)*y(3) + rxt(126)*y(20) + rxt(158)*y(25)
         mat(537) = rxt(213)*y(20)
         mat(1259) = rxt(121)*y(2) + rxt(126)*y(18) + rxt(213)*y(17) + rxt(216)*y(16)
         mat(1141) = rxt(216)*y(20)
         mat(993) = rxt(158)*y(18)

         mat(1131) = -((rxt(118) + rxt(119) + rxt(120)) * y(19) + rxt(123)*y(20) &
                      + rxt(129)*y(2) + rxt(130)*y(1) + 4._r8*rxt(131)*y(21) + rxt(141) &
                      *y(6) + rxt(153)*y(8) + rxt(154)*y(7) + (rxt(160) + rxt(161) &
                      ) * y(25) + rxt(167)*y(27) + rxt(185)*y(34) + rxt(189)*y(35) &
                      + rxt(218)*y(16) + rxt(220)*y(13) + rxt(228)*y(127) + rxt(234) &
                      *y(52) + rxt(240)*y(43) + rxt(248)*y(45) + rxt(261)*y(58) &
                      + rxt(266)*y(61) + rxt(270)*y(64) + rxt(283)*y(71) + rxt(290) &
                      *y(76) + rxt(296)*y(73) + rxt(308)*y(85) + rxt(314)*y(86) &
                      + rxt(320)*y(81) + rxt(324)*y(88) + rxt(331)*y(93) + rxt(336) &
                      *y(97) + rxt(339)*y(100) + rxt(345)*y(103))
         mat(729) = -(rxt(118) + rxt(119) + rxt(120)) * y(21)
         mat(1271) = -rxt(123)*y(21)
         mat(1176) = -rxt(129)*y(21)
         mat(841) = -rxt(130)*y(21)
         mat(978) = -rxt(141)*y(21)
         mat(883) = -rxt(153)*y(21)
         mat(1039) = -rxt(154)*y(21)
         mat(1005) = -(rxt(160) + rxt(161)) * y(21)
         mat(802) = -rxt(167)*y(21)
         mat(779) = -rxt(185)*y(21)
         mat(1060) = -rxt(189)*y(21)
         mat(1151) = -rxt(218)*y(21)
         mat(765) = -rxt(220)*y(21)
         mat(245) = -rxt(228)*y(21)
         mat(311) = -rxt(234)*y(21)
         mat(396) = -rxt(240)*y(21)
         mat(711) = -rxt(248)*y(21)
         mat(431) = -rxt(261)*y(21)
         mat(385) = -rxt(266)*y(21)
         mat(550) = -rxt(270)*y(21)
         mat(351) = -rxt(283)*y(21)
         mat(645) = -rxt(290)*y(21)
         mat(685) = -rxt(296)*y(21)
         mat(668) = -rxt(308)*y(21)
         mat(525) = -rxt(314)*y(21)
         mat(369) = -rxt(320)*y(21)
         mat(607) = -rxt(324)*y(21)
         mat(265) = -rxt(331)*y(21)
         mat(186) = -rxt(336)*y(21)
         mat(232) = -rxt(339)*y(21)
         mat(495) = -rxt(345)*y(21)

         mat(841) = mat(841) + rxt(122)*y(20) + .190_r8*rxt(258)*y(56) &
                      + .060_r8*rxt(304)*y(80) + .120_r8*rxt(237)*y(41) &
                      + .060_r8*rxt(280)*y(74) + .275_r8*rxt(286)*y(75) + rxt(342) &
                      *y(102)
         mat(1176) = mat(1176) + rxt(217)*y(16) + rxt(132)*y(22)
         mat(538) = rxt(214)*y(20)
         mat(978) = mat(978) + rxt(219)*y(13) + rxt(265)*y(61) + rxt(278)*y(70) &
                      + .900_r8*rxt(319)*y(81) + .900_r8*rxt(330)*y(93) + rxt(344) &
                      *y(103) + .900_r8*rxt(337)*y(97) + .900_r8*rxt(340)*y(100) &
                      + rxt(306)*y(85) + .470_r8*rxt(287)*y(76) + rxt(239)*y(43) &
                      + rxt(260)*y(58) + .250_r8*rxt(233)*y(52) + .794_r8*rxt(312) &
                      *y(86) + rxt(322)*y(88) + rxt(227)*y(127)
         mat(1039) = mat(1039) + .700_r8*rxt(334)*y(95)
         mat(1271) = mat(1271) + rxt(122)*y(1) + rxt(214)*y(17) + rxt(152)*y(8) &
                      + rxt(133)*y(39) + rxt(134)*y(40) + rxt(127)*y(22) + rxt(165) &
                      *y(27) + rxt(188)*y(35) + .500_r8*rxt(302)*y(78) &
                      + .250_r8*rxt(329)*y(91) + rxt(253)*y(50) + .200_r8*rxt(293) &
                      *y(77) + rxt(223)*y(15) + rxt(254)*y(48) + rxt(252)*y(49) &
                      + rxt(273)*y(63) + rxt(316)*y(87) + .350_r8*rxt(230)*y(125) &
                      + rxt(225)*y(126) + .500_r8*rxt(354)*y(143)
         mat(883) = mat(883) + rxt(152)*y(20) + rxt(215)*y(16) + rxt(307)*y(85) &
                      + .470_r8*rxt(289)*y(76) + .794_r8*rxt(313)*y(86) + rxt(317) &
                      *y(87) + rxt(323)*y(88)
         mat(765) = mat(765) + rxt(219)*y(6) + 4.000_r8*rxt(221)*y(13) + rxt(168) &
                      *y(27) + .900_r8*rxt(249)*y(45) + rxt(310)*y(85) &
                      + .730_r8*rxt(291)*y(76) + rxt(297)*y(73) + rxt(241)*y(43) &
                      + rxt(262)*y(58) + .300_r8*rxt(271)*y(64) + .800_r8*rxt(325) &
                      *y(88)
         mat(100) = rxt(133)*y(20)
         mat(56) = rxt(134)*y(20)
         mat(1151) = mat(1151) + rxt(217)*y(2) + rxt(215)*y(8) + rxt(162)*y(25) &
                      + rxt(186)*y(34)
         mat(1131) = mat(1131) + .794_r8*rxt(314)*y(86)
         mat(331) = rxt(132)*y(2) + rxt(127)*y(20) + rxt(159)*y(25)
         mat(1005) = mat(1005) + rxt(162)*y(16) + rxt(159)*y(22)
         mat(802) = mat(802) + rxt(165)*y(20) + rxt(168)*y(13)
         mat(779) = mat(779) + rxt(186)*y(16)
         mat(1060) = mat(1060) + rxt(188)*y(20)
         mat(511) = .190_r8*rxt(258)*y(1)
         mat(452) = .060_r8*rxt(304)*y(1)
         mat(385) = mat(385) + rxt(265)*y(6)
         mat(711) = mat(711) + .900_r8*rxt(249)*y(13) + rxt(311)*y(85) &
                      + .470_r8*rxt(292)*y(76) + rxt(326)*y(88)
         mat(162) = .120_r8*rxt(237)*y(1)
         mat(294) = .500_r8*rxt(302)*y(20)
         mat(150) = rxt(278)*y(6)
         mat(369) = mat(369) + .900_r8*rxt(319)*y(6)
         mat(71) = .250_r8*rxt(329)*y(20)
         mat(265) = mat(265) + .900_r8*rxt(330)*y(6)
         mat(93) = .700_r8*rxt(334)*y(7)
         mat(495) = mat(495) + rxt(344)*y(6)
         mat(355) = rxt(253)*y(20)
         mat(186) = mat(186) + .900_r8*rxt(337)*y(6)
         mat(232) = mat(232) + .900_r8*rxt(340)*y(6)
         mat(668) = mat(668) + rxt(306)*y(6) + rxt(307)*y(8) + rxt(310)*y(13) &
                      + rxt(311)*y(45)
         mat(625) = .060_r8*rxt(280)*y(1)
         mat(579) = .275_r8*rxt(286)*y(1)
         mat(645) = mat(645) + .470_r8*rxt(287)*y(6) + .470_r8*rxt(289)*y(8) &
                      + .730_r8*rxt(291)*y(13) + .470_r8*rxt(292)*y(45)
         mat(134) = .200_r8*rxt(293)*y(20)
         mat(685) = mat(685) + rxt(297)*y(13)
         mat(396) = mat(396) + rxt(239)*y(6) + rxt(241)*y(13) + 2.400_r8*rxt(242) &
                      *y(43)
         mat(325) = rxt(342)*y(1)
         mat(431) = mat(431) + rxt(260)*y(6) + rxt(262)*y(13)
         mat(255) = rxt(223)*y(20)
         mat(113) = rxt(254)*y(20)
         mat(418) = rxt(252)*y(20)
         mat(556) = rxt(273)*y(20)
         mat(311) = mat(311) + .250_r8*rxt(233)*y(6)
         mat(550) = mat(550) + .300_r8*rxt(271)*y(13)
         mat(525) = mat(525) + .794_r8*rxt(312)*y(6) + .794_r8*rxt(313)*y(8) &
                      + .794_r8*rxt(314)*y(21)
         mat(481) = rxt(316)*y(20) + rxt(317)*y(8)
         mat(607) = mat(607) + rxt(322)*y(6) + rxt(323)*y(8) + .800_r8*rxt(325)*y(13) &
                      + rxt(326)*y(45)
         mat(86) = .350_r8*rxt(230)*y(20)
         mat(189) = rxt(225)*y(20)
         mat(245) = mat(245) + rxt(227)*y(6)
         mat(106) = .500_r8*rxt(354)*y(20)

         mat(327) = -(rxt(127)*y(20) + rxt(132)*y(2) + rxt(159)*y(25))
         mat(1226) = -rxt(127)*y(22)
         mat(1156) = -rxt(132)*y(22)
         mat(984) = -rxt(159)*y(22)

         mat(1226) = mat(1226) + 2.000_r8*rxt(125)*y(20)
         mat(1089) = 2.000_r8*rxt(131)*y(21)


      end subroutine nlnmat03

      subroutine nlnmat04( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(715) = -(rxt(89)*y(3))
         mat(912) = -rxt(89)*y(124)

         mat(529) = rxt(126)*y(20)
         mat(1258) = rxt(126)*y(18) + 2.000_r8*rxt(124)*y(20) + rxt(149)*y(9) &
                      + rxt(155)*y(10) + rxt(224)*y(14) + rxt(216)*y(16) + rxt(123) &
                      *y(21) + rxt(127)*y(22) + rxt(176)*y(30) + rxt(180)*y(31) &
                      + rxt(196)*y(36) + rxt(244)*y(47) + rxt(238)*y(46) + rxt(267) &
                      *y(62) + rxt(251)*y(51) + rxt(231)*y(42) + .500_r8*rxt(285) &
                      *y(75) + rxt(264)*y(57) + rxt(263)*y(59) + rxt(268)*y(60) &
                      + rxt(272)*y(66) + rxt(274)*y(65) + (rxt(327)+rxt(328))*y(89) &
                      + rxt(225)*y(126) + rxt(356)*y(145)
         mat(435) = rxt(149)*y(20)
         mat(196) = rxt(155)*y(20)
         mat(208) = rxt(224)*y(20)
         mat(1140) = rxt(216)*y(20)
         mat(723) = rxt(120)*y(21)
         mat(1118) = rxt(123)*y(20) + rxt(120)*y(19)
         mat(328) = rxt(127)*y(20)
         mat(893) = rxt(176)*y(20) + (rxt(384)+rxt(389)+rxt(395))*y(31) + (rxt(385) &
                       +rxt(396))*y(37)
         mat(457) = rxt(180)*y(20) + (rxt(384)+rxt(389)+rxt(395))*y(30)
         mat(409) = rxt(196)*y(20)
         mat(401) = (rxt(385)+rxt(396))*y(30)
         mat(563) = rxt(244)*y(20)
         mat(315) = rxt(238)*y(20)
         mat(285) = rxt(267)*y(20)
         mat(250) = rxt(251)*y(20)
         mat(121) = rxt(231)*y(20)
         mat(576) = .500_r8*rxt(285)*y(20)
         mat(63) = rxt(264)*y(20)
         mat(171) = rxt(263)*y(20)
         mat(375) = rxt(268)*y(20)
         mat(177) = rxt(272)*y(20)
         mat(586) = rxt(274)*y(20)
         mat(143) = (rxt(327)+rxt(328))*y(20)
         mat(188) = rxt(225)*y(20)
         mat(53) = rxt(356)*y(20)

         mat(1002) = -(rxt(157)*y(1) + rxt(158)*y(18) + rxt(159)*y(22) + (rxt(160) &
                      + rxt(161)) * y(21) + rxt(162)*y(16) + rxt(179)*y(31) + rxt(183) &
                      *y(32) + rxt(229)*y(42))
         mat(838) = -rxt(157)*y(25)
         mat(533) = -rxt(158)*y(25)
         mat(330) = -rxt(159)*y(25)
         mat(1128) = -(rxt(160) + rxt(161)) * y(25)
         mat(1148) = -rxt(162)*y(25)
         mat(460) = -rxt(179)*y(25)
         mat(471) = -rxt(183)*y(25)
         mat(123) = -rxt(229)*y(25)

         mat(1173) = rxt(164)*y(27) + rxt(177)*y(30)
         mat(922) = rxt(113)*y(30)
         mat(975) = rxt(169)*y(27)
         mat(1268) = rxt(165)*y(27) + rxt(176)*y(30)
         mat(763) = rxt(168)*y(27)
         mat(799) = rxt(164)*y(2) + rxt(169)*y(6) + rxt(165)*y(20) + rxt(168)*y(13) + ( &
                      + 4.000_r8*rxt(171)+2.000_r8*rxt(173))*y(27) + rxt(193)*y(35)
         mat(902) = rxt(177)*y(2) + rxt(113)*y(3) + rxt(176)*y(20)
         mat(1057) = rxt(193)*y(27)


         mat(982) = rxt(183)*y(32)
         mat(785) = 2.000_r8*rxt(172)*y(27)
         mat(887) = (rxt(384)+rxt(389)+rxt(395))*y(31) + (rxt(383)+rxt(388)+rxt(394)) &
                      *y(32)
         mat(455) = (rxt(384)+rxt(389)+rxt(395))*y(30)
         mat(463) = rxt(183)*y(25) + (rxt(383)+rxt(388)+rxt(394))*y(30)

         mat(793) = -(rxt(164)*y(2) + (rxt(165) + rxt(166)) * y(20) + rxt(167)*y(21) &
                      + rxt(168)*y(13) + rxt(169)*y(6) + rxt(170)*y(7) + (4._r8*rxt(171) &
                      + 4._r8*rxt(172) + 4._r8*rxt(173) + 4._r8*rxt(174)) * y(27) &
                      + (rxt(192) + rxt(193) + rxt(194)) * y(35))
         mat(1167) = -rxt(164)*y(27)
         mat(1262) = -(rxt(165) + rxt(166)) * y(27)
         mat(1122) = -rxt(167)*y(27)
         mat(757) = -rxt(168)*y(27)
         mat(969) = -rxt(169)*y(27)
         mat(1030) = -rxt(170)*y(27)
         mat(1051) = -(rxt(192) + rxt(193) + rxt(194)) * y(27)

         mat(832) = rxt(157)*y(25)
         mat(1167) = mat(1167) + rxt(178)*y(31) + rxt(181)*y(32)
         mat(1262) = mat(1262) + rxt(180)*y(31)
         mat(1122) = mat(1122) + rxt(161)*y(25)
         mat(996) = rxt(157)*y(1) + rxt(161)*y(21) + rxt(179)*y(31)
         mat(458) = rxt(178)*y(2) + rxt(180)*y(20) + rxt(179)*y(25)
         mat(468) = rxt(181)*y(2)


         mat(784) = 2.000_r8*rxt(173)*y(27) + rxt(192)*y(35)
         mat(1043) = rxt(192)*y(27)


         mat(783) = 2.000_r8*rxt(174)*y(27)

         mat(899) = -(rxt(113)*y(3) + rxt(176)*y(20) + rxt(177)*y(2) + (rxt(383) &
                      + rxt(388) + rxt(394)) * y(32) + (rxt(384) + rxt(389) + rxt(395) &
                      ) * y(31) + (rxt(385) + rxt(396)) * y(37))
         mat(919) = -rxt(113)*y(30)
         mat(1265) = -rxt(176)*y(30)
         mat(1170) = -rxt(177)*y(30)
         mat(470) = -(rxt(383) + rxt(388) + rxt(394)) * y(30)
         mat(459) = -(rxt(384) + rxt(389) + rxt(395)) * y(30)
         mat(403) = -(rxt(385) + rxt(396)) * y(30)

         mat(531) = rxt(158)*y(25)
         mat(1265) = mat(1265) + rxt(166)*y(27)
         mat(1145) = rxt(162)*y(25)
         mat(1125) = rxt(160)*y(25)
         mat(329) = rxt(159)*y(25)
         mat(999) = rxt(158)*y(18) + rxt(162)*y(16) + rxt(160)*y(21) + rxt(159)*y(22) &
                      + rxt(179)*y(31) + rxt(229)*y(42)
         mat(796) = rxt(166)*y(20)
         mat(459) = mat(459) + rxt(179)*y(25)
         mat(122) = rxt(229)*y(25)

         mat(456) = -(rxt(178)*y(2) + rxt(179)*y(25) + rxt(180)*y(20) + (rxt(384) &
                      + rxt(389) + rxt(395)) * y(30))
         mat(1160) = -rxt(178)*y(31)
         mat(986) = -rxt(179)*y(31)
         mat(1239) = -rxt(180)*y(31)
         mat(891) = -(rxt(384) + rxt(389) + rxt(395)) * y(31)

         mat(1239) = mat(1239) + rxt(182)*y(32)
         mat(1101) = rxt(167)*y(27)
         mat(787) = rxt(167)*y(21)
         mat(465) = rxt(182)*y(20)

         mat(466) = -(rxt(181)*y(2) + rxt(182)*y(20) + rxt(183)*y(25) + (rxt(383) &
                      + rxt(388) + rxt(394)) * y(30))
         mat(1161) = -rxt(181)*y(32)
         mat(1240) = -rxt(182)*y(32)
         mat(987) = -rxt(183)*y(32)
         mat(892) = -(rxt(383) + rxt(388) + rxt(394)) * y(32)

         mat(1020) = rxt(170)*y(27)
         mat(788) = rxt(170)*y(7)


         mat(786) = rxt(194)*y(35)
         mat(888) = (rxt(385)+rxt(396))*y(37)
         mat(1044) = rxt(194)*y(27)
         mat(399) = (rxt(385)+rxt(396))*y(30)

         mat(773) = -(rxt(184)*y(1) + rxt(185)*y(21) + rxt(186)*y(16))
         mat(831) = -rxt(184)*y(34)
         mat(1121) = -rxt(185)*y(34)
         mat(1142) = -rxt(186)*y(34)

         mat(1166) = rxt(187)*y(35) + rxt(197)*y(36)
         mat(915) = rxt(114)*y(36)
         mat(968) = rxt(190)*y(35)
         mat(1261) = rxt(188)*y(35) + rxt(196)*y(36)
         mat(792) = (rxt(192)+rxt(193))*y(35)
         mat(1050) = rxt(187)*y(2) + rxt(190)*y(6) + rxt(188)*y(20) + (rxt(192) &
                       +rxt(193))*y(27) + 4.000_r8*rxt(195)*y(35)
         mat(411) = rxt(197)*y(2) + rxt(114)*y(3) + rxt(196)*y(20)

         mat(1059) = -(rxt(187)*y(2) + rxt(188)*y(20) + rxt(189)*y(21) + rxt(190)*y(6) &
                      + rxt(191)*y(7) + (rxt(192) + rxt(193) + rxt(194)) * y(27) &
                      + 4._r8*rxt(195)*y(35))
         mat(1175) = -rxt(187)*y(35)
         mat(1270) = -rxt(188)*y(35)
         mat(1130) = -rxt(189)*y(35)
         mat(977) = -rxt(190)*y(35)
         mat(1038) = -rxt(191)*y(35)
         mat(801) = -(rxt(192) + rxt(193) + rxt(194)) * y(35)

         mat(840) = rxt(184)*y(34)
         mat(1175) = mat(1175) + rxt(198)*y(37) + rxt(199)*y(38)
         mat(778) = rxt(184)*y(1)
         mat(405) = rxt(198)*y(2)
         mat(303) = rxt(199)*y(2)

         mat(408) = -(rxt(114)*y(3) + rxt(196)*y(20) + rxt(197)*y(2))
         mat(910) = -rxt(114)*y(36)
         mat(1234) = -rxt(196)*y(36)
         mat(1158) = -rxt(197)*y(36)

         mat(1136) = rxt(186)*y(34)
         mat(1098) = rxt(185)*y(34)
         mat(769) = rxt(186)*y(16) + rxt(185)*y(21)

         mat(400) = -(rxt(198)*y(2) + (rxt(385) + rxt(396)) * y(30))
         mat(1157) = -rxt(198)*y(37)
         mat(889) = -(rxt(385) + rxt(396)) * y(37)

         mat(1097) = rxt(189)*y(35)
         mat(1046) = rxt(189)*y(21)

         mat(297) = -(rxt(199)*y(2))
         mat(1155) = -rxt(199)*y(38)

         mat(1016) = rxt(191)*y(35)
         mat(1045) = rxt(191)*y(7)

         mat(500) = -(rxt(257)*y(20) + rxt(258)*y(1) + rxt(259)*y(8))
         mat(1243) = -rxt(257)*y(56)
         mat(814) = -rxt(258)*y(56)
         mat(857) = -rxt(259)*y(56)

         mat(814) = mat(814) + .070_r8*rxt(304)*y(80)
         mat(441) = .070_r8*rxt(304)*y(1)

         mat(440) = -(rxt(303)*y(20) + rxt(304)*y(1) + rxt(305)*y(8))
         mat(1238) = -rxt(303)*y(80)
         mat(812) = -rxt(304)*y(80)
         mat(854) = -rxt(305)*y(80)

         mat(379) = -(rxt(265)*y(6) + rxt(266)*y(21))
         mat(946) = -rxt(265)*y(61)
         mat(1095) = -rxt(266)*y(61)

         mat(1232) = rxt(257)*y(56) + .500_r8*rxt(267)*y(62)
         mat(499) = rxt(257)*y(20)
         mat(282) = .500_r8*rxt(267)*y(20)

         mat(561) = -(rxt(244)*y(20) + rxt(245)*y(8))
         mat(1249) = -rxt(244)*y(47)
         mat(862) = -rxt(245)*y(47)

         mat(819) = .500_r8*rxt(258)*y(56) + .040_r8*rxt(280)*y(74)
         mat(956) = rxt(265)*y(61) + rxt(278)*y(70) + .400_r8*rxt(319)*y(81) &
                      + rxt(282)*y(71) + rxt(239)*y(43) + .270_r8*rxt(260)*y(58)
         mat(1249) = mat(1249) + .500_r8*rxt(243)*y(44) + rxt(254)*y(48)
         mat(745) = .800_r8*rxt(241)*y(43)
         mat(503) = .500_r8*rxt(258)*y(1)
         mat(381) = rxt(265)*y(6)
         mat(147) = rxt(278)*y(6)
         mat(364) = .400_r8*rxt(319)*y(6)
         mat(347) = rxt(282)*y(6)
         mat(613) = .040_r8*rxt(280)*y(1)
         mat(392) = rxt(239)*y(6) + .800_r8*rxt(241)*y(13) + 3.200_r8*rxt(242)*y(43)
         mat(138) = .500_r8*rxt(243)*y(20)
         mat(425) = .270_r8*rxt(260)*y(6)
         mat(112) = rxt(254)*y(20)


      end subroutine nlnmat04

      subroutine nlnmat05( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(314) = -(rxt(238)*y(20))
         mat(1224) = -rxt(238)*y(46)

         mat(809) = .250_r8*rxt(258)*y(56) + .200_r8*rxt(304)*y(80)
         mat(736) = .100_r8*rxt(249)*y(45)
         mat(1088) = .250_r8*rxt(248)*y(45) + .250_r8*rxt(296)*y(73)
         mat(498) = .250_r8*rxt(258)*y(1)
         mat(439) = .200_r8*rxt(304)*y(1)
         mat(691) = .100_r8*rxt(249)*y(13) + .250_r8*rxt(248)*y(21)
         mat(673) = .250_r8*rxt(296)*y(21)

         mat(281) = -(rxt(267)*y(20))
         mat(1221) = -rxt(267)*y(62)

         mat(1086) = rxt(266)*y(61)
         mat(378) = rxt(266)*y(21)

         mat(703) = -(rxt(246)*y(6) + rxt(247)*y(7) + rxt(248)*y(21) + rxt(249)*y(13) &
                      + 4._r8*rxt(250)*y(45) + rxt(292)*y(76) + rxt(311)*y(85) + rxt(326) &
                      *y(88))
         mat(964) = -rxt(246)*y(45)
         mat(1025) = -rxt(247)*y(45)
         mat(1117) = -rxt(248)*y(45)
         mat(753) = -rxt(249)*y(45)
         mat(638) = -rxt(292)*y(45)
         mat(660) = -rxt(311)*y(45)
         mat(600) = -rxt(326)*y(45)

         mat(964) = mat(964) + rxt(282)*y(71) + .530_r8*rxt(287)*y(76) + rxt(294) &
                      *y(73) + rxt(269)*y(64)
         mat(1257) = rxt(244)*y(47) + .500_r8*rxt(251)*y(51) + rxt(274)*y(65)
         mat(870) = rxt(245)*y(47) + .530_r8*rxt(289)*y(76) + rxt(295)*y(73) &
                      + rxt(275)*y(65)
         mat(753) = mat(753) + .260_r8*rxt(291)*y(76) + rxt(297)*y(73) &
                      + .300_r8*rxt(271)*y(64)
         mat(562) = rxt(244)*y(20) + rxt(245)*y(8)
         mat(703) = mat(703) + .530_r8*rxt(292)*y(76)
         mat(249) = .500_r8*rxt(251)*y(20)
         mat(348) = rxt(282)*y(6)
         mat(638) = mat(638) + .530_r8*rxt(287)*y(6) + .530_r8*rxt(289)*y(8) &
                      + .260_r8*rxt(291)*y(13) + .530_r8*rxt(292)*y(45)
         mat(677) = rxt(294)*y(6) + rxt(295)*y(8) + rxt(297)*y(13) + 4.000_r8*rxt(299) &
                      *y(73)
         mat(545) = rxt(269)*y(6) + .300_r8*rxt(271)*y(13)
         mat(585) = rxt(274)*y(20) + rxt(275)*y(8)

         mat(248) = -(rxt(251)*y(20))
         mat(1216) = -rxt(251)*y(51)

         mat(1082) = .750_r8*rxt(248)*y(45) + .750_r8*rxt(296)*y(73)
         mat(690) = .750_r8*rxt(248)*y(21)
         mat(671) = .750_r8*rxt(296)*y(21)

         mat(218) = -(rxt(256)*y(20))
         mat(1213) = -rxt(256)*y(55)

         mat(1013) = rxt(247)*y(45)
         mat(689) = rxt(247)*y(7)

         mat(191) = -(rxt(276)*y(20))
         mat(1208) = -rxt(276)*y(79)

         mat(935) = .100_r8*rxt(319)*y(81)
         mat(849) = rxt(259)*y(56)
         mat(497) = rxt(259)*y(8)
         mat(357) = .100_r8*rxt(319)*y(6)

         mat(119) = -(rxt(229)*y(25) + rxt(231)*y(20))
         mat(983) = -rxt(229)*y(42)
         mat(1196) = -rxt(231)*y(42)

         mat(157) = -(rxt(232)*y(20) + rxt(237)*y(1))
         mat(1202) = -rxt(232)*y(41)
         mat(806) = -rxt(237)*y(41)

         mat(40) = -(rxt(315)*y(20))
         mat(1181) = -rxt(315)*y(68)

         mat(289) = -(rxt(302)*y(20))
         mat(1222) = -rxt(302)*y(78)

         mat(1015) = rxt(300)*y(73)
         mat(672) = rxt(300)*y(7)

         mat(43) = -(rxt(277)*y(20))
         mat(1182) = -rxt(277)*y(67)

         mat(145) = -(rxt(278)*y(6))
         mat(931) = -rxt(278)*y(70)

         mat(1200) = rxt(277)*y(67)
         mat(44) = rxt(277)*y(20)

         mat(361) = -(rxt(319)*y(6) + rxt(320)*y(21))
         mat(944) = -rxt(319)*y(81)
         mat(1093) = -rxt(320)*y(81)

         mat(1230) = rxt(315)*y(68) + rxt(321)*y(82)
         mat(41) = rxt(315)*y(20)
         mat(337) = rxt(321)*y(20)

         mat(335) = -(rxt(321)*y(20))
         mat(1227) = -rxt(321)*y(82)

         mat(1090) = rxt(320)*y(81)
         mat(359) = rxt(320)*y(21)

         mat(213) = -(rxt(281)*y(20))
         mat(1212) = -rxt(281)*y(69)

         mat(936) = .800_r8*rxt(319)*y(81)
         mat(358) = .800_r8*rxt(319)*y(6)

         mat(346) = -(rxt(282)*y(6) + rxt(283)*y(21))
         mat(942) = -rxt(282)*y(71)
         mat(1091) = -rxt(283)*y(71)

         mat(1228) = rxt(281)*y(69) + rxt(284)*y(72)
         mat(214) = rxt(281)*y(20)
         mat(153) = rxt(284)*y(20)

         mat(152) = -(rxt(284)*y(20))
         mat(1201) = -rxt(284)*y(72)

         mat(1071) = rxt(283)*y(71)
         mat(345) = rxt(283)*y(21)

         mat(68) = -(rxt(329)*y(20))
         mat(1189) = -rxt(329)*y(91)

         mat(73) = -(rxt(333)*y(20))
         mat(1190) = -rxt(333)*y(92)

         mat(1190) = mat(1190) + .250_r8*rxt(329)*y(91)
         mat(69) = .250_r8*rxt(329)*y(20)

         mat(259) = -(rxt(330)*y(6) + rxt(331)*y(21))
         mat(939) = -rxt(330)*y(93)
         mat(1083) = -rxt(331)*y(93)

         mat(1218) = .700_r8*rxt(329)*y(91) + rxt(332)*y(94)
         mat(70) = .700_r8*rxt(329)*y(20)
         mat(202) = rxt(332)*y(20)

         mat(201) = -(rxt(332)*y(20))
         mat(1210) = -rxt(332)*y(94)

         mat(1077) = rxt(331)*y(93)
         mat(258) = rxt(331)*y(21)

         mat(90) = -(rxt(334)*y(7))
         mat(1009) = -rxt(334)*y(95)

         mat(1192) = rxt(333)*y(92)
         mat(74) = rxt(333)*y(20)

         mat(486) = -(rxt(344)*y(6) + rxt(345)*y(21))
         mat(951) = -rxt(344)*y(103)
         mat(1103) = -rxt(345)*y(103)

         mat(1242) = rxt(346)*y(104) + rxt(341)*y(102)
         mat(856) = rxt(343)*y(102)
         mat(235) = rxt(346)*y(20)
         mat(319) = rxt(341)*y(20) + rxt(343)*y(8)

         mat(233) = -(rxt(346)*y(20))
         mat(1215) = -rxt(346)*y(104)

         mat(1080) = rxt(345)*y(103)
         mat(484) = rxt(345)*y(21)


         mat(940) = .900_r8*rxt(330)*y(93) + .900_r8*rxt(337)*y(97) + .620_r8*rxt(340) &
                      *y(100)
         mat(1014) = .700_r8*rxt(334)*y(95)
         mat(260) = .900_r8*rxt(330)*y(6)
         mat(91) = .700_r8*rxt(334)*y(7)
         mat(182) = .900_r8*rxt(337)*y(6)
         mat(227) = .620_r8*rxt(340)*y(6)

         mat(353) = -(rxt(253)*y(20))
         mat(1229) = -rxt(253)*y(50)

         mat(943) = .450_r8*rxt(330)*y(93) + .900_r8*rxt(337)*y(97) + .340_r8*rxt(340) &
                      *y(100) + .250_r8*rxt(322)*y(88)
         mat(1229) = mat(1229) + .200_r8*rxt(252)*y(49) + .650_r8*rxt(230)*y(125)
         mat(851) = .250_r8*rxt(323)*y(88)
         mat(737) = .100_r8*rxt(325)*y(88)
         mat(692) = .250_r8*rxt(326)*y(88)
         mat(261) = .450_r8*rxt(330)*y(6)
         mat(183) = .900_r8*rxt(337)*y(6)
         mat(228) = .340_r8*rxt(340)*y(6)
         mat(415) = .200_r8*rxt(252)*y(20)
         mat(594) = .250_r8*rxt(322)*y(6) + .250_r8*rxt(323)*y(8) + .100_r8*rxt(325) &
                      *y(13) + .250_r8*rxt(326)*y(45)
         mat(84) = .650_r8*rxt(230)*y(20)

         mat(46) = -(rxt(335)*y(20))
         mat(1183) = -rxt(335)*y(96)

         mat(181) = -(rxt(336)*y(21) + rxt(337)*y(6))
         mat(1074) = -rxt(336)*y(97)
         mat(933) = -rxt(337)*y(97)

         mat(1206) = rxt(335)*y(96)
         mat(47) = rxt(335)*y(20)


         mat(1064) = rxt(336)*y(97)
         mat(180) = rxt(336)*y(21)

         mat(49) = -(rxt(338)*y(20))
         mat(1184) = -rxt(338)*y(99)

         mat(226) = -(rxt(339)*y(21) + rxt(340)*y(6))
         mat(1079) = -rxt(339)*y(100)
         mat(937) = -rxt(340)*y(100)

         mat(1214) = rxt(338)*y(99)
         mat(50) = rxt(338)*y(20)


         mat(1065) = rxt(339)*y(100)
         mat(225) = rxt(339)*y(21)

         mat(658) = -(rxt(306)*y(6) + rxt(307)*y(8) + rxt(308)*y(21) + rxt(310)*y(13) &
                      + rxt(311)*y(45))
         mat(962) = -rxt(306)*y(85)
         mat(868) = -rxt(307)*y(85)
         mat(1115) = -rxt(308)*y(85)
         mat(751) = -rxt(310)*y(85)
         mat(701) = -rxt(311)*y(85)

         mat(1255) = rxt(303)*y(80) + .200_r8*rxt(309)*y(90)
         mat(446) = rxt(303)*y(20)
         mat(277) = .200_r8*rxt(309)*y(20)

         mat(615) = -(rxt(279)*y(20) + rxt(280)*y(1))
         mat(1253) = -rxt(279)*y(74)
         mat(823) = -rxt(280)*y(74)

         mat(823) = mat(823) + .200_r8*rxt(304)*y(80) + rxt(342)*y(102)
         mat(960) = rxt(344)*y(103) + .320_r8*rxt(306)*y(85) + .039_r8*rxt(312)*y(86)
         mat(866) = .350_r8*rxt(307)*y(85) + .039_r8*rxt(313)*y(86)
         mat(749) = .260_r8*rxt(310)*y(85)
         mat(1113) = .039_r8*rxt(314)*y(86)
         mat(445) = .200_r8*rxt(304)*y(1)
         mat(699) = .350_r8*rxt(311)*y(85)
         mat(489) = rxt(344)*y(6)
         mat(656) = .320_r8*rxt(306)*y(6) + .350_r8*rxt(307)*y(8) + .260_r8*rxt(310) &
                      *y(13) + .350_r8*rxt(311)*y(45)
         mat(321) = rxt(342)*y(1)
         mat(520) = .039_r8*rxt(312)*y(6) + .039_r8*rxt(313)*y(8) + .039_r8*rxt(314) &
                      *y(21)

         mat(571) = -(rxt(285)*y(20) + rxt(286)*y(1))
         mat(1250) = -rxt(285)*y(75)
         mat(820) = -rxt(286)*y(75)

         mat(820) = mat(820) + .400_r8*rxt(304)*y(80) + rxt(342)*y(102)
         mat(957) = rxt(344)*y(103) + .230_r8*rxt(306)*y(85) + .167_r8*rxt(312)*y(86)
         mat(863) = .250_r8*rxt(307)*y(85) + .167_r8*rxt(313)*y(86)
         mat(746) = .190_r8*rxt(310)*y(85)
         mat(1110) = .167_r8*rxt(314)*y(86)
         mat(444) = .400_r8*rxt(304)*y(1)
         mat(696) = .250_r8*rxt(311)*y(85)
         mat(488) = rxt(344)*y(6)
         mat(653) = .230_r8*rxt(306)*y(6) + .250_r8*rxt(307)*y(8) + .190_r8*rxt(310) &
                      *y(13) + .250_r8*rxt(311)*y(45)
         mat(320) = rxt(342)*y(1)
         mat(518) = .167_r8*rxt(312)*y(6) + .167_r8*rxt(313)*y(8) + .167_r8*rxt(314) &
                      *y(21)


      end subroutine nlnmat05

      subroutine nlnmat06( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(636) = -((rxt(287) + rxt(288)) * y(6) + rxt(289)*y(8) + rxt(290)*y(21) &
                      + rxt(291)*y(13) + rxt(292)*y(45))
         mat(961) = -(rxt(287) + rxt(288)) * y(76)
         mat(867) = -rxt(289)*y(76)
         mat(1114) = -rxt(290)*y(76)
         mat(750) = -rxt(291)*y(76)
         mat(700) = -rxt(292)*y(76)

         mat(1254) = rxt(279)*y(74) + .500_r8*rxt(285)*y(75) + .200_r8*rxt(293)*y(77)
         mat(616) = rxt(279)*y(20)
         mat(573) = .500_r8*rxt(285)*y(20)
         mat(132) = .200_r8*rxt(293)*y(20)

         mat(131) = -(rxt(293)*y(20))
         mat(1197) = -rxt(293)*y(77)

         mat(1068) = rxt(290)*y(76)
         mat(628) = rxt(290)*y(21)

         mat(676) = -(rxt(294)*y(6) + rxt(295)*y(8) + rxt(296)*y(21) + rxt(297)*y(13) &
                      + rxt(298)*y(45) + 4._r8*rxt(299)*y(73) + rxt(300)*y(7))
         mat(963) = -rxt(294)*y(73)
         mat(869) = -rxt(295)*y(73)
         mat(1116) = -rxt(296)*y(73)
         mat(752) = -rxt(297)*y(73)
         mat(702) = -rxt(298)*y(73)
         mat(1024) = -rxt(300)*y(73)

         mat(826) = .200_r8*rxt(304)*y(80)
         mat(1256) = .500_r8*rxt(285)*y(75) + .500_r8*rxt(293)*y(77)
         mat(447) = .200_r8*rxt(304)*y(1)
         mat(574) = .500_r8*rxt(285)*y(20)
         mat(133) = .500_r8*rxt(293)*y(20)

         mat(391) = -(rxt(239)*y(6) + rxt(240)*y(21) + rxt(241)*y(13) + 4._r8*rxt(242) &
                      *y(43))
         mat(947) = -rxt(239)*y(43)
         mat(1096) = -rxt(240)*y(43)
         mat(739) = -rxt(241)*y(43)

         mat(1233) = rxt(231)*y(42) + .500_r8*rxt(243)*y(44)
         mat(985) = rxt(229)*y(42)
         mat(120) = rxt(231)*y(20) + rxt(229)*y(25)
         mat(137) = .500_r8*rxt(243)*y(20)

         mat(136) = -(rxt(243)*y(20))
         mat(1198) = -rxt(243)*y(44)

         mat(1069) = rxt(240)*y(43)
         mat(389) = rxt(240)*y(21)

         mat(318) = -(rxt(341)*y(20) + rxt(342)*y(1) + rxt(343)*y(8))
         mat(1225) = -rxt(341)*y(102)
         mat(810) = -rxt(342)*y(102)
         mat(850) = -rxt(343)*y(102)

         mat(61) = -(rxt(264)*y(20))
         mat(1187) = -rxt(264)*y(57)

         mat(423) = -(rxt(260)*y(6) + rxt(261)*y(21) + rxt(262)*y(13))
         mat(949) = -rxt(260)*y(58)
         mat(1100) = -rxt(261)*y(58)
         mat(741) = -rxt(262)*y(58)

         mat(1236) = rxt(264)*y(57) + rxt(263)*y(59)
         mat(62) = rxt(264)*y(20)
         mat(170) = rxt(263)*y(20)

         mat(168) = -(rxt(263)*y(20))
         mat(1204) = -rxt(263)*y(59)

         mat(1072) = rxt(261)*y(58)
         mat(421) = rxt(261)*y(21)

         mat(372) = -(rxt(268)*y(20))
         mat(1231) = -rxt(268)*y(60)

         mat(945) = .500_r8*rxt(278)*y(70) + .250_r8*rxt(319)*y(81) + .100_r8*rxt(344) &
                      *y(103) + .820_r8*rxt(260)*y(58)
         mat(738) = .820_r8*rxt(262)*y(58)
         mat(146) = .500_r8*rxt(278)*y(6)
         mat(362) = .250_r8*rxt(319)*y(6)
         mat(485) = .100_r8*rxt(344)*y(6)
         mat(422) = .820_r8*rxt(260)*y(6) + .820_r8*rxt(262)*y(13)

         mat(174) = -(rxt(272)*y(20))
         mat(1205) = -rxt(272)*y(66)

         mat(1073) = rxt(270)*y(64)
         mat(540) = rxt(270)*y(21)

         mat(254) = -(rxt(223)*y(20))
         mat(1217) = -rxt(223)*y(15)

         mat(735) = 2.000_r8*rxt(222)*y(13) + .250_r8*rxt(310)*y(85) &
                      + .250_r8*rxt(291)*y(76) + .300_r8*rxt(241)*y(43) &
                      + .500_r8*rxt(271)*y(64) + .300_r8*rxt(325)*y(88)
         mat(649) = .250_r8*rxt(310)*y(13)
         mat(629) = .250_r8*rxt(291)*y(13)
         mat(390) = .300_r8*rxt(241)*y(13)
         mat(541) = .500_r8*rxt(271)*y(13)
         mat(593) = .300_r8*rxt(325)*y(13)

         mat(111) = -(rxt(254)*y(20))
         mat(1195) = -rxt(254)*y(48)

         mat(732) = .200_r8*rxt(241)*y(43)
         mat(388) = .200_r8*rxt(241)*y(13) + .800_r8*rxt(242)*y(43)

         mat(416) = -(rxt(252)*y(20))
         mat(1235) = -rxt(252)*y(49)

         mat(948) = .530_r8*rxt(287)*y(76) + .250_r8*rxt(322)*y(88)
         mat(852) = .530_r8*rxt(289)*y(76) + .250_r8*rxt(323)*y(88)
         mat(740) = .260_r8*rxt(291)*y(76) + .100_r8*rxt(325)*y(88)
         mat(693) = .530_r8*rxt(292)*y(76) + .250_r8*rxt(326)*y(88)
         mat(630) = .530_r8*rxt(287)*y(6) + .530_r8*rxt(289)*y(8) + .260_r8*rxt(291) &
                      *y(13) + .530_r8*rxt(292)*y(45)
         mat(595) = .250_r8*rxt(322)*y(6) + .250_r8*rxt(323)*y(8) + .100_r8*rxt(325) &
                      *y(13) + .250_r8*rxt(326)*y(45)

         mat(553) = -(rxt(273)*y(20))
         mat(1248) = -rxt(273)*y(63)

         mat(955) = .220_r8*rxt(287)*y(76) + .250_r8*rxt(322)*y(88)
         mat(1248) = mat(1248) + .500_r8*rxt(267)*y(62) + .500_r8*rxt(302)*y(78)
         mat(861) = .220_r8*rxt(289)*y(76) + .250_r8*rxt(323)*y(88)
         mat(744) = .230_r8*rxt(291)*y(76) + .200_r8*rxt(271)*y(64) + .100_r8*rxt(325) &
                      *y(88)
         mat(283) = .500_r8*rxt(267)*y(20)
         mat(695) = .220_r8*rxt(292)*y(76) + .250_r8*rxt(326)*y(88)
         mat(290) = .500_r8*rxt(302)*y(20)
         mat(633) = .220_r8*rxt(287)*y(6) + .220_r8*rxt(289)*y(8) + .230_r8*rxt(291) &
                      *y(13) + .220_r8*rxt(292)*y(45)
         mat(543) = .200_r8*rxt(271)*y(13)
         mat(597) = .250_r8*rxt(322)*y(6) + .250_r8*rxt(323)*y(8) + .100_r8*rxt(325) &
                      *y(13) + .250_r8*rxt(326)*y(45)

         mat(307) = -(rxt(233)*y(6) + rxt(234)*y(21))
         mat(941) = -rxt(233)*y(52)
         mat(1087) = -rxt(234)*y(52)

         mat(1223) = rxt(232)*y(41)
         mat(159) = rxt(232)*y(20)


         mat(930) = .750_r8*rxt(233)*y(52)
         mat(306) = .750_r8*rxt(233)*y(6)


         mat(1066) = rxt(234)*y(52)
         mat(305) = rxt(234)*y(21)

         mat(165) = -(rxt(318)*y(20))
         mat(1203) = -rxt(318)*y(84)

         mat(932) = .370_r8*rxt(306)*y(85)
         mat(1203) = mat(1203) + rxt(316)*y(87)
         mat(848) = .400_r8*rxt(307)*y(85) + rxt(317)*y(87)
         mat(733) = .300_r8*rxt(310)*y(85)
         mat(688) = .400_r8*rxt(311)*y(85)
         mat(648) = .370_r8*rxt(306)*y(6) + .400_r8*rxt(307)*y(8) + .300_r8*rxt(310) &
                      *y(13) + .400_r8*rxt(311)*y(45)
         mat(475) = rxt(316)*y(20) + rxt(317)*y(8)

         mat(542) = -(rxt(269)*y(6) + rxt(270)*y(21) + rxt(271)*y(13))
         mat(954) = -rxt(269)*y(64)
         mat(1107) = -rxt(270)*y(64)
         mat(743) = -rxt(271)*y(64)

         mat(1247) = rxt(268)*y(60) + rxt(272)*y(66)
         mat(373) = rxt(268)*y(20)
         mat(175) = rxt(272)*y(20)

         mat(584) = -(rxt(274)*y(20) + rxt(275)*y(8))
         mat(1251) = -rxt(274)*y(65)
         mat(864) = -rxt(275)*y(65)

         mat(821) = .950_r8*rxt(280)*y(74) + .800_r8*rxt(286)*y(75)
         mat(958) = .450_r8*rxt(330)*y(93) + .540_r8*rxt(340)*y(100) &
                      + .250_r8*rxt(287)*y(76) + .250_r8*rxt(322)*y(88)
         mat(1251) = mat(1251) + rxt(276)*y(79) + rxt(273)*y(63)
         mat(864) = mat(864) + .250_r8*rxt(289)*y(76) + .250_r8*rxt(323)*y(88)
         mat(747) = .240_r8*rxt(291)*y(76) + .500_r8*rxt(271)*y(64) + .100_r8*rxt(325) &
                      *y(88)
         mat(697) = .250_r8*rxt(292)*y(76) + .250_r8*rxt(326)*y(88)
         mat(192) = rxt(276)*y(20)
         mat(262) = .450_r8*rxt(330)*y(6)
         mat(229) = .540_r8*rxt(340)*y(6)
         mat(614) = .950_r8*rxt(280)*y(1)
         mat(572) = .800_r8*rxt(286)*y(1)
         mat(634) = .250_r8*rxt(287)*y(6) + .250_r8*rxt(289)*y(8) + .240_r8*rxt(291) &
                      *y(13) + .250_r8*rxt(292)*y(45)
         mat(554) = rxt(273)*y(20)
         mat(544) = .500_r8*rxt(271)*y(13)
         mat(598) = .250_r8*rxt(322)*y(6) + .250_r8*rxt(323)*y(8) + .100_r8*rxt(325) &
                      *y(13) + .250_r8*rxt(326)*y(45)

         mat(516) = -(rxt(312)*y(6) + rxt(313)*y(8) + rxt(314)*y(21))
         mat(952) = -rxt(312)*y(86)
         mat(858) = -rxt(313)*y(86)
         mat(1104) = -rxt(314)*y(86)

         mat(858) = mat(858) + rxt(305)*y(80)
         mat(442) = rxt(305)*y(8)

         mat(476) = -(rxt(316)*y(20) + rxt(317)*y(8))
         mat(1241) = -rxt(316)*y(87)
         mat(855) = -rxt(317)*y(87)

         mat(950) = .080_r8*rxt(306)*y(85) + .800_r8*rxt(288)*y(76) + .794_r8*rxt(312) &
                      *y(86)
         mat(855) = mat(855) + .794_r8*rxt(313)*y(86)
         mat(1102) = .794_r8*rxt(314)*y(86)
         mat(651) = .080_r8*rxt(306)*y(6)
         mat(631) = .800_r8*rxt(288)*y(6)
         mat(515) = .794_r8*rxt(312)*y(6) + .794_r8*rxt(313)*y(8) + .794_r8*rxt(314) &
                      *y(21)

         mat(599) = -(rxt(322)*y(6) + rxt(323)*y(8) + rxt(324)*y(21) + rxt(325)*y(13) &
                      + rxt(326)*y(45))
         mat(959) = -rxt(322)*y(88)
         mat(865) = -rxt(323)*y(88)
         mat(1112) = -rxt(324)*y(88)
         mat(748) = -rxt(325)*y(88)
         mat(698) = -rxt(326)*y(88)

         mat(1252) = rxt(318)*y(84) + rxt(327)*y(89) + .800_r8*rxt(309)*y(90)
         mat(166) = rxt(318)*y(20)
         mat(142) = rxt(327)*y(20)
         mat(275) = .800_r8*rxt(309)*y(20)

         mat(141) = -((rxt(327) + rxt(328)) * y(20))
         mat(1199) = -(rxt(327) + rxt(328)) * y(89)

         mat(1070) = rxt(314)*y(86) + rxt(324)*y(88)
         mat(514) = rxt(314)*y(21)
         mat(592) = rxt(324)*y(21)

         mat(273) = -(rxt(309)*y(20))
         mat(1220) = -rxt(309)*y(90)

         mat(1085) = rxt(308)*y(85)
         mat(650) = rxt(308)*y(21)

         mat(82) = -(rxt(230)*y(20))
         mat(1191) = -rxt(230)*y(125)

         mat(187) = -(rxt(225)*y(20))
         mat(1207) = -rxt(225)*y(126)

         mat(807) = .500_r8*rxt(237)*y(41)
         mat(934) = rxt(227)*y(127)
         mat(1207) = mat(1207) + .350_r8*rxt(230)*y(125)
         mat(1075) = rxt(228)*y(127)
         mat(158) = .500_r8*rxt(237)*y(1)
         mat(83) = .350_r8*rxt(230)*y(20)
         mat(240) = rxt(227)*y(6) + rxt(228)*y(21)


      end subroutine nlnmat06

      subroutine nlnmat07( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(241) = -(rxt(227)*y(6) + rxt(228)*y(21))
         mat(938) = -rxt(227)*y(127)
         mat(1081) = -rxt(228)*y(127)

         mat(1135) = rxt(218)*y(21)
         mat(1081) = mat(1081) + rxt(218)*y(16)

         mat(66) = -(rxt(352)*y(20))
         mat(1188) = -rxt(352)*y(142)

         mat(1188) = mat(1188) + (rxt(353)+.500_r8*rxt(354))*y(143)
         mat(845) = rxt(355)*y(143)
         mat(102) = (rxt(353)+.500_r8*rxt(354))*y(20) + rxt(355)*y(8)

         mat(103) = -((rxt(353) + rxt(354)) * y(20) + rxt(355)*y(8))
         mat(1194) = -(rxt(353) + rxt(354)) * y(143)
         mat(846) = -rxt(355)*y(143)


         mat(1180) = rxt(352)*y(142)
         mat(65) = rxt(352)*y(20)

         mat(52) = -(rxt(356)*y(20))
         mat(1185) = -rxt(356)*y(145)
      end subroutine nlnmat07
      subroutine nlnmat_finit( mat, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(inout) :: mat(nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
         mat( 1) = lmat( 1)
         mat( 2) = lmat( 2)
         mat( 3) = lmat( 3)
         mat( 4) = lmat( 4)
         mat( 5) = lmat( 5)
         mat( 6) = lmat( 6)
         mat( 7) = lmat( 7)
         mat( 8) = lmat( 8)
         mat( 9) = lmat( 9)
         mat( 10) = lmat( 10)
         mat( 11) = lmat( 11)
         mat( 12) = lmat( 12)
         mat( 13) = lmat( 13)
         mat( 14) = lmat( 14)
         mat( 15) = lmat( 15)
         mat( 16) = lmat( 16)
         mat( 17) = lmat( 17)
         mat( 18) = lmat( 18)
         mat( 19) = lmat( 19)
         mat( 20) = lmat( 20)
         mat( 21) = lmat( 21)
         mat( 22) = lmat( 22)
         mat( 23) = lmat( 23)
         mat( 24) = lmat( 24)
         mat( 25) = lmat( 25)
         mat( 26) = lmat( 26)
         mat( 27) = lmat( 27)
         mat( 28) = lmat( 28)
         mat( 29) = lmat( 29)
         mat( 30) = lmat( 30)
         mat( 31) = lmat( 31)
         mat( 32) = lmat( 32)
         mat( 33) = lmat( 33)
         mat( 34) = lmat( 34)
         mat( 35) = lmat( 35)
         mat( 36) = lmat( 36)
         mat( 37) = lmat( 37)
         mat( 38) = lmat( 38)
         mat( 39) = lmat( 39)
         mat( 40) = mat( 40) + lmat( 40)
         mat( 43) = mat( 43) + lmat( 43)
         mat( 46) = mat( 46) + lmat( 46)
         mat( 49) = mat( 49) + lmat( 49)
         mat( 52) = mat( 52) + lmat( 52)
         mat( 55) = mat( 55) + lmat( 55)
         mat( 58) = lmat( 58)
         mat( 59) = lmat( 59)
         mat( 60) = lmat( 60)
         mat( 61) = mat( 61) + lmat( 61)
         mat( 66) = mat( 66) + lmat( 66)
         mat( 68) = mat( 68) + lmat( 68)
         mat( 73) = mat( 73) + lmat( 73)
         mat( 76) = lmat( 76)
         mat( 77) = lmat( 77)
         mat( 78) = lmat( 78)
         mat( 79) = lmat( 79)
         mat( 80) = lmat( 80)
         mat( 81) = lmat( 81)
         mat( 82) = mat( 82) + lmat( 82)
         mat( 88) = lmat( 88)
         mat( 89) = lmat( 89)
         mat( 90) = mat( 90) + lmat( 90)
         mat( 94) = mat( 94) + lmat( 94)
         mat( 95) = mat( 95) + lmat( 95)
         mat( 97) = mat( 97) + lmat( 97)
         mat( 98) = mat( 98) + lmat( 98)
         mat( 103) = mat( 103) + lmat( 103)
         mat( 108) = lmat( 108)
         mat( 109) = lmat( 109)
         mat( 110) = lmat( 110)
         mat( 111) = mat( 111) + lmat( 111)
         mat( 115) = lmat( 115)
         mat( 116) = lmat( 116)
         mat( 117) = lmat( 117)
         mat( 118) = lmat( 118)
         mat( 119) = mat( 119) + lmat( 119)
         mat( 125) = lmat( 125)
         mat( 126) = lmat( 126)
         mat( 127) = lmat( 127)
         mat( 128) = lmat( 128)
         mat( 129) = lmat( 129)
         mat( 130) = lmat( 130)
         mat( 131) = mat( 131) + lmat( 131)
         mat( 136) = mat( 136) + lmat( 136)
         mat( 138) = mat( 138) + lmat( 138)
         mat( 139) = lmat( 139)
         mat( 140) = mat( 140) + lmat( 140)
         mat( 141) = mat( 141) + lmat( 141)
         mat( 144) = mat( 144) + lmat( 144)
         mat( 145) = mat( 145) + lmat( 145)
         mat( 152) = mat( 152) + lmat( 152)
         mat( 154) = lmat( 154)
         mat( 155) = lmat( 155)
         mat( 156) = mat( 156) + lmat( 156)
         mat( 157) = mat( 157) + lmat( 157)
         mat( 165) = mat( 165) + lmat( 165)
         mat( 168) = mat( 168) + lmat( 168)
         mat( 169) = lmat( 169)
         mat( 172) = lmat( 172)
         mat( 173) = mat( 173) + lmat( 173)
         mat( 174) = mat( 174) + lmat( 174)
         mat( 176) = lmat( 176)
         mat( 178) = lmat( 178)
         mat( 179) = mat( 179) + lmat( 179)
         mat( 181) = mat( 181) + lmat( 181)
         mat( 187) = mat( 187) + lmat( 187)
         mat( 191) = mat( 191) + lmat( 191)
         mat( 195) = mat( 195) + lmat( 195)
         mat( 197) = lmat( 197)
         mat( 198) = mat( 198) + lmat( 198)
         mat( 199) = lmat( 199)
         mat( 200) = mat( 200) + lmat( 200)
         mat( 201) = mat( 201) + lmat( 201)
         mat( 203) = lmat( 203)
         mat( 204) = lmat( 204)
         mat( 205) = lmat( 205)
         mat( 206) = mat( 206) + lmat( 206)
         mat( 207) = mat( 207) + lmat( 207)
         mat( 209) = lmat( 209)
         mat( 211) = mat( 211) + lmat( 211)
         mat( 212) = mat( 212) + lmat( 212)
         mat( 213) = mat( 213) + lmat( 213)
         mat( 215) = lmat( 215)
         mat( 216) = lmat( 216)
         mat( 218) = mat( 218) + lmat( 218)
         mat( 219) = lmat( 219)
         mat( 220) = lmat( 220)
         mat( 221) = mat( 221) + lmat( 221)
         mat( 222) = lmat( 222)
         mat( 226) = mat( 226) + lmat( 226)
         mat( 233) = mat( 233) + lmat( 233)
         mat( 234) = lmat( 234)
         mat( 236) = lmat( 236)
         mat( 237) = lmat( 237)
         mat( 238) = lmat( 238)
         mat( 239) = mat( 239) + lmat( 239)
         mat( 241) = mat( 241) + lmat( 241)
         mat( 245) = mat( 245) + lmat( 245)
         mat( 246) = lmat( 246)
         mat( 248) = mat( 248) + lmat( 248)
         mat( 251) = lmat( 251)
         mat( 253) = mat( 253) + lmat( 253)
         mat( 254) = mat( 254) + lmat( 254)
         mat( 259) = mat( 259) + lmat( 259)
         mat( 267) = lmat( 267)
         mat( 268) = lmat( 268)
         mat( 269) = lmat( 269)
         mat( 270) = lmat( 270)
         mat( 271) = lmat( 271)
         mat( 272) = lmat( 272)
         mat( 273) = mat( 273) + lmat( 273)
         mat( 274) = lmat( 274)
         mat( 276) = lmat( 276)
         mat( 278) = lmat( 278)
         mat( 279) = lmat( 279)
         mat( 281) = mat( 281) + lmat( 281)
         mat( 284) = lmat( 284)
         mat( 286) = lmat( 286)
         mat( 287) = lmat( 287)
         mat( 288) = mat( 288) + lmat( 288)
         mat( 289) = mat( 289) + lmat( 289)
         mat( 291) = lmat( 291)
         mat( 293) = lmat( 293)
         mat( 297) = mat( 297) + lmat( 297)
         mat( 298) = lmat( 298)
         mat( 299) = lmat( 299)
         mat( 300) = lmat( 300)
         mat( 301) = mat( 301) + lmat( 301)
         mat( 302) = lmat( 302)
         mat( 303) = mat( 303) + lmat( 303)
         mat( 307) = mat( 307) + lmat( 307)
         mat( 314) = mat( 314) + lmat( 314)
         mat( 318) = mat( 318) + lmat( 318)
         mat( 327) = mat( 327) + lmat( 327)
         mat( 333) = mat( 333) + lmat( 333)
         mat( 334) = lmat( 334)
         mat( 335) = mat( 335) + lmat( 335)
         mat( 338) = lmat( 338)
         mat( 340) = lmat( 340)
         mat( 342) = lmat( 342)
         mat( 343) = lmat( 343)
         mat( 344) = mat( 344) + lmat( 344)
         mat( 346) = mat( 346) + lmat( 346)
         mat( 353) = mat( 353) + lmat( 353)
         mat( 354) = mat( 354) + lmat( 354)
         mat( 355) = mat( 355) + lmat( 355)
         mat( 361) = mat( 361) + lmat( 361)
         mat( 372) = mat( 372) + lmat( 372)
         mat( 374) = lmat( 374)
         mat( 376) = lmat( 376)
         mat( 379) = mat( 379) + lmat( 379)
         mat( 391) = mat( 391) + lmat( 391)
         mat( 400) = mat( 400) + lmat( 400)
         mat( 402) = lmat( 402)
         mat( 407) = mat( 407) + lmat( 407)
         mat( 408) = mat( 408) + lmat( 408)
         mat( 410) = lmat( 410)
         mat( 411) = mat( 411) + lmat( 411)
         mat( 416) = mat( 416) + lmat( 416)
         mat( 417) = lmat( 417)
         mat( 418) = mat( 418) + lmat( 418)
         mat( 419) = mat( 419) + lmat( 419)
         mat( 423) = mat( 423) + lmat( 423)
         mat( 434) = mat( 434) + lmat( 434)
         mat( 437) = lmat( 437)
         mat( 438) = mat( 438) + lmat( 438)
         mat( 440) = mat( 440) + lmat( 440)
         mat( 456) = mat( 456) + lmat( 456)
         mat( 460) = mat( 460) + lmat( 460)
         mat( 462) = mat( 462) + lmat( 462)
         mat( 464) = mat( 464) + lmat( 464)
         mat( 465) = mat( 465) + lmat( 465)
         mat( 466) = mat( 466) + lmat( 466)
         mat( 468) = mat( 468) + lmat( 468)
         mat( 469) = mat( 469) + lmat( 469)
         mat( 471) = mat( 471) + lmat( 471)
         mat( 472) = lmat( 472)
         mat( 476) = mat( 476) + lmat( 476)
         mat( 477) = lmat( 477)
         mat( 480) = mat( 480) + lmat( 480)
         mat( 481) = mat( 481) + lmat( 481)
         mat( 482) = lmat( 482)
         mat( 486) = mat( 486) + lmat( 486)
         mat( 500) = mat( 500) + lmat( 500)
         mat( 516) = mat( 516) + lmat( 516)
         mat( 528) = mat( 528) + lmat( 528)
         mat( 536) = mat( 536) + lmat( 536)
         mat( 542) = mat( 542) + lmat( 542)
         mat( 553) = mat( 553) + lmat( 553)
         mat( 555) = lmat( 555)
         mat( 556) = mat( 556) + lmat( 556)
         mat( 557) = lmat( 557)
         mat( 560) = lmat( 560)
         mat( 561) = mat( 561) + lmat( 561)
         mat( 565) = lmat( 565)
         mat( 568) = lmat( 568)
         mat( 570) = mat( 570) + lmat( 570)
         mat( 571) = mat( 571) + lmat( 571)
         mat( 574) = mat( 574) + lmat( 574)
         mat( 575) = lmat( 575)
         mat( 579) = mat( 579) + lmat( 579)
         mat( 580) = mat( 580) + lmat( 580)
         mat( 583) = mat( 583) + lmat( 583)
         mat( 584) = mat( 584) + lmat( 584)
         mat( 585) = mat( 585) + lmat( 585)
         mat( 590) = lmat( 590)
         mat( 599) = mat( 599) + lmat( 599)
         mat( 610) = lmat( 610)
         mat( 611) = mat( 611) + lmat( 611)
         mat( 615) = mat( 615) + lmat( 615)
         mat( 617) = lmat( 617)
         mat( 620) = lmat( 620)
         mat( 636) = mat( 636) + lmat( 636)
         mat( 658) = mat( 658) + lmat( 658)
         mat( 676) = mat( 676) + lmat( 676)
         mat( 703) = mat( 703) + lmat( 703)
         mat( 714) = lmat( 714)
         mat( 715) = mat( 715) + lmat( 715)
         mat( 716) = lmat( 716)
         mat( 718) = mat( 718) + lmat( 718)
         mat( 720) = lmat( 720)
         mat( 721) = mat( 721) + lmat( 721)
         mat( 724) = mat( 724) + lmat( 724)
         mat( 729) = mat( 729) + lmat( 729)
         mat( 756) = mat( 756) + lmat( 756)
         mat( 773) = mat( 773) + lmat( 773)
         mat( 793) = mat( 793) + lmat( 793)
         mat( 799) = mat( 799) + lmat( 799)
         mat( 804) = mat( 804) + lmat( 804)
         mat( 833) = mat( 833) + lmat( 833)
         mat( 836) = mat( 836) + lmat( 836)
         mat( 843) = mat( 843) + lmat( 843)
         mat( 853) = mat( 853) + lmat( 853)
         mat( 876) = mat( 876) + lmat( 876)
         mat( 879) = mat( 879) + lmat( 879)
         mat( 881) = mat( 881) + lmat( 881)
         mat( 885) = mat( 885) + lmat( 885)
         mat( 894) = lmat( 894)
         mat( 899) = mat( 899) + lmat( 899)
         mat( 902) = mat( 902) + lmat( 902)
         mat( 911) = mat( 911) + lmat( 911)
         mat( 913) = mat( 913) + lmat( 913)
         mat( 914) = lmat( 914)
         mat( 915) = mat( 915) + lmat( 915)
         mat( 920) = mat( 920) + lmat( 920)
         mat( 921) = lmat( 921)
         mat( 922) = mat( 922) + lmat( 922)
         mat( 925) = lmat( 925)
         mat( 926) = lmat( 926)
         mat( 927) = lmat( 927)
         mat( 928) = mat( 928) + lmat( 928)
         mat( 929) = mat( 929) + lmat( 929)
         mat( 974) = mat( 974) + lmat( 974)
         mat( 980) = mat( 980) + lmat( 980)
         mat( 989) = mat( 989) + lmat( 989)
         mat( 994) = lmat( 994)
         mat( 995) = lmat( 995)
         mat( 999) = mat( 999) + lmat( 999)
         mat(1002) = mat(1002) + lmat(1002)
         mat(1005) = mat(1005) + lmat(1005)
         mat(1019) = mat(1019) + lmat(1019)
         mat(1035) = mat(1035) + lmat(1035)
         mat(1037) = mat(1037) + lmat(1037)
         mat(1041) = mat(1041) + lmat(1041)
         mat(1042) = mat(1042) + lmat(1042)
         mat(1050) = mat(1050) + lmat(1050)
         mat(1059) = mat(1059) + lmat(1059)
         mat(1062) = mat(1062) + lmat(1062)
         mat(1089) = mat(1089) + lmat(1089)
         mat(1131) = mat(1131) + lmat(1131)
         mat(1138) = lmat(1138)
         mat(1139) = mat(1139) + lmat(1139)
         mat(1141) = mat(1141) + lmat(1141)
         mat(1152) = mat(1152) + lmat(1152)
         mat(1168) = mat(1168) + lmat(1168)
         mat(1178) = mat(1178) + lmat(1178)
         mat(1258) = mat(1258) + lmat(1258)
         mat(1260) = mat(1260) + lmat(1260)
         mat(1261) = mat(1261) + lmat(1261)
         mat(1268) = mat(1268) + lmat(1268)
         mat(1271) = mat(1271) + lmat(1271)
         mat(1274) = mat(1274) + lmat(1274)
         mat( 242) = 0._r8
         mat( 247) = 0._r8
         mat( 266) = 0._r8
         mat( 308) = 0._r8
         mat( 313) = 0._r8
         mat( 336) = 0._r8
         mat( 339) = 0._r8
         mat( 341) = 0._r8
         mat( 352) = 0._r8
         mat( 360) = 0._r8
         mat( 363) = 0._r8
         mat( 365) = 0._r8
         mat( 366) = 0._r8
         mat( 371) = 0._r8
         mat( 380) = 0._r8
         mat( 382) = 0._r8
         mat( 387) = 0._r8
         mat( 398) = 0._r8
         mat( 404) = 0._r8
         mat( 424) = 0._r8
         mat( 426) = 0._r8
         mat( 427) = 0._r8
         mat( 433) = 0._r8
         mat( 448) = 0._r8
         mat( 449) = 0._r8
         mat( 467) = 0._r8
         mat( 478) = 0._r8
         mat( 487) = 0._r8
         mat( 490) = 0._r8
         mat( 491) = 0._r8
         mat( 492) = 0._r8
         mat( 496) = 0._r8
         mat( 502) = 0._r8
         mat( 504) = 0._r8
         mat( 505) = 0._r8
         mat( 509) = 0._r8
         mat( 510) = 0._r8
         mat( 517) = 0._r8
         mat( 519) = 0._r8
         mat( 521) = 0._r8
         mat( 527) = 0._r8
         mat( 546) = 0._r8
         mat( 552) = 0._r8
         mat( 564) = 0._r8
         mat( 567) = 0._r8
         mat( 577) = 0._r8
         mat( 587) = 0._r8
         mat( 589) = 0._r8
         mat( 601) = 0._r8
         mat( 602) = 0._r8
         mat( 609) = 0._r8
         mat( 612) = 0._r8
         mat( 618) = 0._r8
         mat( 619) = 0._r8
         mat( 622) = 0._r8
         mat( 623) = 0._r8
         mat( 624) = 0._r8
         mat( 635) = 0._r8
         mat( 637) = 0._r8
         mat( 639) = 0._r8
         mat( 640) = 0._r8
         mat( 647) = 0._r8
         mat( 652) = 0._r8
         mat( 654) = 0._r8
         mat( 655) = 0._r8
         mat( 657) = 0._r8
         mat( 659) = 0._r8
         mat( 661) = 0._r8
         mat( 662) = 0._r8
         mat( 664) = 0._r8
         mat( 670) = 0._r8
         mat( 674) = 0._r8
         mat( 675) = 0._r8
         mat( 678) = 0._r8
         mat( 679) = 0._r8
         mat( 687) = 0._r8
         mat( 704) = 0._r8
         mat( 705) = 0._r8
         mat( 708) = 0._r8
         mat( 713) = 0._r8
         mat( 717) = 0._r8
         mat( 719) = 0._r8
         mat( 726) = 0._r8
         mat( 727) = 0._r8
         mat( 728) = 0._r8
         mat( 754) = 0._r8
         mat( 755) = 0._r8
         mat( 758) = 0._r8
         mat( 759) = 0._r8
         mat( 760) = 0._r8
         mat( 761) = 0._r8
         mat( 767) = 0._r8
         mat( 768) = 0._r8
         mat( 771) = 0._r8
         mat( 772) = 0._r8
         mat( 775) = 0._r8
         mat( 776) = 0._r8
         mat( 777) = 0._r8
         mat( 781) = 0._r8
         mat( 782) = 0._r8
         mat( 789) = 0._r8
         mat( 790) = 0._r8
         mat( 794) = 0._r8
         mat( 795) = 0._r8
         mat( 797) = 0._r8
         mat( 808) = 0._r8
         mat( 811) = 0._r8
         mat( 813) = 0._r8
         mat( 815) = 0._r8
         mat( 817) = 0._r8
         mat( 818) = 0._r8
         mat( 822) = 0._r8
         mat( 824) = 0._r8
         mat( 825) = 0._r8
         mat( 827) = 0._r8
         mat( 828) = 0._r8
         mat( 835) = 0._r8
         mat( 860) = 0._r8
         mat( 871) = 0._r8
         mat( 872) = 0._r8
         mat( 873) = 0._r8
         mat( 874) = 0._r8
         mat( 875) = 0._r8
         mat( 877) = 0._r8
         mat( 878) = 0._r8
         mat( 880) = 0._r8
         mat( 882) = 0._r8
         mat( 895) = 0._r8
         mat( 896) = 0._r8
         mat( 897) = 0._r8
         mat( 898) = 0._r8
         mat( 901) = 0._r8
         mat( 903) = 0._r8
         mat( 904) = 0._r8
         mat( 905) = 0._r8
         mat( 906) = 0._r8
         mat( 916) = 0._r8
         mat( 918) = 0._r8
         mat( 923) = 0._r8
         mat( 924) = 0._r8
         mat( 965) = 0._r8
         mat( 966) = 0._r8
         mat( 972) = 0._r8
         mat( 973) = 0._r8
         mat( 990) = 0._r8
         mat( 991) = 0._r8
         mat( 992) = 0._r8
         mat(1000) = 0._r8
         mat(1001) = 0._r8
         mat(1003) = 0._r8
         mat(1004) = 0._r8
         mat(1007) = 0._r8
         mat(1017) = 0._r8
         mat(1018) = 0._r8
         mat(1021) = 0._r8
         mat(1022) = 0._r8
         mat(1023) = 0._r8
         mat(1026) = 0._r8
         mat(1027) = 0._r8
         mat(1028) = 0._r8
         mat(1029) = 0._r8
         mat(1033) = 0._r8
         mat(1034) = 0._r8
         mat(1036) = 0._r8
         mat(1040) = 0._r8
         mat(1047) = 0._r8
         mat(1048) = 0._r8
         mat(1049) = 0._r8
         mat(1052) = 0._r8
         mat(1053) = 0._r8
         mat(1054) = 0._r8
         mat(1055) = 0._r8
         mat(1061) = 0._r8
         mat(1067) = 0._r8
         mat(1084) = 0._r8
         mat(1092) = 0._r8
         mat(1094) = 0._r8
         mat(1099) = 0._r8
         mat(1106) = 0._r8
         mat(1108) = 0._r8
         mat(1109) = 0._r8
         mat(1111) = 0._r8
         mat(1126) = 0._r8
         mat(1143) = 0._r8
         mat(1146) = 0._r8
         mat(1147) = 0._r8
         mat(1149) = 0._r8
         mat(1150) = 0._r8
         mat(1159) = 0._r8
         mat(1164) = 0._r8
         mat(1171) = 0._r8
         mat(1219) = 0._r8
         mat(1244) = 0._r8
         mat(1266) = 0._r8
         mat(1267) = 0._r8
         mat( 1) = mat( 1) - dti
         mat( 2) = mat( 2) - dti
         mat( 3) = mat( 3) - dti
         mat( 4) = mat( 4) - dti
         mat( 5) = mat( 5) - dti
         mat( 6) = mat( 6) - dti
         mat( 7) = mat( 7) - dti
         mat( 8) = mat( 8) - dti
         mat( 9) = mat( 9) - dti
         mat( 10) = mat( 10) - dti
         mat( 11) = mat( 11) - dti
         mat( 12) = mat( 12) - dti
         mat( 13) = mat( 13) - dti
         mat( 14) = mat( 14) - dti
         mat( 15) = mat( 15) - dti
         mat( 16) = mat( 16) - dti
         mat( 18) = mat( 18) - dti
         mat( 19) = mat( 19) - dti
         mat( 21) = mat( 21) - dti
         mat( 22) = mat( 22) - dti
         mat( 23) = mat( 23) - dti
         mat( 24) = mat( 24) - dti
         mat( 25) = mat( 25) - dti
         mat( 26) = mat( 26) - dti
         mat( 27) = mat( 27) - dti
         mat( 28) = mat( 28) - dti
         mat( 29) = mat( 29) - dti
         mat( 30) = mat( 30) - dti
         mat( 31) = mat( 31) - dti
         mat( 32) = mat( 32) - dti
         mat( 33) = mat( 33) - dti
         mat( 34) = mat( 34) - dti
         mat( 35) = mat( 35) - dti
         mat( 36) = mat( 36) - dti
         mat( 37) = mat( 37) - dti
         mat( 38) = mat( 38) - dti
         mat( 39) = mat( 39) - dti
         mat( 40) = mat( 40) - dti
         mat( 43) = mat( 43) - dti
         mat( 46) = mat( 46) - dti
         mat( 49) = mat( 49) - dti
         mat( 52) = mat( 52) - dti
         mat( 55) = mat( 55) - dti
         mat( 58) = mat( 58) - dti
         mat( 61) = mat( 61) - dti
         mat( 66) = mat( 66) - dti
         mat( 68) = mat( 68) - dti
         mat( 73) = mat( 73) - dti
         mat( 76) = mat( 76) - dti
         mat( 79) = mat( 79) - dti
         mat( 82) = mat( 82) - dti
         mat( 88) = mat( 88) - dti
         mat( 90) = mat( 90) - dti
         mat( 94) = mat( 94) - dti
         mat( 98) = mat( 98) - dti
         mat( 103) = mat( 103) - dti
         mat( 108) = mat( 108) - dti
         mat( 111) = mat( 111) - dti
         mat( 115) = mat( 115) - dti
         mat( 119) = mat( 119) - dti
         mat( 125) = mat( 125) - dti
         mat( 131) = mat( 131) - dti
         mat( 136) = mat( 136) - dti
         mat( 141) = mat( 141) - dti
         mat( 145) = mat( 145) - dti
         mat( 152) = mat( 152) - dti
         mat( 157) = mat( 157) - dti
         mat( 165) = mat( 165) - dti
         mat( 168) = mat( 168) - dti
         mat( 174) = mat( 174) - dti
         mat( 181) = mat( 181) - dti
         mat( 187) = mat( 187) - dti
         mat( 191) = mat( 191) - dti
         mat( 195) = mat( 195) - dti
         mat( 201) = mat( 201) - dti
         mat( 207) = mat( 207) - dti
         mat( 213) = mat( 213) - dti
         mat( 218) = mat( 218) - dti
         mat( 226) = mat( 226) - dti
         mat( 233) = mat( 233) - dti
         mat( 241) = mat( 241) - dti
         mat( 248) = mat( 248) - dti
         mat( 254) = mat( 254) - dti
         mat( 259) = mat( 259) - dti
         mat( 267) = mat( 267) - dti
         mat( 273) = mat( 273) - dti
         mat( 281) = mat( 281) - dti
         mat( 289) = mat( 289) - dti
         mat( 297) = mat( 297) - dti
         mat( 307) = mat( 307) - dti
         mat( 314) = mat( 314) - dti
         mat( 318) = mat( 318) - dti
         mat( 327) = mat( 327) - dti
         mat( 335) = mat( 335) - dti
         mat( 346) = mat( 346) - dti
         mat( 353) = mat( 353) - dti
         mat( 361) = mat( 361) - dti
         mat( 372) = mat( 372) - dti
         mat( 379) = mat( 379) - dti
         mat( 391) = mat( 391) - dti
         mat( 400) = mat( 400) - dti
         mat( 408) = mat( 408) - dti
         mat( 416) = mat( 416) - dti
         mat( 423) = mat( 423) - dti
         mat( 434) = mat( 434) - dti
         mat( 440) = mat( 440) - dti
         mat( 456) = mat( 456) - dti
         mat( 466) = mat( 466) - dti
         mat( 476) = mat( 476) - dti
         mat( 486) = mat( 486) - dti
         mat( 500) = mat( 500) - dti
         mat( 516) = mat( 516) - dti
         mat( 528) = mat( 528) - dti
         mat( 536) = mat( 536) - dti
         mat( 542) = mat( 542) - dti
         mat( 553) = mat( 553) - dti
         mat( 561) = mat( 561) - dti
         mat( 571) = mat( 571) - dti
         mat( 584) = mat( 584) - dti
         mat( 599) = mat( 599) - dti
         mat( 615) = mat( 615) - dti
         mat( 636) = mat( 636) - dti
         mat( 658) = mat( 658) - dti
         mat( 676) = mat( 676) - dti
         mat( 703) = mat( 703) - dti
         mat( 715) = mat( 715) - dti
         mat( 724) = mat( 724) - dti
         mat( 756) = mat( 756) - dti
         mat( 773) = mat( 773) - dti
         mat( 793) = mat( 793) - dti
         mat( 833) = mat( 833) - dti
         mat( 876) = mat( 876) - dti
         mat( 899) = mat( 899) - dti
         mat( 920) = mat( 920) - dti
         mat( 974) = mat( 974) - dti
         mat(1002) = mat(1002) - dti
         mat(1037) = mat(1037) - dti
         mat(1059) = mat(1059) - dti
         mat(1131) = mat(1131) - dti
         mat(1152) = mat(1152) - dti
         mat(1178) = mat(1178) - dti
         mat(1274) = mat(1274) - dti
      end subroutine nlnmat_finit
      subroutine nlnmat( mat, y, rxt, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)
      call nlnmat01( mat, y, rxt )
      call nlnmat02( mat, y, rxt )
      call nlnmat03( mat, y, rxt )
      call nlnmat04( mat, y, rxt )
      call nlnmat05( mat, y, rxt )
      call nlnmat06( mat, y, rxt )
      call nlnmat07( mat, y, rxt )
      call nlnmat_finit( mat, lmat, dti )
      end subroutine nlnmat
      end module mo_nln_matrix
