




      module mo_nln_matrix

      use shr_kind_mod, only : r8 => shr_kind_r8

      private
      public :: nlnmat

      contains

      subroutine nlnmat01( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(649) = -(rxt(46)*y(2) + rxt(49)*y(3) + rxt(59)*y(15) + rxt(64)*y(12) &
                      + rxt(72)*y(13) + rxt(79)*y(5) + rxt(82)*y(6) + rxt(118)*y(23) &
                      + rxt(139)*y(35) + rxt(161)*y(55) + rxt(167)*y(56) + rxt(185) &
                      *y(52) + rxt(223)*y(65))
         mat(536) = -rxt(46)*y(1)
         mat(441) = -rxt(49)*y(1)
         mat(404) = -rxt(59)*y(1)
         mat(757) = -rxt(64)*y(1)
         mat(892) = -rxt(72)*y(1)
         mat(936) = -rxt(79)*y(1)
         mat(671) = -rxt(82)*y(1)
         mat(156) = -rxt(118)*y(1)
         mat(428) = -rxt(139)*y(1)
         mat(551) = -rxt(161)*y(1)
         mat(500) = -rxt(167)*y(1)
         mat(394) = -rxt(185)*y(1)
         mat(288) = -rxt(223)*y(1)

         mat(649) = mat(649) + .100_r8*rxt(185)*y(52) + .200_r8*rxt(161)*y(55) &
                      + .200_r8*rxt(167)*y(56)
         mat(892) = mat(892) + .250_r8*rxt(129)*y(33) + .250_r8*rxt(177)*y(59)
         mat(814) = .250_r8*rxt(129)*y(13)
         mat(394) = mat(394) + .100_r8*rxt(185)*y(1)
         mat(551) = mat(551) + .200_r8*rxt(161)*y(1)
         mat(500) = mat(500) + .200_r8*rxt(167)*y(1)
         mat(830) = .250_r8*rxt(177)*y(13)

         mat(533) = -(rxt(46)*y(1) + rxt(63)*y(12) + rxt(70)*y(11) + rxt(71)*y(13) &
                      + rxt(74)*y(14) + rxt(77)*y(5) + (rxt(80) + rxt(81)) * y(6) &
                      + rxt(88)*y(7) + rxt(99)*y(20))
         mat(643) = -rxt(46)*y(2)
         mat(751) = -rxt(63)*y(2)
         mat(282) = -rxt(70)*y(2)
         mat(886) = -rxt(71)*y(2)
         mat(101) = -rxt(74)*y(2)
         mat(930) = -rxt(77)*y(2)
         mat(668) = -(rxt(80) + rxt(81)) * y(2)
         mat(965) = -rxt(88)*y(2)
         mat(603) = -rxt(99)*y(2)

         mat(403) = rxt(62)*y(13)
         mat(751) = mat(751) + 2.000_r8*rxt(66)*y(12)
         mat(886) = mat(886) + rxt(62)*y(15)

         mat(438) = -(rxt(49)*y(1) + rxt(51)*y(11) + rxt(57)*y(116))
         mat(635) = -rxt(49)*y(3)
         mat(281) = -rxt(51)*y(3)
         mat(88) = -rxt(57)*y(3)

         mat(617) = -((rxt(95) + rxt(96)) * y(12))
         mat(756) = -(rxt(95) + rxt(96)) * y(17)

         mat(648) = .500_r8*rxt(118)*y(23) + .560_r8*rxt(139)*y(35) + .300_r8*rxt(185) &
                      *y(52) + .050_r8*rxt(161)*y(55) + .200_r8*rxt(167)*y(56)
         mat(535) = rxt(99)*y(20)
         mat(935) = .220_r8*rxt(168)*y(57) + .500_r8*rxt(203)*y(63)
         mat(970) = rxt(97)*y(20) + .220_r8*rxt(170)*y(57) + rxt(156)*y(62) &
                      + .500_r8*rxt(204)*y(63)
         mat(756) = mat(756) + rxt(98)*y(20) + rxt(155)*y(62) + rxt(134)*y(80) &
                      + .350_r8*rxt(111)*y(118)
         mat(789) = .110_r8*rxt(172)*y(57) + .200_r8*rxt(206)*y(63)
         mat(605) = rxt(99)*y(2) + rxt(97)*y(7) + rxt(98)*y(12)
         mat(155) = .500_r8*rxt(118)*y(1)
         mat(813) = .220_r8*rxt(173)*y(57) + .500_r8*rxt(207)*y(63)
         mat(427) = .560_r8*rxt(139)*y(1)
         mat(393) = .300_r8*rxt(185)*y(1)
         mat(550) = .050_r8*rxt(161)*y(1)
         mat(499) = .200_r8*rxt(167)*y(1)
         mat(568) = .220_r8*rxt(168)*y(5) + .220_r8*rxt(170)*y(7) + .110_r8*rxt(172) &
                      *y(18) + .220_r8*rxt(173)*y(33)
         mat(507) = rxt(156)*y(7) + rxt(155)*y(12)
         mat(521) = .500_r8*rxt(203)*y(5) + .500_r8*rxt(204)*y(7) + .200_r8*rxt(206) &
                      *y(18) + .500_r8*rxt(207)*y(33)
         mat(303) = rxt(134)*y(12)
         mat(80) = .350_r8*rxt(111)*y(12)

         mat(279) = -(rxt(51)*y(3) + rxt(68)*y(12) + rxt(70)*y(2))
         mat(436) = -rxt(51)*y(11)
         mat(726) = -rxt(68)*y(11)
         mat(530) = -rxt(70)*y(11)

         mat(400) = rxt(61)*y(13)
         mat(864) = rxt(61)*y(15)

         mat(87) = -(rxt(57)*y(3) + rxt(75)*y(12))
         mat(435) = -rxt(57)*y(116)
         mat(694) = -rxt(75)*y(116)

         mat(54) = -(rxt(76)*y(12))
         mat(686) = -rxt(76)*y(117)

         mat(401) = -(rxt(59)*y(1) + (rxt(60) + rxt(61) + rxt(62)) * y(13))
         mat(632) = -rxt(59)*y(15)
         mat(875) = -(rxt(60) + rxt(61) + rxt(62)) * y(15)

         mat(531) = rxt(70)*y(11) + rxt(63)*y(12)
         mat(437) = rxt(51)*y(11)
         mat(613) = rxt(95)*y(12)
         mat(280) = rxt(70)*y(2) + rxt(51)*y(3) + rxt(68)*y(12)
         mat(739) = rxt(63)*y(2) + rxt(95)*y(17) + rxt(68)*y(11) + rxt(98)*y(20)
         mat(601) = rxt(98)*y(12)

         mat(943) = -(rxt(77)*y(2) + rxt(78)*y(13) + rxt(79)*y(1) + rxt(87)*y(7) &
                      + rxt(101)*y(18) + rxt(109)*y(120) + rxt(114)*y(25) + rxt(120) &
                      *y(30) + rxt(127)*y(33) + rxt(141)*y(37) + rxt(146)*y(39) &
                      + rxt(150)*y(42) + rxt(159)*y(45) + rxt(163)*y(47) + (rxt(168) &
                      + rxt(169)) * y(57) + rxt(175)*y(59) + rxt(187)*y(53) + rxt(193) &
                      *y(84) + rxt(200)*y(50) + rxt(203)*y(63) + rxt(211)*y(70) &
                      + rxt(218)*y(73) + rxt(221)*y(76) + rxt(225)*y(66))
         mat(541) = -rxt(77)*y(5)
         mat(899) = -rxt(78)*y(5)
         mat(656) = -rxt(79)*y(5)
         mat(978) = -rxt(87)*y(5)
         mat(797) = -rxt(101)*y(5)
         mat(197) = -rxt(109)*y(5)
         mat(301) = -rxt(114)*y(5)
         mat(366) = -rxt(120)*y(5)
         mat(821) = -rxt(127)*y(5)
         mat(384) = -rxt(141)*y(5)
         mat(338) = -rxt(146)*y(5)
         mat(488) = -rxt(150)*y(5)
         mat(170) = -rxt(159)*y(5)
         mat(324) = -rxt(163)*y(5)
         mat(575) = -(rxt(168) + rxt(169)) * y(5)
         mat(837) = -rxt(175)*y(5)
         mat(596) = -rxt(187)*y(5)
         mat(475) = -rxt(193)*y(5)
         mat(355) = -rxt(200)*y(5)
         mat(527) = -rxt(203)*y(5)
         mat(272) = -rxt(211)*y(5)
         mat(186) = -rxt(218)*y(5)
         mat(218) = -rxt(221)*y(5)
         mat(418) = -rxt(225)*y(5)

         mat(541) = mat(541) + rxt(80)*y(6)
         mat(678) = rxt(80)*y(2)

         mat(672) = -((rxt(80) + rxt(81)) * y(2) + rxt(82)*y(1) + rxt(83)*y(7) + rxt(85) &
                      *y(12) + rxt(91)*y(13) + rxt(128)*y(33) + rxt(181)*y(59) + rxt(215) &
                      *y(78))
         mat(537) = -(rxt(80) + rxt(81)) * y(6)
         mat(650) = -rxt(82)*y(6)
         mat(972) = -rxt(83)*y(6)
         mat(758) = -rxt(85)*y(6)
         mat(893) = -rxt(91)*y(6)
         mat(815) = -rxt(128)*y(6)
         mat(831) = -rxt(181)*y(6)
         mat(85) = -rxt(215)*y(6)

         mat(650) = mat(650) + rxt(79)*y(5)
         mat(537) = mat(537) + rxt(77)*y(5) + rxt(88)*y(7)
         mat(937) = rxt(79)*y(1) + rxt(77)*y(2) + 2.000_r8*rxt(87)*y(7) + rxt(78) &
                      *y(13) + rxt(101)*y(18) + rxt(114)*y(25) + rxt(120)*y(30) &
                      + rxt(127)*y(33) + rxt(141)*y(37) + rxt(146)*y(39) + rxt(150) &
                      *y(42) + rxt(159)*y(45) + .900_r8*rxt(200)*y(50) + rxt(163) &
                      *y(47) + .920_r8*rxt(187)*y(53) + rxt(168)*y(57) + rxt(175) &
                      *y(59) + rxt(203)*y(63) + rxt(225)*y(66) + .900_r8*rxt(211) &
                      *y(70) + .900_r8*rxt(218)*y(73) + .900_r8*rxt(221)*y(76) &
                      + 1.206_r8*rxt(193)*y(84) + rxt(109)*y(120)
         mat(672) = mat(672) + .700_r8*rxt(215)*y(78)
         mat(972) = mat(972) + rxt(88)*y(2) + 2.000_r8*rxt(87)*y(5) + rxt(89)*y(12) &
                      + rxt(90)*y(13) + rxt(188)*y(53) + rxt(170)*y(57) + rxt(176) &
                      *y(59) + rxt(204)*y(63) + rxt(224)*y(65) + 1.206_r8*rxt(194) &
                      *y(84) + rxt(198)*y(85)
         mat(134) = rxt(92)*y(12)
         mat(758) = mat(758) + rxt(89)*y(7) + rxt(92)*y(9) + rxt(157)*y(82) &
                      + .400_r8*rxt(197)*y(85)
         mat(893) = mat(893) + rxt(78)*y(5) + rxt(90)*y(7) + .206_r8*rxt(195)*y(84)
         mat(791) = rxt(101)*y(5)
         mat(298) = rxt(114)*y(5)
         mat(362) = rxt(120)*y(5)
         mat(815) = mat(815) + rxt(127)*y(5)
         mat(379) = rxt(141)*y(5)
         mat(335) = rxt(146)*y(5)
         mat(483) = rxt(150)*y(5)
         mat(168) = rxt(159)*y(5)
         mat(350) = .900_r8*rxt(200)*y(5)
         mat(320) = rxt(163)*y(5)
         mat(590) = .920_r8*rxt(187)*y(5) + rxt(188)*y(7)
         mat(569) = rxt(168)*y(5) + rxt(170)*y(7)
         mat(831) = mat(831) + rxt(175)*y(5) + rxt(176)*y(7)
         mat(522) = rxt(203)*y(5) + rxt(204)*y(7)
         mat(289) = rxt(224)*y(7)
         mat(413) = rxt(225)*y(5)
         mat(269) = .900_r8*rxt(211)*y(5)
         mat(85) = mat(85) + .700_r8*rxt(215)*y(6)
         mat(184) = .900_r8*rxt(218)*y(5)
         mat(216) = .900_r8*rxt(221)*y(5)
         mat(189) = rxt(157)*y(12)
         mat(472) = 1.206_r8*rxt(193)*y(5) + 1.206_r8*rxt(194)*y(7) + .206_r8*rxt(195) &
                      *y(13)
         mat(460) = rxt(198)*y(7) + .400_r8*rxt(197)*y(12)
         mat(194) = rxt(109)*y(5)

         mat(979) = -(rxt(83)*y(6) + rxt(87)*y(5) + rxt(88)*y(2) + rxt(89)*y(12) &
                      + rxt(90)*y(13) + rxt(97)*y(20) + rxt(126)*y(32) + rxt(140) &
                      *y(35) + rxt(156)*y(62) + rxt(170)*y(57) + rxt(176)*y(59) &
                      + rxt(186)*y(52) + rxt(188)*y(53) + rxt(194)*y(84) + rxt(198) &
                      *y(85) + rxt(204)*y(63) + rxt(224)*y(65) + rxt(236)*y(101))
         mat(679) = -rxt(83)*y(7)
         mat(944) = -rxt(87)*y(7)
         mat(542) = -rxt(88)*y(7)
         mat(765) = -rxt(89)*y(7)
         mat(900) = -rxt(90)*y(7)
         mat(612) = -rxt(97)*y(7)
         mat(454) = -rxt(126)*y(7)
         mat(434) = -rxt(140)*y(7)
         mat(512) = -rxt(156)*y(7)
         mat(576) = -rxt(170)*y(7)
         mat(838) = -rxt(176)*y(7)
         mat(399) = -rxt(186)*y(7)
         mat(597) = -rxt(188)*y(7)
         mat(476) = -rxt(194)*y(7)
         mat(463) = -rxt(198)*y(7)
         mat(528) = -rxt(204)*y(7)
         mat(292) = -rxt(224)*y(7)
         mat(99) = -rxt(236)*y(7)

         mat(657) = rxt(82)*y(6)
         mat(542) = mat(542) + rxt(81)*y(6)
         mat(679) = mat(679) + rxt(82)*y(1) + rxt(81)*y(2)
         mat(236) = rxt(86)*y(12)
         mat(765) = mat(765) + rxt(86)*y(8) + rxt(137)*y(81) + .500_r8*rxt(183)*y(83)
         mat(225) = rxt(137)*y(12)
         mat(251) = .500_r8*rxt(183)*y(12)


      end subroutine nlnmat01

      subroutine nlnmat02( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(233) = -(rxt(86)*y(12))
         mat(719) = -rxt(86)*y(8)

         mat(662) = rxt(85)*y(12)
         mat(950) = rxt(97)*y(20) + rxt(126)*y(32) + rxt(156)*y(62) + rxt(236)*y(101)
         mat(719) = mat(719) + rxt(85)*y(6)
         mat(599) = rxt(97)*y(7)
         mat(446) = rxt(126)*y(7)
         mat(505) = rxt(156)*y(7)
         mat(96) = rxt(236)*y(7)

         mat(133) = -(rxt(92)*y(12))
         mat(702) = -rxt(92)*y(9)

         mat(660) = rxt(91)*y(13)
         mat(848) = rxt(91)*y(6)


         mat(659) = rxt(83)*y(7)
         mat(947) = rxt(83)*y(6)

         mat(759) = -(rxt(63)*y(2) + rxt(64)*y(1) + rxt(65)*y(13) + (4._r8*rxt(66) &
                      + 4._r8*rxt(67)) * y(12) + rxt(68)*y(11) + rxt(69)*y(14) + rxt(75) &
                      *y(116) + rxt(76)*y(117) + rxt(85)*y(6) + rxt(86)*y(8) + rxt(89) &
                      *y(7) + rxt(92)*y(9) + (rxt(95) + rxt(96)) * y(17) + rxt(98) &
                      *y(20) + rxt(105)*y(21) + rxt(106)*y(19) + rxt(107)*y(119) &
                      + rxt(111)*y(118) + rxt(112)*y(29) + rxt(113)*y(23) + rxt(119) &
                      *y(26) + rxt(124)*y(31) + rxt(125)*y(32) + rxt(132)*y(34) &
                      + rxt(133)*y(27) + rxt(134)*y(80) + rxt(135)*y(22) + rxt(137) &
                      *y(81) + rxt(138)*y(35) + rxt(144)*y(38) + rxt(145)*y(36) &
                      + rxt(148)*y(40) + rxt(149)*y(41) + rxt(153)*y(43) + rxt(154) &
                      *y(61) + rxt(155)*y(62) + rxt(157)*y(82) + rxt(158)*y(44) &
                      + rxt(160)*y(55) + rxt(162)*y(46) + rxt(165)*y(48) + rxt(166) &
                      *y(56) + rxt(174)*y(58) + rxt(183)*y(83) + rxt(184)*y(52) &
                      + rxt(190)*y(54) + rxt(196)*y(49) + rxt(197)*y(85) + rxt(199) &
                      *y(60) + rxt(202)*y(51) + rxt(208)*y(64) + rxt(210)*y(68) &
                      + rxt(213)*y(71) + rxt(214)*y(69) + rxt(216)*y(72) + rxt(219) &
                      *y(75) + rxt(222)*y(65) + rxt(227)*y(67) + rxt(233)*y(100) &
                      + (rxt(234) + rxt(235)) * y(101) + rxt(237)*y(103))
         mat(538) = -rxt(63)*y(12)
         mat(651) = -rxt(64)*y(12)
         mat(894) = -rxt(65)*y(12)
         mat(283) = -rxt(68)*y(12)
         mat(102) = -rxt(69)*y(12)
         mat(89) = -rxt(75)*y(12)
         mat(55) = -rxt(76)*y(12)
         mat(673) = -rxt(85)*y(12)
         mat(235) = -rxt(86)*y(12)
         mat(973) = -rxt(89)*y(12)
         mat(135) = -rxt(92)*y(12)
         mat(620) = -(rxt(95) + rxt(96)) * y(12)
         mat(608) = -rxt(98)*y(12)
         mat(262) = -rxt(105)*y(12)
         mat(146) = -rxt(106)*y(12)
         mat(149) = -rxt(107)*y(12)
         mat(81) = -rxt(111)*y(12)
         mat(59) = -rxt(112)*y(12)
         mat(157) = -rxt(113)*y(12)
         mat(204) = -rxt(119)*y(12)
         mat(162) = -rxt(124)*y(12)
         mat(450) = -rxt(125)*y(12)
         mat(208) = -rxt(132)*y(12)
         mat(371) = -rxt(133)*y(12)
         mat(304) = -rxt(134)*y(12)
         mat(106) = -rxt(135)*y(12)
         mat(222) = -rxt(137)*y(12)
         mat(430) = -rxt(138)*y(12)
         mat(126) = -rxt(144)*y(12)
         mat(62) = -rxt(145)*y(12)
         mat(231) = -rxt(148)*y(12)
         mat(327) = -rxt(149)*y(12)
         mat(131) = -rxt(153)*y(12)
         mat(492) = -rxt(154)*y(12)
         mat(509) = -rxt(155)*y(12)
         mat(190) = -rxt(157)*y(12)
         mat(44) = -rxt(158)*y(12)
         mat(553) = -rxt(160)*y(12)
         mat(201) = -rxt(162)*y(12)
         mat(121) = -rxt(165)*y(12)
         mat(501) = -rxt(166)*y(12)
         mat(140) = -rxt(174)*y(12)
         mat(248) = -rxt(183)*y(12)
         mat(395) = -rxt(184)*y(12)
         mat(258) = -rxt(190)*y(12)
         mat(47) = -rxt(196)*y(12)
         mat(461) = -rxt(197)*y(12)
         mat(173) = -rxt(199)*y(12)
         mat(314) = -rxt(202)*y(12)
         mat(93) = -rxt(208)*y(12)
         mat(69) = -rxt(210)*y(12)
         mat(179) = -rxt(213)*y(12)
         mat(73) = -rxt(214)*y(12)
         mat(50) = -rxt(216)*y(12)
         mat(53) = -rxt(219)*y(12)
         mat(290) = -rxt(222)*y(12)
         mat(242) = -rxt(227)*y(12)
         mat(65) = -rxt(233)*y(12)
         mat(97) = -(rxt(234) + rxt(235)) * y(12)
         mat(41) = -rxt(237)*y(12)

         mat(651) = mat(651) + rxt(59)*y(15) + rxt(72)*y(13) + .120_r8*rxt(118)*y(23) &
                      + .330_r8*rxt(139)*y(35) + .270_r8*rxt(185)*y(52) &
                      + .080_r8*rxt(161)*y(55) + .215_r8*rxt(167)*y(56) &
                      + .700_r8*rxt(223)*y(65)
         mat(538) = mat(538) + rxt(70)*y(11) + rxt(71)*y(13) + rxt(74)*y(14) + rxt(99) &
                      *y(20)
         mat(442) = rxt(51)*y(11) + rxt(57)*y(116)
         mat(283) = mat(283) + rxt(70)*y(2) + rxt(51)*y(3)
         mat(89) = mat(89) + rxt(57)*y(3)
         mat(405) = rxt(59)*y(1) + 2.000_r8*rxt(60)*y(13)
         mat(938) = rxt(78)*y(13)
         mat(973) = mat(973) + rxt(90)*y(13)
         mat(759) = mat(759) + .300_r8*rxt(106)*y(19) + .500_r8*rxt(124)*y(31) &
                      + .500_r8*rxt(148)*y(40) + .100_r8*rxt(174)*y(58) &
                      + .650_r8*rxt(111)*y(118)
         mat(894) = mat(894) + rxt(72)*y(1) + rxt(71)*y(2) + 2.000_r8*rxt(60)*y(15) &
                      + rxt(78)*y(5) + rxt(90)*y(7)
         mat(102) = mat(102) + rxt(74)*y(2)
         mat(146) = mat(146) + .300_r8*rxt(106)*y(12)
         mat(608) = mat(608) + rxt(99)*y(2)
         mat(157) = mat(157) + .120_r8*rxt(118)*y(1)
         mat(162) = mat(162) + .500_r8*rxt(124)*y(12)
         mat(430) = mat(430) + .330_r8*rxt(139)*y(1)
         mat(231) = mat(231) + .500_r8*rxt(148)*y(12)
         mat(395) = mat(395) + .270_r8*rxt(185)*y(1)
         mat(553) = mat(553) + .080_r8*rxt(161)*y(1)
         mat(501) = mat(501) + .215_r8*rxt(167)*y(1)
         mat(140) = mat(140) + .100_r8*rxt(174)*y(12)
         mat(290) = mat(290) + .700_r8*rxt(223)*y(1)
         mat(81) = mat(81) + .650_r8*rxt(111)*y(12)

         mat(898) = -((rxt(60) + rxt(61) + rxt(62)) * y(15) + rxt(65)*y(12) + rxt(71) &
                      *y(2) + rxt(72)*y(1) + 4._r8*rxt(73)*y(13) + rxt(78)*y(5) + rxt(90) &
                      *y(7) + rxt(91)*y(6) + rxt(100)*y(20) + rxt(102)*y(18) + rxt(110) &
                      *y(120) + rxt(115)*y(25) + rxt(121)*y(30) + rxt(129)*y(33) &
                      + rxt(142)*y(37) + rxt(147)*y(39) + rxt(151)*y(42) + rxt(164) &
                      *y(47) + rxt(171)*y(57) + rxt(177)*y(59) + rxt(189)*y(53) &
                      + rxt(195)*y(84) + rxt(201)*y(50) + rxt(205)*y(63) + rxt(212) &
                      *y(70) + rxt(217)*y(73) + rxt(220)*y(76) + rxt(226)*y(66))
         mat(406) = -(rxt(60) + rxt(61) + rxt(62)) * y(13)
         mat(763) = -rxt(65)*y(13)
         mat(540) = -rxt(71)*y(13)
         mat(655) = -rxt(72)*y(13)
         mat(942) = -rxt(78)*y(13)
         mat(977) = -rxt(90)*y(13)
         mat(677) = -rxt(91)*y(13)
         mat(610) = -rxt(100)*y(13)
         mat(796) = -rxt(102)*y(13)
         mat(196) = -rxt(110)*y(13)
         mat(300) = -rxt(115)*y(13)
         mat(365) = -rxt(121)*y(13)
         mat(820) = -rxt(129)*y(13)
         mat(383) = -rxt(142)*y(13)
         mat(337) = -rxt(147)*y(13)
         mat(487) = -rxt(151)*y(13)
         mat(323) = -rxt(164)*y(13)
         mat(574) = -rxt(171)*y(13)
         mat(836) = -rxt(177)*y(13)
         mat(595) = -rxt(189)*y(13)
         mat(474) = -rxt(195)*y(13)
         mat(354) = -rxt(201)*y(13)
         mat(526) = -rxt(205)*y(13)
         mat(271) = -rxt(212)*y(13)
         mat(185) = -rxt(217)*y(13)
         mat(217) = -rxt(220)*y(13)
         mat(417) = -rxt(226)*y(13)

         mat(655) = mat(655) + rxt(64)*y(12) + .120_r8*rxt(118)*y(23) &
                      + .190_r8*rxt(139)*y(35) + .060_r8*rxt(185)*y(52) &
                      + .060_r8*rxt(161)*y(55) + .275_r8*rxt(167)*y(56) + rxt(223) &
                      *y(65)
         mat(540) = mat(540) + rxt(74)*y(14) + rxt(99)*y(20)
         mat(622) = rxt(96)*y(12)
         mat(90) = rxt(75)*y(12)
         mat(56) = rxt(76)*y(12)
         mat(942) = mat(942) + rxt(101)*y(18) + .250_r8*rxt(114)*y(25) + rxt(120) &
                      *y(30) + rxt(141)*y(37) + rxt(146)*y(39) + rxt(159)*y(45) &
                      + .900_r8*rxt(200)*y(50) + rxt(187)*y(53) + .470_r8*rxt(168) &
                      *y(57) + rxt(203)*y(63) + rxt(225)*y(66) + .900_r8*rxt(211) &
                      *y(70) + .900_r8*rxt(218)*y(73) + .900_r8*rxt(221)*y(76) &
                      + .794_r8*rxt(193)*y(84) + rxt(109)*y(120)
         mat(677) = mat(677) + .700_r8*rxt(215)*y(78)
         mat(977) = mat(977) + rxt(89)*y(12) + rxt(97)*y(20) + rxt(188)*y(53) &
                      + .470_r8*rxt(170)*y(57) + rxt(204)*y(63) + .794_r8*rxt(194) &
                      *y(84) + rxt(198)*y(85)
         mat(763) = mat(763) + rxt(64)*y(1) + rxt(96)*y(17) + rxt(75)*y(116) + rxt(76) &
                      *y(117) + rxt(89)*y(7) + rxt(69)*y(14) + rxt(105)*y(21) &
                      + rxt(135)*y(22) + rxt(133)*y(27) + .200_r8*rxt(174)*y(58) &
                      + rxt(154)*y(61) + .250_r8*rxt(210)*y(68) + rxt(134)*y(80) &
                      + .500_r8*rxt(183)*y(83) + rxt(197)*y(85) + .500_r8*rxt(235) &
                      *y(101) + .350_r8*rxt(111)*y(118) + rxt(107)*y(119)
         mat(898) = mat(898) + .794_r8*rxt(195)*y(84)
         mat(103) = rxt(74)*y(2) + rxt(69)*y(12)
         mat(796) = mat(796) + rxt(101)*y(5) + 4.000_r8*rxt(103)*y(18) + rxt(122) &
                      *y(30) + .900_r8*rxt(130)*y(33) + rxt(143)*y(37) &
                      + .300_r8*rxt(152)*y(42) + rxt(191)*y(53) + .730_r8*rxt(172) &
                      *y(57) + rxt(178)*y(59) + .800_r8*rxt(206)*y(63)
         mat(610) = mat(610) + rxt(99)*y(2) + rxt(97)*y(7)
         mat(263) = rxt(105)*y(12)
         mat(107) = rxt(135)*y(12)
         mat(158) = .120_r8*rxt(118)*y(1)
         mat(300) = mat(300) + .250_r8*rxt(114)*y(5)
         mat(372) = rxt(133)*y(12)
         mat(365) = mat(365) + rxt(120)*y(5) + rxt(122)*y(18) + 2.400_r8*rxt(123) &
                      *y(30)
         mat(820) = mat(820) + .900_r8*rxt(130)*y(18) + rxt(192)*y(53) &
                      + .470_r8*rxt(173)*y(57) + rxt(207)*y(63)
         mat(432) = .190_r8*rxt(139)*y(1)
         mat(383) = mat(383) + rxt(141)*y(5) + rxt(143)*y(18)
         mat(337) = mat(337) + rxt(146)*y(5)
         mat(487) = mat(487) + .300_r8*rxt(152)*y(18)
         mat(169) = rxt(159)*y(5)
         mat(354) = mat(354) + .900_r8*rxt(200)*y(5)
         mat(398) = .060_r8*rxt(185)*y(1)
         mat(595) = mat(595) + rxt(187)*y(5) + rxt(188)*y(7) + rxt(191)*y(18) &
                      + rxt(192)*y(33)
         mat(556) = .060_r8*rxt(161)*y(1)
         mat(504) = .275_r8*rxt(167)*y(1)
         mat(574) = mat(574) + .470_r8*rxt(168)*y(5) + .470_r8*rxt(170)*y(7) &
                      + .730_r8*rxt(172)*y(18) + .470_r8*rxt(173)*y(33)
         mat(142) = .200_r8*rxt(174)*y(12)
         mat(836) = mat(836) + rxt(178)*y(18)
         mat(494) = rxt(154)*y(12)
         mat(526) = mat(526) + rxt(203)*y(5) + rxt(204)*y(7) + .800_r8*rxt(206)*y(18) &
                      + rxt(207)*y(33)
         mat(291) = rxt(223)*y(1)
         mat(417) = mat(417) + rxt(225)*y(5)
         mat(70) = .250_r8*rxt(210)*y(12)
         mat(271) = mat(271) + .900_r8*rxt(211)*y(5)
         mat(86) = .700_r8*rxt(215)*y(6)
         mat(305) = rxt(134)*y(12)
         mat(185) = mat(185) + .900_r8*rxt(218)*y(5)
         mat(217) = mat(217) + .900_r8*rxt(221)*y(5)
         mat(250) = .500_r8*rxt(183)*y(12)
         mat(474) = mat(474) + .794_r8*rxt(193)*y(5) + .794_r8*rxt(194)*y(7) &
                      + .794_r8*rxt(195)*y(13)
         mat(462) = rxt(198)*y(7) + rxt(197)*y(12)
         mat(98) = .500_r8*rxt(235)*y(12)
         mat(82) = .350_r8*rxt(111)*y(12)
         mat(150) = rxt(107)*y(12)
         mat(196) = mat(196) + rxt(109)*y(5)


      end subroutine nlnmat02

      subroutine nlnmat03( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(100) = -(rxt(69)*y(12) + rxt(74)*y(2))
         mat(697) = -rxt(69)*y(14)
         mat(529) = -rxt(74)*y(14)

         mat(697) = mat(697) + 2.000_r8*rxt(67)*y(12)
         mat(843) = 2.000_r8*rxt(73)*y(13)

         mat(793) = -(rxt(101)*y(5) + rxt(102)*y(13) + (4._r8*rxt(103) + 4._r8*rxt(104) &
                      ) * y(18) + rxt(122)*y(30) + rxt(130)*y(33) + rxt(143)*y(37) &
                      + rxt(152)*y(42) + rxt(172)*y(57) + rxt(178)*y(59) + rxt(191) &
                      *y(53) + rxt(206)*y(63))
         mat(939) = -rxt(101)*y(18)
         mat(895) = -rxt(102)*y(18)
         mat(364) = -rxt(122)*y(18)
         mat(817) = -rxt(130)*y(18)
         mat(381) = -rxt(143)*y(18)
         mat(485) = -rxt(152)*y(18)
         mat(571) = -rxt(172)*y(18)
         mat(833) = -rxt(178)*y(18)
         mat(592) = -rxt(191)*y(18)
         mat(524) = -rxt(206)*y(18)

         mat(652) = .310_r8*rxt(139)*y(35)
         mat(939) = mat(939) + rxt(127)*y(33)
         mat(760) = .700_r8*rxt(106)*y(19) + rxt(119)*y(26)
         mat(793) = mat(793) + .900_r8*rxt(130)*y(33)
         mat(147) = .700_r8*rxt(106)*y(12)
         mat(205) = rxt(119)*y(12)
         mat(817) = mat(817) + rxt(127)*y(5) + .900_r8*rxt(130)*y(18) &
                      + 4.000_r8*rxt(131)*y(33) + rxt(192)*y(53) + rxt(173)*y(57) &
                      + rxt(179)*y(59) + rxt(207)*y(63)
         mat(431) = .310_r8*rxt(139)*y(1)
         mat(592) = mat(592) + rxt(192)*y(33)
         mat(571) = mat(571) + rxt(173)*y(33)
         mat(833) = mat(833) + rxt(179)*y(33)
         mat(524) = mat(524) + rxt(207)*y(33)

         mat(143) = -(rxt(106)*y(12))
         mat(704) = -rxt(106)*y(19)

         mat(850) = rxt(102)*y(18)
         mat(767) = rxt(102)*y(13)

         mat(604) = -(rxt(97)*y(7) + rxt(98)*y(12) + rxt(99)*y(2) + rxt(100)*y(13))
         mat(969) = -rxt(97)*y(20)
         mat(755) = -rxt(98)*y(20)
         mat(534) = -rxt(99)*y(20)
         mat(890) = -rxt(100)*y(20)

         mat(647) = rxt(118)*y(23) + .540_r8*rxt(139)*y(35) + .600_r8*rxt(185)*y(52) &
                      + .800_r8*rxt(161)*y(55) + .700_r8*rxt(167)*y(56)
         mat(934) = rxt(101)*y(18) + .500_r8*rxt(114)*y(25) + rxt(146)*y(39) &
                      + rxt(150)*y(42) + .500_r8*rxt(159)*y(45) + .100_r8*rxt(200) &
                      *y(50) + .510_r8*rxt(187)*y(53) + .250_r8*rxt(168)*y(57) &
                      + rxt(175)*y(59) + .072_r8*rxt(193)*y(84)
         mat(969) = mat(969) + .600_r8*rxt(188)*y(53) + .250_r8*rxt(170)*y(57) &
                      + rxt(176)*y(59) + .072_r8*rxt(194)*y(84)
         mat(755) = mat(755) + .300_r8*rxt(106)*y(19) + rxt(105)*y(21) &
                      + .800_r8*rxt(133)*y(27) + .500_r8*rxt(132)*y(34) + rxt(137) &
                      *y(81) + .500_r8*rxt(183)*y(83)
         mat(890) = mat(890) + .008_r8*rxt(195)*y(84)
         mat(788) = rxt(101)*y(5) + (4.000_r8*rxt(103)+2.000_r8*rxt(104))*y(18) &
                      + .700_r8*rxt(122)*y(30) + rxt(130)*y(33) + rxt(143)*y(37) &
                      + .800_r8*rxt(152)*y(42) + 1.200_r8*rxt(191)*y(53) &
                      + .880_r8*rxt(172)*y(57) + 2.000_r8*rxt(178)*y(59) &
                      + .700_r8*rxt(206)*y(63)
         mat(145) = .300_r8*rxt(106)*y(12)
         mat(261) = rxt(105)*y(12)
         mat(154) = rxt(118)*y(1)
         mat(297) = .500_r8*rxt(114)*y(5)
         mat(369) = .800_r8*rxt(133)*y(12)
         mat(361) = .700_r8*rxt(122)*y(18)
         mat(812) = rxt(130)*y(18) + .600_r8*rxt(192)*y(53) + .250_r8*rxt(173)*y(57) &
                      + rxt(179)*y(59)
         mat(207) = .500_r8*rxt(132)*y(12)
         mat(426) = .540_r8*rxt(139)*y(1)
         mat(378) = rxt(143)*y(18)
         mat(334) = rxt(146)*y(5)
         mat(482) = rxt(150)*y(5) + .800_r8*rxt(152)*y(18)
         mat(167) = .500_r8*rxt(159)*y(5)
         mat(349) = .100_r8*rxt(200)*y(5)
         mat(392) = .600_r8*rxt(185)*y(1)
         mat(587) = .510_r8*rxt(187)*y(5) + .600_r8*rxt(188)*y(7) + 1.200_r8*rxt(191) &
                      *y(18) + .600_r8*rxt(192)*y(33)
         mat(549) = .800_r8*rxt(161)*y(1)
         mat(498) = .700_r8*rxt(167)*y(1)
         mat(567) = .250_r8*rxt(168)*y(5) + .250_r8*rxt(170)*y(7) + .880_r8*rxt(172) &
                      *y(18) + .250_r8*rxt(173)*y(33)
         mat(828) = rxt(175)*y(5) + rxt(176)*y(7) + 2.000_r8*rxt(178)*y(18) + rxt(179) &
                      *y(33) + 4.000_r8*rxt(180)*y(59)
         mat(520) = .700_r8*rxt(206)*y(18)
         mat(220) = rxt(137)*y(12)
         mat(246) = .500_r8*rxt(183)*y(12)
         mat(470) = .072_r8*rxt(193)*y(5) + .072_r8*rxt(194)*y(7) + .008_r8*rxt(195) &
                      *y(13)

         mat(260) = -(rxt(105)*y(12))
         mat(723) = -rxt(105)*y(21)

         mat(770) = 2.000_r8*rxt(104)*y(18) + .300_r8*rxt(122)*y(30) &
                      + .500_r8*rxt(152)*y(42) + .250_r8*rxt(191)*y(53) &
                      + .250_r8*rxt(172)*y(57) + .300_r8*rxt(206)*y(63)
         mat(358) = .300_r8*rxt(122)*y(18)
         mat(478) = .500_r8*rxt(152)*y(18)
         mat(579) = .250_r8*rxt(191)*y(18)
         mat(560) = .250_r8*rxt(172)*y(18)
         mat(514) = .300_r8*rxt(206)*y(18)

         mat(104) = -(rxt(135)*y(12))
         mat(698) = -rxt(135)*y(22)

         mat(766) = .200_r8*rxt(122)*y(30)
         mat(356) = .200_r8*rxt(122)*y(18) + .800_r8*rxt(123)*y(30)


         mat(841) = rxt(115)*y(25)
         mat(293) = rxt(115)*y(13)

         mat(152) = -(rxt(113)*y(12) + rxt(118)*y(1))
         mat(706) = -rxt(113)*y(23)
         mat(626) = -rxt(118)*y(23)


         mat(901) = .750_r8*rxt(114)*y(25)
         mat(294) = .750_r8*rxt(114)*y(5)

         mat(295) = -(rxt(114)*y(5) + rxt(115)*y(13))
         mat(912) = -rxt(114)*y(25)
         mat(865) = -rxt(115)*y(25)

         mat(728) = rxt(113)*y(23)
         mat(153) = rxt(113)*y(12)

         mat(203) = -(rxt(119)*y(12))
         mat(714) = -rxt(119)*y(26)

         mat(627) = .250_r8*rxt(139)*y(35) + .200_r8*rxt(185)*y(52)
         mat(856) = .250_r8*rxt(129)*y(33) + .250_r8*rxt(177)*y(59)
         mat(769) = .100_r8*rxt(130)*y(33)
         mat(800) = .250_r8*rxt(129)*y(13) + .100_r8*rxt(130)*y(18)
         mat(420) = .250_r8*rxt(139)*y(1)
         mat(385) = .200_r8*rxt(185)*y(1)
         mat(823) = .250_r8*rxt(177)*y(13)

         mat(368) = -(rxt(133)*y(12))
         mat(736) = -rxt(133)*y(27)

         mat(919) = .530_r8*rxt(168)*y(57) + .250_r8*rxt(203)*y(63)
         mat(953) = .530_r8*rxt(170)*y(57) + .250_r8*rxt(204)*y(63)
         mat(774) = .260_r8*rxt(172)*y(57) + .100_r8*rxt(206)*y(63)
         mat(804) = .530_r8*rxt(173)*y(57) + .250_r8*rxt(207)*y(63)
         mat(561) = .530_r8*rxt(168)*y(5) + .530_r8*rxt(170)*y(7) + .260_r8*rxt(172) &
                      *y(18) + .530_r8*rxt(173)*y(33)
         mat(516) = .250_r8*rxt(203)*y(5) + .250_r8*rxt(204)*y(7) + .100_r8*rxt(206) &
                      *y(18) + .250_r8*rxt(207)*y(33)

         mat(57) = -(rxt(112)*y(12))
         mat(687) = -rxt(112)*y(29)

         mat(359) = -(rxt(120)*y(5) + rxt(121)*y(13) + rxt(122)*y(18) + 4._r8*rxt(123) &
                      *y(30))
         mat(918) = -rxt(120)*y(30)
         mat(872) = -rxt(121)*y(30)
         mat(773) = -rxt(122)*y(30)

         mat(735) = rxt(112)*y(29) + .500_r8*rxt(124)*y(31)
         mat(58) = rxt(112)*y(12)
         mat(160) = .500_r8*rxt(124)*y(12)

         mat(159) = -(rxt(124)*y(12))
         mat(707) = -rxt(124)*y(31)

         mat(852) = rxt(121)*y(30)
         mat(357) = rxt(121)*y(13)

         mat(447) = -(rxt(125)*y(12) + rxt(126)*y(7))
         mat(743) = -rxt(125)*y(32)
         mat(957) = -rxt(126)*y(32)

         mat(636) = .500_r8*rxt(139)*y(35) + .040_r8*rxt(161)*y(55)
         mat(922) = rxt(120)*y(30) + .270_r8*rxt(141)*y(37) + rxt(146)*y(39) &
                      + rxt(159)*y(45) + .400_r8*rxt(200)*y(50) + rxt(163)*y(47)
         mat(743) = mat(743) + rxt(135)*y(22) + .500_r8*rxt(124)*y(31)
         mat(778) = .800_r8*rxt(122)*y(30)
         mat(105) = rxt(135)*y(12)
         mat(360) = rxt(120)*y(5) + .800_r8*rxt(122)*y(18) + 3.200_r8*rxt(123)*y(30)
         mat(161) = .500_r8*rxt(124)*y(12)
         mat(423) = .500_r8*rxt(139)*y(1)
         mat(376) = .270_r8*rxt(141)*y(5)
         mat(332) = rxt(146)*y(5)
         mat(166) = rxt(159)*y(5)
         mat(346) = .400_r8*rxt(200)*y(5)
         mat(319) = rxt(163)*y(5)
         mat(544) = .040_r8*rxt(161)*y(1)

         mat(818) = -(rxt(127)*y(5) + rxt(128)*y(6) + rxt(129)*y(13) + rxt(130)*y(18) &
                      + 4._r8*rxt(131)*y(33) + rxt(173)*y(57) + rxt(192)*y(53) + rxt(207) &
                      *y(63))
         mat(940) = -rxt(127)*y(33)
         mat(675) = -rxt(128)*y(33)
         mat(896) = -rxt(129)*y(33)
         mat(794) = -rxt(130)*y(33)
         mat(572) = -rxt(173)*y(33)
         mat(593) = -rxt(192)*y(33)
         mat(525) = -rxt(207)*y(33)

         mat(940) = mat(940) + rxt(150)*y(42) + rxt(163)*y(47) + .530_r8*rxt(168) &
                      *y(57) + rxt(175)*y(59)
         mat(975) = rxt(126)*y(32) + .530_r8*rxt(170)*y(57) + rxt(176)*y(59) &
                      + rxt(156)*y(62)
         mat(761) = rxt(125)*y(32) + .500_r8*rxt(132)*y(34) + rxt(155)*y(62)
         mat(794) = mat(794) + .300_r8*rxt(152)*y(42) + .260_r8*rxt(172)*y(57) &
                      + rxt(178)*y(59)
         mat(452) = rxt(126)*y(7) + rxt(125)*y(12)
         mat(818) = mat(818) + .530_r8*rxt(173)*y(57)
         mat(210) = .500_r8*rxt(132)*y(12)
         mat(486) = rxt(150)*y(5) + .300_r8*rxt(152)*y(18)
         mat(322) = rxt(163)*y(5)
         mat(572) = mat(572) + .530_r8*rxt(168)*y(5) + .530_r8*rxt(170)*y(7) &
                      + .260_r8*rxt(172)*y(18) + .530_r8*rxt(173)*y(33)
         mat(834) = rxt(175)*y(5) + rxt(176)*y(7) + rxt(178)*y(18) + 4.000_r8*rxt(180) &
                      *y(59)
         mat(510) = rxt(156)*y(7) + rxt(155)*y(12)

         mat(206) = -(rxt(132)*y(12))
         mat(715) = -rxt(132)*y(34)

         mat(857) = .750_r8*rxt(129)*y(33) + .750_r8*rxt(177)*y(59)
         mat(801) = .750_r8*rxt(129)*y(13)
         mat(824) = .750_r8*rxt(177)*y(13)

         mat(422) = -(rxt(138)*y(12) + rxt(139)*y(1) + rxt(140)*y(7))
         mat(741) = -rxt(138)*y(35)
         mat(634) = -rxt(139)*y(35)
         mat(956) = -rxt(140)*y(35)

         mat(634) = mat(634) + .070_r8*rxt(185)*y(52)
         mat(387) = .070_r8*rxt(185)*y(1)


      end subroutine nlnmat03

      subroutine nlnmat04( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(60) = -(rxt(145)*y(12))
         mat(688) = -rxt(145)*y(36)

         mat(375) = -(rxt(141)*y(5) + rxt(142)*y(13) + rxt(143)*y(18))
         mat(920) = -rxt(141)*y(37)
         mat(874) = -rxt(142)*y(37)
         mat(775) = -rxt(143)*y(37)

         mat(737) = rxt(145)*y(36) + rxt(144)*y(38)
         mat(61) = rxt(145)*y(12)
         mat(125) = rxt(144)*y(12)

         mat(123) = -(rxt(144)*y(12))
         mat(700) = -rxt(144)*y(38)

         mat(846) = rxt(142)*y(37)
         mat(373) = rxt(142)*y(13)

         mat(331) = -(rxt(146)*y(5) + rxt(147)*y(13))
         mat(916) = -rxt(146)*y(39)
         mat(870) = -rxt(147)*y(39)

         mat(733) = rxt(138)*y(35) + .500_r8*rxt(148)*y(40)
         mat(421) = rxt(138)*y(12)
         mat(227) = .500_r8*rxt(148)*y(12)

         mat(226) = -(rxt(148)*y(12))
         mat(718) = -rxt(148)*y(40)

         mat(859) = rxt(147)*y(39)
         mat(330) = rxt(147)*y(13)

         mat(325) = -(rxt(149)*y(12))
         mat(732) = -rxt(149)*y(41)

         mat(915) = .820_r8*rxt(141)*y(37) + .500_r8*rxt(159)*y(45) + .250_r8*rxt(200) &
                      *y(50) + .100_r8*rxt(225)*y(66)
         mat(772) = .820_r8*rxt(143)*y(37)
         mat(374) = .820_r8*rxt(141)*y(5) + .820_r8*rxt(143)*y(18)
         mat(165) = .500_r8*rxt(159)*y(5)
         mat(343) = .250_r8*rxt(200)*y(5)
         mat(408) = .100_r8*rxt(225)*y(5)

         mat(479) = -(rxt(150)*y(5) + rxt(151)*y(13) + rxt(152)*y(18))
         mat(925) = -rxt(150)*y(42)
         mat(881) = -rxt(151)*y(42)
         mat(779) = -rxt(152)*y(42)

         mat(746) = rxt(149)*y(41) + rxt(153)*y(43)
         mat(326) = rxt(149)*y(12)
         mat(129) = rxt(153)*y(12)

         mat(128) = -(rxt(153)*y(12))
         mat(701) = -rxt(153)*y(43)

         mat(847) = rxt(151)*y(42)
         mat(477) = rxt(151)*y(13)

         mat(42) = -(rxt(158)*y(12))
         mat(682) = -rxt(158)*y(44)

         mat(164) = -(rxt(159)*y(5))
         mat(903) = -rxt(159)*y(45)

         mat(708) = rxt(158)*y(44)
         mat(43) = rxt(158)*y(12)

         mat(45) = -(rxt(196)*y(12))
         mat(683) = -rxt(196)*y(49)

         mat(344) = -(rxt(200)*y(5) + rxt(201)*y(13))
         mat(917) = -rxt(200)*y(50)
         mat(871) = -rxt(201)*y(50)

         mat(734) = rxt(196)*y(49) + rxt(202)*y(51)
         mat(46) = rxt(196)*y(12)
         mat(310) = rxt(202)*y(12)

         mat(307) = -(rxt(202)*y(12))
         mat(730) = -rxt(202)*y(51)

         mat(867) = rxt(201)*y(50)
         mat(341) = rxt(201)*y(13)

         mat(198) = -(rxt(162)*y(12))
         mat(713) = -rxt(162)*y(46)

         mat(908) = .800_r8*rxt(200)*y(50)
         mat(340) = .800_r8*rxt(200)*y(5)

         mat(318) = -(rxt(163)*y(5) + rxt(164)*y(13))
         mat(914) = -rxt(163)*y(47)
         mat(868) = -rxt(164)*y(47)

         mat(731) = rxt(162)*y(46) + rxt(165)*y(48)
         mat(199) = rxt(162)*y(12)
         mat(119) = rxt(165)*y(12)

         mat(118) = -(rxt(165)*y(12))
         mat(699) = -rxt(165)*y(48)

         mat(845) = rxt(164)*y(47)
         mat(317) = rxt(164)*y(13)

         mat(386) = -(rxt(184)*y(12) + rxt(185)*y(1) + rxt(186)*y(7))
         mat(738) = -rxt(184)*y(52)
         mat(631) = -rxt(185)*y(52)
         mat(954) = -rxt(186)*y(52)

         mat(586) = -(rxt(187)*y(5) + rxt(188)*y(7) + rxt(189)*y(13) + rxt(191)*y(18) &
                      + rxt(192)*y(33))
         mat(933) = -rxt(187)*y(53)
         mat(968) = -rxt(188)*y(53)
         mat(889) = -rxt(189)*y(53)
         mat(787) = -rxt(191)*y(53)
         mat(811) = -rxt(192)*y(53)

         mat(754) = rxt(184)*y(52) + .200_r8*rxt(190)*y(54)
         mat(391) = rxt(184)*y(12)
         mat(256) = .200_r8*rxt(190)*y(12)

         mat(252) = -(rxt(190)*y(12))
         mat(722) = -rxt(190)*y(54)

         mat(861) = rxt(189)*y(53)
         mat(578) = rxt(189)*y(13)

         mat(547) = -(rxt(160)*y(12) + rxt(161)*y(1))
         mat(752) = -rxt(160)*y(55)
         mat(644) = -rxt(161)*y(55)

         mat(644) = mat(644) + .200_r8*rxt(185)*y(52) + rxt(223)*y(65)
         mat(931) = .320_r8*rxt(187)*y(53) + rxt(225)*y(66) + .039_r8*rxt(193)*y(84)
         mat(966) = .350_r8*rxt(188)*y(53) + .039_r8*rxt(194)*y(84)
         mat(887) = .039_r8*rxt(195)*y(84)
         mat(785) = .260_r8*rxt(191)*y(53)
         mat(809) = .350_r8*rxt(192)*y(53)
         mat(390) = .200_r8*rxt(185)*y(1)
         mat(584) = .320_r8*rxt(187)*y(5) + .350_r8*rxt(188)*y(7) + .260_r8*rxt(191) &
                      *y(18) + .350_r8*rxt(192)*y(33)
         mat(287) = rxt(223)*y(1)
         mat(412) = rxt(225)*y(5)
         mat(469) = .039_r8*rxt(193)*y(5) + .039_r8*rxt(194)*y(7) + .039_r8*rxt(195) &
                      *y(13)

         mat(495) = -(rxt(166)*y(12) + rxt(167)*y(1))
         mat(748) = -rxt(166)*y(56)
         mat(640) = -rxt(167)*y(56)

         mat(640) = mat(640) + .400_r8*rxt(185)*y(52) + rxt(223)*y(65)
         mat(927) = .230_r8*rxt(187)*y(53) + rxt(225)*y(66) + .167_r8*rxt(193)*y(84)
         mat(962) = .250_r8*rxt(188)*y(53) + .167_r8*rxt(194)*y(84)
         mat(883) = .167_r8*rxt(195)*y(84)
         mat(781) = .190_r8*rxt(191)*y(53)
         mat(806) = .250_r8*rxt(192)*y(53)
         mat(389) = .400_r8*rxt(185)*y(1)
         mat(581) = .230_r8*rxt(187)*y(5) + .250_r8*rxt(188)*y(7) + .190_r8*rxt(191) &
                      *y(18) + .250_r8*rxt(192)*y(33)
         mat(286) = rxt(223)*y(1)
         mat(411) = rxt(225)*y(5)
         mat(467) = .167_r8*rxt(193)*y(5) + .167_r8*rxt(194)*y(7) + .167_r8*rxt(195) &
                      *y(13)

         mat(566) = -((rxt(168) + rxt(169)) * y(5) + rxt(170)*y(7) + rxt(171)*y(13) &
                      + rxt(172)*y(18) + rxt(173)*y(33))
         mat(932) = -(rxt(168) + rxt(169)) * y(57)
         mat(967) = -rxt(170)*y(57)
         mat(888) = -rxt(171)*y(57)
         mat(786) = -rxt(172)*y(57)
         mat(810) = -rxt(173)*y(57)

         mat(753) = rxt(160)*y(55) + .500_r8*rxt(166)*y(56) + .200_r8*rxt(174)*y(58)
         mat(548) = rxt(160)*y(12)
         mat(497) = .500_r8*rxt(166)*y(12)
         mat(139) = .200_r8*rxt(174)*y(12)

         mat(138) = -(rxt(174)*y(12))
         mat(703) = -rxt(174)*y(58)

         mat(849) = rxt(171)*y(57)
         mat(559) = rxt(171)*y(13)

         mat(835) = -(rxt(175)*y(5) + rxt(176)*y(7) + rxt(177)*y(13) + rxt(178)*y(18) &
                      + rxt(179)*y(33) + 4._r8*rxt(180)*y(59) + rxt(181)*y(6))
         mat(941) = -rxt(175)*y(59)
         mat(976) = -rxt(176)*y(59)
         mat(897) = -rxt(177)*y(59)
         mat(795) = -rxt(178)*y(59)
         mat(819) = -rxt(179)*y(59)
         mat(676) = -rxt(181)*y(59)

         mat(654) = .200_r8*rxt(185)*y(52)
         mat(762) = .500_r8*rxt(166)*y(56) + .500_r8*rxt(174)*y(58)
         mat(397) = .200_r8*rxt(185)*y(1)
         mat(503) = .500_r8*rxt(166)*y(12)
         mat(141) = .500_r8*rxt(174)*y(12)

         mat(171) = -(rxt(199)*y(12))
         mat(709) = -rxt(199)*y(60)

         mat(904) = .370_r8*rxt(187)*y(53)
         mat(948) = .400_r8*rxt(188)*y(53) + rxt(198)*y(85)
         mat(709) = mat(709) + rxt(197)*y(85)
         mat(768) = .300_r8*rxt(191)*y(53)
         mat(799) = .400_r8*rxt(192)*y(53)
         mat(577) = .370_r8*rxt(187)*y(5) + .400_r8*rxt(188)*y(7) + .300_r8*rxt(191) &
                      *y(18) + .400_r8*rxt(192)*y(33)
         mat(455) = rxt(198)*y(7) + rxt(197)*y(12)

         mat(489) = -(rxt(154)*y(12))
         mat(747) = -rxt(154)*y(61)

         mat(926) = .220_r8*rxt(168)*y(57) + .250_r8*rxt(203)*y(63)
         mat(961) = .220_r8*rxt(170)*y(57) + .250_r8*rxt(204)*y(63)
         mat(747) = mat(747) + .500_r8*rxt(148)*y(40) + .500_r8*rxt(183)*y(83)
         mat(780) = .200_r8*rxt(152)*y(42) + .230_r8*rxt(172)*y(57) + .100_r8*rxt(206) &
                      *y(63)
         mat(805) = .220_r8*rxt(173)*y(57) + .250_r8*rxt(207)*y(63)
         mat(229) = .500_r8*rxt(148)*y(12)
         mat(480) = .200_r8*rxt(152)*y(18)
         mat(563) = .220_r8*rxt(168)*y(5) + .220_r8*rxt(170)*y(7) + .230_r8*rxt(172) &
                      *y(18) + .220_r8*rxt(173)*y(33)
         mat(517) = .250_r8*rxt(203)*y(5) + .250_r8*rxt(204)*y(7) + .100_r8*rxt(206) &
                      *y(18) + .250_r8*rxt(207)*y(33)
         mat(245) = .500_r8*rxt(183)*y(12)

         mat(506) = -(rxt(155)*y(12) + rxt(156)*y(7))
         mat(749) = -rxt(155)*y(62)
         mat(963) = -rxt(156)*y(62)

         mat(641) = .950_r8*rxt(161)*y(55) + .800_r8*rxt(167)*y(56)
         mat(928) = .250_r8*rxt(168)*y(57) + .250_r8*rxt(203)*y(63) + .450_r8*rxt(211) &
                      *y(70) + .540_r8*rxt(221)*y(76)
         mat(963) = mat(963) + .250_r8*rxt(170)*y(57) + .250_r8*rxt(204)*y(63)
         mat(749) = mat(749) + rxt(154)*y(61) + rxt(157)*y(82)
         mat(782) = .500_r8*rxt(152)*y(42) + .240_r8*rxt(172)*y(57) + .100_r8*rxt(206) &
                      *y(63)
         mat(807) = .250_r8*rxt(173)*y(57) + .250_r8*rxt(207)*y(63)
         mat(481) = .500_r8*rxt(152)*y(18)
         mat(546) = .950_r8*rxt(161)*y(1)
         mat(496) = .800_r8*rxt(167)*y(1)
         mat(564) = .250_r8*rxt(168)*y(5) + .250_r8*rxt(170)*y(7) + .240_r8*rxt(172) &
                      *y(18) + .250_r8*rxt(173)*y(33)
         mat(490) = rxt(154)*y(12)
         mat(518) = .250_r8*rxt(203)*y(5) + .250_r8*rxt(204)*y(7) + .100_r8*rxt(206) &
                      *y(18) + .250_r8*rxt(207)*y(33)
         mat(268) = .450_r8*rxt(211)*y(5)
         mat(215) = .540_r8*rxt(221)*y(5)
         mat(188) = rxt(157)*y(12)

         mat(519) = -(rxt(203)*y(5) + rxt(204)*y(7) + rxt(205)*y(13) + rxt(206)*y(18) &
                      + rxt(207)*y(33))
         mat(929) = -rxt(203)*y(63)
         mat(964) = -rxt(204)*y(63)
         mat(885) = -rxt(205)*y(63)
         mat(783) = -rxt(206)*y(63)
         mat(808) = -rxt(207)*y(63)

         mat(750) = .800_r8*rxt(190)*y(54) + rxt(199)*y(60) + rxt(208)*y(64)
         mat(254) = .800_r8*rxt(190)*y(12)
         mat(172) = rxt(199)*y(12)
         mat(92) = rxt(208)*y(12)


      end subroutine nlnmat04

      subroutine nlnmat05( mat, y, rxt )

      use chem_mods, only : gas_pcnst, rxntot, nzcnt

      implicit none

!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)


!----------------------------------------------
! ... local variables
!----------------------------------------------

!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------


         mat(91) = -((rxt(208) + rxt(209)) * y(12))
         mat(695) = -(rxt(208) + rxt(209)) * y(64)

         mat(842) = rxt(205)*y(63) + rxt(195)*y(84)
         mat(513) = rxt(205)*y(13)
         mat(464) = rxt(195)*y(13)

         mat(284) = -(rxt(222)*y(12) + rxt(223)*y(1) + rxt(224)*y(7))
         mat(727) = -rxt(222)*y(65)
         mat(628) = -rxt(223)*y(65)
         mat(951) = -rxt(224)*y(65)

         mat(409) = -(rxt(225)*y(5) + rxt(226)*y(13))
         mat(921) = -rxt(225)*y(66)
         mat(876) = -rxt(226)*y(66)

         mat(955) = rxt(224)*y(65)
         mat(740) = rxt(222)*y(65) + rxt(227)*y(67)
         mat(285) = rxt(224)*y(7) + rxt(222)*y(12)
         mat(239) = rxt(227)*y(12)

         mat(237) = -(rxt(227)*y(12))
         mat(720) = -rxt(227)*y(67)

         mat(860) = rxt(226)*y(66)
         mat(407) = rxt(226)*y(13)

         mat(66) = -(rxt(210)*y(12))
         mat(690) = -rxt(210)*y(68)

         mat(71) = -(rxt(214)*y(12))
         mat(691) = -rxt(214)*y(69)

         mat(691) = mat(691) + .250_r8*rxt(210)*y(68)
         mat(67) = .250_r8*rxt(210)*y(12)

         mat(265) = -(rxt(211)*y(5) + rxt(212)*y(13))
         mat(910) = -rxt(211)*y(70)
         mat(862) = -rxt(212)*y(70)

         mat(724) = .700_r8*rxt(210)*y(68) + rxt(213)*y(71)
         mat(68) = .700_r8*rxt(210)*y(12)
         mat(175) = rxt(213)*y(12)

         mat(174) = -(rxt(213)*y(12))
         mat(710) = -rxt(213)*y(71)

         mat(853) = rxt(212)*y(70)
         mat(264) = rxt(212)*y(13)

         mat(83) = -(rxt(215)*y(6))
         mat(658) = -rxt(215)*y(78)

         mat(693) = rxt(214)*y(69)
         mat(72) = rxt(214)*y(12)


         mat(911) = .900_r8*rxt(211)*y(70) + .900_r8*rxt(218)*y(73) + .620_r8*rxt(221) &
                      *y(76)
         mat(664) = .700_r8*rxt(215)*y(78)
         mat(266) = .900_r8*rxt(211)*y(5)
         mat(84) = .700_r8*rxt(215)*y(6)
         mat(182) = .900_r8*rxt(218)*y(5)
         mat(213) = .620_r8*rxt(221)*y(5)

         mat(302) = -(rxt(134)*y(12))
         mat(729) = -rxt(134)*y(80)

         mat(913) = .250_r8*rxt(203)*y(63) + .450_r8*rxt(211)*y(70) + .900_r8*rxt(218) &
                      *y(73) + .340_r8*rxt(221)*y(76)
         mat(952) = .250_r8*rxt(204)*y(63)
         mat(729) = mat(729) + .200_r8*rxt(133)*y(27) + .650_r8*rxt(111)*y(118)
         mat(771) = .100_r8*rxt(206)*y(63)
         mat(367) = .200_r8*rxt(133)*y(12)
         mat(803) = .250_r8*rxt(207)*y(63)
         mat(515) = .250_r8*rxt(203)*y(5) + .250_r8*rxt(204)*y(7) + .100_r8*rxt(206) &
                      *y(18) + .250_r8*rxt(207)*y(33)
         mat(267) = .450_r8*rxt(211)*y(5)
         mat(183) = .900_r8*rxt(218)*y(5)
         mat(214) = .340_r8*rxt(221)*y(5)
         mat(79) = .650_r8*rxt(111)*y(12)

         mat(48) = -(rxt(216)*y(12))
         mat(684) = -rxt(216)*y(72)

         mat(181) = -(rxt(217)*y(13) + rxt(218)*y(5))
         mat(854) = -rxt(217)*y(73)
         mat(905) = -rxt(218)*y(73)

         mat(711) = rxt(216)*y(72)
         mat(49) = rxt(216)*y(12)


         mat(839) = rxt(217)*y(73)
         mat(180) = rxt(217)*y(13)

         mat(51) = -(rxt(219)*y(12))
         mat(685) = -rxt(219)*y(75)

         mat(212) = -(rxt(220)*y(13) + rxt(221)*y(5))
         mat(858) = -rxt(220)*y(76)
         mat(909) = -rxt(221)*y(76)

         mat(716) = rxt(219)*y(75)
         mat(52) = rxt(219)*y(12)


         mat(840) = rxt(220)*y(76)
         mat(211) = rxt(220)*y(13)

         mat(219) = -(rxt(137)*y(12))
         mat(717) = -rxt(137)*y(81)

         mat(661) = rxt(128)*y(33)
         mat(802) = rxt(128)*y(6)

         mat(187) = -(rxt(157)*y(12))
         mat(712) = -rxt(157)*y(82)

         mat(906) = .100_r8*rxt(200)*y(50)
         mat(949) = rxt(140)*y(35)
         mat(419) = rxt(140)*y(7)
         mat(339) = .100_r8*rxt(200)*y(5)

         mat(244) = -(rxt(183)*y(12))
         mat(721) = -rxt(183)*y(83)

         mat(663) = rxt(181)*y(59)
         mat(825) = rxt(181)*y(6)

         mat(466) = -(rxt(193)*y(5) + rxt(194)*y(7) + rxt(195)*y(13))
         mat(924) = -rxt(193)*y(84)
         mat(959) = -rxt(194)*y(84)
         mat(880) = -rxt(195)*y(84)

         mat(959) = mat(959) + rxt(186)*y(52)
         mat(388) = rxt(186)*y(7)

         mat(456) = -(rxt(197)*y(12) + rxt(198)*y(7))
         mat(744) = -rxt(197)*y(85)
         mat(958) = -rxt(198)*y(85)

         mat(923) = .080_r8*rxt(187)*y(53) + .800_r8*rxt(169)*y(57) + .794_r8*rxt(193) &
                      *y(84)
         mat(958) = mat(958) + .794_r8*rxt(194)*y(84)
         mat(879) = .794_r8*rxt(195)*y(84)
         mat(580) = .080_r8*rxt(187)*y(5)
         mat(562) = .800_r8*rxt(169)*y(5)
         mat(465) = .794_r8*rxt(193)*y(5) + .794_r8*rxt(194)*y(7) + .794_r8*rxt(195) &
                      *y(13)

         mat(64) = -(rxt(233)*y(12))
         mat(689) = -rxt(233)*y(100)

         mat(945) = rxt(236)*y(101)
         mat(689) = mat(689) + (rxt(234)+.500_r8*rxt(235))*y(101)
         mat(94) = rxt(236)*y(7) + (rxt(234)+.500_r8*rxt(235))*y(12)

         mat(95) = -((rxt(234) + rxt(235)) * y(12) + rxt(236)*y(7))
         mat(696) = -(rxt(234) + rxt(235)) * y(101)
         mat(946) = -rxt(236)*y(101)


         mat(680) = rxt(233)*y(100)
         mat(63) = rxt(233)*y(12)

         mat(40) = -(rxt(237)*y(12))
         mat(681) = -rxt(237)*y(103)
         mat(77) = -(rxt(111)*y(12))
         mat(692) = -rxt(111)*y(118)
         mat(148) = -(rxt(107)*y(12))
         mat(705) = -rxt(107)*y(119)
         mat(625) = .500_r8*rxt(118)*y(23)
         mat(902) = rxt(109)*y(120)
         mat(705) = mat(705) + .350_r8*rxt(111)*y(118)
         mat(851) = rxt(110)*y(120)
         mat(151) = .500_r8*rxt(118)*y(1)
         mat(78) = .350_r8*rxt(111)*y(12)
         mat(191) = rxt(109)*y(5) + rxt(110)*y(13)
         mat(192) = -(rxt(109)*y(5) + rxt(110)*y(13))
         mat(907) = -rxt(109)*y(120)
         mat(855) = -rxt(110)*y(120)
         mat(855) = mat(855) + rxt(100)*y(20)
         mat(598) = rxt(100)*y(13)
      end subroutine nlnmat05
      subroutine nlnmat_finit( mat, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(inout) :: mat(nzcnt)
!----------------------------------------------
! ... local variables
!----------------------------------------------
!----------------------------------------------
! ... complete matrix entries implicit species
!----------------------------------------------
         mat( 1) = lmat( 1)
         mat( 2) = lmat( 2)
         mat( 3) = lmat( 3)
         mat( 4) = lmat( 4)
         mat( 5) = lmat( 5)
         mat( 6) = lmat( 6)
         mat( 7) = lmat( 7)
         mat( 8) = lmat( 8)
         mat( 9) = lmat( 9)
         mat( 10) = lmat( 10)
         mat( 11) = lmat( 11)
         mat( 12) = lmat( 12)
         mat( 13) = lmat( 13)
         mat( 14) = lmat( 14)
         mat( 15) = lmat( 15)
         mat( 16) = lmat( 16)
         mat( 17) = lmat( 17)
         mat( 18) = lmat( 18)
         mat( 19) = lmat( 19)
         mat( 20) = lmat( 20)
         mat( 21) = lmat( 21)
         mat( 22) = lmat( 22)
         mat( 23) = lmat( 23)
         mat( 24) = lmat( 24)
         mat( 25) = lmat( 25)
         mat( 26) = lmat( 26)
         mat( 27) = lmat( 27)
         mat( 28) = lmat( 28)
         mat( 29) = lmat( 29)
         mat( 30) = lmat( 30)
         mat( 31) = lmat( 31)
         mat( 32) = lmat( 32)
         mat( 33) = lmat( 33)
         mat( 34) = lmat( 34)
         mat( 35) = lmat( 35)
         mat( 36) = lmat( 36)
         mat( 37) = lmat( 37)
         mat( 38) = lmat( 38)
         mat( 39) = lmat( 39)
         mat( 40) = mat( 40) + lmat( 40)
         mat( 42) = mat( 42) + lmat( 42)
         mat( 45) = mat( 45) + lmat( 45)
         mat( 48) = mat( 48) + lmat( 48)
         mat( 51) = mat( 51) + lmat( 51)
         mat( 54) = mat( 54) + lmat( 54)
         mat( 57) = mat( 57) + lmat( 57)
         mat( 60) = mat( 60) + lmat( 60)
         mat( 64) = mat( 64) + lmat( 64)
         mat( 66) = mat( 66) + lmat( 66)
         mat( 71) = mat( 71) + lmat( 71)
         mat( 74) = lmat( 74)
         mat( 75) = lmat( 75)
         mat( 76) = lmat( 76)
         mat( 77) = mat( 77) + lmat( 77)
         mat( 83) = mat( 83) + lmat( 83)
         mat( 87) = mat( 87) + lmat( 87)
         mat( 91) = mat( 91) + lmat( 91)
         mat( 93) = mat( 93) + lmat( 93)
         mat( 95) = mat( 95) + lmat( 95)
         mat( 100) = mat( 100) + lmat( 100)
         mat( 102) = mat( 102) + lmat( 102)
         mat( 104) = mat( 104) + lmat( 104)
         mat( 108) = lmat( 108)
         mat( 109) = lmat( 109)
         mat( 110) = lmat( 110)
         mat( 111) = lmat( 111)
         mat( 112) = lmat( 112)
         mat( 113) = lmat( 113)
         mat( 114) = lmat( 114)
         mat( 115) = lmat( 115)
         mat( 116) = lmat( 116)
         mat( 117) = lmat( 117)
         mat( 118) = mat( 118) + lmat( 118)
         mat( 120) = lmat( 120)
         mat( 121) = mat( 121) + lmat( 121)
         mat( 122) = lmat( 122)
         mat( 123) = mat( 123) + lmat( 123)
         mat( 124) = lmat( 124)
         mat( 126) = mat( 126) + lmat( 126)
         mat( 127) = lmat( 127)
         mat( 128) = mat( 128) + lmat( 128)
         mat( 130) = lmat( 130)
         mat( 131) = mat( 131) + lmat( 131)
         mat( 132) = lmat( 132)
         mat( 133) = mat( 133) + lmat( 133)
         mat( 134) = mat( 134) + lmat( 134)
         mat( 135) = mat( 135) + lmat( 135)
         mat( 136) = lmat( 136)
         mat( 137) = lmat( 137)
         mat( 138) = mat( 138) + lmat( 138)
         mat( 143) = mat( 143) + lmat( 143)
         mat( 144) = lmat( 144)
         mat( 145) = mat( 145) + lmat( 145)
         mat( 146) = mat( 146) + lmat( 146)
         mat( 148) = mat( 148) + lmat( 148)
         mat( 152) = mat( 152) + lmat( 152)
         mat( 159) = mat( 159) + lmat( 159)
         mat( 161) = mat( 161) + lmat( 161)
         mat( 162) = mat( 162) + lmat( 162)
         mat( 163) = lmat( 163)
         mat( 164) = mat( 164) + lmat( 164)
         mat( 171) = mat( 171) + lmat( 171)
         mat( 174) = mat( 174) + lmat( 174)
         mat( 176) = lmat( 176)
         mat( 177) = lmat( 177)
         mat( 178) = lmat( 178)
         mat( 179) = mat( 179) + lmat( 179)
         mat( 181) = mat( 181) + lmat( 181)
         mat( 187) = mat( 187) + lmat( 187)
         mat( 192) = mat( 192) + lmat( 192)
         mat( 193) = lmat( 193)
         mat( 196) = mat( 196) + lmat( 196)
         mat( 198) = mat( 198) + lmat( 198)
         mat( 200) = lmat( 200)
         mat( 202) = lmat( 202)
         mat( 203) = mat( 203) + lmat( 203)
         mat( 206) = mat( 206) + lmat( 206)
         mat( 208) = mat( 208) + lmat( 208)
         mat( 209) = lmat( 209)
         mat( 212) = mat( 212) + lmat( 212)
         mat( 219) = mat( 219) + lmat( 219)
         mat( 221) = lmat( 221)
         mat( 223) = lmat( 223)
         mat( 224) = lmat( 224)
         mat( 225) = mat( 225) + lmat( 225)
         mat( 226) = mat( 226) + lmat( 226)
         mat( 228) = lmat( 228)
         mat( 230) = lmat( 230)
         mat( 231) = mat( 231) + lmat( 231)
         mat( 232) = lmat( 232)
         mat( 233) = mat( 233) + lmat( 233)
         mat( 234) = lmat( 234)
         mat( 235) = mat( 235) + lmat( 235)
         mat( 237) = mat( 237) + lmat( 237)
         mat( 238) = lmat( 238)
         mat( 240) = lmat( 240)
         mat( 241) = lmat( 241)
         mat( 242) = mat( 242) + lmat( 242)
         mat( 243) = lmat( 243)
         mat( 244) = mat( 244) + lmat( 244)
         mat( 247) = lmat( 247)
         mat( 249) = lmat( 249)
         mat( 252) = mat( 252) + lmat( 252)
         mat( 253) = lmat( 253)
         mat( 255) = lmat( 255)
         mat( 257) = lmat( 257)
         mat( 259) = lmat( 259)
         mat( 260) = mat( 260) + lmat( 260)
         mat( 265) = mat( 265) + lmat( 265)
         mat( 273) = lmat( 273)
         mat( 274) = lmat( 274)
         mat( 275) = lmat( 275)
         mat( 276) = lmat( 276)
         mat( 277) = lmat( 277)
         mat( 278) = lmat( 278)
         mat( 279) = mat( 279) + lmat( 279)
         mat( 284) = mat( 284) + lmat( 284)
         mat( 295) = mat( 295) + lmat( 295)
         mat( 302) = mat( 302) + lmat( 302)
         mat( 303) = mat( 303) + lmat( 303)
         mat( 305) = mat( 305) + lmat( 305)
         mat( 306) = lmat( 306)
         mat( 307) = mat( 307) + lmat( 307)
         mat( 309) = lmat( 309)
         mat( 312) = lmat( 312)
         mat( 313) = lmat( 313)
         mat( 314) = mat( 314) + lmat( 314)
         mat( 316) = lmat( 316)
         mat( 318) = mat( 318) + lmat( 318)
         mat( 325) = mat( 325) + lmat( 325)
         mat( 328) = lmat( 328)
         mat( 329) = lmat( 329)
         mat( 331) = mat( 331) + lmat( 331)
         mat( 344) = mat( 344) + lmat( 344)
         mat( 359) = mat( 359) + lmat( 359)
         mat( 368) = mat( 368) + lmat( 368)
         mat( 369) = mat( 369) + lmat( 369)
         mat( 370) = lmat( 370)
         mat( 372) = mat( 372) + lmat( 372)
         mat( 375) = mat( 375) + lmat( 375)
         mat( 386) = mat( 386) + lmat( 386)
         mat( 401) = mat( 401) + lmat( 401)
         mat( 406) = mat( 406) + lmat( 406)
         mat( 409) = mat( 409) + lmat( 409)
         mat( 422) = mat( 422) + lmat( 422)
         mat( 436) = mat( 436) + lmat( 436)
         mat( 437) = mat( 437) + lmat( 437)
         mat( 438) = mat( 438) + lmat( 438)
         mat( 439) = lmat( 439)
         mat( 440) = lmat( 440)
         mat( 442) = mat( 442) + lmat( 442)
         mat( 443) = lmat( 443)
         mat( 444) = lmat( 444)
         mat( 445) = lmat( 445)
         mat( 447) = mat( 447) + lmat( 447)
         mat( 448) = lmat( 448)
         mat( 451) = lmat( 451)
         mat( 453) = lmat( 453)
         mat( 456) = mat( 456) + lmat( 456)
         mat( 458) = lmat( 458)
         mat( 459) = lmat( 459)
         mat( 460) = mat( 460) + lmat( 460)
         mat( 462) = mat( 462) + lmat( 462)
         mat( 466) = mat( 466) + lmat( 466)
         mat( 479) = mat( 479) + lmat( 479)
         mat( 489) = mat( 489) + lmat( 489)
         mat( 491) = lmat( 491)
         mat( 493) = lmat( 493)
         mat( 494) = mat( 494) + lmat( 494)
         mat( 495) = mat( 495) + lmat( 495)
         mat( 498) = mat( 498) + lmat( 498)
         mat( 499) = mat( 499) + lmat( 499)
         mat( 502) = lmat( 502)
         mat( 503) = mat( 503) + lmat( 503)
         mat( 504) = mat( 504) + lmat( 504)
         mat( 506) = mat( 506) + lmat( 506)
         mat( 507) = mat( 507) + lmat( 507)
         mat( 510) = mat( 510) + lmat( 510)
         mat( 511) = lmat( 511)
         mat( 519) = mat( 519) + lmat( 519)
         mat( 533) = mat( 533) + lmat( 533)
         mat( 536) = mat( 536) + lmat( 536)
         mat( 543) = lmat( 543)
         mat( 547) = mat( 547) + lmat( 547)
         mat( 550) = mat( 550) + lmat( 550)
         mat( 554) = lmat( 554)
         mat( 555) = lmat( 555)
         mat( 566) = mat( 566) + lmat( 566)
         mat( 586) = mat( 586) + lmat( 586)
         mat( 600) = lmat( 600)
         mat( 604) = mat( 604) + lmat( 604)
         mat( 605) = mat( 605) + lmat( 605)
         mat( 617) = mat( 617) + lmat( 617)
         mat( 635) = mat( 635) + lmat( 635)
         mat( 643) = mat( 643) + lmat( 643)
         mat( 649) = mat( 649) + lmat( 649)
         mat( 662) = mat( 662) + lmat( 662)
         mat( 668) = mat( 668) + lmat( 668)
         mat( 672) = mat( 672) + lmat( 672)
         mat( 673) = mat( 673) + lmat( 673)
         mat( 678) = mat( 678) + lmat( 678)
         mat( 759) = mat( 759) + lmat( 759)
         mat( 760) = mat( 760) + lmat( 760)
         mat( 793) = mat( 793) + lmat( 793)
         mat( 818) = mat( 818) + lmat( 818)
         mat( 835) = mat( 835) + lmat( 835)
         mat( 843) = mat( 843) + lmat( 843)
         mat( 898) = mat( 898) + lmat( 898)
         mat( 943) = mat( 943) + lmat( 943)
         mat( 950) = mat( 950) + lmat( 950)
         mat( 965) = mat( 965) + lmat( 965)
         mat( 972) = mat( 972) + lmat( 972)
         mat( 978) = mat( 978) + lmat( 978)
         mat( 979) = mat( 979) + lmat( 979)
         mat( 195) = 0._r8
         mat( 270) = 0._r8
         mat( 296) = 0._r8
         mat( 299) = 0._r8
         mat( 308) = 0._r8
         mat( 311) = 0._r8
         mat( 315) = 0._r8
         mat( 321) = 0._r8
         mat( 333) = 0._r8
         mat( 336) = 0._r8
         mat( 342) = 0._r8
         mat( 345) = 0._r8
         mat( 347) = 0._r8
         mat( 348) = 0._r8
         mat( 351) = 0._r8
         mat( 352) = 0._r8
         mat( 353) = 0._r8
         mat( 363) = 0._r8
         mat( 377) = 0._r8
         mat( 380) = 0._r8
         mat( 382) = 0._r8
         mat( 396) = 0._r8
         mat( 402) = 0._r8
         mat( 410) = 0._r8
         mat( 414) = 0._r8
         mat( 415) = 0._r8
         mat( 416) = 0._r8
         mat( 424) = 0._r8
         mat( 425) = 0._r8
         mat( 429) = 0._r8
         mat( 433) = 0._r8
         mat( 449) = 0._r8
         mat( 457) = 0._r8
         mat( 468) = 0._r8
         mat( 471) = 0._r8
         mat( 473) = 0._r8
         mat( 484) = 0._r8
         mat( 508) = 0._r8
         mat( 523) = 0._r8
         mat( 532) = 0._r8
         mat( 539) = 0._r8
         mat( 545) = 0._r8
         mat( 552) = 0._r8
         mat( 557) = 0._r8
         mat( 558) = 0._r8
         mat( 565) = 0._r8
         mat( 570) = 0._r8
         mat( 573) = 0._r8
         mat( 582) = 0._r8
         mat( 583) = 0._r8
         mat( 585) = 0._r8
         mat( 588) = 0._r8
         mat( 589) = 0._r8
         mat( 591) = 0._r8
         mat( 594) = 0._r8
         mat( 602) = 0._r8
         mat( 606) = 0._r8
         mat( 607) = 0._r8
         mat( 609) = 0._r8
         mat( 611) = 0._r8
         mat( 614) = 0._r8
         mat( 615) = 0._r8
         mat( 616) = 0._r8
         mat( 618) = 0._r8
         mat( 619) = 0._r8
         mat( 621) = 0._r8
         mat( 623) = 0._r8
         mat( 624) = 0._r8
         mat( 629) = 0._r8
         mat( 630) = 0._r8
         mat( 633) = 0._r8
         mat( 637) = 0._r8
         mat( 638) = 0._r8
         mat( 639) = 0._r8
         mat( 642) = 0._r8
         mat( 645) = 0._r8
         mat( 646) = 0._r8
         mat( 653) = 0._r8
         mat( 665) = 0._r8
         mat( 666) = 0._r8
         mat( 667) = 0._r8
         mat( 669) = 0._r8
         mat( 670) = 0._r8
         mat( 674) = 0._r8
         mat( 725) = 0._r8
         mat( 742) = 0._r8
         mat( 745) = 0._r8
         mat( 764) = 0._r8
         mat( 776) = 0._r8
         mat( 777) = 0._r8
         mat( 784) = 0._r8
         mat( 790) = 0._r8
         mat( 792) = 0._r8
         mat( 798) = 0._r8
         mat( 816) = 0._r8
         mat( 822) = 0._r8
         mat( 826) = 0._r8
         mat( 827) = 0._r8
         mat( 829) = 0._r8
         mat( 832) = 0._r8
         mat( 844) = 0._r8
         mat( 863) = 0._r8
         mat( 866) = 0._r8
         mat( 869) = 0._r8
         mat( 873) = 0._r8
         mat( 877) = 0._r8
         mat( 878) = 0._r8
         mat( 882) = 0._r8
         mat( 884) = 0._r8
         mat( 891) = 0._r8
         mat( 960) = 0._r8
         mat( 971) = 0._r8
         mat( 974) = 0._r8
         mat( 1) = mat( 1) - dti
         mat( 2) = mat( 2) - dti
         mat( 3) = mat( 3) - dti
         mat( 4) = mat( 4) - dti
         mat( 5) = mat( 5) - dti
         mat( 6) = mat( 6) - dti
         mat( 7) = mat( 7) - dti
         mat( 8) = mat( 8) - dti
         mat( 9) = mat( 9) - dti
         mat( 10) = mat( 10) - dti
         mat( 11) = mat( 11) - dti
         mat( 12) = mat( 12) - dti
         mat( 13) = mat( 13) - dti
         mat( 14) = mat( 14) - dti
         mat( 15) = mat( 15) - dti
         mat( 16) = mat( 16) - dti
         mat( 18) = mat( 18) - dti
         mat( 19) = mat( 19) - dti
         mat( 21) = mat( 21) - dti
         mat( 22) = mat( 22) - dti
         mat( 23) = mat( 23) - dti
         mat( 24) = mat( 24) - dti
         mat( 25) = mat( 25) - dti
         mat( 26) = mat( 26) - dti
         mat( 27) = mat( 27) - dti
         mat( 28) = mat( 28) - dti
         mat( 29) = mat( 29) - dti
         mat( 30) = mat( 30) - dti
         mat( 31) = mat( 31) - dti
         mat( 32) = mat( 32) - dti
         mat( 33) = mat( 33) - dti
         mat( 34) = mat( 34) - dti
         mat( 35) = mat( 35) - dti
         mat( 36) = mat( 36) - dti
         mat( 37) = mat( 37) - dti
         mat( 38) = mat( 38) - dti
         mat( 39) = mat( 39) - dti
         mat( 40) = mat( 40) - dti
         mat( 42) = mat( 42) - dti
         mat( 45) = mat( 45) - dti
         mat( 48) = mat( 48) - dti
         mat( 51) = mat( 51) - dti
         mat( 54) = mat( 54) - dti
         mat( 57) = mat( 57) - dti
         mat( 60) = mat( 60) - dti
         mat( 64) = mat( 64) - dti
         mat( 66) = mat( 66) - dti
         mat( 71) = mat( 71) - dti
         mat( 74) = mat( 74) - dti
         mat( 77) = mat( 77) - dti
         mat( 83) = mat( 83) - dti
         mat( 87) = mat( 87) - dti
         mat( 91) = mat( 91) - dti
         mat( 95) = mat( 95) - dti
         mat( 100) = mat( 100) - dti
         mat( 104) = mat( 104) - dti
         mat( 108) = mat( 108) - dti
         mat( 112) = mat( 112) - dti
         mat( 118) = mat( 118) - dti
         mat( 123) = mat( 123) - dti
         mat( 128) = mat( 128) - dti
         mat( 133) = mat( 133) - dti
         mat( 138) = mat( 138) - dti
         mat( 143) = mat( 143) - dti
         mat( 148) = mat( 148) - dti
         mat( 152) = mat( 152) - dti
         mat( 159) = mat( 159) - dti
         mat( 164) = mat( 164) - dti
         mat( 171) = mat( 171) - dti
         mat( 174) = mat( 174) - dti
         mat( 181) = mat( 181) - dti
         mat( 187) = mat( 187) - dti
         mat( 192) = mat( 192) - dti
         mat( 198) = mat( 198) - dti
         mat( 203) = mat( 203) - dti
         mat( 206) = mat( 206) - dti
         mat( 212) = mat( 212) - dti
         mat( 219) = mat( 219) - dti
         mat( 226) = mat( 226) - dti
         mat( 233) = mat( 233) - dti
         mat( 237) = mat( 237) - dti
         mat( 244) = mat( 244) - dti
         mat( 252) = mat( 252) - dti
         mat( 260) = mat( 260) - dti
         mat( 265) = mat( 265) - dti
         mat( 273) = mat( 273) - dti
         mat( 279) = mat( 279) - dti
         mat( 284) = mat( 284) - dti
         mat( 295) = mat( 295) - dti
         mat( 302) = mat( 302) - dti
         mat( 307) = mat( 307) - dti
         mat( 318) = mat( 318) - dti
         mat( 325) = mat( 325) - dti
         mat( 331) = mat( 331) - dti
         mat( 344) = mat( 344) - dti
         mat( 359) = mat( 359) - dti
         mat( 368) = mat( 368) - dti
         mat( 375) = mat( 375) - dti
         mat( 386) = mat( 386) - dti
         mat( 401) = mat( 401) - dti
         mat( 409) = mat( 409) - dti
         mat( 422) = mat( 422) - dti
         mat( 438) = mat( 438) - dti
         mat( 447) = mat( 447) - dti
         mat( 456) = mat( 456) - dti
         mat( 466) = mat( 466) - dti
         mat( 479) = mat( 479) - dti
         mat( 489) = mat( 489) - dti
         mat( 495) = mat( 495) - dti
         mat( 506) = mat( 506) - dti
         mat( 519) = mat( 519) - dti
         mat( 533) = mat( 533) - dti
         mat( 547) = mat( 547) - dti
         mat( 566) = mat( 566) - dti
         mat( 586) = mat( 586) - dti
         mat( 604) = mat( 604) - dti
         mat( 617) = mat( 617) - dti
         mat( 649) = mat( 649) - dti
         mat( 672) = mat( 672) - dti
         mat( 759) = mat( 759) - dti
         mat( 793) = mat( 793) - dti
         mat( 818) = mat( 818) - dti
         mat( 835) = mat( 835) - dti
         mat( 898) = mat( 898) - dti
         mat( 943) = mat( 943) - dti
         mat( 979) = mat( 979) - dti
      end subroutine nlnmat_finit
      subroutine nlnmat( mat, y, rxt, lmat, dti )
      use chem_mods, only : gas_pcnst, rxntot, nzcnt
      implicit none
!----------------------------------------------
! ... dummy arguments
!----------------------------------------------
      real(r8), intent(in) :: dti
      real(r8), intent(in) :: lmat(nzcnt)
      real(r8), intent(in) :: y(gas_pcnst)
      real(r8), intent(in) :: rxt(rxntot)
      real(r8), intent(inout) :: mat(nzcnt)
      call nlnmat01( mat, y, rxt )
      call nlnmat02( mat, y, rxt )
      call nlnmat03( mat, y, rxt )
      call nlnmat04( mat, y, rxt )
      call nlnmat05( mat, y, rxt )
      call nlnmat_finit( mat, lmat, dti )
      end subroutine nlnmat
      end module mo_nln_matrix
