#include "dtypes.h"
!===================================================
! DO NOT EDIT THIS FILE, it was generated using bin/genf90.pl 
! Any changes you make to this file may be lost
!===================================================
! Not a module - this line is required by genf90.pl
!>
!! @file 
!! $Revision: 757 $
!! $LastChangedDate: 2013-04-02 13:55:15 -0600 (Tue, 02 Apr 2013) $
!! @brief Callback functions for Asyncronous IO 
!<
# 8 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
subroutine string_handler_for_var1(file, varid, index, ndims, strlen, msg)
  use pio, only : file_desc_t, pio_get_var, pio_put_var
  use pio_msg_mod, only : pio_msg_getvar1
  implicit none
  type(file_desc_t) :: file
  integer, intent(in) :: varid, strlen, msg, ndims
  integer, intent(in) :: index(ndims)
  character(len=strlen) :: str
  integer :: ierr

  if(msg==PIO_MSG_GETVAR1) then
     ierr = pio_get_var(file, varid, index, str )  
  else
     ierr = pio_put_var(file, varid, index, str )  
  end if
# 23 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
end subroutine string_handler_for_var1

# 25 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
subroutine var1_handler(ios, msg)
  use pio, only : iosystem_desc_t, file_desc_t, pio_get_var, pio_put_var
  use pio_kinds, only : i4, r4, r8, pio_offset
  use pio_msg_mod, only : lookupfile, pio_msg_getvar1
  use pio_support, only : debugAsync
#ifndef NO_MPIMOD
  use mpi ! _EXTERNAL
#endif
  implicit none
#ifdef NO_MPIMOD
  include 'mpif.h' !_EXTERNAL
#endif

  type(iosystem_desc_t), intent(inout) :: ios
  integer, intent(in) :: msg
  type(file_desc_t), pointer :: file
  integer :: fh, varid, ierr, itype, strlen, size_index
  integer, allocatable :: index(:)

  real(r4) :: rvar
  real(r8) :: dvar
  integer(i4) :: ivar

  call mpi_bcast(fh, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(varid, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(size_index, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  allocate(index(size_index))
  call mpi_bcast(index, size_index, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(itype, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  file=> lookupfile(fh)


  if(itype == TYPETEXT) then
     call mpi_bcast(strlen, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
     
     call string_handler_for_var1(file, varid, index, size_index, strlen, msg)
  else
     if(msg==pio_msg_getvar1) then
        select case(itype)
        case (TYPEREAL)
           ierr = pio_get_var(file, varid, index, rvar)
        case (TYPEDOUBLE)
           ierr = pio_get_var(file, varid, index, dvar)
        case (TYPEINT)
           ierr = pio_get_var(file, varid, index, ivar)
        end select
     else
        select case(itype)
        case (TYPEREAL)
           ierr = pio_put_var(file, varid, index, rvar)
        case (TYPEDOUBLE)
           ierr = pio_put_var(file, varid, index, dvar)
        case (TYPEINT)
           ierr = pio_put_var(file, varid, index, ivar)
        end select
     end if
  end if
  deallocate(index)
# 83 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
end subroutine var1_handler

! DIMS 1,2,3,4,5
# 86 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
subroutine vara_1d_handler(ios, msg)
  use pio, only : iosystem_desc_t, file_desc_t, pio_get_var, pio_put_var
  use pio_kinds, only : i4, r4, r8, pio_offset
  use pio_msg_mod, only : lookupfile, pio_msg_getvara_1d
  use pio_support, only : debugAsync
#ifndef NO_MPIMOD
  use mpi ! _EXTERNAL
#endif
  implicit none
#ifdef NO_MPIMOD
  include 'mpif.h' !_EXTERNAL
#endif

  type(iosystem_desc_t), intent(inout) :: ios
  integer,intent(in) :: msg

  type(file_desc_t), pointer :: file
  integer :: fh, varid, ierr, itype, strlen, size_index, ndims
  integer :: dims(1)
  integer, allocatable :: start(:), count(:)
  real(r4), allocatable :: rvar(:)
  real(r8), allocatable :: dvar(:)
  integer(i4), allocatable :: ivar(:)

  call mpi_bcast(fh, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(varid, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(itype, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)

  call mpi_bcast(ndims, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  allocate(start(ndims),count(ndims))
  call mpi_bcast(start, ndims, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(count, ndims, mpi_integer, ios%compmaster, ios%intercomm, ierr)

  call MPI_BCAST(dims,1,MPI_INTEGER,ios%CompMaster, ios%intercomm , ierr)
  
  file=> lookupfile(fh)
  
  select case(itype)
  case (TYPETEXT)
     call mpi_bcast(strlen, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
     call string_handler_for_vara_1d(file, varid, start, count, strlen, dims, msg)
  case (TYPEREAL)
#if(1 == 1)
     allocate(rvar(dims(1)))
#elif(1 == 2)
     allocate(rvar(dims(1),dims(2)))
#elif(1 == 3)
     allocate(rvar(dims(1),dims(2),dims(3)))
#elif(1 == 4)
     allocate(rvar(dims(1),dims(2),dims(3),dims(4)))
#elif(1 == 5)
     allocate(rvar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvara_1d) then
        ierr = pio_get_var(file, varid, start, count, rvar)
     else
        ierr = pio_put_var(file, varid, start, count, rvar)
     end if
     deallocate(rvar)
  case (TYPEDOUBLE)
#if(1 == 1)
     allocate(dvar(dims(1)))
#elif(1 == 2)
     allocate(dvar(dims(1),dims(2)))
#elif(1 == 3)
     allocate(dvar(dims(1),dims(2),dims(3)))
#elif(1 == 4)
     allocate(dvar(dims(1),dims(2),dims(3),dims(4)))
#elif(1 == 5)
     allocate(dvar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvara_1d) then
        ierr = pio_get_var(file, varid, start, count, dvar)
     else
        ierr = pio_put_var(file, varid, start, count, dvar)
     end if
     deallocate(dvar)
  case (TYPEINT)
#if(1 == 1)
     allocate(ivar(dims(1)))
#elif(1 == 2)
     allocate(ivar(dims(1),dims(2)))
#elif(1 == 3)
     allocate(ivar(dims(1),dims(2),dims(3)))
#elif(1 == 4)
     allocate(ivar(dims(1),dims(2),dims(3),dims(4)))
#elif(1 == 5)
     allocate(ivar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvara_1d) then
        ierr = pio_get_var(file, varid, start, count, ivar)
     else
        ierr = pio_put_var(file, varid, start, count, ivar)
     end if
     deallocate(ivar)
  end select
  deallocate(start,count)
# 183 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
end subroutine vara_1d_handler
! DIMS 1,2,3,4,5
# 86 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
subroutine vara_2d_handler(ios, msg)
  use pio, only : iosystem_desc_t, file_desc_t, pio_get_var, pio_put_var
  use pio_kinds, only : i4, r4, r8, pio_offset
  use pio_msg_mod, only : lookupfile, pio_msg_getvara_2d
  use pio_support, only : debugAsync
#ifndef NO_MPIMOD
  use mpi ! _EXTERNAL
#endif
  implicit none
#ifdef NO_MPIMOD
  include 'mpif.h' !_EXTERNAL
#endif

  type(iosystem_desc_t), intent(inout) :: ios
  integer,intent(in) :: msg

  type(file_desc_t), pointer :: file
  integer :: fh, varid, ierr, itype, strlen, size_index, ndims
  integer :: dims(2)
  integer, allocatable :: start(:), count(:)
  real(r4), allocatable :: rvar(:,:)
  real(r8), allocatable :: dvar(:,:)
  integer(i4), allocatable :: ivar(:,:)

  call mpi_bcast(fh, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(varid, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(itype, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)

  call mpi_bcast(ndims, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  allocate(start(ndims),count(ndims))
  call mpi_bcast(start, ndims, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(count, ndims, mpi_integer, ios%compmaster, ios%intercomm, ierr)

  call MPI_BCAST(dims,2,MPI_INTEGER,ios%CompMaster, ios%intercomm , ierr)
  
  file=> lookupfile(fh)
  
  select case(itype)
  case (TYPETEXT)
     call mpi_bcast(strlen, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
     call string_handler_for_vara_2d(file, varid, start, count, strlen, dims, msg)
  case (TYPEREAL)
#if(2 == 1)
     allocate(rvar(dims(1)))
#elif(2 == 2)
     allocate(rvar(dims(1),dims(2)))
#elif(2 == 3)
     allocate(rvar(dims(1),dims(2),dims(3)))
#elif(2 == 4)
     allocate(rvar(dims(1),dims(2),dims(3),dims(4)))
#elif(2 == 5)
     allocate(rvar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvara_2d) then
        ierr = pio_get_var(file, varid, start, count, rvar)
     else
        ierr = pio_put_var(file, varid, start, count, rvar)
     end if
     deallocate(rvar)
  case (TYPEDOUBLE)
#if(2 == 1)
     allocate(dvar(dims(1)))
#elif(2 == 2)
     allocate(dvar(dims(1),dims(2)))
#elif(2 == 3)
     allocate(dvar(dims(1),dims(2),dims(3)))
#elif(2 == 4)
     allocate(dvar(dims(1),dims(2),dims(3),dims(4)))
#elif(2 == 5)
     allocate(dvar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvara_2d) then
        ierr = pio_get_var(file, varid, start, count, dvar)
     else
        ierr = pio_put_var(file, varid, start, count, dvar)
     end if
     deallocate(dvar)
  case (TYPEINT)
#if(2 == 1)
     allocate(ivar(dims(1)))
#elif(2 == 2)
     allocate(ivar(dims(1),dims(2)))
#elif(2 == 3)
     allocate(ivar(dims(1),dims(2),dims(3)))
#elif(2 == 4)
     allocate(ivar(dims(1),dims(2),dims(3),dims(4)))
#elif(2 == 5)
     allocate(ivar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvara_2d) then
        ierr = pio_get_var(file, varid, start, count, ivar)
     else
        ierr = pio_put_var(file, varid, start, count, ivar)
     end if
     deallocate(ivar)
  end select
  deallocate(start,count)
# 183 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
end subroutine vara_2d_handler
! DIMS 1,2,3,4,5
# 86 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
subroutine vara_3d_handler(ios, msg)
  use pio, only : iosystem_desc_t, file_desc_t, pio_get_var, pio_put_var
  use pio_kinds, only : i4, r4, r8, pio_offset
  use pio_msg_mod, only : lookupfile, pio_msg_getvara_3d
  use pio_support, only : debugAsync
#ifndef NO_MPIMOD
  use mpi ! _EXTERNAL
#endif
  implicit none
#ifdef NO_MPIMOD
  include 'mpif.h' !_EXTERNAL
#endif

  type(iosystem_desc_t), intent(inout) :: ios
  integer,intent(in) :: msg

  type(file_desc_t), pointer :: file
  integer :: fh, varid, ierr, itype, strlen, size_index, ndims
  integer :: dims(3)
  integer, allocatable :: start(:), count(:)
  real(r4), allocatable :: rvar(:,:,:)
  real(r8), allocatable :: dvar(:,:,:)
  integer(i4), allocatable :: ivar(:,:,:)

  call mpi_bcast(fh, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(varid, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(itype, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)

  call mpi_bcast(ndims, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  allocate(start(ndims),count(ndims))
  call mpi_bcast(start, ndims, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(count, ndims, mpi_integer, ios%compmaster, ios%intercomm, ierr)

  call MPI_BCAST(dims,3,MPI_INTEGER,ios%CompMaster, ios%intercomm , ierr)
  
  file=> lookupfile(fh)
  
  select case(itype)
  case (TYPETEXT)
     call mpi_bcast(strlen, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
     call string_handler_for_vara_3d(file, varid, start, count, strlen, dims, msg)
  case (TYPEREAL)
#if(3 == 1)
     allocate(rvar(dims(1)))
#elif(3 == 2)
     allocate(rvar(dims(1),dims(2)))
#elif(3 == 3)
     allocate(rvar(dims(1),dims(2),dims(3)))
#elif(3 == 4)
     allocate(rvar(dims(1),dims(2),dims(3),dims(4)))
#elif(3 == 5)
     allocate(rvar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvara_3d) then
        ierr = pio_get_var(file, varid, start, count, rvar)
     else
        ierr = pio_put_var(file, varid, start, count, rvar)
     end if
     deallocate(rvar)
  case (TYPEDOUBLE)
#if(3 == 1)
     allocate(dvar(dims(1)))
#elif(3 == 2)
     allocate(dvar(dims(1),dims(2)))
#elif(3 == 3)
     allocate(dvar(dims(1),dims(2),dims(3)))
#elif(3 == 4)
     allocate(dvar(dims(1),dims(2),dims(3),dims(4)))
#elif(3 == 5)
     allocate(dvar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvara_3d) then
        ierr = pio_get_var(file, varid, start, count, dvar)
     else
        ierr = pio_put_var(file, varid, start, count, dvar)
     end if
     deallocate(dvar)
  case (TYPEINT)
#if(3 == 1)
     allocate(ivar(dims(1)))
#elif(3 == 2)
     allocate(ivar(dims(1),dims(2)))
#elif(3 == 3)
     allocate(ivar(dims(1),dims(2),dims(3)))
#elif(3 == 4)
     allocate(ivar(dims(1),dims(2),dims(3),dims(4)))
#elif(3 == 5)
     allocate(ivar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvara_3d) then
        ierr = pio_get_var(file, varid, start, count, ivar)
     else
        ierr = pio_put_var(file, varid, start, count, ivar)
     end if
     deallocate(ivar)
  end select
  deallocate(start,count)
# 183 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
end subroutine vara_3d_handler
! DIMS 1,2,3,4,5
# 86 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
subroutine vara_4d_handler(ios, msg)
  use pio, only : iosystem_desc_t, file_desc_t, pio_get_var, pio_put_var
  use pio_kinds, only : i4, r4, r8, pio_offset
  use pio_msg_mod, only : lookupfile, pio_msg_getvara_4d
  use pio_support, only : debugAsync
#ifndef NO_MPIMOD
  use mpi ! _EXTERNAL
#endif
  implicit none
#ifdef NO_MPIMOD
  include 'mpif.h' !_EXTERNAL
#endif

  type(iosystem_desc_t), intent(inout) :: ios
  integer,intent(in) :: msg

  type(file_desc_t), pointer :: file
  integer :: fh, varid, ierr, itype, strlen, size_index, ndims
  integer :: dims(4)
  integer, allocatable :: start(:), count(:)
  real(r4), allocatable :: rvar(:,:,:,:)
  real(r8), allocatable :: dvar(:,:,:,:)
  integer(i4), allocatable :: ivar(:,:,:,:)

  call mpi_bcast(fh, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(varid, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(itype, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)

  call mpi_bcast(ndims, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  allocate(start(ndims),count(ndims))
  call mpi_bcast(start, ndims, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(count, ndims, mpi_integer, ios%compmaster, ios%intercomm, ierr)

  call MPI_BCAST(dims,4,MPI_INTEGER,ios%CompMaster, ios%intercomm , ierr)
  
  file=> lookupfile(fh)
  
  select case(itype)
  case (TYPETEXT)
     call mpi_bcast(strlen, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
     call string_handler_for_vara_4d(file, varid, start, count, strlen, dims, msg)
  case (TYPEREAL)
#if(4 == 1)
     allocate(rvar(dims(1)))
#elif(4 == 2)
     allocate(rvar(dims(1),dims(2)))
#elif(4 == 3)
     allocate(rvar(dims(1),dims(2),dims(3)))
#elif(4 == 4)
     allocate(rvar(dims(1),dims(2),dims(3),dims(4)))
#elif(4 == 5)
     allocate(rvar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvara_4d) then
        ierr = pio_get_var(file, varid, start, count, rvar)
     else
        ierr = pio_put_var(file, varid, start, count, rvar)
     end if
     deallocate(rvar)
  case (TYPEDOUBLE)
#if(4 == 1)
     allocate(dvar(dims(1)))
#elif(4 == 2)
     allocate(dvar(dims(1),dims(2)))
#elif(4 == 3)
     allocate(dvar(dims(1),dims(2),dims(3)))
#elif(4 == 4)
     allocate(dvar(dims(1),dims(2),dims(3),dims(4)))
#elif(4 == 5)
     allocate(dvar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvara_4d) then
        ierr = pio_get_var(file, varid, start, count, dvar)
     else
        ierr = pio_put_var(file, varid, start, count, dvar)
     end if
     deallocate(dvar)
  case (TYPEINT)
#if(4 == 1)
     allocate(ivar(dims(1)))
#elif(4 == 2)
     allocate(ivar(dims(1),dims(2)))
#elif(4 == 3)
     allocate(ivar(dims(1),dims(2),dims(3)))
#elif(4 == 4)
     allocate(ivar(dims(1),dims(2),dims(3),dims(4)))
#elif(4 == 5)
     allocate(ivar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvara_4d) then
        ierr = pio_get_var(file, varid, start, count, ivar)
     else
        ierr = pio_put_var(file, varid, start, count, ivar)
     end if
     deallocate(ivar)
  end select
  deallocate(start,count)
# 183 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
end subroutine vara_4d_handler
! DIMS 1,2,3,4,5
# 86 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
subroutine vara_5d_handler(ios, msg)
  use pio, only : iosystem_desc_t, file_desc_t, pio_get_var, pio_put_var
  use pio_kinds, only : i4, r4, r8, pio_offset
  use pio_msg_mod, only : lookupfile, pio_msg_getvara_5d
  use pio_support, only : debugAsync
#ifndef NO_MPIMOD
  use mpi ! _EXTERNAL
#endif
  implicit none
#ifdef NO_MPIMOD
  include 'mpif.h' !_EXTERNAL
#endif

  type(iosystem_desc_t), intent(inout) :: ios
  integer,intent(in) :: msg

  type(file_desc_t), pointer :: file
  integer :: fh, varid, ierr, itype, strlen, size_index, ndims
  integer :: dims(5)
  integer, allocatable :: start(:), count(:)
  real(r4), allocatable :: rvar(:,:,:,:,:)
  real(r8), allocatable :: dvar(:,:,:,:,:)
  integer(i4), allocatable :: ivar(:,:,:,:,:)

  call mpi_bcast(fh, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(varid, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(itype, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)

  call mpi_bcast(ndims, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  allocate(start(ndims),count(ndims))
  call mpi_bcast(start, ndims, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(count, ndims, mpi_integer, ios%compmaster, ios%intercomm, ierr)

  call MPI_BCAST(dims,5,MPI_INTEGER,ios%CompMaster, ios%intercomm , ierr)
  
  file=> lookupfile(fh)
  
  select case(itype)
  case (TYPETEXT)
     call mpi_bcast(strlen, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
     call string_handler_for_vara_5d(file, varid, start, count, strlen, dims, msg)
  case (TYPEREAL)
#if(5 == 1)
     allocate(rvar(dims(1)))
#elif(5 == 2)
     allocate(rvar(dims(1),dims(2)))
#elif(5 == 3)
     allocate(rvar(dims(1),dims(2),dims(3)))
#elif(5 == 4)
     allocate(rvar(dims(1),dims(2),dims(3),dims(4)))
#elif(5 == 5)
     allocate(rvar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvara_5d) then
        ierr = pio_get_var(file, varid, start, count, rvar)
     else
        ierr = pio_put_var(file, varid, start, count, rvar)
     end if
     deallocate(rvar)
  case (TYPEDOUBLE)
#if(5 == 1)
     allocate(dvar(dims(1)))
#elif(5 == 2)
     allocate(dvar(dims(1),dims(2)))
#elif(5 == 3)
     allocate(dvar(dims(1),dims(2),dims(3)))
#elif(5 == 4)
     allocate(dvar(dims(1),dims(2),dims(3),dims(4)))
#elif(5 == 5)
     allocate(dvar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvara_5d) then
        ierr = pio_get_var(file, varid, start, count, dvar)
     else
        ierr = pio_put_var(file, varid, start, count, dvar)
     end if
     deallocate(dvar)
  case (TYPEINT)
#if(5 == 1)
     allocate(ivar(dims(1)))
#elif(5 == 2)
     allocate(ivar(dims(1),dims(2)))
#elif(5 == 3)
     allocate(ivar(dims(1),dims(2),dims(3)))
#elif(5 == 4)
     allocate(ivar(dims(1),dims(2),dims(3),dims(4)))
#elif(5 == 5)
     allocate(ivar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvara_5d) then
        ierr = pio_get_var(file, varid, start, count, ivar)
     else
        ierr = pio_put_var(file, varid, start, count, ivar)
     end if
     deallocate(ivar)
  end select
  deallocate(start,count)
# 183 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
end subroutine vara_5d_handler

# 185 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
subroutine string_handler_for_var_0d(file, varid, strlen, msg)
  use pio, only : file_desc_t, pio_get_var, pio_put_var
  use pio_msg_mod, only : PIO_MSG_GETVAR_0D
  implicit none
  type(file_desc_t) :: file
  integer, intent(in) :: varid, strlen, msg
  character(len=strlen) :: str
  integer :: ierr

  if(msg==PIO_MSG_GETVAR_0D) then
     ierr = pio_get_var(file, varid, str )  
  else
     ierr = pio_put_var(file, varid, str )  
  end if
# 199 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
end subroutine string_handler_for_var_0d
  
# 201 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
subroutine var_0d_handler (ios, msg)
  use pio, only : iosystem_desc_t, file_desc_t, pio_get_var, pio_put_var
  use pio_kinds, only : i4, r4, r8, pio_offset
  use pio_msg_mod, only : lookupfile, pio_msg_getvar_0d 
  use pio_support, only : debugAsync, piodie
#ifndef NO_MPIMOD
  use mpi ! _EXTERNAL
#endif
  implicit none
#ifdef NO_MPIMOD
  include 'mpif.h' !_EXTERNAL
#endif

  type(iosystem_desc_t), intent(inout) :: ios
  integer, intent(in) ::msg
  type(file_desc_t), pointer :: file
  integer :: fh, varid, ierr, itype, strlen, dimcnt

  real(r4) :: rvar
  real(r8) :: dvar
  integer(i4) :: ivar
  
  call mpi_bcast(fh, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(varid, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(itype, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)

  file=> lookupfile(fh)
  
  select case(itype)
  case (TYPETEXT)
     call mpi_bcast(strlen, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
     call string_handler_for_var_0d (file, varid, strlen, msg)
  case (TYPEREAL)
     if(msg == pio_msg_getvar_0D) then
        ierr = pio_get_var(file, varid, rvar)
     else
        ierr = pio_put_var(file, varid, rvar)
     end if
  case (TYPEDOUBLE)
     if(msg == pio_msg_getvar_0D) then
        ierr = pio_get_var(file, varid, dvar)
     else
        ierr = pio_put_var(file, varid, dvar)
     end if
  case (TYPEINT)
     if(msg == pio_msg_getvar_0D) then
        ierr = pio_get_var(file, varid, ivar)
     else
        ierr = pio_put_var(file, varid, ivar)
     end if
  end select
  
# 253 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
end subroutine var_0d_handler

! DIMS 1,2,3,4,5
# 256 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
subroutine string_handler_for_var_1d (file, varid, strlen, dims, msg)
  use pio, only : file_desc_t, pio_get_var, pio_put_var
  use pio_msg_mod, only : pio_msg_getvar_1D
  implicit none
  type(file_desc_t) :: file
  integer, intent(in) :: varid, strlen, dims(1), msg

  character(len=strlen), allocatable :: str(:)
  integer :: ierr  

#if(1 == 1)
  allocate(str(dims(1)))
#elif(1 == 2)
  allocate(str(dims(1),dims(2)))
#elif(1 == 3)
  allocate(str(dims(1),dims(2),dims(3)))
#elif(1 == 4)
  allocate(str(dims(1),dims(2),dims(3),dims(4)))
#elif(1 == 5)
  allocate(str(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
  if(msg == PIO_MSG_GETVAR_1D) then
     ierr = pio_get_var(file, varid, str )  
  else
     ierr = pio_put_var(file, varid, str )  
  end if
  deallocate(str)

# 284 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
end subroutine string_handler_for_var_1d
! DIMS 1,2,3,4,5
# 256 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
subroutine string_handler_for_var_2d (file, varid, strlen, dims, msg)
  use pio, only : file_desc_t, pio_get_var, pio_put_var
  use pio_msg_mod, only : pio_msg_getvar_2D
  implicit none
  type(file_desc_t) :: file
  integer, intent(in) :: varid, strlen, dims(2), msg

  character(len=strlen), allocatable :: str(:,:)
  integer :: ierr  

#if(2 == 1)
  allocate(str(dims(1)))
#elif(2 == 2)
  allocate(str(dims(1),dims(2)))
#elif(2 == 3)
  allocate(str(dims(1),dims(2),dims(3)))
#elif(2 == 4)
  allocate(str(dims(1),dims(2),dims(3),dims(4)))
#elif(2 == 5)
  allocate(str(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
  if(msg == PIO_MSG_GETVAR_2D) then
     ierr = pio_get_var(file, varid, str )  
  else
     ierr = pio_put_var(file, varid, str )  
  end if
  deallocate(str)

# 284 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
end subroutine string_handler_for_var_2d
! DIMS 1,2,3,4,5
# 256 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
subroutine string_handler_for_var_3d (file, varid, strlen, dims, msg)
  use pio, only : file_desc_t, pio_get_var, pio_put_var
  use pio_msg_mod, only : pio_msg_getvar_3D
  implicit none
  type(file_desc_t) :: file
  integer, intent(in) :: varid, strlen, dims(3), msg

  character(len=strlen), allocatable :: str(:,:,:)
  integer :: ierr  

#if(3 == 1)
  allocate(str(dims(1)))
#elif(3 == 2)
  allocate(str(dims(1),dims(2)))
#elif(3 == 3)
  allocate(str(dims(1),dims(2),dims(3)))
#elif(3 == 4)
  allocate(str(dims(1),dims(2),dims(3),dims(4)))
#elif(3 == 5)
  allocate(str(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
  if(msg == PIO_MSG_GETVAR_3D) then
     ierr = pio_get_var(file, varid, str )  
  else
     ierr = pio_put_var(file, varid, str )  
  end if
  deallocate(str)

# 284 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
end subroutine string_handler_for_var_3d
! DIMS 1,2,3,4,5
# 256 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
subroutine string_handler_for_var_4d (file, varid, strlen, dims, msg)
  use pio, only : file_desc_t, pio_get_var, pio_put_var
  use pio_msg_mod, only : pio_msg_getvar_4D
  implicit none
  type(file_desc_t) :: file
  integer, intent(in) :: varid, strlen, dims(4), msg

  character(len=strlen), allocatable :: str(:,:,:,:)
  integer :: ierr  

#if(4 == 1)
  allocate(str(dims(1)))
#elif(4 == 2)
  allocate(str(dims(1),dims(2)))
#elif(4 == 3)
  allocate(str(dims(1),dims(2),dims(3)))
#elif(4 == 4)
  allocate(str(dims(1),dims(2),dims(3),dims(4)))
#elif(4 == 5)
  allocate(str(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
  if(msg == PIO_MSG_GETVAR_4D) then
     ierr = pio_get_var(file, varid, str )  
  else
     ierr = pio_put_var(file, varid, str )  
  end if
  deallocate(str)

# 284 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
end subroutine string_handler_for_var_4d
! DIMS 1,2,3,4,5
# 256 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
subroutine string_handler_for_var_5d (file, varid, strlen, dims, msg)
  use pio, only : file_desc_t, pio_get_var, pio_put_var
  use pio_msg_mod, only : pio_msg_getvar_5D
  implicit none
  type(file_desc_t) :: file
  integer, intent(in) :: varid, strlen, dims(5), msg

  character(len=strlen), allocatable :: str(:,:,:,:,:)
  integer :: ierr  

#if(5 == 1)
  allocate(str(dims(1)))
#elif(5 == 2)
  allocate(str(dims(1),dims(2)))
#elif(5 == 3)
  allocate(str(dims(1),dims(2),dims(3)))
#elif(5 == 4)
  allocate(str(dims(1),dims(2),dims(3),dims(4)))
#elif(5 == 5)
  allocate(str(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
  if(msg == PIO_MSG_GETVAR_5D) then
     ierr = pio_get_var(file, varid, str )  
  else
     ierr = pio_put_var(file, varid, str )  
  end if
  deallocate(str)

# 284 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
end subroutine string_handler_for_var_5d
  
! DIMS 1,2,3,4,5
# 287 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
subroutine string_handler_for_vara_1d (file, varid, start, count, strlen, dims, msg)
  use pio_msg_mod, only : pio_msg_getvara_1d
  use pio, only : file_desc_t, pio_get_var, pio_put_var
  implicit none
  type(file_desc_t) :: file
  integer, intent(in) :: varid, strlen, start(1), count(1), dims(1), msg

  character(len=strlen), allocatable :: str(:)
  integer :: ierr

#if(1 == 1)
  allocate(str(dims(1)))
#elif(1 == 2)
  allocate(str(dims(1),dims(2)))
#elif(1 == 3)
  allocate(str(dims(1),dims(2),dims(3)))
#elif(1 == 4)
  allocate(str(dims(1),dims(2),dims(3),dims(4)))
#elif(1 == 5)
  allocate(str(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
  if(msg==pio_msg_getvara_1d) then
     ierr = pio_get_var(file, varid, start, count, str )  
  else
     str = ' '
     ierr = pio_put_var(file, varid, start, count, str )  
  end if
  deallocate(str)

# 316 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
end subroutine string_handler_for_vara_1d
! DIMS 1,2,3,4,5
# 287 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
subroutine string_handler_for_vara_2d (file, varid, start, count, strlen, dims, msg)
  use pio_msg_mod, only : pio_msg_getvara_2d
  use pio, only : file_desc_t, pio_get_var, pio_put_var
  implicit none
  type(file_desc_t) :: file
  integer, intent(in) :: varid, strlen, start(2), count(2), dims(2), msg

  character(len=strlen), allocatable :: str(:,:)
  integer :: ierr

#if(2 == 1)
  allocate(str(dims(1)))
#elif(2 == 2)
  allocate(str(dims(1),dims(2)))
#elif(2 == 3)
  allocate(str(dims(1),dims(2),dims(3)))
#elif(2 == 4)
  allocate(str(dims(1),dims(2),dims(3),dims(4)))
#elif(2 == 5)
  allocate(str(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
  if(msg==pio_msg_getvara_2d) then
     ierr = pio_get_var(file, varid, start, count, str )  
  else
     str = ' '
     ierr = pio_put_var(file, varid, start, count, str )  
  end if
  deallocate(str)

# 316 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
end subroutine string_handler_for_vara_2d
! DIMS 1,2,3,4,5
# 287 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
subroutine string_handler_for_vara_3d (file, varid, start, count, strlen, dims, msg)
  use pio_msg_mod, only : pio_msg_getvara_3d
  use pio, only : file_desc_t, pio_get_var, pio_put_var
  implicit none
  type(file_desc_t) :: file
  integer, intent(in) :: varid, strlen, start(3), count(3), dims(3), msg

  character(len=strlen), allocatable :: str(:,:,:)
  integer :: ierr

#if(3 == 1)
  allocate(str(dims(1)))
#elif(3 == 2)
  allocate(str(dims(1),dims(2)))
#elif(3 == 3)
  allocate(str(dims(1),dims(2),dims(3)))
#elif(3 == 4)
  allocate(str(dims(1),dims(2),dims(3),dims(4)))
#elif(3 == 5)
  allocate(str(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
  if(msg==pio_msg_getvara_3d) then
     ierr = pio_get_var(file, varid, start, count, str )  
  else
     str = ' '
     ierr = pio_put_var(file, varid, start, count, str )  
  end if
  deallocate(str)

# 316 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
end subroutine string_handler_for_vara_3d
! DIMS 1,2,3,4,5
# 287 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
subroutine string_handler_for_vara_4d (file, varid, start, count, strlen, dims, msg)
  use pio_msg_mod, only : pio_msg_getvara_4d
  use pio, only : file_desc_t, pio_get_var, pio_put_var
  implicit none
  type(file_desc_t) :: file
  integer, intent(in) :: varid, strlen, start(4), count(4), dims(4), msg

  character(len=strlen), allocatable :: str(:,:,:,:)
  integer :: ierr

#if(4 == 1)
  allocate(str(dims(1)))
#elif(4 == 2)
  allocate(str(dims(1),dims(2)))
#elif(4 == 3)
  allocate(str(dims(1),dims(2),dims(3)))
#elif(4 == 4)
  allocate(str(dims(1),dims(2),dims(3),dims(4)))
#elif(4 == 5)
  allocate(str(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
  if(msg==pio_msg_getvara_4d) then
     ierr = pio_get_var(file, varid, start, count, str )  
  else
     str = ' '
     ierr = pio_put_var(file, varid, start, count, str )  
  end if
  deallocate(str)

# 316 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
end subroutine string_handler_for_vara_4d
! DIMS 1,2,3,4,5
# 287 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
subroutine string_handler_for_vara_5d (file, varid, start, count, strlen, dims, msg)
  use pio_msg_mod, only : pio_msg_getvara_5d
  use pio, only : file_desc_t, pio_get_var, pio_put_var
  implicit none
  type(file_desc_t) :: file
  integer, intent(in) :: varid, strlen, start(5), count(5), dims(5), msg

  character(len=strlen), allocatable :: str(:,:,:,:,:)
  integer :: ierr

#if(5 == 1)
  allocate(str(dims(1)))
#elif(5 == 2)
  allocate(str(dims(1),dims(2)))
#elif(5 == 3)
  allocate(str(dims(1),dims(2),dims(3)))
#elif(5 == 4)
  allocate(str(dims(1),dims(2),dims(3),dims(4)))
#elif(5 == 5)
  allocate(str(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
  if(msg==pio_msg_getvara_5d) then
     ierr = pio_get_var(file, varid, start, count, str )  
  else
     str = ' '
     ierr = pio_put_var(file, varid, start, count, str )  
  end if
  deallocate(str)

# 316 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
end subroutine string_handler_for_vara_5d
  

! DIMS 1,2,3,4,5
# 320 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
subroutine var_1d_handler (ios, msg)
  use pio, only : iosystem_desc_t, file_desc_t, pio_get_var, pio_put_var
  use pio_kinds, only : i4, r4, r8, pio_offset
  use pio_msg_mod, only : lookupfile, pio_msg_getvar_1d
  use pio_support, only : debugAsync
#ifndef NO_MPIMOD
  use mpi ! _EXTERNAL
#endif
  implicit none
#ifdef NO_MPIMOD
  include 'mpif.h' !_EXTERNAL
#endif

  type(iosystem_desc_t), intent(inout) :: ios
  integer, intent(in) :: msg

  type(file_desc_t), pointer :: file
  integer :: fh, varid, ierr, itype, strlen, dimcnt
  integer, allocatable :: dims(:)

  real(r4), allocatable    :: rvar(:)
  real(r8), allocatable    :: dvar(:)
  integer(i4), allocatable :: ivar(:)
  
  call mpi_bcast(fh, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(varid, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(itype, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)

  allocate(dims(1))
  call mpi_bcast(dims, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)


  file=> lookupfile(fh)
  
  select case(itype)
  case (TYPETEXT)
     call mpi_bcast(strlen, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
     call string_handler_for_var_1d (file, varid, strlen, dims, msg)
  case (TYPEREAL)
#if(1 == 1)
     allocate(rvar(dims(1)))
#elif(1 == 2)
     allocate(rvar(dims(1),dims(2)))
#elif(1 == 3)
     allocate(rvar(dims(1),dims(2),dims(3)))
#elif(1 == 4)
     allocate(rvar(dims(1),dims(2),dims(3),dims(4)))
#elif(1 == 5)
     allocate(rvar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvar_1d ) then
        ierr = pio_get_var(file, varid,  rvar)
     else
        ierr = pio_put_var(file, varid,  rvar)
     end if
     deallocate(rvar)
  case (TYPEDOUBLE)
#if(1 == 1)
  allocate(dvar(dims(1)))
#elif(1 == 2)
  allocate(dvar(dims(1),dims(2)))
#elif(1 == 3)
  allocate(dvar(dims(1),dims(2),dims(3)))
#elif(1 == 4)
  allocate(dvar(dims(1),dims(2),dims(3),dims(4)))
#elif(1 == 5)
  allocate(dvar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvar_1d ) then
        ierr = pio_get_var(file, varid,  dvar)  
     else
        ierr = pio_put_var(file, varid,  dvar)  
     end if
     deallocate(dvar)
  case (TYPEINT)
#if(1 == 1)
  allocate(ivar(dims(1)))
#elif(1 == 2)
  allocate(ivar(dims(1),dims(2)))
#elif(1 == 3)
  allocate(ivar(dims(1),dims(2),dims(3)))
#elif(1 == 4)
  allocate(ivar(dims(1),dims(2),dims(3),dims(4)))
#elif(1 == 5)
  allocate(ivar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvar_1d ) then
        ierr = pio_get_var(file, varid,  ivar)
     else
        ierr = pio_put_var(file, varid,  ivar)
     end if
     deallocate(ivar)
  end select
  
# 414 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
end subroutine var_1d_handler
! DIMS 1,2,3,4,5
# 320 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
subroutine var_2d_handler (ios, msg)
  use pio, only : iosystem_desc_t, file_desc_t, pio_get_var, pio_put_var
  use pio_kinds, only : i4, r4, r8, pio_offset
  use pio_msg_mod, only : lookupfile, pio_msg_getvar_2d
  use pio_support, only : debugAsync
#ifndef NO_MPIMOD
  use mpi ! _EXTERNAL
#endif
  implicit none
#ifdef NO_MPIMOD
  include 'mpif.h' !_EXTERNAL
#endif

  type(iosystem_desc_t), intent(inout) :: ios
  integer, intent(in) :: msg

  type(file_desc_t), pointer :: file
  integer :: fh, varid, ierr, itype, strlen, dimcnt
  integer, allocatable :: dims(:)

  real(r4), allocatable    :: rvar(:,:)
  real(r8), allocatable    :: dvar(:,:)
  integer(i4), allocatable :: ivar(:,:)
  
  call mpi_bcast(fh, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(varid, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(itype, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)

  allocate(dims(2))
  call mpi_bcast(dims, 2, mpi_integer, ios%compmaster, ios%intercomm, ierr)


  file=> lookupfile(fh)
  
  select case(itype)
  case (TYPETEXT)
     call mpi_bcast(strlen, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
     call string_handler_for_var_2d (file, varid, strlen, dims, msg)
  case (TYPEREAL)
#if(2 == 1)
     allocate(rvar(dims(1)))
#elif(2 == 2)
     allocate(rvar(dims(1),dims(2)))
#elif(2 == 3)
     allocate(rvar(dims(1),dims(2),dims(3)))
#elif(2 == 4)
     allocate(rvar(dims(1),dims(2),dims(3),dims(4)))
#elif(2 == 5)
     allocate(rvar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvar_2d ) then
        ierr = pio_get_var(file, varid,  rvar)
     else
        ierr = pio_put_var(file, varid,  rvar)
     end if
     deallocate(rvar)
  case (TYPEDOUBLE)
#if(2 == 1)
  allocate(dvar(dims(1)))
#elif(2 == 2)
  allocate(dvar(dims(1),dims(2)))
#elif(2 == 3)
  allocate(dvar(dims(1),dims(2),dims(3)))
#elif(2 == 4)
  allocate(dvar(dims(1),dims(2),dims(3),dims(4)))
#elif(2 == 5)
  allocate(dvar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvar_2d ) then
        ierr = pio_get_var(file, varid,  dvar)  
     else
        ierr = pio_put_var(file, varid,  dvar)  
     end if
     deallocate(dvar)
  case (TYPEINT)
#if(2 == 1)
  allocate(ivar(dims(1)))
#elif(2 == 2)
  allocate(ivar(dims(1),dims(2)))
#elif(2 == 3)
  allocate(ivar(dims(1),dims(2),dims(3)))
#elif(2 == 4)
  allocate(ivar(dims(1),dims(2),dims(3),dims(4)))
#elif(2 == 5)
  allocate(ivar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvar_2d ) then
        ierr = pio_get_var(file, varid,  ivar)
     else
        ierr = pio_put_var(file, varid,  ivar)
     end if
     deallocate(ivar)
  end select
  
# 414 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
end subroutine var_2d_handler
! DIMS 1,2,3,4,5
# 320 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
subroutine var_3d_handler (ios, msg)
  use pio, only : iosystem_desc_t, file_desc_t, pio_get_var, pio_put_var
  use pio_kinds, only : i4, r4, r8, pio_offset
  use pio_msg_mod, only : lookupfile, pio_msg_getvar_3d
  use pio_support, only : debugAsync
#ifndef NO_MPIMOD
  use mpi ! _EXTERNAL
#endif
  implicit none
#ifdef NO_MPIMOD
  include 'mpif.h' !_EXTERNAL
#endif

  type(iosystem_desc_t), intent(inout) :: ios
  integer, intent(in) :: msg

  type(file_desc_t), pointer :: file
  integer :: fh, varid, ierr, itype, strlen, dimcnt
  integer, allocatable :: dims(:)

  real(r4), allocatable    :: rvar(:,:,:)
  real(r8), allocatable    :: dvar(:,:,:)
  integer(i4), allocatable :: ivar(:,:,:)
  
  call mpi_bcast(fh, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(varid, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(itype, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)

  allocate(dims(3))
  call mpi_bcast(dims, 3, mpi_integer, ios%compmaster, ios%intercomm, ierr)


  file=> lookupfile(fh)
  
  select case(itype)
  case (TYPETEXT)
     call mpi_bcast(strlen, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
     call string_handler_for_var_3d (file, varid, strlen, dims, msg)
  case (TYPEREAL)
#if(3 == 1)
     allocate(rvar(dims(1)))
#elif(3 == 2)
     allocate(rvar(dims(1),dims(2)))
#elif(3 == 3)
     allocate(rvar(dims(1),dims(2),dims(3)))
#elif(3 == 4)
     allocate(rvar(dims(1),dims(2),dims(3),dims(4)))
#elif(3 == 5)
     allocate(rvar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvar_3d ) then
        ierr = pio_get_var(file, varid,  rvar)
     else
        ierr = pio_put_var(file, varid,  rvar)
     end if
     deallocate(rvar)
  case (TYPEDOUBLE)
#if(3 == 1)
  allocate(dvar(dims(1)))
#elif(3 == 2)
  allocate(dvar(dims(1),dims(2)))
#elif(3 == 3)
  allocate(dvar(dims(1),dims(2),dims(3)))
#elif(3 == 4)
  allocate(dvar(dims(1),dims(2),dims(3),dims(4)))
#elif(3 == 5)
  allocate(dvar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvar_3d ) then
        ierr = pio_get_var(file, varid,  dvar)  
     else
        ierr = pio_put_var(file, varid,  dvar)  
     end if
     deallocate(dvar)
  case (TYPEINT)
#if(3 == 1)
  allocate(ivar(dims(1)))
#elif(3 == 2)
  allocate(ivar(dims(1),dims(2)))
#elif(3 == 3)
  allocate(ivar(dims(1),dims(2),dims(3)))
#elif(3 == 4)
  allocate(ivar(dims(1),dims(2),dims(3),dims(4)))
#elif(3 == 5)
  allocate(ivar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvar_3d ) then
        ierr = pio_get_var(file, varid,  ivar)
     else
        ierr = pio_put_var(file, varid,  ivar)
     end if
     deallocate(ivar)
  end select
  
# 414 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
end subroutine var_3d_handler
! DIMS 1,2,3,4,5
# 320 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
subroutine var_4d_handler (ios, msg)
  use pio, only : iosystem_desc_t, file_desc_t, pio_get_var, pio_put_var
  use pio_kinds, only : i4, r4, r8, pio_offset
  use pio_msg_mod, only : lookupfile, pio_msg_getvar_4d
  use pio_support, only : debugAsync
#ifndef NO_MPIMOD
  use mpi ! _EXTERNAL
#endif
  implicit none
#ifdef NO_MPIMOD
  include 'mpif.h' !_EXTERNAL
#endif

  type(iosystem_desc_t), intent(inout) :: ios
  integer, intent(in) :: msg

  type(file_desc_t), pointer :: file
  integer :: fh, varid, ierr, itype, strlen, dimcnt
  integer, allocatable :: dims(:)

  real(r4), allocatable    :: rvar(:,:,:,:)
  real(r8), allocatable    :: dvar(:,:,:,:)
  integer(i4), allocatable :: ivar(:,:,:,:)
  
  call mpi_bcast(fh, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(varid, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(itype, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)

  allocate(dims(4))
  call mpi_bcast(dims, 4, mpi_integer, ios%compmaster, ios%intercomm, ierr)


  file=> lookupfile(fh)
  
  select case(itype)
  case (TYPETEXT)
     call mpi_bcast(strlen, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
     call string_handler_for_var_4d (file, varid, strlen, dims, msg)
  case (TYPEREAL)
#if(4 == 1)
     allocate(rvar(dims(1)))
#elif(4 == 2)
     allocate(rvar(dims(1),dims(2)))
#elif(4 == 3)
     allocate(rvar(dims(1),dims(2),dims(3)))
#elif(4 == 4)
     allocate(rvar(dims(1),dims(2),dims(3),dims(4)))
#elif(4 == 5)
     allocate(rvar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvar_4d ) then
        ierr = pio_get_var(file, varid,  rvar)
     else
        ierr = pio_put_var(file, varid,  rvar)
     end if
     deallocate(rvar)
  case (TYPEDOUBLE)
#if(4 == 1)
  allocate(dvar(dims(1)))
#elif(4 == 2)
  allocate(dvar(dims(1),dims(2)))
#elif(4 == 3)
  allocate(dvar(dims(1),dims(2),dims(3)))
#elif(4 == 4)
  allocate(dvar(dims(1),dims(2),dims(3),dims(4)))
#elif(4 == 5)
  allocate(dvar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvar_4d ) then
        ierr = pio_get_var(file, varid,  dvar)  
     else
        ierr = pio_put_var(file, varid,  dvar)  
     end if
     deallocate(dvar)
  case (TYPEINT)
#if(4 == 1)
  allocate(ivar(dims(1)))
#elif(4 == 2)
  allocate(ivar(dims(1),dims(2)))
#elif(4 == 3)
  allocate(ivar(dims(1),dims(2),dims(3)))
#elif(4 == 4)
  allocate(ivar(dims(1),dims(2),dims(3),dims(4)))
#elif(4 == 5)
  allocate(ivar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvar_4d ) then
        ierr = pio_get_var(file, varid,  ivar)
     else
        ierr = pio_put_var(file, varid,  ivar)
     end if
     deallocate(ivar)
  end select
  
# 414 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
end subroutine var_4d_handler
! DIMS 1,2,3,4,5
# 320 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
subroutine var_5d_handler (ios, msg)
  use pio, only : iosystem_desc_t, file_desc_t, pio_get_var, pio_put_var
  use pio_kinds, only : i4, r4, r8, pio_offset
  use pio_msg_mod, only : lookupfile, pio_msg_getvar_5d
  use pio_support, only : debugAsync
#ifndef NO_MPIMOD
  use mpi ! _EXTERNAL
#endif
  implicit none
#ifdef NO_MPIMOD
  include 'mpif.h' !_EXTERNAL
#endif

  type(iosystem_desc_t), intent(inout) :: ios
  integer, intent(in) :: msg

  type(file_desc_t), pointer :: file
  integer :: fh, varid, ierr, itype, strlen, dimcnt
  integer, allocatable :: dims(:)

  real(r4), allocatable    :: rvar(:,:,:,:,:)
  real(r8), allocatable    :: dvar(:,:,:,:,:)
  integer(i4), allocatable :: ivar(:,:,:,:,:)
  
  call mpi_bcast(fh, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(varid, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
  call mpi_bcast(itype, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)

  allocate(dims(5))
  call mpi_bcast(dims, 5, mpi_integer, ios%compmaster, ios%intercomm, ierr)


  file=> lookupfile(fh)
  
  select case(itype)
  case (TYPETEXT)
     call mpi_bcast(strlen, 1, mpi_integer, ios%compmaster, ios%intercomm, ierr)
     call string_handler_for_var_5d (file, varid, strlen, dims, msg)
  case (TYPEREAL)
#if(5 == 1)
     allocate(rvar(dims(1)))
#elif(5 == 2)
     allocate(rvar(dims(1),dims(2)))
#elif(5 == 3)
     allocate(rvar(dims(1),dims(2),dims(3)))
#elif(5 == 4)
     allocate(rvar(dims(1),dims(2),dims(3),dims(4)))
#elif(5 == 5)
     allocate(rvar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvar_5d ) then
        ierr = pio_get_var(file, varid,  rvar)
     else
        ierr = pio_put_var(file, varid,  rvar)
     end if
     deallocate(rvar)
  case (TYPEDOUBLE)
#if(5 == 1)
  allocate(dvar(dims(1)))
#elif(5 == 2)
  allocate(dvar(dims(1),dims(2)))
#elif(5 == 3)
  allocate(dvar(dims(1),dims(2),dims(3)))
#elif(5 == 4)
  allocate(dvar(dims(1),dims(2),dims(3),dims(4)))
#elif(5 == 5)
  allocate(dvar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvar_5d ) then
        ierr = pio_get_var(file, varid,  dvar)  
     else
        ierr = pio_put_var(file, varid,  dvar)  
     end if
     deallocate(dvar)
  case (TYPEINT)
#if(5 == 1)
  allocate(ivar(dims(1)))
#elif(5 == 2)
  allocate(ivar(dims(1),dims(2)))
#elif(5 == 3)
  allocate(ivar(dims(1),dims(2),dims(3)))
#elif(5 == 4)
  allocate(ivar(dims(1),dims(2),dims(3),dims(4)))
#elif(5 == 5)
  allocate(ivar(dims(1),dims(2),dims(3),dims(4),dims(5)))
#endif
     if(msg==pio_msg_getvar_5d ) then
        ierr = pio_get_var(file, varid,  ivar)
     else
        ierr = pio_put_var(file, varid,  ivar)
     end if
     deallocate(ivar)
  end select
  
# 414 "/glade/u/home/jedwards/pio_trunk/pio/pio_msg_getput_callbacks.F90.in"
end subroutine var_5d_handler

