module convect_ke_intr

  ! interface for convection

  use shr_kind_mod,  only: r8=>shr_kind_r8
  use ppgrid,        only: pcols, pver, pverp
  use constituents,  only: pcnst, cnst_get_ind
  use perf_mod

  private
  integer ixcldice, ixcldliq, cbmf_index, wgustw_index
  public :: convect_ke_intr_tend,  convect_ke_intr_init, convect_ke_intr_reg

  ! Local variables

  save

  !dance test
  real(r8) a

contains

  subroutine convect_ke_intr_reg

!  declare output fields, initialize variables needed by convection

    use phys_buffer, only: pbuf_times, pbuf_add

    implicit none

!    write (6,*) ' convect_ke_intr_reg: registering deep convection '
   
    call pbuf_add('cbmf','global',1,1,pbuf_times, cbmf_index)
    call pbuf_add('wgustw','global',1,1,1, wgustw_index)
    write (6,*) ' wgustw_index is ', wgustw_index

    !	write (6,*) ' convect_ke_intr_reg: done '

  end subroutine convect_ke_intr_reg


  subroutine convect_ke_intr_init()

!  declare output fields, initialize variables needed by convection

    use cam_history,         only: outfld, addfld, add_default, phys_decomp
    use zm_conv, only: zm_convi
    use phys_buffer, only: pbuf_times, pbuf_add

    implicit none

    !	write (6,*) ' convect_ke_intr_init: initializing deep convection '

    call cnst_get_ind('CLDICE', ixcldice)
    call cnst_get_ind('CLDLIQ', ixcldliq)

    call addfld ('DPT_TEND','K/s'    ,pver , 'A','Convective Heating by deep convection',phys_decomp)
    call addfld ('DPQ_TEND','kg/kgs'    ,pver , 'A','Convective moistening by deep convection',phys_decomp)
    call addfld ('PCONVB','Pa'    ,1 , 'A','convection base pressure',phys_decomp)
    call addfld ('PCONVT','Pa'    ,1 , 'A','convection top  pressure',phys_decomp)
    call addfld ('CBMF_KE','kg/m2/s' ,1 , 'A','cloud bass mass flux',phys_decomp)
    call addfld ('WGUSTW','m/s' ,1 , 'A','wind gusts from convection',phys_decomp)
    call addfld ('RNK','index' ,1 , 'A','level of convection launch',phys_decomp)

    call addfld ('CMFMCDKE','kg/m2/s ',pverp,'A','Convection mass flux from Kerry-Emanuel deep',phys_decomp)
    call addfld ('PRECCDKE','m/s     ',1,    'A','Convective precipitation rate from Kerry-Emanuel deep',phys_decomp)

!    call addfld ('CIN ','J/kg    ',1,    'A','Convective inhibition',phys_decomp)
     call addfld ('CAPE','J/kg    ',1,    'A','Convective available potential energy ',phys_decomp)


    call add_default ('DPT_TEND', 1, ' ')
    call add_default ('DPQ_TEND', 1, ' ')
    call add_default ('PCONVB', 1, ' ')
    call add_default ('PCONVT', 1, ' ')
    call add_default ('CMFMCDKE', 1, ' ')
    call add_default ('PRECCDKE', 1, ' ')
    call add_default ('CBMF_KE', 1, ' ')
    call add_default ('WGUSTW', 1, ' ')
    call add_default ('RNK', 1, ' ')

    !	write (6,*) ' convect_ke_intr_init: done '

  end subroutine convect_ke_intr_init

  subroutine convect_ke_intr_tend( precc, cnt, cnb,  &
       pblht,  net_mf, &
       tpert, dlf ,  zdu,&
       rliq, &
       ztodt, snow, &
      state, ptend,  pbuf ) 

    use physics_types,    only: physics_state, physics_ptend, physics_ptend_init
    use cam_history,          only: outfld
    use wv_saturation,    only: aqsat
    use phys_buffer,   only:  pbuf_fld, pbuf_old_tim_idx, pbuf_get_fld_idx,pbuf_size_max
    use time_manager,  only: get_nstep
    use physconst,     only: gravit, latvap, latice, cpair


    implicit none

    ! Arguments
    type(physics_state), intent(in)  :: state     ! state variables
    type(physics_ptend), intent(out) :: ptend   ! package tendencies
    type(pbuf_fld), intent(inout), dimension(pbuf_size_max) :: pbuf  ! physics buffer

    real(r8), intent(in)  :: ztodt                ! timestep
    real(r8), intent(in)    :: pblht(pcols)       ! Planetary boundary layer height

    real(r8), intent(out) :: precc(pcols)                  ! Convective-scale preciptn rate
    real(r8), intent(out) :: snow(pcols)                  ! Convective-scale preciptn rate
    real(r8), intent(out) :: rliq(pcols) ! reserved liquid (not yet in cldliq) for energy integrals, = 0 here.
    real(r8), intent(out) :: dlf(pcols,pver)                   ! Detraining cld H20 from convection
    real(r8), intent(out) :: zdu(pcols,pver)               ! detraining mass flux from deep convection
    real(r8), intent(in) :: tpert(pcols)                ! Thermal temperature excess
    real(r8), intent(out) :: net_mf(pcols,pverp)            ! Convective mass flux--m sub c
    real(r8), intent(out) :: cnt(pcols)                        ! Top level of convective activity
    real(r8), intent(out) :: cnb(pcols)                        ! Lowest level of convective activity

    ! local vars
    integer :: nstep
    real(r8) ftem(pcols,pver)              ! Temporary workspace for outfld variables
    real(r8) w3(pcols,pver)              ! Temporary workspace for outfld variables
    real(r8) pcont(pcols), pconb(pcols)
    integer ltop, lcl
    integer  i,k
    integer nl  !  nl:  the maximum number of levels to which convection can penetrate, plus 1.
! Temporary workspace for variables going into the convection scheme
      real(r8) t_ke(pver), q_ke(pver), qsat_ke(pver), u_ke(pver), v_ke(pver)
      real(r8) p_ke(pver), ph_ke(pver+1)
! Temporary workspace for variables coming out of the convection scheme
      real(r8) ft_ke(pver), fq_ke(pver)
      real(r8) fu_ke(pver), fv_ke(pver)
      real(r8) ftra(pver,pcnst-3)
      real(r8) mup_ke(pver)   ! upward mass flux
      real(r8) mdown_ke(pver) ! downward mass flux
      real(r8) muph_ke(pver+1)! upward mass flux at intermidiate levels
      real(r8) mdownh_ke(pver+1)! downward mass flux at intermidiate levels
      real(r8) det_ke(pver)   ! detrainment
      real(r8) cbmf_ke        ! convective base mass flux (has to be saved)
      real(r8) wd_ke, tprime_ke, qprime_ke
      real(r8) precc_ke
      integer cnt_ke, cnb_ke, iflag
      integer m, mtrans
      real(r8) w1, w2, w4
      real(r8) tracer(pver, pcnst-3)
!      real(r8), pointer, dimension(:) :: cbmf
      real(r8) cbmf(pcols)
      real(r8) rprd(pcols,pver)  ! rain production rate, not yet used

      real(r8) :: est    (pcols,pver)    ! Saturation vapor pressure
      real(r8) :: qsat   (pcols,pver)    ! saturation specific humidity
      real(r8) :: ftoliq                 ! fraction of tend assigned to liquid


      integer lclall(pcols)
      integer lfc(pcols)
      integer lnb(pcols)
      real(r8) cin(pcols)
      real(r8) cape(pcols)
      real(r8) zero(pcols, pver)
      integer mx(pcols)


      integer itime
      integer ifld
      integer ifld_wgustw                        ! index for convective wind gusts
      integer lchnk                              ! chunk identifier
      integer ncol                               ! number of atmospheric columns
      integer nk
      real(r8) rnk(pcols)
      real(r8) wgustw(pcols), wrk1
      integer iwrk1

    !
    call t_startf ('convect_ke_intr_tend')
    nstep = get_nstep()

    lchnk = state%lchnk
    ncol  = state%ncol

    zero(:ncol,:pver) = 0
    call findcin (state%ncol, state%t, state%q, zero, zero,  &
           mx, state%pmid, state%pint, state%zm, &
           lclall, cin, lfc, lnb, cape, "pa")

    call outfld('CAPE    ',cape           ,pcols   ,lchnk   )
    call outfld('CIN     ',cin            ,pcols   ,lchnk   )

#ifdef DEBCONV
      i = 1
      write (6,*) ' mx is ', mx
      write (6,*) ' lclall,lfc,lnb,cin(i,k), cape(i,k)  ', &
              lclall(i),lfc(i),lnb(i),cin(i), cape(i)
#endif


    ! initializer variables that are required by tphysbc but aren't used by this scheme
    rliq = 0.

#ifdef DUMPIT
    OPEN(102, FILE = 'Humid.dat')
    write (102,*)'before convect_ke_intr'
    do k=1,26
       !        k = 26
       !	write(102,1000)nstep,k,state%t(1,k),state%q(1,k,1),ptend%q(1,k,1)
    enddo
#endif

! Associate pointers with physics buffer fields
    itime = pbuf_old_tim_idx()
    ifld = pbuf_get_fld_idx('cbmf')
    ifld_wgustw = pbuf_get_fld_idx('wgustw')
    !	write (6,*) ' itime, ifld, ', itime, ifld, lchnk

    call physics_ptend_init (ptend)
    ptend%ls    = .true.
    ptend%lq(:pcnst) = .true.
    ptend%lu = .true.
    ptend%lv = .true.

    ! for now, rain production rate = 0
    rprd(:ncol,:) = 0.

    itime = pbuf_old_tim_idx()
    ifld = pbuf_get_fld_idx('cbmf')

    if (nstep.le.1) then
       !	write (6,*) ' cbmf set to zero '
       cbmf(:ncol) = 0
       wgustw(:ncol) = 0
       !	write (6,*) ' xxx '
    else

       !this is reassigned to the pointer at the end of the subroutine
       cbmf(:ncol) = pbuf(ifld)%fld_ptr(1,1:ncol,1,lchnk,itime)
       !       wgustw(:ncol) = pbuf(ifld_wgustw)%fld_ptr(1,1:ncol,1,lchnk,itime)
       !	write (6,*) ' yyy' 
    endif
    !	write (6,*) ' top convect_ke_intr: cbmf ', cbmf
!    call endrun()

    ! Determine saturation vapor pressure
    call aqsat (state%t    ,state%pmid  ,est    ,qsat    ,pcols   , &
         ncol ,pver  ,1       ,pver    )

    nl = pver - 2 ! the maximum number of levels to which convection can
    !            penetrate, plus 1.

    net_mf = 0.


    do i = 1,ncol	! loop over all atmopheric columns in chunk lchnk

    ! Initializing the output fields
       cnt(i)   = pver
       cnb(i)   = 1
       rnk(i) = 0
       precc(i) = 0.
       wgustw(i) = 0.
    !      write (6,*) ' ke convection disabled '
    !      return

       do k = 1,pver	
          ft_ke(k) = 0.
          fq_ke(k) = 0.
          mup_ke(k) = 0.
          mdown_ke(k) = 0.
          det_ke(k) = 0.
       enddo

       cbmf_ke = cbmf(i)
       cbmf(i) = 0    ! default to no convection returned (over-ride if iflag=1)
       !	write (6,*) ' using cbmf_ke ', cbmf_ke


       ! Invert the vertical indexing
       do k = 1,pver	
          t_ke(pver-k+1)    = state%t(i,k)
!ke23          q_ke(pver-k+1)    = state%q(i,k,1)  &
!ke23               + state%q(i,k,ixcldliq) &
!ke23               + state%q(i,k,ixcldice)
          q_ke(pver-k+1)    = state%q(i,k,1)
	  qsat_ke(pver-k+1) = qsat(i,k)
          u_ke(pver-k+1)    = state%u(i,k)
          v_ke(pver-k+1)    = state%v(i,k)
          p_ke(pver-k+1)    = state%pmid(i,k)/100. ! convert to mb
       end do
       do k = 1,pver+1	
	  ph_ke(pver-k+2)   = state%pint(i,k)/100. ! convert to mb
       end do

       mtrans = 0
       do m = 1,pcnst
          !        skip water vapor, liquid and ice
          if (m.ne.1.and.m.ne.ixcldliq.and.m.ne.ixcldice) then
             mtrans = mtrans+1
             do k = 1,pver
                tracer(pver-k+1,mtrans) = state%q(i,k,m)
             end do
          endif
       end do

       !	write (6,*) ' ztodt ', ztodt
       call t_startf ('convect_ke')


       !do k = 1,pver
          !	k = 26
          !          write (6,1001) k, t_ke(k), q_ke(k), qsat_ke(k), u_ke(k), v_ke(k), &
          !               p_ke(k), ph_ke(k), q_ke(k)/qsat_ke(k)
1001      format (i3,f8.2,2e10.2,2f7.2,3f8.1)
       !end do
       !dance - the detrained cloud water tendency is set to 0;
       !      - ptend%q(:,:,1) is the tendency of the total water (vapor + condensed)
       !       NRL version
       !       call convect_ke(t_ke, q_ke, qsat_ke, u_ke, v_ke, tracer, p_ke, ph_ke,&
       !      MIT version


       call convect_ke(t_ke, q_ke, qsat_ke, u_ke, v_ke, tracer, p_ke, ph_ke,&
            pver,  nl, pcnst-3,   ztodt, iflag,&
            ft_ke, fq_ke, fu_ke, fv_ke, ftra, precc_ke,&
            wd_ke, tprime_ke, qprime_ke, cbmf_ke, mup_ke, mdown_ke, det_ke,&
            cnt_ke, cnb_ke, nstep, nk )

       !      write (101,*)nstep,' conv_intr: precc_ke mm/d ', precc_ke, iflag
       !	write (6,*)nstep,' conv_intr: precc_ke mm/d ', precc_ke, iflag
       ptend%name  = 'convect_ke'
       call t_stopf('convect_ke')
       
       ftoliq = 0.
       if ( iflag == 1 ) then
          ! Rename and invert back the vertical indexing
          do k = 1,pver	
             ptend%u(i,pver+1-k)  = fu_ke(k)
             ptend%v(i,pver+1-k)  = fv_ke(k)
             ptend%s(i,pver+1-k)  = ft_ke(k)*cpair
             if (fq_ke(k).gt.0) then
                ptend%q(i,pver+1-k,1)= fq_ke(k)*(1.-ftoliq)
                ptend%q(i,pver+1-k,ixcldliq)= fq_ke(k)*ftoliq
             else
                ptend%q(i,pver+1-k,1)= fq_ke(k)
             endif
             zdu(i,pver+1-k)      = det_ke(k)
          end do
          do k = 1,pver-1	
             muph_ke(k+1)   = 0.5*(mup_ke(k)+mup_ke(k+1))
             mdownh_ke(k+1)   = 0.5*(mdown_ke(k)+mdown_ke(k+1))
          end do
          muph_ke(1) = 0.
          muph_ke(pver+1) = 0.
          mdownh_ke(1) = 0.
          mdownh_ke(pver+1) = 0.

          do k = 1,pver+1	
             net_mf(i,pver-k+2)   = muph_ke(k) 
          end do
          rnk(i) = nk

          mtrans = 0
          do m = 1,pcnst
             ! Skip water vapor, liquid and ice
             if (m.ne.1.and.m.ne.ixcldliq.and.m.ne.ixcldice) then
                mtrans = mtrans+1
                ptend%lq(m) = .true.
                do k = 1,pver
                   ptend%q(i,pver+1-k,m) = ftra(k,mtrans)
                end do
             endif
          end do

          cnt(i)   = pver+1-cnt_ke
          cnb(i)   = pver+1-cnb_ke

          precc(i) = precc_ke/8.64e7
          !	write (6,*) ' ke returned cbmf as ', cbmf_ke
          cbmf(i) = cbmf_ke
          wgustw(i) = wd_ke
       

          w1 = 0
          w2 = 0
          w4 = 0
          do k = 1,pver
             w1 = w1 + ptend%q(i,k,1)*state%pdel(i,k)/gravit
             w2 = w2 + ptend%s(i,k)*state%pdel(i,k)/gravit
             w4 = w4 + zdu(i,k)*state%pdel(i,k)/gravit
          end do
          !	write (6,*) ' vertical integral of qtend(kg/m2/s), ttend(eunits)', w1, w2
          !	write (6,*) ' precc, zduint in kg/m2/s ', precc(i)*1000., w4
          !	write (6,*) ' ECHK integral of qtend(eunits), ttend(eunits)', latvap*w1, w2
          !       if (precc_ke.gt.1.) then
          !      check for approximate energy consistency 
          if (abs(latvap*w1+w2).gt.1.) then
             !	write (6,*) ' energy inconsistency is too bad '
             !         call endrun()
          endif

       elseif(iflag .eq. 4) then
          write (6,*) ' iflag 4 ', i, lchnk
       endif ! iflag
    end do		! end loop over ncol

#ifdef DUMPIT
   	write (102,*) 'convect_ke_intr: precc mm/d ', precc
    a = 0.
    do k=1,26
       	write(102,1000)nstep,k,state%t(1,k),state%q(1,k,1),ptend%q(1,k,1)
1000   format (2i3, f8.2, 2 e12.3)
       write(102,*)state%pint(1,k),state%pint(1,k+1),state%pmid(1,k)
       a = a + (ptend%q(1,k,1)*(state%pint(1,k+1)-state%pint(1,k)))/gravit
    enddo
    write (102,*) 'convect_ke_intr: precc mm/d ', precc
    write (102,*)'tot rain from q',a*24*3600
    !dance - the detrained cloud water tendency is set to 0; 
    !      - ptend%q(:,:,1) is the tendency of the total water (vapor + condensed)
#endif

    do k = 1,pver
       do i = 1,ncol
          dlf(i,k)   = 0.
       end do
    end do

    ftem(:ncol,:pver) = ptend%s(:ncol,:pver)/cpair
    call outfld('DPT_TEND    ',ftem           ,pcols   ,lchnk   )
    call outfld('DPQ_TEND    ',ptend%q(1,1,1) ,pcols   ,lchnk   )
    call outfld('CMFMCDKE   ',net_mf         ,pcols   ,lchnk   )
    call outfld('PRECCDKE   ',precc          ,pcols   ,lchnk   )
    call outfld('CBMF_KE    ',cbmf           ,pcols   ,lchnk   )
    call outfld('WGUSTW    ',wgustw         ,pcols   ,lchnk   )
    call outfld('RNK        ',rnk            ,pcols   ,lchnk   )


!    wrk1 = 0.
!    iwrk1 = 0
    do i = 1,ncol
!       if (wgustw(i).gt.wrk1) then
!          iwrk1 = i
!          wrk1 = wgustw(i)
!       endif
       lcl = nint(cnb(i))
       ltop = nint(cnt(i))
       if (ltop.lt.lcl) then
          pcont(i) = state%pmid(i,ltop)
          pconb(i) = state%pmid(i,lcl)
       else
          pcont(i) = state%pint(i,pverp)
          pconb(i) = state%pint(i,pverp)
       endif
       !     write (6,*) ' pcont, pconb ', pcont(i), pconb(i), cnt(i), cnb(i)
    end do
!    if (lchnk.eq.47)  write (6,*) ' convect_ke, wgustw max ', ifld_wgustw, lchnk, i, wrk1
    call outfld('PCONVT  ',pcont          ,pcols   ,lchnk   )
    call outfld('PCONVB  ',pconb          ,pcols   ,lchnk   )






    snow = 0

    ! re-assign field to pointer
    pbuf(ifld)%fld_ptr(1,1:ncol,1,lchnk,itime) = cbmf(:ncol) 
    pbuf(ifld_wgustw)%fld_ptr(1,1:ncol,1,lchnk,1) = wgustw(:ncol) 

    ! if CAPE < 100, set tendencies = 0
    if (.false.) then
    do i = 1,state%ncol 
     if (cape(i) < 100. ) then
       cnt(i) = pver
       cnb(i) = 1
       ptend%s(i,:) = 0.
       ptend%hflux_srf(i) = 0.
       ptend%hflux_top(i) = 0.
       ptend%u(i,:) = 0.
       ptend%taux_srf(i) = 0.
       ptend%taux_top(i) = 0.
       ptend%v(i,:) = 0.
       ptend%tauy_srf(i) = 0.
       ptend%tauy_top(i) = 0.
       ptend%q(i,:,:) = 0.
       ptend%cflx_srf(i,:) = 0.
       ptend%cflx_top(i,:) = 0.
       net_mf(i,:) = 0.
       dlf(i,:) = 0.
       snow(i) = 0.
!       pflx(i,:) = 0.
!       cme(i,:) = 0
       zdu(i,:) = 0
       precc(i) = 0
       rliq(i) = 0
    endif
    end do	
    endif

   ! save rain production rate from deep (currently just = zero.)
    ifld = pbuf_get_fld_idx('RPRDDP')
    pbuf(ifld)%fld_ptr(1,1:ncol,:,lchnk,1) = rprd(:ncol,:)

    call t_stopf('convect_ke_intr_tend')

  end subroutine convect_ke_intr_tend


!=========================================================================================
      subroutine findcin (ncol, t, q, tprime, qprime,  &
           mx, pm, pi, zm, lclo, bmax, lfc, lnb, lcape, punits)

!     find the convective inhibition for each parcel
!     define the dry and moist adiabats as lines of constant s and h
!     where s = c_p T + gz, h = s + Lq

!     note that the variations of c_p and R (for hydrostatic equation) with
!     water vapor are ignored

        use physconst, only: cpair, gravit, latvap
        use wv_saturation, only: estblf, hlatv, tmin, hlatf, rgasv, pcf, &
                            cp, epsqs, ttrice, vqsatd

      implicit none

      integer, intent(in)  :: ncol  ! number of columns in chunk
      real(r8), intent(in) :: t(pcols,pver)                ! temperature of env
      real(r8), intent(in) :: q(pcols, pver)               ! moisture of env
      real(r8), intent(in) :: tprime(pcols,pver)           ! tpert for updraft plume
      real(r8), intent(in) :: qprime(pcols,pver)           ! qpert for updraft plume
      real(r8), intent(in) :: pm(pcols,pver)               ! pressume at layer midpoints
      real(r8), intent(in) :: pi(pcols,pverp)              ! pressure at layer interfaces
      real(r8), intent(in) :: zm(pcols,pver)               ! height at layer midpoints
      integer, intent(out) :: lclo(pcols)               ! lcl of parcel leaving layer mx
      integer, intent(out) ::  mx(pcols)                 ! level of parcel with max cin
      real(r8), intent(out) ::  bmax(pcols)                  ! buoyancy between mx and lcl
      integer, intent(out) ::  lnb(pcols)
      integer, intent(out) ::  lfc(pcols)
      real(r8), intent(out) ::  lcape(pcols)
      character*(*), intent(in) ::  punits

!     local workspace
      real(r8)  capen
      integer  klnb(pcols,pver)
      integer  klcl(pcols,pver)
      integer  klfc(pcols,pver)
      real(r8) tubase(pcols,pver)
      real(r8) qu(pcols,pver)
      real(r8) bloc
      real(r8) bloc2
      real(r8) btot(pcols,pver)
      real(r8) dq
      real(r8) ql(pcols)
      real(r8) tl(pcols)
      real(r8) tvl
      real(r8) tev(pcols,pver)
      real(r8) es
      real(r8) qs(pcols)
      real(r8) buoy
      real(r8) c1n
      real(r8) c2n
      real(r8) e
      real(r8) tlcl(pcols), plcl(pcols)
      real(r8) plexp, qlcl(pcols), esd
      real(r8) dp
      real(r8) bpos(pcols)
      real(r8) tparc(pcols,pver)
      real(r8) qparc(pcols,pver)
      real(r8) hold(pcols)
      real(r8) hnew(pcols)
      real(r8) tsat(pcols)
      real(r8) tnew
      real(r8) qsold
      real(r8) dtd
      real(r8) dtw
      real(r8) err
      real(r8) capgam
      real(r8) dz
      real(r8) cin(pcols,pver)
      real(r8) cape(pcols,pver)
      real(r8) ermax
      real(r8) qold(pcols), told(pcols)
      real(r8) ppa(pcols), esv(pcols)
      real(r8) gam(pcols)
      real(r8) pconst
      integer imax
      real(r8) gmax
      real(r8) bavg
      real(r8) cavg

      integer kb
      integer i
      integer itmax
      integer k
      integer lcl(pcols,pver)
      integer numlcl, numhuge
      integer kt
      integer iter
      integer ktop
      integer nmax

      logical check(pcols)

      if (punits.eq."pa") then
         pconst = 1.
      else
         pconst = 0.01
      endif

     do i = 1,ncol	
	if ( t(i,pver) > 273. ) then
	   check(i) = .true.
        else	    
	   check(i) = .false.
	endif
     end do

      do k = pver,1,-1
         do i = 1,ncol
            qu(i,k) = q(i,k) + qprime(i,k) ! moisture for parcels
            tubase(i,k) = t(i,k) + tprime(i,k) ! temperature for parcels
            tparc(i,k) = tubase(i,k)
!           tev(i,k) = t(i,k)*(1.+.608*q(i,k)) ! virtual temperature for env
            tev(i,k) = t(i,k) &
                     * (1.+1.608*q(i,k))/ (1.+q(i,k))
#ifdef DEBCONV
            write (6,*) ' t, tev, q, s, h ', t(i,k), tev(i,k), q(i,k), &
                 cpair*t(i,k)+gravit*zm(i,k), &
                 cpair*t(i,k)+gravit*zm(i,k) + latvap*q(i,k)
#endif
            lcl(i,k) = 0
            btot(i,k) = -1.e36
            klcl(i,k) = 0
            cape(i,k) = 0
            cin(i,k) = 0
            klfc(i,k) = 0
            klnb(i,k) = pver+1
         end do
      end do

      do i = 1,ncol
         mx(i) = 1
         lclo(i) = 0
         bmax(i) = -1.e36
         bpos(i) = 0.
         lcape(i) = -1.e36
      end do

      c1n = gravit/cpair
      c2n = latvap/cpair
      kt = pver-7
      capgam = -c1n
      itmax = 10
      ktop = 4                          ! highest level to lift a parcel
      kt = pver-7                       ! highest level to start parcels from

!     first calculate the properties of parcel at base of lifting
      do kb = pver,kt,-1
         do i = 1,ncol
            ppa(i) = pm(i,kb)/pconst
         end do
         call vqsatd(tubase(1,kb), ppa, esv, qs, gam, ncol)
         do i = 1,ncol
            tsat(i) = tubase(i,kb)
	    if ( .not. check(i) ) cycle
	    if ( .not. check(i) ) then
	       write(6,*)'convect_ke_intr cycle not working'
	       stop
            endif	
	      
            plcl(i) = 0.

!           start assuming the parcels are unsaturated
            tparc(i,kb) = tubase(i,kb)
            qparc(i,kb) = qu(i,kb)
            hold(i) = cpair*tparc(i,kb)+gravit*zm(i,kb)+latvap*qparc(i,kb)

!           check whether they are saturated

!           if saturated, then first assume water condenses out and
!           releases all latent heat
            gmax = 0.
            dtw = 0.
            if (qs(i) .le. qparc(i,kb)) then
               plcl(i) = max(plcl(i),pm(i,kb))
               klcl(i,kb) = max(klcl(i,kb),kb)
               gmax = max(gam(i),0.1_r8)   ! limit the size of dtw for cold temp
               dtw = latvap*(qparc(i,kb)-qs(i))/(cpair*gmax)
               tsat(i) = tparc(i,kb) + dtw
            endif
#ifdef DEBCONV
            write (6,*) ' evaluating buoyancy from level kb = ', kb
            write (6,*) ' qs, qparc, tsat, tpar ', qs(i), qparc(i,kb), &
                 tsat(i), tparc(i,kb)
            write (6,*) ' if plcl(i) nonzero, this lev is saturated ', plcl(i)
            write (6,*) ' klcl(i,kb) ', klcl(i,kb)
            write (6,*) ' gmax, gam, dtw ', gmax, gam(i), dtw
            write (6,68) 'k ', 'lnb', 'lfc', 'lcl', 'tpv', 'tev', 'tp', 't', 'p', &
                    ' buoy', 'bloc2', 'cin', 'cape '
   68              format (4a5,10a11)
#endif
         end do

         
!        now correct it so parcel is just saturated and conserves h
         do iter=1,itmax
            do i = 1,ncol
               if ( .not. check(i) ) cycle	
               told(i) = tsat(i)
               qold(i) = qs(i)
            end do
            call vqsatd(tsat, ppa, esv, qs, gam, ncol)
            nmax = 0
            do i = 1,ncol
	    if ( .not. check(i) ) cycle
               if (klcl(i,kb).ne.0) then
                  hnew(i) = cpair*tsat(i)+gravit*zm(i,kb)+latvap*qs(i)
                  err = hnew(i) - hold(i)
                  tsat(i) = tsat(i) - err/(cpair*(1+gam(i)))
                  es = estblf(tsat(i))*pconst
                  qs(i) = epsqs*es/(pm(i,kb)-(1.-epsqs)*es)
                  hnew(i) = cpair*tsat(i)+gravit*zm(i,kb)+latvap*qs(i)
                  err = abs((hnew(i)-hold(i))/(hnew(i)+hold(i)))
                  if (err.gt.1.e-4) then
                     nmax = nmax+1
                  endif
               endif
            end do
            if (nmax.eq.0) goto 10
         end do

!        now check to make sure it converged
         ermax = 0.
         imax = 0
         do i = 1,ncol
    	    if ( .not. check(i) ) cycle	
            write (6,*) ' abc ', i, klcl(i,kb), ermax
            if (klcl(i,kb).ne.0) then
               hnew(i) = cpair*tsat(i)+gravit*zm(i,kb)+latvap*qs(i)
               tparc(i,kb) = tsat(i)
               qparc(i,kb) = qs(i)
               err = abs((hnew(i)-hold(i))/(hnew(i)+hold(i)))
               if (err.gt.ermax) then
                  ermax = err
                  imax = i
                  write (6,*) ' inside ermax, imax ', &
                       ermax, imax
               endif
            endif
         end do
         write (6,*) ' ermax, imax ', ermax, imax

         if (ermax.gt.1.e-4) then
            i = imax
            write (6,*) ' problems initializing moist k base ', &
                 i, kb, klcl(i,kb), hold(i), hnew(i)
            write (6,*) ' ermax ', ermax
            write (6,*) ' told, tnew, tparc ',  &
                 told(i), tsat(i), tparc(i,kb)
            write (6,*) ' qold, qnew ',  &
                 qold(i), qs(i), qparc(i,kb)
            write (6,*) ' pm, zm ', pm(i,kb), zm(i,kb)
            stop
         endif
   10    continue
         
!        now check it for lfc
         do i = 1,ncol
	    if ( .not. check(i) ) cycle
!            tvl = tparc(i,kb)*(1.+.608*qparc(i,kb))
            tvl = tparc(i,kb) &
                     * (1.+1.608*qparc(i,kb))/ (1.+qparc(i,kb))
            buoy = tvl-tev(i,kb)
            if (klcl(i,kb).gt.0.and.buoy.gt.0) then
               klfc(i,kb) = max(klfc(i,kb),kb)
            endif
            bloc2 = rgasv*buoy*(pi(i,kb+1)-pi(i,kb))/pm(i,kb)
!            bloc2 = rgasv*buoy*log(pi(i,kb+1)/pi(i,kb))
            if (klfc(i,kb).eq.0) then
               cin(i,kb) = cin(i,kb) + bloc2
            else
               capen = cape(i,kb) + bloc2
               cape(i,kb) = capen
            endif
            if (buoy.ge.0) then
               klnb(i,kb) = min(klnb(i,kb),kb)
            endif
!            if (klfc(i,kb).eq.0.or.buoy.ge.0) then
!               cape(i,kb) = capen
!            endif
#ifdef DEBCONV
!            if (lat.eq.latlook.and.i.eq.ilook) then
               write (6,69) kb, klnb(i,kb), klfc(i,kb), &
                     klcl(i,kb), tvl, tev(i,kb),  &
                    tparc(i,kb), t(i,kb), pm(i,kb),  &
                    buoy, bloc2, &
                    cin(i,kb), cape(i,kb)
!            endif !lat
#endif
         end do

!        move the parcel up
         do k = kb-1,ktop,-1
            do i = 1,ncol
	    if ( .not. check(i) ) cycle
               hold(i) = cpair*tparc(i,k+1) &
                    +gravit*zm(i,k+1)+latvap*qparc(i,k+1)

!              first assume it moves up a dry adiabat
               dz = (zm(i,k)-zm(i,k+1))
               dtd = capgam*dz
!              td = tparc(i,k+1) + dtd
               tparc(i,k) = tparc(i,k+1) + dtd
               qparc(i,k) = qparc(i,k+1)

               hnew(i) = cpair*tparc(i,k)+gravit*zm(i,k)+latvap*qparc(i,k)
               ppa(i) = pm(i,k)/pconst
            end do

!           if it hits saturation, note it, and move up a wet adiabat
!           note this is very approximate because
!           1) qs is assumed linear
!           2) the lcl was assumed to occur precisely at level k+1

            call vqsatd(tparc(1,k), ppa, esv, qs, gam, ncol)
            do i = 1,ncol
    	    if ( .not. check(i) ) cycle
               if (qs(i) .lt. qparc(i,k+1)) then
                  plcl(i) = max(plcl(i),pm(i,k))
                  klcl(i,kb) = max(klcl(i,kb),k)
                  dtw = capgam*dz/(1+gam(i))
                  tsat(i) = tparc(i,k+1) + dtw
                  es = estblf(tsat(i))*pconst
                  qs(i) = epsqs*es/(pm(i,k)-(1.-epsqs)*es)
                  tparc(i,k) = tsat(i)
               endif
            end do
            
!           now correct any parcels that have hit their lcl
!           so they conserve h, and are saturated.
!           using a newton method iteration
!           this remove the error in assumptions mentioned above
            do iter = 1,itmax
               call vqsatd(tparc(1,k), ppa, esv, qs, gam, ncol)
               nmax = 0
               do i = 1,ncol
	       if ( .not. check(i) ) cycle	
                  if (klcl(i,kb).ne.0) then
                     hnew(i) = cpair*tsat(i)+gravit*zm(i,k)+latvap*qs(i)
                     err = hnew(i) - hold(i)
                     dtw =  - err/(cpair*(1+gam(i)))
                     tsat(i) = tsat(i) + dtw
                     es = estblf(tsat(i))*pconst
                     qs(i) = epsqs*es/(pm(i,k)-(1.-epsqs)*es)
                     tparc(i,k) = tsat(i)
                     qparc(i,k) = qs(i)
                  end if
                  hnew(i) = cpair*tparc(i,k)+gravit*zm(i,k)+latvap*qparc(i,k)
                  err = abs((hnew(i)-hold(i))/(hnew(i)+hold(i)))
                  if (err.gt.1.e-4) then
                     nmax = nmax + 1
                  endif
               end do
               if (nmax.eq.0) goto 20
            end do

!           now check to see whether it converged.
            ermax = 0.
            imax = 0
            do i = 1,ncol
	    if ( .not. check(i) ) cycle
               hnew(i) = cpair*tparc(i,k)+gravit*zm(i,k)+latvap*qparc(i,k)
               err = abs((hnew(i)-hold(i))/(hnew(i)+hold(i)))
               if (err.gt.ermax) then
                  ermax = err
                  imax = i
               endif
            end do
            if (ermax.gt.1.e-4) then
               i = imax
               write (6,*) ' problems initializing moist k mid', &
                    i, hold(i), hnew(i), k, kb, t(i,:pver)
                err = hnew(i) - hold(i)
                dtw =  - err/(cpair*(1+gam(i)))
	       write(6,*)'nmax gam(i) dtw',nmax,gam(i),dtw

               stop
            end if
   20       continue

!           now check it for lfc
            do i = 1,ncol
    	    if ( .not. check(i) ) cycle
!               tvl = tparc(i,k)*(1.+.608*qparc(i,k))
               tvl = tparc(i,k) &
                     * (1.+1.608*qparc(i,k))/ (1.+qparc(i,k))
               buoy = tvl-tev(i,k)
               if (klcl(i,kb).gt.0.and.buoy.gt.0) then
                  klfc(i,kb) = max(klfc(i,kb),k)
               endif
               bloc2 = rgasv*buoy*(pi(i,k+1)-pi(i,k))/pm(i,k)
               capen = cape(i,kb) + bloc2
               if (klfc(i,kb).eq.0) then
                  cin(i,kb) = cin(i,kb) + bloc2
               else
                  if (buoy.gt.0.) cape(i,kb) = capen
               endif
               if (buoy.gt.0) then
!              if (klnb(i,kb).eq.0.and.buoy.ge.0) then
                  klnb(i,kb) = min(klnb(i,kb),k)
               endif
!               if (klfc(i,kb).eq.0.or.buoy.ge.0) then
!                 cape(i,kb) = capen
!               endif
#ifdef DEBCONV
!               if (lat.eq.latlook.and.i.eq.ilook) then
                  write (6,69) k, klnb(i,kb), klfc(i,kb), &
                       klcl(i,kb), tvl, tev(i,k), &
                       tparc(i,k), t(i,k), pm(i,k),  &
                       buoy, bloc2, &
                       cin(i,kb), cape(i,kb)
   69              format (4i5,10f11.3)
!               endif
#endif
            end do
         end do

      end do

!     now choose the cloud base
      do kb = pver,kt,-1
         do i = 1,ncol
    	    if ( .not. check(i) ) cycle
!            if (cin(i,kb).gt.bmax(i)) then
!            if (cin(i,kb).ge.bmax(i)
!     $           .and.cape(i,kb).gt.lcape(i)) then
!           choose a layer with the least inhibition
!           till we find a positive capeblfc, then stop
            if (cin(i,kb).ge.bmax(i) &
                 .and.bmax(i).lt.0.) then
               mx(i) = kb
               lclo(i) = klcl(i,kb)
               bmax(i) = cin(i,kb)
               lfc(i) = klfc(i,kb)
               lnb(i) = klnb(i,kb)
               lcape(i) = cape(i,kb)
            endif
         end do
      end do
      

#ifdef DEBCONV

      cavg = 0.
      bavg = 0.
      do i = 1,ncol
         bavg = bavg + bmax(i)
         cavg = cavg + lcape(i)
      end do
      bavg = bavg/ncol
      cavg = cavg/ncol
      write (6,*) ' avgcin, avgcape ', bavg, cavg
#endif

	! reset special values to 0. for plotting purposes

      do i = 1,ncol
	 if (abs(lcape(i)) .ge. 1.e36 ) lcape(i) = 0.
	 if (abs(bmax(i))  .ge. 1.e36 ) bmax(i) = 0.
      end do



      return
      end subroutine findcin



end module convect_ke_intr


