;-----------------------------------------------------------------------
pro animate_lons,info,func
;
; Animate longitude slices in one of three ways, according to input func:
;   In time (at fixed longitude)    func = 'time_fixlon'
;   In time (at fixed local time)   func = 'time_fixslt'
;   In longitude (at fixed ut)      func = 'lon_fixut'
;
; Get state info:
;
lon = *info.plon
fields = *info.fields
field = fields[lon.ifield]
data = *field.data
file = *info.pfile
wanim_xsize=450 & wanim_ysize=450
mag = 0 & if field.grid_type eq 'magnetic' then mag = 1
;
;print,'Enter animate_lons: lon.fmin,max=',lon.fmin,lon.fmax
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;
; Animate in time (fixed longitude):
;
widget_control,/hourglass
case func of
  "time_fixlon": begin
    animbase = widget_base(title=$
      'Animate lon slices in time (fixed longitude)')
    newtimes=intarr(3,3)
    utmin=intarr(3,1)
    utmax=intarr(3,1)
    utmin[0]=file.mtimes[0,0] & utmin[1]=file.mtimes[1,0] & $
      utmin[2]=file.mtimes[2,0]
    utmax[0]=file.mtimes[0,file.ntimes-1] & utmax[1]=file.mtimes[1,file.ntimes-1] & $
      utmax[2]=file.mtimes[2,file.ntimes-1]
    interval=1  
    newtimes=setaxis_ut(info,info.plon,utmin,utmax,interval)
    utmin[0]=newtimes[0,0] & utmin[1]=newtimes[1,0] & $
      utmin[2]=newtimes[2,0]
    utmax[0]=newtimes[0,1] & utmax[1]=newtimes[1,1] & $
      utmax[2]=newtimes[2,1]
    interval=newtimes[0,2]
    print,'animate lons after setaxis_ut: newtimes=',newtimes
    if (interval eq -1) then begin
      print,'Cancelling lon slice animation..'
      return
    endif
    type_hist=newtimes[1,2]
    imtime_min = -1
    imtime_max = -1
    for i=0,file.ntimes-1 do begin
      if file.mtimes[0,i] eq utmin[0] and file.mtimes[1,i] eq utmin[1] and $
        file.mtimes[2,i] eq utmin[2] then begin
        imtime_min=i
      endif
      if file.mtimes[0,i] eq utmax[0] and file.mtimes[1,i] eq utmax[1] and $
        file.mtimes[2,i] eq utmax[2] then begin
        imtime_max=i
      endif
    endfor
;   if imtime_min gt imtime_max then $
;     imtime_max=file.ntimes-1 & $  
;     print,'max time is less than min time resetting max time:',imtime_max
    nframes=imtime_max-imtime_min+1
;
; Set min,max for constant scale:
; Save current:
;
    savemtime = lon.mtime & saveimtime = lon.imtime
    savefmin  = lon.fmin  & savefmax = lon.fmax
    saveut    = lon.ut    & saveslt    = lon.sslt
;
; Calculate min,max for entire animation if not already fixed:
;
    if lon.setcontour eq 'off' then begin
      lon.fmin =  1.e36 & lon.fmax = -1.e36
      for i=0,nframes-1 do begin
        lon.imtime = i+imtime_min
        deflondata,lon,data
        fminmax,*lon.data,fmin,fmax,file.missing_value
        if fmin lt lon.fmin then lon.fmin = fmin
        if fmax gt lon.fmax then lon.fmax = fmax
        cmin=0. & cmax=0. & cint=0.
        levels = mkclevels(fmin,fmax,cmin,cmax,cint)
        *lon.clevels = levels
      endfor
      print,'animate_lons: calculated min,max for animation sequence:',$
        lon.fmin,lon.fmax
    endif
;
; Load frames and run cw_animate:
;
    numberframes=0 
    for i=0,nframes-1 do begin
      lon.imtime = i+imtime_min
      if file.mtimes[type_hist,lon.imtime] mod interval eq 0 then begin
        numberframes=numberframes+1
      endif
    endfor
    animate = cw_animate(animbase,wanim_xsize,wanim_ysize,numberframes )
    add_animid,info,animate

    widget_control,animbase,/realize 
    framenum=0
    for i=0,nframes-1 do begin
      lon.imtime = i+imtime_min
      if file.mtimes[type_hist,lon.imtime] mod interval eq 0 then begin
        lon.mtime = file.mtimes[*,lon.imtime]
        lon.ut = lon.mtime[1]+lon.mtime[2]/60.
        lon.sslt = fslt(lon.sslt,lon.ut,lon.slon,"getlt",mag=mag)
        deflondata,lon,data
        *info.plon = lon
        window,xsize=wanim_xsize,ysize=wanim_ysize,/pixmap
        windo = !d.window
        wset,windo
        pltlon,info,/animate
        cw_animate_load,animate,frame=framenum,window=windo,/track
        framenum=framenum+1
      endif
;     print,'Animate lon in time (fixed lon): frame=',i,' out of ',nframes,$
;       ' lon.fmin,max=',lon.fmin,lon.fmax
    endfor
;
    lon.mtime = savemtime & lon.imtime = saveimtime
    lon.fmin  = savefmin  & lon.fmax = savefmax
    lon.ut    = saveut    & lon.sslt = saveslt
    *info.plon = lon
    cw_animate_run,animate,nframes=numberframes
  end ; animate in time (fixed longitude)
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;
; Animate in time (fixed local time):
; Longitude and ut will vary, and current local time lon.sslt remains constant.
;
  "time_fixslt": begin
    animbase = widget_base(title=$
      'Animate lon slices in time (fixed local time)')
    newtimes=intarr(3,3)
    utmin=intarr(3,1)
    utmax=intarr(3,1)
    utmin[0]=file.mtimes[0,0] & utmin[1]=file.mtimes[1,0] & $
      utmin[2]=file.mtimes[2,0]
    utmax[0]=file.mtimes[0,file.ntimes-1] & utmax[1]=file.mtimes[1,file.ntimes-1] & $
      utmax[2]=file.mtimes[2,file.ntimes-1]
    interval=1  
    newtimes=setaxis_ut(info,info.plon,utmin,utmax,interval)
    utmin[0]=newtimes[0,0] & utmin[1]=newtimes[1,0] & $
      utmin[2]=newtimes[2,0]
    utmax[0]=newtimes[0,1] & utmax[1]=newtimes[1,1] & $
      utmax[2]=newtimes[2,1]
    interval=newtimes[0,2]
    if (interval eq -1) then begin
      print,'Cancelling lon slice animation..'
      return
    endif
    type_hist=newtimes[1,2]
    imtime_min = -1
    imtime_max = -1
    for i=0,file.ntimes-1 do begin
      if file.mtimes[0,i] eq utmin[0] and file.mtimes[1,i] eq utmin[1] and $
        file.mtimes[2,i] eq utmin[2] then begin
        imtime_min=i
      endif
      if file.mtimes[0,i] eq utmax[0] and file.mtimes[1,i] eq utmax[1] and $
        file.mtimes[2,i] eq utmax[2] then begin
        imtime_max=i
      endif
    endfor
    if imtime_min gt imtime_max then $
      imtime_max=file.ntimes-1 & $  
      print,'max time is less than min time resetting max time:',imtime_max
    nframes=imtime_max-imtime_min+1

;    nframes = field.ntime
;
; Save some state parameters of fixed window:
;
    savefmin = lon.fmin & savefmax = lon.fmax
    savemtime = lon.mtime   & saveimtime = lon.imtime
    saveut = lon.ut         & savelon = lon.slon
;
; Find min,max scale for all frames:
;
; Calculate min,max for entire animation if user has not fixed it:
   if lon.setcontour eq 'off' then begin
    if lon.fmin ge lon.fmax then begin ; minmax is *not* fixed
      lon.fmin =  1.e36     & lon.fmax = -1.e36
      for i=0,nframes-1 do begin
        lon.imtime = i+imtime_min
        deflondata,lon,data
        fminmax,*lon.data,fmin,fmax,file.missing_value
        if fmin lt lon.fmin then lon.fmin = fmin
        if fmax gt lon.fmax then lon.fmax = fmax
      endfor
      print,'animate_lons: calculated fmin,max=',lon.fmin,lon.fmax
    endif else $
      print,'animate_lons: using already set fmin,max=',lon.fmin,lon.fmax
   endif
;
; Load frames and run cw_animate:
;
    numberframes=0 
    for i=0,nframes-1 do begin
      lon.imtime = i+imtime_min
      if file.mtimes[type_hist,lon.imtime] mod interval eq 0 then begin
        numberframes=numberframes+1
      endif
    endfor
    animate = cw_animate(animbase,wanim_xsize,wanim_ysize,numberframes )
    add_animid,info,animate

    widget_control,animbase,/realize 
    framenum=0
    for i=0,nframes-1 do begin
      lon.imtime = i+imtime_min
      if file.mtimes[type_hist,lon.imtime] mod interval eq 0 then begin

        lon.mtime = file.mtimes[*,lon.imtime]
        lon.ut = lon.mtime[1]+lon.mtime[2]/60.
        lon.slon = fslt(lon.sslt,lon.ut,lon.slon,"getlon",mag=mag)
;
; Is this necessary?
        if field.grid_type eq 'geographic' then begin ; add periodic point
          nlons = n_elements(*field.lons)
          lons = fltarr(nlons+1)
          lons[0:nlons-1] = *field.lons
          lons[nlons] = abs(lons[0]) ; +180
        endif else lons = *field.lons

        dlon = lons[1]-lons[0]
        if ixfind(lons,lon.slon,0.) lt 0 then begin
          ilon = ixfind(lons,lon.slon,dlon)
          lon.slon = lons[ilon]
        endif
;
        deflondata,lon,data
        *info.plon = lon
        window,xsize=wanim_xsize,ysize=wanim_ysize,/pixmap
        windo = !d.window
        wset,windo
        pltlon,info,/animate
        cw_animate_load,animate,frame=framenum,window=windo,/track
        framenum=framenum+1
;     print,'Animate lons in time (fixed slt): frame=',i,' out of ',nframes,$
;       ' lon.fmin,max=',lon.fmin,lon.fmax
      endif
    endfor
;
; Restore state to fixed window:
;
    lon.fmin = savefmin & lon.fmax = savefmax
    lon.mtime = savemtime & lon.imtime = saveimtime
    lon.ut = saveut & lon.slon = savelon
    *info.plon = lon
;
; Run the animation
;
    cw_animate_run,animate,nframes=numberframes 
  end
;- - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - - -
;
; Animate in longitude (fixed ut):
;
  "lon_fixut": begin
    animbase = widget_base(title='Animate in longitude (fixed ut)')
    nframes = field.nlon
    savelon = lon.slon & saveslt = lon.sslt
    savefmin = lon.fmin & savefmax = lon.fmax
;
; Calculate min,max for entire animation if not already fixed:
;
   if lon.setcontour eq 'off' then begin
    if lon.fmin ge lon.fmax then begin ; minmax is *not* fixed
      lon.fmin =  1.e36 & lon.fmax = -1.e36
      for i=0,nframes-1 do begin
        lon.slon = (*field.lons)[i]
;       lon.sslt = fslt(0.,lon.ut,lon.slon,1)
        lon.sslt = fslt(lon.sslt,lon.ut,lon.slon,"getlt",mag=mag)
        deflondata,lon,data
        fminmax,*lon.data,fmin,fmax,file.missing_value
        if fmin lt lon.fmin then lon.fmin = fmin
        if fmax gt lon.fmax then lon.fmax = fmax
      endfor
      print,'animate_lons: calculated fmin,max=',lon.fmin,lon.fmax
    endif else $
      print,'animate_lons: using already set fmin,max=',lon.fmin,lon.fmax
   endif
;
; Load frames and run cw_animate:
;
    animate = cw_animate(animbase,wanim_xsize,wanim_ysize,nframes)
    add_animid,info,animate

    widget_control,animbase,/realize 
    for i=0,nframes-1 do begin
      lon.slon = (*field.lons)[i]
;     lon.sslt = fslt(0.,lon.ut,lon.slon,1)
      lon.sslt = fslt(lon.sslt,lon.ut,lon.slon,"getlt",mag=mag)
      deflondata,lon,data
      *info.plon = lon
      window,xsize=wanim_xsize,ysize=wanim_ysize,/pixmap
      windo = !d.window
      wset,windo
      pltlon,info,/animate
      cw_animate_load,animate,frame=i,window=windo,/track
;     print,'Animate lons slices in longitude (fixed ut): frame=',i,' out of ',$
;       nframes,' lon.fmin,max=',lon.fmin,lon.fmax
    endfor
    lon.fmin = savefmin & lon.fmax = savefmax
    lon.slon = savelon & lon.sslt = saveslt
    *info.plon = lon
    cw_animate_run,animate,nframes=nframes
  end
;
; Unknown animation type:
;
  else: print,'>>> animate_lons: unknown animation type func=',func
endcase
widget_control,hourglass=0
xmanager,"Map Animation",animbase,event_handler="anim_event"
;info = save_info
end

