;
function check_missing,data,missing_value,fieldname,text=text,$
  nmissing=nmissing
;
; Check for all missing value:
;
ismissing = 0
nelements = n_elements(data)
missing_indices = where(data eq missing_value,nmiss)
if keyword_set(nmissing) then nmissing = nmiss
;
;print,'check_missing: nmiss=',nmiss
if (nmiss eq nelements) then begin
  print,'>>> WARNING: all data are missing -- plot not made.'
  if keyword_set(text) then begin
    text = 'FIELD '+fieldname+': ALL DATA MISSING: missing_value='+ $
      string(missing_value)
    xyouts,0.5,0.7,text,/norm,align=0.5
    text = 'If this is a secondary history, try 2nd or later model time'
    xyouts,0.5,0.65,text,/norm,align=0.5
  endif
  ismissing = 1
  return,ismissing
endif
;
; Check for all 0:
;
missing_zero = where(data eq 0.,nzero)
;print,'check_missing: nzero=',nzero,' nelements=',nelements
if nzero eq nelements then begin
  print,'>>> WARNING check_missing: all data are zero -- plot not made.'
  if keyword_set(text) then begin
    text = 'FIELD '+fieldname+': ALL DATA ARE ZERO'
    xyouts,0.5,0.7,text,/norm,align=0.5
    text = 'If this is a secondary history, try 2nd or later model time'
    xyouts,0.5,0.65,text,/norm,align=0.5
  endif
  ismissing = 1
  return,ismissing
endif
;
; Check for all 0 or missing:
;
if nzero+nmiss eq nelements then begin
  print,'>>> WARNING pltlon: all data are missing or zero -- plot not made.'
  if keyword_set(text) then begin
    text = 'FIELD '+fieldname+': ALL DATA ARE ZERO OR MISSING'
    xyouts,0.5,0.7,text,/norm,align=0.5
    text = 'If this is a secondary history, try 2nd or later model time'
    xyouts,0.5,0.65,text,/norm,align=0.5
  endif
  ismissing = 1
  return,ismissing
endif
;
; Check for all constant (compare to first data element):
;
first = data[0]
constant_indices = where(data ne first,ndiff)
;print,'check_missing: ndiff=',ndiff,' nelements=',nelements
if ndiff eq 0 then begin
  print,'>>> WARNING: all data are constant ',first,' -- plot not made.'
  if keyword_set(text) then begin
    text = 'FIELD '+fieldname+': ALL DATA ARE CONSTANT '+string(first)
    xyouts,0.5,0.7,text,/norm,align=0.5
  endif
  ismissing = 1
  return,ismissing
endif
return,ismissing
end
