;
pro defprofdata,line,data,linedata
;
;  Get subset of field data to be plotted for profile line plot
;
;  Get data and variables needed
;
  field = line.field
  fieldlevs = *field.levs
  nfieldlevs = n_elements(fieldlevs)
  iLat = line.ilat
  ilon = line.ilon
  iLev = line.ilev
;
;  Form data array for plotting
;
  linedata = fltarr(nfieldlevs)
  linedata[*] = 0.
;
;  Pick out data based on profile type of line plot
;
;  if line.levmin lt line.levmax then begin 
;    kk = 0
;    for k=0,nfieldlevs-1 do $
;      if fieldlevs[k] ge line.levmin and fieldlevs[k] le line.levmax then begin
;        print, 'fieldlevs[k], data[ilon,iLat,k,line.imtime] ', fieldlevs[k], data[ilon,iLat,k,line.imtime]
;        if line.zonalmean eq 0 then begin
;          linedata[kk] = float(data[ilon,iLat,k,line.imtime])
;        endif else begin ; plot zonal mean
;          linedata[kk] = float(mean(data[*,iLat,k,line.imtime]))
;        endelse
;        kk = kk+1
;      endif
;  endif else begin
;  print, ' Loading data2 for time ', line.imtime
;
;  Grab data from vertical dimension and calculate zonal mean if requested
;
    if line.zonalmean eq 0 then begin
      linedata[*] = float(data[ilon,iLat,*,line.imtime])
    endif else begin ; zonal mean
      for k=0,nfieldlevs-1 do begin
        linedata[k] = float(mean(data[*,iLat,k,line.imtime]))
      endfor
    endelse ; zonal mean
;  endelse
;
; Take log10 of densities if requested:
;
  if (line.log10 eq 'density fields' and isdensity(field.name) gt 0) or $
     (line.log10 eq 'this frame only') or $
     (line.log10 eq 'all fields') then begin
;   print,'deflinedata: taking log10 of field ',field.name,'...'
    missing_value = float(line.missing_value)
    log10f,linedata,missing_value
  endif
;
;  Update vertical levels
;
  line.levs = PTR_NEW(fieldlevs)
;
; Update lon structure:
;
  line.data = ptr_new(linedata)
;
;  Interpolate WACCM data to 'standard' log pressure levels
;
  IF line.ftype EQ 'WACCM' AND line.plottype EQ 'profile' THEN BEGIN

    interpwdata, line
  
  ENDIF

end
