pro find_nans,info,fieldname,data,numnans
  cdfid=info.cdfid
  varid=ncdf_varid(cdfid,fieldname)
  dims=size(data)
;
;  Check number of dimensions and look for nans for 1d and 2d cases
;  
  IF dims[0] EQ 1 THEN BEGIN ;1D just levels case

    nLev = dims[1]
    numnans = 0
    for iLev=0,nLev-1 do begin
      if not finite(data(iLev)) then $
	numnans = numnans +1
    endfor

  ENDIF ELSE BEGIN  ;2D lats and levels case  

    nlat=dims[1]
    nlev=dims[2]
    numnans=0
    for i=0,nlat-1 do begin
      for j=0,nlev-1 do begin
        if not finite(data(i,j)) then $
  	  numnans = numnans +1
      endfor
    endfor

  ENDELSE

end

