;
function fslt, slt,ut,lon,request,mag=mag,verbose=verbose
;
; If iflag = 1 -> return slt, given ut and glon
; If iflag = 2 -> return ut, given slt and glon
; If iflag = 3 -> return glon, given slt and ut
; (slt and ut always in decimal hours, glon in -180 -> 180)
;
; If mag keyword is set, rotate longitude by 71 degrees
;   (longitude of magnetic pole) to approximate magnetic
;   local time.
;
v = 0 & if keyword_set(verbose) then v = 1
;
if request ne "getlon" then begin
  glon = lon
  if keyword_set(mag) then glon = lon-71. ; rotate to mag pole
endif
if  not keyword_set(mag) then mag = 0
case request of
  "getlt": begin ; return slt
       fslt = ut + glon/15.
       if (fslt lt 0.) then fslt = fslt+24.
       if (fslt ge 24.) then fslt = fslt-24.
       if v gt 0 then print,'fslt getlt: mag=',mag,' ut=',ut,$
         ' glon=',glon,' new lt=',fslt
      end
  "getut": begin ; return ut
       fslt = slt - glon/15. 
       if (fslt lt 0.) then fslt = fslt+24.
       if (fslt gt 24.) then fslt = fslt-24.
       if v gt 0 then print,'fslt getut: mag=',mag,' slt=',slt,$
         ' glon=',glon,' new ut=',fslt
     end  
  "getlon": begin ; return longitude
       fslt = (slt-ut) * 15.
       if keyword_set(mag) then fslt = fslt+71.
       if (fslt ge 180.) then fslt = fslt-360.
       if (fslt lt -180.) then fslt = fslt+360.
       if v gt 0 then print,'fslt getlon: mag=',mag,' ut=',ut,$
         ' slt=',slt,' new lon=',fslt
     end 
  else: begin
;      print,'>>> fslt: unknown request=',request
       fslt = 0.
     end 
endcase
return,fslt
end
