;
function getutzp,ixf,glat,glon
@global.h
@timeproc.h
;
; Return field (ntms,!kmx) at glat,glon (field index ixf), from 
;   pnt(ntms,!kmx,!jmx,nlon,nfcdf)
; For now, assume glon is one of slon(nlon). Later, can provide for 
;   linear interpolation from slon
;
genvert = fltarr(ntms,!kmx)
ixlon = -1
for i=0,nlon-1 do if glon eq slon(i) then ixlon = i
if ixlon lt 0 then begin
  print,'>>> getutzp: could not find index to glon = ',glon
  print,'    slon = ' & print,slon
  return,genvert
endif
if glat ne zmflag then begin
  ixlat = ixfind(gcmlat,!jmx,glat,!dlat)
  if ixlat lt 0 then begin
    print,'>>> getutzp: could not find grid index to glat = ',glat
    return,genvert
  endif
  if (ixf lt nfcdf) then begin ; field is on history
    genvert(*,*) = pnt(*,*,ixlat,ixlon,ixf)
  endif else begin ; derived field
    print,'>>> getutzp: unsupported ixf=',ixf
  endelse
endif else begin ; global means
  if glon ne zmflag then begin
    print,'>>> getutzp: glat=zmflag but glon=',glon
    return,genvert
  endif
  print,'getutzp doing global means...'
  if ixf lt nfcdf then begin
    rjmx = fltarr(!jmx)
    for it=0,ntms-1 do begin
      for k=0,!kmx-1 do begin
        rjmx(*) = pnt(it,k,*,ixlon,ixf)
        genvert(it,k) = glbmean(rjmx,gcmlat,spval,/latonly)
      endfor
    endfor
  endif else begin
    print,'>>> getutzp: unsupported ixf=',ixf
  endelse
endelse
return,genvert
end
