PRO getzprof, info, slice, fields, zheights
;
;  This routine reads the height field from the model history input file and picks out the 
;  subset of the data needed for line plots.  Needs to be cleaned up and checked for accuracy 
;  with meridional and zonal line plots. 
;
  slicetype = slice.plottype
  ;
  ; Get heights from Z (or Z3 from WACCM) field:
  ;
  ixz = -1
  for i=0,n_elements(fields)-1 do begin
    if strcompress(fields[i].name,/remove_all) eq 'Z' then ixz = i
    if strcompress(fields[i].name,/remove_all) eq 'Z3' then ixz = i
  endfor
  if ixz eq -1 then begin
    print,'>>> WARNING altyax: Could not find Z or Z3 field -- extra right-hand',$
      ' axis NOT added.'
    return
  endif
;
; Read Z field if necessary:
; 12/8/05 btf: Currently, altyax is not called for mag fields (see rhyaxis
;              in pltxxx routines). However, ZMAG should be available on
;              histories now, so this routine should check if current field
;              is mag, and if it is, use ZMAG instead of Z.
;
  if not ptr_valid(fields[ixz].data) then begin ; field has not been read
    print,'Reading Z field to get heights for right-hand axes..'
    widget_control,/hourglass
;
; Read Z data from file:
;
    varget,info,fields[ixz],zdata
    field = fields[ixz]
;
; Process Z field:
;
    procfield,info,zdata,field,info.z_hist
    fields[ixz] = field
;
;  Update and report minimum and maximum Z field value
;    
    fmin = min(*fields[ixz].data) & fmax = max(*fields[ixz].data)
    rpt_minmax,info,fields[ixz],fmin,fmax
    *info.fields = fields
  endif
;print, 'slice.levs in getzprof ', *slice.levs
;
;  Get the data to use and save any variables  
;
  fielddata = *fields[ixz].data
  slicedata = *slice.data	; save
  log10save = slice.log10	; save
  slice.log10 = 'none'  	; want linear heights
;  
;  Subset data according to plot type.
;  
  if slicetype eq 'lon' then begin
  ; print,'altyax calling deflondata for Z..'
    deflondata,slice,fielddata   ; get for lon slices (lat,lev)
  endif 
  if slicetype eq 'utvert' then begin
  ; print,'altyax calling defutvertdata for Z.. help,fielddata=' & help,fielddata
    defutvertdata,slice,fielddata   ; get for utvert slices (ut,lev)
  endif
  if slicetype eq 'lat' then begin 
  ; print,'altyax calling deflatdata for Z..'
    deflatdata,slice,fielddata   ; get for lat slices (lon,lev)
  endif
  if slicetype eq 'profile' then begin 
;   print,'altyax calling deflinedata for Z..'
    deflinedata,slice,fielddata	; get for line slices (dat,lev)
  endif
;print, 'slice.levs in getzprof ', *slice.levs
;
;  Meridional line plot type needs data in latitude dimension and zonal line plot type needs data in 
;  longitude dimension and rest need data in vertical dimension
;
  IF slicetype eq 'meridional' THEN BEGIN

    dims = SIZE(fielddata)
    nZH = dims[3]
    zheights = FLTARR(nZH)

    FOR iZH = 0, nZH-1 DO BEGIN
 
      zheights[iZH] = FLOAT(MEAN(fielddata[slice.ilon,*,iZH,slice.imtime]))

    ENDFOR
  
  ENDIF ELSE IF slicetype eq 'zonal' THEN BEGIN

    dims = SIZE(fielddata)
    nZH = dims[3]
    zheights = FLTARR(nZH)

    FOR iZH = 0, nZH-1 DO BEGIN
 
      zheights[iZH] = FLOAT(MEAN(fielddata[*,slice.ilat,iZH,slice.imtime]))

    ENDFOR

  ENDIF ELSE BEGIN

    dims = SIZE(fielddata)
    nZH = dims[3]
    zheights = FLTARR(nZH)
    zheights[*] = FLOAT(fielddata[slice.ilon,slice.ilat,*,slice.imtime])

  ENDELSE

  *slice.data = slicedata ; restore
 
  ;if slicetype ne 'utvert' then begin
    slice.log10 = log10save ; restore
  ;endif

  RETURN

END
