PRO interpwdata, slice
;
;  This routine interpolates WACCM history file data to the vertical pressure level grid which TIME-GCM uses.  It
;  will check for 1-D data with vertical level as the dimension or 4-D data with vertical level as the 3rd dimension
;  of the data.
;
;  Get arrays needed from slice
;
  field = slice.field 
  data = *slice.data
  levs = *field.levs
  nLevs = N_ELEMENTS(levs)
;
;  Hard wire number of levels in 'standard' log pressure array and form array
;  
  newNLevs = 54
  newLevs = FINDGEN(newNLevs)*0.5 - 21.5
;
;  Get the index of the minimum and maximim vertical levels to use in original WACCM data  
;  
  levMin = slice.levmin
  iLevMin = IXFIND_NEAREST(levs,levMin)
  levMax = slice.levmax
  iLevMax = IXFIND_NEAREST(levs,levMax)
  IF iLevMin GT 0 THEN iLevMin = iLevMin - 1
  IF iLevMax LT nLevs-1 THEN iLevMax = iLevMax + 1
;
;  Get number of dimensions in input data and find vertical level dimension if more than one dimension
; 
  nDatDims = SIZE(data,/N_DIMENSIONS)
  
  IF nDatDims GT 1 THEN BEGIN
  
    varDims = SIZE(data,/DIMENSIONS)
    levDim = WHERE(varDims eq nLevs)
    IF levDim LT 0 THEN nLevs = nLevs + 1
    levDim = WHERE(varDims eq nLevs)
    
  ENDIF ELSE IF nDatDims EQ 1 THEN BEGIN
  
    varDims = N_ELEMENTS(data)
    levDim = 0
  
  ENDIF  
;
;  Check to make sure vertical level dimension found in input data
;  
  IF levDim LT 0 THEN BEGIN
 
    PRINT, 'INTERPWDATA: Could not find lev dimension in data '
    RETURN

  ENDIF  
;  
;  Only interpolate levels between slice.levmin and slice levmax for all plot types except profiles
;
;  IF slice.plottype EQ 'profile' OR slice.plottype EQ 'meridional' OR slice.plottype EQ 'zonal' THEN BEGIN
;  
;    iMin = 0
;    iMax = nLevs - 1
;  
;  ENDIF ELSE BEGIN
;
;  Get the corresponding minimum and maximum levels in new vertical level array using original vertical min/max
;
   indexNewLevMin = WHERE(newLevs LT levmin)
   indexNewLevMax = WHERE(newLevs GT levmax)
   
   IF indexNewLevMax[0] EQ -1 THEN indexNewLevMax = newNLevs - 1
  
   iNewLevMin = 0
   iNewLevMax = newNLevs - 1
   nINLMin = N_ELEMENTS(indexNewLevMin)
;
;  New vertical min/max within original min/max
;
   IF indexNewLevMin[nINLMin-1] GT iNewLevMin AND indexNewLevMax[0] LT iNewLevMax AND indexNewLevMax[0] GE 0 THEN BEGIN
  
     iNewLevMin = indexNewLevMin[nINLMin-1]
     iNewLevMax = indexNewLevMax[0]
;
;  New vertical min above original vertical min
;   
   ENDIF ELSE IF indexNewLevMin[nINLMin-1] GT iNewLevMin AND indexNewLevMax[0] GE iNewLevMax THEN BEGIN

     iNewLevMin = indexNewLevMin[nINLMin-1]
;
;  New vertical max above original vertical max
;      
   ENDIF ELSE IF indexNewLevMin[nINLMin-1] LE iNewLevMin AND indexNewLevMax[0] LT iNewLevMax AND indexNewLevMax[0] GE 0 THEN BEGIN
  
     iNewLevMax = indexNewLevMax[0]
   
   ENDIF	 
;
;  Form subsetted 'standard' vertical level array
;
   tempLevs = newLevs[iNewLevMin:iNewLevMax]
  
   newLevs = tempLevs
   newNLevs = N_ELEMENTS(newLevs)

;  ENDELSE
;
;   Check the number of dimensions in the data field to handle as 1-D or 4-D.
;
  IF nDatDims EQ 1 THEN BEGIN
  
    IF levDim EQ 0 THEN BEGIN
    
      newData = FLTARR(newNLevs)
   
      iData = data[iLevMin:iLevMax]
      levsIn = levs[iLevMin:iLevMax]

      indexGood = WHERE(iData NE FLOAT(slice.missing_value))
      iDataG = iData[indexGood]
      levsInG = levsIn[indexGood]
	     
      iNewLevGoodH = newNLevs - 1
      iNewLevGoodL = 0
      IF indexGood[0] GE 0 THEN BEGIN
      
        iLevGoodHigh = indexGood[N_ELEMENTS(indexGood)-1]
        iLevGoodLow = indexGood[0]
	iNewLevGoodHAll = WHERE(newLevs LT levsIn[iLevGoodHigh])
	iNewLevGoodLAll = WHERE(newLevs GT levsIn[iLevGoodLow])
	IF iNewLevGoodHAll[0] GE 0 THEN iNewLevGoodH = iNewLevGoodHAll[N_ELEMENTS(iNewLevGoodHAll)-1]
	IF iNewLevGoodLAll[0] GE 0 THEN iNewLevGoodL = iNewLevGoodLAll[0]
	  	  
      ENDIF 
      
      loglin = 1
      IF  isdensity(slice.field.name) GT 0 THEN loglin = 0

      vfnd, levsInG, iDataG, newLevs, oData, cut=0, linear=loglin
	
      newData = oData

      IF iNewLevGoodH GT 0 AND iNewLevGoodH LT newNLevs-1 THEN newData[iNewLevGoodH:newNLevs-1] = slice.missing_value
      IF iNewLevGoodL GT 1 THEN newData[0:iNewLevGoodL-1] = slice.missing_value

    ENDIF ELSE BEGIN
    
      PRINT, 'INTERPWDATA: Level data not the dimension of data as expected'
      RETURN
      
    ENDELSE 
      

  ENDIF ELSE IF nDatDims EQ 2 THEN BEGIN
  
    IF levDim EQ 1 THEN BEGIN
    
      nDim1 = varDims[0]
      
      newData = FLTARR(nDim1,newNLevs)
      levsIn = levs[iLevMin:iLevMax]

      FOR iDim1=0,nDim1-1 DO BEGIN
      
        iData = TRANSPOSE(data[iDim1,iLevMin:iLevMax])
      
        indexGood = WHERE(iData NE FLOAT(slice.missing_value))
        iDataG = iData[indexGood]
        levsInG = levsIn[indexGood] 
	     
        iMinLevGoodH = newNLevs - 1
        iMinLevGoodL = 0
        IF indexGood[0] GE 0 THEN BEGIN
      
          iLevGoodHigh = indexGood[N_ELEMENTS(indexGood)-1]
	  iLevGoodLow = indexGood[0]
	  iNewLevGoodHAll = WHERE(newLevs LT levsIn[iLevGoodHigh])
	  iNewLevGoodLAll = WHERE(newLevs GT levsIn[iLevGoodLow])
	  IF iNewLevGoodHAll[0] GE 0 THEN iNewLevGoodH = iNewLevGoodHAll[N_ELEMENTS(iNewLevGoodHAll)-1]
	  IF iNewLevGoodLAll[0] GE 0 THEN iNewLevGoodL = iNewLevGoodLAll[0]
	
        ENDIF 
	
	loglin = 1
        IF  isdensity(slice.field.name) GT 0 THEN loglin = 0
	
        vfnd, levsInG, iDataG, newLevs, oData, cut=1, linear=loglin
	
        newData[iDim1,*] = oData

        IF iNewLevGoodH GT 0 AND iNewLevGoodH LT newNLevs-1 THEN newData[iDim1,iNewLevGoodH:newNLevs-1] = slice.missing_value
        IF iNewLevGoodL GT 1 THEN newData[iDim1,0:iNewLevGoodL-1] = slice.missing_value
	
      ENDFOR
      
    ENDIF ELSE BEGIN
    
      PRINT, 'INTERPWDATA: Level data not in second dimension of data as expected'
      RETURN
      
    ENDELSE        
;
;  4-D data with veritical levels assumed as the 3rd dimension
;  
   ENDIF ELSE IF nDatDims EQ 4 THEN BEGIN
  
    IF levDim EQ 2 THEN BEGIN
    
      nDim1 = varDims[0]
      nDim2 = varDims[1]
      nDim4 = varDims[3]
      
      newData = FLTARR(nDim1,nDim2,newNLevs,nDim4)
      
      FOR iDim1=0,nDim1-1 DO BEGIN
        FOR iDim2=0,nDim2-1 DO BEGIN
          FOR iDim4=0,nDim4-1 DO BEGIN
      
            iData = TRANSPOSE(data[iDim1,iDim2,iMin:iMax,iDim4])
      
            indexGood = WHERE(iData NE FLOAT(slice.missing_value))
            iDataG = iData[indexGood]
            levsInG = levsIn[indexGood]      
      
            iNewLevGoodH = newNLevs - 1
            iNewLevGoodL = 0
            IF indexGood[0] GE 0 THEN BEGIN
      
              iLevGoodHigh = indexGood[N_ELEMENTS(indexGood)-1]
	      iLevGoodLow = indexGood[0]
	      iNewLevGoodHAll = WHERE(newLevs LT levsIn[iLevGoodHigh])
	      iNewLevGoodLAll = WHERE(newLevs GT levsIn[iLevGoodLow])
	      IF iNewLevGoodHAll[0] GE 0 THEN iNewLevGoodH = iNewLevGoodHAll[N_ELEMENTS(iNewLevGoodHAll)-1]
	      IF iNewLevGoodLAll[0] GE 0 THEN iNewLevGoodL = iNewLevGoodLAll[0]

            ENDIF 

	    loglin = 1
            IF  isdensity(slice.field.name) GT 0 THEN loglin = 0
	
            vfnd, levsInG, iDataG, newLevs, oData, cut=1, linear=loglin
	
            newData[iDim1,iDim2,*,iDim4] = oData
            IF iNewLevGoodL GE 0 AND iNewLevGoodL LT newNLevs-1 THEN newData[iDim1,iDim2,iNewLevGoodL:newNLevs-1,iDim4] = slice.missing_value
            IF iNewLevGoodH GT 0 AND iNewLevGoodH LT newNLevs-1 THEN newData[iDim1,iDim2,iNewLevGoodH:newNLevs-1,iDim4] = slice.missing_value
	
	  ENDFOR
	ENDFOR	
      ENDFOR
    
    ENDIF ELSE BEGIN
    
      PRINT, 'INTERPWDATA: Level data not in second dimension of data as expected'
      RETURN
      
    ENDELSE        
;
;  Check for common errors
;  
 ENDIF ELSE IF nDatDims EQ -1 THEN BEGIN

    PRINT, 'INTERPWDATA: Did not find level dimension in data'
    RETURN
  
 ENDIF ELSE BEGIN
  
    PRINT, 'INTERPWDATA: Problem determining input data dimensions '
    RETURN
    
  ENDELSE
;
;  Update data and levels and field
;
  slice.data = PTR_NEW(newData)
  slice.levs = PTR_NEW(newLevs)
  fminmax,*slice.data,slice.fmin,slice.fmax,slice.missing_value
  
;  print, 'interpwdata: calculated min/max of data to ', slice.fmin, slice.fmax

  field = slice.field   
  
END
