;
pro labpol,position,hem,chsize,fixtop,mag=mag
;
; Label polar stereographic plot with local time:
; (tried doing this in polar coords. Circle is fine, but cannot
;  do the tic marks, so doing all in cartesian)
;
dgrid = 30.
if fixtop eq 'SLT' then mdlab = 2 else mdlab = 30
;
; Draw circle around map:
;
xll = position(0) & yll = position(1)
xur = position(2) & yur = position(3)
cx = xll + (xur-xll)*.5
cy = yll + (yur-yll)*.5
r = xur-cx
x = fltarr(361) & y = fltarr(361)
for i=0,360 do begin
  x(i) = cx + r*cos(float(i)*!dtor)
  y(i) = cy + r*sin(float(i)*!dtor)  
endfor
pos = position
plot,x,y,xstyle=5,ystyle=5,/norm,/noerase,position=pos
;
; Put cross in center:
;
oplot,[cx],[cy],psym=1,symsize=2.0
;
if hem eq 'S' then begin   ; South
  if fixtop eq 'SLT' then begin
    mlab = 18
    sltlab = string(format="(I2)",mlab)
  endif else begin
    mlab = 90
    sltlab = string(format="(I2)",mlab)
  endelse
endif else begin           ; North
  if fixtop eq 'SLT' then begin
    mlab = 6
    sltlab = string(format="(I1)",mlab)
  endif else begin
    mlab = -90
    sltlab = string(format="(I3)",mlab)
  endelse
endelse
ng = 360./dgrid
theta = 0.
x1 = cx + r*cos(theta)
y1 = cy + r*sin(theta)
tlenmjr = .025*(xur-xll)
tlenmnr = 0.5*tlenmjr
minr = 2
for i=1,ng do begin
  x2 = cx + (r-tlenmjr)*cos(theta)
  y2 = cy + (r-tlenmjr)*sin(theta)
  oplot,[x1,x2],[y1,y2]
  fac = fltarr(12)
;
; N slt: 6    8    10   12   14   16   18   20   22   0    2    4
; fac = [1.5, 1.5, 1.6, 1.4, 2.0, 2.1, 2.4, 2.7, 3.0, 3.0, 3.0, 2.5]
  fac = [1.2, 1.0, 1.1, 0.9, 1.5, 1.7, 2.0, 2.2, 2.5, 2.1, 2.3, 2.0]
;
  xx = cx + (r+fac(i-1)*tlenmjr)*cos(theta)
  yy = cy + (r+fac(i-1)*tlenmjr)*sin(theta)
  align = .5
; print,'labpol: i=',i,' sltlab=',sltlab,' xx=',xx,' yy=',yy
  xyouts,xx,yy,sltlab,alignment=align,charsize=chsize,/data
  for ii=1,minr-1 do begin
    theta = theta + dgrid/float(minr) * !dtor
    x1 = cx + r*cos(theta)
    y1 = cy + r*sin(theta)
    x2 = cx + (r-tlenmnr)*cos(theta)
    y2 = cy + (r-tlenmnr)*sin(theta)
    oplot,[x1,x2],[y1,y2]
  endfor
  theta = theta + dgrid/float(minr) * !dtor

  if hem eq 'S' then begin         ; South
    if fixtop eq 'SLT' then begin
      if (mlab-mdlab lt 0) then mlab = mlab-mdlab+26
      if (mlab-mdlab ge 0) then mlab = (mlab-mdlab) mod 24
    endif else begin ; fixtop eq 'lon'
      mlab = mlab-30
      if (mlab ge 180) then mlab = mlab-360
      if (mlab lt -180) then mlab = mlab+360
    endelse
  endif else begin                 ; North
    if fixtop eq 'SLT' then begin
      mlab = (mlab+mdlab) mod 24
    endif else begin ; fixtop eq 'lon'
      mlab = mlab+30
      if (mlab ge 180) then mlab = mlab-360
      if (mlab lt -180) then mlab = mlab+360
    endelse
  endelse
  nchar = strlen(strcompress(string(mlab),/remove_all))
  format = '(I'+strcompress(string(nchar))+')'
  sltlab = string(format=format,mlab)

  x1 = cx + r*cos(theta)
  y1 = cy + r*sin(theta)
endfor
;xyouts,xll+.5*(xur-xll),yll-.10,'LOCAL TIME',align=.5,/norm,$
;  charsize=chsize
 if fixtop eq 'SLT' then begin
   title='SOLAR LOCAL TIME (HRS)'
   if keyword_set(mag) then title='MAGNETIC LOCAL TIME (HRS)'
 endif else begin
   title='GEOGRAPHIC LONGITUDE (DEG)'
   if keyword_set(mag) then title='MAGNETIC LONGITUDE (DEG)'
 endelse
 xyouts,xll+.5*(xur-xll),yll-.07,title,align=.5,/norm,$
   charsize=chsize
return
end
